// TutorialSystem.h: interface for the CTutorialSystem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TUTORIALSYSTEM_H__78E3D7AE_3E51_4771_8F9B_2C9CA3BB537D__INCLUDED_)
#define AFX_TUTORIALSYSTEM_H__78E3D7AE_3E51_4771_8F9B_2C9CA3BB537D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#define	TUTORIAL_LESSON_COUNT				10

enum {L1_1 = 1, L1_2, L1_3,L1_4,L1_5,L1_6,L1_7};
enum {L2_1 = 1, L2_2,L2_3};
enum {L3_1 = 1, L3_2};
enum {L4_1 = 1};
enum {L5_1 = 1, L5_2};
enum {L6_1 = 1};
enum {L7_1 = 1};
enum {L8_1 = 1};
enum {L9_1 = 1};
enum {L10_1 = 1, L10_2, L10_3,L10_4};

// 2007-07-05 by dgwoo
//   Ʒ  Ѵ.
//  غ ܰ - Ʃ丮   ۷ .
//   ܰ -   ϸ ǥ ޼ϱ  .
//   ܰ -  Ǵ   ָ ܰ Ѿ .(, )
//   ܰ - ۷Ͱ  ϴ ܰ.
//   ܰ - ܰ Ѿ ܰ
enum{TUTORIAL_STATE_READY = 1, 
		TUTORIAL_STATE_MOTION,
		TUTORIAL_STATE_SUCCESS,
		TUTORIAL_STATE_OPERATOR,
		TUTORIAL_STATE_NEXT,
		TUTORIAL_STATE_FAIL
};
//--------------------------------------------------------------------------//


struct Lesson2State
{
	float	fSKey;
	BOOL	nBKey;
};

struct Lesson3State
{
	BOOL	bLRolling;
	BOOL	bRRolling;
	BOOL	bLMove;
	BOOL	bRMove;
};

struct Lesson7State
{
	BOOL	bFire;
};

struct Lesson8State
{
	DWORD	nCount;
};

struct Lesson9State
{
	int		nDeadMonster;
};

struct TutorialGateInfo
{
	D3DXVECTOR3		vPos;
	BOOL			bShow;
	CObjectChild*	pNode;
};

class CINFImage;
class CGameData;
class CTutorialSystem  
{
public:
	CTutorialSystem();
	virtual ~CTutorialSystem();

	void		Tick(float fElapsedTime);
	void		TickSystemWindow(float fElapsedTime);
	void		Lesson0(float fElapsedTime);
	void		Lesson1(float fElapsedTime);
	void		Lesson1_1_5(float fElapsedTime);
	void		Lesson1_6(float fElapsedTime);
	void		Lesson1_7(float fElapsedTime);

	void		Lesson2(float fElapsedTime);
	void		Lesson2_1(float fElapsedTime);
	void		Lesson2_2(float fElapsedTime);
	void		Lesson2_3(float fElapsedTime);

	void		Lesson3(float fElapsedTime);
	void		Lesson3_1(float fElapsedTime);
	void		Lesson3_2(float fElapsedTime);
	void		Lesson4(float fElapsedTime);
	void		Lesson5(float fElapsedTime);
	void		Lesson5_1(float fElapsedTime);
	void		Lesson5_2(float fElapsedTime);
	void		Lesson7(float fElapsedTime);
	void		Lesson6(float fElapsedTime);
	void		Lesson8(float fElapsedTime);
	void		Lesson9(float fElapsedTime);
	void		Lesson10(float fElapsedTime);


	void		SetShuttleEffectPos(float fElapsedtime);
	void		InitTutorialSystem();

	void		StartTutorial();
	void		EndTutorial();

	void		Render();
	void		RenderInterface();				//  ϴܿ Ű  ư.
	void		RenderSystemWindow();
	void		RenderLesson0();				// ȭ.
	void		RenderLesson1();
	void		RenderLesson2();

	void		RenderLesson3();
	void		RenderLesson4();
	void		RenderLesson5();
	void		RenderLesson6();
	void		RenderLesson7();
	void		RenderLesson8();
	void		RenderLesson9();
	void		RenderLesson10();

	DWORD		ChangeLesson(DWORD dwLesson,DWORD dwLessonState = 1);
	void		NextState();
	D3DXVECTOR3	GetGatePos();
	CObjectChild * GetActiveGate();
	void		SetCompleteLesson(INT nTutorialNum , BYTE bComplete = 1);
	// SystemWindow ó.
	void		ChangeSystemWindow();
	void		SystemPlayingButton();
	void		SystemAgainButton();
	void		SystemMainButton();
	void		SystemEndButton();

	void		StartButtonMainChart();					// â  ư ó.
	void		ChapterStateOperator();

	void		RenderETC();
	
	HRESULT		InitDeviceObjects();
	HRESULT		DeleteDeviceObjects();
	HRESULT		RestoreDeviceObjects();
	HRESULT		InvalidateDeviceObjects();
	int			WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam);
	int			WndProcChart(UINT uMsg,WPARAM wParam,LPARAM lParam);

	BOOL		IsTutorialMode() { return m_bTutorialMode; }
	void		SetTutorialMode(BOOL bTutorial) { m_bTutorialMode = bTutorial; }

	BOOL		IsUseShuttleTick() { return m_bUseShuttleTick; }
	void		SetUseShuttleTick(BOOL bUseShuttleTick) { m_bUseShuttleTick = bUseShuttleTick; }

	BOOL		IsUseCameraTick() { return m_bUseCameraTick; }
	void		SetUseCameraTick(BOOL bUseCameraTick) { m_bUseCameraTick = bUseCameraTick; }

	// GameData  Լ
	void		SetResourceFile(char* szFileName);
	DataHeader* FindResource(char* szRcName);
	void		SetImgBoxCenterPos(CINFImage * pImg);
	void		SetImgBoxCenterGoalPos(CINFImage * pImg);


	void		ResetLessonPosition(float fElapsedTime);
	DWORD		GetLesson() { return m_dwLesson; }
	DWORD		GetChapter() {return m_dwChapter; }
	DWORD		GetChapterState() { return m_dwChapterState; }

	void		AddTutorialGateInfo(CObjectChild* pNode);
	BOOL		IsEnableTutorialGate(D3DXVECTOR3 vPos);
	void		ClearTutorialGateInfo();
	void		MakeDisableAllTutorialGate();
	void		MakeEnableTutorialGate(D3DXVECTOR3 vPos);
	void		MakeDisableTutorialGate(D3DXVECTOR3 vPos);
	
	void		DisableTutorialGateFarDistance();

	int			CutOffFirstNumber(int& nNum,int nMaxNum);

	BOOL		IsRenderTargetCenter() { return m_bRenderTargetCenter; }

	BOOL		IsRenderInterface() { return m_bRenderInterface; }
	BOOL		IsRenderSpaceBar() { return m_bRenderSpaceBar; }

	DWORD		GetMessageType() { return m_dwMessageType; }

	void		MonsterDeadNotify(ClientIndex_t MonsterIndex);
	void		ClearTutorialMonster();

	void		SetShuttleOrderTarget();
	BOOL		GetNeedOrderTarget() { return m_bNeedOrderTarget; }
	void		SetNeedOrderTarget(BOOL bNeedOrderTarget) { m_bNeedOrderTarget = bNeedOrderTarget; }
	void		SetOrderTargetPos(int x, int y);
	BOOL		CheckCancel();
	BOOL		GetShowHelpDesk() { return m_bShowHelpDesk; }
	void		SetShowHelpDesk(BOOL bFlag) { m_bShowHelpDesk = bFlag; }
	void		SetOrderTargetPosTo2D(D3DXVECTOR3 vPos);

	void		SetTutorialEd(BOOL bTurotialEd) { m_bTutorialEd = bTurotialEd; }
	BOOL		GetTutorialEd() { return m_bTutorialEd; }

	void		SetMonsterTick();
	void		SetMonsterPosition();
	CMonsterData *	GetNearTutorialMonster();

	void		TutorialLessonSkip(float fElapsedTime);
	D3DXVECTOR3 CheckMob2Postion(D3DXVECTOR3 *vDir, D3DXVECTOR3 *vZigZag);

	// 2007-07-04 by bhsohn ۷ ߰
	//  é Ʈ ´. 
	void		GetOpTxt(char* pTxt, char* pNarration);

	// 2007-07-23 by bhsohn ۷ ߰۾
	void		SetFirstUserIntoFreeSka(BOOL bTake);
	BOOL		GetFirstUserIntoFreeSka();
	void		ChangeChapterReady();
	BOOL		IsSystemWin()			{return m_bSystemWin;}		// ý ޴ ִ°?
private:
	// 2007-07-04 by bhsohn ۷ ߰	
	void		UpdateOpInfo();

	BOOL		IsCompleteAllTutorial();

	void		GetLession0Txt(DWORD dwChapter, char* pTxt, char* pNarration);
	void		GetLession1Txt(DWORD dwChapter, char* pTxt, char* pNarration);
	void		GetLession2Txt(DWORD dwChapter, char* pTxt, char* pNarration);
	void		GetLession3Txt(DWORD dwChapter, char* pTxt, char* pNarration);
	void		GetLession4Txt(DWORD dwChapter, char* pTxt, char* pNarration);
	void		GetLession5Txt(DWORD dwChapter, char* pTxt, char* pNarration);
	void		GetLession6Txt(DWORD dwChapter, char* pTxt, char* pNarration);
	void		GetLession7Txt(DWORD dwChapter, char* pTxt, char* pNarration);	
	void		GetLession8Txt(DWORD dwChapter, char* pTxt, char* pNarration);	
	void		GetLession9Txt(DWORD dwChapter, char* pTxt, char* pNarration);	
	void		GetLession10Txt(DWORD dwChapter, char* pTxt, char* pNarration);	
	
	void		RenderHelper();	
	void		TickHelper(float fElapsedTime);
	void		SetHelper();


private:
	CGameData*		m_pGameData;
	BOOL			m_bTutorialMode;	// Ʃ丮  TRUE
	BOOL			m_bUseShuttleTick;	// Ʋ ƽ ʿϸ TRUE
	BOOL			m_bUseCameraTick;	// ī޶ ƽ ʿϸ TRUE
	DWORD			m_dwLesson;			//  
	DWORD			m_dwChapter;		// .
	DWORD			m_dwChapterState;	// ش  
	float			m_fStateTime;		// ð(ð üũ 뵵 )
	float			m_fRemainTime;		
	BOOL			m_bStateOk;			//  
	DWORD			m_dwMessageType;	// ޽ Ÿ
	POINT			m_MousePt;


	BOOL			m_bNeedOrderTarget;		//    Ÿ ʿѰ..

	// 2007-07-03 by dgwoo Ʃ丮 .
	
	CINFImage *		m_pImgMain;
	CINFImage *		m_pImgChart;
	CINFImage *		m_pImgCari;
	CINFImage *		m_pImgComplete;
	CINFImage *		m_pImgSelect;
	CINFImage *		m_pImgStartB[BUTTON_STATE_NUMBER];
	CINFImage *		m_pImgEndB[BUTTON_STATE_NUMBER];
	CINFImage *		m_pImgLesson1[L1_7];
	CINFImage *		m_pImgLesson1Goal[L1_7];
	CINFImage *		m_pImgLesson2[L2_3];
	CINFImage *		m_pImgLesson2Goal[L2_3];
	CINFImage *		m_pImgLesson3[L3_2];
	CINFImage *		m_pImgLesson3Goal[L3_2];
	CINFImage *		m_pImgLesson4;
	CINFImage *		m_pImgLesson4Goal;
	CINFImage *		m_pImgLesson5[L5_2];
	CINFImage *		m_pImgLesson5Goal[L5_2];
	CINFImage *		m_pImgLesson6;
	CINFImage *		m_pImgLesson6Goal;
	CINFImage *		m_pImgLesson7;
	CINFImage *		m_pImgLesson7Goal;
	CINFImage *		m_pImgLesson8;
	CINFImage *		m_pImgLesson8Goal;
	CINFImage *		m_pImgLesson9;
	CINFImage *		m_pImgLesson9Goal;
	CINFImage *		m_pImgLesson10[L10_4];
	CINFImage *		m_pImgLesson10Goal[L10_4];

	// Interface ̹ Ű  콺.
	CINFImage *		m_pImgInterBG;
	CINFImage *		m_pImgInterMouseL;
	CINFImage *		m_pImgInterMouseR;
	CINFImage *		m_pImgInterMouse;
	CINFImage *		m_pImgInterSpace;
	CINFImage *		m_pImgInterShift;
	CINFImage *		m_pImgInterKey;

	BOOL			m_bInterMouseL;
	BOOL			m_bInterMouseR;
	BOOL			m_bInterMouse;
	BOOL			m_bInterSpace;
	BOOL			m_bInterShift;
	BOOL			m_bInterKeyW;
	BOOL			m_bInterKeyA;
	BOOL			m_bInterKeyS;
	BOOL			m_bInterKeyD;
	BOOL			m_bInterKeyC;
	BOOL			m_bInterKeyB;
	BOOL			m_bLButtonState;	// TRUE : 
	BOOL			m_bRButtonState;	// TRUE : 

	///////////////////////////////////////////////////////////




	float			m_fMainX;								// Ʈ â ġ.
	float			m_fMainY;
	BOOL			m_bLessonComplete[TUTORIAL_LESSON_COUNT];

	int				m_nStartB;
	int				m_nEndB;

	int				m_nSelect;

	BOOL			m_bSystemWin;							// ýâ Ȱȭ .
	float			m_fSystemWinX;							// ýâ ġ.
	float			m_fSystemWinY;
	CINFImage *		m_pImgSysBG;							//  Ʋ.
	CINFImage *		m_pImgSysPlayB[BUTTON_STATE_NUMBER];	//  .
	CINFImage *		m_pImgSysAgainB[BUTTON_STATE_NUMBER];	// ٽ .
	CINFImage *		m_pImgSysMainB[BUTTON_STATE_NUMBER];	//  ȭ.
	CINFImage *		m_pImgSysEndB[BUTTON_STATE_NUMBER];		//  ư.

	int				m_nSysPlayB;
	int				m_nSysAgainB;
	int				m_nSysMainB;
	int				m_nSysEndB;

	BOOL			m_bStatePlus;
	D3DXVECTOR3		m_vecGatePos;
	int				m_nImagePosition_X;
	int				m_nImagePosition_Y;
	int				m_nImageGoalPos_X;
	int				m_nImageGoalPos_Y;
	int				m_nImageInterPos_X;
	int				m_nImageInterPos_Y;

	CINFImage *		m_pImgETCBooster;
	CINFImage *		m_pImgETCBull1;						// ź 1.
	CINFImage *		m_pImgETCBull2;						// ź 2.
	CINFImage *		m_pImgETCHeat;
	CINFImage *		m_pImgETCReAtt;
	CINFImage *		m_pImgETCSP;
	CINFImage *		m_pImgETCWeapone1;					// ⺻ .
	CINFImage *		m_pImgETCWeapone2;					//  .

	CINFImage *		m_pImgHelpTex;						//  Ʒο  .

	int				m_nOrderTargetPos_X;
	int				m_nOrderTargetPos_Y;

	BOOL			m_bChapSuccess;						// ̰ ߴ°?
	BOOL			m_bTutorialFirst;					// Ʃ丮 ѹ óؾϴ .

	INT				m_nHelpTexPosX;						//   Ʒ Xġ.
	BOOL			m_bHelperRender;					//   ؾϴ°?
	float			m_fHelperTime;						// ݱ  ð.
	//--------------------------------------------------------------------------//
	


	int				m_nSkipBoxPosition_X;
	int				m_nSkipBoxPosition_Y;
	int				m_nStartButtonPos_X;
	int				m_nStartButtonPos_Y;
	int				m_nEndButtonPos_X;
	int				m_nEndButtonPos_Y;
	int				m_nCenterButtonPos_X;
	int				m_nCenterButtonPos_Y;
	int				m_nInputButtonPos_X;
	int				m_nInputButtonPos_Y;
	int				m_nInputMousePos_X;
	int				m_nInputMousePos_Y;


	BOOL			m_bPushStartButton;
	BOOL			m_bPushCenterButton;
	BOOL			m_bPushEndButton;
	BOOL			m_bTargetReady;

	BOOL			m_bETC;
	DWORD			m_dwETCState;

	BOOL			m_bRenderTargetCenter;

	BOOL			m_bRenderSpaceBar;
	BOOL			m_bRenderInterface;

	BOOL			m_bShowHelpDesk;

	CINFImage*		m_pSkipBoxImage[10];
	CINFImage*		m_pStartButtonImage[3];
	CINFImage*		m_pCenterButtonImage[3];
	CINFImage*		m_pEndButtonImage[3];
	CINFImage*		m_pImgLessonWelcome;
	CINFImage*		m_pImgLessonSucceed;
	CINFImage*		m_pImgLessonFailed;
	CINFImage*		m_pCurrentImage;
	CINFImage*		m_pCurrentGoalImage;
	CINFImage*		m_pCButtonImage[2];
	CINFImage*		m_pWButtonImage[2];
	CINFImage*		m_pSButtonImage[2];
	CINFImage*		m_pAButtonImage[2];
	CINFImage*		m_pDButtonImage[2];
	CINFImage*		m_pBButtonImage[2];
	CINFImage*		m_pSpaceBarImage[2];
	CINFImage*		m_pMouseImage[4];
	CINFImage*		m_pRemainTime[11];
	
	vector<TutorialGateInfo>	m_vecTutorialGateInfo;

	BOOL			m_bTutorialEd;			// 2005-10-17 by ispark Ʃ丮  ΰ? (ŵ )

	D3DXVECTOR3		m_vecMob1;

	// 2007-07-23 by bhsohn ۷ ߰۾
	BOOL			m_bFristIntoFreeSka;

public:
	Lesson2State	m_Lesson2State;
	Lesson3State	m_Lesson3State;
	Lesson7State	m_Lesson7State;
	Lesson8State	m_Lesson8State;
	Lesson9State	m_Lesson9State;
	

};

#endif // !defined(AFX_TUTORIALSYSTEM_H__78E3D7AE_3E51_4771_8F9B_2C9CA3BB537D__INCLUDED_)
