// INFCityWarp.cpp: implementation of the CINFCityWarp class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "INFCityWarp.h"
#include "AtumApplication.h"
#include "INFImage.h"
#include "D3DHanFont.h"
#include "GameDataLast.h"
#include "FieldWinSocket.h"
#include "INFCityBase.h"
#include "INFScrollBar.h"
#include "Interface.h"
#include "ShuttleChild.h"
#include "CharacterChild.h"				// 2005-07-21 by ispark
#include "Cinema.h"
#include "AtumSound.h"
#include "INFGameMain.h"
#include "Chat.h"
#include "RangeTime.h"
#include "INFInven.h"
#include "StoreData.h"
#include "dxutil.h"
#include "QuestData.h"
#include "AtumDatabase.h"				// 2010-08-10 by dgwoo ׸ ý

#define CITY_WARP_START_X					CITY_BASE_NPC_BOX_START_X
#define CITY_WARP_START_Y					(CITY_BASE_NPC_BOX_START_Y-CITY_BASE_WARP_SIZE_Y)

#define CITY_WARP_BACK_START_X				(CITY_WARP_START_X+12)
#define CITY_WARP_BACK_START_Y				(CITY_WARP_START_Y+27)
#define CITY_WARP_TITLE_START_X				(CITY_WARP_START_X+9)
#define CITY_WARP_TITLE_START_Y				(CITY_WARP_START_Y+6)
#define CITY_WARP_LIST_START_X				(CITY_WARP_START_X+24)
#define CITY_WARP_LIST_START_Y				(CITY_WARP_START_Y+53)
#define CITY_WARP_CASH_START_X				(CITY_WARP_START_X+55)
#define CITY_WARP_CASH_START_Y				(CITY_WARP_START_Y+162)
#define CITY_WARP_LIST_INTERVAL				17

#define CITY_WARP_BUTTON_MOVE_START_X		(CITY_WARP_START_X+132)
#define CITY_WARP_BUTTON_MOVE_START_Y		(CITY_WARP_START_Y+161)
#define CITY_WARP_BUTTON_CANCEL_START_X		(CITY_WARP_START_X+172)
#define CITY_WARP_BUTTON_CANCEL_START_Y		(CITY_WARP_START_Y+161)
#define CITY_WARP_BUTTON_SIZE_X				38
#define CITY_WARP_BUTTON_SIZE_Y				17
#define CITY_WARP_LINE_SIZE_X				169

#define SCROLL_START_X						(CITY_WARP_START_X+202)
#define SCROLL_START_Y						(CITY_WARP_START_Y+52)
#define SCROLL_LINE_LENGTH					103

#define CITY_WARP_TEX_X						CITY_WARP_START_X + 163
#define CITY_WARP_TEX_Y						CITY_WARP_START_Y + 5
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CINFCityWarp::CINFCityWarp(CAtumNode* pParent)
{
	m_pParent = pParent;

	m_pImgBack = NULL;
	m_pImgTitle = NULL;
	for(int i=0;i<CITY_WARP_BUTTON_NUMBER;i++)
	{
		m_pButtonMove[i] = NULL;
		m_pButtonCancel[i] = NULL;
	}
	m_pImgHightLight = NULL;
	m_bRestored = FALSE;
	memset(m_pFontWarpList, 0x00, sizeof(DWORD)*CITY_WARP_LIST_NUMBER);
	memset(m_pFontWarpPrice, 0x00, sizeof(DWORD)*CITY_WARP_LIST_NUMBER);
	m_pScroll = NULL;
	Reset();
	m_pInfluenceTex = NULL;
}

CINFCityWarp::~CINFCityWarp()
{
	SAFE_DELETE(m_pImgBack);
	SAFE_DELETE(m_pImgTitle);
	int i;
	for(i=0;i<CITY_WARP_BUTTON_NUMBER;i++)
	{
		SAFE_DELETE(m_pButtonMove[i]);
		SAFE_DELETE(m_pButtonCancel[i]);
	}
	SAFE_DELETE(m_pImgHightLight);

	for(i=0;i<CITY_WARP_LIST_NUMBER;i++)
	{
		SAFE_DELETE(m_pFontWarpList[i]);
		SAFE_DELETE(m_pFontWarpPrice[i]);
	}

	CVectorWarpTargetInfoIterator it = m_vecWarpTargetInfo.begin();
	while(it != m_vecWarpTargetInfo.end())
	{
		SAFE_DELETE(*it);
		it++;
	}
	m_vecWarpTargetInfo.clear();
	SAFE_DELETE(m_pScroll);
	SAFE_DELETE(m_pInfluenceTex);
}

void CINFCityWarp::Reset()
{
//	m_nCurrentSelectWarpIndex = -1;
	m_nButtonState[0] = BUTTON_STATE_NORMAL;
	m_nButtonState[1] = BUTTON_STATE_NORMAL;
	memset(m_szWarpList, 0x00, CITY_WARP_LIST_NUMBER*CITY_WARP_LIST_STRING_LENGTH);

//	m_nCurrentWarpListScroll = 0;
//	m_bWarpListScrollLock = FALSE;	
	m_nWarpListLineNumber = 0;	

	if(m_vecWarpTargetInfo.size()>0)
	{
		CVectorWarpTargetInfoIterator it = m_vecWarpTargetInfo.begin();
		while(it != m_vecWarpTargetInfo.end())
		{
			SAFE_DELETE(*it);
			it++;
		}
		m_vecWarpTargetInfo.clear();
	}
	m_nMapIndex = 0;	
	m_nTargetIndex = 0;	

}

void CINFCityWarp::AddWarpTargetInfoList(WARP_TARGET_MAP_INFO_4_EXCHANGE* pInfo)
{
	// 2006-09-29 by ispark,    ִ  üũ
	int nQuestIndex = GetQuestIndexForWarp(pInfo->MapIndex);
	if(nQuestIndex != 0 && !g_pQuestData->IsQuestCompleted(nQuestIndex))
	{
		// Ϸ ȉ Ʈ
		return;
	}
	// 2007-09-18 by dgwoo, ٸ    ʴ´.
	if(!IsNotInfluenceSameMap(g_pShuttleChild->m_myShuttleInfo.InfluenceType, pInfo->MapIndex))
	{
		return;
	}

	// 2010-08-10 by dgwoo ׸ ý
	BURNING_MAP_INFO* pBurning = g_pDatabase->GetPtr_BurningMapInfo(pInfo->MapIndex);
	if(pBurning)
	{
		
		if(!IS_SAME_UNITKIND(g_pShuttleChild->m_myShuttleInfo.UnitKind,pBurning->ReqUnitKind))
		{
			return;
		}
	}
	// 2010-08-10 by dgwoo ׸ ý

	WARP_TARGET_MAP_INFO_4_EXCHANGE* pNewInfo = new WARP_TARGET_MAP_INFO_4_EXCHANGE;
	memcpy(pNewInfo, pInfo, sizeof(WARP_TARGET_MAP_INFO_4_EXCHANGE));
	m_vecWarpTargetInfo.push_back(pNewInfo);
//	m_nWarpListLineNumber = m_vecWarpTargetInfo.size();
}

void CINFCityWarp::RecvWarpListDone()
{
	m_nWarpListLineNumber = m_vecWarpTargetInfo.size();
	m_pScroll->SetNumberOfData( m_nWarpListLineNumber );
//	int i =0;
//	CVectorWarpTargetInfoIterator it = m_vecWarpTargetInfo.begin();
//	while(it != m_vecWarpTargetInfo.end())
//	{
//		wsprintf(m_szWarpList[i], "%d    %s",i, (*it)->TargetName);
//		it++;
//		i++;
//	}
}

HRESULT CINFCityWarp::InitDeviceObjects()
{
	DataHeader* pDataHeader;
	pDataHeader = m_pGameData->Find("wpbk");
	m_pImgBack = new CINFImage;
	m_pImgBack->InitDeviceObjects( pDataHeader->m_pData, pDataHeader->m_DataSize );
	pDataHeader = m_pGameData->Find("wptitle");
	m_pImgTitle = new CINFImage;
	m_pImgTitle->InitDeviceObjects( pDataHeader->m_pData, pDataHeader->m_DataSize );
	int i;
	for(i=0;i<CITY_WARP_BUTTON_NUMBER;i++)
	{
		char buf[32];
		wsprintf( buf, "wpmove0%d",i);
		pDataHeader = m_pGameData->Find(buf);
		m_pButtonMove[i] = new CINFImage;
		m_pButtonMove[i]->InitDeviceObjects( pDataHeader->m_pData, pDataHeader->m_DataSize );
		wsprintf( buf, "shmcan0%d",i);
		pDataHeader = m_pGameData->Find(buf);
		m_pButtonCancel[i] = new CINFImage;
		m_pButtonCancel[i]->InitDeviceObjects( pDataHeader->m_pData, pDataHeader->m_DataSize );
	}
	pDataHeader = m_pGameData->Find("wphlgt");
	m_pImgHightLight = new CINFImage;
	m_pImgHightLight->InitDeviceObjects( pDataHeader->m_pData, pDataHeader->m_DataSize );

	for(i=0;i<CITY_WARP_LIST_NUMBER;i++)
	{
		m_pFontWarpList[i] = new CD3DHanFont(_T(g_pD3dApp->GetFontStyle()),9, D3DFONT_ZENABLE,  FALSE,256,32);
		m_pFontWarpList[i]->InitDeviceObjects(g_pD3dDev) ;
		m_pFontWarpPrice[i] = new CD3DHanFont(_T(g_pD3dApp->GetFontStyle()),9, D3DFONT_ZENABLE,  FALSE,256,32);
		m_pFontWarpPrice[i]->InitDeviceObjects(g_pD3dDev) ;
	}
	m_pScroll = new CINFScrollBar(this,
								SCROLL_START_X, 
								SCROLL_START_Y, 
								SCROLL_LINE_LENGTH,
								CITY_WARP_LIST_NUMBER);
	m_pScroll->SetGameData( m_pGameData );
	m_pScroll->InitDeviceObjects();

	m_pInfluenceTex = new CD3DHanFont(_T(g_pD3dApp->GetFontStyle()),9, D3DFONT_ZENABLE,  TRUE,256,32);
	m_pInfluenceTex->InitDeviceObjects(g_pD3dDev);

	m_pInfluenceTex->RestoreDeviceObjects();
	return S_OK;
}

HRESULT CINFCityWarp::RestoreDeviceObjects()
{
	if(!m_bRestored)
	{
		m_pImgBack->RestoreDeviceObjects();
		m_pImgTitle->RestoreDeviceObjects();
		int i;
		for(i=0;i<CITY_WARP_BUTTON_NUMBER;i++)
		{
			m_pButtonMove[i]->RestoreDeviceObjects();
			m_pButtonCancel[i]->RestoreDeviceObjects();
		}
		m_pImgHightLight->RestoreDeviceObjects();
		for(i=0;i<CITY_WARP_LIST_NUMBER;i++)
		{
			m_pFontWarpList[i]->RestoreDeviceObjects() ;
			m_pFontWarpPrice[i]->RestoreDeviceObjects();
		}
		m_pScroll->RestoreDeviceObjects();
		m_pScroll->SetWheelRect(CITY_WARP_LIST_START_X, 
			CITY_WARP_LIST_START_Y,
			CITY_WARP_LIST_START_X+CITY_WARP_LINE_SIZE_X,
			CITY_WARP_LIST_START_Y+CITY_WARP_LIST_INTERVAL*CITY_WARP_LIST_NUMBER);

		m_bRestored = TRUE;
	}
	return S_OK;
}

HRESULT CINFCityWarp::InvalidateDeviceObjects()
{
	if(m_bRestored)
	{
		m_pImgBack->InvalidateDeviceObjects();
		m_pImgTitle->InvalidateDeviceObjects();
		int i;
		for(i=0;i<CITY_WARP_BUTTON_NUMBER;i++)
		{
			m_pButtonMove[i]->InvalidateDeviceObjects();
			m_pButtonCancel[i]->InvalidateDeviceObjects();
		}
		m_pImgHightLight->InvalidateDeviceObjects();
		for(i=0;i<CITY_WARP_LIST_NUMBER;i++)
		{
			m_pFontWarpList[i]->InvalidateDeviceObjects() ;
			m_pFontWarpPrice[i]->InvalidateDeviceObjects();
		}
		m_pScroll->InvalidateDeviceObjects();

		m_bRestored = FALSE;
	}
	m_pInfluenceTex->InvalidateDeviceObjects();
	return S_OK;
}

HRESULT CINFCityWarp::DeleteDeviceObjects()
{
	m_pImgBack->DeleteDeviceObjects();
	SAFE_DELETE(m_pImgBack);
	m_pImgTitle->DeleteDeviceObjects();
	SAFE_DELETE(m_pImgTitle);
	int i;
	for(i=0;i<CITY_WARP_BUTTON_NUMBER;i++)
	{
		m_pButtonMove[i]->DeleteDeviceObjects();
		m_pButtonCancel[i]->DeleteDeviceObjects();
		SAFE_DELETE(m_pButtonMove[i]);
		SAFE_DELETE(m_pButtonCancel[i]);
	}
	m_pImgHightLight->DeleteDeviceObjects();
	SAFE_DELETE(m_pImgHightLight);
	for(i=0;i<CITY_WARP_LIST_NUMBER;i++)
	{
		m_pFontWarpList[i]->DeleteDeviceObjects();
		SAFE_DELETE(m_pFontWarpList[i]);
		m_pFontWarpPrice[i]->DeleteDeviceObjects();
		SAFE_DELETE(m_pFontWarpPrice[i]);
	}
	m_pScroll->DeleteDeviceObjects();
	SAFE_DELETE(m_pScroll);

	m_pInfluenceTex->DeleteDeviceObjects();
	SAFE_DELETE(m_pInfluenceTex);
	return S_OK;
}

void CINFCityWarp::Render()
{
	m_pImgBack->Move(CITY_WARP_BACK_START_X,CITY_WARP_BACK_START_Y);
	m_pImgBack->Render();
	m_pImgTitle->Move(CITY_WARP_TITLE_START_X,CITY_WARP_TITLE_START_Y);
	m_pImgTitle->Render();
	if(m_nButtonState[CITY_WARP_BUTTON_MOVE] != BUTTON_STATE_NORMAL)
	{
		m_pButtonMove[m_nButtonState[CITY_WARP_BUTTON_MOVE]]->Move(CITY_WARP_BUTTON_MOVE_START_X, CITY_WARP_BUTTON_MOVE_START_Y);
		m_pButtonMove[m_nButtonState[CITY_WARP_BUTTON_MOVE]]->Render();
	}
	if(m_nButtonState[CITY_WARP_BUTTON_CANCEL] != BUTTON_STATE_NORMAL)
	{
		m_pButtonCancel[m_nButtonState[CITY_WARP_BUTTON_CANCEL]]->Move(CITY_WARP_BUTTON_CANCEL_START_X, CITY_WARP_BUTTON_CANCEL_START_Y);
		m_pButtonCancel[m_nButtonState[CITY_WARP_BUTTON_CANCEL]]->Render();
	}
//	if(m_nCurrentSelectWarpIndex != -1)
//	{
//		m_pImgHightLight->Move(CITY_WARP_LIST_START_X+1,
//			CITY_WARP_LIST_START_Y+CITY_WARP_LIST_INTERVAL*m_nCurrentSelectWarpIndex+1);
//		m_pImgHightLight->Render();
//	}
	if(m_pScroll->GetCurrentSelectWindowIndex() >= 0 &&
		m_pScroll->GetCurrentSelectWindowIndex() < CITY_WARP_LIST_NUMBER)
	{
		m_pImgHightLight->Move(CITY_WARP_LIST_START_X+1,
			CITY_WARP_LIST_START_Y+CITY_WARP_LIST_INTERVAL*m_pScroll->GetCurrentSelectWindowIndex()+1);
		m_pImgHightLight->Render();
	}
//	for(int i=0;i<CITY_WARP_LIST_NUMBER;i++)
//	{
//		if(m_szWarpList[i])
//		{
//			m_pFontWarpList[i]->DrawText(CITY_WARP_LIST_START_X+1, 
//				CITY_WARP_LIST_START_Y+CITY_WARP_LIST_INTERVAL*i+1,
//				m_pScroll->GetCurrentSelectWindowIndex == i ? GUI_SELECT_FONT_COLOR : GUI_FONT_COLOR,
//				m_szWarpList[i],0L);
//		}
//		else 
//		{
//			break;
//		}
//	}
	for(int i=0;i<CITY_WARP_LIST_NUMBER;i++)
	{
		int index = m_pScroll->GetCurrentScrollIndex()+i;
		if(index >= m_vecWarpTargetInfo.size())
		{
			break;
		}
//#if defined(LANGUAGE_ENGLISH) || defined(LANGUAGE_VIETNAM)
		char chWarpPrice[30] = {0, };
		int len = 0;
//		wsprintf(m_szWarpList[i], "%16s%10d", m_vecWarpTargetInfo[index]->TargetName, m_vecWarpTargetInfo[index]->Fee);
		wsprintf(m_szWarpList[i], "%s", m_vecWarpTargetInfo[index]->TargetName);
		int nWarpPrice = (CAtumSJ::GetCityWarTex(m_vecWarpTargetInfo[index]->Fee, m_fTexRate) + m_vecWarpTargetInfo[index]->Fee);
		// 2006-04-21 by ispark, ڴ ¥
		if(COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_INFLUENCE_LEADER))
		{
			nWarpPrice = 0;
		// 2007-10-10 by dgwoo    
		}else if(0 != g_pD3dApp->GetPrimiumCardInfo()->nCardItemNum1)
		{
			nWarpPrice = nWarpPrice - (nWarpPrice / (100/MEMBERSHIP_DISCOUNT_WARPFEE));
		}
		wsprintf(chWarpPrice, "%d", nWarpPrice);
		len = strlen(chWarpPrice);
//#else
//		int nWarpPrice = (CAtumSJ::GetCityWarTex(m_vecWarpTargetInfo[index]->Fee, m_fTexRate) + m_vecWarpTargetInfo[index]->Fee);
//		// 2006-04-21 by ispark, ڴ ¥
//		if(COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_INFLUENCE_LEADER))
//		{
//			nWarpPrice = 0;
//		}
//		wsprintf(m_szWarpList[i], "%16s%10d", m_vecWarpTargetInfo[index]->TargetName, nWarpPrice);
//#endif
		if(m_szWarpList[i])
		{
//#if defined(LANGUAGE_ENGLISH) || defined(LANGUAGE_VIETNAM)
			m_pFontWarpList[i]->DrawText(CITY_WARP_LIST_START_X+1, 
				CITY_WARP_LIST_START_Y+CITY_WARP_LIST_INTERVAL*i-1,
				m_pScroll->GetCurrentSelectWindowIndex() == i ? GUI_SELECT_FONT_COLOR : GUI_FONT_COLOR,
				m_szWarpList[i],0L);
			m_pFontWarpPrice[i]->DrawText(CITY_WARP_LIST_START_X+165 - len*7, 
				CITY_WARP_LIST_START_Y+CITY_WARP_LIST_INTERVAL*i-1,
				m_pScroll->GetCurrentSelectWindowIndex() == i ? GUI_SELECT_FONT_COLOR : GUI_FONT_COLOR,
				chWarpPrice,0L);
//#else
//			m_pFontWarpList[i]->DrawText(CITY_WARP_LIST_START_X+1, 
//				CITY_WARP_LIST_START_Y+CITY_WARP_LIST_INTERVAL*i+1,
//				m_pScroll->GetCurrentSelectWindowIndex() == i ? GUI_SELECT_FONT_COLOR : GUI_FONT_COLOR,
//				m_szWarpList[i],0L);
//#endif
		}
		else 
		{
			break;
		}
	}
	m_pScroll->Render();

	// 2006-02-08 by ispark,  
	char chTexbuf[30] = {0,};
	sprintf(chTexbuf, STRMSG_C_060208_0000, m_fTexRate);
	m_pInfluenceTex->DrawText(CITY_WARP_TEX_X, CITY_WARP_TEX_Y, GUI_FONT_COLOR, chTexbuf, 0L);
}

void CINFCityWarp::Tick()
{

}

int CINFCityWarp::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if(m_pScroll)
	{
		if(m_pScroll->WndProc(uMsg, wParam, lParam) == INF_MSGPROC_BREAK)
		{
			return INF_MSGPROC_BREAK;
		}
	}
	switch(uMsg)
	{
	case WM_MOUSEMOVE:
		{
			POINT pt;
			pt.x = LOWORD(lParam);
			pt.y = HIWORD(lParam);
			CheckMouseReverse(&pt);
			if(pt.y > CITY_WARP_BUTTON_MOVE_START_Y && 
				pt.y < CITY_WARP_BUTTON_MOVE_START_Y + CITY_WARP_BUTTON_SIZE_Y)
			{
				if( pt.x > CITY_WARP_BUTTON_MOVE_START_X && 
					pt.x < CITY_WARP_BUTTON_MOVE_START_X+CITY_WARP_BUTTON_SIZE_X)
				{
					if(m_nButtonState[CITY_WARP_BUTTON_MOVE] != BUTTON_STATE_DOWN)
						m_nButtonState[CITY_WARP_BUTTON_MOVE] = BUTTON_STATE_UP;
				}
				else 
				{
					m_nButtonState[CITY_WARP_BUTTON_MOVE] = BUTTON_STATE_NORMAL;
				}
				if( pt.x > CITY_WARP_BUTTON_CANCEL_START_X && 
					pt.x < CITY_WARP_BUTTON_CANCEL_START_X+CITY_WARP_BUTTON_SIZE_X)
				{
					if(m_nButtonState[CITY_WARP_BUTTON_CANCEL] != BUTTON_STATE_DOWN)
						m_nButtonState[CITY_WARP_BUTTON_CANCEL] = BUTTON_STATE_UP;
				}
				else 
				{
					m_nButtonState[CITY_WARP_BUTTON_CANCEL] = BUTTON_STATE_NORMAL;
				}
			}
			else
			{
				m_nButtonState[CITY_WARP_BUTTON_MOVE] = BUTTON_STATE_NORMAL;
				m_nButtonState[CITY_WARP_BUTTON_CANCEL] = BUTTON_STATE_NORMAL;
			}
		}
		break;
	case WM_LBUTTONDOWN:
		{
			POINT pt;
			pt.x = LOWORD(lParam);
			pt.y = HIWORD(lParam);
			CheckMouseReverse(&pt);
			if(pt.y > CITY_WARP_BUTTON_MOVE_START_Y && 
				pt.y < CITY_WARP_BUTTON_MOVE_START_Y + CITY_WARP_BUTTON_SIZE_Y)
			{
				if( pt.x > CITY_WARP_BUTTON_MOVE_START_X && 
					pt.x < CITY_WARP_BUTTON_MOVE_START_X+CITY_WARP_BUTTON_SIZE_X)
				{
					m_nButtonState[CITY_WARP_BUTTON_MOVE] = BUTTON_STATE_DOWN;
				}
				else 
				{
					m_nButtonState[CITY_WARP_BUTTON_MOVE] = BUTTON_STATE_NORMAL;
				}
				if( pt.x > CITY_WARP_BUTTON_CANCEL_START_X && 
					pt.x < CITY_WARP_BUTTON_CANCEL_START_X+CITY_WARP_BUTTON_SIZE_X)
				{
					m_nButtonState[CITY_WARP_BUTTON_CANCEL] = BUTTON_STATE_DOWN;
				}
				else 
				{
					m_nButtonState[CITY_WARP_BUTTON_CANCEL] = BUTTON_STATE_NORMAL;
				}
			}
//			if( pt.x > CITY_WARP_LIST_START_X && 
//				pt.x < CITY_WARP_LIST_START_X + CITY_WARP_LINE_SIZE_X &&
//				pt.y > CITY_WARP_LIST_START_Y && 
//				pt.y < CITY_WARP_LIST_START_Y + CITY_WARP_LIST_INTERVAL*CITY_WARP_LIST_NUMBER)
//			{
//				int i = (pt.y-CITY_WARP_LIST_START_Y)/CITY_WARP_LIST_INTERVAL;
//				if(i>=0 && i<CITY_WARP_LIST_NUMBER)
//				{
//					if(m_vecWarpTargetInfo.size() >= i + m_nCurrentWarpListScroll)
//					{
//						m_nCurrentSelectWarpIndex = i;
//					}
//				}
//			}
		}
		break;
	case WM_LBUTTONUP:
		{
			POINT pt;
			pt.x = LOWORD(lParam);
			pt.y = HIWORD(lParam);
			CheckMouseReverse(&pt);
			if(pt.y > CITY_WARP_BUTTON_MOVE_START_Y && 
				pt.y < CITY_WARP_BUTTON_MOVE_START_Y + CITY_WARP_BUTTON_SIZE_Y)
			{
				if( pt.x > CITY_WARP_BUTTON_MOVE_START_X && 
					pt.x < CITY_WARP_BUTTON_MOVE_START_X+CITY_WARP_BUTTON_SIZE_X)
				{
					if(m_nButtonState[CITY_WARP_BUTTON_MOVE] == BUTTON_STATE_DOWN)
					{
						OnButtonClicked(CITY_WARP_BUTTON_MOVE);
					}
					m_nButtonState[CITY_WARP_BUTTON_MOVE] = BUTTON_STATE_UP;
				}
				else 
				{
					m_nButtonState[CITY_WARP_BUTTON_MOVE] = BUTTON_STATE_NORMAL;
				}
				if( pt.x > CITY_WARP_BUTTON_CANCEL_START_X && 
					pt.x < CITY_WARP_BUTTON_CANCEL_START_X+CITY_WARP_BUTTON_SIZE_X)
				{
					if(m_nButtonState[CITY_WARP_BUTTON_CANCEL] == BUTTON_STATE_DOWN)
					{
						OnButtonClicked(CITY_WARP_BUTTON_CANCEL);
					}
					m_nButtonState[CITY_WARP_BUTTON_CANCEL] = BUTTON_STATE_UP;
				}
				else 
				{
					m_nButtonState[CITY_WARP_BUTTON_CANCEL] = BUTTON_STATE_NORMAL;
				}
			}
		}
		break;
	}
	return INF_MSGPROC_NORMAL;
}

void CINFCityWarp::OnButtonClicked(int nButton)
{
	switch(nButton)
	{
	case CITY_WARP_BUTTON_MOVE:
		{
//			if(m_nCurrentSelectWarpIndex != -1 && 
//				m_nCurrentSelectWarpIndex + m_nCurrentWarpListScroll < m_vecWarpTargetInfo.size())
//			{
//				WARP_TARGET_MAP_INFO_4_EXCHANGE *pWarpInfo = m_vecWarpTargetInfo[m_nCurrentSelectWarpIndex + m_nCurrentWarpListScroll];
//				if(pWarpInfo)
//				{
//					DBGOUT(" սô(Map:%d,Target:%d,Name:%s).!!\n",
//						pWarpInfo->MapIndex, pWarpInfo->TargetIndex, pWarpInfo->TargetName);
//					SendFieldSocketRequestShopWarp(pWarpInfo->MapIndex, pWarpInfo->TargetIndex);
//				}
//			}
			int nCurrentSelectRealIndex = m_pScroll->GetCurrentSelectDataIndex();
			if( nCurrentSelectRealIndex >= 0 && 
				nCurrentSelectRealIndex < m_vecWarpTargetInfo.size())
			{
				WARP_TARGET_MAP_INFO_4_EXCHANGE *pWarpInfo = m_vecWarpTargetInfo[nCurrentSelectRealIndex];
				if(pWarpInfo)
				{
					// 2010-08-10 by dgwoo ׸ ý
					BURNING_MAP_INFO* pBurning = g_pDatabase->GetPtr_BurningMapInfo(pWarpInfo->MapIndex);
					if(pBurning)
					{
						
						if((pBurning->ReqMaxLv < g_pShuttleChild->m_myShuttleInfo.Level)
							|| (pBurning->ReqMinLv > g_pShuttleChild->m_myShuttleInfo.Level))
						{
							CHAR buf[256] = {0,};
							sprintf(buf,STRMSG_C_100810_0100,pBurning->ReqMinLv,pBurning->ReqMaxLv);
							g_pD3dApp->m_pChat->CreateChatChild( buf, COLOR_ERROR );
						}
					}
					// 2010-08-10 by dgwoo ׸ ý

					// 2008-01-31 by dgwoo     .
					INT nWarpPrice = pWarpInfo->Fee;
					if(0 != g_pD3dApp->GetPrimiumCardInfo()->nCardItemNum1)
					{
						nWarpPrice = nWarpPrice - (nWarpPrice / (100/MEMBERSHIP_DISCOUNT_WARPFEE));
					}
					if( nWarpPrice > g_pGameMain->m_pInven->GetItemSpi() )
					{
						g_pD3dApp->m_pChat->CreateChatChild( STRMSG_C_CITY_0006, COLOR_ERROR );//" ʿ ǰ մϴ."
						break;
					}
					if( g_pStoreData->FindItemInInventoryByWindowPos( POS_REAR ) == NULL )
					{
						g_pD3dApp->m_pChat->CreateChatChild( STRMSG_C_CITY_0007, COLOR_ERROR );//"     ϴ."
						break;
					}
					
					GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
					if(pBuilding)
					{
						g_pInterface->m_pCityBase->SendLeaveEnterBuilding( pBuilding->buildingInfo.BuildingIndex, -1 );
					}
//					SendFieldSocketRequestShopWarp(pWarpInfo->MapIndex, pWarpInfo->TargetIndex);
					m_nMapIndex = pWarpInfo->MapIndex;	
					m_nTargetIndex = pWarpInfo->TargetIndex;	

					// 2004-10-25 by jschoi
					// Ʒ    Ѱ  ûѴ.
					//  Ȯ  Ʒ  κ ϵ Ѵ.
					//   ų  Ұ    Ѵ.
						g_pShuttleChild->m_nEventType = EVENT_CITY_OUT_MOVE;
					g_pFieldWinSocket->SendMsg(T_FC_CITY_CHECK_WARP_STATE, NULL, 0);

//					SAFE_DELETE(g_pShuttleChild->m_pCinemaCamera);
//					if (g_pShuttleChild->InitCinemaUnit(PATTERN_UNIT_CITY_OUT) == TRUE)
//					{
//						g_pD3dApp->m_pSound->PlayD3DSound( SOUND_TAKEINGOFF_IN_CITY, g_pShuttleChild->m_vPos );
//						g_pShuttleChild->ChangeSingleBodyCondition(BODYCON_TAKEOFF_MASK);
//						g_pShuttleChild->m_nEventType = EVENT_CITY_OUT_MOVE;
//						g_pShuttleChild->ChangeUnitState( _TAKINGOFF );
//						CAppEffectData * pEffect = new CAppEffectData(RC_EFF_LANDING_TAKEOFF,MAP_TYPE_CITY_UNIT_POS);
//						pEffect->ChangeBodyCondition(BODYCON_LANDED_MASK);
//						g_pD3dApp->m_pEffectList->AddChild(pEffect);
//
//					}
//					else
//					{
//						SendFieldSocketRequestShopWarp();
//					}
				}
			}
		}
		break;
	case CITY_WARP_BUTTON_CANCEL:
		{
		}
		break;
	}

}

void CINFCityWarp::SendFieldSocketRequestShopWarp()//int nMapIndex, int nTargetIndex)
{
	MSG_FC_EVENT_REQUEST_SHOP_WARP sMsg;
	sMsg.MapIndex = m_nMapIndex;
	sMsg.TargetIndex = m_nTargetIndex;
	g_pFieldWinSocket->SendMsg(T_FC_EVENT_REQUEST_SHOP_WARP, (char*)&sMsg, sizeof(sMsg));
	DBGOUT("FieldSocket : Request Warp. T_FC_EVENT_REQUEST_SHOP_WARP\n");
}

WARP_TARGET_MAP_INFO_4_EXCHANGE *CINFCityWarp::GetCurrentWarpInfo()
{
//	return m_vecWarpTargetInfo[m_nCurrentSelectWarpIndex + m_nCurrentWarpListScroll];
	return m_vecWarpTargetInfo[m_pScroll->GetCurrentSelectDataIndex()];
}