// CINFOtherCharInfo.cpp: implementation of the CINFOtherCharInfo class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "INFOtherCharInfo.h"
#include "AtumApplication.h"
#include "INFImage.h"
#include "GameDataLast.h"
#include "EnemyData.h"
#include "D3DHanFont.h"
#include "INFGameMain.h"
#include "SceneData.h"
#include "UnitData.h"
#include "AtumDatabase.h"
#include "INFSelect.h"
#include "INFPilotFace.h"
#include "ShuttleChild.h"
#include "CharacterChild.h"				// 2005-07-21 by ispark
// 2007-11-22 by bhsohn Ʒ ռ
#include "IMSocketManager.h"
//#include "IMSocket.h"  

#include "dxutil.h"

#define USER_INFO_BOX_WIDTH		268
#define USER_INFO_BOX_HEIGHT	139

#define USER_BOX_CITY_HEIGHT	84
#define USER_BOX_FIELD_HEIGHT	39

#define USER_NAME_INDEX			0
#define USER_UNIT_INDEX			1
#define USER_GUILD_INDEX		2
#define USER_CLASS_INDEX		3
#define USER_FAME_INDEX			4
#define USER_LEVEL_INDEX		5

#define USER_TEXTDROW_WIDTH		165
#define USER_TEXTDROW_HEIGHT	26
#define USER_FONT_LINE_HEIGHT	20

#define USER_FACE_POSITION_X	8
#define USER_FACE_POSITION_Y	24
#define USER_GUILDMARK_POSITION_X	78
#define USER_GUILDMARK_POSITION_Y	105	

#define USER_CITY_SHOWBOX_INIT_HEIGHT	89
#define USER_FIELD_SHOWBOX_INIT_HEIGHT	44


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CINFOtherCharInfo::CINFOtherCharInfo(CAtumNode* pParent)
{
	FLOG( "CINFOtherCharInfo()" );

	m_pParent = pParent;
	
	for(int i =0; i<OTHERINFO_INFOMATION_NUMBER; i++)
		m_pFontInfo[i]		= NULL;
	
	m_pInfoShowImage		= NULL;
	m_pInfoGuildCase		= NULL;
	
	memset(m_strUserName,	0x00, 128);
	memset(m_strUserGear,	0x00, 64);
	memset(m_strGuild,		0x00, 256);
	memset(m_strClass,		0x00, 128);	
	memset(m_strFame,		0x00, 16);	
	memset(m_strLevel,		0x00, 16);

	m_nX = g_pD3dApp->GetBackBufferDesc().Width-USER_INFO_BOX_WIDTH;
	m_nY = 200;	
	m_bRenderInfo			= FALSE;
	m_nGuildUniNum			= 0;
	m_nMoveWindows			= FALSE;
	m_nBoxStartXOld			= m_nX;
	m_nBoxStartYOld			= m_nY;

	memset(&m_createUnit, 0x00, sizeof(MSG_FC_CHARACTER_CREATE));
	m_pPilotFace			= NULL;

	m_pointBeforeMousePoint.x		= 0;
	m_pointBeforeMousePoint.y		= 0;

	// 2005-04-22 by jschoi
	m_bRenderLevel = FALSE;
}

CINFOtherCharInfo::~CINFOtherCharInfo()
{
	FLOG( "~CINFOtherCharInfo()" );

	for(int i =0; i<OTHERINFO_INFOMATION_NUMBER; i++)
		SAFE_DELETE(m_pFontInfo[i]);
	
	SAFE_DELETE(m_pInfoShowImage);
	SAFE_DELETE(m_pInfoGuildCase);
	SAFE_DELETE(m_pPilotFace);
}

HRESULT CINFOtherCharInfo::InitDeviceObjects()
{
	FLOG( "CINFOtherCharInfo::InitDeviceObjects(char* pData, int nSize)" );

	DataHeader	* pDataHeader ;
	
	for(int i =0; i<OTHERINFO_INFOMATION_NUMBER; i++)
	{
		m_pFontInfo[i] = new CD3DHanFont(_T(g_pD3dApp->GetFontStyle()),9, D3DFONT_ZENABLE, FALSE,1024,32);
		m_pFontInfo[i]->InitDeviceObjects(g_pD3dDev);
	}	

	m_pInfoShowImage = new CINFImage;
	pDataHeader = FindResource("userinfo");
	m_pInfoShowImage->InitDeviceObjects(pDataHeader->m_pData,pDataHeader->m_DataSize) ;
	
	m_pInfoGuildCase = new CINFImage;
	pDataHeader = FindResource("GuilCase");
	m_pInfoGuildCase->InitDeviceObjects(pDataHeader->m_pData,pDataHeader->m_DataSize) ;

	m_pPilotFace = new CINFPilotFace;
	m_pPilotFace->InitDeviceObjects("face.tex");

	return S_OK;
}

HRESULT CINFOtherCharInfo::RestoreDeviceObjects()
{
	FLOG( "CINFOtherCharInfo::RestoreDeviceObjects()" );

	for(int i =0; i<OTHERINFO_INFOMATION_NUMBER; i++)
		m_pFontInfo[i]->RestoreDeviceObjects();

	m_pInfoShowImage->RestoreDeviceObjects();
	m_pInfoGuildCase->RestoreDeviceObjects();
	if(m_pPilotFace)
		m_pPilotFace->RestoreDeviceObjects();
	
	return S_OK;
}

HRESULT CINFOtherCharInfo::InvalidateDeviceObjects()
{
	FLOG( "CINFOtherCharInfo::InvalidateDeviceObjects()" );

	for(int i =0; i<OTHERINFO_INFOMATION_NUMBER; i++)
		m_pFontInfo[i]->InvalidateDeviceObjects();

	m_pInfoShowImage->InvalidateDeviceObjects();
	m_pInfoGuildCase->InvalidateDeviceObjects();
	m_pPilotFace->InvalidateDeviceObjects();
	
	return S_OK;
}

HRESULT CINFOtherCharInfo::DeleteDeviceObjects()
{
	FLOG( "CINFOtherCharInfo::DeleteDeviceObjects()" );	
	
	for(int i =0; i<OTHERINFO_INFOMATION_NUMBER; i++)
	{
		m_pFontInfo[i]->DeleteDeviceObjects();
		SAFE_DELETE(m_pFontInfo[i]);
	}

	m_pInfoShowImage->DeleteDeviceObjects();
	SAFE_DELETE(m_pInfoShowImage);
	
	m_pInfoGuildCase->DeleteDeviceObjects();
	SAFE_DELETE(m_pInfoGuildCase);

	m_pPilotFace->DeleteDeviceObjects();
	SAFE_DELETE(m_pPilotFace);
	return S_OK;
}

void CINFOtherCharInfo::Render()
{
	FLOG( "CINFOtherCharInfo::Render()" );	

	m_pInfoShowImage->Move(m_nX, m_nY);
	m_pInfoShowImage->Render();

	m_pFontInfo[USER_NAME_INDEX]->DrawText(m_nX+USER_TEXTDROW_WIDTH,
		m_nY+USER_TEXTDROW_HEIGHT,GUI_FONT_COLOR, m_strUserName, 0L);
	m_pFontInfo[USER_UNIT_INDEX]->DrawText(m_nX+USER_TEXTDROW_WIDTH,
		m_nY+USER_TEXTDROW_HEIGHT+USER_FONT_LINE_HEIGHT,GUI_FONT_COLOR, m_strUserGear, 0L);
	m_pFontInfo[USER_GUILD_INDEX]->DrawText(m_nX+USER_TEXTDROW_WIDTH,
		m_nY+USER_TEXTDROW_HEIGHT+(USER_FONT_LINE_HEIGHT*2),GUI_FONT_COLOR, m_strGuild, 0L);
	m_pFontInfo[USER_CLASS_INDEX]->DrawText(m_nX+USER_TEXTDROW_WIDTH,
		m_nY+USER_TEXTDROW_HEIGHT+(USER_FONT_LINE_HEIGHT*3),GUI_FONT_COLOR, m_strClass, 0L);
	m_pFontInfo[USER_FAME_INDEX]->DrawText(m_nX+USER_TEXTDROW_WIDTH,
		m_nY+USER_TEXTDROW_HEIGHT+(USER_FONT_LINE_HEIGHT*4),GUI_FONT_COLOR, m_strFame, 0L);
	
	// Ϸ ̽  
	CINFImage* pFace = m_pPilotFace->FindPilotImage(m_createUnit.PilotFace);	
	if(pFace)
	{
		pFace->Move(m_nX+USER_FACE_POSITION_X, m_nY+USER_FACE_POSITION_Y);
		pFace->Render();
	}

	//  ũ 
	if(m_nGuildUniNum)
	{
		CINFImage* pMark = NULL;
		pMark = g_pDatabase->GetGuildMark(m_nGuildUniNum);
		if(pMark)
		{
			m_pInfoGuildCase->Move( m_nX+USER_GUILDMARK_POSITION_X-1, m_nY+USER_GUILDMARK_POSITION_Y-1 );
			m_pInfoGuildCase->Render();
			
			pMark->Move( m_nX+USER_GUILDMARK_POSITION_X, m_nY+USER_GUILDMARK_POSITION_Y );
			pMark->Render();
		}
	}

	if(m_bRenderLevel)
	{
		m_pFontInfo[USER_LEVEL_INDEX]->DrawText(m_nX + USER_TEXTDROW_WIDTH + (strlen(m_strUserGear)+1)*6,
		m_nY+USER_TEXTDROW_HEIGHT + USER_FONT_LINE_HEIGHT,GUI_FONT_COLOR, m_strLevel, 0L);	
	}
}

void CINFOtherCharInfo::Tick()
{
	FLOG( "CINFOtherCharInfo::Tick()" );	
}

void CINFOtherCharInfo::GetOtherCharInfo(char *sName, BOOL bRenderLevel)
{
	FLOG( "CINFOtherCharInfo::GetOtherCharInfo()" );

	// 2005-04-22 by jschoi -  ǥ
	m_bRenderLevel = bRenderLevel;
	
	if(g_pD3dApp->m_dwGameState == _CITY)
	{
		m_nY = g_pD3dApp->GetBackBufferDesc().Height - USER_CITY_SHOWBOX_INIT_HEIGHT - USER_INFO_BOX_HEIGHT+5;
	}
	else
	{
		m_nY = g_pD3dApp->GetBackBufferDesc().Height - USER_FIELD_SHOWBOX_INIT_HEIGHT - USER_INFO_BOX_HEIGHT+5;
	}
	m_nX = g_pD3dApp->GetBackBufferDesc().Width-USER_INFO_BOX_WIDTH;
	
	CEnemyData * pOtherInfo = NULL;
	CMapEnemyIterator itEnemy = g_pD3dApp->m_pScene->m_mapEnemyList.begin();
	while(itEnemy != g_pD3dApp->m_pScene->m_mapEnemyList.end())
	{
		// 2006-11-14 by ispark,  ¸ ֱ
		if(!strcmp(itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName, sName) &&
			(IsInfluenceCharacter(g_pShuttleChild->m_myShuttleInfo.InfluenceType, itEnemy->second->m_infoCharacter.CharacterInfo.InfluenceType, 0) ||
				COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER)))
		{
			pOtherInfo = itEnemy->second;
			break;
		}
		itEnemy++;
	}

	if(strcmp(g_pShuttleChild->m_myShuttleInfo.CharacterName, sName) == 0)
	{
		m_bRenderInfo = TRUE;

		// ĳ ̸
		strcpy(m_strUserName, g_pShuttleChild->m_myShuttleInfo.CharacterName);
		// 2008-02-26 by bhsohn  Ʒ   
		// ۾ ٲپش.
		g_pD3dApp->ConevertArenaRenderUserName(g_pD3dApp->GetArenaState(), m_strUserName);

		//  
		strcpy(m_strUserGear, g_pAtumSJ->GetUnitKindString(g_pShuttleChild->m_myShuttleInfo.UnitKind));
		
		// 
		if(g_pShuttleChild->m_myShuttleInfo.GuildName)
		{
			strcpy(m_strGuild, g_pShuttleChild->m_myShuttleInfo.GuildName);
			m_nGuildUniNum = g_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber;
		}
		else 
		{
			m_nGuildUniNum = 0;
			memset(m_strGuild,		0x00, 256);
		}

		// 
		int tempState = g_pAtumSJ->GetStatusByPropensity(g_pShuttleChild->m_myShuttleInfo.Propensity);
		strcpy(m_strClass, g_pAtumSJ->GetStatusNameKO(tempState));

		// 
		wsprintf(m_strFame, "%d", g_pShuttleChild->m_myShuttleInfo.Propensity);

		// Face
		m_createUnit.PilotFace = g_pShuttleChild->m_myShuttleInfo.PilotFace;		
		
	}
	else if(pOtherInfo)
	{
		m_bRenderInfo = TRUE;

		// ĳ ̸
		strcpy(m_strUserName, pOtherInfo->m_infoCharacter.CharacterInfo.CharacterName);
		
		// 2008-02-26 by bhsohn  Ʒ   
		// ۾ ٲپش.
		g_pD3dApp->ConevertArenaRenderUserName(g_pD3dApp->GetArenaState(), m_strUserName);

		//  
		strcpy(m_strUserGear, g_pAtumSJ->GetUnitKindString(pOtherInfo->m_infoCharacter.CharacterInfo.UnitKind));
		
		// 
		if(pOtherInfo->m_infoCharacter.CharacterInfo.GuildUniqueNumber)
		{
			MEX_OTHER_GUILD_INFO* pGuild = g_pDatabase->GetOtherGuildInfo( pOtherInfo->m_infoCharacter.CharacterInfo.GuildUniqueNumber );
			if(pGuild != NULL)
			{
			wsprintf(m_strGuild, pGuild->GuildName, sizeof(pGuild->GuildName)); 
			m_nGuildUniNum = pOtherInfo->m_infoCharacter.CharacterInfo.GuildUniqueNumber;
			}
		}
		else 
		{
			m_nGuildUniNum = 0;
			memset(m_strGuild,		0x00, 256);
		}

		// 
		int tempState = g_pAtumSJ->GetStatusByPropensity(pOtherInfo->m_infoCharacter.CharacterInfo.Propensity);
		strcpy(m_strClass, g_pAtumSJ->GetStatusNameKO(tempState));

		// 
		wsprintf(m_strFame, "%d", pOtherInfo->m_infoCharacter.CharacterInfo.Propensity);

		// Face
		m_createUnit.PilotFace = pOtherInfo->m_infoCharacter.CharacterInfo.PilotFace;	
		
		// 
		wsprintf(m_strLevel, "[Lv.%dX]",(int)pOtherInfo->m_infoCharacter.CharacterInfo.Level1/10);
	}

}

int CINFOtherCharInfo::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	FLOG( "CINFOtherCharInfo::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)" );
	
	POINT pt;

	switch(uMsg)
	{
	case WM_MOUSEMOVE:
		{
			GetCursorPos(&pt);
			ScreenToClient(g_pD3dApp->GetHwnd(), &pt);
			CheckMouseReverse(&pt);
			
			// â̵ ư
			if( m_nMoveWindows )
			{
				m_nX = m_nBoxStartXOld + pt.x - m_pointBeforeMousePoint.x;
				m_nY = m_nBoxStartYOld + pt.y - m_pointBeforeMousePoint.y;				
				
				return INF_MSGPROC_BREAK;
			}
		}
		break;
	case WM_LBUTTONDOWN:
		{
			GetCursorPos(&pt);
			ScreenToClient(g_pD3dApp->GetHwnd(), &pt);
			CheckMouseReverse(&pt);
			
			// âݱ ư
			if(pt.x >= m_nX + 250
				&& pt.x < m_nX + USER_INFO_BOX_WIDTH - 6
				&& pt.y >= m_nY + 5
				&& pt.y < m_nY+USER_INFO_BOX_HEIGHT-123)
			{
				m_bRenderInfo = FALSE;
				return INF_MSGPROC_BREAK;
			}
			
			// â̵ ư
			if(pt.x >= m_nX
				&& pt.x < m_nX + USER_INFO_BOX_WIDTH
				&& pt.y >= m_nY
				&& pt.y < m_nY+20)
			{
				m_pointBeforeMousePoint		= pt;
				m_nBoxStartXOld				= m_nX;
				m_nBoxStartYOld				= m_nY;
				m_nMoveWindows = TRUE;
				
				return INF_MSGPROC_BREAK;
			}
		}
		break;
	case WM_LBUTTONUP:
		{
			m_nMoveWindows = FALSE;
		}
		break;
	}
	return INF_MSGPROC_NORMAL;
}