///////////////////////////////////////////////////////////////////////////////
//  Overlapped.cpp : 
//  
//  Date	: 2004-03-17 by cmkwon
///////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Overlapped.h"
#include "VMemPool.h"


//////////////////////////////////////////////////////////////////////////
// static 
//////////////////////////////////////////////////////////////////////////
char* COverlapped::pXOR_ENCODE_BYTES	= XOR_ENCODE_BYTES;


//////////////////////////////////////////////////////////////////////////
// Construction/Destruction 
//////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
/// \fn			COverlapped::COverlapped(int Mode, int Type, BOOL Encoding)
/// \brief		COverlapped 
/// \author		cmkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		Mode		[in] Read(0) or Write(1) Operation Mode
/// \param		Type		[in] Static(2) or Dynamic(3) Overlapped Type
/// \param		Encoding	[in] Ŷ ڵ ÷
/// \return		
///////////////////////////////////////////////////////////////////////////////
COverlapped::COverlapped(ENOperationMode i_enOperationMode,
						 ENOverlappedType i_enOverlappedType,
						 BOOL Encoding)
:m_enOperationMode(i_enOperationMode), m_enOverlappedType(i_enOverlappedType), m_bEncodingFlag(Encoding)
{
	ResetOverlapped();
}

//////////////////////////////////////////////////////////////////
// COverlapped Ҹ
//    ̹Ƿ óҰ 
COverlapped::~COverlapped()
{
}


//////////////////////////////////////////////////////////////////////////
// Method
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
// COverlapped Ŷ Ÿ ߰ϴ Լ
// pData		- Data Pointer
// nSize		- ߰ Ÿ Size
// 2008-03-13 by cmkwon, Ը  Ŭ̾Ʈ ñ°  - ߰(SSendedOverlappedInfo *o_pSendedOverInfo)
BOOL COverlapped::AddData(SSendedOverlappedInfo *o_pSendedOverInfo, BYTE* pData, int nSize)
{	
	if(m_bEncodedFlag
		|| NULL == pData
		|| nSize <= 0
		|| m_WSABUF.len + nSize > SIZE_MAX_PACKET)
	{	// ̹ ڵ Ŷ
		// Ŷ  ȿ üũ

		return FALSE;
	}

	o_pSendedOverInfo->pOverlapped	= this;		// 2008-03-13 by cmkwon, Ը  Ŭ̾Ʈ ñ°  - 
	int nLen = 0;
	if(0 == m_WSABUF.len)
	{
		o_pSendedOverInfo->pbyData		= (BYTE*)(lpBuff + SIZE_PACKET_HEADER);	// 2008-03-13 by cmkwon, Ը  Ŭ̾Ʈ ñ°  - 
		memcpy(lpBuff+SIZE_PACKET_HEADER, pData, nSize);
		m_WSABUF.len = nSize + SIZE_PACKET_HEADER;
	}
	else
	{
		o_pSendedOverInfo->pbyData		= (BYTE*)(&lpBuff[m_WSABUF.len]);	// 2008-03-13 by cmkwon, Ը  Ŭ̾Ʈ ñ°  - 
		memcpy(&lpBuff[m_WSABUF.len], pData, nSize);
		m_WSABUF.len += nSize;
	}
	*(USHORT*)m_WSABUF.buf = m_WSABUF.len - SIZE_PACKET_HEADER;
	return TRUE;
}

//////////////////////////////////////////////////////////////////
// COverlapped Ŷ ִ Ÿ 
//  
int COverlapped::GetDataSize(void)
{
	return m_WSABUF.len;
}

//////////////////////////////////////////////////////////////////
// COverlapped Ŷ ʱȭ ϴ Լ
//  
void COverlapped::ResetOverlapped(void)
{
	Internal				= 0;
	InternalHigh			= 0;
	Offset					= 0;
	OffsetHigh				= 0;
	hEvent					= NULL;

	m_bEncodedFlag			= FALSE;
	m_WSABUF.buf			= lpBuff;
	m_WSABUF.len			= 0;
	m_nSizesocketaddr_in	= sizeof(sockaddr_in);
	memset(&m_socketaddr_in, 0x00, sizeof(sockaddr_in));
	memset(lpBuff, 0x00, SIZE_MAX_SOCKET_BUFFER);

	if(EN_OPERATION_MODE_READ == this->GetOperationMode()){		m_WSABUF.len = SIZE_MAX_SOCKET_BUFFER;}
}


// Encoding  FALSE 츸 Ǵ Լ
// m_bEncodingFlag  FALSE϶ Sequence Number Ѵ.
void COverlapped::SetSequenceNumber(BYTE seq)
{
	if(m_bEncodingFlag == TRUE){ return;}
	*(lpBuff + SIZE_BODY_LENGTH + SIZE_ENCODE_FLAG) = seq;
}


// m_bEncodingFlag  TRUḚ m_bEncodedFlag TRUE϶ Ŷ  Sequence Number
// m_bEncodingFlag  FALSE϶ Ŷ  Sequence Number
BYTE COverlapped::GetSequenceNumber()
{
	return *(lpBuff + SIZE_BODY_LENGTH + SIZE_ENCODE_FLAG);
}

// Ŷ Encoding Ǿ θ 
BOOL COverlapped::IsPacketEncoded()
{
	return m_bEncodedFlag;
}

void COverlapped::EncodePacket(BYTE seq)
{
	if(m_bEncodedFlag == TRUE){ return;}

	if(m_bEncodingFlag == FALSE)
	{
		*(lpBuff+SIZE_BODY_LENGTH+SIZE_ENCODE_FLAG) = seq;
		return;
	}

	// XOR_N , 4, 8, 12, ... , 124
	BYTE XOR_N = (BYTE)(GetTickCount() % 30 + 1) * 4;

	//  , 
	BYTE checkSum = 0;
	int nDummyLen = seq%4;
	int woffset = SIZE_BODY_LENGTH;
	int roffset = SIZE_PACKET_HEADER;
	int xoffset = XOR_N;
	char *pBlock	= (char*)lpBuff;
	int nLength = m_WSABUF.len - SIZE_PACKET_HEADER;

	// size 
	*(unsigned short*)lpBuff
		= (unsigned short)(nLength + SIZE_CHECKSUM + nDummyLen);

	// encode flag 1B ϰ 
	BYTE encodeFlag = ENCODE_MASK | (XOR_N_MASK & XOR_N);
	*(BYTE*)(lpBuff+woffset) = encodeFlag;
	woffset += SIZE_ENCODE_FLAG;

	// sequence number(1B) XOR, , checksum  
	checkSum ^= seq;
	*(BYTE*)(lpBuff+woffset) = (seq ^ pXOR_ENCODE_BYTES[XOR_N-1]);
	woffset += SIZE_SEQ_NUM;

	// MSGs 4B XOR, checksum 
	int nEndValue = (int)(nLength / 4 + 1) * 4;
	DWORD checkSum_4B = 0;
	while (roffset < nEndValue)
	{
		checkSum_4B ^= *(DWORD*)(pBlock+roffset);
		*(DWORD*)(lpBuff+woffset)
			= *(DWORD*)(pBlock+roffset) ^ *(DWORD*)(pXOR_ENCODE_BYTES+xoffset);
		woffset += 4;
		roffset += 4;
		xoffset = (xoffset + 4) % SIZE_XOR_ENCODE_BYTES;
	}

	// 4B checkSum_4B 1B checkSum ȯ
	checkSum ^= ( *((char*)&checkSum_4B)
				^ *((char*)&checkSum_4B+1)
				^ *((char*)&checkSum_4B+2)
				^ *((char*)&checkSum_4B+3) );

	// ִ nLength - nEndValue ŭ ͸ ó -> XOR + checkSum
	for (int i = 0; i < nLength + 4 - nEndValue; i++)
	{
		checkSum ^= pBlock[roffset];
		lpBuff[woffset]
			= pBlock[roffset] ^ pXOR_ENCODE_BYTES[xoffset];
		woffset++;
		roffset++;
		xoffset = (xoffset + 1) % SIZE_XOR_ENCODE_BYTES;
	}

	// checksum ߰
	lpBuff[woffset++] =  checkSum ^ pXOR_ENCODE_BYTES[xoffset];

	// dummy data XOR_ENCODE_BYTES 
	char *dummyData = pXOR_ENCODE_BYTES + XOR_N;

	memcpy(lpBuff+woffset, dummyData, nDummyLen);
	woffset += nDummyLen;

	m_WSABUF.len = woffset;
	*(unsigned short*)lpBuff = woffset-SIZE_PACKET_HEADER;

	m_bEncodedFlag = TRUE;
}


void* COverlapped::operator new(size_t size)
{
	return CVMemPool::vmObjectNew(size);
}

void COverlapped::operator delete(void* p)
{
	CVMemPool::vmObjectDelete(p, sizeof(COverlapped));
}