#include "stdafx.h"
#include "atumparam.h"
#include "atumprotocol.h"
#include "AtumError.h"				// 2006-10-02 by cmkwon
#include <fstream>					// 2007-05-10 by cmkwon

#ifdef _ATUM_FIELD_SERVER
#include "FieldIOCPSocket.h"
#endif

#ifndef DBGOUT
#define	DBGOUT	(void(0))
#endif

///////////////////////////////////////////////////////////////////////////////
// Config Variables
///////////////////////////////////////////////////////////////////////////////
char	CONFIG_ROOT[1024];

///////////////////////////////////////////////////////////////////////////////
// String Conversion Functions
const char *DBG_GET_POSITION_STRING(D3DXVECTOR3& vec, string& str)
{
#ifdef _DEBUG
	char buffer[256];
	sprintf(buffer, "(%d, %d, %d)", (int)vec.x, (int)vec.y, (int)vec.z);
	str += buffer;

	return str.c_str();
#else
	return NULL;
#endif
}

const char *GetMapString(MAP_CHANNEL_INDEX &refMapChannelIndex, string &str)
{
	char buffer[512];
	sprintf(buffer, "%d(%d)", refMapChannelIndex.MapIndex, refMapChannelIndex.ChannelIndex);
	str += buffer;

	return str.c_str();
}

const char *GetCharacterString(const CHARACTER *pCharac, string &str)
{
	if (pCharac == NULL)
	{
		return "[NULL]";
	}

	char buffer[512];
	sprintf(buffer, "[A(%s:%d) C(%s:%d) CI(%d)]",
		pCharac->AccountName, pCharac->AccountUniqueNumber, pCharac->CharacterName, pCharac->CharacterUniqueNumber, pCharac->ClientIndex);
// 2007-07-18 by cmkwon,   -   
//	sprintf(buffer, "[A: %s, CH: %s, CI: %d, UN: %d]",
//		pCharac->AccountName, pCharac->CharacterName, pCharac->ClientIndex, pCharac->CharacterUniqueNumber);
	str += buffer;

	return str.c_str();
}

const char *GetItemString(const ITEM_BASE *pItem, string &str)
{
	if (pItem == NULL)
	{
		return "[NULL]";
	}

	char buffer[512];
	sprintf(buffer, "[N: %s, IN: %d, UN: %I64d]",
		pItem->ItemInfo->ItemName, pItem->ItemNum, pItem->UniqueNumber);
	str += buffer;

	return str.c_str();
}

const char *GetItemGeneralString(const ITEM_GENERAL *pItem, string &str)
{
	if (pItem == NULL)
	{
		return "[NULL]";
	}

	char buffer[512];
	// 2008-02-14 by cmkwon,   
	sprintf(buffer, "[IN:%d N:%10s UN:%I64d C:%d]",
		pItem->ItemNum, pItem->ItemInfo->ItemName, pItem->UniqueNumber, pItem->CurrentCount);
	str += buffer;

	return str.c_str();
}

const char *GetTimeString(string &str)
{
	char buffer[128];
	time_t ltime;
	struct tm *today = NULL;

	time(&ltime);
	today = localtime(&ltime);
	strftime(buffer, 128, "[%m-%d %H:%M:%S]", today );
	str += buffer;

	return str.c_str();
}

const char *GetItemSkillString(const ITEM_SKILL *pItem, string &str)
{
	if (pItem == NULL)
	{
		return "[NULL]";
	}

	char buffer[512];
	// 2008-02-14 by cmkwon,   
	sprintf(buffer, "[IN:%d N:%10s UN:%I64d]",
		pItem->ItemNum, pItem->ItemInfo->ItemName, pItem->UniqueNumber);
	str += buffer;

	return str.c_str();
}

const char *Int2String(int n, string &str)
{
	char buffer[64];
	sprintf(buffer, "%d", n);
	str += buffer;

	return str.c_str();
}

const char *GetRaceString(USHORT race)
{
	switch(race)
	{
	case RACE_BATTALUS:			return STRCMD_CS_COMMON_RACE_BATTALUS;
	case RACE_DECA:				return STRCMD_CS_COMMON_RACE_DECA;
	case RACE_PHILON:			return STRCMD_CS_COMMON_RACE_PHILON;
	case RACE_SHARRINE:			return STRCMD_CS_COMMON_RACE_SHARRINE;
// 2006-04-20 by cmkwon	case RACE_MONSTER1:			return STRCMD_CS_COMMON_RACE_MONSTER1;
	case RACE_INFLUENCE_LEADER:	return STRCMD_CS_COMMON_RACE_INFLUENCE_LEADER;			// 2006-04-20 by cmkwon
// 2006-12-08 by dhjin	case RACE_MONSTER2:			return STRCMD_CS_COMMON_RACE_MONSTER2;

// 2007-10-06 by cmkwon,  2 ȣĪ ٸ  -
//	case RACE_INFLUENCE_SUBLEADER: return STRCMD_CS_COMMON_RACE_INFLUENCE_SUBLEADER;	// 2006-12-08 by dhjin
//	case RACE_NPC:				return STRCMD_CS_COMMON_RACE_NPC;
	case RACE_INFLUENCE_SUBLEADER_1:	return STRCMD_CS_COMMON_RACE_INFLUENCE_SUBLEADER_1;	// 2007-10-06 by cmkwon,  2 ȣĪ ٸ  -
	case RACE_INFLUENCE_SUBLEADER_2:	return STRCMD_CS_COMMON_RACE_INFLUENCE_SUBLEADER_2;	// 2007-10-06 by cmkwon,  2 ȣĪ ٸ  -
	case RACE_OPERATION:		return STRCMD_CS_COMMON_RACE_OPERATION;
	case RACE_GAMEMASTER:		return STRCMD_CS_COMMON_RACE_GAMEMASTER;
	case RACE_MONITOR:			return STRCMD_CS_COMMON_RACE_MONITOR;
	case RACE_GUEST:			return STRCMD_CS_COMMON_RACE_GUEST;
	case RACE_DEMO:				return STRCMD_CS_COMMON_RACE_DEMO;
	case RACE_ALL:				return STRCMD_CS_COMMON_RACE_ALL;
	}

	return STRCMD_CS_COMMON_RACE_UNKNOWN;
}

char* Underbar2Space(char *string)
{
	int len = strlen(string);
	for (int i = 0; i < len && i < 128; i++)
	{
		if (string[i] == '_')
		{
			string[i] = ' ';
		}
	}

	return string;
}

bool operator<(const VersionInfo &v1, const VersionInfo &v2)
{
	if (v1.GetVersion()[0] != v2.GetVersion()[0])
	{
		return v1.GetVersion()[0] < v2.GetVersion()[0];
	}
	if (v1.GetVersion()[1] != v2.GetVersion()[1])
	{
		return v1.GetVersion()[1] < v2.GetVersion()[1];
	}
	if (v1.GetVersion()[2] != v2.GetVersion()[2])
	{
		return v1.GetVersion()[2] < v2.GetVersion()[2];
	}
	if (v1.GetVersion()[3] != v2.GetVersion()[3])
	{
		return v1.GetVersion()[3] < v2.GetVersion()[3];
	}
	
	return FALSE;
}

void PrintExchangeMsg(BYTE SendOrRecv, MessageType_t nType, char *peerIP, ENServerType st, BYTE printLevel)
{
#ifdef _DEBUG
	int bPrint = FALSE;

/*	if (HIBYTE(nType) == T0_FC_BATTLE)
	{
		//  !
		bPrint = TRUE;
	} else*/
	if (printLevel == PRINTLEVEL_NO_MSG)
	{
		return;
	}
	else if (printLevel == PRINTLEVEL_ALL)
	{
		bPrint = TRUE;
	}
	else if (printLevel == PRINTLEVEL_WO_ALIVE)
	{
		if (IS_ALIVE_MSG(nType))
		{
			return;
		}

		bPrint = TRUE;
	}
	else if (printLevel == PRINTLEVEL_WO_MOVE_BATTLE &&
		HIBYTE(nType) != T0_FC_MOVE &&
		HIBYTE(nType) != T0_FN_MOVE &&
		HIBYTE(nType) != T0_FN_MONSTER &&
		HIBYTE(nType) != T0_FC_BATTLE &&
		HIBYTE(nType) != T0_FN_BATTLE &&
		nType != T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP &&
		nType != T_FC_CHARACTER_CHANGE_BODYCONDITION &&
		nType != T_FN_MONSTER_CHANGE_HP &&
		nType != T_FC_STRING_128
	)
	{
		bPrint = TRUE;
	}
	else if (printLevel == PRINTLEVEL_A_FEW &&
//		HIBYTE(nType) == T0_FC_TRADE
//*
		(HIBYTE(nType) == T0_FC_PARTY ||
		HIBYTE(nType) == T0_IC_PARTY ||
		HIBYTE(nType) == T0_FI_PARTY)
		&&
		!(nType >= T_FC_PARTY_UPDATE_MEMBER_INFO_ALL &&
		nType <= T_FC_PARTY_UPDATE_MEMBER_INFO_BODYCONDITION)
//*/
	)
	{
		// PARTY ø 
		bPrint = TRUE;
	}
	else if (printLevel == PRINTLEVEL_FEW &&
		HIBYTE(nType) == T0_FI_ADMIN
	)
	{
		// ADMIN  
		bPrint = TRUE;
	}
	else
	{
		return;
	}

	// bPrint Ȯϱ
	if (!bPrint) return;

	char szTime[128];
	time_t ltime;
	struct tm *today = NULL;
	const char *st_string;

	st_string = GGetENServerTypeString(st);

	if (SendOrRecv == RECV_TYPE)
	{
		time(&ltime);
		today = localtime(&ltime);
		strftime(szTime, 128, "[%m-%d %H:%M:%S]", today );
		DBGOUT("%s RECV TYPE: %s(%#04x) from %s[%s]\n", szTime, GetProtocolTypeString(nType), nType, st_string, peerIP);
	}
	else if (SendOrRecv == SEND_TYPE)
	{
		time(&ltime);
		today = localtime(&ltime);
		strftime(szTime, 128, "[%m-%d %H:%M:%S]", today );
		DBGOUT("%s SEND TYPE: %s(%#04x) to %s[%s]\n", szTime, GetProtocolTypeString(nType), nType, st_string, peerIP);
	}
#endif

}

BYTE* GetIPAddressInBytes(char *i_szIPAddress, BYTE *o_pIPArray)
{
	char *token;
	char seps[] = ".";
	char buffer[SIZE_MAX_VERSION_STRING];
	STRNCPY_MEMSET(buffer, i_szIPAddress, SIZE_MAX_VERSION_STRING);

	token = strtok(buffer, seps); o_pIPArray[0] = (BYTE)atoi(token);
	token = strtok(NULL, seps); o_pIPArray[1] = (BYTE)atoi(token);
	token = strtok(NULL, seps); o_pIPArray[2] = (BYTE)atoi(token);
	token = strtok(NULL, seps); o_pIPArray[3] = (BYTE)atoi(token);

	return o_pIPArray;
}

const char *GetIPAddressString(BYTE *i_pIPArray, STRNBUF &i_strnbuf)
{
	sprintf(i_strnbuf.GetBuffer(), "%d.%d.%d.%d", i_pIPArray[0], i_pIPArray[1], i_pIPArray[2], i_pIPArray[3]);
	return i_strnbuf.GetBuffer();
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			char *GetMonsterBellString(BYTE i_byMonBell)
/// \brief		
/// \author		cmkwon
/// \date		2006-12-13 ~ 2006-12-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *GetMonsterBellString(BYTE i_byMonBell)
{
	switch(i_byMonBell)
	{
	case BELL_ATATTACK:						return "BELL_ATATTACK";
	case BELL_DEFENSE:						return "BELL_DEFENSE";
	case BELL_RETREAT:						return "BELL_RETREAT";
	case BELL_TAGETATATTACK:				return "BELL_TAGETATATTACK";
	case BELL_NOTATTACK:					return "BELL_NOTATTACK";
	case BELL_ATTACK_OUTPOST_PROTECTOR:		return "BELL_ATTACK_OUTPOST_PROTECTOR";

	case BELL_INFLUENCE_VCN:				return "BELL_INFLUENCE_VCN";
	case BELL_INFLUENCE_ANI:				return "BELL_INFLUENCE_ANI";
	case BELL_STRATEGYPOINT_VCN:			return "BELL_STRATEGYPOINT_VCN";
	case BELL_STRATEGYPOINT_ANI:			return "BELL_STRATEGYPOINT_ANI";
	case BELL_OUTPOST_PROTECTOR_VCN:		return "BELL_OUTPOST_PROTECTOR_VCN";
	case BELL_OUTPOST_PROTECTOR_ANI:		return "BELL_OUTPOST_PROTECTOR_ANI";
	case BELL_OUTPOST_RESET_VCN:			return "BELL_OUTPOST_RESET_VCN";
	case BELL_OUTPOST_RESET_ANI:			return "BELL_OUTPOST_RESET_ANI";
	case BELL_ONEY_ATTACK_INFLUENCE_VCN:	return "BELL_ONEY_ATTACK_INFLUENCE_VCN";
	case BELL_ONEY_ATTACK_INFLUENCE_ANI:	return "BELL_ONEY_ATTACK_INFLUENCE_ANI";
	}
	
	return "UNKNOWN_BELL";
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			const char *GetItemDesParameter(BYTE i_byDesParameter)
/// \brief		
/// \author		cmkwon
/// \date		2005-11-25 ~ 2005-11-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
const char *GetItemDesParameter(BYTE i_byDesParameter)
{
	switch(i_byDesParameter)
	{
	GET_CASERETURN_STRING_BY_TYPE(DES_NULL);
	GET_CASERETURN_STRING_BY_TYPE(DES_ATTACK_PART);
	GET_CASERETURN_STRING_BY_TYPE(DES_DEFENSE_PART);
	GET_CASERETURN_STRING_BY_TYPE(DES_FUEL_PART);
	GET_CASERETURN_STRING_BY_TYPE(DES_SOUL_PART);
	GET_CASERETURN_STRING_BY_TYPE(DES_SHIELD_PART);
	GET_CASERETURN_STRING_BY_TYPE(DES_DODGE_PART);
	GET_CASERETURN_STRING_BY_TYPE(DES_BODYCONDITION);
	GET_CASERETURN_STRING_BY_TYPE(DES_ENDURANCE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_ENDURANCE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_CHARGING_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_CHARGING_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_PROPENSITY);
	GET_CASERETURN_STRING_BY_TYPE(DES_HP);
	GET_CASERETURN_STRING_BY_TYPE(DES_DP);
	GET_CASERETURN_STRING_BY_TYPE(DES_SP);
	GET_CASERETURN_STRING_BY_TYPE(DES_EP);
	GET_CASERETURN_STRING_BY_TYPE(DES_SPRECOVERY);
	GET_CASERETURN_STRING_BY_TYPE(DES_HPRECOVERY);
	GET_CASERETURN_STRING_BY_TYPE(DES_MINATTACK_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_MAXATTACK_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_MINATTACK_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_MAXATTACK_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_ATTACKPROBABILITY_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_ATTACKPROBABILITY_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_DEFENSE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_DEFENSE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_DEFENSEPROBABILITY_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_DEFENSEPROBABILITY_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILLPROBABILITY_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILLPROBABILITY_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_FACTION_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_FACTION_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_FACTIONRESISTANCE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_FACTIONRESISTANCE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_SPEED);
	GET_CASERETURN_STRING_BY_TYPE(DES_TRANSPORT);
	GET_CASERETURN_STRING_BY_TYPE(DES_MATERIAL);
	GET_CASERETURN_STRING_BY_TYPE(DES_REATTACKTIME_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_REATTACKTIME_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_ABRASIONRATE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_ABRASIONRATE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_RANGE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_RANGE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_RANGEANGLE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_RANGEANGLE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_MULTITAGET_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_MULTITAGET_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_EXPLOSIONRANGE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_EXPLOSIONRANGE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_UNIT);
	GET_CASERETURN_STRING_BY_TYPE(DES_REVISION);
	GET_CASERETURN_STRING_BY_TYPE(DES_FACTIONPROBABILITY_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_FACTIONPROBABILITY_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_SHOTNUM_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_SHOTNUM_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_MULTINUM_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_MULTINUM_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_ATTACKTIME_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_ATTACKTIME_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_TIME_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_TIME_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_OVERHITTIME_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_OVERHITTIME_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_UNITKIND);
	GET_CASERETURN_STRING_BY_TYPE(DES_ITEMKIND);
	GET_CASERETURN_STRING_BY_TYPE(DES_SUMMON);
	GET_CASERETURN_STRING_BY_TYPE(DES_GRADUAL_HP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_GRADUAL_DP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_GRADUAL_SP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_GRADUAL_EP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_IN_TIME_HP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_IN_TIME_DP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_IN_TIME_SP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_IN_TIME_EP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_IMMEDIATE_HP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_IMMEDIATE_DP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_IMMEDIATE_SP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_IMMEDIATE_EP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_GROUNDMODE);
	GET_CASERETURN_STRING_BY_TYPE(DES_SIEGEMODE);
	GET_CASERETURN_STRING_BY_TYPE(DES_WEIGHT_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_WEIGHT_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_BULLET_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_BULLET_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_PRIMARY_WEAPON);
	GET_CASERETURN_STRING_BY_TYPE(DES_SECONDARY_WEAPON);
	GET_CASERETURN_STRING_BY_TYPE(DES_ALL_WEAPON);
	GET_CASERETURN_STRING_BY_TYPE(DES_CRITICALHITRATE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_CRITICALHITRATE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_WARP);
	GET_CASERETURN_STRING_BY_TYPE(DES_REACTION_RANGE);
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_FIX_NONE);
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_FIX_PREFIX);
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_FIX_SUFFIX);
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_FIX_BOTH);
	GET_CASERETURN_STRING_BY_TYPE(DES_REQ_MIN_LEVEL);
	GET_CASERETURN_STRING_BY_TYPE(DES_REQ_MAX_LEVEL);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_STAT_ALL_INITIALIZE);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_STAT_PART_INITIALIZE);
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_FIX_PREFIX_INITIALIZE);
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_FIX_SUFFIX_INITIALIZE);
	GET_CASERETURN_STRING_BY_TYPE(DES_ENCHANT_INITIALIZE);				// 2007-04-03 by cmkwon

	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_STEALTH);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_HP_AND_DP_UP);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_GUILD_ALL_MEMBERS_SUMMON);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_GUILD_MEMBER_SUMMON);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_NORMAL_RESTORE);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_SUPER_RESTORE);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_GUILD);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_MONSTER_SUMMON);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_CHANGE_CHARACTERNAME);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_SKILL_INITIALIZE);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_CHANGE_PILOTFACE);
	GET_CASERETURN_STRING_BY_TYPE(DES_CASH_CRACKER_CARD);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_REDUCE_SHIELD_DAMAGE);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_INVINCIBLE);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_BIG_BOOM);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_HALLUCINATION);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_RANGEDOWN_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_RANGEDOWN_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_PROHIBITION_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_PROHIBITION_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_ATTACK_RANGE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_ATTACK_RANGE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_INVISIBLE);
// 2005-12-02 by cmkwon	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_HYPERMOVING);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_DEFENSE_01);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_DEFENSE_02);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_FREEZINGBODY);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_REVERSECONTROL);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_GRADUAL_HPSHIELD_DOWN);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_SLOWMOVING);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_BOOSTEROFF);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_COLLISIONDAMAGE_DOWN);
//	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_CAMOUFLAGE);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_RANDOMTELEPORT);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_ATTACK_ALL);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_SCANNING);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_REVERSEENGINE);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_LOCKDOWN);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_STEALSP);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_SMARTSP);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_SUMMON_FORMATION_MEMBER);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_CANCEL_MAGIC);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_RANDOM_CANCEL);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_STOPMAGIC);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_CANCELALL);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_REACTIONSPEED);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_ENGINEANGLE);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_ENGINEBOOSTERANGLE);
	GET_CASERETURN_STRING_BY_TYPE(DES_DROP_EXP);
	GET_CASERETURN_STRING_BY_TYPE(DES_DROP_SPI);
	GET_CASERETURN_STRING_BY_TYPE(DES_DROP_ITEM);
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_ITEM_DROP_RATE);	// 238,2010-11-30 by shcho,   Ȯ   
	GET_CASERETURN_STRING_BY_TYPE(DES_HP_REPAIR_RATE_FLIGHTING);
	GET_CASERETURN_STRING_BY_TYPE(DES_DP_REPAIR_RATE);
	GET_CASERETURN_STRING_BY_TYPE(DES_SP_REPAIR_RATE);
	GET_CASERETURN_STRING_BY_TYPE(DES_BAZAAR_SELL);
	GET_CASERETURN_STRING_BY_TYPE(DES_BAZAAR_BUY);
	GET_CASERETURN_STRING_BY_TYPE(DES_KILLMARK_EXP);
	GET_CASERETURN_STRING_BY_TYPE(DES_HYPER_BOOSTER);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_CHAFF_HP);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_AIR_BOMBING);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_NO_WARNING);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_ROLLING_TIME);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_FULL_RECOVERY);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_CAMOUFLAGE);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_BARRIER);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_HYPERSHOT);
	GET_CASERETURN_STRING_BY_TYPE(DES_SKILL_SHIELD_PARALYZE);
	GET_CASERETURN_STRING_BY_TYPE(DES_WARHEAD_SPEED);			// 176, 2007-06-11 by cmkwon, ź ӵ
	GET_CASERETURN_STRING_BY_TYPE(DES_CHAT_ALL_INFLUENCE);		// 177		// 2007-08-09 by cmkwon,  ¿ ä ϱ - desparam ߰, 
	// 2008-09-22 by dhjin, ű þƮ
	GET_CASERETURN_STRING_BY_TYPE(DES_ENGINE_BOOSTER_TIME_UP);		// 178		// 2008-09-22 by dhjin, ν ð 
	GET_CASERETURN_STRING_BY_TYPE(DES_ENGINE_MAX_SPEED_UP);			// 179		// 2008-09-22 by dhjin,  Ϲݼӵ(ִ) 
	GET_CASERETURN_STRING_BY_TYPE(DES_ENGINE_MIN_SPEED_UP);			// 180		// 2008-09-22 by dhjin,  Ϲݼӵ(ּ) 
	GET_CASERETURN_STRING_BY_TYPE(DES_ENGINE_BOOSTER_SPEED_UP);		// 181		// 2008-09-22 by dhjin,  νͼӵ 
	GET_CASERETURN_STRING_BY_TYPE(DES_ENGINE_GROUND_SPEED_UP);		// 182		// 2008-09-22 by dhjin,  ӵ 
	GET_CASERETURN_STRING_BY_TYPE(DES_RADAR_OBJECT_DETECT_RANGE);	// 183		// 2008-09-22 by dhjin, ̴ ü  ݰ
	GET_CASERETURN_STRING_BY_TYPE(DES_PIERCE_UP_01);				// 184		// 2008-09-22 by dhjin, ⺻ Ǿ  ī
	GET_CASERETURN_STRING_BY_TYPE(DES_PIERCE_UP_02);				// 185		// 2008-09-22 by dhjin, ޹ Ǿ  ī
	GET_CASERETURN_STRING_BY_TYPE(DES_ENGINE_ANGLE_UP);				// 186		// 2008-09-30 by dhjin,  ȸ  ī
	GET_CASERETURN_STRING_BY_TYPE(DES_ENGINE_BOOSTERANGLE_UP);		// 187		// 2008-09-30 by dhjin,  ν ȸ  ī
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_ITEM_PARTNER_SPEED);		// 239,		// 2010-12-21 by jskim,  ̵ ӵ   
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_ITEM_PARTNER_DAMAGE);	// 240,		// 2010-12-21 by jskim, Ʈ    
	GET_CASERETURN_STRING_BY_TYPE(DES_RARE_ITEM_HPDP);				// 241,		// 2010-12-21 by jskim, HP, DP ŰƮ 뷮   
	}

	return "UNKNOWN_DES_PARAMETER";
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL GIsValidInfuenceType(BYTE i_byInfluenceTy)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-03 ~ 2005-12-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL GIsValidInfuenceType(BYTE i_byInfluenceTy)
{
	switch(i_byInfluenceTy)
	{
	case INFLUENCE_TYPE_NORMAL:
	case INFLUENCE_TYPE_VCN:
	case INFLUENCE_TYPE_ANI:
	case INFLUENCE_TYPE_RRP:
		break;
	default:
		{
			return FALSE;
		}
	}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			char *GGetLowerCase(char *o_szLowercaseSting, char *i_szString, int nMaxStringSize)
/// \brief		
/// \author		cmkwon
/// \date		2006-05-22 ~ 2006-05-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *GGetLowerCase(char *o_szLowercaseSting, char *i_szString, int nMaxStringSize)
{
	STRNCPY_MEMSET(o_szLowercaseSting, i_szString, nMaxStringSize);
	_strlwr(o_szLowercaseSting);
	return o_szLowercaseSting;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			int GDelimiterIndex(char *i_szStr, int i_nMinIndex)
/// \brief		
/// \author		cmkwon
/// \date		2006-04-12 ~ 2006-04-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
int GDelimiterIndex(char *i_szStr, int i_nMaxCount)
{
	if(i_nMaxCount >= strlen(i_szStr))
	{
		return strlen(i_szStr);
	}

	char *pBeforeStr = i_szStr;
	char *pCurStr = CharNext(pBeforeStr);
	while(pCurStr)
	{
		pBeforeStr	= pCurStr;
		pCurStr		= CharNext(pCurStr);
		int nCurCount = pCurStr - i_szStr;
		if(nCurCount == i_nMaxCount)
		{
			return nCurCount;
		}
		else if(nCurCount > i_nMaxCount)
		{
			return pBeforeStr - i_szStr;
		}
	}

	return 0;
}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// 2006-10-02 by cmkwon
int		g_nargvCount;
char	g_szArrargv[SIZE_MAX_ARGV_COUNT][SIZE_MAX_ARGV_PARAM_STRING_SIZE];

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GSetExcuteParameterList(int i_nParamCount, char ** i_ppszParamString)
/// \brief		
/// \author		cmkwon
/// \date		2006-10-02 ~ 2006-10-02
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GSetExcuteParameterList(int i_nParamCount, char ** i_ppszParamString)
{
	if(SIZE_MAX_ARGV_COUNT < i_nParamCount)
	{
		return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
	}

	g_nargvCount			= i_nParamCount;
	for(int i=0; i < g_nargvCount; i++)
	{
		STRNCPY_MEMSET(g_szArrargv[i], i_ppszParamString[i], SIZE_MAX_ARGV_PARAM_STRING_SIZE);
	}

	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		
/// \author		cmkwon
/// \date		2006-10-02 ~ 2006-10-02
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList(SEXCUTE_PARAMETER *io_pExeParam)
{
#ifdef _DEBUG
	return ERR_NO_ERROR;
#endif

	// 2008-04-25 by cmkwon,  / ߰  ߰ Ǿ ϴ  - [-ʼ] C_Exe1, C_Exe2   Ķ ó Լ ߰

#ifdef SERVICE_TYPE_KOREAN_SERVER_1
	return GCheckExcuteParameterList_Kor(io_pExeParam);
#endif

#ifdef SERVICE_TYPE_KOREAN_SERVER_2
	return GCheckExcuteParameterList_Kor2(io_pExeParam);
#endif

#ifdef SERVICE_TYPE_ENGLISH_SERVER_1
	return GCheckExcuteParameterList_Eng(io_pExeParam);
#endif

// 2007-12-21 by cmkwon, Gameforge(Europe) Ʈ ߰ - ߰
// 2008-12-22 by cmkwon,   ߰(Gameforge4D Ű, Ҿ, Żƾ) - Ʒ  3  ߰
//#if defined(SERVICE_TYPE_ENGLISH_SERVER_2) || defined(SERVICE_TYPE_GERMAN_SERVER_1)		// 2008-04-25 by cmkwon, Gameforge4D_Deu ߰ - 
// 2009-06-04 by cmkwon,   ߰(Gameforge4D , ξ) - 
//#if defined(SERVICE_TYPE_ENGLISH_SERVER_2) || defined(SERVICE_TYPE_GERMAN_SERVER_1) || defined(SERVICE_TYPE_TURKISH_SERVER_1) || defined(SERVICE_TYPE_FRENCH_SERVER_1) || defined(SERVICE_TYPE_ITALIAN_SERVER_1)
// 2010-11-01 by shcho,	   ߰(Gameforge4D ξ, ƸƼ) -  
//#if defined(SERVICE_TYPE_ENGLISH_SERVER_2) || defined(SERVICE_TYPE_GERMAN_SERVER_1) || defined(SERVICE_TYPE_TURKISH_SERVER_1) || defined(SERVICE_TYPE_FRENCH_SERVER_1) || defined(SERVICE_TYPE_ITALIAN_SERVER_1) || defined(SERVICE_TYPE_POLISH_SERVER_1) || defined(SERVICE_TYPE_SPANISH_SERVER_1)
#if defined(SERVICE_TYPE_ENGLISH_SERVER_2) || defined(SERVICE_TYPE_GERMAN_SERVER_1) || defined(SERVICE_TYPE_TURKISH_SERVER_1) || defined(SERVICE_TYPE_FRENCH_SERVER_1) || defined(SERVICE_TYPE_ITALIAN_SERVER_1) || defined(SERVICE_TYPE_POLISH_SERVER_1) || defined(SERVICE_TYPE_SPANISH_SERVER_1) || defined(SERVICE_TYPE_ARGENTINA_SERVER_1)
	return GCheckExcuteParameterList_Eng_Server_2(io_pExeParam);
#endif

#ifdef SERVICE_TYPE_VIETNAMESE_SERVER_1
	return GCheckExcuteParameterList_Viet(io_pExeParam);
#endif

	// 2007-05-15 by cmkwon, ߱ 	
#ifdef SERVICE_TYPE_CHINESE_SERVER_1
	return GCheckExcuteParameterList_Chn(io_pExeParam);
#endif

// 2008-05-02 by cmkwon, WinnerOnline_Tha ߰ϱ - 
#if defined(SERVICE_TYPE_THAI_SERVER_1) || defined(SERVICE_TYPE_SINGAPORE_1) || defined(SERVICE_TYPE_INDONESIA_SERVER_1)
	return GCheckExcuteParameterList_Tha(io_pExeParam);
#endif

// 2008-05-29 by cmkwon,   ߰(Innova_Rus þƾ ߰) - 
#ifdef SERVICE_TYPE_RUSSIAN_SERVER_1
	return GCheckExcuteParameterList_Rus(io_pExeParam);
#endif

// 2008-09-23 by cmkwon,   ߰(븸 Netpower_Tpe) - 
#ifdef SERVICE_TYPE_TAIWANESE_SERVER_1
	return GCheckExcuteParameterList_Tpe(io_pExeParam);
#endif

// 2008-12-03 by cmkwon,   ߰(Ϻ Arario_Jpn) - 
#ifdef SERVICE_TYPE_JAPANESE_SERVER_1
	return GCheckExcuteParameterList_Jpn(io_pExeParam);
#endif
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Kor(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		
/// \author		cmkwon
/// \date		2006-10-09 ~ 2006-10-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Kor(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 2 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}

			if(2 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[1], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	}
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Kor2(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		
/// \author		cmkwon
/// \date		2006-10-09 ~ 2006-10-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Kor2(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[20]	AccountName
			// argv[2]:	char[33]	MD5PWD
			// argv[3]: int			Seed			[0~
			// argv[4]:	int			ExcuteType
			// argv[5]:	char[21]	2007-03-29 by cmkwon, Yedang  Key
			// argv[6]:	char[20]	2007-06-05 by cmkwon, BirthYear - ⵵
			///////////////////////////////////////////////////////////////////////////////			
			if(7 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}

			// argv[1]
			_strlwr(g_szArrargv[1]);				// 2006-10-18 by cmkwon, ҹڷ 
			STRNCPY_MEMSET(io_pExeParam->o_szAccountName0, g_szArrargv[1], SIZE_MAX_ACCOUNT_NAME);
			
			// argv[2], argv[3]
			char szEncryptMutexName[1024];
			sprintf(szEncryptMutexName, "%s%s", g_szArrargv[2], g_szArrargv[3]);
			HANDLE hMutex = ::OpenMutex(MUTEX_ALL_ACCESS, TRUE, szEncryptMutexName);
			if(hMutex == NULL)
			{		
				return ERR_INVALID_EXCUTE_PARAMETER;
			}	
			CloseHandle(hMutex);		// 2006-10-19 by cmkwon, Լ (ReleaseMutex-->CloseHandle)

		}
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[20]	AccountName
			// argv[2]:	char[33]	MD5PWD
			// argv[3]: int			Seed			[0~
			// argv[4]:	int			ExcuteType
			// argv[5]:	char[21]	2007-03-29 by cmkwon, Yedang  Key
			// argv[6]:	char[20]	2007-06-05 by cmkwon, BirthYear - ⵵
			// argv[7]: char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(7 != g_nargvCount && 8 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}

			// argv[1]
			_strlwr(g_szArrargv[1]);				// 2006-10-18 by cmkwon, ҹڷ 
			STRNCPY_MEMSET(io_pExeParam->o_szAccountName0, g_szArrargv[1], SIZE_MAX_ACCOUNT_NAME);
			
			// argv[2], argv[3]
			char szEncryptMutexName[1024];
			sprintf(szEncryptMutexName, "%s%s", g_szArrargv[2], g_szArrargv[3]);
			HANDLE hMutex = ::OpenMutex(MUTEX_ALL_ACCESS, TRUE, szEncryptMutexName);
			if(hMutex == NULL)
			{		
				return ERR_INVALID_EXCUTE_PARAMETER;
			}	
			CloseHandle(hMutex);		// 2006-10-19 by cmkwon, Լ (ReleaseMutex-->CloseHandle)

			if(8 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[7], SIZE_MAX_IPADDRESS);
			}

			///////////////////////////////////////////////////////////////////////////////
			// 2007-06-05 by cmkwon, ⵵ ѱ
			io_pExeParam->o_nBirthYear	= atoi(g_szArrargv[6]);
		}
		break;
	case EXCUTE_FILE_TYPE_SC_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-09 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]: char[16]	FieldServer IP
			// argv[2]: int			FieldServer Port
			// argv[3]: char[16]	IMServer IP
			// argv[4]: int			IMServer Port
			// argv[5]: Width		ػ 
			// argv[6]: Height		ػ 
			// argv[7]: Degree		  (0 , 1 ߻ , 2 , 3 浹ó())
			// argv[8]:	char[20]	AccountName
			// argv[9]:	char[33]	MD5PWD
			// argv[10]:int			Seed			[0~
			// argv[11]:int			ExcuteType
			// argv[12]:char[20]	Reserve
			// argv[13]:char[20]	Reserve
			///////////////////////////////////////////////////////////////////////////////			
		}
		break;
	}
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Eng(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		
/// \author		cmkwon
/// \date		2006-10-09 ~ 2006-10-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Eng(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 2 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}

			if(2 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[1], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	}
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Eng_Server_2(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		// 2007-12-21 by cmkwon, Gameforge(Europe) Ʈ ߰ - GCheckExcuteParameterList_Eng_Server_2() ߰
/// \author		cmkwon
/// \date		2007-12-21 ~ 2007-12-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Eng_Server_2(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 2 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}

			if(2 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[1], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	}
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Viet(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		
/// \author		cmkwon
/// \date		2006-10-09 ~ 2006-10-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Viet(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 2 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}

			if(2 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[1], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	}
	return ERR_NO_ERROR;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Chn(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		
/// \author		cmkwon
/// \date		2006-10-09 ~ 2006-10-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Chn(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 2 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}

			if(2 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[1], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	}
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Tha(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		// 2008-05-02 by cmkwon, WinnerOnline_Tha ߰ϱ - GCheckExcuteParameterList_Tha() ߰
/// \author		cmkwon
/// \date		2008-05-02 ~ 2005-05-02
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Tha(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 2 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}
			
			if(2 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[1], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	}
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Rus(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		// 2008-05-29 by cmkwon,   ߰(Innova_Rus þƾ ߰) - GCheckExcuteParameterList_Rus() ߰
/// \author		cmkwon
/// \date		2008-05-29 ~ 2005-05-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Rus(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 2 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}
			
			if(2 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[1], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	}
	return ERR_NO_ERROR;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Tpe(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		// 2008-09-23 by cmkwon,   ߰(븸 Netpower_Tpe) - 
/// \author		cmkwon
/// \date		2008-09-23 ~ 2008-09-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Tpe(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-02 by cmkwon
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 2 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}
			
			if(2 == g_nargvCount)
			{// 2007-05-15 by cmkwon, PreServer IP ڸƮ ִ
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[1], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	}
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t GCheckExcuteParameterList_Jpn(SEXCUTE_PARAMETER *io_pExeParam)
/// \brief		// 2008-12-03 by cmkwon,   ߰(Ϻ Arario_Jpn) - 
/// \author		cmkwon
/// \date		2008-12-03 ~ 2008-12-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t GCheckExcuteParameterList_Jpn(SEXCUTE_PARAMETER *io_pExeParam)
{
	switch(io_pExeParam->i_nExcuteFileType)
	{
	case EXCUTE_FILE_TYPE_SC_EXE:	// ACEonline.atm
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2008-12-18 by cmkwon, Ϻ Arario ó  - 
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[20]	AccountName
			// argv[2]:	char[33]	Password
			// argv[3]:	char[301]	Session Key
			///////////////////////////////////////////////////////////////////////////////			
			if(4 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}
			
			STRNCPY_MEMSET(io_pExeParam->o_szAccountName0, g_szArrargv[1], SIZE_MAX_ACCOUNT_NAME);
			STRNCPY_MEMSET(io_pExeParam->o_szPassword, g_szArrargv[2], SIZE_MAX_PASSWORD_MD5_STRING);
			STRNCPY_MEMSET(io_pExeParam->o_szSessionKey, g_szArrargv[3], SIZE_MAX_WEBLOGIN_AUTHENTICATION_KEY);
		}
		break;
	case EXCUTE_FILE_TYPE_SC_LAUNCHER_ATM:	// Launcher.atm
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2008-12-18 by cmkwon, Ϻ Arario ó  - 
			// argv[0]: char[??]	  ̸
			// argv[1]:	char[20]	AccountName
			// argv[2]:	char[33]	Password
			// argv[3]:	char[301]	Session Key
			// argv[4]:	char[16]	2007-05-15 by cmkwon, PreServer IP
			///////////////////////////////////////////////////////////////////////////////			
			if(1 != g_nargvCount && 5 != g_nargvCount)
			{
				return ERR_INVALID_EXCUTE_PARAMETER_COUNT;
			}
			
			if(5 == g_nargvCount)
			{
				STRNCPY_MEMSET(io_pExeParam->o_szAccountName0, g_szArrargv[1], SIZE_MAX_ACCOUNT_NAME);
				STRNCPY_MEMSET(io_pExeParam->o_szPassword, g_szArrargv[2], SIZE_MAX_PASSWORD_MD5_STRING);
				STRNCPY_MEMSET(io_pExeParam->o_szSessionKey, g_szArrargv[3], SIZE_MAX_WEBLOGIN_AUTHENTICATION_KEY);
				STRNCPY_MEMSET(io_pExeParam->o_szPreServerIP0, g_szArrargv[4], SIZE_MAX_IPADDRESS);
			}
		}
		break;
	case EXCUTE_FILE_TYPE_SC_ATM:
		break;
	}
	return ERR_NO_ERROR;
}

Err_t GReadVersionInfoFile(VersionInfo *o_pLauncherVerInfo, SREG_DATA_EXE_2 *o_pRegDataExe2, char *i_szVersionInfoFileName)
{
	o_pLauncherVerInfo->SetVersion(0,0,0,0);
	o_pRegDataExe2->resetREG_DATA_EXE_2();


	const int	BUFF_SIZE = 1024;
	char		buff[BUFF_SIZE];
	const char	*token;
	char		seps[] = " \t";
	ifstream	fin;

	fin.open(i_szVersionInfoFileName);
	if (!fin.is_open())
	{
		return ERR_VERSIONINFO_FILE_NOT_FOUND;
	}

	while(TRUE)
	{
		memset(buff, 0x00, BUFF_SIZE);
		BOOL bFlagFileEnd = fin.getline(buff, BUFF_SIZE).eof();
		if (bFlagFileEnd == TRUE)
		{
			break;
		}

		token = strtok(buff, seps);
		if (token == NULL						// ignore blank lines
			|| strncmp(token, "#", 1) == 0		// ignore comments
			|| strncmp(token, "$", 1) == 0)		// ignore user defined variables
		{
			continue;
		}

		if (0 == stricmp(token, STRMSG_REG_KEY_NAME_LAUNCHER_VERSION))
		{
			token = strtok(NULL, seps);
			if (token)
			{
				o_pLauncherVerInfo->SetVersion(token);
			}
		}
		else if (0 == stricmp(token, STRMSG_REG_KEY_NAME_CLIENT_VERSION))
		{
			char *token = strtok(NULL, seps);
			if (token)
			{
				o_pRegDataExe2->ClientVersion.SetVersion(token);
			}
		}
		else if (0 == stricmp(token, STRMSG_REG_KEY_NAME_WINDOWDEGREE_NEW))
		{
// 2007-12-27 by cmkwon,    ߰ - Ʒ  
//			char *token = strtok(NULL, seps);
//			if (token)
//			{
//				o_pRegDataExe2->WindowDegree = atoi(token);
//			}
			char *token = strtok(NULL, "\t");
			if (token)
			{
				STRNCPY_MEMSET(o_pRegDataExe2->WindowDegree, token, SIZE_MAX_WINDOW_DEGREE_NAME);
			}
		}
		else if (0 == stricmp(token, STRMSG_REG_KEY_NAME_WINDOWMODE))
		{// 2008-01-03 by cmkwon,   ϱ - GReadVersionInfoFile()  ó ߰
			char *token = strtok(NULL, seps);
			if (token)
			{
				int nMode = atoi(token);
				if(0 != nMode)
				{
					o_pRegDataExe2->IsWindowMode	= TRUE;
				}
			}
		}
		else if (0 == stricmp(token, STRMSG_REG_KEY_NAME_ACCOUNT_NAME))
		{
			char *token = strtok(NULL, seps);
			if (token)
			{
				STRNCPY_MEMSET(o_pRegDataExe2->BeforeAccountName, token, SIZE_MAX_ACCOUNT_NAME);
			}
		}
		else if (0 == stricmp(token, STRMSG_REG_KEY_NAME_SERVER_GROUP_NAME))
		{
			char *token = strtok(NULL, seps);
			if (token)
			{
				STRNCPY_MEMSET(o_pRegDataExe2->SelectedServerGroupName, token, SIZE_MAX_SERVER_NAME);
			}
		}
	}
	fin.close();

	return ERR_NO_ERROR;
}

Err_t GLoadExe1VersionInfo(VersionInfo *o_pLauncherVerInfo, char *i_szVersionInfoFileName)
{
	VersionInfo lver;
	SREG_DATA_EXE_2 regDataExe2;
	regDataExe2.resetREG_DATA_EXE_2();
	Err_t errCode = GReadVersionInfoFile(&lver, &regDataExe2, i_szVersionInfoFileName);
	if(errCode != ERR_NO_ERROR)
	{
		return errCode;
	}

	*o_pLauncherVerInfo = lver;
	return ERR_NO_ERROR;
}

Err_t GLoadExe2VersionInfo(SREG_DATA_EXE_2 *o_pRegDataEXE2, char *i_szVersionInfoFileName)
{
	VersionInfo lver;
	SREG_DATA_EXE_2 regDataExe2;
	regDataExe2.resetREG_DATA_EXE_2();
	Err_t errCode = GReadVersionInfoFile(&lver, &regDataExe2, i_szVersionInfoFileName);
	if(errCode != ERR_NO_ERROR)
	{
		return errCode;
	}

	*o_pRegDataEXE2		= regDataExe2;
	return ERR_NO_ERROR;
}


Err_t GWriteVersionInfoFile(VersionInfo *i_pLauncherVerInfo, SREG_DATA_EXE_2 *i_pRegDataEXE2, char *i_szVersionInfoFileName)
{
	//   
	DeleteFile(i_szVersionInfoFileName);
	int nErr = GetLastError();
	SetLastError(0);
	
	//  
	HANDLE hFile = INVALID_HANDLE_VALUE;
	hFile = CreateFile(i_szVersionInfoFileName, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL);
	if (INVALID_HANDLE_VALUE == hFile)
	{
		int nErr = GetLastError();
		SetLastError(0);
		return ERR_VERSIONINFO_FILE_CAN_NOT_CREATE;
	}

	const int	BUFF_SIZE = 1024;
	char		buff[BUFF_SIZE];
	DWORD		nWritten;

	sprintf(buff, "###############################################################################\r\n");
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
	sprintf(buff, "#  %s			0.0.0.0\r\n#\r\n", STRMSG_REG_KEY_NAME_LAUNCHER_VERSION);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
	sprintf(buff, "#  %s			0.0.0.0\r\n", STRMSG_REG_KEY_NAME_CLIENT_VERSION);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
// 2007-12-27 by cmkwon,    ߰ - Ʒ  
//	sprintf(buff, "#  %s				0\r\n#\r\n", STRMSG_REG_KEY_NAME_WINDOWDEGREE);
	sprintf(buff, "#  %s			1024x768 (high)\r\n#\r\n", STRMSG_REG_KEY_NAME_WINDOWDEGREE_NEW);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
	
	// 2008-01-03 by cmkwon,   ϱ - 
	sprintf(buff, "#  %s				0\r\n#\r\n", STRMSG_REG_KEY_NAME_WINDOWMODE);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);

	sprintf(buff, "#  %s				Mir\r\n", STRMSG_REG_KEY_NAME_ACCOUNT_NAME);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
	sprintf(buff, "#  %s			ACE\r\n", STRMSG_REG_KEY_NAME_SERVER_GROUP_NAME);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
	sprintf(buff, "###############################################################################\r\n\r\n");
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);

	sprintf(buff, "%s\t\t\t%s\r\n\r\n", STRMSG_REG_KEY_NAME_LAUNCHER_VERSION, i_pLauncherVerInfo->GetVersionString());
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);

	sprintf(buff, "%s\t\t\t%s\r\n", STRMSG_REG_KEY_NAME_CLIENT_VERSION, i_pRegDataEXE2->ClientVersion.GetVersionString());
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
// 2007-12-27 by cmkwon,    ߰ -
//	sprintf(buff, "%s\t\t\t%d\r\n\r\n", STRMSG_REG_KEY_NAME_WINDOWDEGREE, i_pRegDataEXE2->WindowDegree);
	sprintf(buff, "%s\t\t\t%s\r\n\r\n", STRMSG_REG_KEY_NAME_WINDOWDEGREE_NEW, i_pRegDataEXE2->WindowDegree);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
	
	// 2008-01-03 by cmkwon,   ϱ - 
	sprintf(buff, "%s\t\t\t\t%d\r\n\r\n", STRMSG_REG_KEY_NAME_WINDOWMODE, i_pRegDataEXE2->IsWindowMode);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);

	sprintf(buff, "%s\t\t\t\t%s\r\n", STRMSG_REG_KEY_NAME_ACCOUNT_NAME, i_pRegDataEXE2->BeforeAccountName);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
	sprintf(buff, "%s\t\t\t%s\r\n", STRMSG_REG_KEY_NAME_SERVER_GROUP_NAME, i_pRegDataEXE2->SelectedServerGroupName);
	WriteFile(hFile, buff, strlen(buff), &nWritten, NULL);
	
	CloseHandle(hFile);		//  ݱ
	return ERR_NO_ERROR;
}

Err_t GSaveExe1VersionInfo(VersionInfo *i_pLauncherVerInfo, char *i_szVersionInfoFileName)
{
	VersionInfo lver;
	SREG_DATA_EXE_2 regDataExe2;
	regDataExe2.resetREG_DATA_EXE_2();
	Err_t errCode = GReadVersionInfoFile(&lver, &regDataExe2, i_szVersionInfoFileName);
		
	lver = *i_pLauncherVerInfo;
	return GWriteVersionInfoFile(&lver, &regDataExe2, i_szVersionInfoFileName);
}

Err_t GSaveExe2VersionInfo(SREG_DATA_EXE_2 *i_pRegDataEXE2, char *i_szVersionInfoFileName)
{
	VersionInfo lver;
	SREG_DATA_EXE_2 regDataExe2;
	regDataExe2.resetREG_DATA_EXE_2();
	Err_t errCode = GReadVersionInfoFile(&lver, &regDataExe2, i_szVersionInfoFileName);
	
	regDataExe2 = *i_pRegDataEXE2;
	return GWriteVersionInfoFile(&lver, &regDataExe2, i_szVersionInfoFileName);
}


//
/////////////////////////////////////////////////////////////////////////
//// User-Friedly Map Name Ҵ -> check: ð config ű!
/////////////////////////////////////////////////////////////////////////
//#define MAP_0101			"Stone's ruin"
//#define MAP_0102			"Tyrant of Giantjungle"
//#define MAP_0103			"Enigmatic sand"
//#define MAP_0104			"Steep Giantjungle"
//#define MAP_0105			"Land of Severe Cold"
//#define MAP_0106			"ATUM [Deca city]"
//#define MAP_NONAME			""
//
//const char *GetUserFriendlyMapName(MapIndex_t MapIndex)
//{
//	if (MapIndex == 0101)
//	{
//		return MAP_0101;
//	}
//	else if (MapIndex == 0102)
//	{
//		return MAP_0102;
//	}
//	else if (MapIndex == 0103)
//	{
//		return MAP_0103;
//	}
//	else if (MapIndex == 0104)
//	{
//		return MAP_0104;
//	}
//	else if (MapIndex == 0105)
//	{
//		return MAP_0105;
//	}
//	else if (MapIndex == 0106)
//	{
//		return MAP_0106;
//	}
//	else
//	{
//		return MAP_NONAME;
//	}
//
//	return MAP_NONAME;
//}

///////////////////////////////////////////////////////////////////////////////
// 2008-04-25 by cmkwon,  / ߰  ߰ Ǿ ϴ  - [-ʼ] AdminTool, DBTool, Monitor    Ʈ 

// 2006-01-09 by cmkwon, EP2 ؼ DB 
//						atum_db_account			--> atum2_db_account
//						atum_db_[n]				--> atum2_db_[n]
//						atum_db_account_test	--> atum2_db_account_test
//						atum_db_test			--> atum2_db_test
#ifndef _ATUM_CLIENT
GAME_SERVER_INFO_FOR_ADMIN g_arrGameServers[] = 
{
	// 2007-11-07 by cmkwon, α DB   ϱ - ʵ 4 ߰, LogDBIP, LogDBPort, LogDBUID, LogDBPWD
	// {Name, XOREncodedPreServerIP, XOREncodedDBServerIP, DBServerPort, XOREncodedDBUserID, XOREncodedDBPWD, DB Name, LogDBIP, LogDBPort, LogDBUID, LogDBPWD, PreServerIP, DBServerIP, DBUserID, DBPWD}
	// 2007-10-24 by cmkwon,   ȣȭ - Key
	// #define STR_XOR_KEY_STRING_SERVER_INFO			"~8xANs(^fP{)34$(fcbTN$(C-=x"	// 2007-10-24 by cmkwon,   ȣȭ - DB Server Password XOR Key

// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
//#ifdef _ATUM_ADMIN_RELEASE

#if defined(SERVICE_TYPE_KOREAN_SERVER_1)
	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.140(4F0A496F7F401C7057614F07020014), 121.134.114.140(4F0A496F7F401C7057614F07020014), atum(1F4C0D2C), callweb(1D59142D39164A)
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.140(48095672775D1969567E4A1D03)
	//{"MS140(Masang_Kor)_(atum2_db_account)",				"48095672775D1969567E4A1D03", "48095672775D1969567E4A1D03", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D03", 9979, "1F4C0D2C",	"1D59142D39164A"},
	// 2008-08-20 by cmkwon, 
	//{"MS140(Masang)_Kor(atum2_db_account_test)",		"4F0A496F7F401C7057614F07020014", "4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2008-04-30 by cmkwon, ׽Ʈ ߰  
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.150(48095672775D1969567E4A1C03)
	// PreServerIP	: 121.134.114.150	- 4F0A496F7F401C7057614F07020114
	//{"MS150(Masang_Kor)_(atum2_db_account)",		"48095672775D1969567E4A1C03", "48095672775D1969567E4A1C03", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1C03", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2010-01-21 by cmkwon,  FGT غ - 
	// PreServerIP		: 112.107.1.31	- 4F094A6F7F431F70577E4818
	// DBServerIP		: 112.107.1.33	- 4F094A6F7F431F70577E481A
	// DBServerPort		: 9979
	// DB User			: atum			- 1F4C0D2C
	// DB PWD			: callweb		- 1D59142D39164A
	//{"Yedang_FGT(atum2_db_1)",		"4F094A6F7F431F70577E4818", "4F094A6F7F431F70577E481A", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F094A6F7F431F70577E481A", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2010-02-04 by cmkwon,  EP4   - 61.39.170.191(48095672775D1969567E4A1002)
	// PreServerIP		: 61.39.170.191	- 48095672775D1969567E4A1002
	// DBServerIP		: 61.39.170.191	- 48095672775D1969567E4A1002
	// DBServerPort		: 9979
	// DB User			: atum			- 1F4C0D2C
	// DB PWD			: callweb		- 1D59142D39164A
	//{"MS191(Masang_EP4)_(atum2_db_account)",			"48095672775D1969567E4A1002", "48095672775D1969567E4A1002", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1002", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2010-02-04 by cmkwon,  EP4   - 61.39.170.153(48095672775D1969567E4A1C00)
	// PreServerIP		: 61.39.170.153	- 48095672775D1969567E4A1C00
	// DBServerIP		: 61.39.170.153	- 48095672775D1969567E4A1C00
	// DBServerPort		: 9979
	// DB User			: atum			- 1F4C0D2C
	// DB PWD			: callweb		- 1D59142D39164A
	//{"MS153(Masang_Kor)_(atum2_db_account)",				"48095672775D1969567E4A1C00", "48095672775D1969567E4A1C00", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1C00", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2010-02-04 by cmkwon,  EP4   - 61.39.170.158(48095672775D1969567E4A1C0B)
	// PreServerIP		: 61.39.170.158	- 48095672775D1969567E4A1C0B
	// DBServerIP		: 61.39.170.158	- 48095672775D1969567E4A1C0B
	// DBServerPort		: 9979
	// DB User			: atum			- 1F4C0D2C
	// DB PWD			: callweb		- 1D59142D39164A
	//{"MS158(Masang_Kor)_(atum2_db_account)",				"48095672775D1969567E4A1C0B", "48095672775D1969567E4A1C0B", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1C0B", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2010-09-06 by hsLee,  EP4   - 61.39.170.151(48095672775D1969567E4A1C02)
	// PreServerIP		: 61.39.170.151	- 48095672775D1969567E4A1C02
	// DBServerIP		: 61.39.170.140	- 48095672775D1969567E4A1D03
	// DBServerPort		: 9979
	// DB User			: atum			- 1F4C0D2C
	// DB PWD			: callweb		- 1D59142D39164A
	//{"MS151(Masang_Kor)_(atum2_db_account)",				"48095672775D1969567E4A1C02", "48095672775D1969567E4A1D03", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D03", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2011-05-18 by hskim,  ӽ  - 61.39.170.134(48095672775D1969567E4A1A07)	
	// PreServerIP		: 61.39.170.134	- 48095672775D1969567E4A1A07
	// DBServerIP		: 61.39.170.238	- 48095672775D1969567E491A0B	
	// DBServerPort		: 9979
	// DB User			: atum			- 1F4C0D2C
	// DB PWD			: callweb		- 1D59142D39164A
	//{"MS134(Masang_Kor)_(atum2_db_account)",				"48095672775D1969567E4A1A07", "48095672775D1969567E491A0B", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491A0B", 9979, "1F4C0D2C",	"1D59142D39164A"},

	{"Combat-Rivals - Live Server",		"4C0D56707845066B5F7E4A1B00", "4C0D56707845066B5F7E4A1B00", 1433, "2D79",	"2A504B123A435A2756363D1D43",		"atum2_db_1", "4C0D56707845066B5F7E4A1B00", 1433, "2D79",	"2A504B123A435A2756363D1D43"},
	{"Combat-Rivals - Test Server",		"4F0A4F6F7E5D187057", "4F0A4F6F7E5D187057", 1433, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "4F0A4F6F7E5D187057", 1433, "1F4C0D2C",	"1D59142D39164A"},

	
#endif // END - #if defined(SERVICE_TYPE_KOREAN_SERVER_1)


#ifdef SERVICE_TYPE_KOREAN_SERVER_2		// 2006-09-05 by cmkwon
	// 2007-10-24 by cmkwon,   ȣȭ - 112.107.1.13(4F094A6F7F431F70577E4A1A), 211.189.116.12(4C09496F7F4B117057614D070206), 211.189.116.16(4C09496F7F4B117057614D070202), atum(1F4C0D2C), dpdltm@@tjdrhdgkwk$$!!(1A481C2D3A1E681E123A1F5B5B504343110846706F05)
	// 2007-12-07 by cmkwon,   Ʈ   
	// 2008-04-16 by cmkwon,  å  DB Server   缳 (192.168.2.64<==211.189.116.12, 192.168.2.63<==211.189.116.16)
	// 2008-04-30 by cmkwon,  DB Server IP, Port (<==192.168.2.64,9979)
	// 2009-04-15 by cmkwon,   DB Server IP  - 192.168.21.66(<--192.168.2.66), 192.168.21.63(<--192.168.2.63)
	// PreServerIP		: 112.107.1.13				- 4F094A6F7F431F70577E4A1A						// 2009-02-16 by dhjin,  IDC (211.189.116.13 - 4C09496F7F4B117057614D070207)
	// DBServerIP		: 192.168.21.66				- 4F014A6F7F4510705461551F05
	// DBServerPort		: 1456
	// DB User			: superold					- 0D4D08243C1C443A								// 2008-09-04 by cmkwon,  ,׼ DB    - 
	// DB PWD			: shdls$$rpdla!!			- 0D501C2D3D570C2C163417481215					// 2008-09-04 by cmkwon,  ,׼ DB    - 
	// LogDBServerIP	: 192.168.21.63				- 4F014A6F7F4510705461551F00
	// LogDBServerPort	: 1456
	// DB User			: superold					- 0D4D08243C1C443A								// 2008-09-04 by cmkwon,  ,׼ DB    - 
	// DB PWD			: shdls$$rpdlafhrm!!		- 0D501C2D3D570C2C16341748555C56454742			// 2008-09-04 by cmkwon,  ,׼ DB    - 
	{" - 01_ī(atum2_db_1)",					"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_1",	"4F014A6F7F4510705461551F00", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C16341748555C56454742"},
	{" - 02_(atum2_db_7)",					"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_7",	"4F014A6F7F4510705461551F00", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C16341748555C56454742"},
	{" - ȸ(atum2_db_20)",				"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_20",	"4F014A6F7F4510705461551F00", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C16341748555C56454742"},		// 2007-05-09 by cmkwon, ߰

	// 2007-10-24 by cmkwon,   ȣȭ - 112.107.1.11(4F094A6F7F431F70577E4A18), 112.107.1.17(4F094A6F7F431F70577E4A1E), atum(1F4C0D2C), tmzk!@Wkd(0A55022A6F337F3502)
	// PreServerIP		: 112.107.1.11				- 4F094A6F7F431F70577E4A18					// 2009-02-16 by dhjin,  IDC (211.189.116.11 - 4C09496F7F4B117057614D070205)
	// DBServerIP		: 112.107.1.17				- 4F094A6F7F431F70577E4A1E					// 2009-02-16 by dhjin,  IDC (211.189.116.17 - 4C09496F7F4B117057614D070203)
	// DBServerPort		: 9979
	// DB User			: superoldtest				- 0D4D08243C1C443A1235085D						// 2008-09-04 by cmkwon,  ,׼ DB    - 
	// DB PWD			: shdls$$rpdlaxptmxm!!		- 0D501C2D3D570C2C163417484B4450451E0E4375		// 2008-09-04 by cmkwon,  ,׼ DB    - 
	// LogDBServerIP	: 112.107.1.17				- 4F094A6F7F431F70577E4A1E					// 2009-02-16 by dhjin,  IDC (211.189.116.17 - 4C09496F7F4B117057614D070203)
	// LogDBServerPort	: 9979
	// DB User			: superoldtest				- 0D4D08243C1C443A1235085D						// 2008-09-04 by cmkwon,  ,׼ DB    - 
	// DB PWD			: shdls$$rpdlaxptmxm!!		- 0D501C2D3D570C2C163417484B4450451E0E4375		// 2008-09-04 by cmkwon,  ,׼ DB    - 
	{"׼ - ׽Ʈ1(atum2_db_1)",		"4F094A6F7F431F70577E4A18", "4F094A6F7F431F70577E4A1E", 9979, "0D4D08243C1C443A1235085D",	"0D501C2D3D570C2C163417484B4450451E0E4375",	"atum2_db_1", "4F094A6F7F431F70577E4A1E", 9979, "0D4D08243C1C443A1235085D",	"0D501C2D3D570C2C163417484B4450451E0E4375"},
	{"׼ - ׽Ʈ2(atum2_db_2)",		"4F094A6F7F431F70577E4A18", "4F094A6F7F431F70577E4A1E", 9979, "0D4D08243C1C443A1235085D",	"0D501C2D3D570C2C163417484B4450451E0E4375",	"atum2_db_2", "4F094A6F7F431F70577E4A1E", 9979, "0D4D08243C1C443A1235085D",	"0D501C2D3D570C2C163417484B4450451E0E4375"},
	{"׼ - ׽Ʈ3(atum2_db_3)",		"4F094A6F7F431F70577E4A18", "4F094A6F7F431F70577E4A1E", 9979, "0D4D08243C1C443A1235085D",	"0D501C2D3D570C2C163417484B4450451E0E4375",	"atum2_db_3", "4F094A6F7F431F70577E4A1E", 9979, "0D4D08243C1C443A1235085D",	"0D501C2D3D570C2C163417484B4450451E0E4375"},

	{"() - 05_(atum2_db_8)",			"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_8", "4F014A6F7F4510705461551F00", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C16341748555C56454742"},
	{"() - 06_(atum2_db_9)",			"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_9", "4F014A6F7F4510705461551F00", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C16341748555C56454742"},

	// 2007-12-13 by cmkwon,  DB ߰
	{"() - 01_ī(atum2_db_1_bak)",		"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_1_bak", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215"},
	{"() - 02_(atum2_db_7_bak)",		"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_7_bak", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215"},

	// 2007-10-24 by cmkwon,   ȣȭ - 211.189.116.13(4C09496F7F4B117057614D070207), 211.189.116.12(4C09496F7F4B117057614D070206), atum(1F4C0D2C), dpdltm!@eoqkr(1A481C2D3A1E091E033F0A4241)
	{"() - <200701>Ż(atum2_db_2)",	"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_2", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215"},
	{"() - <200701>(atum2_db_3)",		"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_3", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215"},
	{"() - <200701>(atum2_db_4)",		"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_4", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215"},
	{"() - <200803>ī(atum2_db_5)",		"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_5", "4F014A6F7F4510705461551F00", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215"},
	{"() - <200803>ī(atum2_db_6)",		"4F094A6F7F431F70577E4A1A", "4F014A6F7F4510705461551F05", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_6", "4F014A6F7F4510705461551F00", 1456, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215"},

	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.141(4F0A496F7F401C7057614F07020015), 121.134.114.141(4F0A496F7F401C7057614F07020015), atum(1F4C0D2C), callweb(1D59142D39164A)
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.141(48095672775D1969567E4A1D02)
	{"MS141(Yedang_Kor)_(atum2_db_account)",				"48095672775D1969567E4A1D02", "48095672775D1969567E4A1D02", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D02", 9979, "1F4C0D2C",	"1D59142D39164A"},			// 2006-09-21 by cmkwon
	// 2008-08-20 by cmkwon, 
	//{"MS141(Yedang)_Kor(atum2_db_account_test)",		"4F0A496F7F401C7057614F07020015", "4F0A496F7F401C7057614F07020015", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020015", 9979, "1F4C0D2C",	"1D59142D39164A"},		// 2006-09-21 by cmkwon

	// 2011-10-10 by shcho, QA_SERVER  ߰
	// PreServerIP		: 112.107.1.6				- 4F094A6F7F431F70577E4D
	// DBServerIP		: 112.107.1.7				- 4F094A6F7F431F70577E4C
	// DBServerPort		: 9979
	// DB User			: superold					- 0D4D08243C1C443A								// 2008-09-04 by cmkwon,  ,׼ DB    - 
	// DB PWD			: shdls$$rpdla!!			- 0D501C2D3D570C2C163417481215					// 2008-09-04 by cmkwon,  ,׼ DB    - 
	// 2007-10-24 by cmkwon,   ȣȭ - Key
	// #define STR_XOR_KEY_STRING_SERVER_INFO			"~8xANs(^fP{)34$(fcbTN$(C-=x"	// 2007-10-24 by cmkwon,   ȣȭ - DB Server Password XOR Key
	
	// {Name,										XOREncodedPreServerIP,		XOREncodedDBServerIP, DBServerPort, XOREncodedDBUserID,		 XOREncodedDBPWD,							DB Name,			LogDBIP,			LogDBPort,  LogDBUID,	LogDBPWD, PreServerIP, DBServerIP, DBUserID, DBPWD}
	{"YD_QA_SERVER_(atum2_db_account)",				"4F094A6F7F431F70577E4D", "4F094A6F7F431F70577E4C", 9979, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215",	"atum2_db_1",		"4F094A6F7F431F70577E4C", 9979, "0D4D08243C1C443A",	"0D501C2D3D570C2C163417481215"},
	// end 2011-10-10 by shcho, QA_SERVER  ߰

#endif// #ifdef SERVICE_TYPE_KOREAN_SERVER_2
#ifdef SERVICE_TYPE_ENGLISH_SERVER_1
	// 2008-08-05 by cmkwon, WikiGames_Eng    - 
	// 2009-09-02 by cmkwon, WikiGames  IP  - 
	// PreServerIP		: 10.10.133.35				- 4F0856707E5D196D557E481C
	// DBServerIP		: 10.10.133.30				- 4F0856707E5D196D557E4819
	// DBServerPort		: 1433
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: 5278WIKIg$box				- 4B0A4F79193A6317017419464B
	// LogDBServerIP	: 10.10.133.30				- 4F0856707E5D196D557E4819
	// LogDBServerPort	: 1433
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: 5278WIKIg$box				- 4B0A4F79193A6317017419464B
	{"Main DB",		"4F0A4F6F7E5D187057", "4F0A4F6F7E5D187057", 1433, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "4F0A4F6F7E5D187057", 1433, "1F4C0D2C",	"1D59142D39164A"},
	//{"Main      - Server3     (atum2_db_3)",		"4F0856707E5D196D557E481C", "4F0856707E5D196D557E4819", 1433, "1F4C0D2C",	"4B0A4F79193A6317017419464B",		"atum2_db_3", "4F0856707E5D196D557E4819", 1433, "1F4C0D2C",	"4B0A4F79193A6317017419464B"},

    //2010-05-24 by shcho, 	WikiGames_Eng IP
 	// PreServerIP		: 10.10.10.40			    - 4F0856707E5D196E48644B   //  208.68.90.122
	// DBServerIP		: 10.10.10.22			    - 4F0856707E5D196E486249   //  208.68.90.109
	// DBServerPort		: 1433
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: 5278WIKIg$box				- 4B0A4F79193A6317017419464B
	// LogDBServerIP	: 10.10.10.22				- 1A1D48507E5D5718705462   //  208.68.90.109
	// LogDBServerPort	: 1433
	// DB User			: atum						- 1F4C0D2C
	//{"Test      - TestServer(atum2_db_1)",		"4F0856707E5D196E48644B", "4F0856707E5D196E486249", 1433, "1F4C0D2C",	"4B0A4F79193A6317017419464B",		"atum2_db_1", "4F0856707E5D196E486249", 1433, "1F4C0D2C",	"4B0A4F79193A6317017419464B"},

	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.142(4F0A496F7F401C7057614F07020016), 121.134.114.142(4F0A496F7F401C7057614F07020016), atum(1F4C0D2C), callweb(1D59142D39164A)
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.142(48095672775D1969567E4A1D01)
	//{"MS142(Wikigames_Eng)_(atum2_db_account)",		"48095672775D1969567E4A1D01", "48095672775D1969567E4A1D01", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D01", 9979, "1F4C0D2C",	"1D59142D39164A"},
	// 2008-08-20 by cmkwon, 
	//{"MS142(Yedang-Global)_Eng(atum2_db_account_test)",	"4F0A496F7F401C7057614F07020016", "4F0A496F7F401C7057614F07020016", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020016", 9979, "1F4C0D2C",	"1D59142D39164A"},
#endif// #ifdef SERVICE_TYPE_ENGLISH_SERVER_1
#ifdef SERVICE_TYPE_CHINESE_SERVER_1

// 2009-01-21 by cmkwon, ߱  α  ΰ(net, cnc)   -  Ʈ ּ ó
// // 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - Ʒ  
// //	// 2007-04-12 by cmkwon, ߰
// //	// 2007-09-19 by cmkwon, NET DB   - db_1->db_11, db_2->db_12, ...
// //	// 2007-10-24 by cmkwon,   ȣȭ - 222.73.108.92(4C0A4A6F7940066F5668551001), 222.73.108.101(4C0A4A6F7940066F566855180305), atum(1F4C0D2C), tmzk!@Wkd(0A55022A6F337F3502)
// //	// 2008-03-13 by cmkwon, йȣ 
// //	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// //	{"NET1 1 (db_1) - db(11+15)",				"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_1", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"NET1 2 (db_2) - db(12+14+17)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_2", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"NET1 3 (db_3) - db(13+16+18)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_3", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1 1 (db_11)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_11", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1 2 (db_12)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_12", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1 3 (db_13)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_13", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1 4 (db_14)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_14", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1 5 (db_15)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_15", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1 6 (db_16)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_16", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1 7 (db_17)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_17", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1 8 (db_18)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_18", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	// 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - NET1 (4 <== 1 + 2 + 3)
// 	// 2008-06-19 by cmkwon, Yetime_Chn PreServer, DBServer IP ٽ  IP  - 
// 	// 2008-09-23 by cmkwon, ߱ Yetime_Chn  α   ߰ - 
// 	// 2008-11-13 by cmkwon, ߱ Yetime_Chn   - Net1 4 ű  ߰
// 	// 2008-11-26 by cmkwon, ߱ Yetime_Chn   - Net1 3  ߰
// 	// PreServerIP		: 222.73.108.92				- 4C0A4A6F7940066F5668551001
// 	// DBServerIP		: 222.73.72.154				- 4C0A4A6F79400669547E4A1C07	// 2009-01-05 by dhjin, 222.73.108.101->222.73.72.154 
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 222.73.72.154				- 4C0A4A6F79400669547E4A1C07	// 2009-01-05 by dhjin, 222.73.108.101->222.73.72.154 
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	{"NET1-1        - db_4(1+2+3)",				"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_4", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"NET1-6        - db_5(20080707)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_5", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-07-07 by dhjin
// 	{"NET1-7        - db_13(20081113)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_13", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"NET1-8        - db_14(20081113)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_14", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"NET1-9        - db_15(20081113)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_15", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"NET1-10       - db_16(20081113)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_16", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"NET1-11       - db_11(20081126)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_11", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-11-26 by cmkwon, ߱ Yetime_Chn   - ߰
// 	{"NET1-12       - db_12(20081126)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_12", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-11-26 by cmkwon, ߱ Yetime_Chn   - ߰
// 	{"NET1-13       - db_17(20081126)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_17", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-11-26 by cmkwon, ߱ Yetime_Chn   - ߰
// 	{"NET1-18       - db_18(20090121)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_18", "4C0A4A6F79400669547E4A1C07", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-11-26 by cmkwon, ߱ Yetime_Chn   - ߰
// // 2008-11-26 by cmkwon, ߱ Yetime_Chn   - ʿ   ּ ó
// //	{"NET1-5        - db_8(20080923)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_8", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// //	{"NET1-6        - db_11(20080923)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_11", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// //	{"old           - NET1-3 db_6(20080723)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_6", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-07-23 by dhjin
// //	{"old           - NET1-4 db_7(20080723)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_7", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-07-23 by dhjin
// //	{"old           - NET1-1 (db_1)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_1", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1-2 (db_2)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_2", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// //	{"old           - NET1-3 (db_3)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_3", "4C0A4A6F7940066F566855180305", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 
// // 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - Ʒ  
// //	// 2007-09-19 by cmkwon, NET2 ߰
// //	// 2007-10-24 by cmkwon,   ȣȭ - 222.73.108.68(4C0A4A6F7940066F5668551F0B), 222.73.108.69(4C0A4A6F7940066F5668551F0A), atum(1F4C0D2C), atumcall(1F4C0D2C2D124432)
// //	// 2008-03-13 by cmkwon, йȣ 
// //	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// // 	{"NET2 1 (db_11) - db(1+7+8)",				"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_11", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"NET2 2 (db_12) - db(2+3+4+5)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_12", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old           - NET2 1 (db_1)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old           - NET2 2 (db_2)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old           - NET2 3 (db_3)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old           - NET2 4 (db_4)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old           - NET2 5 (db_5)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_5", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old           - NET2 6 (db_6)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_6", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old           - NET2 7 (db_7)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_7", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old           - NET2 8 (db_8)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_8", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	// 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - NET2(13 <== 11 + 12)
// 	// 2008-06-19 by cmkwon, Yetime_Chn PreServer, DBServer IP ٽ  IP  - 
// 	// 2008-09-23 by cmkwon, ߱ Yetime_Chn  α   ߰ - 
// 	// PreServerIP		: 222.73.108.68				- 4C0A4A6F7940066F5668551F0B
// 	// DBServerIP		: 222.73.108.69				- 4C0A4A6F7940066F5668551F0A
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 222.73.108.69				- 4C0A4A6F7940066F5668551F0A
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	{"NET2-1        - db_13(11+12)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_13", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"NET2-2        - db_14(20080708)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_14", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-07-08 by dhjin
// 	{"NET2-5        - db_17(20080821)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_17", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"NET2-6        - db_18(2008923)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_18", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"old           - NET2-3 db_15(20080723)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_15", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-07-23 by dhjin
// 	{"old           - NET2-4 db_16(20080821)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_16", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"old           - NET2-1 (db_11)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_11", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - NET2-2 (db_12)",			"4C0A4A6F7940066F5668551F0B", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_12", "4C0A4A6F7940066F5668551F0A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 
// // 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - Ʒ  
// //	// 2007-09-19 by cmkwon, NET3 ߰
// //	// 2007-10-24 by cmkwon,   ȣȭ - 222.73.108.80(4C0A4A6F7940066F5668551103), 222.73.108.81(4C0A4A6F7940066F5668551102), atum(1F4C0D2C), atumcall(1F4C0D2C2D124432)
// //	// 2008-03-13 by cmkwon, йȣ 
// //	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// // 	{"NET3 1 (db_11) - db(1+7+8)",				"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_11", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"NET3 2 (db_12) - db(2)",					"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_12", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"NET3 3 (db_13) - db(3+4)",				"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_13", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"NET3 4 (db_14) - db(5+6)",				"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_14", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - NET3 1 (db_1)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - NET3 2 (db_2)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - NET3 3 (db_3)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - NET3 4 (db_4)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - NET3 5 (db_5)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_5", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - NET3 6 (db_6)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_6", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - NET3 7 (db_7)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_7", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - NET3 8 (db_8)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_8", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	// 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - NET3(15 <== 11 + 12 + 13 + 14)
// 	// 2008-06-19 by cmkwon, Yetime_Chn PreServer, DBServer IP ٽ  IP  - 
// 	// 2008-09-23 by cmkwon, ߱ Yetime_Chn  α   ߰ - 
// 	// PreServerIP		: 222.73.108.80				- 4C0A4A6F7940066F5668551103
// 	// DBServerIP		: 222.73.108.81				- 4C0A4A6F7940066F5668551102
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 222.73.108.81				- 4C0A4A6F7940066F5668551102
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// 2008-06-25 by cmkwon, Yetime_Chn ߰([net3-6,3-7,3-8], [cnc2-5,2-6,2-7]) - 
// 	{"NET3-1        - db_15(11+12+13+14)",		"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_15", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"NET3-6        - db_18(16+17)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_18", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"NET3-7        - db_2(20080821)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4C0A4A6F7940066F5668551102",		9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"NET3-9        - db_4(20080923)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4C0A4A6F7940066F5668551102",		9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - NET3-5 db_1(20080723)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4C0A4A6F7940066F5668551102",		9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-23 by dhjin
// 	{"old           - NET3-8 db_3(20080821)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4C0A4A6F7940066F5668551102",		9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - NET3-6 db_16(20080625)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_16", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - NET3-7 db_17(20080625)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_17", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - NET3-1 (db_11)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_11", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - NET3-2 (db_12)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_12", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - NET3-3 (db_13)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_13", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - NET3-4 (db_14)",			"4C0A4A6F7940066F5668551103", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_14", "4C0A4A6F7940066F5668551102",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 
// // 2008-05-14 by cmkwon, Yetime_Chn α  2 ߰ -  ʴ κ
// // 	// 2007-09-19 by cmkwon, NET4 ߰
// // 	// 2007-10-24 by cmkwon,   ȣȭ - 222.73.108.92(4C0A4A6F7940066F5668551001), 222.73.108.93(4C0A4A6F7940066F5668551000), atum(1F4C0D2C), atumcall(1F4C0D2C2D124432)
// // 	// 2008-03-13 by cmkwon, йȣ 
// // 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// // 	{"Yetime(Chn)   - NET4 1 (db_1)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET4 2 (db_2)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET4 3 (db_3)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET4 4 (db_4)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET4 5 (db_5)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_5", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET4 6 (db_6)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_6", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET4 7 (db_7)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_7", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET4 8 (db_8)",			"4C0A4A6F7940066F5668551001", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_8", "4C0A4A6F7940066F5668551000",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	// 2007-09-19 by cmkwon, NET5 ߰
// // 	// 2007-10-24 by cmkwon,   ȣȭ - 222.73.108.104(4C0A4A6F7940066F566855180300), 222.73.108.105(4C0A4A6F7940066F566855180301), atum(1F4C0D2C), atumcall(1F4C0D2C2D124432)
// // 	// 2008-03-13 by cmkwon, йȣ 
// // 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// // 	{"Yetime(Chn)   - NET5 1 (db_1)",			"4C0A4A6F7940066F566855180300", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET5 2 (db_2)",			"4C0A4A6F7940066F566855180300", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET5 3 (db_3)",			"4C0A4A6F7940066F566855180300", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET5 4 (db_4)",			"4C0A4A6F7940066F566855180300", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET5 5 (db_5)",			"4C0A4A6F7940066F566855180300", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_5", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET5 6 (db_6)",			"4C0A4A6F7940066F566855180300", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_6", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET5 7 (db_7)",			"4C0A4A6F7940066F566855180300", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_7", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - NET5 8 (db_8)",			"4C0A4A6F7940066F566855180300", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_8", "4C0A4A6F7940066F566855180301",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	
// 	// 2008-05-14 by cmkwon, Yetime_Chn α  2 ߰ - NET4  ߰,  4
// 	// 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - Private IP 
// 	// 2008-06-19 by cmkwon, Yetime_Chn PreServer, DBServer IP ٽ  IP  - 
// 	// PreServerIP		: 222.73.72.156				- 4C0A4A6F79400669547E4A1C05
// 	// DBServerIP		: 222.73.72.154				- 4C0A4A6F79400669547E4A1C07
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 222.73.72.154				- 4C0A4A6F79400669547E4A1C07
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	{"NET4-1        - Serv 1(db_1)",	"4C0A4A6F79400669547E4A1C05", "4C0A4A6F79400669547E4A1C07",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4C0A4A6F79400669547E4A1C07",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 	{"NET4-2        - Serv 2(db_2)",	"4C0A4A6F79400669547E4A1C05", "4C0A4A6F79400669547E4A1C07",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4C0A4A6F79400669547E4A1C07",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 	{"NET4-3        - Serv 3(db_3)",	"4C0A4A6F79400669547E4A1C05", "4C0A4A6F79400669547E4A1C07",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4C0A4A6F79400669547E4A1C07",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 	{"NET4-4        - Serv 4(db_4)",	"4C0A4A6F79400669547E4A1C05", "4C0A4A6F79400669547E4A1C07",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4C0A4A6F79400669547E4A1C07",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 
// // 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - Ʒ  
// // 	// 2007-09-19 by cmkwon, CNC IP  DB   - db_1->db_11, db_2->db_12, ...
// // 	// 2007-10-24 by cmkwon,   ȣȭ - 123.234.8.98(4F0A4B6F7C401C705E7E4211), 123.234.8.99(4F0A4B6F7C401C705E7E4210), atum(1F4C0D2C), tmzk!@Wkd(0A55022A6F337F3502)
// // 	// 2008-02-28 by cmkwon, PreServerIP (123.234.8.98 -> 123.234.8.102)
// // 	// PreServerIP		: 123.234.8.102				- 4F0A4B6F7C401C705E7E4A1901
// // 	// DBServerIP		: 123.234.8.99				- 4F0A4B6F7C401C705E7E4210
// // 	// DBServerPort		: 9979
// // 	// DB User			: atum						- 1F4C0D2C
// // 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// // 	// LogDBServerIP	: 123.234.8.99				- 4F0A4B6F7C401C705E7E4210
// // 	// LogDBServerPort	: 9979
// // 	// DB User			: atum						- 1F4C0D2C
// // 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// // 	{"CNC1 1 (db_1)  - db(11~16)",				"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_1", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	{"old            - CNC1 1 (db_11)",			"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_11", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	{"old            - CNC1 2 (db_12)",			"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_12", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	{"old            - CNC1 3 (db_13)",			"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_13", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	{"old            - CNC1 4 (db_14)",			"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_14", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	{"old            - CNC1 5 (db_15)",			"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_15", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	{"old            - CNC1 6 (db_16)",			"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_16", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	{"old            - CNC1 7 (db_17)",			"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_17", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	{"old            - CNC1 8 (db_18)",			"4F0A4B6F7C401C705E7E4A1901", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_18", "4F0A4B6F7C401C705E7E4210", 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin  
// // 	// 2007-09-19 by cmkwon, CNC2 ߰
// // 	// 2007-10-24 by cmkwon,   ȣȭ - 123.234.8.66(4F0A4B6F7C401C705E7E4D1F), 123.234.8.67(4F0A4B6F7C401C705E7E4D1E), atum(1F4C0D2C), atumcall(1F4C0D2C2D124432)
// // 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// // 	{"CNC2 1 (db_11) - db(1+5)",				"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_11", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"CNC2 2 (db_12) - db(2+4+7)",				"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_12", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"CNC2 3 (db_13) - db(3+6+8)",				"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_13", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - CNC2 1 (db_1)",			"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - CNC2 2 (db_2)",			"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - CNC2 3 (db_3)",			"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - CNC2 4 (db_4)",			"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - CNC2 5 (db_5)",			"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_5", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - CNC2 6 (db_6)",			"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_6", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - CNC2 7 (db_7)",			"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_7", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"old            - CNC2 8 (db_8)",			"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_8", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	// 2008-06-04 by cmkwon, Yetime_Chn ι°   , PreServer DBServer Private IP   - CNC1, CNC2(CNC2-4 <== CNC1-1 + CNC2-1 + CNC2-2 + CNC2-3), "old           - CNC1 1 (db_1)" PreServer IP CNC2  ϰ 
// 	// 2008-06-19 by cmkwon, Yetime_Chn PreServer, DBServer IP ٽ  IP  - 
// 	// 2008-09-23 by cmkwon, ߱ Yetime_Chn  α   ߰ - 
// 	// PreServerIP		: 123.234.8.66				- 4F0A4B6F7C401C705E7E4D1F
// 	// DBServerIP		: 123.234.8.67				- 4F0A4B6F7C401C705E7E4D1E
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 123.234.8.67				- 4F0A4B6F7C401C705E7E4D1E
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// 2008-06-25 by cmkwon, Yetime_Chn ߰([net3-6,3-7,3-8], [cnc2-5,2-6,2-7]) - 
// 	{"CNC2-1        - db_14(CNC1-1+CNC2-1+CNC2-2+CNC2-3)",	"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_14", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"CNC2-5        - db_18(20080707)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_18", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-07-07 by dhjin
// 	{"CNC2-7        - db_2(20080805)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"CNC2-8        - db_3(20080923)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"CNC2-9        - db_4(20080923)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - CNC2-1 db_1(20080723)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-23 by dhjin
// 	{"old           - CNC2-5 db_15(20080625)",					"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_15", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - CNC2-6 db_16(20080625)",					"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_16", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - CNC2-7 db_17(20080625)",					"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_17", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - CNC2-1 (db_11)",					"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_11", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - CNC2-2 (db_12)",					"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_12", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"old           - CNC2-3 (db_13)",					"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_13", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 
// 
// // 2008-05-14 by cmkwon, Yetime_Chn α  2 ߰ -   ʴ  
// // 	// 2007-09-19 by cmkwon, CNC3 ߰
// // 	// 2007-10-24 by cmkwon,   ȣȭ - 123.234.8.69(4F0A4B6F7C401C705E7E4D10), 123.234.8.71(4F0A4B6F7C401C705E7E4C18), atum(1F4C0D2C), atumcall(1F4C0D2C2D124432)
// // 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// // 	{"Yetime(Chn)   - CNC3 1 (db_1)",			"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - CNC3 2 (db_2)",			"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - CNC3 3 (db_3)",			"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - CNC3 4 (db_4)",			"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - CNC3 5 (db_5)",			"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_5", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - CNC3 6 (db_6)",			"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_6", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - CNC3 7 (db_7)",			"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_7", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// // 	{"Yetime(Chn)   - CNC3 8 (db_8)",			"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_8", "4F0A4B6F7C401C705E7E4C18",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 
// 	// 2008-05-14 by cmkwon, Yetime_Chn α  2 ߰ - CNC3  ߰,  1, ӽ÷ 2
// 	// 2008-06-19 by cmkwon, Yetime_Chn PreServer, DBServer IP ٽ  IP  - 
// 	// PreServerIP		: 123.234.8.69				- 4F0A4B6F7C401C705E7E4D10
// 	// DBServerIP		: 123.234.8.73				- 4F0A4B6F7C401C705E7E4C1A
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 123.234.8.73				- 4F0A4B6F7C401C705E7E4C1A
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	{"CNC3-1        - Serv 1(db_1)",	"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C1A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "4F0A4B6F7C401C705E7E4C1A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 	{"CNC3-2        - Reserve 2(db_2)",	"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C1A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4F0A4B6F7C401C705E7E4C1A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 	{"CNC3-3        - Reserve 3(db_3)",	"4F0A4B6F7C401C705E7E4D10", "4F0A4B6F7C401C705E7E4C1A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_3", "4F0A4B6F7C401C705E7E4C1A",	 9979, "1F4C0D2C",	"5D5D3C226A016E28"},

// 2009-12-01 by cmkwon, ߱ IDC (NET 1, CNC 1) - Ʒ  
// 	// 2009-01-21 by cmkwon, ߱  α  ΰ(net, cnc)   -  Ʈ , "NET1-18       - db_18(20090121)"
// 	// 2009-05-20 by cmkwon, ߱ NET PreServer IP  - (222.73.108.92)
// 	// 2009-05-21 by cmkwon, ߱ NET DBServer IP  - (222.73.72.154)
// 	// PreServerIP		: 222.73.108.114			- 4C0A4A6F7940066F566855180200
// 	// DBServerIP		: 222.73.108.113			- 4C0A4A6F7940066F566855180207
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 222.73.108.113			- 4C0A4A6F7940066F566855180207
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	{"NET1-4        - db_4(1+2+3)",				"4C0A4A6F7940066F566855180200", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_4", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"NET1-5        - db_5(20080707)",			"4C0A4A6F7940066F566855180200", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_5", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-07-07 by dhjin
// 	{"NET1-14       - db_14(20081113)",			"4C0A4A6F7940066F566855180200", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_14", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"NET1-15       - db_15(20081113)",			"4C0A4A6F7940066F566855180200", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_15", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-08-21 by dhjin
// 	{"NET1-18       - db_18(20090121)",			"4C0A4A6F7940066F566855180200", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_18", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2008-11-26 by cmkwon, ߱ Yetime_Chn   - ߰
// 	
// 	// 2009-04-15 by cmkwon, ߱  4 ߰ - NET 2
// 	{"NET1-GameServ5 - db_6(20090415)",			"4C0A4A6F7940066F566855180200", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_6", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			
// 	{"NET1-GameServ7 - db_9(20090415)",			"4C0A4A6F7940066F566855180200", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_9", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},			
// 
// 	// 2009-07-08 by cmkwon, ߱  1 ߰ - NET 1
// 	{"NET1-GameServ8 - db_19(20090708)",			"4C0A4A6F7940066F566855180200", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_19", "4C0A4A6F7940066F566855180207", 9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 
// 
// 	// 2009-01-21 by cmkwon, ߱  α  ΰ(net, cnc)   -  Ʈ 
// 	// PreServerIP		: 123.234.8.66				- 4F0A4B6F7C401C705E7E4D1F
// 	// DBServerIP		: 123.234.8.67				- 4F0A4B6F7C401C705E7E4D1E
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 123.234.8.67				- 4F0A4B6F7C401C705E7E4D1E
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	{"CNC2-2        - db_2(20080805)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_2", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 	{"CNC2-14       - db_14(CNC1-1+CNC2-1+CNC2-2+CNC2-3)",	"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_14", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 
// 	// 2009-04-15 by cmkwon, ߱  4 ߰ - CNC 2
// 	{"CNC2-GameServ2 - db_5(20090415)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_5", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 	{"CNC2-GameServ6 - db_6(20090415)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_6", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},
// 
// 	// 2009-06-11 by cmkwon, ߱ Yetime ż 1 ߰ - CNC 1 ߰,     ϳ   ̶ .
// 	{"CNC2-GameServ1 - db_7(20090611)",						"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_7", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},

// 2010-01-14 by cmkwon, ߱   ۾ - 
// 	///////////////////////////////////////////////////////////////////////////////
// 	// 2009-12-01 by cmkwon, ߱ IDC (NET 1, CNC 1) - NET
// 	// PreServerIP		: 123.234.8.74				- 4F0A4B6F7C401C705E7E4C1D
// 	// DBServerIP		: 123.234.8.73				- 4F0A4B6F7C401C705E7E4C1A
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 123.234.8.73				- 4F0A4B6F7C401C705E7E4C1A
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	{"NET-GameServ1 - db_4(1+2+3)",					"4F0A4B6F7C401C705E7E4C1D", "4F0A4B6F7C401C705E7E4C1A",		9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_4", "4F0A4B6F7C401C705E7E4C1A",		9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-07-04 by dhjin
// 
// 	///////////////////////////////////////////////////////////////////////////////
// 	// 2009-12-01 by cmkwon, ߱ IDC (NET 1, CNC 1) - CNC
// 	// PreServerIP		: 123.234.8.66				- 4F0A4B6F7C401C705E7E4D1F
// 	// DBServerIP		: 123.234.8.67				- 4F0A4B6F7C401C705E7E4D1E
// 	// DBServerPort		: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	// LogDBServerIP	: 123.234.8.67				- 4F0A4B6F7C401C705E7E4D1E
// 	// LogDBServerPort	: 9979
// 	// DB User			: atum						- 1F4C0D2C
// 	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
// 	{"CNC-GameServ1 - db_7(20090611)",				"4F0A4B6F7C401C705E7E4D1F", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_7", "4F0A4B6F7C401C705E7E4D1E",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},
	///////////////////////////////////////////////////////////////////////////////
	// 2010-01-14 by cmkwon, ߱   ۾ - 
	// PreServerIP		: 61.155.138.234			- 480956707B46066F5568551B0000
	// DBServerIP		: 61.155.138.232			- 480956707B46066F5568551B0006
	// DBServerPort		: 9979
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
	// LogDBServerIP	: 61.155.138.232			- 480956707B46066F5568551B0006
	// LogDBServerPort	: 9979
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
	{"NET-GameServ1 - db_1(20100114)",				"480956707B46066F5568551B0000", "480956707B46066F5568551B0006",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28",			"atum2_db_1", "480956707B46066F5568551B0006",	 	9979, "1F4C0D2C",	"5D5D3C226A016E28"},


	// 2008-06-16 by cmkwon, Yedtime_Chn ׼  , // 2008-01-22 by cmkwon, Yetime ׼   
	// 2008-12-17 by cmkwon, ߱ Yetime_Chn ׼   - PreServer(<-222.73.72.200), DBServer(<-222.73.72.199)
	// 2009-05-21 by cmkwon, ߱ NET DBServer IP  - (Pre:61.155.141.136, DB:61.155.141.137)
	// PreServerIP		: 192.168.0.201				- 4F014A6F7F451070567E491902
	// DBServerIP		: 192.168.0.220				- 4F014A6F7F451070567E491B03
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: #eDc$rFv					- 5D5D3C226A016E28
	{"Yetime(Chn)   - TestServer (db_1)",	"4F014A6F7F451070567E491902", "4F014A6F7F451070567E491B03",		9979, "1F4C0D2C",	"5D5D3C226A016E28",		"atum2_db_1", "4F014A6F7F451070567E491B03",		9979, "1F4C0D2C",	"5D5D3C226A016E28"},			// 2007-04-12 by cmkwon

	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.146(4F0A496F7F401C7057614F07020012), 121.134.114.146(4F0A496F7F401C7057614F07020012), atum(1F4C0D2C), callweb(1D59142D39164A)
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.146(48095672775D1969567E4A1D05)
	{"MS146(Yetime_Chn)_(atum2_db_account)",				"48095672775D1969567E4A1D05", "48095672775D1969567E4A1D05", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D05", 9979, "1F4C0D2C",	"1D59142D39164A"},			// 2007-06-13 by dhjin
	// 2008-08-20 by cmkwon, 
	//{"MS146(Yetime)_Chn(atum2_db_account_test)",		"4F0A496F7F401C7057614F07020012", "4F0A496F7F401C7057614F07020012", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020012", 9979, "1F4C0D2C",	"1D59142D39164A"},		// 2007-06-13 by dhjin
#endif// #ifdef SERVICE_TYPE_CHINESE_SERVER_1
#ifdef SERVICE_TYPE_VIETNAMESE_SERVER_1
	// 2006-08-28 by cmkwon, Changed PreServerIP(10.10.1.10 --> 10.10.1.28)
	// 2006-11-02 by cmkwon, Changed PreServerIP(10.10.1.28 --> 222.255.15.37), DBServerIP(10.10.1.14 --> 222.255.15.61)
	// 2007-10-22 by cmkwon, Changed passowrd(<--"tmzk!@Wkd")
	// 2007-10-24 by cmkwon,   ȣȭ - 222.255.15.37(4F0A496F7F401C7057614F07020014), 222.255.15.61(4C0A4A6F7C461D705765551F02), atum(1F4C0D2C), \/tcb3gin08(22170C222C404F37086043)
	// 2009-01-07 by cmkwon, Ʈ Ʈ ý  - ̸ ϰ ӽÿ ΰ ߰.
	// 2009-01-08 by cmkwon, Ʈ db  缳 IP  - 
	// 2009-01-15 by cmkwon, Ʈ DB PWD , public ip ٽ  - 
	// 2010-02-04 by cmkwon, Ʈ  ߰(atum2_db_18 Eternal) - 
	// 2011-08-16 by shcho, Ʈ IP PreServer(117.103.194.77), DBServer(117.103.194.76)

	// PreServerIP		: 117.103.194.77			- 4F094F6F7F431B7057694F070403 ( 4C0A4A6F7C461D705765551A04)
	// DBServerIP		: 117.103.194.76			- 4F094F6F7F431B7057694F070402 ( 4C0A4A6F7C461D705765551F02)
	// DBServerIP		: 117.103.194.75			- 4F094F6F7F431B7057694F070401 (з:dragon,legend(PW:ace|2011|\/tc - 1F5B1D3D7C43196F1A0C545D50))
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: \/tcR3vive2011			- 22170C221C405E37103549190205	// OLD PASSWORD (v\/tcb3gin08	- 086457352D111B390F3E4B11)2006-06-02 by shcho
	// 2011-03-17 by shcho, Ʈ IP - atum2_db_16  IP 117.103.194.75(4F094F6F7F431B7057694F070401)

	{"Main      - Phoenix   (atum2_db_14)",		"4F094F6F7F431B7057694F070403", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205",		"atum2_db_14", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205"},			// 2011-01-20 by shcho, Ʈ  ߰ 
	{"Main      - Akron     (atum2_db_15)",		"4F094F6F7F431B7057694F070403", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205",		"atum2_db_15", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205"},			// 2006-04-26 by cmkwon
	{"Main      - Legend    (atum2_db_16)",		"4F094F6F7F431B7057694F070403", "4F094F6F7F431B7057694F070401", 9979, "1F4C0D2C",	"1F5B1D3D7C43196F1A0C545D50",		"atum2_db_16", "4F094F6F7F431B7057694F070401", 9979, "1F4C0D2C",	"1F5B1D3D7C43196F1A0C545D50"},			// 2011-12-08 by shcho, DB IP,PW
	{"Main      - Dragon    (atum2_db_17)",		"4F094F6F7F431B7057694F070403", "4F094F6F7F431B7057694F070401", 9979, "1F4C0D2C",	"1F5B1D3D7C43196F1A0C545D50",		"atum2_db_17", "4F094F6F7F431B7057694F070401", 9979, "1F4C0D2C",	"1F5B1D3D7C43196F1A0C545D50"},			// 2011-12-08 by shcho, DB IP,PW
	{"Main      - Eternal   (atum2_db_18)",		"4F094F6F7F431B7057694F070403", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205",		"atum2_db_18", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205"},			// 2006-04-26 by cmkwon
	{"Main      - PANDORA   (atum2_db_19)",		"4F094F6F7F431B7057694F070403", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205",		"atum2_db_19", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205"},			// 2006-06-02 by shcho
//{"Main      - Pandea    (atum2_db_17)",		"4F094F6F7F431B7057694F070403", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205",		"atum2_db_17", "4F094F6F7F431B7057694F070402", 9979, "1F4C0D2C",	"22170C221C405E37103549190205"},			// 2006-04-26 by cmkwon	
	
// 2009-01-07 by cmkwon, Ʈ Ʈ ý  - 
//	{"VTC(Viet) - old_Alioth    (atum2_db_1)",	"4C0A4A6F7C461D705765551A04", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043",		"atum2_db_1", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043"},			// 2006-04-26 by cmkwon
//	{"VTC(Viet) - old_Blackburn (atum2_db_11)",	"4C0A4A6F7C461D705765551A04", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043",		"atum2_db_11", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043"},			// 2006-04-26 by cmkwon
//	{"VTC(Viet) - old_Chaos     (atum2_db_12)",	"4C0A4A6F7C461D705765551A04", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043",		"atum2_db_12", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043"},			// 2006-04-26 by cmkwon
//	{"VTC(Viet) - old_Denebola  (atum2_db_13)",	"4C0A4A6F7C461D705765551A04", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043",		"atum2_db_13", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043"},			// 2006-04-26 by cmkwon
//	{"VTC(Viet) - old_Edmont    (atum2_db_14)",	"4C0A4A6F7C461D705765551A04", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043",		"atum2_db_14", "4C0A4A6F7C461D705765551F02", 9979, "1F4C0D2C",	"22170C222C404F37086043"},			// 2006-04-26 by cmkwon

	// 2007-10-24 by cmkwon,   ȣȭ - 222.255.15.54(4C0A4A6F7C461D705765551C07), 222.255.15.61(4C0A4A6F7C461D705765551F02), atum(1F4C0D2C), Scovn2007?><(1D59142D39164A)
	// 2009-01-07 by cmkwon, Ʈ Ʈ ý  - ׼ DB   
	// 2009-01-08 by cmkwon, Ʈ db  缳 IP  - 
	// 2009-01-15 by cmkwon, Ʈ DB PWD , public ip ٽ  - 
	// 2011-08-16 by shcho, Ʈ IP - testServer PreServer(117.103.198.155), DBServer(117.103.198.170)
	// PreServerIP		: 117.103.198.155				- 4F094F6F7F431B7057694307020111
	// DBServerIP		: 117.103.198.170				- 4F094F6F7F431B7057694307020314
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: 12315						- 4F0A4B707B
	{"Test      - TestServ1 (atum2_db_1)",		"4F094F6F7F431B7057694307020111", "4F094F6F7F431B7057694307020314", 9979, "1F4C0D2C",	"4F0A4B707B",		"atum2_db_1", "4F094F6F7F431B7057694307020314", 9979, "1F4C0D2C",	"4F0A4B707B"},		// 2006-04-26 by cmkwon

	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.143(4F0A496F7F401C7057614F07020017), 121.134.114.143(4F0A496F7F401C7057614F07020017), atum(1F4C0D2C), callweb(1D59142D39164A)
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.143(48095672775D1969567E4A1D00)
	{"MS143(VTC-Intecom_Viet)_(atum2_db_account)",		"48095672775D1969567E4A1D00", "48095672775D1969567E4A1D00", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D00", 9979, "1F4C0D2C",	"1D59142D39164A"},			// 2006-03-24 by cmkwon
	// 2008-08-20 by cmkwon, 
	//{"MS143(VTC-Intecom)_Viet(atum2_db_account_test)",	"4F0A496F7F401C7057614F07020017", "4F0A496F7F401C7057614F07020017", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020017", 9979, "1F4C0D2C",	"1D59142D39164A"},		// 2006-03-24 by cmkwon
#endif// #ifdef SERVICE_TYPE_VIETNAMESE_SERVER_1

#ifdef SERVICE_TYPE_ENGLISH_SERVER_2
	// 2008-01-04 by cmkwon, Gameforge4D ߰ - 
	// 2008-04-16 by cmkwon, Gameforge4D  ߰(db_3, db_4, db_5)
	// 2009-03-04 by cmkwon, Gameforge ,  PreServer, DBServer Domain   - (83.141.22.23, 83.141.22.20)
	// PreServerIP	: zion.airrivals.net		- 0451172F6012412C14390D485F470A460317
	// DBServerIP	: speicher.airrivals.net	- 0D481D282D1B4D2C4831125B415D52490A104C3A2B50
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: aktkd1226game		- 1F530C2A2A421A6C50371A4456
	{"Main      - HELIX   (atum2_db_1)",		"0451172F6012412C14390D485F470A460317", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_1", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - ORION   (atum2_db_2)",		"0451172F6012412C14390D485F470A460317", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_2", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - AURIGA  (atum2_db_3)",		"0451172F6012412C14390D485F470A460317", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_3", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Reserve1(atum2_db_4)",		"0451172F6012412C14390D485F470A460317", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_4", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Reserve1(atum2_db_5)",		"0451172F6012412C14390D485F470A460317", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_5", "0D481D282D1B4D2C4831125B415D52490A104C3A2B50", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},

	// 2008-01-26 by cmkwon, Gameforge4D ׼ ߰ - 
	// 2008-10-30 by cmkwon, Gameforge4D_Eng ׼  IP  - (<--85.115.19.228)
	// PreServerIP	: 79.110.95.6		- 490156707F430667537E4D
	// DBServerIP	: 79.110.95.6		- 490156707F430667537E4D		// 2008-09-19 by cmkwon, (<--85.115.19.229)
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"Test    - TestServer(atum2_db_1)",	"490156707F430667537E4D", "490156707F430667537E4D", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "490156707F430667537E4D", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2008-01-04 by cmkwon, Gameforge4D ߰ - 
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.145(48095672775D1969567E4A1D06)
	// PreServerIP	: 61.39.170.145		- 48095672775D1969567E4A1D06
	// DBServerIP	: 61.39.170.145		- 48095672775D1969567E4A1D06
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS145(Gameforge4D_Eng)_(atum2_db_account)",		"48095672775D1969567E4A1D06", "48095672775D1969567E4A1D06", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D06", 9979, "1F4C0D2C",	"1D59142D39164A"},
	// 2008-08-20 by cmkwon, 
	//{"MS145(Gameforge4D_Eng)_(atum2_db_account_test)",	"4F0A496F7F401C7057614F07020011", "4F0A496F7F401C7057614F07020011", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020011", 9979, "1F4C0D2C",	"1D59142D39164A"},
#endif// #ifdef SERVICE_TYPE_ENGLISH_SERVER_2

// 2008-04-25 by cmkwon,   Ͼ ߰ - 
#if defined(SERVICE_TYPE_GERMAN_SERVER_1)
	// 2008-07-10 by cmkwon,   ߰.
	// 2008-08-13 by cmkwon,  Gameforge4D_Deu DB Server IP changed - 83.141.22.216 <-- 83.141.22.210
	// 2009-03-04 by cmkwon, Gameforge ,  PreServer, DBServer Domain   - (83.141.22.113, 83.141.22.216)
	// PreServerIP	: prokyon.airrivals.de		- 0E4A172A371C46700739095B5A424544154D0631
	// DBServerIP	: speicher.airrivals.de		- 0D481D282D1B4D2C4831125B415D52490A104C302B
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: vm/-ekQcjqnf		- 0855576C2B18793D0C21154F
	// 2008-07-10 by cmkwon,   ߰.
	// 2008-07-22 by cmkwon, Gameforge4D_Deu Pandora(Server2) ߰ 
	{"Main      - Prokyon  (atum2_db_1)",		"0E4A172A371C46700739095B5A424544154D0631", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_1", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Pandora  (atum2_db_2)",		"0E4A172A371C46700739095B5A424544154D0631", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_2", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Antares  (atum2_db_3)",		"0E4A172A371C46700739095B5A424544154D0631", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_3", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Reserve4 (atum2_db_4)",		"0E4A172A371C46700739095B5A424544154D0631", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_4", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Reserve5 (atum2_db_5)",		"0E4A172A371C46700739095B5A424544154D0631", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_5", "0D481D282D1B4D2C4831125B415D52490A104C302B", 9979, "1F4C0D2C",	"0855576C2B18793D0C21154F"},

	// 2008-04-25 by cmkwon,   Ͼ ߰ - 
	// 2008-10-30 by cmkwon, Gameforge4D_Deu ׼  IP  - (<--85.115.19.232)
	// 2010-03-25 by cmkwon, Gameforge4D_Deu ׼  IP (:79.110.95.9) - 
	// PreServerIP	: 79.110.95.47		- 490156707F430667537E4F1E
	// DBServerIP	: 79.110.95.47		- 490156707F430667537E4F1E
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"Test    - TestServer(atum2_db_1)",	"490156707F430667537E4F1E", "490156707F430667537E4F1E", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "490156707F430667537E4F1E", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2008-04-25 by cmkwon, Gameforge4D_Deu ߰ - 
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.147(48095672775D1969567E4A1D04)
	// PreServerIP	: 61.39.170.147		- 48095672775D1969567E4A1D04
	// DBServerIP	: 61.39.170.147		- 48095672775D1969567E4A1D04
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS147(Gameforge4D_Deu)_(atum2_db_account)",		"48095672775D1969567E4A1D04", "48095672775D1969567E4A1D04", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D04", 9979, "1F4C0D2C",	"1D59142D39164A"},

// 2009-10-16 by cmkwon, ʿ Ƿ 
//	{"MS147(Gameforge4D_Deu_MySQL)_(atum2_db_account)",	"4F0A496F7F401C7057614F07020013", "4F0A496F7F401C7057614F07020013", 3306, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020013", 3306, "1F4C0D2C",	"1D59142D39164A"},

	// 2008-08-20 by cmkwon, 
	//{"MS147(Gameforge4D_Deu)_(atum2_db_account_test)",	"4F0A496F7F401C7057614F07020013", "4F0A496F7F401C7057614F07020013", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020013", 9979, "1F4C0D2C",	"1D59142D39164A"},
#endif// #ifdef SERVICE_TYPE_GERMAN_SERVER_1

// 2008-05-07 by cmkwon, WinnerOnline_Tha ߰ϱ - 
#if defined(SERVICE_TYPE_THAI_SERVER_1)
	// 2008-05-07 by cmkwon, WinnerOnline_Tha ߰ϱ - 
	// 2008-11-19 by cmkwon, ± WinnerOnline_Tha ׷ ߰ - 
	// 2009-09-23 by cmkwon, ±      - 
	// PreServerIP	: 202.43.33.65		- 4C084A6F7A40066D557E4D1C
	// DBServerIP	: 202.43.33.66		- 4C084A6F7A40066D557E4D1F
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: winner9sohk		- 0951162F2B01112D093810
	{"Main  - Enterprise  (atum2_db_11<8+9>)",	"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_11", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
	{"Main  - Orion       (atum2_db_12<7+10>)",	"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_12", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
	{"Main  - Colony      (atum2_db_13)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_13", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
	{"Main  - Reserve1    (atum2_db_14)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_14", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
	{"Main  - Reserve2    (atum2_db_15)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_15", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
	{"Main    - old_Omega   (atum2_db_7)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_7", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
	{"Main    - old_Fornax  (atum2_db_8)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_8", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
	{"Main    - old_Tucana  (atum2_db_9)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_9", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
	{"Main    - old_Phoenix (atum2_db_10)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_10", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 2009-09-23 by cmkwon, ±      - 
// 	{"Main      - Serv1   (atum2_db_1)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_1", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv2   (atum2_db_2)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_2", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv3	  (atum2_db_3)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_3", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv4	  (atum2_db_4)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_4", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv5   (atum2_db_5)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_5", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv6	  (atum2_db_6)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_6", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv7	  (atum2_db_7)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_7", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv8   (atum2_db_8)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_8", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv9	  (atum2_db_9)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_9", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},
// 	{"Main      - Serv10  (atum2_db_10)",		"4C084A6F7A40066D557E4D1C", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_10", "4C084A6F7A40066D557E4D1F", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},

	// 2008-05-07 by cmkwon, WinnerOnline_Tha ߰ϱ - 
	// 2008-06-20 by cmkwon, WinnerOnline_Tha ׼ PreServer,DBServerIP  - (// PreServerIP	: 202.176.82.16, // DBServerIP	: 58.136.118.37)
	// 2009-08-28 by cmkwon, ± ׼  PC IP  - 
	// PreServerIP	: 202.170.113.40	- 4C084A6F7F441870576148070704
	// DBServerIP	: 202.170.113.39	- 4C084A6F7F44187057614807000D
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: winner9sohk		- 0951162F2B01112D093810
	{"Test    - TestServer(atum2_db_1)",	"4C084A6F7F441870576148070704", "4C084A6F7F44187057614807000D", 1433, "1F4C0D2C",	"0951162F2B01112D093810",		"atum2_db_1", "4C084A6F7F44187057614807000D", 1433, "1F4C0D2C",	"0951162F2B01112D093810"},

	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2008-05-07 by cmkwon, WinnerOnline_Tha ߰ϱ - 
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.148(48095672775D1969567E4A1D0B)
	// PreServerIP	: 61.39.170.148		- 48095672775D1969567E4A1D0B
	// DBServerIP	: 61.39.170.148		- 48095672775D1969567E4A1D0B
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS148(WinnerOnline_Tha)_(atum2_db_account)",		"48095672775D1969567E4A1D0B", "48095672775D1969567E4A1D0B", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E4A1D0B", 9979, "1F4C0D2C",	"1D59142D39164A"},
	// 2008-08-20 by cmkwon, 
	//{"MS148(WinnerOnline_Tha)_(atum2_db_account_test)",	"4F0A496F7F401C7057614F0702001C", "4F0A496F7F401C7057614F0702001C", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A"},
#endif// #ifdef SERVICE_TYPE_THAI_SERVER_1

// 2008-06-27 by cmkwon, Innova_Rus AdminTool,DBTool  DB  ߰ - 
#if defined(SERVICE_TYPE_RUSSIAN_SERVER_1)
	// 2008-06-27 by cmkwon, Innova_Rus AdminTool,DBTool  DB  ߰ - 
	// 2009-12-11 by cmkwon, þ PreServer,DBServer IP - 
	// PreServerIP	: 109.105.134.133	- 4F08416F7F431D7057634F07020717
	// DBServerIP	: 109.105.134.140	- 4F08416F7F431D7057634F07020014
	// 2008-07-29 by cmkwon, ӽ÷ DB IP 89.249.25.69(460156737A4A066C537E4D10)  
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: ahr!$akfj			- 1F500A606A1243380C
	{"Main      - Serv1   (atum2_db_1)",		"4F08416F7F431D7057634F07020717", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C",		"atum2_db_1", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C"},
	{"Main      - Serv2   (atum2_db_2)",		"4F08416F7F431D7057634F07020717", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C",		"atum2_db_2", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C"},
	{"Main      - Reserve3(atum2_db_3)",		"4F08416F7F431D7057634F07020717", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C",		"atum2_db_3", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C"},
	{"Main      - Reserve4(atum2_db_4)",		"4F08416F7F431D7057634F07020717", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C",		"atum2_db_4", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C"},
	{"Main      - Reserve5(atum2_db_5)",		"4F08416F7F431D7057634F07020717", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C",		"atum2_db_5", "4F08416F7F431D7057634F07020014", 1433, "1F4C0D2C",	"1F500A606A1243380C"},
	
	// 2008-10-29 by cmkwon, þ Innova_Rus ׼  ߰ 
	// 2010-04-26 by cmkwon, þ Innova ׼ IP  -  Pre(89.249.25.58),  DB(89.249.25.56)
	// 2010-06-30 by jskim //DBServerIP	: 109.105.134.130	- 4F08416F7F431D7057634F07020714
	// PreServerIP	: 109.105.134.130	- 4F08416F7F431D7057634F07020714
	// DBServerIP	: 109.105.134.141	- 4F08416F7F431D7057634F07020015
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: ahr!$akfj			- 1F500A606A1243380C
	{"Test      - TestServer1(atum2_db_1)",	"4F08416F7F431D7057634F07020714", "4F08416F7F431D7057634F07020015", 1433, "1F4C0D2C",	"1F500A606A1243380C",		"atum2_db_1", "4F08416F7F431D7057634F07020015", 1433, "1F4C0D2C",	"1F500A606A1243380C"},
	
	// 2011-04-29 by shcho, þ Innova_Rus ׼  ߰ - 2° ׼
	// PreServerIP	: 10.33.152.121		- 4F0856727D5D196B547E4A1B02
	// DBServerIP	: 10.33.152.120		- 4F0856727D5D196B547E4A1B03
	// DBServerPort	: 1433									 (ؾ - ȣ)
	// DB User		: atum				- 1F4C0D2C			 (ؾ - ȣ)
	// DB PWD		: ahr!$akfj			- 1F500A606A1243380C (ؾ - ȣ)
	{"Test      - TestServer2(atum2_db_1)",	"4F0856727D5D196B547E4A1B02", "4F0856727D5D196B547E4A1B03", 1433, "1F4C0D2C",	"1F500A606A1243380C",		"atum2_db_1", "4F0856727D5D196B547E4A1B03", 1433, "1F4C0D2C",	"1F500A606A1243380C"},

	// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
	// 2008-06-19 by cmkwon, Innova_Rus  ׽Ʈ  ߰ - 
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.220(48095672775D1969567E491B03)
	// PreServerIP	: 61.39.170.220		- 48095672775D1969567E491B03
	// DBServerIP	: 61.39.170.220		- 48095672775D1969567E491B03
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS220(Innova_Rus)_(atum2_db_account)",		"48095672775D1969567E491B03", "48095672775D1969567E491B03", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B03", 9979, "1F4C0D2C",	"1D59142D39164A"},
	// 2008-08-20 by cmkwon, 
	//{"MS220(Innova_Rus)_(atum2_db_account_test)",	"4F0A496F7F401C7057614F07010614", "4F0A496F7F401C7057614F07010614", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07010614", 9979, "1F4C0D2C",	"1D59142D39164A"},
#endif// END - #if defined(SERVICE_TYPE_RUSSIAN_SERVER_1)

///////////////////////////////////////////////////////////////////////////////
// 2008-09-23 by cmkwon,   ߰(븸 Netpower_Tpe) - 
#if defined(SERVICE_TYPE_TAIWANESE_SERVER_1)	
	// PreServerIP		: 202.153.171.70			- 4C084A6F7F461B7057674A070404
	// DBServerIP		: 10.10.50.31				- 4F0856707E5D1D6E48634A
	// DBServerPort		: 9979
	// DB User			: aceuser					- 1F5B1D343D165A
	// DB PWD			: aceu960@@##				- 1F5B1D347745181E267358
	// LogDBServerIP	: 10.10.50.31				- 4F0856707E5D1D6E48634A
	// LogDBServerPort	: 9978
	// DB User			: aceuser					- 1F5B1D343D165A
	// DB PWD			: aceu960@@##				- 1F5B1D347745181E267358
	{"Main      - Serv1   (atum2_db_1)",		"4C084A6F7F461B7057674A070404", "4F0856707E5D1D6E48634A", 9979, "1F5B1D343D165A",	"1F5B1D347745181E267358",		"atum2_db_1", "4F0856707E5D1D6E48634A", 9978, "1F5B1D343D165A",	"1F5B1D347745181E267358"},
	{"Main      - Serv2   (atum2_db_2)",		"4C084A6F7F461B7057674A070404", "4F0856707E5D1D6E48634A", 9979, "1F5B1D343D165A",	"1F5B1D347745181E267358",		"atum2_db_2", "4F0856707E5D1D6E48634A", 9978, "1F5B1D343D165A",	"1F5B1D347745181E267358"},
	{"Main      - Serv3   (atum2_db_3)",		"4C084A6F7F461B7057674A070404", "4F0856707E5D1D6E48634A", 9979, "1F5B1D343D165A",	"1F5B1D347745181E267358",		"atum2_db_3", "4F0856707E5D1D6E48634A", 9978, "1F5B1D343D165A",	"1F5B1D347745181E267358"},
	{"Main      - Reserve4(atum2_db_4)",		"4C084A6F7F461B7057674A070404", "4F0856707E5D1D6E48634A", 9979, "1F5B1D343D165A",	"1F5B1D347745181E267358",		"atum2_db_4", "4F0856707E5D1D6E48634A", 9978, "1F5B1D343D165A",	"1F5B1D347745181E267358"},
	{"Main      - Reserve5(atum2_db_5)",		"4C084A6F7F461B7057674A070404", "4F0856707E5D1D6E48634A", 9979, "1F5B1D343D165A",	"1F5B1D347745181E267358",		"atum2_db_5", "4F0856707E5D1D6E48634A", 9978, "1F5B1D343D165A",	"1F5B1D347745181E267358"},
	
	// 2008-06-27 by cmkwon, Innova_Rus AdminTool,DBTool  DB  ߰ - 
	// PreServerIP		: 192.168.1.31				- 4F014A6F7F451070577E4818
	// DBServerIP		: 192.168.1.32				- 4F014A6F7F451070577E481B
	// DBServerPort		: 9979
	// DB User			: aceuser					- 1F5B1D343D165A
	// DB PWD			: aceu960@@##				- 1F5B1D347745181E267358
	// LogDBServerIP	: 192.168.1.32				- 4F014A6F7F451070577E481B
	// LogDBServerPort	: 9978
	// DB User			: aceuser					- 1F5B1D343D165A
	// DB PWD			: aceu960@@##				- 1F5B1D347745181E267358
	{"Test    - TestServer(atum2_db_1)",	"4F014A6F7F451070577E4818", "4F014A6F7F451070577E481B", 9979, "1F5B1D343D165A",	"1F5B1D347745181E267358",		"atum2_db_1", "4F014A6F7F451070577E481B", 9978, "1F5B1D343D165A",	"1F5B1D347745181E267358"},

	// 2008-09-23 by cmkwon,   ߰(븸 Netpower_Tpe) - 
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.221(48095672775D1969567E491B02)
	// PreServerIP	: 61.39.170.221		- 48095672775D1969567E491B02
	// DBServerIP	: 61.39.170.221		- 48095672775D1969567E491B02
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS221(Netpower_Tpe)_(atum2_db_account)",	"48095672775D1969567E491B02", "48095672775D1969567E491B02", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B02", 9979, "1F4C0D2C",	"1D59142D39164A"},
#endif // END - #if defined(SERVICE_TYPE_TAIWANESE_SERVER_1)

///////////////////////////////////////////////////////////////////////////////
// 2008-12-03 by cmkwon,   ߰(Ϻ Arario_Jpn) - 
#if defined(SERVICE_TYPE_JAPANESE_SERVER_1)	
	// 2009-02-04 by cmkwon, Ϻ Arario /׼ PreServerIP, DBServerIP  -  PreServer:203.191.254.181,  DBServer:203.191.254.228
	// 2009-02-10 by cmkwon, Ϻ Arario AdminTool    ߰ - Ʈ ( 43957)
	// 2009-10-26 by cmkwon, , IDC  ۾ -  PreServer:119.75.233.81,  DBServer:119.75.233.28
	// 2010. 10. 04. by hsLee.	Ϻ  IP.	- ⺻ PreServer:61.206.174.81,  DBServer:61.206.174.28
	// PreServerIP		: 61.206.174.160			- 480956737E45066F516455180504
	// DBServerIP		: 61.206.174.12				- 480956737E45066F5164551801
	// DBServerPort		: 40996
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: No##d/XGY3				- 30575B622A5C70193F63
	// LogDBServerIP	: 61.206.174.12				- 480956737E45066F5164551801
	// LogDBServerPort	: 40996
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: No##d/XGY3				- 30575B622A5C70193F63
// 2009-10-26 by cmkwon, , IDC  ۾ - 
//	{"Main      - Strike  (atum2_db_1)",		"4F09416F7946066C5563551102", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_1", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
// 	{"Main      - Delta   (atum2_db_2)",		"4F09416F7946066C5563551102", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_2", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
// 	{"Main      - Cross   (atum2_db_3)",		"4F09416F7946066C5563551102", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_3", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
// 	{"Main      - Sigma   (atum2_db_4)",		"4F09416F7946066C5563551102", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_4", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
// 	{"Main      - Omega   (atum2_db_5)",		"4F09416F7946066C5563551102", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_5", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
// 	{"Main      - Chronicle(atum2_db_6)",		"4F09416F7946066C5563551102", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_6", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
// 	{"Main      - Reserve1(atum2_db_7)",		"4F09416F7946066C5563551102", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_7", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
// 	{"Main      - Reserve2(atum2_db_8)",		"4F09416F7946066C5563551102", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_8", "4F09416F7946066C5563551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	// 2010. 10. 04. by hsLee. ServerIP . -  - PreServer : 61.206.174.81, Luna Server : 61.206.174.82, Stella Server : 61.206.174.83, DB Server : 61.206.174.28 
	// 2009-10-26 by cmkwon, , IDC  ۾ - 
// 	{"Main  - Luna(atum2_db_7)  <db_1+db_5>",			"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_7", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
// 	{"Main  - Stella(atum2_db_8)<db_2+db_3+db_4>",		"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_8", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
//	{"Main      - Backup_Strike(db_1)",					"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_1", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
//	{"Main      - Backup_Delta (db_2)",					"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_2", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
//	{"Main      - Backup_Cross (db_3)",					"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_3", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
//	{"Main      - Backup_Sigma (db_4)",					"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_4", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
//	{"Main      - Backup_Omega (db_5)",					"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_5", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
//	{"Main      - Reserve3(atum2_db_9)",				"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_9", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
//	{"Main      - Reserve3(atum2_db_10)",				"480956737E45066F5164551102", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_10", "480956737E45066F5164551B0B", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	// 2010. 10. 04. by hsLee. ServerIP .
 	{"Main		- Luna(atum2_db_7)  <db_1+db_5>",		"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_7", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
 	{"Main		- Stella(atum2_db_8)<db_2+db_3+db_4>",	"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_8", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	{"Main      - Backup_Strike(db_1)",					"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_1", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	{"Main      - Backup_Delta (db_2)",					"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_2", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	{"Main      - Backup_Cross (db_3)",					"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_3", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	{"Main      - Backup_Sigma (db_4)",					"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_4", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	{"Main      - Backup_Omega (db_5)",					"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_5", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	{"Main      - Reserve3(atum2_db_9)",				"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_9", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	{"Main      - Reserve3(atum2_db_10)",				"480956737E45066F516455180504", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_10", "480956737E45066F5164551801", 40996, "1F4C0D2C",	"30575B622A5C70193F63"},
	
	
	
	// 2009-02-04 by cmkwon, Ϻ Arario /׼ PreServerIP, DBServerIP  -  PreServer:203.191.254.156,  DBServer:203.191.254.231
	// 2009-10-26 by cmkwon, , IDC  ۾ -  PreServer:119.75.233.55,  DBServer:119.75.233.51
	// 2009-02-04 by cmkwon, Ϻ Arario /׼ PreServerIP, DBServerIP  -  PreServer:203.191.254.156,  DBServer:203.191.254.231
	// 2010-10-18 by shcho, Ϻ ׼ IP / PORTȣ  -  43957 1433 
	// PreServerIP		: 61.206.174.70			- 480956737E45066F5164551E03
	// DBServerIP		: 61.206.174.66			- 480956737E45066F5164551F05
	// DBServerPort		: 1433  
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: No##d/XGY3				- 30575B622A5C70193F63
	// LogDBServerIP	: 61.206.174.66			- 480956737E45066F5164551F05
	// LogDBServerPort	: 43957
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: No##d/XGY3				- 30575B622A5C70193F63
	{"Test      - TestServer(atum2_db_1)",	"480956737E45066F5164551E03", "480956737E45066F5164551F05", 1433, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_1", "480956737E45066F5164551F05", 43957, "1F4C0D2C",	"30575B622A5C70193F63"},

// 2008-12-31 by cmkwon, Ϻ  ġ Ϸ Ǿٰ . ӽÿ 
//	// 2008-12-10 by cmkwon, Ϻ ӽÿ
//	{"Temp for Alpha - Serv1   (atum2_db_1)",	"4C084B6F7F4A197054654F07020C15", "4C084B6F7F4A197054654F07010715", 43957, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_1", "4C084B6F7F4A197054654F07010715", 43957, "1F4C0D2C",	"30575B622A5C70193F63"},
//	{"Temp for Alpha - Serv2   (atum2_db_2)",	"4C084B6F7F4A197054654F07020C15", "4C084B6F7F4A197054654F07010715", 43957, "1F4C0D2C",	"30575B622A5C70193F63",		"atum2_db_2", "4C084B6F7F4A197054654F07010715", 43957, "1F4C0D2C",	"30575B622A5C70193F63"},

	// 2008-12-03 by cmkwon,   ߰(Ϻ Arario_Jpn) - 
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.222(48095672775D1969567E491B01)
	// PreServerIP	: 61.39.170.222		- 48095672775D1969567E491B01
	// DBServerIP	: 61.39.170.222		- 48095672775D1969567E491B01
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS222(Arario_Jpn)_(atum2_db_account)",	"48095672775D1969567E491B01", "48095672775D1969567E491B01", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B01", 9979, "1F4C0D2C",	"1D59142D39164A"},
#endif // END - #if defined(SERVICE_TYPE_JAPANESE_SERVER_1)

	// 2008-12-22 by cmkwon,   ߰(Gameforge4D Ű, Ҿ, Żƾ) -
#if defined(SERVICE_TYPE_TURKISH_SERVER_1)
	// 2008-12-22 by cmkwon,   ߰(Gameforge4D Ű, Ҿ, Żƾ) -   
	// 2009-01-15 by cmkwon, Ű    -   IP Domain 
	// 2009-05-18 by cmkwon, ͱ  DBServer Port  - (9979)
	// PreServerIP		: solus.airrivals.org		- 0D5714343D5D49371422125F52585706091105
	// DBServerIP		: speicher.airrivals.org	- 0D481D282D1B4D2C4831125B415D52490A104C3B3C43
	// DBServerPort		: 9980
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: vm/-ekQcjqnf				- 0855576C2B18793D0C21154F
	// LogDBServerIP	: speicher.airrivals.org	- 0D481D282D1B4D2C4831125B415D52490A104C3B3C43
	// LogDBServerPort	: 9980
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: vm/-ekQcjqnf				- 0855576C2B18793D0C21154F
	{"Main      - Server_1 (atum2_db_1)",		"0D5714343D5D49371422125F52585706091105", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_1", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Server_2 (atum2_db_2)",		"0D5714343D5D49371422125F52585706091105", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_2", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Server_3 (atum2_db_3)",		"0D5714343D5D49371422125F52585706091105", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_3", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Reserve1 (atum2_db_4)",		"0D5714343D5D49371422125F52585706091105", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_4", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Reserve2 (atum2_db_5)",		"0D5714343D5D49371422125F52585706091105", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_5", "0D481D282D1B4D2C4831125B415D52490A104C3B3C43", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	
	// 2009-01-09 by dhjin,   ߰(Gameforge4D Ű, Ҿ, Żƾ)
	// 2010-03-19 by cmkwon, Ű ׼ IP  - (79.110.95.14)
	// PreServerIP		: 79.110.95.32			- 490156707F430667537E481B
	// DBServerIP		: 79.110.95.32			- 490156707F430667537E481B
	// DBServerPort		: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// LogDBServerIP	: 79.110.95.32			- 490156707F430667537E481B
	// LogDBServerPort	: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	{"Test    - TestServer(atum2_db_1)",	"490156707F430667537E481B", "490156707F430667537E481B", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "490156707F430667537E481B", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
	// 2008-12-22 by cmkwon,   ߰(Gameforge4D Ű, Ҿ, Żƾ) -
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.223(48095672775D1969567E491B00)
	// PreServerIP	: 61.39.170.223		- 48095672775D1969567E491B00
	// DBServerIP	: 61.39.170.223		- 48095672775D1969567E491B00
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS223(Gameforge4D_Tur)_(atum2_db_account)",		"48095672775D1969567E491B00", "48095672775D1969567E491B00", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B00", 9979, "1F4C0D2C",	"1D59142D39164A"},

#endif // END - #if defined(SERVICE_TYPE_TURKISH_SERVER_1)

	// 2009-01-13 by cmkwon, Ż    ߰ - AdminTool,DBTool,Monitor   Ʈ ߰
#if defined(SERVICE_TYPE_ITALIAN_SERVER_1)
	// 2009-01-13 by cmkwon, Ż    ߰ -   
	// PreServerIP		: s1.airrivals.it			- 0D09562027015A371031175A1D5D50
	// DBServerIP		: speicher.airrivals.it		- 0D481D282D1B4D2C4831125B415D52490A104C3D3A
	// DBServerPort		: 9980
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: vm/-ekQcjqnf				- 0855576C2B18793D0C21154F
	// LogDBServerIP	: speicher.airrivals.it		- 0D481D282D1B4D2C4831125B415D52490A104C3D3A
	// LogDBServerPort	: 9980
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: vm/-ekQcjqnf				- 0855576C2B18793D0C21154F
	{"Main      - Server_1 (atum2_db_1)",		"0D09562027015A371031175A1D5D50", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_1", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Server_2 (atum2_db_2)",		"0D09562027015A371031175A1D5D50", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_2", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Server_3 (atum2_db_3)",		"0D09562027015A371031175A1D5D50", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_3", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Reserve1 (atum2_db_4)",		"0D09562027015A371031175A1D5D50", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_4", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	{"Main      - Reserve2 (atum2_db_5)",		"0D09562027015A371031175A1D5D50", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F",		"atum2_db_5", "0D481D282D1B4D2C4831125B415D52490A104C3D3A", 9980, "1F4C0D2C",	"0855576C2B18793D0C21154F"},
	
	// 2009-01-20 by cmkwon, Ż ׼  ޾Ƽ  - 
	// PreServerIP		: 79.110.95.16			- 490156707F430667537E4A1F
	// DBServerIP		: 79.110.95.16			- 490156707F430667537E4A1F
	// DBServerPort		: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// LogDBServerIP	: 79.110.95.16			- 490156707F430667537E4A1F
	// LogDBServerPort	: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	{"Test    - TestServer(atum2_db_1)",	"490156707F430667537E4A1F", "490156707F430667537E4A1F", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "490156707F430667537E4A1F", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
	// 2009-01-13 by cmkwon, Ż    ߰ -   
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.224(48095672775D1969567E491B07)
	// PreServerIP	: 61.39.170.224		- 48095672775D1969567E491B07
	// DBServerIP	: 61.39.170.224		- 48095672775D1969567E491B07
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS224(Gameforge4D_Ita)_(atum2_db_account)",		"48095672775D1969567E491B07", "48095672775D1969567E491B07", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B07", 9979, "1F4C0D2C",	"1D59142D39164A"},

#endif // END - #if defined(SERVICE_TYPE_ITALIAN_SERVER_1)

	// 2009-03-03 by cmkwon,   ߰(Gameforge4D  ) - 
#if defined(SERVICE_TYPE_FRENCH_SERVER_1)
	// 2009-03-03 by cmkwon,   ߰(Gameforge4D  ) -  
	// PreServerIP		: s1.airrivals.fr			- 0D09562027015A371031175A1D5256
	// DBServerIP		: speicher.airrivals.fr		- 0D481D282D1B4D2C4831125B415D52490A104C323C
	// DBServerPort		: 9979
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: aktkd1226game				- 1F530C2A2A421A6C50371A4456
	// LogDBServerIP	: speicher.airrivals.fr		- 0D481D282D1B4D2C4831125B415D52490A104C323C
	// LogDBServerPort	: 9979
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: aktkd1226game				- 1F530C2A2A421A6C50371A4456
	{"Main      - Server_1 (atum2_db_1)",		"0D09562027015A371031175A1D5256", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_1", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Server_2 (atum2_db_2)",		"0D09562027015A371031175A1D5256", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_2", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Server_3 (atum2_db_3)",		"0D09562027015A371031175A1D5256", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_3", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Reserve1 (atum2_db_4)",		"0D09562027015A371031175A1D5256", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_4", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Reserve2 (atum2_db_5)",		"0D09562027015A371031175A1D5256", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_5", "0D481D282D1B4D2C4831125B415D52490A104C323C", 9979, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	
	// 2009-03-03 by cmkwon,   ߰(Gameforge4D  ) - ׼ 
	// PreServerIP		: 79.110.95.20			- 490156707F430667537E4919
	// DBServerIP		: 79.110.95.20			- 490156707F430667537E4919
	// DBServerPort		: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// LogDBServerIP	: 79.110.95.20			- 490156707F430667537E4919
	// LogDBServerPort	: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	{"Test    - TestServer(atum2_db_1)",	"490156707F430667537E4919", "490156707F430667537E4919", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "490156707F430667537E4919", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
	// 2009-03-03 by cmkwon,   ߰(Gameforge4D  ) -    
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.225(48095672775D1969567E491B06)
	// PreServerIP	: 61.39.170.225		- 48095672775D1969567E491B06
	// DBServerIP	: 61.39.170.225		- 48095672775D1969567E491B06
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS225(Gameforge4D_Fra)_(atum2_db_account)",		"48095672775D1969567E491B06", "48095672775D1969567E491B06", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B06", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
#endif // END - #if defined(SERVICE_TYPE_FRENCH_SERVER_1)

	// 2009-06-04 by cmkwon,   ߰(Gameforge4D , ξ) - ߰
#if defined(SERVICE_TYPE_POLISH_SERVER_1)
	// 2009-06-04 by cmkwon,   ߰(Gameforge4D , ξ) -  
	// PreServerIP		: s1.airrivals.pl			- 0D09562027015A371031175A1D4448
	// DBServerIP		: speicher.airrivals.pl		- 0D481D282D1B4D2C4831125B415D52490A104C2422
	// DBServerPort		: 9981
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: aktkd1226game				- 1F530C2A2A421A6C50371A4456
	// LogDBServerIP	: speicher.airrivals.pl		- 0D481D282D1B4D2C4831125B415D52490A104C2422
	// LogDBServerPort	: 9981
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: aktkd1226game				- 1F530C2A2A421A6C50371A4456
	{"Main      - Server_1 (atum2_db_1)",		"0D09562027015A371031175A1D4448", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_1", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Server_2 (atum2_db_2)",		"0D09562027015A371031175A1D4448", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_2", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Server_3 (atum2_db_3)",		"0D09562027015A371031175A1D4448", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_3", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Reserve1 (atum2_db_4)",		"0D09562027015A371031175A1D4448", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_4", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Reserve2 (atum2_db_5)",		"0D09562027015A371031175A1D4448", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_5", "0D481D282D1B4D2C4831125B415D52490A104C2422", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	
	// 2009-06-04 by cmkwon,   ߰(Gameforge4D , ξ) - ׼ 
	// PreServerIP		: test.airrivals.pl		- 0A5D0B356012412C14390D485F470A580A
	// DBServerIP		: test.airrivals.pl		- 0A5D0B356012412C14390D485F470A580A
	// DBServerPort		: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// LogDBServerIP	: test.airrivals.pl		- 0A5D0B356012412C14390D485F470A580A
	// LogDBServerPort	: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	{"Test    - TestServer(atum2_db_1)",	"0A5D0B356012412C14390D485F470A580A", "0A5D0B356012412C14390D485F470A580A", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "0A5D0B356012412C14390D485F470A580A", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
	// 2009-03-03 by cmkwon,   ߰(Gameforge4D  ) -    
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.226(48095672775D1969567E491B05)
	// PreServerIP	: 61.39.170.226		- 48095672775D1969567E491B05
	// DBServerIP	: 61.39.170.226		- 48095672775D1969567E491B05
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS226(Gameforge4D_Pol)_(atum2_db_account)",		"48095672775D1969567E491B05", "48095672775D1969567E491B05", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B05", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
#endif // END - #if defined(SERVICE_TYPE_POLISH_SERVER_1)

	// 2009-07-10 by cmkwon, Gameforge4D    غ - 
#if defined(SERVICE_TYPE_SPANISH_SERVER_1)
	// 2009-07-10 by cmkwon, Gameforge4D    غ -  
	// PreServerIP		: s1.airrivals.es			- 0D09562027015A371031175A1D5157
	// DBServerIP		: speicher.airrivals.es		- 0D481D282D1B4D2C4831125B415D52490A104C313D
	// DBServerPort		: 9981
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: aktkd1226game				- 1F530C2A2A421A6C50371A4456
	// LogDBServerIP	: speicher.airrivals.es		- 0D481D282D1B4D2C4831125B415D52490A104C313D
	// LogDBServerPort	: 9981
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: aktkd1226game				- 1F530C2A2A421A6C50371A4456
	{"Main      - Server_1 (atum2_db_1)",		"0D09562027015A371031175A1D5157", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_1", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Server_2 (atum2_db_2)",		"0D09562027015A371031175A1D5157", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_2", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Server_3 (atum2_db_3)",		"0D09562027015A371031175A1D5157", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_3", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Reserve1 (atum2_db_4)",		"0D09562027015A371031175A1D5157", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_4", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	{"Main      - Reserve2 (atum2_db_5)",		"0D09562027015A371031175A1D5157", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456",		"atum2_db_5", "0D481D282D1B4D2C4831125B415D52490A104C313D", 9981, "1F4C0D2C",	"1F530C2A2A421A6C50371A4456"},
	
	// 2009-07-10 by cmkwon, Gameforge4D    غ - ׼ 
	// PreServerIP		: test.airrivals.es		- 0A5D0B356012412C14390D485F470A4D15
	// DBServerIP		: test.airrivals.es		- 0A5D0B356012412C14390D485F470A4D15
	// DBServerPort		: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// LogDBServerIP	: test.airrivals.es		- 0A5D0B356012412C14390D485F470A4D15
	// LogDBServerPort	: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	{"Test    - TestServer(atum2_db_1)",	"0A5D0B356012412C14390D485F470A4D15", "0A5D0B356012412C14390D485F470A4D15", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "0A5D0B356012412C14390D485F470A4D15", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
	// 2009-07-10 by cmkwon, Gameforge4D    غ -    
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.227(48095672775D1969567E491B04)
	// PreServerIP	: 61.39.170.227		- 48095672775D1969567E491B04
	// DBServerIP	: 61.39.170.227		- 48095672775D1969567E491B04
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS227(Gameforge4D_Esp)_(atum2_db_account)",		"48095672775D1969567E491B04", "48095672775D1969567E491B04", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B04", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
#endif // END - #if defined(SERVICE_TYPE_SPANISH_SERVER_1)

	// 2010-11-01 by shcho, Lin ƸƼ   غ - 
#if defined(SERVICE_TYPE_ARGENTINA_SERVER_1)
	// 2010-11-01 by shcho, Lin ƸƼ   غ -  
	// PreServerIP		: 209.251.187.183			- 4C08416F7C46197057684C07020C17
	// DBServerIP		: 10.122.174.214			- 4F0856707C41066F5164551B0200
	// DBServerPort		: 9979
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: callweb					- 1D59142D39164A
	// LogDBServerIP	: 10.122.174.214			- 4F0856707C41066F5164551B0200
	// LogDBServerPort	: 9979
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: callweb					- 1D59142D39164A
	
	// arg_main - // Lin_Arg_Main_PreServer(209.251.187.183) = 4C08416F7C46197057684C07020C17
	{"Main      - Server_1 (atum2_db_1)",		"4C08416F7C46197057684C07020C17", "4F0856707C41066F5164551B0200", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "4F0856707C41066F5164551B0200", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
	// 2010-11-01 by shcho, Lin ƸƼ   غ - ׼ 
	// PreServerIP		: 209.251.187.187		- 4C08416F7C46197057684C07020C13
	// DBServerIP		: 209.251.187.187		- 4C08416F7C46197057684C07020C13
	// DBServerPort		: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// LogDBServerIP	: test.airrivals.es		- 0A5D0B356012412C14390D485F470A4D15
	// LogDBServerPort	: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// 10.121.60.141 4F0856707C420668567E4A1D02
	// arg_test - // Lin_Arg_Test_PreServer(209.251.187.187) = 4C08416F7C46197057684C07020C13
	{"Test    - TestServer(atum2_db_1)",	"4F0856707C420668567E4A1D02", "4F0856707C420668567E4A1D02", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "4F0856707C420668567E4A1D02", 9979, "1F4C0D2C",	"1D59142D39164A"},
	// 2009-07-10 by cmkwon, Gameforge4D    غ -    
	// 2009-12-28 by cmkwon, ȸ IP  - 61.39.170.228(48095672775D1969567E491B0B)
	// PreServerIP	: 61.39.170.228		- 48095672775D1969567E491B0B
	// DBServerIP	: 61.39.170.228		- 48095672775D1969567E491B0B
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	// {"MS228(Lin_Ang)_(atum2_db_account)",		"48095672775D1969567E491B0B", "48095672775D1969567E491B0B", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491B0B", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
#endif // END - #if defined(SERVICE_TYPE_ARGENTINA_SERVER_1)

#if defined(SERVICE_TYPE_SINGAPORE_1)	
	// 2010-12-07 by shcho,	   غ (WinnerOnline ) -  
	// PreServerIP		: 114.129.32.181(ܺ)		- 4F094C6F7F411170556255180B05
	// DBServerIP		: 114.129.32.170(ܺ)		- 4F094C6F7F411170556255180404 // 2010-12-21 by shcho, ܺ IP  -   IP
	// DBServerPort		: 9979
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: callweb					- 1D59142D39164A
	// LogDBServerIP	: 114.129.32.170(ܺ)		- 4F094C6F7F411170556255180404 // 2010-12-21 by shcho, ܺ IP  -   IP
	// LogDBServerPort	: 9979
	// DB User			: atum						- 1F4C0D2C
	// DB PWD			: callweb					- 1D59142D39164A
	{"Main      - Server_1 (atum2_db_1)",		"4F094C6F7F411170556255180B05", "4F094C6F7F411170556255180404", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "4F094C6F7F411170556255180404", 9979, "1F4C0D2C",	"1D59142D39164A"},
	{"Main      - Server_2 (atum2_db_2)",		"4F094C6F7F411170556255180B05", "4F094C6F7F411170556255180404", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_2", "4F094C6F7F411170556255180404", 9979, "1F4C0D2C",	"1D59142D39164A"},
	{"Main      - Server_3 (atum2_db_3)",		"4F094C6F7F411170556255180B05", "4F094C6F7F411170556255180404", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_3", "4F094C6F7F411170556255180404", 9979, "1F4C0D2C",	"1D59142D39164A"},

	
	// 2010-12-07 by shcho,	   غ (WinnerOnline ) - ׼ 
	// PreServerIP		: 180.178.110.34(ܺ)	- 4F00486F7F44107057614B070000
	// DBServerIP		: 180.178.110.33(ܺ)	- 4F00486F7F44107057614B070007 // 2010-12-21 by shcho, ܺ IP  -   IP
	// DBServerPort		: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// LogDBServerIP	: 180.178.110.33(ܺ)	- 4F00486F7F44107057614B070007 // 2010-12-21 by shcho, ܺ IP  -   IP
	// LogDBServerPort	: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	{"Test    - TestServer1(atum2_db_1)",	"4F00486F7F44107057614B070000", "4F00486F7F44107057614B070007", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "4F00486F7F44107057614B070007", 9979, "1F4C0D2C",	"1D59142D39164A"},
	// 2010-12-07 by shcho,	   غ (WinnerOnline ) - ׼ 
	// PreServerIP		: 114.129.32.166(ܺ)	- 4F094C6F7F411170556255180502
	// DBServerIP		: 114.129.32.165(ܺ)	- 4F094C6F7F411170556255180501 // 2010-12-21 by shcho, ܺ IP  -   IP
	// DBServerPort		: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	// LogDBServerIP	: 114.129.32.165(ܺ)	- 4F094C6F7F411170556255180501 // 2010-12-21 by shcho, ܺ IP  -   IP
	// LogDBServerPort	: 9979
	// DB User			: atum					- 1F4C0D2C
	// DB PWD			: callweb				- 1D59142D39164A
	{"Test    - TestServer2(atum2_db_1)",	"4F094C6F7F411170556255180502", "4F094C6F7F411170556255180501", 9979, "1F4C0D2C",	"1D59142D39164A",		"atum2_db_1", "4F094C6F7F411170556255180501", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2010-12-07 by shcho,	   غ (WinnerOnline ) -   ׼ 
	// PreServerIP	: 61.39.170.202		- 48095672775D1969567E491901
	// DBServerIP	: 61.39.170.202		- 48095672775D1969567E491901
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS202(WinnerOnline_Sgp)_(atum2_db_account)",		"48095672775D1969567E491901", "48095672775D1969567E491901", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491901", 9979, "1F4C0D2C",	"1D59142D39164A"},
	
#endif // END - #if defined(SERVICE_TYPE_SINGAPORE_1)

#if defined(SERVICE_TYPE_INDONESIA_SERVER_1)
	
	// 2010-01-11 by shcho,	   ߰(WinnerOnline ε׽þƾ) -    
	// atum2_db_1
	// PreServerIP	: 180.178.110.70	- 4F00486F7F44107057614B070404
	// DBServerIP	: 180.178.110.72	- 4F00486F7F44107057614B070406
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A

	{"Main      - Server_1 (atum2_db_1)",		"4F00486F7F44107057614B070404", "4F00486F7F44107057614B070406", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",	"4F00486F7F44107057614B070406", 9979, "1F4C0D2C",	"1D59142D39164A"},
	{"Main      - Server_2 (atum2_db_2)",		"4F00486F7F44107057614B070404", "4F00486F7F44107057614B070406", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_2",	"4F00486F7F44107057614B070406", 9979, "1F4C0D2C",	"1D59142D39164A"},
	{"Main      - Server_3 (atum2_db_3)",		"4F00486F7F44107057614B070404", "4F00486F7F44107057614B070406", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_3",	"4F00486F7F44107057614B070406", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2010-01-11 by shcho,	   ߰(WinnerOnline ε׽þƾ) -    
	// atum2_db_1
	// PreServerIP	: 180.178.110.34	- 4F00486F7F44107057614B070000
	// DBServerIP	: 180.178.110.33	- 4F00486F7F44107057614B070007
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"Test      - Server_1 (atum2_db_1)",		"4F00486F7F44107057614B070000", "4F00486F7F44107057614B070007", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",	"4F00486F7F44107057614B070007", 9979, "1F4C0D2C",	"1D59142D39164A"},

	// 2010-01-11 by shcho,	   ߰(WinnerOnline ε׽þƾ) -    
	// PreServerIP	: 61.39.170.203		- 48095672775D1969567E491900
	// DBServerIP	: 61.39.170.203		- 48095672775D1969567E491900
	// DB User		: atum				- 1F4C0D2C
	// DB PWD		: callweb			- 1D59142D39164A
	{"MS203(WinnerOnline_Idn)_(atum2_db_account)",		"48095672775D1969567E491900", "48095672775D1969567E491900", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"48095672775D1969567E491900", 9979, "1F4C0D2C",	"1D59142D39164A"},
#endif //defined(SERVICE_TYPE_INDONESIA_SERVER_1)


// 2008-08-29 by cmkwon, AdminTool,DBTool  Ʈ  (񽺺 ̰) - 
// #else // _ATUM_ADMIN_RELEASE
// 	// 2008-08-20 by cmkwon, ߰   . - Ʒ ̸   .
// 
// 	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.140(4F0A496F7F401C7057614F07020014), 121.134.114.140(4F0A496F7F401C7057614F07020014), atum(1F4C0D2C), callweb(1D59142D39164A)
// 	{"MS140(Masang_Kor)_(atum2_db_account)",				"4F0A496F7F401C7057614F07020014", "4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS140(Masang)_Kor(atum2_db_account_test)",		"4F0A496F7F401C7057614F07020014", "4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 
// 	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.141(4F0A496F7F401C7057614F07020015), 121.134.114.141(4F0A496F7F401C7057614F07020015), atum(1F4C0D2C), callweb(1D59142D39164A)
// 	{"MS141(Yedang_Kor)_(atum2_db_account)",				"4F0A496F7F401C7057614F07020015", "4F0A496F7F401C7057614F07020015", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020015", 9979, "1F4C0D2C",	"1D59142D39164A"},			// 2006-09-21 by cmkwon
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS141(Yedang)_Kor(atum2_db_account_test)",		"4F0A496F7F401C7057614F07020015", "4F0A496F7F401C7057614F07020015", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020015", 9979, "1F4C0D2C",	"1D59142D39164A"},		// 2006-09-21 by cmkwon
// 
// 	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.142(4F0A496F7F401C7057614F07020016), 121.134.114.142(4F0A496F7F401C7057614F07020016), atum(1F4C0D2C), callweb(1D59142D39164A)
// 	{"MS142(Wikigames_Eng)_(atum2_db_account)",		"4F0A496F7F401C7057614F07020016", "4F0A496F7F401C7057614F07020016", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020016", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS142(Yedang-Global)_Eng(atum2_db_account_test)",	"4F0A496F7F401C7057614F07020016", "4F0A496F7F401C7057614F07020016", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020016", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 	
// 	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.143(4F0A496F7F401C7057614F07020017), 121.134.114.143(4F0A496F7F401C7057614F07020017), atum(1F4C0D2C), callweb(1D59142D39164A)
// 	{"MS143(VTC-Intecom_Viet)_(atum2_db_account)",		"4F0A496F7F401C7057614F07020017", "4F0A496F7F401C7057614F07020017", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020017", 9979, "1F4C0D2C",	"1D59142D39164A"},			// 2006-03-24 by cmkwon
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS143(VTC-Intecom)_Viet(atum2_db_account_test)",	"4F0A496F7F401C7057614F07020017", "4F0A496F7F401C7057614F07020017", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020017", 9979, "1F4C0D2C",	"1D59142D39164A"},		// 2006-03-24 by cmkwon
// 	
// 	// 2007-10-24 by cmkwon,   ȣȭ - 121.134.114.146(4F0A496F7F401C7057614F07020012), 121.134.114.146(4F0A496F7F401C7057614F07020012), atum(1F4C0D2C), callweb(1D59142D39164A)
// 	{"MS146(Yetime_Chn)_(atum2_db_account)",				"4F0A496F7F401C7057614F07020012", "4F0A496F7F401C7057614F07020012", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020012", 9979, "1F4C0D2C",	"1D59142D39164A"},			// 2007-06-13 by dhjin
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS146(Yetime)_Chn(atum2_db_account_test)",		"4F0A496F7F401C7057614F07020012", "4F0A496F7F401C7057614F07020012", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020012", 9979, "1F4C0D2C",	"1D59142D39164A"},		// 2007-06-13 by dhjin
// 
// 	// 2008-01-04 by cmkwon, Gameforge4D ߰ - 
// 	// PreServerIP	: 121.134.114.145	- 4F0A496F7F401C7057614F07020011
// 	// DBServerIP	: 121.134.114.145	- 4F0A496F7F401C7057614F07020011
// 	// DB User		: atum				- 1F4C0D2C
// 	// DB PWD		: callweb			- 1D59142D39164A
// 	{"MS145(Gameforge4D_Eng)_(atum2_db_account)",		"4F0A496F7F401C7057614F07020011", "4F0A496F7F401C7057614F07020011", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020011", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS145(Gameforge4D_Eng)_(atum2_db_account_test)",	"4F0A496F7F401C7057614F07020011", "4F0A496F7F401C7057614F07020011", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020011", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 
// 	// 2008-04-25 by cmkwon, Gameforge4D_Deu ߰ - 
// 	// PreServerIP	: 121.134.114.147	- 4F0A496F7F401C7057614F07020013
// 	// DBServerIP	: 121.134.114.147	- 4F0A496F7F401C7057614F07020013
// 	// DB User		: atum				- 1F4C0D2C
// 	// DB PWD		: callweb			- 1D59142D39164A
// 	{"MS147(Gameforge4D_Deu)_(atum2_db_account)",		"4F0A496F7F401C7057614F07020013", "4F0A496F7F401C7057614F07020013", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020013", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 	{"MS147(Gameforge4D_Deu_MySQL)_(atum2_db_account)",	"4F0A496F7F401C7057614F07020013", "4F0A496F7F401C7057614F07020013", 3306, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020013", 3306, "1F4C0D2C",	"1D59142D39164A"},
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS147(Gameforge4D_Deu)_(atum2_db_account_test)",	"4F0A496F7F401C7057614F07020013", "4F0A496F7F401C7057614F07020013", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020013", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 
// 	// 2008-05-07 by cmkwon, WinnerOnline_Tha ߰ϱ - 
// 	// PreServerIP	: 121.134.114.148	- 4F0A496F7F401C7057614F0702001C
// 	// DBServerIP	: 121.134.114.148	- 4F0A496F7F401C7057614F0702001C
// 	// DB User		: atum				- 1F4C0D2C
// 	// DB PWD		: callweb			- 1D59142D39164A
// 	{"MS148(WinnerOnline_Tha)_(atum2_db_account)",		"4F0A496F7F401C7057614F0702001C", "4F0A496F7F401C7057614F0702001C", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS148(WinnerOnline_Tha)_(atum2_db_account_test)",	"4F0A496F7F401C7057614F0702001C", "4F0A496F7F401C7057614F0702001C", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 
// 	// 2008-06-19 by cmkwon, Innova_Rus  ׽Ʈ  ߰ - 
// 	// PreServerIP	: 121.134.114.220	- 4F0A496F7F401C7057614F07010614
// 	// DBServerIP	: 121.134.114.220	- 4F0A496F7F401C7057614F07010614
// 	// DB User		: atum				- 1F4C0D2C
// 	// DB PWD		: callweb			- 1D59142D39164A
// 	{"MS220(Innova_Rus)_(atum2_db_account)",		"4F0A496F7F401C7057614F07010614", "4F0A496F7F401C7057614F07010614", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07010614", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 	// 2008-08-20 by cmkwon, 
// 	//{"MS220(Innova_Rus)_(atum2_db_account_test)",	"4F0A496F7F401C7057614F07010614", "4F0A496F7F401C7057614F07010614", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_test",	"4F0A496F7F401C7057614F07010614", 9979, "1F4C0D2C",	"1D59142D39164A"},
// 
// 	// 2008-04-30 by cmkwon, ׽Ʈ ߰  
// 	// PreServerIP	: 121.134.114.150	- 4F0A496F7F401C7057614F07020114
// 	{"MS150(Masang_Kor)_(atum2_db_account)",		"4F0A496F7F401C7057614F07020114", "4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A",	"atum2_db_1",		"4F0A496F7F401C7057614F07020014", 9979, "1F4C0D2C",	"1D59142D39164A"},
// #endif // _ATUM_ADMIN_RELEASE
	{NULL, NULL, NULL, 0, NULL, NULL}
	// ServerName, PreServerIP, DBIP, DBPort, DBUID, DBPWD, DBName
};
#else // _ATUM_CLIENT
GAME_SERVER_INFO_FOR_ADMIN g_arrGameServers[] = 
{
	{NULL, NULL, NULL, 0, NULL, NULL}
};
#endif // _ATUM_CLIENT


///////////////////////////////////////////////////////////////////////////////
/// \fn			void GDecryptGameServerInfoByXOR(void)
/// \brief		// 2007-10-24 by cmkwon,   ȣȭ -
/// \author		cmkwon
/// \date		2007-10-24 ~ 2007-10-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void GDecryptGameServerInfoByXOR(void)
{
#ifndef _ATUM_CLIENT

	for(int i = 0; g_arrGameServers[i].ServerName != NULL; i++)
	{
		BYTE byEncodedBinary[1024];

		memset(byEncodedBinary, 0x00, 1024);
		if(XOR::XORString2Binary(byEncodedBinary, g_arrGameServers[i].XOREncodedServerIP))
		{
			XOR::XOREncode((BYTE*)g_arrGameServers[i].ServerIP, byEncodedBinary, strlen(g_arrGameServers[i].XOREncodedServerIP)/2, STR_XOR_KEY_STRING_SERVER_INFO);
		}

		memset(byEncodedBinary, 0x00, 1024);
		if(XOR::XORString2Binary(byEncodedBinary, g_arrGameServers[i].XOREncodedDBIP))
		{
			XOR::XOREncode((BYTE*)g_arrGameServers[i].DBIP, byEncodedBinary, strlen(g_arrGameServers[i].XOREncodedDBIP)/2, STR_XOR_KEY_STRING_SERVER_INFO);
		}

		memset(byEncodedBinary, 0x00, 1024);
		if(XOR::XORString2Binary(byEncodedBinary, g_arrGameServers[i].XOREncodedDBUID))
		{
			XOR::XOREncode((BYTE*)g_arrGameServers[i].DBUID, byEncodedBinary, strlen(g_arrGameServers[i].XOREncodedDBUID)/2, STR_XOR_KEY_STRING_SERVER_INFO);
		}

		memset(byEncodedBinary, 0x00, 1024);
		if(XOR::XORString2Binary(byEncodedBinary, g_arrGameServers[i].XOREncodedDBPWD))
		{
			XOR::XOREncode((BYTE*)g_arrGameServers[i].DBPWD, byEncodedBinary, strlen(g_arrGameServers[i].XOREncodedDBPWD)/2, STR_XOR_KEY_STRING_SERVER_INFO);
		}
		
		///////////////////////////////////////////////////////////////////////////////		
		// 2007-11-07 by cmkwon, α DB   ϱ - GAME_SERVER_INFO_FOR_ADMIN  4 ʵ ߰
		// 2007-11-07 by cmkwon, LogDBIP, LogDBUID, LogDBPWD  ʵ ڵ Ǿ Ƿ Ʒ  ȣȭ ؾ 
		char szEncryptData[1024];

		memset(szEncryptData, 0x00, 1024);
		strncpy(szEncryptData, g_arrGameServers[i].LogDBIP, 2*SIZE_MAX_ADDRESS - 1);		// 2009-01-15 by cmkwon, PreServer, DBServer  DNS  ϰ  - (SIZE_MAX_IPADDRESS)
		memset(g_arrGameServers[i].LogDBIP, 0x00, 2*SIZE_MAX_ADDRESS);						// 2009-01-15 by cmkwon, PreServer, DBServer  DNS  ϰ  - (SIZE_MAX_IPADDRESS)
		memset(byEncodedBinary, 0x00, 1024);
		if(XOR::XORString2Binary(byEncodedBinary, szEncryptData))
		{
			XOR::XOREncode((BYTE*)g_arrGameServers[i].LogDBIP, byEncodedBinary, strlen(szEncryptData)/2, STR_XOR_KEY_STRING_SERVER_INFO);
		}

		memset(szEncryptData, 0x00, 1024);
		strncpy(szEncryptData, g_arrGameServers[i].LogDBUID, 2*SIZE_MAX_DB_USER_ID - 1);
		memset(g_arrGameServers[i].LogDBUID, 0x00, 2*SIZE_MAX_DB_USER_ID);
		memset(byEncodedBinary, 0x00, 1024);
		if(XOR::XORString2Binary(byEncodedBinary, szEncryptData))
		{
			XOR::XOREncode((BYTE*)g_arrGameServers[i].LogDBUID, byEncodedBinary, strlen(szEncryptData)/2, STR_XOR_KEY_STRING_SERVER_INFO);
		}
		
		memset(szEncryptData, 0x00, 1024);
		strncpy(szEncryptData, g_arrGameServers[i].LogDBPWD, 2*SIZE_MAX_DB_USER_PWD - 1);
		memset(g_arrGameServers[i].LogDBPWD, 0x00, 2*SIZE_MAX_DB_USER_PWD);
		memset(byEncodedBinary, 0x00, 1024);
		if(XOR::XORString2Binary(byEncodedBinary, szEncryptData))
		{
			XOR::XOREncode((BYTE*)g_arrGameServers[i].LogDBPWD, byEncodedBinary, strlen(szEncryptData)/2, STR_XOR_KEY_STRING_SERVER_INFO);
		}
	}
#endif
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			char *GetDayOfWeekString(int i_nDayOfWeek)
/// \brief		// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  -
/// \author		cmkwon
/// \date		2007-10-30 ~ 2007-10-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *GetDayOfWeekString(int i_nDayOfWeek)
{
	switch(i_nDayOfWeek)
	{
	case DAY_OF_WEEK_SUMDAY:				return "Sunday";
	case DAY_OF_WEEK_MONDAY:				return "Monday";
	case DAY_OF_WEEK_TUESDAY:				return "Tuesday";
	case DAY_OF_WEEK_WEDNESDAY:				return "Wednesday";
	case DAY_OF_WEEK_THURSDAY:				return "Thursday";
	case DAY_OF_WEEK_FRIDAY:				return "Friday";
	case DAY_OF_WEEK_SATURDAY:				return "Saturday";
	case DAY_OF_WEEK_HAPPYHOUREVENT_PERIOD:	return "HappyHourEventPeriod";
	case DAY_OF_WEEK_PCBANG_HAPPYHOUREVENT:	return "PCBangHappyHourEventPeriod";
	}
	return "Unknown day of week";	
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			char *GetWPUTString(BYTE i_byWPUT)
/// \brief		// 2009-01-22 by cmkwon,    α  - 
/// \author		cmkwon
/// \date		2009-01-22 ~ 2009-01-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *GetWPUTString(BYTE i_byWPUT)
{
	switch(i_byWPUT)
	{
	case WPUT_GENERAL:				return "WPUT_GENERAL";
	case WPUT_ARENA:				return "WPUT_ARENA";
	case WPUT_MOTHERSHIPWAR:		return "WPUT_MOTHERSHIPWAR";
	case WPUT_STRATEGYPOINTWAR:		return "WPUT_STRATEGYPOINTWAR";
	case WPUT_OUTPOSTWAR:			return "WPUT_OUTPOSTWAR";
	case WPUT_SHOP:					return "WPUT_SHOP";
	case WPUT_ADMIN_COMMAND:		return "WPUT_ADMIN_COMMAND";
	}

	return WPUT_UNKNOWN;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			char *LowercaseOnly_i_forTurkish(char *i_szString, int i_nMaxLen)
/// \brief		// 2009-01-23 by cmkwon, Ű i,I   ó -
/// \author		cmkwon
/// \date		2009-01-23 ~ 2009-01-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *LowercaseOnly_i_forTurkish(char *i_szString, int i_nMaxLen)
{
#if defined(SERVICE_TYPE_TURKISH_SERVER_1)
	char *	pCurChar	= i_szString;
	int		nLen		= min(i_nMaxLen, strlen(i_szString));
	while(pCurChar && pCurChar < i_szString + nLen)
	{
		// 2009-01-23 by cmkwon, Iڸ i 
		if('I' == *pCurChar)
		{
			*pCurChar = 'i';
		}
		
		pCurChar = CharNext(pCurChar);		// 2007-12-05 by cmkwon,  ڷ ̵
	}
#endif
	return i_szString;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			int GetArrIdxByUnitMaskforWRK(INT i_unitMask)
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-18 ~ 2009-02-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
int GetArrIdxByUnitMaskforWRK(INT i_unitMask)
{
	if(UNITKIND_ALL_MASK == i_unitMask)
	{
		return 0;
	}

	if(COMPARE_BIT_FLAG(i_unitMask, UNITKIND_BGEAR))
	{
		return 1;
	}
	if(COMPARE_BIT_FLAG(i_unitMask, UNITKIND_MGEAR))
	{
		return 2;
	}
	if(COMPARE_BIT_FLAG(i_unitMask, UNITKIND_AGEAR))
	{
		return 3;
	}
	if(COMPARE_BIT_FLAG(i_unitMask, UNITKIND_IGEAR))
	{
		return 4;
	}

	return -1;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			int GetUnitMaskByArrIdxforWRK(INT i_arrIdx)
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-18 ~ 2009-02-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
int GetUnitMaskByArrIdxforWRK(INT i_arrIdx)
{
	switch(i_arrIdx)
	{
	case 0:			return UNITKIND_ALL_MASK;
	case 1:			return UNITKIND_BGEAR;
	case 2:			return UNITKIND_MGEAR;
	case 3:			return UNITKIND_AGEAR;
	case 4:			return UNITKIND_IGEAR;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			int GetArrayIndexByInfluenceType(BYTE i_byInflTy)
/// \brief		// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  - GetArrayIndexByInfluenceType() Լ ߰
/// \author		cmkwon
/// \date		2007-11-01 ~ 2007-11-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
int GetArrayIndexByInfluenceType(BYTE i_byInflTy)
{
	switch(i_byInflTy)
	{
	case INFLUENCE_TYPE_NORMAL:				return 0;
	case INFLUENCE_TYPE_VCN:				return 1;
	case INFLUENCE_TYPE_ANI:				return 2;
	case INFLUENCE_TYPE_ALL_MASK:			return 3;
	}

	return -1;	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BYTE GetInfluenceTypeByArrayIndex(int i_nArrIdx)
/// \brief		// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  - GetInfluenceTypeByArrayIndex() Լ ߰
/// \author		cmkwon
/// \date		2007-11-01 ~ 2007-11-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BYTE GetInfluenceTypeByArrayIndex(int i_nArrIdx)
{
	switch(i_nArrIdx)
	{
	case 0:			return INFLUENCE_TYPE_NORMAL;
	case 1:			return INFLUENCE_TYPE_VCN;
	case 2:			return INFLUENCE_TYPE_ANI;
	case 3:			return INFLUENCE_TYPE_ALL_MASK;
	}

	return INFLUENCE_TYPE_UNKNOWN;	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2008-06-03 by cmkwon, AdminTool, DBTool   ˻ ޺ڽ ˻  ߰(K0000143) - 
/// \author		cmkwon
/// \date		2008-06-03 ~ 2008-06-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *StringCullingForValidChar(char *i_szSource, int i_nCullingSize)
{
	char *pCur	= i_szSource;
	char *pPrev = i_szSource;
	while('\0' != *pCur)
	{
		pCur = CharNext(pCur);
		int nGap = pCur - i_szSource;
		if(nGap == i_nCullingSize)
		{
			return pCur;
		}
		else if(nGap > i_nCullingSize)
		{
			return pPrev;
		}
		pPrev = pCur;
	}

	return pCur;
}


// operator overloading
MEX_ITEM_INFO& MEX_ITEM_INFO::operator=(const ITEM& rhs)
{
	this->ItemNum			= rhs.ItemNum;		
	this->Kind				= rhs.Kind;			
	this->AbilityMin		= rhs.AbilityMin;		
	this->AbilityMax		= rhs.AbilityMax;		
	this->ReqUnitKind		= rhs.ReqUnitKind;	
	this->ReqMinLevel		= rhs.ReqMinLevel;
	this->ReqMaxLevel		= rhs.ReqMaxLevel;
	this->HitRate			= rhs.HitRate;		
	this->Defense			= rhs.Defense;		
	this->SpeedPenalty		= rhs.SpeedPenalty;	
	this->Range				= rhs.Range;			
	this->Price				= rhs.Price;
	this->CashPrice			= rhs.CashPrice;
// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - Ʒ  
// 	this->DestParameter1	= rhs.DestParameter1;	
// 	this->ParameterValue1	= rhs.ParameterValue1;
// 	this->DestParameter2	= rhs.DestParameter2;	
// 	this->ParameterValue2	= rhs.ParameterValue2;
// 	this->DestParameter3	= rhs.DestParameter3;	
// 	this->ParameterValue3	= rhs.ParameterValue3;
// 	this->DestParameter4	= rhs.DestParameter4;	
// 	this->ParameterValue4	= rhs.ParameterValue4;
	memcpy(this->ArrDestParameter, rhs.ArrDestParameter, sizeof(this->ArrDestParameter[0])*SIZE_MAX_DESPARAM_COUNT_IN_ITEM);
	memcpy(this->ArrParameterValue, rhs.ArrParameterValue, sizeof(this->ArrParameterValue[0])*SIZE_MAX_DESPARAM_COUNT_IN_ITEM);

	this->ReAttacktime		= rhs.ReAttacktime;	
	this->Time				= rhs.Time;			
	this->RepeatTime		= rhs.RepeatTime;			// 2006-12-08 by cmkwon, ߰
	this->RangeAngle		= rhs.RangeAngle;		
	this->MultiTarget		= rhs.MultiTarget;	
	this->ExplosionRange	= rhs.ExplosionRange;	
	this->ReactionRange		= rhs.ReactionRange;	
	this->ShotNum			= rhs.ShotNum;		
	this->MultiNum			= rhs.MultiNum;		
	this->AttackTime		= rhs.AttackTime;		
	this->ReqSP				= rhs.ReqSP;			
	this->OrbitType			= rhs.OrbitType;		
	this->ItemAttribute		= rhs.ItemAttribute;	
	this->BoosterAngle		= rhs.BoosterAngle;	

	return *this;
}

ITEM& ITEM::operator=(const MEX_ITEM_INFO& rhs)
{
	this->ItemNum			= rhs.ItemNum;		
	this->Kind				= rhs.Kind;			
	this->AbilityMin		= rhs.AbilityMin;		
	this->AbilityMax		= rhs.AbilityMax;		
	this->ReqUnitKind		= rhs.ReqUnitKind;	
	this->ReqMinLevel		= rhs.ReqMinLevel;
	this->ReqMaxLevel		= rhs.ReqMaxLevel;
	this->HitRate			= rhs.HitRate;		
	this->Defense			= rhs.Defense;		
	this->SpeedPenalty		= rhs.SpeedPenalty;	
	this->Range				= rhs.Range;			
	this->Price				= rhs.Price;
	this->CashPrice			= rhs.CashPrice;
// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - Ʒ  
// 	this->DestParameter1	= rhs.DestParameter1;	
// 	this->ParameterValue1	= rhs.ParameterValue1;
// 	this->DestParameter2	= rhs.DestParameter2;	
// 	this->ParameterValue2	= rhs.ParameterValue2;
// 	this->DestParameter3	= rhs.DestParameter3;	
// 	this->ParameterValue3	= rhs.ParameterValue3;
// 	this->DestParameter4	= rhs.DestParameter4;	
// 	this->ParameterValue4	= rhs.ParameterValue4;
	memcpy(this->ArrDestParameter, rhs.ArrDestParameter, sizeof(this->ArrDestParameter[0])*SIZE_MAX_DESPARAM_COUNT_IN_ITEM);
	memcpy(this->ArrParameterValue, rhs.ArrParameterValue, sizeof(this->ArrParameterValue[0])*SIZE_MAX_DESPARAM_COUNT_IN_ITEM);

	this->ReAttacktime		= rhs.ReAttacktime;	
	this->Time				= rhs.Time;			
	this->RepeatTime		= rhs.RepeatTime;			// 2006-12-08 by cmkwon, ߰
	this->RangeAngle		= rhs.RangeAngle;		
	this->MultiTarget		= rhs.MultiTarget;	
	this->ExplosionRange	= rhs.ExplosionRange;	
	this->ReactionRange		= rhs.ReactionRange;	
	this->ShotNum			= rhs.ShotNum;		
	this->MultiNum			= rhs.MultiNum;		
	this->AttackTime		= rhs.AttackTime;		
	this->ReqSP				= rhs.ReqSP;			
	this->OrbitType			= rhs.OrbitType;		
	this->ItemAttribute		= rhs.ItemAttribute;	
	this->BoosterAngle		= rhs.BoosterAngle;	

	return *this;
}

BOOL GCheckLimitLevel(EN_CHECK_TYPE i_checkType, int i_nLevel)
{
	switch(i_checkType)
	{
	case CHECK_TYPE_BATTLE_P2P_PK:
		{
			if(i_nLevel >= 10)
			{
				return TRUE;
			}
		}
		break;
	case CHECK_TYPE_BATTLE_PARTY_WAR:
		{
			if(i_nLevel >= 10)
			{
				return TRUE;
			}
		}
		break;
	case CHECK_TYPE_CHARACTER_MENT:
		{
			if(i_nLevel >= 30)
			{
				return TRUE;
			}
		}
		break;
//	case CHECK_TYPE_GUILD_CREATE:
//	case CHECK_TYPE_CHAT_SELL_ALL:		// 2008-05-19 by dhjin, EP3 - ä ý ,  ä
	case CHECK_TYPE_GUILD_CREATE:
		{
			if(i_nLevel >= GuildCommanderMinLevel)		// 2008-10-13 by dhjin,     üũ ߰.
			{
				return TRUE;
			}
		}
		break;
	case CHECK_TYPE_PENALTY_ON_DEAD:
		{
			if(i_nLevel > 15)
			{
				return TRUE;
			}
		}
		break;
	case CHECK_TYPE_LOWLEVEL_ADVANTAGE:			// 2006-03-15 by cmkwon
		{
			if(i_nLevel <= 5)
			{
				return TRUE;
			}
		}
		break;
	case CHECK_TYPE_CHAT_WAR:			// 2008-05-19 by dhjin, EP3 - ä ý ,  ä
		{
			if(i_nLevel >= 20)
			{
				return TRUE;
			}
		}
		break;
	}
	return FALSE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL GCheckRaceAndInfluenceType(EN_CHECK_TYPE i_checkType, USHORT i_usRace, BYTE i_byInfluenceTy, USHORT i_usPeerRace, BYTE i_byPeerInfluenceTy)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-06 ~ 2005-12-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL GCheckRaceAndInfluenceType(EN_CHECK_TYPE i_checkType
								, USHORT i_usRace, BYTE i_byInfluenceTy
								, USHORT i_usPeerRace, BYTE i_byPeerInfluenceTy)
{
	switch(i_checkType)
	{
	case CHECK_TYPE_TRADE:		//    ó ʿ, 2005-12-06 by cmkwon
		{
			if ( COMPARE_RACE(i_usRace, RACE_DEMO|RACE_GUEST|RACE_MONITOR|RACE_GAMEMASTER)
				|| COMPARE_RACE(i_usPeerRace, RACE_DEMO|RACE_GUEST|RACE_MONITOR|RACE_GAMEMASTER) )
			{
				return FALSE;
			}

			if(COMPARE_RACE(i_usRace, RACE_OPERATION))
			{// 2005-12-06 by cmkwon, ڵ   ŷ ,   ϶
				if(FALSE == COMPARE_RACE(i_usPeerRace, RACE_OPERATION))
				{
					return FALSE;
				}
			}
			else if(COMPARE_RACE(i_usPeerRace, RACE_OPERATION))
			{// 2005-12-06 by cmkwon, ڵ   ŷ ,   ϶
				if(FALSE == COMPARE_RACE(i_usRace, RACE_OPERATION))
				{
					return FALSE;
				}
			}
			else
			{
// 2006-05-18 by cmkwon, Ʒ    ƴϸ ŷ Ұ
// 				if(COMPARE_INFLUENCE(i_byInfluenceTy, INFLUENCE_TYPE_ANI))
// 				{// ݶ
// 					if(i_byInfluenceTy != i_byPeerInfluenceTy)
// 					{// ٸ ϰ ŷ Ұ
// 						return FALSE;
// 					}
// 				}
// 				else
// 				{// Ϲݼ, Լ
// 					if(FALSE == COMPARE_INFLUENCE(i_byPeerInfluenceTy, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN))
// 					{// ٸ ϰ ŷ Ұ
// 						return FALSE;
// 					}
// 				}

				if(COMPARE_INFLUENCE(i_byInfluenceTy, INFLUENCE_TYPE_NORMAL))
				{// Ϲݼ ŷ Ұ
					return FALSE;
				}

				if(COMPARE_INFLUENCE(i_byPeerInfluenceTy, INFLUENCE_TYPE_NORMAL))
				{// Ϲݼ ŷ Ұ
					return FALSE;
				}
				
				if(i_byInfluenceTy != i_byPeerInfluenceTy)
				{// 2006-05-18 by cmkwon, ٸ 
					return FALSE;
				}
			}
		}
		break;
	case CHECK_TYPE_BAZAAR:		// 2006-08-07 by cmkwon
		{
			if ( COMPARE_RACE(i_usRace, RACE_DEMO|RACE_GUEST|RACE_MONITOR)
				|| COMPARE_RACE(i_usPeerRace, RACE_DEMO|RACE_GUEST|RACE_MONITOR) )
			{
				return FALSE;
			}

			if(COMPARE_RACE(i_usRace, RACE_OPERATION|RACE_GAMEMASTER)
				^ COMPARE_RACE(i_usPeerRace, RACE_OPERATION|RACE_GAMEMASTER))
			{// 2006-08-07 by cmkwon, ڽŰ  ߿ Ѹ  Ȥ  ϶
				return FALSE;
			}			
		}
		break;

	case CHECK_TYPE_GUILD_JOIN:		//  ó ʿ , 2005-12-07 by cmkwon
		{
			if(COMPARE_INFLUENCE(i_byPeerInfluenceTy, INFLUENCE_TYPE_NORMAL))
			{// Ϲݼ   Ұ
				return FALSE;
			}
			if(i_byInfluenceTy != i_byPeerInfluenceTy)
			{//  ٸ   Ұ
				return FALSE;
			}
		}
		break;

	case CHECK_TYPE_PARTY_JOIN:
	case CHECK_TYPE_CHAT_SELL_ALL:		// 2005-12-07 by cmkwon
	case CHECK_TYPE_CHAT_CASH_ALL:		// 2005-12-07 by cmkwon
	case CHECK_TYPE_BATTLE_PARTY_WAR:		// 2006-01-05 by cmkwon
	case CHECK_TYPE_BATTLE_GUILD_WAR:		// 2006-01-05 by cmkwon
	case CHECK_TYPE_CHAT_WAR:			// 2008-05-19 by dhjin, EP3 - ä ý ,  ä
		{//  ¸ ϴ
			if(i_byInfluenceTy != i_byPeerInfluenceTy)
			{
				//////////////////////////////////////////////////////////////////////////
				// 2006-10-12 by dhjin, ٸ  Ұ
				//if(FALSE == COMPARE_INFLUENCE(i_byInfluenceTy, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN)
				//	|| FALSE == COMPARE_INFLUENCE(i_byPeerInfluenceTy, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN))
				//{
				return FALSE;
				//}
			}
		}
		break;
	case CHECK_TYPE_CHAT_PTOP:		// 2005-12-07 by cmkwon
	case CHECK_TYPE_VOIP_1to1:		// 2005-12-07 by cmkwon
		{
			///////////////////////////////////////////////////////////////////////////////
			// 1. Ѹ̶ , Ӹʹ  
			// 2.  ٸ Ұ
			if(COMPARE_RACE(i_usRace, RACE_OPERATION|RACE_GAMEMASTER)
				|| COMPARE_RACE(i_usPeerRace, RACE_OPERATION|RACE_GAMEMASTER))
			{
				return TRUE;
			}
			if(i_byInfluenceTy != i_byPeerInfluenceTy)
			{
				if(COMPARE_INFLUENCE(i_byInfluenceTy, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN)
					&& COMPARE_INFLUENCE(i_byPeerInfluenceTy, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN))
				{
					return TRUE;
				}
				return FALSE;
			}
		}
		break;
	default:
		{
			return FALSE;
		}
	}
	
	return TRUE;
}

const char * GET_ARENA_STATE_STRING(BYTE i_byAState)
{
	switch(i_byAState)
	{
	case ARENA_STATE_NONE:					return "ARENA_STATE_NONE";
	case ARENA_STATE_JOINING:				return "ARENA_STATE_JOINING";
	case ARENA_STATE_READY:					return "ARENA_STATE_READY";
	case ARENA_STATE_READY_FINISH:			return "ARENA_STATE_READY_FINISH";
	case ARENA_STATE_FIGHTING_WARREADY:		return "ARENA_STATE_FIGHTING_WARREADY";
	case ARENA_STATE_FIGHTING_WARING:		return "ARENA_STATE_FIGHTING_WARING";
	case ARENA_STATE_FIGHTING_WARFINISH:	return "ARENA_STATE_FIGHTING_WARFINISH";
	}

	return "ARENA_STATE_UNKNOWN";
}

char *GetLeader8SubLeaderString(BYTE i_byInflTy, USHORT i_usRace)
{
	switch(i_byInflTy)
	{
	case INFLUENCE_TYPE_VCN:
		{
			if(COMPARE_RACE(i_usRace, RACE_INFLUENCE_LEADER))
			{
				return STRCMD_VCN_INFLUENCE_LEADER;
			}
			if(COMPARE_RACE(i_usRace, RACE_INFLUENCE_SUBLEADER_1))
			{
				return STRCMD_VCN_INFLUENCE_SUBLEADER_1;
			}
			if(COMPARE_RACE(i_usRace, RACE_INFLUENCE_SUBLEADER_2))
			{
				return STRCMD_VCN_INFLUENCE_SUBLEADER_2;
			}
		}
		break;
	case INFLUENCE_TYPE_ANI:
		{
			if(COMPARE_RACE(i_usRace, RACE_INFLUENCE_LEADER))
			{
				return STRCMD_ANI_INFLUENCE_LEADER;
			}
			if(COMPARE_RACE(i_usRace, RACE_INFLUENCE_SUBLEADER_1))
			{
				return STRCMD_ANI_INFLUENCE_SUBLEADER_1;
			}
			if(COMPARE_RACE(i_usRace, RACE_INFLUENCE_SUBLEADER_2))
			{
				return STRCMD_ANI_INFLUENCE_SUBLEADER_2;
			}
		}
		break;
	}

	return "";
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			INT CalcGradeByRate(float i_nMaxValue, float i_nValue, INT i_nRate)
/// \brief		  ǥ ȹ -    Ѵ.
/// \author		dhjin
/// \date		2008-03-24 ~ 2008-03-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
INT CalcGradeByRate(float i_nMaxValue, float i_nValue, INT i_nRate)
{
	//////////////////////////////////////////////////////////////////////////
	//	i_nValue			 i_nRate
	//	-----------	 * 100 * -------  = i_nValue / i_nMaxValue * i_nRate
	//	i_nMaxValue			   100	
	//////////////////////////////////////////////////////////////////////////
	
	float CalcGrade = i_nValue / i_nMaxValue * i_nRate;
	INT	o_Grade = ceil(CalcGrade);

	return o_Grade;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-10-22 by cmkwon, ð   ý  - 
/// \author		cmkwon
/// \date		2009-10-22 ~ 2009-10-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
inline int GetNumberOfBits(INT64 i_n64Mask)
{
	int nBits = 0;
    while( i_n64Mask )
    {
        i_n64Mask = i_n64Mask & ( i_n64Mask - 1 ); 
        nBits++;
    }
    return nBits;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
/// \author		cmkwon
/// \date		2009-11-02 ~ 2009-11-02
/// \warning	
///
/// \param		BYTE i_enStorage		==> ITEM_IN_XXX
/// \return		
///////////////////////////////////////////////////////////////////////////////
BYTE CHARACTER::GetAddedPermanentInventoryCount(BYTE i_enStorage/*=ITEM_IN_CHARACTER*/)
{
	BYTE by4Ret = 0;
	switch(i_enStorage)
	{
	case ITEM_IN_CHARACTER:				by4Ret = RacingPoint & 0xFF;			return min(by4Ret, SIZE_MAX_ADDABLE_INVENTORY_COUNT);
	case ITEM_IN_STORE:					by4Ret = (RacingPoint & 0xFF00)>>8;		return min(by4Ret, SIZE_MAX_ADDABLE_STORE_COUNT);
	}
	return 0;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
/// \author		cmkwon
/// \date		2009-11-03 ~ 2009-11-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CHARACTER::SetAddedPermanentInventoryCount(BYTE i_byAddCount, BYTE i_enStorage/*=ITEM_IN_CHARACTER*/)
{	
	switch(i_enStorage)
	{
	case ITEM_IN_CHARACTER:
		{
			RacingPoint &= ~(0xFF);
			RacingPoint |= i_byAddCount;
		}
		break;
	case ITEM_IN_STORE:
		{
			RacingPoint &= ~(0xFF00);
			RacingPoint |= ((int)i_byAddCount)<<8;
		}
		break;
	default:
		{
			return FALSE;
		}
	}
	return TRUE;
}

struct find_if_INT		// 2010-01-18 by cmkwon,   Parameter ߺ üũ ý  - 
{
	find_if_INT(INT i_findValue): m_findValue(i_findValue){};
	bool operator()(const INT i_nValue)
	{
		return m_findValue == i_nValue;
	}
	INT m_findValue;
};

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-01-18 by cmkwon,   Parameter ߺ üũ ý  - 
/// \author		cmkwon
/// \date		2010-01-18 ~ 2010-01-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL ITEM::CheckParamOverlap(ITEM *i_pUsingItemInfo)
{
	if(NULL == this->pParamOverlapIdxList || NULL == i_pUsingItemInfo->pParamOverlapIdxList)
	{
		return TRUE;
	}
	
	vectINT *pMainVec	= this->pParamOverlapIdxList;
	vectINT *pSubVec	= i_pUsingItemInfo->pParamOverlapIdxList;
	if(this->pParamOverlapIdxList->size() > i_pUsingItemInfo->pParamOverlapIdxList->size())
	{
		pMainVec	= i_pUsingItemInfo->pParamOverlapIdxList;
		pSubVec		= this->pParamOverlapIdxList;
	}
	
	vectINT::iterator MItr(pMainVec->begin());
	for(; MItr != pMainVec->end(); MItr++)
	{
		INT OverlapIdx = *MItr;
		
		vectINT::iterator SItr = find_if(pSubVec->begin(), pSubVec->end(), find_if_INT(OverlapIdx));
		if(SItr != pSubVec->end())
		{
			return FALSE;
		}
	}
	
	return TRUE;
}


#ifdef _ATUM_SERVER
#include "VMemPool.h"

void * EVENTINFO::operator new(size_t size)
{
	return CVMemPool::vmObjectNew(size);
}

void EVENTINFO::operator delete(void* p)
{
	CVMemPool::vmObjectDelete(p, sizeof(EVENTINFO));
}

#ifndef _ATUM_ADMINTOOL		// 2005-11-26 by cmkwon
void * ITEM_GENERAL::operator new(size_t size)
{
	return CVMemPool::vmObjectNew(size);
}

void ITEM_GENERAL::operator delete(void* p)
{
	CVMemPool::vmObjectDelete(p, sizeof(ITEM_GENERAL));
}
#endif // end_#ifndef _ATUM_ADMINTOOL

void * ITEM_SKILL::operator new(size_t size)
{
	return CVMemPool::vmObjectNew(size);
}

void ITEM_SKILL::operator delete(void* p)
{
	CVMemPool::vmObjectDelete(p, sizeof(ITEM_SKILL));
}


// 2010-06-15 by shcho&hslee ý - ޸ Ǯ .
void * tPET_CURRENTINFO :: operator new(size_t size)
{
	return CVMemPool::vmObjectNew(size);
}

void tPET_CURRENTINFO :: operator delete(void* p)
{
	CVMemPool::vmObjectDelete(p, sizeof(tPET_CURRENTINFO));
}

// 2010-11 by dhjin, ƶ󸮿 äθ α.
char* GetConnectPublisherName(eCONNECT_PUBLISHER i_eCONNECT_PUBLISHER)
{
	switch(i_eCONNECT_PUBLISHER)
	{
	case CONNECT_PUBLISHER_NHN_JPN:
		{
			return "NHN";
		}
		break;
	default:
		{
			return "DEFAULT";
		}
	}
}
// 2011-11-18 by shcho, ٿ ٿ  ó - ߰ ɹ 
BOOL CheckAdminCommand(char *token)
{

#ifdef S_GM_COMMAND_USE_SHCHO
	return FALSE;
#endif

	if(
	//  ִ ɾ  Ұ óѴ.
	0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyKIND)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyKIND_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyKIND_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUMRANGE)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUMRANGE_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUMRANGE_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_STATINIT)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_STATINIT_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_STATINIT_2)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_STATINIT_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMETIME)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMETIME_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMETIME_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_STRINGLEVEL_0)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_STRINGLEVEL_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_STRINGLEVEL_2)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_STRINGLEVEL_HELP)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTALL)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTALL_1)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTALL_HELP)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTWEAPON)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTWEAPON_1)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTWEAPON_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERSINFOTOTAL)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERSINFOTOTAL_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERSINFOTOTAL_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTDBG)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTDBG_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTDBG_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGSETPARAMF)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGSETPARAMF_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_VARIABLESET)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_VARIABLESET_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_VARIABLESET_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTMSGF_0)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTMSGF_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTMSGF_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1EXP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1SPI)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1EXPR)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1ITEM)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1RARE)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P2END)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_HELP)
//	|| 0 == stricmp(token, STRCMD_CS_COMMAND_CITYWAR)
//	|| 0 == stricmp(token, STRCMD_CS_COMMAND_CITYWAR_1)
//	|| 0 == stricmp(token, STRCMD_CS_COMMAND_CITYWAR_PSTART)
//	|| 0 == stricmp(token, STRCMD_CS_COMMAND_CITYWAR_PEND)
//	|| 0 == stricmp(token, STRCMD_CS_COMMAND_CITYWAR_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT_PSTART)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT_PEND)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGSETPARAMI)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGSETPARAMI_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_REGISTERADMIN)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_REGISTERADMIN_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_REGISTERADMIN_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTMSGI_0)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTMSGI_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTMSGI_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_SERVERDOWN)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_SERVERDOWN_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_SERVERDOWN_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDSET)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDSET_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDSET_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDROLLBACK)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDROLLBACK_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDROLLBACK_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDLIST)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDLIST_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDLIST_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDENCRYPT)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDENCRYPT_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_PASSWORDENCRYPT_HELP)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ACCOUNTBLOCKLIST)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ACCOUNTBLOCKLIST_1)
	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ACCOUNTBLOCKLIST_HELP)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINMAP_0)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINMAP_1)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINMAP_2)
// 	|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINMAP_HELP)
	)
		{
			return TRUE;
		}
	return FALSE;
}


//void * ENCHANT::operator new(size_t size)
//{
//	return CVMemPool::vmObjectNew(size);
//}
//
//void ENCHANT::operator delete(void* p)
//{
//	CVMemPool::vmObjectDelete(p, sizeof(ENCHANT));
//}
#endif // _ATUM_SERVER
