// TriggerNGCInflWarMonsterGroup.cpp: implementation of the CTriggerNGCInflWarMonsterGroup class.
//
/// \brief		// 2011-11-07 by hskim, EP4 [Ʈ ý] - NCG  ý
/// \author		hskim
/// \date		2011-11-07
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TriggerNGCInflWarMonsterGroup.h"
#include "MapTriggerManager.h"
#include "TriggerFunctionNGCInflWar.h"
#include "FieldMapChannel.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTriggerNGCInflWarMonsterGroup::CTriggerNGCInflWarMonsterGroup()
{
	Clear();
}

CTriggerNGCInflWarMonsterGroup::~CTriggerNGCInflWarMonsterGroup()
{
	Destroy();
}

void CTriggerNGCInflWarMonsterGroup::Clear()
{
	m_Monster = 0;
	m_iSummonCount = 0;
	m_iSummonRandomPos = 0;

	m_pMapTriggerManager = NULL;
	m_pTriggerFunctionNGCInflWar = NULL;
}

BOOL CTriggerNGCInflWarMonsterGroup::Create(CMapTriggerManager *pMapTriggerManager, CTriggerFunctionNGCInflWar *pTriggerFunctionCrystal, MonIdx_t Monster, INT iSummonCount, INT iSummonRandomPos)
{
	m_Monster = Monster;
	m_iSummonCount = iSummonCount;
	m_iSummonRandomPos = iSummonRandomPos;

	m_pMapTriggerManager = pMapTriggerManager;
	m_pTriggerFunctionNGCInflWar = pTriggerFunctionCrystal;

	return TRUE;
}

void CTriggerNGCInflWarMonsterGroup::Destroy()
{
	Clear();
}

BOOL CTriggerNGCInflWarMonsterGroup::CreateMonster()
{
	// NPC Server  (NPC   Ǿ ִ Ȯϰ ȣ)

	if( NULL != m_pTriggerFunctionNGCInflWar && NULL != m_pTriggerFunctionNGCInflWar->m_pFieldMapChannel )
	{
		INIT_MSG_WITH_BUFFER(MSG_FN_NPCSERVER_CINEMA_MONSTER_CREATE, T_FN_NPCSERVER_CINEMA_MONSTER_CREATE, pSummon, SendBuf2);
		pSummon->mapChann			= m_pTriggerFunctionNGCInflWar->m_pFieldMapChannel->GetMapChannelIndex();
		pSummon->MonsterUnitKind	= m_Monster;
		pSummon->MonsterSummonCount = m_iSummonCount;
		pSummon->MaxRandomDistance	= m_iSummonRandomPos;
		pSummon->MonsterBalanceInfo.Init(0);
		((CFieldIOCP*)(m_pTriggerFunctionNGCInflWar->m_pFieldMapChannel->m_pFieldMapWorkspace->m_pIOCPServer))->Send2NPCServerByTCP(SendBuf2, MSG_SIZE(MSG_FN_NPCSERVER_CINEMA_MONSTER_CREATE));
	}

	return TRUE;
}

BOOL CTriggerNGCInflWarMonsterGroup::DestroyMonster()
{
	if( NULL != m_pTriggerFunctionNGCInflWar && NULL != m_pTriggerFunctionNGCInflWar->m_pFieldMapChannel )
	{
		INIT_MSG_WITH_BUFFER(MSG_FN_NPCSERVER_CINEMA_MONSTER_DESTROY, T_FN_NPCSERVER_CINEMA_MONSTER_DESTROY, pDestroy, SendBufDestroy);
		pDestroy->mapChann			= m_pTriggerFunctionNGCInflWar->m_pFieldMapChannel->GetMapChannelIndex();
		pDestroy->MonsterUnitKind	= m_Monster;
		((CFieldIOCP*)(m_pTriggerFunctionNGCInflWar->m_pFieldMapChannel->m_pFieldMapWorkspace->m_pIOCPServer))->Send2NPCServerByTCP(SendBufDestroy, MSG_SIZE(MSG_FN_NPCSERVER_CINEMA_MONSTER_DESTROY));
	}

	return TRUE;
}
