// INFSecuSetPassWnd.cpp: implementation of the CINFSecuSetPassWnd class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "AtumApplication.h"
#include "ShuttleChild.h"
#include "INFImage.h"
#include "GameDataLast.h"
#include "INFGameMain.h"
#include "D3DHanFont.h"
#include "AtumSound.h"
#include "QuestData.h"
#include "StoreData.h"
#include "ItemInfo.h"
#include "Interface.h"
#include "INFSecuMain.h"

#include "INFSecuSetPassWnd.h"

#include "INFImageEx.h"
#include "INFGroupImage.h"
#include "INFGroupManager.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
#ifdef C_EPSODE4_UI_CHANGE_JSKIM					        // 2011. 10. 10 by jskim UIý 
#define	SECU_WND_TITLEBAR_HEIGHT		20

// OK ư 
#define		SECURITY_WND_OK_X			143
#define		SECURITY_WND_OK_Y			160

// Cancel ư 
#define		SECURITY_WND_CANCEL_X		185
#define		SECURITY_WND_CANCEL_Y		160

// Edit Ʈ (Pass)
#define		SECURITY_WND_PASS_EDIT_X		23
#define		SECURITY_WND_PASS_EDIT_Y		52
#define		SECURITY_WND_PASS_EDIT_W		195
#define		SECURITY_WND_PASS_EDIT_H		23

// Edit Ʈ (Ȯ)
#define		SECURITY_WND_CONFIRM_EDIT_X		23
#define		SECURITY_WND_CONFIRM_EDIT_Y		97
#define		SECURITY_WND_CONFIRM_EDIT_W		190
#define		SECURITY_WND_CONFIRM_EDIT_H		23
#else
#define	SECU_WND_TITLEBAR_HEIGHT		20

// OK ư 
#define		SECURITY_WND_OK_X			140
#define		SECURITY_WND_OK_Y			155

// Cancel ư 
#define		SECURITY_WND_CANCEL_X		180
#define		SECURITY_WND_CANCEL_Y		155

// Edit Ʈ (Pass)
#define		SECURITY_WND_PASS_EDIT_X		19
#define		SECURITY_WND_PASS_EDIT_Y		60
#define		SECURITY_WND_PASS_EDIT_W		200
#define		SECURITY_WND_PASS_EDIT_H		20

// Edit Ʈ (Ȯ)
#define		SECURITY_WND_CONFIRM_EDIT_X		19
#define		SECURITY_WND_CONFIRM_EDIT_Y		118
#define		SECURITY_WND_CONFIRM_EDIT_W		200
#define		SECURITY_WND_CONFIRM_EDIT_H		20
#endif

// ִ ۾  
#define		MAX_STRING_LEN					8

//  Ʈ Ҳ?
#define		SECURITY_WND_PASS_EDIT				0
#define		SECURITY_WND_CONFIRM_EDIT			1

CINFSecuSetPassWnd::CINFSecuSetPassWnd(CINFSecuMain* pMain)
{
	m_pINFSecuMain = pMain;

	m_pSetPassBk = NULL;	

	m_nBackPosX = m_nBackPosY= 0;
	m_nCx = m_nCy = 1;

	m_bMouseLock = FALSE;
	m_ptMouseLockCap.x = m_ptMouseLockCap.y= 0;

	m_pSetOk = NULL;
	m_pSetCancel = NULL;
	m_pINFSecuEditBox = NULL;
	m_pINFSecuComfirmEditBox= NULL;

	m_nSelEdit = SECURITY_WND_PASS_EDIT;

}

CINFSecuSetPassWnd::~CINFSecuSetPassWnd()
{
	DeleteDeviceObjects();
}


HRESULT CINFSecuSetPassWnd::InitDeviceObjects()
{
	DeleteDeviceObjects();

	DataHeader	* pDataHeader = NULL;
	char buf[30] ;
	int nCnt = 0;
	memset(buf, 0x00, 30);

#ifdef C_EPSODE4_UI_CHANGE_JSKIM					        // 2011. 10. 10 by jskim UIý 
	{
		DataHeader	* pDataHeader;
		pDataHeader = g_pGameMain->m_GruopImagemanager->FindResource("setupPW");
		m_pSetPassBk = g_pGameMain->m_GruopImagemanager->GetGroupImage( pDataHeader );
		m_pSetPassBk->InitDeviceObjects( g_pD3dApp->m_pImageList );
	}
	{	
		char szUpBtn[30], szDownBtn[30], szSelBtn[30], szDisBtn[30];		
		wsprintf(szUpBtn, "oks00");
		wsprintf(szDownBtn, "oks01");
		wsprintf(szSelBtn, "oks03");
		wsprintf(szDisBtn, "oks02");
		if(NULL == m_pSetOk)
		{
			m_pSetOk = new CINFImageBtn;
		}
		m_pSetOk->InitDeviceObjects(szUpBtn, szDownBtn, szSelBtn, szDisBtn);		
	}
	{
		char szUpBtn[30], szDownBtn[30], szSelBtn[30], szDisBtn[30];		
		wsprintf(szUpBtn, "cans00");
		wsprintf(szDownBtn, "cans01");
		wsprintf(szSelBtn, "cans03");
		wsprintf(szDisBtn, "cans02");
		if(NULL == m_pSetCancel)
		{
			m_pSetCancel = new CINFImageBtn;
		}
		m_pSetCancel->InitDeviceObjects(szUpBtn, szDownBtn, szSelBtn, szDisBtn);		
	}
#else
	{
		if(NULL == m_pSetPassBk)
		{
			m_pSetPassBk = new CINFImageEx;
		}
		wsprintf(buf,"se_pinbk");
		pDataHeader = g_pGameMain->FindResource(buf);
		m_pSetPassBk->InitDeviceObjects(pDataHeader);		
	}
	{	
		char szUpBtn[30], szDownBtn[30], szSelBtn[30], szDisBtn[30];		
		wsprintf(szUpBtn, "shlaok00");
		wsprintf(szDownBtn, "shlaok01");
		wsprintf(szSelBtn, "shlaok03");
		wsprintf(szDisBtn, "shlaok02");
		if(NULL == m_pSetOk)
		{
			m_pSetOk = new CINFImageBtn;
		}
		m_pSetOk->InitDeviceObjects(szUpBtn, szDownBtn, szSelBtn, szDisBtn);		
	}
	{
		char szUpBtn[30], szDownBtn[30], szSelBtn[30], szDisBtn[30];		
		wsprintf(szUpBtn, "shmcan00");
		wsprintf(szDownBtn, "shmcan01");
		wsprintf(szSelBtn, "shmcan03");
		wsprintf(szDisBtn, "shmcan02");
		if(NULL == m_pSetCancel)
		{
			m_pSetCancel = new CINFImageBtn;
		}
		m_pSetCancel->InitDeviceObjects(szUpBtn, szDownBtn, szSelBtn, szDisBtn);		
	}
#endif



	{
		if(NULL == m_pINFSecuEditBox)
		{
			m_pINFSecuEditBox = new CINFSecuEditBox;
		}
		
		POINT ptPos = {SECURITY_WND_PASS_EDIT_X, SECURITY_WND_PASS_EDIT_Y};
		m_pINFSecuEditBox->InitDeviceObjects(9, ptPos, SECURITY_WND_PASS_EDIT_W, TRUE, SECURITY_WND_PASS_EDIT_H);		
	}
	
	{
		if(NULL == m_pINFSecuComfirmEditBox)
		{
			m_pINFSecuComfirmEditBox = new CINFSecuEditBox;
		}
		
		POINT ptPos = {SECURITY_WND_CONFIRM_EDIT_X, SECURITY_WND_CONFIRM_EDIT_Y};
		m_pINFSecuComfirmEditBox->InitDeviceObjects(9, ptPos, SECURITY_WND_CONFIRM_EDIT_W, TRUE, SECURITY_WND_CONFIRM_EDIT_H);		
	}
	
	m_pINFSecuEditBox->EnableEdit(TRUE);
	m_nSelEdit = SECURITY_WND_PASS_EDIT;

	m_pINFSecuEditBox->SetMaxStringLen(MAX_STRING_LEN);
	m_pINFSecuComfirmEditBox->SetMaxStringLen(MAX_STRING_LEN);

	return S_OK ;
}

HRESULT CINFSecuSetPassWnd::RestoreDeviceObjects()
{
	{	
		m_pSetPassBk->RestoreDeviceObjects();		
		POINT ptBk = m_pSetPassBk->GetImgSize();
				
		if(g_pD3dApp->GetBackBufferDesc().Width > ptBk.x)
		{
			m_nBackPosX = (g_pD3dApp->GetBackBufferDesc().Width/2)-(ptBk.x/2);
		}
		if(g_pD3dApp->GetBackBufferDesc().Height > ptBk.y)
		{
			m_nBackPosY = (g_pD3dApp->GetBackBufferDesc().Height/2)-(ptBk.y/2);
		}
		m_nCx = ptBk.x;
		m_nCy = ptBk.y;
	}
	{
		m_pSetOk->RestoreDeviceObjects();
		m_pSetCancel->RestoreDeviceObjects();
		m_pINFSecuEditBox->RestoreDeviceObjects();		
		m_pINFSecuComfirmEditBox->RestoreDeviceObjects();		
	}
	// ư ġ Ʈ 
	UpdateBtnPos(m_nBackPosX, m_nBackPosY);	
	
	return S_OK ;
}

HRESULT CINFSecuSetPassWnd::DeleteDeviceObjects()
{
	if(m_pSetPassBk)
	{
		m_pSetPassBk->DeleteDeviceObjects();	
		SAFE_DELETE(m_pSetPassBk);
	}
	if(m_pSetOk)
	{
		m_pSetOk->DeleteDeviceObjects();	
		SAFE_DELETE(m_pSetOk);
	}
	if(m_pSetCancel)
	{
		m_pSetCancel->DeleteDeviceObjects();	
		SAFE_DELETE(m_pSetCancel);
	}
	if(m_pINFSecuEditBox)
	{
		m_pINFSecuEditBox->DeleteDeviceObjects();	
		SAFE_DELETE(m_pINFSecuEditBox);
	}
	
	if(m_pINFSecuComfirmEditBox)
	{
		m_pINFSecuComfirmEditBox->DeleteDeviceObjects();	
		SAFE_DELETE(m_pINFSecuComfirmEditBox);
	}
	
	return S_OK ;
}

HRESULT CINFSecuSetPassWnd::InvalidateDeviceObjects()
{
	m_pSetPassBk->InvalidateDeviceObjects();
	m_pSetOk->InvalidateDeviceObjects();		
	m_pSetCancel->InvalidateDeviceObjects();		
	m_pINFSecuEditBox->InvalidateDeviceObjects();		
	m_pINFSecuComfirmEditBox->InvalidateDeviceObjects();		
	return S_OK ;
}

void	CINFSecuSetPassWnd::Render()
{
	{
		m_pSetPassBk->Move(m_nBackPosX,m_nBackPosY);
		m_pSetPassBk->Render();
	}
	m_pSetOk->Render();
	m_pSetCancel->Render();
	{		
		m_pINFSecuEditBox->Render();
		m_pINFSecuComfirmEditBox->Render();
	}
}
void	CINFSecuSetPassWnd::Tick()
{
	m_pINFSecuEditBox->Tick();
	m_pINFSecuComfirmEditBox->Tick();
}

int CINFSecuSetPassWnd::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_LBUTTONDOWN:
		{
			return OnLButtonDown(wParam, lParam);
		}
		break;
	case WM_MOUSEMOVE:
		{
			return OnMouseMove(wParam, lParam);
		}
		break;
	case WM_LBUTTONUP:
		{
			return OnLButtonUp(wParam, lParam);
		}
		break;
	case WM_KEYDOWN:
		{
			switch(m_nSelEdit)
			{
			case SECURITY_WND_PASS_EDIT:
				{
					if(m_pINFSecuEditBox->WndProc(uMsg, wParam, lParam))
					{
						return INF_MSGPROC_BREAK;
					}
				}
				break;
			case SECURITY_WND_CONFIRM_EDIT:
				{
					if(m_pINFSecuComfirmEditBox->WndProc(uMsg, wParam, lParam))
					{
						return INF_MSGPROC_BREAK;
					}
				}
				break;
			}			
		}
		break;
	}
	return INF_MSGPROC_NORMAL;		
}

int CINFSecuSetPassWnd::OnLButtonDown(WPARAM wParam, LPARAM lParam)
{
	POINT pt;
	pt.x = LOWORD(lParam);
	pt.y = HIWORD(lParam);
	CheckMouseReverse(&pt);
	if((m_nBackPosX < pt.x && pt.x < (m_nBackPosX+m_nCx)  )
		&&(m_nBackPosY < pt.y && pt.y < (m_nBackPosY+m_nCy)  ))
	{
	}
	else
	{
		return INF_MSGPROC_NORMAL;
	}
	
	{
		if(TRUE == m_pINFSecuEditBox->OnLButtonDown(pt))
		{				
			RefreshEditCtl(SECURITY_WND_PASS_EDIT, m_pINFSecuEditBox);			
			
			// ư 콺 ִ.
			return  INF_MSGPROC_BREAK;
		}
	}
	
	{		
		if(TRUE == m_pINFSecuComfirmEditBox->OnLButtonDown(pt))
		{			
			RefreshEditCtl(SECURITY_WND_CONFIRM_EDIT, m_pINFSecuComfirmEditBox);						
			// ư 콺 ִ.
			return  INF_MSGPROC_BREAK;
		}
	}

	{
		if(TRUE == m_pSetOk->OnLButtonDown(pt))
		{
			// ư 콺 ִ.
			return  INF_MSGPROC_BREAK;
		}		
	}
	
	{
		if(TRUE == m_pSetCancel->OnLButtonDown(pt))
		{
			// ư 콺 ִ.
			return  INF_MSGPROC_BREAK;
		}		
	}
	
	if(pt.y < (m_nBackPosY+SECU_WND_TITLEBAR_HEIGHT) )
	{
		m_bMouseLock = TRUE;
		
		m_ptMouseLockCap.x = pt.x - m_nBackPosX;
		m_ptMouseLockCap.y = pt.y - m_nBackPosY;	
	}

	return INF_MSGPROC_BREAK;	
}
int CINFSecuSetPassWnd::OnMouseMove(WPARAM wParam, LPARAM lParam)
{
	POINT pt;
	pt.x = LOWORD(lParam);
	pt.y = HIWORD(lParam);

	m_pSetOk->OnMouseMove(pt);	
	m_pSetCancel->OnMouseMove(pt);	


	if(FALSE == m_bMouseLock )
	{
		return INF_MSGPROC_NORMAL;
	}

	m_nBackPosX = pt.x - m_ptMouseLockCap.x;
	m_nBackPosY = pt.y - m_ptMouseLockCap.y;

	// X ǥ 
	if(m_nBackPosX < 0)
	{
		m_nBackPosX = 0;
	}
	else if((m_nBackPosX+m_nCx) > g_pD3dApp->GetBackBufferDesc().Width)
	{
		m_nBackPosX = g_pD3dApp->GetBackBufferDesc().Width - m_nCx;
	}
	
	// Y ǥ 
	if(m_nBackPosY < 0)
	{
		m_nBackPosY = 0;
	}
	else if((m_nBackPosY+m_nCy) > g_pD3dApp->GetBackBufferDesc().Height)
	{
		m_nBackPosY = g_pD3dApp->GetBackBufferDesc().Height - m_nCy;
	}	

	// ư ġ Ʈ 
	UpdateBtnPos(m_nBackPosX, m_nBackPosY);	

	return INF_MSGPROC_BREAK;	
}
void CINFSecuSetPassWnd::UpdateBtnPos(int nBackPosX, int nBackPosY)
{
 	int nPosX, nPosY;
	{
		nPosX = nBackPosX + SECURITY_WND_OK_X;
		nPosY = nBackPosY + SECURITY_WND_OK_Y;		
		m_pSetOk->SetBtnPosition(nPosX, nPosY);
	}
	{
		nPosX = nBackPosX + SECURITY_WND_CANCEL_X;
		nPosY = nBackPosY + SECURITY_WND_CANCEL_Y;		
		m_pSetCancel->SetBtnPosition(nPosX, nPosY);
	}
	{
		nPosX = nBackPosX + SECURITY_WND_PASS_EDIT_X;
		nPosY = nBackPosY + SECURITY_WND_PASS_EDIT_Y;
		m_pINFSecuEditBox->SetPos(nPosX, nPosY);
	}
	{		
		nPosX = nBackPosX + SECURITY_WND_CONFIRM_EDIT_X;
		nPosY = nBackPosY + SECURITY_WND_CONFIRM_EDIT_Y;
		m_pINFSecuComfirmEditBox->SetPos(nPosX, nPosY);
	}
}

int CINFSecuSetPassWnd::OnLButtonUp(WPARAM wParam, LPARAM lParam)
{
	POINT pt;
	pt.x = LOWORD(lParam);
	pt.y = HIWORD(lParam);

	{
		if(TRUE == m_pSetOk->OnLButtonUp(pt))
		{				
			OnClickOk();

			// ư Ŭ 			
			g_pD3dApp->m_pSound->PlayD3DSound(SOUND_SELECT_BUTTON, D3DXVECTOR3(0,0,0), FALSE);			
			return  INF_MSGPROC_BREAK;
		}
	}
	
	{
		if(TRUE == m_pSetCancel->OnLButtonUp(pt))
		{			
			OnClickCancel();

			// ư Ŭ 			
			g_pD3dApp->m_pSound->PlayD3DSound(SOUND_SELECT_BUTTON, D3DXVECTOR3(0,0,0), FALSE);			
			return  INF_MSGPROC_BREAK;
		}
	}

	if(FALSE == m_bMouseLock )
	{
		return INF_MSGPROC_NORMAL;
	}
	m_bMouseLock = FALSE;
	return INF_MSGPROC_BREAK;	
}

// ݱ ư Ŭ
void CINFSecuSetPassWnd::OnCloseInfWnd()
{
	m_pINFSecuEditBox->InitString();		
	m_pINFSecuEditBox->EnableEdit(FALSE);

	m_pINFSecuComfirmEditBox->InitString();		
	m_pINFSecuComfirmEditBox->EnableEdit(FALSE);
}

// Show Pass  
void CINFSecuSetPassWnd::ShowSetPassWnd()
{	
	OnCloseInfWnd();
	m_nSelEdit = SECURITY_WND_PASS_EDIT;
	m_pINFSecuEditBox->EnableEdit(TRUE);	
}

// Okư Ŭ 
void CINFSecuSetPassWnd::OnClickOk()
{
	char chEdit[512], chComfirmEdit[512];
	memset(chEdit, 0x00, 512);
	memset(chComfirmEdit, 0x00, 512);

	m_pINFSecuEditBox->GetString(chEdit, 512);
	m_pINFSecuComfirmEditBox->GetString(chComfirmEdit, 512);

	if((0 == strlen(chEdit))		
		||(0 == strlen(chComfirmEdit)))
	{
		g_pGameMain->CreateChatChild(STRMSG_C_070917_0203, COLOR_ERROR);// "\\y йȣ ߸ Էϼ̽ϴ."
		return;
	}

	if(0 == strncmp(chEdit, chComfirmEdit, 512))
	{			
		// ٲٱ ϰ Ȯϰ . 		
		m_pINFSecuMain->SetSecurityPassword(chEdit);
	}
	else
	{
		g_pGameMain->CreateChatChild(STRMSG_C_070430_0101, COLOR_ERROR);// "йȣ Ʋϴ."
	}
}

void CINFSecuSetPassWnd::OnClickCancel()
{
	m_pINFSecuMain->ShowSecurityWnd(SECURITY_MODE_SETUP_PASSWORD, FALSE);	
}

void CINFSecuSetPassWnd::RefreshEditCtl(int nEditMode, CINFSecuEditBox* pIEdit)
{
	{
		m_pINFSecuEditBox->EnableEdit(FALSE);
		m_pINFSecuComfirmEditBox->EnableEdit(FALSE);
	}
	
	pIEdit->EnableEdit(TRUE);
	m_nSelEdit = nEditMode;
}