// wrsevicesettingdlg.cpp : implementation file
//

#include "stdafx.h"
#include "..\atumadmintool.h"
#include "wrsevicesettingdlg.h"
#include "wrankingmanagement.h"
#include "AtumSJ.h"
#include "AtumAdminToolDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWRSeviceSettingDlg dialog


///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-26 ~ 2009-02-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
CWRSeviceSettingDlg::CWRSeviceSettingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWRSeviceSettingDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWRSeviceSettingDlg)
	m_ctrlcsServiceUID = _T("");
	m_ctrlcsServiceName = _T("");
	m_ctrlcsSymbolImagePath = _T("");
	m_ctrlcsServerGroupName = _T("");
	m_ctrlcsServerGroupID = _T("");
	//}}AFX_DATA_INIT
	m_ctrlcsServiceUID.Format("%d", SERVICE_UID_FOR_WORLD_RANKING);

	m_pWRankManager		= (CWRankingManagement*)pParent;
	MEMSET_ZERO(&m_RegServiceInfo, sizeof(m_RegServiceInfo));
	MEMSET_ZERO(&m_RegServerGroupInfo, sizeof(m_RegServerGroupInfo));
}


void CWRSeviceSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWRSeviceSettingDlg)
	DDX_Text(pDX, IDC_EDIT_SERVICEUID, m_ctrlcsServiceUID);
	DDX_Text(pDX, IDC_EDIT_SERVICE_NAME, m_ctrlcsServiceName);
	DDX_Text(pDX, IDC_EDIT_SYMBOL_IMAGE_PATH, m_ctrlcsSymbolImagePath);
	DDX_Text(pDX, IDC_EDIT_SERVER_GROUP_NAME, m_ctrlcsServerGroupName);
	DDX_Text(pDX, IDC_EDIT_SERVER_GROUP_ID, m_ctrlcsServerGroupID);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWRSeviceSettingDlg, CDialog)
	//{{AFX_MSG_MAP(CWRSeviceSettingDlg)
	ON_BN_CLICKED(IDC_FIND_FILE, OnFindFile)
	ON_BN_CLICKED(IDC_BTN_REG_OR_UPDATE, OnBtnRegOrUpdate)
	ON_BN_CLICKED(IDC_BTN_DELETE_SERVICE, OnBtnDeleteService)
	ON_BN_CLICKED(IDC_BTN_DELETE_SERVER_GROUP_INFO, OnBtnDeleteServerGroupInfo)
	ON_BN_CLICKED(IDC_BTN_UPDATE_SERVER_GROUP_NAME, OnBtnUpdateServerGroupName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWRSeviceSettingDlg message handlers

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-26 ~ 2009-02-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CWRSeviceSettingDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here


	SWRK_SERVICE_INFO tmServiInfo;	MEMSET_ZERO(&tmServiInfo, sizeof(tmServiInfo));
	if(m_pWRankManager->DBQ_LoadSelfServiceInfo(&tmServiInfo))
	{
		m_ctrlcsServiceUID.Format("%d", tmServiInfo.ServiceUID);
		m_ctrlcsServiceName		= tmServiInfo.ServiceName;
		m_RegServiceInfo		= tmServiInfo;
	}

	SWRK_SERVER_GROUP tmServGroup;	MEMSET_ZERO(&tmServGroup, sizeof(tmServGroup));
	if(m_pWRankManager->DBQ_LoadServerGroupInfo(&tmServGroup))
	{
		m_ctrlcsServerGroupID.Format("%d", tmServGroup.ServerGroupID);
		m_ctrlcsServerGroupName	= tmServGroup.ServerGroupNameforRK;
		m_RegServerGroupInfo	= tmServGroup;
	}
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-26 ~ 2009-02-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CWRSeviceSettingDlg::OnFindFile() 
{
	// TODO: Add your control notification handler code here
	bool bOpen = TRUE;
	
	CFileDialog fDlg(bOpen, "Find Service Symbole Image", bOpen ? NULL : _T(""), OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, _T("Image Files (*.bmp;*.jpg)|*.bmp;*.jpg|All Files (*.*)|*.*||"));
	fDlg.m_ofn.lpstrInitialDir = ".";
	if (IDOK != fDlg.DoModal())
	{
		return;
	}

	CFile ImageFile;
	if(FALSE == ImageFile.Open(fDlg.GetPathName(), CFile::modeRead))
	{
		AfxMessageBox("Invalid file path !!");
		return;
	}

	DWORD dwLen = ImageFile.GetLength();
	if(SIZE_MAX_SERVICE_SYMBOL_IMAGE < dwLen)
	{
		AfxMessageBox("File size is too big !!(less then 2KBytes)");
		return;
	}
	
	m_ctrlcsSymbolImagePath = fDlg.GetPathName();
	
	GetDlgItem(IDC_EDIT_SYMBOL_IMAGE_PATH)->SetWindowText(m_ctrlcsSymbolImagePath);	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-26 ~ 2009-02-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CWRSeviceSettingDlg::OnBtnRegOrUpdate() 
{
	// TODO: Add your control notification handler code here
	if(FALSE == m_pWRankManager->m_pMainDlg->IsConnectedToPreServer())
	{
		AfxMessageBox("Disconnected from PreServer !!");
		return;
	}
	
	UpdateData();

	SWRK_SERVICE_INFO tmServiInfo;
	MEMSET_ZERO(&tmServiInfo, sizeof(tmServiInfo));
	if(m_ctrlcsServiceUID.IsEmpty())
	{
		AfxMessageBox("Input Service UID !!");
		return;
	}

	tmServiInfo.ServiceUID	= atoi(m_ctrlcsServiceUID);
	if(FALSE == IS_IN_RANGE(SERVICE_UID_FOR_WORLD_RANKING, tmServiInfo.ServiceUID, SERVICE_UID_FOR_WORLD_RANKING+99))
	{
		AfxMessageBox("Invalid Service UID !!");
		return;
	}
	if(m_ctrlcsServiceName.IsEmpty())
	{
		AfxMessageBox("Input Service Name !!");
		return;
	}

	STRNCPY_MEMSET(tmServiInfo.ServiceName, m_ctrlcsServiceName, SIZE_MAX_SERVICE_NAME);
	// 2010-01-14 by cmkwon, 巩ŷý  (񽺻,׷) - Ʒ  ('-','_')
	//if(FALSE == CAtumSJ::IsAlphaNum(tmServiInfo.ServiceName))
	if(FALSE == CAtumSJ::IsValidWRankingServiceName(tmServiInfo.ServiceName))
	{
		AfxMessageBox("Invalid Service Name !!");
		return;
	}

	if(m_ctrlcsSymbolImagePath.IsEmpty())
	{
		memcpy(tmServiInfo.ServiceSymbolIamge, m_RegServiceInfo.ServiceSymbolIamge, SIZE_MAX_SERVICE_SYMBOL_IMAGE);
		tmServiInfo.SymbolImageSize		= m_RegServiceInfo.SymbolImageSize;
	}
	else
	{
		CFile ImageFile;
		if(FALSE == ImageFile.Open(m_ctrlcsSymbolImagePath, CFile::modeRead))
		{
			AfxMessageBox("Invalid image file path !!");
			return;
		}
		
		DWORD dwLen = ImageFile.GetLength();
		if(SIZE_MAX_SERVICE_SYMBOL_IMAGE < dwLen)
		{
			AfxMessageBox("Image file size is too big !!");
			return;
		}

		ImageFile.Read(tmServiInfo.ServiceSymbolIamge, dwLen);
		tmServiInfo.SymbolImageSize		= dwLen;
	}

	if(FALSE == m_pWRankManager->DBQ_UpdateSelfServiceInfo(&tmServiInfo))
	{
		AfxMessageBox("DBQ_UpdateSelfServiceInfo# fail !!");
		return;
	}

	m_RegServiceInfo	= tmServiInfo;

	AfxMessageBox("Success to update SelfServiceInfo !!");	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-26 ~ 2009-02-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CWRSeviceSettingDlg::OnBtnDeleteService() 
{
	// TODO: Add your control notification handler code here
	if(FALSE == m_pWRankManager->m_pMainDlg->IsConnectedToPreServer())
	{
		AfxMessageBox("Disconnected from PreServer !!");
		return;
	}

	if(FALSE == this->IsValidServiceInfo())
	{
		AfxMessageBox("You have to register this service to WorldRankingServer !!");
		return;
	}

	UpdateData();

	SWRK_SERVICE_INFO tmServiInfo;
	MEMSET_ZERO(&tmServiInfo, sizeof(tmServiInfo));
	if(m_ctrlcsServiceUID.IsEmpty())
	{
		AfxMessageBox("Input Service UID !!");
		return;
	}
	
	tmServiInfo.ServiceUID	= atoi(m_ctrlcsServiceUID);
	if(FALSE == IS_IN_RANGE(SERVICE_UID_FOR_WORLD_RANKING, tmServiInfo.ServiceUID, SERVICE_UID_FOR_WORLD_RANKING+99)
		|| tmServiInfo.ServiceUID != m_RegServiceInfo.ServiceUID)
	{
		AfxMessageBox("Invalid Service UID !!");
		return;
	}

	if(FALSE == m_pWRankManager->DBQ_DeleteSelfServiceInfo(&tmServiInfo))
	{
		AfxMessageBox("DBQ_DeleteSelfServiceInfo# fail !!");
		return;
	}

	m_ctrlcsServiceName.Empty();
	m_ctrlcsSymbolImagePath.Empty();
	MEMSET_ZERO(&m_RegServiceInfo, sizeof(m_RegServiceInfo));

	UpdateData(FALSE);

	AfxMessageBox("Success to delete SelfServiceInfo !!");	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-26 ~ 2009-02-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CWRSeviceSettingDlg::OnBtnDeleteServerGroupInfo() 
{
	// TODO: Add your control notification handler code here
	if(FALSE == m_pWRankManager->m_pMainDlg->IsConnectedToPreServer())
	{
		AfxMessageBox("Disconnected from PreServer !!");
		return;
	}

	if(0 >= m_RegServerGroupInfo.ServerGroupID)
	{
		AfxMessageBox("You have to register ServerGroupInfo !!");
		return;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2010-01-14 by cmkwon, 巩ŷý  (񽺻,׷) - Ʒ  ڷ .
	int nServiceUID = (m_ctrlcsServiceUID.IsEmpty()) ? 0 : atoi(m_ctrlcsServiceUID);
	if(FALSE == m_pWRankManager->DBQ_DeleteServerGroupInfo(&m_RegServerGroupInfo, nServiceUID))
	{
		AfxMessageBox("DBQ_DeleteServerGroupInfo fail !!");
		return;
	}

	MEMSET_ZERO(&m_RegServerGroupInfo, sizeof(m_RegServerGroupInfo));
	m_ctrlcsServerGroupID.Empty();
	m_ctrlcsServerGroupName.Empty();

	UpdateData(FALSE);

	AfxMessageBox("Success to delete ServerGroupInfo !!");
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-26 ~ 2009-02-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CWRSeviceSettingDlg::OnBtnUpdateServerGroupName() 
{
	// TODO: Add your control notification handler code here
	if(FALSE == m_pWRankManager->m_pMainDlg->IsConnectedToPreServer())
	{
		AfxMessageBox("Disconnected from PreServer !!");
		return;
	}

	if(FALSE == this->IsValidServiceInfo())
	{
		AfxMessageBox("You have to register this service to WorldRankingServer !!");
		return;
	}

	UpdateData();

	SWRK_SERVER_GROUP tmServG;
	MEMSET_ZERO(&tmServG, sizeof(tmServG));

	if(m_ctrlcsServerGroupID.IsEmpty())
	{
		AfxMessageBox("Input Server Group ID !!");
		return;
	}
	tmServG.ServerGroupID	= atoi(m_ctrlcsServerGroupID);
	if(0 >= tmServG.ServerGroupID)
	{
		AfxMessageBox("Invalid Server Group ID !!");
		return;
	}

	if(m_ctrlcsServerGroupName.IsEmpty())
	{
		AfxMessageBox("Input Server Group Name !!");
		return;
	}
	STRNCPY_MEMSET(tmServG.ServerGroupNameforRK, m_ctrlcsServerGroupName, SIZE_MAX_SERVER_NAME);
	// 2010-01-14 by cmkwon, 巩ŷý  (񽺻,׷) - Ʒ  ('-','_')
	//if(FALSE == CAtumSJ::IsAlphaNum(tmServG.ServerGroupNameforRK))
	if(FALSE == CAtumSJ::IsValidWRankingServiceName(tmServG.ServerGroupNameforRK))
	{
		AfxMessageBox("Invalid Server Group Name !!");
		return;
	}

	if(FALSE == m_pWRankManager->DBQ_UpdateServerGroupInfo(&tmServG))
	{
		AfxMessageBox("DBQ_UpdateServerGroupInfo fail !!");
		return;
	}


	m_RegServerGroupInfo	= tmServG;

	AfxMessageBox("Success to update ServerGroupInfo !!");
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
/// \author		cmkwon
/// \date		2009-02-24 ~ 2009-02-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CWRSeviceSettingDlg::IsValidServiceInfo(void)
{
	if(0 >= m_RegServiceInfo.ServiceUID
		|| 0 >= strlen(m_RegServiceInfo.ServiceName))
	{
		return FALSE;
	}

	return TRUE;
}