// FieldIOCPSocket2.cpp: implementation of the CFieldIOCPSocket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "FieldIOCPSocket.h"
#include "FieldIOCP.h"
#include "LogWinSocket.h"
#include "FieldServer.h"
#include "FieldGlobal.h"
#include "MonsterDBAccess.h"
#include "FieldMapProject.h"
#include "AtumLogSender.h"
#include "AtumError.h"
#include "FieldParty.h"
#include "GeneralRequestHandler.h"
#include "RacingDemon.h"
#include "MTAutoCriticalSection.h"
#include "AtumTime.h"
//#include "MallAgentConnect.h"			// 2005-11-29 by cmkwon, #include "MGExtMallAuthDll4CP.h"
#include "CouponManager.h"
#include "HappyHourEventManager.h"
#include "FieldODBC.h"
#include "GuildDamageManager.h"
#include "EXPDivisionManager.h"
#include "CallWarpEventManager.h"		// 2006-07-21 by cmkwon
#include "BazaarManager.h"				// 2006-07-26 by cmkwon
#include "SecurityManager.h"			// 2011-06-22 by hskim, 缳  
#include "TriggerMapBuffManager.h"		// 2011-10-10 by hskim, EP4 [Ʈ ý] - ȭ /  ǳ
#include "MapTriggerManager.h"			// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
#include "TriggerFunction.h"			// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý		
#include "StatisticsManager.h"			// 2012-01-16 by hskim,  - ȭ
#include "GlobalFunc.h"


///////////////////////////////////////////////////////////////////////////////
// 2008-04-25 by cmkwon,  / ߰  ߰ Ǿ ϴ  - [-ʼ]  ̺귯  ߰


#include "AllGuildItemManager.h"		// 2006-09-20 by dhjin
#include "GuildItemManager.h"			// 2006-09-20 by dhjin
#include "PCBangIPManager.h"			// 2007-08-07 by dhjin
#include "md5_lib_src.h"				// 2007-09-13 by cmkwon, Ʈ 2н  -

#include <BonusKillSystem.h>			// 2015-06-16 by Future, Bonus Kill System Definitions

// 2012-08-17 by jhseol,  BPSoft ý
// ġ Ʈ Ʈ Ѵ.
#ifdef S_BPSOFTBILLING_JHSEOL
#import "../../Lib/BPSOFT/BCARTPURCHASE_COM.dll" no_namespace
#include <atlbase.h>
#endif

//ȯ Լ 
#define BUFFSIZE 1024
#define WTOM(wstr, mstr ) WideCharToMultiByte( CP_ACP, 0, (LPCWSTR)(wstr), -1, (mstr), BUFFSIZE, NULL, NULL )
#define MTOW(mstr, wstr, n ) MultiByteToWideChar( CP_ACP, MB_ERR_INVALID_CHARS, (mstr), (n), (wstr), BUFFSIZE/2 )
/********************************************************
BPSoft ý    ذ by jhseol

VS6.0 ȯ濡   ߻ ذ

  case.1 --> error C2065: 'CoInitializeEx' : undeclared identifier
	solution : ޴-> Project Settings -> C/C++ tab Preprocessor definitions _WIN32_DCOM  ߰ ϸ ȴ.


  case.2 --> error C2065: 'CComPtr' : undeclared identifier
	solution : #include <atlbase.h> ߰


  case.3 --> error C2664: 'WideCharToMultiByte' : cannot convert parameter 3 from 'long' to 'const unsigned short *'
	solution :  ũ Լ ĳ  ȵǴ  ũ 
			before	- #define WTOM(wstr, mstr ) WideCharToMultiByte( CP_ACP, 0,			 (wstr), -1, (mstr), BUFFSIZE, NULL, NULL )
			after	- #define WTOM(wstr, mstr ) WideCharToMultiByte( CP_ACP, 0, (LPCWSTR)(wstr), -1, (mstr), BUFFSIZE, NULL, NULL )
********************************************************/

#define BPSOFT_MEMBERSHIP_CODE			"MASANG"
#define BPSOFT_CINTENS_NO				1
#define BPSOFT_SITE_NO					1
#define BPSOFT_METHOD_CALL_NO_ERRER		"0000"
#define BPSOFT_TEST_USER_NO				"321"
#define BPSOFT_TEST_USER_ID				"bey2207"
#define BPSOFT_ITEM_AMOUNT				1		// ĳ ƾ 1Ծ Ǹ ϰ ִ.
// end 2012-08-17 by jhseol,  BPSoft ý

ProcessResult CFieldIOCPSocket::Process_FC_SHOP_GET_ITEMINFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	int									nRecvTypeSize = 0;
	MSG_FC_SHOP_GET_ITEMINFO			*pGetItemInfo = NULL;
	BYTE								SendBuf[SIZE_MAX_PACKET];

	nRecvTypeSize = sizeof(MSG_FC_SHOP_GET_ITEMINFO);

	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_SHOP_GET_ITEMINFO, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14040);
		return RES_RETURN_FALSE;
	}

	pGetItemInfo = (MSG_FC_SHOP_GET_ITEMINFO*)(pPacket+nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	*(MessageType_t*)SendBuf = T_FC_SHOP_GET_ITEMINFO_OK;
	MSG_FC_SHOP_GET_ITEMINFO_OK *pGetItemInfoOK
		= (MSG_FC_SHOP_GET_ITEMINFO_OK*)(SendBuf + SIZE_FIELD_TYPE_HEADER);
	pGetItemInfoOK->ItemInfo = *(ms_pFieldIOCP->GetItemInfo(pGetItemInfo->ItemNum));

	SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_GET_ITEMINFO_OK));

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SHOP_BUY_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_BUY_ITEM,
									MSG_FC_SHOP_BUY_ITEM, pBuyItem);
	if (!IsValidCharacter())
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
	
	//////////////////////////////////////////////////////////////////////////
	// 2008-08-18 by dhjin, 1  ý ȹ
	if(!this->CheckOneSecondTermSystem())
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_INTERVAL_SYSTEM_SECOND, m_dwMSTermSystem);
		return RES_BREAK;
	}

	if(INVALID_UNIQUE_NUMBER != m_peerTraderCharacterUniqueNumber
		&& 0 != m_peerTraderCharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_ITEM_TRADING);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_SHOP_BUY_ITEM û 2н üũ
	if(!this->CheckSecondaryPasswordLock())
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_SECPASS_LOCKED);
		return RES_BREAK;
	}

	if(pBuyItem->Amount <= 0)
	{
		
		char szSystemLog[512];
		sprintf(szSystemLog, "[ERROR] Shop Buy Item Error, Char(%15s) ItemNum(%8d) ItemAmoun(%8d)\r\n"
			, m_character.CharacterName, pBuyItem->ItemNum, pBuyItem->Amount);
		g_pFieldGlobal->WriteSystemLog(szSystemLog);
		DBGOUT(szSystemLog);

		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0070);
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, pBuyItem->Amount);
		return RES_RETURN_FALSE;
	}

	CShopInfo* pShopInfo = m_pCurrentFieldMapChannel->m_pFieldMapProject->GetShopInfoByBuildingNPC(pBuyItem->BuildingIndex);
	if (!pShopInfo)
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP);
		return RES_RETURN_FALSE;
	}

	SHOP_ITEM *pShopItem = pShopInfo->GetSHOP_ITEMPtr(pBuyItem->ItemNum);
	if (NULL == pShopItem)
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP_ITEM, pBuyItem->ItemNum);
		return RES_RETURN_FALSE;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-02-08 by cmkwon, ó
	float	fTotalTexPercent	= ms_pFieldIOCP->GetInfluenceTypeDistirbutionTexPercent(m_character.InfluenceType);
	int		nTotalTexSPI		= 0;


	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);			// lock m_mapItemGeneral, MSG_FC_SHOP_BUY_ITEM
	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if(pMoney == NULL)
	{// check:
		if(NULL == pMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
// 2006-10-23 by cmkwon, Ʒ SendErrorMessage()  
//		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0070);
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM, MONEY_ITEM_NUMBER);
		return RES_BREAK;
	}

	//  䱸  Ȯ, check: ϴ skill 츸 Ȯ
	ITEM *pItemInfo = ms_pFieldIOCP->GetItemInfo(pBuyItem->ItemNum);
	if (pItemInfo == NULL)
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM, pBuyItem->ItemNum);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2009-09-23 by cmkwon, ʵâ ĳ   - T_FC_SHOP_BUY_ITEM, ʵâ ̿  Űɿ  üũ
	if(pItemInfo->IsExistDesParam(DES_FIELD_STORE)
		&& this->m_ItemManager.IsUseableFieldStore())
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_CANNOT_BUY_ITEM, pItemInfo->ItemNum, this->m_ItemManager.IsUseableFieldStore());
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// ִ  Ȯ
	// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  -  
	if(IS_COUNTABLE_ITEM(pItemInfo->Kind))
	{// īͺ  κ丮   ִ밳 Ȯ

		ITEM_GENERAL *pItemGeneralInven = m_ItemManager.GetFirstItemGeneralByItemNum(pBuyItem->ItemNum);
		if (NULL == pItemGeneralInven
			&& m_ItemManager.GetInventoryItemCounts() >= m_ItemManager.GetMaxInventoryCount())
		{
			SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, m_ItemManager.GetMaxInventoryCount());
			return RES_BREAK;
		}
	}
	else if(IS_GENERAL_ITEM(pItemInfo->Kind))
	{// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - Ʒ  üũ 

		pBuyItem->Amount = min(pBuyItem->Amount, MAX_ITEM_COUNTS_FOR_BUY);		// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - ִ    .

		if(m_ItemManager.GetInventoryItemCounts() + pBuyItem->Amount > m_ItemManager.GetMaxInventoryCount())
		{// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ -     ؼ üũ Ѵ.
			SendErrorMessage(T_FC_STORE_MOVE_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, m_ItemManager.GetMaxInventoryCount());
			return RES_BREAK;
		}
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2005-09-13 by cmkwon, īͺ   ִ(20) īƮ üũ
	if(IS_COUNTABLE_ITEM(pItemInfo->Kind))
	{
		INT64 tmCurrentCount = pBuyItem->Amount;

		ITEM_GENERAL *pMyItem = m_ItemManager.GetFirstItemGeneralByItemNum(pBuyItem->ItemNum);
		if(pMyItem){				tmCurrentCount += pMyItem->CurrentCount;}
		if(tmCurrentCount > MAX_ITEM_COUNTS)
		{
			SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER, 0, 0);
			return RES_BREAK;			
		}
		else if(tmCurrentCount >= MAX_NOTIFY_ITEM_COUNTS)
		{
			SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_NOTIFY_MAX_ITEM_COUNTS_OVER);
		}
	}	

	if (IS_GENERAL_ITEM(pItemInfo->Kind) 
		&& FALSE == IS_SKILL_ITEM(pItemInfo->Kind)			// 2007-01-30 by cmkwon, ų κ丮  üũ ʴ´
		&& FALSE == IS_COUNTABLE_ITEM(pItemInfo->Kind))
	{
		if(timeGetTime()-m_dwLastTickInsertingStoreItem > 5000)
		{
			m_nInsertingStoreItemCounts = 0;
		}

		if(m_ItemManager.GetInventoryItemCounts() + m_nInsertingStoreItemCounts + pBuyItem->Amount > m_ItemManager.GetMaxInventoryCount())
		{
			SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, 1);
			return RES_BREAK;
		}		
	}

	if (COMPARE_BIT_FLAG(pItemInfo->ItemAttribute, ITEM_ATTR_NO_TRANSFER|ITEM_ATTR_KILL_MARK_ITEM))
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}

	// ּ ŷ  Ȯ: MinTradeQuantity θ    
	if ( pBuyItem->Amount%pItemInfo->MinTradeQuantity != 0)
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_MIN_TRADE_QUANTITY_ERROR, pItemInfo->MinTradeQuantity);
		return RES_BREAK;
	}

	// ų   LinkItem ʿ ,  LinkItemNum
	int nDeleteLinkItemNum = 0;

	if (IS_SKILL_ITEM(pItemInfo->Kind))
	{
		Err_t tmpErr = CheckSkillItemRequirements(pItemInfo);
		if (tmpErr != ERR_NO_ERROR)
		{
			SendErrorMessage(T_FC_SHOP_BUY_ITEM, tmpErr);
			return RES_BREAK;
		}

		if(IS_BAZAAR_SKILL(pItemInfo)
			&& COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
		{// 2006-08-08 by cmkwon, Ϲݼ λų  Ұ
			SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
			return RES_BREAK;
		}

		// ̹ ش ų   ERR_PROTOCOL_ALREADY_HAVE_SKILL 
		// 2013-03-12 by jhseol, ų ѹ ý 
#ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
		ITEM_SKILL *pOldItemSkill = m_ItemManager.GetFirstSkillBySkillBaseNum(pItemInfo->NextSkill);
		if (pOldItemSkill != NULL)
		{
			if (pOldItemSkill->ItemInfo->SkillLevel >= pItemInfo->SkillLevel)
			{
				SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0071);
				SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED);		// 2006-10-23 by cmkwon
				return RES_BREAK;
			}
		}
#else	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
		ITEM_SKILL *pOldItemSkill = m_ItemManager.GetFirstSkillBySkillBaseNum(pItemInfo->ItemNum);
		if (pOldItemSkill != NULL)
		{
			if (SKILL_LEVEL(pOldItemSkill->ItemNum) >= SKILL_LEVEL(pItemInfo->ItemNum))
			{
				SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0071);
				SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED);		// 2006-10-23 by cmkwon
				return RES_BREAK;
			}
		}
#endif	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
		// end 2013-03-12 by jhseol, ų ѹ ý 

		// ų LinkItem Ȯ
		if (pItemInfo->LinkItem != 0)
		{
			ITEM *pTmpLinkItemInfo = ms_pFieldIOCP->GetItemInfo(pItemInfo->LinkItem);
			if (pTmpLinkItemInfo == NULL)
			{
				SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0072);
				SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED);		// 2006-10-23 by cmkwon
				return RES_BREAK;
			}

			if (m_ItemManager.GetFirstItemGeneralByItemNum(pItemInfo->LinkItem) == NULL)
			{
				SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_DO_NOT_HAVE_LINK_ITEM, pTmpLinkItemInfo->ItemNum, 0, pTmpLinkItemInfo->ItemName);
				return RES_BREAK;
			}

			nDeleteLinkItemNum = pItemInfo->LinkItem;
		}
	}

	//  Ȯ
	if (pMoney == 0)
	{
		// error
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	INT64 n64SumOfPrice	= pShopItem->Price;
	n64SumOfPrice		*= (pBuyItem->Amount/pItemInfo->MinTradeQuantity);

	// 2012-10-16 by bckim, ĳ  Log ߰
	INT64 n64LogSpend = n64SumOfPrice;		//	  Ժ 
	// end 2012-10-16 by bckim, ĳ  Log ߰
	
// 2006-02-08 by cmkwon,    
//	nCityWarTex			= CAtumSJ::GetCityWarTex(n64SumOfPrice, fCityWarTexPercent);
//	n64SumOfPrice		+= nCityWarTex;

	nTotalTexSPI		= CAtumSJ::GetItemTexSPI(n64SumOfPrice, fTotalTexPercent);
	n64SumOfPrice		+= nTotalTexSPI;

	if (n64SumOfPrice > pMoney->CurrentCount)
	{
		// error
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	// start 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
	//   Ȯ
	UID32_t ShopOwnerUID = pShopInfo->GetShopOwner();
	if( ShopOwnerUID != 0 && ShopOwnerUID != m_character.CharacterUniqueNumber )
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_NOT_OWNER_SHOP);
		return RES_BREAK;
	}

	//    Ȯ
	if( FALSE == pShopItem->IsAvailableShopItem(pBuyItem->Amount) )
	{
		SendErrorMessage(T_FC_SHOP_BUY_ITEM, ERR_INSUFFICIENT_NUMBER_SHOP_ITEM);

		return RES_BREAK;
	}
	// end 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý

	if (IS_SKILL_ITEM(pItemInfo->Kind))
	{
		// ų   ϳ

		//  
		m_ItemManager.InsertItemBaseByItemNum(pItemInfo->ItemNum, 1, IUT_SHOP);

		//  
		m_ItemManager.UpdateItemCountByPointer(pMoney, -n64SumOfPrice, IUT_SHOP);

		if (nDeleteLinkItemNum != 0)
		{
			m_ItemManager.DeleteItemFromCharacterByItemNum(nDeleteLinkItemNum, 1, IUT_SHOP);
		}
	}
	else
	{
		// skill ̿ Ϲ  

		//  
		m_ItemManager.InsertItemBaseByItemNum(pItemInfo->ItemNum, pBuyItem->Amount, IUT_SHOP);

		//  
		m_ItemManager.UpdateItemCountByPointer(pMoney, -n64SumOfPrice, IUT_SHOP);

		// start 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
		if( TRUE == pShopItem->IsLimitedEditionShopItem() )
		{
			pShopItem->RemainCountForLimitedEdition -= pBuyItem->Amount;

			SHOP_ITEM *pShopItemBuffer = pShopInfo->GetSHOP_ITEMPtrFrombuffer(pShopItem->ItemNum);
			if( NULL != pShopItemBuffer )
			{
				pShopItemBuffer->RemainCountForLimitedEdition -= pBuyItem->Amount;
			}

			INIT_MSG_OF_SIZE(MSG_FC_SHOP_BUY_ITEM_UPDATE, T_FC_SHOP_BUY_ITEM_UPDATE, pBuyUpdateInfo, SendBuf);
			pBuyUpdateInfo->BuildingIndex = pBuyItem->BuildingIndex;
			pBuyUpdateInfo->ItemNum = pItemInfo->ItemNum;
			pBuyUpdateInfo->RemainCountForLimitedEdition = pShopItemBuffer->RemainCountForLimitedEdition;
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_BUY_ITEM_UPDATE));
		}
		// end 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
	}

	// send log
	ITEM_GENERAL tmpItemForLog(pItemInfo);
	tmpItemForLog.UniqueNumber			= 0;
	tmpItemForLog.AccountUniqueNumber	= m_character.AccountUniqueNumber;
	tmpItemForLog.Possess				= m_character.CharacterUniqueNumber;
	tmpItemForLog.Wear					= WEAR_NOT_ATTACHED;
	tmpItemForLog.CurrentCount			= pBuyItem->Amount;
// 2009-08-25 by cmkwon,  ʴ ʵ (td_Store.ScarcityNumber) - 
//	tmpItemForLog.ScarcityNumber		= 0;
	tmpItemForLog.ItemWindowIndex		= POS_INVALID_POSITION;
	tmpItemForLog.PrefixCodeNum			= 0;
	tmpItemForLog.SuffixCodeNum			= 0;
	tmpItemForLog.NumOfEnchants			= 0;
	CAtumLogSender::SendLogMessageITEMBuyITEM(this, &tmpItemForLog, pBuyItem->Amount, pMoney->CurrentCount);

	// 2012-10-16 by bckim, ĳ  Log ߰
	//enum ITEM_BUY_CASH_PRICE_TYPE{BUY_TYPE_SPI=1,BUY_TYPE_WARPOINT,BUY_TYPE_CASH,BUY_TYPE_INFINITY};
	CAtumLogSender::SendLogMessageITEMBuyCashPrice(this, &tmpItemForLog, pBuyItem->Amount, n64LogSpend, FALSE, BUY_TYPE_SPI, NULL); // SPI TYPE : 1
	// end 2012-10-16 by bckim, ĳ  Log ߰

	igLock.auto_unlock_cancel();

	// 2007-08-27 by dhjin, ǰ ó
	this->SetExpediencyFundW(m_character.InfluenceType, n64SumOfPrice);

// 2006-02-08 by cmkwon,   
//	if(nCityWarTex > 0)
//	{
//		m_pCurrentFieldMapChannel->CityWarAddTex(nCityWarTex);
//	}
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SHOP_GET_USED_ITEM_PRICE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_GET_USED_ITEM_PRICE,
									MSG_FC_SHOP_GET_USED_ITEM_PRICE, pMsgGetUsedItemPrice);

	
	// lock m_mapItemGeneral, MSG_FC_SHOP_GET_USED_ITEM_PRICE
	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);

	// Get Item Info
	ITEM_GENERAL *pItem = m_ItemManager.GetItemGeneralByUID(pMsgGetUsedItemPrice->ItemUniqueNumber);
	if (pItem == NULL)
	{
		SendErrorMessage(T_FC_SHOP_GET_USED_ITEM_PRICE, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}
	ITEM *pItemInfo = pItem->ItemInfo;

	// Check if the user tries to sell more or less of the Item than its min trade quantity
	if (pMsgGetUsedItemPrice->Amount % pItemInfo->MinTradeQuantity != 0)
	{
		SendErrorMessage(T_FC_SHOP_GET_USED_ITEM_PRICE, ERR_PROTOCOL_MIN_TRADE_QUANTITY_ERROR, pItemInfo->MinTradeQuantity);
		return RES_BREAK;
	}

	INIT_MSG_OF_SIZE(MSG_FC_SHOP_GET_USED_ITEM_PRICE_OK, T_FC_SHOP_GET_USED_ITEM_PRICE_OK, pMsgGetUsedItemPriceOK, SendBuf);
	pMsgGetUsedItemPriceOK->ItemUniqueNumber = pItem->UniqueNumber;
	pMsgGetUsedItemPriceOK->Price
#ifdef SHOP_PRICES_PER_BUILDING_NPC
		= (UINT)(pItemInfo->SellingPrice * (pMsgGetUsedItemPrice->Amount / pItemInfo->MinTradeQuantity));	// Ignore Selling Price Rate
#else
		= (UINT)(pItemInfo->Price * CAtumSJ::GetItemSellingPriceRate() * (pMsgGetUsedItemPrice->Amount/pItemInfo->MinTradeQuantity));
#endif // SHOP_PRICES_PER_BUILDING_NPC
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_GET_USED_ITEM_PRICE_OK));
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SHOP_GET_SHOP_ITEM_LIST(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_GET_SHOP_ITEM_LIST,
									MSG_FC_SHOP_GET_SHOP_ITEM_LIST, pMsgGetList);

	if (m_pCurrentBuildingNPC == NULL)
	{
		SendErrorMessage(T_FC_SHOP_GET_SHOP_ITEM_LIST, ERR_PROTOCOL_NO_SUCH_SHOP, pMsgGetList->BuildingIndex);
		return RES_BREAK;
	}

	if (m_pCurrentBuildingNPC != NULL
		&& m_pCurrentBuildingNPC->BuildingIndex != pMsgGetList->BuildingIndex)
	{
		SendErrorMessage(T_FC_SHOP_GET_SHOP_ITEM_LIST, ERR_PROTOCOL_NO_SUCH_SHOP, pMsgGetList->BuildingIndex);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-01-10 by cmkwon, 
	if(BUILDINGKIND_CASH_SHOP == m_pCurrentBuildingNPC->BuildingKind
		&& FALSE == g_pFieldGlobal->m_bCashShopServiceFlag
		&& FALSE == COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER))
	{// 2007-01-10 by cmkwon, ȭ   üũ - /ڴ  
		SendErrorMessage(T_FC_SHOP_GET_SHOP_ITEM_LIST, ERR_CASH_CASH_SHOP_NO_SERVICE, 0, 0, NULL, FALSE, FALSE);
		return RES_BREAK;
	}

	ResetCashAuthenticationKey();		// 2013-03-13 by hskim,  ĳ 

	switch (m_pCurrentBuildingNPC->BuildingKind)
	{
	case BUILDINGKIND_1ST_WEAPONSHOP:
	case BUILDINGKIND_2ND_WEAPONSHOP:
	case BUILDINGKIND_COMPONENTSHOP:
	case BUILDINGKIND_PETSHOP:
	case BUILDINGKIND_ANTIQUESHOP:
	case BUILDINGKIND_PUBLICOFFICE:
	case BUILDINGKIND_ACTIONHOUSE:
	case BUILDINGKIND_RACETRACK:
	case BUILDINGKIND_REFINERY:
	case BUILDINGKIND_MILITARYACADEMY:
	case BUILDINGKIND_SKILL_SHOP:
	case BUILDINGKIND_CASH_SHOP:
	case BUILDINGKIND_WARPOINT_SHOP:
	case BUILDINGKIND_TRIGGER_CRYSTAL:	// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
	case BUILDINGKIND_PARTSSHOP:		// 2012-02-29 by hskim,  ŸƲ ֱ - 
	case BUILDINGKIND_GEARSHOP:			// 2012-02-29 by hskim,  ŸƲ ֱ - 
	case BUILDINGKIND_CARDSHOP:			// 2012-02-29 by hskim,  ŸƲ ֱ - ī
		{
			if(BUILDINGKIND_CASH_SHOP == m_pCurrentBuildingNPC->BuildingKind)
			{
				///////////////////////////////////////////////////////////////////////////////
				// 2010-01-26 by cmkwon, ĳ  Ǹ ý  - T_FC_SHOP_GET_SHOP_ITEM_LIST, Ǹ  Ʈ Ʈ
				ms_pFieldIOCP->LimitedEUpdateShopItemW(pMsgGetList->BuildingIndex, this->GetCurrentFieldMapProject());				

				// 2013-03-13 by hskim,  ĳ 
#ifdef S_WEB_CASHSHOP_SERVER_MODULE_HSKIM
				GenCashAuthenticationKey();

				INIT_MSG_OF_SIZE(MSG_FC_SHOP_AUTH_KEY, T_FC_SHOP_AUTH_KEY, pAuthKeyMsg, SendBuf);
				STRNCPY_MEMSET(pAuthKeyMsg->AuthenticationKey, GetCashAuthenticationKey(), sizeof(pAuthKeyMsg->AuthenticationKey));
				pAuthKeyMsg->ServerID = g_pGlobalGameServer->GetMGameServerID();
				SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_AUTH_KEY));
#endif
				// end 2013-03-13 by hskim,  ĳ 
			}

			CShopInfo* pShopInfo = m_pCurrentFieldMapChannel->m_pFieldMapProject->GetShopInfoByBuildingNPC(pMsgGetList->BuildingIndex);
			if (!pShopInfo)
			{
				SendErrorMessage(T_FC_SHOP_GET_SHOP_ITEM_LIST, ERR_PROTOCOL_NO_SUCH_SHOP, pMsgGetList->BuildingIndex);
				return RES_BREAK;
			}

			BYTE *buf = (BYTE*)pShopInfo->m_buffer.ptr;
			int size = pShopInfo->m_buffer.size;
			int offset = 0;

			// send MSG_FC_SHOP_PUT_ITEM_HEADER
			SendAddData(buf + offset, MSG_SIZE(MSG_FC_SHOP_PUT_ITEM_HEADER));
			offset +=  MSG_SIZE(MSG_FC_SHOP_PUT_ITEM_HEADER);

			// send MSG_FC_SHOP_PUT_ITEM
			BYTE *msgStartPoint;
			MessageType_t Type;

			while(TRUE)
			{
				msgStartPoint = buf + offset;

				Type = *(MessageType_t*)(buf + offset);
				offset += SIZE_FIELD_TYPE_HEADER;

				if (Type == T_FC_SHOP_PUT_ITEM)
				{
					MSG_FC_SHOP_PUT_ITEM *pPutItem = (MSG_FC_SHOP_PUT_ITEM*)(buf + offset);
					offset += sizeof(MSG_FC_SHOP_PUT_ITEM);
					assert(pPutItem->BytesToRead < SIZE_MAX_PACKET);

					SendAddData(msgStartPoint, MSG_SIZE(MSG_FC_SHOP_PUT_ITEM) + pPutItem->BytesToRead);
					offset += pPutItem->BytesToRead;
				}
				else if (Type == T_FC_SHOP_PUT_ITEM_DONE)
				{
					break;
				}
				else
				{
					ASSERT_NEVER_GET_HERE();
				}
			}

			// send MSG_FC_SHOP_PUT_ITEM_DONE
			assert(Type==T_FC_SHOP_PUT_ITEM_DONE);
			SendAddData(msgStartPoint, MSG_SIZE(MSG_FC_SHOP_PUT_ITEM_DONE));
			offset += sizeof(MSG_FC_SHOP_PUT_ITEM_DONE);

			assert(size== offset);
		}
		break;
	case BUILDINGKIND_CITYWARP:
	case BUILDINGKIND_LABORATORY:
	case BUILDINGKIND_FACTORY:
	case BUILDINGKIND_STORE:
	case BUILDINGKIND_AUCTION:
	case BUILDINGKIND_ARENA:
	case BUILDINGKIND_TUNING_COLOR:		// 2005-11-11 by cmkwon, ߰
	case BUILDINGKIND_BRIEFING_ROOM:	// 2007-07-16 by dhjin
	case BUILDINGKIND_TUTORIAL:			// 2007-07-16 by dhjin
	case BUILDINGKIND_CITYLEADER_LEADER:		// 2007-08-27 by dhjin
	case BUILDINGKIND_CITYLEADER_OUTPOST:		// 2007-08-27 by dhjin
	case BUILDINGKIND_LUCKY:			// 2008-11-04 by dhjin, Űӽ
	case BUILDINGKIND_WORLDRANKING:		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case BUILDINGKIND_INFINITY:			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	case BUILDINGKIND_LUCKY_OPTION_MACHINE:			// 2010-04-20 by cmkwon, ű Ű ӽ  - 
	case BUILDINGKIND_MYSTERY_SHOP:			// 2012-07-09 by hskim, ̽͸ ӽ 
		{
			// do nothing
		}
		break;
	case BUILDINGKIND_INFINITY_SHOP:	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
		{
			BYTE SendBuf[SIZE_MAX_PACKET];
			int			nSendBytes		= 0;
			*(MessageType_t*)(SendBuf)	= T_FC_SHOP_INFINITY_ITEM_HEADER;
			nSendBytes					= SIZE_FIELD_TYPE_HEADER;
			
			vectorInfinityShopInfo::iterator itrInfinityInfo = this->ms_pFieldIOCP->m_InfinityShopInfoList.begin();
			for (; itrInfinityInfo != this->ms_pFieldIOCP->m_InfinityShopInfoList.end(); itrInfinityInfo++) {
				if(nSendBytes + MSG_SIZE(MSG_FC_SHOP_INFINITY_ITEM) > SIZE_MAX_PACKET) {
					this->SendAddData(SendBuf, nSendBytes);
					nSendBytes					= 0;
				}
				
				*((MessageType_t*)(SendBuf + nSendBytes))	= T_FC_SHOP_INFINITY_ITEM;
				nSendBytes									+= SIZE_FIELD_TYPE_HEADER;
				MSG_FC_SHOP_INFINITY_ITEM *pRMsg			= (MSG_FC_SHOP_INFINITY_ITEM*)(SendBuf + nSendBytes);
				*pRMsg										= *itrInfinityInfo;
				nSendBytes									+= sizeof(MSG_FC_SHOP_INFINITY_ITEM);
			}
			
			if(nSendBytes > 0) {
				this->SendAddData(SendBuf, nSendBytes);
				nSendBytes						= 0;
			}
			
			this->SendAddMessageType(T_FC_SHOP_INFINITY_ITEM_DONE);	
		}
		break;
	case BUILDINGKIND_DISSOLUTION:		// 2010-08-31 by shcho&jskim ۿ ý - 
		{
			// do nothing
		}
		break;
	// 2013-05-09 by hskim,  Ʈ 
	case BUILDINGKIND_INFLBUFF_SHOP:
		{
			// do nothing
		}
		break;
	// 2013-05-09 by hskim,  Ʈ 
	default:
		{
			SendErrorMessage (T_FC_EVENT_ENTER_BUILDING, ERR_PROTOCOL_NO_SUCH_SHOP, m_pCurrentBuildingNPC->BuildingKind);
			return RES_BREAK;
		}
		break;
	}

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SHOP_SELL_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_SELL_ITEM,
									MSG_FC_SHOP_SELL_ITEM, pMsgSellItem);

	if (FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2008-08-18 by dhjin, 1  ý ȹ
	/*if(!this->CheckOneSecondTermSystem())
	{
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_INTERVAL_SYSTEM_SECOND, m_dwMSTermSystem);
		return RES_BREAK;
	}*/

	///////////////////////////////////////////////////////////////////////////////
	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_SHOP_SELL_ITEM û 2н üũ
	if(FALSE == this->CheckSecondaryPasswordLock())
	{
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_SECPASS_LOCKED);
		return RES_BREAK;
	}

	// lock m_mapItemGeneral, MSG_FC_SHOP_SELL_ITEM
	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);

	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if(pMoney == NULL)
	{	// check:
		if(NULL == pMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0073);
		return RES_BREAK;
	}

	ITEM_GENERAL *pItemToSell = m_ItemManager.GetItemGeneralByUID(pMsgSellItem->ItemUniqueNumber);
	if (pItemToSell == NULL)
	{
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM, pMsgSellItem->ItemUniqueNumber);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2008-07-22 by cmkwon,   üũ(ItemUID üũ) ߰ - Process_FC_SHOP_SELL_ITEM
	if(pItemToSell->Kind != pMsgSellItem->ItemKind
		|| pItemToSell->UniqueNumber != pMsgSellItem->ItemUniqueNumber
		|| pItemToSell->Possess != GetCharacter()->CharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER, 1000);
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] ItemBug(%s) %s %s, %d %I64d, %d %d\r\n"
			, GetProtocolTypeString(T_FC_SHOP_SELL_ITEM), GetCharacterString(GetCharacter(), string()), GetItemGeneralString(pItemToSell, string()), pItemToSell->Possess, pMsgSellItem->ItemUniqueNumber, pItemToSell->Kind, pMsgSellItem->ItemKind);
		return RES_BREAK;
	}

	// 2008-02-19 by cmkwon,    Ǹ Ұ - 
	// 2009-10-22 by cmkwon, ð   ý  - 
	//if(SIZE_MAX_POS > pItemToSell->ItemWindowIndex)
	if(IS_ATTACHABLE_POSITION(pItemToSell->ItemWindowIndex))
	{		
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_CANNOT_UNWEAR_ARMOR, pItemToSell->ItemNum, pItemToSell->ItemWindowIndex);
		return RES_BREAK;
	}

	ITEM *pItemInfo = pItemToSell->ItemInfo;
	if (pItemToSell->Kind != pMsgSellItem->ItemKind)
	{
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_ITEM_KIND_NOT_MATCHED, pItemToSell->Kind, pMsgSellItem->ItemKind);
		return RES_BREAK;
	}

	if (COMPARE_BIT_FLAG(pItemInfo->ItemAttribute, ITEM_ATTR_NO_TRANSFER))
	{
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}

	if(ITEMKIND_ACCESSORY_TIMELIMIT == pItemToSell->Kind
		&& pItemToSell->UsingTimeStamp != ITEM_NOT_USING)
	{// 2006-06-16 by cmkwon, ̹  ۵   Ǹ/ŷ/â ̵ Ұ
		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER, 1, 0);
		return RES_BREAK;
	}


	// check:  , 20040913, kelovon
//	// ּ ŷ  Ȯ: MinTradeQuantity θ   
//	if ( pMsgSellItem->Amount%pItemInfo->MinTradeQuantity != 0)
//	{
//		SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_MIN_TRADE_QUANTITY_ERROR, pItemInfo->MinTradeQuantity);
//		return RES_BREAK;
//	}

	if (IS_COUNTABLE_ITEM(pItemToSell->Kind))
	{
		if (pItemToSell->CurrentCount < pMsgSellItem->Amount)
		{
			SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
			return RES_BREAK;
		}

		int nIncomingMoney
#ifdef SHOP_PRICES_PER_BUILDING_NPC
			= (int)pItemInfo->SellingPrice * (pMsgSellItem->Amount / pItemInfo->MinTradeQuantity);
#else
			= (int)(pItemInfo->Price * CAtumSJ::GetItemSellingPriceRate()) * (pMsgSellItem->Amount / pItemInfo->MinTradeQuantity);
#endif // SHOP_PRICES_PER_BUILDING_NPC

		

		// send log
		CAtumLogSender::SendLogMessageITEMSellITEM(this,
				pItemToSell, pMsgSellItem->Amount,
				pMoney->CurrentCount + nIncomingMoney);	//   Ǹ

		m_ItemManager.UpdateItemCountByPointer(pItemToSell, -pMsgSellItem->Amount, IUT_SHOP);
		m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, nIncomingMoney, IUT_SHOP);
	}
	else
	{
		if (pMsgSellItem->Amount != 1)
		{
			SendErrorMessage(T_FC_SHOP_SELL_ITEM, ERR_PROTOCOL_INVALID_ITEM_COUNT, pMsgSellItem->Amount);
			return RES_BREAK;
		}

		// 2013-05-31 by jhseol,bckim Ƹ ÷ -   Ǹ
#ifdef SC_COLLECTION_ARMOR_JHSEOL_BCKIM	// -   Ǹ
		if ( ITEMKIND_DEFENSE == pItemToSell->Kind && SHAPE_STAT_INIT_LEVEL < pItemToSell->FixedTermShape.nStatLevel )
		{
			m_ArmorCollection.ChangeActivedCount(pItemToSell->ShapeItemNum, FALSE);
		}
#endif
		// end 2013-05-31 by jhseol,bckim Ƹ ÷ -   Ǹ

		///////////////////////////////////////////////////////////////////////////////
		// 2007-07-20 by cmkwon, Ǹž α ߰ - æƮ Ʈ 
		vectENCHANT tmvectEnchant;
		this->PopAllEnchantByItemUID(&tmvectEnchant, pItemToSell->UniqueNumber);

		// send log
		CAtumLogSender::SendLogMessageITEMSellITEM(this,
				pItemToSell, 1,
#ifdef SHOP_PRICES_PER_BUILDING_NPC
				pMoney->CurrentCount + pItemInfo->SellingPrice, &tmvectEnchant
#else
				pMoney->CurrentCount + pItemInfo->Price * CAtumSJ::GetItemSellingPriceRate(), &tmvectEnchant
#endif // SHOP_PRICES_PER_BUILDING_NPC
				);	// 2007-07-20 by cmkwon, Ǹž α ߰ - æƮ Ʈ  ڷ ѱ, //   Ǹ

		m_ItemManager.DeleteItemFromCharacterByUID(pMsgSellItem->ItemUniqueNumber, IUT_SHOP);
#ifdef SHOP_PRICES_PER_BUILDING_NPC
		m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, pItemInfo->SellingPrice, IUT_SHOP);
#else
		m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, pItemInfo->Price * CAtumSJ::GetItemSellingPriceRate(), IUT_SHOP);
#endif // SHOP_PRICES_PER_BUILDING_NPC
	}

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SHOP_REQUEST_REPAIR(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_REQUEST_REPAIR,
									MSG_FC_SHOP_REQUEST_REPAIR, msgRepair);

	if(msgRepair->Count <= 0)
	{
		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_INVALID_ITEM_COUNT);
		return RES_RETURN_FALSE;
	}
	if(NULL == m_pCurrentBuildingNPC)
	{
		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_COMMON_INVALID_BUILDINGKIND);
		return RES_BREAK;
	}
	if (m_pCurrentBuildingNPC->BuildingKind != BUILDINGKIND_REFINERY)
	{// BuildKind üũ
		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NO_SUCH_SHOP);
		return RES_BREAK;
	}
	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

// 2007-10-02 by cmkwon, Ʈ 2н  - 㰡
//	///////////////////////////////////////////////////////////////////////////////
//	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_SHOP_REQUEST_REPAIR û 2н üũ
//	if(FALSE == this->CheckSecondaryPasswordLock())
//	{
//		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_SECPASS_LOCKED);
//		return RES_BREAK;
//	}

	// lock m_mapItemGeneral, MSG_FC_SHOP_REQUEST_REPAIR
	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);

	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if (pMoney == NULL
		|| pMoney->CurrentCount <= 0)
	{
		if(NULL == pMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	int nRequestAmountToRepair		= 0;
	ITEM_GENERAL *pWeaponItemGen	= NULL;
	ITEM *pBulletItem				= NULL;
	switch(msgRepair->DesParam)
	{
	case DES_HP:
		nRequestAmountToRepair = min(msgRepair->Count, (int)m_character.HP - (int)m_character.CurrentHP);
		break;
	case DES_DP:
		nRequestAmountToRepair = min(msgRepair->Count, (int)m_character.DP - (int)m_character.CurrentDP);
		break;
	case DES_EP:
		nRequestAmountToRepair = min(msgRepair->Count, (int)m_character.EP - (int)m_character.CurrentEP);
		break;
	case DES_SP:
		nRequestAmountToRepair = min(msgRepair->Count, (int)m_character.SP - (int)m_character.CurrentSP);
		break;
	case DES_BULLET_01:		// 1 Ѿ
		{
			pWeaponItemGen	= (ITEM_GENERAL*)m_ItemProwOut.ItemNum;
			if(NULL == pWeaponItemGen)
			{
				SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NO_SUCH_DES_PARAM, msgRepair->DesParam);
				return RES_BREAK;
			}
			pBulletItem		= ms_pFieldIOCP->GetBulletItemInfoByCaliber(pWeaponItemGen->ItemInfo->Caliber);
			if(NULL == pBulletItem)
			{
				SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NO_SUCH_BULLET_ITEM, pWeaponItemGen->ItemNum, pWeaponItemGen->ItemInfo->Caliber);
				return RES_BREAK;
			}

			///////////////////////////////////////////////////////////////////////////////
			// 2007-09-06 by cmkwon,    - Ѿ ι ä  ִ
			// 2007-10-06 by cmkwon,    - Ʈ Ѿ ι 
			// 2007-10-15 by cmkwon,   źâ ι Ŀ - Ʒ  Լ ó
			int nMaxChargingCount = pWeaponItemGen->GetMaxBulletCount(m_ItemManager.IsExistPremiumCard());


			nRequestAmountToRepair	= min(msgRepair->Count, nMaxChargingCount);	// 2007-09-06 by cmkwon,    - Ѿ ι ä  ִ
		}
		break;
	case DES_BULLET_02:		// 2 Ѿ
		{
			pWeaponItemGen	= (ITEM_GENERAL*)m_ItemWingOut.ItemNum;
			if(NULL == pWeaponItemGen)
			{
				SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NO_SUCH_DES_PARAM, msgRepair->DesParam);
				return RES_BREAK;
			}
			pBulletItem		= ms_pFieldIOCP->GetBulletItemInfoByCaliber(pWeaponItemGen->ItemInfo->Caliber);
			if(NULL == pBulletItem)
			{
				SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NO_SUCH_BULLET_ITEM, pWeaponItemGen->ItemNum, pWeaponItemGen->ItemInfo->Caliber);
				return RES_BREAK;
			}
			///////////////////////////////////////////////////////////////////////////////
			// 2007-09-06 by cmkwon,    - Ѿ ι ä  ִ
			// 2007-10-06 by cmkwon,    - Ʈ Ѿ ι 
			// 2007-10-15 by cmkwon,   źâ ι Ŀ - Ʒ  Լ ó
			int nMaxChargingCount = pWeaponItemGen->GetMaxBulletCount(m_ItemManager.IsExistPremiumCard());

			nRequestAmountToRepair	= min(msgRepair->Count, nMaxChargingCount);	// 2007-09-06 by cmkwon,    - Ѿ ι ä  ִ
		}
		break;
	default:
		{
			SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NO_SUCH_DES_PARAM, msgRepair->DesParam);
			return RES_BREAK;
		}
	}

	int nRepairCost			= 0;
	int nRealAmountToRepair	= 0;
	if(FALSE == CAtumSJ::GetRepairCost(&nRepairCost, &nRealAmountToRepair, msgRepair->DesParam, nRequestAmountToRepair, pBulletItem))
	{
		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NO_SUCH_DES_PARAM, msgRepair->DesParam);
		return RES_BREAK;
	}

	// 2006-02-08 by cmkwon, º  
	float	fTotalTexPercent	= ms_pFieldIOCP->GetInfluenceTypeDistirbutionTexPercent(m_character.InfluenceType);
	int		nTotalTexSPI		= CAtumSJ::GetItemTexSPI(nRepairCost, fTotalTexPercent);
	nRepairCost					+= nTotalTexSPI;		// 2006-02-08 by cmkwon,  Ѵ.
	
	if(pMoney->CurrentCount < nRepairCost)
	{
		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	switch(msgRepair->DesParam)
	{
	case DES_HP:
		ChangeCurrentHP(nRealAmountToRepair);
		break;
	case DES_DP:
		ChangeCurrentDP(nRealAmountToRepair);
		break;
	case DES_EP:
		ChangeCurrentEP(nRealAmountToRepair);
		break;
	case DES_SP:
		ChangeCurrentSP(nRealAmountToRepair);
		break;
	case DES_BULLET_01:		// 1 Ѿ
	case DES_BULLET_02:		// 2 Ѿ
		this->SupplyBullet(pWeaponItemGen, pBulletItem, nRealAmountToRepair);
		break;
	}
	///////////////////////////////////////////////////////////////////////////////
	// 2006-10-27 by cmkwon, SPI α  ߰
	CAtumLogSender::SendLogMessageITEMSPI(this, pMoney, IUT_SHOP, -nRepairCost, max(0, pMoney->CurrentCount-nRepairCost));

	m_ItemManager.UpdateItemCountByPointer(pMoney, -nRepairCost, IUT_SHOP);		// update money
	igLock.auto_unlock_cancel();		// 2007-10-05 by cmkwon, 

	INIT_MSG_WITH_BUFFER(MSG_FC_SHOP_REQUEST_REPAIR_OK, T_FC_SHOP_REQUEST_REPAIR_OK, pSRepairOK, SendBuf);
	pSRepairOK->DesParam	= msgRepair->DesParam;
	pSRepairOK->Count		= nRealAmountToRepair;
	pSRepairOK->RepairCost	= nRepairCost;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_REQUEST_REPAIR_OK));

	// 2007-08-27 by dhjin, ǰ ó
	this->SetExpediencyFundW(m_character.InfluenceType, nRepairCost);

//	int nRepairCost = CAtumSJ::GetRepairCost(msgRepair->DesParam);	//   
//	if (nRepairCost == 0)
//	{
//		return RES_BREAK;
//	}
//
//	// lock m_mapItemGeneral, MSG_FC_SHOP_REQUEST_REPAIR
//	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
//
//	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
//	if (pMoney == NULL)
//	{
//		return RES_BREAK;
//	}
//	if (pMoney->CurrentCount <= 0)
//	{
//		SendErrorMessage(T_FC_SHOP_REQUEST_REPAIR, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
//		return RES_BREAK;
//	}
//
//	int nAmountToRepair = 0;
//	int nTotalCost = 0;
//
//	switch (msgRepair->DesParam) {
//	case DES_HP:
//		nAmountToRepair = (int)m_character.HP - (int)m_character.CurrentHP;
//		break;
//	case DES_EP:
//		nAmountToRepair = (int)m_character.EP - (int)m_character.CurrentEP;
//		break;
//	case DES_DP:
//		nAmountToRepair = (int)m_character.DP - (int)m_character.CurrentDP;
//		break;
//	default:
//		nAmountToRepair = 0;
//	}
//
//	if (nAmountToRepair <= 0)
//	{
//		return RES_BREAK;
//	}
//
//	nTotalCost = min(nAmountToRepair*nRepairCost, pMoney->CurrentCount);
//	nAmountToRepair = nTotalCost/nRepairCost;
//
//	// update character
//	if (msgRepair->DesParam == DES_HP)
//	{
//		m_character.CurrentHP = min(m_character.CurrentHP+nAmountToRepair, m_character.HP);
//		SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTHP);
//	}
//	else if (msgRepair->DesParam == DES_EP)
//	{
//		m_character.CurrentEP = min(m_character.CurrentEP+nAmountToRepair, m_character.EP);
//		SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTEP);
//	}
//	else if (msgRepair->DesParam == DES_DP)
//	{
//		m_character.CurrentDP = min(m_character.CurrentDP+nAmountToRepair, m_character.DP);
//		SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTDP);
//	}
//	else
//	{
//		return RES_BREAK;
//	}
//
//	// update money
//	m_ItemManager.UpdateItemCountByPointer(pMoney, -nTotalCost, IUT_SHOP);

	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_SHOP_BUY_CASH_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	// 2012-10-16 by bckim, ĳ  Log ߰
	INT64 n64LogSpend = 0;	//	  Ժ 
	// end 2012-10-16 by bckim, ĳ  Log ߰

	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_BUY_CASH_ITEM,
									MSG_FC_SHOP_BUY_CASH_ITEM, pBuyItem);

	if (FALSE == IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
	
	//////////////////////////////////////////////////////////////////////////
	// 2008-08-18 by dhjin, 1  ý ȹ
	if(!this->CheckOneSecondTermSystem())
	{
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_INTERVAL_SYSTEM_SECOND, m_dwMSTermSystem);
		return RES_BREAK;
	}

	if(INVALID_UNIQUE_NUMBER != m_peerTraderCharacterUniqueNumber
		&& 0 != m_peerTraderCharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_ITEM_TRADING);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_SHOP_BUY_CASH_ITEM û 2н üũ
	if(FALSE == this->CheckSecondaryPasswordLock())
	{
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_SECPASS_LOCKED);
		return RES_BREAK;
	}

	if(pBuyItem->Amount <= 0)
	{		
		char szSystemLog[512];
		sprintf(szSystemLog, "[ERROR] Shop Buy Cash Item Error, Char(%15s) ItemNum(%8d) ItemAmoun(%8d)\r\n"
			, m_character.CharacterName, pBuyItem->ItemNum, pBuyItem->Amount);
		g_pFieldGlobal->WriteSystemLog(szSystemLog);
		DBGOUT(szSystemLog);

		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0074);
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, pBuyItem->Amount);
		return RES_RETURN_FALSE;
	}

	CShopInfo* pShopInfo = m_pCurrentFieldMapChannel->m_pFieldMapProject->GetShopInfoByBuildingNPC(pBuyItem->BuildingIndex);
	if (!pShopInfo)
	{
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP);
		return RES_RETURN_FALSE;
	}

// 2006-10-20 by cmkwon,   Ʈ ̳ , Ʒ  
//	map<UINT, SHOP_ITEM>::iterator itr_item	= pShop->m_mapShopItem.find(pBuyItem->ItemNum);
//	if (itr_item == pShop->m_mapShopItem.end())
//	{
//		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP_ITEM, pBuyItem->ItemNum);
//		return RES_RETURN_FALSE;
//	}
//	SHOP_ITEM *pShopItem = &itr_item->second;
	SHOP_ITEM *pShopItem = pShopInfo->GetSHOP_ITEMPtr(pBuyItem->ItemNum);
	if (NULL == pShopItem)
	{
		///////////////////////////////////////////////////////////////////////////////
		// 2007-08-10 by cmkwon, ĳ Ƹ ÷  Ǹ  ߰ - Ʈ 
		ITEM *pTmItemInfo = ms_pFieldIOCP->GetItemInfo(pBuyItem->ItemNum);
		if(pTmItemInfo
			&& ITEMKIND_COLOR_ITEM == pTmItemInfo->Kind 
			&& CASH_ITEMKIND_COLOR_ITEM == pTmItemInfo->SummonMonster)
		{
			// ó ʿ 
		}
		else
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP_ITEM, pBuyItem->ItemNum);
			return RES_RETURN_FALSE;
		}
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2010-01-26 by cmkwon, ĳ  Ǹ ý  - T_FC_SHOP_BUY_CASH_ITEM,  üũ
	int nRemainCountForLimitedEdition = 0;
	if(pShopItem->IsSoldOutShopItem())
	{
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_SOLD_OUT_SHOP_ITEM, pBuyItem->ItemNum, pShopItem->IsSoldOutShopItem());
		return RES_BREAK;
	}

	//  䱸  Ȯ, check: ϴ skill 츸 Ȯ
	ITEM *pItemInfo = ms_pFieldIOCP->GetItemInfo(pBuyItem->ItemNum);
	if (pItemInfo == NULL
		|| FALSE == COMPARE_BIT_FLAG(pItemInfo->ItemAttribute, ITEM_ATTR_CASH_ITEM))
	{
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM, pBuyItem->ItemNum);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-11-13 by cmkwon, ϱ  ߰ - üũ ߰
	if(IS_VALID_UNIQUE_NUMBER(pBuyItem->GiveTargetCharacterUID))
	{
		if(m_giveTargetCharacter.CharacterUID0 != pBuyItem->GiveTargetCharacterUID)
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_INVALID_PEER_CHARACTER, pBuyItem->ItemNum);
			return RES_BREAK;
		}
		if(m_giveTargetCharacter.BuyItemNum != pBuyItem->ItemNum)
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_REQ_ITEM_NOT_MATCHED, pBuyItem->ItemNum);
			return RES_BREAK;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2009-10-08 by cmkwon, ʵâ ĳ  ý  - T_FC_SHOP_BUY_CASH_ITEM, ʵâ  ϱ Ұ
		if(COMPARE_BIT_FLAG(pItemInfo->ItemAttribute, ITEM_ATTR_CASH_ITEM_PREMIUM_CARD)		// 2009-10-08 by cmkwon, ̾  ϱ Ұ
			|| pItemInfo->IsExistDesParam(DES_FIELD_STORE))
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_CANNOT_BUY_ITEM, pBuyItem->ItemNum);
			return RES_BREAK;
		}

#ifdef S_CANNOT_DO_GIFT_UNDER_LEVEL_BCKIM	// 2013-07-08 by bckim, ĳٿû 70 ̸ ϱ Ұ
		if( 70 > this->m_character.Level )
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_CANNOT_DO_GIFT_UNDER_LEVEL, this->m_character.CharacterUniqueNumber, this->m_character.Level);
			return RES_BREAK;
		}
#endif

		// 2012-11-12 by hskim, ĳ ϱ  
#ifdef S_DELETE_BUY_CASH_GIVE
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_CANNOT_BUY_ITEM, pBuyItem->ItemNum);
		return RES_BREAK;
#endif
		// 2012-11-12 by hskim, ĳ ϱ  
	}


	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);									// lock m_mapItemGeneral, MSG_FC_SHOP_BUY_ITEM

	///////////////////////////////////////////////////////////////////////////////
	//  MGameMoney ´
	int nTotalMoney	= 0;
	int nMCash		= 0;
	int nGiftCard	= 0;
	Err_t nRetedErr = CashItemMoneyPay(&nTotalMoney, &nMCash, &nGiftCard);
	if(ERR_NO_ERROR != nRetedErr)
	{
		SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, nRetedErr);
		return RES_BREAK;
	}

// 2008-10-20 by cmkwon,   üũ ItemAttribute  ó - 
//	if(CASH_ITEMKIND_PREMIUM_CARD == pItemInfo->SummonMonster)
	if(COMPARE_BIT_FLAG(pItemInfo->ItemAttribute, ITEM_ATTR_CASH_ITEM_PREMIUM_CARD))
	{// ̾ ī ó

// 2006-06-14 by cmkwon,  ʿ  - ̾ ī尡  ʰ ִ
// 		if(0 != m_ItemPet.ItemNum
// 			&& (m_ItemPet.IsExistDesParam(DES_DROP_EXP) || m_ItemPet.IsExistDesParam(DES_DROP_SPI) || m_ItemPet.IsExistDesParam(DES_DROP_ITEM)))
// 		{// 2006-03-30 by cmkwon, Ư ð ׼   ̾ī  Ұ 
// 			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_CANNOT_BUY_PREMIUM_CARD_USING_SPEC_ITEM);
// 			return RES_BREAK;
// 		}
#ifdef SHOP_PRICES_PER_BUILDING_NPC
		INT64 n64SumOfPrice	= pShopItem->Price * (pBuyItem->Amount/pItemInfo->MinTradeQuantity);
#else
		INT64 n64SumOfPrice = pItemInfo->CashPrice * (pBuyItem->Amount / pItemInfo->MinTradeQuantity);
#endif // SHOP_PRICES_PER_BUILDING_NPC

		
		// 2013-04-11 by jhseol, ĳ 1  n  ϴ ׼
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "   [Check] CFieldIOCPSocket::Process_FC_SHOP_BUY_CASH_ITEM, #1 _ AUID(%d) CUID(%d) ItemNum(%d) [TotalCash(%d) = MainCash(%d) + FreeCash(%d)] [TotalPrice(%I64d) = (BuyAmount(%d) / MinTradeQuantity(%d)) * ItemPrice(%d)]\r\n"
			, m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, pItemInfo->ItemNum
			, nTotalMoney, nMCash, nGiftCard
			, n64SumOfPrice, pBuyItem->Amount, pItemInfo->MinTradeQuantity
#ifdef SHOP_PRICES_PER_BUILDING_NPC
			, pShopItem->Price
#else
			, pItemInfo->CashPrice
#endif
			);
		// end 2013-04-11 by jhseol, ĳ 1  n  ϴ ׼
		if (n64SumOfPrice > nTotalMoney)	// 2006-10-24 by cmkwon, nTotalMoney Ѵ.
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY, n64SumOfPrice, nTotalMoney);
			return RES_BREAK;
		}

		///////////////////////////////////////////////////////////////////////////////
		// ̾  ԰ üũ
		nRetedErr = this->m_ItemManager.CashInsertPremiumCard(pItemInfo, TRUE);
		if(ERR_NO_ERROR != nRetedErr)
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, nRetedErr, 0);
			return RES_BREAK;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2010-01-26 by cmkwon, ĳ  Ǹ ý  - T_FC_SHOP_BUY_CASH_ITEM, Ǹ   üũ
		if(pShopItem->IsLimitedEditionShopItem())
		{
			BOOL bSuccessBuy = m_ItemManager.CheckBuyLimitedEditionShopItem(&nRemainCountForLimitedEdition, pShopItem->ItemNum);
			pShopItem->RemainCountForLimitedEdition	= nRemainCountForLimitedEdition;
			
			if(FALSE == bSuccessBuy)
			{
				SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_SOLD_OUT_SHOP_ITEM, pBuyItem->ItemNum, pShopItem->IsSoldOutShopItem());
				return RES_BREAK;
			}
		}

		///////////////////////////////////////////////////////////////////////////////
		//  ó
		// 2008-12-18 by cmkwon, Ϻ Arario ܺ,   ϱ - Ʒ  
		//nRetedErr = CashItemMoneyPay(&nTotalMoney, &nMCash, &nGiftCard, pItemInfo, n64SumOfPrice);
#ifdef SHOP_PRICES_PER_BUILDING_NPC
		nRetedErr = CashItemMoneyPay(&nTotalMoney, &nMCash, &nGiftCard, pItemInfo, pShopItem->Price, n64SumOfPrice, 0, nTotalMoney);	// 2008-12-18 by cmkwon, Ϻ Arario ܺ,   ϱ - nTotalMoney .
#else
		nRetedErr = CashItemMoneyPay(&nTotalMoney, &nMCash, &nGiftCard, pItemInfo, n64SumOfPrice, 0, nTotalMoney);	// 2008-12-18 by cmkwon, Ϻ Arario ܺ,   ϱ - nTotalMoney .
#endif // SHOP_PRICES_PER_BUILDING_NPC

		
		if(ERR_NO_ERROR != nRetedErr)
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, nRetedErr);
			return RES_BREAK;
		}
		
		///////////////////////////////////////////////////////////////////////////////
		// ̾  ߰
		nRetedErr = this->m_ItemManager.CashInsertPremiumCard(pItemInfo);
		if(ERR_NO_ERROR != nRetedErr)
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, nRetedErr, 1);
			return RES_BREAK;
		}

	}
	// 2013-05-22 by jhseol, ҽ - ּ
	else
	{// Ϲ ȭ  ó

		///////////////////////////////////////////////////////////////////////////////
		// 2009-09-23 by cmkwon, ʵâ ĳ   - T_FC_SHOP_BUY_CASH_ITEM, ʵâ ̿  Űɿ  üũ
		if(pItemInfo->IsExistDesParam(DES_FIELD_STORE)
			&& this->m_ItemManager.IsUseableFieldStore())
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_CANNOT_BUY_ITEM, pItemInfo->ItemNum, this->m_ItemManager.IsUseableFieldStore());
			return RES_BREAK;
		}

		if(FALSE == IS_VALID_UNIQUE_NUMBER(pBuyItem->GiveTargetCharacterUID))
		{// 2007-11-14 by cmkwon, ڽ    
			// ִ  Ȯ
			// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
			if(IS_COUNTABLE_ITEM(pItemInfo->Kind))
			{// īͺ  κ丮   ִ밳 Ȯ

				ITEM_GENERAL *pItemGeneralInven = m_ItemManager.GetFirstItemGeneralByItemNum(pItemInfo->ItemNum);
				if (NULL == pItemGeneralInven
					&& m_ItemManager.GetInventoryItemCounts() >= m_ItemManager.GetMaxInventoryCount())
				{
					SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, m_ItemManager.GetMaxInventoryCount());
					return RES_BREAK;
				}
			}
			else if(IS_GENERAL_ITEM(pItemInfo->Kind))
			{// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - Ʒ  üũ 
				
				pBuyItem->Amount = min(pBuyItem->Amount, MAX_ITEM_COUNTS_FOR_BUY);		// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - ִ    .

				if(m_ItemManager.GetInventoryItemCounts() + pBuyItem->Amount > m_ItemManager.GetMaxInventoryCount())
				{// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ -     ؼ üũ Ѵ.
					SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, m_ItemManager.GetMaxInventoryCount());
					return RES_BREAK;
				}
			}
// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ -    .
//			else if (m_ItemManager.GetInventoryItemCounts() >= CAtumSJ::GetMaxInventorySize(m_ItemManager.IsExistPremiumCard()))
//			{// īͺ ƴ  ִ  Ȯ
//
//				SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, CAtumSJ::GetMaxInventorySize(m_ItemManager.IsExistPremiumCard()));
//				return RES_BREAK;
//			}

			///////////////////////////////////////////////////////////////////////////////
			// 2005-09-13 by cmkwon, īͺ   ִ(20) īƮ üũ
			if(IS_COUNTABLE_ITEM(pItemInfo->Kind))
			{
				INT64 tmCurrentCount = pBuyItem->Amount;

				ITEM_GENERAL *pMyItem = m_ItemManager.GetFirstItemGeneralByItemNum(pBuyItem->ItemNum);
				if(pMyItem){				tmCurrentCount += pMyItem->CurrentCount;}
				if(tmCurrentCount > MAX_ITEM_COUNTS)
				{
					SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER, 0, 0);
					return RES_BREAK;			
				}
				else if(tmCurrentCount >= MAX_NOTIFY_ITEM_COUNTS)
				{
					SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_NOTIFY_MAX_ITEM_COUNTS_OVER);
				}
			}


			if (IS_GENERAL_ITEM(pItemInfo->Kind) 
				&& FALSE == IS_COUNTABLE_ITEM(pItemInfo->Kind))
			{
				if(timeGetTime()-m_dwLastTickInsertingStoreItem > 5000)
				{
					m_nInsertingStoreItemCounts = 0;
				}

				// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - 
				//if(m_ItemManager.GetInventoryItemCounts() + m_nInsertingStoreItemCounts >= CAtumSJ::GetMaxInventorySize(m_ItemManager.IsExistPremiumCard()))	// 2006-10-25 by cmkwon,  
				// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
				if(m_ItemManager.GetInventoryItemCounts() + m_nInsertingStoreItemCounts + pBuyItem->Amount > m_ItemManager.GetMaxInventoryCount())	// 2006-10-25 by cmkwon,  
				{// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ -     ؼ üũ Ѵ.
					SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, 1);
					return RES_BREAK;
				}		
			}
		}
		

		if (COMPARE_BIT_FLAG(pItemInfo->ItemAttribute, ITEM_ATTR_NO_TRANSFER|ITEM_ATTR_KILL_MARK_ITEM))
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
			return RES_BREAK;
		}
// 2005-09-27 by cmkwon, ԰  ۸ ϵ 
//		//  Ȯ
//		if (pItemInfo->Weight > 0.0f)
//		{
//			float fItemWeight = CAtumSJ::GetItemWeight(pItemInfo, pBuyItem->Amount);
//			if (GetCurrentLoadagePercentage(fItemWeight) > 1.0f)
//			{
//				SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_ITEM_OVER_WEIGHT,
//									(INT)m_ItemManager.GetCurrentCarryingItemWeight()+fItemWeight,
//									(INT)CAtumSJ::GetTransport(&m_character));
//				return RES_BREAK;
//			}
//		}

		// ּ ŷ  Ȯ: MinTradeQuantity θ    
		if ( pBuyItem->Amount%pItemInfo->MinTradeQuantity != 0)
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_MIN_TRADE_QUANTITY_ERROR, pItemInfo->MinTradeQuantity);
			return RES_BREAK;
		}

		// ȭ ۿ ų 
		
		if (nTotalMoney <= 0)
		{// MGameMoney 
			
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
			return RES_BREAK;
		}

#ifdef SHOP_PRICES_PER_BUILDING_NPC
		INT64 n64SumOfPrice	= pShopItem->Price * (pBuyItem->Amount/pItemInfo->MinTradeQuantity);
#else
		INT64 n64SumOfPrice = pItemInfo->CashPrice * (pBuyItem->Amount / pItemInfo->MinTradeQuantity);
#endif // SHOP_PRICES_PER_BUILDING_NPC

		
		// 2013-04-11 by jhseol, ĳ 1  n  ϴ ׼
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "   [Check] CFieldIOCPSocket::Process_FC_SHOP_BUY_CASH_ITEM, #2 _ AUID(%d) CUID(%d) ItemNum(%d) [TotalCash(%d) = MainCash(%d) + FreeCash(%d)] [TotalPrice(%I64d) = (BuyAmount(%d) / MinTradeQuantity(%d)) * ItemPrice(%d)]\r\n"
			, m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, pItemInfo->ItemNum
			, nTotalMoney, nMCash, nGiftCard
			, n64SumOfPrice, pBuyItem->Amount, pItemInfo->MinTradeQuantity
#ifdef SHOP_PRICES_PER_BUILDING_NPC
			, pShopItem->Price
#else
			, pItemInfo->CashPrice
#endif // SHOP_PRICES_PER_BUILDING_NPC
			);
		// end 2013-04-11 by jhseol, ĳ 1  n  ϴ ׼
		// 2012-10-16 by bckim, ĳ  Log ߰
		n64LogSpend = n64SumOfPrice;		//	  Ժ 
		// end 2012-10-16 by bckim, ĳ  Log ߰
		if (n64SumOfPrice > nTotalMoney)
		{
			// error
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
			return RES_BREAK;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2010-01-26 by cmkwon, ĳ  Ǹ ý  - T_FC_SHOP_BUY_CASH_ITEM, Ǹ   üũ
		if(pShopItem->IsLimitedEditionShopItem())
		{
			BOOL bSuccessBuy = m_ItemManager.CheckBuyLimitedEditionShopItem(&nRemainCountForLimitedEdition, pShopItem->ItemNum);
			pShopItem->RemainCountForLimitedEdition	= nRemainCountForLimitedEdition;

			if(FALSE == bSuccessBuy)
			{
				SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_SOLD_OUT_SHOP_ITEM, pBuyItem->ItemNum, pShopItem->IsSoldOutShopItem());
				return RES_BREAK;
			}
		}


		///////////////////////////////////////////////////////////////////////////////
		//  ó
		// 2007-12-04 by cmkwon,  ϱ ̺귯  - CashItemMoneyPay()  ߰
		// 2008-12-18 by cmkwon, Ϻ Arario ܺ,   ϱ - Ʒ  
		//nRetedErr = CashItemMoneyPay(&nTotalMoney, &nMCash, &nGiftCard, pItemInfo, n64SumOfPrice, pBuyItem->GiveTargetCharacterUID);
		// 2012-09-12 by jhseol,  BPSoft ý -  ĳθ 
#ifdef S_BPSOFTBILLING_JHSEOL
		if( NULL != pBuyItem->GiveTargetCharacterUID )
		{
			if( nMCash < pItemInfo->CashPrice )
			{
				SendString128(STRING_128_USER_NOTICE, "\\yĳ Ͽ   ϴ.\\y");
				SendString128(STRING_128_USER_NOTICE, "\\yĳ ܾ[%10d]\\y", nMCash);
				SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, ERR_DB_NOT_ENOUGH_MONEY);
				return RES_BREAK;
			}
		}
#endif
		// end 2012-09-12 by jhseol,  BPSoft ý -  ĳθ 
#ifdef SHOP_PRICES_PER_BUILDING_NPC
		nRetedErr = CashItemMoneyPay(&nTotalMoney, &nMCash, &nGiftCard, pItemInfo, n64SumOfPrice, pBuyItem->GiveTargetCharacterUID, nTotalMoney);	// 2008-12-18 by cmkwon, Ϻ Arario ܺ,   ϱ - nTotalMoney 
#else
		nRetedErr = CashItemMoneyPay(&nTotalMoney, &nMCash, &nGiftCard, pItemInfo, pShopItem->Price, n64SumOfPrice, pBuyItem->GiveTargetCharacterUID, nTotalMoney);	// 2008-12-18 by cmkwon, Ϻ Arario ܺ,   ϱ - nTotalMoney 
#endif // SHOP_PRICES_PER_BUILDING_NPC

		if(ERR_NO_ERROR != nRetedErr)
		{
			SendErrorMessage(T_FC_SHOP_BUY_CASH_ITEM, nRetedErr);
			return RES_BREAK;
		}

		if(FALSE == IS_VALID_UNIQUE_NUMBER(pBuyItem->GiveTargetCharacterUID))
		{// 2007-11-14 by cmkwon, ڽ    
			///////////////////////////////////////////////////////////////////////////////
			//  
			m_ItemManager.InsertItemBaseByItemNum(pItemInfo->ItemNum, pBuyItem->Amount, IUT_SHOP);
		}
		else
		{
			///////////////////////////////////////////////////////////////////////////////
			// ش ĳ â  ߰
			this->GiveItem(pItemInfo, pBuyItem->Amount, IUT_SHOP);
		}
	}

	// send log
	ITEM_GENERAL tmpItemForLog(pItemInfo);
	tmpItemForLog.UniqueNumber			= 0;	// 2007-11-28 by cmkwon,  ⺻ 0 , // 2007-11-13 by cmkwon, ϱ  ߰ - ڽ ̸ 0, ϱ ̸ 1
	tmpItemForLog.AccountUniqueNumber	= m_character.AccountUniqueNumber;
	tmpItemForLog.Possess				= m_character.CharacterUniqueNumber;
	tmpItemForLog.Wear					= WEAR_NOT_ATTACHED;
	tmpItemForLog.CurrentCount			= pBuyItem->Amount;
// 2009-08-25 by cmkwon,  ʴ ʵ (td_Store.ScarcityNumber) - 
//	tmpItemForLog.ScarcityNumber		= 0;
	tmpItemForLog.ItemWindowIndex		= POS_INVALID_POSITION;
	tmpItemForLog.PrefixCodeNum			= 0;
	tmpItemForLog.SuffixCodeNum			= 0;
	tmpItemForLog.NumOfEnchants			= 0;

	// 2013-05-30 by jhseol, GLog ý  - ĳ  GLog ߰
#ifdef S_GLOG_3ND_KHK	// - ĳ  GLog ߰
	m_ItemManager.SetGLogData(GLOG_IL_LT_CASHSHOP_BUY,&tmpItemForLog,m_character.Level);
#endif
	// end 2013-05-30 by jhseol, GLog ý  - ĳ  GLog ߰
	
	// 2010-01-26 by cmkwon, ĳ  Ǹ ý  - 
	CAtumLogSender::SendLogMessageITEMBuyITEM(this, &tmpItemForLog, pBuyItem->Amount, nTotalMoney, FALSE, nRemainCountForLimitedEdition);

	// 2012-10-16 by bckim, ĳ  Log ߰
	//enum ITEM_BUY_CASH_PRICE_TYPE{BUY_TYPE_SPI=1,BUY_TYPE_WARPOINT,BUY_TYPE_CASH,BUY_TYPE_INFINITY};
	CAtumLogSender::SendLogMessageITEMBuyCashPrice(this, &tmpItemForLog, pBuyItem->Amount, n64LogSpend, FALSE, BUY_TYPE_CASH, NULL); // CASH TYPE : 3
	// end 2012-10-16 by bckim, ĳ  Log ߰

	if(IS_VALID_UNIQUE_NUMBER(pBuyItem->GiveTargetCharacterUID))
	{
		// 2007-11-13 by cmkwon, ϱ  ߰ - ϱ α ߰ϱ
		CAtumLogSender::SendLogMessageITEMGiftSend(this, &tmpItemForLog, pBuyItem->Amount, &m_giveTargetCharacter);
		// 2007-11-27 by cmkwon, ϱ α  - CAtumLogSender::SendLogMessageITEMGiftRecv() Լ  , Ʒ  
		// 2012-08-30 by jhseol, Ǯα 
#ifdef S_FULL_LOG_JHSEOL
		// 2012-08-30 by jhseol, Ǯα  -  Լ  ּ  .
		//CAtumLogSender::SendLogMessageITEMGiftRecv(&m_giveTargetCharacter, &tmpItemForLog, pBuyItem->Amount, &m_character);
#endif	//#ifdef S_FULL_LOG_JHSEOL
		// end 2012-08-30 by jhseol, Ǯα 
		CAtumLogSender::SendLogMessageITEMGiftRecv(m_giveTargetCharacter.CharacterUID0, &tmpItemForLog, pBuyItem->Amount, m_character.CharacterUniqueNumber, m_character.CharacterName);
	}
	
	igLock.auto_unlock_cancel();

	// 2007-11-13 by cmkwon, ϱ  ߰ - ޽ ٸ ó
	if(FALSE == IS_VALID_UNIQUE_NUMBER(pBuyItem->GiveTargetCharacterUID))
	{
		///////////////////////////////////////////////////////////////////////////////
		//   text 
		SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0075);
		SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0076, pItemInfo->ItemName, pBuyItem->Amount);
	}
	else
	{
		///////////////////////////////////////////////////////////////////////////////
		//   text 
		SendString128(STRING_128_USER_NOTICE, STRMSG_071115_0001, m_giveTargetCharacter.CharacterName0, pItemInfo->ItemName);
		SendString128(STRING_128_USER_NOTICE, STRMSG_071115_0002, pItemInfo->ItemName, pBuyItem->Amount);

// 2007-11-28 by cmkwon, ý  - Ʒ  ýý ó
//		CFieldIOCPSocket *pTargetFISoc = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(pBuyItem->GiveTargetCharacterUID);
//		if(pTargetFISoc
//			&& pTargetFISoc->IsValidCharacter(FALSE))
//		{// 2007-11-15 by cmkwon,    ˸
//			pTargetFISoc->SendString128(STRING_128_USER_NOTICE, STRMSG_071115_0003, m_character.CharacterName, m_giveTargetCharacter.CharacterName0, pItemInfo->ItemName);
//		}
		SNOTIFY_MSG notifyMsg;		MEMSET_ZERO(&notifyMsg, sizeof(notifyMsg));
		notifyMsg.CharacterUID			= pBuyItem->GiveTargetCharacterUID;
		notifyMsg.NotifyMsgType			= NOTIFY_MSG_TYPE_RECV_GIFT;
		_snprintf(notifyMsg.NotifyMsgString, SIZE_MAX_NOTIFY_MSG_STRING, STRMSG_071128_0001, m_character.CharacterName, pItemInfo->ItemName, pBuyItem->Amount);
		notifyMsg.SenderCharacterUID	= m_character.CharacterUniqueNumber;
		STRNCPY_MEMSET(notifyMsg.SenderCharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
		// 2007-12-20 by cmkwon, ý   - CFieldIOCPSocket::InsertNotifyMsg() Լ 
		//CFieldIOCPSocket::InsertNotifyMsg(&notifyMsg, this);
		CFieldIOCPSocket::InsertNotifyMsg2Anyone(&notifyMsg, this);
	}

	///////////////////////////////////////////////////////////////////////////////
	//  MGameMoney 
	INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK, T_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK, pSOKt, SendBuf);
	pSOKt->nMCash			= nMCash;
	pSOKt->nGiftCard		= nGiftCard;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK));

	///////////////////////////////////////////////////////////////////////////////
	// 2007-11-13 by cmkwon, ϱ  ߰ - ĳ   ޽ 
	INIT_MSG(MSG_FC_SHOP_BUY_CASH_ITEM_OK, T_FC_SHOP_BUY_CASH_ITEM_OK, pSBuyOK, SendBuf);
	pSBuyOK->ItemNum		= pBuyItem->ItemNum;
	pSBuyOK->Amount			= pBuyItem->Amount;
	if(IS_VALID_UNIQUE_NUMBER(pBuyItem->GiveTargetCharacterUID))
	{
		pSBuyOK->GiveTargetCharacterUID	= m_giveTargetCharacter.CharacterUID0;
		STRNCPY_MEMSET(pSBuyOK->GiveTargetCharacterName, m_giveTargetCharacter.CharacterName0, SIZE_MAX_CHARACTER_NAME);
	}
	pSBuyOK->RemainCountForLimitedEdition	= pShopItem->RemainCountForLimitedEdition;		// 2010-01-26 by cmkwon, ĳ  Ǹ ý  - 
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_BUY_CASH_ITEM_OK));

	MEMSET_ZERO(&m_giveTargetCharacter, sizeof(m_giveTargetCharacter));				// 2007-11-13 by cmkwon, ϱ  ߰ - ʱȭ

	// 2013-03-29 by jhseol,  ̺Ʈ - ſ ù  
#ifdef S_MONTHL_CASH_BUY_GIFT_JHSEOL
	vectItemEventInfo		vectItemEventInfo1;
	vectItemEventInfo1.clear();
	vectItemEventInfo1.reserve(20);
	ms_pFieldIOCP->m_pGiveItemManager->GetActEventItemFirstPurchase(&vectItemEventInfo1, m_ItemManager.IsExistPremiumCard(), m_bIsPCBangClient, m_character.InfluenceType, m_character.UnitKind, m_atAccountLastBuyDate, m_atCharacterLastBuyDate);
	for (int i=0; i < vectItemEventInfo1.size(); i++)
	{
		// 2013-03-29 by jhseol,  ̺Ʈ - Ÿ ߰ 
		if ( FALSE == ms_pFieldIOCP->ItemEventSubTypeCheck(m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, vectItemEventInfo1[i]) )
		{
			continue;
		}
		// end 2013-03-29 by jhseol,  ̺Ʈ - Ÿ ߰ 

		char tmpAccount[SIZE_MAX_SQL_DATETIME_STRING] = {0,};
		m_atAccountLastBuyDate.GetSQLDateTimeString(tmpAccount, SIZE_MAX_SQL_DATETIME_STRING);
		char tmpCharacter[SIZE_MAX_SQL_DATETIME_STRING] = {0,};
		m_atCharacterLastBuyDate.GetSQLDateTimeString(tmpCharacter, SIZE_MAX_SQL_DATETIME_STRING);
		char EventStartTime[SIZE_MAX_SQL_DATETIME_STRING] = {0,};
		vectItemEventInfo1[i].StartTime.GetSQLDateTimeString(EventStartTime, SIZE_MAX_SQL_DATETIME_STRING);
		char EventEndTime[SIZE_MAX_SQL_DATETIME_STRING] = {0,};
		vectItemEventInfo1[i].EndTime.GetSQLDateTimeString(EventEndTime, SIZE_MAX_SQL_DATETIME_STRING);
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[S_MONTHL_CASH_BUY_GIFT_JHSEOL][Notify] CFieldIOCPSocket::Process_FC_SHOP_BUY_CASH_ITEM, AUID(%8d) CUID(%8d) A_Date(%s) C_Date(%s), Event ID(%5d) Time(%s ~ %s)\r\n"
			, m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, tmpAccount, tmpCharacter, vectItemEventInfo1[i].ItemEventUID, EventStartTime, EventEndTime);
		QPARAM_CHECK_EVENTITEM *pQParam = new QPARAM_CHECK_EVENTITEM;
		pQParam->AccountUID		= m_character.AccountUniqueNumber;
		pQParam->ItemEventUID	= vectItemEventInfo1[i].ItemEventUID;
		pQParam->ItemEventType  = vectItemEventInfo1[i].ItemEventType;
		pQParam->ItemNum		= vectItemEventInfo1[i].ItemNum;
		pQParam->Count			= vectItemEventInfo1[i].Count;
		pQParam->PrefixCodeNum	= vectItemEventInfo1[i].PrefixCodeNum;
		pQParam->SuffixCodeNum	= vectItemEventInfo1[i].SuffixCodeNum;
		pQParam->CharacterUID	= (FALSE == vectItemEventInfo1[i].CheckWithCharacterUID) ? 0 : m_character.CharacterUniqueNumber;	// 2009-11-19 by cmkwon,  ̺Ʈ Account/Character üũ  ߰ - 
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_CheckEventItem, this, m_character.AccountUniqueNumber, pQParam);
	}

	m_atCharacterLastBuyDate.SetCurrentDateTime(FALSE);
	m_atAccountLastBuyDate.SetCurrentDateTime(FALSE);
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_InsertCashBuyDate, this, m_character.AccountUniqueNumber, NULL);
#endif
	// end 2013-03-29 by jhseol,  ̺Ʈ - ſ ù  

	return RES_RETURN_TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_SHOP_BUY_COLOR_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-06 ~ 2005-12-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_SHOP_BUY_COLOR_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_BUY_COLOR_ITEM,
									MSG_FC_SHOP_BUY_COLOR_ITEM, pBuyColorItem);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2008-08-18 by dhjin, 1  ý ȹ
	if(!this->CheckOneSecondTermSystem())
	{
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_INTERVAL_SYSTEM_SECOND, m_dwMSTermSystem);
		return RES_BREAK;
	}
	
	if(INVALID_UNIQUE_NUMBER != m_peerTraderCharacterUniqueNumber
		&& 0 != m_peerTraderCharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_ITEM_TRADING);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_SHOP_BUY_COLOR_ITEM û 2н üũ
	if(FALSE == this->CheckSecondaryPasswordLock())
	{
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_SECPASS_LOCKED);
		return RES_BREAK;
	}

	ITEM *pColorItem = ms_pFieldIOCP->GetItemInfo(pBuyColorItem->ItemNum);
	if(NULL == pColorItem)
	{// ItemNum üũ
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_ITEM_KIND_NOT_MATCHED);
		return RES_BREAK;
	}

	if (0 != pColorItem->ReqMinLevel 
		&& pColorItem->ReqMinLevel > m_character.Level)
	{// ּ ʿ  üũ
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED);
		return RES_BREAK;
	}
	if (0 != pColorItem->ReqMaxLevel 
		&& pColorItem->ReqMaxLevel < m_character.Level)	
	{// ִ ʿ  üũ
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED);
		return RES_BREAK;
	}
	
	if(NULL == m_pCurrentBuildingNPC)
	{
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_COMMON_INVALID_BUILDINGKIND);
		return RES_BREAK;
	}
	if (m_pCurrentBuildingNPC->BuildingKind != BUILDINGKIND_TUNING_COLOR)
	{// BuildKind üũ
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_BUILDING_KIND_NOT_MATCHED);
		return RES_BREAK;
	}

	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);	// lock m_mapItemGeneral 

	ITEM_GENERAL *pArmorItemGen = GetAttachItemGeneralByPosition(POS_CENTER);
	if(NULL == pArmorItemGen
		|| ITEMKIND_DEFENSE != pArmorItemGen->Kind)
	{// Ƹ  üũ
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_INVALID_ARMOR_ITEM);
		return RES_BREAK;
	}
#ifndef _REWORKED_COLORSHOP
	if(pArmorItemGen->ItemInfo->SourceIndex != COLORItemNum_TO_ArmorSourceIndex(pColorItem->ItemNum))
	{// ItemNum üũ
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_INVALID_ITEMNUM, 1);
		return RES_BREAK;
	}
#endif

#ifdef SHOP_PRICES_PER_BUILDING_NPC
	// Get the Shop Information
	CShopInfo* pShopInfo = m_pCurrentFieldMapChannel->m_pFieldMapProject->GetShopInfoByBuildingNPC(m_pCurrentBuildingNPC->BuildingIndex);
	if (!pShopInfo)
	{
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP);
		return RES_RETURN_FALSE;
	}

	// Get the Shop Item Info
	SHOP_ITEM *pShopItem = pShopInfo->GetSHOP_ITEMPtr(pBuyColorItem->ItemNum);
	if (!pShopItem)
	{
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP_ITEM, pBuyColorItem->ItemNum);
#ifndef _REWORKED_COLORSHOP
		return RES_RETURN_FALSE;
#else
		pShopItem = new SHOP_ITEM;
		pShopItem->Price = pColorItem->ItemNum == COLOR_RESET_ITEMNUM ? 10000 : DEFAULT_COLOR_PRICE;
#endif
	}

	int nColorCost = pShopItem->Price;
#else	// SHOP_PRICES_PER_BUILDING_NPC
	int nColorCost = pColorItem->Price;
#endif // SHOP_PRICES_PER_BUILDING_NPC

#ifdef _REWORKED_COLORSHOP
	if(nColorCost > this->m_character.WarPoint)
	{
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY, m_character.WarPoint, nColorCost);
		return RES_BREAK;
	}
#else
	// 2006-02-08 by cmkwon, º  
	float	fTotalTexPercent	= ms_pFieldIOCP->GetInfluenceTypeDistirbutionTexPercent(m_character.InfluenceType);
	int		nTotalTexSPI		= CAtumSJ::GetItemTexSPI(nColorCost, fTotalTexPercent);
	nColorCost					+= nTotalTexSPI;		// 2006-02-08 by cmkwon,  Ѵ.

	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if (pMoney == NULL
		|| pMoney->CurrentCount < nColorCost)
	{
		if(NULL == pMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
		SendErrorMessage(T_FC_SHOP_BUY_COLOR_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}
#endif

	///////////////////////////////////////////////////////////////////////////////
	// 2005-12-06 by cmkwon,   SPI  ó
	pArmorItemGen->ColorCode	= pColorItem->ItemNum;
	this->UpdateItemRenderInfo(POS_CENTER, TRUE);
#ifdef _REWORKED_COLORSHOP
	//Substract the cost from warpoints
	this->m_character.WarPoint -= nColorCost;
	//Add the count to statistics
	if (NULL != this->ms_pFieldIOCP->m_pStatisticsManager)
	{
		this->ms_pFieldIOCP->m_pStatisticsManager->Sub(STATISTICS_WAR_POINT, nColorCost);
	}

	QPARAM_UPDATE_WARPOINT *pQparam = new QPARAM_UPDATE_WARPOINT;
	pQparam->CharacterUID = this->m_character.CharacterUniqueNumber;
	pQparam->AccountUID = this->m_character.AccountUniqueNumber;
	pQparam->TotalWarPoint = this->m_character.WarPoint;
	pQparam->CumulativeWarPoint = this->m_character.CumulativeWarPoint;
	this->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateWarPoint, this, this->m_character.AccountUniqueNumber, pQparam);

	//Reload Warpoint
	INIT_MSG_WITH_BUFFER(MSG_FC_SHOP_BUY_WARPOINT_ITEM_OK, T_FC_SHOP_BUY_WARPOINT_ITEM_OK, pMsg, WPSendBuf);
	pMsg->PayWarPoint				= nColorCost;
	pMsg->WarPoint = this->m_character.WarPoint;
	this->SendAddData(WPSendBuf, MSG_SIZE(MSG_FC_SHOP_BUY_WARPOINT_ITEM_OK));
#else
	m_ItemManager.UpdateItemCountByPointer(pMoney, -nColorCost, IUT_SHOP);		// update money
#endif

	///////////////////////////////////////////////////////////////////////////////
	// 2005-12-06 by cmkwon, DB Update
	QPARAM_STORE_UPDATE_COLORCODE *pQParam = new QPARAM_STORE_UPDATE_COLORCODE;
	pQParam->ItemUniqueNumber	= pArmorItemGen->UniqueNumber;
#ifdef _REWORKED_COLORSHOP
	//Reset the Color with hardcoded item
	if (pBuyColorItem->ItemNum == COLOR_RESET_ITEMNUM)
	{
		pQParam->ColorCode = 0;
		pArmorItemGen->ColorCode = 0;
	}
	else
	{
#endif
		pQParam->ColorCode = pArmorItemGen->ColorCode;
#ifdef _REWORKED_COLORSHOP
	}
#endif
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_StoreUpdateColorCode, this, m_character.AccountUniqueNumber, pQParam);

	///////////////////////////////////////////////////////////////////////////////
	// 2005-12-06 by cmkwon, Ŭ̾Ʈ 
	INIT_MSG_WITH_BUFFER(MSG_FC_SHOP_BUY_COLOR_ITEM_OK, T_FC_SHOP_BUY_COLOR_ITEM_OK, pSMsg, SendBuf);
	pSMsg->ItemUID64			= pArmorItemGen->UniqueNumber;
	pSMsg->ColorCode			= pArmorItemGen->ColorCode;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_BUY_COLOR_ITEM_OK));

	igLock.auto_unlock_cancel();	// 2007-10-05 by cmkwon, 

	// 2007-08-27 by dhjin, ǰ ó
	this->SetExpediencyFundW(m_character.InfluenceType, nColorCost);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::Process_FC_SHOP_BUY_WARPOINT_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		WarPoint 
/// \author		dhjin
/// \date		2007-06-13 ~ 2007-06-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_SHOP_BUY_WARPOINT_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	// 2007-06-13 by dhjin, ⺻ κ üũ
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_BUY_WARPOINT_ITEM,
									MSG_FC_SHOP_BUY_WARPOINT_ITEM, pBuyWarPointItem);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2008-08-18 by dhjin, 1  ý ȹ
	if(!this->CheckOneSecondTermSystem())
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_INTERVAL_SYSTEM_SECOND, m_dwMSTermSystem);
		return RES_BREAK;
	}

	if(INVALID_UNIQUE_NUMBER != m_peerTraderCharacterUniqueNumber
		&& 0 != m_peerTraderCharacterUniqueNumber)
	{// 2007-06-13 by dhjin, ŷ  üũ
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_ITEM_TRADING);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_SHOP_BUY_WARPOINT_ITEM û 2н üũ
	if(FALSE == this->CheckSecondaryPasswordLock())
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_SECPASS_LOCKED);
		return RES_BREAK;
	}
	
	CShopInfo* pShopInfo = m_pCurrentFieldMapChannel->m_pFieldMapProject->GetShopInfoByBuildingNPC(pBuyWarPointItem->BuildingIndex);
	if (!pShopInfo)
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP);
		return RES_RETURN_FALSE;
	}

	SHOP_ITEM *pWarPointShopItem = pShopInfo->GetSHOP_ITEMPtr(pBuyWarPointItem->ItemNum);
	if (NULL == pWarPointShopItem)
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_NO_SUCH_SHOP_ITEM, pBuyWarPointItem->ItemNum);
		return RES_RETURN_FALSE;
	}

	if(NULL == m_pCurrentBuildingNPC)
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_COMMON_INVALID_BUILDINGKIND);
		return RES_BREAK;
	}

	if (m_pCurrentBuildingNPC->BuildingKind != BUILDINGKIND_WARPOINT_SHOP)
	{// BuildKind üũ
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_BUILDING_KIND_NOT_MATCHED);
		return RES_BREAK;
	}

	if(pBuyWarPointItem->Amount <= 0)
	{// 2007-06-13 by dhjin,   0  		
		char szSystemLog[512];
		sprintf(szSystemLog, "[ERROR] Shop Buy WarPoint Item Error, Char(%15s) ItemNum(%8d) ItemAmoun(%8d)\r\n"
			, m_character.CharacterName, pBuyWarPointItem->ItemNum, pBuyWarPointItem->Amount);
		g_pFieldGlobal->WriteSystemLog(szSystemLog);
		DBGOUT(szSystemLog);

		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0074);
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, pBuyWarPointItem->Amount);
		return RES_RETURN_FALSE;
	}

	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
	ITEM *pWarPointItemInfo = ms_pFieldIOCP->GetItemInfo(pBuyWarPointItem->ItemNum);
	if (pWarPointItemInfo == NULL)
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM, pBuyWarPointItem->ItemNum);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2009-09-23 by cmkwon, ʵâ ĳ   - T_FC_SHOP_BUY_WARPOINT_ITEM, ʵâ ̿  Űɿ  üũ
	if(pWarPointItemInfo->IsExistDesParam(DES_FIELD_STORE)
		&& this->m_ItemManager.IsUseableFieldStore())
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_CANNOT_BUY_ITEM, pWarPointItemInfo->ItemNum, this->m_ItemManager.IsUseableFieldStore());
		return RES_BREAK;
	}


// 2009-09-16 by cmkwon, WarPoint  īͺ    - Ʒʿ ݾ 
// 	INT64 n64SumOfPrice	= pWarPointItemInfo->CashPrice * (pBuyWarPointItem->Amount/pWarPointItemInfo->MinTradeQuantity);
// 	if (NULL == this->m_character.WarPoint
// 		|| n64SumOfPrice > this->m_character.WarPoint)
// 	{// 2007-06-13 by dhjin, Ϸ    
// 		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
// 		return RES_BREAK;
// 	}

	// 2007-06-13 by dhjin, WarPoint ǰ 
	// ִ  Ȯ
	// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
	if(IS_COUNTABLE_ITEM(pWarPointItemInfo->Kind))
	{// īͺ  κ丮   ִ밳 Ȯ

		ITEM_GENERAL *pItemGeneralInven = m_ItemManager.GetFirstItemGeneralByItemNum(pWarPointItemInfo->ItemNum);
		if (NULL == pItemGeneralInven
			&& m_ItemManager.GetInventoryItemCounts() >= m_ItemManager.GetMaxInventoryCount())
		{
			SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, m_ItemManager.GetMaxInventoryCount());
			return RES_BREAK;
		}
	}
	else if(IS_GENERAL_ITEM(pWarPointItemInfo->Kind))
	{// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - 
		pBuyWarPointItem->Amount = min(pBuyWarPointItem->Amount, MAX_ITEM_COUNTS_FOR_BUY);		// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - ִ    .
		
		if(m_ItemManager.GetInventoryItemCounts() + pBuyWarPointItem->Amount > m_ItemManager.GetMaxInventoryCount())
		{// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ -     ؼ üũ Ѵ.
			SendErrorMessage(T_FC_STORE_MOVE_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, m_ItemManager.GetMaxInventoryCount());
			return RES_BREAK;
		}
	}
// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - 
//	else if (m_ItemManager.GetInventoryItemCounts() >= CAtumSJ::GetMaxInventorySize(m_ItemManager.IsExistPremiumCard()))
//	{// īͺ ƴ  ִ  Ȯ
//
//		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, CAtumSJ::GetMaxInventorySize(m_ItemManager.IsExistPremiumCard()));
//		return RES_BREAK;
//	}

	// 2009-09-16 by cmkwon, WarPoint  īͺ    - īͺ     ɼ ֱ  ġ ̵
#ifdef SHOP_PRICES_PER_BUILDING_NPC
	INT64 n64SumOfPrice = pWarPointShopItem->Price * (pBuyWarPointItem->Amount / pWarPointItemInfo->MinTradeQuantity);
#else
	INT64 n64SumOfPrice	= pWarPointItemInfo->CashPrice * (pBuyWarPointItem->Amount/pWarPointItemInfo->MinTradeQuantity);
#endif // SHOP_PRICES_PER_BUILDING_NPC

	// 2012-10-16 by bckim, ĳ  Log ߰
	INT64 n64LogSpend = n64SumOfPrice;		//	  Ժ 
	// end 2012-10-16 by bckim, ĳ  Log ߰

	if (NULL == this->m_character.WarPoint
		|| n64SumOfPrice > this->m_character.WarPoint)
	{// 2007-06-13 by dhjin, Ϸ    
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2005-09-13 by cmkwon, īͺ   ִ(20) īƮ üũ
	if(IS_COUNTABLE_ITEM(pWarPointItemInfo->Kind))
	{
		INT64 tmCurrentCount = pBuyWarPointItem->Amount;

		ITEM_GENERAL *pMyItem = m_ItemManager.GetFirstItemGeneralByItemNum(pBuyWarPointItem->ItemNum);
		if(pMyItem){				tmCurrentCount += pMyItem->CurrentCount;}
		if(tmCurrentCount > MAX_ITEM_COUNTS)
		{
			SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER, 0, 0);
			return RES_BREAK;			
		}
		else if(tmCurrentCount >= MAX_NOTIFY_ITEM_COUNTS)
		{
			SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_NOTIFY_MAX_ITEM_COUNTS_OVER);
		}
	}

	if (IS_GENERAL_ITEM(pWarPointItemInfo->Kind) 
		&& FALSE == IS_COUNTABLE_ITEM(pWarPointItemInfo->Kind))
	{
		if(timeGetTime()-m_dwLastTickInsertingStoreItem > 5000)
		{
			m_nInsertingStoreItemCounts = 0;
		}

		// 2008-07-16 by cmkwon, ITEM_GENERAL   üũ - 
		//if(m_ItemManager.GetInventoryItemCounts() + m_nInsertingStoreItemCounts >= CAtumSJ::GetMaxInventorySize(m_ItemManager.IsExistPremiumCard()))	// 2006-10-25 by cmkwon,  
		// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
		if(m_ItemManager.GetInventoryItemCounts() + m_nInsertingStoreItemCounts + pBuyWarPointItem->Amount > m_ItemManager.GetMaxInventoryCount())	// 2006-10-25 by cmkwon,  
		{
			SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, 1);
			return RES_BREAK;
		}		
	}

	if (COMPARE_BIT_FLAG(pWarPointItemInfo->ItemAttribute, ITEM_ATTR_NO_TRANSFER|ITEM_ATTR_KILL_MARK_ITEM))
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}

	// ּ ŷ  Ȯ: MinTradeQuantity θ    
	if ( pBuyWarPointItem->Amount%pWarPointItemInfo->MinTradeQuantity != 0)
	{
		SendErrorMessage(T_FC_SHOP_BUY_WARPOINT_ITEM, ERR_PROTOCOL_MIN_TRADE_QUANTITY_ERROR, pWarPointItemInfo->MinTradeQuantity);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	//  
	m_ItemManager.InsertItemBaseByItemNum(pWarPointItemInfo->ItemNum, pBuyWarPointItem->Amount, IUT_SHOP, FALSE, ITEM_IN_CHARACTER,	TRUE, TRUE, 0, 0, 0, 0, GLOG_WARPOINTSHOP);  // 2012-11-21 by khkim, GLog 2 
	
	// 2007-06-13 by dhjin, WarPoint 
	this->m_character.WarPoint -= n64SumOfPrice;

	// start 2012-01-16 by hskim,  - ȭ
	if( NULL != this->ms_pFieldIOCP->m_pStatisticsManager )
	{
		this->ms_pFieldIOCP->m_pStatisticsManager->Sub(STATISTICS_WAR_POINT, n64SumOfPrice);
	}
	// end 2012-01-16 by hskim,  - ȭ

	// send log
	ITEM_GENERAL tmpItemForLog(pWarPointItemInfo);
	tmpItemForLog.UniqueNumber			= 0;
	tmpItemForLog.AccountUniqueNumber	= m_character.AccountUniqueNumber;
	tmpItemForLog.Possess				= m_character.CharacterUniqueNumber;
	tmpItemForLog.Wear					= WEAR_NOT_ATTACHED;
	tmpItemForLog.CurrentCount			= pBuyWarPointItem->Amount;
// 2009-08-25 by cmkwon,  ʴ ʵ (td_Store.ScarcityNumber) - 
//	tmpItemForLog.ScarcityNumber		= 0;
	tmpItemForLog.ItemWindowIndex		= POS_INVALID_POSITION;
	tmpItemForLog.PrefixCodeNum			= 0;
	tmpItemForLog.SuffixCodeNum			= 0;
	tmpItemForLog.NumOfEnchants			= 0;
	CAtumLogSender::SendLogMessageITEMBuyITEM(this, &tmpItemForLog, pBuyWarPointItem->Amount, this->m_character.WarPoint, TRUE);
	
	// 2012-10-16 by bckim, ĳ  Log ߰
	//enum ITEM_BUY_CASH_PRICE_TYPE{BUY_TYPE_SPI=1,BUY_TYPE_WARPOINT,BUY_TYPE_CASH,BUY_TYPE_INFINITY};
	CAtumLogSender::SendLogMessageITEMBuyCashPrice(this, &tmpItemForLog, pBuyWarPointItem->Amount, n64LogSpend, FALSE, BUY_TYPE_WARPOINT, NULL); // WARPOINT type : 2
	// end 2012-10-16 by bckim, ĳ  Log ߰

	igLock.auto_unlock_cancel();

	// 2009-01-22 by cmkwon,    α  - CAtumLogSender::SendLogMessageGetWarPoint() (, BYTE i_byWPUpdateTy) ߰
	CAtumLogSender::SendLogMessageGetWarPoint(this, n64SumOfPrice, this->m_character.WarPoint, this->m_character.CumulativeWarPoint, WPUT_SHOP);
	// 2007-05-16 by dhjin, DB Ʈ
	QPARAM_UPDATE_WARPOINT *pQparam = new QPARAM_UPDATE_WARPOINT;
	pQparam->CharacterUID		= this->m_character.CharacterUniqueNumber;
	pQparam->AccountUID			= this->m_character.AccountUniqueNumber;
	pQparam->TotalWarPoint		= this->m_character.WarPoint;
	pQparam->CumulativeWarPoint	= this->m_character.CumulativeWarPoint;
	this->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateWarPoint, this, this->m_character.AccountUniqueNumber, pQparam);

	// 2007-05-16 by dhjin, Ŭ̾Ʈ 
	INIT_MSG_WITH_BUFFER(MSG_FC_SHOP_BUY_WARPOINT_ITEM_OK, T_FC_SHOP_BUY_WARPOINT_ITEM_OK, pMsg, SendBuf);
	pMsg->PayWarPoint				= n64SumOfPrice;
	pMsg->WarPoint					= this->m_character.WarPoint;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_BUY_WARPOINT_ITEM_OK));
	
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::Process_FC_SHOP_CHECK_GIVE_TARGET(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		// 2007-11-13 by cmkwon, ϱ  ߰ - CFieldIOCPSocket::Process_FC_SHOP_CHECK_GIVE_TARGET() ߰
/// \author		cmkwon
/// \date		2007-11-13 ~ 2007-11-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_SHOP_CHECK_GIVE_TARGET(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_CHECK_GIVE_TARGET,
									MSG_FC_SHOP_CHECK_GIVE_TARGET, pRMsg);


	MEMSET_ZERO(&m_giveTargetCharacter, sizeof(m_giveTargetCharacter));				// 2007-11-13 by cmkwon, ϱ  ߰ - ʱȭ

	if(FALSE == IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_SHOP_CHECK_GIVE_TARGET, ERR_INVALID_CHARACTER, 100);
		return RES_BREAK;
	}

	if(0 == stricmp("", pRMsg->GiveTargetCharName))
	{
		SendErrorMessage(T_FC_SHOP_CHECK_GIVE_TARGET, ERR_PROTOCOL_EMPTY_CHARACTERNAME, 111);
		return RES_BREAK;
	}

	if(0 == stricmp(m_character.CharacterName, pRMsg->GiveTargetCharName))
	{// 2007-11-15 by cmkwon, ڱڽſ ʹϱ Ұ
		SendErrorMessage(T_FC_SHOP_CHECK_GIVE_TARGET, ERR_COMMON_NOT_ALLOWED_TO_MYSELF, 112);
		return RES_BREAK;
	}

	ITEM *pGiftItem = ms_pFieldIOCP->GetItemInfo(pRMsg->GiveItemNum);
	if(NULL == pGiftItem
		|| FALSE == COMPARE_BIT_FLAG(pGiftItem->ItemAttribute, ITEM_ATTR_CASH_ITEM))
	{// 2007-11-14 by cmkwon, ϱ ۸ ϴ
		SendErrorMessage(T_FC_SHOP_CHECK_GIVE_TARGET, ERR_PROTOCOL_NO_SUCH_ITEM, 101, pGiftItem->ItemNum);
		return RES_BREAK;
	}

	if(ITEMKIND_COLOR_ITEM == pGiftItem->Kind
		|| CASH_ITEMKIND_COLOR_ITEM == pGiftItem->SummonMonster
// 2008-10-20 by cmkwon,   üũ ItemAttribute  ó - 
//		|| CASH_ITEMKIND_PREMIUM_CARD == pGiftItem->SummonMonster)
		|| COMPARE_BIT_FLAG(pGiftItem->ItemAttribute, ITEM_ATTR_CASH_ITEM_PREMIUM_CARD))
	{// 2007-11-14 by cmkwon, Ƹ÷, ϱ Ұ
		SendErrorMessage(T_FC_SHOP_CHECK_GIVE_TARGET, ERR_CANNOT_PUT_ITEM, 102, pGiftItem->ItemNum);
		return RES_BREAK;
	}

	STRNCPY_MEMSET(m_giveTargetCharacter.CharacterName0, pRMsg->GiveTargetCharName, SIZE_MAX_CHARACTER_NAME);	// 2007-11-13 by cmkwon, ϱ  ߰ - 
	m_giveTargetCharacter.BuyItemNum = pRMsg->GiveItemNum;

	QPARAM_CHECK_GiveTarget *pQParam = new QPARAM_CHECK_GiveTarget;
	*pQParam		= *pRMsg;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_CheckGiveTarget, this, this->m_character.AccountUniqueNumber, pQParam);
	return RES_RETURN_TRUE;
}

// 2013-05-09 by hskim,  Ʈ 
ProcessResult CFieldIOCPSocket::Process_FC_SHOP_INFLUENCE_BUFF(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SHOP_INFLUENCE_BUFF, MSG_FC_SHOP_INFLUENCE_BUFF, pRMsg);

	int iLastSkillNum = 0;
	int arSkillNum[] = { 0, 0, CONSECUTIVE_VICTORIES_BUFF_SKILL_2ND, CONSECUTIVE_VICTORIES_BUFF_SKILL_3RD, CONSECUTIVE_VICTORIES_BUFF_SKILL_4TH, CONSECUTIVE_VICTORIES_BUFF_SKILL_5TH, CONSECUTIVE_VICTORIES_BUFF_SKILL_6TH, CONSECUTIVE_VICTORIES_BUFF_SKILL_7TH, CONSECUTIVE_VICTORIES_BUFF_SKILL_8TH };

	if(FALSE == IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_SHOP_INFLUENCE_BUFF, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	if( !COMPARE_INFLUENCE(m_character.InfluenceType, (INFLUENCE_TYPE_VCN | INFLUENCE_TYPE_ANI)) )
	{
		SendErrorMessage(T_FC_SHOP_INFLUENCE_BUFF, ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED);
		return RES_BREAK;
	}

	if( pRMsg->nConsecutiveVictories != ms_pFieldIOCP->m_InflWarManager.GetConsecutiveVictoriesPoint(m_character.InfluenceType) )
	{
		SendErrorMessage(T_FC_SHOP_INFLUENCE_BUFF, ERR_PROTOCOL_RACE_PERMISSION_DENIED);
		return RES_BREAK;
	}

	if( IsInvisibleCharacter() )
	{
		SendErrorMessage(T_FC_SHOP_INFLUENCE_BUFF, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}

	for(int i=0; i<=pRMsg->nConsecutiveVictories; i++)
	{
		if( pRMsg->nConsecutiveVictories < 0 || pRMsg->nConsecutiveVictories > 8 ) break;
		if( 0 == arSkillNum[i] ) continue;

		if( TRUE == this->ApplyBuffSkill(arSkillNum[i]) )
		{
			iLastSkillNum = arSkillNum[i];
		}
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_SHOP_INFLUENCE_BUFF_OK, T_FC_SHOP_INFLUENCE_BUFF_OK, pMsg, SendBuf);
	pMsg->nLastSkillNum = iLastSkillNum;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_SHOP_INFLUENCE_BUFF_OK));

	return RES_RETURN_TRUE;
}
// end 2013-05-09 by hskim,  Ʈ 

void CFieldIOCPSocket::SendString128Static(BYTE string128_type, char* pFormat, ...)
{
	if (string128_type < m_STRING_128_print_level)
	{
		return;
	}
	char szStrTemp[1024];
	int nHeaderSize = 0;
	MEMSET_ZERO(szStrTemp, 1024);
	if (string128_type == STRING_128_DEBUG_L1)
	{
		strcpy(szStrTemp, "[D1]");
		nHeaderSize = 4;
	}
	else if (string128_type == STRING_128_DEBUG_L2)
	{
		strcpy(szStrTemp, "[D2]");
		nHeaderSize = 4;
	}
	else if (string128_type == STRING_128_DEBUG_L3)
	{
		strcpy(szStrTemp, "[D3]");
		nHeaderSize = 4;
	}
	else if (string128_type == STRING_128_ADMIN_CMD)
	{
		strcpy(szStrTemp, "[A]");
		nHeaderSize = 3;
	}

	va_list args;
	va_start(args, pFormat);
	vsprintf(szStrTemp+nHeaderSize, pFormat, args);
    va_end(args);

	// start 2011-06-22 by hskim, 缳  
	WORD wSecurityNumber = ms_pFieldIOCP->m_pSecurityManager->GetSecurityNumber();
	// end 2011-06-22 by hskim, 缳  

	int nStrLen = strlen(szStrTemp);
	if(128 > nStrLen)
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_128, T_FC_STRING_128, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 128);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_128));
	}
	else if(256 > nStrLen)
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_256, T_FC_STRING_256, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 256);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_256));
	}
	else if(512 > nStrLen)
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_512, T_FC_STRING_512, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 512);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_512));
	}
	else
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_512, T_FC_STRING_512, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 512);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_512));

		char szErrStr[1024];
 		wsprintf(szErrStr, "  Error: String Too Long For STRING_XXX(Length:%d, %s)\r\n", nStrLen, szStrTemp);
		g_pFieldGlobal->WriteSystemLog(szErrStr);
		DbgOut(szErrStr);
	}

// 2006-04-13 by cmkwon
// 	int nHeaderSize = 0;
// 	INIT_MSG_WITH_BUFFER(MSG_FC_STRING_128, T_FC_STRING_128, MsgStr, SendBuf);
// 	MsgStr->PrintType = STR128_PRINT_TYPE_STATIC;
// 	if (string128_type == STRING_128_DEBUG_L1)
// 	{
// 		strcpy(MsgStr->String, "[D1]");
// 		nHeaderSize = 4;
// 	}
// 	else if (string128_type == STRING_128_DEBUG_L2)
// 	{
// 		strcpy(MsgStr->String, "[D2]");
// 		nHeaderSize = 4;
// 	}
// 	else if (string128_type == STRING_128_DEBUG_L3)
// 	{
// 		strcpy(MsgStr->String, "[D3]");
// 		nHeaderSize = 4;
// 	}
// 	else if (string128_type == STRING_128_ADMIN_CMD)
// 	{
// 		strcpy(MsgStr->String, "[A]");
// 		nHeaderSize = 3;
// 	}
// 
// 	va_list args;
// 	va_start(args, pFormat);
// 	vsprintf(MsgStr->String+nHeaderSize, pFormat, args);
// 	int ret = GDeleteNewLine(MsgStr->String);	// delete newline character(s)
// 	if (ret < 128)
// 	{
// 		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_128));
// 	}
// 	else
// 	{
// 		MsgStr->String[127] = '\0';
// 		DBGOUT("  Error: String Too Long For STRING_128(ret: %d): %s\r\n", ret, MsgStr->String);
// 		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_128));
// 	}
// 	va_end(args);

// check: static string128  , 20031203, kelovon
//	if (string128_type == STRING_128_ADMIN_CMD)
//	{
//		DBGOUT2(DO2_SYSLOG|DO2_DBGOUT, "	SendString128 %s: %s\r\n",
//			GetCharacterString(&m_character, string()),
//			MsgStr->String);
//	}
}

void CFieldIOCPSocket::SendString128(BYTE string128_type, char* pFormat, ...)
{
	if (string128_type < m_STRING_128_print_level)
	{
		return;
	}

	// start 2011-06-22 by hskim, 缳  
	WORD wSecurityNumber = ms_pFieldIOCP->m_pSecurityManager->GetSecurityNumber();
	// end 2011-06-22 by hskim, 缳  

	char szStrTemp[1024];
	int nHeaderSize = 0;
	MEMSET_ZERO(szStrTemp, 1024);
	if (string128_type == STRING_128_DEBUG_L1)
	{
		strcpy(szStrTemp, "[D1]");
		nHeaderSize = 4;
	}
	else if (string128_type == STRING_128_DEBUG_L2)
	{
		strcpy(szStrTemp, "[D2]");
		nHeaderSize = 4;
	}
	else if (string128_type == STRING_128_DEBUG_L3)
	{
		strcpy(szStrTemp, "[D3]");
		nHeaderSize = 4;
	}
	else if (string128_type == STRING_128_ADMIN_CMD)
	{
		strcpy(szStrTemp, "[A]");
		nHeaderSize = 3;
	}

	va_list args;
	va_start(args, pFormat);
	vsprintf(szStrTemp+nHeaderSize, pFormat, args);
    va_end(args);

	int nStrLen = strlen(szStrTemp);
	if(128 > nStrLen)
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_128, T_FC_STRING_128, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 128);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_128));
	}
	else if(256 > nStrLen)
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_256, T_FC_STRING_256, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 256);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_256));
	}
	else if(512 > nStrLen)
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_512, T_FC_STRING_512, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 512);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_512));
	}
	else
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_512, T_FC_STRING_512, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 512);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_512));

		char szErrStr[1024];
 		wsprintf(szErrStr, "  Error: String Too Long For STRING_XXX(Length:%d, %s)\r\n", nStrLen, szStrTemp);
		g_pFieldGlobal->WriteSystemLog(szErrStr);
		DbgOut(szErrStr);
	}

	// start 2012-02-13 by hskim,    ׽Ʈ ɾ
	if( STRING_128_DEBUG_PRINT == string128_type )
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_512, T_FC_STRING_512, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_DBGOUT;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 512);
		MsgStr->SecurityNumber = wSecurityNumber;		// 2011-06-22 by hskim, 缳  
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_512));
	}
	// end 2012-02-13 by hskim,    ׽Ʈ ɾ
	// start 2012-03-30 by hskim, EP4 Ʈ ý ̺Ʈ ˸
	else if( STRING_128_SYSTEM_NOTICE == string128_type )
	{
		if(128 > nStrLen)
		{
		INIT_MSG_WITH_BUFFER(MSG_FC_STRING_128, T_FC_STRING_128, MsgStr, SendBuf);
		MsgStr->PrintType = STR128_PRINT_TYPE_NOTICE;
		STRNCPY_MEMSET(MsgStr->String, szStrTemp, 128);
		MsgStr->SecurityNumber = wSecurityNumber;
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_128));
		}
		else if(256 > nStrLen)
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_STRING_256, T_FC_STRING_256, MsgStr, SendBuf);
			MsgStr->PrintType = STR128_PRINT_TYPE_NOTICE;
			STRNCPY_MEMSET(MsgStr->String, szStrTemp, 256);
			MsgStr->SecurityNumber = wSecurityNumber;
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_256));
		}
		else
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_STRING_512, T_FC_STRING_512, MsgStr, SendBuf);
			MsgStr->PrintType = STR128_PRINT_TYPE_NOTICE;
			STRNCPY_MEMSET(MsgStr->String, szStrTemp, 512);
			MsgStr->SecurityNumber = wSecurityNumber;
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_512));
		}
	}
	// end 2012-03-30 by hskim, EP4 Ʈ ý ̺Ʈ ˸
	// 2013-05-31 by jhseol,bckim Ƹ ÷ - ˾ ˸
	else if ( STRING_128_USER_POPUP == string128_type )
	{
		if(128 > nStrLen)
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_STRING_128, T_FC_STRING_128, MsgStr, SendBuf);
			MsgStr->PrintType = STR128_PRINT_TYPE_POPUP;
			STRNCPY_MEMSET(MsgStr->String, szStrTemp, 128);
			MsgStr->SecurityNumber = wSecurityNumber;
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_128));
		}
		else if(256 > nStrLen)
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_STRING_256, T_FC_STRING_256, MsgStr, SendBuf);
			MsgStr->PrintType = STR128_PRINT_TYPE_POPUP;
			STRNCPY_MEMSET(MsgStr->String, szStrTemp, 256);
			MsgStr->SecurityNumber = wSecurityNumber;
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_256));
		}
		else
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_STRING_512, T_FC_STRING_512, MsgStr, SendBuf);
			MsgStr->PrintType = STR128_PRINT_TYPE_POPUP;
			STRNCPY_MEMSET(MsgStr->String, szStrTemp, 512);
			MsgStr->SecurityNumber = wSecurityNumber;
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_512));
		}
	}
	// end 2013-05-31 by jhseol,bckim Ƹ ÷ - ˾ ˸

	if (string128_type == STRING_128_ADMIN_CMD)
	{
		DBGOUT2(DO2_SYSLOG, "	SendString128 %s: %s\r\n",
			GetCharacterString(&m_character, string()),
			szStrTemp);
	}

// 2006-04-13 by cmkwon,  ڵ 
// 	int nHeaderSize = 0;
// 	INIT_MSG_WITH_BUFFER(MSG_FC_STRING_128, T_FC_STRING_128, MsgStr, SendBuf);
// 	MsgStr->PrintType = STR128_PRINT_TYPE_CHAT;
// 	if (string128_type == STRING_128_DEBUG_L1)
// 	{
// 		strcpy(MsgStr->String, "[D1]");
// 		nHeaderSize = 4;
// 	}
// 	else if (string128_type == STRING_128_DEBUG_L2)
// 	{
// 		strcpy(MsgStr->String, "[D2]");
// 		nHeaderSize = 4;
// 	}
// 	else if (string128_type == STRING_128_DEBUG_L3)
// 	{
// 		strcpy(MsgStr->String, "[D3]");
// 		nHeaderSize = 4;
// 	}
// 	else if (string128_type == STRING_128_ADMIN_CMD)
// 	{
// 		strcpy(MsgStr->String, "[A]");
// 		nHeaderSize = 3;
// 	}
// 
// 	va_list args;
// 	va_start(args, pFormat);
// 	vsprintf(MsgStr->String+nHeaderSize, pFormat, args);
// 	int ret = GDeleteNewLine(MsgStr->String);	// delete newline character(s)
// 	if (ret < 128)
// 	{
// 		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_128));
// 	}
// 	else
// 	{
// 		MsgStr->String[127] = '\0';
// 		DBGOUT("  Error: String Too Long For STRING_128(ret: %d): %s\r\n", ret, MsgStr->String);
// 		SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_128));
// 	}
// 	va_end(args);
// 
// 	if (string128_type == STRING_128_ADMIN_CMD)
// 	{
// 		DBGOUT2(DO2_SYSLOG, "	SendString128 %s: %s\r\n",
// 			GetCharacterString(&m_character, string()),
// 			MsgStr->String);
// 	}
}

void CFieldIOCPSocket::SendNotification(BOOL bSpecialChat/*Write it into Leadechat or not?*/, char* pFormat, ...)
{
	char szStrTemp[1024];
	MEMSET_ZERO(szStrTemp, 1024);

	WORD wSecurityNumber = ms_pFieldIOCP->m_pSecurityManager->GetSecurityNumber();

	va_list args;
	va_start(args, pFormat);
	vsprintf(szStrTemp, pFormat, args);
	va_end(args);

	INIT_MSG_WITH_BUFFER(MSF_FC_WORLD_NOTIFICATION, T_FC_WORLD_NOTIFICATION, MsgStr, SendBuf);
	MsgStr->Notification = bSpecialChat;
	STRNCPY_MEMSET(MsgStr->String, szStrTemp, 512);
	MsgStr->SecurityNumber = wSecurityNumber;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_STRING_512));
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_REQUEST_INVITE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_PARTY_REQUEST_INVITE,
									MSG_FC_PARTY_REQUEST_INVITE, pMsgReqInvite);


	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
	if(BAZAAR_STATE_NONE != m_bazaarManager.GetBazaarState())
	{// 2006-08-01 by cmkwon,   üũ
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_USING_BAZAAR, 0);
		return RES_BREAK;
	}

	CFieldParty *pFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (NULL == pFParty)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_PROTOCOL_NO_SUCH_PARTY);
		return RES_BREAK;
	}

	mt_auto_lock pmlock(&pFParty->m_ListPartyMember);

	if (pFParty->GetMasterCharacterUniqueNumber() != m_character.CharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_PROTOCOL_PARTY_MASTER_NOT_MATCHED);
		return RES_BREAK;
	}

	if (pFParty->m_FieldPartyInfo.nTotalPartyMember >= SIZE_MAX_PARTY_MEMBER)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_PROTOCOL_ALREADY_MAX_PARTY_MEMBER);
		return RES_BREAK;
	}

	CFieldIOCPSocket *pInvitee = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(pMsgReqInvite->CharacterName);
	if (NULL == pInvitee
		|| FALSE == pInvitee->IsUsing())
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_COMMON_NO_SUCH_CHARACTER, 0, 0, pMsgReqInvite->CharacterName);
		return RES_BREAK;
	}

//	// check:   Ȯ, ġ й  ű
//	if (abs(pInvitee->m_character.Level - m_character.Level) > 6)
//	{
//		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED, abs(pInvitee->m_character.Level - m_character.Level));
//		return RES_BREAK;
//	}

	if(BAZAAR_STATE_NONE != pInvitee->m_bazaarManager.GetBazaarState())
	{// 2006-07-31 by cmkwon,   üũ 
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_USING_BAZAAR, 1);
		return RES_BREAK;
	}

	if (FALSE == pInvitee->IsValidCharacter()
		|| COMPARE_BODYCON_BIT(pInvitee->m_character.BodyCondition, BODYCON_DEAD_MASK|BODYCON_EVENT_HANDLE_MASK))
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_PROTOCOL_CANNOT_INVITE_USER);
		return RES_BREAK;
	}

	// 2005-12-07 by cmkwon, üũ
	if(FALSE == GCheckRaceAndInfluenceType(CHECK_TYPE_PARTY_JOIN, m_character.Race, m_character.InfluenceType,
		pInvitee->GetCharacter()->Race, pInvitee->GetCharacter()->InfluenceType))
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_PROTOCOL_CANNOT_INVITE_USER);
		return RES_BREAK;
	}

	if (pInvitee->m_pFieldParty != NULL)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_INVITE, ERR_PROTOCOL_CANNOT_INVITE_USER);
		return RES_BREAK;
	}

	// send message to invitee...
	INIT_MSG_WITH_BUFFER(MSG_FC_PARTY_REQUEST_INVITE_QUESTION, T_FC_PARTY_REQUEST_INVITE_QUESTION, pQuestion, pQuestionBuf);
	pQuestion->PartyID = pFParty->m_PartyID;
	STRNCPY_MEMSET(pQuestion->MasterCharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	pInvitee->SendAddData(pQuestionBuf, MSG_SIZE(MSG_FC_PARTY_REQUEST_INVITE_QUESTION));

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_ACCEPT_INVITE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_PARTY_ACCEPT_INVITE,
									MSG_FC_PARTY_ACCEPT_INVITE, pMsgAccept);

	// lock m_MapParties
	mt_auto_lock pslock(&ms_pFieldIOCP->m_MapParties);

	CFieldParty *pParty = ms_pFieldIOCP->m_MapParties.findLock(pMsgAccept->PartyID);
	if (pParty == NULL)
	{
		SendErrorMessage(T_FC_PARTY_ACCEPT_INVITE, ERR_PROTOCOL_NO_SUCH_PARTY, LODWORD(pMsgAccept->PartyID), HIDWORD(pMsgAccept->PartyID));
		return RES_BREAK;
	}

	mt_auto_lock pmlock(&pParty->m_ListPartyMember);

	FieldPartyMember tmpMember;
	if ( TRUE == pParty->GetMemberByCharacterUniqueNumber(m_character.CharacterUniqueNumber, tmpMember)
		|| NULL != m_pFieldParty)
	{
		SendErrorMessage(T_FC_PARTY_ACCEPT_INVITE, ERR_PROTOCOL_PARTY_MEMBER_ALREADY_EXISTS);
		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0077);
		return RES_BREAK;
	}

	if (pParty->GetMasterCharacterUniqueNumber() == m_character.CharacterUniqueNumber)
	{
		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0078);
		return RES_BREAK;
	}

	if (pParty->m_PeerBattlePartyID != 0 || pParty->m_PeerBattleRequesterPartyID != 0)
	{
		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0079);
		return RES_BREAK;
	}

	if (pParty->m_FieldPartyInfo.nTotalPartyMember >= SIZE_MAX_PARTY_MEMBER)
	{
		SendErrorMessage(T_FC_PARTY_ACCEPT_INVITE, ERR_PROTOCOL_ALREADY_MAX_PARTY_MEMBER);
		return RES_BREAK;
	}

	// Ƽ  ʵ 鿡 PARTY_ACCEPT_INVITE_OK  IM Server ûѴ.
	INIT_MSG_WITH_BUFFER(MSG_FI_PARTY_ACCEPT_INVITE_OK, T_FI_PARTY_ACCEPT_INVITE_OK, msgAcceptInviteOK, msgAcceptInviteOKBuf);
	msgAcceptInviteOK->PartyID = pMsgAccept->PartyID;
	msgAcceptInviteOK->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
	msgAcceptInviteOK->FieldPartyInfo.nTotalPartyMember = 0;	//  MSG F->I  
	msgAcceptInviteOK->FieldPartyInfo.lowestMemberLevel = 0;	//  MSG F->I  
	ms_pFieldIOCP->m_pIMWinSocket->Write((char*)msgAcceptInviteOKBuf, MSG_SIZE(MSG_FI_PARTY_ACCEPT_INVITE_OK));

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_REJECT_INVITE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_PARTY_REJECT_INVITE,
									MSG_FC_PARTY_REJECT_INVITE, pMsgReject);

	// lock m_MapParties
	mt_auto_lock pslock(&ms_pFieldIOCP->m_MapParties);

	CFieldParty *pParty = ms_pFieldIOCP->m_MapParties.findLock(pMsgReject->PartyID);
	if (pParty == NULL)
	{
		SendErrorMessage(T_FC_PARTY_REJECT_INVITE, ERR_PROTOCOL_NO_SUCH_PARTY, LODWORD(pMsgReject->PartyID), HIDWORD(pMsgReject->PartyID));
		return RES_BREAK;
	}

	mt_auto_lock pmlock(&pParty->m_ListPartyMember);

	// send message to master...
	CFieldIOCPSocket *pMasterSocket = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(pParty->GetMasterCharacterUniqueNumber());
	if (pMasterSocket == NULL)
	{
		SendErrorMessage(T_FC_PARTY_REJECT_INVITE, ERR_COMMON_NO_SUCH_CHARACTER, pParty->GetMasterCharacterUniqueNumber());
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_PARTY_REJECT_INVITE_OK, T_FC_PARTY_REJECT_INVITE_OK, pRejectOK, pRejectOKBuf);
	pRejectOK->PartyID = pRejectOK->PartyID;
	STRNCPY_MEMSET(pRejectOK->CharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	pMasterSocket->SendAddData(pRejectOKBuf, MSG_SIZE(MSG_FC_PARTY_REJECT_INVITE_OK));

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_GET_MEMBER(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_PARTY_GET_MEMBER,
									MSG_FC_PARTY_GET_MEMBER, pMsgGetMember);

	CFieldParty *pFParty = this->m_pFieldParty;		// 2006-04-17 by cmkwon
	if (pFParty == NULL)
	{
		SendErrorMessage(T_FC_PARTY_GET_MEMBER, ERR_PROTOCOL_NO_SUCH_PARTY);
		return RES_BREAK;
	}

	mt_auto_lock pmlock(&pFParty->m_ListPartyMember);
	FieldPartyMember retMember;
	if (FALSE == pFParty->GetMemberByCharacterUniqueNumber(pMsgGetMember->CharacterUniqueNumber, retMember))
	{
		SendErrorMessage(T_FC_PARTY_GET_MEMBER, ERR_PROTOCOL_NO_SUCH_PARTY_MEMBER, pMsgGetMember->CharacterUniqueNumber);
		return RES_BREAK;
	}

	CFieldIOCPSocket *pSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(pMsgGetMember->CharacterUniqueNumber);
	if (NULL == pSocket || pSocket->m_pCurrentFieldMapChannel !=  m_pCurrentFieldMapChannel ||
		COMPARE_BODYCON_BIT(pSocket->m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK)
	)
	{
		SendErrorMessage(T_FC_PARTY_GET_MEMBER, ERR_PROTOCOL_GET_MEMBER_FAIL, pMsgGetMember->CharacterUniqueNumber);
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_PARTY_PUT_MEMBER, T_FC_PARTY_PUT_MEMBER, pPutMember, pPutMemberBuf);
	pPutMember->FieldMemberInfo = pSocket->m_character;
	SendAddData(pPutMemberBuf, MSG_SIZE(MSG_FC_PARTY_PUT_MEMBER));

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_GET_ALL_MEMBER(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_PARTY_GET_ALL_MEMBER,
									MSG_FC_PARTY_GET_ALL_MEMBER, pMsgGetAllMember);

	///////////////////////////////////////////////////////////////////////////
	// check: ʿϸ , 20031005
	///////////////////////////////////////////////////////////////////////////
	SendString128(STRING_128_USER_NOTICE, " Ƽ    !");

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_REQUEST_PARTY_WARP(const char* pPacket, int nLength, int &nBytesUsed)
{
	int								nRecvTypeSize = 0;
	MSG_FC_PARTY_REQUEST_PARTY_WARP	*pMsgPartyWarp = NULL;

	nRecvTypeSize = sizeof(MSG_FC_PARTY_REQUEST_PARTY_WARP)
					+ ((MSG_FC_PARTY_REQUEST_PARTY_WARP*)(pPacket+nBytesUsed))->nPartyMembers*sizeof(UINT);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14047);
		return RES_RETURN_FALSE;
	}
	pMsgPartyWarp = (MSG_FC_PARTY_REQUEST_PARTY_WARP*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	CFieldParty *pFParty = this->m_pFieldParty;		// 2006-04-17 by cmkwon
	if (pFParty == NULL)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, ERR_PROTOCOL_NO_SUCH_PARTY);
		return RES_BREAK;
	}
// 2007-02-12 by cmkwon, Ʒ  Լ ó
//	mt_auto_lock pmlock(&pFParty->m_ListPartyMember);
//
//	if (m_character.CharacterUniqueNumber != pFParty->GetMasterCharacterUniqueNumber())
	if(FALSE == this->IsPartyMaster())
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, ERR_PROTOCOL_PARTY_PERMISSION_DENIED);
		return RES_BREAK;
	}

	// Ÿ  ã
	EVENTINFO *pEventInfo
		= m_pCurrentFieldMapChannel->GetTileEventInfoW(&m_character.PositionVector);

	if (pEventInfo
		&& pEventInfo->m_bEventType == EVENT_TYPE_WARP
		&& COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_FLY_MASK) == TRUE)
	{

		CMapProject *pMapProject = ms_pFieldIOCP->GetMapWorkspace()->GetMapProjectByMapIndex(pEventInfo->m_EventwParam3);

		///////////////////////////////////////////////////////////////////////////////
		// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::Process_FC_PARTY_REQUEST_PARTY_WARP#, º ø
		if(INFLUENCE_CITY_MAP_INDEX == pEventInfo->m_EventwParam3)
		{
			pMapProject = this->GetCityFieldMapProjectPtr();
		}
		if(COMPARE_INFLUENCE(m_character.InfluenceType, pEventInfo->m_nObejctMonsterUnitKind))
		{// 2009-10-13 by cmkwon, Ʈ ̿ Ұ  üũ
			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED, pEventInfo->m_nObejctMonsterUnitKind);
			return RES_BREAK;			
		}

		if (pMapProject == NULL)
		{
			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, ERR_PROTOCOL_NO_SUCH_MAP_SERVED);
			return RES_BREAK;
		}

		Err_t err = this->IsEnableWarp(pMapProject->GetMapInfluenceType(), pMapProject->IsConflictAreaMap(), pMapProject->m_nQuestIndexForWarp);
		if(ERR_NO_ERROR != err)
		{// 2006-11-02 by cmkwon
			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, err);
			return RES_BREAK;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2006-11-02 by cmkwon
		MAP_CHANNEL_INDEX beforeMapChannIndex = m_character.MapChannelIndex;

		//////////////////////////////////////////
		// Ƽ  ó
		//////////////////////////////////////////
		EventResult_t ret = HandleEvent(pEventInfo);

		// event result  ۾
		if (ret == EVENT_RESULT_BREAK)
		{
#ifdef _DEBUG
			DBGOUT(STRERR_S_F2NOTIFY_0005,
				pEventInfo->m_bEventType, GetCharacterString(&m_character, string()));
#endif
			return RES_BREAK;
		}
		else if (ret == EVENT_RESULT_CONTINUE)
		{
			// do nothing
		}
		else if (ret == EVENT_RESULT_CLOSE_CONNECTION)
		{
			// do nothing
			// check:   ó
			//SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, ERR_PROTOCOL_INVALID_MAP_EVENT_INFO, eventType, ret);
#ifdef _DEBUG
			SendString128(STRING_128_DEBUG_L1, STRMSG_S_F2NOTIFY_0081);
			g_pFieldGlobal->WriteSystemLogEX(FALSE, STRERR_S_F2NOTIFY_0006,
				m_character.AccountName, m_character.CharacterName, m_pCurrentFieldMapChannel->m_pFieldMapProject->m_nMapIndex,
				pEventInfo->m_EventwParam3, pEventInfo->m_EventwParam2);
#else
			Close(0x14026);
			return RES_RETURN_FALSE;
#endif
		}
		else
		{
			// error
			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, ERR_PROTOCOL_INVALID_MAP_EVENT_INFO, pEventInfo->m_bEventType, ret);
			return RES_BREAK;
		}

		//////////////////////////////////////////
		// Ƽ  ó, Ƽ 
		//////////////////////////////////////////
		UID32_t *ArrCharacterUniqueNumber = (UID32_t*)(((char*)pMsgPartyWarp) + sizeof(MSG_FC_PARTY_REQUEST_PARTY_WARP));
		for (int i = 0; i < pMsgPartyWarp->nPartyMembers; i++)
		{
			CFieldIOCPSocket *pMemberSock = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(ArrCharacterUniqueNumber[i]);
			if (NULL == pMemberSock
				|| FALSE == pMemberSock->IsValidCharacter())
			{
// 2006-11-02 by cmkwon
//				SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, ERR_PROTOCOL_NO_SUCH_PARTY_MEMBER);
				continue;
			}

			if(FALSE == beforeMapChannIndex.IsSameMapChannelIndex(pMemberSock->GetCharacter()->MapChannelIndex))
			{// 2006-11-02 by cmkwon, ʿ ־ üũ
				continue;
			}

			err = pMemberSock->IsEnableWarp(pMapProject->GetMapInfluenceType(), pMapProject->IsConflictAreaMap(), pMapProject->m_nQuestIndexForWarp);
			if(ERR_NO_ERROR != err)
			{// 2006-11-02 by cmkwon
				pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP, err);
				continue;
			}

			EventResult_t ret = pMemberSock->HandleEvent(pEventInfo);

			// event result  ۾
			if (ret == EVENT_RESULT_BREAK)
			{
#ifdef _DEBUG
				DBGOUT(STRERR_S_F2NOTIFY_0007,
					GetCharacterString(&m_character, string()));
#endif
				continue;
			}
		}
	}

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME(const char* pPacket, int nLength, int &nBytesUsed)
{
	int												nRecvTypeSize = 0;
	MSG_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME	*pMsgPartyWarpMap = NULL;

	nRecvTypeSize = sizeof(MSG_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME)
					+ ((MSG_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME*)(pPacket+nBytesUsed))->nPartyMembers*sizeof(UINT);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14047);
		return RES_RETURN_FALSE;
	}
	pMsgPartyWarpMap = (MSG_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	CFieldParty *pFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (pFParty == NULL)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME, ERR_PROTOCOL_NO_SUCH_PARTY);
		return RES_BREAK;
	}

// 2007-02-12 by cmkwon, Ʒ  Լ ó
//	mt_auto_lock pmlock(&pFParty->m_ListPartyMember);
//
//	if (m_character.CharacterUniqueNumber != pFParty->GetMasterCharacterUniqueNumber())
	if(FALSE == this->IsPartyMaster())
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME, ERR_PROTOCOL_PARTY_PERMISSION_DENIED);
		return RES_BREAK;
	}

	CMapProject *pMapProject
		= ms_pFieldIOCP->GetMapWorkspace()->GetMapProjectByMapIndex(pMsgPartyWarpMap->MapChannelIndex.MapIndex);
	if (pMapProject == NULL)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME, ERR_PROTOCOL_NO_SUCH_MAP_SERVED);
		return RES_BREAK;
	}

	Err_t err = this->IsEnableWarp(pMapProject->GetMapInfluenceType(), pMapProject->IsConflictAreaMap(), pMapProject->m_nQuestIndexForWarp);
	if(ERR_NO_ERROR != err)
	{// 2006-11-02 by cmkwon
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME, err);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-11-02 by cmkwon
	MAP_CHANNEL_INDEX beforeMapChannIndex = m_character.MapChannelIndex;

	//////////////////////////////////////////
	// Ƽ忡  
	//////////////////////////////////////////
	EventResult_t ret = WarpToMap(pMsgPartyWarpMap->MapChannelIndex);
	// 2007-07-03 by cmkwon, Warp  üũ α - ý۷α ߰
	char szSystemLog[1024];
	sprintf(szSystemLog, "[Notify] WarpToMap(109) : %10s SocketIndex[%4d] Map(%4d)	Position(%5d, %5d, %5d)\r\n",
		m_character.CharacterName, m_character.ClientIndex, m_character.MapChannelIndex.MapIndex, (int)m_character.PositionVector.x,
		(int)m_character.PositionVector.y, (int)m_character.PositionVector.z);
	g_pFieldGlobal->WriteSystemLogEX(FALSE, szSystemLog);

	// event result  ۾
	if (ret == EVENT_RESULT_BREAK)
	{
#ifdef _DEBUG
		DBGOUT(STRERR_S_F2NOTIFY_0008,
			EVENT_TYPE_WARP,
			GetCharacterString(&m_character, string())
		);

		return RES_BREAK;
#endif
	}

	//////////////////////////////////////////
	// 鿡  , Ƽ 
	//////////////////////////////////////////
	UID32_t *ArrCharacterUniqueNumber = (UID32_t*)(((char*)pMsgPartyWarpMap) + sizeof(MSG_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME));
	for (int i = 0; i < pMsgPartyWarpMap->nPartyMembers; i++)
	{
		CFieldIOCPSocket *pMemberSock = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(ArrCharacterUniqueNumber[i]);
		if (NULL == pMemberSock
			|| FALSE == pMemberSock->IsValidCharacter())
		{
// 2006-11-02 by cmkwon, ʿ 
//			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME, ERR_PROTOCOL_NO_SUCH_PARTY_MEMBER);
			continue;
		}

		if(FALSE == beforeMapChannIndex.IsSameMapChannelIndex(pMemberSock->GetCharacter()->MapChannelIndex))
		{// 2006-11-02 by cmkwon, ʿ ־ üũ
			continue;
		}

		err = pMemberSock->IsEnableWarp(pMapProject->GetMapInfluenceType(), pMapProject->IsConflictAreaMap(), pMapProject->m_nQuestIndexForWarp);
		if(ERR_NO_ERROR != err)
		{// 2006-11-02 by cmkwon
			pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME, err);
			continue;
		}

		EventResult_t ret = pMemberSock->WarpToMap(pMsgPartyWarpMap->MapChannelIndex);
		// 2007-07-03 by cmkwon, Warp  üũ α - ý۷α ߰
		char szSystemLog[1024];
		sprintf(szSystemLog, "[Notify] WarpToMap(110) : %10s SocketIndex[%4d] Map(%4d)	Position(%5d, %5d, %5d)\r\n",
			pMemberSock->m_character.CharacterName, pMemberSock->m_character.ClientIndex, pMemberSock->m_character.MapChannelIndex.MapIndex, (int)pMemberSock->m_character.PositionVector.x,
			(int)pMemberSock->m_character.PositionVector.y, (int)pMemberSock->m_character.PositionVector.z);
		g_pFieldGlobal->WriteSystemLogEX(FALSE, szSystemLog);

		// event result  ۾
		if (ret == EVENT_RESULT_BREAK)
		{
#ifdef _DEBUG
			DBGOUT(STRERR_S_F2NOTIFY_0009,
				pMsgPartyWarpMap->MapChannelIndex.MapIndex,
				GetCharacterString(&m_character, string())
			);
#endif
			continue;
		}
	}

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT(const char* pPacket, int nLength, int &nBytesUsed)
{
	int										nRecvTypeSize = 0;
	MSG_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT	*pMsgPartyObjectEvent = NULL;

	nRecvTypeSize = sizeof(MSG_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT)
					+ ((MSG_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT*)(pPacket+nBytesUsed))->nPartyMembers*sizeof(UINT);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14047);
		return RES_RETURN_FALSE;
	}
	pMsgPartyObjectEvent = (MSG_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	CFieldParty *pFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if(NULL == pFParty)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_NO_SUCH_PARTY);
		return RES_BREAK;
	}

// 2007-02-12 by cmkwon, ʿ	mt_auto_lock pmlock(&pFParty->m_ListPartyMember);

	D3DXVECTOR3	tmVec3 = A2DX(pMsgPartyObjectEvent->ObjectPosition);
	EVENTINFO *pEventInfo = m_pCurrentFieldMapChannel->GetEventInfoByObjectTypeAndDistanceW(pMsgPartyObjectEvent->ObjectType, &tmVec3);
	if(NULL == pEventInfo)
	{
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_TOO_FAR_TO_DO,
			pMsgPartyObjectEvent->ObjectType, 0);
		return RES_BREAK;
	}

// 2007-12-14 by cmkwon,   ĳ 忡 Ұ - Ʒ  ó
//	if(EVENT_TYPE_CHARACTERMODE_WARP == pEventInfo->m_bEventType
//		&& FALSE == m_character.CharacterMode)
//	{// 2007-10-15 by cmkwon, ĳ͸  ĳ͸ üũ
//		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_TOO_FAR_TO_DO, pMsgPartyObjectEvent->ObjectType, 100);
//		return RES_BREAK;
//	}
	if(m_character.CharacterMode)
	{// 2007-12-14 by cmkwon,   ĳ 忡 Ұ - 
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_CHARACTER_MODE_NOT_MATCHED, pMsgPartyObjectEvent->ObjectType, 100);
		return RES_BREAK;
	}

	if (EVENT_TYPE_WARP == pEventInfo->m_bEventType)
// 2007-12-14 by cmkwon,   ĳ 忡 Ұ - ĳ͸  üũ ʿ 
//		|| EVENT_TYPE_CHARACTERMODE_WARP == pEventInfo->m_bEventType)
	{
		if (COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK))
		{
			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_INVALID_BODYCONDITION);
			return RES_BREAK;
		}

		///////////////////////////////////////////////////////////////////////
		//	- WARP Ƽ常 û  ִ.
		//	- Ƽ ƴ Ƽ ûϸ .
// 2007-02-12 by cmkwon, Ʒ  Լ ó
// 		if (pFParty->GetMasterCharacterUniqueNumber() != m_character.CharacterUniqueNumber)
		if(FALSE == this->IsPartyMaster())
		{
			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_PARTY_MASTER_NOT_MATCHED);
			return RES_BREAK;
		}

		CFieldMapProject *pFieldMapProject = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pEventInfo->m_EventwParam3);

		///////////////////////////////////////////////////////////////////////////////
		// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::Process_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT#, º ø 
		switch(pEventInfo->m_EventwParam3)
		{
		case INFLUENCE_CITY_MAP_INDEX:		pFieldMapProject = this->GetCityFieldMapProjectPtr();			break;
		case INFLUENCE_GARDEN_MAP_INDEX:	pFieldMapProject = this->GetGardenFieldMapProjectPtr();			break;
		}
		if(COMPARE_INFLUENCE(m_character.InfluenceType, pEventInfo->m_nObejctMonsterUnitKind))
		{// 2009-10-13 by cmkwon, Ʈ ̿ Ұ  üũ
			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED, pEventInfo->m_nObejctMonsterUnitKind);
			return RES_BREAK;			
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2005-11-14 by cmkwon, Warp is possible check
		Err_t	nErrCode	= ERR_NO_ERROR;
		int		nErrParam1	= 0;
		int		nErrParam2	= 0;
		if(NULL == pFieldMapProject)
		{
			nErrCode		= ERR_PROTOCOL_NO_SUCH_MAP_SERVED;
			nErrParam2		= pEventInfo->m_EventwParam3;
		}
		else
		{
			nErrCode		= this->IsEnableWarp(pFieldMapProject->GetMapInfluenceType(), pFieldMapProject->IsConflictAreaMap(), pFieldMapProject->m_nQuestIndexForWarp, FALSE, pFieldMapProject);		// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
			nErrParam1		= ERR_PROTOCOL_REQ_QUEST_NOT_MATCHED;
			nErrParam2		= pEventInfo->m_EventwParam3;
		}

		if(ERR_NO_ERROR != nErrCode)
		{
			//////////////////////////////////////////
			// Ƽ忡  
			SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, nErrCode, nErrParam1, nErrParam2);

			//////////////////////////////////////////
			// Ƽ ο  
			UID32_t *ArrCharacterUniqueNumber = (UID32_t*)(((char*)pMsgPartyObjectEvent) + sizeof(MSG_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT));
			for (int i = 0; i < pMsgPartyObjectEvent->nPartyMembers; i++)
			{
				CFieldIOCPSocket *pMemberSock = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(ArrCharacterUniqueNumber[i]);
				if (NULL == pMemberSock
					|| FALSE == pMemberSock->IsValidCharacter(FALSE))
				{
					continue;
				}
				pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, nErrCode, nErrParam1, nErrParam2);
			}
			return RES_BREAK;
		}

		//////////////////////////////////////////////////////////////////////////
		// 2007-08-28 by dhjin,   ° üũ
		// 2007-09-21 by cmkwon,    ø ƴ 츸 üũ
		if(FALSE == IS_OUTPOST_CITY_MAP_INDEX(m_pCurrentFieldMapChannel->GetMapChannelIndex().MapIndex)
			&& IS_MAP_INFLUENCE_OUTPOST(pFieldMapProject->GetMapInfluenceType()) 
			&& FALSE == ms_pFieldIOCP->m_OutPostManager.CheckOutPostWaring(pFieldMapProject->m_nMapIndex))
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2007-09-28 by cmkwon, ,ڵ   ,ø  
			// 2007-10-06 by cmkwon,  2 ȣĪ ٸ  -
			//if(FALSE == COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER|RACE_INFLUENCE_SUBLEADER))
			if(FALSE == COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER|RACE_INFLUENCE_SUBLEADER_MASK))
			{
				if(FALSE == ms_pFieldIOCP->m_OutPostManager.CheckValidGuildUID(pFieldMapProject->m_nMapIndex, m_character.GuildUniqueNumber))
				{
					SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST, pFieldMapProject->m_nMapIndex, 1);
					return RES_BREAK;
				}
			}
			else
			{
				///////////////////////////////////////////////////////////////////////////////
				// 2007-09-28 by cmkwon, ,  ش  °  üũ
				BYTE byInflTy = ms_pFieldIOCP->m_OutPostManager.GetOutPostInfluenceByMapIndex(pFieldMapProject->m_nMapIndex);
				if(FALSE == COMPARE_INFLUENCE(m_character.InfluenceType, byInflTy))
				{
					SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST, pEventInfo->m_EventwParam3, 2);
					return RES_BREAK;
				}
			}
		}

		// 2007-09-21 by cmkwon,  ø   üũ
		if(IS_OUTPOST_CITY_MAP_INDEX(pFieldMapProject->m_nMapIndex))
		{
			if(FALSE == IS_VALID_UNIQUE_NUMBER(m_character.GuildUniqueNumber))
			{
				SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP, pEventInfo->m_EventwParam3, 3);
				return RES_BREAK;
			}

			if(ms_pFieldIOCP->m_OutPostManager.CheckOutPostWaring(pFieldMapProject->m_nMapIndex))
			{
				SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP, pEventInfo->m_EventwParam3, 4);
				return RES_BREAK;
			}

			///////////////////////////////////////////////////////////////////////////////
			// 2007-09-28 by cmkwon, ,ڵ   ,ø  
			// 2007-10-06 by cmkwon,  2 ȣĪ ٸ  -
			//if(FALSE == COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER|RACE_INFLUENCE_SUBLEADER))
			if(FALSE == COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER|RACE_INFLUENCE_SUBLEADER_MASK))
			{			
				if(FALSE == ms_pFieldIOCP->m_OutPostManager.CheckValidGuildUID(m_character.MapChannelIndex.MapIndex, m_character.GuildUniqueNumber))
				{
					SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP, pEventInfo->m_EventwParam3, 5);
					return RES_BREAK;
				}
			}
			else
			{
				///////////////////////////////////////////////////////////////////////////////
				// 2007-09-28 by cmkwon, ,  ش  °  üũ
				BYTE byInflTy = ms_pFieldIOCP->m_OutPostManager.GetOutPostInfluenceByMapIndex(pFieldMapProject->m_nMapIndex);
				if(FALSE == COMPARE_INFLUENCE(m_character.InfluenceType, byInflTy))
				{
					SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP, pEventInfo->m_EventwParam3, 6);
					return RES_BREAK;
				}
			}

		}
		
		if (FALSE == pFieldMapProject->IsMultiMapChannel(m_character.InfluenceType))
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-11-02 by cmkwon
			MAP_CHANNEL_INDEX beforeMapChannIndex = m_character.MapChannelIndex;

			//////////////////////////////////////////
			// Ƽ  ó
			CFieldMapChannel *pFMChann = pFieldMapProject->GetFirstFieldMapChannel(TRUE);
			WarpToMap(pFMChann->m_MapChannelIndex, pEventInfo->m_EventwParam2);
			// 2007-07-03 by cmkwon, Warp  üũ α - ý۷α ߰
			char szSystemLog[1024];
			sprintf(szSystemLog, "[Notify] WarpToMap(111) : %10s SocketIndex[%4d] Map(%4d)	Position(%5d, %5d, %5d)\r\n",
				m_character.CharacterName, m_character.ClientIndex, m_character.MapChannelIndex.MapIndex, (int)m_character.PositionVector.x,
				(int)m_character.PositionVector.y, (int)m_character.PositionVector.z);
			g_pFieldGlobal->WriteSystemLogEX(FALSE, szSystemLog);

			//////////////////////////////////////////
			// Ƽ  ó, Ƽ 
			//////////////////////////////////////////
			UID32_t *ArrCharacterUniqueNumber = (UID32_t*)(((char*)pMsgPartyObjectEvent) + sizeof(MSG_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT));
			for (int i = 0; i < pMsgPartyObjectEvent->nPartyMembers; i++)
			{
				CFieldIOCPSocket *pMemberSock = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(ArrCharacterUniqueNumber[i]);
				if (NULL == pMemberSock
					|| FALSE == pMemberSock->IsValidCharacter())
				{
// 2006-11-02 by cmkwon, ʿ 
//					SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_NO_SUCH_PARTY_MEMBER);
					continue;
				}

				if(FALSE == beforeMapChannIndex.IsSameMapChannelIndex(pMemberSock->GetCharacter()->MapChannelIndex))
				{// 2006-11-02 by cmkwon, ʿ ־ üũ
					continue;
				}

				//////////////////////////////////////////////////////////////////////////
				// 2007-08-28 by dhjin,   ° üũ
				// 2007-09-21 by cmkwon,    ø ƴ 츸 üũ
				if(FALSE == IS_OUTPOST_CITY_MAP_INDEX(pMemberSock->m_pCurrentFieldMapChannel->GetMapChannelIndex().MapIndex)
					&& IS_MAP_INFLUENCE_OUTPOST(pFieldMapProject->GetMapInfluenceType()) 
					&& FALSE == ms_pFieldIOCP->m_OutPostManager.CheckOutPostWaring(pFieldMapProject->m_nMapIndex))
				{
					///////////////////////////////////////////////////////////////////////////////
					// 2007-09-28 by cmkwon, ,ڵ   ,ø  
					// 2007-10-06 by cmkwon,  2 ȣĪ ٸ  -
					//if(FALSE == COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER|RACE_INFLUENCE_SUBLEADER))
					if(FALSE == COMPARE_RACE(pMemberSock->m_character.Race, RACE_INFLUENCE_LEADER|RACE_INFLUENCE_SUBLEADER_MASK))
					{
						if(FALSE == ms_pFieldIOCP->m_OutPostManager.CheckValidGuildUID(pFieldMapProject->m_nMapIndex, pMemberSock->m_character.GuildUniqueNumber))
						{
							pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST, pFieldMapProject->m_nMapIndex, 1);
							continue;
						}
					}
					else
					{
						///////////////////////////////////////////////////////////////////////////////
						// 2007-09-28 by cmkwon, ,  ش  °  üũ
						BYTE byInflTy = ms_pFieldIOCP->m_OutPostManager.GetOutPostInfluenceByMapIndex(pFieldMapProject->m_nMapIndex);
						if(FALSE == COMPARE_INFLUENCE(pMemberSock->m_character.InfluenceType, byInflTy))
						{
							pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST, pEventInfo->m_EventwParam3, 2);
							continue;
						}
					}
				}

				// 2007-09-21 by cmkwon,  ø   üũ
				if(IS_OUTPOST_CITY_MAP_INDEX(pFieldMapProject->m_nMapIndex))
				{
					if(FALSE == IS_VALID_UNIQUE_NUMBER(pMemberSock->m_character.GuildUniqueNumber))
					{
						pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP, pEventInfo->m_EventwParam3, 3);
						continue;
					}

					if(ms_pFieldIOCP->m_OutPostManager.CheckOutPostWaring(pFieldMapProject->m_nMapIndex))
					{
						pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP, pEventInfo->m_EventwParam3, 4);
						continue;
					}

					///////////////////////////////////////////////////////////////////////////////
					// 2007-09-28 by cmkwon, ,ڵ   ,ø  
					// 2007-10-06 by cmkwon,  2 ȣĪ ٸ  -
					//if(FALSE == COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER|RACE_INFLUENCE_SUBLEADER))
					if(FALSE == COMPARE_RACE(pMemberSock->m_character.Race, RACE_INFLUENCE_LEADER|RACE_INFLUENCE_SUBLEADER_MASK))
					{			
						if(FALSE == ms_pFieldIOCP->m_OutPostManager.CheckValidGuildUID(pMemberSock->m_character.MapChannelIndex.MapIndex, pMemberSock->m_character.GuildUniqueNumber))
						{
							pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP, pEventInfo->m_EventwParam3, 5);
							continue;
						}
					}
					else
					{
						///////////////////////////////////////////////////////////////////////////////
						// 2007-09-28 by cmkwon, ,  ش  °  üũ
						BYTE byInflTy = ms_pFieldIOCP->m_OutPostManager.GetOutPostInfluenceByMapIndex(pFieldMapProject->m_nMapIndex);
						if(FALSE == COMPARE_INFLUENCE(pMemberSock->m_character.InfluenceType, byInflTy))
						{
							pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP, pEventInfo->m_EventwParam3, 6);
							continue;
						}
					}

				}

				///////////////////////////////////////////////////////////////////////////////
				// 2005-11-14 by cmkwon, Warp is possible check
				nErrCode = pMemberSock->IsEnableWarp(pFieldMapProject->GetMapInfluenceType(), pFieldMapProject->IsConflictAreaMap(), pFieldMapProject->m_nQuestIndexForWarp, FALSE, pFieldMapProject);		// 2011-12-19 by hskim, EP4 [Ʈ ý] - ũŻ ý
				if(ERR_NO_ERROR != nErrCode)
				{
					pMemberSock->SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, nErrCode);
					continue;
				}

				if ( //(D3DXVec3Length(&(m_character.PositionVector-pMemberSock->m_character.PositionVector)) < 500.0f)	// check: Ȯ Ÿ ã, 20040226, kelovon
					pMemberSock->m_pFieldParty == pFParty 
					&& FALSE == COMPARE_BODYCON_BIT(pMemberSock->m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK)
				)
				{
					pMemberSock->WarpToMap(pFMChann->m_MapChannelIndex, pEventInfo->m_EventwParam2);
					// 2007-07-03 by cmkwon, Warp  üũ α - ý۷α ߰
					char szSystemLog[1024];
					sprintf(szSystemLog, "[Notify] WarpToMap(112) : %10s SocketIndex[%4d] Map(%4d)	Position(%5d, %5d, %5d)\r\n",
						pMemberSock->m_character.CharacterName, pMemberSock->m_character.ClientIndex, pMemberSock->m_character.MapChannelIndex.MapIndex, (int)pMemberSock->m_character.PositionVector.x,
						(int)pMemberSock->m_character.PositionVector.y, (int)pMemberSock->m_character.PositionVector.z);
					g_pFieldGlobal->WriteSystemLogEX(FALSE, szSystemLog);
				}
// 2005-11-14 by cmkwon, ʿ
//				else
//				{
//#ifdef _DEBUG
//					DBGOUT(STRERR_S_F2NOTIFY_0012,
//						GetCharacterString(&pMemberSock->m_character, string()),
//						(D3DXVec3Length(&(m_character.PositionVector-pMemberSock->m_character.PositionVector))),
//						HIDWORD(pMemberSock->m_character.BodyCondition),
//						LODWORD(pMemberSock->m_character.BodyCondition));
//#endif
//				}
			}

		}// end_if (FALSE == pFieldMapProject->IsMultiMapChannel(m_character.InfluenceType))
		else
		{
			SetBodyConditionBit(m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK|BODYCON_EVENT_SELECTCHANNEL_MASK);
			SendAllChannelState(pFieldMapProject, pEventInfo);
		}
	}
	else if (pEventInfo->m_bEventType == EVENT_TYPE_ENTER_BUILDING)
	{
		//  ó  
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_INVALID_MAP_EVENT_INFO);		// 2007-10-15 by cmkwon, ߰
		return RES_BREAK;
	}
	else
	{
		//  ó  
		SendErrorMessage(T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT, ERR_PROTOCOL_INVALID_MAP_EVENT_INFO);		// 2007-10-15 by cmkwon, ߰
		return RES_BREAK;
	}

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_PARTY_GET_OTHER_MOVE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_PARTY_GET_OTHER_MOVE,
									MSG_FC_PARTY_GET_OTHER_MOVE, pPartyOtherMove);

	if(FALSE == this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_PARTY_GET_OTHER_MOVE, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	CFieldIOCPSocket *pOtherSock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(pPartyOtherMove->OtherCharacterUniqueNumber);
	if (pOtherSock == NULL
		|| FALSE == pOtherSock->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_PARTY_GET_OTHER_MOVE, ERR_COMMON_NO_SUCH_CHARACTER, pPartyOtherMove->OtherCharacterUniqueNumber);
		return RES_BREAK;
	}

	// ٸ ̸  
	if (m_pCurrentFieldMapChannel == NULL || m_pCurrentFieldMapChannel != pOtherSock->m_pCurrentFieldMapChannel)
	{
// 2004-12-23 by cmkwon, ʿ
//		g_pFieldGlobal->WriteSystemLogEX(FALSE, "  GET_OTHER_MOVE: ٸ   , %s %s  û\r\n"
//				, m_character.CharacterName
//				, pOtherSock->m_character.CharacterName);
		return RES_BREAK;
	}

	CFieldParty *pMeFParty		= this->m_pFieldParty;			// 2006-07-04 by cmkwon
	CFieldParty *pOtherFParty	= pOtherSock->m_pFieldParty;	// 2006-07-04 by cmkwon	
	if (pMeFParty == NULL
		|| pOtherFParty == NULL
		|| (pMeFParty->m_PartyID != pOtherFParty->m_PartyID)
		)
	{
		//  Ƽ ƴϸ
		SendErrorMessage(T_FC_PARTY_GET_OTHER_MOVE, ERR_PROTOCOL_NO_SUCH_PARTY_MEMBER);
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_MOVE_OK, T_FC_MOVE_OK, pMoveOK, pMoveOKBuf);
	pMoveOK->ClientIndex	= pOtherSock->m_character.ClientIndex;
// 2007-03-29 by cmkwon, Ʒ  Ʈ÷  ߰
//	pMoveOK->CharacterMode0	= pOtherSock->m_character.CharacterMode;
	pMoveOK->moveBitFlag	= pOtherSock->Get_MSG_FC_MOVE_BIT_FLAG();	
	pMoveOK->PositionVector	= pOtherSock->m_character.PositionVector;
	pMoveOK->TargetVector	= pOtherSock->m_character.TargetVector*1000.0f;
	pMoveOK->UpVector		= pOtherSock->m_character.UpVector;

	SendAddData(pMoveOKBuf, MSG_SIZE(MSG_FC_MOVE_OK));

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_GUILD_GET_MAP_OWNER_INFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_GUILD_GET_MAP_OWNER_INFO,
									MSG_FC_GUILD_GET_MAP_OWNER_INFO, pMsgGetOwnerInfo);

// 2008-08-27 by cmkwon,  Procedure  -  ʴ κ
// 	MAP_OWNERSHIP	mapOwnership;
// 
// 	ms_pFieldIOCP->m_MapOwnershipManager.GetMapOwnership(pMsgGetOwnerInfo->MapIndex, &mapOwnership);
// 
// 	INIT_MSG_WITH_BUFFER(MSG_FC_GUILD_GET_MAP_OWNER_INFO_OK, T_FC_GUILD_GET_MAP_OWNER_INFO_OK, pGetOK, pGetOKBuf);
// 	STRNCPY_MEMSET(pGetOK->DefenderGuildName, mapOwnership.OwnerGuildName, SIZE_MAX_GUILD_NAME);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_GUILD_GET_WAR_INFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_GUILD_GET_WAR_INFO,
									MSG_FC_GUILD_GET_WAR_INFO, pMsgGetWarInfo);

	INIT_MSG_WITH_BUFFER(MSG_FC_GUILD_GET_WAR_INFO_OK, T_FC_GUILD_GET_WAR_INFO_OK, pGetOK, pGetOKBuf);

	ms_pFieldIOCP->m_GuildWarManager.LockGuildWarManager();	
	{
		CGuildWar *pGuildWar = ms_pFieldIOCP->m_GuildWarManager.FindGuildWarPtr(pMsgGetWarInfo->GuildUID);
		if (pGuildWar == NULL)
		{
			ms_pFieldIOCP->m_GuildWarManager.UnlockGuildWarManager();
			return RES_BREAK;
		}	
		pGetOK->MapChannel		= pGuildWar->GetMapChannelIndex();
		pGetOK->PeerGuildUID	= pGuildWar->GetPeerGuildForGuildWar(m_character.GuildUniqueNumber)->uidGuildUID;
	}
	ms_pFieldIOCP->m_GuildWarManager.UnlockGuildWarManager();

	SendAddData(pGetOKBuf, MSG_SIZE(MSG_FC_GUILD_GET_WAR_INFO_OK));
	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_GUILD_SUMMON_MEMBER_OK(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_GUILD_SUMMON_MEMBER_OK,
									MSG_FC_GUILD_SUMMON_MEMBER_OK, pRSummonOK);

	if(CS_PLAYING != this->GetClientState()
		|| COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_DEAD_MASK))
	{
		SendErrorMessage(T_FC_GUILD_SUMMON_MEMBER_OK, ERR_PROTOCOL_CANNOT_WARP_INVALID_STATE);
		return RES_BREAK;
	}

	CFieldMapChannel *pFMChann = ms_pFieldIOCP->GetFieldMapChannelByMapChannelIndex(pRSummonOK->MapChannel);
	if(NULL == pFMChann)
	{
		return RES_BREAK;
	}
	
	INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_USE_CARDITEM_GUILDSUMMON_NOTIFY, T_FC_ITEM_USE_CARDITEM_GUILDSUMMON_NOTIFY, pSNotify, SendBuf);
	pSNotify->guildSummonClientIdx		= this->GetCharacter()->ClientIndex;
	ms_pFieldIOCP->SendInRangeMessageAroundPosition(this->GetCharacter()->PositionVector
		, SendBuf, MSG_SIZE(MSG_FC_ITEM_USE_CARDITEM_GUILDSUMMON_NOTIFY), this->GetCurrentFieldMapChannel());	

	D3DXVECTOR3 tmVec3Pos(pRSummonOK->PositionVector.x, pRSummonOK->PositionVector.y, pRSummonOK->PositionVector.z);
	EventResult_t ret = WarpToMap(pRSummonOK->MapChannel, &tmVec3Pos);
	if (ret == EVENT_RESULT_BREAK)
	{
#ifdef _DEBUG
		DBGOUT(STRERR_S_F2NOTIFY_0013,
			pRSummonOK->MapChannel.MapIndex, GetCharacterString(&m_character, string()));
#endif
	}

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_GUILD_DISMEMBER(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-11-12 ~ 2007-11-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_GUILD_DISMEMBER(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_GUILD_DISMEMBER,
									MSG_FC_GUILD_DISMEMBER, pMsgRequestGuildWar);

	// 2007-11-12 by dhjin, ȿ  üũ
	if(FALSE == this->IsValidCharacter()
		|| this->m_character.GuildUniqueNumber != pMsgRequestGuildWar->GuildUniqueNumber)
	{
		SendErrorMessage(T_FC_GUILD_DISMEMBER, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}	
	
	if(FALSE == ms_pFieldIOCP->m_GuildWarManager.CheckGuildCommander(m_character.CharacterUniqueNumber))
	{// 2009-06-30 by cmkwon,  üũ  
		SendErrorMessage(T_FC_GUILD_DISMEMBER, ERR_PROTOCOL_NOT_GUILD_MASTER);
		return RES_BREAK;
	}

// 2009-06-30 by cmkwon,  ü üũ  - Ʒ   .
// 	//////////////////////////////////////////////////////////////////////////
// 	// 2007-11-09 by dhjin,  Ͽ ó
// 	if(ms_pFieldIOCP->m_OutPostManager.CheckALLOutPostWaring()
// 		&& ms_pFieldIOCP->m_OutPostManager.CheckOutPostPossessByGuildUID(pMsgRequestGuildWar->GuildUniqueNumber))
// 	{
// 		SendErrorMessage(T_FC_GUILD_DISMEMBER, ERR_WARING_OUTPOST_TO_OWNMAP);
// 		return RES_BREAK;
// 	}
	///////////////////////////////////////////////////////////////////////////////
	// 2009-06-30 by cmkwon,  ü üũ  -     ü Ұ
	if(ms_pFieldIOCP->m_OutPostManager.CheckOutPostPossessByGuildUID(pMsgRequestGuildWar->GuildUniqueNumber))
	{
 		SendErrorMessage(T_FC_GUILD_DISMEMBER, ERR_POSSESS_OUTPOST);
 		return RES_BREAK;
	}
	///////////////////////////////////////////////////////////////////////////////
	// 2009-06-30 by cmkwon,  ü üũ  -       ü Ұ
	if(ms_pFieldIOCP->m_OutPostManager.CheckALLOutPostWaring()
		&& ms_pFieldIOCP->m_OutPostManager.CheckOutPostResetByGuildUID(pMsgRequestGuildWar->GuildUniqueNumber))
	{
		SendErrorMessage(T_FC_GUILD_DISMEMBER, ERR_WARING_OUTPOST_TO_OWNMAP);
		return RES_BREAK;
	}


	INIT_MSG_WITH_BUFFER(MSG_FI_GUILD_DISMEMBER, T_FI_GUILD_DISMEMBER, pSMsg, SendBuf);
	pSMsg->GuildUniqueNumber	= pMsgRequestGuildWar->GuildUniqueNumber;
	ms_pFieldIOCP->Send2IMServer(SendBuf, MSG_SIZE(MSG_FI_GUILD_DISMEMBER));		

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_GUILD_REQUEST_GUILD_WAR(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_GUILD_REQUEST_GUILD_WAR,
									MSG_FC_GUILD_REQUEST_GUILD_WAR, pMsgRequestGuildWar);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TRADE_REQUEST_TRADE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int								nRecvTypeSize;
	MSG_FC_TRADE_REQUEST_TRADE		*pMsgRequest;
	BYTE SendBuf[SIZE_MAX_PACKET];

	nRecvTypeSize = sizeof(MSG_FC_TRADE_REQUEST_TRADE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14048);
		return RES_RETURN_FALSE;
	}
	pMsgRequest = (MSG_FC_TRADE_REQUEST_TRADE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;
	
	// 2008-02-26 by dhjin, Ʒ  - Ʒ   Ұ
	if(g_pFieldGlobal->IsArenaServer())
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_CANNOT_USE_ARENASERVER);
		return RES_BREAK;
	}

	// ڽ ̹ ŷ
	if (IS_VALID_UNIQUE_NUMBER(m_peerTraderCharacterUniqueNumber))
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_PROTOCOL_ALREADY_TRADING);
		// 2008-02-12 by cmkwon,  óǸ ȵȴ.  ÿ ŷ   ׸  Ű ڵ
		//SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// ڱ ڽ Ȯ
	if (strnicmp(pMsgRequest->TradeTarget, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME) == 0)
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_COMMON_NOT_ALLOWED_TO_MYSELF, 0, 0, pMsgRequest->TradeTarget);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

// 2006-11-16 by cmkwon, ý  ʿ 
//	if(FALSE == this->IsValidGameUser())
//	{// 2006-06-14 by cmkwon, Ʈ  ó - ŷ Ұ
//		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_INVALID_GAMEUSER, 0);
//		SendTradeCanceledAndReset(NULL, FALSE);
//		return RES_BREAK;
//	}

	if(this->m_pCurrentBuildingNPC)
	{// 2006-05-11 by cmkwon, ڱ ڽ  ̿  - ŷ Ұ
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_USING_SHOP, 0, 0, m_character.CharacterName);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}
	if(BAZAAR_STATE_NONE != m_bazaarManager.GetBazaarState())
	{// 2006-07-31 by cmkwon,   üũ 
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_USING_BAZAAR, 0);
		return RES_BREAK;
	}

	// ش ĳͰ 
	CFieldIOCPSocket *pTargetSocket = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(pMsgRequest->TradeTarget);
	if (NULL == pTargetSocket
		|| FALSE == pTargetSocket->IsValidCharacter())
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_INVALID_CHARACTER, 0, 0, pMsgRequest->TradeTarget);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

// 2006-11-16 by cmkwon, ý  ʿ 
//	if(FALSE == pTargetSocket->IsValidGameUser())
//	{// 2006-06-14 by cmkwon, Ʈ  ó - ŷ Ұ
//		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_INVALID_GAMEUSER, 1);
//		SendTradeCanceledAndReset(NULL, FALSE);
//		return RES_BREAK;
//	}


// 2005-12-06 by cmkwon, Ʒ Լ üũ
//	//    ŷ   
//	// 2005-11-01 by cmkwon, GameMaster ŷ 
//	if (COMPARE_RACE(m_character.Race, RACE_DEMO|RACE_GUEST|RACE_MONITOR|RACE_GAMEMASTER)
//		|| COMPARE_RACE(pTargetSocket->m_character.Race, RACE_DEMO|RACE_GUEST|RACE_MONITOR|RACE_GAMEMASTER)
//	)
//	{
//		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0082);
//		SendTradeCanceledAndReset(NULL, FALSE);
//		return RES_BREAK;
//	}
	if(FALSE == GCheckRaceAndInfluenceType(CHECK_TYPE_TRADE, (0 == m_backupRace)?m_character.Race:m_backupRace, m_character.InfluenceType
		, (0 == pTargetSocket->m_backupRace)?pTargetSocket->GetCharacter()->Race:pTargetSocket->m_backupRace, pTargetSocket->GetCharacter()->InfluenceType))
	{// 2005-12-06 by cmkwon, Race   üũ
		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0082);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	//  ̹ ŷ
	if (IS_VALID_UNIQUE_NUMBER(pTargetSocket->m_peerTraderCharacterUniqueNumber))
	{
		m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
		m_bOKTradeChecked = FALSE;
		m_mapTradeItem.clearLock();

		INIT_MSG(MSG_FC_TRADE_REJECT_TRADING, T_FC_TRADE_REJECT_TRADING, msgRejectTrading, SendBuf);
		STRNCPY_MEMSET(msgRejectTrading->TradeTarget, pMsgRequest->TradeTarget, SIZE_MAX_CHARACTER_NAME);
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_REJECT_TRADING));

		return RES_BREAK;
	}
	if(BAZAAR_STATE_NONE != pTargetSocket->m_bazaarManager.GetBazaarState())
	{// 2006-07-31 by cmkwon,   üũ 
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_USING_BAZAAR, 1);
		return RES_BREAK;
	}

	// Ÿ ־ trade Ұ
	if (D3DXVec3Length(&(m_character.PositionVector-pTargetSocket->m_character.PositionVector)) > REQUERED_TRADE_DISTANCE)
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_PROTOCOL_TOO_FAR_TO_TRADE);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	if(pTargetSocket->m_pCurrentBuildingNPC)
	{// 2006-05-11 by cmkwon,   ̿  - ŷ Ұ
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_USING_SHOP, 0, 0, pTargetSocket->m_character.CharacterName);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_TRADE_REQUEST_TRADE û ڽ/ 2н üũ
	if(FALSE == this->CheckSecondaryPasswordLock()
		|| FALSE == pTargetSocket->CheckSecondaryPasswordLock())
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_SECPASS_LOCKED, 0);
		return RES_BREAK;
	}

	// ִ  Ȯ
	// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
	if (m_ItemManager.GetInventoryItemCounts() >= m_ItemManager.GetMaxInventoryCount())
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, m_ItemManager.GetMaxInventoryCount());
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	if (pTargetSocket->m_ItemManager.GetInventoryItemCounts() >= pTargetSocket->m_ItemManager.GetMaxInventoryCount())
	{
		SendErrorMessage(T_FC_TRADE_REQUEST_TRADE, ERR_PROTOCOL_INVENTORY_FULL_ITEM, 0, pTargetSocket->m_ItemManager.GetMaxInventoryCount());
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	//  ŷڸ setting (ÿ ŷ · ٲ)
	m_peerTraderCharacterUniqueNumber = pTargetSocket->m_character.CharacterUniqueNumber;
	pTargetSocket->m_peerTraderCharacterUniqueNumber = m_character.CharacterUniqueNumber;

	// MSG_FC_TRADE_REQUEST_TRADE_OK 
	INIT_MSG(MSG_FC_TRADE_REQUEST_TRADE_OK, T_FC_TRADE_REQUEST_TRADE_OK, msgRequestOK, SendBuf);
	STRNCPY_MEMSET(msgRequestOK->TradeSource, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	msgRequestOK->TradeSourceCharacterUniqueNumber = m_character.CharacterUniqueNumber;

	pTargetSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_REQUEST_TRADE_OK));

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TRADE_CANCEL_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize;
	MSG_FC_TRADE_CANCEL_REQUEST	*pMsgCancelRequest;
	BYTE SendBuf[SIZE_MAX_PACKET];

	nRecvTypeSize = sizeof(MSG_FC_TRADE_CANCEL_REQUEST);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_TRADE_CANCEL_REQUEST, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1404A);
		return RES_RETURN_FALSE;
	}
	pMsgCancelRequest = (MSG_FC_TRADE_CANCEL_REQUEST*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	if (!IS_VALID_UNIQUE_NUMBER(m_peerTraderCharacterUniqueNumber))
	{
		SendErrorMessage(T_FC_TRADE_CANCEL_REQUEST, ERR_PROTOCOL_TRADE_NOT_STARTED);
		return RES_BREAK;
	}

	CFieldIOCPSocket *pTargetSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
	if (NULL == pTargetSocket)
	{
		SendErrorMessage(T_FC_TRADE_CANCEL_REQUEST, ERR_COMMON_NO_SUCH_CHARACTER);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	if (strcmp(pMsgCancelRequest->TradeTarget, pTargetSocket->GetCharacter()->CharacterName) != 0)
	{
		SendErrorMessage(T_FC_TRADE_CANCEL_REQUEST, ERR_PROTOCOL_PEER_TRADER_NOT_MATCHED);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	INIT_MSG(MSG_FC_TRADE_CANCEL_REQUEST_OK, T_FC_TRADE_CANCEL_REQUEST_OK, msgCancelRequestOK, SendBuf);
	STRNCPY_MEMSET(msgCancelRequestOK->TradeSource, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	msgCancelRequestOK->TradeSourceCharacterUniqueNumber = m_character.CharacterUniqueNumber;

	pTargetSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_CANCEL_REQUEST_OK));

	// ŷ reset
	m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
	m_bOKTradeChecked = FALSE;
	m_mapTradeItem.clearLock();
	pTargetSocket->m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
	pTargetSocket->m_bOKTradeChecked = FALSE;
	pTargetSocket->m_mapTradeItem.clearLock();


	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TRADE_ACCEPT_TRADE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize;
	MSG_FC_TRADE_ACCEPT_TRADE	*pMsgAccept;
	BYTE SendBuf[SIZE_MAX_PACKET];

	nRecvTypeSize = sizeof(MSG_FC_TRADE_ACCEPT_TRADE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_TRADE_ACCEPT_TRADE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1404B);
		return RES_RETURN_FALSE;
	}
	pMsgAccept = (MSG_FC_TRADE_ACCEPT_TRADE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	// ŷ û  ٸ
	if (pMsgAccept->TradeSourceCharacterUniqueNumber != m_peerTraderCharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_TRADE_ACCEPT_TRADE, ERR_PROTOCOL_PEER_TRADER_NOT_MATCHED);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// ش ĳͰ  , ӿ ƨų    
	CFieldIOCPSocket *pSourceSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
	if (NULL == pSourceSocket
		|| FALSE == pSourceSocket->IsValidCharacter())
	{
		SendErrorMessage(T_FC_TRADE_ACCEPT_TRADE, ERR_COMMON_NO_SUCH_CHARACTER);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// Send MSG_FC_TRADE_ACCEPT_TRADE_OK
	INIT_MSG(MSG_FC_TRADE_ACCEPT_TRADE_OK, T_FC_TRADE_ACCEPT_TRADE_OK, msgAcceptOK, SendBuf);
	STRNCPY_MEMSET(msgAcceptOK->TradeTarget, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	msgAcceptOK->TradeTargetCharacterUniqueNumber = m_character.CharacterUniqueNumber;

	pSourceSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_ACCEPT_TRADE_OK));

	// Send MSG_FC_TRADE_SHOW_TRADE_WINDOW
	INIT_MSG(MSG_FC_TRADE_SHOW_TRADE_WINDOW, T_FC_TRADE_SHOW_TRADE_WINDOW, msgShowWindow, SendBuf);
	// To Source
	msgShowWindow->PeerTradeCharacterUniqueNumber = m_character.CharacterUniqueNumber;
	pSourceSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_SHOW_TRADE_WINDOW));
	// To Target
	msgShowWindow->PeerTradeCharacterUniqueNumber = pSourceSocket->m_character.CharacterUniqueNumber;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_SHOW_TRADE_WINDOW));

	// set lock
	m_pCurrentLockTrade = &(pSourceSocket->m_lockTrade);
	pSourceSocket->m_pCurrentLockTrade = &(pSourceSocket->m_lockTrade);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TRADE_REJECT_TRADE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize;
	MSG_FC_TRADE_REJECT_TRADE	*pMsgReject;
	BYTE SendBuf[SIZE_MAX_PACKET];

	nRecvTypeSize = sizeof(MSG_FC_TRADE_REJECT_TRADE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_TRADE_REJECT_TRADE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1404C);
		return RES_RETURN_FALSE;
	}
	pMsgReject = (MSG_FC_TRADE_REJECT_TRADE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	// ŷ û  ٸ
	if (pMsgReject->TradeSourceCharacterUniqueNumber != m_peerTraderCharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_TRADE_REJECT_TRADE, ERR_PROTOCOL_PEER_TRADER_NOT_MATCHED);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// ش ĳͰ  , ӿ ƨų    
	CFieldIOCPSocket *pSourceSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
	if (NULL == pSourceSocket)
	{
		SendErrorMessage(T_FC_TRADE_REJECT_TRADE, ERR_COMMON_NO_SUCH_CHARACTER);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	INIT_MSG(MSG_FC_TRADE_REJECT_TRADE_OK, T_FC_TRADE_REJECT_TRADE_OK, msgRejectOK, SendBuf);
	STRNCPY_MEMSET(msgRejectOK->TradeTarget, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	msgRejectOK->TradeTargetCharacterUniqueNumber = m_character.CharacterUniqueNumber;

	pSourceSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_REJECT_TRADE_OK));

	// ŷ reset
	m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
	m_bOKTradeChecked = FALSE;
	m_mapTradeItem.clearLock();
	pSourceSocket->m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
	pSourceSocket->m_bOKTradeChecked = FALSE;
	pSourceSocket->m_mapTradeItem.clearLock();

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TRADE_TRANS_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_TRADE_TRANS_ITEM,
									MSG_FC_TRADE_TRANS_ITEM, pMsgTransItem);
	if (FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_INVALID_CHARACTER);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// ش ĳͰ  , ӿ ƨų    
	CFieldIOCPSocket *pPeerTraderSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
	if (NULL == pPeerTraderSocket
		|| FALSE == pPeerTraderSocket->IsValidCharacter())
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_COMMON_NO_SUCH_CHARACTER, m_peerTraderCharacterUniqueNumber);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// 2010-05-12 by cmkwon, ŷ ̿  ޸  (K0002953) - ߿ Ѹ̶ ŷ  ¸  ߰ Ұ
	if(pPeerTraderSocket->m_bOKTradeChecked)
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_CANNOT_PUT_ITEM, pPeerTraderSocket->m_bOKTradeChecked, pMsgTransItem->ItemNum);
		return RES_BREAK;
	}

	if (pMsgTransItem->CharacterUniqueNumber != m_character.CharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_INVALID_CHARACTER_UNIQUENUMBER);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_TRADE_TRANS_ITEM û ڽ/ 2н üũ
	if(FALSE == this->CheckSecondaryPasswordLock()
		|| FALSE == pPeerTraderSocket->CheckSecondaryPasswordLock())
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_SECPASS_LOCKED);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	// lock m_mapItemGeneral, MSG_FC_TRADE_TRANS_ITEM
	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);

	if(this->m_bOKTradeChecked)
	{// 2008-11-21 by cmkwon, ŷ  Ȯ ý  - ŷ  ̸  ߰ Ҽ .  
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_CANNOT_PUT_ITEM, this->m_bOKTradeChecked, pMsgTransItem->ItemNum);
		return RES_BREAK;
	}

	ITEM_GENERAL *pItem = m_ItemManager.GetItemGeneralByUID(pMsgTransItem->ItemUniqueNumber);
	if (NULL == pItem)
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2008-07-22 by cmkwon,   üũ(ItemUID üũ) ߰ - Process_FC_TRADE_TRANS_ITEM
	if(pItem->UniqueNumber != pMsgTransItem->ItemUniqueNumber
		|| pItem->Possess != GetCharacter()->CharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER, 1000);
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] ItemBug(%s) %s %s, %d %I64d\r\n"
			, GetProtocolTypeString(T_FC_TRADE_TRANS_ITEM), GetCharacterString(GetCharacter(), string()), GetItemGeneralString(pItem, string()), pItem->Possess, pMsgTransItem->ItemUniqueNumber);
		return RES_BREAK;
	}

	if (pMsgTransItem->ItemNum != pItem->ItemNum)
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_INVALID_ITEMNUM);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	// 2009-10-22 by cmkwon, ð   ý  - 
	//if(pItem->ItemWindowIndex < POS_INVALID_POSITION)
	if(IS_ATTACHABLE_POSITION(pItem->ItemWindowIndex))
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}

	if (COMPARE_BIT_FLAG(pItem->ItemInfo->ItemAttribute, ITEM_ATTR_NO_TRANSFER|ITEM_ATTR_KILL_MARK_ITEM|ITEM_ATTR_ACCOUNT_POSSESSION|ITEM_ATTR_TRASH_ONLY))
	{// 2007-09-17 by cmkwon,  ĳ ĳ ŷ Ұ  ߰ -    üũ ߰
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}

	if(ITEMKIND_ACCESSORY_TIMELIMIT == pItem->Kind
		&& pItem->UsingTimeStamp != ITEM_NOT_USING)
	{// 2006-06-16 by cmkwon, ̹  ۵   Ǹ/ŷ/â ̵ Ұ
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER, 1, 0);
		return RES_BREAK;
	}

	if (pMsgTransItem->Amount > pItem->CurrentCount)
	{
		SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	INT nFinalAmountOfTradeItem = 0;
	mt_auto_lock mtaTrade(&m_mapTradeItem);
	mtmapUID2TradeItem::iterator itrTrade = m_mapTradeItem.find(pMsgTransItem->ItemUniqueNumber);
	if (itrTrade != m_mapTradeItem.end())
	{// ̹ ö  
		
		if(FALSE == IS_COUNTABLE_ITEM(pItem->Kind))
		{			
			SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_ALREADY_TRADE_ITEM);
			return RES_BREAK;
		}
		if(pItem->CurrentCount < itrTrade->second.Count + pMsgTransItem->Amount)
		{// 2008-10-30 by cmkwon, Ʈ     -    üũ
			SendErrorMessage(T_FC_TRADE_TRANS_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED, pItem->CurrentCount, itrTrade->second.Count + pMsgTransItem->Amount);
			SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
			return RES_BREAK;
		}
		
		itrTrade->second.Count += pMsgTransItem->Amount;
		nFinalAmountOfTradeItem = itrTrade->second.Count;
	}
	else
	{// Trade Item Ʈ ߰

		TradeItem tradeItem;
		tradeItem.ItemUniqueNumber = pItem->UniqueNumber;
		tradeItem.Count = pMsgTransItem->Amount;
		tradeItem.pStoreItem = pItem;
		m_mapTradeItem.insertNoLock(pItem->UniqueNumber, tradeItem);
		nFinalAmountOfTradeItem = pMsgTransItem->Amount;
	}
	mtaTrade.auto_unlock_cancel();

	INIT_MSG_WITH_BUFFER(MSG_FC_TRADE_TRANS_ITEM_OK, T_FC_TRADE_TRANS_ITEM_OK, msgTransItemOK, SendBuf);
	msgTransItemOK->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
	msgTransItemOK->TradeItem = *pItem;
	msgTransItemOK->TradeItem.CurrentCount = nFinalAmountOfTradeItem;
	msgTransItemOK->NumOfEnchants = 0;	// Ʒ Ҵ
	// lock
	m_mapEnchant.lock();
	mtmapUID2EnchantVector::iterator itrEnchantList = m_mapEnchant.find(pItem->UniqueNumber);
	if (itrEnchantList != m_mapEnchant.end())
	{
		vectENCHANT &vecECH = itrEnchantList->second;
		msgTransItemOK->NumOfEnchants = vecECH.size();
		INT *ArrInchantItemNum = (INT*)(SendBuf+MSG_SIZE(MSG_FC_TRADE_TRANS_ITEM_OK));
		for (int i = 0; i < msgTransItemOK->NumOfEnchants; i++)
		{
			ArrInchantItemNum[i] = vecECH[i].EnchantItemNum;
		}
	}
	// unlock
	m_mapEnchant.unlock();
	igLock.auto_unlock_cancel();

	// Send Message
	if(pPeerTraderSocket
		&& pPeerTraderSocket->IsUsing())
	{
		
		pPeerTraderSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_TRANS_ITEM_OK) + msgTransItemOK->NumOfEnchants*sizeof(INT));
	}

		
	// 2010-06-15 by shcho&hslee ý - ŷ    
	vecPetCurrentInfo::iterator petiter = this->m_ItemManager.m_vectPetCurrentInfo.begin();
	// Ŷ 
	INIT_MSG_WITH_BUFFER(MSG_TRADE_PET_DATA, T_FC_TRADE_SEE_PET_DATA, Petcurrentmsg, sendPetbuff);

	for(;petiter != this->m_ItemManager.m_vectPetCurrentInfo.end(); ++petiter)
	{
		if( pMsgTransItem->ItemUniqueNumber == (*petiter)->CreatedPetUID ) //  ȣ   ۰    
		{
			///////////////////////////////////////////////////////////////////////////////////////
			// start 2011-08-17 by hskim, Ʈ ý 2 - ڷ  
			//
			//  
			//

// 			Petcurrentmsg->CreatedPetUID = (*petiter)->CreatedPetUID;
// 			Petcurrentmsg->EnableEditPetName = (*petiter)->EnableEditPetName;
// 			Petcurrentmsg->EnableLevelUp = (*petiter)->EnableLevelUp;
// 			Petcurrentmsg->PetExp = (*petiter)->PetExp;
// 			Petcurrentmsg->PetIndex = (*petiter)->PetIndex;
// 			Petcurrentmsg->PetLevel = (*petiter)->PetLevel;
// 			memcpy(Petcurrentmsg->szPetName,(*petiter)->szPetName,SIZE_MAX_PET_NAME);

			/////////
			// 

			Petcurrentmsg->CreatedPetUID = (*petiter)->CreatedPetUID;
			Petcurrentmsg->PetExp = (*petiter)->PetExp;
			Petcurrentmsg->PetIndex = (*petiter)->PetIndex;
			Petcurrentmsg->PetLevel = (*petiter)->PetLevel;
			memcpy(Petcurrentmsg->PetName,(*petiter)->PetName,SIZE_MAX_PET_NAME);

			// end 2011-08-17 by hskim, Ʈ ý 2 - ڷ  
			///////////////////////////////////////////////////////////////////////////////////////

			pPeerTraderSocket->SendAddData( sendPetbuff, MSG_SIZE(MSG_TRADE_PET_DATA) ); //   
			break;
		}
	}
	// END 2010-06-15 by shcho&hslee ý - ŷ    
//#ifdef _DEBUG
//	DBGOUT("\n\nProcess_FC_TRADE_TRANS_ITEM From %s...\n", m_character.CharacterName);
//
//	DBG_PRINT_ITEM();
//#endif
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TRADE_SEE_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_TRADE_SEE_ITEM,
									MSG_FC_TRADE_SEE_ITEM, pMsgSeeItem);

	// ش ĳͰ  , ӿ ƨų    
	CFieldIOCPSocket *pPeerTraderSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
	if (NULL == pPeerTraderSocket
		|| FALSE == pPeerTraderSocket->IsValidCharacter())
	{
		SendErrorMessage(T_FC_TRADE_SEE_ITEM, ERR_COMMON_NO_SUCH_CHARACTER);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2005-09-13 by cmkwon, īͺ ִ ġ 20ﰳ üũ
	if(IS_COUNTABLE_ITEM(pMsgSeeItem->ItemNum))
	{
		// lock m_mapItemGeneral, MSG_FC_TRADE_SEE_ITEM
		mt_auto_lock myigLock(&m_ItemManager.m_mapItemGeneral);
		
		INT64 tmCurrentCount = pMsgSeeItem->Amount;
		ITEM_GENERAL *pMyItem = m_ItemManager.GetFirstItemGeneralByItemNum(pMsgSeeItem->ItemNum);
		if(pMyItem){				tmCurrentCount += pMyItem->CurrentCount;}
		if(tmCurrentCount > MAX_ITEM_COUNTS)
		{
			SendErrorMessage(T_FC_TRADE_SEE_ITEM, ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER, 0, 0);
			SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
			return RES_BREAK;
		}
	}

	// lock m_mapItemGeneral, MSG_FC_TRADE_SEE_ITEM
	mt_auto_lock igLock(&pPeerTraderSocket->m_ItemManager.m_mapItemGeneral);

	TradeItem tradeItem;

	m_mapTradeItem.lock();
	mtmapUID2TradeItem::iterator itr = pPeerTraderSocket->m_mapTradeItem.find(pMsgSeeItem->ItemUniqueNumber);
	if (m_mapTradeItem.end() == itr)
	{
		m_mapTradeItem.unlock();
		SendErrorMessage(T_FC_TRADE_SEE_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM, pMsgSeeItem->ItemUniqueNumber);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}
	tradeItem = itr->second;
	m_mapTradeItem.unlock();

	//  ġ  Ȯ
	if (pMsgSeeItem->ItemUniqueNumber != tradeItem.ItemUniqueNumber || pMsgSeeItem->Amount != tradeItem.Count)
	{
		SendErrorMessage(T_FC_TRADE_SEE_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	ITEM_GENERAL *pItem = pPeerTraderSocket->m_ItemManager.GetItemGeneralByUID(pMsgSeeItem->ItemUniqueNumber);
	if (NULL == pItem)
	{
		SendErrorMessage(T_FC_TRADE_SEE_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	if (pItem->CurrentCount < pMsgSeeItem->Amount)
	{
		SendErrorMessage(T_FC_TRADE_SEE_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_TRADE_SEE_ITEM_OK, T_FC_TRADE_SEE_ITEM_OK, msgSeeOk, SendBuf);
	msgSeeOk->CharacterUniqueNumber = pPeerTraderSocket->m_character.CharacterUniqueNumber;

	int offset = MSG_SIZE(MSG_FC_TRADE_SEE_ITEM_OK);
	ITEM_GENERAL *pItemCopy = (ITEM_GENERAL*)(SendBuf + offset);

	offset += CopyItem2Buffer((char*)pItemCopy, pItem);
	pItemCopy->CurrentCount = pMsgSeeItem->Amount;

	pPeerTraderSocket->SendAddData(SendBuf, offset);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TRADE_OK_TRADE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_TRADE_OK_TRADE,
									MSG_FC_TRADE_OK_TRADE, pMsgOKTrade);

	if (FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_TRADE_OK_TRADE, ERR_INVALID_CHARACTER);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// 2008-07-18 by cmkwon,    (λ ŷÿ ̿ ϴ  ) - ŷ Ȯ û ڽ   üũ 
	if(BAZAAR_STATE_NONE != m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_TRADE_OK_TRADE, ERR_USING_BAZAAR, m_character.CharacterUniqueNumber);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// ش ĳͰ  , ӿ ƨų    
	CFieldIOCPSocket *pPeerTraderSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
	if (NULL == pPeerTraderSocket
		|| FALSE == pPeerTraderSocket->IsValidCharacter())
	{
		SendErrorMessage(T_FC_TRADE_OK_TRADE, ERR_COMMON_NO_SUCH_CHARACTER);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	// 2008-07-18 by cmkwon,    (λ ŷÿ ̿ ϴ  ) - ŷ Ȯ û    üũ 
	if(BAZAAR_STATE_NONE != pPeerTraderSocket->m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_TRADE_OK_TRADE, ERR_USING_BAZAAR, m_peerTraderCharacterUniqueNumber);
		SendTradeCanceledAndReset(NULL, FALSE);
		return RES_BREAK;
	}

	m_pCurrentLockTrade->lock();
	if (m_bOKTradeChecked == TRUE && pPeerTraderSocket->m_bOKTradeChecked == TRUE)
	{
#ifdef _DEBUG
		DBGOUT(STRERR_S_F2NOTIFY_0014, GetCharacterString(&m_character, string()));
#endif
		m_pCurrentLockTrade->unlock();
		return RES_BREAK;
	}
	m_bOKTradeChecked = TRUE;
	if (!pPeerTraderSocket->m_bOKTradeChecked)
	{
		m_pCurrentLockTrade->unlock();

		// 2008-11-21 by cmkwon, ŷ  Ȯ ý  - Ʒ  ŷ     ο 
		INIT_MSG_WITH_BUFFER(MSG_FC_TRADE_OK_TRADE_NOTIFY, T_FC_TRADE_OK_TRADE_NOTIFY, pTradeOKNotify, SendBuf);
		pTradeOKNotify->CharacterUniqueNumber	= this->GetCharacter()->CharacterUniqueNumber;
		this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_OK_TRADE_NOTIFY));
		pPeerTraderSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_OK_TRADE_NOTIFY));
		return RES_BREAK;
	}
	m_pCurrentLockTrade->unlock();

	///////////////////////////////////////////////////////////////////////////////////
	// ŷ 
	///////////////////////////////////////////////////////////////////////////////////

	// lock m_mapItemGeneral, MSG_FC_TRADE_OK_TRADE
	mt_auto_lock igLock1(&m_ItemManager.m_mapItemGeneral);
	mt_auto_lock meTILock(&m_mapTradeItem);

	// lock m_mapItemGeneral, MSG_FC_TRADE_OK_TRADE
	mt_auto_lock igLock2(&pPeerTraderSocket->m_ItemManager.m_mapItemGeneral);
	mt_auto_lock peerTILock(&pPeerTraderSocket->m_mapTradeItem);

///////////////////////////////////////////////////////////////////////////////
// 2006-05-15 by cmkwon, ŷ ý 
// 	QPARAM_EXECUTETRADE *pParam	= new QPARAM_EXECUTETRADE;
// 	pParam->pPeerTraderSocket	= pPeerTraderSocket;
// 
// 	BOOL bOuterDeleted = FALSE;		// Outer Loop itrTrd ٸ, itrTrd++  ʿ䰡 .
// 
// 	mtmapUID2TradeItem::iterator itrTrd = m_mapTradeItem.begin();
// 	while (itrTrd != m_mapTradeItem.end())
// 	{
// 		if (!IS_COUNTABLE_ITEM(itrTrd->second.pStoreItem->Kind))
// 		{
// 			itrTrd++;
// 			continue;
// 		}
// 
// 		mtmapUID2TradeItem::iterator itrTrdPeer = pPeerTraderSocket->m_mapTradeItem.begin();
// 		while (itrTrdPeer != pPeerTraderSocket->m_mapTradeItem.end())
// 		{
// 			if (!IS_COUNTABLE_ITEM(itrTrdPeer->second.pStoreItem->Kind))
// 			{
// 				itrTrdPeer++;
// 				continue;
// 			}
// 
// 			if (itrTrd->second.pStoreItem->ItemNum == itrTrdPeer->second.pStoreItem->ItemNum)
// 			{
// 				if (itrTrd->second.Count > itrTrdPeer->second.Count)
// 				{
// 					itrTrd->second.Count -= itrTrdPeer->second.Count;
// 					pPeerTraderSocket->m_mapTradeItem.erase(itrTrdPeer);
// 					break;
// 				}
// 				else if (itrTrd->second.Count < itrTrdPeer->second.Count)
// 				{
// 					itrTrdPeer->second.Count -= itrTrd->second.Count;
// 					m_mapTradeItem.erase(itrTrd++); bOuterDeleted = TRUE;
// 					break;
// 				}
// 				else if (itrTrd->second.Count == itrTrdPeer->second.Count)
// 				{
// 					m_mapTradeItem.erase(itrTrd++); bOuterDeleted = TRUE;
// 					pPeerTraderSocket->m_mapTradeItem.erase(itrTrdPeer);
// 					break;
// 				}
// 			}
// 			itrTrdPeer++;
// 		}
// 
// 		if (!bOuterDeleted) itrTrd++;	// ٸ ̹ itrTrd++ ǾǷ   ʿ .
// 		bOuterDeleted = FALSE;
// 	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-05-11 by cmkwon, ŷ  ߰  üũ
	Err_t err = this->TradeCheckEnableInsertItems(pPeerTraderSocket);
	if(ERR_NO_ERROR != err)
	{
		SendErrorMessage(T_FC_TRADE_OK_TRADE, err, 0, 0, pPeerTraderSocket->m_character.CharacterName);
		pPeerTraderSocket->SendErrorMessage(T_FC_TRADE_OK_TRADE, err, 1, 0, pPeerTraderSocket->m_character.CharacterName);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}
	err = pPeerTraderSocket->TradeCheckEnableInsertItems(this);
	if(ERR_NO_ERROR != err)
	{
		SendErrorMessage(T_FC_TRADE_OK_TRADE, err, 1, 0, this->m_character.CharacterName);
		pPeerTraderSocket->SendErrorMessage(T_FC_TRADE_OK_TRADE, err, 0, 0, this->m_character.CharacterName);
		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-05-11 by cmkwon, ŷ   ó
	this->TradeInsertItems(pPeerTraderSocket);
	pPeerTraderSocket->TradeInsertItems(this);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-05-11 by cmkwon, ŷ  ʱȭ
	this->m_peerTraderCharacterUniqueNumber	= INVALID_UNIQUE_NUMBER;
	this->m_bOKTradeChecked					= FALSE;
	this->m_mapTradeItem.clear();
	pPeerTraderSocket->m_peerTraderCharacterUniqueNumber	= INVALID_UNIQUE_NUMBER;
	pPeerTraderSocket->m_bOKTradeChecked					= FALSE;
	pPeerTraderSocket->m_mapTradeItem.clear();


	peerTILock.auto_unlock_cancel();
	meTILock.auto_unlock_cancel();
	igLock2.auto_unlock_cancel();
	igLock1.auto_unlock_cancel();

	///////////////////////////////////////////////////////////////////////////////
	// 2006-05-11 by cmkwon, ŷ Ϸ ޽ 
	INIT_MSG_WITH_BUFFER(MSG_FC_TRADE_OK_TRADE_OK, T_FC_TRADE_OK_TRADE_OK, pTradeOK, SendBuf);
	pTradeOK->CharacterUniqueNumber	= pPeerTraderSocket->GetCharacter()->CharacterUniqueNumber;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_OK_TRADE_OK));

	pTradeOK->CharacterUniqueNumber	= this->GetCharacter()->CharacterUniqueNumber;
	pPeerTraderSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_OK_TRADE_OK));

//#ifdef _DEBUG
//	DBGOUT("  ŷ   \r\n");
//	DBG_PRINT_ITEM();
//	pPeerTraderSocket->DBG_PRINT_ITEM();
//#endif // _DEBUG

// 2005-09-27 by cmkwon, ԰  ۸ ϵ 
//	// 緮 Ȯ
//	if (GetCurrentLoadagePercentage(pPeerTraderSocket->GetTradeItemWeight()) > 1.0f)
//	{
//		SendErrorMessage(T_FC_TRADE_OK_TRADE, ERR_PROTOCOL_ITEM_OVER_WEIGHT,
//							(INT)m_ItemManager.GetCurrentCarryingItemWeight()+pPeerTraderSocket->GetTradeItemWeight(),
//							(INT)CAtumSJ::GetTransport(&m_character));
//		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0083, m_character.CharacterName);
//		pPeerTraderSocket->SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0083, m_character.CharacterName);
//		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
//		return RES_BREAK;
//	}
//
//	if (pPeerTraderSocket->GetCurrentLoadagePercentage(GetTradeItemWeight()) > 1.0f)
//	{
//		pPeerTraderSocket->SendErrorMessage(T_FC_TRADE_OK_TRADE, ERR_PROTOCOL_ITEM_OVER_WEIGHT,
//											(INT)pPeerTraderSocket->m_ItemManager.GetCurrentCarryingItemWeight()+GetTradeItemWeight(),
//											(INT)CAtumSJ::GetTransport(&pPeerTraderSocket->m_character));
//		pPeerTraderSocket->SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0083, pPeerTraderSocket->m_character.CharacterName);
//		SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0083, pPeerTraderSocket->m_character.CharacterName);
//		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
//		return RES_BREAK;
//	}

// 2006-05-11 by cmkwon,  ó
// 	// check: QP_ExecuteTrade()  츮! 20030903, kelovon
// 	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ExecuteTrade, this, m_character.AccountUniqueNumber, pParam);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TRADE_CANCEL_TRADE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize;
	MSG_FC_TRADE_CANCEL_TRADE	*pMsgCancelTrade;

	nRecvTypeSize = sizeof(MSG_FC_TRADE_CANCEL_TRADE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_TRADE_CANCEL_TRADE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14052);
		return RES_RETURN_FALSE;
	}
	pMsgCancelTrade = (MSG_FC_TRADE_CANCEL_TRADE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	SendTradeCanceledAndReset(NULL, TRUE);

	return RES_RETURN_TRUE;
}

// Countdown
ProcessResult CFieldIOCPSocket::Process_FC_COUNTDOWN_DONE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize;
	MSG_FC_COUNTDOWN_DONE	*pReMsg;
	
	nRecvTypeSize = sizeof(MSG_FC_COUNTDOWN_DONE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_COUNTDOWN_DONE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14052);
		return RES_RETURN_FALSE;
	}
	pReMsg = (MSG_FC_COUNTDOWN_DONE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	if(NULL == m_pCurrentFieldMapChannel)
	{
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// ð  Ǿ üũ( ߰ؾ)
	// ERR_COUNTDOWN_NOT_ENOUGH_TIME
	if (FALSE == m_countdownChecker.IsEndedCountDown(pReMsg->byCountdownType, timeGetTime()))
	{
		SendErrorMessage(T_FC_COUNTDOWN_DONE, ERR_COUNTDOWN_NOT_ENOUGH_TIME, pReMsg->byCountdownType);
		
		INIT_MSG_WITH_BUFFER(MSG_FC_COUNTDOWN_START, T_FC_COUNTDOWN_START, pSMsg, pSendBuf);
		pSMsg->byCountdownType	= pReMsg->byCountdownType;
		pSMsg->nWaitingSecond	= SECOND_COUNTDOWN_TIME_GAP/2;
		this->SendAddData(pSendBuf, MSG_SIZE(MSG_FC_COUNTDOWN_START));
		return RES_BREAK;
	}

	switch(pReMsg->byCountdownType)
	{
	case COUNTDOWN_TYPE_P2P_WAR:
		{
			if(FALSE == m_bP2PPKStarted
				|| INVALID_CLIENT_INDEX == m_peerP2PPKClientIndex)
			{
				return RES_BREAK;
			}

			CFieldIOCPSocket *pPeerFISocket = ms_pFieldIOCP->GetFieldIOCPSocket(m_peerP2PPKClientIndex);
			if(NULL == pPeerFISocket
				|| FALSE == pPeerFISocket->IsUsing())
			{
				return RES_BREAK;
			}

			///////////////////////////////////////////////////////////////////////////////
			// ð  Ǿ üũ( ߰ؾ)

			///////////////////////////////////////////////////////////////////////////////
			// Send MSG_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK
			INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK, T_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK, pSMsg, SendBuf);
			pSMsg->PeerClientIndex = m_peerP2PPKClientIndex;
			this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK));
		}
		break;
	case COUNTDOWN_TYPE_PARTY_WAR:
		{
			CFieldParty *pMeFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
			if(NULL == pMeFParty
				|| 0 == pMeFParty->m_PeerBattleRequesterPartyID)
			{
				return RES_BREAK;
			}

			//   Ƽ  
			CFieldParty *pPeerParty = ms_pFieldIOCP->m_MapParties.findLock(pMeFParty->m_PeerBattlePartyID);
			if (pPeerParty == NULL || 0 == pPeerParty->m_PeerBattleRequesterPartyID)
			{
				SendErrorMessage(T_FC_COUNTDOWN_DONE, ERR_PROTOCOL_NO_SUCH_PARTY, LODWORD(pMeFParty->m_PeerBattlePartyID), HIDWORD(pMeFParty->m_PeerBattlePartyID));
				return RES_BREAK;
			}

			//  Ƽ üũ
			CFieldIOCPSocket *pPeerMasterSocket = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(pPeerParty->GetMasterCharacterUniqueNumber());
			if (pPeerMasterSocket == NULL || FALSE == pPeerMasterSocket->IsUsing())
			{
				SendErrorMessage(T_FC_COUNTDOWN_DONE, ERR_COMMON_NO_SUCH_CHARACTER, pPeerParty->GetMasterCharacterUniqueNumber());
				return RES_BREAK;
			}			

			// Ƽ ̵ Ȯ
			if (pMeFParty->m_PeerBattleRequesterPartyID != pPeerParty->m_PartyID
				|| pMeFParty->m_PartyID != pPeerParty->m_PeerBattleRequesterPartyID
				)
			{
				SendErrorMessage(T_FC_COUNTDOWN_DONE, ERR_PROTOCOL_PARTY_ID_NOT_MATCHED, HIDWORD(pMeFParty->m_PeerBattleRequesterPartyID), 0, m_character.CharacterName);
				return RES_BREAK;
			}

			///////////////////////////////////////////////////////////////////////////////
			// ð  Ǿ üũ( ߰ؾ)
			// ERR_COUNTDOWN_NOT_ENOUGH_TIME


			int i = 0;
			CFieldIOCPSocket *ArrayPartyMember[SIZE_MAX_PARTY_MEMBER];
			MEMSET_ZERO(ArrayPartyMember, sizeof(ArrayPartyMember[0]) * SIZE_MAX_PARTY_MEMBER);
			INIT_MSG_WITH_BUFFER(MSG_FC_PARTY_BATTLE_START, T_FC_PARTY_BATTLE_START, pSMsg, pSendBuf);
			
			// Send MSG to Target(this) Party
			pSMsg->PeerPartyID					= pMeFParty->m_PeerBattlePartyID;
			pSMsg->PeerPartyMasterClientIndex	= pPeerMasterSocket->m_character.ClientIndex;
			pSMsg->nPeerPartyMemberToBattle		= 0;
			int nMemCount = pPeerParty->GetMembersInSameMap(ArrayPartyMember, m_pCurrentFieldMapChannel);
			nMemCount = min(nMemCount, SIZE_MAX_PARTY_MEMBER);
			PEER_PARTY_MEMBER *pMember = (PEER_PARTY_MEMBER*)(pSendBuf + MSG_SIZE(MSG_FC_PARTY_BATTLE_START));
			for (i = 0; i < nMemCount; i++)
			{
				if(ArrayPartyMember[i] && ArrayPartyMember[i]->IsUsing())
				{
					pMember->ClientIndex			= ArrayPartyMember[i]->m_character.ClientIndex;
					pMember->CharacterUniqueNumber	= ArrayPartyMember[i]->m_character.CharacterUniqueNumber;
					pSMsg->nPeerPartyMemberToBattle++;
					pMember++;
				}
			}
			this->SendAddData(pSendBuf
				, MSG_SIZE(MSG_FC_PARTY_BATTLE_START) + pSMsg->nPeerPartyMemberToBattle*sizeof(PEER_PARTY_MEMBER));		
		}
		break;
	default:
		{
			SendErrorMessage(T_FC_COUNTDOWN_DONE, ERR_COUNTDOWN_INVALID_COUNTDOWN_TYPE, pReMsg->byCountdownType);
			return RES_BREAK;
		}
	}
	
	return RES_RETURN_TRUE;
}


// Object
ProcessResult CFieldIOCPSocket::Process_FC_OBJECT_CHANGE_BODYCONDITION(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_OBJECT_CHANGE_BODYCONDITION,
		MSG_FC_OBJECT_CHANGE_BODYCONDITION, pRObjChangeBodyCond);

	///////////////////////////////////////////////////////////////////////////////	
	// 2009-01-21 by cmkwon,     Ʈ Ⱥ̰ ó -  üũ
	if(FALSE == IsValidCharacter(FALSE)
		|| this->IsInvisibleCharacter())
	{
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_OBJECT_CHANGE_BODYCONDITION_OK, T_FC_OBJECT_CHANGE_BODYCONDITION_OK, pSObjBodyCond, pBuffer);
	*pSObjBodyCond = *pRObjChangeBodyCond;

	ms_pFieldIOCP->SendInRangeMessageAroundCharacter(m_character.ClientIndex, pBuffer, MSG_SIZE(MSG_FC_OBJECT_CHANGE_BODYCONDITION_OK),
													GetCurrentFieldMapChannel(), FALSE, GetCurrentFieldMapChannel()->GetUserVisibleDiameterW());	
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_AUCTION_REGISTER_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_AUCTION_REGISTER_ITEM,
		MSG_FC_AUCTION_REGISTER_ITEM, pMsgAuctionRegister);

	//     
	if (m_pCurrentBuildingNPC == NULL
		|| m_pCurrentBuildingNPC->BuildingKind != BUILDINGKIND_AUCTION)
	{
		SendErrorMessage(T_FC_AUCTION_GET_ITEM_LIST, ERR_COMMON_INVALID_BUILDINGKIND);
		return RES_BREAK;
	}

	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_AuctionRegisterItem, this, m_character.AccountUniqueNumber, NULL, NULL, pMsgAuctionRegister->ItemUID, pMsgAuctionRegister->Price);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_AUCTION_CANCEL_REGISTER(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_AUCTION_CANCEL_REGISTER,
		MSG_FC_AUCTION_CANCEL_REGISTER, pMsgCancelRegister);

	//     
	if (m_pCurrentBuildingNPC == NULL
		|| m_pCurrentBuildingNPC->BuildingKind != BUILDINGKIND_AUCTION)
	{
		SendErrorMessage(T_FC_AUCTION_CANCEL_REGISTER, ERR_COMMON_INVALID_BUILDINGKIND);
		return RES_BREAK;
	}

	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_AuctionCancelRegister, this, m_character.AccountUniqueNumber, NULL, NULL, pMsgCancelRegister->ItemUID);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_AUCTION_BUY_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_AUCTION_BUY_ITEM,
		MSG_FC_AUCTION_BUY_ITEM, pMsgAuctionBuy);

	//     
	if (m_pCurrentBuildingNPC == NULL
		|| m_pCurrentBuildingNPC->BuildingKind != BUILDINGKIND_AUCTION)
	{
		SendErrorMessage(T_FC_AUCTION_BUY_ITEM, ERR_COMMON_INVALID_BUILDINGKIND);
		return RES_BREAK;
	}

	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_AuctionBuyItem, this, m_character.AccountUniqueNumber, NULL, NULL, pMsgAuctionBuy->ItemUID);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_AUCTION_GET_ITEM_LIST(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_AUCTION_GET_ITEM_LIST,
		MSG_FC_AUCTION_GET_ITEM_LIST, pMsgAuctionGetItemList);

	//     
	if (m_pCurrentBuildingNPC == NULL
		|| m_pCurrentBuildingNPC->BuildingKind != BUILDINGKIND_AUCTION)
	{
		SendErrorMessage(T_FC_AUCTION_GET_ITEM_LIST, ERR_COMMON_INVALID_BUILDINGKIND);
		return RES_BREAK;
	}

	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_AuctionGetItemList, this, m_character.AccountUniqueNumber, NULL, NULL, pMsgAuctionGetItemList->AuctionKind, pMsgAuctionGetItemList->CharacterUID);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SKILL_USE_SKILLPOINT(const char* pPacket, int nLength, int &nBytesUsed)
{
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SKILL_SETUP_SKILL(const char* pPacket, int nLength, int &nBytesUsed)
{
	return RES_RETURN_TRUE;
}

// 2006-07-21 by cmkwon,  ߰ - ClientIndex_t i_SkillUseClientIdx
BOOL CFieldIOCPSocket::SetParamFactor(CParamFactor *i_pParamFactor, DestParam_t desParam, float paramValue, ClientIndex_t i_SkillUseClientIdx/*=0*/)		// 2011-08-01 by hskim, Ʈ ý 2 - ڷ  (DestParameter - 255 -> 32767 )
{
	//////////////////////////////////////////////////////////////////////////
	// 2006-11-27 by dhjin, 
	//if(0.0f == paramValue){						return FALSE;}		// 2006-04-24 by cmkwon

	switch (desParam)
	{	
	case DES_SP:						// 14, ҿƮ
		{
			//  ð Ŀ SP 5ŭ , UnSet ʿϴ
			m_character.CurrentSP += paramValue;
			if (m_character.CurrentSP >= m_character.SP)
			{
				m_character.CurrentSP = m_character.SP;
			}

			// MSG 
			INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_CHANGE_CURRENTSP, T_FC_CHARACTER_CHANGE_CURRENTSP, pMsgSP, pMsgSPBuf);
			pMsgSP->ClientIndex = m_character.ClientIndex;
			pMsgSP->CurrentSP = m_character.CurrentSP;
			SendAddData(pMsgSPBuf, MSG_SIZE(MSG_FC_CHARACTER_CHANGE_CURRENTSP));

			// DB 
			QPARAM_CHARACTER_CHANGE_CURRENTHPDPSPEP *pQChangeHPDPSPEP
				= new QPARAM_CHARACTER_CHANGE_CURRENTHPDPSPEP;
			pQChangeHPDPSPEP->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
			pQChangeHPDPSPEP->CurrentHP = m_character.CurrentHP;
			pQChangeHPDPSPEP->CurrentDP = m_character.CurrentDP;
			pQChangeHPDPSPEP->CurrentSP = m_character.CurrentSP;
			pQChangeHPDPSPEP->CurrentEP = m_character.CurrentEP;
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangeCurrentHPDPSPEP, this, m_character.AccountUniqueNumber, pQChangeHPDPSPEP);
		}
		break;
	case DES_MINATTACK_01:				// 18, ּ ݷ 01
		{
			i_pParamFactor->pfm_MINATTACK_01 += paramValue;
		}
		break;
	case DES_MAXATTACK_01:				// 71, ִ ݷ 01
		{
			i_pParamFactor->pfm_MAXATTACK_01 += paramValue;
		}
		break;
	case DES_MINATTACK_02:				// 19, ּ ݷ 02
		{
			i_pParamFactor->pfm_MINATTACK_02 += paramValue;
		}
		break;
	case DES_MAXATTACK_02:				// 72, ִ ݷ 02
		{
			i_pParamFactor->pfm_MAXATTACK_02 += paramValue;
		}
		break;
	case DES_ATTACKPROBABILITY_01:		// 20, Ȯ 01
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_ATTACKPROBABILITY_01 += ((Prob256_t)paramValue);
			i_pParamFactor->pfp_ATTACKPROBABILITY_01 += paramValue;
		}
		break;
	case DES_ATTACKPROBABILITY_02:		// 21, Ȯ 02
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_ATTACKPROBABILITY_02 += ((Prob256_t)paramValue);
			i_pParamFactor->pfp_ATTACKPROBABILITY_02 += paramValue;
		}
		break;
	case DES_DEFENSE_01:				// 22,  01
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_DEFENSE_01 += ((Prob256_t)paramValue);
			i_pParamFactor->pfp_DEFENSE_01 += paramValue;
		}
		break;
	case DES_DEFENSE_02:				// 23,  02
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_DEFENSE_02 += ((Prob256_t)paramValue);
			i_pParamFactor->pfp_DEFENSE_02 += paramValue;
		}
		break;
	case DES_DEFENSEPROBABILITY_01:		// 24, Ȯ 01
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_DEFENSEPROBABILITY_01 += ((Prob256_t)paramValue);
			i_pParamFactor->pfp_DEFENSEPROBABILITY_01 += paramValue;
		}
		break;
	case DES_DEFENSEPROBABILITY_02:		// 25, Ȯ 02
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_DEFENSEPROBABILITY_02 += ((Prob256_t)paramValue);
			i_pParamFactor->pfp_DEFENSEPROBABILITY_02 += paramValue;
		}
		break;	
	case DES_REATTACKTIME_01:			// 31, (*) Ÿ 01
		{
			i_pParamFactor->pfm_REATTACKTIME_01 += paramValue;
		}
		break;
	case DES_REATTACKTIME_02:			// 32, (*) Ÿ 02
		{
			i_pParamFactor->pfm_REATTACKTIME_02 += paramValue;
		}
		break;	
	case DES_RANGE_01:					// 35, (*) ȿŸ 01
		{
			i_pParamFactor->pfm_RANGE_01 += paramValue;
		}
		break;
	case DES_RANGE_02:					// 36, (*) ȿŸ 02
		{
			i_pParamFactor->pfm_RANGE_02 += paramValue;
		}
		break;	
	case DES_EXPLOSIONRANGE_01:			// 40, ߹ݰ 01
		{
			// , Primary  ش  , 20040909, kelovon
			i_pParamFactor->pfp_EXPLOSIONRANGE_01 += paramValue;
		}
		break;
	case DES_EXPLOSIONRANGE_02:			// 67, ߹ݰ 02
		{
			// Secondary ⿡ ش
			i_pParamFactor->pfp_EXPLOSIONRANGE_02 += paramValue;
		}
		break;
	case DES_SHOTNUM_01:				// 44,   ߻  01
		{
			i_pParamFactor->pfp_SHOTNUM_01 += (INT)paramValue;
		}
		break;
	case DES_SHOTNUM_02:				// 69,   ߻  02
		{
			i_pParamFactor->pfp_SHOTNUM_02 += (INT)paramValue;
		}
		break;
	case DES_MULTINUM_01:				// 45,  ߻  01
		{
			i_pParamFactor->pfp_MULTINUM_01 += (INT)paramValue;
		}
		break;
	case DES_MULTINUM_02:				// 70,  ߻  02
		{
			i_pParamFactor->pfp_MULTINUM_02 += (INT)paramValue;
		}
		break;	
	case DES_IMMEDIATE_HP_UP:			// 59, ,  HP  VALUEŭ ÷
		{
			////////////////////////////////////////////////////////////////////////////////
			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
			if(!this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_MON_FREEZE_HP)) {
				//  ų ߿ HP,DP,SP ȸ Ұ
				this->ChangeCurrentHP(paramValue, DAMAGE_BY_NA, i_SkillUseClientIdx);
			}
		}
		break;
	case DES_IMMEDIATE_DP_UP:
		{
			////////////////////////////////////////////////////////////////////////////////
			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
			if(!this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_MON_FREEZE_DP)) {
				//  ų ߿ HP,DP,SP ȸ Ұ
				this->ChangeCurrentDP(paramValue, i_SkillUseClientIdx);	
			}
		}
		break;
	case DES_IMMEDIATE_SP_UP:
		{
			////////////////////////////////////////////////////////////////////////////////
			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
			if(!this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_MON_FREEZE_SP)) {
				//  ų ߿ HP,DP,SP ȸ Ұ
				this->ChangeCurrentSP(paramValue);
			}
		}
		break;
	case DES_IMMEDIATE_EP_UP:
		{
			this->ChangeCurrentEP(paramValue);
		}
		break;
	case DES_REACTION_RANGE:
		{
			i_pParamFactor->pfp_REACTION_RANGE += ((Prob256_t)paramValue);
		}
		break;
	case DES_SKILL_REDUCE_SHIELD_DAMAGE:	// 121, 忡   ٿش, 2005-11-21 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_REDUCE_SHIELD_DAMAGE += paramValue;
		}
		break;
	case DES_SKILL_COLLISIONDAMAGE_DOWN:	// 140,  Ʈ,ٴ 浹  ҽŲ, 2005-11-21 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_COLLISIONDAMAGE_DOWN += paramValue;
		}
		break;
	case DES_SKILL_SMARTSP:					// 148, ڽ ϴ  ų 뷮 ٿش.(*), 2005-11-24 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_SMARTSP += paramValue;
		}
		break;

	case DES_RANGEANGLE_01:			// 37, ȿ 01
		{
			i_pParamFactor->pfp_RANGEANGLE_01 += paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_RANGEANGLE_02:			// 38, ȿ 02
		{
			i_pParamFactor->pfp_RANGEANGLE_02 += paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_TIME_01:				// 48,  ð 01
		{
			i_pParamFactor->pfm_TIME_01	+= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_TIME_02:				// 49,  ð 02
		{
			i_pParamFactor->pfm_TIME_02	+= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_SKILL_REACTIONSPEED:				// 154, (*) (ӵ),  ó ʿ, 2005-12-02 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_REACTIONSPEED += paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_SKILL_ENGINEANGLE:					// 155, (*) (ȸ),  ó ʿ, 2005-12-02 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_ENGINEANGLE += paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_SKILL_ENGINEBOOSTERANGLE:			// 156, (*) (ν ȸ),  ó ʿ, 2005-12-02 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_ENGINEBOOSTERANGLE += paramValue;		// 2005-12-21 by cmkwon
		}
		break;

// 2005-12-02 by cmkwon
//	case DES_SKILL_HYPERMOVING:				// 132, 2005-11-28 by cmkwon -  ü ̵ӵ , ν   ʴ´.(*),  ó ʿ, 2005-11-28 by cmkwon
//		break;
//	case DES_SKILL_SLOWMOVING:					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Debuff üũ ó // 138,   ϰ Ѵ.(̵ִ ӵ, ν ӵ, ̵ , ν ̵ )(*),  ó ʿ, 2005-11-26 by cmkwon
	case DES_SKILL_REVERSEENGINE:				// 145,   ϰ Ѵ,  ó ʿ, 2005-11-26 by cmkwon
	case DES_SKILL_SUMMON_FORMATION_MEMBER:		// 149,   1 ȯѴ,  ó ʿ, 2005-11-24 by cmkwon
		break;
// 2006-03-30 by cmkwon
	case DES_DROP_EXP:					// 157, 2006-03-30 by cmkwon - ġ, ̾ ø Ұ
		{
			i_pParamFactor->pfm_DROP_EXP					+= paramValue;
		}
		break;
	case DES_DROP_SPI:					// 158, 2006-03-30 by cmkwon - SPI, ̾ ø Ұ
		{
			i_pParamFactor->pfm_DROP_SPI					+= paramValue;
		}
		break;
	case DES_DROP_ITEM:					// 159, 2006-03-30 by cmkwon -  , ̾ ø Ұ
		{
			i_pParamFactor->pfm_DROP_ITEM					+= paramValue;
		}
		break;
	case DES_RARE_ITEM_DROP_RATE:		// 238,2010-11-30 by shcho,   Ȯ   
		{
			i_pParamFactor->pfm_DROP_RAREITEM				+= paramValue;
		}
		break;
	case DES_HP_REPAIR_RATE_FLIGHTING:	// 160, 2006-03-30 by cmkwon -  HP ȸ
		{
			////////////////////////////////////////////////////////////////////////////////
			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
			if(!this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_MON_FREEZE_HP)) {
				//  ų ߿ HP,DP,SP ȸ Ұ
				i_pParamFactor->pfm_HP_REPAIR_RATE_FLIGHTING	+= paramValue;
				this->m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_HP);	// 2006-04-12 by cmkwon, HP ȸ 			
			}
		}
		break;
	case DES_DP_REPAIR_RATE:			// 161, 2006-03-30 by cmkwon - DP ȸ
		{
			////////////////////////////////////////////////////////////////////////////////
			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
			if(!this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_MON_FREEZE_DP)) {
				//  ų ߿ HP,DP,SP ȸ Ұ
				i_pParamFactor->pfm_DP_REPAIR_RATE				+= paramValue;
				this->m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_DP);	// 2006-04-12 by cmkwon, DP ȸ 						
			}
		}
		break;
	case DES_SP_REPAIR_RATE:			// 162, 2006-03-30 by cmkwon - SP ȸ
		{
			////////////////////////////////////////////////////////////////////////////////
			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
			if(!this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_MON_FREEZE_SP)) {
				//  ų ߿ HP,DP,SP ȸ Ұ
				i_pParamFactor->pfm_SP_REPAIR_RATE				+= paramValue;
				this->m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_SP);	// 2006-04-12 by cmkwon, SP ȸ 			
			}
		}
		break;
	case DES_SKILL_ROLLING_TIME:		// 170, 2006-11-17 by dhjin - 30ʰ Ѹ  ð 
		{
			// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
			//i_pParamFactor->pfb_SKILL_ROLLING_TIME		=	TRUE;
			i_pParamFactor->pfb_BitFlag.pfb_SKILL_ROLLING_TIME	= TRUE;
		}
		break;
	case DES_SKILL_BARRIER:				// 173, 2006-11-17 by dhjin - A ޹⿡  ų
		{
			// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
			//i_pParamFactor->pfb_SKILL_Barrier			=	TRUE;
			i_pParamFactor->pfb_BitFlag.pfb_SKILL_Barrier	= TRUE;
		}
		break;
 	case DES_SKILL_SHIELD_PARALYZE:		// 175, 2006-11-24 by dhjin - A 帶 ų,   ȸ 0 
 		{	// 2009-09-09 ~ 2010-02-18 by dhjin, ǴƼ - Debuff üũ ߰
 			// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
 			//i_pParamFactor->pfb_SKILL_SHIELD_PARALYZE	=	TRUE;
 			i_pParamFactor->pfb_BitFlag.pfb_SKILL_SHIELD_PARALYZE	= TRUE;
 		}
 		break;
	case DES_SKILL_INVINCIBLE:			// 122, 2006-11-24 by dhjin - 
		{																											 
			// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
			//i_pParamFactor->pfb_SKILL_Invincible		=	TRUE;
			i_pParamFactor->pfb_BitFlag.pfb_SKILL_Invincible		=	TRUE;
		}
		break;
	case DES_INVISIBLE:					// 131, 2006-11-24 by dhjin -  μ   , ̴ٿ  ʴ´.
		{
			m_UnitRenderInfo.RI_Invisible		=	TRUE;
			INIT_MSG_WITH_BUFFER(MSG_FN_CHARACTER_CHANGE_INVISIBLE, T_FN_CHARACTER_CHANGE_INVISIBLE, pSMsg, BufSend);
			pSMsg->ChannelIndex		= m_pCurrentFieldMapChannel->GetMapChannelIndex().ChannelIndex;
			pSMsg->ClientIndex		= m_character.ClientIndex;
			pSMsg->bInvisible		= m_UnitRenderInfo.RI_Invisible;
			m_pCurrentFieldMapChannel->Send2NPCServerW(BufSend, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_INVISIBLE));
		}
		break;
	// 2013-05-09 by hskim,  Ʈ 
	case DES_CASH_STEALTH:				// 108, ڽ ī
		{
			m_bStealthStateBySkill		=	TRUE;
			INIT_MSG_WITH_BUFFER(MSG_FN_CHARACTER_CHANGE_STEALTHSTATE, T_FN_CHARACTER_CHANGE_STEALTHSTATE, pSMsg, BufSend);
			pSMsg->ChannelIndex		= m_pCurrentFieldMapChannel->GetMapChannelIndex().ChannelIndex;
			pSMsg->ClientIndex		= m_character.ClientIndex;
			pSMsg->bStealthState2	= this->GetStealthState();
			m_pCurrentFieldMapChannel->Send2NPCServerW(BufSend, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_STEALTHSTATE));
		}
		break;
	// end 2013-05-09 by hskim,  Ʈ 
	case DES_SKILL_CAMOUFLAGE:			// 172, 2006-11-24 by dhjin - A  ų
		{
			m_UnitRenderInfo.RI_Invisible		=	TRUE;
			INIT_MSG_WITH_BUFFER(MSG_FN_CHARACTER_CHANGE_INVISIBLE, T_FN_CHARACTER_CHANGE_INVISIBLE, pSMsg, BufSend);
			pSMsg->ChannelIndex		= m_pCurrentFieldMapChannel->GetMapChannelIndex().ChannelIndex;
			pSMsg->ClientIndex		= m_character.ClientIndex;
			pSMsg->bInvisible		= m_UnitRenderInfo.RI_Invisible;
			m_pCurrentFieldMapChannel->Send2NPCServerW(BufSend, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_INVISIBLE));
		}
		break;
	case DES_WARHEAD_SPEED:				// 176, 2007-06-11 by cmkwon, ź ӵ
		{
			i_pParamFactor->pfm_WARHEAD_SPEED		+= paramValue;
		}
		break;
	case DES_HP:						// 13, // 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::SetParamFactor()  ó ߰
		{
			i_pParamFactor->pfp_HP					+= paramValue;	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
//			this->ChangeHP(GetCharacterTotalHP());		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::SetParamFactor()  ó ߰ 
		}
		break;
	case DES_DP:						// 89, // 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::SetParamFactor()  ó ߰
		{
			i_pParamFactor->pfp_DP					+= paramValue;	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
//			this->ChangeDP(GetCharacterTotalDP());		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::SetParamFactor()  ó ߰ 
		}
		break;
	case DES_EP:						// 15, // 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::SetParamFactor()  ó ߰
		{
			i_pParamFactor->pfp_EP					+= paramValue;	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
//			this->ChangeEP(GetCharacterTotalEP());		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::SetParamFactor()  ó ߰ 
		}
		break;
	case DES_MAX_SP_UP:
		{
			// 2010-08-26 by shcho&jsKim,    - Set
			i_pParamFactor->pfp_SP					+= paramValue;
		}
		break;	
	// 2008-09-22 by dhjin, ű þƮ
	case DES_ENGINE_BOOSTER_TIME_UP:
		{
			i_pParamFactor->pfn_ENGINE_BOOSTER_TIME_UP += paramValue;
		}
		break;
	case DES_ENGINE_MAX_SPEED_UP:
		{
			i_pParamFactor->pfn_ENGINE_MAX_SPEED_UP += paramValue;
		}
		break;
	case DES_ENGINE_MIN_SPEED_UP:
		{
			i_pParamFactor->pfn_ENGINE_MIN_SPEED_UP += paramValue;
		}
		break;
	case DES_ENGINE_BOOSTER_SPEED_UP:
		{
			i_pParamFactor->pfn_ENGINE_BOOSTER_SPEED_UP += paramValue;
		}
		break;
	case DES_ENGINE_GROUND_SPEED_UP:
		{
			i_pParamFactor->pfn_ENGINE_GROUND_SPEED_UP += paramValue;
		}
		break;
	case DES_RADAR_OBJECT_DETECT_RANGE:
		{
			i_pParamFactor->pfn_RADAR_OBJECT_DETECT_RANGE += (INT)paramValue;
		}
		break;
	case DES_PIERCE_UP_01:
		{
			i_pParamFactor->pfm_PIERCE_UP_01			+= paramValue;
		}
		break;
	case DES_PIERCE_UP_02:
		{
			i_pParamFactor->pfm_PIERCE_UP_02			+= paramValue;
		}
		break;
	case DES_ENGINE_ANGLE_UP:
		{
			i_pParamFactor->pfm_ENGINE_ANGLE_UP			+= paramValue;
		}
		break;
	case DES_ENGINE_BOOSTERANGLE_UP:
		{
			i_pParamFactor->pfm_ENGINE_BOOSTERANGLE_UP	+= paramValue;
		}
		break;	
	case DES_SKILL_DAMAGE_DISTRIBUTION:		// 2009-08-03 by cmkwon, EP3-4   ų  - 
		{
			i_pParamFactor->pfb_BitFlag.pfb_SKILL_DamageDistribution	= TRUE;
		}
		break;
	case DES_ITEM_RESISTANCE:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -    üũ 
		{
			i_pParamFactor->pf_ITEM_Resistance	+= paramValue;
		}
		break;
	case DES_ITEM_ADDATTACK:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 밪 Ÿġ   üũ 
		{
			i_pParamFactor->pf_ITEM_AddAttack	+= paramValue;
		}
		break;
	case DES_ITEM_IGNOREDEFENCE:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -     üũ
		{
			i_pParamFactor->pfb_BitFlag.pfb_ITEM_IgnoreDefence	= TRUE;
		}
		break;
	case DES_ITEM_IGNOREAVOID:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ȸǷ    üũ
		{
			i_pParamFactor->pfb_BitFlag.pfb_ITEM_IgnoreAvoid	= TRUE;
		}
		break;
	case DES_ITEM_REDUCEDAMAGE:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  밪    üũ
		{
			i_pParamFactor->pf_ITEM_ReduceDamage	+= paramValue;
		}
		break;
	case DES_ITEM_ADDATTACK_SEC:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 밪 Ÿġ  ޹(⹫ з)
		{
			i_pParamFactor->pf_ITEM_AddAttack_Sec	+= paramValue;
		}
		break;
	case DES_ITEM_ONCE_RESISTANCE:		// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ -   ϰ    ߰ 
		{
			i_pParamFactor->pf_ITEM_OnceResistance	+= paramValue;
		}
		break;
	case DES_IMMEDIATE_HP_OR_DP_UP:		// 2010-03-31 by dhjin, ǴƼ() -
		{
			this->IncreaseCurrentHPDP(paramValue);
		}
		break;
	case DES_PLUS_WARPOINT_RATE:		// 2010-05-18 by cmkwon, WarPoint   (Ϻû) - 
		{
			i_pParamFactor->pfm_PLUS_WARPOINT_RATE	+= paramValue;
		}
		break;
// 2013-02-28 by bckim,  ߰
#ifdef S_ITEM_EVENT_RETURN_USER_BCKIM		// ȸ WP ȹ Ķ  
	case DES_PLUS_WARPOINT_RATE_FOR_RETURN_USER:		
		{
			i_pParamFactor->pfm_PLUS_WARPOINT_RATE	+= paramValue;
		}
		break;
#endif
// End. 2013-02-28 by bckim,  ߰
	case DES_PCROOM_USE_CARD:
		{ // 2010-06-01 by shcho, PC  ȹ(ĳ)  - 
			this->SetHomepremium(TRUE);
		}
		break;
	// 2010-12-21 by jskim,  ̵ ӵ   
	case DES_RARE_ITEM_PARTNER_SPEED:		
		{
			i_pParamFactor->pf_ITEMS_MOVE_SPEED_RATE	+= paramValue;
		}
		break;
	// end 2010-12-21 by jskim,  ̵ ӵ   

	// 2013-05-09 by hskim,  Ʈ 
	case DES_SKILL_BUFF_MON_ATTACK_POWER:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_ATTACK_POWER	+= paramValue;
		}
		break;
	case DES_SKILL_BUFF_MON_ATTACK_PROBABILITY:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_ATTACK_PROBABILITY	+= paramValue;
		}
		break;
	case DES_SKILL_BUFF_MON_ATTACK_PIERCE:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_ATTACK_PIERCE	+= paramValue;
		}
		break;
	case DES_SKILL_BUFF_MON_DEFENCE:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_DEFENCE	+= paramValue;
		}
		break;
	case DES_SKILL_BUFF_MON_DEFENCE_AVOID:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_DEFENCE_AVOID	+= paramValue;
		}
		break;
	case DES_SKILL_BUFF_PVP_ATTACK_POWER:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_ATTACK	+= paramValue;
		}
		break;
		// 2013-08-01 by jhseol,   
	case DES_SKILL_BUFF_PVP_ATTACK_PROBABILITY:
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_ATTACK_PROBABILITY	+= paramValue;
		}
		break;
	case DES_SKILL_BUFF_PVP_ATTACK_PIERCE:
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_ATTACK_PIERCE		+= paramValue;
		}
		break;
	case DES_SKILL_BUFF_PVP_DEFENCE:
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_DEFENCE				+= paramValue;
		}
		break;
	case DES_SKILL_BUFF_PVP_DEFENCE_PROBABILITY:
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_DEFENCE_PROBABILITY	+= paramValue;
		}
		break;
		// end 2013-08-01 by jhseol,   
	// end 2013-05-09 by hskim,  Ʈ 
	default:
		{
			return FALSE;
		}
	}

	return TRUE;
}

BOOL CFieldIOCPSocket::UnsetParamFactor(CParamFactor *i_pParamFactor, DestParam_t desParam, float paramValue)			// 2011-08-01 by hskim, Ʈ ý 2 - ڷ  (DestParameter - 255 -> 32767 )	
{

///////////////////////////////////////////////////////////////////////////////
// 2006-11-27 by dhjin
//	if (desParam == DES_NULL)
//	{
//		return TRUE;
//	}

	switch (desParam)
	{
	case DES_NULL:					// 0,  ĶͰ   
		{
		}
		break;
	case DES_ATTACK_PART:			// 1,  Ʈ
		{
		}
		break;
	case DES_DEFENSE_PART:			// 2,  Ʈ
		{
		}
		break;
	case DES_FUEL_PART:				// 3,  Ʈ
		{
		}
		break;
	case DES_SOUL_PART:				// 4,  Ʈ
		{
		}
		break;
	case DES_SHIELD_PART:			// 5,  Ʈ
		{
		}
		break;
	case DES_DODGE_PART:			// 6, ȸ Ʈ
		{
		}
		break;
	case DES_BODYCONDITION:			// 7, 
		{
		}
		break;
	case DES_ENDURANCE_01 :			// 8,  01
		{
		}
		break;
	case DES_ENDURANCE_02:			// 9,  02
		{
		}
		break;
	case DES_CHARGING_01:			// 10, ź 01
		{
		}
		break;
	case DES_CHARGING_02:			// 11, ź 02
		{
		}
		break;
	case DES_PROPENSITY:			// 12, 
		{
		}
		break;
	case DES_HP:					// 13, ƮƮ
		{
			m_ParamFactor.pfp_HP			-= paramValue;
// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
//			this->ChangeHP(GetCharacterTotalHP());		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::UnsetParamFactor()  ó ߰ 
		}
		break;
	case DES_DP:					// 89, // 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::UnsetParamFactor()  ó ߰
		{
			m_ParamFactor.pfp_DP			-= paramValue;
// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
//			this->ChangeDP(GetCharacterTotalDP());		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::UnsetParamFactor()  ó ߰ 
		}
		break;
	case DES_SP:					// 14, ҿƮ
		{
			// do nothing
			// UnSet ʿ!
		}
		break;
	case DES_EP:					// 15, Ʈ
		{
			m_ParamFactor.pfp_EP		-= paramValue;
// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
//			this->ChangeEP(GetCharacterTotalEP());		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::UnsetParamFactor()  ó ߰ 
		}
		break;
	case DES_MAX_SP_UP:
		{
			// 2010-08-26 by shcho&jsKim,    unSet
			m_ParamFactor.pfp_SP		-= paramValue;
		}
		break;	
	case DES_SPRECOVERY:			// 16, ҿƮȸ
		{
		}
		break;
	case DES_HPRECOVERY:			// 17, Ʈȸ
		{
		}
		break;
	case DES_MINATTACK_01:				// 18, ּ ݷ 01
		{
			i_pParamFactor->pfm_MINATTACK_01 -= paramValue;
			i_pParamFactor->pfm_MINATTACK_01 = (i_pParamFactor->pfm_MINATTACK_01 < 0.01f)?0.0f:i_pParamFactor->pfm_MINATTACK_01;
		}
		break;
	case DES_MAXATTACK_01:				// 71, ִ ݷ 01
		{
			i_pParamFactor->pfm_MAXATTACK_01 -= paramValue;
		}
		break;
	case DES_MINATTACK_02:				// 19, ּ ݷ 02
		{
			i_pParamFactor->pfm_MINATTACK_02 -= paramValue;
		}
		break;
	case DES_MAXATTACK_02:				// 72, ִ ݷ 02
		{
			i_pParamFactor->pfm_MAXATTACK_02 -= paramValue;
		}
		break;
	case DES_ATTACKPROBABILITY_01:	// 20, Ȯ 01
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_ATTACKPROBABILITY_01 -= ((Prob256_t)paramValue);
			i_pParamFactor->pfp_ATTACKPROBABILITY_01 -= paramValue;
		}
		break;
	case DES_ATTACKPROBABILITY_02:	// 21, Ȯ 02
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_ATTACKPROBABILITY_02 -= ((Prob256_t)paramValue);
			i_pParamFactor->pfp_ATTACKPROBABILITY_02 -= paramValue;
		}
		break;
	case DES_DEFENSE_01:			// 22,  01
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_DEFENSE_01 -= ((Prob256_t)paramValue);
			i_pParamFactor->pfp_DEFENSE_01 -= paramValue;
		}
		break;
	case DES_DEFENSE_02:			// 23,  02
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_DEFENSE_02 -= ((Prob256_t)paramValue);
			i_pParamFactor->pfp_DEFENSE_02 -= paramValue;
		}
		break;
	case DES_DEFENSEPROBABILITY_01:	// 24, Ȯ 01
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_DEFENSEPROBABILITY_01 -= ((Prob256_t)paramValue);
			i_pParamFactor->pfp_DEFENSEPROBABILITY_01 -= paramValue;
		}
		break;
	case DES_DEFENSEPROBABILITY_02:	// 25, Ȯ 02
		{
			// 2010-07-19 by dhjin, Ȯ  
//			i_pParamFactor->pfp_DEFENSEPROBABILITY_02 -= ((Prob256_t)paramValue);
			i_pParamFactor->pfp_DEFENSEPROBABILITY_02 -= paramValue;
		}
		break;
	case DES_SKILLPROBABILITY_01:	// 26, ųȮ 01
		{
		}
		break;
	case DES_SKILLPROBABILITY_02:	// 64, ųȮ 02
		{
		}
		break;
	case DES_FACTIONRESISTANCE_01:		// 27, Ӽ׷ 01
		{
		}
		break;
	case DES_FACTIONRESISTANCE_02:		// 65, Ӽ׷ 02
		{
		}
		break;
	case DES_SPEED:					// 28, (*) ̵ӵ
		{
		}
		break;
	case DES_TRANSPORT:				// 29, ݷ
		{
		}
		break;
	case DES_MATERIAL:				// 30, 
		{
		}
		break;
	case DES_REATTACKTIME_01:		// 31, (*) Ÿ 01
		{
			i_pParamFactor->pfm_REATTACKTIME_01 -= paramValue;
		}
		break;
	case DES_REATTACKTIME_02:		// 32, (*) Ÿ 02
		{
			i_pParamFactor->pfm_REATTACKTIME_02 -= paramValue;
		}
		break;
	case DES_ABRASIONRATE_01:		// 33,  01
		{
		}
		break;
	case DES_ABRASIONRATE_02:		// 34,  02
		{
		}
		break;
	case DES_RANGE_01:				// 35, (*) ȿŸ 01
		{
			i_pParamFactor->pfm_RANGE_01 -= paramValue;
		}
		break;
	case DES_RANGE_02:				// 36, (*) ȿŸ 02
		{
			i_pParamFactor->pfm_RANGE_02 -= paramValue;
		}
		break;
	case DES_RANGEANGLE_01:			// 37, ȿ 01
		{
			i_pParamFactor->pfp_RANGEANGLE_01 -= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_RANGEANGLE_02:			// 38, ȿ 02
		{
			i_pParamFactor->pfp_RANGEANGLE_02 -= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_MULTITAGET_01:			// 39, ƼŸ 01
		{
			//  ʿ
		}
		break;
	case DES_MULTITAGET_02:			// 66, ƼŸ 02
		{
			//  ʿ
		}
		break;
	case DES_EXPLOSIONRANGE_01:		// 40, ߹ݰ 01
		{
			// , Primary  ش  , 20040909, kelovon
			i_pParamFactor->pfp_EXPLOSIONRANGE_01 -= paramValue;
		}
		break;
	case DES_EXPLOSIONRANGE_02:		// 67, ߹ݰ 02
		{
			// Secondary ⿡ ش
			i_pParamFactor->pfp_EXPLOSIONRANGE_02 -= paramValue;
		}
		break;
	case DES_UNIT:					// 41,   (28 ~ 29   ָ  )
		{
		}
		break;
	case DES_REVISION:				// 42,   (28 ~ 29   ָ  )
		{
		}
		break;
	case DES_FACTIONPROBABILITY_01:	// 43, Ӽ  Ȯ 01
		{
		}
		break;
	case DES_FACTIONPROBABILITY_02:	// 68, Ӽ  Ȯ 02
		{
		}
		break;
	case DES_SHOTNUM_01:			// 44,   ߻  01
		{
			i_pParamFactor->pfp_SHOTNUM_01 -= (INT)paramValue;
		}
		break;
	case DES_SHOTNUM_02:			// 69,   ߻  02
		{
			//  2  ش  , 20031217, kelovon
			i_pParamFactor->pfp_SHOTNUM_02 -= (INT)paramValue;
		}
		break;
	case DES_MULTINUM_01:			// 45,  ߻  01
		{
			//  1  ش  , 20031217, kelovon
			i_pParamFactor->pfp_MULTINUM_01 -= (INT)paramValue;
		}
		break;
	case DES_MULTINUM_02:			// 70,  ߻  02
		{
			i_pParamFactor->pfp_MULTINUM_02 -= (INT)paramValue;
		}
		break;
	case DES_ATTACKTIME_01:			// 46, ó   Ÿ 01
		{
			// check: ȹ Ⱑ   , ¡ 
		}
		break;
	case DES_ATTACKTIME_02:			// 47, ó   Ÿ 02
		{
			// check: ȹ Ⱑ   , ¡ 
		}
		break;
	case DES_REACTION_RANGE:
		{
			i_pParamFactor->pfp_REACTION_RANGE -= ((Prob256_t)paramValue);
		}
		break;
	case DES_SKILL_REDUCE_SHIELD_DAMAGE:	// 121, 忡   ٿش, 2005-11-21 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_REDUCE_SHIELD_DAMAGE -= paramValue;
		}
		break;
	case DES_SKILL_COLLISIONDAMAGE_DOWN:	// 140,  Ʈ,ٴ 浹  ҽŲ, 2005-11-21 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_COLLISIONDAMAGE_DOWN -= paramValue;
		}
		break;
	case DES_SKILL_SMARTSP:					// 148, ڽ ϴ  ų 뷮 ٿش.(*), 2005-11-24 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_SMARTSP -= paramValue;
		}
		break;

	case DES_TIME_01:				// 48,  ð 01
		{
			i_pParamFactor->pfm_TIME_01	-= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_TIME_02:				// 49,  ð 02
		{
			i_pParamFactor->pfm_TIME_02	-= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_SKILL_REACTIONSPEED:				// 154, (*) (ӵ),  ó ʿ, 2005-12-02 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_REACTIONSPEED -= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_SKILL_ENGINEANGLE:					// 155, (*) (ȸ),  ó ʿ, 2005-12-02 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_ENGINEANGLE -= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
	case DES_SKILL_ENGINEBOOSTERANGLE:			// 156, (*) (ν ȸ),  ó ʿ, 2005-12-02 by cmkwon
		{
			i_pParamFactor->pfm_SKILL_ENGINEBOOSTERANGLE -= paramValue;		// 2005-12-21 by cmkwon
		}
		break;
// 2005-12-02 by cmkwon
//	case DES_SKILL_HYPERMOVING:				// 132, 2005-11-28 by cmkwon -  ü ̵ӵ , ν   ʴ´.(*),  ó ʿ, 2005-11-28 by cmkwon
//		break;
//	case DES_SKILL_SLOWMOVING:				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Debuff üũ ó	// 138, (*)  ϰ Ѵ.(̵ִ ӵ, ν ӵ, ̵ , ν ̵ ),  ó ʿ, 2005-11-26 by cmkwon
	case DES_SKILL_REVERSEENGINE:				// 145, (*)  ϰ Ѵ,  ó ʿ, 2005-11-26 by cmkwon
	case DES_SKILL_SUMMON_FORMATION_MEMBER:		// 149, (*)  1 ȯѴ,  ó ʿ, 2005-11-24 by cmkwon
		break;
// 2006-03-30 by cmkwon
	case DES_DROP_EXP:					// 157, 2006-03-30 by cmkwon - ġ, ̾ ø Ұ
		{
			i_pParamFactor->pfm_DROP_EXP = max(0.0f, i_pParamFactor->pfm_DROP_EXP - paramValue);
		}
		break;
	case DES_DROP_SPI:					// 158, 2006-03-30 by cmkwon - SPI, ̾ ø Ұ
		{
			i_pParamFactor->pfm_DROP_SPI = max(0.0f, i_pParamFactor->pfm_DROP_SPI - paramValue);
		}
		break;
	case DES_DROP_ITEM:					// 159, 2006-03-30 by cmkwon -  , ̾ ø Ұ
		{
			i_pParamFactor->pfm_DROP_ITEM = max(0.0f, i_pParamFactor->pfm_DROP_ITEM - paramValue);
		}
		break;
	case DES_RARE_ITEM_DROP_RATE:		// 238,2010-11-30 by shcho,   Ȯ   
		{
			i_pParamFactor->pfm_DROP_RAREITEM = max(0.0f, i_pParamFactor->pfm_DROP_RAREITEM - paramValue);
		}
		break;
	case DES_HP_REPAIR_RATE_FLIGHTING:	// 160, 2006-03-30 by cmkwon -  HP ȸ
		{
			i_pParamFactor->pfm_HP_REPAIR_RATE_FLIGHTING -= paramValue;			
		}
		break;
	case DES_DP_REPAIR_RATE:			// 161, 2006-03-30 by cmkwon - DP ȸ
		{
			// 2008-12-29 by cmkwon, Ϻ Arario   ð   DesParam ߰  - Ʒ  
			//i_pParamFactor->pfm_DP_REPAIR_RATE -= paramValue;
			i_pParamFactor->pfm_DP_REPAIR_RATE = max(0.0f, i_pParamFactor->pfm_DP_REPAIR_RATE - paramValue);
		}
		break;
	case DES_SP_REPAIR_RATE:			// 162, 2006-03-30 by cmkwon - SP ȸ
		{
			// 2008-12-29 by cmkwon, Ϻ Arario   ð   DesParam ߰  - Ʒ  
			//i_pParamFactor->pfm_SP_REPAIR_RATE -= paramValue;
			i_pParamFactor->pfm_SP_REPAIR_RATE = max(0.0f, i_pParamFactor->pfm_SP_REPAIR_RATE - paramValue);
		}
		break;
	case DES_SKILL_ROLLING_TIME:		// 170, 2006-11-17 by dhjin - 30ʰ Ѹ  ð 
		{
			// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
			//i_pParamFactor->pfb_SKILL_ROLLING_TIME		=	FALSE;
			i_pParamFactor->pfb_BitFlag.pfb_SKILL_ROLLING_TIME			= FALSE;
		}
		break;
	case DES_SKILL_BARRIER:				// 173, 2006-11-17 by dhjin - A ޹⿡  ų
		{
			// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
			//i_pParamFactor->pfb_SKILL_Barrier			=	FALSE;
			i_pParamFactor->pfb_BitFlag.pfb_SKILL_Barrier			= FALSE;
		}
		break;
 	case DES_SKILL_SHIELD_PARALYZE:		// 175, 2006-11-24 by dhjin - A 帶 ų,   ȸ 0 
 		{	// 2009-09-09 ~ 2010-02-18 by dhjin, ǴƼ - Debuff üũ ߰
 			// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
 			//i_pParamFactor->pfb_SKILL_SHIELD_PARALYZE	=	FALSE;
 			i_pParamFactor->pfb_BitFlag.pfb_SKILL_SHIELD_PARALYZE	= FALSE;
 		}
 		break;
	case DES_SKILL_INVINCIBLE:			// 122, 2006-11-24 by dhjin - 
		{
			// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
			//i_pParamFactor->pfb_SKILL_Invincible		=	FALSE;
			i_pParamFactor->pfb_BitFlag.pfb_SKILL_Invincible		=	FALSE;
		}
		break;
	case DES_INVISIBLE:					// 131, 2006-11-24 by dhjin -  μ   , ̴ٿ  ʴ´.
		{
			m_UnitRenderInfo.RI_Invisible		=	FALSE;
			INIT_MSG_WITH_BUFFER(MSG_FN_CHARACTER_CHANGE_INVISIBLE, T_FN_CHARACTER_CHANGE_INVISIBLE, pSMsg, BufSend);
			pSMsg->ChannelIndex		= m_pCurrentFieldMapChannel->GetMapChannelIndex().ChannelIndex;
			pSMsg->ClientIndex		= m_character.ClientIndex;
			pSMsg->bInvisible		= m_UnitRenderInfo.RI_Invisible;
			m_pCurrentFieldMapChannel->Send2NPCServerW(BufSend, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_INVISIBLE));
		}
		break;
	// 2013-05-09 by hskim,  Ʈ 
	case DES_CASH_STEALTH:				// 108, ڽ ī
		{
			m_bStealthStateBySkill		=	FALSE;
			INIT_MSG_WITH_BUFFER(MSG_FN_CHARACTER_CHANGE_STEALTHSTATE, T_FN_CHARACTER_CHANGE_STEALTHSTATE, pSMsg, BufSend);
			pSMsg->ChannelIndex		= m_pCurrentFieldMapChannel->GetMapChannelIndex().ChannelIndex;
			pSMsg->ClientIndex		= m_character.ClientIndex;
			pSMsg->bStealthState2	= this->GetStealthState();
			m_pCurrentFieldMapChannel->Send2NPCServerW(BufSend, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_STEALTHSTATE));
		}
		break;
	// end 2013-05-09 by hskim,  Ʈ 
	case DES_SKILL_CAMOUFLAGE:			// 172, 2006-11-24 by dhjin - A  ų
		{
			m_UnitRenderInfo.RI_Invisible		=	FALSE;
			INIT_MSG_WITH_BUFFER(MSG_FN_CHARACTER_CHANGE_INVISIBLE, T_FN_CHARACTER_CHANGE_INVISIBLE, pSMsg, BufSend);
			pSMsg->ChannelIndex		= m_pCurrentFieldMapChannel->GetMapChannelIndex().ChannelIndex;
			pSMsg->ClientIndex		= m_character.ClientIndex;
			pSMsg->bInvisible		= m_UnitRenderInfo.RI_Invisible;
			m_pCurrentFieldMapChannel->Send2NPCServerW(BufSend, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_INVISIBLE));
		}
		break;
	case DES_WARHEAD_SPEED:				// 176, 2007-06-11 by cmkwon, ź ӵ
		{
			i_pParamFactor->pfm_WARHEAD_SPEED		-= paramValue;
		}
		break;
	// 2008-09-22 by dhjin, ű þƮ
	case DES_ENGINE_BOOSTER_TIME_UP:
		{
			i_pParamFactor->pfn_ENGINE_BOOSTER_TIME_UP -= paramValue;
		}
		break;
	case DES_ENGINE_MAX_SPEED_UP:
		{
			i_pParamFactor->pfn_ENGINE_MAX_SPEED_UP -= paramValue;
		}
		break;
	case DES_ENGINE_MIN_SPEED_UP:
		{
			i_pParamFactor->pfn_ENGINE_MIN_SPEED_UP -= paramValue;
		}
		break;
	case DES_ENGINE_BOOSTER_SPEED_UP:
		{
			i_pParamFactor->pfn_ENGINE_BOOSTER_SPEED_UP -= paramValue;
		}
		break;
	case DES_ENGINE_GROUND_SPEED_UP:
		{
			i_pParamFactor->pfn_ENGINE_GROUND_SPEED_UP -= paramValue;
		}
		break;
	case DES_RADAR_OBJECT_DETECT_RANGE:
		{
			i_pParamFactor->pfn_RADAR_OBJECT_DETECT_RANGE -= (INT)paramValue;
		}
		break;
	case DES_PIERCE_UP_01:
		{
			i_pParamFactor->pfm_PIERCE_UP_01			-= paramValue;
		}
		break;
	case DES_PIERCE_UP_02:
		{
			i_pParamFactor->pfm_PIERCE_UP_02			-= paramValue;
		}
		break;
	case DES_ENGINE_ANGLE_UP:
		{
			i_pParamFactor->pfm_ENGINE_ANGLE_UP			-= paramValue;
		}
		break;
	case DES_ENGINE_BOOSTERANGLE_UP:
		{
			i_pParamFactor->pfm_ENGINE_BOOSTERANGLE_UP	-= paramValue;
		}
		break;
	case DES_SKILL_DAMAGE_DISTRIBUTION:		// 2009-08-03 by cmkwon, EP3-4   ų  - 
		{
			i_pParamFactor->pfb_BitFlag.pfb_SKILL_DamageDistribution	= FALSE;
		}
		break;
	case DES_ITEM_RESISTANCE:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -    üũ 
		{
			i_pParamFactor->pf_ITEM_Resistance	-= paramValue;
		}
		break;
	case DES_ITEM_ADDATTACK:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 밪 Ÿġ   üũ 
		{
			i_pParamFactor->pf_ITEM_AddAttack	-= paramValue;
		}
		break;
	case DES_ITEM_IGNOREDEFENCE:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -     üũ
		{
			i_pParamFactor->pfb_BitFlag.pfb_ITEM_IgnoreDefence	= FALSE;
		}
		break;
	case DES_ITEM_IGNOREAVOID:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ȸǷ    üũ
		{
			i_pParamFactor->pfb_BitFlag.pfb_ITEM_IgnoreAvoid	= FALSE;
		}
		break;
	case DES_ITEM_REDUCEDAMAGE:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  밪    üũ
		{
			i_pParamFactor->pf_ITEM_ReduceDamage	-= paramValue;
		}
	case DES_ITEM_ADDATTACK_SEC:		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 밪 Ÿġ  ޹(⹫ з)
		{
			i_pParamFactor->pf_ITEM_AddAttack_Sec	-= paramValue;
		}
		break;
	case DES_ITEM_ONCE_RESISTANCE:		// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ -   ϰ    ߰ 
		{
			i_pParamFactor->pf_ITEM_OnceResistance	-= paramValue;
		}
		break;
	case DES_PLUS_WARPOINT_RATE:		// 2010-05-18 by cmkwon, WarPoint   (Ϻû) - 
		{
			i_pParamFactor->pfm_PLUS_WARPOINT_RATE	-= paramValue;
		}
		break;
		// 2013-02-28 by bckim,  ߰
#ifdef S_ITEM_EVENT_RETURN_USER_BCKIM		// ȸ WP ȹ Ķ  
	case DES_PLUS_WARPOINT_RATE_FOR_RETURN_USER:		
		{
			i_pParamFactor->pfm_PLUS_WARPOINT_RATE	-= paramValue;
		}
		break;
#endif
// End. 2013-02-28 by bckim,  ߰
	case DES_PCROOM_USE_CARD:
		{// 2010-06-01 by shcho, PC  ȹ(ĳ)  - 
			this->SetHomepremium(FALSE);
		}
		break;
		// 2010-12-21 by jskim,  ̵ ӵ   
	case DES_RARE_ITEM_PARTNER_SPEED:		
		{
			i_pParamFactor->pf_ITEMS_MOVE_SPEED_RATE	-= paramValue;
		}
		break;
		// end 2010-12-21 by jskim,  ̵ ӵ   
	// 2013-05-09 by hskim,  Ʈ 
	case DES_SKILL_BUFF_MON_ATTACK_POWER:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_ATTACK_POWER	-= paramValue;
		}
		break;
	case DES_SKILL_BUFF_MON_ATTACK_PROBABILITY:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_ATTACK_PROBABILITY	-= paramValue;
		}
		break;
	case DES_SKILL_BUFF_MON_ATTACK_PIERCE:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_ATTACK_PIERCE	-= paramValue;
		}
		break;
	case DES_SKILL_BUFF_MON_DEFENCE:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_DEFENCE	-= paramValue;
		}
		break;
	case DES_SKILL_BUFF_MON_DEFENCE_AVOID:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_MON_DEFENCE_AVOID	-= paramValue;
		}
		break;
	case DES_SKILL_BUFF_PVP_ATTACK_POWER:		
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_ATTACK	-= paramValue;
		}
		break;
		// 2013-08-01 by jhseol,   
	case DES_SKILL_BUFF_PVP_ATTACK_PROBABILITY:
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_ATTACK_PROBABILITY	-= paramValue;
		}
		break;
	case DES_SKILL_BUFF_PVP_ATTACK_PIERCE:
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_ATTACK_PIERCE		-= paramValue;
		}
		break;
	case DES_SKILL_BUFF_PVP_DEFENCE:
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_DEFENCE				-= paramValue;
		}
		break;
	case DES_SKILL_BUFF_PVP_DEFENCE_PROBABILITY:
		{
			i_pParamFactor->pfp_SKILL_BUFF_PVP_DEFENCE_PROBABILITY	-= paramValue;
		}
		break;
		// end 2013-08-01 by jhseol,   
	// end 2013-05-09 by hskim,  Ʈ 
	default:
		{
			return FALSE;
		}
	}

	return TRUE;
}

// 2006-07-21 by cmkwon,  ߰ - ClientIndex_t i_SkillUseClientIdx
BOOL CFieldIOCPSocket::SetParamFactor(DestParam_t desParam, float paramValue, ClientIndex_t i_SkillUseClientIdx/*=0*/)		// 2011-08-01 by hskim, Ʈ ý 2 - ڷ  (DestParameter - 255 -> 32767 )
{
	return SetParamFactor(&this->m_ParamFactor, desParam, paramValue, i_SkillUseClientIdx);
}

BOOL CFieldIOCPSocket::UnsetParamFactor(DestParam_t desParam, float paramValue)				// 2011-08-01 by hskim, Ʈ ý 2 - ڷ  (DestParameter - 255 -> 32767 )
{
	return UnsetParamFactor(&this->m_ParamFactor, desParam, paramValue);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CParamFactor *CFieldIOCPSocket::GetParamFactor(void)
/// \brief		
/// \author		cmkwon
/// \date		2005-11-22 ~ 2005-11-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
CParamFactor *CFieldIOCPSocket::GetParamFactor(void)
{
	return &m_ParamFactor;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::CheckSKILLInvincible(void)	
/// \brief		
/// \author		dhjin
/// \date		2006-11-27 ~ 2006-11-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::CheckSKILLInvincible(void)
{
	CParamFactor *pParamFactor = this->GetParamFactor();
	// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
	//if (TRUE == pParamFactor->pfb_SKILL_Invincible)
	if (TRUE == pParamFactor->pfb_BitFlag.pfb_SKILL_Invincible)
	{
		return TRUE;
	}
	return FALSE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::CheckSKILLBarrier(void)
/// \brief		
/// \author		dhjin
/// \date		2006-11-27 ~ 2006-11-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::CheckSKILLBarrier(void)
{
	CParamFactor *pParamFactor = this->GetParamFactor();
	// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
	//if (TRUE == pParamFactor->pfb_SKILL_Barrier)
	if(pParamFactor->pfb_BitFlag.pfb_SKILL_Barrier)
	{
		return TRUE;
	}
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::CheckSKILLChainRolling(void)
/// \brief		
/// \author		dhjin
/// \date		2006-11-27 ~ 2006-11-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::CheckSKILLChainRolling(void)
{
	CParamFactor *pParamFactor = this->GetParamFactor();
	// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
	//if (TRUE == pParamFactor->pfb_SKILL_ROLLING_TIME)
	if(pParamFactor->pfb_BitFlag.pfb_SKILL_ROLLING_TIME)
	{
		return TRUE;
	}
	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsEnableRepairDP(void)
/// \brief		
/// \author		dhjin
/// \date		2006-11-27 ~ 2006-11-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsEnableRepairDP(void)
{
	CParamFactor *pParamFactor = this->GetParamFactor();
	// 2009-08-03 by cmkwon, EP3-4   ų  -  BOOL  Ʈü , Ʒ  
	//if (FALSE == pParamFactor->pfb_SKILL_SHIELD_PARALYZE)
	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010-02-18 by dhjin, ǴƼ - Debuff üũ ߰   
 	if(TRUE == pParamFactor->pfb_BitFlag.pfb_SKILL_SHIELD_PARALYZE)
 	{
 		return FALSE;
 	}
	if(TRUE == this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_SHIELD_PARALYZE)) {
		return FALSE;
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			float CFieldIOCPSocket::CalcSKILLBigBoom(void)
/// \brief		
/// \author		dhjin
/// \date		2006-11-30 ~ 2006-11-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
float CFieldIOCPSocket::CalcSKILLBigBoom(void)
{
	CParamFactor *pParamFactor = this->GetParamFactor();
	return pParamFactor->pf_SKILL_Big_Boom_damage;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-08-03 by cmkwon, EP3-4   ų  - 
/// \author		cmkwon
/// \date		2009-08-17 ~ 2009-08-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsDamageDistributionToPartyMember(void)
{
	CParamFactor *pParamFactor = this->GetParamFactor();
	return pParamFactor->pfb_BitFlag.pfb_SKILL_DamageDistribution;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::SetParamFactor_POS_ATTACHMENT(BYTE desParam, float paramValue)
/// \brief		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::SetParamFactor_POS_ATTACHMENT() ߰
/// \author		cmkwon
/// \date		2007-12-13 ~ 2007-12-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::SetParamFactor_POS_ATTACHMENT(BYTE desParam, float paramValue)
{
	if(DES_NULL == desParam)
	{
		return TRUE;	// 2007-12-13 by cmkwon, TRUE  
	}

	switch(desParam)
	{
	case DES_HP:
	case DES_DP:
	case DES_EP:
		break;
	default:// 2006-04-04 by cmkwon,  ׼ DES_HP, DES_DP, DES_EP ȿ
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Error] CFieldIOCPSocket::SetParamFactor_POS_ATTACHMENT_ invalid DES_XXX !!, DES_XX(%d) ParamValue(%4.3f)\r\n", desParam, paramValue);
			return FALSE;
		}
	}

	return this->SetParamFactor(desParam, paramValue);	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::UnsetParamFactor_POS_ATTACHMENT(BYTE desParam, float paramValue)
/// \brief		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::UnsetParamFactor_POS_ATTACHMENT() ߰
/// \author		cmkwon
/// \date		2007-12-13 ~ 2007-12-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::UnsetParamFactor_POS_ATTACHMENT(BYTE desParam, float paramValue)
{
	if(DES_NULL == desParam)
	{
		return TRUE;	// 2007-12-13 by cmkwon, TRUE  
	}

	switch(desParam)
	{
	case DES_HP:
	case DES_DP:
	case DES_EP:
		break;
	default:// 2006-04-04 by cmkwon,  ׼ DES_HP, DES_DP, DES_EP ȿ
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Error] CFieldIOCPSocket::UnsetParamFactor_POS_ATTACHMENT_ invalid DES_XXX !!, DES_XX(%d) ParamValue(%4.3f)\r\n", desParam, paramValue);
			return FALSE;
		}
	}

	return this->UnsetParamFactor(desParam, paramValue);	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			USHORT CFieldIOCPSocket::GetParamValue_POS_ATTACHMENT(BYTE desParam)
/// \brief		// 2007-12-13 by cmkwon,  Ǽ縮 ߱  - CFieldIOCPSocket::GetParamValue_POS_ATTACHMENT() ߰
/// \author		cmkwon
/// \date		2007-12-13 ~ 2007-12-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
USHORT CFieldIOCPSocket::GetParamValue_POS_ATTACHMENT(BYTE desParam)
{
	// 2010-06-15 by shcho&hslee ý
// 	if(0 == m_ItemAttachment.ItemNum
// 		|| ITEMKIND_ACCESSORY_UNLIMITED != m_ItemAttachment.Kind)
	if(0 == m_ItemAccessoryUnLimited.ItemNum
		|| ITEMKIND_ACCESSORY_UNLIMITED != m_ItemAccessoryUnLimited.Kind)
	{// 2007-12-13 by cmkwon,  üũ
		return 0;
	}

	// 2010-06-15 by shcho&hslee ý
	return (USHORT)m_ItemAccessoryUnLimited.GetParameterValue(desParam);
}

// 2010-11-12 start by khkim ޸:14() α  
BOOL CFieldIOCPSocket::ItemOptionInitialization(ITEM_GENERAL *pItemGeneral)
{
	if (NULL == pItemGeneral) 
	{						
		return FALSE; 
	}
	pItemGeneral->DesWeight			= 0.0f;
	return true;
}
// 2010-11-12 End by khkim ޸() α  

BOOL CFieldIOCPSocket::ApplyRareFix(ITEM_GENERAL *pItemGeneral)
{
	if (NULL == pItemGeneral) {						return FALSE; }

	RARE_ITEM_INFO *pRareItemInfoPrefix = ms_pFieldIOCP->GetRareItemInfo(pItemGeneral->PrefixCodeNum);
	if (pRareItemInfoPrefix != NULL
		&& COMPARE_ITEMKIND(pRareItemInfoPrefix->ReqItemKind, pItemGeneral->Kind))
	{
		for (int i = 0; i < SIZE_DES_PARAM_PER_RARE_ITEM_INFO; i++)
		{
			if (pRareItemInfoPrefix->DesParameter[i] == DES_NULL) {				break; }

			// 2006-01-24 by cmkwon,  ߷ æƮ 
			if(DES_WEIGHT_01 == pRareItemInfoPrefix->DesParameter[i] || DES_WEIGHT_02 == pRareItemInfoPrefix->DesParameter[i])
			{
				pItemGeneral->DesWeight		+= pRareItemInfoPrefix->ParameterValue[i];
			}

			SetParamFactor(pRareItemInfoPrefix->DesParameter[i], pRareItemInfoPrefix->ParameterValue[i]);
		}
	}

	RARE_ITEM_INFO *pRareItemInfoSuffix = ms_pFieldIOCP->GetRareItemInfo(pItemGeneral->SuffixCodeNum);
	if (pRareItemInfoSuffix != NULL
		&& COMPARE_ITEMKIND(pRareItemInfoSuffix->ReqItemKind, pItemGeneral->Kind))
	{
		for (int i = 0; i < SIZE_DES_PARAM_PER_RARE_ITEM_INFO; i++)
		{
			if (pRareItemInfoSuffix->DesParameter[i] == DES_NULL) {				break; }

			// 2006-01-24 by cmkwon,  ߷ æƮ 
			if(DES_WEIGHT_01 == pRareItemInfoSuffix->DesParameter[i] || DES_WEIGHT_02 == pRareItemInfoSuffix->DesParameter[i])
			{
				pItemGeneral->DesWeight		+= pRareItemInfoSuffix->ParameterValue[i];
			}

			SetParamFactor(pRareItemInfoSuffix->DesParameter[i], pRareItemInfoSuffix->ParameterValue[i]);
		}
	}

	return TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SKILL_PREPARE_USE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SKILL_PREPARE_USE,
									MSG_FC_SKILL_PREPARE_USE, pMsgPrepareSkill);

// 2007-10-02 by cmkwon, Ʈ 2н  - 㰡
//	///////////////////////////////////////////////////////////////////////////////
//	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_SKILL_PREPARE_USE û 2н üũ
//	if(FALSE == this->CheckSecondaryPasswordLock())
//	{
//		SendErrorMessage(T_FC_SKILL_PREPARE_USE, ERR_SECPASS_LOCKED, pMsgPrepareSkill->SkillItemID.ItemNum);
//		return RES_BREAK;
//	}

	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);			// lock m_mapItemGeneral, MSG_FC_SKILL_PREPARE_USE
	
	// 2013-03-12 by jhseol, ų ѹ ý 
#ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	ITEM *pItemInfo = ms_pFieldIOCP->GetItemInfo(pMsgPrepareSkill->SkillItemID.ItemNum);
	if (pItemInfo == NULL)
	{
		SendErrorMessage(T_FC_SKILL_PREPARE_USE, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}
	ITEM_SKILL *pSkillItem
		= m_ItemManager.GetFirstSkillBySkillBaseNum(pItemInfo->NextSkill);
#else	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	ITEM_SKILL *pSkillItem
		= m_ItemManager.GetFirstSkillBySkillBaseNum(pMsgPrepareSkill->SkillItemID.ItemNum);
#endif	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	// end 2013-03-12 by jhseol, ų ѹ ý 

	if (pSkillItem == NULL)
	{
		SendErrorMessage(T_FC_SKILL_PREPARE_USE, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	// 2006-11-29 by dhjin, AttackTimḛų SKILLTYPE_CHARGING FC_SKILL_PREPARE_USE 
//	if (pSkillItem->ItemInfo->SkillType != SKILLTYPE_CHARGING)
	if (0 >= pSkillItem->ItemInfo->AttackTime)
	{
		SendErrorMessage(T_FC_SKILL_PREPARE_USE, ERR_PROTOCOL_NO_SUCH_ITEM, pSkillItem->ItemNum);
		return RES_BREAK;
	}

	// 2013-01-21 by jhseol, NGC  Ʈ ý - ߺ  
#ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	BYTE nOldSkillLevel = m_SkillManager.GetSkillActivatedLevelBySkillBaseNum(pItemInfo->NextSkill);
	if ( nOldSkillLevel >= pItemInfo->SkillLevel )
	{
		SendErrorMessage(T_FC_SKILL_PREPARE_USE, ERR_PROTOCOL_CANNOT_USE_SKILL, pSkillItem->ItemNum);
		return RES_BREAK;
	}
#endif
	// end 2013-01-21 by jhseol, NGC  Ʈ ý - ߺ  

	ATUM_DATE_TIME atBeforeUseTime = pSkillItem->UseTime;
	ATUM_DATE_TIME atCurTime(TRUE);

	//////////////////////////////////////////////////////////////////////////
	// 2006-12-18 by dhjin, attacktime ϴ ų T_FC_SKILL_PREPARE_USE UseTime ó 
	// 2010. 08. 18. by hsLee. ڳ ڵ ų  ð  ϵ .
	//if (FALSE == COMPARE_RACE(m_character.Race, RACE_OPERATION))
	//{// 2006-12-05 by dhjin, ڳ ̸ ų  ð   밡
		if (FALSE == m_SkillManager.CheckUseSkillTime(pSkillItem, &atCurTime))
		{
			SendErrorMessage(T_FC_SKILL_PREPARE_USE, ERR_PROTOCOL_NOT_ENOUGH_ELAPSE_TIME, pSkillItem->ItemNum); // ߰  ޼
			return RES_BREAK;
		}
	//}

	// SP Ȯ
	if (pSkillItem->ItemInfo->ReqSP > m_character.CurrentSP)
	{
		SendErrorMessage(T_FC_SKILL_PREPARE_USE, ERR_PROTOCOL_NOT_ENOUGH_SP, pSkillItem->ItemNum);
		return RES_BREAK;
	}

	pSkillItem->UseTime		= atCurTime;

	// 2006-12-06 by dhjin, ų  ð DB 
	m_SkillManager.SaveUseSkillTime(pSkillItem);	// 2006-12-18 by dhjin, attacktime ϴ ų T_FC_SKILL_PREPARE_USE UseTime ó 

	// SP 
// 2009-02-18 by cmkwon, M SmartSP    ȵǴ   - Ʒ  DecreaseCurrentSP() Լ ó
// 	m_character.CurrentSP -= pSkillItem->ItemInfo->ReqSP;
// 	SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTSP);
	// 2013-03-12 by jhseol, ų ѹ ý 
#ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	this->DecreaseCurrentSP(pSkillItem->ItemInfo->ReqSP, pSkillItem->ItemInfo->NextSkill);
#else	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	this->DecreaseCurrentSP(pSkillItem->ItemInfo->ReqSP, SKILL_BASE_NUM(pSkillItem->ItemInfo->ReqSP));	// 2009-02-18 by cmkwon, M SmartSP    ȵǴ   -	
#endif	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	// end 2013-03-12 by jhseol, ų ѹ ý 
	
	//////////////////////////////////////////////////////////////////////////
	// 2006-11-29 by dhjin, B BigBoomų̸  HP 
	// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - ITEM::IsExistDesParam() Լ 
	//if (IS_EXIST_DES_PARAM(pSkillItem->ItemInfo, DES_SKILL_BIG_BOOM))
	if (pSkillItem->ItemInfo->IsExistDesParam(DES_SKILL_BIG_BOOM))
	{
		CParamFactor *pParamFactor = this->GetParamFactor();
		pParamFactor->pf_SKILL_Big_Boom_damage	= m_character.CurrentHP;

		// 2007-07-11 by cmkwon, BigBoom PrepareUse   - TRUE 
		m_SkillManager.SetPrepareUseBigBoom(TRUE);
	}

	// SP ȸ 
	m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_SP);

	INIT_MSG_WITH_BUFFER(MSG_FC_SKILL_PREPARE_USE_OK, T_FC_SKILL_PREPARE_USE_OK, msgPrepareSkillOK, msgPrepareSkillOKBuf);
	msgPrepareSkillOK->ClientIndex = m_character.ClientIndex;
	msgPrepareSkillOK->SkillItemID = pMsgPrepareSkill->SkillItemID;
	SendInRangeMessageAroundMe(msgPrepareSkillOKBuf, MSG_SIZE(MSG_FC_SKILL_PREPARE_USE_OK), TRUE);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SKILL_CANCEL_PREPARE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SKILL_CANCEL_PREPARE,
									MSG_FC_SKILL_CANCEL_PREPARE, pMsgCancelPrepare);

	INIT_MSG_WITH_BUFFER(MSG_FC_SKILL_CANCEL_PREPARE_OK, T_FC_SKILL_CANCEL_PREPARE_OK, msgCancelPrepareOK, msgCancelPrepareOKBuf);
	msgCancelPrepareOK->ClientIndex = m_character.ClientIndex;
	msgCancelPrepareOK->SkillItemID = pMsgCancelPrepare->SkillItemID;
	SendInRangeMessageAroundMe(msgCancelPrepareOKBuf, MSG_SIZE(MSG_FC_SKILL_CANCEL_PREPARE_OK), TRUE);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SKILL_CONFIRM_USE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SKILL_CONFIRM_USE,
									MSG_FC_SKILL_CONFIRM_USE, pRMsg);

	return RES_RETURN_TRUE;		// 2009-04-06 by cmkwon, ݿ  ų ý  - 
// 2009-04-06 by cmkwon, ݿ  ų ý  - ý  ڵ óϴ  .
// 	if(FALSE == IsValidCharacter())
// 	{
// 		SendErrorMessage(T_FC_SKILL_CONFIRM_USE, ERR_INVALID_CHARACTER, pRMsg->TargetCharacterUID, pRMsg->UsingSkillItemNum);
// 		return RES_BREAK;
// 	}
// 
// 	CFieldIOCPSocket *pTargetFISock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(pRMsg->TargetCharacterUID);
// 	if(NULL == pTargetFISock
// 		|| FALSE == pTargetFISock->IsValidCharacter())
// 	{
// 		SendErrorMessage(T_FC_SKILL_CONFIRM_USE, ERR_INVALID_PEER_CHARACTER, pRMsg->TargetCharacterUID, pRMsg->UsingSkillItemNum);
// 		return RES_BREAK;
// 	}
// 
// 	CFieldMapProject *pFMPro = this->GetCurrentFieldMapProject();
// 	if(NULL == pFMPro
// 		|| ERR_NO_ERROR != pTargetFISock->IsEnableWarp(pFMPro->GetMapInfluenceType(), pFMPro->IsConflictAreaMap(), pFMPro->m_nQuestIndexForWarp))
// 	{
// 		SendErrorMessage(T_FC_SKILL_CONFIRM_USE, ERR_REQ_WARP_COMPLETIONQUEST_NOT_MATCHED, pRMsg->TargetCharacterUID, pRMsg->UsingSkillItemNum);
// 		return RES_BREAK;
// 	}
// 
// 	INIT_MSG_WITH_BUFFER(MSG_FC_SKILL_CONFIRM_USE, T_FC_SKILL_CONFIRM_USE, pSMsg, SendBuf);
// 	memcpy(pSMsg, pRMsg, sizeof(MSG_FC_SKILL_CONFIRM_USE));
// 	pTargetFISock->SendAddData(SendBuf, MSG_SIZE(MSG_FC_SKILL_CONFIRM_USE));
// 	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SKILL_CONFIRM_USE_ACK(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SKILL_CONFIRM_USE_ACK,
									MSG_FC_SKILL_CONFIRM_USE_ACK, pRMsg);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_SKILL_CONFIRM_USE_ACK, ERR_INVALID_CHARACTER, pRMsg->AttackCharacterUID, pRMsg->UsingSkillItemNum);
		return RES_BREAK;
	}

	CFieldIOCPSocket *pAttackFISock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(pRMsg->AttackCharacterUID);
	if(NULL == pAttackFISock
		|| FALSE == pAttackFISock->IsValidCharacter(FALSE))	// 2009-04-06 by cmkwon, ݿ  ų ý  - ڴ ׾  
	{
		SendErrorMessage(T_FC_SKILL_CONFIRM_USE_ACK, ERR_INVALID_PEER_CHARACTER, pRMsg->AttackCharacterUID, pRMsg->UsingSkillItemNum);
		return RES_BREAK;
	}

// 2009-04-06 by cmkwon, ݿ  ų ý  - Ʒ   .
// 	INIT_MSG_WITH_BUFFER(MSG_FC_SKILL_CONFIRM_USE_ACK, T_FC_SKILL_CONFIRM_USE_ACK, pSMsg, SendBuf);
// 	memcpy(pSMsg, pRMsg, sizeof(MSG_FC_SKILL_CONFIRM_USE_ACK));
// 	pAttackFISock->SendAddData(SendBuf, MSG_SIZE(MSG_FC_SKILL_CONFIRM_USE_ACK));
	///////////////////////////////////////////////////////////////////////////////
	// 2009-04-06 by cmkwon, ݿ  ų ý  - 
	SSKILL_CONFIRM_USE tmSkillConfirmUse;	
	MEMSET_ZERO(&tmSkillConfirmUse, sizeof(tmSkillConfirmUse));
	if(FALSE == pAttackFISock->m_SkillManager.PopSkillConfirmUse(pRMsg->SkillConfirmUseUID, pRMsg->TargetCharacterUID, pRMsg->UsingSkillItemNum, &tmSkillConfirmUse))
	{
		if(pRMsg->bYesOrNo)
		{// 2009-04-06 by cmkwon,  ĳͿ  .
			pAttackFISock->SendErrorMessage(T_FC_SKILL_CONFIRM_USE_ACK, ERR_PROTOCOL_CANNOT_USE_SKILL, pRMsg->AttackCharacterUID, pRMsg->UsingSkillItemNum);
		}
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_SKILL_CONFIRM_USE_ACK, T_FC_SKILL_CONFIRM_USE_ACK, pSMsg, SendBuf);
	*pSMsg	= *pRMsg;
	pAttackFISock->SendAddData(SendBuf, MSG_SIZE(MSG_FC_SKILL_CONFIRM_USE_ACK));
	
	if(FALSE == pRMsg->bYesOrNo)
	{// 2009-04-06 by cmkwon, ݿ  ź
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2010-03-29 by cmkwon, ݿ ν   üũ(K0002789) - 
	CFieldMapProject *pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(tmSkillConfirmUse.MapChannelIndex.MapIndex);
	
	if(NULL == pFMPro)
	{
		this->SendErrorMessage(T_FC_SKILL_CONFIRM_USE_ACK, ERR_PROTOCOL_NO_SUCH_MAP_SERVED, this->GetCharacter()->CharacterUniqueNumber, tmSkillConfirmUse.UsingSkillItemNum);
		return RES_BREAK;
	}
	

	// 2010. 11. 24. by hsLee.	ڰ Ÿ   Ÿ Ÿ    üũ.
	if(NULL != this->ms_pFieldIOCP->GetBurningMapInfo(tmSkillConfirmUse.MapChannelIndex.MapIndex))
	{
		CFieldIOCPSocket *pTargetFISock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber ( pRMsg->TargetCharacterUID );

		if ( NULL == pTargetFISock 
			|| ERR_NO_ERROR != pTargetFISock->CheckPossibleBurningMapWarp ( tmSkillConfirmUse.MapChannelIndex.MapIndex ) )
		{
			this->SendErrorMessage ( T_FC_SKILL_CONFIRM_USE_ACK , ERR_PROTOCOL_NOT_WARP_BURNING_MAP , this->GetCharacter()->CharacterUniqueNumber , tmSkillConfirmUse.UsingSkillItemNum );
			return RES_BREAK;
		}
	}

	Err_t nErr = this->IsEnableWarp(pFMPro->GetMapInfluenceType(), pFMPro->IsConflictAreaMap(), pFMPro->m_nQuestIndexForWarp, FALSE, pFMPro);		// 2011-12-19 by hskim, EP4 [Ʈ ý] - ũŻ ý
	if(ERR_NO_ERROR != nErr)
	{// 2005-12-02 by cmkwon,  Ұ
		this->SendErrorMessage(T_FC_SKILL_CONFIRM_USE_ACK, nErr, this->GetCharacter()->CharacterUniqueNumber, tmSkillConfirmUse.UsingSkillItemNum);
		return RES_BREAK;
	}

	EventResult_t nRetedResult = this->WarpToMap(tmSkillConfirmUse.MapChannelIndex, &(tmSkillConfirmUse.PositionVec3));
	if(EVENT_RESULT_CONTINUE != nRetedResult)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::Process_FC_SKILL_CONFIRM_USE_ACK# can't warp !! %s %d \r\n"
			, GetCharacterString(GetCharacter(), string()), nRetedResult);
		return RES_BREAK;
	}
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_TIMER_TIMEOUT(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_TIMER_TIMEOUT,
									MSG_FC_TIMER_TIMEOUT, pMsgTimeOut);

	MEX_TIMER_EVENT	*pMexTimerEvent = &pMsgTimeOut->TimerEvent;
	TimeUnit_t		nCurrentServerTimeInMilliSeconds = ms_pFieldIOCP->GetCurrentServerTimeInMilliSeconds();

	// Valid Ÿ̸ ̺Ʈ Ȯ
	const MEX_TIMER_EVENT *pMexTimerEventServer = m_TimerManager.GetTimerEventByEventID(pMexTimerEvent->TimerUID);
	if (pMexTimerEventServer == NULL)
	{
		SendString128(STRING_128_DEBUG_L3, "INVALID %s uid(%d) interval(%d) gap(%d)",
			CAtumSJ::GetTimerTypeString(pMexTimerEvent->Type),
			(INT)pMexTimerEvent->TimerUID,
			(INT)pMexTimerEvent->TimeInterval,
			(INT)(nCurrentServerTimeInMilliSeconds - pMexTimerEvent->ExpireTime));
		return RES_BREAK;
	}

	if (pMexTimerEvent->bRepeatable)
	{
		SendString128(STRING_128_DEBUG_L3, "%s uid(%d) interval(%d) gap(%d)",
			CAtumSJ::GetTimerTypeString(pMexTimerEvent->Type),
			(INT)pMexTimerEvent->TimerUID,
			(INT)pMexTimerEvent->TimeInterval,
			(INT)(nCurrentServerTimeInMilliSeconds
				- (pMexTimerEvent->StartTimeStamp
					+ (pMexTimerEventServer->nRemainedRepeatCount - pMexTimerEvent->nRemainedRepeatCount)*pMexTimerEvent->TimeInterval)
			));
	}
	else
	{
		SendString128(STRING_128_DEBUG_L3, "%s uid(%d) interval(%d) gap(%d)",
			CAtumSJ::GetTimerTypeString(pMexTimerEvent->Type),
			(INT)pMexTimerEvent->TimerUID,
			(INT)pMexTimerEvent->TimeInterval,
			(INT)(nCurrentServerTimeInMilliSeconds - pMexTimerEvent->ExpireTime));
	}

	// event ߻
	switch (pMexTimerEvent->Type)
	{
		// check:   Ŭ̾Ʈ  ϱ ϸ鼭 , 20041118, kelovon with dhkwon
//	case TE_TYPE_DELETE_MINE:
//		{
//			m_TimerManager.HandleTimerEventDeleteMine(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
//		}
//		break;
	case TE_TYPE_DELETE_DUMMY:
		{
			m_TimerManager.HandleTimerEventDeleteDummy(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_DELETE_FIXER:
		{
			m_TimerManager.HandleTimerEventDeleteFixer(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_DELETE_DECOY:
		{
			m_TimerManager.HandleTimerEventDeleteDecoy(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_RECOVER_HP:
		{
			m_TimerManager.HandleTimerEventRecoverHP(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_RECOVER_DP:
		{
			m_TimerManager.HandleTimerEventRecoverDP(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_RECOVER_SP:
		{
			m_TimerManager.HandleTimerEventRecoverSP(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_DECREASE_SP:
		{
			m_TimerManager.HandleTimerEventDecreaseSP(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_GRADUAL_HP_UP:
	case TE_TYPE_GRADUAL_DP_UP:
	case TE_TYPE_GRADUAL_EP_UP:
	case TE_TYPE_GRADUAL_SHIELD_UP:
		{
			m_TimerManager.HandleTimerEventSequential(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_IMMEDIATE_HP_UP:
		{
			m_TimerManager.m_bImmediateHPTimerRunning	= FALSE;
		}
		break;
	case TE_TYPE_IMMEDIATE_DP_UP:
		{
			m_TimerManager.m_bImmediateDPTimerRunning	= FALSE;
		}
		break;
	case TE_TYPE_IMMEDIATE_SP_UP:
		{
			m_TimerManager.m_bImmediateSPTimerRunning	= FALSE;
		}
		break;
	case TE_TYPE_IMMEDIATE_EP_UP:
		{
			m_TimerManager.m_bImmediateEPTimerRunning	= FALSE;
		}
		break;
	case TE_TYPE_REQUEST_TIMEOUT:
		{
			m_TimerManager.HandleTimerEventRequestTimeOut(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_TEST:
		{
			m_TimerManager.HandleTimerEventTest(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_DO_MINUTELY_WORK:
		{
			m_TimerManager.HandleTimerEventDoMinutelyWork(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
			//////////////////////////////////////////////////////////////////////
			// 2012-10-05 by jhseol, NPlay PC  -  и pc  ش
#ifdef S_NPLAY_PCBANG_MODULE_JHSEOL
			if( FALSE == g_pFieldGlobal->IsArenaServer() )
			{
				INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_PCBANG_PREMIUN_APPLY, T_FC_CHARACTER_PCBANG_PREMIUN_APPLY, pPremiun, SendBuf);
				pPremiun->PremiumApply = m_bIsPCBangClient;
				ms_pFieldIOCP->LoadGameEventMessage(this, &pPremiun->msg);
				SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_PCBANG_PREMIUN_APPLY));
			}
#endif
			// end 2012-10-05 by jhseol, NPlay PC  -  и pc  ش

		}
		break;
		////////////////////////////////////////////////////////////////////////////////
		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	case TE_TYPE_DOTSKILL_STEALING:
		{
			m_TimerManager.HandleTimerEventDotSkillStealing(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_DOTSKILL_DRAIN:
		{
			m_TimerManager.HandleTimerEventDotSkillDrain(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	case TE_TYPE_DOTSKILL_TIME_BOMB:
		{
			m_TimerManager.HandleTimerEventDotSkillTimeBomb(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	// 2012-10-10 by hskim, Ⱓ Ӽ  (Ⱓ )
	case TE_TYPE_FIXED_TERM_SHAPE:
		{
			m_TimerManager.HandleTimerFixedTermShape(pMexTimerEvent, nCurrentServerTimeInMilliSeconds);
		}
		break;
	// 2012-10-10 by hskim, Ⱓ Ӽ  (Ⱓ )
	default:
		{
			SendErrorMessage(T_FC_TIMER_TIMEOUT, ERR_PROTOCOL_NO_SUCH_TIMER_EVENT_TYPE, pMexTimerEvent->Type);
			return RES_BREAK;
		}
	} // end - switch

	// 
	if (pMexTimerEvent->bRepeatable && pMexTimerEvent->nRemainedRepeatCount > 0)
	{
		// Repeatable Timer Event
		SendString128(STRING_128_DEBUG_L3, "REPEAT TE, cnt: %d", pMexTimerEvent->nRemainedRepeatCount);
	}
	else
	{
		// ȸ Timer Event
		if (!m_TimerManager.DeleteTimerEventByTimerUID(pMexTimerEvent->TimerUID))
		{
			//  
			SendErrorMessage(T_FC_TIMER_TIMEOUT, ERR_PROTOCOL_NO_SUCH_TIME_LIMIT_EVENT_IN_BUCKET,
							pMexTimerEvent->Type, 0, (char*)CAtumSJ::GetTimerTypeString(pMexTimerEvent->Type));
		}
	}

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_SKILL_USE_SKILL(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SKILL_USE_SKILL,
									MSG_FC_SKILL_USE_SKILL,	pMsgUseSkill);

// 2007-10-02 by cmkwon, Ʈ 2н  - 㰡
//	///////////////////////////////////////////////////////////////////////////////
//	// 2007-09-13 by cmkwon, Ʈ 2н  - T_FC_SKILL_USE_SKILL û 2н üũ
//	if(FALSE == this->CheckSecondaryPasswordLock())
//	{
//		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_SECPASS_LOCKED);
//		return RES_BREAK;
//	}

	BYTE SendBuf[SIZE_MAX_PACKET];

	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);			// lock m_mapItemGeneral, MSG_FC_SKILL_USE_SKILL
	
	if(FALSE == IsValidCharacter())
	{// 2006-09-19 by cmkwon, üũ
		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2010-04-01 by cmkwon,  ų ¿  Ұ ó - 
	if(this->IsInvisibleCharacter())
	{
		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}
	
	ITEM_SKILL *pSkillItem = m_ItemManager.GetItemSkillByUID(pMsgUseSkill->SkillItemID.ItemUID);
	if (pSkillItem == NULL)
	{
		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	ITEM_SKILL TempSkillItem = *pSkillItem;

	// start 2012-01-17 by hskim, EP4 [ ] -    
	if( TRUE == IS_MAP_INFLUENCE_NON_DISPUTE(m_pCurrentFieldMapChannel->GetMapInfluenceTypeW()) )
	{
		if( pMsgUseSkill->TargetIndex < MONSTER_CLIENT_INDEX_START_NUM && 0 != pMsgUseSkill->TargetIndex )
		{
			//   ų  üũϰ ,    ϼ.
			if( TempSkillItem.ItemInfo->IsExistDesParam(DES_SKILL_CANCELALL) ||
				TempSkillItem.ItemInfo->IsExistDesParam(DES_SKILL_SLOWMOVING) ||
				TempSkillItem.ItemInfo->IsExistDesParam(DES_SKILL_SHIELD_PARALYZE) ||
				TempSkillItem.ItemInfo->IsExistDesParam(DES_SKILL_STOPMAGIC) )
			{
				SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_CANNOT_USE_SKILL, TempSkillItem.ItemNum, 0);
				return RES_BREAK;
			}
		}
	}
	// start 2012-01-17 by hskim, EP4 [ ] -    

	igLock.auto_unlock_cancel();
	
//	// SKILLTYPE_CHARGING SP Ҹ FC_SKILL_PREPARE_USE 
//	if (pSkillItem->ItemInfo->SkillType != SKILLTYPE_CHARGING
//		&& pSkillItem->ItemInfo->ReqSP > m_character.CurrentSP)
	// 2006-12-08 by dhjin, attacktime ϴ ų T_FC_SKILL_PREPARE_USE sp Ҹ Ͽ  üũ ʴ´ 
	if (0 >= TempSkillItem.ItemInfo->AttackTime
		&& TempSkillItem.ItemInfo->ReqSP > m_character.CurrentSP)
	{// SP Ȯ

		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_NOT_ENOUGH_SP, TempSkillItem.ItemNum);
		return RES_BREAK;		
	}

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ϷƮ  üũ,  üũѴ.
	if(this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_MON_SILENCE_SKILL)) {
		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_DEBUFF_SKILL_APPLYING_SLIENCE);
		return RES_BREAK;
	}

	// start 2011-10-28 by hskim, EP4 [Ʈ ý] - ų ߰
#ifdef S_EP4_HSKIM		// ON/OFF  
	if(this->m_SkillManager.m_FieldDebuff.CheckApplyingDebuff(DES_SKILL_STOPMAGIC)) {
		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_DEBUFF_SKILL_APPLYING_STOPMAGIC);
		return RES_BREAK;
	}
#endif
	// end 2011-10-28 by hskim, EP4 [Ʈ ý] - ų ߰

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-26 by cmkwon,   ó - /Ǹ
	if(IS_BAZAAR_SKILL(TempSkillItem.ItemInfo))
	{
		///////////////////////////////////////////////////////////////////////////////
		// 2008-07-01 by dhjin, Ʈ 2н  - λ  üũ
		if(FALSE == this->CheckSecondaryPasswordLock())
		{
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_SECPASS_LOCKED);
			return RES_BREAK;
		}

		// 2007-07-09 by dhjin,    üũ
		if(NULL != m_pCurrentBuildingNPC)
		{
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_USING_SHOP, TempSkillItem.ItemNum);
			return RES_BREAK;
		}

// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//		if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
		if(this->IsInvisibleCharacter())
		{// 2006-08-03 by cmkwon, ¿   Ұ
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_INVISIBLE_STATE, TempSkillItem.ItemNum);
			return RES_BREAK;
		}
		
// 2007-05-25 by dhjin, Ʈ ߿    
//		if(this->GetCharacterQuestInProgress())
//		{// 2006-08-07 by cmkwon, Ʈ ߿    Ұ
//			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_QUEST_IS_IN_PROGRESS, TempSkillItem.ItemNum);
//			return RES_BREAK;
//		}

		if(BAZAAR_STATE_NONE != m_bazaarManager.GetBazaarState())
		{
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_CANNOT_USE_SKILL, TempSkillItem.ItemNum, 0);
			return RES_BREAK;
		}

		//////////////////////////////////////////////////////////////////////////
		// 2007-06-01 by dhjin,     
// 2008-02-12 by cmkwon, IS_CITY_MAP_INDEX() ũθ  ø θ 
// 		if(!(TRUE == IS_BAZAAR_MAP_INDEX(m_character.MapChannelIndex.MapIndex)
// 			|| TRUE == IS_CITY_MAP_INDEX(m_character.MapChannelIndex.MapIndex)) )
//		if(FALSE == IS_BAZAAR_MAP_INDEX(m_character.MapChannelIndex.MapIndex))

		if(FALSE == IS_INFLUENCE_CITY_MAP_INDEX(m_pCurrentFieldMapChannel->GetMapChannelIndex().MapIndex)
			&& FALSE == IS_CONFERENCEROOM_MAP_INDEX(m_pCurrentFieldMapChannel->GetMapChannelIndex().MapIndex))
		{// 2008-02-12 by cmkwon, ºøʰ ȸǷ븸 , // 2006-07-31 by cmkwon
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_CANNOT_USE_SKILL, TempSkillItem.ItemNum, 1);
			return RES_BREAK;
		}
//////////////////////////////////////////////////////////////////////////
// 2007-06-04 by dhjin, ڸ   밡.
//		if(IS_BAZAAR_MAP_INDEX(m_character.MapChannelIndex.MapIndex))
//		{
//			EVENTINFO *pEvInfo = GetCurrentFieldMapChannel()->GetTileEventInfoW(&m_character.PositionVector);
//			if (EVENT_TYPE_ENTER_BUILDING_BAZAAR != pEvInfo->m_bEventType)
//			{
//				SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_CANNOT_USE_SKILL, TempSkillItem.ItemNum, 2);
//				return RES_BREAK;
//			}
//		}

		if(NULL != m_pFieldParty)
		{
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_IMPOSSIBLE_IN_PARTY, TempSkillItem.ItemNum);
			return RES_BREAK;
		}
		//////////////////////////////////////////////////////////////////////////
		// 2007-04-26 by dhjin, ARENA ¿ ڽų  Ұ
		if(ARENA_STATE_NONE != this->m_ArenaInfo.State)
		{
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_ARENA_STATE, TempSkillItem.ItemNum);
			return RES_BREAK;
		}

		// 2009-09-09 ~ 2010-01-20 by dhjin, ǴƼ -    μ Ѵ.   üũ
		if(INFINITY_STATE_NONE != this->m_InfinityPlayingInfo.InfinityState ) {
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_INFINITY_STATE);
			return RES_BREAK;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2007-06-04 by cmkwon, ڻ ĳ͸ ¿ 
		if(FALSE == m_character.CharacterMode)
		{
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_CHARACTER_MODE_NOT_MATCHED, TempSkillItem.ItemNum);
			return RES_BREAK;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2008-07-18 by cmkwon,    (λ ŷÿ ̿ ϴ  ) - ŷ û  λ   
		if(IS_VALID_UNIQUE_NUMBER(m_peerTraderCharacterUniqueNumber))
		{
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_ITEM_TRADING, TempSkillItem.ItemNum);
			return RES_BREAK;
		}

		// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - ITEM::IsExistDesParam() Լ 
		//if(IS_EXIST_DES_PARAM(TempSkillItem.ItemInfo, DES_BAZAAR_SELL))
		if(TempSkillItem.ItemInfo->IsExistDesParam(DES_BAZAAR_SELL))
		{
			m_bazaarManager.SetBazaarTypeAndState(BAZAAR_TYPE_SELL, BAZAAR_STATE_READY);
		}
		else
		{
			m_bazaarManager.SetBazaarTypeAndState(BAZAAR_TYPE_BUY, BAZAAR_STATE_READY);
		}
	}


	ATUM_DATE_TIME atBeforeUseTime = TempSkillItem.UseTime;
	ATUM_DATE_TIME atCurTime(TRUE);

	//////////////////////////////////////////////////////////////////////////
	// 2006-12-05 by dhjin, ų  ð üũ
	// 2010. 08. 18. by hsLee. ڳ ڵ ų  ð  ϵ .
	if ( /*FALSE == COMPARE_RACE(m_character.Race, RACE_OPERATION)
		&&*/ 0 >= TempSkillItem.ItemInfo->AttackTime)	// 2006-12-18 by dhjin, attacktime ϴ ų T_FC_SKILL_PREPARE_USE UseTime ó 
	{// 2006-12-05 by dhjin, ڳ ̸ ų  ð   밡
		if (FALSE == m_SkillManager.CheckUseSkillTime(&TempSkillItem, &atCurTime))
		{
			SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_NOT_ENOUGH_ELAPSE_TIME, TempSkillItem.ItemNum); // ߰  ޼
			return RES_BREAK;
		}
	}

	TempSkillItem.UseTime		= atCurTime;	// 2006-12-13 by dhjin, ڵ DB  ð ǰ .

	///////////////////////////////////////////////////////////////////////////////	
	// ų 
	if (!m_SkillManager.UseSkill(&TempSkillItem, pMsgUseSkill))
	{
		TempSkillItem.UseTime		= atBeforeUseTime;
		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_CANNOT_USE_SKILL, TempSkillItem.ItemNum, 3);
		return RES_BREAK;
	}

	// 2013-03-12 by jhseol, ų ѹ ý 
#ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	ITEM *pItemInfo = ms_pFieldIOCP->GetItemInfo(pMsgUseSkill->SkillItemID.ItemNum);
	if ( NULL == pItemInfo )
	{
		SendErrorMessage(T_FC_SKILL_USE_SKILL, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}
	// 2013-01-29 by jhseol,  ų Ʈ 
	if( AGEAR_SKILL_BASENUM_BARIAL == pItemInfo->NextSkill )
	{
		m_structUsingItemBitFlag.bUsingBarialSkill = TRUE;
	}
	// end 2013-01-29 by jhseol,  ų Ʈ 
	
	// 2013-02-06 by jhseol, M ų ̺Ʈ 
	else if( MGEAR_SKILL_BASENUM_INVICIBLE == pItemInfo->NextSkill )
	{
		m_structUsingItemBitFlag.bUsingInvicibleSkill = TRUE;
	}
	// end 2013-02-06 by jhseol, M ų ̺Ʈ 
#else	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	// 2013-01-29 by jhseol,  ų Ʈ 
	if( AGEAR_SKILL_BASENUM_BARIAL == SKILL_BASE_NUM(pMsgUseSkill->SkillItemID.ItemNum) )
	{
		m_structUsingItemBitFlag.bUsingBarialSkill = TRUE;
	}
	// end 2013-01-29 by jhseol,  ų Ʈ 

	// 2013-02-06 by jhseol, M ų ̺Ʈ 
	else if( MGEAR_SKILL_BASENUM_INVICIBLE == SKILL_BASE_NUM(pMsgUseSkill->SkillItemID.ItemNum) )
	{
		m_structUsingItemBitFlag.bUsingInvicibleSkill = TRUE;
	}
	// end 2013-02-06 by jhseol, M ų ̺Ʈ 
#endif	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	// end 2013-03-12 by jhseol, ų ѹ ý 

	// 2007-02-07 by dhjin, Lockؼ Ǯ pSkillItem ٽ Lock ų  ð Ʈ Ѵ.
	this->SetSkillUseTime(TempSkillItem.UniqueNumber, TempSkillItem.UseTime);

	// SP 
//	if (pSkillItem->ItemInfo->SkillType != SKILLTYPE_CHARGING)
	//////////////////////////////////////////////////////////////////////////
	// 2006-12-01 by dhjin, attacktime ϴ ų T_FC_SKILL_PREPARE_USE sp Ҹ ó
	if (0 >= TempSkillItem.ItemInfo->AttackTime)
	{// SKILLTYPE_CHARGING T_FC_SKILL_PREPARE_USE SP Ҹ óѴ.
// 2005-11-22 by cmkwon
//		ChangeCurrentSP(-pSkillItem->ItemInfo->ReqSP);
		
		// 2006-12-06 by dhjin, ų  ð DB 
		m_SkillManager.SaveUseSkillTime(&TempSkillItem);	// 2006-12-18 by dhjin, attacktime ϴ ų T_FC_SKILL_PREPARE_USE UseTime ó 
		// 2013-03-12 by jhseol, ų ѹ ý 
#ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
		DecreaseCurrentSP(TempSkillItem.ItemInfo->ReqSP, TempSkillItem.ItemInfo->NextSkill);
#else	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
		DecreaseCurrentSP(TempSkillItem.ItemInfo->ReqSP, SKILL_BASE_NUM(TempSkillItem.ItemInfo->ItemNum));
#endif	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
		// end 2013-03-12 by jhseol, ų ѹ ý 
	}

	// Ʈ ų  NPC ε 
// 2005-11-22 by cmkwon
//	switch(pSkillItem->ItemInfo->ItemNum)
//	{
//	case BT_SKILL_QUICKTURN:
//	case BT_SKILL_REVERSETURN:
//	case BT_SKILL_COPTERFLIGHT:
//	case OT_SKILL_PARALLELMOVEMENT:
//	case OT_SKILL_SCREWPUSHING:
//	case OT_SKILL_OVERRISING:
//	case DT_SKILL_DASH:
//	case DT_SKILL_AUTODRIVING:
//	case ST_SKILL_YOYOSPINNING:
//	case ST_SKILL_OVERBOOST:
//	case ST_SKILL_COPTERFLIGHT:

	// 2013-03-12 by jhseol, ų ѹ ý 
#ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	switch(TempSkillItem.ItemInfo->NextSkill)
#else	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	switch(SKILL_BASE_NUM(TempSkillItem.ItemInfo->ItemNum))
#endif	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	// end 2013-03-12 by jhseol, ų ѹ ý 
	{
	case BGEAR_SKILL_BASENUM_BACKMOVEMACH:
	case BGEAR_SKILL_BASENUM_TURNAROUND:
	case IGEAR_SKILL_BASENUM_BACKMOVEMACH:
	case IGEAR_SKILL_BASENUM_TURNAROUND:
		{
			INIT_MSG(MSG_FN_SKILL_USE_SKILL_OK, T_FN_SKILL_USE_SKILL_OK, pSendNPC, SendBuf);
			pSendNPC->ChannelIndex	= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
			pSendNPC->SkillItemID	= pMsgUseSkill->SkillItemID;
			pSendNPC->AttackIndex	= pMsgUseSkill->AttackIndex;
			pSendNPC->TargetIndex	= pMsgUseSkill->TargetIndex;
			m_pCurrentFieldMapChannel->Send2NPCServerW(SendBuf, MSG_SIZE(MSG_FN_SKILL_USE_SKILL_OK));
		}
		break;
	default:
		{
			if(IS_MONSTER_CLIENT_INDEX(pMsgUseSkill->TargetIndex))
			{
				INIT_MSG(MSG_FN_SKILL_USE_SKILL_OK, T_FN_SKILL_USE_SKILL_OK, pSendNPC, SendBuf);
				pSendNPC->ChannelIndex	= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
				pSendNPC->SkillItemID	= pMsgUseSkill->SkillItemID;
				pSendNPC->AttackIndex	= pMsgUseSkill->AttackIndex;
				pSendNPC->TargetIndex	= pMsgUseSkill->TargetIndex;
				m_pCurrentFieldMapChannel->Send2NPCServerW(SendBuf, MSG_SIZE(MSG_FN_SKILL_USE_SKILL_OK));
			}
		}
	}

	// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - ITEM::IsExistDesParam() Լ 
	//if(IS_EXIST_DES_PARAM(TempSkillItem.ItemInfo, DES_SKILL_BIG_BOOM))
	if(TempSkillItem.ItemInfo->IsExistDesParam(DES_SKILL_BIG_BOOM))
	{// 2006-12-01 by dhjin
		
		// 2007-06-08 by cmkwon, 2 Ȯ,Ǿ,ݷ  ý  ߰			
		SATTACK_PARAMETER attParam;
		MEMSET_ZERO(&attParam, sizeof(attParam));
		attParam.pWeaponItemInfo	= TempSkillItem.ItemInfo;
		//attParam.MultiTargetIndex	= pMsgUseSkill->MultiTargetIndex;		// 2011-03-21 by hskim, ǴƼ 3 -  Ƽ Ÿ  ߰	// ӽ  (Ŭ󿡼  Ȯ  츲)
		ProcessSplashDamageC2All(this, &attParam, TempSkillItem.ItemInfo->Range, &m_character.PositionVector);
		CharacterDeadRoutine(DAMAGE_BY_NA);

		// 2007-07-11 by cmkwon, BigBoom PrepareUse   -  ų , FALSE , 
		m_SkillManager.SetPrepareUseBigBoom(FALSE);
	}

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::SetSkillUseTime(UID64_t i_skillUID, ATUM_DATE_TIME i_atUseTime)
/// \brief		
/// \author		dhjin
/// \date		2007-02-07 ~ 2007-02-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::SetSkillUseTime(UID64_t i_skillUID, ATUM_DATE_TIME i_atUseTime)
{
	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
	ITEM_SKILL *pSkillItem = m_ItemManager.GetItemSkillByUID(i_skillUID);
	if(pSkillItem)
	{
		pSkillItem->UseTime = i_atUseTime;
	}
}

ProcessResult CFieldIOCPSocket::Process_FC_SKILL_CANCEL_SKILL(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_SKILL_CANCEL_SKILL,
									MSG_FC_SKILL_CANCEL_SKILL, pMsgCancelSkill);

	ITEM *pSkillItemInfo = ms_pFieldIOCP->GetItemInfo(pMsgCancelSkill->SkillItemID.ItemNum);
	if (pSkillItemInfo == NULL)
	{
		SendErrorMessage(T_FC_SKILL_CANCEL_SKILL, ERR_PROTOCOL_NO_SUCH_ITEM, pMsgCancelSkill->SkillItemID.ItemNum);	// 2006-07-13 by cmkwon,  
		return RES_BREAK;
	}

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	if(TRUE == IS_ORBIT_SKILL(pSkillItemInfo->OrbitType)) {
		// OrbitSkill 
		this->m_SkillManager.ReleaseOrbitSkill(pSkillItemInfo);
		if(NULL != this->m_pFieldParty) {
			INIT_MSG_OF_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_RELEASE, T_FC_CHARACTER_DEBUFF_DOT_RELEASE, pSendMsg, DebuffDotSendBuf);
			pSendMsg->CharacterUID		= this->m_character.CharacterUniqueNumber;
			pSendMsg->SkillItemNum		= pMsgCancelSkill->SkillItemID.ItemNum;
			this->m_pFieldParty->SendMsgToMembers(DebuffDotSendBuf, MSG_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_RELEASE), this->m_character.CharacterUniqueNumber);
		}
		return RES_RETURN_TRUE;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-26 by cmkwon,   
	if(IS_BAZAAR_SKILL(pSkillItemInfo))
	{
	 	m_bazaarManager.ResetBazaarManager();
	}

// 2009-08-03 by cmkwon, EP3-4   ų  - Ʒ  CFieldSkillManager::CancelSkill() ó
// 	// CANCEL_SKILL ð(SKILLTYPE_TIMELIMIT), (SKILLTYPE_TOGGLE) ų   ִ.
// 	switch(pSkillItemInfo->SkillType)
// 	{
// 	case SKILLTYPE_TIMELIMIT:
// 		{
// 			if (m_SkillManager.IsSkillActivatedByItemNum(pMsgCancelSkill->SkillItemID.ItemNum))
// 			{
// 				if (!m_SkillManager.DeactivateSkill(pSkillItemInfo, TRUE))
// 				{
// #ifdef _DEBUG
// 					SendString128(STRING_128_ADMIN_CMD, "ATTACKPROBABILITY01: %d @CancelSkill", m_ParamFactor.pfp_ATTACKPROBABILITY_01);
// #endif
// 					SendErrorMessage(T_FC_SKILL_CANCEL_SKILL, ERR_PROTOCOL_NO_SUCH_SKILL, pSkillItemInfo->ItemNum);
// 					return RES_BREAK;
// 				}
// 			}
// 		}
// 		break;
// 	case SKILLTYPE_TOGGLE:
// 		{
// 			if (m_SkillManager.IsSkillActivatedByItemNum(pMsgCancelSkill->SkillItemID.ItemNum))
// 			{
// 				if (!m_SkillManager.DeactivateSkill(pSkillItemInfo, TRUE))
// 				{
// #ifdef _DEBUG
// 					SendString128(STRING_128_ADMIN_CMD, "ATTACKPROBABILITY01: %d @CancelSkill", m_ParamFactor.pfp_ATTACKPROBABILITY_01);
// #endif
// 					SendErrorMessage(T_FC_SKILL_CANCEL_SKILL, ERR_PROTOCOL_NO_SUCH_SKILL, pSkillItemInfo->ItemNum);
// 					return RES_BREAK;
// 				}
// 			}
// 		}
// 		break;
// 	case SKILLTYPE_CLICK:
// 		{
// 			if (SKILL_KIND(pSkillItemInfo->ItemNum) == SKILL_KIND_CONTROL)
// 			{
// 				// ڽ   ֿ ѷֱ⸸ Ѵ.
// 				INIT_MSG_OF_SIZE(MSG_FC_SKILL_INVALIDATE_SKILL, T_FC_SKILL_INVALIDATE_SKILL, msgInvalidateSkill, msgInvalidateSkillBuf);
// 				msgInvalidateSkill->SkillItemID.ItemNum = pSkillItemInfo->ItemNum;
// 				msgInvalidateSkill->SkillItemID.ItemUID = 0;	// Ŭ̾Ʈ ʿ
// 				msgInvalidateSkill->ClientIndex = m_character.ClientIndex;
// 				SendInRangeMessageAroundMe(msgInvalidateSkillBuf, MSG_SIZE(MSG_FC_SKILL_INVALIDATE_SKILL), TRUE);
// 			}
// 		}
// 		break;
// 	case SKILLTYPE_CHARGING:
// 		{// 2006-11-30 by dhjin, ¡ ҵ Ŭ̾Ʈ Ѵ
// 			m_SkillManager.ClearChargingSkill(pSkillItemInfo);			// 2006-12-06 by cmkwon, ҵ ¡ų ʱȭ Ѵ.
// 		}
// 		break;
// 	default:
// 		{
// 			SendErrorMessage(T_FC_SKILL_CANCEL_SKILL, ERR_PROTOCOL_INVALID_SKILLTYPE, pSkillItemInfo->ItemNum);
// 		}
// 	}
	///////////////////////////////////////////////////////////////////////////////
	// 2009-08-03 by cmkwon, EP3-4   ų  - CFieldSkillManager::CancelSkill() ó
	if(COMPARE_BIT_FLAG(pSkillItemInfo->ItemAttribute, SKILL_ATTR_PARTY_FORMATION_SKILL))
	{// 2009-08-11 by cmkwon,  ų Ŭ̾Ʈ  Ұ
		SendErrorMessage(T_FC_SKILL_CANCEL_SKILL, ERR_PROTOCOL_INVALID_SKILLTYPE, pSkillItemInfo->ItemNum);
		return RES_BREAK;
	}
	Err_t nErr = m_SkillManager.CancelSkill(pSkillItemInfo, pMsgCancelSkill);
	if(ERR_NO_ERROR != nErr)
	{
		SendErrorMessage(T_FC_SKILL_CANCEL_SKILL, nErr, pSkillItemInfo->ItemNum);
		return RES_BREAK;
	}

	// 2013-03-12 by jhseol, ų ѹ ý 
#ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	// 2013-01-29 by jhseol,  ų Ʈ 
	if( AGEAR_SKILL_BASENUM_BARIAL == pSkillItemInfo->NextSkill )
	{
		m_structUsingItemBitFlag.bUsingBarialSkill = FALSE;
	}
	// end 2013-01-29 by jhseol,  ų Ʈ 
	
	// 2013-02-06 by jhseol, M ų ̺Ʈ 
	else if( MGEAR_SKILL_BASENUM_INVICIBLE == pSkillItemInfo->NextSkill )
	{
		m_structUsingItemBitFlag.bUsingInvicibleSkill = FALSE;
	}
	// 2013-02-06 by jhseol, M ų ̺Ʈ 
#else	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	// 2013-01-29 by jhseol,  ų Ʈ 
	if( AGEAR_SKILL_BASENUM_BARIAL == SKILL_BASE_NUM(pMsgCancelSkill->SkillItemID.ItemNum) )
	{
		m_structUsingItemBitFlag.bUsingBarialSkill = FALSE;
	}
	// end 2013-01-29 by jhseol,  ų Ʈ 

	// 2013-02-06 by jhseol, M ų ̺Ʈ 
	else if( MGEAR_SKILL_BASENUM_INVICIBLE == SKILL_BASE_NUM(pMsgCancelSkill->SkillItemID.ItemNum) )
	{
		m_structUsingItemBitFlag.bUsingInvicibleSkill = FALSE;
	}
	// 2013-02-06 by jhseol, M ų ̺Ʈ 
#endif	// #ifdef S_SKILL_NUMBERING_RENEWAL_JHSEOL
	// end 2013-03-12 by jhseol, ų ѹ ý 

	///////////////////////////////////////////////////////////////////////////////
	// 2006-12-06 by cmkwon, ü  ؾ
	// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - ITEM::IsExistDesParam() Լ 
	//if(IS_EXIST_DES_PARAM(pSkillItemInfo, DES_SKILL_HALLUCINATION))
	if(pSkillItemInfo->IsExistDesParam(DES_SKILL_HALLUCINATION))
	{
		mt_auto_lock mtA(&m_mtvectFieldDummy);
		m_bDummyCheck			= FALSE;
		if(false == m_mtvectFieldDummy.empty())
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_DELETE_DUMMY_OK, T_FC_BATTLE_DELETE_DUMMY_OK, pSMsg, SendBuf);
			pSMsg->AttackIndex		= GetCharacter()->ClientIndex;
			mtvectFieldDummy::iterator itr = m_mtvectFieldDummy.begin();
			for(; itr != m_mtvectFieldDummy.end(); itr++)
			{
				FIELD_DUMMY *pFDummy	= *itr;
				pSMsg->ItemFieldIndex	= pFDummy->ItemFieldIndex;

				// 2006-12-06 by cmkwon,   ĳͿ 
				this->SendInRangeMessageAroundMe(SendBuf, MSG_SIZE(MSG_FC_BATTLE_DELETE_DUMMY_OK), TRUE);
			}
			this->DeleteAllFieldDummy();			// 2006-12-06 by cmkwon,  ü Ѵ.
		}
	}

	if(SKILLTYPE_CHARGING == pSkillItemInfo->SkillType
// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - ITEM::IsExistDesParam() Լ 
//		|| IS_EXIST_DES_PARAM(pSkillItemInfo, DES_INVISIBLE)			// 2006-11-28 by dhjin, κ ų  Ǹ  Ŭ̾Ʈ ˸
//		|| IS_EXIST_DES_PARAM(pSkillItemInfo, DES_SKILL_CAMOUFLAGE))	// 2006-11-28 by dhjin,  ų  Ǹ  Ŭ̾Ʈ ˸
		|| pSkillItemInfo->IsExistDesParam(DES_INVISIBLE)				// 2006-11-28 by dhjin, κ ų  Ǹ  Ŭ̾Ʈ ˸
		|| pSkillItemInfo->IsExistDesParam(DES_SKILL_CAMOUFLAGE))		// 2006-11-28 by dhjin,  ų  Ǹ  Ŭ̾Ʈ ˸
	{
		INIT_MSG_OF_SIZE(MSG_FC_SKILL_CANCEL_SKILL_OK, T_FC_SKILL_CANCEL_SKILL_OK, msgCancelSkill, msgCancelSkillBuf);
		msgCancelSkill->SkillItemID.ItemNum		= pSkillItemInfo->ItemNum; 
		msgCancelSkill->ClientIndex				= m_character.ClientIndex;
		msgCancelSkill->AttackSkillItemNum0		= pMsgCancelSkill->AttackSkillItemNum0;		// 2006-12-12 by cmkwon, ߰
		SendInRangeMessageAroundMe(msgCancelSkillBuf, MSG_SIZE(MSG_FC_SKILL_CANCEL_SKILL_OK), TRUE);	
	}
#ifdef _DEBUG
	SendString128(STRING_128_ADMIN_CMD, "ATTACKPROBABILITY01: %d @CancelSkill", m_ParamFactor.pfp_ATTACKPROBABILITY_01);
#endif

	return RES_RETURN_TRUE;
}

CFieldIOCPSocket* CFieldIOCPSocket::SendTradeCanceledAndReset(CFieldIOCPSocket *pPeerSocket, BOOL bSendToPeer)
{
	if (NULL == pPeerSocket && bSendToPeer)
	{
		pPeerSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
	}

	// 2009-02-05 by cmkwon,     ó  - ȿ   ̸ NULL .
	if(pPeerSocket && FALSE == pPeerSocket->IsValidCharacter(FALSE))
	{
		pPeerSocket	= NULL;
	}

	// Send MSG_FC_TRADE_CANCEL_TRADE_OK
	INIT_MSG_WITH_BUFFER(MSG_FC_TRADE_CANCEL_TRADE_OK, T_FC_TRADE_CANCEL_TRADE_OK, msgCancelOK, SendBuf);

	// To Me
	msgCancelOK->CharacterUniqueNumber = m_peerTraderCharacterUniqueNumber;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_CANCEL_TRADE_OK));

	// To Peer
	if (pPeerSocket != NULL && bSendToPeer)
	{
		msgCancelOK->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
		pPeerSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_CANCEL_TRADE_OK));
	}

	// reset trade
	m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
	m_bOKTradeChecked = FALSE;
	m_mapTradeItem.clearLock();
	if (pPeerSocket != NULL)
	{
		pPeerSocket->m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
		pPeerSocket->m_bOKTradeChecked = FALSE;
		pPeerSocket->m_mapTradeItem.clearLock();
	}

	return pPeerSocket;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::TradeCheckEnableInsertItems(CFieldIOCPSocket *i_pPeerFISock)
/// \brief		
/// \author		cmkwon
/// \date		2006-05-11 ~ 2006-05-11
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::TradeCheckEnableInsertItems(CFieldIOCPSocket *i_pPeerFISock)
{
// 2006-05-11 by cmkwon, EPII  ߷  ۸ Ѵ.
// 	if (GetCurrentLoadagePercentage(i_pPeerFISock->GetTradeItemWeight()) > 1.0f)
//	{
// 		return ERR_PROTOCOL_ITEM_OVER_WEIGHT;
// 	}

	int nInsertInventoryCnt = 0;
	mtmapUID2TradeItem::iterator itr = i_pPeerFISock->m_mapTradeItem.begin();
	for(; itr != i_pPeerFISock->m_mapTradeItem.end(); itr++)
	{
		TradeItem *pTItem = &itr->second;
		if(FALSE == IS_COUNTABLE_ITEM(pTItem->pStoreItem->Kind))
		{
			ITEM_GENERAL *pPeerItemG = i_pPeerFISock->m_ItemManager.GetItemGeneralByUID(pTItem->pStoreItem->UniqueNumber);
			if(NULL == pPeerItemG)
			{// 2006-05-12 by cmkwon, ִ  κ  
				return ERR_PROTOCOL_NO_SUCH_ITEM;
			}
			nInsertInventoryCnt++;
		}
		else
		{
			ITEM_GENERAL *pPeerItemG = i_pPeerFISock->m_ItemManager.GetFirstItemGeneralByItemNum(pTItem->pStoreItem->ItemNum);
			if(NULL == pPeerItemG)
			{// 2006-05-12 by cmkwon, ִ  κ  
				return ERR_PROTOCOL_NO_SUCH_ITEM;
			}
			else if(pTItem->Count > pPeerItemG->CurrentCount)
			{// 2006-05-12 by cmkwon, ִ  κ   ַ  ۴
				return ERR_PROTOCOL_INVALID_ITEM_COUNT;
			}

			ITEM_GENERAL *pMeItemG = m_ItemManager.GetFirstItemGeneralByItemNum(pTItem->pStoreItem->ItemNum);
			if(NULL == pMeItemG)
			{
				nInsertInventoryCnt++;
			}
			else if(MAX_ITEM_COUNTS < (INT64)pTItem->Count + (INT64)pMeItemG->CurrentCount)
			{// 2006-05-11 by cmkwon, īͺ  ִ  ʰ
				return ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER;
			}
		}
		
		// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
		if(m_ItemManager.GetMaxInventoryCount() < this->m_ItemManager.GetInventoryItemCounts() + nInsertInventoryCnt)
		{
			return ERR_PROTOCOL_INVENTORY_FULL_ITEM;
		}
	}

	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::TradeInsertItems(CFieldIOCPSocket *i_pPeerFISock)
/// \brief		
/// \author		cmkwon
/// \date		2006-05-11 ~ 2006-05-11
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::TradeInsertItems(CFieldIOCPSocket *i_pPeerFISock)
{
	mtmapUID2TradeItem::iterator itr = i_pPeerFISock->m_mapTradeItem.begin();
	for(; itr != i_pPeerFISock->m_mapTradeItem.end(); itr++)
	{
		TradeItem		*pTItem			= &itr->second;
		ITEM_GENERAL	*pTradeItemG	= pTItem->pStoreItem;
		if(FALSE == IS_COUNTABLE_ITEM(pTItem->pStoreItem->Kind))
		{
			///////////////////////////////////////////////////////////////////////////////
			// 1. ִ  Log 
			ITEM_GENERAL tmpItemOnlyForLog = *pTradeItemG;	// : only α׿! α׸    0  ϹǷ ӽ÷   Ѵ.
			tmpItemOnlyForLog.CurrentCount = 0;
			CAtumLogSender::SendLogMessageITEMTradeSend(i_pPeerFISock, &tmpItemOnlyForLog, 1, &this->m_character);	//  ŷ: ֱ, non-countable

			///////////////////////////////////////////////////////////////////////////////
			// 2.   κ  - DB Ʈ  , ޸𸮸  

			i_pPeerFISock->m_ItemManager.RemoveTimerFixedTermShape(pTradeItemG);		// 2012-10-10 by hskim, Ⱓ Ӽ  (Ⱓ )

			if(FALSE == i_pPeerFISock->m_ItemManager.DeleteItemFromCharacterByUID(pTradeItemG->UniqueNumber, IUT_TRADE, ITEM_IN_CHARACTER, FALSE, TRUE, FALSE))
			{
				///////////////////////////////////////////////////////////////////////////////
				// 2008-07-23 by cmkwon,    üũ ߰
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] DeleteItemFromCharacterByUID error !!, CharInfo(%s) ItemInfo(%s) PeerCharInfo(%s)\r\n"
					, GetCharacterString(i_pPeerFISock->GetCharacter(), string()), GetItemGeneralString(pTradeItemG, string()), GetCharacterString(GetCharacter(), string()));
			}

			///////////////////////////////////////////////////////////////////////////////
			// 3.  κ  ߰ - DB Ʈ  
			pTradeItemG->Wear				= FALSE;
			pTradeItemG->ItemWindowIndex	= POS_INVALID_POSITION;
			this->m_ItemManager.InsertItemGeneralByPointer(pTradeItemG, IUT_TRADE, FALSE, ITEM_IN_CHARACTER, FALSE);

			this->m_ItemManager.RegisterTimerFixedTermShape(pTradeItemG);		// 2012-10-10 by hskim, Ⱓ Ӽ  (Ⱓ )

			///////////////////////////////////////////////////////////////////////////////
			// 4. æƮ ó
			vectENCHANT tmvectEnchant;
			if(i_pPeerFISock->PopAllEnchantByItemUID(&tmvectEnchant, pTradeItemG->UniqueNumber))
			{
				this->DeleteAllEnchantToItem(pTradeItemG->UniqueNumber);		// 2006-05-11 by cmkwon,   ʱȭ
				this->InsertEnchantToItem(pTradeItemG, &tmvectEnchant);
			}

			///////////////////////////////////////////////////////////////////////////////
			// 5.   ó
			// 2010-06-15 by shcho&hslee ý - ŷ    ó
			if(pTradeItemG->Kind == ITEMKIND_PET_ITEM)
			{
				TradePetData( pTradeItemG->UniqueNumber, i_pPeerFISock );
			}
			// END 2010-06-15 by shcho&hslee ý - ŷ    ó

			///////////////////////////////////////////////////////////////////////////////
			// 6. DB 
			QPARAM_TRADE_MOVEITEM	*pMoveItem = new QPARAM_TRADE_MOVEITEM;
			pMoveItem->ToAccountUID		= GetCharacter()->AccountUniqueNumber;
			pMoveItem->ToCharacterUID	= GetCharacter()->CharacterUniqueNumber;
			pMoveItem->FromCharacterUID	= i_pPeerFISock->GetCharacter()->CharacterUniqueNumber;
			pMoveItem->MoveItemUID		= pTItem->pStoreItem->UniqueNumber;
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_TradeMoveItem, this, m_character.AccountUniqueNumber, pMoveItem);

			///////////////////////////////////////////////////////////////////////////////
			// 7. ޴  α 
			CAtumLogSender::SendLogMessageITEMTradeRecv(this, pTradeItemG, 1, &i_pPeerFISock->m_character);	//  ŷ: ޱ, non-countable
		}
		else
		{
			int nTradeItemNum = pTradeItemG->ItemNum;

			///////////////////////////////////////////////////////////////////////////////
			// 1.  κ丮  ߰
			m_ItemManager.InsertItemGeneralByItemNum(pTradeItemG->ItemNum, pTItem->Count, IUT_TRADE, ITEM_IN_CHARACTER, TRUE, TRUE, i_pPeerFISock->GetCharacter()->CharacterUniqueNumber);

			///////////////////////////////////////////////////////////////////////////////
			// 2. ޴  α 
			ITEM_GENERAL *pMeItemG = m_ItemManager.GetFirstItemGeneralByItemNum(pTradeItemG->ItemNum);
			if(NULL == pMeItemG)
			{// 2006-05-15 by cmkwon,  ߰Ǵ , DB ߰, α׵ DB ߰  .
				char szSysLog[1024];
				wsprintf(szSysLog, "[Notify] CFieldIOCPSocket::TradeInsertItems_ Insert to DB CharacterInfo(%s:%d), PeerCharacterInfo(%s:%d), ItemNum(%d), ItemCount(%d)\r\n"
					, m_character.CharacterName, m_character.CharacterUniqueNumber
					, i_pPeerFISock->GetCharacter()->CharacterName, i_pPeerFISock->GetCharacter()->CharacterUniqueNumber
					, pTItem->pStoreItem->ItemNum, pTItem->Count);
				DbgOut(szSysLog);
				g_pFieldGlobal->WriteSystemLog(szSysLog);
			}
			else
			{
				CAtumLogSender::SendLogMessageITEMTradeRecv(this, pMeItemG, pTItem->Count, &i_pPeerFISock->m_character);
			}
			
			///////////////////////////////////////////////////////////////////////////////
			// 3. ִ  κ    Ȥ 
			ITEM_GENERAL tmpItemOnlyForLog = *pTradeItemG;	// : only α׿!
			i_pPeerFISock->m_ItemManager.UpdateItemCountByPointer(pTItem->pStoreItem, -pTItem->Count, IUT_TRADE);// start 2012-11-21 by khkim, GLog 2

			///////////////////////////////////////////////////////////////////////////////
			// 4. ִ  α
			ITEM_GENERAL *pPeerItemG = i_pPeerFISock->m_ItemManager.GetFirstItemGeneralByItemNum(nTradeItemNum);
			if(NULL == pPeerItemG)
			{
				tmpItemOnlyForLog.CurrentCount	= 0;
				CAtumLogSender::SendLogMessageITEMTradeSend(i_pPeerFISock, &tmpItemOnlyForLog, pTItem->Count, &this->m_character);	//  ŷ: ֱ
			}
			else
			{
				CAtumLogSender::SendLogMessageITEMTradeSend(i_pPeerFISock, pPeerItemG, pTItem->Count, &this->m_character);	//  ŷ: ֱ
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::TradePetData(UID64_t i_tradeUniqeNum, CFieldIOCPSocket *i_pPeerFISock)
/// \brief		// 2010-06-15 by shcho&hslee ý - ŷ    ó		
/// \author		shcho & jskim
/// \date		2006-08-10
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::TradePetData(UID64_t i_tradeUniqeNum, CFieldIOCPSocket *i_pPeerFISock)
{
	//   ////////
	vecPetCurrentInfo::iterator Mypetiter = this->m_ItemManager.m_vectPetCurrentInfo.begin();
	vecPetCurrentInfo::iterator Peerpetiter = i_pPeerFISock->m_ItemManager.m_vectPetCurrentInfo.begin();
	/////////////////////

	for( ; Mypetiter != this->m_ItemManager.m_vectPetCurrentInfo.end() ; ++Mypetiter)
	{
		//     
		if( Mypetiter == this->m_ItemManager.m_vectPetCurrentInfo.end() )
		{
			break;
		}
		if( i_tradeUniqeNum == (*Mypetiter)->CreatedPetUID )
		{ // ڽ ̸ 
			this->m_ItemManager.DeleteItemPetFromCharacterByUID((*Mypetiter)->CreatedPetUID); // Լ ο  .
			break;
		}
	}

	//ڽ  ƴ϶ ߰
	for( ; Peerpetiter != i_pPeerFISock->m_ItemManager.m_vectPetCurrentInfo.end() ; ++Peerpetiter )
 	{
		if( i_tradeUniqeNum == (*Peerpetiter)->CreatedPetUID )
 		{
 			this->m_ItemManager.m_vectPetCurrentInfo.push_back( (*Peerpetiter) );
			//߰   
			INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_PET_BASEDATA, T_FC_TRADE_INSERT_CURRENT_PET_DATA, Petcurrentmsg, sendPetbuff);

			///////////////////////////////////////////////////////////////////////////////////////
			// start 2011-08-17 by hskim, Ʈ ý 2 - ڷ  
			//
			//  
			//

// 			Petcurrentmsg->CreatedPetUID		= (*Peerpetiter)->CreatedPetUID;
// 			Petcurrentmsg->EnableEditPetName	= (*Peerpetiter)->EnableEditPetName;
// 			Petcurrentmsg->EnableLevelUp		= (*Peerpetiter)->EnableLevelUp;
// 			Petcurrentmsg->PetExp				= (*Peerpetiter)->PetExp;
// 			Petcurrentmsg->PetIndex				= (*Peerpetiter)->PetIndex;
// 			Petcurrentmsg->PetLevel				= (*Peerpetiter)->PetLevel;
// 			Petcurrentmsg->SourceIndex_City		= (*Peerpetiter)->SourceIndex_City;
// 			Petcurrentmsg->SourceIndex_Field	= (*Peerpetiter)->SourceIndex_Field;
// 			Petcurrentmsg->Stamina				= (*Peerpetiter)->Stamina;
// 
// 			for ( int i = 0 ; i < SIZE_MAX_PETSKILLITEM ; ++i )
// 			{
// 				if ( (*Peerpetiter)->pItem_PetSkill[i] )
// 					Petcurrentmsg->ItemIndex_PetSkill[i] = (*Peerpetiter)->pItem_PetSkill[i]->ItemNum;
// 			}
// 			
// 			memcpy(Petcurrentmsg->szPetName,(*Peerpetiter)->szPetName,SIZE_MAX_PET_NAME);

			/////////
			// 

			Petcurrentmsg->CreatedPetUID		= (*Peerpetiter)->CreatedPetUID;
			Petcurrentmsg->PetExp				= (*Peerpetiter)->PetExp;
			Petcurrentmsg->PetIndex				= (*Peerpetiter)->PetIndex;
			Petcurrentmsg->PetLevel				= (*Peerpetiter)->PetLevel;
			Petcurrentmsg->PetExpRatio			= (*Peerpetiter)->PetExpRatio;
			Petcurrentmsg->PetEnableSocketCount	= (*Peerpetiter)->PetEnableSocketCount;

			memcpy(Petcurrentmsg->PetName, (*Peerpetiter)->PetName, SIZE_MAX_PET_NAME);

			memcpy(&Petcurrentmsg->PetSocketItemUID, &((*Peerpetiter)->PetSocketItemUID), sizeof(Petcurrentmsg->PetSocketItemUID));
			memcpy(&Petcurrentmsg->PetKitHP, &((*Peerpetiter)->PetKitHP), sizeof(Petcurrentmsg->PetKitHP));
			memcpy(&Petcurrentmsg->PetKitShield, &((*Peerpetiter)->PetKitShield), sizeof(Petcurrentmsg->PetKitShield));
			memcpy(&Petcurrentmsg->PetKitSP, &((*Peerpetiter)->PetKitSP), sizeof(Petcurrentmsg->PetKitSP));
			memcpy(&Petcurrentmsg->PetAutoSkill, &((*Peerpetiter)->PetAutoSkill), sizeof(Petcurrentmsg->PetAutoSkill));

			// end 2011-08-17 by hskim, Ʈ ý 2 - ڷ  
			///////////////////////////////////////////////////////////////////////////////////////

			this->SendAddData( sendPetbuff, MSG_SIZE(MSG_FC_ITEM_PET_BASEDATA) ); //   
			break;
 		}
 	}
}

CFieldIOCPSocket* CFieldIOCPSocket::SendP2PPKEndAndReset(CFieldIOCPSocket *pPeerSocket, BOOL bSendToPeer)
{
	if (NULL == pPeerSocket && bSendToPeer)
	{
		pPeerSocket = ms_pFieldIOCP->GetFieldIOCPSocket(m_peerP2PPKClientIndex);
	}

	// Send MSG_FC_BATTLE_END_P2P_PK
	INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_END_P2P_PK, T_FC_BATTLE_END_P2P_PK, pMsgEnd, pMsgEndBuf);
	pMsgEnd->EndType = BATTLE_END_END;

	// To Me
	pMsgEnd->PeerClientIndex = m_peerP2PPKClientIndex;
	SendAddData(pMsgEndBuf, MSG_SIZE(MSG_FC_BATTLE_END_P2P_PK));

	// To Peer
	if (pPeerSocket != NULL && bSendToPeer)
	{
		pMsgEnd->PeerClientIndex = m_character.ClientIndex;
		pPeerSocket->SendAddData(pMsgEndBuf, MSG_SIZE(MSG_FC_BATTLE_END_P2P_PK));
	}

	// reset P2P PK
	m_peerP2PPKClientIndex = INVALID_CLIENT_INDEX;
	m_bP2PPKStarted = FALSE;
	if (pPeerSocket != NULL)
	{
		pPeerSocket->m_peerP2PPKClientIndex = INVALID_CLIENT_INDEX;
		pPeerSocket->m_bP2PPKStarted = FALSE;
	}

	return pPeerSocket;
}

void CFieldIOCPSocket::OnP2PPKEnd(CFieldIOCPSocket *pWinnerSocket, CFieldIOCPSocket *pLoserSocket)
{
	if (pWinnerSocket != NULL && IS_VALID_CLIENT_INDEX(pWinnerSocket->m_character.ClientIndex)
		&& pLoserSocket != NULL && IS_VALID_CLIENT_INDEX(pLoserSocket->m_character.ClientIndex))
	{
		// ϴ PK  ۵Ǿ ó
		if (pLoserSocket->m_bP2PPKStarted && pWinnerSocket->m_bP2PPKStarted)
		{
			// 2005-11-03 by cmkwon, ø  ¸  ĳ͸  Ų.
			if(pWinnerSocket->IsCityCurrentFieldMapChannel())
			{
				pWinnerSocket->WarpToCityMap();
			}
			INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_END_P2P_PK, T_FC_BATTLE_END_P2P_PK, pMsgEndPK, pMsgEndPKBuf);
			// To Loser
			pMsgEndPK->EndType = BATTLE_END_DEFEAT;
			pMsgEndPK->PeerClientIndex = pWinnerSocket->m_character.ClientIndex;
			pLoserSocket->SendAddData(pMsgEndPKBuf, MSG_SIZE(MSG_FC_BATTLE_END_P2P_PK));
			// send log
			CAtumLogSender::SendLogMessagePKLOSS(pLoserSocket, pWinnerSocket->m_character.CharacterUniqueNumber);
			// To Winner
			pMsgEndPK->EndType = BATTLE_END_WIN;
			pMsgEndPK->PeerClientIndex = pLoserSocket->m_character.ClientIndex;
			pWinnerSocket->SendAddData(pMsgEndPKBuf, MSG_SIZE(MSG_FC_BATTLE_END_P2P_PK));
			// send log
			CAtumLogSender::SendLogMessagePKWIN(pWinnerSocket, pLoserSocket->m_character.CharacterUniqueNumber);

			// PK ġ 
			// Winner
			pWinnerSocket->m_character.PKWinPoint += 1;
// 2005-12-27 by cmkwon, 1:1 PK ġ ø ʴ´ - ġ Ÿ ׿  ȴ.
//			pWinnerSocket->m_character.Propensity += max(0, (10 + pLoserSocket->m_character.Level - pWinnerSocket->m_character.Level));
			pWinnerSocket->CheckAndUpdateStatus();
			pWinnerSocket->SendCharacterInfo(T_FC_CHARACTER_CHANGE_PKPOINT);
			// DB 
			QPARAM_CHARACTER_CHANGE_PKPOINT *pQChangePKPointWinner = new QPARAM_CHARACTER_CHANGE_PKPOINT;
			pQChangePKPointWinner->CharacterUniqueNumber = pWinnerSocket->m_character.CharacterUniqueNumber;
			pQChangePKPointWinner->Propensity = pWinnerSocket->m_character.Propensity;
			pQChangePKPointWinner->PKWinPoint = pWinnerSocket->m_character.PKWinPoint;
			pQChangePKPointWinner->PKLossPoint = pWinnerSocket->m_character.PKLossPoint;
			pWinnerSocket->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangePKPoint, pWinnerSocket, pWinnerSocket->m_character.AccountUniqueNumber, pQChangePKPointWinner);
			// Loser
			pLoserSocket->m_character.PKLossPoint += 1;
// 2005-11-08 by cmkwon and ȹ, й ġ ٿ 
//			pLoserSocket->m_character.Propensity -= (5 + max(pLoserSocket->m_character.Level - pWinnerSocket->m_character.Level, 0));
			pLoserSocket->CheckAndUpdateStatus();
			pLoserSocket->SendCharacterInfo(T_FC_CHARACTER_CHANGE_PKPOINT);
			// DB 
			QPARAM_CHARACTER_CHANGE_PKPOINT *pQChangePKPointLoser = new QPARAM_CHARACTER_CHANGE_PKPOINT;
			pQChangePKPointLoser->CharacterUniqueNumber = pLoserSocket->m_character.CharacterUniqueNumber;
			pQChangePKPointLoser->Propensity = pLoserSocket->m_character.Propensity;
			pQChangePKPointLoser->PKWinPoint = pLoserSocket->m_character.PKWinPoint;
			pQChangePKPointLoser->PKLossPoint = pLoserSocket->m_character.PKLossPoint;
			pLoserSocket->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangePKPoint, pLoserSocket, pLoserSocket->m_character.AccountUniqueNumber, pQChangePKPointLoser);
		}
		
		// PK Reset
		pLoserSocket->m_peerP2PPKClientIndex	= INVALID_CLIENT_INDEX;
		pLoserSocket->m_bP2PPKStarted			= FALSE;
		pWinnerSocket->m_peerP2PPKClientIndex	= INVALID_CLIENT_INDEX;
		pWinnerSocket->m_bP2PPKStarted			= FALSE;
	}
}

ProcessResult CFieldIOCPSocket::Process_FC_CLIENT_REPORT(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize;
	MSG_FC_CLIENT_REPORT		*pMsgClientReport;

	nRecvTypeSize = sizeof(MSG_FC_CLIENT_REPORT);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_CLIENT_REPORT, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14053);
		return RES_RETURN_FALSE;
	}
	pMsgClientReport = (MSG_FC_CLIENT_REPORT*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	// start 2011-10-28 by hskim, 缳  
	MSG_FC_CLIENT_REPORT Temp;

	STRNCPY_MEMSET(Temp.ClientPrivateIP, pMsgClientReport->ClientPrivateIP, SIZE_MAX_IPADDRESS);
	STRNCPY_MEMSET(Temp.CharacterName, pMsgClientReport->CharacterName, SIZE_MAX_CHARACTER_NAME);
	STRNCPY_MEMSET(Temp.Message, pMsgClientReport->Message, SIZE_MAX_CLIENT_REPORT);
	// end 2011-10-28 by hskim, 缳  

	char szSystemLog[sizeof(MSG_FC_CLIENT_REPORT)+100];
	sprintf(szSystemLog, "CLIENT REPORT from %s(%s): %s\r\n",
		Temp.CharacterName, Temp.ClientPrivateIP, Temp.Message);
	g_pFieldGlobal->WriteSystemLog(szSystemLog);		// 2011-10-28 by hskim, 缳  
	DBGOUT(szSystemLog);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_ADMIN_GET_SERVER_STAT(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(FALSE == IsValidCharacter(FALSE))
	{// 2008-03-13 by cmkwon, Ը  Ŭ̾Ʈ ñ°  - 
		return RES_BREAK;
	}

	if (NULL == m_pCurrentFieldMapChannel
		|| FALSE == COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER))		// 2005-12-22 by cmkwon,   ߰
	{
#ifdef _SHOW_LATENCY
		if (NULL == m_pCurrentFieldMapChannel)
		{
			return RES_BREAK;
		}
		INIT_MSG_WITH_BUFFER(MSG_FC_ADMIN_GET_SERVER_STAT_OK, T_FC_ADMIN_GET_SERVER_STAT_OK, pStatOK, pStatOKBuf);
		//Send just fake data because it's "just" a normal user
		pStatOK->CurrentANIUserCount = 0;
		pStatOK->CurrentBCUUserCount = 0;
		pStatOK->CurrentMapChannelIndex = m_character.MapChannelIndex;
		pStatOK->CurrentUserCount = 0;

		SendAddData(pStatOKBuf, MSG_SIZE(MSG_FC_ADMIN_GET_SERVER_STAT_OK));

		return RES_RETURN_TRUE;
#endif
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_ADMIN_GET_SERVER_STAT_OK, T_FC_ADMIN_GET_SERVER_STAT_OK, pStatOK, pStatOKBuf);
	pStatOK->CurrentMapChannelIndex = m_character.MapChannelIndex;
	pStatOK->CurrentUserCount = m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.size();
	int iBCUCount = 0;
	int iANICount = 0;
	mtmapUID2FieldIOCPSocket::iterator it;
	for (it = m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.begin(); it != m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.end(); it++)
	{
		if (COMPARE_INFLUENCE(it->second->m_character.InfluenceType, INFLUENCE_TYPE_VCN))
		{
			iBCUCount++;
		}
		else if (COMPARE_INFLUENCE(it->second->m_character.InfluenceType, INFLUENCE_TYPE_ANI))
		{
			iANICount++;
		}
	}

	pStatOK->CurrentANIUserCount = iANICount;
	pStatOK->CurrentBCUUserCount = iBCUCount;

	SendAddData(pStatOKBuf, MSG_SIZE(MSG_FC_ADMIN_GET_SERVER_STAT_OK));

	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FM_PRINTMAP(const char* pPacket, int nLength, int &nBytesUsed)
{
	int					nRecvTypeSize = 0;
	MSG_FM_PRINTMAP		*pRePrintMap = NULL;

	nRecvTypeSize = sizeof(MSG_FM_PRINTMAP);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FM_PRINTMAP, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14056);
		return RES_RETURN_FALSE;
	}
	pRePrintMap = (MSG_FM_PRINTMAP*)(pPacket+nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	CFieldMapProject *pFMPro = (CFieldMapProject*)ms_pFieldIOCP->GetMapWorkspace()->GetMapProjectByMapIndex(pRePrintMap->MapChannelIndex.MapIndex);
	if(NULL == pFMPro){				return RES_BREAK;}

	CFieldMapChannel * pFMChann = pFMPro->GetFieldMapChannelByIndex(pRePrintMap->MapChannelIndex.ChannelIndex);
	if(NULL == pFMChann){			return RES_BREAK;}

#ifdef _DEBUG
	pFMChann->printUnitCountsPerBlock();
#endif
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FM_SAVE_MAPBLOCK_INFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize = 0;
	MSG_FM_SAVE_MAPBLOCK_INFO	*pRecvMapBlockInfo = NULL;

	nRecvTypeSize = sizeof(MSG_FM_SAVE_MAPBLOCK_INFO);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FM_SAVE_MAPBLOCK_INFO, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14056);
		return RES_RETURN_FALSE;
	}
	pRecvMapBlockInfo = (MSG_FM_SAVE_MAPBLOCK_INFO*)(pPacket+nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	CFieldMapProject *pFMPro = (CFieldMapProject*)ms_pFieldIOCP->GetMapWorkspace()->GetMapProjectByMapIndex(pRecvMapBlockInfo->MapChannelIndex.MapIndex);
	if(NULL == pFMPro){				return RES_BREAK;}

	CFieldMapChannel * pFMChann = pFMPro->GetFieldMapChannelByIndex(pRecvMapBlockInfo->MapChannelIndex.ChannelIndex);
	if(NULL == pFMChann){			return RES_BREAK;}

	pFMChann->SaveUnitCountsPerBlock();
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FM_GET_MAP_USER_COUNTS(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize = 0;
	MSG_FM_GET_MAP_USER_COUNTS	*pRecvMapUserCounts = NULL;

	nRecvTypeSize = sizeof(MSG_FM_GET_MAP_USER_COUNTS);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FM_GET_MAP_USER_COUNTS, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14056);
		return RES_RETURN_FALSE;
	}
	pRecvMapUserCounts = (MSG_FM_GET_MAP_USER_COUNTS*)(pPacket+nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	CFieldMapProject *pFMapPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pRecvMapUserCounts->MapChannIndex.MapIndex);
	if(NULL == pFMapPro){				return RES_BREAK;}

	CFieldMapChannel *pFMapChann = pFMapPro->GetFieldMapChannelByIndex(pRecvMapUserCounts->MapChannIndex.ChannelIndex);
	if(NULL == pFMapChann){				return RES_BREAK;}

	INIT_MSG_WITH_BUFFER(MSG_FM_GET_MAP_USER_COUNTS_ACK, T_FM_GET_MAP_USER_COUNTS_ACK, pSendUserCountsAck, SendB);
	pSendUserCountsAck->MapChannIndex = pRecvMapUserCounts->MapChannIndex;
	pSendUserCountsAck->AccumulatedUserCounts		= pFMapChann->m_uiAccumulatedUserCountsInChannel;
	pSendUserCountsAck->CurrentUserCounts			= pFMapChann->GetNumClients();
	pFMapChann->UpdateMaxUserCounts(pSendUserCountsAck->CurrentUserCounts);
	pSendUserCountsAck->MaxUserCounts				= pFMapChann->m_uiMaxUserCountsInChannel;
	pSendUserCountsAck->AccumulatedMonsterCounts	= pFMapChann->m_uiAccumulatedMonsterCountsInChannel;
	pSendUserCountsAck->CurrentMonsterCounts		= pFMapChann->GetNumMonsters();
	
	SendAddData(SendB, MSG_SIZE(MSG_FM_GET_MAP_USER_COUNTS_ACK));
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FM_SET_SERVICE_STATE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FM_SET_SERVICE_STATE,
									MSG_FM_SET_SERVICE_STATE, pMsgSetServiceState);

	switch(pMsgSetServiceState->ServiceType)
	{
	case SERVER_SERVICE_TYPE_QUEST:
		ms_pFieldIOCP->m_ServicePauseManager.SetQuestServiceState(pMsgSetServiceState->ServiceState);
		break;
	default:
		// no such server service type
		break;
	}

	SendAddMessageType(T_FM_SET_SERVICE_STATE_OK);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FM_RELOAD_SERVER_INFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FM_RELOAD_SERVER_INFO,
									MSG_FM_RELOAD_SERVER_INFO, pMsgReloadInfo);

	switch(pMsgReloadInfo->InfoType)
	{
	case SERVER_INFO_TYPE_QUEST:
		{
			if (!ms_pFieldIOCP->LoadQuestInfo(TRUE))
			{
				DBGOUT(STRERR_S_F2NOTIFY_0015);
			}
		}
		break;
	default:
		// no such server info type
		break;
	}

	SendAddMessageType(T_FM_RELOAD_SERVER_INFO_OK);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FM_INCREASE_CHANNEL(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FM_INCREASE_CHANNEL,
									MSG_FM_INCREASE_CHANNEL, pMsgIncreaseChannel);

	// 2004-10-07 by cmkwon, ä ǽð  
	return RES_BREAK;
	
//	CFieldMapProject *pMapProject = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pMsgIncreaseChannel->MapIndex);
//	if (pMapProject == NULL)
//	{
//		SendErrorMessage(T_FM_INCREASE_CHANNEL, ERR_PROTOCOL_NO_SUCH_MAP_SERVED, pMsgIncreaseChannel->MapIndex);
//		return RES_BREAK;
//	}
//
//	BOOL bRet = pMapProject->IncreaseMapChannels(1);
//
//	if (!bRet)
//	{
//		// error
//		return RES_BREAK;
//	}
//
//	BYTE SendBuf[SIZE_MAX_PACKET];
//
//	INIT_MSG(MSG_FM_SEND_CHANNEL_INFO, T_FM_SEND_CHANNEL_INFO, pSendProjectInfo, SendBuf);
//	pSendProjectInfo->ChannelIndex = pMapProject->GetLastFieldMapChannel(FALSE)->m_MapChannelIndex.ChannelIndex;
//	pSendProjectInfo->projectInfo = *((PROJECTINFO*)pMapProject);
//	SendAddData(SendBuf, MSG_SIZE(MSG_FM_SEND_CHANNEL_INFO));
//
//	// NPC  
//	INIT_MSG(MSG_FN_CONNECT_INCREASE_CHANNEL, T_FN_CONNECT_INCREASE_CHANNEL, pFNIncreaseChannel, SendBuf);
//	pFNIncreaseChannel->MapIndex = pMapProject->m_nMapIndex;
//	pFNIncreaseChannel->TotalChannelCount = pMapProject->GetNumberOfMapChannels(FALSE);
//	pMapProject->Send2NPCServer(SendBuf, MSG_SIZE(MSG_FN_CONNECT_INCREASE_CHANNEL));
//
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FM_SET_CHANNEL_STATE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FM_SET_CHANNEL_STATE,
									MSG_FM_SET_CHANNEL_STATE, pMsgSetChannelState);

	CFieldMapProject *pMapProject = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pMsgSetChannelState->MapChannelIndex.MapIndex);
	if (pMapProject == NULL)
	{
		SendErrorMessage(T_FM_SET_CHANNEL_STATE, ERR_PROTOCOL_NO_SUCH_MAP_SERVED, pMsgSetChannelState->MapChannelIndex.MapIndex);
		return RES_BREAK;
	}

	CFieldMapChannel *pMapChannel = pMapProject->GetFieldMapChannelByIndex(pMsgSetChannelState->MapChannelIndex.ChannelIndex);
	if (pMapChannel == NULL)
	{
		SendErrorMessage(T_FM_SET_CHANNEL_STATE, ERR_PROTOCOL_NO_SUCH_CHANNEL, pMsgSetChannelState->MapChannelIndex.ChannelIndex);
		return RES_BREAK;
	}

	pMapChannel->SetChannelState(pMsgSetChannelState->EnableChannel);

	INIT_MSG_WITH_BUFFER(MSG_FM_SET_CHANNEL_STATE_OK, T_FM_SET_CHANNEL_STATE_OK, pMsgSetStateOK, SendBuf);
	pMsgSetStateOK->MapChannelIndex = pMsgSetChannelState->MapChannelIndex;
	pMsgSetStateOK->IsEnabled = pMapChannel->IsEnabled();
	SendAddData(SendBuf, MSG_SIZE(MSG_FM_SET_CHANNEL_STATE_OK));

	// NPC  
	INIT_MSG(MSG_FN_CONNECT_SET_CHANNEL_STATE, T_FN_CONNECT_SET_CHANNEL_STATE, pFNSetState, SendBuf);
	pFNSetState->MapChannelIndex = pMsgSetChannelState->MapChannelIndex;
	pFNSetState->EnableChannel = pMapChannel->IsEnabled();
	pMapProject->Send2NPCServer(SendBuf, MSG_SIZE(MSG_FN_CONNECT_SET_CHANNEL_STATE));

	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FM_CITYWAR_CHANGE_WAR_TIME(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FM_CITYWAR_CHANGE_WAR_TIME,
									MSG_FM_CITYWAR_CHANGE_WAR_TIME, pRWarTime);

	CCityWar *pCityWar = ms_pFieldIOCP->m_cityWarManager.GetCityWarPtrByCityWarMapIndex(pRWarTime->MapChannelIndex.MapIndex);
	if(NULL == pCityWar)
	{
		return RES_BREAK;
	}

	if(FALSE == pCityWar->ChangeWarTimeCityWar(&pRWarTime->CityWarATimeDefault, &pRWarTime->CityWarATimeSetting))
	{
		return RES_BREAK;
	}
	
	///////////////////////////////////////////////////////////////////////////////
	// ͷ   
	INIT_MSG_WITH_BUFFER(MSG_FM_CITYWAR_CHANGED_OCCUPY_INFO, T_FM_CITYWAR_CHANGED_OCCUPY_INFO, pSMsg, SendBuf);
	pSMsg->MapChannelIndex.MapIndex		= pCityWar->MapIndex;	
	pSMsg->MapChannelIndex.ChannelIndex	= 0;
	pSMsg->cityWarOccupyInfo			= *pCityWar->GetCITY_OCCUPY_INFO();
	ms_pFieldIOCP->SendMessageToMonitor(SendBuf, MSG_SIZE(MSG_FM_CITYWAR_CHANGED_OCCUPY_INFO));
	return RES_RETURN_TRUE;
}
BOOL CFieldIOCPSocket::CheckCommandExecutability(USHORT i_nAllowedRace, BOOL i_bAllowAdminTool /* = FALSE */)
{
	BOOL bRet = COMPARE_RACE(m_character.Race, i_nAllowedRace)
				|| (i_bAllowAdminTool && m_PeerSocketType == ST_ADMIN_TOOL);

	return bRet;
}

BOOL CFieldIOCPSocket::HandleAdminCommands(const char *cmd)
{
	char *token;
	char seps[] = " ";
	char buffer[SIZE_MAX_CHAT_MESSAGE];

	STRNCPY_MEMSET(buffer, cmd, SIZE_MAX_CHAT_MESSAGE);
	token = strtok(buffer, seps);

	// 2011-11-18 by shcho, ٿ ٿ  ó - ߰ ɹ 
	if( CheckAdminCommand(token) )
		return FALSE;

	if (0 == stricmp(token, STRCMD_CS_COMMAND_MENT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_MENT_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_MENT_2))
	{
		if(FALSE == GCheckLimitLevel(CHECK_TYPE_CHARACTER_MENT, m_character.Level))
		{
			SendErrorMessage(T_FIELD_IOCP, ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED, CHECK_TYPE_CHARACTER_MENT, 0);
			return FALSE;
		}

		// format: "/Ʈ [String]" - ĳ Ʈ 

		token = strtok(NULL, "");		// 鵵 ؾ ϹǷ seps  ʴ´
		if(NULL == token)
		{
			MEMSET_ZERO(this->m_szCharacterMent, SIZE_STRING_32);
		}
		else
		{
			memcpy(this->m_szCharacterMent, token, SIZE_STRING_32-1);
		}
		INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_CHANGE_CHARACTER_MENT, T_FC_CHARACTER_CHANGE_CHARACTER_MENT
			, pS2CMent, SendBuf);		
		pS2CMent->ClientIdx = m_character.ClientIndex;
		memcpy(pS2CMent->szCharacterMent1, this->m_szCharacterMent, SIZE_STRING_32);
		ms_pFieldIOCP->SendInRangeMessageAroundPosition(m_character.PositionVector, SendBuf
			, MSG_SIZE(MSG_FC_CHARACTER_CHANGE_CHARACTER_MENT), m_pCurrentFieldMapChannel);

		return TRUE;
	}
	else if (0 == stricmp(token, STRCMD_CS_COMMAND_GET_RND_DGA_TIMES))
	{
		if (!CheckCommandExecutability(RACE_OPERATION | RACE_GAMEMASTER))
		{
			return FALSE;
		}

		vector<ATUM_DATE_TIME> times = ms_pFieldIOCP->m_pDGAEventManager->m_pRndDGATimes;

		for (int i = 0; i < times.size(); i++)
		{
			SendString128(STRING_128_ADMIN_CMD, "DGA Time: Today %02d:%02d", times.at(i).Hour, times.at(i).Minute);
		}
		return TRUE;
	}
	else if (0 == stricmp(token, STRCMD_CS_COMMAND_GET_WARPOINT_ALL_USER))
	{
		BYTE infl;
		int count;

		token = strtok(NULL, seps);
		if (token != NULL)
		{
			infl = (BYTE)atoi(token);

			switch (infl)
			{
			case INFLUENCE_TYPE_ALL_MASK:
			case INFLUENCE_TYPE_ANI:
			case INFLUENCE_TYPE_NORMAL:
			case INFLUENCE_TYPE_VCN:
				break;
			default:
				return TRUE;
			}
		}
		else
		{
			return TRUE;
		}

		token = strtok(NULL, seps);
		if (token != NULL)
		{
			count = atoi(token);
		}
		else
		{
			return TRUE;
		}

		ms_pFieldIOCP->SendWarPointToInflClientByDGA(count, infl);
		SendString128(STRING_128_ADMIN_CMD, "Sent %d WarPoints to Nation %s", count, CAtumSJ::GetInfluenceTypeString(infl));
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_MOVE)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_MOVE_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER|RACE_DEMO|RACE_MONITOR) )
		{// 2008-09-09 by cmkwon,      ߰ - STRCMD_CS_COMMAND_MOVE, // 2006-04-13 by cmkwon, //DEMO  
			return FALSE;
		}

		// format: "/̵ [MapIndex] [ChannelIndex]" - ش  ̵
		token = strtok(NULL, seps);
		if (NULL == token)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_MOVE_HELP);
			return FALSE;
		}

		//////////////////////////////////////////////////////////////////////////
		// 2007-05-22 by dhjin, Ʒ ʿ  Ʒ  ̸  Ż ó Ѵ.
		if(IS_MAP_INFLUENCE_ARENA(m_pCurrentFieldMapChannel->GetMapInfluenceTypeW())
			&& m_ArenaInfo.IsValidArenaState() )
		{
			if(m_ArenaInfo.WatchState)
			{// 2007-06-21 by dhjin, ̸   ʱȭѴ.
				this->WatchEnd();
			}
			else
			{
				this->ms_pFieldIOCP->m_ArenaManager.DeleteMember(this);		// 2007-04-23 by dhjin,  
				this->m_ArenaInfo.ResetArenaInfo();		
				this->SendAddMessageType(T_FC_ARENA_REAVE_TEAM_OK);			// 2007-05-03 by dhjin, Ʒ    

				// 2008-01-15 by dhjin, Ʒ  - ʵ    Ͽ ó
				this->SendArenaCharacterDisConnect();
//				// 2007-06-07 by dhjin,   1
//				this->m_character.ArenaDisConnect += 1;
//				QPARAM_UPDATE_ARENA_DISCONNECT *pQparam = new QPARAM_UPDATE_ARENA_DISCONNECT;
//				pQparam->CharacterUID			= this->m_character.CharacterUniqueNumber;
//				pQparam->AccountUID				= this->m_character.AccountUniqueNumber;
//				pQparam->ArenaDisConnect		= this->m_character.ArenaDisConnect;
//				this->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateArenaDisConnect, this, 0, pQparam);
			}
		}
// 2007-10-23 by cmkwon, Ʒ  
//		MAP_CHANNEL_INDEX tmpMapChannelIndex;
//
//		CFieldMapProject *pMapProject
//			= (CFieldMapProject*)ms_pFieldIOCP->GetMapWorkspace()->GetMapProjectByMapIndex(atoi(token));
//		if (pMapProject != NULL)
//		{
//			tmpMapChannelIndex.MapIndex = atoi(token);
//
//			// ä 
//			token = strtok(NULL, seps);
//			if (token != NULL) { tmpMapChannelIndex.ChannelIndex = atoi(token); }
//			else
//			{
//				CFieldMapChannel *pFieldMapChannel = pMapProject->GetFirstFieldMapChannel(TRUE);
//				if (pFieldMapChannel == NULL)
//				{
//					return FALSE;
//				}
//				else
//				{
//					tmpMapChannelIndex.ChannelIndex = pFieldMapChannel->GetMapChannelIndex().ChannelIndex;
//				}
//			}
//
//			EventResult_t ret = WarpToMap(tmpMapChannelIndex);
//
//			// event result  ۾
//			if (ret == EVENT_RESULT_BREAK)
//			{
//#ifdef _DEBUG
//				DBGOUT(STRERR_S_F2NOTIFY_0016,
//					token, GetCharacterString(&m_character, string()));
//#endif
//				return TRUE;
//			}
//			else if (ret == EVENT_RESULT_CONTINUE)
//			{
//				return TRUE;
//			}
//		}
		CFieldMapProject *pMapProject = (CFieldMapProject*)ms_pFieldIOCP->GetMapWorkspace()->GetMapProjectByMapIndex(atoi(token));
		if (NULL == pMapProject)
		{
			SendString128(STRING_128_ADMIN_CMD, "Invalid MapIndex(%d) !!", atoi(token));
			return FALSE;
		}

		MAP_CHANNEL_INDEX tmpMapChannelIndex(atoi(token),0);	// 2007-10-23 by cmkwon, ⺻ 0 ä		
		token = strtok(NULL, seps);
		if (token != NULL) 
		{
			tmpMapChannelIndex.ChannelIndex = max(0, atoi(token));	// ä 
		}		
		CFieldMapChannel *pFMChann = ms_pFieldIOCP->GetFieldMapChannelByMapChannelIndex(tmpMapChannelIndex);
		if(NULL == pFMChann
			|| FALSE == pFMChann->IsEnabled())
		{// 2007-10-23 by cmkwon, ̵ û ä üũѴ
			SendString128(STRING_128_ADMIN_CMD, "Invalid ChannelIndex or is not enalbe channel !!, MapChannel(%d:%d)", tmpMapChannelIndex.MapIndex, tmpMapChannelIndex.ChannelIndex);
			return FALSE;
		}

// 2007-11-30 by cmkwon, ʿ ä ٸ 쵵  ó - üũ ʿ 
//		if(m_character.MapChannelIndex.MapIndex == tmpMapChannelIndex.MapIndex
//			&& m_character.MapChannelIndex.ChannelIndex != tmpMapChannelIndex.ChannelIndex)
//		{
//			SendString128(STRING_128_ADMIN_CMD, "can't warp !!, MapChannel(%d:%d)", tmpMapChannelIndex.MapIndex, tmpMapChannelIndex.ChannelIndex);
//			return FALSE;
//		}

		EventResult_t ret = WarpToMap(tmpMapChannelIndex);		
		if (ret != EVENT_RESULT_CONTINUE)
		{// event result  ۾
			g_pFieldGlobal->WriteSystemLogEX(TRUE, STRERR_S_F2NOTIFY_0016, token, GetCharacterString(&m_character, string()));
		}
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_COORDINATE) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_COORDINATE_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER|RACE_MONITOR|RACE_GUEST|RACE_DEMO) )
		{
			// ڿ, Ϲ ڴ 
			return FALSE;
		}

		D3DXVECTOR3 newPos;

		// format: "/ǥ [X] [Y]" -   ش ǥ ̵
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_COORDINATE_HELP);
			return TRUE;
		}
		newPos.x = atof(token)*SIZE_MAP_TILE_SIZE;
		token = strtok(NULL, seps);
		if (token == NULL){							return FALSE;}
		newPos.z = atof(token)*SIZE_MAP_TILE_SIZE;
		// 2013-06-26 by jhseol, ǥɾ ̰ 
		token = strtok(NULL, seps);
		float PosY = 100.0f;
		if (token != NULL)
		{
			PosY = atof(token)*SIZE_MAP_TILE_SIZE;
		}
		// end 2013-06-26 by jhseol, ǥɾ ̰ 
		if (!IS_IN_RANGE(5*SIZE_MAP_TILE_SIZE, newPos.x, m_pCurrentFieldMapChannel->m_pFieldMapProject->m_fSizeMap_X-5*SIZE_MAP_TILE_SIZE)
			|| !IS_IN_RANGE(5*SIZE_MAP_TILE_SIZE, newPos.z, m_pCurrentFieldMapChannel->m_pFieldMapProject->m_fSizeMap_Z-5*SIZE_MAP_TILE_SIZE))
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0084,
				(int)m_pCurrentFieldMapChannel->m_pFieldMapProject->m_fSizeMap_X/SIZE_MAP_TILE_SIZE - 5,
				(int)m_pCurrentFieldMapChannel->m_pFieldMapProject->m_fSizeMap_Z/SIZE_MAP_TILE_SIZE - 5);
			return FALSE;
		}

		newPos.y = m_pCurrentFieldMapChannel->m_pFieldMapProject->GetMapHeightIncludeWater(&newPos) + PosY;		// 2013-06-26 by jhseol, ǥɾ ̰ 
		WarpToMap(m_pCurrentFieldMapChannel->m_MapChannelIndex, &newPos);
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_LIST) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_LIST_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER|RACE_MONITOR) )
		{
			// ڿ, Ϲ ڴ 
			return FALSE;
		}

		// format: "/Ʈ" -    Ʈ (ִ 20)

		int nCount = 0;
		string strUserList = STRMSG_S_F2NOTIFY_0085;
		m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.lock();

		//  ü   , check: 䱸ϸ 츮, kelovon
//		SendString128(STRING_128_ADMIN_CMD, " \'%s\' ü : %d", m_character.MapName, m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.size());

		//    
		mtmapUID2FieldIOCPSocket::iterator itrChar = m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.begin();
		while (itrChar != m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.end())
		{
			// īƮ 
			nCount++;

			CFieldIOCPSocket *pSocket = itrChar->second;
/*
			SendString128(STRING_128_ADMIN_CMD, "%d: %s(: %s, : %s, : %d)",
								nCount,
								pSocket->m_character.CharacterName,
								pSocket->m_character.AccountName,
								pSocket->m_character.MapName,
								pSocket->m_character.Level);
*/
			strUserList += pSocket->m_character.CharacterName;

			if (nCount%5 == 0)
			{
				SendString128(STRING_128_ADMIN_CMD, (char*)strUserList.c_str());
				strUserList = STRMSG_S_F2NOTIFY_0085;
			}
			else
			{
				strUserList += " ";
			}

			if (nCount == 25)
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0086);
				break;
			}

			itrChar++;
		}
		//   
		SendString128(STRING_128_ADMIN_CMD, (char*)strUserList.c_str());

		m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.unlock();

		return TRUE;
	}
	else if (stricmp(token, STRCMD_CS_COMMAND_USERSEND) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERSEND_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{
			// ڿ, Ϲ ڴ 
			return FALSE;
		}

		// 2008-02-21 by dhjin, Ʒ  - Ʒ   Ұ
		if(g_pFieldGlobal->IsArenaServer())
		{
			return FALSE;
		}

		// format: "/ [character name] [map name]" - ش ĳ͸ õ  ̵Ŵ
		token = strtok(NULL, seps);		// character name
		if (NULL == token)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_USERSEND_HELP);
			return TRUE;
		}
		char *CharacName = token;

		char tmCharacterName[SIZE_MAX_CHARACTER_NAME];		
		CFieldIOCPSocket *pCharacSocket = ms_pFieldIOCP->m_mapCharacterName.findLock(GGetLowerCase(tmCharacterName, CharacName, SIZE_MAX_CHARACTER_NAME));

		if (pCharacSocket != NULL)
		{
			// 2009-09-09 ~ 2010-01-20 by dhjin, ǴƼ -    μ Ѵ.   üũ
			if(INFINITY_STATE_NONE != pCharacSocket->m_InfinityPlayingInfo.InfinityState ) {
				return FALSE;
			}

			token = strtok(NULL, seps);		// map name
			if (token != NULL)
			{
				CMapProject *pMapProject = ms_pFieldIOCP->GetMapWorkspace()->GetMapProjectByMapIndex(atoi(token));
				if (pMapProject != NULL)
				{
					//////////////////////////////////////////////////////////////////////////
					// 2007-05-22 by dhjin, Ʒ ʿ  Ʒ  ̸  Ż ó Ѵ.
					if(IS_MAP_INFLUENCE_ARENA(pCharacSocket->m_pCurrentFieldMapChannel->GetMapInfluenceTypeW())
						&& pCharacSocket->m_ArenaInfo.IsValidArenaState() )
					{
						if(pCharacSocket->m_ArenaInfo.WatchState)
						{// 2007-06-21 by dhjin, ̸   ʱȭѴ.
							pCharacSocket->WatchEnd();
						}
						else
						{
							ms_pFieldIOCP->m_ArenaManager.DeleteMember(pCharacSocket);			// 2007-04-23 by dhjin,  
							pCharacSocket->m_ArenaInfo.ResetArenaInfo();		
							pCharacSocket->SendAddMessageType(T_FC_ARENA_REAVE_TEAM_OK);			// 2007-05-03 by dhjin, Ʒ    
						}
					}

					EventResult_t ret = pCharacSocket->WarpToMap(atoi(token), 0);

					// event result  ۾
					if (ret == EVENT_RESULT_BREAK)
					{
#ifdef _DEBUG
						DBGOUT(STRERR_S_F2NOTIFY_0017,
							token, GetCharacterString(&pCharacSocket->m_character, string()));
#endif
						return FALSE;
					}
					else if (ret == EVENT_RESULT_CONTINUE)
					{
						return TRUE;
					}
				}
				return FALSE;
			}
			else
			{
				return FALSE;
			}
		}
		else
		{
			SendString128(STRING_128_ADMIN_CMD, "%s NOT PLAYING", CharacName);
			return FALSE;
		}
		return FALSE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_INFObyNAME) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_INFObyNAME_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// 2007-11-08 by cmkwon, GM ɾ  - '/' ڵ  , // 2006-10-23 by cmkwon, ڸ ϵ 
			// ڿ, Ϲ ڴ 
			return FALSE;
		}

		// format: "/ [monster name|item name]" - ̸ ش Ʈ ԵǴ ͳ   
		token = strtok(NULL, seps);
		if (NULL == token)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_INFObyNAME_HELP);
			return TRUE;			
		}
		char *pName = token;

		//   ˻
		ez_map<int, MONSTER_INFO>::iterator itrMon = ms_pFieldIOCP->m_mapMonsterInfo.begin();
		while(itrMon != ms_pFieldIOCP->m_mapMonsterInfo.end())
		{
			MONSTER_INFO *pMonsterInfo = &(itrMon->second);
			if (strstr(pMonsterInfo->MonsterName, pName) != NULL)
			{
				SendString128(STRING_128_ADMIN_CMD, "[Monster]%d:%s, Lv %d",
					pMonsterInfo->MonsterUnitKind, pMonsterInfo->MonsterName, (INT)pMonsterInfo->Level);
			}
			itrMon++;
		}

		//   ˻
		ez_map<int, ITEM*>::iterator itrItem = ms_pFieldIOCP->m_mapItemInfo.begin();
		while(itrItem != ms_pFieldIOCP->m_mapItemInfo.end())
		{
			ITEM *pItem = itrItem->second;
			if (strstr(pItem->ItemName, pName) != NULL)
			{
				SendString128(STRING_128_ADMIN_CMD, "[Item]%d:%s,Lv %d~%d, %s",
					pItem->ItemNum, pItem->ItemName, (INT)pItem->ReqMinLevel, (INT)pItem->ReqMaxLevel,
					CAtumSJ::GetItemKindName(pItem->Kind));
			}
			itrItem++;
		}
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_QUESTINFO) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_QUESTINFO_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2007-11-08 by cmkwon, GM ɾ  - '/Ʈ'   Ұ
			// ڿ, Ϲ ڴ 
			return FALSE;
		}
		
		token = strtok(NULL, seps);		// 2009-10-15 by cmkwon, ƮƮ ÿ Ʈ ˻  ߰ - 

		// format: "/Ʈ" - ĳ Ʈ  
		ms_pFieldIOCP->SendAllQuestList(this, m_character.InfluenceType, token);		// 2006-08-08 by cmkwon,  Ʈ Ʈ Ѵ.

		mt_auto_lock mqLock(&m_mapQuest);
		mtmapQuestIndex2FieldCharacterQuest::iterator itr_quest = m_mapQuest.begin();
		while(itr_quest != m_mapQuest.end())
		{
			CFieldCharacterQuest *tmFCharQuest = &itr_quest->second;
			CQuest *pQuestInfo = tmFCharQuest->GetQuestInfo();
			if(COMPARE_INFLUENCE(m_character.InfluenceType, pQuestInfo->ReqInfluenceType))
			{
				if(token
					&& NULL == strstr(pQuestInfo->QuestName, token))
				{// 2009-10-15 by cmkwon, ƮƮ ÿ Ʈ ˻  ߰ - 
					itr_quest++;
					continue;
				}
				SendString128 (STRING_128_ADMIN_CMD, "IDX(%d) QNAME(%s) STATE(%d)",
					tmFCharQuest->QuestIndex, pQuestInfo->QuestName, tmFCharQuest->QuestState);
			}

			itr_quest++;
		}

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_QUESTDEL) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_QUESTDEL_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/Ʈ [Ʈȣ]" - ĳ Ʈ 
		int nQuestIndex = 0;
		token = strtok(NULL, seps);
		if (NULL == token)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_QUESTDEL_HELP);
			return TRUE;
		}
			
		nQuestIndex = atoi(token);		

		mt_auto_lock mqLock(&m_mapQuest);
		mtmapQuestIndex2FieldCharacterQuest::iterator itr_quest = m_mapQuest.begin();
		while(itr_quest != m_mapQuest.end())
		{
			CFieldCharacterQuest *tmFCharQuest = &itr_quest->second;

			if (nQuestIndex != 0 && tmFCharQuest->QuestIndex != nQuestIndex)
			{
				itr_quest++;
				continue;
			}

			CQuest *pQuestInfo = tmFCharQuest->GetQuestInfo();
			if (pQuestInfo == NULL)
			{
				SendString128 (STRING_128_ADMIN_CMD, "IDX(%d) NAME(N/A) STATE(%d) - deleted",
					tmFCharQuest->QuestIndex, tmFCharQuest->QuestState);
			}
			else
			{
				SendString128 (STRING_128_ADMIN_CMD, "IDX(%d) QNAME(%s) STATE(%d) - deleted",
					tmFCharQuest->QuestIndex,
					pQuestInfo->QuestName, tmFCharQuest->QuestState);
			}

			INIT_MSG_WITH_BUFFER(MSG_FC_QUEST_DISCARD_QUEST_OK, T_FC_QUEST_DISCARD_QUEST_OK, pMsgDiscard, pMsgDiscardBuf);
			pMsgDiscard->QuestIndex = tmFCharQuest->QuestIndex;
			pMsgDiscard->IsDiscarded = TRUE;
			SendAddData(pMsgDiscardBuf, MSG_SIZE(MSG_FC_QUEST_DISCARD_QUEST_OK));

			// Ʈ  - DB
			QPARAM_DELETE_QUEST *pQDeleteQuest = new QPARAM_DELETE_QUEST;
			pQDeleteQuest->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
			pQDeleteQuest->QuestIndex = tmFCharQuest->QuestIndex;
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_DeleteQuest, this, m_character.AccountUniqueNumber, pQDeleteQuest);

			m_mapQuest.erase(itr_quest++);
		}

//		SendString128(STRING_128_ADMIN_CMD, "ĳ (â 缱)ϸ  Ʈ ϴ.");

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_ITEMINFObyKIND) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINFObyKIND_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{
			// ڿ, Ϲ ڴ 
			return FALSE;
		}

		// format: "/ [item kind(0~53)]" - ش   
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			//   ˻
			int nCnts = 0;
			ez_map<int, ITEM*>::iterator itrItem = ms_pFieldIOCP->m_mapItemInfo.begin();
			while(itrItem != ms_pFieldIOCP->m_mapItemInfo.end())
			{
				ITEM *pItem = itrItem->second;
				if (pItem->Kind == atoi(token))
				{
					SendString128(STRING_128_ADMIN_CMD, "[Item]%s(MinLv%d, MaxLv%d): %d, %s",
						pItem->ItemName, (INT)pItem->ReqMinLevel, (INT)pItem->ReqMaxLevel,
						pItem->ItemNum, CAtumSJ::GetItemKindName(pItem->Kind));
					nCnts++;
				}
				itrItem++;
			}

			// 2007-12-13 by cmkwon,  ߰
			if(0 >= nCnts)
			{
				SendString128(STRING_128_ADMIN_CMD, "Nothing item of ItemKind(%d) !!", atoi(token));
			}
		}
		else
		{
			for (int i = 0; i < ITEMKIND_FOR_MON_PRIMARY; i++)
			{
				if (stricmp(CAtumSJ::GetItemKindName(i), STRCMD_CS_ITEMKIND_UNKNOWN) != 0)
				{
					SendString128(STRING_128_ADMIN_CMD, "%3d -> %s", i, CAtumSJ::GetItemKindName(i));
				}
			}
		}
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyKIND) == 0
			|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyKIND_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/ [item kind(0~53)]" - ش   ߰
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_ITEMINSERTbyKIND_HELP);
			return TRUE;
		}
		//   ˻
		ez_map<int, ITEM*>::iterator itrItem = ms_pFieldIOCP->m_mapItemInfo.begin();
		while(itrItem != ms_pFieldIOCP->m_mapItemInfo.end())
		{
			ITEM *pItem = itrItem->second;
			if (IS_GENERAL_ITEM(pItem->Kind)
				&& (m_character.UnitKind&pItem->ReqUnitKind) != 0
				&& pItem->Kind == atoi(token))
			{
				m_ItemManager.InsertItemBaseByItemNum(pItem->ItemNum, 1, IUT_ADMIN);
			}

			itrItem++;
		}
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUMRANGE) == 0
			|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUMRANGE_1))
	{
		return FALSE;		// 2006-04-13 by cmkwon,  Ұ ɾ

		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/ [from itemnum] ~ [to itemnum]" - ش   ߰
		int nFromItemNum = 0;
		int nToItemNum = 0;

		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUMRANGE_HELP);
			return TRUE;
		}
		nFromItemNum = atoi(token);
		if (nFromItemNum == 0){					return FALSE;}
		
		token = strtok(NULL, seps);
		if (token == NULL){						return FALSE;}
		if (strncmp(token, "~", 1) != 0){		return FALSE;}
		
		token = strtok(NULL, seps);
		if (token == NULL){						return FALSE;}
		
		nToItemNum = atoi(token);
		if (nToItemNum == 0){					return FALSE;}

		//  
		if (nFromItemNum != 0 && nToItemNum != 0)
		{
			//   ˻
			ez_map<int, ITEM*>::iterator itrItem = ms_pFieldIOCP->m_mapItemInfo.begin();
			while(itrItem != ms_pFieldIOCP->m_mapItemInfo.end())
			{
				ITEM *pItem = itrItem->second;
				if (IS_GENERAL_ITEM(pItem->Kind)
					&& (m_character.UnitKind&pItem->ReqUnitKind) != 0
					&& IS_IN_RANGE(nFromItemNum, pItem->ItemNum, nToItemNum))
				{
					m_ItemManager.InsertItemBaseByItemNum(pItem->ItemNum, 1, IUT_ADMIN);
				}

				itrItem++;
			}
		}

		return TRUE;
	}
	else if (stricmp(token, STRCMD_CS_COMMAND_STATINIT) == 0
			|| 0 == stricmp(token, STRCMD_CS_COMMAND_STATINIT_1)
			|| 0 == stricmp(token, STRCMD_CS_COMMAND_STATINIT_2))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		CFieldIOCPSocket *pSocket = NULL;
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			pSocket = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if (pSocket == NULL
				|| FALSE == pSocket->IsUsing())
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0087, token);
				return FALSE;
			}
		}
		else
		{
			pSocket = this;
		}

		if (pSocket == NULL)
		{
			return FALSE;
		}

		// format: "/ʱȭ" -  ʱȭ 
		if (ERR_NO_ERROR != pSocket->ResetStat(STAT_ALL_PART))
		{
			// 2009-02-04 by cmkwon, ߰
			SendString128(STRING_128_ADMIN_CMD, "%s's Stat initialing failed !!", pSocket->GetCharacter()->CharacterName);
			return FALSE;
		}
		
		return TRUE;
	}
	else if (stricmp(token, STRCMD_CS_COMMAND_PARTYINFO) == 0
			|| 0 == stricmp(token, STRCMD_CS_COMMAND_PARTYINFO_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/Ƽ" - Ƽ  
		CFieldParty *pMeFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
		if (pMeFParty != NULL)
		{
			pMeFParty->Print(this);
			return TRUE;
		}
		else
		{
			SendString128(STRING_128_DEBUG_L3, STRMSG_S_F2NOTIFY_0088);
			return TRUE;
		}
	}
	else if (stricmp(token, STRCMD_CS_COMMAND_GAMETIME) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMETIME_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2007-11-08 by cmkwon, GM ɾ  - '/ð'   Ұ, // 2006-04-13 by cmkwon, /ڸ  
			return FALSE;
		}

		// format: "/ð [ ð(0~23)]" -  ð (ڱ ڽ ð ٲ)
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			int timeToAdd = atoi(token);
			if (timeToAdd < 0 || timeToAdd > 24)
			{
				return FALSE;
			}

			// ð 
			time_t ltime;
			struct tm *today = NULL;
			time(&ltime);
			today = localtime(&ltime);
			INIT_MSG_WITH_BUFFER(MSG_FC_CONNECT_SYNC_TIME, T_FC_CONNECT_SYNC_TIME, pSyncTime, pSyncTimeBuf);
			// 4ð   
			AtumTime aTime(0, 10*timeToAdd);
			AtumTime rTime(today->tm_hour, today->tm_min);

			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0089,
				rTime.Hour, rTime.Minute, (rTime*6).Hour%24, (rTime*6).Minute);

			rTime += aTime;

			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0090
				, rTime.Hour, rTime.Minute, (rTime*6).Hour%24, (rTime*6).Minute);

			pSyncTime->CurrentTime
				= (rTime.Hour%4)*3600 + rTime.Minute*60;

			SendAddData(pSyncTimeBuf, MSG_SIZE(MSG_FC_CONNECT_SYNC_TIME));
			SendString128(STRING_128_ADMIN_CMD, "synctime: %d", pSyncTime->CurrentTime);
		}
		else
		{
			// ð 
			time_t ltime;
			struct tm *today = NULL;
			time(&ltime);
			today = localtime(&ltime);
			// 4ð   
			AtumTime rTime(today->tm_hour, today->tm_min);

			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0089
				, rTime.Hour, rTime.Minute, (rTime*6).Hour%24, (rTime*6).Minute);

			return FALSE;
		}

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_STRINGLEVEL_0) == 0
		||  stricmp(token, STRCMD_CS_COMMAND_STRINGLEVEL_1) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_STRINGLEVEL_2))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/Ʈ [0~5]" -  ޼ ϴ level 
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_STRINGLEVEL_HELP);
			return TRUE;
		}
		int level = atoi(token);
		if (level >= STRING_128_DEBUG_L1 && level <= STRING_128_USER_NOTICE)
		{
			m_STRING_128_print_level = level;
		}
		else
		{
			return FALSE;
		}
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_MONSUMMON) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_MONSUMMON_1))
	{
		// 2009-02-04 by cmkwon, "/Summon" ɾ GameMaster ϰ  - Ʒ  
		//if ( !CheckCommandExecutability(RACE_OPERATION) )
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// 2008-08-18 by dhjin, ڸ 밡  // 2007-11-08 by cmkwon, GM ɾ  - '/ȯ' ڵ  , // 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2010-04-19 by cmkwon, Gameforge4D GM ȯ ɾ  Ұ(E0044590) - 
#if defined(_DEFINED_GAMEFORGE4D_)
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2010-04-19 by cmkwon, Gameforge4D GM ȯ ɾ  Ұ(E0044590) - 
			return FALSE;
		}
#endif // END - #if defined(_DEFINED_GAMEFORGE4D_)

		//////////////////////////////////////////////////////////////////////////
		// 2007-06-22 by dhjin, Ʒ ʿ  Ұ
		if(IS_MAP_INFLUENCE_ARENA(this->m_pCurrentFieldMapChannel->GetMapInfluenceTypeW()))
		{
			return FALSE;
		}

		// format: "/ȯ [monster number|monster name] [# of monsters]" - ͸ ȯ( ̸  ִ   '_' ϸ )
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_MONSUMMON_HELP);
			return TRUE;			
		}
		INIT_MSG_WITH_BUFFER(MSG_FN_ADMIN_SUMMON_MONSTER, T_FN_ADMIN_SUMMON_MONSTER, pMsgSummonMonster, pMsgSummonMonsterBuf);
		pMsgSummonMonster->ChannelIndex		= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
		STRNCPY_MEMSET(pMsgSummonMonster->CharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
		pMsgSummonMonster->MonsterUnitKind	= atoi(token);
		pMsgSummonMonster->MonsterTargetType1	= MONSTER_TARGETTYPE_NORMAL;
		pMsgSummonMonster->TargetTypeData1		= 0;
		pMsgSummonMonster->CltIdxForTargetType1	= 0;
		if (0 == pMsgSummonMonster->MonsterUnitKind
			|| NULL == ms_pFieldIOCP->GetMonsterInfo(pMsgSummonMonster->MonsterUnitKind))
		{
			pMsgSummonMonster->MonsterUnitKind = 0;
			Underbar2Space(token);	// '_' space 

			MONSTER_INFO *pMonInfo = ms_pFieldIOCP->GetMonsterInfo(token);
			if(NULL == pMonInfo)
			{
				return FALSE;
			}

			pMsgSummonMonster->MonsterUnitKind = pMonInfo->MonsterUnitKind;			
		}

		// 2010. 07. 05 by hsLee.  ȯ . (뷱   .)
		pMsgSummonMonster->MonsterBalanceData.Init(0);


		token = strtok(NULL, seps);
		if (pMsgSummonMonster->MonsterUnitKind != 0 && token != NULL)
		{
			pMsgSummonMonster->NumOfMonster = atoi(token);
			pMsgSummonMonster->Position = m_character.PositionVector;

			if (m_pCurrentFieldMapChannel->m_pFieldMapProject->GetNPCServerStartFlag() == FALSE)
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0091);
				return FALSE;
			}

			m_pCurrentFieldMapChannel->Send2NPCServerW(pMsgSummonMonsterBuf, MSG_SIZE(MSG_FN_ADMIN_SUMMON_MONSTER));
			return TRUE;
		}

		return FALSE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_SKILLALL) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_SKILLALL_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/罺ų [level]" - شǴ  ų 
		int nSkillLevel = 1;
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			nSkillLevel = atoi(token);
		}
		nSkillLevel = max(1, nSkillLevel);

		mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);			// lock m_mapItemGeneral, "/罺ų"

		ez_map<int, ITEM*>::iterator itrSkill = ms_pFieldIOCP->m_mapItemInfo.begin();
		while (itrSkill != ms_pFieldIOCP->m_mapItemInfo.end())
		{
			ITEM *pItemSkill = itrSkill->second;
			if (IS_SKILL_ITEM(pItemSkill->Kind)
				&& FALSE == COMPARE_BIT_FLAG(pItemSkill->ItemAttribute, SKILL_ATTR_PARTY_FORMATION_SKILL)		// 2009-08-03 by cmkwon, EP3-4   ų  -   ų 
				&& (m_character.UnitKind&pItemSkill->ReqUnitKind) != 0
				&& pItemSkill->SkillLevel == nSkillLevel)
			{
				m_ItemManager.InsertItemBaseByItemNum(pItemSkill->ItemNum, 1, IUT_ADMIN);
			}

			itrSkill++;
		}

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTALL) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTALL_1))
	{
		return FALSE;		// 2006-04-13 by cmkwon, Ұ ɾ

		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/" - شǴ   , ų  Countable 

		// lock , "/"
		mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);

		ez_map<int, ITEM*>::iterator itrItemInfo = ms_pFieldIOCP->m_mapItemInfo.begin();
		while (itrItemInfo != ms_pFieldIOCP->m_mapItemInfo.end())
		{
			ITEM *pItem = itrItemInfo->second;
			if (IS_GENERAL_ITEM(pItem->Kind)
				&& (m_character.UnitKind&pItem->ReqUnitKind) != 0
				&& !IS_COUNTABLE_ITEM(pItem->Kind)
			)
			{
				m_ItemManager.InsertItemBaseByItemNum(pItem->ItemNum, 1, IUT_ADMIN);
			}

			itrItemInfo++;
		}
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTWEAPON) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTWEAPON_1))
	{
		return FALSE;		// 2006-04-13 by cmkwon,  Ұ ɾ

		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/繫" - شǴ   

		// lock , "/繫"
		mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);

		ez_map<int, ITEM*>::iterator itrItemInfo = ms_pFieldIOCP->m_mapItemInfo.begin();
		while (itrItemInfo != ms_pFieldIOCP->m_mapItemInfo.end())
		{
			ITEM *pItem = itrItemInfo->second;
			if (IS_WEAPON(pItem->Kind)
				&& (m_character.UnitKind&pItem->ReqUnitKind) != 0
				&& !IS_COUNTABLE_ITEM(pItem->Kind)
			)
			{
				m_ItemManager.InsertItemBaseByItemNum(pItem->ItemNum, 1, IUT_ADMIN);
			}

			itrItemInfo++;
		}

		return TRUE;
	}
	else if (stricmp(token, STRCMD_CS_COMMAND_ITEMDELALL_0) == 0
			|| stricmp(token, STRCMD_CS_COMMAND_ITEMDELALL_1) == 0
			|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMDELALL_2))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/۹" - شǴ    (ų )
		BOOL bDeleted = m_ItemManager.DeleteAllItemGeneralFromCharacter();

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUM) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUM_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/ [item number] [# of items]" -  , [# of items]  1 ޵
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_ITEMINSERTbyITEMNUM_HELP);
			return TRUE;
		}
		ITEM *pItem = ms_pFieldIOCP->GetItemInfo(atoi(token));
		if (pItem == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0092, atoi(token));
			return FALSE;
		}

		// start 2011-09-30 by hskim, Ʈ ý 2
		if( ITEMKIND_PET_ITEM == pItem->Kind && g_pFieldGlobal->IsArenaServer() )
		{
			// Ʈ Ʒ  
			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0150);

			return FALSE;
		}
		// end 2011-09-30 by hskim, Ʈ ý 2

		int count = 1;
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			count = atoi(token);
			if (!IS_COUNTABLE_ITEM(pItem->Kind) && count >= 10)
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0093);
				count = 10;
			}
		}
		else
		{
			count = 1;
		}

		// InsertItemBaseByItemNum ο lock ó
		if (!m_ItemManager.InsertItemBaseByItemNum(pItem->ItemNum, count, IUT_ADMIN))
		{
			return FALSE;
		}
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_ITEMDROP) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMDROP_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/ [item number] [|# of items]" -  , [# of items]  1 ޵
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_ITEMDROP_HELP);
			return TRUE;
		}
		int nItemNum = atoi(token);
		int count = 1;
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			count = atoi(token);
		}
		else
		{
			count = 1;
		}

		return ms_pFieldIOCP->m_DropItemManager.DropItemInRandomRadius(m_pCurrentFieldMapChannel, &m_character.PositionVector, DROP_ITEM_RADIUS, nItemNum, count, TRUE);		// 2013-04-10 by hskim,  ɿ     ð 2 
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_USERSINFOTOTAL) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERSINFOTOTAL_1))
	{
		// format: "/" -   
		if (!CheckCommandExecutability(RACE_OPERATION|RACE_MONITOR, TRUE))
		{// 2007-11-08 by cmkwon, GM ɾ  - '/'  Ұ, // 2006-04-13 by cmkwon, //SCMonitor/SCAdminTool  
			return FALSE;
		}

		SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0094,
			GET_MAP_STRING(m_character.MapChannelIndex),
			m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.size());

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_USERSINFOperMAP) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERSINFOperMAP_1))
	{
		// format: "/" -    
		if (!CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2006-04-13 by cmkwon, /ڸ  
			return FALSE;
		}

		int			nClientCount;
		CFieldMapChannel *pFMapChann = NULL;
		CFieldMapWorkspace *pFieldMapWorkspace = ms_pFieldIOCP->GetMapWorkspace();

		for (int i = 0; i < pFieldMapWorkspace->m_vectorPtrMapProject.size(); i++)
		{
			int nChannCounts = pFieldMapWorkspace->m_vectorPtrMapProject[i]->GetNumberOfMapChannels();
			for(int k = 0; k < nChannCounts; k++)
			{
				pFMapChann = (CFieldMapChannel*)pFieldMapWorkspace->m_vectorPtrMapProject[i]->GetMapChannelByIndex(k);
				if (NULL == pFMapChann)
				{
					continue;
				}

				nClientCount = pFMapChann->GetNumClients();
				pFMapChann->UpdateMaxUserCounts(nClientCount);

				if (pFMapChann->m_MapChannelIndex == m_character.MapChannelIndex)
				{
					SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0095,
						GET_MAP_STRING(pFMapChann->m_MapChannelIndex),
						(pFMapChann->IsEnabled()?"O":"X"),
						nClientCount,
						CAtumSJ::GetMapName(pFMapChann->m_MapChannelIndex.MapIndex));
				}
				else
				{
					SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0096,
						GET_MAP_STRING(pFMapChann->m_MapChannelIndex),
						(pFMapChann->IsEnabled()?"O":"X"),
						nClientCount,
						CAtumSJ::GetMapName(pFMapChann->m_MapChannelIndex.MapIndex));
				}
			}
		}

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_CHANNELINFO) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_CHANNELINFO_1))
	{
		// format: "/ä" -  ä  
		if (!CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2006-04-13 by cmkwon, /ڸ  
			return FALSE;
		}

		SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0097,
			CAtumSJ::GetMapName(m_character.MapChannelIndex.MapIndex),
			m_character.MapChannelIndex.MapIndex,
			m_character.MapChannelIndex.ChannelIndex);

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTDBG) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTDBG_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// 2008-02-14 by cmkwon, ش ĳ  PRINT_DEBUG_MESSAGE()  ȣѴ.
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			CFieldIOCPSocket *pFISoc = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if (NULL == pFISoc
				|| FALSE == pFISoc->IsValidCharacter(FALSE))
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0102, token);
				return FALSE;
			}

// 2008-03-19 by cmkwon,  ʿ 
// 			char *dpm = NULL;
// 			pFISoc->PRINT_DEBUG_MESSAGE(dpm);
		
			// 2008-03-19 by cmkwon, Ը  Ŭ̾Ʈ (lack)   - ӽÿ, ش  WirteBuf Ϸ Ѵ.  ذǸ ʿ 
			pFISoc->SaveDataOfWriteBufList();
		}

		return TRUE;
	}
	else if ( strcmp(token, STRCMD_CS_COMMAND_DEBUGSETPARAMF) == 0)
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/testf [Param1] [Param2] [Param3]" -  ׽Ʈ
		int nParam1 = 0, nParam2 = 0, nParam3 = 0;
		const char *szParam1 = NULL, *szParam2 = NULL, *szParam3 = NULL;

		// Param 1
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_DEBUGSETPARAMF_HELP);
			return TRUE;
		}
		nParam1 = atoi(token);
		szParam1 = token;

		// Param 2
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_DEBUGSETPARAMF_HELP);
			return TRUE;
		}
		nParam2 = atoi(token);
		szParam2 = token;

		// Param 3
		token = strtok(NULL, seps);
		if (token == NULL)		// 2009-03-09 by cmkwon, Ϻ Arario nProtect CS ϱ -   
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_DEBUGSETPARAMF_HELP);
			return TRUE;
		}
		nParam3 = atoi(token);
		szParam3 = token;
		StartTestDBG(nParam1, nParam2, nParam3, szParam1, szParam2, szParam3);
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_BULLETCHARGE) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_BULLETCHARGE_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		
		mt_auto_lock mtig(&m_ItemManager.m_mapItemGeneral);		// 2007-10-15 by cmkwon, ʿ

		ITEM_GENERAL *pPriItem = (ITEM_GENERAL*)m_ItemProwOut.ItemNum;
		ITEM_GENERAL *pSecItem = (ITEM_GENERAL*)m_ItemWingOut.ItemNum;

		// format: "/Ѿ [1 Ѿ ] [2 Ѿ ]"
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			if (m_ItemProwOut.ItemNum != 0)
			{
				RechargeBullet(pPriItem, FALSE, BULLET_RECHARGE_TYPE_ADMIN_COMMAND);	// 2007-08-07 by cmkwon, 1/2  Ѿ    -
			}

			if (m_ItemWingOut.ItemNum != 0)
			{
				RechargeBullet(pSecItem, FALSE, BULLET_RECHARGE_TYPE_ADMIN_COMMAND);	// 2007-08-07 by cmkwon, 1/2  Ѿ    -
			}
		}
		else
		{
			/////////////////////////////////////
			// 1  ó
			/////////////////////////////////////
			int nTargetCount = atoi(token);

			// 濡  ź  ã
			multimap<BYTE, ITEM*>::iterator itrBullet = ms_pFieldIOCP->m_multiMapCaliber2Bullet.find((m_ItemProwOut.ItemNum==0?0:m_ItemProwOut.Caliber));
			if (itrBullet == ms_pFieldIOCP->m_multiMapCaliber2Bullet.end() || !IS_PRIMARY_WEAPON_1(m_ItemProwOut.Kind))
			{
				SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0098);
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0099, m_ItemProwOut.ItemName, m_ItemProwOut.Caliber);
			}
			else
			{
				if (nTargetCount < 0)
				{
					return FALSE;
				}

				nTargetCount = min(nTargetCount, pPriItem->GetMaxBulletCount(m_ItemManager.IsExistPremiumCard()));
				// 2007-10-15 by cmkwon,   źâ ι Ŀ -   
				//if (nTargetCount >= m_ItemProwOut.Charging)
				//{
				//	nTargetCount = m_ItemProwOut.Charging;
				//}

				int nRechargeCount = nTargetCount - pPriItem->CurrentCount;
				m_ItemManager.UpdateItemCountByPointer(pPriItem, nRechargeCount, IUT_BULLET, ITEM_IN_CHARACTER, TRUE, FALSE);

				INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_PRI_BULLET_RELOADED, T_FC_BATTLE_PRI_BULLET_RELOADED, pPriBulletReloded, pPriBulletRelodedBuf);
				pPriBulletReloded->BulletCount = pPriItem->CurrentCount;
				SendAddData(pPriBulletRelodedBuf, MSG_SIZE(MSG_FC_BATTLE_PRI_BULLET_RELOADED));
// check: ׳  ϱ, 20041030, kelovon with ClientTeam
//				m_PrimaryShotNumCount = CAtumSJ::GetTotalPrimaryShotCountPerReattackTime(&m_ItemProwOut, &m_ParamFactor);
			}

			/////////////////////////////////////
			// 2  ó
			/////////////////////////////////////
			token = strtok(NULL, seps);
			if (token != NULL)
			{
				nTargetCount = atoi(token);

				multimap<BYTE, ITEM*>::iterator itrBullet = ms_pFieldIOCP->m_multiMapCaliber2Bullet.find((m_ItemWingOut.ItemNum==0?0:m_ItemWingOut.Caliber));
				if (itrBullet == ms_pFieldIOCP->m_multiMapCaliber2Bullet.end() || m_ItemWingOut.Kind == ITEMKIND_SHIELD)
				{
					SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0100);
					SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0101, m_ItemWingOut.ItemName, m_ItemWingOut.Caliber);
				}
				else
				{
					if (nTargetCount < 0)
					{
						return TRUE;
					}

					nTargetCount = min(nTargetCount, pSecItem->GetMaxBulletCount(m_ItemManager.IsExistPremiumCard()));
					// 2007-10-15 by cmkwon,   źâ ι Ŀ -   
					//if (nTargetCount >= m_ItemWingOut.Charging)
					//{
					//	nTargetCount = m_ItemWingOut.Charging;
					//}

					int nRechargeCount = nTargetCount - pSecItem->CurrentCount;
					m_ItemManager.UpdateItemCountByPointer(pSecItem, nRechargeCount, IUT_BULLET, ITEM_IN_CHARACTER, TRUE, FALSE);

					INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_SEC_BULLET_RELOADED, T_FC_BATTLE_SEC_BULLET_RELOADED, pSecBulletReloded, pSecBulletRelodedBuf);
					pSecBulletReloded->BulletCount = pSecItem->CurrentCount;
					SendAddData(pSecBulletRelodedBuf, MSG_SIZE(MSG_FC_BATTLE_SEC_BULLET_RELOADED));
// check: ׳  ϱ ϸ鼭  , 20041030, kelovon with ClientTeam
//					m_SecondaryShotNumCount = CAtumSJ::GetTotalSecondaryShotCountPerReattackTime(&m_ItemWingOut, &m_ParamFactor);
				}
			}
		}

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_REPAIRALL) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_REPAIRALL_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/ [character name]" - HP, UTC, FUEL 100% ä, [character name]  ڱ ڽ
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			CFieldIOCPSocket *pSocket = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if (pSocket == NULL
				|| FALSE == pSocket->IsUsing())
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0102, token);
				return FALSE;
			}
			if(FALSE == pSocket->IsValidCharacter())
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0103, token);
				return FALSE;
			}

			pSocket->m_character.CurrentHP = pSocket->m_character.HP;
			pSocket->m_character.CurrentDP = pSocket->m_character.DP;
			pSocket->m_character.CurrentSP = pSocket->m_character.SP;
			pSocket->m_character.CurrentEP = pSocket->m_character.EP;
			pSocket->SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP);
		}
		else
		{
			if(FALSE == this->IsValidCharacter())
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0103, m_character.CharacterName);
				return FALSE;
			}

			// ڱ ڽ
			this->m_character.CurrentHP = this->m_character.HP;
			this->m_character.CurrentDP = this->m_character.DP;
			this->m_character.CurrentSP = this->m_character.SP;
			this->m_character.CurrentEP = this->m_character.EP;
			this->SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP);
		}

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_REPAIRbyPARAM) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_REPAIRbyPARAM_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/ [ %] [character name]" - HP, UTC, FUEL [ %] , [ %]  50%, [character name]  ڱ ڽ
		float ratioOfP = 0.5f;
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			int percentage = atoi(token);

			//  Ȯ   
			if (percentage <= 0) percentage = 50;
			else if (percentage >= 100) percentage = 100;

			ratioOfP = ((float)percentage)/100.0f;
		}
		else
		{
			ratioOfP = 0.5f;
		}

		CFieldIOCPSocket *pSocket = this;
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			pSocket = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if (pSocket == NULL
				|| FALSE == pSocket->IsUsing())
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0104, token);
				return FALSE;
			}
		}
		else
		{
			pSocket = this;
		}

//#ifdef _DEBUG
		if (pSocket == NULL
			|| FALSE == pSocket->IsUsing())
		{
			return FALSE;
		}
		if(FALSE == pSocket->IsValidCharacter())
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0103, pSocket->GetCharacter()->CharacterName);
			return FALSE;
		}
//#endif

		pSocket->m_character.CurrentHP = pSocket->m_character.HP*ratioOfP;
		pSocket->m_character.CurrentDP = pSocket->m_character.DP*ratioOfP;
		pSocket->m_character.CurrentSP = pSocket->m_character.SP*ratioOfP;
		pSocket->m_character.CurrentEP = pSocket->m_character.EP*ratioOfP;
		pSocket->SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP);

		pSocket->m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_HP);
		pSocket->m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_DP);
		pSocket->m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_SP);

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_USERNORMALIZE) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERNORMALIZE_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/Ϲ" - ڳ    , Ϲ  ٲ

		// 
		m_backupRace = m_character.Race;

		// 
		m_character.Race &= (~(RACE_OPERATION|RACE_GAMEMASTER|RACE_DEMO));

		SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0105);

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_USERSPECIALIZE) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERSPECIALIZE_1))
	{
		if ( !COMPARE_RACE(m_backupRace, RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/Ư" - ڳ    , Ϲ  ٽ Ư  ٲ

		// 
		m_character.Race = m_backupRace;

		// ʱȭ
		m_backupRace = 0;

		SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0106);

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_USERINVINCIBILITY) == 0
			|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERINVINCIBILITY_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// 2006-04-13 by cmkwon, //DEMO  
			return FALSE;
		}

//		return FALSE;		// ׽Ʈ 

		// format: "/" - ڳ    ,   

		if (!m_bNoDamage)
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0107);
			m_bNoDamage = TRUE;
		}
		else
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0108);
			m_bNoDamage = FALSE;
		}

		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_POWERUP) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_POWERUP_1))
	{
		// 2012-09-11 by jhseol,   GM   "/" ɾ Ȱȭ
#ifdef _DEFINED_GAMEFORGE4D_
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}
#else
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}
#endif
		// end 2012-09-11 by jhseol,   GM   "/" ɾ Ȱȭ

//		return FALSE;		// ׽Ʈ 

		// format: "/ [ݷ (%)]" - ⿡ Ͻ ⼺  Ѵ

		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_POWERUP_HELP);
			return TRUE;
		}
		float fTemp = min(atof(token), 100000000.0f);
		fTemp = fTemp / 100.0f;
		SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0109, fTemp*100.0f);
		SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0111);
		m_ParamFactor.pfm_MINATTACK_01 += fTemp;
		m_ParamFactor.pfm_MAXATTACK_01 += fTemp;
		m_ParamFactor.pfm_MINATTACK_02 += fTemp;
		m_ParamFactor.pfm_MAXATTACK_02 += fTemp;
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_VARIABLESET) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_VARIABLESET_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/ []" - (Ϲ) 
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			int nVariable = atoi(token);

			///////////////////////////////////////////////////////////////////
			//   Ͻÿ
			///////////////////////////////////////////////////////////////////
			g_pFieldGlobal->m_bEventActivated = (nVariable==0?FALSE:TRUE);
			///////////////////////////////////////////////////////////////////
			//   Ͻÿ
			///////////////////////////////////////////////////////////////////

			return TRUE;
		}
		else
		{
			return FALSE;
		}

		return FALSE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_LEVELSET) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_LEVELSET_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/ [level] [percentage of exp] [character name]" -  
		token = strtok(NULL, seps);
		if (NULL == token)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_LEVELSET_HELP);			
			return TRUE;
		}

		int nLevel = atoi(token);

		if (nLevel > CHARACTER_MAX_LEVEL || nLevel <= 0)
		{
			return FALSE;
		}

		// percentage of exp
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			//  ̻ ĶͰ , ڱ ڽſ  ġ 0%
			this->ChangeLevel(nLevel-m_character.Level);
			return TRUE;
		}

		int percentageOfExp = atoi(token);
		// character name
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			// ڱ ڽ
			this->ChangeLevel(nLevel-m_character.Level, percentageOfExp);
			return TRUE;
		}
		else
		{
			CFieldIOCPSocket *pSocket = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if (pSocket == NULL
				|| FALSE == pSocket->IsUsing())
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0112, token);
				return FALSE;
			}

			pSocket->ChangeLevel(nLevel-pSocket->m_character.Level, percentageOfExp);
			return TRUE;
		}

		return TRUE;
	}
	/////////////////////////////////////////////////
	// start 2011-09-05 by hskim, Ʈ ý 2	
	else if ( stricmp(token, STRCMD_CS_COMMAND_PARTNERLEVELSET) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_PARTNERLEVELSET_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/Ʈʷ [level] [percentage of exp] [partner UID]" -  
		token = strtok(NULL, seps);
		if (NULL == token)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_PARTNERLEVELSET_HELP);
			return TRUE;
		}

		int nLevel = atoi(token);

		if (nLevel > PET_LEVEL_MAX || nLevel <= 0)
		{
			return FALSE;
		}

		token = strtok(NULL, seps);
		if (token == NULL)
		{
			this->PetChangeLevel(nLevel);

			return TRUE;
		}

		int percentageOfExp = atoi(token);
		token = strtok(NULL, seps);
		this->PetChangeLevel(nLevel, percentageOfExp);

		return TRUE;
	}
	// end 2011-09-05 by hskim, Ʈ ý 2
	/////////////////////////////////////////////////
	else if ( stricmp(token, STRCMD_CS_COMMAND_USERINVISIABLE) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_USERINVISIABLE_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// 2006-04-13 by cmkwon, /ڸ  
			return FALSE;
		}

		// format: "/" - ڽ ٸ ĳͿ  ʴ´

// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//		if (COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
//		{
//			ClearBodyConditionBit(m_character.BodyCondition, BODYCON_STEALTH_MASK);
//			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0113);
//		}
//		else
//		{
//			SetBodyConditionBit(m_character.BodyCondition, BODYCON_STEALTH_MASK);
//			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0114);
//		}
		if(FALSE == this->IsInvisibleCharacter())
		{
			m_bIsInvisibleCharacter				= TRUE;
			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0114);
		}
		else
		{
			m_bIsInvisibleCharacter				= FALSE;
			SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0113);
		}
		return TRUE;
	}
	else if ( stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTMSGF_0) == 0 
		|| stricmp(token, STRCMD_CS_COMMAND_DEBUGPRINTMSGF_1) == 0 )
	{
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: "/messagef" - Ŭ̾Ʈ ʵ  ְ ޴   

		if (m_bSendMessgeTypeDBG)
		{
			m_bSendMessgeTypeDBG = FALSE;
		}
		else
		{
			m_bSendMessgeTypeDBG = TRUE;
		}
		return TRUE;
	}
	else if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_1))
	{
		// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  - ӽ÷  ȵǴ ɾ
		return FALSE;

// 2008-05-20 by cmkwon,  ̺Ʈ(HappyHoure,MotherShip,Item) ׷ ÿ ϰ -  ʴ κ
// 		if ( !CheckCommandExecutability(RACE_OPERATION) )
// 		{// 2006-04-13 by cmkwon, ڸ  
// 			return FALSE;
// 		}
// 
// 		// format: "/̺Ʈ [ġ||ġ|||Ʈ] [ %f] [ð()]		- [ġ||۵|۵|Ʈ] ̺Ʈ 
// 		// format: "/̺Ʈ [ġ||ġ|||Ʈ] 						- [ġ||ġ|||Ʈ] ̺Ʈ 
// 		// format: "/̺Ʈ [ġ||ġ|||Ʈ]							- [ġ||ġ|||Ʈ] ̺Ʈ  
// 		token = strtok(NULL, seps);
// 		if (token == NULL)
// 		{//  ڰ 
// 			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_GAMEEVENT_HELP);			
// 			return TRUE;
// 		}
// 
// 		if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1EXP) == 0
// 			|| stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1SPI) == 0
// 			|| stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1EXPR) == 0
// 			|| stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1ITEM) == 0
// 			|| stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1RARE) == 0
// 			|| stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1WARPOINT) == 0)			// 2007-06-27 by dhjin, WarPoint ̺Ʈ ߰
// 		{
// 			EN_GAME_EVENT_TYPE enGEventType;
// 			if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1EXP) == 0)			enGEventType = GAME_EVENT_TYPE_EXP;
// 			else if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1SPI) == 0)		enGEventType = GAME_EVENT_TYPE_SPI;
// 			else if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1EXPR) == 0)	enGEventType = GAME_EVENT_TYPE_EXP_NO_DOWN;
// 			else if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1ITEM) == 0)	enGEventType = GAME_EVENT_TYPE_DROP_ITEM;
// 			else if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1RARE) == 0)	enGEventType = GAME_EVENT_TYPE_DROP_REAR_ITEM;
// 			else if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P1WARPOINT) == 0)	enGEventType = GAME_EVENT_TYPE_WARPOINT;		// 2007-06-27 by dhjin, WarPoint ̺Ʈ ߰
// 	
// 			token = strtok(NULL, seps);
// 			if(NULL == token)
// 			{//  ڰ  - ġ ̺Ʈ  Ѵ
// 
// 				char szTemp[1024];
// 				if(FALSE == ms_pFieldIOCP->m_gameEventManager.GetGameEventInfoString(szTemp, NULL, enGEventType, TRUE))
// 				{
// 					return FALSE;
// 				}
// 				
// 				this->SendString128(STRING_128_USER_NOTICE, szTemp);
// 				return TRUE;
// 			}
// 			else if(stricmp(token, STRCMD_CS_COMMAND_GAMEEVENT_P2END) == 0)
// 			{
// 				char szTemp[1024];
// 				BYTE byInflMask	 = INFLUENCE_TYPE_ALL_MASK;
// 				token = strtok(NULL, seps);
// 				if(token)
// 				{
// 					byInflMask = (BYTE)atoi(token);
// 					switch(byInflMask)
// 					{
// 					case INFLUENCE_TYPE_NORMAL:
// 					case INFLUENCE_TYPE_VCN:
// 					case INFLUENCE_TYPE_ANI:
// 					case INFLUENCE_TYPE_ALL_MASK:
// 						break;
// 					default:
// 						{
// 							return FALSE;
// 						}
// 					}
// 				}
// 
// 				if(FALSE == ms_pFieldIOCP->m_gameEventManager.EndGameEvent(enGEventType, TRUE, byInflMask))
// 				{
// 					sprintf(szTemp, STRMSG_S_F2NOTIFY_0115
// 						, CGameEventManager::GetGameEventTypeString(enGEventType));
// 					this->SendString128(STRING_128_USER_NOTICE, szTemp);					
// 				}
// 				else
// 				{
// 					BYTE byInflMask = INFLUENCE_TYPE_UNKNOWN;
// 					if(ms_pFieldIOCP->m_gameEventManager.GetGameEventInfoString(szTemp, &byInflMask, enGEventType, TRUE))
// 					{
// 						ms_pFieldIOCP->SendString128ToAllClients(STRING_128_USER_NOTICE, szTemp, TRUE, byInflMask);
// 					}
// 				}
// 
// 				return TRUE;
// 			}
// 
// 			float fExpRate = atof(token);
// 			if(fExpRate <= 0.0f)
// 			{// ġ 
// 
// 				return FALSE;
// 			}
// 
// 			token = strtok(NULL, seps);
// 			if(NULL == token)
// 			{// ð  
// 
// 				return FALSE;
// 			}
// 
// 			int nLimitMinute = atoi(token);
// 			if(nLimitMinute <= 0)
// 			{// ð  
// 
// 				return FALSE;
// 			}
// 
// 			BYTE byInflMask	 = INFLUENCE_TYPE_ALL_MASK;
// 			token = strtok(NULL, seps);
// 			if(token)
// 			{
// 				byInflMask = (BYTE)atoi(token);
// 				switch(byInflMask)
// 				{
// 				case INFLUENCE_TYPE_NORMAL:
// 				case INFLUENCE_TYPE_VCN:
// 				case INFLUENCE_TYPE_ANI:
// 				case INFLUENCE_TYPE_ALL_MASK:
// 					break;
// 				default:
// 					{
// 						return FALSE;
// 					}
// 				}
// 			}
// 
// 			///////////////////////////////////////////////////////////////////////////////
// 			// 2007-09-17 by cmkwon, StartGameEvent  ߻  ޽ ߰
// 			if(FALSE == ms_pFieldIOCP->m_gameEventManager.StartGameEvent(enGEventType, fExpRate, nLimitMinute, 1, CHARACTER_MAX_LEVEL, byInflMask))	// 2008-03-14 by dhjin, Level Ǿƿ ̺Ʈ  -
// 			{
// 				char szTemp[1024];
// 				if(FALSE == ms_pFieldIOCP->m_gameEventManager.GetGameEventInfoString(szTemp, NULL, enGEventType, TRUE))
// 				{
// 					return FALSE;
// 				}				
// 				this->SendString128(STRING_128_USER_NOTICE, "StartGameEvent error !!, %s", szTemp);
// 				return FALSE;
// 			}
// 
// 			char szTemp[1024];
// 			sprintf(szTemp, STRMSG_S_F2NOTIFY_0116
// 				, CGameEventManager::GetGameEventTypeString(enGEventType), fExpRate, nLimitMinute);
// 			ms_pFieldIOCP->SendString128ToAllClients(STRING_128_USER_NOTICE, szTemp, TRUE, byInflMask);
// 			return TRUE;
//		}
		
		return FALSE;				// ̺Ʈ ɾ 		
	}// end_else if(stricmp(token, "/̺Ʈ") == 0)
	else if(stricmp(token, STRCMD_CS_COMMAND_PREMEUM) == 0
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_PREMEUM_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION))
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}

		// format: /̾ [Ϲ|] []
		token = strtok(NULL, seps);
		if(NULL == token)
		{//  ڰ  - ġ ̺Ʈ  Ѵ

			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_PREMEUM_HELP);
			return TRUE;
		}

		if(0 == stricmp(token, STRCMD_CS_COMMAND_PREMEUM_PNORMAL))
		{
			token = strtok(NULL, seps);
			if(NULL == token)
			{
				Err_t nRetedErr = this->m_ItemManager.CashInsertPremiumCard(ms_pFieldIOCP->GetItemInfo(ITEM_NUM_CASH_NORMAL_PREMIUM_CARD));

				if(0 == nRetedErr)
				{
					this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0117);
				}
				else
				{
					this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0118);
				}
				return TRUE;
			}			
		}
		else if(0 == stricmp(token, STRCMD_CS_COMMAND_PREMEUM_PSUPER))
		{
			token = strtok(NULL, seps);
			if(NULL == token)
			{
				Err_t nRetedErr = this->m_ItemManager.CashInsertPremiumCard(ms_pFieldIOCP->GetItemInfo(ITEM_NUM_CASH_NORMAL_PREMIUM_CARD));
				if(0 == nRetedErr)
				{
					this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0119);
				}
				else
				{
					this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0118);
				}
				return TRUE;
			}
		}
// 2006-07-05 by cmkwon, ̾ ī ý MonthlyPay , ׷̵  ʿ
// 		else if(0 == stricmp(token, STRCMD_CS_COMMAND_PREMEUM_PUPGRADE))
// 		{
// 			token = strtok(NULL, seps);
// 			if(NULL == token)
// 			{
// 				Err_t nRetedErr = this->m_ItemManager.CashInsertPremiumCard(ms_pFieldIOCP->GetItemInfo(ITEM_NUM_CASH_UPGRADE_PREMIUM_CARD));
// 				if(0 == nRetedErr)
// 				{
// 					this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0119);
// 				}
// 				else
// 				{
// 					this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0118);
// 				}
// 				return TRUE;
// 			}
// 		}
		else if(0 == stricmp(token, STRCMD_CS_COMMAND_PREMEUM_PEND))
		{
			this->m_ItemManager.CashCheckPremiumCardExpire(TRUE);
			return TRUE;
		}
	}// end_else if(stricmp(token, "/̾") == 0)
// 2008-02-14 by cmkwon,  ɾ 
// 	else if(stricmp(token, STRCMD_CS_COMMAND_CITYWAR) == 0
// 		|| 0 == stricmp(token, STRCMD_CS_COMMAND_CITYWAR_1))
// 	{
// 		
// 		if ( !CheckCommandExecutability(RACE_OPERATION))
// 		{// 2006-04-13 by cmkwon, ڸ  
// 			return FALSE;
// 		}
// 
// 		if(NULL == m_pCurrentFieldMapChannel->m_pRefCityWar1
// 			|| FALSE == IS_CITYWAR_MAP_INDEX(m_pCurrentFieldMapChannel->GetMapChannelIndex().MapIndex))
// 		{
// 			this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0120);
// 			return TRUE;
// 		}
// 
// 		// format: / [|]
// 		token = strtok(NULL, seps);
// 		if(NULL == token)
// 		{//  ڰ  - ġ ̺Ʈ  Ѵ
// 
// 			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_CITYWAR_HELP);
// 			return TRUE;
// 		}
// 
// 		if(0 == stricmp(token, STRCMD_CS_COMMAND_CITYWAR_PSTART))
// 		{
// 			if(FALSE == m_pCurrentFieldMapChannel->m_pRefCityWar1->SetStartState())
// 			{
// 				this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0121);
// 				return TRUE;
// 			}
// 			ms_pFieldIOCP->OnCityWarStartFieldIOCP(m_pCurrentFieldMapChannel->m_pRefCityWar1);
// 			return TRUE;
// 		}
// 		else if(0 == stricmp(token, STRCMD_CS_COMMAND_CITYWAR_PEND))
// 		{
// 			vectCITYWAR_QUEST tmVectCITYWAR_QUEST;
// 			tmVectCITYWAR_QUEST.clear();
// 			if(FALSE == m_pCurrentFieldMapChannel->m_pRefCityWar1->SetEndState(&tmVectCITYWAR_QUEST))
// 			{
// 				this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0122);
// 				return TRUE;
// 			}
// 			ms_pFieldIOCP->OnCityWarEndFieldIOCP(m_pCurrentFieldMapChannel->m_pRefCityWar1, &tmVectCITYWAR_QUEST);			
// 			return TRUE;
// 		}
// 	}// end_else if(stricmp(token, "/") == 0)
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_STEALTH)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_STEALTH_1))
	{
		// "format: /ڽ -  Ͱ   ʴ´"
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2006-04-13 by cmkwon, /ڸ  
			return FALSE;
		}
		this->m_bStealthState = !this->m_bStealthState;
		if(FALSE == this->m_bStealthState)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0123);
		}
		else
		{
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0124);
		}

		INIT_MSG_WITH_BUFFER(MSG_FN_CHARACTER_CHANGE_STEALTHSTATE, T_FN_CHARACTER_CHANGE_STEALTHSTATE, pSMsg, BufSend);
		pSMsg->ChannelIndex		= m_pCurrentFieldMapChannel->GetMapChannelIndex().ChannelIndex;
		pSMsg->ClientIndex		= m_character.ClientIndex;
		pSMsg->bStealthState2	= this->GetStealthState();		// 2013-05-09 by hskim,  Ʈ 
		m_pCurrentFieldMapChannel->Send2NPCServerW(BufSend, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_STEALTHSTATE));
		return TRUE;
	}// end_else if(0 == stricmp(token, "/ڽ"))
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_RETURNALL)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_RETURNALL_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{
			// ڿ, Ϲ ڴ 
			return FALSE;
		}

		// format: /αȯ
// 2006-07-24 by cmkwon, Ʒ  º ø ̵ 
// 		token = strtok(NULL, seps);
// 		if(NULL == token)
// 		{//  ڰ 
// 			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_RETURNALL_HELP);
// 			return TRUE;
// 		}
// 		int MapIndex = atoi(token);
// 		if(FALSE == m_pCurrentFieldMapChannel->WarpToCityMapFieldMapChannel(MapIndex, this->GetCharacter()->GuildUniqueNumber))
// 		{
// 			this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0125);
// 		}

		GetCurrentFieldMapChannel()->WarpToCityMap(this->GetCharacter()->CharacterUniqueNumber);
		return TRUE;
	}// end_else if(0 == stricmp(token, "/αȯ"))
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT_1))
	{
		if (FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}
		
		// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  - ɾ  
		//// format: /Ǿƿ̺Ʈ [|] [ð(:)]
		// "format: /Ǿƿ̺Ʈ [255(缼)|0(Ϲݼ)|2(VCN)|4(ANI)] [|] [ð(:)]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_HAPPYHOUREVENT_HELP);
			return TRUE;
		}

		// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  -  Ķ ߰
		BYTE byInflTy = atoi(token);
		switch(byInflTy)
		{
		case INFLUENCE_TYPE_NORMAL:
		case INFLUENCE_TYPE_VCN:
		case INFLUENCE_TYPE_ANI:
		case INFLUENCE_TYPE_ALL_MASK:
			break;
		default:
			{
				this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_HAPPYHOUREVENT_HELP);
				return TRUE;
			}
		}

		token = strtok(NULL, seps);
		if(NULL ==  token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_HAPPYHOUREVENT_HELP);
			return TRUE;
		}
		if(0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT_PSTART))
		{
			token = strtok(NULL, seps);
			if(NULL == token)
			{
				this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_HAPPYHOUREVENT_HELP);
				return TRUE;
			}
			
			int nEventTime = max(10, atoi(token));
			ATUM_DATE_TIME aStartTime, aEndTime;
			aStartTime.SetCurrentDateTime(TRUE);
			aEndTime = aStartTime;
			aEndTime.AddDateTime(0, 0, 0, 0, nEventTime, 0);

			// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  -
			//ms_pFieldIOCP->m_pHappyHourEventManager->SetHappyHourEventTime(aStartTime, aEndTime, TRUE);
			ms_pFieldIOCP->m_pHappyHourEventManager->SetHappyHourEventPeriod(byInflTy, aStartTime, aEndTime, TRUE);
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0126, nEventTime);
			return TRUE;
		}
		else if(0 == stricmp(token, STRCMD_CS_COMMAND_HAPPYHOUREVENT_PEND))
		{
			ATUM_DATE_TIME aStartTime, aEndTime;
			aStartTime.SetCurrentDateTime(TRUE);
			aEndTime = aStartTime;
			// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  -
			//ms_pFieldIOCP->m_pHappyHourEventManager->SetHappyHourEventTime(aStartTime, aEndTime, TRUE);
			ms_pFieldIOCP->m_pHappyHourEventManager->SetHappyHourEventPeriod(byInflTy, aStartTime, aEndTime, TRUE);
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0127);
			return TRUE;
		}
	}// end_else if(0 == stricmp(token, "/Ǿƿ̺Ʈ"))
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_BONUSSTAT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_BONUSSTAT_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_BONUSSTAT_2))
	{
		if (FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2006-04-13 by cmkwon, ڸ  
			return FALSE;
		}
		
		// format: /BonusStat [Bonus Counts] [|character name] - ʽ  
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_BONUSSTAT_HELP);
			return TRUE;
		}
		int nBonus = min(255, atoi(token));
		if(nBonus <= 0)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_BONUSSTAT_HELP);
			return TRUE;
		}
		CFieldIOCPSocket *pFISock = this;
		token = strtok(NULL, seps);
		if(token)
		{
			pFISock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if (pFISock == NULL
				|| FALSE == pFISock->IsUsing())
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0112, token);
				return FALSE;
			}
		}

		pFISock->m_character.BonusStat = min(255, pFISock->m_character.BonusStat+nBonus);		// 2007-06-19 by cmkwon,  
		CAtumLogSender::SendLogMessageSTAT(pFISock, STAT_BONUS, m_character.BonusStat);			// 2007-06-20 by cmkwon, ʽ   α 
		pFISock->SendStat_UpdateDB(TRUE, FALSE, TRUE);		// 2010-05-12 by cmkwon, 1 ߵ   Ʈ  ʽ   (K0002932) - 
		pFISock->UpdateDBtoBonusStatPoint();
		return TRUE;
	}// end_else if(0 == stricmp(token, "/ʽ"))
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_BONUSSTAT_POINT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_BONUSSTAT_POINT_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_BONUSSTAT_POINT_2))
	{// 2007-01-08 by dhjin, ʽƮ DB  Ų. (ű ɸ  ʽ  Ʈ DB Ʈ ȵǴ  )
		if (FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2007-01-10 by cmkwon, ڸ  
			return FALSE;
		}
		
		// "format: /BonusStatPoint [BonusStatPoint Counts] [|character name] - BonusStatPoint DB UPDATE"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, "BonusStatPoint:[%3d]", m_character.BonusStatPoint);
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_BONUSSTAT_POINT_HELP);
			return TRUE;
		}
		int nBonus = min(255, atoi(token));
		if(nBonus <= 0)
		{
			this->SendString128(STRING_128_USER_NOTICE, "BonusStatPoint:[%3d]", m_character.BonusStatPoint);
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_BONUSSTAT_POINT_HELP);
			return TRUE;
		}
		CFieldIOCPSocket *pFISock = this;
		token = strtok(NULL, seps);
		if(token)
		{
			pFISock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if (NULL == pFISock
				|| FALSE == pFISock->IsValidCharacter(FALSE))
			{
				SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0112, token);
				return FALSE;
			}
		}

		pFISock->m_character.BonusStatPoint	= nBonus;
		CAtumLogSender::SendLogMessageSTAT(pFISock, STAT_BONUS_STAT_POINT, m_character.BonusStatPoint);			// 2007-06-20 by cmkwon, ʽ   α 
		pFISock->SendStat_UpdateDB(TRUE, FALSE);
		pFISock->UpdateDBtoBonusStatPoint();			// ʽ  Ʈ DB 
		return TRUE;
	}// end_else if(0 == stricmp(token, "/ʽDBƮ"))	
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_QUESTCOMPLETION_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_QUESTCOMPLETION_1))
// 2007-06-19 by cmkwon,  
//		|| 0 == stricmp(token, STRCMD_CS_COMMAND_BONUSSTAT_2))
	{
		if (FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2007-11-08 by cmkwon, GM ɾ  - '/ƮϷ'   Ұ, // Ϲ ڴ (,  )
			return FALSE;
		}

		// "format: /ƮϷ [Ʈε]"
		int nReqQuestIndex = -1;
		token = strtok(NULL, seps);
		if(token)
		{
			nReqQuestIndex	= atoi(token);
		}
		if(FALSE == this->GMQuestCompletion(nReqQuestIndex))
		{
			SendString128(STRING_128_ADMIN_CMD, "Quest cannot be completed.");
			return FALSE;
		}
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_INFLDITRIBUTION_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_INFLDITRIBUTION_1))
	{// 2006-02-08 by cmkwon,   

		int nVCNDistPercent = ms_pFieldIOCP->GetInfluenceTypeDistirbutionPercent(INFLUENCE_TYPE_VCN);
		// "format: /º"
		// 2007-11-08 by cmkwon, GM ɾ  - ڸ  ش.
		if (FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// Ϲ 
		//	  ' Ա:55%'
		//	  '˸ Ա:45%'
			SendString128(STRING_128_USER_NOTICE, "  %s:%d%%"
				, STRCMD_CS_INFLUENCE_TYPE_VCN, ms_pFieldIOCP->GetInfluenceTypeDistirbutionPercent(INFLUENCE_TYPE_VCN));
			SendString128(STRING_128_USER_NOTICE, "  %s:%d%%"
				, STRCMD_CS_INFLUENCE_TYPE_ANI, ms_pFieldIOCP->GetInfluenceTypeDistirbutionPercent(INFLUENCE_TYPE_ANI));
		}
		else
		{// , 
		//	  ' Ա:55%(550)'
		//	  '˸ Ա:45%(450)'
			SendString128(STRING_128_USER_NOTICE, "  %s:%d%%(%d)"
				, STRCMD_CS_INFLUENCE_TYPE_VCN, ms_pFieldIOCP->GetInfluenceTypeDistirbutionPercent(INFLUENCE_TYPE_VCN), ms_pFieldIOCP->m_nVCNInfluenceCount);
			SendString128(STRING_128_USER_NOTICE, "  %s:%d%%(%d)"
				, STRCMD_CS_INFLUENCE_TYPE_ANI, ms_pFieldIOCP->GetInfluenceTypeDistirbutionPercent(INFLUENCE_TYPE_ANI), ms_pFieldIOCP->m_nANIInfluenceCount);
		}

		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_CHANGEINFL_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_CHANGEINFL_1))
	{
		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2006-04-13 by cmkwon, /ڸ  
			return FALSE;
		}

		//////////////////////////////////////////////////////////////////////////
		// 2007-05-10 by dhjin, ARENA ¿   Ұϴ
		if(ARENA_STATE_NONE != this->m_ArenaInfo.State)
		{
			return FALSE;
		}
		
		// 2009-09-09 ~ 2010-01-20 by dhjin, ǴƼ -    μ Ѵ.   üũ
		if(INFINITY_STATE_NONE != this->m_InfinityPlayingInfo.InfinityState ) {
			return FALSE;
		}

		// "format: /º [|1(Normal)|2(VCN)|4(ANI)]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_CHANGEINFL_HELP);
			this->SendString128(STRING_128_USER_NOTICE, "Your nation is %s(%d)."
				, CAtumSJ::GetInfluenceTypeString(m_character.InfluenceType), m_character.InfluenceType);
			return TRUE;
		}

		BYTE byChangeInfl = atoi(token);		// 2006-02-08 by cmkwon
		if(FALSE == IS_VALID_INFLUENCE_TYPE(byChangeInfl)
			|| m_character.InfluenceType == byChangeInfl)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_CHANGEINFL_HELP);
			this->SendString128(STRING_128_USER_NOTICE, "Your nation is %s(%d)."
				, CAtumSJ::GetInfluenceTypeString(m_character.InfluenceType), m_character.InfluenceType);
			return TRUE;
		}

		this->ChangeCharacterInfluenceType(byChangeInfl, TRUE);		// º ó

		this->GMQuestAdjustByInfluenceType(byChangeInfl);			// 2006-08-08 by cmkwon, º  º Ʈ 
		return TRUE;
	}
	// 2013-07-26 by jhseol, Ÿ  º
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_ACCOUNT_CHANGEINFL_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ACCOUNT_CHANGEINFL_1))
	{
		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2006-04-13 by cmkwon, /ڸ  
			return FALSE;
		}
		
		//////////////////////////////////////////////////////////////////////////
		// 2007-05-10 by dhjin, ARENA ¿   Ұϴ
		if(ARENA_STATE_NONE != this->m_ArenaInfo.State)
		{
			return FALSE;
		}
		
		// 2009-09-09 ~ 2010-01-20 by dhjin, ǴƼ -    μ Ѵ.   üũ
		if(INFINITY_STATE_NONE != this->m_InfinityPlayingInfo.InfinityState ) {
			return FALSE;
		}
		
		// "format: /º [UID] [2(BCU)|4(ANI)]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ACCOUNT_CHANGEINFL_HELP);
			return TRUE;
		}
		
		UID32_t UserAccountUID = atoi(token);
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ACCOUNT_CHANGEINFL_HELP);
			return TRUE;
		}

		BYTE byChangeInfl = atoi(token);
		if( INFLUENCE_TYPE_VCN == byChangeInfl || INFLUENCE_TYPE_ANI == byChangeInfl)
		{
			// º ó
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_AccountInflChange, this, 0, NULL, NULL, (INT64)UserAccountUID, (INT64)byChangeInfl);
			return TRUE;
		}
		else
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ACCOUNT_CHANGEINFL_HELP);
			return TRUE;
		}
	}
	// end 2013-07-26 by jhseol, Ÿ  º
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_GOMONSTER_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_GOMONSTER_1))
	{
		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// Ϲ ڴ (,  )
			return FALSE;
		}

		// "format: / [MonsterName|MonsterNumber]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_GOMONSTER_HELP);
			return TRUE;
		}

		MONSTER_INFO *pMonInfo = ms_pFieldIOCP->GetMonsterInfo(atoi(token));
		if(NULL == pMonInfo)
		{
			pMonInfo = ms_pFieldIOCP->GetMonsterInfo(token);
			if(NULL == pMonInfo)
			{
				return FALSE;
			}
		}

		CFieldMonster *pFMon = (CFieldMonster*)m_pCurrentFieldMapChannel->GetMonsterByMonsterUnitKind(pMonInfo->MonsterUnitKind);
		if(NULL == pFMon)
		{
			return FALSE;
		}

		//////////////////////////////////////////////////////////////////////////
		// 2007-05-22 by dhjin, Ʒ ʿ  Ʒ  ̸  Ż ó Ѵ.
		if(IS_MAP_INFLUENCE_ARENA(m_pCurrentFieldMapChannel->GetMapInfluenceTypeW())
			&& m_ArenaInfo.IsValidArenaState() )
		{
			if(m_ArenaInfo.WatchState)
			{// 2007-06-21 by dhjin, ̸   ʱȭѴ.
				this->WatchEnd();
			}
			else
			{
				this->ms_pFieldIOCP->m_ArenaManager.DeleteMember(this);		// 2007-04-23 by dhjin,  
				this->m_ArenaInfo.ResetArenaInfo();		
				this->SendAddMessageType(T_FC_ARENA_REAVE_TEAM_OK);			// 2007-05-03 by dhjin, Ʒ    

				// 2008-01-15 by dhjin, Ʒ  - ʵ    Ͽ ó
				this->SendArenaCharacterDisConnect();
//				// 2007-06-07 by dhjin,   1
//				this->m_character.ArenaDisConnect += 1;
//				QPARAM_UPDATE_ARENA_DISCONNECT *pQparam = new QPARAM_UPDATE_ARENA_DISCONNECT;
//				pQparam->CharacterUID			= this->m_character.CharacterUniqueNumber;
//				pQparam->AccountUID				= this->m_character.AccountUniqueNumber;
//				pQparam->ArenaDisConnect		= this->m_character.ArenaDisConnect;
//				this->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateArenaDisConnect, this, 0, pQparam);
		    }
        }
		
		WarpToMap(m_pCurrentFieldMapChannel->m_MapChannelIndex, &pFMon->PositionVector);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_SIGNBOARD_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_SIGNBOARD_1))
	{
		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER|RACE_INFLUENCE_LEADER))
		{// 2006-04-20 by cmkwon, //¸  
			return FALSE;
		}
		// "format: / [ӽð(:)] [  ]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_SIGNBOARD_HELP);
			return TRUE;
		}

		int nUpkeepMinute = atoi(token);
		if(0 >= nUpkeepMinute)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_SIGNBOARD_HELP);
			return FALSE;
		}

		token = strtok(NULL, "");
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_SIGNBOARD_HELP);
			return FALSE;
		}

		MSG_SIGN_BOARD_STRING	tmSignBoardString;
		MEMSET_ZERO(&tmSignBoardString, sizeof(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING));
		if(COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER))
		{
			tmSignBoardString.InfluenceMask0	= m_character.InfluenceType;
			tmSignBoardString.IsInfluenceLeader	= TRUE;
		}
		else
		{
			tmSignBoardString.InfluenceMask0	= INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI;
			tmSignBoardString.IsInfluenceLeader	= FALSE;
		}
		tmSignBoardString.SignBoardExprieATime.SetCurrentDateTime(TRUE);
		tmSignBoardString.SignBoardExprieATime.AddDateTime(0, 0, 0, 0, nUpkeepMinute, 0);
		STRNCPY_MEMSET(tmSignBoardString.SingBoardString, token, SIZE_MAX_SIGN_BOARD_STRING);
		if(FALSE == ms_pFieldIOCP->SignBoardInsertString(&tmSignBoardString))
		{
			this->SendString128(STRING_128_USER_NOTICE, "SignBoard String Buffer overflow!!");
			return FALSE;
		}
		
		INIT_MSG_WITH_BUFFER(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING, T_FC_WAR_SIGN_BOARD_INSERT_STRING, pSSignBoardString, SendBuf);
		pSSignBoardString->IsInfluenceLeader	= tmSignBoardString.IsInfluenceLeader;
		pSSignBoardString->StringIndex			= tmSignBoardString.StringIndex;
		pSSignBoardString->SignBoardExprieATime	= tmSignBoardString.SignBoardExprieATime;
		STRNCPY_MEMSET(pSSignBoardString->SingBoardString, tmSignBoardString.SingBoardString, SIZE_MAX_SIGN_BOARD_STRING);
		if(FALSE == tmSignBoardString.IsInfluenceLeader)
		{
			if(FALSE == this->IsCityCurrentFieldMapChannel())
			{
				SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING));
			}
			ms_pFieldIOCP->SendMessageToCityClients(SendBuf, MSG_SIZE(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING), INFLUENCE_TYPE_VCN);
			ms_pFieldIOCP->SendMessageToCityClients(SendBuf, MSG_SIZE(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING), INFLUENCE_TYPE_ANI);
		}
		else
		{
			if(FALSE == this->IsCityCurrentFieldMapChannel())
			{
				SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING));
			}
			ms_pFieldIOCP->SendMessageToCityClients(SendBuf, MSG_SIZE(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING), GetCharacter()->InfluenceType);
		}
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_SIGNBOARD_DEL_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_SIGNBOARD_DEL_1))
	{

		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER|RACE_INFLUENCE_LEADER))
		{// , ,    ɾ
			return FALSE;
		}
		// "format: /ǻ [   ε]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_SIGNBOARD_DEL_HELP);
			return TRUE;
		}

		int nStrIdx = atoi(token);
		if(0 >= nStrIdx)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_SIGNBOARD_DEL_HELP);
			return FALSE;
		}
		BOOL bInflLeader = COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER);
		if(FALSE == ms_pFieldIOCP->SignBoardDeleteString(nStrIdx, bInflLeader))
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_SIGNBOARD_DEL_HELP);
			return FALSE;
		}
				
		INIT_MSG_WITH_BUFFER(MSG_FC_WAR_SIGN_BOARD_DELETE_STRING, T_FC_WAR_SIGN_BOARD_DELETE_STRING, pSDelString, SendBuf);
		pSDelString->DeleteStringIndex			= nStrIdx;
		if(FALSE == bInflLeader)
		{
			ms_pFieldIOCP->SendMessageToAllClients(SendBuf, MSG_SIZE(MSG_FC_WAR_SIGN_BOARD_DELETE_STRING));
		}
		else
		{
			ms_pFieldIOCP->SendMessageToAllClients(SendBuf, MSG_SIZE(MSG_FC_WAR_SIGN_BOARD_DELETE_STRING), m_character.InfluenceType);
		}
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_CONPOINT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_CONPOINT_1))
	{// 2006-04-24 by cmkwon
// 2006-05-22 by cmkwon, Gala-Net û 
// 		if(FALSE == g_pFieldGlobal->InMasangServer())
// 		{// 2006-04-24 by cmkwon,  ο   ɾ
// 			return FALSE;
// 		}
		if (FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// ڸ   ɾ
			return FALSE;
		}
		// "format: /⿩ [(2:VCN, 4:ANI)] [] - Ư  ⿩ Ų"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_CONPOINT_HELP);
			this->SendString128(STRING_128_USER_NOTICE, "ContributionPoint VCN:%5d, ANI:%5d"
				, ms_pFieldIOCP->m_InflWarManager.GetContributionPoint(INFLUENCE_TYPE_VCN)
				, ms_pFieldIOCP->m_InflWarManager.GetContributionPoint(INFLUENCE_TYPE_ANI));
			return TRUE;
		}

		int nInflTy = atoi(token);
		if(INFLUENCE_TYPE_VCN != nInflTy
			&& INFLUENCE_TYPE_ANI != nInflTy)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_CONPOINT_HELP);
			return FALSE;
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_CONPOINT_HELP);
			return FALSE;
		}

		int nAddPoint = atoi(token);

		if(0 >= nAddPoint
			|| 100000 < nAddPoint)
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ContributionPoint");
			return FALSE;
		}

// 2013-05-09 by hskim,  Ʈ 
#ifdef S_UPGRADE_INFLUENCE_POINT_HSKIM
		ms_pFieldIOCP->m_InflWarManager.CalcContributionPoint(nInflTy, nAddPoint, 0);
#else
		ms_pFieldIOCP->m_InflWarManager.AddContributionPoint(nInflTy, nAddPoint);
#endif
// end 2013-05-09 by hskim,  Ʈ 
		
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_COMEONINFL_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_COMEONINFL_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_COMEONINFL_2))
	{// 2006-07-18 by cmkwon
		// 2012-09-11 by jhseol,   GM   "/" ɾ Ȱȭ
#ifdef _DEFINED_GAMEFORGE4D_
		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2007-11-08 by cmkwon, GM ɾ  - '/¿'   Ұ, // 2006-07-18 by cmkwon, /ڸ  
			return TRUE;
		}
#else
		if(FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2007-11-08 by cmkwon, GM ɾ  - '/¿'   Ұ, // 2006-07-18 by cmkwon, /ڸ  
			return TRUE;
		}
#endif
		// end 2012-09-11 by jhseol,   GM   "/" ɾ Ȱȭ

		//////////////////////////////////////////////////////////////////////////
		// 2007-06-22 by dhjin, Ʒ ʿ  Ұ
		if(IS_MAP_INFLUENCE_ARENA(this->m_pCurrentFieldMapChannel->GetMapInfluenceTypeW()))
		{
			return FALSE;
		}

		// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
		// "format: /ComeOnInfl [1(Normal)|2(VCN)|4(ANI)|255(All)] [ִο] [0|ּҷ] [0|ִ뷹] [1(B)|16(M)|256(A)|4096] [  ޽] -   ,   鿡 ̺Ʈ ̵ ûѴ"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}

		SCALL_WARP_EVENT tmCallWarpEvent;
		MEMSET_ZERO(&tmCallWarpEvent, sizeof(SCALL_WARP_EVENT));
		tmCallWarpEvent.byPermissionInfluenceMask	= (BYTE)atoi(token);
		if(FALSE == COMPARE_INFLUENCE(tmCallWarpEvent.byPermissionInfluenceMask, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI))
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}
		
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}
		tmCallWarpEvent.nPermissionUserCnts			= min(1000, atoi(token));
		if(0 == tmCallWarpEvent.nPermissionUserCnts)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}
		tmCallWarpEvent.byPermissionMinLevel		= atoi(token);

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}
		tmCallWarpEvent.byPermissionMaxLevel		= atoi(token);
		if(0 != tmCallWarpEvent.byPermissionMaxLevel
			&& tmCallWarpEvent.byPermissionMinLevel > tmCallWarpEvent.byPermissionMaxLevel)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}

		// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - Ÿ 
		USHORT usReqUnitKind = atoi(token);
		if(IS_BGEAR(usReqUnitKind)){		tmCallWarpEvent.usReqUnitKind |= UNITKIND_BGEAR_MASK;}
		if(IS_MGEAR(usReqUnitKind)){		tmCallWarpEvent.usReqUnitKind |= UNITKIND_MGEAR_MASK;}
		if(IS_AGEAR(usReqUnitKind)){		tmCallWarpEvent.usReqUnitKind |= UNITKIND_AGEAR_MASK;}
		if(IS_IGEAR(usReqUnitKind)){		tmCallWarpEvent.usReqUnitKind |= UNITKIND_IGEAR_MASK;}
		if(0 == tmCallWarpEvent.usReqUnitKind)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}

		token = strtok(NULL, "");
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_COMEONINFL_HELP2);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - 
			return FALSE;
		}
		tmCallWarpEvent.dwCallWarpEventID		= timeGetTime();
		tmCallWarpEvent.dwSupportTermTick		= 12000;			// 2006-07-21 by cmkwon, 12
		tmCallWarpEvent.vWarpPosition			= m_character.PositionVector;
		tmCallWarpEvent.CallMapChannelIndex		= GetCurrentFieldMapChannel()->GetMapChannelIndex();
		ms_pFieldIOCP->AddCallWarpEventRequest(&tmCallWarpEvent);

		INIT_MSG_WITH_BUFFER(MSG_FC_EVENT_CALL_WARP_EVENT_REQUEST, T_FC_EVENT_CALL_WARP_EVENT_REQUEST, pSCallWarp, SendBuf);
		pSCallWarp->dwCallWarpEventID0			= tmCallWarpEvent.dwCallWarpEventID;
		pSCallWarp->dwSupportTermTick0			= tmCallWarpEvent.dwSupportTermTick-2000;	// 2006-07-24 by cmkwon, 10
		STRNCPY_MEMSET(pSCallWarp->szUserMessage, token, SIZE_STRING_128);
		ms_pFieldIOCP->SendMessageToAllClients(SendBuf, MSG_SIZE(MSG_FC_EVENT_CALL_WARP_EVENT_REQUEST), tmCallWarpEvent.byPermissionInfluenceMask
			, tmCallWarpEvent.byPermissionMinLevel, tmCallWarpEvent.byPermissionMaxLevel, &tmCallWarpEvent.CallMapChannelIndex, FALSE, TRUE, tmCallWarpEvent.usReqUnitKind);	// 2008-09-09 by cmkwon, /¼ȯ ɾ  Ʈ Ÿ ߰ - , // 2007-06-22 by dhjin, Ʒ  Դ  ʴ´.
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINMAP_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINMAP_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMINMAP_2))
	{// 2006-07-24 by cmkwon
		if(FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2006-10-23 by cmkwon, ڸ ϵ 
			return TRUE;
		}

		// "format: /InsertItemInMap [1(Normal)|2(VCN)|4(ANI)|3|5|6|7] [Item Number] [# of items] -       Ѵ"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMINMAP_HELP);
			return FALSE;
		}

		BYTE byInflTyMask = (BYTE)atoi(token);
		if(FALSE == COMPARE_INFLUENCE(byInflTyMask, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid IfluenceTypeMask");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMINMAP_HELP);
			return FALSE;
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, "ItemNum error");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMINMAP_HELP);
			return FALSE;
		}

		int nInsertItemNum = atoi(token);
		if(NULL == ms_pFieldIOCP->GetItemInfo(nInsertItemNum))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ItemNum");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMINMAP_HELP);
			return FALSE;			
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, "ItemCount error");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMINMAP_HELP);
			return FALSE;
		}

		int nInsertItemCnts = atoi(token);
		if(0 >= nInsertItemCnts)
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ItemCount");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMINMAP_HELP);
			return FALSE;
		}
		
		GetCurrentFieldMapChannel()->InsertItemInMap(nInsertItemNum, nInsertItemCnts, byInflTyMask);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_DISTRIBUTIONLEVEL_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_DISTRIBUTIONLEVEL_1))
	{// 2006-08-09 by dhjin. / ɾ ó.
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2007-11-08 by cmkwon, GM ɾ  - '/'   Ұ, // 2006-08-08 by dhjin, /ڸ  
			return FALSE;
		}
		int UserDistributionLevel[10];
		
		ms_pFieldIOCP->GetUserLevelList(UserDistributionLevel);
	
		SendString128(STRING_128_ADMIN_CMD, "Lv1~10:%d,Lv11~20:%d,Lv21~30:%d,Lv31~40:%d,Lv41~50:%d,Lv51~60:%d,Lv61~70:%d,Lv71~80:%d,Lv81~90:%d,Lv91~:%d"
			,UserDistributionLevel[0],UserDistributionLevel[1]
			,UserDistributionLevel[2],UserDistributionLevel[3],UserDistributionLevel[4],UserDistributionLevel[5]
			,UserDistributionLevel[6],UserDistributionLevel[7],UserDistributionLevel[8],UserDistributionLevel[9]);

		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_PCBANGUSERCOUNT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_PCBANGUSERCOUNT_1))
	{// 2007-01-25 by dhjin, /PCBang ɾ ó.
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2007-11-08 by cmkwon, GM ɾ  - '/PCBang'   Ұ, // 2007-01-25 by dhjin, /ڸ  
			return FALSE;
		}
		int PCBangUserCount = ms_pFieldIOCP->GetPCBangUserCount();
	
		SendString128(STRING_128_ADMIN_CMD, "TotalPCBangUserCount:%d", PCBangUserCount);

		return TRUE;
	}	
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_TIMELIMITSYSTEM_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_TIMELIMITSYSTEM_1))
	{// 2006-11-17 by cmkwon, format: /ðѽý [on|off] -  Ϸ   ð ش

		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// 2006-11-17 by cmkwon, /ڸ  
			return FALSE;
		}

		if(LANGUAGE_TYPE_VIETNAMESE != g_pFieldGlobal->GetLanguageType())
		{// 2006-11-17 by cmkwon, Ϲ  Ʈ  
			return FALSE;
		}
	
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_TIMELIMITSYSTEM_HELP);
			return FALSE;
		}

		if(0 == stricmp(token, STRCMD_CS_COMMAND_TIMELIMITSYSTEM_P2ON))
		{// 2006-11-17 by cmkwon, ðѽý ѱ
			ms_pFieldIOCP->m_bUseTimeLimiteSysteOfToday		= TRUE;
		}
		else if(0 == stricmp(token, STRCMD_CS_COMMAND_TIMELIMITSYSTEM_P2OFF))
		{// 2006-11-17 by cmkwon, ðѽý 
			ms_pFieldIOCP->m_bUseTimeLimiteSysteOfToday		= FALSE;
		}
		else
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_TIMELIMITSYSTEM_HELP);
			return FALSE;
		}		

		this->SendString128(STRING_128_USER_NOTICE, "%s ==> [%s]", STRCMD_CS_COMMAND_TIMELIMITSYSTEM_1, token);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_PLAYTIME_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_PLAYTIME_1))
	{

		// 2008-03-28 by cmkwon, ڸ PlayTime  ϰ 
		token = strtok(NULL, seps);
		if(token
			&& CheckCommandExecutability(RACE_OPERATION))
		{
			int nSetContinueTimeSec = atoi(token);
			if(IS_IN_RANGE(0, nSetContinueTimeSec, 86400))		// 86400 = 24ð
			{
				this->GPInitGameStartTime();			// ؽð ʱȭ
				this->m_nGameContinueTimeInSecondOfToday		= nSetContinueTimeSec;	//  ð 
				this->m_nGameContinueTimeInSecondOfToday4Viet	= nSetContinueTimeSec;	//  ð 
			}
		}

		char szTemp[1024];
		this->GetPlayTimeInfoString(szTemp);

		this->SendString128(STRING_128_USER_NOTICE, "Playtime: %s", szTemp);
		return TRUE;
	}
	//////////////////////////////////////////////////////////////////////////
	// 2007-02-15 by dhjin, Ŭ̾Ʈ ó
	//	else if(0 == stricmp(token, STRCMD_CS_COMMAND_SUBLEADER_0)
	//		|| 0 == stricmp(token, STRCMD_CS_COMMAND_SUBLEADER_1))
	//	{// 2007-02-13 by dhjin, format: / [CharacterName] -  
	//		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_INFLUENCE_LEADER))
	//		{// ,    ɾ
	//			return FALSE;
	//		}
	//		
	//		token = strtok(NULL, seps);
	//		if(NULL == token)
	//		{
	//			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_SUBLEADER_HELP);
	//			return TRUE;
	//		}		
	//		
	//		return TRUE;
	//	}

	else if(0 == stricmp(token, STRCMD_CS_COMMAND_STRATEGYPOINTINFO_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_STRATEGYPOINTINFO_1))
	{// 2007-02-23 by dhjin, format: / -     ش
		/* Remove /sp command
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// /ڸ  
			return FALSE;
		}
		*/
		if(ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.empty())
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_STRATEGYPOINTINFO_EMPTY);
		}
		else
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_STRATEGYPOINTINFO_EXIST);
		
			mt_auto_lock mtA(&(ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo));	// 2007-10-08 by cmkwon, lock ʿ

			mtvectorSSUMMON_STRATEGYPOINT_INFO::iterator	itr = ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.begin();
			while(itr != ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.end())
			{
				if (COMPARE_RACE(m_character.Race, RACE_ACCOUNT_TYPE_MASK))
				{
					this->SendString128(STRING_128_USER_NOTICE, "%s  :  %s(%d)", STRCMD_CS_COMMAND_STRATEGYPOINTINFO_ZONE, itr->MapName, itr->MapIndex);
				}
				else
				{
					this->SendString128(STRING_128_USER_NOTICE, "%s  :  %s", STRCMD_CS_COMMAND_STRATEGYPOINTINFO_ZONE, itr->MapName);
				}
				this->SendString128(STRING_128_USER_NOTICE, "%s  :  %s"
									, STRCMD_CS_COMMAND_STRATEGYPOINTINFO_STARTTIME, itr->SummonStrategyPointTime.GetDateTimeString(STRNBUF(SIZE_MAX_SQL_DATETIME_STRING), TRUE));
				itr++;
			}
		}
		
		return TRUE;
	}
	
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_OBSERVER_REG_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_OBSERVER_REG_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// /ڸ  
			return FALSE;
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_OBSERVER_REG_HELP);
			return TRUE;
		}

		int nRegNum = atoi(token);
		
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_OBSERVER_REG_HELP);
			return FALSE;
		}

		CFieldIOCPSocket *pOTFISoc = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
		if (NULL == pOTFISoc)
		{
			SendString128(STRING_128_ADMIN_CMD, "%s NOT PLAYING", token);
			return TRUE;		// ʵ  ߰  ʿ 
		}

		if(this == pOTFISoc)
		{
			this->SendString128(STRING_128_USER_NOTICE, "Cann't myself");
			return FALSE;
		}

		if(FALSE == this->ObserverTargetCharacterCheck(pOTFISoc))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid Character !!");
			return FALSE;
		}

		INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_OBSERVER_REG, T_FC_CHARACTER_OBSERVER_REG, pMsg, SendBuf);
		pMsg->ClientIndex	=	pOTFISoc->GetCharacter()->ClientIndex;
		pMsg->nRegNum		=	nRegNum;
		this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_OBSERVER_REG));
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_JAMBOREE_INIT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_JAMBOREE_INIT_1))
	{// 2007-04-10 by cmkwon
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// ڸ  
			return FALSE;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2007-04-10 by cmkwon, "format: /InitJamboree [] - ȸ DB(atum2_db_20) ʱȭ Ѵ."

		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_JAMBOREE_INIT_HELP);
			SendString128(STRING_128_ADMIN_CMD, STRMSG_070410_0000);
			return TRUE;
		}

		int nVerifyNumber = atoi(token);

		if(0 == ms_pFieldIOCP->m_nJamboreeInitCommandVerifyNumber
			||  nVerifyNumber != ms_pFieldIOCP->m_nJamboreeInitCommandVerifyNumber)
		{
			ms_pFieldIOCP->m_nJamboreeInitCommandVerifyNumber = RANDI(1000, 10000);
			SendString128(STRING_128_ADMIN_CMD, STRMSG_070410_0000);
			SendString128(STRING_128_ADMIN_CMD, STRMSG_070410_0001, ms_pFieldIOCP->m_nJamboreeInitCommandVerifyNumber);
			return TRUE;
		}
		ms_pFieldIOCP->m_nJamboreeInitCommandVerifyNumber = 0;

		///////////////////////////////////////////////////////////////////////////////
		// 2007-04-10 by cmkwon, ý α 
		char szSysLog[1024];
		sprintf(szSysLog, "[Notify]: Jamboree DB Server Init, Admin[%s]\r\n", GetCharacterString(GetCharacter(), string()));
		g_pFieldGlobal->WriteSystemLog(szSysLog);
		DbgOut(szSysLog);

		///////////////////////////////////////////////////////////////////////////////
		// 2007-04-10 by cmkwon, ʱȭ ν ȣ
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_JamboreeInit, this, m_character.AccountUniqueNumber, NULL);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_JAMBOREE_ENTRANTS_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_JAMBOREE_ENTRANTS_1))
	{// 2007-04-10 by cmkwon
		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// ڸ  
			return FALSE;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2007-04-10 by cmkwon, "format: /EntrantJamboree [CharacterName] -  ĳ ͸ ȸ DB(atum2_db_20) Ѵ."
		// 2008-04-15 by cmkwon, ȸ(JamboreeServer) ý  - "format: /EntrantJamboree [CharacterName] [1(Normal)|2(BCU)|4(ANI)] -  ĳ ͸ ȸ DB(atum2_db_20) ش  Ѵ."
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_JAMBOREE_ENTRANTS_HELP);
			return TRUE;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2008-04-15 by cmkwon, ȸ(JamboreeServer) ý  - "/ȸ" ɾ  
		char szCharName[SIZE_MAX_CHARACTER_NAME];
		STRNCPY_MEMSET(szCharName, token, SIZE_MAX_CHARACTER_NAME);

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_JAMBOREE_ENTRANTS_HELP);
			return TRUE;
		}
		BYTE byInflTy = (BYTE)(atoi(token));
		if(FALSE == IS_VALID_INFLUENCE_TYPE(byInflTy))
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_JAMBOREE_ENTRANTS_HELP);
			return TRUE;
		}


// 2008-04-15 by cmkwon, ȸ(JamboreeServer) ý  - Ʒ   
// 		QPARAM_JAMBOREE_ENTRANTS *pQPEntrants = new QPARAM_JAMBOREE_ENTRANTS;
// 		STRNCPY_MEMSET(pQPEntrants->szCharName0, token, SIZE_MAX_CHARACTER_NAME);
// 		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_JamboreeEntrants, this, m_character.AccountUniqueNumber, pQPEntrants);
 		QPARAM_JAMBOREE_ENTRANTS *pQPEntrants = new QPARAM_JAMBOREE_ENTRANTS;
 		STRNCPY_MEMSET(pQPEntrants->szCharName0, szCharName, SIZE_MAX_CHARACTER_NAME);
 		pQPEntrants->byInflTy	= byInflTy;											// 2008-04-15 by cmkwon, ȸ(JamboreeServer) ý  -  ߰
 		pQPEntrants->MapIndex	= CAtumSJ::GetCityMapIndexByInfluence(byInflTy);	// 2008-04-15 by cmkwon, ȸ(JamboreeServer) ý  - ø  ߰
 		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_JamboreeEntrants, this, m_character.AccountUniqueNumber, pQPEntrants);		
		return TRUE;
	}
	else if(0 == stricmp(token, STRMSG_CS_COMMAND_ARENA_TEAM_INFO_0)
		|| 0 == stricmp(token, STRMSG_CS_COMMAND_ARENA_TEAM_INFO_1))
	{// 2007-05-23 by dhjin, format: /Ʒ -  Ʒ   ش.

		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// /ڸ  
			return FALSE;
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_CS_COMMAND_ARENA_TEAM_INFO_HELP);
			return TRUE;
		}

		BYTE byInfl = atoi(token);
		if(INFLUENCE_TYPE_VCN == byInfl || INFLUENCE_TYPE_ANI == byInfl)
		{// 2007-05-25 by dhjin, ˸ϰ  ¸
			this->ms_pFieldIOCP->m_ArenaManager.SendArenaTeamInfoByGMCommand(this, byInfl);
			return TRUE;
		}
		
		this->SendString128(STRING_128_USER_NOTICE, STRMSG_CS_COMMAND_ARENA_TEAM_INFO_HELP);
		return TRUE;
	}
	else if(0 == stricmp(token, STRMSG_CS_COMMAND_WATCH_START_INFO_0)
		|| 0 == stricmp(token, STRMSG_CS_COMMAND_WATCH_START_INFO_1))
	{// 2007-06-15 by dhjin, format: / -  Ѵ.

		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// /ڸ  
			return FALSE;
		}

		if(COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
		{// 2007-06-20 by dhjin, Ϲ  Ұ
			SendString128(STRING_128_ADMIN_CMD, STRMSG_070620_0000);
			return RES_BREAK;
		}

		if(FALSE == this->IsInvisibleCharacter())
		{// 2007-06-15 by dhjin, ¿ 
			SendString128(STRING_128_ADMIN_CMD, STRMSG_070615_0000);
			return FALSE;
		}


#ifdef S_ARENA_NOT_INFO
		//////////////////////////////////////////////////////////////////////////
		// 2007-06-21 by dhjin, Ʒ ̸   .
		// 		if(ARENA_STATE_NONE != this->m_ArenaInfo.State)
		// 		{
		// 			return FALSE;
		// 		}
#else
		if(ARENA_STATE_NONE != this->m_ArenaInfo.State)
		{
			return FALSE;
		}
#endif




		if(FALSE == IS_MAP_INFLUENCE_ARENA(m_pCurrentFieldMapChannel->GetMapInfluenceTypeW()))
		{// 2007-06-18 by dhjin, Ʒ ʿ 
			return FALSE;
		}
		
		//////////////////////////////////////////////////////////////////////////
		// 2007-06-18 by dhjin,  غ
		this->WatchReady();
		
		return TRUE;
	}
	else if(0 == stricmp(token, STRMSG_CS_COMMAND_WATCH_END_INFO_0)
		|| 0 == stricmp(token, STRMSG_CS_COMMAND_WATCH_END_INFO_1))
	{// 2007-06-15 by dhjin, format: / -  Ѵ.

		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// /ڸ  
			return FALSE;
		}

		if(FALSE == this->IsInvisibleCharacter())
		{// 2007-06-15 by dhjin, ¿ 
			SendString128(STRING_128_ADMIN_CMD, STRMSG_070615_0000);
			return FALSE;
		}

		if(FALSE == IS_MAP_INFLUENCE_ARENA(m_pCurrentFieldMapChannel->GetMapInfluenceTypeW()))
		{// 2007-06-18 by dhjin, Ʒ ʿ 
			return FALSE;
		}

		//////////////////////////////////////////////////////////////////////////
		// 2007-06-18 by dhjin,  
		this->WatchEnd();

		return TRUE;
	}	
	else if(0 == stricmp(token, STRMSG_CS_COMMAND_WARPOINT_0)
		|| 0 == stricmp(token, STRMSG_CS_COMMAND_WARPOINT_1))
	{// 2007-06-22 by dhjin, format: /Ʈ [ 1~1000000] [̸] - Ʈ ߰Ѵ.

		if ( !CheckCommandExecutability(RACE_OPERATION) )
		{// 2007-11-08 by cmkwon, GM ɾ  - '/Ʈ'   Ұ, // /ڸ  
			return FALSE;
		}
		
		token = strtok(NULL, seps);
		if (token == NULL)
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_CS_COMMAND_WARPOINT_HELP);
			return TRUE;
		}
		
		int	count = atoi(token);
		if(0 >= count 
			|| 1000000 <= count)
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_CS_COMMAND_WARPOINT_HELP);
			return TRUE;
		}

		CFieldIOCPSocket *pFISoc = this;
		token = strtok(NULL, seps);
		if (token != NULL)
		{
			pFISoc = this->ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if (NULL == pFISoc
				|| FALSE == pFISoc->IsValidCharacter())
			{
				SendString128(STRING_128_ADMIN_CMD, "%s NOT PLAYING", token);
				return TRUE;
			}
		}
		
		pFISoc->m_character.WarPoint += count;
		pFISoc->m_character.CumulativeWarPoint += count;
		
		// start 2012-01-16 by hskim,  - ȭ
		//    
		//if( NULL != this->ms_pFieldIOCP->m_pStatisticsManager )
		//{
		//	this->ms_pFieldIOCP->m_pStatisticsManager->Add(STATISTICS_WAR_POINT, count);
		//}
		// end 2012-01-16 by hskim,  - ȭ

		// 2009-01-22 by cmkwon,    α  - CAtumLogSender::SendLogMessageGetWarPoint() (, BYTE i_byWPUpdateTy) ߰
		CAtumLogSender::SendLogMessageGetWarPoint(pFISoc, count, pFISoc->m_character.WarPoint, pFISoc->m_character.CumulativeWarPoint, WPUT_ADMIN_COMMAND);
		// 2007-05-16 by dhjin, DB Ʈ
		QPARAM_UPDATE_WARPOINT *pQparam = new QPARAM_UPDATE_WARPOINT;
		pQparam->CharacterUID		= pFISoc->m_character.CharacterUniqueNumber;
		pQparam->AccountUID			= pFISoc->m_character.AccountUniqueNumber;
		pQparam->TotalWarPoint		= pFISoc->m_character.WarPoint;
		pQparam->CumulativeWarPoint	= pFISoc->m_character.CumulativeWarPoint;
		this->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateWarPoint, pFISoc, pFISoc->m_character.AccountUniqueNumber, pQparam);

		// 2007-05-16 by dhjin, Ŭ̾Ʈ 
		INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_PAY_WARPOINT, T_FC_CHARACTER_PAY_WARPOINT, pMsg, SendBuf);
		pMsg->WarPoint				= count;
		pMsg->TotalWarPoint			= pFISoc->m_character.WarPoint;
		pMsg->CumulativeWarPoint	= pFISoc->m_character.CumulativeWarPoint;
		pMsg->UseItemFlag			= FALSE;		// 2010-08-27 by shcho&&jskim, WARPOINT    -   
		pMsg->ShowSystemMessage		= TRUE;
		pFISoc->SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_PAY_WARPOINT));

		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_ARENAFORBID_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ARENAFORBID_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ARENAFORBID_2))
	{// 2007-07-11 by cmkwon, Ʒ ý  - Ʒ ɾ ߰
		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// /ڸ  
			return FALSE;
		}

		// 2008-02-21 by dhjin, Ʒ  - Ʒ   Ұ
		if(g_pFieldGlobal->IsArenaServer())
		{
			return FALSE;
		}	
		
		// "format: /Ʒ [character name] [ð()] - Arena  Ŵ"
		token = strtok(NULL, seps);
		if (NULL == token)
		{// CharacterName  
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_ARENAFORBID_HELP);
			return TRUE;
		}

		char szCharName[SIZE_MAX_CHARACTER_NAME];
		STRNCPY_MEMSET(szCharName, token, SIZE_MAX_CHARACTER_NAME);

		token = strtok(NULL, seps);
		if(NULL == token)
		{// ĳ Ʒ  Ѵ
			
			int nRemainMinute = 0;
			if(FALSE == ms_pFieldIOCP->m_arenaBlockManager.IsExistChatBlockList(&nRemainMinute, szCharName))
			{
				this->SendString128(STRING_128_USER_NOTICE, STRMSG_070711_0000, szCharName);
			}
			else
			{
				this->SendString128(STRING_128_USER_NOTICE, STRMSG_070711_0001, szCharName, nRemainMinute);
			}
			return TRUE;
		}

		int  nMinutes = max(1, atoi(token));
		CFieldIOCPSocket *pFISock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(szCharName);
		if(pFISock
			&& pFISock->IsValidCharacter(FALSE))
		{
			pFISock->SendString128(STRING_128_USER_NOTICE, STRMSG_070711_0002, nMinutes);
		}
		SendString128(STRING_128_USER_NOTICE, STRMSG_070711_0001, szCharName, nMinutes);
		ms_pFieldIOCP->m_arenaBlockManager.InsertChatBlockList(szCharName, nMinutes);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_ARENAFORBIDRelease_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ARENAFORBIDRelease_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ARENAFORBIDRelease_2))
	{// 2007-07-11 by cmkwon, Ʒ ý  - Ʒ ɾ ߰
		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// /ڸ  
			return FALSE;
		}

		// 2008-02-21 by dhjin, Ʒ  - Ʒ   Ұ
		if(g_pFieldGlobal->IsArenaServer())
		{
			return FALSE;
		}
		
		// "format: /Ʒ [character name] - Arena   Ŵ"
		token = strtok(NULL, seps);
		if (NULL == token)
		{// CharacterName  
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_ARENAFORBIDRelease_HELP);
			return TRUE;
		}

		CFieldIOCPSocket *pFISock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
		if(pFISock
			&& pFISock->IsValidCharacter(FALSE))
		{
			pFISock->SendString128(STRING_128_USER_NOTICE, STRMSG_070711_0003);
		}

		SendString128(STRING_128_USER_NOTICE, STRMSG_070711_0004, token);
		ms_pFieldIOCP->m_arenaBlockManager.DeleteChatBlockList(token);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_UsableSpeakerItem_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_UsableSpeakerItem_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_UsableSpeakerItem_2))
	{// 2007-08-24 by cmkwon, Ŀ  /   ߰ - ɾ ó
		if (FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{// /ڸ  
			return FALSE;
		}
		
		// "format: /Ŀ [|] - Ŀ  / Ŵ"
		token = strtok(NULL, seps);
		if (NULL == token)
		{// ù° ڰ 
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_UsableSpeakerItem_HELP);
			return TRUE;
		}

		BOOL	bUnusableFlag	= FALSE;
		if(0 == stricmp(token, STRCMD_CS_COMMAND_UsableSpeakerItem_P1Able))
		{
			bUnusableFlag		= FALSE;		//  
		}
		else if(0 == stricmp(token, STRCMD_CS_COMMAND_UsableSpeakerItem_P1Forbid))
		{
			bUnusableFlag		= TRUE;			//  Ұ
		}
		else
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_UsableSpeakerItem_HELP);
			return TRUE;
		}

		ms_pFieldIOCP->SetUnusableSpeakerItem(bUnusableFlag);		
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_EntrancePermission_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_EntrancePermission_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_EntrancePermission_2))
	{// 2007-08-30 by cmkwon, ȸǷ ý  - ɾ ߰
		
		if (FALSE == COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER))
		{// ڸ  

			if(FALSE == CheckCommandExecutability(RACE_OPERATION))
			{// ڴ 
				return FALSE;
			}

			if(COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
			{// Ϲݼ Ұ
				SendString128(STRING_128_ADMIN_CMD, STRMSG_070830_0001);
				return FALSE;
			}
		}
		int					nConferenceRoomMapIndex = CFieldMapProject::GetConferenceRoomMapIndex(m_character.InfluenceType);
		CFieldMapProject	*pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(nConferenceRoomMapIndex);
		if(NULL == pFMPro)
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_070830_0002, nConferenceRoomMapIndex);
			return FALSE;
		}
		
		// "format: /[㰡] [|CharacterName] - ڸ  , ش ĳ͸ ȸǷ  㰡 Ʈ ߰ Ѵ."
		token = strtok(NULL, seps);
		if (NULL == token)
		{// CharacterName  
			
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_EntrancePermission_HELP);
			pFMPro->SendWarpableUserList(this);
			return TRUE;
		}

		S_S1_CHARACTER_INFO s1CharInfo;		MEMSET_ZERO(&s1CharInfo, sizeof(s1CharInfo));
		if(pFMPro->FindInWarpableUserListByCharacterName(&s1CharInfo, token))
		{
			SendString128(STRING_128_ADMIN_CMD, STRMSG_070830_0004, token);
			return TRUE;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2007-08-30 by cmkwon, ȸǷ ý  - ߰ 
		QPARAM_Insert2WarpableUserList *pQParam	= new QPARAM_Insert2WarpableUserList;
		pQParam->MapIndex				= nConferenceRoomMapIndex;
		pQParam->byInfluenceType0		= m_character.InfluenceType;
		STRNCPY_MEMSET(pQParam->CharacterName0, token, SIZE_MAX_CHARACTER_NAME);
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_Insert2WarpableUserList, this, m_character.AccountUniqueNumber, pQParam);

		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_EntrancePermissionDeny_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_EntrancePermissionDeny_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_EntrancePermissionDeny_2))
	{// 2007-08-30 by cmkwon, ȸǷ ý  - ɾ ߰
	
		if (FALSE == COMPARE_RACE(m_character.Race, RACE_INFLUENCE_LEADER))
		{// ڸ  

			if(FALSE == CheckCommandExecutability(RACE_OPERATION))
			{// ڴ 
				return FALSE;
			}

			if(COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
			{// Ϲݼ Ұ
				SendString128(STRING_128_ADMIN_CMD, STRMSG_070830_0001);
				return FALSE;
			}
		}
		int					nConferenceRoomMapIndex = CFieldMapProject::GetConferenceRoomMapIndex(m_character.InfluenceType);
		CFieldMapProject	*pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(nConferenceRoomMapIndex);
		if(NULL == pFMPro)
		{
			SendString128(STRING_128_USER_NOTICE, STRMSG_070830_0002, nConferenceRoomMapIndex);
			return FALSE;
		}

		// "format: /[Ұ] [|CharacterName] - ڸ  , ش ĳ͸ ȸǷ  㰡 Ʈ  Ѵ."
		token = strtok(NULL, seps);
		if (NULL == token)
		{// CharacterName  
			SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_EntrancePermissionDeny_HELP);
			return TRUE;
		}

		S_S1_CHARACTER_INFO s1CharInfo;		MEMSET_ZERO(&s1CharInfo, sizeof(s1CharInfo));
		if(FALSE == pFMPro->PopInWarpableUserListByCharacterName(&s1CharInfo, token))
		{
			SendString128(STRING_128_USER_NOTICE, STRMSG_070830_0005, token);
			return TRUE;
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2007-08-31 by cmkwon
		CFieldIOCPSocket *pTargetFISoc = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(s1CharInfo.CharacterUID1);
		if(pTargetFISoc
			&& pTargetFISoc->IsValidCharacter(FALSE))
		{
			pTargetFISoc->SendString128(STRING_128_USER_NOTICE, STRMSG_070830_0010);

			if(IS_CONFERENCEROOM_MAP_INDEX(pTargetFISoc->GetCharacter()->MapChannelIndex.MapIndex))
			{//  ȸǷʿ 
				CFieldMapProject *pCityFMPro = this->GetCityFieldMapProjectPtr();
				if(pCityFMPro
					&& ERR_NO_ERROR == pTargetFISoc->IsEnableWarp(pCityFMPro->GetMapInfluenceType(), FALSE))
				{
					pTargetFISoc->WarpToCityMap();
				}
			}
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2007-08-30 by cmkwon, ȸǷ ý  -   
		QPARAM_DeleteWarpableUser *pQParam	= new QPARAM_DeleteWarpableUser;
		pQParam->MapIndex				= nConferenceRoomMapIndex;
		pQParam->CharacterUID0			= s1CharInfo.CharacterUID1;
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_DeleteWarpableUser, this, m_character.AccountUniqueNumber, pQParam);
		
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_WAPPOINTINMAP_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_WAPPOINTINMAP_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_WAPPOINTINMAP_2))
	{// 2007-11-05 by cmkwon, WP  ɾ  - ɾ ó 

		if(FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2007-11-05 by cmkwon, WP  ɾ  - ڸ ϵ 
			return TRUE;
		}

		// 2008-02-21 by dhjin, Ʒ  - Ʒ   Ұ
		if(g_pFieldGlobal->IsArenaServer())
		{
			return FALSE;
		}

		// "format: /AddWarPointInMap [1(Normal)|2(VCN)|4(ANI)|3|5|6|7] [AddWarPoint(1~)] -     WarPoint Ѵ."
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_WAPPOINTINMAP_HELP);
			return FALSE;
		}

		BYTE byInflTyMask = (BYTE)atoi(token);
		if(FALSE == COMPARE_INFLUENCE(byInflTyMask, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid IfluenceTypeMask !!");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_WAPPOINTINMAP_HELP);
			return FALSE;
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, "WarPoint error !!");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_WAPPOINTINMAP_HELP);
			return FALSE;
		}

		int nAddWarPoint = atoi(token);
		if(0 >= nAddWarPoint)
		{
			this->SendString128(STRING_128_USER_NOTICE, "WarPoint error !!");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_WAPPOINTINMAP_HELP);
			return FALSE;			
		}
		
		// 2007-11-05 by cmkwon, WP  ɾ  -  ش  鿡 WarPoint Ѵ.
		GetCurrentFieldMapChannel()->AddWarPointInMap(nAddWarPoint, FALSE, byInflTyMask, WPUT_ADMIN_COMMAND);	// 2009-01-22 by cmkwon,    α  - CFieldMapChannel::AddWarPointInMap() (, BYTE i_byWPUpdateTy=WPUT_GENERAL) ߰
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_2))
	{// 2008-01-31 by cmkwon,  / ɾ  ý  - 

		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2008-01-31 by cmkwon, /  
			return TRUE;
		}

		// "format: /Block [AccountName] [BlockType(1:Normal|2:Related Money|3:Related Item|4:Related SpeedHack|5:Related Chatting|6:Related GameBug)] [Period:Days] [Block Reason for User] / [Block Reason for only Admin]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_HELP);
			return FALSE;
		}

		SBLOCKED_ACCOUNT_INFO blockedAccInfo;
		MEMSET_ZERO(&blockedAccInfo, sizeof(SBLOCKED_ACCOUNT_INFO));

		blockedAccInfo.AdminFieldServerClientIndex	= GetCharacter()->ClientIndex;
		STRNCPY_MEMSET(blockedAccInfo.szBlockAdminAccountName, m_character.AccountName, SIZE_MAX_ACCOUNT_NAME);		// 2008-01-31 by cmkwon,  AccountName

#if defined _DEFINED_GAMEFORGE4D_
		// Start 2012-01-03 by shcho,  ɵ ҹڷ Ѵ. -   , ҹ  ӽÿ  ȵǴ  ó
		_strlwr(token);
		// End 2012-01-03 by shcho,  ɵ ҹڷ Ѵ. -   , ҹ  ӽÿ  ȵǴ  ó
		STRNCPY_MEMSET(blockedAccInfo.szBlockedAccountName, token, SIZE_MAX_ACCOUNT_NAME);							// 2008-01-31 by cmkwon, ų  AccountName		
#else
		// 2008-01-31 by cmkwon, [AccountName]
		STRNCPY_MEMSET(blockedAccInfo.szBlockedAccountName, token, SIZE_MAX_ACCOUNT_NAME);							// 2008-01-31 by cmkwon, ų  AccountName
#endif


		// 2008-01-31 by cmkwon, [BlockType(1:Normal|2:Related Money|3:Related Item|4:Related SpeedHack|5:Related Chatting|6:Related GameBug)]
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_HELP);
			return FALSE;
		}
		blockedAccInfo.enBlockedType = (EN_BLOCKED_TYPE)atoi(token);
		if(FALSE == IS_IN_RANGE(T_BLOCKEDACCOUNT_NORMAL, blockedAccInfo.enBlockedType, T_BLOCKEDACCOUNT_CHAT_GAMEBUG))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid BlockType !!");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_HELP);
			return FALSE;
		}

		// 2008-01-31 by cmkwon, [Period:Days]
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_HELP);
			return FALSE;
		}
		int nPeriodOfDay = atoi(token);
		if(0 >= nPeriodOfDay)
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid Period !!");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_HELP);
			return FALSE;
		}
		blockedAccInfo.atimeStartTime.SetCurrentDateTime();
		blockedAccInfo.atimeEndTime	= blockedAccInfo.atimeStartTime;
		blockedAccInfo.atimeEndTime.AddDateTime(0, 0, nPeriodOfDay);

		// 2008-01-31 by cmkwon, [Block Reason for User] /
		token = strtok(NULL, "/");
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_HELP);
			return FALSE;
		}
		STRNCPY_MEMSET(blockedAccInfo.szBlockedReasonForUser, token, SIZE_MAX_BLOCKED_ACCOUNT_REASON);

		// 2008-01-31 by cmkwon, [Block Reason for only Admin]
		token = strtok(NULL, "/");
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_NEWACCOUNTBLOCK_HELP);
			return FALSE;
		}
		STRNCPY_MEMSET(blockedAccInfo.szBlockedReasonForOnlyAdmin, token, SIZE_MAX_BLOCKED_ACCOUNT_REASON);

		INIT_MSG_WITH_BUFFER(MSG_FP_ADMIN_BLOCKACCOUNT, T_FP_ADMIN_BLOCKACCOUNT, pBlockAcc, SendBuf);
		pBlockAcc->blockAccInfo	= blockedAccInfo;
		ms_pFieldIOCP->Send2PreServerW(SendBuf, MSG_SIZE(MSG_FP_ADMIN_BLOCKACCOUNT));		
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_NEWACCOUNTUNBLOCK_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_NEWACCOUNTUNBLOCK_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_NEWACCOUNTUNBLOCK_2))
	{// 2008-01-31 by cmkwon,  / ɾ  ý  - 

		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2008-01-31 by cmkwon, /  
			return TRUE;
		}

		// "format: /Unblock [AccountName]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_NEWACCOUNTUNBLOCK_HELP);
			return FALSE;
		}

		SBLOCKED_ACCOUNT_INFO blockedAccInfo;
		MEMSET_ZERO(&blockedAccInfo, sizeof(SBLOCKED_ACCOUNT_INFO));

		blockedAccInfo.AdminFieldServerClientIndex	= GetCharacter()->ClientIndex;
		STRNCPY_MEMSET(blockedAccInfo.szBlockAdminAccountName, m_character.AccountName, SIZE_MAX_ACCOUNT_NAME);		// 2008-01-31 by cmkwon,  AccountName
		// 2008-01-31 by cmkwon, [AccountName]
		STRNCPY_MEMSET(blockedAccInfo.szBlockedAccountName, token, SIZE_MAX_ACCOUNT_NAME);							// 2008-01-31 by cmkwon, ų  AccountName
		blockedAccInfo.atimeStartTime.SetCurrentDateTime();
		blockedAccInfo.atimeEndTime	= blockedAccInfo.atimeStartTime;

		INIT_MSG_WITH_BUFFER(MSG_FP_ADMIN_UNBLOCKACCOUNT, T_FP_ADMIN_UNBLOCKACCOUNT, pUnblockAcc, SendBuf);
		pUnblockAcc->blockAccInfo	= blockedAccInfo;
		ms_pFieldIOCP->Send2PreServerW(SendBuf, MSG_SIZE(MSG_FP_ADMIN_UNBLOCKACCOUNT));		
		return TRUE;
	}
	
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_USERCOUNT))
	{

		int aniCount = 0;
		int bcuCount = 0;
		
		ms_pFieldIOCP->GetUserCountByInfluence(aniCount,bcuCount);

		SendString128(STRING_128_USER_NOTICE, "\\y*************************\\y");
		SendString128(STRING_128_USER_NOTICE, "Online Usercount");
		SendString128(STRING_128_USER_NOTICE, "\\eBCU\\e: \\g%d\\g",bcuCount);
		SendString128(STRING_128_USER_NOTICE, "\\cANI\\c: \\g%d\\g",aniCount);
		SendString128(STRING_128_USER_NOTICE, "\\y**************************\\y");
		return true;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_ITEMALLUSER_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMALLUSER_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ITEMALLUSER_2))
	{// 2008-02-20 by cmkwon, ɾ ߰(   ο   - 

		if(FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2008-01-31 by cmkwon, ڸ  
			return TRUE;
		}

		// "format: /ItemAllUser [1(Normal)|2(VCN)|4(ANI)|255(All)] [Item Number] [# of items] -  ߿      Ѵ"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMALLUSER_HELP);
			return FALSE;
		}

		BYTE byInflTyMask = (BYTE)atoi(token);
		if(FALSE == COMPARE_INFLUENCE(byInflTyMask, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid IfluenceTypeMask");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMALLUSER_HELP);
			return FALSE;
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, "ItemNum error");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMALLUSER_HELP);
			return FALSE;
		}

		int nInsertItemNum = atoi(token);
		if(NULL == ms_pFieldIOCP->GetItemInfo(nInsertItemNum))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ItemNum");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMALLUSER_HELP);
			return FALSE;			
		}

		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, "ItemCount error");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMALLUSER_HELP);
			return FALSE;
		}

		int nInsertItemCnts = atoi(token);
		if(0 >= nInsertItemCnts)
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ItemCount");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ITEMALLUSER_HELP);
			return FALSE;
		}
		
		ms_pFieldIOCP->InsertItemAllCharacter(nInsertItemNum, nInsertItemCnts, byInflTyMask);
		return TRUE;
	}
	//////////////////////////////////////////////////////////////////////////
	// 2008-03-10 by dhjin, Ʒ  - ɾ ߰
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_TEAMARENALEAVE_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_TEAMARENALEAVE_1))
	{
		if(FALSE == g_pFieldGlobal->IsArenaServer())
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ArenaServer");
			return FALSE;
		}

		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2008-03-10 by dhjin, ,    
			return TRUE;
		}

		// "format: /ArenaLeave [2(BLUE)|4(RED)|6(BLUE AND RED)]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_TEAMARENALEAVE_HELP);
			return FALSE;
		}
		
		BYTE byInflTyMask = (BYTE)atoi(token);
		if(FALSE == COMPARE_INFLUENCE(byInflTyMask, INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid IfluenceTypeMask");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_TEAMARENALEAVE_HELP);
			return FALSE;
		}		
	
		GetCurrentFieldMapChannel()->TeamArenaLeaveCommand(byInflTyMask);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_TARGETARENALEAVE_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_TARGETARENALEAVE_1))
	{
		if(FALSE == g_pFieldGlobal->IsArenaServer())
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ArenaServer");
			return FALSE;
		}

		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2008-03-10 by dhjin, ,    
			return TRUE;
		}

		// "format: /TargetArenaLeave [Charactername]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_TEAMARENALEAVE_HELP);
			return FALSE;
		}
		
		CFieldIOCPSocket *pFISock = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
		if(NULL == pFISock
			|| FALSE == pFISock->IsValidCharacter(FALSE))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid CharacterName");
			return FALSE;			
		}		

		pFISock->SendAddMessageType(T_FC_ARENA_USE_CITYWARPITEM);

		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_ARENAEVENT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ARENAEVENT_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ARENAEVENT_2))
	{ 
		if(FALSE == g_pFieldGlobal->IsArenaServer())
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ArenaServer");
			return FALSE;
		}
			
		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2008-03-10 by dhjin, ,    
			return TRUE;
		}

		// "format: /ArenaEvent [RoomNumber]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ARENAEVENT_HELP);
			return FALSE;
		}
		
		int Roomnum = atoi(token);
		if(!ms_pFieldIOCP->m_ArenaManager.SetTeamEventW(Roomnum,TRUE))
		{
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_ARENAEVENT_080310_0003);
			return FALSE;			
		}
		
		this->SendString128(STRING_128_USER_NOTICE, STRMSG_ARENAEVENT_080310_0001, Roomnum);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_ARENAEVENTRELEASE_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ARENAEVENTRELEASE_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ARENAEVENTRELEASE_2))
	{ 
		if(FALSE == g_pFieldGlobal->IsArenaServer())
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid ArenaServer");
			return FALSE;
		}
			
		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2008-03-10 by dhjin, ,    
			return TRUE;
		}

		// "format: /ArenaEvent [RoomNumber]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ARENAEVENTRELEASE_HELP);
			return FALSE;
		}
		
		int Roomnum = atoi(token);
		if(!ms_pFieldIOCP->m_ArenaManager.SetTeamEventW(Roomnum,FALSE))
		{
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_ARENAEVENT_080310_0003);
			return FALSE;			
		}
		
		this->SendString128(STRING_128_USER_NOTICE, STRMSG_ARENAEVENT_080310_0002, Roomnum);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_INFLUENCEMARKEVENT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_INFLUENCEMARKEVENT_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_INFLUENCEMARKEVENT_2))
	{// 2008-08-18 by dhjin, ¸ũ̺Ʈ
		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2008-03-10 by dhjin, ,    
			return TRUE;
		}

		// "format: /influencemarkevent [ 2(BCU)|4(ANI)]"
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_INFLUENCEMARKEVENT_HELP);
			return FALSE;
		}
		
		BYTE byInflTyMask = (BYTE)atoi(token);
		if(FALSE == COMPARE_INFLUENCE(byInflTyMask, INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Invalid IfluenceTypeMask");
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_INFLUENCEMARKEVENT_HELP);
			return FALSE;
		}	

		INIT_MSG_WITH_BUFFER(MSG_FC_EVENT_INFLUENCEMARK, T_FC_EVENT_INFLUENCEMARK, pSendMSG, SendBuf);
		pSendMSG->Influence	= byInflTyMask;
		this->ms_pFieldIOCP->SendMessageToAllClients(SendBuf, MSG_SIZE(MSG_FC_EVENT_INFLUENCEMARK), INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI);
		
		return TRUE;		
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_INFLUENCEMARKEVENTEND_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_INFLUENCEMARKEVENTEND_1)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_INFLUENCEMARKEVENTEND_2))
	{// 2008-08-18 by dhjin, ¸ũ̺Ʈ 
		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// 2008-03-10 by dhjin, ,    
			return TRUE;
		}
		
		MessageType_t msgTy = T_FC_EVENT_INFLUENCEMARKEND;
		this->ms_pFieldIOCP->SendMessageToAllClients((BYTE*)&msgTy, SIZE_FIELD_TYPE_HEADER, INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI);
		
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_PCBANGRELOADTIME_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_PCBANGRELOADTIME_1))
	{// 2008-08-25 by dhjin, ± PC IP ε 
		if(FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2008-08-25 by dhjin,    
			return TRUE;
		}
		
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_PCBANGRELOADTIME_HELP);
			return FALSE;
		}
		
		int PCBangMinTick = atoi(token);		

		if(MinPCBangMinTick > PCBangMinTick
			|| MaxPCBangMinTick < PCBangMinTick)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_PCBANGRELOADTIME_HELP);
			return FALSE;
		}

		this->ms_pFieldIOCP->m_nMaxPCBangMinTick = PCBangMinTick;
				
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_KICK_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_KICK_1))
	{// 2008-09-09 by cmkwon, "/kick" ɾ ߰ - 
		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER|RACE_MONITOR, TRUE))
		{// 2008-09-09 by cmkwon, , , , AdminTool
			return TRUE;
		}
		
		// "format: /Kick [CharacterName] - ش ĳ͸ ӿ  Ų."
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_KICK_HELP);
			return FALSE;
		}
		
		CFieldIOCPSocket *pTargetFISoc = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
		if(NULL == pTargetFISoc
			|| FALSE == pTargetFISoc->IsValidCharacter(FALSE))
		{
			this->SendString128(STRING_128_USER_NOTICE, "Character(%s) is offline or invalid CharacterName !!", token);
			return FALSE;
		}
		
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Notify] kicked %s by %s \r\n", GetCharacterString(pTargetFISoc->GetCharacter(), string()), GetCharacterString(this->GetCharacter(), string()));
		pTargetFISoc->Close(0x14070);
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_ADD_FAME_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_ADD_FAME_1))
	{// 2008-09-12 by cmkwon, "/" ɾ ߰ - 
		if(FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2008-09-09 by cmkwon, 
			return TRUE;
		}
		
		// "format: / [θ] [ܸ] -  ĳ , ĳ   ÷ش."
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ADD_FAME_HELP);
			return FALSE;
		}
		
		int nAddCharacFame = atoi(token);
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_ADD_FAME_HELP);
			return FALSE;
		}
		int nAddGuildFame = atoi(token);

		this->AddCharacterFame(nAddCharacFame, nAddGuildFame);		// 2008-09-12 by cmkwon, "/" ɾ ߰ - 
		return TRUE;
	}
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_CHANGE_StartCityMapIndex_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_CHANGE_StartCityMapIndex_1))
	{// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::HandleAdminCommands#, ɾ ó ߰
		if(FALSE == CheckCommandExecutability(RACE_OPERATION))
		{// 2009-10-15 by cmkwon, ڸ  
			return FALSE;
		}
		
		// "format: /۵ø [2001|2002] [|CharacterName] - ش ĳ Ϲݼ½ ۵ø ش  Ѵ."
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_CHANGE_StartCityMapIndex_HELP);
			return FALSE;
		}
		
		int nStartCityMapIdx = atoi(token);
		if(FALSE == IS_VCN_CITY_MAP_INDEX(nStartCityMapIdx)
			&& FALSE == IS_ANI_CITY_MAP_INDEX(nStartCityMapIdx))
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_CHANGE_StartCityMapIndex_HELP);
			return FALSE;
		}

		CFieldIOCPSocket *pTargetFISoc = this;
		token = strtok(NULL, seps);
		if(NULL != token)
		{
			pTargetFISoc = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterName(token);
			if(NULL == pTargetFISoc
				|| FALSE == pTargetFISoc->IsValidCharacter(FALSE))
			{
				this->SendString128(STRING_128_USER_NOTICE, "Character(%s) is offline or invalid CharacterName !!", token);
				return FALSE;
			}
		}
		pTargetFISoc->m_character.Material	= nStartCityMapIdx;		
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangeStartCityMapIndex, NULL, m_character.AccountUniqueNumber, NULL, NULL, pTargetFISoc->GetCharacter()->CharacterUniqueNumber, nStartCityMapIdx);
		return TRUE;
	}
	// 2010. 06. 04 by hsLee ƼǴ ʵ 2 ̵ . (GM ɾ ߰. /nextscene( ó׸  ȣ.) )
	else if ( 0 == stricmp ( token , STRCMD_CS_COMMAND_INFINITY_NEXT_SCENE ) )
	{
		if ( FALSE == g_pFieldGlobal->IsArenaServer() )
			return FALSE;

		int nUpdateSceneCount = 0;

		token = strtok(NULL, seps);

		if(NULL != token)
			nUpdateSceneCount = atoi(token);
		
		ms_pFieldIOCP->m_InfinityManager.UpdateNextSceneProc ( this->m_InfinityPlayingInfo.ModeTypeNum , this->m_InfinityPlayingInfo.InfinityCreateUID , this , nUpdateSceneCount );
		
		return TRUE;
	}
	// End 2010. 06. 04 by hsLee ƼǴ ʵ 2 ̵ . (GM ɾ ߰. /nextscene( ó׸  ȣ.) )

	////////////////////////////////////////////////////////////////
	// 2011-06-22 by hskim ߰Ǵ ɾ ٰ ߰ϼ!!
	// ....	  Ʒ ٰ 

	// start 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_RESETTRIGGER)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_RESETTRIGGER_1))
	{
		int iFunctionID = 0;
		if( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{
			// ڿ, Ϲ ڴ 
			return FALSE;
		}

		// "format: /Ʈ [ƮŹȣ] - ǰ ִ ƮŸ Ű ʱȭ Ѵ."
		token = strtok(NULL, seps);
		if(NULL != token)
		{
			int iFunctionID = atoi(token);
			token = strtok(NULL, seps);
		}

		CFieldMapChannel *pFMChann = GetCurrentFieldMapChannel();

		if( NULL == pFMChann )
		{
			return FALSE;
		}

		if( 0 == iFunctionID )
		{
			ms_pFieldIOCP->m_pMapTriggerManager->SkipEventByMapChannelIndex(pFMChann->GetMapChannelIndex());
		}
		else
		{
			ms_pFieldIOCP->m_pMapTriggerManager->SkipEventByTriggerID(iFunctionID);
		}
		
		return TRUE;
	}
	// end 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý

	// start 2012-02-13 by hskim,    ׽Ʈ ɾ
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_TEST_MONSTER_DROPITEM)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_TEST_MONSTER_DROPITEM_1))
	{
		int MonsterIndex = 0;
		int TestCount = 10000;		// ⺻ ׽Ʈ  
		if( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{
			// ڿ, Ϲ ڴ 
			return FALSE;
		}

		// "format: /׽Ʈ͵ [monster number] [test numbers] -  ɽ Ǵ  ùķ̼ؼ ش."
		token = strtok(NULL, seps);
		if(NULL == token)
		{
			this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_TEST_MONSTER_DROPITEM_HELP);
			return FALSE;
		}

		MonsterIndex = atoi(token);

		token = strtok(NULL, seps);
		if(NULL != token)
		{
			TestCount = atoi(token);

			if( TestCount <= 0 )
			{
				return FALSE;
			}

			if( TestCount > 100000 )
			{
				return FALSE;
			}
		}

		return TestMonsterDropItems(MonsterIndex, TestCount);
	}
	// end 2012-02-13 by hskim,    ׽Ʈ ɾ

	// ...
	////////////////////////////////////////////////////////////////

	// start 2011-06-22 by hskim, 缳  
	else if ( 0 == stricmp ( token , STRCMD_CS_COMMAND_SERVERINFO ) )
	{
		this->SendString128(STRING_128_USER_NOTICE, "[%s %s] [%d]", __DATE__, __TIME__, g_pFieldGlobal->GetLanguageType());

		return TRUE;
	}
	// 2012-09-24 by jhseol, Ʒ  ɾ 
	else if( 0 == stricmp( token , STRCMD_CS_COMMAND_ENDARENA ) )
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER|RACE_DEMO|RACE_MONITOR) )
		{// 2008-09-09 by cmkwon,      ߰ - STRCMD_CS_COMMAND_MOVE, // 2006-04-13 by cmkwon, //DEMO  
			return FALSE;
		}
		
		if(TRUE == g_pFieldGlobal->IsArenaServer()) 
		{
			if( ARENA_STATE_FIGHTING_WARING == m_ArenaInfo.State )
			{
				CArenaDeathMatchRoom * tmArenaDMRoom = ms_pFieldIOCP->m_ArenaManager.GetArenaDeathMatchRoom(m_ArenaInfo.DeathMatchRoomNum);
				if( NULL != tmArenaDMRoom )
				{
					tmArenaDMRoom->ArenaFinish();
					SendString128(STRING_128_USER_NOTICE, "The command is complete. 'endarena'");
					return TRUE;
				}
			}
		}
		return FALSE;
	}
	// end 2012-09-24 by jhseol, Ʒ  ɾ 
	// 2012-11-29 by jhseol, OX̺Ʈ   - ɾ ߰
	else if(0 == stricmp(token, STRCMD_CS_COMMAND_MAP_WARP_RESTRICT_0)
		|| 0 == stricmp(token, STRCMD_CS_COMMAND_MAP_WARP_RESTRICT_1))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{
			return FALSE;
		}

		token = strtok(NULL, seps);
		if (NULL == token)
		{
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_MAP_WARP_RESTRICT_HELP);
			return FALSE;
		}

		int MapIndex = atoi(token);

		switch( ms_pFieldIOCP->ReversalMapWarpPossible(MapIndex) )
		{
		case FALSE:
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_MAP_WARP_RESTRICT_RESULT_0, MapIndex);
			break;
		case TRUE:
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_MAP_WARP_RESTRICT_RESULT_1, MapIndex);
			break;
		default:
			SendString128(STRING_128_ADMIN_CMD, STRCMD_CS_COMMAND_MAP_WARP_ERROR, MapIndex);
			break;
		}
		return TRUE;
	}
	// end 2012-11-29 by jhseol, OX̺Ʈ   - ɾ ߰
	///////////////////////////////////////////////////////////////////////////////////////////
	// ׽Ʈ ɾ 238 Ȥ 140 ־ ϴ ɾ ⿡ ߰ Ѵ. - start
#if defined(TEST140)
	// 2013-01-21 by jhseol, NGC  Ʈ ý - ׽Ʈ  ߰
#ifdef S_TRIGGER_OUTPOST_JHSEOL	// - ׽Ʈ  ߰
	else if(0 == stricmp(token, "/"))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{
			return FALSE;
		}

		token = strtok(NULL, seps);

		CFieldMapChannel *pFMChann = GetCurrentFieldMapChannel();
		
		if( NULL == pFMChann )
		{
			return FALSE;
		}
		
		if(NULL != token)
		{
			ms_pFieldIOCP->m_pMapTriggerManager->FixedBuffItemChannelIndex(pFMChann->GetMapChannelIndex(), atoi(token));
		}
		else
		{
			ms_pFieldIOCP->m_pMapTriggerManager->FixedBuffItemChannelIndex(pFMChann->GetMapChannelIndex(), 0);
		}
		
		return TRUE;
	}
#endif
	// end 2013-01-21 by jhseol, NGC  Ʈ ý - ׽Ʈ  ߰
	// 2013-03-29 by jhseol,  ̺Ʈ - ſ ù  
#ifdef S_MONTHL_CASH_BUY_GIFT_JHSEOL
	else if(0 == stricmp(token, "/"))
	{
		if ( !CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
		{
			return FALSE;
		}
		vectItemEventInfo		vectItemEventInfo1;
		vectItemEventInfo1.clear();
		vectItemEventInfo1.reserve(20);
		ms_pFieldIOCP->m_pGiveItemManager->GetActEventItemFirstPurchase(&vectItemEventInfo1, m_ItemManager.IsExistPremiumCard(), m_bIsPCBangClient, m_character.InfluenceType, m_character.UnitKind, m_atAccountLastBuyDate, m_atCharacterLastBuyDate);
		for (int i=0; i < vectItemEventInfo1.size(); i++)
		{
			// 2013-03-29 by jhseol,  ̺Ʈ - Ÿ ߰ 
			if ( FALSE == ms_pFieldIOCP->ItemEventSubTypeCheck(m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, vectItemEventInfo1[i]) )
			{
				continue;
			}
			// end 2013-03-29 by jhseol,  ̺Ʈ - Ÿ ߰ 

			char tmpAccount[SIZE_MAX_SQL_DATETIME_STRING] = {0, };
			m_atAccountLastBuyDate.GetSQLDateTimeString(tmpAccount, SIZE_MAX_SQL_DATETIME_STRING);
			char tmpCharacter[SIZE_MAX_SQL_DATETIME_STRING] = {0, };
			m_atCharacterLastBuyDate.GetSQLDateTimeString(tmpCharacter, SIZE_MAX_SQL_DATETIME_STRING);
			char EventStartTime[SIZE_MAX_SQL_DATETIME_STRING] = {0, };
			vectItemEventInfo1[i].StartTime.GetSQLDateTimeString(EventStartTime, SIZE_MAX_SQL_DATETIME_STRING);
			char EventEndTime[SIZE_MAX_SQL_DATETIME_STRING] = {0, };
			vectItemEventInfo1[i].EndTime.GetSQLDateTimeString(EventEndTime, SIZE_MAX_SQL_DATETIME_STRING);
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[S_MONTHL_CASH_BUY_GIFT_JHSEOL][Notify] CFieldIOCPSocket::HandleAdminCommands, AUID(%8d) CUID(%8d) A_Date(%s) C_Date(%s), Event ID(%5d) Time(%s ~ %s)\r\n"
				, m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, tmpAccount, tmpCharacter, vectItemEventInfo1[i].ItemEventUID, EventStartTime, EventEndTime);
			QPARAM_CHECK_EVENTITEM *pQParam = new QPARAM_CHECK_EVENTITEM;
			pQParam->AccountUID		= m_character.AccountUniqueNumber;
			pQParam->ItemEventUID	= vectItemEventInfo1[i].ItemEventUID;
			pQParam->ItemEventType  = vectItemEventInfo1[i].ItemEventType;
			pQParam->ItemNum		= vectItemEventInfo1[i].ItemNum;
			pQParam->Count			= vectItemEventInfo1[i].Count;
			pQParam->PrefixCodeNum	= vectItemEventInfo1[i].PrefixCodeNum;
			pQParam->SuffixCodeNum	= vectItemEventInfo1[i].SuffixCodeNum;
			pQParam->CharacterUID	= (FALSE == vectItemEventInfo1[i].CheckWithCharacterUID) ? 0 : m_character.CharacterUniqueNumber;	// 2009-11-19 by cmkwon,  ̺Ʈ Account/Character üũ  ߰ - 
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_CheckEventItem, this, m_character.AccountUniqueNumber, pQParam);
		}
		m_atCharacterLastBuyDate.SetCurrentDateTime(FALSE);
		m_atAccountLastBuyDate.SetCurrentDateTime(FALSE);
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_InsertCashBuyDate, this, m_character.AccountUniqueNumber, NULL);
		return TRUE;
	}
	#endif	//#ifdef S_MONTHL_CASH_BUY_GIFT_JHSEOL 
	// end 2013-03-29 by jhseol,  ̺Ʈ - ſ ù  
#endif
	// ׽Ʈ ɾ 238 Ȥ 140 ־ ϴ ɾ ⿡ ߰ Ѵ. - end
	///////////////////////////////////////////////////////////////////////////////////////////
	else
	{
		if( TRUE == ms_pFieldIOCP->m_pSecurityManager->ExecCommand(token) ) 
		{
			return TRUE;
		}

		if( TRUE == ms_pFieldIOCP->m_pSecurityManager->CheckCommand(token) )		//  Ǽ  (α ȳ⵵ ó)
		{
			return TRUE;
		}
	}
	// end 2011-06-22 by hskim, 缳  
	
	// ش ɾ  
	SendErrorMessage(T_FIELD_IOCP, ERR_CHAT_INVALID_COMMAND, 0, 0, token);
	return FALSE;
}

ProcessResult CFieldIOCPSocket::Process_FM_PRINT_DEBUG_MSG(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize	= 0;
	MSG_FM_PRINT_DEBUG_MSG	*pRecvPrintDbg = NULL;

	nRecvTypeSize = sizeof(MSG_FM_PRINT_DEBUG_MSG);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FM_PRINT_DEBUG_MSG, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14056);
		return RES_RETURN_FALSE;
	}
	pRecvPrintDbg = (MSG_FM_PRINT_DEBUG_MSG*)(pPacket+nBytesUsed);
	nBytesUsed += nRecvTypeSize;

// 2008-02-14 by cmkwon, ó   ּ ó
// 	DBGOUT("=== START - DEBUG MESSAGE REQUESTED BY MONITOR SERVER ========\n");
// 	DBGOUT("  Int Param1   : %d \n", pRecvPrintDbg->IntParam1);
// 	DBGOUT("  Int Param2   : %d \n", pRecvPrintDbg->IntParam2);
// 	DBGOUT("  Float Param1 : %d \n", (int)pRecvPrintDbg->FloatParam1);
// 	DBGOUT("  Float Param2 : %d \n", (int)pRecvPrintDbg->FloatParam2);
// 	DBGOUT("  String Param : \"%s\" \n", pRecvPrintDbg->StringParam);
// 
// 	//char msg[200000];
// 	char *msg = NULL;
// 	PRINT_DEBUG_MESSAGE(msg);
// 
// 
// 	DBGOUT("=== END --- DEBUG MESSAGE REQUESTED BY MONITOR SERVER ========\n");

	return RES_RETURN_TRUE;
}

void CFieldIOCPSocket::PRINT_DEBUG_MESSAGE(char*& msg)
{
	// 2008-02-14 by cmkwon, Ʈ üũ  ӽ÷ ߰ ڵ - ش ĳ   α׷ Ѵ.
	this->m_ItemManager.DBG_PRINT_ITEM();

}

// 2008-02-14 by cmkwon,  ʴ ڵ.   ؼ 
//void CFieldIOCPSocket::PRINT_DEBUG_MESSAGE(char*& msg)
// 	return;		// 2005-01-31 by cmkwon
// 
// 	char szTime[128];
// 	time_t ltime;
// 	struct tm *today = NULL;
// 	time(&ltime);
// 	today = localtime(&ltime);
// 	strftime(szTime, 128, "[%m-%d %H:%M:%S]", today );
// 
// 	PRINT_DEBUG_MESSAGE_LOCK.lock();
// 	///////////////////////////////////////////////////////////////////////////
// 	// START - DEBUG MESSAGE
// 	///////////////////////////////////////////////////////////////////////////
// 
// 	// ڱ ڽ 
// 	SendString128(STRING_128_ADMIN_CMD, "Field - AUN(%d) CUN(%d) CI(%d) MAP(%d, %d)",
// 		m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber,
// 		m_character.ClientIndex, m_character.MapChannelIndex.MapIndex,
// 		m_character.MapChannelIndex.ChannelIndex);
// 
// 
// //	// Ÿ̸ 
// //	m_listWatingTimerEvents.lock();
// //	mtlistMexTimerEvent::iterator itrTimer = m_listWatingTimerEvents.begin();
// //	while(m_listWatingTimerEvents.end() != itrTimer)
// //	{
// //		MEX_TIMER_EVENT *pTimerEvent = &(*itrTimer);
// //
// //		SendString128(STRING_128_ADMIN_CMD, "%s %d", CAtumSJ::GetTimerTypeString(pTimerEvent->Type), pTimerEvent->TimerUID);
// //
// //		itrTimer++;
// //	}
// //	m_listWatingTimerEvents.unlock();
// 
// 	// Ƽ 
// 	DBGOUT2(DO2_DBGOUT, "\n[Party Info] - %s\n", szTime);
// 
// 	// lock m_MapParties
// 	mt_auto_lock pslock(&ms_pFieldIOCP->m_MapParties);
// 	mtmapPartyID2FieldParty::iterator itr = ms_pFieldIOCP->m_MapParties.begin();
// 	while (itr != ms_pFieldIOCP->m_MapParties.end())
// 	{
// 		CFieldParty *pParty = itr->second;
// 		mt_auto_lock pmlock(&pParty->m_ListPartyMember);
// 
// 		// party master
// 		CFieldIOCPSocket *pMaster = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(pParty->GetMasterCharacterUniqueNumber());
// 
// 		if (pMaster != NULL)
// 		{
// 			DBGOUT2(DO2_DBGOUT, "PARTY Master: %s(%d, %d) - key: %d, MemberCounts: %d\n"
// 				, pMaster->m_character.CharacterName
// 				, pParty->GetMasterCharacterUniqueNumber()
// 				, pMaster->m_character.ClientIndex
// 				, HIDWORD(pParty->m_PartyID)
// 				, itr->second->m_ListPartyMember.size()
// 			);
// 		}
// 		else
// 		{
// 			DBGOUT2(DO2_DBGOUT, "PARTY Master: %s(%d, %s) - key: %d, num: %d\n"
// 				, "N/A"
// 				, pParty->GetMasterCharacterUniqueNumber()
// 				, "N/A"
// 				, HIDWORD(itr->first)
// 				, itr->second->m_ListPartyMember.size()
// 			);
// 		}
// 
// 		mtlistFieldPartyMember::iterator itr2 = pParty->m_ListPartyMember.begin();
// 		while (itr2 != pParty->m_ListPartyMember.end())
// 		{
// 			CFieldIOCPSocket *pMember = itr2->PM_CharacterSocket;
// 			if (pMember != NULL)
// 			{
// 				DBGOUT2(DO2_DBGOUT, "      Member: %10s(%6d, %4d) at %d(%d)\n"
// 					, pMember->m_character.CharacterName
// 					, pMember->m_character.CharacterUniqueNumber
// 					, pMember->m_character.ClientIndex
// 					, pMember->m_character.MapChannelIndex.MapIndex
// 					, pMember->m_character.MapChannelIndex.ChannelIndex
// 				);
// 			}
// 			else
// 			{
// 				DBGOUT2(DO2_DBGOUT, "      Member: ERROR! NULL MEMBER POINTER! CHECK IT OUT!\n");
// 			}
// 
// 			itr2++;
// 		}
// 
// 		itr++;
// 	}
// 
// 	///////////////////////////////////////////////////////////////////////////
// 	// :      , 20031103, kelovon
// 	///////////////////////////////////////////////////////////////////////////
// 	PRINT_DEBUG_MESSAGE_LOCK.unlock();
//}

ProcessResult CFieldIOCPSocket::Process_FC_MONSTER_SKILL_END_SKILL(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize;	
	MSG_FC_MONSTER_SKILL_END_SKILL	*pEndSkill;

	nRecvTypeSize = sizeof(MSG_FC_MONSTER_SKILL_END_SKILL);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_MONSTER_SKILL_END_SKILL, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14053);
		return RES_RETURN_FALSE;
	}
	pEndSkill = (MSG_FC_MONSTER_SKILL_END_SKILL*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;	

	if(m_pCurrentFieldMapChannel)
	{
		INIT_MSG_WITH_BUFFER(MSG_FN_MONSTER_SKILL_END_SKILL, T_FN_MONSTER_SKILL_END_SKILL, pSeEndSkill, SendBuf);
		pSeEndSkill->ChannelIndex	= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
		pSeEndSkill->MonsterIndex	= pEndSkill->MonsterIndex;
		pSeEndSkill->PositionVector	= pEndSkill->PositionVector;
		pSeEndSkill->TargetVector	= pEndSkill->TargetVector;
		m_pCurrentFieldMapChannel->Send2NPCServerW(SendBuf, MSG_SIZE(MSG_FN_MONSTER_SKILL_END_SKILL));
	}

	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_MONSTER_SUMMON_MONSTER(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_MONSTER_SUMMON_MONSTER
		, MSG_FC_MONSTER_SUMMON_MONSTER, pRSummonMonster);
	
	// start 2012-01-05 by hskim,  ״  
	if(FALSE == IsValidCharacter(FALSE))
	{
		return RES_BREAK;
	}
	// end 2012-01-05 by hskim,  ״  
	
	if(MONSTER_TARGETTYPE_TUTORIAL == pRSummonMonster->byMonsterTargetType2)
	{
		if(FALSE == IS_TUTORIAL_MAP_INDEX(m_character.MapChannelIndex.MapIndex))
		{
			SendErrorMessage(T_FC_MONSTER_SUMMON_MONSTER, ERR_PROTOCOL_NOT_TUTORIAL_MAP, m_character.MapChannelIndex.MapIndex);
			return RES_BREAK;
		}
	}
	else
	{
		if(FALSE == CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER))
		{// , ڸ 
			SendErrorMessage(T_FC_MONSTER_SUMMON_MONSTER, ERR_PROTOCOL_RACE_PERMISSION_DENIED);
			return RES_BREAK;
		}
	}

	D3DXVECTOR3 tmVec3Pos = A2DX(pRSummonMonster->PositionAVector);
	if(FALSE == m_pCurrentFieldMapChannel->m_pFieldMapProject->IsValidTileForCreateMonster(&tmVec3Pos))
	{
		SendErrorMessage(T_FC_MONSTER_SUMMON_MONSTER, ERR_PROTOCOL_INVALID_POSITION);
		return RES_BREAK;
	}
	ez_map<int, MONSTER_INFO>::iterator itrMon = ms_pFieldIOCP->m_mapMonsterInfo.find(pRSummonMonster->SummonMonsterUnitKind);
	if (itrMon == ms_pFieldIOCP->m_mapMonsterInfo.end())
	{
		SendErrorMessage(T_FC_MONSTER_SUMMON_MONSTER, ERR_PROTOCOL_NO_SUCH_MONSTER_INFO, pRSummonMonster->SummonMonsterUnitKind);
		return RES_BREAK;
	}

	if (m_pCurrentFieldMapChannel->m_pFieldMapProject->GetNPCServerStartFlag() == FALSE)
	{
		SendErrorMessage(T_FC_MONSTER_SUMMON_MONSTER, ERR_PROTOCOL_INVALID_SOCKET_FORNPC);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// NPC Server 
	INIT_MSG_WITH_BUFFER(MSG_FN_ADMIN_SUMMON_MONSTER, T_FN_ADMIN_SUMMON_MONSTER, pMsgSummonMonster, SendBuf);
	pMsgSummonMonster->ChannelIndex			= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
	STRNCPY_MEMSET(pMsgSummonMonster->CharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	pMsgSummonMonster->MonsterUnitKind		= pRSummonMonster->SummonMonsterUnitKind;
	pMsgSummonMonster->MonsterTargetType1	= pRSummonMonster->byMonsterTargetType2;
	pMsgSummonMonster->TargetTypeData1		= pRSummonMonster->nTargetTypeData2;
	pMsgSummonMonster->CltIdxForTargetType1	= 0;
	if(MONSTER_TARGETTYPE_TUTORIAL == pRSummonMonster->byMonsterTargetType2)
	{
		pMsgSummonMonster->CltIdxForTargetType1	= m_character.ClientIndex;
	}
	pMsgSummonMonster->NumOfMonster			= max(1, pRSummonMonster->nSummonCounts);
	pMsgSummonMonster->Position				= pRSummonMonster->PositionAVector;

	// 2010. 07. 05 by hsLee.  ȯ . (뷱   .)
	pMsgSummonMonster->MonsterBalanceData.Init(0);

	m_pCurrentFieldMapChannel->Send2NPCServerW(SendBuf, MSG_SIZE(MSG_FN_ADMIN_SUMMON_MONSTER));
	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_MONSTER_TUTORIAL_MONSTER_DELETE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_MONSTER_TUTORIAL_MONSTER_DELETE
		, MSG_FC_MONSTER_TUTORIAL_MONSTER_DELETE, pRTMonDel);
	
	if(FALSE == IS_TUTORIAL_MAP_INDEX(m_character.MapChannelIndex.MapIndex))
	{
		SendErrorMessage(T_FC_MONSTER_TUTORIAL_MONSTER_DELETE, ERR_PROTOCOL_NOT_TUTORIAL_MAP, m_character.MapChannelIndex.MapIndex);
		return RES_BREAK;
	}

	CFieldMonster *pFMon = m_pCurrentFieldMapChannel->GetFieldMonster(pRTMonDel->monsterIdx, 22);
	if(NULL == pFMon
		|| MONSTER_TARGETTYPE_TUTORIAL != pFMon->m_byMonsterTargetType)
	{
		return RES_BREAK;
	}

	m_pCurrentFieldMapChannel->OnMonsterDeadFieldMapChannel(pFMon);
	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_RACING_RACINGLIST_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
{	
	INIT_MSG_WITH_BUFFER(MSG_FC_RACING_RACINGLIST_REQUEST_ACK, T_FC_RACING_RACINGLIST_REQUEST_ACK, pSMsg, SendBuf);	
	if(FALSE == ms_pFieldIOCP->m_pRacingDemon->MakeMessageRacingDemon(T_FC_RACING_RACINGLIST_REQUEST_ACK, pSMsg))
	{
		return RES_BREAK;
	}
	
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_RACING_RACINGLIST_REQUEST_ACK)+pSMsg->byRacingListCounts*sizeof(MAP_CHANNEL_INDEX));
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_RACING_RACINGINFO_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
{
	int								nRecvTypeSize = 0;	
	MSG_FC_RACING_RACINGINFO_REQUEST	*pRMsg = NULL;

	nRecvTypeSize = sizeof(MSG_FC_RACING_RACINGINFO_REQUEST);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_RACING_RACINGINFO_REQUEST, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14053);
		return RES_RETURN_FALSE;
	}
	pRMsg = (MSG_FC_RACING_RACINGINFO_REQUEST*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;
	
	if(m_pRacingFieldMapChannel)
	{
		m_pRacingFieldMapChannel->OutRacingSystem(this);
		m_pRacingFieldMapChannel = NULL;
	}
	m_pRacingFieldMapChannel = ms_pFieldIOCP->m_pRacingDemon->FindRacingMapChannel(pRMsg->mapChannIdx);
	if(NULL == m_pRacingFieldMapChannel)
	{
		return RES_BREAK;
	}

	m_pRacingFieldMapChannel->InRacingWaitingRoom(this);

	INIT_MSG_WITH_BUFFER(MSG_FC_RACING_RACINGINFO_REQUEST_ACK, T_FC_RACING_RACINGINFO_REQUEST_ACK, pSMsg, SendBuf);
	if(FALSE == m_pRacingFieldMapChannel->MakeRacingMessage(T_FC_RACING_RACINGINFO_REQUEST_ACK, pSMsg))
	{
		return RES_BREAK;
	}
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_RACING_RACINGINFO_REQUEST_ACK));	
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_RACING_JOIN_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize = 0;	
	MSG_FC_RACING_JOIN_REQUEST	*pRMsg = NULL;

	nRecvTypeSize = sizeof(MSG_FC_RACING_JOIN_REQUEST);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_RACING_JOIN_REQUEST, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14053);
		return RES_RETURN_FALSE;
	}
	pRMsg = (MSG_FC_RACING_JOIN_REQUEST*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	if(NULL == m_pRacingFieldMapChannel
		|| m_pRacingFieldMapChannel->GetMapChannelIndex() != pRMsg->mapChannIdx)
	{
		m_pRacingFieldMapChannel = ms_pFieldIOCP->m_pRacingDemon->FindRacingMapChannel(pRMsg->mapChannIdx);
		if(NULL == m_pRacingFieldMapChannel)
		{
			return RES_BREAK;
		}
	}
	
	INIT_MSG_WITH_BUFFER(MSG_FC_RACING_JOIN_REQUEST_ACK, T_FC_RACING_JOIN_REQUEST_ACK, pSMsg, SendBuf);
	pSMsg->mapChannIdx		= m_pRacingFieldMapChannel->GetMapChannelIndex();
	pSMsg->byJoinedOrder	= m_pRacingFieldMapChannel->JoinRacing(this);
	if(0 == pSMsg->byJoinedOrder)
	{
		pSMsg->byJoinedFlag		= FALSE;
	}
	else
	{
		pSMsg->byJoinedFlag		= TRUE;
	}
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_RACING_JOIN_REQUEST_ACK));

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_RACING_CHECKPOINT_CHECK(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize = 0;	
	MSG_FC_RACING_CHECKPOINT_CHECK	*pRMsg = NULL;

	nRecvTypeSize = sizeof(MSG_FC_RACING_CHECKPOINT_CHECK);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FC_RACING_CHECKPOINT_CHECK, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14053);
		return RES_RETURN_FALSE;
	}
	pRMsg = (MSG_FC_RACING_CHECKPOINT_CHECK*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	if(NULL == m_pRacingFieldMapChannel)
	{
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_RACING_CHECKPOINT_CHECK_ACK, T_FC_RACING_CHECKPOINT_CHECK_ACK, pSMsg, SendBuf);
	pSMsg->byCheckedFlag		= FALSE;
	pSMsg->byCheckPointIndex	= pRMsg->byCheckPointIndex;	
// 2004-11-23 by cmkwon, GetEventInfoByObjectTypeAndDistanceWԼ ؾ
//	vectorObjectInfoServer::iterator it(m_pRacingFieldMapChannel->m_pFieldMapProject->m_vectorObjectInfo.begin());
//	while(it != m_pCurrentFieldMapChannel->m_pFieldMapProject->m_vectorObjectInfo.end())
//	{
//		D3DXVECTOR3	tmVec3 = A2DX(pRMsg->PositionAVector3);
//		if(it->m_EventInfo.m_bEventType == EVENT_TYPE_RACING_CHECK_POTINT
//			&& pRMsg->dwObjectType == it->m_dwObjType			
//			&& D3DXVec3Length(&(tmVec3 - it->m_vPos)) < 10.0f)
//		{
//			if(TRUE == m_pRacingFieldMapChannel->CheckPointCheck(this, pRMsg->byCheckPointIndex))
//			{
//				pSMsg->byCheckedFlag = TRUE;
//			}
//		}
//		it++;
//	}
//	pSMsg->byRanking = this->m_byRacingRanking;
//	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_RACING_CHECKPOINT_CHECK_ACK));
//
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FC_CITYWAR_GET_OCCUPYINFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	CFieldMapChannel *pFMChann = GetCurrentFieldMapChannel();
	if(NULL == pFMChann)
	{
		return RES_BREAK;
	}
	
	INIT_MSG_WITH_BUFFER(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK, T_FC_CITYWAR_GET_OCCUPYINFO_OK, pSMsg, SendBuf);
	if(FALSE == pFMChann->MakeMSG_FC_CITYWAR_GET_OCCUPYINFO_OK(pSMsg, m_character.GuildUniqueNumber))
	{
		SendErrorMessage(T_FC_CITYWAR_GET_OCCUPYINFO, ERR_CITYWAR_NO_SUCH_CITYWAR_INFO
			, pFMChann->m_MapChannelIndex.MapIndex, pFMChann->m_MapChannelIndex.ChannelIndex);
		return RES_BREAK;
	}

	SendAddData(SendBuf, MSG_SIZE(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK));
	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_CITYWAR_SET_SETTINGTIME(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_CITYWAR_SET_SETTINGTIME
		, MSG_FC_CITYWAR_SET_SETTINGTIME, pRSetWarTime);

	CFieldMapChannel *pFMChann = GetCurrentFieldMapChannel();
	if(NULL == pFMChann)
	{
		return RES_BREAK;
	}

	Err_t err = pFMChann->SetCityWarSettingTimeFieldMapChannel(&pRSetWarTime->atimeSetCityWarSettingTime, m_character.GuildUniqueNumber, m_character.CharacterUniqueNumber);
	if(ERR_NO_ERROR != err)
	{
		SendErrorMessage(T_FC_CITYWAR_SET_SETTINGTIME, err, pFMChann->m_MapChannelIndex.MapIndex);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// ͷ   
	INIT_MSG_WITH_BUFFER(MSG_FM_CITYWAR_CHANGED_OCCUPY_INFO, T_FM_CITYWAR_CHANGED_OCCUPY_INFO, pS2MOccInfo, SendBuf);
	pS2MOccInfo->MapChannelIndex.MapIndex		= pFMChann->m_pRefCityWar1->MapIndex;	
	pS2MOccInfo->MapChannelIndex.ChannelIndex	= 0;
	pS2MOccInfo->cityWarOccupyInfo				= *(pFMChann->m_pRefCityWar1->GetCITY_OCCUPY_INFO());
	ms_pFieldIOCP->SendMessageToMonitor(SendBuf, MSG_SIZE(MSG_FM_CITYWAR_CHANGED_OCCUPY_INFO));
	
	///////////////////////////////////////////////////////////////////////////////
	// 忡   
	INIT_MSG(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK, T_FC_CITYWAR_GET_OCCUPYINFO_OK, pS2COccInfo, SendBuf);
	if(FALSE == pFMChann->MakeMSG_FC_CITYWAR_GET_OCCUPYINFO_OK(pS2COccInfo, m_character.GuildUniqueNumber))
	{
		SendErrorMessage(T_FC_CITYWAR_SET_SETTINGTIME, ERR_CITYWAR_NO_SUCH_CITYWAR_INFO
			, pFMChann->m_MapChannelIndex.MapIndex, pFMChann->m_MapChannelIndex.ChannelIndex);
		return RES_BREAK;
	}
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK));
	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_CITYWAR_SET_TEX(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_CITYWAR_SET_TEX
		, MSG_FC_CITYWAR_SET_TEX, pRSetTex);

	CFieldMapChannel *pFMChann = GetCurrentFieldMapChannel();
	if(NULL == pFMChann)
	{
		return RES_BREAK;
	}

	Err_t err = pFMChann->SetCityWarTexFieldMapChannel(pRSetTex->fSetTex, m_character.GuildUniqueNumber, m_character.CharacterUniqueNumber);
	if(ERR_NO_ERROR != err)
	{
		SendErrorMessage(T_FC_CITYWAR_SET_TEX, err, pFMChann->m_MapChannelIndex.MapIndex);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 忡   
	INIT_MSG_WITH_BUFFER(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK, T_FC_CITYWAR_GET_OCCUPYINFO_OK, pS2COccInfo, SendBuf);
	if(FALSE == pFMChann->MakeMSG_FC_CITYWAR_GET_OCCUPYINFO_OK(pS2COccInfo, m_character.GuildUniqueNumber))
	{
		SendErrorMessage(T_FC_CITYWAR_SET_TEX, ERR_CITYWAR_NO_SUCH_CITYWAR_INFO
			, pFMChann->m_MapChannelIndex.MapIndex, pFMChann->m_MapChannelIndex.ChannelIndex);
		return RES_BREAK;
	}
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK));
	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_CITYWAR_SET_BRIEFING(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_CITYWAR_SET_BRIEFING
		, MSG_FC_CITYWAR_SET_BRIEFING, pRSetBriefing);

	CFieldMapChannel *pFMChann = GetCurrentFieldMapChannel();
	if(NULL == pFMChann)
	{
		return RES_BREAK;
	}

	Err_t err = pFMChann->SetCityWarBriefingFieldMapChannel(pRSetBriefing->szSetBriefing, m_character.GuildUniqueNumber, m_character.CharacterUniqueNumber);
	if(ERR_NO_ERROR != err)
	{
		SendErrorMessage(T_FC_CITYWAR_SET_BRIEFING, err, pFMChann->m_MapChannelIndex.MapIndex);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 忡   
	INIT_MSG_WITH_BUFFER(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK, T_FC_CITYWAR_GET_OCCUPYINFO_OK, pS2COccInfo, SendBuf);
	if(FALSE == pFMChann->MakeMSG_FC_CITYWAR_GET_OCCUPYINFO_OK(pS2COccInfo, m_character.GuildUniqueNumber))
	{
		SendErrorMessage(T_FC_CITYWAR_SET_BRIEFING, ERR_CITYWAR_NO_SUCH_CITYWAR_INFO
			, pFMChann->m_MapChannelIndex.MapIndex, pFMChann->m_MapChannelIndex.ChannelIndex);
		return RES_BREAK;
	}
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK));
	return RES_RETURN_TRUE;
}
ProcessResult CFieldIOCPSocket::Process_FC_CITYWAR_BRING_SUMOFTEX(const char* pPacket, int nLength, int &nBytesUsed)
{	
	CFieldMapChannel *pFMChann = GetCurrentFieldMapChannel();
	if(NULL == pFMChann)
	{
		return RES_BREAK;
	}

	int nBringTex = 0.0f;
	Err_t err = pFMChann->CityWarBringSumOfTex(&nBringTex, m_character.GuildUniqueNumber, m_character.CharacterUniqueNumber);
	if(ERR_NO_ERROR != err)
	{
		SendErrorMessage(T_FC_CITYWAR_BRING_SUMOFTEX, err, pFMChann->m_MapChannelIndex.MapIndex);
		return RES_BREAK;
	}

	if(nBringTex <= 0)
	{
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	//   ڽ ߰Ѵ
	mt_auto_lock mtA(&m_ItemManager.m_mapItemGeneral);
	m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, nBringTex, IUT_CITYWAR_BRING_SUMOFTEX);
	mtA.auto_unlock_cancel();

	///////////////////////////////////////////////////////////////////////////////
	//    
	INIT_MSG_WITH_BUFFER(MSG_FC_CITYWAR_BRING_SUMOFTEX_OK, T_FC_CITYWAR_BRING_SUMOFTEX_OK, pS2CBringOK, SendBuf);
	pS2CBringOK->nBroughtSumOfTex	= nBringTex;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_CITYWAR_BRING_SUMOFTEX_OK));
	
	///////////////////////////////////////////////////////////////////////////////
	// 忡   
	INIT_MSG(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK, T_FC_CITYWAR_GET_OCCUPYINFO_OK, pS2COccInfo, SendBuf);
	if(FALSE == pFMChann->MakeMSG_FC_CITYWAR_GET_OCCUPYINFO_OK(pS2COccInfo, m_character.GuildUniqueNumber))
	{
		SendErrorMessage(T_FC_CITYWAR_SET_BRIEFING, ERR_CITYWAR_NO_SUCH_CITYWAR_INFO
			, pFMChann->m_MapChannelIndex.MapIndex, pFMChann->m_MapChannelIndex.ChannelIndex);
		return RES_BREAK;
	}
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK));
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_WAR_REQ_SIGN_BOARD_STRING_LIST(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2006-04-17 ~ 2006-04-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_WAR_REQ_SIGN_BOARD_STRING_LIST(const char* pPacket, int nLength, int &nBytesUsed)
{	
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_WAR_REQ_SIGN_BOARD_STRING_LIST
		, MSG_FC_WAR_REQ_SIGN_BOARD_STRING_LIST, pRReqStringList);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-04-19 by cmkwon,   
	ms_pFieldIOCP->SendSignBoardStringList(this, pRReqStringList->nReqStringCount);


	// 2009-10-13 by cmkwon, Ϲ  ⿩   ʿ 
	if(FALSE == COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		///////////////////////////////////////////////////////////////////////////////
		// 2006-04-19 by cmkwon, ⿩ 
		INIT_MSG_WITH_BUFFER(MSG_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK, T_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK, pSConPoint, SendBuf);
		// 2009-10-12 by cmkwon, ī    - Ʒ  ڽ  Ѵ.
		//pSConPoint->byInfluenceType		= m_character.GetInfluenceMask();
		pSConPoint->byInfluenceType		= m_character.InfluenceType;
		pSConPoint->nContributionPoint	= ms_pFieldIOCP->m_InflWarManager.GetContributionPoint(m_character.InfluenceType);
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK));
	}
	return RES_RETURN_TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_PUT_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_PUT_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{	
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_SELL_PUT_ITEM
		, MSG_FC_BAZAAR_SELL_PUT_ITEM, pRMsg);

	if(0 >= pRMsg->nAmount
		|| 0 >= pRMsg->nEachPrice
		|| MAX_ITEM_COUNTS < (INT64)pRMsg->nAmount * (INT64)pRMsg->nEachPrice)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, ERR_DB_INVALID_PARAMETER);
		return RES_BREAK;
	}

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
	if(this->IsInvisibleCharacter())
	{// 2006-08-03 by cmkwon, ¿   Ұ
		SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}

	mt_auto_lock igLock(&this->m_ItemManager.m_mapItemGeneral);

	ITEM_GENERAL *pSellItemG = m_ItemManager.GetItemGeneralByUID(pRMsg->itemUID);
	if(NULL == pSellItemG)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	if(FALSE == this->IsTransferItem(pSellItemG, TRUE))
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}

	if(FALSE == IS_COUNTABLE_ITEM(pSellItemG->Kind))
	{
		pRMsg->nAmount			= 1;
	}
	else
	{
		if(pSellItemG->CurrentCount < pRMsg->nAmount)
		{
			SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
			return RES_BREAK;
		}
	}

	mt_auto_lock bmLock(m_bazaarManager.GetBazaarItemListPtr());

	ITEM_GENERAL *pSPIItemG = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if(NULL == pSPIItemG)
	{
		if(NULL == pSPIItemG)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
		SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	INT64	n64TotalMoney = m_bazaarManager.GetTotalPrice() + (INT64)pRMsg->nAmount * (INT64)pRMsg->nEachPrice + pSPIItemG->CurrentCount; 
	if(MAX_ITEM_COUNTS < n64TotalMoney)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	Err_t errCode = m_bazaarManager.AddSellItem(pSellItemG, pRMsg->nAmount, pRMsg->nEachPrice);
	if(ERR_NO_ERROR != errCode)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_PUT_ITEM, errCode);
		return RES_BREAK;
	}

	bmLock.auto_unlock_cancel();
	igLock.auto_unlock_cancel();


	INIT_MSG_WITH_BUFFER(MSG_FC_BAZAAR_SELL_PUT_ITEM_OK, T_FC_BAZAAR_SELL_PUT_ITEM_OK, pSItemOK, SendBuf);
	pSItemOK->itemUID		= pRMsg->itemUID;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_BAZAAR_SELL_PUT_ITEM_OK));
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_CANCEL_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_CANCEL_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{	
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_SELL_CANCEL_ITEM
		, MSG_FC_BAZAAR_SELL_CANCEL_ITEM, pRMsg);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_CANCEL_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	mt_auto_lock igLock(&this->m_ItemManager.m_mapItemGeneral);
	mt_auto_lock bmLock(m_bazaarManager.GetBazaarItemListPtr());

	if(BAZAAR_STATE_READY != m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_CANCEL_ITEM, ERR_PROTOCOL_INVALID_CHARACTER_STATE);
		return RES_BREAK;
	}

	SBazaarItem *pBazaarItem = m_bazaarManager.FindBazaarItemByItemUIDNoLock(pRMsg->itemUID);
	if(NULL == pBazaarItem)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_CANCEL_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	m_bazaarManager.DeleteBazaarItem(pBazaarItem->nBuyItemIndex);

	bmLock.auto_unlock_cancel();

	INIT_MSG_WITH_BUFFER(MSG_FC_BAZAAR_SELL_CANCEL_ITEM_OK, T_FC_BAZAAR_SELL_CANCEL_ITEM_OK, pSCancelOK, SendBuf);
	pSCancelOK->itemUID		= pRMsg->itemUID;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_BAZAAR_SELL_CANCEL_ITEM_OK));
	return RES_RETURN_TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_START(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_START(const char* pPacket, int nLength, int &nBytesUsed)
{	
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_SELL_START
		, MSG_FC_BAZAAR_SELL_START, pRMsg);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_START, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
	if(this->IsInvisibleCharacter())
	{// 2006-08-03 by cmkwon, ¿   Ұ
		SendErrorMessage(T_FC_BAZAAR_SELL_START, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}


	mt_auto_lock igLock(&this->m_ItemManager.m_mapItemGeneral);
	mt_auto_lock bmLock(m_bazaarManager.GetBazaarItemListPtr());

	if(BAZAAR_STATE_READY != m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_START, ERR_PROTOCOL_INVALID_CHARACTER_STATE);
		return RES_BREAK;
	}

	if(m_bazaarManager.IsEmptyBazaar())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_START, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	if(0 >= strlen(pRMsg->szBazaarName))
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_START, ERR_PROTOCOL_INVALID_CHARACTER_STATE);
		return RES_BREAK;
	}

	m_bazaarManager.SetBazaarName(pRMsg->szBazaarName);
	m_bazaarManager.SetBazaarState(BAZAAR_STATE_ACTIVE);	

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-26 by cmkwon,    BazaarInfo  غ
	INIT_MSG_WITH_BUFFER(MSG_FC_BAZAAR_INFO_OK, T_FC_BAZAAR_INFO_OK, pSBazaarInfoOK, SendBuf);
	this->MakeMSG_FC_BAZAAR_INFO_OKW(pSBazaarInfoOK);

	// 2008-10-30 by cmkwon, Ʈ     - 
	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Notify] Bazaar Sell Shop open !! %s ItemKindCount(%d)\r\n", GetCharacterString(this->GetCharacter(), string()), m_bazaarManager.GetBazaarItemListPtr()->size());

	bmLock.auto_unlock_cancel();
	igLock.auto_unlock_cancel();	// 2008-10-30 by cmkwon, Ʈ     - ⿡  ϴ    
	
	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-26 by cmkwon, ڱ ڽſ    OK 
	SendAddMessageType(T_FC_BAZAAR_SELL_START_OK);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-26 by cmkwon,    BazaarInfo 
	ms_pFieldIOCP->SendInRangeMessageAroundPosition(m_character.PositionVector, SendBuf, MSG_SIZE(MSG_FC_BAZAAR_INFO_OK),
															this->m_pCurrentFieldMapChannel, m_character.ClientIndex);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_REQUEST_ITEMLIST(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		// 2008-10-30 by cmkwon, Ʈ     - Ǹ  ڰ Ǹ  Ʈ û 
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_REQUEST_ITEMLIST(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_SELL_REQUEST_ITEMLIST
		, MSG_FC_BAZAAR_SELL_REQUEST_ITEMLIST, pRMsg);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
	if(this->IsInvisibleCharacter())
	{// 2006-08-03 by cmkwon, ¿   Ұ
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}

	// 2008-10-30 by cmkwon, Ʈ     - T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, Ǹ  Ǹ  Ʈ û ڰ     üũ
	if(BAZAAR_STATE_NONE != this->m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_USING_BAZAAR, this->m_bazaarManager.GetBazaarState());
		return RES_BREAK;
	}

	CFieldIOCPSocket *pPeerFISock = ms_pFieldIOCP->GetFieldIOCPSocket(pRMsg->clientIndex0);
	if(NULL == pPeerFISock
		|| FALSE == pPeerFISock->IsValidCharacter()
		|| FALSE == pPeerFISock->GetCharacter()->CharacterMode)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_INVALID_PEER_CHARACTER);
		return RES_BREAK;
	}

	if(REQUERED_BAZAAR_DISTANCE < D3DXVec3Length(&(m_character.PositionVector - pPeerFISock->GetCharacter()->PositionVector)))
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_PROTOCOL_TOO_FAR_TO_DO);
		return RES_BREAK;
	}
	
	if(FALSE == GCheckRaceAndInfluenceType(CHECK_TYPE_BAZAAR, (0==m_backupRace)?m_character.Race:m_backupRace, m_character.InfluenceType,
		(0==pPeerFISock->m_backupRace)?pPeerFISock->m_character.Race:pPeerFISock->m_backupRace, pPeerFISock->m_character.InfluenceType))
	{// 2006-08-07 by cmkwon, / ŷ üũ
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_INVALID_BAZAAR);
		return RES_BREAK;
	}

	if(FALSE == pPeerFISock->SendBazaarItemList(this, BAZAAR_TYPE_SELL))
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_INVALID_BAZAAR);
		return RES_BREAK;
	}

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_BUY_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		// 2008-10-30 by cmkwon, Ʈ     - Ǹ  ڰ   ûϴ 
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_SELL_BUY_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_SELL_BUY_ITEM
		, MSG_FC_BAZAAR_SELL_BUY_ITEM, pRMsg);

	if(0 >= pRMsg->nAmount0)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_DB_INVALID_PARAMETER);
		return RES_BREAK;
	}

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
	if(this->IsInvisibleCharacter())
	{// 2006-08-03 by cmkwon, ¿   Ұ
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}

	// 2008-10-30 by cmkwon, Ʈ     - T_FC_BAZAAR_SELL_BUY_ITEM, Ǹ    û ڰ     üũ
	if(BAZAAR_STATE_NONE != this->m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_USING_BAZAAR, this->m_bazaarManager.GetBazaarState());
		return RES_BREAK;
	}

	CFieldIOCPSocket *pPeerFISock = ms_pFieldIOCP->GetFieldIOCPSocket(pRMsg->clientIndex0);
	if(NULL == pPeerFISock
		|| FALSE == pPeerFISock->IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_INVALID_PEER_CHARACTER);
		return RES_BREAK;
	}

	if(FALSE == GCheckRaceAndInfluenceType(CHECK_TYPE_BAZAAR, (0==m_backupRace)?m_character.Race:m_backupRace, m_character.InfluenceType,
		(0==pPeerFISock->m_backupRace)?pPeerFISock->m_character.Race:pPeerFISock->m_backupRace, pPeerFISock->m_character.InfluenceType))
	{// 2006-08-07 by cmkwon, / ŷ üũ
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_INVALID_BAZAAR);
		return RES_BREAK;
	}

	mt_auto_lock meigLock(&m_ItemManager.m_mapItemGeneral);
	ITEM_GENERAL *pMeMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if(NULL == pMeMoney)
	{
		if(NULL == pMeMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	mt_auto_lock peerigLock(&pPeerFISock->m_ItemManager.m_mapItemGeneral);
	mt_auto_lock peerbiLock(pPeerFISock->m_bazaarManager.GetBazaarItemListPtr());

	SBazaarItem *pBazaarItem = pPeerFISock->m_bazaarManager.FindBazaarItemByItemUIDNoLock(pRMsg->itemUID);
	if(NULL == pBazaarItem)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_BAZAAR_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	ITEM_GENERAL *pItemG = pPeerFISock->m_ItemManager.GetItemGeneralByUID(pRMsg->itemUID);
	if(NULL == pItemG
		|| pItemG != pBazaarItem->pItemGeneral)
	{// 2008-07-23 by cmkwon,     -  ǸŻ  ǸŽ  üũ ߰
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_BAZAAR_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2008-07-22 by cmkwon,   üũ(ItemUID üũ) ߰ - Process_FC_BAZAAR_SELL_BUY_ITEM
	if(pBazaarItem->pItemGeneral->UniqueNumber != pRMsg->itemUID
		|| pBazaarItem->pItemGeneral->Possess != pPeerFISock->GetCharacter()->CharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER, 1000);
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] ItemBug(%s) %s %s, %d %I64d\r\n"
			, GetProtocolTypeString(T_FC_BAZAAR_SELL_BUY_ITEM), GetCharacterString(pPeerFISock->GetCharacter(), string()), GetItemGeneralString(pBazaarItem->pItemGeneral, string()), pBazaarItem->pItemGeneral->Possess, pRMsg->itemUID);
		return RES_BREAK;
	}

// 2008-10-30 by cmkwon, Ʈ     - Ʒ     üũ .
// 	if(pBazaarItem->nItemCnts < pRMsg->nAmount0)
// 	{
// 		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
// 		return RES_BREAK;
// 	}
	if(pBazaarItem->nItemCnts < pRMsg->nAmount0
		|| (IS_COUNTABLE_ITEM(pItemG->Kind) && pItemG->CurrentCount < pRMsg->nAmount0) )	// 2008-10-30 by cmkwon, Ʈ     - īͺ  κ   üũ
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED, pItemG->CurrentCount, pRMsg->nAmount0);
		return RES_BREAK;
	}

	ITEM_GENERAL *pPeerMoney = pPeerFISock->m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if(NULL == pPeerMoney)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	// 2006-07-26 by cmkwon,  SPI üũ
	if(pMeMoney->CurrentCount < (INT64)pRMsg->nAmount0 * (INT64)pBazaarItem->nItemPriceOfEach)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	if(MAX_ITEM_COUNTS < (INT64)pPeerMoney->CurrentCount + (INT64)pRMsg->nAmount0 * (INT64)pBazaarItem->nItemPriceOfEach)
	{// 2006-08-03 by cmkwon, 
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER);
		return RES_BREAK;
	}

	// 2006-07-26 by cmkwon,  κ丮  üũ
	// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
	if(m_ItemManager.GetInventoryItemCounts() >= m_ItemManager.GetMaxInventoryCount())
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon,   ó
	this->BazaarInsertItem(pPeerFISock, pBazaarItem->pItemGeneral, pRMsg->nAmount0);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon,  SPI ó 
	ITEM_GENERAL tmpItemOnlyForLog_BazaarSellVisitor = *pMeMoney;
	tmpItemOnlyForLog_BazaarSellVisitor.CurrentCount -= pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach;

	// 2008-09-08 by cmkwon, λ α    α ߰ - (ǸŻ) SendLogMessageITEMBazaarRecv .
	CAtumLogSender::SendLogMessageITEMBazaarSend(this, &tmpItemOnlyForLog_BazaarSellVisitor, pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach, &pPeerFISock->m_character);	//  ŷ: ޱ, non-countable
	m_ItemManager.UpdateItemCountByPointer(pMeMoney, -(pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach), IUT_BAZAAR_SELL);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon, Ǹ SPI ó 
	ITEM_GENERAL tmpItemOnlyForLog_BazaarSeller = *pPeerMoney;
	tmpItemOnlyForLog_BazaarSeller.CurrentCount += pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach;

	// 2008-09-08 by cmkwon, λ α    α ߰ - (ǸŻ) SendLogMessageITEMBazaarSend  .
	CAtumLogSender::SendLogMessageITEMBazaarRecv(pPeerFISock, &tmpItemOnlyForLog_BazaarSeller, pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach, &this->m_character);	//  ŷ: ֱ, non-countable
	pPeerFISock->m_ItemManager.UpdateItemCountByPointer(pPeerMoney, pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach, IUT_BAZAAR_SELL);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon,    ó
	if(FALSE == IS_COUNTABLE_ITEM(pBazaarItem->pBazaarItemInfo->Kind)
		|| pBazaarItem->nItemCnts == pRMsg->nAmount0)
	{
		pPeerFISock->m_bazaarManager.DeleteBazaarItem(pBazaarItem->nBuyItemIndex);
	}
	else	
	{
		pBazaarItem->nItemCnts	-= pRMsg->nAmount0;
	}

	peerbiLock.auto_unlock_cancel();
	peerigLock.auto_unlock_cancel();
	meigLock.auto_unlock_cancel();

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon, ޽ 
	INIT_MSG_WITH_BUFFER(MSG_FC_BAZAAR_SELL_BUY_ITEM_OK, T_FC_BAZAAR_SELL_BUY_ITEM_OK, pSBuyItemOK, SendBuf);
	pSBuyItemOK->itemUID		= pRMsg->itemUID;
	pSBuyItemOK->nAmount0		= pRMsg->nAmount0;
	pSBuyItemOK->clientIndex0	= pRMsg->clientIndex0;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_BAZAAR_SELL_BUY_ITEM_OK));

	pSBuyItemOK->clientIndex0	= this->GetCharacter()->ClientIndex;
	pPeerFISock->SendAddData(SendBuf, MSG_SIZE(MSG_FC_BAZAAR_SELL_BUY_ITEM_OK));

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_PUT_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-27 ~ 2006-07-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_PUT_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_BUY_PUT_ITEM
		, MSG_FC_BAZAAR_BUY_PUT_ITEM, pRMsg);

	if(0 >= pRMsg->nAmount
		|| MAX_ITEM_COUNTS <= (INT64)pRMsg->nAmount * (INT64)pRMsg->nEachPrice)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, ERR_DB_INVALID_PARAMETER);
		return RES_BREAK;
	}

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
	if(this->IsInvisibleCharacter())
	{// 2006-08-03 by cmkwon, ¿   Ұ
		SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}

	mt_auto_lock igLock(&this->m_ItemManager.m_mapItemGeneral);


	ITEM *pItemInfo = ms_pFieldIOCP->GetItemInfo(pRMsg->itemNum0);
	if(NULL == pItemInfo)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM, pRMsg->itemNum0);
		return RES_BREAK;
	}

	if(FALSE == this->IsTransferItem(pItemInfo, TRUE))
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}


	if(FALSE == IS_COUNTABLE_ITEM(pItemInfo->Kind))
	{
		pRMsg->nAmount			= 1;
	}
	else
	{
		ITEM_GENERAL *pMeItemG = m_ItemManager.GetFirstItemGeneralByItemNum(pRMsg->itemNum0);
		if(pMeItemG
			&& MAX_ITEM_COUNTS <= (INT64)pMeItemG->CurrentCount + (INT64)pRMsg->nAmount)		
		{
			SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
			return RES_BREAK;
		}
	}

	ITEM_GENERAL *pSPIItemG = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if(NULL == pSPIItemG)
	{
		if(NULL == pSPIItemG)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
		SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	mt_auto_lock bmLock(m_bazaarManager.GetBazaarItemListPtr());

	if(m_bazaarManager.GetTotalPrice() + (INT64)pRMsg->nAmount * (INT64)pRMsg->nEachPrice > pSPIItemG->CurrentCount)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	int nBuyItemIndex = 0;
	Err_t errCode = m_bazaarManager.AddBuyItem(&nBuyItemIndex, pItemInfo, pRMsg->nAmount, pRMsg->nEachPrice);
	if(ERR_NO_ERROR != errCode)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_PUT_ITEM, errCode);
		return RES_BREAK;
	}

	bmLock.auto_unlock_cancel();
	igLock.auto_unlock_cancel();


	INIT_MSG_WITH_BUFFER(MSG_FC_BAZAAR_BUY_PUT_ITEM_OK, T_FC_BAZAAR_BUY_PUT_ITEM_OK, pSItemOK, SendBuf);
	pSItemOK->itemNum0			= pRMsg->itemNum0;
	pSItemOK->nBuyItemIndex0	= nBuyItemIndex;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_BAZAAR_BUY_PUT_ITEM_OK));

	return RES_RETURN_TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_CANCEL_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_CANCEL_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{	
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_BUY_CANCEL_ITEM
		, MSG_FC_BAZAAR_BUY_CANCEL_ITEM, pRMsg);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_CANCEL_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	mt_auto_lock bmLock(m_bazaarManager.GetBazaarItemListPtr());

	if(BAZAAR_STATE_READY != m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_CANCEL_ITEM, ERR_PROTOCOL_INVALID_CHARACTER_STATE);
		return RES_BREAK;
	}

	SBazaarItem *pBazaarItem = m_bazaarManager.FindBazaarItemByBazaarIndexNoLock(pRMsg->nBuyItemIndex0);
	if(NULL == pBazaarItem)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_CANCEL_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	m_bazaarManager.DeleteBazaarItem(pBazaarItem->nBuyItemIndex);

	bmLock.auto_unlock_cancel();

	INIT_MSG_WITH_BUFFER(MSG_FC_BAZAAR_BUY_CANCEL_ITEM_OK, T_FC_BAZAAR_BUY_CANCEL_ITEM_OK, pSCancelOK, SendBuf);
	pSCancelOK->nBuyItemIndex0	= pRMsg->nBuyItemIndex0;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_BAZAAR_BUY_CANCEL_ITEM_OK));
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_START(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_START(const char* pPacket, int nLength, int &nBytesUsed)
{	
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_BUY_START
		, MSG_FC_BAZAAR_BUY_START, pRMsg);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_START, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
	if(this->IsInvisibleCharacter())
	{// 2006-08-03 by cmkwon, ¿   Ұ
		SendErrorMessage(T_FC_BAZAAR_BUY_START, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}

	mt_auto_lock igLock(&this->m_ItemManager.m_mapItemGeneral);
	mt_auto_lock bmLock(m_bazaarManager.GetBazaarItemListPtr());

	if(BAZAAR_STATE_READY != m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_START, ERR_PROTOCOL_INVALID_CHARACTER_STATE);
		return RES_BREAK;
	}

	if(m_bazaarManager.IsEmptyBazaar())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_START, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	if(0 >= strlen(pRMsg->szBazaarName))
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_START, ERR_PROTOCOL_INVALID_CHARACTER_STATE);
		return RES_BREAK;
	}

	m_bazaarManager.SetBazaarName(pRMsg->szBazaarName);
	m_bazaarManager.SetBazaarState(BAZAAR_STATE_ACTIVE);	

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-26 by cmkwon,    BazaarInfo  غ
	INIT_MSG_WITH_BUFFER(MSG_FC_BAZAAR_INFO_OK, T_FC_BAZAAR_INFO_OK, pSBazaarInfoOK, SendBuf);
	this->MakeMSG_FC_BAZAAR_INFO_OKW(pSBazaarInfoOK);
	
	// 2008-10-30 by cmkwon, Ʈ     - 
	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Notify] Bazaar Buy  Shop open !! %s ItemKindCount(%d)\r\n", GetCharacterString(this->GetCharacter(), string()), m_bazaarManager.GetBazaarItemListPtr()->size());

	bmLock.auto_unlock_cancel();
	igLock.auto_unlock_cancel();	// 2008-10-30 by cmkwon, Ʈ     - ⿡  ϴ    
	
	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-26 by cmkwon, ڱ ڽſ    OK 
	SendAddMessageType(T_FC_BAZAAR_BUY_START_OK);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-26 by cmkwon,    BazaarInfo 
	ms_pFieldIOCP->SendInRangeMessageAroundPosition(m_character.PositionVector, SendBuf, MSG_SIZE(MSG_FC_BAZAAR_INFO_OK),
															this->m_pCurrentFieldMapChannel, m_character.ClientIndex);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_REQUEST_ITEMLIST(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		// 2008-10-30 by cmkwon, Ʈ     - ڱ  Ǹڰ   Ʈ ûϴ 
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_REQUEST_ITEMLIST(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_BUY_REQUEST_ITEMLIST
		, MSG_FC_BAZAAR_BUY_REQUEST_ITEMLIST, pRMsg);

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_REQUEST_ITEMLIST, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
	if(this->IsInvisibleCharacter())
	{// 2006-08-03 by cmkwon, ¿   Ұ
		SendErrorMessage(T_FC_BAZAAR_BUY_REQUEST_ITEMLIST, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}

	// 2008-10-30 by cmkwon, Ʈ     - T_FC_BAZAAR_BUY_REQUEST_ITEMLIST, ڱ  Ǹڰ   Ʈ û Ǹ     üũ
	if(BAZAAR_STATE_NONE != this->m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_REQUEST_ITEMLIST, ERR_USING_BAZAAR, this->m_bazaarManager.GetBazaarState());
		return RES_BREAK;
	}

	CFieldIOCPSocket *pPeerFISock = ms_pFieldIOCP->GetFieldIOCPSocket(pRMsg->clientIndex0);
	if(NULL == pPeerFISock
		|| FALSE == pPeerFISock->IsValidCharacter()
		|| FALSE == pPeerFISock->GetCharacter()->CharacterMode)
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_INVALID_PEER_CHARACTER);
		return RES_BREAK;
	}

	if(REQUERED_BAZAAR_DISTANCE < D3DXVec3Length(&(m_character.PositionVector - pPeerFISock->GetCharacter()->PositionVector)))
	{
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_PROTOCOL_TOO_FAR_TO_DO);
		return RES_BREAK;
	}

	if(FALSE == GCheckRaceAndInfluenceType(CHECK_TYPE_BAZAAR, (0==m_backupRace)?m_character.Race:m_backupRace, m_character.InfluenceType,
		(0==pPeerFISock->m_backupRace)?pPeerFISock->m_character.Race:pPeerFISock->m_backupRace, pPeerFISock->m_character.InfluenceType))
	{// 2006-08-07 by cmkwon, / ŷ üũ
		SendErrorMessage(T_FC_BAZAAR_SELL_REQUEST_ITEMLIST, ERR_INVALID_BAZAAR);
		return RES_BREAK;
	}

	if(FALSE == pPeerFISock->SendBazaarItemList(this, BAZAAR_TYPE_BUY))
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_REQUEST_ITEMLIST, ERR_INVALID_BAZAAR);
		return RES_BREAK;
	}

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_SELL_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		// 2008-10-30 by cmkwon, Ʈ     - ڱ  Ǹڰ Ǹ ûϴ 
/// \author		cmkwon
/// \date		2006-07-26 ~ 2006-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_BAZAAR_BUY_SELL_ITEM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_BAZAAR_BUY_SELL_ITEM
		, MSG_FC_BAZAAR_BUY_SELL_ITEM, pRMsg);

	if(0 >= pRMsg->nAmount0)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_DB_INVALID_PARAMETER);
		return RES_BREAK;
	}

	if(FALSE == IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	// 2008-10-30 by cmkwon, Ʈ     - T_FC_BAZAAR_BUY_SELL_ITEM, ڱ   Ǹ û Ǹڰ     üũ
	if(BAZAAR_STATE_NONE != this->m_bazaarManager.GetBazaarState())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_USING_BAZAAR, this->m_bazaarManager.GetBazaarState());
		return RES_BREAK;
	}

// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_STEALTH_MASK))
	if(this->IsInvisibleCharacter())
	{// 2006-08-03 by cmkwon, ¿   Ұ
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_INVISIBLE_STATE);
		return RES_BREAK;
	}

	CFieldIOCPSocket *pPeerFISock = ms_pFieldIOCP->GetFieldIOCPSocket(pRMsg->clientIndex0);
	if(NULL == pPeerFISock
		|| FALSE == pPeerFISock->IsValidCharacter())
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_INVALID_PEER_CHARACTER);
		return RES_BREAK;
	}

	if(FALSE == GCheckRaceAndInfluenceType(CHECK_TYPE_BAZAAR, (0==m_backupRace)?m_character.Race:m_backupRace, m_character.InfluenceType,
		(0==pPeerFISock->m_backupRace)?pPeerFISock->m_character.Race:pPeerFISock->m_backupRace, pPeerFISock->m_character.InfluenceType))
	{// 2006-08-07 by cmkwon, / ŷ üũ
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_INVALID_BAZAAR);
		return RES_BREAK;
	}

	mt_auto_lock meigLock(&m_ItemManager.m_mapItemGeneral);

	ITEM_GENERAL *pItemG = m_ItemManager.GetItemGeneralByUID(pRMsg->itemUID);
	if (NULL == pItemG)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM);
		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2008-07-22 by cmkwon,   üũ(ItemUID üũ) ߰ - Process_FC_BAZAAR_BUY_SELL_ITEM
	if(pItemG->UniqueNumber != pRMsg->itemUID
		|| pItemG->Possess != GetCharacter()->CharacterUniqueNumber)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER, 1000);
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] ItemBug(%s) %s %s, %d %I64d\r\n"
			, GetProtocolTypeString(T_FC_BAZAAR_BUY_SELL_ITEM), GetCharacterString(GetCharacter(), string()), GetItemGeneralString(pItemG, string()), pItemG->Possess, pRMsg->itemUID);
		return RES_BREAK;
	}

	if(0 != pItemG->PrefixCodeNum
		|| 0 != pItemG->SuffixCodeNum
		|| this->GetVectEnchantListPtr(pRMsg->itemUID))
	{// 2006-07-27 by cmkwon, ⺻  üũ
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}
	if(FALSE == this->IsTransferItem(pItemG, TRUE))
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}

	if(FALSE == IS_COUNTABLE_ITEM(pItemG->Kind))
	{
		pRMsg->nAmount0		= 1;
	}
	else
	{
		if(pItemG->CurrentCount < pRMsg->nAmount0)
		{
			SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
			return RES_BREAK;
		}
	}

	ITEM_GENERAL *pMeMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
 	if(NULL == pMeMoney)
 	{
		if(NULL == pMeMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
 		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_NO_SUCH_ITEM, MONEY_ITEM_NUMBER);
		return RES_BREAK;
 	}

	mt_auto_lock peerigLock(&pPeerFISock->m_ItemManager.m_mapItemGeneral);
	mt_auto_lock peerbiLock(pPeerFISock->m_bazaarManager.GetBazaarItemListPtr());

	SBazaarItem *pBazaarItem = pPeerFISock->m_bazaarManager.FindBazaarItemByBazaarIndexNoLock(pRMsg->nBuyItemIndex0);
	if(NULL == pBazaarItem)
	{
 		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_BAZAAR_NO_SUCH_ITEM, pRMsg->nBuyItemIndex0);
		return RES_BREAK;
	}

	// 2010-01-26 by cmkwon, ڱŻ  (ItemNum üũ) - 
	if(pItemG->ItemNum != pBazaarItem->pBazaarItemInfo->ItemNum)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_INVALID_ITEMNUM, pItemG->ItemNum, pBazaarItem->pBazaarItemInfo->ItemNum);
		return RES_BREAK;
	}

	if(pBazaarItem->nItemCnts < pRMsg->nAmount0)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
		return RES_BREAK;
	}

	ITEM_GENERAL *pPeerMoney = pPeerFISock->m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if(NULL == pPeerMoney)
	{
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

 	if(pPeerMoney->CurrentCount < (INT64)pRMsg->nAmount0 * (INT64)pBazaarItem->nItemPriceOfEach)
 	{
 		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_ITEM_AMOUNT_EXCEED);
 		return RES_BREAK;
 	}
	if(MAX_ITEM_COUNTS < (INT64)pMeMoney->CurrentCount + (INT64)pRMsg->nAmount0 * (INT64)pBazaarItem->nItemPriceOfEach)
	{// 2006-08-03 by cmkwon
 		SendErrorMessage(T_FC_BAZAAR_SELL_BUY_ITEM, ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER);
 		return RES_BREAK;
	}

	// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
	if(pPeerFISock->m_ItemManager.GetInventoryItemCounts() >= pPeerFISock->m_ItemManager.GetMaxInventoryCount())
	{// 2007-10-30 by cmkwon,   - CAtumSJ::GetMaxInventorySize() Լ ڷ   ÷ ־ 
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_INVENTORY_FULL_ITEM);
		return RES_BREAK;
	}

	// 2013-05-31 by jhseol,bckim Ƹ ÷ - λ Ǹ
#ifdef SC_COLLECTION_ARMOR_JHSEOL_BCKIM	// - λ Ǹ
	if ( 0 != pItemG->ShapeItemNum && SHAPE_STAT_INIT_LEVEL < pItemG->FixedTermShape.nStatLevel )
	{
		SendString128(STRING_128_USER_NOTICE, STRMSG_130531_0009);
		SendErrorMessage(T_FC_BAZAAR_BUY_SELL_ITEM, ERR_PROTOCOL_ITEM_CANNOT_TRANSFER);
		return RES_BREAK;
	}
#endif
	// end 2013-05-31 by jhseol,bckim Ƹ ÷ - λ Ǹ

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon, Ż ο  ߰
	pPeerFISock->BazaarInsertItem(this, pItemG, pRMsg->nAmount0, IUT_BAZAAR_BUY);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon, Ż  SPI ó 
	ITEM_GENERAL tmpItemOnlyForLog_BazaarBuyVisitor = *pMeMoney;
	tmpItemOnlyForLog_BazaarBuyVisitor.CurrentCount += pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach;
	CAtumLogSender::SendLogMessageITEMBazaarRecv(this, &tmpItemOnlyForLog_BazaarBuyVisitor, pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach, &pPeerFISock->m_character);	//  ŷ: ޱ, non-countable
	m_ItemManager.UpdateItemCountByPointer(pMeMoney, pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach, IUT_BAZAAR_BUY);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon, Ż  SPI ó
	ITEM_GENERAL tmpItemOnlyForLog_BazaarBuyer = *pPeerMoney;
	tmpItemOnlyForLog_BazaarBuyer.CurrentCount -= pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach;
	CAtumLogSender::SendLogMessageITEMBazaarSend(pPeerFISock, &tmpItemOnlyForLog_BazaarBuyer, pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach, &this->m_character);	//  ŷ: ֱ, non-countable
	pPeerFISock->m_ItemManager.UpdateItemCountByPointer(pPeerMoney, -(pRMsg->nAmount0 * pBazaarItem->nItemPriceOfEach), IUT_BAZAAR_BUY);

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon, Ż  ó
	if(FALSE == IS_COUNTABLE_ITEM(pBazaarItem->pBazaarItemInfo->Kind)
		|| pBazaarItem->nItemCnts == pRMsg->nAmount0)
	{
		pPeerFISock->m_bazaarManager.DeleteBazaarItem(pBazaarItem->nBuyItemIndex);
	}
	else	
	{
		pBazaarItem->nItemCnts	-= pRMsg->nAmount0;
	}

	peerbiLock.auto_unlock_cancel();
	peerigLock.auto_unlock_cancel();
	meigLock.auto_unlock_cancel();

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon, ޽ 
	INIT_MSG_WITH_BUFFER(MSG_FC_BAZAAR_BUY_SELL_ITEM_OK, T_FC_BAZAAR_BUY_SELL_ITEM_OK, pSBuyItemOK, SendBuf);
	pSBuyItemOK->itemUID		= pRMsg->itemUID;
	pSBuyItemOK->nBuyItemIndex0	= pRMsg->nBuyItemIndex0;
	pSBuyItemOK->nAmount0		= pRMsg->nAmount0;
	pSBuyItemOK->clientIndex0	= pRMsg->clientIndex0;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_BAZAAR_BUY_SELL_ITEM_OK));

	pSBuyItemOK->clientIndex0	= this->GetCharacter()->ClientIndex;
	pPeerFISock->SendAddData(SendBuf, MSG_SIZE(MSG_FC_BAZAAR_BUY_SELL_ITEM_OK));

	return RES_RETURN_TRUE;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// 2012-06-08 by jhseol, Ʒ ߰part2 - ɸ : Ÿ 
///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_PLAY_CHARACTER_TYPE(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		Ʒ ÷  ɸ Ÿ 
/// \author		jhseol
/// \date		2012-06-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_PLAY_CHARACTER_TYPE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_ARENA_PLAY_CHARACTER_TYPE
		, MSG_FC_ARENA_PLAY_CHARACTER_TYPE, pRMsg);
	
	if(!this->IsValidCharacter())
	{
		SendErrorMessage(T_FC_ARENA_PLAY_CHARACTER_TYPE, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	m_nPlayCharacterType = pRMsg->PlayCharacterType;

	if(TRUE == g_pFieldGlobal->IsArenaServer())
	{
		this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberList(this->m_ArenaInfo.TeamNum);
	}
	
	return RES_RETURN_TRUE;
}
// end 2012-06-08 by jhseol, Ʒ ߰part2 - ɸ : Ÿ 

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_REQUEST_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-04-23 ~ 2007-04-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_REQUEST_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_ARENA_REQUEST_TEAM
		, MSG_FC_ARENA_REQUEST_TEAM, pRMsg);
	
	if(this->m_character.ClientIndex != pRMsg->ClientIndex)
	{
		SendErrorMessage(T_FC_ARENA_REQUEST_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	if(!this->IsValidCharacter())
	{
		SendErrorMessage(T_FC_ARENA_REQUEST_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,   û  óѴ.
	this->ms_pFieldIOCP->m_ArenaManager.SendRequestTeamInfo(this, pRMsg->ArenaMode, pRMsg->StartTeamNum, pRMsg->RequestTeamState, pRMsg->ArenaMap);	// 2012-04-12 by jhseol, Ʒ ߰ -  Ʒ  Ķ ߰
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_CREATE_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-04-23 ~ 2007-04-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_CREATE_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_ARENA_CREATE_TEAM
		, MSG_FC_ARENA_CREATE_TEAM, pRMsg);
	
	if(this->m_character.ClientIndex != pRMsg->ClientIndex)
	{
		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	if(!this->IsValidCharacter())
	{
		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-30 by dhjin, Ʒ Ȱ      ִ.
	if(ARENA_STATE_NONE != this->m_ArenaInfo.State)
	{
		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_ARENA_STATE);
		return RES_BREAK;		
	}
	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   üũ
	if(INFINITY_STATE_NONE != this->m_InfinityPlayingInfo.InfinityState ) {
		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_INFINITY_STATE);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-26 by dhjin,   ʾ 
	if(COMPARE_INFLUENCE(this->m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_REQ_CHOOSE_INFLUENCE_TYPE);
		return RES_BREAK;
	}

	// 2012-08-24 by jhseol, Ʒ ׼ - 巹 üũ ߰
	// 2012-09-14 by jhseol, Ʒ ߰ restore -   ¿ ڽ ɸͷθ ÷ ϵ 
#ifdef S_ARENA_EX_1ST_JHSEOL
#ifndef S_ARENA_EX_1ST_RESTORE_JHSEOL
	if( this->m_character.Level < ARENA_STAGE_START_LEVEL || this->m_character.Level > ARENA_STAGE_A_END_LEVEL)
	{
		return RES_BREAK;
	}
#endif
#endif
	// end 2012-09-14 by jhseol, Ʒ ߰ restore -   ¿ ڽ ɸͷθ ÷ ϵ 
	// end 2012-08-24 by jhseol, Ʒ ׼ - 巹 üũ ߰

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-26 by dhjin, ̼    Ұ
//	if(this->GetCharacterQuestInProgress())
//	{
//		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_PROTOCOL_QUEST_IS_IN_PROGRESS);
//		return RES_BREAK;
//	}
	
	//////////////////////////////////////////////////////////////////////////
	// 2007-04-26 by dhjin, ,    Ұ
// 2008-01-03 by dhjin, Ʒ  - Ŭ̾Ʈ ó
//	if(this->ms_pFieldIOCP->m_InflWarManager.CheckSummonBossAndStrategyPoint())
//	{
//		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_BOSS_STRATEGYPOINT_STATE_SUMMON);
//		return RES_BREAK;
//	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin,  ָ  ¿ û  .
// 2008-01-03 by dhjin, Ʒ  - Ǳ  Ʒ   ʴ´.
//	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
//	ITEM_GENERAL *pBCULeaderItem = m_ItemManager.GetFirstItemGeneralByItemNum(ITEM_NUM_BRIGHTNESS_OF_BCU_LEADER, ITEM_IN_CHARACTER);
//	ITEM_GENERAL *pANILeaderItem = m_ItemManager.GetFirstItemGeneralByItemNum(ITEM_NUM_BRIGHTNESS_OF_ANI_LEADER, ITEM_IN_CHARACTER);
//	if( (pBCULeaderItem && WEAR_NOT_ATTACHED != pBCULeaderItem->Wear)
//		|| (pANILeaderItem && WEAR_NOT_ATTACHED != pANILeaderItem->Wear) )
//	{
//		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_PROTOCOL_INVALID_ITEM_WINDOW_POSITION);
//		return RES_BREAK;		
//	}
//	igLock.auto_unlock_cancel();

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-15 by dhjin, Ƽ  ϶  Ұ
// 2008-01-03 by dhjin, Ʒ  - üũ ƾ 
//	if (this->IsPartyBattleState())
//	{
//		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_PROTOCOL_DOING_PARTY_BATTLE);
//		return RES_BREAK;
//	}
//	
//	//////////////////////////////////////////////////////////////////////////
//	// 2007-05-15 by dhjin,  ϴ  Ұ.
//	mt_auto_lock mtGW(ms_pFieldIOCP->m_GuildWarManager.GetmtmapGuildWarPtr());
//	if (ms_pFieldIOCP->m_GuildWarManager.FindGuildWarPtr(this->GetCharacter()->GuildUniqueNumber))
//	{
//		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_PROTOCOL_DOING_GUILDWAR_BATTLE);
//		return RES_BREAK;
//	}
// 	mtGW.auto_unlock_cancel();

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,  
	INT	nTeamNum =	this->ms_pFieldIOCP->m_ArenaManager.CreateTeam(pRMsg, this);

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,   
	if(STATE_ERROR == nTeamNum)
	{
		SendErrorMessage(T_FC_ARENA_CREATE_TEAM, ERR_ARENA_CREATE_TEAM);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin, Arena 
	this->m_ArenaInfo.ArenaMode =	pRMsg->ArenaMode;
	this->m_ArenaInfo.State		=	ARENA_STATE_JOINING;
	this->m_ArenaInfo.TeamNum	=	nTeamNum;
	this->m_ArenaInfo.ReadyButtonClickTime.SetCurrentDateTime();
	this->m_ArenaInfo.ReadyButtonClickTime.AddDateTime(0,0,0,0,0,-5);

	// 2008-01-03 by dhjin,  Ʒ  - ʵ弭 ɸ Ʒ ° 
	if(FALSE == this->SendMFSArenaStateChange(ARENA_STATE_JOINING))
	{
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,    
	INIT_MSG_WITH_BUFFER(MSG_FC_ARENA_CREATE_TEAM_OK, T_FC_ARENA_CREATE_TEAM_OK, pCreateTeamOK, SendBuf);
	pCreateTeamOK->ArenaMode	= pRMsg->ArenaMode;
	pCreateTeamOK->TeamSize		= this->ms_pFieldIOCP->m_ArenaManager.GetTeamSize(nTeamNum);
	pCreateTeamOK->TeamNum		= nTeamNum;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_ARENA_CREATE_TEAM_OK));

//	// 2007-05-18 by cmkwon, ׽Ʈ α
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ARENA] CreateTeam - TeamNum(%4d) AState(%30s) DMRoomNum(%d) CharName(%s), TeamSize(%d)\r\n" 
//			, m_ArenaInfo.TeamNum, GET_ARENA_STATE_STRING(m_ArenaInfo.State), m_ArenaInfo.DeathMatchRoomNum, m_character.CharacterName, pCreateTeamOK->TeamSize);

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,   
	this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberList(nTeamNum);

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,  ° ARENA_STATE_READY̸ READY ¸ ˷ش.
	if(ARENA_STATE_READY == this->ms_pFieldIOCP->m_ArenaManager.GetTeamState(nTeamNum))
	{
		this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberState(nTeamNum, ARENA_STATE_READY);
	}

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_ENTER_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-04-23 ~ 2007-04-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_ENTER_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_ARENA_ENTER_TEAM
		, MSG_FC_ARENA_ENTER_TEAM, pRMsg);
	
	if(this->m_character.ClientIndex != pRMsg->ClientIndex)
	{
		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	if(!this->IsValidCharacter())
	{
		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin, Ʒ ° ƴϾ 
	if(ARENA_STATE_NONE != this->m_ArenaInfo.State)
	{
		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_ARENA_STATE);
		return RES_BREAK;		
	}

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   üũ
	if(INFINITY_STATE_NONE != this->m_InfinityPlayingInfo.InfinityState ) {
		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_INFINITY_STATE);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-26 by dhjin,   ʾ 
	if(COMPARE_INFLUENCE(this->m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_REQ_CHOOSE_INFLUENCE_TYPE);
		return RES_BREAK;
	}

// 2007-05-15 by dhjin, ̼ ߿ Ʒ  
//	//////////////////////////////////////////////////////////////////////////
//	// 2007-04-26 by dhjin, ̼    Ұ
//	if(this->GetCharacterQuestInProgress())
//	{
//		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_PROTOCOL_QUEST_IS_IN_PROGRESS);
//		return RES_BREAK;
//	}
	
	//////////////////////////////////////////////////////////////////////////
	// 2007-04-26 by dhjin, ,    Ұ
// 2008-01-03 by dhjin, Ʒ  - Ŭ̾Ʈ ó
//	if(this->ms_pFieldIOCP->m_InflWarManager.CheckSummonBossAndStrategyPoint())
//	{
//		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_BOSS_STRATEGYPOINT_STATE_SUMMON);
//		return RES_BREAK;
//	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin,  ָ  ¿ û  .
// 2008-01-03 by dhjin, Ʒ  - Ǳ  Ʒ   ʴ´.
//	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
//	ITEM_GENERAL *pBCULeaderItem = m_ItemManager.GetFirstItemGeneralByItemNum(ITEM_NUM_BRIGHTNESS_OF_BCU_LEADER, ITEM_IN_CHARACTER);
//	ITEM_GENERAL *pANILeaderItem = m_ItemManager.GetFirstItemGeneralByItemNum(ITEM_NUM_BRIGHTNESS_OF_ANI_LEADER, ITEM_IN_CHARACTER);
//	if( (pBCULeaderItem && WEAR_NOT_ATTACHED != pBCULeaderItem->Wear)
//		|| (pANILeaderItem && WEAR_NOT_ATTACHED != pANILeaderItem->Wear) )
//	{
//		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_PROTOCOL_INVALID_ITEM_WINDOW_POSITION);
//		return RES_BREAK;		
//	}
//	igLock.auto_unlock_cancel();

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-15 by dhjin, Ƽ  ϶  Ұ
// 2008-01-03 by dhjin, Ʒ  - üũ ƾ 
//	if (this->IsPartyBattleState())
//	{
//		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_PROTOCOL_DOING_PARTY_BATTLE);
//		return RES_BREAK;
//	}
//	
//	//////////////////////////////////////////////////////////////////////////
//	// 2007-05-15 by dhjin,  ϴ  Ұ.
//	mt_auto_lock mtGW(ms_pFieldIOCP->m_GuildWarManager.GetmtmapGuildWarPtr());
//	if (ms_pFieldIOCP->m_GuildWarManager.FindGuildWarPtr(this->GetCharacter()->GuildUniqueNumber))
//	{
//		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, ERR_PROTOCOL_DOING_GUILDWAR_BATTLE);
//		return RES_BREAK;
//	}	
//	mtGW.auto_unlock_cancel();
	
	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,  ߰ 
	Err_t errCode = this->ms_pFieldIOCP->m_ArenaManager.InsertMember(pRMsg, this);
	if(ERR_NO_ERROR != errCode)
	{
		SendErrorMessage(T_FC_ARENA_ENTER_TEAM, errCode);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin, Arena  
	this->m_ArenaInfo.ArenaMode =	pRMsg->ArenaMode;
	this->m_ArenaInfo.State		=	ARENA_STATE_JOINING;
	this->m_ArenaInfo.TeamNum	=	pRMsg->TeamNum;
	this->m_ArenaInfo.ReadyButtonClickTime.SetCurrentDateTime();
	this->m_ArenaInfo.ReadyButtonClickTime.AddDateTime(0,0,0,0,0,-5);

	// 2008-01-03 by dhjin,  Ʒ  - ʵ弭 ɸ Ʒ ° 
	if(FALSE == this->SendMFSArenaStateChange(ARENA_STATE_JOINING))
	{
		return RES_BREAK;
	}

//	// 2007-05-18 by cmkwon, ׽Ʈ α
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ARENA] EnterTeam - TeamNum(%4d) AState(%30s) DMRoomNum(%d) CharName(%s)\r\n" 
//			, m_ArenaInfo.TeamNum, GET_ARENA_STATE_STRING(m_ArenaInfo.State), m_ArenaInfo.DeathMatchRoomNum, m_character.CharacterName);

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,    
	INIT_MSG_WITH_BUFFER(MSG_FC_ARENA_ENTER_TEAM_OK, T_FC_ARENA_ENTER_TEAM_OK, pEnterTeamOK, SendBuf);
	pEnterTeamOK->ArenaMode		= pRMsg->ArenaMode;
	pEnterTeamOK->TeamSize		= this->ms_pFieldIOCP->m_ArenaManager.GetTeamSize(pRMsg->TeamNum);
	pEnterTeamOK->TeamNum		= pRMsg->TeamNum;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_ARENA_ENTER_TEAM_OK));

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,   
	this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberList(pRMsg->TeamNum);

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,  ° ARENA_STATE_READY̸ READY ¸ ˷ش.
	if(ARENA_STATE_READY == this->ms_pFieldIOCP->m_ArenaManager.GetTeamState(pRMsg->TeamNum))
	{
		this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberState(pRMsg->TeamNum, ARENA_STATE_READY);
	}
	
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_REAVE_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-04-23 ~ 2007-04-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_REAVE_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_ARENA_REAVE_TEAM
		, MSG_FC_ARENA_REAVE_TEAM, pRMsg);
	
	if(this->m_character.ClientIndex != pRMsg->ClientIndex)
	{
		SendErrorMessage(T_FC_ARENA_REAVE_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	if(!this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_ARENA_REAVE_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}	

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-03 by dhjin, ޼ üũ
	if(FALSE == this->m_ArenaInfo.IsValidArenaState()			// 2007-05-14 by cmkwon, üũ߰
		|| this->m_ArenaInfo.ArenaMode != pRMsg->ArenaMode
		|| this->m_ArenaInfo.TeamNum != pRMsg->TeamNum)
	{
		SendErrorMessage(T_FC_ARENA_REAVE_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,  
	Err_t errCode = this->ms_pFieldIOCP->m_ArenaManager.DeleteMember(this);
	if(ERR_NO_ERROR != errCode)
	{
		SendErrorMessage(T_FC_ARENA_REAVE_TEAM, errCode);
		return RES_BREAK;
	}

	// 2008-01-03 by dhjin,  Ʒ  - ʵ弭 ɸ Ʒ ° 
	if(FALSE == this->SendMFSArenaStateChange(ARENA_STATE_NONE))
	{
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-03 by dhjin, Ʒ    
	this->SendAddMessageType(T_FC_ARENA_REAVE_TEAM_OK);


	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin, Arena 
	this->m_ArenaInfo.ResetArenaInfo();

	//////////////////////////////////////////////////////////////////////
	// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ⱑ   ִ ȣ ʱȭ ش
	INIT_MSG_WITH_BUFFER(MSG_FI_PARTY_ARENA_TEAM_NUM, T_FI_PARTY_ARENA_TEAM_NUM, msgArenaTeamNum, msgArenaTeamNumBuf);
	msgArenaTeamNum->TeamNum = this->m_ArenaInfo.TeamNum;
	msgArenaTeamNum->CharacterUniqueNumber = this->m_character.CharacterUniqueNumber;
	this->ms_pFieldIOCP->m_pIMWinSocket->Write((char*)msgArenaTeamNumBuf, MSG_SIZE(MSG_FI_PARTY_ARENA_TEAM_NUM));
	// end 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ⱑ   ִ ȣ ʱȭ ش
	//////////////////////////////////////////////////////////////////////

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_TEAM_READY_FINISH(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-05-02 ~ 2007-05-02
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_TEAM_READY_FINISH(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_ARENA_TEAM_READY_FINISH, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}	

	// 2007-07-11 by cmkwon, Ʒ ý  - T_FC_ARENA_TEAM_READY_FINISH
	int nRemainMinute = 0;
	if(ms_pFieldIOCP->m_arenaBlockManager.IsExistChatBlockList(&nRemainMinute, m_character.CharacterName))
	{
		SendErrorMessage(T_FC_ARENA_TEAM_READY_FINISH, ERR_ARENA_BLOCKED, nRemainMinute);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin, Ʒ  ARENA_STATE_READY ƴϸ ùٸ ° ƴϴ.
	if(ARENA_STATE_JOINING != this->m_ArenaInfo.State
		&&  ARENA_STATE_READY != this->m_ArenaInfo.State)
	{
		SendErrorMessage(T_FC_ARENA_TEAM_READY_FINISH, ERR_ARENA_STATE);
		return RES_BREAK;		
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-26 by dhjin, ,    Ұ
// 2008-01-03 by dhjin, Ʒ  - Ŭ̾Ʈ ó
//	if(this->ms_pFieldIOCP->m_InflWarManager.CheckSummonBossAndStrategyPoint())
//	{
//		SendErrorMessage(T_FC_ARENA_TEAM_READY_FINISH, ERR_BOSS_STRATEGYPOINT_STATE_SUMMON);
//		return RES_BREAK;
//	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-08 by dhjin, Ű ð , 3 ̰  ʾҴٸ Ѵ.
	ATUM_DATE_TIME tmCurTime;
	tmCurTime.SetCurrentDateTime();
	if(ARENA_READYBUTTON_INTERVAL > tmCurTime.GetTimeDiffTimeInSeconds(this->m_ArenaInfo.ReadyButtonClickTime))
	{
		SendErrorMessage(T_FC_ARENA_TEAM_READY_FINISH, ERR_COUNTDOWN_NOT_ENOUGH_TIME,
			tmCurTime.GetTimeDiffTimeInSeconds(this->m_ArenaInfo.ReadyButtonClickTime), 0,
			(char*)(m_ArenaInfo.ReadyButtonClickTime.GetCurrentDateTimeString(STRNBUF(SIZE_MAX_SQL_DATETIME_STRING))));
		return RES_BREAK;	
	}
	this->m_ArenaInfo.ReadyButtonClickTime = tmCurTime;

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin, Ʒ  ARENA_STATE_READY_FINISH  
	this->m_ArenaInfo.State	= ARENA_STATE_READY_FINISH;

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin,   
	this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberList(this->m_ArenaInfo.TeamNum);

//	// 2007-05-18 by cmkwon, ׽Ʈ α
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ARENA] TeamReadyFinish - TeamNum(%4d) AState(%30s) DMRoomNum(%d) CharName(%s)\r\n" 
//			, m_ArenaInfo.TeamNum, GET_ARENA_STATE_STRING(m_ArenaInfo.State), m_ArenaInfo.DeathMatchRoomNum, m_character.CharacterName);

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin,   ARENA_STATE_READY_FINISH üũϿ TRUE̸ Ī Ѵ.
	if(this->ms_pFieldIOCP->m_ArenaManager.ChectTeamFullReadyFinish(this->m_ArenaInfo.TeamNum))
	{
		this->ms_pFieldIOCP->m_ArenaManager.SendTeamMatchIngState(this->m_ArenaInfo.TeamNum);
		
		if(!this->ms_pFieldIOCP->m_ArenaManager.TeamMatch(this->m_ArenaInfo.TeamNum))
		{
			return RES_BREAK;
		}
	}

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult Process_FC_ARENA_TEAM_READY_FINISH_CANCEL(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-05-04 ~ 2007-05-04
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_TEAM_READY_FINISH_CANCEL(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_ARENA_TEAM_READY_FINISH_CANCEL, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}	

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-08 by dhjin, Ű ð , 3 ̰  ʾҴٸ Ѵ.
	ATUM_DATE_TIME tmCurTime;
	tmCurTime.SetCurrentDateTime();
	if(ARENA_READYBUTTON_INTERVAL > tmCurTime.GetTimeDiffTimeInSeconds(this->m_ArenaInfo.ReadyButtonClickTime))
	{
		SendErrorMessage(T_FC_ARENA_TEAM_READY_FINISH_CANCEL, ERR_COUNTDOWN_NOT_ENOUGH_TIME,
			tmCurTime.GetTimeDiffTimeInSeconds(this->m_ArenaInfo.ReadyButtonClickTime), 0,
			(char*)(m_ArenaInfo.ReadyButtonClickTime.GetCurrentDateTimeString(STRNBUF(SIZE_MAX_SQL_DATETIME_STRING))));
		return RES_BREAK;	
	}
	this->m_ArenaInfo.ReadyButtonClickTime = tmCurTime;

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin, Ʒ  ARENA_STATE_READY_FINISH ƴϸ ùٸ ° ƴϴ.
	if(ARENA_STATE_FIGHTING_WARREADY == this->ms_pFieldIOCP->m_ArenaManager.GetTeamState(this->m_ArenaInfo.TeamNum)
		&& ARENA_STATE_READY_FINISH != this->m_ArenaInfo.State)
	{
		SendErrorMessage(T_FC_ARENA_TEAM_READY_FINISH_CANCEL, ERR_ARENA_STATE);
		return RES_BREAK;		
	}
	
	//////////////////////////////////////////////////////////////////////////
	// 2007-05-04 by dhjin, Ʒ   ARENA_STATE_READY 
	this->m_ArenaInfo.State	= ARENA_STATE_READY;

//	// 2007-05-18 by cmkwon, ׽Ʈ α
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ARENA] TeamReadyFinishCancel - TeamNum(%4d) AState(%30s) DMRoomNum(%d) CharName(%s)\r\n" 
//			, m_ArenaInfo.TeamNum, GET_ARENA_STATE_STRING(m_ArenaInfo.State), m_ArenaInfo.DeathMatchRoomNum, m_character.CharacterName);

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-04 by dhjin,    ִٸ ¸ ARENA_STATE_READY , ƴϸ ARENA_STATE_JOINING 
	if(this->ms_pFieldIOCP->m_ArenaManager.CheckTeamFullMember(this->m_ArenaInfo.TeamNum))
	{
		this->ms_pFieldIOCP->m_ArenaManager.SetTeamState(this->m_ArenaInfo.TeamNum, ARENA_STATE_READY);	
	}
	else
	{
		this->ms_pFieldIOCP->m_ArenaManager.SetTeamState(this->m_ArenaInfo.TeamNum, ARENA_STATE_JOINING);	
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin,   
	this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberList(this->m_ArenaInfo.TeamNum);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_ENTER_ROOM_WARP(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-05-04 ~ 2007-05-04
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_ENTER_ROOM_WARP(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_ARENA_ENTER_ROOM_WARP
		, MSG_FC_ARENA_ENTER_ROOM_WARP, pRMsg);
	
	if(!this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_ARENA_ENTER_ROOM_WARP, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}	

	//////////////////////////////////////////////////////////////////////////
	// 2008-02-21 by dhjin, Ʒ  - '/Ʒ̵' ɾ ƴϸ üũѴ. ɾ Ʒ  ̵ϱ  ʿƾ ~!
	if(pRMsg->CheckCommand
		&& CheckCommandExecutability(RACE_OPERATION|RACE_GAMEMASTER) )
	{
		this->m_ArenaInfo.Command	= TRUE;	
	}
	else
	{
		//////////////////////////////////////////////////////////////////////////
		// 2007-05-02 by dhjin, Ʒ  ARENA_STATE_READY ƴϸ ùٸ ° ƴϴ.
		if(ARENA_STATE_FIGHTING_WARREADY != this->m_ArenaInfo.State)
		{
			SendErrorMessage(T_FC_ARENA_ENTER_ROOM_WARP, ERR_ARENA_STATE);
			return RES_BREAK;		
		}
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-04 by dhjin, Ʒ   Ų
// 2008-01-04 by dhjin, Ʒ  - ʵ  Ī  Ѵ.
//	this->ms_pFieldIOCP->m_ArenaManager.WarpToDeathMatchRoom(this);
	CIOCPSocket	*	MFSSock = ms_pFieldIOCP->GetMFSSockForArenaServer(this->m_AfsNeedMfsInfo.MFSServerID);
	if(NULL == MFSSock)
	{// 2007-12-28 by dhjin, ʵ     
		SendErrorMessage(T_FC_ARENA_ENTER_ROOM_WARP, ERR_NO_SUCH_FIELDSERVER);
		return RES_BREAK;
	}
	
	INIT_MSG_WITH_BUFFER(MSG_FtoA_ARENA_TEAM_MATCHING, T_FtoA_ARENA_TEAM_MATCHING, pSendMsg, SendBuf);
	pSendMsg->AccountUID				= this->m_character.AccountUniqueNumber;
	pSendMsg->AFSCharacterUID			= this->m_character.CharacterUniqueNumber;
	pSendMsg->AFSClientIndex			= this->m_character.ClientIndex;
	pSendMsg->MFSCharacterUID			= this->m_AfsNeedMfsInfo.MFSCharacterUID;
	pSendMsg->MFSClientIndex			= this->m_AfsNeedMfsInfo.MFSClientIdx;
	MFSSock->SendAddData(SendBuf, MSG_SIZE(MSG_FtoA_ARENA_TEAM_MATCHING));

//	// 2007-05-18 by cmkwon, ׽Ʈ α
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ARENA] EnterRoomWarp - TeamNum(%4d) AState(%30s) DMRoomNum(%d) CharName(%s)\r\n" 
//			, m_ArenaInfo.TeamNum, GET_ARENA_STATE_STRING(m_ArenaInfo.State), m_ArenaInfo.DeathMatchRoomNum, m_character.CharacterName);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_FINISH_WARP(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-04-24 ~ 2007-04-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_FINISH_WARP(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_ARENA_FINISH_WARP, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}	

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin, Ʒ  ARENA_STATE_WARFINISH ƴϸ ùٸ ° ƴϴ.
	if(ARENA_STATE_FIGHTING_WARFINISH != this->m_ArenaInfo.State)
	{
		SendErrorMessage(T_FC_ARENA_FINISH_WARP, ERR_ARENA_STATE, 10000, this->m_ArenaInfo.State);
		return RES_BREAK;		
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-24 by dhjin,   û óѴ.
	this->ms_pFieldIOCP->m_ArenaManager.SendDeathMatchUserWarpCity(this->m_ArenaInfo.DeathMatchRoomNum, this);

//	// 2007-05-18 by cmkwon, ׽Ʈ α
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ARENA] FinishWarp - TeamNum(%4d) AState(%30s) DMRoomNum(%d) CharName(%s)\r\n" 
//			, m_ArenaInfo.TeamNum, GET_ARENA_STATE_STRING(m_ArenaInfo.State), m_ArenaInfo.DeathMatchRoomNum, m_character.CharacterName);

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin,   
	this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberList(this->m_ArenaInfo.TeamNum);
	
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_REQUEST_CREATE_TEAMINFO(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-04-26 ~ 2007-04-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_REQUEST_CREATE_TEAMINFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter())
	{
		SendErrorMessage(T_FC_ARENA_REQUEST_CREATE_TEAMINFO, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-24 by dhjin,  ϱ  DB Ѵ.
	this->ms_pFieldIOCP->m_ArenaManager.SendCreatTeamInfo(this);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_REQUEST_OTHER_TEAM_INFO(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		   
/// \author		dhjin
/// \date		2007-05-23 ~ 2007-05-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_REQUEST_OTHER_TEAM_INFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter())
	{
		SendErrorMessage(T_FC_ARENA_REQUEST_OTHER_TEAM_INFO, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-23 by dhjin,    Ѵ.
	this->ms_pFieldIOCP->m_ArenaManager.SendOtherTeamInfo(this);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_ARENA_QUICK_ENTER_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		 û Ű   
/// \author		dhjin
/// \date		2007-06-05 ~ 2007-06-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_QUICK_ENTER_TEAM(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter())
	{
		SendErrorMessage(T_FC_ARENA_QUICK_ENTER_TEAM, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
	
	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin, Ʒ ° ƴϾ 
	if(ARENA_STATE_NONE != this->m_ArenaInfo.State)
	{
		SendErrorMessage(T_FC_ARENA_QUICK_ENTER_TEAM, ERR_ARENA_STATE);
		return RES_BREAK;		
	}
	
	//////////////////////////////////////////////////////////////////////////
	// 2007-04-26 by dhjin,   ʾ 
	if(COMPARE_INFLUENCE(this->m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		SendErrorMessage(T_FC_ARENA_QUICK_ENTER_TEAM, ERR_REQ_CHOOSE_INFLUENCE_TYPE);
		return RES_BREAK;
	}
	
	// 2012-08-24 by jhseol, Ʒ ׼ - 巹 üũ ߰
	// 2012-09-14 by jhseol, Ʒ ߰ restore -   ¿ ڽ ɸͷθ ÷ ϵ 
#ifdef S_ARENA_EX_1ST_JHSEOL
#ifndef S_ARENA_EX_1ST_RESTORE_JHSEOL
	if( this->m_character.Level < ARENA_STAGE_START_LEVEL || this->m_character.Level > ARENA_STAGE_A_END_LEVEL)
	{
		return RES_BREAK;
	}
#endif
#endif
	// end 2012-09-14 by jhseol, Ʒ ߰ restore -   ¿ ڽ ɸͷθ ÷ ϵ 
	// end 2012-08-24 by jhseol, Ʒ ׼ - 巹 üũ ߰

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-26 by dhjin, ,    Ұ
// 2008-01-03 by dhjin, Ʒ  - Ŭ̾Ʈ ó
//	if(this->ms_pFieldIOCP->m_InflWarManager.CheckSummonBossAndStrategyPoint())
//	{
//		SendErrorMessage(T_FC_ARENA_QUICK_ENTER_TEAM, ERR_BOSS_STRATEGYPOINT_STATE_SUMMON);
//		return RES_BREAK;
//	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-02 by dhjin,  ָ  ¿ û  .
// 2008-01-03 by dhjin, Ʒ  - Ǳ  Ʒ   ʴ´.
//	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
//	ITEM_GENERAL *pBCULeaderItem = m_ItemManager.GetFirstItemGeneralByItemNum(ITEM_NUM_BRIGHTNESS_OF_BCU_LEADER, ITEM_IN_CHARACTER);
//	ITEM_GENERAL *pANILeaderItem = m_ItemManager.GetFirstItemGeneralByItemNum(ITEM_NUM_BRIGHTNESS_OF_ANI_LEADER, ITEM_IN_CHARACTER);
//	if( (pBCULeaderItem && WEAR_NOT_ATTACHED != pBCULeaderItem->Wear)
//		|| (pANILeaderItem && WEAR_NOT_ATTACHED != pANILeaderItem->Wear) )
//	{
//		SendErrorMessage(T_FC_ARENA_QUICK_ENTER_TEAM, ERR_PROTOCOL_INVALID_ITEM_WINDOW_POSITION);
//		return RES_BREAK;		
//	}
//	igLock.auto_unlock_cancel();

	//////////////////////////////////////////////////////////////////////////
	// 2007-05-15 by dhjin, Ƽ  ϶  Ұ
// 2008-01-03 by dhjin, Ʒ  - üũ ƾ 
//	if (this->IsPartyBattleState())
//	{
//		SendErrorMessage(T_FC_ARENA_QUICK_ENTER_TEAM, ERR_PROTOCOL_DOING_PARTY_BATTLE);
//		return RES_BREAK;
//	}
//	
//	//////////////////////////////////////////////////////////////////////////
//	// 2007-05-15 by dhjin,  ϴ  Ұ.
//	mt_auto_lock mtGW(ms_pFieldIOCP->m_GuildWarManager.GetmtmapGuildWarPtr());
//	if (ms_pFieldIOCP->m_GuildWarManager.FindGuildWarPtr(this->GetCharacter()->GuildUniqueNumber))
//	{
//		SendErrorMessage(T_FC_ARENA_QUICK_ENTER_TEAM, ERR_PROTOCOL_DOING_GUILDWAR_BATTLE);
//		return RES_BREAK;
//	}	
//	mtGW.auto_unlock_cancel();
	
	BYTE CreateArenaMode = 0;
	BYTE CreateTeamSize = 0;
	INT CreateTeamNum = -1;
	
	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,  ߰ 
	Err_t errCode = this->ms_pFieldIOCP->m_ArenaManager.QuickInsertMember(this, &CreateArenaMode, &CreateTeamSize, &CreateTeamNum);
	if(ERR_NO_ERROR != errCode)
	{
		SendErrorMessage(T_FC_ARENA_QUICK_ENTER_TEAM, errCode);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin, Arena  
	this->m_ArenaInfo.ArenaMode =	CreateArenaMode;
	this->m_ArenaInfo.State		=	ARENA_STATE_JOINING;
	this->m_ArenaInfo.TeamNum	=	CreateTeamNum;
	this->m_ArenaInfo.ReadyButtonClickTime.SetCurrentDateTime();
	this->m_ArenaInfo.ReadyButtonClickTime.AddDateTime(0,0,0,0,0,-5);

	// 2008-01-03 by dhjin,  Ʒ  - ʵ弭 ɸ Ʒ ° 
	if(FALSE == this->SendMFSArenaStateChange(ARENA_STATE_JOINING))
	{
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,    
	INIT_MSG_WITH_BUFFER(MSG_FC_ARENA_ENTER_TEAM_OK, T_FC_ARENA_ENTER_TEAM_OK, pEnterTeamOK, SendBuf);
	pEnterTeamOK->ArenaMode		= CreateArenaMode;
	pEnterTeamOK->TeamSize		= CreateTeamSize;
	pEnterTeamOK->TeamNum		= CreateTeamNum;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_ARENA_ENTER_TEAM_OK));

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,   
	this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberList(CreateTeamNum);

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-23 by dhjin,  ° ARENA_STATE_READY̸ READY ¸ ˷ش.
	if(ARENA_STATE_READY == this->ms_pFieldIOCP->m_ArenaManager.GetTeamState(CreateTeamNum))
	{
		this->ms_pFieldIOCP->m_ArenaManager.SendTeamMemberState(CreateTeamNum, ARENA_STATE_READY);
	}

	return RES_RETURN_TRUE;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
// 2008-01-08 by dhjin, Ʒ  -

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		dhjin
/// \date		2008-01-08 ~ 2008-01-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_ARENA_CHARACTER_GAMESTART(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(FALSE == g_pFieldGlobal->IsArenaServer())
	{// 2007-12-27 by dhjin, Ʒ  ƴϸ 
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] ArenaServer is not\r\n");
		return RES_RETURN_FALSE;
	}	

// 2008-04-24 by dhjin, ٽ   ý  - 
// 	Err_t err = this->SecurityClientInit();		// 2008-04-03 by cmkwon, ٽ   ý  - 
//	if(ERR_NO_ERROR != err)
//	{
//		SendErrorMessage(T_FC_ARENA_CHARACTER_GAMESTART, err);
//		return RES_RETURN_FALSE;
//	}	

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ذ  
//		this->SetDataArenaGameStart();
	if(INFINITY_STATE_READY <= this->m_InfinityPlayingInfo.InfinityState) {
		this->SetDataInfinityGameStart();
	}
	else {
		this->SetDataArenaGameStart();

		//////////////////////////////////////////////////////////////////////////
		// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ʒ   Ǵ Ƽ û Ŷ 
#ifdef S_ARENA_EX_1ST_JHSEOL
		// 2012-08-09 by jhseol, Ʒ ߰ -    : ڴ Ƽ  ʿ䰡   ƾ 
		if( m_ArenaInfo.WatchState || m_ArenaInfo.Command )
		{
			return RES_RETURN_TRUE;
		}
		// end 2012-08-09 by jhseol, Ʒ ߰ -    : ڴ Ƽ  ʿ䰡   ƾ 
		CFieldIOCPSocket *pSock = NULL;
		EnterCriticalSection(&m_criticalLevelAndExperience);	// 2013-02-13 by jhseol, Ʒ  ũ  : ̹  ༮ Ȱ - Lock
		CArenaTeam * ArenaTeamInfo = ms_pFieldIOCP->m_ArenaManager.GetArenaTeam(this->m_ArenaInfo.TeamNum);
		if(NULL == ArenaTeamInfo)
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] ArenaTeamInfo Fine Fail!!\r\n");
			LeaveCriticalSection(&m_criticalLevelAndExperience);	// 2013-02-13 by jhseol, Ʒ  ũ  : ̹  ༮ Ȱ - unLock
			return RES_RETURN_TRUE;
		}
		vectorClientIndex * TeamMamba = ArenaTeamInfo->GetTeamList();
		if( NULL == TeamMamba )
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] TeamMamba Fine Fail!!\r\n");
			LeaveCriticalSection(&m_criticalLevelAndExperience);	// 2013-02-13 by jhseol, Ʒ  ũ  : ̹  ༮ Ȱ - unLock
			return RES_RETURN_TRUE;
		}
		vectorClientIndex::iterator itr = TeamMamba->begin();
		for(; itr != TeamMamba->end(); itr++)
		{// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : ɹ Ŭε ȣ  ã´.
			// 2012-11-27 by jhseol,  Ʒ  ٿǴ . ڵ ó ߰
			if( itr == TeamMamba->end() )
			{
				break;
			}
			// end 2012-11-27 by jhseol,  Ʒ  ٿǴ . ڵ ó ߰
			pSock = ms_pFieldIOCP->GetFieldIOCPSocket(*itr);
			if(NULL == pSock)
			{
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] TeamMamba in pSock Fine Fail!!\r\n");
				continue;
			}
			if(m_character.CharacterUniqueNumber == pSock->m_character.CharacterUniqueNumber)
			{// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : ã ɹ ڱ ڽ̸ н Ѵ.
				continue;
			}
			if(NULL != pSock->m_pFieldParty)
			{// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : ã ɹ  Ƽ ¸ Ȯ.
				if(SIZE_MAX_PARTY_MEMBER > pSock->m_pFieldParty->m_ListPartyMember.size())
				{// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ƽ  ο Ȯ. 6 ϸ  Ŷ   Ż
					INIT_MSG_WITH_BUFFER(MSG_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA, T_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA, pQuestion, pQuestionBuf);
					pQuestion->PartyID = pSock->m_pFieldParty->m_PartyID;
					//STRNCPY_MEMSET(pQuestion->MasterCharacterName, ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(pSock->m_pFieldParty->GetMasterCharacterUniqueNumber())->m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
					// 2013-05-16 by jhseol,    Ƽ - ϸ鼭 ǥ  ǴܵǾ ּó.
					SendAddData(pQuestionBuf, MSG_SIZE(MSG_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA));
					break;
				}
			}
		}
		if(itr == TeamMamba->end())
		{// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ :  ٴ°? Ƽ Ȥ   ִ Ƽ  ǹ.
			if(NULL == m_pFieldParty)
			{// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ƽ  Ƽ Ŷ .
				SPARTY_INFO PartyInfo;
				MEMSET_ZERO(&PartyInfo, sizeof(SPARTY_INFO));
				PartyInfo.ExpDistributeType			= EXP_DISTRIBUTE_TYPE_DAMAGE;
				PartyInfo.FormationType				= FLIGHT_FORM_NONE;
				PartyInfo.ItemDistributeType		= ITEM_DISTRIBUTE_TYPE_DAMAGE;
				PartyInfo.MaxLevel					= CHARACTER_MAX_LEVEL;
				PartyInfo.MinLevel					= 1;
				PartyInfo.PartyInfluence			= m_character.InfluenceType;
				PartyInfo.PartyJoinType				= PARTY_JOIN_TYPE_FREE;
				PartyInfo.PartyLock					= FALSE;
				char chPartyName[3][256]			= {STRMSG_C_080610_0200, STRMSG_C_080610_0201, STRMSG_C_080610_0202};
				int nRandIdx = rand() %3;
				if(nRandIdx <0 || nRandIdx >= 3)
				{
					nRandIdx = 0;
				}
				memcpy(PartyInfo.PartyName, chPartyName[nRandIdx], SIZE_MAX_PARTY_NAME);
				INIT_MSG_WITH_BUFFER(MSG_FC_PARTY_AUTO_CREATED_THE_ARENA, T_FC_PARTY_AUTO_CREATED_THE_ARENA, pSMsg, SendBuf);
				MEMSET_ZERO(pSMsg, sizeof(MSG_FC_PARTY_AUTO_CREATED_THE_ARENA));
				pSMsg->PartyInfo = PartyInfo;
				SendAddData(SendBuf, MSG_SIZE(MSG_FC_PARTY_AUTO_CREATED_THE_ARENA));
			}
		}
		LeaveCriticalSection(&m_criticalLevelAndExperience);	// 2013-02-13 by jhseol, Ʒ  ũ  : ̹  ༮ Ȱ - unLock
		INIT_MSG_WITH_BUFFER(MSG_FI_PARTY_ARENA_TEAM_NUM, T_FI_PARTY_ARENA_TEAM_NUM, msgArenaTeamNum, msgArenaTeamNumBuf);
		msgArenaTeamNum->TeamNum = this->m_ArenaInfo.TeamNum;
		msgArenaTeamNum->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
		ms_pFieldIOCP->m_pIMWinSocket->Write((char*)msgArenaTeamNumBuf, MSG_SIZE(MSG_FI_PARTY_ARENA_TEAM_NUM));
		// end 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ

		// 2012-06-21 by jhseol, Ʒ ߰part2 - Ʒ   ( 0 = , 1 = Ʒ )
		QPARAM_GET_QUICKSLOT *pQParam = new QPARAM_GET_QUICKSLOT;
		pQParam->AccountUID			= m_character.AccountUniqueNumber;
		pQParam->CharacterUID		= m_character.CharacterUniqueNumber;
		// 2012-09-14 by jhseol, Ʒ ߰ restore -   ¿ ڽ ɸͷθ ÷ ϵ 
#ifdef S_ARENA_EX_1ST_RESTORE_JHSEOL
		pQParam->SlotPurpose		= SLOT_PURPOSE_MAIN;
#else
		pQParam->SlotPurpose		= SLOT_PURPOSE_ARENA;
#endif	//#ifdef S_ARENA_EX_1ST_RESTORE_JHSEOL
		// end 2012-09-14 by jhseol, Ʒ ߰ restore -   ¿ ڽ ɸͷθ ÷ ϵ 
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_Get_QuickSlot,this, m_character.AccountUniqueNumber, pQParam);
		// end 2012-06-21 by jhseol, Ʒ ߰part2 - Ʒ   ( 0 = , 1 = Ʒ )
#endif
	}

//	// 2007-05-18 by cmkwon, ׽Ʈ α	
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ARENACHECK] T_FC_ARENA_CHARACTER_GAMESTART ArenaCUID = %d, CUID = %d, AUID = %d\r\n"
//		, this->m_character.CharacterUniqueNumber, 0, this->m_character.AccountUniqueNumber);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_TUTORIAL_START(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		Tutorial  
/// \author		dhjin
/// \date		2007-07-06 ~ 2007-07-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_TUTORIAL_START(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_TUTORIAL_START, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-07-06 by dhjin, Tutorial  Ѵ.
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_LoadTutorialComplete, this, 0, NULL);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			INT	CFieldIOCPSocket::MakeMSG_FC_TUTORIAL_START_OK(STUTORIAL_LIST_INFO * o_pTutorialListInfo)
/// \brief		Tutorial ޼ 
/// \author		dhjin
/// \date		2007-07-06 ~ 2007-07-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
INT	CFieldIOCPSocket::MakeMSG_FC_TUTORIAL_START_OK(STUTORIAL_LIST_INFO * o_pTutorialListInfo)
{
	INT	nTutorialListCount = 0;

	mt_auto_lock mta(&m_mtvectTutorialList);

	mtvectTutorialList::iterator itr(m_mtvectTutorialList.begin());
	for(; itr != m_mtvectTutorialList.end(); itr++)
	{
		o_pTutorialListInfo[nTutorialListCount].TutorialNum		= itr->TutorialNum;
		o_pTutorialListInfo[nTutorialListCount].TutorialComplete= itr->TutorialComplete;
		nTutorialListCount++;
	}

	return nTutorialListCount;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_TUTORIAL_COMPLETE(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		Tutorial Ϸ 
/// \author		dhjin
/// \date		2007-07-06 ~ 2007-07-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_TUTORIAL_COMPLETE(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_TUTORIAL_COMPLETE
									, MSG_FC_TUTORIAL_COMPLETE, pRMsg);

	if(!this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_TUTORIAL_COMPLETE, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}


	mt_auto_lock mta(&m_mtvectTutorialList);

	// 2007-07-09 by dhjin, Ϸ  
	STUTORIAL_LIST_INFO *pTutorialData = this->GetTutorialDataNoLock(pRMsg->TutorialNum);
	if(NULL == pTutorialData)
	{
		SendErrorMessage(T_FC_TUTORIAL_COMPLETE, ERR_INVALID_TUTORIAL);
		return RES_BREAK;
	}
	BOOL bAlreadyCompleted	= FALSE;	// 2007-07-18 by dhjin, Tutorial Ϸ üũ  
	if(pTutorialData->TutorialComplete)
	{// ̹ Ϸ  üũ
		bAlreadyCompleted	= TRUE;
	}
	pTutorialData->TutorialComplete = TRUE;		// 2007-07-23 by cmkwon, 
	mta.auto_unlock_cancel();					// 2007-07-23 by cmkwon, ߰

	// 2007-07-06 by dhjin, Ϸ  
	INIT_MSG_WITH_BUFFER(MSG_FC_TUTORIAL_COMPLETE_OK, T_FC_TUTORIAL_COMPLETE_OK, pTutorialComplete, SendBuf);
	pTutorialComplete->TutorialNum		= pRMsg->TutorialNum;

	if(bAlreadyCompleted)
	{// 2007-07-18 by dhjin, ̹ Ϸߴٸ  , α׸  ʴ´.
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_TUTORIAL_COMPLETE_OK));
		return RES_RETURN_TRUE;
	}

	// 2007-07-23 by cmkwon,   - Tutorial Ϸ ȣ ޵  ã Ѵ.
	STUTORIAL_INFO *pTutorialInfo = ms_pFieldIOCP->GetTutorialInfo(pRMsg->TutorialNum);
	if(pTutorialInfo)
	{
		if(0 < pTutorialInfo->TutorialPayItem1 && 0 < pTutorialInfo->TutorialPayItemCount1)
		{
			if(this->m_ItemManager.InsertItemBaseByItemNum(pTutorialInfo->TutorialPayItem1, pTutorialInfo->TutorialPayItemCount1, IUT_TUTORIAL_PAY_ITEM))
			{
				pTutorialComplete->TutorialItemNum1		= pTutorialInfo->TutorialPayItem1;
				pTutorialComplete->TutorialItemCount1	= pTutorialInfo->TutorialPayItemCount1;
			}
		}
		if(0 < pTutorialInfo->TutorialPayItem2 && 0 < pTutorialInfo->TutorialPayItemCount2)
		{
			if(this->m_ItemManager.InsertItemBaseByItemNum(pTutorialInfo->TutorialPayItem2, pTutorialInfo->TutorialPayItemCount2, IUT_TUTORIAL_PAY_ITEM))
			{
				pTutorialComplete->TutorialItemNum2		= pTutorialInfo->TutorialPayItem2;
				pTutorialComplete->TutorialItemCount2	= pTutorialInfo->TutorialPayItemCount2;
			}
		}
		if(0 < pTutorialInfo->TutorialPayItem3 && 0 < pTutorialInfo->TutorialPayItemCount3)
		{
			if(this->m_ItemManager.InsertItemBaseByItemNum(pTutorialInfo->TutorialPayItem3, pTutorialInfo->TutorialPayItemCount3, IUT_TUTORIAL_PAY_ITEM))
			{
				pTutorialComplete->TutorialItemNum3		= pTutorialInfo->TutorialPayItem3;
				pTutorialComplete->TutorialItemCount3	= pTutorialInfo->TutorialPayItemCount3;
			}
		}
	}
	
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_TUTORIAL_COMPLETE_OK));

	// 2007-07-06 by dhjin, α׸ .
	CAtumLogSender::SendLogMessageTutorialCOMPLETION(this, pRMsg->TutorialNum);

	// 2007-07-06 by dhjin, Tutorial Ϸ DB Ʈ 
	QPARAM_INSERT_TUTORIAL_COMPLETE *pQParam = new QPARAM_INSERT_TUTORIAL_COMPLETE;
	pQParam->CharacterUID		= this->m_character.CharacterUniqueNumber;
	pQParam->TutorialUID		= pRMsg->TutorialNum;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_InsertTutorialComplete, this, m_character.AccountUniqueNumber, pQParam);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_TUTORIAL_END(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		Tutorial 
/// \author		dhjin
/// \date		2007-07-06 ~ 2007-07-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_TUTORIAL_END(const char* pPacket, int nLength, int &nBytesUsed)
{
	// 2007-07-06 by dhjin,  ó Ϸ ޼ 
	this->SendAddMessageType(T_FC_TUTORIAL_END_OK);

	// 2007-07-06 by dhjin,  
	this->WarpToCityMap();

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_TUTORIAL_WARP(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-07-16 ~ 2007-07-16
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_TUTORIAL_WARP(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter())
	{
		SendErrorMessage(T_FC_TUTORIAL_WARP, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	// 2007-07-06 by dhjin, Tutorial  
	this->WarpToMap(TUTORIAL_MAP_INDEX, 0);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_OUTPOST_RESET_CHECK_START(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-20 ~ 2007-08-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
//ProcessResult CFieldIOCPSocket::Process_FC_OUTPOST_RESET_CHECK_START(const char* pPacket, int nLength, int &nBytesUsed)
//{
//	if(!this->IsValidCharacter())
//	{// 2007-08-20 by dhjin, ȿ  üũ 
//		SendErrorMessage(T_FC_OUTPOST_RESET_CHECK_START, ERR_INVALID_CHARACTER);
//		return RES_BREAK;
//	}
//
//	if(!ms_pFieldIOCP->m_GuildWarManager.CheckGuildCommander(m_character.CharacterUniqueNumber))
//	{// 2007-08-20 by dhjin,  üũ 
//		SendErrorMessage(T_FC_OUTPOST_RESET_CHECK_START, ERR_PROTOCOL_NOT_GUILD_MASTER);
//		return RES_BREAK;		
//	}
//
//	if(!ms_pFieldIOCP->m_OutPostManager.CheckResetValidGuildUID(m_character.MapChannelIndex.MapIndex, m_character.GuildUniqueNumber))
//	{// 2007-08-20 by dhjin,    üũ 
//		SendErrorMessage(T_FC_OUTPOST_RESET_CHECK_START, ERR_PROTOCOL_GUILD_NOT_MATCHED);
//		return RES_BREAK;
//	}
//
//	this->SendAddMessageType(T_FC_OUTPOST_RESET_CHECK_START_OK);
//
//	return RES_RETURN_TRUE;
//}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_OUTPOST_RESET_START(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-20 ~ 2007-08-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_OUTPOST_RESET_START(const char* pPacket, int nLength, int &nBytesUsed)
{	
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_OUTPOST_RESET_START
									, MSG_FC_OUTPOST_RESET_START, pRMsg);

	CFieldMonster	*pMonster = m_pCurrentFieldMapChannel->GetFieldMonster(pRMsg->TargetIndex, 3);
	if(NULL == pMonster
		|| (BELL_OUTPOST_RESET_VCN != pMonster->MonsterInfoPtr->Belligerence
			&& BELL_OUTPOST_RESET_ANI != pMonster->MonsterInfoPtr->Belligerence))
	{// 2007-09-10 by dhjin,  ߾ ó ġ ƴϸ 
		SendErrorMessage(T_FC_OUTPOST_RESET_START, ERR_PROTOCOL_REQ_MONSTER_NOT_MATCHED);
		return RES_BREAK;
	}

	// 2007-08-20 by dhjin, T_FC_OUTPOST_RESET_CHECK_START üũ κ    üũѴ.
	if(!this->IsValidCharacter())
	{// 2007-08-20 by dhjin, ȿ  üũ 
		SendErrorMessage(T_FC_OUTPOST_RESET_START, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	if(!ms_pFieldIOCP->m_OutPostManager.CheckResetValidGuildUID(m_character.MapChannelIndex.MapIndex, m_character.GuildUniqueNumber))
	{// 2007-08-20 by dhjin,    üũ 
		SendErrorMessage(T_FC_OUTPOST_RESET_START, ERR_PROTOCOL_GUILD_NOT_MATCHED);
		return RES_BREAK;
	}

	if(!ms_pFieldIOCP->m_GuildWarManager.CheckGuildCommander(m_character.CharacterUniqueNumber))
	{// 2007-08-20 by dhjin,  üũ 
		SendErrorMessage(T_FC_OUTPOST_RESET_START, ERR_PROTOCOL_NOT_GUILD_MASTER);
		return RES_BREAK;		
	}	

	// 2007-10-16 by cmkwon, α ߰ - SendOutPostResetStartByGuildCommander() Լ  
	if(this->ms_pFieldIOCP->m_OutPostManager.SendOutPostResetStartByGuildCommander(m_character.MapChannelIndex.MapIndex, m_character.GuildUniqueNumber, m_character.CharacterUniqueNumber))
	{
		// 2007-09-10 by dhjin, ߾ó ġ ٵ ٲ۴.
		CLEAR_BODYCON_BIT(pMonster->BodyCondition, BODYCON_MON_BUILDED);			// 2007-09-20 by cmkwon, ڷƮ  - 
		SET_BODYCON_BIT(pMonster->BodyCondition,  BODYCON_MON_BUILDING);
		this->m_pCurrentFieldMapChannel->FieldSendMonsterChangeInfo(pMonster, T_FN_MONSTER_CHANGE_BODYCONDITION);
		this->m_pCurrentFieldMapChannel->FieldSendMonsterChangeInfo(pMonster, T_FC_MONSTER_CHANGE_BODYCONDITION);
		m_pCurrentFieldMapChannel->m_ChangeBodyConMonsterIndex	=	pRMsg->TargetIndex;
	}

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_OUTPOST_NEXTWAR_INFO_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-22 ~ 2007-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_OUTPOST_NEXTWAR_INFO_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(!this->IsValidCharacter())
	{// 2007-08-28 by dhjin, ȿ  üũ 
		SendErrorMessage(T_FC_OUTPOST_NEXTWAR_INFO_REQUEST, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	BOOL	CheckGuildCommander = FALSE;

	if(ms_pFieldIOCP->m_CityLeader.CheckIsValidCharacter(m_character.MapChannelIndex.MapIndex, m_character.CharacterUniqueNumber))
	{// 2007-08-28 by dhjin,    üũ 
		CheckGuildCommander = TRUE;
	}
	
	BYTE	SendMsg[SIZE_MAX_PACKET];
	MEMSET_ZERO(SendMsg,SIZE_MAX_PACKET);
	INT		SendBuf = 0;
	ms_pFieldIOCP->m_OutPostManager.MakeMsgOutPostNextWarInfoRequest(m_character.MapChannelIndex.MapIndex, CheckGuildCommander, SendMsg, &SendBuf);
	this->SendAddData(SendMsg, SendBuf);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_OUTPOST_NEXTWAR_SET_TIME(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-22 ~ 2007-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_OUTPOST_NEXTWAR_SET_TIME(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_OUTPOST_NEXTWAR_SET_TIME
									, MSG_FC_OUTPOST_NEXTWAR_SET_TIME, pRMsg);

	if(!this->IsValidCharacter())
	{// 2007-08-28 by dhjin, ȿ  üũ 
		SendErrorMessage(T_FC_OUTPOST_NEXTWAR_SET_TIME, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	if(!ms_pFieldIOCP->m_CityLeader.CheckIsValidCharacter(m_character.MapChannelIndex.MapIndex, m_character.CharacterUniqueNumber))
	{// 2007-08-28 by dhjin,    üũ 
		SendErrorMessage(T_FC_OUTPOST_NEXTWAR_SET_TIME, ERR_PROTOCOL_GUILD_NOT_MATCHED);
		return RES_BREAK;
	}

	// 2007-08-28 by dhjin,   ð . // 2007-11-05 by dhjin, OutPostNextWarTimeSetByChoiceUserW() Լ 
	// 2007-10-16 by cmkwon, α ߰ - OutPostNextWarTimeSetW() Լ  
	Err_t errCode = ms_pFieldIOCP->m_OutPostManager.OutPostNextWarTimeSetByChoiceUserW(m_character.MapChannelIndex.MapIndex, pRMsg->OutPostNextWarSelectTimeChoice, m_character.GuildUniqueNumber, m_character.CharacterUniqueNumber);
	if(ERR_NO_ERROR != errCode)
	{
		SendErrorMessage(T_FC_OUTPOST_NEXTWAR_SET_TIME, errCode);
		return RES_BREAK;
	}

	// 2007-08-28 by dhjin,   ð   .
	BYTE	SendMsg[SIZE_MAX_PACKET];
	MEMSET_ZERO(SendMsg,SIZE_MAX_PACKET);
	INT		SendBuf = 0;
	ms_pFieldIOCP->m_OutPostManager.MakeMsgOutPostNextWarInfoRequest(m_character.MapChannelIndex.MapIndex, TRUE, SendMsg, &SendBuf);
	this->SendAddData(SendMsg, SendBuf);

	// 2007-09-06 by dhjin,    ð     Ѵ.
	INIT_MSG_WITH_BUFFER(MSG_FC_OUTPOST_NEXTWAR_SET_TIME_OK, T_FC_OUTPOST_NEXTWAR_SET_TIME_OK, SendMsg2, SendBuf2);
	SendMsg2->MapIndex				= m_character.MapChannelIndex.MapIndex;
	SendMsg2->OutPostNextWarTime	= *(ms_pFieldIOCP->m_OutPostManager.GetOutPostNextWarTimeByCityMapIndex(m_character.MapChannelIndex.MapIndex));
	this->ms_pFieldIOCP->SendMessageToAllClients(SendBuf2, MSG_SIZE(MSG_FC_OUTPOST_NEXTWAR_SET_TIME_OK),INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI);

	return RES_RETURN_TRUE;
}

//////////////////////////////////////////////////////////////////////////
// 2007-08-22 by dhjin, Notice

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_INFO_NOTICE_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-22 ~ 2007-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_NOTICE_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_NOTICE_REQUEST
									, MSG_FC_INFO_NOTICE_REQUEST, pRMsg);

	if(!this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_INFO_NOTICE_REQUEST, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_INFO_NOTICE_REQUEST_OK, T_FC_INFO_NOTICE_REQUEST_OK, pSendMsg, Sendbuf);
	if(NULL != ms_pFieldIOCP->m_CityLeader.GetNotice(pRMsg->MapIndex))
	{
		STRNCPY_MEMSET(pSendMsg->NoticeString, ms_pFieldIOCP->m_CityLeader.GetNotice(pRMsg->MapIndex), SIZE_MAX_NOTICE);	
	}
	this->SendAddData(Sendbuf, MSG_SIZE(MSG_FC_INFO_NOTICE_REQUEST_OK));

	// 2007-09-14 by dhjin,   ð ,   ٽ  . 
	BYTE	SendMsg2[SIZE_MAX_PACKET];
	MEMSET_ZERO(SendMsg2,SIZE_MAX_PACKET);
	INT		SendBuf2 = 0;
	ms_pFieldIOCP->m_OutPostManager.MakeMsgOutPostNextWarInfoRequest(2004, FALSE, SendMsg2, &SendBuf2);
	this->SendAddData(SendMsg2, SendBuf2);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_INFO_NOTICE_REG(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-22 ~ 2007-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_NOTICE_REG(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_NOTICE_REG
									, MSG_FC_INFO_NOTICE_REG, pRMsg);
 	
	if(!this->IsValidCharacter()
		|| pRMsg->GuildUID != m_character.GuildUniqueNumber
		|| FALSE == ms_pFieldIOCP->m_CityLeader.CheckIsValidCharacter(m_character.MapChannelIndex.MapIndex, m_character.CharacterUniqueNumber))
	{/// 2007-08-22 by dhjin, ȿ  üũ 
		SendErrorMessage(T_FC_INFO_NOTICE_REG, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	// 2007-08-22 by dhjin,  
	this->ms_pFieldIOCP->m_CityLeader.SetNotice(m_character.MapChannelIndex.MapIndex, m_character.CharacterUniqueNumber, pRMsg->NoticeString);

	// 2007-08-22 by dhjin, DB  
	QPARAM_REG_NOTICE *pQParam	= new QPARAM_REG_NOTICE;
	pQParam->MapIndex			= m_character.MapChannelIndex.MapIndex;
	pQParam->CharacterUID		= m_character.CharacterUniqueNumber;
	if(NULL == pRMsg->NoticeString)
	{
		MEMSET_ZERO(pQParam->Notice, SIZE_MAX_NOTICE);
	}
	else
	{
		STRNCPY_MEMSET(pQParam->Notice, pRMsg->NoticeString, SIZE_MAX_NOTICE);
	}
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_RegNotice, NULL, NULL, pQParam);
	
	this->SendAddMessageType(T_FC_INFO_NOTICE_REG_OK);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_INFO_NOTICE_MODIFY(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-22 ~ 2007-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_NOTICE_MODIFY(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_NOTICE_MODIFY
									, MSG_FC_INFO_NOTICE_MODIFY, pRMsg);
	
	if(!this->IsValidCharacter()
		|| pRMsg->GuildUID != m_character.GuildUniqueNumber
		|| FALSE == ms_pFieldIOCP->m_CityLeader.CheckIsValidCharacter(m_character.MapChannelIndex.MapIndex, m_character.CharacterUniqueNumber))
	{/// 2007-08-22 by dhjin, ȿ  üũ 
		SendErrorMessage(T_FC_INFO_NOTICE_MODIFY, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	// 2007-08-22 by dhjin,  
	this->ms_pFieldIOCP->m_CityLeader.SetNotice(m_character.MapChannelIndex.MapIndex, m_character.CharacterUniqueNumber, pRMsg->NoticeString);

	// 2007-08-22 by dhjin, DB  
	QPARAM_MODIFY_NOTICE *pQParam	= new QPARAM_MODIFY_NOTICE;
	pQParam->MapIndex			= m_character.MapChannelIndex.MapIndex;
	pQParam->CharacterUID		= m_character.CharacterUniqueNumber;
	if(NULL == pRMsg->NoticeString)
	{
		MEMSET_ZERO(pQParam->Notice, SIZE_MAX_NOTICE);
	}
	else
	{
		STRNCPY_MEMSET(pQParam->Notice, pRMsg->NoticeString, SIZE_MAX_NOTICE);
	}
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ModifyNotice, NULL, NULL, pQParam);
	
	this->SendAddMessageType(T_FC_INFO_NOTICE_MODIFY_OK);
	
	return RES_RETURN_TRUE;
}


//////////////////////////////////////////////////////////////////////////
// 2007-08-22 by dhjin, ǰ

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_INFO_EXPEDIENCYFUND_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-22 ~ 2007-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_EXPEDIENCYFUND_REQUEST(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_EXPEDIENCYFUND_REQUEST
									, MSG_FC_INFO_EXPEDIENCYFUND_REQUEST, pRMsg);
	
	if(!this->IsValidCharacter()
		|| FALSE == ms_pFieldIOCP->m_CityLeader.CheckIsValidCharacter(pRMsg->MapIndex, m_character.CharacterUniqueNumber))
	{/// 2007-08-22 by dhjin, ȿ  üũ 
		SendErrorMessage(T_FC_INFO_EXPEDIENCYFUND_REQUEST, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	SCITYLEADER_INFO	tmCityLeaderInfo;
	MEMSET_ZERO(&tmCityLeaderInfo, sizeof(SCITYLEADER_INFO));
	this->ms_pFieldIOCP->m_CityLeader.GetExpediencyfund(pRMsg->MapIndex, &tmCityLeaderInfo);

	INIT_MSG_WITH_BUFFER(MSG_FC_INFO_EXPEDIENCYFUND_REQUEST_OK, T_FC_INFO_EXPEDIENCYFUND_REQUEST_OK, pSendMsg, Sendbuf);
	pSendMsg->ExpediencyFund			= tmCityLeaderInfo.ExpediencyFund;
	pSendMsg->ExpediencyFundRate		= tmCityLeaderInfo.ExpediencyFundRate;
	pSendMsg->CumulativeExpediencyFund	= tmCityLeaderInfo.ExpediencyFundCumulative;
	this->SendAddData(Sendbuf, MSG_SIZE(MSG_FC_INFO_EXPEDIENCYFUND_REQUEST_OK));

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_INFO_EXPEDIENCYFUND_PAYBACK(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		dhjin
/// \date		2007-08-22 ~ 2007-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_EXPEDIENCYFUND_PAYBACK(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_EXPEDIENCYFUND_PAYBACK
									, MSG_FC_INFO_EXPEDIENCYFUND_PAYBACK, pRMsg);
	
	if(0 >= pRMsg->ExpediencyFundPayBackCount
		|| MAX_ITEM_COUNTS <= pRMsg->ExpediencyFundPayBackCount)
	{// 2007-10-05 by cmkwon,  üũ
		SendErrorMessage(T_FC_INFO_EXPEDIENCYFUND_PAYBACK, ERR_DB_INVALID_PARAMETER);
		return RES_BREAK;
	}

	if(!this->IsValidCharacter()
		|| FALSE == ms_pFieldIOCP->m_CityLeader.CheckIsValidCharacter(m_character.MapChannelIndex.MapIndex, m_character.CharacterUniqueNumber))
	{/// 2007-08-22 by dhjin, ȿ  üũ 
		SendErrorMessage(T_FC_INFO_EXPEDIENCYFUND_PAYBACK, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}	

	SCITYLEADER_INFO	tmCityLeaderInfo;
	MEMSET_ZERO(&tmCityLeaderInfo, sizeof(SCITYLEADER_INFO));
	this->ms_pFieldIOCP->m_CityLeader.GetExpediencyfund(m_character.MapChannelIndex.MapIndex, &tmCityLeaderInfo);
	if(tmCityLeaderInfo.ExpediencyFund < pRMsg->ExpediencyFundPayBackCount)
	{// 2007-08-22 by dhjin, ã ǰ  ũ 
		SendErrorMessage(T_FC_INFO_EXPEDIENCYFUND_PAYBACK, ERR_OVER_COUNT);
		return RES_BREAK;
	}

	// 2007-08-22 by dhjin, ǰ  
	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);

	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if(NULL == pMoney)
	{// 2006-10-16 by cmkwon, SPI    ߰
		m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		SendErrorMessage(T_FC_INFO_EXPEDIENCYFUND_PAYBACK, ERR_PROTOCOL_NOT_ENOUGH_MONEY);
		return RES_BREAK;
	}

	INT64 n64CurCnt		= pMoney->CurrentCount;
	if(MAX_ITEM_COUNTS < n64CurCnt + pRMsg->ExpediencyFundPayBackCount)
	{// 2007-10-05 by cmkwon, ִ  üũ
		SendErrorMessage(T_FC_INFO_EXPEDIENCYFUND_PAYBACK, ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER);
		return RES_BREAK;
	}
	
	CAtumLogSender::SendLogMessageITEMSPI(this, pMoney, IUT_EXPEDIENCYFUND_PAYBACK, pRMsg->ExpediencyFundPayBackCount, max(0, pMoney->CurrentCount+pRMsg->ExpediencyFundPayBackCount));
	m_ItemManager.UpdateItemCountByPointer(pMoney, pRMsg->ExpediencyFundPayBackCount, IUT_EXPEDIENCYFUND_PAYBACK);
	
	igLock.auto_unlock_cancel();

	// 2007-08-22 by dhjin, ǰ û ó
	Err_t errCode = ms_pFieldIOCP->m_CityLeader.PayBackExpediencyfund(m_character.MapChannelIndex.MapIndex, m_character.CharacterUniqueNumber, pRMsg->ExpediencyFundPayBackCount, &tmCityLeaderInfo);
	if(ERR_NO_ERROR != errCode)
	{
		SendErrorMessage(T_FC_INFO_EXPEDIENCYFUND_PAYBACK, errCode);
		return RES_BREAK;
	}

	// 2007-08-22 by dhjin, ǰ ȯ  DB Ʈ
	QPARAM_SET_EXPEDIENCY_FUNDPAYBACK *pQParam	= new QPARAM_SET_EXPEDIENCY_FUNDPAYBACK;
	pQParam->MapIndex				= tmCityLeaderInfo.MapIndex;
	pQParam->Influence				= tmCityLeaderInfo.Influence;
	pQParam->CharacterUID			= tmCityLeaderInfo.CharacterUID;
	pQParam->ExpediencyFund			= tmCityLeaderInfo.ExpediencyFund;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_SetExpediencyFundPayBack, NULL, NULL, pQParam);

	// 2007-08-22 by dhjin, ǰ ȯ  
	INIT_MSG_WITH_BUFFER(MSG_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK, T_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK, pSendMsg, Sendbuf);
	pSendMsg->ExpediencyFund			= tmCityLeaderInfo.ExpediencyFund;
	pSendMsg->ExpediencyFundRate		= tmCityLeaderInfo.ExpediencyFundRate;
	pSendMsg->CumulativeExpediencyFund	= tmCityLeaderInfo.ExpediencyFundCumulative;
	pSendMsg->ExpediencyFundPayBackCount= pRMsg->ExpediencyFundPayBackCount;
	this->SendAddData(Sendbuf, MSG_SIZE(MSG_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK));

	// 2007-10-02 by dhjin, ǰ ȯ  α 
	// 2007-10-16 by cmkwon, α ߰ -
	CAtumLogSender::SendLogMessageExpediencyFund(this, m_character.MapChannelIndex.MapIndex, FALSE, pRMsg->ExpediencyFundPayBackCount, tmCityLeaderInfo.ExpediencyFundRate, tmCityLeaderInfo.ExpediencyFund);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		// 2007-09-12 by cmkwon, Ʈ 2н  - Լ ߰
/// \author		cmkwon
/// \date		2007-09-12 ~ 2007-09-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD
									, MSG_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD, pRMsg);

	if(FALSE == this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
	if(FALSE == g_pFieldGlobal->GetUseSecondaryPasswordSystemFlag())
	{
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD, ERR_SECPASS_NOT_USE_SYSTEM);
		return RES_BREAK;
	}

// 2007-09-28 by cmkwon, NewSecPassword NULL̸ 2н ϴ 
//	if(0 == strncmp(pRMsg->NewSecPassword, "", SIZE_MAX_PASSWORD_MD5_STRING))
//	{// 2007-09-12 by cmkwon, ο н尡  Ǿ  
//		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD, ERR_SECPASS_NEW_PASSWORD_NOT_SETTING);
//		return RES_BREAK;
//	}

	if(FALSE != IsSettingSecondaryPassword())
	{// 2007-09-12 by cmkwon, 2н尡 Ǿ ִ

		if(FALSE == CompareSecondaryPassword(pRMsg->CurrentSecPassword))
		{// 2007-09-12 by cmkwon,  2н尡 ٸ
			
			SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD, ERR_SECPASS_PASSWORD_NOT_MATCHED);
			return RES_BREAK;
		}		
	}
	
	///////////////////////////////////////////////////////////////////////////////
	QPARAM_UPDATE_SECONDARY_PASSWORD *pQParam = new QPARAM_UPDATE_SECONDARY_PASSWORD;
	pQParam->AccountUID	= m_character.AccountUniqueNumber;
	STRNCPY_MEMSET(pQParam->NewSecPassword, pRMsg->NewSecPassword, SIZE_MAX_PASSWORD_MD5_STRING);
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateSecondaryPassword, this, m_character.AccountUniqueNumber, pQParam);
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		// 2007-09-12 by cmkwon, Ʈ 2н  - Լ ߰
/// \author		cmkwon
/// \date		2007-09-12 ~ 2007-09-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD
									, MSG_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD, pRMsg);

	if(FALSE == g_pFieldGlobal->GetUseSecondaryPasswordSystemFlag())
	{
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD, ERR_SECPASS_NOT_USE_SYSTEM);
		return RES_BREAK;
	}

	if(FALSE == IsSettingSecondaryPassword())
	{// 2007-09-12 by cmkwon, 2н尡   
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD, ERR_SECPASS_PASSWORD_NOT_SETTING);
		return RES_BREAK;
	}
		
	if(FALSE == CompareSecondaryPassword(pRMsg->CurrentSecPassword))
	{
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD, ERR_SECPASS_PASSWORD_NOT_MATCHED);
		return RES_BREAK;
	}
	
	this->SendAddMessageType(T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD_OK);	
	return RES_RETURN_TRUE;
}



///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FC_INFO_SECONDARYPASSWORD_LOCK(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		// 2007-09-12 by cmkwon, Ʈ 2н  - Լ ߰
/// \author		cmkwon
/// \date		2007-09-12 ~ 2007-09-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_SECONDARYPASSWORD_LOCK(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_SECONDARYPASSWORD_LOCK
									, MSG_FC_INFO_SECONDARYPASSWORD_LOCK, pRMsg);

	if(FALSE == this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_LOCK, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}

	if(FALSE == g_pFieldGlobal->GetUseSecondaryPasswordSystemFlag())
	{
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_LOCK, ERR_SECPASS_NOT_USE_SYSTEM);
		return RES_BREAK;
	}

	if(FALSE == IsSettingSecondaryPassword())
	{// 2007-09-12 by cmkwon, 2н尡   
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_LOCK, ERR_SECPASS_PASSWORD_NOT_SETTING);
		return RES_BREAK;
	}

	if(FALSE == m_bUnlockSecondaryPassword && FALSE == pRMsg->bIsUnlockFlag)
	{// 2007-09-12 by cmkwon,  Lockε Lock û Ѵ.
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_LOCK, ERR_SECPASS_ALREADY_LOCK);
		return RES_BREAK;
	}

	if(m_bUnlockSecondaryPassword && pRMsg->bIsUnlockFlag)
	{// 2007-09-12 by cmkwon,  Unlockε Unlock û Ѵ.
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_LOCK, ERR_SECPASS_ALREADY_UNLOCK);
		return RES_BREAK;
	}

	if(FALSE == CompareSecondaryPassword(pRMsg->CurrentSecPassword))
	{
		SendErrorMessage(T_FC_INFO_SECONDARYPASSWORD_LOCK, ERR_SECPASS_PASSWORD_NOT_MATCHED);
		return RES_BREAK;
	}

	m_bUnlockSecondaryPassword	= pRMsg->bIsUnlockFlag;			// 2007-09-18 by cmkwon, Lock/Unlock Ѵ.
	
	INIT_MSG_WITH_BUFFER(MSG_FC_INFO_SECONDARYPASSWORD_LOCK_OK, T_FC_INFO_SECONDARYPASSWORD_LOCK_OK, pSendMsg, Sendbuf);
	pSendMsg->bIsUnlockFlag		= pRMsg->bIsUnlockFlag;
	this->SendAddData(Sendbuf, MSG_SIZE(MSG_FC_INFO_SECONDARYPASSWORD_LOCK_OK));
	
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn		ProcessResult CFieldIOCPSocket::Process_FC_INFO_GET_GUILDMARK(const char* pPacket, int nLength, int &nBytesUsed)	
/// \brief		
/// \author		dhjin
/// \date		2007-12-07 ~ 2007-12-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FC_INFO_GET_GUILDMARK(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FC_INFO_GET_GUILDMARK
									, MSG_FC_INFO_GET_GUILDMARK, pRMsg);

	if(FALSE == this->IsValidCharacter(FALSE))
	{
		SendErrorMessage(T_FC_INFO_GET_GUILDMARK, ERR_INVALID_CHARACTER);
		return RES_BREAK;
	}
	
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_GetGuildMark, this, 0, NULL, NULL, pRMsg->GuildUID);

	return RES_RETURN_TRUE;
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

ProcessResult CFieldIOCPSocket::Process_FN_MAPPROJECT_START(const char* pPacket, int nLength, int &nBytesUsed)
{
	if(NULL == m_pFieldMapProjectForNPC)
	{
		char	szSystemLog[256];
		sprintf(szSystemLog, "[ERROR] CFieldIOCPSocket::OnRecvdPacketFieldServer invalid variable, MapProject[%#08x] Index[%d]\r\n"
			, m_pFieldMapProjectForNPC, this->GetClientArrayIndex());
		g_pFieldGlobal->WriteSystemLog(szSystemLog);
		DBGOUT(szSystemLog);
		return RES_RETURN_FALSE;
	}

	// 2009-03-26 by cmkwon, ý α ߰ - 
	g_pGlobal->WriteSystemLogEX(TRUE, "  [Notify] UDP Socket ready for NPC Server!! MapIndex(%d) SockIdx(%4d) \r\n", m_pFieldMapProjectForNPC->m_nMapIndex, this->GetClientArrayIndex());

	m_pFieldMapProjectForNPC->ResetAllChannel();
	this->SetPeerUDPReady(TRUE);
	m_PeerSocketType = ST_NPC_SERVER;

	INIT_MSG_WITH_BUFFER(MSG_FN_MAPPROJECT_START_OK, T_FN_MAPPROJECT_START_OK, pSendStartOK, SendBuf);	
	MSG_FN_CONNECT_SET_CHANNEL_STATE *pChannelState = (MSG_FN_CONNECT_SET_CHANNEL_STATE*)(SendBuf + MSG_SIZE(MSG_FN_MAPPROJECT_START_OK));
	int nChannelCounts = 0;
	m_pFieldMapProjectForNPC->MakeMsg_AllChannelState(&nChannelCounts, pChannelState);
	pSendStartOK->CreateChannelCounts	= nChannelCounts;
	pSendStartOK->bCityWarStarted		= FALSE;
	pSendStartOK->CityWarOccupyGuildUID	= INVALID_GUILD_UID;
	if(m_pFieldMapProjectForNPC->m_pRefCityWar2
		&& IS_CITYWAR_MAP_INDEX(m_pFieldMapProjectForNPC->m_nMapIndex))
	{
		pSendStartOK->CityWarOccupyGuildUID = m_pFieldMapProjectForNPC->m_pRefCityWar2->m_OccupyCITY_WAR_DATAWhenWarStarted.GuildUID1;
		if(CITYWAR_STATE_STARTED == m_pFieldMapProjectForNPC->m_pRefCityWar2->GetCityWarState())
		{
			pSendStartOK->bCityWarStarted = TRUE;;
		}		
	}
	SendAddData(SendBuf, MSG_SIZE(MSG_FN_MAPPROJECT_START_OK) + pSendStartOK->CreateChannelCounts*sizeof(MSG_FN_CONNECT_SET_CHANNEL_STATE));
	return RES_RETURN_TRUE;
}


ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_CREATE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize	= 0;
	MSG_FN_MONSTER_CREATE	*pRecvFMCreate = NULL;

	nRecvTypeSize = sizeof(MSG_FN_MONSTER_CREATE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_CREATE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14057);
		return RES_RETURN_FALSE;
	}
	pRecvFMCreate = (MSG_FN_MONSTER_CREATE*)(pPacket+nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterCreateW(pRecvFMCreate);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_MOVE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize	= 0;
	MSG_FN_MONSTER_MOVE		*pRecvFCMove = NULL;

	nRecvTypeSize = sizeof(MSG_FN_MONSTER_MOVE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_MOVE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14058);
		return RES_RETURN_FALSE;
	}
	pRecvFCMove = (MSG_FN_MONSTER_MOVE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterMoveW(pRecvFCMove);

	// check: Ŭ̾Ʈ ֱ ,   ϱ, 20031114, kelovon
	//		//   ó
	//		CheckMineAttackMonster(pMonster);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_GET_CHARACTER_INFO(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize	= 0;
	MSG_FN_GET_CHARACTER_INFO		*pRecvCharacterInfo = NULL;

	nRecvTypeSize = sizeof(MSG_FN_GET_CHARACTER_INFO);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_GET_CHARACTER_INFO, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1405A);
		return RES_RETURN_FALSE;
	}
	pRecvCharacterInfo = (MSG_FN_GET_CHARACTER_INFO*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnGetCharacterInfoW(pRecvCharacterInfo);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_DELETE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize	= 0;
	MSG_FN_MONSTER_DELETE		*pRecvMonsterDele = NULL;

	nRecvTypeSize = sizeof(MSG_FN_MONSTER_DELETE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_DELETE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1405B);
		return RES_RETURN_FALSE;
	}
	pRecvMonsterDele = (MSG_FN_MONSTER_DELETE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterDeleteW(pRecvMonsterDele);
	return RES_RETURN_TRUE;
}

// start 2011-05-11 by hskim, ǴƼ 3 - ó׸   ߰ - ش ä Ư    ߰
ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_CHANGE_OK(const char* pPacket, int nLength, int &nBytesUsed)
{
	int nRecvTypeSize	= 0;
	MSG_FN_MONSTER_CHANGE_OK *pRecvMonsterChange = NULL;

	nRecvTypeSize = sizeof(MSG_FN_MONSTER_CHANGE_OK);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_CHANGE_OK, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1405F);
		return RES_RETURN_FALSE;
	}
	pRecvMonsterChange = (MSG_FN_MONSTER_CHANGE_OK*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterChangeOkW(pRecvMonsterChange);
	return RES_RETURN_TRUE;
}
// end 2011-05-11 by hskim, ǴƼ 3 - ó׸   ߰ - ش ä Ư    ߰

ProcessResult CFieldIOCPSocket::Process_FN_MISSILE_MOVE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize = 0;
	MSG_FN_MISSILE_MOVE		*pRecvMissileMove = NULL;

	nRecvTypeSize = sizeof(MSG_FN_MISSILE_MOVE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MISSILE_MOVE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1405C);
		return RES_RETURN_FALSE;
	}
	pRecvMissileMove = (MSG_FN_MISSILE_MOVE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMissileMoveW(pRecvMissileMove);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_HPRECOVERY(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize = 0;
	MSG_FN_MONSTER_HPRECOVERY	*pRecvHPRecovery = NULL;

	nRecvTypeSize = sizeof(MSG_FN_MONSTER_HPRECOVERY);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_HPRECOVERY, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14059);
		return RES_RETURN_FALSE;
	}
	pRecvHPRecovery = (MSG_FN_MONSTER_HPRECOVERY*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterHPRecoveryW(pRecvHPRecovery);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_HIDE(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize = 0;
	MSG_FN_MONSTER_HIDE		*pRecvHide = NULL;

	nRecvTypeSize = sizeof(MSG_FN_MONSTER_HIDE);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_HIDE, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14059);
		return RES_RETURN_FALSE;
	}
	pRecvHide = (MSG_FN_MONSTER_HIDE*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterHideW(pRecvHide);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_SHOW(const char* pPacket, int nLength, int &nBytesUsed)
{
	int						nRecvTypeSize = 0;
	MSG_FN_MONSTER_HIDE		*pRecvShow = NULL;

	nRecvTypeSize = sizeof(MSG_FN_MONSTER_SHOW);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_SHOW, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14059);
		return RES_RETURN_FALSE;
	}
	pRecvShow = (MSG_FN_MONSTER_SHOW*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterShowW(pRecvShow);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_PRIMARY(const char* pPacket, int nLength, int &nBytesUsed
																 , MSG_FN_BATTLE_ATTACK_PRIMARY *i_pObjectMonsterAttackPrimary/*=NULL*/
																 , CFieldMapProject *i_pFMapProject/*=NULL*/)
{
	MSG_FN_BATTLE_ATTACK_PRIMARY	*pRFNAttackPri = i_pObjectMonsterAttackPrimary;
	if(NULL == pRFNAttackPri)
	{
		int				nRecvTypeSize = 0;	

		nRecvTypeSize = sizeof(MSG_FN_BATTLE_ATTACK_PRIMARY);
		if(nLength - nBytesUsed < nRecvTypeSize)
		{	// ޾ƾ ޼ Ÿ   Ÿ  ۴ٸ 
			// Protocl Error ó
			// - Client   Data Size Field Type  Data Size ۴
			SendErrorMessage(T_FN_BATTLE_ATTACK_PRIMARY, ERR_PROTOCOL_INVALID_FIELD_DATA);
			Close(0x1402C);
			return RES_RETURN_FALSE;
		}
		pRFNAttackPri = (MSG_FN_BATTLE_ATTACK_PRIMARY*)(pPacket+nBytesUsed);
		nBytesUsed += nRecvTypeSize;
	}

	CFieldMapProject *pCurFMapProject = NULL;
	if(NULL == i_pFMapProject)
	{
		pCurFMapProject = m_pFieldMapProjectForNPC;
	}
	else
	{
		pCurFMapProject = i_pFMapProject;
	}

	CFieldMonster *ptmFMonster = pCurFMapProject->GetFieldMonsterW(pRFNAttackPri->ChannelIndex, pRFNAttackPri->AttackIndex, 100);
	if(NULL == ptmFMonster
		|| ptmFMonster->m_enMonsterState != MS_PLAYING
		|| TRUE == COMPARE_BODYCON_BIT(ptmFMonster->BodyCondition, BODYCON_DEAD_MASK))
	{
		return RES_BREAK;
	}

	// Primary ݹ Ҵ
	ITEM		*pAttackItemDefault = ptmFMonster->FindItemPtrWithItemNum(pRFNAttackPri->WeaponItemNumber);
	if(NULL == pAttackItemDefault)
	{	// ݹⰡ ȿ  

		return RES_BREAK;
	}

	//////////////////////////////////////////////////////////////////////////////////
	// --> Start ڰ , ǰڰ ĳ
	if(pRFNAttackPri->TargetIndex < MONSTER_CLIENT_INDEX_START_NUM)
	{
		CFieldIOCPSocket	*pPeerFieldIOCPSocket = NULL;
		CHARACTER			*pCharacter;

		if(FALSE == CheckValidAttackTargetCharacter(ptmFMonster->m_pCurrentFieldMapChannelMonster, pRFNAttackPri->TargetIndex, pPeerFieldIOCPSocket, pCharacter))
		{
			return RES_BREAK;
		}

// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - CFieldIOCPSocket::ProcessSplashDamageMonsterAllAttack# 
// 		if (pAttackItemDefault->Kind == ITEMKIND_FOR_MON_ALLATTACK)
// 		{// 2005-12-13 by cmkwon, ü  SplashDamage ó
// 			ProcessSplashDamageMonsterAllAttack(pRFNAttackPri, this, ptmFMonster, pAttackItemDefault);
// 			return RES_RETURN_TRUE;
// 		}
// 
// 		////////////////////////////////////////////////////////////////////////////////
// 		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -
// 		if(ITEMKIND_FOR_MON_RANGE_ATTACK == pAttackItemDefault->Kind) {
// 			//   
// 			ProcessRangeDamageMonsterAllAttack(pRFNAttackPri, this, ptmFMonster, pAttackItemDefault);
// 			return RES_RETURN_TRUE;
// 		}
		///////////////////////////////////////////////////////////////////////////////
		// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - CFieldIOCPSocket::ProcessSplashDamageMonsterAllAttack# 
		if(pAttackItemDefault->Kind == ITEMKIND_FOR_MON_ALLATTACK || ITEMKIND_FOR_MON_RANGE_ATTACK == pAttackItemDefault->Kind)
		{
 			ProcessSplashDamageMonsterAllAttack(pRFNAttackPri, this, ptmFMonster, pAttackItemDefault);
 			return RES_RETURN_TRUE;
		}

		float		fDistance;
		float		fDamage;
		D3DXVECTOR3		vFrontVel, vExpectPos;

		INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_ATTACK_OK, T_FC_BATTLE_ATTACK_OK, pSFCAttackOK, Sendbuf);
		pSFCAttackOK->AttackIndex						= pRFNAttackPri->AttackIndex;
		pSFCAttackOK->TargetInfo.TargetIndex			= pRFNAttackPri->TargetIndex;
		pSFCAttackOK->TargetInfo.TargetItemFieldIndex	= 0;
		pSFCAttackOK->TargetInfo.TargetPosition			= pRFNAttackPri->TargetPosition;
		pSFCAttackOK->FirePosition.Reset();	
		pSFCAttackOK->AttackType						= ATT_TYPE_GENERAL_PRI;
		pSFCAttackOK->WeaponIndex						= pRFNAttackPri->WeaponIndex;
		pSFCAttackOK->ItemNum							= pAttackItemDefault->ItemNum;	//    ItemNum 
		pSFCAttackOK->RemainedBulletFuel				= 0;
		pSFCAttackOK->SkillNum							= 0;


		// ĳ Ÿ ϰ üũѴ.
		// 20030107 cmkwon, ʹ Ÿ üũ ʿ
		fDistance = D3DXVec3Length(&(ptmFMonster->PositionVector - pCharacter->PositionVector));

		// Ÿ   
		D3DXVec3Normalize(&vFrontVel, &(A2DX(pRFNAttackPri->TargetPosition) - ptmFMonster->PositionVector));	//  ȭ鿡
		vExpectPos = ptmFMonster->PositionVector + vFrontVel * fDistance;
		//  Damage Kind  Ѵ.
		BYTE DamageKind = pPeerFieldIOCPSocket->CalcDamageKind(D3DXVec3Length(&(vExpectPos - pCharacter->PositionVector)));

		if(DamageKind != DAMAGEKIND_NO_DAMAGE)
		{
// 2006-12-04 by dhjin, ü  Ͽ   ҽ .
//			mt_auto_lock dummyLock(&pPeerFieldIOCPSocket->m_mapFieldDummy);			// lock m_mapFieldDummy
//
//			if (pPeerFieldIOCPSocket->m_mapFieldDummy.empty())
//			{// ǰڰ Dummy ް   
//
//				//  Damage Ѵ.
//				fDamage = CFieldIOCPSocket::CalcDamageOfAttack(M2C, 1.0f, this,		// @Process_FN_BATTLE_ATTACK_PRIMARY()
//						ptmFMonster, pPeerFieldIOCPSocket, (void*)pCharacter, pAttackItemDefault,
//						&DamageKind, A2DX(pRFNAttackPri->TargetPosition),
//						pAttackItemDefault->Range, ((pAttackItemDefault->OrbitType == ORBIT_BODYSLAM) ? 0 : fDistance ));
//	// 2005-12-13 by cmkwon, splash damage  ü ݸ Ѵ.
//	//			// ü   splash damage ó
//	//			if (pAttackItemDefault->Kind == ITEMKIND_FOR_MON_ALLATTACK)
//	//			{
//	//				ProcessSplashDamage(M2C, this, ptmFMonster, A2DX(pRFNAttackPri->TargetPosition), pAttackItemDefault, pRFNAttackPri->TargetIndex);
//	//			}
//				pPeerFieldIOCPSocket->SendString128(STRING_128_DEBUG_L1, STRMSG_S_F2NOTIFY_0128, ptmFMonster->MonsterInfoPtr->MonsterUnitKind, fDamage);
//			}
//			else
//			{// ǰڰ Dummy ް  
//				
//				FIELD_DUMMY *pTargetDummy = (pPeerFieldIOCPSocket->m_mapFieldDummy.begin())->second;
//				pSFCAttackOK->TargetInfo.TargetItemFieldIndex = pTargetDummy->ItemFieldIndex;
//				
//				fDamage = CalcDamageOfAttack(M2C, 1.0f, this, ptmFMonster, pPeerFieldIOCPSocket, (void*)pCharacter,
//						pAttackItemDefault, &DamageKind, A2DX(pSFCAttackOK->TargetInfo.TargetPosition),
//						0, 0, (pTargetDummy==NULL?NULL:pTargetDummy->ItemFieldIndex));
//				pPeerFieldIOCPSocket->SendString128(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0129, ptmFMonster->MonsterInfoPtr->MonsterUnitKind, fDamage);
//			}
			///////////////////////////////////////////////////////////////////////////////	
			// 2007-06-08 by cmkwon, 2 Ȯ,Ǿ,ݷ  ý  ߰			
			SATTACK_PARAMETER attParam;	
			MEMSET_ZERO(&attParam, sizeof(attParam));
			attParam.MultiTargetIndex = pRFNAttackPri->MultiTargetIndex;		// 2011-03-21 by hskim, ǴƼ 3 -  Ƽ Ÿ  ߰
			ptmFMonster->APCalcAttckParameter(&attParam, pAttackItemDefault, pRFNAttackPri->WeaponIndex);
			fDamage = CFieldIOCPSocket::CalcDamageOfAttackNew(&DamageKind, M2C, 1.0f, this, ptmFMonster, &attParam, pPeerFieldIOCPSocket, (void*)pCharacter, pAttackItemDefault->Range, ((pAttackItemDefault->OrbitType == ORBIT_BODYSLAM) ? 0.0f : fDistance ));
// 2007-06-08 by cmkwon, 2 Ȯ,Ǿ,ݷ  ý 
//			// 2006-12-04 by dhjin, Ʒ  
//			fDamage = CFieldIOCPSocket::CalcDamageOfAttack(M2C, 1.0f, this, ptmFMonster, pPeerFieldIOCPSocket, (void*)pCharacter, pAttackItemDefault,
//					&DamageKind, A2DX(pRFNAttackPri->TargetPosition), pAttackItemDefault->Range, ((pAttackItemDefault->OrbitType == ORBIT_BODYSLAM) ? 0 : fDistance ));
			pPeerFieldIOCPSocket->SendString128(STRING_128_DEBUG_L1, STRMSG_S_F2NOTIFY_0128, ptmFMonster->MonsterInfoPtr->MonsterUnitKind, fDamage);
		}// end_if(DamageKind != DAMAGEKIND_NO_DAMAGE)

		///////////////////////////////////////////////////////////////////////////////
		// 2005-12-13 by cmkwon,  
		ms_pFieldIOCP->SendInRangeMessageAroundCharacter(pRFNAttackPri->AttackIndex, Sendbuf
			, MSG_SIZE(MSG_FC_BATTLE_ATTACK_OK), ptmFMonster->m_pCurrentFieldMapChannelMonster
			, FALSE, ptmFMonster->m_pCurrentFieldMapChannelMonster->GetMonsterVisibleDiameterW());

		return RES_RETURN_TRUE;
	}	// --> End ڰ , ǰڰ ĳ

	//////////////////////////////////////////////////////////////////////////
	// ڰ , ǰڵ 
	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	else {
// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - 
// 		CFieldMonster *pTargetFMonster = pCurFMapProject->GetFieldMonsterW(pRFNAttackPri->ChannelIndex, pRFNAttackPri->TargetIndex, 104);
// 		if(NULL == pTargetFMonster
// 			|| pTargetFMonster->m_enMonsterState != MS_PLAYING
// 			|| TRUE == COMPARE_BODYCON_BIT(pTargetFMonster->BodyCondition, BODYCON_DEAD_MASK)) {
// 			return RES_BREAK;
// 		}
		///////////////////////////////////////////////////////////////////////////////
		// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - 
		CFieldMapChannel *pFMapCh = pCurFMapProject->GetFieldMapChannelByIndex(pRFNAttackPri->ChannelIndex);
		if(NULL == pFMapCh)
		{
			return RES_RETURN_TRUE;
		}
		CFieldMonster *pTargetFMonster = NULL;
		if(FALSE == this->CheckValidM2M(pFMapCh, pRFNAttackPri->AttackIndex, &ptmFMonster, pRFNAttackPri->TargetIndex, &pTargetFMonster))
		{
			return RES_RETURN_TRUE;
		}

// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - CFieldIOCPSocket::ProcessSplashDamageMonsterAllAttack# 
// 		if (pAttackItemDefault->Kind == ITEMKIND_FOR_MON_ALLATTACK)
// 		{// 2005-12-13 by cmkwon, ü  SplashDamage ó
// 			ProcessSplashDamageMonsterAllAttack(pRFNAttackPri, this, pTargetFMonster, pAttackItemDefault);
// 			return RES_RETURN_TRUE;
// 		}
// 
// 		if(ITEMKIND_FOR_MON_RANGE_ATTACK == pAttackItemDefault->Kind) {
// 			//   
// 			ProcessRangeDamageMonsterAllAttack(pRFNAttackPri, this, ptmFMonster, pAttackItemDefault);
// 			return RES_RETURN_TRUE;
// 		}
		///////////////////////////////////////////////////////////////////////////////
		// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - CFieldIOCPSocket::ProcessSplashDamageMonsterAllAttack# 
 		if (pAttackItemDefault->Kind == ITEMKIND_FOR_MON_ALLATTACK || ITEMKIND_FOR_MON_RANGE_ATTACK == pAttackItemDefault->Kind)
		{
 			ProcessSplashDamageMonsterAllAttack(pRFNAttackPri, this, ptmFMonster, pAttackItemDefault);
 			return RES_RETURN_TRUE;
		}


		float		fDistance;
		float		fDamage;
		D3DXVECTOR3		vFrontVel, vExpectPos;
		
		INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_ATTACK_OK, T_FC_BATTLE_ATTACK_OK, pSFCAttackOK, Sendbuf);
		pSFCAttackOK->AttackIndex						= pRFNAttackPri->AttackIndex;
		pSFCAttackOK->TargetInfo.TargetIndex			= pRFNAttackPri->TargetIndex;
		pSFCAttackOK->TargetInfo.TargetItemFieldIndex	= 0;
		pSFCAttackOK->TargetInfo.TargetPosition			= pRFNAttackPri->TargetPosition;
		pSFCAttackOK->TargetInfo.MultiTargetIndex		= pRFNAttackPri->MultiTargetIndex;		// 2011-03-21 by hskim, ǴƼ 3 -  Ƽ Ÿ  ߰
		pSFCAttackOK->FirePosition.Reset();	
		pSFCAttackOK->AttackType						= ATT_TYPE_GENERAL_PRI;
		pSFCAttackOK->WeaponIndex						= pRFNAttackPri->WeaponIndex;
		pSFCAttackOK->ItemNum							= pAttackItemDefault->ItemNum;	//    ItemNum 
		pSFCAttackOK->RemainedBulletFuel				= 0;
		pSFCAttackOK->SkillNum							= 0;
		
		
		// ĳ Ÿ ϰ üũѴ.
		// 20030107 cmkwon, ʹ Ÿ üũ ʿ
		fDistance = D3DXVec3Length(&(ptmFMonster->PositionVector - pTargetFMonster->PositionVector));
		
		// Ÿ   
		D3DXVec3Normalize(&vFrontVel, &(A2DX(pRFNAttackPri->TargetPosition) - ptmFMonster->PositionVector));	//  ȭ鿡
		vExpectPos = ptmFMonster->PositionVector + vFrontVel * fDistance;

		SATTACK_PARAMETER attParam;	
		MEMSET_ZERO(&attParam, sizeof(attParam));
		attParam.MultiTargetIndex = pRFNAttackPri->MultiTargetIndex;		// 2011-03-21 by hskim, ǴƼ 3 -  Ƽ Ÿ  ߰
		ptmFMonster->APCalcAttckParameter(&attParam, pAttackItemDefault, pRFNAttackPri->WeaponIndex);
		fDamage = CFieldIOCPSocket::CalcDamageOfAttackMonsterToMonster(1.0f, this, ptmFMonster, &attParam, (void*)pTargetFMonster);

		///////////////////////////////////////////////////////////////////////
		// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - Attack  NPC 
		INIT_MSG_WITH_BUFFER(MSG_FN_BATTLE_SET_ATTACK_CHARACTER, T_FN_BATTLE_SET_ATTACK_CHARACTER, pSetAttackChar, Send2NPC);
		pSetAttackChar->ChannelIndex	= pFMapCh->GetMapChannelIndex().ChannelIndex;
		pSetAttackChar->AttackIndex		= pRFNAttackPri->AttackIndex;
		pSetAttackChar->TargetIndex		= pRFNAttackPri->TargetIndex;
		pSetAttackChar->DamageAmount	= fDamage;
		pSetAttackChar->ItemKind		= pAttackItemDefault->Kind;
		pFMapCh->Send2NPCServerW(Send2NPC, MSG_SIZE(MSG_FN_BATTLE_SET_ATTACK_CHARACTER));

		///////////////////////////////////////////////////////////////////////////////
		// 2005-12-13 by cmkwon,  
		ms_pFieldIOCP->SendInRangeMessageAroundCharacter(pRFNAttackPri->AttackIndex, Sendbuf
			, MSG_SIZE(MSG_FC_BATTLE_ATTACK_OK), ptmFMonster->m_pCurrentFieldMapChannelMonster
			, FALSE, ptmFMonster->m_pCurrentFieldMapChannelMonster->GetMonsterVisibleDiameterW());
		
		return RES_RETURN_TRUE;
	}

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
// ProcessResult CFieldIOCPSocket::Process_FC_BATTLE_ATTACK_SECONDARY(const char* pPacket, int nLength, int &nBytesUsed)
// ݽ ó Լ
//  ĳ Ϻ ,   ĳ ( Ǿ Ѵ.)
//  ڿ ǰڿ
ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_SECONDARY(const char* pPacket, int nLength, int &nBytesUsed)
{
	int				nRecvTypeSize = 0;
	MSG_FN_BATTLE_ATTACK_SECONDARY		*pRFNAttackSec = NULL;

	nRecvTypeSize = sizeof(MSG_FN_BATTLE_ATTACK_SECONDARY);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		SendErrorMessage(T_FN_BATTLE_ATTACK_SECONDARY, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1402C);
		return RES_RETURN_FALSE;
	}
	pRFNAttackSec = (MSG_FN_BATTLE_ATTACK_SECONDARY*)(pPacket+nBytesUsed);
	nBytesUsed += nRecvTypeSize;

// 2010-04-05 by cmkwon, 2 M2M 2   ó - 
// 	//////////////////////////////////////////////////////////////////////////
// 	// ڰ Monster
// 	CFieldMonster * ptmFMonster = m_pFieldMapProjectForNPC->GetFieldMonsterW(pRFNAttackSec->ChannelIndex, pRFNAttackSec->AttackIndex, 101);
// 	if(NULL == ptmFMonster
// 		|| MS_PLAYING != ptmFMonster->m_enMonsterState
// 		|| TRUE == COMPARE_BODYCON_BIT(ptmFMonster->BodyCondition, BODYCON_DEAD_MASK))
// 	{	// ڰ ȿ üũ
// 
// 		return RES_BREAK;
// 	}
	///////////////////////////////////////////////////////////////////////////////
	// 2010-04-05 by cmkwon, 2 M2M 2   ó - 
	CFieldMapChannel * pCurFMChann = m_pFieldMapProjectForNPC->GetFieldMapChannelByIndex(pRFNAttackSec->ChannelIndex);
	if(NULL == pCurFMChann)
	{
		return RES_BREAK;
	}
 	CFieldMonster * ptmFMonster = pCurFMChann->GetFieldMonster(pRFNAttackSec->AttackIndex, 101);
	if(NULL == ptmFMonster
		|| FALSE == ptmFMonster->IsValidMonster())
	{
		return RES_BREAK;
	}

	// Secondary ݹ
	ITEM * pAttackItemDefault = ptmFMonster->FindItemPtrWithItemNum(pRFNAttackSec->WeaponItemNumber);
	if(NULL == pAttackItemDefault)
	{	// ݹⰡ ȿ  

		return RES_BREAK;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2010-04-05 by cmkwon, 2 M2M 2   ó - 
	vectSATTACK_PARAMETER tmOverLifeTimeAttParamList;
	if(ptmFMonster->APPopOverLifeTimeAttackParameterList(&tmOverLifeTimeAttParamList))
	{
		vectSATTACK_PARAMETER::iterator itr(tmOverLifeTimeAttParamList.begin());
		for(; itr != tmOverLifeTimeAttParamList.end(); itr++)
		{
			SATTACK_PARAMETER *pAttParam = &*itr;
			ProcessM2MOverLifeTimeAttackParameter(ptmFMonster, pAttParam, pCurFMChann);
		}
	}
	
	///////////////////////////////////////////////////////////////////////////////	
	// 2007-06-08 by cmkwon, 2 Ȯ,Ǿ,ݷ  ý  ߰			
	SATTACK_PARAMETER attParam;	
	MEMSET_ZERO(&attParam, sizeof(attParam));
	attParam.MultiTargetIndex = pRFNAttackSec->MultiTargetIndex;		// 2011-03-21 by hskim, ǴƼ 3 -  Ƽ Ÿ  ߰
	ptmFMonster->APCalcAttckParameter(&attParam, pAttackItemDefault, pRFNAttackSec->WeaponIndex);

	///////////////////////////////////////////////////////////////////////////////
	// 2010-04-05 by cmkwon, 2 M2M 2   ó - 
	attParam.TargetIndex	= pRFNAttackSec->TargetIndex;
	attParam.AttackType		= pRFNAttackSec->SecAttackType;

	ptmFMonster->APInsertAttackParameter(&attParam);		

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ذ  
//	if(pRFNAttackSec->TargetIndex < MONSTER_CLIENT_INDEX_START_NUM)
//	{	// ǰڰ Client
//		if(FALSE == this->MonsterAttackM2C(ptmFMonster, pRFNAttackSec, pAttackItemDefault)) {
//			return RES_BREAK;
//		}
// 		CFieldIOCPSocket	*pPeerFieldIOCPSocket = NULL;
// 		CHARACTER			*pCharacter;
// 		if(!CheckValidAttackTargetCharacter(ptmFMonster->m_pCurrentFieldMapChannelMonster, pRFNAttackSec->TargetIndex, pPeerFieldIOCPSocket, pCharacter))
// 		{
// 			// ǰ ĳͰ ȿ üũ
// 			return RES_BREAK;
// 		}
// 
// 		INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_ATTACK_OK, T_FC_BATTLE_ATTACK_OK, pSFCAttackOK, Sendbuf);
// 		pSFCAttackOK->AttackIndex = pRFNAttackSec->AttackIndex;
// 		pSFCAttackOK->TargetInfo.TargetIndex = pRFNAttackSec->TargetIndex;
// 		pSFCAttackOK->TargetInfo.TargetItemFieldIndex = 0;
// 		pSFCAttackOK->TargetInfo.TargetPosition = pRFNAttackSec->TargetPosition;
// 		pSFCAttackOK->FirePosition.Reset();	
// 		pSFCAttackOK->AttackType = ATT_TYPE_GENERAL_SEC;
// 		pSFCAttackOK->WeaponIndex = pRFNAttackSec->WeaponIndex;
// 		pSFCAttackOK->ItemNum = pAttackItemDefault->ItemNum;	//    ItemNum 
// 		pSFCAttackOK->RemainedBulletFuel = 0;
// 		pSFCAttackOK->SkillNum = 0;
// 		
// 		///////////////////////////////////////////////////////////////////////////////	
// 		// 2007-06-08 by cmkwon, 2 Ȯ,Ǿ,ݷ  ý  ߰			
// 		SATTACK_PARAMETER attParam;	
// 		MEMSET_ZERO(&attParam, sizeof(attParam));
// 		ptmFMonster->APCalcAttckParameter(&attParam, pAttackItemDefault, pRFNAttackSec->WeaponIndex);
// 		ptmFMonster->APInsertAttackParameter(&attParam);		
// 
// 		float fDistance = D3DXVec3Length(&(ptmFMonster->PositionVector - pCharacter->PositionVector));
// 		// 20030107 cmkwon ʹ Ÿ üũ  ʴ´.
// 
// 		// 2007-10-24 by cmkwon,    - Ʒ  Ÿ  켱   Կ Ѵ.
// 		//ms_pFieldIOCP->SendInRangeMessageAroundCharacter(pRFNAttackSec->AttackIndex, Sendbuf
// 		//	, MSG_SIZE(MSG_FC_BATTLE_ATTACK_OK), ptmFMonster->m_pCurrentFieldMapChannelMonster
// 		//	, FALSE, );
// 		pPeerFieldIOCPSocket->SendAddData(Sendbuf, MSG_SIZE(MSG_FC_BATTLE_ATTACK_OK));
// 		ms_pFieldIOCP->SendInRangeMessageExactAroundPosition(ptmFMonster->PositionVector, Sendbuf, MSG_SIZE(MSG_FC_BATTLE_ATTACK_OK)
// 			, ptmFMonster->m_pCurrentFieldMapChannelMonster->GetMonsterVisibleDiameterW()/2, ptmFMonster->m_pCurrentFieldMapChannelMonster
// 			, pPeerFieldIOCPSocket->GetCharacter()->ClientIndex);
//		return RES_RETURN_TRUE;
//	}	// --> End ڰ , ǰڰ ĳ
//	//////////////////////////////////////////////////////////////////////////
//	// ڰ , ǰڵ 

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	if(pRFNAttackSec->TargetIndex < MONSTER_CLIENT_INDEX_START_NUM)	{
		// ǰڰ Client
		if(FALSE == this->MonsterAttackSecM2C(ptmFMonster, pRFNAttackSec, pAttackItemDefault)) {
			return RES_BREAK;
		}
	}
	else {
		// M -> M
		if(FALSE == this->MonsterAttackSecM2M(ptmFMonster, pRFNAttackSec, pAttackItemDefault)) {
			return RES_BREAK;
		}
	}

	return RES_RETURN_TRUE;
}


ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_FIND(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize	= 0;
	MSG_FN_BATTLE_ATTACK_FIND	*pRFNAttackFind	= NULL;

	nRecvTypeSize = sizeof(MSG_FN_BATTLE_ATTACK_FIND);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		SendErrorMessage(T_FN_BATTLE_ATTACK_FIND, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x1402D);
		return RES_RETURN_FALSE;
	}
	pRFNAttackFind = (MSG_FN_BATTLE_ATTACK_FIND*)(pPacket+nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	///////////////////////////////////////////////////////////////////////////
	//  2 ݵ FC_BATTLE_ATTACK_FIND óϱ , 20040909, kelovon
	///////////////////////////////////////////////////////////////////////////

// 2007-09-14 by cmkwon, ּ ó
//	ASSERT_NEVER_GET_HERE();

	return RES_RETURN_TRUE;
}


ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_DROP_FIXER_OK(const char* pPacket, int nLength, int &nBytesUsed)
{
	int							nRecvTypeSize = 0;
	MSG_FN_BATTLE_DROP_FIXER_OK	*pRecvFixerOK = NULL;
	CFieldIOCPSocket			*pPeerFieldIOCPSocket = NULL;
	CFieldMonster				*pMonster = NULL;

	nRecvTypeSize = sizeof(MSG_FN_BATTLE_DROP_FIXER_OK);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_BATTLE_DROP_FIXER_OK, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14059);
		return RES_RETURN_FALSE;
	}
	pRecvFixerOK = (MSG_FN_BATTLE_DROP_FIXER_OK*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	if (!CheckValidAttackTargetMonster(m_character.InfluenceType, pRecvFixerOK->TargetIndex, pRecvFixerOK->ChannelIndex, pMonster))
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "  Process_FN_BATTLE_DROP_FIXER_OK() Error!\r\n");
		return RES_BREAK;
	}

	// send msg
	INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_DROP_FIXER_OK, T_FC_BATTLE_DROP_FIXER_OK, pFCDropFixerOK, pFCDropFixerOKBuf);
	pFCDropFixerOK->AttackIndex = pRecvFixerOK->AttackIndex;
	pFCDropFixerOK->TargetIndex = pRecvFixerOK->TargetIndex;
	pFCDropFixerOK->ItemFieldIndex = pRecvFixerOK->ItemFieldIndex;
	pFCDropFixerOK->ItemNum = pRecvFixerOK->ItemNum;

	CFieldMapChannel * ptmpFMapChannel = m_pFieldMapProjectForNPC->GetFieldMapChannelByIndex(pRecvFixerOK->ChannelIndex);
	if(NULL == ptmpFMapChannel) { return RES_BREAK; }

	ms_pFieldIOCP->SendInRangeMessageAroundPosition(pMonster->PositionVector, pFCDropFixerOKBuf
		, MSG_SIZE(MSG_FC_BATTLE_DROP_FIXER_OK), ptmpFMapChannel, 0, FALSE);

	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_HIDE_ITEM_W_KIND(const char* pPacket, int nLength, int &nBytesUsed)
{
	int										nRecvTypeSize = 0;
	MSG_FN_BATTLE_ATTACK_HIDE_ITEM_W_KIND	*pRecvHide = NULL;
	CFieldIOCPSocket						*pPeerFieldIOCPSocket = NULL;
	CFieldMonster							*pMonster = NULL;

	nRecvTypeSize = sizeof(MSG_FN_BATTLE_ATTACK_HIDE_ITEM_W_KIND);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_BATTLE_ATTACK_HIDE_ITEM_W_KIND, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14059);
		return RES_RETURN_FALSE;
	}
	pRecvHide = (MSG_FN_BATTLE_ATTACK_HIDE_ITEM_W_KIND*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	if (!CheckValidAttackTargetMonster(m_character.InfluenceType, pRecvHide->TargetIndex, pRecvHide->ChannelIndex, pMonster))
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "  Process_FN_BATTLE_ATTACK_HIDE_ITEM_W_KIND() Error!\r\n");
		return RES_BREAK;
	}

	// send msg
	INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND, T_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND, pFCHide, pFCHideBuf);
	pFCHide->TargetIndex = pRecvHide->TargetIndex;
	pFCHide->ItemKind = pRecvHide->ItemKind;
	pFCHide->TargetItemFieldIndex = pRecvHide->TargetItemFieldIndex;

	CFieldMapChannel * ptmpFMapChannel = m_pFieldMapProjectForNPC->GetFieldMapChannelByIndex(pRecvHide->ChannelIndex);
	if(NULL == ptmpFMapChannel) { return RES_BREAK; }

	ms_pFieldIOCP->SendInRangeMessageAroundPosition(pMonster->PositionVector, pFCHideBuf
		, MSG_SIZE(MSG_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND), ptmpFMapChannel
		, 0, FALSE);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_SKILL(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		ǴƼ - 
/// \author		dhjin
/// \date		2009-09-09 ~ 2010
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_SKILL(const char* pPacket, int nLength, int &nBytesUsed) {
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FN_BATTLE_ATTACK_SKILL, MSG_FN_BATTLE_ATTACK_SKILL, pRMsg);
	
// 2010-04-01 by cmkwon
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Check] T_FN_BATTLE_ATTACK_SKILL Test 1, SkillNum = (%d) SkillCasterCliIdx(%d) TargetCliIdx(%d) \r\n", pRMsg->SkillItemNum, pRMsg->MonsterIndex, pRMsg->ClientIndex);

	// 2010-04-01 by cmkwon, 2 ߰  - 
	CFieldMapChannel * pFMapChann = m_pFieldMapProjectForNPC->GetFieldMapChannelByIndex(pRMsg->MapInfo.ChannelIndex);
	if(NULL == pFMapChann)
	{
		return RES_BREAK;
	}

	CFieldMonster *pCasterFMon = pFMapChann->GetFieldMonster(pRMsg->MonsterIndex, 100);
	if(NULL == pCasterFMon
		|| FALSE == pCasterFMon->IsValidMonster())
	{
		return RES_BREAK;
	}
	
// 2010-04-01 by cmkwon
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Check] T_FN_BATTLE_ATTACK_SKILL Test 2, SkillNum = (%d), Monster \r\n", pRMsg->SkillItemNum);

	//  ų Ҵ
	ITEM		*pSkillItemDefault = pCasterFMon->FindItemPtrWithItemNum(pRMsg->SkillItemNum);
	if(NULL == pSkillItemDefault) {return RES_BREAK;}

// 2010-04-01 by cmkwon
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Check] T_FN_BATTLE_ATTACK_SKILL Test 3, SkillNum = (%d) \r\n", pRMsg->SkillItemNum);

///////////////////////////////////////////////////////////////////////////////
// 2010-03-31 by dhjin, ǴƼ() - ذ  
// 	CFieldIOCPSocket	*pPeerFieldIOCPSocket = NULL;
// 	CHARACTER			*pCharacter;
// 
// 	INIT_MSG_WITH_BUFFER(MSG_FC_MONSTER_SKILL, T_FC_MONSTER_SKILL, msgUseSkillOK, SendBuf);
// 	msgUseSkillOK->SkillItemNum	= pRMsg->SkillItemNum;
// 	msgUseSkillOK->MonsterIndex	= pRMsg->MonsterIndex;
// 	msgUseSkillOK->PositionVector = pRMsg->PositionVector;
// 	msgUseSkillOK->TargetVector	= pRMsg->TargetVector;
//
// 	if(1 < pSkillItemDefault->MultiTarget) {
// 		// ټ  ų
// 		int		MultiTargetCount  = 0;
// 		D3DXVECTOR3		vec3AttackPos = A2DX(pRMsg->PositionVector);
// 		vectorClientIndex tmClientIdxList;
// 		tmClientIdxList.reserve(10);
// 		ptmFMonster->GetAttackedInfoClientIndexList(&tmClientIdxList);
// 		int CheckSize = pSkillItemDefault->MultiTarget;
// 		if(tmClientIdxList.size() < pSkillItemDefault->MultiTarget) {
// 			// ټ  ׷ Ʈ  ٸ ׷ Ʈ  ִ뷮 Ҵ.
// 			CheckSize = tmClientIdxList.size();
// 		}
// 		vectorClientIndex::iterator itr(tmClientIdxList.begin());
// 		for(; itr != tmClientIdxList.end(); itr++) {
// 			ClientIndex_t tmClientIdx = *itr;
// 			if(IS_CHARACTER_CLIENT_INDEX(tmClientIdx)
// 				&& CheckValidAttackTargetCharacter(ptmFMonster->m_pCurrentFieldMapChannelMonster, tmClientIdx, pPeerFieldIOCPSocket, pCharacter)
// 				&& pPeerFieldIOCPSocket->IsValidCharacter(FALSE)
// 				&& FALSE == COMPARE_BODYCON_BIT(pPeerFieldIOCPSocket->m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK)
// 				&& D3DXVec3Length(&(pPeerFieldIOCPSocket->m_character.PositionVector - vec3AttackPos)) <= pSkillItemDefault->Range ) {
// 				// ڽŰ  Ʊ׵鿡Ե 
// 				pPeerFieldIOCPSocket->m_SkillManager.ApplyMonSkill(pSkillItemDefault, pRMsg);
// 				msgUseSkillOK->ClientIndex = tmClientIdx;
// 				pPeerFieldIOCPSocket->m_pCurrentFieldMapChannel->SendMessageToAllInChannel(SendBuf, MSG_SIZE(MSG_FC_MONSTER_SKILL));
// 				if(NULL != pPeerFieldIOCPSocket->m_pFieldParty) {
// 					//   Ƽ鿡  ( ʿ !!!)
// 					INIT_MSG_OF_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING, T_FC_CHARACTER_DEBUFF_DOT_APPLYING, pSendMsg, DebuffDotSendBuf);
// 					pSendMsg->CharacterUID		= pPeerFieldIOCPSocket->m_character.CharacterUniqueNumber;
// 					pSendMsg->SkillItemNum		= pRMsg->SkillItemNum;
// 					pPeerFieldIOCPSocket->m_pFieldParty->SendMsgToMembers(DebuffDotSendBuf, MSG_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING), pPeerFieldIOCPSocket->m_character.CharacterUniqueNumber);
// 				}
// 				MultiTargetCount++;
// 			}
// 			if(MultiTargetCount >= CheckSize) {
// 				break;
// 			}
// 		}
// 
// 	}
//	else if (1 == pSkillItemDefault->MultiTarget){
// 	if (1 <= pSkillItemDefault->MultiTarget){
// 		// Ƽ Ÿ NPC Ѵ.
// 		if(IS_CHARACTER_CLIENT_INDEX(pRMsg->ClientIndex)
// 			&& CheckValidAttackTargetCharacter(ptmFMonster->m_pCurrentFieldMapChannelMonster, pRMsg->ClientIndex, pPeerFieldIOCPSocket, pCharacter)
// 			&& pPeerFieldIOCPSocket->IsValidCharacter(FALSE)
// 			&& FALSE == COMPARE_BODYCON_BIT(pPeerFieldIOCPSocket->m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK)) {
// 			// ڽŰ  Ʊ׵鿡Ե 
// 			// 2009-09-09 ~ 2010-01-28 by dhjin, ǴƼ -  ų     
// 			if(COMPARE_BIT_FLAG(pSkillItemDefault->ItemAttribute, ITEM_ATTR_CHECK_SKILL_RESISTANCE_STATE) 
// 				&& TRUE == m_SkillManager.CheckResistance(pPeerFieldIOCPSocket)) {
// 				//   ~!!
// 				INIT_MSG_WITH_BUFFER(MSG_FC_INFO_APPLY_RESISTANCE_ITEM, T_FC_INFO_APPLY_RESISTANCE_ITEM, ResistanceMsg, ResistanceSendBuf);
// 				ResistanceMsg->ResistanceUserIdx		= pPeerFieldIOCPSocket->m_character.ClientIndex;
// 				ResistanceMsg->SkillNum					= pSkillItemDefault->ItemNum;	// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ - ׵ ų  ߰
// 				ResistanceMsg->OnceResistanceItem		= FALSE;		// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ -   ϰ    ߰
// 				pPeerFieldIOCPSocket->SendAddData(ResistanceSendBuf, MSG_SIZE(MSG_FC_INFO_APPLY_RESISTANCE_ITEM));
// 			}
// 			else if(COMPARE_BIT_FLAG(pSkillItemDefault->ItemAttribute, ITEM_ATTR_CHECK_SKILL_RESISTANCE_STATE) 
// 				&& TRUE == m_SkillManager.CheckOnceResistance(pPeerFieldIOCPSocket)) {
// 				//   ~!!
// 				INIT_MSG_WITH_BUFFER(MSG_FC_INFO_APPLY_RESISTANCE_ITEM, T_FC_INFO_APPLY_RESISTANCE_ITEM, ResistanceMsg, ResistanceSendBuf);
// 				ResistanceMsg->ResistanceUserIdx		= pPeerFieldIOCPSocket->m_character.ClientIndex;
// 				ResistanceMsg->SkillNum					= pSkillItemDefault->ItemNum;	// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ - ׵ ų  ߰
// 				ResistanceMsg->OnceResistanceItem		= TRUE;		// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ -   ϰ    ߰
// 				pPeerFieldIOCPSocket->SendAddData(ResistanceSendBuf, MSG_SIZE(MSG_FC_INFO_APPLY_RESISTANCE_ITEM));
// 			}
// 			else {
// 				pPeerFieldIOCPSocket->m_SkillManager.ApplyMonSkill(pSkillItemDefault, pRMsg);
// 				msgUseSkillOK->ClientIndex	= pRMsg->ClientIndex;
// 				pPeerFieldIOCPSocket->m_pCurrentFieldMapChannel->SendMessageToAllInChannel(SendBuf, MSG_SIZE(MSG_FC_MONSTER_SKILL));
// 				if(NULL != pPeerFieldIOCPSocket->m_pFieldParty
// 					&& TRUE == IS_ORBIT_SKILL(pSkillItemDefault->OrbitType)) {	// 2009-09-09 ~ 2010-01-18 by dhjin, ǴƼ - Orbit ų 츸 Ƽ , Ʈ  .
// 					INIT_MSG_OF_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING, T_FC_CHARACTER_DEBUFF_DOT_APPLYING, pSendMsg, DebuffDotSendBuf);
// 					//   Ƽ鿡  ( ʿ !!!)
// 					pSendMsg->CharacterUID	= pPeerFieldIOCPSocket->m_character.CharacterUniqueNumber;
// 					pSendMsg->SkillItemNum	= pRMsg->SkillItemNum;
// 					pPeerFieldIOCPSocket->m_pFieldParty->SendMsgToMembers(DebuffDotSendBuf, MSG_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING), pPeerFieldIOCPSocket->m_character.CharacterUniqueNumber);
// 				}
// 			}
// 		}
// 	}
// 	else if(0 == pSkillItemDefault->MultiTarget){
// 		//  ڽ ų
// 		msgUseSkillOK->ClientIndex	= pRMsg->MonsterIndex;
// 		ptmFMonster->m_pCurrentFieldMapChannelMonster->SendMessageToAllInChannel(SendBuf, MSG_SIZE(MSG_FC_MONSTER_SKILL));
// 		ptmFMonster->MonsterSkillApply(pRMsg, pSkillItemDefault);
// 	}
	if(IS_CHARACTER_CLIENT_INDEX(pRMsg->ClientIndex))
	{	//   ų̴.
		this->UserApplyByMonsterSkill(pRMsg, pCasterFMon, pSkillItemDefault);
	}
	else
	{	// Ϳ  ų̴.

		CFieldMonster *pTarFMon = pFMapChann->GetFieldMonster(pRMsg->ClientIndex, 11000);
		if(NULL == pTarFMon
			|| FALSE == pTarFMon->IsValidMonster())
		{
			return RES_BREAK;
		}

		INIT_MSG_WITH_BUFFER(MSG_FC_MONSTER_SKILL, T_FC_MONSTER_SKILL, msgUseSkillOK, SendBuf);
		msgUseSkillOK->SkillItemNum		= pRMsg->SkillItemNum;
		msgUseSkillOK->MonsterIndex		= pRMsg->MonsterIndex;
		msgUseSkillOK->PositionVector	= pRMsg->PositionVector;
		msgUseSkillOK->TargetVector		= pRMsg->TargetVector;
		msgUseSkillOK->ClientIndex		= pRMsg->ClientIndex;
		pFMapChann->SendMessageToAllInChannel(SendBuf, MSG_SIZE(MSG_FC_MONSTER_SKILL));
 		pTarFMon->MonsterSkillApply(pRMsg, pSkillItemDefault);
	}

	CAtumLogSender::SendLogMessageMonsterSkill(pCasterFMon->MonsterInfoPtr->MonsterUnitKind, pRMsg->SkillItemNum);		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ų 

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		ǴƼ() - Ͱ  ų ó ()
/// \author		dhjin
/// \date		2010-03-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::UserApplyByMonsterSkill(MSG_FN_BATTLE_ATTACK_SKILL * i_pRMsg, CFieldMonster * i_pFMonster, ITEM * i_pSkillItemDefault)
{
	if(NULL == i_pRMsg
		|| NULL == i_pFMonster
		|| NULL == i_pSkillItemDefault)
	{
		return;
	}

	CFieldIOCPSocket	*pPeerFieldIOCPSocket = NULL;
	CHARACTER			*pCharacter;
	
	INIT_MSG_WITH_BUFFER(MSG_FC_MONSTER_SKILL, T_FC_MONSTER_SKILL, msgUseSkillOK, SendBuf);
	msgUseSkillOK->SkillItemNum	= i_pRMsg->SkillItemNum;
	msgUseSkillOK->MonsterIndex	= i_pRMsg->MonsterIndex;
	msgUseSkillOK->PositionVector = i_pRMsg->PositionVector;
	msgUseSkillOK->TargetVector	= i_pRMsg->TargetVector;
	if(CheckValidAttackTargetCharacter(i_pFMonster->m_pCurrentFieldMapChannelMonster, i_pRMsg->ClientIndex, pPeerFieldIOCPSocket, pCharacter)
		&& pPeerFieldIOCPSocket->IsValidCharacter(FALSE)
		&& FALSE == COMPARE_BODYCON_BIT(pPeerFieldIOCPSocket->m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK)) {
		// ڽŰ  Ʊ׵鿡Ե 
		// 2009-09-09 ~ 2010-01-28 by dhjin, ǴƼ -  ų     
		if(COMPARE_BIT_FLAG(i_pSkillItemDefault->ItemAttribute, ITEM_ATTR_CHECK_SKILL_RESISTANCE_STATE) 
			&& TRUE == m_SkillManager.CheckResistance(pPeerFieldIOCPSocket)) {
			//   ~!!
			INIT_MSG_WITH_BUFFER(MSG_FC_INFO_APPLY_RESISTANCE_ITEM, T_FC_INFO_APPLY_RESISTANCE_ITEM, ResistanceMsg, ResistanceSendBuf);
			ResistanceMsg->ResistanceUserIdx		= pPeerFieldIOCPSocket->m_character.ClientIndex;
			ResistanceMsg->SkillNum					= i_pSkillItemDefault->ItemNum;	// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ - ׵ ų  ߰
			ResistanceMsg->OnceResistanceItem		= FALSE;		// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ -   ϰ    ߰
			pPeerFieldIOCPSocket->SendAddData(ResistanceSendBuf, MSG_SIZE(MSG_FC_INFO_APPLY_RESISTANCE_ITEM));
		}
		else if(COMPARE_BIT_FLAG(i_pSkillItemDefault->ItemAttribute, ITEM_ATTR_CHECK_SKILL_RESISTANCE_STATE) 
			&& TRUE == m_SkillManager.CheckOnceResistance(pPeerFieldIOCPSocket)) {
			//   ~!!
			INIT_MSG_WITH_BUFFER(MSG_FC_INFO_APPLY_RESISTANCE_ITEM, T_FC_INFO_APPLY_RESISTANCE_ITEM, ResistanceMsg, ResistanceSendBuf);
			ResistanceMsg->ResistanceUserIdx		= pPeerFieldIOCPSocket->m_character.ClientIndex;
			ResistanceMsg->SkillNum					= i_pSkillItemDefault->ItemNum;	// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ - ׵ ų  ߰
			ResistanceMsg->OnceResistanceItem		= TRUE;		// 2009-09-09 ~ 2010-01-19 by dhjin, ǴƼ -   ϰ    ߰
			pPeerFieldIOCPSocket->SendAddData(ResistanceSendBuf, MSG_SIZE(MSG_FC_INFO_APPLY_RESISTANCE_ITEM));
		}
		else {
			pPeerFieldIOCPSocket->m_SkillManager.ApplyMonSkill(i_pSkillItemDefault, i_pRMsg);
			msgUseSkillOK->ClientIndex	= i_pRMsg->ClientIndex;
			pPeerFieldIOCPSocket->m_pCurrentFieldMapChannel->SendMessageToAllInChannel(SendBuf, MSG_SIZE(MSG_FC_MONSTER_SKILL));
			if(NULL != pPeerFieldIOCPSocket->m_pFieldParty
				&& TRUE == IS_ORBIT_SKILL(i_pSkillItemDefault->OrbitType)) {	// 2009-09-09 ~ 2010-01-18 by dhjin, ǴƼ - Orbit ų 츸 Ƽ , Ʈ  .
				INIT_MSG_OF_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING, T_FC_CHARACTER_DEBUFF_DOT_APPLYING, pSendMsg, DebuffDotSendBuf);
				//   Ƽ鿡  ( ʿ !!!)
				pSendMsg->CharacterUID	= pPeerFieldIOCPSocket->m_character.CharacterUniqueNumber;
				pSendMsg->SkillItemNum	= i_pRMsg->SkillItemNum;
				pPeerFieldIOCPSocket->m_pFieldParty->SendMsgToMembers(DebuffDotSendBuf, MSG_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING), pPeerFieldIOCPSocket->m_character.CharacterUniqueNumber);
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		ǴƼ() - ߽ ߵǴ ų ó
/// \author		dhjin
/// \date		2010-03-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::ProcessingHitInvokeSkill(ITEM * i_pAttackItem, ClientIndex_t i_AttackIdx)
{
	if(NULL == i_pAttackItem)
	{
		return;
	}

	for(int j=0; j < SIZE_MAX_DESPARAM_COUNT_IN_ITEM; j++)
	{
		if(DES_HIT_INVOKE_SKILL == i_pAttackItem->ArrDestParameter[j])
		{
			this->ApplyHitInvokeSkill((ItemNum_t)i_pAttackItem->ArrParameterValue[j], i_AttackIdx);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::ApplyHitInvokeSkill(ItemNum_t i_SkillNum, ClientIndex_t i_AttackIdx)
/// \brief		ǴƼ() - ߽ ߵǴ ų 
/// \author		dhjin
/// \date		2010-03-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::ApplyHitInvokeSkill(ItemNum_t i_SkillNum, ClientIndex_t i_AttackIdx)
{
	ITEM * HitInvokeSkill = this->ms_pFieldIOCP->GetItemInfo(i_SkillNum);

	if(NULL == HitInvokeSkill)
	{
		return;
	}

	INIT_MSG_OF_SIZE(MSG_FC_SKILL_USE_SKILL_OK, T_FC_SKILL_USE_SKILL_OK, msgUseSkillOK, SendBuf);
	msgUseSkillOK->SkillItemID.ItemNum	= i_SkillNum;
	msgUseSkillOK->AttackIndex	= i_AttackIdx;
	msgUseSkillOK->TargetIndex	= this->m_character.CharacterUniqueNumber;
	this->SendInRangeMessageAroundMe(SendBuf, MSG_SIZE(MSG_FC_SKILL_USE_SKILL_OK), TRUE);

	if(TRUE == IS_ORBIT_SKILL(HitInvokeSkill->OrbitType)) 
	{
		this->m_SkillManager.ApplyOrbitSkill(HitInvokeSkill, this->GetCharacter()->ClientIndex);
		if(NULL != this->m_pFieldParty)
		{
			INIT_MSG_OF_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING, T_FC_CHARACTER_DEBUFF_DOT_APPLYING, pSendMsg, DebuffDotSendBuf);
			pSendMsg->CharacterUID	= this->m_character.CharacterUniqueNumber;
			pSendMsg->SkillItemNum	= i_SkillNum;
			this->m_pFieldParty->SendMsgToMembers(DebuffDotSendBuf, MSG_SIZE(MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING), this->m_character.CharacterUniqueNumber);
		}
		return;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-05 by cmkwon, 2 M2M 2   ó - 
/// \author		cmkwon
/// \date		2010-04-05 ~ 2010-04-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::ProcessM2MOverLifeTimeAttackParameter(CFieldMonster *i_pAttFMon, SATTACK_PARAMETER *i_pAttParam, CFieldMapChannel *i_pCurFMapChann)
{
	// MSG_FC_BATTLE_ATTACK_FIND_OK غ
	INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_ATTACK_FIND_OK, T_FC_BATTLE_ATTACK_FIND_OK, pMsgAttackFindOK, pMsgAttackFindOKBuf);
	pMsgAttackFindOK->AttackIndex			= i_pAttFMon->MonsterIndex;
	pMsgAttackFindOK->TargetIndex			= i_pAttParam->TargetIndex;
	pMsgAttackFindOK->TargetItemFieldIndex	= 0;
	pMsgAttackFindOK->WeaponIndex			= i_pAttParam->WeaponIndex;
	pMsgAttackFindOK->AttackType			= i_pAttParam->AttackType;

	CFieldMonster *pAttMon = NULL;
	CFieldMonster *pTarMon = NULL;
	if (FALSE == CheckValidM2M(i_pCurFMapChann, i_pAttFMon->MonsterIndex, &pAttMon, i_pAttParam->TargetIndex, &pTarMon))
	{
		pMsgAttackFindOK->TargetIndex			= 0;
		pMsgAttackFindOK->TargetItemFieldIndex	= 0;
		ms_pFieldIOCP->SendInRangeMessageAroundPosition(i_pAttFMon->PositionVector, pMsgAttackFindOKBuf, MSG_SIZE(MSG_FC_BATTLE_ATTACK_FIND_OK), i_pCurFMapChann);
		return;
	}
	
	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 踮 üũ
	if(pTarMon->CheckBarrierHave())
	{
		if(pTarMon->CheckBarrierUsing())
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_MONSTER_BARRIER_USING, T_FC_BATTLE_MONSTER_BARRIER_USING, pSendMsg, SendBuf);
			pSendMsg->MonsterIndex		= pTarMon->MonsterIndex;
			this->SendAddData(SendBuf,  MSG_SIZE(MSG_FC_BATTLE_MONSTER_BARRIER_USING));
			ms_pFieldIOCP->SendInRangeMessageAroundPosition(i_pAttFMon->PositionVector, pMsgAttackFindOKBuf, MSG_SIZE(MSG_FC_BATTLE_ATTACK_FIND_OK), i_pCurFMapChann);
			return ;
		}
		if(pTarMon->BarrierUse())
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_MONSTER_BARRIER_USE, T_FC_BATTLE_MONSTER_BARRIER_USE, pSendMsg, SendBuf);
			pSendMsg->MonsterIndex		= pTarMon->MonsterIndex;
			pSendMsg->SkillItemNum		= pTarMon->m_bBarrierInfo.SkillNum;
			ms_pFieldIOCP->SendInRangeMessageAroundPosition(i_pAttFMon->PositionVector, SendBuf,  MSG_SIZE(MSG_FC_BATTLE_MONSTER_BARRIER_USE), i_pCurFMapChann);
			ms_pFieldIOCP->SendInRangeMessageAroundPosition(i_pAttFMon->PositionVector, pMsgAttackFindOKBuf, MSG_SIZE(MSG_FC_BATTLE_ATTACK_FIND_OK), i_pCurFMapChann);
			return;
		}
	}
	// 2009-09-09 ~ 2010-01-15 by dhjin, ǴƼ -    踮 ų(޹⸸ߵ)
	if(TRUE == pTarMon->CheckImmediateBarrierUsing())
	{
		return;
	}
	
	float		fDamage = CFieldIOCPSocket::CalcDamageOfAttackMonsterToMonster(1.0f, this, pAttMon, i_pAttParam, (void*)pTarMon);	
	
	///////////////////////////////////////////////////////////////////////
	// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - Attack  NPC 
	INIT_MSG_WITH_BUFFER(MSG_FN_BATTLE_SET_ATTACK_CHARACTER, T_FN_BATTLE_SET_ATTACK_CHARACTER, pSetAttackChar, Send2NPC);
	pSetAttackChar->ChannelIndex	= i_pCurFMapChann->GetMapChannelIndex().ChannelIndex;
	pSetAttackChar->AttackIndex		= pMsgAttackFindOK->AttackIndex;
	pSetAttackChar->TargetIndex		= pMsgAttackFindOK->TargetIndex;
	pSetAttackChar->DamageAmount	= fDamage;
	pSetAttackChar->ItemKind		= i_pAttParam->pWeaponItemInfo->Kind;
	i_pCurFMapChann->Send2NPCServerW(Send2NPC, MSG_SIZE(MSG_FN_BATTLE_SET_ATTACK_CHARACTER));
	
	ms_pFieldIOCP->SendInRangeMessageAroundPosition(i_pAttFMon->PositionVector, pMsgAttackFindOKBuf, MSG_SIZE(MSG_FC_BATTLE_ATTACK_FIND_OK), i_pCurFMapChann);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-05 by cmkwon,   ī  ý  - 
/// \author		cmkwon
/// \date		2010-04-05 ~ 2010-04-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::InfinityInitImputeList(vectINFINITY_IMPUTE *i_pImputeList)
{
	if(i_pImputeList->empty()){						return;}

	mt_auto_lock mtImpute(&m_mtVecInfiImpute);
	m_mtVecInfiImpute.clear();
	m_mtVecInfiImpute.reserve(i_pImputeList->size());
	m_mtVecInfiImpute.insert(m_mtVecInfiImpute.end(), i_pImputeList->begin(), i_pImputeList->end());
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-05 by cmkwon,   ī  ý  - 
/// \author		cmkwon
/// \date		2010-04-05 ~ 2010-04-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::InfinityAddImpute(InfiModeUID_t i_infiModeUID, BOOL i_bUpdate2DB/*=FALSE*/)
{
	mt_auto_lock mtImpute(&m_mtVecInfiImpute);
	
	INFINITY_IMPUTE *pImputeInfo = InfinityGetImputeInfoNoLock(i_infiModeUID);
	if(pImputeInfo)
	{
		pImputeInfo->EntranceCount++;

		if(i_bUpdate2DB)
		{
			QPARAM_UPDATE_INFINITY * pQParam = new QPARAM_UPDATE_INFINITY;
			pQParam->AccountUID				= this->m_character.AccountUniqueNumber;
			pQParam->CharacterUID			= this->m_character.CharacterUniqueNumber;
			pQParam->InfinityModeUID		= i_infiModeUID;
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateInfinityImpute, this, GetCharacter()->AccountUniqueNumber, pQParam);
		}
		
//		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TEMP] [Infinity] CFieldIOCPSocket::InfinityAddImpute# %s updated !! InfiModeUID(%d) EntranceCnt(%d) UpdateDB(%d) \r\n"
//			, GetCharacterString(GetCharacter(), string()), i_infiModeUID, pImputeInfo->EntranceCount, i_bUpdate2DB);
		return;
	}

	INFINITY_IMPUTE tmImpute;		MEMSET_ZERO(&tmImpute, sizeof(tmImpute));
	tmImpute.InfinityModeUID	= i_infiModeUID;
	tmImpute.EntranceCount		= 1;
	m_mtVecInfiImpute.push_back(tmImpute);

	if(i_bUpdate2DB)
	{
		QPARAM_INSERT_INFINITY * pQParam = new QPARAM_INSERT_INFINITY;
		pQParam->AccountUID				= this->m_character.AccountUniqueNumber;
		pQParam->CharacterUID			= this->m_character.CharacterUniqueNumber;
		pQParam->InfinityModeUID		= i_infiModeUID;
		pQParam->StartTime.SetCurrentDateTime();
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_InsertInfinityImpute, this, GetCharacter()->AccountUniqueNumber, pQParam);
	}

//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TEMP] [Infinity] CFieldIOCPSocket::InfinityAddImpute# %s inserted !! InfiModeUID(%d) UpdateDB(%d) \r\n"
//		, GetCharacterString(GetCharacter(), string()), i_infiModeUID, i_bUpdate2DB);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		cmkwon
/// \date		2010-04-05 ~ 2010-04-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
INFINITY_IMPUTE *CFieldIOCPSocket::InfinityGetImputeInfoNoLock(InfiModeUID_t i_infiModeUID)
{
	mt_vectorInfinityImpute::iterator itr(m_mtVecInfiImpute.begin());
	
	for(; itr != m_mtVecInfiImpute.end(); itr++)
	{
		INFINITY_IMPUTE *pImpute = &*itr;
		if(i_infiModeUID == pImpute->InfinityModeUID)
		{
			return pImpute;
		}
	}

	return NULL;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		cmkwon
/// \date		2010-04-05 ~ 2010-04-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::InfinitySendImputeList2AFS(void)
{
	mt_auto_lock mtImpute(&m_mtVecInfiImpute);

	vectINFINITY_IMPUTE tmImputeList;
	if(false == m_mtVecInfiImpute.empty())
	{
		tmImputeList.reserve(m_mtVecInfiImpute.size());
		tmImputeList.insert(tmImputeList.end(), m_mtVecInfiImpute.begin(), m_mtVecInfiImpute.end());
	}
	mtImpute.auto_unlock_cancel();

	INIT_MSG_WITH_BUFFER(MSG_FtoA_INFINITY_IMPUTE_LIST, T_FtoA_INFINITY_IMPUTE_LIST, pSendImputeMsg, SendImputeBuf);
	pSendImputeMsg->AFSClientIndex		= this->m_AFSClientIndex;
	pSendImputeMsg->bHaveReentryTicket	= (NULL == this->m_ItemManager.GetItemGeneralByDestParam(DES_INFINITY_REENTRY_TICKET)) ? FALSE : TRUE;	// 2010-03-23 by cmkwon, ǴƼ  ĳ   - 

	INFINITY_IMPUTE * pInfinityImputeInfo = (INFINITY_IMPUTE*)(SendImputeBuf+MSG_SIZE(MSG_FtoA_INFINITY_IMPUTE_LIST));
	int nRecodeCnt		= 0;

	vectINFINITY_IMPUTE::iterator itr(tmImputeList.begin());
	for(; itr != tmImputeList.end(); itr++)
	{
		if(SIZE_MAX_PACKET < MSG_SIZE(MSG_FtoA_INFINITY_IMPUTE_LIST) + sizeof(INFINITY_IMPUTE) * (nRecodeCnt+1))
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::InfinitySendImputeList2AFS# PacketSize error !! %s ImputeListSize(%d) \r\n"
				, GetCharacterString(GetCharacter(), string()), tmImputeList.size());
			break;
		}

		INFINITY_IMPUTE *pImpute = &*itr;

		pInfinityImputeInfo[nRecodeCnt].InfinityModeUID		= pImpute->InfinityModeUID;
		pInfinityImputeInfo[nRecodeCnt].EntranceCount		= pImpute->EntranceCount;
		nRecodeCnt++;
	}
	pSendImputeMsg->InfinityImputeListCount = nRecodeCnt;
	ms_pFieldIOCP->m_pArenaFieldWinSocket->Write(SendImputeBuf, MSG_SIZE(MSG_FtoA_INFINITY_IMPUTE_LIST) + sizeof(INFINITY_IMPUTE) * nRecodeCnt);
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-05 by cmkwon,   ī  ý  - 
/// \author		cmkwon
/// \date		2010-04-05 ~ 2010-04-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::InfinitySendAddDataFromAFS2MFS(BYTE * pData, int nSize)
{
	CIOCPSocket *pISoc4MFS = ms_pFieldIOCP->GetMFSSockForArenaServer(this->m_AfsNeedMfsInfo.MFSServerID);
	if(NULL == pISoc4MFS
		|| FALSE == pISoc4MFS->IsUsing())
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] [Infinity] ISoc4MFS is NULL !!, %s MFSServerID(%d) \r\n", GetCharacterString(GetCharacter(), string()), this->m_AfsNeedMfsInfo.MFSServerID);
		return FALSE;
	}

	return pISoc4MFS->SendAddData(pData, nSize);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-06 by cmkwon, 2 ߰  - 
/// \author		cmkwon
/// \date		2010-04-06 ~ 2010-04-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::InfinityOnCharacterGameEndRoutine(void)
{
	eINFINITY_STATE tmInfiState = this->m_InfinityPlayingInfo.InfinityState;
	if(FALSE == g_pFieldGlobal->IsArenaServer()
		|| INFINITY_STATE_NONE == tmInfiState)
	{
		return;
	}

//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TEMP] [Infinity][%I64d] CFieldIOCPSocket::InfinityOnCharacterGameEndRoutine# ! %s, InfiState(%d) \r\n"
//		, m_InfinityPlayingInfo.InfinityCreateUID, GetCharacterString(GetCharacter(), string()), tmInfiState);		

	INFINITY_DISCONNECTUSER_INFO DisConnectUserInfo;	MEMSET_ZERO(&DisConnectUserInfo, sizeof(DisConnectUserInfo));
	STRNCPY_MEMSET(DisConnectUserInfo.CharacterName, this->m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	DisConnectUserInfo.InfinityCreateUID = this->m_InfinityPlayingInfo.InfinityCreateUID;
	DisConnectUserInfo.MainServerID		 = this->m_AfsNeedMfsInfo.MFSServerID;
	DisConnectUserInfo.InfinityMode		 = this->m_InfinityPlayingInfo.ModeTypeNum;

	ms_pFieldIOCP->m_InfinityManager.LeaveInfinity(this->m_InfinityPlayingInfo.ModeTypeNum, this->m_InfinityPlayingInfo.InfinityCreateUID, this);	

	switch(tmInfiState)
	{
	case INFINITY_STATE_ENTERING:
	case INFINITY_STATE_MAPLOADED:
		{
			// 2010-04-06 by cmkwon,  ϰ ó
			this->ms_pFieldIOCP->m_InfinityManager.SetDisConnectUserInfo(&DisConnectUserInfo);

			// 2010-04-06 by cmkwon, 2 ߰  - ͼó ؾ.
			INIT_MSG_WITH_BUFFER(MSG_FtoA_INFINITY_UPDATE_USER_MAP_INFO, T_FtoA_INFINITY_UPDATE_USER_MAP_INFO, pSMsg, SendBuf);
			pSMsg->AccountUID			= this->m_character.AccountUniqueNumber;
			pSMsg->MFSCharacterUID		= this->m_AfsNeedMfsInfo.MFSCharacterUID;
			pSMsg->MFSClientIndex		= this->m_AfsNeedMfsInfo.MFSClientIdx;
			pSMsg->InfinityMapIndex		= this->m_character.MapChannelIndex.MapIndex;
			pSMsg->InfinityChannelIndex	= this->m_character.MapChannelIndex.ChannelIndex;
			this->InfinitySendAddDataFromAFS2MFS(SendBuf, MSG_SIZE(MSG_FtoA_INFINITY_UPDATE_USER_MAP_INFO));
		}
		break;
	case INFINITY_STATE_PLAYING:
	// start 2011-04-08 by hskim, ǴƼ 3 - ó׸ ܰ躰  
	case INFINITY_STATE_PLAYING_STEP1:
	case INFINITY_STATE_PLAYING_STEP2:
	case INFINITY_STATE_PLAYING_STEP3:
	case INFINITY_STATE_PLAYING_STEP4:
	case INFINITY_STATE_PLAYING_STEP5:
	case INFINITY_STATE_PLAYING_STEP6:
	case INFINITY_STATE_PLAYING_STEP7:
	case INFINITY_STATE_PLAYING_STEP8:
	// end 2011-04-08 by hskim, ǴƼ 3 - ó׸ ܰ躰  
	case INFINITY_STATE_DONE_SUCCESS:
	case INFINITY_STATE_DONE_FAIL:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
			// 2010-04-02 by cmkwon, 2 ߰  - 
			this->GameEndAllInvokingEquipItem();

			// start 2011-04-08 by hskim, ǴƼ 3 - ó׸ ܰ躰  
			// 
			// if(INFINITY_STATE_PLAYING == tmInfiState)

			// 
			if( TRUE == IS_INFINITY_STATE_PLAYING(this->m_InfinityPlayingInfo.InfinityState) )
			// end 2011-04-08 by hskim, ǴƼ 3 - ó׸ ܰ躰  
			{// 2010-04-06 by cmkwon,  ϶  ϰ ó
				this->ms_pFieldIOCP->m_InfinityManager.SetDisConnectUserInfo(&DisConnectUserInfo);
			}
			
			//  ̾ٸ  !!
			this->InfinityFin();
		}
		break;
	}
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-06 by cmkwon, 2 ߰  - 
/// \author		cmkwon
/// \date		2010-04-06 ~ 2010-04-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::ArenaOnCharacterGameEndRoutine(void)
{
	if(FALSE == g_pFieldGlobal->IsArenaServer()
		|| ARENA_STATE_NONE == this->m_ArenaInfo.State)
	{
		return;
	}

	// 2007-05-02 by dhjin,  Ʒ   óؾ  
	//////////////////////////////////////////////////////////////////////////
	// 2007-06-04 by dhjin, Ʒ   Ѵ.
	m_ItemManager.DeleteAllArenaItem();
	
	// 2007-04-23 by dhjin,  
	this->ms_pFieldIOCP->m_ArenaManager.DeleteMember(this);
	
	if(ARENA_STATE_FIGHTING_WARREADY <=  this->m_ArenaInfo.State
		&& ARENA_STATE_FIGHTING_WARFINISH >=  this->m_ArenaInfo.State
		&& FALSE == this->m_ArenaInfo.WatchState)
	{// 2007-06-21 by dhjin, Ʒ  ̾ٸ   1.
		// 2008-01-15 by dhjin, Ʒ  - ʵ    Ͽ ó
		this->SendArenaCharacterDisConnect();
	}	

	// start 2011-10-17 by hskim, Ʈ ý 2
	switch( m_ArenaInfo.State )
	{
		case ARENA_STATE_FIGHTING_WARREADY:
		case ARENA_STATE_FIGHTING_WARING:
		case ARENA_STATE_FIGHTING_WARFINISH:
		{
			this->ArenaFin();		// Ʒ ̶  Ʈ
			break;
		}

		case ARENA_STATE_JOINING:
		case ARENA_STATE_READY:
		case ARENA_STATE_READY_FINISH:
		default:
		{
			break;
		}
	}
	// end 2011-10-17 by hskim, Ʈ ý 2
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-20 by cmkwon, ű Ű ӽ  - 
/// \author		cmkwon
/// \date		2010-04-20 ~ 2010-04-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::TryEnchantItem(BOOL *o_pbSuccessFlag, ITEM_GENERAL *i_pTargetItemG, int i_nEnchantCnt, ITEM_GENERAL *i_pEnchatItemG, ITEM_GENERAL *i_pPreventDestructionItemG, ITEM_GENERAL *i_pProbabilityIncreaseItemG)
{
	
	// start 2012-11-21 by khkim, GLog 2
	MSG_FL_LOG_ITEM LogItemParameter;
	MEMSET_ZERO(&LogItemParameter, sizeof(LogItemParameter));	// 2013-05-30 by jhseol, GLog ý  - ʱȭ
	int EnchantBefore		= 0;
	// end 2012-11-21 by khkim, GLog 2
	
	*o_pbSuccessFlag		= FALSE;

	// æƮ  ˻
	ENCHANT_INFO *pEnchantInfo = ms_pFieldIOCP->m_mapEnchantInfo.findEZ_ptr(i_pEnchatItemG->ItemNum);
	if (pEnchantInfo == NULL)
	{
		return ERR_NO_SUCH_ENCHANT_INFO;
	}
	
	//  Ȯ
	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if (pMoney == NULL || pMoney->CurrentCount < pEnchantInfo->EnchantCost)
	{
		if(NULL == pMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
		return ERR_PROTOCOL_NOT_ENOUGH_MONEY;
	}

	Prob10K_t EnchantProbability = pEnchantInfo->ProbabilityPerLevel[i_nEnchantCnt];
	///////////////////////////////////////////////////////////////////////////////
	// 2007-10-02 by cmkwon,  æƮ ī ߰ æƮ/ Ȯ 0   Ұ ϴ
	if(0 >= EnchantProbability)
	{
		return ERR_PROTOCOL_CANNOT_ENCHANT_ITEM;
	}

	if(MAX_RAND10K_VALUE < EnchantProbability)
	{// 2010-04-20 by cmkwon, ̹  Ȯ 100%  Ĺ/Ȯ   ʴ´.
		i_pPreventDestructionItemG	= NULL;
		i_pProbabilityIncreaseItemG	= NULL;
	}

	if(i_pProbabilityIncreaseItemG)
	{
		EnchantProbability = EnchantProbability + (EnchantProbability * (i_pProbabilityIncreaseItemG->ItemInfo->GetParameterValue(DES_ENCHANT_INCREASE_PROBABILITY) / (MAX_RAND10K_VALUE+1) ) );	
	}

	BOOL bEnchantSuccess	= FALSE;
	Prob10K_t nRandValue = ms_pFieldIOCP->GetRandInt32(0, MAX_RAND10K_VALUE);	// 2007-12-10 by cmkwon,  ý  - 
	if (nRandValue <= EnchantProbability)
	{// 

		//////////////////////////////////////////////////////////////////////////////////
		// start 2011-10-19 by hskim, EP4 [Free to play] - 10 ȸ þƮ   
		//
		// 
		//

		/*
		bEnchantSuccess		= TRUE;
		i_nEnchantCnt++;

		// ENCHANT , DB parameter ѱ  new 
		ENCHANT *pNewEnchant				= new ENCHANT;
		pNewEnchant->TargetItemUniqueNumber	= i_pTargetItemG->UniqueNumber;
		pNewEnchant->TargetItemNum			= i_pTargetItemG->ItemNum;
		pNewEnchant->EnchantItemNum			= i_pEnchatItemG->ItemNum;

		// 
		InsertEnchantToItem(i_pTargetItemG, *pNewEnchant);

		// Send MSG
		INIT_MSG_OF_SIZE(MSG_FC_ITEM_PUT_ENCHANT, T_FC_ITEM_PUT_ENCHANT, pPutEnchant, pPutEnchantBuf);
		pPutEnchant->Enchant = *pNewEnchant;
		SendAddData(pPutEnchantBuf, MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT));

		// Update DB
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_InsertEnchant, this, m_character.AccountUniqueNumber, pNewEnchant);
		*/

		/////////
		// 

		int iApplyCount = 1;

		if( TRUE == i_pEnchatItemG->ItemInfo->IsExistDesParam(DES_ENCHANT_ONCE_APPLY) && i_pPreventDestructionItemG == NULL && i_nEnchantCnt < MAX_ENCHANT_ONCE_APPLY_COUNT )
		{
			iApplyCount = i_pEnchatItemG->ItemInfo->GetParameterValue(DES_ENCHANT_ONCE_APPLY) - i_nEnchantCnt;
		}

		bEnchantSuccess		= TRUE;

		for(int a=0; a<iApplyCount; a++)
		{	
			// start 2012-11-21 by khkim, GLog 2	
			EnchantBefore				= i_nEnchantCnt++;	
			LogItemParameter.LogType	= GLOG_IL_LT_ENCHANT_UP;
			// end 2012-11-21 by khkim, GLog 2
			
			// ENCHANT , DB parameter ѱ  new 
			ENCHANT *pNewEnchant				= new ENCHANT;
			pNewEnchant->TargetItemUniqueNumber	= i_pTargetItemG->UniqueNumber;
			pNewEnchant->TargetItemNum			= i_pTargetItemG->ItemNum;
			pNewEnchant->EnchantItemNum			= i_pEnchatItemG->ItemNum;
			pNewEnchant->SequenceNumber_DB		= 0;	// 2013-01-15 by bckim, æƮ ѹ ߰

			// 
			InsertEnchantToItem(i_pTargetItemG, *pNewEnchant);

			// Send MSG
			INIT_MSG_OF_SIZE(MSG_FC_ITEM_PUT_ENCHANT, T_FC_ITEM_PUT_ENCHANT, pPutEnchant, pPutEnchantBuf);
			pPutEnchant->Enchant = *pNewEnchant;
			SendAddData(pPutEnchantBuf, MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT));

			// Update DB
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_InsertEnchant, this, m_character.AccountUniqueNumber, pNewEnchant);
		}

		// end 2011-10-19 by hskim, EP4 [Free to play] - 10 ȸ þƮ   
		//////////////////////////////////////////////////////////////////////////////////
		
		// 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
		if (NULL != i_pTargetItemG)
		{
			vectENCHANT tempvectEnchantList;
			this->GetAllEnchantListByItemUID(&tempvectEnchantList,i_pTargetItemG->UniqueNumber);
			CAtumLogSender::SendLogMessageITEMTryEnchantInfo(this, i_pTargetItemG, TRY_ENCHANT_SUCCESS,&tempvectEnchantList);
			this->ExsistHyperCardIn10Lv(i_pTargetItemG->UniqueNumber);  // 10æƮ ī尡 Ǿ α  
		}
		// End. 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
		
	}
	else
	{
		// start 2012-11-21 by khkim, GLog 2
		LogItemParameter.LogType	= GLOG_IL_LT_ENCHANT_DWON;
		EnchantBefore				= i_nEnchantCnt;		
		// end 2012-11-21 by khkim, GLog 2

		i_nEnchantCnt		= 0;		// æƮ īƮ ʱȭ

		///////////////////////////////////////////////////////////////////////////////
	
		// 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
		if (NULL != i_pTargetItemG)
		{
			vectENCHANT tempvectEnchantList;
			this->GetAllEnchantListByItemUID(&tempvectEnchantList,i_pTargetItemG->UniqueNumber);
			CAtumLogSender::SendLogMessageITEMTryEnchantInfo(this, i_pTargetItemG, TRY_ENCHANT_FAIL,&tempvectEnchantList);
		}
		// End. 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
		
		// 2006-08-23 by cmkwon,  æƮ ´
		vectENCHANT tmvectEnchant;
		this->PopAllEnchantByItemUID(&tmvectEnchant, i_pTargetItemG->UniqueNumber);

		if(false == tmvectEnchant.empty())
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-08-23 by cmkwon,  æƮ 
			ENCHANT *pDelEnchant				= new ENCHANT;
			pDelEnchant->TargetItemUniqueNumber	= i_pTargetItemG->UniqueNumber;
			pDelEnchant->TargetItemNum			= i_pTargetItemG->ItemNum;
			pDelEnchant->EnchantItemNum			= i_pEnchatItemG->ItemNum;
			// Update DB
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_DeleteAllEnchant, this, m_character.AccountUniqueNumber, pDelEnchant);

			// Update Client
			INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_DELETE_ALL_ENCHANT, T_FC_ITEM_DELETE_ALL_ENCHANT, pDeleteEnchant, SendBuf);
			pDeleteEnchant->ItemUniqueNumber	= i_pTargetItemG->UniqueNumber;
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_ITEM_DELETE_ALL_ENCHANT));
		}

		if(i_pPreventDestructionItemG)
		{
			// 2013-01-08 by bckim, 10æƮ ̸ ī 
			vectENCHANT::iterator itrEnchant;
			for ( itrEnchant = tmvectEnchant.begin(); itrEnchant != tmvectEnchant.end() ; )
			{
				ENCHANT_INFO *pTempEnchantInfo = ms_pFieldIOCP->m_mapEnchantInfo.findEZ_ptr(itrEnchant->EnchantItemNum);
				if (pTempEnchantInfo == NULL)
				{
					return ERR_NO_SUCH_ENCHANT_INFO;
				}

				// 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
				//  ڵ ּ ó 
// 				INT64 TotalProb = 0;
// 				for( int ProbLevel = 0; ProbLevel<10; ProbLevel++)
// 				{
// 					TotalProb += pTempEnchantInfo->ProbabilityPerLevel[ProbLevel];
// 				}
				
				// 2013-04-04 by bckim, æƮ  ѹ ϴ 
				if( 0 == itrEnchant->SequenceNumber_DB )
				{
					g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ Enchant SEQ_NUM ERROR!! ][%s][%s][%d][%I64d][%d][%d][%I64d] \r\n",this->m_character.AccountName, this->m_character.CharacterName,
							this->m_character.CharacterUniqueNumber,itrEnchant->TargetItemUniqueNumber,itrEnchant->TargetItemNum,itrEnchant->EnchantItemNum,itrEnchant->SequenceNumber_DB);						
				}
				// End. 2013-04-04 by bckim, æƮ  ѹ ϴ  

				if( TRUE == IsHyperCard(pTempEnchantInfo) )
				{
					// 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
					//g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Debug Info] HyperEnchant exist within below Enchant_lv10 (%s|%s|%d|%d \r\n",this->m_character.AccountName, this->m_character.CharacterName,this->m_character.CharacterUniqueNumber, itrEnchant->EnchantItemNum );
					//tmvectEnchant.erase(itrEnchant);
					// α ߰ 
					g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TRY_ENCHANT_ERROR] HyperEnchant exist within below Enchant_lv10 (%s|%s|%d|%d \r\n",this->m_character.AccountName, this->m_character.CharacterName,this->m_character.CharacterUniqueNumber, itrEnchant->EnchantItemNum );
					// End. 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
				}
				
					itrEnchant++;
				}
			// End. 2013-01-08 by bckim, 10æƮ ̸ ī 

			sort(tmvectEnchant.begin(), tmvectEnchant.end(), ENCHANT_ITEM_SORT_BY_SEQUENCE_NUMBER()); 			// 2013-01-15 by bckim, æƮ ѹ ߰
			int nRepairEnchantCnt = min(tmvectEnchant.size(), i_pPreventDestructionItemG->ItemInfo->GetParameterValue(DES_ENCHANT_PREVENTION_DELETE_SAVE_ENCHANT));
			for(int i=0; i < nRepairEnchantCnt; i++)
			{
				// ENCHANT , DB parameter ѱ  new 
				ENCHANT *pNewEnchant				= new ENCHANT;
				pNewEnchant->TargetItemUniqueNumber	= i_pTargetItemG->UniqueNumber;
				pNewEnchant->TargetItemNum			= i_pTargetItemG->ItemNum;
				pNewEnchant->EnchantItemNum			= tmvectEnchant[i].EnchantItemNum;
				pNewEnchant->SequenceNumber_DB		= tmvectEnchant[i].SequenceNumber_DB;		// 2013-01-15 by bckim, æƮ ѹ ߰
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ENCHANT_SEQ_NUM_SORT][%d] [%I64d][%d][%d][%I64d]\r\n",i,tmvectEnchant[i].TargetItemUniqueNumber,tmvectEnchant[i].TargetItemNum,tmvectEnchant[i].EnchantItemNum,tmvectEnchant[i].SequenceNumber_DB);

				// 
				InsertEnchantToItem(i_pTargetItemG, *pNewEnchant);

				// Send MSG
				INIT_MSG_OF_SIZE(MSG_FC_ITEM_PUT_ENCHANT, T_FC_ITEM_PUT_ENCHANT, pPutEnchant, pPutEnchantBuf);
				pPutEnchant->Enchant = *pNewEnchant;
				SendAddData(pPutEnchantBuf, MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT));

				// Update DB
				ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_InsertEnchant, this, m_character.AccountUniqueNumber, pNewEnchant);
			}
			
			i_nEnchantCnt	= nRepairEnchantCnt;	// æƮ īƮ 缳

			// 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
			if (NULL != i_pTargetItemG)
			{
				vectENCHANT tempvectEnchantList;
				int nPreventCount = i_pPreventDestructionItemG->ItemInfo->GetParameterValue(DES_ENCHANT_PREVENTION_DELETE_SAVE_ENCHANT);
				this->GetAllEnchantListByItemUID(&tempvectEnchantList,i_pTargetItemG->UniqueNumber);
				CAtumLogSender::SendLogMessageITEMTryEnchantInfo(this, i_pTargetItemG, nPreventCount,&tempvectEnchantList);
				this->ExsistHyperCardIn10Lv(i_pTargetItemG->UniqueNumber);			 // 10æƮ ī尡 Ǿ α  
			}
			// End. 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
		}
		else
		{
			//  , target item Ѵ
			m_ItemManager.DeleteItemFromCharacterByUID(i_pTargetItemG->UniqueNumber, IUT_ENCHANT);
			LogItemParameter.LogType		= GLOG_IL_LT_ENCHANT_DESTROY;	//	2012-11-21 by khkim, GLog 2
		}
	}

	*o_pbSuccessFlag	= bEnchantSuccess;

	// 2010-04-20 by cmkwon, ű Ű ӽ  - (߰ ) - 
	CAtumLogSender::SendLogMessageITEMUseENCHANT(this, i_pTargetItemG, i_pEnchatItemG, i_nEnchantCnt, bEnchantSuccess, i_pPreventDestructionItemG, i_pProbabilityIncreaseItemG);

	ITEM_GENERAL tmpItemForLog = *i_pEnchatItemG;
	tmpItemForLog.CurrentCount--;
	CAtumLogSender::SendLogMessageITEMUseITEM(this, &tmpItemForLog);
	m_ItemManager.UpdateItemCountByPointer(i_pEnchatItemG, -1, IUT_ENCHANT);		// Current ϱ

	if(i_pPreventDestructionItemG)
	{
		tmpItemForLog = *i_pPreventDestructionItemG;
		tmpItemForLog.CurrentCount--;
		CAtumLogSender::SendLogMessageITEMUseITEM(this, &tmpItemForLog);
		m_ItemManager.UpdateItemCountByPointer(i_pPreventDestructionItemG, -1, IUT_ENCHANT);	// Current ϱ
	}

	if(i_pProbabilityIncreaseItemG)
	{
		tmpItemForLog = *i_pProbabilityIncreaseItemG;
		tmpItemForLog.CurrentCount--;
		CAtumLogSender::SendLogMessageITEMUseITEM(this, &tmpItemForLog);
		m_ItemManager.UpdateItemCountByPointer(i_pProbabilityIncreaseItemG, -1, IUT_ENCHANT);	// Current ϱ
	}

	if(0 < pEnchantInfo->EnchantCost)
	{
		//  
		tmpItemForLog = *pMoney;
		tmpItemForLog.CurrentCount = max(0, pMoney->CurrentCount - pEnchantInfo->EnchantCost);
		CAtumLogSender::SendLogMessageITEMUseITEM(this, &tmpItemForLog);
		m_ItemManager.UpdateItemCountByPointer(pMoney, -pEnchantInfo->EnchantCost, IUT_ENCHANT);
	}

	// start 2012-11-21 by khkim, GLog 2
	// ENCHANT GLog ŶSend κ
	if(!COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER|RACE_MONITOR|RACE_GUEST|RACE_DEMO))		// 2013-01-18 by khkim, GLog (Ϲ )	
	{
		LogItemParameter.ItemSerial		= (UID64_t)i_pTargetItemG->ItemNum;	// 2013-05-30 by jhseol, GLog ý  - ĳ
		LogItemParameter.Count1			= (UID64_t)EnchantBefore;	// 2013-05-30 by jhseol, GLog ý  - ĳ
		LogItemParameter.Count2			= (UID64_t)i_nEnchantCnt;	// 2013-05-30 by jhseol, GLog ý  - ĳ
		// 2013-05-30 by jhseol, GLog ý 
//		LogItemParameter.CharSerial		= NULL;
		LogItemParameter.CharSerial		= (UID64_t)m_character.CharacterUniqueNumber;
		// end 2013-05-30 by jhseol, GLog ý 
		LogItemParameter.CharLv			= (int)m_character.Level;	// 2013-05-30 by jhseol, GLog ý  - ĳ
		LogItemParameter.GameServerID	= g_pFieldGlobal->GetMGameServerID();
		CAtumLogSender::SendLogItem(&LogItemParameter);
	}
	// end 2012-11-21 by khkim, GLog 2
	
	return ERR_NO_ERROR;
}

// 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
BOOL CFieldIOCPSocket::IsHyperCard(ENCHANT_INFO *i_pEnchantInfo)
{
	if( NULL == i_pEnchantInfo )
	{ return FALSE; }

	INT64 nTotalProb = 0;
	for(int i=0; i<10; i++)
	{
		nTotalProb += i_pEnchantInfo->ProbabilityPerLevel[i];

		if( nTotalProb > 0 )
		{
			return FALSE;
		}
	}
	return TRUE; 
}	
BOOL CFieldIOCPSocket::ExsistHyperCardIn10Lv(UID64_t i_nItemUID)				
{
 	vectENCHANT tempvectEnchantList;
	GetAllEnchantListByItemUID(&tempvectEnchantList,i_nItemUID);											// Ʈ  
	sort(tempvectEnchantList.begin(), tempvectEnchantList.end(), ENCHANT_ITEM_SORT_BY_SEQUENCE_NUMBER());	//  

	if( TRUE == tempvectEnchantList.empty()) // æƮƮ  ī嵵 
	{
		return FALSE; 
	}

	vectENCHANT::iterator itr = tempvectEnchantList.begin();
	int count = 0;
	while( itr != tempvectEnchantList.end() || 10 <= count)
	{
		ENCHANT_INFO *pTempEnchantInfo = ms_pFieldIOCP->m_mapEnchantInfo.findEZ_ptr(itr->EnchantItemNum);
		if( NULL == pTempEnchantInfo)
		{
			return FALSE;
		}
		if( TRUE == IsHyperCard(pTempEnchantInfo) )
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TRY_ENCHANT_ERROR] HyperEnchant exist within below Enchant_lv10 (%s|%s|%d|%I64d \r\n",
				this->m_character.AccountName, this->m_character.CharacterName,this->m_character.CharacterUniqueNumber, i_nItemUID);
			return TRUE; 	// ϳ ߰ߵǸ α 
		}
		itr++;
		count++;
	}

	return FALSE; 
}
// End. 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  


///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-20 by cmkwon, ű Ű ӽ  - 
/// \author		cmkwon
/// \date		2010-04-20 ~ 2010-04-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::TryGambleItem(BOOL *o_pbSuccessFlag, ITEM_GENERAL *i_pTargetItemG, int i_nEnchantCnt, ITEM_GENERAL *i_pGambleCard1ItemG, ITEM_GENERAL *i_pGambleCard2ItemG)
{
	if(NULL == i_pGambleCard1ItemG && NULL == i_pGambleCard2ItemG)
	{
		// 2010-04-21 by cmkwon, ɼī尡  ó
		return ERR_PROTOCOL_CANNOT_ENCHANT_ITEM;
	}
	if(i_pGambleCard1ItemG && i_pGambleCard2ItemG)
	{
		// 2010-04-21 by cmkwon, Ѵ  ɼ̸  ó
		if( (i_pGambleCard1ItemG->ItemInfo->IsExistDesParam(DES_RARE_FIX_PREFIX) && i_pGambleCard2ItemG->ItemInfo->IsExistDesParam(DES_RARE_FIX_PREFIX))
			|| (i_pGambleCard1ItemG->ItemInfo->IsExistDesParam(DES_RARE_FIX_SUFFIX)	&& i_pGambleCard2ItemG->ItemInfo->IsExistDesParam(DES_RARE_FIX_SUFFIX)) )
		{
			return ERR_PROTOCOL_CANNOT_ENCHANT_ITEM;
		}
	}

	ITEM_GENERAL	*pPrefixItemG = NULL;
	ITEM_GENERAL	*pSuffixItemG = NULL;
	BOOL			bSuccessPrefix = FALSE;
	BOOL			bSuccessSuffix = FALSE;
	if(i_pGambleCard1ItemG)
	{
		if(i_pGambleCard1ItemG->ItemInfo->IsExistDesParam(DES_RARE_FIX_PREFIX))
		{
			pPrefixItemG = i_pGambleCard1ItemG;
		}
		else
		{
			pSuffixItemG = i_pGambleCard1ItemG;
		}
	}
	if(i_pGambleCard2ItemG)
	{
		if(i_pGambleCard2ItemG->ItemInfo->IsExistDesParam(DES_RARE_FIX_PREFIX))
		{
			pPrefixItemG = i_pGambleCard2ItemG;
		}
		else
		{
			pSuffixItemG = i_pGambleCard2ItemG;
		}
	}

	int nCostGamble = 0;

	if(pPrefixItemG)
	{
		// æƮ  ˻
		ENCHANT_INFO *pEnchantInfo = ms_pFieldIOCP->m_mapEnchantInfo.findEZ_ptr(pPrefixItemG->ItemNum);
		if (pEnchantInfo == NULL)
		{			
			return ERR_NO_SUCH_ENCHANT_INFO;
		}
		nCostGamble	+= pEnchantInfo->EnchantCost;

		Prob10K_t nRandValue			= ms_pFieldIOCP->GetRandInt32(0, MAX_RAND10K_VALUE);	// 2007-12-10 by cmkwon,  ý  - 
		Prob10K_t EnchantProbability	= pEnchantInfo->ProbabilityPerLevel[0];					// ķ ī  ù Ȯ .
		
		///////////////////////////////////////////////////////////////////////////////
		// 2007-10-02 by cmkwon,  æƮ ī ߰ æƮ/ Ȯ 0   Ұ ϴ
		if(0 >= EnchantProbability)
		{
			return ERR_PROTOCOL_CANNOT_ENCHANT_ITEM;
		}
		if(nRandValue <= EnchantProbability)
		{
			bSuccessPrefix	= TRUE;
		}
	}

	if(pSuffixItemG)
	{
		// æƮ  ˻
		ENCHANT_INFO *pEnchantInfo = ms_pFieldIOCP->m_mapEnchantInfo.findEZ_ptr(pSuffixItemG->ItemNum);
		if (pEnchantInfo == NULL)
		{			
			return ERR_NO_SUCH_ENCHANT_INFO;
		}
		nCostGamble	+= pEnchantInfo->EnchantCost;

		Prob10K_t nRandValue			= ms_pFieldIOCP->GetRandInt32(0, MAX_RAND10K_VALUE);	// 2007-12-10 by cmkwon,  ý  - 
		Prob10K_t EnchantProbability	= pEnchantInfo->ProbabilityPerLevel[0];					// ķ ī  ù Ȯ .
		
		///////////////////////////////////////////////////////////////////////////////
		// 2007-10-02 by cmkwon,  æƮ ī ߰ æƮ/ Ȯ 0   Ұ ϴ
		if(0 >= EnchantProbability)
		{
			return ERR_PROTOCOL_CANNOT_ENCHANT_ITEM;
		}
		if(nRandValue <= EnchantProbability)
		{
			bSuccessSuffix	= TRUE;
		}
	}

	//  Ȯ
	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if (pMoney == NULL || pMoney->CurrentCount < nCostGamble)
	{
		if(NULL == pMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}
		return ERR_PROTOCOL_NOT_ENOUGH_MONEY;
	}

	if(FALSE == bSuccessPrefix && FALSE == bSuccessSuffix)
	{
		return ERR_PROTOCOL_ITEM_KIND_NOT_MATCHED;
	}

	// start 2011-10-20 by hskim, EP4 [Free to play] - /  ɼ

	if( NULL != pPrefixItemG && TRUE == pPrefixItemG->ItemInfo->IsExistDesParam(DES_GAMBLE_RARE_ITEM_FIX) )
	{
#ifdef S_EP4_HSKIM		// ON/OFF  
#else
		return ERR_PROTOCOL_CANNOT_ENCHANT_ITEM;
#endif

		if( FALSE == ms_pFieldIOCP->CheckFixRareCode(i_pTargetItemG->ItemInfo, TRUE, pPrefixItemG->ItemInfo->GetParameterValue(DES_GAMBLE_RARE_ITEM_FIX)) )
		{
			return ERR_PROTOCOL_CANNOT_ENCHANT_LACK_REQUIREMENT;
		}
	}

	if( NULL != pSuffixItemG && TRUE == pSuffixItemG->ItemInfo->IsExistDesParam(DES_GAMBLE_RARE_ITEM_FIX) )
	{
#ifdef S_EP4_HSKIM		// ON/OFF  
#else
		return ERR_PROTOCOL_CANNOT_ENCHANT_ITEM;
#endif
		if( FALSE == ms_pFieldIOCP->CheckFixRareCode(i_pTargetItemG->ItemInfo, FALSE, pSuffixItemG->ItemInfo->GetParameterValue(DES_GAMBLE_RARE_ITEM_FIX)) )
		{
			return ERR_PROTOCOL_CANNOT_ENCHANT_LACK_REQUIREMENT;
		}
	}
	// end 2011-10-20 by hskim, EP4 [Free to play] - /  ɼ

	// 2010-04-20 by cmkwon, ű Ű ӽ  - 0527 by cmkwon, κ ߰ -  ÷ TRUE 
	*o_pbSuccessFlag	= TRUE;

	if(pPrefixItemG)
	{
		if(bSuccessPrefix)
		{
			// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  -  õ   ڷ Ѵ.
			ApplyGambleRareFix(pPrefixItemG->ItemInfo, i_pTargetItemG, m_pLastSelectedPrefixRareItemInfo);
			m_pLastSelectedPrefixRareItemInfo = ms_pFieldIOCP->GetRareItemInfo(i_pTargetItemG->PrefixCodeNum);
		}

		// æƮ/     α
		CAtumLogSender::SendLogMessageITEMUseENCHANT(this, i_pTargetItemG, pPrefixItemG, i_nEnchantCnt, bSuccessPrefix);	// 2007-07-30 by cmkwon, /æƮ α׿ /   
	}

	if(pSuffixItemG)
	{
		if(bSuccessSuffix)
		{
			// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  -  õ   ڷ Ѵ.
			ApplyGambleRareFix(pSuffixItemG->ItemInfo, i_pTargetItemG, m_pLastSelectedSuffixRareItemInfo);
			m_pLastSelectedSuffixRareItemInfo = ms_pFieldIOCP->GetRareItemInfo(i_pTargetItemG->SuffixCodeNum);
		}

		// æƮ/     α
		CAtumLogSender::SendLogMessageITEMUseENCHANT(this, i_pTargetItemG, pSuffixItemG, i_nEnchantCnt, bSuccessSuffix);	// 2007-07-30 by cmkwon, /æƮ α׿ /   
	}
	
	///////////////////////////////////////////////////////////////////////////////	
	// 2010-04-20 by cmkwon, ű Ű ӽ  - (κ߰) - 
	// Send MSG
	INIT_MSG_OF_SIZE(MSG_FC_STORE_UPDATE_RARE_FIX, T_FC_STORE_UPDATE_RARE_FIX, pUpdateRareFix, pUpdateRareFixBuf);
	pUpdateRareFix->ItemUID			= i_pTargetItemG->UniqueNumber;
	pUpdateRareFix->PrefixCodeNum	= i_pTargetItemG->PrefixCodeNum;
	pUpdateRareFix->SuffixCodeNum	= i_pTargetItemG->SuffixCodeNum;
	SendAddData(pUpdateRareFixBuf, MSG_SIZE(MSG_FC_STORE_UPDATE_RARE_FIX));
	
	// Update DB
	QPARAM_UPDATE_ITEM_RARE_FIX *pQParam = new QPARAM_UPDATE_ITEM_RARE_FIX;
	pQParam->ItemUID				= i_pTargetItemG->UniqueNumber;
	pQParam->PrefixCodeNum			= i_pTargetItemG->PrefixCodeNum;
	pQParam->SuffixCodeNum			= i_pTargetItemG->SuffixCodeNum;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateItemRareFix, this, m_character.AccountUniqueNumber, pQParam);
	
	///////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////
	// ó    ó

	if(pPrefixItemG)
	{
		ITEM_GENERAL tmpItemForLog = *pPrefixItemG;
		tmpItemForLog.CurrentCount--;
		CAtumLogSender::SendLogMessageITEMUseITEM(this, &tmpItemForLog);
		m_ItemManager.UpdateItemCountByPointer(pPrefixItemG, -1, IUT_ENCHANT);		// Current ϱ
	}
	if(pSuffixItemG)
	{
		ITEM_GENERAL tmpItemForLog = *pSuffixItemG;
		tmpItemForLog.CurrentCount--;
		CAtumLogSender::SendLogMessageITEMUseITEM(this, &tmpItemForLog);
		m_ItemManager.UpdateItemCountByPointer(pSuffixItemG, -1, IUT_ENCHANT);		// Current ϱ
	}

	if(0 < nCostGamble)
	{
		//  
		ITEM_GENERAL tmpItemForLog = *pMoney;
		tmpItemForLog.CurrentCount = max(0, pMoney->CurrentCount - nCostGamble);
		CAtumLogSender::SendLogMessageITEMUseITEM(this, &tmpItemForLog);
		m_ItemManager.UpdateItemCountByPointer(pMoney, -nCostGamble, IUT_ENCHANT);
	}
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-05-12 by cmkwon, ŷ ̿  ޸  (K0002953) - ŷ   
/// \author		cmkwon
/// \date		2010-05-12 ~ 2010-05-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::CheckTradingItem(UID64_t i_itemUID)
{
	if(FALSE == IS_VALID_UID64(i_itemUID)
		|| FALSE == IS_VALID_UNIQUE_NUMBER(m_peerTraderCharacterUniqueNumber))
	{
		return FALSE;
	}

	mt_auto_lock TILock(&m_mapTradeItem);
	mtmapUID2TradeItem::iterator itrTrade = m_mapTradeItem.find(i_itemUID);
	if (itrTrade == m_mapTradeItem.end())
	{
		return FALSE;
	}

	return TRUE;
}

// 2010-06-01 by shcho, PC  ȹ(ĳ)  - 
void CFieldIOCPSocket::SetHomepremium(BOOL i_bUse)
{
	m_bIsPCBangClient = i_bUse;
	INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_HOMEPREMIUM_INFO, T_FC_ITEM_HOMEPREMIUM_INFO, pHomepremiumInfo, SendBuf);
	pHomepremiumInfo->bUse = i_bUse;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_ITEM_HOMEPREMIUM_INFO));	
}

// 2010-08-27 by shcho&&jskim, WARPOINT   
BOOL CFieldIOCPSocket::SetWarPoint(INT i_nAddWarPoint)
{
	if(NULL == this->GetCharacter())
	{ // ɸͰ  

		return FALSE;
	}
	// Ʈ ߰
	this->m_character.WarPoint				+= i_nAddWarPoint;
	this->m_character.CumulativeWarPoint	+= i_nAddWarPoint;
		
	// start 2012-01-16 by hskim,  - ȭ
	if( NULL != ms_pFieldIOCP->m_pStatisticsManager )
	{
		ms_pFieldIOCP->m_pStatisticsManager->Add(STATISTICS_WAR_POINT, i_nAddWarPoint);
	}
	// end 2012-01-16 by hskim,  - ȭ

	// 2007-05-16 by dhjin, DB Ʈ
	QPARAM_UPDATE_WARPOINT *pQparam = new QPARAM_UPDATE_WARPOINT;
	pQparam->CharacterUID		= this->m_character.CharacterUniqueNumber;
	pQparam->AccountUID			= this->m_character.AccountUniqueNumber;
	pQparam->TotalWarPoint		= this->m_character.WarPoint;
	pQparam->CumulativeWarPoint	= this->m_character.CumulativeWarPoint;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateWarPoint, this, this->m_character.AccountUniqueNumber, pQparam);
	
	// 2007-05-16 by dhjin, Ŭ̾Ʈ 
	INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_PAY_WARPOINT, T_FC_CHARACTER_PAY_WARPOINT, pMsg, SendBuf);
	pMsg->WarPoint				= i_nAddWarPoint;
	pMsg->TotalWarPoint			= this->m_character.WarPoint;
	pMsg->CumulativeWarPoint	= this->m_character.CumulativeWarPoint;
	pMsg->UseItemFlag			= TRUE;
	pMsg->ShowSystemMessage		= TRUE;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_PAY_WARPOINT));

	return TRUE;
}
// END 2010-08-27 by shcho&&jskim, WARPOINT   

// start 2011-09-20 by hskim, Ʈ ý 2
Err_t CFieldIOCPSocket::PetCancelSocketItem(ITEM *i_pItemInfo)
{
	// ϱ Lock ɰ ȣ ϼ
	//mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);

	if(ITEMKIND_PET_SOCKET_ITEM != i_pItemInfo->Kind)
	{
		return ERR_PROTOCOL_ITEM_KIND_NOT_MATCHED;
	}

	if( NULL == m_ItemManager.FindUsingItemByItemNumNoLock(i_pItemInfo->ItemNum) )				
	{
		return ERR_PROTOCOL_NOT_ACTIVATED_ITEM;
	}

	if(FALSE == this->m_ItemManager.DeleteUsingTimeLimitedItemList(i_pItemInfo->ItemNum) )
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] DeleteUsingTimeLimitedItemList error !!, CFieldIOCPSocket::PetCancelSocketItem User(%s) ItemNum(%d)\r\n"
			, GetCharacterString(GetCharacter(), string()), i_pItemInfo->ItemNum);
	}

	//igLock.auto_unlock_cancel();

	return ERR_NO_ERROR;
}
// end 2011-09-20 by hskim, Ʈ ý 2

// start 2012-02-13 by hskim,    ׽Ʈ ɾ
BOOL CFieldIOCPSocket::TestMonsterDropItems(int MonsterIndex, int TestCount)
{
	mapMonsterDropItemTest mapMonsterDropItem;
	vectorMonsterDropItemTest vectorMonsterDropItem;
	MONSTER_INFO *pMonsterInfo = ms_pFieldIOCP->GetMonsterInfo (MonsterIndex);

	if( NULL == pMonsterInfo )
	{
		return FALSE;
	}

	for(int i=0; i<TestCount; i++)
	{
		ms_pFieldIOCP->TestDropItems(pMonsterInfo, &mapMonsterDropItem);
	}

	mapMonsterDropItemTest::iterator itrDropTest = mapMonsterDropItem.begin();
	while(itrDropTest != mapMonsterDropItem.end())
	{
		MONSTER_DROP_ITEM_TEST_INFO *pDropItemInfo = &itrDropTest->second;

		vectorMonsterDropItem.push_back(*pDropItemInfo);

		itrDropTest++;
	}

	sort(vectorMonsterDropItem.begin(), vectorMonsterDropItem.end(), Sort_MonsterDropItemTestInfo_by_CurrentCount());

	SendString128(STRING_128_DEBUG_PRINT, "----------------------------------------");
	SendString128(STRING_128_DEBUG_PRINT, "%s (%d) %ld", pMonsterInfo->MonsterName, pMonsterInfo->MonsterUnitKind, TestCount);
	SendString128(STRING_128_DEBUG_PRINT, "----------------------------------------");

	vectorMonsterDropItemTest::iterator itrDropTestVector = vectorMonsterDropItem.begin();
	while(itrDropTestVector != vectorMonsterDropItem.end())
	{
		MONSTER_DROP_ITEM_TEST_INFO *pDropItemInfo = &*itrDropTestVector;

		ITEM *pItemInfo = ms_pFieldIOCP->GetItemInfo(pDropItemInfo->ItemNum);

		if( NULL == pItemInfo )
		{
			continue;
		}

		SendString128(STRING_128_DEBUG_PRINT, "%s (%d) = %ld", pItemInfo->ItemName, pDropItemInfo->ItemNum, pDropItemInfo->CurrentCount);

		itrDropTestVector++;
	}

	SendString128(STRING_128_DEBUG_PRINT, "----------------------------------------");

	vectorMonsterDropItem.clear();
	mapMonsterDropItem.clear();	

	return TRUE;
}
// end 2012-02-13 by hskim,    ׽Ʈ ɾ

// 2010-06-01 by shcho, GLogDB  -
MOSTSTAYED_MAP_INFO* CFieldIOCPSocket::FindStayedMapInfo(MapIndex_t i_MapIndex)
{
	vectStayedMapInfo::iterator iter(m_vectStayedMapInfo.begin());
	for(;iter!=m_vectStayedMapInfo.end();iter++)
	{
		if(iter->MapIndex == i_MapIndex)
		{
			return &*iter;
		}		
	}

	return NULL;
}

// 2010-06-01 by shcho, GLogDB  -
const char * CFieldIOCPSocket::GetStayedMapName()
{
	MOSTSTAYED_MAP_INFO TempInfo;
	MEMSET_ZERO(&TempInfo,sizeof(MOSTSTAYED_MAP_INFO));

	vectStayedMapInfo::iterator iter(m_vectStayedMapInfo.begin());
	for(;iter!=m_vectStayedMapInfo.end();iter++)
	{
		if(iter->StayedTime > TempInfo.StayedTime) // ð    ε̸
		{
			TempInfo.MapIndex	= iter->MapIndex;
			TempInfo.StayedTime	= iter->StayedTime;
		}		
	}

	return CAtumSJ::GetMapName(TempInfo.MapIndex);
}

ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_CHANGE_BODYCONDITION(const char* pPacket, int nLength, int &nBytesUsed)
{
	int										nRecvTypeSize = 0;
	MSG_FN_MONSTER_CHANGE_BODYCONDITION		*pRecvBody = NULL;
	
	nRecvTypeSize = sizeof(MSG_FN_MONSTER_CHANGE_BODYCONDITION);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_CHANGE_BODYCONDITION, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14059);
		return RES_RETURN_FALSE;
	}
	pRecvBody = (MSG_FN_MONSTER_CHANGE_BODYCONDITION*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterChangeBodyconditionW(pRecvBody);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_SKILL_USE_SKILL(const char* pPacket, int nLength, int &nBytesUsed)
{
	int									nRecvTypeSize = 0;
	MSG_FN_MONSTER_SKILL_USE_SKILL		*pReUseSkill = NULL;
	
	nRecvTypeSize = sizeof(MSG_FN_MONSTER_SKILL_USE_SKILL);
	if(nLength - nBytesUsed < nRecvTypeSize)
	{
		// Protocl Error ó
		// - Client   Data Size Field Type  Data Size ۴
		// Error Code : ERR_PROTOCOL_INVALID_FIELD_DATA
		SendErrorMessage(T_FN_MONSTER_SKILL_USE_SKILL, ERR_PROTOCOL_INVALID_FIELD_DATA);
		Close(0x14059);
		return RES_RETURN_FALSE;
	}
	pReUseSkill = (MSG_FN_MONSTER_SKILL_USE_SKILL*)(pPacket + nBytesUsed);
	nBytesUsed += nRecvTypeSize;

	m_pFieldMapProjectForNPC->FieldOnMonsterSkillUseSkillW(pReUseSkill);
	return RES_RETURN_TRUE;
}

ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_SKILL_END_SKILL(const char* pPacket, int nLength, int &nBytesUsed)
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FN_MONSTER_SKILL_END_SKILL
		, MSG_FN_MONSTER_SKILL_END_SKILL, pReEndSkill);


	m_pFieldMapProjectForNPC->FieldOnMonsterSkillEndSkillW(pReEndSkill);
	return RES_RETURN_TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_AUTO_DESTROYED(const char* pPacket, int nLength, int &nBytesUsed)
/// \brief		
/// \author		cmkwon
/// \date		2006-04-17 ~ 2006-04-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_AUTO_DESTROYED(const char* pPacket, int nLength, int &nBytesUsed)
{

	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FN_MONSTER_AUTO_DESTROYED
		, MSG_FN_MONSTER_AUTO_DESTROYED, pRDestroyed);

	// 2007-11-26 by cmkwon,  ڵ ޽ TCP (N->F) - Ʒ  
	//m_pFieldMapProjectForNPC->FieldOnMonsterAutoDestroyedW(pRDestroyed);
	CFieldMapProject  *pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pRDestroyed->MapChannIdx.MapIndex);
	if(NULL == pFMPro)
	{
		return RES_BREAK;
	}
	pFMPro->FieldOnMonsterAutoDestroyedW(pRDestroyed);

	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_HPTALK(const char* pPacket, int nLength, int &nBytesUsed)	
/// \brief		ǴƼ -   Ŭ̾Ʈ 
/// \author		dhjin
/// \date		2009-09-09 ~ 2010
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FN_MONSTER_HPTALK(const char* pPacket, int nLength, int &nBytesUsed) {
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FN_MONSTER_HPTALK, MSG_FN_MONSTER_HPTALK, pRMsg);
	
	INIT_MSG_WITH_BUFFER(MSG_FC_MONSTER_HPTALK, T_FC_MONSTER_HPTALK, pSMsg, pSBuf);
	pSMsg->MonsterIndex		= pRMsg->MonsterIndex;
	pSMsg->MonsterUnitKind	= pRMsg->MonsterUnitKind;
	pSMsg->HPTalkImportance = pRMsg->HPTalkImportance;
	pSMsg->HPCameraTremble	= pRMsg->HPCameraTremble;
	pSMsg->TargetIndex		= pRMsg->TargetIndex;
	STRNCPY_MEMSET(pSMsg->HPTalk, pRMsg->HPTalk, SIZE_MAX_HPTALK_DESCRIPTION);

	switch (pRMsg->HPTalkImportance) {
		case HPACTION_TALK_IMPORTANCE_CHANNEL : { 
			CFieldMapChannel *pFMChann = ms_pFieldIOCP->GetFieldMapChannelByMapChannelIndex(pRMsg->ChannelIndex); 
			if(NULL == pFMChann) {
				return RES_BREAK;
			}
			pFMChann->SendMessageToAllInChannel(pSBuf, MSG_SIZE(MSG_FC_MONSTER_HPTALK));
		} break;
		case HPACTION_TALK_IMPORTANCE_INFL : {
			//    Ұ 𸥴.  ̱ 
		 } break;
		case HPACTION_TALK_IMPORTANCE_ALL : {
			ms_pFieldIOCP->SendMessageToAllClients(pSBuf, MSG_SIZE(MSG_FC_MONSTER_HPTALK), INFLUENCE_TYPE_ALL_MASK);
		} break;
	}

	CAtumLogSender::SendLogMessageHPActionTalk(pRMsg->MonsterUnitKind, pRMsg->HPTalk);	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ȭ 
	
	return RES_RETURN_TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_SKILL_CANCEL(const char* pPacket, int nLength, int &nBytesUsed) 
/// \brief		ǴƼ() - 
/// \author		dhjin
/// \date		2010-03-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ProcessResult CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_SKILL_CANCEL(const char* pPacket, int nLength, int &nBytesUsed) 
{
	DECLARE_MESSAGE_AND_CHECK_SIZE(pPacket, nLength, nBytesUsed, T_FN_BATTLE_ATTACK_SKILL_CANCEL, MSG_FN_BATTLE_ATTACK_SKILL_CANCEL, pRMsg);
	
	//g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TEMP] CFieldIOCPSocket::Process_FN_BATTLE_ATTACK_SKILL_CANCEL Map(%s) MonIdx(%d) SkillItemNum(%d) \r\n", GetMapString(pRMsg->MapInfo, string()), pRMsg->MonsterIndex, pRMsg->SkillItemNum);
	
	CFieldMonster *ptmFMonster = m_pFieldMapProjectForNPC->GetFieldMonsterW(pRMsg->MapInfo.ChannelIndex, pRMsg->MonsterIndex, 100);
	if(NULL == ptmFMonster
		|| ptmFMonster->m_enMonsterState != MS_PLAYING
		|| TRUE == COMPARE_BODYCON_BIT(ptmFMonster->BodyCondition, BODYCON_DEAD_MASK)) {
		return RES_BREAK;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_MONSTER_SKILL_CANCEL, T_FC_MONSTER_SKILL_CANCEL, msgUseSkillOK, SendBuf);
	msgUseSkillOK->SkillItemNum	= pRMsg->SkillItemNum;
	msgUseSkillOK->MonsterIndex	= pRMsg->MonsterIndex;
	ptmFMonster->m_pCurrentFieldMapChannelMonster->SendMessageToAllInChannel(SendBuf, MSG_SIZE(MSG_FC_MONSTER_SKILL_CANCEL));

	return RES_RETURN_TRUE;
}

BOOL CFieldIOCPSocket::CharacterGameStartRoutine(GameStartType type)
{
	CMTAutoCriticalSection mtAuto(m_mtCritSecForGameEndRoutine.GetCriticalSectionPtr());
	///////////////////////////////////////
	// GameStartType
	// * GST_GAMESTART				= 0
	// * GST_CONN_GAMESTART			= 1
	// * GST_WARP_CONN_GAMESTART	= 2
	// * GST_WARP_SAME_MAP			= 3
	// * GST_WARP_SAME_FIELD_SERVER	= 4
	///////////////////////////////////////

	BYTE SendBuf[SIZE_MAX_PACKET];
	MessageType_t msgType		= T_NA;
	switch(type)
	{
	case GST_GAMESTART:				msgType = T_FC_CHARACTER_GAMESTART;				break;
// 2005-07-21 by cmkwon, ٸ ʵ弭 GameStart Ƿ 
//	case GST_CONN_GAMESTART:		msgType = T_FC_CHARACTER_CONNECT_GAMESTART;		break;
// 2004-12-16 by cmkwon, ٸ ʵ弭  Ƿ 
//	case GST_WARP_CONN_GAMESTART:	msgType = T_FC_EVENT_WARP_CONNECT;				break;
	default:
		{
			return FALSE; 
		}
	}

	/*/////////////////////////////////////////////////////////////////////////
	// Game Start Routine
	// - pre server   m_character Ҵ ٰ !!!
	//
	// *  flag   ʱȭ
	// * m_pCurrentFieldMapChannel Ҵ
	// * ̵ Ұ   ⺻ ġ ̵
	// * m_mapCharacterUniqueNumber m_mapCharacterName ߰
	// * party ʱȭ
	// * SetInitialPosition
	// * MSG_FC_CHARACTER_GAMESTART_OK 
	// * NPC Server MSG_FN_CLIENT_GAMESTART_OK 
	// * MSG_FC_STORE_GET_ITEM DB 䱸(޽  )
	// * SendInRangeCharacterOtherInfo
	// * init log
	// * IM Server IP 
	/////////////////////////////////////////////////////////////////////////*/

	//  flag   ʱȭ
	m_bFlagDBStore				= TRUE;
	m_bFieldServerChangeFlag	= FALSE;
	this->SetClientState(CS_PLAYING);
	m_dwLastTickSpeedHackCheck = timeGetTime();
	m_ExperienceDelayStore		= m_character.Experience;			// 2006-05-21 by cmkwon
	this->m_dwReadyTickforSecurityCheck		= timeGetTime();		// 2009-03-09 by cmkwon, Ϻ Arario nProtect CS ϱ - 

// 2008-01-08 by cmkwon, CheckCurrentMapOnGameStart()  üũ
//	//////////////////////////////////////////////////////////////////////////
//	// 2007-12-12 by dhjin,   κ   ùٸ ʿ ִ üũѴ.
//	if(IS_CONFERENCEROOM_MAP_INDEX(m_character.MapChannelIndex.MapIndex))
//	{
//		CFieldMapProject *pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(CFieldMapProject::GetConferenceRoomMapIndex(m_character.InfluenceType));
//		if(NULL == pFMPro
//			|| FALSE == pFMPro->IsWarpableUser(m_character.CharacterUniqueNumber, m_character.Race))
//		{	
//			CFieldMapChannel *pFMChann = this->GetCityFieldMapChannelPtr();
//			if(NULL == pFMChann)
//			{
//				return FALSE;
//			}
//			m_character.MapChannelIndex	= pFMChann->GetMapChannelIndex();
//			m_character.PositionVector	= pFMChann->m_pMapProject->GetRandomXZCityWarpTargetPosition();
//		}
//	}
//	else if(IS_OUTPOST_CITY_MAP_INDEX(m_character.MapChannelIndex.MapIndex)
//		|| IS_MAP_INFLUENCE_OUTPOST(GetFieldMapChannel(&m_character.MapChannelIndex, TRUE, TRUE)->GetMapInfluenceTypeW()))
//	{	// 2007-09-28 by dhjin, øʿ ۽   ƴϸ 
//		if(m_character.MapChannelIndex.MapIndex != ms_pFieldIOCP->m_OutPostManager.GetOutPostCityMapIndexByGuildUID(m_character.GuildUniqueNumber))
//		{
//			CFieldMapChannel *pFMChann = this->GetCityFieldMapChannelPtr();
//			if(NULL == pFMChann)
//			{
//				return FALSE;
//			}
//			m_character.MapChannelIndex	= pFMChann->GetMapChannelIndex();
//			m_character.PositionVector	= pFMChann->m_pMapProject->GetRandomXZCityWarpTargetPosition();
//		}
//	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-10-23 by cmkwon, Ʈ   ð ý   - â ٰ  ۽ ó ӽ ӽð 
	if(LANGUAGE_TYPE_VIETNAMESE == g_pFieldGlobal->GetLanguageType())
	{
		// 2012-10-30 by jhseol, Ʈ ÷Ÿ - ɸ   ۽ µǵ ûϿ ÷Ÿ ʱȭ .
		//m_nGameContinueTimeInSecondOfToday = m_nGameContinueTimeInSecondOfToday4Viet;		// <<  - ¥ ٲ ʱȭ 
		m_nGameContinueTimeInSecondOfToday = 0;												// <<  -  ۽ ʱȭ 
		// end 2012-10-30 by jhseol, Ʈ ÷Ÿ - ɸ   ۽ µǵ ûϿ ÷Ÿ ʱȭ .
	}
	
	///////////////////////////////////////////////////////////////////////////////	
	// 2007-06-08 by cmkwon, 2 Ȯ,Ǿ,ݷ  ý  ⿡ ʱȭ Ѵ.
	m_WeaponIndexGenerator.Reset();			

	// 2006-02-09 by cmkwon, ڽ Ÿ¿      ųũ 
	this->ResetGiveKillMarkItemPtr2Killer();

// 2008-01-08 by cmkwon, Ʒ ġ ̵
//	if(FALSE == IS_TUTORIAL_MAP_INDEX(m_character.MapChannelIndex.MapIndex)
//		&& COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER))
//	{// 2007-07-19 by cmkwon, Ʃ丮ʿ   // 2006-05-08 by cmkwon, /ڴ , ڽ, · ۵
//// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
////		SetBodyConditionBit(m_character.BodyCondition, BODYCON_STEALTH_MASK);
//		m_bIsInvisibleCharacter	= TRUE;		// 2006-11-08 by cmkwon
//		m_bStealthState			= TRUE;
//		m_bNoDamage				= TRUE;		// 2006-05-09 by cmkwon
//	}

	///////////////////////////////////////////////////////////////////////////////
	// ̾ ī üũ
	if(m_ItemManager.IsExistPremiumCard()
		&& FALSE == m_ItemManager.CashCheckPremiumCardExpire())
	{
		INIT_MSG(MSG_FI_CASH_PREMIUM_CARD_INFO, T_FI_CASH_PREMIUM_CARD_INFO, pIMSCardInfo, SendBuf); // 2006-09-14 by dhjin, IM ɹ ˷ش.
		m_ItemManager.Make_MSG_FI_CASH_PREMIUM_CARD_INFO(pIMSCardInfo);
		ms_pFieldIOCP->Send2IMServer(SendBuf, MSG_SIZE(MSG_FI_CASH_PREMIUM_CARD_INFO));
	}
	
//	m_ItemManager.CashCheckPremiumCardExpire();

	// Ʈ128  level 
	if (COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER|RACE_MONITOR))
	{
		m_STRING_128_print_level = STRING_128_ADMIN_CMD;
	}

// 2008-01-08 by cmkwon,   - CFieldIOCPSocket::ResGetCharacterInfoByName()  ó
//	///////////////////////////////////////////////////////////////////////////////	
//	// 2008-01-08 by dhjin, ɸ â    - 2007-12-26 by cmkwon, CurrentMap üũ ý  - ,   üũ
//	ms_pFieldIOCP->m_InflWarManager.SetLeader8SubLeaderRACE(&m_character);	// 2007-10-06 by cmkwon,  2 ȣĪ ٸ  -

	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-26 by cmkwon, CurrentMap üũ ý  -
	if(FALSE == this->CheckCurrentMapOnGameStart())
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::CharacterGameStartRoutine_1 mapchannel error !!, %s: MapChannel[%s]\n", 
			GetCharacterString(&m_character, string()), GetMapString(m_character.MapChannelIndex, string()));
		Close(0x1405E);
		return FALSE;
	}

	// 2008-01-08 by cmkwon, ġ ̵
	if(FALSE == IS_TUTORIAL_MAP_INDEX(m_character.MapChannelIndex.MapIndex)
		&& COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER))
	{// 2007-07-19 by cmkwon, Ʃ丮ʿ   // 2006-05-08 by cmkwon, /ڴ , ڽ, · ۵
// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//		SetBodyConditionBit(m_character.BodyCondition, BODYCON_STEALTH_MASK);
		m_bIsInvisibleCharacter	= TRUE;		// 2006-11-08 by cmkwon
		m_bStealthState			= TRUE;
		m_bNoDamage				= TRUE;		// 2006-05-09 by cmkwon
	}

	// m_pCurrentFieldMapChannel Ҵ
	SetCurrentFieldMapChannel(GetFieldMapChannel(&m_character.MapChannelIndex, TRUE, TRUE));
	if (m_pCurrentFieldMapChannel == NULL)
	{
		// ERROR! All Channels Not Available
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::CharacterGameStartRoutine_2 mapchannel error !!, %s: MapChannel[%s]\n", 
			GetCharacterString(&m_character, string()), GetMapString(m_character.MapChannelIndex, string()));
		Close(0x1405D);
		return FALSE;
	}
	
	// 2010-06-01 by shcho, GLogDB  -
	m_StartStayedMapTime.SetCurrentDateTime(); //  ð ִ´.
	MOSTSTAYED_MAP_INFO tempMapInfo; // Ϳ ߰ ε ð
	tempMapInfo.MapIndex	=  m_character.MapChannelIndex.MapIndex; //   ε
	tempMapInfo.StayedTime	=  m_StartStayedMapTime.GetTimeDiffTimeInSeconds(this->m_character.LastStartedTime);
	m_vectStayedMapInfo.push_back(tempMapInfo);//  ߰Ѵ.

	// 2013-05-22 by jhseol, ҽ - ּ

	///////////////////////////////////////////////////////////////////////////////
	//  , ,   
	this->m_byCityWarTeamType	= m_pCurrentFieldMapChannel->m_pFieldMapProject->GetCityWarTeamTypeByGuildUID(this->GetCharacter()->GuildUniqueNumber);

	// m_mapCharacterUniqueNumber m_mapCharacterName ߰
	if (type == GST_GAMESTART 
		|| type == GST_CONN_GAMESTART)
	{//  ϴ  ó, GST_WARP_CONN_GAMESTART ó ʿ

		ms_pFieldIOCP->m_mapCharacterUniqueNumber.insertLock(m_character.CharacterUniqueNumber, this);
		m_pFieldParty			= NULL;			// party ʱȭ
	}
	char tmCharacterName[SIZE_MAX_CHARACTER_NAME];
	ms_pFieldIOCP->m_mapCharacterName.insertLock(GGetLowerCase(tmCharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME), this);

	// Set Initial Position
	if(FALSE == m_pCurrentFieldMapChannel->SetInitialPosition(m_character.PositionVector.x, m_character.PositionVector.z, m_character.ClientIndex))
	{
		char szTemp[256];
		sprintf(szTemp, "[Error] SetInitialPosition_2 Error, MapChannel(%s) UnitIndex(%5d) XZ(%5.0f, %5.0f)\n"
			, GET_MAP_STRING(m_pCurrentFieldMapChannel->m_MapChannelIndex), m_character.ClientIndex
			, m_character.PositionVector.x, m_character.PositionVector.z);
		DBGOUT(szTemp);
		g_pGlobal->WriteSystemLog(szTemp);
	}
	m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.insertLock(m_character.CharacterUniqueNumber, this);

	// start 2011-10-10 by hskim, EP4 [Ʈ ý] - ȭ /  ǳ
	if( TRUE == m_pCurrentFieldMapChannel->IsEnableTriggerMapBuff() )
	{
		m_pCurrentFieldMapChannel->GetTriggerMapBuffManager()->SetMapBuff(m_character.CharacterUniqueNumber, this);
	}
	// end 2011-10-10 by hskim, EP4 [Ʈ ý] - ȭ /  ǳ

	// ð 
	time_t ltime;
	struct tm *today = NULL;
	time(&ltime);
	today = localtime(&ltime);
	INIT_MSG_WITH_BUFFER(MSG_FC_CONNECT_SYNC_TIME, T_FC_CONNECT_SYNC_TIME, pSyncTime, pSyncTimeBuf);
	pSyncTime->CurrentTime = (today->tm_hour%4)*3600 + today->tm_min*60 + today->tm_sec;	// 4ð   
	SendAddData(pSyncTimeBuf, MSG_SIZE(MSG_FC_CONNECT_SYNC_TIME));

	// GAME START OK 
	if (type == GST_GAMESTART)
	{
		// send MSG_FC_CHARACTER_GAMESTART_OK
		INIT_MSG(MSG_FC_CHARACTER_GAMESTART_OK, T_FC_CHARACTER_GAMESTART_OK, pSendCharacterGameStartOK, SendBuf);
		pSendCharacterGameStartOK->ClientIndex		= this->GetClientArrayIndex();
		STRNCPY_MEMSET(pSendCharacterGameStartOK->FieldServerIP, m_pCurrentFieldMapChannel->m_pFieldMapProject->m_strFieldIP, SIZE_MAX_IPADDRESS);	// set field server IP
		pSendCharacterGameStartOK->FieldServerPort	= m_pCurrentFieldMapChannel->m_pFieldMapProject->m_sFieldListenPort;
		pSendCharacterGameStartOK->CharacterMode0	= m_character.CharacterMode;
		pSendCharacterGameStartOK->PositionVector	= m_character.PositionVector;
		pSendCharacterGameStartOK->MapWeather		= m_pCurrentFieldMapChannel->m_pFieldMapProject->m_Weather;
		pSendCharacterGameStartOK->bMemberPCBang	= m_bIsPCBangClient;			// 2007-01-25 by cmkwon,  PC ÷
		STRNCPY_MEMSET(pSendCharacterGameStartOK->ServerGroupName0, g_pFieldGlobal->GetServerGroupName(), SIZE_MAX_SERVER_NAME);			// 2007-04-09 by cmkwon
		STRNCPY_MEMSET(pSendCharacterGameStartOK->MainORTestServerName, g_pFieldGlobal->GetMainORTestServerName(), SIZE_MAX_SERVER_NAME);	// 2007-04-09 by cmkwon
		STRNCPY_MEMSET(pSendCharacterGameStartOK->GamePublisher, g_pFieldGlobal->GetGamePublisherName(), SIZE_MAX_GAME_PUBLISHER_NAME);		// 2007-04-09 by cmkwon
		pSendCharacterGameStartOK->MapInfo			= m_pCurrentFieldMapChannel->GetMapChannelIndex();

		// 2008-04-01 by cmkwon, øʿ    ȰѼ ĳ · ó - Ŭ̾Ʈ Ȱó  ʿ ʵ  
		pSendCharacterGameStartOK->BodyCondition	= m_character.BodyCondition;
		pSendCharacterGameStartOK->CurrentHP		= m_character.CurrentHP;
		pSendCharacterGameStartOK->CurrentDP		= m_character.CurrentDP;
		pSendCharacterGameStartOK->CurrentEP		= m_character.CurrentEP;
		pSendCharacterGameStartOK->CurrentSP		= m_character.CurrentSP;

		SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_GAMESTART_OK));
	}
	
	// 2013-05-22 by jhseol, ҽ - ּ

	// 2013-05-31 by jhseol,bckim Ƹ ÷ - Ƹ ÷ ε
#ifdef SC_COLLECTION_ARMOR_JHSEOL_BCKIM	// - Ƹ ÷ ε
	if ( FALSE == g_pFieldGlobal->IsArenaServer() )
	{
		m_ArmorCollection.CollectionLoad();
	}
#endif
	// end 2013-05-31 by jhseol,bckim Ƹ ÷ - Ƹ ÷ ε

	// NPC Server Character  GameStart ޼ Ѵ.
	INIT_MSG(MSG_FN_CLIENT_GAMESTART_OK, T_FN_CLIENT_GAMESTART_OK, pSendClientGameStartOK, SendBuf);
	pSendClientGameStartOK->ChannelIndex			= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
	pSendClientGameStartOK->ClientIndex				= m_character.ClientIndex;
	pSendClientGameStartOK->mexCharacter			= m_character;
	pSendClientGameStartOK->GuildMasterCharUID		= 0;
	pSendClientGameStartOK->bStealthState1			= TRUE;			// ⺻ ڽ · ۵ȴ.  εǰ  
	pSendClientGameStartOK->bInvisible				= FALSE;		// 2006-11-27 by dhjin
	m_pCurrentFieldMapChannel->Send2NPCServerW(SendBuf, MSG_SIZE(MSG_FN_CLIENT_GAMESTART_OK));
	ms_pFieldIOCP->m_InflWarManager.SendStrategicPointInfoForUser(this);
	char szSystemLog[256];
	sprintf(szSystemLog, "  GameStartRoutine(%s) %s Map(%04d) Position(%4d, %4d, %4d) IP(%s)\r\n",
			GetProtocolTypeString(msgType), GetCharacterString(&m_character, string()),
			m_character.MapChannelIndex.MapIndex, (int)m_character.PositionVector.x,
			(int)m_character.PositionVector.y, (int)m_character.PositionVector.z,
			GetPeerIP());
	g_pFieldGlobal->WriteSystemLog(szSystemLog);
	DBGOUT(szSystemLog);

	m_bProcessingStoreGetItem = TRUE;		// 2012-12-11 by hskim, Ʈ     (DB ó   Ŷ )

	// send MSG_FC_STORE_GET_ITEM to DB Manager
	MSG_FC_STORE_GET_ITEM *pGetItem = new MSG_FC_STORE_GET_ITEM;
	pGetItem->AccountUniqueNumber	= m_character.AccountUniqueNumber;
	pGetItem->PossessCharacter		= m_character.CharacterUniqueNumber;
	pGetItem->ItemStorage0			= ITEM_IN_CHARACTER;
	if (type == GST_GAMESTART || type == GST_CONN_GAMESTART) {		pGetItem->bSendToClient = TRUE; }
	pGetItem->bMainGameStartFlag	= TRUE;		// 2012-10-08 by khkim, GLog - Mainʵ弭 ӽ
// 2005-07-21 by hblee, ٸ ʵ弭  Ƿ 
//	else if (type == GST_WARP_CONN_GAMESTART) {						pGetItem->bSendToClient = FALSE; }
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_GetStoreItem, this, m_character.AccountUniqueNumber, (MSG_FC_STORE_GET_ITEM*)pGetItem);

// 2008-02-18 by cmkwon,   ȭ  - CFieldIOCPSocket::Process_FC_EVENT_NOTIFY_MSG_GET() Լ ġ ̵, Ŭ̾Ʈ ӽ غ  ó ʿ
// 	ms_pFieldIOCP->SendInRangeCharacterOtherInfo(this, m_pCurrentFieldMapChannel);
// 
// 	//  ִ   ´.
// 	SendDropItemsAroundPosition(m_character.PositionVector);

	// send log message
	if (type == GST_GAMESTART || type == GST_CONN_GAMESTART)
	{
// 2007-06-19 by cmkwon,   ð  - ߱ 5ð   ó, Ʒ GPInitGameStartTime()Լ ó
//		this->m_atmeGameStartTime.SetCurrentDateTime();			// 2006-11-15 by cmkwon;	//   ð 
//		if(m_atimeLastGameEndDate.Year != m_atmeGameStartTime.Year
//			|| m_atimeLastGameEndDate.Month != m_atmeGameStartTime.Month
//			|| m_atimeLastGameEndDate.Day != m_atmeGameStartTime.Day)
//		{// 2006-11-16 by cmkwon,    ð  ƴϸ Ϸ  ð ʱȭ Ѵ.
//			m_nGameContinueTimeInSecondOfToday		= 0;		// 2006-11-16 by cmkwon
//		}
		this->GPInitGameStartTime();		// 2007-06-19 by cmkwon,   ð  - ߱ 5ð   ó
		this->m_nGameStartTimeInSeconds		= ms_pFieldIOCP->GetCurrentServerTime();			// 2006-11-15 by cmkwon, CAtumLogSender::SendLogMessageGAMESTART() ִ  ű
		m_nInsertPCBangEventItemLastCounts	= this->GetPCBangTotalPlayTimeInSeconds()/TERM_30MINUTES_BY_SECOND;		// 2007-06-28 by cmkwon,  7 PC ̺Ʈ  ð ,,// 2007-06-13 by cmkwon,  7 PC θ(̺Ʈ ) -  ð 

		CAtumLogSender::SendLogMessageGAMESTART(this);

#ifdef S_BONUSEXPSYSTEM_RENEWAL
		// 2012-10-07 by hskim, ޽ ġ
		QPARAM_ADDEXP_REST_EXPERIENCE_COUNT *pQParam = new QPARAM_ADDEXP_REST_EXPERIENCE_COUNT;
		pQParam->AccountUID = m_character.AccountUniqueNumber;
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_GetAddExpRestExperienceCount, this, NULL, pQParam);
		// 2012-10-07 by hskim, ޽ ġ
#endif // S_BONUSEXPSYSTEM_RENEWAL

//#ifdef S_BONUS_KILL_SYSTEM_RENEWAL
//		QPARAM_ADDKILL_REST_KILL_COUNT* pQParam = new QPARAM_ADDKILL_REST_KILL_COUNT;
//		pQParam->AccountUID = m_character.AccountUniqueNumber;
//		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_GetAddKillRestKillCount, this, NULL, pQParam);
//#endif // S_BONUS_KILL_SYSTEM_RENEWAL
	}

	// ڽ 
	if (COMPARE_RACE(m_character.Race, RACE_GUEST))
	{
// 2006-11-08 by cmkwon, Ʒ  (IsInvisibleCharacter  ó )
//		SetBodyConditionBit(m_character.BodyCondition, BODYCON_STEALTH_MASK);
		m_bIsInvisibleCharacter		= TRUE;
	}

#ifdef _ATUM_LOAD_TEST
	if(0 != strnicmp(m_character.AccountName, ATUM_LOAD_TEST_PREFIX_ACCOUNT_NAME, ATUM_LOAD_TEST_PREFIX_ACCOUNT_NAME_SIZE))
	{
		// IM Server 
		INIT_MSG(MSG_FI_CONNECT_NOTIFY_FIELDSERVER_IP, T_FI_CONNECT_NOTIFY_FIELDSERVER_IP, msgNotiryFieldIP, SendBuf);
		msgNotiryFieldIP->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
		msgNotiryFieldIP->FieldServerID = ms_pFieldIOCP->m_FieldServerID;

		ms_pFieldIOCP->m_pIMWinSocket->Write(SendBuf, MSG_SIZE(MSG_FI_CONNECT_NOTIFY_FIELDSERVER_IP));

		// IM Server   ˸
		if (type == GST_GAMESTART || type == GST_CONN_GAMESTART)
		{
			INIT_MSG(MSG_FI_CONNECT_NOTIFY_GAMESTART, T_FI_CONNECT_NOTIFY_GAMESTART, msgNotifyGameStart, SendBuf);
			msgNotifyGameStart->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
			msgNotifyGameStart->FieldGameStartType = type;
			msgNotifyGameStart->MapChannelIndex = m_character.MapChannelIndex;
			
			ms_pFieldIOCP->m_pIMWinSocket->Write(SendBuf, MSG_SIZE(MSG_FI_CONNECT_NOTIFY_GAMESTART));
		}

		// Pre Server   ˸
		if (type == GST_GAMESTART || type == GST_GAMESTART)
		{
			INIT_MSG(MSG_FP_EVENT_GAME_STARTED, T_FP_EVENT_GAME_STARTED, msgGameStarted, SendBuf);
			STRNCPY_MEMSET(msgGameStarted->AccountName, m_character.AccountName, SIZE_MAX_ACCOUNT_NAME);
			STRNCPY_MEMSET(msgGameStarted->CharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
			msgGameStarted->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
			msgGameStarted->MapChannelIndex = m_character.MapChannelIndex;
			ms_pFieldIOCP->m_pPreWinSocket->Write(SendBuf, MSG_SIZE(MSG_FP_EVENT_GAME_STARTED));
		}
	}
	else
	{
		m_bIsInvisibleCharacter		= FALSE;		// 2007-01-23 by cmkwon
	}
#else
	// IM Server 
	INIT_MSG(MSG_FI_CONNECT_NOTIFY_FIELDSERVER_IP, T_FI_CONNECT_NOTIFY_FIELDSERVER_IP, msgNotiryFieldIP, SendBuf);
	msgNotiryFieldIP->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
	msgNotiryFieldIP->FieldServerID = ms_pFieldIOCP->m_FieldServerID;

	ms_pFieldIOCP->m_pIMWinSocket->Write(SendBuf, MSG_SIZE(MSG_FI_CONNECT_NOTIFY_FIELDSERVER_IP));

	// IM Server   ˸
	if (type == GST_GAMESTART || type == GST_CONN_GAMESTART)
	{
		INIT_MSG(MSG_FI_CONNECT_NOTIFY_GAMESTART, T_FI_CONNECT_NOTIFY_GAMESTART, msgNotifyGameStart, SendBuf);
		msgNotifyGameStart->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
		msgNotifyGameStart->FieldGameStartType = type;
		msgNotifyGameStart->MapChannelIndex = m_character.MapChannelIndex;

		ms_pFieldIOCP->m_pIMWinSocket->Write(SendBuf, MSG_SIZE(MSG_FI_CONNECT_NOTIFY_GAMESTART));
	}

	// Pre Server   ˸
	if (type == GST_GAMESTART || type == GST_GAMESTART)
	{
		INIT_MSG(MSG_FP_EVENT_GAME_STARTED, T_FP_EVENT_GAME_STARTED, msgGameStarted, SendBuf);
		STRNCPY_MEMSET(msgGameStarted->AccountName, m_character.AccountName, SIZE_MAX_ACCOUNT_NAME);
		STRNCPY_MEMSET(msgGameStarted->CharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
		msgGameStarted->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
		msgGameStarted->MapChannelIndex = m_character.MapChannelIndex;
		ms_pFieldIOCP->m_pPreWinSocket->Write(SendBuf, MSG_SIZE(MSG_FP_EVENT_GAME_STARTED));
	}
#endif // END - _ATUM_LOAD_TEST

	////////////////////////////////////////////////////////////////////////////
	// 2012-10-05 by jhseol, NPlay pc  - pre   updata û
#ifdef S_NPLAY_PCBANG_MODULE_JHSEOL
	if( TRUE != g_pFieldGlobal->IsArenaServer() )
	{
		INIT_MSG_WITH_BUFFER(MSG_FP_PCBANG_USER_GAME_START, T_FP_PCBANG_USER_GAME_START, pSendMsgUserInfoUpdata, SendMsgUserInfoUpdataBuf);
		STRNCPY_MEMSET(pSendMsgUserInfoUpdata->AccountName, m_character.AccountName, SIZE_MAX_ACCOUNT_NAME);
		STRNCPY_MEMSET(pSendMsgUserInfoUpdata->ServerGroupName, g_pFieldGlobal->GetServerGroupName(), SIZE_MAX_SERVER_NAME);
		ms_pFieldIOCP->m_pPreWinSocket->Write(SendMsgUserInfoUpdataBuf, MSG_SIZE(MSG_FP_PCBANG_USER_GAME_START));
	}
#endif
	// end 2012-10-05 by jhseol, NPlay pc  - pre   updata û


	//   ð , LastStartedTime 
	if (type == GST_GAMESTART || type == GST_CONN_GAMESTART)
	{
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateLastStartedTime, this, m_character.AccountUniqueNumber, NULL, NULL, m_character.CharacterUniqueNumber);
	}

	// Ƽ  Ʈ
//	if (m_pFieldParty != NULL && type == GST_WARP_CONN_GAMESTART)
//	{
//		m_pFieldParty->UpdateMemberInfoAllInMap(this, m_pCurrentFieldMapChannel);
//	}
//

	// ù exp  Ѵ
	SendCharacterInfo(T_FC_CHARACTER_CHANGE_EXP);

	// ù HP  
	SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP);

	// ù ȸ Timer 
	m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_HP);
	m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_DP);
	m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_SP);
	m_TimerManager.CheckRecoveryTimer(TE_TYPE_DO_MINUTELY_WORK);

	// General Welcome
	SendString128(STRING_128_USER_NOTICE, "\\c************************************\\c");
	SendString128(STRING_128_SYSTEM_NOTICE, STRMSG_S_F2NOTIFY_0130_1, GetCharacterString2(&m_character, string()));
	//SendString128(STRING_128_USER_POPUP, "\\cRemember Check FAQ and Rules before Playing\\c");

	// Staff Information
	if (COMPARE_RACE(m_character.Race, RACE_ACCOUNT_TYPE_MASK))
	{
		SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0130, GetRaceString(m_character.Race&RACE_ACCOUNT_TYPE_MASK));

		if(this->IsInvisibleCharacter())
		{
			SendString128(STRING_128_USER_NOTICE, STRMSG_060509_0000);
		}
		if(m_bNoDamage)
		{
			SendString128(STRING_128_USER_NOTICE, STRMSG_060509_0001);
		}
		if(m_bStealthState)
		{
			SendString128(STRING_128_USER_NOTICE, STRMSG_060509_0002);
		}
	}

	// SP War Information
	if (!ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.empty())
	{
		this->SendString128(STRING_128_USER_NOTICE, STRCMD_CS_COMMAND_STRATEGYPOINTINFO_EXIST);

		mt_auto_lock mtA(&(ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo));	// 2007-10-08 by cmkwon, lock ʿ

		mtvectorSSUMMON_STRATEGYPOINT_INFO::iterator	itr = ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.begin();
		while (itr != ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.end())
		{
			this->SendString128(STRING_128_USER_NOTICE, "%s  :  %s(%d)"
				, STRCMD_CS_COMMAND_STRATEGYPOINTINFO_ZONE, itr->MapName, itr->MapIndex);
			this->SendString128(STRING_128_USER_NOTICE, "%s  :  %s"
				, STRCMD_CS_COMMAND_STRATEGYPOINTINFO_STARTTIME, itr->SummonStrategyPointTime.GetDateTimeString(STRNBUF(SIZE_MAX_SQL_DATETIME_STRING), TRUE));
			itr++;
		}
	}

	// 2015-06-07 Future, Gear connection Infos
	SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0151, m_character.LastStartedTime.GetDateTimeString(STRNBUF(SIZE_MAX_SQL_DATETIME_STRING)));
	SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0152, m_character.CreatedTime.GetDateTimeString(STRNBUF(SIZE_MAX_SQL_DATETIME_STRING)));
	// Get elapsed playtime from the total playing time in seconds
	UINT playedDays;
	BYTE playedHours, playedMinutes, playedSeconds;
	CAtumSJ::GetDHMSFromTimeInS(m_character.TotalPlayTime, &playedDays, &playedHours, &playedMinutes, &playedSeconds);
	SendString128(STRING_128_USER_NOTICE, STRMSG_S_F2NOTIFY_0153, playedDays, playedHours, playedMinutes, playedSeconds);

	SendString128(STRING_128_USER_NOTICE, "\\c************************************\\c");

// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  - Ŭ̾Ʈ û(T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO)ϴ  
//	if (type == GST_GAMESTART || type == GST_CONN_GAMESTART)
//	{// ̺Ʈ    
//
//		///////////////////////////////////////////////////////////////////////////////
//		// 2006-08-22 by cmkwon, Լ 
//		ms_pFieldIOCP->SendGameEventMessage(this, m_character.InfluenceType);
//	}

// 2009-03-31 by dhjin,   -  ¸   Ǵ ̺Ʈ 
//	///////////////////////////////////////////////////////////////////////////////
//	// 2006-04-21 by cmkwon
//	SDB_INFLUENCE_WAR_INFO *pCurWarInfo = NULL;
//	if(ms_pFieldIOCP->m_InflWarManager.GetINFLUENCE_WAR_INFO_ByInflType(&pCurWarInfo, m_character.InfluenceType))
//	{
//		INIT_MSG(MSG_FC_WAR_INFLUENCE_DATA, T_FC_WAR_INFLUENCE_DATA, pSInflData, SendBuf);
//		pSInflData->byInfluenceType		= pCurWarInfo->InfluenceType;
//		pSInflData->fHPRepairRate		= pCurWarInfo->HPRepairRate;
//		pSInflData->fDPRepairRate		= pCurWarInfo->DPRepairRate;
//		pSInflData->fSPRepairRate		= pCurWarInfo->SPRepairRate;
//		SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_INFLUENCE_DATA));
//	}
	CInflWarData *pInflWarData = ms_pFieldIOCP->m_InflWarManager.GetInflWarDataByInflType(m_character.InfluenceType);
	if(pInflWarData)
	{
		INIT_MSG(MSG_FC_WAR_INFLUENCE_DATA, T_FC_WAR_INFLUENCE_DATA, pSInflData, SendBuf);
		pSInflData->byInfluenceType		= m_character.InfluenceType;
		pSInflData->fHPRepairRate		= pInflWarData->fInflHPRepairRate;
		pSInflData->fDPRepairRate		= pInflWarData->fInflDPRepairRate;
		pSInflData->fSPRepairRate		= pInflWarData->fInflSPRepairRate;
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_INFLUENCE_DATA));
	}
	
	///////////////////////////////////////////////////////////////////////////////
	// 2006-04-20 by cmkwon,  ȯ  
	if(COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI))
	{
		BOOL	CheckBoss	= FALSE;		// 2007-07-16 by dhjin,       ʴ´.
		INIT_MSG(MSG_FC_WAR_BOSS_MONSTER_SUMMON_DATA, T_FC_WAR_BOSS_MONSTER_SUMMON_DATA, pSBossSummon, SendBuf);
		if(ms_pFieldIOCP->m_InflWarManager.GetSummonInflBossMonsterData(pSBossSummon, INFLUENCE_TYPE_VCN))
		{
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_BOSS_MONSTER_SUMMON_DATA));
		}
		if(ms_pFieldIOCP->m_InflWarManager.GetSummonInflBossMonsterData(pSBossSummon, INFLUENCE_TYPE_ANI))
		{
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_BOSS_MONSTER_SUMMON_DATA));
		}
		if(ms_pFieldIOCP->m_InflWarManager.GetVCNSummonedInflBossMonsterData(pSBossSummon))
		{// 2007-02-06 by dhjin,  () Ǿ    üũϿ 
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_BOSS_MONSTER_SUMMON_DATA));
			CheckBoss = TRUE;
		}
		if(ms_pFieldIOCP->m_InflWarManager.GetANISummonedInflBossMonsterData(pSBossSummon))
		{// 2007-02-06 by dhjin, ˸ () Ǿ    üũϿ 
			SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_BOSS_MONSTER_SUMMON_DATA));
			CheckBoss = TRUE;
		}
		if(FALSE == CheckBoss
			&& !ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.empty())
		{// 2007-07-16 by dhjin,   .
			
			INIT_MSG(MSG_FC_WAR_STRATEGYPOINT_MONSTER_SUMMON, T_FC_WAR_STRATEGYPOINT_MONSTER_SUMMON, pSBossSummon, SendBuf);

			mt_auto_lock mtA(&(ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo));	// 2007-10-08 by cmkwon, lock ʿ
			mtvectorSSUMMON_STRATEGYPOINT_INFO::iterator	itr = ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.begin();
			while(itr != ms_pFieldIOCP->m_InflWarManager.m_mtvectSummonStrategyPointInfo.end())
			{
				pSBossSummon->InfluenceType				= itr->InfluenceType;
				pSBossSummon->MapIndex					= itr->MapIndex;
				STRNCPY_MEMSET(pSBossSummon->MapName, itr->MapName, SIZE_MAX_MAP_NAME);
				pSBossSummon->SummonStrategyPointTime	= itr->SummonStrategyPointTime;
				SendAddData(SendBuf, MSG_SIZE(MSG_FC_WAR_STRATEGYPOINT_MONSTER_SUMMON));
				itr++;
			}
		}
	}
	

	//////////////////////////////////////////////////////////////////////////
	// 2007-09-14 by dhjin,    
	INIT_MSG(MSG_FC_OUTPOST_WAR_INFO, T_FC_OUTPOST_WAR_INFO, pSOutPostWarInfo, SendBuf);
	pSOutPostWarInfo->OutPostWarInfoListCount = this->ms_pFieldIOCP->m_OutPostManager.CheckAllOutPostWaringAndSendClient((SOUTPOST_WAR_INFO*)(SendBuf+MSG_SIZE(MSG_FC_OUTPOST_WAR_INFO)));
	if(0 < pSOutPostWarInfo->OutPostWarInfoListCount)
	{
		this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_OUTPOST_WAR_INFO)+pSOutPostWarInfo->OutPostWarInfoListCount*sizeof(SOUTPOST_WAR_INFO));
	}

	// ׿,  ð 
	m_nOldTimeStampDBG = ms_pFieldIOCP->GetCurrentServerTimeInMilliSeconds();

	//////////////////////////////////////////////////////////////////////////
	// 2008-03-26 by dhjin,   ǥ ȹ - Ʈ    
	if(ms_pFieldIOCP->m_InflWarManager.CheckSummonBoss())
	{
		ms_pFieldIOCP->m_InflWarManager.SendMSWarInfoForUser(this);		
	}
	ms_pFieldIOCP->m_InflWarManager.SendMSWarOptionTypeForInfluenceUser(this);

	//////////////////////////////////////////////////////////////////////////
	// 2008-04-23 by dhjin, EP3  ý - 
	this->GetDBAllLetter();

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	if(FALSE == g_pFieldGlobal->IsArenaServer()) {
		// Ʒ  MainServerκ  ޴´.!!!!
		this->GetDBInfinityImpute();
	}

	// 2013-05-09 by hskim,  Ʈ 
#ifdef S_UPGRADE_INFLUENCE_POINT_HSKIM
	if( this->IsCityCurrentFieldMapChannel() )
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_WAR_INFLUENCE_CONSECUTIVE_VICTORITES, T_FC_WAR_INFLUENCE_CONSECUTIVE_VICTORITES, pInflVictory, pInflVictorySendBuf);
		pInflVictory->PointBCU = ms_pFieldIOCP->m_InflWarManager.GetConsecutiveVictoriesPoint(INFLUENCE_TYPE_VCN);
		pInflVictory->PointANI = ms_pFieldIOCP->m_InflWarManager.GetConsecutiveVictoriesPoint(INFLUENCE_TYPE_ANI);
		SendAddData(pInflVictorySendBuf, MSG_SIZE(MSG_FC_WAR_INFLUENCE_CONSECUTIVE_VICTORITES));
	}

	this->ApplyBuffSkillByTurnAround();
#endif
	// end 2013-05-09 by hskim,  Ʈ 	

//////////////////////////////////////////////////////////////////////////
// 2007-12-12 by dhjin,   κ   ø.
//	///////////////////////////////////////////////////////////////////////////////
//	// 2007-08-30 by cmkwon, ȸǷ ý  -    üũ
//	if(IS_CONFERENCEROOM_MAP_INDEX(m_character.MapChannelIndex.MapIndex))
//	{
//		CFieldMapProject *pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(CFieldMapProject::GetConferenceRoomMapIndex(m_character.InfluenceType));
//		if(NULL == pFMPro
//			|| FALSE == pFMPro->IsWarpableUser(m_character.CharacterUniqueNumber, m_character.Race))
//		{
//			this->WarpToCityMap();
//		}
//	}
//	else if(IS_OUTPOST_CITY_MAP_INDEX(m_character.MapChannelIndex.MapIndex)
//		|| IS_MAP_INFLUENCE_OUTPOST(m_pCurrentFieldMapChannel->GetMapInfluenceTypeW()))
//	{	// 2007-09-28 by dhjin, øʿ ۽   ƴϸ  ȯ
//
//		if(m_character.MapChannelIndex.MapIndex != ms_pFieldIOCP->m_OutPostManager.GetOutPostCityMapIndexByGuildUID(m_character.GuildUniqueNumber))
//		{
//			this->WarpToCityMap();
//		}
//	}

	// 2015-06-13 Future, get cached kill count
#ifdef S_BONUS_KILL_SYSTEM_RENEWAL
	m_nKillCount = ms_pFieldIOCP->GetCachedKillCount(m_character.CharacterUniqueNumber);
	if (m_nKillCount > 0)
	{
		SendToClient_KillCount();
	}
#endif // S_BONUS_KILL_SYSTEM_RENEWAL

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::CheckCurrentMapOnGameStart(void)
/// \brief		// 2007-12-26 by cmkwon, CurrentMap üũ ý  - CFieldIOCPSocket::CheckCurrentMapOnGameStart() ߰
/// \author		cmkwon
/// \date		2007-12-26 ~ 2007-12-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::CheckCurrentMapOnGameStart(void)
{
	CHARACTER *pCharacter = &m_character;

	CFieldMapChannel *pCityFMapChan = this->GetCityFieldMapChannelPtr(pCharacter->InfluenceType, pCharacter->GetStartCityMapIndex());	// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::CheckCurrentMapOnGameStart#

	///////////////////////////////////////////////////////////////////////////////
	// 2007-02-26 by cmkwon,  ĳ ʰ PositionVector ȿ üũ
	CFieldMapChannel *pFMChann = GetFieldMapChannel(&(pCharacter->MapChannelIndex), TRUE);
	if (NULL == pFMChann			// 2007-02-26 by cmkwon, 񽺵 ʴ ä
		|| IS_MAP_INFLUENCE_EVENT_AREA(pFMChann->m_pFieldMapProject->m_nMapInfluenceType)	// 2007-02-26 by cmkwon, ̺Ʈ
		|| IS_MAP_INFLUENCE_ARENA(pFMChann->m_pFieldMapProject->m_nMapInfluenceType)		// 2007-05-07 by dhjin, Ʒ ̸ 
// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::CheckCurrentMapOnGameStart#, Ʒ  
//		|| IS_OTHER_INFLUENCE_MAP(pCharacter->InfluenceType, pFMChann->m_pFieldMapProject->m_nMapInfluenceType) 	// 2007-08-29 by dhjin, ٸ  ʿ  ϸ  		
		|| CAtumSJ::IsOtherInfluenceMap(pCharacter->InfluenceType, pCharacter->GetStartCityMapIndex(), pFMChann->GetMapInfluenceTypeW())	// 2009-10-12 by cmkwon, ī    - 
		|| ( IS_NORMAL_INFLUENCE_TYPE(pCharacter->InfluenceType) && IS_VCN_CITY_MAP_INDEX(pFMChann->GetMapChannelIndex().MapIndex) )	// 2008-01-17 by cmkwon, S_F: Ϲݼ Ա ÿ   ̵
		)
	{
		// 2007-06-13 by cmkwon, loadtest  Ѵ.
		if(NULL == pFMChann
			|| 0 != strnicmp(pCharacter->AccountName, ATUM_LOAD_TEST_PREFIX_ACCOUNT_NAME, strlen(ATUM_LOAD_TEST_PREFIX_ACCOUNT_NAME)) )
		{
			// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::CheckCurrentMapOnGameStart#,
			//pFMChann = this->GetCityFieldMapChannelPtr(pCharacter->InfluenceType);
			pFMChann = pCityFMapChan;		// 2009-10-12 by cmkwon, ī    - 
			if(NULL	== pFMChann)
			{
				return FALSE;
			}
			pCharacter->PositionVector	= pFMChann->m_pMapProject->GetRandomXZCityWarpTargetPosition();
		}
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-08-30 by cmkwon, ȸǷ ý  -    üũ			
	if(IS_CONFERENCEROOM_MAP_INDEX(pFMChann->GetMapChannelIndex().MapIndex))
	{
		CFieldMapProject *pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(CFieldMapProject::GetConferenceRoomMapIndex(pCharacter->InfluenceType));
		if(NULL ==pFMPro
			|| FALSE == pFMPro->IsWarpableUser(pCharacter->CharacterUniqueNumber, pCharacter->Race))
		{
			// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::CheckCurrentMapOnGameStart#,
			//pFMChann = this->GetCityFieldMapChannelPtr(pCharacter->InfluenceType);
			pFMChann = pCityFMapChan;		// 2009-10-12 by cmkwon, ī    - 
			if(NULL	== pFMChann)
			{				
				return FALSE;
			}
			pCharacter->PositionVector	= pFMChann->m_pMapProject->GetRandomXZCityWarpTargetPosition();
		}
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-09-28 by dhjin, øʿ ۽   ƴϸ  ȯ
	if(IS_OUTPOST_CITY_MAP_INDEX(pFMChann->GetMapChannelIndex().MapIndex)
		|| IS_MAP_INFLUENCE_OUTPOST(pFMChann->GetMapInfluenceTypeW()))
	{
		if(pCharacter->MapChannelIndex.MapIndex != ms_pFieldIOCP->m_OutPostManager.GetOutPostCityMapIndexByGuildUID(pCharacter->GuildUniqueNumber))
		{
			// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::CheckCurrentMapOnGameStart#,
			//pFMChann = this->GetCityFieldMapChannelPtr(pCharacter->InfluenceType);
			pFMChann = pCityFMapChan;		// 2009-10-12 by cmkwon, ī    - 
			if(NULL	== pFMChann)
			{
				SendErrorMessage(T_FC_CHARACTER_GET_CHARACTER, ERR_PROTOCOL_NO_SUCH_MAP_SERVED);
				return FALSE;
			}
			pCharacter->PositionVector	= pFMChann->m_pMapProject->GetRandomXZCityWarpTargetPosition();
		}
	}

	// start 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
	if( ERR_NO_ERROR != pFMChann->m_pFieldMapProject->IsEnableWarpByMapProject(this, TRUE) )
	{
		CFieldMapProject *pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pFMChann->m_pFieldMapProject->m_nBeforeMapIndex);

		if( NULL != pFMPro )
		{
			pFMChann = (CFieldMapChannel*)(pFMPro->GetMapChannelByIndex(0));		// ⺻ äη ̵

			if(NULL	== pFMChann)
			{
				SendErrorMessage(T_FC_CHARACTER_GET_CHARACTER, ERR_PROTOCOL_NO_SUCH_MAP_SERVED);

				return FALSE;
			}

			pCharacter->PositionVector	= pFMChann->GetDefaultPointW();
		}
		else
		{
			pFMChann = pCityFMapChan;		// Ȥó BackMap  Ǿ  ʴٸ  

			if(NULL	== pFMChann)
			{
				SendErrorMessage(T_FC_CHARACTER_GET_CHARACTER, ERR_PROTOCOL_NO_SUCH_MAP_SERVED);

				return FALSE;
			}

			pCharacter->PositionVector	= pFMChann->m_pMapProject->GetRandomXZCityWarpTargetPosition();
		}
	}
	// end 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý

	// 2012-08-01 by hskim,   -      Ұ 2
	if( IS_STONES_RUIN_MAP_INDEX(pFMChann->m_pFieldMapProject->m_nMapIndex) )
	{
		if( COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_VCN | INFLUENCE_TYPE_ANI) )
		{
			if( TRUE == ms_pFieldIOCP->m_InflWarManager.CheckBossMonsterSummoningByAttackInfl(INFLUENCE_TYPE_ANI) )
			{
				// Ϲ  ƴ      ο     
				
				pFMChann = pCityFMapChan;
				
				if(NULL	== pFMChann)
				{
					SendErrorMessage(T_FC_CHARACTER_GET_CHARACTER, ERR_PROTOCOL_NO_SUCH_MAP_SERVED);
					
					return FALSE;
				}
				
				pCharacter->PositionVector	= pFMChann->m_pMapProject->GetRandomXZCityWarpTargetPosition();				
			}
		}
	}
	// end 2012-08-01 by hskim,   -      Ұ 2

	pCharacter->MapChannelIndex		= pFMChann->GetMapChannelIndex();

	if(FALSE == pFMChann->m_pFieldMapProject->CheckCharacterPosition(&pCharacter->PositionVector, TRUE))
	{// 2007-02-26 by cmkwon, PositionVector ȿ üũ
		pCharacter->PositionVector	= pFMChann->GetDefaultPointW();
	}

	CLEAR_BODYCON_BIT(pCharacter->BodyCondition, BODYCON_LANDED_MASK);
	if(FALSE == COMPARE_BODYCON_BIT(pCharacter->BodyCondition, BODYCON_DEAD_MASK))
	{//   ° ƴϸ

		// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::CheckCurrentMapOnGameStart#,
		//if(pFMChann == this->GetCityFieldMapChannelPtr(pCharacter->InfluenceType)
		if(pFMChann == pCityFMapChan		// 2009-10-12 by cmkwon, ī    - 
			|| IS_BAZAAR_MAP_INDEX(pFMChann->GetMapChannelIndex().MapIndex)
			|| IS_OUTPOST_CITY_MAP_INDEX(pFMChann->GetMapChannelIndex().MapIndex))	// 2007-09-10 by dhjin,   ʵ ɸ  
		{// 2007-02-26 by cmkwon, øʰ ڸ ׻ ĳ͸ ۵ȴ.
			pCharacter->CharacterMode	= TRUE;
		}
		else
		{// 2007-02-26 by cmkwon, ٸ ĳ͸ Ҽ 
			pCharacter->CharacterMode	= FALSE;
		}

		if(pCharacter->CharacterMode)
		{
// 2010-04-14 by cmkwon,  ޸    - 
// 			//   ̸  · set -> HP ȸ Ʒ SP ȸ  ִ.
// 			TILEINFO *pTile = pFMChann->m_pFieldMapProject->GetTileInfo(&pCharacter->PositionVector);
// 			if(NULL == pTile
// 				|| (EVENT_TYPE_ENTER_BUILDING != pTile->m_EventInfo.m_bEventType && EVENT_TYPE_ENTER_BUILDING_BAZAAR != pTile->m_EventInfo.m_bEventType))	// 2006-08-07 by cmkwon,  ʵ ߰
// 			{			
// 				pCharacter->PositionVector	= pFMChann->m_pFieldMapProject->GetRandomXZCityWarpTargetPosition();
// 			}
			///////////////////////////////////////////////////////////////////////////////
			// 2010-04-14 by cmkwon,  ޸    - 
			EVENTINFO *pTileEvInfo = pFMChann->GetTileEventInfoW(&pCharacter->PositionVector);
			if(NULL == pTileEvInfo
				|| (EVENT_TYPE_ENTER_BUILDING != pTileEvInfo->m_bEventType && EVENT_TYPE_ENTER_BUILDING_BAZAAR != pTileEvInfo->m_bEventType))
			{
 				pCharacter->PositionVector	= pFMChann->m_pFieldMapProject->GetRandomXZCityWarpTargetPosition();
			}
			
			SET_BODYCON_BIT(pCharacter->BodyCondition, BODYCON_CHARACTER_MODE_STOP);
		}
	}
	else
	{//   

		// 2008-04-01 by cmkwon, øʿ    ȰѼ ĳ · ó - 
		if(FALSE == IS_CITY_MAP_INDEX(pCharacter->MapChannelIndex.MapIndex))
		{
			pCharacter->CurrentHP			= 0.0f;
			pCharacter->CurrentDP			= 0.0f;

			pCharacter->CharacterMode		= FALSE;		// 2006-10-17 by cmkwon,  ¸  óѴ.

			SET_BODYCON_BIT(pCharacter->BodyCondition, BODYCON_DEAD_MASK);
			CLEAR_BODYCON_BIT(pCharacter->BodyCondition, BODYCON_BOOSTER_EX_STATE_CLEAR_MASK);	// 2005-07-29 by cmkwon,  ´ 
		}
		else
		{
			// 2008-04-01 by cmkwon, øʿ    ȰѼ ĳ · ó - 
			this->CharacterDeadGameStartRoutine(FALSE, m_character.HP, m_character.DP);
			this->m_bDeadReasonByPK			= FALSE;
			pCharacter->CharacterMode		= TRUE;			// ĳͻ· 
			pCharacter->PositionVector		= pFMChann->m_pMapProject->GetRandomXZCityWarpTargetPosition();
		}
	}

	return TRUE;
}


BOOL CFieldIOCPSocket::CharacterSaveCriticalData(BOOL i_bSynchExec /* = FALSE */)
{
	if(g_pFieldGlobal->IsArenaServer())
	{// 2008-01-31 by dhjin, Ʒ   ʴ´.
		return FALSE;
	}	
	
	if (!IS_VALID_UNIQUE_NUMBER(m_character.CharacterUniqueNumber)
		|| m_character.CharacterUniqueNumber == 0
		|| !IS_VALID_CLIENT_INDEX(m_character.ClientIndex))
	{
		DBGOUT2(DO2_DBGOUT|DO2_SYSLOG, "---> CFieldIOCPSocket::CharacterSaveCriticalData()_1 INVALID %s\r\n", GetCharacterString(&m_character, string()));
		return FALSE;
	}

#ifdef _DEBUG
	DBGOUT("---> CFieldIOCPSocket::CharacterSaveCriticalData()_2 %s\r\n", GetCharacterString(&m_character, string()));
#endif

	///////////////////////////////////////////////////////////////////////////
	// DB  Bullet Count Ѵ.
	SaveCurrentBulletCount((ITEM_GENERAL*)m_ItemProwOut.ItemNum);	// 1 
	SaveCurrentBulletCount((ITEM_GENERAL*)m_ItemWingOut.ItemNum);	// 2 

	///////////////////////////////////////////////////////////////////////////
	// īͺ  īƮ ٸ͸ Ѵ
	m_ItemManager.StoreCountableItem();

	///////////////////////////////////////////////////////////////////////////////
	// 2006-05-21 by cmkwon, ġ  ý
	this->StoreExperienceDelayStore();

	///////////////////////////////////////////////////////////////////////////////
	//  ð   ð Ͽ DB 
	m_ItemManager.StoreTimeStampUsingTimeLimitedIteList();

	///////////////////////////////////////////////////////////////////////////////
	// ߿ Ÿ  
	QPARAM_CHARACTER_SAVE_CRITICAL_DATA *pQCharacData = new QPARAM_CHARACTER_SAVE_CRITICAL_DATA;
	pQCharacData->CharacterUID		= m_character.CharacterUniqueNumber;
	pQCharacData->Level				= m_character.Level;
	pQCharacData->CharacterMode0	= m_character.CharacterMode;
	pQCharacData->Experience		= m_character.Experience;
	pQCharacData->DownExperience	= (FALSE == COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_DEAD_MASK)) ? 0.0f : m_character.DownExperience;
	pQCharacData->DownSPIOnDeath0	= (FALSE == COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_DEAD_MASK)) ? 0 : m_character.DownSPIOnDeath;	// 2006-04-10 by cmkwon
	pQCharacData->BodyCondition		= (m_character.BodyCondition&BODYCON_KEEPING_MASK);	//  body condition 
	pQCharacData->PetLevel			= m_character.PetLevel;
	pQCharacData->PetExperience		= m_character.PetExperience;
	pQCharacData->Position_X		= m_character.PositionVector.x;
	pQCharacData->Position_Y		= m_character.PositionVector.y;
	pQCharacData->Position_Z		= m_character.PositionVector.z;
	pQCharacData->MapIndex			= m_character.MapChannelIndex.MapIndex;
	pQCharacData->ChannelIndex		= m_character.MapChannelIndex.ChannelIndex;
	pQCharacData->HP				= m_character.HP;
	pQCharacData->DP				= m_character.DP;
	pQCharacData->SP				= m_character.SP;
	pQCharacData->EP				= m_character.EP;
	pQCharacData->CurrentHP			= m_character.CurrentHP;
	pQCharacData->CurrentDP			= m_character.CurrentDP;
	pQCharacData->CurrentSP			= m_character.CurrentSP;
	pQCharacData->CurrentEP			= m_character.CurrentEP;
	pQCharacData->TotalPlayTime		= GetTotalPlayTimeInSeconds();
	pQCharacData->LastGameEndDate.SetCurrentDateTime();													// 2006-11-16 by cmkwon
	pQCharacData->GameContinueTimeInSecondOfToday	= this->GetCurGameContinueTimeInSecondOfToday();	// 2006-11-16 by cmkwon
// 2007-05-29 by cmkwon, ʿ
//	pQCharacData->WarPoint			= m_character.WarPoint;												// 2007-04-25 by dhjin
	pQCharacData->PCBangTotalPlayTime	= GetPCBangTotalPlayTimeInSeconds();
	pQCharacData->SecretInfoOption	= m_character.SecretInfoOption;				// 2008-06-23 by dhjin, EP3 ɼ -

	// 2007-06-13 by cmkwon,  7 PC θ(̺Ʈ ) -  ð üũ
	if(this->m_bIsPCBangClient
		&& m_nInsertPCBangEventItemLastCounts < (int)(pQCharacData->PCBangTotalPlayTime/TERM_30MINUTES_BY_SECOND))		// 2007-06-28 by cmkwon,  7 PC ̺Ʈ  ð 
	{
		pQCharacData->PCBangTotalPlayTime = max(0, pQCharacData->PCBangTotalPlayTime-120);	// 2  Ѵ
	}

	this->m_atimeLastGameEndDate					= pQCharacData->LastGameEndDate;					// 2006-11-16 by cmkwon

	if (i_bSynchExec)
	{
		// Synchronous Execution
		ms_pFieldIOCP->m_pAtumDBManager->ExecuteQuery(QT_SaveCharacterCriticalData, this, pQCharacData);
	}
	else
	{
		// Asynchronous Execution
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_SaveCharacterCriticalData, this, m_character.AccountUniqueNumber, pQCharacData);
	}

	return TRUE;
}

void CFieldIOCPSocket::CharacterGameEndRoutine(void)
{
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó, Ʒ ÷  üũ
	BOOL bArenaPlayUser = FALSE;

	// 2013-05-31 by jhseol,bckim Ƹ ÷ -   ƾ
#ifdef SC_COLLECTION_ARMOR_JHSEOL_BCKIM	// -   ƾ
	m_ArmorCollection.CollectionFinish();
#endif
	// 2013-05-31 by jhseol,bckim Ƹ ÷ -   ƾ
		
	this->m_mtCritSecForGameEndRoutine.Enter();
	{
		if(CS_PLAYING > this->GetClientState()				// 2008-02-11 by dhjin, Ʒ  -
			|| FALSE == m_bFlagDBStore
			|| m_character.CharacterUniqueNumber == 0)
		{	//  ƾ ó .
#ifdef _DEBUG
			DBGOUT2(DO2_DBGOUT|DO2_SYSLOG, STRMSG_S_F2NOTIFY_0131, GetCharacterString(&m_character, string()), GetClientState(), m_bFlagDBStore);
#endif
			this->m_mtCritSecForGameEndRoutine.Leave();
			return;
		}

		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó, Ʒ ÷  üũ
		if(CS_ARENASERVER_PLAYING == this->GetClientState()) {
			bArenaPlayUser = TRUE;
		}

		this->SetClientState(CS_LOGINED);	// ĳ   ٽ .
		m_bFlagDBStore = FALSE;				//  GameEnd,  ġ DB  Ͽ  Closeÿ   ʿ 
	}
	this->m_mtCritSecForGameEndRoutine.Leave();

	g_pFieldGlobal->WriteSystemLogEX(TRUE, "  GameEndRoutine %s Map(%04d) Position(%4d, %4d, %4d)\r\n",
		GetCharacterString(&m_character, string()), m_character.MapChannelIndex.MapIndex, (int)m_character.PositionVector.x,
		(int)m_character.PositionVector.y, (int)m_character.PositionVector.z);

	///////////////////////////////////////////////////////////////////////////////
	// 2010-04-06 by cmkwon, 2 ߰  - 
	this->InfinityOnCharacterGameEndRoutine();
	this->ArenaOnCharacterGameEndRoutine();

	///////////////////////////////////////////////////////////////////////////////
	// 2008-04-11 by cmkwon,  ÿ  ų ʱȭ - 76(Yedang_Kor)  
	this->ResetAllSkill();

	BYTE						SendBuf[SIZE_MAX_PACKET];
	MSG_FN_CLIENT_GAMEEND_OK	*pSendClientGameEndOK = NULL;	
	// MSG ̸  α
	INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_GAMEEND_OK, T_FC_CHARACTER_GAMEEND_OK, pMsgGameEndOK, pMsgGameEndOKBuf);
	pMsgGameEndOK->ClientIndex = m_character.ClientIndex;

	// PK̾ٸ, PK Reset ó
	if (IS_VALID_CLIENT_INDEX(m_peerP2PPKClientIndex))
	{
		CFieldIOCPSocket *pPeerPKSocket = ms_pFieldIOCP->GetFieldIOCPSocket(m_peerP2PPKClientIndex);
		OnP2PPKEnd(pPeerPKSocket, this);
	}

	// Ƽ  ó
	if (this->IsPartyBattleState())
	{
		OnPartyBattleMemberDead(TRUE);
	}


	vectCFieldIOCPSocket vectCFISockList;	// 2008-12-30 by cmkwon, Ƽ Move ó ý  - CFieldIOCPSocket::CharacterGameEndRoutine(),   ó

	// Ƽ̸ Ƽ Ʈ 
	CFieldParty *ptmFParty = m_pFieldParty;
	if ( NULL != ptmFParty)
	{		
		mt_auto_lock pslock(&ms_pFieldIOCP->m_MapParties);
		mt_auto_lock pmlock(&ptmFParty->m_ListPartyMember);		// lock m_ListPartyMember
			
		// Ƽ鿡 GAMEEND 
		ptmFParty->SendMsgToMembersMap(pMsgGameEndOKBuf, MSG_SIZE(MSG_FC_CHARACTER_GAMEEND_OK), m_pCurrentFieldMapChannel, m_character.CharacterUniqueNumber);
			
		FieldPartyMember tmpMember;
		if (ptmFParty->DeleteByCharacterUniqueNumber(m_character.CharacterUniqueNumber, tmpMember))
		{
			//   
// 2007-09-14 by cmkwon, ʿ  ּ ó
//			assert(this == tmpMember.PM_CharacterSocket);
		}
		else
		{
			// ̷  Ǵµ...
			g_pFieldGlobal->WriteSystemLogEX(TRUE, STRMSG_S_F2NOTIFY_0132, GetCharacterString(&m_character, string()));
		}

#ifdef S_ITEM_EVENT_RETURN_USER_BCKIM				// 2013-02-28 by bckim,  ߰
		if( NULL != m_pFieldParty)					//	2013-07-07 by bckim,    
		{
			m_pFieldParty->SetReturnUserBuffSkill(this); // DeleteByCharacterUniqueNumberĿ   
		}
#endif

		ptmFParty->GetAllMembers(&vectCFISockList);		// 2008-12-30 by cmkwon, Ƽ Move ó ý  - CFieldIOCPSocket::CharacterGameEndRoutine(),   ó
		
		// Ƽ  
		if (ptmFParty->empty())
		{
			ms_pFieldIOCP->m_MapParties.deleteLock(ptmFParty->m_PartyID);
			pmlock.auto_unlock_cancel();
			ms_pFieldIOCP->DeleteFieldParty(ptmFParty);			
		}
	}
	m_pFieldParty = NULL;

	CFieldIOCPSocket::ArrangeAllPartyMember(&vectCFISockList);		// 2008-12-30 by cmkwon, Ƽ Move ó ý  - CFieldIOCPSocket::CharacterGameEndRoutine(),   ó
	this->CleanPartyMemberList();									// 2008-12-30 by cmkwon, Ƽ Move ó ý  - CFieldIOCPSocket::CharacterGameEndRoutine(),   ó

	//  ڷ  
	ms_pFieldIOCP->m_mapCharacterUniqueNumber.deleteLock(m_character.CharacterUniqueNumber);
	char tmCharacterName[SIZE_MAX_CHARACTER_NAME];	
	ms_pFieldIOCP->m_mapCharacterName.deleteLock(GGetLowerCase(tmCharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME));

	// 2010-06-15 by shcho&hslee ý -   ޸ 
	
	// this->m_ItemManager.DeleteItemPetDataGameEnd();
	// END 2010-06-15 by shcho&hslee ý -   ޸ 
	
	///////////////////////////////////////////////////////////////////////////
	// ŷ resetϱ
	if (m_peerTraderCharacterUniqueNumber != INVALID_UNIQUE_NUMBER)
	{
		CFieldIOCPSocket *pPeerTraderSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
		if (NULL != pPeerTraderSocket)
		{
			INIT_MSG(MSG_FC_TRADE_CANCEL_TRADE_OK, T_FC_TRADE_CANCEL_TRADE_OK, msgCancelTradeOK, SendBuf);
			msgCancelTradeOK->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
			pPeerTraderSocket->SendAddData(SendBuf, MSG_SIZE(MSG_FC_TRADE_CANCEL_TRADE_OK));

			pPeerTraderSocket->m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
			pPeerTraderSocket->m_bOKTradeChecked = FALSE;
			pPeerTraderSocket->m_mapTradeItem.clearLock();
		}
		m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
		m_bOKTradeChecked = FALSE;
		m_mapTradeItem.clearLock();
	}

	// ѷ  
	ClearAllCharacterMines();

	if (m_pCurrentFieldMapChannel != NULL)
	{
		///////////////////////////////////////////////////////////////////////////
		// NPC Server GameEndOK ޼ Ѵ.
		INIT_MSG(MSG_FN_CLIENT_GAMEEND_OK, T_FN_CLIENT_GAMEEND_OK, pSendClientGameEndOK, SendBuf);
		pSendClientGameEndOK->ChannelIndex	= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
		pSendClientGameEndOK->ClientIndex	= m_character.ClientIndex;
		m_pCurrentFieldMapChannel->Send2NPCServerW(SendBuf, MSG_SIZE(MSG_FN_CLIENT_GAMEEND_OK));
	}

	if (!m_bFieldServerChangeFlag)
	{
		///////////////////////////////////////////////////////////////////////////
		// IM Server GameEndOK ޼ Ѵ.
		*(MessageType_t*)SendBuf = T_FI_CONNECT_NOTIFY_GAMEEND;
		MSG_FI_CONNECT_NOTIFY_GAMEEND	*pMsgChatGameEnd = NULL;
		pMsgChatGameEnd = (MSG_FI_CONNECT_NOTIFY_GAMEEND*)(SendBuf + SIZE_FIELD_TYPE_HEADER);
		pMsgChatGameEnd->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
		ms_pFieldIOCP->m_pIMWinSocket->Write((char*)SendBuf, MSG_SIZE(MSG_FI_CONNECT_NOTIFY_GAMEEND));
	}

	// 2008-02-11 by dhjin, Ʒ  - ڱ ڽſ   
	
	///////////////////////////////////////////////////////////////////////////
	// ڽŰ  ĳͿ GameEndOK ޼ Ѵ.
	ms_pFieldIOCP->SendInRangeMessageAroundCharacter(this->GetClientArrayIndex(), pMsgGameEndOKBuf, MSG_SIZE(MSG_FC_CHARACTER_GAMEEND_OK)
		, m_pCurrentFieldMapChannel, FALSE, m_pCurrentFieldMapChannel->GetUserVisibleDiameterW());
	this->SendAddData(pMsgGameEndOKBuf, MSG_SIZE(MSG_FC_CHARACTER_GAMEEND_OK));

	///////////////////////////////////////////////////////////////////////////
	// ڽŰ  ĳͿ GameEndOK ޼ Ѵ.
//	ms_pFieldIOCP->SendInRangeMessageAroundCharacter(this->GetClientArrayIndex(), pMsgGameEndOKBuf, MSG_SIZE(MSG_FC_CHARACTER_GAMEEND_OK)
//		, m_pCurrentFieldMapChannel, TRUE, m_pCurrentFieldMapChannel->GetUserVisibleDiameterW());

	///////////////////////////////////////////////////////////////////////////
	// ڽ   Block  Ѵ.
	if (m_pCurrentFieldMapChannel != NULL)
	{
		if(FALSE == m_pCurrentFieldMapChannel->DeleteBlockPosition(m_character.PositionVector.x, m_character.PositionVector.z, m_character.ClientIndex))
		{
			char szTemp[256];
			sprintf(szTemp, "[Error] DeleteBlockPosition_3 Error, MapChannel(%s) UnitIndex(%5d) XZ(%5.0f, %5.0f) \r\n"
				, GET_MAP_STRING(m_pCurrentFieldMapChannel->m_MapChannelIndex), m_character.ClientIndex
				, m_character.PositionVector.x, m_character.PositionVector.z);
			DBGOUT(szTemp);
			g_pFieldGlobal->WriteSystemLog(szTemp);
		}
		m_pCurrentFieldMapChannel->m_mapCharacterUniqueNumberMapProject.deleteLock(m_character.CharacterUniqueNumber);
	}

// 2005-03-22 by cmkwon, ׽Ʈ
//	if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_DEAD_MASK) == TRUE
//		|| m_character.CurrentHP <= 0.0f)
//	{
//		// ׾ٸ  
//		m_character.MapChannelIndex.MapIndex		= this->GetDefaultCityMapProject()->m_nMapIndex;
//		m_character.PositionVector					= this->GetDefaultCityMapProject()->GetDefaultPoint();
//		m_character.MapChannelIndex.ChannelIndex	= 0;	// check: MapChannel , 20040322, kelovon
//
//		this->CharacterDeadGameStartRoutine(FALSE);
//	}

	///////////////////////////////////////////////////////////////////////////////
	// ڽ  ϴ  AttackedInfoList  ڽ  Ѵ
	this->DeleteMeFromMonsterAttackedList();

	///////////////////////////////////////////////////////////////////////////
	// character cache update
	this->UpdateCharacterCacheLock(m_character.CharacterUniqueNumber, &m_character);

	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó, ذ  
//	// DB  ĳ Ÿ 
//	CharacterSaveCriticalData();
	if(FALSE == bArenaPlayUser) {
		CharacterSaveCriticalData();
	}

	// ÿ α׸ Ѵ.
	CAtumLogSender::SendLogMessageGAMEEND(this);

#ifdef S_BONUSEXPSYSTEM_RENEWAL
	// 2012-10-07 by hskim, ޽ ġ
	QPARAM_ADDEXP_REST_EXPERIENCE_COUNT *pQParam = new QPARAM_ADDEXP_REST_EXPERIENCE_COUNT;
	pQParam->AccountUID = m_character.AccountUniqueNumber;
	pQParam->RestExperienceCount = m_nRestExperienceCount;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_SetAddExpRestExperienceCount, this, NULL, pQParam);
	// 2012-10-07 by hskim, ޽ ġ
#endif // S_BONUSEXPSYSTEM_RENEWAL

//#ifdef S_BONUS_KILL_SYSTEM_RENEWAL
//	// 2015-06-11 Future, Kill System
//	QPARAM_ADDKILL_REST_KILL_COUNT* pQParam = new QPARAM_ADDKILL_REST_KILL_COUNT;
//	pQParam->AccountUID = m_character.AccountUniqueNumber;
//	pQParam->RestKillCount = m_nRestKillCount;
//	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_SetAddKillrestKillCount, this, NULL, pQParam);
//	// end 2015-06-11 Future, Kill System
//#endif // S_BONUS_KILL_SYSTEM_RENEWAL

	

	///////////////////////////////////////////////////////////////////////////////
	// 2007-06-14 by cmkwon,   ð  ⺻ ý  - PlayTime  , ĳ  ó 
	// 2007-11-07 by cmkwon,   ð   -  ι   ,  ִ  ̵
	this->m_nGameContinueTimeInSecondOfToday = this->GetCurGameContinueTimeInSecondOfToday();
	// Ʈ  ÷ ð ִ  
	this->m_nGameContinueTimeInSecondOfToday4Viet = this->m_nGameContinueTimeInSecondOfToday;

#ifdef S_BONUS_KILL_SYSTEM_RENEWAL
	if (m_nKillCount > 0)
	{
		ms_pFieldIOCP->CacheCharacterKillCount(m_character.CharacterUniqueNumber, m_nKillCount);
	}
#endif // S_BONUS_KILL_SYSTEM_RENEWAL


	// member  ʱȭ
	ResetAllVariables(RVT_GAME_END);
}

// ĳͰ װ GameEndRoutine() Ȥ DEAD_GAMESTART ϱ () ó ׵
void CFieldIOCPSocket::CharacterDeadRoutine(BYTE damageType
											, CFieldMonster *i_pAttackMonster/*=NULL*/
											, CFieldIOCPSocket *i_pAttackUser/*=NULL*/)
{	
	m_TimerManager.m_TEIDGradualHPUP			= NULL;		// Timer ϱ

	m_TimerManager.m_nRemainedTimeOfGradualHPUP = 0;
	m_TimerManager.m_nRemainedTimeOfGradualDPUP = 0;
	m_TimerManager.m_nRemainedTimeOfGradualSPUP = 0;
	m_TimerManager.m_nRemainedTimeOfGradualEPUP = 0;
	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	this->m_SkillManager.ResetDebuffSkill();
	this->m_SkillManager.ResetDotSkill();
	if(g_pFieldGlobal->IsArenaServer()
		&& INFINITY_STATE_PLAYING <= this->m_InfinityPlayingInfo.InfinityState) {
		//  α׿
		m_InfinityPlayingInfo.DeathCount++;
 		if(0 != m_InfinityPlayingInfo.TimePenaltyValue || 0 != m_InfinityPlayingInfo.HPPenaltyValue ) {		// 2011-06-14 by hskim, ǴƼ 3 - гƼ  ߰ (HP  ð   )
 			// 2010-03-31 by dhjin, ǴƼ() - ذ   // 2009-09-09 ~ 2010-01-13 by dhjin, ǴƼ -   ̸   ߰, // 2009-09-09 ~ 2010 by dhjin, ǴƼ -   гƼ ߰
// 			this->ms_pFieldIOCP->m_InfinityManager.CalcLimitTimeByUserDeathW(this->m_character.CharacterName, m_InfinityPlayingInfo.ModeTypeNum, m_InfinityPlayingInfo.InfinityCreateUID);
			this->ms_pFieldIOCP->m_InfinityManager.ProcessingInfinityPenalty(this->m_character.CharacterName, m_InfinityPlayingInfo.ModeTypeNum, m_InfinityPlayingInfo.InfinityCreateUID);
 		}
	}
	///////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ü ϸ Ѵ.
	if(FALSE != m_mtvectFieldDummy.empty()) {
		mt_auto_lock mtA(&m_mtvectFieldDummy);
		m_bDummyCheck			= FALSE;
		INIT_MSG_WITH_BUFFER(MSG_FC_BATTLE_DELETE_DUMMY_OK, T_FC_BATTLE_DELETE_DUMMY_OK, pDummySMsg, DummySendBuf);
		pDummySMsg->AttackIndex		= GetCharacter()->ClientIndex;
		mtvectFieldDummy::iterator itr = m_mtvectFieldDummy.begin();
		for(; itr != m_mtvectFieldDummy.end(); itr++)
		{
			FIELD_DUMMY *pFDummy	= *itr;
			pDummySMsg->ItemFieldIndex	= pFDummy->ItemFieldIndex;
			
			// 2006-12-06 by cmkwon,   ĳͿ 
			this->SendInRangeMessageAroundMe(DummySendBuf, MSG_SIZE(MSG_FC_BATTLE_DELETE_DUMMY_OK), TRUE);
		}
		this->DeleteAllFieldDummy();			// 2006-12-06 by cmkwon,  ü Ѵ.
		mtA.auto_unlock_cancel();
	}

	m_character.CurrentHP						= 0.0f;		// HP ʱȭ
	m_character.CurrentDP						= 0.0f;		// DP ʱȭ
// 2006-04-10 by cmkwon, ProcessSPIPenaltyOnDead() Լ ʱȭ Ѵ.
// 	m_character.DownExperience					= 0.0f;		//   ٿ ġ ʱȭ
// 	m_character.DownSPIOnDeath					= 0;		// 2006-04-10 by cmkwon, ĳͰ   SPI

	SetBodyConditionBit(m_character.BodyCondition, BODYCON_DEAD_MASK);
	QPARAM_CHARACTER_CHANGE_BODYCONDITION *pQBodyCondition = new QPARAM_CHARACTER_CHANGE_BODYCONDITION;
	pQBodyCondition->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
	pQBodyCondition->BodyCondition			= m_character.BodyCondition;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangeBodyCondition, this, m_character.AccountUniqueNumber, pQBodyCondition);
	SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP);

	// ڽŰ  ĳ͵鿡 ڽ ĵǾٴ  
	ms_pFieldIOCP->SendInRangeChangeBodyCondition(m_character.ClientIndex, m_pCurrentFieldMapChannel, m_pCurrentFieldMapChannel->GetUserVisibleDiameterW());

	// NPCԵ 
	m_pCurrentFieldMapChannel->SendBodyCondition2NPCServer(m_character.ClientIndex, m_character.BodyCondition);

	// ġ ٿ ó, PK(Ƽ )   ó 
	if (GCheckLimitLevel(CHECK_TYPE_PENALTY_ON_DEAD, m_character.Level)
		&& damageType != DAMAGE_BY_PK)
	{// 2006-02-28 by cmkwon,  Ϳ    

		if(DAMAGE_BY_MONSTER != damageType
			|| (DAMAGE_BY_MONSTER == damageType && i_pAttackMonster && FALSE == IS_INFLWAR_MONSTER(i_pAttackMonster->MonsterInfoPtr->Belligerence)))
		{
			ProcessSPIPenaltyOnDead();
		}
	}
// 2006-02-28 by cmkwon,   
// 	if (GCheckLimitLevel(CHECK_TYPE_PENALTY_ON_DEAD, m_character.Level)
// 		&& damageType != DAMAGE_BY_PK)
// 	{
// 
// 		if(NULL == m_pCurrentFieldMapChannel->m_pRefCityWar1
// 			|| m_pCurrentFieldMapChannel->m_pRefCityWar1->MapIndex != m_pCurrentFieldMapChannel->m_MapChannelIndex.MapIndex
// 			|| CITYWAR_STATE_STARTED != m_pCurrentFieldMapChannel->m_pRefCityWar1->GetCityWarState())
// 		{//  ϶  ʿ ġ ٿ 
// 
// 			ProcessSPIPenaltyOnDead();
// 
// // 2005-06-29 by cmkwon, SPI ٿ ó
// //			///////////////////////////////////////////////////////////////////////////////
// //			//  ġ ٿ ó
// //			Experience_t expDecrement	= CAtumSJ::GetLevelExperience(m_character.Level)->ExperienceLossOnDeath;
// //			expDecrement				= max(0, expDecrement - expDecrement*GetPlusRateExpRepair());
// //
// //			Experience_t expOfLevel		= CAtumSJ::GetInitialExperienceOfLevel(m_character.Level);
// //			if (m_character.Experience - expDecrement <= expOfLevel)
// //			{
// //				CAtumLogSender::SendLogMessageEXP(this, expOfLevel - m_character.Experience, expOfLevel);	// Send Log
// //				this->m_character.DownExperience	= m_character.Experience - expOfLevel;
// //				m_character.Experience				= expOfLevel;
// //			}
// //			else
// //			{
// //				m_character.Experience				-= expDecrement;
// //				CAtumLogSender::SendLogMessageEXP(this, -expDecrement, m_character.Experience);				// Send Log
// //				this->m_character.DownExperience	= expDecrement;
// //			}
// //
// //			QPARAM_CHARACTER_CHANGE_EXP *pQChangeEXP	= new QPARAM_CHARACTER_CHANGE_EXP;
// //			pQChangeEXP->CharacterUniqueNumber			= m_character.CharacterUniqueNumber;
// //			pQChangeEXP->Experience						= m_character.Experience;
// //			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangeExp, this, m_character.AccountUniqueNumber, pQChangeEXP);
// //			SendCharacterInfo(T_FC_CHARACTER_CHANGE_EXP);
// 		}
//	}

	///////////////////////////////////////////////////////////////////////////////
	// 2005-12-27 by cmkwon,   ó
	if( i_pAttackUser
		&& i_pAttackUser->IsValidCharacter(FALSE)
		&& this->GetCharacter()->InfluenceType != i_pAttackUser->GetCharacter()->InfluenceType
		&& COMPARE_INFLUENCE(this->GetCharacter()->InfluenceType, INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI)
		&& COMPARE_INFLUENCE(i_pAttackUser->GetCharacter()->InfluenceType, INFLUENCE_TYPE_VCN|INFLUENCE_TYPE_ANI) )
	{
		//////////////////////////////////////////////////////////////////////////
		// 2008-03-11 by dhjin, Ʒ  - Ʒ  ġ, , ųũ  ó  ʴ´.
		if(FALSE == g_pFieldGlobal->IsArenaServer())
		{
			if(ms_pFieldIOCP->GetP2PPKFamePoint(i_pAttackUser->GetCharacter()->CharacterName, GetCharacter()->CharacterName))
			{
				i_pAttackUser->InfluenceWarBonus2Killer(this);

// 2013-05-09 by hskim,  Ʈ 
#ifdef S_UPGRADE_INFLUENCE_POINT_HSKIM
#else
				///////////////////////////////////////////////////////////////////////////////
				// 2006-04-14 by cmkwon,  ⿩ 
				ms_pFieldIOCP->m_InflWarManager.AddContributionPoint(i_pAttackUser->GetCharacter()->InfluenceType, 1);
#endif
			}
		}

		//////////////////////////////////////////////////////////////////////////
		// 2008-02-21 by dhjin, Ʒ  - Ʒ   ̸ '\xxx'  ֱ,   
		if(g_pFieldGlobal->IsArenaServer())
		{
			CHAR SendArenaCharacterName[SIZE_MAX_CHARACTER_NAME];
			MEMSET_ZERO(SendArenaCharacterName, SIZE_MAX_CHARACTER_NAME);
			CHAR ArenaCharacterName[SIZE_MAX_CHARACTER_NAME];
			STRNCPY_MEMSET(ArenaCharacterName, i_pAttackUser->GetCharacter()->CharacterName, SIZE_MAX_CHARACTER_NAME);
			ms_pFieldIOCP->ConvertArenaRenderUserName(ArenaCharacterName, SendArenaCharacterName);
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_061107_0000, SendArenaCharacterName);
			//////////////////////////////////////////////////////////////////////////
			// 2008-04-28 by dhjin, Ʒ  -    Ʈ ߰, Ʒ ʿ
			MEMSET_ZERO(SendArenaCharacterName, SIZE_MAX_CHARACTER_NAME);
			STRNCPY_MEMSET(ArenaCharacterName, this->GetCharacter()->CharacterName, SIZE_MAX_CHARACTER_NAME);
			ms_pFieldIOCP->ConvertArenaRenderUserName(ArenaCharacterName, SendArenaCharacterName);
			i_pAttackUser->SendString128(STRING_128_USER_NOTICE, STRMSG_080428_0001, SendArenaCharacterName);		
		}	
		else
		{
			if (ms_pFieldIOCP->CountP2PPKFamePoint(i_pAttackUser->GetCharacter()->CharacterName, GetCharacter()->CharacterName) > 10)
			{
				i_pAttackUser->SendString128(STRING_128_USER_NOTICE, STRMSG_061107_0001);
			}
			this->SendString128(STRING_128_USER_NOTICE, STRMSG_061107_0000, i_pAttackUser->GetCharacter()->CharacterName);
		}
//		// 2006-11-07 by cmkwon, ߰
//		this->SendString128(STRING_128_USER_NOTICE, STRMSG_061107_0000, i_pAttackUser->GetCharacter()->CharacterName);

		// 2006-03-06 by cmkwon, ÿ  ¿    α
		CAtumLogSender::SendLogMessagePvELOSS(this, i_pAttackUser->GetCharacter()->CharacterUniqueNumber);

		// 2006-03-06 by cmkwon,  뼼   α
		CAtumLogSender::SendLogMessagePvEWIN(i_pAttackUser, this->GetCharacter()->CharacterUniqueNumber);
	}

	// ϴ   ó
	if (IS_VALID_CLIENT_INDEX(m_peerP2PPKClientIndex))
	{
		CFieldIOCPSocket *pPeerPKSocket = ms_pFieldIOCP->GetFieldIOCPSocket(m_peerP2PPKClientIndex);
		OnP2PPKEnd(pPeerPKSocket, this);
		if(DAMAGE_BY_PK == damageType)
		{// ĳ ؼ ׾  Ʈ Ȱ
			m_bDeadReasonByPK				= TRUE;
		}
	}

	// Ƽ  ó
	if (this->IsPartyBattleState())
	{
		OnPartyBattleMemberDead();
	}

	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰ - ذ  
//	// DEAD Log 
	// 2012-08-30 by jhseol, Ǯα 
#ifdef S_FULL_LOG_JHSEOL
//	CAtumLogSender::SendLogMessageDEAD(this, damageType);	// 2012-08-30 by jhseol, Ǯα  -  Լ  ּ  .
#endif	//#ifdef S_FULL_LOG_JHSEOL
	// end 2012-08-30 by jhseol, Ǯα 
	if(NULL != i_pAttackUser) {
		CAtumLogSender::SendLogMessageDEAD(this, damageType, i_pAttackUser->GetCurrentAttackItemNum());
	}
	else if(NULL != i_pAttackMonster) {
		CAtumLogSender::SendLogMessageDEAD(this, damageType, i_pAttackMonster->GetCurrentAttackItemNum());
	}
	else {
		CAtumLogSender::SendLogMessageDEAD(this, damageType, 0);
	}
	
	///////////////////////////////////////////////////////////////////////////
	// ŷ resetϱ
	if (IS_VALID_UNIQUE_NUMBER(m_peerTraderCharacterUniqueNumber))
	{
		CFieldIOCPSocket *pPeerTraderSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
		if (pPeerTraderSocket
			&& pPeerTraderSocket->IsValidCharacter(FALSE))
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_TRADE_CANCEL_TRADE_OK, T_FC_TRADE_CANCEL_TRADE_OK, msgCancelTradeOK, msgCancelTradeOKBuf);
			msgCancelTradeOK->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
			pPeerTraderSocket->SendAddData(msgCancelTradeOKBuf, MSG_SIZE(MSG_FC_TRADE_CANCEL_TRADE_OK));

			pPeerTraderSocket->m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
			pPeerTraderSocket->m_bOKTradeChecked = FALSE;
			pPeerTraderSocket->m_mapTradeItem.clearLock();
		}
		m_peerTraderCharacterUniqueNumber = INVALID_UNIQUE_NUMBER;
		m_bOKTradeChecked = FALSE;
		m_mapTradeItem.clearLock();
	}

	// ѷ  
	ClearAllCharacterMines();

	//  
	if (m_ItemWingOut.Kind == ITEMKIND_SHIELD && COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_SHIELD_MASK))
	{
		StopItemKindShield(((ITEM_GENERAL*)m_ItemWingOut.ItemNum)->ItemInfo);
	}

	//  
	if (m_ItemWingOut.Kind == ITEMKIND_DECOY && COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_DECOY_MASK))
	{
		StopItemKindDecoy(((ITEM_GENERAL*)m_ItemWingOut.ItemNum)->ItemInfo);
	}

	// ¡ ų 
	m_SkillManager.ClearChargingSkill();

	// 2007-07-11 by cmkwon, BigBoom PrepareUse   - ĳͰ  FALSE , 
	m_SkillManager.SetPrepareUseBigBoom(FALSE);

	//
	INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_DEAD_NOTIFY, T_FC_CHARACTER_DEAD_NOTIFY, pFCDead, SendBuf);
	pFCDead->ClientIndex		= m_character.ClientIndex;
	pFCDead->byDamageKind		= damageType;
	pFCDead->bDeadByP2PPK		= this->m_bDeadReasonByPK;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_DEAD_NOTIFY));

	// IM Server DEAD ޼ Ѵ.
	INIT_MSG(MSG_FI_CONNECT_NOTIFY_DEAD, T_FI_CONNECT_NOTIFY_DEAD, pMsgDead, SendBuf);
	pMsgDead->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
	pMsgDead->AttackerGuildUID		= this->m_uidAttackerGuildUID;
	ms_pFieldIOCP->m_pIMWinSocket->Write(SendBuf, MSG_SIZE(MSG_FI_CONNECT_NOTIFY_DEAD));

	// 2005-08-30 by cmkwon,   Ʈ  īƮ ó
	if(i_pAttackMonster)
	{
		this->CheckSuccessAllQuestByAttackMonsterNum(i_pAttackMonster->MonsterInfoPtr->MonsterUnitKind);
	}

	//////////////////////////////////////////////////////////////////////////
	// 2007-04-24 by dhjin, ARENA_STATE_WARING ̸ Ʒ ̹Ƿ Ʒ ó  ó
	if(IS_MAP_INFLUENCE_ARENA(m_pCurrentFieldMapChannel->GetMapInfluenceTypeW())
		&& ARENA_STATE_FIGHTING_WARING == this->m_ArenaInfo.State)
	{
		if(i_pAttackUser
			&& i_pAttackUser->IsValidCharacter(FALSE))
		{		
			i_pAttackUser->m_ArenaInfo.ShootingDown++;
			this->m_ArenaInfo.SufferingAttack++;
		}
		else
		{// 2007-06-01 by dhjin,   ʰ ׾  LostPoint
			this->m_ArenaInfo.LostPoint++;
		}
		ms_pFieldIOCP->m_ArenaManager.SendDeathMatchRoomInfo(this->m_ArenaInfo.TeamNum, this->m_ArenaInfo.DeathMatchRoomNum, this->m_character.InfluenceType);
	}

	m_mtvectActionInfoAggroList.clearLock();		// 2006-07-21 by cmkwon, Aggro Ʈ ʱȭ

	///////////////////////////////////////////////////////////////////////////////
	// 2009-09-23 by cmkwon, ʵâ ĳ   - CFieldIOCPSocket::CharacterDeadRoutine(), ĳ  ʱȭ ó
	m_ItemManager.SetUsingFieldStore(FALSE);
	m_ItemManager.SetUsingStore(FALSE);				// 2013-04-12 by jhseol, ʵâ  þƮ  
}

BOOL CFieldIOCPSocket::CharacterDeadGameStartRoutine(BOOL i_bNotify
													 , int i_nRecoverHP/*=0*/
													 , int i_nRecoverDP/*=0*/
													 , int i_nRecoverSP/*=0*/
													 , int i_nRecoverEP/*=0*/)
{
	//  ä
	if(i_nRecoverHP){		m_character.CurrentHP	= i_nRecoverHP;}
	if(i_nRecoverDP){		m_character.CurrentDP	= i_nRecoverDP;}
	if(i_nRecoverSP){		m_character.CurrentSP	= i_nRecoverSP;}
	if(i_nRecoverEP){		m_character.CurrentEP	= i_nRecoverEP;}	// 2007-05-11 by dhjin, ᵵ ä   ֵ ߰
	else{	m_character.CurrentEP	= max(1, m_character.CurrentEP);}	// 2005-12-14 by cmkwon, Ḧ 1 äش
// 2005-11-18 by cmkwon, SP, , Ѿ˴ ޻ ̿ؾѴ.
//	m_character.CurrentSP	= m_character.SP;
//	///////////////////////////////////////////////////////////////////////////////
//	// 2005-08-02 by cmkwon
//	// 1, 2 Ѿ  ä ش.	
//	ITEM_GENERAL *pPriItem = (ITEM_GENERAL*)m_ItemProwOut.ItemNum;
//	ITEM_GENERAL *pSecItem = (ITEM_GENERAL*)m_ItemWingOut.ItemNum;
//	if (m_ItemProwOut.ItemNum != 0){			RechargeBullet(pPriItem, FALSE);}
//	if (m_ItemWingOut.ItemNum != 0){			RechargeBullet(pSecItem, FALSE);}


// 2005-06-29 by cmkwon,  ä ִ  
//	if(i_nRecoverHP <= 0)
//	{
//		if (m_character.Level < 10)
//		{
//			m_character.CurrentHP = m_character.HP;
//		}
//		else
//		{
//			m_character.CurrentHP = 0.3f * (float)m_character.HP;
//		}
//	}
//	else
//	{
//		m_character.CurrentHP = min(i_nRecoverHP, m_character.HP);
//		m_character.CurrentDP = min(i_nRecoverDP, m_character.DP);
//		m_character.CurrentSP = min(i_nRecoverSP, m_character.SP);
//	}

	// Body Condition ٲ
	m_character.BodyCondition = BODYCON_FLY_MASK;
	ClearBodyConditionBit(m_character.BodyCondition, BODYCON_BOOSTER_EX_STATE_CLEAR_MASK|BODYCON_LANDED_MASK);
	if(FALSE == i_bNotify)
	{// ĳͰ  ¿  ϴ Ȳ
		return TRUE;
	}

	SendCharacterInfo(T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP);
	
	INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_CHANGE_BODYCONDITION, T_FC_CHARACTER_CHANGE_BODYCONDITION, pBodyCon, SendBuf);
	pBodyCon->ClientIndex		= m_character.ClientIndex;
	pBodyCon->BodyCondition		= m_character.BodyCondition;
	SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_CHANGE_BODYCONDITION));

	INIT_MSG(MSG_FI_CONNECT_NOTIFY_DEAD_GAMESTART, T_FI_CONNECT_NOTIFY_DEAD_GAMESTART, pSIMServer, SendBuf);
	pSIMServer->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
	ms_pFieldIOCP->m_pIMWinSocket->Write(SendBuf, MSG_SIZE(MSG_FI_CONNECT_NOTIFY_DEAD_GAMESTART));

	// NPC Ե 
	INIT_MSG(MSG_FN_CHARACTER_CHANGE_BODYCONDITION, T_FN_CHARACTER_CHANGE_BODYCONDITION, pSBodyCon, SendBuf);
	pSBodyCon->ChannelIndex		= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
	pSBodyCon->ClientIndex		= m_character.ClientIndex;
	pSBodyCon->BodyCondition	= m_character.BodyCondition;
	m_pCurrentFieldMapChannel->Send2NPCServerW(SendBuf, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_BODYCONDITION));

	///////////////////////////////////////////////////////////////////////////
	// NPC Server GameEndOK ޼ Ѵ.
	INIT_MSG(MSG_FN_CLIENT_GAMEEND_OK, T_FN_CLIENT_GAMEEND_OK, pSendClientGameEndOK, SendBuf);
	pSendClientGameEndOK->ChannelIndex	= m_pCurrentFieldMapChannel->m_MapChannelIndex.ChannelIndex;
	pSendClientGameEndOK->ClientIndex	= m_character.ClientIndex;
	m_pCurrentFieldMapChannel->Send2NPCServerW(SendBuf, MSG_SIZE(MSG_FN_CLIENT_GAMEEND_OK));
	return TRUE;
}

LONGLONG CFieldIOCPSocket::GetTotalPlayTimeInSeconds()
{
	return m_character.TotalPlayTime + GetCurrentPlayTimeInSeconds();
}

LONGLONG CFieldIOCPSocket::GetCurrentPlayTimeInSeconds()
{
	if(0 == m_nGameStartTimeInSeconds){			return 0;}			// 2006-05-07 by cmkwon

	return ms_pFieldIOCP->GetCurrentServerTime() - m_nGameStartTimeInSeconds;
}

//////////////////////////////////////////////////////////////////////////
// 2007-06-07 by dhjin, PC  ÷ ð .
LONGLONG CFieldIOCPSocket::GetPCBangTotalPlayTimeInSeconds()
{
	if(FALSE == m_bIsPCBangClient)
	{
		return m_character.PCBangTotalPlayTime;
	}

	return m_character.PCBangTotalPlayTime + GetCurrentPlayTimeInSeconds();
}

BOOL CFieldIOCPSocket::CompareCharacterName(char *i_szCharacterName)
{
	if(0 == strnicmp(i_szCharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME))
	{
		return TRUE;
	}

	return FALSE;
}

CFieldMapProject *CFieldIOCPSocket::GetDefaultCityMapProject(void)
{
	if(NULL == m_pCurrentFieldMapChannel)
	{
		return NULL;
	}

	///////////////////////////////////////////////////////////////////////////////
	//   ⺻ ø 
	CFieldMapProject *pFMPro = m_pCurrentFieldMapChannel->GetDeadDefaultMapProjectW();

	///////////////////////////////////////////////////////////////////////////////
	//  ܿ ɵø 
	if(IS_VALID_UNIQUE_NUMBER(m_character.GuildUniqueNumber))
	{
		CCityWar *pCityWar = ms_pFieldIOCP->m_cityWarManager.GetCityWarPtrByOccupyGuildUID(m_character.GuildUniqueNumber);
		if(pCityWar)
		{
			pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pCityWar->CityMapIndex);
		}
	}

	return pFMPro;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CFieldMapProject *CFieldIOCPSocket::GetCityFieldMapProjectPtr(void)
/// \brief		
///				// 2009-10-12 by cmkwon, ī    - ߰(MapIndex_t i_nStartCityMapIdx)
/// \author		cmkwon
/// \date		2005-07-26 ~ 2005-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
CFieldMapProject *CFieldIOCPSocket::GetCityFieldMapProjectPtr(BYTE i_byInfluence/*=INFLUENCE_TYPE_UNKNOWN*/, MapIndex_t i_nStartCityMapIdx/*=VCN_CITY_MAP_INDEX*/)
{
	if(INFLUENCE_TYPE_UNKNOWN == i_byInfluence)
	{
		i_byInfluence = m_character.InfluenceType;
		i_nStartCityMapIdx	= m_character.GetStartCityMapIndex();	// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::GetCityFieldMapProjectPtr#
	}
	
	// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::GetCityFieldMapProjectPtr#
	return ms_pFieldIOCP->GetCityFieldMapProjectPtrByInfluenceW(i_byInfluence, i_nStartCityMapIdx);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CFieldMapChannel *CFieldIOCPSocket::GetCityFieldMapChannelPtr(BYTE i_byInfluence/*=INFLUENCE_TYPE_UNKNOWN*/)
/// \brief		
///				// 2007-02-27 by cmkwon, ߰(BYTE i_byInfluence=INFLUENCE_TYPE_UNKNOWN)
///				// 2009-10-12 by cmkwon, ī    - ߰(MapIndex_t i_nStartCityMapIdx)
/// \author		cmkwon
/// \date		2005-07-26 ~ 2005-07-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
CFieldMapChannel *CFieldIOCPSocket::GetCityFieldMapChannelPtr(BYTE i_byInfluence/*=INFLUENCE_TYPE_UNKNOWN*/, MapIndex_t i_nStartCityMapIdx/*=VCN_CITY_MAP_INDEX*/)
{
	// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::GetCityFieldMapChannelPtr#
	CFieldMapProject *pFMPro = this->GetCityFieldMapProjectPtr(i_byInfluence, i_nStartCityMapIdx);
	if(NULL == pFMPro)
	{
		return NULL;
	}

	return pFMPro->GetFirstFieldMapChannel(FALSE);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::GetGardenFieldMapProjectPtr# ߰
/// \author		cmkwon
/// \date		2009-10-13 ~ 2009-10-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
CFieldMapProject *CFieldIOCPSocket::GetGardenFieldMapProjectPtr(BYTE i_byInfluence/*=INFLUENCE_TYPE_UNKNOWN*/, MapIndex_t i_nStartCityMapIdx/*=VCN_CITY_MAP_INDEX*/)
{
	if(INFLUENCE_TYPE_UNKNOWN == i_byInfluence)
	{
		i_byInfluence		= m_character.InfluenceType;
		i_nStartCityMapIdx	= m_character.GetStartCityMapIndex();	// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::GetCityFieldMapProjectPtr#
	}

	BOOL bMotherShipWar = ms_pFieldIOCP->m_InflWarManager.CheckBossMonsterSummoningByAttackInfl(INFLUENCE_TYPE_ANI);		// 2012-07-02 by hskim,   -      Ұ

	MapIndex_t nGardenMapIdx = CAtumSJ::GetGargenMapIndexByInfluence(i_byInfluence, i_nStartCityMapIdx, bMotherShipWar);		// 2012-07-02 by hskim,   -      Ұ

	return ms_pFieldIOCP->GetFieldMapProjectByMapIndex(nGardenMapIdx);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		ĳͰ ׾   SPI Ѵ.
/// \author		cmkwon
/// \date		2005-06-29 ~ 2005-06-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
INT CFieldIOCPSocket::GetDownSPICountOnDead(void)
{
	return CAtumSJ::GetSPIPenaltyOnDead(m_character.Level);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::ProcessSPIPenaltyOnDead(BYTE i_nItemUpdateType=IUT_PENALTY_ON_DEAD)
/// \brief		
/// \author		cmkwon
/// \date		2005-08-19 ~ 2005-08-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::ProcessSPIPenaltyOnDead(BYTE i_nItemUpdateType/*=IUT_PENALTY_ON_DEAD*/)
{
	m_character.DownExperience			= 0.0f;		//   ٿ ġ ʱȭ
	m_character.DownSPIOnDeath			= 0;		// 2006-04-10 by cmkwon, ĳͰ   SPI

	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
	INT nDownSPI = GetDownSPICountOnDead();

	///////////////////////////////////////////////////////////////////////////////	
	// 2009-06-30 by cmkwon, ĳ  гƼ    - ȸ  ݾ üũؾ Ѵ.
	nDownSPI -= (nDownSPI * GetPlusRateExpRepair());

	ITEM_GENERAL *pMoney = m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER);
	if (pMoney == NULL 
		|| pMoney->CurrentCount < nDownSPI)
	{
		if(NULL == pMoney)
		{// 2006-10-16 by cmkwon, SPI    ߰
			m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
		}

		Experience_t expDecrement	= CAtumSJ::GetLevelExperience(m_character.Level)->ExperienceLossOnDeath;
		expDecrement				= max(0, expDecrement - expDecrement*GetPlusRateExpRepair());

		Experience_t expOfLevel		= CAtumSJ::GetInitialExperienceOfLevel(m_character.Level);
		if (m_character.Experience - expDecrement <= expOfLevel)
		{
			CAtumLogSender::SendLogMessageEXP(this, expOfLevel - m_character.Experience, expOfLevel);	// Send Log
			this->m_character.DownExperience	= m_character.Experience - expOfLevel;
			m_character.Experience				= expOfLevel;
		}
		else
		{
			m_character.Experience				-= expDecrement;
			CAtumLogSender::SendLogMessageEXP(this, -expDecrement, m_character.Experience);				// Send Log
			this->m_character.DownExperience	= expDecrement;
		}

		QPARAM_CHARACTER_CHANGE_EXP *pQChangeEXP	= new QPARAM_CHARACTER_CHANGE_EXP;
		pQChangeEXP->CharacterUniqueNumber			= m_character.CharacterUniqueNumber;
		pQChangeEXP->Experience						= m_character.Experience;
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangeExp, this, m_character.AccountUniqueNumber, pQChangeEXP);
		SendCharacterInfo(T_FC_CHARACTER_CHANGE_EXP);

// 2006-02-28 by cmkwon,   ġ ٿ ó
// 		m_character.Propensity -= m_character.Level;			//  ġ ĳ Level ŭ Ѵ.
// 		
// 		QPARAM_CHARACTER_CHANGE_PKPOINT *pQChangePKPropensity = new QPARAM_CHARACTER_CHANGE_PKPOINT;
// 		pQChangePKPropensity->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
// 		pQChangePKPropensity->Propensity			= m_character.Propensity;
// 		pQChangePKPropensity->PKWinPoint			= m_character.PKWinPoint;
// 		pQChangePKPropensity->PKLossPoint			= m_character.PKLossPoint;
// 		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangePKPoint, this
// 			, m_character.AccountUniqueNumber, pQChangePKPropensity);
// 
// 		INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_CHANGE_PROPENSITY, T_FC_CHARACTER_CHANGE_PROPENSITY, pSPropensity, SendBuf);
// 		pSPropensity->ClientIndex		= m_character.ClientIndex;
// 		pSPropensity->byUpdateType		= i_nItemUpdateType;
// 		pSPropensity->Propensity		= m_character.Propensity;
// 		this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_CHANGE_PROPENSITY));
	}
	else
	{
		// 2009-06-30 by cmkwon, ĳ  гƼ    -  .
		//nDownSPI -= (nDownSPI * GetPlusRateExpRepair());	// 2006-10-19 by cmkwon, SPI  Ѵ

		if(0 >= nDownSPI)
		{
			m_character.DownSPIOnDeath		= 0;				// 2006-04-10 by cmkwon,   SPI 
		}
		else
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-27 by cmkwon, α  ߰
			CAtumLogSender::SendLogMessageITEMSPI(this, pMoney, i_nItemUpdateType, -nDownSPI, max(0, pMoney->CurrentCount-nDownSPI));

			m_character.DownSPIOnDeath		= nDownSPI;				// 2006-04-10 by cmkwon,   SPI 
			m_ItemManager.UpdateItemCountByPointer(pMoney, -nDownSPI, i_nItemUpdateType);
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsCityCurrentFieldMapChannel(void)
/// \brief		
/// \author		cmkwon
/// \date		2005-11-03 ~ 2005-11-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsCityCurrentFieldMapChannel(void)
{
	if(NULL == m_pCurrentFieldMapChannel){			return FALSE;}

	CFieldMapProject *pFMPro = this->GetCityFieldMapProjectPtr();

	return pFMPro == m_pCurrentFieldMapChannel->m_pFieldMapProject;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsValidCharacter(BOOL i_bLiveCheck/*=TRUE*/)
/// \brief		
///				// 2010-04-22 by cmkwon, Ʒ ÷ µ ȿ ĳͷ ó - 
/// \author		cmkwon
/// \date		2005-11-18 ~ 2005-11-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsValidCharacter(BOOL i_bLiveCheck/*=TRUE*/, BOOL i_bPermissionArenaState/*=FALSE*/)
{
	if(FALSE == this->IsUsing())
	{
		return FALSE;
	}

	if(ST_CLIENT_TYPE != m_PeerSocketType)
	{
		return FALSE;
	}

	if(CS_PLAYING != GetClientState())
	{
		// 2010-04-22 by cmkwon, Ʒ ÷ µ ȿ ĳͷ ó - 
		if(FALSE == i_bPermissionArenaState
			|| CS_ARENASERVER_PLAYING != GetClientState())
		{
			return FALSE;
		}
	}

	if(0 == m_character.AccountUniqueNumber
		|| 0 == m_character.CharacterUniqueNumber)
	{
		return FALSE;
	}

	if(i_bLiveCheck)
	{//  ִ üũ
		if(COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_DEAD_MASK))
		{//  
			return FALSE;
		}
	}

	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::IsEnableWarp(int i_nMapInfluenceTy, BOOL i_bConflictAraeMap, int i_nRequetCompletionQuestIndex/*=0*/)
/// \brief		// 2010-02-01 by cmkwon, ŷ ̼Ǹ̵    - 
/// \author		cmkwon
/// \date		2005-11-24 ~ 2005-11-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::IsEnableWarp(int i_nMapInfluenceTy, BOOL i_bConflictAraeMap, int i_nRequetCompletionQuestIndex/*=0*/, BOOL i_bCancelTrade/*=FALSE*/,  CFieldMapProject *i_pTargetFieldMapProject /*= NULL*/)		// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
{
	if(FALSE == this->IsValidCharacter())
	{
		return ERR_INVALID_CHARACTER;
	}

	if (COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK))
	{// ̹  
		return ERR_WARPING;
	}

	if(IS_VALID_UNIQUE_NUMBER(m_peerTraderCharacterUniqueNumber))
	{// 2006-03-23 by cmkwon, ŷ̴

		///////////////////////////////////////////////////////////////////////////////
		// 2010-02-01 by cmkwon, ŷ ̼Ǹ̵    - ŷ ó
		if(FALSE == i_bCancelTrade)
		{
			return ERR_CANNOT_WARP_BY_TRADING;
		}
		SendTradeCanceledAndReset(NULL, TRUE);
	}

	if(m_pCurrentBuildingNPC)
	{// 2006-03-23 by cmkwon,  ̴̿
		return ERR_CANNOT_WARP_BY_SHOPPING;
	}

	if(IS_MAP_INFLUENCE_CONFLICT_AREA(i_nMapInfluenceTy))
	{// 2006-02-09 by cmkwon,   ̸  Ұ
		return ERR_CANNOT_WARP_CONNFLICT_AREA;
	}

	//////////////////////////////////////////////////////////////////////////
	// 2009-01-12 by dhjin,   - ذ  . // 2007-05-22 by cmkwon, Ϲݼµø(ī̸)  
	if(i_bConflictAraeMap
		&& MAP_INFLUENCE_NEUTRALITY != i_nMapInfluenceTy // 2009-01-12 by dhjin,   - 缼    üũ
// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::IsEnableWarp#
//		&& FALSE == IS_SAME_CHARACTER_8_MAP_INFLUENCE(m_character.InfluenceType, i_nMapInfluenceTy)
		&& FALSE == CAtumSJ::IsSameCharacterInfluence8MapInfluence(m_character.InfluenceType, i_nMapInfluenceTy)	// 2009-10-12 by cmkwon, ī    - 
		)
	{
		return ERR_CANNOT_WARP_POSSESSED_CONNFLICT_AREA;
 	}

// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::IsEnableWarp#, Ʒ üũ
// 	// 2007-05-22 by cmkwon, Ϲݼµø(ī̸) 	
// 	if(IS_MAP_INFLUENCE_CITY(i_nMapInfluenceTy)
// 		&& FALSE == IS_SAME_CHARACTER_8_MAP_INFLUENCE(m_character.InfluenceType, i_nMapInfluenceTy))
// 	{// 2007-05-22 by cmkwon, ٸ ø  Ұ
// 		return ERR_CANNOT_WARP_TO_CITY;
// 	}	

	// 2007-05-22 by cmkwon, Ϲݼµø(ī̸) 
	if(i_bConflictAraeMap
		|| MAP_INFLUENCE_NEUTRALITY == i_nMapInfluenceTy
// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::IsEnableWarp#,
//		|| IS_SAME_CHARACTER_8_MAP_INFLUENCE(m_character.InfluenceType, i_nMapInfluenceTy))
		|| CAtumSJ::IsSameCharacterInfluence8MapInfluence(m_character.InfluenceType, i_nMapInfluenceTy))	// 2009-10-12 by cmkwon, ī    - 
	{// 2005-12-28 by cmkwon, ĳͿ   , // 2006-08-28 by cmkwon, , ߸ Ʈε üũѴ
		if(0 != i_nRequetCompletionQuestIndex
			&& FALSE == IsCheckQuestComplited(i_nRequetCompletionQuestIndex))
		{
			// 2008-04-15 by cmkwon, ȸ(JamboreeServer) ý  -  üũ ƮϷ üũ  
			if(FALSE == g_pFieldGlobal->GetIsJamboreeServer())
			{
				return  ERR_REQ_WARP_COMPLETIONQUEST_NOT_MATCHED;
			}
		}
	}

// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::IsEnableWarp#,
// 	// 2007-05-22 by cmkwon, Ϲݼµø(ī̸) 
// 	if(IS_NORMAL_INFLUENCE_TYPE(m_character.InfluenceType)
// 		&& IS_MAP_INFLUENCE_ANI(i_nMapInfluenceTy))
// 	{// 2007-05-22 by cmkwon, Ϲݼ ANI¸  Ұ
// 		return ERR_PROTOCOL_CANNOT_WARP;
// 	}
	///////////////////////////////////////////////////////////////////////////////
	// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::IsEnableWarp#,
	if(IS_NORMAL_INFLUENCE_TYPE(m_character.InfluenceType))
	{
		if(IS_MAP_INFLUENCE_CITY(i_nMapInfluenceTy))
		{
			MapIndex_t nStartCityMapIdx = m_character.GetStartCityMapIndex();

			if( (IS_ANI_CITY_MAP_INDEX(nStartCityMapIdx) && IS_MAP_INFLUENCE_VCN(i_nMapInfluenceTy))
				|| (FALSE == IS_ANI_CITY_MAP_INDEX(nStartCityMapIdx) && IS_MAP_INFLUENCE_ANI(i_nMapInfluenceTy)) )
			{
				return ERR_PROTOCOL_CANNOT_WARP;
			}
		}
		else if(IS_MAP_INFLUENCE_ANI(i_nMapInfluenceTy))
		{// 2009-10-13 by cmkwon, Ϲݼ ø ƴ ANI¸  Ұ
		 	return ERR_PROTOCOL_CANNOT_WARP;
		}
	}
	else if(IS_MAP_INFLUENCE_CITY(i_nMapInfluenceTy)
		&& FALSE == CAtumSJ::IsSameCharacterInfluence8MapInfluence(m_character.InfluenceType, i_nMapInfluenceTy))
	{// 2007-05-22 by cmkwon, ٸ ø  Ұ
		return ERR_CANNOT_WARP_TO_CITY;
	}

	if (this->IsPartyBattleState())
	{// Ƽ üũ
		return ERR_IN_PARTY_BATTLE;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-07-27 by cmkwon,   üũ
	if(BAZAAR_STATE_NONE != m_bazaarManager.GetBazaarState())
	{
		return ERR_USING_BAZAAR;
	}

	// start 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
	if( NULL != i_pTargetFieldMapProject )
	{
		Err_t nErr = i_pTargetFieldMapProject->IsEnableWarpByMapProject(this);
		if( ERR_NO_ERROR != nErr  )
		{
			return nErr;
		}
	}
	// end 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý

	// 2012-07-02 by hskim,   -      Ұ
	if( NULL != i_pTargetFieldMapProject )
	{
		if( IS_STONES_RUIN_MAP_INDEX(i_pTargetFieldMapProject->m_nMapIndex) )
		{
			if( COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_ANI) )		//   ANI    Ұ 
			{
				if( TRUE == ms_pFieldIOCP->m_InflWarManager.CheckBossMonsterSummoningByAttackInfl(INFLUENCE_TYPE_ANI) )
				{
					return ERR_CANNOT_WARP_DURING_MSWAR;
				}
			}
		}
	}
	// end 2012-07-02 by hskim,   -      Ұ

	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::IsEnableWarpToCityMap(void)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-24 ~ 2006-07-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::IsEnableWarpToCityMap(void)
{
	CFieldMapProject *pFMapPro = this->GetCityFieldMapProjectPtr();
	if(NULL == pFMapPro)
	{
		return ERR_PROTOCOL_REQ_MAP_AREA_NOT_MATCHED;
	}
	
	return IsEnableWarp(pFMapPro->m_nMapInfluenceType, pFMapPro->IsConflictAreaMap(), pFMapPro->m_nQuestIndexForWarp);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::ClearCharacterForWarp(void)
/// \brief		// 2009-02-05 by cmkwon,     ó  - 
/// \author		cmkwon
/// \date		2009-02-05 ~ 2009-02-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::ClearCharacterForWarp(void)
{
	// 2009-02-05 by cmkwon,  ó - ڽ  ó
	if(this->IsPartyBattleState())
	{
		this->OnPartyBattleMemberDead();
	}

	// 2009-02-05 by cmkwon,  üũ
	if(m_pCurrentBuildingNPC)
	{
		m_pCurrentBuildingNPC		= NULL;		// 2009-02-05 by cmkwon,  ʱȭ

		INIT_MSG_WITH_BUFFER(MSG_FC_EVENT_LEAVE_BUILDING_OK, T_FC_EVENT_LEAVE_BUILDING_OK, pLeaveOK, SendBuf);
		pLeaveOK->PositionVector	= m_character.PositionVector;
		pLeaveOK->TargetVector		= m_character.TargetVector*1000.0f;
		SendAddData(SendBuf, MSG_SIZE(MSG_FC_EVENT_LEAVE_BUILDING_OK));
	}

	// 2009-02-05 by cmkwon, ŷ üũ - ŷ   ʱȭ ó
	if(IS_VALID_UNIQUE_NUMBER(m_peerTraderCharacterUniqueNumber))
	{
		CFieldIOCPSocket *pPeerTraderSocket = ms_pFieldIOCP->m_mapCharacterUniqueNumber.findLock(m_peerTraderCharacterUniqueNumber);
		if(this->m_bOKTradeChecked
			&& pPeerTraderSocket
			&& pPeerTraderSocket->IsValidCharacter()
			&& pPeerTraderSocket->m_bOKTradeChecked)
		{// 2009-02-05 by cmkwon, 1:1 ŷ Ѵ ŷ  ´  Ұ
			return ERR_CANNOT_WARP_BY_TRADING;
		}

		SendTradeCanceledAndReset(pPeerTraderSocket, TRUE);
	}

	// 2009-02-05 by cmkwon,   üũ
	if(COMPARE_BODYCON_BIT(this->GetCharacter()->BodyCondition, BODYCON_DEAD_MASK))
	{
		this->CharacterDeadGameStartRoutine(TRUE, this->GetCharacter()->HP, this->GetCharacter()->DP);
		this->m_bDeadReasonByPK		= FALSE;
	}

	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsCheckInfluenceTypeANDSocketType(BYTE i_bySenderInfluenceTyMask, int i_nOnlySocketTy/*=ST_ALL*/, BOOL i_bGameMasterOK/*=TRUE*/)
/// \brief		
///				// 2008-01-10 by cmkwon, IsCheckInfluenceTypeANDSocketType()   - IsCheckInfluenceTypeANDSocketType()  ߰
///				// 2009-10-12 by cmkwon, ī    - IsCheckInfluenceTypeANDSocketType, ߰(i_nStartCityMapIdx)
/// \author		cmkwon
/// \date		2005-12-22 ~ 2005-12-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsCheckInfluenceTypeANDSocketType(BYTE i_bySenderInfluenceTyMask, int i_nOnlySocketTy/*=ST_ALL*/, BOOL i_bGameMasterOK/*=TRUE*/, MapIndex_t i_nStartCityMapIdx/*=0*/)
{
	if(ST_ALL != i_nOnlySocketTy
		&& m_PeerSocketType != i_nOnlySocketTy)
	{
		return FALSE;
	}

	// 2008-01-10 by cmkwon, IsCheckInfluenceTypeANDSocketType()   - i_bGameMasterOK  ϶ RACE_GAMEMASTER  üũѴ.
	if(i_bGameMasterOK
		&& COMPARE_RACE(m_character.Race, RACE_GAMEMASTER))
	{
		return TRUE;
	}

	if(FALSE == COMPARE_INFLUENCE(m_character.InfluenceType, i_bySenderInfluenceTyMask))
	{
		return FALSE;
	}

	// 2009-10-12 by cmkwon, ī    - ڽ Ϲݼ  ۸ε ƾ  ̴. 0 ϶ 
	if(INFLUENCE_TYPE_ALL_MASK != i_bySenderInfluenceTyMask
		&& 0 != i_nStartCityMapIdx
		&& COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		if(i_nStartCityMapIdx != GetCharacter()->Material
			&& !(0 == GetCharacter()->Material && IS_VCN_CITY_MAP_INDEX(i_nStartCityMapIdx)))
		{
			return FALSE;
		}
	}

	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsCheckLevel(BYTE i_byMinLevel, BYTE i_byMaxLevel)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-21 ~ 2006-07-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsCheckLevel(BYTE i_byMinLevel, BYTE i_byMaxLevel)
{
	if(0 != i_byMinLevel
		&& GetCharacter()->Level < i_byMinLevel)
	{
		return FALSE;
	}

	if(0 != i_byMaxLevel
		&& GetCharacter()->Level > i_byMaxLevel)
	{
		return FALSE;
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::AddCharacterFame(int i_nAddCharacterFameValues/*=1*/, int i_nAddGuildFameValues/*=1*/)
/// \brief		// 2008-09-12 by cmkwon, "/" ɾ ߰ - θ, ܸ  ΰ 
/// \author		cmkwon
/// \date		2005-12-27 ~ 2005-12-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::AddCharacterFame(int i_nAddCharacterFameValues/*=1*/, int i_nAddGuildFameValues/*=1*/)
{

	if(0 < i_nAddCharacterFameValues)
	{// 2008-09-12 by cmkwon, ߰θġ 0 Ŭ 츸 ó

		// ڽ ġ ø.
		// 2008-09-12 by cmkwon, "/" ɾ ߰ - 
		//m_character.Propensity++;			// ĳ ġ ׻ 1 ø

		m_character.Propensity	+= i_nAddCharacterFameValues;		// 2008-09-12 by cmkwon, "/" ɾ ߰ - 

		//   Ŭ̾Ʈ Ѵ.
		CheckAndUpdateStatus();
		SendCharacterInfo(T_FC_CHARACTER_CHANGE_PKPOINT);
		
		// DB 
		QPARAM_CHARACTER_CHANGE_PKPOINT *pQChangePKPointLoser = new QPARAM_CHARACTER_CHANGE_PKPOINT;
		pQChangePKPointLoser->CharacterUniqueNumber		= m_character.CharacterUniqueNumber;
		pQChangePKPointLoser->Propensity				= m_character.Propensity;
		pQChangePKPointLoser->PKWinPoint				= m_character.PKWinPoint;
		pQChangePKPointLoser->PKLossPoint				= m_character.PKLossPoint;
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangePKPoint, this, m_character.AccountUniqueNumber, pQChangePKPointLoser);
	}

	if(FALSE == this->IsValidGuild()
		|| 0 >= i_nAddGuildFameValues)	// 2008-09-12 by cmkwon, ܸ߰ġ 0   
	{//   
		return;
	}

	//   
	INIT_MSG_WITH_BUFFER(MSG_FI_GUILD_ADD_GUILD_FAME, T_FI_GUILD_ADD_GUILD_FAME, pSGuildFame, SendBuf);
	pSGuildFame->guildUID	= m_character.GuildUniqueNumber;
// 2008-09-12 by cmkwon, "/" ɾ ߰ - 
//	pSGuildFame->addValues	= i_nAddFameValues;
	pSGuildFame->addValues	= i_nAddGuildFameValues;		// 2008-09-12 by cmkwon, "/" ɾ ߰ - 
	ms_pFieldIOCP->Send2IMServer(SendBuf, MSG_SIZE(MSG_FI_GUILD_ADD_GUILD_FAME));
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsGoToInfluenceCity(BYTE i_byCharInfluenceTy, INT i_nMapInfluenceTy)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-28 ~ 2005-12-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsGoToInfluenceCity(BYTE i_byCharInfluenceTy, INT i_nMapInfluenceTy)
{
	if(IS_MAP_INFLUENCE_EVENT_AREA(i_nMapInfluenceTy))
	{// 2006-07-18 by cmkwon, ̺Ʈ ̸ ø ̵
		return TRUE;
	}

	if(COMPARE_INFLUENCE(i_byCharInfluenceTy, INFLUENCE_TYPE_NORMAL|INFLUENCE_TYPE_VCN))
	{
		return MAP_INFLUENCE_ANI_START == i_nMapInfluenceTy;
	}
	if(COMPARE_INFLUENCE(i_byCharInfluenceTy, INFLUENCE_TYPE_ANI))
	{
		return MAP_INFLUENCE_VCN_START == i_nMapInfluenceTy;
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsValidGuild(void)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-28 ~ 2005-12-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsValidGuild(void)
{
	return IS_VALID_UNIQUE_NUMBER(m_character.GuildUniqueNumber);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::StoreDB_QPARAM_CHARACTER_CHANGE_STAT(void)
/// \brief		
/// \author		cmkwon
/// \date		2006-04-04 ~ 2006-04-04
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::StoreDB_QPARAM_CHARACTER_CHANGE_STAT(void)
{
	QPARAM_CHARACTER_CHANGE_STAT	*pQChangeStat = new QPARAM_CHARACTER_CHANGE_STAT;
	pQChangeStat->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
	pQChangeStat->byAutoStatType		= m_character.AutoStatType;
	pQChangeStat->GearStat1				= m_character.GearStat;
	pQChangeStat->HP					= m_character.HP;
	pQChangeStat->DP					= m_character.DP;
	pQChangeStat->SP					= m_character.SP;
	pQChangeStat->EP					= m_character.EP;
	pQChangeStat->BonusStat				= m_character.BonusStat;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangeStat, this, m_character.AccountUniqueNumber, pQChangeStat);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::StoreExperienceDelayStore(void)
/// \brief		
/// \author		cmkwon
/// \date		2006-05-21 ~ 2006-05-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::StoreExperienceDelayStore(void)
{
	if(m_character.Experience != m_ExperienceDelayStore)
	{
		///////////////////////////////////////////////////////////////////////////////
		// 2006-05-21 by cmkwon
		QPARAM_CHARACTER_CHANGE_EXP *pQChangeEXP	= new QPARAM_CHARACTER_CHANGE_EXP;
		pQChangeEXP->CharacterUniqueNumber			= m_character.CharacterUniqueNumber;
		pQChangeEXP->Experience						= m_character.Experience;
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangeExp, this, m_character.AccountUniqueNumber, pQChangeEXP);

		///////////////////////////////////////////////////////////////////////////////
		// 2007-01-15 by cmkwon, ý α׿ 
		CAtumLogSender::SendLogMessageEXP(this, m_character.Experience - m_ExperienceDelayStore, m_character.Experience);	// Send Log

		m_ExperienceDelayStore						= m_character.Experience;
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::CharacterChangeModeRoutine(void)
/// \brief		
/// \author		cmkwon
/// \date		2005-07-25 ~ 2005-07-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::CharacterChangeModeRoutine(void)
{
	if(FALSE == m_character.CharacterMode)
	{//  ϶ - ĳ͸尡 ƴҶ
	
	}
	else
	{// ĳ͸ ϶ 

	}


}




void CFieldIOCPSocket::OnWarpDone(EnumWarpType warpType)
{
#ifdef _DEBUG
	SendString128(STRING_128_ADMIN_CMD, "ATTACKPROBABILITY01: %d @OnWarpDone", m_ParamFactor.pfp_ATTACKPROBABILITY_01);
#endif
	m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_HP);
	m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_DP);
	m_TimerManager.CheckRecoveryTimer(TE_TYPE_RECOVER_SP);

	CharacterSaveCriticalData();


	///////////////////////////////////////////////////////////////////////////////
	// 2006-10-16 by cmkwon, Ƽ  ó - ä ý  ⿡ ó
	if(m_bQuestRequestWarp)
	{
		CFieldMapChannel *pBeforeFMapChann	= ms_pFieldIOCP->GetFieldMapChannelByMapChannelIndex(m_beforeMapChannIdxQuestRequestWarp);	// 2006-10-16 by cmkwon
		CFieldMapProject *pMapProject		= GetCurrentFieldMapProject();	// 2006-10-16 by cmkwon
		CFieldParty *pFParty				= this->m_pFieldParty;			// 2006-07-04 by cmkwon

		if(pBeforeFMapChann && pMapProject && pFParty)
		{
			m_dwLastQuestRequestWarpTick		= timeGetTime();					// 2006-10-16 by cmkwon

			INIT_MSG_WITH_BUFFER(MSG_FC_QUEST_REQUEST_PARTY_WARP, T_FC_QUEST_REQUEST_PARTY_WARP, pPartyWarp, SendBuf);
			pPartyWarp->callerCharacterUID		= m_character.CharacterUniqueNumber;
			pPartyWarp->dwRemainTime			= TERM_QUEST_REQUEST_WARP_EFFECTIVE_TIME;	// 2006-10-16 by cmkwon, 20
			pPartyWarp->warpMapChannIndex		= m_character.MapChannelIndex;

			///////////////////////////////////////////////////////////////////////////////
			// 2006-10-16 by cmkwon
			CFieldIOCPSocket *ArrayPartyMember[SIZE_MAX_PARTY_MEMBER];
			MEMSET_ZERO(ArrayPartyMember, sizeof(ArrayPartyMember[0]) * SIZE_MAX_PARTY_MEMBER);

			//////////////////////////////////////////////////////////////////////////
			// 2008-12-16 by dhjin, ̼Ǹ - ̼Ǹʹ ٸ ʿ ־ 
			// 2007-06-26 by cmkwon, Ƽ ġ   -  ִ ĳ͸ ó
//			int nMemCount = pFParty->GetMembersInSameMap(ArrayPartyMember, pBeforeFMapChann, TRUE);
			int nMemCount = pFParty->QuestWarpGetMembers(ArrayPartyMember, pBeforeFMapChann);

			for(int i=0; i<nMemCount; i++)
			{
				if(ArrayPartyMember[i]
					&& ArrayPartyMember[i] != this
					&& ERR_NO_ERROR == ArrayPartyMember[i]->IsEnableWarp( pMapProject->GetMapInfluenceType(), pMapProject->IsConflictAreaMap(), pMapProject->m_nQuestIndexForWarp))
				{
					ArrayPartyMember[i]->SendAddData(SendBuf, MSG_SIZE(MSG_FC_QUEST_REQUEST_PARTY_WARP));
				}
			}
		}
	}// END - if(m_bQuestRequestWarp)
	m_bQuestRequestWarp			= FALSE;		// 2006-10-16 by cmkwon

	//////////////////////////////////////////////////////////////////////////
	// 2009-01-06 by dhjin,   ߰
	if(this->ms_pFieldIOCP->m_InflWarManager.CheckSummonBossAndStrategyPoint()
		|| this->ms_pFieldIOCP->m_OutPostManager.CheckALLOutPostWaring() )
	{
// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::OnWarpDone#, Ʒ  
//		if(IS_OTHER_INFLUENCE_MAP(this->m_character.InfluenceType, this->GetCurrentFieldMapChannel()->GetMapInfluenceTypeW())
		if(CAtumSJ::IsOtherInfluenceMap(m_character.InfluenceType, m_character.GetStartCityMapIndex(), GetCurrentFieldMapChannel()->GetMapInfluenceTypeW())		// 2009-10-12 by cmkwon, ī    - 
			&& (0 == this->GetCurrentFieldMapChannel()->GetMapChannelIndex().ChannelIndex ))
		{
			ms_pFieldIOCP->WarOtherInflStayTime(this, TRUE);
		}
		else
		{
			ms_pFieldIOCP->WarOtherInflStayTime(this, FALSE);
		}
	}

	// start 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
	this->GetCurrentFieldMapProject()->InsertEnterOneTimeLimited(m_character.CharacterUniqueNumber);
	// end 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý
}

void CFieldIOCPSocket::SetBodyConditionBit(BodyCond_t &VAR, BodyCond_t MASK)
{
	SET_BODYCON_BIT(VAR, MASK);
}

void CFieldIOCPSocket::ClearBodyConditionBit(BodyCond_t &VAR, BodyCond_t MASK)
{
	CLEAR_BODYCON_BIT(VAR, MASK);
}

/*
BOOL CFieldIOCPSocket::CompareBodyConditionBit(BodyCondtionMask_t &VAR, BodyCondtionMask_t MASK)
{
	return COMPARE_BODYCON_BIT(VAR, MASK);
}
*/

// 2009-08-26 by cmkwon, ׷ ҽ  ý  - Ʒ  Լ 
//void CFieldIOCPSocket::UpdateRenderInfo()
void CFieldIOCPSocket::InitRenderInfo(void)
{
// 2009-08-26 by cmkwon, ׷ ҽ  ý  - ShapeItemNum ʵ ߰
// 	m_UnitRenderInfo.RI_Prow		= ((m_ItemProw.ItemNum!=0)?((ITEM_BASE*)m_ItemProw.ItemNum)->ItemInfo->ItemNum:0);
// 	m_UnitRenderInfo.RI_ProwOut		= ((m_ItemProwOut.ItemNum!=0)?((ITEM_BASE*)m_ItemProwOut.ItemNum)->ItemInfo->ItemNum:0);
// 	m_UnitRenderInfo.RI_WingOut		= ((m_ItemWingOut.ItemNum!=0)?((ITEM_BASE*)m_ItemWingOut.ItemNum)->ItemInfo->ItemNum:0);
// 	m_UnitRenderInfo.RI_WingIn		= ((m_ItemWingIn.ItemNum!=0)?((ITEM_BASE*)m_ItemWingIn.ItemNum)->ItemInfo->ItemNum:0);		// 2006-07-25 by cmkwon
// 	if(0 == m_ItemCenter.ItemNum)
// 	{
// 		m_UnitRenderInfo.RI_Center	= 0;
// 	}
// 	else
// 	{
// 		m_UnitRenderInfo.RI_Center			= ((ITEM_BASE*)m_ItemCenter.ItemNum)->ItemInfo->ItemNum;
// 		m_UnitRenderInfo.RI_ArmorColorCode	= ((ITEM_GENERAL*)m_ItemCenter.ItemNum)->ColorCode;			// 2005-12-08 by cmkwon, Ƹ  Ʃ 
// 	}
// 	m_UnitRenderInfo.RI_Rear		= ((m_ItemRear.ItemNum!=0)?((ITEM_BASE*)m_ItemRear.ItemNum)->ItemInfo->ItemNum:0);
// 	m_UnitRenderInfo.RI_Attachment	= ((m_ItemAttachment.ItemNum!=0)?((ITEM_BASE*)m_ItemAttachment.ItemNum)->ItemInfo->ItemNum:0);
	///////////////////////////////////////////////////////////////////////////////
	// 2009-08-26 by cmkwon, ׷ ҽ  ý  - ShapeItemNum ʵ ߰, Ʒ  
	int nItemNum, nShapeItemNum, nEffectItemNum, nPetLevel = 0;		// 2012-12-05 by hskim, Ʈ Ⱓ  
	
	// 2010-06-15 by shcho&hslee ý -  .
	/*for(int i = POS_PROW; i <= POS_ACCESSORY_TIME_LIMIT; i++)*/
	for(int i = POS_PROW; i <= POS_PET; i++)
	{
		if(FALSE == this->UpdateItemRenderInfoByPOS(&nItemNum, &nShapeItemNum, &nEffectItemNum, i, &nPetLevel))		// 2012-12-05 by hskim, Ʈ Ⱓ  
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::InitRenderInfo# invalid attached Pos(%d) ItemNum(%d) ShapeItemNum(%d) EffectItemNum(%d) !! \r\n", i, nItemNum, nShapeItemNum, nEffectItemNum);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-08-26 by cmkwon, ׷ ҽ  ý  - 
/// \author		cmkwon
/// \date		2009-08-26 ~ 2009-08-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::UpdateItemRenderInfoByPOS(INT *o_pnItemNum, INT *o_pnShapeItemNum, INT *o_pnEffectItemNum, INT i_nPos, INT *o_pnPetLevel)		// 2012-12-05 by hskim, Ʈ Ⱓ  
{
	*o_pnItemNum		= 0;
	*o_pnShapeItemNum	= 0;
	*o_pnEffectItemNum	= 0;
	*o_pnPetLevel	= 0;		// 2012-12-05 by hskim, Ʈ Ⱓ  
	switch(i_nPos)
	{
	case POS_PROW:			// ̴ - 氡
		{
			if(0 != m_ItemProw.ItemNum)
			{
				*o_pnItemNum		= ((ITEM_GENERAL*)m_ItemProw.ItemNum)->ItemInfo->ItemNum;
				*o_pnShapeItemNum	= ((ITEM_GENERAL*)m_ItemProw.ItemNum)->GetShapeItemNum();
			}
		}
		break;
	case POS_PROWIN:		// CPU ǻ - 
		{
			if(0 != m_ItemProwIn.ItemNum)
			{
				*o_pnItemNum		= ((ITEM_GENERAL*)m_ItemProwIn.ItemNum)->ItemInfo->ItemNum;
			}
		}
		break;
	case POS_PROWOUT:		// 1  - 氡 + źƮ氡
		{
			if(0 != m_ItemProwOut.ItemNum)
			{
				*o_pnItemNum		= ((ITEM_GENERAL*)m_ItemProwOut.ItemNum)->ItemInfo->ItemNum;
				*o_pnShapeItemNum	= ((ITEM_GENERAL*)m_ItemProwOut.ItemNum)->GetShapeItemNum();
				*o_pnEffectItemNum	= ((ITEM_GENERAL*)m_ItemProwOut.ItemNum)->GetEffectItemNum();
			}
		}
		break;
	case POS_WINGIN:		// ũ - 氡
		{
			if(0 != m_ItemWingIn.ItemNum)
			{
				*o_pnItemNum			= ((ITEM_GENERAL*)m_ItemWingIn.ItemNum)->ItemInfo->ItemNum;
				*o_pnShapeItemNum		= ((ITEM_GENERAL*)m_ItemWingIn.ItemNum)->GetShapeItemNum();
			}
		}
		break;
	case POS_WINGOUT:		// 2  - 氡 + źƮ氡
		{
			if(0 != m_ItemWingOut.ItemNum)
			{
				*o_pnItemNum		= ((ITEM_GENERAL*)m_ItemWingOut.ItemNum)->ItemInfo->ItemNum;
				*o_pnShapeItemNum	= ((ITEM_GENERAL*)m_ItemWingOut.ItemNum)->GetShapeItemNum();
				*o_pnEffectItemNum	= ((ITEM_GENERAL*)m_ItemWingOut.ItemNum)->GetEffectItemNum();
			}
		}
		break;
	case POS_CENTER:		// Ƹ - 氡
		{
			if(0 != m_ItemCenter.ItemNum)
			{
				*o_pnItemNum		= ((ITEM_GENERAL*)m_ItemCenter.ItemNum)->ItemInfo->ItemNum;
#ifdef _REWORKED_COLORSHOP
				if (((ITEM_GENERAL*)m_ItemCenter.ItemNum)->ColorCode)
				{
					*o_pnShapeItemNum = ((ITEM_GENERAL*)m_ItemCenter.ItemNum)->ColorCode;
				}
				else
				{
#endif
					*o_pnShapeItemNum = ((ITEM_GENERAL*)m_ItemCenter.ItemNum)->GetShapeItemNum();
#ifdef _REWORKED_COLORSHOP
				}
#endif
			}
		}
		break;
	case POS_REAR:			//  - 
		{
			if(0 != m_ItemRear.ItemNum)
			{
				*o_pnItemNum		= ((ITEM_GENERAL*)m_ItemRear.ItemNum)->ItemInfo->ItemNum;
			}
		}
		break;

	// 2010-06-15 by shcho&hslee ý -  .
	//case POS_ATTACHMENT:	// ũ or Ǳ - 
	case POS_ACCESSORY_UNLIMITED :
		{
			if(0 != m_ItemAccessoryUnLimited.ItemNum/*m_ItemAttachment.ItemNum*/)
			{
				*o_pnItemNum		= ((ITEM_GENERAL*)m_ItemAccessoryUnLimited.ItemNum/*m_ItemAttachment.ItemNum*/)->ItemInfo->ItemNum;
			}
		}
		break;

	// 2010-06-15 by shcho&hslee ý -  .
	//case POS_PET:			// ð Ǽ縮 - 
	case POS_ACCESSORY_TIME_LIMIT :
		{
			if(0 != m_ItemAccessoryTimeLimit.ItemNum/*m_ItemPet.ItemNum*/)
			{
				*o_pnItemNum		= ((ITEM_GENERAL*)m_ItemAccessoryTimeLimit.ItemNum/*m_ItemPet.ItemNum*/)->ItemInfo->ItemNum;
			}
		}
		break;

	// 2010-06-15 by shcho&hslee ý
	case POS_PET :
		{
			if( 0 != m_ItemPet.ItemNum )
			{
				*o_pnItemNum = ((ITEM_GENERAL*)m_ItemPet.ItemNum)->ItemInfo->ItemNum;

				tPET_CURRENTINFO *psPetCurInfo = m_ItemManager.GetItemPetByUID ( ((ITEM_GENERAL *)m_ItemPet.ItemNum)->UniqueNumber );
				if ( psPetCurInfo && ms_pFieldIOCP->m_cPetDataManager.GetPetLevelData ( psPetCurInfo->PetIndex , psPetCurInfo->PetLevel ) )
				{	//  ShapeItemNum 2(City & Field)̱   ־ ȰѴ.
					*o_pnShapeItemNum =((ITEM_GENERAL*)m_ItemPet.ItemNum)->GetShapeItemNum();		// 2012-12-05 by hskim, Ʈ Ⱓ  
					*o_pnPetLevel = psPetCurInfo->PetLevel;		// 2012-12-05 by hskim, Ʈ Ⱓ  
				}
			}
		}
		break;

	default:
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::UpdateItemRenderInfoByPOS# invalid attached Pos(%d) !! \r\n", i_nPos);
			return FALSE;
		}
	}

	return m_UnitRenderInfo.SetRenderInfoWithPOS(i_nPos, *o_pnItemNum, *o_pnShapeItemNum, *o_pnEffectItemNum);
}

void CFieldIOCPSocket::UpdateItemRenderInfo(INT WinPos, BOOL bSendMsg)
{
// 2009-08-26 by cmkwon, ׷ ҽ  ý  - 
// 	INT ItemNum = 0;
// 	int	nArmorColorCode = 0;
// 	switch(WinPos) {
// 	case POS_PROW:
// 		ItemNum
// 			= (m_UnitRenderInfo.RI_Prow
// 			= ((m_ItemProw.ItemNum!=0)?((ITEM_BASE*)m_ItemProw.ItemNum)->ItemInfo->ItemNum:0));
// 		break;
// 	case POS_PROWOUT:
// 		ItemNum
// 			= (m_UnitRenderInfo.RI_ProwOut
// 			= ((m_ItemProwOut.ItemNum!=0)?((ITEM_BASE*)m_ItemProwOut.ItemNum)->ItemInfo->ItemNum:0));
// 		break;
// 	case POS_WINGOUT:
// 		ItemNum
// 			= (m_UnitRenderInfo.RI_WingOut
// 			= ((m_ItemWingOut.ItemNum!=0)?((ITEM_BASE*)m_ItemWingOut.ItemNum)->ItemInfo->ItemNum:0));
// 		break;
// 	case POS_WINGIN:		// 2006-07-25 by cmkwon, ߰
// 		ItemNum	= (m_UnitRenderInfo.RI_WingIn
// 			= ((m_ItemWingIn.ItemNum!=0)?((ITEM_BASE*)m_ItemWingIn.ItemNum)->ItemInfo->ItemNum:0));
// 		break;
// 	case POS_CENTER:
// 		{
// 			if(0 == m_ItemCenter.ItemNum)
// 			{
// 				ItemNum = m_UnitRenderInfo.RI_Center = 0;
// 			}
// 			else
// 			{
// 				ItemNum			= ((ITEM_BASE*)m_ItemCenter.ItemNum)->ItemInfo->ItemNum;
// 				nArmorColorCode = ((ITEM_GENERAL*)m_ItemCenter.ItemNum)->ColorCode;			// 2005-12-08 by cmkwon, Ƹ  Ʃ 
// 			}
// 		}
// 		break;
// 	case POS_REAR:
// 		ItemNum
// 			= (m_UnitRenderInfo.RI_Rear
// 			= ((m_ItemRear.ItemNum!=0)?((ITEM_BASE*)m_ItemRear.ItemNum)->ItemInfo->ItemNum:0));
// 		break;
// 	case POS_ATTACHMENT:
// 		ItemNum
// 			= (m_UnitRenderInfo.RI_Attachment
// 			= ((m_ItemAttachment.ItemNum!=0)?((ITEM_BASE*)m_ItemAttachment.ItemNum)->ItemInfo->ItemNum:0));
// 		break;
// 	default:
// 		ItemNum = -1;
// 		break;
// 	}
// 
// 	if (bSendMsg 
// 		&& ItemNum != -1)
// // 2006-07-03 by cmkwon, ĳ 忡  ʿ -  Ʈ ,...
// //		&& FALSE == this->m_character.CharacterMode)
// 	{
// 		//  ִ ĳ鿡 
// 		INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_UPDATE_ITEM_POS, T_FC_ITEM_UPDATE_ITEM_POS, pPos, pPosBuf);
// 		pPos->ClientIndex	= m_character.ClientIndex;
// 		pPos->ItemPosition	= WinPos;
// 		pPos->ItemNum		= ItemNum;
// 		pPos->ColorCode		= nArmorColorCode;
// 		ms_pFieldIOCP->SendInRangeMessageAroundCharacter(m_character.ClientIndex, pPosBuf, MSG_SIZE(MSG_FC_ITEM_UPDATE_ITEM_POS)
// 			, m_pCurrentFieldMapChannel, FALSE, m_pCurrentFieldMapChannel->GetUserVisibleDiameterW());
// 
// 		if (m_pFieldParty != NULL)
// 		{
// 			// Ƽ鿡Դ  (IM Server ̿)
// 			INIT_MSG_WITH_BUFFER(MSG_FI_PARTY_UPDATE_ITEM_POS, T_FI_PARTY_UPDATE_ITEM_POS, pPartyPos, pPartyPosBuf);
// 			pPartyPos->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
// 			pPartyPos->ItemPosition				= WinPos;
// 			pPartyPos->ItemNum					= ItemNum;
// 			pPartyPos->ColorCode				= nArmorColorCode;
// 			ms_pFieldIOCP->m_pIMWinSocket->Write(pPartyPosBuf, MSG_SIZE(MSG_FI_PARTY_UPDATE_ITEM_POS));
// 		}
// 	}
	///////////////////////////////////////////////////////////////////////////////
	// 2009-08-26 by cmkwon, ׷ ҽ  ý  - 
	INT nItemNum		= 0;
	INT nShapeItemNum	= 0;
	INT nEffectItemNum	= 0;	
	INT nPetLevel		= 0;		// 2012-12-05 by hskim, Ʈ Ⱓ  
	if(FALSE == this->UpdateItemRenderInfoByPOS(&nItemNum, &nShapeItemNum, &nEffectItemNum, WinPos, &nPetLevel))		// 2012-12-05 by hskim, Ʈ Ⱓ  
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::UpdateItemRenderInfo# invalid attached Pos(%d) Send(%d) !! ItemNum(%d) ShapeItemNum(%d) EffectItemNum(%d) \r\n", WinPos, bSendMsg, nItemNum, nShapeItemNum, nEffectItemNum);
		return;
	}

	if(FALSE == bSendMsg)
	{
		return;
	}

	INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_UPDATE_ITEM_POS, T_FC_ITEM_UPDATE_ITEM_POS, pPos, pPosBuf);
	pPos->ClientIndex	= m_character.ClientIndex;
	pPos->ItemPosition	= WinPos;
	pPos->ItemNum		= nItemNum;
	pPos->nShapeItemNum		= nShapeItemNum;		// 2009-08-26 by cmkwon, ׷ ҽ  ý  -   ItemNum ޵ȴ.
	pPos->nEffectItemNum	= nEffectItemNum;		// 2009-08-26 by cmkwon, ׷ ҽ  ý  - 
	pPos->nPetLevel		= nPetLevel;				// 2012-12-05 by hskim, Ʈ Ⱓ  
	ms_pFieldIOCP->SendInRangeMessageAroundCharacter(m_character.ClientIndex, pPosBuf, MSG_SIZE(MSG_FC_ITEM_UPDATE_ITEM_POS)
		, m_pCurrentFieldMapChannel, FALSE, m_pCurrentFieldMapChannel->GetUserVisibleDiameterW());
	
	if (m_pFieldParty != NULL)
	{
		// Ƽ鿡Դ  (IM Server ̿)
		INIT_MSG_WITH_BUFFER(MSG_FI_PARTY_UPDATE_ITEM_POS, T_FI_PARTY_UPDATE_ITEM_POS, pPartyPos, pPartyPosBuf);
		pPartyPos->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
		pPartyPos->ItemPosition				= WinPos;
		pPartyPos->ItemNum					= nItemNum;
		pPartyPos->nShapeItemNum			= nShapeItemNum;		// 2009-08-26 by cmkwon, ׷ ҽ  ý  -   ItemNum ޵ȴ.
		pPartyPos->nEffectItemNum			= nEffectItemNum;		// 2009-08-26 by cmkwon, ׷ ҽ  ý  - 
		ms_pFieldIOCP->m_pIMWinSocket->Write(pPartyPosBuf, MSG_SIZE(MSG_FI_PARTY_UPDATE_ITEM_POS));
	}


// 2009-08-26 by cmkwon, ׷ ҽ  ý  - ü 缳ϴ  ʿ 
// 	// 缳
// 	UpdateRenderInfo();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-03-18 by cmkwon, ͺ  - 
/// \author		cmkwon
/// \date		2010-03-18 ~ 2010-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::UpdateItemRenderInfoForTransformer(INT i_nMonUnitKind, BOOL i_bAttachFlag, BOOL i_bSendToAround/*=TRUE*/)
{
	if(i_bAttachFlag)
	{ 
	    // 2010-05-26 shcho  ī ߰ - Ż¿ ٷ ŵǵ 
		if(m_UnitRenderInfo.RI_MonsterUnitKind_ForTransformer && i_nMonUnitKind)
		{
			m_ItemManager.DeleteUsingTimeLimitedItemListByDestParameter(DES_TRANSFORM_TO_MONSTER);
		}
		if(0 != m_UnitRenderInfo.RI_MonsterUnitKind_ForTransformer &&
		  m_UnitRenderInfo.RI_MonsterUnitKind_ForTransformer == i_nMonUnitKind)
		{
			return FALSE;
		}
	}

	m_UnitRenderInfo.RI_MonsterUnitKind_ForTransformer	= i_nMonUnitKind;


	if(i_bSendToAround)
	{
		INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_UPDATE_TRANSFORMER_OK, T_FC_ITEM_UPDATE_TRANSFORMER_OK, pSMsg, SendBuf);
		pSMsg->CharacUID		= GetCharacter()->CharacterUniqueNumber;
		pSMsg->ClientIdx		= GetCharacter()->ClientIndex;
		pSMsg->MonsterUnitKind	= m_UnitRenderInfo.RI_MonsterUnitKind_ForTransformer;
		ms_pFieldIOCP->SendInRangeMessageAroundCharacter(m_character.ClientIndex, SendBuf, MSG_SIZE(MSG_FC_ITEM_UPDATE_TRANSFORMER_OK)
			, m_pCurrentFieldMapChannel, TRUE, m_pCurrentFieldMapChannel->GetUserVisibleDiameterW());

		if (m_pFieldParty != NULL)
		{
			// Ƽ鿡Դ  (IM Server ̿)
			INIT_MSG_WITH_BUFFER(MSG_FI_PARTY_UPDATE_ITEM_TRANSFORMER_OK, T_FI_PARTY_UPDATE_ITEM_TRANSFORMER_OK, pPMsg, pPSendBuf);
			pPMsg->CharacUID		= GetCharacter()->CharacterUniqueNumber;
			pPMsg->ClientIdx		= GetCharacter()->ClientIndex;
			pPMsg->MonsterUnitKind	= m_UnitRenderInfo.RI_MonsterUnitKind_ForTransformer;
			ms_pFieldIOCP->Send2IMServer(pPSendBuf, MSG_SIZE(MSG_FI_PARTY_UPDATE_ITEM_TRANSFORMER_OK));
		}
	}
	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		 Լ ȣ  m_ItemManager Lock ̴
///				// 2010-03-10 by cmkwon, ǿ ð ׼ ߰    - 
/// \author		cmkwon
/// \date		2005-03-10 ~ 2005-03-10
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::InitCharacterInventoryItem(BOOL i_bStartFromArena/*=FALSE*/)
{
	mt_auto_lock igLock(&(m_ItemManager.m_mapItemGeneral));		// 2010-03-10 by cmkwon, ǿ ð ׼ ߰    - 

	// 2010-06-15 by shcho&hslee ý -  .
	ITEM_GENERAL *pAccesoryTimeLimiteItemG = GetAttachItemGeneralByPosition( POS_ACCESSORY_TIME_LIMIT /*POS_PET*/);

	if(pAccesoryTimeLimiteItemG)
	{// 2006-04-24 by cmkwon, ׼ ð  ߰Ѵ, m_ItemManager.ResetTimeStampUsingTimeLimitedItemList()Լ ȣ ߰ؾѴ.
		m_ItemManager.Add2UsingTimeLimitedItemList(pAccesoryTimeLimiteItemG);
	}
	// 2010-12-21 by jskim,  ̵ ӵ   
	ITEM_GENERAL *pPetTimeItemG = GetAttachItemGeneralByPosition( POS_PET );
	
	if(pPetTimeItemG)
	{
		m_ItemManager.Add2UsingTimeLimitedItemList(pPetTimeItemG);
	}

	// end 2010-12-21 by jskim,  ̵ ӵ   

	// 1.  ð  ī  Ŭ̾Ʈ ϰ Ѵ
	m_ItemManager.ResetTimeStampUsingTimeLimitedItemList();

// 2010-03-05 by cmkwon, ߵ α  - 
//	// 2. ǻ    ü  
//	this->CheckArmor_SendTotalStat(TRUE);
	// 2010-03-05 by cmkwon, ߵ α  - 
	// 2010-03-10 by cmkwon, ǿ ð ׼ ߰    - 
	if(FALSE == i_bStartFromArena)
	{
		this->RearrangeCharacterTatalStat(FALSE);	// called CFieldIOCPSocket::InitCharacterInventoryItem#
	}
	else
	{
		this->RearrangeCharacterTatalStat();		// called CFieldIOCPSocket::InitCharacterInventoryItem#
	}

	// 3. skill and enchant 
	this->ResetAllSkillAndEnchant();		// called CFieldIOCPSocket::InitCharacterInventoryItem#

	// 4. Item Requirement üũ
	m_ItemManager.CheckRequirementAllGeneralItems();

	if(FALSE == this->GetStealthState() )		// 2013-05-09 by hskim,  Ʈ 
	{
		INIT_MSG_WITH_BUFFER(MSG_FN_CHARACTER_CHANGE_STEALTHSTATE, T_FN_CHARACTER_CHANGE_STEALTHSTATE, pSMsg, BufSend);
			pSMsg->ChannelIndex		= m_pCurrentFieldMapChannel->GetMapChannelIndex().ChannelIndex;
			pSMsg->ClientIndex		= m_character.ClientIndex;
			pSMsg->bStealthState2	= this->GetStealthState();		// 2013-05-09 by hskim,  Ʈ 

		m_pCurrentFieldMapChannel->Send2NPCServerW(BufSend, MSG_SIZE(MSG_FN_CHARACTER_CHANGE_STEALTHSTATE));
	}
	return TRUE;
}

//  () ؼ ش
BOOL CFieldIOCPSocket::ResetAllSkillAndEnchant()
{
	mt_auto_lock mta(&m_ItemManager.m_mapItemGeneral);

	m_ParamFactor.Reset();									//  ParamFactor ʱȭ
	this->m_InvokingItemManager.Init();		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, ʱȭ


// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
// 	m_SkillManager.ApplyAllPermanentAndAtivatedSkills();	// PermanentSill 
// 	ApplyEnchant(&m_ItemProwOut);							// 1  Enchant ( æƮ )
// 	ApplyEnchant(&m_ItemWingOut);							// 2  Enchant ( æƮ )
// 	ApplyRareFix(((ITEM_GENERAL*)m_ItemProwOut.ItemNum));	// 1  Rare 
// 	ApplyRareFix(((ITEM_GENERAL*)m_ItemWingOut.ItemNum));	// 2  Rare 
// 	
// 	ApplyEnchant(&m_ItemCenter);							// Ƹ Enchant (HP,DP  æƮ )
// 	ApplyArmorParamFactor();								// Ƹ 3,4 Param 
// 	
// 	// 2008-09-23 by dhjin, ű þƮ
// 	ApplyEnchant(&m_ItemRear);		//  
// 	ApplyEnchant(&m_ItemProw);		// ̴ 
// 	
// 	ChangeHP(GetCharacterTotalHP());
// 	ChangeDP(GetCharacterTotalDP());
// 	
// 	///////////////////////////////////////////////////////////////////////////////
// 	// 2006-04-24 by cmkwon
// 	this->ApplyParamFactorWithAllUsingTimeLimitedOnlyCardItemW();
// 	
// 	///////////////////////////////////////////////////////////////////////////////
// 	// 2006-04-24 by cmkwon
// 	ITEM_GENERAL *pAccesoryTimeLimiteItemG = GetAttachItemGeneralByPosition(POS_PET);
// 	if(pAccesoryTimeLimiteItemG)
// 	{
// 		ApplyParamFactorWithAccesoryTimeLimiteItem(pAccesoryTimeLimiteItemG->ItemInfo);
// 	}
	///////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ	
	m_SkillManager.ApplyAllPermanentAndAtivatedSkills();	// PermanentSill  ActivateSkill  
	ApplyDestParam8Enchant8RareOfAttachedItems();			//   

	///////////////////////////////////////////////////////////////////////////////
	// 2006-04-24 by cmkwon,     Ķ 
	this->ApplyParamFactorWithAllUsingTimeLimitedOnlyCardItemW();


	this->ChangeHP(this->GetCharacterTotalHP());
	this->ChangeDP(this->GetCharacterTotalDP());
	this->ChangeEP(this->GetCharacterTotalEP());		// 2010-03-31 by cmkwon,    (K0002796) - DP   
	this->ChangeSP(this->GetCharacterTotalSP());		// 2010-08-26 by shcho&jsKim,   

	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
	// Update DB
	QPARAM_CHARACTER_CHANGE_HPDPSPEP *pQChangeHPDPSPEP = new QPARAM_CHARACTER_CHANGE_HPDPSPEP;
	pQChangeHPDPSPEP->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
	pQChangeHPDPSPEP->HP = m_character.HP;
	pQChangeHPDPSPEP->DP = m_character.DP;
	pQChangeHPDPSPEP->SP = m_character.SP;
	pQChangeHPDPSPEP->EP = m_character.EP;
	pQChangeHPDPSPEP->CurrentHP = m_character.CurrentHP;
	pQChangeHPDPSPEP->CurrentDP = m_character.CurrentDP;
	pQChangeHPDPSPEP->CurrentSP = m_character.CurrentSP;
	pQChangeHPDPSPEP->CurrentEP = m_character.CurrentEP;
	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangeHPDPSPEP, this, m_character.AccountUniqueNumber, pQChangeHPDPSPEP);
	return TRUE;
}

// 2013-05-22 by jhseol, ҽ - ּ

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::InsertItemListByCharacterFirstGameStartFromDB(vectITEM_GENERALPtr *i_pvectItemGPtrList, vectENCHANT *i_pvectEnchantList, vectItemSkillPtr *i_pvectItemSkillPtrList)
/// \brief		  ƾ DB  Client κ и
/// wbrief		2010-06-15 by shcho&hslee ý -    ߰    ߰(vectCurrentDataInfo *i_vectPetInfo)
/// \author		dhjin
/// \date		2007-12-21 ~ 2007-12-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::InsertItemListByCharacterFirstGameStartFromDB(vectITEM_GENERALPtr *i_pvectItemGPtrList, vectENCHANT *i_pvectEnchantList, vectItemSkillPtr *i_pvectItemSkillPtrList,vecPetCurrentInfo *i_vectPetCurInfo) // 2007-12-21 by dhjin,   ƾ DB  Client κ и
{
	mt_auto_lock igLock(&(m_ItemManager.m_mapItemGeneral));
	m_ItemManager.ResetAllCharacterItems();


	///////////////////////////////////////////////////////////////////////
	// START 2010-06-15 by shcho&hslee ý -    ߰  
	//    m_vectPetInfo
	// ޾ƿ   i_vectPetInfo
	mt_auto_lock vtlock(&this->m_ItemManager.m_vectPetCurrentInfo);
	//m_vectPetInfo.clear();
	int nPetInfoCnt		= i_vectPetCurInfo->size();
	if(0 < nPetInfoCnt)
	{
		for(int i=0; i < nPetInfoCnt; i++)
		{
			tPET_CURRENTINFO *pCurrentInfo = (*i_vectPetCurInfo)[i];
			this->m_ItemManager.InsertItemPetByPointer( pCurrentInfo );
		}
		i_vectPetCurInfo->clear();
	}// END
	vtlock.auto_unlock_cancel();	
	// END 2010-06-15 by shcho&hslee ý -    ߰  
	////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////
	// 2010-06-15 by shcho&hslee ý -    Ŭ̾Ʈ .
	SendPetItemList ();
	// END 2010-06-15 by shcho&hslee ý -    Ŭ̾Ʈ .
	////////////////////////////////////////////////////////////////////////


	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-26 by cmkwon, 1. κ丮  ߰
	int nItemCnt		= i_pvectItemGPtrList->size();
	if(0 < nItemCnt)
	{// 2007-12-26 by cmkwon, κ丮  ߰
		for(int i=0; i < nItemCnt; i++)
		{
			ITEM_GENERAL *pItemG = (*i_pvectItemGPtrList)[i];

			if(COMPARE_BIT_FLAG(pItemG->ItemInfo->ItemAttribute, ITEM_ATTR_TIME_LIMITE|ITEM_ATTR_DELETED_TIME_LIMITE_AFTER_USED)	// 2008-11-26 by cmkwon,   ð(ð)    - 
				&& ITEM_NOT_USING != pItemG->UsingTimeStamp
// 2009-10-22 by cmkwon, ð   ý  - CFieldIOCPSocket::InsertItemListByCharacterFirstGameStartFromDB#, 
//				&& ITEMKIND_ACCESSORY_TIMELIMIT != pItemG->Kind
				&& FALSE == IS_ATTACHABLE_ITEM(pItemG->ItemInfo))		// 2009-10-22 by cmkwon, ð   ý  - CFieldIOCPSocket::InsertItemListByCharacterFirstGameStartFromDB#, â Ұ ۸ ó,     ó
			{
				if(TRUE == g_pFieldGlobal->IsArenaServer()) {
					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ۽  α
					CAtumLogSender::SendLogMessageInfinityStartItem(this, pItemG);
				}

				this->m_ItemManager.Add2UsingTimeLimitedItemList(pItemG);

#ifdef S_ITEM_EVENT_RETURN_USER_BCKIM				// 2013-02-28 by bckim,  ߰
				if( pItemG->ItemInfo->IsExistDesParam(DES_BUFF_TO_RETURN_USER) )
				{
					m_character.bUsingReturnItem  = TRUE;	// ൵  Ǵµ ..
					this->SendCharacterOtherInfo( m_character.ClientIndex, TRUE );
				}
#endif

				continue;
			}

			this->m_ItemManager.m_mapItemGeneral.insertLock(pItemG->UniqueNumber, pItemG);
			// 2013-06-25 by jhseol,  UID '0'   α
#ifdef S_ITEMUID_ZERO_DEBUG_LOG_JHSEOL
			if (IS_COUNTABLE_ITEM(pItemG->Kind))
			{
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DEBUG] SPI ItemUID Zero : CFieldIOCPSocket::InsertItemListByCharacterFirstGameStartFromDB - CUID(%d), ItemNum(%d), Count(%d), ItemUID(%d)\r\n"
					, this->m_character.CharacterUniqueNumber, pItemG->ItemNum, pItemG->CurrentCount, pItemG->UniqueNumber);
			}
#endif
			// end 2013-06-25 by jhseol,  UID '0'   α
			this->m_ItemManager.SetDelayStoredItemCounts(pItemG);
			if(TRUE == g_pFieldGlobal->IsArenaServer()) {
				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ۽  α
				CAtumLogSender::SendLogMessageInfinityStartItem(this, pItemG);
			}

			if(WEAR_ATTACHED == pItemG->Wear)
			{
				BOOL bWearValid = this->CheckItemWindowPosition(pItemG->ItemWindowIndex, pItemG->ItemInfo);
				if (bWearValid)
				{
					bWearValid = this->AttachItem(pItemG->ItemWindowIndex, pItemG, TRUE);
				}
				
				if(FALSE == bWearValid)
				{
					//   ȿ Ƿ ʱȭ
					pItemG->Wear				= WEAR_NOT_ATTACHED;
					pItemG->ItemWindowIndex		= POS_INVALID_POSITION;
				}

				// 2010-04-02 by cmkwon, 2 ߰  - 
				//g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TEMP] [Infinity] %s WEAR_ATTACHED %s, MainSvrItemUID(%I64d) WearValid(%d) \r\n"
				//	, GetCharacterString(GetCharacter(), string()), GetItemGeneralString(pItemG, string()), pItemG->MainSvrItemUID, bWearValid);
			}
		}
		i_pvectItemGPtrList->clear();
	}

	m_ItemManager.CalcInventoryHiddenItemCounts();		// start 2011-10-21 by hskim, Ʈ ý 2 -   ִ   (POS_HIDDEN_ITEM)  

	///////////////////////////////////////////////////////////////////////////////
	// 2007-01-29 by cmkwon, 2. æƮ ߰
	mt_auto_lock enlock(&m_mapEnchant);
	m_mapEnchant.clear();
	int nEnchantCnt		= i_pvectEnchantList->size();
	if(0 < nEnchantCnt)
	{
		for(int i=0; i < nEnchantCnt; i++)
		{
			ENCHANT *pEnchant		= &(*i_pvectEnchantList)[i];
			ITEM_GENERAL *pItemG	= m_ItemManager.GetItemGeneralByUID(pEnchant->TargetItemUniqueNumber, ITEM_IN_CHARACTER);
			if(NULL == pItemG)
			{
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Error] %s Enchant: TargetItemUID(%I64d) TargetItemNum(%d), EnchantItemNum(%d)\r\n"
					, GetCharacterString(GetCharacter(), string()), pEnchant->TargetItemUniqueNumber, pEnchant->TargetItemNum, pEnchant->EnchantItemNum);
				continue;
			}
			///////////////////////////////////////////////////////////////////////////////
			// 2007-01-30 by cmkwon, æƮ ߰
			this->InsertEnchantToItem(pItemG, *pEnchant);
		}
		i_pvectEnchantList->clear();
	}// END - if(0 < nEnchantCnt)


	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-26 by cmkwon, 3. ۰ æƮ Ŭ̾Ʈ 
	SendCharacterItemList();		// 2007-12-26 by dhjin,  Ŭ̾Ʈ  - κ丮 

	enlock.auto_unlock_cancel();	// 2007-12-26 by cmkwon, æƮ lock 

	///////////////////////////////////////////////////////////////////////////////
	// 2007-03-29 by cmkwon, 4. ߺ countable item 
	this->m_ItemManager.RearrangeCountableItems(ITEM_IN_CHARACTER);

	///////////////////////////////////////////////////////////////////////////////	
	// 2007-12-26 by cmkwon, 5. Skill ߰
	int nSkillCnt		= i_pvectItemSkillPtrList->size();
	if(0 < nSkillCnt)
	{
		for(int i=0; i < nSkillCnt; i++)
		{
			ITEM_SKILL *pItemSkill = (*i_pvectItemSkillPtrList)[i];

			///////////////////////////////////////////////////////////////////////////////
			// 2007-01-29 by cmkwon, 
			if(FALSE == this->m_ItemManager.InsertItemSkillByPointer(pItemSkill->UniqueNumber, pItemSkill))
			{
				///////////////////////////////////////////////////////////////////////////////
				// 2008-07-23 by cmkwon,    üũ ߰
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] InsertItemSkillByPointer error !!, CharInfo(%s) SkillItemInfo(%s)\r\n"
					, GetCharacterString(GetCharacter(), string()), GetItemSkillString(pItemSkill, string()));
				SAFE_DELETE(pItemSkill);
			}
		}
		i_pvectItemSkillPtrList->clear();
	}
	
	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-26 by cmkwon, 6. ų Ŭ̾Ʈ 
	SendSkillItemList();

	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-26 by cmkwon, 7. ĳ   ʱȭ
	InitCharacterInventoryItem();
	// 2009-08-26 by cmkwon, ׷ ҽ  ý  - InitRenderInfo() Լ 
	//UpdateRenderInfo();
	InitRenderInfo();

	//////////////////////////////////////////////////////////////////////////
	// 2008-01-09 by dhjin, Ʒ  -
	if(g_pFieldGlobal->IsArenaServer())
	{// 2007-12-27 by dhjin, Ʒ ̸ Ʒ   
		this->ms_pFieldIOCP->m_ArenaManager.ArenaItemSupply(this, this->m_pCurrentFieldMapChannel->GetMapChannelIndex().MapIndex);
	}	

	igLock.auto_unlock_cancel();		// 2007-12-26 by cmkwon, lock 
	
	
	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-26 by cmkwon, 8. Ʈ Ŭ̾Ʈ 
	//////////////////////////////////////////////////////////////////////////
	// 2008-01-09 by dhjin, Ʒ  -
	if(FALSE == g_pFieldGlobal->IsArenaServer())
	{// 2007-12-27 by dhjin, Ʒ  ƴϸ Ʈ 
		this->SendQuestList();
	 	////////////////////////////////////////////////////////////////////////////////	
		// 2007-07-23 by dhjin, ̺Ʈ Ⱓȿ ȸ   ϴ ̺Ʈ  üũ ߰
		// 2008-02-11 by cmkwon,  ε Ϸ  Ŀ ó ؾϴ  - CFieldIOCPSocket::InsertItemListByCharacterFirstGameStartFromDB()  ġ ̵
		vectItemEventInfo		vectItemEventInfo0;

		// start 2011-08-25 by shcho, Ƚ  ޱ  - 0ΰ  ó. 2 , Ϸ翡 ѹ ѱ 2 ؾ 
		//  üũ Ѵ.  ӽÿ ѹ ԷؾѴ.
		int Logincount = 0;
		Logincount = ms_pFieldIOCP->m_pFieldODBC->CheckLoginEventDBData(m_character.AccountUniqueNumber);	// ̺Ʈ ѹ 1 Ʈ  
		// end 2011-08-25 by shcho, Ƚ  ޱ  - 0ΰ  ó. 2 , Ϸ翡 ѹ ѱ 2 ؾ 

		// 2010-06-16 by jskim,  ̺Ʈ üũ  -
		//ms_pFieldIOCP->m_pGiveItemManager->GetActEventItemGameStart(&vectItemEventInfo0, m_ItemManager.IsExistPremiumCard(), m_bIsPCBangClient, m_character.InfluenceType, m_character.UnitKind, &m_AccountRegisteredDate, &m_atimeLastGameEndDate);
		// 2011-08-25 by shcho, Ƚ  ޱ 
		ms_pFieldIOCP->m_pGiveItemManager->GetActEventItemGameStart(&vectItemEventInfo0, m_ItemManager.IsExistPremiumCard(), m_bIsPCBangClient, m_character.InfluenceType, m_character.UnitKind, &m_AccountRegisteredDate, &m_atimeLastGameEndDate, m_character.Level, m_character.AccountUniqueNumber, Logincount);
		// end 2011-08-25 by shcho, Ƚ  ޱ 
		//end 2010-06-16 by jskim,  ̺Ʈ üũ  -
		for (int i=0; i < vectItemEventInfo0.size(); i++)
		{
			// 2013-03-29 by jhseol,  ̺Ʈ - Ÿ ߰ 
			if ( FALSE == ms_pFieldIOCP->ItemEventSubTypeCheck(m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, vectItemEventInfo0[i]) )
			{
				continue;
			}
			// end 2013-03-29 by jhseol,  ̺Ʈ - Ÿ ߰ 

			QPARAM_CHECK_EVENTITEM *pQParam = new QPARAM_CHECK_EVENTITEM;
			pQParam->AccountUID		= m_character.AccountUniqueNumber;
			pQParam->ItemEventUID	= vectItemEventInfo0[i].ItemEventUID;
			pQParam->ItemEventType  = vectItemEventInfo0[i].ItemEventType;
			pQParam->ItemNum		= vectItemEventInfo0[i].ItemNum;
			pQParam->Count			= vectItemEventInfo0[i].Count;
			pQParam->PrefixCodeNum	= vectItemEventInfo0[i].PrefixCodeNum;
			pQParam->SuffixCodeNum	= vectItemEventInfo0[i].SuffixCodeNum;
			pQParam->CharacterUID	= (FALSE == vectItemEventInfo0[i].CheckWithCharacterUID) ? 0 : m_character.CharacterUniqueNumber;	// 2009-11-19 by cmkwon,  ̺Ʈ Account/Character üũ  ߰ - 
			
#ifdef S_ITEM_EVENT_RETURN_USER_BCKIM				// 2013-02-28 by bckim,  ߰
			pQParam->UseFixedPeriod	= vectItemEventInfo0[i].UseFixedPeriod;
			pQParam->FixedPeriod_DAY= vectItemEventInfo0[i].FixedPeriod_DAY;
#endif

			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_CheckEventItem, this, m_character.AccountUniqueNumber, pQParam);
		}
	}
	
	return TRUE;
}

// 2013-05-22 by jhseol, ҽ - ּ

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::SendCharacterItemList()
/// \brief		  ƾ DB  Client κ и
/// \author		dhjin
/// \date		2007-12-14 ~ 2007-12-14
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::SendCharacterItemList()
{
	mt_auto_lock igLock(&(m_ItemManager.m_mapItemGeneral));			// lock m_mapItemGeneral, @InsertItemListFromDB

	int nItemCnt		= m_ItemManager.m_mapItemGeneral.size();
	int nTotalSend		= 0;
	int nSendCnt		= 0;
	
	INIT_MSG_WITH_BUFFER(MSG_FC_STORE_PUT_ITEM_HEADER, T_FC_STORE_PUT_ITEM_HEADER, pSPutHeader, SendBuf);
	pSPutHeader->PossessCharacter	= this->m_character.CharacterUniqueNumber;
	pSPutHeader->ItemStorage0		= ITEM_IN_CHARACTER;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_STORE_PUT_ITEM_HEADER));

	INIT_MSG(MSG_FC_STORE_INSERT_ITEM, T_FC_STORE_INSERT_ITEM, pSInsertItem, SendBuf);
	mtmapUID2ItemGeneral::iterator itr = m_ItemManager.m_mapItemGeneral.begin();
	for(; m_ItemManager.m_mapItemGeneral.end() != itr; itr++)
	{
		ITEM_GENERAL *pItemG = itr->second;

		pSInsertItem->FromCharacterUniqueNumber		= m_character.CharacterUniqueNumber;
		pSInsertItem->ItemInsertionType				= IUT_LOADING;
		pSInsertItem->ItemGeneral					= *pItemG;
		nSendCnt++;
		nTotalSend++;

		if((nSendCnt+1)*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM) > SIZE_MAX_PACKET)
		{
			this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_STORE_INSERT_ITEM));
			nSendCnt		= 0;
			MEMSET_ZERO(SendBuf, SIZE_MAX_PACKET);
			*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM)) ) = T_FC_STORE_INSERT_ITEM;
			pSInsertItem	= (MSG_FC_STORE_INSERT_ITEM*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM) + SIZE_FIELD_TYPE_HEADER);
		}
		else
		{
			*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM)) ) = T_FC_STORE_INSERT_ITEM;
			pSInsertItem	= (MSG_FC_STORE_INSERT_ITEM*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM) + SIZE_FIELD_TYPE_HEADER);
		}
	}

	if(0 < nSendCnt)
	{
		this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_STORE_INSERT_ITEM));
		nSendCnt		= 0;
	}

	INIT_MSG(MSG_FC_STORE_PUT_ITEM_DONE, T_FC_STORE_PUT_ITEM_DONE, pSPutItemDone, SendBuf);
	pSPutItemDone->NumOfItem		= nTotalSend;
	pSPutItemDone->ItemStorage0		= ITEM_IN_CHARACTER;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_STORE_PUT_ITEM_DONE));

	//////////////////////////////////////////////////////////////////////////
	//	þƮ  
	this->SendAddMessageType(T_FC_ITEM_PUT_ENCHANT_HEADER);

	m_mapEnchant.lock();

	mtmapUID2EnchantVector::iterator itrEnchantList = m_mapEnchant.begin();
	for(; itrEnchantList != m_mapEnchant.end(); itrEnchantList++)
	{
		// 2008-01-10 by cmkwon,   - pSPutEnchant ʱȭ   ̾, ⿡ ʱȭ ϴ  
		INIT_MSG(MSG_FC_ITEM_PUT_ENCHANT, T_FC_ITEM_PUT_ENCHANT, pSPutEnchant, SendBuf);
		vectENCHANT::iterator itrVEnchant = itrEnchantList->second.begin();
		for(; itrVEnchant != itrEnchantList->second.end(); itrVEnchant++)
		{
			ITEM_GENERAL *pItemG	= m_ItemManager.GetItemGeneralByUID((*itrVEnchant).TargetItemUniqueNumber, ITEM_IN_CHARACTER);
			if(NULL == pItemG)
			{
				break;
			}
			pSPutEnchant->Enchant	= *itrVEnchant;
			nSendCnt++;
			nTotalSend++;

			if((nSendCnt+1)*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT) > SIZE_MAX_PACKET)
			{
				this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT));
				nSendCnt		= 0;
				MEMSET_ZERO(SendBuf, SIZE_MAX_PACKET);
				*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT)) ) = T_FC_ITEM_PUT_ENCHANT;
				pSPutEnchant	= (MSG_FC_ITEM_PUT_ENCHANT*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT) + SIZE_FIELD_TYPE_HEADER);
			}
			else
			{
				*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT)) ) = T_FC_ITEM_PUT_ENCHANT;
				pSPutEnchant	= (MSG_FC_ITEM_PUT_ENCHANT*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT) + SIZE_FIELD_TYPE_HEADER);
			}
		}
		if(0 < nSendCnt)
		{
			this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT));
			nSendCnt		= 0;
		}
	}
	this->SendAddMessageType(T_FC_ITEM_PUT_ENCHANT_DONE);

	// unlock
	m_mapEnchant.unlock();

	// 2013-05-31 by jhseol,bckim Ƹ ÷ - arena  main  ͽ Ÿ̸ 
#ifdef SC_COLLECTION_ARMOR_JHSEOL_BCKIM	// - arena  main  ͽ Ÿ̸ 
	mtmapUID2ItemGeneral::iterator itr2 = m_ItemManager.m_mapItemGeneral.begin();
	for(; m_ItemManager.m_mapItemGeneral.end() != itr2; itr2++)
	{
		ITEM_GENERAL *pItemG = itr2->second;
		if ( TRUE == pItemG->FixedTermShape.bActive && IS_ENABLE_CHANGE_ShapeItemNum(pItemG->Kind) )
		{
			INT nCalcMin = 0;
			ATUM_DATE_TIME CurrentDate(TRUE);
			
			nCalcMin = pItemG->FixedTermShape.EndDate.GetTimeDiffTimeInMinutes(CurrentDate);
			pItemG->FixedTermShape.TimerUID = this->m_TimerManager.StartTimerField(TE_TYPE_FIXED_TERM_SHAPE, max(nCalcMin, 0) * TIMER_DO_MINUTELY_WORK, 0, 0);
		}
	}

	m_ArmorCollection.SendCollectionInfoAllData();
	// 2013-04-18 by jhseol,bckim ̴ Ƹ - ÷ ̴ Ƹ ̺Ʈ  
	#ifdef S_MONTHL_ARMOR_EVENT_JHSEOL_BCKIM	// - ÷ ̴ Ƹ ̺Ʈ  
	if ( NULL != ms_pFieldIOCP && NULL != ms_pFieldIOCP->m_pMonthlyArmorManager)
	{
		ms_pFieldIOCP->m_pMonthlyArmorManager->SendMonthlyArmorEventAllCollectionList(this);
	}
	#endif
	// end 2013-04-18 by jhseol,bckim ̴ Ƹ - ÷ ̴ Ƹ ̺Ʈ  
#endif
	// end 2013-05-31 by jhseol,bckim Ƹ ÷ - arena  main  ͽ Ÿ̸ 

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::InsertStoreItemListFromDB(vectITEM_GENERALPtr *i_pvectItemGPtrList, vectENCHANT *i_pvectEnchantList, UID32_t i_possessCharacterUID, vecPetCurrentInfo *i_vectPetCurInfo)
/// \brief		  ƾ DB  Client κ и
///				// 2008-01-10 by cmkwon,  â   - CFieldIOCPSocket::InsertStoreItemListFromDB()   ߰
/// \author		dhjin
/// \date		2007-12-14 ~ 2007-12-14
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::InsertStoreItemListFromDB(vectITEM_GENERALPtr *i_pvectItemGPtrList, vectENCHANT *i_pvectEnchantList, UID32_t i_possessCharacterUID, vecPetCurrentInfo *i_vectPetCurInfo)		// 2012-01-14 by hskim, Ʈ ý 2 - â   Ŭ ƨ  
{
	if(FALSE == this->IsValidCharacter(FALSE)){				return FALSE;}

	// start 2012-01-14 by hskim, Ʈ ý 2 - â   Ŭ ƨ  
	if( NULL != i_vectPetCurInfo )
	{
		mt_auto_lock vtlock(&this->m_ItemManager.m_vectPetCurrentInfo);

		vecPetCurrentInfo::iterator itr(i_vectPetCurInfo->begin());
		while(itr != i_vectPetCurInfo->end())
		{
			tPET_CURRENTINFO *pCurrentInfo = *itr;
			if( TRUE == this->m_ItemManager.InsertItemPetByPointer(pCurrentInfo) )
			{
				itr = i_vectPetCurInfo->erase(itr);
				continue;
			}

			itr++;
		}

		vtlock.auto_unlock_cancel();

		SendPetItemList();
	}
	// end 2012-01-14 by hskim, Ʈ ý 2 - â   Ŭ ƨ  

	mt_auto_lock igLock(&(m_ItemManager.m_mapItemGeneral));			// lock m_mapItemGeneral, @InsertItemListFromDB
	m_ItemManager.ResetAllItemGeneralsInStore();
	m_ItemManager.m_uid32StoreCharacterUID = i_possessCharacterUID;		// 2008-01-10 by cmkwon,  â   - ش CharacterUID  ؾ Ѵ.

	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-27 by cmkwon, 1. â  ߰
	int nItemCnt		= i_pvectItemGPtrList->size();
	if(0 < nItemCnt)
	{
		for(int i=0; i < nItemCnt; i++)
		{
			ITEM_GENERAL *pItemG = (*i_pvectItemGPtrList)[i];
			if(FALSE == this->m_ItemManager.InsertStoreItemByPointer(pItemG->UniqueNumber, pItemG))
			{
				///////////////////////////////////////////////////////////////////////////////
				// 2008-07-23 by cmkwon,    üũ ߰
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] InsertStoreItemByPointer error !!, CharInfo(%s), StoreCharacterUID(%d), ItemInfo(%s) ItemPossess(%d)\r\n"
					, GetCharacterString(GetCharacter(), string()), m_ItemManager.m_uid32StoreCharacterUID 
					, GetItemGeneralString(pItemG, string()), pItemG->Possess);
				SAFE_DELETE(pItemG);
			}
		}
		i_pvectItemGPtrList->clear();

	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-27 by cmkwon, 2. countable item ߺ 
	this->m_ItemManager.RearrangeCountableItems(ITEM_IN_STORE);

	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-27 by cmkwon, 3. â  æƮ ó
	int nEnchantCnt		= i_pvectEnchantList->size();
	if(0 < nEnchantCnt)
	{
		mt_auto_lock enlock(&m_mapEnchant);			// 2007-12-27 by cmkwon, ߰
		for(int i=0; i < nEnchantCnt; i++)
		{
			ENCHANT *pEnchant		= &(*i_pvectEnchantList)[i];
			ITEM_GENERAL *pItemG	= m_ItemManager.GetItemGeneralByUID(pEnchant->TargetItemUniqueNumber, ITEM_IN_STORE);
			if(NULL == pItemG)
			{
				g_pGlobalGameServer->WriteSystemLogEX(TRUE, "[Error] Enchant error !! , %s TargetItemUID(%I64d) TargetItemNum(%d), EnchantItemNum(%d)\r\n",
					GetCharacterString(&m_character, string()),	pEnchant->TargetItemUniqueNumber, pEnchant->TargetItemNum, pEnchant->EnchantItemNum);
				continue;
			}
			///////////////////////////////////////////////////////////////////////////////
			// 2007-01-30 by cmkwon, æƮ ߰
			this->InsertEnchantToItem(pItemG, *pEnchant);
		}
		i_pvectEnchantList->clear();
	}// END - if(0 < nEnchantCnt)

	///////////////////////////////////////////////////////////////////////////////
	// 2009-01-20 by cmkwon, â    - â SPI  ٸ 0 ߰ Ѵ.
	if(NULL == m_ItemManager.GetFirstItemGeneralByItemNum(MONEY_ITEM_NUMBER, ITEM_IN_STORE))
	{
		m_ItemManager.InsertItemBaseByItemNum(MONEY_ITEM_NUMBER, 0, IUT_GENERAL);
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-12-27 by cmkwon, 4. Ŭ̾Ʈ ϱ
	this->SendStoreItemList();			// 2007-12-26 by cmkwon, ġ ű
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::SendStoreItemList()
/// \brief		  ƾ DB  Client κ и
/// \author		dhjin
/// \date		2007-12-14 ~ 2007-12-14
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::SendStoreItemList()
{
	// 2009-10-30 by cmkwon, â      - lock   , Ʒ  m_ItemManager.m_mapItemGeneral ó ؾ .
	//mt_auto_lock igLock(&(m_ItemManager.m_mapItemInStore));			// lock m_mapItemGeneral, @InsertItemListFromDB
	mt_auto_lock igLock(&(m_ItemManager.m_mapItemGeneral));			// lock m_mapItemGeneral, @InsertItemListFromDB

	int nItemCnt		= m_ItemManager.m_mapItemInStore.size();
	int nTotalSend		= 0;
	int nSendCnt		= 0;
	
	INIT_MSG_WITH_BUFFER(MSG_FC_STORE_PUT_ITEM_HEADER, T_FC_STORE_PUT_ITEM_HEADER, pSPutHeader, SendBuf);
	pSPutHeader->PossessCharacter	= this->m_character.CharacterUniqueNumber;
	pSPutHeader->ItemStorage0		= ITEM_IN_STORE;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_STORE_PUT_ITEM_HEADER));

	INIT_MSG(MSG_FC_STORE_INSERT_ITEM, T_FC_STORE_INSERT_ITEM, pSInsertItem, SendBuf);
	mtmapUID2ItemGeneral::iterator itr = m_ItemManager.m_mapItemInStore.begin();
	for(; m_ItemManager.m_mapItemInStore.end() != itr; itr++)
	{

		ITEM_GENERAL *pItemG = itr->second;

		pSInsertItem->FromCharacterUniqueNumber		= m_character.CharacterUniqueNumber;
		pSInsertItem->ItemInsertionType				= IUT_LOADING;
		pSInsertItem->ItemGeneral					= *pItemG;
		nSendCnt++;
		nTotalSend++;

		if((nSendCnt+1)*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM) > SIZE_MAX_PACKET)
		{
			this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_STORE_INSERT_ITEM));
			nSendCnt		= 0;
			MEMSET_ZERO(SendBuf, SIZE_MAX_PACKET);
			*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM)) ) = T_FC_STORE_INSERT_ITEM;
			pSInsertItem	= (MSG_FC_STORE_INSERT_ITEM*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM) + SIZE_FIELD_TYPE_HEADER);
		}
		else
		{
			*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM)) ) = T_FC_STORE_INSERT_ITEM;
			pSInsertItem	= (MSG_FC_STORE_INSERT_ITEM*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_STORE_INSERT_ITEM) + SIZE_FIELD_TYPE_HEADER);
		}
	}// END - for(int i=0; i < nItemCnt; i++)

	if(0 < nSendCnt)
	{
		this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_STORE_INSERT_ITEM));
		nSendCnt		= 0;
	}

	INIT_MSG(MSG_FC_STORE_PUT_ITEM_DONE, T_FC_STORE_PUT_ITEM_DONE, pSPutItemDone, SendBuf);
	pSPutItemDone->NumOfItem		= nTotalSend;
	pSPutItemDone->ItemStorage0		= ITEM_IN_STORE;
	this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_STORE_PUT_ITEM_DONE));

	//////////////////////////////////////////////////////////////////////////
	//	þƮ  
	
	mt_auto_lock enlock(&m_mapEnchant);			// 2007-12-27 by cmkwon, 
	mtmapUID2EnchantVector::iterator itrEnchantList = m_mapEnchant.begin();
	for(; itrEnchantList != m_mapEnchant.end(); itrEnchantList++)
	{
		// 2008-01-10 by cmkwon,   - pSPutEnchant ʱȭ   ̾, ⿡ ʱȭ ϴ  
		INIT_MSG(MSG_FC_ITEM_PUT_ENCHANT, T_FC_ITEM_PUT_ENCHANT, pSPutEnchant, SendBuf);
		vectENCHANT::iterator itrVEnchant = itrEnchantList->second.begin();
		for(; itrVEnchant != itrEnchantList->second.end(); itrVEnchant++)
		{
			ITEM_GENERAL *pItemG	= m_ItemManager.GetItemGeneralByUID((*itrVEnchant).TargetItemUniqueNumber, ITEM_IN_STORE);
			if(NULL == pItemG)
			{
				break;
			}

			pSPutEnchant->Enchant	= *itrVEnchant;
			nSendCnt++;
			nTotalSend++;

			if((nSendCnt+1)*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT) > SIZE_MAX_PACKET)
			{
				this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT));
				nSendCnt		= 0;
				MEMSET_ZERO(SendBuf, SIZE_MAX_PACKET);
				*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT)) ) = T_FC_ITEM_PUT_ENCHANT;
				pSPutEnchant	= (MSG_FC_ITEM_PUT_ENCHANT*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT) + SIZE_FIELD_TYPE_HEADER);
			}
			else
			{
				*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT)) ) = T_FC_ITEM_PUT_ENCHANT;
				pSPutEnchant	= (MSG_FC_ITEM_PUT_ENCHANT*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT) + SIZE_FIELD_TYPE_HEADER);
			}
		}
		if(0 < nSendCnt)
		{
			this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT));
			nSendCnt		= 0;
		}
	}
	enlock.auto_unlock_cancel();	// unlock

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::InsertSkillListFromDB(vectItemSkillPtr *i_pvectItemSkillPtrList)
/// \brief		  ƾ DB  Client κ и
/// \author		dhjin
/// \date		2007-12-14 ~ 2007-12-14
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::InsertSkillListFromDB(vectItemSkillPtr *i_pvectItemSkillPtrList)
{
	mt_auto_lock igLock(&(m_ItemManager.m_mapItemGeneral));

	int nSkillCnt		= i_pvectItemSkillPtrList->size();
	if(0 >= nSkillCnt)
	{
		return FALSE;
	}

	for(int i=0; i < nSkillCnt; i++)
	{
		ITEM_SKILL *pItemSkill = (*i_pvectItemSkillPtrList)[i];

		///////////////////////////////////////////////////////////////////////////////
		// 2007-01-29 by cmkwon, 
		if(FALSE == this->m_ItemManager.InsertItemSkillByPointer(pItemSkill->UniqueNumber, pItemSkill))
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2008-07-23 by cmkwon,    üũ ߰
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] InsertItemSkillByPointer error !!, CharInfo(%s) SkillItemInfo(%s)\r\n"
				, GetCharacterString(GetCharacter(), string()), GetItemSkillString(pItemSkill, string()));
			SAFE_DELETE(pItemSkill);
		}
	}

	i_pvectItemSkillPtrList->clear();

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::SendSkillItemList()
/// \brief		  ƾ DB  Client κ и
/// \author		dhjin
/// \date		2007-12-14 ~ 2007-12-14
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::SendSkillItemList()
{
	mt_auto_lock igLock(&(m_ItemManager.m_mapItemGeneral));
	
	int nTotalSend			= 0;
	int nSendCnt			= 0;

	this->SendAddMessageType(T_FC_SKILL_SETUP_SKILL_OK_HEADER);
	INIT_MSG_WITH_BUFFER(MSG_FC_SKILL_SETUP_SKILL_OK, T_FC_SKILL_SETUP_SKILL_OK, pSSetupSkillOK, SendBuf);

	vectItemSkillPtr::iterator itr = m_ItemManager.m_vectItemSkillPtr.begin();
	while (itr != m_ItemManager.m_vectItemSkillPtr.end())
	{
		pSSetupSkillOK->ItemUpdateType	= IUT_LOADING;
		pSSetupSkillOK->ItemSkill		= **itr;
		nSendCnt++;
		nTotalSend++;

		if((nSendCnt+1)*MSG_SIZE(MSG_FC_SKILL_SETUP_SKILL_OK) > SIZE_MAX_PACKET)
		{
			this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_SKILL_SETUP_SKILL_OK));
			nSendCnt		= 0;
			MEMSET_ZERO(SendBuf, SIZE_MAX_PACKET);
			*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_SKILL_SETUP_SKILL_OK)) ) = T_FC_SKILL_SETUP_SKILL_OK;
			pSSetupSkillOK	= (MSG_FC_SKILL_SETUP_SKILL_OK*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_SKILL_SETUP_SKILL_OK) + SIZE_FIELD_TYPE_HEADER);
		}
		else
		{
			*( (MessageType_t*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_SKILL_SETUP_SKILL_OK)) ) = T_FC_SKILL_SETUP_SKILL_OK;
			pSSetupSkillOK	= (MSG_FC_SKILL_SETUP_SKILL_OK*)(SendBuf + nSendCnt*MSG_SIZE(MSG_FC_SKILL_SETUP_SKILL_OK) + SIZE_FIELD_TYPE_HEADER);
		}
		itr++;
	}

	if(0 < nSendCnt)
	{
		this->SendAddData(SendBuf, nSendCnt * MSG_SIZE(MSG_FC_SKILL_SETUP_SKILL_OK));
		nSendCnt		= 0;
	}
	this->SendAddMessageType(T_FC_SKILL_SETUP_SKILL_OK_DONE);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			 void CFieldIOCPSocket::SendPetItemList()
/// \brief		// 2010-06-15 by shcho&hslee ý - Ŭ̾Ʈ Ŷ  Լ ߰ 
/// \author		shcho&hslee
/// \date		2010-07-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::SendPetItemList()
{
	
	// IOCPϿ Itemmanager  ִ   
	mt_auto_lock igLock(&(m_ItemManager.m_vectPetCurrentInfo));
	
	int nTotalSend			= 0;
	int nSendCnt			= 0;
	
	this->SendAddMessageType(T_FC_ITEM_PET_HEADER);

	const tPET_CURRENTINFO *a_pPetCurInfo = NULL;
	
	//  ⺻ ġ  .
	INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_PET_BASEDATA, T_FC_ITEM_PET_BASEDATA_OK, pSSetupPetItemOK, SendBuf_PetBase);

	mtvectPetCurrentInfo::iterator itr = m_ItemManager.m_vectPetCurrentInfo.begin();

	while ( itr != m_ItemManager.m_vectPetCurrentInfo.end() )
	{
		///////////////////////////////////////////////////////////////////////////////////////
		// start 2011-08-17 by hskim, Ʈ ý 2 - ڷ  
		//
		//  
		//

// 		a_pPetCurInfo = (const tPET_CURRENTINFO *)(*itr);
// 
// 		pSSetupPetItemOK->ItemUpdateType = IUT_LOADING;
// 		
// 		pSSetupPetItemOK->CreatedPetUID = a_pPetCurInfo->CreatedPetUID;
// 		
// 		pSSetupPetItemOK->EnableEditPetName = a_pPetCurInfo->EnableEditPetName;
// 		pSSetupPetItemOK->EnableLevelUp = a_pPetCurInfo->EnableLevelUp;
// 		
// 		strcpy ( pSSetupPetItemOK->szPetName, a_pPetCurInfo->szPetName );
// 		
// 		pSSetupPetItemOK->PetIndex = a_pPetCurInfo->PetIndex;
// 		pSSetupPetItemOK->PetLevel = a_pPetCurInfo->PetLevel;
// 		
// 		pSSetupPetItemOK->PetExp = a_pPetCurInfo->PetExp;
// 		
// 		pSSetupPetItemOK->Stamina = a_pPetCurInfo->Stamina;
// 		
// 		pSSetupPetItemOK->SourceIndex_Field = a_pPetCurInfo->SourceIndex_Field;
// 		pSSetupPetItemOK->SourceIndex_City = a_pPetCurInfo->SourceIndex_City;
// 
// 
// 		for ( int i = 0 ; i < SIZE_MAX_PETSKILLITEM ; ++i )
// 		{
// 			if ( a_pPetCurInfo->pItem_PetSkill[i] )
// 				pSSetupPetItemOK->ItemIndex_PetSkill[i] = a_pPetCurInfo->pItem_PetSkill[i]->ItemNum;
// 		}

		/////////
		// 

		a_pPetCurInfo = (const tPET_CURRENTINFO *)(*itr);

		pSSetupPetItemOK->ItemUpdateType = IUT_LOADING;
		pSSetupPetItemOK->CreatedPetUID = a_pPetCurInfo->CreatedPetUID;
		strcpy ( pSSetupPetItemOK->PetName, a_pPetCurInfo->PetName );
		pSSetupPetItemOK->PetIndex = a_pPetCurInfo->PetIndex;
		pSSetupPetItemOK->PetLevel = a_pPetCurInfo->PetLevel;
		pSSetupPetItemOK->PetExp = a_pPetCurInfo->PetExp;
		pSSetupPetItemOK->PetExpRatio = a_pPetCurInfo->PetExpRatio;
		pSSetupPetItemOK->PetEnableSocketCount = a_pPetCurInfo->PetEnableSocketCount;

		memcpy(&pSSetupPetItemOK->PetSocketItemUID, &(a_pPetCurInfo->PetSocketItemUID), sizeof(pSSetupPetItemOK->PetSocketItemUID));
		memcpy(&pSSetupPetItemOK->PetKitHP, &(a_pPetCurInfo->PetKitHP), sizeof(pSSetupPetItemOK->PetKitHP));
		memcpy(&pSSetupPetItemOK->PetKitShield, &(a_pPetCurInfo->PetKitShield), sizeof(pSSetupPetItemOK->PetKitShield));
		memcpy(&pSSetupPetItemOK->PetKitSP, &(a_pPetCurInfo->PetKitSP), sizeof(pSSetupPetItemOK->PetKitSP));
		memcpy(&pSSetupPetItemOK->PetAutoSkill, &(a_pPetCurInfo->PetAutoSkill), sizeof(pSSetupPetItemOK->PetAutoSkill));

		// end 2011-08-17 by hskim, Ʈ ý 2 - ڷ  
		///////////////////////////////////////////////////////////////////////////////////////
	
		nSendCnt++;
		nTotalSend++;

		if((nSendCnt+1)*MSG_SIZE(MSG_FC_ITEM_PET_BASEDATA) > SIZE_MAX_PACKET)
		{
			this->SendAddData( SendBuf_PetBase,nSendCnt*MSG_SIZE( MSG_FC_ITEM_PET_BASEDATA ) );
			nSendCnt = 0;
			MEMSET_ZERO(SendBuf_PetBase,SIZE_MAX_PACKET);
			*( ( MessageType_t* ) ( SendBuf_PetBase + nSendCnt*MSG_SIZE( MSG_FC_ITEM_PET_BASEDATA ) ) ) = T_FC_ITEM_PET_BASEDATA_OK;
			pSSetupPetItemOK = (MSG_FC_ITEM_PET_BASEDATA*) ( SendBuf_PetBase + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PET_BASEDATA) + SIZE_FIELD_TYPE_HEADER );
		}
		else
		{
			*( (MessageType_t*)(SendBuf_PetBase + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PET_BASEDATA)) ) = T_FC_ITEM_PET_BASEDATA_OK;
			pSSetupPetItemOK = (MSG_FC_ITEM_PET_BASEDATA*) ( SendBuf_PetBase + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PET_BASEDATA) + SIZE_FIELD_TYPE_HEADER );
		}
		itr++;
	}
	
	if ( 0 < nSendCnt )
	{
		this->SendAddData(SendBuf_PetBase, nSendCnt * MSG_SIZE(MSG_FC_ITEM_PET_BASEDATA));
		nSendCnt = 0;
	}
	//..

	//    .
// 	INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_PET_SOCKETDATA, T_FC_ITEM_PET_SOCKETDATA_OK, pSSetupPetItem_SocketDataOK, SendBuf_Socket);
// 	
// 	itr = m_ItemManager.m_vectPetCurrentInfo.begin();
// 	
// 	while ( itr != m_ItemManager.m_vectPetCurrentInfo.end() )
// 	{
// 		a_pPetCurInfo = (const tPET_CURRENTINFO *)(*itr);
// 		
// 		int i = 0;
// 		
// 		for ( i = 0; i < SIZE_MAX_PETSOCKETITEM; ++i )
// 		{
// 			if ( a_pPetCurInfo->pItem_PetSocketItem[i] )
// 			{
// 				pSSetupPetItem_SocketDataOK->CreatePetUID = a_pPetCurInfo->CreatedPetUID;
// 				pSSetupPetItem_SocketDataOK->iSlotIndex = i;
// 				
// 				memcpy ( &pSSetupPetItem_SocketDataOK->sItem_PetSocket , a_pPetCurInfo->pItem_PetSocketItem[i] , sizeof( ITEM ) );
// 														
// 				
// 				nSendCnt++;
// 				nTotalSend++;
// 				
// 				if((nSendCnt+1)*MSG_SIZE(MSG_FC_ITEM_PET_SOCKETDATA) > SIZE_MAX_PACKET)
// 				{
// 					this->SendAddData( SendBuf_Socket,nSendCnt*MSG_SIZE( MSG_FC_ITEM_PET_SOCKETDATA ) );
// 					nSendCnt = 0;
// 					MEMSET_ZERO(SendBuf_Socket,SIZE_MAX_PACKET);
// 					*( ( MessageType_t* ) ( SendBuf_Socket + nSendCnt*MSG_SIZE( MSG_FC_ITEM_PET_SOCKETDATA ) ) ) = T_FC_ITEM_PET_SOCKETDATA_OK;
// 					pSSetupPetItem_SocketDataOK = (MSG_FC_ITEM_PET_SOCKETDATA*) ( SendBuf_Socket + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PET_SOCKETDATA) + SIZE_FIELD_TYPE_HEADER );
// 				}
// 				else
// 				{
// 					*( (MessageType_t*)(SendBuf_Socket + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PET_SOCKETDATA)) ) = T_FC_ITEM_PET_SOCKETDATA_OK;
// 					pSSetupPetItem_SocketDataOK = (MSG_FC_ITEM_PET_SOCKETDATA*) ( SendBuf_Socket + nSendCnt*MSG_SIZE(MSG_FC_ITEM_PET_SOCKETDATA) + SIZE_FIELD_TYPE_HEADER );
// 				}
// 			}
// 		}
// 		
// 		itr++;
// 	}
// 	
// 	if ( 0 < nSendCnt )
// 	{
// 		this->SendAddData(SendBuf_Socket, nSendCnt * MSG_SIZE(MSG_FC_ITEM_PET_SOCKETDATA));
// 		nSendCnt = 0;
// 	}
	//..

	this->SendAddMessageType(T_FC_ITEM_PET_DONE);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			 void CFieldIOCPSocket::SendInsertPetItemList()
/// \brief		// 2010-06-15 by shcho&hslee ý - Item Insert ÿ Ŭ̾Ʈ Ŷ  Լ ߰ 
/// \author		shcho&hslee
/// \date		2010-07-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::SendInsertPetItemInfo(BYTE ItemInsertiontype, tPET_CURRENTINFO* pcurrentPetInfo)
{
	const tPET_CURRENTINFO *a_pPetCurInfo = pcurrentPetInfo;
	
	//  ⺻ ġ  .
	INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_PET_BASEDATA, T_FC_ITEM_PET_BASEDATA_OK, pSSetupPetItemOK, SendBuf_PetBase);

	///////////////////////////////////////////////////////////////////////////////////////
	// start 2011-08-17 by hskim, Ʈ ý 2 - ڷ  
	//
	//  
	//

// 	pSSetupPetItemOK->ItemUpdateType = IUT_LOADING;		
// 	pSSetupPetItemOK->CreatedPetUID = a_pPetCurInfo->CreatedPetUID;
// 	pSSetupPetItemOK->EnableEditPetName = a_pPetCurInfo->EnableEditPetName;
// 	pSSetupPetItemOK->EnableLevelUp = a_pPetCurInfo->EnableLevelUp;
// 	strcpy ( pSSetupPetItemOK->szPetName, a_pPetCurInfo->szPetName );
// 	pSSetupPetItemOK->PetIndex = a_pPetCurInfo->PetIndex;
// 	pSSetupPetItemOK->PetLevel = a_pPetCurInfo->PetLevel;
// 	pSSetupPetItemOK->PetExp = a_pPetCurInfo->PetExp;
// 	pSSetupPetItemOK->Stamina = a_pPetCurInfo->Stamina;
// 	pSSetupPetItemOK->SourceIndex_Field = a_pPetCurInfo->SourceIndex_Field;
// 	pSSetupPetItemOK->SourceIndex_City = a_pPetCurInfo->SourceIndex_City;
// 
// 	for ( int i = 0; i < SIZE_MAX_PETSKILLITEM; ++i )
// 	{
// 		if ( a_pPetCurInfo->pItem_PetSkill[i] )
// 			pSSetupPetItemOK->ItemIndex_PetSkill[i] = a_pPetCurInfo->pItem_PetSkill[i]->ItemNum;
// 		// ų  0ó
// 		pSSetupPetItemOK->ItemIndex_PetSkill[i] = 0;
// 	}

	/////////
	// 

	pSSetupPetItemOK->ItemUpdateType = IUT_LOADING;		
	pSSetupPetItemOK->CreatedPetUID = a_pPetCurInfo->CreatedPetUID;
	strcpy(pSSetupPetItemOK->PetName, a_pPetCurInfo->PetName);
	pSSetupPetItemOK->PetIndex = a_pPetCurInfo->PetIndex;
	pSSetupPetItemOK->PetLevel = a_pPetCurInfo->PetLevel;
	pSSetupPetItemOK->PetExp = a_pPetCurInfo->PetExp;
	pSSetupPetItemOK->PetExpRatio = a_pPetCurInfo->PetExpRatio;
	pSSetupPetItemOK->PetEnableSocketCount = a_pPetCurInfo->PetEnableSocketCount;

	memcpy(&pSSetupPetItemOK->PetSocketItemUID, &(a_pPetCurInfo->PetSocketItemUID), sizeof(pSSetupPetItemOK->PetSocketItemUID));
	memcpy(&pSSetupPetItemOK->PetKitHP, &(a_pPetCurInfo->PetKitHP), sizeof(pSSetupPetItemOK->PetKitHP));
	memcpy(&pSSetupPetItemOK->PetKitShield, &(a_pPetCurInfo->PetKitShield), sizeof(pSSetupPetItemOK->PetKitShield));
	memcpy(&pSSetupPetItemOK->PetKitSP, &(a_pPetCurInfo->PetKitSP), sizeof(pSSetupPetItemOK->PetKitSP));
	memcpy(&pSSetupPetItemOK->PetAutoSkill, &(a_pPetCurInfo->PetAutoSkill), sizeof(pSSetupPetItemOK->PetAutoSkill));

	// end 2011-08-17 by hskim, Ʈ ý 2 - ڷ  
	///////////////////////////////////////////////////////////////////////////////////////

	this->SendAddData(SendBuf_PetBase, MSG_SIZE(MSG_FC_ITEM_PET_BASEDATA));
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::SendQuestList()
/// \brief		  ƾ DB  Client κ и
/// \author		dhjin
/// \date		2007-12-14 ~ 2007-12-14
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::SendQuestList()
{
	mt_auto_lock mtA(&m_mapQuest);

	this->SendAddMessageType(T_FC_QUEST_PUT_ALL_QUEST_HEADER);
	///////////////////////////////////////////////////////////////////////////////
	// 2005-10-25 by cmkwon
	INIT_MSG_WITH_BUFFER(MSG_FC_QUEST_PUT_ALL_QUEST, T_FC_QUEST_PUT_ALL_QUEST, pPutAllQuest, SendBuf);
	pPutAllQuest->fVCNInflDistributionPercent	= ms_pFieldIOCP->GetInfluenceTypeDistirbutionPercent(INFLUENCE_TYPE_VCN);	// 2006-02-08 by cmkwon
	pPutAllQuest->fANIInflDistributionPercent	= ms_pFieldIOCP->GetInfluenceTypeDistirbutionPercent(INFLUENCE_TYPE_ANI);	// 2006-02-08 by cmkwon
	pPutAllQuest->NumOfQuest 					= 0;

	mtmapQuestIndex2FieldCharacterQuest::iterator cqitr(m_mapQuest.begin());
	for(; cqitr != m_mapQuest.end(); cqitr++)
	{
		CFieldCharacterQuest	*pFCharQuest = &cqitr->second;
		CQuest					*pQuestInfo = pFCharQuest->GetQuestInfo();

		if(MSG_SIZE(MSG_FC_QUEST_PUT_ALL_QUEST)+(pPutAllQuest->NumOfQuest+1)*sizeof(MEX_QUEST_INFO) >= SIZE_MAX_PACKET)
		{
			this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_QUEST_PUT_ALL_QUEST) + pPutAllQuest->NumOfQuest*sizeof(MEX_QUEST_INFO));
			pPutAllQuest->NumOfQuest		= 0;
		}

		MEX_QUEST_INFO *pQuest4Exch		= (MEX_QUEST_INFO*)(SendBuf + MSG_SIZE(MSG_FC_QUEST_PUT_ALL_QUEST) + pPutAllQuest->NumOfQuest*sizeof(MEX_QUEST_INFO));
		pQuest4Exch->QuestIndex			= pFCharQuest->QuestIndex;
		pQuest4Exch->QuestState			= pFCharQuest->QuestState;
		pQuest4Exch->QuestPlayTimeStamp	= pFCharQuest->QuestPlayTimeStamp;
		if(pQuestInfo->IsCityWar)
		{
			STRNCPY_MEMSET(pQuest4Exch->szCityWarServerGroupName, g_pFieldGlobal->GetServerGroupNameByMGameServerID(pFCharQuest->QuestParam1), SIZE_MAX_SERVER_NAME);
		}
		
		pPutAllQuest->NumOfQuest++;
	}
	if (pPutAllQuest->NumOfQuest > 0)
	{		
		this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_QUEST_PUT_ALL_QUEST) + pPutAllQuest->NumOfQuest*sizeof(MEX_QUEST_INFO));
	}
	this->SendAddMessageType(T_FC_QUEST_PUT_ALL_QUEST_DONE);

	this->SendAddMessageType(T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT_HEADER);
	///////////////////////////////////////////////////////////////////////////////
	// 2005-10-25 by cmkwon
	// Ʈ  īƮ  Ѵ.
	INIT_MSG(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT, T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT, pSAllMonCount, SendBuf);
	pSAllMonCount->NumOfMonsterCount	= 0;

	cqitr = m_mapQuest.begin();
	for(; cqitr != m_mapQuest.end(); cqitr++)
	{
		CFieldCharacterQuest	*pFCharQuest = &cqitr->second;
		CQuest					*pQuestInfo = pFCharQuest->GetQuestInfo();
		if(pQuestInfo->TargetMonsterVector.empty()
			|| pFCharQuest->IsEmptyMonsterCount())
		{
			continue;
		}

		vectCharacterQuestMonsterCount::iterator	mcitr(pFCharQuest->m_vectQuestMonsterCount.begin());
		for(; mcitr != pFCharQuest->m_vectQuestMonsterCount.end(); mcitr++)
		{
			if(MSG_SIZE(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT)+(pSAllMonCount->NumOfMonsterCount+1)*sizeof(MEX_QUEST_MONSTER_COUNT) >= SIZE_MAX_PACKET)
			{
				this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT) + pSAllMonCount->NumOfMonsterCount*sizeof(MEX_QUEST_MONSTER_COUNT));
				pSAllMonCount->NumOfMonsterCount	= 0;
			}
			MEX_QUEST_MONSTER_COUNT *pMonCount4Exch = (MEX_QUEST_MONSTER_COUNT*)(SendBuf + MSG_SIZE(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT) + pSAllMonCount->NumOfMonsterCount*sizeof(MEX_QUEST_MONSTER_COUNT));
			pMonCount4Exch->QuestIndex			= pFCharQuest->QuestIndex;
			pMonCount4Exch->MonsterUniqueNumber	= mcitr->MonsterUniqueNumber;
			pMonCount4Exch->Count				= mcitr->Count;

			pSAllMonCount->NumOfMonsterCount++;
		}
	}
	if (pSAllMonCount->NumOfMonsterCount > 0)
	{		
		this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT) + pSAllMonCount->NumOfMonsterCount*sizeof(MEX_QUEST_MONSTER_COUNT));
	}
	this->SendAddMessageType(T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT_DONE);
	
}


float CFieldIOCPSocket::GetEnchantValue(ITEM *pTargetItem, BYTE desParam)
{
	float fRetValue = 0.0f;

	if(NULL == pTargetItem || 0 == pTargetItem->ItemNum){			return fRetValue;}
	ITEM_GENERAL	*pItemGeneral		= (ITEM_GENERAL*)pTargetItem->ItemNum;
	ITEM			*pItemInfoOriginal	= ms_pFieldIOCP->GetItemInfo(pItemGeneral->ItemNum);	//   

	if (pItemGeneral->Wear == WEAR_NOT_ATTACHED)
	{
		return fRetValue;
	}

	m_mapEnchant.lock();
	{
		mtmapUID2EnchantVector::iterator itrEnchantList	= m_mapEnchant.find(pItemGeneral->UniqueNumber);
		if (m_mapEnchant.end() != itrEnchantList)
		{
			vectENCHANT &vecECH = itrEnchantList->second;

			for (int i = 0; i < vecECH.size(); i++)
			{
				ENCHANT &tmpEnchant = vecECH[i];
				ITEM *pEnchantItemInfo = ms_pFieldIOCP->GetItemInfo(tmpEnchant.EnchantItemNum);
				if (pEnchantItemInfo != NULL)
				{					
// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - Ʒ  
// 					if(desParam == pEnchantItemInfo->DestParameter1)
// 						fRetValue += pEnchantItemInfo->ParameterValue1;
// 					if(desParam == pEnchantItemInfo->DestParameter2)
// 						fRetValue += pEnchantItemInfo->ParameterValue2;
// 					if(desParam == pEnchantItemInfo->DestParameter3)
// 						fRetValue += pEnchantItemInfo->ParameterValue3;
// 					if(desParam == pEnchantItemInfo->DestParameter3)
// 						fRetValue += pEnchantItemInfo->ParameterValue3;
					if(pEnchantItemInfo->IsExistDesParam(desParam))
					{
						fRetValue += pEnchantItemInfo->GetParameterValue(desParam);
					}

				}
			}
		}
	}
	m_mapEnchant.unlock();

	return fRetValue;
}

// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
BOOL CFieldIOCPSocket::ApplyEnchant(ITEM_GENERAL *pTargetItemG)
{
// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
// 	if (pTargetItem == NULL || pTargetItem->ItemNum == NULL) {				return FALSE; }
// 
// 	ITEM_GENERAL	*pItemGeneral		= (ITEM_GENERAL*)pTargetItem->ItemNum;
// 	ITEM			*pItemInfoOriginal	= ms_pFieldIOCP->GetItemInfo(pItemGeneral->ItemNum);	//   
	///////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
	if(NULL == pTargetItemG){					return FALSE;}
 	ITEM_GENERAL	*pItemGeneral		= pTargetItemG;
 	ITEM			*pItemInfoOriginal	= pTargetItemG->ItemInfo;

	// lock
	m_mapEnchant.lock();
	{
//		pItemGeneral->DesWeight			= 0.0f;		// 2006-01-24 by cmkwon, ߷ æƮ ġ ʱȭ	// 2012-11-12 by khkim ̰ ʱȭ  ޸ ߻ 
		mtmapUID2EnchantVector::iterator itrEnchantList	= m_mapEnchant.find(pItemGeneral->UniqueNumber);
		if (m_mapEnchant.end() != itrEnchantList)
		{
			vectENCHANT &vecECH = itrEnchantList->second;

			for (int i = 0; i < vecECH.size(); i++)
			{
				ENCHANT &tmpEnchant = vecECH[i];
				ITEM *pEnchantItemInfo = ms_pFieldIOCP->GetItemInfo(tmpEnchant.EnchantItemNum);
				if (pEnchantItemInfo != NULL)
				{
					///////////////////////////////////////////////////////////////////////////////
					// 2006-01-24 by cmkwon,  ߷ æƮ 
// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - Ʒ  
// 					if(DES_WEIGHT_01 == pEnchantItemInfo->DestParameter1 || DES_WEIGHT_02 == pEnchantItemInfo->DestParameter1)
// 					{
// 						pItemGeneral->DesWeight		+= pEnchantItemInfo->ParameterValue1;
// 					}
// 					if(DES_WEIGHT_01 == pEnchantItemInfo->DestParameter2 || DES_WEIGHT_02 == pEnchantItemInfo->DestParameter2)
// 					{
// 						pItemGeneral->DesWeight		+= pEnchantItemInfo->ParameterValue2;
// 					}
// 					if(DES_WEIGHT_01 == pEnchantItemInfo->DestParameter3 || DES_WEIGHT_02 == pEnchantItemInfo->DestParameter3)
// 					{
// 						pItemGeneral->DesWeight		+= pEnchantItemInfo->ParameterValue3;
// 					}
// 					if(DES_WEIGHT_01 == pEnchantItemInfo->DestParameter4 || DES_WEIGHT_02 == pEnchantItemInfo->DestParameter4)
// 					{
// 						pItemGeneral->DesWeight		+= pEnchantItemInfo->ParameterValue4;
// 					}
					if(pEnchantItemInfo->IsExistDesParam(DES_WEIGHT_01))
					{
						pItemGeneral->DesWeight		+= pEnchantItemInfo->GetParameterValue(DES_WEIGHT_01);
					}
					if(pEnchantItemInfo->IsExistDesParam(DES_WEIGHT_02))
					{
						pItemGeneral->DesWeight		+= pEnchantItemInfo->GetParameterValue(DES_WEIGHT_02);
					}
					
					///////////////////////////////////////////////////////////////////////////////
					// â  ParamFactor 
					if (pItemGeneral->Wear == WEAR_ATTACHED)
					{

// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - Ʒ  
// 						SetParamFactor(pEnchantItemInfo->DestParameter1, pEnchantItemInfo->ParameterValue1);
// 						SetParamFactor(pEnchantItemInfo->DestParameter2, pEnchantItemInfo->ParameterValue2);
// 						SetParamFactor(pEnchantItemInfo->DestParameter3, pEnchantItemInfo->ParameterValue3);
// 						SetParamFactor(pEnchantItemInfo->DestParameter4, pEnchantItemInfo->ParameterValue4);
						for(int j=0; j < SIZE_MAX_DESPARAM_COUNT_IN_ITEM; j++)
						{
							SetParamFactor(pEnchantItemInfo->ArrDestParameter[j], pEnchantItemInfo->ArrParameterValue[j]);
						}
					}

					///////////////////////////////////////////////////////////////////////////////
					// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
					if(pEnchantItemInfo->InvokingDestParamID) {
						this->EnchantApplyInvokingItem(pItemGeneral, pEnchantItemInfo);
					}
				}
			}
		}
	}
	m_mapEnchant.unlock();

	return TRUE;
}

BOOL CFieldIOCPSocket::InsertEnchantToItem(ITEM_GENERAL *pTargetItem, ENCHANT &enchant)
{
	// lock
	m_mapEnchant.lock();

	mtmapUID2EnchantVector::iterator itrEnchantList = m_mapEnchant.find(enchant.TargetItemUniqueNumber);
	if (m_mapEnchant.end() == itrEnchantList)
	{
		vectENCHANT v1;
		m_mapEnchant.insertLock(enchant.TargetItemUniqueNumber, v1);
		itrEnchantList = m_mapEnchant.find(enchant.TargetItemUniqueNumber);
	}

	vectENCHANT &tmpVector = itrEnchantList->second;
	if(0 == tmpVector.size())
	{
		tmpVector.reserve(SIZE_MAX_ENCHANT_PER_ITEM);
	}

	// 2009-10-30 by cmkwon, â      - CFieldIOCPSocket::InsertEnchantToItem#
	if(SIZE_MAX_ENCHANT_PER_ITEM <= tmpVector.size())
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::InsertEnchantToItem enchang count over !! %s %s CurEnchantCount(%d) BuildingKind(%d) EnchangItemNum(%d) \r\n"
			, GetCharacterString(this->GetCharacter(), string()), GetItemGeneralString(pTargetItem, string()), tmpVector.size(), enchant.EnchantItemNum);

		m_mapEnchant.unlock();
		return FALSE;
	}
	
	tmpVector.push_back(enchant);

	// unlock
	m_mapEnchant.unlock();

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::InsertEnchantToItem(ITEM_GENERAL *pTargetItem, vectENCHANT *i_pvectEnchant, BOOL bSendToClient/*=TRUE*/)
/// \brief		
/// \author		cmkwon
/// \date		2006-05-11 ~ 2006-05-11
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::InsertEnchantToItem(ITEM_GENERAL *pTargetItem, vectENCHANT *i_pvectEnchant, BOOL bSendToClient/*=TRUE*/)
{
	INIT_MSG_WITH_BUFFER(MSG_FC_ITEM_PUT_ENCHANT, T_FC_ITEM_PUT_ENCHANT, pPutEnchant, SendBuf);
	mt_auto_lock mtA(&m_mapEnchant);			// 2006-12-18 by cmkwon,  (m_mapTradeItem->m_mapEnchant)
	int nVectCnt = i_pvectEnchant->size();
	for(int i=0; i < nVectCnt; i++)
	{
		this->InsertEnchantToItem(pTargetItem, (*i_pvectEnchant)[i]);
		if(bSendToClient)
		{
			pPutEnchant->Enchant = (*i_pvectEnchant)[i];
			this->SendAddData(SendBuf, MSG_SIZE(MSG_FC_ITEM_PUT_ENCHANT));
		}
	}

	return TRUE;
}

BOOL CFieldIOCPSocket::DeleteAllEnchantToItem(UID64_t i_itemUID)
{
	// lock
	m_mapEnchant.lock();
	m_mapEnchant.erase(i_itemUID);
	m_mapEnchant.unlock();

	return TRUE;
}

void CFieldIOCPSocket::PrintEnchant(UID64_t ItemUniqueNumber, BOOL i_bWriteSystemLog)
{
// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø -  
// 	BitFlag8_t DO2Option = (DO2_DBGOUT | (i_bWriteSystemLog?DO2_SYSLOG:0));
// 
// 	// lock m_mapItemGeneral, @PrintEnchant
// 	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
// 
// 	// lock
// 	m_mapEnchant.lock();
// 
// 	mtmapUID2EnchantVector::iterator itrECH = m_mapEnchant.begin();
// 	while (itrECH != m_mapEnchant.end())
// 	{
// 		if (ItemUniqueNumber == 0 || ItemUniqueNumber == itrECH->first)
// 		{
// 			DBGOUT2(DO2Option, "  ENCHANT %s: ", GetItemString(m_ItemManager.GetItemGeneralByUID(itrECH->first), string()));
// 			vectENCHANT &vecECH = itrECH->second;
// 
// 			for (int ii = 0; ii < vecECH.size(); ii++)
// 			{
// 				ITEM *pEnchantItem = ms_pFieldIOCP->GetItemInfo(vecECH[ii].EnchantItemNum);
// 				if (pEnchantItem != NULL)
// 				{
// 					DBGOUT2(DO2Option, "%s(%d)", pEnchantItem->ItemName, pEnchantItem->ItemNum);
// 					DBGOUT2(DO2Option, "[%d(%3.2f) ", pEnchantItem->DestParameter1, pEnchantItem->ParameterValue1);
// 					DBGOUT2(DO2Option, "%d(%3.2f) ", pEnchantItem->DestParameter2, pEnchantItem->ParameterValue2);
// 					DBGOUT2(DO2Option, "%d(%3.2f) ", pEnchantItem->DestParameter3, pEnchantItem->ParameterValue3);
// 					DBGOUT2(DO2Option, "%d(%3.2f)] ", pEnchantItem->DestParameter4, pEnchantItem->ParameterValue4);
// 				}
// 			}
// 			DBGOUT2(DO2Option, "\r\n");
// 		}
// 
// 		itrECH++;
// 	}
// 
// 	// unlock
// 	m_mapEnchant.unlock();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::PopAllEnchantByItemUID(vectENCHANT *o_pvectEnchat, UID64_t i_itemUID)
/// \brief		
/// \author		cmkwon
/// \date		2006-05-11 ~ 2006-05-11
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::PopAllEnchantByItemUID(vectENCHANT *o_pvectEnchat, UID64_t i_itemUID)
{
	mt_auto_lock mtA(&m_mapEnchant);

	mtmapUID2EnchantVector::iterator itr = m_mapEnchant.find(i_itemUID);
	if (itr == m_mapEnchant.end())
	{
		return FALSE;
	}

	*o_pvectEnchat = itr->second;		
	
	m_mapEnchant.erase(i_itemUID);		// Ѵ.

	return TRUE;
}

// 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  
BOOL CFieldIOCPSocket::GetAllEnchantListByItemUID(vectENCHANT *o_pvectEnchat, UID64_t i_itemUID)
{
	mt_auto_lock mtA(&m_mapEnchant);
	
	mtmapUID2EnchantVector::iterator itr = m_mapEnchant.find(i_itemUID);
	if (itr == m_mapEnchant.end())
	{
		return FALSE;
	}
	
	*o_pvectEnchat = itr->second;		
	return TRUE;
}
// End. 2013-07-01 by bckim, 10æƮ ̸ īó, α߰,  

///////////////////////////////////////////////////////////////////////////////
/// \fn			vectENCHANT *CFieldIOCPSocket::GetVectEnchantListPtr(UID64_t i_itemUID)
/// \brief		
/// \author		cmkwon
/// \date		2006-07-27 ~ 2006-07-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
vectENCHANT *CFieldIOCPSocket::GetVectEnchantListPtr(UID64_t i_itemUID)
{
	mtmapUID2EnchantVector::iterator itr = m_mapEnchant.find(i_itemUID);
	if (itr == m_mapEnchant.end())
	{
		return NULL;
	}

	return &(itr->second);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ
/// \author		cmkwon
/// \date		2010-03-05 ~ 2010-03-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::ApplyDestParam8Enchant8RareOfAttachedItems(void)
{
	mt_auto_lock mta(&m_ItemManager.m_mapItemGeneral);

	for (int i = 0; i < SIZE_MAX_POS; i++)
	{
		ITEM_GENERAL *pItemG = GetAttachItemGeneralByPosition(i);
		if(NULL == pItemG)
		{
			continue;
		}

		// 1. ش  ⺻ DestParam , cpu   .
		if(pItemG->Kind != ITEMKIND_COMPUTER)
		{
			// 2013-05-31 by jhseol,bckim Ƹ ÷ -  ɼ ( )
#ifdef SC_COLLECTION_ARMOR_JHSEOL_BCKIM	// -  ɼ ( )
			if ( ITEMKIND_DEFENSE == pItemG->Kind)
			{
				ITEM *pOptionItem = ms_pFieldIOCP->GetItemInfo(pItemG->FixedTermShape.nStatShapeItemNum);
				if ( NULL != pOptionItem )
				{
					for ( int i = 0 ; i < pItemG->FixedTermShape.nStatLevel ; i++ )
					{
						ApplyItemDesParam(pOptionItem);
					}
				}
			}
#endif
			// end 2013-05-31 by jhseol,bckim Ƹ ÷ -  ɼ ( )

			// 2013-04-18 by jhseol,bckim ̴ Ƹ -   ɼ 
#ifdef S_MONTHL_ARMOR_EVENT_JHSEOL_BCKIM		//   ɼ 
			if ( ITEMKIND_DEFENSE == pItemG->Kind)
			{
				ITEM *pOptionItem = ms_pFieldIOCP->GetItemInfo(pItemG->nMonthlyOptionItemNum);
				if ( NULL != pOptionItem )
				{
					ApplyItemDesParam(pOptionItem);
				}
			}
#endif
			// end 2013-04-18 by jhseol,bckim ̴ Ƹ -   ɼ 
			ApplyItemDesParam(pItemG->ItemInfo);
		}

		// 2. â ߵ  
		ApplyInvokingItem(pItemG);

		// 2.5  (þƮ / ) ɼ ʱȭ
		ItemOptionInitialization(pItemG);			// 2010-11-12 by khkim ޸:14() α  

		// 3.  
		if(IS_RARE_TARGET_ITEMKIND(pItemG->Kind))
		{
			ApplyRareFix(pItemG);
		}

		// 4. æƮ 
		if(IS_ENCHANT_TARGET_ITEMKIND(pItemG->Kind))
		{
			ApplyEnchant(pItemG);
		}
	}
	return TRUE;
}

void CFieldIOCPSocket::ApplyRareItem(CFieldMonster *i_pMonster, MONSTER2ITEM *i_pMonster2Item
									 , float i_fPlusRateDropRareItem, CFieldIOCP *i_pFieldIOCP, ITEM_GENERAL *io_pItem)
{
	int i = 0;
	// 2010-04-20 by cmkwon, ű Ű ӽ  -
	//if (FALSE == IS_WEAPON(io_pItem->Kind)
	if(FALSE == IS_RARE_TARGET_ITEMKIND(io_pItem->Kind)
		|| COMPARE_BIT_FLAG(io_pItem->ItemInfo->ItemAttribute, ITEM_ATTR_UNIQUE_ITEM|ITEM_ATTR_LEGEND_ITEM))
	{// 2007-08-22 by cmkwon,   - üũ ߰, // 2005-12-02 by cmkwon, ũ  üũ
		return;
	}

	///////////////////////////////////////////////////////////////////////////////
	// i_fPlusRateDropRareItem Prefix,Suffixó  Ȯ Ѵ

	// Prefix 
	int prob = RAND100K();
	if (i_pMonster2Item->PrefixProbability > 0
		&& i_pMonster2Item->PrefixProbability > prob - i_pMonster2Item->PrefixProbability*i_fPlusRateDropRareItem)
	{		
		io_pItem->PrefixCodeNum = ms_pFieldIOCP->GetRandomRareCode(io_pItem->ItemInfo, TRUE, RARE_ITEM_USE_TYPE_NORMAL);
	}

	// Suffix 
	prob = RAND100K();
	if (i_pMonster2Item->SuffixProbability > 0
		&& i_pMonster2Item->SuffixProbability > prob - i_pMonster2Item->SuffixProbability*i_fPlusRateDropRareItem)
	{
		io_pItem->SuffixCodeNum = ms_pFieldIOCP->GetRandomRareCode(io_pItem->ItemInfo, FALSE, RARE_ITEM_USE_TYPE_NORMAL);
	}

// 2007-12-07 by cmkwon,  ý  -   CFieldIOCP::GetRandomRareCode() Լ ó
//	// Prefix 
//	int prob = RAND100K();
//	if (i_pMonster2Item->PrefixProbability > 0
//		&& i_pMonster2Item->PrefixProbability > prob - i_pMonster2Item->PrefixProbability*i_fPlusRateDropRareItem)
//	{
////		DBGOUT("Monster: %s(%d), Item: %s, Pro(%d) > Rand(%d) \r\n",	i_pMonster->MonsterInfoPtr->MonsterName, i_pMonster->MonsterIndex
////			, io_pItem->ItemInfo->ItemName, (INT)(i_pMonster2Item->PrefixProbability)
////			, (int)(prob - i_pMonster2Item->PrefixProbability*i_fPlusRateDropRareItem));
//		
//		vector<RARE_ITEM_INFO* > *pRareFixVector= i_pFieldIOCP->m_mapLevel2RareItemInfo.findEZ_ptr(min(CHARACTER_MAX_LEVEL, io_pItem->ItemInfo->ReqMinLevel));
//		for (i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (IS_RARE_SUFFIX(pRareItemInfo->CodeNum)
//				|| !COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItem->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, RARE_ITEM_USE_TYPE_NORMAL))
//			{
//				continue;
//			}
//
//			prob = RAND100K();
//			if (pRareItemInfo->Probability > prob)
//			{// RareItem 
//
////				DBGOUT("	Prefix : %d > %d\r\n", (INT)(pRareItemInfo->Probability), prob);				
//				io_pItem->PrefixCodeNum = pRareItemInfo->CodeNum;
//				break;
//			}
////			else
////			{
////				DBGOUT("	Prefix : %d <= %d\r\n", (INT)(pRareItemInfo->Probability), prob);
////			}
//		}
//	}
//
//	// Suffix 
//	prob = RAND100K();
//	if (i_pMonster2Item->SuffixProbability > 0
//		&& i_pMonster2Item->SuffixProbability > prob - i_pMonster2Item->SuffixProbability*i_fPlusRateDropRareItem)
//	{
////		DBGOUT("Monster: %s(%d), Item: %s, Pro(%d) > Rand(%d)\r\n", i_pMonster->MonsterInfoPtr->MonsterName, i_pMonster->MonsterIndex,
////			io_pItem->ItemInfo->ItemName, (INT)(i_pMonster2Item->SuffixProbability)
////			, (int)(prob - i_pMonster2Item->SuffixProbability*i_fPlusRateDropRareItem));
//
//		vector<RARE_ITEM_INFO* > *pRareFixVector
//			= i_pFieldIOCP->m_mapLevel2RareItemInfo.findEZ_ptr(min(CHARACTER_MAX_LEVEL, io_pItem->ItemInfo->ReqMinLevel));
//
//		for (i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (IS_RARE_PREFIX(pRareItemInfo->CodeNum)
//				|| !COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItem->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, RARE_ITEM_USE_TYPE_NORMAL))
//			{
//				continue;
//			}
//
//			prob = RAND100K();
//			if (pRareItemInfo->Probability > prob)
//			{// RareItem 
//
////				DBGOUT("	Suffix : %d > %d\r\n", (INT)(pRareItemInfo->Probability), prob);				
//				io_pItem->SuffixCodeNum = pRareItemInfo->CodeNum;
//				break;
//			}
////			else
////			{
////				DBGOUT("	Suffix : %d <= %d\r\n", (INT)(pRareItemInfo->Probability), prob);
////			}
//		}
//	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::ApplyGambleRareFix(ITEM_GENERAL *io_pItemG, int i_n100KPrefixProbability, int i_n100KSuffixProbability)
/// \brief		
/// \author		cmkwon
/// \date		2006-08-10 ~ 2006-08-10
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::ApplyGambleRareFix(ITEM_GENERAL *io_pItemG, int i_n100KPrefixProbability, int i_n100KSuffixProbability)
{
	int i = 0;
	// 2010-04-20 by cmkwon, ű Ű ӽ  -
	//if (FALSE == IS_WEAPON(io_pItemG->Kind)
	if(FALSE == IS_RARE_TARGET_ITEMKIND(io_pItemG->Kind)
		|| COMPARE_BIT_FLAG(io_pItemG->ItemInfo->ItemAttribute, ITEM_ATTR_UNIQUE_ITEM|ITEM_ATTR_LEGEND_ITEM))
	{// 2007-08-22 by cmkwon,   - üũ ߰, // 2006-08-10 by cmkwon, ũ  üũ
		return FALSE;
	}

	///////////////////////////////////////////////////////////////////////////////
	// Prefix 
	int prob = RAND100K();
	if (i_n100KPrefixProbability > 0
		&& i_n100KPrefixProbability > prob)
	{
		io_pItemG->PrefixCodeNum = ms_pFieldIOCP->GetRandomRareCode(io_pItemG->ItemInfo, TRUE, RARE_ITEM_USE_TYPE_NORMAL, this);	// 2007-12-07 by cmkwon,  ý  - 
		
		if (io_pItemG->PrefixCodeNum == 0)
		{// Prefix  پ ,    ,  츦  α 			
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::ApplyGambleRareFix_ Prefix error, %s %s\r\n",
				GetCharacterString(&m_character, string()), GetItemString(io_pItemG, string()));
		}
	}

	///////////////////////////////////////////////////////////////////////////////
	// Suffix 
	prob = RAND100K();
	if (i_n100KSuffixProbability > 0
		&& i_n100KSuffixProbability > prob)
	{
		io_pItemG->SuffixCodeNum = ms_pFieldIOCP->GetRandomRareCode(io_pItemG->ItemInfo, FALSE, RARE_ITEM_USE_TYPE_NORMAL, this);	// 2007-12-07 by cmkwon,  ý  - 
		
		if (io_pItemG->SuffixCodeNum == 0)
		{// Suffix  پ ,    ,  츦  α 
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::ApplyGambleRareFix_ Suffix, %s %s\r\n",
				GetCharacterString(&m_character, string()), GetItemString(io_pItemG, string()));
		}
	}
	return TRUE;

// 2007-12-07 by cmkwon,  ý  -   CFieldIOCP::GetRandomRareCode() Լ ó
//	///////////////////////////////////////////////////////////////////////////////
//	// Prefix 
//	int prob = RAND100K();
//	if (i_n100KPrefixProbability > 0
//		&& i_n100KPrefixProbability > prob)
//	{
//		vector<RARE_ITEM_INFO* > *pRareFixVector = ms_pFieldIOCP->m_mapLevel2RareItemInfo.findEZ_ptr(min(CHARACTER_MAX_LEVEL, io_pItemG->ItemInfo->ReqMinLevel));
//		
//		Prob100K_t	nSumProb		= 0;
//		///////////////////////////////////////////////////////////////////////////////
//		// شǴ RareFix  Ȯ  
//		for (int i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//			if (IS_RARE_SUFFIX(pRareItemInfo->CodeNum)
//				|| FALSE == COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItemG->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, RARE_ITEM_USE_TYPE_NORMAL)
//				)
//			{
//				continue;
//			}
//
//			nSumProb += pRareItemInfo->Probability;
//		}
//
//		Prob100K_t prob				= RANDI(0, nSumProb-1);
//		Prob100K_t nTempSumProb		= 0;
//		///////////////////////////////////////////////////////////////////////////////		
//		// Ȯ  RareFix 
//		for (i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (IS_RARE_SUFFIX(pRareItemInfo->CodeNum)
//				|| FALSE == COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItemG->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, RARE_ITEM_USE_TYPE_NORMAL)
//				)
//			{
//				continue;
//			}
//
//			if (0 < nTempSumProb+pRareItemInfo->Probability			// 2006-04-20 by cmkwon, 0    
//				&& IS_IN_RANGE(nTempSumProb, prob, nTempSumProb+pRareItemInfo->Probability))
//			{// RareItem 
//
//				io_pItemG->PrefixCodeNum = pRareItemInfo->CodeNum;
//				break;
//			}
//
//			nTempSumProb += pRareItemInfo->Probability;			// 
//		}
//
//		// Prefix  پ ,    ,  츦  α 
//		if (io_pItemG->PrefixCodeNum == 0)
//		{
//			g_pFieldGlobal->WriteSystemLogEX(TRUE, "FATAL Error: No Prefix, %d %d %s %s\r\n",
//				(int)nTempSumProb, (int)prob, GetCharacterString(&m_character, string()), GetItemString(io_pItemG, string()));
//		}
//	}// END - if (i_n100KPrefixProbability > 0 && i_n100KPrefixProbability > prob)
//
//	///////////////////////////////////////////////////////////////////////////////
//	///////////////////////////////////////////////////////////////////////////////
//	// Suffix 
//	prob = RAND100K();
//	if (i_n100KSuffixProbability > 0
//		&& i_n100KSuffixProbability > prob)
//	{
//		vector<RARE_ITEM_INFO* > *pRareFixVector = ms_pFieldIOCP->m_mapLevel2RareItemInfo.findEZ_ptr(min(CHARACTER_MAX_LEVEL, io_pItemG->ItemInfo->ReqMinLevel));
//
//		Prob100K_t	nSumProb		= 0;
//		///////////////////////////////////////////////////////////////////////////////		
//		// شǴ RareFix  Ȯ  
//		for (int i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (IS_RARE_PREFIX(pRareItemInfo->CodeNum)
//				|| FALSE == COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItemG->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, RARE_ITEM_USE_TYPE_NORMAL)
//				)
//			{
//				continue;
//			}
//
//			nSumProb += pRareItemInfo->Probability;
//		}
//
//		Prob100K_t prob				= RANDI(0, nSumProb-1);
//		Prob100K_t nTempSumProb		= 0;
//		///////////////////////////////////////////////////////////////////////////////
//		// Ȯ  RareFix 
//		for (i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (IS_RARE_PREFIX(pRareItemInfo->CodeNum)
//				|| FALSE == COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItemG->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, RARE_ITEM_USE_TYPE_NORMAL)
//				)
//			{
//				continue;
//			}
//
//			if (0 < nTempSumProb+pRareItemInfo->Probability			// 2006-04-20 by cmkwon, 0    
//				&& IS_IN_RANGE(nTempSumProb, prob, nTempSumProb+pRareItemInfo->Probability))
//			{// RareItem 
//
//				io_pItemG->SuffixCodeNum = pRareItemInfo->CodeNum;
//				break;
//			}
//	
//			nTempSumProb += pRareItemInfo->Probability;		// 
//		}
//
//		// Suffix  پ ,    ,  츦  α 
//		if (io_pItemG->SuffixCodeNum == 0)
//		{
//			g_pFieldGlobal->WriteSystemLogEX(TRUE, "FATAL Error: No Suffix, %d %d %s %s\r\n",
//				(int)nTempSumProb, (int)prob, GetCharacterString(&m_character, string()), GetItemString(io_pItemG, string()));
//		}
//	}// END - if (i_n100KSuffixProbability > 0 && i_n100KSuffixProbability > prob)
//
//	return TRUE;
}

// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  - ߰(, RARE_ITEM_INFO *i_pLastRareItemInfo/*=NULL*/)
BOOL CFieldIOCPSocket::ApplyGambleRareFix(ITEM *i_pGambleItemInfo, ITEM_GENERAL *io_pItem, RARE_ITEM_INFO *i_pLastRareItemInfo/*=NULL*/)
{
// 2010-04-20 by cmkwon, ű Ű ӽ  -
//	if (FALSE == IS_WEAPON(io_pItem->Kind)){					return FALSE;}
	if(FALSE == IS_RARE_TARGET_ITEMKIND(io_pItem->Kind)){		return FALSE;}

	int			nReqUseType	= 0;
	// 2007-11-07 by cmkwon, / ٴ ý  - Ʒ  ITEM_ATTR_SUPER_GAMBLE_ITEM  üũ Ͽ óϴ  
	//if(FALSE == COMPARE_BIT_FLAG(i_pGambleItemInfo->ItemAttribute, ITEM_ATTR_CASH_ITEM))

	// 2012-12-27 by hskim,  / ý 
	if( TRUE == COMPARE_BIT_FLAG(i_pGambleItemInfo->ItemAttribute, ITEM_ATTR_HYPER_GAMBLE_ITEM) )
	{
		SET_BIT_FLAG(nReqUseType, RARE_ITEM_USE_TYPE_HYPERGAMBLE);
	}
	else
	// end 2012-12-27 by hskim,  / ý 
	
	if(FALSE == COMPARE_BIT_FLAG(i_pGambleItemInfo->ItemAttribute, ITEM_ATTR_SUPER_GAMBLE_ITEM))
	{// 2007-11-07 by cmkwon, / ٴ ý  - 
		SET_BIT_FLAG(nReqUseType, RARE_ITEM_USE_TYPE_GAMBLE);
	}
	else
	{
		SET_BIT_FLAG(nReqUseType, RARE_ITEM_USE_TYPE_SUPERGAMBLE);
	}

	// Prefix 
	// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  - 
	//if (i_pGambleItemInfo->DestParameter1 == DES_RARE_FIX_PREFIX)
	if (IS_DES_RARE_FIX_PREFIX(i_pGambleItemInfo))
	{
		/////////////////////////////////////////////////////////////////////////
		// start 2011-10-20 by hskim, EP4 [Free to play] - /  ɼ

		/////////
		// 
	
//		// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  -  ߰Ѱ 
//		io_pItem->PrefixCodeNum = ms_pFieldIOCP->GetRandomRareCode(io_pItem->ItemInfo, TRUE, nReqUseType, this, i_pLastRareItemInfo);	// 2007-12-07 by cmkwon,  ý  - 
//		if (io_pItem->PrefixCodeNum == 0)
//		{// Prefix  پ ,    ,  츦  α 
//			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::ApplyGambleRareFix_ Prefix, %s %s %s\r\n",
//				GetCharacterString(&m_character, string()),	GetItemString(io_pItem, string()), i_pGambleItemInfo->ItemName);
//		}

		/////////
		// 

		if( FALSE == i_pGambleItemInfo->IsExistDesParam(DES_GAMBLE_RARE_ITEM_FIX) )
		{
		// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  -  ߰Ѱ 
		io_pItem->PrefixCodeNum = ms_pFieldIOCP->GetRandomRareCode(io_pItem->ItemInfo, TRUE, nReqUseType, this, i_pLastRareItemInfo);	// 2007-12-07 by cmkwon,  ý  - 
		if (io_pItem->PrefixCodeNum == 0)
		{// Prefix  پ ,    ,  츦  α 
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::ApplyGambleRareFix_ Prefix, %s %s %s\r\n",
				GetCharacterString(&m_character, string()),	GetItemString(io_pItem, string()), i_pGambleItemInfo->ItemName);
		}
	}
		else
		{
			//  CheckFixRareCode() Լ ̸ ˻

			io_pItem->PrefixCodeNum = i_pGambleItemInfo->GetParameterValue(DES_GAMBLE_RARE_ITEM_FIX);
		}

		// end 2011-10-20 by hskim, EP4 [Free to play] - /  ɼ
		/////////////////////////////////////////////////////////////////////////
	}

	// Suffix 
	// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  - 
	//if (i_pGambleItemInfo->DestParameter1 == DES_RARE_FIX_SUFFIX)
	if (IS_DES_RARE_FIX_SUFFIX(i_pGambleItemInfo))
	{
		/////////////////////////////////////////////////////////////////////////
		// start 2011-10-20 by hskim, EP4 [Free to play] - /  ɼ

		/////////
		// 

		/*
		// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  -  ߰Ѱ 
		io_pItem->SuffixCodeNum = ms_pFieldIOCP->GetRandomRareCode(io_pItem->ItemInfo, FALSE, nReqUseType, this, i_pLastRareItemInfo);	// 2007-12-07 by cmkwon,  ý  - 
		if (io_pItem->SuffixCodeNum == 0)
		{// Suffix  پ ,    ,  츦  α 
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::ApplyGambleRareFix_ Suffix, %s %s %s\r\n",
				GetCharacterString(&m_character, string()),	GetItemString(io_pItem, string()), i_pGambleItemInfo->ItemName);
		*/

		/////////
		// 

		if( FALSE == i_pGambleItemInfo->IsExistDesParam(DES_GAMBLE_RARE_ITEM_FIX) )
		{
			// 2008-10-21 by cmkwon,  õ  ٽ  ʰ  -  ߰Ѱ 
			io_pItem->SuffixCodeNum = ms_pFieldIOCP->GetRandomRareCode(io_pItem->ItemInfo, FALSE, nReqUseType, this, i_pLastRareItemInfo);	// 2007-12-07 by cmkwon,  ý  - 
			if (io_pItem->SuffixCodeNum == 0)
			{// Suffix  پ ,    ,  츦  α 
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::ApplyGambleRareFix_ Suffix, %s %s %s\r\n",
					GetCharacterString(&m_character, string()),	GetItemString(io_pItem, string()), i_pGambleItemInfo->ItemName);
			}
		}
		else
		{
			//  CheckFixRareCode() Լ ̸ ˻

			io_pItem->SuffixCodeNum = i_pGambleItemInfo->GetParameterValue(DES_GAMBLE_RARE_ITEM_FIX);
		}
		// end 2011-10-20 by hskim, EP4 [Free to play] - /  ɼ
		/////////////////////////////////////////////////////////////////////////
	}

// 2010-04-20 by cmkwon, ű Ű ӽ  - (κ߰) - Լ ȣϴ  ϰ 
// 	// Send MSG
// 	INIT_MSG_OF_SIZE(MSG_FC_STORE_UPDATE_RARE_FIX, T_FC_STORE_UPDATE_RARE_FIX, pUpdateRareFix, pUpdateRareFixBuf);
// 	pUpdateRareFix->ItemUID			= io_pItem->UniqueNumber;
// 	pUpdateRareFix->PrefixCodeNum	= io_pItem->PrefixCodeNum;
// 	pUpdateRareFix->SuffixCodeNum	= io_pItem->SuffixCodeNum;
// 	SendAddData(pUpdateRareFixBuf, MSG_SIZE(MSG_FC_STORE_UPDATE_RARE_FIX));
// 
// 	// Update DB
// 	QPARAM_UPDATE_ITEM_RARE_FIX *pQParam = new QPARAM_UPDATE_ITEM_RARE_FIX;
// 	pQParam->ItemUID				= io_pItem->UniqueNumber;
// 	pQParam->PrefixCodeNum			= io_pItem->PrefixCodeNum;
// 	pQParam->SuffixCodeNum			= io_pItem->SuffixCodeNum;
// 	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateItemRareFix, this, m_character.AccountUniqueNumber, pQParam);
	return TRUE;

// 2007-12-07 by cmkwon,  ý  -   CFieldIOCP::GetRandomRareCode() Լ ó
//	// Prefix 
//	if (i_pGambleItemInfo->DestParameter1 == DES_RARE_FIX_PREFIX)
//	{
//		vector<RARE_ITEM_INFO* > *pRareFixVector = ms_pFieldIOCP->m_mapLevel2RareItemInfo.findEZ_ptr(min(CHARACTER_MAX_LEVEL, io_pItem->ItemInfo->ReqMinLevel));
//		
//		int			nRareTotalCnts	= 0;		// 2007-12-07 by cmkwon,  
//		Prob100K_t	nSumProb = 0;
//		// شǴ RareFix  Ȯ  
//		for (int i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (0 >= pRareItemInfo->Probability			// 2007-12-07 by cmkwon, 0    
//				|| IS_RARE_SUFFIX(pRareItemInfo->CodeNum)
//				|| FALSE == COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItem->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, nReqUseType)
//				)
//			{
//				continue;
//			}
//
//			nSumProb += pRareItemInfo->Probability;
//			nRareTotalCnts++;					// 2007-12-07 by cmkwon,  
//		}
//
//		int			nRareCurCnts	= 0;		// 2007-12-07 by cmkwon,  
//		// Ȯ  RareFix 
//		Prob100K_t prob = RANDI(0, nSumProb-1);
//		Prob100K_t nTempSumProb = 0;
//
//		for (i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (0 >= pRareItemInfo->Probability			// 2007-12-07 by cmkwon,  Ȯ 0   ó ȵǵ 
//				|| IS_RARE_SUFFIX(pRareItemInfo->CodeNum)
//				|| FALSE == COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItem->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, nReqUseType)
//				)
//			{
//				continue;
//			}
//
//			if (0 < nTempSumProb+pRareItemInfo->Probability			// 2007-12-07 by cmkwon,  Ȯ 0   ó ȵǵ 
//				&& IS_IN_RANGE(nTempSumProb, prob, nTempSumProb+pRareItemInfo->Probability))
//			{
//				// 2007-12-07 by cmkwon,  
//				char szLog[1024];
//				sprintf(szLog, "Prefix \'%15s\' Success: %4d <= %4d <= %4d, TotalPro(%5d) TotalRareCount(%d) CurCount(%d)\r\n",
//					pRareItemInfo->Name, nTempSumProb, prob, nTempSumProb+pRareItemInfo->Probability,
//					nSumProb, nRareTotalCnts, nRareCurCnts);
//				g_pFieldGlobal->WriteSystemLogEX(TRUE, szLog);
//				SendString128(STRING_128_ADMIN_CMD, szLog);
//				// RareItem 
//				io_pItem->PrefixCodeNum = pRareItemInfo->CodeNum;
//				break;
//			}
//
//			// 
//			nTempSumProb += pRareItemInfo->Probability;
//			nRareCurCnts++;		// 2007-12-07 by cmkwon,  
//		}
//
//		// Prefix  پ ,    ,  츦  α 
//		if (io_pItem->PrefixCodeNum == 0)
//		{
//			g_pFieldGlobal->WriteSystemLogEX(TRUE, "FATAL Error: No Prefix, %d %d %s %s %s\r\n",
//				(int)nTempSumProb, (int)prob,
//				GetCharacterString(&m_character, string()),
//				GetItemString(io_pItem, string()),
//				i_pGambleItemInfo->ItemName);
//		}
//	}
//
//	// Suffix 
//	if (i_pGambleItemInfo->DestParameter1 == DES_RARE_FIX_SUFFIX)
//	{
//		vector<RARE_ITEM_INFO* > *pRareFixVector = ms_pFieldIOCP->m_mapLevel2RareItemInfo.findEZ_ptr(min(CHARACTER_MAX_LEVEL, io_pItem->ItemInfo->ReqMinLevel));
//
//		int			nRareTotalCnts	= 0;		// 2007-12-07 by cmkwon,  
//		Prob100K_t	nSumProb = 0;
//
//		// شǴ RareFix  Ȯ  
//		for (int i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (0 >= pRareItemInfo->Probability			// 2007-12-07 by cmkwon,  Ȯ 0   ó ȵǵ 
//				|| IS_RARE_PREFIX(pRareItemInfo->CodeNum)
//				|| FALSE == COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItem->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, nReqUseType)
//				)
//			{
//				continue;
//			}
//
//			nSumProb += pRareItemInfo->Probability;
//			nRareTotalCnts++;					// 2007-12-07 by cmkwon,  
//		}
//
//		int			nRareCurCnts	= 0;		// 2007-12-07 by cmkwon,  
//		// Ȯ  RareFix 
//		Prob100K_t prob = RANDI(0, nSumProb-1);
//		Prob100K_t nTempSumProb = 0;
//
//		for (i = 0; i < pRareFixVector->size(); i++)
//		{
//			RARE_ITEM_INFO *pRareItemInfo = (*pRareFixVector)[i];
//
//			if (0 >= pRareItemInfo->Probability			// 2007-12-07 by cmkwon,  Ȯ 0   ó ȵǵ 
//				|| IS_RARE_PREFIX(pRareItemInfo->CodeNum)
//				|| FALSE == COMPARE_ITEMKIND(pRareItemInfo->ReqItemKind, io_pItem->Kind)
//				|| FALSE == COMPARE_BIT_FLAG(pRareItemInfo->ReqUseType, nReqUseType)
//				)
//			{
//				continue;
//			}
//
//			if (0 < nTempSumProb+pRareItemInfo->Probability			// 2006-04-20 by cmkwon, 0    
//				&& IS_IN_RANGE(nTempSumProb, prob, nTempSumProb+pRareItemInfo->Probability))
//			{
//				// 2007-12-07 by cmkwon,  
//				char szLog[1024];
//				sprintf(szLog, "Suffix \'%15s\' Success: %4d <= %4d <= %4d, TotalPro(%5d) TotalRareCount(%d) CurCount(%d)\r\n",
//					pRareItemInfo->Name, nTempSumProb, prob, nTempSumProb+pRareItemInfo->Probability,
//					nSumProb, nRareTotalCnts, nRareCurCnts);
//				g_pFieldGlobal->WriteSystemLogEX(TRUE, szLog);
//				SendString128(STRING_128_ADMIN_CMD, szLog);
//
//				// RareItem 
//				io_pItem->SuffixCodeNum = pRareItemInfo->CodeNum;
//				break;
//			}
//
//			// 
//			nTempSumProb += pRareItemInfo->Probability;
//			nRareCurCnts++;			// 2007-12-07 by cmkwon,  
//		}
//
//		// Suffix  پ ,    ,  츦  α 
//		if (io_pItem->SuffixCodeNum == 0)
//		{
//			g_pFieldGlobal->WriteSystemLogEX(TRUE, "FATAL Error: No Suffix, %d %d %s %s %s\r\n",
//				(int)nTempSumProb, (int)prob,
//				GetCharacterString(&m_character, string()),
//				GetItemString(io_pItem, string()),
//				i_pGambleItemInfo->ItemName);
//		}
//	}
//
//	// Send MSG
//	INIT_MSG_OF_SIZE(MSG_FC_STORE_UPDATE_RARE_FIX, T_FC_STORE_UPDATE_RARE_FIX, pUpdateRareFix, pUpdateRareFixBuf);
//	pUpdateRareFix->ItemUID			= io_pItem->UniqueNumber;
//	pUpdateRareFix->PrefixCodeNum	= io_pItem->PrefixCodeNum;
//	pUpdateRareFix->SuffixCodeNum	= io_pItem->SuffixCodeNum;
//	SendAddData(pUpdateRareFixBuf, MSG_SIZE(MSG_FC_STORE_UPDATE_RARE_FIX));
//
//	// Update DB
//	QPARAM_UPDATE_ITEM_RARE_FIX *pQParam = new QPARAM_UPDATE_ITEM_RARE_FIX;
//	pQParam->ItemUID				= io_pItem->UniqueNumber;
//	pQParam->PrefixCodeNum			= io_pItem->PrefixCodeNum;
//	pQParam->SuffixCodeNum			= io_pItem->SuffixCodeNum;
//	ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateItemRareFix, this, m_character.AccountUniqueNumber, pQParam);
//	return TRUE;
}

BOOL CFieldIOCPSocket::StopItemKindDecoy(ITEM *pItemDecoy)
{
	if (COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_DECOY_MASK))
	{
		ClearBodyConditionBit(m_character.BodyCondition, BODYCON_DECOY_MASK);

// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - Ʒ  
// 		UnsetParamFactor(m_ItemWingOut.DestParameter1, m_ItemWingOut.ParameterValue1);
// 		UnsetParamFactor(m_ItemWingOut.DestParameter2, m_ItemWingOut.ParameterValue2);
// 		UnsetParamFactor(m_ItemWingOut.DestParameter3, m_ItemWingOut.ParameterValue3);
// 		UnsetParamFactor(m_ItemWingOut.DestParameter4, m_ItemWingOut.ParameterValue4);
		for(int i=0; i < SIZE_MAX_DESPARAM_COUNT_IN_ITEM; i++)
		{
			UnsetParamFactor(m_ItemWingOut.ArrDestParameter[i], m_ItemWingOut.ArrParameterValue[i]);
		}

	}

	INIT_MSG_OF_SIZE(MSG_FC_BATTLE_TOGGLE_DECOY_OK, T_FC_BATTLE_TOGGLE_DECOY_OK, pToggleDecoy, pToggleDecoyBuf);
	pToggleDecoy->AttackIndex = m_character.ClientIndex;
	pToggleDecoy->IsOn = FALSE;
	if (pItemDecoy == NULL)
	{
		pToggleDecoy->ItemNum = 0;
	}
	else
	{
		pToggleDecoy->ItemNum = pItemDecoy->ItemNum;
	}

	SendInRangeMessageAroundMe(pToggleDecoyBuf, MSG_SIZE(MSG_FC_BATTLE_TOGGLE_DECOY_OK), TRUE);
#ifdef _DEBUG
	SendString128Static(STRING_128_ADMIN_CMD, STRMSG_S_F2NOTIFY_0135, pItemDecoy->ItemName);
#endif

	return TRUE;
}

BOOL CFieldIOCPSocket::StopItemKindShield(ITEM *pItemShield)
{
	ClearBodyConditionBit(m_character.BodyCondition, BODYCON_SHIELD_MASK);

	INIT_MSG_OF_SIZE(MSG_FC_BATTLE_TOGGLE_SHIELD_RESULT, T_FC_BATTLE_TOGGLE_SHIELD_RESULT,
						pToggleShield, pToggleShieldBuf);
	pToggleShield->AttackIndex = m_character.ClientIndex;
	pToggleShield->IsOn = FALSE;
	if (pItemShield == NULL)
	{
		pToggleShield->ItemNum = 0;
	}
	else
	{
		pToggleShield->ItemNum = pItemShield->ItemNum;
	}

	SendInRangeMessageAroundMe(pToggleShieldBuf, MSG_SIZE(MSG_FC_BATTLE_TOGGLE_SHIELD_RESULT), TRUE);

	return TRUE;
}

// 2007-12-04 by cmkwon,  ϱ ̺귯  - CashItemMoneyPay()  ߰, UID32_t i_giveTargetCharUID=0
// 2008-12-18 by cmkwon, Ϻ Arario ܺ,   ϱ -  ߰(, int i_nCurTotalMoney=0)
Err_t CFieldIOCPSocket::CashItemMoneyPay(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pGiftCard, ITEM *i_pItem/*=NULL*/, int itemPrice /*=0*/, int i_nTotalPrice/*=0*/, UID32_t i_giveTargetCharUID/*=0*/, int i_nCurTotalMoney/*=0*/)
{	
	*o_pTotalMoney	= 0;
	*o_pMCash		= 0;
	*o_pGiftCard	= 0;

	if(FALSE == g_pFieldGlobal->m_bCashShopServiceFlag
		&& FALSE == COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER))
	{// 2007-01-10 by cmkwon, ȭ   üũ - /ڴ  
		return ERR_CASH_CASH_SHOP_NO_SERVICE;	
	}

	if(g_pFieldGlobal->GetIsJamboreeServer())
	{// 2007-11-05 by cmkwon, ȸ  ȭ    Ұ -   
		return ERR_CASH_CASH_SHOP_NO_SERVICE;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2008-04-25 by cmkwon,  / ߰  ߰ Ǿ ϴ  - [-ʼ]  Լ ȣ

	// 2012-08-17 by jhseol,  BPSoft ý
#ifdef S_BPSOFTBILLING_JHSEOL
	return CashItem_BPSOFT(o_pTotalMoney, o_pMCash, o_pGiftCard, i_pItem);
#endif
	// end 2012-08-17 by jhseol,  BPSoft ý

#ifdef SERVICE_TYPE_VIETNAMESE_SERVER_1
	return CashItemVTCIntecomMoneyPay(o_pTotalMoney, o_pMCash, o_pGiftCard, i_pItem, i_nTotalPrice);
#else
#ifdef SHOP_PRICES_PER_BUILDING_NPC
	return CashItem_Wikigames(o_pTotalMoney, o_pMCash, o_pGiftCard, i_pItem, itemPrice, i_nTotalPrice, i_giveTargetCharUID);	// 2008-08-14 by cmkwon, ĳ Wikigames_Eng ϱ   - // 2008-08-07 by cmkwon, Wikigames_Eng   - 
#else
	return CashItem_Wikigames(o_pTotalMoney, o_pMCash, o_pGiftCard, i_pItem, i_nTotalPrice, i_giveTargetCharUID);
#endif
#endif // END - #ifdef SERVICE_TYPE_VIETNAMESE_SERVER_1

	return ERR_CASH_mgQueryMall_ERROR;

	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
// 2008-04-25 by cmkwon,  / ߰  ߰ Ǿ ϴ  - [-ʼ]  Լ 

#if defined(SERVICE_TYPE_VIETNAMESE_SERVER_1) 
///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::CashItemVTCIntecomMoneyPay(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pGiftCard, ITEM *i_pItem/*=NULL*/, int i_nTotalPrice/*=0*/)
/// \brief		
/// \author		cmkwon
/// \date		2006-06-07 ~ 2006-06-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
#ifdef SHOP_PRICES_PER_BUILDING_NPC
Err_t CFieldIOCPSocket::CashItemVTCIntecomMoneyPay(INT *o_pTotalMoney
	, INT *o_pMCash
	, INT *o_pGiftCard
	, ITEM *i_pItem/*=NULL*/
	, int itemPrice = 0
	, int i_nTotalPrice/*=0*/)
#else
Err_t CFieldIOCPSocket::CashItemVTCIntecomMoneyPay(INT *o_pTotalMoney
	, INT *o_pMCash
	, INT *o_pGiftCard
	, ITEM *i_pItem/*=NULL*/
	, int i_nTotalPrice/*=0*/)
#endif // SHOP_PRICES_PER_BUILDING_NPC
{
//#if defined(_DEBUG)
//	///////////////////////////////////////////////////////////////////////////////
//	// 2009-03-02 by cmkwon,  ׼ ĳ Ʈ  ( ø ) - Ʈ VTC-Intecom ó
//	if(g_pFieldGlobal->InMasangServer())
//	{
//		*o_pMCash		= 50000;																// CashPoint
//#ifdef SHOP_PRICES_PER_BUILDING_NPC
//		*o_pGiftCard	= *o_pMCash;															// BonusPoint
//#else
//		*o_pGiftCard	= (NULL == i_pItem) ? *o_pMCash : *o_pMCash - i_pItem->CashPrice;		// BonusPoint
//#endif // SHOP_PRICES_PER_BUILDING_NPC
//
//		
//		*o_pTotalMoney	= *o_pMCash + *o_pGiftCard;												// Total Cash
//		return ERR_NO_ERROR;
//	}
//#endif

	///////////////////////////////////////////////////////////////////////////////
	// 2009-06-25 by cmkwon, Ʈ VTC  ý  -
	SVTCBILL_REQ_DATA	tmBReq;		MEMSET_ZERO(&tmBReq, sizeof(tmBReq));
	SVTCBILL_RET_DATA	tmBRet;		MEMSET_ZERO(&tmBRet, sizeof(tmBRet));

	tmBReq.nCommand		= 1;		// ʱⰪ ܾ ȸ
	STRNCPY_MEMSET(tmBReq.szAccountName, GetCharacter()->AccountName, min(SIZE_MAX_ACCOUNT_NAME, VTCBILL_SIZE_MAX_ACCOUNT_NAME));
	STRNCPY_MEMSET(tmBReq.szCharacterName, GetCharacter()->CharacterName, min(SIZE_MAX_CHARACTER_NAME, VTCBILL_SIZE_MAX_CHARACTER_NAME));
	STRNCPY_MEMSET(tmBReq.szUserIP, GetPeerIP(), min(SIZE_MAX_IPADDRESS, VTCBILL_SIZE_MAX_IPADDRESS));

	if(i_pItem)
	{
		tmBReq.nCommand		= 2;		// ŷ 
		tmBReq.nItemNum		= i_pItem->ItemNum;
		// 2013-04-11 by jhseol, ĳ 1  n  ϴ ׼
		//tmBReq.nItemPrice	= i_pItem->CashPrice;
		tmBReq.nItemPrice	= i_nTotalPrice;	//  ݾ   ٲ۴

#ifdef SHOP_PRICES_PER_BUILDING_NPC
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "   [Check] CFieldIOCPSocket::Process_FC_SHOP_BUY_CASH_ITEM, CashItemVTCIntecomMoneyPay _ AUID(%d) CUID(%d) ItemNum(%d) [TotalPrice(%d) = ItemPrice(%d) * BuyAmount(%d)]\r\n"
			, m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, i_pItem->ItemNum, i_nTotalPrice, itemPrice, itemPrice > 0 ? i_nTotalPrice / itemPrice : -1);
#else
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "   [Check] CFieldIOCPSocket::Process_FC_SHOP_BUY_CASH_ITEM, CashItemVTCIntecomMoneyPay _ AUID(%d) CUID(%d) ItemNum(%d) [TotalPrice(%d) = ItemPrice(%d) * BuyAmount(%d)]\r\n"
			, m_character.AccountUniqueNumber, m_character.CharacterUniqueNumber, i_pItem->ItemNum, i_nTotalPrice, i_pItem->CashPrice, i_pItem->CashPrice > 0 ? i_nTotalPrice / i_pItem->CashPrice : -1);
#endif // SHOP_PRICES_PER_BUILDING_NPC

		
		// end 2013-04-11 by jhseol, ĳ 1  n  ϴ ׼
	}

	if(FALSE == CashItem_VTC_DirectConnect(&tmBReq, &tmBRet))
	{
		int nErr = ERR_CASH_NORMAL_ERROR;
		switch(tmBRet.nRetErrCode)
		{
		case VTCBILL_ERR_NOT_EXIST_ACCOUNTNAME:			nErr = ERR_CASH_mgQueryMall_RESULT_NO_ACCOUNT;		break;
		case VTCBILL_ERR_NOT_ENOUGH_MONEY:				nErr = ERR_CASH_mgQueryMall_RESULT_CANNOT_PAYMENT;	break;
		case VTCBILL_ERR_INVALID_ITEM_INFORMATION:		nErr = ERR_CASH_INVALID_ITEM_INFORMATION;			break;
		case VTCBILL_ERR_DB_TRANSACTION:				nErr = ERR_CASH_mgQueryMall_ERROR;					break;
		case VTCBILL_ERR_DB_CONNECT_FAIL:				nErr = ERR_CASH_mgQueryMall_ERROR;					break;
		case VTCBILL_ERR_DB_QUERY_ERROR:				nErr = ERR_CASH_mgQueryMall_ERROR;					break;
		case VTCBILL_ERR_DB_QUERY_FETCH_ERROR:			nErr = ERR_CASH_mgQueryMall_ERROR;					break;
		case VTCBILL_ERR_DB_INVALID_BILLING_COMMAND:	nErr = ERR_CASH_mgQueryMall_ERROR;					break;
		}

		return nErr;
	}

	*o_pMCash		= tmBRet.nCashPoint;			// CashPoint
	*o_pGiftCard	= tmBRet.nBonusPoint;			// BonusPoint
	*o_pTotalMoney	= *o_pMCash + *o_pGiftCard;		// Total Cash
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2009-06-25 by cmkwon, Ʈ VTC  ý  - 
/// \author		cmkwon
/// \date		2009-06-25 ~ 2009-06-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::CashItem_VTC_DirectConnect(SVTCBILL_REQ_DATA *i_pReqData, SVTCBILL_RET_DATA *o_pRetData)
{
	o_pRetData->nRetErrCode	= 0;
	o_pRetData->nCashPoint	= 0;
	o_pRetData->nBonusPoint	= 0;

	wchar_t wcAccName[VTCBILL_SIZE_MAX_ACCOUNT_NAME];
	MEMSET_ZERO(wcAccName, sizeof(wcAccName[0])*VTCBILL_SIZE_MAX_ACCOUNT_NAME);
	MultiByteToWideChar(CODE_PAGE, 0, i_pReqData->szAccountName, -1, wcAccName, VTCBILL_SIZE_MAX_ACCOUNT_NAME);

	wchar_t wcUserIP[VTCBILL_SIZE_MAX_IPADDRESS];
	MEMSET_ZERO(wcUserIP, sizeof(wcUserIP[0])*VTCBILL_SIZE_MAX_IPADDRESS);
	MultiByteToWideChar(CODE_PAGE, 0, i_pReqData->szUserIP, -1, wcUserIP, VTCBILL_SIZE_MAX_IPADDRESS);

	switch(i_pReqData->nCommand)
	{
	case 1:
	case 2:
		break;
	default:
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::CashItem_VTC_DirectConnect# command error !! Command(%d)\r\n", i_pReqData->nCommand);
			o_pRetData->nRetErrCode	= VTCBILL_ERR_DB_CONNECT_FAIL;
			return FALSE;
		}
	}

	CODBCStatement odbcStmt;
	BOOL bRet = odbcStmt.Init(g_pFieldGlobal->GetBillingDBServerIP(), g_pFieldGlobal->GetBillingDBServerPort(), g_pFieldGlobal->GetBillingDBServerDatabaseName(), g_pFieldGlobal->GetBillingDBServerUserID(), g_pFieldGlobal->GetBillingDBServerPassword(), g_pFieldGlobal->GetMainWndHandle());
	if (!bRet)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CFieldIOCPSocket::CashItem_VTC_DirectConnect# connect error !! DBServer(%s:%d) DatabaseName(%s) UID(%s) PWD(%s)\r\n"
			, g_pFieldGlobal->GetBillingDBServerIP(), g_pFieldGlobal->GetBillingDBServerPort(), g_pFieldGlobal->GetBillingDBServerDatabaseName(), g_pFieldGlobal->GetBillingDBServerUserID(), g_pFieldGlobal->GetBillingDBServerPassword());
		o_pRetData->nRetErrCode	= VTCBILL_ERR_DB_CONNECT_FAIL;
		return FALSE;
	}

	SQLHSTMT hstmt = odbcStmt.GetSTMTHandle();
	SQLINTEGER arrCB[9] = {SQL_NTS,SQL_NTS,SQL_NTS,SQL_NTS,SQL_NTS, SQL_NTS,SQL_NTS,SQL_NTS,SQL_NTS};
	// (1:ܾȸ, 2:۱)
	switch (i_pReqData->nCommand)
	{
	case 1:
		{
			int nReturn			= 0;
			int nResponseStatus = -1;
			SQLBindParameter(hstmt, 1, SQL_PARAM_OUTPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &nReturn, 0,											&arrCB[1]);	
			SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_WCHAR, SQL_WVARCHAR, VTCBILL_SIZE_MAX_ACCOUNT_NAME, 0, wcAccName, 0,				&arrCB[2]);
			SQLBindParameter(hstmt, 3, SQL_PARAM_OUTPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(nResponseStatus), 0,									&arrCB[3]);
			SQLBindParameter(hstmt, 4, SQL_PARAM_OUTPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(o_pRetData->nCashPoint), 0,							&arrCB[4]);

			// -- Get account's Vcoin values :
			// PROCEDURE  [dbo].[SP_Account_GetTotalVcoin] 
			//	@_AccountName       NVARCHAR (30),
			//	@_AccountID             INT OUTPUT,
			//	@_TotalVcoin            INT OUTPUT
			//	OUTPUT
			//	@_AccountID  
			//	--   > 0   :  Value of the AccountID (Successful)
			//	--   -1     :  Account not exist			
			bRet = odbcStmt.ExecuteQuery((char*)(PROCEDURE_090625_0348));
			if(FALSE == bRet)
			{
				odbcStmt.ProcessLogMessagesForStmt("[DB ERROR] ExecuteQuery(PROCEDURE_090625_0348@) Error !!\r\n");
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] BillingReqExecuteDirectConnect ExecuteQuery(PROCEDURE_090625_0348@) error !! %s \r\n"
					, GetCharacterString(GetCharacter(), string()));
				o_pRetData->nRetErrCode		= VTCBILL_ERR_DB_QUERY_ERROR;
				return FALSE;
			}

			while(TRUE)
			{
				SQLRETURN ret = SQLMoreResults(hstmt);
				if(ret!=SQL_SUCCESS && ret!=SQL_SUCCESS_WITH_INFO)
				{
					break;
				}
			}
			odbcStmt.FreeStatement();
			
			if(0 >= nResponseStatus)
			{
				if(-1 == nResponseStatus)
				{
					o_pRetData->nRetErrCode		= VTCBILL_ERR_NOT_EXIST_ACCOUNTNAME;
				}
				else
				{
					g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] BillingReqExecuteDirectConnect Fetch(PROCEDURE_090625_0348@) error !! %s ResponseStatus(%d)\r\n"
						, GetCharacterString(GetCharacter(), string()), nResponseStatus);
					o_pRetData->nRetErrCode		= VTCBILL_ERR_DB_QUERY_FETCH_ERROR;
				}
				return FALSE;
			}
		}
		break;
	case 2:
		{
			int nReturn			= 0;
			int nResponseStatus = -1;
			int nDiscountMoney	= 0;	//   óϴ 
			SQLBindParameter(hstmt, 1, SQL_PARAM_OUTPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &nReturn, 0,									&arrCB[1]);	
			SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_WCHAR, SQL_WVARCHAR, VTCBILL_SIZE_MAX_ACCOUNT_NAME, 0, wcAccName, 0,		&arrCB[2]);
			SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(i_pReqData->nItemNum), 0,						&arrCB[3]);
			SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(i_pReqData->nItemPrice), 0,					&arrCB[4]);
			SQLBindParameter(hstmt, 5, SQL_PARAM_INPUT, SQL_C_WCHAR, SQL_WVARCHAR, VTCBILL_SIZE_MAX_IPADDRESS, 0, wcUserIP, 0,			&arrCB[5]);
			SQLBindParameter(hstmt, 6, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(nDiscountMoney), 0,							&arrCB[6]);
			SQLBindParameter(hstmt, 7, SQL_PARAM_OUTPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(nResponseStatus), 0,							&arrCB[7]);
			SQLBindParameter(hstmt, 8, SQL_PARAM_OUTPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(o_pRetData->nCashPoint), 0,					&arrCB[8]);
		
			//--  Perform transactions :				  
			//PROCEDURE    [dbo].[SP_SCO_BuyItem] 
			//	@_AccountName		NVARCHAR(30),
			//	@_ItemID			INT,
			//	@_PriceMoney		INT,
			//	@_AccountIP			NVARCHAR(15),
			//	@_DiscountMoney		INT,
			//	@_ResponseStatus	INT OUTPUT,
			//	@_TotalVcoin		INT OUTPUT
			//	OUTPUT
			//	@_ ResponseStatus  
			//	--       0   : Successful Transaction
			//	--    -50   : Account not exist
			//	--    -51   : Vcoin not enough
			//	--    -52   : Item price invalid (ItemPrice <= 0)
			//	--    -99   : Error system transaction
			bRet = odbcStmt.ExecuteQuery((char*)(PROCEDURE_090625_0349));
			if(FALSE == bRet)
			{
				odbcStmt.ProcessLogMessagesForStmt("[DB ERROR] ExecuteQuery(PROCEDURE_090625_0349@) Error !!\r\n");
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] BillingReqExecuteDirectConnect ExecuteQuery(PROCEDURE_090625_0349@) error !! %s IP(%s) Item(%d, %d)\r\n"
					, GetCharacterString(GetCharacter(), string()), i_pReqData->szUserIP, i_pReqData->nItemNum, i_pReqData->nItemPrice);
				o_pRetData->nRetErrCode		= VTCBILL_ERR_DB_QUERY_ERROR;
				return FALSE;
			}
			
			while(TRUE)
			{
				SQLRETURN ret = SQLMoreResults(hstmt);
				if(ret!=SQL_SUCCESS && ret!=SQL_SUCCESS_WITH_INFO)
				{
					break;
				}
			}
			odbcStmt.FreeStatement();

			if(VTCBILL_ERR_SUCCESS != nResponseStatus)
			{
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] BillingReqExecuteDirectConnect Fetch(PROCEDURE_090625_0349@) error !! %s ResponseStatus(%d) \r\n"
					, GetCharacterString(GetCharacter(), string()), nResponseStatus);
				switch(nResponseStatus)
				{
				case VTCBILL_ERR_NOT_EXIST_ACCOUNTNAME:		o_pRetData->nRetErrCode		= VTCBILL_ERR_NOT_EXIST_ACCOUNTNAME;			return FALSE;
				case VTCBILL_ERR_NOT_ENOUGH_MONEY:			o_pRetData->nRetErrCode		= VTCBILL_ERR_NOT_ENOUGH_MONEY;					return FALSE;
				case VTCBILL_ERR_INVALID_ITEM_INFORMATION:	o_pRetData->nRetErrCode		= VTCBILL_ERR_INVALID_ITEM_INFORMATION;			return FALSE;
				case VTCBILL_ERR_DB_TRANSACTION:			o_pRetData->nRetErrCode		= VTCBILL_ERR_DB_TRANSACTION;					return FALSE;
				}
				o_pRetData->nRetErrCode		= VTCBILL_ERR_DB_QUERY_FETCH_ERROR;
				return FALSE;
			}
		}
		break;
	} // END - switch (i_pReqData->nCommand)

	return TRUE;
}

#else	// SERVICE_TYPE_VIETNAMESE_SERVER_1

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::CashItem_Wikigames(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pGiftCard, ITEM *i_pItem/*=NULL*/, int i_nTotalPrice/*=0*/, UID32_t i_giveTargetCharUID/*=0*/)
/// \brief		// 2008-08-07 by cmkwon, Wikigames_Eng   - 
/// \author		cmkwon
/// \date		2006-05-30 ~ 2006-05-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
#ifdef SHOP_PRICES_PER_BUILDING_NPC
Err_t CFieldIOCPSocket::CashItem_Wikigames(INT *o_pTotalMoney
	, INT *o_pMCash
	, INT *o_pGiftCard
	, ITEM *i_pItem/*=NULL*/
	, int itemPrice /*=0*/
	, int i_nTotalPrice/*=0*/
	, UID32_t i_giveTargetCharUID/*=0*/)
#else
Err_t CFieldIOCPSocket::CashItem_Wikigames(INT *o_pTotalMoney
	, INT *o_pMCash
	, INT *o_pGiftCard
	, ITEM *i_pItem/*=NULL*/
	, int i_nTotalPrice/*=0*/
	, UID32_t i_giveTargetCharUID/*=0*/)
#endif // SHOP_PRICES_PER_BUILDING_NPC
{
//#if defined(_DEBUG)
//	///////////////////////////////////////////////////////////////////////////////
//	// 2009-03-02 by cmkwon,  ׼ ĳ Ʈ  ( ø ) - ĳ Wikigames ó
//	if (g_pFieldGlobal->InMasangServer())
//	{
//		*o_pMCash = 50000;																// CashPoint
//#ifdef SHOP_PRICES_PER_BUILDING_NPC
//		*o_pGiftCard = *o_pMCash;		// BonusPoint
//#else
//		*o_pGiftCard = (NULL == i_pItem) ? *o_pMCash : *o_pMCash - i_pItem->CashPrice;		// BonusPoint
//#endif // SHOP_PRICES_PER_BUILDING_NPC
//		*o_pTotalMoney = *o_pMCash + *o_pGiftCard;												// Total Cash
//		return ERR_NO_ERROR;
//	}
//#endif

	SWIKIBILL_REQ_DATA	tmBReq;		MEMSET_ZERO(&tmBReq, sizeof(tmBReq));
	SWIKIBILL_RET_DATA	tmBRet;		MEMSET_ZERO(&tmBRet, sizeof(tmBRet));

	tmBReq.nCommand = 1;					// 2007-09-13 by cmkwon, ⺻ ܾȸ - // (1:ܾȸ, 2:۱)
	STRNCPY_MEMSET(tmBReq.szAccountName, m_character.AccountName, SIZE_MAX_ACCOUNT_NAME);
	STRNCPY_MEMSET(tmBReq.szCharacterName, m_character.CharacterName, SIZE_MAX_CHARACTER_NAME);
	STRNCPY_MEMSET(tmBReq.szUserIP, GetPeerIP(), SIZE_MAX_IPADDRESS);
	if (i_pItem)
	{// if buy item

		tmBReq.nCommand = 2;		// 2006-09-13 by cmkwon,  
		sprintf(tmBReq.szItemNum, "%d", i_pItem->ItemNum);
		STRNCPY_MEMSET(tmBReq.szItemName, i_pItem->ItemName, SIZE_MAX_ITEM_NAME);
		tmBReq.nBuyItemCount = 1;					//  īƮ
#ifdef SHOP_PRICES_PER_BUILDING_NPC
		tmBReq.nItemUnitPrice = itemPrice;
#else
		tmBReq.nItemUnitPrice = i_pItem->CashPrice;
#endif // SHOP_PRICES_PER_BUILDING_NPC

		///////////////////////////////////////////////////////////////////////////////
		// 2008-08-14 by cmkwon, ĳ Wikigames_Eng ϱ   - ޴  ϱ
		if (IS_VALID_UNIQUE_NUMBER(i_giveTargetCharUID))
		{
			tmBReq.nCommand = 3;	// 2008-08-14 by cmkwon, ĳ Wikigames_Eng ϱ   - (1:ܾȸ, 2:۱, 3:)
			STRNCPY_MEMSET(tmBReq.GiftAccountName, m_giveTargetCharacter.AccountName0, min(SIZE_MAX_ACCOUNT_NAME, WIKIBILL_SIZE_MAX_ACCOUNT_NAME));
			tmBReq.GiftAccountUID = m_giveTargetCharacter.AccountUID0;
			STRNCPY_MEMSET(tmBReq.GiftCharacterName, m_giveTargetCharacter.CharacterName0, min(SIZE_MAX_CHARACTER_NAME, WIKIBILL_SIZE_MAX_CHARACTER_NAME));
		}
	}

	int nRetCode = CashItem_Wikigames_DirectConnect(&tmBReq, &tmBRet);

	if (0 != nRetCode)
	{
		if (i_pItem)
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::CashItem_Wikigames CashItem_Wikigames_DirectConnect Error(%d), %s ItemInfo(%d:%s) TotalPrice(%d) RetCode(%d, %d)\r\n"
				, tmBRet.nRetErrCode, GetCharacterString(&m_character, string()), i_pItem->ItemNum, i_pItem->ItemName, i_nTotalPrice, nRetCode, tmBRet.nRetErrCode);
		}
		else
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CFieldIOCPSocket::CashItem_Wikigames CashItem_Wikigames_DirectConnect Error(%d), %s RetCode(%d, %d)\r\n"
				, tmBRet.nRetErrCode, GetCharacterString(&m_character, string()), nRetCode, tmBRet.nRetErrCode);
		}
		switch (tmBRet.nRetErrCode)
		{
		case WIKIBILL_ERR_DB_NO_ERROR:
			break;

		case WIKIBILL_ERR_DB_NOT_ENOUGH_MONEY:
			return ERR_CASH_mgQueryMall_RESULT_CANNOT_PAYMENT;

		case WIKIBILL_ERR_DB_IS_NOT_ACCOUNTNAME:
			return ERR_CASH_mgQueryMall_RESULT_NO_ACCOUNT;

		case WIKIBILL_ERR_DB_INVALID_ITEM:
			return ERR_CASH_INVALID_ITEM_INFORMATION;

		default:
		{
			return ERR_CASH_NORMAL_ERROR;
		}
		}
	}

	*o_pMCash = tmBRet.nCashPoint;					// RealCash
	*o_pGiftCard = tmBRet.nBonusPoint;					// BonusCash
	*o_pTotalMoney = *o_pMCash + *o_pGiftCard;				// Total Cash

	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			int CFieldIOCPSocket::CashItem_Wikigames_DirectConnect(SWIKIBILL_REQ_DATA *i_pReqData, SWIKIBILL_RET_DATA *o_pRetData)
/// \brief		// 2008-08-07 by cmkwon, Wikigames_Eng   - 
/// \author		cmkwon
/// \date		2008-08-07 ~ 2008-08-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
int CFieldIOCPSocket::CashItem_Wikigames_DirectConnect(SWIKIBILL_REQ_DATA *i_pReqData, SWIKIBILL_RET_DATA *o_pRetData)
{
	// 2008-07-30 by cmkwon, ʱȭ
	o_pRetData->nCashPoint = 0;
	o_pRetData->nBonusPoint = 0;
	o_pRetData->nRetErrCode = 0;

	// 2008-07-30 by cmkwon, Command üũ
	switch (i_pReqData->nCommand)
	{
	case 1:
	case 2:
	case 3:
		break;
	default:
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] CashItem_Wikigames_DirectConnect command error !! Command(%d)\r\n"
			, i_pReqData->nCommand);
		o_pRetData->nRetErrCode = WIKIBILL_ERR_DB_INVALID_BILLING_COMMAND;
		return TRUE;	// 2008-07-30 by cmkwon, ó 0,  1
	}
	}

	CODBCStatement odbcStmt;
	BOOL bRet = odbcStmt.Init(g_pFieldGlobal->GetBillingDBServerIP(), g_pFieldGlobal->GetBillingDBServerPort(), g_pFieldGlobal->GetBillingDBServerDatabaseName(), g_pFieldGlobal->GetBillingDBServerUserID(), g_pFieldGlobal->GetBillingDBServerPassword(), g_pFieldGlobal->GetMainWndHandle());
	if (!bRet)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CashItem_Wikigames_DirectConnect connect error !! DBServer(%s:%d) DatabaseName(%s) UID(%s) PWD(%s)\r\n"
			, g_pFieldGlobal->GetBillingDBServerIP(), g_pFieldGlobal->GetBillingDBServerPort(), g_pFieldGlobal->GetBillingDBServerDatabaseName(), g_pFieldGlobal->GetBillingDBServerUserID(), g_pFieldGlobal->GetBillingDBServerPassword());
		o_pRetData->nRetErrCode = WIKIBILL_ERR_DB_CONNECT_FAIL;
		return TRUE;	// 2008-07-30 by cmkwon, ó 0,  1
	}

	SQLHSTMT hstmt = odbcStmt.GetSTMTHandle();
	SQLINTEGER arrCB[15] = { SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS
		, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS };
	SQLRETURN ret = 0;
	int nRetVal = 1;	// Error · ʱȭ Ѵ.

	// (1:ܾȸ, 2:۱, 3:) // 2007-12-04 by cmkwon,  ϱ ̺귯  - 
	switch (i_pReqData->nCommand)
	{
	case 1:
	{
		SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_ACCOUNT_NAME, 0, i_pReqData->szAccountName, 0, &arrCB[1]);
		bRet = odbcStmt.ExecuteQuery((char*)(PROCEDURE_080822_0196));
		if (FALSE == bRet)
		{
			odbcStmt.ProcessLogMessagesForStmt("[DB Error] ExecuteQuery(Billing_Get_Point@) Error !!\r\n");
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CashItem_Wikigames_DirectConnect ExecuteQuery(Billing_Get_Point@) error !! User(%s|%s|%s)\r\n"
				, i_pReqData->szAccountName, i_pReqData->szCharacterName, i_pReqData->szUserIP);
			o_pRetData->nRetErrCode = WIKIBILL_ERR_DB_QUERY_ERROR;
			return TRUE;	// 2008-07-30 by cmkwon, ó 0,  1
		}
		arrCB[1] = arrCB[2] = arrCB[3] = SQL_NTS;
		SQLBindCol(hstmt, 1, SQL_C_LONG, &nRetVal, 0, &arrCB[1]);
		SQLBindCol(hstmt, 2, SQL_C_LONG, &o_pRetData->nCashPoint, 0, &arrCB[2]);
		SQLBindCol(hstmt, 3, SQL_C_LONG, &o_pRetData->nBonusPoint, 0, &arrCB[3]);

		SQLSMALLINT    nColCnts = 0;
		while (TRUE)
		{
			SQLNumResultCols(hstmt, &nColCnts);
			if (nColCnts <= 0)
			{// 2008-07-25 by cmkwon, ResultCols 0 ̸  RowCount ̴ 
				ret = SQLMoreResults(hstmt);
				if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
				{
					break;
				}
				continue;
			}
			ret = SQLFetch(hstmt);
			if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
			{
				ret = SQLMoreResults(hstmt);                 // 2008-07-25 by cmkwon,  Results  ִ ѹ üũѴ.
				if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
				{
					break;
				}
				continue;
			}
			///////////////////////////////////////////////////////////////////////////////
			// 2008-07-25 by cmkwon, Results set ó
		}
		odbcStmt.FreeStatement();

		///////////////////////////////////////////////////////////////////////////////
		// 0 ==> 
		// 1 ==> 			
		switch (nRetVal)
		{
		case 0:
		{
		}
		break;
		default:
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CashItem_Wikigames_DirectConnect Fetch(Billing_Get_Point@) error !! User(%s:%s|%s) RetVal(%d)\r\n"
				, i_pReqData->szAccountName, i_pReqData->szCharacterName, i_pReqData->szUserIP, nRetVal);
			o_pRetData->nRetErrCode = WIKIBILL_ERR_DB_QUERY_FETCH_ERROR;
			return TRUE;	// 2008-07-30 by cmkwon, ó 0,  1
		}
		}
	}
	break;
	case 2:
	{
		SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_ACCOUNT_NAME, 0, i_pReqData->szAccountName, 0, &arrCB[1]);
		SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_CHARACTER_NAME, 0, i_pReqData->szCharacterName, 0, &arrCB[2]);
		SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_ITEM_NUM, 0, i_pReqData->szItemNum, 0, &arrCB[3]);
		SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_ITEM_NAME, 0, i_pReqData->szItemName, 0, &arrCB[4]);
		SQLBindParameter(hstmt, 5, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(i_pReqData->nBuyItemCount), 0, &arrCB[5]);
		SQLBindParameter(hstmt, 6, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(i_pReqData->nItemUnitPrice), 0, &arrCB[6]);
		SQLBindParameter(hstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_IPADDRESS, 0, i_pReqData->szUserIP, 0, &arrCB[7]);

		bRet = odbcStmt.ExecuteQuery((char*)(PROCEDURE_080822_0197));
		if (FALSE == bRet)
		{
			odbcStmt.ProcessLogMessagesForStmt("[DB ERROR] ExecuteQuery(Billing_Buy_Item@) Error !!\r\n");
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CashItem_Wikigames_DirectConnect ExecuteQuery(Billing_Buy_Item@) error !! User(%s|%s|%s) Item(%s,%d)\r\n"
				, i_pReqData->szAccountName, i_pReqData->szCharacterName, i_pReqData->szUserIP, i_pReqData->szItemNum, i_pReqData->nBuyItemCount);
			o_pRetData->nRetErrCode = WIKIBILL_ERR_DB_QUERY_ERROR;
			return TRUE;	// 2008-07-30 by cmkwon, ó 0,  1
		}

		arrCB[1] = arrCB[2] = arrCB[3] = SQL_NTS;
		SQLBindCol(hstmt, 1, SQL_C_LONG, &nRetVal, 0, &arrCB[1]);
		SQLBindCol(hstmt, 2, SQL_C_LONG, &o_pRetData->nCashPoint, 0, &arrCB[2]);
		SQLBindCol(hstmt, 3, SQL_C_LONG, &o_pRetData->nBonusPoint, 0, &arrCB[3]);

		SQLSMALLINT    nColCnts = 0;
		while (TRUE)
		{
			SQLNumResultCols(hstmt, &nColCnts);
			if (nColCnts <= 0)
			{// 2008-07-25 by cmkwon, ResultCols 0 ̸  RowCount ̴ 
				ret = SQLMoreResults(hstmt);
				if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
				{
					break;
				}
				continue;
			}
			ret = SQLFetch(hstmt);
			if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
			{
				ret = SQLMoreResults(hstmt);                 // 2008-07-25 by cmkwon,  Results  ִ ѹ üũѴ.
				if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
				{
					break;
				}
				continue;
			}
			///////////////////////////////////////////////////////////////////////////////
			// 2008-07-25 by cmkwon, Results set ó
		}
		odbcStmt.FreeStatement();

		///////////////////////////////////////////////////////////////////////////////
		// 0 ==>  
		// 1 ==> ĳ  
		// 2 ==> Żǰ ġ 
		if (0 != nRetVal)
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CashItem_Wikigames_DirectConnect Fetch(Billing_Buy_Item@) error !! User(%s|%s|%s) RetVal(%d)\r\n"
				, i_pReqData->szAccountName, i_pReqData->szCharacterName, i_pReqData->szUserIP, nRetVal);
			o_pRetData->nRetErrCode = nRetVal;
			return TRUE;	// 2008-07-30 by cmkwon, ó 0,  1				
		}
	}
	break;
	case 3:
	{
		SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_ACCOUNT_NAME, 0, i_pReqData->szAccountName, 0, &arrCB[1]);
		SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_CHARACTER_NAME, 0, i_pReqData->szCharacterName, 0, &arrCB[2]);
		SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_ITEM_NUM, 0, i_pReqData->szItemNum, 0, &arrCB[3]);
		SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_ITEM_NAME, 0, i_pReqData->szItemName, 0, &arrCB[4]);
		SQLBindParameter(hstmt, 5, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(i_pReqData->nBuyItemCount), 0, &arrCB[5]);
		SQLBindParameter(hstmt, 6, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(i_pReqData->nItemUnitPrice), 0, &arrCB[6]);
		SQLBindParameter(hstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_IPADDRESS, 0, i_pReqData->szUserIP, 0, &arrCB[7]);
		SQLBindParameter(hstmt, 8, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &(i_pReqData->GiftAccountUID), 0, &arrCB[8]);
		SQLBindParameter(hstmt, 9, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_ACCOUNT_NAME, 0, i_pReqData->GiftAccountName, 0, &arrCB[9]);
		SQLBindParameter(hstmt, 10, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, WIKIBILL_SIZE_MAX_CHARACTER_NAME, 0, i_pReqData->GiftCharacterName, 0, &arrCB[10]);

		bRet = odbcStmt.ExecuteQuery((char*)(PROCEDURE_080822_0198));
		if (FALSE == bRet)
		{
			odbcStmt.ProcessLogMessagesForStmt("[DB ERROR] ExecuteQuery(Billing_Gift_Item@) Error !!\r\n");
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CashItem_Wikigames_DirectConnect ExecuteQuery(Billing_Gift_Item@) error !! User(%s|%s|%s) Item(%s,%d) GiftUser(%s:%d %s)\r\n"
				, i_pReqData->szAccountName, i_pReqData->szCharacterName, i_pReqData->szUserIP, i_pReqData->szItemNum, i_pReqData->nBuyItemCount
				, i_pReqData->GiftAccountName, i_pReqData->GiftAccountUID, i_pReqData->GiftCharacterName);
			o_pRetData->nRetErrCode = WIKIBILL_ERR_DB_QUERY_ERROR;
			return TRUE;	// 2008-07-30 by cmkwon, ó 0,  1
		}

		arrCB[1] = arrCB[2] = arrCB[3] = SQL_NTS;
		SQLBindCol(hstmt, 1, SQL_C_LONG, &nRetVal, 0, &arrCB[1]);
		SQLBindCol(hstmt, 2, SQL_C_LONG, &o_pRetData->nCashPoint, 0, &arrCB[2]);
		SQLBindCol(hstmt, 3, SQL_C_LONG, &o_pRetData->nBonusPoint, 0, &arrCB[3]);

		SQLSMALLINT    nColCnts = 0;
		while (TRUE)
		{
			SQLNumResultCols(hstmt, &nColCnts);
			if (nColCnts <= 0)
			{// 2008-07-25 by cmkwon, ResultCols 0 ̸  RowCount ̴ 
				ret = SQLMoreResults(hstmt);
				if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
				{
					break;
				}
				continue;
			}
			ret = SQLFetch(hstmt);
			if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
			{
				ret = SQLMoreResults(hstmt);                 // 2008-07-25 by cmkwon,  Results  ִ ѹ üũѴ.
				if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
				{
					break;
				}
				continue;
			}
			///////////////////////////////////////////////////////////////////////////////
			// 2008-07-25 by cmkwon, Results set ó
		}
		odbcStmt.FreeStatement();

		///////////////////////////////////////////////////////////////////////////////
		// 0 ==>  
		// 1 ==> ĳ  
		// 2 ==> Żǰ ġ 
		if (0 != nRetVal)
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CashItem_Wikigames_DirectConnect Fetch(Billing_Gift_Item@) error !! User(%s|%s|%s) GiftUser(%s:%d %s) RetVal(%d)\r\n"
				, i_pReqData->szAccountName, i_pReqData->szCharacterName, i_pReqData->szUserIP
				, i_pReqData->GiftAccountName, i_pReqData->GiftAccountUID, i_pReqData->GiftCharacterName, nRetVal);
			o_pRetData->nRetErrCode = nRetVal;
			return TRUE;	// 2008-07-30 by cmkwon, ó 0,  1				
		}
	}
	break;

	} // END - switch (i_pReqData->nCommand)

	return FALSE;	// 2008-07-30 by cmkwon, ó 0,  1
}
#endif		//#if defined(SERVICE_TYPE_VIETNAMESE_SERVER_1)

struct for_each_uprcase_at_string		// 2009-10-06 by cmkwon, Ʈ   X-TRAP  - 
{
	void operator()(string & i_op)
	{
		transform(i_op.begin(), i_op.end(), i_op.begin(), toupper);
	}
};


// 2012-08-17 by jhseol,  BPSoft ý
///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::CashItem_BPSOFT(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pFreeCash, UINT i_pItemCashPrice/*=0*/)
/// \brief		
/// \author		jhseol
/// \date		2012-08-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::CashItem_BPSOFT(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pFreeCash, ITEM *i_pItem/*=0*/)
{
	Err_t nRetedErr = GetCashPay_BPSOFT(o_pTotalMoney, o_pMCash, o_pFreeCash);

	if( ERR_NO_ERROR != nRetedErr )
	{
		return nRetedErr;
	}
	if( NULL == i_pItem )
	{
		return nRetedErr;
	}

	nRetedErr = BuyCashItem_BPSOFT(o_pTotalMoney, o_pMCash, o_pFreeCash, i_pItem);
	if( ERR_NO_ERROR != nRetedErr )
	{
		return nRetedErr;
	}
	return ERR_NO_ERROR;
}
// end 2012-08-17 by jhseol,  BPSoft ý

///////////////////////////////////////////////////////////////////////////////

BOOL CFieldIOCPSocket::ms_bUsingNProtect		= FALSE;		// 2009-03-09 by cmkwon, Ϻ Arario nProtect CS ϱ - 

///////////////////////////////////////////////////////////////////////////////
/// \fn			INT CFieldIOCPSocket::GetMaxBuyableDayOfMembership(void)
/// \brief		// 2007-10-01 by cmkwon,    ִ ϼ - 󺰷 ٸ
/// \author		cmkwon
/// \date		2007-10-01 ~ 2007-10-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
INT CFieldIOCPSocket::GetMaxBuyableDayOfMembership(void)
{
	// 2008-04-25 by cmkwon,  / ߰  ߰ Ǿ ϴ  - [-ʼ] ߰ ÿ    ִ ϼ

	switch(g_pFieldGlobal->GetLanguageType())
	{
	case LANGUAGE_TYPE_VIETNAMESE:	return TERM_MONTHLYPAY_MAX_BUY_ENABLE_DAY;	// 2007-10-01 by cmkwon, 180
	case LANGUAGE_TYPE_DEFAULT:		return 60;									// 2007-10-08 by cmkwon, 60
	case LANGUAGE_TYPE_ENGLISH:
		{
#if defined(SERVICE_TYPE_ENGLISH_SERVER_1)
			return 60;		// 2008-08-14 by cmkwon, ĳ Wikigames_Eng   ִ 2 
#endif
			return 730;									// 2008-04-03 by cmkwon, Gameforge4D  ִ ϼ(730=24)
		}
	}
	return TERM_MONTHLYPAY_MAX_BUY_ENABLE_DAY;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsChargeUser(void)
/// \brief		
/// \author		cmkwon
/// \date		2006-06-01 ~ 2006-06-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsChargeUser(void)
{
	switch(g_pFieldGlobal->GetLanguageType())
	{
	case LANGUAGE_TYPE_VIETNAMESE:
		{
			if(m_ItemManager.IsExistPremiumCard())
			{// 2006-06-01 by cmkwon, Ʈ ̾  üũѴ.
				return TRUE;
			}
		}
		break;
	default:
		{
			return TRUE;
		}
	}
	return FALSE;
}

BOOL CFieldIOCPSocket::IsValidGameUser(Experience_t *o_pExptMaxEXP/*=NULL*/
									   , Experience_t i_CurEXP/*=0.0f*/)
{
	///////////////////////////////////////////////////////////////////////////////
	// 2006-10-21 by cmkwon, Ʈ ѱ ϰ  
	return TRUE;


	if(IsChargeUser())
	{
		return TRUE;
	}

	switch(g_pFieldGlobal->GetLanguageType())
	{
	case LANGUAGE_TYPE_VIETNAMESE:
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2006-06-14 by cmkwon,   üũ
			ATUM_DATE_TIME tmaExpre = m_AccountRegisteredDate;
			tmaExpre.AddDateTime(0, 0, 7, 0, 0, 0);
			ATUM_DATE_TIME tmaCur(TRUE);
			if(tmaExpre < tmaCur)
			{
				return FALSE;
			}

			///////////////////////////////////////////////////////////////////////////////
			// 2006-06-14 by cmkwon, ġ üũ
			if(0.0f >= i_CurEXP)
			{
				i_CurEXP = m_character.Experience;
			}
			Experience_t tmExp = CAtumSJ::GetExperienceFromPercentage(99, 24);
			if(i_CurEXP >= tmExp)
			{
				if(o_pExptMaxEXP)
				{
					*o_pExptMaxEXP = tmExp;
				}
				return FALSE;
			}
		}
		break;
	}

	return TRUE;
}

// 2012-10-18 by jhseol, BPSoft   - (=WEB)DB   ѹ 
///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::GetWebAccountNum(char* i_szAccountName, UID32_t* o_WebAccountNumber, int* o_nErrNum)
/// \brief		BPSoft   - (=WEB)DB   ѹ 
/// \author		jhseol
/// \date		2012-10-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::GetWebAccountNum(char* i_szAccountName, UID32_t* o_WebAccountNumber, int* o_nErrNum)
{
#ifdef S_BPSOFTBILLING_JHSEOL
	CODBCStatement odbcStmt;
	char DBIP[SIZE_MAX_IPADDRESS];
	int DBPort = 9979;
	char DBName[20];
	char DBUserName[20];
	char DBPWD[20];
	STRNCPY_MEMSET(DBIP,		"192.168.4.14",		sizeof(DBIP));
	STRNCPY_MEMSET(DBName,		"masangsoftweb",	sizeof(DBName));
	STRNCPY_MEMSET(DBUserName,	"web_master",		sizeof(DBUserName));
	STRNCPY_MEMSET(DBPWD,		"dnpq34tjqltm()",	sizeof(DBPWD));
	BOOL bRet = odbcStmt.Init(DBIP, DBPort, DBName, DBUserName, DBPWD, g_pFieldGlobal->GetMainWndHandle());
	if (!bRet)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CFieldIOCPSocket::GetWebAccountNum, WEB DB DirectConnect# connect error !! DBServer(%s:%d)\r\n", DBIP, DBPort);
		*o_nErrNum = ERR_DB_CONNECT_FAIL;
		return;
	}
	
	SQLHSTMT hstmt = odbcStmt.GetSTMTHandle();
	SQLINTEGER arrCB[3] = {SQL_NTS,SQL_NTS,SQL_NTS};
	SQLRETURN ret = 0;
	
	SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, SIZE_MAX_ACCOUNT_NAME, 0, i_szAccountName, 0,	&arrCB[1]);
	bRet = odbcStmt.ExecuteQuery("{call dbo.usp_SELECT_HOMEPAGE_MEMBER_SERIAL(?)}");
	if(FALSE == bRet)
	{
		odbcStmt.ProcessLogMessagesForStmt("[DB Error] CFieldIOCPSocket::GetWebAccountNum ExecuteQuery(dbo.usp_SELECT_HOMEPAGE_MEMBER_SERIAL) Error !!\r\n");
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CFieldIOCPSocket::GetWebAccountNum, ExecuteQuery(dbo.usp_SELECT_HOMEPAGE_MEMBER_SERIAL) error !! User(%s)\r\n", i_szAccountName);
		*o_nErrNum = ERR_DB_QUERY_ERROR;
		return;
	}
	SQLBindCol(hstmt, 1, SQL_C_ULONG, o_WebAccountNumber, 0,		&arrCB[2]);
	
	ret = SQLFetch(hstmt);
	if(ret!=SQL_SUCCESS && ret!=SQL_SUCCESS_WITH_INFO)
	{
		odbcStmt.ProcessLogMessagesForStmt("[DB Error] CFieldIOCPSocket::GetWebAccountNum, SQLBindCol(Billing_Get_Point@) Error !!\r\n");
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CFieldIOCPSocket::GetWebAccountNum, SQLBindCol(Billing_Get_Point@) error !! User(%s)\r\n", i_szAccountName);
		*o_nErrNum = ERR_DB_QUERY_ERROR;
		return;
	}
	*o_nErrNum = ERR_NO_ERROR;
#endif
}
// end 2012-10-18 by jhseol, BPSoft   - (=WEB)DB   ѹ 

// 2012-08-17 by jhseol,  BPSoft ý
///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::GetCashPay_BPSOFT(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pFreeCash)
/// \brief		
/// \author		jhseol
/// \date		2012-08-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::GetCashPay_BPSOFT(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pFreeCash)
{
#ifdef S_BPSOFTBILLING_JHSEOL
	char UserNum[BUFFSIZE] = {NULL,};
	char UserID[BUFFSIZE] = {NULL,};
	// 2012-10-18 by jhseol, BPSoft   - (=WEB)DB   ѹ 
	UID32_t tmWebAccountNumber = 0;
	int ErrCode = ERR_NO_ERROR;
	GetWebAccountNum(m_character.AccountName, &tmWebAccountNumber, &ErrCode);
	if( ErrCode != ERR_NO_ERROR)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CFieldIOCPSocket::GetCashPay_BPSOFT, GetWebAccountNum() error !! User(%s) RetVal(%d)\r\n", m_character.AccountName, ErrCode);
		SendString128(STRING_128_USER_ERR, STRERR_ERROR_0046);
		return ERR_CASH_BPSOFT_METHOD_CALL;
	}
	itoa(tmWebAccountNumber, UserNum, 10);
	// end 2012-10-18 by jhseol, BPSoft   - (=WEB)DB   ѹ 
	memcpy(UserID, m_character.AccountName, BUFFSIZE);

#if defined(TEST140)
	memcpy(UserNum, BPSOFT_TEST_USER_NO, BUFFSIZE);
	memcpy(UserID, BPSOFT_TEST_USER_ID, BUFFSIZE);
#endif
	
	
	/********************************************************************************************/
	/*	ܾ ȸ								   */
	/*	Method :CashBalanceInfo() ȣ .					   */
	/********************************************************************************************/
	
	// 
	_variant_t	vsMembership_Cd, vsUser_no, vsUser_id, vsUser_name,vlCharge_cash, vlPay_cash, vlGift_cash, vlEvent_cash, vlYD_cash, vlTest_cash, vlTotal_cash,vsRetCode,vlRetValCom;
	
	char	szTemp[BUFFSIZE] = {0};
	WCHAR	*wTemp = (WCHAR *)szTemp;
	char	Buf[BUFFSIZE] = {0};
	//[IN] 
	// ڵ - (M:Mandatory)- μ ο  
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(BPSOFT_MEMBERSHIP_CODE, wTemp, strlen(BPSOFT_MEMBERSHIP_CODE) );
	vsMembership_Cd.vt = VT_BSTR; vsMembership_Cd.bstrVal= ::SysAllocString(wTemp);

	// ȣ - (M:Mandatory)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(UserNum, wTemp, strlen(UserNum) );
	vsUser_no.vt = VT_BSTR; vsUser_no.bstrVal= ::SysAllocString(wTemp);

	// ̵- (M:Mandatory)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(UserID, wTemp, strlen(UserID) );
	vsUser_id.vt = VT_BSTR; vsUser_id.bstrVal= ::SysAllocString(wTemp);
	
	
	//COM ̺귯 ʱȭ
	if  ( !(CoInitializeEx(NULL, COINIT_MULTITHREADED) == S_OK))
	{
		//ó
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::GetCashPay_BPSOFT (Load COM Library CoInitializeEx() FAILED)\r\n");
		SendString128(STRING_128_USER_ERR, STRERR_ERROR_0046);
		return ERR_CASH_BPSOFT_COM_LIBRARY_INIT;
	}
	
	try
	{
		//COM ü 
		CComPtr<ICartPurchaseCli>pICartPurchaseCli;
		HRESULT hr = pICartPurchaseCli.CoCreateInstance(OLESTR("BCARTPURCHASE_COM.CartPurchaseCli.1"));
		if  (FAILED(hr))
		{
			//ó
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::GetCashPay_BPSOFT (Creation ICartPurchaseCli Object FAILED)\r\n");
			SendString128(STRING_128_USER_ERR, STRERR_ERROR_0046);
			return ERR_CASH_BPSOFT_CREATION_OBJECK;
		}
		
		//Լ ȣ
		vlRetValCom = pICartPurchaseCli->CashBalanceInfo (&vsMembership_Cd, &vsUser_no, &vsUser_id, &vsUser_name,&vlCharge_cash, &vlPay_cash, &vlGift_cash, &vlEvent_cash, &vlYD_cash,&vlTest_cash, &vlTotal_cash);

		_variant_t callresult;
		memset(wTemp, 0x00, BUFFSIZE);	MTOW(BPSOFT_METHOD_CALL_NO_ERRER, wTemp, strlen(BPSOFT_METHOD_CALL_NO_ERRER) );
		callresult.vt = VT_BSTR; callresult.bstrVal = ::SysAllocString(wTemp);
		
		if( callresult != vlRetValCom )
		{
			::CoUninitialize();
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::BuyCashItem_BPSOFT (CashBalanceInfo Method Call FAILED)\r\n");
			SendString128(STRING_128_USER_ERR, STRERR_ERROR_0046);
			return ERR_CASH_BPSOFT_METHOD_CALL;
		}

		memset(szTemp, 0x00, BUFFSIZE); WTOM(vlRetValCom.lVal, szTemp);
		//
		if (atoi(szTemp) == 0)
		{
			// [OUT]   óѴ.
			*o_pMCash		= vlCharge_cash.lVal + vlYD_cash.lVal;
			*o_pFreeCash	= vlEvent_cash.lVal + vlTest_cash.lVal;
			*o_pTotalMoney	= *o_pMCash + *o_pFreeCash;
		}
		else
		{
			//  ó
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::GetCashPay_BPSOFT (CashBalanceInfo Method Call FAILED : szTemp[%s])\r\n", szTemp);
			SendString128(STRING_128_USER_ERR, STRERR_ERROR_0046);
			return ERR_CASH_BPSOFT_METHOD_CALL;
		}
	}
	catch (const _com_error& e)
	{
		::CoUninitialize();
		//ó
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::GetCashPay_BPSOFT (Exception ERROR Type.1)\r\n");
		SendString128(STRING_128_USER_ERR, STRERR_ERROR_0046);
		return ERR_CASH_BPSOFT_EXCEPTION;
	}
	catch (...)
	{
		CoUninitialize();
		//ó
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::GetCashPay_BPSOFT (Exception ERROR Type.2)\r\n");
		SendString128(STRING_128_USER_ERR, STRERR_ERROR_0046);
		return ERR_CASH_BPSOFT_EXCEPTION;
	}
	CoUninitialize();
#endif
	return ERR_NO_ERROR;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			Err_t CFieldIOCPSocket::BuyCashItem_BPSOFT(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pFreeCash, UINT i_pItemCashPrice);
/// \brief		
/// \author		jhseol
/// \date		2012-08-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
Err_t CFieldIOCPSocket::BuyCashItem_BPSOFT(INT *o_pTotalMoney, INT *o_pMCash, INT *o_pFreeCash, ITEM *i_pItem)
{
#ifdef S_BPSOFTBILLING_JHSEOL
	char UserNum[BUFFSIZE] = {NULL,};
	char UserID[BUFFSIZE] = {NULL,};
	char ItemNum[BUFFSIZE] = {NULL,};
	// 2012-10-18 by jhseol, BPSoft   - (=WEB)DB   ѹ 
	UID32_t tmWebAccountNumber = 0;
	int ErrCode = ERR_NO_ERROR;
	GetWebAccountNum(m_character.AccountName, &tmWebAccountNumber, &ErrCode);
	if( ErrCode != ERR_NO_ERROR)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[DB Error] CFieldIOCPSocket::BuyCashItem_BPSOFT, GetWebAccountNum() error !! User(%s) RetVal(%d)\r\n", m_character.AccountName, ErrCode);
		SendString128(STRING_128_USER_ERR, STRERR_ERROR_0046);
		return ERR_CASH_BPSOFT_METHOD_CALL;
	}
	itoa(tmWebAccountNumber, UserNum, 10);
	// end 2012-10-18 by jhseol, BPSoft   - (=WEB)DB   ѹ 
	memcpy(UserID, m_character.AccountName, BUFFSIZE);
	itoa(i_pItem->ItemNum, ItemNum, 10);

	
#if defined(TEST140)
	memcpy(UserNum, BPSOFT_TEST_USER_NO, BUFFSIZE);
	memcpy(UserID, BPSOFT_TEST_USER_ID, BUFFSIZE);
#endif

	/********************************************************************************************/
	/*	 ǰ 								   */
	/*	Method :PurchaseComplete() ȣ .					   */
	/********************************************************************************************/
	
	// 
	_variant_t	vsMembership_Cd, vsUser_no, vsUser_id,vlContentsNo,vlSiteNo,vsGoodsNo, vlGoodsCnt, vlPayAmt, vsUserIp, vsServerIp, vsFreeVar1, vsFreeVar2, vsFreeVar3, vsFreeVar4,
		vsBxaid,vlLimitAge,vlLimitAmt,vlLimitBuyAmt,vsRetCode,vlRetValCom;

	char	szTemp[BUFFSIZE] = {0};
	WCHAR	*wTemp = (WCHAR *)szTemp;
	char	Buf[BUFFSIZE] = {0};
	
	//[IN] 
	// ڵ - (M:Mandatory)- μ ο  
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(BPSOFT_MEMBERSHIP_CODE, wTemp, strlen(BPSOFT_MEMBERSHIP_CODE) );
	vsMembership_Cd.vt = VT_BSTR; vsMembership_Cd.bstrVal= ::SysAllocString(wTemp);
	
	// ȣ - (M:Mandatory)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(UserNum, wTemp, strlen(UserNum) );
	vsUser_no.vt = VT_BSTR; vsUser_no.bstrVal= ::SysAllocString(wTemp);
	
	// ̵- (M:Mandatory)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(UserID, wTemp, strlen(UserID) );
	vsUser_id.vt = VT_BSTR; vsUser_id.bstrVal= ::SysAllocString(wTemp);
	
	// ȣ-(M:Mandatory) - μ ο  
	vlContentsNo.vt = VT_I4;
	vlContentsNo.lVal = (LONG)BPSOFT_CINTENS_NO;
	
	//Ʈ ȣ-(M:Mandatory)- μ ο  
	vlSiteNo.vt = VT_I4;
	vlSiteNo.lVal = (LONG)BPSOFT_SITE_NO;
	
	//ǰ ȣ - (M:Mandatory)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(ItemNum, wTemp, strlen(ItemNum) );
	vsGoodsNo.vt = VT_BSTR; vsGoodsNo.bstrVal= ::SysAllocString(wTemp);
	
	//ǰ -(M:Mandatory)
	vlGoodsCnt.vt = VT_I4;
	vlGoodsCnt.lVal = (LONG)BPSOFT_ITEM_AMOUNT;
	
	//ǰ -(M:Mandatory)   ǰ  ԷѴ.
	vlPayAmt.vt = VT_I4;
	vlPayAmt.lVal = (LONG)i_pItem->CashPrice;
	
	// IP - (M:Mandatory)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(m_szPeerIP, wTemp, strlen(m_szPeerIP) );
	vsUserIp.vt = VT_BSTR; vsUserIp.bstrVal= ::SysAllocString(wTemp);
	
	char tmServerIP[SIZE_MAX_IPADDRESS];
	if( 10062 == g_pFieldGlobal->GetMGameServerID() )
	{
		STRNCPY_MEMSET(tmServerIP, "182.162.137.3", SIZE_MAX_IPADDRESS)
	}
	else if( 10067 == g_pFieldGlobal->GetMGameServerID() )
	{
		STRNCPY_MEMSET(tmServerIP, "182.162.137.4", SIZE_MAX_IPADDRESS)
	}
	// IP - (M:Mandatory)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW(tmServerIP, wTemp, strlen(tmServerIP) );
	vsServerIp.vt = VT_BSTR; vsServerIp.bstrVal= ::SysAllocString(wTemp);
	
	//ETC Param 1 - (O:Option)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW("ETC Param 1", wTemp, strlen("ETC Param 1") );
	vsFreeVar1.vt = VT_BSTR; vsFreeVar1.bstrVal = ::SysAllocString(wTemp);
	
	//ETC Param 2 - (O:Option)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW("ETC Param 2", wTemp, strlen("ETC Param 2") );
	vsFreeVar2.vt = VT_BSTR; vsFreeVar2.bstrVal = ::SysAllocString(wTemp);
	
	//ETC Param 3 - (O:Option)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW("ETC Param 3", wTemp, strlen("ETC Param 3") );
	vsFreeVar3.vt = VT_BSTR; vsFreeVar3.bstrVal = ::SysAllocString(wTemp);
	
	//ETC Param 4 - (O:Option)
	memset(wTemp, 0x00, BUFFSIZE);	MTOW("ETC Param 4", wTemp, strlen("ETC Param 4") );
	vsFreeVar4.vt = VT_BSTR; vsFreeVar4.bstrVal = ::SysAllocString(wTemp);
	
	//COM ̺귯 ʱȭ
	if  ( !(CoInitializeEx(NULL, COINIT_MULTITHREADED) == S_OK)) {
		//ó
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::BuyCashItem_BPSOFT (Load COM Library CoInitializeEx() FAILED)\r\n");
		SendString128(STRING_128_USER_ERR, STRERR_ERROR_0045);
		return ERR_CASH_BPSOFT_COM_LIBRARY_INIT;
	}
	
	try
	{
		//COM ü 
		CComPtr<ICartPurchaseCli>pICartPurchaseCli;
		HRESULT hr = pICartPurchaseCli.CoCreateInstance(OLESTR("BCARTPURCHASE_COM.CartPurchaseCli.1"));
		if  (FAILED(hr))
		{
			//ó
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::BuyCashItem_BPSOFT (Creation ICartPurchaseCli Object FAILED)\r\n");
			SendString128(STRING_128_USER_ERR, STRERR_ERROR_0045);
			return ERR_CASH_BPSOFT_CREATION_OBJECK;
		}
		
		//Լ ȣ
		vlRetValCom = pICartPurchaseCli ->PurchaseComplete (&vsMembership_Cd, &vsUser_no, &vsUser_id, &vlContentsNo, &vlSiteNo, &vsGoodsNo, &vlGoodsCnt, &vlPayAmt, &vsUserIp , &vsServerIp,  &vsFreeVar1, &vsFreeVar2, &vsFreeVar3, &vsFreeVar4, &vsBxaid, &vlLimitAge, &vlLimitAmt, &vlLimitBuyAmt);
		
		_variant_t callresult;
		memset(wTemp, 0x00, BUFFSIZE);	MTOW(BPSOFT_METHOD_CALL_NO_ERRER, wTemp, strlen(BPSOFT_METHOD_CALL_NO_ERRER) );
		callresult.vt = VT_BSTR; callresult.bstrVal = ::SysAllocString(wTemp);

		if( callresult != vlRetValCom )
		{
			::CoUninitialize();
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::BuyCashItem_BPSOFT (PurchaseComplete Method Call FAILED)\r\n");
			SendString128(STRING_128_USER_ERR, STRERR_ERROR_0045);
			return ERR_CASH_BPSOFT_METHOD_CALL;
		}
		
		// ó
		memset(szTemp, 0x00, BUFFSIZE); WTOM(vlRetValCom.bstrVal, szTemp);
		//
		if (atoi(szTemp) == 0)
		{
			// [OUT]   óѴ.
			// ֹ ȣ
			memset(szTemp, 0x00, BUFFSIZE); 
			WTOM(vsBxaid.bstrVal, szTemp);
			// 
			//" = vlLimitAge.lVal;
			//ѵ ݾ
			//"ѵ ݾ = vlLimitAmt.lVal;
			// ѵ ݾ 
			//" ѵ ݾ = vlLimitBuyAmt.lVal;
				
		}
		else
		{
			//  ó
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::BuyCashItem_BPSOFT (PurchaseComplete Method Call FAILED : szTemp[%s])\r\n", szTemp);
			SendString128(STRING_128_USER_ERR, STRERR_ERROR_0045);
			return ERR_CASH_BPSOFT_METHOD_CALL;
		}
	}
	catch (const _com_error& e)
	{
		::CoUninitialize();
		//ó
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::BuyCashItem_BPSOFT (Exception ERROR Type.1)\r\n");
		SendString128(STRING_128_USER_ERR, STRERR_ERROR_0045);
		return ERR_CASH_BPSOFT_EXCEPTION;
	}
	catch (...)
	{
		CoUninitialize();
		//ó
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [ERROR] CFieldIOCPSocket::BuyCashItem_BPSOFT (Exception ERROR Type.2)\r\n");
		SendString128(STRING_128_USER_ERR, STRERR_ERROR_0045);
		return ERR_CASH_BPSOFT_EXCEPTION;
	}
	
	::CoUninitialize();
	
	//  Ϸ  ܾ ȸ ٽѴ.
	g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [Notify] CFieldIOCPSocket::BuyCashItem_BPSOFT Success, Before the GetCashPay_BPSOFT Method Call (CUID:%d) (ItemNum:%d) (CashPrice:%d) (Amount:%d)\r\n"
		,m_character.CharacterUniqueNumber, i_pItem->ItemNum, i_pItem->CashPrice, BPSOFT_ITEM_AMOUNT);
	return GetCashPay_BPSOFT(o_pTotalMoney, o_pMCash, o_pFreeCash);
#endif
	return ERR_NO_ERROR;
}
// end 2012-08-17 by jhseol,  BPSoft ý


///////////////////////////////////////////////////////////////////////////////
/// \fn			ITEM *CFieldIOCPSocket::GetGiveKillMarkItemPtr2Killer(void)
/// \brief		
/// \author		cmkwon
/// \date		2006-02-09 ~ 2006-02-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
ITEM *CFieldIOCPSocket::GetGiveKillMarkItemPtr2Killer(void)
{
	return m_pGiveKillMarkItemPtr2Killer;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::ResetGiveKillMarkItemPtr2Killer(void)
/// \brief		
/// \author		cmkwon
/// \date		2006-02-09 ~ 2006-02-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::ResetGiveKillMarkItemPtr2Killer(void)
{
	m_pGiveKillMarkItemPtr2Killer = ms_pFieldIOCP->GetKillMarkItemPtr(m_character.InfluenceType, m_character.Level);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::GMQuestCompletion(int i_questIdx/*=-1*/)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-07 ~ 2005-12-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::GMQuestCompletion(int i_questIdx/*=-1*/)
{
	mt_auto_lock mtA(&this->m_mapQuest);

	if(-1 == i_questIdx)
	{// 2006-08-07 by cmkwon,   Ʈ ϷѴ.

		CFieldCharacterQuest *pFCharQuest = this->GetCharacterQuestInProgress();
		if(NULL == pFCharQuest)
		{// 2005-12-07 by cmkwon,  Ʈ 
			return FALSE;
		}

		return this->GMQuestCompletion(pFCharQuest->GetQuestInfo());
	}

	CQuest *pQuestInfo = ms_pFieldIOCP->GetQuestInfo(i_questIdx);
	if(NULL == pQuestInfo
		|| FALSE == COMPARE_INFLUENCE(m_character.InfluenceType, pQuestInfo->ReqInfluenceType))
	{// 2006-08-08 by cmkwon, ̼ ° ĳ  üũѴ.
		return FALSE;
	}

	if(QUEST_KIND_SCENARIO != pQuestInfo->QuestKind)
	{// 2006-08-08 by cmkwon, ó ̼ ƴϸ ã ̼Ǹ Ϸ ó
		return this->GMQuestCompletion(pQuestInfo);
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-08-08 by cmkwon, ó ̼  ش  ó ̼ ã ̼Ǳ  Ϸ óѴ.
	CQuest *pCurQuestInfo = ms_pFieldIOCP->GetFirstScenarioQuestInfoByInfluenceType(m_character.InfluenceType);
	if(NULL == pCurQuestInfo)
	{
		return FALSE;
	}

	for(; NULL != pCurQuestInfo && pCurQuestInfo->QuestIndex != pQuestInfo->NextQuestIndex; pCurQuestInfo = ms_pFieldIOCP->GetQuestInfo(pCurQuestInfo->NextQuestIndex))
	{
		if(FALSE == this->GMQuestCompletion(pCurQuestInfo))
		{
			break;
		}
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::GMQuestCompletion(CQuest *i_pQuestInfo)
/// \brief		
/// \author		cmkwon
/// \date		2006-08-07 ~ 2006-08-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::GMQuestCompletion(CQuest *i_pQuestInfo)
{
	// 2007-10-11 by cmkwon, üũ ߰
	if(FALSE == IsValidCharacter())
	{
		return FALSE;
	}

	if(QUEST_END_TYPE_SELECT_INFLUENCE == i_pQuestInfo->QuestEndType)
	{// 2005-12-07 by cmkwon, ¼ù̼ ڵ Ϸ Ұ
		return FALSE;
	}

	CFieldCharacterQuest *pFCharQuest = this->GetFieldCharacterQuestPtrByQuestIndex(i_pQuestInfo->QuestIndex);
	if(QUEST_TYPE_REPEATABLE == i_pQuestInfo->QuestType)
	{
		if(pFCharQuest)
		{
			// Ʈ Ѵ
			QPARAM_DELETE_QUEST *pQDeleteQuest		= new QPARAM_DELETE_QUEST;
			pQDeleteQuest->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
			pQDeleteQuest->QuestIndex				= i_pQuestInfo->QuestIndex;
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_DeleteQuest, this, m_character.AccountUniqueNumber, pQDeleteQuest);

			m_mapQuest.deleteLock(i_pQuestInfo->QuestIndex);
		}
	}
	else
	{
		if(NULL == pFCharQuest)
		{
			CharacterQuest *pQInsertQuest = new CharacterQuest;
			pQInsertQuest->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
			pQInsertQuest->QuestIndex				= i_pQuestInfo->QuestIndex;
			pQInsertQuest->QuestState				= QUEST_STATE_COMPLETED;
			pQInsertQuest->QuestParam1				= 0;
			pQInsertQuest->QuestTimeStamp.SetCurrentDateTime();
			pQInsertQuest->QuestPlayTimeStamp		= GetTotalPlayTimeInSeconds();

			m_mapQuest.insertNoLock(i_pQuestInfo->QuestIndex, CFieldCharacterQuest(pQInsertQuest, i_pQuestInfo));

			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_InsertQuest, this, m_character.AccountUniqueNumber, pQInsertQuest);
		}
		else
		{
			if(QUEST_STATE_COMPLETED == pFCharQuest->QuestState)
			{
				return TRUE;
			}

			pFCharQuest->QuestState					= QUEST_STATE_COMPLETED;

			QPARAM_UPDATE_QUEST *pQUpdateQuest		= new QPARAM_UPDATE_QUEST;
			pQUpdateQuest->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
			pQUpdateQuest->QuestIndex				= pFCharQuest->QuestIndex;
			pQUpdateQuest->QuestState				= pFCharQuest->QuestState;
			pQUpdateQuest->QuestProgressTimeInSecond	= this->GetTotalPlayTimeInSeconds() - pFCharQuest->QuestPlayTimeStamp;	// 2006-08-31 by cmkwon, Ʈ  ð 
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateQuestState, this, m_character.AccountUniqueNumber, pQUpdateQuest);
		}
	}

	///////////////////////////////////////////////////////////////////////////////
	// Ϸ Ʈ α׿ 
	CAtumLogSender::SendLogMessageQUESTCOMPLETION(this, i_pQuestInfo->QuestIndex);		// send log

	INIT_MSG_WITH_BUFFER(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT, T_FC_QUEST_REQUEST_SUCCESS_RESULT, pSuccessResult, pSuccessResultBuf);
	pSuccessResult->QuestIndex		= i_pQuestInfo->QuestIndex;
	pSuccessResult->IsSuccessful	= TRUE;
	SendAddData(pSuccessResultBuf, MSG_SIZE(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT));
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::GMQuestAdjustByInfluenceType(BYTE i_byInflTy)
/// \brief		
/// \author		cmkwon
/// \date		2006-08-08 ~ 2006-08-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::GMQuestAdjustByInfluenceType(BYTE i_byInflTy)
{
	mt_auto_lock mtA(&this->m_mapQuest);

	mtmapQuestIndex2FieldCharacterQuest::iterator itrQuest = m_mapQuest.begin();
	while (itrQuest != m_mapQuest.end())
	{
		CFieldCharacterQuest *pFCharacterQuest = &itrQuest->second;
		CQuest *pQuestInfo = pFCharacterQuest->GetQuestInfo();
		if (INFLUENCE_TYPE_NORMAL == i_byInflTy					// 2009-03-31 by cmkwon, ʱȭ ý  - ɾ Ϲݼ ϸ  Ʈ 
			|| FALSE == COMPARE_INFLUENCE(i_byInflTy, pQuestInfo->ReqInfluenceType))
		{
			INIT_MSG_WITH_BUFFER(MSG_FC_QUEST_DISCARD_QUEST_OK, T_FC_QUEST_DISCARD_QUEST_OK, pMsgDiscard, pMsgDiscardBuf);
			pMsgDiscard->QuestIndex		= pFCharacterQuest->QuestIndex;
			pMsgDiscard->IsDiscarded	= TRUE;
			SendAddData(pMsgDiscardBuf, MSG_SIZE(MSG_FC_QUEST_DISCARD_QUEST_OK));

			// Ʈ  - DB
			QPARAM_DELETE_QUEST *pQDeleteQuest		= new QPARAM_DELETE_QUEST;
			pQDeleteQuest->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
			pQDeleteQuest->QuestIndex				= pFCharacterQuest->QuestIndex;
			ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_DeleteQuest, this, m_character.AccountUniqueNumber, pQDeleteQuest);

			m_mapQuest.erase(itrQuest++);
			continue;
		}
		itrQuest++;
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CFieldCharacterQuest * CFieldIOCPSocket::GetFieldCharacterQuestPtrByQuestIndex(INT i_questIdx)
/// \brief		
/// \author		cmkwon
/// \date		2005-10-19 ~ 2005-10-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
CFieldCharacterQuest * CFieldIOCPSocket::GetFieldCharacterQuestPtrByQuestIndex(INT i_questIdx)
{
	return this->m_mapQuest.findNoLock_Ptr(i_questIdx);
}

Err_t CFieldIOCPSocket::CheckQuestStartRequirements(CQuest *pQuestInfo, MSG_FC_QUEST_REQUEST_START *i_pQuestStart, BOOL i_bProcessPartyMembers/*=TRUE*/)
{
	if (FALSE == (m_character.UnitKind & pQuestInfo->ReqUnitKind))
	{//   üũ
		return ERR_PROTOCOL_REQ_UNITKIND_NOT_MATCHED;
	}

	if(FALSE == COMPARE_INFLUENCE(pQuestInfo->ReqInfluenceType, m_character.InfluenceType))
	{
		return ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED;
	}

	if (!IS_IN_RANGE(pQuestInfo->ReqAttackPart.Min, m_character.TotalGearStat.AttackPart, pQuestInfo->ReqAttackPart.Max))
	{
		return ERR_PROTOCOL_REQ_ATTACK_PART_NOT_MATCHED;
	}

	if (!IS_IN_RANGE(pQuestInfo->ReqDefensePart.Min, m_character.TotalGearStat.DefensePart, pQuestInfo->ReqDefensePart.Max))
	{
		return ERR_PROTOCOL_REQ_DEFENSE_PART_NOT_MATCHED;
	}

	if (!IS_IN_RANGE(pQuestInfo->ReqFuelPart.Min, m_character.TotalGearStat.FuelPart, pQuestInfo->ReqFuelPart.Max))
	{
		return ERR_PROTOCOL_REQ_FUEL_PART_NOT_MATCHED;
	}

	if (!IS_IN_RANGE(pQuestInfo->ReqSoulPart.Min, m_character.TotalGearStat.SoulPart, pQuestInfo->ReqSoulPart.Max))
	{
		return ERR_PROTOCOL_REQ_SOUL_PART_NOT_MATCHED;
	}

	if (!IS_IN_RANGE(pQuestInfo->ReqShieldPart.Min, m_character.TotalGearStat.ShieldPart, pQuestInfo->ReqShieldPart.Max))
	{
		return ERR_PROTOCOL_REQ_SHIELD_PART_NOT_MATCHED;
	}

	if (!IS_IN_RANGE(pQuestInfo->ReqDodgePart.Min, m_character.TotalGearStat.DodgePart, pQuestInfo->ReqDodgePart.Max))
	{
		return ERR_PROTOCOL_REQ_DODGE_PART_NOT_MATCHED;
	}

	if (!IS_IN_RANGE(pQuestInfo->ReqLevel.Min, m_character.Level, pQuestInfo->ReqLevel.Max))	// ʿ䷹
	{
		return ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED;
	}

	if (pQuestInfo->ReqExperience > m_character.Experience)	// ʿ ġ
	{
		return ERR_PROTOCOL_REQ_EXPERIENCE_NOT_MATCHED;
	}

	int i = 0;

	// ʿ  Ȯ
	if(false == pQuestInfo->ReqItemVector.empty())
	{
		mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);
		for (i = 0; i < pQuestInfo->ReqItemVector.size(); i++)
		{
			ITEM_W_COUNT tmpItemWCount = pQuestInfo->ReqItemVector[i];

			// lock m_mapItemGeneral, @CheckQuestStartRequirements

			ITEM_BASE *pItem = m_ItemManager.GetFirstItemGeneralByItemNum(tmpItemWCount.ItemNum);
			if (pItem == NULL || (IS_GENERAL_ITEM(pItem->ItemInfo->Kind) && ((ITEM_GENERAL*)pItem)->CurrentCount < tmpItemWCount.Count))
			{
				return ERR_PROTOCOL_REQ_ITEM_NOT_MATCHED;
			}
		}
	}

	// ʿ quest Ȯ
	if(false == pQuestInfo->ReqQuestIndexVector.empty())
	{
		mt_auto_lock qLock(&m_mapQuest);
		for (i = 0; i < pQuestInfo->ReqQuestIndexVector.size(); i++)
		{
			CFieldCharacterQuest *pFCharQuest = m_mapQuest.findNoLock_Ptr(pQuestInfo->ReqQuestIndexVector[i]);
			if (NULL == pFCharQuest || pFCharQuest->QuestState != QUEST_STATE_COMPLETED)
			{
				return ERR_PROTOCOL_REQ_QUEST_NOT_MATCHED;
			}
		}
	}

	// ʿ  quest Ȯ
	if(false == pQuestInfo->ReqRecvQuestIndexVector.empty())
	{
		mt_auto_lock qLock(&m_mapQuest);
		for (i = 0; i < pQuestInfo->ReqRecvQuestIndexVector.size(); i++)
		{
			CFieldCharacterQuest *pFCharQuest = m_mapQuest.findNoLock_Ptr(pQuestInfo->ReqRecvQuestIndexVector[i]);
			if (NULL == pFCharQuest || pFCharQuest->QuestState != QUEST_STATE_IN_PROGRESS)
			{
				return ERR_PROTOCOL_REQ_QUEST_NOT_MATCHED;
			}
		}
	}

// 2005-09-27 by cmkwon, ԰  ۸ ϵ 
//	// ʿ  Ȯ
//	if (GetCurrentLoadagePercentage(pQuestInfo->StartPayItemWeight) > 1.0f)
//	{
//		return ERR_PROTOCOL_ITEM_OVER_WEIGHT;
//	}

	if(FALSE == pQuestInfo->ReqStartArea.IsPositionInArea(m_character.MapChannelIndex.MapIndex, i_pQuestStart->AVec3QuestPosition.z, i_pQuestStart->AVec3QuestPosition.z))
	{
		return ERR_PROTOCOL_REQ_MAP_AREA_NOT_MATCHED;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2006-03-21 by cmkwon, Ƽ̼ üũ
	if(i_bProcessPartyMembers
		&& pQuestInfo->IsPartyQuest())
	{
		CFieldParty *pFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
		if(NULL == pFParty)
		{// 2006-03-21 by cmkwon, Ƽ 
			return ERR_PROTOCOL_NO_SUCH_PARTY;
		}

// 2007-02-12 by cmkwon, Ʒ  
//		mt_auto_lock pmlock(&pFParty->m_ListPartyMember);
//		if(pQuestInfo->QuestPartyMembers > pFParty->m_FieldPartyInfo.nTotalPartyMember)
//		{// 2006-03-21 by cmkwon, Ƽ ϴ
//			return ERR_PROTOCOL_REQ_PARTYMEMBERS_NOT_MATCHED;
//		}
//// 2007-01-08 by cmkwon, dhkwon, ʿ   ó
////		if(10 <= pFParty->GetMaxMemberLevel() - pFParty->GetLowestMemberLevel())
////		{// 2006-03-21 by cmkwon, ְ   10̴̻
////			return ERR_PROTOCOL_REQ_PARTYMEMBERS_LEVEL_NOT_MATCHED;
////		}
//
//		if(pFParty->m_FieldPartyInfo.nTotalPartyMember != pFParty->GetMembersInSameMap(NULL, m_pCurrentFieldMapChannel))
//		{// 2006-03-21 by cmkwon, Ƽ    ʴ
//			return ERR_PROTOCOL_MAP_CHANNEL_NOT_MATCHED;
//		}
//
//		if(0 != pQuestInfo->StartMapIndex)
//		{
//			CFieldMapProject *pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pQuestInfo->StartMapIndex);
//			if (NULL == pFMPro)
//			{
//				return ERR_PROTOCOL_NO_SUCH_MAP_SERVED;
//			}
//
//			pmlock.auto_unlock_cancel();
//
//			if(FALSE == pFParty->CheckAllMemberEnableWarp(m_pCurrentFieldMapChannel, pFMPro->GetMapInfluenceType(), pFMPro->IsConflictAreaMap(), pFMPro->m_nQuestIndexForWarp))
//			{
//				return ERR_PROTOCOL_REQ_PARTYMEMBERS_SOMEONE_CANNOT_WARP;
//			}
//		}

		vectCFieldIOCPSocket tmFISockList;
		pFParty->GetAllMembers(&tmFISockList);

		if(pQuestInfo->QuestPartyMembers > tmFISockList.size())
		{// 2006-03-21 by cmkwon, Ƽ ϴ
			return ERR_PROTOCOL_REQ_PARTYMEMBERS_NOT_MATCHED;
		}

		if(FALSE == CFieldIOCPSocket::IsAllSameMap(this->GetCurrentFieldMapChannel(), &tmFISockList))
		{// 2007-02-12 by cmkwon, Ƽ    ʴ
			return ERR_PROTOCOL_MAP_CHANNEL_NOT_MATCHED;
		}

		if(0 != pQuestInfo->StartMapIndex)
		{
			CFieldMapProject *pFMPro = ms_pFieldIOCP->GetFieldMapProjectByMapIndex(pQuestInfo->StartMapIndex);
			if (NULL == pFMPro)
			{
				return ERR_PROTOCOL_NO_SUCH_MAP_SERVED;
			}

			if(FALSE == CFieldParty::CheckAllMemberEnableWarp(&tmFISockList, m_pCurrentFieldMapChannel, pFMPro->GetMapInfluenceType(), pFMPro->IsConflictAreaMap(), pFMPro->m_nQuestIndexForWarp))
			{
				return ERR_PROTOCOL_REQ_PARTYMEMBERS_SOMEONE_CANNOT_WARP;
			}
		}
	}

	if(pQuestInfo->IsCityWar)
	{//  Ʈ ̴

		CCityWar *pCityWar = ms_pFieldIOCP->m_cityWarManager.GetCityWarPtrByQuestIndex(pQuestInfo->QuestIndex);
		if(NULL == pCityWar)
		{
			return ERR_PROTOCOL_QUEST_INVALID_CITYWAR_QUEST_INDEX;
		}
		
		if(CITYWAR_STATE_STARTED == pCityWar->GetCityWarState())
		{			
			return ERR_PROTOCOL_QUEST_CANNOT_CITYWAR_QUEST;
		}
		
// 2008-07-24 by cmkwon, MySQL  (OUTPUT ) -  ʴ Լ, ּ ó .
//		if(FALSE == pCityWar->QP_CheckGuildAndGuildMaster(m_character.GuildUniqueNumber, m_character.CharacterUniqueNumber))
//		{//  ƴϴ
//			return ERR_PROTOCOL_REQ_NOT_GUILD_MASTER;
//		}
		
		if(IsExistQuestCityWar())
		{// ٸ  Ʈ Ѵ
			return ERR_PROTOCOL_QUEST_ALREADY_EXIST_CITYWAR;
		}
	}
		
	return ERR_NO_ERROR;
}

Err_t CFieldIOCPSocket::CheckQuestCompetionRequirements(CFieldCharacterQuest *i_pFCharQuest
														, MSG_FC_QUEST_REQUEST_SUCCESS *i_pQuestSuccess
														, MapIndex_t i_nMapIndex
														, INT i_nWarpTargetIndex
														, INT i_nAttMonster/*=0*/
														, BOOL i_bByUser/*=TRUE*/)
{
	CQuest *pQuestInfo = i_pFCharQuest->GetQuestInfo();
	if(NULL == pQuestInfo)
	{
		return ERR_PROTOCOL_NO_SUCH_QUEST_INFO;
	}

	if(QUEST_END_TYPE_SELECT_INFLUENCE == pQuestInfo->QuestEndType)
	{//   ̼ǽ üũ
		if(this->m_pFieldParty)
		{// 2005-12-06 by cmkwon, Ƽ¿ Ұ
			return ERR_PROTOCOL_DOING_PARTY_BATTLE;
		}

		if(FALSE == COMPARE_INFLUENCE(i_pQuestSuccess->QuestResult, this->GetSelectableInfluenceMask()))
		{// 2005-12-07 by cmkwon, ϳ  ϳ ¸  ϴ
			if(FALSE == COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER))
			{// 2005-12-08 by cmkwon,  Ȥ ڰ ƴϸ  Ѵ.
				return ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED;
			}
		}

		///////////////////////////////////////////////////////////////////////////////
		// 2009-03-31 by cmkwon, ʱȭ ý  - CFieldIOCPSocket::CheckQuestCompetionRequirements(), μ Ʈ   ִ üũ Ѵ.
		if(FALSE == ms_pFieldIOCP->m_QuestMatching.IsEnableSelectInfluence(this))
		{
			return ERR_PROTOCOL_QUEST_NEVER_COMPLITION_BY_USER;
		}

		// 2009-03-31 by cmkwon, ʱȭ ý  -  ó ϴ  ϰ   üũ
		if(m_character.SelectableInfluenceMask != i_pQuestSuccess->QuestResult
// 2009-09-16 by cmkwon,  ʱȭ ¡   - Ʒ  Լ , Level  ߰
//			&& FALSE == ms_pFieldIOCP->IsEnableSelectInfluence(i_pQuestSuccess->QuestResult))
			&& FALSE == ms_pFieldIOCP->IsSelectableInfluence(i_pQuestSuccess->QuestResult, m_character.Level))
		{
			return ERR_CANNOT_CHOOSE_INFLUENCE_TYPE;
		}
	}


	if(pQuestInfo->IsNeverCompletionByUser
		&& i_bByUser)
	{//  ؼ ϷҰϴ

		return ERR_PROTOCOL_QUEST_NEVER_COMPLITION_BY_USER;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2005-07-13 by cmkwon
	// ̼ Ϸ  üũϱ   ̼  ŸԿ  üũ Ѵ.
	switch(pQuestInfo->QuestEndType)
	{
	case QUEST_END_TYPE_LEVEL_UP:
		{
			if(m_character.Level <= i_pFCharQuest->QuestParam1)
			{
				return ERR_PROTOCOL_QUEST_NO_LEVEL_UP;
			}
		}
		return ERR_NO_ERROR;
	case QUEST_END_TYPE_TIME_OVER:
		{
			if(i_pQuestSuccess->SpentTimeInSeconds < pQuestInfo->TimeLimitInMinutes * 60)
			{
				return ERR_PROTOCOL_TIME_LIMIT_ERROR;
			}
		}
		return ERR_NO_ERROR;
	}

	// 2005-07-15 by cmkwon, ʿ , NPC  ʰ ذ ϰ ȹ
	// 2005-08-22 by cmkwon, ٽ ߰
	if (pQuestInfo->TargetMeetNPCInfo.NPCIndex != 0)
	{
		if (m_pCurrentBuildingNPC == NULL)
		{
			SendErrorMessage(T_FIELD_IOCP, ERR_PROTOCOL_QUEST_GENERAL_ERROR);
			SendString128(STRING_128_USER_ERR, STRMSG_S_F2NOTIFY_0136);
			return ERR_PROTOCOL_QUEST_GENERAL_ERROR;
		}

		if (pQuestInfo->TargetMeetNPCInfo.NPCIndex != m_pCurrentBuildingNPC->NPCIndex)
		{
			return ERR_PROTOCOL_QUEST_GENERAL_ERROR;
		}
	}

	///////////////////////////////////////////////////////////////////////////////
	// 2007-04-02 by cmkwon,  Ϸ  üũ ̼ ߰ Ʒ  
	// TargetMixItemTarget 0 ƴϸ  TargetMixItemTarget ִٸ ʿ üũ ʿ Ϸᰡ
	// TargetMixItemTarget 0̸   ʿ  üũѴ.
	if(0 != pQuestInfo->TargetMixItemTarget.ItemNum)
	{
		///////////////////////////////////////////////////////////////////////////////
		// 2007-04-02 by cmkwon,   ʿ  īͺ  ƴҼ ִ.  īͺ  1 ϴ.
		ITEM_GENERAL *pItemG = m_ItemManager.GetFirstItemGeneralByItemNum(pQuestInfo->TargetMixItemTarget.ItemNum);
		if (NULL == pItemG)
		{
			return ERR_PROTOCOL_REQ_MIX_ITEM_NOT_MATCHED;
		}

		if(IS_COUNTABLE_ITEM(pItemG->ItemInfo->Kind)
			&& pItemG->CurrentCount < pQuestInfo->TargetMixItemTarget.Count)
		{// 2007-04-02 by cmkwon, īͺ   üũ
			return ERR_PROTOCOL_REQ_MIX_ITEM_NOT_MATCHED;
		}
	}
	else
	{
		///////////////////////////////////////////////////////////////////////////////
		// 2007-04-02 by cmkwon, ̼ Ϸῡ ʿ   īͺ ̴
		
		// ʿ   Ȯ
		for (int j = 0; j < pQuestInfo->TargetMonsterItemVector.size(); j++)
		{
			if (0 >= pQuestInfo->TargetMonsterItemVector[j].ItemWithCount.ItemNum)
			{// 2007-03-16 by cmkwon, ItemNum ȿ 
				continue;
			}
		
			ITEM_GENERAL *pTargetMonsterItem = m_ItemManager.GetFirstItemGeneralByItemNum(pQuestInfo->TargetMonsterItemVector[j].ItemWithCount.ItemNum);

			// Count 0̸   ʾƵ Ǵ 
			if (0 >= pQuestInfo->TargetMonsterItemVector[j].ItemWithCount.Count)
			{// 2007-03-16 by cmkwon, Count 0̸ üũ ʾƵ 
				continue;
			}

			// ش    
			if (pTargetMonsterItem == NULL)
			{
				return ERR_PROTOCOL_QUEST_GENERAL_ERROR;
			}

			// ش    
			if (IS_COUNTABLE_ITEM(pTargetMonsterItem->ItemInfo->Kind)
				&& pTargetMonsterItem->CurrentCount < pQuestInfo->TargetMonsterItemVector[j].ItemWithCount.Count)
			{
				return ERR_PROTOCOL_QUEST_GENERAL_ERROR;
			}
		}

		// ʿ  Ȯ
		for (int i = 0; i < pQuestInfo->TargetItemVector.size(); i++)
		{
			ITEM_W_COUNT tmpItemWCount = pQuestInfo->TargetItemVector[i];

			ITEM_BASE *pItem = m_ItemManager.GetFirstItemGeneralByItemNum(tmpItemWCount.ItemNum);
			if (pItem == NULL || (IS_GENERAL_ITEM(pItem->ItemInfo->Kind) && ((ITEM_GENERAL*)pItem)->CurrentCount < tmpItemWCount.Count))
			{
				return ERR_PROTOCOL_REQ_ITEM_NOT_MATCHED;
			}
		}
	}

	// 2005-10-19 by cmkwon, ʿ  īƮ Ȯ
	for (int i = 0; i < pQuestInfo->TargetMonsterVector.size(); i++)
	{
		MONSTER_W_COUNT tmpMonWCount = pQuestInfo->TargetMonsterVector[i];

		if(0 >= tmpMonWCount.Count)
		{// 2007-03-14 by cmkwon,  īƮ 0 ̸ üũ ʿ 
			continue;
		}

		CharacterQuestMonsterCount *pMonCount = i_pFCharQuest->FindMonsterCountByMonsterUniqueNumber(tmpMonWCount.MonsterUniqueNumber);

		if(NULL == pMonCount
			|| pMonCount->Count < tmpMonWCount.Count)
		{
			return ERR_PROTOCOL_REQ_MONSTER_NOT_MATCHED;
		}
	}

// 2005-09-27 by cmkwon, ԰  ۸ ϵ 
//	// ʿ  Ȯ
//	if (GetCurrentLoadagePercentage(pQuestInfo->EndPayItemWeight) > 1.0f)
//	{
//		return ERR_PROTOCOL_ITEM_OVER_WEIGHT;
//	}

	// ð  Ȯ
	if (pQuestInfo->TimeLimitInMinutes != 0
//		&& pCharacterQuest->QuestTimeStamp.GetTimeDiffToCurrentTimeInSeconds() > pQuestInfo->TimeLimitInMinutes*60
//		&& GetTotalPlayTimeInSeconds() - pCharacterQuest->QuestPlayTimeStamp > pQuestInfo->TimeLimitInMinutes*60
		&& i_pQuestSuccess->SpentTimeInSeconds > pQuestInfo->TimeLimitInMinutes * 60
	)
	{
		return ERR_PROTOCOL_TIME_LIMIT_ERROR;
	}

	if(0 != pQuestInfo->TargetMeetObjectMapArea.MapIndex)
	{
		if(pQuestInfo->TargetMeetObjectMapArea.MapIndex != i_nMapIndex
			|| pQuestInfo->TargetMeetObjectIndex != i_nWarpTargetIndex)
		{
			return ERR_PROTOCOL_REQ_MAP_OBJECT_NOT_MATCHED;
		}
	}

	if(0 != pQuestInfo->TargetDeadByMonsterUniquenumber)
	{
		if(pQuestInfo->TargetDeadByMonsterUniquenumber != i_nAttMonster)
		{
			return ERR_PROTOCOL_QUEST_GENERAL_ERROR;
		}
	}

	if(FALSE == pQuestInfo->TargetMeetMapArea.IsPositionInArea(m_character.MapChannelIndex.MapIndex, i_pQuestSuccess->AVec3QuestPosition.x, i_pQuestSuccess->AVec3QuestPosition.z))
	{
		return ERR_PROTOCOL_REQ_MAP_AREA_NOT_MATCHED;
	}

	if(pQuestInfo->IsPartyQuest()
		&& NULL == m_pFieldParty)
	{// 2006-03-24 by cmkwon, ƼƮ Ϸ Ƽ ¿ 
		return ERR_PROTOCOL_NO_SUCH_PARTY;
	}

	return ERR_NO_ERROR;
}

ProcessResult CFieldIOCPSocket::CheckQuestRequestSuccessAndSendResult(CFieldCharacterQuest *i_pFCharQuest
																	  , MSG_FC_QUEST_REQUEST_SUCCESS *i_pQuestSuccess
																	  , BOOL i_bSendErrorMessage/*=TRUE*/
																	  , MapIndex_t i_nMapIndex/*=0*/
																	  , INT i_nWarpTargetIndex/*=0*/
																	  , INT i_nAttMonster/*=0*/
																	  , BOOL i_bOnlyCompletionCheck/*=FALSE*/)
{
	CQuest *pQuestInfo = i_pFCharQuest->GetQuestInfo();		// Ʈ Ǿ Ǿ Ѵ.
	if(NULL == pQuestInfo)
	{
		SendErrorMessage(T_FC_QUEST_REQUEST_SUCCESS, ERR_PROTOCOL_NO_SUCH_QUEST_INFO, i_pFCharQuest->QuestIndex);
		return RES_BREAK;
	}

	Err_t errQuestCompletion = CheckQuestCompetionRequirements(i_pFCharQuest, i_pQuestSuccess, i_nMapIndex, i_nWarpTargetIndex, i_nAttMonster);
	if (errQuestCompletion != ERR_NO_ERROR)
	{// Ʈ Ϸ  Ҹ 

		if(i_bSendErrorMessage
			&& FALSE == i_bOnlyCompletionCheck)
		{
			// client ش Ʈ NPC_QUEST_TALK_IN_PROGRESS  ָ ȴ. NPC_QUEST_TALK_IN_PROGRESS   ƹ͵  ʿ .
			INIT_MSG_WITH_BUFFER(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT, T_FC_QUEST_REQUEST_SUCCESS_RESULT, pSuccessResult, pSuccessResultBuf);
			pSuccessResult->QuestIndex		= i_pFCharQuest->QuestIndex;
			pSuccessResult->IsSuccessful	= FALSE;
			SendAddData(pSuccessResultBuf, MSG_SIZE(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT));

			// check: ʿ  .  . 20040220, kelovon
			SendErrorMessage(T_FC_QUEST_REQUEST_SUCCESS, errQuestCompletion, i_pFCharQuest->QuestIndex, this->GetSelectableInfluenceMask());
		}
		return RES_BREAK;
	}

	if(i_bOnlyCompletionCheck)
	{// 2006-03-24 by cmkwon, ƼƮ Ϸ üũ 
		return RES_RETURN_TRUE;
	}
	
	// Ʈ Ϸ   üũ
	int nExpOfCompensation = 0;		// 2007-03-06 by cmkwon, ߰

	// 2007-07-09 by dhjin, Ʈ Ϸ   ߰Ͽ .
	INIT_MSG_WITH_BUFFER(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT, T_FC_QUEST_REQUEST_SUCCESS_RESULT, pSuccessResult, pSuccessResultBuf);
	if (FALSE == ProcessQuestResult(&nExpOfCompensation, i_pFCharQuest->GetQuestInfo(), i_pQuestSuccess->QuestResult, pSuccessResult
									, (QUEST_PAY_ITEM_INFO*)(pSuccessResultBuf+MSG_SIZE(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT))))
	{
		if(i_bSendErrorMessage)
		{
			SendErrorMessage(T_FC_QUEST_REQUEST_SUCCESS, ERR_PROTOCOL_QUEST_RESULT_PROCESS_FAILED);
		}
		return RES_BREAK;
	}

	if (pQuestInfo->QuestType == QUEST_TYPE_REPEATABLE)
	{
		// Ʈ Ѵ
		QPARAM_DELETE_QUEST *pQDeleteQuest		= new QPARAM_DELETE_QUEST;
		pQDeleteQuest->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
		pQDeleteQuest->QuestIndex				= i_pFCharQuest->QuestIndex;
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_DeleteQuest, this, m_character.AccountUniqueNumber, pQDeleteQuest);

		m_mapQuest.deleteLock(i_pFCharQuest->QuestIndex);
	}
	else
	{
		// Update Field
		i_pFCharQuest->QuestState				= QUEST_STATE_COMPLETED;

		// Update DB
		QPARAM_UPDATE_QUEST *pQUpdateQuest		= new QPARAM_UPDATE_QUEST;
		pQUpdateQuest->CharacterUniqueNumber	= m_character.CharacterUniqueNumber;
		pQUpdateQuest->QuestIndex				= i_pFCharQuest->QuestIndex;
		pQUpdateQuest->QuestState				= i_pFCharQuest->QuestState;
		pQUpdateQuest->QuestProgressTimeInSecond	= this->GetTotalPlayTimeInSeconds() - i_pFCharQuest->QuestPlayTimeStamp;	// 2006-08-31 by cmkwon, Ʈ  ð 
		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_UpdateQuestState, this, m_character.AccountUniqueNumber, pQUpdateQuest);
	}
	
	///////////////////////////////////////////////////////////////////////////////
	// Ϸ Ʈ α׿ 
	CAtumLogSender::SendLogMessageQUESTCOMPLETION(this, pQuestInfo->QuestIndex);		// send log

	pSuccessResult->QuestIndex				= pQuestInfo->QuestIndex;
	pSuccessResult->IsSuccessful			= TRUE;
	pSuccessResult->ExpOfCompensation		= nExpOfCompensation;		// 2007-03-06 by cmkwon
	SendAddData(pSuccessResultBuf, MSG_SIZE(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT)+pSuccessResult->QuestPayInfoListCount*sizeof(QUEST_PAY_ITEM_INFO));

	return RES_RETURN_TRUE;
}

void CFieldIOCPSocket::CheckSuccessAllQuestByWarpTargetIndex(MapIndex_t i_nMapIndex, INT i_nWarpTargetIndex)
{
	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);		// lock m_ItemManager.m_mapItemGeneral - @CheckQuestCompetionRequirements, @ProcessQuestResult
	mt_auto_lock mqLock(&m_mapQuest);							// lock m_mapQuest
	mtmapQuestIndex2FieldCharacterQuest::iterator itrQuest= m_mapQuest.begin();
	for(; itrQuest != m_mapQuest.end(); itrQuest++)
	{
		CFieldCharacterQuest *pFCharQuest = &itrQuest->second;
		if (pFCharQuest->QuestState == QUEST_STATE_IN_PROGRESS)
		{
			CQuest *pQuestInfo = pFCharQuest->GetQuestInfo();
			if(pQuestInfo
				&& i_nMapIndex == pQuestInfo->TargetMeetObjectMapArea.MapIndex
				&& i_nWarpTargetIndex == pQuestInfo->TargetMeetObjectIndex)
			{
				MSG_FC_QUEST_REQUEST_SUCCESS tmQuest;
				tmQuest.QuestIndex			= pQuestInfo->QuestIndex;
				tmQuest.SpentTimeInSeconds	= 0;
				tmQuest.QuestResult			= 0;
				this->CheckQuestRequestSuccessAndSendResult(pFCharQuest, &tmQuest, FALSE, i_nMapIndex, i_nWarpTargetIndex);
				break;	// 2005-08-17 by cmkwon, Ʈ ϳ üũϰ  
			}
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::CheckSuccessAllQuestByAttackMonsterNum(INT i_nAttackMonsterNum)
/// \brief		
/// \author		cmkwon
/// \date		2005-08-22 ~ 2005-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::CheckSuccessAllQuestByAttackMonsterNum(INT i_nAttackMonsterNum)
{
	if(0 == i_nAttackMonsterNum){					return;}

	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);		// lock m_ItemManager.m_mapItemGeneral - @CheckQuestCompetionRequirements, @ProcessQuestResult
	mt_auto_lock mqLock(&m_mapQuest);							// lock m_mapQuest
	mtmapQuestIndex2FieldCharacterQuest::iterator itrQuest= m_mapQuest.begin();
	for(; itrQuest != m_mapQuest.end(); itrQuest++)
	{
		CFieldCharacterQuest *pFCharQuest = &itrQuest->second;
		if (pFCharQuest->QuestState == QUEST_STATE_IN_PROGRESS)
		{
			CQuest *pQuestInfo = pFCharQuest->GetQuestInfo();
			if(pQuestInfo
				&& i_nAttackMonsterNum == pQuestInfo->TargetDeadByMonsterUniquenumber)
			{
				MSG_FC_QUEST_REQUEST_SUCCESS tmQuest;
				tmQuest.QuestIndex			= pQuestInfo->QuestIndex;
				tmQuest.SpentTimeInSeconds	= 0;
				tmQuest.QuestResult			= 0;
				this->CheckQuestRequestSuccessAndSendResult(pFCharQuest, &tmQuest, FALSE, 0, 0, i_nAttackMonsterNum);
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::CheckSuccessProgressQuestByTimeLimited(void)
/// \brief		// 2007-12-06 by cmkwon, ð Ʈ  ð üũϰ  - CheckSuccessProgressQuestByTimeLimited() ߰
/// \author		cmkwon
/// \date		2007-12-06 ~ 2007-12-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::CheckSuccessProgressQuestByTimeLimited(void)
{
	if(FALSE == this->IsValidCharacter(FALSE))
	{
		return;
	}

	mt_auto_lock igLock(&m_ItemManager.m_mapItemGeneral);		// lock m_ItemManager.m_mapItemGeneral - @CheckQuestCompetionRequirements, @ProcessQuestResult
	mt_auto_lock mqLock(&m_mapQuest);							// lock m_mapQuest

	
	CFieldCharacterQuest *pFCharQuest = this->GetCharacterQuestInProgress();	// 2007-12-06 by cmkwon,   Ʈ ´
	if(NULL == pFCharQuest
		|| FALSE == pFCharQuest->m_pQuestInfo->IsEndTypeTimeOver())	// 2007-12-06 by cmkwon, ð Ʈ ƴϸ 
	{
		return;
	}

	LONGLONG	llTPlayTime		= this->GetTotalPlayTimeInSeconds();
	int			nSpentTimeSec	= llTPlayTime - pFCharQuest->QuestPlayTimeStamp;

	// 2007-12-06 by cmkwon,  üũ ּ 30   Ϸǵ
	if(FALSE == pFCharQuest->m_pQuestInfo->IsCompleteEndTypeTimeOver(max(0, nSpentTimeSec-30)))
	{
		return;
	}

	// 2007-12-06 by cmkwon, ׽Ʈ  ӽÿ -  ÷ ̻  ߿  ؾ
	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Notify] CFieldIOCPSocket::CheckSuccessProgressQuestByTimeLimited_ %s, QuestIndex(%d), TotalPlayTime(%I64d), PlayTimeAtQuestStart(%I64d), TimeGap(%dsec)\r\n"
		, GetCharacterString(&m_character, string()), pFCharQuest->QuestIndex, llTPlayTime, pFCharQuest->QuestPlayTimeStamp, nSpentTimeSec);

	MSG_FC_QUEST_REQUEST_SUCCESS tmQuestReqSuccess;
	tmQuestReqSuccess.QuestIndex			= pFCharQuest->m_pQuestInfo->QuestIndex;
	tmQuestReqSuccess.SpentTimeInSeconds	= nSpentTimeSec;
	tmQuestReqSuccess.QuestResult			= 0;
	this->CheckQuestRequestSuccessAndSendResult(pFCharQuest, &tmQuestReqSuccess, FALSE);	
}
	

// error ޼ 
void CFieldIOCPSocket::SendErrorMessage(MessageType_t msgType, Err_t err, int errParam1, int errParam2
										, char* errMsg/*=NULL*/
										, BOOL bCloseConnection/*=FALSE*/
										, BOOL i_bWriteSystemLog/*=TRUE*/)
{
	MSG_ERROR	*pMsgError;
	BYTE		SendBuf[SIZE_MAX_PACKET];

	if(i_bWriteSystemLog)
	{
		char szSystemLog[2048];		// 2009-12-15 by cmkwon,  ״  (2048κ) - 
		sprintf(szSystemLog, "  SendErrorMsg to %s %s ==> %s(%#04x) AT %s Param1(%d) Param2(%d) Msg(%s)\r\n",
			GetCharacterString(&m_character, string()), m_szPeerIP,
			GetErrorString(err), err, GetProtocolTypeString(msgType), errParam1, errParam2, errMsg);
		g_pFieldGlobal->WriteSystemLog(szSystemLog);
#ifdef _DEBUG
	//	if (err != ERR_PROTOCOL_INVALID_MAP_EVENT_INFO)
		{
			DBGOUT(szSystemLog);
		}
#endif
	}

	*(MessageType_t*)SendBuf = T_ERROR;
	pMsgError = (MSG_ERROR*)(SendBuf+SIZE_FIELD_TYPE_HEADER);
	pMsgError->CloseConnection = bCloseConnection;
	pMsgError->ErrorCode = err;
	pMsgError->MsgType = msgType;
	pMsgError->ErrParam1 = errParam1;
	pMsgError->ErrParam2 = errParam2;
	if (errMsg == NULL)
	{
		pMsgError->StringLength = 0;
	}
	else
	{
		pMsgError->StringLength = (USHORT)(strlen(errMsg) + 1);
		STRNCPY_MEMSET((char*)SendBuf + MSG_SIZE(MSG_ERROR), errMsg, SIZE_MAX_ERROR_STRING);
	}
	SendAddData(SendBuf, MSG_SIZE(MSG_ERROR) + pMsgError->StringLength);
}

void CFieldIOCPSocket::SendNetworkErrorMessage(int i_nWriteBufCounts, int i_nBadNetworkContinueTime)
{
	///////////////////////////////////////////////////////////////////////////////
	// 2008-03-13 by cmkwon, Ʒ  
	switch(m_PeerSocketType)
	{
	case ST_CLIENT_TYPE:
		{
			BOOL bCloseFlag = i_nWriteBufCounts > 200 ? TRUE:FALSE;			
			this->SendErrorMessage(T_FC_CONNECT_ALIVE, ERR_COMMON_BAD_NETWORK, i_nWriteBufCounts, i_nBadNetworkContinueTime, NULL, bCloseFlag);
						
			if(bCloseFlag
				&& i_nBadNetworkContinueTime > 60000)
			{
				m_bMustClose					= TRUE;		// 2007-03-12 by cmkwon
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [Notify]: Closed by Bad network !!, %s IP|%s| SockIdx|%4d| WriteBufCount|%8d| ContinueTime|%8d|\r\n"
					, GetCharacterString(GetCharacter(), string()), GetPeerIP(), this->GetClientArrayIndex(), i_nWriteBufCounts, i_nBadNetworkContinueTime);

				// 2008-03-19 by cmkwon, Ը  Ŭ̾Ʈ (lack)   - Ʈũ °  Ⱦ Ǵ  ͸ Ϸ Ѵ.
				this->SaveDataOfWriteBufList();
			}
		}
		break;
	default:
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[ERROR] SendNetworkError !! IP|%s| SockIdx|%4d| WriteBufCount|%8d| ContinueTime|%8d|\r\n"
				, GetPeerIP(), this->GetClientArrayIndex(), i_nWriteBufCounts, i_nBadNetworkContinueTime);
		}
	}

// 2008-03-13 by cmkwon, Ը  Ŭ̾Ʈ ñ°  -   
// 	if(ST_CLIENT_TYPE == m_PeerSocketType)
// 	{
// 		// 2008-03-10 by cmkwon, Ը  Ŭ̾Ʈ ñ°  - 400  (<==200)
// 		BOOL bCloseFlag = i_nWriteBufCounts > 400 ? TRUE:FALSE;
// 		//	this->SendErrorMessage(T_FC_CONNECT_ALIVE, ERR_COMMON_BAD_NETWORK
// 		//		, i_nWriteBufCounts, i_nBadNetworkContinueTime, NULL
// 		//		, (i_nWriteBufCounts > 50 ? TRUE:FALSE));
// 		
// 		// 2004-11-15 by cmkwon, WriteBufCounts 100 ũ  CloeseѴ
// 		this->SendErrorMessage(T_FC_CONNECT_ALIVE, ERR_COMMON_BAD_NETWORK
// 			, i_nWriteBufCounts, i_nBadNetworkContinueTime, NULL
// 			, bCloseFlag);
// 		
// 		// 2008-03-10 by cmkwon, Ը  Ŭ̾Ʈ ñ°  - 60000  (<==30000)
// 		if(bCloseFlag
// 			&& i_nBadNetworkContinueTime > 60000)
// 		{
// 			m_bMustClose					= TRUE;		// 2007-03-12 by cmkwon
// // 2007-03-12 by cmkwon, Ḧ Alive üũ ʿ ó,   ó
// //			Sleep(100);
// //			this->Close(0, FALSE);
// 			g_pFieldGlobal->WriteSystemLogEX(TRUE, "  [Notify]: Closed by Bad network !!, %s WriteBufCount(%d) BadnetworkContinueTime(%d)\r\n"
// 				, GetCharacterString(GetCharacter(), string()), i_nWriteBufCounts, i_nBadNetworkContinueTime);
// 		}
// 	}
// #ifdef _DEBUG
// 	else
// 	{
// 		char szSystemLog[256];
// 		sprintf(szSystemLog, "[ERROR] SendNetworkError to %s %s ==> WriteBufCounts(%4d) ContinueTime(%5d)\r\n"
// 			, GetCharacterString(&m_character, string()), m_szPeerIP
// 			, i_nWriteBufCounts, i_nBadNetworkContinueTime);
// 		g_pFieldGlobal->WriteSystemLog(szSystemLog);	
// 	}
// #endif// _DEBUG_endif
}

// error ޼ 
void CFieldIOCPSocket::SendErrorMessageFromFieldDB(EnumQueryType qType, Err_t err, int errParam1, int errParam2, char* errMsg, BOOL bCloseConnection)
{
	if(FALSE == IsUsing()){						return;	}

	MSG_ERROR	*pMsgError;
	BYTE		SendBuf[SIZE_MAX_PACKET];

	char szSystemLog[256];
	sprintf(szSystemLog, "  SendErrorMessageFromFieldDB to %s %s ==> %s(%#04x) AT %s Param1(%d) Param2(%d) Msg(%s)\r\n",
		GetCharacterString(&m_character, string()), m_szPeerIP,
		GetErrorString(err), err, GetDBQueryTypeString(qType), errParam1, errParam2, errMsg);
	g_pFieldGlobal->WriteSystemLog(szSystemLog);
#ifdef _DEBUG
//	if (err != ERR_PROTOCOL_INVALID_MAP_EVENT_INFO)
	{
		DBGOUT(szSystemLog);
	}
#endif

	*(MessageType_t*)SendBuf = T_ERROR;
	pMsgError = (MSG_ERROR*)(SendBuf+SIZE_FIELD_TYPE_HEADER);
	pMsgError->CloseConnection = bCloseConnection;
	pMsgError->ErrorCode = err;
	pMsgError->MsgType = T_FIELD_DB;
	pMsgError->ErrParam1 = errParam1;
	pMsgError->ErrParam2 = errParam2;
	if (errMsg == NULL)
	{
		pMsgError->StringLength = 0;
	}
	else
	{
		pMsgError->StringLength = (USHORT)(strlen(errMsg) + 1);
		STRNCPY_MEMSET((char*)SendBuf + MSG_SIZE(MSG_ERROR), errMsg, SIZE_MAX_ERROR_STRING);
	}
	SendAddData(SendBuf, MSG_SIZE(MSG_ERROR) + pMsgError->StringLength);
}

BOOL CFieldIOCPSocket::IsSamePartyByClientIndex(ClientIndex_t clientIndex)
{
	CFieldParty *pMeFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (pMeFParty == NULL)
	{
		return FALSE;
	}

	CFieldIOCPSocket *pSocket = ms_pFieldIOCP->GetFieldIOCPSocket(clientIndex);
	if (!pSocket->IsUsing())
	{
		return FALSE;
	}

	CFieldParty *pPeerFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (pPeerFParty == NULL)
	{
		return FALSE;
	}

	return (pPeerFParty->m_PartyID == pMeFParty->m_PartyID);
}

BOOL CFieldIOCPSocket::IsSamePartyByCharacterUniqueNumber(UID32_t characterUniqueNumber)
{
	CFieldParty *pMeFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (pMeFParty == NULL)
	{
		return FALSE;
	}

	CFieldIOCPSocket *pSocket = ms_pFieldIOCP->GetFieldIOCPSocketByCharacterUniqueNumber(characterUniqueNumber);
	if (NULL == pSocket
		|| FALSE == pSocket->IsValidCharacter(FALSE))
	{
		return FALSE;
	}

	CFieldParty *pPeerFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (pPeerFParty == NULL)
	{
		return FALSE;
	}

	return (pPeerFParty->m_PartyID == pMeFParty->m_PartyID);
}


void CFieldIOCPSocket::PartyGetMemberClientIdxListExcludeMe(vectorClientIndex *o_pVectClientIndex
															, ClientIndex_t i_excludeCltIdx/*=0*/
															, BOOL i_bOnlySameMapChannel/*=FALSE*/
															, BOOL i_bOnlyNoBodyConEventHandle/*=FALSE*/)
{
	CFieldParty *pParty = this->m_pFieldParty;
	if (NULL == pParty)
	{
		return;
	}

	pParty->m_ListPartyMember.lock();
	int nSize = pParty->m_ListPartyMember.size();
	
	for(int i=0; i < nSize; i++)
	{
		CFieldIOCPSocket *pSocket = pParty->m_ListPartyMember[i].PM_CharacterSocket;
		if (pSocket
			&& pSocket != this
			&& pSocket->IsUsing()
			&& pSocket->m_character.ClientIndex != i_excludeCltIdx)
		{
			if(FALSE == i_bOnlySameMapChannel
				|| pSocket->m_pCurrentFieldMapChannel == this->m_pCurrentFieldMapChannel)
			{
				if(FALSE == i_bOnlyNoBodyConEventHandle
					|| FALSE == COMPARE_BODYCON_BIT(pSocket->m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK))
				{
					o_pVectClientIndex->push_back(pSocket->m_character.ClientIndex);
				}
			}					
		}
	}
	pParty->m_ListPartyMember.unlock();
}

UID32_t CFieldIOCPSocket::GetPartyMasterUniqueNumber()
{
	CFieldParty *pFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (pFParty == NULL)
	{
		return INVALID_UNIQUE_NUMBER;
	}

	return pFParty->GetMasterCharacterUniqueNumber();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::IsPartyMaster(void)
/// \brief		
/// \author		cmkwon
/// \date		2007-02-12 ~ 2007-02-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::IsPartyMaster(void)
{
	CFieldParty *pFParty = m_pFieldParty;
	if(NULL == pFParty)
	{
		return FALSE;
	}

	mt_auto_lock mtFP(&pFParty->m_ListPartyMember);
	return m_character.CharacterUniqueNumber == pFParty->GetMasterCharacterUniqueNumber();
}

BOOL CFieldIOCPSocket::IsSameParty(CFieldIOCPSocket *pSocket)
{
	CFieldParty *pMeFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (pMeFParty == NULL)
	{
		return FALSE;
	}
	
	if (pSocket == NULL || FALSE == pSocket->IsUsing())
	{
		return FALSE;
	}
	
	CFieldParty *pPeerFParty = pSocket->m_pFieldParty;			// 2006-07-04 by cmkwon
	if(NULL == pPeerFParty)
	{
		return FALSE;
	}	

	return (pPeerFParty->m_PartyID == pMeFParty->m_PartyID);
}

void CFieldIOCPSocket::OnPartyBattleMemberDead(BOOL bImediateLoss)
{
	CFieldParty *pMeFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if (NULL == pMeFParty
		|| FALSE == this->IsPartyBattleState())
	{
		return;
	}

	pMeFParty->m_ListPartyMember.lock();

	// live member lock
	pMeFParty->m_PartyBattle.m_setLiveMember.lock();

	pMeFParty->m_PartyBattle.m_setLiveMember.deleteLock(m_character.CharacterUniqueNumber);

	if (bImediateLoss)
	{
// 2005-12-27 by cmkwon, 1:1 PK ġ ø ʴ´ - ġ Ÿ ׿  ȴ.
//		//  й踦 ó
//		m_character.PKLossPoint += 1;
//		m_character.Propensity
//			-= (5 + max(m_pFieldParty->m_PartyBattle.m_nAverageLevel - m_pFieldParty->m_PartyBattle.m_nPeerAverageLevel, 0));
//		CheckAndUpdateStatus();
//		SendCharacterInfo(T_FC_CHARACTER_CHANGE_PKPOINT);
//		// DB 
//		QPARAM_CHARACTER_CHANGE_PKPOINT *pQChangePKPointLoser = new QPARAM_CHARACTER_CHANGE_PKPOINT;
//		pQChangePKPointLoser->CharacterUniqueNumber = m_character.CharacterUniqueNumber;
//		pQChangePKPointLoser->Propensity = m_character.Propensity;
//		pQChangePKPointLoser->PKWinPoint = m_character.PKWinPoint;
//		pQChangePKPointLoser->PKLossPoint = m_character.PKLossPoint;
//		ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangePKPoint, this, m_character.AccountUniqueNumber, pQChangePKPointLoser);
	}
	else
	{
		pMeFParty->m_PartyBattle.m_setLossWaiters.insertLock(m_character.CharacterUniqueNumber);
	}

	if (pMeFParty->m_PartyBattle.m_setLiveMember.empty())
	{
		// live member unlock
		pMeFParty->m_PartyBattle.m_setLiveMember.unlock();

		//  , Ƽ й
		PartyID_t tmpPeerPartyID = pMeFParty->m_PeerBattlePartyID;
		pMeFParty->m_PeerBattlePartyID = 0;	//  ̻ Ƽ  ƾ   ʱȭ, ex)  Ŀ ̻ ± 

		CFieldParty *pPeerWinnerParty = ms_pFieldIOCP->m_MapParties.findLock(tmpPeerPartyID);
		if (pPeerWinnerParty != NULL)
		{
			pPeerWinnerParty->m_PeerBattlePartyID = 0;	//  ̻ Ƽ  ƾ   ʱȭ, ex)  Ŀ ̻ ± 

			// Ƽ  ó
			OnPartyBattleEnd(pPeerWinnerParty, pMeFParty);
		}
	}
	else
	{
		// just live member unlock
		pMeFParty->m_PartyBattle.m_setLiveMember.unlock();
	}

	// party unlock
	pMeFParty->m_ListPartyMember.unlock();
}

BOOL CFieldIOCPSocket::IsPartyBattleState(void)
{
	CFieldParty *pFParty = this->m_pFieldParty;			// 2006-07-04 by cmkwon
	if(NULL == pFParty
		|| 0 == pFParty->m_PeerBattlePartyID)
	{
		return FALSE;
	}

	return TRUE;
}

void CFieldIOCPSocket::OnPartyBattleEnd(CFieldParty *pWinnerParty, CFieldParty *pLoserParty)
{
	///////////////////////////////////////////////////////////////////////////
	// Winner Party ó
	///////////////////////////////////////////////////////////////////////////
	if (pWinnerParty != NULL)
	{
		mt_auto_lock pmlock(&pWinnerParty->m_ListPartyMember);

		// Ƽ  뺸
		INIT_MSG_WITH_BUFFER(MSG_FC_PARTY_BATTLE_END, T_FC_PARTY_BATTLE_END, pPartyBattleEnd, pPartyBattleEndBuf);
		// To Winner
		pPartyBattleEnd->EndType = BATTLE_END_WIN;
		pPartyBattleEnd->PeerPartyID = pWinnerParty->m_PeerBattlePartyID;
		pWinnerParty->SendMsgToMembersMap(pPartyBattleEndBuf, MSG_SIZE(MSG_FC_PARTY_BATTLE_END), pWinnerParty->m_PartyBattle.m_pBattleMapChannel);

// 2005-12-27 by cmkwon, 1:1 PK ġ ø ʴ´ - ġ Ÿ ׿  ȴ.
//		// PK ġ 
//		mtlistFieldPartyMember::iterator itrWinner = pWinnerParty->m_ListPartyMember.begin();
//		while (itrWinner != pWinnerParty->m_ListPartyMember.end())
//		{
//			CFieldIOCPSocket *pWinnerSocket = (*itrWinner).PM_CharacterSocket;
//
//			if (pWinnerSocket->IsUsing())
//			{
//				pWinnerSocket->m_character.PKWinPoint += 1;
//				pWinnerSocket->m_character.Propensity += max(0, (10 + pWinnerParty->m_PartyBattle.m_nPeerAverageLevel - pWinnerParty->m_PartyBattle.m_nAverageLevel));
//				pWinnerSocket->CheckAndUpdateStatus();
//				pWinnerSocket->SendCharacterInfo(T_FC_CHARACTER_CHANGE_PKPOINT);
//				// DB 
//				QPARAM_CHARACTER_CHANGE_PKPOINT *pQChangePKPointWinner = new QPARAM_CHARACTER_CHANGE_PKPOINT;
//				pQChangePKPointWinner->CharacterUniqueNumber = pWinnerSocket->m_character.CharacterUniqueNumber;
//				pQChangePKPointWinner->Propensity = pWinnerSocket->m_character.Propensity;
//				pQChangePKPointWinner->PKWinPoint = pWinnerSocket->m_character.PKWinPoint;
//				pQChangePKPointWinner->PKLossPoint = pWinnerSocket->m_character.PKLossPoint;
//				pWinnerSocket->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangePKPoint, pWinnerSocket, pWinnerSocket->m_character.AccountUniqueNumber, pQChangePKPointWinner);
//			}
//
//			itrWinner++;
//		}

		// Reset
		pWinnerParty->m_PeerBattleRequesterPartyID = 0;
		pWinnerParty->m_PeerBattlePartyID = 0;
		pWinnerParty->m_PartyBattle.CleanFieldPartyBattle();
	}

	///////////////////////////////////////////////////////////////////////////
	// Loser Party ó
	///////////////////////////////////////////////////////////////////////////
	if (pLoserParty != NULL)
	{
		// lock m_ListPartyMember
		mt_auto_lock pmlock(&pLoserParty->m_ListPartyMember);

		// Ƽ  뺸
		INIT_MSG_WITH_BUFFER(MSG_FC_PARTY_BATTLE_END, T_FC_PARTY_BATTLE_END, pPartyBattleEnd, pPartyBattleEndBuf);
		pPartyBattleEnd->EndType = BATTLE_END_DEFEAT;
		pPartyBattleEnd->PeerPartyID = pLoserParty->m_PeerBattlePartyID;
		pLoserParty->SendMsgToMembersMap(pPartyBattleEndBuf, MSG_SIZE(MSG_FC_PARTY_BATTLE_END), pLoserParty->m_PartyBattle.m_pBattleMapChannel);

		pLoserParty->m_PartyBattle.m_setLossWaiters.lock();
// 2005-12-27 by cmkwon, 1:1 PK ġ ø ʴ´ - ġ Ÿ ׿  ȴ.
//		// PK ġ 
//		mtsetUID32::iterator itrLoserCharacter = pLoserParty->m_PartyBattle.m_setLossWaiters.begin();
//		while (itrLoserCharacter != pLoserParty->m_PartyBattle.m_setLossWaiters.end())
//		{
//			UID32_t loserCharacterUniqueNumber = (*itrLoserCharacter);
//			CFieldIOCPSocket *pLoserSocket = pLoserParty->m_pFieldIOCP7->m_mapCharacterUniqueNumber.findLock(loserCharacterUniqueNumber);
//			if (pLoserSocket == NULL)
//			{
//				// check: fatal error
//				g_pFieldGlobal->WriteSystemLogEX(TRUE, "FATAL ERROR@OnPartyBattleEnd: loser socket is null(%d)\r\n", loserCharacterUniqueNumber);
//			}
//			else
//			{
//				pLoserSocket->m_character.PKLossPoint += 1;
//				pLoserSocket->m_character.Propensity -= (5 + max(pLoserParty->m_PartyBattle.m_nAverageLevel - pLoserParty->m_PartyBattle.m_nPeerAverageLevel, 0));
//				pLoserSocket->CheckAndUpdateStatus();
//				pLoserSocket->SendCharacterInfo(T_FC_CHARACTER_CHANGE_PKPOINT);
//				// DB 
//				QPARAM_CHARACTER_CHANGE_PKPOINT *pQChangePKPointLoser = new QPARAM_CHARACTER_CHANGE_PKPOINT;
//				pQChangePKPointLoser->CharacterUniqueNumber = pLoserSocket->m_character.CharacterUniqueNumber;
//				pQChangePKPointLoser->Propensity = pLoserSocket->m_character.Propensity;
//				pQChangePKPointLoser->PKWinPoint = pLoserSocket->m_character.PKWinPoint;
//				pQChangePKPointLoser->PKLossPoint = pLoserSocket->m_character.PKLossPoint;
//				pLoserSocket->ms_pFieldIOCP->m_pAtumDBManager->MakeAndEnqueueQuery(QT_ChangePKPoint, pLoserSocket, pLoserSocket->m_character.AccountUniqueNumber, pQChangePKPointLoser);
//			}
//
//			itrLoserCharacter++;
//		}
		pLoserParty->m_PartyBattle.m_setLossWaiters.clearLock();
		pLoserParty->m_PartyBattle.m_setLossWaiters.unlock();

		// Reset
		pLoserParty->m_PeerBattleRequesterPartyID = 0;
		pLoserParty->m_PeerBattlePartyID = 0;
		pLoserParty->m_PartyBattle.CleanFieldPartyBattle();
	}
}


void CFieldIOCPSocket::DBGOUT2(BitFlag8_t bType, char* pFormat, ...)
{
	if (bType == DO2_NONE)
	{
		return;
	}

	char szLogMsg[1024];
	va_list args;
	va_start(args, pFormat);
	vsprintf(szLogMsg, pFormat, args);

	if (COMPARE_BIT_FLAG(bType, DO2_DBGOUT)) DBGOUT(szLogMsg);
	if (COMPARE_BIT_FLAG(bType, DO2_SYSLOG)) g_pFieldGlobal->WriteSystemLog(szLogMsg, TRUE);
	if (COMPARE_BIT_FLAG(bType, DO2_STR128)) SendString128(STRING_128_ADMIN_CMD, szLogMsg);
}

void CFieldIOCPSocket::StartTestDBG(int nParam1, int nParam2, int nParam3, const char *szParam1, const char *szParam2, const char *szParam3)
{
	//  ׽Ʈ
//	int nBytesUsed = 0;
//	MSG_FC_AUCTION_CANCEL_REGISTER msgReg;
//	msgReg.ItemUID = nParam1;
//	Process_FC_AUCTION_CANCEL_REGISTER((char*)&msgReg, sizeof(MSG_FC_AUCTION_CANCEL_REGISTER), nBytesUsed);

//	// Ÿ̸ ׽Ʈ
//	m_TimerManager.StartTimerField(TE_TYPE_TEST, 2000, 1, 2, 3, 100);

// 	int nByteUsed = 0;
//	MSG_FC_GUILD_GET_MAP_OWNER_INFO msgGetOwnerInfo;
//	msgGetOwnerInfo.MapIndex = m_character.MapChannelIndex.MapIndex;
//	Process_FC_GUILD_GET_MAP_OWNER_INFO((char*)&msgGetOwnerInfo, sizeof(MSG_FC_GUILD_GET_MAP_OWNER_INFO), nByteUsed);

	///////////////////////////////////////////////////////////////////////////////
	// 2009-03-09 by cmkwon, Ϻ Arario nProtect CS ϱ - ӽ ɾ 
	if(0 == stricmp(szParam1, "Release")
		&& 0 == stricmp(szParam2, "Security")
		&& 0 == stricmp(szParam3, "System"))
	{
		CFieldIOCPSocket::SecurityServerClean();
		this->SendString128(STRING_128_ADMIN_CMD, "Released security system !!");
	}
}

BOOL CFieldIOCPSocket::CheckValidAttackTargetCharacter(CFieldMapChannel *i_pFMChann, ClientIndex_t i_targetIndex)
{
	CFieldIOCPSocket *pTargetSocket	= NULL;
	CHARACTER *pTargetCharacter		= NULL;

	return CheckValidAttackTargetCharacter(i_pFMChann, i_targetIndex, pTargetSocket, pTargetCharacter);
}

BOOL CFieldIOCPSocket::CheckValidAttackTargetCharacter(CFieldMapChannel *i_pFMChann, ClientIndex_t i_targetIndex, CFieldIOCPSocket *&o_pTargetSocket)
{
	CHARACTER *pTargetCharacter		= NULL;

	return CheckValidAttackTargetCharacter(i_pFMChann, i_targetIndex, o_pTargetSocket, pTargetCharacter);
}

BOOL CFieldIOCPSocket::CheckValidAttackTargetCharacter(CFieldMapChannel *i_pFMChann, ClientIndex_t i_targetIndex, CFieldIOCPSocket *&o_pTargetSocket, CHARACTER *&o_pTargetCharacter)
{
	o_pTargetSocket		= NULL;
	o_pTargetCharacter	= NULL;

	if (!IS_CHARACTER_CLIENT_INDEX(i_targetIndex))
	{
		return FALSE;
	}

	o_pTargetSocket = ms_pFieldIOCP->GetFieldIOCPSocket(i_targetIndex);

	// ǰ IOCPSocket ȿ üũ
	if (NULL == o_pTargetSocket
		|| FALSE == o_pTargetSocket->IsValidCharacter()
		|| TRUE == COMPARE_BODYCON_BIT(o_pTargetSocket->m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK)
		|| NULL == i_pFMChann
		|| i_pFMChann != o_pTargetSocket->GetCurrentFieldMapChannel())		// 2007-07-02 by cmkwon,   
	{
		o_pTargetSocket		= NULL;
		return FALSE;
	}

	// ǰ ĳͰ ȿ üũ
	o_pTargetCharacter = &o_pTargetSocket->m_character;
	return TRUE;
}

BOOL CFieldIOCPSocket::CheckValidAttackTargetMonster(BYTE i_byAttackCharInfluenceTy, ClientIndex_t i_nTargetIndex, ChannelIndex_t i_nChannelIndex, CFieldMonster *&o_pTargetMonster)
{
	if (FALSE == IS_MONSTER_CLIENT_INDEX(i_nTargetIndex))
	{
		return FALSE;
	}

	if (m_PeerSocketType == ST_NPC_SERVER
		&& m_pFieldMapProjectForNPC)
	{
		// Ͱ ȿ üũ
		o_pTargetMonster = m_pFieldMapProjectForNPC->GetFieldMonsterW(i_nChannelIndex, i_nTargetIndex, 102);
	}
	else if (m_PeerSocketType == ST_CLIENT_TYPE
		&& m_pCurrentFieldMapChannel)
	{
		// Ͱ ȿ üũ
		o_pTargetMonster = m_pCurrentFieldMapChannel->m_pFieldMapProject->GetFieldMonsterW(i_nChannelIndex, i_nTargetIndex, 103);
	}
	else
	{
		return FALSE;
	}

	if(NULL == o_pTargetMonster
		|| FALSE == o_pTargetMonster->IsValidMonster())
	{
		o_pTargetMonster = NULL;
		return FALSE;
	}

	if(IS_SAME_CHARACTER_MONSTER_INFLUENCE(i_byAttackCharInfluenceTy , o_pTargetMonster->MonsterInfoPtr->Belligerence))
	{// 2006-11-20 by cmkwon,  ͸鼭 ĳͿ Ͱ 
		return FALSE;
	}
// 2006-11-20 by cmkwon,   
//	if( (IS_VCN_INFLUENCE_TYPE(i_byAttackCharInfluenceTy) && BELL_INFLUENCE_VCN == o_pTargetMonster->MonsterInfoPtr->Belligerence)
//		|| (IS_ANI_INFLUENCE_TYPE(i_byAttackCharInfluenceTy) && BELL_INFLUENCE_ANI == o_pTargetMonster->MonsterInfoPtr->Belligerence) )
//	{// 2005-12-28 by cmkwon, ĳͿ Ͱ      
//		o_pTargetMonster = NULL;
//		return FALSE;
//	}

	///////////////////////////////////////////////////////////////////////////////
	// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - 
	if(BELL_INFINITY_DEFENSE_MONSTER == o_pTargetMonster->MonsterInfoPtr->Belligerence)
	{
		return FALSE;
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-03-16 by cmkwon, 2 MtoM, MtoC Ÿ    - 
/// \author		cmkwon
/// \date		2010-03-17 ~ 2010-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::CheckValidM2M(CFieldMapChannel *i_pFMChann, ClientIndex_t i_AttackerIdx, CFieldMonster **o_ppAttackMon, ClientIndex_t i_TargetIdx, CFieldMonster **o_ppTargetMon)
{
	*o_ppAttackMon	= NULL;
	*o_ppTargetMon	= NULL;

	if (FALSE == IS_MONSTER_CLIENT_INDEX(i_AttackerIdx)
		|| FALSE == IS_MONSTER_CLIENT_INDEX(i_TargetIdx))
	{
		return FALSE;
	}

	if(NULL == i_pFMChann
		|| IS_CITY_MAP_INDEX(i_pFMChann->GetMapChannelIndex().MapIndex))
	{
		return FALSE;
	}

	CFieldMonster *pAttFMon	= i_pFMChann->GetFieldMonster(i_AttackerIdx, 200);
	CFieldMonster *pTarFMon	= i_pFMChann->GetFieldMonster(i_TargetIdx, 201);
	if(NULL == pAttFMon || NULL == pTarFMon
		|| FALSE == pAttFMon->IsValidMonster() || FALSE == pTarFMon->IsValidMonster())
	{
		return FALSE;
	}

	// 2010-03-17 by cmkwon,  BELL_INFINITY_ATTACK_MONSTER BELL_INFINITY_DEFENSE_MONSTER  ϴ.
	if(FALSE == IS_WARABLE_M2M_BELL(pAttFMon->MonsterInfoPtr->Belligerence, pTarFMon->MonsterInfoPtr->Belligerence))
	{
		return FALSE;
	}

	*o_ppAttackMon	= pAttFMon;
	*o_ppTargetMon	= pTarFMon;
	return TRUE;
}

Err_t CFieldIOCPSocket::CheckItemRequirements(ITEM *i_pItemInfo)
{
	// 2013-05-31 by jhseol,bckim Ƹ ÷ - ÷ Ͽ    üũ ʴ´.
	if ( FALSE == i_pItemInfo->IsExistDesParam(DES_COLLECTION_ARMOR_INDEX) )
	{
		if ((i_pItemInfo->ReqUnitKind & m_character.UnitKind) == 0)	// ʿ
		{
			return ERR_PROTOCOL_REQ_UNITKIND_NOT_MATCHED;
		}
	}
	// end 2013-05-31 by jhseol,bckim Ƹ ÷ - ÷ Ͽ    üũ ʴ´.

// 2010-05-19 by cmkwon, 2  ųũ    - Ʒ  
// 	if (COMPARE_RACE(i_pItemInfo->ReqRace, m_character.Race) == FALSE)	// ʿ
// 	{
// 		return ERR_PROTOCOL_REQ_RACE_NOT_MATCHED;
// 	}
	// 2010-05-19 by cmkwon, 2  ųũ    - ųũ  ReqRace üũ ʾƾ Ѵ.
	if(FALSE == COMPARE_BIT_FLAG(i_pItemInfo->ItemAttribute, ITEM_ATTR_KILL_MARK_ITEM))
	{
		if (COMPARE_RACE(i_pItemInfo->ReqRace, m_character.Race) == FALSE)	// ʿ
		{
			return ERR_PROTOCOL_REQ_RACE_NOT_MATCHED;
		}
	}

	if (i_pItemInfo->ReqGearStat.AttackPart > m_character.TotalGearStat.AttackPart)
	{
		return ERR_PROTOCOL_REQ_ATTACK_PART_NOT_MATCHED;
	}
	if (i_pItemInfo->ReqGearStat.DefensePart > m_character.TotalGearStat.DefensePart)
	{
		return ERR_PROTOCOL_REQ_DEFENSE_PART_NOT_MATCHED;
	}
	if (i_pItemInfo->ReqGearStat.FuelPart > m_character.TotalGearStat.FuelPart)
	{
		return ERR_PROTOCOL_REQ_FUEL_PART_NOT_MATCHED;
	}
	if (i_pItemInfo->ReqGearStat.SoulPart > m_character.TotalGearStat.SoulPart)
	{
		return ERR_PROTOCOL_REQ_SOUL_PART_NOT_MATCHED;
	}
	if (i_pItemInfo->ReqGearStat.ShieldPart > m_character.TotalGearStat.ShieldPart)
	{
		return ERR_PROTOCOL_REQ_SHIELD_PART_NOT_MATCHED;
	}
	if (i_pItemInfo->ReqGearStat.DodgePart > m_character.TotalGearStat.DodgePart)
	{
		return ERR_PROTOCOL_REQ_DODGE_PART_NOT_MATCHED;
	}

	return ERR_NO_ERROR;
}

Err_t CFieldIOCPSocket::CheckGeneralItemRequirements(ITEM_GENERAL *i_pGItem)
{
	int nReqMinLevel = 0;
	int nReqMaxLevel = 0;
	
	ms_pFieldIOCP->GetReqLevelApplyRare(&nReqMinLevel, &nReqMaxLevel, i_pGItem);

	//////////////////////////////////////////////////////////////////////////
	// 2008-10-01 by dhjin, ű þƮ
	if(ITEMKIND_SUPPORT == i_pGItem->Kind)
	{
		mt_auto_lock mtA(&m_mapEnchant);		// 2012-09-20 by jhseol, MAP   ٿ  
		mtmapUID2EnchantVector::iterator itrEnchantList = m_mapEnchant.find(i_pGItem->UniqueNumber);
		if (m_mapEnchant.end() != itrEnchantList)
		{
			vectENCHANT &vecECH = itrEnchantList->second;
			for (int i = 0; i < vecECH.size(); i++)
			{
				ITEM *pEnchantItem = ms_pFieldIOCP->GetItemInfo(vecECH[i].EnchantItemNum);
				if (pEnchantItem != NULL)
				{
					// 2009-04-21 by cmkwon, ITEM DesParam ʵ  8 ø - Ʒ  
					//if(DES_REQ_MIN_LEVEL == pEnchantItem->DestParameter1)
					//{
					//	nReqMinLevel += pEnchantItem->ParameterValue1;
					//}
					if(DES_REQ_MIN_LEVEL == pEnchantItem->ArrDestParameter[0])
					{
						nReqMinLevel += pEnchantItem->ArrParameterValue[0];
					}
				}
			}
		}
	}

	if (0 != nReqMinLevel 
		&& nReqMinLevel > m_character.Level)	// ּ ʿ 
	{
		return ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED;
	}

	if (0 != nReqMaxLevel 
		&& nReqMaxLevel < m_character.Level)	// ִ ʿ 
	{
		return ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED;
	}

	return CheckItemRequirements(i_pGItem->ItemInfo);
}

Err_t CFieldIOCPSocket::CheckSkillItemRequirements(ITEM *i_pSItemInfo)
{
	if (0 != i_pSItemInfo->ReqMinLevel 
		&& i_pSItemInfo->ReqMinLevel > m_character.Level)	// ʿ䷹
	{
		return ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED;
	}

	if (0 != i_pSItemInfo->ReqMaxLevel 
		&& i_pSItemInfo->ReqMaxLevel < m_character.Level)	// ʿ䷹
	{
		return ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED;
	}

	return CheckItemRequirements(i_pSItemInfo);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::CheckSpeedHack(DWORD i_dwClientTickGap, float i_fServerDistaceGap)
/// \brief		
/// \author		cmkwon
/// \date		2004-11-01 ~ 2004-11-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::CheckSpeedHack(DWORD i_dwClientTickGap, float i_fServerDistaceGap)
{
	m_arrSpeedHackCheck[0].nRecvMoveCounts++;
	m_arrSpeedHackCheck[0].nSumClientTimeGap		+= i_dwClientTickGap;
	m_arrSpeedHackCheck[0].nSumServerDistanceGap	+= (int)i_fServerDistaceGap;
	
	DWORD dwCurTick = timeGetTime();
	m_arrSpeedHackCheck[0].nServerTimeGap = dwCurTick - m_dwLastTickSpeedHackCheck;
	if(m_arrSpeedHackCheck[0].nServerTimeGap > CHARACTER_SPEED_HACK_CHECK_TERM)
	{
		float fTemp = max(1.0f, (float)m_arrSpeedHackCheck[0].nSumClientTimeGap/1000.0f);
		m_arrSpeedHackCheck[0].nCurrentSpeed
			= (int)( (float)m_arrSpeedHackCheck[0].nSumServerDistanceGap/fTemp );

		if(m_arrSpeedHackCheck[0].nRecvMoveCounts > (m_arrSpeedHackCheck[0].nServerTimeGap*5)/1000 + 10)
		{
			this->WriteLogMessageSpeedHack(SPEEDHACK_CHECK_TYPE_BY_SERVER);
		}

		for(int i = ARRAYSIZE_SPEED_HACK_DATA-2; i >= 0; i--)
		{
			m_arrSpeedHackCheck[i+1] = m_arrSpeedHackCheck[i];
		}
		m_arrSpeedHackCheck[0].ResetSPEED_HACK_DATA();
		
		m_dwLastTickSpeedHackCheck	= dwCurTick;
	}
}

BOOL CFieldIOCPSocket::WriteLogMessageSpeedHack(BYTE i_bCheckType)
{
	int nCheckedCounts = 0;
	int nTotalMoveCounts = 0, i;
	for(i = ARRAYSIZE_SPEED_HACK_DATA-1; i >= 0; i-- )
	{
		if(m_arrSpeedHackCheck[i].nServerTimeGap > CHARACTER_SPEED_HACK_CHECK_TERM)
		{
			nCheckedCounts++;
			nTotalMoveCounts += m_arrSpeedHackCheck[i].nRecvMoveCounts;
		}
	}

	if(nTotalMoveCounts < nCheckedCounts*50 + 10)
	{
		return FALSE;
	}
		
	for(i = ARRAYSIZE_SPEED_HACK_DATA-1; i >= 0; i-- )
	{
		if(0 != m_arrSpeedHackCheck[i].nServerTimeGap)
		{
			///////////////////////////////////////////////////////////////////////////////
			// 2004-11-12, cmkwon, Speed Hack , DB  ؾ
			// AccountName, CharacterName, MapChannelIndex
			// CheckType, ReceivedMoveCounts,
			// ItemNum, ServerPastTime, ClientPastTime, PastDistance, CurrentSpeed,  ð(ʴ)
			CAtumLogSender::SendLogMessageSpeedHack(this, i_bCheckType, m_arrSpeedHackCheck[i].nRecvMoveCounts
				, ((m_ItemRear.ItemNum == 0)?0 : ((ITEM_BASE*)m_ItemRear.ItemNum)->ItemInfo->ItemNum)
				, m_arrSpeedHackCheck[i].nServerTimeGap, m_arrSpeedHackCheck[i].nSumClientTimeGap
				, m_arrSpeedHackCheck[i].nSumServerDistanceGap, m_arrSpeedHackCheck[i].nCurrentSpeed);
			
			char szSystem[1024];
			sprintf(szSystem, "	SpeedHack User by Server ==> AccountName(%10s) CharacterName(%10s) MapChannelIndex(%s) RecvMoveCounts(%5d) ServerPastTime(%4d), ClientPastTime(%4d), PastDistance(%6d) CurrentSpeed(%d)\r\n"
				, m_character.AccountName
				, m_character.CharacterName
				, GET_MAP_STRING(m_character.MapChannelIndex)
				, m_arrSpeedHackCheck[i].nRecvMoveCounts
				, m_arrSpeedHackCheck[i].nServerTimeGap
				, m_arrSpeedHackCheck[i].nSumClientTimeGap
				, m_arrSpeedHackCheck[i].nSumServerDistanceGap
				, m_arrSpeedHackCheck[i].nCurrentSpeed);
// 			DBGOUT(szSystem);
			g_pFieldGlobal->WriteSystemLog(szSystem);
		}
	}

	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::CheckMemoryHackWeapon(ITEM_GENERAL *i_pItemGen, MSG_FC_CHARACTER_GET_REAL_WEAPON_INFO_OK *i_pRealInfo)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-21 ~ 2005-12-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::CheckMemoryHackWeapon(ITEM_GENERAL *i_pItemGen, MSG_FC_CHARACTER_GET_REAL_WEAPON_INFO_OK *i_pRealInfo)
{
	if(NULL == i_pItemGen
		|| FALSE == IS_WEAPON(i_pItemGen->Kind))
	{
		return;
	}

	if(IS_PRIMARY_WEAPON(i_pItemGen->Kind))
	{
		CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_SHOTNUM, CAtumSJ::GetTotalPrimaryShotNumPerReattackTime(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->ShotNum0);
		CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_MULTINUM, 1, i_pRealInfo->MultiNum0);
	}
	else
	{
		CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_SHOTNUM, CAtumSJ::GetTotalSecondaryShotNumPerReattackTime(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->ShotNum0);
		CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_MULTINUM, CAtumSJ::GetSecondaryMultiNumCount(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->MultiNum0);
	}
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_REATTACKTIME, CAtumSJ::GetShotCountReattackTime(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->ReattackTime0);

	// 2008-05-29 by cmkwon, ( )ź æƮ  ޸ ɸ  (G0010300) - Ʒ  
	//CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_REPEATTIME, i_pItemGen->ItemInfo->RepeatTime, i_pRealInfo->RepeatTime0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_REPEATTIME, CAtumSJ::GetWarHeadSpeed(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->RepeatTime0);	// 2008-05-29 by cmkwon, ( )ź æƮ  ޸ ɸ  (G0010300) - CAtumSJ::GetWarHeadSpeed()  üũ

	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_TIME, CAtumSJ::GetOverheatTime(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->Time0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_RANGEANGLE, CAtumSJ::GetAttackRangeAngle(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->RangeAngle0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_BOOSTERANGLE, i_pItemGen->ItemInfo->BoosterAngle, i_pRealInfo->BoosterAngle0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_ORBITTYPE, i_pItemGen->ItemInfo->OrbitType, i_pRealInfo->OrbitType0);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::CheckMemoryHackEngine(ITEM_GENERAL *i_pItemGen, MSG_FC_CHARACTER_GET_REAL_ENGINE_INFO_OK *i_pRealInfo)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-21 ~ 2005-12-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::CheckMemoryHackEngine(ITEM_GENERAL *i_pItemGen, MSG_FC_CHARACTER_GET_REAL_ENGINE_INFO_OK *i_pRealInfo)
{
	if(NULL == i_pItemGen
		|| ITEMKIND_SUPPORT != i_pItemGen->Kind)
	{
		return;
	}

	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_ABILITYMIN, i_pItemGen->ItemInfo->AbilityMin, i_pRealInfo->AbilityMin0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_ABILITYMAX, i_pItemGen->ItemInfo->AbilityMax, i_pRealInfo->AbilityMax0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_SPEEDPENALTY, CAtumSJ::GetCircularAngle(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->SpeedPenalty0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_TIME, i_pItemGen->ItemInfo->Time, i_pRealInfo->Time0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_RANGE, (float)i_pItemGen->ItemInfo->Range, i_pRealInfo->Range0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_RANGEANGLE, CAtumSJ::GetEngineRangeAngle(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->RangeAngle0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_BOOSTERANGLE, CAtumSJ::GetEngineBoosterRangeAngle(i_pItemGen->ItemInfo, &m_ParamFactor), i_pRealInfo->BoosterAngle0);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::CheckMemoryHackTotalWeight(ITEM_GENERAL *i_pItemGen, MSG_FC_CHARACTER_GET_REAL_TOTAL_WEIGHT_OK *i_pRealInfo)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-21 ~ 2005-12-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::CheckMemoryHackTotalWeight(ITEM_GENERAL *i_pItemGen, MSG_FC_CHARACTER_GET_REAL_TOTAL_WEIGHT_OK *i_pRealInfo)
{
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_TRANSPORT, CAtumSJ::GetTransport(&m_character), i_pRealInfo->Transport0);
	CheckMemoryHackByMemoryHackCheckTy(i_pItemGen, HACK_CHECK_TYPE_TOTALWEIGHT, m_ItemManager.GetCurrentCarryingItemWeight(), i_pRealInfo->TotalWeight0);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			BOOL CFieldIOCPSocket::CheckMemoryHackByMemoryHackCheckTy(ITEM_GENERAL *i_pItemGen, int i_nMemoryHackCheckTy, float i_fValidValue, float i_fCurrentValue, int i_nParam1/*=0*/)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-21 ~ 2005-12-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CFieldIOCPSocket::CheckMemoryHackByMemoryHackCheckTy(ITEM_GENERAL *i_pItemGen, int i_nMemoryHackCheckTy
														  , float i_fValidValue, float i_fCurrentValue, int i_nParam1/*=0*/)
{
#ifdef _WARRIOR_ANTICHEAT
	bool	bShouldRunAntiCheat = false;
	bool	bAdvancedChecking = true;
#endif
#ifdef S_AUTO_BLOCK_REATTACKETIME_EXCEPT_JHSEOL
	if(HACK_CHECK_TYPE_REATTACKTIME == i_nMemoryHackCheckTy) return TRUE;	// 2013-07-29 by jhseol, japan Memory Hack Auto Block ReAttackeTime tamp bug adjust
#endif
	int		nValidValue		= fastf2i(100.0f*i_fValidValue);		// 2008-06-26 by cmkwon, float -> int ȯ Լ ߰ - 
	int		nCurValue		= fastf2i(100.0f*i_fCurrentValue);		// 2008-06-26 by cmkwon, float -> int ȯ Լ ߰ - 
	int		nThValue		= 5;	// 2010-11-12 by khkim ޸:4 źμӵ 

	switch(i_nMemoryHackCheckTy)
	{
	case HACK_CHECK_TYPE_TOTALWEIGHT:
	case HACK_CHECK_TYPE_TRANSPORT:
	case HACK_CHECK_TYPE_POSITION:
	case HACK_CHECK_TYPE_REPEATTIME:	// 2008-06-26 by cmkwon, ( )ź æƮ  ޸ ɸ  ߰ (G0010300) - HACK_CHECK_TYPE_REPEATTIME üũ  ؾ Ѵ.
		{
			nValidValue		= (int)(i_fValidValue);
			nCurValue		= (int)(i_fCurrentValue);
			break;
		}
	default:
		break;
	}
#ifdef _WARRIOR_ANTICHEAT
	if ((nCurValue - nValidValue) > nValidValue)
	{
		bShouldRunAntiCheat = true;
		bAdvancedChecking = false;
	}
#endif
	// 2012-11-12 start by khkim ޸:4 źμӵ 
	switch(i_nMemoryHackCheckTy)
	{
	case HACK_CHECK_TYPE_REPEATTIME:
		{
			nThValue = 350;			// ӽù
			break;
		}							
	default:
		break;
	}
	// End 2012-11-12 by khkim ޸ źμӵ
#ifdef _WARRIOR_ANTICHEAT
if (bAdvancedChecking)
{
#endif
	if(nValidValue == nCurValue)
	{
		m_MemoryHackHistory.InsertResult(i_nMemoryHackCheckTy, i_pItemGen->Kind, FALSE);		// 2012-12-14 by hskim, ޸ ڵ   

		return FALSE;
	}

	///////////////////////////////////////////////////////////////////////////////
	// 밪 ؼ ̰ 5̻϶ ޸ 
	if(nValidValue > nCurValue)
	{
		if(labs(nValidValue - nCurValue) < nThValue) // 2010-11-12 by khkim ޸:4 źμӵ 
		{
			m_MemoryHackHistory.InsertResult(i_nMemoryHackCheckTy, i_pItemGen->Kind, FALSE);		// 2012-12-14 by hskim, ޸ ڵ   

			return FALSE;
		}
	}
	else
	{
		if(labs(nCurValue - nValidValue) < nThValue) // 2010-11-12 by khkim ޸:4 źμӵ 
		{
			m_MemoryHackHistory.InsertResult(i_nMemoryHackCheckTy, i_pItemGen->Kind, FALSE);		// 2012-12-14 by hskim, ޸ ڵ   

			return FALSE;
		}
	}
#ifdef _WARRIOR_ANTICHEAT
}
#endif
	int nItemKind	= i_pItemGen->Kind;
	int nItemNum	= i_pItemGen->ItemNum;
	int nItemUID	= i_pItemGen->UniqueNumber;

	if(IS_PRIMARY_WEAPON(i_pItemGen->Kind))
	{
		nItemKind	= ITEMKIND_PRIMARY_WEAPON_ALL;
	}
	else if(IS_SECONDARY_WEAPON(i_pItemGen->Kind))
	{
		nItemKind	= ITEMKIND_SECONDARY_WEAPON_ALL;
	}
		
	CAtumLogSender::SendLogMessageMemoryHack(this, nItemKind, nItemNum, nItemUID, i_nMemoryHackCheckTy, i_fValidValue, i_fCurrentValue, i_nParam1);
#ifdef _WARRIOR_ANTICHEAT
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Memory hack log inserted to DB! \r\n");//added

		if (bAdvancedChecking)
		{
			if (i_fValidValue != 0)
			{//if valid vlaue is 0 then its not hack

				if (i_fValidValue > 0)
				{
					g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Valid value bigger than 0 its not any bug - compare with current val and if it is hack ban it! \r\n");//added
				}
				if (nItemNum == 0)
				{//if itemnum is 0 - dont ban it
					g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] ItemNum is null -bug- dont ban it! \r\n");//added
					return FALSE;
				}
				if (nItemKind == 0)
				{//if itemkind is 0
					g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Item Kind is 0 - it's bug - not bananble! \r\n");//added
					return FALSE;
				}
				//after checks if not returned false yet then run anti cheat function
				bShouldRunAntiCheat = true;
			}
			else
			{
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Valid value is 0 - it shouldn't be banned! \r\n");//added
				return FALSE;
			}
		}

	if (bShouldRunAntiCheat)
	{
#define PROCEDURE_150303_0001 (UCHAR*)"{call dbo.atum_UpdateAccountHacksCount(?,?,?,?)}"
#define PROCEDURE_150303_0002 (UCHAR*)"{call dbo.atum_GetAccountHacksCount(?)}"
	CODBCStatement i_pODBCStmt;

	BOOL bRet = i_pODBCStmt.Init(g_pGlobalGameServer->GetDBServerIP(), g_pGlobalGameServer->GetDBServerPort(), g_pGlobalGameServer->GetDBServerDatabaseName(), (LPCSTR)g_pGlobalGameServer->GetODBCUID(), (LPCSTR)g_pGlobalGameServer->GetODBCPASSWORD(), g_pGlobalGameServer->GetMainWndHandle());
	if (!bRet)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Error] Connecting db failed ! \r\n");
	}

	SQLHSTMT hstmt = i_pODBCStmt.GetSTMTHandle();
	int isMooreThan = 5;
	int DBGetCount = 0;
	int nRetVal = 1;
	SQLRETURN ret = 0;
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//2015-03-03 by WarriorSW
	//procedures
	//AccountUniqueNumber - m_character.AccountUniqueNumber
	//AccountName - m_character.AccountName
	/********************************************************************************
	--!!!!
	-- Name: atum_UpdateAccountHacksCount
	-- Desc: // 2015-03-03 by WarriorSW, Update hacked counts for anti-cheat
	--====
	USE [atum2_db_1]
	GO
	SET ANSI_NULLS ON
	GO
	SET QUOTED_IDENTIFIER ON
	GO
	ALTER PROCEDURE [dbo].[atum_UpdateAccountHacksCount]
	@i_AccountUniqueNumber	INT,
	@i_AccountName			VARCHAR(20),
	@i_CharacterName		VARCHAR(20),
	@i_IP					VARCHAR(50)
	AS
	BEGIN
	IF NOT EXISTS(SELECT AccountName FROM atum2_db_account.dbo.td_AccountHacks WHERE AccountUniqueNumber = @i_AccountUniqueNumber)
	BEGIN
	INSERT INTO atum2_db_account.dbo.td_AccountHacks (AccountUniqueNumber, AccountName, CharacterName, IP, HackCount, HackedDate) VALUES (@i_AccountUniqueNumber, @i_AccountName, @i_CharacterName, @i_IP, '1', GetDate());
	END
	ELSE

	BEGIN
	UPDATE atum2_db_account.dbo.td_AccountHacks SET HackCount = HackCount + 1, HackedDate = GetDate() where AccountUniqueNumber = @i_AccountUniqueNumber
	END
	RETURN 1
	END
	********************************************************************************/

	//update hacked count query

	char				m_szIPLocal[SIZE_MAX_IPADDRESS];
	sprintf(m_szIPLocal, "%s", this->GetPeerIP());

	SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &m_character.AccountUniqueNumber, 0, NULL);
	SQLBindParameter(hstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, 20, 0, &m_character.AccountName, 0, NULL);
	SQLBindParameter(hstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, 20, 0, &m_character.CharacterName, 0, NULL);
	SQLBindParameter(hstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, 50, 0, &m_szIPLocal, 0, NULL);
	bRet = i_pODBCStmt.ExecuteQuery((char*)(PROCEDURE_150303_0001));
	if (FALSE == bRet)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Error] Updating hacked count failed ! Account(%s)[ID:%d] Character(%s) ip(%s) \r\n", m_character.AccountName, m_character.AccountUniqueNumber, m_character.CharacterName, m_szIPLocal);
		SQLFreeStmt(hstmt, SQL_CLOSE);
	}
	else
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Info] Updating hacked count ok ! Account(%s)[ID:%d] Character(%s) ip(%s) \r\n", m_character.AccountName, m_character.AccountUniqueNumber, m_character.CharacterName, m_szIPLocal);
		SQLFreeStmt(hstmt, SQL_CLOSE);
	}



	//end of update qry

	//get actually hacked times
	//get actually hacked times
	/************************************************************************
--------------------------------------------------------------------------------
-- PROCEDURE NAME	: dbo.atum_GetAccountHacksCount
-- DESC				: //2015-03-03 by WarriorSW, get hacked times for anti-cheat
--------------------------------------------------------------------------------
USE [atum2_db_1]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [dbo].[atum_GetAccountHacksCount]

@i_AccountUID		INT
AS
SELECT 0, HackCount FROM atum2_db_account.dbo.td_AccountHacks WHERE AccountUniqueNumber = @i_AccountUID
GO
************************************************************************/
	SQLINTEGER arrCB[15] = { SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS
		, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS, SQL_NTS };
	SQLBindParameter(hstmt, 1, SQL_PARAM_INPUT, SQL_C_LONG, SQL_INTEGER, 0, 0, &m_character.AccountUniqueNumber, 0, &arrCB[1]);
	bRet = i_pODBCStmt.ExecuteQuery((char*)(PROCEDURE_150303_0002));

	if (FALSE == bRet)
	{
		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Error] Getting hacked count failed ! Accountid(%d) ", m_character.AccountUniqueNumber);
		SQLFreeStmt(hstmt, SQL_CLOSE);
	}


	arrCB[1] = arrCB[2] = arrCB[3] = SQL_NTS;
	SQLBindCol(hstmt, 1, SQL_C_LONG, &nRetVal, 0, &arrCB[1]);
	SQLBindCol(hstmt, 2, SQL_C_USHORT, &DBGetCount, 0, &arrCB[2]);
	SQLBindCol(hstmt, 3, SQL_C_LONG, &isMooreThan, 0, &arrCB[3]);
	SQLSMALLINT    nColCnts = 0;
	while (TRUE)
	{
		SQLNumResultCols(hstmt, &nColCnts);
		if (nColCnts <= 0)
		{// 2008-07-25 by cmkwon, ResultCols 0 ̸  RowCount ̴ 
			ret = SQLMoreResults(hstmt);
			if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
			{
				break;
			}
			continue;
		}
		ret = SQLFetch(hstmt);
		if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
		{
			ret = SQLMoreResults(hstmt);                 // 2008-07-25 by cmkwon,  Results  ִ ѹ üũѴ.
			if (ret != SQL_SUCCESS && ret != SQL_SUCCESS_WITH_INFO)
			{
				break;
			}
			continue;
		}
		///////////////////////////////////////////////////////////////////////////////
		// 2008-07-25 by cmkwon, Results set ó
	}
	i_pODBCStmt.FreeStatement();

	///////////////////////////////////////////////////////////////////////////////
	// 0 ==> 
	// 1 ==> 			
	switch (nRetVal)
	{
		case 0:
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Info] Getting hacked count OK ! Accountid(%d) Count(%d) \r\n", m_character.AccountUniqueNumber, DBGetCount);
		}
		break;
		default:
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[Error] Fetching hacked count fail ! Accountid(%d) Count(%d) retval(%d) mt(%d)\r\n", m_character.AccountUniqueNumber, DBGetCount, nRetVal, isMooreThan);
		}
	}

	SQLFreeStmt(hstmt, SQL_CLOSE);


	//end of get actually hacked times

	if (DBGetCount < 0)
	{
		if (i_fCurrentValue < (0.01f) / 100)
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Current value is smaller than 0,01 its not possible to do normally - will be banned! Account(%s) Character(%s) \r\n", m_character.AccountName, m_character.CharacterName);
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Starting Ban procedure! \r\n");
			m_MemoryHackHistory.InsertResult(i_nMemoryHackCheckTy, i_pItemGen->Kind, TRUE);


			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Memory hack log checked - it will be banned! \r\n");
			if (FALSE == CheckCommandExecutability(RACE_OPERATION | RACE_GAMEMASTER))
			{
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[AutoBlockSystem] Ban Mode #1 (Hacking Client)! \r\n");
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[AutoBlock Debug] Its not a Admin/GM Account! \r\n");

				SBLOCKED_ACCOUNT_INFO blockedAccInfo;
				MEMSET_ZERO(&blockedAccInfo, sizeof(SBLOCKED_ACCOUNT_INFO));

				blockedAccInfo.AdminFieldServerClientIndex = GetCharacter()->ClientIndex;
				sprintf(blockedAccInfo.szBlockedAccountName, "%s", m_character.AccountName);
				sprintf(blockedAccInfo.szBlockAdminAccountName, "SW_AutoBlockSystem");
				blockedAccInfo.enBlockedType = T_BLOCKEDACCOUNT_MEMORYHACK_AUTOBLOCK;
				blockedAccInfo.atimeStartTime.SetCurrentDateTime();
				blockedAccInfo.atimeEndTime.SetDateTime(blockedAccInfo.atimeStartTime.Year + 2000, blockedAccInfo.atimeStartTime.Month, blockedAccInfo.atimeStartTime.Day, blockedAccInfo.atimeStartTime.Hour, blockedAccInfo.atimeStartTime.Minute, blockedAccInfo.atimeStartTime.Second);
				sprintf(blockedAccInfo.szBlockedReasonForUser, "Hacking DreamACE Client. Every hack will be banned automatically. \r\n DreamACE Team");
				sprintf(blockedAccInfo.szBlockedReasonForOnlyAdmin, "MemHack : HACK_CHECK_TYPE(%d)", i_nMemoryHackCheckTy);

				INIT_MSG_WITH_BUFFER(MSG_FP_ADMIN_BLOCKACCOUNT, T_FP_ADMIN_BLOCKACCOUNT, pBlockAcc, SendBuf);
				pBlockAcc->blockAccInfo = blockedAccInfo;
				ms_pFieldIOCP->Send2PreServerW(SendBuf, MSG_SIZE(MSG_FP_ADMIN_BLOCKACCOUNT));
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Another account banned automatically \r\n");
			}
			return TRUE;
		}

		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Starting Ban procedure! \r\n");
		m_MemoryHackHistory.InsertResult(i_nMemoryHackCheckTy, i_pItemGen->Kind, TRUE);

		g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Memory hack log checked - it will be banned! \r\n");
		if (FALSE == CheckCommandExecutability(RACE_OPERATION | RACE_GAMEMASTER))
		{

			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[AutoBlockSystem] Ban Mode #2 (Hacking Client)! \r\n");
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[AutoBlockSystem] Its not a Admin/GM Account - Ban it! \r\n");

			SBLOCKED_ACCOUNT_INFO blockedAccInfo;
			MEMSET_ZERO(&blockedAccInfo, sizeof(SBLOCKED_ACCOUNT_INFO));

			blockedAccInfo.AdminFieldServerClientIndex = GetCharacter()->ClientIndex;
			sprintf(blockedAccInfo.szBlockedAccountName, "%s", m_character.AccountName);
			sprintf(blockedAccInfo.szBlockAdminAccountName, "SW_AutoBlockSystem");
			blockedAccInfo.enBlockedType = T_BLOCKEDACCOUNT_MEMORYHACK_AUTOBLOCK;
			blockedAccInfo.atimeStartTime.SetCurrentDateTime();
			blockedAccInfo.atimeEndTime.SetDateTime(blockedAccInfo.atimeStartTime.Year + 2000, blockedAccInfo.atimeStartTime.Month, blockedAccInfo.atimeStartTime.Day, blockedAccInfo.atimeStartTime.Hour, blockedAccInfo.atimeStartTime.Minute, blockedAccInfo.atimeStartTime.Second);
			sprintf(blockedAccInfo.szBlockedReasonForUser, "Hacking DreamACE Client. Every hack will be banned automatically. \r\n DreamACE Team");
			sprintf(blockedAccInfo.szBlockedReasonForOnlyAdmin, "MemHack : HACK_CHECK_TYPE(%d)", i_nMemoryHackCheckTy);

			INIT_MSG_WITH_BUFFER(MSG_FP_ADMIN_BLOCKACCOUNT, T_FP_ADMIN_BLOCKACCOUNT, pBlockAcc, SendBuf);
			pBlockAcc->blockAccInfo = blockedAccInfo;
			ms_pFieldIOCP->Send2PreServerW(SendBuf, MSG_SIZE(MSG_FP_ADMIN_BLOCKACCOUNT));
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Another account banned automatically \r\n");
		}

	}
	else
	{
		if (i_fCurrentValue < (0.01f) / 100)
		{
			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Starting Kick procedure! \r\n");
			m_MemoryHackHistory.InsertResult(i_nMemoryHackCheckTy, i_pItemGen->Kind, TRUE);

			g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Memory hack log checked - it will be kicked! \r\n");
			if (FALSE == CheckCommandExecutability(RACE_OPERATION | RACE_GAMEMASTER))
			{

				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[AutoBlockSystem] Ban Mode #2 (Hacking Client)! \r\n");
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[AutoBlockSystem] Its not a Admin/GM Account - Ban it! \r\n");

				SBLOCKED_ACCOUNT_INFO blockedAccInfo;
				MEMSET_ZERO(&blockedAccInfo, sizeof(SBLOCKED_ACCOUNT_INFO));

				blockedAccInfo.AdminFieldServerClientIndex = GetCharacter()->ClientIndex;
				sprintf(blockedAccInfo.szBlockedAccountName, "%s", m_character.AccountName);
				sprintf(blockedAccInfo.szBlockAdminAccountName, "SW_AutoBlockSystem");
				blockedAccInfo.enBlockedType = T_BLOCKEDACCOUNT_MEMORYHACK_AUTOBLOCK;
				blockedAccInfo.atimeStartTime.SetCurrentDateTime();
				//kick
				blockedAccInfo.atimeEndTime.SetDateTime(blockedAccInfo.atimeStartTime.Year, blockedAccInfo.atimeStartTime.Month, blockedAccInfo.atimeStartTime.Day, blockedAccInfo.atimeStartTime.Hour, blockedAccInfo.atimeStartTime.Minute, blockedAccInfo.atimeStartTime.Second + 3);
				sprintf(blockedAccInfo.szBlockedReasonForUser, "Hacking DreamACE Client. Every hack will be banned automatically. \r\n DreamACE Team");
				sprintf(blockedAccInfo.szBlockedReasonForOnlyAdmin, "MemHack : HACK_CHECK_TYPE(%d)", i_nMemoryHackCheckTy);

				INIT_MSG_WITH_BUFFER(MSG_FP_ADMIN_BLOCKACCOUNT, T_FP_ADMIN_BLOCKACCOUNT, pBlockAcc, SendBuf);
				pBlockAcc->blockAccInfo = blockedAccInfo;
				ms_pFieldIOCP->Send2PreServerW(SendBuf, MSG_SIZE(MSG_FP_ADMIN_BLOCKACCOUNT));
				g_pFieldGlobal->WriteSystemLogEX(TRUE, "[INFO] Another account banned automatically \r\n");
			}
		}
	}
}
#endif

	return TRUE;
}




void CFieldIOCPSocket::InsertAttackTargetIndexVector(ClientIndex_t i_Index)
{
	if(FALSE == IS_MONSTER_CLIENT_INDEX(i_Index))
	{// 2009-12-11 by cmkwon,  ׷η Ÿ ϴ   - 
		return;
	}

	mt_auto_lock mtAuto(&m_mtvectAttackTargetMonsterIndex);
	
	if(i_Index == GetLastMonsterIndexAttack2Me())
	{// 2009-12-11 by cmkwon,  ׷η Ÿ ϴ   - 
		return;
	}

	vectorClientIndex::iterator it = find(m_mtvectAttackTargetMonsterIndex.begin(), m_mtvectAttackTargetMonsterIndex.end(), i_Index);
	if(it == m_mtvectAttackTargetMonsterIndex.end())
	{
		if(m_mtvectAttackTargetMonsterIndex.size() >= 20)
		{// Ÿ ε ִ 20 Ѵ

			m_mtvectAttackTargetMonsterIndex.erase(m_mtvectAttackTargetMonsterIndex.begin());
		}
		m_mtvectAttackTargetMonsterIndex.push_back(i_Index);		
	}	
	SetLastMonsterIndexAttack2Me(i_Index);

// 2009-12-10 by cmkwon, TEMP 
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TEMP] 091210 %s inserted MonsterIndex(%d) ListCnt(%d) AttckMonIdx(%d) TargetMonIdx(%d)\r\n"
//		, GetCharacterString(GetCharacter(), string()), i_Index, m_mtvectAttackTargetMonsterIndex.size(), GetLastMonsterIndexAttack2Me(), m_nTargetMonsterIndex);
}


void CFieldIOCPSocket::DeleteAttackTargetIndexVector(ClientIndex_t i_Index)
{
	mt_auto_lock mtAuto(&m_mtvectAttackTargetMonsterIndex);
	vectorClientIndex::iterator it = find(m_mtvectAttackTargetMonsterIndex.begin(), m_mtvectAttackTargetMonsterIndex.end(), i_Index);
	if(it != m_mtvectAttackTargetMonsterIndex.end())
	{
		m_mtvectAttackTargetMonsterIndex.erase(it);
	}

	// 2009-12-11 by cmkwon,  ׷η Ÿ ϴ   - 
	if(i_Index == GetLastMonsterIndexAttack2Me())
	{
		SetLastMonsterIndexAttack2Me(0);
	}
	if(i_Index == GetTargetMonsterIndex())
	{
		SetTargetMonsterIndex(0);
	}

// 2009-12-10 by cmkwon, TEMP 
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TEMP] 091210 %s deleted MonsterIndex(%d) ListCnt(%d) AttckMonIdx(%d) TargetMonIdx(%d)\r\n"
//		, GetCharacterString(GetCharacter(), string()), i_Index, m_mtvectAttackTargetMonsterIndex.size(), GetLastMonsterIndexAttack2Me(), m_nTargetMonsterIndex);
}


struct For_Each_DeleteMe_From_MonsterAttackedList
{
	For_Each_DeleteMe_From_MonsterAttackedList(ClientIndex_t nDelIdx, CFieldMapChannel *pFieldMapChannel):m_nDelIndex(nDelIdx), m_pFieldMapChannel(pFieldMapChannel){};
	void operator()(ClientIndex_t &index)
	{
		CFieldMonster *pMon = m_pFieldMapChannel->GetFieldMonster(index, 9);
		if(pMon)
		{
			pMon->DeleteAttackedInfowithIndex(m_nDelIndex);			
		}
	}
	CFieldMapChannel	*m_pFieldMapChannel;
	ClientIndex_t		m_nDelIndex;
};

void CFieldIOCPSocket::DeleteMeFromMonsterAttackedList(void)
{
	if(NULL == m_pCurrentFieldMapChannel){				return;}

	mt_auto_lock mtAuto(&m_mtvectAttackTargetMonsterIndex);
// 2009-12-10 by cmkwon, TEMP 
//	g_pFieldGlobal->WriteSystemLogEX(TRUE, "[TEMP] 091210 %s clear MonsterTargetList ListCnt(%d) AttckMonIdx(%d) TargetMonIdx(%d)\r\n"
//		, GetCharacterString(GetCharacter(), string()), m_mtvectAttackTargetMonsterIndex.size(), GetLastMonsterIndexAttack2Me(), m_nTargetMonsterIndex);

	if(m_mtvectAttackTargetMonsterIndex.empty())
	{
		return;
	}
	mtvectClientIndex_t		tempMtvect;
	tempMtvect.reserve(m_mtvectAttackTargetMonsterIndex.size());
	tempMtvect.insert(tempMtvect.begin()
		, m_mtvectAttackTargetMonsterIndex.begin(), m_mtvectAttackTargetMonsterIndex.end());
	m_mtvectAttackTargetMonsterIndex.clear();
	SetLastMonsterIndexAttack2Me(0);		// 2009-12-11 by cmkwon,  ׷η Ÿ ϴ   - 
	SetTargetMonsterIndex(0);				// 2009-12-11 by cmkwon,  ׷η Ÿ ϴ   - 
	mtAuto.auto_unlock_cancel();

	for_each(tempMtvect.begin(), tempMtvect.end()
		, For_Each_DeleteMe_From_MonsterAttackedList(m_character.ClientIndex, m_pCurrentFieldMapChannel));
	
}

BOOL CFieldIOCPSocket::SendAddDataBuffer(GBUFFER_SIZE_MAX_PACKET &i_gbuffer, EN_PACKET_PRIORITY i_enPacketPriority)
{
	return CIOCPSocket::SendAddData(i_gbuffer.GetPtr(), i_gbuffer.GetSize(), i_enPacketPriority);
}

BOOL CFieldIOCPSocket::IsTrivialMessageType(MessageType_t msgType)
{
	if (T0_FC_STRING			== HIBYTE(msgType) ||
		T0_FC_MOVE				== HIBYTE(msgType) ||
//		T0_FC_BATTLE			== HIBYTE(msgType) ||
		T0_FC_CHARACTER			== HIBYTE(msgType) ||
		T0_FC_ADMIN				== HIBYTE(msgType) ||
		T_FC_MONSTER_MOVE_OK	== msgType ||
		IS_ALIVE_MSG(msgType)
	)
	{
		return TRUE;
	}

	return FALSE;
}

#ifdef _DEBUG
// check: EVENT  MSG     !   ãƾ .
// check: SendInRangeXXX()  casting  CIOCPSocket::SendAddData() ٷ ȣϴ     ִ. 20040831, kelovon.
BOOL CFieldIOCPSocket::SendAddData(BYTE* pData, int nSize)
{
//	if (m_PeerSocketType == ST_CLIENT && COMPARE_BODYCON_BIT(m_character.BodyCondition, BODYCON_EVENT_HANDLE_MASK))
//	{
//		DBGOUT("SendAddData Failed: %s %d", GetCharacterString(&m_character, string()), m_PeerSocketType);
//		return FALSE;
//	}

	MessageType_t msgType = *(MessageType_t*)pData;

	if (m_PeerSocketType == ST_CLIENT_TYPE
		&& m_bSendMessgeTypeDBG
		&& !IsTrivialMessageType(msgType)
	)
	{
		SendString128(STRING_128_USER_NOTICE, "[F->C]%s", GetProtocolTypeString(msgType));
	}

	if (g_exchangeMsgPrintLevel != PRINTLEVEL_NO_MSG)
	{
		PrintExchangeMsg(SEND_TYPE, msgType, m_szPeerIP, m_PeerSocketType, GGetexchangeMsgPrintLevel());
	}

	return CIOCPSocket::SendAddData(pData, nSize);
}
#endif


void CFieldIOCPSocket::IncrementInsertingStoreCounts(void)
{
	this->m_dwLastTickInsertingStoreItem = timeGetTime();
	InterlockedIncrement(&this->m_nInsertingStoreItemCounts);
}

void CFieldIOCPSocket::DecrementInsertingStoreCounts(void)
{
	if(0 > InterlockedDecrement(&this->m_nInsertingStoreItemCounts))
	{
		this->m_nInsertingStoreItemCounts = 0;
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			void CFieldIOCPSocket::InfluenceWarCheckInvasion(void)
/// \brief		
/// \author		cmkwon
/// \date		2005-12-28 ~ 2005-12-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CFieldIOCPSocket::InfluenceWarCheckInvasion(void)
{
	///////////////////////////////////////////////////////////////////////////////
	// 2006-01-10 by cmkwon - ü üũϴ  ʺ üũ , ޽ ۵ θ 


	CFieldMapChannel *pFMChann = GetCurrentFieldMapChannel();
	if(NULL == pFMChann)
	{
		return;
	}

	// 2007-05-22 by cmkwon, Ϲݼµø(ī̸) 
	if(COMPARE_RACE(m_character.Race, RACE_OPERATION|RACE_GAMEMASTER)
		|| COMPARE_INFLUENCE(m_character.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{// 2006-01-10 by cmkwon, , GM üũ ʴ´, // 2007-05-22 by cmkwon, Ϲݼµ üũ ʴ´
		return;
	}

	int nMapInfl = GetCurrentFieldMapChannel()->GetMapInfluenceTypeW();
	// 2007-05-22 by cmkwon, Ϲݼµø(ī̸) 
	if(MAP_INFLUENCE_NEUTRALITY == nMapInfl
		|| IS_MAP_INFLUENCE_EVENT_AREA(nMapInfl)		// 2007-05-22 by cmkwon, ̺Ʈʵ üũ ʴ´
// 2009-10-12 by cmkwon, ī    - CFieldIOCPSocket::InfluenceWarCheckInvasion#, 
//		|| IS_SAME_CHARACTER_8_MAP_INFLUENCE(m_character.InfluenceType, nMapInfl))
		|| CAtumSJ::IsSameCharacterInfluence8MapInfluence(m_character.InfluenceType, nMapInfl))		// 2009-10-12 by cmkwon, ī    - 
	{// ߸ ̰ų ĳ  ¸̴.
		return;
