// INFItemMenuList.cpp: implementation of the CINFItemMenuList class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "AtumApplication.h"
#include "INFImage.h"
#include "GameDataLast.h"
#include "INFGameMain.h"
#include "Interface.h"
#include "AtumSound.h"
#include "D3DHanFont.h"
#include "INFCityBase.h"
#include "INFListBox.h"

#include "INFWorldRankWnd.h"
#include "INFImageEx.h"									   // 2011. 10. 10 by jskim UIý 
#include "INFGroupManager.h"
#include "INFGroupImage.h"

#include "AtumDatabase.h"


#include "INFItemMenuList.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CINFItemMenuList::CINFItemMenuList()
{
	m_pItemMixInfoBtn = NULL;		// 
	m_pArmorCollectionBtn = NULL;	// Ƹ ÷ ư // 2013-05-28 by bhsohn Ƹ ÷ ý

	m_nShowItemNum = 0;
	m_uItemUniNum = 0;

}

CINFItemMenuList::~CINFItemMenuList()
{
	SAFE_DELETE(m_pItemMixInfoBtn);		// 
	SAFE_DELETE(m_pArmorCollectionBtn);	// Ƹ ÷ ư // 2013-05-28 by bhsohn Ƹ ÷ ý

}

HRESULT CINFItemMenuList::InitDeviceObjects()
{
	char szUpBtn[30], szDownBtn[30], szSelBtn[30], szDisBtn[30];
	{
		wsprintf(szUpBtn, "reci_view3");
		wsprintf(szDownBtn, "reci_view1");
		wsprintf(szSelBtn, "reci_view0");
		wsprintf(szDisBtn, "reci_view2");
		
		if(NULL == m_pItemMixInfoBtn)
		{
			m_pItemMixInfoBtn = new CINFImageBtn;
			m_pItemMixInfoBtn->InitDeviceObjects(szUpBtn, szDownBtn, szSelBtn, szDisBtn);
		}			
	}
	// 2013-05-28 by bhsohn Ƹ ÷ ý
	{
		wsprintf(szUpBtn, "coll_view3");
		wsprintf(szDownBtn, "coll_view1");
		wsprintf(szSelBtn, "coll_view0");
		wsprintf(szDisBtn, "coll_view2");
		
		if(NULL == m_pArmorCollectionBtn)
		{
			m_pArmorCollectionBtn = new CINFImageBtn;
			m_pArmorCollectionBtn->InitDeviceObjects(szUpBtn, szDownBtn, szSelBtn, szDisBtn);
		}			
	}
	// END 2013-05-28 by bhsohn Ƹ ÷ ý
	return S_OK ;
}
HRESULT CINFItemMenuList::RestoreDeviceObjects()
{
	int nWidth = 0;
	int nHeight = 0;
	if(m_pItemMixInfoBtn)
	{
		m_pItemMixInfoBtn->RestoreDeviceObjects();	
		nWidth += m_pItemMixInfoBtn->GetImgSize().x;
		nHeight += m_pItemMixInfoBtn->GetImgSize().y;
	}
	// 2013-05-28 by bhsohn Ƹ ÷ ý
	if(m_pArmorCollectionBtn)
	{
		m_pArmorCollectionBtn->RestoreDeviceObjects();
		nHeight += m_pArmorCollectionBtn->GetImgSize().y;
	}	
	SetSize(nWidth, nHeight);
	// END 2013-05-28 by bhsohn Ƹ ÷ ý

	return S_OK ;
}

HRESULT CINFItemMenuList::DeleteDeviceObjects()
{
	if(m_pItemMixInfoBtn)
	{
		m_pItemMixInfoBtn->DeleteDeviceObjects();
		SAFE_DELETE(m_pItemMixInfoBtn);
	}
	// 2013-05-28 by bhsohn Ƹ ÷ ý
	if(m_pArmorCollectionBtn)
	{
		m_pArmorCollectionBtn->DeleteDeviceObjects();
		SAFE_DELETE(m_pArmorCollectionBtn);
	}
	// END 2013-05-28 by bhsohn Ƹ ÷ ý

	return S_OK ;
}

HRESULT CINFItemMenuList::InvalidateDeviceObjects()
{
	if(m_pItemMixInfoBtn)
	{
		m_pItemMixInfoBtn->InvalidateDeviceObjects();		
	}
	// 2013-05-28 by bhsohn Ƹ ÷ ý
	if(m_pArmorCollectionBtn)
	{
		m_pArmorCollectionBtn->InvalidateDeviceObjects();		
	}
	// END 2013-05-28 by bhsohn Ƹ ÷ ý

	return S_OK ;
}

void CINFItemMenuList::Render()
{
	if(!IsShowWnd())
	{
		return;
	}

	if(m_pItemMixInfoBtn)
	{
		m_pItemMixInfoBtn->Render();		
	}
	// 2013-05-28 by bhsohn Ƹ ÷ ý
	if(m_pArmorCollectionBtn)
	{
		m_pArmorCollectionBtn->Render();		
	}
	// END 2013-05-28 by bhsohn Ƹ ÷ ý
	CINFDefaultWnd::Render();
}
void CINFItemMenuList::Tick()
{
	if(!IsShowWnd())
	{
		return;
	}

	CINFDefaultWnd::Tick();

}

void CINFItemMenuList::ShowWnd(BOOL bShowWnd, INT nShowItemNum, UID64_t uItemUniNum, POINT *ptPos/*=NULL*/, int nWndWidth/*=0*/)
{
	m_nShowItemNum = nShowItemNum;
	m_uItemUniNum = uItemUniNum;

	CINFDefaultWnd::ShowWnd(bShowWnd, ptPos, nWndWidth);	

	if(bShowWnd)
	{
		UpdateBtnPos(0, 0);		// ư ġ 		
	}
}

int CINFItemMenuList::WndProc(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if(!IsShowWnd())
	{
		return INF_MSGPROC_NORMAL;
	}
	switch(uMsg)
	{
	case WM_LBUTTONUP:
		{
			return OnLButtonUp(uMsg, wParam, lParam);
		}
		break;
	case WM_LBUTTONDOWN:
		{
			return OnLButtonDown(uMsg, wParam, lParam);
		}
		break;
	case WM_MOUSEMOVE:
		{
			return OnMouseMove(uMsg, wParam, lParam);
		}
		break;	
	}
	
	return INF_MSGPROC_NORMAL;

}
void CINFItemMenuList::UpdateBtnPos(int nWidth, int nHeight)
{
	int nPosY = m_ptBkPos.y;

	BOOL bShowMixInfo, bShowArmorCollect;
	bShowMixInfo = bShowArmorCollect = FALSE;;

#ifdef C_INGAME_MIX_ITEM
	bShowMixInfo = TRUE;
#endif

#ifdef SC_COLLECTION_ARMOR_JHSEOL_BCKIM
	bShowArmorCollect = FALSE;
	ITEM* pItem = g_pDatabase->GetItemInfoLoadItemData(m_nShowItemNum);
	if(pItem && (ITEMKIND_DEFENSE == pItem->Kind))
	{		 
		bShowArmorCollect = TRUE;
	}

	// Ʒ ȵǰ
	if(g_pD3dApp->GetArenaState() == ARENA_STATE_ARENA_GAMING)
	{
		bShowArmorCollect = FALSE;
	}
#endif
	
	if(bShowMixInfo && m_pItemMixInfoBtn)
	{
		m_pItemMixInfoBtn->ShowWindow(TRUE);
		m_pItemMixInfoBtn->SetBtnPosition(m_ptBkPos.x, m_ptBkPos.y);
		nPosY += m_pItemMixInfoBtn->GetImgSize().y;
	}
	else if(m_pItemMixInfoBtn)
	{
		m_pItemMixInfoBtn->ShowWindow(FALSE);
	}
	// 2013-05-28 by bhsohn Ƹ ÷ ý
	if(bShowArmorCollect && m_pArmorCollectionBtn)
	{
//		nPosY -= 3;
		m_pArmorCollectionBtn->ShowWindow(TRUE);
		m_pArmorCollectionBtn->SetBtnPosition(m_ptBkPos.x, nPosY );
	}
	else if(m_pArmorCollectionBtn)
	{
		m_pArmorCollectionBtn->ShowWindow(FALSE);
	}
	// END 2013-05-28 by bhsohn Ƹ ÷ ý

//	CINFDefaultWnd::UpdateBtnPos(nWidth, nHeight);		
}

int CINFItemMenuList::OnLButtonUp(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	POINT pt;
	pt.x = LOWORD(lParam);
	pt.y = HIWORD(lParam);
	CheckMouseReverse(&pt);
	
	{
		if(m_bMove)
		{
			m_bMove = FALSE;
			return INF_MSGPROC_BREAK;
		}		
	}		
	if(m_pItemMixInfoBtn && TRUE == m_pItemMixInfoBtn->OnLButtonUp(pt))
	{	
		g_pGameMain->OnClickItemMixWnd(TRUE, m_nShowItemNum, m_uItemUniNum);
		g_pD3dApp->m_pSound->PlayD3DSound(SOUND_SELECT_BUTTON, D3DXVECTOR3(0,0,0), FALSE);
		ShowWnd(FALSE, 0, 0);
		
		return  INF_MSGPROC_BREAK;
	}	
	
	// 2013-05-28 by bhsohn Ƹ ÷ ý
	if(m_pArmorCollectionBtn && TRUE == m_pArmorCollectionBtn->OnLButtonUp(pt))
	{			
		g_pGameMain->OnClickArmorCollectionWnd(TRUE, m_nShowItemNum, m_uItemUniNum);
		g_pD3dApp->m_pSound->PlayD3DSound(SOUND_SELECT_BUTTON, D3DXVECTOR3(0,0,0), FALSE);
		ShowWnd(FALSE, 0, 0);
		
		return  INF_MSGPROC_BREAK;
	}	
	// END 2013-05-28 by bhsohn Ƹ ÷ ý
	
	if(!IsWndRect(pt) && !m_bMove)
	{
		return INF_MSGPROC_NORMAL;
	}
	
	return INF_MSGPROC_NORMAL;
}

int CINFItemMenuList::OnLButtonDown(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	POINT pt;
	pt.x = LOWORD(lParam);
	pt.y = HIWORD(lParam);
	CheckMouseReverse(&pt);	
	
	if(!IsWndRect(pt) && !m_bMove)
	{
		ShowWnd(FALSE,0, 0); // ٸ Ŭ  
		return INF_MSGPROC_NORMAL;
	}
	
	
	{
		if(m_pItemMixInfoBtn && TRUE == m_pItemMixInfoBtn->OnLButtonDown(pt))
		{
			// ư 콺 ִ.
			return  INF_MSGPROC_BREAK;
		}		
	}	
	
	// 2013-05-28 by bhsohn Ƹ ÷ ý
	{
		if(m_pArmorCollectionBtn && TRUE == m_pArmorCollectionBtn->OnLButtonDown(pt))
		{
			// ư 콺 ִ.
			return  INF_MSGPROC_BREAK;
		}		
	}
	// END 2013-05-28 by bhsohn Ƹ ÷ ý
	
	return INF_MSGPROC_NORMAL;
	
	
}

int CINFItemMenuList::OnMouseMove(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	POINT pt;
	pt.x = LOWORD(lParam);
	pt.y = HIWORD(lParam);
	CheckMouseReverse(&pt);		

	// 2013-05-28 by bhsohn Ƹ ÷ ý
	BOOL bRtn = m_pItemMixInfoBtn->OnMouseMove(pt);	
	if(m_pArmorCollectionBtn )
	{
		bRtn |= m_pArmorCollectionBtn->OnMouseMove(pt);
	}
	
	if(bRtn)	
	{
		g_pGameMain->SetToolTip(0,0,NULL);
		g_pGameMain->SetItemInfoUser( NULL, 0, 0 );
		
		return INF_MSGPROC_BREAK;
	}
	// END 2013-05-28 by bhsohn Ƹ ÷ ý

	if(!IsWndRect(pt) && !m_bMove)
	{
		return INF_MSGPROC_NORMAL;
	}
	
	{
		if(m_bMove)
		{
			m_ptBkPos.x = pt.x - m_ptCommOpMouse.x;
			m_ptBkPos.y = pt.y - m_ptCommOpMouse.y;				
			// UI  
			//UpdateBtnPos();
			return INF_MSGPROC_BREAK;
		}
	}
	return INF_MSGPROC_NORMAL;
	
}