#include "StdAfx.h"
#include "GLogDataAccountInfo.h"

CGLogDataAccountInfo::CGLogDataAccountInfo(_RecordsetPtr i_pSourceRecordSet,_CommandPtr i_pSourceCommand,_RecordsetPtr i_pDestRecordSet,_CommandPtr i_pDestCommand)
{
	this->Init(i_pSourceRecordSet,i_pSourceCommand,i_pDestRecordSet,i_pDestCommand);
}

CGLogDataAccountInfo::~CGLogDataAccountInfo(void)
{
}

void CGLogDataAccountInfo::ResetData()
{
	MEMSET_ZERO(m_arrAccountInfo,sizeof(CAccountInfo)*GLOG_DATA_MAX_CNT);
}

Err_t CGLogDataAccountInfo::GLogProcessing()
{
	int SelectCnt = 0;
	Err_t Err =	this->GLogDBSelect(&SelectCnt);
	if(ERR_NO_ERROR != Err)
	{
		return this->ErrorProcessing(Err);
	}
	g_pLogGlobal->m_pGlobalLogManager->WriteSystemLog(L"============== GLog CGLogDataAccountInfo Select Fin!!! ==============\r\n",TRUE);

	//Insert & Delete ྿ ó.
	for(int Cnt = 0 ; Cnt < SelectCnt; Cnt++)
	{
		Err = this->GLogDBInsert(Cnt);
		if(ERR_NO_ERROR != Err
			&& ERR_DB_COM_DUPLICATE_INSERT != Err)
		{
			return this->ErrorProcessing(Err);
		}

		Err = this->GLogDBDelete(Cnt);
		if(ERR_NO_ERROR != Err)
		{
			return this->ErrorProcessing(Err);
		}
	}
	g_pLogGlobal->m_pGlobalLogManager->WriteSystemLog(L"============== GLog CGLogDataAccountInfo Update Fin!!! ==============\r\n",TRUE);

	this->ResetData();
	return ERR_NO_ERROR;
}

Err_t CGLogDataAccountInfo::GLogDBSelect(int * o_pSelectCnt)
{
	m_pSourceCommand->CommandText = QDB_GLOG_ACCOUNT_INFO_SELECT;
	try
	{
		m_pSourceRecordSet = m_pSourceCommand->Execute(NULL,NULL,adCmdStoredProc);  //  select մϴ.
	}
	catch(_com_error& e)
	{
		return ErrorLog(L"CGLogDataAccountInfo",e);
	}

	if(m_pSourceRecordSet->EndOfFile)     
	{
		m_pSourceRecordSet->Close();   // ڵ ݴ´.(׻ ڵ  Ŀ ݾִ ۾ ؾ մϴ.)
		return ERR_DB_NO_DATA;
	}   

	int				nCnt = 0;
	CAccountInfo	tmpAccountInfo;
	// ȸ ڵ    ͸ Ȯմϴ.
	while(!m_pSourceRecordSet->EndOfFile)
	{	
		tmpAccountInfo.RegisteredDate		= m_pSourceRecordSet->Fields->GetItem("RegisteredDate")->GetValue();	
		tmpAccountInfo.Jointype				= m_pSourceRecordSet->Fields->GetItem("Jointype")->GetValue();
		tmpAccountInfo.AccountUniqueNumber	= m_pSourceRecordSet->Fields->GetItem("AccountUniqueNumber")->GetValue();
		LSTRNCPY_OLEDB(tmpAccountInfo.AccountName,m_pSourceRecordSet->Fields->GetItem("AccountName")->GetValue());
		LSTRNCPY_OLEDB(tmpAccountInfo.ExtCertifyCode,m_pSourceRecordSet->Fields->GetItem("ExtCertifyCode")->GetValue());	// 2014-02-24 by bckim, äθ

		memcpy(&m_arrAccountInfo[nCnt],&tmpAccountInfo,sizeof(CAccountInfo));
		MEMSET_ZERO(&tmpAccountInfo,sizeof(CAccountInfo));
		// Ʈ Ʈ ߰ϼ̰ų ȭ鿡 Ͻ  ôٸ 
		//    äִ ۾ ̺κп Ͻø ˴ϴ.
		m_pSourceRecordSet->MoveNext();    // ڵ  ̵ŵϴ.
		nCnt++;
	}

	*o_pSelectCnt = nCnt;
	m_pSourceRecordSet->Close();           // ڵ ݾݴϴ.
	return ERR_NO_ERROR;
}

Err_t CGLogDataAccountInfo::GLogDBInsert(int i_nCnt)
{

	try
	{
		// ν 
		m_pDestCommand->CommandText = QDB_GLOG_ACCOUNT_INFO_INSERT;

		// ν  ڰ 
		this->DBInsertParametersAppend(i_nCnt);

		// ν 
		m_pDestCommand->Execute(NULL,NULL,adCmdStoredProc);

		// ڰ ʱȭ
		this->DBInsertParametersDelete();
	}
	catch(_com_error& e)
	{
		// ڰ ʱȭ
		this->DBInsertParametersDelete();
		return ErrorLog(L"CGLogDataCAccountInfo",e);
	}
	return ERR_NO_ERROR;
}

Err_t CGLogDataAccountInfo::GLogDBDelete(int i_nCnt)
{
	try
	{
		// ν 
		m_pSourceCommand->CommandText = QDB_GLOG_ACCOUNT_INFO_DELETE;

		// ν  ڰ 
		m_pSourceCommand->Parameters->Append(m_pSourceCommand->CreateParameter(_bstr_t("AccountUniqueNumber"),adBigInt,adParamInput,8,_variant_t(m_arrAccountInfo[i_nCnt].AccountUniqueNumber)));

		// ν 
		m_pSourceCommand->Execute(NULL,NULL,adCmdStoredProc);
		// ڰ ʱȭ
		m_pSourceCommand->Parameters->Delete(_bstr_t("AccountUniqueNumber"));
	}
	catch(_com_error& e)
	{
		return ErrorLog(L"CGLogDataCAccountInfoPlayTime",e);
	}
	return ERR_NO_ERROR;
}

void CGLogDataAccountInfo::DBInsertParametersAppend(int i_nCnt)
{
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("RegisteredDate"),adDate,adParamInput,8,_variant_t(m_arrAccountInfo[i_nCnt].RegisteredDate)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("Jointype"),adInteger,adParamInput,0,_variant_t(m_arrAccountInfo[i_nCnt].Jointype)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("AccountUniqueNumber"),adBigInt,adParamInput,8,_variant_t(m_arrAccountInfo[i_nCnt].AccountUniqueNumber)));
	VARIANT vAccountName;
	vAccountName.vt = VT_BSTR;
	vAccountName.bstrVal = _bstr_t(m_arrAccountInfo[i_nCnt].AccountName); 
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("AccountName"),adWChar,adParamInput,SIZE_MAX_ACCOUNT_NAME+1,vAccountName));

	// 2014-02-24 by bckim, äθ
	VARIANT vExtCertifyCode;
	vExtCertifyCode.vt = VT_BSTR;
	vExtCertifyCode.bstrVal = _bstr_t(m_arrAccountInfo[i_nCnt].ExtCertifyCode); 
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("ExtCertifyCode"),adWChar,adParamInput,USER_CI_SIZE+1,vExtCertifyCode));
	// End.2014-02-24 by bckim, äθ

}

void CGLogDataAccountInfo::DBInsertParametersDelete()
{
	m_pDestCommand->Parameters->Delete(_bstr_t("Jointype"));
	m_pDestCommand->Parameters->Delete(_bstr_t("RegisteredDate"));		
	m_pDestCommand->Parameters->Delete(_bstr_t("AccountUniqueNumber"));
	m_pDestCommand->Parameters->Delete(_bstr_t("AccountName"));
	m_pDestCommand->Parameters->Delete(_bstr_t("ExtCertifyCode"));		// 2014-02-24 by bckim, äθ
}
