/////////////////////////////////////////////////
// 2014-02-24 by bckim, Glog_ƮƮ
/////////////////////////////////////////////////

#include "StdAfx.h"
#include "GlogBugTrap.h"

CGLogBugTrap::CGLogBugTrap(_RecordsetPtr i_pSourceRecordSet,_CommandPtr i_pSourceCommand,_RecordsetPtr i_pDestRecordSet,_CommandPtr i_pDestCommand)
{
	this->Init(i_pSourceRecordSet,i_pSourceCommand,i_pDestRecordSet,i_pDestCommand);
}

CGLogBugTrap::~CGLogBugTrap(void)
{
}

void CGLogBugTrap::ResetData()
{
	MEMSET_ZERO(m_arrBugTrap,sizeof(CAccountInfo)*GLOG_DATA_MAX_CNT);
}

Err_t CGLogBugTrap::GLogProcessing()
{
	int SelectCnt = 0;
	Err_t Err =	this->GLogDBSelect(&SelectCnt);
	if(ERR_NO_ERROR != Err)
	{
		return this->ErrorProcessing(Err);
	}
	g_pLogGlobal->m_pGlobalLogManager->WriteSystemLog(L"============== GLog CGLogBugTrap Select Fin!!! ==============\r\n",TRUE);

	//Insert & Delete ྿ ó.
	for(int Cnt = 0 ; Cnt < SelectCnt; Cnt++)
	{
		Err = this->GLogDBInsert(Cnt);
		if(ERR_NO_ERROR != Err
			&& ERR_DB_COM_DUPLICATE_INSERT != Err)
		{
			return this->ErrorProcessing(Err);
		}

		Err = this->GLogDBDelete(Cnt);
		if(ERR_NO_ERROR != Err)
		{
			return this->ErrorProcessing(Err);
		}
	}
	g_pLogGlobal->m_pGlobalLogManager->WriteSystemLog(L"============== GLog CGLogBugTrap Update Fin!!! ==============\r\n",TRUE);

	this->ResetData();
	return ERR_NO_ERROR;
}

Err_t CGLogBugTrap::GLogDBSelect(int * o_pSelectCnt)
{
	m_pSourceCommand->CommandText = QDB_GLOG_BUGTRAP_INFO_SELECT;		//		L"GLog_Bugtrap_Select"				// ٿ  
	try
	{
		m_pSourceRecordSet = m_pSourceCommand->Execute(NULL,NULL,adCmdStoredProc);  //  select մϴ.
	}
	catch(_com_error& e)
	{
		return ErrorLog(L"CGLogBugTrap",e);
	}

	if(m_pSourceRecordSet->EndOfFile)     
	{
		m_pSourceRecordSet->Close();   // ڵ ݴ´.(׻ ڵ  Ŀ ݾִ ۾ ؾ մϴ.)
		return ERR_DB_NO_DATA;
	}   

	int				nCnt = 0;
	CBugTrap	tmpBugTrap;
	// ȸ ڵ    ͸ Ȯմϴ.
	while(!m_pSourceRecordSet->EndOfFile)
	{		
		tmpBugTrap.UID						= m_pSourceRecordSet->Fields->GetItem("UID")->GetValue();	
		tmpBugTrap.LogType					= m_pSourceRecordSet->Fields->GetItem("LogType")->GetValue();
		tmpBugTrap.LoginDate				= m_pSourceRecordSet->Fields->GetItem("LoginDate")->GetValue();
		tmpBugTrap.PlayTime					= m_pSourceRecordSet->Fields->GetItem("PlayTime")->GetValue();	
		tmpBugTrap.ClosedDate				= m_pSourceRecordSet->Fields->GetItem("ClosedDate")->GetValue();	
		tmpBugTrap.CloseType				= m_pSourceRecordSet->Fields->GetItem("CloseType")->GetValue();	
		LSTRNCPY_OLEDB(tmpBugTrap.IP,m_pSourceRecordSet->Fields->GetItem("IP")->GetValue());
		tmpBugTrap.AccountUID				= m_pSourceRecordSet->Fields->GetItem("AccountUID")->GetValue();	
		LSTRNCPY_OLEDB(tmpBugTrap.AccountName,m_pSourceRecordSet->Fields->GetItem("AccountName")->GetValue());	
		tmpBugTrap.CharacterUID				= m_pSourceRecordSet->Fields->GetItem("CharacterUID")->GetValue();			
		LSTRNCPY_OLEDB(tmpBugTrap.CharacterName,m_pSourceRecordSet->Fields->GetItem("CharacterName")->GetValue());
		tmpBugTrap.MapIndex					= m_pSourceRecordSet->Fields->GetItem("MapIndex")->GetValue();
		tmpBugTrap.ChannelIndex				= m_pSourceRecordSet->Fields->GetItem("ChannelIndex")->GetValue();
		tmpBugTrap.PositionX				= m_pSourceRecordSet->Fields->GetItem("PositionX")->GetValue();	
		tmpBugTrap.PositionY				= m_pSourceRecordSet->Fields->GetItem("PositionY")->GetValue();
		tmpBugTrap.PositionZ				= m_pSourceRecordSet->Fields->GetItem("PositionZ")->GetValue();
		tmpBugTrap.ServerGroupID			= m_pSourceRecordSet->Fields->GetItem("ServerGroupID")->GetValue();
		LSTRNCPY_OLEDB(tmpBugTrap.ServerCroupName,m_pSourceRecordSet->Fields->GetItem("ServerGroupName")->GetValue());
		LSTRNCPY_OLEDB(tmpBugTrap.PublisherName,m_pSourceRecordSet->Fields->GetItem("PublisherName")->GetValue());
		

		memcpy(&m_arrBugTrap[nCnt],&tmpBugTrap,sizeof(CBugTrap));
		MEMSET_ZERO(&tmpBugTrap,sizeof(CBugTrap));
		// Ʈ Ʈ ߰ϼ̰ų ȭ鿡 Ͻ  ôٸ 
		//    äִ ۾ ̺κп Ͻø ˴ϴ.
		m_pSourceRecordSet->MoveNext();    // ڵ  ̵ŵϴ.
		nCnt++;
	}

	*o_pSelectCnt = nCnt;
	m_pSourceRecordSet->Close();           // ڵ ݾݴϴ.
	return ERR_NO_ERROR;
}

Err_t CGLogBugTrap::GLogDBInsert(int i_nCnt)
{

	try
	{
		// ν 
		m_pDestCommand->CommandText = QDB_GLOG_BUGTRAP_INFO_INSERT;			// 	#define QDB_GLOG_BUGTRAP_INFO_INSERT		L"usp_GLOG_INSERT_BUGTRAP"	//   

		// ν  ڰ 
		this->DBInsertParametersAppend(i_nCnt);

		// ν 
		m_pDestCommand->Execute(NULL,NULL,adCmdStoredProc);

		// ڰ ʱȭ
		this->DBInsertParametersDelete();
	}
	catch(_com_error& e)
	{
		// ڰ ʱȭ
		this->DBInsertParametersDelete();
		return ErrorLog(L"CGLogBugTrap",e);
	}
	return ERR_NO_ERROR;
}

Err_t CGLogBugTrap::GLogDBDelete(int i_nCnt)
{
	try
	{
		// ν 
		m_pSourceCommand->CommandText = QDB_GLOG_BUGTRAP_INFO_DELETE;		// #define QDB_GLOG_BUGTRAP_INFO_DELETE		L"GLog_Bugtrap_Delete"				// ٿ  

		// ν  ڰ 
		m_pSourceCommand->Parameters->Append(m_pSourceCommand->CreateParameter(_bstr_t("UID"),adBigInt,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].UID)));

		// ν 
		m_pSourceCommand->Execute(NULL,NULL,adCmdStoredProc);
		// ڰ ʱȭ
		m_pSourceCommand->Parameters->Delete(_bstr_t("UID"));
	}
	catch(_com_error& e)
	{
		return ErrorLog(L"CGLogBugTrap",e);
	}
	return ERR_NO_ERROR;
}

void CGLogBugTrap::DBInsertParametersAppend(int i_nCnt)
{
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("UID"),adBigInt,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].UID)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("LogType"),adTinyInt,adParamInput,0,_variant_t(m_arrBugTrap[i_nCnt].LogType)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("LoginDate"),adDate,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].LoginDate)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("PlayTime"),adBigInt,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].PlayTime)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("ClosedDate"),adDate,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].ClosedDate)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("CloseType"),adTinyInt,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].CloseType)));
	
	VARIANT vIP;
	vIP.vt = VT_BSTR;
	vIP.bstrVal = _bstr_t(m_arrBugTrap[i_nCnt].IP); 
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("IP"),adWChar,adParamInput,SIZE_MAX_GAME_SERVER_IP+1,vIP));
	
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("AccountUID"),adInteger,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].AccountUID)));
	
	VARIANT vAccountName;
	vAccountName.vt = VT_BSTR;
	vAccountName.bstrVal = _bstr_t(m_arrBugTrap[i_nCnt].AccountName); 
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("AccountName"),adWChar,adParamInput,SIZE_MAX_ACCOUNT_NAME+1,vAccountName));
	
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("CharacterUID"),adInteger,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].CharacterUID)));
	
	VARIANT vCharacterName;
	vCharacterName.vt = VT_BSTR;
	vCharacterName.bstrVal = _bstr_t(m_arrBugTrap[i_nCnt].CharacterName); 
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("CharacterName"),adWChar,adParamInput,SIZE_MAX_ACCOUNT_NAME+1,vCharacterName));

	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("MapIndex"),adInteger,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].MapIndex)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("ChannelIndex"),adInteger,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].ChannelIndex)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("PositionX"),adInteger,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].PositionX)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("PositionY"),adInteger,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].PositionY)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("PositionZ"),adInteger,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].PositionZ)));
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("ServerGroupID"),adInteger,adParamInput,8,_variant_t(m_arrBugTrap[i_nCnt].ServerGroupID)));

	VARIANT vServerGroupName;
	vServerGroupName.vt = VT_BSTR;
	vServerGroupName.bstrVal = _bstr_t(m_arrBugTrap[i_nCnt].ServerCroupName); 
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("ServerGroupName"),adWChar,adParamInput,SIZE_MAX_GAME_SERVER_NAME+1,vServerGroupName));

	VARIANT vPublisherName;
	vPublisherName.vt = VT_BSTR;
	vPublisherName.bstrVal = _bstr_t(m_arrBugTrap[i_nCnt].PublisherName); 
	m_pDestCommand->Parameters->Append(m_pDestCommand->CreateParameter(_bstr_t("PublisherName"),adWChar,adParamInput,SIZE_MAX_GAME_PUBLISHER_NAME+1,vPublisherName));
}

void CGLogBugTrap::DBInsertParametersDelete()
{
	m_pDestCommand->Parameters->Delete(_bstr_t("UID"));
	m_pDestCommand->Parameters->Delete(_bstr_t("LogType"));		
	m_pDestCommand->Parameters->Delete(_bstr_t("LoginDate"));
	m_pDestCommand->Parameters->Delete(_bstr_t("PlayTime"));
	m_pDestCommand->Parameters->Delete(_bstr_t("ClosedDate"));		
	m_pDestCommand->Parameters->Delete(_bstr_t("CloseType"));
	m_pDestCommand->Parameters->Delete(_bstr_t("IP"));		
	m_pDestCommand->Parameters->Delete(_bstr_t("AccountUID"));
	m_pDestCommand->Parameters->Delete(_bstr_t("AccountName"));
	m_pDestCommand->Parameters->Delete(_bstr_t("CharacterUID"));		
	m_pDestCommand->Parameters->Delete(_bstr_t("CharacterName"));
	m_pDestCommand->Parameters->Delete(_bstr_t("MapIndex"));		
	m_pDestCommand->Parameters->Delete(_bstr_t("ChannelIndex"));
	m_pDestCommand->Parameters->Delete(_bstr_t("PositionX"));
	m_pDestCommand->Parameters->Delete(_bstr_t("PositionY"));		
	m_pDestCommand->Parameters->Delete(_bstr_t("PositionZ"));
	m_pDestCommand->Parameters->Delete(_bstr_t("ServerGroupID"));		
	m_pDestCommand->Parameters->Delete(_bstr_t("ServerGroupName"));
	m_pDestCommand->Parameters->Delete(_bstr_t("PublisherName"));
}
