/*--
	Copyright (C) 2007-2010 Wellbia.com Co., Ltd.

	Module Name:
		zwave_sdk_errors.h

	Abstract:
		XIGNCODE for Server Error Codeds

	Author:
		2010-10-18 HyunOh Kim <zextor@wellbia.com>

	Environment:
		any

	Library:
		none

--*/

#include "xtypes.h"

//================================================
// Define Error Code
//------------------------------------------------

#define XM_COREDB 170 /// AA
#define XM_SERVER 171 /// AB
#define XM_LINKER	172 /// AC


/// COREDB GENERAL
#define ZWAVE_STATUS_INVALID_PARAM					MAKE_E_XSTATUS(XM_COREDB, 1)
#define ZWAVE_STATUS_FAIL_CREATE_EVENT				MAKE_E_XSTATUS(XM_COREDB, 2)
#define ZWAVE_STATUS_FAIL_CREATE_THREAD				MAKE_E_XSTATUS(XM_COREDB, 3)
#define ZWAVE_STATUS_FAIL_LOAD_MODULES				MAKE_E_XSTATUS(XM_COREDB, 4)
#define ZWAVE_STATUS_NOT_ENOUGH_MEMORY				MAKE_E_XSTATUS(XM_COREDB, 5)
#define ZWAVE_STATUS_FAIL_READ_FILE					MAKE_E_XSTATUS(XM_COREDB, 6)
#define ZWAVE_STATUS_MISSING_HANDLER				MAKE_E_XSTATUS(XM_COREDB, 7)
#define ZWAVE_STATUS_NCB_NOT_MATCH_SIG				MAKE_E_XSTATUS(XM_COREDB, 8)
#define ZWAVE_STATUS_NCB_NO_MATCH_LIC				MAKE_E_XSTATUS(XM_COREDB, 9)
#define ZWAVE_STATUS_ZCEV_XLOADER_FAIL				MAKE_E_XSTATUS(XM_COREDB, 10)
#define ZWAVE_STATUS_ZCEV_LOAD_FAIL					MAKE_E_XSTATUS(XM_COREDB, 11)
#define ZWAVE_STATUS_ZCEV_INTERFACE_NOT_MATCH		MAKE_E_XSTATUS(XM_COREDB, 12)
#define ZWAVE_STATUS_ZCEV_INIT_FAIL					MAKE_E_XSTATUS(XM_COREDB, 13)
#define ZWAVE_STATUS_ZCEV_FAIL_GET_CRC				MAKE_E_XSTATUS(XM_COREDB, 14)
#define ZWAVE_STATUS_ZCEV_CRC_WRONG					MAKE_E_XSTATUS(XM_COREDB, 15)
#define ZWAVE_STATUS_ZCEV_SIGNATURE_WRONG			MAKE_E_XSTATUS(XM_COREDB, 16)
#define ZWAVE_STATUS_NOT_EXIST_OR_FAIL_OPEN		MAKE_E_XSTATUS(XM_COREDB, 17)
#define ZWAVE_COREDB_E_INVALID_OPERATION			MAKE_E_XSTATUS(XM_COREDB, 18)

/// SERVER - GENERAL
#define ZWAVE_STATUS_INVALID_HANDLE					MAKE_E_XSTATUS(XM_SERVER, 1)
#define ZWAVE_STATUS_NOT_INITIALIZED				MAKE_E_XSTATUS(XM_SERVER, 2)	// not used
#define ZWAVE_STATUS_INVALID_PARAMETER				MAKE_E_XSTATUS(XM_SERVER, 3)
#define ZWAVE_STATUS_INSUFFICIENT_RESOURCE			MAKE_E_XSTATUS(XM_SERVER, 4)
#define ZWAVE_STATUS_UNHANDLED_EXCEPTION			MAKE_E_XSTATUS(XM_SERVER, 5)
#define ZWAVE_STATUS_FAIL_RUN_FILE					MAKE_E_XSTATUS(XM_SERVER, 6)	// not used
#define ZWAVE_STATUS_CORRUPTED_POLICIES				MAKE_E_XSTATUS(XM_SERVER, 7)
#define ZWAVE_STATUS_E_INVALID_OPERATION			MAKE_E_XSTATUS(XM_SERVER, 8)


/// SERVER - PACKET - VALIFY
#define ZWAVE_STATUS_PACKET_VERSION_MISMATCH		MAKE_E_XSTATUS(XM_SERVER, 100)
#define ZWAVE_STATUS_PACKET_HANDLE_MISMATCH		MAKE_E_XSTATUS(XM_SERVER, 101)
#define ZWAVE_STATUS_PACKET_STATE_MISMATCH			MAKE_E_XSTATUS(XM_SERVER, 102)
#define ZWAVE_STATUS_PACKET_SEQNUM1_MISMATCH		MAKE_E_XSTATUS(XM_SERVER, 103)
#define ZWAVE_STATUS_PACKET_SEQNUM2_MISMATCH		MAKE_E_XSTATUS(XM_SERVER, 104)
#define ZWAVE_STATUS_PACKET_NOT_COMS				MAKE_E_XSTATUS(XM_SERVER, 105)
#define ZWAVE_STATUS_PACKET_CRC_ERROR				MAKE_E_XSTATUS(XM_SERVER, 106)

/// SERVER - INITIALIZE & LOADING MODULES
#define ZWAVE_STATUS_UNKNOWN_SCAN_TYPE				MAKE_E_XSTATUS(XM_SERVER, 299)
#define ZWAVE_STATUS_FAIL_OPEN_DATABASE				MAKE_E_XSTATUS(XM_SERVER, 300)
#define ZWAVE_STATUS_FAIL_INIT_DATABASE				MAKE_E_XSTATUS(XM_SERVER, 301) // not used

#define ZWAVE_STATUS_NCB_NOT_EXISTS					MAKE_E_XSTATUS(XM_SERVER, 302) // not used
#define ZWAVE_STATUS_INT_NOT_EXISTS					MAKE_E_XSTATUS(XM_SERVER, 303) // not used
#define ZWAVE_STATUS_XCE_NOT_EXISTS					MAKE_E_XSTATUS(XM_SERVER, 304) // not used
#define ZWAVE_STATUS_XVC_NOT_EXISTS					MAKE_E_XSTATUS(XM_SERVER, 305) // not used

#define ZWAVE_STATUS_NCB_REGISTING_FAILED			MAKE_E_XSTATUS(XM_SERVER, 306) // not used
#define ZWAVE_STATUS_ZCEV_REGISTING_FAILED			MAKE_E_XSTATUS(XM_SERVER, 307) // not used
#define ZWAVE_STATUS_ZCE_REGISTING_FAILED			MAKE_E_XSTATUS(XM_SERVER, 308) // not used
#define ZWAVE_STATUS_XVC_REGISTING_FAILED			MAKE_E_XSTATUS(XM_SERVER, 309) // not used

#define ZWAVE_STATUS_NCB_CRC_ERROR					MAKE_E_XSTATUS(XM_SERVER, 310) // not used
#define ZWAVE_STATUS_INT_CRC_ERROR					MAKE_E_XSTATUS(XM_SERVER, 311) // not used
#define ZWAVE_STATUS_XCE_CRC_ERROR					MAKE_E_XSTATUS(XM_SERVER, 312) // not used
#define ZWAVE_STATUS_XVC_CRC_ERROR					MAKE_E_XSTATUS(XM_SERVER, 313) // not used

#define ZWAVE_STATUS_MODULE_VERSION_MISMATCH		MAKE_E_XSTATUS(XM_SERVER, 314) // not used
#define ZWAVE_STATUS_MODULE_NOT_INITIALIZED		MAKE_E_XSTATUS(XM_SERVER, 315) // not used
#define ZWAVE_STATUS_ZCOREDB_LOAD_FAILED			MAKE_E_XSTATUS(XM_SERVER, 316) 
#define ZWAVE_STATUS_ZCOREDB_INVALID_DLL			MAKE_E_XSTATUS(XM_SERVER, 317)
#define ZWAVE_STATUS_MUTEX_FAILED					MAKE_E_XSTATUS(XM_SERVER, 318)

/// LINKER - GENERALS
#define ZWAVE_STATUS_LINKER_FAILED					MAKE_E_XSTATUS(XM_LINKER, 1)
#define ZWAVE_STATUS_LINKER_INIT_EVENT_FAILED		MAKE_E_XSTATUS(XM_LINKER, 2)
#define ZWAVE_STATUS_LINKER_INIT_MAP_FAILED		MAKE_E_XSTATUS(XM_LINKER, 3)
#define ZWAVE_STATUS_LINKER_INIT_VIEW_FAILED		MAKE_E_XSTATUS(XM_LINKER, 4)
#define ZWAVE_STATUS_LINKER_INIT_THREAD_FAILED		MAKE_E_XSTATUS(XM_LINKER, 5)
#define ZWAVE_STATUS_LINKER_STATE_MISMATCH			MAKE_E_XSTATUS(XM_LINKER, 6)
#define ZWAVE_STATUS_LINKER_SERVER_INVALID_DLL		MAKE_E_XSTATUS(XM_LINKER, 7)
#define ZWAVE_STATUS_LINKER_SERVER_INITIALIED		MAKE_E_XSTATUS(XM_LINKER, 8)
#define ZWAVE_STATUS_LINKER_INVALID_LIBDIR			MAKE_E_XSTATUS(XM_LINKER, 9)
#define ZWAVE_STATUS_LINKER_CREATE_EVENT_FAIL		MAKE_E_XSTATUS(XM_LINKER, 10) // not used
#define ZWAVE_STATUS_LINKER_TOO_MANY_SERVER		MAKE_E_XSTATUS(XM_LINKER, 11) // not used