#include "stdafx.h"
#include "atumparam.h"
#include "atumprotocol.h"
#include "atumerror.h"

const char* GetProtocolTypeString(MessageType_t msgType)
{
	switch(msgType)
	{
	case T_PC_DEFAULT_UPDATE_LAUNCHER_VERSION:			return "T_PC_DEFAULT_UPDATE_LAUNCHER_VERSION";
	case T_PC_DEFAULT_UPDATE_LAUNCHER_UPDATE_INFO:		return "T_PC_DEFAULT_UPDATE_LAUNCHER_UPDATE_INFO";
	case T_PC_DEFAULT_UPDATE_LAUNCHER_VERSION_OK:		return "T_PC_DEFAULT_UPDATE_LAUNCHER_VERSION_OK";
	case T_PC_DEFAULT_NEW_UPDATE_LAUNCHER_VERSION:			return "T_PC_DEFAULT_NEW_UPDATE_LAUNCHER_VERSION";		// 2007-01-08 by cmkwon
	case T_PC_DEFAULT_NEW_UPDATE_LAUNCHER_UPDATE_INFO:		return "T_PC_DEFAULT_NEW_UPDATE_LAUNCHER_UPDATE_INFO";	// 2007-01-08 by cmkwon

	case T_PC_CONNECT_CLOSE:							return "T_PC_CONNECT_CLOSE";
	case T_PC_CONNECT_ALIVE:							return "T_PC_CONNECT_ALIVE";
	case T_PC_CONNECT_VERSION:							return "T_PC_CONNECT_VERSION";
	case T_PC_CONNECT_UPDATE_INFO:						return "T_PC_CONNECT_UPDATE_INFO";
	case T_PC_CONNECT_VERSION_OK:						return "T_PC_CONNECT_VERSION_OK";
	case T_PC_CONNECT_REINSTALL_CLIENT:					return "T_PC_CONNECT_REINSTALL_CLIENT";
	case T_PC_CONNECT_LOGIN:							return "T_PC_CONNECT_LOGIN";
	case T_PC_CONNECT_LOGIN_OK:							return "T_PC_CONNECT_LOGIN_OK";
	case T_PC_CONNECT_SINGLE_FILE_VERSION_CHECK:		return "T_PC_CONNECT_SINGLE_FILE_VERSION_CHECK";
	case T_PC_CONNECT_SINGLE_FILE_VERSION_CHECK_OK:		return "T_PC_CONNECT_SINGLE_FILE_VERSION_CHECK_OK";
	case T_PC_CONNECT_SINGLE_FILE_UPDATE_INFO:			return "T_PC_CONNECT_SINGLE_FILE_UPDATE_INFO";
	case T_PC_CONNECT_GET_SERVER_GROUP_LIST:			return "T_PC_CONNECT_GET_SERVER_GROUP_LIST";
	case T_PC_CONNECT_GET_SERVER_GROUP_LIST_OK:			return "T_PC_CONNECT_GET_SERVER_GROUP_LIST_OK";
	case T_PC_CONNECT_GET_GAME_SERVER_GROUP_LIST:		return "T_PC_CONNECT_GET_GAME_SERVER_GROUP_LIST";		// 2007-05-02 by cmkwon
	case T_PC_CONNECT_GET_GAME_SERVER_GROUP_LIST_OK:	return "T_PC_CONNECT_GET_GAME_SERVER_GROUP_LIST_OK";	// 2007-05-02 by cmkwon
	case T_PC_CONNECT_NETWORK_CHECK:					return "T_PC_CONNECT_NETWORK_CHECK";	// 2007-06-18 by cmkwon, Ʈũ  üũ
	case T_PC_CONNECT_NETWORK_CHECK_OK:					return "T_PC_CONNECT_NETWORK_CHECK_OK";	// 2007-06-18 by cmkwon, Ʈũ  üũ
	case T_PC_CONNECT_GET_NEW_GAME_SERVER_GROUP_LIST:		return "T_PC_CONNECT_GET_NEW_GAME_SERVER_GROUP_LIST";		// 2007-09-05 by cmkwon, EXE_1 α   ̽  -
	case T_PC_CONNECT_GET_NEW_GAME_SERVER_GROUP_LIST_OK:	return "T_PC_CONNECT_GET_NEW_GAME_SERVER_GROUP_LIST_OK";	// 2007-09-05 by cmkwon, EXE_1 α   ̽  -

	case T_PC_CONNECT_LOGIN_BLOCKED:					return "T_PC_CONNECT_LOGIN_BLOCKED";

	case T_FC_CONNECT_CLOSE:							return "T_FC_CONNECT_CLOSE";
	case T_FC_CONNECT_ALIVE:							return "T_FC_CONNECT_ALIVE";
	case T_FC_CONNECT_LOGIN:							return "T_FC_CONNECT_LOGIN";
	case T_FC_CONNECT_LOGIN_OK:							return "T_FC_CONNECT_LOGIN_OK";
	case T_FC_CONNECT_SYNC_TIME:						return "T_FC_CONNECT_SYNC_TIME";
	case T_FC_CONNECT_NOTIFY_SERVER_SHUTDOWN:			return "T_FC_CONNECT_NOTIFY_SERVER_SHUTDOWN";

	case T_FC_CONNECT_NETWORK_CHECK:					return "T_FC_CONNECT_NETWORK_CHECK";		// 2008-02-15 by cmkwon, Client<->FieldServer  Ʈũ  üũ - 
	case T_FC_CONNECT_NETWORK_CHECK_OK:					return "T_FC_CONNECT_NETWORK_CHECK_OK";		// 2008-02-15 by cmkwon, Client<->FieldServer  Ʈũ  üũ - 



	case T_FC_CONNECT_ARENASERVER_INFO:					return "T_FC_CONNECT_ARENASERVER_INFO";			// 2007-12-28 by dhjin, Ʒ  - 
	case T_FC_CONNECT_ARENASERVER_LOGIN:				return "T_FC_CONNECT_ARENASERVER_LOGIN";			// 2007-12-28 by dhjin, Ʒ  - 
	case T_FC_CONNECT_ARENASERVER_LOGIN_OK:				return "T_FC_CONNECT_ARENASERVER_LOGIN_OK";			// 2007-12-28 by dhjin, Ʒ  - 
	case T_FC_CONNECT_ARENASERVER_SSERVER_GROUP_FOR_CLIENT:				return "T_FC_CONNECT_ARENASERVER_SSERVER_GROUP_FOR_CLIENT";			// 2008-02-25 by dhjin, Ʒ  - 
	case T_FC_CONNECT_ARENASERVER_TO_IMSERVER:				return "T_FC_CONNECT_ARENASERVER_TO_IMSERVER";			// 2008-03-03 by dhjin, Ʒ  - 
	// start 2011-11-03 by shcho, yedang ˴ٿ  - 
	case T_FC_SHUTDOWNMINS_USER_ALTER:					return "T_FC_SHUTDOWNMINS_USER_ALTER";		// 10  ˸
	case T_FC_SHUTDOWNMINS_USER_ENDGAME:				return "T_FC_SHUTDOWNMINS_USER_ENDGAME";	//  
	case ERR_SHUTDOWNMINORS_USER:						return "ERR_SHUTDOWNMINORS_USER";			// 16  ó  ó
	// end 2011-11-03 by shcho, yedang ˴ٿ  - 

	case T_FP_CONNECT_CLOSE:							return "T_FP_CONNECT_CLOSE";
	case T_FP_CONNECT_ALIVE:							return "T_FP_CONNECT_ALIVE";
	case T_FP_CONNECT_AUTH_USER:						return "T_FP_CONNECT_AUTH_USER";
	case T_FP_CONNECT_AUTH_USER_OK:						return "T_FP_CONNECT_AUTH_USER_OK";
	case T_FP_CONNECT_FIELD_CONNECT:					return "T_FP_CONNECT_FIELD_CONNECT";
	case T_FP_CONNECT_FIELD_CONNECT_OK:					return "T_FP_CONNECT_FIELD_CONNECT_OK";
	case T_FP_CONNECT_NOTIFY_CLOSE:						return "T_FP_CONNECT_NOTIFY_CLOSE";
	case T_FP_CONNECT_NOTIFY_FIELDSERVER_CHANGE:		return "T_FP_CONNECT_NOTIFY_FIELDSERVER_CHANGE";
	case T_FP_CONNECT_NOTIFY_FIELDSERVER_CHANGE_OK:		return "T_FP_CONNECT_NOTIFY_FIELDSERVER_CHANGE_OK";
	case T_FP_CONNECT_PREPARE_SHUTDOWN:					return "T_FP_CONNECT_PREPARE_SHUTDOWN";
	case T_FP_CONNECT_UPDATE_DBSERVER_GROUP:			return "T_FP_CONNECT_UPDATE_DBSERVER_GROUP";		// 2008-04-29 by cmkwon,   DB ߰(ű  ĳ   ý߰) - 
	case T_FP_CONNECT_CHECK_CONNECTABLE_ACCOUNT:		return "T_FP_CONNECT_CHECK_CONNECTABLE_ACCOUNT";		// 2008-04-29 by cmkwon,   DB ߰(ű  ĳ   ý߰) - 
	case T_FP_CONNECT_CHECK_CONNECTABLE_ACCOUNT_OK:		return "T_FP_CONNECT_CHECK_CONNECTABLE_ACCOUNT_OK";	// 2008-04-29 by cmkwon,   DB ߰(ű  ĳ   ý߰) - 
	case T_FP_ADMIN_RELOAD_WORLDRANKING:				return "T_FP_ADMIN_RELOAD_WORLDRANKING";		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FP_ADMIN_RELOAD_INFLUENCERATE:				return "T_FP_ADMIN_RELOAD_INFLUENCERATE";		// 2009-09-16 by cmkwon,  ʱȭ ¡   - 

	case T_IP_CONNECT_CLOSE:							return "T_IP_CONNECT_CLOSE";
	case T_IP_CONNECT_ALIVE:							return "T_IP_CONNECT_ALIVE";
	case T_IP_CONNECT_IM_CONNECT:						return "T_IP_CONNECT_IM_CONNECT";
	case T_IP_CONNECT_IM_CONNECT_OK:					return "T_IP_CONNECT_IM_CONNECT_OK";
	case T_IP_GET_SERVER_GROUP_INFO:					return "T_IP_GET_SERVER_GROUP_INFO";
	case T_IP_GET_SERVER_GROUP_INFO_ACK:				return "T_IP_GET_SERVER_GROUP_INFO_ACK";
	case T_IP_ADMIN_PETITION_SET_PERIOD:				return "T_IP_ADMIN_PETITION_SET_PERIOD";		// 2007-11-19 by cmkwon, ý Ʈ - 
	case T_IP_ADMIN_RELOAD_ADMIN_NOTICE_SYSTEM:			return "T_IP_ADMIN_RELOAD_ADMIN_NOTICE_SYSTEM";		// 2009-01-14 by cmkwon,  ڵ  ý  - 
		
	case T_IC_CONNECT_CLOSE:							return "T_IC_CONNECT_CLOSE";
	case T_IC_CONNECT_ALIVE:							return "T_IC_CONNECT_ALIVE";
	case T_IC_CONNECT_LOGIN:							return "T_IC_CONNECT_LOGIN";
	case T_IC_CONNECT_LOGIN_OK:							return "T_IC_CONNECT_LOGIN_OK";
	case T_IC_CONNECT_FM_TO_IM_OK:						return "T_IC_CONNECT_FM_TO_IM_OK";		// 2008-03-03 by dhjin, Ʒ  - 

	case T_FI_CONNECT:									return "T_FI_CONNECT";
	case T_FI_CONNECT_OK:								return "T_FI_CONNECT_OK";
	case T_FI_CONNECT_CLOSE:							return "T_FI_CONNECT_CLOSE";
	case T_FI_CONNECT_ALIVE:							return "T_FI_CONNECT_ALIVE";
	case T_FI_CONNECT_NOTIFY_FIELDSERVER_IP:			return "T_FI_CONNECT_NOTIFY_FIELDSERVER_IP";
	case T_FI_CONNECT_NOTIFY_GAMEEND:					return "T_FI_CONNECT_NOTIFY_GAMEEND";
	case T_FI_CONNECT_NOTIFY_DEAD:						return "T_FI_CONNECT_NOTIFY_DEAD";
	case T_FI_GET_FIELD_USER_COUNTS:					return "T_FI_GET_FIELD_USER_COUNTS";
	case T_FI_GET_FIELD_USER_COUNTS_ACK:				return "T_FI_GET_FIELD_USER_COUNTS_ACK";
	case T_FI_CONNECT_NOTIFY_GAMESTART:					return "T_FI_CONNECT_NOTIFY_GAMESTART";
	case T_FI_CONNECT_NOTIFY_DEAD_GAMESTART:			return "T_FI_CONNECT_NOTIFY_DEAD_GAMESTART";
	case T_FI_CONNECT_PREPARE_SHUTDOWN:					return "T_FI_CONNECT_PREPARE_SHUTDOWN";

	case T_PM_CONNECT:									return "T_PM_CONNECT";
	case T_PM_CONNECT_OK:								return "T_PM_CONNECT_OK";
	case T_PM_CONNECT_CLOSE:							return "T_PM_CONNECT_CLOSE";
	case T_PM_CONNECT_ALIVE:							return "T_PM_CONNECT_ALIVE";
	case T_FM_CONNECT:									return "T_FM_CONNECT";
	case T_FM_CONNECT_OK:								return "T_FM_CONNECT_OK";
	case T_FM_CONNECT_CLOSE:							return "T_FM_CONNECT_CLOSE";
	case T_FM_CONNECT_ALIVE:							return "T_FM_CONNECT_ALIVE";
	case T_FN_CONNECT_CLOSE:							return "T_FN_CONNECT_CLOSE";
	case T_FN_CONNECT_ALIVE:							return "T_FN_CONNECT_ALIVE";
	case T_FN_CONNECT_INCREASE_CHANNEL:					return "T_FN_CONNECT_INCREASE_CHANNEL";
	case T_FN_CONNECT_SET_CHANNEL_STATE:				return "T_FN_CONNECT_SET_CHANNEL_STATE";
	case T_LM_CONNECT:									return "T_LM_CONNECT";
	case T_LM_CONNECT_OK:								return "T_LM_CONNECT_OK";
	case T_LM_CONNECT_CLOSE:							return "T_LM_CONNECT_CLOSE";
	case T_LM_CONNECT_ALIVE:							return "T_LM_CONNECT_ALIVE";
	case T_IM_CONNECT:									return "T_IM_CONNECT";
	case T_IM_CONNECT_OK:								return "T_IM_CONNECT_OK";
	case T_IM_CONNECT_CLOSE:							return "T_IM_CONNECT_CLOSE";
	case T_IM_CONNECT_ALIVE:							return "T_IM_CONNECT_ALIVE";
	case T_NM_CONNECT:									return "T_NM_CONNECT";
	case T_NM_CONNECT_OK:								return "T_NM_CONNECT_OK";
	case T_NM_CONNECT_CLOSE:							return "T_NM_CONNECT_CLOSE";
	case T_NM_CONNECT_ALIVE:							return "T_NM_CONNECT_ALIVE";
	case T_PL_CONNECT:									return "T_PL_CONNECT";
	case T_PL_CONNECT_OK:								return "T_PL_CONNECT_OK";
	case T_PL_CONNECT_CLOSE:							return "T_PL_CONNECT_CLOSE";
	case T_PL_CONNECT_ALIVE:							return "T_PL_CONNECT_ALIVE";
	case T_IL_CONNECT:									return "T_IL_CONNECT";
	case T_IL_CONNECT_OK:								return "T_IL_CONNECT_OK";
	case T_IL_CONNECT_CLOSE:							return "T_IL_CONNECT_CLOSE";
	case T_IL_CONNECT_ALIVE:							return "T_IL_CONNECT_ALIVE";
	case T_FL_CONNECT:									return "T_FL_CONNECT";
	case T_FL_CONNECT_OK:								return "T_FL_CONNECT_OK";
	case T_FL_CONNECT_CLOSE:							return "T_FL_CONNECT_CLOSE";
	case T_FL_CONNECT_ALIVE:							return "T_FL_CONNECT_ALIVE";
	case T_NL_CONNECT:									return "T_NL_CONNECT";
	case T_NL_CONNECT_OK:								return "T_NL_CONNECT_OK";
	case T_NL_CONNECT_CLOSE:							return "T_NL_CONNECT_CLOSE";
	case T_NL_CONNECT_ALIVE:							return "T_NL_CONNECT_ALIVE";

	case T_PP_CONNECT:									return "T_PP_CONNECT";			// 2008-02-22 by cmkwon, ServerPreServer->MasangPreServer     ý ߰ - 
	case T_PP_CONNECT_OK:								return "T_PP_CONNECT_OK";		// 2008-02-22 by cmkwon, ServerPreServer->MasangPreServer     ý ߰ - 
	case T_PP_CONNECT_DO_CLOSE:							return "T_PP_CONNECT_DO_CLOSE";	// 2008-02-22 by cmkwon, ServerPreServer->MasangPreServer     ý ߰ - 

	case T_FI_EVENT_NOTIFY_WARP:						return "T_FI_EVENT_NOTIFY_WARP";
// 2005-07-27 by cmkwon, ٸ ʵ弭  Ƿ 
//	case T_FI_EVENT_NOTIFY_WARP_OK:						return "T_FI_EVENT_NOTIFY_WARP_OK";
	case T_FI_EVENT_CHAT_BLOCK:							return "T_FI_EVENT_CHAT_BLOCK";		// 2008-12-30 by cmkwon,  ä  ī  - 


	case T_IC_CHAT_ALL:									return "T_IC_CHAT_ALL";
	case T_IC_CHAT_MAP:									return "T_IC_CHAT_MAP";
	case T_IC_CHAT_REGION:								return "T_IC_CHAT_REGION";
	case T_IC_CHAT_PTOP:								return "T_IC_CHAT_PTOP";
	case T_IC_CHAT_PARTY:								return "T_IC_CHAT_PARTY";
	case T_IC_CHAT_GUILD:								return "T_IC_CHAT_GUILD";
	case T_IC_CHAT_GET_GUILD:							return "T_IC_CHAT_GET_GUILD";
	case T_IC_CHAT_GET_GUILD_OK:						return "T_IC_CHAT_GET_GUILD_OK";
	case T_IC_CHAT_CHANGE_GUILD:						return "T_IC_CHAT_CHANGE_GUILD";
	case T_IC_CHAT_CHANGE_GUILD_OK:						return "T_IC_CHAT_CHANGE_GUILD_OK";
	case T_IC_CHAT_CHANGE_PARTY:						return "T_IC_CHAT_CHANGE_PARTY";
	case T_IC_CHAT_CHANGE_PARTY_OK:						return "T_IC_CHAT_CHANGE_PARTY_OK";
	case T_IC_CHAT_CHANGE_CHAT_FLAG:					return "T_IC_CHAT_CHANGE_CHAT_FLAG";
	case T_IC_CHAT_POSITION:							return "T_IC_CHAT_POSITION";
	case T_IC_CHAT_BLOCK:								return "T_IC_CHAT_BLOCK";
	case T_IC_CHAT_GET_BLOCK:							return "T_IC_CHAT_GET_BLOCK";
	case T_IC_CHAT_GET_BLOCK_OK:						return "T_IC_CHAT_GET_BLOCK_OK";
	case T_IC_CHAT_BLOCK_YOU:							return "T_IC_CHAT_BLOCK_YOU";
	case T_IC_CHAT_FRIENDLIST_AND_REJECTLIST_LOADING:	return "T_IC_CHAT_FRIENDLIST_AND_REJECTLIST_LOADING";
	case T_IC_CHAT_FRIENDLIST_LOADING_OK:				return "T_IC_CHAT_FRIENDLIST_LOADING_OK";
	case T_IC_CHAT_FRIENDLIST_INSERT:					return "T_IC_CHAT_FRIENDLIST_INSERT";
	case T_IC_CHAT_FRIENDLIST_INSERT_OK:				return "T_IC_CHAT_FRIENDLIST_INSERT_OK";
	case T_IC_CHAT_FRIENDLIST_INSERT_NOTIFY:			return "T_IC_CHAT_FRIENDLIST_INSERT_NOTIFY";	// 2009-01-13 by cmkwon, ģ Ͻ 濡 ˸ ý  - 

	case T_IC_CHAT_FRIENDLIST_DELETE:					return "T_IC_CHAT_FRIENDLIST_DELETE";
	case T_IC_CHAT_FRIENDLIST_DELETE_OK:				return "T_IC_CHAT_FRIENDLIST_DELETE_OK";
	case T_IC_CHAT_FRIENDLIST_REFRESH:					return "T_IC_CHAT_FRIENDLIST_REFRESH";
	case T_IC_CHAT_FRIENDLIST_REFRESH_OK:				return "T_IC_CHAT_FRIENDLIST_REFRESH_OK";
	case T_IC_CHAT_REJECTLIST_LOADING_OK:				return "T_IC_CHAT_REJECTLIST_LOADING_OK";
	case T_IC_CHAT_REJECTLIST_INSERT:					return "T_IC_CHAT_REJECTLIST_INSERT";
	case T_IC_CHAT_REJECTLIST_INSERT_OK:				return "T_IC_CHAT_REJECTLIST_INSERT_OK";
	case T_IC_CHAT_REJECTLIST_DELETE:					return "T_IC_CHAT_REJECTLIST_DELETE";
	case T_IC_CHAT_REJECTLIST_DELETE_OK:				return "T_IC_CHAT_REJECTLIST_DELETE_OK";
	case T_IC_CHAT_SELL_ALL:							return "T_IC_CHAT_SELL_ALL";
	case T_IC_CHAT_CASH_ALL:							return "T_IC_CHAT_CASH_ALL";
	case T_IC_CHAT_INFLUENCE_ALL:						return "T_IC_CHAT_INFLUENCE_ALL";
	case T_IC_CHAT_ARENA:								return "T_IC_CHAT_ARENA";
	case T_IC_CHAT_WAR:									return "T_IC_CHAT_WAR";			// 2008-05-19 by dhjin, EP3 - ä ý ,  ä
	case T_IC_CHAT_CHATROOM:							return "T_IC_CHAT_CHATROOM";	// 2008-06-18 by dhjin, EP3 äù - 
	case T_IC_CHAT_INFINITY:							return "T_IC_CHAT_INFINITY";	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ä
		
	case T_FI_CHAT_MAP:									return "T_FI_CHAT_MAP";
	case T_FI_CHAT_REGION:								return "T_FI_CHAT_REGION";
	case T_FI_CHAT_CHANGE_CHAT_FLAG:					return "T_FI_CHAT_CHANGE_CHAT_FLAG";
	case T_FI_CHAT_CASH_ALL:							return "T_FI_CHAT_CASH_ALL";
	case T_FI_CHAT_ARENA:								return "T_FI_CHAT_ARENA";
	case T_FI_CHAT_OUTPOST_GUILD:						return "T_FI_CHAT_OUTPOST_GUILD";	// 2007-10-06 by cmkwon
	case T_FI_CHAT_INFINITY:							return "T_FI_CHAT_INFINITY";	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ä

	case T_FI_CHAT_ONLINE_EACHOTHER_FRIEND_COUNT_OK:	return "T_FI_CHAT_ONLINE_EACHOTHER_FRIEND_COUNT_OK";
	case T_IC_CHAT_ONLINE_EACHOTHER_FRIEND_COUNT:		return "T_IC_CHAT_ONLINE_EACHOTHER_FRIEND_COUNT";		// 2008-07-11 by dhjin, EP3 ģ -

	case T_FC_CHAT_MAP:									return "T_FC_CHAT_MAP";
	case T_FC_CHAT_REGION:								return "T_FC_CHAT_REGION";
	case T_FC_CHAT_CASH_ALL:							return "T_FC_CHAT_CASH_ALL";
	case T_FC_CHAT_ARENA:								return "T_FC_CHAT_ARENA";
	case T_FC_CHAT_ALL_INFLUENCE:						return "T_FC_CHAT_ALL_INFLUENCE";	// 2007-08-09 by cmkwon,  ¿ ä ϱ -
	case T_FC_CHAT_OUTPOST_GUILD:						return "T_FC_CHAT_OUTPOST_GUILD";	// 2007-10-06 by cmkwon,      ä 
	case T_FC_CHAT_INFINITY:							return "T_FC_CHAT_INFINITY";	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ä

	case T_FC_CHARACTER_CREATE:							return "T_FC_CHARACTER_CREATE";
	case T_FC_CHARACTER_CREATE_OK:						return "T_FC_CHARACTER_CREATE_OK";
	case T_FC_CHARACTER_DELETE:							return "T_FC_CHARACTER_DELETE";
	case T_FC_CHARACTER_DELETE_OK:						return "T_FC_CHARACTER_DELETE_OK";
	case T_FC_CHARACTER_GET_CHARACTER:					return "T_FC_CHARACTER_GET_CHARACTER";
	case T_FC_CHARACTER_GET_CHARACTER_OK:				return "T_FC_CHARACTER_GET_CHARACTER_OK";
	case T_FC_CHARACTER_GAMESTART:						return "T_FC_CHARACTER_GAMESTART";
	case T_FC_CHARACTER_GAMESTART_OK:					return "T_FC_CHARACTER_GAMESTART_OK";
	case T_FC_CHARACTER_CONNECT_GAMESTART:				return "T_FC_CHARACTER_CONNECT_GAMESTART";
	case T_FC_CHARACTER_CONNECT_GAMESTART_OK:			return "T_FC_CHARACTER_CONNECT_GAMESTART_OK";
	case T_FC_CHARACTER_GAMEEND:						return "T_FC_CHARACTER_GAMEEND";
	case T_FC_CHARACTER_GAMEEND_OK:						return "T_FC_CHARACTER_GAMEEND_OK";
	case T_FC_CHARACTER_REPAIR:							return "T_FC_CHARACTER_REPAIR";
	case T_FC_CHARACTER_REPAIR_OK:						return "T_FC_CHARACTER_REPAIR_OK";
	case T_FC_CHARACTER_REPAIR_ERR:						return "T_FC_CHARACTER_REPAIR_ERR";
	case T_FC_CHARACTER_DOCKING:						return "T_FC_CHARACTER_DOCKING";
	case T_FC_CHARACTER_UNDOCKING:						return "T_FC_CHARACTER_UNDOCKING";
	case T_FC_CHARACTER_DOCKING_ERR:					return "T_FC_CHARACTER_DOCKING_ERR";
	case T_FC_CHARACTER_GET_OTHER_INFO:					return "T_FC_CHARACTER_GET_OTHER_INFO";
	case T_FC_CHARACTER_GET_OTHER_INFO_OK:				return "T_FC_CHARACTER_GET_OTHER_INFO_OK";
	case T_FC_CHARACTER_GET_MONSTER_INFO_OK:			return "T_FC_CHARACTER_GET_MONSTER_INFO_OK";
	case T_FC_CHARACTER_CHANGE_UNITKIND:				return "T_FC_CHARACTER_CHANGE_UNITKIND";
	case T_FC_CHARACTER_CHANGE_STAT:					return "T_FC_CHARACTER_CHANGE_STAT";
	case T_FC_CHARACTER_CHANGE_TOTALGEAR_STAT:			return "T_FC_CHARACTER_CHANGE_TOTALGEAR_STAT";
	case T_FC_CHARACTER_CHANGE_FRIEND:					return "T_FC_CHARACTER_CHANGE_FRIEND";
	case T_FC_CHARACTER_CHANGE_EXP:						return "T_FC_CHARACTER_CHANGE_EXP";
	case T_FC_CHARACTER_CHANGE_BODYCONDITION:			return "T_FC_CHARACTER_CHANGE_BODYCONDITION";
	case T_FC_CHARACTER_CHANGE_BODYCONDITION_SKILL:		return "T_FC_CHARACTER_CHANGE_BODYCONDITION_SKILL";
	case T_FC_CHARACTER_CHANGE_INFLUENCE_TYPE:			return "T_FC_CHARACTER_CHANGE_INFLUENCE_TYPE";
	case T_FC_CHARACTER_CHANGE_STATUS:					return "T_FC_CHARACTER_CHANGE_STATUS";
	case T_FC_CHARACTER_CHANGE_PKPOINT:					return "T_FC_CHARACTER_CHANGE_PKPOINT";
	case T_FC_CHARACTER_CHANGE_HPDPSPEP:				return "T_FC_CHARACTER_CHANGE_HPDPSPEP";
	case T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP:			return "T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP";
	case T_FC_CHARACTER_CHANGE_CURRENTHP:				return "T_FC_CHARACTER_CHANGE_CURRENTHP";
	case T_FC_CHARACTER_CHANGE_CURRENTDP:				return "T_FC_CHARACTER_CHANGE_CURRENTDP";
	case T_FC_CHARACTER_CHANGE_CURRENTSP:				return "T_FC_CHARACTER_CHANGE_CURRENTSP";
	case T_FC_CHARACTER_CHANGE_CURRENTEP:				return "T_FC_CHARACTER_CHANGE_CURRENTEP";
	case T_FC_CHARACTER_CHANGE_MAPNAME:					return "T_FC_CHARACTER_CHANGE_MAPNAME";
	case T_FC_CHARACTER_CHANGE_PETINFO:					return "T_FC_CHARACTER_CHANGE_PETINFO";
	case T_FC_CHARACTER_CHANGE_POSITION:				return "T_FC_CHARACTER_CHANGE_POSITION";
	case T_FC_CHARACTER_CHANGE_LEVEL:					return "T_FC_CHARACTER_CHANGE_LEVEL";
	case T_FC_CHARACTER_USE_BONUSSTAT:					return "T_FC_CHARACTER_USE_BONUSSTAT";
	case T_FC_CHARACTER_USE_BONUSSTAT_OK:				return "T_FC_CHARACTER_USE_BONUSSTAT_OK";		// 2006-09-18 by cmkwon
	case T_FC_CHARACTER_DEAD_NOTIFY:					return "T_FC_CHARACTER_DEAD_NOTIFY";
	case T_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER:		return "T_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER";
	case T_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER_OK:		return "T_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER_OK";
	case T_FC_CHARACTER_APPLY_COLLISION_DAMAGE:			return "T_FC_CHARACTER_APPLY_COLLISION_DAMAGE";
	case T_FC_CHARACTER_GET_OTHER_MOVE:					return "T_FC_CHARACTER_GET_OTHER_MOVE";
	case T_FC_CHARACTER_DELETE_OTHER_INFO:				return "T_FC_CHARACTER_DELETE_OTHER_INFO";
	case T_FC_CHARACTER_DEAD_GAMESTART:					return "T_FC_CHARACTER_DEAD_GAMESTART";
	case T_FC_CHARACTER_OTHER_REVIVED:					return "T_FC_CHARACTER_OTHER_REVIVED";
	case T_FC_CHARACTER_GET_OTHER_RENDER_INFO:			return "T_FC_CHARACTER_GET_OTHER_RENDER_INFO";
	case T_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK:		return "T_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK";
	case T_FC_CHARACTER_CHANGE_BODYCONDITION_ALL:		return "T_FC_CHARACTER_CHANGE_BODYCONDITION_ALL";
	case T_FC_CHARACTER_CHANGE_PROPENSITY:			return "T_FC_CHARACTER_CHANGE_PROPENSITY";

	case T_FC_CHARACTER_SHOW_EFFECT:					return "T_FC_CHARACTER_SHOW_EFFECT";
	case T_FC_CHARACTER_SHOW_EFFECT_OK:					return "T_FC_CHARACTER_SHOW_EFFECT_OK";
	case T_FC_CHARACTER_GET_OTHER_PARAMFACTOR:			return "T_FC_CHARACTER_GET_OTHER_PARAMFACTOR";
	case T_FC_CHARACTER_GET_OTHER_PARAMFACTOR_OK:		return "T_FC_CHARACTER_GET_OTHER_PARAMFACTOR_OK";
	case T_FC_CHARACTER_SEND_PARAMFACTOR_IN_RANGE:		return "T_FC_CHARACTER_SEND_PARAMFACTOR_IN_RANGE";
	case T_FC_CHARACTER_SPEED_HACK_USER:				return "T_FC_CHARACTER_SPEED_HACK_USER";
	case T_FC_CHARACTER_CHANGE_CHARACTER_MENT:			return "T_FC_CHARACTER_CHANGE_CHARACTER_MENT";	
	case T_FC_CHARACTER_GET_CASH_MONEY_COUNT:			return "T_FC_CHARACTER_GET_CASH_MONEY_COUNT";	
	case T_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK:		return "T_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK";	
	case T_FC_CHARACTER_CASH_PREMIUM_CARD_INFO:			return "T_FC_CHARACTER_CASH_PREMIUM_CARD_INFO";	
	case T_FC_CHARACTER_TUTORIAL_SKIP:					return "T_FC_CHARACTER_TUTORIAL_SKIP";	
	case T_FC_CHARACTER_TUTORIAL_SKIP_OK:				return "T_FC_CHARACTER_TUTORIAL_SKIP_OK";
	// 2005-07-26 by hblee : 忡 ĳ  ȯ.
	case T_FC_CHARACTER_CHANGE_CHARACTER_MODE:			return "T_FC_CHARACTER_CHANGE_CHARACTER_MODE";
	case T_FC_CHARACTER_CHANGE_CHARACTER_MODE_OK:		return "T_FC_CHARACTER_CHANGE_CHARACTER_MODE_OK";
	case T_FC_CHARACTER_FALLING_BY_FUEL_ALLIN:			return "T_FC_CHARACTER_FALLING_BY_FUEL_ALLIN";
	case T_FC_CHARACTER_WARP_BY_AGEAR_LANDING_FUEL_ALLIN:		return "T_FC_CHARACTER_WARP_BY_AGEAR_LANDING_FUEL_ALLIN";
	case T_FC_CHARACTER_GET_REAL_WEAPON_INFO:			return "T_FC_CHARACTER_GET_REAL_WEAPON_INFO";
	case T_FC_CHARACTER_GET_REAL_WEAPON_INFO_OK:		return "T_FC_CHARACTER_GET_REAL_WEAPON_INFO_OK";
	case T_FC_CHARACTER_GET_REAL_ENGINE_INFO:			return "T_FC_CHARACTER_GET_REAL_ENGINE_INFO";
	case T_FC_CHARACTER_GET_REAL_ENGINE_INFO_OK:		return "T_FC_CHARACTER_GET_REAL_ENGINE_INFO_OK";
	case T_FC_CHARACTER_GET_REAL_TOTAL_WEIGHT:			return "T_FC_CHARACTER_GET_REAL_TOTAL_WEIGHT";
	case T_FC_CHARACTER_GET_REAL_TOTAL_WEIGHT_OK:		return "T_FC_CHARACTER_GET_REAL_TOTAL_WEIGHT_OK";
	case T_FC_CHARACTER_MEMORY_HACK_USER:				return "T_FC_CHARACTER_MEMORY_HACK_USER";
	case T_FC_CHARACTER_UPDATE_SUBLEADER:				return "T_FC_CHARACTER_UPDATE_SUBLEADER";
	case T_FC_CHARACTER_UPDATE_SUBLEADER_OK:			return "T_FC_CHARACTER_UPDATE_SUBLEADER_OK";

	case T_FC_CHARACTER_OBSERVER_START:					return "T_FC_CHARACTER_OBSERVER_START";
	case T_FC_CHARACTER_OBSERVER_START_OK:				return "T_FC_CHARACTER_OBSERVER_START_OK";
	case T_FC_CHARACTER_OBSERVER_END:					return "T_FC_CHARACTER_OBSERVER_END";
	case T_FC_CHARACTER_OBSERVER_END_OK:				return "T_FC_CHARACTER_OBSERVER_END_OK";
	case T_FC_CHARACTER_OBSERVER_INFO:					return "T_FC_CHARACTER_OBSERVER_INFO";
	case T_FC_CHARACTER_OBSERVER_REG:					return "T_FC_CHARACTER_OBSERVER_REG";
	case T_FC_CHARACTER_SHOW_MAP_EFFECT:				return "T_FC_CHARACTER_SHOW_MAP_EFFECT";		// 2007-04-20 by cmkwon
	case T_FC_CHARACTER_SHOW_MAP_EFFECT_OK:				return "T_FC_CHARACTER_SHOW_MAP_EFFECT_OK";		// 2007-04-20 by cmkwon
	case T_FC_CHARACTER_PAY_WARPOINT:					return "T_FC_CHARACTER_PAY_WARPOINT";			// 2007-05-16 by dhjin
	case T_FC_CHARACTER_WATCH_INFO:						return "T_FC_CHARACTER_WATCH_INFO";				// 2007-06-19 by dhjin
	// 2008-01-10 by dhjin,  Ʒ  - 
	case T_FC_CHARACTER_GAMESTART_FROM_ARENA_TO_MAINSERVER:			return "T_FC_CHARACTER_GAMESTART_FROM_ARENA_TO_MAINSERVER";
	case T_FC_CHARACTER_READY_GAMESTART_FROM_ARENA_TO_MAINSERVER:			return "T_FC_CHARACTER_READY_GAMESTART_FROM_ARENA_TO_MAINSERVER";
	case T_FC_CHARACTER_READY_GAMESTART_FROM_ARENA_TO_MAINSERVER_OK:		return "T_FC_CHARACTER_READY_GAMESTART_FROM_ARENA_TO_MAINSERVER_OK";
	case T_FC_CHARACTER_GET_USER_INFO:					return "T_FC_CHARACTER_GET_USER_INFO";					// C->F, // 2008-06-23 by dhjin, EP3 ɼ -
	case T_FC_CHARACTER_GET_USER_INFO_OK:				return "T_FC_CHARACTER_GET_USER_INFO_OK";				// F->C, // 2008-06-23 by dhjin, EP3 ɼ -
	case T_FC_CHARACTER_CHANGE_INFO_OPTION_SECRET:		return "T_FC_CHARACTER_CHANGE_INFO_OPTION_SECRET";		// C->F, // 2008-06-23 by dhjin, EP3 ɼ -
	case T_FC_CHARACTER_CHANGE_INFO_OPTION_SECRET_OK:	return "T_FC_CHARACTER_CHANGE_INFO_OPTION_SECRET_OK";	// F->C, // 2008-06-23 by dhjin, EP3 ɼ -
	case T_FC_CHARACTER_CHANGE_NICKNAME:				return "T_FC_CHARACTER_CHANGE_NICKNAME";		// C->F, // 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_CHARACTER_CHANGE_NICKNAME_OK:				return "T_FC_CHARACTER_CHANGE_NICKNAME_OK";		// F->C, // 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_CHARACTER_CHANGE_START_CITY_MAPINDEX:				return "T_FC_CHARACTER_CHANGE_START_CITY_MAPINDEX";		// 2009-10-12 by cmkwon, ī    - 
	case T_FC_CHARACTER_CHANGE_START_CITY_MAPINDEX_OK:			return "T_FC_CHARACTER_CHANGE_START_CITY_MAPINDEX_OK";	// 2009-10-12 by cmkwon, ī    - 
	case T_FC_CHARACTER_CHANGE_ADDED_INVENTORY_COUNT:			return "T_FC_CHARACTER_CHANGE_ADDED_INVENTORY_COUNT";	// 2009-11-02 by cmkwon, ĳ(κ/â Ȯ)  ߰  - 
	//////////////////////////////////////////////////////////////////
	// 2012-06-05 by jhseol, ۹̸ - Ŭû Ŷ ߰
	case T_FC_CHARACTER_GET_USER_ITEM_INFO:						return "T_FC_CHARACTER_GET_USER_ITEM_INFO";		// 2012-06-05 by jhseol, ۹̸ - 캼 ɸ UID
	case T_FC_CHARACTER_GET_USER_ITEM_INFO_OK:					return "T_FC_CHARACTER_GET_USER_ITEM_INFO_OK";	// 2012-06-05 by jhseol, ۹̸ - 캻 ɸ 
	case T_FC_CHARACTER_GET_USER_ITEM_INFO_OK_DONE:				return "T_FC_CHARACTER_GET_USER_ITEM_INFO_OK_DONE";	// 2012-06-05 by jhseol, ۹̸ - 캻 ɸ 
	case T_FC_CHARACTER_GET_USER_ITEM_INFO_SECRET:				return "T_FC_CHARACTER_GET_USER_ITEM_INFO_SECRET";		// 2012-07-12 by isshin ۹̸ On / Off  -  
	case T_FC_CHARACTER_GET_USER_ITEM_INFO_SECRET_OK:			return "T_FC_CHARACTER_GET_USER_ITEM_INFO_SECRET_OK";	// 2012-07-12 by isshin ۹̸ On / Off  -  

	case T_FC_CHARACTER_DEBUFF_DOT_INFO:				return "T_FC_CHARACTER_DEBUFF_DOT_INFO";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - C -> F
	case T_FC_CHARACTER_DEBUFF_DOT_INFO_OK:				return "T_FC_CHARACTER_DEBUFF_DOT_INFO_OK";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - F -> C
	case T_FC_CHARACTER_DEBUFF_DOT_APPLYING:			return "T_FC_CHARACTER_DEBUFF_DOT_APPLYING";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - F -> C
	case T_FC_CHARACTER_DEBUFF_DOT_RELEASE:				return "T_FC_CHARACTER_DEBUFF_DOT_RELEASE";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - F -> C

	// 2012-10-12 by jhjang  ƿ ġ ʽ ý 
	case T_FC_CHARACTER_KILLCOUNT:						return "T_FC_CHARACTER_KILLCOUNT";
	case T_FC_CHARACTER_RESTCOUNT:						return "T_FC_CHARACTER_RESTCOUNT";
	case T_FC_CHARACTER_BONUS_EXP_RATE:					return "T_FC_CHARACTER_BONUS_EXP_RATE";
	// end 2012-10-12 by jhjang  ƿ ġ ʽ ý 
	
	case T_FN_CHARACTER_CHANGE_UNITKIND:				return "T_FN_CHARACTER_CHANGE_UNITKIND";
	case T_FN_CHARACTER_CHANGE_BODYCONDITION:			return "T_FN_CHARACTER_CHANGE_BODYCONDITION";
	case T_FN_CHARACTER_CHANGE_HPDPSPEP:				return "T_FN_CHARACTER_CHANGE_HPDPSPEP";
	case T_FN_CHARACTER_CHANGE_CURRENTHPDPSPEP:			return "T_FN_CHARACTER_CHANGE_CURRENTHPDPSPEP";
	case T_FN_CHARACTER_CHANGE_MAPNAME:					return "T_FN_CHARACTER_CHANGE_MAPNAME";
	case T_FN_CHARACTER_CHANGE_POSITION:				return "T_FN_CHARACTER_CHANGE_POSITION";
	case T_FN_CHARACTER_CHANGE_STEALTHSTATE:			return "T_FN_CHARACTER_CHANGE_STEALTHSTATE";
	case T_FN_CHARACTER_CHANGE_CHARACTER_MODE_OK:					return "T_FN_CHARACTER_CHANGE_CHARACTER_MODE_OK";
	case T_FN_CHARACTER_CHANGE_INFLUENCE_TYPE:				return "T_FN_CHARACTER_CHANGE_INFLUENCE_TYPE";
	case T_FN_CHARACTER_CHANGE_INVISIBLE:				return "T_FN_CHARACTER_CHANGE_INVISIBLE";

	case T_FC_MOVE:										return "T_FC_MOVE";
	case T_FC_MOVE_OK:									return "T_FC_MOVE_OK";
	case T_FC_MOVE_LOCKON:								return "T_FC_MOVE_LOCKON";
	case T_FC_MOVE_LOCKON_OK:							return "T_FC_MOVE_LOCKON_OK";
	case T_FC_MOVE_UNLOCKON:							return "T_FC_MOVE_UNLOCKON";
	case T_FC_MOVE_UNLOCKON_OK:							return "T_FC_MOVE_UNLOCKON_OK";
	case T_FC_MOVE_LANDING:								return "T_FC_MOVE_LANDING";
	case T_FC_MOVE_LANDING_OK:							return "T_FC_MOVE_LANDING_OK";
	case T_FC_MOVE_LANDING_DONE:						return "T_FC_MOVE_LANDING_DONE";
	case T_FC_MOVE_TAKEOFF:								return "T_FC_MOVE_TAKEOFF";
	case T_FC_MOVE_TAKEOFF_OK:							return "T_FC_MOVE_TAKEOFF_OK";
	case T_FC_MISSILE_MOVE_OK:							return "T_FC_MISSILE_MOVE_OK";
	case T_FC_MOVE_TARGET:								return "T_FC_MOVE_TARGET";
	case T_FC_MOVE_WEAPON_VEL:							return "T_FC_MOVE_WEAPON_VEL";
	case T_FC_MOVE_WEAPON_VEL_OK:						return "T_FC_MOVE_WEAPON_VEL_OK";
	case T_FC_MOVE_ROLLING:								return "T_FC_MOVE_ROLLING";
	case T_FC_MOVE_ROLLING_OK:							return "T_FC_MOVE_ROLLING_OK";
	case T_FC_MOVE_HACKSHIELD_GuidReqMsg:				return "T_FC_MOVE_HACKSHIELD_GuidReqMsg";
	case T_FC_MOVE_HACKSHIELD_GuidAckMsg:				return "T_FC_MOVE_HACKSHIELD_GuidAckMsg";
	case T_FC_MOVE_HACKSHIELD_CRCReqMsg:				return "T_FC_MOVE_HACKSHIELD_CRCReqMsg";
	case T_FC_MOVE_HACKSHIELD_CRCAckMsg:				return "T_FC_MOVE_HACKSHIELD_CRCAckMsg";
	case T_FC_MOVE_HACKSHIELD_HACKING_CLIENT:			return "T_FC_MOVE_HACKSHIELD_HACKING_CLIENT";
	case T_FC_MOVE_XIGNCODE_REQ_SCAN_INIT:				return "T_FC_MOVE_XIGNCODE_REQ_SCAN_INIT";			// 2008-11-28 by cmkwon, 븸 Netpower_Tpe XignCode(Ӱ)  - 
	case T_FC_MOVE_XIGNCODE_REQ_SCAN_INIT_OK:			return "T_FC_MOVE_XIGNCODE_REQ_SCAN_INIT_OK";		// 2008-11-28 by cmkwon, 븸 Netpower_Tpe XignCode(Ӱ)  - 
	case T_FC_MOVE_XIGNCODE_REQ_SCAN_CHECK:				return "T_FC_MOVE_XIGNCODE_REQ_SCAN_CHECK";			// 2008-11-28 by cmkwon, 븸 Netpower_Tpe XignCode(Ӱ)  - 
	case T_FC_MOVE_XIGNCODE_REQ_SCAN_CHECK_OK:			return "T_FC_MOVE_XIGNCODE_REQ_SCAN_CHECK_OK";		// 2008-11-28 by cmkwon, 븸 Netpower_Tpe XignCode(Ӱ)  - 
	case T_FC_MOVE_NPROTECT_REQ_AUTH_DATA:				return "T_FC_MOVE_NPROTECT_REQ_AUTH_DATA";			// 2009-03-09 by cmkwon, Ϻ Arario nProtect CS ϱ - 
	case T_FC_MOVE_NPROTECT_REQ_AUTH_DATA_OK:			return "T_FC_MOVE_NPROTECT_REQ_AUTH_DATA_OK";		// 2009-03-09 by cmkwon, Ϻ Arario nProtect CS ϱ - 
	case T_FC_MOVE_XTRAP_REQ_STEP:						return "T_FC_MOVE_XTRAP_REQ_STEP";			// 2009-10-06 by cmkwon, Ʈ   X-TRAP  - 
	case T_FC_MOVE_XTRAP_REQ_STEP_OK:					return "T_FC_MOVE_XTRAP_REQ_STEP_OK";		// 2009-10-06 by cmkwon, Ʈ   X-TRAP  - 
	case T_FC_MOVE_APEX_REQ_APEXDATA:					return "T_FC_MOVE_APEX_REQ_APEXDATA";			// 2009-11-04 by cmkwon, ± Ӱ Apex  - 
	case T_FC_MOVE_APEX_REQ_APEXDATA_OK:				return "T_FC_MOVE_APEX_REQ_APEXDATA_OK";		// 2009-11-04 by cmkwon, ± Ӱ Apex  - 

	case T_FN_MONSTER_MOVE:								return "T_FN_MONSTER_MOVE";
	case T_FN_MOVE_OK:									return "T_FN_MOVE_OK";
	case T_FN_MOVE_LOCKON:								return "T_FN_MOVE_LOCKON";
	case T_FN_MOVE_LOCKON_OK:							return "T_FN_MOVE_LOCKON_OK";
	case T_FN_MOVE_LOCKON_AVOID:						return "T_FN_MOVE_LOCKON_AVOID";
	case T_FN_MOVE_LOCKON_AVOID_OK:						return "T_FN_MOVE_LOCKON_AVOID_OK";
	case T_FN_MISSILE_MOVE:								return "T_FN_MISSILE_MOVE";
	case T_FN_MONSTER_HPRECOVERY:						return "T_FN_MONSTER_HPRECOVERY";
	case T_FN_MONSTER_HIDE:								return "T_FN_MONSTER_HIDE";
	case T_FN_MONSTER_SHOW:								return "T_FN_MONSTER_SHOW";
	case T_FC_BATTLE_ATTACK:							return "T_FC_BATTLE_ATTACK";
	case T_FC_BATTLE_ATTACK_OK:							return "T_FC_BATTLE_ATTACK_OK";
	case T_FC_BATTLE_ATTACK_FIND:						return "T_FC_BATTLE_ATTACK_FIND";
	case T_FC_BATTLE_ATTACK_FIND_OK:					return "T_FC_BATTLE_ATTACK_FIND_OK";
	case T_FC_BATTLE_DROP_MINE:							return "T_FC_BATTLE_DROP_MINE";
	case T_FC_BATTLE_DROP_MINE_OK:						return "T_FC_BATTLE_DROP_MINE_OK";
	case T_FC_BATTLE_MINE_ATTACK:						return "T_FC_BATTLE_MINE_ATTACK";
	case T_FC_BATTLE_MINE_ATTACK_OK:					return "T_FC_BATTLE_MINE_ATTACK_OK";
	case T_FC_BATTLE_MINE_ATTACK_FIND:					return "T_FC_BATTLE_MINE_ATTACK_FIND";
	case T_FC_BATTLE_MINE_ATTACK_FIND_OK:				return "T_FC_BATTLE_MINE_ATTACK_FIND_OK";
	case T_FC_BATTLE_REQUEST_PK:						return "T_FC_BATTLE_REQUEST_PK";
	case T_FC_BATTLE_REQUEST_PK_OK:						return "T_FC_BATTLE_REQUEST_PK_OK";
	case T_FC_BATTLE_CANCEL_PK:							return "T_FC_BATTLE_CANCEL_PK";
	case T_FC_BATTLE_REQUEST_P2P_PK:					return "T_FC_BATTLE_REQUEST_P2P_PK";
	case T_FC_BATTLE_REQUEST_P2P_PK_OK:					return "T_FC_BATTLE_REQUEST_P2P_PK_OK";
	case T_FC_BATTLE_ACCEPT_REQUEST_P2P_PK:				return "T_FC_BATTLE_ACCEPT_REQUEST_P2P_PK";
	case T_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK:			return "T_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK";
	case T_FC_BATTLE_REJECT_REQUEST_P2P_PK:				return "T_FC_BATTLE_REJECT_REQUEST_P2P_PK";
	case T_FC_BATTLE_REJECT_REQUEST_P2P_PK_OK:			return "T_FC_BATTLE_REJECT_REQUEST_P2P_PK_OK";
	case T_FC_BATTLE_SURRENDER_P2P_PK:					return "T_FC_BATTLE_SURRENDER_P2P_PK";
	case T_FC_BATTLE_SURRENDER_P2P_PK_OK:				return "T_FC_BATTLE_SURRENDER_P2P_PK_OK";
	case T_FC_BATTLE_ACCEPT_SURRENDER_P2P_PK:			return "T_FC_BATTLE_ACCEPT_SURRENDER_P2P_PK";
	case T_FC_BATTLE_REJECT_SURRENDER_P2P_PK:			return "T_FC_BATTLE_REJECT_SURRENDER_P2P_PK";
	case T_FC_BATTLE_REJECT_SURRENDER_P2P_PK_OK:		return "T_FC_BATTLE_REJECT_SURRENDER_P2P_PK_OK";
	case T_FC_BATTLE_END_P2P_PK:						return "T_FC_BATTLE_END_P2P_PK";
	case T_FC_BATTLE_ATTACK_EXPLODE_ITEM:				return "T_FC_BATTLE_ATTACK_EXPLODE_ITEM";
	case T_FC_BATTLE_ATTACK_HIDE_ITEM:					return "T_FC_BATTLE_ATTACK_HIDE_ITEM";
	case T_FC_BATTLE_ATTACK_EXPLODE_ITEM_W_KIND:		return "T_FC_BATTLE_ATTACK_EXPLODE_ITEM_W_KIND";
	case T_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND:			return "T_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND";
	case T_FC_BATTLE_TOGGLE_SHIELD:						return "T_FC_BATTLE_TOGGLE_SHIELD";
	case T_FC_BATTLE_TOGGLE_SHIELD_RESULT:				return "T_FC_BATTLE_TOGGLE_SHIELD_RESULT";
	case T_FC_BATTLE_DROP_DUMMY:						return "T_FC_BATTLE_DROP_DUMMY";
	case T_FC_BATTLE_DROP_DUMMY_OK:						return "T_FC_BATTLE_DROP_DUMMY_OK";
	case T_FC_BATTLE_DROP_FIXER:						return "T_FC_BATTLE_DROP_FIXER";
	case T_FC_BATTLE_DROP_FIXER_OK:						return "T_FC_BATTLE_DROP_FIXER_OK";
	case T_FC_BATTLE_PRI_BULLET_RELOADED:				return "T_FC_BATTLE_PRI_BULLET_RELOADED";
	case T_FC_BATTLE_SEC_BULLET_RELOADED:				return "T_FC_BATTLE_SEC_BULLET_RELOADED";
	case T_FC_BATTLE_SHIELD_DAMAGE:						return "T_FC_BATTLE_SHIELD_DAMAGE";
	case T_FC_BATTLE_TOGGLE_DECOY:						return "T_FC_BATTLE_TOGGLE_DECOY";
	case T_FC_BATTLE_TOGGLE_DECOY_OK:					return "T_FC_BATTLE_TOGGLE_DECOY_OK";
	case T_FC_BATTLE_SHOW_DAMAGE:						return "T_FC_BATTLE_SHOW_DAMAGE";
	case T_FC_BATTLE_ATTACK_EVASION:					return "T_FC_BATTLE_ATTACK_EVASION";
	case T_FC_BATTLE_ATTACK_EVASION_OK:					return "T_FC_BATTLE_ATTACK_EVASION_OK";
	case T_FC_BATTLE_DELETE_DUMMY_OK:					return "T_FC_BATTLE_DELETE_DUMMY_OK";		// 2006-12-04 by dhjin
	case T_FC_BATTLE_EXPLODE_DUMMY_OK:					return "T_FC_BATTLE_EXPLODE_DUMMY_OK";		// 2006-12-04 by dhjin
	case T_FC_BATTLE_MONSTER_BARRIER_USING:				return "T_FC_BATTLE_MONSTER_BARRIER_USING";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - F -> C
	case T_FC_BATTLE_MONSTER_BARRIER_USE:				return "T_FC_BATTLE_MONSTER_BARRIER_USE";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - F -> C(n)

	case T_FN_BATTLE_ATTACK_PRIMARY:					return "T_FN_BATTLE_ATTACK_PRIMARY";
	case T_FN_BATTLE_ATTACK_RESULT_PRIMARY:				return "T_FN_BATTLE_ATTACK_RESULT_PRIMARY";
	case T_FN_BATTLE_ATTACK_SECONDARY:					return "T_FN_BATTLE_ATTACK_SECONDARY";
	case T_FN_BATTLE_ATTACK_RESULT_SECONDARY:			return "T_FN_BATTLE_ATTACK_RESULT_SECONDARY";
	case T_FN_BATTLE_ATTACK_FIND:						return "T_FN_BATTLE_ATTACK_FIND";
	case T_FN_BATTLE_ATTACK_FIND_RESULT:				return "T_FN_BATTLE_ATTACK_FIND_RESULT";
	case T_FN_BATTLE_SET_ATTACK_CHARACTER:				return "T_FN_BATTLE_SET_ATTACK_CHARACTER";
	case T_FN_BATTLE_DROP_FIXER:						return "T_FN_BATTLE_DROP_FIXER";
	case T_FN_BATTLE_DROP_FIXER_OK:						return "T_FN_BATTLE_DROP_FIXER_OK";
	case T_FN_BATTLE_ATTACK_HIDE_ITEM_W_KIND:			return "T_FN_BATTLE_ATTACK_HIDE_ITEM_W_KIND";
	case T_FN_BATTLE_ATTACK_SKILL:						return "T_FN_BATTLE_ATTACK_SKILL";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - N -> F
	case T_FC_PARTY_CREATE_OK:							return "T_FC_PARTY_CREATE_OK";
	case T_FC_PARTY_REQUEST_INVITE:						return "T_FC_PARTY_REQUEST_INVITE";
	case T_FC_PARTY_REQUEST_INVITE_QUESTION:			return "T_FC_PARTY_REQUEST_INVITE_QUESTION";
	case T_FC_PARTY_ACCEPT_INVITE:						return "T_FC_PARTY_ACCEPT_INVITE";
	case T_FC_PARTY_REJECT_INVITE:						return "T_FC_PARTY_REJECT_INVITE";
	case T_FC_PARTY_REJECT_INVITE_OK:					return "T_FC_PARTY_REJECT_INVITE_OK";
	case T_FC_PARTY_GET_MEMBER:							return "T_FC_PARTY_GET_MEMBER";
	case T_FC_PARTY_PUT_MEMBER:							return "T_FC_PARTY_PUT_MEMBER";
	case T_FC_PARTY_GET_ALL_MEMBER:						return "T_FC_PARTY_GET_ALL_MEMBER";
	case T_FC_PARTY_PUT_ALL_MEMBER:						return "T_FC_PARTY_PUT_ALL_MEMBER";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_ALL:				return "T_FC_PARTY_UPDATE_MEMBER_INFO_ALL";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_LEVEL:			return "T_FC_PARTY_UPDATE_MEMBER_INFO_LEVEL";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_HP:				return "T_FC_PARTY_UPDATE_MEMBER_INFO_HP";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_HP:		return "T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_HP";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_DP:				return "T_FC_PARTY_UPDATE_MEMBER_INFO_DP";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_DP:		return "T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_DP";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_SP:				return "T_FC_PARTY_UPDATE_MEMBER_INFO_SP";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_SP:		return "T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_SP";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_EP:				return "T_FC_PARTY_UPDATE_MEMBER_INFO_EP";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_EP:		return "T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_EP";
	case T_FC_PARTY_UPDATE_MEMBER_INFO_BODYCONDITION:	return "T_FC_PARTY_UPDATE_MEMBER_INFO_BODYCONDITION";
	case T_FC_PARTY_REQUEST_PARTY_WARP:					return "T_FC_PARTY_REQUEST_PARTY_WARP";
	case T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME:	return "T_FC_PARTY_REQUEST_PARTY_WARP_WITH_MAP_NAME";
	case T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT:			return "T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT";
	case T_FC_PARTY_GET_OTHER_MOVE:						return "T_FC_PARTY_GET_OTHER_MOVE";
	case T_FC_PARTY_BATTLE_START:						return "T_FC_PARTY_BATTLE_START";
	case T_FC_PARTY_BATTLE_END:							return "T_FC_PARTY_BATTLE_END";
	case T_FC_PARTY_PUT_ITEM_OTHER:						return "T_FC_PARTY_PUT_ITEM_OTHER";
	case T_FI_PARTY_CREATE_OK:							return "T_FI_PARTY_CREATE_OK";
	case T_FI_PARTY_ACCEPT_INVITE_OK:					return "T_FI_PARTY_ACCEPT_INVITE_OK";
	case T_FI_PARTY_BAN_MEMBER_OK:						return "T_FI_PARTY_BAN_MEMBER_OK";
	case T_FI_PARTY_LEAVE_OK:							return "T_FI_PARTY_LEAVE_OK";
	case T_FI_PARTY_TRANSFER_MASTER_OK:					return "T_FI_PARTY_TRANSFER_MASTER_OK";
	case T_FI_PARTY_DISMEMBER_OK:						return "T_FI_PARTY_DISMEMBER_OK";
	case T_FI_PARTY_CHANGE_FLIGHT_FORMATION_OK:			return "T_FI_PARTY_CHANGE_FLIGHT_FORMATION_OK";
	case T_FI_PARTY_CHANGE_FLIGHT_POSITION:				return "T_FI_PARTY_CHANGE_FLIGHT_POSITION";
	case T_FI_PARTY_CANCEL_FLIGHT_POSITION:				return "T_FI_PARTY_CANCEL_FLIGHT_POSITION";
	case T_FI_PARTY_NOTIFY_BATTLE_PARTY:				return "T_FI_PARTY_NOTIFY_BATTLE_PARTY";
	case T_FI_PARTY_NOTIFY_BATTLE_PARTY_OK:				return "T_FI_PARTY_NOTIFY_BATTLE_PARTY_OK";
	case T_FI_PARTY_ADD_MEMBER:							return "T_FI_PARTY_ADD_MEMBER";
	case T_FI_PARTY_DELETE_MEMBER:						return "T_FI_PARTY_DELETE_MEMBER";
	case T_FI_PARTY_UPDATE_ITEM_POS:					return "T_FI_PARTY_UPDATE_ITEM_POS";
	case T_FI_PARTY_ALL_FLIGHT_POSITION:				return "T_FI_PARTY_ALL_FLIGHT_POSITION";
	case T_FI_PARTY_UPDATE_PARTY_INFO:					return "T_FI_PARTY_UPDATE_PARTY_INFO";
	case T_FI_PARTY_CHANGE_EXP_DISTRIBUTE_TYPE:			return "T_FI_PARTY_CHANGE_EXP_DISTRIBUTE_TYPE";		// 2008-06-04 by dhjin, EP3   - ġ й   
	case T_FI_PARTY_CHANGE_ITEM_DISTRIBUTE_TYPE:		return "T_FI_PARTY_CHANGE_ITEM_DISTRIBUTE_TYPE";	// 2008-06-04 by dhjin, EP3   -  й  
	case T_FI_PARTY_CHANGE_FORMATION_SKILL:				return "T_FI_PARTY_CHANGE_FORMATION_SKILL";			// 2009-08-03 by cmkwon, EP3-4   ų  - 
	case T_FI_PARTY_ARENA_TEAM_NUM:						return "T_FI_PARTY_ARENA_TEAM_NUM";					// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ :   üũ ȣ 

	case T_IC_PARTY_CREATE:								return "T_IC_PARTY_CREATE";
	case T_IC_PARTY_ACCEPT_INVITE_OK:					return "T_IC_PARTY_ACCEPT_INVITE_OK";
	case T_IC_PARTY_GET_MEMBER:							return "T_IC_PARTY_GET_MEMBER";
	case T_IC_PARTY_PUT_MEMBER:							return "T_IC_PARTY_PUT_MEMBER";
	case T_IC_PARTY_GET_ALL_MEMBER:						return "T_IC_PARTY_GET_ALL_MEMBER";
	case T_IC_PARTY_PUT_ALL_MEMBER:						return "T_IC_PARTY_PUT_ALL_MEMBER";
	case T_IC_PARTY_BAN_MEMBER:							return "T_IC_PARTY_BAN_MEMBER";
	case T_IC_PARTY_BAN_MEMBER_OK:						return "T_IC_PARTY_BAN_MEMBER_OK";
	case T_IC_PARTY_LEAVE:								return "T_IC_PARTY_LEAVE";
	case T_IC_PARTY_LEAVE_OK:							return "T_IC_PARTY_LEAVE_OK";
	case T_IC_PARTY_TRANSFER_MASTER:					return "T_IC_PARTY_TRANSFER_MASTER";
	case T_IC_PARTY_TRANSFER_MASTER_OK:					return "T_IC_PARTY_TRANSFER_MASTER_OK";
	case T_IC_PARTY_DISMEMBER:							return "T_IC_PARTY_DISMEMBER";
	case T_IC_PARTY_DISMEMBER_OK:						return "T_IC_PARTY_DISMEMBER_OK";
	case T_IC_PARTY_CHANGE_FLIGHT_FORMATION:			return "T_IC_PARTY_CHANGE_FLIGHT_FORMATION";
	case T_IC_PARTY_CHANGE_FLIGHT_FORMATION_OK:			return "T_IC_PARTY_CHANGE_FLIGHT_FORMATION_OK";
	case T_IC_PARTY_GET_FLIGHT_POSITION:				return "T_IC_PARTY_GET_FLIGHT_POSITION";
	case T_IC_PARTY_CHANGE_FLIGHT_POSITION:				return "T_IC_PARTY_CHANGE_FLIGHT_POSITION";
	case T_IC_PARTY_CANCEL_FLIGHT_POSITION:				return "T_IC_PARTY_CANCEL_FLIGHT_POSITION";
	case T_IC_PARTY_PUT_LAST_PARTY_INFO:				return "T_IC_PARTY_PUT_LAST_PARTY_INFO";
	case T_IC_PARTY_UPDATE_MEMBER_INFO_MAPNAME:			return "T_IC_PARTY_UPDATE_MEMBER_INFO_MAPNAME";
	case T_IC_PARTY_MEMBER_INVALIDATED:					return "T_IC_PARTY_MEMBER_INVALIDATED";
	case T_IC_PARTY_MEMBER_REJOINED:					return "T_IC_PARTY_MEMBER_REJOINED";
	case T_IC_PARTY_UPDATE_ITEM_POS:					return "T_IC_PARTY_UPDATE_ITEM_POS";
	case T_IC_PARTY_ALL_FLIGHT_POSITION:				return "T_IC_PARTY_ALL_FLIGHT_POSITION";
	case T_IC_PARTY_REQUEST_PARTYINFO_FROM_A_TO_M:		return "T_IC_PARTY_REQUEST_PARTYINFO_FROM_A_TO_M";	// 2008-02-28 by dhjin, Ʒ  - 
	case T_IC_PARTY_LEAVE_FROM_M_TO_A:					return "T_IC_PARTY_LEAVE_FROM_M_TO_A";				// 2008-02-28 by dhjin, Ʒ  -
	case T_IC_PARTY_LEAVE_FROM_A_TO_M:					return "T_IC_PARTY_LEAVE_FROM_A_TO_M";				// 2008-02-28 by dhjin, Ʒ  -
	case T_IC_PARTY_LIST_INFO:							return "T_IC_PARTY_LIST_INFO";						// C -> I, 2008-06-02 by dhjin, EP3   -   Ʈ û
	case T_IC_PARTY_LIST_INFO_OK:						return "T_IC_PARTY_LIST_INFO_OK";					// I -> C, 2008-06-02 by dhjin, EP3   -   Ʈ û OK
	case T_IC_PARTY_JOIN_FREE:							return "T_IC_PARTY_JOIN_FREE";						// C -> I, 2008-06-03 by dhjin, EP3   -   
	case T_IC_PARTY_JOIN_FREE_OK:						return "T_IC_PARTY_JOIN_FREE_OK";					// I -> C, 2008-06-03 by dhjin, EP3   -    OK
	case T_IC_PARTY_CHANGE_INFO:						return "T_IC_PARTY_CHANGE_INFO";					// C -> I, 2008-06-04 by dhjin, EP3   -   
	case T_IC_PARTY_CHANGE_INFO_OK:						return "T_IC_PARTY_CHANGE_INFO_OK";					// I -> C, 2008-06-04 by dhjin, EP3   -    OK
	case T_IC_PARTY_RECOMMENDATION_MEMBER:				return "T_IC_PARTY_RECOMMENDATION_MEMBER";			// C -> I, 2008-06-04 by dhjin, EP3   - õ ɸ û
	case T_IC_PARTY_RECOMMENDATION_MEMBER_OK:			return "T_IC_PARTY_RECOMMENDATION_MEMBER_OK";		// I -> C, 2008-06-04 by dhjin, EP3   - õ ɸ û OK
	case T_IC_PARTY_INFO:								return "T_IC_PARTY_INFO";							// I -> C, 2008-06-10 by dhjin, EP3   -   
	case T_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA:	return "T_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA";	// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ʒ   ڵ Ƽ Ҷ ϴ Ŷ
	case T_FC_PARTY_AUTO_CREATED_THE_ARENA:				return "T_FC_PARTY_AUTO_CREATED_THE_ARENA";			// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ʒ   ڵ Ƽ Ҷ ϴ Ŷ
	
	case T_FI_CHARACTER_DELETE_CHARACTER:				return "T_FI_CHARACTER_DELETE_CHARACTER";
	case T_FI_CHARACTER_CHANGE_LEVEL:					return "T_FI_CHARACTER_CHANGE_LEVEL";
	case T_FI_CHARACTER_UPDATE_GUILD_INFO:				return "T_FI_CHARACTER_UPDATE_GUILD_INFO";
	case T_FI_CHARACTER_UPDATE_MAP_CHANNEL:				return "T_FI_CHARACTER_UPDATE_MAP_CHANNEL";
	case T_FI_CHARACTER_CHANGE_INFLUENCE_TYPE:				return "T_FI_CHARACTER_CHANGE_INFLUENCE_TYPE";
	case T_FI_UPDATE_SUBLEADER:							return "T_FI_UPDATE_SUBLEADER";
	case T_FI_CREATE_GUILD_BY_SUBLEADER:				return "T_FI_CREATE_GUILD_BY_SUBLEADER";
		
	case T_FC_MONSTER_CREATED:							return "T_FC_MONSTER_CREATED";
	case T_FC_MONSTER_MOVE_OK:							return "T_FC_MONSTER_MOVE_OK";
	case T_FC_MONSTER_HIDE:								return "T_FC_MONSTER_HIDE";
	case T_FC_MONSTER_SHOW:								return "T_FC_MONSTER_SHOW";
	case T_FC_MONSTER_CHANGE_HP:						return "T_FC_MONSTER_CHANGE_HP";
	case T_FC_MONSTER_CHANGE_BODYCONDITION:				return "T_FC_MONSTER_CHANGE_BODYCONDITION";
	case T_FC_MONSTER_SKILL_USE_SKILL:					return "T_FC_MONSTER_SKILL_USE_SKILL";
	case T_FC_MONSTER_SKILL_END_SKILL:					return "T_FC_MONSTER_SKILL_END_SKILL";
	case T_FC_MONSTER_SUMMON_MONSTER:					return "T_FC_MONSTER_SUMMON_MONSTER";
	case T_FC_MONSTER_TUTORIAL_MONSTER_DEAD_NOTIFY:		return "T_FC_MONSTER_TUTORIAL_MONSTER_DEAD_NOTIFY";
	case T_FC_MONSTER_TUTORIAL_MONSTER_DELETE:			return "T_FC_MONSTER_TUTORIAL_MONSTER_DELETE";
	case T_FC_MONSTER_CHANGE_INDEX:						return "T_FC_MONSTER_CHANGE_INDEX";		// 2011-05-17 by hskim, ǴƼ 3 - ó׸  ü 

	case T_FC_MONSTER_CINEMA_DELETE_NOTIFY:				return "T_FC_MONSTER_CINEMA_DELETE_NOTIFY";		// 2011-05-30 by hskim, ǴƼ 3 -   Ŭ̾Ʈ ݿ

	case T_FC_TRIGGER_MAP_BUFF_SKILL:					return "T_FC_TRIGGER_MAP_BUFF_SKILL";			// 2011-10-18 by hskim, EP4 [Ʈ ý] - ȭ /  ǳ
	case T_FC_SET_LIMITTIME:							return "T_FC_SET_LIMITTIME";					// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý

	case T_FN_MAPPROJECT_START:							return "T_FN_MAPPROJECT_START";
	case T_FN_MAPPROJECT_START_OK:						return "T_FN_MAPPROJECT_START_OK";
	case T_FN_MAPPROJECT_START_OK_ACK:					return "T_FN_MAPPROJECT_START_OK_ACK";
	case T_FN_MONSTER_CREATE:							return "T_FN_MONSTER_CREATE";
	case T_FN_MONSTER_CREATE_OK:						return "T_FN_MONSTER_CREATE_OK";
	case T_FN_MONSTER_DELETE:							return "T_FN_MONSTER_DELETE";
	case T_FN_CLIENT_GAMESTART_OK:						return "T_FN_CLIENT_GAMESTART_OK";
	case T_FN_CLIENT_GAMEEND_OK:						return "T_FN_CLIENT_GAMEEND_OK";
	case T_FN_GET_CHARACTER_INFO:						return "T_FN_GET_CHARACTER_INFO";
	case T_FN_GET_CHARACTER_INFO_OK:					return "T_FN_GET_CHARACTER_INFO_OK";
	case T_FN_ADMIN_SUMMON_MONSTER:						return "T_FN_ADMIN_SUMMON_MONSTER";
	case T_FN_MONSTER_CHANGE_HP:						return "T_FN_MONSTER_CHANGE_HP";
	case T_FN_MONSTER_CHANGE_BODYCONDITION:				return "T_FN_MONSTER_CHANGE_BODYCONDITION";
	case T_FN_MONSTER_SKILL_USE_SKILL:					return "T_FN_MONSTER_SKILL_USE_SKILL";
	case T_FN_MONSTER_SKILL_END_SKILL:					return "T_FN_MONSTER_SKILL_END_SKILL";
	case T_FN_MONSTER_AUTO_DESTROYED:					return "T_FN_MONSTER_AUTO_DESTROYED";
	case T_FN_MONSTER_STRATEGYPOINT_INIT:				return "T_FN_MONSTER_STRATEGYPOINT_INIT";		// 2006-11-20 by cmkwon
	case T_FN_MONSTER_STRATEGYPOINT_SUMMON:				return "T_FN_MONSTER_STRATEGYPOINT_SUMMON";		// 2007-03-02 by dhjin
	case T_FN_MONSTER_OUTPOST_INIT:						return "T_FN_MONSTER_OUTPOST_INIT";				// 2007-08-24 by dhjin
	case T_FN_MONSTER_OUTPOST_RESET_SUMMON:				return "T_FN_MONSTER_OUTPOST_RESET_SUMMON";			// 2007-08-24 by dhjin
	case T_FN_MONSTER_CREATE_IN_MAPCHANNEL_BYVALUE:		return "T_FN_MONSTER_CREATE_IN_MAPCHANNEL_BYVALUE";			// 2007-08-29 by dhjin
	case T_FN_MONSTER_TELEPORT_SUMMON:					return "T_FN_MONSTER_TELEPORT_SUMMON";			// 2007-08-24 by dhjin

	case T_FN_NPCSERVER_START:							return "T_FN_NPCSERVER_START";
	case T_FN_NPCSERVER_START_OK:						return "T_FN_NPCSERVER_START_OK";
	case T_FN_NPCSERVER_SUMMON_JACO_MONSTER:			return "T_FN_NPCSERVER_SUMMON_JACO_MONSTER";
	case T_FN_NPCSERVER_DELETE_MONSTER_IN_MAPCHANNEL:	return "T_FN_NPCSERVER_DELETE_MONSTER_IN_MAPCHANNEL";	// 2007-08-22 by cmkwon, ش ä   ϱ  ߰

	case T_FN_MONSTER_CHANGE_OK:						return "T_FN_MONSTER_CHANGE_OK";		// 2011-05-11 by hskim, ǴƼ 3 - ó׸   ߰ - ش ä Ư    ߰
	case T_FN_NPCSERVER_CINEMA_MONSTER_DESTROY:			return "T_FN_NPCSERVER_CINEMA_MONSTER_DESTROY";		// 2011-04-28 by hskim, ǴƼ 3 - ó׸   ߰ - ش ä Ư    ߰
	case T_FN_NPCSERVER_CINEMA_MONSTER_CHANGE:			return "T_FN_NPCSERVER_CINEMA_MONSTER_CHANGE";		// 2011-05-11 by hskim, ǴƼ 3 - ó׸   ߰ - ش ä Ư    ߰
	case T_FN_NPCSERVER_CINEMA_MONSTER_REGEN:			return "T_FN_NPCSERVER_CINEMA_MONSTER_REGEN";		// 2011-06-02 by hskim, ǴƼ 3 -  6 - ֱ ȯ  

	case T_FC_INFINITY_SET_LIMITTIME:					return "T_FC_INFINITY_SET_LIMITTIME";		// 2011-05-30 by hskim, ǴƼ 3 - ÷ ð 缳  

	case T_FC_EVENT_WARP:								return "T_FC_EVENT_WARP";
	case T_FC_EVENT_WARP_SAME_MAP:						return "T_FC_EVENT_WARP_SAME_MAP";
	case T_FC_EVENT_WARP_SAME_MAP_DONE:					return "T_FC_EVENT_WARP_SAME_MAP_DONE";
	case T_FC_EVENT_WARP_SAME_FIELD_SERVER:				return "T_FC_EVENT_WARP_SAME_FIELD_SERVER";
	case T_FC_EVENT_WARP_SAME_FIELD_SERVER_DONE:		return "T_FC_EVENT_WARP_SAME_FIELD_SERVER_DONE";
	case T_FC_EVENT_OTHER_WARPED:						return "T_FC_EVENT_OTHER_WARPED";
	case T_FC_EVENT_WARP_CONNECT_OK:					return "T_FC_EVENT_WARP_CONNECT_OK";
	case T_FC_EVENT_ENTER_BUILDING:						return "T_FC_EVENT_ENTER_BUILDING";
	case T_FC_EVENT_ENTER_BUILDING_OK:					return "T_FC_EVENT_ENTER_BUILDING_OK";
	case T_FC_EVENT_LEAVE_BUILDING:						return "T_FC_EVENT_LEAVE_BUILDING";
	case T_FC_EVENT_LEAVE_BUILDING_OK:					return "T_FC_EVENT_LEAVE_BUILDING_OK";
	case T_FC_EVENT_REQUEST_WARP:						return "T_FC_EVENT_REQUEST_WARP";
	case T_FC_EVENT_REJECT_WARP:						return "T_FC_EVENT_REJECT_WARP";
	case T_FC_EVENT_REQUEST_OBJECT_EVENT:				return "T_FC_EVENT_REQUEST_OBJECT_EVENT";
	case T_FC_EVENT_CHANGE_WEATHER:						return "T_FC_EVENT_CHANGE_WEATHER";
	case T_FC_EVENT_SUGGEST_CHANNELS:					return "T_FC_EVENT_SUGGEST_CHANNELS";
	case T_FC_EVENT_SELECT_CHANNEL:						return "T_FC_EVENT_SELECT_CHANNEL";
	case T_FC_EVENT_SELECT_CHANNEL_WITH_PARTY:			return "T_FC_EVENT_SELECT_CHANNEL_WITH_PARTY";
	case T_FC_EVENT_REQUEST_RACING_WARP:				return "T_FC_EVENT_REQUEST_RACING_WARP";
	case T_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST:		return "T_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST";
	case T_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST_OK:	return "T_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST_OK";
	case T_FC_EVENT_REQUEST_SHOP_WARP:					return "T_FC_EVENT_REQUEST_SHOP_WARP";
	case T_FC_EVENT_CHARACTERMODE_ENTER_BUILDING:		return "T_FC_EVENT_CHARACTERMODE_ENTER_BUILDING";
	case T_FC_EVENT_CALL_WARP_EVENT_REQUEST:			return "T_FC_EVENT_CALL_WARP_EVENT_REQUEST";
	case T_FC_EVENT_CALL_WARP_EVENT_REQUEST_ACK:		return "T_FC_EVENT_CALL_WARP_EVENT_REQUEST_ACK";
	case T_FC_EVENT_CLICK_TELEPORT:						return "T_FC_EVENT_CLICK_TELEPORT";
	case T_FC_EVENT_CLICK_TELEPORT_OK:					return "T_FC_EVENT_CLICK_TELEPORT_OK";			// 2008-04-22 by dhjin,   ǥ ȹ - ڷƮ  Ϸ ð
	case T_FC_EVENT_TELEPORT_BUILDCOMPLETE:				return "T_FC_EVENT_TELEPORT_BUILDCOMPLETE";		
	case T_FC_EVENT_TELEPORT_DESTROY:					return "T_FC_EVENT_TELEPORT_DESTROY";

	case T_FC_EVENT_NOTIFY_MSG_GET:						return "T_FC_EVENT_NOTIFY_MSG_GET";		// 2007-11-28 by cmkwon, ý  -
	case T_FC_EVENT_NOTIFY_MSG_GET_OK:					return "T_FC_EVENT_NOTIFY_MSG_GET_OK";	// 2007-11-28 by cmkwon, ý  -
	case T_FC_EVENT_NOTIFY_MSG_DELETE:					return "T_FC_EVENT_NOTIFY_MSG_DELETE";	// 2007-11-28 by cmkwon, ý  -

	case T_FC_EVENT_COUPON_EVENT_INFO:					return "T_FC_EVENT_COUPON_EVENT_INFO";			// 2008-01-10 by cmkwon,  ̺Ʈ ýۿ   ý ߰ - 
	case T_FC_EVENT_COUPON_EVENT_USE_COUPON:			return "T_FC_EVENT_COUPON_EVENT_USE_COUPON";	// 2008-01-10 by cmkwon,  ̺Ʈ ýۿ   ý ߰ - 
	case T_FC_EVENT_COUPON_EVENT_USE_COUPON_OK:			return "T_FC_EVENT_COUPON_EVENT_USE_COUPON_OK";	// 2008-01-10 by cmkwon,  ̺Ʈ ýۿ   ý ߰ - 

	case T_FN_EVENT_WARP:								return "T_FN_EVENT_WARP";
	case T_FN_EVENT_OTHER_WARPED:						return "T_FN_EVENT_OTHER_WARPED";
	case T_FN_EVENT_WARP_CONNECT_OK:					return "T_FN_EVENT_WARP_CONNECT_OK";
// 2005-07-27 by cmkwon, ٸ ʵ弭  Ƿ 
//	case T_FP_EVENT_NOTIFY_WARP:						return "T_FP_EVENT_NOTIFY_WARP";
//	case T_FP_EVENT_NOTIFY_WARP_OK:						return "T_FP_EVENT_NOTIFY_WARP_OK";
	case T_FP_EVENT_ENTER_SELECT_SCREEN:				return "T_FP_EVENT_ENTER_SELECT_SCREEN";
	case T_FP_EVENT_GAME_STARTED:						return "T_FP_EVENT_GAME_STARTED";
	case T_FP_EVENT_MAP_CHANGED:						return "T_FP_EVENT_MAP_CHANGED";
	case T_FP_EVENT_RELOAD_HAPPYEV:						return "T_FP_EVENT_RELOAD_HAPPYEV";
	case T_FP_EVENT_RELOAD_ITEMEV:						return "T_FP_EVENT_RELOAD_ITEMEV";

	case T_FP_EVENT_UPDATE_PCBANGLIST:					return "T_FP_EVENT_UPDATE_PCBANGLIST";
	case T_FP_EVENT_UPDATE_STRATEGYPOINT_NOTSUMMONTIM:	return "T_FP_EVENT_UPDATE_STRATEGYPOINT_NOTSUMMONTIM";

	case T_FP_CASH_CHANGE_CHARACTERNAME:				return "T_FP_CASH_CHANGE_CHARACTERNAME";

	case T_FP_ADMIN_BLOCKACCOUNT:						return "T_FP_ADMIN_BLOCKACCOUNT";		// 2008-01-31 by cmkwon,  / ɾ  ý  - 
	case T_FP_ADMIN_BLOCKACCOUNT_OK:					return "T_FP_ADMIN_BLOCKACCOUNT_OK";	// 2008-01-31 by cmkwon,  / ɾ  ý  - 
	case T_FP_ADMIN_UNBLOCKACCOUNT:						return "T_FP_ADMIN_UNBLOCKACCOUNT";		// 2008-01-31 by cmkwon,  / ɾ  ý  - 
	case T_FP_ADMIN_UNBLOCKACCOUNT_OK:					return "T_FP_ADMIN_UNBLOCKACCOUNT_OK";	// 2008-01-31 by cmkwon,  / ɾ  ý  - 
		
	case T_FP_ADMIN_STRATRGYPOINT_INFO_CHANGE:	return "T_FP_ADMIN_STRATRGYPOINT_INFO_CHANGE";	// 2012-11-13 by jhseol,  ý  - 

	case T_FP_GLOG_CONNECT_USER_NEW:					return "T_FP_GLOG_CONNECT_USER_NEW";		// 2012-01-08 by hskim, GLog 2
	case T_FP_GLOG_CONNECT_USER_LOGIN:					return "T_FP_GLOG_CONNECT_USER_LOGIN";		// 2012-01-08 by hskim, GLog 2

	case T_FP_MONITOR_SET_MGAME_EVENT_TYPE:				return "T_FP_MONITOR_SET_MGAME_EVENT_TYPE";
	case T_FP_MONITOR_RELOAD_VERSION_INFO_OK:			return "T_FP_MONITOR_RELOAD_VERSION_INFO_OK";		// 2008-09-08 by cmkwon, SCMonitor ReloadVersionInfoÿ Ϻ üũ(.\Res-Tex\*.*) εϱ - 

	case T_FC_STORE_GET_ITEM:							return "T_FC_STORE_GET_ITEM";
	case T_FC_STORE_PUT_ITEM_HEADER:					return "T_FC_STORE_PUT_ITEM_HEADER";
	case T_FC_STORE_PUT_ITEM:							return "T_FC_STORE_PUT_ITEM";
	case T_FC_STORE_PUT_ITEM_DONE:						return "T_FC_STORE_PUT_ITEM_DONE";
	case T_FC_STORE_MOVE_ITEM:							return "T_FC_STORE_MOVE_ITEM";
	case T_FC_STORE_MOVE_ITEM_OK:						return "T_FC_STORE_MOVE_ITEM_OK";
	case T_FC_STORE_INSERT_ITEM:						return "T_FC_STORE_INSERT_ITEM";
	case T_FC_STORE_DELETE_ITEM:						return "T_FC_STORE_DELETE_ITEM";
	case T_FC_STORE_UPDATE_ITEM_COUNT:					return "T_FC_STORE_UPDATE_ITEM_COUNT";
	case T_FC_STORE_UPDATE_ENDURANCE:					return "T_FC_STORE_UPDATE_ENDURANCE";
	case T_FC_STORE_UPDATE_POSSESS:						return "T_FC_STORE_UPDATE_POSSESS";
	case T_FC_STORE_UPDATE_RARE_FIX:					return "T_FC_STORE_UPDATE_RARE_FIX";
	case T_FC_STORE_INSERT_USINGITEM:					return "T_FC_STORE_INSERT_USINGITEM";
	case T_FC_STORE_DELETE_USINGITEM:					return "T_FC_STORE_DELETE_USINGITEM";
	case T_FC_STORE_UPDATE_USINGITEM:					return "T_FC_STORE_UPDATE_USINGITEM";
	case T_FC_STORE_EXPIRE_USINGITEM:					return "T_FC_STORE_EXPIRE_USINGITEM";		// 2006-10-11 by cmkwon
	case T_FC_STORE_UPDATE_ITEMSTORAGE:					return "T_FC_STORE_UPDATE_ITEMSTORAGE";		// 2009-03-16 by cmkwon,  ߰
	case T_FC_STORE_UPDATE_ITEMNUM:						return "T_FC_STORE_UPDATE_ITEMNUM";			// 2009-03-16 by cmkwon,  ߰
	case T_FC_STORE_REQUEST_QUICKSLOT:					return "T_FC_STORE_REQUEST_QUICKSLOT";		// 2009-03-16 by cmkwon,  ߰
	case T_FC_STORE_REQUEST_QUICKSLOT_OK:				return "T_FC_STORE_REQUEST_QUICKSLOT_OK";	// 2009-03-16 by cmkwon,  ߰
	case T_FC_STORE_SAVE_QUICKSLOT:						return "T_FC_STORE_SAVE_QUICKSLOT";			// 2009-03-16 by cmkwon,  ߰
		
	case T_FC_STORE_LOG_GUILD_ITEM:						return "T_FC_STORE_LOG_GUILD_ITEM";
	case T_FC_STORE_LOG_GUILD_ITEM_OK:					return "T_FC_STORE_LOG_GUILD_ITEM_OK";
	case T_FC_STORE_LOG_GUILD_ITEM_OK_HEADER:			return "T_FC_STORE_LOG_GUILD_ITEM_OK_HEADER";
	case T_FC_STORE_LOG_GUILD_ITEM_OK_DONE:				return "T_FC_STORE_LOG_GUILD_ITEM_OK_DONE";

	case T_FC_ITEM_SHOW_ITEM:							return "T_FC_ITEM_SHOW_ITEM";
	case T_FC_ITEM_HIDE_ITEM:							return "T_FC_ITEM_HIDE_ITEM";
	case T_FC_ITEM_GET_ITEM:							return "T_FC_ITEM_GET_ITEM";
	case T_FC_ITEM_GET_ITEM_OK:							return "T_FC_ITEM_GET_ITEM_OK";
	case T_FC_ITEM_GET_ITEM_FAIL:						return "T_FC_ITEM_GET_ITEM_FAIL";
	case T_FC_ITEM_PUT_ITEM:							return "T_FC_ITEM_PUT_ITEM";
// 2005-11-15 by cmkwon, 
//	case T_FC_ITEM_BONUSSKILLPOINT:						return "T_FC_ITEM_BONUSSKILLPOINT";
//	case T_FC_ITEM_BONUSSKILLPOINT_OK:					return "T_FC_ITEM_BONUSSKILLPOINT_OK";
	case T_FC_ITEM_CHANGE_WINDOW_POSITION:				return "T_FC_ITEM_CHANGE_WINDOW_POSITION";
	case T_FC_ITEM_CHANGE_WINDOW_POSITION_OK:			return "T_FC_ITEM_CHANGE_WINDOW_POSITION_OK";
	case T_FC_ITEM_UPDATE_WINDOW_ITEM_LIST:				return "T_FC_ITEM_UPDATE_WINDOW_ITEM_LIST";
	case T_FC_ITEM_THROW_AWAY_ITEM:						return "T_FC_ITEM_THROW_AWAY_ITEM";
	case T_FC_ITEM_THROW_AWAY_ITEM_OK:					return "T_FC_ITEM_THROW_AWAY_ITEM_OK";
	case T_FC_ITEM_USE_ENERGY:							return "T_FC_ITEM_USE_ENERGY";
	case T_FC_ITEM_USE_ENERGY_OK:						return "T_FC_ITEM_USE_ENERGY_OK";
	case T_FC_ITEM_USE_ITEM:							return "T_FC_ITEM_USE_ITEM";
	case T_FC_ITEM_USE_ITEM_OK:							return "T_FC_ITEM_USE_ITEM_OK";
	case T_FC_ITEM_DELETE_ITEM_ADMIN:					return "T_FC_ITEM_DELETE_ITEM_ADMIN";
	case T_FC_ITEM_RELOAD_ITEM_INFO:					return "T_FC_ITEM_RELOAD_ITEM_INFO";
	case T_FC_ITEM_USE_ENCHANT:							return "T_FC_ITEM_USE_ENCHANT";
	case T_FC_ITEM_USE_ENCHANT_OK:						return "T_FC_ITEM_USE_ENCHANT_OK";
	case T_FC_ITEM_PUT_ENCHANT_HEADER:					return "T_FC_ITEM_PUT_ENCHANT_HEADER";
	case T_FC_ITEM_PUT_ENCHANT:							return "T_FC_ITEM_PUT_ENCHANT";
	case T_FC_ITEM_PUT_ENCHANT_DONE:					return "T_FC_ITEM_PUT_ENCHANT_DONE";
	case T_FC_ITEM_DELETE_DROP_ITEM:					return "T_FC_ITEM_DELETE_DROP_ITEM";
	case T_FC_ITEM_UPDATE_ITEM_POS:						return "T_FC_ITEM_UPDATE_ITEM_POS";
	case T_FC_ITEM_MIX_ITEMS:							return "T_FC_ITEM_MIX_ITEMS";
	case T_FC_ITEM_MIX_ITEMS_RESULT:					return "T_FC_ITEM_MIX_ITEMS_RESULT";
	case T_FC_ITEM_USE_CARDITEM_GUILDSUMMON:			return "T_FC_ITEM_USE_CARDITEM_GUILDSUMMON";
	case T_FC_ITEM_USE_CARDITEM_GUILDSUMMON_NOTIFY:		return "T_FC_ITEM_USE_CARDITEM_GUILDSUMMON_NOTIFY";
	case T_FC_ITEM_USE_CARDITEM_RESTORE:				return "T_FC_ITEM_USE_CARDITEM_RESTORE";
	case T_FC_ITEM_USE_CARDITEM_RESTORE_NOTIFY:			return "T_FC_ITEM_USE_CARDITEM_RESTORE_NOTIFY";
	case T_FC_ITEM_USE_CARDITEM_GUILD:					return "T_FC_ITEM_USE_CARDITEM_GUILD";
	case T_FC_ITEM_USE_CARDITEM_GUILD_NOTIFY:			return "T_FC_ITEM_USE_CARDITEM_GUILD_NOTIFY";
	case T_FC_ITEM_USE_CARDITEM_MONSTERSUMMON:			return "T_FC_ITEM_USE_CARDITEM_MONSTERSUMMON";
	case T_FC_ITEM_USE_CARDITEM_MONSTERSUMMON_NOTIFY:	return "T_FC_ITEM_USE_CARDITEM_MONSTERSUMMON_NOTIFY";
	case T_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME:	return "T_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME";
	case T_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME_NOTIFY:		return "T_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME_NOTIFY";
	case T_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE:		return "T_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE";
	case T_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE_NOTIFY:		return "T_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE_NOTIFY";
	case T_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE:		return "T_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE";
	case T_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE_NOTIFY:		return "T_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE_NOTIFY";
	case T_FC_ITEM_USE_INFLUENCE_BUFF:					return "T_FC_ITEM_USE_INFLUENCE_BUFF";
	case T_FC_ITEM_USE_INFLUENCE_BUFF_OK:				return "T_FC_ITEM_USE_INFLUENCE_BUFF_OK";
	case T_FC_ITEM_USE_INFLUENCE_GAMEEVENT:				return "T_FC_ITEM_USE_INFLUENCE_GAMEEVENT";
	case T_FC_ITEM_USE_INFLUENCE_GAMEEVENT_OK:			return "T_FC_ITEM_USE_INFLUENCE_GAMEEVENT_OK";
	case T_FC_ITEM_USE_RANDOMBOX:						return "T_FC_ITEM_USE_RANDOMBOX";
	case T_FC_ITEM_USE_RANDOMBOX_OK:					return "T_FC_ITEM_USE_RANDOMBOX_OK";
	case T_FC_ITEM_USE_SKILL_SUPPORT_ITEM:				return "T_FC_ITEM_USE_SKILL_SUPPORT_ITEM";
	case T_FC_ITEM_USE_SKILL_SUPPORT_ITEM_OK:			return "T_FC_ITEM_USE_SKILL_SUPPORT_ITEM_OK";
	case T_FC_ITEM_USE_RANDOMBOX_OK_DONE:				return "T_FC_ITEM_USE_RANDOMBOX_OK_DONE";			// 2008-08-26 by cmkwon, ItemAttribute ߰ - Ű(Package) 
	case T_FC_ITEM_USE_LUCKY_ITEM:						return "T_FC_ITEM_USE_LUCKY_ITEM";					// C->F, 2008-11-04 by dhjin, Űӽ
	case T_FC_ITEM_USE_LUCKY_ITEM_OK:					return "T_FC_ITEM_USE_LUCKY_ITEM_OK";				// F->C, 2008-11-04 by dhjin, Űӽ
	case T_FC_ITEM_CHANGED_SHAPEITEMNUM:				return "T_FC_ITEM_CHANGED_SHAPEITEMNUM";			// 2009-08-26 by cmkwon, ׷ ҽ  ý  - 
	case T_FC_ITEM_CHANGED_EFFECTITEMNUM:				return "T_FC_ITEM_CHANGED_EFFECTITEMNUM";			// 2009-08-26 by cmkwon, ׷ ҽ  ý  - 
	case T_FC_ITEM_USE_PET_SOCKET_ITEM:					return "T_FC_ITEM_USE_PET_SOCKET_ITEM";				// C->F, // 2011-09-20 by hskim, Ʈ ý 2 -    ()

	case T_FC_ITEM_USE_PET_SOCKET_ITEM_OK:				return "T_FC_ITEM_USE_PET_SOCKET_ITEM_OK";			// F->C, // 2011-09-20 by hskim, Ʈ ý 2 -     ()
	case T_FC_ITEM_CANCEL_PET_SOCKET_ITEM:				return "T_FC_ITEM_CANCEL_PET_SOCKET_ITEM";			// C->F, // 2011-09-20 by hskim, Ʈ ý 2 -     ()
	case T_FC_ITEM_CANCEL_PET_SOCKET_ITEM_OK:			return "T_FC_ITEM_CANCEL_PET_SOCKET_ITEM_OK";		// F->C, // 2011-09-20 by hskim, Ʈ ý 2 -      ()
	case T_FC_ITEM_NOTIFY_WINDOW_POSITION:				return "T_FC_ITEM_NOTIFY_WINDOW_POSITION";			// F->C, // 2011-09-20 by hskim, Ʈ ý 2

	case T_FC_SHOP_PUT_ITEM_HEADER:						return "T_FC_SHOP_PUT_ITEM_HEADER";
	case T_FC_SHOP_PUT_ITEM:							return "T_FC_SHOP_PUT_ITEM";
	case T_FC_SHOP_PUT_ITEM_DONE:						return "T_FC_SHOP_PUT_ITEM_DONE";
	case T_FC_SHOP_GET_ITEMINFO:						return "T_FC_SHOP_GET_ITEMINFO";
	case T_FC_SHOP_GET_ITEMINFO_OK:						return "T_FC_SHOP_GET_ITEMINFO_OK";
	case T_FC_SHOP_BUY_ITEM:							return "T_FC_SHOP_BUY_ITEM";
	case T_FC_SHOP_BUY_ITEM_UPDATE:						return "T_FC_SHOP_BUY_ITEM_UPDATE";					// F->C, // 2011-12-26 by hskim, EP4 [Ʈ ý] - ũŻ ý
	case T_FC_SHOP_BUY_ITEM_OK:							return "T_FC_SHOP_BUY_ITEM_OK";
	case T_FC_SHOP_SELL_ITEM:							return "T_FC_SHOP_SELL_ITEM";
	case T_FC_SHOP_SELL_ITEM_OK:						return "T_FC_SHOP_SELL_ITEM_OK";
	case T_FC_SHOP_GET_USED_ITEM_PRICE:					return "T_FC_SHOP_GET_USED_ITEM_PRICE";
	case T_FC_SHOP_GET_USED_ITEM_PRICE_OK:				return "T_FC_SHOP_GET_USED_ITEM_PRICE_OK";
	case T_FC_SHOP_GET_SHOP_ITEM_LIST:					return "T_FC_SHOP_GET_SHOP_ITEM_LIST";
	case T_FC_SHOP_REQUEST_REPAIR:						return "T_FC_SHOP_REQUEST_REPAIR";
	case T_FC_SHOP_REQUEST_REPAIR_OK:					return "T_FC_SHOP_REQUEST_REPAIR_OK";
	case T_FC_SHOP_BUY_CASH_ITEM:						return "T_FC_SHOP_BUY_CASH_ITEM";
	case T_FC_SHOP_BUY_CASH_ITEM_OK:					return "T_FC_SHOP_BUY_CASH_ITEM_OK";			// 2007-11-13 by cmkwon, ϱ  ߰ -
	case T_FC_SHOP_BUY_COLOR_ITEM:						return "T_FC_SHOP_BUY_COLOR_ITEM";
	case T_FC_SHOP_BUY_COLOR_ITEM_OK:					return "T_FC_SHOP_BUY_COLOR_ITEM_OK";
	case T_FC_SHOP_BUY_WARPOINT_ITEM_OK:				return "T_FC_SHOP_BUY_WARPOINT_ITEM_OK";		// 2007-06-13 by dhjin
	case T_FC_SHOP_BUY_WARPOINT_ITEM:					return "T_FC_SHOP_BUY_WARPOINT_ITEM";			// 2007-06-13 by dhjin	

	case T_FC_SHOP_CLOSE:								return "T_FC_SHOP_CLOSE";						// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý

	case T_FC_SHOP_CHECK_GIVE_TARGET:					return "T_FC_SHOP_CHECK_GIVE_TARGET";			// 2007-11-13 by cmkwon, ϱ  ߰ -
	case T_FC_SHOP_CHECK_GIVE_TARGET_OK:				return "T_FC_SHOP_CHECK_GIVE_TARGET_OK";		// 2007-11-13 by cmkwon, ϱ  ߰ -

	case T_FC_TRADE_REQUEST_TRADE:						return "T_FC_TRADE_REQUEST_TRADE";
	case T_FC_TRADE_REQUEST_TRADE_OK:					return "T_FC_TRADE_REQUEST_TRADE_OK";
	case T_FC_TRADE_CANCEL_REQUEST:						return "T_FC_TRADE_CANCEL_REQUEST";
	case T_FC_TRADE_CANCEL_REQUEST_OK:					return "T_FC_TRADE_CANCEL_REQUEST_OK";
	case T_FC_TRADE_ACCEPT_TRADE:						return "T_FC_TRADE_ACCEPT_TRADE";
	case T_FC_TRADE_ACCEPT_TRADE_OK:					return "T_FC_TRADE_ACCEPT_TRADE_OK";
	case T_FC_TRADE_REJECT_TRADE:						return "T_FC_TRADE_REJECT_TRADE";
	case T_FC_TRADE_REJECT_TRADE_OK:					return "T_FC_TRADE_REJECT_TRADE_OK";
	case T_FC_TRADE_REJECT_TRADING:						return "T_FC_TRADE_REJECT_TRADING";
	case T_FC_TRADE_SHOW_TRADE_WINDOW:					return "T_FC_TRADE_SHOW_TRADE_WINDOW";
	case T_FC_TRADE_TRANS_ITEM:							return "T_FC_TRADE_TRANS_ITEM";
	case T_FC_TRADE_TRANS_ITEM_OK:						return "T_FC_TRADE_TRANS_ITEM_OK";
	case T_FC_TRADE_SEE_ITEM:							return "T_FC_TRADE_SEE_ITEM";
	case T_FC_TRADE_SEE_ITEM_OK:						return "T_FC_TRADE_SEE_ITEM_OK";
	case T_FC_TRADE_OK_TRADE:							return "T_FC_TRADE_OK_TRADE";
	case T_FC_TRADE_OK_TRADE_OK:						return "T_FC_TRADE_OK_TRADE_OK";
	case T_FC_TRADE_CANCEL_TRADE:						return "T_FC_TRADE_CANCEL_TRADE";
	case T_FC_TRADE_CANCEL_TRADE_OK:					return "T_FC_TRADE_CANCEL_TRADE_OK";
	case T_FC_TRADE_INSERT_ITEM:						return "T_FC_TRADE_INSERT_ITEM";
	case T_FC_TRADE_DELETE_ITEM:						return "T_FC_TRADE_DELETE_ITEM";
	case T_FC_TRADE_UPDATE_ITEM_COUNT:					return "T_FC_TRADE_UPDATE_ITEM_COUNT";
	case T_FC_TRADE_OK_TRADE_NOTIFY:					return "T_FC_TRADE_OK_TRADE_NOTIFY";		// 2008-11-21 by cmkwon, ŷ  Ȯ ý  - 
	case T_FC_TRADE_SEE_PET_DATA:						return "T_FC_TRADE_SEE_PET_DATA";			// 2010-06-15 by shcho&hslee ý - ŷ    
	case T_FC_TRADE_DELETE_CURRENT_PET_DATA:			return "T_FC_TRADE_DELETE_CURRENT_PET_DATA";
	case T_FC_TRADE_INSERT_CURRENT_PET_DATA:			return "T_FC_TRADE_INSERT_CURRENT_PET_DATA";

	case T_FC_COUNTDOWN_START:							return "T_FC_COUNTDOWN_START";
	case T_FC_COUNTDOWN_DONE:							return "T_FC_COUNTDOWN_DONE";
	case T_FC_OBJECT_CHANGE_BODYCONDITION:				return "T_FC_OBJECT_CHANGE_BODYCONDITION";
	case T_FC_OBJECT_CHANGE_BODYCONDITION_OK:			return "T_FC_OBJECT_CHANGE_BODYCONDITION_OK";
	case T_FC_OBJECT_CHANGE					:			return "T_FC_OBJECT_CHANGE";				// 2011-11-07 by hskim, EP4 [Ʈ ý] - ũŻ ý
	case T_FC_AUCTION_REGISTER_ITEM:					return "T_FC_AUCTION_REGISTER_ITEM";
	case T_FC_AUCTION_REGISTER_ITEM_OK:					return "T_FC_AUCTION_REGISTER_ITEM_OK";
	case T_FC_AUCTION_CANCEL_REGISTER:					return "T_FC_AUCTION_CANCEL_REGISTER";
	case T_FC_AUCTION_CANCEL_REGISTER_OK:				return "T_FC_AUCTION_CANCEL_REGISTER_OK";
	case T_FC_AUCTION_BUY_ITEM:							return "T_FC_AUCTION_BUY_ITEM";
	case T_FC_AUCTION_BUY_ITEM_OK:						return "T_FC_AUCTION_BUY_ITEM_OK";
	case T_FC_AUCTION_GET_ITEM_LIST:					return "T_FC_AUCTION_GET_ITEM_LIST";
	case T_FC_AUCTION_INSERT_ITEM:						return "T_FC_AUCTION_INSERT_ITEM";
	case T_FC_AUCTION_PUT_ENCHANT:						return "T_FC_AUCTION_PUT_ENCHANT";
	case T_FC_GUILD_GET_MAP_OWNER_INFO:					return "T_FC_GUILD_GET_MAP_OWNER_INFO";
	case T_FC_GUILD_GET_MAP_OWNER_INFO_OK:				return "T_FC_GUILD_GET_MAP_OWNER_INFO_OK";
	case T_FC_GUILD_REQUEST_GUILD_WAR:					return "T_FC_GUILD_REQUEST_GUILD_WAR";
	case T_FC_GUILD_REQUEST_GUILD_WAR_RESULT:			return "T_FC_GUILD_REQUEST_GUILD_WAR_RESULT";
	case T_FC_GUILD_GET_CHALLENGER_GUILD:				return "T_FC_GUILD_GET_CHALLENGER_GUILD";
	case T_FC_GUILD_GET_CHALLENGER_GUILD_OK:			return "T_FC_GUILD_GET_CHALLENGER_GUILD_OK";
	case T_FC_GUILD_GET_WAR_INFO:						return "T_FC_GUILD_GET_WAR_INFO";
	case T_FC_GUILD_GET_WAR_INFO_OK:					return "T_FC_GUILD_GET_WAR_INFO_OK";
	case T_FC_GUILD_SUMMON_MEMBER:						return "T_FC_GUILD_SUMMON_MEMBER";
	case T_FC_GUILD_DISMEMBER:							return "T_FC_GUILD_DISMEMBER";

	case T_FI_GUILD_NOTIFY_START_WAR:					return "T_FI_GUILD_NOTIFY_START_WAR";
	case T_FI_GUILD_NOTIFY_END_WAR:						return "T_FI_GUILD_NOTIFY_END_WAR";
	case T_FI_GUILD_DELETE_GUILD:						return "T_FI_GUILD_DELETE_GUILD";
	case T_FI_GUILD_REG_DELETE_GUILD:					return "T_FI_GUILD_REG_DELETE_GUILD";
	case T_FI_GUILD_DISMEMBER:							return "T_FI_GUILD_DISMEMBER";
	case T_FI_GUILD_OUTPOST:							return "T_FI_GUILD_OUTPOST";	// F->I, // 2008-05-20 by dhjin, EP3 -    -  
	// 2012-10-12 by jhjang  ƿ ġ ʽ ý 
	case T_FI_GUILD_BONUS_EXP_RATE:						return "T_FI_GUILD_BOUNUEXP_RATE";	// F->I, // 2012-10-12 by jhjang  ġ  
	// end 2012-10-12 by jhjang  ƿ ġ ʽ ý 

	case T_IC_GUILD_CREATE:								return "T_IC_GUILD_CREATE";
	case T_IC_GUILD_CREATE_OK:							return "T_IC_GUILD_CREATE_OK";
	case T_IC_GUILD_GET_GUILD_INFO:						return "T_IC_GUILD_GET_GUILD_INFO";
	case T_IC_GUILD_GET_GUILD_INFO_OK:					return "T_IC_GUILD_GET_GUILD_INFO_OK";
	case T_IC_GUILD_GET_OTHER_GUILD_INFO:				return "T_IC_GUILD_GET_OTHER_GUILD_INFO";
	case T_IC_GUILD_GET_OTHER_GUILD_INFO_OK:			return "T_IC_GUILD_GET_OTHER_GUILD_INFO_OK";
	case T_IC_GUILD_REQUEST_INVITE:						return "T_IC_GUILD_REQUEST_INVITE";
	case T_IC_GUILD_REQUEST_INVITE_QUESTION:			return "T_IC_GUILD_REQUEST_INVITE_QUESTION";
	case T_IC_GUILD_ACCEPT_INVITE:						return "T_IC_GUILD_ACCEPT_INVITE";
	case T_IC_GUILD_ACCEPT_INVITE_OK:					return "T_IC_GUILD_ACCEPT_INVITE_OK";
	case T_IC_GUILD_REJECT_INVITE:						return "T_IC_GUILD_REJECT_INVITE";
	case T_IC_GUILD_REJECT_INVITE_OK:					return "T_IC_GUILD_REJECT_INVITE_OK";
	case T_IC_GUILD_BAN_MEMBER:							return "T_IC_GUILD_BAN_MEMBER";
	case T_IC_GUILD_BAN_MEMBER_OK:						return "T_IC_GUILD_BAN_MEMBER_OK";
	case T_IC_GUILD_LEAVE:								return "T_IC_GUILD_LEAVE";
	case T_IC_GUILD_LEAVE_OK:							return "T_IC_GUILD_LEAVE_OK";
//	case T_IC_GUILD_DISMEMBER:							return "T_IC_GUILD_DISMEMBER";
	case T_IC_GUILD_DISMEMBER_OK:						return "T_IC_GUILD_DISMEMBER_OK";
	case T_IC_GUILD_SET_MEMBER_STATE:					return "T_IC_GUILD_SET_MEMBER_STATE";
	case T_IC_GUILD_CANCEL_DISMEMBER:					return "T_IC_GUILD_CANCEL_DISMEMBER";
	case T_IC_GUILD_CANCEL_DISMEMBER_OK:				return "T_IC_GUILD_CANCEL_DISMEMBER_OK";
	case T_IC_GUILD_GET_DISMEMBER_DATE:					return "T_IC_GUILD_GET_DISMEMBER_DATE";
	case T_IC_GUILD_GET_DISMEMBER_DATE_OK:				return "T_IC_GUILD_GET_DISMEMBER_DATE_OK";
	case T_IC_GUILD_CHANGE_GUILD_NAME:					return "T_IC_GUILD_CHANGE_GUILD_NAME";
	case T_IC_GUILD_CHANGE_GUILD_NAME_OK:				return "T_IC_GUILD_CHANGE_GUILD_NAME_OK";
	case T_IC_GUILD_GET_GUILD_MARK:						return "T_IC_GUILD_GET_GUILD_MARK";
	case T_IC_GUILD_GET_GUILD_MARK_OK:					return "T_IC_GUILD_GET_GUILD_MARK_OK";
	case T_IC_GUILD_SET_GUILD_MARK:						return "T_IC_GUILD_SET_GUILD_MARK";
	case T_IC_GUILD_SET_GUILD_MARK_OK:					return "T_IC_GUILD_SET_GUILD_MARK_OK";
	case T_IC_GUILD_SET_RANK:							return "T_IC_GUILD_SET_RANK";
	case T_IC_GUILD_SET_RANK_OK:						return "T_IC_GUILD_SET_RANK_OK";
	case T_IC_GUILD_CHANGE_GUILD_STATE:					return "T_IC_GUILD_CHANGE_GUILD_STATE";
	case T_IC_GUILD_LOADING_GUILD_DONE:					return "T_IC_GUILD_LOADING_GUILD_DONE";
	case T_IC_GUILD_WAR_READY:							return "T_IC_GUILD_WAR_READY";
	case T_IC_GUILD_START_WAR:							return "T_IC_GUILD_START_WAR";
	case T_IC_GUILD_END_WAR:							return "T_IC_GUILD_END_WAR";
	case T_IC_GUILD_UPDATE_WAR_POINT:					return "T_IC_GUILD_UPDATE_WAR_POINT";
	case T_IC_GUILD_SURRENDER_GUILD_WAR:				return "T_IC_GUILD_SURRENDER_GUILD_WAR";
	case T_IC_GUILD_CHANGE_MEMBER_CAPACITY:				return "T_IC_GUILD_CHANGE_MEMBER_CAPACITY";
	case T_IC_GUILD_GET_GUILD_MEMBER_LIST_OK:			return "T_IC_GUILD_GET_GUILD_MEMBER_LIST_OK";
	case T_IC_GUILD_END_WAR_ADMIN_NOTIFY:				return "T_IC_GUILD_END_WAR_ADMIN_NOTIFY";
	case T_IC_GUILD_MEMBER_LEVEL_UP:					return "T_IC_GUILD_MEMBER_LEVEL_UP";		// 2008-05-20 by dhjin, EP3 -    - ܿ  
	case T_IC_GUILD_NEW_COMMANDER:						return "T_IC_GUILD_NEW_COMMANDER";		// 2008-05-20 by dhjin, EP3 -    -  
	case T_IC_GUILD_NOTICE_WRITE:						return "T_IC_GUILD_NOTICE_WRITE";		// 2008-05-20 by dhjin, EP3 -    -  
	case T_IC_GUILD_NOTICE_WRITE_OK:					return "T_IC_GUILD_NOTICE_WRITE_OK";		// 2008-05-20 by dhjin, EP3 -    -  
	case T_IC_GUILD_GET_APPLICANT:						return "T_IC_GUILD_GET_APPLICANT";				// C->I, // 2008-05-27 by dhjin, EP3 -    -   
	case T_IC_GUILD_GET_APPLICANT_OK_HEADER:			return "T_IC_GUILD_GET_APPLICANT_OK_HEADER";	// I->C, // 2008-05-27 by dhjin, EP3 -    -    OK
	case T_IC_GUILD_GET_APPLICANT_OK:					return "T_IC_GUILD_GET_APPLICANT_OK";			// I->C, // 2008-05-27 by dhjin, EP3 -    -    OK
	case T_IC_GUILD_GET_APPLICANT_OK_DONE:				return "T_IC_GUILD_GET_APPLICANT_OK_DONE";		// I->C, // 2008-05-27 by dhjin, EP3 -    -    OK
	case T_IC_GUILD_GET_INTRODUCTION:					return "T_IC_GUILD_GET_INTRODUCTION";			// C->I, // 2008-05-27 by dhjin, EP3 -    -  Ұ
	case T_IC_GUILD_GET_INTRODUCTION_OK:				return "T_IC_GUILD_GET_INTRODUCTION_OK";		// I->C, // 2008-05-27 by dhjin, EP3 -    -  Ұ ok
	case T_IC_GUILD_GET_SELF_INTRODUCTION:				return "T_IC_GUILD_GET_SELF_INTRODUCTION";		// C->I, // 2008-05-27 by dhjin, EP3 -    -   Ұ 
	case T_IC_GUILD_GET_SELF_INTRODUCTION_OK:			return "T_IC_GUILD_GET_SELF_INTRODUCTION_OK";	// I->C, // 2008-05-27 by dhjin, EP3 -    -   Ұ OK
	case T_IC_GUILD_SEARCH_INTRODUCTION:				return "T_IC_GUILD_SEARCH_INTRODUCTION";			// C->I, // 2008-05-27 by dhjin, EP3 -    -  Ұ ˻ 
	case T_IC_GUILD_SEARCH_INTRODUCTION_OK_HEADER:		return "T_IC_GUILD_SEARCH_INTRODUCTION_OK_HEADER";	// I->C, // 2008-05-27 by dhjin, EP3 -    -  Ұ ˻ OK
	case T_IC_GUILD_SEARCH_INTRODUCTION_OK:				return "T_IC_GUILD_SEARCH_INTRODUCTION_OK";			// I->C, // 2008-05-27 by dhjin, EP3 -    -  Ұ ˻ OK
	case T_IC_GUILD_SEARCH_INTRODUCTION_OK_DONE:		return "T_IC_GUILD_SEARCH_INTRODUCTION_OK_DONE";		// I->C, // 2008-05-27 by dhjin, EP3 -    -  Ұ ˻ OK
	case T_IC_GUILD_UPDATE_INTRODUCTION:				return "T_IC_GUILD_UPDATE_INTRODUCTION";			// C->I, // 2008-05-27 by dhjin, EP3 -    -  Ұ ۼ 
	case T_IC_GUILD_UPDATE_INTRODUCTION_OK:				return "T_IC_GUILD_UPDATE_INTRODUCTION_OK";			// I->C, // 2008-05-27 by dhjin, EP3 -    -  Ұ ۼ OK
	case T_IC_GUILD_DELETE_INTRODUCTION:				return "T_IC_GUILD_DELETE_INTRODUCTION";			// C->I, // 2008-05-27 by dhjin, EP3 -    -  Ұ   
	case T_IC_GUILD_DELETE_INTRODUCTION_OK:				return "T_IC_GUILD_DELETE_INTRODUCTION_OK";			// I->C, // 2008-05-27 by dhjin, EP3 -    -  Ұ  OK
	case T_IC_GUILD_UPDATE_SELFINTRODUCTION:			return "T_IC_GUILD_UPDATE_SELFINTRODUCTION";		// C->I, // 2008-05-27 by dhjin, EP3 -    - ڱ Ұ ۼ 
	case T_IC_GUILD_UPDATE_SELFINTRODUCTION_OK:			return "T_IC_GUILD_UPDATE_SELFINTRODUCTION_OK";		// I->C, // 2008-05-27 by dhjin, EP3 -    - ڱ Ұ ۼ OK
	case T_IC_GUILD_DELETE_SELFINTRODUCTION:			return "T_IC_GUILD_DELETE_SELFINTRODUCTION";		// C->I, // 2008-05-27 by dhjin, EP3 -    - ڱ Ұ   
	case T_IC_GUILD_DELETE_SELFINTRODUCTION_OK:			return "T_IC_GUILD_DELETE_SELFINTRODUCTION_OK";		// I->C, // 2008-05-27 by dhjin, EP3 -    - ڱ Ұ  OK
	case T_IC_GUILD_CHANGE_FAME_RANK:					return "T_IC_GUILD_CHANGE_FAME_RANK";				// I->C, // 2008-06-10 by dhjin, EP3 -    -   
	case T_IC_GUILD_APPLICANT_INVITE:					return "T_IC_GUILD_APPLICANT_INVITE";				// C->I, // 2008-06-12 by dhjin, EP3 -    -   ܿ ʴ
	case T_IC_GUILD_APPLICANT_INVITE_OK:				return "T_IC_GUILD_APPLICANT_INVITE_OK";			// I->C, // 2008-06-12 by dhjin, EP3 -    -   ܿ ʴ OK
	case T_IC_GUILD_APPLICANT_REJECT_INVITE:			return "T_IC_GUILD_APPLICANT_REJECT_INVITE";		// C->I, // 2008-06-12 by dhjin, EP3 -    -   ܿ ʴ ź 
	case T_IC_GUILD_APPLICANT_REJECT_INVITE_OK:			return "T_IC_GUILD_APPLICANT_REJECT_INVITE_OK";		// I->C, // 2008-06-12 by dhjin, EP3 -    -   ܿ ʴ ź OK
	case T_IC_GUILD_CHANGE_MEMBERSHIP:					return "T_IC_GUILD_CHANGE_MEMBERSHIP";				// I->C, // 2008-06-20 by dhjin, EP3 -    -  ɹ  

	case T_FC_SKILL_USE_SKILLPOINT:						return "T_FC_SKILL_USE_SKILLPOINT";
	case T_FC_SKILL_USE_SKILLPOINT_OK:					return "T_FC_SKILL_USE_SKILLPOINT_OK";
	case T_FC_SKILL_SETUP_SKILL:						return "T_FC_SKILL_SETUP_SKILL";
	case T_FC_SKILL_SETUP_SKILL_OK_HEADER:				return "T_FC_SKILL_SETUP_SKILL_OK_HEADER";
	case T_FC_SKILL_SETUP_SKILL_OK:						return "T_FC_SKILL_SETUP_SKILL_OK";
	case T_FC_SKILL_SETUP_SKILL_OK_DONE:				return "T_FC_SKILL_SETUP_SKILL_OK_DONE";
	case T_FC_SKILL_USE_SKILL:							return "T_FC_SKILL_USE_SKILL";
	case T_FC_SKILL_USE_SKILL_OK:						return "T_FC_SKILL_USE_SKILL_OK";
	case T_FC_SKILL_CANCEL_SKILL:						return "T_FC_SKILL_CANCEL_SKILL";
	case T_FC_SKILL_CANCEL_SKILL_OK:					return "T_FC_SKILL_CANCEL_SKILL_OK";
	case T_FC_SKILL_INVALIDATE_SKILL:					return "T_FC_SKILL_INVALIDATE_SKILL";
	case T_FC_SKILL_PREPARE_USE:						return "T_FC_SKILL_PREPARE_USE";
	case T_FC_SKILL_PREPARE_USE_OK:						return "T_FC_SKILL_PREPARE_USE_OK";
	case T_FC_SKILL_CANCEL_PREPARE:						return "T_FC_SKILL_CANCEL_PREPARE";
	case T_FC_SKILL_CANCEL_PREPARE_OK:					return "T_FC_SKILL_CANCEL_PREPARE_OK";
	case T_FC_SKILL_CONFIRM_USE:						return "T_FC_SKILL_CONFIRM_USE";
	case T_FC_SKILL_CONFIRM_USE_ACK:					return "T_FC_SKILL_CONFIRM_USE_ACK";

	case T_FN_SKILL_USE_SKILL:							return "T_FN_SKILL_USE_SKILL";
	case T_FN_SKILL_USE_SKILL_OK:						return "T_FN_SKILL_USE_SKILL_OK";
	case T_FC_QUEST_REQUEST_START:						return "T_FC_QUEST_REQUEST_START";
	case T_FC_QUEST_REQUEST_START_RESULT:				return "T_FC_QUEST_REQUEST_START_RESULT";
	case T_FC_QUEST_ACCEPT_QUEST:						return "T_FC_QUEST_ACCEPT_QUEST";
	case T_FC_QUEST_CANCEL_QUEST:						return "T_FC_QUEST_CANCEL_QUEST";
	case T_FC_QUEST_REQUEST_SUCCESS:					return "T_FC_QUEST_REQUEST_SUCCESS";
	case T_FC_QUEST_REQUEST_SUCCESS_RESULT:				return "T_FC_QUEST_REQUEST_SUCCESS_RESULT";
	case T_FC_QUEST_PUT_ALL_QUEST_HEADER:				return "T_FC_QUEST_PUT_ALL_QUEST_HEADER";
	case T_FC_QUEST_PUT_ALL_QUEST:						return "T_FC_QUEST_PUT_ALL_QUEST";
	case T_FC_QUEST_PUT_ALL_QUEST_DONE:					return "T_FC_QUEST_PUT_ALL_QUEST_DONE";
	case T_FC_QUEST_DISCARD_QUEST:						return "T_FC_QUEST_DISCARD_QUEST";
	case T_FC_QUEST_DISCARD_QUEST_OK:					return "T_FC_QUEST_DISCARD_QUEST_OK";
	case T_FC_QUEST_MOVE_QUEST_MAP:						return "T_FC_QUEST_MOVE_QUEST_MAP";
	case T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT_HEADER:	return "T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT_HEADER";
	case T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT:		return "T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT";
	case T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT_DONE:	return "T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT_DONE";
	case T_FC_QUEST_UPDATE_MONSTER_COUNT:				return "T_FC_QUEST_UPDATE_MONSTER_COUNT";
	case T_FC_QUEST_REQUEST_SUCCESS_CHECK:				return "T_FC_QUEST_REQUEST_SUCCESS_CHECK";
	case T_FC_QUEST_REQUEST_SUCCESS_CHECK_RESULT:		return "T_FC_QUEST_REQUEST_SUCCESS_CHECK_RESULT";
	case T_FC_QUEST_REQUEST_PARTY_WARP:					return "T_FC_QUEST_REQUEST_PARTY_WARP";				// 2006-10-16 by cmkwon
	case T_FC_QUEST_REQUEST_PARTY_WARP_ACK:				return "T_FC_QUEST_REQUEST_PARTY_WARP_ACK";			// 2006-10-16 by cmkwon

	case T_FC_INFO_GET_MONSTER_INFO:					return "T_FC_INFO_GET_MONSTER_INFO";
	case T_FC_INFO_GET_MONSTER_INFO_OK:					return "T_FC_INFO_GET_MONSTER_INFO_OK";
	case T_FC_INFO_GET_MAPOBJECT_INFO:					return "T_FC_INFO_GET_MAPOBJECT_INFO";
	case T_FC_INFO_GET_MAPOBJECT_INFO_OK:				return "T_FC_INFO_GET_MAPOBJECT_INFO_OK";
	case T_FC_INFO_GET_ITEM_INFO:						return "T_FC_INFO_GET_ITEM_INFO";
	case T_FC_INFO_GET_ITEM_INFO_OK:					return "T_FC_INFO_GET_ITEM_INFO_OK";
	case T_FC_INFO_GET_RARE_ITEM_INFO:					return "T_FC_INFO_GET_RARE_ITEM_INFO";
	case T_FC_INFO_GET_RARE_ITEM_INFO_OK:				return "T_FC_INFO_GET_RARE_ITEM_INFO_OK";
	case T_FC_INFO_GET_BUILDINGNPC_INFO:				return "T_FC_INFO_GET_BUILDINGNPC_INFO";
	case T_FC_INFO_GET_BUILDINGNPC_INFO_OK:				return "T_FC_INFO_GET_BUILDINGNPC_INFO_OK";
	case T_FC_INFO_GET_SIMPLE_ITEM_INFO:				return "T_FC_INFO_GET_SIMPLE_ITEM_INFO";
	case T_FC_INFO_GET_SIMPLE_ITEM_INFO_OK:				return "T_FC_INFO_GET_SIMPLE_ITEM_INFO_OK";
	case T_FC_INFO_GET_ENCHANT_COST:					return "T_FC_INFO_GET_ENCHANT_COST";
	case T_FC_INFO_GET_ENCHANT_COST_OK:					return "T_FC_INFO_GET_ENCHANT_COST_OK";
	case T_FC_INFO_GET_CURRENT_MAP_INFO:				return "T_FC_INFO_GET_CURRENT_MAP_INFO";
	case T_FC_INFO_GET_CURRENT_MAP_INFO_OK:				return "T_FC_INFO_GET_CURRENT_MAP_INFO_OK";
	case T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_OK:		return "T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_OK";
	case T_FC_INFO_GET_GAME_EVENT_INFO_OK:				return "T_FC_INFO_GET_GAME_EVENT_INFO_OK";
	case T_FC_INFO_GET_SERVER_DATE_TIME:				return "T_FC_INFO_GET_SERVER_DATE_TIME";
	case T_FC_INFO_GET_SERVER_DATE_TIME_OK:				return "T_FC_INFO_GET_SERVER_DATE_TIME_OK";
	case T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO:			return "T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO";	// 2007-10-30 by cmkwon, º Ǿƿ ̺Ʈ  - C->F
	case T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_BY_LEVEL:	return "T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_BY_LEVEL";	// 2008-03-14 by dhjin, Level Ǿƿ ̺Ʈ  -
	case T_FC_INFO_CHECK_RESOBJ_CHECKSUM:				return "T_FC_INFO_CHECK_RESOBJ_CHECKSUM";		// 2007-05-28 by cmkwon

	case T_FC_REQUEST_REQUEST:							return "T_FC_REQUEST_REQUEST";
	case T_FC_REQUEST_REQUEST_OK:						return "T_FC_REQUEST_REQUEST_OK";
	case T_FC_REQUEST_ACCEPT_REQUEST:					return "T_FC_REQUEST_ACCEPT_REQUEST";
	case T_FC_REQUEST_ACCEPT_REQUEST_OK:				return "T_FC_REQUEST_ACCEPT_REQUEST_OK";
	case T_FC_REQUEST_REJECT_REQUEST:					return "T_FC_REQUEST_REJECT_REQUEST";
	case T_FC_REQUEST_REJECT_REQUEST_OK:				return "T_FC_REQUEST_REJECT_REQUEST_OK";
	case T_FC_REQUEST_CANCEL_REQUEST:					return "T_FC_REQUEST_CANCEL_REQUEST";
	
	case T_FC_CITY_GET_BUILDING_LIST:								return "T_FC_CITY_GET_BUILDING_LIST";
	case T_FC_CITY_GET_BUILDING_LIST_OK:							return "T_FC_CITY_GET_BUILDING_LIST_OK";
	case T_FC_CITY_REQUEST_ENTER_BUILDING:							return "T_FC_CITY_REQUEST_ENTER_BUILDING";
	case T_FC_CITY_REQUEST_ENTER_BUILDING_OK:						return "T_FC_CITY_REQUEST_ENTER_BUILDING_OK";
	case T_FC_CITY_CHECK_WARP_STATE:								return "T_FC_CITY_CHECK_WARP_STATE";
	case T_FC_CITY_CHECK_WARP_STATE_OK:								return "T_FC_CITY_CHECK_WARP_STATE_OK";
	case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST:				return "T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST";
	case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK_HEADER:	return "T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK_HEADER";
	case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK:			return "T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK";
	case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK_DONE:		return "T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK_DONE";
	case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO:				return "T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO";
	case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO_OK:			return "T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO_OK";
	case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO_OK_GUILDMARK:	return "T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO_OK_GUILDMARK";
	case T_FC_CITY_POLL_REG_LEADER_CANDIDATE:						return "T_FC_CITY_POLL_REG_LEADER_CANDIDATE";
	case T_FC_CITY_POLL_REG_LEADER_CANDIDATE_OK:					return "T_FC_CITY_POLL_REG_LEADER_CANDIDATE_OK";
	case T_FC_CITY_POLL_DELETE_LEADER_CANDIDATE:					return "T_FC_CITY_POLL_DELETE_LEADER_CANDIDATE";
	case T_FC_CITY_POLL_DELETE_LEADER_CANDIDATE_OK:					return "T_FC_CITY_POLL_DELETE_LEADER_CANDIDATE_OK";
	case T_FC_CITY_POLL_VOTE:										return "T_FC_CITY_POLL_VOTE";
	case T_FC_CITY_POLL_VOTE_OK:									return "T_FC_CITY_POLL_VOTE_OK";
	case T_FC_CITY_POLL_REQUEST_POLL_DATE:							return "T_FC_CITY_POLL_REQUEST_POLL_DATE";
	case T_FC_CITY_POLL_REQUEST_POLL_DATE_OK:						return "T_FC_CITY_POLL_REQUEST_POLL_DATE_OK";
	case T_FC_CITY_POLL_LEADER_ELECTION_INFO:						return "T_FC_CITY_POLL_LEADER_ELECTION_INFO";
	case T_FC_CITY_WARINFO_INFLUENCE:								return "T_FC_CITY_WARINFO_INFLUENCE";
	case T_FC_CITY_WARINFO_INFLUENCE_OK:							return "T_FC_CITY_WARINFO_INFLUENCE_OK";
	case T_FC_CITY_WARINFO_OUTPOST:									return "T_FC_CITY_WARINFO_OUTPOST";
	case T_FC_CITY_WARINFO_OUTPOST_OK:								return "T_FC_CITY_WARINFO_OUTPOST_OK";


	case T_FC_TIMER_START_TIMER:						return "T_FC_TIMER_START_TIMER";
	case T_FC_TIMER_STOP_TIMER:							return "T_FC_TIMER_STOP_TIMER";
	case T_FC_TIMER_UPDATE_TIMER:						return "T_FC_TIMER_UPDATE_TIMER";
	case T_FC_TIMER_PAUSE_TIMER:						return "T_FC_TIMER_PAUSE_TIMER";
	case T_FC_TIMER_CONTINUE_TIMER:						return "T_FC_TIMER_CONTINUE_TIMER";
	case T_FC_TIMER_TIMEOUT:							return "T_FC_TIMER_TIMEOUT";
	case T_FC_CLIENT_REPORT:							return "T_FC_CLIENT_REPORT";
	case T_FC_STRING_128:								return "T_FC_STRING_128";
	case T_IC_STRING_128:								return "T_IC_STRING_128";
	case T_FI_ADMIN_GET_CHARACTER_INFO:					return "T_FI_ADMIN_GET_CHARACTER_INFO";
	case T_FI_ADMIN_GET_CHARACTER_INFO_OK:				return "T_FI_ADMIN_GET_CHARACTER_INFO_OK";
	case T_FI_ADMIN_CALL_CHARACTER:						return "T_FI_ADMIN_CALL_CHARACTER";
	case T_FI_ADMIN_MOVETO_CHARACTER:					return "T_FI_ADMIN_MOVETO_CHARACTER";
	case T_FI_ADMIN_PRINT_DEBUG_MSG:					return "T_FI_ADMIN_PRINT_DEBUG_MSG";
	case T_FI_ADMIN_CHANGE_WEATHER:						return "T_FI_ADMIN_CHANGE_WEATHER";
	case T_IC_ADMIN_CALL_CHARACTER:						return "T_IC_ADMIN_CALL_CHARACTER";
	case T_IC_ADMIN_GET_SERVER_STAT:					return "T_IC_ADMIN_GET_SERVER_STAT";
	case T_IC_ADMIN_GET_SERVER_STAT_OK:					return "T_IC_ADMIN_GET_SERVER_STAT_OK";
	case T_IC_ADMIN_CALL_GUILD:							return "T_IC_ADMIN_CALL_GUILD";
	case T_IC_ADMIN_CALLGM_INFO_OK:						return "T_IC_ADMIN_CALLGM_INFO_OK";
	case T_IC_ADMIN_CALLGM_VIEW_OK:						return "T_IC_ADMIN_CALLGM_VIEW_OK";
	case T_IC_ADMIN_CALLGM_BRING_OK:					return "T_IC_ADMIN_CALLGM_BRING_OK";

	case T_FC_ADMIN_GET_SERVER_STAT:					return "T_FC_ADMIN_GET_SERVER_STAT";
	case T_FC_ADMIN_GET_SERVER_STAT_OK:					return "T_FC_ADMIN_GET_SERVER_STAT_OK";
		
	case T_IC_COUNTDOWN_START:							return "T_IC_COUNTDOWN_START";
	case T_IC_COUNTDOWN_DONE:							return "T_IC_COUNTDOWN_DONE";

	case T_IC_VOIP_SET:									return "T_IC_VOIP_SET";					// C -> I, 2008-06-17 by dhjin, EP3 VOIP -  
	case T_IC_VOIP_SET_OK:								return "T_IC_VOIP_SET_OK";				// I -> C, 2008-06-17 by dhjin, EP3 VOIP -   

	// T0_IC_CHATROOM
	case T_IC_CHATROOM_CREATE:							return "T_IC_CHATROOM_CREATE";					// C -> I, 2008-06-16 by dhjin, EP3 äù - äù 
	case T_IC_CHATROOM_CREATE_OK:						return "T_IC_CHATROOM_CREATE_OK";				// I -> C, 2008-06-16 by dhjin, EP3 äù - äù  OK
	case T_IC_CHATROOM_LIST_INFO:						return "T_IC_CHATROOM_LIST_INFO";				// C -> I, 2008-06-16 by dhjin, EP3 äù - äù  
	case T_IC_CHATROOM_LIST_INFO_OK:					return "T_IC_CHATROOM_LIST_INFO_OK";			// I -> C, 2008-06-16 by dhjin, EP3 äù - äù   OK
	case T_IC_CHATROOM_REQUEST_INVITE:					return "T_IC_CHATROOM_REQUEST_INVITE";			// C -> I, 2008-06-16 by dhjin, EP3 äù - äù ʴ û 
	case T_IC_CHATROOM_REQUEST_INVITE_QUESTION:			return "T_IC_CHATROOM_REQUEST_INVITE_QUESTION";	// I -> C, 2008-06-16 by dhjin, EP3 äù - äù ʴ 󿡰 
	case T_IC_CHATROOM_JOIN:							return "T_IC_CHATROOM_JOIN";					// C -> I, 2008-06-16 by dhjin, EP3 äù - äù 
	case T_IC_CHATROOM_JOIN_OK:							return "T_IC_CHATROOM_JOIN_OK";					// I -> C, 2008-06-16 by dhjin, EP3 äù - äù  OK
	case T_IC_CHATROOM_ACCEPT_INVITE:					return "T_IC_CHATROOM_ACCEPT_INVITE";			// C -> I, 2008-06-16 by dhjin, EP3 äù - äù ʴ 
	case T_IC_CHATROOM_ACCEPT_INVITE_OK:				return "T_IC_CHATROOM_ACCEPT_INVITE_OK";		// I -> C, 2008-06-16 by dhjin, EP3 äù - äù ʴ  OK
	case T_IC_CHATROOM_REJECT_INVITE:					return "T_IC_CHATROOM_REJECT_INVITE";			// C -> I, 2008-06-16 by dhjin, EP3 äù - äù ʴ 
	case T_IC_CHATROOM_REJECT_INVITE_OK:				return "T_IC_CHATROOM_REJECT_INVITE_OK";		// I -> C, 2008-06-16 by dhjin, EP3 äù - äù ʴ  OK
	case T_IC_CHATROOM_LEAVE:							return "T_IC_CHATROOM_LEAVE";					// C -> I, 2008-06-16 by dhjin, EP3 äù - äù 
	case T_IC_CHATROOM_LEAVE_OK:						return "T_IC_CHATROOM_LEAVE_OK";				// I -> C, 2008-06-16 by dhjin, EP3 äù - äù  OK
	case T_IC_CHATROOM_BAN:								return "T_IC_CHATROOM_BAN";						// C -> I, 2008-06-16 by dhjin, EP3 äù - äù ߹
	case T_IC_CHATROOM_BAN_OK:							return "T_IC_CHATROOM_BAN_OK";					// I -> C, 2008-06-16 by dhjin, EP3 äù - äù ߹ OK
	case T_IC_CHATROOM_CHANGE_NAME:						return "T_IC_CHATROOM_CHANGE_NAME";				// C -> I, 2008-06-16 by dhjin, EP3 äù - äù ̸ 
	case T_IC_CHATROOM_CHANGE_NAME_OK:					return "T_IC_CHATROOM_CHANGE_NAME_OK";			// I -> C, 2008-06-16 by dhjin, EP3 äù - äù ̸  OK
	case T_IC_CHATROOM_CHANGE_MASTER:					return "T_IC_CHATROOM_CHANGE_MASTER";			// C -> I, 2008-06-16 by dhjin, EP3 äù - äù  
	case T_IC_CHATROOM_CHANGE_MASTER_OK:				return "T_IC_CHATROOM_CHANGE_MASTER_OK";		// I -> C, 2008-06-16 by dhjin, EP3 äù - äù   OK
	case T_IC_CHATROOM_CHANGE_LOCK_PW:					return "T_IC_CHATROOM_CHANGE_LOCK_PW";			// C -> I, 2008-06-16 by dhjin, EP3 äù - äù йȣ 
	case T_IC_CHATROOM_CHANGE_LOCK_PW_OK:				return "T_IC_CHATROOM_CHANGE_LOCK_PW_OK";		// I -> C, 2008-06-16 by dhjin, EP3 äù - äù йȣ  OK
	case T_IC_CHATROOM_CHANGE_MAX_MEMBER:				return "T_IC_CHATROOM_CHANGE_MAX_MEMBER";		// C -> I, 2008-06-16 by dhjin, EP3 äù - äù ο 
	case T_IC_CHATROOM_CHANGE_MAX_MEMBER_OK:			return "T_IC_CHATROOM_CHANGE_MAX_MEMBER_OK";	// I -> C, 2008-06-16 by dhjin, EP3 äù - äù ο  OK
	case T_IC_CHATROOM_MEMBER_INFO:						return "T_IC_CHATROOM_MEMBER_INFO";				// I -> C, 2008-06-25 by dhjin, EP3 äù - äù ɹ  
	case T_IC_CHATROOM_MEMBER_INFO_OK:					return "T_IC_CHATROOM_MEMBER_INFO_OK";			// I -> C, 2008-06-25 by dhjin, EP3 äù - äù ɹ   OK
	case T_IC_CHATROOM_OTHER_MEMBER_INFO:				return "T_IC_CHATROOM_OTHER_MEMBER_INFO";		// I -> C, 2008-06-25 by dhjin, EP3 äù - äù ٸ ɹ  
	case T_IC_CHATROOM_OTHER_MEMBER_INFO_OK:			return "T_IC_CHATROOM_OTHER_MEMBER_INFO_OK";	// I -> C, 2008-06-25 by dhjin, EP3 äù - äù ٸ ɹ   OK
		
	case T_FC_CITYWAR_START_WAR:						return "T_FC_CITYWAR_START_WAR";
	case T_FC_CITYWAR_MONSTER_CREATED:					return "T_FC_CITYWAR_MONSTER_CREATED";
	case T_FC_CITYWAR_MONSTER_DEAD:						return "T_FC_CITYWAR_MONSTER_DEAD";
	case T_FC_CITYWAR_END_WAR:							return "T_FC_CITYWAR_END_WAR";
	case T_FC_CITYWAR_GET_OCCUPYINFO:					return "T_FC_CITYWAR_GET_OCCUPYINFO";
	case T_FC_CITYWAR_GET_OCCUPYINFO_OK:				return "T_FC_CITYWAR_GET_OCCUPYINFO_OK";
	case T_FC_CITYWAR_SET_SETTINGTIME:					return "T_FC_CITYWAR_SET_SETTINGTIME";
	case T_FC_CITYWAR_SET_TEX:							return "T_FC_CITYWAR_SET_TEX";
	case T_FC_CITYWAR_SET_BRIEFING:						return "T_FC_CITYWAR_SET_BRIEFING";
	case T_FC_CITYWAR_BRING_SUMOFTEX:					return "T_FC_CITYWAR_BRING_SUMOFTEX";
	case T_FC_CITYWAR_BRING_SUMOFTEX_OK:				return "T_FC_CITYWAR_BRING_SUMOFTEX_OK";

	case T_FC_WAR_NOTIFY_INVASION:						return "T_FC_WAR_NOTIFY_INVASION";
	case T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD:		return "T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD";
	case T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_INVASION:	return "T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_INVASION";
	case T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_AUTO_DESTROYED:	return "T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_AUTO_DESTROYED";
	case T_FC_WAR_BOSS_MONSTER_SUMMON_DATA:				return "T_FC_WAR_BOSS_MONSTER_SUMMON_DATA";
	case T_FC_WAR_JACO_MONSTER_SUMMON:					return "T_FC_WAR_JACO_MONSTER_SUMMON";
	case T_FC_WAR_STRATEGYPOINT_MONSTER_SUMMON:			return "T_FC_WAR_STRATEGYPOINT_MONSTER_SUMMON";

	case T_FC_WAR_SIGN_BOARD_INSERT_STRING:				return "T_FC_WAR_SIGN_BOARD_INSERT_STRING";
	case T_FC_WAR_SIGN_BOARD_DELETE_STRING:				return "T_FC_WAR_SIGN_BOARD_DELETE_STRING";
	case T_FC_WAR_REQ_SIGN_BOARD_STRING_LIST:			return "T_FC_WAR_REQ_SIGN_BOARD_STRING_LIST";
	case T_FC_WAR_REQ_SIGN_BOARD_STRING_LIST_OK:		return "T_FC_WAR_REQ_SIGN_BOARD_STRING_LIST_OK";
	case T_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK:			return "T_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK";
	case T_FC_WAR_INFLUENCE_DATA:						return "T_FC_WAR_INFLUENCE_DATA";
	case T_FC_WAR_MONSTER_CREATED:						return "T_FC_WAR_MONSTER_CREATED";
	case T_FC_WAR_MONSTER_AUTO_DESTROYED:				return "T_FC_WAR_MONSTER_AUTO_DESTROYED";
	case T_FC_WAR_MONSTER_DEAD:							return "T_FC_WAR_MONSTER_DEAD";
	case T_FC_WAR_BOSS_CONTRIBUTION_GUILD:				return "T_FC_WAR_BOSS_CONTRIBUTION_GUILD";	// 2008-12-29 by dhjin,   ߰, F->C(n)

	case T_FC_BAZAAR_CUSTOMER_INFO_OK:					return "T_FC_BAZAAR_CUSTOMER_INFO_OK";
	case T_FC_BAZAAR_INFO_OK				:			return "T_FC_BAZAAR_INFO_OK";
	case T_FC_BAZAAR_SELL_PUT_ITEM			:			return "T_FC_BAZAAR_SELL_PUT_ITEM";
	case T_FC_BAZAAR_SELL_PUT_ITEM_OK		:			return "T_FC_BAZAAR_SELL_PUT_ITEM_OK";
	case T_FC_BAZAAR_SELL_CANCEL_ITEM		:			return "T_FC_BAZAAR_SELL_CANCEL_ITEM";
	case T_FC_BAZAAR_SELL_CANCEL_ITEM_OK	:			return "T_FC_BAZAAR_SELL_CANCEL_ITEM_OK";
	case T_FC_BAZAAR_SELL_START				:			return "T_FC_BAZAAR_SELL_START";
	case T_FC_BAZAAR_SELL_START_OK			:			return "T_FC_BAZAAR_SELL_START_OK";
	case T_FC_BAZAAR_SELL_REQUEST_ITEMLIST	:			return "T_FC_BAZAAR_SELL_REQUEST_ITEMLIST";
	case T_FC_BAZAAR_SELL_REQUEST_ITEMLIST_OK:			return "T_FC_BAZAAR_SELL_REQUEST_ITEMLIST_OK";
	case T_FC_BAZAAR_SELL_ITEM_ENCHANTLIST_OK:			return "T_FC_BAZAAR_SELL_ITEM_ENCHANTLIST_OK";
	case T_FC_BAZAAR_SELL_BUY_ITEM			:			return "T_FC_BAZAAR_SELL_BUY_ITEM";
	case T_FC_BAZAAR_SELL_BUY_ITEM_OK		:			return "T_FC_BAZAAR_SELL_BUY_ITEM_OK";

	case T_FC_BAZAAR_BUY_PUT_ITEM			:			return "T_FC_BAZAAR_BUY_PUT_ITEM";
	case T_FC_BAZAAR_BUY_PUT_ITEM_OK			:		return "T_FC_BAZAAR_BUY_PUT_ITEM_OK";
	case T_FC_BAZAAR_BUY_CANCEL_ITEM			:		return "T_FC_BAZAAR_BUY_CANCEL_ITEM";
	case T_FC_BAZAAR_BUY_CANCEL_ITEM_OK		:			return "T_FC_BAZAAR_BUY_CANCEL_ITEM_OK";
	case T_FC_BAZAAR_BUY_START				:			return "T_FC_BAZAAR_BUY_START";
	case T_FC_BAZAAR_BUY_START_OK			:			return "T_FC_BAZAAR_BUY_START_OK";
	case T_FC_BAZAAR_BUY_REQUEST_ITEMLIST	:			return "T_FC_BAZAAR_BUY_REQUEST_ITEMLIST";
	case T_FC_BAZAAR_BUY_REQUEST_ITEMLIST_OK	:		return "T_FC_BAZAAR_BUY_REQUEST_ITEMLIST_OK";
	case T_FC_BAZAAR_BUY_SELL_ITEM			:			return "T_FC_BAZAAR_BUY_SELL_ITEM";
	case T_FC_BAZAAR_BUY_SELL_ITEM_OK		:			return "T_FC_BAZAAR_BUY_SELL_ITEM_OK";
	case T_FI_GUILD_RANK_OK		:						return "T_FI_GUILD_RANK_OK";
	case T_FI_GUILD_DELETE_INFO_OK		:				return "T_FI_GUILD_DELETE_INFO_OK";


	case T_PRE_IOCP:									return "T_PRE_IOCP";
	case T_PRE_DB:										return "T_PRE_DB";
	case T_IM_IOCP:										return "T_IM_IOCP";
	case T_IM_DB:										return "T_IM_DB";
	case T_FIELD_IOCP:									return "T_FIELD_IOCP";
	case T_FIELD_DB:									return "T_FIELD_DB";
	case T_NPC_IOCP:									return "T_NPC_IOCP";
	case T_NPC_DB:										return "T_NPC_DB";
	case T_TIMER:										return "T_TIMER";
	case T_DB:											return "T_DB";
	case T_NA:											return "T_NA";
	case T_ERROR:										return "T_ERROR";
	case T_FC_RACING_RACINGLIST_REQUEST:				return "T_FC_RACING_RACINGLIST_REQUEST";
	case T_FC_RACING_RACINGLIST_REQUEST_ACK:			return "T_FC_RACING_RACINGLIST_REQUEST_ACK";
	case T_FC_RACING_RACINGINFO_REQUEST:				return "T_FC_RACING_RACINGINFO_REQUEST";
	case T_FC_RACING_RACINGINFO_REQUEST_ACK:			return "T_FC_RACING_RACINGINFO_REQUEST_ACK";
	case T_FC_RACING_RACINGNOTIFY:						return "T_FC_RACING_RACINGNOTIFY";
	case T_FC_RACING_JOIN_ENABLE:						return "T_FC_RACING_JOIN_ENABLE";
	case T_FC_RACING_JOIN_REQUEST:						return "T_FC_RACING_JOIN_REQUEST";
	case T_FC_RACING_JOIN_REQUEST_ACK:					return "T_FC_RACING_JOIN_REQUEST_ACK";
	case T_FC_RACING_COUNTDOWN:							return "T_FC_RACING_COUNTDOWN";
	case T_FC_RACING_CHECKPOINT_CHECK:					return "T_FC_RACING_CHECKPOINT_CHECK";
	case T_FC_RACING_CHECKPOINT_CHECK_ACK:				return "T_FC_RACING_CHECKPOINT_CHECK_ACK";
	case T_FC_RACING_FINISHED:							return "T_FC_RACING_FINISHED";
	case T_FC_RACING_OTHER_FINISHED:					return "T_FC_RACING_OTHER_FINISHED";
	case T_FC_RACING_FINALRANKING:						return "T_FC_RACING_FINALRANKING";
	case T_FL_LOG_LOGIN:								return "T_FL_LOG_LOGIN";
	case T_FL_LOG_LOGOUT:								return "T_FL_LOG_LOGOUT";
	case T_FL_LOG_LEVEL:								return "T_FL_LOG_LEVEL";
	case T_FL_LOG_EXP:									return "T_FL_LOG_EXP";
	case T_FL_LOG_STAT:									return "T_FL_LOG_STAT";
	case T_FL_LOG_GAME_START:							return "T_FL_LOG_GAME_START";
	case T_FL_LOG_GAME_END:								return "T_FL_LOG_GAME_END";
	case T_FL_LOG_QUEST_COMPLETION:						return "T_FL_LOG_QUEST_COMPLETION";
	case T_FL_LOG_QUEST_COMPENSATION:					return "T_FL_LOG_QUEST_COMPENSATION";
	case T_FL_LOG_PKWIN:								return "T_FL_LOG_PKWIN";
	case T_FL_LOG_PKLOSS:								return "T_FL_LOG_PKLOSS";
	case T_FL_LOG_DEAD:									return "T_FL_LOG_DEAD";
	case T_FL_LOG_WARP:									return "T_FL_LOG_WARP";
	case T_FL_LOG_SPEED_HACK:							return "T_FL_LOG_SPEED_HACK";
	case T_FL_LOG_CREATE_CHARACTER:						return "T_FL_LOG_CREATE_CHARACTER";
	case T_FL_LOG_DELETE_CHARACTER:						return "T_FL_LOG_DELETE_CHARACTER";
	case T_FL_LOG_MEMORY_HACK:							return "T_FL_LOG_MEMORY_HACK";
	case T_FL_LOG_PvEWIN:								return "T_FL_LOG_PvEWIN";
	case T_FL_LOG_PvELOSS:								return "T_FL_LOG_PvELOSS";

	// 2012-12-17 by bckim, â  ̵  ߰α 
	case T_FL_LOG_ITEM_CHARACTER_ITEM_GUILDSTORE_RESULT:					return "T_FL_LOG_ITEM_CHARACTER_ITEM_GUILDSTORE_RESULT";
	// 2012-12-17 by bckim, â  ̵  ߰α.End 
	case T_FL_LOG_ITEM_CHARACTER_ITEM:					return "T_FL_LOG_ITEM_CHARACTER_ITEM";
	case T_FL_LOG_ITEM_GET_ITEM:						return "T_FL_LOG_ITEM_GET_ITEM";
	case T_FL_LOG_ITEM_TRADE_SEND:						return "T_FL_LOG_ITEM_TRADE_SEND";
	case T_FL_LOG_ITEM_TRADE_RECV:						return "T_FL_LOG_ITEM_TRADE_RECV";
	case T_FL_LOG_ITEM_THROWAWAY_ITEM:					return "T_FL_LOG_ITEM_THROWAWAY_ITEM";
	case T_FL_LOG_ITEM_BUY_ITEM:						return "T_FL_LOG_ITEM_BUY_ITEM";
	case T_FL_LOG_ITEM_SELL_ITEM:						return "T_FL_LOG_ITEM_SELL_ITEM";
	case T_FL_LOG_ITEM_USE_ITEM:						return "T_FL_LOG_ITEM_USE_ITEM";
	case T_FL_LOG_ITEM_USE_ENERGY:						return "T_FL_LOG_ITEM_USE_ENERGY";
	case T_FL_LOG_ITEM_USE_ENCHANT:						return "T_FL_LOG_ITEM_USE_ENCHANT";
	case T_FL_LOG_ITEM_ADD_ITEM_BY_ADMIN:				return "T_FL_LOG_ITEM_ADD_ITEM_BY_ADMIN";
	case T_FL_LOG_ITEM_DEL_ITEM_BY_ADMIN:				return "T_FL_LOG_ITEM_DEL_ITEM_BY_ADMIN";
	case T_FL_LOG_ITEM_ADD_ITEM_BY_COMMAND:				return "T_FL_LOG_ITEM_ADD_ITEM_BY_COMMAND";
	case T_FL_LOG_ITEM_INSERT_TO_STORE:					return "T_FL_LOG_ITEM_INSERT_TO_STORE";
	case T_FL_LOG_ITEM_DRAW_FROM_STORE:					return "T_FL_LOG_ITEM_DRAW_FROM_STORE";
	case T_FL_LOG_ITEM_STORE_ITEM:						return "T_FL_LOG_ITEM_STORE_ITEM";
	case T_FL_LOG_ITEM_USE_MIX:							return "T_FL_LOG_ITEM_USE_MIX";
	case T_FL_LOG_ITEM_USE_CHANGE_CHARACTER_NAME_ORIGIN:	return "T_FL_LOG_ITEM_USE_CHANGE_CHARACTER_NAME_ORIGIN";
	case T_FL_LOG_ITEM_BAZAAR_SEND:						return "T_FL_LOG_ITEM_BAZAAR_SEND";
	case T_FL_LOG_ITEM_BAZAAR_RECV:						return "T_FL_LOG_ITEM_BAZAAR_RECV";
	case T_FL_LOG_ITEM_INSERT_TO_GUILDSTORE:			return "T_FL_LOG_ITEM_INSERT_TO_GUILDSTORE";
	case T_FL_LOG_ITEM_DRAW_FROM_GUILDSTORE:			return "T_FL_LOG_ITEM_DRAW_FROM_GUILDSTORE";
	case T_FL_LOG_ITEM_SPI:								return "T_FL_LOG_ITEM_SPI";			// 2006-10-27 by cmkwon
	case T_FL_LOG_ITEM_GET_ITEM_BY_ITEMEVENT:			return "T_FL_LOG_ITEM_GET_ITEM_BY_ITEMEVENT";	// 2007-01-11 by cmkwon
	case T_FL_LOG_WARPOINT:								return "T_FL_LOG_WARPOINT";						// 2007-05-15 by dhjin

	case T_FL_LOG_ARENA_TEAM_MATCH:						return "T_FL_LOG_ARENA_TEAM_MATCH";				// 2007-06-11 by dhjin
	case T_FL_LOG_TUTORIAL_COMPLETION:					return "T_FL_LOG_TUTORIAL_COMPLETION";				// 2007-07-06 by dhjin
	case T_FL_LOG_OUTPOST_START:						return "T_FL_LOG_OUTPOST_START";				// 2007-10-02 by dhjin
	case T_FL_LOG_OUTPOST_END:							return "T_FL_LOG_OUTPOST_END";				// 2007-10-02 by dhjin
	case T_FL_LOG_EXPEDIENCYFUND:						return "T_FL_LOG_EXPEDIENCYFUND";				// 2007-10-02 by dhjin

	case T_FL_LOG_SERVER_INFO_MAP:						return "T_FL_LOG_SERVER_INFO_MAP";
	case T_FL_LOG_SERVER_INFO_TOTAL:					return "T_FL_LOG_SERVER_INFO_TOTAL";
	case T_FL_LOG_HACKING_LOG:							return "T_FL_LOG_HACKING_LOG";

	case T_FL_LOG_MONSTER_BOSS:							return "T_FL_LOG_MONSTER_BOSS";
	case T_FL_LOG_MS_WAR:								return "T_FL_LOG_MS_WAR";			// 2008-04-01 by dhjin, ,  â ȹ - 
	case T_FL_LOG_SP_WAR:								return "T_FL_LOG_SP_WAR";			// 2008-04-01 by dhjin, ,  â ȹ - 
	case T_FL_LOG_WAR_CONTRIBUTION:						return "T_FL_LOG_WAR_CONTRIBUTION";			// 2008-12-23 by dhjin,   ߰
	case T_FL_LOG_WAR_CONTRIBUTION_GEAR:				return "T_FL_LOG_WAR_CONTRIBUTION_GEAR";			// 2008-12-23 by dhjin,   ߰

	case T_FL_LOG_INFLWAR_START:						return "T_FL_LOG_INFLWAR_START";					// 2007-10-16 by cmkwon, α ߰ -
	case T_FL_LOG_INFLWAR_END:							return "T_FL_LOG_INFLWAR_END";						// 2007-10-16 by cmkwon, α ߰ -
	case T_FL_LOG_OUTPOSTWAR_RESET_START:				return "T_FL_LOG_OUTPOSTWAR_RESET_START";			// 2007-10-16 by cmkwon, α ߰ -
	case T_FL_LOG_OUTPOSTWAR_RESET_DESTROY:				return "T_FL_LOG_OUTPOSTWAR_RESET_DESTROY";			// 2007-10-16 by cmkwon, α ߰ -
	case T_FL_LOG_OUTPOSTWAR_RESET_COMPLETE:			return "T_FL_LOG_OUTPOSTWAR_RESET_COMPLETE";		// 2007-10-16 by cmkwon, α ߰ -
	case T_FL_LOG_OUTPOSTWAR_PROTECTOR_DESTROY:			return "T_FL_LOG_OUTPOSTWAR_PROTECTOR_DESTROY";		// 2007-10-16 by cmkwon, α ߰ -
	case T_FL_LOG_OUTPOSTWAR_SET_NEXTTIME:				return "T_FL_LOG_OUTPOSTWAR_SET_NEXTTIME";			// 2007-10-16 by cmkwon, α ߰ -

	case T_FL_LOG_POLL_VOTE:							return "T_FL_LOG_POLL_VOTE";						// 2007-11-08 by dhjin
	case T_FL_LOG_POLL_DELETE_LEADERCANDIDATE:			return "T_FL_LOG_POLL_DELETE_LEADERCANDIDATE";		// 2007-11-08 by dhjin

	case T_FL_LOG_DISMEMBER_GUILD:						return "T_FL_LOG_DISMEMBER_GUILD";		// 2007-11-08 by dhjin
	case T_FL_LOG_NOTIFY_MSG_DELETE:					return "T_FL_LOG_NOTIFY_MSG_DELETE";	// 2008-01-23 by cmkwon
	case T_FL_LOG_USE_COUPON:							return "T_FL_LOG_USE_COUPON";			// 2008-01-23 by cmkwon, S_F, S_L:    α׿ ߰ - 

	case T_FL_LOG_ITEM_ATTACH_ITEM:						return "T_FL_LOG_ITEM_ATTACH_ITEM";		// 2008-01-23 by cmkwon, S_F, S_L: /  α׿ ߰ - 
	case T_FL_LOG_ITEM_DETACH_ITEM:						return "T_FL_LOG_ITEM_DETACH_ITEM";		// 2008-01-23 by cmkwon, S_F, S_L: /  α׿ ߰ - 
	case T_FL_LOG_ITEM_DELETE:							return "T_FL_LOG_ITEM_DELETE";			// 2008-01-23 by cmkwon, S_F, S_L: /  α׿ ߰ - 

	case T_FL_LOG_LUCKY_DROP:							return "T_FL_LOG_LUCKY_DROP";			// 2009-03-31 by dhjin, Űӽ α
	case T_FL_LOG_INFINITY_START:						return "T_FL_LOG_INFINITY_START";		// 193 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,    
	case T_FL_LOG_INFINITY_START_ITEM:					return "T_FL_LOG_INFINITY_START_ITEM";	// 194 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰, ۽   
	case T_FL_LOG_INFINITY_CINEMA:						return "T_FL_LOG_INFINITY_CINEMA";		// 195 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  α
	case T_FL_LOG_MONSTER_SKILL:						return "T_FL_LOG_MONSTER_SKILL";		// 196 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ų 
	case T_FL_LOG_HPACTION_TALK:						return "T_FL_LOG_HPACTION_TALK";		// 197 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ȭ 
	case T_FL_LOG_INFINITY_FIN:							return "T_FL_LOG_INFINITY_FIN";			// 198 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,    
	case T_FL_LOG_INFINITY_FIN_ITEM:					return "T_FL_LOG_INFINITY_FIN_ITEM";	// 199 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,    
	case T_FL_LOG_INFINITY_FIN_ALIVE_KEY_MONSTER:		return "T_FL_LOG_INFINITY_FIN_ALIVE_KEY_MONSTER";	// 200 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ִ  
	case T_FL_LOG_INFINITY_LEAVE_ITEM:					return "T_FL_LOG_INFINITY_LEAVE_ITEM";	// 201 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  Ż   
	
	case T_FL_LOG_START_FIELD_SERVER:					return "T_FL_LOG_START_FIELD_SERVER";
	
	case T_FM_GET_NUM_CLIENTS:							return "T_FM_GET_NUM_CLIENTS";
	case T_FM_GET_NUM_CLIENTS_OK:						return "T_FM_GET_NUM_CLIENTS_OK";
	case T_FM_SHUTDOWN:									return "T_FM_SHUTDOWN";
	case T_FM_SHUTDOWN_OK:								return "T_FM_SHUTDOWN_OK";
	case T_FM_PING:										return "T_FM_PING";
	case T_FM_PING_OK:									return "T_FM_PING_OK";
	case T_FM_PRINTMAP:									return "T_FM_PRINTMAP";
	case T_FM_SAVE_MAPBLOCK_INFO:						return "T_FM_SAVE_MAPBLOCK_INFO";
	case T_FM_PRINT_DEBUG_MSG:							return "T_FM_PRINT_DEBUG_MSG";
	case T_FM_SEND_CHANNEL_INFO:						return "T_FM_SEND_CHANNEL_INFO";
	case T_FM_CHANGE_BANDWIDTH_FLAG:					return "T_FM_CHANGE_BANDWIDTH_FLAG";
	case T_FM_CHANGE_BANDWIDTH_FLAG_OK:					return "T_FM_CHANGE_BANDWIDTH_FLAG_OK";
	case T_FM_SET_MSG_PRINT_LEVEL:						return "T_FM_SET_MSG_PRINT_LEVEL";
	case T_FM_GET_CHARACTER_INFO:						return "T_FM_GET_CHARACTER_INFO";
	case T_FM_GET_CHARACTER_INFO_OK:					return "T_FM_GET_CHARACTER_INFO_OK";
	case T_FM_GET_MAP_USER_COUNTS:						return "T_FM_GET_MAP_USER_COUNTS";
	case T_FM_GET_MAP_USER_COUNTS_ACK:					return "T_FM_GET_MAP_USER_COUNTS_ACK";
	case T_FM_RELOAD_ITEM_INFO:							return "T_FM_RELOAD_ITEM_INFO";
	case T_FM_RELOAD_ITEM_INFO_OK:						return "T_FM_RELOAD_ITEM_INFO_OK";
	case T_FM_RESET_NPC_SERVER:							return "T_FM_RESET_NPC_SERVER";
	case T_FM_RESET_NPC_SERVER_OK:						return "T_FM_RESET_NPC_SERVER_OK";
	case T_FM_SERVER_THREAD_STATUS:						return "T_FM_SERVER_THREAD_STATUS";
	case T_FM_SET_SERVICE_STATE:						return "T_FM_SET_SERVICE_STATE";
	case T_FM_SET_SERVICE_STATE_OK:						return "T_FM_SET_SERVICE_STATE_OK";
	case T_FM_RELOAD_SERVER_INFO:						return "T_FM_RELOAD_SERVER_INFO";
	case T_FM_RELOAD_SERVER_INFO_OK:					return "T_FM_RELOAD_SERVER_INFO_OK";
	case T_FM_INCREASE_CHANNEL:							return "T_FM_INCREASE_CHANNEL";
	case T_FM_INCREASE_CHANNEL_OK:						return "T_FM_INCREASE_CHANNEL_OK";
	case T_FM_SET_CHANNEL_STATE:						return "T_FM_SET_CHANNEL_STATE";
	case T_FM_SET_CHANNEL_STATE_OK:						return "T_FM_SET_CHANNEL_STATE_OK";
	case T_PM_GET_NUM_CLIENTS:							return "T_PM_GET_NUM_CLIENTS";
	case T_PM_GET_NUM_CLIENTS_OK:						return "T_PM_GET_NUM_CLIENTS_OK";
	case T_PM_SHUTDOWN:									return "T_PM_SHUTDOWN";
	case T_PM_SHUTDOWN_OK:								return "T_PM_SHUTDOWN_OK";
	case T_PM_CLOSE:									return "T_PM_CLOSE";
	case T_PM_CLOSE_OK:									return "T_PM_CLOSE_OK";
	case T_PM_PING:										return "T_PM_PING";
	case T_PM_PING_OK:									return "T_PM_PING_OK";
	case T_PM_RELOAD_VERSION_INFO:						return "T_PM_RELOAD_VERSION_INFO";
	case T_PM_RELOAD_VERSION_INFO_OK:					return "T_PM_RELOAD_VERSION_INFO_OK";
	case T_PM_CHANGE_BANDWIDTH_FLAG:					return "T_PM_CHANGE_BANDWIDTH_FLAG";
	case T_PM_CHANGE_BANDWIDTH_FLAG_OK:					return "T_PM_CHANGE_BANDWIDTH_FLAG_OK";
	case T_PM_SET_MSG_PRINT_LEVEL:						return "T_PM_SET_MSG_PRINT_LEVEL";
	case T_PM_PAUSE_SERVICE:							return "T_PM_PAUSE_SERVICE";
	case T_PM_PAUSE_SERVICE_OK:							return "T_PM_PAUSE_SERVICE_OK";
	case T_PM_START_SERVICE:							return "T_PM_START_SERVICE";
	case T_PM_START_SERVICE_OK:							return "T_PM_START_SERVICE_OK";
	case T_PM_GET_SERVER_GROUP_INFO:					return "T_PM_GET_SERVER_GROUP_INFO";
	case T_PM_GET_SERVER_GROUP_INFO_ACK:				return "T_PM_GET_SERVER_GROUP_INFO_ACK";
	case T_PM_SET_LIMIT_GROUP_USER_COUNTS:				return "T_PM_SET_LIMIT_GROUP_USER_COUNTS";
	case T_PM_SERVER_THREAD_STATUS:						return "T_PM_SERVER_THREAD_STATUS";
	case T_PM_RELOAD_BLOCKED_ACCOUNTS:					return "T_PM_RELOAD_BLOCKED_ACCOUNTS";
	case T_PM_RELOAD_BLOCKED_ACCOUNTS_OK:				return "T_PM_RELOAD_BLOCKED_ACCOUNTS_OK";
	case T_PM_SET_MGAME_EVENT_TYPE:						return "T_PM_SET_MGAME_EVENT_TYPE";
	case T_PM_CHANGE_ENABLE_SERVER_GROUP:				return "T_PM_CHANGE_ENABLE_SERVER_GROUP";
	case T_PM_PREPARE_SHUTDOWN:							return "T_PM_PREPARE_SHUTDOWN";
	case T_PM_AUTO_UPDATE_FTP_SERVER_SETTING:			return "T_PM_AUTO_UPDATE_FTP_SERVER_SETTING";
	case T_PM_AUTO_UPDATE_HTTP_SERVER_SETTING:			return "T_PM_AUTO_UPDATE_HTTP_SERVER_SETTING";
	case T_PM_RELOAD_VERSION_INFO_HEADER:				return "T_PM_RELOAD_VERSION_INFO_HEADER";			// 2007-01-09 by cmkwon
	case T_PM_RELOAD_VERSION_INFO_LIST:					return "T_PM_RELOAD_VERSION_INFO_LIST";				// 2007-01-09 by cmkwon
	case T_PM_RELOAD_VERSION_INFO_DONE:					return "T_PM_RELOAD_VERSION_INFO_DONE";				// 2007-01-09 by cmkwon

	case T_PIFNtoM_ADMIN_INFO_CHECK_RESOBJ_CHECKSUM:			return "T_PIFNtoM_ADMIN_INFO_CHECK_RESOBJ_CHECKSUM";			// 2012-05-13 by hskim,  ȭ
	case T_PIFNtoM_ADMIN_INFO_CHECK_RESOBJ_CHECKSUM_RESULT:		return "T_PIFNtoM_ADMIN_INFO_CHECK_RESOBJ_CHECKSUM_RESULT";		// 2012-05-13 by hskim,  ȭ
	case T_PIFNtoA_ADMIN_INFO_CHECK_RESOBJ_CHECKSUM:			return "T_PIFNtoA_ADMIN_INFO_CHECK_RESOBJ_CHECKSUM";			// 2012-05-13 by hskim,  ȭ
	case T_PIFNtoA_ADMIN_INFO_CHECK_RESOBJ_CHECKSUM_RESULT:		return "T_PIFNtoA_ADMIN_INFO_CHECK_RESOBJ_CHECKSUM_RESULT";		// 2012-05-13 by hskim,  ȭ

	case T_NM_GET_NUM_MONSTERS:							return "T_NM_GET_NUM_MONSTERS";
	case T_NM_GET_NUM_MONSTERS_OK:						return "T_NM_GET_NUM_MONSTERS_OK";
	case T_NM_SHUTDOWN:									return "T_NM_SHUTDOWN";
	case T_NM_SHUTDOWN_OK:								return "T_NM_SHUTDOWN_OK";
	case T_NM_PING:										return "T_NM_PING";
	case T_NM_PING_OK:									return "T_NM_PING_OK";
	case T_NM_PRINTMAP:									return "T_NM_PRINTMAP";
	case T_NM_SAVE_MAPBLOCK_INFO:						return "T_NM_SAVE_MAPBLOCK_INFO";
	case T_NM_SEND_CHANNEL_INFO:						return "T_NM_SEND_CHANNEL_INFO";
	case T_NM_CHANGE_BANDWIDTH_FLAG:					return "T_NM_CHANGE_BANDWIDTH_FLAG";
	case T_NM_CHANGE_BANDWIDTH_FLAG_OK:					return "T_NM_CHANGE_BANDWIDTH_FLAG_OK";
	case T_NM_SET_MSG_PRINT_LEVEL:						return "T_NM_SET_MSG_PRINT_LEVEL";
	case T_NM_GET_MAP_USER_COUNTS:						return "T_NM_GET_MAP_USER_COUNTS";
	case T_NM_GET_MAP_USER_COUNTS_ACK:					return "T_NM_GET_MAP_USER_COUNTS_ACK";
	case T_NM_SET_LIMIT_MONSTER_COUNT:					return "T_NM_SET_LIMIT_MONSTER_COUNT";
	case T_NM_SET_LIMIT_MONSTER_COUNT_ACK:				return "T_NM_SET_LIMIT_MONSTER_COUNT_ACK";
	case T_NM_SERVER_THREAD_STATUS:						return "T_NM_SERVER_THREAD_STATUS";
	case T_NM_SET_CHANNEL_STATE_OK:						return "T_NM_SET_CHANNEL_STATE_OK";
	case T_IM_GET_NUM_CLIENTS:							return "T_IM_GET_NUM_CLIENTS";
	case T_IM_GET_NUM_CLIENTS_OK:						return "T_IM_GET_NUM_CLIENTS_OK";
	case T_IM_SHUTDOWN:									return "T_IM_SHUTDOWN";
	case T_IM_SHUTDOWN_OK:								return "T_IM_SHUTDOWN_OK";
	case T_IM_PING:										return "T_IM_PING";
	case T_IM_PING_OK:									return "T_IM_PING_OK";
	case T_IM_PRINTMAP:									return "T_IM_PRINTMAP";
	case T_IM_PRINT_DEBUG_MSG:							return "T_IM_PRINT_DEBUG_MSG";
	case T_IM_CHANGE_BANDWIDTH_FLAG:					return "T_IM_CHANGE_BANDWIDTH_FLAG";
	case T_IM_CHANGE_BANDWIDTH_FLAG_OK:					return "T_IM_CHANGE_BANDWIDTH_FLAG_OK";
	case T_IM_SET_MSG_PRINT_LEVEL:						return "T_IM_SET_MSG_PRINT_LEVEL";
	case T_IM_GET_TOTAL_USER_COUNTS:					return "T_IM_GET_TOTAL_USER_COUNTS";
	case T_IM_GET_TOTAL_USER_COUNTS_ACK:				return "T_IM_GET_TOTAL_USER_COUNTS_ACK";
	case T_IM_SERVER_THREAD_STATUS:						return "T_IM_SERVER_THREAD_STATUS";
	case T_PA_ADMIN_CONNECT:							return "T_PA_ADMIN_CONNECT";
	case T_PA_ADMIN_CONNECT_OK:							return "T_PA_ADMIN_CONNECT_OK";
	case T_PA_ADMIN_CHANGE_SERVER_STATE:				return "T_PA_ADMIN_CHANGE_SERVER_STATE";
	case T_PA_ADMIN_GET_ACCOUNT_INFO:					return "T_PA_ADMIN_GET_ACCOUNT_INFO";
	case T_PA_ADMIN_GET_ACCOUNT_INFO_OK:				return "T_PA_ADMIN_GET_ACCOUNT_INFO_OK";
	case T_PA_ADMIN_DISCONNECT_USER:					return "T_PA_ADMIN_DISCONNECT_USER";
	case T_PA_ADMIN_DISCONNECT_USER_OK:					return "T_PA_ADMIN_DISCONNECT_USER_OK";
	case T_PA_ADMIN_BLOCK_ACCOUNT:						return "T_PA_ADMIN_BLOCK_ACCOUNT";
	case T_PA_ADMIN_BLOCK_ACCOUNT_OK:					return "T_PA_ADMIN_BLOCK_ACCOUNT_OK";
	case T_PA_ADMIN_UNBLOCK_ACCOUNT:					return "T_PA_ADMIN_UNBLOCK_ACCOUNT";
	case T_PA_ADMIN_UNBLOCK_ACCOUNT_OK:					return "T_PA_ADMIN_UNBLOCK_ACCOUNT_OK";
	case T_PA_ADMIN_GET_SERVER_INFO:					return "T_PA_ADMIN_GET_SERVER_INFO";
	case T_PA_ADMIN_GET_SERVER_INFO_OK:					return "T_PA_ADMIN_GET_SERVER_INFO_OK";
	case T_PA_ADMIN_GET_ACCOUNT_LIST:					return "T_PA_ADMIN_GET_ACCOUNT_LIST";
	case T_PA_ADMIN_GET_ACCOUNT_LIST_OK:				return "T_PA_ADMIN_GET_ACCOUNT_LIST_OK";
	case T_PA_ADMIN_RELOAD_HAPPYEV:						return "T_PA_ADMIN_RELOAD_HAPPYEV";
	case T_PA_ADMIN_RELOAD_ITEMEV:						return "T_PA_ADMIN_RELOAD_ITEMEV";	      // 2006-08-31 by dhjin, ItemEvent Reload
	case T_PA_ADMIN_UPDATE_PCBANGLIST:					return "T_PA_ADMIN_UPDATE_PCBANGLIST";		// 2007-01-22 by dhjin	
	case T_PA_ADMIN_UPDATE_STRATEGYPOINT_NOTSUMMONTIME:	return "T_PA_ADMIN_UPDATE_STRATEGYPOINT_NOTSUMMONTIME";		// 2007-03-06 by dhjin
	case T_PA_ADMIN_PETITION_SET_PERIOD:				return "T_PA_ADMIN_PETITION_SET_PERIOD";		// 2007-11-19 by cmkwon, ý Ʈ - 
	case T_PA_ADMIN_SET_DBSERVER_GROUP:					return "T_PA_ADMIN_SET_DBSERVER_GROUP";		// 2008-04-29 by cmkwon,   DB ߰(ű  ĳ   ý߰) - 
	case T_PA_ADMIN_SET_DBSERVER_GROUP_OK:				return "T_PA_ADMIN_SET_DBSERVER_GROUP_OK";		// 2008-04-29 by cmkwon,   DB ߰(ű  ĳ   ý߰) - 
	case T_PA_ADMIN_RELOAD_ADMIN_NOTICE_SYSTEM:			return "T_PA_ADMIN_RELOAD_ADMIN_NOTICE_SYSTEM";		// 2009-01-14 by cmkwon,  ڵ  ý  - 
	case T_PA_ADMIN_RELOAD_WORLDRANKING:				return "T_PA_ADMIN_RELOAD_WORLDRANKING";			// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_PA_ADMIN_RELOAD_INFLUENCERATE:				return "T_PA_ADMIN_RELOAD_INFLUENCERATE";			// 2009-09-16 by cmkwon,  ʱȭ ¡   - 
	case T_PA_ADMIN_LOG_ACCOUNT_ACCOUNTTYPE_CHANGE:			return "T_PA_ADMIN_LOG_ACCOUNT_ACCOUNTTYPE_CHANGE";			// 2012-06-07 by hskim,    ȭ -    α 
	case T_PA_ADMIN_LOG_CHARACTER_RACEACCOUNTTYPE_CHANGE:	return "T_PA_ADMIN_LOG_CHARACTER_RACEACCOUNTTYPE_CHANGE";	// 2012-06-07 by hskim,    ȭ -    α 

	case T_PA_ADMIN_STRATRGYPOINT_INFO_CHANGE:			return "T_PA_ADMIN_STRATRGYPOINT_INFO_CHANGE";		// 2012-11-13 by jhseol,  ý  - 

	case T_IA_ADMIN_CONNECT:							return "T_IA_ADMIN_CONNECT";
	case T_IA_ADMIN_CONNECT_OK:							return "T_IA_ADMIN_CONNECT_OK";
	case T_IA_ADMIN_CHANGE_SERVER_STATE:				return "T_IA_ADMIN_CHANGE_SERVER_STATE";
	case T_IA_ADMIN_GET_CHARACTER:						return "T_IA_ADMIN_GET_CHARACTER";
	case T_IA_ADMIN_GET_CHARACTER_OK:					return "T_IA_ADMIN_GET_CHARACTER_OK";
	case T_IA_ADMIN_CHAT_ALL:							return "T_IA_ADMIN_CHAT_ALL";
	case T_IA_ADMIN_GET_SERVER_INFO:					return "T_IA_ADMIN_GET_SERVER_INFO";
	case T_IA_ADMIN_GET_SERVER_INFO_OK:					return "T_IA_ADMIN_GET_SERVER_INFO_OK";
	case T_FA_ADMIN_CONNECT:							return "T_FA_ADMIN_CONNECT";
	case T_FA_ADMIN_CONNECT_OK:							return "T_FA_ADMIN_CONNECT_OK";
	case T_FA_ADMIN_CHANGE_SERVER_STATE:				return "T_FA_ADMIN_CHANGE_SERVER_STATE";
		
	case T_PIFNtoM_ACCOUNT_AUTH:						return "T_PIFNtoM_ACCOUNT_AUTH";					// 2012-05-13 by hskim,  ȭ
	case T_PIFNtoM_ACCOUNT_AUTH_RESULT:					return "T_PIFNtoM_ACCOUNT_AUTH_RESULT";				// 2012-05-13 by hskim,  ȭ

	case T_FC_ARENA_PLAY_CHARACTER_TYPE:				return "T_FC_ARENA_PLAY_CHARACTER_TYPE";	// 2012-06-08 by jhseol, Ʒ ߰part2 - ɸ : Ÿ 
	case T_FC_ARENA_REQUEST_TEAM:						return "T_FC_ARENA_REQUEST_TEAM";
	case T_FC_ARENA_REQUEST_TEAM_OK:					return "T_FC_ARENA_REQUEST_TEAM_OK";
	case T_FC_ARENA_CREATE_TEAM:						return "T_FC_ARENA_CREATE_TEAM";	
	case T_FC_ARENA_CREATE_TEAM_OK:						return "T_FC_ARENA_CREATE_TEAM_OK";
	case T_FC_ARENA_ENTER_TEAM:							return "T_FC_ARENA_ENTER_TEAM";		
	case T_FC_ARENA_ENTER_TEAM_OK:						return "T_FC_ARENA_ENTER_TEAM_OK";
	case T_FC_ARENA_TEAM_MEMBER_LIST:					return "T_FC_ARENA_TEAM_MEMBER_LIST";
	case T_FC_ARENA_REAVE_TEAM:							return "T_FC_ARENA_REAVE_TEAM";		
	case T_FC_ARENA_REAVE_TEAM_OK:						return "T_FC_ARENA_REAVE_TEAM_OK";
	case T_FC_ARENA_TEAM_READY:							return "T_FC_ARENA_TEAM_READY";
	case T_FC_ARENA_TEAM_READY_FINISH:					return "T_FC_ARENA_TEAM_READY_FINISH";
	case T_FC_ARENA_TEAM_READY_FINISH_CANCEL:			return "T_FC_ARENA_TEAM_READY_FINISH_CANCEL";
	case T_FC_ARENA_TEAM_MATCHING:						return "T_FC_ARENA_TEAM_MATCHING";
	case T_FC_ARENA_ENTER_ROOM:							return "T_FC_ARENA_ENTER_ROOM";
	case T_FC_ARENA_ENTER_ROOM_WARP:					return "T_FC_ARENA_ENTER_ROOM_WARP";
	case T_FC_ARENA_ROOM_WAR_START:						return "T_FC_ARENA_ROOM_WAR_START";
	case T_FC_ARENA_ROOM_WAR_INFO:						return "T_FC_ARENA_ROOM_WAR_INFO";
	case T_FC_ARENA_ROOM_WAR_FINISH_HEADER:				return "T_FC_ARENA_ROOM_WAR_FINISH_HEADER";
	case T_FC_ARENA_ROOM_WAR_FINISH:					return "T_FC_ARENA_ROOM_WAR_FINISH";
	case T_FC_ARENA_ROOM_WAR_FINISH_DONE:				return "T_FC_ARENA_ROOM_WAR_FINISH_DONE";
	case T_FC_ARENA_ROOM_WAR_FINISH_DRAW:				return "T_FC_ARENA_ROOM_WAR_FINISH_DRAW";
	case T_FC_ARENA_FINISH_WARP:						return "T_FC_ARENA_FINISH_WARP";		
	case T_FC_ARENA_FINISH_WARP_OK:						return "T_FC_ARENA_FINISH_WARP_OK";
	case T_FC_ARENA_REQUEST_CREATE_TEAMINFO:			return "T_FC_ARENA_REQUEST_CREATE_TEAMINFO";
	case T_FC_ARENA_REQUEST_CREATE_TEAMINFO_OK:			return "T_FC_ARENA_REQUEST_CREATE_TEAMINFO_OK";
	case T_FC_ARENA_BEFORE_ROOM_WAR_FINISH:				return "T_FC_ARENA_BEFORE_ROOM_WAR_FINISH";
	case T_FC_ARENA_REQUEST_OTHER_TEAM_INFO:			return "T_FC_ARENA_REQUEST_OTHER_TEAM_INFO";
	case T_FC_ARENA_REQUEST_OTHER_TEAM_INFO_OK:			return "T_FC_ARENA_REQUEST_OTHER_TEAM_INFO_OK";
	case T_FC_ARENA_GM_COMMAND_INFO_HEADER:				return "T_FC_ARENA_GM_COMMAND_INFO_HEADER";
	case T_FC_ARENA_GM_COMMAND_INFO:					return "T_FC_ARENA_GM_COMMAND_INFO";
	case T_FC_ARENA_GM_COMMAND_INFO_DONE:				return "T_FC_ARENA_GM_COMMAND_INFO_DONE";
	case T_FC_ARENA_QUICK_ENTER_TEAM:					return "T_FC_ARENA_QUICK_ENTER_TEAM";
	case T_FC_ARENA_WATCH_READY:						return "T_FC_ARENA_WATCH_READY";
	case T_FC_ARENA_WATCH_START:						return "T_FC_ARENA_WATCH_START";
	case T_FC_ARENA_WATCH_END:							return "T_FC_ARENA_WATCH_END";
	case T_FC_ARENA_WATCH_REMOVE_USER:					return "T_FC_ARENA_WATCH_REMOVE_USER";
	// 2008-01-08 by dhjin, Ʒ  - 
	case T_FC_ARENA_POSSIBLE_GAMESTART:					return "T_FC_ARENA_POSSIBLE_GAMESTART";
	case T_FC_ARENA_CHARACTER_GAMESTART:				return "T_FC_ARENA_CHARACTER_GAMESTART";
	case T_FC_ARENA_USE_CITYWARPITEM:					return "T_FC_ARENA_USE_CITYWARPITEM";
	
	case T_FC_TUTORIAL_START:							return "T_FC_TUTORIAL_START";
	case T_FC_TUTORIAL_START_OK:						return "T_FC_TUTORIAL_START_OK";
	case T_FC_TUTORIAL_COMPLETE:						return "T_FC_TUTORIAL_COMPLETE";
	case T_FC_TUTORIAL_COMPLETE_OK:						return "T_FC_TUTORIAL_COMPLETE_OK";
	case T_FC_TUTORIAL_END:								return "T_FC_TUTORIAL_END";
	case T_FC_TUTORIAL_END_OK:							return "T_FC_TUTORIAL_END_OK";
	case T_FC_TUTORIAL_WARP:							return "T_FC_TUTORIAL_WARP";
	case T_FC_OUTPOST_WAR_BEFORE:						return "T_FC_OUTPOST_WAR_BEFORE";
	case T_FC_OUTPOST_WAR_START:						return "T_FC_OUTPOST_WAR_START";
	case T_FC_OUTPOST_PROTECTOR_DESTROY:				return "T_FC_OUTPOST_PROTECTOR_DESTROY";
//	case T_FC_OUTPOST_RESET_CHECK_START:				return "T_FC_OUTPOST_RESET_CHECK_START";
//	case T_FC_OUTPOST_RESET_CHECK_START_OK:				return "T_FC_OUTPOST_RESET_CHECK_START_OK";
	case T_FC_OUTPOST_RESET_START:						return "T_FC_OUTPOST_RESET_START";
	case T_FC_OUTPOST_RESET_START_OK:					return "T_FC_OUTPOST_RESET_START_OK";
	case T_FC_OUTPOST_RESET_DESTROY:					return "T_FC_OUTPOST_RESET_DESTROY";
	case T_FC_OUTPOST_RESET_SUCCESS:					return "T_FC_OUTPOST_RESET_SUCCESS";
	case T_FC_OUTPOST_WAR_END:							return "T_FC_OUTPOST_WAR_END";
	case T_FC_OUTPOST_NEXTWAR_INFO_REQUEST:				return "T_FC_OUTPOST_NEXTWAR_INFO_REQUEST";
	case T_FC_OUTPOST_NEXTWAR_INFO_REQUEST_OK:			return "T_FC_OUTPOST_NEXTWAR_INFO_REQUEST_OK";
	case T_FC_OUTPOST_NEXTWAR_SET_TIME:					return "T_FC_OUTPOST_NEXTWAR_SET_TIME";
	case T_FC_OUTPOST_NEXTWAR_SET_TIME_OK:				return "T_FC_OUTPOST_NEXTWAR_SET_TIME_OK";
	case T_FC_OUTPOST_WAR_INFO:							return "T_FC_OUTPOST_WAR_INFO";
	case T_FC_INFO_NOTICE_REQUEST:						return "T_FC_INFO_NOTICE_REQUEST";
	case T_FC_INFO_NOTICE_REQUEST_OK:					return "T_FC_INFO_NOTICE_REQUEST_OK";
	case T_FC_INFO_NOTICE_REG:							return "T_FC_INFO_NOTICE_REG";
	case T_FC_INFO_NOTICE_REG_OK:						return "T_FC_INFO_NOTICE_REG_OK";
	case T_FC_INFO_NOTICE_MODIFY:						return "T_FC_INFO_NOTICE_MODIFY";
	case T_FC_INFO_NOTICE_MODIFY_OK:					return "T_FC_INFO_NOTICE_MODIFY_OK";
	case T_FC_INFO_EXPEDIENCYFUND_REQUEST:				return "T_FC_INFO_EXPEDIENCYFUND_REQUEST";
	case T_FC_INFO_EXPEDIENCYFUND_REQUEST_OK:			return "T_FC_INFO_EXPEDIENCYFUND_REQUEST_OK";
	case T_FC_INFO_EXPEDIENCYFUND_PAYBACK:				return "T_FC_INFO_EXPEDIENCYFUND_PAYBACK";
	case T_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK:			return "T_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK";
	case T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD:		return "T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD";		// 2007-09-12 by cmkwon, Ʈ 2н  -
	case T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD_OK:	return "T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD_OK";	// 2007-09-12 by cmkwon, Ʈ 2н  -
	case T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD:		return "T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD";		// 2007-09-12 by cmkwon, Ʈ 2н  -
	case T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD_OK:		return "T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD_OK";		// 2007-09-12 by cmkwon, Ʈ 2н  -
	case T_FC_INFO_SECONDARYPASSWORD_LOCK:					return "T_FC_INFO_SECONDARYPASSWORD_LOCK";					// 2007-09-12 by cmkwon, Ʈ 2н  -
	case T_FC_INFO_SECONDARYPASSWORD_LOCK_OK:				return "T_FC_INFO_SECONDARYPASSWORD_LOCK_OK";				// 2007-09-12 by cmkwon, Ʈ 2н  -
	case T_FC_INFO_GET_GUILDMARK:						return "T_FC_INFO_GET_GUILDMARK";					// 2007-12-07 by dhjin,  ũ C->F
	case T_FC_INFO_GET_GUILDMARK_OK:					return "T_FC_INFO_GET_GUILDMARK_OK";				// 2007-12-07 by dhjin,  ũ F->C
	case T_FtoA_MFSINFO:								return "T_FtoA_MFSINFO";							// 2007-12-27 by dhjin, Ʒ  - 	
	case T_FtoA_MFSINFO_OK:								return "T_FtoA_MFSINFO_OK";							// 2007-12-27 by dhjin, Ʒ  - 
	case T_FtoA_ALIVE:									return "T_FtoA_ALIVE";								// 2007-12-27 by dhjin, Ʒ  - 
	case T_FtoA_AUTH_CHARACTER:							return "T_FtoA_AUTH_CHARACTER";						// 2007-12-27 by dhjin, Ʒ  - 
	case T_FtoA_AUTH_CHARACTER_OK:						return "T_FtoA_AUTH_CHARACTER_OK";					// 2007-12-27 by dhjin, Ʒ  - 	
	case T_FtoA_ARENA_STATE_CHANGE:						return "T_FtoA_ARENA_STATE_CHANGE";					// 2008-01-03 by dhjin, Ʒ  - 
	case T_FtoA_ARENA_TEAM_MATCHING:					return "T_FtoA_ARENA_TEAM_MATCHING";				// 2008-01-04 by dhjin, Ʒ  - 	
	case T_FtoA_ARENA_TEAM_MATCHING_OK:					return "T_FtoA_ARENA_TEAM_MATCHING_OK";				// 2008-01-04 by dhjin, Ʒ  - 
	case T_FtoA_ARENA_SERVER_PAY:						return "T_FtoA_ARENA_SERVER_PAY";					// 2008-01-10 by dhjin, Ʒ  - 
	case T_FtoA_ARENA_CHARACTER_PAY:					return "T_FtoA_ARENA_CHARACTER_PAY";					// 2008-01-10 by dhjin, Ʒ  - 
	case T_FtoA_ARENA_CHARACTER_DISCONNECT:				return "T_FtoA_ARENA_CHARACTER_DISCONNECT";				// 2008-01-15 by dhjin, Ʒ  - 
	case T_FtoA_ARENA_CHARACTERARENAINFO_UPDATA:		return "T_FtoA_ARENA_CHARACTERARENAINFO_UPDATA";		// 2012-04-12 by jhseol, Ʒ ߰ -  : AFS -> MFS CharacterArena UUpdata û Ŷ
	case T_FtoA_ARENA_CHARACTER_RESET_RELOAD:			return "T_FtoA_ARENA_CHARACTER_RESET_RELOAD";		// 2012-12-18 by jhseol, Ʒ ĳ   ĳ  ٽ εϱ.
	case T_FC_INFO_MSWARINFO_DISPLAY:					return "T_FC_INFO_MSWARINFO_DISPLAY";				// 2008-03-27 by dhjin,   ǥ ȹ - 
	case T_FC_INFO_MSWARINFO_DISPLAY_OPTION:			return "T_FC_INFO_MSWARINFO_DISPLAY_OPTION";				// 2008-03-27 by dhjin,   ǥ ȹ - 
	case T_FC_INFO_MSWARINFO_DISPLAY_OPTION_OK:			return "T_FC_INFO_MSWARINFO_DISPLAY_OK";				// 2008-03-27 by dhjin,   ǥ ȹ - 
	case T_FC_INFO_MSWARINFO_RESULT:					return "T_FC_INFO_MSWARINFO_RESULT";					// 2008-04-02 by dhjin, ,  â ȹ - 
	case T_FC_INFO_MSWARINFO_RESULT_OK:					return "T_FC_INFO_MSWARINFO_RESULT_OK";					// 2008-04-02 by dhjin, ,  â ȹ - 
	case T_FC_INFO_SPWARINFO_RESULT:					return "T_FC_INFO_SPWARINFO_RESULT";					// 2008-04-02 by dhjin, ,  â ȹ - 
	case T_FC_INFO_SPWARINFO_RESULT_OK_HEADER:			return "T_FC_INFO_SPWARINFO_RESULT_OK_HEADER";			// 2008-04-02 by dhjin, ,  â ȹ - 
	case T_FC_INFO_SPWARINFO_RESULT_OK:					return "T_FC_INFO_SPWARINFO_RESULT_OK";					// 2008-04-02 by dhjin, ,  â ȹ - 
	case T_FC_INFO_SPWARINFO_RESULT_OK_DONE:			return "T_FC_INFO_SPWARINFO_RESULT_OK_DONE";			// 2008-04-02 by dhjin, ,  â ȹ - 
	case T_FC_CHAT_LETTER_REQUEST_TITLE:				return "T_FC_CHAT_LETTER_REQUEST_TITLE";				// 2008-04-29 by dhjin, EP3  ý -  Ʈ û C->F
	case T_FC_CHAT_LETTER_REQUEST_TITLE_OK_HEADER:		return "T_FC_CHAT_LETTER_REQUEST_TITLE_OK_HEADER";		// 2008-04-29 by dhjin, EP3  ý -  Ʈ  F->C
	case T_FC_CHAT_LETTER_REQUEST_TITLE_OK:				return "T_FC_CHAT_LETTER_REQUEST_TITLE_OK";				// 2008-04-29 by dhjin, EP3  ý -  Ʈ  F->C
	case T_FC_CHAT_LETTER_REQUEST_TITLE_OK_DONE:		return "T_FC_CHAT_LETTER_REQUEST_TITLE_OK_DONE";		// 2008-04-29 by dhjin, EP3  ý -  Ʈ  F->C
	case T_FC_CHAT_LETTER_READ:							return "T_FC_CHAT_LETTER_READ";							// 2008-04-29 by dhjin, EP3  ý -  б û C->F
	case T_FC_CHAT_LETTER_READ_OK:						return "T_FC_CHAT_LETTER_READ_OK";						// 2008-04-29 by dhjin, EP3  ý -  б Ϸ F->C
	case T_FC_CHAT_LETTER_DELETE:						return "T_FC_CHAT_LETTER_DELETE";						// 2008-04-29 by dhjin, EP3  ý -   û C->F
	case T_FC_CHAT_LETTER_DELETE_OK:					return "T_FC_CHAT_LETTER_DELETE_OK";					// 2008-04-29 by dhjin, EP3  ý -   Ϸ F->C
	case T_FC_CHAT_LETTER_SEND:							return "T_FC_CHAT_LETTER_SEND";							// 2008-05-08 by dhjin, EP3  ý -   C->F
	case T_FC_CHAT_LETTER_SEND_OK:						return "T_FC_CHAT_LETTER_SEND_OK";						// 2008-05-08 by dhjin, EP3  ý -   Ϸ F->C 
	case T_FC_CHAT_LETTER_RECEIVE:						return "T_FC_CHAT_LETTER_RECEIVE";						// 2008-05-08 by dhjin, EP3  ý -    F->C
	case T_FC_CHAT_ALLLETTER_REQUEST_TITLE:				return "T_FC_CHAT_ALLLETTER_REQUEST_TITLE";				// 2008-05-09 by dhjin, EP3  ý - ü  Ʈ û C->F
	case T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK_HEADER:	return "T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK_HEADER";	// 2008-05-09 by dhjin, EP3  ý - ü  Ʈ  F->C
	case T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK:			return "T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK";			// 2008-05-09 by dhjin, EP3  ý - ü  Ʈ  F->C
	case T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK_DONE:		return "T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK_DONE";		// 2008-05-09 by dhjin, EP3  ý - ü  Ʈ  F->C
	case T_FC_CHAT_ALLLETTER_READ:						return "T_FC_CHAT_ALLLETTER_READ";						// 2008-05-09 by dhjin, EP3  ý - ü  б û C->F
	case T_FC_CHAT_ALLLETTER_READ_OK:					return "T_FC_CHAT_ALLLETTER_READ_OK";					// 2008-05-09 by dhjin, EP3  ý - ü  б Ϸ F->C
	case T_FC_CHAT_ALLLETTER_DELETE:					return "T_FC_CHAT_ALLLETTER_DELETE";					// 2008-05-09 by dhjin, EP3  ý - ü   û C->F
	case T_FC_CHAT_ALLLETTER_DELETE_OK:					return "T_FC_CHAT_ALLLETTER_DELETE_OK";				// 2008-05-09 by dhjin, EP3  ý - ü   Ϸ F->C
	case T_FC_CHAT_ALLLETTER_SEND:						return "T_FC_CHAT_ALLLETTER_SEND";					// 2008-05-09 by dhjin, EP3  ý - ü   C->F
	case T_FC_CHAT_ALLLETTER_SEND_OK:					return "T_FC_CHAT_ALLLETTER_SEND_OK";					// 2008-05-09 by dhjin, EP3  ý - ü   Ϸ F->C 
	case T_FC_CHAT_ALLLETTER_RECEIVE:					return "T_FC_CHAT_ALLLETTER_RECEIVE";					// 2008-05-09 by dhjin, EP3  ý - ü    F->C
	case T_FC_EVENT_INFLUENCEMARK:						return "T_FC_EVENT_INFLUENCEMARK";						// 2008-08-18 by dhjin, ¸ũ̺Ʈ F->C
	case T_FC_EVENT_INFLUENCEMARKEND:					return "T_FC_EVENT_INFLUENCEMARKEND";					// 2008-08-18 by dhjin, ¸ũ̺Ʈ F->C
	case T_FC_QUEST_REQUEST_MISSIONMASTER_HELP:			return "T_FC_QUEST_REQUEST_MISSIONMASTER_HELP";			// 2008-12-02 by dhjin, C -> F, ̼Ǹ û
	case T_FC_QUEST_REQUEST_MISSIONMASTER_HELP_INVITE:	return "T_FC_QUEST_REQUEST_MISSIONMASTER_HELP_INVITE";	// 2008-12-02 by dhjin, F -> C(n),   ̼ǸͿ û
	case T_FC_QUEST_MISSIONMASTER_HELP_INVITE:			return "T_FC_QUEST_MISSIONMASTER_HELP_INVITE";			// 2008-12-02 by dhjin, C -> F, ̼Ǹ û ¶ 
	case T_FC_QUEST_MISSIONMASTER_HELP_INVITE_OK:		return "T_FC_QUEST_MISSIONMASTER_HELP_INVITE_OK";		// 2008-12-02 by dhjin, F -> C, ̼Ǹ û ¶
	case T_FC_QUEST_MISSIONMASTER_HELP_REJECT:			return "T_FC_QUEST_MISSIONMASTER_HELP_REJECT";			// 2008-12-02 by dhjin, C -> F, ̼Ǹ û  
	case T_FC_QUEST_MISSIONMASTER_HELP_REJECT_OK:		return "T_FC_QUEST_MISSIONMASTER_HELP_REJECT_OK";		// 2008-12-02 by dhjin, F -> C, ̼Ǹ û 
	case T_FC_QUEST_INSERT_QUEST:						return "T_FC_QUEST_INSERT_QUEST";						// 2009-03-31 by cmkwon, ʱȭ ý  - 
	case T_FC_QUEST_DELETE_QUEST:						return "T_FC_QUEST_DELETE_QUEST";						// 2009-03-31 by cmkwon, ʱȭ ý  - 

	case T_FC_INFO_DECLARATION_MSWAR_INFO:				return "T_FC_INFO_DECLARATION_MSWAR_INFO";				// 2009-01-12 by dhjin,   -   û C->F
	case T_FC_INFO_DECLARATION_MSWAR_INFO_OK:			return "T_FC_INFO_DECLARATION_MSWAR_INFO_OK";			// 2009-01-12 by dhjin,   -    F->C
	case T_FC_INFO_DECLARATION_MSWAR_SET:				return "T_FC_INFO_DECLARATION_MSWAR_SET";				// 2009-01-12 by dhjin,   -  ð    C->F
	case T_FI_INFO_DECLARATION_MSWAR_SET_OK:			return "T_FI_INFO_DECLARATION_MSWAR_SET_OK";			// 2009-01-12 by dhjin,   -  ð    F->I
	case T_IC_INFO_DECLARATION_MSWAR_SET_OK:			return "T_IC_INFO_DECLARATION_MSWAR_SET_OK";			// 2009-01-12 by dhjin,   -  ð    I->C

	case T_FC_INFO_WRK_GET_SERVICE_INFO:				return "T_FC_INFO_WRK_GET_SERVICE_INFO";				// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_SERVICE_INFO_OK:				return "T_FC_INFO_WRK_GET_SERVICE_INFO_OK";				// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_SERVICE_INFO_OK_IMAGE:		return "T_FC_INFO_WRK_GET_SERVICE_INFO_OK_IMAGE";		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_SERVICE_INFO_OK_DONE:		return "T_FC_INFO_WRK_GET_SERVICE_INFO_OK_DONE";		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_RANKER_LIST:					return "T_FC_INFO_WRK_GET_RANKER_LIST";					// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_LEVEL_RANKER_LIST_OK:		return "T_FC_INFO_WRK_GET_LEVEL_RANKER_LIST_OK";		// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_FAME_RANKER_LIST_OK:			return "T_FC_INFO_WRK_GET_FAME_RANKER_LIST_OK";			// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_PVP_RANKER_LIST_OK:			return "T_FC_INFO_WRK_GET_PVP_RANKER_LIST_OK";			// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_SELF_RANKING:				return "T_FC_INFO_WRK_GET_SELF_RANKING";				// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 
	case T_FC_INFO_WRK_GET_SELF_RANKING_OK:				return "T_FC_INFO_WRK_GET_SELF_RANKING_OK";				// 2009-02-12 by cmkwon, EP3-3 巩ŷý  - 

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -
	case T_FN_MONSTER_HPTALK:							return "T_FN_MONSTER_HPTALK";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ - , N->F
	case T_FC_MONSTER_HPTALK:							return "T_FC_MONSTER_HPTALK";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ - , F->C
	case T_FC_MONSTER_SKILL:							return "T_FC_MONSTER_SKILL";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ - , F->C
	case T_FC_INFINITY_MODE_LIST:						return "T_FC_INFINITY_MODE_LIST";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ʈ û, C -> F
	case T_FC_INFINITY_MODE_LIST_OK:					return "T_FC_INFINITY_MODE_LIST_OK";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ʈ û, F -> C
	case T_FC_INFINITY_READY_LIST:						return "T_FC_INFINITY_READY_LIST";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ʈ û, C -> F
	case T_FC_INFINITY_READY_LIST_OK:					return "T_FC_INFINITY_READY_LIST_OK";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ʈ û, F -> C
	case T_FC_INFINITY_CREATE:							return "T_FC_INFINITY_CREATE";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   û, C -> F
	case T_FC_INFINITY_CREATE_OK:						return "T_FC_INFINITY_CREATE_OK";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   û, F -> C
	case T_FC_INFINITY_JOIN:							return "T_FC_INFINITY_JOIN";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   û, C -> F
	case T_FC_INFINITY_JOIN_REQUEST_MASTERUSER:			return "T_FC_INFINITY_JOIN_REQUEST_MASTERUSER";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  忡    û, F -> C
	case T_FC_INFINITY_JOIN_REQUEST_MASTERUSER_OK:		return "T_FC_INFINITY_JOIN_REQUEST_MASTERUSER_OK";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  忡    û, C -> F
	case T_FC_INFINITY_JOIN_OK:							return "T_FC_INFINITY_JOIN_OK";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   û, F -> C
	case T_FC_INFINITY_MEMBER_INFO_LIST:				return "T_FC_INFINITY_MEMBER_INFO_LIST";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ɹ , C -> F
	case T_FC_INFINITY_MEMBER_INFO_LIST_OK:				return "T_FC_INFINITY_MEMBER_INFO_LIST_OK";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ɹ , F -> C
	case T_FC_INFINITY_CHANGE_MASTER:					return "T_FC_INFINITY_CHANGE_MASTER";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   , C -> F
	case T_FC_INFINITY_CHANGE_MASTER_OK:				return "T_FC_INFINITY_CHANGE_MASTER_OK";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   , F -> C
	case T_FC_INFINITY_LEAVE:							return "T_FC_INFINITY_LEAVE";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ż, C -> F
	case T_FC_INFINITY_LEAVE_OK:						return "T_FC_INFINITY_LEAVE_OK";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ż, F -> C
	case T_FC_INFINITY_BAN:								return "T_FC_INFINITY_BAN";								// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ߹, C -> F
	case T_FC_INFINITY_BAN_OK:							return "T_FC_INFINITY_BAN_OK";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ߹, F -> C
	case T_FtoA_INFINITY_IMPUTE_LIST:					return "T_FtoA_INFINITY_IMPUTE_LIST";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ͼ  , MFS -> AFS
	case T_FC_INFINITY_READY:							return "T_FC_INFINITY_READY";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   ư , C -> F
	case T_FC_INFINITY_READY_OK:						return "T_FC_INFINITY_READY_OK";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   ư , F -> C
	case T_FC_INFINITY_READY_CANCEL:					return "T_FC_INFINITY_READY_CANCEL";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   ư , C -> F
	case T_FC_INFINITY_READY_CANCEL_OK:					return "T_FC_INFINITY_READY_CANCEL_OK";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   ư , F -> C
	case T_FC_INFINITY_START:							return "T_FC_INFINITY_START";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   ư ( ), C -> F
	case T_FtoA_INFINITY_START:							return "T_FtoA_INFINITY_START";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   MainFieldServer ˸, AFS -> MFS
	case T_FtoA_INFINITY_START_OK:						return "T_FtoA_INFINITY_START_OK";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   MainFieldSeverغ Ϸ , MFS -> AFS
	case T_FC_INFINITY_MAP_LOADING:						return "T_FC_INFINITY_MAP_LOADING";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   ε  ˸, F -> C
	case T_FC_INFINITY_MAP_LOADED:						return "T_FC_INFINITY_MAP_LOADED";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   ε Ϸ, C -> F
	case T_FtoA_INFINITY_IMPUTE:						return "T_FtoA_INFINITY_IMPUTE";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer ͼ  , AFS -> MFS
	case T_FC_INFINITY_ENTER:							return "T_FC_INFINITY_ENTER";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -    㰡, F -> C
	case T_FC_INFINITY_CINEMA:							return "T_FC_INFINITY_CINEMA";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ó׸  , F -> C
	case T_FN_NPCSERVER_CINEMA_MONSTER_CREATE:			return "T_FN_NPCSERVER_CINEMA_MONSTER_CREATE";			// 2010-03-31 by dhjin, ǴƼ() -	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Ű  , F -> N
	case T_FC_INFINITY_SUCCESS_FIN:						return "T_FC_INFINITY_SUCCESS_FIN";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  , F -> C
	case T_FC_INFINITY_FAIL_FIN:						return "T_FC_INFINITY_FAIL_FIN";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  , F -> C
	case T_FC_INFINITY_FIN_OK:							return "T_FC_INFINITY_FIN_OK";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ȯ  (Main ư), C -> F
	case T_FC_INFINITY_READY_FINISH_MAINSVR_START:		return "T_FC_INFINITY_READY_FINISH_MAINSVR_START";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Main ư غ Ϸ , F -> C
	case T_FC_INFINITY_MOVIE:							return "T_FC_INFINITY_MOVIE";							// 2011-05-17 by hskim, ǴƼ 3 - ó׸ , F -> C
	case T_FtoA_INFINITY_UPDATE_ALL_ITEM_COUNT:			return "T_FtoA_INFINITY_UPDATE_ALL_ITEM_COUNT";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_INSERT_ITEM_HEADER:			return "T_FtoA_INFINITY_INSERT_ITEM_HEADER";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_INSERT_ITEM:					return "T_FtoA_INFINITY_INSERT_ITEM";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_INSERT_ITEM_DONE:				return "T_FtoA_INFINITY_INSERT_ITEM_DONE";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_UPDATE_ITEM_HEADER:			return "T_FtoA_INFINITY_UPDATE_ITEM_HEADER";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_UPDATE_ITEM:					return "T_FtoA_INFINITY_UPDATE_ITEM";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_UPDATE_ITEM_DONE:				return "T_FtoA_INFINITY_UPDATE_ITEM_DONE";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_DELETE_ITEM:					return "T_FtoA_INFINITY_DELETE_ITEM";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_UPDATE_USER_INFO:				return "T_FtoA_INFINITY_UPDATE_USER_INFO";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer  ȭ  , AFS -> MFS
	case T_FtoA_INFINITY_READY_FINISH_MAINSVR_START:	return "T_FtoA_INFINITY_READY_FINISH_MAINSVR_START";	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Main ư غ Ϸ , MFS -> AFS
	case T_FtoA_INFINITY_LOG:							return "T_FtoA_INFINITY_LOG";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer α , AFS -> MFS
	case T_FtoA_INFINITY_USING_TIME_LIMIT_ITEM:			return "T_FtoA_INFINITY_USING_TIME_LIMIT_ITEM";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  MainFieldServer α , AFS -> MFS
	case T_FN_NPCSERVER_NEW_CHANGE_OBJECT:				return "T_FN_NPCSERVER_NEW_CHANGE_OBJECT";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ʈ !!!! 
	case T_FN_NPCSERVER_RESET_CHANGE_OBJECT:			return "T_FN_NPCSERVER_RESET_CHANGE_OBJECT";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Ʈ !!!! 
	case T_FC_INFINITY_TENDER_DROPITEM_INFO:			return "T_FC_INFINITY_TENDER_DROPITEM_INFO";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ͿԼ  Tender , F -> C
	case T_FC_INFINITY_TENDER_START:					return "T_FC_INFINITY_TENDER_START";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Tender , F -> C
	case T_FC_INFINITY_TENDER_PUT_IN_TENDER:			return "T_FC_INFINITY_TENDER_PUT_IN_TENDER";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Tender ư , C -> F
	case T_FC_INFINITY_TENDER_PUT_IN_TENDER_OK:			return "T_FC_INFINITY_TENDER_PUT_IN_TENDER_OK";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  Tender ư  , F -> C
	case T_FC_INFINITY_TENDER_RESULT:					return "T_FC_INFINITY_TENDER_RESULT";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  , F -> C
	case T_FC_INFINITY_TENDER_RESULT_TIMEOVER:			return "T_FC_INFINITY_TENDER_TIMEOVER";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Tender ð  ڰ , F -> C
	case T_FC_INFINITY_TENDER_RESULT_ALLGIVEUP:			return "T_FC_INFINITY_TENDER_ALLGIVEUP";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   , F -> C
	case T_FC_INFO_APPLY_RESISTANCE_ITEM:				return "T_FC_INFO_APPLY_RESISTANCE_ITEM";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -     , F -> C(n)
	case T_FC_SHOP_INFINITY_ITEM_HEADER:				return "T_FC_SHOP_INFINITY_ITEM_HEADER";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	case T_FC_SHOP_INFINITY_ITEM:						return "T_FC_SHOP_INFINITY_ITEM";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	case T_FC_SHOP_INFINITY_ITEM_DONE:					return "T_FC_SHOP_INFINITY_ITEM_DONE";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	case T_FC_SHOP_INFINITY_BUY_ITEM:					return "T_FC_SHOP_INFINITY_BUY_ITEM";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - , 
	case T_FC_INFINITY_CHANGE_LIMITTIME:				return "T_FC_INFINITY_CHANGE_LIMITTIME";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   гƼ ߰, F -> C
	case T_FC_INFINITY_JOIN_CANCEL:						return "T_FC_INFINITY_JOIN_CANCEL";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   
	case T_FC_INFINITY_JOIN_CANCEL_REQUEST_MASTERUSER:	return "T_FC_INFINITY_JOIN_CANCEL_REQUEST_MASTERUSER";	// 2009-09-09 ~ 2010 by dhjin, ǴƼ -   
	case T_FC_INFINITY_REQUEST_RESTART_BY_DISCONNECT:	return "T_FC_INFINITY_REQUEST_RESTART_BY_DISCONNECT";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó
	case T_FC_INFINITY_RESTART_BY_DISCONNECT:			return "T_FC_INFINITY_RESTART_BY_DISCONNECT";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó
	case T_FC_INFINITY_MAP_LOADED_RESTART_BY_DISCONNECT:			return "T_FC_INFINITY_MAP_LOADED_RESTART_BY_DISCONNECT";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó
	case T_FC_INFINITY_DELETED_CINEMA_HEADER:			return "T_FC_INFINITY_DELETED_CINEMA_HEADER";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó
	case T_FC_INFINITY_DELETED_CINEMA:					return "T_FC_INFINITY_DELETED_CINEMA";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó
	case T_FC_INFINITY_DELETED_CINEMA_DONE:				return "T_FC_INFINITY_DELETED_CINEMA_DONE";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó
	case T_FC_INFINITY_ENTER_BY_DISCONNECT:				return "T_FC_INFINITY_ENTER_BY_DISCONNECT";			// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó
	case T_FtoA_INFINITY_STATE_CHANGE:					return "T_FtoA_INFINITY_STATE_CHANGE";			// 2009-09-09 ~ 2010-01-20 by dhjin, ǴƼ -    μ Ѵ.   üũ
	case T_FI_PARTY_AUTO_CREATE:						return "T_FI_PARTY_AUTO_CREATE";					// 2009-09-09 ~ 2010-01-26 by dhjin, ǴƼ - ڵ   û, F -> I
	case T_FI_PARTY_AUTO_CREATE_OK:						return "T_FI_PARTY_AUTO_CREATE_OK";				// 2009-09-09 ~ 2010-01-26 by dhjin, ǴƼ - ڵ   Ϸ, I -> F
	case T_FC_PARTY_AUTO_CREATED:						return "T_FC_PARTY_AUTO_CREATED";					// 2009-09-09 ~ 2010-01-26 by dhjin, ǴƼ - ڵ   Ϸ ˸, F -> C
	case T_IC_PARTY_GET_AUTO_PARTY_INFO:				return "T_IC_PARTY_GET_AUTO_PARTY_INFO";			// 2009-09-09 ~ 2010-01-26 by dhjin, ǴƼ - ڵ   û, C -> I
	case T_IC_PARTY_GET_AUTO_PARTY_INFO_OK:				return "T_IC_PARTY_GET_AUTO_PARTY_INFO_OK";		// 2009-09-09 ~ 2010-01-26 by dhjin, ǴƼ - ڵ   , I -> C
	case T_FI_PARTY_DISCONNECT_LEAVE_OK:				return "T_FI_PARTY_DISCONNECT_LEAVE_OK";		// 2009-09-09 ~ 2010-01-27 by dhjin, ǴƼ -    Ƽ Żó!
	case T_FC_ITEM_USE_INVOKING_WEAR_ITEM:				return "T_FC_ITEM_USE_INVOKING_WEAR_ITEM";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ , C->F
	case T_FC_ITEM_EXPIRE_TIME_INVOKING_WEAR_ITEM:		return "T_FC_ITEM_EXPIRE_TIME_INVOKING_WEAR_ITEM";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ  ð Ϸ, C->F
	case T_FC_INFO_APPLY_DESTPARAM:						return "T_FC_INFO_APPLY_DESTPARAM";				// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, DestParam    
	case T_FC_INFO_APPLY_DESTPARAM_LIST:				return "T_FC_INFO_APPLY_DESTPARAM_LIST";				// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, DestParam    
	case T_FC_ITEM_END_COOLINGTIME_ITEM:				return "T_FC_ITEM_END_COOLINGTIME_ITEM";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, Ÿ  C->F
	case T_FC_ITEM_END_COOLINGTIME_ITEM_OK:				return "T_FC_ITEM_END_COOLINGTIME_ITEM_OK";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, Ÿ  F->C
	case T_FC_ITEM_GET_COOLINGTIME_INFO:				return "T_FC_ITEM_GET_COOLINGTIME_INFO";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, Ÿ  û C->F
	case T_FC_ITEM_GET_COOLINGTIME_INFO_OK:				return "T_FC_ITEM_GET_COOLINGTIME_INFO_OK";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, Ÿ  û F->C
	case T_FC_ITEM_USE_INVOKING_WEAR_ITEM_BUFF:			return "T_FC_ITEM_USE_INVOKING_WEAR_ITEM_BUFF";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ,  ø F->C
	case T_FC_INFINITY_CHANGE_ALIVE_FOR_GAMECLEAR_MONSTERHP:	return "T_FC_INFINITY_CHANGE_ALIVE_FOR_GAMECLEAR_MONSTERHP";		// 2010-03-31 by dhjin, ǴƼ() -   гƼ, F -> C
	case T_FC_MONSTER_CREATED_ALIVE_FOR_GAMECLEAR:		return "T_FC_MONSTER_CREATED_ALIVE_FOR_GAMECLEAR";		// 2010-03-31 by dhjin, ǴƼ() -

	case T_FC_ITEM_UPDATE_TRANSFORMER_OK:				return "T_FC_ITEM_UPDATE_TRANSFORMER_OK";			// 2010-03-18 by cmkwon, ͺ  - 
	case T_FI_PARTY_UPDATE_ITEM_TRANSFORMER_OK:			return "T_FI_PARTY_UPDATE_ITEM_TRANSFORMER_OK";		// 2010-03-18 by cmkwon, ͺ  - 
	case T_IC_PARTY_UPDATE_ITEM_TRANSFORMER_OK:			return "T_IC_PARTY_UPDATE_ITEM_TRANSFORMER_OK";		// 2010-03-18 by cmkwon, ͺ  - 

	case T_FN_BATTLE_ATTACK_SKILL_CANCEL:				return "T_FN_BATTLE_ATTACK_SKILL_CANCEL";		// 2010-03-31 by dhjin, ǴƼ() -
	case T_FC_MONSTER_SKILL_CANCEL:						return "T_FC_MONSTER_SKILL_CANCEL";		// 2010-03-31 by dhjin, ǴƼ() -
	case T_FtoA_UPDATE_ITEM_NOTI:						return "T_FtoA_UPDATE_ITEM_NOTI";		//	MFS -> AFS // 2010-03-31 by dhjin, ǴƼ  ĳ   - 

	case T_FtoA_INFINITY_UPDATE_USER_MAP_INFO:			return "T_FtoA_INFINITY_UPDATE_USER_MAP_INFO";		// 2010-04-06 by cmkwon, 2 ߰  - 
	
	//case T_FC_INFINITY_DIFFICULTY_LIST:				return "T_FC_INFINITY_DIFFICULTY_LIST";		// 2010-05-04 by shcho, ǴƼ ̵  -
	case T_FC_INFINITY_DIFFICULTY_LIST_OK:				return "T_FC_INFINITY_DIFFICULTY_LIST_OK";	// 2010-05-04 by shcho, ǴƼ ̵  -

	case T_FC_INFINITY_CHANGE_DIFFICULTY_LEVEL:			return "T_FC_INFINITY_CHANGE_DIFFICULTY_LEVEL";			// C -> AFS // 2010-05-24 by hsLee, ̵  û.
	case T_FC_INFINITY_CHANGE_DIFFICULTY_LEVEL_OK :		return "T_FC_INFINITY_CHANGE_DIFFICULTY_LEVEL_OK";		// AFS -> C // 2010-05-24 by hsLee, ̵  û .

	case T_FC_INFINITY_READY_CANCEL_ALL_OK :			return "T_FC_INFINITY_READY_CANCEL_ALL_OK";				// AFS -> C // 2010-05-31 by hsLee,   . (̵ ).

	case T_FC_INFINITY_SKIP_ENDING_CINEMA :				return "T_FC_INFINITY_SKIP_ENDING_CINEMA";				// C -> F // ǴƼ    ó׸  ŵ û. 2010. 07. 27 by hsLee.
	case T_FC_INFINITY_SKIP_ENDING_CINEMA_OK :			return "T_FC_INFINITY_SKIP_ENDING_CINEMA_OK";			// F -> C // ǴƼ    ó׸  ŵ . 2010. 07. 27 by hsLee.

	case T_FC_ITEM_HOMEPREMIUM_INFO :					return "T_FC_ITEM_HOMEPREMIUM_INFO";				// F->C, // 2010-06-01 by shcho, PC  ȹ(ĳ)  -

	// 2010-06-15 by shcho&hslee ý - Ŭ̾Ʈ Ŷ  Ŀǵ ߰
	case T_FC_ITEM_PET_HEADER:							return "T_FC_ITEM_PET_HEADER";				
	case T_FC_ITEM_PET:									return "T_FC_ITEM_PET";
	case T_FC_ITEM_PET_BASEDATA_OK:						return "T_FC_ITEM_PET_BASEDATA_OK";
	//case T_FC_ITEM_PET_SKILLDATA_OK:					return "T_FC_ITEM_PET_SKILLDATA_OK";		// 2011-08-30 by hskim, Ʈ ý 2
	//case T_FC_ITEM_PET_SOCKETDATA_OK:					return "T_FC_ITEM_PET_SOCKETDATA_OK";		// 2011-08-30 by hskim, Ʈ ý 2
	case T_FC_ITEM_PET_DONE:							return "T_FC_ITEM_PET_DONE";
	
	case T_IP_AUTHENTICATION_SHUTDOWN:					return "T_IP_AUTHENTICATION_SHUTDOWN";		// 2011-06-22 by hskim, 缳  
	case T_FP_AUTHENTICATION_SHUTDOWN:					return "T_FP_AUTHENTICATION_SHUTDOWN";		// 2011-06-22 by hskim, 缳  	

	/////////////////////////////////////////////////////////////
	// start 2011-08-22 by hskim, Ʈ ý 2 -  

	case T_FC_ITEM_PET_SET_NAME:						return "T_FC_ITEM_PET_SET_NAME";					// C -> F, 2011-08-22 by hskim, Ʈ ý 2 -  ̸  û
	case T_FC_ITEM_PET_SET_NAME_OK:						return "T_FC_ITEM_PET_SET_NAME_OK";					// F -> C, 2011-08-22 by hskim, Ʈ ý 2 -  ̸  û 
	case T_FC_ITEM_PET_SET_EXP_RATIO:					return "T_FC_ITEM_PET_SET_EXP_RATIO";				// C -> F, 2011-08-22 by hskim, Ʈ ý 2 -  ġ ȹ   û
	case T_FC_ITEM_PET_SET_EXP_RATIO_OK:				return "T_FC_ITEM_PET_SET_EXP_RATIO_OK";			// F -> C, 2011-08-22 by hskim, Ʈ ý 2 -  ġ ȹ   
	case T_FC_ITEM_PET_CHANGE_LEVEL:					return "T_FC_ITEM_PET_CHANGE_LEVEL";				// F -> C, 2011-08-22 by hskim, Ʈ ý 2 -   ˸
	case T_FC_ITEM_PET_CHANGE_EXP:						return "T_FC_ITEM_PET_CHANGE_EXP";					// F -> C, 2011-08-22 by hskim, Ʈ ý 2 -  ġ ȹ ˸

	case T_FC_ITEM_PET_SET_SOCKET:						return "T_FC_ITEM_PET_SET_SOCKET";					// C -> F, 2011-08-30 by hskim, Ʈ ý 2 -   
	case T_FC_ITEM_PET_SET_SOCKET_OK:					return "T_FC_ITEM_PET_SET_SOCKET_OK";				// F -> C, 2011-08-30 by hskim, Ʈ ý 2 -    
	case T_FC_ITEM_PET_SET_KIT_SLOT:					return "T_FC_ITEM_PET_SET_KIT_SLOT";				// C -> F, 2011-08-30 by hskim, Ʈ ý 2 - ŰƮ  
	case T_FC_ITEM_PET_SET_KIT_SLOT_OK:					return "T_FC_ITEM_PET_SET_KIT_SLOT_OK";				// F -> C, 2011-08-30 by hskim, Ʈ ý 2 - ŰƮ   
	case T_FC_ITEM_PET_SET_AUTOSKILL_SLOT:				return "T_FC_ITEM_PET_SET_AUTOSKILL_SLOT";			// C -> F, 2011-08-30 by hskim, Ʈ ý 2 -  ų  
	case T_FC_ITEM_PET_SET_AUTOSKILL_SLOT_OK:			return "T_FC_ITEM_PET_SET_AUTOSKILL_SLOT_OK";		// F -> C, 2011-08-30 by hskim, Ʈ ý 2 -  ų  		

	case T_FtoA_INFINITY_COME_BACK_PREWORK:				return "T_FtoA_INFINITY_COME_BACK_PREWORK";			//  AMF - >MFS // 2011-09-29 by hskim, Ʈ ý 2 -  MainFieldServer ư   ۾ ó 
	case T_FtoA_INFINITY_UPDATE_ITEM_PET:				return "T_FtoA_INFINITY_UPDATE_ITEM_PET";			//	AFS -> MFS // 2011-09-30 by hskim, Ʈ ý 2 -  MainFieldServer Ʈ  ȭ  
	case T_FtoA_INFINITY_COME_BACK_POSTWORK:			return "T_FtoA_INFINITY_COME_BACK_POSTWORK";		//  AMF - >MFS  // 2011-09-29 by hskim, Ʈ ý 2 -  MainFieldServer ư   ۾ ó 

	// end 2011-08-22 by hskim, Ʈ ý 2 -  
	/////////////////////////////////////////////////////////////

	// 2012-07-23 by jhseol, Ʈ ɰȭ : ۽ - Ŷ
	case T_FC_ITEM_PET_SWAP_SAVE:						return "T_FC_ITEM_PET_SWAP_SAVE";
	case T_FC_ITEM_PET_SWAP_SAVE_OK:					return "T_FC_ITEM_PET_SWAP_SAVE_OK";
	case T_FC_ITEM_PET_SWAP_CHANGE_OK:					return "T_FC_ITEM_PET_SWAP_CHANGE_OK";
	// end 2012-07-23 by jhseol, Ʈ ɰȭ : ۽ - Ŷ

	////////////////////////////////////////////////////////////////////////////
	// 2012-10-05 by jhseol, NPlay pc 
	case T_FP_PCBANG_USER_GAME_START:					return "T_FP_PCBANG_USER_GAME_START";
	case T_FP_PCBANG_USER_GAME_END:						return "T_FP_PCBANG_USER_GAME_END";
	case T_FP_PCBANG_USER_PREMIUN_END:					return "T_FP_PCBANG_USER_PREMIUN_END";
	case T_FP_PCBANG_USER_PREMIUM_INFO:					return "T_FP_PCBANG_USER_PREMIUM_INFO";
	case T_FP_PCBANG_USER_PREMIUM_REQUEST:				return "T_FP_PCBANG_USER_PREMIUM_REQUEST";
	case T_FP_PCBANG_USER_PREMIUM_RESIDUAL_TIME:		return "T_FP_PCBANG_USER_PREMIUM_RESIDUAL_TIME";
	case T_FC_CHARACTER_PCBANG_PREMIUN_APPLY:			return "T_FC_CHARACTER_PCBANG_PREMIUN_APPLY";
	// end 2012-10-05 by jhseol, NPlay pc 

	// 2012-10-17 by hskim, XignCode۾
	case T_FC_CHARACTER_XIGNCODE_C_ACK_PACKET:			return "T_FC_CHARACTER_XIGNCODE_C_ACK_PACKET";
	case T_FC_CHARACTER_XIGNCODE_C_ACK_CODE:			return "T_FC_CHARACTER_XIGNCODE_C_ACK_CODE";
	case T_FC_CHARACTER_XIGNCODE_S_ACK_PACKET:			return "T_FC_CHARACTER_XIGNCODE_S_ACK_PACKET";
	// end 2012-10-17 by hskim, XignCode۾
	}
	return "NO SUCH MESSAGE TYPE";
}

const char* GetGameLogTypeString(MessageType_t msgType)
{
	switch(msgType)
	{
	case T_FA_ADMIN_CHANGE_SERVER_STATE:				return "T_FA_ADMIN_CHANGE_SERVER_STATE";
	case T1_FL_LOG_LOGIN:								return "T1_FL_LOG_LOGIN";
	case T1_FL_LOG_LOGOUT:								return "T1_FL_LOG_LOGOUT";
	case T1_FL_LOG_LEVEL:								return "T1_FL_LOG_LEVEL";
	case T1_FL_LOG_EXP:									return "T1_FL_LOG_EXP";
	case T1_FL_LOG_STAT:								return "T1_FL_LOG_STAT";
	case T1_FL_LOG_GAME_START:							return "T1_FL_LOG_GAME_START";
	case T1_FL_LOG_GAME_END:							return "T1_FL_LOG_GAME_END";
	case T1_FL_LOG_QUEST_COMPLETION:					return "T1_FL_LOG_QUEST_COMPLETION";
	case T1_FL_LOG_QUEST_COMPENSATION:					return "T1_FL_LOG_QUEST_COMPENSATION";

	case T1_FL_LOG_PKWIN:								return "T1_FL_LOG_PKWIN";
	case T1_FL_LOG_PKLOSS:								return "T1_FL_LOG_PKLOSS";
	case T1_FL_LOG_DEAD:								return "T1_FL_LOG_DEAD";
	case T1_FL_LOG_WARP:								return "T1_FL_LOG_WARP";
	case T1_FL_LOG_SPEED_HACK:							return "T1_FL_LOG_SPEED_HACK";
	case T1_FL_LOG_CREATE_CHARACTER:					return "T1_FL_LOG_CREATE_CHARACTER";
	case T1_FL_LOG_DELETE_CHARACTER:					return "T1_FL_LOG_DELETE_CHARACTER";
	case T1_FL_LOG_MEMORY_HACK:							return "T1_FL_LOG_MEMORY_HACK";
	case T1_FL_LOG_PvEWIN:								return "T1_FL_LOG_PvEWIN";
	case T1_FL_LOG_PvELOSS:								return "T1_FL_LOG_PvELOSS";
	case T1_FL_LOG_ITEM_CHARACTER_ITEM:					return "T1_FL_LOG_ITEM_CHARACTER_ITEM";
	case T1_FL_LOG_ITEM_GET_ITEM:						return "T1_FL_LOG_ITEM_GET_ITEM";
	case T1_FL_LOG_ITEM_TRADE_SEND:						return "T1_FL_LOG_ITEM_TRADE_SEND";
	case T1_FL_LOG_ITEM_TRADE_RECV:						return "T1_FL_LOG_ITEM_TRADE_RECV";
	case T1_FL_LOG_ITEM_THROWAWAY_ITEM:					return "T1_FL_LOG_ITEM_THROWAWAY_ITEM";
	case T1_FL_LOG_ITEM_BUY_ITEM:						return "T1_FL_LOG_ITEM_BUY_ITEM";

	// 2012-10-16 by bckim, ĳ  Log ߰
	case T1_FL_LOG_ITEM_BUY_CASH_PRICE:					return "T1_FL_LOG_ITEM_BUY_CASH_PRICE";
	// end 2012-10-16 by bckim, ĳ  Log ߰
	// 2012-12-17 by bckim, â  ̵  ߰α 
	case T1_FL_LOG_ITEM_CHARACTER_ITEM_GUILDSTORE_RESULT:	return "T1_FL_LOG_ITEM_CHARACTER_ITEM_GUILDSTORE_RESULT";
	// 2012-12-17 by bckim, â  ̵  ߰α.End 
	// 2012-12-20 by bckim, ʱȭ â 忡 Ű  α
	case T1_FL_LOG_ITEM_INITIALIZED_GUILD_STORE:		return "T1_FL_LOG_ITEM_INITIALIZED_GUILD_STORE";
	// 2012-12-20 by bckim, ʱȭ â 忡 Ű  α.End
	// 2012-12-27 by bckim, ϰ,  ɸͰ  ̵ α߰
	case T1_FL_LOG_ITEM_GET_WITH_SAME_ACCOUNT:			return "T1_FL_LOG_ITEM_GET_WITH_SAME_ACCOUNT";
	// 2012-12-27 by bckim, ϰ,  ɸͰ  ̵ α߰.End

	case T1_FL_LOG_ITEM_SELL_ITEM:						return "T1_FL_LOG_ITEM_SELL_ITEM";
	case T1_FL_LOG_ITEM_USE_ITEM:						return "T1_FL_LOG_ITEM_USE_ITEM";
	case T1_FL_LOG_ITEM_USE_ENERGY:						return "T1_FL_LOG_ITEM_USE_ENERGY";
	case T1_FL_LOG_ITEM_USE_ENCHANT:					return "T1_FL_LOG_ITEM_USE_ENCHANT";
	case T1_FL_LOG_ITEM_ADD_ITEM_BY_ADMIN:				return "T1_FL_LOG_ITEM_ADD_ITEM_BY_ADMIN";
	case T1_FL_LOG_ITEM_DEL_ITEM_BY_ADMIN:				return "T1_FL_LOG_ITEM_DEL_ITEM_BY_ADMIN";
	case T1_FL_LOG_ITEM_ADD_ITEM_BY_COMMAND:			return "T1_FL_LOG_ITEM_ADD_ITEM_BY_COMMAND";
	case T1_FL_LOG_ITEM_INSERT_TO_STORE:				return "T1_FL_LOG_ITEM_INSERT_TO_STORE";
	case T1_FL_LOG_ITEM_DRAW_FROM_STORE:				return "T1_FL_LOG_ITEM_DRAW_FROM_STORE";
	case T1_FL_LOG_ITEM_STORE_ITEM:						return "T1_FL_LOG_ITEM_STORE_ITEM";
	case T1_FL_LOG_ITEM_USE_MIX:						return "T1_FL_LOG_ITEM_USE_MIX";
	case T1_FL_LOG_ITEM_USE_CHANGE_CHARACTER_NAME_ORIGIN:	return "T1_FL_LOG_ITEM_USE_CHANGE_CHARACTER_NAME_ORIGIN";
	case T1_FL_LOG_ITEM_USE_CHANGE_CHARACTER_NAME_NEW:		return "T1_FL_LOG_ITEM_USE_CHANGE_CHARACTER_NAME_NEW";
	case T1_FL_LOG_ITEM_BAZAAR_SEND:				return "T1_FL_LOG_ITEM_BAZAAR_SEND";
	case T1_FL_LOG_ITEM_BAZAAR_RECV:				return "T1_FL_LOG_ITEM_BAZAAR_RECV";
	case T1_FL_LOG_ITEM_INSERT_TO_GUILDSTORE:		return "T1_FL_LOG_ITEM_INSERT_TO_GUILDSTORE";		// 2006-09-28 by cmkwon
	case T1_FL_LOG_ITEM_DRAW_FROM_GUILDSTORE:		return "T1_FL_LOG_ITEM_DRAW_FROM_GUILDSTORE";		// 2006-09-28 by cmkwon
	case T1_FL_LOG_ITEM_SPI:						return "T1_FL_LOG_ITEM_SPI";						// 2006-10-27 by cmkwon
	case T1_FL_LOG_ITEM_GET_ITEM_BY_ITEMEVENT:		return "T1_FL_LOG_ITEM_GET_ITEM_BY_ITEMEVENT";		// 2007-01-11 by cmkwon
	case T1_FL_LOG_WARPOINT:						return "T1_FL_LOG_WARPOINT";						// 2007-05-15 by dhjin

	case T1_FL_LOG_ARENA_TEAM_MATCH:				return "T1_FL_LOG_ARENA_TEAM_MATCH";				// 2007-06-11 by dhjin
	case T1_FL_LOG_TUTORIAL_COMPLETION:				return "T1_FL_LOG_TUTORIAL_COMPLETION";				// 60 - Tutorial, 2007-07-06 by dhjin

	case T1_FL_LOG_OUTPOST_START:					return "T1_FL_LOG_OUTPOST_START";					// 61 - OutPost α, 2007-10-02 by dhjin
	case T1_FL_LOG_OUTPOST_END:						return "T1_FL_LOG_OUTPOST_END";						// 62 - OutPost α, 2007-10-02 by dhjin
	case T1_FL_LOG_EXPEDIENCYFUND:					return "T1_FL_LOG_EXPEDIENCYFUND";					// 63 - ǰ / α, 2007-10-02 by dhjin

	case T1_FL_LOG_SERVER_INFO_MAP:						return "T1_FL_LOG_SERVER_INFO_MAP";
	case T1_FL_LOG_SERVER_INFO_TOTAL:					return "T1_FL_LOG_SERVER_INFO_TOTAL";
	case T1_FL_LOG_HACKING_LOG:							return "T1_FL_LOG_HACKING_LOG";

	case T1_FL_LOG_MONSTER_BOSS:						return "T1_FL_LOG_MONSTER_BOSS";
	case T1_FL_LOG_START_FIELD_SERVER:					return "T1_FL_LOG_START_FIELD_SERVER";

	case T1_FL_LOG_SERVER_INTEGRAION:					return "T1_FL_LOG_SERVER_INTEGRAION";			// 2007-01-26 by cmkwon
	case T1_FL_LOG_SERVER_INTEGRAION_GUILD_STORE_ITEMS:	return "T1_FL_LOG_SERVER_INTEGRAION_GUILD_STORE_ITEMS";	// 2007-02-15 by cmkwon
	case T1_FL_LOG_SERVER_INTEGRAION_ONLY_CASH_STORE_ITEMS:	return "T1_FL_LOG_SERVER_INTEGRAION_ONLY_CASH_STORE_ITEMS";	// 2008-02-28 by cmkwon,    ĳ ۸ ̵ϴ ν

	case T1_FL_LOG_INFLWAR_START:						return "T1_FL_LOG_INFLWAR_START";					// 2007-10-16 by cmkwon, α ߰ -
	case T1_FL_LOG_INFLWAR_END:							return "T1_FL_LOG_INFLWAR_END";						// 2007-10-16 by cmkwon, α ߰ -
	case T1_FL_LOG_OUTPOSTWAR_RESET_START:				return "T1_FL_LOG_OUTPOSTWAR_RESET_START";			// 2007-10-16 by cmkwon, α ߰ -
	case T1_FL_LOG_OUTPOSTWAR_RESET_DESTROY:			return "T1_FL_LOG_OUTPOSTWAR_RESET_DESTROY";		// 2007-10-16 by cmkwon, α ߰ -
	case T1_FL_LOG_OUTPOSTWAR_RESET_COMPLETE:			return "T1_FL_LOG_OUTPOSTWAR_RESET_COMPLETE";		// 2007-10-16 by cmkwon, α ߰ -
	case T1_FL_LOG_OUTPOSTWAR_PROTECTOR_DESTROY:		return "T1_FL_LOG_OUTPOSTWAR_PROTECTOR_DESTROY";	// 2007-10-16 by cmkwon, α ߰ -
	case T1_FL_LOG_OUTPOSTWAR_SET_NEXTTIME:				return "T1_FL_LOG_OUTPOSTWAR_SET_NEXTTIME";			// 2007-10-16 by cmkwon, α ߰ -


	case T1_FL_LOG_POLL_VOTE:							return "T1_FL_LOG_POLL_VOTE";
	case T1_FL_LOG_POLL_DELETE_LEADERCANDIDATE:			return "T1_FL_LOG_POLL_DELETE_LEADERCANDIDATE";

	case T1_FL_LOG_DISMEMBER_GUILD:						return "T1_FL_LOG_DISMEMBER_GUILD";
	case T1_FL_LOG_NOTIFY_MSG_DELETE:					return "T1_FL_LOG_NOTIFY_MSG_DELETE";		// 2007-11-28 by cmkwon, ý  -
	case T1_FL_LOG_USE_COUPON:							return "T1_FL_LOG_USE_COUPON";				// 2008-01-23 by cmkwon, S_F, S_L:    α׿ ߰ - 
		
	case T1_FL_LOG_ITEM_GIFT_SEND:						return "T1_FL_LOG_ITEM_GIFT_SEND";			// 2007-11-13 by cmkwon, ϱ  ߰ - 
	case T1_FL_LOG_ITEM_GIFT_RECV:						return "T1_FL_LOG_ITEM_GIFT_RECV";			// 2007-11-13 by cmkwon, ϱ  ߰ - 
	case T1_FL_LOG_ITEM_REARRANGE_DELETE_ITEM:			return "T1_FL_LOG_ITEM_REARRANGE_DELETE_ITEM";	// 2007-11-29 by cmkwon, īͺ   α  - 
	case T1_FL_LOG_ITEM_REARRANGE_ITEM:					return "T1_FL_LOG_ITEM_REARRANGE_ITEM";			// 2007-11-29 by cmkwon, īͺ   α  - 
	case T1_FL_LOG_ITEM_ATTACH_ITEM:					return "T1_FL_LOG_ITEM_ATTACH_ITEM";			// 2008-01-23 by cmkwon, S_F, S_L: /  α׿ ߰ - 
	case T1_FL_LOG_ITEM_DETACH_ITEM:					return "T1_FL_LOG_ITEM_DETACH_ITEM";			// 2008-01-23 by cmkwon, S_F, S_L: /  α׿ ߰ - 
	case T1_FL_LOG_ITEM_DELETE:							return "T1_FL_LOG_ITEM_DELETE";					// 2008-01-23 by cmkwon, S_F, S_L: /  α׿ ߰ - 

	case T1_FL_LOG_LUCKY_DROP:							return "T1_FL_LOG_LUCKY_DROP";					// 2009-03-31 by dhjin, Űӽ α

	case T1_FL_LOG_BLOCK_ACCOUNT:						return "T1_FL_LOG_BLOCK_ACCOUNT";				// 2008-01-30 by cmkwon,   α   - 
	case T1_FL_LOG_UNBLOCK_ACCOUNT:						return "T1_FL_LOG_UNBLOCK_ACCOUNT";				// 2008-01-30 by cmkwon,   α   - 

	case T1_FL_LOG_WAR_CONTRIBUTION:					return "T1_FL_LOG_WAR_CONTRIBUTION";			// 2008-12-29 by dhjin,   ߰
	case T1_FL_LOG_WAR_CONTRIBUTION_GEAR:				return "T1_FL_LOG_WAR_CONTRIBUTION_GEAR";		// 2008-12-29 by dhjin,   ߰
	
	case T1_FL_LOG_INFINITY_START:						return "T1_FL_LOG_INFINITY_START";	// 193 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,    
	case T1_FL_LOG_INFINITY_START_ITEM:					return "T1_FL_LOG_INFINITY_START_ITEM";	// 194 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰, ۽   
	case T1_FL_LOG_INFINITY_CINEMA:						return "T1_FL_LOG_INFINITY_CINEMA";	// 195 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  α
	case T1_FL_LOG_MONSTER_SKILL:						return "T1_FL_LOG_MONSTER_SKILL";	// 196 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ų 
	case T1_FL_LOG_HPACTION_TALK:						return "T1_FL_LOG_HPACTION_TALK";	// 197 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ȭ 
	case T1_FL_LOG_INFINITY_FIN:						return "T1_FL_LOG_INFINITY_FIN";	// 198 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,    
	case T1_FL_LOG_INFINITY_FIN_ITEM:					return "T1_FL_LOG_INFINITY_FIN_ITEM";	// 199 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,    
	case T1_FL_LOG_INFINITY_FIN_ALIVE_KEY_MONSTER:		return "T1_FL_LOG_INFINITY_FIN_ALIVE_KEY_MONSTER";	// 200 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  ִ  	
	case T1_FL_LOG_INFINITY_LEAVE_ITEM:					return "T1_FL_LOG_INFINITY_LEAVE_ITEM";	// 201 - // 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ӷα ߰,  Ż   
	case T1_FL_LOG_PET_LEVEL:							return "T1_FL_LOG_PET_LEVEL"; // 213 - // 2011-09-15 by hskim, Ʈ ý 2 - Ʈ  
	case T1_FL_LOG_CONNECT_USER_NEW:					return "T1_FL_LOG_CONNECT_USER_NEW";	// 214 - // 2012-01-08 by hskim, GLog 2 -  ű 
	case T1_FL_LOG_CONNECT_USER_LOGIN:					return "T1_FL_LOG_CONNECT_USER_LOGIN";	// 214 - // 2012-01-08 by hskim, GLog 2 -  
	}

	return "UNKNOWN_GAME_LOG_TYPE";
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			const char* GetItemUpdateTypeString(BYTE i_byItemUpdateTy)
/// \brief		
/// \author		cmkwon
/// \date		2006-10-27 ~ 2006-10-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
const char* GetItemUpdateTypeString(BYTE i_byItemUpdateTy)
{
	switch(i_byItemUpdateTy)
	{
	case IUT_GENERAL:						return "IUT_GENERAL";
	case IUT_DROP_ITEM:						return "IUT_DROP_ITEM";
	case IUT_MIXING:						return "IUT_MIXING";
	case IUT_TRADE:							return "IUT_TRADE";
	case IUT_SHOP:							return "IUT_SHOP";
	case IUT_QUEST:							return "IUT_QUEST";
	case IUT_ADMIN:							return "IUT_ADMIN";
	case IUT_BULLET:						return "IUT_BULLET";
	case IUT_SKILL:							return "IUT_SKILL";
	case IUT_LOADING:						return "IUT_LOADING";
	case IUT_AUCTION:						return "IUT_AUCTION";
	case IUT_ENCHANT:						return "IUT_ENCHANT";
	case IUT_USE_ITEM:						return "IUT_USE_ITEM";
	case IUT_MGAME_EVENT:					return "IUT_MGAME_EVENT";
	case IUT_USE_ENERGY:					return "IUT_USE_ENERGY";
	case IUT_EXPIRE_CARD_ITEM:				return "IUT_EXPIRE_CARD_ITEM";
	case IUT_PENALTY_ON_DEAD:				return "IUT_PENALTY_ON_DEAD";
	case IUT_PENALTY_AGEAR_FUEL_ALLIN:		return "IUT_PENALTY_AGEAR_FUEL_ALLIN";
	case IUT_INFLUENCEWAR_KILLER_BONUS:		return "IUT_INFLUENCEWAR_KILLER_BONUS";
	case IUT_BONUS_ITEM:					return "IUT_BONUS_ITEM";
	case IUT_BAZAAR_SELL:					return "IUT_BAZAAR_SELL";
	case IUT_BAZAAR_BUY:					return "IUT_BAZAAR_BUY";
	case IUT_RANDOMBOX:						return "IUT_RANDOMBOX";
	case IUT_GIVEEVENTITEM:					return "IUT_GIVEEVENTITEM";
	case IUT_GUILD_STORE:					return "IUT_GUILD_STORE";
	case IUT_EXPIRE_ITEM:					return "IUT_EXPIRE_ITEM";
	case IUT_STORE:							return "IUT_STORE";
	case IUT_STORE_FEE:						return "IUT_STORE_FEE";
	case IUT_ARENA_ITEM:					return "IUT_ARENA_ITEM";
	case IUT_TUTORIAL_PAY_ITEM:				return "IUT_TUTORIAL_PAY_ITEM";
	case IUT_EXPEDIENCYFUND_PAYBACK:		return "IUT_EXPEDIENCYFUND_PAYBACK";
	case IUT_GIVEEVENTITEM_COUPONEVENT:		return "IUT_GIVEEVENTITEM_COUPONEVENT";		// 2008-01-10 by cmkwon,  ̺Ʈ ýۿ   ý ߰ - 
	case IUT_DEPENDENCY_ITEM:				return "IUT_DEPENDENCY_ITEM";		// 2011-09-20 by hskim, Ʈ ý 2
	case IUT_WARP:							return "IUT_WARP";							// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý -   ǿ   
	}

	return "UNKNOWN_ITEM_UPDATE_TYPE";
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			const char* GetItemDeleteTypeString(BYTE i_byItemDeleteTy)
/// \brief		// 2008-01-23 by cmkwon, S_F, S_L: /  α׿ ߰ - GetItemDeleteTypeString() ߰
/// \author		cmkwon
/// \date		2008-01-23 ~ 2008-01-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
const char* GetItemDeleteTypeString(BYTE i_byItemDeleteTy)
{
	switch(i_byItemDeleteTy)
	{
	case IDT_GENERAL:						return "IDT_GENERAL";
	case IDT_EXPIRE_TIME:					return "IDT_EXPIRE_TIME";
	case IDT_INVALID_ITEMNUM:				return "IDT_INVALID_ITEMNUM";		// 2009-11-20 by cmkwon,   ε ȿ   ó  - 
	case IDT_COUNTABLEITEM_ZERO:			return "IDT_COUNTABLEITEM_ZERO";	// 2009-11-20 by cmkwon,   ε ȿ   ó  - 
	}

	return "UNKNOWN_ITEM_DELETE_TYPE";
}

char* GetErrorString(Err_t err)
{
	switch(err)
	{
	case ERR_NO_ERROR:									return "ERR_NO_ERROR";
	case ERR_COMMON_UNKNOWN_ERROR:						return "ERR_COMMON_UNKNOWN_ERROR";
	case ERR_COMMON_LOGIN_FAILED:						return "ERR_COMMON_LOGIN_FAILED";
	case ERR_COMMON_NO_SUCH_CHARACTER:					return "ERR_COMMON_NO_SUCH_CHARACTER";
	case ERR_COMMON_CHARACTER_ALREADY_EXISTS:			return "ERR_COMMON_CHARACTER_ALREADY_EXISTS";
	case ERR_COMMON_TOO_LONG_PACKET:					return "ERR_COMMON_TOO_LONG_PACKET";
	case ERR_COMMON_SERVICE_TEMPORARILY_PAUSED:			return "ERR_COMMON_SERVICE_TEMPORARILY_PAUSED";
	case ERR_COMMON_INVALID_CLIENT_VERSION:				return "ERR_COMMON_INVALID_CLIENT_VERSION";
	case ERR_COMMON_NOT_ALLOWED_TO_MYSELF:				return "ERR_COMMON_NOT_ALLOWED_TO_MYSELF";
	case ERR_COMMON_INVALID_BUILDINGKIND:				return "ERR_COMMON_INVALID_BUILDINGKIND";
	case ERR_COMMON_NO_SUCH_BUILDINGKIND:				return "ERR_COMMON_NO_SUCH_BUILDINGKIND";
	case ERR_COMMON_BAD_NETWORK:						return "ERR_COMMON_BAD_NETWORK";
	case ERR_COMMON_CONNECTING_GAME:					return "ERR_COMMON_CONNECTING_GAME";		// 2008-11-26 by cmkwon, 븸 Netpower_Tpe   ߰ ν ߰ - 
	case ERR_COMMON_DISABLE_CONTENT:					return "ERR_COMMON_DISABLE_CONTENT";		// 2011-10-05 by hskim, Ʈ ý 2 -  OFF  ޽ 

	case ERR_DB_ACCOUNT_ALREAY_EXISTS:					return "ERR_DB_ACCOUNT_ALREAY_EXISTS";
	case ERR_DB_ACCOUNT_CHARACTER_NO_MATCH:				return "ERR_DB_ACCOUNT_CHARACTER_NO_MATCH";
	case ERR_DB_INTEGRITY_CONSTRAINT_VIOLATION:			return "ERR_DB_INTEGRITY_CONSTRAINT_VIOLATION";
	case ERR_DB_INVALID_PARAMETER:						return "ERR_DB_INVALID_PARAMETER";
	case ERR_DB_INVALID_UNIQUE_NUMBER:					return "ERR_DB_INVALID_UNIQUE_NUMBER";
	case ERR_DB_NO_SUCH_ACCOUNT:						return "ERR_DB_NO_SUCH_ACCOUNT";
	case ERR_DB_NUMERIC_VALUE_OUT_OF_RANGE:				return "ERR_DB_NUMERIC_VALUE_OUT_OF_RANGE";
	case ERR_DB_STRING_TOO_LONG:						return "ERR_DB_STRING_TOO_LONG";
	case ERR_DB_NO_SUCH_STORE_ITEM:						return "ERR_DB_NO_SUCH_STORE_ITEM";
	case ERR_DB_CANNOT_INSERT_DEFAULT_ITEMS:			return "ERR_DB_CANNOT_INSERT_DEFAULT_ITEMS";
	case ERR_DB_CONNECTION_ERROR:						return "ERR_DB_CONNECTION_ERROR";
	case ERR_DB_EXECUTION_FAILED:						return "ERR_DB_EXECUTION_FAILED";
	case ERR_DB_NO_SUCH_DATA:							return "ERR_DB_NO_SUCH_DATA";		// 2008-06-12 by dhjin, EP3 Ÿ     ߰
	case ERR_DB_INSERT_QUERY_ERROR:						return "ERR_DB_INSERT_QUERY_ERROR";		// 2008-11-26 by cmkwon, 븸 Netpower_Tpe   ߰ ν ߰ - 

	case ERR_PROTOCOL_INVALID_PROTOCOL_TYPE:			return "ERR_PROTOCOL_INVALID_PROTOCOL_TYPE";
	case ERR_PROTOCOL_INVALID_FIELD_DATA:				return "ERR_PROTOCOL_INVALID_FIELD_DATA";
	case ERR_PROTOCOL_INVALID_ACCOUNT_UNIQUENUMBER:		return "ERR_PROTOCOL_INVALID_ACCOUNT_UNIQUENUMBER";
	case ERR_PROTOCOL_INVALID_CHARACTER_UNIQUENUMBER:	return "ERR_PROTOCOL_INVALID_CHARACTER_UNIQUENUMBER";
	case ERR_PROTOCOL_INVALID_UNITKIND:					return "ERR_PROTOCOL_INVALID_UNITKIND";
	case ERR_PROTOCOL_INVALID_CLIENTINDEX:				return "ERR_PROTOCOL_INVALID_CLIENTINDEX";
	case ERR_PROTOCOL_INVALID_PACKET:					return "ERR_PROTOCOL_INVALID_PACKET";
	case ERR_PROTOCOL_INVALID_PACKET_SIZE:				return "ERR_PROTOCOL_INVALID_PACKET_SIZE";
	case ERR_PROTOCOL_INVALID_SEQUENCE_NUMBER:			return "ERR_PROTOCOL_INVALID_SEQUENCE_NUMBER";
	case ERR_PROTOCOL_INVALID_PEER:						return "ERR_PROTOCOL_INVALID_PEER";
	case ERR_PROTOCOL_INVALID_STAT_VALUE_OR_KIND:		return "ERR_PROTOCOL_INVALID_STAT_VALUE_OR_KIND";
	case ERR_PROTOCOL_EMPTY_ACCOUNTNAME:				return "ERR_PROTOCOL_EMPTY_ACCOUNTNAME";
	case ERR_PROTOCOL_DUPLICATE_LOGIN:					return "ERR_PROTOCOL_DUPLICATE_LOGIN";
	case ERR_PROTOCOL_NOT_LOGINED:						return "ERR_PROTOCOL_NOT_LOGINED";
	case ERR_PROTOCOL_INVALID_SERVER_GROUP_NAME:		return "ERR_PROTOCOL_INVALID_SERVER_GROUP_NAME";
	case ERR_PROTOCOL_LIMIT_GROUP_USER_COUNT:			return "ERR_PROTOCOL_LIMIT_GROUP_USER_COUNT";
	case ERR_PROTOCOL_ACCOUNT_BLOCKED:					return "ERR_PROTOCOL_ACCOUNT_BLOCKED";
	case ERR_PROTOCOL_INVALID_TARGET_INDEX:				return "ERR_PROTOCOL_INVALID_TARGET_INDEX";
	case ERR_PROTOCOL_INVALID_GETCHARACTER:				return "ERR_PROTOCOL_INVALID_GETCHARACTER";
	case ERR_PROTOCOL_INVALID_CHARACTER_STATE:				return "ERR_PROTOCOL_INVALID_CHARACTER_STATE";

	case ERR_PROTOCOL_ALREADY_MAX_CHARACTER:			return "ERR_PROTOCOL_ALREADY_MAX_CHARACTER";
	case ERR_PROTOCOL_EMPTY_CHARACTERNAME:				return "ERR_PROTOCOL_EMPTY_CHARACTERNAME";
	case ERR_PROTOCOL_STATE_MINUSVALUE:					return "ERR_PROTOCOL_STATE_MINUSVALUE";
	case ERR_PROTOCOL_STATE_SUMISNOTBONUS:				return "ERR_PROTOCOL_STATE_SUMISNOTBONUS";
	case ERR_PROTOCOL_INVALID_GAMESTART:				return "ERR_PROTOCOL_INVALID_GAMESTART";
	case ERR_PROTOCOL_INVALID_SOCKET_FORNPC:			return "ERR_PROTOCOL_INVALID_SOCKET_FORNPC";
	case ERR_PROTOCOL_INVALID_CONNECT_GAMESTART:		return "ERR_PROTOCOL_INVALID_CONNECT_GAMESTART";
	case ERR_PROTOCOL_INVALID_CONNECT_WARP:				return "ERR_PROTOCOL_INVALID_CONNECT_WARP";
	case ERR_PROTOCOL_INVALID_POSITION:					return "ERR_PROTOCOL_INVALID_POSITION";
	case ERR_PROTOCOL_INVALID_GAMEEND:					return "ERR_PROTOCOL_INVALID_GAMEEND";
	case ERR_PROTOCOL_GAMESTARTROUTINE_FAILED:			return "ERR_PROTOCOL_GAMESTARTROUTINE_FAILED";
	case ERR_PROTOCOL_INVALID_CHARACTER_NAME:			return "ERR_PROTOCOL_INVALID_CHARACTER_NAME";
	case ERR_PROTOCOL_INVALID_PEER_CHARACTER:			return "ERR_PROTOCOL_INVALID_PEER_CHARACTER";
	case ERR_PROTOCOL_INVALID_AUTOSTAT_TYPE:			return "ERR_PROTOCOL_INVALID_AUTOSTAT_TYPE";
	case ERR_PROTOCOL_NOT_TUTORIAL_MAP:					return "ERR_PROTOCOL_NOT_TUTORIAL_MAP";
	case ERR_PROTOCOL_RACE_PERMISSION_DENIED:			return "ERR_PROTOCOL_RACE_PERMISSION_DENIED";
	case ERR_PROTOCOL_NOT_ENOUGH_ELAPSE_TIME:			return "ERR_PROTOCOL_NOT_ENOUGH_ELAPSE_TIME";
	case ERR_PROTOCOL_INVALID_CHARACTERNAME:			return "ERR_PROTOCOL_INVALID_CHARACTERNAME";
	case ERR_PROTOCOL_CHARACTER_MODE_NOT_MATCHED:		return "ERR_PROTOCOL_CHARACTER_MODE_NOT_MATCHED";
	case ERR_PROTOCOL_UNKNOWN_CHARACTER_ACTION_TYPE:	return "ERR_PROTOCOL_UNKNOWN_CHARACTER_ACTION_TYPE";
	case ERR_PROTOCOL_BUILDING_KIND_NOT_MATCHED:		return "ERR_PROTOCOL_BUILDING_KIND_NOT_MATCHED";

	case ERR_PROTOCOL_INVALID_BODYCONDITION:			return "ERR_PROTOCOL_INVALID_BODYCONDITION";
	case ERR_PROTOCOL_INVALID_MAP_EVENT_INFO:			return "ERR_PROTOCOL_INVALID_MAP_EVENT_INFO";
	case ERR_PROTOCOL_MAP_ALREADY_SERVED_BY_FEILD_SERVER:		return "ERR_PROTOCOL_MAP_ALREADY_SERVED_BY_FEILD_SERVER";
	case ERR_PROTOCOL_NO_SUCH_FIELD_SERVER:				return "ERR_PROTOCOL_NO_SUCH_FIELD_SERVER";
	case ERR_PROTOCOL_NO_SUCH_MAP_SERVED:				return "ERR_PROTOCOL_NO_SUCH_MAP_SERVED";
	case ERR_PROTOCOL_NO_SUCH_CHANNEL:					return "ERR_PROTOCOL_NO_SUCH_CHANNEL";
	case ERR_PROTOCOL_MAP_CHANNEL_NOT_MATCHED:			return "ERR_PROTOCOL_MAP_CHANNEL_NOT_MATCHED";
	case ERR_PROTOCOL_CANNOT_WARP:						return "ERR_PROTOCOL_CANNOT_WARP";
	case ERR_PROTOCOL_CANNOT_WARP_INVALID_STATE:		return "ERR_PROTOCOL_CANNOT_WARP_INVALID_STATE";
	case ERR_PROTOCOL_DOING_WARP:		return "ERR_PROTOCOL_DOING_WARP";

	case ERR_PROTOCOL_INVALID_FIELDSERVER_CLIENT_STATE:		return "ERR_PROTOCOL_INVALID_FIELDSERVER_CLIENT_STATE";
	case ERR_PROTOCOL_INVALID_PRESERVER_CLIENT_STATE:	return "ERR_PROTOCOL_INVALID_PRESERVER_CLIENT_STATE";
	case ERR_PROTOCOL_NO_SUCH_SERVER_GROUP:				return "ERR_PROTOCOL_NO_SUCH_SERVER_GROUP";
	case ERR_PROTOCOL_FIELD_SERVER_ALREADY_REGISTERD:	return "ERR_PROTOCOL_FIELD_SERVER_ALREADY_REGISTERD";
	case ERR_PROTOCOL_FIELD_SERVER_ID_NOT_MATCHED:		return "ERR_PROTOCOL_FIELD_SERVER_ID_NOT_MATCHED";
	case ERR_PROTOCOL_ALL_FIELD_SERVER_NOT_ALIVE:		return "ERR_PROTOCOL_ALL_FIELD_SERVER_NOT_ALIVE";
	case ERR_PROTOCOL_NO_SUCH_SHOP:						return "ERR_PROTOCOL_NO_SUCH_SHOP";
	case ERR_PROTOCOL_NO_SUCH_SHOP_ITEM:				return "ERR_PROTOCOL_NO_SUCH_SHOP_ITEM";
	case ERR_PROTOCOL_NOT_ENOUGH_MONEY:					return "ERR_PROTOCOL_NOT_ENOUGH_MONEY";
	case ERR_PROTOCOL_ITEM_KIND_NOT_MATCHED:			return "ERR_PROTOCOL_ITEM_KIND_NOT_MATCHED";
	case ERR_PROTOCOL_NO_SUCH_ITEM:						return "ERR_PROTOCOL_NO_SUCH_ITEM";
	case ERR_PROTOCOL_ITEM_AMOUNT_EXCEED:				return "ERR_PROTOCOL_ITEM_AMOUNT_EXCEED";
	case ERR_PROTOCOL_CLIENT_IP_NOT_MATCHED:			return "ERR_PROTOCOL_CLIENT_IP_NOT_MATCHED";
	case ERR_PROTOCOL_IMSERVER_ALREADY_CONNECTED:		return "ERR_PROTOCOL_IMSERVER_ALREADY_CONNECTED";
	case ERR_PROTOCOL_GENERAL_ITEM_ERROR:				return "ERR_PROTOCOL_GENERAL_ITEM_ERROR";
	case ERR_PROTOCOL_IM_SERVER_NOT_ALIVE:				return "ERR_PROTOCOL_IM_SERVER_NOT_ALIVE";
	case ERR_PROTOCOL_PARTY_MASTER_NOT_MATCHED:			return "ERR_PROTOCOL_PARTY_MASTER_NOT_MATCHED";
	case ERR_PROTOCOL_NO_SUCH_PARTY_MEMBER:				return "ERR_PROTOCOL_NO_SUCH_PARTY_MEMBER";
	case ERR_PROTOCOL_PARTY_PERMISSION_DENIED:			return "ERR_PROTOCOL_PARTY_PERMISSION_DENIED";
	case ERR_PROTOCOL_PARTY_MEMBER_ALREADY_EXISTS:		return "ERR_PROTOCOL_PARTY_MEMBER_ALREADY_EXISTS";
	case ERR_PROTOCOL_NO_SUCH_PARTY:					return "ERR_PROTOCOL_NO_SUCH_PARTY";
	case ERR_PROTOCOL_CANNOT_INVITE_USER:				return "ERR_PROTOCOL_CANNOT_INVITE_USER";
	case ERR_PROTOCOL_GET_MEMBER_FAIL:					return "ERR_PROTOCOL_GET_MEMBER_FAIL";
	case ERR_PROTOCOL_PARTY_ID_NOT_MATCHED:				return "ERR_PROTOCOL_PARTY_ID_NOT_MATCHED";
	case ERR_PROTOCOL_ALREADY_MAX_PARTY_MEMBER:			return "ERR_PROTOCOL_ALREADY_MAX_PARTY_MEMBER";
	case ERR_PROTOCOL_ALREADY_PARTY_BATTLE:				return "ERR_PROTOCOL_ALREADY_PARTY_BATTLE";
	case ERR_PROTOCOL_ALREADY_REQUESTING_PARTY_BATTLE:	return "ERR_PROTOCOL_ALREADY_REQUESTING_PARTY_BATTLE";
	case ERR_PROTOCOL_DOING_PARTY_BATTLE:				return "ERR_PROTOCOL_DOING_PARTY_BATTLE";
	case ERR_PROTOCOL_IMPOSSIBLE_IN_PARTY:				return "ERR_PROTOCOL_IMPOSSIBLE_IN_PARTY";

	case ERR_PROTOCOL_NOT_ENOUGH_PARTY_MEMBER:			return "ERR_PROTOCOL_NOT_ENOUGH_PARTY_MEMBER";
	case ERR_PROTOCOL_GUILD_NAME_ALREADY_EXISTS:		return "ERR_PROTOCOL_GUILD_NAME_ALREADY_EXISTS";
	case ERR_PROTOCOL_GUILD_MEMBER_ALREADY_EXISTS:		return "ERR_PROTOCOL_GUILD_MEMBER_ALREADY_EXISTS";
	case ERR_PROTOCOL_GUILD_PERMISSION_DENIED:			return "ERR_PROTOCOL_GUILD_PERMISSION_DENIED";
	case ERR_PROTOCOL_NOT_HAVE_GUILD:					return "ERR_PROTOCOL_NOT_HAVE_GUILD";
	case ERR_PROTOCOL_GUILD_NOT_MATCHED:				return "ERR_PROTOCOL_GUILD_NOT_MATCHED";
	case ERR_PROTOCOL_NO_SUCH_GUILD_MEMBER:				return "ERR_PROTOCOL_NO_SUCH_GUILD_MEMBER";
	case ERR_PROTOCOL_NOT_HAVE_PARTY:					return "ERR_PROTOCOL_NOT_HAVE_PARTY";
	case ERR_PROTOCOL_NO_SUCH_GUILD:					return "ERR_PROTOCOL_NO_SUCH_GUILD";
	case ERR_PROTOCOL_NOT_GUILD_MASTER:					return "ERR_PROTOCOL_NOT_GUILD_MASTER";
	case ERR_PROTOCOL_GUILD_CARD_ALREADY_USING:			return "ERR_PROTOCOL_GUILD_CARD_ALREADY_USING";
	case ERR_PROTOCOL_INVLID_GUILDNAME:					return "ERR_PROTOCOL_INVLID_GUILDNAME";
	case ERR_PROTOCOL_NOT_GET_GUILDSTORE_MEMBER:		return "ERR_PROTOCOL_NOT_GET_GUILDSTORE_MEMBER";
	case ERR_PROTOCOL_DOING_GUILDWAR_BATTLE:			return "ERR_PROTOCOL_DOING_GUILDWAR_BATTLE";
	case ERR_PROTOCOL_INVLID_GuildMarkSize:				return "ERR_PROTOCOL_INVLID_GuildMarkSize";			// 2007-08-02 by cmkwon,  ũ ɻ ý  - ܸũ  
	case ERR_PROTOCOL_OVER_MEMBERCOUNT:					return "ERR_PROTOCOL_OVER_MEMBERCOUNT";		// 2008-05-27 by dhjin, EP3    - ܿ  ĳ , ִ ܿ  ѱ

	case ERR_PROTOCOL_TOO_FAR_TO_TRADE:					return "ERR_PROTOCOL_TOO_FAR_TO_TRADE";
	case ERR_PROTOCOL_ALREADY_TRADING:					return "ERR_PROTOCOL_ALREADY_TRADING";
	case ERR_PROTOCOL_PEER_TRADER_NOT_MATCHED:			return "ERR_PROTOCOL_PEER_TRADER_NOT_MATCHED";
	case ERR_PROTOCOL_TRADE_NOT_STARTED:				return "ERR_PROTOCOL_TRADE_NOT_STARTED";
	case ERR_PROTOCOL_INVALID_ITEMNUM:					return "ERR_PROTOCOL_INVALID_ITEMNUM";
	case ERR_PROTOCOL_INVALID_ITEM_COUNT:				return "ERR_PROTOCOL_INVALID_ITEM_COUNT";
	case ERR_PROTOCOL_TRADE_ERROR:						return "ERR_PROTOCOL_TRADE_ERROR";
	case ERR_PROTOCOL_INVALID_ITEM_KIND:				return "ERR_PROTOCOL_INVALID_ITEM_KIND";
	case ERR_PROTOCOL_MIN_TRADE_QUANTITY_ERROR:			return "ERR_PROTOCOL_MIN_TRADE_QUANTITY_ERROR";
	case ERR_PROTOCOL_ALREADY_TRADE_ITEM:				return "ERR_PROTOCOL_ALREADY_TRADE_ITEM";
	case ERR_PROTOCOL_NO_SUCH_SKILL:					return "ERR_PROTOCOL_NO_SUCH_SKILL";
	case ERR_PROTOCOL_CANNOT_USE_SKILL:					return "ERR_PROTOCOL_CANNOT_USE_SKILL";
	case ERR_PROTOCOL_INVALID_SKILLTYPE:				return "ERR_PROTOCOL_INVALID_SKILLTYPE";
	case ERR_PROTOCOL_NOT_ENOUGH_SP:					return "ERR_PROTOCOL_NOT_ENOUGH_SP";
	case ERR_PROTOCOL_NO_SUCH_TIME_LIMIT_EVENT_IN_BUCKET:		return "ERR_PROTOCOL_NO_SUCH_TIME_LIMIT_EVENT_IN_BUCKET";
	case ERR_PROTOCOL_NO_SUCH_TIMER_EVENT_TYPE:			return "ERR_PROTOCOL_NO_SUCH_TIMER_EVENT_TYPE";
	case ERR_PROTOCOL_ALREADY_MAX_ENCHANT_PER_ITEM:		return "ERR_PROTOCOL_ALREADY_MAX_ENCHANT_PER_ITEM";
	case ERR_PROTOCOL_ALREADY_HAVE_RARE_FIX:			return "ERR_PROTOCOL_ALREADY_HAVE_RARE_FIX";
	case ERR_PROTOCOL_ALREADY_INITIALIZE_RARE_FIX:		return "ERR_PROTOCOL_ALREADY_INITIALIZE_RARE_FIX";
	case ERR_PROTOCOL_CANNOT_USE_ITEMKIND_PREVENTION_DELETE_ITEM:	return "ERR_PROTOCOL_CANNOT_USE_ITEMKIND_PREVENTION_DELETE_ITEM";
	case ERR_PROTOCOL_CANNOT_USE_ITEMKIND_PREVENTION_DELETE_ITEM_BY_STARTCOUNT:	return "ERR_PROTOCOL_CANNOT_USE_ITEMKIND_PREVENTION_DELETE_ITEM_BY_STARTCOUNT";	// 2009-01-19 by dhjin, þƮ Ȯ , 10þ Ĺ ī

	case ERR_PROTOCOL_NOT_ENOUGH_EP:					return "ERR_PROTOCOL_NOT_ENOUGH_EP";
	case ERR_PROTOCOL_TOO_LONG_DISTANCE:				return "ERR_PROTOCOL_TOO_LONG_DISTANCE";
	case ERR_PROTOCOL_ALREADY_P2P_PK:					return "ERR_PROTOCOL_ALREADY_P2P_PK";
	case ERR_PROTOCOL_TOO_FAR_TO_P2P_PK:				return "ERR_PROTOCOL_TOO_FAR_TO_P2P_PK";
	case ERR_PROTOCOL_HIGH_LEVEL_GAP_TO_P2P_PK:			return "ERR_PROTOCOL_HIGH_LEVEL_GAP_TO_P2P_PK";
	case ERR_PROTOCOL_NOT_DOING_P2P_PK:					return "ERR_PROTOCOL_NOT_DOING_P2P_PK";
	case ERR_PROTOCOL_NOT_ALLOWED_ATTACK:				return "ERR_PROTOCOL_NOT_ALLOWED_ATTACK";
	case ERR_PROTOCOL_CANNOT_USE_ITEM:					return "ERR_PROTOCOL_CANNOT_USE_ITEM";
	case ERR_PROTOCOL_ALREADY_HAVE_ITEM:				return "ERR_PROTOCOL_ALREADY_HAVE_ITEM";
	case ERR_PROTOCOL_ALREADY_HAVE_SKILL:				return "ERR_PROTOCOL_ALREADY_HAVE_SKILL";
	case ERR_PROTOCOL_INVALID_ITEM_WINDOW_POSITION:		return "ERR_PROTOCOL_INVALID_ITEM_WINDOW_POSITION";
	case ERR_PROTOCOL_ALREADY_ITEM_ACTIVATED:			return "ERR_PROTOCOL_ALREADY_ITEM_ACTIVATED";
	case ERR_PROTOCOL_NO_SUCH_DES_PARAM:				return "ERR_PROTOCOL_NO_SUCH_DES_PARAM";
	case ERR_PROTOCOL_NOT_ENOUGH_BULLET:				return "ERR_PROTOCOL_NOT_ENOUGH_BULLET";
	case ERR_PROTOCOL_ITEM_CANNOT_TRANSFER:				return "ERR_PROTOCOL_ITEM_CANNOT_TRANSFER";
	case ERR_PROTOCOL_NO_SUCH_MIXING_INFO:				return "ERR_PROTOCOL_NO_SUCH_MIXING_INFO";
	case ERR_PROTOCOL_ITEM_OVER_WEIGHT:					return "ERR_PROTOCOL_ITEM_OVER_WEIGHT";
	case ERR_PROTOCOL_DO_NOT_HAVE_LINK_ITEM:			return "ERR_PROTOCOL_DO_NOT_HAVE_LINK_ITEM";
	case ERR_PROTOCOL_INVENTORY_FULL_ITEM:				return "ERR_PROTOCOL_INVENTORY_FULL_ITEM";
	case ERR_PROTOCOL_STORE_FULL_ITEM:					return "ERR_PROTOCOL_STORE_FULL_ITEM";
	case ERR_PROTOCOL_ALREADY_USE_ITEM:					return "ERR_PROTOCOL_ALREADY_USE_ITEM";
	case ERR_PROTOCOL_ALREADY_USE_OTHER_ITEM:			return "ERR_PROTOCOL_ALREADY_USE_OTHER_ITEM";
	case ERR_PROTOCOL_STAT_ERROR_STATE:					return "ERR_PROTOCOL_STAT_ERROR_STATE";
	case ERR_PROTOCOL_STAT_INITIALIZE_STATE:			return "ERR_PROTOCOL_STAT_INITIALIZE_STATE";
	case ERR_PROTOCOL_AREADY_USING_HP_UP_ITEM:			return "ERR_PROTOCOL_AREADY_USING_HP_UP_ITEM";
	case ERR_PROTOCOL_AREADY_USING_DP_UP_ITEM:			return "ERR_PROTOCOL_AREADY_USING_DP_UP_ITEM";
	case ERR_PROTOCOL_AREADY_USING_SP_UP_ITEM:			return "ERR_PROTOCOL_AREADY_USING_SP_UP_ITEM";
	case ERR_PROTOCOL_AREADY_USING_EP_UP_ITEM:			return "ERR_PROTOCOL_AREADY_USING_EP_UP_ITEM";
	case ERR_PROTOCOL_AREADY_FULL_HP:					return "ERR_PROTOCOL_AREADY_FULL_HP";
	case ERR_PROTOCOL_AREADY_FULL_DP:					return "ERR_PROTOCOL_AREADY_FULL_DP";
	case ERR_PROTOCOL_AREADY_FULL_SP:					return "ERR_PROTOCOL_AREADY_FULL_SP";
	case ERR_PROTOCOL_AREADY_FULL_EP:					return "ERR_PROTOCOL_AREADY_FULL_EP";
	case ERR_PROTOCOL_CANNOT_USEITEM_IN_PARTY:			return "ERR_PROTOCOL_CANNOT_USEITEM_IN_PARTY";
	case ERR_PROTOCOL_CANNOT_IN_CITY_MAP_CHANNEL:		return "ERR_PROTOCOL_CANNOT_IN_CITY_MAP_CHANNEL";
	case ERR_PROTOCOL_CHANNEL_USER_OVERFLOW:			return "ERR_PROTOCOL_CHANNEL_USER_OVERFLOW";
	case ERR_PROTOCOL_NO_SUCH_EVENT_AREA_INDEX:			return "ERR_PROTOCOL_NO_SUCH_EVENT_AREA_INDEX";
	case ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER:				return "ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER";
	case ERR_PROTOCOL_NOTIFY_MAX_ITEM_COUNTS_OVER:		return "ERR_PROTOCOL_NOTIFY_MAX_ITEM_COUNTS_OVER";
	case ERR_PROTOCOL_CANNOT_UNWEAR_ARMOR:				return "ERR_PROTOCOL_CANNOT_UNWEAR_ARMOR";
	case ERR_PROTOCOL_NO_SUCH_BULLET_ITEM:				return "ERR_PROTOCOL_NO_SUCH_BULLET_ITEM";
	case ERR_PROTOCOL_CANNOT_ENCHANT_ITEM:				return "ERR_PROTOCOL_CANNOT_ENCHANT_ITEM";
	case ERR_PROTOCOL_BAZAAR_NO_SUCH_ITEM:				return "ERR_PROTOCOL_BAZAAR_NO_SUCH_ITEM";
	case ERR_PROTOCOL_GUILD_STORE_FULL_ITEM:			return "ERR_PROTOCOL_GUILD_STORE_FULL_ITEM";
	case ERR_PROTOCOL_CANNOT_USE_ITEM_IN_ARENA:			return "ERR_PROTOCOL_CANNOT_USE_ITEM_IN_ARENA";
	case ERR_PROTOCOL_INVALID_MIXING_INFO:				return "ERR_PROTOCOL_INVALID_MIXING_INFO";		// 2009-10-01 by cmkwon, ׷ ҽ   ʱȭ   - 
	case ERR_PROTOCOL_NOT_WEARING_STATE:				return "ERR_PROTOCOL_NOT_WEARING_STATE";			// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ,  ° ƴϴ. 
	case ERR_PROTOCOL_INVALID_INVOKING_TYPE:			return "ERR_PROTOCOL_INVALID_INVOKING_TYPE";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, ߵ Ÿ 
	case ERR_PROTOCOL_FAIL_INVOKING_BY_RATE:			return "ERR_PROTOCOL_FAIL_INVOKING_BY_RATE";		// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, ߵ ̽
	case ERR_PROTOCOL_FAIL_INVOKING_BY_REQITEMNUM:		return "ERR_PROTOCOL_FAIL_INVOKING_BY_REQITEMNUM";	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, ߵ   
	case ERR_PROTOCOL_COOLING_TIME_INVOKING_ITEM:		return "ERR_PROTOCOL_COOLING_TIME_INVOKING_ITEM";	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, ߵ  Ÿ
	case ERR_PROTOCOL_CANNOT_RARE_ITEM:					return "ERR_PROTOCOL_CANNOT_RARE_ITEM";	// 2009-09-09 ~ 2010-02-10 by dhjin, ǴƼ - ߵ, ߵ  Ÿ
	case ERR_PROTOCOL_NOT_ACTIVATED_ITEM:				return "ERR_PROTOCOL_NOT_ACTIVATED_ITEM";			// 2011-09-20 by hskim, Ʈ ý 2 - Ȱȭ   
	case ERR_PROTOCOL_CANNOT_ATTACHED_ITEM:				return "ERR_PROTOCOL_CANNOT_ATTACHED_ITEM";			// 2011-09-20 by hskim, Ʈ ý 2 -   
	case ERR_PROTOCOL_CANNOT_ENCHANT_MORE_THEN_10:			return "ERR_PROTOCOL_CANNOT_ENCHANT_MORE_THEN_10";		// 2011-10-19 by hskim, EP4 [Free to play] - 10 ȸ þƮ    - 10 æƮ ̻  ȭ  
	case ERR_PROTOCOL_CANNOT_ENCHANT_DIFFERENCE_ATTRIBUTE:	return "ERR_PROTOCOL_CANNOT_ENCHANT_DIFFERENCE_ATTRIBUTE";		// 2011-10-19 by hskim, EP4 [Free to play] - 10 ȸ þƮ    - æƮ Ӽ Ʋ æƮ   
	case ERR_PROTOCOL_CANNOT_ENCHANT_LACK_REQUIREMENT:		return "ERR_PROTOCOL_CANNOT_ENCHANT_LACK_REQUIREMENT";			// 2011-10-19 by hskim, EP4 [Free to play] - /  ɼ - 䱸ǿ 
	case ERR_PROTOCOL_REQ_EXPERIENCE_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_EXPERIENCE_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_RACE_NOT_MATCHED:				return "ERR_PROTOCOL_REQ_RACE_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_ATTACK_PART_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_ATTACK_PART_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_DEFENSE_PART_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_DEFENSE_PART_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_FUEL_PART_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_FUEL_PART_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_SOUL_PART_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_SOUL_PART_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_SHIELD_PART_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_SHIELD_PART_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_DODGE_PART_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_DODGE_PART_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_UNITKIND_NOT_MATCHED:			return "ERR_PROTOCOL_REQ_UNITKIND_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED:			return "ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED:			return "ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED:			return "ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_ITEM_NOT_MATCHED:				return "ERR_PROTOCOL_REQ_ITEM_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_QUEST_NOT_MATCHED:			return "ERR_PROTOCOL_REQ_QUEST_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_NUM_OF_CHARACTER_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_NUM_OF_CHARACTER_NOT_MATCHED";
	case ERR_PROTOCOL_TOO_FAR_TO_DO:					return "ERR_PROTOCOL_TOO_FAR_TO_DO";
	case ERR_PROTOCOL_NO_SUCH_REQUEST_TYPE:				return "ERR_PROTOCOL_NO_SUCH_REQUEST_TYPE";
	case ERR_PROTOCOL_LOW_PROBABILITY:					return "ERR_PROTOCOL_LOW_PROBABILITY";
	case ERR_PROTOCOL_REQ_NOT_CITY_MAP_CHANNEL:			return "ERR_PROTOCOL_REQ_NOT_CITY_MAP_CHANNEL";
	case ERR_PROTOCOL_REQ_MUST_RELEASE_ALL_ITEM:		return "ERR_PROTOCOL_REQ_MUST_RELEASE_ALL_ITEM";
	case ERR_PROTOCOL_REQ_WARP_REQUIREMENTS_NOT_MATCHED:	return "ERR_PROTOCOL_REQ_WARP_REQUIREMENTS_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_MAP_OBJECT_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_MAP_WARP_TARGET_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_MAP_AREA_NOT_MATCHED:			return "ERR_PROTOCOL_REQ_MAP_AREA_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_MONSTER_NOT_MATCHED:			return "ERR_PROTOCOL_REQ_MONSTER_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_PARTYMEMBERS_NOT_MATCHED:		return "ERR_PROTOCOL_REQ_PARTYMEMBERS_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_PARTYMEMBERS_LEVEL_NOT_MATCHED:	return "ERR_PROTOCOL_REQ_PARTYMEMBERS_LEVEL_NOT_MATCHED";
	case ERR_PROTOCOL_REQ_PARTYMEMBERS_SOMEONE_CANNOT_WARP:	return "ERR_PROTOCOL_REQ_PARTYMEMBERS_SOMEONE_CANNOT_WARP";
	case ERR_PROTOCOL_REQ_PARTYMEMBERS_SOMEONE_NOT_COMPLETION:	return "ERR_PROTOCOL_REQ_PARTYMEMBERS_SOMEONE_NOT_COMPLETION";
	case ERR_PROTOCOL_REQ_MIX_ITEM_NOT_MATCHED:			return "ERR_PROTOCOL_REQ_MIX_ITEM_NOT_MATCHED";		// 2007-04-02 by cmkwon
	case ERR_PROTOCOL_REQ_PW_NOT_MATCHED:				return "ERR_PROTOCOL_REQ_PW_NOT_MATCHED";		// 2008-06-03 by dhjin, EP3   - PW
	case ERR_PROTOCOL_NOT_WARP_BURNING_MAP:				return "ERR_PROTOCOL_NOT_WARP_BURNING_MAP";		// 2010-11-24 by shcho, ݿ   Ÿ ̸ ȯҰ ó

	case ERR_PROTOCOL_NO_SUCH_CHARACTER_QUEST:			return "ERR_PROTOCOL_NO_SUCH_CHARACTER_QUEST";
	case ERR_PROTOCOL_QUEST_ALREADY_COMPLETED:			return "ERR_PROTOCOL_QUEST_ALREADY_COMPLETED";
	case ERR_PROTOCOL_QUEST_NOT_IN_PROGRESS:			return "ERR_PROTOCOL_QUEST_NOT_IN_PROGRESS";
	case ERR_PROTOCOL_QUEST_RESULT_PROCESS_FAILED:		return "ERR_PROTOCOL_QUEST_RESULT_PROCESS_FAILED";
	case ERR_PROTOCOL_QUEST_GENERAL_ERROR:				return "ERR_PROTOCOL_QUEST_GENERAL_ERROR";
	case ERR_PROTOCOL_TIME_LIMIT_ERROR:					return "ERR_PROTOCOL_TIME_LIMIT_ERROR";
	case ERR_PROTOCOL_REQ_NOT_GUILD_MASTER:				return "ERR_PROTOCOL_REQ_NOT_GUILD_MASTER";
	case ERR_PROTOCOL_QUEST_ALREADY_EXIST_CITYWAR:		return "ERR_PROTOCOL_QUEST_ALREADY_EXIST_CITYWAR";
	case ERR_PROTOCOL_QUEST_NEVER_COMPLITION_BY_USER:	return "ERR_PROTOCOL_QUEST_NEVER_COMPLITION_BY_USER";
	case ERR_PROTOCOL_QUEST_INVALID_CITYWAR_QUEST_INDEX:	return "ERR_PROTOCOL_QUEST_INVALID_CITYWAR_QUEST_INDEX";
	case ERR_PROTOCOL_QUEST_CANNOT_CITYWAR_QUEST:		return "ERR_PROTOCOL_QUEST_CANNOT_CITYWAR_QUEST";
	case ERR_PROTOCOL_QUEST_CITYWAR_MGAMESERVERID_NOT_MATCHED:		return "ERR_PROTOCOL_QUEST_CITYWAR_MGAMESERVERID_NOT_MATCHED";
	case ERR_PROTOCOL_QUEST_COUPON_INVALID_NUMBER:		return "ERR_PROTOCOL_QUEST_COUPON_INVALID_NUMBER";
	case ERR_PROTOCOL_QUEST_COUPON_ALREADY_USED:		return "ERR_PROTOCOL_QUEST_COUPON_ALREADY_USED";
	case ERR_PROTOCOL_QUEST_COUPON_EXPIRED:				return "ERR_PROTOCOL_QUEST_COUPON_EXPIRED";
	case ERR_PROTOCOL_QUEST_COUPON_USE_ERROR:			return "ERR_PROTOCOL_QUEST_COUPON_USE_ERROR";
	case ERR_PROTOCOL_QUEST_NO_LEVEL_UP:				return "ERR_PROTOCOL_QUEST_NO_LEVEL_UP";
	case ERR_PROTOCOL_QUEST_IS_IN_PROGRESS:				return "ERR_PROTOCOL_QUEST_IS_IN_PROGRESS";

	case ERR_PROTOCOL_QUEST_SERVICE_PAUSED:				return "ERR_PROTOCOL_QUEST_SERVICE_PAUSED";

	case ERR_PROTOCOL_NO_SUCH_MONSTER_INFO:				return "ERR_PROTOCOL_NO_SUCH_MONSTER_INFO";
	case ERR_PROTOCOL_NO_SUCH_MAPOBJECT_INFO:			return "ERR_PROTOCOL_NO_SUCH_MAPOBJECT_INFO";
	case ERR_PROTOCOL_NO_SUCH_QUEST_INFO:				return "ERR_PROTOCOL_NO_SUCH_QUEST_INFO";
	case ERR_PROTOCOL_NO_SUCH_ITEM_INFO:				return "ERR_PROTOCOL_NO_SUCH_ITEM_INFO";

	case ERR_CHAT_CHARACTER_NAME_NOT_MATCHED:			return "ERR_CHAT_CHARACTER_NAME_NOT_MATCHED";
	case ERR_CHAT_NOT_ALLOWED_STRING:					return "ERR_CHAT_NOT_ALLOWED_STRING";
	case ERR_CHAT_PERMISSION_DENIED:					return "ERR_CHAT_PERMISSION_DENIED";
	case ERR_CHAT_INVALID_COMMAND:						return "ERR_CHAT_INVALID_COMMAND";
	case ERR_CHAT_CHAT_NOT_TRANSFERED:					return "ERR_CHAT_CHAT_NOT_TRANSFERED";
	case ERR_CHAT_CHAT_BLOCKED:							return "ERR_CHAT_CHAT_BLOCKED";
	case ERR_FRIEND_INVALID_CHARACTER_NAME:				return "ERR_FRIEND_INVALID_CHARACTER_NAME";
	case ERR_FRIEND_REGISTERED_PEER_REJECTLIST:			return "ERR_FRIEND_REGISTERED_PEER_REJECTLIST";
	case ERR_FRIEND_ALREADY_REGISTERED:					return "ERR_FRIEND_ALREADY_REGISTERED";
	case ERR_FRIEND_ALREADY_MAX_LIST:					return "ERR_FRIEND_ALREADY_MAX_LIST";
	case ERR_FRIEND_NO_SUCH_CHARACTER_IN_LIST:			return "ERR_FRIEND_NO_SUCH_CHARACTER_IN_LIST";
	case ERR_COUNTDOWN_INVALID_COUNTDOWN_TYPE:			return "ERR_COUNTDOWN_INVALID_COUNTDOWN_TYPE";
	case ERR_COUNTDOWN_NOT_ENOUGH_TIME:					return "ERR_COUNTDOWN_NOT_ENOUGH_TIME";
	case ERR_INTERVAL_SYSTEM_SECOND:					return "ERR_INTERVAL_SYSTEM_SECOND";			// 2008-08-18 by dhjin, 1  ý ȹ

	case ERR_CITYWAR_NO_SUCH_CITYWAR_INFO:				return "ERR_CITYWAR_NO_SUCH_CITYWAR_INFO";
	case ERR_CITYWAR_NOT_MATCHED_CITY_MAP_INDEX:		return "ERR_CITYWAR_NOT_MATCHED_CITY_MAP_INDEX";
	case ERR_CITYWAR_SETOCCUPYINFO_PERMISSION_DENIED:	return "ERR_CITYWAR_SETOCCUPYINFO_PERMISSION_DENIED";
	case ERR_CITYWAR_SETOCCUPYINFO_IMPOSSIBLE_STATE:	return "ERR_CITYWAR_SETOCCUPYINFO_IMPOSSIBLE_STATE";
	case ERR_CITYWAR_SETOCCUPYINFO_IMPOSSIBLE_TIME:		return "ERR_CITYWAR_SETOCCUPYINFO_IMPOSSIBLE_TIME";
	case ERR_CITYWAR_SETOCCUPYINFO_INVALID_WARTIME:		return "ERR_CITYWAR_SETOCCUPYINFO_INVALID_WARTIME";

	case ERR_CASH_mgQueryMall_ERROR:					return "ERR_CASH_mgQueryMall_ERROR";
	case ERR_CASH_mgQueryMall_RESULT_CANNOT_PAYMENT:	return "ERR_CASH_mgQueryMall_RESULT_CANNOT_PAYMENT";
	case ERR_CASH_mgQueryMall_RESULT_NO_ACCOUNT:		return "ERR_CASH_mgQueryMall_RESULT_NO_ACCOUNT";
	case ERR_CASH_NOT_CHARGE_USER:						return "ERR_CASH_NOT_CHARGE_USER";
	case ERR_CASH_INVALID_EXT_ACCOUNTID_NUM:			return "ERR_CASH_INVALID_EXT_ACCOUNTID_NUM";
	case ERR_CASH_INVALID_ITEM_INFORMATION:				return "ERR_CASH_INVALID_ITEM_INFORMATION";
	case ERR_CASH_NORMAL_ERROR:							return "ERR_CASH_NORMAL_ERROR";
	case ERR_CASH_CASH_SHOP_NO_SERVICE:					return "ERR_CASH_CASH_SHOP_NO_SERVICE";
	case ERR_CASH_LIBRARY_INIT_ERROR:					return "ERR_CASH_LIBRARY_INIT_ERROR";		// 2007-08-22 by cmkwon, ߱ Yetime  ̺귯  -
	case ERR_CASH_INVALID_GIVE_TARGET_ACCOUNT:			return "ERR_CASH_INVALID_GIVE_TARGET_ACCOUNT";		// 2009-08-18 by cmkwon,  ĳ   üũ ߰ - 

	case ERR_INVALID_CHARACTER:							return "ERR_INVALID_CHARACTER";
	case ERR_INVALID_PEER_CHARACTER:					return "ERR_INVALID_PEER_CHARACTER";
	case ERR_WARPING:									return "ERR_WARPING";
	case ERR_IN_PARTY_BATTLE:							return "ERR_IN_PARTY_BATTLE";
	case ERR_REQ_WARP_COMPLETIONQUEST_NOT_MATCHED:		return "ERR_REQ_WARP_COMPLETIONQUEST_NOT_MATCHED";
	case ERR_REQ_CHOOSE_INFLUENCE_TYPE:					return "ERR_REQ_CHOOSE_INFLUENCE_TYPE";
	case ERR_CANNOT_WARP_CONNFLICT_AREA:				return "ERR_CANNOT_WARP_INFLICT_AREA";
	case ERR_CANNOT_WARP_POSSESSED_CONNFLICT_AREA:		return "ERR_CANNOT_WARP_POSSESSED_CONNFLICT_AREA";
	case ERR_CANNOT_WARP_BY_TRADING:					return "ERR_CANNOT_WARP_BY_TRADING";
	case ERR_CANNOT_WARP_BY_SHOPPING:					return "ERR_CANNOT_WARP_BY_SHOPPING";
	case ERR_CANNOT_ATTACHED_USING_PREMIUM_CARD:		return "ERR_CANNOT_ATTACHED_USING_PREMIUM_CARD";
	case ERR_CANNOT_BUY_PREMIUM_CARD_USING_SPEC_ITEM:	return "ERR_CANNOT_BUY_PREMIUM_CARD_USING_SPEC_ITEM";
	case ERR_EXPIRED_ITEM:								return "ERR_EXPIRED_ITEM";
	case ERR_FAILURE_USE_RESTORE_ITEM:					return "ERR_FAILURE_USE_RESTORE_ITEM";
	case ERR_DOING_GAMEEVENT:							return "ERR_DOING_GAMEEVENT";
	case ERR_INVALID_GAMEUSER:							return "ERR_INVALID_GAMEUSER";
	case ERR_INVALID_CALL_WARP_EVENT_ID:				return "ERR_INVALID_CALL_WARP_EVENT_ID";
	case ERR_TIMEOVER_CALL_WARP_EVENT:					return "ERR_TIMEOVER_CALL_WARP_EVENT";
	case ERR_CANNOT_PUT_ITEM:							return "ERR_CANNOT_PUT_ITEM";
	case ERR_OVER_COUNT:								return "ERR_OVER_COUNT";
	case ERR_INVALID_BAZAAR:							return "ERR_INVALID_BAZAAR";
	case ERR_USING_BAZAAR:								return "ERR_USING_BAZAAR";
	case ERR_INVISIBLE_STATE:							return "ERR_INVISIBLE_STATE";
	case ERR_DOING_SERVER_SHUTDOWN:						return "ERR_DOING_SERVER_SHUTDOWN";
	case ERR_NO_SEARCH_CHARACTER:						return "ERR_NO_SEARCH_CHARACTER";
	case ERR_NO_MEMBERSHIP_USER:						return "ERR_NO_MEMBERSHIP_USER";
	case ERR_ALREADY_OPEN_OTHER_STORE:					return "ERR_ALREADY_OPEN_OTHER_STORE";		// 2006-09-24 by cmkwon
	case ERR_ALREADY_LOADING_GUILD_STORE:				return "ERR_ALREADY_LOADING_GUILD_STORE";	// 2006-09-25 by cmkwon
	case ERR_NO_SUCH_GUILD_STORE:						return "ERR_NO_SUCH_GUILD_STORE";			// 2006-09-25 by cmkwon
	case ERR_PERMISSION_DENIED:							return "ERR_PERMISSION_DENIED";				// 2006-09-27 by cmkwon
	case ERR_INVALID_EXCUTE_PARAMETER_COUNT:			return "ERR_INVALID_EXCUTE_PARAMETER_COUNT";		// 2006-10-02 by cmkwon
	case ERR_INVALID_EXCUTE_PARAMETER:					return "ERR_INVALID_EXCUTE_PARAMETER";				// 2006-10-02 by cmkwon
	case ERR_NOT_RANK_DRAW_GUILD_STORE:					return "ERR_NOT_RANK_DRAW_GUILD_STORE";				// 2006-10-09 by dhjin
	case ERR_CANNOT_BOOSTER:							return "ERR_CANNOT_BOOSTER";				// 2006-10-09 by dhjin
	case ERR_NOT_INVISIBLE_STATE:						return "ERR_NOT_INVISIBLE_STATE";			// 2007-04-02 by cmkwon
	case ERR_JAMBOREE_NO_SUCH_CHARACTER:				return "ERR_JAMBOREE_NO_SUCH_CHARACTER";		// 2007-04-09 by cmkwon
	case ERR_JAMBOREE_FAIL_CREATE_CHARACTER:			return "ERR_JAMBOREE_FAIL_CREATE_CHARACTER";	// 2007-04-09 by cmkwon
	case ERR_BOSS_STRATEGYPOINT_STATE_SUMMON:			return "ERR_BOSS_STRATEGYPOINT_STATE_SUMMON";	// 2007-04-26 by dhjin
	case ERR_CANNOT_WARP_TO_CITY:						return "ERR_CANNOT_WARP_TO_CITY";				// 2007-05-22 by cmkwon
	case ERR_INVALID_WEAPON_INDEX:						return "ERR_INVALID_WEAPON_INDEX";				// 2007-06-08 by cmkwon
	case ERR_INVALID_TUTORIAL:							return "ERR_INVALID_TUTORIAL";
	case ERR_CANNOT_USE_SPEAKER_ITEM:					return "ERR_CANNOT_USE_SPEAKER_ITEM";			// 2007-08-24 by cmkwon, Ŀ  /   ߰
	case ERR_CONFERENCEROOM_PERMISSION_DENIED:			return "ERR_CONFERENCEROOM_PERMISSION_DENIED";	// 2007-08-30 by cmkwon, ȸǷ ý  -  Ұ  ߰
	case ERR_CANNOT_WARP_TO_OUTPOST:					return "ERR_CANNOT_WARP_TO_OUTPOST";			// 2007-08-28 by dhjin,    Ұ

	case ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP:			return "ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP";			// 2007-08-28 by dhjin,    Ұ
	case ERR_CANNOT_SEARCH_OUTPOST:						return "ERR_CANNOT_SEARCH_OUTPOST";			// 2007-08-28 by dhjin,    Ұ
	case ERR_ALREADY_SET_OUTPOST_NEXTWARTIME:			return "ERR_ALREADY_SET_OUTPOST_NEXTWARTIME";			// 2007-08-28 by dhjin,    Ұ
	case ERR_CANNOT_SEARCH_OUTPOST_NEXTWARTIME:			return "ERR_CANNOT_SEARCH_OUTPOST_NEXTWARTIME";			// 2007-08-28 by dhjin,    Ұ

	
	case ERR_ARENA_NO_SUCH_TEAM:						return "ERR_ARENA_NO_SUCH_TEAM";				// 2007-04-23 by dhjin
	case ERR_ARENA_CREATE_TEAM:							return "ERR_ARENA_CREATE_TEAM";					// 2007-04-23 by dhjin, 
	case ERR_ARENA_NOT_MATCH_MODE:						return "ERR_ARENA_NOT_MATCH_MODE";				// 2007-04-23 by dhjin, 
	case ERR_ARENA_NOT_MATCH_LEVEL:						return "ERR_ARENA_NOT_MATCH_LEVEL";				// 2007-04-23 by dhjin, 
	case ERR_ARENA_NOT_MATCH_PW:						return "ERR_ARENA_NOT_MATCH_PW";				// 2007-04-23 by dhjin, 
	case ERR_ARENA_FULL_TEAMLIST:						return "ERR_ARENA_FULL_TEAMLIST";				// 2007-04-23 by dhjin, 
	case ERR_ARENA_STATE:								return "ERR_ARENA_STATE";						// 2007-04-23 by dhjin, 
	case ERR_ARENA_STATE_TEAM_READY:					return "ERR_ARENA_STATE_TEAM_READY";			// 2007-06-05 by dhjin
	case ERR_ARENA_STATE_TEAM_WARING:					return "ERR_ARENA_STATE_TEAM_WARING";			// 2007-06-05 by dhjin
	case ERR_ARENA_BLOCKED:								return "ERR_ARENA_BLOCKED";						// 2007-07-11 by cmkwon, Ʒ ý 

	case ERR_NO_SEARCH_CITYLEADER_INFO:					return "ERR_NO_SEARCH_CITYLEADER_INFO";			// 2007-09-13 by cmkwon
	case ERR_REQ_NOT_LEADER_CANDIDATE:					return "ERR_REQ_NOT_LEADER_CANDIDATE";			// 2007-10-30 by dhjin
	case ERR_REQ_NOT_POLLDATE_APPLICATION:				return "ERR_REQ_NOT_POLLDATE_APPLICATION";		// 2007-10-30 by dhjin
	case ERR_FAIL_REG_LEADER_CANDIDATE_BY_DB:			return "ERR_FAIL_REG_LEADER_CANDIDATE_BY_DB";	// 2007-10-30 by dhjin
	case ERR_FAIL_REG_LEADER_CANDIDATE_BY_REQ:			return "ERR_FAIL_REG_LEADER_CANDIDATE_BY_REQ";	// 2007-10-30 by dhjin
	case ERR_REQ_NOT_POLLDATE_VOTE:						return "ERR_REQ_NOT_POLLDATE_VOTE";				// 2007-10-30 by dhjin
	case ERR_REQ_NOT_VOTE:								return "ERR_REQ_NOT_VOTE";						// 2007-10-31 by dhjin
	case ERR_ALREADY_VOTE:								return "ERR_ALREADY_VOTE";						// 2007-10-31 by dhjin
	case ERR_INVALID_LEADER_CANDIDATE:					return "ERR_INVALID_LEADER_CANDIDATE";			// 2007-10-31 by dhjin
	case ERR_ALREADY_LEADER_CANDIDATE:					return "ERR_ALREADY_LEADER_CANDIDATE";			// 2007-11-01 by dhjin

	case ERR_ALREADY_DELETE_LEADER_CANDIDATE:			return "ERR_ALREADY_DELETE_LEADER_CANDIDATE";	// 2007-11-01 by dhjin
	case ERR_REQ_NOT_POLLDATE_ALL_RANGE:				return "ERR_REQ_NOT_POLLDATE_ALL_RANGE";		// 2007-11-20 by dhjin
	case ERR_REQ_REG_LEADER_CANDIDATE:					return "ERR_REQ_REG_LEADER_CANDIDATE";		// 2007-11-20 by dhjin

	case ERR_CANNOT_WARP_DURING_MSWAR:					return "ERR_CANNOT_WARP_DURING_MSWAR";			// 2012-07-02 by hskim,   -      Ұ

	case ERR_WARING_OUTPOST_TO_OWNMAP:					return "ERR_WARING_OUTPOST_TO_OWNMAP";			// 2007-11-01 by dhjin
	case ERR_DELETE_CHARACTER_GUILDCOMMANDER:			return "ERR_DELETE_CHARACTER_GUILDCOMMANDER";	// 2008-10-20 by dhjin,  ɸ  Ұ 

	case ERR_SECPASS_NOT_USE_SYSTEM:					return "ERR_SECPASS_NOT_USE_SYSTEM";			// 2007-09-13 by cmkwon
	case ERR_SECPASS_PASSWORD_NOT_SETTING:				return "ERR_SECPASS_PASSWORD_NOT_SETTING";		// 2007-09-13 by cmkwon
	case ERR_SECPASS_ALREADY_LOCK:						return "ERR_SECPASS_ALREADY_LOCK";				// 2007-09-13 by cmkwon
	case ERR_SECPASS_ALREADY_UNLOCK:					return "ERR_SECPASS_ALREADY_UNLOCK";			// 2007-09-13 by cmkwon
	case ERR_SECPASS_PASSWORD_NOT_MATCHED:				return "ERR_SECPASS_PASSWORD_NOT_MATCHED";		// 2007-09-13 by cmkwon
	case ERR_SECPASS_NEW_PASSWORD_NOT_SETTING:			return "ERR_SECPASS_NEW_PASSWORD_NOT_SETTING";	// 2007-09-13 by cmkwon
	case ERR_SECPASS_LOCKED:							return "ERR_SECPASS_LOCKED";					// 2007-09-13 by cmkwon

	case ERR_LUCKYITEM_INSERT_BUT_COINITEM_DELETE:		return "ERR_LUCKYITEM_INSERT_BUT_COINITEM_DELETE";				// 2008-11-10 by dhjin, Űӽ  ϳ ޵Ǿ ýۿ  ־   ʾ 
		
	case ERR_INVALID_ARMOR_ITEM:						return "ERR_INVALID_ARMOR_ITEM";
	case ERR_ITEM_TRADING:								return "ERR_ITEM_TRADING";
	case ERR_USING_SHOP:								return "ERR_USING_SHOP";
	case ERR_NO_SUCH_WEAPON_ITEM:						return "ERR_NO_SUCH_WEAPON_ITEM";				// 2007-08-07 by cmkwon, 1/2  Ѿ    - ڵ ߰
	case ERR_ALREADY_FULL_BULLET:						return "ERR_ALREADY_FULL_BULLET";				// 2007-08-07 by cmkwon, 1/2  Ѿ    - ڵ ߰
	case ERR_INVALID_ITEMEVENT_UID:						return "ERR_INVALID_ITEMEVENT_UID";				// 2008-01-10 by cmkwon,  ̺Ʈ ýۿ   ý ߰ - 
	case ERR_NOT_ACCOUNT_BLOCKED:						return "ERR_NOT_ACCOUNT_BLOCKED";
	case ERR_SOLD_OUT_SHOP_ITEM:						return "ERR_SOLD_OUT_SHOP_ITEM";				// 2010-01-26 by cmkwon, ĳ  Ǹ ý  - 
	case ERR_NO_SUCH_ENCHANT_INFO:						return "ERR_NO_SUCH_ENCHANT_INFO";				// 2010-04-20 by cmkwon, ű Ű ӽ  - 

	case ERR_PROTOCOL_SUBLEADER_SET_FAIL:				return "ERR_PROTOCOL_SUBLEADER_SET_FAIL";
	case ERR_PROTOCOL_SUBLEADER_SET_ALEADY:				return "ERR_PROTOCOL_SUBLEADER_SET_ALEADY";

	case ERR_CANNOT_USE_GUILD_STORE:					return "ERR_CANNOT_USE_GUILD_STORE";			// 2009-09-23 by cmkwon, ʵâ ĳ   - 
	case ERR_CANNOT_USE_STORE:							return "ERR_CANNOT_USE_STORE";					// 2009-09-23 by cmkwon, ʵâ ĳ   - 
	case ERR_CANNOT_USE_FIELD_STORE:					return "ERR_CANNOT_USE_FIELD_STORE";			// 2009-09-23 by cmkwon, ʵâ ĳ   - 
	case ERR_ALREADY_USING_BUILDING:					return "ERR_ALREADY_USING_BUILDING";			// 2009-09-23 by cmkwon, ʵâ ĳ   - 
	case ERR_NO_SUCH_BUILDINGINDEX:						return "ERR_NO_SUCH_BUILDINGINDEX";				// 2009-09-23 by cmkwon, ʵâ ĳ   - 
	case ERR_CANNOT_BUY_ITEM:							return "ERR_CANNOT_BUY_ITEM";					// 2009-09-23 by cmkwon, ʵâ ĳ   - 
	case ERR_ALREADY_USE_ITEMPARAM:						return "ERR_ALREADY_USE_ITEMPARAM";				// 2010-01-18 by cmkwon,   Parameter ߺ üũ ý  - 
	case ERR_INSUFFICIENT_NUMBER_SHOP_ITEM:				return "ERR_INSUFFICIENT_NUMBER_SHOP_ITEM";		// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý - Ҽ ִ  
	case ERR_NOT_OWNER_SHOP:							return "ERR_NOT_OWNER_SHOP";					// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý -   ƴ

	case ERR_MAP_CHECKSUM_NOT_MATCHED:					return "ERR_MAP_CHECKSUM_NOT_MATCHED";		// 2007-04-06 by cmkwon
	case ERR_REQ_WARP_ONE_TIME_LIMITED:					return "ERR_REQ_WARP_ONE_TIME_LIMITED";			// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý - 1   
	case ERR_REQ_WARP_GUILD_NOT_MATCHED:				return "ERR_REQ_WARP_GUILD_NOT_MATCHED";		// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý -    ִ 尡 ƴ
	case ERR_REQ_WARP_MAXIMUM_USER_LIMITED:				return "ERR_REQ_WARP_MAXIMUM_USER_LIMITED";		// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý - ִ   ִ ο Ѿ
	case ERR_REQ_WARP_NO_QUEST_ITEM:					return "ERR_REQ_WARP_NO_QUEST_ITEM";			// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý - 忡 ʿ Ʈ  
	case ERR_REQ_WARP_GAME_START_NOT_ALLOWED_USER:		return "ERR_REQ_WARP_GAME_START_NOT_ALLOWED_USER";		// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý -  ۽ÿ ʿ    ƴ
	case ERR_REQ_WARP_INFLUENCE_NOT_MATCHED:			return "ERR_REQ_WARP_INFLUENCE_NOT_MATCHED";		// 2011-10-28 by hskim, EP4 [Ʈ ý] - ũŻ ý -    ִ  ƴ

	case ERR_REQ_CHOOSE_START_CIIY_MAP_INDEX:			return "ERR_REQ_CHOOSE_START_CIIY_MAP_INDEX";	// 2009-10-12 by cmkwon, ī    - 

	case ERR_INVALID_ARENASERVER:						return "ERR_INVALID_ARENASERVER";			// 2008-03-07 by dhjin, Ʒ  - 
	case ERR_NO_SUCH_FIELDSERVER:						return "ERR_NO_SUCH_FIELDSERVER";			// 2008-03-07 by dhjin, Ʒ  - 
	case ERR_INVALID_MAINSERVER_CHARACTER:				return "ERR_INVALID_MAINSERVER_CHARACTER";	// 2008-03-07 by dhjin, Ʒ  - 
	case ERR_INVALID_ARENASERVER_CHARACTER:				return "ERR_INVALID_ARENASERVER_CHARACTER";	// 2008-03-07 by dhjin, Ʒ  - 	
	case ERR_CANNOT_USE_ARENASERVER:					return "ERR_CANNOT_USE_ARENASERVER";		// 2008-03-07 by dhjin, Ʒ  - 
	case ERR_NOT_CONNECT_TO_ARENASERVER:				return "ERR_NOT_CONNECT_TO_ARENASERVER";	// 2008-03-07 by dhjin, Ʒ  - 

	case ERR_NO_SUCH_LETTER:							return "ERR_NO_SUCH_LETTER";				// 2008-04-30 by dhjin, EP3  ý -  ã Ͽ.

	case ERR_ALREADY_REG:								return "ERR_ALREADY_REG";					// 2008-04-30 by dhjin, EP3 -    - ڱ Ұ  Ǿִ.
	case ERR_CANNOT_USE_NEW_COMMANDER_BY_CITYLEADER:    return "ERR_CANNOT_USE_NEW_COMMANDER_BY_CITYLEADER";		// 2008-06-19 by dhjin, EP3 -    - ڳ     Ұ 
	case ERR_CANNOT_USE_NEW_COMMANDER_BY_POLL:		    return "ERR_CANNOT_USE_NEW_COMMANDER_BY_POLL";				// 2008-06-19 by dhjin, EP3 -    - ſ ⸶    Ұ
	case ERR_POSSESS_OUTPOST:						    return "ERR_POSSESS_OUTPOST";							// 2009-06-30 by cmkwon,  ü üũ  - 

	case ERR_INVALID_DATA_FROM_CLIENT:					return "ERR_INVALID_DATA_FROM_CLIENT";			// 2008-06-17 by dhjin, EP3 äù - Ŭ̾Ʈκ  ߸ Ÿ
	case ERR_CHATROOM_NO_SUCH_CREATE_NUM:				return"ERR_CHATROOM_NO_SUCH_CREATE_NUM";		// 2008-06-17 by dhjin, EP3 äù -   ȣ 
	case ERR_CHATROOM_NO_SUCH:							return"ERR_CHATROOM_NO_SUCH";					// 2008-06-17 by dhjin, EP3 äù - äù .
	case ERR_CHATROOM_ALREADY_USING:					return"ERR_CHATROOM_ALREADY_USING";				// 2008-06-17 by dhjin, EP3 äù - ̹ äù ̴̿.
	case ERR_CHATROOM_PERMISSION_DENIED:				return"ERR_CHATROOM_PERMISSION_DENIED";			// 2008-06-17 by dhjin, EP3 äù -  .
	case ERR_CHATROOM_FULL_MEMBER:						return"ERR_CHATROOM_FULL_MEMBER";				// 2008-06-17 by dhjin, EP3 äù - äù ο ̴.
	case ERR_CHATROOM_NO_SUCH_NEW_MASTER:				return"ERR_CHATROOM_NO_SUCH_NEW_MASTER";		// 2008-06-17 by dhjin, EP3 äù - ο  ã ߴ.
	case ERR_NOT_MATCH_PW:								return"ERR_NOT_MATCH_PW";						// 2008-07-15 by dhjin, EP3 äù - ȣ ġ.
	case ERR_NO_SUCH_DECLARATION_MSWAR_INFO:			return"ERR_NO_SUCH_DECLARATION_MSWAR_INFO";		// 2009-01-12 by dhjin,   -    ã
	case ERR_NO_MORE_DECLARATION_MSWAR_SET:				return"ERR_NO_MORE_DECLARATION_MSWAR_SET";		// 2009-01-12 by dhjin,   -   ð  ̻    .
	case ERR_INVALID_DECLARATION_MSWAR_TIME:			return"ERR_INVALID_DECLARATION_MSWAR_TIME";		// 2009-01-12 by dhjin,   -   ð  ߸.

	case ERR_CANNOT_CHOOSE_INFLUENCE_TYPE:				return"ERR_CANNOT_CHOOSE_INFLUENCE_TYPE";		// 2009-03-31 by cmkwon, ʱȭ ý  - 

	case ERR_CANNOT_CONNECT_INTERNET:					return "ERR_CANNOT_CONNECT_INTERNET";
	case ERR_CANNOT_CONNECT_AUTO_UPDATE_SERVER:			return "ERR_CANNOT_CONNECT_AUTO_UPDATE_SERVER";
	case ERR_LOCAL_FILE_CREATE_FAIL:					return "ERR_LOCAL_FILE_CREATE_FAIL";
	case ERR_AUTO_UPDATE_SERVER_PERMISSION_DENIED:		return "ERR_AUTO_UPDATE_SERVER_PERMISSION_DENIED";
	case ERR_UPDATE_FILE_NOT_FOUND:						return "ERR_UPDATE_FILE_NOT_FOUND";
	case ERR_UPDATE_FILE_DOWNLOADING_FAIL:				return "ERR_UPDATE_FILE_DOWNLOADING_FAIL";
	case ERR_UPDATE_FILE_DOWNLOADING_CANCEL:			return "ERR_UPDATE_FILE_DOWNLOADING_CANCEL";
	case ERR_FUNC_HttpOpenRequest:						return "ERR_FUNC_HttpOpenRequest";
	case ERR_FUNC_HttpSendRequest:						return "ERR_FUNC_HttpSendRequest";
	case ERR_FUNC_HttpQueryInfo:						return "ERR_FUNC_HttpQueryInfo";
	case ERR_VERSIONINFO_FILE_NOT_FOUND:				return "ERR_VERSIONINFO_FILE_NOT_FOUND";		// 2007-05-09 by cmkwon
	case ERR_VERSIONINFO_FILE_CAN_NOT_CREATE:			return "ERR_VERSIONINFO_FILE_CAN_NOT_CREATE";		// 2007-05-09 by cmkwon
	case ERR_NOT_ALLOWED_IP:							return "ERR_NOT_ALLOWED_IP";		// 2007-10-19 by cmkwon, AllowedIP ý  -

	////////////////////////////////////////////////////////////////////////////////
	// 2009-09-09 ~ 2010 by dhjin, ǴƼ - 
	case ERR_DEBUFF_SKILL_APPLYING_SLIENCE:				return "ERR_DEBUFF_SKILL_APPLYING_SLIENCE";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Ϸ  ̴.
	case ERR_RELEASE_SKILL_NOT_FIND:					return "ERR_RELEASE_SKILL_NOT_FIND";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ų ã .
	case ERR_DEBUFF_SKILL_APPLYING_NOT_HP_RECOVERY:		return "ERR_DEBUFF_SKILL_APPLYING_NOT_HP_RECOVERY";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - HPȸ 
	case ERR_DEBUFF_SKILL_APPLYING_NOT_DP_RECOVERY:		return "ERR_DEBUFF_SKILL_APPLYING_NOT_DP_RECOVERY";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - DPȸ 
	case ERR_DEBUFF_SKILL_APPLYING_NOT_SP_RECOVERY:		return "ERR_DEBUFF_SKILL_APPLYING_NOT_SP_RECOVERY";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - SPȸ 
	case ERR_INFINITY_NO_SUCH_MODE_LIST:				return "ERR_INFINITY_NO_SUCH_MODE_LIST";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ Ʈ ã  
	case ERR_INFINITY_NO_SUCH_READY_LIST:				return "ERR_INFINITY_NO_SUCH_READY_LIST";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ  Ʈ ã  
	case ERR_INFINITY_OVER_ENTRANCECOUNT:				return "ERR_INFINITY_OVER_ENTRANCECOUNT";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ    Ѱ.
	case ERR_INFINITY_CREATE_FAIL:						return "ERR_INFINITY_CREATE_FAIL";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ  
	case ERR_INFINITY_JOIN_FAIL_SOCKET:					return "ERR_INFINITY_JOIN_FAIL_SOCKET";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ   -  NULL
	case ERR_INFINITY_MAX_ADMISSIONCNT:					return "ERR_INFINITY_MAX_ADMISSIONCNT";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ   - ִ ο
	case ERR_INFINITY_MISMATCH_LEVEL:					return "ERR_INFINITY_MISMATCH_LEVEL";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ   - 
	case ERR_INFINITY_MODE:								return "ERR_INFINITY_MODE";								// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ߸ 
	case ERR_INFINITY_CREATEUID:						return "ERR_INFINITY_CREATEUID";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ߸  ȣ
	case ERR_INFINITY_NO_SUCH_MASTER_USER:				return "ERR_INFINITY_NO_SUCH_MASTER_USER";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ   -  
	case ERR_INFINITY_JOIN_FAIL_MASTERUSER_REJECT:		return "ERR_INFINITY_JOIN_FAIL_MASTERUSER_REJECT";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ   -  ȣ
	case ERR_INFINITY_NO_SUCH_MEMBER_LIST:				return "ERR_INFINITY_NO_SUCH_MEMBER_LIST";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ  Ʈ ã  
	case ERR_INFINITY_STATE:							return "ERR_INFINITY_STATE";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ ߸ °
	case ERR_INFINITY_SAME_MASTER:						return "ERR_INFINITY_SAME_MASTER";						// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ι!
	case ERR_INFINITY_MASTER:							return "ERR_INFINITY_MASTER";							// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Ͱ ƴϴ.
	case ERR_INFINITY_CREATE_MAPCHANNEL:				return "ERR_INFINITY_CREATE_MAPCHANNEL";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ -    ä  
	case ERR_INFINITY_NOT_ALL_READY:					return "ERR_INFINITY_NOT_ALL_READY";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -    ° ƴϴ.
	case ERR_INFINITY_CANNOT_USE_ITEM:					return "ERR_INFINITY_CANNOT_USE_ITEM";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ  Ұ
	case ERR_INFINITY_MIN_ADMISSIONCNT:					return "ERR_INFINITY_MIN_ADMISSIONCNT";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ -  ̿ ּ ο 
	case ERR_INFINITY_TENDER_PROCESSING:				return "ERR_INFINITY_TENDER_PROCESSING";				// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Tender̴.
	case ERR_INFINITY_NOT_PROCESSING_TENDERITEM:		return "ERR_INFINITY_NOT_PROCESSING_TENDERITEM";		// 2009-09-09 ~ 2010 by dhjin, ǴƼ - Tender  ƴϴ.
	case ERR_INFINITY_ONLY_USE_ITEM:					return "ERR_INFINITY_ONLY_USE_ITEM";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ǴƼ  
	case ERR_INFINITY_CANNOT_SUCH_TEAM:					return "ERR_INFINITY_CANNOT_SUCH_TEAM";					// 2009-09-09 ~ 2010 by dhjin, ǴƼ - ñ   ó, ϴ  .
	case ERR_INFINITY_NULL_VALUE:						return "ERR_INFINITY_NULL_VALUE";						// 2009-09-09 ~ 2010-01 by dhjin, ǴƼ - ҽ üũ, NULL üũ
	case ERR_INFINITY_CANNOT_ALL_START:					return "ERR_INFINITY_CANNOT_ALL_START";					// 2010-04-06 by cmkwon, 2 ߰  - 
	case ERR_INFINITY_TENDER_ALREADY_CHOICED:			return "ERR_INFINITY_TENDER_ALREADY_CHOICED";			// 2010-04-09 by cmkwon, 2 ߰ (ܰ躰  ߰) - 

	case ERR_INFINITY_DIFFICLUTY_NOT_FIND :				return "ERR_INFINITY_DIFFICLUTY_NOT_FIND";				// 2010-05-04 by shcho, ǴƼ ̵  - ̵ ã  
	case ERR_INFINITY_DIFFICULTY_LEVEL_SAME :			return "ERR_INFINITY_DIFFICULTY_LEVEL_SAME";			// 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() ) -  ̵  û .
	case ERR_INFINITY_DIFFICULTY_LEVEL_INVALID :		return "ERR_INFINITY_DIFFICULTY_LEVEL_INVALID";			// 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() ) - ȿ  ̵ 氪 û .

	case ERR_INFINITY_MISMATCH_CREATEUID :				return "ERR_INFINITY_MISMATCH_CREATEUID";				// ǴƼ -  ȣ ġ.	// 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.
	case ERR_INFINITY_PLAYING_STATE :					return "ERR_INFINITY_PLAYING_STATE";					// ǴƼ -    ƴ . ( STATE - PLAYING ~  ) // 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.
	case ERR_INFINITY_ALWAYS_SKIP_ENDINGCINEMA :		return "ERR_INFINITY_ALWAYS_SKIP_ENDINGCINEMA";			// ǴƼ - ̹  ŵ Ȱȭ Ǿ . // 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.

	case ERR_DEBUFF_SKILL_APPLYING_STOPMAGIC :			return "ERR_DEBUFF_SKILL_APPLYING_STOPMAGIC";			// 2011-10-28 by hskim, EP4 [Ʈ ý] - ų ߰ : ħ  ų Ҽ ϴ.

	case ERR_KNOWN_ERROR:								return "ERR_KNOWN_ERROR";			// 2010-04-26 by cmkwon, þ Innva / ý  - 
	case ERR_INVALID_HANDLE:							return "ERR_INVALID_HANDLE";			// 2010-04-26 by cmkwon, þ Innva / ý  - 

	///////////////////////////////////////////////////////////////////////////////
	// 2011-01-26 by hskim,   

	case ERR_PROTOCOL_INVALID_AUTHENTICATION_SERVER_LOGIN_DATA:			return "ERR_PROTOCOL_INVALID_AUTHENTICATION_SERVER_LOGIN_DATA"; // 2011-01-26 by hskim,    - PreServer    Data Size Authentication Packet Type  Data Size 
	case ERR_PROTOCOL_INVALID_AUTHENTICATION_SERVER_LOGIN_DB:			return "ERR_PROTOCOL_INVALID_AUTHENTICATION_SERVER_LOGIN_DB";	// 2011-01-26 by hskim,    - PreServer   Ÿ    ߰  ó ʾҴ

	/////////////////////////////////////////////////////////////
	// 2011-08-22 by hskim, Ʈ ý 2

	case ERR_PET_NUMERIC_VALUE_OUT_OF_RANGE:			return "ERR_PET_NUMERIC_VALUE_OUT_OF_RANGE";		// 2011-09-15 by hskim, Ʈ ý 2 -   
	case ERR_PET_NOT_EQUIPPED:							return "ERR_PET_NOT_EQUIPPED";						// 2011-09-15 by hskim, Ʈ ý 2 -  Ǿ  ʴ
	case ERR_PET_EMPTY_NAME:							return "ERR_PET_EMPTY_NAME";						// 2011-09-15 by hskim, Ʈ ý 2 - ̸  
	case ERR_PET_NOT_ALLOW_LEVEL_UP:					return "ERR_PET_NOT_ALLOW_LEVEL_UP";				// 2011-09-15 by hskim, Ʈ ý 2 -   
	case ERR_PET_NOT_ALLOW_CHANGE_NAME:					return "ERR_PET_NOT_ALLOW_CHANGE_NAME";				// 2011-09-15 by hskim, Ʈ ý 2 - ̸   
	case ERR_PET_NOT_ALLOW_SOCKET_INDEX:				return "ERR_PET_NOT_ALLOW_SOCKET_INDEX";			// 2011-09-15 by hskim, Ʈ ý 2 - ȵǴ  ε
	case ERR_PET_ALREADY_USE_SOCKET:					return "ERR_PET_ALREADY_USE_SOCKET";				// 2011-09-15 by hskim, Ʈ ý 2 - ̹  
	case ERR_PET_INVALID_SOCKET:						return "ERR_PET_INVALID_SOCKET";					// 2011-09-15 by hskim, Ʈ ý 2 - ߸ 
	case ERR_PET_NO_SUCH_INFO:							return "ERR_PET_NO_SUCH_INFO";						// 2011-09-15 by hskim, Ʈ ý 2 -   ã 
	case ERR_PET_INVALID_AUTOSKILL:						return "ERR_PET_INVALID_AUTOSKILL";					// 2011-09-15 by hskim, Ʈ ý 2 - ߸ ڵ ų
	case ERR_PET_INVALID_AUTOKIT:						return "ERR_PET_INVALID_AUTOKIT";					// 2011-09-15 by hskim, Ʈ ý 2 - ߸ Ʈ ų
	case ERR_PET_NOT_MATCH_SOCKET:						return "ERR_PET_NOT_MATCH_SOCKET";					// 2011-09-15 by hskim, Ʈ ý 2 - Ͼ  ġ ʴ´

	case ERR_SECURITY_NOT_CHECK_VERSION:				return "ERR_SECURITY_NOT_CHECK_VERSION";
	case ERR_SECURITY_HACKING_GUID:						return "ERR_SECURITY_HACKING_GUID";
	case ERR_SECURITY_HACKING_CRC:						return "ERR_SECURITY_HACKING_CRC";
	case ERR_SECURITY_HACKING_CLIENT:					return "ERR_SECURITY_HACKING_CLIENT";
	case ERR_SECURITY_ANTICPX_INVALID_HANDLE:			return "ERR_SECURITY_ANTICPX_INVALID_HANDLE";	// 2008-04-03 by cmkwon, ٽ   ý  - 
	case ERR_SECURITY_CREATE_CLIENT_FAIL:				return "ERR_SECURITY_CREATE_CLIENT_FAIL";		// 2008-04-03 by cmkwon, ٽ   ý  - 

	case ERR_AHNHS_ENGINE_DETECT_GAME_HACK:				return "ERR_AHNHS_ENGINE_DETECT_GAME_HACK";
	case ERR_AHNHS_ACTAPC_DETECT_AUTOMOUSE:				return "ERR_AHNHS_ACTAPC_DETECT_AUTOMOUSE";
	case ERR_AHNHS_ACTAPC_DETECT_ALREADYHOOKED:			return "ERR_AHNHS_ACTAPC_DETECT_ALREADYHOOKED";
	case ERR_AHNHS_ACTAPC_DETECT_SPEEDHACK:				return "ERR_AHNHS_ACTAPC_DETECT_SPEEDHACK";
	case ERR_AHNHS_ACTAPC_DETECT_SPEEDHACK_APP:			return "ERR_AHNHS_ACTAPC_DETECT_SPEEDHACK_APP";
	case ERR_AHNHS_ACTAPC_DETECT_KDTRACE:				return "ERR_AHNHS_ACTAPC_DETECT_KDTRACE";
	case ERR_AHNHS_ACTAPC_DETECT_KDTRACE_CHANGED:		return "ERR_AHNHS_ACTAPC_DETECT_KDTRACE_CHANGED";
	case ERR_AHNHS_ACTAPC_DETECT_DRIVERFAILED:			return "ERR_AHNHS_ACTAPC_DETECT_DRIVERFAILED";
	case ERR_AHNHS_ACTAPC_DETECT_HOOKFUNCTION:			return "ERR_AHNHS_ACTAPC_DETECT_HOOKFUNCTION";
	case ERR_AHNHS_ACTAPC_DETECT_MESSAGEHOOK:			return "ERR_AHNHS_ACTAPC_DETECT_MESSAGEHOOK";
	case ERR_AHNHS_ACTAPC_DETECT_MODULE_CHANGE:			return "ERR_AHNHS_ACTAPC_DETECT_MODULE_CHANGE";
	case ERR_AHNHS_ACTAPC_DETECT_ABNORMAL_MEMORY_ACCESS:	return "ERR_AHNHS_ACTAPC_DETECT_ABNORMAL_MEMORY_ACCESS";	// 2007-04-09 by cmkwon

	case ERR_AHNHS_ACTAPC_DETECT_ENGINEFAILED:				return "ERR_AHNHS_ACTAPC_DETECT_ENGINEFAILED";	// 2008-03-24 by cmkwon, ٽ 2.0  - AHNHS_ACTAPC_DETECT_ENGINEFAILED ߰
	case ERR_AHNHS_ACTAPC_DETECT_AUTOMACRO:						return "ERR_AHNHS_ACTAPC_DETECT_AUTOMACRO";						// 2009-07-17 by cmkwon, ٽ ü  ó Ÿ߰(Ŭ̾Ʈ ) - 
	case ERR_AHNHS_ACTAPC_DETECT_CODEMISMATCH:					return "ERR_AHNHS_ACTAPC_DETECT_CODEMISMATCH";					// 2009-07-17 by cmkwon, ٽ ü  ó Ÿ߰(Ŭ̾Ʈ ) - 
	case ERR_AHNHS_ACTAPC_DETECT_ABNORMAL_HACKSHIELD_STATUS:	return "ERR_AHNHS_ACTAPC_DETECT_ABNORMAL_HACKSHIELD_STATUS";	// 2009-07-17 by cmkwon, ٽ ü  ó Ÿ߰(Ŭ̾Ʈ ) - 
	case ERR_AHNHS_ACTAPC_DETECT_LMP_FAILED:					return "ERR_AHNHS_ACTAPC_DETECT_LMP_FAILED";					// 2009-07-17 by cmkwon, ٽ ü  ó Ÿ߰(Ŭ̾Ʈ ) - 

	case ERR_CASH_PREMIUM_CARD_INVALID_ITEMNUM:			return "ERR_CASH_PREMIUM_CARD_INVALID_ITEMNUM";
	case ERR_CASH_PREMIUM_CARD_ALREADY_USING:			return "ERR_CASH_PREMIUM_CARD_ALREADY_USING";
	case ERR_CASH_PREMIUM_CARD_NOT_MATCHED:				return "ERR_CASH_PREMIUM_CARD_NOT_MATCHED";
//	case ERR_CASH_PREMIUM_CARD_NOT_YET_BUY_STATE:		return "ERR_CASH_PREMIUM_CARD_NOT_YET_BUY_STATE";
	case ERR_CASH_PREMIUM_CARD_NOT_YET_BUY_STATE:		return "ERR_CASH_PREMIUM_CARD_NOT_YET_BUY_STATE";
	case ERR_NOT_DISSOLVED_ITEM:						return "ERR_NOT_DISSOLVED_ITEM";
	case ERR_NOT_INSERT_DISSOLVED_ITEMS:				return "ERR_NOT_INSERT_DISSOLVED_ITEMS";
	
	// 2012-08-17 by jhseol,  BPSoft ý
	case ERR_CASH_BPSOFT_COM_LIBRARY_INIT:				return "ERR_CASH_BPSOFT_COM_LIBRARY_INIT";
	case ERR_CASH_BPSOFT_CREATION_OBJECK:				return "ERR_CASH_BPSOFT_CREATION_OBJECK";
	case ERR_CASH_BPSOFT_METHOD_CALL:					return "ERR_CASH_BPSOFT_METHOD_CALL";
	case ERR_CASH_BPSOFT_EXCEPTION:						return "ERR_CASH_BPSOFT_EXCEPTION";
	// end 2012-08-17 by jhseol,  BPSoft ý
	}

	return "UNKNOWN_ERROR";
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			char *GET_LANGUAGE_TYPE_STRING(int i_nLangTy)
/// \brief		// 2008-04-25 by cmkwon,   Ͼ ߰ - GET_LANGUAGE_TYPE_STRING() ߰
/// \author		cmkwon
/// \date		2008-04-25 ~ 2008-04-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *GET_LANGUAGE_TYPE_STRING(int i_nLangTy)
{
	// 2008-04-25 by cmkwon,  / ߰  ߰ Ǿ ϴ  - [-ʼ] ߰  Ʈ  Լ ߰

	switch(i_nLangTy)
	{
	case LANGUAGE_TYPE_KOREAN:			return "LANGUAGE_TYPE_KOREAN";
	case LANGUAGE_TYPE_ENGLISH:			return "LANGUAGE_TYPE_ENGLISH";
	case LANGUAGE_TYPE_JAPANESE:		return "LANGUAGE_TYPE_JAPANESE";
	case LANGUAGE_TYPE_CHINESE:			return "LANGUAGE_TYPE_CHINESE";
	case LANGUAGE_TYPE_VIETNAMESE:		return "LANGUAGE_TYPE_VIETNAMESE";
	case LANGUAGE_TYPE_GERMAN:			return "LANGUAGE_TYPE_GERMAN";
	case LANGUAGE_TYPE_THAI:			return "LANGUAGE_TYPE_THAI";
	case LANGUAGE_TYPE_RUSSIAN:			return "LANGUAGE_TYPE_RUSSIAN";
	case LANGUAGE_TYPE_TAIWANESE:		return "LANGUAGE_TYPE_TAIWANESE";	// 2008-09-23 by cmkwon,   ߰(븸 Netpower_Tpe) - 
	case LANGUAGE_TYPE_TURKISH:			return "LANGUAGE_TYPE_TURKISH";		// 2008-12-22 by cmkwon,   ߰(Gameforge4D Ű, Ҿ, Żƾ) - 
	case LANGUAGE_TYPE_FRENCH:			return "LANGUAGE_TYPE_FRENCH";		// 2008-12-22 by cmkwon,   ߰(Gameforge4D Ű, Ҿ, Żƾ) - 
	case LANGUAGE_TYPE_ITALIAN:			return "LANGUAGE_TYPE_ITALIAN";		// 2008-12-22 by cmkwon,   ߰(Gameforge4D Ű, Ҿ, Żƾ) - 
	case LANGUAGE_TYPE_POLISH:			return "LANGUAGE_TYPE_POLISH";		// 2009-03-17 by cmkwon,   ߰(, ξ) - 
	case LANGUAGE_TYPE_SPANISH:			return "LANGUAGE_TYPE_SPANISH";		// 2009-03-17 by cmkwon,   ߰(, ξ) - 
	}
	return "LANGUAGE_TYPE_UNKNOWN";
}

char *Get_EVENT_TYPE_String(EventType_t i_evType)
{
	switch(i_evType)
	{
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_NOEVENT);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_WARP);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_WARP_TARGET);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_ENTER_BUILDING);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_LANDING);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_RACING_CHECK_POTINT);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_OBJECT_MONSTER);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_PATTERN_POINT);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_OBJ_BUILDING_NPC);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_LANDING_PATTERN_START);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_LANDING_PATTERN_END);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_TAKEOFF_PATTERN_START);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_TAKEOFF_PATTERN_END);
		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_OBJ_ENTER_BUILDING);
//		GET_CASERETURN_STRING_BY_TYPE(EVENT_TYPE_OBJ_LEAVE_BUILDING);
	}
	
	return "UNKNOWN_EVENT_TYPE";
}

char * GetStringBLOCKED_TYPE(int i_blocktype)
{
	switch(i_blocktype)
	{
	case T_BLOCKEDACCOUNT_UNKNOWN:				return "Unknown";				// ˼ 
	case T_BLOCKEDACCOUNT_NORMAL:				return "Normal";				// Ư  , ӽ÷
	case T_BLOCKEDACCOUNT_MONEY_RELATED:		return "Related Money";			// 
	case T_BLOCKEDACCOUNT_ITEM_RELATED:			return "Related Item";			// 
	case T_BLOCKEDACCOUNT_SPEEDHACK_RELATED:	return "Related SpeedHack";		//  
	case T_BLOCKEDACCOUNT_CHAT_RELATED:			return "Related Chatting";		// 
	case T_BLOCKEDACCOUNT_CHAT_GAMEBUG:			return "Related GameBug";		// 
	}
	return "Unknown";
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			int GetBlockTypeBYBlockTypeString(char *i_szTyString)
/// \brief		// 2008-01-30 by cmkwon,   α   - GetBlockTypeBYBlockTypeString() ߰
/// \author		cmkwon
/// \date		2008-01-30 ~ 2008-01-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
int GetBlockTypeBYBlockTypeString(char *i_szTyString)
{
	if(0 == stricmp(i_szTyString, "Unknown"))
	{
		return T_BLOCKEDACCOUNT_UNKNOWN;
	}

	if(0 == stricmp(i_szTyString, "Normal"))
	{
		return T_BLOCKEDACCOUNT_NORMAL;
	}
	if(0 == stricmp(i_szTyString, "Related Money"))
	{
		return T_BLOCKEDACCOUNT_MONEY_RELATED;
	}
	if(0 == stricmp(i_szTyString, "Related Item"))
	{
		return T_BLOCKEDACCOUNT_ITEM_RELATED;
	}
	if(0 == stricmp(i_szTyString, "Related SpeedHack"))
	{
		return T_BLOCKEDACCOUNT_SPEEDHACK_RELATED;
	}
	if(0 == stricmp(i_szTyString, "Related Chatting"))
	{
		return T_BLOCKEDACCOUNT_CHAT_RELATED;
	}
	if(0 == stricmp(i_szTyString, "Related GameBug"))
	{
		return T_BLOCKEDACCOUNT_CHAT_GAMEBUG;
	}

	return T_BLOCKEDACCOUNT_UNKNOWN;
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			char *GetStringGuildMarkState(BYTE i_byGuildMarkState, BOOL i_bForUser/*=FALSE*/)
/// \brief		
/// \author		cmkwon
/// \date		2007-08-03 ~ 2007-08-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *GetStringGuildMarkState(BYTE i_byGuildMarkState, BOOL i_bForUser/*=FALSE*/)
{
	if(FALSE == i_bForUser)
	{
		switch(i_byGuildMarkState)
		{
		case GUILD_MARK_STATE_NONE:					return "GUILD_MARK_STATE_NONE";
		case GUILD_MARK_STATE_WAITING_PERMISSION:	return "GUILD_MARK_STATE_WAITING_PERMISSION";
		case GUILD_MARK_STATE_NORMAL:				return "GUILD_MARK_STATE_NORMAL";
		}

		return "GUILD_MARK_STATE_UNKNWON";
	}

	switch(i_byGuildMarkState)
	{
	case GUILD_MARK_STATE_NONE:					return STRMSG_070802_0004;
	case GUILD_MARK_STATE_WAITING_PERMISSION:	return STRMSG_070802_0005;
	case GUILD_MARK_STATE_NORMAL:				return STRMSG_070802_0006;
	}
	return STRMSG_070802_0007;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		// 2010-04-20 by cmkwon, ű Ű ӽ  - 
/// \author		cmkwon
/// \date		2010-04-21 ~ 2010-04-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
char *GetEnchatLogTypeString(int i_nEnchantLogTy)
{
	switch(i_nEnchantLogTy)
	{
	case ENCHANT_LOGTYPE_ENCHANT_FAIL				:				return "ENCHANT_LOGTYPE_ENCHANT_FAIL";
	case ENCHANT_LOGTYPE_ENCHANT_SUCCESS			:				return "ENCHANT_LOGTYPE_ENCHANT_SUCCESS";
	case ENCHANT_LOGTYPE_ENCHANT_INIT_FAIL			:				return "ENCHANT_LOGTYPE_ENCHANT_INIT_FAIL";
	case ENCHANT_LOGTYPE_ENCHANT_INIT_SUCCESS		:				return "ENCHANT_LOGTYPE_ENCHANT_INIT_SUCCESS";
	case ENCHANT_LOGTYPE_GAMBLE_PREFIX_FAIL			:				return "ENCHANT_LOGTYPE_GAMBLE_PREFIX_FAIL";
	case ENCHANT_LOGTYPE_GAMBLE_PREFIX_SUCCESS		:				return "ENCHANT_LOGTYPE_GAMBLE_PREFIX_SUCCESS";
	case ENCHANT_LOGTYPE_GAMBLE_SUFFIX_FAIL			:				return "ENCHANT_LOGTYPE_GAMBLE_SUFFIX_FAIL";
	case ENCHANT_LOGTYPE_GAMBLE_SUFFIX_SUCCESS		:				return "ENCHANT_LOGTYPE_GAMBLE_SUFFIX_SUCCESS";
	case ENCHANT_LOGTYPE_GAMBLE_PREFIX_INIT_FAIL	:				return "ENCHANT_LOGTYPE_GAMBLE_PREFIX_INIT_FAIL";
	case ENCHANT_LOGTYPE_GAMBLE_PREFIX_INIT_SUCCESS	:				return "ENCHANT_LOGTYPE_GAMBLE_PREFIX_INIT_SUCCESS";
	case ENCHANT_LOGTYPE_GAMBLE_SUFFIX_INIT_FAIL	:				return "ENCHANT_LOGTYPE_GAMBLE_SUFFIX_INIT_FAIL";
	case ENCHANT_LOGTYPE_GAMBLE_SUFFIX_INIT_SUCCESS	:				return "ENCHANT_LOGTYPE_GAMBLE_SUFFIX_INIT_SUCCESS";
	}

	return "ENCHANT_LOGTYPE_UNKNOWN";
}

int GetEnchantLogType(ITEM *i_pEnchantItemInfo, BOOL i_bSuccessFlag)
{
	if(ITEMKIND_ENCHANT == i_pEnchantItemInfo->Kind)
	{
		if(i_pEnchantItemInfo->IsExistDesParam(DES_ENCHANT_INITIALIZE))
		{
			return (FALSE == i_bSuccessFlag) ? ENCHANT_LOGTYPE_ENCHANT_INIT_FAIL : ENCHANT_LOGTYPE_ENCHANT_INIT_SUCCESS;
		}
		return (FALSE == i_bSuccessFlag) ? ENCHANT_LOGTYPE_ENCHANT_FAIL : ENCHANT_LOGTYPE_ENCHANT_SUCCESS;
	}

	if(i_pEnchantItemInfo->IsExistDesParam(DES_RARE_FIX_PREFIX_INITIALIZE))
	{
		return (FALSE == i_bSuccessFlag) ? ENCHANT_LOGTYPE_GAMBLE_PREFIX_INIT_FAIL : ENCHANT_LOGTYPE_GAMBLE_PREFIX_INIT_SUCCESS;
	}
	if(i_pEnchantItemInfo->IsExistDesParam(DES_RARE_FIX_SUFFIX_INITIALIZE))
	{
		return (FALSE == i_bSuccessFlag) ? ENCHANT_LOGTYPE_GAMBLE_SUFFIX_INIT_FAIL : ENCHANT_LOGTYPE_GAMBLE_SUFFIX_INIT_SUCCESS;
	}

	if(i_pEnchantItemInfo->IsExistDesParam(DES_RARE_FIX_PREFIX))
	{
		return (FALSE == i_bSuccessFlag) ? ENCHANT_LOGTYPE_GAMBLE_PREFIX_FAIL : ENCHANT_LOGTYPE_GAMBLE_PREFIX_SUCCESS;
	}
	if(i_pEnchantItemInfo->IsExistDesParam(DES_RARE_FIX_SUFFIX))
	{
		return (FALSE == i_bSuccessFlag) ? ENCHANT_LOGTYPE_GAMBLE_SUFFIX_FAIL : ENCHANT_LOGTYPE_GAMBLE_SUFFIX_SUCCESS;
	}

	return ENCHANT_LOGTYPE_UNKNOWN;
}