// AtumApplication.cpp: implementation of the CAtumApplication class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "Frustum.h"
#include "AtumApplication.h"
#include "time.h"
#include <stdio.h>
#include "AtumProtocol.h"
#include "ChatMoveData.h"
#include <fcntl.h>
#include "ObjectChild.h"
#include "RainData.h"
#include "shellapi.h"

#include <D3DUtil.h>
#include "D3DFont.h"
#include "DXUtil.h"
#include "dsutil.h"
#include "KeyBoardInput.h"
#include "Camera.h"
#include "UnitRender.h"
#include "CharacterRender.h"				// 2005-07-21 by ispark
#include "D3DHanFont.h"
// 2008-11-13 by bhsohn ̽ƽ ۾
#include "JoyStickInput.h"					
#include "JoyStickFreedback.h"
// end 2008-11-13 by bhsohn ̽ƽ ۾

// 2007-11-22 by bhsohn Ʒ ռ
#include "FieldWinSocket.h"
#include "FieldWinSocketManager.h"
#include "IMSocket.h"
#include "IMSocketManager.h"

#include "ShuttleChild.h"
#include "CharacterChild.h"					// 2005-07-21 by ispark
#include "ChatRender.h"
#include "Chat.h"
#include "WeaponFastData.h"
#include "WeaponMissileData.h"
#include "WeaponRocketData.h"
//#include "WeaponMonsterData.h"
#include "WeaponMineData.h"
#include "WeaponFireData.h"
#include "AppEffectData.h"
//#include "WeaponBundleData.h"
#include "InitThread.h"
#include "MapInitThread.h"
//#include "TraceRender.h"
#include "ItemData.h"
#include "objectDefine.h"
#include "EffectRender.h"
#include "Interface.h"
#include "AbuseFilter.h"
#include "Weapon.h"
#include "Skill.h"
#include "SkillInfo.h"
#include "ClientParty.h"

// remodeling, 2004-03-19 by dhkwon
#include "AtumSound.h"
// 2012-10-22 by jhjang  ٿ ڰ    ý ߰
#include "MusicMP3Ex.h"
// end 2012-10-22 by jhjang  ٿ ڰ    ý ߰

#include "SceneData.h"
#include "AtumDatabase.h"
#include "UnitData.h"	// shuttle, enemy  
#include "INFStageEffect.h"


#include "INFWindow.h"
#include "INFGameMain.h"
#include "INFSelect.h"
#include "INFCityBase.h"
#include "MonsterData.h"
#include "EnemyData.h"
#include "StoreData.h"
#include "INFTrade.h"
#include "INFCommunity.h"
#include "INFCommunityParty.h"
#include "INFCityWarp.h"
#include "INFMapLoad.h"
// 2008-09-22 by bhsohn EP3 ĳ â
//#include "INFCharacterInfo.h"
#include "INFCharacterInfoExtend.h"
#include "INFCommunityGuild.h"
#include "INFChannelList.h"
#include "QuestData.h"
//#include "INFShop.h"
#include "INFCreateMenu.h"
#include "INFSelectBack.h"
#include "INFGameMainUnitInfoBar.h"
#include "RangeTime.h"
#include "INFUnitState.h"
//#include "INFNotice.h"
#include "INFCityShop.h"
#include "INFGameMainChat.h"
#include "Background.h"
#include "ETCRender.h"
#include "ItemInfo.h"
#include "RangeTime.h"
#include "INFInven.h"
#include "AtumError.h"
#include "INFCityLab.h"
#include "WeaponItemInfo.h"
#include "INFCityStore.h"
#include "VoipParam.h"
#include "VoipError.h"
#include "INFGameHelpDesk.h"
#include "INFCitySkillShop.h"
#include "TickTimeProcess.h"
#include "SkillEffect.h"
#include "INFCommunityFriend.h"
#include "INFCommunityReject.h"
#include "INFSkill.h"
#include "INFGameCountDown.h"
#include "Cinema.h"
#include "INFDamageView.h"
#include "INFFadeEffect.h"
#include "INFCityAuction.h"
#include "INFCityMission.h"
#include "FxSystem.h"
#include "INFUnitNameInfo.h"
#include "PkNormalTimer.h"
#include "INFCityOccupy.h"
#include "INFCityCashShop.h"
#include "INFOtherCharInfo.h"
#include "INFMp3Player.h"
#include "TutorialSystem.h"
#include "INFGameMainMiniMap.h"
#include "INFTarget.h"
#include "ImageManager.h"
#include "InputManager.h"
#include "CInput.h"
#include "GlobalImage.h"
#include "INFMissionInfo.h"
#include "INFCityBoard.h"
#include "INFCityBazaar.h"
#include "CharacterInfo.h"
#include "INFCityArena.h"
#include "INFGameArena.h"
#include "INFCityWarPointShop.h"

//  .
#include "INFCityOutPost.h"
#include "INFGameMainOutPost.h"
#include "INFCityLeader.h"

#include "INFToolTip.h"
#include "INFOpMain.h"

#include "INFChangeCharactor.h"

// 2007-11-22 by bhsohn Ʒ ռ
#include "ArenaManager.h"

// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
#include "INFCommunityLetter.h"
#include "INFCommuPartyCre.h"
#include "INFCommunityGuildManager.h"
#include "INFCommunityGuildSearch.h"
#include "INFCommuPartyInvite.h"
#include "INFCommunityChatRoom.h"

#include "INFListBox.h"

// 2008-08-11 by bhsohn ܵ  ǰԲ
#include "SinglePlayGame.h"
// 2008-11-04 by dgwoo LuckyMachineȹ ߰.
#include "INFLuckyMachine.h"

// 2009-01-22 by bhsohn Xign Code ϴ   ߰
//#include "zwave_sdk_client.h"	// 2008-11-28 by bhsohn XignCode߰

#include "INFMissionMain.h"     // 2008-12-09 by dgwoo ̼Ǹ.



// 2009. 01. 12 by ckPark   ý

#include "CalendarBuilder.h"
#include "INFMotherShipManager.h"

// end 2009. 01. 12 by ckPark   ý

#include "WorldRankManager.h"		// 2009-02-13 by bhsohn  ŷ ý


// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
#include "InfinityManager.h"
#include "INFInfinity.h"
#include "INFWindow.h"
#include "INFCityInfinityField.h"
#include "INFCityInfinityShop.h"
// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý

#include "INFOptionMachine.h"

// 2009. 11. 23 by jskim ҽ ε  
#include "MeshInitThread.h"

#define LOAD_TIME_CHECK 5
// 0.005 ʸ ε ޽ ִ üũѴ.
//end 2009. 11. 23 by jskim ҽ ε  
// 2010-06-15 by shcho&hslee ý - ŷ    
#include "PetManager.h"
// end 2010-06-15 by shcho&hslee ý - ŷ    

// 2010-08-31 by shcho&&jskim,  ý 
#include "INFDissolution.h"
// end 2010-08-31 by shcho&&jskim,  ý 

// 2010. 10. 05 by jskim ʷε  
#include "MapLoad.h"
// end 2010. 10. 05 by jskim ʷε  


#include "CustomOptimizer.h"

#include "textures.h"
#include "dshowtextures.h"

// 2011. 1. 18 by jskim Ʈ VTC
#include "VTCThread.h"
// end 2011. 1. 18 by jskim Ʈ VTC

#include "zwave_sdk_client.h"	  // 2012-10-13 by jhahn ٽ->Xigncode

#include "INFMenuList.h"	// 2012-07-12 by isshin ۹̸ On / Off  -  

#define _TIMER_ALIVE (WM_USER_BASE + 5)
#define _TIMER_MOVE (WM_USER_BASE + 6)

#define REG_CHAT_VIEW_COUNT			37

//#define SLEEP_TIMER_TEMP					4.0f

// 2006-06-05 by ispark
int __stdcall HS_MainCallbackProc ( long lCode, long lParamSize, void* pParam );
// 2012-10-13 by jhahn ٽ->Xigncode
xstatus XCALL MyUserInfoCallback(xuint iid,xstr buffer,xsize size, xpvoid context);
xbool CALLBACK AceOnlineXigncodeCallback(ULONG Code , ULONG W , PVOID L , PVOID Context); // 2012-10-17 by bhsohn XignCode۾
#define				GAME_GUARD_FOLDER		"Xigncode"
//end 2012-10-13 by jhahn ٽ->Xigncode
//////////////////////////////////////////////////////////////////////
// ũ  ȣ ڵ
// ydkim 2004.06.12
//////////////////////////////////////////////////////////////////////

#define XOR_ENCODE_SCREENSHOT_60BYTE		"5%$#djfnskdnf%l10d5fn*^%$djfner20dn&^%fjesdas0$^&%sdwfvvskdi56*$%$#"

// 2012-03-21 by hskim, ٽ  ߰ [ڵ Ʈ/ɼ ߰/͸ ý]
#include "ConfigHackShield.h"
// 2012-03-21 by hskim, ٽ  ߰ [ڵ Ʈ/ɼ ߰/͸ ý]

// 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)
#if defined(LANGUAGE_VIETNAM)
		#define XTRAP_LICENCE_CODE					XTRAP_KEY_STRING
#endif
// 2010. 11. 05 by jskim Ӱ  (ƸƼ)
#if defined(LANGUAGE_ARGENTINA)
		#define XTRAP_LICENCE_CODE					XTRAP_KEY_STRING
#endif
// end 2010. 11. 05 by jskim Ӱ  (ƸƼ)
//end 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)

// 2007.04.24 by bhsohn China IME Working
#define IME_POS_SELECT_X						(g_pD3dApp->GetBackBufferDesc().Width /2 +165)
#define IME_POS_SELECT_Y						(g_pD3dApp->GetBackBufferDesc().Height - 127)

#define IME_POS_CREATE_X						(g_pD3dApp->GetBackBufferDesc().Width /2 + 112)
#define IME_POS_CREATE_Y						(g_pD3dApp->GetBackBufferDesc().Height - 127)

#define IME_POS_GAME_X							((g_pD3dApp->GetBackBufferDesc().Width - 254)/2)+26
#define IME_POS_GAME_Y							(g_pD3dApp->GetBackBufferDesc().Height - 70)

// 2007-05-21 by bhsohn China IME Working
#define IME_TYPE_SHOW_TIME						30

// 2008-01-11 by bhsohn 1е  Ŭ̾Ʈ ߰ ϸ Ŭ̾Ʈ  
#ifdef LANGUAGE_CHINA
	#define TIME_COMPULSION_CAP						30000.0f	// 60*1000(ms) = 60000(ms)
#else
	#define TIME_COMPULSION_CAP						60000.0f	// 60*1000(ms) = 60000(ms)
#endif


// 2008-01-16 by bhsohn 1ʵ  Ŭ̾Ʈ ߰,  Ŷ 
#define TIME_MOVE_CAP							1000.0f		// 1*1000(ms) = 1000(ms)

// 2008-06-20 by bhsohn EP3 ɼǰ ó
#define WND_LOCK_PIXEL_CAP							10		//   ȼ

// 2008-11-13 by bhsohn ̽ƽ ۾
// Ʈ üũ ð
#define	JOYSTICK_CHECK_TIME							0.033f		// 1000/30() = 33(ms) = 0.033f
//  ð
#define	JOYSTICK_FEED_TIME							2.50f		// 


// 2009-01-22 by bhsohn Xign Code ϴ   ߰
////////////////////////   ////////////////////////
//
// #define		USE_GAMEGUARD_NONE					0		//Ӱ 
// #define		USE_GAMEGUARD_AHNLAB_HACKSHIELD		1		//ٽ Ӱ
// #define		USE_GAMEGUARD_XIGNCODE				2		//Xign Ӱ
// 
// #if defined(TAIWAN_RELEASE)	
// 	// XIGNCode
// 	#define		GAMEGUARD_TYPE					USE_GAMEGUARD_XIGNCODE
// // 2008-12-04 by bhsohn Japan Working
// #elif defined(LANGUAGE_RUSSIA) || defined(LANGUAGE_JAPAN) || defined(_DEBUG) || defined(GAMEFORGE_RELEASE)
// 	// Ӱ 
// 	#define		GAMEGUARD_TYPE 					USE_GAMEGUARD_NONE
// #else
// 	// ٽ
// 	#define		GAMEGUARD_TYPE					USE_GAMEGUARD_AHNLAB_HACKSHIELD		
// #endif
// 2009-01-22 by bhsohn Xign Code ϴ   ߰
#if defined(DEFINE_USE_GAMEGUARD_XIGNCODE)	
	#include "zwave_sdk_client.h"	// XignCode߰
#endif
// end 2009-01-22 by bhsohn Xign Code ϴ   ߰

// 2009-01-28 by bhsohn nProtector   ߰
#define		GAME_GUARD_nPROTECTOR_CHECK_TIME		(10.0f)
// end 2009-01-28 by bhsohn nProtector   ߰
	// 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)
#define		GAME_GUARD_XTRAP_CHECK_TIME				(60.0)   // 60 
	//end 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)

// 2009-02-03 by bhsohn ũ  
#define SCREENSHOT_FILE_PATH			".\\ScreenShot\\"	
// end 2009-02-03 by bhsohn ũ  


// 2012-11-07 by bhsohn Ʈ Ŷ ó
#define CLIENT_LIVE_CHECK_TIME			1.0f
#define MAX_CLIENT_LIVE_TIME			3.0f
// END 2012-11-07 by bhsohn Ʈ Ŷ ó

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
LPDIRECT3DDEVICE9		g_pD3dDev = NULL;	// D3D̽ü PTR
CAtumApplication    *	g_pD3dApp = NULL;
CAtumSJ				*	g_pAtumSJ = NULL;
sOPTION_SYSTEM		*	g_pSOption = NULL;
sOPTION_CHARACTER	*	g_pSOptionCharacter = NULL;
PROCESS_INFORMATION		g_infoAssistProcess;
// 2008-06-20 by bhsohn EP3 ɼǰ ó
sOPTION_ETC*			g_pSOptionEtc = NULL;
// 2008-11-13 by bhsohn ̽ƽ ۾
structJoyStickOptionInfo*		g_pJoysticOp = NULL;

CSceneData				*g_pScene = NULL;
CShuttleChild			*g_pShuttleChild = NULL;
CCharacterChild			*g_pCharacterChild = NULL;
CAtumDatabase			*g_pDatabase = NULL;
CInterface				*g_pInterface = NULL;
CINFGameMain			*g_pGameMain = NULL;
CStoreData				*g_pStoreData = NULL;
CQuestData				*g_pQuestData = NULL;
CCamera					*g_pCamera = NULL;
CBackground				*g_pGround = NULL;
// 2007-11-22 by bhsohn Ʒ ռ
//CFieldWinSocket			*g_pFieldWinSocket = NULL;
//CIMSocket				*g_pIMSocket = NULL;
CFieldWinSocketManager			*g_pFieldWinSocket = NULL;
CIMSocketManager				*g_pIMSocket = NULL;

CINFSelect				*g_pSelect = NULL;
CINFChannelList			*g_pChannelList = NULL;
CFrustum				*g_pFrustum = NULL;
CTutorialSystem			*g_pTutorial = NULL;
CImageManager			*g_pImgManager = NULL;
CInputManager			*g_pInputManager = NULL;
CInput					g_input;
CGlobalImage			*g_pGImage;

float					g_fSendMovePacket = 0;
BOOL					g_bDetailDrawFrame = FALSE;
BOOL					g_bEventRecovery = FALSE;
float					g_fEventRecoveryRate = 0;
ATUM_DATE_TIME			g_ServerDateTime;			// 2006-10-11 by ispark,  ð
int						g_GameStartTime = 0;		// 2006-10-11 by ispark,   ð
// 2009. 08. 19 by jsKim   ޴   Ŀ  ʴ 
// 2012-12-17 by jhjang  콺 Ŀ   ʴ  
//int						g_INFCnt = 0;
// end 2012-12-17 by jhjang  콺 Ŀ   ʴ  
// end 2009. 08. 19 by jsKim   ޴   Ŀ  ʴ 
// 2009. 09. 10 by jsKim Ʒ Խ  ī  
ATUM_DATE_TIME			g_ArenaServerDateTime;		
int						g_ArenaStartTime = 0;		
// end 2009. 09. 10 by jsKim Ʒ Խ  ī  
#ifdef _DEBUG

int						g_nMoveCountPerRate;
int						g_nMoveCountPerPacket;
float					g_fMoveCountFrame;
DWORD					g_dwDebugFogColor = D3DCOLOR_ARGB(0,205,210,180);
float					g_pDebugFogStartDistance = 1000.0f;
float					g_pDebugFogEndDistance = 5000.0f;
D3DXVECTOR3				g_vDebugLightDirection = D3DXVECTOR3(1,-0.5,1);

int						g_nMissileCount = 0;
#endif // _DEBUG_endif
int						g_nRenderCandidate = SET_MAIN_CHAT_CANDIDATE;		// IME ĺƮ  ġ


LPDIRECT3DVERTEXBUFFER9 g_pVB        = NULL; // Buffer to hold vertices


CComPtr<IGraphBuilder>  g_pGB;          // GraphBuilder
CComPtr<IMediaControl>  g_pMC;          // Media Control
CComPtr<IMediaPosition> g_pMP;          // Media Position
CComPtr<IMediaEvent>    g_pME;          // Media Event
CComPtr<IBaseFilter>    g_pRenderer;    // our custom renderer



struct ArenaTeamInfo
{
	template<typename T>
		BOOL operator()(const T pPtr1, const T pPtr2)
	{
		if(pPtr1.ArenaMode < pPtr2.ArenaMode)
		{
			return TRUE;
		}
		else if(pPtr1.ArenaMode == pPtr2.ArenaMode)
		{
			if(pPtr1.Level < pPtr2.Level)
			{
				return TRUE;
			}
			else if(pPtr1.Level == pPtr2.Level)
			{
				if(pPtr1.MemberCount < pPtr2.MemberCount)
				{
					return TRUE;
				}
				else if(pPtr1.MemberCount == pPtr2.MemberCount)
				{
					if(pPtr1.TeamCount < pPtr2.Level)
					{
						return TRUE;
					}
				}
			}
		}
		
		return FALSE;
	}
};

CAtumApplication::CAtumApplication()
{
#ifdef _FUNCTION_LOG
	GInitFunctionLogSharedMemory();
	STARTUPINFO si = {sizeof(si)};
	CreateProcess(NULL,"atumassist.exe", NULL,NULL,0,0,NULL,NULL,&si,&g_infoAssistProcess);
	SetFocus(GetHwnd());
#endif //_FUNCTION_LOG_endif
	g_pD3dApp = this;
    srand( (unsigned)time( NULL ) );
	m_strWindowTitle	= _T(WINDOWTEXT_NAME_CLIENT);		// ø̼ ŸƲ
    m_dwCreationWidth   = 800;
    m_dwCreationHeight  = 600;
	m_bUseDepthBuffer   = TRUE;						// ̹ ̿

	m_pFontDebug = NULL;
	m_pKeyBoard = NULL;

	// 2008-11-13 by bhsohn ̽ƽ ۾
	m_pJoyStick = NULL;				// ̽ƽ 	
	m_fJoyStickCheckTime = 0.0f;	

	m_pJoyStickFreedback = NULL;
	m_fJoyStickFeedbackPlayTime = 0.0f;

	m_nJoyStickFeedbackType =-1;
	m_nJoyContorlLen = 0;
	int nJoyCnt = 0;
	for(nJoyCnt = 0;nJoyCnt < MAX_JOYCTL_LIST;nJoyCnt++)
	{
		memset(m_chJoystickCtrlList[nJoyCnt], 0x00, MAX_PATH);
	}
	
	// end 2008-11-13 by bhsohn ̽ƽ ۾

	m_pCamera = NULL;
	m_fElapsedTime = 0.0;
//	m_pShuttleRender = NULL;
	m_pUnitRender = NULL;
	m_pShuttleChild = NULL;
	memset(m_strChat,0x00,SIZE_MAX_CHAT_MESSAGE);

	m_pFontInput = NULL;
	m_pChat = NULL;
	m_bChatMode = FALSE;
	m_bFixUnitDirMode = FALSE;
	m_bMessageBox	= FALSE;
	m_pVBSleep = NULL;
// 2012-07-17 by jhahn, ˴ٿ ð ǥ
	FristSeting = FALSE;
	nCount = 1;

	nOldTime = NULL;	
	nNewTime = NULL;
//end 2012-07-17 by jhahn, ˴ٿ ð ǥ
	memset(m_strFieldIP,0x00,sizeof(m_strFieldIP));
	m_nFieldPort = 6003;

	m_pFieldWinSocket = NULL;
	m_bReconnectFieldServer = FALSE;
	m_pIMSocket = NULL;

	m_bOtherFieldWarping = FALSE;

	CFieldWinSocket::SocketInit();

//	m_pInitThread = NULL;
	m_pMapInitThread = NULL;
//	m_bInitializing = TRUE;
	//////////////// weapon ////////////////////
///	m_pWeaponData = NULL;

	InitializeCriticalSection(&m_cs);
	m_pData = NULL;

	m_dwCursor = IDC_CURSOR_YELLOW;
	m_dwIcon = IDI_ICON1;
	m_bShowCursorWhenFullscreen = TRUE;
	m_bShowCursor = FALSE;

	m_vClientOldPos = D3DXVECTOR3(0,0,0);
//	m_dwCurTickTime = 0;
	m_dwSpeedHackTimer = 0;
	m_nCheckRenderPos = 0;
	m_fRenderDeleteCheckTime = 10.0f;

//	m_pItemData = NULL;

	m_nItemStorage = ITEM_IN_CHARACTER;//â,â 

//	m_hWndAtumVoIPClient = NULL;
//	m_bReadyVoIP = FALSE;
//	m_bRinging = 0;
//	m_dwVOIPState = _VOIP_NOTLOGIN;
	memset( &m_VOIPState, 0x00, sizeof(m_VOIPState) );
	m_VOIPState.nVOIPState = _VOIP_ERRORSTATE; //  Ϸÿ  · 

	m_pEffectRender = NULL;// by dhkwon 2003.5.16


	m_fCheckSocketTime = 10.0f;
	m_fOldTickTime = 0.1f;
	m_fReturnKeyTime = 0.2f;

	m_pEffectList = NULL;

	m_bDebugText = FALSE;

	m_bClientQuit = FALSE;
	// 2012-12-21 by bhsohn Ʈ   ȵǴ  ذ
	m_bClientLogOff = FALSE;
	// END 2012-12-21 by bhsohn Ʈ   ȵǴ  ذ

	m_bResCheck = FALSE;

	m_bReadyBeginScene = FALSE;

//	m_hHangulDC = NULL;
//	MakeArrayLevelExperience(m_ArrayLevelExperience);

	m_bDeleteItemSend = FALSE;

	m_pInterface = NULL;
//	m_pAtumIntro = NULL;
	m_IsFullMode = 0;
	m_pAbuseFilter = NULL;
	m_pAbuseFilterData = NULL;
//	m_pHelpData = NULL;
	m_nInvalidClientIndexCont = 0;
	m_fBattleCountCheckTime = -1.0f;
	m_nBattlePartyCount = 0;

	// 2007-04-05 by dgwoo  High  ׸Ѵ.
	m_bDegree = 2;

	memset(m_strDebug,0x00,sizeof(m_strDebug));

	g_pSOption = NULL;
	g_pSOptionCharacter = NULL;
	m_pd3dxSprite= NULL;

	// 2008-06-20 by bhsohn EP3 ɼǰ ó
	g_pSOptionEtc = NULL;

	// 2008-11-13 by bhsohn ̽ƽ ۾
	g_pJoysticOp = NULL;
	// end 2008-11-13 by bhsohn ̽ƽ ۾

//	m_fDebugCheckValue = 0.0f;

//	memset(m_strHelp,0x00,100*128);
//	m_nHelpNum = 0;
//	m_nHelpCurCont = 0;
//	m_pHelpData =NULL;

//	m_nCurrentUserNum = 0;
	m_fUserCheckTime = 10.0f;
	memset(m_strSeverUserNum,0x00,sizeof(m_strSeverUserNum));
	memset(m_strMapUserNum,0x00,sizeof(m_strMapUserNum));

	// 2012-11-07 by bhsohn Ʈ Ŷ ó
	m_fServerLiveTime = 20.0f;
	// END 2012-11-07 by bhsohn Ʈ Ŷ ó

	// remodeling, 2004-03-19 by dhkwon
	m_pSound = NULL;
	m_pScene = NULL;
	m_pDatabase = NULL;
	ChangeGameState(_INIT); // SLEEP   
//	m_pTraceRender = NULL;

	m_bReadyToGetGuildInfo = FALSE;
	// 2007-01-07 by bhsohn   ȭ   ó
	m_bReadyFieldGameStartOk = FALSE;

	m_pStageEffect = NULL;
	m_pQuestData = NULL;

	// 2004-11-11 by jschoi
	m_nCheckSpeedHackCount = 0;
	m_dwCheckSpeedHackTime = 0;
	m_nSendMovePacketCount = 0;

	m_pFxSystem = new CFxSystem;

	// 2005-02-21 by jschoi - 
	m_bWeb = FALSE;

	// 2007-11-27 by bhsohn ׽Ʈ  
	m_bTestServerDefine = FALSE;

#ifdef _TEST_SERVER
	m_bTestServer = FALSE;				// ĳ 
	// 2007-11-27 by bhsohn ׽Ʈ  
	m_bTestServerDefine = TRUE;
#else
	m_bTestServer = FALSE;				// ĳ 
#endif

	// 2005-02-18 by jschoi - Premium Card Info 
	// 2005-03-18 by jschoi - 
	memset(&m_PremiumCardInfo,0x00,sizeof(MSG_FC_CHARACTER_CASH_PREMIUM_CARD_INFO));

	m_bRequestEnable = TRUE;	//  û  ΰ?
	m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;


	// 2005-03-25 by jschoi
	m_dwTargetting = OLD2_TARGETTING;	
	
//	m_bLoading = TRUE;
	
//#ifdef _DEBUG
//	m_nDebugTimerMove = 0;
//	m_fDebugTimerCheckTime = 0;
//#endif

	// 2005-03-31 by jschoi
	m_pTutorial = new CTutorialSystem;
//	m_pImgManager = new CImageManager;

	// 2005-05-13 by jschoi
	m_pInputManager = new CInputManager;

	// 2005-05-12 by jschoi
	m_bDeadByP2PPK = FALSE;
	m_vecStingCandidate.clear();
	for(int i=0; i<CHAR_INF_CANDIDATE; i++)
		m_pFontCandidate[i] = NULL;
	m_bCharacter = FALSE;						// ó ü ʱ  Ѵ.
	m_pCharacterChild = NULL;
	ZERO_MEMORY(m_strFont);

	// 2007.04.24 by bhsohn China IME Working
	m_pFontCompositon = NULL;
	m_pFontIMEType = NULL;

	m_nDephbias = -1;							// ʱȭ -1 
	m_nArmorNum = 0;
	m_nArmorNumMax = 0;

	m_dwHackCheckTime = 0;	// 2005-12-21 by ispark
	m_dwMoveCheckTime = 0;	// 2006-01-10 by ispark
	m_vShuttleOldPos = D3DXVECTOR3(0, 0, 0);

	m_bShutDown = FALSE;						// 2006-07-05 by ispark
	memset(m_strMsgLastError, 0x00, sizeof(m_strMsgLastError));
#ifdef _DEBUG
	m_bEventObjectRender = FALSE;
#endif

	m_bBazaar = FALSE;
	m_bGameShutDown	= FALSE;
	m_fGameShutDownTime = 0.0f;

	m_bCheckQuickSlotSave = FALSE;
	// 2007-02-12 by bhsohn Ŀ Ҿ Ծ   ó
	m_fCheckElapsedTime		= 0.0f;
	m_dwCurrentTime		= 0;
	// end 2007-02-12 by bhsohn Ŀ Ҿ Ծ   ó

	// 2007-02-12 by bhsohn Item   ó
	DelMultiItemList();	
	m_bCtrlBtnClick = FALSE;
	m_bStartMultiSell = FALSE;
	m_bStartMultiStore = FALSE;
	// end 2007-02-12 by bhsohn Item   ó

	// 2007-02-28 by bhsohn  ǸŽ 0 spi  ó
	memset(&m_struLastSelMultiItem, 0x00, sizeof(stMultiSelectItem));

	// 2007-04-09 by bhsohn   ǥ  ó
	memset(m_strConnectSeverName, 0x00, 1024);	
	
	// 2007.04.24 by bhsohn China IME Working
	memset(m_szReadingString, 0x00, 1024);	
	memset(m_szImeString, 0x00, 1024);	
	
	// 2007-05-21 by bhsohn China IME Working
	m_fIMETypeShowTime = IME_TYPE_SHOW_TIME;	

	// 2007-07-10 by bhsohn  Ÿ   ó
	m_nPreComType = 0;
	m_nPreIMComType = 0;	
	m_bInputItemDone = FALSE;

	// 2007-07-24 by bhsohn ̼ mp3߰
	memset(&m_chNarrationSound, 0x00, 256);		
	// 2009. 01. 22 by ckPark  º ۷ MP3 и
	memset(&m_chErNarrationSound, 0x00, 256);			

	m_bInfregular = TRUE;

	// 2007-08-03 by bhsohn ĳ Ʈ üũ 
	m_vecSendCharacterOmiInfo.clear();

	// 2007-09-12 by bhsohn 2 ȣ ý 
	m_bIsUseSecondaryPasswordSystem = FALSE;	// ý  
	m_bIsSetSecondaryPassword = FALSE;		// ȣ ߴ 
	// end 2007-09-12 by bhsohn 2 ȣ ý 

	// 2008-07-07 by bhsohn 2 н Ȱȭ, κ ȿ 
	m_bSecondPassLock = FALSE;
	// end 2008-07-07 by bhsohn 2 н Ȱȭ, κ ȿ 

	// 2007-10-30 by dgwoo   ð  ѹ ش.
	m_bResortingItem = TRUE;

	// 2007-11-20 by bhsohn ʷε ϴ  
	memset(&m_struGameStartInfo, 0x00, sizeof(stGameStartInfo));
	m_bGameStartInfo = FALSE;		

	// 2007-12-21 by bhsohn α׷    
	InitMultiLockInfo();

	// 2008-01-11 by bhsohn 1е  Ŭ̾Ʈ ߰ ϸ Ŭ̾Ʈ  
	m_dwLastestTickTime = 0;

	// 2007-11-22 by bhsohn Ʒ ռ
	m_pArenaManager = new CArenaManager;

	// 2008-02-15 by bhsohn Ʈũ ӵ üũ
	memset(&m_stNetCheckInfo, 0x00, sizeof(structNetCheckInfo));

	// 2008-06-20 by bhsohn EP3 ɼǰ ó
	m_fMouseLockTime = 0.0f;
	m_bWndMoving = FALSE;
	m_nOnFriendCount = 0;

	// 2008-08-11 by bhsohn ܵ  ǰԲ
	m_pSinglePlayGame = new CSinglePlayGame();	

	// 2008-08-18 by bhsohn 1   ̵ ý 	
	m_bSendTerm = FALSE;
	m_dwSendTermTime = 0;
	// 2009-01-28 by bhsohn nProtector   ߰	
#if defined(DEFINE_USE_GAMEGUARD_NPROTECTOR)	
	m_pNpgl = NULL;
	m_fnProtectorHackCheckTime = GAME_GUARD_nPROTECTOR_CHECK_TIME;
#endif
	// end 2009-01-28 by bhsohn nProtector   ߰	

	// 2009-02-13 by bhsohn  ŷ ý
	m_pWorldRankManager = new CWorldRankManager();

	// 2009. 11. 24 by ckPark 巩ŷ 밡 ϵ 
// #if defined(LANGUAGE_KOREA)
// 	#ifndef YEDANG_RELEASE
// 		m_pWorldRankManager->SetUseWorldRanking(TRUE);
// 	#endif
// #endif

	m_pWorldRankManager->SetUseWorldRanking( TRUE );
	// end 2009. 11. 24 by ckPark 巩ŷ 밡 ϵ 


	// end 2009-02-13 by bhsohn  ŷ ý

	// 2009-04-08 by bhsohn  ý, ũ  æƮ   ǸŽ  ޽  ȹ (K0000174)
	memset(&m_stMultiWarningSelItem, 0x00, sizeof(stMultiSelectItem));
	// end 2009-04-08 by bhsohn  ý, ũ  æƮ   ǸŽ  ޽  ȹ (K0000174)

	// 2009. 06. 09 by ckPark OMI  ۽ üũ ϵ 
	memset( m_nOMICheckSum, 0, sizeof(m_nOMICheckSum) );
	m_nOMIFileSize = 0;
	// end 2009. 06. 09 by ckPark OMI  ۽ üũ ϵ 

	// 2010. 03. 12 by ckPark Interface.tex üũ ߰
	memset( m_nInterfaceCheckSum, 0, sizeof( m_nInterfaceCheckSum ) );
	m_nInterfaceFileSize	= 0;
	// end 2010. 03. 12 by ckPark Interface.tex üũ ߰
	
	// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	m_pInfinityManager		= new CInfinityManager;
	m_ArenaSocketType		= ARENASOCKET_NONE;		// Ʒ  Ÿ
	m_bInfinityMapload		= FALSE;
	m_bEnterInfinityAllowed	= FALSE;				// ǴƼ  㰡
	m_bInfinityRestart		= FALSE;
	m_bAddInfinityRestartMessageBox	= FALSE;
	// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý


	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	m_bWaitInfinityMapLoad	= FALSE;

	m_nInfinityMapLoadTime	= 0;

	memset( &m_ArenaStartPacket, 0, sizeof( MSG_FC_ARENA_POSSIBLE_GAMESTART ) );
	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)


	// 2010. 03. 23 by ckPark ǴƼ ʵ 2(ǴƼ ʵ  ĳ)
	m_bInfinityMapLoadedSendEnable	= FALSE;
	m_bInfinitySkillSetupOKDone		= FALSE;
	// end 2010. 03. 23 by ckPark ǴƼ ʵ 2(ǴƼ ʵ  ĳ)


	// 2009. 11. 03 by ckPark ± APEX Ӱ ۾
	#if defined( DEFINE_USE_GAMEGUARD_APEX )
	m_pApexfp_rec = NULL;
	#endif
	// end 2009. 11. 03 by ckPark ± APEX Ӱ ۾

	// 2009. 11. 23 by jskim ҽ ε  
 	m_dwTimeCheck		= timeGetTime();	
	m_pMeshInitThread	= new CMeshInitThread;
	m_pMeshInitThread->CreateThread();
	m_pLoadingGameData = NULL;
	//end 2009. 11. 23 by jskim ҽ ε  
    // 2010. 10. 05 by jskim ʷε  
	m_pMaploading	   = new CMapLoad;		 
    // end 2010. 10. 05 by jskim ʷε  
	// 2011. 10. 10 by jskim UIý 
	m_pImageList  = new CINFImageList;
	// end 2011. 10. 10 by jskim UIý 

	// 2011. 1. 18 by jskim Ʈ VTC
	m_fnVTCDLLInit		= NULL;
	m_fnVTCDLLGetStatus	= NULL;
	m_fnVTCDLLSetUser	= NULL;
	m_fnVTCDLLExit		= NULL;
	// end 2011. 1. 18 by jskim Ʈ VTC
   	m_vecWearDisplayInfo.clear();	// 2012-06-14 by isshin ۹̸
	// 2012-12-17 by jhjang  콺 Ŀ   ʴ  
	m_nINFCnt = 0;
	// end 2012-12-17 by jhjang  콺 Ŀ   ʴ  

	// 2012-11-29 by mspark, ġ ġ ̵ϴ ĳ ġ ϵ 
	m_nItemNum = 0;
	// end 2012-11-29 by mspark, ġ ġ ̵ϴ ĳ ġ ϵ 
	m_bIsTestServerConnect = FALSE;	// 2012-11-28 by jhjang ׼   ó ߰
	m_nDBSid = 0;
}

CAtumApplication::~CAtumApplication()
{
	FLOG( "~CAtumApplication()" );
	// 2008-08-11 by bhsohn ܵ  ǰԲ
	SAFE_DELETE(m_pSinglePlayGame);

	// 2007-11-22 by bhsohn Ʒ ռ
	SAFE_DELETE(m_pArenaManager);	 

	CFieldWinSocket::SocketClean();

	SAFE_DELETE( m_pFxSystem );
	SAFE_DELETE( m_pTutorial );
	SAFE_DELETE( m_pInputManager );
//	SAFE_DELETE( m_pImgManager );
	
	for(int i=0; i<CHAR_INF_CANDIDATE; i++)
		SAFE_DELETE(m_pFontCandidate[i]);

	// 2007.04.24 by bhsohn China IME Working
	SAFE_DELETE(m_pFontCompositon);
	SAFE_DELETE(m_pFontIMEType);	 

	m_vecCharacterOtherInfo.clear();
	m_vecCharacterOtherInfoRequest.clear();
	m_vecCharacterOtherMove.clear();
	m_vecCharacterOtherRenderInfo.clear();
	m_vecCharacterOtherRenderInfoRequest.clear();
	m_vecMoveTarget.clear();

	m_vecMapObjectInfo.clear();
	m_vecMonsterInfo.clear();
	m_vecSimpleItemInfo.clear();
	m_vecItemInfo.clear();

	// 2012-06-14 by isshin ۹̸
	vector<CItemInfo*>::iterator itItem = m_vecWearDisplayInfo.begin();
	while(itItem != m_vecWearDisplayInfo.end())
	{
		SAFE_DELETE(itItem);
		itItem++;
	}
	m_vecWearDisplayInfo.clear();
	// end 2012-06-14 by isshin ۹̸

// 2009-01-28 by bhsohn nProtector   ߰
#if defined(DEFINE_USE_GAMEGUARD_NPROTECTOR)	
	SAFE_DELETE(m_pNpgl);
#endif

	// 2007-02-12 by bhsohn Item   ó
	m_bCtrlBtnClick = FALSE;
	DelMultiItemList();
	// end 2007-02-12 by bhsohn Item   ó

	// 2009-02-13 by bhsohn  ŷ ý
	SAFE_DELETE(m_pWorldRankManager);
	// end 2009-02-13 by bhsohn  ŷ ý

	// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	SAFE_DELETE( m_pInfinityManager );
	// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	
	// 2009. 11. 23 by jskim ҽ ε  
	SAFE_DELETE( m_pMeshInitThread );
	//end 2009. 11. 23 by jskim ҽ ε  

    // 2010. 10. 05 by jskim ʷε  
	SAFE_DELETE( m_pMaploading );
    // end 2010. 10. 05 by jskim ʷε  

#ifdef DEFINE_USE_GAMEGUARD_VTC
	// 2011. 1. 18 by jskim Ʈ VTC
	if(m_pVTCGuard)
	{
		SAFE_DELETE( m_pVTCGuard );
	}
	// end 2011. 1. 18 by jskim Ʈ VTC
#endif


	
}
#ifdef _DEBUG
const char *GetGameStateString(DWORD dwState)
{
	switch(dwState)
	{
	case _LOGO:
		return "_LOGO";
	case _INIT:
		return "_INIT";
	case _SELECT:
		return "_SELECT";
	case _CREATE:
		return "_CREATE";
	case _OPTION:
		return "_OPTION";
	case _MAPLOAD:
		return "_MAPLOAD";
	case _GAME:
		return "_GAME";
	case _SHOP:
		return "_SHOP";
	case _CITY:
		return "_CITY";
	case _WAITING:
		return "_WAITING";
	case _GAMEOVER:
		return "_GAMEOVER";
	case _COMPLETE:
		return "_COMPLETE";
	case _PROLOGUE:
		return "_PROLOGUE";
	case _ENDGAME:
		return "_ENDGAME";
	case _ENDCLIENT:
		return "_ENDCLIENT";
	default:
		return "_N_DEFINED_STATE";
	}
	return "_N_DEFINED_STATE";
}
#endif // _DEBUG_endif

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::ChangeGameState(DWORD dwType, BOOL bSet)
/// \brief		  
/// \author		dhkwon
/// \date		2004-06-02 ~ 2004-06-02
/// \warning	bSet FALSE̸ SLEEP· Ѿ FrameMove  ð Ŀ
///				m_nNextState Setϰ ȴ.
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::ChangeGameState(DWORD dwType, BOOL bUseThread/*=FALSE*/)
{
	FLOG("CAtumApplication::ChangeGameState(DWORD dwType)");
#ifdef _DEBUG
	DBGOUT( "--------------------Change Game State : %s --> %s------------------------\n",
		GetGameStateString(m_dwGameState), GetGameStateString(dwType) );
#endif //_DEBUG_endif

	// by bhsohn 2007-03-12 China Working
	// 2009-01-12 by bhsohn Japan Working
#ifdef IS_USE_ONOFF_IME
//#ifdef LANGUAGE_CHINA
	if(_CREATE == dwType 
		|| _SELECT == dwType )
	{
		// 2007.04.24 by bhsohn China IME Working
		g_pD3dApp->m_inputkey.EnableIMEControl(TRUE);
		
	}
	else if(_GAME == dwType )
	{		
		// 2008-01-18 by bhsohn ߱ Ŭ̾Ʈ ״  ذ
		//g_pD3dApp->m_inputkey.EnableIMEControl(FALSE);
		if(FALSE == bUseThread)
		{			
			// ʷε 忡 IME ũ  ߻Ѵ.
			g_pD3dApp->m_inputkey.EnableIMEControl(FALSE);
		}
		// end 2008-01-18 by bhsohn ߱ Ŭ̾Ʈ ״  ذ
	}		
#endif
	// end by bhsohn 2007-03-12 China Working

	if( m_dwGameState != _GAME && 
		m_dwGameState != _SHOP && 
		m_dwGameState != _CITY && 
		(dwType == _GAME || 
		dwType == _SHOP ||
		dwType == _CITY))
	{
		m_pScene->SetObjectRenderList();
	}
	if(m_pSound)
	{
		if(g_pGameMain && g_pGameMain->m_pMp3Player)
		{
			 if( g_pGameMain->m_pMp3Player->m_bMp3Play == FALSE 
				 || dwType == _ENDGAME  || dwType == _ENDCLIENT
				 || dwType == _GAMEOVER || dwType == _SCRIPT
				 || dwType == _COMPLETE || dwType == _WAITING)
			 {
				 m_pSound->SetBackMusic(dwType);
			 }
		}
		else
		{
			m_pSound->SetBackMusic(dwType);
		}		
	}
	//   
	switch(dwType)
	{
	case _CITY:
		{
			//  Ⱑ Ǿ     Ų.
			if(m_pShuttleChild && m_pShuttleChild->m_pSecondaryWeapon)
			{ 
				m_pShuttleChild->m_pSecondaryWeapon->ReleaseAllUsingToggleWeapon();
			}	
			// 2004-11-19 by jschoi
			// ÿ Խÿ   ų Ѵ. ---  û
			if(m_pShuttleChild && m_pShuttleChild->m_pSkill)
			{
				m_pShuttleChild->m_pSkill->ReleaseAllUsingSkillWithOutPermanent();
				// 2007-04-05 by bhsohn   ó
				//  ųʱȭ
				g_pShuttleChild->m_pSkill->InitPreSkillItemNum();
			}
			StartFadeEffect(TRUE,1,D3DCOLOR_ARGB(0,0,0,0));
		}
		break;
	case _GAME:
		{
			// 2007-07-25 by bhsohn  Ʃ丮ʿ ־  , ù  
			CHARACTER myShuttle = m_pShuttleChild->GetMyShuttleInfo();
			if(g_pTutorial->GetFirstUserIntoFreeSka() == TRUE	// ī ʿ ó ̳?
				&&(FALSE == IS_TUTORIAL_MAP_INDEX(myShuttle.MapChannelIndex.MapIndex)))	//   Ʃ丮 ƴϴ.
			{
				g_pGameMain->FirstUserShowMissionTreeWnd();
				g_pTutorial->SetFirstUserIntoFreeSka(FALSE);
			}
			// 2007-09-07 by dgwoo ʷε    &   ϰ
			g_pGameMain->m_pOutPost->SetOutPostImgShow();

			InitSpeedHackTimer();
			if( m_dwGameState != _GAME &&
				m_dwGameState != _SHOP && 
				m_dwGameState != _SCRIPT)
			{
				StartFadeEffect(TRUE,1,D3DCOLOR_ARGB(0,0,0,0));
			}

			// 2010. 02. 11 by ckPark ߵ 
			//  ε   Ÿ  û
			m_pFieldWinSocket->SendMsg( T_FC_ITEM_GET_COOLINGTIME_INFO, NULL, 0 );
			// end 2010. 02. 11 by ckPark ߵ 
		}
		break;
	case _WAITING:
		{
			EndFadeEffect();
			if(m_bClientQuit == TRUE)
			{
				InitStageEffect( STAGE_EFFECT_GAME_WAITING, 247 , TRUE );
			}
		}
		break;
	case _SELECT:
		{
			StartFadeEffect(TRUE,1,D3DCOLOR_ARGB(0,0,0,0));
			// 2008-07-09 by dgwoo ĳ    ġ .
			//g_pSelect->m_pSelectBack->ChangeMode(SELECT_MODE);
			
			// 2008-07-10 by bhsohn Ʈ ȭ ü  
			g_pSelect->m_pSelectBack->RefreshUnitMatrix();
			
			// 2007-08-03 by bhsohn ĳ Ʈ üũ 
			ResetCharecterOmiInfo();
			// end 2007-08-03 by bhsohn ĳ Ʈ üũ 
		}
		break;
		// 2007-07-04 by bhsohn   Ż   
	case _MAPLOAD:
		{
			m_pShuttleChild->InitUnitState();
			// 2007-10-05 by dgwoo ʷε¿ FADE IN & OUT  ʴ´.
			EndFadeEffect();
			// 2007-07-25 by bhsohn  Ʃ丮ʿ ־  , ù  
			g_pInterface->ShowOpUserHelper(FALSE, 0, NULL);	

			if ( g_pInterface->m_pBazaarShop )
			{
				g_pInterface->CloseVisitShop();
			}

		}
		break;
		// end 2007-07-04 by bhsohn   Ż   
	default:
		{
			EndFadeEffect();
		}
		break;
	}
	m_dwGameState = dwType;
}
// 2007-07-20 by bhsohn 긮η 
DWORD CAtumApplication::GetGameState()
{
	return m_dwGameState;
}

HRESULT CAtumApplication::FinalCleanup()
{
	FLOG( "CAtumApplication::FinalCleanup()" );
	SAFE_DELETE(m_pFontDebug);
	SAFE_DELETE(m_pKeyBoard);
	SAFE_DELETE(m_pCamera);
	// 2008-11-13 by bhsohn ̽ƽ ۾
	SAFE_DELETE(m_pJoyStick);				// ̽ƽ 
	SAFE_DELETE(m_pJoyStickFreedback);

	SAFE_DELETE( m_pFontInput );
	SAFE_DELETE( m_pChat);

	if(m_pFieldWinSocket)
	{
		m_pFieldWinSocket->CloseSocket();
		SAFE_DELETE( m_pFieldWinSocket );
	}

	if(m_pIMSocket)
	{
		m_pIMSocket->CloseSocket();
		SAFE_DELETE( m_pIMSocket );
	}
//	SAFE_DELETE( m_pInitThread );
	SAFE_DELETE( m_pMapInitThread );

	DeleteCriticalSection( &m_cs );
	SAFE_DELETE( m_pData );
// 	SAFE_DELETE( m_pItemData );
// 	SAFE_DELETE( m_pTraceRender );
	SAFE_DELETE( m_pCharacterChild );				// 2005-07-21 by ispark

	SAFE_DELETE(m_pEffectRender);
	SAFE_DELETE(m_pEffectList);

	KillTimer( m_hWnd, _TIMER_ALIVE);
	KillTimer( m_hWnd, _TIMER_MOVE);

//	if(m_hHangulDC)
//	{
//		DeleteObject(m_hHangulDC);
//	}
	SAFE_DELETE(g_pAtumSJ);
	SAFE_DELETE(g_pSOption);
	SAFE_DELETE(g_pSOptionCharacter);
	// 2008-06-20 by bhsohn EP3 ɼǰ ó
	SAFE_DELETE(g_pSOptionEtc);

	// 2008-11-13 by bhsohn ̽ƽ ۾
	SAFE_DELETE(g_pJoysticOp);
	// end 2008-11-13 by bhsohn ̽ƽ ۾

	// ysw 9_15
	SAFE_DELETE(m_pInterface );
//	SAFE_DELETE(m_pAtumIntro ) ;


//	SAFE_DELETE( m_pShuttleRender );
	SAFE_DELETE( m_pUnitRender );
	SAFE_DELETE( m_pCharacterRender );				// 2005-07-21 by ispark
	SAFE_DELETE( m_pShuttleChild );

	SAFE_DELETE(m_pAbuseFilter);

	SAFE_DELETE(m_pAbuseFilterData);
//	SAFE_DELETE(m_pHelpData);

	m_pDatabase->DeleteDeviceObjects();
	SAFE_RELEASE(m_pd3dxSprite);
	m_pd3dxSprite = NULL;
	// remodeling, 2004-03-19 by dhkwon
	if(m_pSound)
	{
		m_pSound->DeleteDeviceObjects();
		SAFE_DELETE(m_pSound);
	}
	if(m_pScene)
	{
		m_pScene->DeleteDeviceObjects();
		SAFE_DELETE(m_pScene);
	}
	if(m_pDatabase)
	{
		SAFE_DELETE(m_pDatabase);
	}

#ifdef _FUNCTION_LOG
	GCloseFunctionLogSharedMemory();

	DWORD dwExitCode;
	GetExitCodeProcess(g_infoAssistProcess.hProcess, &dwExitCode);
	TerminateProcess(g_infoAssistProcess.hProcess, dwExitCode);
#endif // _FUNCTION_LOG_endif

	SAFE_DELETE(m_pQuestData);
	return S_OK;
}

HRESULT CAtumApplication::OneTimeSceneInit()
{
	FLOG( "CAtumApplication::OneTimeSceneInit()" );

	D3DAdapterInfo* pAdapterInfo = &m_Adapters[m_dwAdapter];
	D3DDeviceInfo*  pDeviceInfo  = &pAdapterInfo->devices[pAdapterInfo->dwCurrentDevice];

	char buf[256];
/*	wsprintf(buf,"DeviceInfo.Inf");
	FILE *	fp;
	fp = fopen(buf,"w+b");
	if(fp)
	{
		fwrite(&pDeviceInfo->d3dCaps,1,sizeof(D3DCAPS8),fp);
		fclose(fp);
	}
*/	
//--------------------------------------------------------------------------//
// 2007-12-17 by dgwoo  忡 â .
//  ҽ.
//#ifdef _DEBUG
//	if(m_IsFullMode)
//	{
//		// Ǯȭ ٲ
//		m_bWindowed = FALSE;
//		pDeviceInfo->dwCurrentMode = m_dwCurrentMode;
//		pDeviceInfo->bWindowed = FALSE;
//	}
//#else
//	m_bWindowed = FALSE;
//	pDeviceInfo->dwCurrentMode = m_dwCurrentMode;
//	pDeviceInfo->bWindowed = FALSE;
//#endif
//  ҽ.
// 2007-12-18 by dgwoo â .
	if(m_IsFullMode)
	{// Ǯ.
		m_bWindowed = FALSE;
		pDeviceInfo->dwCurrentMode = m_dwCurrentMode;
		pDeviceInfo->bWindowed = FALSE;
	}else
	{// â.
		m_bWindowed = TRUE;
		pDeviceInfo->dwCurrentMode = m_dwCurrentMode;
		pDeviceInfo->bWindowed = TRUE;
	}
//--------------------------------------------------------------------------//
	
	m_pFontDebug = new CD3DHanFont( _T(g_pD3dApp->GetFontStyle()), 9, D3DFONT_ZENABLE, FALSE, 1024, 32);
	m_pKeyBoard = new CKeyBoardInput();
    if( FAILED( m_pKeyBoard->OnCreateDevice(m_hWnd ) ) )
	{
        m_pKeyBoard->FreeDirectInput();
		MessageBox(NULL, STRMSG_C_DIRECTX_0003, WINDOWTEXT_NAME_CLIENT, MB_OK);//"DirectInput ʱȭ . Ű    ϴ."
	}
	m_pCamera = new CCamera();

//	m_pShuttleRender = new CShuttleRender();
	m_pUnitRender = new CUnitRender();
	m_pCharacterRender = new CCharacterRender();				// 2005-07-13 by ispark
	m_pShuttleChild = new CShuttleChild();
	m_pCharacterChild = new CCharacterChild();					// 2005-07-21 by ispark

//	m_pFontInput = new CD3DHanFont(_T(g_pD3dApp->GetFontStyle()),9, D3DFONT_ZENABLE, FALSE,1024,32,TRUE);
	m_pChat = new CChat();

	// 2007-11-22 by bhsohn Ʒ ռ
	//m_pFieldWinSocket = new CFieldWinSocket(m_hWnd);	
	//m_pIMSocket = new CIMSocket(m_hWnd);
	m_pFieldWinSocket = new CFieldWinSocketManager(m_hWnd);		
	m_pIMSocket = new CIMSocketManager(m_hWnd);
	

	// 2008-06-20 by bhsohn EP3 ɼǰ ó
	g_pSOptionEtc = new sOPTION_ETC;
	memset(g_pSOptionEtc,0x00,sizeof(sOPTION_ETC));
	InitOptionEtcInfo(g_pSOptionEtc);
	// end 2008-06-20 by bhsohn EP3 ɼǰ ó

	// 2008-11-13 by bhsohn ̽ƽ ۾	
	SAFE_DELETE(g_pJoysticOp);
	g_pJoysticOp = new structJoyStickOptionInfo;
	memset(g_pJoysticOp,0x00,sizeof(structJoyStickOptionInfo));		
	InitJoyStickOptionInfo(g_pJoysticOp);
	// end 2008-11-13 by bhsohn ̽ƽ ۾

//	m_pInitThread = new CInitThread();

	g_pSOption = new sOPTION_SYSTEM;
	memset(g_pSOption,0x00,sizeof(sOPTION_SYSTEM));
	g_pSOptionCharacter = new sOPTION_CHARACTER;
	memset(g_pSOptionCharacter,0x00,sizeof(sOPTION_CHARACTER));
	m_pInterface = new CInterface;
	m_pInterface->LoadOptionFile();

	// 2008-11-13 by bhsohn ̽ƽ ۾
	InitJoyStickDevice(TRUE, TRUE, g_pJoysticOp->chJoySelJoy);	// ̽ƽ ġ ʱȭ
	// end 2008-11-13 by bhsohn ̽ƽ ۾

//	m_pTraceRender = new CTraceRender();
	m_pEffectList = new CAtumNode;


	SetTimer( m_hWnd, _TIMER_ALIVE, 15000, NULL);
	SetTimer( m_hWnd, _TIMER_MOVE, 200, NULL);

	g_pAtumSJ = new CAtumSJ;

	m_pAbuseFilter = new CAbuseFilter();
	m_pAbuseFilterData = new CGameData;
	memset(buf,0x00,sizeof(buf));
	strcpy(buf, "asdfasveq45hnsdn");
	m_pAbuseFilterData->SetFile(".\\Res-Tex\\AFList.tex",TRUE,buf,strlen(buf));
//	m_pAbuseFilterData->SetFile(".\\Res-Tex\\AFList.tex",FALSE,NULL,0);
	DataHeader * pHeader = m_pAbuseFilterData->Find("AFList");
	char* p;
	if(pHeader)
	{
		p = pHeader->m_pData;
		int nCheckSize = 0;
		while(nCheckSize < pHeader->m_DataSize)
		{
			int nCheckByte = 0;
			char* p2 = p;
			memset(buf,0x00,sizeof(buf));
			while(1)
			{
				nCheckByte++;
				char bufTemp;
				memcpy(&bufTemp,p2,1);
				if(bufTemp == '\n' || bufTemp == '\r')
				{
					m_pAbuseFilter->AddAbuse(buf);
					break;
				}
				buf[nCheckByte-1] = bufTemp;
				p2 += 1;
			}
			p += nCheckByte;
			nCheckSize += nCheckByte;
		}
	}
/*
	m_pHelpData = new CGameData;
	memset(buf,0x00,sizeof(buf));
	strcpy(buf, "asvawevawe!23r23");
	m_pHelpData->SetFile(".\\Res-Tex\\helptext.tex",TRUE,buf,strlen(buf));
	pHeader = m_pHelpData->Find("help");
	if(pHeader)
	{
		p = pHeader->m_pData;
		int nCheckSize = 0;
		while(nCheckSize < pHeader->m_DataSize)
		{
			int nCheckByte = 0;
			char* p2 = p;
			memset(buf,0x00,sizeof(buf));
			while(1)
			{
				nCheckByte++;
				char bufTemp;
				memcpy(&bufTemp,p2,1);
				if(bufTemp == '\n' || bufTemp == '\r')
				{
					if(strlen(buf)>0)
					{
						strcpy(m_strHelp[m_nHelpNum],buf);
						m_nHelpNum++;
					}
					break;
				}
				buf[nCheckByte-1] = bufTemp;
				p2 += 1;
			}
			p += nCheckByte;
			nCheckSize += nCheckByte;
		}
	}
*/

	m_pDatabase = new CAtumDatabase;
	m_pDatabase->InitDeviceObjects();
	
	// 2009. 06. 09 by ckPark OMI  ۽ üũ ϵ 
	char chFullMapPath[MAX_PATH], chMapIdx[64];	
	
	memset(chFullMapPath, 0x00, MAX_PATH);		
	memset(chMapIdx, 0x00, 64);
	
	wsprintf(chMapIdx, "omi.tex");
	strncpy(chFullMapPath, chMapIdx, MAX_PATH);
	
	LoadPath( chFullMapPath, IDS_DIRECTORY_TEXTURE, chMapIdx);

	m_pDatabase->GetOMICheckSum( chFullMapPath, m_nOMICheckSum, &m_nOMIFileSize );
	// end 2009. 06. 09 by ckPark OMI  ۽ üũ ϵ 

	// 2010. 03. 12 by ckPark Interface.tex üũ ߰
	memset(chFullMapPath, 0x00, MAX_PATH);		
	memset(chMapIdx, 0x00, 64);
	
	wsprintf(chMapIdx, "interface.tex");
	strncpy(chFullMapPath, chMapIdx, MAX_PATH);
	
	LoadPath( chFullMapPath, IDS_DIRECTORY_TEXTURE, chMapIdx);
	
	m_pDatabase->GetOMICheckSum( chFullMapPath, m_nInterfaceCheckSum, &m_nInterfaceFileSize );
	// end 2010. 03. 12 by ckPark Interface.tex üũ ߰

	m_pSound = new CAtumSound;
	m_pSound->InitDeviceObjects();
	m_pScene = new CSceneData;
	m_pScene->InitDeviceObjects();
	return S_OK;
}

DWORD CAtumApplication::ResourceLoadThread()// by dhkwon, InitDeviceObjects()
{
	FLOG("CAtumApplication::ResourceLoadThread()");
	if(m_pFontDebug)
		m_pFontDebug->InitDeviceObjects( g_pD3dDev );//m_nLoadCurrent+=1;
//	if(m_pShuttleRender)
//		m_pShuttleRender->InitDeviceObjects();//m_nLoadCurrent+=1;
	if(m_pUnitRender)
		m_pUnitRender->InitDeviceObjects();
	if(m_pCharacterRender)								// 2005-07-21 by ispark
		m_pCharacterRender->InitDeviceObjects();
	if(m_pShuttleChild)
		m_pShuttleChild->InitDeviceObjects();
	if(m_pCharacterChild)								// 2005-07-21 by ispark
		m_pCharacterChild->InitDeviceObjects();
	if(m_pInterface)
	{
		m_pInterface->InitSelectObjects();
//		m_pInterface->InitMapLoadObjects();
	}
	if(m_pChat)
		m_pChat->InitDeviceObjects();//m_nLoadCurrent+=1;
	m_pQuestData = new CQuestData;

	// 2008-11-11 by bhsohn Ʈ CheckSum߰
	m_pQuestData->RefreshQuestCheckSum();
	return 0;
}

DWORD CAtumApplication::ResourceRestoreThread()// by dhkwon
{
	FLOG("CAtumApplication::ResourceRestoreThread()");
	if(m_pFontDebug)
 		m_pFontDebug->RestoreDeviceObjects();//m_nLoadCurrent+=1;
//	if(m_pShuttleRender)
//		m_pShuttleRender->RestoreDeviceObjects();//m_nLoadCurrent+=1;
	if(m_pUnitRender)
		m_pUnitRender->RestoreDeviceObjects();
	if(m_pCharacterRender)									// 2005-07-21 by ispark
		m_pCharacterRender->RestoreDeviceObjects();
	if(m_pShuttleChild)
		m_pShuttleChild->RestoreDeviceObjects();
	if(m_pCharacterChild)									// 2005-07-21 by ispark
		m_pCharacterChild->RestoreDeviceObjects();
//		m_pShuttleChild->RestoreChat();//m_nLoadCurrent+=1;
	if(m_dwGameState == _SELECT || m_dwGameState == _CREATE )
	{
		if(m_pInterface)
		{
			m_pInterface->RestoreSelectObjects();
		}
	}
	else if(m_dwGameState == _GAME || 
		m_dwGameState == _SHOP || 
		m_dwGameState == _CITY ||
		// 2010. 03. 05 by jskim  ε   ȭ ȯ ƨ  
		//m_dwGameState == _SCRIPT)
		m_dwGameState == _SCRIPT ||
		m_dwGameState == _MAPLOAD)	
		//end 2010. 03. 05 by jskim  ε   ȭ ȯ ƨ  
	{
		m_pInterface->RestoreGameObjects();
		m_pInterface->RestoreCityObjects();
		if(m_dwGameState == _SCRIPT)
		{
			m_pInterface->RestoreSoundScript();
		}
	}
	if(m_pChat)
		m_pChat->RestoreDeviceObjects();//m_nLoadCurrent+=1;
	return 0;
}

VOID CAtumApplication::NetworkErrorMsgBox( char* strMsg)
{
	FLOG("CAtumApplication::NetworkErrorMsgBox( char* strMsg)");
	DWORD dR = 0;
	m_bShutDown = TRUE;

	strncpy(m_strMsgLastError, strMsg, strlen(strMsg) + 1);

	// 2012-10-22 by jhjang  ٿ ڰ    ý ߰
#ifdef S_ALEAM_SERVERDOWN_MUSIC // 2012-10-07 by jhjang 
	if(g_pShuttleChild && COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
	{
		// 2013-02-05 by bhsohn Sound  񿡼 Exception   			
		if(g_pD3dApp->m_pSound && g_pD3dApp->m_pSound->IsSoundDevice())
		{
			g_pD3dApp->m_pSound->GetMusicMp3()->Atum_MusicStop();
			g_pD3dApp->m_pSound->PlayNarrationSound("ServerDown");
		}
		MessageBox(NULL, "ServerDown", "SpaceCowboy", MB_OK);
	}
#endif //S_ALEAM_SERVERDOWN_MUSIC
	// end 2012-10-22 by jhjang  ٿ ڰ    ý ߰

//	if(g_pD3dDev)
//	{
//		dR = g_pD3dDev->SetDialogBoxMode(TRUE);
//	}

//	if(dR)
//	{
//		MessageBox(m_hWnd, strMsg, "SpaceCowboy", MB_OK);
		DBGOUT("[WM_CLOSE]CAtumApplication::NetworkErrorMsgBox(%s) ", strMsg );
		PostMessage(m_hWnd, WM_CLOSE, 0, 0);
//	}
//	else
//	{
//		MessageBox(NULL, strMsg, "SpaceCowboy", MB_OK);
//		SendMessage(m_hWnd,WM_CLOSE,0,0);
//	}


	// 2006-07-04 by ispark,  ޼ ó
//	SendMessage(m_hWnd,WM_CLOSE,0,0);
//	if(m_pInterface)
//	{
//		CINFWindow* pWindow = NULL;
//		if(g_pGameMain)
//			pWindow = g_pGameMain->m_pInfWindow;
//		else if(g_pSelect)
//			pWindow = g_pSelect->m_pInfWindow;
//		if(pWindow)
//		{
//			pWindow->AddMsgBox(strMsg, _MESSAGE_ERROR_NETWORK);
//		}
//		else
//		{
//			g_pD3dDev->SetDialogBoxMode(TRUE);
//			MessageBox(m_hWnd, strMsg, "SpaceCowboy", MB_OK);
//		}
//	}
//	else
//	{
//		g_pD3dDev->SetDialogBoxMode(TRUE);
//		MessageBox(m_hWnd, strMsg, "SpaceCowboy", MB_OK);
//	}
//	
//	if(	m_dwGameState == _LOGO ||
//		m_dwGameState == _INIT )
//	{
//		g_pD3dDev->SetDialogBoxMode(TRUE);
//		MessageBox(m_hWnd, strMsg, "SpaceCowboy", MB_OK);
//		SendMessage(m_hWnd,WM_CLOSE,0,0);
//	}
}

void CAtumApplication::InitStageEffect( int nIndex, float fPlayTime, BOOL bEnableSkip )
{
	if(m_pStageEffect)
	{
		m_pStageEffect->InvalidateDeviceObjects();
		m_pStageEffect->DeleteDeviceObjects();
		SAFE_DELETE(m_pStageEffect);
	}
	m_pStageEffect = new CINFStageEffect( nIndex, fPlayTime, bEnableSkip );
	m_pStageEffect->InitDeviceObjects();
	m_pStageEffect->RestoreDeviceObjects();
}

HRESULT CAtumApplication::InitDeviceObjects()
{
	FLOG("CAtumApplication::InitDeviceObjects()");
	g_pD3dDev = m_pd3dDevice;
			

			
#ifdef _DEBUG
//	InitStageEffect( STAGE_EFFECT_MGAME, 2.0f, TRUE );
	InitStageEffect( STAGE_EFFECT_GAME_LOGO, 2.0f, TRUE );
#else
//	InitStageEffect( STAGE_EFFECT_MGAME, 2.0f, FALSE );
	InitStageEffect( STAGE_EFFECT_GAME_LOGO, 2.0f, FALSE );
#endif

	m_pEffectRender = new CEffectRender();
	m_pEffectRender->InitDeviceObjects();
	ResourceLoadThread();

	

	m_pInterface->InitDeviceObjects();


	g_pD3dDev->ShowCursor(FALSE);
	// 2008-08-11 by bhsohn ܵ  ǰԲ
	if(g_pD3dApp->IsSingletonMode())
	{
	}
	else
	{
		if(!m_pFieldWinSocket->Connect(m_strFieldIP,m_nFieldPort))
		{
			NetworkErrorMsgBox(STRMSG_C_SERVER_0005);//"ʵ弭  Ǿϴ.  ˴ϴ."
			return E_FAIL; // 2005-03-25 by jschoi
		}
		if(!m_pIMSocket->Connect(m_strChatIP,m_nChatPort))
		{
			NetworkErrorMsgBox(STRMSG_C_SERVER_0006);//"IM  Ǿϴ.  ˴ϴ."
			return E_FAIL; // 2005-03-25 by jschoi
		}
	}
	

//	if(!m_pFieldWinSocket->Connect(m_strFieldIP,m_nFieldPort))
//	{
//		NetworkErrorMsgBox(STRMSG_C_SERVER_0005);//"ʵ弭  Ǿϴ.  ˴ϴ."
//		return E_FAIL; // 2005-03-25 by jschoi
//	}
//	if(!m_pIMSocket->Connect(m_strChatIP,m_nChatPort))
//	{
//		NetworkErrorMsgBox(STRMSG_C_SERVER_0006);//"IM  Ǿϴ.  ˴ϴ."
//		return E_FAIL; // 2005-03-25 by jschoi
//	}
	// end 2008-08-11 by bhsohn ܵ  ǰԲ

	m_pFxSystem->InitDeviceObjects();
	if(m_pTutorial->IsTutorialMode() == TRUE)
	{
		m_pTutorial->InitDeviceObjects();
	}
	// 2005-05-02 by ydkim CImageManager
//	if(m_pImgManager)
//		m_pImgManager->InitDeviceObjects();

	for(int i=0; i<CHAR_INF_CANDIDATE; i++)
	{
		m_pFontCandidate[i] = new CD3DHanFont(_T(g_pD3dApp->GetFontStyle()),9, D3DFONT_ZENABLE, TRUE,1024,32);
		m_pFontCandidate[i]->InitDeviceObjects(g_pD3dDev);
	}

	// 2007.04.24 by bhsohn China IME Working
#ifdef LANGUAGE_CHINA
	m_pFontCompositon = new CD3DHanFont(_T(g_pD3dApp->GetFontStyle()),9, D3DFONT_ZENABLE, TRUE,1024,32);
	m_pFontCompositon->InitDeviceObjects(g_pD3dDev);

	m_pFontIMEType = new CD3DHanFont(_T(g_pD3dApp->GetFontStyle()),9, D3DFONT_ZENABLE, TRUE,1024,32);
	m_pFontIMEType->InitDeviceObjects(g_pD3dDev);
#endif



	return S_OK;
}

HRESULT CAtumApplication::RestoreDeviceObjects()
{
	FLOG("CAtumApplication::RestoreDeviceObjects()");
	if(!m_pd3dxSprite)
		D3DXCreateSprite(g_pD3dDev , &m_pd3dxSprite);
	if(m_pStageEffect)
	{
		m_pStageEffect->RestoreDeviceObjects();
	}
  
//2012-01-05 by jhahn  ÷
	{
		HRESULT hr;
		
		// Create the vertex buffer.
		if( FAILED( hr = g_pD3dDev->CreateVertexBuffer( 2*2*sizeof(CUSTOMVERTEX),
			0, D3DFVF_CUSTOMVERTEX,
			D3DPOOL_DEFAULT, &g_pVB, NULL ) ) )
		{
			
			return E_FAIL;
		}
		
		// Fill the vertex buffer. We are setting the tu and tv texture
		// coordinates, which range from 0.0 to 1.0
		CUSTOMVERTEX* pVertices;
		if ( FAILED( hr = g_pVB->Lock( 0, 0, (void**)&pVertices, 0 ) ) )
		{
			
			return E_FAIL;
		}
		
		
		{  
			
			pVertices[0].position = D3DXVECTOR3(  -1.0f,  0.75f, 1.0f );
			pVertices[0].color    = 0xffffffff;
			pVertices[0].tu       = 0.0f;
			pVertices[0].tv       = 1.0f; 
			
			pVertices[1].position = D3DXVECTOR3(  1.0f,  0.75f, 1.0f );
			pVertices[1].color    = 0xffffffff;
			pVertices[1].tu       = 1.0f;
			pVertices[1].tv       = 1.0f; 
			
			pVertices[2].position = D3DXVECTOR3(  -1.0f,  -0.75f, 1.0f );
			pVertices[2].color    = 0xffffffff;
			pVertices[2].tu       = 0.0f;
			pVertices[2].tv       = 0.0f; 
			
			pVertices[3].position = D3DXVECTOR3(  1.0f,  -0.75f, 1.0f );
			pVertices[3].color    = 0xffffffff;
			pVertices[3].tu       = 1.0f;
			pVertices[3].tv       = 0.0f;
		}
		
		g_pVB->Unlock();
	}
	
	InitDShowTextureRenderer();	 
//end 2012-01-05 by jhahn  ÷
/*	g_pD3dDev->BeginStateBlock();
	g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
    g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE,  FALSE );
	g_pD3dDev->SetRenderState( D3DRS_ZENABLE, TRUE );
	g_pD3dDev->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
	g_pD3dDev->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
//	g_pD3dDev->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR );
	g_pD3dDev->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	g_pD3dDev->SetRenderState( D3DRS_NORMALIZENORMALS, TRUE );	//   ϴ  ڵ ǥȭ
	g_pD3dDev->SetRenderState( D3DRS_LIGHTING, TRUE );
	g_pD3dDev->SetRenderState( D3DRS_DITHERENABLE, TRUE );		// 16Ʈ  忡 Ÿ  ִ ܻ 뿪 δ(?)
    g_pD3dDev->SetRenderState( D3DRS_CULLMODE, D3DCULL_CCW );
	g_pD3dDev->EndStateBlock( &m_dwStateBlock );
*/
	m_pScene->SetupLights();

	if( FAILED( g_pD3dDev->CreateVertexBuffer( 4 * sizeof(NOSPRITE),
		0, D3DFVF_NOSPRITE, D3DPOOL_MANAGED, &m_pVBSleep ,NULL) ) )
		return E_FAIL;
	float hsx,hsy; 
	NOSPRITE* v;
	m_pVBSleep->Lock( 0, 0, (void**)&v, 0 );
	hsx = 1.5f;
	hsy = 1.5f;
	// 2008-06-27 by bhsohn 1600X900   ׾ ,  ̹ ó ª  ó
	if(g_pD3dApp->GetWidth() > 1440)
	{
		hsx = 1.7f;
	}
	// end 2008-06-27 by bhsohn 1600X900   ׾ ,  ̹ ó ª  ó
	v[0].p = D3DXVECTOR3(-hsx,-hsy,0);	v[0].color=0x77FF0000;
	v[1].p = D3DXVECTOR3(-hsx,hsy,0);	v[1].color=0x77FF0000;
	v[2].p = D3DXVECTOR3(hsx,-hsy,0);	v[2].color=0x77FF0000;
	v[3].p = D3DXVECTOR3(hsx,hsy,0); 	v[3].color=0x77FF0000;
	m_pVBSleep->Unlock();

	//ysw 9_15
//	if(m_pAtumIntro)
//		m_pAtumIntro->RestoreDeviceObjects() ;

//	if(!m_pAtumIntro && m_pEffectRender)
	if(m_pEffectRender)
		m_pEffectRender->RestoreDeviceObjects();
	//////////////////////////////////////////////////////////////////////////

	// For Alt+Tab
	if(m_pScene)
	{
		m_pScene->RestoreDeviceObjects();
	}
	ResourceRestoreThread();
	if(m_pDatabase)
		m_pDatabase->RestoreDeviceObjects();
	if(m_pInterface)
		m_pInterface->RestoreDeviceObjects();

	m_bResCheck = TRUE;
	m_bReadyBeginScene = TRUE;

	m_pFxSystem->RestoreDeviceObjects();
	if(m_pTutorial->IsTutorialMode() == TRUE)
	{
		m_pTutorial->RestoreDeviceObjects();
	}
//	if(m_pImgManager)
//		m_pImgManager->RestoreDeviceObjects(m_dwGameState);

	for(int i=0; i<CHAR_INF_CANDIDATE; i++)
		m_pFontCandidate[i]->RestoreDeviceObjects();

	// 2007.04.24 by bhsohn China IME Working
#ifdef LANGUAGE_CHINA
	if(m_pFontCompositon)
	{
		m_pFontCompositon->RestoreDeviceObjects();
	}
	if(m_pFontIMEType)
	{
		m_pFontIMEType->RestoreDeviceObjects();
	}	
#endif



	return S_OK;
}

HRESULT CAtumApplication::InvalidateDeviceObjects()
{
	FLOG("CAtumApplication::InvalidateDeviceObjects()");
	if(m_pStageEffect)
	{
		m_pStageEffect->InvalidateDeviceObjects();
	}
	if(g_pVB)
	{
		SAFE_RELEASE(g_pVB);
	}	
	if(g_pTextureMoviePlayer)
	{
		SAFE_RELEASE(g_pTextureMoviePlayer);
	}	
	CleanupDShow();
// 2010. 10. 05 by jskim ʷε  
// 	while(m_pMapInitThread && m_pMapInitThread->m_bRunning)
// 	{
// 		Sleep(500);
// 	}									 
// end 2010. 10. 05 by jskim ʷε  
	if(m_dwStateBlock)
	{
//		g_pD3dDev->DeleteStateBlock(m_dwStateBlock);
		m_dwStateBlock = 0;
	}
	if(m_pFontDebug)
		m_pFontDebug->InvalidateDeviceObjects();
//	if(m_pShuttleRender)
//		m_pShuttleRender->InvalidateDeviceObjects();
	if(m_pUnitRender)
		m_pUnitRender->InvalidateDeviceObjects();
	if(m_pCharacterRender)										// 2005-07-21 by ispark
		m_pCharacterRender->InvalidateDeviceObjects();
	if(m_pShuttleChild)
		m_pShuttleChild->InvalidateDeviceObjects();
	if(m_pCharacterChild)										// 2005-07-21 by ispark
		m_pCharacterChild->InvalidateDeviceObjects();
//  		m_pShuttleChild->InvalidateChat();
	if(m_pChat)
		m_pChat->InvalidateDeviceObjects();
	SAFE_RELEASE( m_pVBSleep );
	if(m_pEffectRender)
		m_pEffectRender->InvalidateDeviceObjects();
	if(m_pScene)
	{
		m_pScene->InvalidateDeviceObjects();
	}
	m_bReadyBeginScene = FALSE;
	if(m_pInterface)
	{
		m_pInterface->InvalidateDeviceObjects();
	}
	if(m_pDatabase)
		m_pDatabase->InvalidateDeviceObjects();

//	if(m_pAtumIntro)
//		m_pAtumIntro->InvalidateDeviceObjects();

	SAFE_RELEASE(m_pd3dxSprite);
	m_pd3dxSprite = NULL;

	m_pFxSystem->InvalidateDeviceObjects();
	if(m_pTutorial->IsTutorialMode() == TRUE)
	{
		m_pTutorial->InvalidateDeviceObjects();
	}

//	if(m_pImgManager)
//		m_pImgManager->InvalidateDeviceObjects(m_dwGameState);
	for(int i=0; i<CHAR_INF_CANDIDATE; i++)
		m_pFontCandidate[i]->InvalidateDeviceObjects();

	// 2007.04.24 by bhsohn China IME Working
#ifdef LANGUAGE_CHINA
	if(m_pFontCompositon)
	{
		m_pFontCompositon->InvalidateDeviceObjects();
	}
	if(m_pFontIMEType)
	{
		m_pFontIMEType->InvalidateDeviceObjects();
	}
#endif


	return S_OK;
}

HRESULT CAtumApplication::DeleteDeviceObjects()
{
	FLOG("CAtumApplication::DeleteDeviceObjects()");
	//*--------------------------------------------------------------------------*//
	// 
	if(m_bCheckQuickSlotSave == FALSE)
	{
		m_pInterface->SaveCharacterFile(SLOT_PURPOSE_MAIN);		// 2012-06-21 by jhseol, Ʒ ߰part2 - Ʒ   Ķ ߰ ( 0 = , 1 = Ʒ )
	}
	//*--------------------------------------------------------------------------*//
//2012-01-05 by jhahn  ÷	
	if(g_pVB)
	{
		SAFE_RELEASE(g_pVB);
	}	
	if(g_pTextureMoviePlayer)
	{
		SAFE_RELEASE(g_pTextureMoviePlayer);
	}	
	CleanupDShow();	
//end 2012-01-05 by jhahn  ÷
	if(m_pStageEffect)
	{
		m_pStageEffect->DeleteDeviceObjects();
		SAFE_DELETE(m_pStageEffect);
	}
	m_pFontDebug->DeleteDeviceObjects();

//	if(m_pShuttleRender)
//	{
//		m_pShuttleRender->DeleteDeviceObjects();
//	}
	if(m_pUnitRender)
		m_pUnitRender->DeleteDeviceObjects();
	if(m_pCharacterRender)								// 2005-07-21 by ispark
		m_pCharacterRender->DeleteDeviceObjects();
	if(m_pCharacterChild)								// 2005-07-21 by ispark
		m_pCharacterChild->DeleteDeviceObjects();
	if(m_pShuttleChild)
	{
  		m_pShuttleChild->DeleteDeviceObjects();
	}

	if(m_pScene)
	{
		m_pScene->DeleteDeviceObjects();//DeleteRes();
		SAFE_DELETE(m_pScene);
	}
	
//	m_pFontInput->DeleteDeviceObjects();
	m_pChat->DeleteDeviceObjects();
//	if(m_VOIPState.nVOIPState != _VOIP_NOTLOGIN && m_VOIPState.nVOIPState != _VOIP_ERRORSTATE) 
//	{
		COPYDATASTRUCT	copyData;
		memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
		AV_MSG_WM_COPYDATA voIP(_1to1Call, AV_MT_CLIENT_END, 0);
		copyData.dwData = (DWORD)voIP;
//		copyData.dwData = MAKELONG(AV_MT_CLIENT_END, 0);
		copyData.lpData = NULL;
		copyData.cbData = 0;
		::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&copyData);
//	}
//	if(m_bReadyVoIP) 
//	{
//		COPYDATASTRUCT	copyData;
//		memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
//		copyData.dwData = MAKELONG(AV_MT_CLIENT_END, 0);
//		copyData.lpData = NULL;
//		copyData.cbData = 0;
//		::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&copyData);
//		m_bReadyVoIP = FALSE;
//	}
// 	SAFE_DELETE(m_pItemData);
	//ysw 9_20
	if(m_pInterface)
	{
		m_pInterface->DeleteDeviceObjects();
		SAFE_DELETE(m_pInterface);
	}
/*	if( m_dwGameState == _LOGO || 
		m_dwGameState == _INIT ||
		m_dwGameState == _SELECT || 
		m_dwGameState == _CREATE || 
		m_dwGameState == _OPTION )
	{
		if(m_pInterface) 
		{
			m_pInterface->DeleteSelectObjects();
		}
	}
	else if((m_dwGameState == _GAME || m_dwGameState == _SHOP) && m_pInterface)
	{
		m_pInterface->DeleteGameObjects();
	}
	SAFE_DELETE(m_pInterface );
*/
/*	if(m_pAtumIntro)
	{
		m_pAtumIntro->DeleteDeviceObjects();
		SAFE_DELETE(m_pAtumIntro);
	}
*/	if(m_pEffectRender)
	{
		m_pEffectRender->DeleteDeviceObjects();
		SAFE_DELETE(m_pEffectRender);
	}
	if(m_pSound)
	{
		m_pSound->DeleteDeviceObjects();
		SAFE_DELETE(m_pSound);
	}

	m_pFxSystem->DeleteDeviceObjects();
	if(m_pTutorial->IsTutorialMode() == TRUE)
	{
		m_pTutorial->DeleteDeviceObjects();
	}
//	if(m_pImgManager)
//	{
//		m_pImgManager->DeleteDeviceObjects(m_dwGameState);
//		SAFE_DELETE(m_pImgManager);
//	}
	for(int i=0; i<CHAR_INF_CANDIDATE; i++)
	{
		m_pFontCandidate[i]->DeleteDeviceObjects();
		SAFE_DELETE(m_pFontCandidate[i]);
	}
	// 2007.04.24 by bhsohn China IME Working
#ifdef LANGUAGE_CHINA
	if(m_pFontCompositon)
	{
		m_pFontCompositon->DeleteDeviceObjects();
		SAFE_DELETE(m_pFontCompositon);
	}
	if(m_pFontIMEType)
	{
		m_pFontIMEType->DeleteDeviceObjects();
		SAFE_DELETE(m_pFontIMEType);
	}
#endif


	return S_OK;
}

HRESULT CAtumApplication::Render()
{
	FLOG("CAtumApplication::Render()");
	if(!m_bReadyBeginScene)
		return S_OK;
	// 2009. 11. 23 by jskim ҽ ε  
	LoadMeshPorcess();	
	//end 2009. 11. 23 by jskim ҽ ε  
	EnterCriticalSection(&m_cs);
	if( m_dwGameState == _MAPLOAD || 
//		m_dwGameState == _SELECTCHANNEL || 
		m_dwGameState == _MOVIE || 
		m_dwGameState == _LOGO || 
		m_dwGameState == _INIT || 
		m_dwGameState == _SCRIPT || 
		m_dwGameState == _WAITING ||
		m_dwGameState == _PROLOGUE)			// 2006-09-18 by ispark
	{
		m_pScene->m_dwFogColor= D3DCOLOR_ARGB(0x00,(BYTE)0,(BYTE)0,(BYTE)0);
	}
	else if( m_dwGameState == _SELECTCHANNEL )
	{
		m_pScene->m_dwFogColor= D3DCOLOR_ARGB(0x00,(BYTE)22,(BYTE)22,(BYTE)22);
	}

	g_pD3dDev->Clear( 0L, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,m_pScene->m_dwFogColor, 1.0f, 0L );

			g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
			g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
			g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE,  FALSE );
			g_pD3dDev->SetRenderState( D3DRS_ZENABLE, TRUE );
			g_pD3dDev->SetRenderState( D3DRS_NORMALIZENORMALS, TRUE );	//   ϴ  ڵ ǥȭ
			g_pD3dDev->SetRenderState( D3DRS_LIGHTING, TRUE );
			g_pD3dDev->SetRenderState( D3DRS_DITHERENABLE, TRUE );		// 16Ʈ  忡 Ÿ  ִ ܻ 뿪 δ(?)
			g_pD3dDev->SetRenderState( D3DRS_CULLMODE, D3DCULL_CCW );
			// 2005-01-03 by jschoi
//			g_pD3dDev->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
//			g_pD3dDev->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
			g_pD3dDev->SetSamplerState(0,D3DSAMP_MINFILTER,D3DTEXF_LINEAR);
			g_pD3dDev->SetSamplerState(0,D3DSAMP_MAGFILTER,D3DTEXF_LINEAR);
			g_pD3dDev->SetSamplerState(0,D3DSAMP_MIPFILTER,D3DTEXF_LINEAR);


			g_pD3dDev->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );

			// 2005-01-04 by jschoi
//			g_pD3dDev->SetTextureStageState( 0, D3DTSS_ADDRESSU,  D3DTADDRESS_CLAMP );
//			g_pD3dDev->SetTextureStageState( 0, D3DTSS_ADDRESSV,  D3DTADDRESS_CLAMP );
			g_pD3dDev->SetSamplerState(0, D3DSAMP_ADDRESSU,D3DTADDRESS_CLAMP );
			g_pD3dDev->SetSamplerState(0, D3DSAMP_ADDRESSV,D3DTADDRESS_CLAMP );

			g_pD3dDev->SetTransform( D3DTS_VIEW,       &m_pCamera->GetViewMatrix() );
			g_pD3dDev->SetTransform( D3DTS_PROJECTION, &m_pCamera->GetProjMatrix() );

    if( SUCCEEDED( g_pD3dDev->BeginScene() ) )
    {
		switch(m_dwGameState)
		{
		case _MOVIE:
		case _LOGO:
		case _INIT:
			{
				if(m_pStageEffect)
				{
					m_pStageEffect->Render();
				}
				if( m_pInterface && 
					m_pInterface->m_pSelect &&
					m_pInterface->m_pSelect->m_pInfWindow)
				{
					m_pInterface->m_pSelect->m_pInfWindow->RenderMessaegBox();

				}
			}
			break;

		case _MOVIEPLAYER:
			{
				{
					g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );			
					
					D3DXMATRIX matWorld;
					D3DXMatrixIdentity( &matWorld );				  
					g_pD3dDev->SetTransform( D3DTS_WORLD, &matWorld );				  
					D3DXMATRIX matView;
					D3DXMatrixLookAtLH( &matView, &D3DXVECTOR3( 0.0f, 0.0f,-1.5f ),
						&D3DXVECTOR3( 0.0f, 0.0f, 0.0f ),
						&D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
					g_pD3dDev->SetTransform( D3DTS_VIEW, &matView );		  
					
					D3DXMATRIX matProj;
					D3DXMatrixPerspectiveFovLH( &matProj, D3DX_PI/4, 1.0f, 1.0f, 100.0f );
					
					g_pD3dDev->SetTransform( D3DTS_PROJECTION, &matProj );
					
					g_pD3dDev->SetTexture( 0, g_pTextureMoviePlayer );
					
					// Render the vertex buffer contents
					g_pD3dDev->SetStreamSource( 0, g_pVB, 0, sizeof(CUSTOMVERTEX) );
					g_pD3dDev->SetVertexShader( NULL );
					g_pD3dDev->SetFVF( D3DFVF_CUSTOMVERTEX );
					g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );

					HRESULT hr = CheckMovieStatus();
					if (hr == S_FALSE)
					{
						ChangeGameState(_SELECT);
					}
				}			

			}
			break;
		case _SELECT:
			{
				// 2010-06-07 by dgwoo ĳͼâ ҽ 濡  Ʈ  .
				m_pInterface->m_pSelect->m_pSelectBack->Render();
				g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, TRUE );
				m_pInterface->m_pSelect->m_pSelectBack->RenderSelectUnit();
				g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
				//end 2010-06-07 by dgwoo ĳͼâ ҽ 濡  Ʈ  .
				m_pEffectRender->Render();
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _CREATE:
			{
				// 2010-06-07 by dgwoo ĳͼâ ҽ 濡  Ʈ  .
				m_pInterface->m_pSelect->m_pSelectBack->Render();
				g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, TRUE );
				m_pInterface->m_pSelect->m_pSelectBack->RenderCreateUnit();
				g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, FALSE ); 
				//end 2010-06-07 by dgwoo ĳͼâ ҽ 濡  Ʈ  .
				m_pEffectRender->Render();
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _OPTION:
			{
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _MAPLOAD:
			{
				// 2011-10110 by jhahn EP4 ʷε  ʱȭ
				m_pFxSystem->SetingSandStromSurface(FALSE);	 
                //end 2011-10110 by jhahn EP4 ʷε  ʱȭ

				
				g_pD3dDev->SetRenderState(D3DRS_FOGENABLE, FALSE);
				if(m_pInterface)
					m_pInterface->Render();
				if( m_pInterface && 
					m_pInterface->m_pSelect &&
					m_pInterface->m_pSelect->m_pInfWindow)
				{
					m_pInterface->m_pSelect->m_pInfWindow->RenderMessaegBox();
				}
				else if( m_pInterface &&
					m_pInterface->m_pGameMain &&
					m_pInterface->m_pGameMain->m_pInfWindow)
				{
					m_pInterface->m_pGameMain->m_pInfWindow->RenderMessaegBox();
				}
			}
			break;
		case _GAME:
			{
				RenderGame();
				m_pEffectRender->Render();

				//*--------------------------------------------------------------------------*//
				// 2006-11-16 by ispark,  
				RenderAlpha();
				//*--------------------------------------------------------------------------*//

				// Ϲ 
                if(m_pFxSystem->IsRenderBlurFilter() && g_pSOption->sContrast > 0)
				{
					m_pFxSystem->MakeTargetSurface();
					m_pFxSystem->DrawTargetSurface();
				}
				// 2009-03-18 by bhsohn κ ü ȳ  
				if((0 == g_pSOption->sContrast) && (g_pSOption->sFilter > 0))
				{
					g_pD3dDev->SetRenderState( D3DRS_ZENABLE, FALSE );					
				}
				// end 2009-03-18 by bhsohn κ ü ȳ  

				// 2005-01-17 by jschoi - 콺 
				if(m_pFxSystem->IsRenderGaussBlur() && g_pSOption->sFilter > 0)
				{
					m_pFxSystem->MakeGaussFilterSurface();
					m_pFxSystem->DrawGaussFilterSurface();
				}
#ifdef C_EPSODE4_SETTING_JHAHN
				// 2011-10-10 by jhahn EP4 Ʈ ý	ȭ Ʈ ߰
				if (m_pFxSystem->GetingSandStromSurface() )
					m_pFxSystem->MakeSandStromSurface();					
#endif
				//end 2011-10-10 by jhahn EP4 Ʈ ý	ȭ Ʈ ߰

				m_pChat->Render();
//				if(m_pTutorial->IsTutorialMode() == TRUE)				// 2006-09-21 by ispark, ̽  ġ 
//					m_pTutorial->Render();
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _SHOP:
			{
    			RenderGame();
				m_pEffectRender->Render();

				// Ϲ 
                if(m_pFxSystem->IsRenderBlurFilter() && g_pSOption->sContrast > 0)
				{
					m_pFxSystem->MakeTargetSurface();
					m_pFxSystem->DrawTargetSurface();
				}
				// 2009-03-18 by bhsohn κ ü ȳ  
				if((0 == g_pSOption->sContrast) && (g_pSOption->sFilter > 0))
				{
					g_pD3dDev->SetRenderState( D3DRS_ZENABLE, FALSE );					
				}
				// end 2009-03-18 by bhsohn κ ü ȳ  

				// 2005-01-17 by jschoi - 콺 
				if(m_pFxSystem->IsRenderGaussBlur() && g_pSOption->sFilter > 0)
				{
					m_pFxSystem->MakeGaussFilterSurface();
					m_pFxSystem->DrawGaussFilterSurface();
				}

				m_pChat->Render();
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _CITY:
			{
				RenderCity();
				m_pEffectRender->Render();

				// Ϲ 
                if(m_pFxSystem->IsRenderBlurFilter() && g_pSOption->sContrast > 0)
				{
					m_pFxSystem->MakeTargetSurface();
					m_pFxSystem->DrawTargetSurface();
				}
				// 2009-03-18 by bhsohn κ ü ȳ  
				if((0 == g_pSOption->sContrast) && (g_pSOption->sFilter > 0))
				{
					g_pD3dDev->SetRenderState( D3DRS_ZENABLE, FALSE );					
				}
				// end 2009-03-18 by bhsohn κ ü ȳ  

				// 2005-01-17 by jschoi - 콺 
				if(m_pFxSystem->IsRenderGaussBlur() && g_pSOption->sFilter > 0)
				{
					m_pFxSystem->MakeGaussFilterSurface();
					m_pFxSystem->DrawGaussFilterSurface();
				}


				m_pChat->Render();
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _SCRIPT:
			{
				g_pD3dDev->SetRenderState(D3DRS_FOGENABLE, FALSE);
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _WAITING:
			{
				if(m_pStageEffect)
				{
					m_pStageEffect->Render();
				}
				if(m_pInterface)
					m_pInterface->Render();
				if( m_pInterface && 
					m_pInterface->m_pSelect &&
					m_pInterface->m_pSelect->m_pInfWindow)
				{
					m_pInterface->m_pSelect->m_pInfWindow->RenderMessaegBox();
				}
				else if( m_pInterface &&
					m_pInterface->m_pGameMain &&
					m_pInterface->m_pGameMain->m_pInfWindow)
				{
					m_pInterface->m_pGameMain->m_pInfWindow->RenderMessaegBox();
				}
			}
			break;
		case _GAMEOVER:
			{
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _COMPLETE:
			{
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _PROLOGUE:
			{
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _ENDGAME:
			{
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _ENDCLIENT:
			{
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		case _SELECTCHANNEL:
			{
				if(m_pInterface)
					m_pInterface->Render();
			}
			break;
		}

		// 2005-03-03 by jschoi
		RenderRequestEnable();
		
		FadeEffectRender();
		RenderDbg();
		g_pD3dDev->EndScene();
	}
	LeaveCriticalSection(&m_cs);	
    return S_OK;
}

void CAtumApplication::CheckRenderState()
{
	FLOG("CAtumApplication::CheckRenderState()");
	int temp = m_nCheckRenderPos;
	for(int i = 0 ; i < 1 ; i++)
	{
		// Shuttle
/*		if(temp < SHUTTLE_NUM)
		{
			if(m_pShuttleRender->m_pMeshNode[temp])
			{
				if(m_pShuttleRender->m_pMeshNode[temp]->m_nRenderCount > 2)//m_pRenderCount[temp] > 2)
					m_pShuttleRender->m_pMeshNode[temp]->m_nRenderCount = 2;//m_pRenderCount[temp] = 2;
				else
					m_pShuttleRender->ShuttleDeleteData(temp);
			}
		}
		// Monster
		else if(temp < SHUTTLE_NUM + MONSTER_NUM)
		{
			if(m_pMonsterRender->m_pMeshNode[temp-SHUTTLE_NUM])
			{
				if(m_pMonsterRender->m_pMeshNode[temp-SHUTTLE_NUM]->m_nRenderCount > 2)
					m_pMonsterRender->m_pMeshNode[temp-SHUTTLE_NUM]->m_nRenderCount = 2;
				else
					m_pMonsterRender->MonsterDeleteData(temp-SHUTTLE_NUM);
			}
		}
		// Object
		else if(temp < SHUTTLE_NUM + MONSTER_NUM + OBJECT_NUM )
		{
			if(m_pScene->m_pObjectRender->m_pMeshNode[temp-SHUTTLE_NUM-MONSTER_NUM])
			{
				if( m_pScene->m_pObjectRender->m_pMeshNode[temp-SHUTTLE_NUM-MONSTER_NUM]->m_nRenderCount > 2)
					m_pScene->m_pObjectRender->m_pMeshNode[temp-SHUTTLE_NUM-MONSTER_NUM]->m_nRenderCount = 2;
				else
					m_pScene->m_pObjectRender->ObjectDeleteData(temp-SHUTTLE_NUM-MONSTER_NUM);
			}
		}
		temp++;
		if(temp == SHUTTLE_NUM + MONSTER_NUM + OBJECT_NUM)
			temp = 0;
*/	}
	m_nCheckRenderPos = temp;
}
/*
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::TickSleep()
/// \brief		 GameState Ѵ.
/// \author		dhkwon
/// \date		2004-06-02 ~ 2004-06-02
/// \warning	m_fSleepTime > 0
///				
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
HRESULT  CAtumApplication::TickSleep()
{
	m_fSleepTime -= m_fElapsedTime;
	if(m_fSleepTime <= 0)
	{
		m_fSleepTime = 0;
	}
	if(m_fSleepTime > 0) //  ο
	{
		DWORD alpha = (DWORD)((m_fSleepTime/SLEEP_TIMER_TEMP*100));
		if( alpha > 100 )
			alpha = 100;
		if(m_pVBSleep)
		{
			NOSPRITE* v;
			m_pVBSleep->Lock( 0, 0, (BYTE**)&v, 0 );
			v[0].color=(DWORD)((alpha << 24) | 0x00000000);
			v[1].color=v[0].color;
			v[2].color=v[0].color;
			v[3].color=v[0].color;
			m_pVBSleep->Unlock();
		}
	}
	*/
/*	if(m_fSleepTime > SLEEP_TIMER_TEMP/2) //  ο
	{
		DWORD alpha = (DWORD)((m_fSleepTime-SLEEP_TIMER_TEMP/2)/SLEEP_TIMER_TEMP*200);
		if( alpha > 100 )
			alpha = 100;
		if(m_pVBSleep)
		{
			NOSPRITE* v;
			m_pVBSleep->Lock( 0, 0, (BYTE**)&v, 0 );
			v[0].color=(DWORD)((alpha << 24) | 0x00FFFFFF);
			v[1].color=v[0].color;
			v[2].color=v[0].color;
			v[3].color=v[0].color;
			m_pVBSleep->Unlock();
		}
	}
	else //  
	{
		DWORD alpha = (DWORD)((SLEEP_TIMER_TEMP/2-m_fSleepTime)/SLEEP_TIMER_TEMP*200);
		if( alpha > 100 )
			alpha = 100;
		if(m_pVBSleep)
		{
			NOSPRITE* v;
			m_pVBSleep->Lock( 0, 0, (BYTE**)&v, 0 );
			v[0].color=(DWORD)((alpha << 24) | 0x00FF0000);
			v[1].color=v[0].color;
			v[2].color=v[0].color;
			v[3].color=v[0].color;
			m_pVBSleep->Unlock();
		}
	}
	return S_OK;
}
*/
HRESULT CAtumApplication::FrameMove()
{
	FLOG("CAtumApplication::FrameMove()");
#ifdef _DEBUG
	g_fMoveCountFrame += GetElapsedTime();
#endif
	static float fDebugTextCheckTime = 0.0f;
	static float fCloudCheckTime = 600.0f;

	if(fDebugTextCheckTime >= 0.0f)
		fDebugTextCheckTime -= m_fElapsedTime;


	// 2007-02-12 by bhsohn Ŀ Ҿ Ծ   ó
	UpdateCheckTime();
	// end 2007-02-12 by bhsohn Ŀ Ҿ Ծ   ó

//	char message[512];
	///////////////////////////////  Ӱ   Ͽ    ////////////////////////////

	// ʴ 5 ̻ PC  Ѵ.
	if(m_fElapsedTime > 0.2f)
		m_fElapsedTime = 0.2f;
	float fTemp;
	fTemp = (m_fOldTickTime+m_fElapsedTime)/2.0f;
	m_fOldTickTime = m_fElapsedTime;
	m_fElapsedTime = fTemp;

	//  Ʈ ð      Ѵ.
	if(m_fRenderDeleteCheckTime >= 0.0f)
		m_fRenderDeleteCheckTime -= GetElapsedTime();
	if(m_fRenderDeleteCheckTime <= 0.0f)
	{
		CheckRenderState();
		m_fRenderDeleteCheckTime = 60.0f;
	}


	if(m_fCheckSocketTime >= 0.0f)
		m_fCheckSocketTime -= GetElapsedTime();
	if(m_fCheckSocketTime <= 0.0f)
	{
	// 2008-08-11 by bhsohn ܵ  ǰԲ
	if(g_pD3dApp->IsSingletonMode())
	{
	}
	else
	{
		if(m_dwGameState != _MAPLOAD)// by dhkwon 2003.7.4
		{
			if(!m_pFieldWinSocket->IsConnected())
			{
				NetworkErrorMsgBox(STRMSG_C_SERVER_0005);//"ʵ弭  Ǿϴ.  ˴ϴ."
				return E_FAIL;// 2005-03-25 by jschoi -  ʿ
			}
		}
		if(!m_pIMSocket->IsConnected())
		{
			NetworkErrorMsgBox(STRMSG_C_SERVER_0006);//"IM  Ǿϴ.  ˴ϴ."
			return E_FAIL;// 2005-03-25 by jschoi -  ʿ
		}
	}

		m_fCheckSocketTime = 10.0f;
	}
	////////////////////////
	//   ÷ //
	////////////////////////
	m_pSound->PlayBackSound();
	
	// 2007-07-24 by bhsohn ̼ mp3߰
	// ̼ mp3÷
	PlayNarrationSound();

	////////////////////////
//	if(!m_bInitializing)
//	{
		if( FAILED( m_pKeyBoard->ReadImmediateData(m_hWnd ) ) )
			return E_FAIL;
#ifdef _DEBUG
		if( m_pShuttleChild && 
//			COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER) && 
			m_pKeyBoard->GetAsyncKeyState( DIK_LCONTROL) && 
			m_pKeyBoard->GetAsyncKeyState( DIK_LMENU) && 
			m_pKeyBoard->GetAsyncKeyState( DIK_SLASH))
		{
			if(fDebugTextCheckTime < 0.0f)
			{
				m_bDebugText = !m_bDebugText;
				fDebugTextCheckTime = 1.0f;
			}
		}
#endif
		// 2007-09-05 by bhsohn China IME Working
#ifdef LANGUAGE_CHINA
		TickImeChange();
#endif
		// 2008-11-13 by bhsohn ̽ƽ ۾
		TickJoyStickInfo();	// ̽ƽ Ʈ  
		
		// 2008-08-18 by bhsohn 1   ̵ ý 
		TickItemSell();
		// end 2008-08-18 by bhsohn 1   ̵ ý 


		// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
		TickInfinityStart();
		// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)


		// 2010. 03. 23 by ckPark ǴƼ ʵ 2(ǴƼ ʵ  ĳ)
		TickInfintyMapLoadedSend();
		// end 2010. 03. 23 by ckPark ǴƼ ʵ 2(ǴƼ ʵ  ĳ)

		// 2010. 10. 05 by jskim ʷε  
		m_pMaploading->TickMapLoad();
		// end 2010. 10. 05 by jskim ʷε  
		
		// 2009-01-28 by bhsohn nProtector   ߰
		#if defined(DEFINE_USE_GAMEGUARD_NPROTECTOR)
			if(!TickGetCheckGameGuardNProtector())
			{
				//     ų Ȳ̴.
				NetworkErrorMsgBox(STRMSG_C_SERVER_0010);
			}
		#endif
		// end 2009-01-28 by bhsohn nProtector   ߰
	// 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)
		#if defined(DEFINE_USE_GAMEGUARD_XTRAP)
			TickGetCheckGameGuardXTrap();			
		#endif
	//end 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)
		
		if(GetHwnd() == GetActiveWindow() && m_pKeyBoard->GetAsyncKeyState(DIK_F12))
		{
			if(fDebugTextCheckTime < 0.0f)
			{
				if(m_dwGameState == _SELECT || 
					m_dwGameState == _CREATE || 
					m_dwGameState == _MAPLOAD || 
					m_dwGameState == _GAME || 
					m_dwGameState == _CITY || 
					m_dwGameState == _SHOP)
				{
					int nNumber = GetScreenShotNumber();
					if(nNumber != -1)
					{
						char buf[64];
						wsprintf(buf, "ATM%05d.bmp", nNumber);
						TakeScreenShot(g_pD3dDev, buf, GetBackBufferDesc().Width, GetBackBufferDesc().Height);
					}
					fDebugTextCheckTime = 0.5f;
				}
			}
		}

		// 2005-04-07 by jschoi
		if( m_dwGameState != _GAME ||
			m_pTutorial->IsTutorialMode() == FALSE)
		{
			if(m_pInterface)
				m_pInterface->Tick();
		}
		else if(m_pTutorial->IsTutorialMode() == TRUE)
		{
			if(g_pGameMain && g_pGameMain->m_pMiniMap)
			{
				g_pGameMain->m_pMiniMap->Tick();
			}
// 2007-07-27 by dgwoo Ʃ丮 Tick .
//			if(m_pInterface && m_pInterface->m_pTarget)
//			{
//				m_pInterface->m_pTarget->Tick();
//			}
		}
		
		switch(m_dwGameState)
		{
		case _MOVIE:
			{
				if(m_pStageEffect)
				{
					m_pStageEffect->Tick();
					if(!m_pStageEffect->IsRuning())
					{
						BOOL bWork = m_pStageEffect->GetEndWork();
#ifdef _DEBUG
						InitStageEffect( STAGE_EFFECT_MASANGSOFT, 2.0f, TRUE );
#else
						InitStageEffect( STAGE_EFFECT_MASANGSOFT, 2.0f, FALSE );
#endif
						m_pStageEffect->SetEndWork( bWork );
						ChangeGameState(_LOGO);

					}
				}
			}
			break;
		case _LOGO:
			{
				if(m_pStageEffect)
				{
					m_pStageEffect->Tick();
					if(!m_pStageEffect->IsRuning())
					{
						BOOL bWork = m_pStageEffect->GetEndWork();
						InitStageEffect( STAGE_EFFECT_GAME_LOGO );
						m_pStageEffect->SetEndWork( bWork );
						ChangeGameState(_INIT);
					}
				}
			}
			break;
		case _INIT:
			{
				ShotDownGameTime();
				if(m_pStageEffect)
				{
					m_pStageEffect->Tick();
					if(!m_pStageEffect->IsRuning())
					{
						m_pStageEffect->InvalidateDeviceObjects();
						m_pStageEffect->DeleteDeviceObjects();
						SAFE_DELETE(m_pStageEffect);
// 2011. 1. 13 by jskim  
//   						if (m_bMovePlayer)
//   						{
//  							ChangeGameState(_MOVIEPLAYER);					
//  			    		} 
//  						else
//  						{
//								ChangeGameState(_SELECT);
//							}						
						ChangeGameState(_SELECT);
// end 2011. 1. 13 by jskim  
						m_pInterface->RestoreSelectObjects();	// 2004-06-03 by dhkwon , LOGO->SELECT
						
					}

					// 2008-08-11 by bhsohn ܵ  ǰԲ
					if(IsSingletonMode())
					{
						SetTempCharcaterInfo();	// ӽ÷ ĳ  						
					}
					// end 2008-08-11 by bhsohn ܵ  ǰԲ
				}
			}
			break;
		case _MOVIEPLAYER:
			if( !m_bDeviceLost )
			{
				MovieRender();
			}
            break;
		case _SELECT:
		case _CREATE:
		case _OPTION:
			{
				if(g_pCamera)
				{
					g_pCamera->SetViewPlane();
				}
				if(m_pEffectList)
					m_pEffectList->Tick();
				if(m_pUnitRender)
					m_pUnitRender->Tick(m_fElapsedTime);
				if(m_pEffectRender)
					m_pEffectRender->Tick(m_fElapsedTime);

				ShotDownGameTime();
			}
			break;
		case _MAPLOAD:
			break;
		case _SELECTCHANNEL:
			break;
		case _GAME:
		case _SHOP:
		{
			if(m_pShuttleChild && 
				COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
			{
				if(m_fUserCheckTime >= 0.0f)
				{
					m_fUserCheckTime -= m_fElapsedTime;
				}
// 2012-11-07 by bhsohn Ʈ Ŷ ó
#ifdef C_CLIENT_LIVE_TIME
				if(m_fServerLiveTime >= 0.0f)
				{
					m_fServerLiveTime -= m_fElapsedTime;
				}
#endif
// END 2012-11-07 by bhsohn Ʈ Ŷ ó
				if(m_fUserCheckTime <= 0.0f)
				{
					m_pFieldWinSocket->SendMsg(T_FC_ADMIN_GET_SERVER_STAT, NULL, 0);
					m_pIMSocket->SendMsg(T_IC_ADMIN_GET_SERVER_STAT, NULL, 0);
					
					m_fUserCheckTime = 15.0f;					
// 2012-11-07 by bhsohn Ʈ Ŷ ó
#ifdef C_CLIENT_LIVE_TIME
					m_fUserCheckTime = CLIENT_LIVE_CHECK_TIME;					
#endif
// END 2012-11-07 by bhsohn Ʈ Ŷ ó
				}

// 2012-11-07 by bhsohn Ʈ Ŷ ó
#ifdef C_CLIENT_LIVE_TIME
				if(m_fServerLiveTime <= 0.0f)
				{
//					NetworkErrorMsgBox(STRMSG_C_SERVER_0005);
					// Lock
					if(GetEnterLock())
					{
						EnterLock(FALSE);	// FALSE :Lock  TRUE : UnLock
					}
				}
#endif
// END 2012-11-07 by bhsohn Ʈ Ŷ ó
			}
			if( m_pShuttleChild &&
				COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER) && 
				m_pKeyBoard->GetAsyncKeyState( DIK_LCONTROL) && 
				m_pKeyBoard->GetAsyncKeyState( DIK_LMENU) && 
				// 2008-11-13 by bhsohn ̽ƽ ۾
				//m_pKeyBoard->GetAsyncKeyState( DIK_C))
				GetAsyncKeyState_DIK_DIJ( DIK_C))				
			{
				if(fDebugTextCheckTime < 0.0f)
				{
					m_pCamera->ChangeCamCollType();
					fDebugTextCheckTime = 1.0f;
				}
			}

			// 2006-02-27 by ispark
			// ĳ͸ 켱 Tick Ѵ.  ī޶
			if(m_pTutorial->IsTutorialMode() == TRUE)
			{
				m_pTutorial->Tick(m_fElapsedTime);
			}
			else if(m_bCharacter)						// 2005-07-21 by ispark
			{
				m_pCharacterChild->Tick(m_fElapsedTime);			// ĳ
			}
			else
			{
				m_pShuttleChild->Tick(m_fElapsedTime);				// 
			}

//			if(m_pShuttleChild && m_bLoading == FALSE)
			//////////////////////////////////////////////////////////////////////////////////////////////////
//			if(m_pCamera && m_bLoading == FALSE && !m_pShuttleChild->m_bIsCameraPattern)
			// 2005-08-16 by ispark
			if(m_pCamera && !m_pShuttleChild->m_bIsCameraPattern && m_bCharacter == FALSE)
			{
				if(m_pShuttleChild->IsObserverMode())
				{
					m_pCamera->ObserveTick();
				}
				else
				{
					m_pCamera->Tick();
				}
			}
			else if(m_bCharacter == TRUE)
			{
				m_pCamera->CharacterCamTick();
			}

			// 2006-05-17 by ispark
			if(g_pCamera)
			{
				g_pCamera->SetViewPlane();
			}
			g_pFrustum->Construct( g_pD3dDev );

			if(m_pScene)
			{
				m_pScene->Tick();
			}

			if(m_pScene)
				m_pScene->CheckObjectRenderList();

//			if(m_bLoading == TRUE)
//			{
//				m_bLoading = FALSE;
//			}
//			if(g_pCamera)
//			{
//				g_pCamera->SetViewPlane();
//			}
//			g_pFrustum->Construct( g_pD3dDev );

//			if(m_pShuttleChild)
//			{
//				m_pShuttleChild->Tick(m_fElapsedTime);
//			}
			
			if(m_pUnitRender)
				m_pUnitRender->Tick(m_fElapsedTime);
			if(m_pCharacterRender)							// 2005-07-13 by ispark
				m_pCharacterRender->Tick(m_fElapsedTime);

			if(	m_pTutorial->IsTutorialMode() == FALSE ||
				m_pTutorial->IsUseShuttleTick() == TRUE )
			{
				if(m_pEffectList)
				{
					m_pEffectList->Tick();
				}
			}

			if(m_pChat)
				m_pChat->Tick();

			if(	m_pTutorial->IsTutorialMode() == FALSE ||
				m_pTutorial->IsUseShuttleTick() == TRUE )
			{
				if(m_pEffectRender)
				{
					m_pEffectRender->Tick(m_fElapsedTime);
				}
			}
			
			// 2004-11-08 by jschoi
			m_dwSpeedHackTimer += m_fElapsedTime*1000;
			// 2006-06-15 by ispark, ð Ŷ  κ 
			if(m_dwSpeedHackTimer > 200)
			{
				SendOtherPacket();
			}

			// ǵ  üũ
			if( m_pShuttleChild &&
				//m_bActive == TRUE && // 2009-01-14 by bhsohn â忡  ּȭ MovePacketȺ  
				m_dwSpeedHackTimer > 200 &&
				m_pScene->m_byMapType != MAP_TYPE_TUTORIAL &&
				(m_bCharacter || UNIT_STATE_MOVE(m_pShuttleChild->m_dwState) || g_fSendMovePacket > 0) )
			{
//				DBGOUT("Send Move Packet %f\n", (float)m_dwSpeedHackTimer / 1000.0f);
				SendMovePacket(TRUE);
				m_nSendMovePacketCount++;
				m_dwSpeedHackTimer -= 200;
				if(m_dwSpeedHackTimer > 200)
				{
					m_dwSpeedHackTimer = 0;
				}
//				m_dwSpeedHackTimer = 0;
			}

			// 2005-12-22 by ispark, 1д  üũ
			int nCheckTime = 1000 * 60;		// 1
#ifdef _DEBUG
			nCheckTime = 1000 * 10;			// 10
#endif
			m_dwHackCheckTime += m_fElapsedTime*1000;
			if(m_pTutorial->IsTutorialMode() == FALSE &&
				//m_bActive == TRUE &&// 2009-01-14 by bhsohn â忡  ּȭ MovePacketȺ  
				m_dwHackCheckTime > nCheckTime)
			{
				SendHackTime_WeaponInfo();
				SendHackTime_EngineInfo();
				SendHackTime_TotalWeight();

				m_dwHackCheckTime = 0;
			}

			// 2005-12-22 by ispark, Ÿ  üũ
			// ĳ ¿ Ÿ  üũ (Ǹ... ߿  )
			// 10.0f ִ  
			// 2006-01-04 by ispark, 1 
			m_dwMoveCheckTime += m_fElapsedTime * 1000;			
			float fShuttleMoveLength = D3DXVec3Length(&(m_pShuttleChild->m_vPos - m_vShuttleOldPos));
			float fShuttleMoveCheck;
			if(m_pShuttleChild->m_nBooster == BOOSTER_TYPE_MAX)
			{
				fShuttleMoveCheck = (m_pShuttleChild->m_fRealShuttleSpeedBoosterOn - m_pShuttleChild->m_fTempGravity) * m_fElapsedTime + 7.0f;
//				DBGOUT("B_Move %f(%f),", 
//						fShuttleMoveCheck, 
//						m_pShuttleChild->m_fRealShuttleSpeedBoosterOn);
			}
			else
			{
				fShuttleMoveCheck = (m_pShuttleChild->m_fRealShuttleSpeedMax - m_pShuttleChild->m_fTempGravity) * m_fElapsedTime + 7.0f;
//				DBGOUT("M_Move %f(%f),", 
//						fShuttleMoveCheck, 
//						m_pShuttleChild->m_fRealShuttleSpeedMax);
			}
//			DBGOUT(" Current %f(%f)\n", 
//					fShuttleMoveLength, 
//					m_pShuttleChild->m_fShuttleSpeed);
//			DBGOUT("AdvanceTime %f\n", m_pShuttleChild->m_fAdvanceTime);

			if(m_pShuttleChild &&
				!m_pShuttleChild->m_bSkillMoveIsUse &&							// ų 
				m_bCharacter == FALSE &&										// ĳ 
				m_pTutorial->IsTutorialMode() == FALSE &&						// Ʃ丮  
				m_pShuttleChild->m_dwState == _NORMAL &&						//  ° _NORMAL 
				m_pShuttleChild->m_fAdvanceTime <= 0.0f &&						// Advace  (10) 
				!m_pShuttleChild->m_pClientParty->IsFormationFlightMove() &&	// ̵ 
				fShuttleMoveCheck < fShuttleMoveLength &&						//  ũ(ٽ)
				m_dwMoveCheckTime > nCheckTime)									// üũð 1 Ѱ
			{
				//  Ʋ ǵ   Ÿ ũٸ   ִ.
				SendHackTime_MemoryCheck(fShuttleMoveCheck, fShuttleMoveLength, m_fElapsedTime);
				m_dwMoveCheckTime = 0;
				DBGOUT("ȵŰڳ~~! (%f) (%f)\n", fShuttleMoveCheck, fShuttleMoveLength);
			}
			m_vShuttleOldPos = m_pShuttleChild->m_vPos;

			// 2006-01-10 by ispark, 30  ̻ ٸ ʱȭ(ڷ ÷  ؼ)
			if(m_dwMoveCheckTime > 1000 * 60 * 30)
				m_dwMoveCheckTime = 0;
//			if(m_pInterface)
//				m_pInterface->Tick();

			/*
			if(m_fBattleCountCheckTime > -1.0f)
			{
				m_fBattleCountCheckTime -= m_fElapsedTime;
//				if(!m_pShuttleChild->m_bPKMode && 
				if(m_fBattleCountCheckTime <= -1.0f)
				{
					m_fBattleCountCheckTime = -1.0f;
//					m_pShuttleChild->m_bPKMode = TRUE;
//					wsprintf(message,"  : Go~!!");
//					m_pChat->CreateChatChild(message,COLOR_VOIP);
					ASSERT_ASSERT(m_pSound);
					m_pSound->PlayD3DSound(SOUND_PVP_START,m_pShuttleChild->m_vPos);
				}
				//if(!m_pShuttleChild->m_bPKMode && 
				else if(m_nBattlePartyCount != (int)m_fBattleCountCheckTime)
				{
					m_nBattlePartyCount = (int)m_fBattleCountCheckTime;
					wsprintf(message,"īƮ : %d",m_nBattlePartyCount);
					m_pChat->CreateChatChild(message,COLOR_VOIP);
					if(m_nBattlePartyCount < 10)
					{
						ASSERT_ASSERT(m_pSound);
						m_pSound->PlayD3DSound(SOUND_PVP_COUNT+m_nBattlePartyCount+35,m_pShuttleChild->m_vPos);
					}
				}
			}
			*/

			ShotDownGameTime();
			break;
		}
		case _CITY:
			{
				ShotDownGameTime();
				if(g_pCamera)
				{
					g_pCamera->SetViewPlane();
				}
				//if(m_pCamera)
					//m_pCamera->Tick();
				//////////////////////////////////////////////////////////////////////////////////////////////////
				g_pFrustum->Construct( g_pD3dDev );
				if(m_pShuttleChild)
				{
					m_pShuttleChild->Tick(m_fElapsedTime);
				}
				if(m_pScene)//  Ʈ 
				{
					m_pScene->CheckObjectRenderList();
					m_pScene->m_pGround->Tick( m_fElapsedTime );// ׸  ڵ 
				}
				if(m_pEffectList)//  
					m_pEffectList->Tick();
				if(m_pEffectRender)//  Ʈ Ʈ
					m_pEffectRender->Tick(m_fElapsedTime);
				if(m_pUnitRender)
					m_pUnitRender->Tick(m_fElapsedTime);
				if(m_pChat)
					m_pChat->Tick();
//				if(m_pInterface)
//					m_pInterface->Tick();
			}
			break;
		case _SCRIPT:
			{
			}
			break;
		case _WAITING:
			{
				if(m_bClientQuit)
				{
					if(m_pStageEffect)
					{
						m_pStageEffect->Tick();
						if( !m_pStageEffect->IsRuning() )
						{
							m_pStageEffect->InvalidateDeviceObjects();
							m_pStageEffect->DeleteDeviceObjects();
							SAFE_DELETE(m_pStageEffect);
//							if(m_bClientQuit)
//							{
								ChangeGameState(_ENDGAME);
								DBGOUT("Field Server State : T_FC_CHARACTER_GAMEEND_OK, Exit Client Program..\n");
//							}
//							else
//							{
//								ChangeGameState(_SELECT);
//								DBGOUT("ʵ弭 Ȳ : T_FC_CHARACTER_GAMEEND_OK,   --> SELECTâ\n");
//							}

						}
					}
				}
//				else
//				{
//					ChangeGameState(_SELECT);
//					DBGOUT("ʵ弭 Ȳ : T_FC_CHARACTER_GAMEEND_OK,   --> SELECTâ\n");
//				}
			}
			break;
		case _GAMEOVER:
			{
				if(m_pShuttleChild)
				{
					m_bClientQuit = TRUE;
					MSG_FC_CHARACTER_GAMEEND_OK sMsg;
					sMsg.ClientIndex = m_pShuttleChild->m_myShuttleInfo.ClientIndex;
					FieldSocketCharacterGameEndOk(WM_PACKET_NOTIFY, &sMsg);
				}
				else
				{
					return E_FAIL;
				}
			}
			break;
		case _COMPLETE:
			break;
		case _PROLOGUE:
			break;
		case _ENDGAME:
			{
				return E_FAIL;
			}
			break;
		}
//	}
/*	else
	{
		if( m_pAtumIntro)
		{
			m_pAtumIntro->Tick(m_fElapsedTime) ;
		}
	}
*/	
//#ifdef _DEBUG
//	m_fDebugTimerCheckTime += m_fElapsedTime;
//	if(m_fDebugTimerCheckTime > 10)
//	{
//		DBGOUT("Send_MOVE_Packet/10sec(Timer):%d\n",m_nDebugTimerMove );
//		m_nDebugTimerMove = 0;
//		m_fDebugTimerCheckTime = 0;
//	}
//#endif

	// 2004-12-13 by jschoi - "Fade-In & Fade-Out"
	FadeEffectTick();

#ifdef _DEBUG
	m_pFxSystem->Tick(m_fElapsedTime);
#endif
	RequestEnableTick(m_fElapsedTime);

	return S_OK;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		// 2007-09-05 by bhsohn China IME Working
/// \date		2007-09-05 ~ 2007-09-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::TickImeChange()
{
	// 2007-12-18 by bhsohn Tawan IME Working
#ifdef TAIWAN_RELEASE
	return;
#endif
	// end 2007-12-18 by bhsohn Tawan IME Working
#ifdef LANGUAGE_CHINA
	DWORD dwImeChangeTime = g_input.GetImeChangeTime();
	if(0 == dwImeChangeTime)
	{
		return;
	}

	DWORD dwCurrentTime = timeGetTime();
	if(dwCurrentTime < dwImeChangeTime)
	{
		return;
	}
	DWORD dwTimeCap = dwCurrentTime - dwImeChangeTime;
	if(dwTimeCap < 1000)
	{
		return;
	}		
	m_inputkey.NextImeSelect();		
#endif
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			HRESULT CAtumApplication::InActiveFrameMove() 
/// \brief		â Ȱ  Tick
/// \author		ispark
/// \date		2006-07-06 ~ 2006-07-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
HRESULT CAtumApplication::InActiveFrameMove() 
{
	// 2004-11-08 by jschoi
	m_dwSpeedHackTimer += m_fElapsedTime*1000;
	
	if(m_pShuttleChild &&
		m_dwSpeedHackTimer > 200 &&
		m_pScene->m_byMapType != MAP_TYPE_TUTORIAL &&
		(m_bCharacter || UNIT_STATE_MOVE(m_pShuttleChild->m_dwState) || g_fSendMovePacket > 0) )
	{
		SendMovePacket(FALSE);
		m_nSendMovePacketCount++;
		if(m_dwSpeedHackTimer > 200)
		{
			m_dwSpeedHackTimer = 0;
		}
	}

	return S_OK;
}

void CAtumApplication::RenderCity() 
{
	FLOG("CAtumApplication::RenderCity()");
	g_pD3dDev->SetTransform( D3DTS_VIEW,       &m_pCamera->GetViewMatrix() );
	g_pD3dDev->SetTransform( D3DTS_PROJECTION, &m_pCamera->GetProjMatrix() );
 	g_pD3dDev->SetLight( 0, &m_pScene->m_light0 );

	if(m_pScene)// object render
	{
		m_pScene->RenderCity();
	}
//	m_pShuttleChild->Render();
//	if(g_pSOption->sReflactive)
//	{
		g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, TRUE );
		m_pShuttleChild->Render();
		g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
//	}
//	else
//	{
//		m_pShuttleChild->Render();
//	}

 	g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE, FALSE );
	g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
	g_pD3dDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
	g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );
	g_pD3dDev->SetFVF( D3DFVF_SPRITEVERTEX );
    g_pD3dDev->SetRenderState( D3DRS_FOGENABLE, FALSE );

}
/*
void CAtumApplication::RenderSleep()
{
	D3DXVECTOR3 vTemp,vTemppos;
	D3DXMATRIX mat;
	D3DXVec3Normalize(&vTemp,&(m_pCamera->GetLookatPt() - m_pCamera->GetEyePt()));
	vTemppos = m_pCamera->GetEyePt()+1.5f*vTemp;

	g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );
	g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE,  TRUE );
	g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
	g_pD3dDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCCOLOR );
	g_pD3dDev->SetRenderState( D3DRS_ZENABLE, FALSE );
	D3DXMatrixIdentity(&mat);
	mat = m_pCamera->GetBillboardMatrix();
	mat._41 = vTemppos.x;
	mat._42 = vTemppos.y;
	mat._43 = vTemppos.z;
	g_pD3dDev->SetTexture(0, NULL);
	g_pD3dDev->SetVertexShader(D3DFVF_NOSPRITE);
	g_pD3dDev->SetTransform(D3DTS_WORLD, &mat);
	g_pD3dDev->SetStreamSource(0, m_pVBSleep, sizeof(NOSPRITE));
	g_pD3dDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
}
*/
void CAtumApplication::RenderGame() 
{
	FLOG("CAtumApplication::RenderGame()");
	//  & Ʈ Ѵ.
	g_pD3dDev->SetTransform( D3DTS_VIEW,       &m_pCamera->GetViewMatrix() );
	g_pD3dDev->SetTransform( D3DTS_PROJECTION, &m_pCamera->GetProjMatrix() );
 	g_pD3dDev->SetLight( 0, &m_pScene->m_light0 );

	// Ground Render
//	if(m_pScene->m_byMapType != MAP_TYPE_TUTORIAL && m_pScene->m_pETCRender)
//	{
//		m_pScene->m_pETCRender->SkyRender();
//	}
	if(IsSkyRenderEnable( g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex ))
	{
		m_pScene->m_pETCRender->SkyRender();
	}

//#ifdef _DEBUG
	// 2005-07-28 by ispark
	// ĳ  Ʈ  
	if( m_bCharacter == FALSE && 
		g_pStoreData->FindItemInInventoryByWindowPos(POS_PROW) != NULL &&
		(g_pScene->m_bNight == TRUE ||
		IsTileMapRenderEnable(g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex) == FALSE))
	{
		g_pScene->m_light1.Position		= g_pShuttleChild->m_vPos;
		g_pScene->m_light1.Direction	= g_pShuttleChild->m_vVel;
		g_pScene->m_light1.Range		= RANGE_OF_VISION;
		g_pD3dDev->SetLight( 1, &g_pScene->m_light1 );
		g_pD3dDev->LightEnable( 1, TRUE );
	}
	else
	{
		g_pD3dDev->LightEnable( 1, FALSE );
	}
//#else
//	g_pD3dDev->LightEnable( 1, FALSE );
//#endif
	g_pD3dDev->LightEnable( 2, FALSE );
	g_pD3dDev->LightEnable( 3, FALSE );
	
	if(g_pGround)
	{
		g_pGround->Render();
	}
	
	if(m_pScene)
	{
		m_pScene->Render();
	}	
//	if( //m_pScene->m_byMapType != MAP_TYPE_TUTORIAL && 
//		m_pScene->m_byMapType != MAP_TYPE_CITY && 
//		m_pScene->m_byWeatherType != WEATHER_FOGGY)// &&
//		//IsSunRenderEnable(m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex))//ӽ ڵ
//	{
//		if(m_pEffectRender)
//			m_pEffectRender->RenderSun();
//	}

	// 2004-12-16 by jschoi - ShuttleChild UnitRenderList .
//	if(m_pShuttleChild)
//	{
//		m_pShuttleChild->Render();
//		if( (m_pCamera->GetCamType() == CAMERA_TYPE_NORMAL && 
//			m_pShuttleChild->m_bAttackMode != 2 ) ||
//			m_pShuttleChild->m_bIsCameraPattern == TRUE)// 1Ī ,    
//		{
//			if(g_pSOption->sReflactive)
//			{
//			g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, TRUE );
//			m_pShuttleChild->Render();
//			g_pD3dDev->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
//			}
//			else
//			{
//				
//			}
//		}
//	}

	// 2004-03-19 by dhkwon
	//if(m_pShuttleChild)
	//	m_pShuttleChild->RenderTrace();

	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	if(m_pShuttleChild)
	{
		if(m_pShuttleChild->m_dwState == _EXPLODING || 
			m_pShuttleChild->m_dwState == _EXPLODED	|| 
			m_pShuttleChild->m_dwState == _FALLING || 
			m_pShuttleChild->m_dwState == _FALLEN)
		{
			D3DXVECTOR3 vTemp,vTemppos;
			D3DXMATRIX mat;
			D3DXVec3Normalize(&vTemp,&(m_pCamera->GetLookatPt() - m_pCamera->GetEyePt()));
			vTemppos = m_pCamera->GetEyePt()+1.5f*vTemp;

			g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );
			g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE,  TRUE );
			g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_DESTALPHA );
			g_pD3dDev->SetRenderState( D3DRS_ZENABLE, FALSE );
			D3DXMatrixIdentity(&mat);
			mat = m_pCamera->GetBillboardMatrix();
			mat._41 = vTemppos.x;
			mat._42 = vTemppos.y;
			mat._43 = vTemppos.z;
			g_pD3dDev->SetTexture(0, NULL);
			g_pD3dDev->SetFVF(D3DFVF_NOSPRITE);
			g_pD3dDev->SetTransform(D3DTS_WORLD, &mat);
			g_pD3dDev->SetStreamSource(0, m_pVBSleep,0, sizeof(NOSPRITE));
			g_pD3dDev->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);
		}
	}

	D3DXVECTOR3 vDir = m_pCamera->GetViewDir();
	D3DXVec3Normalize(&vDir,&vDir);

	D3DXMATRIX mBillboard,mScale,m;
	D3DXVECTOR3 v,v1,vPos,vSide,vUp, vView;
	vView = m_pCamera->GetEyePt();
	vPos = vView + 100.0f*vDir;
	D3DXVec3Normalize(&vSide,&m_pCamera->GetCross());
	D3DXVec3Cross(&vUp,&vSide,&vDir);

	vPos += vUp*10.0f;
	mBillboard = m_pCamera->GetBillboardMatrix();
 	g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE, FALSE );
	g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
	g_pD3dDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
	g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   FALSE );
	g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );
	g_pD3dDev->SetFVF( D3DFVF_SPRITEVERTEX );
    g_pD3dDev->SetRenderState( D3DRS_FOGENABLE, FALSE );
}

// iCoordW 0 Ŭ ũ ʿ , ǥ iCoordX, iCoordY ȴ.
void CAtumApplication::CalcObjectSourceScreenCoords( D3DXVECTOR3 vObjPos, 
													int iScreenWidth, 
													int iScreenHeight, 
													int &iCoordX, 
													int &iCoordY, 
													int &iCoordW )
{
	FLOG("CAtumApplication::CalcObjectSourceScreenCoords");
	D3DXMATRIX matWorld, matView, matConcat, matViewportScale, matProj;
	D3DXVECTOR4 vResult;
	matViewportScale = D3DXMATRIX(iScreenWidth/2.0f, 0, 0, 0,
									0, -iScreenHeight/2.0f, 0, 0,
									0, 0, 1, 0,
									iScreenWidth/2.0f, iScreenHeight/2.0f, 0, 1);
	matView = m_pCamera->GetViewMatrix();
	D3DXMatrixIdentity(&matWorld); // no need for a world xform
	matConcat = matWorld;
	matConcat *= matView;
	matConcat *= m_pCamera->GetProjMatrix();
	matConcat *= matViewportScale;
	D3DXVec3Transform(&vResult, &vObjPos, &matConcat);
	iCoordX = (int)(vResult.x/vResult.w);
	iCoordY = (int)(vResult.y/vResult.w);
	iCoordW = (int)vResult.w;	
	// 2005-07-29 by ispark
	// Ȯ  2Dǥ  
//	D3DXMATRIX matWorld, matView, matConcat, matViewportScale, matScreen;
//	D3DXVECTOR4 vResult;
//
////  m_pd3dDevice->GetTransform( D3DTS_PROJECTION, &matViewportScale );
//	matViewportScale = m_pCamera->GetProjMatrix();
//
//	matScreen = D3DXMATRIX(iScreenWidth/2.0f, 0, 0, 0,
//							0, -iScreenHeight/2.0f, 0, 0,
//							0, 0, 1, 0,
//							iScreenWidth/2.0f, iScreenHeight/2.0f, 0, 1);
//	matView = m_pCamera->GetViewMatrix();
////	D3DXMatrixIdentity(&matWorld); // no need for a world xform
//	D3DXMatrixIdentity(&matConcat); // no need for a world xform
////	m_pd3dDevice->GetTransform( D3DTS_VIEW, &matView );
////	m_pd3dDevice->GetTransform( D3DTS_WORLD, &matWorld );
////	matConcat = matWorld;
////	matConcat = m_pCharacterChild->m_mMatrix;
//	matConcat = matConcat * matView;
////	matConcat *= m_pCamera->GetProjMatrix();
//	matConcat = matConcat * matViewportScale;
//	matConcat = matConcat * matScreen;
////	D3DXMatrixInverse( &matConcat, NULL, &matConcat );
//	D3DXVec3Transform(&vResult, &vObjPos, &matConcat);
//	iCoordX = (int)(vResult.x/vResult.w);
//	iCoordY = (int)(vResult.y/vResult.w);
//	iCoordW = (int)vResult.w;

//	D3DXVec4Transform(&vResult, &vResult, &matScreen);
}

// ݵ IME Disableϱ   Լ ȣؾѴ.
VOID CAtumApplication::CleanText()
{
	FLOG("CAtumApplication::CleanText()");
	// 2009-01-28 by bhsohn Ŀ  IME ʱȭ ǰ 
	DBGOUT("VOID CAtumApplication::CleanText() \n");
	char text[SIZE_MAX_STRING_1024];
	ZERO_MEMORY(text);
	int strlenComp = g_input.GetComp(text, sizeof(text));
	
	if(strlenComp >0)
	{
		// ϋ Ŭ
		HIMC hIMC = ::ImmGetContext( GetHwnd() );
		ImmNotifyIME(hIMC, NI_COMPOSITIONSTR, CPS_CANCEL, 0);
		ImmSetCompositionString( hIMC, SCS_SETSTR, NULL, 0, NULL, 0 );
		ImmNotifyIME(hIMC, NI_CLOSECANDIDATE, 0, 0);
		ImmReleaseContext( GetHwnd(), hIMC );
	}
	// end 2009-01-28 by bhsohn Ŀ  IME ʱȭ ǰ 

	memset(m_inputkey.m_full_str,0x00,sizeof(m_inputkey.m_full_str));
	memset(m_strChat,0x00,sizeof(m_strChat));
	m_inputkey.m_str_pos=0;
	m_inputkey.m_ime_composing=FALSE;
	g_input.ResetFontBuffer();
//	g_input.SetChangeEnterState(TRUE);	
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		// 2009-02-26 by bhsohn Japan IME
/// \date		2009-02-26 ~ 2009-02-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::CleanIMEControl()
{
	HIMC hIMC = ::ImmGetContext( GetHwnd() );
	ImmNotifyIME(hIMC, NI_COMPOSITIONSTR, CPS_CANCEL, 0);
	ImmSetCompositionString( hIMC, SCS_SETSTR, NULL, 0, NULL, 0 );
	ImmNotifyIME(hIMC, NI_CLOSECANDIDATE, 0, 0);
	ImmReleaseContext( GetHwnd(), hIMC );
}

void CAtumApplication::SetCamPosInit()
{
	FLOG("CAtumApplication::SetCamPosInit()");
    FLOAT fAspect = ((FLOAT)m_d3dsdBackBuffer.Width) / m_d3dsdBackBuffer.Height;
	// Camera Setting
	if(m_pScene->m_byMapType == MAP_TYPE_CITY)
	{
		m_pCamera->SetCityCamera();
		//m_pCamera->Init(m_pShuttleChild->m_vPos,(MAP_TYPE_CITY_UNIT_POS+D3DXVECTOR3(0.0f, 85.0f, -198.0f))-m_pShuttleChild->m_vPos,D3DX_PI/15.0f, 60.0f);
		//m_pCamera->SetProjParams( D3DX_PI*(93.0f/180.0f), fAspect, 1.0f, 10000.0f );		// 60 
	}
	else
	{
		D3DXVECTOR3 vCamStartPos = m_pShuttleChild->m_vPos-50.0f*m_pShuttleChild->m_vVel+30.0f*m_pShuttleChild->m_vUp;//D3DXVECTOR3(0.0f, 0.0f, 0.0f);
		D3DXVECTOR3 vCamEndPos = m_pShuttleChild->m_vVel*10000.0f + vCamStartPos;
//		m_pCamera->Init(m_pShuttleChild->m_vPos,m_pShuttleChild-m_vVel, 3.14f/13.0f, 60.0f);//3.14f/13.0f : ְ ī޶ ̰ 15 Ǵ  
		// 2005-08-10 by ispark
		// ĳ    Ǵ
		if(g_pD3dApp->m_bCharacter == TRUE)
		{
			D3DXVECTOR3 vPos = g_pCharacterChild->m_vPos;
			vPos.y += GetCharacterHeight(g_pCharacterChild->m_nUnitNum);
			m_pCamera->Init(vPos, g_pCharacterChild->m_vVel);
		}
		else
		{
			m_pCamera->Init(m_pShuttleChild->m_vPos,m_pShuttleChild->m_vVel, 3.14f/13.0f, 30.0f);//3.14f/13.0f : ְ ī޶ ̰ 15 Ǵ   // 2005.6.13 by dhkwon
		}
		m_pCamera->SetProjParams( D3DX_PI/3, fAspect, 1.0f, 100000.0f );		// 60 
	}
}

int CAtumApplication::MsgProcGame( UINT uMsg, WPARAM wParam, LPARAM lParam )
{
//	static int nCheckObjectList = 0;
	
	// 2004-11-11 by jschoi
	if(m_dwCheckSpeedHackTime == 0)
	{
		m_dwCheckSpeedHackTime = timeGetTime();	// ð ʱȭ
	}

	switch( uMsg )
	{
	case WM_TIMER:
		{
			switch(wParam)
			{
			case _TIMER_MOVE:
				{
					// 2004-11-11 by jschoi 찡 Ȱȭ ¿ ǵ  üũѴ.
//					if(m_bActive == TRUE)
					{
						if(m_nCheckSpeedHackCount >= 50)
						{
							DWORD dwCheckCurrentTime = timeGetTime();
							if(m_nSendMovePacketCount > 60)
							{
								MSG_FC_CHARACTER_SPEED_HACK_USER sMsg;
								memset(&sMsg,0x00,sizeof(sMsg)); 
								sMsg.dwTimeGap = dwCheckCurrentTime - m_dwCheckSpeedHackTime;
								sMsg.nSendMoveCounts = m_nSendMovePacketCount;
								m_pFieldWinSocket->SendMsg( T_FC_CHARACTER_SPEED_HACK_USER, (char*)&sMsg, sizeof(sMsg)); 
								DBGOUT("Send to Server SpeedHack User.(Gap:%d,Count:%d)\n",
									sMsg.dwTimeGap,sMsg.nSendMoveCounts);
							}
//							DBGOUT("m_nSendMovePacketCount : %d , sMsg.dwTimeGap : %d\n",m_nSendMovePacketCount,dwCheckCurrentTime - m_dwCheckSpeedHackTime);
							m_nSendMovePacketCount = 0;
							m_nCheckSpeedHackCount = 0;
							m_dwCheckSpeedHackTime = dwCheckCurrentTime;
						}
						m_nCheckSpeedHackCount++;
					}
					
					// 2008-01-16 by bhsohn 1ʵ  Ŭ̾Ʈ ߰,  Ŷ 					
					if(IsCompultionGame(TIME_MOVE_CAP))
					{
						SendMovePacket(FALSE);
					}
					
					// 2008-01-16 by bhsohn 1ʵ  Ŭ̾Ʈ ߰,  Ŷ 
					// 2004-11-08 by jschoi , cmkwon
					// ̰ 찡 Ȱȭ(Ŀ Ҿ  T_FC_MOVE .
					// 2006-07-06 by ispark, SendMovePacket Ȱȭ ϶ . m_bActive װ ִ.
//					if( m_bActive == FALSE && 
//						m_pScene->m_byMapType != MAP_TYPE_TUTORIAL &&
//						UNIT_STATE_MOVE(m_pShuttleChild->m_dwState) )
//					{
//						// 2008-01-15 by bhsohn α׷   ó
//						DBGOUT("SendMovePacket(FALSE); \n");
//
//						SendMovePacket(FALSE);
//						g_fSendMovePacket -= m_fElapsedTime;
//						m_dwCurTickTime = timeGetTime();
//						//float fDistance = D3DXVec3Length(&(m_pShuttleChild->m_vPos-m_vClientOldPos));
//						USHORT		sTimeGap = m_dwCurTickTime - m_dwLastTickTime;
//						MSG_FC_MOVE sMsg;
//						memset(&sMsg,0x00,sizeof(sMsg));
//						sMsg.ClientIndex = m_pShuttleChild->m_myShuttleInfo.ClientIndex;
//
//						// 2004-11-01 by jschoi with cmkwon
//						// Window Ŀ Ҿ (Alt+Tab) FrameMove(Tick)  Ƿ,
//						// m_dwSpeedHackTimer  ׻ 0 ȴ.   쿡  200̸ ð ش.
//
//						sMsg.TimeGap = 200;
//						if(m_dwSpeedHackTimer == 0)
//						{
//							sMsg.TimeGap = 200;
//						}
//						else
//						{
//							sMsg.TimeGap = m_dwSpeedHackTimer;
//						}
//
//						//if(fDistance > 255)
//						//	fDistance = 255.0f;
//						//sMsg.DistanceGap = (BYTE)fDistance;
//						sMsg.PositionVector = m_pShuttleChild->m_vPos;
//						sMsg.TargetVector = m_pShuttleChild->m_vVel*1000.0f;
//						D3DXVECTOR3 vUp;
//						vUp.x = m_pShuttleChild->m_mMatrix._21;
//						vUp.y = m_pShuttleChild->m_mMatrix._22;
//						vUp.z = m_pShuttleChild->m_mMatrix._23;
//						sMsg.UpVector = vUp*1000.0f;
//						//sMsg.UpVector = m_pShuttleChild->m_vUp*1000.0f;
//						m_pFieldWinSocket->SendMsg( T_FC_MOVE, (char*)&sMsg, sizeof(sMsg));
//						m_vClientOldPos = m_pShuttleChild->m_vPos;
//						m_dwLastTickTime = m_dwCurTickTime;
//						m_dwSpeedHackTimer = 0;
//						if(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
//						{
//							m_pShuttleChild->SendMoveWeaponVel();
//						}
//#ifdef _DEBUG
//						m_nDebugTimerMove++;
//#endif
//					}
				}
				break;
			}
		}
		break;
	case WM_MOUSEWHEEL:
		{
			// 2005-08-17 by ispark
			if((m_pCamera->m_bIsCamControl ||
				g_pShuttleChild->m_dwState == _LANDED) &&
				m_bCharacter == FALSE)
			{
				m_pCamera->SetControlCamPos((int)wParam);
			}
		}
		break;
	case WM_LBUTTONUP:
		{
			if(m_bDeleteItemSend && COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
			{// - Ű      غ ϰ ȴ.
				m_bDeleteItemSend = FALSE;
				m_pScene->SendItemDeleteItemAdmin( LOWORD(lParam), HIWORD(lParam) );
			}
		}
		break;
	case WM_KEYDOWN:
		{
#ifdef _DEBUG
			// 2005-11-16 by ispark
			//  ÿ '*'Ű  ̺Ʈ Ʈ ̰ 
			if(wParam == 106 && COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION))
			{
				m_bEventObjectRender = !m_bEventObjectRender;
			}
#endif

			if(wParam == 109 && COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
			{// - Ű      غ ϰ ȴ.
				m_bDeleteItemSend = TRUE;
			}

			if(m_bChatMode && wParam == 38 && m_strChat[0] == '"')
			{// Up
				if(m_pShuttleChild->m_bOldPToPPos != 200)
				{
					if(strlen(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos]))
					{
						if(m_pShuttleChild->m_bOldPToPPos == MAX_CHAT_PTOP_CONT - 1)
							m_pShuttleChild->m_bOldPToPPos = 0;
						else
							m_pShuttleChild->m_bOldPToPPos++;
						if(strlen(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos]))
						{
							memset(m_strChat,0x00,SIZE_MAX_CHAT_MESSAGE);
							m_strChat[0] = '"';
							strncpy(m_strChat+1,m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos],strlen(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos]));
							m_strChat[strlen(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos])+1] = ' ';
							memset(m_inputkey.m_full_str,0x00,sizeof(m_inputkey.m_full_str));
							strncpy(m_inputkey.m_full_str,m_strChat,strlen(m_strChat));
							m_inputkey.m_str_pos = strlen(m_strChat);
						}
						else
						{
							if(m_pShuttleChild->m_bOldPToPPos == 0)
								m_pShuttleChild->m_bOldPToPPos = MAX_CHAT_PTOP_CONT-1;
							else
								m_pShuttleChild->m_bOldPToPPos--;
						}
						return 0;
					}
				}
			}
			if(m_bChatMode && wParam == 40 && m_strChat[0] == '"')
			{// Down
				if(m_pShuttleChild->m_bOldPToPPos != 200)
				{
					if(strlen(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos]))
					{
						if(m_pShuttleChild->m_bOldPToPPos == 0)
							m_pShuttleChild->m_bOldPToPPos = MAX_CHAT_PTOP_CONT-1;
						else
							m_pShuttleChild->m_bOldPToPPos--;
						if(strlen(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos]))
						{
							memset(m_strChat,0x00,SIZE_MAX_CHAT_MESSAGE);
							m_strChat[0] = '"';
							strncpy(m_strChat+1,m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos],strlen(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos]));
							m_strChat[strlen(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bOldPToPPos])+1] = ' ';
							memset(m_inputkey.m_full_str,0x00,sizeof(m_inputkey.m_full_str));
							strncpy(m_inputkey.m_full_str,m_strChat,strlen(m_strChat));
							m_inputkey.m_str_pos = strlen(m_strChat);
						}
						else
						{
							if(m_pShuttleChild->m_bOldPToPPos == MAX_CHAT_PTOP_CONT - 1)
								m_pShuttleChild->m_bOldPToPPos = 0;
							else
								m_pShuttleChild->m_bOldPToPPos++;
						}
					}
				}
			}
		}
		break;
	}

	if(m_bCharacter)
	{
		if(m_pCharacterChild)
		{
			m_pCharacterChild->WndProc(uMsg, wParam, lParam);
		}
	}
	else
	{
		// 2006-09-20 by ispark, Ʃ丮 üũ
		if((g_pTutorial->IsTutorialMode() == FALSE ||
			g_pTutorial->IsUseShuttleTick() == TRUE ) &&
			m_pShuttleChild)
		{
			m_pShuttleChild->WndProc(uMsg,wParam,lParam);
		}
	}

	if(m_pTutorial->IsTutorialMode() == TRUE)
		m_pTutorial->WndProc(uMsg,wParam,lParam);

	return INF_MSGPROC_NORMAL;
}
int CAtumApplication::MsgProcCity( UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	static BOOL bRbuttonDown = FALSE;// camera control
	static POINT ptOld;// camera control
	switch(uMsg)
	{
	case WM_MOUSEWHEEL:
		{
			if(!g_pInterface->m_pCityBase->GetCurrentBuildingNPC())
			{
				m_pCamera->SetCameraZoomInOut( (int)wParam );// camera control
			}
		}
		break;
	case WM_RBUTTONDOWN:
		{
			bRbuttonDown = TRUE;// camera control

			ptOld.x = LOWORD(lParam);
			ptOld.y = HIWORD(lParam);

			CheckMouseReverse(&ptOld);
		}
		break;
	case WM_RBUTTONUP:
		{
			bRbuttonDown = FALSE;// camera control
		}
		break;
	case WM_MOUSEMOVE:
		{
			if(bRbuttonDown && !g_pInterface->m_pCityBase->GetCurrentBuildingNPC())// camera control
			{
				POINT pt;
				pt.x = LOWORD(lParam);
				pt.y = HIWORD(lParam);

				CheckMouseReverse(&pt);
				m_pCamera->SetCameraRotate( (int)pt.x - (int)ptOld.x, (int)pt.y - (int)ptOld.y );
				ptOld = pt;
			}
		}
		break;
//	case WM_KEYDOWN:
//		{
//			const int nKeyMove = 1; // Ű 
//			switch(wParam)
//			{
//			case VK_LEFT:
//				m_pCamera->SetCameraRotate(nKeyMove,0);
//				break;
//			case VK_RIGHT:
//				m_pCamera->SetCameraRotate(-nKeyMove,0);
//				break;
//			case VK_UP:
//				m_pCamera->SetCameraRotate(0,nKeyMove);
//				break;
//			case VK_DOWN:
//				m_pCamera->SetCameraRotate(0,-nKeyMove);
//				break;
//			case VK_PRIOR:
//				m_pCamera->SetCameraZoomInOut(nKeyMove);
//				break;
//			case VK_NEXT:
//				m_pCamera->SetCameraZoomInOut(-nKeyMove);
//				break;
//			}
//		}
//		break;
	}
	// 2005-07-21 by ispark
	// ĳ ߰
	if(m_bCharacter)
	{
		if(m_pCharacterChild)
			m_pCharacterChild->WndProc(uMsg, wParam, lParam);
	}
	else
	{
	if(m_pShuttleChild)
		m_pShuttleChild->WndProc(uMsg,wParam,lParam);
	}
	return INF_MSGPROC_NORMAL;
}
int CAtumApplication::MsgProcCreate( UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	switch(uMsg)
	{
		// 2008-12-15 by bhsohn Ÿ IMEý  ȵǴ  ذ
	case WM_IME_STARTCOMPOSITION:
		{
			g_input.SetImeRtnValue(TRUE);
			return INF_MSGPROC_BREAK;
		}
		break;
		// end 2008-12-15 by bhsohn Ÿ IMEý  ȵǴ  ذ
	case WM_IME_NOTIFY:
	case WM_IME_COMPOSITION:
	case WM_INPUTLANGCHANGE:
	case WM_IME_ENDCOMPOSITION:
	case WM_IME_SETCONTEXT:	
	case WM_CHAR:
		{
			g_nRenderCandidate = SET_CREATEMENU_CANDIDATE;
			int bFlag = FALSE;
			int nLanguageChoice = 0;
			
#ifdef LANGUAGE_VIETNAM
			if(m_dwGameState == _SELECT || m_dwGameState == _CREATE)
				g_pD3dApp->m_inputkey.SetInputLanguage(INPUT_LANGUAGE_ENG);
#endif
			if(INF_MSGPROC_BREAK == g_pD3dApp->m_inputkey.KeyMapping(g_pD3dApp->GetHwnd(), uMsg, wParam, lParam))
				bFlag = TRUE;			

			//////////////////////////////////////////////////////////////////////////
			char text[256];
			char stringtext[512];
			ZERO_MEMORY(text);
			ZERO_MEMORY(stringtext);

			// 2007-11-06 by bhsohn Ʈ ڻ  ԷŰ ȵǴ  ó
			//int strlenInput = g_input.GetInput(text, sizeof(text));
			int nLanguageConversion = g_pD3dApp->m_inputkey.GetInputLanguage();					
			int strlenInput = g_input.GetInput(text, sizeof(text), nLanguageConversion);
			
			strcpy(stringtext, text);
			ZERO_MEMORY(text);
			int strlenComp = g_input.GetComp(text, sizeof(text));
			strcat(stringtext, text);
			
			// 2008-10-10 by bhsohn Tawan IME Working
//#ifdef TAIWAN_RELEASE
			// 2008-12-10 by bhsohn JAPAN IME Working
#if defined(TAIWAN_RELEASE)
			if(strlenComp>=20)
			{
				keybd_event(VK_SPACE, 0, KEYEVENTF_EXTENDEDKEY, 0);
			}
			// 2009-02-11 by bhsohn Japan IME Fix
#elif defined(LANGUAGE_JAPAN)

#else
			if(strlenComp>=8)
			{
				keybd_event(VK_SPACE, 0, KEYEVENTF_EXTENDEDKEY, 0);
			}
#endif
			// end 2008-10-10 by bhsohn Tawan IME Working

			// 2009-02-10 by bhsohn Japan Charcter Create
#if defined(LANGUAGE_JAPAN)
			if( strlenInput+strlenComp >= (24))
			{
				keybd_event(VK_BACK, 0, KEYEVENTF_EXTENDEDKEY, 0);
 			}
#else
			if( strlenInput+strlenComp >= SIZE_MAXUSE_CHARACTER_NAME )	// 2006-05-20 by ispark
			{
				keybd_event(VK_BACK, 0, KEYEVENTF_EXTENDEDKEY, 0);
 			}
#endif			
			// end 2009-02-10 by bhsohn Japan Charcter Create

			if(g_pSelect && g_pSelect->m_pCreateMenu)
			{
				if(strlen(stringtext)>0)
				{
					vector<string> vecTemp;
					// 2009-02-10 by bhsohn Japan Charcter Create
#if defined(LANGUAGE_JAPAN)
					::StringCullingUserData(stringtext, MAX_PATH, &vecTemp);
					strncpy(g_pSelect->m_pCreateMenu->m_strCharacterName, (char*)vecTemp[0].c_str(),MAX_PATH);
#else
					::StringCullingUserData(stringtext, SIZE_MAXUSE_CHARACTER_NAME, &vecTemp);
					strncpy(g_pSelect->m_pCreateMenu->m_strCharacterName, (char*)vecTemp[0].c_str(),SIZE_MAXUSE_CHARACTER_NAME);
#endif
					
					m_inputkey.m_str_pos  = strlen(g_pSelect->m_pCreateMenu->m_strCharacterName)+1;
				}
				else
				{
					ZERO_MEMORY(g_pSelect->m_pCreateMenu->m_strCharacterName);
				}
			}
			//////////////////////////////////////////////////////////////////////////
			if(bFlag == TRUE)
				return INF_MSGPROC_BREAK;

		}
		break;
		// 2007-06-11 by bhsohn China IME Working
	case WM_KEYDOWN:
		{
			#ifdef LANGUAGE_CHINA
				return g_pD3dApp->m_inputkey.OnIMEKeyDown(g_pD3dApp->GetHwnd(), uMsg, wParam, lParam);
			#endif

		}
		break;
	}
	return INF_MSGPROC_NORMAL;
}

LRESULT CAtumApplication::MsgProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	FLOG("CAtumApplication::MsgProc()");
	// 2008-11-06 by bhsohn 콺 α  
	// 2008-06-20 by bhsohn EP3 ɼǰ ó
//	if(IsWindowMode())
//	{		
//		//   콺 ݱ
//		if(g_pD3dApp->IsOptionEtc(OPTION_RADIO_MOUSE_LOCK))
//		{
//			ForceMousePos(uMsg, wParam, lParam);
//		}
//	}
	// end 2008-06-20 by bhsohn EP3 ɼǰ ó
	// end 2008-11-06 by bhsohn 콺 α  

	// 2008-12-15 by bhsohn Ÿ IMEý  ȵǴ  ذ
	g_input.SetImeRtnValue(FALSE);

	if(m_pStageEffect)
	{
		m_pStageEffect->WndProc( uMsg, wParam, lParam );
	}
	if(m_pInterface)
	{
		if(m_pInterface->WndProc(uMsg,wParam,lParam) == INF_MSGPROC_BREAK)
			return S_OK;
	}
	switch(uMsg)
	{	
	case 78:// ! ?
		{
			return S_OK;
		}
		break;
	case WM_CREATE:
		{			
			g_input.OnInputLanguageChange(hWnd, 0, (LPARAM)GetKeyboardLayout(0));			
			SetHanFontLang(lParam);

//#ifdef LANGUAGE_KOREA
#if defined(KOR_HANGEUL_START_HSSON)
			// ѱ  
			// 2006-09-27 by ispark, ѱ 
			g_pD3dApp->m_inputkey.ChangeInputLanguage(hWnd);
#elif defined(LANGUAGE_CHINA)			
			// 2007.04.24 by bhsohn China IME Working
			//g_pD3dApp->m_inputkey.SetInputLanguage(INPUT_LANGUAGE_CHINA);	
			// 2007-06-21 by bhsohn China IME Working
			//g_pD3dApp->m_inputkey.SetMSPYIME();
#endif			
		}
		break;
	case WM_ASYNC_EVENT:
		{
			m_pFieldWinSocket->OnAsyncEvent(lParam);
			return S_OK;
		}
		break;
	case WM_PACKET_NOTIFY:
		{
			// 2007-11-22 by bhsohn Ʒ ռ
			//OnRecvFieldSocketMessage(wParam);
			OnRecvFieldSocketMessage(wParam, uMsg);
			return S_OK;
		}
		// 2007-11-22 by bhsohn Ʒ ռ
	case WM_ASYNC_ARENA_EVENT:
		{
			m_pFieldWinSocket->OnArenaAsyncEvent(lParam);
			return S_OK;
		}		
		break;	
	case WM_PACKET_ARENA_NOTIFY:
		{			
			OnRecvFieldSocketMessage(wParam, uMsg);
			return S_OK;
		}
		break;
		// end 2007-11-22 by bhsohn Ʒ ռ
	case WM_IM_ASYNC:
		{
			m_pIMSocket->OnAsyncEvent(lParam);
			return S_OK;
		}
		break;
	case WM_IM_NOTIFY:
		{
			// 2007-11-22 by bhsohn Ʒ ռ
			//OnRecvIMSocketMessage(wParam);
			OnRecvIMSocketMessage(wParam, uMsg);
			return S_OK;
		}		
		break;
	// 2007-11-22 by bhsohn Ʒ ռ
	case WM_IM_ARENA_ASYNC:
		{
			m_pIMSocket->OnArenaAsyncEvent(lParam);
			return S_OK;
		}		
		break;
	case WM_IM_ARENA_NOTIFY:
		{
			OnRecvIMSocketMessage(wParam, uMsg);
			return S_OK;
		}		
		break;
	// end 2007-11-22 by bhsohn Ʒ ռ
	
	case WM_COPYDATA:
		{
			OnRecvCopyData( wParam, (COPYDATASTRUCT*)lParam );
		}
		break;
	case WM_TIMER:
		{
			if( wParam == _TIMER_ALIVE)
			{
				// 2007-11-22 by bhsohn Ʒ ռ
				//char buffer[SIZE_MAX_PACKET];
				int nType = T_FC_CONNECT_ALIVE;
				if( m_pFieldWinSocket && 
					m_pFieldWinSocket->IsConnected())
				{
					// 2007-11-22 by bhsohn Ʒ ռ
//					memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
//					m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER);					
					m_pFieldWinSocket->SendMsg(nType, NULL, NULL);
					// end 2007-11-22 by bhsohn Ʒ ռ
				}
				if( m_pIMSocket &&
					m_pIMSocket->IsConnected())
				{
					nType = T_IC_CONNECT_ALIVE;
					// 2007-11-22 by bhsohn Ʒ ռ
//					memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
//					m_pIMSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER);
					m_pIMSocket->SendMsg(nType, NULL, NULL);
					// end 2007-11-22 by bhsohn Ʒ ռ
				}
#ifndef _DEBUG
				// 2008-01-11 by bhsohn 1е  Ŭ̾Ʈ ߰ ϸ Ŭ̾Ʈ  
				//if(IsCompultionGame(TIME_COMPULSION_CAP))
				// 2009-02-02 by bhsohn  ߿  üũ üũ 
				if((!m_bClientQuit) && (_WAITING != GetGameState())
#ifdef C_BAZZER_NOT_EXIT// 2013-01-08 by jhjang λ  ¿ Ŭ̾Ʈ     ߰
					&& !((_SHOP == GetGameState()) && g_pInterface->m_pBazaarShop)
#endif					// end 2013-01-08 by jhjang λ  ¿ Ŭ̾Ʈ     ߰
					&& IsCompultionGame(TIME_COMPULSION_CAP))					
				{
					//     ų Ȳ̴.
					NetworkErrorMsgBox(STRMSG_C_080111_0201);
					
				}
				// end 2007-01-11 by bhsohn 1е  Ŭ̾Ʈ ߰ ϸ Ŭ̾Ʈ  
#endif
			}
			
		break;
		}
	// 2008-01-11 by bhsohn Ŀ , Ű ó ȵǰ 
	case WM_KILLFOCUS:
		{
			if(m_pKeyBoard)
			{				
				m_pKeyBoard->SetKeyBoardFocus(FALSE);			
			}
			// 2008-11-06 by bhsohn 콺 α  			
			{
				SetClipCursor(FALSE);
			}
		}
		break;
	case WM_SETFOCUS:
		{
			if(m_pKeyBoard)
			{				
				m_pKeyBoard->SetKeyBoardFocus(TRUE);			
			}
			// 2008-11-06 by bhsohn 콺 α  			
			{
				RefreshMouseMode();
			}		
			// 2008-11-13 by bhsohn ̽ƽ ۾
			CJoyStickFreedback *pJoyStickFreedback = GetJoyStickFeedback();
			if((IsUseJoyStick()) && pJoyStickFreedback)
			{
				//   ȵ´.
				if(pJoyStickFreedback->IsEffectStarted())
				{
					pJoyStickFreedback->DeviceAcquire();
				}
				else
				{
					pJoyStickFreedback->RqEffectStarted(TRUE);
				}
			}
			

			// end 2008-11-13 by bhsohn ̽ƽ ۾
		}
		break;
	// end 2008-01-11 by bhsohn Ŀ , Ű ó ȵǰ 
	//case WM_IME_STARTCOMPOSITION:
		// 2008-12-15 by bhsohn Ÿ IMEý  ȵǴ  ذ
	case WM_IME_STARTCOMPOSITION:
		{			
			g_input.SetImeRtnValue(TRUE);			
			if(m_bChatMode == FALSE && m_dwGameState != _CREATE)
				return 0L;
		}
		break;
	case WM_IME_SETCONTEXT:
		{
			lParam = 0;
			return DefWindowProc( hWnd, uMsg, wParam, lParam );
		}
		break;
		// end 2008-12-15 by bhsohn Ÿ IMEý  ȵǴ  ذ
	case WM_IME_NOTIFY:
	case WM_IME_COMPOSITION:
	case WM_INPUTLANGCHANGE:	
	case WM_IME_ENDCOMPOSITION:
	//case WM_IME_SETCONTEXT:
		{
			if(m_bChatMode == FALSE && m_dwGameState != _CREATE)
				return 0L;
		}
		break;

		// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	case WM_ADDMSGBOX:
		{
			g_pGameMain->m_pInfWindow->AddMsgBox( reinterpret_cast<char*>(lParam), wParam );
		}
		break;

		// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	}

	switch(m_dwGameState)
	{
	case _LOGO:
		{
		}
		break;
	case _INIT:
		{
		}
		break;
	case _SELECT:
		{
		}
		break;
	case _CREATE:
		{
			if( MsgProcCreate( uMsg, wParam, lParam ) == INF_MSGPROC_BREAK)
			{
				return S_OK;
			}
		}
		break;
	case _OPTION:
		{
		}
		break;
	case _MAPLOAD:
		{
		}
		break;
	case _GAME:
	case _SHOP:
		{
			if( MsgProcGame( uMsg, wParam, lParam ) == INF_MSGPROC_BREAK)
			{
				return S_OK;
			}
		}
		break;
//	case _SHOP:
//		{
//			if( MsgProcShop( uMsg, wParam, lParam ) == INF_MSGPROC_BREAK)
//			{
//				return S_OK;
//			}
//		}
//		break;
	case _CITY:
		{
			if(MsgProcCity( uMsg, wParam, lParam ) == INF_MSGPROC_BREAK)
			{
				return S_OK;
			}
		}
		break;
	case _SCRIPT:
		{
		}
		break;
	case _WAITING:
		{
		}
		break;
	case _GAMEOVER:
		{
		}
		break;
	case _COMPLETE:
		{
		}
		break;
	case _PROLOGUE:
		{
		}
		break;
	case _ENDGAME:
		{
		}
		break;
	case _ENDCLIENT:
		{
		}
		break;
	}
	// Framework ⺻ ޼ ó 
	return CD3DApplication::MsgProc( hWnd, uMsg, wParam, lParam );
}

HRESULT CAtumApplication::ConfirmDevice( D3DCAPS9* pCaps, DWORD dwBehavior,
                                          D3DFORMAT Format )
{
    // This sample wants mixed ver0tex processing rather than hardware
    // vertex processing so it can fallback to sw processing if the
    // device supports fewer than three matrices when skinning.
    if( dwBehavior & D3DCREATE_HARDWARE_VERTEXPROCESSING || dwBehavior & D3DCREATE_MIXED_VERTEXPROCESSING)
        return E_FAIL;

	return S_OK;
}

VOID CAtumApplication::CheckError(DWORD err)
{
	FLOG("CAtumApplication::CheckError(DWORD err)");
	char buf[256];
	switch(err)
	{
	case APP_ERR_MAPLOAD:
		{
			wsprintf(buf,STRERR_C_RESOURCE_0003);//"Map  ε(Ϲ) ϴµ  Ͽϴ. α׷ մϴ!"
		}
		break;
	case CLIENT_ERR_MESHLOAD:
		{
			wsprintf(buf,STRERR_C_RESOURCE_0004);//"Mesh  ε(Ϲ) ϴµ  Ͽϴ. ҽ Ȯ ֽʽÿ!"
		}
		break;
	case CLIENT_ERR_TEXINIT:
		{
			wsprintf(buf,STRERR_C_RESOURCE_0005);//"Texture  ʱȭ ϴµ  Ͽϴ. ҽ Ȯ ֽʽÿ!"
		}
		break;
	case CLIENT_ERR_SHUTTLE_MESHLORD:
		{
			wsprintf(buf,STRERR_C_RESOURCE_0006);//"Ʋ Mesh  εϴµ  Ͽϴ. ҽ Ȯ ֽʽÿ!"
		}
		break;
	case CLIENT_ERR_SHUTTLE_EFFECTINIT:
		{
			wsprintf(buf,STRERR_C_RESOURCE_0007);//"Ʋ Effect  ʱȭ ϴµ  Ͽϴ. ҽ Ȯ ֽʽÿ!"
		}
		break;
	case CLIENT_ERR_SHUTTLE_EFFECTRESTORE:
		{
			wsprintf(buf,STRERR_C_RESOURCE_0008);//"Ʋ Effect  Restore ϴ  ߻Ͽϴ. α׷ մϴ."
		}
		break;
	case CLIENT_ERR_WEAPON_TEXINIT:
		{
			wsprintf(buf,STRERR_C_RESOURCE_0009);//"Weapon Texture  ʱȭ ϴµ  Ͽϴ. ҽ Ȯ ֽʽÿ!"
		}
		break;
	case CLIENT_ERR_WEAPON_VBRESTORE:
		{
			wsprintf(buf,STRERR_C_RESOURCE_0010);//"Weapon VertexBuffer Restore ϴ  ߻Ͽϴ. α׷ մϴ."
		}
		break;
	}
	NetworkErrorMsgBox(buf);
}

void CAtumApplication::LoadPath( char* strPath, UINT nType, char * strFileName )
{
	FLOG("CAtumApplication::LoadPath( char* strPath, UINT nType, char * strFileName )");
	char buf[256];
	if(LoadString(m_hInstance, nType, buf, sizeof(buf)) == 0)
		strPath[0] = NULL;
	else
		wsprintf(strPath, "%s%s", buf, strFileName );
}

FLOAT CAtumApplication::Distance3DTo2D(D3DXVECTOR3 vPos1
									   , D3DXVECTOR3 vPos2)
{
	FLOG("CAtumApplication::Distance3DTo2D(D3DXVECTOR3 vPos1, D3DXVECTOR3 vPos2)");
	D3DXVECTOR2 v1, v2;
	v1.x = vPos1.x;
	v1.y = vPos1.z;
	v2.x = vPos2.x;
	v2.y = vPos2.z;
	return D3DXVec2Length(&(v1-v2));
}

VOID CAtumApplication::ChangeEffectTexture(CAtumNode * pNode,char * str)
{
	FLOG("CAtumApplication::ChangeEffectTexture(CAtumNode * pNode,char * str)");
	CAppEffectData * pEff = (CAppEffectData *)pNode;
	if(pEff->m_pCharacterInfo)
	{
		map<BodyCond_t,CBodyConditionInfo*>::iterator it = pEff->m_pCharacterInfo->m_mapBodyCondition.find(pEff->m_bodyCondition);
		if(it != pEff->m_pCharacterInfo->m_mapBodyCondition.end())
		{
			CBodyConditionInfo* pBody = it->second;
			vector<CEffectInfo*>::iterator itEffect = pBody->m_vecEffect.begin();
			while(itEffect != pBody->m_vecEffect.end())
			{
				CEffectInfo* pEffect = *itEffect;
				pEffect->SetTexture(str);
				itEffect++;
			}
		}
	}
}

int CAtumApplication::GetScreenShotNumber()
{
	FLOG("CAtumApplication::GetScreenShotNumber()");
	WIN32_FIND_DATA FindFileData;
	HANDLE hFind;

	static int nNumber = 1;
	while(TRUE)
	{
		char buf[64];
//		wsprintf(buf, "ATM%05d.jpg", nNumber);
		// 2009-02-03 by bhsohn ũ  
		//wsprintf(buf, "ATM%05d.bmp", nNumber);
		wsprintf(buf, "%sATM%05d.bmp", SCREENSHOT_FILE_PATH, nNumber);
		// end 2009-02-03 by bhsohn ũ  
		DBGOUT("CAtumApplication::GetScreenShotNumber(),Target file is %s.\n", buf);
		hFind = FindFirstFile(buf, &FindFileData);

		if (hFind == INVALID_HANDLE_VALUE) 
		{
			DBGOUT ("CAtumApplication::GetScreenShotNumber(),file number founded %d\n", nNumber);
			return nNumber;
		} 
		else 
		{
			DBGOUT ("CAtumApplication::GetScreenShotNumber(),file [%s] exists.\n", FindFileData.cFileName);
			FindClose(hFind);
		}
		nNumber++;
		if(nNumber > 99999)
			break;
	}
	return -1;
}

void CAtumApplication::TakeScreenShot(IDirect3DDevice9* device
									  , char* file_name
									  , int screenx
									  , int screeny)
{
	FLOG("CAtumApplication::TakeScreenShot");
	IDirect3DSurface9* frontbuf; //this is our pointer to the memory location containing our copy of the
								//front buffer

	//now we create the image that our screen shot will be copied into
	//NOTE: Surface format of the front buffer is D3DFMT_A8R8G8B8 when it is returned
	// 2005-01-04 by jschoi
//	device->CreateImageSurface(screenx, screeny, D3DFMT_A8R8G8B8, &frontbuf);
	device->CreateOffscreenPlainSurface(screenx, screeny, D3DFMT_A8R8G8B8,D3DPOOL_DEFAULT , &frontbuf,NULL);

	//now we copy the front buffer into our surface
	//HRESULT hr = device->GetFrontBuffer(frontbuf);
	// 2005-01-04 by jschoi
//	HRESULT hr = device->GetBackBuffer(0,D3DBACKBUFFER_TYPE_MONO,&frontbuf);
	HRESULT hr = device->GetBackBuffer(0,0,D3DBACKBUFFER_TYPE_MONO,&frontbuf);

	//error checking
	if(hr != D3D_OK)
	{
		//do error handling etc...
		frontbuf->Release(); //release the surface so there is no memory leak
		return;
	}

	// 2009-02-03 by bhsohn ũ  	
	CreateDirectory(SCREENSHOT_FILE_PATH, NULL);	

	char szScreenShotPath[MAX_PATH];
	ZERO_MEMORY(szScreenShotPath);
	wsprintf(szScreenShotPath, "%s%s", SCREENSHOT_FILE_PATH, file_name);	
	// end 2009-02-03 by bhsohn ũ  

	//now write our screen shot to a bitmap file
	//the last 2 params are NULL because we want the entire front buffer and no palette
	// 2009-02-03 by bhsohn ũ  
	//D3DXSaveSurfaceToFile(file_name, D3DXIFF_BMP, frontbuf, NULL, NULL);
	D3DXSaveSurfaceToFile(szScreenShotPath, D3DXIFF_BMP, frontbuf, NULL, NULL);
	// end 2009-02-03 by bhsohn ũ  

	char buf[256];
	wsprintf(buf, STRMSG_C_ETC_0005, file_name);//"%s Ͽ ũ  Ǿϴ."
	m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
	//release the surface so there is no memory leak
	frontbuf->Release();

// by cmkwon
	//HANDLE fhandle = CreateFile(file_name,GENERIC_WRITE,0,NULL,OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	// 2009-02-03 by bhsohn ũ  
	//HANDLE fhandle = CreateFile(file_name,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE fhandle = CreateFile(szScreenShotPath,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	// end 2009-02-03 by bhsohn ũ  

	// 2007-06-04 by bhsohn   ð ũ 
	ATUM_DATE_TIME time = GetServerDateTime();
	if(fhandle != INVALID_HANDLE_VALUE)
	{
		DrawBMPText(time, &fhandle);
	}

	if(fhandle == INVALID_HANDLE_VALUE)
	{
//		DBGOUT (" ũѵ   %d,    %d\n", g_pGameMain->m_pChat->m_nCurrentBufferIndex[CHAT_TAB_NUMBER], 
//			g_pGameMain->m_pChat->m_nStartBufferIndex[CHAT_TAB_NUMBER]);
	}
	else if(g_pGameMain && g_pGameMain->m_pChat)
	{
		DWORD dwWritten;
		SetFilePointer(fhandle, 0, 0, FILE_END);
		CINFGameMainChat * pTmChat = g_pGameMain->m_pChat;
				
//		int  index = pTmChat->m_nStartBufferIndex[pTmChat->m_nCurrentTab]-pTmChat->m_nCurrentBufferIndex[pTmChat->m_nCurrentTab]-1;
		int  index = pTmChat->m_ArrChatTab.m_nStoreStartIndex - 
			         pTmChat->m_ArrChatTab.m_nRenderStartIndex-1;
		int  i=0, j=0;
		char strSecuryBuffer[SIZE_MAX_CHAT_MESSAGE]; // ȣȭ ڵ
		
//		strncpy(strSecuryBuffer, ATUM_SECURITY_60_BYTE, SIZE_MAX_CHAT_MESSAGE);	

		char bufTime[128], bufDate[128];
		_strtime( bufTime );
		_strdate( bufDate );
		wsprintf(strSecuryBuffer, "%s %s %s", STRMSG_WINDOW_TEXT, bufDate, bufTime );

		char *szXORString = XOR_ENCODE_SCREENSHOT_60BYTE;
		for(j = 0; j < SIZE_MAX_CHAT_MESSAGE; j++)
		{
			strSecuryBuffer[j] = strSecuryBuffer[j] ^ szXORString[j];					
		}
		WriteFile(fhandle, strSecuryBuffer, SIZE_MAX_CHAT_MESSAGE, &dwWritten, NULL);

		while(pTmChat->m_ArrChatTab.m_ArrChatLine[index].pszChatString != NULL)
		{
//			if(index<0) index = CHAT_BUFFER_NUMBER + index;	
			if(index<0)	break;	
			
			if(CHAT_MENUBOX_START_Y - pTmChat->m_nChatBoxHeight + 2 > CHAT_FONT_START_Y-CHAT_FONT_LINE_HEIGHT*i)
				break;

//			strncpy(strSecuryBuffer, pTmChat->m_ArrChatTab.m_ArrChatLine[index].szChatString, 
//				SIZE_MAX_CHAT_MESSAGE);
			// 2006-04-26 by isparkm, 
			int nMax = strlen(pTmChat->m_ArrChatTab.m_ArrChatLine[index].pszChatString);
			if(SIZE_MAX_CHAT_MESSAGE < strlen(pTmChat->m_ArrChatTab.m_ArrChatLine[index].pszChatString))
			{
				nMax = SIZE_MAX_CHAT_MESSAGE;
			}
//			strncpy(strSecuryBuffer, pTmChat->m_ArrChatTab.m_ArrChatLine[index].pszChatString, 
//				strlen(pTmChat->m_ArrChatTab.m_ArrChatLine[index].pszChatString));
			memset(strSecuryBuffer, 0x00, SIZE_MAX_CHAT_MESSAGE);
			strncpy(strSecuryBuffer, pTmChat->m_ArrChatTab.m_ArrChatLine[index].pszChatString, 
				nMax);
			
			szXORString = XOR_ENCODE_SCREENSHOT_60BYTE;
			for(j = 0; j < SIZE_MAX_CHAT_MESSAGE; j++)
			{
				strSecuryBuffer[j] = strSecuryBuffer[j] ^ szXORString[j];					
			}
			WriteFile(fhandle, strSecuryBuffer, SIZE_MAX_CHAT_MESSAGE, &dwWritten, NULL);

			i++;
			index = pTmChat->m_ArrChatTab.m_nRenderStartIndex
				- pTmChat->m_ArrChatTab.m_nStoreEndIndex-i-1;
		}

		CloseHandle(fhandle);
		fhandle = NULL;
	}
/*
	char buf[256];
	char buf2[256];
	memset(buf,0x00,256);
	memset(buf2,0x00,256);
	strncpy(buf,file_name,8);
	wsprintf(buf2,"%s.jpg",buf);
	BMP_To_JPG(file_name, buf2);
	DeleteFile(file_name);
*/
}


HRESULT CAtumApplication::DrawBMPText(ATUM_DATE_TIME time, HANDLE *pfFilehandle)
{	
	SetFilePointer((*pfFilehandle), 0, 0, FILE_BEGIN);		
	DWORD dwRead;
	DWORD FileSize=GetFileSize((*pfFilehandle),NULL);

	//   ε
	BITMAPFILEHEADER *fh =(BITMAPFILEHEADER *)malloc(FileSize);	
	BITMAPINFOHEADER *ih;
	LPBITMAPINFOHEADER lpbi = NULL;
	{
		
		FileSize=GetFileSize((*pfFilehandle),NULL);					
		ReadFile((*pfFilehandle), fh, FileSize,&dwRead,NULL);
		ih=(BITMAPINFOHEADER *)((PBYTE)fh+sizeof(BITMAPFILEHEADER));
		lpbi = ih;
		
	}

	BITMAPINFO bmi;
	ZeroMemory( &bmi.bmiHeader,  sizeof(BITMAPINFOHEADER) );
	bmi.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth       = lpbi->biWidth;
	bmi.bmiHeader.biHeight      = lpbi->biHeight;
	bmi.bmiHeader.biPlanes      = lpbi->biPlanes;
	bmi.bmiHeader.biCompression = lpbi->biCompression;
	bmi.bmiHeader.biBitCount    = lpbi->biBitCount;


	// Prepare to create a bitmap
	HDC hdc = CreateCompatibleDC(NULL);
	DWORD*      pBitmapBits;
	
	// Create a DC and a bitmap for the font
	HBITMAP hbmBitmap = CreateDIBSection( hdc, &bmi, DIB_RGB_COLORS,
		(VOID**)&pBitmapBits, NULL, 0 );
	if(!hbmBitmap || !pBitmapBits)
	{	
		free(fh);
		return E_FAIL;
	}
	SetMapMode( hdc, MM_TEXT);	
	
	// Create a font.  By specifying ANTIALIASED_QUALITY, we might get an
	// antialiased font, but this is not guaranteed.
	INT nHeight    = 15;
	DWORD dwBold   = FW_BOLD;
	DWORD dwItalic = FALSE;

	// ۾  .
	char strText[256];
	memset(strText, 0x00, 256);
	
	wsprintf(strText, "%04d/%02d/%02d %02d:%02d", 
						time.Year, 
						time.Month,
						time.Day,
						time.Hour,
						time.Minute);


	DWORD dwCharset = DEFAULT_CHARSET;
#ifdef LANGUAGE_VIETNAM
	dwCharset = VIETNAMESE_CHARSET;
#endif
	
	HFONT hFont    = CreateFont( nHeight, 0, 0, 0, dwBold, dwItalic,
		FALSE, FALSE, dwCharset, OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
		FIXED_PITCH , GetFontStyle() );
	if( NULL==hFont )
	{
		free(fh);
		return E_FAIL;
	}
	
	HGDIOBJ hOldBitmap = SelectObject( hdc, hbmBitmap );
	HGDIOBJ hOldFont = SelectObject( hdc, hFont );
	
	int nPosX, nPosY;
	nPosX = nPosY = 0;		

	// ۿ ִ  DC . 
	StretchDIBits(hdc,
			0, 0,
			lpbi->biWidth, lpbi->biHeight,
			0, 0,
			lpbi->biWidth,
			lpbi->biHeight,
			//m_pOutBuff, 
			(LPBYTE)lpbi +(lpbi->biSize),
			(LPBITMAPINFO)lpbi,
			DIB_RGB_COLORS,
			SRCCOPY);

	SIZE size;
	int  iStringLength = lstrlen(strText);	
	GetTextExtentPoint32( hdc, strText, iStringLength, &size );

	SetBkColor(   hdc, 0xff000000 );	
	SetBkMode(hdc, TRANSPARENT);
	SetTextAlign( hdc, TA_TOP|TA_LEFT );
	SetTextColor( hdc, GUI_FONT_COLOR_Y);

	nPosX = (lpbi->biWidth - size.cx) - 10;
	nPosY = 10;

	ExtTextOut( hdc, 
				nPosX, 
				nPosY, 
				ETO_CLIPPED, 
				NULL, 
				strText, 
				strlen(strText), NULL );
	
	int xCharSize = size.cx / iStringLength;
	
	size.cx+=10;
	size.cy+=10;		
	

	//  
	{				
		GetDIBits(hdc, 
			hbmBitmap, 
			0, 
			(DWORD)lpbi->biHeight,
			(LPBYTE)lpbi +(lpbi->biSize), 
			(LPBITMAPINFO)lpbi, 
			(DWORD)DIB_RGB_COLORS);		
		
		SetFilePointer((*pfFilehandle), 0, 0, FILE_BEGIN);
		
		DWORD len;
		if(!WriteFile((*pfFilehandle),fh,FileSize,&len,NULL))
		{		
			free(fh);
			return E_FAIL;
		}			
	}
	free(fh);

	SelectObject( hdc, hOldBitmap );
	SelectObject( hdc, hOldFont );
	DeleteObject( hbmBitmap );
	DeleteObject( hFont );

	DeleteDC(hdc);	

	return D3D_OK;
}

void CAtumApplication::DeleteEffectList()
{
	FLOG("CAtumApplication::DeleteEffectList()");
	DBGOUT("CAtumApplication::DeleteEffectList\n");
	if(m_pEffectList)
	{
		CAtumNode * pEff = m_pEffectList->m_pChild;
		while(pEff)
		{
			pEff->m_bUsing = FALSE;
			pEff = pEff->m_pNext;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::OnRecvFieldSocketMessage( DWORD wParam )
/// \brief		OnRecv FieldSocket Message
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
// 2007-11-22 by bhsohn Ʒ ռ
//int CAtumApplication::OnRecvFieldSocketMessage( DWORD wParam )
int CAtumApplication::OnRecvFieldSocketMessage( DWORD wParam, UINT nSocketNotifyType)
{
	FLOG("CAtumApplication::OnRecvFieldSocketMessage( DWORD wParam )");
	
	// 2007-11-22 by bhsohn Ʒ ռ
	CFieldWinSocket* pFieldSocket = GetFieldWinSocket(nSocketNotifyType);
	if(NULL == pFieldSocket)
	{
		// Ͽ
		return 0;
	}

	switch(LOWORD(wParam))
	{
	case CFieldWinSocket::WS_ERROR:
		{
			DBGOUT("ERROR : CAtumApplication::MsgProc(), CFieldWinSocket::WS_ERROR wParam(%x)\n",HIWORD(wParam));
		}
		break;
	case CFieldWinSocket::WS_CONNECTED:
		{
			// 2007-11-22 by bhsohn Ʒ ռ
			//OnRecvFieldSocketWS_CONNECTED( HIWORD(wParam) );
			if(WM_PACKET_ARENA_NOTIFY == nSocketNotifyType)
			{
				EnterLock(TRUE);	// FALSE :Lock  TRUE : UnLock
			}
			OnRecvFieldSocketWS_CONNECTED( HIWORD(wParam), pFieldSocket);
		}
		break;
	case CFieldWinSocket::WS_CLOSED:
		{
			// 2007-11-22 by bhsohn Ʒ ռ
			//OnRecvFieldSocketWS_CLOSED();
			if(WM_PACKET_ARENA_NOTIFY == nSocketNotifyType)
			{
				// Ʒ ߿   Ʒ  Ǵ
				if(FALSE == m_pFieldWinSocket->IsRequestArenaSocketClose() 
					&& (ARENA_STATE_ARENA_GAMING == GetArenaState()))
				{
					// Ʒ   Ǿ.
					ArenaFinishWarp(FALSE);
				}
				else if(FALSE == m_pFieldWinSocket->IsRequestArenaSocketClose() 
					&& (ARENA_STATE_ARENA_GAMING != GetArenaState())
					&& (TRUE == g_pInterface->IsArenaGameState(ARENA_GAME_STATE_TEAMINFO))
					&& g_pInterface && g_pInterface->m_pGameArena)
				{
					// Ʒ  Ʒ   Ʒ ⸦ ҽŲ.
					g_pInterface->m_pGameArena->ReaveArena();
				}
			}
			else
			{
				OnRecvFieldSocketWS_CLOSED();
			}
			
		}
		break;
	case CFieldWinSocket::WS_RECEIVED:
		{
            // 2010. 10. 05 by jskim ʷε  
			// 2009. 09. 10 by ckPark ʷε Ŷ ť ׾Ƶε 
			// 2010. 10. 05 by jskim ʷε    
			//if( m_pMapInitThread && m_pMapInitThread->m_bRunning )
            // end 2010. 10. 05 by jskim ʷε  
			//{
			//	pFieldSocket->m_bSendNotify = FALSE;
			//	return 0;
			//}
			// end 2009. 09. 10 by ckPark ʷε Ŷ ť ׾Ƶε 
			// end 2010. 10. 05 by jskim ʷε  
			
			
			char * pPacket = NULL;
			int len,nType;
			// 2007-11-22 by bhsohn Ʒ ռ
			//m_pFieldWinSocket->Read(&pPacket, len);
			pFieldSocket->Read(&pPacket, len);
			
//			if(pPacket)
#ifdef _DEBUG
			int nCharacterMoveCount = 0;
#endif // _DEBUG_endif
			// 2007-11-22 by bhsohn Ʒ ռ
			//while(pPacket && m_pFieldWinSocket && m_pFieldWinSocket->IsConnected())// 2004-04-20 by dhkwon
			while(pPacket && pFieldSocket && pFieldSocket->IsConnected())// 2004-04-20 by dhkwon
			{
				nType = *(MessageType_t*)pPacket;
#ifdef _DEBUG
				PrintExchangeMsg(RECV_TYPE, nType, NULL, ST_FIELD_SERVER);
//				PrintExchangeMsg(RECV_TYPE, nType, NULL, ST_INVALID_TYPE, PRINTLEVEL_WO_MOVE_BATTLE);//,ST_FIELD_SERVER);
//				PrintExchangeMsg(RECV_TYPE, nType, NULL, ST_FIELD_SERVER, PRINTLEVEL_ALL);
#endif
				// 2007-12-21 by bhsohn α׷    
				//   üũ 
				CheckMultiLock(TRUE, nType);

				g_cCustomOptimizer.ViewDebugString(nType, CCustomOptimizer::E_FL_SERVER_TO_CLIENT);

				switch((nType))
				{
				case T_FC_CONNECT_LOGIN_OK:
					{
						FieldSocketConnectLoginOk((MSG_FC_CONNECT_LOGIN_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_GET_CHARACTER_OK:
					{
						FieldSocketCharacterGetCharacterOk((MSG_FC_CHARACTER_GET_CHARACTER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CREATE_OK:
					{
						FieldSocketCharacterCreateOk((MSG_FC_CHARACTER_CREATE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_DELETE_OK:
					{
						FieldSocketCharacterDeleteOk();
					}
					break;
				case T_FC_CHARACTER_REPAIR_OK:
					{
					}
					break;
				case T_FC_CHARACTER_REPAIR_ERR:
					{
					}
					break;
				case T_FC_CHARACTER_DOCKING_ERR:
					{
					}
					break;
				case T_FC_CHARACTER_GET_OTHER_INFO_OK:
					{
						FieldSocketCharacterGetOtherInfoOk((MSG_FC_CHARACTER_GET_OTHER_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_GET_MONSTER_INFO_OK:
					{
						FieldSocketCharacterGetMonsterInfoOk((MSG_FC_CHARACTER_GET_MONSTER_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_GAMESTART_OK:
					{
						FieldSocketCharacterGameStartOk((MSG_FC_CHARACTER_GAMESTART_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CONNECT_GAMESTART_OK:
					{
						FieldSocketCharacterConnectGameStartOk((MSG_FC_CHARACTER_CONNECT_GAMESTART_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_GAMEEND_OK	:
					{
						// 2008-03-10 by bhsohn Ʒ ȯ Ż ó
						//FieldSocketCharacterGameEndOk((MSG_FC_CHARACTER_GAMEEND_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
						FieldSocketCharacterGameEndOk(nSocketNotifyType, (MSG_FC_CHARACTER_GAMEEND_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MOVE_OK:
					{
						FieldSocketMoveOk((MSG_FC_MOVE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
#ifdef _DEBUG
						nCharacterMoveCount++;
#endif
					}
					break;
				case T_FC_MONSTER_MOVE_OK:
					{
						FieldSocketMonsterMoveOk((MSG_FC_MONSTER_MOVE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
/*				case T_FC_BATTLE_ATTACK_RESULT_PRIMARY:
					{
						FieldSocketBattleAttackResultPrimary((MSG_FC_BATTLE_ATTACK_RESULT_PRIMARY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_RESULT_SECONDARY:
					{
						FieldSocketBattleAttackResultSecondary((MSG_FC_BATTLE_ATTACK_RESULT_SECONDARY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_FIND_RESULT:
					{
						FieldSocketBattleAttackFindResult((MSG_FC_BATTLE_ATTACK_FIND_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
*/				case T_FC_CHARACTER_CHANGE_HPDPSPEP:
					{
						FieldSocketCharacterChangeHPDPSPEP((MSG_FC_CHARACTER_CHANGE_HPDPSPEP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP:
					{
						FieldSocketCharacterChangeCurrentHPDPSPEP((MSG_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_CURRENTHP:
					{
						FieldSocketCharacterChangeCurrentHP((MSG_FC_CHARACTER_CHANGE_CURRENTHP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_CURRENTDP:
					{
						FieldSocketCharacterChangeCurrentDP((MSG_FC_CHARACTER_CHANGE_CURRENTDP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_CURRENTSP:
					{
						FieldSocketCharacterChangeCurrentSP((MSG_FC_CHARACTER_CHANGE_CURRENTSP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_CURRENTEP:
					{
						FieldSocketCharacterChangeCurrentEP((MSG_FC_CHARACTER_CHANGE_CURRENTEP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_BODYCONDITION:
					{
						FieldSocketCharacterChangeBodycondition((MSG_FC_CHARACTER_CHANGE_BODYCONDITION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_UNITKIND:
					{
						FieldSocketCharacterChangeUnitkind((MSG_FC_CHARACTER_CHANGE_UNITKIND*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// 2012-10-12 by jhjang  ƿ ġ ʽ ý 
				case T_FC_CHARACTER_KILLCOUNT:
					{
						FieldSocketCharacterKillCount((MSG_FC_CHARACTER_KILLCOUNT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_RESTCOUNT:
					{
						FieldSocketCharacterRestCount((MSG_FC_CHARACTER_RESTCOUNT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_BONUS_EXP_RATE:
					{
						FieldSocketCharacterBonusExpRate((MSG_FC_CHARACTER_BONUS_EXP_RATE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// end 2012-10-12 by jhjang  ƿ ġ ʽ ý 
				case T_FC_PARTY_CREATE_OK:
					{
						FieldSocketPartyCreateOk((MSG_FC_PARTY_CREATE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_REQUEST_INVITE_QUESTION:
					{
						FieldSocketPartyRequestInviteQuestion((MSG_FC_PARTY_REQUEST_INVITE_QUESTION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA:		/// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ƽ  غ
					{
						FieldSocketPartyRequestInviteQuestion_THE_ARENA((MSG_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_AUTO_CREATED_THE_ARENA:		/// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : ڵ Ƽ  Ŷ.
					{
						FieldSocketPartyAutoCreated_THE_ARENA((MSG_FC_PARTY_AUTO_CREATED_THE_ARENA*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_REJECT_INVITE_OK:
					{
						FieldSocketPartyRejectInviteOk((MSG_FC_PARTY_REJECT_INVITE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_PUT_MEMBER:
					{
						FieldSocketPartyPutMember((MSG_FC_PARTY_PUT_MEMBER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_ALL:
					{
						FieldSocketPartyUpdateMemberInfoAll((MSG_FC_PARTY_UPDATE_MEMBER_INFO_ALL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_LEVEL:
					{
						FieldSocketPartyUpdateMemberInfoLevel((MSG_FC_PARTY_UPDATE_MEMBER_INFO_LEVEL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_HP:
					{
						FieldSocketPartyUpdateMemberInfoHP((MSG_FC_PARTY_UPDATE_MEMBER_INFO_HP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_HP:
					{
						FieldSocketPartyUpdateMemberInfoCurrentHP((MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_HP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_DP:
					{
						FieldSocketPartyUpdateMemberInfoDP((MSG_FC_PARTY_UPDATE_MEMBER_INFO_DP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_DP:
					{
						FieldSocketPartyUpdateMemberInfoCurrentDP((MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_DP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_SP:
					{
						FieldSocketPartyUpdateMemberInfoSP((MSG_FC_PARTY_UPDATE_MEMBER_INFO_SP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_SP:
					{
						FieldSocketPartyUpdateMemberInfoCurrentSP((MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_SP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_EP:
					{
						FieldSocketPartyUpdateMemberInfoEP((MSG_FC_PARTY_UPDATE_MEMBER_INFO_EP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_EP:
					{
						FieldSocketPartyUpdateMemberInfoCurrentEP((MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_EP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_UPDATE_MEMBER_INFO_BODYCONDITION:
					{
						FieldSocketPartyUpdateMemberInfoBodyCondition((MSG_FC_PARTY_UPDATE_MEMBER_INFO_BODYCONDITION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_CHECK_WARP_STATE_OK:
					{
						FieldSocketCityCheckWarpStateOk((MSG_FC_CITY_CHECK_WARP_STATE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_WARP:
					{
						FieldSocketEventWarpOtherFieldServer((MSG_FC_EVENT_WARP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_WARP_SAME_MAP:
					{
						FieldSocketEventWarpSameMap((MSG_FC_EVENT_WARP_SAME_MAP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_WARP_SAME_FIELD_SERVER:
					{
						FieldSocketEventWarpSameFieldServer((MSG_FC_EVENT_WARP_SAME_FIELD_SERVER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_OTHER_WARPED:
					{
						FieldSocketEventOtherWarped((MSG_FC_EVENT_OTHER_WARPED*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_WARP_CONNECT_OK:
					{
						FieldSocketEventWarpConnectOk((MSG_FC_EVENT_WARP_CONNECT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_PUT_ITEM_HEADER:
					{
						FieldSocketStorePutItemHeader((MSG_FC_STORE_PUT_ITEM_HEADER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_PUT_ITEM:
					{
						FieldSocketStorePutItem((MSG_FC_STORE_PUT_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_PUT_ITEM_DONE:
					{
						FieldSocketStorePutItemDone((MSG_FC_STORE_PUT_ITEM_DONE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_LEVEL:
					{
						FieldSocketCharacterChangeLevel((MSG_FC_CHARACTER_CHANGE_LEVEL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_EXP:
					{
						FieldSocketCharacterChangeExp((MSG_FC_CHARACTER_CHANGE_EXP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_STAT:
					{
						FieldSocketCharacterChangeStat((MSG_FC_CHARACTER_CHANGE_STAT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_TOTALGEAR_STAT:
					{
						FieldSocketCharacterChangeTotalGearStat((MSG_FC_CHARACTER_CHANGE_TOTALGEAR_STAT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_STATUS:
					{
						FieldSocketCharacterChangeStatus((MSG_FC_CHARACTER_CHANGE_STATUS*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_PROPENSITY:
					{
						FieldSocketCharacterChangePropensity((MSG_FC_CHARACTER_CHANGE_PROPENSITY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_CHANGE_WINDOW_POSITION_OK:
					{
						FieldSocketItemChangeWindowPositionOk((MSG_FC_ITEM_CHANGE_WINDOW_POSITION_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MOVE_LANDING_OK:
					{
						FieldSocketMoveLandingOk((MSG_FC_MOVE_LANDING_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MOVE_TAKEOFF_OK:
					{
						FieldSocketMoveTakeOffOk((MSG_FC_MOVE_TAKEOFF_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MOVE_ROLLING_OK:
					{
						FieldSocketMoveRolling((MSG_FC_MOVE_ROLLING_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_SHOW_ITEM:
					{
						FieldSocketItemShowItem((MSG_FC_ITEM_SHOW_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_GET_ITEM_OK:
					{
						FieldSocketItemGetItemOk((MSG_FC_ITEM_GET_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_HIDE_ITEM:
					{
						FieldSocketItemHideItem((MSG_FC_ITEM_HIDE_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_PUT_ITEM_OTHER:
					{
						FieldSocketPartyPutItemOther((MSG_FC_PARTY_PUT_ITEM_OTHER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_GET_ITEM_FAIL:
					{
						FieldSocketItemGetItemFail((MSG_FC_ITEM_GET_ITEM_FAIL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITYWAR_GET_OCCUPYINFO_OK:
					{
						FieldSocketCitywarGetOccupyinfoOk((MSG_FC_CITYWAR_GET_OCCUPYINFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITYWAR_BRING_SUMOFTEX_OK:
					{
						FieldSocketCitywarBringSumoftexOk((MSG_FC_CITYWAR_BRING_SUMOFTEX_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITYWAR_START_WAR:
					{
						FieldSocketCitywarStartWar((MSG_FC_CITYWAR_START_WAR*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITYWAR_END_WAR:
					{
						FieldSocketCitywarEndWar((MSG_FC_CITYWAR_END_WAR*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK:
					{
						FieldSocketCharacterGetCashMoneyCountOk((MSG_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_CHARACTER_MODE_OK:
					{
						FieldSocketCharacterChangeCharacterModeOk((MSG_FC_CHARACTER_CHANGE_CHARACTER_MODE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
/*				case T_FC_BATTLE_MINE_ATTACK_RESULT:
					{
						FieldSocketBattleMineAttackResult((MSG_FC_BATTLE_MINE_ATTACK_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_MINE_ATTACK_FIND_RESULT:
					{
						FieldSocketBattleMineAttackFindResult((MSG_FC_BATTLE_MINE_ATTACK_FIND_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_MINE_ATTACK_ITEM_FIND_RESULT:
					{
						FieldSocketBattleMineAttackItemFindResult((MSG_FC_BATTLE_MINE_ATTACK_ITEM_FIND_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
*/				case T_FC_MISSILE_MOVE_OK:
					{
						FieldSocketMissileMoveOk((MSG_FC_MISSILE_MOVE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_REQUEST_ENTER_BUILDING_OK:
					{	//  
						FieldSocketCityRequestEnterBuildingOk((MSG_FC_CITY_REQUEST_ENTER_BUILDING_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_ENTER_BUILDING:
					{	//  
						FieldSocketEventEnterBuilding((MSG_FC_EVENT_ENTER_BUILDING*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_LEAVE_BUILDING_OK:
					{	//  
						FieldSocketEventLeaveBuildingOk((MSG_FC_EVENT_LEAVE_BUILDING_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_PUT_ITEM_HEADER:
					{	//
						FieldSocketShopPutItemHeader((MSG_FC_SHOP_PUT_ITEM_HEADER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_PUT_ITEM:
					{	//
						FieldSocketShopPutItem((MSG_FC_SHOP_PUT_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_PUT_ITEM_DONE:
					{	//
						FieldSocketShopPutItemDone((MSG_FC_SHOP_PUT_ITEM_DONE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_GET_ITEMINFO_OK:
					{	//
						FieldSocketShopGetItemInfoOk((MSG_FC_SHOP_GET_ITEMINFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_BUY_ITEM_OK:
					{	//
						FieldSocketShopBuyItemOk((MSG_FC_SHOP_BUY_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_SELL_ITEM_OK:
					{	//
						FieldSocketShopSellItemOk((MSG_FC_SHOP_SELL_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_GET_USED_ITEM_PRICE_OK:
					{	//
						FieldSocketShopGetUsedItemPriceOk((MSG_FC_SHOP_GET_USED_ITEM_PRICE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));

					}
					break;
				case T_FC_ITEM_THROW_AWAY_ITEM_OK:
					{	//
						FieldSocketItemThrowAwayItemOk((MSG_FC_ITEM_THROW_AWAY_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_ENERGY_OK:
					{
						FieldSocketItemUseEnergyOk((MSG_FC_ITEM_USE_ENERGY_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_ITEM_OK:
					{
						FieldSocketItemUseItemOk((MSG_FC_ITEM_USE_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_CARDITEM_GUILD_NOTIFY:
					{
						FieldSocketItemUseCarditemGuildNotify((MSG_FC_ITEM_USE_CARDITEM_GUILD_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_DELETE_ALL_ENCHANT:
					{
						FieldSocketItemUseCarditemDeleteAllEnchant((MSG_FC_ITEM_DELETE_ALL_ENCHANT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_CARDITEM_MONSTERSUMMON_NOTIFY:
					{
						FieldSocketItemUseCardItemMonstersummonNotify((MSG_FC_ITEM_USE_CARDITEM_MONSTERSUMMON_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME_NOTIFY:
					{
						FieldSocketItemUseCardItemChangecharacternameNotify((MSG_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE_NOTIFY:
					{
						FieldSocketItemUseCardItemSkillinitializeNotify((MSG_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE_NOTIFY:
					{
						FieldSocketItemUseCardItemChangepilotfaceNotify((MSG_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHAT_REGION:
					{
						FieldSocketChatRegion((MSG_FC_CHAT_REGION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHAT_CASH_ALL:
					{
						FieldSocketChatCashAll((MSG_FC_CHAT_CASH_ALL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHAT_MAP:
					{
						FieldSocketChatMap((MSG_FC_CHAT_MAP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHAT_ARENA:
					{
						FieldSocketChatArena((MSG_FC_CHAT_ARENA*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;

				// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
				case T_FC_CHAT_INFINITY:
					{
						FieldSocketChatInfinity( (MSG_FC_CHAT_INFINITY*)(pPacket+SIZE_FIELD_TYPE_HEADER) );
					}
					break;
				// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý

				case T_FC_TRADE_REQUEST_TRADE_OK:
					{
						FieldSocketTradeRequestTradeOk((MSG_FC_TRADE_REQUEST_TRADE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_ACCEPT_TRADE_OK:
					{
						FieldSocketTradeAcceptTradeOk((MSG_FC_TRADE_ACCEPT_TRADE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_REJECT_TRADE_OK:
					{
						FieldSocketTradeRejectTradeOk((MSG_FC_TRADE_REJECT_TRADE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_REJECT_TRADING:
					{
						FieldSocketTradeRejectTrading((MSG_FC_TRADE_REJECT_TRADING*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_SHOW_TRADE_WINDOW:
					{
						FieldSocketTradeShowTradeWindow((MSG_FC_TRADE_SHOW_TRADE_WINDOW*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_OK_TRADE_OK:
					{
						FieldSocketTradeOkTradeOk((MSG_FC_TRADE_OK_TRADE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_CANCEL_TRADE_OK:
					{
						FieldSocketTradeCancelTradeOk((MSG_FC_TRADE_CANCEL_TRADE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_DELETE_ITEM:
				case T_FC_TRADE_DELETE_ITEM:
					{
						FieldSocketTradeDeleteItem((MSG_FC_TRADE_DELETE_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_UPDATE_ITEM_COUNT:
				case T_FC_TRADE_UPDATE_ITEM_COUNT:
					{
						FieldSocketTradeUpdateItemCount((MSG_FC_TRADE_UPDATE_ITEM_COUNT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_INSERT_ITEM:
				case T_FC_TRADE_INSERT_ITEM:
					{
						FieldSocketTradeInsertItem((MSG_FC_TRADE_INSERT_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_UPDATE_ENDURANCE:
					{
						FieldSocketStoreUpdateEndurance((MSG_FC_STORE_UPDATE_ENDURANCE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_UPDATE_POSSESS:
					{
						FieldSocketStoreUpdatePossess((MSG_FC_STORE_UPDATE_POSSESS*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_UPDATE_RARE_FIX:
					{
						FieldSocketStoreUpdateRareFix((MSG_FC_STORE_UPDATE_RARE_FIX*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_TRANS_ITEM_OK://  ǰ Ʈ ִ´.
					{
						FieldSocketTradeTransItemOk((MSG_FC_TRADE_TRANS_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_SEE_ITEM_OK:
					{
						FieldSocketTradeSeeItemOk((MSG_FC_TRADE_SEE_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// 2010-06-15 by shcho&hslee ý - ŷ    recv
				case T_FC_TRADE_SEE_PET_DATA:
					{
						FieldSocketTradeSeePetData((MSG_TRADE_PET_DATA*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_DELETE_CURRENT_PET_DATA:
					{
						FieldSocketTradeDeletePetData((MSG_TRADE_PET_DATA*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TRADE_INSERT_CURRENT_PET_DATA:
					{
						FieldSocketTradeInsertPetData((MSG_FC_ITEM_PET_BASEDATA*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// 2010-06-15 by shcho&hslee ý - ŷ    recv
//2011-10-06 by jhahn Ʈ  ý
// 2012-07-12 by jhahn, Ʈ  ũ ߰
				case T_FC_ITEM_PET_SWAP_SAVE_OK:
					{
						FieldSocketInvenItempSwapPetEquip((MSG_FC_ITEM_PET_SWAP_SAVE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;

				case T_FC_ITEM_PET_SWAP_CHANGE_OK:
					{
						FieldSocketInvenItempSwapPetEquipOk((MSG_FC_ITEM_PET_SWAP_CHANGE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;					   
//end 2012-07-12 by jhahn, Ʈ  ũ ߰
				case T_FC_ITEM_NOTIFY_WINDOW_POSITION:
					{
						FieldSocketInvenItempHidePetData((MSG_FC_ITEM_NOTIFY_WINDOW_POSITION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;

				case T_FC_ITEM_USE_PET_SOCKET_ITEM_OK:
					{
						_asm nop
					}
					break;

				case T_FC_ITEM_CANCEL_PET_SOCKET_ITEM_OK:
					{
						_asm nop
					}
					break;
//end 2011-10-06 by jhahn Ʈ  ý
				case T_FC_SKILL_USE_SKILL_OK:
					{
						FieldSocketSkillUseSkill((MSG_FC_SKILL_USE_SKILL_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SKILL_INVALIDATE_SKILL:
					{
						FieldSocketInvalidateSkill((MSG_FC_SKILL_INVALIDATE_SKILL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER_OK:
					{
						FieldSocketCharacterGetAccountUniqueNumberOk((MSG_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_REQUEST_PK_OK:
					{
						FieldSocketBattleRequestPkOk((MSG_FC_BATTLE_REQUEST_PK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_CANCEL_PK:
					{
						FieldSocketBattleCancelPK();
					}
					break;
				case T_FC_MONSTER_CHANGE_HP:
					{
						FieldSocketCharacterChangeMonsterHP((MSG_FC_MONSTER_CHANGE_HP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;

/*				case T_FC_BATTLE_DROP_BUNDLE_OK:
					{
						FieldSocketBattleDropBundleOk((MSG_FC_BATTLE_DROP_BUNDLE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_BUNDLE_ATTACK_RESULT:
					{
						FieldSocketBattleBundleAttackResult((MSG_FC_BATTLE_BUNDLE_ATTACK_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
*/				case T_FC_CHARACTER_DELETE_OTHER_INFO:
					{
						FieldSocketCharacterDeleteOtherInfo((MSG_FC_CHARACTER_DELETE_OTHER_INFO*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MONSTER_CREATED:
					{
						FieldSocketCharacterMonsterCreated((MSG_FC_MONSTER_CREATED*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_REQUEST_P2P_PK_OK:
					{
						FieldSocketBattleRequestP2PPkOk((MSG_FC_BATTLE_REQUEST_P2P_PK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK:
					{
						FieldSocketBattleAcceptRequestP2PPkOk((MSG_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_REJECT_REQUEST_P2P_PK_OK:
					{
						FieldSocketBattleRejectRequestP2PPkOk((MSG_FC_BATTLE_REJECT_REQUEST_P2P_PK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_SURRENDER_P2P_PK_OK:
					{
						FieldSocketBattleSurrenderP2PPkOk((MSG_FC_BATTLE_SURRENDER_P2P_PK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_CHARACTER_MENT:
					{
						FieldSocketCharacterChangeCharacterMent((MSG_FC_CHARACTER_CHANGE_CHARACTER_MENT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
/*					case T_FC_BATTLE_ACCEPT_SURRENDER_P2P_PK_OK:
					{
						MSG_FC_BATTLE_ACCEPT_SURRENDER_P2P_PK_OK *pMsg;
						pMsg = (MSG_FC_BATTLE_ACCEPT_SURRENDER_P2P_PK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER);
						m_pChat->CreateChatChild(" йϿϴ.",COLOR_TRADE);
						m_pShuttleChild->m_bPKMode = FALSE;
					}
					break;
*/					case T_FC_BATTLE_REJECT_SURRENDER_P2P_PK_OK:
					{
						FieldSocketBattleRejectSurrenderP2PPkOk((MSG_FC_BATTLE_REJECT_SURRENDER_P2P_PK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_END_P2P_PK:
					{
						FieldSocketBattleEndP2PPk((MSG_FC_BATTLE_END_P2P_PK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_PKPOINT:
					{
						FieldSocketCharacterChangePKPoint((MSG_FC_CHARACTER_CHANGE_PKPOINT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_DROP_DUMMY_OK:
					{
						FieldSocketBattleDropDummyOk((MSG_FC_BATTLE_DROP_DUMMY_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
/*				case T_FC_BATTLE_ATTACK_ITEM_RESULT_PRIMARY:
					{
						FieldSocketBattleAttackItemResultPrimary((MSG_FC_BATTLE_ATTACK_ITEM_RESULT_PRIMARY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_ITEM_RESULT_SECONDARY:
					{
						FieldSocketBattleAttackItemResultSecondary((MSG_FC_BATTLE_ATTACK_ITEM_RESULT_SECONDARY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_ITEM_FIND_RESULT:
					{
						FieldSocketBattleAttackItemFindResult((MSG_FC_BATTLE_ATTACK_ITEM_FIND_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
*/				case T_FC_BATTLE_ATTACK_HIDE_ITEM:
					{
						FieldSocketBattleAttackHideItem((MSG_FC_BATTLE_ATTACK_HIDE_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_EXPLODE_ITEM:
					{
						FieldSocketBattleAttackExplodeItem((MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
/*				case T_FC_BATTLE_BUNDLE_ATTACK_ITEM_RESULT:
					{
						FieldSocketBattleBundleAttackItemResult((MSG_FC_BATTLE_BUNDLE_ATTACK_ITEM_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_MINE_ATTACK_ITEM_RESULT:
					{
						FieldSocketBattleMineAttackItemResult((MSG_FC_BATTLE_MINE_ATTACK_ITEM_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
*/				case T_FC_MONSTER_HIDE:
					{
						FieldSocketMonsterHide((MSG_FC_MONSTER_HIDE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MONSTER_SHOW:
					{
						FieldSocketMonsterShow((MSG_FC_MONSTER_SHOW*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MONSTER_CHANGE_BODYCONDITION:
					{
						FieldSocketMonsterChangeBodycondition((MSG_FC_MONSTER_CHANGE_BODYCONDITION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_DROP_FIXER_OK:
					{
						FieldSocketBattleDropFixerOk((MSG_FC_BATTLE_DROP_FIXER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_GET_ITEM_INFO_OK:
					{
						FieldSocketInfoGetItemInfoOk(((MSG_FC_INFO_GET_ITEM_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER))->ItemInfo);
					}
					break;
				case T_FC_INFO_GET_SIMPLE_ITEM_INFO_OK:
					{
						FieldSocketInfoGetSimpleItemInfoOk(((MSG_FC_INFO_GET_SIMPLE_ITEM_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER))->ItemInfo);
					}
					break;
				case T_FC_INFO_GET_ENCHANT_COST_OK:
					{
						FieldSocketInfoGetEnchantCostOk(((MSG_FC_INFO_GET_ENCHANT_COST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER)));
					}
					break;
				case T_FC_INFO_GET_RARE_ITEM_INFO_OK:
					{
						FieldSocketInfoGetRareItemInfoOk(((MSG_FC_INFO_GET_RARE_ITEM_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER))->RareItemInfo);
					}
					break;
				case T_FC_INFO_GET_MONSTER_INFO_OK:
					{
						FieldSocketInfoGetMonsterInfoOk((MSG_FC_INFO_GET_MONSTER_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_GET_MAPOBJECT_INFO_OK:
					{
						FieldSocketInfoGetMapObjectInfoOk(((MSG_FC_INFO_GET_MAPOBJECT_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER))->MapObjectInfo);
					}
					break;
				case T_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND:
					{
						FieldSocketBattleAttackHideItemWKind((MSG_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_EXPLODE_ITEM_W_KIND:
					{
						FieldSocketBattleAttackExplodeItemWKind((MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM_W_KIND*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CONNECT_SYNC_TIME:
					{
						FieldSocketConnectSyncTime((MSG_FC_CONNECT_SYNC_TIME*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_RELOAD_ITEM_INFO:
					{
						FieldSocketItemReloadItemInfo();
					}
					break;
				case T_FC_ITEM_USE_ENCHANT_OK:
					{
						FieldSocketItemUseEnchantOk((MSG_FC_ITEM_USE_ENCHANT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_PUT_ENCHANT:
					{
						FieldSocketItemPutEnchant((MSG_FC_ITEM_PUT_ENCHANT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_REQUEST_START_RESULT:
					{
						FieldSocketQuestRequestStartResult((MSG_FC_QUEST_REQUEST_START_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_REQUEST_SUCCESS_RESULT:
					{
						FieldSocketQuestRequestSuccessResult((MSG_FC_QUEST_REQUEST_SUCCESS_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_REQUEST_SUCCESS_CHECK_RESULT:
					{
						FieldSocketQuestRequestSuccessCheckResult((MSG_FC_QUEST_REQUEST_SUCCESS_CHECK_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_PUT_ALL_QUEST:
					{
						FieldSocketQuestPutAllQuest((MSG_FC_QUEST_PUT_ALL_QUEST*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SKILL_SETUP_SKILL_OK:
					{
						FieldSocketSkillSetupSkillOk((MSG_FC_SKILL_SETUP_SKILL_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_REQUEST_REQUEST_OK:
					{
						FieldSocketRequestRequestOk((MSG_FC_REQUEST_REQUEST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_REQUEST_REJECT_REQUEST_OK:
					{
						FieldSocketRequestRejectRequestOk((MSG_FC_REQUEST_REJECT_REQUEST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_REQUEST_CANCEL_REQUEST:
					{
						FieldSocketRequestCancelRequest((MSG_FC_REQUEST_CANCEL_REQUEST*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_REQUEST_ACCEPT_REQUEST_OK:
					{
						FieldSocketRequestAcceptRequestOk((MSG_FC_REQUEST_ACCEPT_REQUEST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_BATTLE_START:	
					{
						FieldSocketPartyBattleStart((MSG_FC_PARTY_BATTLE_START*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_PARTY_BATTLE_END:	
					{
						FieldSocketPartyBattleEnd((MSG_FC_PARTY_BATTLE_END*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT:
					{
						FieldSocketQuestPutAllQuestMonsterCount((MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_UPDATE_MONSTER_COUNT:
					{
						FieldSocketQuestUpdateMonsterCount((MSG_FC_QUEST_UPDATE_MONSTER_COUNT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// 2004-11-24 by jschoi "T_FC_ITEM_RESET_SKILL_ENCHANT_TO_LOADED_ITEM" .
//				case T_FC_ITEM_RESET_SKILL_ENCHANT_TO_LOADED_ITEM:
//					{
//						FieldSocketItemResetSkillEnchantToLoadedItem();
//					}
//					break;
/*				case T_FC_BATTLE_CHANGE_TARGET_OK:
					{//  
						FieldSocketBattleChangeTargetOk((MSG_FC_BATTLE_CHANGE_TARGET_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
*/				case T_FC_BATTLE_TOGGLE_SHIELD_RESULT:
					{//  
						FieldSocketBattleToggleShieldResult((MSG_FC_BATTLE_TOGGLE_SHIELD_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_TOGGLE_DECOY_OK:
					{//  
						FieldSocketBattleToggleDecoyOk((MSG_FC_BATTLE_TOGGLE_DECOY_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_PRI_BULLET_RELOADED:	
					{
						FieldSocketBattlePriBulletReloaded((MSG_FC_BATTLE_PRI_BULLET_RELOADED*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_SEC_BULLET_RELOADED:	
					{
						FieldSocketBattleSecBulletReloaded((MSG_FC_BATTLE_SEC_BULLET_RELOADED*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
//				case T_FC_BATTLE_SHIELD_DAMAGE:	
//					{
//						FieldSocketBattleShieldDamage((MSG_FC_BATTLE_SHIELD_DAMAGE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
//					}
//					break;
				case T_FC_EVENT_CHANGE_WEATHER:
					{// 
						FieldSocketEventChangeWeather((MSG_FC_EVENT_CHANGE_WEATHER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_UPDATE_ITEM_POS:
					{// Ÿĳ  ü
						FieldSocketItemUpdateItemPos((MSG_FC_ITEM_UPDATE_ITEM_POS*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK:
					{// Ÿĳ  ü
						FieldSocketCharacterGetOtherRenderInfoOk((MSG_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_GET_BUILDINGNPC_INFO_OK:	
					{
						FieldSocketInfoGetBuildingNPCInfoOk((MSG_FC_INFO_GET_BUILDINGNPC_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_SUGGEST_CHANNELS:
					{
						FieldSocketEventSuggestChannels((MSG_FC_EVENT_SUGGEST_CHANNELS*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_GET_BUILDING_LIST_OK:	
					{
						FieldSocketCityGetBuildingListOk((MSG_FC_CITY_GET_BUILDING_LIST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST_OK:	
					{
						FieldSocketGetShopWarpTargetMapListOk((MSG_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ADMIN_GET_SERVER_STAT_OK:	
					{
						FieldSocketAdminGetServerStatOk((MSG_FC_ADMIN_GET_SERVER_STAT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_SHOW_EFFECT_OK:
					{
						FieldSocketCharacterShowEffectOk((MSG_FC_CHARACTER_SHOW_EFFECT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2007-04-19 by bhsohn ġ  ߰
				case T_FC_CHARACTER_SHOW_MAP_EFFECT_OK:
					{
						FieldSocketCharacterMapEffectOk((MSG_FC_CHARACTER_SHOW_MAP_EFFECT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2007-04-19 by bhsohn ġ  ߰
				case T_FC_CONNECT_CLOSE:
					{//  
						FieldSocketConnectClose((MSG_FC_CONNECT_CLOSE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STRING_128:
					{
						FieldSocketString128((MSG_FC_STRING_128*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STRING_256:
					{
						FieldSocketString256((MSG_FC_STRING_256*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STRING_512:
					{
						FieldSocketString512((MSG_FC_STRING_512*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MONSTER_SKILL_USE_SKILL:
					{
						FieldSocketMonsterSkillUseSkill((MSG_FC_MONSTER_SKILL_USE_SKILL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MONSTER_SKILL_END_SKILL:
					{
						FieldSocketMonsterSkillEndSkill((MSG_FC_MONSTER_SKILL_END_SKILL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_MIX_ITEMS_RESULT:
					{
						FieldSocketItemMixItemsResult((MSG_FC_ITEM_MIX_ITEMS_RESULT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_GUILD_GET_WAR_INFO_OK:
					{
						FieldSocketGuildGetWarInfoOk((MSG_FC_GUILD_GET_WAR_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_MOVE_ITEM_OK:
					{
						FieldSocketStoreMoveItemOk((MSG_FC_STORE_MOVE_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_GET_OTHER_PARAMFACTOR_OK:
					{
						FieldSocketCharacterGetOtherParamfactorOk((MSG_FC_CHARACTER_GET_OTHER_PARAMFACTOR_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_DISCARD_QUEST_OK:
					{
						FieldSocketQuestDiscardQuestOk((MSG_FC_QUEST_DISCARD_QUEST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_OK:
					{
						FieldSocketBattleAttackOk((MSG_FC_BATTLE_ATTACK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_FIND_OK:
					{
						FieldSocketBattleAttackFindOk((MSG_FC_BATTLE_ATTACK_FIND_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_DROP_MINE_OK:
					{
						FieldSocketBattleDropMineOk((MSG_FC_BATTLE_DROP_MINE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_MINE_ATTACK_OK:
					{
						FieldSocketBattleMineAttackOk((MSG_FC_BATTLE_MINE_ATTACK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_MINE_ATTACK_FIND_OK:
					{
						FieldSocketBattleMineAttackFindOk((MSG_FC_BATTLE_MINE_ATTACK_FIND_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TIMER_START_TIMER:
					{
						FieldSocketTimerStartTimer((MSG_FC_TIMER_START_TIMER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TIMER_STOP_TIMER:
					{
						FieldSocketTimerStopTimer((MSG_FC_TIMER_STOP_TIMER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TIMER_UPDATE_TIMER:
					{
						FieldSocketTimerUpdateTimer((MSG_FC_TIMER_UPDATE_TIMER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TIMER_PAUSE_TIMER:
					{
						FieldSocketTimerPauseTimer((MSG_FC_TIMER_PAUSE_TIMER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TIMER_CONTINUE_TIMER:
					{
						FieldSocketTimerContinueTimer((MSG_FC_TIMER_CONTINUE_TIMER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SKILL_PREPARE_USE_OK:
					{
						FieldSocketSKillPrepareUseOk((MSG_FC_SKILL_PREPARE_USE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SKILL_CANCEL_PREPARE_OK:
					{
						FieldSocketCancelPrepareOk((MSG_FC_SKILL_CANCEL_PREPARE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MOVE_WEAPON_VEL_OK:
					{
						FieldSocketMoveWeaponVelOk((MSG_FC_MOVE_WEAPON_VEL_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_COUNTDOWN_START:
					{
						FieldSocketCountdownStart((MSG_FC_COUNTDOWN_START*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_SHOW_DAMAGE:
					{
						FieldSocketBattleShowDamage((MSG_FC_BATTLE_SHOW_DAMAGE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OBJECT_CHANGE_BODYCONDITION_OK:
					{
						FieldSocketObjectChangeBodyConditionOk((MSG_FC_OBJECT_CHANGE_BODYCONDITION_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_AUCTION_INSERT_ITEM:
					{
						FieldSocketAuctionInsertItem((MSG_FC_AUCTION_INSERT_ITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_AUCTION_REGISTER_ITEM_OK:
					{
						FieldSocketAuctionRegisterItemOk((MSG_FC_AUCTION_REGISTER_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_AUCTION_CANCEL_REGISTER_OK:
					{
						FieldSocketAuctionCancerRegisterOk((MSG_FC_AUCTION_CANCEL_REGISTER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_AUCTION_BUY_ITEM_OK:
					{
						FieldSocketAuctionBuyItemOk((MSG_FC_AUCTION_BUY_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_AUCTION_PUT_ENCHANT:
					{
						FieldSocketAuctionPutEnchant((MSG_FC_AUCTION_PUT_ENCHANT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MOVE_LOCKON_OK:
					{
						FieldSocketMoveLockonOk((MSG_FC_MOVE_LOCKON_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MOVE_UNLOCKON_OK:
					{
						FieldSocketMoveUnlockonOk((MSG_FC_MOVE_UNLOCKON_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_GET_CURRENT_MAP_INFO_OK:
					{
						FieldSocketInfoGetCurrentMapInfoOk((MSG_FC_INFO_GET_CURRENT_MAP_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CASH_PREMIUM_CARD_INFO:
					{
						FieldSocketCharacterCashPremiumCardInfo((MSG_FC_CHARACTER_CASH_PREMIUM_CARD_INFO*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_INSERT_USINGITEM:
					{
						FieldSocketStoreInsertUsingItem((MSG_FC_STORE_INSERT_USINGITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_DELETE_USINGITEM:
					{
						FieldSocketStoreDeleteUsingItem((MSG_FC_STORE_DELETE_USINGITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_GUILD_SUMMON_MEMBER:
					{
						FieldSocketGuildSummonMember((MSG_FC_GUILD_SUMMON_MEMBER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_CARDITEM_RESTORE_NOTIFY:
					{
						FieldSocketItemUseCarditemRestoreNotify((MSG_FC_ITEM_USE_CARDITEM_RESTORE_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_CARDITEM_GUILDSUMMON_NOTIFY:
					{
						FieldSocketItemUseCarditemGuildsummonNotify((MSG_FC_ITEM_USE_CARDITEM_GUILDSUMMON_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_OK:
					{
						FieldSocketInfoGetHappyHourEventInfoOk(FALSE, (MSG_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_GET_GAME_EVENT_INFO_OK:
					{
						FieldSocketInfoGetGameEventInfoOk((MSG_FC_INFO_GET_GAME_EVENT_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MONSTER_TUTORIAL_MONSTER_DEAD_NOTIFY:
					{
						FieldSocketMonsterTutorialMonsterDeadNotify((MSG_FC_MONSTER_TUTORIAL_MONSTER_DEAD_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// 2009. 09. 18 by ckPark ǴƼ ʵ HP   ȭ
				case T_FC_MONSTER_HPTALK:
					{
						FieldSocketMonsterHPTalk( (MSG_FC_MONSTER_HPTALK*)(pPacket+SIZE_FIELD_TYPE_HEADER) );
					}
					break;
				// end 2009. 09. 18 by ckPark ǴƼ ʵ HP   ȭ

				// 2009. 09. 21 by ckPark ǴƼ ʵ  ų 
				case T_FC_MONSTER_SKILL:
					{
						FieldSocketMonsterSkill( (MSG_FC_MONSTER_SKILL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;

				//2011-10-24 by jhahn Ʈ ý  
				case T_FC_TRIGGER_MAP_BUFF_SKILL:
					{
						FieldSocketTriggerMapBuffSkill(( MSG_FC_TRIGGER_MAP_BUFF_SKILL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;		 
				//end 2011-10-24 by jhahn Ʈ ý 	
// 2011-02-08 by jhahn EP4 Ʈ  ý Ʈ 			
				case T_FC_OBJECT_CHANGE	:
					{
						FieldObjectChangeOK( (MSG_FC_OBJECT_CHANGE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
//end 2011-02-08 by jhahn EP4 Ʈ  ý Ʈ 			
				
// 2011-10-24 by jhahn EP4 Ʈ ý 	
				case T_FC_SHOP_CLOSE:					
					{						
						FieldSocketShopClose( (MSG_FC_SHOP_CLOSE*)(pPacket+SIZE_FIELD_TYPE_HEADER) );
					}
					break;
//end 2011-10-24 by jhahn EP4 Ʈ ý 
//2011-10-24 by jhahn EP4 Ʈ ý 
				case T_FC_SET_LIMITTIME:
					{						
						FieldSocketSetLimitTime( (MSG_FC_SET_LIMITTIME*)(pPacket+SIZE_FIELD_TYPE_HEADER) );

					}
					break;
//end 2011-10-24 by jhahn EP4 Ʈ ý 
				case T_FC_BATTLE_MONSTER_BARRIER_USING:
					{
						FieldSocketMonsterMonsterBarrierUsing( (MSG_FC_BATTLE_MONSTER_BARRIER_USING*)(pPacket+SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_BATTLE_MONSTER_BARRIER_USE:
					{
						FieldSocketMonsterMonsterBarrierUse( (MSG_FC_BATTLE_MONSTER_BARRIER_USE*)(pPacket+SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_CHARACTER_DEBUFF_DOT_INFO_OK:
					{
						FieldSocketCharacterDebuffDotInfo( (MSG_FC_CHARACTER_DEBUFF_DOT_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_CHARACTER_DEBUFF_DOT_APPLYING:
					{
						FieldSocketCharacterDebuffDotApply( (MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;

				case T_FC_CHARACTER_DEBUFF_DOT_RELEASE:
					{
						FieldSocketCharacterDebuffDotRelease( (MSG_FC_CHARACTER_DEBUFF_DOT_RELEASE*)(pPacket+SIZE_FIELD_TYPE_HEADER) );
					}
					break;
				// end 2009. 09. 21 by ckPark ǴƼ ʵ  ų 

				// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
				case T_FC_INFINITY_MODE_LIST_OK:
					{
						// ǴƼ  Ʈ
						FieldSocketInfinityModeListOK( (MSG_FC_INFINITY_MODE_LIST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_INFINITY_READY_LIST_OK:
					{
						// ǴƼ  Ʈ
						FieldSocketInfinityReadyListOK( (MSG_FC_INFINITY_READY_LIST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_INFINITY_CREATE_OK:
					{
						// ǴƼ  Ϸ
						FieldSocketInfinityCreateOK( (MSG_FC_INFINITY_CREATE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_INFINITY_MEMBER_INFO_LIST_OK:
					{
						// ǴƼ ο Ʈ
						FieldSocketInfinityMemberInfoList( (MSG_FC_INFINITY_MEMBER_INFO_LIST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_INFINITY_LEAVE_OK:
					{
						// ǴƼ  
						FieldSocketInfinityLeaveOK( (MSG_FC_INFINITY_LEAVE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_INFINITY_BAN_OK:
					{
						// ǴƼ 
						FieldSocketInfinityBanOK( (MSG_FC_INFINITY_BAN_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_INFINITY_JOIN_REQUEST_MASTERUSER:
					{
						// ǴƼ  û
						FieldSocketInfinityJoinRequest( (MSG_FC_INFINITY_JOIN_REQUEST_MASTERUSER*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_JOIN_OK:
					{
						// ǴƼ  
						FieldSocketInfinityJoinOK( (MSG_FC_INFINITY_JOIN_OK*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_ENTER:
					{
						// ǴƼ  
						FieldSocketInfinityEnter( (MSG_FC_INFINITY_ENTER*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_READY_OK:
					{
						//  
						FieldSocketInfinityReadyOK( (MSG_FC_INFINITY_READY_OK*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_READY_CANCEL_OK:
					{
						//   
						FieldSocketInfinityReadyCancelOK( (MSG_FC_INFINITY_READY_CANCEL_OK*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_CHANGE_MASTER_OK:
					{
						//  
						FieldSocketInfinityChangeMaster( (MSG_FC_INFINITY_CHANGE_MASTER_OK*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_CINEMA:
					{
						// 
						FieldSocketInfinityCinema( (MSG_FC_INFINITY_CINEMA*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_SUCCESS_FIN:
					{
						// ǴƼ 
						FieldSocketInfinitySuccessFIN();
					}
					break;

				case T_FC_INFINITY_FAIL_FIN:
					{
						// ǴƼ 
						FieldSocketInfinityFailFIN();
					}
					break;

				case T_FC_INFINITY_READY_FINISH_MAINSVR_START:
					{
						// ǴƼ ,  ʵ弭  
						FieldSocketInfinityReadyFinishMainSvrStart();
					}
					break;

				case T_FC_INFINITY_TENDER_DROPITEM_INFO	:
					{
						//  ߰
						FieldSocketInfinityTenderDropItemInfo( (MSG_FC_INFINITY_TENDER_DROPITEM_INFO*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_TENDER_START:
					{
						//  
						FieldSocketInfinityTenderStart( (MSG_FC_INFINITY_TENDER_START*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_TENDER_PUT_IN_TENDER_OK:
					{
						// ֻ 
						FieldSocketInfinityPutInTenderOK( (MSG_FC_INFINITY_TENDER_PUT_IN_TENDER_OK*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_TENDER_RESULT:
					{
						//  
						FieldSocketInfinityTenderResult( (MSG_FC_INFINITY_TENDER_RESULT*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_TENDER_RESULT_TIMEOVER:
					{
						//  ð 
						FieldSocketInfinityTenderResultTimeOver( (MSG_FC_INFINITY_TENDER_RESULT_TIMEOVER*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_TENDER_RESULT_ALLGIVEUP:
					{
						//   
						FieldSocketInfinityTenderResultAllGiveUp( (MSG_FC_INFINITY_TENDER_RESULT_ALLGIVEUP*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFO_APPLY_RESISTANCE_ITEM:
					{
						// ų 
						FieldSocketInfinityApplyResistanceItem( (MSG_FC_INFO_APPLY_RESISTANCE_ITEM*)( pPacket + SIZE_FIELD_TYPE_HEADER) );
					}
					break;

				case T_FC_SHOP_INFINITY_ITEM_HEADER:
					{
						FieldSocketInfinityShopItemHeader();
					}
					break;

				case T_FC_SHOP_INFINITY_ITEM:
					{
						// ǴƼ    ߰
						FieldSocketInfinityShopItem( (MSG_FC_SHOP_INFINITY_ITEM*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_SHOP_INFINITY_ITEM_DONE:
					{
						FieldSocketInfinityShopItemDone();
					}
					break;

				case T_FC_INFINITY_CHANGE_LIMITTIME:
					{
						// ǴƼ   ð Ƽ
						FieldSocketInfinityChangeLimitTime( (MSG_FC_INFINITY_CHANGE_LIMITTIME*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_JOIN_CANCEL_REQUEST_MASTERUSER:
					{
						// ǴƼ  Ե 
						FieldSocketInfinityJoinCancelRequestMaster( (MSG_FC_INFINITY_JOIN_CANCEL_REQUEST_MASTERUSER*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case  T_FC_INFINITY_REQUEST_RESTART_BY_DISCONNECT:
					{
						// ǴƼ ƨ ˸
						FieldSocketInfinityRequestRestartByDisconnect();
					}
					break;

				case T_FC_INFINITY_DELETED_CINEMA_HEADER:
					{

					}
					break;

				case T_FC_INFINITY_DELETED_CINEMA:
					{
						// ǴƼ ƨ  ִ  cinema
						FieldSocketInfinityDeletedCinema( (MSG_FC_INFINITY_DELETED_CINEMA*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_DELETED_CINEMA_DONE:
					{
						
					}
					break;

				case T_FC_INFINITY_ENTER_BY_DISCONNECT:
					{
						// ǴƼ ƨ 
						FieldSocketInfinityEnterByDisConnect( (MSG_FC_INFINITY_ENTER_BY_DISCONNECT*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_PARTY_AUTO_CREATED:
					{
						FieldSocketInfinityPartyAutoCreated( (MSG_FC_PARTY_AUTO_CREATED*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;
				// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý

				// 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() )

				case T_FC_INFINITY_DIFFICULTY_LIST_OK :
					{
						FieldSocketInfinityRegsiterDifficultyBonusInfoListData ( (MSG_INFINITY_DIFFICULTY_LIST_OK *)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFINITY_CHANGE_DIFFICULTY_LEVEL_OK :
					{
						FieldSocketInfinityChangeRoomDifficultyLevelOK ( (MSG_FC_INFINITY_CHANGE_DIFFICULTY_LEVEL_OK *)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;
				// End 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() )

				// 2010. 05. 31 by hsLee ǴƼ ʵ 2 ̵ . (Ʈ  뷱   .)
				case T_FC_INFINITY_READY_CANCEL_ALL_OK :
					{
						FieldSocketInfinityReadyCancelAllOK ( (MSG_FC_INFINITY_READY_CANCEL_ALL_OK *)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;
				// End 2010. 05. 31 by hsLee ǴƼ ʵ 2 ̵ . (Ʈ  뷱   .)

				// 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.
				case T_FC_INFINITY_SKIP_ENDING_CINEMA_OK :
					{
						FieldSocketInfinityCinemaSkip ( ( MSG_FC_INFINITY_SKIP_ENDING_CINEMA_OK *)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;
				// End 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.

				// 2010. 02. 11 by ckPark ߵ 
				case T_FC_INFO_APPLY_DESTPARAM:
					{
						FieldSocketInfoApplyDestParam( (MSG_FC_INFO_APPLY_DESTPARAM*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_INFO_APPLY_DESTPARAM_LIST:
					{
						FieldSocketInfoApplyDestParamList( (MSG_FC_INFO_APPLY_DESTPARAM_LIST*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_ITEM_END_COOLINGTIME_ITEM_OK:
					{
						FieldSocketItemEndCoolItemOK( (MSG_FC_ITEM_END_COOLINGTIME_ITEM_OK*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_ITEM_GET_COOLINGTIME_INFO_OK:
					{
						FieldSocketItemGetCoolTimeInfoOK( (MSG_FC_ITEM_GET_COOLINGTIME_INFO_OK*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_ITEM_USE_INVOKING_WEAR_ITEM_BUFF:
					{
						FieldSocketItemUseInvokingWearItemBuff( (MSG_FC_ITEM_USE_INVOKING_WEAR_ITEM_BUFF*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;
				// end 2010. 02. 11 by ckPark ߵ 

				// 2010. 03. 15 by ckPark ǴƼ ʵ 2( ó)
				case T_FC_INFINITY_CHANGE_ALIVE_FOR_GAMECLEAR_MONSTERHP:
					{
						FieldSocketInfinityChangeAliveForGameClearMonsterHP( (MSG_FC_INFINITY_CHANGE_ALIVE_FOR_GAMECLEAR_MONSTERHP*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_MONSTER_CREATED_ALIVE_FOR_GAMECLEAR:
					{
						FieldSocketMonsterCreatedAliveForGameClear( (MSG_FC_MONSTER_CREATED_ALIVE_FOR_GAMECLEAR*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;
				// end 2010. 03. 15 by ckPark ǴƼ ʵ 2( ó)

				// 2010. 03. 18 by ckPark ǴƼ ʵ 2( ų ߰)
				case T_FC_MONSTER_SKILL_CANCEL:
					{
						FieldSocketMonsterCancelSkill( (MSG_FC_MONSTER_SKILL_CANCEL*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;
				// end 2010. 03. 18 by ckPark ǴƼ ʵ 2( ų ߰)

				case T_FC_CHARACTER_TUTORIAL_SKIP_OK:
					{
						FieldSocketCharacterTutorialSkipOk((MSG_FC_CHARACTER_TUTORIAL_SKIP_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_DEAD_NOTIFY:
					{
						FieldSocketCharacterDeadNotify((MSG_FC_CHARACTER_DEAD_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITYWAR_MONSTER_DEAD:
					{
						FieldSocketCitywarMonsterDead((MSG_FC_CITYWAR_MONSTER_DEAD*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_CHANGE_INFLUENCE_TYPE:
					{
						FieldSocketCharacterChangeInfluenceType((MSG_FC_CHARACTER_CHANGE_INFLUENCE_TYPE*)(pPacket+SIZE_FIELD_TYPE_HEADER));						
					}
					break;
				case T_FC_SHOP_REQUEST_REPAIR_OK:
					{
						FieldSocketRequestRepairOk((MSG_FC_SHOP_REQUEST_REPAIR_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SKILL_CONFIRM_USE_ACK:
					{
						FieldSocketSkillConfirmUseAck((MSG_FC_SKILL_CONFIRM_USE_ACK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SKILL_CONFIRM_USE:
					{
						FieldSocketSkillConfirmUse((MSG_FC_SKILL_CONFIRM_USE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_UPDATE_ITEMSTORAGE:
					{
						FieldSocketStoreUpdateItemStorage((MSG_FC_STORE_UPDATE_ITEMSTORAGE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_BUY_COLOR_ITEM_OK:
					{
						FieldSocketShopBuyColorItemOk((MSG_FC_SHOP_BUY_COLOR_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_ATTACK_EVASION_OK:
					{
						FieldSocketBattleAttackEvasionOk((MSG_FC_BATTLE_ATTACK_EVASION_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_NOTIFY_INVASION:
					{
						FieldSocketWarNotifyInvasion((MSG_FC_WAR_NOTIFY_INVASION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD:
					{
						FieldSocketWarNotifyInfluenceMonsterDead((MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2007-02-15 by bhsohn  ڵ Ҹ ̺Ʈ .
				case T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_AUTO_DESTROYED:
					{
						FieldSocketWarNotifyInfluenceAutoMonsterDead((MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2007-02-15 by bhsohn  ڵ Ҹ ̺Ʈ .
				case T_FC_WAR_NOTIFY_INFLUENCE_MONSTER_INVASION:
					{
						FieldSocketWarNotifyInfluenceMonsterIvasion((MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_INVASION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_UPDATE_USINGITEM:
					{
						FieldSocketStoreUpdateUsingItem((MSG_FC_STORE_UPDATE_USINGITEM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_BOSS_MONSTER_SUMMON_DATA:
					{
						FieldSocketWarBossMonsterSummonDataInvasion((MSG_FC_WAR_BOSS_MONSTER_SUMMON_DATA*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2007-07-04 by bhsohn ۷ ߰
				case T_FC_WAR_STRATEGYPOINT_MONSTER_SUMMON:
					{
						FieldSocketWarStrategypointMonsterSummon(((MSG_FC_WAR_STRATEGYPOINT_MONSTER_SUMMON*)(pPacket+SIZE_FIELD_TYPE_HEADER)));
					}
					break;
					// end 2007-07-04 by bhsohn ۷ ߰
				case T_FC_WAR_SIGN_BOARD_INSERT_STRING:
					{
						FieldSocketWarSignBoardInsertString((MSG_FC_WAR_SIGN_BOARD_INSERT_STRING*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_REQ_SIGN_BOARD_STRING_LIST_OK:
					{
						FieldSocketWarReqSignBoardStringListOk((MSG_FC_WAR_REQ_SIGN_BOARD_STRING_LIST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_SIGN_BOARD_DELETE_STRING:
					{
						FieldSocketWarSignBoardDeleteString((MSG_FC_WAR_SIGN_BOARD_DELETE_STRING*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK:
					{
						FieldSocketWarUpdateContributionPointOk((MSG_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_JACO_MONSTER_SUMMON:
					{
						FieldSocketWarJacoMonsterSummon((MSG_FC_WAR_JACO_MONSTER_SUMMON*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_INFLUENCE_DATA:
					{
						FieldSocketWarInfluenceData((MSG_FC_WAR_INFLUENCE_DATA*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_INFLUENCE_BUFF_OK:
					{
						FieldSocketItemUseBuffOk((MSG_FC_ITEM_USE_INFLUENCE_BUFF_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_USE_INFLUENCE_GAMEEVENT_OK:
					{
						FieldSocketItemUseInfluenceGameEventOk((MSG_FC_ITEM_USE_INFLUENCE_GAMEEVENT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2008-04-04 by bhsohn ٽ  
//				case T_FC_MOVE_HACKSHIELD_GuidReqMsg:
//					{
//						FieldSocketMoveHackShield_GuidReqMsg((MSG_FC_MOVE_HACKSHIELD_GuidReqMsg*)(pPacket+SIZE_FIELD_TYPE_HEADER));
//					}
//					break;
					// end 2008-04-04 by bhsohn ٽ  
				case T_FC_MOVE_HACKSHIELD_CRCReqMsg:
					{
						FieldSocketMoveHackShield_CRCReqMsg((MSG_FC_MOVE_HACKSHIELD_CRCReqMsg*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_UPDATE_ITEMNUM:
					{
						FieldSocketStoreUpdateItemNum((MSG_FC_STORE_UPDATE_ITEMNUM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_CALL_WARP_EVENT_REQUEST:
					{
						FieldSocketEventCallWarpEventReqeust((MSG_FC_EVENT_CALL_WARP_EVENT_REQUEST*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_SELL_PUT_ITEM_OK:
					{
						FieldSocketBazaarSellPutItemOK((MSG_FC_BAZAAR_SELL_PUT_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_BUY_PUT_ITEM_OK:
					{
						FieldSocketBazaarBuyPutItemOK((MSG_FC_BAZAAR_BUY_PUT_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_SELL_CANCEL_ITEM_OK:
					{
						FieldSocketBazaarSellCancelItemOK((MSG_FC_BAZAAR_SELL_CANCEL_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_BUY_CANCEL_ITEM_OK:
					{
						FieldSocketBazaarBuyCancelItemOK((MSG_FC_BAZAAR_BUY_CANCEL_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_SELL_START_OK:
					{
						FieldSocketBazaarSellStartOK();
					}
					break;
				case T_FC_BAZAAR_BUY_START_OK:
					{
						FieldSocketBazaarBuyStartOK();
					}
					break;
				case T_FC_BAZAAR_INFO_OK:
					{
						FieldSocketBazaarInfoOK((MSG_FC_BAZAAR_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_SELL_REQUEST_ITEMLIST_OK:
					{
						FieldSocketBazaarSellReQuestItemListOK((MSG_FC_BAZAAR_SELL_REQUEST_ITEMLIST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_BUY_REQUEST_ITEMLIST_OK:
					{
						FieldSocketBazaarBuyReQuestItemListOK((MSG_FC_BAZAAR_BUY_REQUEST_ITEMLIST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_CUSTOMER_INFO_OK:
					{
						FieldSocketBazaarCustomerInfoOK((MSG_FC_BAZAAR_CUSTOMER_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_SELL_ITEM_ENCHANTLIST_OK:
					{
						FieldSocketBazaarSellItemEnchantlistOK((MSG_FC_BAZAAR_SELL_ITEM_ENCHANTLIST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_SELL_BUY_ITEM_OK:
					{
						FieldSocketBazaarSellBuyItemOK((MSG_FC_BAZAAR_SELL_BUY_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BAZAAR_BUY_SELL_ITEM_OK:
					{
						FieldSocketBazaarBuySellItemOK((MSG_FC_BAZAAR_BUY_SELL_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CONNECT_NOTIFY_SERVER_SHUTDOWN:
					{
						FieldSocketNotifyServerShutdown();
					}
					break;
				case T_FC_ITEM_USE_RANDOMBOX_OK:
					{
						FieldSocketItemUseRandomBoxOk((MSG_FC_ITEM_USE_RANDOMBOX_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2008-08-26 by bhsohn ڽ ý 
				case T_FC_ITEM_USE_RANDOMBOX_OK_DONE:
					{
						FieldSocketItemUseRandomBoxOkDone();
					}
					break;
					// end 2008-08-26 by bhsohn ڽ ý 
				case T_FC_STORE_REQUEST_QUICKSLOT_OK:
					{
						FieldSocketStoreRequestQuickslotOK((MSG_FC_STORE_REQUEST_QUICKSLOT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_USE_BONUSSTAT_OK:
					{
						FieldSocketCharacterUseBonusstatOK((MSG_FC_CHARACTER_USE_BONUSSTAT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_LOG_GUILD_ITEM_OK:
					{
						FieldSocketStoreLogGuildItemOK((MSG_FC_STORE_LOG_GUILD_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_STORE_LOG_GUILD_ITEM_OK_HEADER:
					{
						FieldSocketStoreLogGuildItemOKHeader();
					}
					break;
				case T_FC_STORE_LOG_GUILD_ITEM_OK_DONE:
					{
						FieldSocketStoreLogGuildItemOKDone();						
					}
					break;
				case T_FC_ITEM_USE_SKILL_SUPPORT_ITEM_OK:
					{
						FieldSocketUseSkillSupportItemOK((MSG_FC_ITEM_USE_SKILL_SUPPORT_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_GET_SERVER_DATE_TIME_OK:
					{
						FieldSocketGetServerDataTimeOK((MSG_FC_INFO_GET_SERVER_DATE_TIME_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_REQUEST_PARTY_WARP:
					{
						FieldSocketRequestPartyWarp((MSG_FC_QUEST_REQUEST_PARTY_WARP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_MONSTER_CREATED:
					{
						FieldSocketWarMonsterCreated((MSG_FC_WAR_MONSTER_CREATED*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_MONSTER_AUTO_DESTROYED:
					{
						FieldSocketWarMonsterAutoDestroyed((MSG_FC_WAR_MONSTER_AUTO_DESTROYED*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_WAR_MONSTER_DEAD:
					{
						FieldSocketWarMonsterDead((MSG_FC_WAR_MONSTER_DEAD*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SKILL_CANCEL_SKILL_OK:
					{
						FieldSocketSkillCancelSkillOK((MSG_FC_SKILL_CANCEL_SKILL_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_DELETE_DUMMY_OK:
					{
						FieldSocketBattleDeleteDummyOK((MSG_FC_BATTLE_DELETE_DUMMY_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_BATTLE_EXPLODE_DUMMY_OK:
					{
						FieldSocketBattleExplodeDummyOK((MSG_FC_BATTLE_EXPLODE_DUMMY_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_OBSERVER_START_OK:
					{
						FieldSocketCharacterObserverStartOK((MSG_FC_CHARACTER_OBSERVER_START*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_OBSERVER_END_OK:
					{
						FieldSocketCharacterObserverEndOK((MSG_FC_CHARACTER_OBSERVER_END*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_OBSERVER_REG:
					{
						FieldSocketCharacterObserverRegOK((MSG_FC_CHARACTER_OBSERVER_REG*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_OBSERVER_INFO:
					{
						FieldSocketCharacterObserverInfoOK((MSG_FC_CHARACTER_OBSERVER_INFO*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_REQUEST_TEAM_OK:
					{
						FieldSocketArenaRequestTeamOK((MSG_FC_ARENA_REQUEST_TEAM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_CREATE_TEAM_OK:
					{
						FieldSocketArenaCreateTeamOK((MSG_FC_ARENA_CREATE_TEAM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_ENTER_TEAM_OK:
					{
						FieldSocketArenaEnterTeamOK((MSG_FC_ARENA_ENTER_TEAM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_TEAM_MEMBER_LIST:
					{
						FieldSocketArenaTeamMemberList((MSG_FC_ARENA_TEAM_MEMBER_LIST*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_REAVE_TEAM_OK:
					{
						FieldSocketArenaReaveTeamOK();
					}
					break;
				case T_FC_ARENA_TEAM_READY:
					{
						FieldSocketArenaTeamReady((MSG_FC_ARENA_TEAM_READY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_ENTER_ROOM:
					{
						FieldSocketArenaEnterRoom((MSG_FC_ARENA_ENTER_ROOM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_ROOM_WAR_START:
					{
						FieldSocketArenaRoomWarStart();
					}
					break;
				case T_FC_ARENA_ROOM_WAR_INFO:
					{
						FieldSocketArenaRoomWarInfo((MSG_FC_ARENA_ROOM_WAR_INFO*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_ROOM_WAR_FINISH_HEADER:
					{
						FieldSocketArenaRoomWarFinishHeader((MSG_FC_ARENA_ROOM_WAR_FINISH_HEADER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_ROOM_WAR_FINISH:
					{
						FieldSocketArenaRoomWarFinish((MSG_FC_ARENA_ROOM_WAR_FINISH*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_ROOM_WAR_FINISH_DONE:
					{
						FieldSocketArenaRoomWarFinishDone((MSG_FC_ARENA_ROOM_WAR_FINISH_DONE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_ROOM_WAR_FINISH_DRAW:
					{
						FieldSocketArenaRoomWarFinishDraw((MSG_FC_ARENA_ROOM_WAR_FINISH_DRAW*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_FINISH_WARP_OK:
					{
						FieldSocketArenaFinishWarpOK((MSG_FC_ARENA_FINISH_WARP_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_BEFORE_ROOM_WAR_FINISH:
					{
						FieldSocketArenaBeforRoomWarFinish();
					}
					break;
				case T_FC_ARENA_REQUEST_CREATE_TEAMINFO_OK:
					{
						FieldSocketArenaRequestCreateTeamInfoOK((MSG_FC_ARENA_REQUEST_CREATE_TEAMINFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_TEAM_MATCHING:
					{
						FieldSocketArenaTeamMatching();
					}
					break;
				case T_FC_CHARACTER_PAY_WARPOINT:
					{
						FieldSocketCharacterPayWarPoint((MSG_FC_CHARACTER_PAY_WARPOINT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_REQUEST_OTHER_TEAM_INFO_OK:
					{
						FieldSocketArenaRequestOtherTeamInfoOK((MSG_FC_ARENA_REQUEST_OTHER_TEAM_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_GM_COMMAND_INFO_HEADER:
					{
						FieldSocketArenaGMCommandInfoHeader();
					}
					break;
				case T_FC_ARENA_GM_COMMAND_INFO:
					{
						FieldSocketArenaGMCommandInfo((MSG_FC_ARENA_GM_COMMAND_INFO*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_GM_COMMAND_INFO_DONE:
					{
						FieldSocketArenaGMCommandInfoDone((MSG_FC_ARENA_GM_COMMAND_INFO_DONE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_BUY_WARPOINT_ITEM_OK:
					{
						FieldSocketShopBuyWarPointItemOK((MSG_FC_SHOP_BUY_WARPOINT_ITEM_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_WATCH_READY:
					{
						FieldSocketArenaWatchReady((MSG_FC_ARENA_WATCH_READY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_WATCH_START:
					{
						FieldSocketArenaWatchStart((MSG_FC_ARENA_WATCH_START*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ARENA_WATCH_END:
					{
						FieldSocketArenaWatchEnd();
					}
					break;
				case T_FC_ARENA_WATCH_REMOVE_USER:
					{
						FieldSocketArenaWatchRemoveUser((MSG_FC_ARENA_WATCH_REMOVE_USER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHARACTER_WATCH_INFO:	
					{
						FieldSocketCharacterWatchInfo((MSG_FC_CHARACTER_WATCH_INFO*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TUTORIAL_START_OK:
					{
						FieldSocketTutorialStartOK((MSG_FC_TUTORIAL_START_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_TUTORIAL_COMPLETE_OK:
					{
						FieldSocketTutorialCompleteOK((MSG_FC_TUTORIAL_COMPLETE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));;
					}
					break;
				case T_FC_TUTORIAL_END_OK:
					{
						FieldSocketTutorialEndOK();
					}
					break;
					// 2007-08-07 by bhsohn Ŀ  ߰
				case T_FC_CHAT_ALL_INFLUENCE:
					{
						FieldSocketChatAllInfluenceOK((MSG_FC_CHAT_ALL_INFLUENCE*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2007-08-07 by bhsohn Ŀ  ߰
				case T_FC_CHAT_OUTPOST_GUILD:
					{
						FieldSocketChatOutPostGuild((MSG_FC_CHAT_OUTPOST_GUILD*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_WAR_BEFORE:
					{
						FieldSocketOutPostWarBefore((MSG_FC_OUTPOST_WAR_BEFORE*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_WAR_START:
					{
						FieldSocketOutPostWarStart((MSG_FC_OUTPOST_WAR_START*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_PROTECTOR_DESTROY:
					{
						FieldSocketOutPostProtectorDestroy((MSG_FC_OUTPOST_PROTECTOR_DESTROY*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_RESET_START_OK:
					{
						FieldSocketOutPostResetStartOk((MSG_FC_OUTPOST_RESET_START_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_RESET_DESTROY:
					{
						FieldSocketOutPostResetDestroy((MSG_FC_OUTPOST_RESET_DESTROY*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_RESET_SUCCESS:
					{
						FieldSocketOutPostResetSuccess((MSG_FC_OUTPOST_RESET_SUCCESS*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_WAR_END:
					{
						FieldSocketOutPostWarEnd((MSG_FC_OUTPOST_WAR_END*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_NOTICE_REQUEST_OK:
					{
						FieldSocketInfoNoticeRequestOk((MSG_FC_INFO_NOTICE_REQUEST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_NOTICE_REG_OK:
					{
						FieldSocketInfoNoticeRegOk();
					}
					break;
				case T_FC_INFO_NOTICE_MODIFY_OK:
					{
						FieldSocketInfoNoticeModifyOk();
					}
					break;
				case T_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK:
					{
						FieldSocketInfoExpediencyfundPayBackOk((MSG_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_EXPEDIENCYFUND_REQUEST_OK:
					{
						FieldSocketInfoExpediencyfundRequestOk((MSG_FC_INFO_EXPEDIENCYFUND_REQUEST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_NEXTWAR_INFO_REQUEST_OK:
					{
						FieldSocketOutPostNextWarInfoRequestOk((MSG_FC_OUTPOST_NEXTWAR_INFO_REQUEST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_NEXTWAR_SET_TIME_OK:
					{
						FieldSocketOutPostNextWarSetTimeOk((MSG_FC_OUTPOST_NEXTWAR_SET_TIME_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_OUTPOST_WAR_INFO:
					{
						FieldSocketOutPostWarInfo((MSG_FC_OUTPOST_WAR_INFO*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2007-09-12 by bhsohn 2 ȣ ý 
				case T_FC_INFO_SECONDARYPASSWORD_LOCK_OK:
					{
						FieldSecondLockOk((MSG_FC_INFO_SECONDARYPASSWORD_LOCK_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_SECONDARYPASSWORD_CHECK_PASSWORD_OK:
					{
						FieldSocketInfoSecondarypasswordCheckPassword(TRUE);
					}
					break;
				case T_FC_INFO_SECONDARYPASSWORD_UPDATE_PASSWORD_OK:
					{
						FieldSocketSecondPasswordUpdateOk(TRUE);
					}
					break;				
					// end 2007-09-12 by bhsohn 2 ȣ ý 
				case T_FC_EVENT_TELEPORT_BUILDCOMPLETE:
					{
						FieldSocketEventTeleportBuildComplete((MSG_FC_EVENT_TELEPORT_BUILDCOMPLETE*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_TELEPORT_DESTROY:
					{
						FieldSocketEventTeleportDestroy((MSG_FC_EVENT_TELEPORT_DESTROY*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;					
				case T_FC_CHARACTER_UPDATE_SUBLEADER_OK:
					{
						FieldSocketCharacterUpdateSubleaderOk((MSG_FC_CHARACTER_UPDATE_SUBLEADER_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK_HEADER:
					{
						FieldSocketCityPollRequestLeaderCandidateListOKHeader((MSG_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK_HEADER*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK:
					{
						FieldSocketCityPollRequestLeaderCandidateListOK((MSG_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST_OK_DONE:
					{
						FieldSocketCityPollRequestLeaderCandidateListOKDone();
					}
					break;
				case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO_OK:
					{
						FieldSocketCityPollRequestLeaderCandidateInfoOK((MSG_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO_OK_GUILDMARK:
					{
						FieldSocketCityPollRequestLeaderCandidateInfoOkGuildMark((MSG_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_INFO_OK_GUILDMARK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_POLL_REG_LEADER_CANDIDATE_OK:
					{
						FieldSocketCityPollRegLeaderCandidateOK((MSG_FC_CITY_POLL_REG_LEADER_CANDIDATE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_POLL_DELETE_LEADER_CANDIDATE_OK:
					{
						FieldSocketCityPollDeleteLeaderCandidateOK();
					}
					break;
				case T_FC_CITY_POLL_REQUEST_POLL_DATE_OK:
					{
						FieldSocketCityPollRequestPollDateOK((MSG_FC_CITY_POLL_REQUEST_POLL_DATE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_POLL_VOTE_OK:
					{
						FieldSocketCityPollVoteOK();
					}
					break;
				case T_FC_SHOP_CHECK_GIVE_TARGET_OK:
					{
						FieldSocketShopCheckGiveTargetOK((MSG_FC_SHOP_CHECK_GIVE_TARGET_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_SHOP_BUY_CASH_ITEM_OK:
					{
						FieldSocketShopBuyCashItemOK((MSG_FC_SHOP_BUY_CASH_ITEM_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
						
#ifdef C_EPSODE4_UI_CHANGE_JSKIM					        // 2011. 10. 10 by jskim UIý 
                case T_FC_SHOP_BUY_ITEM_UPDATE:
					{
						FieldSocketShopBuyItemUpdate((MSG_FC_SHOP_BUY_ITEM_UPDATE*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				
#endif
				case T_FC_CITY_POLL_LEADER_ELECTION_INFO:
					{
						FieldSocketCityPollLeaderElectionInfo((MSG_FC_CITY_POLL_LEADER_ELECTION_INFO*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_NOTIFY_MSG_GET_OK:
					{
						FieldSocketEventNotifyMsgGetOK((MSG_FC_EVENT_NOTIFY_MSG_GET_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_WARINFO_INFLUENCE_OK:
					{
						FieldSocketCityWarInfoInfluenceOK((MSG_FC_CITY_WARINFO_INFLUENCE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CITY_WARINFO_OUTPOST_OK:
					{
						FieldSocketCityWarInfoOutPostOK((MSG_FC_CITY_WARINFO_OUTPOST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_GET_GUILDMARK_OK:
					{
						FieldSocketInfoGetGuildMarkOK((MSG_FC_INFO_GET_GUILDMARK_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// 2007-11-22 by bhsohn Ʒ ռ
				case T_FC_CONNECT_ARENASERVER_INFO:
					{
						// Ʒ    
						FieldSocketConnectArenaServerInfo((MSG_FC_CONNECT_ARENASERVER_INFO*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CONNECT_ARENASERVER_LOGIN_OK:
					{
						// Ʒ ʵ  α 						
						FieldSocketConnectArenaServerLoginOk((MSG_FC_CONNECT_ARENASERVER_LOGIN_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;					
				case T_FC_ARENA_POSSIBLE_GAMESTART:
					{

						// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

// 						// Ʒ   
// 						FieldSocketArenaPossibleGameStart((MSG_FC_ARENA_POSSIBLE_GAMESTART*)(pPacket+SIZE_FIELD_TYPE_HEADER));

						if( m_ArenaSocketType != ARENASOCKET_INFINITY )
							FieldSocketArenaPossibleGameStart((MSG_FC_ARENA_POSSIBLE_GAMESTART*)(pPacket+SIZE_FIELD_TYPE_HEADER));
						else
						{
							// ǴƼ ۽
							if( m_ArenaSocketType == ARENASOCKET_INFINITY )
							{

								// 2011-07-21 by jhahn	3  ǴƼ  ޼  ޼ â 
								if( m_pInterface && m_pInterface->m_pInfinityPopup )			
									m_pInterface->m_pInfinityPopup->AddChat( STRMSG_C_100310_0306 );

								//	m_pChat->CreateChatChild( STRMSG_C_100310_0306, COLOR_SYSTEM );		// "\\yǴƼ ʵ մϴ.\\y"
								//end 2011-07-21 by jhahn	3  ǴƼ  ޼  ޼ â 					
							

								// ǴƼ ʷε 
								m_bWaitInfinityMapLoad	= TRUE;

								// ǴƼ ʷε  ð
								m_nInfinityMapLoadTime	= timeGetTime() + 1000;

								// Ʒ  Ŷ
								memcpy( &m_ArenaStartPacket,
										(MSG_FC_ARENA_POSSIBLE_GAMESTART*)(pPacket+SIZE_FIELD_TYPE_HEADER),
										sizeof( MSG_FC_ARENA_POSSIBLE_GAMESTART ) );
							}
						}
						// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

					}
					break;					
				case T_FC_CHARACTER_READY_GAMESTART_FROM_ARENA_TO_MAINSERVER_OK:
					{
						FieldSocketCharacterReadyGamestartFromArenaToMainserver((MSG_FC_CHARACTER_READY_GAMESTART_FROM_ARENA_TO_MAINSERVER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;					
					// end 2007-11-22 by bhsohn Ʒ ռ
					
					// 2007-12-17 by bhsohn    ȿ  ·
				case T_FC_SKILL_SETUP_SKILL_OK_HEADER:
					{
						
					}
					break;
				case T_FC_SKILL_SETUP_SKILL_OK_DONE:
					{			
						// 2007-11-22 by bhsohn Ʒ ռ
						if(ARENA_STATE_ARENA_GAMING == GetArenaState())
						{
							if(g_pGameMain && g_pGameMain->m_pQuickSlot)
							{
								g_pGameMain->m_pQuickSlot->RefreshQSlotInfo();
							}
						}
						// end 2007-11-22 by bhsohn Ʒ ռ

						// 2010. 03. 23 by ckPark ǴƼ ʵ 2(ǴƼ ʵ  ĳ)
						m_bInfinitySkillSetupOKDone	= TRUE;
						// end 2010. 03. 23 by ckPark ǴƼ ʵ 2(ǴƼ ʵ  ĳ)
					}
					break;
				case T_FC_QUEST_PUT_ALL_QUEST_HEADER:
					{
						
					}
					break;
				case T_FC_QUEST_PUT_ALL_QUEST_DONE:
					{
						// 2010. 01. 12 by ckPark      ƴ   ϴ  ذ

						FieldSocketPutAllQuestDone();

						// end 2010. 01. 12 by ckPark      ƴ   ϴ  ذ
					}
					break;
				case T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT_HEADER:
					{						
					}
					break;
				case T_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT_DONE:
					{
						// 2009-02-03 by bhsohn ̼ ۽ Ϸ üũ üũ
						FieldSocketQuestPutAllQuestMonsterCountDone();
						// end 2009-02-03 by bhsohn ̼ ۽ Ϸ üũ üũ
					}
					break;
				case T_FC_ITEM_PUT_ENCHANT_HEADER:
					{						
					}
					break;
				case T_FC_ITEM_PUT_ENCHANT_DONE:
					{
// 2012-07-06 by mspark, æƮ Ʈ
#ifdef C_ENCHANT_EFFECT_MSPARK
						m_pShuttleChild->InitItemPoint();
#endif
// end 2012-07-06 by mspark, æƮ Ʈ
						// 2009. 04. 06 by ckPark ӽ۽ ߷ æƮ  ȵȻ·  (0001388)
						FieldSocketPutEnchantDone();
						// end 2009. 04. 06 by ckPark ӽ۽ ߷ æƮ  ȵȻ·  (0001388)
					}
					break;
					// end 2007-12-17 by bhsohn    ȿ  ·
				case T_FC_EVENT_COUPON_EVENT_INFO:
					{
						FieldSocketEventCouponEventInfo((MSG_FC_EVENT_COUPON_EVENT_INFO*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_COUPON_EVENT_USE_COUPON_OK:
					{
						FieldSocketEventCouponEventUseCouponOK((MSG_FC_EVENT_COUPON_EVENT_USE_COUPON_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2008-02-15 by bhsohn Ʈũ ӵ üũ
				case T_FC_CONNECT_NETWORK_CHECK_OK:
					{
						FieldSocketConnectNetWorkCheckOk((MSG_FC_CONNECT_NETWORK_CHECK_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2008-02-15 by bhsohn Ʈũ ӵ üũ
					// 2008-02-25 by bhsohn Ʒ    ǥϰ 
				case T_FC_CONNECT_ARENASERVER_SSERVER_GROUP_FOR_CLIENT:
					{
						FieldSocketArenaServerSServerGroupForClient((MSG_FC_CONNECT_ARENASERVER_SSERVER_GROUP_FOR_CLIENT*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2008-02-25 by bhsohn Ʒ    ǥϰ 
				// 2008-03-10 by bhsohn Ʒ ȯ Ż ó
				case T_FC_ARENA_USE_CITYWARPITEM:
					{
						FieldSocketArenaUseCityWarpItem();
					}
					break;
					// end 2008-03-10 by bhsohn Ʒ ȯ Ż ó
					// 2008-03-14 by bhsohn   Ǿƿ ó
				case T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_BY_LEVEL:
					{
						FieldSocketInfoGetHappyHourEventInfoOk(TRUE, (MSG_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2008-03-14 by bhsohn   Ǿƿ ó
					// 2008-03-19 by bhsohn ,  â
				case T_FC_INFO_MSWARINFO_RESULT_OK:
					{
						FieldSocketInfoMsWarInfoResultOk((MSG_FC_INFO_MSWARINFO_RESULT_OK*) (pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_SPWARINFO_RESULT_OK_HEADER:
					{
						//   						
						FieldSocketInfoSpWarInfoResultOkHeader();
					}
					break;
				case T_FC_INFO_SPWARINFO_RESULT_OK:
					{
						FieldSocketInfoSpWarInfoResultOk((MSG_FC_INFO_SPWARINFO_RESULT_OK*) (pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_SPWARINFO_RESULT_OK_DONE:
					{	
						// 2008-04-22 by bhsohn /   ǥ ϰ 
						//    Ʈ
						FieldSocketInfoSpWarInfoResultOkDone();
					}
					break;					
					// end 2008-03-19 by bhsohn ,  â
				case T_FC_INFO_MSWARINFO_DISPLAY:
					{
						FieldSocketInfoMSWarInfoDisplay((MSG_FC_INFO_MSWARINFO_DISPLAY*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_MSWARINFO_DISPLAY_OPTION_OK:
					{
						FieldSocketInfoMSWarInfoDisplayOptionOK((MSG_FC_INFO_MSWARINFO_DISPLAY_OPTION_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_CLICK_TELEPORT_OK:
					{
						FieldSocketEventClickTeleportOK((MSG_FC_EVENT_CLICK_TELEPORT_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
					//  Ʈ
				case T_FC_CHAT_LETTER_REQUEST_TITLE_OK_HEADER:
					{
						FieldSocketChatLetterRqTitleHeader();
					}
					break;
				case T_FC_CHAT_LETTER_REQUEST_TITLE_OK:
					{
						FieldSocketChatLetterRqTitle((MSG_FC_CHAT_LETTER_REQUEST_TITLE_OK*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHAT_LETTER_REQUEST_TITLE_OK_DONE:
					{
						FieldSocketChatLetterRqTitleOkDone();
					}
					break;
					//  
				case T_FC_CHAT_LETTER_READ_OK:
					{
						FieldSocketLetterReadOk((MSG_FC_CHAT_LETTER_READ_OK*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					//  
				case T_FC_CHAT_LETTER_DELETE_OK:
					{
						FieldSocketChatLetterDelOk();
					}
					break;
					//  
				case T_FC_CHAT_LETTER_SEND_OK:
					{
						FieldSocketChatSendOk();
					}
					break;
				case T_FC_CHAT_LETTER_RECEIVE:
					{
						//  .
						FiedldSocketChatLetterReceive((MSG_FC_CHAT_LETTER_RECEIVE*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// ü  
				case T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK_HEADER:
					{
					}
					break;
				case T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK:
					{
						FieldSocketChatALLLetterRqTitle((MSG_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_CHAT_ALLLETTER_REQUEST_TITLE_OK_DONE:
					{
						FieldSocketChatALLLetterRqTitleOkDone();						
					}
					break;
					// ü  
				case T_FC_CHAT_ALLLETTER_READ_OK:
					{
						FieldSocketAllLetterReadOk((MSG_FC_CHAT_ALLLETTER_READ_OK*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// ü  
				case T_FC_CHAT_ALLLETTER_DELETE_OK:
					{
						FieldSocketChatLetterDelOk();
					}
					break;
					// ü  
				case T_FC_CHAT_ALLLETTER_SEND_OK:
					{
						FieldSocketChatSendOk();
					}
					break;
				case T_FC_CHAT_ALLLETTER_RECEIVE:
					{
						// ü .						
						FiedldSocketChatAllLetterReceive((MSG_FC_CHAT_ALLLETTER_RECEIVE*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					//  ó
				case T_FC_CHARACTER_GET_USER_INFO_OK:
					{
						FieldSocketCharacterGetUserInfoOk((MSG_FC_CHARACTER_GET_USER_INFO_OK*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// 2012-06-14 by isshin ۹̸
				case T_FC_CHARACTER_GET_USER_ITEM_INFO_SECRET_OK:
					{
						FieldSocketCharacterGetUserItemInfoSecretOk((MSG_FC_CHARACTER_GET_USER_ITEM_INFO_SECRET_OK*) (pPacket + SIZE_FIELD_TYPE_HEADER));												
					}
					break;				
				case T_FC_CHARACTER_GET_USER_ITEM_INFO_OK:
					{
						FieldSocketCharacterGetUserItemInfoOk((MSG_FC_ENEMY_ITEM_INFO*) (pPacket + SIZE_FIELD_TYPE_HEADER));												
					}
					break;
				case T_FC_CHARACTER_GET_USER_ITEM_INFO_OK_DONE:
					{
						FieldSocketCharacterGetUserItemInfoDone((MSG_FC_CHARACTER_GET_USER_ITEM_INFO_OK_DONE*) (pPacket + SIZE_FIELD_TYPE_HEADER));												
					}
					break;
					// end 2012-06-14 by isshin ۹̸
				case T_FC_CHARACTER_CHANGE_INFO_OPTION_SECRET_OK:
					{
						FieldSocketCharacterChangeInfoOptionSecetOk();
					}
					break;
					// end 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
					// 2008-08-19 by bhsohn  ũ ý ߰
				case T_FC_EVENT_INFLUENCEMARK:
					{
						FieldSocketEventInfluenceMark((MSG_FC_EVENT_INFLUENCEMARK*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_EVENT_INFLUENCEMARKEND:
					{
						FieldSocketEventInfluenceMarkEnd();
					}
					break;
					// end 2008-08-19 by bhsohn  ũ ý ߰
                    // 2008-11-21 by bhsohn ŷ Ϸ ý ó
				case T_FC_TRADE_OK_TRADE_NOTIFY:
					{
						FieldSocketTradeOkTradeNotify((MSG_FC_TRADE_OK_TRADE_NOTIFY*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2008-11-21 by bhsohn ŷ Ϸ ý ó
					
				case T_FC_ITEM_USE_LUCKY_ITEM_OK:
					{
						FieldSocketItemUseRuckyItemOK((MSG_FC_ITEM_USE_LUCKY_ITEM_OK*) (pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// 2009. 08. 27 by ckPark ׷ ҽ  ý 
				case T_FC_ITEM_CHANGED_SHAPEITEMNUM:
					{
						FieldSocketItemChangedShapeItemNum( (MSG_FC_ITEM_CHANGED_SHAPEITEMNUM*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;

				case T_FC_ITEM_CHANGED_EFFECTITEMNUM:
					{
						FieldSocketItemChangedEffectItemNum( (MSG_FC_ITEM_CHANGED_EFFECTITEMNUM*)( pPacket + SIZE_FIELD_TYPE_HEADER ) );
					}
					break;
				// end 2009. 08. 27 by ckPark ׷ ҽ  ý 

					// 2008-11-28 by bhsohn XignCode߰
				case T_FC_MOVE_XIGNCODE_REQ_SCAN_INIT:
					{
						FieldSocketMoveXignCodeReqScanInit(nSocketNotifyType, (MSG_FC_MOVE_XIGNCODE_REQ_SCAN_INIT*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_MOVE_XIGNCODE_REQ_SCAN_CHECK:
					{
						FieldSocketMoveXignCodeReqScanCheck(nSocketNotifyType, (MSG_FC_MOVE_XIGNCODE_REQ_SCAN_CHECK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2008-11-28 by bhsohn XignCode߰
// 2008-12-09 by dgwoo ̼Ǹ.
				case T_FC_QUEST_REQUEST_MISSIONMASTER_HELP_INVITE:
					{
						FieldSocketQuestRequestMissionMasterHelpInvite((MSG_FC_QUEST_REQUEST_MISSIONMASTER_HELP_INVITE*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_MISSIONMASTER_HELP_INVITE_OK:
					{
						FieldSocketQuestMissionMasterHelpInviteOK((MSG_FC_QUEST_MISSIONMASTER_HELP_INVITE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_MISSIONMASTER_HELP_REJECT_OK:
					{
						FieldSocketQuestMissionMasterHelpRejectOK((MSG_FC_QUEST_MISSIONMASTER_HELP_REJECT_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;		  
// end 2008-12-09 by dgwoo ̼Ǹ.
					// 2008-12-30 by bhsohn ﺸ߰ ȹ
				case T_FC_WAR_BOSS_CONTRIBUTION_GUILD:
					{
						FieldSocketBossContributionGuild((MSG_FC_WAR_BOSS_CONTRIBUTION_GUILD*)(pPacket + SIZE_FIELD_TYPE_HEADER));						
					}
					break;
					// end 2008-12-30 by bhsohn ﺸ߰ ȹ

					// 2009. 01. 12 by ckPark   ý
				case T_FC_INFO_DECLARATION_MSWAR_INFO_OK:
					{
						g_pD3dApp->EnterLock(TRUE);

						FieldSocketWarDeclareInfoOK((MSG_FC_INFO_DECLARATION_MSWAR_INFO_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2009. 01. 12 by ckPark   ý
					// 2009-02-13 by bhsohn  ŷ ý
				case T_FC_INFO_WRK_GET_SERVICE_INFO_OK:
					{						
						FieldSocketInfoWRKGetServiceInfoOk((MSG_FC_INFO_WRK_GET_SERVICE_INFO_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_WRK_GET_SERVICE_INFO_OK_IMAGE:
					{						
						FieldSocketInfoWRKGetServiceInfoOkImage((MSG_FC_INFO_WRK_GET_SERVICE_INFO_OK_IMAGE*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_WRK_GET_SERVICE_INFO_OK_DONE:
					{						
						FieldSocketInfoWRKGetServiceInfoOkDone();
					}
					break;
				case T_FC_INFO_WRK_GET_LEVEL_RANKER_LIST_OK:
					{
						FieldSocketInfoWRKGetLevelRankerListOk((MSG_FC_INFO_WRK_GET_LEVEL_RANKER_LIST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_WRK_GET_FAME_RANKER_LIST_OK:
					{
						FieldSocketInfoWRKGetFameRankerListOk((MSG_FC_INFO_WRK_GET_FAME_RANKER_LIST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_WRK_GET_PVP_RANKER_LIST_OK:
					{
						FieldSocketInfoWRKGetPVPRankerListOk((MSG_FC_INFO_WRK_GET_PVP_RANKER_LIST_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;				
				case T_FC_CHARACTER_CHANGE_NICKNAME_OK:
					{
						FieldSocketCharacterChangeNickNameOk((MSG_FC_CHARACTER_CHANGE_NICKNAME_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_INFO_WRK_GET_SELF_RANKING_OK:
					{
						FieldSocketInfoWrkGetSelfRankingOk((MSG_FC_INFO_WRK_GET_SELF_RANKING_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2009-02-13 by bhsohn  ŷ ý
					// 2009-03-10 by bhsohn nProtector CS ߰
				case T_FC_MOVE_NPROTECT_REQ_AUTH_DATA:
					{
						FieldSocketMoveNProtectReqAuthData((MSG_FC_MOVE_NPROTECT_REQ_AUTH_DATA*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2009-03-10 by bhsohn nProtector CS ߰
					// 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)
				case T_FC_MOVE_XTRAP_REQ_STEP:
					{
						FieldSocketMoveXTrapReqStep((MSG_FC_MOVE_XTRAP_REQ_STEP*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					//end 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)

					// 2009. 11. 03 by ckPark ± APEX Ӱ ۾
				case T_FC_MOVE_APEX_REQ_APEXDATA:
					{
						FieldSocketApexReqApexData( (MSG_FC_MOVE_APEX_REQ_APEXDATA*)(pPacket + SIZE_FIELD_TYPE_HEADER) );
					}
					break;
					// end 2009. 11. 03 by ckPark ± APEX Ӱ ۾

					// 2009. 10. 14 by jskim ī 
				case T_FC_CHARACTER_CHANGE_START_CITY_MAPINDEX_OK:
					{
						FieldSocketCharacterChangeStart((MSG_FC_CHARACTER_CHANGE_START_CITY_MAPINDEX_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					//end 2009. 10. 14 by jskim ī 
					// 2009. 11. 3 by jskim ĳ(κ/â Ȯ)  ߰ 
				case T_FC_CHARACTER_CHANGE_ADDED_INVENTORY_COUNT:
					{
						FieldSocketChangeAddedInventoryCount((MSG_FC_CHARACTER_CHANGE_ADDED_INVENTORY_COUNT*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					//end 2009. 11. 3 by jskim ĳ(κ/â Ȯ)  ߰ 
					// 2010. 03. 18 by jskim ͺ ī
				case T_FC_ITEM_UPDATE_TRANSFORMER_OK:
					{
						FieldSocketItemUpdateTransformerOk((MSG_FC_ITEM_UPDATE_TRANSFORMER_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					//end 2010. 03. 18 by jskim ͺ ī

				case T_FC_QUEST_INSERT_QUEST:
					{
						FieldSocketQuestInserQuest((MSG_FC_QUEST_INSERT_QUEST*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_QUEST_DELETE_QUEST:
					{
						FieldSocketQuestDeleteQuest((MSG_FC_QUEST_DELETE_QUEST*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					// end 2009-04-01 by bhsohn  ұ,  ʱȭ ý
					// 2010. 06. 08 by jskim Ȩ̾  ó
				case T_FC_ITEM_HOMEPREMIUM_INFO:
					{
						FieldSocketHomePremium((MSG_FC_ITEM_HOMEPREMIUM_INFO*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
					//end 2010. 06. 08 by jskim Ȩ̾  ó
					// 2010-06-15 by shcho&hslee ý -    ó
				case T_FC_ITEM_PET_HEADER:
					{

					}
					break;
				case T_FC_ITEM_PET_BASEDATA_OK:
					{
						//Լ ɹ ߰Ѵ.
						FieldSocketCurrentPetBaseData((MSG_FC_ITEM_PET_BASEDATA*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
//2011-10-06 by jhahn Ʈ  ý
// 				case T_FC_ITEM_PET_SKILLDATA_OK:
// 					{
// 						//Լ ɹ ߰Ѵ.
// 						FieldSocketCurrentPetSkillData((MSG_FC_ITEM_PET_SKILLDATA*)(pPacket + SIZE_FIELD_TYPE_HEADER));
// 					}
// 					break;
// 				case T_FC_ITEM_PET_SOCKETDATA_OK:
// 					{
// 						//Լ ɹ ߰Ѵ.
// 						FieldSocketCurrentPetSocketData((MSG_FC_ITEM_PET_SOCKETDATA*)(pPacket + SIZE_FIELD_TYPE_HEADER));
// 					}
// 					break;				  
                //2011-10-06 by jhahn Ʈ  ý
				case T_FC_ITEM_PET_DONE:
					{
						
					}
					break;
					// End 2010-06-15 by shcho&hslee ý -    ó
				
				// 2010-08-31 by shcho&&jskim,  ý 
				case T_FC_DISSOLVED_ITEM_OK:
					{
						FieldSocketDissolDissolutionPutItem((MSG_FC_DISSOLVED_SUCCESS_AND_FAILED*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// end 2010-08-31 by shcho&&jskim,  ý 
			
				// 2011-05-18 by jhahn, 3  ü 
				case T_FC_MONSTER_CHANGE_INDEX:
					{
  						FieldMonsterChangeOK((MSG_FC_MONSTER_CHANGE_INDEX*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// end 2011-05-18 by jhahn, 3  ü 
				
//2011-10-06 by jhahn Ʈ  ý					
				case T_FC_ITEM_PET_SET_SOCKET_OK:
					{
						FieldPetSetSocket((MSG_FC_ITEM_PET_SET_SOCKET_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));					
					}
					break;
				case T_FC_ITEM_PET_SET_KIT_SLOT_OK:
					{
						FieldPetSetKitSlot((MSG_FC_ITEM_PET_SET_KIT_SLOT_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));		
					}
					break;

				case T_FC_ITEM_PET_SET_AUTOSKILL_SLOT_OK:
					{
						FieldPetSetAutoSkillSlot((MSG_FC_ITEM_PET_SET_AUTOSKILL_SLOT_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));		
					}
					break;

				case T_FC_ITEM_PET_SET_NAME_OK:
					{
						FieldPetNameChangeOK((MSG_FC_ITEM_PET_SET_NAME_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				case T_FC_ITEM_PET_SET_EXP_RATIO_OK:
					{					
						FieldPetExpRationOK((MSG_FC_ITEM_PET_SET_EXP_RATIO_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;

				case T_FC_ITEM_PET_CHANGE_LEVEL:
					{					
						FieldPetLevelChangeOK((MSG_FC_ITEM_PET_CHANGE_LEVEL*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;

				case T_FC_ITEM_PET_CHANGE_EXP:				
					{					
						FieldPetExpChangeOK((MSG_FC_ITEM_PET_CHANGE_EXP*)(pPacket + SIZE_FIELD_TYPE_HEADER));						
					}
					break;
//end 2011-10-06 by jhahn Ʈ  ý				
				// 2011-05-30 by jhahn, 3  
				case T_FC_MONSTER_CINEMA_DELETE_NOTIFY:
					{
						FieldMonsterDeleteOK((MSG_FC_MONSTER_CINEMA_DELETE_NOTIFY*)(pPacket + SIZE_FIELD_TYPE_HEADER));						
					}
					break;
				// end 2011-05-30 by jhahn, 3  	
 					
 				// 2011-05-30 by jhahn, 3 ð 
				case T_FC_INFINITY_SET_LIMITTIME:
					{						
						FieldSocketInfinityResetTime((MSG_FC_INFINITY_SET_LIMITTIME*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// end 2011-05-30 by jhahn, 3 ð 		

				// 2011-05-31 by jhahn, 3ó׸ 
				case T_FC_INFINITY_MOVIE:
					{
						FieldInfinityCinemaOK((MSG_FC_INFINITY_MOVIE*)(pPacket + SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// end 2011-05-31 by jhahn, 3ó׸ 

				// START 2011-11-03 by shcho, yedang ˴ٿ 
				case T_FC_SHUTDOWNMINS_USER_ALTER:
					{
#ifdef SC_SHUT_DOWNMIN_SHCHO
						// ûҳ ȣ ǰϿ  16 ̸  00ú 06ñ  ̿ Ұմϴ.
						m_pChat->CreateChatChild( STRMSG_C_111109_0001, COLOR_CHAT_ALL, CHAT_TAB_SYSTEM );
#endif
					}
					break;
				case T_FC_SHUTDOWNMINS_USER_ENDGAME:
					{
						if(g_pD3dApp->GetArenaState() == ARENA_STATE_ARENA_GAMING )
						{			
							if( g_pD3dApp->m_ArenaSocketType == CAtumApplication::ARENASOCKET_ARENA )
							{
								g_pGameMain->m_pSystem->m_bQuitGameMessage = TRUE;
							}
							else if( g_pD3dApp->m_ArenaSocketType == CAtumApplication::ARENASOCKET_INFINITY )
							{
								g_pFieldWinSocket->SendMsg( T_FC_INFINITY_LEAVE, 0, 0 );
							}			
						}
						else
						{
							// normal exit
							g_pGameMain->m_pSystem->m_bQuitGameMessage = TRUE;
						}									
					}
					break;
				//  END 2011-11-03 by shcho, yedang ˴ٿ 
				// 2012-10-16 by bhsohn NPlay PC 
				case T_FC_CHARACTER_PCBANG_PREMIUN_APPLY:
					{
						FieldSocketCharacterPCBangPremiumApply((MSG_FC_CHARACTER_PCBANG_PREMIUN_APPLY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				// END 2012-10-16 by bhsohn NPlay PC 
				// 2012-10-17 by bhsohn XignCode۾		
				case T_FC_CHARACTER_XIGNCODE_S_ACK_PACKET:
					{
						FieldSocketCharacterXignCodeAckPacket((MSG_FC_CHARACTER_XIGNCODE_ACK_PACKET*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
					
				// end 2012-10-17 by bhsohn XignCode۾		
				case T_ERROR:
					{
						FieldSocketError((MSG_ERROR*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					}
					break;
				
				default:
					{
						FieldSocketInvalidPacket(pPacket);
					}
					break;
				}

				// 2007-07-10 by bhsohn  Ÿ   ó
				m_nPreComType = nType;

				if(pPacket != NULL)
				{
					SAFE_DELETE(pPacket);
				}
				// 2007-11-22 by bhsohn Ʒ ռ
//				if(m_pFieldWinSocket)
//				{
//					m_pFieldWinSocket->Read(&pPacket, len);// 2004-04-20 by dhkwon
//				}
				if(pFieldSocket)
				{																	
                    // 2010. 10. 05 by jskim ʷε    
					// 2009. 09. 10 by ckPark ʷε Ŷ ť ׾Ƶε 
					//if( m_pMapInitThread && m_pMapInitThread->m_bRunning )
					//{
					//	pFieldSocket->m_bSendNotify = FALSE;
					//	return 0;
					//}
					// end 2009. 09. 10 by ckPark ʷε Ŷ ť ׾Ƶε 
                    // end 2010. 10. 05 by jskim ʷε  

					pFieldSocket->Read(&pPacket, len);// 2004-04-20 by dhkwon
				}
				// end 2007-11-22 by bhsohn Ʒ ռ
			}
#ifdef _DEBUG
			g_nMoveCountPerPacket = nCharacterMoveCount;
#endif // _DEBUG_endif
		}
	}
	return 0;
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::OnRecvFieldSocketWS_CONNECTED( USHORT nConnect )
/// \brief		Field socket WS_CONNECTED ޾
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		USHORT nConnect :  
/// \return		
///////////////////////////////////////////////////////////////////////////////
// 2007-11-22 by bhsohn Ʒ ռ
//void CAtumApplication::OnRecvFieldSocketWS_CONNECTED( USHORT nConnect )
void CAtumApplication::OnRecvFieldSocketWS_CONNECTED( USHORT nConnect, CFieldWinSocket* pFieldSocket)
{
	FLOG("CAtumApplication::OnRecvFieldSocketWS_CONNECTED( USHORT nConnect )");
	if(nConnect)
	{
		if(m_bReconnectFieldServer)
		{
			m_bReconnectFieldServer = FALSE;
			MSG_FC_CHARACTER_CONNECT_GAMESTART sMsg;
			memset(&sMsg,0x00,sizeof(sMsg));
			char buffer[SIZE_MAX_PACKET];
			strcpy(sMsg.AccountName, m_strUserID);
			strcpy(sMsg.Password,m_strUserPassword);

			char	host[100];
			HOSTENT	*p;
			char	ip[SIZE_MAX_IPADDRESS];
			gethostname(host, 100);
			if(p = gethostbyname(host))
			{
				sprintf(ip, "%d.%d.%d.%d", (BYTE)p->h_addr_list[0][0], (BYTE)p->h_addr_list[0][1],(BYTE)p->h_addr_list[0][2], (BYTE)p->h_addr_list[0][3]);
				strncpy(sMsg.PrivateIP, ip, SIZE_MAX_IPADDRESS);
			}

			sMsg.AccountUniqueNumber = ((CShuttleChild *)m_pShuttleChild)->m_myShuttleInfo.AccountUniqueNumber;
			sMsg.CharacterUniqueNumber = ((CShuttleChild *)m_pShuttleChild)->m_myShuttleInfo.CharacterUniqueNumber;
			int nType = T_FC_CHARACTER_CONNECT_GAMESTART;
			memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
			memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
			m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));
		}
		else
		{
			// 2007-11-22 by bhsohn Ʒ ռ
			//SendFieldSocketConnectLogin();
			SendFieldSocketConnectLogin(pFieldSocket);		
		}
	}
	else
	{
		// 2007-11-22 by bhsohn Ʒ ռ
		//NetworkErrorMsgBox(STRMSG_C_SERVER_0007);//"ʵ弭    ˴ϴ."
		CFieldWinSocket* pArenaFieldSocket = m_pFieldWinSocket->GetArenaFieldWinSocket();
		if(pArenaFieldSocket && pArenaFieldSocket == pFieldSocket)
		{
			char szNotice[1024];
			memset(szNotice,0x00,1024);		
			sprintf(szNotice, STRMSG_C_080129_0201);		//"Ʒ   Ͽϴ."
			m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);

			g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_080129_0201, _MESSAGE);

			//  â ݴ´.
			g_pInterface->m_pCityBase->CloseCurrentEnterBuilding();

			// Ʒ ϰ 
			CloseArenaSocket();
		}
		else
		{
			NetworkErrorMsgBox(STRMSG_C_SERVER_0007);//"ʵ弭    ˴ϴ."
		}		
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::OnRecvFieldSocketWS_CLOSED(void)
/// \brief		Field socket WS_CLOSED ޾
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	m_dwGameState != _MAPLOAD ̸  ̴.
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::OnRecvFieldSocketWS_CLOSED(void)
{
	FLOG("CAtumApplication::OnRecvFieldSocketWS_CLOSED(void)");
//	if(!m_bReconnectFieldServer || !m_bOtherFieldWarping)
	if(m_dwGameState != _MAPLOAD)
	{
		NetworkErrorMsgBox(STRMSG_C_SERVER_0008);//"  Ǿϴ. Ŭ̾Ʈ մϴ. (FieldWinSocket WS_CLOSED)"
	}
#ifdef _DEBUG // by dhkwon 2003.7.4
	else
	{
		DBGOUT("case CFieldWinSocket::WS_CLOSED: close\n");
	}
#endif
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketConnectLoginOk(MSG_FC_CONNECT_LOGIN_OK *pMsg)
/// \brief		MSG_FC_CONNECT_LOGIN_OK
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketConnectLoginOk(MSG_FC_CONNECT_LOGIN_OK *pMsg)
{
	FLOG("CAtumApplication::FieldSocketConnectLoginOk(MSG_FC_CONNECT_LOGIN_OK *pMsg)");
	int i;
	// 2007-09-12 by bhsohn 2 ȣ ý 
	// ý  
	m_bIsUseSecondaryPasswordSystem = pMsg->bIsUseSecondaryPasswordSystem;
	// ȣ ߴ 
	m_bIsSetSecondaryPassword= pMsg->bIsSetSecondaryPassword;
	// end 2007-09-12 by bhsohn 2 ȣ ý 
	
	// 2008-07-07 by bhsohn 2 н Ȱȭ, κ ȿ 
	m_bSecondPassLock = FALSE;
	if(m_bIsUseSecondaryPasswordSystem)
	{
		//2 н ÿ  ־
		m_bSecondPassLock = m_bIsSetSecondaryPassword;
	}
	// end 2008-07-07 by bhsohn 2 н Ȱȭ, κ ȿ 

	m_accountUniqueNumber = pMsg->AccountUniqueNumber;
	g_pSelect->m_pSelectBack->m_bInitEffectItem = false;
	DeleteEffectList();
	if(pMsg->NumCharacters>0)
	{
		for(i=0;i<pMsg->NumCharacters;i++)
		{
//			m_pGUIGame->m_pSelect->SetUnitRenderInfo(i, pMsg->Characters[i]);
			if(m_pInterface && g_pSelect)
			{
				g_pSelect->SetUnitRenderInfo(i, pMsg->Characters[i]);
			}
		}

		MSG_FC_CHARACTER_GET_CHARACTER sMsg;
		memset(&sMsg,0x00,sizeof(sMsg));
		char buffer[SIZE_MAX_PACKET];
		sMsg.AccountUniqueNumber = m_accountUniqueNumber;
		sMsg.CharacterUniqueNumber = pMsg->Characters[0].CharacterUniqueNumber;

		// START 2011-11-03 by shcho, yedang ˴ٿ 
		sMsg.ShutDownMINS = pMsg->Characters[0].ShutDownMINS;
		// END 2011-11-03 by shcho, yedang ˴ٿ 

		int nType = T_FC_CHARACTER_GET_CHARACTER;
		memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
		memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
		m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));

		g_pD3dApp->m_bRequestEnable = FALSE;
	
	}
	strcpy(m_VOIPState.szVoIP1to1ServerIP, pMsg->VoIP1to1ServerIP);
	m_VOIPState.nVoIP1to1ServerPort = pMsg->VoIP1to1ServerPort;
	strcpy(m_VOIPState.szVoIPNtoNServerIP, pMsg->VoIPNtoNServerIP);
	m_VOIPState.nVoIPNtoNServerPort = pMsg->VoIPNtoNServerPort;

	if(m_pStageEffect) // 2004-06-07 by dhkwon , LOGO->INIT,SELECT
	{
		m_pStageEffect->SetEndWork(TRUE);
	}

	//  ð û // 2008-04-02 by dgwoo ð GameStartOK ûϴ α信 ó.
	g_pFieldWinSocket->SendMsg(T_FC_INFO_GET_SERVER_DATE_TIME, NULL, 0);
//	m_bInitializing = FALSE;
	DBGOUT("Field Server State : Login Done (MSG_FC_CONNECT_LOGIN_OK)\n");

	// 2008-08-11 by bhsohn ܵ  ǰԲ
	SetLoginOkInfo(pMsg);
	// end 2008-08-11 by bhsohn ܵ  ǰԲ

	// 2008-11-06 by bhsohn 콺 α  
	{
		// 콺 α  
		RefreshMouseMode();
	}
	SetTestServerConnect(pMsg->BIsTestServer); // 2012-11-28 by jhjang ׼   ó ߰
	SetDBSid(pMsg->DBNum);// 2012-11-28 by jhjang ׼   ó ߰
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketCharacterGetCharacterOk(MSG_FC_CHARACTER_GET_CHARACTER_OK * pMsg)
/// \brief		MSG_FC_CHARACTER_GET_CHARACTER_OK
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterGetCharacterOk(MSG_FC_CHARACTER_GET_CHARACTER_OK * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterGetCharacterOk(MSG_FC_CHARACTER_GET_CHARACTER_OK * pMsg)");


	if(m_pInterface && g_pSelect)
	{
		g_pSelect->SetUnitDetailInfo(pMsg->Character);
	}
//	if(m_dwGameState == _CREATE)
//	{
//		// ĳ Select ȭ ȯ   
//		m_pInterface->m_pSelect->m_pCreateMenu->m_bBlocking = FALSE;// createÿ Ű  Ǯش.
//		memcpy(&m_pShuttleChild->m_myShuttleInfo,&pMsg->Character,sizeof(CHARACTER));
//		memcpy(&m_pIMSocket->m_character,&pMsg->Character,sizeof(CHARACTER));
//		strcpy(((CChatMoveData *)m_pShuttleChild->m_pIDChat->m_pChild)->m_szString,pMsg->Character.CharacterName);
//		m_pInterface->InitMapLoadObjects();
//		m_pInterface->RestoreMapLoadObjects();
//		SAFE_DELETE(m_pMapInitThread );
//		m_pMapInitThread = new CMapInitThread();
//		m_pMapInitThread->CreateThread();
//		ChangeGameState(_MAPLOAD);
//		DBGOUT("ʵ弭 : â -->  ٷ , ʷε \n");
//	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketCharacterCreateOk(MSG_FC_CHARACTER_CREATE_OK* pMsg)
/// \brief		MSG_FC_CHARACTER_CREATE_OK
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterCreateOk(MSG_FC_CHARACTER_CREATE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterCreateOk(MSG_FC_CHARACTER_CREATE_OK* pMsg)");
	int nEmpty = g_pSelect->GetEmptySlot();
	FC_CONNECT_LOGIN_INFO info;
	memset(&info, 0x00, sizeof(FC_CONNECT_LOGIN_INFO));
	strcpy(info.CharacterName,pMsg->Character.CharacterName);
	info.CharacterUniqueNumber = pMsg->Character.CharacterUniqueNumber;
	info.Gender = pMsg->Character.Gender;
	info.PilotFace = pMsg->Character.PilotFace;
	info.Race = pMsg->Character.Race;
	info.UnitKind = pMsg->Character.UnitKind;
//	info.CharacterRenderInfo.RI_ProwOut = GetCreateUnitWeapon11(pMsg->Character.UnitKind);
//	info.CharacterRenderInfo.RI_Rear = GetCreateUnitEngine(pMsg->Character.UnitKind);
	info.CharacterRenderInfo = pMsg->CharacterRenderInfo;
	g_pSelect->SetUnitRenderInfo(nEmpty, info);

	MSG_FC_CHARACTER_GET_CHARACTER sMsg;
	memset(&sMsg,0x00,sizeof(sMsg));
	char buffer[SIZE_MAX_PACKET];
	sMsg.AccountUniqueNumber = m_accountUniqueNumber;
	sMsg.CharacterUniqueNumber = info.CharacterUniqueNumber;
	int nType = T_FC_CHARACTER_GET_CHARACTER;
	memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
	memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
	m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));
	
	g_pD3dApp->m_bRequestEnable = FALSE;

	g_pSelect->m_pSelectBack->ChangeMode(SELECT_MODE);
	g_pSelect->m_pSelectBack->m_bInitEffectItem = false;
	m_pInterface->m_pSelect->m_pCreateMenu->m_bBlocking = FALSE;
	DeleteEffectList();

	ChangeGameState(_SELECT);
	DBGOUT("Field Server State : Create Character (MSG_FC_CHARACTER_CREATE_OK), Try Game Start(T_FC_CHARACTER_GET_CHARACTER)\n");

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketCharacterDeleteOk(void)
/// \brief		DeleteOk
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterDeleteOk(void)
{
	FLOG("CAtumApplication::FieldSocketCharacterDeleteOk(void)");
	FC_CONNECT_LOGIN_INFO info;
	memset(&info, 0x00, sizeof(info));
	int select = g_pSelect->GetCurrentSelectIndex();
	g_pSelect->SetUnitRenderInfo(select, info);
	g_pSelect->SetUnitDetailInfoNULL(select);
	int valid = g_pSelect->GetValidIndex();
	if(valid>=0 && valid <3)
	{
		g_pSelect->MoveSelect(valid);
	}
	DeleteEffectList();
	g_pSelect->m_pSelectBack->m_bInitEffectItem = FALSE;
	
	g_pD3dApp->m_bRequestEnable = TRUE;
	g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;

	// 2007-09-12 by bhsohn 2 ȣ ý 
	g_pSelect->ShowSecutiryWnd(FALSE);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketCharacterGetOtherInfoOk(MSG_FC_CHARACTER_GET_OTHER_INFO_OK* pMsg)
/// \brief		MSG_FC_CHARACTER_GET_OTHER_INFO_OK
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	尡 ϰ, 幮     û
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterGetOtherInfoOk(MSG_FC_CHARACTER_GET_OTHER_INFO_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterGetOtherInfoOk(MSG_FC_CHARACTER_GET_OTHER_INFO_OK* pMsg)");
	if(m_dwGameState == _CITY)
	{
		DBGOUT("MSG_FC_CHARACTER_GET_OTHER_INFO_OK in _CITY \n");
		return;
	}
	if(m_pShuttleChild)
	{
		// 2006-01-10 by ispark, Enemy  ã´.
		CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->CharacterInfo.ClientIndex);
		if(itEnemy != m_pScene->m_mapEnemyList.end())
		{
			if(m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.ChannelIndex != pMsg->CharacterInfo.MapChannelIndex.ChannelIndex ||
				m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex != pMsg->CharacterInfo.MapChannelIndex.MapIndex)
			{
				//   ƴϹǷ .
//				DBGOUT("%s Enemy Other Map[%d(%d)]\n", 
//					itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName, 
//					pMsg->CharacterInfo.MapChannelIndex.MapIndex, 
//					m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex);
				
				itEnemy->second->m_bUsing = FALSE;
				return;
			}
		}
		// Enemy ų  ̶  Է
		m_pShuttleChild->CheckIndexList(pMsg);
		if(pMsg->CharacterInfo.GuildUniqueNumber != 0 )
		{
			m_pDatabase->GetOtherGuildInfo( pMsg->CharacterInfo.GuildUniqueNumber );
		}


	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCharacterGetOtherParamfactorOk(MSG_FC_CHARACTER_GET_OTHER_PARAMFACTOR_OK* pMsg)
/// \brief		MSG_FC_CHARACTER_GET_OTHER_PARAMFACTOR_OK
/// \author		dhkwon
/// \date		2004-07-31 ~ 2004-07-31
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterGetOtherParamfactorOk(MSG_FC_CHARACTER_GET_OTHER_PARAMFACTOR_OK* pMsg)
{
	CUnitData* pUnit = m_pScene->FindUnitDataByClientIndex( pMsg->ClientIndex );
	if(pUnit && pUnit->m_dwPartType == _ENEMY)
	{
		((CEnemyData*)pUnit)->SetItemParamFactor(pMsg);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketCharacterGetMonsterInfoOk(MSG_FC_CHARACTER_GET_MONSTER_INFO_OK* pMsg)
/// \brief		MSG_FC_CHARACTER_GET_MONSTER_INFO_OK
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterGetMonsterInfoOk(MSG_FC_CHARACTER_GET_MONSTER_INFO_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterGetMonsterInfoOk(MSG_FC_CHARACTER_GET_MONSTER_INFO_OK* pMsg)");
	if(pMsg->MonsterUnitKind < 2000000 || pMsg->MonsterUnitKind >= 3000000)
		return;
	if(m_pShuttleChild)
	{
		m_pShuttleChild->CheckIndexList(pMsg);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketCharacterGameStartOk(MSG_FC_CHARACTER_GAMESTART_OK * pMsg)
/// \brief		MSG_FC_CHARACTER_GAMESTART_OK
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterGameStartOk(MSG_FC_CHARACTER_GAMESTART_OK * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterGameStartOk(MSG_FC_CHARACTER_GAMESTART_OK * pMsg)");
	
	// 2007-11-20 by bhsohn ʷε ϴ  
	// ε忡 Ϸ
	{
		//   
		g_pShuttleChild->m_myShuttleInfo.MapChannelIndex = pMsg->MapInfo;
		m_pInterface->m_pMapLoad->MapLoadComplete();	
	}

	// 2008-04-01 by bhsohn ӽŸƮ ü ٵ   ް 
	{
		g_pShuttleChild->m_myShuttleInfo.BodyCondition = pMsg->BodyCondition;
		
		g_pShuttleChild->m_myShuttleInfo.CurrentHP	= pMsg->CurrentHP;
		m_pShuttleChild->m_fNextHP = pMsg->CurrentHP;

		g_pShuttleChild->m_myShuttleInfo.CurrentDP = pMsg->CurrentDP;
		m_pShuttleChild->m_fNextDP = pMsg->CurrentDP;

		g_pShuttleChild->m_myShuttleInfo.CurrentSP = pMsg->CurrentSP;
		m_pShuttleChild->m_fNextSP = pMsg->CurrentSP;

		g_pShuttleChild->m_myShuttleInfo.CurrentEP = pMsg->CurrentEP;		
		m_pShuttleChild->m_fNextEP = pMsg->CurrentEP;
	}
	// end 2008-04-01 by bhsohn ӽŸƮ ü ٵ   ް 

	// 2007-04-09 by bhsohn   ǥ  ó	
	wsprintf(m_strConnectSeverName, "%s[%s] %s", pMsg->GamePublisher, pMsg->MainORTestServerName, pMsg->ServerGroupName0);
	// 2007-07-16 by dgwoo      .

	m_bInputItemDone = FALSE;

	// 2006-06-07 by ispark,  ȭ  , ڸ  Ѵ.
	if(COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
	{
		m_bTestServer = FALSE;
	}
//////////////////////////////////////////////////////////////////////////
// 2006-05-08 by ispark, ʵ弭 ΰ ̻  ʿ ̴.
// 2006-05-08 by ispark, ׷  Ѱ ̹Ƿ ʿ䰡 .
//	strcpy(m_strFieldIPCurrent,pMsg->FieldServerIP);
//	int re = strcmp(m_strFieldIPCurrent,m_strFieldIP);
//	strcpy(m_strFieldIP,m_strFieldIPCurrent);
//	if(re != 0 || pMsg->FieldServerPort != m_nFieldPort)
//	{
//		m_bReconnectFieldServer = TRUE;
//		m_pFieldWinSocket->CloseSocket();
//		if(!m_pFieldWinSocket->Connect(m_strFieldIP,m_nFieldPort))
//		{
//			NetworkErrorMsgBox(STRMSG_C_SERVER_0009);//"    (Game Start OK Error)"
//			return;
//		}
//		Sleep(500);
//		DBGOUT("Field Server State : MSG_FC_CHARACTER_GAMESTART_OK, Try Connect Other Field Server(m_pFieldWinSocket->Connect(%s,%d))\n",m_strFieldIP,m_nFieldPort);
//	}
//	else
//////////////////////////////////////////////////////////////////////////
	{
		// 2005-07-21 by ispark
		// ĳ  Է (0 : (ü), ׿ܴ ĳ)
		if(pMsg->CharacterMode0 > 0)
			m_bCharacter = TRUE;
		else
			m_bCharacter = FALSE;		

		// 2007-11-20 by bhsohn ʷε ϴ  
		//InitCharacterGameStartOk( pMsg->PositionVector, pMsg->MapWeather );
		InitOnlyGameStartOk( pMsg->PositionVector, pMsg->MapWeather, FALSE );

		DBGOUT("Field Server State : MSG_FC_CHARACTER_GAMESTART_OK, init Game Infomation \n");
	}
	
	// 2007-01-07 by bhsohn   ȭ   ó
	m_bReadyFieldGameStartOk = TRUE;

	// ĳ  ӽ ̼â ̱
	if(g_pTutorial->GetTutorialEd() == TRUE)							// 2005-10-14 by ispark
	{
		// 2007-06-12 by bhsohn ̼ ̽ 
//		g_pGameMain->m_pMissionInfo->SetFirstMissionSelect(TRUE);
//		g_pGameMain->m_pMissionInfo->MissionProcFlag(TRUE);
		
		g_pGameMain->FirstUserShowMissionTreeWnd();

		// 2005-12-20 by ispark
		// ó ̼â ̴  Ʃ丮̳ ŵ  ̴. ׷Ƿ ̼â ̰  
		//  ˻ FALSE Ѵ.
		g_pTutorial->SetTutorialEd(FALSE);		
	}
	
	// PC üũ.
	if(pMsg->bMemberPCBang && g_pGameMain->m_pUnitInfoBar)
	{
		char szNotice[1024];
		memset(szNotice,0x00,1024);
		g_pGameMain->m_pUnitInfoBar->SetHappyHourEventIconPos();
		g_pGameMain->m_pUnitInfoBar->m_bMemberPCBang = TRUE;
		sprintf(szNotice, STRMSG_C_060830_0101);					//"PCԴϴ."
		m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	

	}


	//  ̼ ˻
	CQuest* pQuest = g_pQuestData->FindMapHideQuest( g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex );
	if(pQuest)
	{
		// 2007-06-12 by bhsohn ̼ ̽ 
//		g_pGameMain->m_pMissionInfo->SetPosMissionSearchStart(TRUE);
//		g_pGameMain->m_pMissionInfo->SetPosMissionInfo(pQuest);
		g_pGameMain->SetMissionPosMissionSearchStart(TRUE);
		g_pGameMain->SetMissionPosMissionInfo(pQuest);
	}

	// Ư  Ϸ ̼ ˻
	CQuest* pQuest2 = g_pQuestData->FindPosCompleteQuest( g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex );
	if(pQuest2)
	{
		// 2007-06-12 by bhsohn ̼ ̽ 
		//g_pGameMain->m_pMissionInfo->SetPosMissionComplete(TRUE);
		g_pGameMain->SetMissionPosMissionComplete(TRUE);
	}

	// 2007-12-27 by bhsohn  ۿ  κ 
	// 2005-03-28 by jschoi -    ٵ üũ ߰
//	if(	COMPARE_BODYCON_BIT(g_pShuttleChild->m_myShuttleInfo.BodyCondition,BODYCON_DEAD_MASK) )
//	{
//		if( !COMPARE_BODYCON_BIT(g_pShuttleChild->GetCurrentBodyCondition(),BODYCON_EXPLOSION_MASK) )
//		{
//			g_pShuttleChild->m_myShuttleInfo.CurrentHP = 0.0f;
//			g_pShuttleChild->m_pOrderTarget = NULL;
//			g_pShuttleChild->ChangeSingleBodyCondition(BODYCON_EXPLOSION_MASK);
//			g_pD3dApp->SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE1_MASK, FALSE );
//			g_pD3dApp->SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE2_MASK, FALSE );
//			g_pD3dApp->SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE3_MASK, TRUE );
//			g_pShuttleChild->ChangeUnitStateDead();
//			g_pShuttleChild->m_fCurrentTime = 186.0f;
//		}	
//	}
	// end 2007-12-27 by bhsohn  ۿ  κ 

	// 2007-07-11 by bhsohn omi üũ ߰
	SendOMICheckSum();

	// 2010. 03. 12 by ckPark Interface.tex üũ ߰
	SendInterfaceCheckSum();
	// end 2010. 03. 12 by ckPark Interface.tex üũ ߰
	
	SendAtmCheckSum();	// 2008-09-17 by bhsohn  ϸ üũ ߰

	SendQuestCheckSum();	// 2008-11-11 by bhsohn Ʈ CheckSum߰

	// 2007-11-01 by bhsohn  ƿ ̺Ʈ ó  
	//   ƿ û
	RequestHappyHourInfo();
	// 2007-11-28 by dgwoo  ӽ  ޽ ִ  û.
	// 2008-02-17 by bhsohn ʷε Ϸ Ͽ    ִ ̴.
	// ⼭ û ȴ´.
	//RequestNotifyMsg();	  

	// 2008-01-18 by bhsohn ߱ Ŭ̾Ʈ ״  ذ
	// 2009-01-12 by bhsohn Japan Working
#ifdef IS_USE_ONOFF_IME
//#ifdef LANGUAGE_CHINA
	// IME Main忡
	g_pD3dApp->m_inputkey.EnableIMEControl(FALSE);
#endif
	// end 2008-01-18 by bhsohn ߱ Ŭ̾Ʈ ״  ذ
	
	// 2007-11-22 by bhsohn Ʒ ռ
	// μ ClientIndex 
	SetMFSMyShuttleInfo(&m_pShuttleChild->m_myShuttleInfo);
	// end 2007-11-22 by bhsohn Ʒ ռ

	// 2008-08-11 by bhsohn ܵ  ǰԲ
	SetGameStartOkInfo(pMsg);	
	// end 2008-08-11 by bhsohn ܵ  ǰԲ

	// 2009. 11. 03 by ckPark ± APEX Ӱ ۾
#if defined( DEFINE_USE_GAMEGUARD_APEX )
	StartApexClient();
#endif
	// end 2009. 11. 03 by ckPark ± APEX Ӱ ۾

	// 2008-12-23 by bhsohn ̽ƽ ߰ û ó
	CJoyStickInput *pJoyStickInput = GetJoystickControl();
	if(pJoyStickInput && IsUseJoyStick())
	{
		char chBufTmp[256];
		memset(chBufTmp, 0x00, 256);
		wsprintf(chBufTmp, STRMSG_C_081223_0201);//"\\yƮѷ  ¿ 콺 ϱ ؼ  ° Ǿ մϴ."
		g_pD3dApp->m_pChat->CreateChatChild(chBufTmp,COLOR_SYSTEM);	
	}
	// end 2008-12-23 by bhsohn ̽ƽ ߰ û ó

	// 2007-11-20 by bhsohn ʷε ϴ  
	{
		//
		m_pInterface->m_pMapLoad->MapLoadComplete();

//		m_pInterface->InitMapLoadObjects();
//		m_pInterface->RestoreMapLoadObjects();
        // 2010. 10. 05 by jskim ʷε  
		//SAFE_DELETE(m_pMapInitThread );
		//m_pMapInitThread = new CMapInitThread();
		//m_pMapInitThread->CreateThread();
        m_pMaploading->SetMapStep(_MAP_LOADING_STEP1);
		// end 2010. 10. 05 by jskim ʷε  
	}
	// end 2007-11-20 by bhsohn ʷε ϴ  


	g_cCustomOptimizer.InitOptionSeting();
// 2012. 01. 04 by jskim  ŷ  
	// 2009-02-13 by bhsohn  ŷ ý
	{
		CWorldRankManager*	pWorldRankManager = g_pD3dApp->GetWorldRankManager();
		pWorldRankManager->RqInitWorldRank();
	}
	// end 2009-02-13 by bhsohn  ŷ ý
// end 2012. 01. 04 by jskim  ŷ  

	// 2012-12-21 by bhsohn Ʈ   ȵǴ  ذ
	g_pD3dApp->SetClientLogOff(FALSE);
	// END 2012-12-21 by bhsohn Ʈ   ȵǴ  ذ
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		// 2007-11-20 by bhsohn ʷε ϴ  
/// \date		2007-11-20 ~ 2007-11-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::InitOnlyGameStartOk(AVECTOR3 vPos, BitFlag16_t MapWeather, BOOL bArenaRestart)
{
	// 2007-11-20 by bhsohn ʷε ϴ  
	{
		m_bGameStartInfo = TRUE;
		m_struGameStartInfo.vPos = vPos;
		m_struGameStartInfo.MapWeather = MapWeather;
	}
	// end 2007-11-20 by bhsohn ʷε ϴ  

	FLOG("CAtumApplication::InitOnlyGameStartOk(AVECTOR3 vPos, BitFlag16_t MapWeather)");	
	g_pD3dDev->EvictManagedResources();
	
	DeleteEffectList();
	
	m_pCharacterChild->m_vPos = m_pShuttleChild->m_vPos = A2DX(vPos);
	m_vClientOldPos = m_pShuttleChild->m_vPos;
	m_pShuttleChild->m_myShuttleInfo.PositionVector = A2DX(vPos);//by dhkwon 2002.12.16
		
	m_dwSpeedHackTimer = 0;
	m_dwHackCheckTime = 0;	// 2005-12-21 by ispark
	m_dwMoveCheckTime = 0;	// 2006-01-10 by ispark

	if(m_pInterface)
	{
		// 2007-11-22 by bhsohn Ʒ ռ
		if(FALSE == bArenaRestart)
		{
			m_pInterface->InvalidateSelectObjects();
		}
		m_pInterface->InitGameObjects();
		m_pInterface->RestoreGameObjects();

		// 2008-02-27 by bhsohn Ʒ ̵ ä 
		if(bArenaRestart)
		{			
			// äâ  
			m_pInterface->RefreshChatInfo();
		}
		// end 2008-02-27 by bhsohn Ʒ ̵ ä 
		
		m_pInterface->InitCityObjects();
		m_pInterface->RestoreCityObjects();

		m_pShuttleChild->m_fNextHP = m_pShuttleChild->m_myShuttleInfo.CurrentHP;
		m_pShuttleChild->m_fNextEP = m_pShuttleChild->m_myShuttleInfo.CurrentEP;
		m_pShuttleChild->m_fNextSP = m_pShuttleChild->m_myShuttleInfo.CurrentSP;
		m_pShuttleChild->m_fNextDP = m_pShuttleChild->m_myShuttleInfo.CurrentDP;
		
		if(g_pGameMain->m_pUnitInfoBar)
		{
			g_pGameMain->m_pUnitInfoBar->UpdateAllGage();
		}		
		// 2007-11-22 by bhsohn Ʒ ռ
		m_pInterface->LoadCharacterFile(bArenaRestart);
	}	
		
//	m_pInterface->InvalidateMapLoadObjects();
//	m_pInterface->DeleteMapLoadObjects();
	m_pShuttleChild->SetShuttleData(0);
		
	m_pShuttleChild->InitMissileWarning();

	// 2009-02-02 by bhsohn ɼǿ 1Ī   ȵǴ  
	//m_pCamera->SetCamType(CAMERA_TYPE_NORMAL);
	m_pCamera->SetCamType( g_pSOption->sEyePt );
	
	// 2007-11-22 by bhsohn Ʒ ռ
	//if(FALSE == bArenaRestart)
	{
		char buf[256];
		//////////////////////////////////////////////////////////////////////
		// EXEFile param1 param2 param3 param4 param5 param6
		//   param1 : VoIP Agent WindowText  <== ex> ACEonlineVoIP_R
		//   param2 : VoIP Client WindowText <== ex> ACEonline_R
		//   param3 : PCCallAgent IP
		//   param4 : PCCallAgent Port
		//   param5 : VDServer IP
		//   param6 : VDServer Port
		wsprintf(buf,".\\Res-VoIP\\SCVoIP.exe %s %s %s %d %s %d",
			WINDOWTEXT_NAME_VOIP,
			WINDOWTEXT_NAME_CLIENT,
			m_VOIPState.szVoIP1to1ServerIP, m_VOIPState.nVoIP1to1ServerPort,
			m_VOIPState.szVoIPNtoNServerIP, m_VOIPState.nVoIPNtoNServerPort );
		DBGOUT( "******VOIP[%s]******\n", buf );
		WinExec( buf, SW_HIDE );
		DBGOUT( "********************\n" );
	}	
	
	
	// ʺƮ  ߴ üũ	
	//   û
	// 2008-04-08 by bhsohn ñ 
	//if(m_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber != 0 && m_bReadyToGetGuildInfo)
	if(m_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber != 0 && m_bReadyToGetGuildInfo && !bArenaRestart)
	{
		MSG_IC_GUILD_GET_GUILD_INFO sMsg;
		sMsg.GuildUniqueNumber = m_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber;
		m_pIMSocket->SendMsg( T_IC_GUILD_GET_GUILD_INFO, (char*)&sMsg, sizeof(sMsg));
		DBGOUT("Request T_IC_GUILD_GET_GUILD_INFO in GAME_START_OK \n");
	}
	
	////////////////////////////////////////////////////////////////////////////////////
	// ģ, ź Ʈ û
	DBGOUT("---------- FriendList RejectList Loading ----------\n");
	g_pIMSocket->WriteMessageType(T_IC_CHAT_FRIENDLIST_AND_REJECTLIST_LOADING);
	
	// ʺ  
	DBGOUT("---------- Help system ----------\n");
	g_pGameMain->InitHelpSystem(TRUE);
	// 2004-11-15 by jschoi
	DBGOUT("---------- SpeedHackTimer ----------\n");
	InitSpeedHackTimer();		// ǵŸ̸ ʱȭ
		
	//g_pInterface->m_pMapLoad->SendServerMapLoad();
	
	// 2006-07-05 by ispark, ̾  
	DBGOUT("---------- PrimiumCard Check ----------\n");
	if(GetPrimiumCardInfo()->nCardItemNum1)
	{
		m_pChat->CreateChatChild(STRMSG_C_CARD_0010,COLOR_ERROR);//"  Դϴ."
		char buf[MAX_PATH];
		wsprintf(buf,STRMSG_C_CARD_0011,GetPrimiumCardInfo()->atumTimeExpireTime1.GetLocalDateTimeString(string(),GetLanguageType(),TRUE));	//"ð : %s"
		m_pChat->CreateChatChild(buf,COLOR_ERROR);
	}
	
	DBGOUT("---------- Set Render MapNameImg ----------\n");
	g_pInterface->m_pMapLoad->SetRenderMapNameImg(TRUE);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		// 2007-11-20 by bhsohn ʷε ϴ  
/// \date		2007-11-20 ~ 2007-11-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::UpdateGameStartMapInfo()
{
	// 2008-01-24 by bhsohn Ŭ̾Ʈ   κ 
	// ʷε  ƽð ش.
	// ʷε ð  ɸ PC Tick ð 1 Ѱ ɸ Ǿ ذѴ.
	DBGOUT("CAtumApplication::UpdateGameStartMapInfo Update\n");
	m_dwLastestTickTime = timeGetTime();
	// end 2008-01-24 by bhsohn Ŭ̾Ʈ   κ 

	// 2008-11-06 by bhsohn 콺 α  
	RefreshMouseMode();

// 2012. 01. 04 by jskim  ŷ  
	if(FALSE == m_bGameStartInfo )
	{
		// 2009-02-13 by bhsohn  ŷ ý
		{
			CWorldRankManager*	pWorldRankManager = g_pD3dApp->GetWorldRankManager();
			pWorldRankManager->RqInitWorldRank();
		}
		// end 2009-02-13 by bhsohn  ŷ ý
		return;
	}
// end 2012. 01. 04 by jskim  ŷ  

	// 2007-11-22 by bhsohn Ʒ ռ
	// Ʒ  Step
	int nOldArenaStep = NextStepArenaState();	
	// end 2007-11-22 by bhsohn Ʒ ռ

	m_bGameStartInfo = FALSE;	
	
	if(m_pScene->m_byMapType == MAP_TYPE_CITY)
	{
		// 2008-01-18 by bhsohn ߱ Ŭ̾Ʈ ״  ذ
		//ChangeGameState(_CITY);		
		//   忡  ¸ ҷ Ѵ.
		ChangeGameState(_CITY,TRUE);		
		// end 2008-01-18 by bhsohn ߱ Ŭ̾Ʈ ״  ذ

		if(m_bCharacter)
		{
			m_pCharacterChild->InitCharacterData();
		}
		else
		{
			m_pShuttleChild->InitShuttleData();
		}
		SetFogLevel( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex, TRUE );
		m_pScene->m_byWeatherType = WEATHER_DEFAULT;
		m_pScene->SetupLights();
		
		SendFieldSocketCityGetBuildingList( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex );
				
		MSG_FC_MOVE_LANDING_DONE sMsg;
		sMsg.Position = MAP_TYPE_CITY_UNIT_POS;
		g_pFieldWinSocket->SendMsg( T_FC_MOVE_LANDING_DONE, (char*)&sMsg, sizeof(sMsg) );
		DBGOUT("T_FC_MOVE_LANDING_DONE\n");
		g_pShuttleChild->ChangeUnitState( _LANDED );
		g_pShuttleChild->ChangeSingleBodyCondition(BODYCON_LANDED_MASK);
		// 2007-01-02 by bhsohn A b+Enter  , ϸ    ó								
		if(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
		{
			// A   ʱȭ
			m_pShuttleChild->InitUnitStop();
		}				
		// end 2007-01-02 by bhsohn A b+Enter  , ϸ    ó
		
	}
	else
	{
		DBGOUT("---------- Change Game Start ----------\n");
		// 2008-01-18 by bhsohn ߱ Ŭ̾Ʈ ״  ذ
		//ChangeGameState(_GAME);
		//   忡  ¸ ҷ Ѵ.

		// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
		//ChangeGameState(_GAME, TRUE);

		// ǴƼ   ʷε ٷ  ʰ T_FC_INFINITY_ENTER  ʷε Ѵ
		if( !m_bInfinityMapload )
			ChangeGameState(_GAME, TRUE);
		// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý

		// end 2008-01-18 by bhsohn ߱ Ŭ̾Ʈ ״  ذ
		
		if(m_bCharacter)
		{
			m_pCharacterChild->InitCharacterData();
		}
		else
		{
			m_pShuttleChild->InitShuttleData();
		}
		SetFogLevel( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex, TRUE );
		//m_pScene->m_byWeatherType = MapWeather;
		m_pScene->m_byWeatherType = m_struGameStartInfo.MapWeather;
		m_pScene->m_bChangeWeather = TRUE;
		// ó׸
		if( g_pShuttleChild->InitCinemaCamera(PATTERN_CAMERA_GAME_START) == TRUE )
		{
			g_pShuttleChild->m_nEventType = EVENT_GAME_START;
			
			DBGOUT("---------- Change Warp Start ----------\n");
			g_pShuttleChild->ChangeUnitState( _WARP );
		}
	}
	
	{
		g_pInterface->m_pMapLoad->SendServerMapLoad();
	}

	// 2007-12-27 by bhsohn  ۿ  κ 	
	if(	COMPARE_BODYCON_BIT(g_pShuttleChild->m_myShuttleInfo.BodyCondition,BODYCON_DEAD_MASK) )
	{
		if( !COMPARE_BODYCON_BIT(g_pShuttleChild->GetCurrentBodyCondition(),BODYCON_EXPLOSION_MASK) )
		{
			g_pShuttleChild->m_myShuttleInfo.CurrentHP = 0.0f;
			g_pShuttleChild->m_pOrderTarget = NULL;
			g_pShuttleChild->ChangeSingleBodyCondition(BODYCON_EXPLOSION_MASK);
			g_pD3dApp->SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE1_MASK, FALSE );
			g_pD3dApp->SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE2_MASK, FALSE );
			g_pD3dApp->SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE3_MASK, TRUE );
			g_pShuttleChild->ChangeUnitStateDead();
			g_pShuttleChild->m_fCurrentTime = 186.0f;
		}	
	}
	// end 2007-12-27 by bhsohn  ۿ  κ 

	// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	// ǴƼ   ε ٷ  ʴ´. T_FC_INFINITY_ENTER Ҷ  
	if( !m_bInfinityMapload )
	// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	// ʰü 	
	{
		m_pInterface->InvalidateMapLoadObjects();
		m_pInterface->DeleteMapLoadObjects();
	}	

	// 2009-02-05 by bhsohn ī޶   ó
	if(m_bCharacter)
	{
		// ĳ ϶ ī޶  ʱȭ
		g_pCamera->SetCamDistance(CHARACTER_CAMERA_DISTANCE);		// ī޶ ʱ Ÿ
		g_pD3dApp->SetCamPosInit();
	}
	// end 2009-02-05 by bhsohn ī޶   ó

	// 2007-11-22 by bhsohn Ʒ ռ
	switch(nOldArenaStep)
	{
	case ARENA_STATE_ARENA_LOAD_GAME_INFO:
		{
			
			SendFCArenaCharacterGameStart();

			//  Ʒ ó  ´.
			// ׷Ƿ   ۽Ų.
			g_pShuttleChild->DeletePattern();
			g_pShuttleChild->PatternWarpOut(TRUE);	
		}
		break;
	case ARENA_STATE_ARENA_ARENA_TO_MAIN:
		{
			// Ʒ    .
			SendFCCharacterGameStartFromArenaToMainServer();
		}
		break;
	}		
	
	
	// end 2007-11-22 by bhsohn Ʒ ռ		  

	// 2008-02-17 by bhsohn ʷε Ϸ Ͽ    ִ ̴.
	{
		// ʷε Ϸ Ǿ.
		RequestNotifyMsg();		
	}
// 2012. 01. 04 by jskim  ŷ  
	// 2009-02-13 by bhsohn  ŷ ý
// 	{
// 		CWorldRankManager*	pWorldRankManager = g_pD3dApp->GetWorldRankManager();
// 		pWorldRankManager->RqInitWorldRank();
// 	}
// 	// end 2009-02-13 by bhsohn  ŷ ý
// end 2012. 01. 04 by jskim  ŷ  

	// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	//  ε   ǴƼ ƨ   ޼ ڽ ߰
	if( m_bAddInfinityRestartMessageBox )
	{
		g_pGameMain->m_pInfWindow->AddMsgBox( STRMSG_C_091103_0339, _Q_RETURN_TO_PROGRESS_INFINITY );
		m_bAddInfinityRestartMessageBox = FALSE;
	}
	// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
}

	
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::RequestHappyHourInfo()
/// \brief		//   ƿ û T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO
/// \author		// 2007-11-01 by bhsohn  ƿ ̺Ʈ ó  
/// \date		2007-11-01 ~ 2007-11-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::RequestHappyHourInfo()
{
	if(g_pGameMain && g_pGameMain->m_pUnitInfoBar)
	{
		//  ƿ  ʱȭ
		g_pGameMain->m_pUnitInfoBar->InitHappyHourInfo();
	}	
	m_pFieldWinSocket->SendMsg(T_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO, NULL, 0);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::RequestNotifyMsg()
/// \brief		 ӽ  ޽ ִ   û.
/// \author		dgwoo
/// \date		2007-11-28 ~ 2007-11-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::RequestNotifyMsg()
{
	m_pFieldWinSocket->SendMsg(T_FC_EVENT_NOTIFY_MSG_GET,NULL,0);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketCharacterConnectGameStartOk(MSG_FC_CHARACTER_CONNECT_GAMESTART_OK * pMsg)
/// \brief		MSG_FC_CHARACTER_CONNECT_GAMESTART_OK
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterConnectGameStartOk(MSG_FC_CHARACTER_CONNECT_GAMESTART_OK * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterConnectGameStartOk(MSG_FC_CHARACTER_CONNECT_GAMESTART_OK * pMsg)");
	m_pShuttleChild->m_myShuttleInfo.ClientIndex = pMsg->ClientIndex;

	InitCharacterGameStartOk( pMsg->PositionVector, pMsg->MapWeather );
	DBGOUT("Field Server State : MSG_FC_CHARACTER_CONNECT_GAMESTART_OK, Init Game Information\n");
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::InitCharacterGameStartOk(AVECTOR3 vPos, BitFlag16_t MapWeather)
/// \brief		FieldSocketCharacterGameStartOk, FieldSocketCharacterConnectGameStartOkԼ  κ
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	m_pShuttleChild->m_vPos ChangeGameState(_CITY|_GAME ؾ Ѵ.rendering object)
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::InitCharacterGameStartOk(AVECTOR3 vPos, BitFlag16_t MapWeather)
{
	FLOG("CAtumApplication::InitCharacterGameStartOk(AVECTOR3 vPos, BitFlag16_t MapWeather)");
	// 2005-01-04 by jschoi
//	g_pD3dDev->ResourceManagerDiscardBytes(0);
	g_pD3dDev->EvictManagedResources();

	DeleteEffectList();
	// 2005-07-21 by ispark
	m_pCharacterChild->m_vPos = m_pShuttleChild->m_vPos = A2DX(vPos);
	m_vClientOldPos = m_pShuttleChild->m_vPos;
	m_pShuttleChild->m_myShuttleInfo.PositionVector = A2DX(vPos);//by dhkwon 2002.12.16

//	m_dwLastTickTime = GetTickCount();
	m_dwSpeedHackTimer = 0;
	m_dwHackCheckTime = 0;	// 2005-12-21 by ispark
	m_dwMoveCheckTime = 0;	// 2006-01-10 by ispark

//	m_pShuttleChild->InitShuttleData();
	m_pInterface->InvalidateMapLoadObjects();
	m_pInterface->DeleteMapLoadObjects();
	m_pShuttleChild->SetShuttleData(0);
//	m_pScene->SetShuttleLandState(m_pShuttleChild);

	// 2006-02-13 by ispark
	m_pShuttleChild->InitMissileWarning();
	m_pCamera->SetCamType(CAMERA_TYPE_NORMAL);

	char buf[256];
	//////////////////////////////////////////////////////////////////////
	// EXEFile param1 param2 param3 param4 param5 param6
	//   param1 : VoIP Agent WindowText  <== ex> ACEonlineVoIP_R
	//   param2 : VoIP Client WindowText <== ex> ACEonline_R
	//   param3 : PCCallAgent IP
	//   param4 : PCCallAgent Port
	//   param5 : VDServer IP
	//   param6 : VDServer Port
	wsprintf(buf,".\\Res-VoIP\\SCVoIP.exe %s %s %s %d %s %d",
		WINDOWTEXT_NAME_VOIP,
		WINDOWTEXT_NAME_CLIENT,
		m_VOIPState.szVoIP1to1ServerIP, m_VOIPState.nVoIP1to1ServerPort,
		m_VOIPState.szVoIPNtoNServerIP, m_VOIPState.nVoIPNtoNServerPort );
	DBGOUT( "******VOIP[%s]******\n", buf );
	WinExec( buf, SW_HIDE );
	DBGOUT( "********************\n" );
	if(m_pInterface)
	{
		m_pInterface->InvalidateSelectObjects();
		m_pInterface->InitGameObjects();
		m_pInterface->RestoreGameObjects();
//		if( m_pScene->m_byMapType == MAP_TYPE_CITY )
//		{
			m_pInterface->InitCityObjects();
			m_pInterface->RestoreCityObjects();
//		}
		m_pShuttleChild->m_fNextHP = m_pShuttleChild->m_myShuttleInfo.CurrentHP;
		m_pShuttleChild->m_fNextEP = m_pShuttleChild->m_myShuttleInfo.CurrentEP;
		m_pShuttleChild->m_fNextSP = m_pShuttleChild->m_myShuttleInfo.CurrentSP;
		m_pShuttleChild->m_fNextDP = m_pShuttleChild->m_myShuttleInfo.CurrentDP;

		if(g_pGameMain->m_pUnitInfoBar)
		{
			g_pGameMain->m_pUnitInfoBar->UpdateAllGage();
		}

		// 2007-11-22 by bhsohn Ʒ ռ
		m_pInterface->LoadCharacterFile(TRUE);
	}
	if(m_pScene->m_byMapType == MAP_TYPE_CITY)
	{
		ChangeGameState(_CITY);
		// 2005-07-21 by ispark
		if(m_bCharacter)
		{
			m_pCharacterChild->InitCharacterData();
		}
		else
		{
	         m_pShuttleChild->InitShuttleData();
		}
		SetFogLevel( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex, TRUE );
		m_pScene->m_byWeatherType = WEATHER_DEFAULT;
		m_pScene->SetupLights();
//		m_pScene->m_bChangeWeather = TRUE;
		SendFieldSocketCityGetBuildingList( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex );
//		if (g_pShuttleChild->InitCinemaUnit(PATTERN_UNIT_CITY_IN) == TRUE) //  ۽ ÿ   
//		{
//			m_pSound->PlayD3DSound( SOUND_LANDING_IN_CITY, g_pShuttleChild->m_vPos );
//			g_pShuttleChild->ChangeUnitState( _LANDING );
//			g_pShuttleChild->ChangeSingleBodyCondition(BODYCON_LANDING_MASK);
//			CAppEffectData * pEffect = new CAppEffectData(RC_EFF_LANDING_TAKEOFF,MAP_TYPE_CITY_UNIT_POS);
//			m_pEffectList->AddChild(pEffect);
//		}
//		else
//		{

			MSG_FC_MOVE_LANDING_DONE sMsg;
			sMsg.Position = MAP_TYPE_CITY_UNIT_POS;
			g_pFieldWinSocket->SendMsg( T_FC_MOVE_LANDING_DONE, (char*)&sMsg, sizeof(sMsg) );
			DBGOUT("T_FC_MOVE_LANDING_DONE\n");
			g_pShuttleChild->ChangeUnitState( _LANDED );
			g_pShuttleChild->ChangeSingleBodyCondition(BODYCON_LANDED_MASK);
			// 2007-01-02 by bhsohn A b+Enter  , ϸ    ó								
			if(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
			{
				// A   ʱȭ
				m_pShuttleChild->InitUnitStop();
			}				
			// end 2007-01-02 by bhsohn A b+Enter  , ϸ    ó

//		}
	}
	else
	{
		DBGOUT("---------- Change Game Start ----------\n");
		ChangeGameState(_GAME);
		// 2005-07-21 by ispark
		if(m_bCharacter)
		{
			m_pCharacterChild->InitCharacterData();
		}
		else
		{
			m_pShuttleChild->InitShuttleData();
		}
		SetFogLevel( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex, TRUE );
		m_pScene->m_byWeatherType = MapWeather;
		m_pScene->m_bChangeWeather = TRUE;
		// ó׸
		if( g_pShuttleChild->InitCinemaCamera(PATTERN_CAMERA_GAME_START) == TRUE )
		{
			g_pShuttleChild->m_nEventType = EVENT_GAME_START;
//			g_pShuttleChild->m_bEventReady = TRUE;
//			g_pShuttleChild->m_fEventCheckTime = 2.0f;
			DBGOUT("---------- Change Warp Start ----------\n");
			g_pShuttleChild->ChangeUnitState( _WARP );
		}
	}

	// ʺƮ  ߴ üũ
//	if(m_pScene->m_byMapType == MAP_TYPE_TUTORIAL)
//		m_pShuttleChild->CheckBeginnerQuest();
	//   û
	if(m_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber != 0 && m_bReadyToGetGuildInfo)
	{
		MSG_IC_GUILD_GET_GUILD_INFO sMsg;
		sMsg.GuildUniqueNumber = m_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber;
		m_pIMSocket->SendMsg( T_IC_GUILD_GET_GUILD_INFO, (char*)&sMsg, sizeof(sMsg));
		DBGOUT("Request T_IC_GUILD_GET_GUILD_INFO in GAME_START_OK \n");
	}

	////////////////////////////////////////////////////////////////////////////////////
	// ģ, ź Ʈ û
	DBGOUT("---------- FriendList RejectList Loading ----------\n");
	g_pIMSocket->WriteMessageType(T_IC_CHAT_FRIENDLIST_AND_REJECTLIST_LOADING);

	// ʺ  
	DBGOUT("---------- Help system ----------\n");
	g_pGameMain->InitHelpSystem(TRUE);
	// 2004-11-15 by jschoi
	DBGOUT("---------- SpeedHackTimer ----------\n");
	InitSpeedHackTimer();		// ǵŸ̸ ʱȭ

	// 2007-04-05 by bhsohn ʷε, üũ ߰
	//g_pFieldWinSocket->WriteMessageType(T_FC_INFO_GET_CURRENT_MAP_INFO);
	g_pInterface->m_pMapLoad->SendServerMapLoad();

	// 2006-07-05 by ispark, ̾  
	DBGOUT("---------- PrimiumCard Check ----------\n");
	if(GetPrimiumCardInfo()->nCardItemNum1)
	{
		m_pChat->CreateChatChild(STRMSG_C_CARD_0010,COLOR_ERROR);//"  Դϴ."
		char buf[MAX_PATH];
		wsprintf(buf,STRMSG_C_CARD_0011,GetPrimiumCardInfo()->atumTimeExpireTime1.GetLocalDateTimeString(string(),GetLanguageType(),TRUE));	//"ð : %s"
		m_pChat->CreateChatChild(buf,COLOR_ERROR);
	}
//	else if(GetPrimiumCardInfo()->nCardItemNum1 == ITEM_NUM_CASH_SUPER_PREMIUM_CARD )
//	{
//		m_pChat->CreateChatChild(STRMSG_C_CARD_0012,COLOR_ERROR);//"  Դϴ."
//		char buf[MAX_PATH];
//		wsprintf(buf,STRMSG_C_CARD_0011,GetPrimiumCardInfo()->atumTimeExpireTime1.GetDateTimeString(STRNBUF(SIZE_MAX_SQL_DATETIME_STRING),TRUE));	
//		m_pChat->CreateChatChild(buf,COLOR_ERROR);
//	}	
	DBGOUT("---------- Set Render MapNameImg ----------\n");
	g_pInterface->m_pMapLoad->SetRenderMapNameImg(TRUE);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketCharacterGameEndOk(MSG_FC_CHARACTER_GAMEEND_OK * pMsg)
/// \brief		MSG_FC_CHARACTER_GAMEEND_OK
/// \author		dhkwon
/// \date		2004-03-17 ~ 2004-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
// 2008-03-10 by bhsohn Ʒ ȯ Ż ó
//VOID CAtumApplication::FieldSocketCharacterGameEndOk(MSG_FC_CHARACTER_GAMEEND_OK * pMsg)
VOID CAtumApplication::FieldSocketCharacterGameEndOk(UINT nSocketNotifyType, MSG_FC_CHARACTER_GAMEEND_OK * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterGameEndOk(MSG_FC_CHARACTER_GAMEEND_OK * pMsg)");

	// 2007-11-22 by bhsohn Ʒ ռ
	CHARACTER* pMainInfo = g_pD3dApp->GetMFSMyShuttleInfo();
	ClientIndex_t myClientIndex = pMainInfo->ClientIndex;	
	// 2008-03-10 by bhsohn Ʒ ȯ Ż ó
	if(WM_PACKET_ARENA_NOTIFY == nSocketNotifyType)
	{		
		// Ʒʵ弭  ص尡 Դ.
		CHARACTER*	pArenaCharacter = g_pD3dApp->GetArenaCharacterInfo();
		myClientIndex = pArenaCharacter->ClientIndex;
	}
	// end 2008-03-10 by bhsohn Ʒ ȯ Ż ó

	//if(pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	if(pMsg->ClientIndex == myClientIndex)
	{
		// 2008-10-30 by bhsohn   ̵ ƿ ý 
		EnterLock(TRUE);	// FALSE :Lock  TRUE : UnLock	
		// end 2008-10-30 by bhsohn   ̵ ƿ ý 

		g_pD3dApp->m_bCharacter = FALSE;
		m_pQuestData->Init();
		if(m_pInterface )
		{
			g_pSelect->m_pSelectBack->ChangeMode(SELECT_MODE);
			m_pInterface->InvalidateCityObjects();
			m_pInterface->DeleteCityObjects();
			m_pInterface->InvalidateGameObjects();
			// 2007-11-22 by bhsohn Ʒ ռ
			//m_pInterface->DeleteGameObjects();
			
			g_pDatabase->InvalidateDeviceObjects();
			m_pInterface->DeleteGameObjects(FALSE);
			g_pDatabase->DeleteGuildInfo();

			m_pImageList->DeleteDeviceObjects();
			m_pInterface->ResetMapNameList();
			if(!m_bClientQuit)
			{
				m_pInterface->RestoreSelectObjects();
				g_pSelect->GameEnd();
			}
		}
		// 2005-01-04 by jschoi
//		g_pD3dDev->ResourceManagerDiscardBytes(0);
		g_pD3dDev->EvictManagedResources();

		// ε Ʈ ũ  Ѵ.
		// ShuttleChild()  ִ    ϰ .
		// ShuttleChild .
		if(m_pShuttleChild)
		{
//			g_pStoreData->SendFieldSocketItemIndexInfo();
			m_pShuttleChild->InvalidateDeviceObjects();
//			m_pShuttleChild->InvalidateChat();
			m_pShuttleChild->DeleteDeviceObjects();
			SAFE_DELETE(m_pShuttleChild);
		}
		// 2005-07-25 by ispark
		// ĳ
		if(m_pCharacterChild)
		{
			m_pCharacterChild->InvalidateDeviceObjects();
			m_pCharacterChild->DeleteDeviceObjects();
			SAFE_DELETE(m_pCharacterChild);
		}
		// Chat  .
		CAtumNode* pChat = (CAtumNode *)m_pChat->m_pChild;
		while(pChat)
		{
			pChat->m_bUsing = FALSE;
			pChat = pChat->m_pNext;
		}
		m_pChat->Tick();
		// Effect(App)  .
		// Effect(ZEnableEffect)  .
		m_pEffectRender->m_vecZEnableEffect.clear();
		
		EnterCriticalSection(&m_cs);
		m_pUnitRender->InvalidateDeviceObjects();
		m_pUnitRender->DeleteDeviceObjects();
		m_pUnitRender->InitDeviceObjects();
		m_pUnitRender->RestoreDeviceObjects();
		if(m_pScene)
		{
			m_pScene->InvalidateRes();
			m_pScene->DeleteRes();
		}
		DeleteEffectList();
		m_pEffectList->Tick();
		// Ʈ  ؾ Ѵ. ٸ ̳ 
		//   ۷  
		//   ֱ ̴.
		LeaveCriticalSection(&m_cs);
		if(!m_bClientQuit)
		{
			g_pSelect->m_pSelectBack->m_bInitEffectItem = false;
//			ChangeGameState(_SELECT); //   FrameMove ű
			m_pShuttleChild = new CShuttleChild();
			m_pShuttleChild->InitDeviceObjects();
//			m_pShuttleChild->RestoreChat();
			m_pShuttleChild->RestoreDeviceObjects();
			// 2005-07-25 by ispark
			// ĳ
			m_pCharacterChild = new CCharacterChild();
			m_pCharacterChild->InitDeviceObjects();
			m_pCharacterChild->RestoreDeviceObjects();
			
			// 2007-11-20 by bhsohn ʷε ϴ  
			//m_pInterface->m_pMapLoad->m_bLoginChat = IM_SERVER_STATE_NOT_LOGIN;
			m_pInterface->m_pMapLoad->SetLoginChatMode(IM_SERVER_STATE_NOT_LOGIN);
			DBGOUT("IM Server State : Change Not Ready --> Receive MSG_FC_CHARACTER_GAMEEND_OK, Move select Window, m_bLoginChat = IM_SERVER_STATE_NOT_LOGIN)\n");
		}
//		if(m_VOIPState.nVOIPState != _VOIP_NOTLOGIN)
//		{
			COPYDATASTRUCT	copyData;
			memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
			AV_MSG_WM_COPYDATA voIP(_1to1Call, AV_MT_CLIENT_END, 0);
			copyData.dwData = (DWORD)voIP;
//			copyData.dwData = MAKELONG(AV_MT_CLIENT_END, 0);
			copyData.lpData = NULL;
			copyData.cbData = 0;
			::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)GetHwnd(), (LPARAM)&copyData);
			m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
//		}

		CleanText();
		m_bReadyToGetGuildInfo = FALSE;
		// 2007-01-07 by bhsohn   ȭ   ó
		m_bReadyFieldGameStartOk = FALSE;

		if(m_bClientQuit ) // 2004-06-07 by dhkwon , WAITING->ENDGAME,SELECT
		{
			if(m_pStageEffect)
			{
				m_pStageEffect->SetEndWork(TRUE);
			}
		}
		else
		{
			ChangeGameState(_SELECT );

			// 2007-11-22 by bhsohn Ʒ ռ
			// Ʈ ȭ  Ʒ ϰ  
			CloseArenaSocket();
		}

	}
	else
	{
		// Ÿ ĳ ó
		if(pMsg->ClientIndex < 10000)
		{
			// 2007-06-13 by bhsohn ޸  
			//   
			m_pScene->DeleteRenderEnemy(pMsg->ClientIndex);

			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				if(	m_pShuttleChild &&
					m_pShuttleChild->m_pOrderTarget && 
					m_pShuttleChild->m_pOrderTarget == itEnemy->second)
					m_pShuttleChild->m_pOrderTarget = NULL;
				//  ĳ ͵(̷ )
				// 2006-08-03 by ispark,  λ ̿  ݴ´.
				if(m_pCharacterChild->m_ShopEnemyClientIndex == pMsg->ClientIndex)
				{
					m_pInterface->ReadyCloseBazaarShop(TRUE);
					m_pChat->CreateChatChild(STRMSG_C_060801_0000, COLOR_ERROR);	// "λ  Ǿϴ."
				}
				// 2007-04-03 by dgwoo    ó.
				if(itEnemy->second->m_infoCharacter.CharacterInfo.ClientIndex == g_pShuttleChild->m_stObserve.ClientIndex)
				{
					g_pShuttleChild->ObserveCancelUpdateInfo();
					g_pShuttleChild->ObserveEnd();
				}
				m_pScene->DeleteFieldItemOfUnitData( itEnemy->second );
				m_pScene->DeleteToBlockData(itEnemy->second);
				SAFE_DELETE(itEnemy->second);
				m_pScene->m_mapEnemyList.erase(itEnemy);
//				if(itEnemy->second->m_nPartyID == 0)
//				{
//					SAFE_DELETE(itEnemy->second);
//					m_pScene->m_mapEnemyList.erase(itEnemy);
//				}
//				else
//				{
//					itEnemy->second->m_bIsRender = FALSE;
////					itEnemy->second->m_infoParty.bPartyType = _PARTYRESTARTMEMBER;
//					itEnemy->second->m_infoCharacter.ClientIndex = INVALID_CLIENT_INDEX;
//					itEnemy->second->DeleteItemPoint();
//					ChangeEnemyIndexForParty(itEnemy->first,itEnemy->second);
//				}
			}
		}
		else
		{
			//  ó
			CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->ClientIndex);
			if(itMonster != m_pScene->m_mapMonsterList.end())
			{
				m_pScene->DeleteToBlockData(itMonster->second);
//				if(m_pShuttleChild->m_pOrderTarget && m_pShuttleChild->m_pOrderTarget == itMonster->second)
//					m_pShuttleChild->m_pOrderTarget = NULL;
				SAFE_DELETE(itMonster->second);
				m_pScene->m_mapMonsterList.erase(itMonster);
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMoveOk( MSG_FC_MOVE_OK* pMsg)
/// \brief		MSG_FC_MOVE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMoveOk( MSG_FC_MOVE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMoveOk( MSG_FC_MOVE_OK* pMsg)");
#ifdef _DEBUG
	static int nMoveCount=0;
 	nMoveCount++;
	if(g_fMoveCountFrame>1.0f)
	{
		g_fMoveCountFrame = 0.0f;
		g_nMoveCountPerRate = nMoveCount;
		nMoveCount = 0;
	}
#endif // _DEBUG_endif
	if(m_dwGameState == _GAME || m_dwGameState == _SHOP)
	{
		if(m_pShuttleChild)
			m_pShuttleChild->CheckMove(pMsg);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMonsterMoveOk(MSG_FC_MONSTER_MOVE_OK* pMsg)
/// \brief		MSG_FC_MONSTER_MOVE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMonsterMoveOk(MSG_FC_MONSTER_MOVE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMonsterMoveOk(MSG_FC_MONSTER_MOVE_OK* pMsg)");
	if(!(m_dwGameState == _GAME || m_dwGameState == _SHOP))
	{
		return ;
	}
	CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);
	if(itMonster != m_pScene->m_mapMonsterList.end())
	{
		itMonster->second->SetMonPosition(pMsg);
	}
	else
	{
		// Ʈ  Ŭ̾Ʈ  û
//		if(!m_pShuttleChild->m_bGetOtherInfo)
//		{
//			DBGOUT("MONSTER[%d] MONSTER_MOVE_OK Distance[%d]\n",pMsg->ClientIndex,
//					(int)Distance3DTo2D(g_pShuttleChild->m_vPos, A2DX(pMsg->PositionVector)));
//			m_pShuttleChild->m_bGetOtherInfo = TRUE;
			m_pShuttleChild->m_fGetOtherInfoCheckTime = 0.5f;
			m_pShuttleChild->m_nGetOtherIndex = pMsg->MonsterIndex;

			// 2006-06-15 by ispark, ð Ŷ   
//			MSG_FC_CHARACTER_GET_OTHER_INFO sMsg;
//			memset(&sMsg,0x00,sizeof(sMsg));
//			sMsg.ClientIndex = pMsg->MonsterIndex;
//			m_pFieldWinSocket->SendMsg( T_FC_CHARACTER_GET_OTHER_INFO, (char*)&sMsg, sizeof(sMsg) );
//		}
	
			SetClientIndexDataByVector(m_vecCharacterOtherInfo, pMsg->MonsterIndex);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::SendFieldSocketConnectLogin()
/// \brief		MSG_FC_CONNECT_LOGIN 
/// \author		dhkwon
/// \date		2004-06-03 ~ 2004-06-03
/// \warning	WS_CONNECT Ŀ 
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
// 2007-11-22 by bhsohn Ʒ ռ
//VOID CAtumApplication::SendFieldSocketConnectLogin()
VOID CAtumApplication::SendFieldSocketConnectLogin(CFieldWinSocket* pFieldSocket)
{
	MSG_FC_CONNECT_LOGIN sMsg;
	memset(&sMsg,0x00,sizeof(sMsg));
	strcpy(sMsg.AccountName, m_strUserID);
	strcpy(sMsg.Password, m_strUserPassword);
	char	host[100];
	HOSTENT	*p;
	char	ip[SIZE_MAX_IPADDRESS];
	gethostname(host, 100);
	if(p = gethostbyname(host))
	{
		sprintf(ip, "%d.%d.%d.%d", (BYTE)p->h_addr_list[0][0], 
			(BYTE)p->h_addr_list[0][1], (BYTE)p->h_addr_list[0][2], (BYTE)p->h_addr_list[0][3]);
		strncpy(sMsg.PrivateIP, ip, SIZE_MAX_IPADDRESS);
	}	
#ifdef _DEBUG	

	// 2010. 01. 18 by ckPark д 繫 IP߰
// 	if( strncmp(sMsg.PrivateIP, MASANG_PREFIX_IP1, 11) != 0 &&		// 2007-01-03 by dgwoo ȸ(͹̳) Ǻ.
// 		strncmp(sMsg.PrivateIP, "210.93.214", 10) != 0 &&
// 		strncmp(sMsg.PrivateIP, "61.37.75.140", 12) != 0 &&
// 		strncmp(sMsg.PrivateIP, "211.215.163", 11) != 0 &&
// 		strncmp(sMsg.PrivateIP, "172.20.105", 10) != 0 &&
// 		strncmp(sMsg.PrivateIP, "172.20.2.117", 12) != 0 &&	// 2005-07-01 by ispark,  IP߰
// 		strncmp(sMsg.PrivateIP, "203.252.180", 11) != 0)	// 2006-02-10 by ispark, Ǵ

	if( !IS_MASANG_IP( sMsg.PrivateIP ) )
	// end 2010. 01. 18 by ckPark д 繫 IP߰
	{
		m_pFieldWinSocket->CloseSocket();
		NetworkErrorMsgBox( STRMSG_C_SERVER_0010 );//"α׷  "
		return;
	}
#endif
	// 2007-11-22 by bhsohn Ʒ ռ	
	//m_pFieldWinSocket->SendMsg(T_FC_CONNECT_LOGIN, (char*)&sMsg, sizeof(sMsg));
	CFieldWinSocket* pArenaFieldSocket = m_pFieldWinSocket->GetArenaFieldWinSocket();
	int nMsgType = T_FC_CONNECT_LOGIN;
	if(pArenaFieldSocket &&  pFieldSocket == pArenaFieldSocket)
	{
		SendArenaLoginOk();		
	}	
	else
	{
		m_pFieldWinSocket->SendMsg(nMsgType, (char*)&sMsg, sizeof(sMsg));
	}	
	
	
	DBGOUT("Send MSG_FC_CONNECT_LOGIN(%s, %s)\n", m_strUserID, sMsg.PrivateIP );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::SendFieldSocketCityGetBuildingList( MAP_CHANNEL_INDEX mapChannelIndex )
/// \brief		ÿ Խ   Ʈ ûѴ.
/// \author		dhkwon
/// \date		2004-04-12 ~ 2004-04-12
/// \warning	ӽ۽(InitCharacterGameStartOk), Ϸ(CINFMapLoad::Tick())Լ ȣѴ.
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::SendFieldSocketCityGetBuildingList( MAP_CHANNEL_INDEX mapChannelIndex )
{
	FLOG("CAtumApplication::SendFieldSocketCityGetBuildingList( MAP_CHANNEL_INDEX mapChannelIndex )");
	DBGOUT("Request City Shop List [index:%d][channel:%d]\n",mapChannelIndex.MapIndex, mapChannelIndex.ChannelIndex);
	MSG_FC_CITY_GET_BUILDING_LIST sMsg;
	sMsg.MapChannelIndex = mapChannelIndex;
	m_pFieldWinSocket->SendMsg( T_FC_CITY_GET_BUILDING_LIST, (char*)&sMsg, sizeof(sMsg) );

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::SendFieldSocketGetShopWarpTargetMapList( MAP_CHANNEL_INDEX mapChannelIndex )
/// \brief		 Խ  Ʈ ûѴ.
/// \author		dhkwon
/// \date		2004-04-12 ~ 2004-04-12
/// \warning	  Ʈ   ûѴ.(FieldSocketCityGetBuildingListOk)
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::SendFieldSocketGetShopWarpTargetMapList( MAP_CHANNEL_INDEX mapChannelIndex )
{
	FLOG("CAtumApplication::SendFieldSocketGetShopWarpTargetMapList( MAP_CHANNEL_INDEX mapChannelIndex )");
	DBGOUT("Request City Warp Target List [index:%d][channel:%d]\n",mapChannelIndex.MapIndex, mapChannelIndex.ChannelIndex);
	MSG_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST sMsg;
	sMsg.MapChannelIndex = mapChannelIndex;
	m_pFieldWinSocket->SendMsg( T_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST, (char*)&sMsg, sizeof(sMsg) );

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::SendFieldSocketChangeCharacterBodyCondition(BodyCond_t hySingleBodyCondition, BOOL bSet)
/// \brief		FieldSocketCharacterChangeCurrentHPDPSPEP,FieldSocketCharacterChangeCurrentHP Bodyconditionü 
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		BodyCond_t hySingleBodyCondition, BOOL bSet:TRUE ٵ ߵϰ, FALSE ߵ Ѵ.
///				 ν  ϸ ȵȴ.
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::SendFieldSocketChangeCharacterBodyCondition(BodyCond_t hySingleBodyCondition, BOOL bSet)
{
	FLOG("CAtumApplication::SendFieldSocketChangeCharacterBodyCondition(BodyCond_t hySingleBodyCondition, BOOL bSet)");
	// [bSet=TRUE, COMPARE=FALSE : new] [bSet=FALSE, COMPARE=TRUE : delete]
	if(bSet == !COMPARE_BODYCON_BIT(m_pShuttleChild->GetCurrentBodyCondition(),hySingleBodyCondition))
	{
		MSG_FC_CHARACTER_CHANGE_BODYCONDITION sMsg;
		sMsg.ClientIndex = m_pShuttleChild->m_myShuttleInfo.ClientIndex;
		sMsg.BodyCondition = bSet ? (hySingleBodyCondition|BODYCON_SET_OR_CLEAR_MASK) : hySingleBodyCondition;
		m_pShuttleChild->TurnSingleBodyCondition(hySingleBodyCondition, bSet);
		m_pFieldWinSocket->SendMsg( T_FC_CHARACTER_CHANGE_BODYCONDITION, (char*)&sMsg, sizeof(sMsg) );
	}
}

VOID CAtumApplication::FieldSocketCharacterChangeStatus(MSG_FC_CHARACTER_CHANGE_STATUS* pMsg)
{
	if(pMsg->ClientIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		g_pShuttleChild->m_myShuttleInfo.Status = pMsg->Status;
		if(m_pEffectList)
		{
			CAppEffectData *pData = NULL;
			if(IS_BT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
				pData = new CAppEffectData(m_pShuttleChild,RC_EFF_LEVELUP_BT,m_pShuttleChild->m_vPos);
			else if(IS_OT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
				pData = new CAppEffectData(m_pShuttleChild,RC_EFF_LEVELUP_OT,m_pShuttleChild->m_vPos);
			else if(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
				pData = new CAppEffectData(m_pShuttleChild,RC_EFF_LEVELUP_DT,m_pShuttleChild->m_vPos);
			else if(IS_ST(m_pShuttleChild->m_myShuttleInfo.UnitKind))
				pData = new CAppEffectData(m_pShuttleChild,RC_EFF_LEVELUP_ST,m_pShuttleChild->m_vPos);
			if(pData)
			{
				pData = (CAppEffectData *)m_pEffectList->AddChild(pData);
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeHPDPSPEP(MSG_FC_CHARACTER_CHANGE_HPDPSPEP * pMsg)
/// \brief		ÿ HP, DP, SP, EP ȭ
/// \author		dhkwon
/// \date		2004-06-23 ~ 2004-06-23
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeHPDPSPEP(MSG_FC_CHARACTER_CHANGE_HPDPSPEP * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeCurrentHPDPSPEP(MSG_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP * pMsg)");
	ASSERT_ASSERT(m_pShuttleChild && pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex);
	g_pShuttleChild->m_myShuttleInfo.HP = pMsg->HP;
	g_pShuttleChild->m_myShuttleInfo.DP = pMsg->DP;
	g_pShuttleChild->m_myShuttleInfo.SP = pMsg->SP;
	g_pShuttleChild->m_myShuttleInfo.EP = pMsg->EP;
	CharacterChangeCurrentHPAndDamageBodyCondition( pMsg->CurrentHP );
	CharacterChangeCurrentDP( pMsg->CurrentDP );
	CharacterChangeCurrentSP( pMsg->CurrentSP );
	CharacterChangeCurrentEP( pMsg->CurrentEP );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeCurrentHPDPSPEP(MSG_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP * pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeCurrentHPDPSPEP(MSG_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeCurrentHPDPSPEP(MSG_FC_CHARACTER_CHANGE_CURRENTHPDPSPEP * pMsg)");
	ASSERT_ASSERT(m_pShuttleChild && pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex);
	CharacterChangeCurrentHPAndDamageBodyCondition( pMsg->CurrentHP );
	CharacterChangeCurrentDP( pMsg->CurrentDP );
	CharacterChangeCurrentSP( pMsg->CurrentSP );
	CharacterChangeCurrentEP( pMsg->CurrentEP );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeCurrentHP(MSG_FC_CHARACTER_CHANGE_CURRENTHP * pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_CURRENTHP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeCurrentHP(MSG_FC_CHARACTER_CHANGE_CURRENTHP * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeCurrentHP(MSG_FC_CHARACTER_CHANGE_CURRENTHP * pMsg)");
	ASSERT_ASSERT(m_pShuttleChild && pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex);
	CharacterChangeCurrentHPAndDamageBodyCondition(pMsg->CurrentHP);

	// 2010-06-15 by shcho&hslee ý - ۷ 	
	if( g_pStoreData->FindItemInInventoryByWindowPos( POS_PET ) &&
		pMsg->CurrentHP / m_pShuttleChild->m_myShuttleInfo.HP < 
		g_pInterface->m_pINFOpMain->GetOpInfo()->GetOperatorAction(1,3)->spOperatorInfo->FunctionValue )
	{
		g_pInterface->m_pINFOpMain->GetOpInfo()->SetOperatorAction(1,3);
	}
	// end 2010-06-15 by shcho&hslee ý - ۷ 
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::CharacterChangeCurrentHPAndDamageBodyCondition(float CurrentHP)
/// \brief		FieldSocketCharacterChangeCurrentHP,FieldSocketCharacterChangeCurrentHPDPSPEPԼ HP Bodycondition
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::CharacterChangeCurrentHPAndDamageBodyCondition(float fCurrentHP)
{
	FLOG("CAtumApplication::CharacterChangeCurrentHPAndDamageBodyCondition(float CurrentHP)");
	if(m_pShuttleChild->m_myShuttleInfo.CurrentHP > fCurrentHP)
	{
		m_pShuttleChild->m_fShuttleSpeed *= 0.9f;
		m_pShuttleChild->m_myShuttleInfo.CurrentHP = fCurrentHP;
		m_pShuttleChild->m_fNextHP = fCurrentHP;
		m_pCamera->ChangeCamCollType();

		// 2005-11-08 by ispark
		//   Ÿ 
		g_pInterface->m_pCityBase->RecvRequestRepair(FALSE);
	}
	else
	{
		m_pShuttleChild->m_fNextHP = fCurrentHP;
		m_pShuttleChild->m_fNextHPRate = m_pShuttleChild->m_fNextHP - m_pShuttleChild->m_myShuttleInfo.CurrentHP;

		// 2005-11-08 by ispark
		//   Ÿ 
		g_pInterface->m_pCityBase->RecvRequestRepair(TRUE);
	}
//	if(m_pInterface->m_pGageBox)
//	{
//		m_pInterface->m_pGageBox->UpdateHPGage();
//	}
	if(g_pGameMain->m_pUnitInfoBar)
	{
		g_pGameMain->m_pUnitInfoBar->SetHP(m_pShuttleChild->m_myShuttleInfo.CurrentHP, (float)m_pShuttleChild->m_myShuttleInfo.HP);
	}
	// damage bodycondition 
	if(m_pShuttleChild->m_fNextHP/m_pShuttleChild->m_myShuttleInfo.HP < CHARACTER_DAMAGE_STATE_05)
	{
		//  1,2,3  Ȱȭ
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE1_MASK, TRUE );
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE2_MASK, TRUE );
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE3_MASK, TRUE );
		g_pGameMain->m_pUnitState->InsertState(INF_UW_DANGER_MASK);
		if(m_bCharacter == FALSE)
			m_pSound->PlayD3DSound(SOUND_WARNING_HP, D3DXVECTOR3(0,0,0), FALSE);
	}
	else if(m_pShuttleChild->m_fNextHP/m_pShuttleChild->m_myShuttleInfo.HP < CHARACTER_DAMAGE_STATE_10)
	{
		//  1,2 Ȱȭ
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE1_MASK, TRUE );
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE2_MASK, TRUE );
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE3_MASK, FALSE );
		g_pGameMain->m_pUnitState->InsertState(INF_UW_DANGER_MASK);
		if(m_bCharacter == FALSE)
			m_pSound->PlayD3DSound(SOUND_WARNING, D3DXVECTOR3(0,0,0), FALSE);
	}
	else if(m_pShuttleChild->m_fNextHP/m_pShuttleChild->m_myShuttleInfo.HP < CHARACTER_DAMAGE_STATE_15)
	{
		//  1 Ȱȭ
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE1_MASK, TRUE );
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE2_MASK, FALSE );
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE3_MASK, FALSE );
		g_pGameMain->m_pUnitState->OffState(INF_UW_DANGER_MASK);
	}
	else
	{
		//  Ȱȭ
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE1_MASK, FALSE );
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE2_MASK, FALSE );
		SendFieldSocketChangeCharacterBodyCondition( BODYCON_DAMAGE3_MASK, FALSE );
		g_pGameMain->m_pUnitState->OffState(INF_UW_DANGER_MASK);
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::CharacterChangeCurrentDP(float CurrentDP)
/// \brief		FieldSocketCharacterChangeCurrentDP, FieldSocketCharacterChangeCurrentHPDPSPEPԼ SP 
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::CharacterChangeCurrentDP(float sCurrentDP)
{
	FLOG("CAtumApplication::CharacterChangeCurrentDP(float sCurrentDP)");
	if(m_pShuttleChild->m_myShuttleInfo.CurrentDP > sCurrentDP)
	{
		m_pShuttleChild->m_myShuttleInfo.CurrentDP = sCurrentDP;
		m_pShuttleChild->m_fNextDP = sCurrentDP;
//		m_pCamera->ChangeCamCollType();

		// 2005-11-08 by ispark
		//   Ÿ 
		g_pInterface->m_pCityBase->RecvRequestRepair(FALSE);	
	}
	else
	{
		m_pShuttleChild->m_fNextDP = sCurrentDP;
		m_pShuttleChild->m_fNextDPRate = m_pShuttleChild->m_fNextDP - m_pShuttleChild->m_myShuttleInfo.CurrentDP;

		// 2005-11-08 by ispark
		//   Ÿ 
		g_pInterface->m_pCityBase->RecvRequestRepair(TRUE);	
	}
	if(sCurrentDP > 0)
	{
		g_pGameMain->m_pUnitState->OffState(INF_UW_LOWSHIELD_MASK);
		m_pShuttleChild->m_bShielding = TRUE;
	}
	else
	{
		g_pGameMain->m_pUnitState->InsertState(INF_UW_LOWSHIELD_MASK);
		m_pShuttleChild->m_bShielding = FALSE;
	}
	if(g_pGameMain->m_pUnitInfoBar)
	{
		g_pGameMain->m_pUnitInfoBar->SetDP( m_pShuttleChild->m_myShuttleInfo.CurrentDP, (float)m_pShuttleChild->m_myShuttleInfo.DP );
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeCurrentDP(MSG_FC_CHARACTER_CHANGE_CURRENTDP * pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_CURRENTDP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeCurrentDP(MSG_FC_CHARACTER_CHANGE_CURRENTDP * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeCurrentDP(MSG_FC_CHARACTER_CHANGE_CURRENTDP * pMsg)");
	ASSERT_ASSERT(m_pShuttleChild && pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex);
	CharacterChangeCurrentDP(pMsg->CurrentDP);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::CharacterChangeCurrentSP(SHORT CurrentSP)
/// \brief		FieldSocketCharacterChangeCurrentSP, FieldSocketCharacterChangeCurrentHPDPSPEPԼ SP 
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::CharacterChangeCurrentSP(SHORT sCurrentSP)
{
	FLOG("CAtumApplication::CharacterChangeCurrentSP(SHORT sCurrentSP)");
	if(m_pShuttleChild->m_myShuttleInfo.CurrentSP > sCurrentSP)
	{
		m_pShuttleChild->m_myShuttleInfo.CurrentSP = sCurrentSP;
		m_pShuttleChild->m_fNextSP = sCurrentSP;

		// 2005-11-08 by ispark
		//   Ÿ 
		g_pInterface->m_pCityBase->RecvRequestRepair(FALSE);	
	}
	else
	{
		m_pShuttleChild->m_fNextSP = sCurrentSP;
		m_pShuttleChild->m_fNextSPRate = m_pShuttleChild->m_fNextSP - m_pShuttleChild->m_myShuttleInfo.CurrentSP;

		// 2005-11-08 by ispark
		//   Ÿ 
		g_pInterface->m_pCityBase->RecvRequestRepair(TRUE);	
	}
	if(g_pGameMain->m_pUnitInfoBar)
	{
		g_pGameMain->m_pUnitInfoBar->SetSP((float)m_pShuttleChild->m_myShuttleInfo.CurrentSP, (float)m_pShuttleChild->m_myShuttleInfo.SP);
	}
	if(sCurrentSP <= 0)
	{ // SP Ͽ ۽ų Ѵ. // 2004-10-08 by jschoi
		m_pShuttleChild->m_pSkill->ReleaseAllUsingToggleSkill();
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeCurrentSP(MSG_FC_CHARACTER_CHANGE_CURRENTSP * pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_CURRENTSP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeCurrentSP(MSG_FC_CHARACTER_CHANGE_CURRENTSP * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeCurrentSP(MSG_FC_CHARACTER_CHANGE_CURRENTSP * pMsg)");
	ASSERT_ASSERT(m_pShuttleChild && pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex);
	CharacterChangeCurrentSP(pMsg->CurrentSP);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::CharacterChangeCurrentEP(float fCurrentEP)
/// \brief		CharacterChangeCurrentEP, FieldSocketCharacterChangeCurrentHPDPSPEPԼ EP 
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
/////////////////////////////////////////////////////////////////////////////// 
VOID CAtumApplication::CharacterChangeCurrentEP(float fCurrentEP)
{
	FLOG("CAtumApplication::CharacterChangeCurrentEP(float fCurrentEP)");
	if(m_pShuttleChild->m_myShuttleInfo.CurrentEP > fCurrentEP)
	{
		m_pShuttleChild->m_myShuttleInfo.CurrentEP = fCurrentEP;
		m_pShuttleChild->m_fNextEP = fCurrentEP;
		// 2005-11-08 by ispark
		//   Ÿ 
		g_pInterface->m_pCityBase->RecvRequestRepair(FALSE);	
	}
	else
	{
		m_pShuttleChild->m_fNextEP = fCurrentEP;
		m_pShuttleChild->m_fNextEPRate = m_pShuttleChild->m_fNextEP - m_pShuttleChild->m_myShuttleInfo.CurrentEP;
		// 2005-11-08 by ispark
		//   Ÿ 
		g_pInterface->m_pCityBase->RecvRequestRepair(TRUE);	
	}
	if(g_pGameMain->m_pUnitInfoBar)
	{
		g_pGameMain->m_pUnitInfoBar->SetEP(m_pShuttleChild->m_myShuttleInfo.CurrentEP, (float)m_pShuttleChild->m_myShuttleInfo.EP);
	}
	// damage bodycondition 
	if(m_pShuttleChild->m_fNextEP/m_pShuttleChild->m_myShuttleInfo.EP < CHARACTER_LOWFUEL_STATE)
	{
		g_pGameMain->m_pUnitState->InsertState(INF_UW_LOWFUEL_MASK);
	}
	else
	{
		g_pGameMain->m_pUnitState->OffState(INF_UW_LOWFUEL_MASK);
	}

	// 2005-12-30 by ispark,  ٵ  üũ
	g_pShuttleChild->CheckDamageBodyCondition();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeCurrentEP(MSG_FC_CHARACTER_CHANGE_CURRENTEP * pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_CURRENTEP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeCurrentEP(MSG_FC_CHARACTER_CHANGE_CURRENTEP * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeCurrentEP(MSG_FC_CHARACTER_CHANGE_CURRENTEP * pMsg)");
	ASSERT_ASSERT(m_pShuttleChild && pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex);
	CharacterChangeCurrentEP(pMsg->CurrentEP);

	// 2010-06-15 by shcho&hslee ý - ۷ 	
	if(((float)m_pShuttleChild->m_myShuttleInfo.CurrentEP / (float)m_pShuttleChild->m_myShuttleInfo.EP ) <= 
	g_pInterface->m_pINFOpMain->GetOpInfo()->GetOperatorAction(1,1)->spOperatorInfo->FunctionValue )
	{
		g_pInterface->m_pINFOpMain->GetOpInfo()->SetOperatorAction(1,1);
	}
	// end 2010-06-15 by shcho&hslee ý - ۷ 
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeBodycondition(MSG_FC_CHARACTER_CHANGE_BODYCONDITION * pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_BODYCONDITION
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterChangeBodycondition(MSG_FC_CHARACTER_CHANGE_BODYCONDITION * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeBodycondition(MSG_FC_CHARACTER_CHANGE_BODYCONDITION * pMsg)");
  	if(pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		m_pShuttleChild->ChangeBodyConditionFromServer( pMsg->BodyCondition );
	}
	else if(pMsg->ClientIndex < 10000)
	{
		CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
		if(itEnemy != m_pScene->m_mapEnemyList.end())
		{
			BodyCond_t oldBodyCondition = ((CEnemyData*)itEnemy->second)->GetCurrentBodyCondition();
			itEnemy->second->ChangeBodyConditionFromServer( pMsg->BodyCondition );
			// 2007-03-20 by dgwoo  (ٸ ν Ʈ   )
			//--------------------------------------------------------------------------//
			if(g_pShuttleChild->IsObserverMode()
				&& g_pShuttleChild->m_stObserve.ClientIndex == itEnemy->second->m_infoCharacter.CharacterInfo.ClientIndex)
			{
				DbgOut("BodyCondition = %x\n",pMsg->BodyCondition);
				if(!COMPARE_BODYCON_BIT(oldBodyCondition,BODYCON_BOOSTER3_MASK) &&
					COMPARE_BODYCON_BIT(pMsg->BodyCondition,BODYCON_BOOSTER3_MASK) &&
					!COMPARE_BODYCON_BIT(pMsg->BodyCondition,BODYCON_DEAD_MASK))
				{
					// ũ Ʈ
					if(g_pD3dApp->m_pEffectList)
					{
						CAppEffectData* pEffect = g_pScene->FindEffect( RC_EFF_BOOSTER );
						if(pEffect == NULL)
						{
							pEffect = new CAppEffectData(g_pCamera,RC_EFF_BOOSTER,100);
							g_pD3dApp->m_pEffectList->AddChild(pEffect);
						}
					}
				}
				// 2007-03-28 by dgwoo ν Ʈ  .
//				else if((COMPARE_BODYCON_BIT(oldBodyCondition,BODYCON_BOOSTER3_MASK) &&
//					!COMPARE_BODYCON_BIT(pMsg->BodyCondition,BODYCON_BOOSTER3_MASK)) ||
//					COMPARE_BODYCON_BIT(pMsg->BodyCondition,BODYCON_DEAD_MASK))
					else if(!COMPARE_BODYCON_BIT(pMsg->BodyCondition,BODYCON_BOOSTER3_MASK)
						|| COMPARE_BODYCON_BIT(pMsg->BodyCondition,BODYCON_DEAD_MASK))
				{
					// ũ Ʈ
					if(g_pD3dApp->m_pEffectList)
					{
						CAppEffectData* pEffect = g_pScene->FindEffect( RC_EFF_BOOSTER );
						if(pEffect != NULL)
						{
							pEffect->ChangeBodyCondition(BODYCON_LANDED_MASK); // BODYCON_BOOSTER_OFF
						}
					}
				}
			}
			//--------------------------------------------------------------------------//
			
		}
	}
	else
	{
		CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->ClientIndex);
		if(itMonster != m_pScene->m_mapMonsterList.end())
		{
			itMonster->second->ChangeBodyConditionFromServer(pMsg->BodyCondition);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeUnitkind(MSG_FC_CHARACTER_CHANGE_UNITKIND * pMsg)
/// \brief		
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeUnitkind(MSG_FC_CHARACTER_CHANGE_UNITKIND * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeUnitkind(MSG_FC_CHARACTER_CHANGE_UNITKIND * pMsg)");
	CAppEffectData * pData = NULL;
	D3DXVECTOR3 vPos = D3DXVECTOR3(0,1,0);
	if(m_pShuttleChild)
	{
		if(pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			if(pMsg->UnitKind != m_pShuttleChild->m_myShuttleInfo.UnitKind)
			{
				// Effect ߰ Ұ
				m_pShuttleChild->m_myShuttleInfo.UnitKind = pMsg->UnitKind;
				if(m_pEffectList)
				{
					if(IS_BT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
						pData = new CAppEffectData(m_pShuttleChild,RC_EFF_LEVELUP_BT,vPos);
					else if(IS_OT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
						pData = new CAppEffectData(m_pShuttleChild,RC_EFF_LEVELUP_OT,vPos);
					else if(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
						pData = new CAppEffectData(m_pShuttleChild,RC_EFF_LEVELUP_DT,vPos);
					else if(IS_ST(m_pShuttleChild->m_myShuttleInfo.UnitKind))
						pData = new CAppEffectData(m_pShuttleChild,RC_EFF_LEVELUP_ST,vPos);
					if(pData)
					{
						pData = (CAppEffectData *)m_pEffectList->AddChild(pData);
					}
				}
//				if(m_pShuttleChild->m_pCharacterInfo)
///				{
//					m_pShuttleChild->m_pCharacterInfo->InvalidateDeviceObjects();
//					m_pShuttleChild->m_pCharacterInfo->DeleteDeviceObjects();
//					SAFE_DELETE(m_pShuttleChild->m_pCharacterInfo);
//					char strFileName[128];
//					wsprintf( strFileName, "1%d00%02d00", m_bDegree,
//						m_pShuttleRender->GetRenderType(m_pShuttleChild->m_myShuttleInfo.UnitKind));
//					m_pShuttleChild->LoadCharacterEffect(strFileName);
//					if(m_pShuttleChild->m_pCharacterInfo)
//					{
//						m_pShuttleChild->m_pCharacterInfo->SetAllBodyConditionMatrix(m_pShuttleChild->m_mMatrix);
//						m_pShuttleChild->m_pCharacterInfo->SetBodyCondition(m_pShuttleChild->m_myShuttleInfo.BodyCondition);
//					}
//				}
			}
		}
		else
		{
			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				if(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind != pMsg->UnitKind)
				{
					itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind = pMsg->UnitKind;
					// Effect ߰ Ұ
					if(m_pEffectList)
					{
						if(IS_BT(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind))
							pData = new CAppEffectData(itEnemy->second,RC_EFF_LEVELUP_BT,vPos);
						else if(IS_OT(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind))
							pData = new CAppEffectData(itEnemy->second,RC_EFF_LEVELUP_OT,vPos);
						else if(IS_DT(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind))
							pData = new CAppEffectData(itEnemy->second,RC_EFF_LEVELUP_DT,vPos);
						else if(IS_ST(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind))
							pData = new CAppEffectData(itEnemy->second,RC_EFF_LEVELUP_ST,vPos);
						if(pData)
						{
							pData = (CAppEffectData *)m_pEffectList->AddChild(pData);
						}
					}
//					if(itEnemy->second->m_pCharacterInfo)
//					{
//						itEnemy->second->m_pCharacterInfo->InvalidateDeviceObjects();
//						itEnemy->second->m_pCharacterInfo->DeleteDeviceObjects();
//						SAFE_DELETE(itEnemy->second->m_pCharacterInfo);
//						char strFileName[128];
//						wsprintf( strFileName, "1%d00%02d00", m_bDegree,m_pShuttleRender->GetRenderType(itEnemy->second->m_infoCharacter.UnitKind));
//						itEnemy->second->LoadCharacterEffect(strFileName);
//						if(itEnemy->second->m_pCharacterInfo)
//						{
//							itEnemy->second->m_pCharacterInfo->SetAllBodyConditionMatrix(itEnemy->second->m_mMatrix);
//							itEnemy->second->m_pCharacterInfo->SetBodyCondition(itEnemy->second->m_infoCharacter.BodyCondition);
//						}
//					}
				}
			}
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangePropensity(MSG_FC_CHARACTER_CHANGE_PROPENSITY* pMsg)
/// \brief		ġ 
/// \author		ispark
/// \date		2005-08-22 ~ 2005-08-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangePropensity(MSG_FC_CHARACTER_CHANGE_PROPENSITY* pMsg)
{
	if(m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex)
	{
		if(pMsg->byUpdateType == IUT_PENALTY_ON_DEAD)
		{
			char Fame[128];
			wsprintf(Fame, STRMSG_C_050822_0100, m_pShuttleChild->m_myShuttleInfo.Propensity - pMsg->Propensity);
			m_pChat->CreateChatChild(Fame, COLOR_SYSTEM); 
			m_pShuttleChild->m_myShuttleInfo.Propensity = pMsg->Propensity;
		}
		else if(pMsg->byUpdateType == IUT_PENALTY_AGEAR_FUEL_ALLIN)
		{
			char Fame[128];
			wsprintf(Fame, STRMSG_C_050822_0100, m_pShuttleChild->m_myShuttleInfo.Propensity - pMsg->Propensity);
			m_pChat->CreateChatChild(Fame, COLOR_SYSTEM); 
			m_pShuttleChild->m_myShuttleInfo.Propensity = pMsg->Propensity;
		}

	}
	
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyCreateOk(MSG_FC_PARTY_CREATE_OK* pMsg)
/// \brief		MSG_FC_PARTY_CREATE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyCreateOk(MSG_FC_PARTY_CREATE_OK* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyCreateOk(pMsg);

	// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â	
	if(g_pGameMain && g_pGameMain->m_pCommunity)
	{
		// ɼâ 
		SPARTY_INFO* pSPartyInfo = g_pGameMain->m_pCommunity->GetPartyCreate()->GetSPartyCreateInfo();
		//    Ƽ 
		g_pShuttleChild->m_pClientParty->SetSPartyInfo(pSPartyInfo);
		g_pShuttleChild->m_pClientParty->ChagePartyFormation(pSPartyInfo->FormationType);	//    

		CINFCommuPartyCre*	pPartyCre = g_pGameMain->m_pCommunity->GetPartyCreate();	// 
		if(pPartyCre)
		{
			// 츦 
			pPartyCre->ShowWindow(FALSE);			

		}
		CINFCommunityParty*	pParty = g_pGameMain->m_pCommunity->GetParty();	// 
		if(pParty)
		{
			// 
			pParty->ChangePartySubMode(WND_PARTYMODE_OPTION);
		}
		// 2008-12-15 by dgwoo ̼ .
		g_pInterface->m_pGameMain->m_pMissionMain->UpdateMissionMasterButton();
		if(pPartyCre->IsMissionMaster())
		{
			MSG_FC_QUEST_REQUEST_MISSIONMASTER_HELP sMsg;
			sMsg.QuestIdx = g_pInterface->m_pGameMain->m_pMissionMain->GetMissionMasterQuestIdx();
			m_pFieldWinSocket->SendMsg(T_FC_QUEST_REQUEST_MISSIONMASTER_HELP,(char*)&sMsg,sizeof(MSG_FC_QUEST_REQUEST_MISSIONMASTER_HELP));
			pPartyCre->SetMissionMaster(FALSE);
		}
	}
	// end 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyRequestInviteQuestion(MSG_FC_PARTY_REQUEST_INVITE_QUESTION* pMsg)
/// \brief		MSG_FC_PARTY_REQUEST_INVITE_QUESTION
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyRequestInviteQuestion(MSG_FC_PARTY_REQUEST_INVITE_QUESTION* pMsg)
{
	// 2008-07-14 by bhsohn EP3  ó
	// ̹ Ƽ ʴ â ִ.
	if(g_pGameMain->m_pInfWindow->IsExistMsgBox(_Q_PARTY_INVITE))
	{		
		char szCharName[SIZE_MAX_ARENA_FULL_NAME];
		STRNCPY_MEMSET(szCharName, pMsg->MasterCharacterName, SIZE_MAX_ARENA_FULL_NAME);	
		g_pD3dApp->ConevertArenaRenderUserName(g_pD3dApp->GetArenaState(), szCharName);

		if(g_pGameMain->m_pInfWindow->IsExistMsgBoxString(_Q_PARTY_INVITE, szCharName))
		{
			return;			
		}		
	}
	// end 2008-07-14 by bhsohn EP3  ó


	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyRequestInviteQuestion(pMsg);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyRequestInviteQuestion_THE_ARENA(MSG_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA* pMsg)
/// \brief		MSG_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA
/// \author		jhseol
/// \date		2012-04-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyRequestInviteQuestion_THE_ARENA(MSG_FC_PARTY_REQUEST_INVITE_QUESTION_THE_ARENA* pMsg)
{/// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : Ƽ  غ
	g_pShuttleChild->m_pClientParty->SetFirstPartySetupInfo(TRUE);
	g_pShuttleChild->m_pClientParty->FSendPartyAcceptInvite( pMsg->PartyID );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyAutoCreated_THE_ARENA(MSG_FC_PARTY_AUTO_CREATED_THE_ARENA* pMsg)
/// \brief		MSG_FC_PARTY_AUTO_CREATED_THE_ARENA
/// \author		jhseol
/// \date		2012-04-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyAutoCreated_THE_ARENA(MSG_FC_PARTY_AUTO_CREATED_THE_ARENA* pMsg)
{/// 2012-04-12 by jhseol, Ʒ ߰ - ڵƼ : ڵ Ƽ.
	g_pGameMain->m_pCommunity->SetAutoCreateParty(pMsg->PartyInfo);
	g_pGameMain->m_pCommunity->GetParty()->PartySendCreate();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyRejectInviteOk(MSG_FC_PARTY_REJECT_INVITE_OK* pMsg)
/// \brief		MSG_FC_PARTY_REJECT_INVITE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyRejectInviteOk(MSG_FC_PARTY_REJECT_INVITE_OK* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyRejectInviteOk(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyPutMember(MSG_FC_PARTY_PUT_MEMBER* pMsg)
/// \brief		MSG_FC_PARTY_PUT_MEMBER
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyPutMember(MSG_FC_PARTY_PUT_MEMBER* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyPutMember(pMsg);

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoAll(MSG_FC_PARTY_UPDATE_MEMBER_INFO_ALL* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_ALL
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoAll(MSG_FC_PARTY_UPDATE_MEMBER_INFO_ALL* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoAll(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoLevel(MSG_FC_PARTY_UPDATE_MEMBER_INFO_LEVEL* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_LEVEL
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoLevel(MSG_FC_PARTY_UPDATE_MEMBER_INFO_LEVEL* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoLevel(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoHP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_HP* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_HP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoHP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_HP* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoHP(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoCurrentHP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_HP* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_HP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoCurrentHP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_HP* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoCurrentHP(pMsg);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoDP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_DP* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_DP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoDP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_DP* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoDP(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoCurrentDP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_DP* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_DP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoCurrentDP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_DP* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoCurrentDP(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoSP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_SP* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_SP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoSP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_SP* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoSP(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoCurrentSP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_SP* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_SP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoCurrentSP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_SP* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoCurrentSP(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoEP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_EP* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_EP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoEP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_EP* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoEP(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoCurrentEP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_EP* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_EP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoCurrentEP(MSG_FC_PARTY_UPDATE_MEMBER_INFO_CURRENT_EP* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoCurrentEP(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyUpdateMemberInfoBodyCondition(MSG_FC_PARTY_UPDATE_MEMBER_INFO_BODYCONDITION* pMsg)
/// \brief		MSG_FC_PARTY_UPDATE_MEMBER_INFO_BODYCONDITION
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyUpdateMemberInfoBodyCondition(MSG_FC_PARTY_UPDATE_MEMBER_INFO_BODYCONDITION* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoBodyCondition(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketEventWarpOtherFieldServer(MSG_FC_EVENT_WARP * pMsg)
/// \brief		MSG_FC_EVENT_WARP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	  ,  ڵ ؾ 
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketEventWarpOtherFieldServer(MSG_FC_EVENT_WARP * pMsg)
{
	FLOG("CAtumApplication::FieldSocketEventWarpOtherFieldServer(MSG_FC_EVENT_WARP * pMsg)");
	strcpy(m_strFieldIPCurrent,pMsg->FieldServerID.IP);
	int re = strcmp(m_strFieldIPCurrent,m_strFieldIP);
	if(re != 0)
	{
		strcpy(m_strFieldIP,m_strFieldIPCurrent);
		m_nFieldPort = pMsg->FieldServerID.port;
		m_pFieldWinSocket->CloseSocket();
		if(!m_pFieldWinSocket->Connect(m_strFieldIP,m_nFieldPort))
		{
			//  Ҽ 
			NetworkErrorMsgBox(STRMSG_C_SERVER_0011);//" IP ٸ     "
			return;
		}
		m_bOtherFieldWarping = TRUE;
		m_sWarpAreaIndex = pMsg->WarpAreaIndex;
	}
	// 2006-11-02 by ispark,   
	m_pShuttleChild->CheckFormationMoveDelete();
	
	EventWarpOtherMap(pMsg->MapChannelIndex);
	DBGOUT("Map Channel Information : Warp At other Field server [MapIndex:%d][ChannelIndex:%d]\n", pMsg->MapChannelIndex.MapIndex, pMsg->MapChannelIndex.ChannelIndex);
//	EventWarpOtherMap(pMsg->MapName);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketEventWarpSameFieldServer(MSG_FC_EVENT_WARP_SAME_FIELD_SERVER * pMsg)
/// \brief		MSG_FC_EVENT_WARP_SAME_FIELD_SERVER
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketEventWarpSameFieldServer(MSG_FC_EVENT_WARP_SAME_FIELD_SERVER * pMsg)
{
	FLOG("CAtumApplication::EventWarpSameFieldServer(MSG_FC_EVENT_WARP_SAME_FIELD_SERVER * pMsg)");
	m_pShuttleChild->m_vPos = A2DX(pMsg->PositionVector);
	m_pShuttleChild->m_myShuttleInfo.PositionVector = A2DX(pMsg->PositionVector);
//	if(m_pShuttleChild->m_bFormationFlight)//    ʱȭ
//	{
//		m_pShuttleChild->m_bFormationFlight = FALSE;
//		m_pShuttleChild->m_infoParty.bFormationFlyingPositionType = 0;
//		memset( m_pShuttleChild->m_nCharactUniqueNumber, 0x00, sizeof(UINT)*(MAX_PARTY_NUMBER-1));
//	}
	SetFogLevel( pMsg->MapChannelIndex.MapIndex, !m_pScene->m_bNight );
	m_pScene->m_byWeatherType = pMsg->MapWeather;
	m_pScene->m_bChangeWeather = TRUE;

	EventWarpOtherMap(pMsg->MapChannelIndex);

	// Ʒ ʿ ٸ  ̵ 
	if(g_pInterface->m_pGameArena->IsArenaGameState(ARENA_GAME_STATE_RESULT))
	{
		g_pInterface->m_pGameArena->SetArenaGameState(ARENA_GAME_STATE_TEAMINFO);
	}

	// 2006-11-02 by ispark,   
	m_pShuttleChild->CheckFormationMoveDelete();

	// 2005-07-29 by ispark
	// ĳʹ - >   -> ĳͷ
	// 2005-08-02 by ispark
	//  ε  Է ĳͿ  ʱȭ ؾ Ѵ.
	if(pMsg->CharacterMode0 == FALSE)
	{
		m_bCharacter = FALSE;
//		m_pShuttleChild->InitShuttleData();				// 2005-08-03 by ispark
		m_pShuttleChild->m_nBooster = BOOSTER_TYPE_MIN;	// 2005-08-04 by ispark
	}
	else
	{
		m_pCharacterChild->m_vPos = A2DX(pMsg->PositionVector);
		m_bCharacter = TRUE;
		m_pCharacterChild->InitCharacterData();
	}
//	SendMissionComplete();								// 2006-12-18 by ispark, ѹ  üũϱ  ̹Ƿ ϴ ּó
	
	// 2009. 10. 14 by jskim ī  - ó Ʃ丮  ѷα ȳ  ó
	// ĳ  ӽ ̼â ̱
	// 2005-10-17 by ispark
	//if(g_pTutorial->GetTutorialEd() == TRUE)
	//{
		// 2007-06-12 by bhsohn ̼ ̽ 
//		g_pGameMain->m_pMissionInfo->SetFirstMissionSelect(TRUE);
//		g_pGameMain->m_pMissionInfo->MissionProcFlag(TRUE);
		// 2007-12-26 by bhsohn  ۿ  κ 
		//g_pGameMain->ShowMissionTreeWnd(TRUE, FALSE);
		//g_pTutorial->SetTutorialEd(FALSE);

		// 2007-07-20 by bhsohn Ʃ丮  ۷ ȶߴ  ó
//		g_pGameMain->FirstUserShowMissionTreeWnd();
		// 2007-07-26 by bhsohn ̼ mp3߰
		//g_pTutorial->SetTutorialEd(FALSE);
		// end 2007-07-20 by bhsohn Ʃ丮  ۷ ȶߴ  ó
	//}
	//end 2009. 10. 14 by jskim ī  - ó Ʃ丮  ѷα ȳ  ó
	//  ̼ ˻
	CQuest* pQuest = g_pQuestData->FindMapHideQuest( g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex );
	if(pQuest)
	{
		// 2007-06-12 by bhsohn ̼ ̽ 
//		g_pGameMain->m_pMissionInfo->SetPosMissionSearchStart(TRUE);
//		g_pGameMain->m_pMissionInfo->SetPosMissionInfo(pQuest);
		g_pGameMain->SetMissionPosMissionSearchStart(TRUE);
		g_pGameMain->SetMissionPosMissionInfo(pQuest);
	}
	// Ư  Ϸ ̼ ˻
	CQuest* pQuest2 = g_pQuestData->FindPosCompleteQuest( g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex );
	if(pQuest2)
	{
		// 2007-06-12 by bhsohn ̼ ̽ 
		//g_pGameMain->m_pMissionInfo->SetPosMissionComplete(TRUE);
		g_pGameMain->SetMissionPosMissionComplete(TRUE);
	}

	// 2010. 03. 25 by ckPark  5̻ ߶ϸ Ȱ޼ ߰
	m_pShuttleChild->SetDeadMessageEnable( TRUE );
	// end 2010. 03. 25 by ckPark  5̻ ߶ϸ Ȱ޼ ߰

	// 2012-12-17 by bhsohn A 踮 Ʈ    ó
	if(!IsMyShuttleCharacter())// TRUE : ĳ͸, FLASE: 		
	{
		// 
		//m_pShuttleChild->UpdateSkillEffectInfo();
		// 2013-02-14 by mspark, M  ų Ŀ 濡  ʴ  
		m_pShuttleChild->UpdateSkillEffectInfo(AGEAR_SKILL_BASENUM_BARIAL);
		// end 2013-02-14 by mspark, M  ų Ŀ 濡  ʴ  
	}
	// END 2012-12-17 by bhsohn A 踮 Ʈ    ó

	// 2013-02-14 by mspark, M  ų Ŀ 濡  ʴ  
	if(!IsMyShuttleCharacter())// TRUE : ĳ͸, FLASE: 		
	{		
		m_pShuttleChild->UpdateSkillEffectInfo(MGEAR_STATE_INVINCIBLE);	
	}
	// end 2013-02-14 by mspark, M  ų Ŀ 濡  ʴ  

// 2012-11-29 by mspark, ġ ġ ̵ϴ ĳ ġ ϵ 
#ifdef C_SEARCHEYE_SHUTTLE_POSITION_MSPARK
	if(m_nItemNum == RC_ITEM_SEARCHEYE_NUM)
	{
		SetPlaySearchEyeEffect(g_pShuttleChild, RC_EFF_SEARCHEYE_SHUTTLE_POSITION, 0);
	}
	else if(m_nItemNum == RC_ITEM_SEARCHEYE2_NUM)
	{
		SetPlaySearchEyeEffect(g_pShuttleChild, RC_EFF_SEARCHEYE_SHUTTLE_POSITION2, 0);
	}
#endif
// end 2012-11-29 by mspark, ġ ġ ̵ϴ ĳ ġ ϵ 
	
	DBGOUT("Map Channel Information : Warp at Same Field Server [MapIndex:%d][ChannelIndex:%d]\n", pMsg->MapChannelIndex.MapIndex, pMsg->MapChannelIndex.ChannelIndex);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::EventWarpOtherMap(MAP_CHANNEL_INDEX &channelIndex)
/// \brief		FieldSocketEventWarpOtherFieldServer, FieldSocketEventWarpSameFieldServer ̵ ʱȭ Լ
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	EnemyData Ƽ    ⼭ óѴ.
///				m_pScene->DeleteRes() m_mapEnemyList ̹ ִ.
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::EventWarpOtherMap(MAP_CHANNEL_INDEX &channelIndex)
{
	FLOG("CAtumApplication::EventWarpOtherMap(MAP_CHANNEL_INDEX &channelIndex)");
	// 2006-08-21 by dgwoo   ΰ ߴѴ.
	g_pShuttleChild->m_nEventType = EVENT_GAME_START;

	m_pSound->StopD3DSound( SOUND_FLYING_M_A_GEAR );
	m_pSound->StopD3DSound( SOUND_HIGH_BOOSTER );
	m_pSound->StopD3DSound( SOUND_FLYING_B_I_GEAR );
	m_pSound->StopD3DSound( SOUND_LOW_BOOSTER );
	g_pInterface->InvalidateChannelListObjects();
	g_pInterface->DeleteChannelListObjects();

	// 2006-05-29 by ispark, ShuttleChild  ʱȭ Լ .
	g_pShuttleChild->InitWarpShuttle(channelIndex);
	
////	   ų Ѵ.
//	g_pShuttleChild->m_pSkill->ReleaseAllUsingToggleSkill();
//	m_pShuttleChild->DeleteItemPoint();// Effect  ͸ 
////	m_mapObjectList.clear();
//	m_pShuttleChild->m_bSkillMoveIsUse = FALSE;
//	// 2006-02-13 by ispark
//	m_pShuttleChild->InitMissileWarning();
//	m_pShuttleChild->SetBackView(FALSE);		// 2006-05-29 by ispark,  ʱȭ
	// 2005-01-04 by jschoi
//	g_pD3dDev->ResourceManagerDiscardBytes(0);
	g_pD3dDev->EvictManagedResources();


//	CMapEnemyList mapParty;
//	int cont = 60000;
//	m_nInvalidClientIndexCont = 0;
//	// EnemyData Ƽ    ⼭ óѴ.
//	// m_pScene->DeleteRes() m_mapEnemyList ̹ ִ.
//	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.begin();
//	while(itEnemy != m_pScene->m_mapEnemyList.end())
//	{
//		if(itEnemy->second->m_infoParty.bPartyType == _NOPARTY)
//		if(itEnemy->second->m_nPartyID == 0)
//		{
//			SAFE_DELETE(itEnemy->second);
//		}
//		else
//		{
//			itEnemy->second->m_infoCharacter.ClientIndex = INVALID_CLIENT_INDEX;
//			mapParty[cont + m_nInvalidClientIndexCont] = itEnemy->second;
//			itEnemy->second->DeleteItemPoint();
//			m_nInvalidClientIndexCont++;
//		}
//		itEnemy++;
//	}
	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.begin();
	while(itEnemy != m_pScene->m_mapEnemyList.end())
	{
		// 2007-04-03 by dgwoo   .
		if(itEnemy->second->m_infoCharacter.CharacterInfo.ClientIndex == g_pShuttleChild->m_stObserve.ClientIndex)
		{
			g_pShuttleChild->ObserveCancelUpdateInfo();
			g_pShuttleChild->ObserveEnd();
		}
		SAFE_DELETE(itEnemy->second);
		itEnemy = m_pScene->m_mapEnemyList.erase(itEnemy);
	}
	// Chat  .
	if(m_pChat)
	{
		CAtumNode* pChat = (CAtumNode *)m_pChat->m_pChild;
		while(pChat)
		{
			pChat->m_bUsing = FALSE;
			pChat = pChat->m_pNext;
		}
		m_pChat->Tick();
	}
	// Effect(App)  .
	if(m_pEffectList)
	{
		DeleteEffectList();
		m_pEffectList->Tick();
	}
	if(m_pEffectRender)
		m_pEffectRender->m_vecZEnableEffect.clear();

	if(m_pScene)
	{
		m_pScene->InvalidateRes();
		m_pScene->DeleteRes();
// 		m_pScene->m_mapEnemyList = mapParty;	// enemy Ƽ鸸 .
	}

	m_pShuttleChild->m_nOldMapIndex = m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex;
	m_pShuttleChild->m_myShuttleInfo.MapChannelIndex = channelIndex;

	//  ä ε Ʈ - ߿ ٽ Ȯ  .
//	vector<PARTYENEMYINFO*>::iterator itParty = m_pShuttleChild->m_pClientParty->m_vecPartyEnemyInfo.begin();
//	while(itParty != m_pShuttleChild->m_pClientParty->m_vecPartyEnemyInfo.end())
//	{
//		if((*itParty)->m_bPartyType == _PARTYMEMBER || (*itParty)->m_bPartyType == _PARTYMASTER)
//		{
//			if((*itParty)->m_bFormationFlight)
//			{
//				(*itParty)->m_ImPartyMemberInfo.MapChannelIndex = channelIndex;
//			}
//		}
//		itParty++;
//	}

	if(m_pShuttleChild->m_pClientParty->IsFormationFlight())
	{
		m_pShuttleChild->m_pClientParty->FormationFlightClear();
		// 2008-03-05 by bhsohn   ̵,     
		// ٸ  ̵Ͽ  ü
		if(g_pShuttleChild->m_pClientParty->GetPartyInfo().bPartyType == _PARTYMASTER)
		{
			// 2008-06-17 by bhsohn   ó			
			// 			
			g_pShuttleChild->m_pClientParty->RefreshFormationType();	//   
		}		
		else if(g_pShuttleChild->m_pClientParty->GetPartyInfo().bPartyType == _PARTYMEMBER)
		{
			// 
			g_pShuttleChild->SendPacket(T_IC_PARTY_CANCEL_FLIGHT_POSITION);			
		}
		// end 2008-03-05 by bhsohn   ̵,     
	}
	// 2008-06-17 by bhsohn   ó			
	else if(g_pShuttleChild->m_pClientParty->GetOldFormationFlyingType() != -1)
	{
		//    ־.
		if(g_pShuttleChild->m_pClientParty->GetPartyInfo().bPartyType == _PARTYMASTER)
		{
			g_pShuttleChild->m_pClientParty->RefreshFormationType();	//   
		}
	}
	// end 2008-06-17 by bhsohn   ó			

//	MSG_IC_PARTY_GET_ALL_MEMBER sMsg;
//	memset(&sMsg,0x00,sizeof(sMsg));
//	char buffer[SIZE_MAX_PACKET];
//	int nType = T_IC_PARTY_GET_ALL_MEMBER;
//	sMsg.PartyID = g_pShuttleChild->m_pClientParty->GetPartyInfo().PartyID;
//	memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
//	memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
//	g_pIMSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));

	DBGOUT("Map Channel Info : Set Unit Map Info [MapIndex:%d][ChannelIndex:%d]\n",
		channelIndex.MapIndex, channelIndex.ChannelIndex);
	//strcpy(m_pShuttleChild->m_myShuttleInfo.MapName,szMapName);
	m_pInterface->InitMapLoadObjects();
	m_pInterface->RestoreMapLoadObjects();
    
    // 2010. 10. 05 by jskim ʷε  
	//SAFE_DELETE(m_pMapInitThread );
	//m_pMapInitThread = new CMapInitThread();
	//m_pMapInitThread->CreateThread();
    m_pMaploading->SetMapStep(_MAP_LOADING_STEP1);
    // end 2010. 10. 05 by jskim ʷε  
	ChangeGameState(_MAPLOAD);

	// 2007-11-22 by bhsohn Ʒ ռ
	// Ʒ ߿   ,  ´.
	// Ʒ  ¸ Ŭο  ʿ .
	BOOL bArenaTeamNotLoad = (ARENA_STATE_ARENA_GAMING != GetArenaState()) 
								&&(FALSE == g_pInterface->IsArenaGameState(ARENA_GAME_STATE_TEAMINFO))
								// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
								// ǴƼ ˾ â  Ȳ´
								&& ( !m_pInterface->m_pInfinityPopup || !m_pInterface->m_pInfinityPopup->IsShowWnd() )
								// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
								&& !IS_CITY_MAP_INDEX(channelIndex.MapIndex);
	BOOL bGmMode = (ARENA_STATE_ARENA_GAMING != GetArenaState()) 
					&&(TRUE == IsGmModeConnect());
	if(bArenaTeamNotLoad|| bGmMode)	// GM ĿƮ   ´.
	{			
		CloseArenaSocket();		
	}	
	
	// end 2007-11-22 by bhsohn Ʒ ռ
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketEventWarpSameMap(MSG_FC_EVENT_WARP_SAME_MAP * pMsg)
/// \brief		MSG_FC_EVENT_WARP_SAME_MAP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketEventWarpSameMap(MSG_FC_EVENT_WARP_SAME_MAP * pMsg)
{
	FLOG("CAtumApplication::FieldSocketEventWarpSameMap(MSG_FC_EVENT_WARP_SAME_MAP * pMsg)");
	m_pShuttleChild->m_vPos = A2DX(pMsg->PositionVector);
	ChangeGameState(_GAME);
//	if(m_pShuttleChild->m_bFormationFlight)//    ʱȭ
//	{
//		m_pShuttleChild->m_bFormationFlight = FALSE;
//		m_pShuttleChild->m_infoParty.bFormationFlyingPositionType = 0;
//		memset( m_pShuttleChild->m_nCharactUniqueNumber, 0x00, sizeof(UINT)*(MAX_PARTY_NUMBER-1));
//	}
	// 2006-11-02 by ispark,   
	m_pShuttleChild->CheckFormationMoveDelete();
	// 2006-05-29 by ispark, ShuttleChild  ʱȭ Լ .
	g_pShuttleChild->InitWarpShuttle();
	if(m_pShuttleChild->m_pClientParty->IsFormationFlight())
	{
		m_pShuttleChild->m_pClientParty->FormationFlightClear();
		// 2008-03-05 by bhsohn   ̵,     
		if(g_pShuttleChild->m_pClientParty->GetPartyInfo().bPartyType == _PARTYMASTER)
		{
			// 2008-06-17 by bhsohn   ó
			//  ׾ٰ ٽ Ƴ.
			// 
			//g_pShuttleChild->m_pClientParty->ISendPartyChangeFlightFormation(FLIGHT_FORM_NONE);
			g_pShuttleChild->m_pClientParty->RefreshFormationType();	//   
		}		
		else if(g_pShuttleChild->m_pClientParty->GetPartyInfo().bPartyType == _PARTYMEMBER)
		{
			// 
			g_pShuttleChild->SendPacket(T_IC_PARTY_CANCEL_FLIGHT_POSITION);			
		}

		// end 2008-03-05 by bhsohn   ̵,     
	}
	// 2008-06-17 by bhsohn   ó			
	else if(g_pShuttleChild->m_pClientParty->GetOldFormationFlyingType() != -1)
	{
		//    ־.
		if(g_pShuttleChild->m_pClientParty->GetPartyInfo().bPartyType == _PARTYMASTER)
		{
			g_pShuttleChild->m_pClientParty->RefreshFormationType();	//   
		}
	}
	// end 2008-06-17 by bhsohn   ó			
	m_pShuttleChild->ChangeUnitState( _NORMAL );

	// 2005-07-29 by ispark
	// ĳʹ - >   -> ĳͷ
	if(pMsg->CharacterMode0 == FALSE)
	{
		g_pD3dApp->m_bCharacter = FALSE;
		g_pShuttleChild->InitShuttleData(TRUE);		
		INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_CHANGE_CHARACTER_MODE,
			T_FC_CHARACTER_CHANGE_CHARACTER_MODE, pSMode, SendBuf);
		pSMode->CharacterMode0 = FALSE;
		pSMode->PositionAVec3 = A2DX(pMsg->PositionVector);
		pSMode->TargetAVec3 = m_pShuttleChild->m_vVel*1000.0f;
		g_pFieldWinSocket->Write(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_CHANGE_CHARACTER_MODE));
		m_pShuttleChild->SendFieldSocketChangeBodyCondition(m_pShuttleChild->m_myShuttleInfo.ClientIndex, BODYCON_SET_OR_CLEAR_MASK);
	}
	else
	{
		m_pCharacterChild->m_vPos = A2DX(pMsg->PositionVector);
		m_bCharacter = TRUE;
		m_pCharacterChild->InitCharacterData();

		// 2005-08-09 by ispark
		//   ĳ ȯ ˷  ڽ ȯ  ʴ´.
		//  ĳ  ȯ ˸.
		// ޼ ó
		INIT_MSG_WITH_BUFFER(MSG_FC_CHARACTER_CHANGE_CHARACTER_MODE,
			T_FC_CHARACTER_CHANGE_CHARACTER_MODE, pSMode, SendBuf);
		pSMode->CharacterMode0 = TRUE;
		pSMode->PositionAVec3 = A2DX(pMsg->PositionVector);
		pSMode->TargetAVec3 = m_pShuttleChild->m_vVel*1000.0f;
		g_pFieldWinSocket->Write(SendBuf, MSG_SIZE(MSG_FC_CHARACTER_CHANGE_CHARACTER_MODE));
		// 2005-07-28 by ispark
		// ĳ ʱ ٵ  .  Ĵ  ʴ´. Client  ٵ ǴѴ.
		m_pShuttleChild->SendFieldSocketChangeBodyCondition(m_pShuttleChild->m_myShuttleInfo.ClientIndex, BODYCON_SET_OR_CLEAR_MASK);
	}
	
	///////////////////////////////  Ϸ  ////////////////////////////
	char buffer[SIZE_MAX_PACKET];
	int nType = T_FC_EVENT_WARP_SAME_MAP_DONE;
	memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
	m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER);
	m_pScene->SetObjectRenderList();

	// 2004-11-26 by jschoi - ƿ   
	// 2006-08-01 by ispark, ϻ
	g_pShuttleChild->DeletePattern();
	m_pShuttleChild->PatternWarpOut(TRUE);
//	SendMissionComplete();									// 2006-12-18 by ispark, ѹ  üũϱ  ̹Ƿ ϴ ּó

	// 2010. 03. 25 by ckPark  5̻ ߶ϸ Ȱ޼ ߰
	m_pShuttleChild->SetDeadMessageEnable( TRUE );
	// end 2010. 03. 25 by ckPark  5̻ ߶ϸ Ȱ޼ ߰
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketEventOtherWarped(MSG_FC_EVENT_OTHER_WARPED * pMsg)
/// \brief		MSG_FC_EVENT_OTHER_WARPED
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketEventOtherWarped(MSG_FC_EVENT_OTHER_WARPED * pMsg)
{
	FLOG("CAtumApplication::FieldSocketEventOtherWarped(MSG_FC_EVENT_OTHER_WARPED * pMsg)");
	if(m_dwGameState == _CITY)
	{
		DBGOUT("MSG_FC_EVENT_OTHER_WARPED in _CITY \n");
		return;
	}
	if(pMsg->ClientIndex < 10000)
	{
		CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
		if(itEnemy != m_pScene->m_mapEnemyList.end())
		{
			//  ƼŬ 
			if(m_pEffectList)
			{
				CAppEffectData *pData = new CAppEffectData(NULL,RC_EFF_OTHER_WARP,itEnemy->second->m_vPos);
				pData = (CAppEffectData *)m_pEffectList->AddChild(pData);
			}
//			m_pSound->PlayD3DSound(SOUND_WARP, itEnemy->second->m_vPos);
//			CObjectChild* pWarpgate = m_pScene->FindWarpGateByPosition( itEnemy->second->m_vPos );
//			if( pWarpgate )
//			{
//				pWarpgate->ChangeBodycondition( BODYCON_WARP_MASK );
//			}

			// 2005-11-01 by ispark
			//   ƴϸ 
			// 2007-05-07 by bhsohn   ġ   
			//  ʿ   . 
			//if(pMsg->WarpMapIndex != m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex)
			{
				itEnemy->second->m_bIsRender = FALSE;
				//  ĳ ͵(̷ )
				itEnemy->second->m_bUsing = FALSE;
			}
//			m_pScene->DeleteFieldItemOfUnitData( itEnemy->second );
//			m_pScene->DeleteToBlockData(itEnemy->second);
//			SAFE_DELETE(itEnemy->second);
//			m_pScene->m_mapEnemyList.erase(itEnemy);
		}
	}
	else
	{
		CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->ClientIndex);
		if(itMonster != m_pScene->m_mapMonsterList.end())
		{
			itMonster->second->m_bUsing = FALSE;
//			m_pScene->DeleteFieldItemOfUnitData( itMonster->second );
//			m_pScene->DeleteToBlockData(itMonster->second);
//			itMonster->second->DeleteItemPoint();
//			SAFE_DELETE(itMonster->second);
//			m_pScene->m_mapMonsterList.erase(itMonster);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketEventWarpConnectOk(MSG_FC_EVENT_WARP_CONNECT_OK* pMsg)
/// \brief		MSG_FC_EVENT_WARP_CONNECT_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketEventWarpConnectOk(MSG_FC_EVENT_WARP_CONNECT_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketEventWarpConnectOk(MSG_FC_EVENT_WARP_CONNECT_OK* pMsg)");
	m_pShuttleChild->m_myShuttleInfo.ClientIndex = pMsg->ClientIndex;
	m_pShuttleChild->m_vPos = A2DX(pMsg->PositionVector);
//	if(m_pShuttleChild->m_bFormationFlight)//    ʱȭ
//	{
//		m_pShuttleChild->m_bFormationFlight = FALSE;
//		m_pShuttleChild->m_infoParty.bFormationFlyingPositionType = 0;
//		memset( m_pShuttleChild->m_nCharactUniqueNumber, 0x00, sizeof(UINT)*(MAX_PARTY_NUMBER-1));
//	}
	if(m_pShuttleChild->m_pClientParty->IsFormationFlight())
	{
		m_pShuttleChild->m_pClientParty->FormationFlightClear();
	}
	m_bOtherFieldWarping = FALSE;
	if( m_pScene->m_byMapType == MAP_TYPE_CITY )
	{
		ChangeGameState(_CITY);
	}
	else
	{
		ChangeGameState(_GAME);
	}

	// 2005-07-21 by ispark
	// ĳ  Է (0 : (ü), ׿ܴ ĳ)
//	if(pMsg->CharacterMode0 > 0)
//	{
//		m_bCharacter = TRUE;
//		m_pCharacterChild->InitCharacterData();
//	}
//	else
//	{
//	m_bCharacter = FALSE;		
//	m_pShuttleChild->InitShuttleData();
//	}

	m_pInterface->InvalidateMapLoadObjects();
	m_pInterface->DeleteMapLoadObjects();
	SetFogLevel( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex, !m_pScene->m_bNight );
	m_pScene->m_byWeatherType = pMsg->MapWeather;
	m_pScene->m_bChangeWeather = TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketStorePutItemHeader(MSG_FC_STORE_PUT_ITEM_HEADER* pMsg)
/// \brief		MSG_FC_STORE_PUT_ITEM_HEADER
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketStorePutItemHeader(MSG_FC_STORE_PUT_ITEM_HEADER* pMsg)
{
	FLOG("CAtumApplication::FieldSocketStorePutItemHeader(MSG_FC_STORE_PUT_ITEM_HEADER* pMsg)");
	// 2008-08-11 by bhsohn ܵ  ǰԲ
	InitItemList();
	// end 2008-08-11 by bhsohn ܵ  ǰԲ

	// ۽   ޱ 
	m_nItemStorage = pMsg->ItemStorage0;
	// 2007-10-30 by dgwoo   ð  ѹ ش.
	m_bResortingItem = FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::FieldSocketStorePutItem(MSG_FC_STORE_PUT_ITEM* pMsg)
/// \brief		MSG_FC_STORE_PUT_ITEM
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketStorePutItem(MSG_FC_STORE_PUT_ITEM* pMsg)
{
	FLOG("CAtumApplication::FieldSocketStorePutItem(MSG_FC_STORE_PUT_ITEM* pMsg)");
	//   ޱ
	int size = pMsg->BytesToRead;
	char * p = (char *)pMsg;
	p += sizeof(int);
//	if(m_nStorePacketPossess != 0)
	if(m_nItemStorage == ITEM_IN_CHARACTER)
	{
		while(size)
		{
			int usebyte = 0;
			usebyte = g_pStoreData->PutItem(p);
			p += usebyte;
			size -= usebyte;
			if(size < 0)
			{
				m_pChat->CreateChatChild(STRMSG_C_STORE_0007,COLOR_ERROR);//"Store Item ޴  Size(-) "
				break;//err;
			}
		}
	}
	else // â
	{
		ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
		CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
		ASSERT_ASSERT(pStore);
		while(size)
		{
			int usebyte = 0;
			usebyte = pStore->PutItem(p);
			p += usebyte;
			size -= usebyte;
			if(size < 0)
			{
				m_pChat->CreateChatChild(STRMSG_C_STORE_0007,COLOR_ERROR);
				break;//err;
			}
		}
//		while(size)
//		{
//			int usebyte = 0;
//			usebyte = g_pStoreData->PutItemStore(p);
//			p += usebyte;
//			size -= usebyte;
//			if(size < 0)
//			{
//				m_pChat->CreateChatChild("Store Item ޴ Size(-) ",COLOR_ERROR);
//				break;//err;
//			}
//		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketStorePutItemDone(MSG_FC_STORE_PUT_ITEM_DONE* pMsg)
/// \brief		MSG_FC_STORE_PUT_ITEM_DONE
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketStorePutItemDone(MSG_FC_STORE_PUT_ITEM_DONE* pMsg)
{
	FLOG("CAtumApplication::FieldSocketStorePutItemDone(MSG_FC_STORE_PUT_ITEM_DONE* pMsg)");
	//   ޱ Ϸ

	// 2005-03-07 by jschoi
	g_pD3dApp->m_bRequestEnable = TRUE;
	g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
	m_bInputItemDone = TRUE;
	//DBGOUT("FieldSocketStorePutItemDone\n");

	// 2007-10-30 by dgwoo   ð  ѹ ش.
	m_bResortingItem = TRUE;
// 2006-01-05 by ispark, 
//	if(m_nStorePacketPossess != 0)
	if(pMsg->ItemStorage0 == ITEM_IN_CHARACTER)
	{
		m_pShuttleChild->ResortingItem();
		m_pShuttleChild->SetShuttleData(1);
		m_pShuttleChild->SetShuttleData(5);
		if(g_pGameMain)
		{
			if(g_pGameMain->m_pInven)
				g_pGameMain->m_pInven->SetAllIconInfo();
			if(g_pGameMain->m_pCharacterInfo)
				g_pGameMain->m_pCharacterInfo->SetAllUTCInfo();
			if(g_pGameMain->m_pQuickSlot)
				g_pGameMain->m_pQuickSlot->SetAllQSlotInfo();
		}

		// 2009. 04. 06 by ckPark ӽ۽ ߷ æƮ  ȵȻ·  (0001388)
// 		float fWeight = g_pStoreData->GetTotalWeight() / CAtumSJ::GetTransport(&g_pShuttleChild->m_myShuttleInfo);
// 		if(fWeight >= 0.9f)
// 		{
// 			m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0044,COLOR_SYSTEM);//" 緮 90% ʰ Ͽϴ."
// 			m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0045,COLOR_SYSTEM);//"ּ ӵθ ̵ϸ, Ҹ մϴ."
// 		}
// 		else if(fWeight > WEIGHT_RATE_VERY_HEAVY)
// 		{
// 			m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0046,COLOR_SYSTEM);//" 緮 80% ʰ Ͽϴ."
// 			m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0047,COLOR_SYSTEM);//"ν  ѵǸ, Ҹ մϴ."
// 		}
// 		else if(fWeight >= WEIGHT_RATE_HEAVY)
// 		{
// 			m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0048,COLOR_SYSTEM);//" 緮 70% ʰϿ Ҹ մϴ."
// 		}
		// end 2009. 04. 06 by ckPark ӽ۽ ߷ æƮ  ȵȻ·  (0001388)
	}
	else
	{
		ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
		CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
		ASSERT_ASSERT(pStore);
		pStore->InputItemDone();
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		dhkwon
/// \date		2004-07-30 ~ 2004-07-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketStoreMoveItemOk(MSG_FC_STORE_MOVE_ITEM_OK* pMsg)
{
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeLevel(MSG_FC_CHARACTER_CHANGE_LEVEL* pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_LEVEL
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterChangeLevel(MSG_FC_CHARACTER_CHANGE_LEVEL* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeLevel(MSG_FC_CHARACTER_CHANGE_LEVEL* pMsg)");
	CAppEffectData * pData = NULL;
	D3DXVECTOR3 vPos = D3DXVECTOR3(0,1,0);
	CQuest *pQuestInfo = g_pQuestData->GetProgressMission();
	if(pQuestInfo && pQuestInfo->QuestEndType == QUEST_END_TYPE_LEVEL_UP)
	{
		// ̼ Ϸ 
		// 2006-03-27 by ispark, Ƽ̼ ߰
		if(pQuestInfo->IsPartyQuest())
		{
			g_pQuestData->SendFieldSocketQuestRequestSuccessCheck(pQuestInfo->QuestIndex);
		}
		else
		{
			g_pGImage->SetImageInfo(MISSION_SUC, TRUE);
		}
	}
	
	if(m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex)
	{
		// 2006-08-22 by ispark,  
		if(m_pShuttleChild->m_myShuttleInfo.BonusStat < pMsg->BonusStat)
		{
			// 2007-07-27 by bhsohn  ߰   ۷Ϳ 
			g_pGameMain->ShowOpStatChange(pMsg->BonusStat - m_pShuttleChild->m_myShuttleInfo.BonusStat);
//			g_pGameMain->m_bKnowON[LOW_LEVEL_STAT_HELP] = TRUE;
//			g_pGameMain->m_pHelpDesk->SetLowLevelStringbyType(LOW_LEVEL_STAT_HELP, pMsg->BonusStat - m_pShuttleChild->m_myShuttleInfo.BonusStat);
		}

		m_pShuttleChild->m_myShuttleInfo.Level = pMsg->Level;
		m_pShuttleChild->m_myShuttleInfo.BonusStat = pMsg->BonusStat;
//		m_pShuttleChild->m_myShuttleInfo.BonusSkillPoint = pMsg->BonusSkillPoint; // 2005-11-16 by ispark
		// Level Up Effect Create
		if(m_pEffectList)
		{
			// 2005-11-25 by ispark
			// ĳ 󿡼  Ʈ  ʾ ̰ ϱ ؼ ߰
			//   CCharacterChild CAtumNode ߰Ͽ
			CAtumNode * pEffectParent;
			if(g_pD3dApp->m_bCharacter)
				pEffectParent = m_pCharacterChild;
			else
				pEffectParent = m_pShuttleChild;

			if(IS_BT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
			{
				pData = new CAppEffectData(pEffectParent,RC_EFF_LEVELUP_BT,vPos);
			}
			else if(IS_OT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
			{
				pData = new CAppEffectData(pEffectParent,RC_EFF_LEVELUP_OT,vPos);
			}
			else if(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
			{
				pData = new CAppEffectData(pEffectParent,RC_EFF_LEVELUP_DT,vPos);
			}
			else if(IS_ST(m_pShuttleChild->m_myShuttleInfo.UnitKind))
			{
				pData = new CAppEffectData(pEffectParent,RC_EFF_LEVELUP_ST,vPos);
			}
			if(pData)
			{
				pData = (CAppEffectData *)m_pEffectList->AddChild(pData);
			}
		}
//		if(g_pGameMain->m_nRightWindowInfo != RIGHT_WINDOW_INFO)
//			g_pGameMain->RightWindowShow( TRUE, RIGHT_WINDOW_INFO );
//		m_pShuttleChild->CheckQuest();
		if(pMsg->Level < 5)
		{
//			g_pGameMain->m_pNotice->SetNotice("â(F5)  '' йϽñ ٶϴ.");
			g_pGameMain->SetNotice( 17 );
		}
		else if(pMsg->Level == 5)
		{
			// 1 
			// 'ö̾ ' ̼ Ͻø ο 1 ⸦   ֽϴ. ݵ Ͽ ο ⸦ Ͻñ ٶϴ.
			g_pGameMain->SetNotice( 23 );
		}
		else if(pMsg->Level == 6)
		{
			//  5 ̻ʹ '' Ҹ˴ϴ.  'ü'Ʈ ԰մϴ.
			g_pGameMain->SetNotice( 43 );
		}
		else if(pMsg->Level == 7)
		{
			// 1 
			// 'ڽ ȸ' ̼ Ͻø ο 2 ⸦   ֽϴ.
			g_pGameMain->SetNotice( 24 );
		}
		else if(pMsg->Level == 8)
		{
			// ݳ '' ̿Ͽ    ִ  Ǿϴ.
			g_pGameMain->SetNotice( 40 );
		}
		else if(pMsg->Level == 9)
		{
			// ݳ 'ų Ʈ' ̿Ͽ ڽſ ´ ų   ֽϴ.
			g_pGameMain->SetNotice( 41 );
		}
		else if(pMsg->Level == 10)
		{
			//  10ʹ Ϳ  ߴϸ Ȯ ġ ϴ.
			g_pGameMain->SetNotice( 56 );
		}
		if(g_pInterface->m_pCityBase)
		{
			g_pInterface->m_pCityBase->SetButtonEnableByLevel(pMsg->Level);
		}
		g_pQuestData->NotifyStartQuest();

		// 2007-06-12 by bhsohn ̼ ̽ 
		//  ˾  Show
		CQuest *pProgressQuestInfo = g_pQuestData->GetProgressMission();
		if(NULL == pProgressQuestInfo)
		{
			//  ϰִ Ʈ  
			g_pGameMain->UpdateMissionPopWnd(pMsg->Level, -1);
		}
		
		// 2008-03-14 by bhsohn   Ǿƿ ó		
		if(g_pGameMain && g_pGameMain->m_pUnitInfoBar)
		{
			// Levlup¸ Ǿƿ  ʱȭ
			g_pGameMain->m_pUnitInfoBar->InitHappyHourInfo();
		}		
		// end 2008-03-14 by bhsohn   Ǿƿ ó
	}
	else
	{
		CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
		if(itEnemy != m_pScene->m_mapEnemyList.end())
		{
			// Level Up Effect Create
			if(m_pEffectList)
			{
				if(IS_BT(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind))
					pData = new CAppEffectData(itEnemy->second,RC_EFF_LEVELUP_BT,vPos);
				else if(IS_OT(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind))
					pData = new CAppEffectData(itEnemy->second,RC_EFF_LEVELUP_OT,vPos);
				else if(IS_DT(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind))
					pData = new CAppEffectData(itEnemy->second,RC_EFF_LEVELUP_DT,vPos);
				else if(IS_ST(itEnemy->second->m_infoCharacter.CharacterInfo.UnitKind))
					pData = new CAppEffectData(itEnemy->second,RC_EFF_LEVELUP_ST,vPos);
				if(pData)
				{
					pData = (CAppEffectData *)m_pEffectList->AddChild(pData);
				}
			}
		}
	}

	// 2007-01-29 by bhsohn ű ̼ ̽
	//  ٲ   û
	if(g_pShuttleChild->GetShuttleInfo()->InfluenceType & INFLUENCE_TYPE_NORMAL)
		g_pGameMain->m_pHelpDesk->ReShowHelpDesk();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeExp(MSG_FC_CHARACTER_CHANGE_EXP* pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_EXP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterChangeExp(MSG_FC_CHARACTER_CHANGE_EXP* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeExp(MSG_FC_CHARACTER_CHANGE_EXP* pMsg)");
	if(m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex)
	{
		Experience_t oldExperience = m_pShuttleChild->m_myShuttleInfo.Experience;
		m_pShuttleChild->m_myShuttleInfo.Experience = pMsg->Experience;
		m_pShuttleChild->m_fExpPer = (float)((((double)m_pShuttleChild->m_myShuttleInfo.Experience
									- (double)CAtumSJ::GetInitialExperienceOfLevel(m_pShuttleChild->m_myShuttleInfo.Level))
									/((double)CAtumSJ::GetInitialExperienceOfLevel(m_pShuttleChild->m_myShuttleInfo.Level+1)
									- (double)CAtumSJ::GetInitialExperienceOfLevel(m_pShuttleChild->m_myShuttleInfo.Level)))
									* 100);
// 2008-05-30 by dgwoo ġ ý ޽â .
//#ifdef _DEBUG
		char buf[128];
		float fExperience = (float)m_pShuttleChild->m_myShuttleInfo.Experience - oldExperience;
		if(fExperience != 0)
		{
			sprintf(buf, STRMSG_C_060721_0000,fExperience);
			m_pChat->CreateChatChild(buf, COLOR_SKILL_USE,CHAT_TAB_SYSTEM);
		}
//#endif
		if(g_pGameMain->m_pUnitInfoBar)
		{
			g_pGameMain->m_pUnitInfoBar->SetEXP(m_pShuttleChild->m_fExpPer);
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeStat(MSG_FC_CHARACTER_CHANGE_STAT * pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_STAT
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterChangeStat(MSG_FC_CHARACTER_CHANGE_STAT * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeStat(MSG_FC_CHARACTER_CHANGE_STAT * pMsg)");
	if(m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex)
	{
		m_pShuttleChild->m_myShuttleInfo.GearStat = pMsg->GearStat1;
		if(m_pShuttleChild->m_myShuttleInfo.BonusStat != pMsg->BonusStat)
		{
			// 2006-08-22 by ispark,  
			if(m_pShuttleChild->m_myShuttleInfo.BonusStat < pMsg->BonusStat)
			{
				// 2007-07-27 by bhsohn  ߰   ۷Ϳ 
				g_pGameMain->ShowOpStatChange(pMsg->BonusStat - m_pShuttleChild->m_myShuttleInfo.BonusStat);
//				g_pGameMain->m_bKnowON[LOW_LEVEL_STAT_HELP] = TRUE;
//				g_pGameMain->m_pHelpDesk->SetLowLevelStringbyType(LOW_LEVEL_STAT_HELP, pMsg->BonusStat - m_pShuttleChild->m_myShuttleInfo.BonusStat);
			}
			m_pShuttleChild->m_myShuttleInfo.BonusStat = pMsg->BonusStat;
			m_pSound->PlayD3DSound(SOUND_STAT_UP, g_pShuttleChild->m_vPos, FALSE);
		}
//		//   ˻
//		CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByWindowPos( POS_REAR );
//		if( pItemInfo )
//		{
//			if( pItemInfo->GetRealItemInfo()->ReqGearStat.DodgePart > m_pShuttleChild->m_myShuttleInfo.TotalGearStat.DodgePart )
//			{
//				//  .
//				// send item windowNumber (socket)
//				MSG_FC_ITEM_CHANGE_WINDOW_POSITION sMsg;
//				sMsg.CharacterUniqueNumber = g_pShuttleChild->m_myShuttleInfo.CharacterUniqueNumber;
//				sMsg.FromItemUniqueNumber = pItemInfo->UniqueNumber;
//				sMsg.FromItemWindowIndex = pItemInfo->ItemWindowIndex;
//				sMsg.ToItemUniqueNumber = 0;
//				sMsg.ToItemWindowIndex = 9999;
//				g_pFieldWinSocket->SendMsg( T_FC_ITEM_CHANGE_WINDOW_POSITION, (char*)&sMsg, sizeof(sMsg) );
//			}
//		}
	}
/*	if(m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex)
	{
		switch(pMsg->KindOfStat)
		{
			case STAT_ATTACK_PART:
			{
				m_pShuttleChild->m_myShuttleInfo.GearStat.AttackPart = pMsg->ChangeValue_2;
				break;
			}
			case STAT_DEFENSE_PART:
			{
				m_pShuttleChild->m_myShuttleInfo.GearStat.DefensePart = pMsg->ChangeValue_2;
				break;
			}
			case STAT_FUEL_PART:
			{
				m_pShuttleChild->m_myShuttleInfo.GearStat.FuelPart = pMsg->ChangeValue_2;
				if(pMsg->ChangeValue_1)
					m_pShuttleChild->m_myShuttleInfo.EP = pMsg->ChangeValue_1;
				if(g_pGameMain->m_pUnitInfoBar)
				{
					g_pGameMain->m_pUnitInfoBar->SetEP(m_pShuttleChild->m_myShuttleInfo.CurrentEP, (float)m_pShuttleChild->m_myShuttleInfo.EP);
				}
				break;
			}
			case STAT_SOUL_PART:
			{
				m_pShuttleChild->m_myShuttleInfo.GearStat.SoulPart = pMsg->ChangeValue_2;
				if(pMsg->ChangeValue_1)
					m_pShuttleChild->m_myShuttleInfo.SP = pMsg->ChangeValue_1;
				if(g_pGameMain->m_pUnitInfoBar)
				{
					g_pGameMain->m_pUnitInfoBar->SetSP( (float)m_pShuttleChild->m_myShuttleInfo.CurrentSP, (float)m_pShuttleChild->m_myShuttleInfo.SP );
				}
				break;
			}
			case STAT_SHIELD_PART:
			{
				m_pShuttleChild->m_myShuttleInfo.GearStat.ShieldPart = pMsg->ChangeValue_2;
				if(pMsg->ChangeValue_1)
					m_pShuttleChild->m_myShuttleInfo.DP = pMsg->ChangeValue_1;
				if(g_pGameMain->m_pUnitInfoBar)
				{
					g_pGameMain->m_pUnitInfoBar->SetDP( (float)m_pShuttleChild->m_myShuttleInfo.CurrentDP, (float)m_pShuttleChild->m_myShuttleInfo.DP );
				}
				break;
			}
			case STAT_DODGE_PART:
			{
				m_pShuttleChild->m_myShuttleInfo.GearStat.DodgePart = pMsg->ChangeValue_2;
				break;
			}
		}
		m_pShuttleChild->m_myShuttleInfo.BonusStat = pMsg->RemainedAmountOfStat;
		m_pSound->PlayD3DSound(SOUND_STAT_UP, g_pShuttleChild->m_vPos, FALSE);
	}
*/
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeTotalGearStat(MSG_FC_CHARACTER_CHANGE_TOTALGEAR_STAT * pMsg)
/// \brief		
/// \author		jschoi
/// \date		2005-03-04 ~ 2005-03-04
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketCharacterChangeTotalGearStat(MSG_FC_CHARACTER_CHANGE_TOTALGEAR_STAT * pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeStat(MSG_FC_CHARACTER_CHANGE_STAT * pMsg)");
	if(m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex)
	{
		m_pShuttleChild->m_myShuttleInfo.TotalGearStat = pMsg->GearStat1;

		// 2007-05-15 by bhsohn    ó
		//   Ǯ  
		m_pShuttleChild->SetMyShuttleFullStatInfo(pMsg->GearStat1);
		// ִġ COUNT_MAX_STAT_POINT  Ѱ 
		m_pShuttleChild->ReformMyShuttleStatInfo(&m_pShuttleChild->m_myShuttleInfo.TotalGearStat);

		//   ˻
		CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByWindowPos( POS_REAR );
		if( pItemInfo )
		{
			if( pItemInfo->GetRealItemInfo()->ReqGearStat.DodgePart > m_pShuttleChild->m_myShuttleInfo.TotalGearStat.DodgePart )
			{
				//  .
				// send item windowNumber (socket)
				MSG_FC_ITEM_CHANGE_WINDOW_POSITION sMsg;
				sMsg.CharacterUniqueNumber = g_pShuttleChild->m_myShuttleInfo.CharacterUniqueNumber;
				sMsg.FromItemUniqueNumber = pItemInfo->UniqueNumber;
				sMsg.FromItemWindowIndex = pItemInfo->ItemWindowIndex;
				sMsg.ToItemUniqueNumber = 0;
				sMsg.ToItemWindowIndex = 9999;
				g_pFieldWinSocket->SendMsg( T_FC_ITEM_CHANGE_WINDOW_POSITION, (char*)&sMsg, sizeof(sMsg) );
//				g_pD3dApp->m_bRequestEnable = FALSE;			// 2006-06-19 by ispark, ޼  ٸ.
			}
		}
	}

}



///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemChangeWindowPositionOk(MSG_FC_ITEM_CHANGE_WINDOW_POSITION_OK * pMsg)
/// \brief		MSG_FC_ITEM_CHANGE_WINDOW_POSITION_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketItemChangeWindowPositionOk(MSG_FC_ITEM_CHANGE_WINDOW_POSITION_OK * pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemChangeWindowPositionOk(MSG_FC_ITEM_CHANGE_WINDOW_POSITION_OK * pMsg)");


	g_pStoreData->ItemChangeWindowPosition( pMsg );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMoveLandingOk(MSG_FC_MOVE_LANDING_OK* pMsg)
/// \brief		MSG_FC_MOVE_LANDING_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMoveLandingOk(MSG_FC_MOVE_LANDING_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMoveLandingOk(MSG_FC_MOVE_LANDING_OK* pMsg)");
	BOOL bObjectLanging = 
		(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind)==FALSE ||
		IsTileMapRenderEnable(g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex) == FALSE) ? TRUE : FALSE;
	if(m_pShuttleChild->SetOrderMoveTargetPos(bObjectLanging) == FALSE)//   ǥ 
	{
		m_pShuttleChild->ChangeUnitState( _TAKINGOFF );
		return;
	}
		
	m_pShuttleChild->m_vNextPos = A2DX(pMsg->Position);
	m_pShuttleChild->ChangeUnitState( _LANDING );
	m_pShuttleChild->ChangeSingleBodyCondition( BODYCON_LANDING_MASK);
	//m_pShuttleChild->m_dwState = _LANDING;
	m_pShuttleChild->m_bOrderMove = TRUE;
	m_pShuttleChild->m_fLandingCheckTime = 4.0f;
	m_pShuttleChild->m_fLandingDist = m_pShuttleChild->m_vPos.y - m_pShuttleChild->m_vTargetPos.y;
	if(m_pShuttleChild->m_fLandingDist < 200.0f)
		m_pShuttleChild->m_bOrderMoveType = 1;// 
	else
		m_pShuttleChild->m_bOrderMoveType = 2;// ȸ 

	// ī޶   2004.06.30 jschoi
	g_pShuttleChild->InitCinemaCamera(PATTERN_CAMERA_LANDING);	// PATTERN_CAMERA_LANDING
	m_pSound->PlayD3DSound( SOUND_LANDING, g_pShuttleChild->m_vPos, FALSE);

	DBGOUT("*****MSG_FC_MOVE_LANDING_OK\n");
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMoveTakeOffOk(MSG_FC_MOVE_TAKEOFF_OK* pMsg)
/// \brief		MSG_FC_MOVE_TAKEOFF_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMoveTakeOffOk(MSG_FC_MOVE_TAKEOFF_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMoveTakeOffOk(MSG_FC_MOVE_TAKEOFF_OK* pMsg)");
	// 2006-06-29 by ispark  · Ǿ ִٸ  ݴ´.
	if(g_pD3dApp->m_dwGameState == _SHOP)
	{
		g_pInterface->m_pCityBase->OnCityNPCButtonDown(CITY_NPC_BUTTON_CLOSE);
	}

	m_pShuttleChild->m_vNextPos = A2DX(pMsg->Position);
	m_pShuttleChild->ChangeUnitState( _TAKINGOFF );
	//m_pShuttleChild->m_dwState = _TAKINGOFF;
	m_pShuttleChild->m_bOrderMove = FALSE;
	m_pShuttleChild->m_nShuttleStopState = 0;
	
	// 2007-05-15 by bhsohn A 
	//m_pShuttleChild->m_fRasingCheckTime = 1.0f;
	m_pShuttleChild->m_fRasingCheckTime = m_pShuttleChild->GetRasingCheckTime();

//	if(m_dwGameState == _SHOP)
//	{
//		g_pInterface->m_pCityBase->OnCityNPCButtonDown(CITY_NPC_BUTTON_CLOSE);
//	}
	if( IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind) )
	{
		g_pShuttleChild->m_pSkill->ReleaseGroundSkill();
	}
	DBGOUT("T_FC_MOVE_TAKEOFF_OK\n");
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemShowItem(MSG_FC_ITEM_SHOW_ITEM* pMsg)
/// \brief		MSG_FC_ITEM_SHOW_ITEM
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemShowItem(MSG_FC_ITEM_SHOW_ITEM* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemShowItem(MSG_FC_ITEM_SHOW_ITEM* pMsg)");
	if(pMsg->DropItemType == DROP_ITEM_TYPE_PICKUP)
	{
		m_pScene->AddFieldItemItemSHowItem( pMsg );
	}
	else
	{
		if(m_pScene->m_pWeaponData)
		{
			CAtumNode * pWeapon = m_pScene->m_pWeaponData->m_pChild;
			while(pWeapon)
			{
				if( pWeapon->m_dwPartType == _MINE && 
					((CWeaponMineData *)pWeapon)->m_nFieldItemIndex == pMsg->ItemFieldIndex)
				{
					DBGOUT("\nERROR:MSG_FC_ITEM_SHOW_ITEM\n");
					return ;
				}
				pWeapon = (CWeaponMineData *)pWeapon->m_pNext;
			}
			pWeapon = new CWeaponMineData(pMsg);
			pWeapon = (CWeaponMineData *)m_pScene->m_pWeaponData->AddChild(pWeapon);
		}
	}
}



///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemGetItemOk(MSG_FC_ITEM_GET_ITEM_OK* pMsg)
/// \brief		MSG_FC_ITEM_GET_ITEM_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemGetItemOk(MSG_FC_ITEM_GET_ITEM_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemGetItemOk(MSG_FC_ITEM_GET_ITEM_OK* pMsg)");
	CItemData *pItem = m_pScene->FindFieldItemByFieldIndex( pMsg->ItemFieldIndex );
	if(pItem)
	{
		// Effect ߰ؾ
		if(pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			char * p = (char *)(pMsg);
			p+=sizeof(MSG_FC_ITEM_GET_ITEM_OK);

			ITEM *item = m_pDatabase->GetServerItemInfo(pMsg->ItemNum);
			char buf[256];
			if(item)
			{
				if(IS_COUNTABLE_ITEM(item->Kind))// == ITEMKIND_ENERGY)
				{
					wsprintf(buf,STRMSG_C_ITEM_0059,item->ItemName,pMsg->Amount);//"%s(%d)  Ͽϴ."
					m_pChat->CreateChatChild(buf,COLOR_ITEM);
				}
				else
				{
					wsprintf(buf,STRMSG_C_ITEM_0060,item->ItemName);//"%s  Ͽϴ."
					m_pChat->CreateChatChild(buf,COLOR_ITEM);
				}				
			}
			g_pStoreData->PutItem(p);
			g_pGameMain->m_pInven->SetAllIconInfo();
			g_pGameMain->m_pCharacterInfo->SetAllUTCInfo();
			pItem->m_pTarget = m_pShuttleChild;
			pItem->m_dwState = _EXPLODING;

			m_pSound->PlayD3DSound(SOUND_GET_ITEM, m_pShuttleChild->m_vPos, FALSE);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemHideItem(MSG_FC_ITEM_HIDE_ITEM* pMsg)
/// \brief		MSG_FC_ITEM_HIDE_ITEM
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemHideItem(MSG_FC_ITEM_HIDE_ITEM* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemHideItem(MSG_FC_ITEM_HIDE_ITEM* pMsg)");
	CItemData *pItem = m_pScene->FindFieldItemByFieldIndex( pMsg->ItemFieldIndex );
	if(pItem)
	{
		// Effect ߰ؾ
		if(pMsg->ClientIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			pItem->m_pTarget = g_pShuttleChild;
			pItem->m_dwState = _EXPLODING;
			// 2007-06-18 by dgwoo,   ItemFieldIndex 0 ʱȭ Ѵ.  ItemFieldIndex ҴǾ ذ ؼ
			pItem->m_nItemIndex		= 0;		
			return ;
		}
		else if(IS_VALID_CLIENT_INDEX(pMsg->ClientIndex))
		{
			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				pItem->m_pTarget = itEnemy->second;
				pItem->m_dwState = _EXPLODING;
				return ;
			}
		}
		//   Ŭ̾Ʈ  ۸ 
		pItem->m_bUsing = FALSE;
	}
/*	if(m_pItemData)
	{
		CItemData * pItem = (CItemData *)m_pItemData->m_pChild;
		while(pItem)
		{
			if(pItem->m_nItemIndex == pMsg->ItemFieldIndex)
			{
				// Effect ߰ؾ
				if(IS_VALID_CLIENT_INDEX(pMsg->ClientIndex))
				{
					CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
					if(itEnemy != m_pScene->m_mapEnemyList.end())
					{
						pItem->m_pTarget = itEnemy->second;
						pItem->m_dwState = _EXPLODING;
						return ;
					}
				}
				//   Ŭ̾Ʈ  ۸ 
				pItem->m_bUsing = FALSE;
				return ;
			}
			pItem = (CItemData *)pItem->m_pNext;
		}
	}
*/	
	if(m_pScene->m_pWeaponData)
	{
		CAtumNode * pWeapon = m_pScene->m_pWeaponData->m_pChild;
		while(pWeapon)
		{
			if( pWeapon->m_dwPartType == _MINE && 
				((CWeaponMineData *)pWeapon)->m_nFieldItemIndex == pMsg->ItemFieldIndex)
			{
				pWeapon->m_bUsing = FALSE;
				((CWeaponMineData *)pWeapon)->m_nFieldItemIndex = 0xFFFFFFFF;
				break;
			}
			pWeapon = (CWeaponMineData *)pWeapon->m_pNext;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyPutItemOther(MSG_FC_PARTY_PUT_ITEM_OTHER* pMsg)
/// \brief		MSG_FC_PARTY_PUT_ITEM_OTHER
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyPutItemOther(MSG_FC_PARTY_PUT_ITEM_OTHER* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyPutItemOther(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemGetItemFail(MSG_FC_ITEM_GET_ITEM_FAIL* pMsg)
/// \brief		MSG_FC_ITEM_GET_ITEM_FAIL
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemGetItemFail(MSG_FC_ITEM_GET_ITEM_FAIL* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemGetItemFail(MSG_FC_ITEM_GET_ITEM_FAIL* pMsg)");
	char strbuf[256];
	wsprintf(strbuf,STRMSG_C_ITEM_0061);//"ش     ϴ."
	m_pChat->CreateChatChild(strbuf,COLOR_ERROR);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMissileMoveOk(MSG_FC_MISSILE_MOVE_OK* pMsg)
/// \brief		MSG_FC_MISSILE_MOVE_OK,  
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMissileMoveOk(MSG_FC_MISSILE_MOVE_OK* pMsg)
{

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCityRequestEnterBuildingOk(MSG_FC_CITY_REQUEST_ENTER_BUILDING_OK* pMsg)
/// \brief		ǹ() (ȭ , ÿ ϰ )
/// \author		dhkwon
/// \date		2004-06-25 ~ 2004-06-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCityRequestEnterBuildingOk(MSG_FC_CITY_REQUEST_ENTER_BUILDING_OK* pMsg)
{
	if(m_dwGameState == _CITY || pMsg->BuildingIndex == CASH_SHOP_BUILDING_INDEX)
	{
		// 2007-08-10 by dgwoo ĳ   Ѵ.
		if(g_pGameMain)
		{
			g_pGameMain->BackUpWearItem();
		}
//		m_pInterface->m_pCityBase->RecvCityRequestEnterBuildingOk(pMsg->BuildingIndex, pMsg->fCityWarTexRate);
		m_pInterface->m_pCityBase->RecvCityRequestEnterBuildingOk(pMsg->BuildingIndex, pMsg->fInflDistributionTexPercent);
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketEventEnterBuilding(MSG_FC_EVENT_ENTER_BUILDING* pMsg)
/// \brief		MSG_FC_EVENT_ENTER_BUILDING
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventEnterBuilding(MSG_FC_EVENT_ENTER_BUILDING* pMsg)
{
	FLOG("CAtumApplication::FieldSocketEventEnterBuilding(MSG_FC_EVENT_ENTER_BUILDING* pMsg)");
	MSG_FC_EVENT_ENTER_BUILDING_OK sMsg;
	sMsg.BuildingIndex = pMsg->BuildingNPCInfo.BuildingIndex;
	sMsg.SendShopItemList = FALSE;

	//  
	if( IS_PRIMARY_WEAPON(pMsg->BuildingNPCInfo.BuildingKind)	||
		IS_SECONDARY_WEAPON(pMsg->BuildingNPCInfo.BuildingKind) ||
		pMsg->BuildingNPCInfo.BuildingKind == BUILDINGKIND_TUNING_COLOR ||

		// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
		pMsg->BuildingNPCInfo.BuildingKind == BUILDINGKIND_INFINITY_SHOP ||
		// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý

		// 2007-06-28 by dgwoo   ִ  BackUp ޾ƾѴ.
		pMsg->BuildingNPCInfo.BuildingKind == BUILDINGKIND_WARPOINT_SHOP)
	{
		g_pGameMain->BackUpWearItem();
	}
	
	// 2004-04-20 by dhkwon
	if(m_dwGameState == _CITY)
	{
		DBGOUT("MSG_FC_EVENT_ENTER_BUILDING : Can Not Use In City.\n");
	}
	else if(m_pTutorial->GetTutorialEd() == FALSE)	// 2005-11-14 by ispark Ʃ丮  ¶ â  ʴ´.
	{
//		m_pShuttleChild->m_bEventReady = FALSE;
		if( m_pShuttleChild->m_dwState == _LANDING ||
			m_pShuttleChild->m_dwState == _LANDED ||
			// 2009. 09. 24 by jskim ʵ â ĳ 
			//IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind)) 
		//{
			//m_pShuttleChild->ChangeUnitState( _LANDED );
			IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind) ||
			pMsg->BuildingNPCInfo.BuildingIndex == FIELD_STORE_SHOP_BUILDING_INDEX ||
			m_pShuttleChild->m_dwState==_NORMAL)				// 2011-11-01 by jhahn EP4 ʵ  Ŭ
		{						
			if(pMsg->BuildingNPCInfo.BuildingIndex != FIELD_STORE_SHOP_BUILDING_INDEX)
			{
				if (m_pShuttleChild->m_bUnitStop == FALSE )		  // 2011-11-01 by jhahn EP4 ʵ  Ŭ
				m_pShuttleChild->ChangeUnitState( _LANDED );			
			}
			//end 2009. 09. 24 by jskim ʵ â ĳ 			
			// 2006-02-10 by ispark,  ¼ ̼â  ִٸ   
			// 2007-06-12 by bhsohn ̼ ̽ 
			//if(g_pGameMain->m_pMissionInfo->GetInfluenceMission() == TRUE)
			if(g_pGameMain->GetInfluenceMission() == TRUE)
			{
				return;
			}
			// 2007-07-20 by bhsohn 긮η 
			//ChangeGameState(_SHOP);
			//  ʱȭ
			m_pInterface->m_pCityBase->RecvEventEnterBuilding(pMsg);
	//		m_pShuttleChild->ChangeUnitState( _NORMAL );				// 2011-11-01 by jhahn EP4 ʵ  Ŭ
				
		}
		else
		{
			m_pInterface->m_pCityBase->SendLeaveEnterBuilding(pMsg->BuildingNPCInfo.BuildingIndex, -1);
		}
//		if(g_pGameMain && g_pGameMain->m_pShop)
//		{
//			g_pGameMain->m_pShop->InitData(pMsg/*pMsg->NPCTalkIndex*/);
//			if(g_pGameMain->m_nLeftWindowInfo != LEFT_WINDOW_SHOP)
//			{
//				g_pGameMain->LeftWindowShow( TRUE, LEFT_WINDOW_SHOP );
//			}
//		}
	}
	else if(m_pTutorial->GetTutorialEd() == TRUE)	// 2005-11-14 by ispark Ʃ丮  ¿ٸ
	{
		// 2005-11-14 by ispark
		// Ʃ丮     ѹ   Ʃ丮  ¸ Ǭ. 
		//  Ʃ丮     ߴ  Ҵ. Ŀ  ϱ ؼ
		//  ڵ带 ۼ ̴.
		g_pTutorial->SetTutorialEd(FALSE);
	}
	//MSG_FC_EVENT_ENTER_BUILDING_OK
//	m_pFieldWinSocket->SendMsg(T_FC_EVENT_ENTER_BUILDING_OK, (char*)&sMsg,sizeof(sMsg));
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketEventLeaveBuildingOk(MSG_FC_EVENT_LEAVE_BUILDING_OK* pMsg)
/// \brief		MSG_FC_EVENT_LEAVE_BUILDING_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventLeaveBuildingOk(MSG_FC_EVENT_LEAVE_BUILDING_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketEventLeaveBuildingOk(MSG_FC_EVENT_LEAVE_BUILDING_OK* pMsg)");
	// 2007-06-28 by dgwoo   ִ  BackUp ޾ƾѴ.
	if(g_pGameMain->m_bUseShopItem)
	{
		g_pInterface->SetShopItemUseSerch();
	}
	if(m_dwGameState == _CITY)
	{
		//g_pInterface->m_pCityBase->OnCityNPCButtonDown(CITY_NPC_BUTTON_CLOSE);
		g_pInterface->m_pCityBase->RecvLeaveBuildingOk();
	}
	else if(m_dwGameState != _GAME)
	{
//		if(m_dwGameState == _SHOP && g_pGameMain->m_pShop)
//		{
//			g_pGameMain->LeftWindowShow( TRUE, LEFT_WINDOW_WEAPON );
//		}
		g_pInterface->m_pCityBase->RecvLeaveBuildingOk();
		// 2007-07-20 by bhsohn 긮η 
		if(_MAPLOAD != GetGameState())
		{
			ChangeGameState(_GAME);
		}
		//  ٽ  ʰ  Ѵ.
//		m_pShuttleChild->m_fEventCheckTime = 2.0f;
//		m_pShuttleChild->m_bEventReady = TRUE;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketShopPutItemHeader(MSG_FC_SHOP_PUT_ITEM_HEADER* pMsg)
/// \brief		MSG_FC_SHOP_PUT_ITEM_HEADER, ƹϵ 
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopPutItemHeader(MSG_FC_SHOP_PUT_ITEM_HEADER* pMsg)
{
	FLOG("CAtumApplication::FieldSocketShopPutItemHeader(MSG_FC_SHOP_PUT_ITEM_HEADER* pMsg)");

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketShopPutItem(MSG_FC_SHOP_PUT_ITEM* pMsg)
/// \brief		MSG_FC_SHOP_PUT_ITEM
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopPutItem(MSG_FC_SHOP_PUT_ITEM* pMsg)
{
	FLOG("CAtumApplication::FieldSocketShopPutItem(MSG_FC_SHOP_PUT_ITEM* pMsg)");
	GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
	if(pBuilding == NULL)
	{
		return;
	}
	int nBuildingKind = pBuilding->buildingInfo.BuildingKind;
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildingKind);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end())
	{
		return;
	}

	int size = pMsg->BytesToRead;
	char * p = (char *)pMsg;
	p += sizeof(MSG_FC_SHOP_PUT_ITEM);
	while(size)
	{
		int usebyte = 0;
		if(IS_ITEM_SHOP_TYPE(nBuildingKind))
		{
			usebyte = ((CINFCityShop*)it->second)->InputItem(p);
		}
		else if(IS_SKILL_SHOP_TYPE(nBuildingKind))
		{
			usebyte = ((CINFCitySkillShop*)it->second)->InputItem(p);
		}
		else if(IS_CASH_SHOP_TYPE(nBuildingKind))
		{
			usebyte = ((CINFCityCashShop*)it->second)->InputItem(p);
		}
		else if(IS_WARPOINT_SHOP_TYPE(nBuildingKind))
		{
			usebyte = ((CINFCityWarPointShop*)it->second)->InputItem(p);
		}
		else
		{
			DBGOUT("ERROR : CAtumApplication::MsgProc(), Shop Item \n");
		}
		p += usebyte;
		size -= usebyte;
		if(size < 0)
		{
			DBGOUT("ERROR : CAtumApplication::MsgProc(), Shop Item \n");
			break;//err;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketShopPutItemDone(MSG_FC_SHOP_PUT_ITEM_DONE* pMsg)
/// \brief		MSG_FC_SHOP_PUT_ITEM_DONE
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopPutItemDone(MSG_FC_SHOP_PUT_ITEM_DONE* pMsg)
{
	FLOG("CAtumApplication::FieldSocketShopPutItemDone(MSG_FC_SHOP_PUT_ITEM_DONE* pMsg)");
//	if(m_dwGameState == _CITY)
//	{
		if(g_pInterface->m_pCityBase->GetCurrentBuildingNPC())
		{
			int nBuildingKind = g_pInterface->m_pCityBase->GetCurrentBuildingNPC()->buildingInfo.BuildingKind;
			CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildingKind);
			if(it != g_pInterface->m_pCityBase->m_mapCityShop.end())
			{
				if(IS_ITEM_SHOP_TYPE(nBuildingKind))
				{
					((CINFCityShop*)it->second)->InputItemDone();
				}
				else if(IS_SKILL_SHOP_TYPE(nBuildingKind))
				{
					((CINFCitySkillShop*)it->second)->InputItemDone();
				}
				else if(IS_CASH_SHOP_TYPE(nBuildingKind))
				{
					((CINFCityCashShop*)it->second)->InputItemDone();
					// 2009-01-28 by bhsohn ĳ ó
					((CINFCityCashShop*)it->second)->InputCashColorShopItem();
					// end 2009-01-28 by bhsohn ĳ ó
				}
				else if(IS_WARPOINT_SHOP_TYPE(nBuildingKind))
				{
					((CINFCityWarPointShop*)it->second)->InputItemDone();
				}
				else
				{
					DBGOUT("ERROR : CAtumApplication::MsgProc(), Shop Item \n");
				}
				
				DBGOUT("Request Shop Item Info Done(%d)\n",pMsg->NumOfItem);
			}
			else
			{
				DBGOUT("ERROR : CAtumApplication::FieldSocketShopPutItemDone(%d)\n", nBuildingKind);
			}

			// 2007-08-10 by dgwoo ĳ ÷ .
			// 2009-01-28 by bhsohn ĳ ó
// 			if(IS_CASH_SHOP_TYPE(nBuildingKind))
// 			{
// 				((CINFCityCashShop*)it->second)->InputCashColorShopItem();
// 			}
			// end 2009-01-28 by bhsohn ĳ ó
		}
//	}
//	else
//	{
//		g_pGameMain->m_pShop->InputItemDone();
//	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketShopGetItemInfoOk(MSG_FC_SHOP_GET_ITEMINFO_OK* pMsg)
/// \brief		MSG_FC_SHOP_GET_ITEMINFO_OK, ƹϵ 
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopGetItemInfoOk(MSG_FC_SHOP_GET_ITEMINFO_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketShopGetItemInfoOk(MSG_FC_SHOP_GET_ITEMINFO_OK* pMsg)");

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketShopBuyItemOk(MSG_FC_SHOP_BUY_ITEM_OK* pMsg)
/// \brief		MSG_FC_SHOP_BUY_ITEM_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopBuyItemOk(MSG_FC_SHOP_BUY_ITEM_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketShopBuyItemOk(MSG_FC_SHOP_BUY_ITEM_OK* pMsg)");
	// 2002.10.14, â()
	g_pGameMain->m_pInven->SetItemSpi(pMsg->RemainedMoney);

	// 2005-03-07 by jschoi
	g_pD3dApp->m_bRequestEnable = TRUE;
	g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;

	char* p = (char*)pMsg;
	p += sizeof(MSG_FC_SHOP_BUY_ITEM_OK);
	int size = pMsg->SizeOfItem;
	while(size > 0)
	{
		int temp = g_pStoreData->PutItem(p);
		if(IS_SKILL_ITEM(((ITEM_BASE*)p)->Kind))
		{
			CAppEffectData * pEff = new CAppEffectData(m_pShuttleChild,RC_EFF_GET_SKILL,D3DXVECTOR3(0,0,0));
			m_pEffectList->AddChild(pEff);
			CINFCitySkillShop * pShop = (CINFCitySkillShop*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_SKILL_SHOP);
			if(pShop)
			{
				pShop->ReloadSkillItemList();
			}
		}
		size -= temp;
		p += temp;
		if(size < 0)
		{
			m_pChat->CreateChatChild(STRMSG_C_ITEM_0062,COLOR_ERROR);//"Buy Item ޴  Size(-) "
			break;//err;
		}
	}
	// 2003.10.10
	g_pGameMain->m_pInven->SetAllIconInfo();
	g_pGameMain->m_pCharacterInfo->SetAllUTCInfo();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketShopSellItemOk(MSG_FC_SHOP_SELL_ITEM_OK* pMsg)
/// \brief		MSG_FC_SHOP_SELL_ITEM_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopSellItemOk(MSG_FC_SHOP_SELL_ITEM_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketShopSellItemOk(MSG_FC_SHOP_SELL_ITEM_OK* pMsg)");
//	g_pStoreData->SetItemNumber( pMsg->ItemUniqueNumber, pMsg->RemainedNumOfItem);
	g_pStoreData->UpdateItemCount( pMsg->ItemUniqueNumber, pMsg->RemainedNumOfItem);

	// 2002.10.14, â()
	g_pGameMain->m_pInven->SetItemSpi(pMsg->RemainedMoney);

	//m_pShuttleChild->ResortingItem();
	//m_pShuttleChild->SetShuttleData(5);
	// 2003.10.10
	//g_pGameMain->m_pInven->SetAllIconInfo();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketShopGetUsedItemPriceOk(MSG_FC_SHOP_GET_USED_ITEM_PRICE_OK* pMsg)
/// \brief		MSG_FC_SHOP_GET_USED_ITEM_PRICE_OK, ƹϵ 
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopGetUsedItemPriceOk(MSG_FC_SHOP_GET_USED_ITEM_PRICE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketShopGetUsedItemPriceOk(MSG_FC_SHOP_GET_USED_ITEM_PRICE_OK* pMsg)");

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUseEnergyOk(MSG_FC_ITEM_USE_ENERGY_OK*)
/// \brief		MSG_FC_ITEM_USE_ENERGY_OK
/// \author		ydkim
/// \date		2005-04-6
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseEnergyOk(MSG_FC_ITEM_USE_ENERGY_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseEnergyOk(MSG_FC_ITEM_USE_ENERGY_OK* pMsg)");

	ITEM * pIteminfo = g_pDatabase->GetServerItemInfo(pMsg->ItemNum);
	if(pIteminfo->Kind == ITEMKIND_ENERGY)
	{
		// 2009-04-21 by bhsohn  DesParam߰
		//switch(pIteminfo->DestParameter1)
		switch(pIteminfo->ArrDestParameter[0])
		{
		case DES_IMMEDIATE_HP_UP:
			{
				if(g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.HP > g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.CurrentHP)
				{
					CAppEffectData * pEff = NULL; 
					int nEffNum = RC_EFF_USEITEM_REPAIR_HP;
					switch(pMsg->ItemNum)
					{
					case  ITEM_NUM_APLUS_GRADE_HP_KIT:		nEffNum = RC_EFF_USEITEM_REPAIR_HPA;	break;
					case  ITEM_NUM_S_GRADE_HP_KIT:			nEffNum = RC_EFF_USEITEM_REPAIR_HPS;	break;
					// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
					case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKIII:
					case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKII:
					case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKI:
						nEffNum = RC_EFF_USEITEM_REPAIR_HPS;
						break;
					case ITEM_NUM_DEUS_EX_MACHINA_MKIII:
					case ITEM_NUM_DEUS_EX_MACHINA_MKII:
					case ITEM_NUM_DEUS_EX_MACHINA_MKI:
						nEffNum = RC_EFF_USEITEM_REPAIR_DPS;
						break;
					// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
					}

					g_pD3dApp->m_pSound->PlayD3DSound(SOUND_USEITEM_REPAIR_HP, g_pShuttleChild->m_vPos, FALSE);
					pEff = new CAppEffectData(g_pD3dApp->m_pShuttleChild,nEffNum,D3DXVECTOR3(0,0,0));
					pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					MSG_FC_CHARACTER_SHOW_EFFECT sMsg;
					sMsg.EffectIndex = nEffNum;
					g_pFieldWinSocket->SendMsg( T_FC_CHARACTER_SHOW_EFFECT, (char*)&sMsg, sizeof(sMsg) );
				}
				// 2008-08-27 by bhsohn HP/DPÿ   ߰
				// 2009-04-21 by bhsohn  DesParam߰
				//if((DES_IMMEDIATE_DP_UP == pIteminfo->DestParameter2) 
				if((DES_IMMEDIATE_DP_UP == pIteminfo->ArrDestParameter[1]) 
					&& (g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.DP > g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.CurrentDP)
					&& (!g_pShuttleChild->m_pSkill->IsShieldParalyze())) //   Ȱɷ
				{
					CAppEffectData * pEff = NULL;
					int nEffNum = RC_EFF_USEITEM_REPAIR_DP;
					switch(pMsg->ItemNum)
					{
						case  ITEM_NUM_APLUS_GRADE_DP_KIT:		nEffNum = RC_EFF_USEITEM_REPAIR_DPA;	break;
						case  ITEM_NUM_S_GRADE_DP_KIT:			nEffNum = RC_EFF_USEITEM_REPAIR_DPS;	break;
						// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
						case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKIII:
						case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKII:
						case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKI:
							nEffNum = RC_EFF_USEITEM_REPAIR_HPS;
							break;
						case ITEM_NUM_DEUS_EX_MACHINA_MKIII:
						case ITEM_NUM_DEUS_EX_MACHINA_MKII:
						case ITEM_NUM_DEUS_EX_MACHINA_MKI:
							nEffNum = RC_EFF_USEITEM_REPAIR_DPS;
							break;
						// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
					}

					g_pD3dApp->m_pSound->PlayD3DSound(SOUND_USEITEM_REPAIR_DP, g_pShuttleChild->m_vPos, FALSE);
					pEff = new CAppEffectData(g_pD3dApp->m_pShuttleChild,nEffNum,D3DXVECTOR3(0,0,0));
					pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					MSG_FC_CHARACTER_SHOW_EFFECT sMsg;
					sMsg.EffectIndex = nEffNum;
					g_pFieldWinSocket->SendMsg( T_FC_CHARACTER_SHOW_EFFECT, (char*)&sMsg, sizeof(sMsg) );
				}				
				// end 2008-08-27 by bhsohn HP/DPÿ   ߰
			}
			break;
		case DES_IMMEDIATE_DP_UP:
			{
				if(g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.DP > g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.CurrentDP)
				{
					CAppEffectData * pEff = NULL;
					int nEffNum = RC_EFF_USEITEM_REPAIR_DP;
					switch(pMsg->ItemNum)
					{
						case  ITEM_NUM_APLUS_GRADE_DP_KIT:		nEffNum = RC_EFF_USEITEM_REPAIR_DPA;	break;
						case  ITEM_NUM_S_GRADE_DP_KIT:			nEffNum = RC_EFF_USEITEM_REPAIR_DPS;	break;
						// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
						case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKIII:
						case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKII:
						case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKI:
							nEffNum = RC_EFF_USEITEM_REPAIR_HPS;
							break;
						case ITEM_NUM_DEUS_EX_MACHINA_MKIII:
						case ITEM_NUM_DEUS_EX_MACHINA_MKII:
						case ITEM_NUM_DEUS_EX_MACHINA_MKI:
							nEffNum = RC_EFF_USEITEM_REPAIR_DPS;
							break;
						// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
					}

					g_pD3dApp->m_pSound->PlayD3DSound(SOUND_USEITEM_REPAIR_DP, g_pShuttleChild->m_vPos, FALSE);
					pEff = new CAppEffectData(g_pD3dApp->m_pShuttleChild,nEffNum,D3DXVECTOR3(0,0,0));
					pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					MSG_FC_CHARACTER_SHOW_EFFECT sMsg;
					sMsg.EffectIndex = nEffNum;
					g_pFieldWinSocket->SendMsg( T_FC_CHARACTER_SHOW_EFFECT, (char*)&sMsg, sizeof(sMsg) );
				}
				// 2008-08-27 by bhsohn HP/DPÿ   ߰
				// 2009-04-21 by bhsohn  DesParam߰
				//if((DES_IMMEDIATE_HP_UP == pIteminfo->DestParameter2)
				if((DES_IMMEDIATE_HP_UP == pIteminfo->ArrDestParameter[1])
					&&(g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.HP > g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.CurrentHP))
				{
					CAppEffectData * pEff = NULL; 
					int nEffNum = RC_EFF_USEITEM_REPAIR_HP;
					switch(pMsg->ItemNum)
					{
					case  ITEM_NUM_APLUS_GRADE_HP_KIT:		nEffNum = RC_EFF_USEITEM_REPAIR_HPA;	break;
					case  ITEM_NUM_S_GRADE_HP_KIT:			nEffNum = RC_EFF_USEITEM_REPAIR_HPS;	break;
						// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
					case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKIII:
					case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKII:
					case ITEM_NUM_NEUTRON_RECHARGEABLE_BATTERY_MKI:
						nEffNum = RC_EFF_USEITEM_REPAIR_HPS;
						break;
					case ITEM_NUM_DEUS_EX_MACHINA_MKIII:
					case ITEM_NUM_DEUS_EX_MACHINA_MKII:
					case ITEM_NUM_DEUS_EX_MACHINA_MKI:
						nEffNum = RC_EFF_USEITEM_REPAIR_DPS;
						break;
					// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
					}

					g_pD3dApp->m_pSound->PlayD3DSound(SOUND_USEITEM_REPAIR_HP, g_pShuttleChild->m_vPos, FALSE);
					pEff = new CAppEffectData(g_pD3dApp->m_pShuttleChild,nEffNum,D3DXVECTOR3(0,0,0));
					pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					MSG_FC_CHARACTER_SHOW_EFFECT sMsg;
					sMsg.EffectIndex = nEffNum;
					g_pFieldWinSocket->SendMsg( T_FC_CHARACTER_SHOW_EFFECT, (char*)&sMsg, sizeof(sMsg) );
				}
				// end 2008-08-27 by bhsohn HP/DPÿ   ߰
				
			}
			break;
		case DES_IMMEDIATE_EP_UP:
			{
				if(g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.EP > g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.CurrentEP)
				{
					//   
					CAppEffectData * pEff = NULL;
					g_pD3dApp->m_pSound->PlayD3DSound(SOUND_USEITEM_REPAIR_HP, g_pShuttleChild->m_vPos, FALSE);
					pEff = new CAppEffectData(g_pD3dApp->m_pShuttleChild,RC_EFF_USEITEM_REPAIR_EP,D3DXVECTOR3(0,0,0));
					pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					MSG_FC_CHARACTER_SHOW_EFFECT sMsg;
					sMsg.EffectIndex = RC_EFF_USEITEM_REPAIR_EP;
					g_pFieldWinSocket->SendMsg( T_FC_CHARACTER_SHOW_EFFECT, (char*)&sMsg, sizeof(sMsg) );
				}
			}
			break;
			// 2006-01-17 by ispark, SP Ʈ ߰
		case DES_IMMEDIATE_SP_UP:
			{
				if(g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.HP > g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.CurrentHP)
				{
					CAppEffectData * pEff = NULL; 
					MSG_FC_CHARACTER_SHOW_EFFECT sMsg;
					sMsg.EffectIndex = pMsg->ItemNum;
//					sMsg.EffectIndex = RC_EFF_USEITEM_REPAIR_SP;
//					switch(pMsg->ItemNum)
//					{
//					case  ITEM_NUM_APLUS_GRADE_HP_KIT:		nEffNum = RC_EFF_USEITEM_REPAIR_HPA;	break;
//					case  ITEM_NUM_S_GRADE_HP_KIT:			nEffNum = RC_EFF_USEITEM_REPAIR_HPS;	break;
//					}
					g_pD3dApp->m_pSound->PlayD3DSound(SOUND_USEITEM_REPAIR_HP, g_pShuttleChild->m_vPos, FALSE);

					// 2012-02-23 by jhahn  SPŰƮ Ʈ  
					//pEff = new CAppEffectData(g_pD3dApp->m_pShuttleChild,pMsg->so,D3DXVECTOR3(0,0,0));
					ITEM*	pShapeItem	= g_pDatabase->GetServerItemInfo( pMsg->ItemNum );
					pEff = new CAppEffectData(g_pD3dApp->m_pShuttleChild,pShapeItem->SourceIndex,D3DXVECTOR3(0,0,0));
					// end 2012-02-23 by jhahn  SPŰƮ Ʈ  
					
					pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					g_pFieldWinSocket->SendMsg( T_FC_CHARACTER_SHOW_EFFECT, (char*)&sMsg, sizeof(sMsg) );
				}
			}
			break;
		case DES_CASH_CRACKER_CARD:
			{
				CAppEffectData * pEff = NULL;
				int nEffNum = RC_EFF_USEITEM_REPAIR_EP;

//				g_pD3dApp->m_pSound->PlayD3DSound(SOUND_USEITEM_REPAIR_DP, g_pShuttleChild->m_vPos, FALSE);
				pEff = new CAppEffectData(g_pD3dApp->m_pShuttleChild,nEffNum,D3DXVECTOR3(0,0,0));
				pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
				MSG_FC_CHARACTER_SHOW_EFFECT sMsg;
				sMsg.EffectIndex = nEffNum;
				g_pFieldWinSocket->SendMsg( T_FC_CHARACTER_SHOW_EFFECT, (char*)&sMsg, sizeof(sMsg) );
			}
			break;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUseItemOk(MSG_FC_ITEM_USE_ITEM_OK*)
/// \brief		MSG_FC_ITEM_USE_ITEM_OK
/// \author		ydkim
/// \date		2005-04-6
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseItemOk(MSG_FC_ITEM_USE_ITEM_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseItemOk(MSG_FC_ITEM_USE_ITEM_OK* pMsg)");

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUseCarditemGuildNotify(MSG_FC_ITEM_USE_CARDITEM_GUILD_NOTIFY*)
/// \brief		MSG_FC_ITEM_USE_CARDITEM_GUILD_NOTIFY
/// \author		ydkim
/// \date		2005-04-6
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseCarditemGuildNotify(MSG_FC_ITEM_USE_CARDITEM_GUILD_NOTIFY* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseCarditemGuildNotify(MSG_FC_ITEM_USE_CARDITEM_GUILD_NOTIFY* pMsg)");
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUseCarditemDeleteAllEnchant(MSG_FC_ITEM_DELETE_ALL_ENCHANT* pMsg)
/// \brief		MSG_FC_ITEM_DELETE_ALL_ENCHANT
/// \author		ydkim
/// \date		2005-04-6
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseCarditemDeleteAllEnchant(MSG_FC_ITEM_DELETE_ALL_ENCHANT* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseCarditemDeleteAllEnchant(MSG_FC_ITEM_DELETE_ALL_ENCHANT* pMsg)");
	CINFCityLab* pBuidling = (CINFCityLab*)g_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
	if(pBuidling)
	{
		CItemInfo *pInfo = pBuidling->GetTargetItemInfo();
		if(pInfo)
		{
			pInfo->DeleteEnchantInfo();
		}
		else
		{
			CItemInfo *pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber(pMsg->ItemUniqueNumber);
			if(pItemInfo)
			{
				pItemInfo->DeleteEnchantInfo();
			}
		}
	}


//	CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber(pMsg->ItemUniqueNumber);
//	if(pItemInfo)
//	{
//		pItemInfo->DeleteEnchantInfo();		
//	}
	DBGOUT("Delete Item Enchant\n");
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketItemUseCardItemMonstersummonNotify(MSG_FC_ITEM_USE_CARDITEM_MONSTERSUMMON_NOTIFY*)
/// \brief		MSG_FC_ITEM_USE_CARDITEM_MONSTERSUMMON_NOTIFY
/// \author		ydkim
/// \date		2005-04-6
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseCardItemMonstersummonNotify(MSG_FC_ITEM_USE_CARDITEM_MONSTERSUMMON_NOTIFY* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseCardItemMonstersummonNotify(MSG_FC_ITEM_USE_CARDITEM_MONSTERSUMMON_NOTIFY* pMsg)");

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketItemUseCardItemChangecharacternameNotify(MSG_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME_NOTIFY*)
/// \brief		MSG_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME_NOTIFY
/// \author		ydkim
/// \date		2005-04-6
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseCardItemChangecharacternameNotify(MSG_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME_NOTIFY* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseCardItemChangecharacternameNotify(MSG_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME_NOTIFY* pMsg)");

	if(pMsg->notifyClientIdx == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		memset(g_pShuttleChild->m_myShuttleInfo.CharacterName, 0x00, strlen(g_pShuttleChild->m_myShuttleInfo.CharacterName));
		strcpy(g_pShuttleChild->m_myShuttleInfo.CharacterName, pMsg->szChangedCharacterName);
		ZERO_MEMORY(((CChatMoveData *)g_pShuttleChild->m_pIDChat->m_pChild)->m_szString);
		strcpy(((CChatMoveData *)g_pShuttleChild->m_pIDChat->m_pChild)->m_szString, pMsg->szChangedCharacterName);

		g_pGameMain->m_pSystem->m_bLogOffGameMessage	= TRUE;
		g_pGameMain->m_pSystem->m_bQuitGameMessage		= TRUE;
		g_pGameMain->m_pSystem->m_fLastTickSecTime		= 20.0f;
	}
	else
	{
		// ĳ ̸  ƴ϶....
		MSG_IC_GUILD_GET_GUILD_INFO_OK * GuildTemp = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
		if(GuildTemp)
		{
			vector<structGuildInfo*>::iterator it = g_pGameMain->m_pCommunity->GetGuild()->GetGuildMemberList()->begin();
			while(it != g_pGameMain->m_pCommunity->GetGuild()->GetGuildMemberList()->end())
			{
				if(0 == strcmp((*it)->MemberName,pMsg->szOriginCharacterName))
				{
					strcpy((*it)->MemberName,pMsg->szChangedCharacterName);
					char buf[256];
					ZERO_MEMORY(buf);

					wsprintf(buf, STRMSG_C_CARD_0013, pMsg->szOriginCharacterName, pMsg->szChangedCharacterName);//"ܿ \'%s\' \'%s\' ĳ Ͽϴ."
					m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
				}
				it++;
			}
		}

	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketItemUseCardItemSkillinitializeNotify(MSG_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE_NOTIFY*)
/// \brief		MSG_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE_NOTIFY
/// \author		ydkim
/// \date		2005-04-6
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseCardItemSkillinitializeNotify(MSG_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE_NOTIFY* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseCardItemSkillinitializeNotify(MSG_FC_ITEM_USE_CARDITEM_SKILLINITIALIZE_NOTIFY* pMsg)");

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketItemUseCardItemChangepilotfaceNotify(MSG_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE_NOTIFY*)
/// \brief		MSG_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE_NOTIFY
/// \author		ydkim
/// \date		2005-04-6
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseCardItemChangepilotfaceNotify(MSG_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE_NOTIFY* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseCardItemChangepilotfaceNotify(MSG_FC_ITEM_USE_CARDITEM_CHANGEPILOTFACE_NOTIFY* pMsg)");
	if(pMsg->notifyClientIdx == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		m_bRequestEnable = TRUE;
		if(g_pShuttleChild)
		{
			g_pShuttleChild->m_myShuttleInfo.PilotFace = pMsg->pilotFace;	
		}
		if(m_pCharacterChild)
		{
			m_pCharacterChild->InitCharacterData();
		}
		g_pGameMain->m_pChangeCharactor->SetActive(FALSE);
		m_pChat->CreateChatChild(STRMSG_C_071121_0101,COLOR_SYSTEM);
	}
	else
	{
		CEnemyData * pEnemy;
		CMapEnemyIterator itEnemy = g_pScene->m_mapEnemyList.find(pMsg->notifyClientIdx);
		pEnemy = itEnemy->second;
		if(pEnemy)
		{
			pEnemy->m_infoCharacter.CharacterInfo.PilotFace = pMsg->pilotFace;
			pEnemy->SetPilotNumber(pMsg->pilotFace);
		}

	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemThrowAwayItemOk(MSG_FC_ITEM_THROW_AWAY_ITEM_OK* pMsg)
/// \brief		MSG_FC_ITEM_THROW_AWAY_ITEM_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemThrowAwayItemOk(MSG_FC_ITEM_THROW_AWAY_ITEM_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemThrowAwayItemOk(MSG_FC_ITEM_THROW_AWAY_ITEM_OK* pMsg)");
//	g_pStoreData->SetItemNumber( pMsg->ItemUniqueNumber, pMsg->RemainedNumOfItem);
	g_pStoreData->UpdateItemCount( pMsg->ItemUniqueNumber, pMsg->RemainedNumOfItem);
	//m_pShuttleChild->ResortingItem();
	//m_pShuttleChild->SetShuttleData(5);
	// 2003.10.10
	//g_pGameMain->m_pInven->SetAllIconInfo();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUseBuffOk(MSG_FC_ITEM_USE_INFLUENCE_BUFF_OK* pMsg)
/// \brief		   OK
/// \author		ispark
/// \date		2006-04-24 ~ 2006-04-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseBuffOk(MSG_FC_ITEM_USE_INFLUENCE_BUFF_OK* pMsg)
{
	// 2008-01-05 by bhsohn ̼  
//	char buff[128] = {0,};	
// 	wsprintf(buff,STRMSG_C_060424_0000);		
// 	m_pChat->CreateChatChild(buff, COLOR_INFLUENCE);
	ITEM *pItem = g_pDatabase->GetServerItemInfo(pMsg->ItemNum);
	if(NULL == pItem)
	{
		return;
	}
	char buff[256] = {0,};
	memset(buff, 0x00, 256);
	// 2009-04-21 by bhsohn  DesParam߰
	//switch(pItem->DestParameter1)
	switch(pItem->ArrDestParameter[0])
	{
	case DES_ITEM_BUFF_INFLUENCE:
		{
			// "ڰ <  >  Ͽϴ."
			wsprintf(buff,STRMSG_C_060424_0000);
		}
		break;
	case DES_ITEM_BUFF_PARTY:
		{
			// "\\y%s    Ͽϴ."
			wsprintf(buff,STRMSG_C_090105_0201, pMsg->ItemUseCharacterName);
		}
		break;
	}
	if(strlen(buff) > 0)
	{
		m_pChat->CreateChatChild(buff, COLOR_INFLUENCE);
	}	
	// end 2008-01-05 by bhsohn ̼  
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUseInfluenceGameEventOk(MSG_FC_ITEM_USE_INFLUENCE_GAMEEVENT_OK* pMsg);
/// \brief		  ̺Ʈ OK
/// \author		ispark
/// \date		2006-04-24 ~ 2006-04-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseInfluenceGameEventOk(MSG_FC_ITEM_USE_INFLUENCE_GAMEEVENT_OK* pMsg)
{
	char buff[128] = {0,};
	wsprintf(buff,STRMSG_C_060424_0001);		
	m_pChat->CreateChatChild(buff, COLOR_INFLUENCE);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketChatRegion(MSG_FC_CHAT_REGION* pMsg)
/// \brief		MSG_FC_CHAT_REGION
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketChatRegion(MSG_FC_CHAT_REGION* pMsg)
{
	FLOG("CAtumApplication::FieldSocketChatRegion(MSG_FC_CHAT_REGION* pMsg)");
	char strChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	memset(strChat, 0x00, SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4);
	char textbuf[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	memset(textbuf, 0x00, SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4);

	// ź ä  ʱ
	vector<Reject_t>::iterator it = g_pGameMain->m_pCommunity->GetReject()->m_vecReject.begin();
	while(it != g_pGameMain->m_pCommunity->GetReject()->m_vecReject.end())
	{
		if(0 == stricmp(pMsg->FromCharacterName, it->szRejectName))
		{
			return;
		}
		it++;			
	}

	///////////////////////////////////////////////////////////
	//
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_FC_CHAT_REGION);
	memcpy(strChat,p,size);
	//
	//////////////////////////////////////////////////////////

	int temp,temp2;
	CheckReadyStringFiltering(strChat,&temp,&temp2);
//	m_pAbuseFilter->AbuseFiltering(strChat,&temp,&temp2);
	wsprintf(textbuf,"[%s]:%s",pMsg->FromCharacterName,strChat);

	g_pGameMain->m_pUnitNameInfo->ChatCreateInfo( pMsg->MessageLength, strChat, pMsg->FromCharacterName);	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketChatCashAll(MSG_FC_CHAT_CASH_ALL* pMsg)
/// \brief		MSG_FC_CHAT_CASH_ALL
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketChatCashAll(MSG_FC_CHAT_CASH_ALL* pMsg)
{
	FLOG("CAtumApplication::FieldSocketChatCashAll(MSG_FC_CHAT_CASH_ALL* pMsg)");
	
	char str[512];
	char strChat[512];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_FC_CHAT_MAP);
	memcpy(strChat,p,size);
	int temp,temp2;
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(strChat, &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(strChat,&temp,&temp2);
	wsprintf(str,"&[%s] %s",pMsg->FromCharacterName,strChat);//  ä
	m_pChat->CreateChatChild(str,COLOR_CHAT_CASH, CHAT_TAB_CASH);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketChatMap(MSG_FC_CHAT_MAP* pMsg)
/// \brief		MSG_FC_CHAT_MAP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketChatMap(MSG_FC_CHAT_MAP* pMsg)
{
	FLOG("CAtumApplication::FieldSocketChatMap(MSG_FC_CHAT_MAP* pMsg)");

	// ź ä  ʱ
	vector<Reject_t>::iterator it = g_pGameMain->m_pCommunity->GetReject()->m_vecReject.begin();
	while(it != g_pGameMain->m_pCommunity->GetReject()->m_vecReject.end())
	{
		if(0 == stricmp(pMsg->FromCharacterName, it->szRejectName))//(pMsg->FromCharacterName == it->szRejectName)
		{
			return;
		}
		it++;			
	}

	char str[512];
	char strChat[512];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_FC_CHAT_MAP);
	memcpy(strChat,p,size);
	int temp,temp2;
	CheckReadyStringFiltering(strChat,&temp,&temp2);
//	m_pAbuseFilter->AbuseFiltering(strChat,&temp,&temp2);
	wsprintf(str,"![%s] %s",pMsg->FromCharacterName,strChat);//  ä
	m_pChat->CreateChatChild(str,COLOR_CHAT_MAP, CHAT_TAB_MAP);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketChatArena(MSG_FC_CHAT_ARENA* pMsg)
/// \brief		Ʒ ä.
/// \author		dgwoo
/// \date		2007-05-08 ~ 2007-05-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketChatArena(MSG_FC_CHAT_ARENA* pMsg)
{
	char str[512];
	char strChat[512];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_FC_CHAT_ARENA);
	memcpy(strChat,p,size);
	int temp,temp2;
	CheckReadyStringFiltering(strChat,&temp,&temp2);

	// 2007-11-22 by bhsohn Ʒ ռ	
	//wsprintf(str,"%[%s] %s",pMsg->FromCharacterName,strChat);//  ä	
	char szCharacterName[SIZE_MAX_ARENA_FULL_NAME];
	memset(szCharacterName, 0x00, SIZE_MAX_ARENA_FULL_NAME);
	strncpy(szCharacterName, pMsg->FromCharacterName, SIZE_MAX_CHARACTER_NAME);
	ConevertArenaRenderUserName(ARENA_STATE_ARENA_GAMING, szCharacterName);
	wsprintf(str,"%[%s] %s",szCharacterName,strChat);//  ä	
	// end 2007-11-22 by bhsohn Ʒ ռ

	m_pChat->CreateChatChild(str,COLOR_ARENA, CHAT_TAB_ARENA);
}

// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
// ǴƼ   ä
VOID	CAtumApplication::FieldSocketChatInfinity( MSG_FC_CHAT_INFINITY* pMsg )
{
	char str[512];
	char strChat[512];
	BYTE size = pMsg->MessageLength;
	char* p = (char*)pMsg;
	p += sizeof(MSG_FC_CHAT_INFINITY);
	memcpy(strChat,p,size);
	int temp,temp2;
	CheckReadyStringFiltering(strChat,&temp,&temp2);

	char szCharacterName[SIZE_MAX_ARENA_FULL_NAME];
	memset(szCharacterName, 0x00, SIZE_MAX_ARENA_FULL_NAME);
	strncpy(szCharacterName, pMsg->FromCharacterName, SIZE_MAX_CHARACTER_NAME);
	ConevertArenaRenderUserName(ARENA_STATE_ARENA_GAMING, szCharacterName);
	wsprintf(str,"%[%s] %s",szCharacterName,strChat);

	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
// 	CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY );
// 	if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
// 		((CINFCityInfinityField*)((*it).second))->AddChat( str );

	if( m_pInterface && m_pInterface->m_pInfinityPopup )
		m_pInterface->m_pInfinityPopup->AddChat( str );
	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
}
// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeRequestTradeOk(MSG_FC_TRADE_REQUEST_TRADE_OK* pMsg)
/// \brief		MSG_FC_TRADE_REQUEST_TRADE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeRequestTradeOk(MSG_FC_TRADE_REQUEST_TRADE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeRequestTradeOk(MSG_FC_TRADE_REQUEST_TRADE_OK* pMsg)");
	// 2008-06-20 by bhsohn EP3 ɼǰ ó
	BOOL bTradeFlag = g_pGameMain->m_pChat->m_bTradeFlag;
	if(bTradeFlag)
	{
		if(!g_pD3dApp->IsOptionEtc(OPTION_RADIO_EXCHANGE))
		{
			bTradeFlag = FALSE;
		}
	}
	// end 2008-06-20 by bhsohn EP3 ɼǰ ó
	// 2003.10.14 ŷ
	//if(g_pGameMain->m_pChat->m_bTradeFlag == TRUE)
	if(bTradeFlag == TRUE)
	{
		// ŷ źλ° ƴϸ
		// 2006-11-07 by ispark,  Ʈ üũ
		vector<Reject_t>::iterator itReject = g_pGameMain->m_pCommunity->GetReject()->m_vecReject.begin();
		while(itReject != g_pGameMain->m_pCommunity->GetReject()->m_vecReject.end())
		{
			if(0 == stricmp(pMsg->TradeSource, itReject->szRejectName))
			{
				g_pGameMain->m_pTrade->m_nTradeCharacterUniqueNumber = pMsg->TradeSourceCharacterUniqueNumber;
				g_pGameMain->m_pTrade->SendTradeReject();
				return;
			}
			itReject++;			
		}
	

		g_pGameMain->m_pTrade->RequestTrade(pMsg->TradeSource, pMsg->TradeSourceCharacterUniqueNumber);
	}
	else
	{
		// ŷ źλ̸
		MSG_FC_TRADE_REJECT_TRADE sMsg;
		memset(&sMsg,0x00,sizeof(sMsg));
		char buffer[SIZE_MAX_PACKET];
		int nType = T_FC_TRADE_REJECT_TRADE;
		sMsg.TradeSourceCharacterUniqueNumber = pMsg->TradeSourceCharacterUniqueNumber;
		memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
		memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
		g_pD3dApp->m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));
		
		char buf[128];
		wsprintf(buf,STRMSG_C_TRADE_0010,pMsg->TradeSource);//"\\yŷźλ \\y%s԰ ŷ ź Ͽϴ."
		m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeAcceptTradeOk(MSG_FC_TRADE_ACCEPT_TRADE_OK* pMsg)
/// \brief		MSG_FC_TRADE_ACCEPT_TRADE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeAcceptTradeOk(MSG_FC_TRADE_ACCEPT_TRADE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeAcceptTradeOk(MSG_FC_TRADE_ACCEPT_TRADE_OK* pMsg)");
	m_pChat->CreateChatChild(STRMSG_C_TRADE_0011,COLOR_TRADE);//" ŷ  Ͽϴ."
	// 2003.10.14 ŷ
	g_pGameMain->m_pTrade->RecvTradeAccept(pMsg->TradeTarget, pMsg->TradeTargetCharacterUniqueNumber);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeRejectTradeOk(MSG_FC_TRADE_REJECT_TRADE_OK* pMsg)
/// \brief		MSG_FC_TRADE_REJECT_TRADE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeRejectTradeOk(MSG_FC_TRADE_REJECT_TRADE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeRejectTradeOk(MSG_FC_TRADE_REJECT_TRADE_OK* pMsg)");
	m_pChat->CreateChatChild(STRMSG_C_TRADE_0012,COLOR_TRADE);//" ŷ  Ͽϴ."
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeRejectTrading(MSG_FC_TRADE_REJECT_TRADING* pMsg)
/// \brief		MSG_FC_TRADE_REJECT_TRADING
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeRejectTrading(MSG_FC_TRADE_REJECT_TRADING* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeRejectTrading(MSG_FC_TRADE_REJECT_TRADING* pMsg)");
	char message[256];
	wsprintf(message,STRMSG_C_TRADE_0013,pMsg->TradeTarget);//"%s   ŷԴϴ."
	m_pChat->CreateChatChild(message,COLOR_TRADE);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeShowTradeWindow(MSG_FC_TRADE_SHOW_TRADE_WINDOW* pMsg)
/// \brief		MSG_FC_TRADE_SHOW_TRADE_WINDOW
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeShowTradeWindow(MSG_FC_TRADE_SHOW_TRADE_WINDOW* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeShowTradeWindow(MSG_FC_TRADE_SHOW_TRADE_WINDOW* pMsg)");
	// 2003.10.14, ŷ
	if(g_pGameMain->m_nLeftWindowInfo != LEFT_WINDOW_TRANS)
		g_pGameMain->LeftWindowShow(TRUE, LEFT_WINDOW_TRANS);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeOkTradeOk(MSG_FC_TRADE_OK_TRADE_OK* pMsg)
/// \brief		MSG_FC_TRADE_OK_TRADE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeOkTradeOk(MSG_FC_TRADE_OK_TRADE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeOkTradeOk(MSG_FC_TRADE_OK_TRADE_OK* pMsg)");
	// ŷ 
	m_pChat->CreateChatChild(STRMSG_C_TRADE_0014,COLOR_TRADE);//"ŷ Ϸ Ǿϴ."
	// 2003.10.14, ŷ
	g_pGameMain->m_pTrade->EndTrade();

	// 2008-10-20 by bhsohn ŷ â 
	g_pGameMain->m_pInven->ShowInven(NULL, NULL);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeCancelTradeOk(MSG_FC_TRADE_CANCEL_TRADE_OK* pMsg)
/// \brief		MSG_FC_TRADE_CANCEL_TRADE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeCancelTradeOk(MSG_FC_TRADE_CANCEL_TRADE_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeCancelTradeOk(MSG_FC_TRADE_CANCEL_TRADE_OK* pMsg)");
	// ŷâ ִ  â ̵Ѵ.
	// 2003.20.14 ŷ
//	vector<CItemInfo*>::iterator it = g_pGameMain->m_pTrade->m_vecMyStore.begin();
//	while(it != g_pGameMain->m_pTrade->m_vecMyStore.end())
//	{
//		ITEM_GENERAL* pItem = (ITEM_GENERAL*)(*it);
//		g_pStoreData->PutItem((char *)pItem, TRUE);//update
//		it++;
//	}
//	g_pGameMain->m_pInven->SetItemSpi(g_pGameMain->m_pInven->GetItemSpi() +
//		g_pGameMain->m_pTrade->m_nMyStoreSpi);
//	m_pShuttleChild->ResortingItem();
//	m_pShuttleChild->SetShuttleData(5);
//	g_pGameMain->m_pInven->SetAllIconInfo();
//	g_pGameMain->m_pTrade->EndTrade();

	// ŷ 
	g_pGameMain->m_pTrade->CancelTrade();
	m_pChat->CreateChatChild(STRMSG_C_TRADE_0015,COLOR_TRADE);//"ŷ  Ǿϴ."

	// 2008-10-20 by bhsohn ŷ â 
	g_pGameMain->m_pInven->ShowInven(NULL, NULL);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeDeleteItem(MSG_FC_TRADE_DELETE_ITEM* pMsg)
/// \brief		MSG_FC_TRADE_DELETE_ITEM
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeDeleteItem(MSG_FC_TRADE_DELETE_ITEM* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeDeleteItem(MSG_FC_TRADE_DELETE_ITEM* pMsg)");
///	g_pStoreData->DeleteItemAndEnchant( pMsg->ItemUniqueNumber );
	DBGOUT("MSG_FC_TRADE_DELETE_ITEM\n");

	// 2006-07-31 by ispark,  
	//if(pMsg->ItemDeletionType != g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
	// ߸ 񱳹 . 2010. 08. 02. by hsLee.
	if( pMsg->ItemUniqueNumber != g_pGameMain->m_pInven->GetItemSpiUniqueNumber() )
	{
		CItemInfo* pItem = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
//		if(pItem && pMsg->ItemDeletionType == IUT_BAZAAR_SELL)
		if(pMsg->ItemDeletionType == IUT_BAZAAR_SELL)
		{
			g_pD3dApp->m_bRequestEnable = TRUE;
			g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
			char ShopResult[128] = {0,};
			if(g_pInterface->m_pBazaarShop)
			{
				// 
				if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 1)
				{
					// 2006-09-04 by ispark,  κ  ʰ    Ʈ ִ.
					CItemInfo* pOpenItem = g_pInterface->m_pBazaarShop->GetShopItemInfo(pMsg->ItemUniqueNumber);
					if(IS_COUNTABLE_ITEM(pOpenItem->ItemInfo->Kind))
					{
						wsprintf(ShopResult, STRMSG_C_060803_0003, pOpenItem->ItemInfo->ItemName, pOpenItem->CurrentCount);
					}
					else
					{
						wsprintf(ShopResult, STRMSG_C_060803_0003, pOpenItem->ItemInfo->ItemName, 1);
					}

					m_pChat->CreateChatChild(ShopResult, COLOR_SYSTEM); 
				}
			}
		}
		else if(pItem && pMsg->ItemDeletionType == IUT_BAZAAR_BUY)
		{
			g_pD3dApp->m_bRequestEnable = TRUE;
			g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
			char ShopResult[128] = {0,};
			if(g_pInterface->m_pBazaarShop)
			{
				// 湮
				if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 2)
				{
					// 2006-09-01 by dgwoo īͺ ϶  ش.
					if(IS_COUNTABLE_ITEM(pItem->ItemInfo->Kind))
					{
						wsprintf(ShopResult, STRMSG_C_060803_0003, pItem->ItemInfo->ItemName, pItem->CurrentCount);
					}
					else
					{
						wsprintf(ShopResult, STRMSG_C_060803_0003, pItem->ItemInfo->ItemName, 1);
					}
					
					m_pChat->CreateChatChild(ShopResult, COLOR_SYSTEM); 
				}
			}
		}
		else if(pItem && pMsg->ItemDeletionType == IUT_ARENA_ITEM)
		{
			char buf[128];
			wsprintf(buf, STRMSG_C_070604_0101, pItem->ItemInfo->ItemName);
			m_pChat->CreateChatChild(buf, COLOR_SYSTEM); 
		}
	}

	// 2005-03-07 by jschoi
	if(pMsg->ItemDeletionType == IUT_SHOP)
	{
		g_pD3dApp->m_bRequestEnable = TRUE;
		g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
	}

	// 2010. 08. 02 by hsLee. Ű ӽ īͺ     .
	if ( pMsg->ItemDeletionType == IUT_LUCKY_ITEM )
	{
		CINFLuckyMachine* pStore = (CINFLuckyMachine*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LUCKY);
		if ( pStore ) 
			pStore->SetDeletePrizeItem ( pMsg->ItemUniqueNumber );
	}

	// 2010-08-31 by shcho&&jskim,  ý 
	if ( pMsg->ItemDeletionType == IUT_DISSOLUTION_ITEM )
	{
		CINFDissolution* pStore = (CINFDissolution*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_DISSOLUTION);
//  		if ( pStore ) 
//  			pStore->SetDeleteItem ( pMsg->ItemUniqueNumber );
	}
	// end 2010-08-31 by shcho&&jskim,  ý 

	if(pMsg->ItemDeletionType == IUT_SKILL)
	{
		g_pShuttleChild->m_pSkill->DeleteSkill(pMsg->ItemUniqueNumber);
		if(g_pGameMain && g_pGameMain->m_pCharacterInfo)
		{
			g_pGameMain->m_pCharacterInfo->SetAllUTCInfo();
		}
	}
	else
	{
		if( g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber ) != NULL )
		{
			if(pMsg->ItemDeletionType == IUT_QUEST)
			{
				CItemInfo* pItemInfo = 
					g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
				g_pStoreData->CreateChatOfItemUpdate( pItemInfo->ItemNum, 1, 0 ); // 
			}
			g_pStoreData->DeleteItem( pMsg->ItemUniqueNumber );
			g_pGameMain->m_pInven->SetAllIconInfo();
		}
//		else if(m_dwGameState == _CITY)
		else
		{
			// â
			ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
			CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
			if(pStore)
			{
				if(pMsg->ItemUniqueNumber == pStore->GetItemSpiUniqueNumber() )
				{
					pStore->SetItemSpi( 0 );
				}
				else if( pStore->FindItemInfo( pMsg->ItemUniqueNumber ) != NULL )
				{
					pStore->DeleteItem( pMsg->ItemUniqueNumber ); // InputItemDone();
				}
			}
//			else
//			{
			// æƮ
			CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
			if(pCityLab)
			{
				DBGOUT("Delete Enchant Item\n");
				pCityLab->DeleteTargetItem( pMsg->ItemUniqueNumber );
			}
			// 丮()
			pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_FACTORY);
			if(pCityLab)
			{
				pCityLab->DeleteTargetItem( pMsg->ItemUniqueNumber );
			}
//			}			
		}
		// 2007-02-28 by bhsohn  ǸŽ 0 spi  ó
		// 0 Item   Ѵ. 
		UpdateMultiSellZeroSPIItem(pMsg->ItemUniqueNumber);		
	}
	

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeUpdateItemCount(MSG_FC_TRADE_UPDATE_ITEM_COUNT* pMsg)
/// \brief		MSG_FC_TRADE_UPDATE_ITEM_COUNT
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeUpdateItemCount(MSG_FC_TRADE_UPDATE_ITEM_COUNT* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeUpdateItemCount(MSG_FC_TRADE_UPDATE_ITEM_COUNT* pMsg)");
	// 2007-07-24 by dgwoo Ʃ丮    ¶ ޾ƿ   ó.
	//if(g_pTutorial->IsTutorialMode())
	if(g_pStoreData->IsTutorialItemBackUp())
	{		
		m_vecTutorialUpdateItem.push_back(*pMsg);
		return;
	}
	switch(pMsg->ItemUpdateType)
	{
	case IUT_ENCHANT:
		{
			CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber(  pMsg->ItemUniqueNumber );
// 2010. 04. 21 by jskim ű Ű ӽ 
// 			if(pItemInfo)
// 			{
// 				CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
// 				if(pCityLab)
// 				{
// 					if(pMsg->NewCount == pItemInfo->CurrentCount)
// 					{
// 						pCityLab->DeleteTargetItem( pMsg->ItemUniqueNumber );
// 					}
// 					else
// 					{
// 						DBGOUT("ERROR\n");
// 					}
// 				}
// 			}
// 			else if(pMsg->ItemUniqueNumber == g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
// 			{
// 				g_pGameMain->m_pInven->SetItemSpi(pMsg->NewCount);
// 			}
// 			else //   ø 
// 			{
// 			}
			if(g_pInterface->m_pCityBase->GetCurrentBuildingNPC()->buildingInfo.BuildingKind == BUILDINGKIND_LUCKY_OPTION_MACHINE)
			{
				if(pItemInfo)
				{
					CINFOptionMachine * pOptionMachine = (CINFOptionMachine*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LUCKY_OPTION_MACHINE);
					if(pOptionMachine)
					{
						if(pMsg->NewCount == pItemInfo->CurrentCount)
						{
							pOptionMachine->DeleteTargetItem( pMsg->ItemUniqueNumber );
						}

					}
				}
			}
			else if(g_pInterface->m_pCityBase->GetCurrentBuildingNPC()->buildingInfo.BuildingKind == BUILDINGKIND_LABORATORY)
			{
				if(pItemInfo)
				{
					CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
					if(pCityLab)
					{
						if(pMsg->NewCount == pItemInfo->CurrentCount)
						{
							pCityLab->DeleteTargetItem( pMsg->ItemUniqueNumber );
						}
						else
						{
							DBGOUT("ERROR\n");
						}
					}
				}
				else if(pMsg->ItemUniqueNumber == g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
				{
					g_pGameMain->m_pInven->SetItemSpi(pMsg->NewCount);
				}
				else //   ø 
				{
				}
			}
//end 2010. 04. 21 by jskim ű Ű ӽ 
		}
		break;
	case IUT_MIXING:
		{
			CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber(  pMsg->ItemUniqueNumber );
			if(pItemInfo)
			{
				CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_FACTORY);
				if(pCityLab)
				{
					if(pMsg->NewCount - pItemInfo->CurrentCount > 0)
					{
						ITEM_GENERAL item;
						item = (ITEM_GENERAL)(*pItemInfo);
						item.CurrentCount = pMsg->NewCount - pItemInfo->CurrentCount;
						pCityLab->PutTargetItem(&item);
						DBGOUT("Mix Result : (MSG_FC_TRADE_UPDATE_ITEM_COUNT):ItemNum[%d],NewCount[%d]-CurrentCount[%d]\n",pItemInfo->ItemNum, pMsg->NewCount, pItemInfo->CurrentCount);
					}
					else if(pMsg->NewCount - pItemInfo->CurrentCount == 0)
					{
						pCityLab->DeleteTargetItem( pMsg->ItemUniqueNumber );
					}
				}
			}
			else if(pMsg->ItemUniqueNumber == g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
			{
				g_pGameMain->m_pInven->SetItemSpi(pMsg->NewCount);
			}
		}
		break;
	case IUT_TUTORIAL_PAY_ITEM:
	case IUT_GENERAL:
	case IUT_DROP_ITEM:
	case IUT_TRADE:
	case IUT_SHOP:
	case IUT_QUEST:
	case IUT_ADMIN:
	case IUT_BULLET:
	case IUT_LOADING:
	case IUT_AUCTION:	
// 	case IUT_ENCHANT:	
	case IUT_USE_ITEM:
	case IUT_INFLUENCEWAR_KILLER_BONUS:
	case IUT_BONUS_ITEM:
	case IUT_BAZAAR_SELL:
	case IUT_BAZAAR_BUY:
	default:
		{
			// 2005-08-19 by ispark
			if(pMsg->ItemUniqueNumber == g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
			{
				if(pMsg->ItemUpdateType == IUT_PENALTY_ON_DEAD)
				{
					// 
					char RepairPay[128];
					wsprintf(RepairPay, STRMSG_C_050819_0102, g_pGameMain->m_pInven->GetItemSpi() - pMsg->NewCount);
					m_pChat->CreateChatChild(RepairPay, COLOR_SYSTEM,CHAT_TAB_SYSTEM);
				}
				else if(pMsg->ItemUpdateType == IUT_PENALTY_AGEAR_FUEL_ALLIN)
				{
					// ̵
					char MovePay[128];
					wsprintf(MovePay, STRMSG_C_050819_0103, g_pGameMain->m_pInven->GetItemSpi() - pMsg->NewCount);
					m_pChat->CreateChatChild(MovePay, COLOR_SYSTEM,CHAT_TAB_SYSTEM); 
				}
				// 2006-08-03 by ispark, λ
				else if(pMsg->ItemUpdateType == IUT_BAZAAR_SELL)
				{
					char SellPay[128];
					if(g_pInterface->m_pBazaarShop)
					{
						// 
						if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 1)
						{
							wsprintf(SellPay, STRMSG_C_060803_0002, pMsg->NewCount - g_pGameMain->m_pInven->GetItemSpi());	// "%dǰ ԱݵǾϴ."
						}
						// 湮
						else if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 2)
						{
							wsprintf(SellPay, STRMSG_C_060803_0001, g_pGameMain->m_pInven->GetItemSpi() - pMsg->NewCount);	// "%dǸ Ͽϴ."
						}
					}
					m_pChat->CreateChatChild(SellPay, COLOR_SYSTEM,CHAT_TAB_SYSTEM); 
				}
				else if(pMsg->ItemUpdateType == IUT_BAZAAR_BUY)
				{
					char BuyPay[128];
					if(g_pInterface->m_pBazaarShop)
					{
						// 
						if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 1)
						{
							wsprintf(BuyPay, STRMSG_C_060803_0001, g_pGameMain->m_pInven->GetItemSpi() - pMsg->NewCount);	// "%dǸ Ͽϴ."
						}
						// 湮
						else if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 2)
						{
							wsprintf(BuyPay, STRMSG_C_060803_0002, pMsg->NewCount - g_pGameMain->m_pInven->GetItemSpi());	// "%dǰ ԱݵǾϴ."
						}
					}
					m_pChat->CreateChatChild(BuyPay, COLOR_SYSTEM,CHAT_TAB_SYSTEM); 
				}
				else if(pMsg->ItemUpdateType == IUT_TUTORIAL_PAY_ITEM)
				{
					char buf[128];
					wsprintf(buf,STRMSG_C_QUEST_0039,STRMSG_C_QUEST_0019,pMsg->NewCount - g_pGameMain->m_pInven->GetItemSpi() );
					m_pChat->CreateChatChild(buf, COLOR_SKILL_USE,CHAT_TAB_SYSTEM); 
				}
				// 2008-08-27 by bhsohn  ̺Ʈ, īͺ  Ʈ   
				// 2009-04-21 by bhsohn κ  ̺Ʈ ޽ ޽â  ذ
				// ⼭ ó ϰ TradeUpdateItemAddChat(pMsg) ϰ óϰ 
//				else if(pMsg->ItemUpdateType == IUT_GIVEEVENTITEM)
// 				{
// 					char buff[128] = {0,};
// 					CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber(  pMsg->ItemUniqueNumber );					
// 					int nCount = pMsg->NewCount;
// 					
// 					if(NULL == pItemInfo )
// 					{
// 						// SPI 
// 						int nUpdateSPI = pMsg->NewCount - g_pGameMain->m_pInven->GetItemSpi();
// 
// 						if(pMsg->ItemUniqueNumber == g_pGameMain->m_pInven->GetItemSpiUniqueNumber()
// 							&&(nUpdateSPI > 0))
// 						{
// 							wsprintf(buff,STRMSG_C_ITEM_0002,nUpdateSPI);
// 							m_pChat->CreateChatChild(buff, COLOR_ITEM);		
// 						}
// 					}
// 					else
// 					{	
// 						nCount = pMsg->NewCount - pItemInfo->CurrentCount;						
// 						if(IS_COUNTABLE_ITEM(pItemInfo->ItemInfo->Kind))
// 						{
// 							wsprintf(buff,STRMSG_C_060904_0100,pItemInfo->ItemInfo->ItemName,
// 								nCount);
// 						}
// 						else
// 						{
// 							wsprintf(buff,STRMSG_C_060904_0100,pItemInfo->ItemInfo->ItemName,1);
// 						}
// 						m_pChat->CreateChatChild(buff, COLOR_ITEM);		
// 					}				
// 				}
				// end 2009-04-21 by bhsohn κ  ̺Ʈ ޽ ޽â  ذ
				// end 2008-08-27 by bhsohn  ̺Ʈ, īͺ  Ʈ   
			}

			// 2006-07-31 by ispark,  
			if(pMsg->ItemUpdateType == IUT_BAZAAR_SELL)
			{
				g_pD3dApp->m_bRequestEnable = TRUE;
				g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
				if(pMsg->ItemUniqueNumber != g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
				{
					char ShopResult[128] = {0,};
					CItemInfo* pItem = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
					if(g_pInterface->m_pBazaarShop && pItem)
					{
						// 
						int nCount = 0;
						if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 1)
						{
							int nBazaarShopItemCount = g_pInterface->m_pBazaarShop->GetShopItemCount(pMsg->ItemUniqueNumber);
							nCount = (pItem->CurrentCount + nBazaarShopItemCount) - pMsg->NewCount;
							wsprintf(ShopResult, STRMSG_C_060803_0003, pItem->ItemInfo->ItemName, nCount);
						}
						// 湮
						else if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 2)
						{
							nCount = pMsg->NewCount - pItem->CurrentCount;
							wsprintf(ShopResult, STRMSG_C_060519_0000, pItem->ItemInfo->ItemName, nCount);
						}
						
						m_pChat->CreateChatChild(ShopResult, COLOR_SYSTEM,CHAT_TAB_SYSTEM);
					}
				}
			}
			else if(pMsg->ItemUpdateType == IUT_BAZAAR_BUY)
			{
				g_pD3dApp->m_bRequestEnable = TRUE;
				g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
				if(pMsg->ItemUniqueNumber != g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
				{
					char ShopResult[128] = {0,};
					CItemInfo* pItem = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
					if(g_pInterface->m_pBazaarShop && pItem)
					{
						// 
						int nCount = 0;
						if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 1)
						{
							nCount = pMsg->NewCount - pItem->CurrentCount;
							wsprintf(ShopResult, STRMSG_C_060519_0000, pItem->ItemInfo->ItemName, nCount);
						}
						// 湮
						else if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 2)
						{
							nCount = pItem->CurrentCount - pMsg->NewCount;
							wsprintf(ShopResult, STRMSG_C_060803_0003, pItem->ItemInfo->ItemName, nCount);
						}

						m_pChat->CreateChatChild(ShopResult, COLOR_SYSTEM,CHAT_TAB_SYSTEM); 
					}
				}
			}
			
			// 2005-03-07 by jschoi
			if(pMsg->ItemUpdateType == IUT_SHOP)
			{
				g_pD3dApp->m_bRequestEnable = TRUE;
				g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;

				// 2006-05-19 by ispark, 
				if(pMsg->ItemUniqueNumber != g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
				{
					CItemInfo* pItem = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
					int nCount = pMsg->NewCount;
					if(pItem)
						nCount = pMsg->NewCount - pItem->CurrentCount;
					char ShopResult[128];
					if(nCount > 0)
					{
						wsprintf(ShopResult, STRMSG_C_060519_0000, pItem->ItemInfo->ItemName, nCount);
						m_pChat->CreateChatChild(ShopResult, COLOR_ITEM,CHAT_TAB_SYSTEM);	
					}
				}
			}

			// 2006-04-26 by ispark, ʽ 
			// 2006-07-25 by ispark,  ó ߰
			if(pMsg->ItemUpdateType == IUT_BONUS_ITEM)
			{
				if(pMsg->ItemUniqueNumber != g_pGameMain->m_pInven->GetItemSpiUniqueNumber())	
				{
					char buff[128];
					ZERO_MEMORY(buff);
					CItemInfo* pItem = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
					if(pItem)
					{
						int nCount = pMsg->NewCount - pItem->CurrentCount;
						wsprintf(buff,STRMSG_C_ITEM_0006, pItem->ItemInfo->ItemName, nCount);
						m_pChat->CreateChatChild(buff, COLOR_ITEM,CHAT_TAB_SYSTEM);		
					}
				}
			}
			// 2008-11-25 by dgwoo Ű ӽ.
			if(pMsg->ItemUpdateType == IUT_LUCKY_ITEM)
			{
				CINFLuckyMachine* pStore = (CINFLuckyMachine*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LUCKY);					
				pStore->SetPrizeItem(pMsg);
				break;
			}
			
			// 2010-08-31 by shcho&&jskim,  ý 
			if(pMsg->ItemUpdateType == IUT_DISSOLUTION_ITEM)
			{
				CINFDissolution* pStore = (CINFDissolution*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_DISSOLUTION);					
				pStore->SetTakeItem(pMsg);
				break;
			}
			// end 2010-08-31 by shcho&&jskim,  ý 

			// 2009-04-21 by bhsohn κ  ̺Ʈ ޽ ޽â  ذ
			// ⼭   Ʈ 
			TradeUpdateItemAddChat(pMsg);				
			// end 2009-04-21 by bhsohn κ  ̺Ʈ ޽ ޽â  ذ

			if(pMsg->ItemUniqueNumber == g_pGameMain->m_pInven->GetItemSpiUniqueNumber())
			{
				if( pMsg->ItemUpdateType == IUT_QUEST ||
					pMsg->ItemUpdateType == IUT_DROP_ITEM ||
					pMsg->ItemUpdateType == IUT_INFLUENCEWAR_KILLER_BONUS ||
					pMsg->ItemUpdateType == IUT_BONUS_ITEM)									// 2006-07-25 by ispark
				{
					g_pStoreData->CreateChatOfItemUpdate( MONEY_ITEM_NUMBER, 
						g_pGameMain->m_pInven->GetItemSpi(), pMsg->NewCount );
				}
				// 2008-12-30 by bhsohn ﺸ߰ ȹ
				else if((pMsg->ItemUpdateType == IUT_WAR_CONTRIBUTION)
					||(pMsg->ItemUpdateType == IUT_WAR_CONTRIBUTION_LEADER))
				{
					CreateChatWarContribution(pMsg->ItemUpdateType, g_pGameMain->m_pInven->GetItemSpi(), pMsg->NewCount);
				}				
				// end 2008-12-30 by bhsohn ﺸ߰ ȹ

				g_pGameMain->m_pInven->SetItemSpi(pMsg->NewCount);

				if(pMsg->ItemUpdateType == IUT_GUILD_STORE ||
					pMsg->ItemUpdateType == IUT_STORE ||
					pMsg->ItemUpdateType == IUT_STORE_FEE)
				{
					g_pD3dApp->m_bRequestEnable = TRUE;
					g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
				}
				// 2007-02-12 by bhsohn Item   ó
				//  Ǹ Ϸ
				//UpdateMultiResponseOK();
				// end 2007-02-12 by bhsohn Item   ó

				// 2008-08-18 by bhsohn 1   ̵ ý 
				IntervalSellMutltiOneItem();
				// end 2008-08-18 by bhsohn 1   ̵ ý 
			}
			else if(g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber ) != NULL)
			{
				if( pMsg->ItemUpdateType == IUT_QUEST ||
					pMsg->ItemUpdateType == IUT_DROP_ITEM ||
					pMsg->ItemUpdateType == IUT_INFLUENCEWAR_KILLER_BONUS)
				{
					CItemInfo* pItemInfo = 
						g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
					if( pMsg->ItemUpdateType == IUT_QUEST )
					{
						g_pQuestData->NoticeQuestTargetItem( pItemInfo->ItemInfo->ItemNum, pMsg->NewCount );
					}
					g_pStoreData->CreateChatOfItemUpdate( pItemInfo->ItemNum, 
						pItemInfo->CurrentCount, pMsg->NewCount );
				}

				g_pStoreData->UpdateItemCount( pMsg->ItemUniqueNumber, pMsg->NewCount );
				// 2009-04-02 by bhsohn Ű ӽ ߰ ȹ
				g_pStoreData->UpdateCoinItemCount(pMsg->ItemUniqueNumber);
				// end 2009-04-02 by bhsohn Ű ӽ ߰ ȹ

				if(pMsg->ItemUpdateType == IUT_GUILD_STORE ||
					pMsg->ItemUpdateType == IUT_STORE ||
					pMsg->ItemUpdateType == IUT_STORE_FEE)
				{
					g_pD3dApp->m_bRequestEnable = TRUE;
					g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
				}
				// 2007-02-12 by bhsohn Item   ó
				FromStoreMultiResponseOK();
			}
//			else if(m_dwGameState == _CITY) // â
			else
			{
				ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
				CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
//				ASSERT_ASSERT(pStore);
				if(pStore==NULL)
				{
					// 2006-05-15 by isparkm, ŷ κ丮 Ƿ ŷ ̽   ´.
					if(pMsg->ItemUpdateType == IUT_TRADE)
					{
						CItemInfo* pItemInfo = g_pGameMain->m_pTrade->FindTradeMyItem(pMsg->ItemUniqueNumber);
						if(pItemInfo)
						{
							g_pStoreData->PutItem((char*)((ITEM_GENERAL*)pItemInfo));
							m_pShuttleChild->ResortingItem();
							m_pShuttleChild->SetShuttleData(5);
							g_pGameMain->m_pInven->SetAllIconInfo();
						}
						return;
					}
					DBGOUT("Error : Change ItemNum\n");
					return;
				}
				if(pMsg->ItemUniqueNumber == pStore->GetItemSpiUniqueNumber() )
				{
					pStore->SetItemSpi( pMsg->NewCount );
				}
				else
				{
					ASSERT_ASSERT( pStore->FindItemInfo( pMsg->ItemUniqueNumber ) != NULL );
					pStore->UpdateItemCount( pMsg->ItemUniqueNumber, pMsg->NewCount );
				}

				// 2006-10-26 by ispark, Ȳ 
				g_pD3dApp->m_bRequestEnable = TRUE;
				g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
			}
		}
		break;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeInsertItem(MSG_FC_TRADE_INSERT_ITEM* pMsg)
/// \brief		MSG_FC_TRADE_INSERT_ITEM
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeInsertItem(MSG_FC_TRADE_INSERT_ITEM* pMsg)
{
	// 2008-08-11 by bhsohn ܵ  ǰԲ
	AddItemList(pMsg);
	// end 2008-08-11 by bhsohn ܵ  ǰԲ

	FLOG("CAtumApplication::FieldSocketTradeInsertItem(MSG_FC_TRADE_INSERT_ITEM* pMsg)");
	// 2007-07-24 by dgwoo Ʃ丮    ¶ ޾ƿ   ó.
	//if(g_pTutorial->IsTutorialMode())
	if(g_pStoreData->IsTutorialItemBackUp())
	{
		m_vecTutorialInsertItem.push_back(*pMsg);
		return;
	}

	// 2006-07-25 by ispark,  ItemInfo Ŭ̾Ʈ ּҰ ƴϴ. ׷Ƿ, ̸ ּ  ־ش.
	pMsg->ItemGeneral.ItemInfo = g_pDatabase->GetServerItemInfo(pMsg->ItemGeneral.ItemNum);

	if(ITEM_IN_CHARACTER == pMsg->ItemGeneral.ItemStorage)
	{
		switch(pMsg->ItemInsertionType)
		{
		case IUT_MIXING:
			{
				CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_FACTORY);
				if(pCityLab)
				{
					pCityLab->PutTargetItem((ITEM_GENERAL*)&(pMsg->ItemGeneral));
					DBGOUT("Mix Result : (MSG_FC_TRADE_INSERT_ITEM):ItemNum[%d]\n",pMsg->ItemGeneral.ItemNum);
				}
			}
			break;
		case IUT_SKILL: //  . SETUP_SKILL óȴ.
			{
				g_pStoreData->PutItem((char*)&(pMsg->ItemGeneral));
				g_pGameMain->m_pCharacterInfo->SetAllUTCInfo();
				//CAppEffectData * pEff = new CAppEffectData(m_pShuttleChild,RC_EFF_GET_SKILL,D3DXVECTOR3(0,0,0));
				//m_pEffectList->AddChild(pEff);
				//CINFCitySkillShop * pShop = (CINFCitySkillShop*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_SKILL_SHOP);
				//if(pShop)
				//{
				//	pShop->ReloadSkillItemList();
				//}
			}
			break;
		case IUT_TUTORIAL_PAY_ITEM:
		case IUT_GENERAL:
		case IUT_DROP_ITEM:
		case IUT_TRADE:
		case IUT_SHOP:
		case IUT_QUEST:
		case IUT_ADMIN:
		case IUT_BULLET:
		case IUT_LOADING:
		case IUT_AUCTION:	
		case IUT_ENCHANT:	
		case IUT_USE_ITEM:
		case IUT_BONUS_ITEM:
		case IUT_BAZAAR_SELL:
		case IUT_BAZAAR_BUY:
		default:
			{
				// 2006-07-31 by ispark,  
				if(pMsg->ItemInsertionType == IUT_BAZAAR_SELL)
				{
					g_pD3dApp->m_bRequestEnable = TRUE;
					g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
					char ShopResult[128] = {0,};
					if(g_pInterface->m_pBazaarShop)
					{
						// 
						if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 1)
						{
							if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
							{
								wsprintf(ShopResult, STRMSG_C_060803_0003, pMsg->ItemGeneral.ItemInfo->ItemName, pMsg->ItemGeneral.CurrentCount);
							}
							else
							{
								wsprintf(ShopResult, STRMSG_C_060803_0003, pMsg->ItemGeneral.ItemInfo->ItemName, 1);
							}
						}
						// 湮
						else if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 2)
						{
							if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
							{
								wsprintf(ShopResult, STRMSG_C_060519_0000, pMsg->ItemGeneral.ItemInfo->ItemName, pMsg->ItemGeneral.CurrentCount);
							}
							else
							{
								wsprintf(ShopResult, STRMSG_C_060519_0000, pMsg->ItemGeneral.ItemInfo->ItemName, 1);
							}
						}
					}
					m_pChat->CreateChatChild(ShopResult, COLOR_SYSTEM); 
				}
				else if(pMsg->ItemInsertionType == IUT_BAZAAR_BUY)
				{
					g_pD3dApp->m_bRequestEnable = TRUE;
					g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
					char ShopResult[128] = {0,};
					if(g_pInterface->m_pBazaarShop)
					{
						// 
						if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 1)
						{
							if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
							{
								wsprintf(ShopResult, STRMSG_C_060519_0000, pMsg->ItemGeneral.ItemInfo->ItemName, pMsg->ItemGeneral.CurrentCount);
							}
							else
							{
								wsprintf(ShopResult, STRMSG_C_060519_0000, pMsg->ItemGeneral.ItemInfo->ItemName, 1);
							}
						}
						// 湮
						else if(g_pInterface->m_pBazaarShop->GetbBazaarShopTypeState() == 2)
						{
							if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
							{
								wsprintf(ShopResult, STRMSG_C_060803_0003, pMsg->ItemGeneral.ItemInfo->ItemName, pMsg->ItemGeneral.CurrentCount);
							}
							else
							{
								wsprintf(ShopResult, STRMSG_C_060803_0003, pMsg->ItemGeneral.ItemInfo->ItemName, 1);
							}
						}
					}
					m_pChat->CreateChatChild(ShopResult, COLOR_SYSTEM); 
				}

				// 2005-03-07 by jschoi
				// 2006-07-31 by ispark, Ǹ  Ѱ Ϲݻ .
				if(pMsg->ItemInsertionType == IUT_SHOP)
				{
					g_pD3dApp->m_bRequestEnable = TRUE;
					g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;

					// 2006-05-19 by ispark, 
					char ShopResult[128] = {0,};
//					ITEM* ItemInfo = g_pDatabase->GetServerItemInfo(pMsg->ItemGeneral.ItemNum);
					if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
					{
						wsprintf(ShopResult, STRMSG_C_060519_0000, pMsg->ItemGeneral.ItemInfo->ItemName, pMsg->ItemGeneral.CurrentCount);
					}
					else
					{
						wsprintf(ShopResult, STRMSG_C_060519_0000, pMsg->ItemGeneral.ItemInfo->ItemName, 1);
					}
					m_pChat->CreateChatChild(ShopResult, COLOR_ITEM);	
				}
				// 2006-04-26 by ispark, ʽ 
				// 2006-07-24 by ispark, 
				if(pMsg->ItemInsertionType == IUT_BONUS_ITEM)
				{
					char buff[128] = {0,};
//					ITEM* ItemInfo = g_pDatabase->GetServerItemInfo(pMsg->ItemGeneral.ItemNum);
					if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
					{
						wsprintf(buff,STRMSG_C_ITEM_0006, pMsg->ItemGeneral.ItemInfo->ItemName, pMsg->ItemGeneral.CurrentCount);
					}
					else
					{
						wsprintf(buff,STRMSG_C_ITEM_0006, pMsg->ItemGeneral.ItemInfo->ItemName, 1);
					}
					m_pChat->CreateChatChild(buff, COLOR_ITEM,CHAT_TAB_SYSTEM);		
				}
				// 2006-09-04 by dgwoo ̺Ʈ  ߰.
				if(pMsg->ItemInsertionType == IUT_GIVEEVENTITEM)
				{
					char buff[128] = {0,};
					if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
					{
						wsprintf(buff,STRMSG_C_060904_0100,pMsg->ItemGeneral.ItemInfo->ItemName,pMsg->ItemGeneral.CurrentCount);
					}
					else
					{
						wsprintf(buff,STRMSG_C_060904_0100,pMsg->ItemGeneral.ItemInfo->ItemName,1);
					}
					m_pChat->CreateChatChild(buff, COLOR_ITEM);		
				}
				// 2007-06-04 by dgwoo
				if(pMsg->ItemInsertionType == IUT_ARENA_ITEM
					|| pMsg->ItemInsertionType == IUT_GIVEEVENTITEM_COUPONEVENT)		// 2008-01-17 by dgwoo   Ʈ ߰.
				{
					char buff[128] = {0,};
					if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
					{
						wsprintf(buff,STRMSG_C_ITEM_0006,pMsg->ItemGeneral.ItemInfo->ItemName,pMsg->ItemGeneral.CurrentCount);
					}
					else
					{
						wsprintf(buff,STRMSG_C_ITEM_0006,pMsg->ItemGeneral.ItemInfo->ItemName,1);
					}
					m_pChat->CreateChatChild(buff, COLOR_ITEM,CHAT_TAB_SYSTEM);		
				}
				// 2008-11-25 by dgwoo Ű ӽ.
				if(pMsg->ItemInsertionType == IUT_LUCKY_ITEM)
				{
					CINFLuckyMachine* pStore = (CINFLuckyMachine*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LUCKY);					
					pStore->SetPrizeItem(pMsg->ItemGeneral);
				}

				// 2010-08-31 by shcho&&jskim,  ý 
				else if(pMsg->ItemInsertionType == IUT_DISSOLUTION_ITEM)
				{
					CINFDissolution* pStore = (CINFDissolution*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_DISSOLUTION);					
					pStore->SetTakeItem(pMsg->ItemGeneral);
				}
				// end 2010-08-31 by shcho&&jskim,  ý 
				else
				{
					g_pStoreData->PutItem((char*)&(pMsg->ItemGeneral));
				}
				// 2007-10-30 by dgwoo   ð  ѹ ش.
				if(m_bResortingItem)
				{
					m_pShuttleChild->ResortingItem();
				}
				m_pShuttleChild->SetShuttleData(5);
				g_pGameMain->m_pInven->SetScrollEndLine();						// 2006-06-21 by ispark
				g_pGameMain->m_pInven->SetAllIconInfo();

				if( pMsg->ItemInsertionType == IUT_QUEST )
				{
					g_pQuestData->NoticeQuestTargetItem( pMsg->ItemGeneral.ItemNum, pMsg->ItemGeneral.CurrentCount );
				}
				if( pMsg->ItemInsertionType == IUT_QUEST ||
					pMsg->ItemInsertionType == IUT_DROP_ITEM ||
					pMsg->ItemInsertionType == IUT_INFLUENCEWAR_KILLER_BONUS)
				{
					CItemInfo* pItemInfo = 
						g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemGeneral.UniqueNumber );

					if(pItemInfo)
					{
						if(IS_COUNTABLE_ITEM(pMsg->ItemGeneral.ItemInfo->Kind))
						{
							g_pStoreData->CreateChatOfItemUpdate(pItemInfo->ItemNum,0,pMsg->ItemGeneral.CurrentCount);
						}
						else
						{// 2007-03-15 by dgwoo ⰰ  CurrentCount Ѿ˼ ǥϱ⶧ ī Ѱ͵ 
							// 1 ǥش.
							g_pStoreData->CreateChatOfItemUpdate( pItemInfo->ItemNum, 0, 1 );
						}
					}
				}

				// 2006-10-26 by ispark
				if(pMsg->ItemInsertionType == IUT_GUILD_STORE ||
					pMsg->ItemInsertionType == IUT_STORE ||
					pMsg->ItemInsertionType == IUT_STORE_FEE)
				{
					// ȭ 
					g_pD3dApp->m_bRequestEnable = TRUE;
					g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
				}
				// 2007-02-12 by bhsohn Item   ó
				FromStoreMultiResponseOK();
			}
			break;		
		}
	}
	else // â
	{
		ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
		CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
		ASSERT_ASSERT(pStore);
		pStore->PutItem((char*)&(pMsg->ItemGeneral));

		// â  (IUT_LOADING) PUT_ITEM_DONE InputItemDone ȣ
		if(pMsg->ItemInsertionType != IUT_LOADING) 
		{
			pStore->InputItemDone();
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketStoreUpdatePossess(MSG_FC_STORE_UPDATE_POSSESS* pMsg)
/// \brief		â  ű涧
/// \author		dhkwon
/// \date		2004-08-02 ~ 2004-08-02
/// \warning	 Ѵ.(    IS_COUNTABLE_ITEM  ʴ´.
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketStoreUpdatePossess(MSG_FC_STORE_UPDATE_POSSESS* pMsg)
{
	ASSERT_IMPLIES(pMsg->FromPossess != pMsg->ToPossess, pMsg->FromPossess != 0 || pMsg->ToPossess != 0);
	ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
	
	CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
	ASSERT_ASSERT(pStore);
	if(pStore)
	{
		if(pMsg->FromPossess == 0)	// â -> â
		{
			CItemInfo* pItemInfo = pStore->FindItemInfo( pMsg->ItemUniqueNumber );
			ASSERT_ASSERT( IS_COUNTABLE_ITEM(pItemInfo->Kind) == FALSE );
			CItemInfo* pNewItemInfo = new CItemInfo((ITEM_GENERAL*)pItemInfo);
			pNewItemInfo->ItemWindowIndex = POS_INVALID_POSITION;

			// 2010. 02. 11 by ckPark ߵ 
			//pNewItemInfo->SetEnchantParam( pItemInfo->GetEnchantParamFactor(), pItemInfo->GetEnchantNumber() );
			// ߵ æƮ , Ÿ  ߰ 
			pNewItemInfo->CopyItemInfo( pItemInfo );
			// end 2010. 02. 11 by ckPark ߵ 

			pStore->DeleteItem( pMsg->ItemUniqueNumber ); // InputItemDone();
			g_pStoreData->AddItemDataToUniqueNumberAndWindowPosition( pNewItemInfo );
			g_pGameMain->m_pInven->SetAllIconInfo();
		}
		else if(pMsg->ToPossess == 0) // â -> â
		{
			CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
			ASSERT_ASSERT( IS_COUNTABLE_ITEM(pItemInfo->Kind) == FALSE );
			CItemInfo* pNewItemInfo = new CItemInfo((ITEM_GENERAL*)pItemInfo);

			// 2010. 02. 11 by ckPark ߵ 
			//pNewItemInfo->SetEnchantParam( pItemInfo->GetEnchantParamFactor(), pItemInfo->GetEnchantNumber() );
			// ߵ æƮ , Ÿ  ߰ 
			pNewItemInfo->CopyItemInfo( pItemInfo );
			// end 2010. 02. 11 by ckPark ߵ 

			pStore->AddItem( pNewItemInfo );
			pStore->InputItemDone();
			g_pStoreData->DeleteItem( pMsg->ItemUniqueNumber );
		}
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketStoreUpdateRareFix(MSG_FC_STORE_UPDATE_RARE_FIX* pMsg)
/// \brief		   ٴ ɼ
/// \author		ydkim
/// \date		2004-12-03 by ydkim
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketStoreUpdateRareFix(MSG_FC_STORE_UPDATE_RARE_FIX* pMsg)
{
//	if( g_pStoreData->PutEnchant(pMsg) == FALSE )
//	{
//		if( m_dwGameState == _CITY )
//		{
//			ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
//			CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
//			if(pStore)
//			{
//				pStore->AddEnchantItem( pMsg->Enchant.TargetItemUniqueNumber, pMsg->Enchant.EnchantItemNum );
//			}
//			CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
//			if(pCityLab)
//			{
//				pCityLab->PutEnchant( pMsg );
//			}
//		}
//	}
	ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);

	if( g_pStoreData->PutRareInfo(pMsg) == FALSE )
	{
// 2010. 04. 21 by jskim ű Ű ӽ 
// 		CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
// 		if(pCityLab)
// 		{
// 			pCityLab->PutRareInfo( pMsg );
// 		}
		if(g_pInterface->m_pCityBase->GetCurrentBuildingNPC()->buildingInfo.BuildingKind == BUILDINGKIND_LUCKY_OPTION_MACHINE)
		{
			CINFOptionMachine * pOptionMachine = (CINFOptionMachine*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LUCKY_OPTION_MACHINE);
			if(pOptionMachine)
			{
				pOptionMachine->PutRareInfo( pMsg );
			}
		}
		else if(g_pInterface->m_pCityBase->GetCurrentBuildingNPC()->buildingInfo.BuildingKind == BUILDINGKIND_LABORATORY)
		{
			CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
			if(pCityLab)
			{
				pCityLab->PutRareInfo( pMsg );
			}
		}
//end 2010. 04. 21 by jskim ű Ű ӽ 
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketStoreUpdateEndurance(MSG_FC_STORE_UPDATE_ENDURANCE* pMsg)
/// \brief		  Ǵ 
/// \author		dhkwon
/// \date		2004-05-14 ~ 2004-05-14
/// \warning	  
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketStoreUpdateEndurance(MSG_FC_STORE_UPDATE_ENDURANCE* pMsg)
{
	//DBGOUT("\n",pMsg->ItemUniqueNumber, pMsg->Endurance);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeTransItemOk(MSG_FC_TRADE_TRANS_ITEM_OK* pMsg)
/// \brief		MSG_FC_TRADE_TRANS_ITEM_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeTransItemOk(MSG_FC_TRADE_TRANS_ITEM_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeTransItemOk(MSG_FC_TRADE_TRANS_ITEM_OK* pMsg)");
	CItemInfo* pItem = new CItemInfo(&pMsg->TradeItem);
	if(g_pGameMain->m_pTrade)
	{
		g_pGameMain->m_pTrade->AddItem(pItem, 0);
		for(int i=0;i<pMsg->NumOfEnchants;i++)
		{
			INT nEnchantItemNum = 
				*(INT*)(((char*)pMsg)+sizeof(MSG_FC_TRADE_TRANS_ITEM_OK)+sizeof(INT)*i);
			g_pGameMain->m_pTrade->AddEnchantItem( pMsg->TradeItem.UniqueNumber, nEnchantItemNum );

//			TRADE_ENCHANT_INFO* pEnchant = 
//				(TRADE_ENCHANT_INFO*)(((char*)pMsg)+sizeof(MSG_FC_TRADE_TRANS_ITEM_OK)+sizeof(TRADE_ENCHANT_INFO)*i);
//			g_pGameMain->m_pTrade->AddEnchantItem(pMsg->TradeItem.UniqueNumber, pEnchant->DestParam, pEnchant->ParamValue);
		}
		MSG_FC_TRADE_SEE_ITEM sMsg;
		memset(&sMsg,0x00,sizeof(sMsg));
		char buffer[SIZE_MAX_PACKET];
		sMsg.CharacterUniqueNumber = pMsg->CharacterUniqueNumber;
		sMsg.ItemNum = pMsg->TradeItem.ItemNum;
		sMsg.ItemUniqueNumber = pMsg->TradeItem.UniqueNumber;
		sMsg.Amount = pMsg->TradeItem.CurrentCount;
		int nType = T_FC_TRADE_SEE_ITEM;
		memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
		memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
		m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeSeeItemOk(MSG_FC_TRADE_SEE_ITEM_OK* pMsg)
/// \brief		MSG_FC_TRADE_SEE_ITEM_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeSeeItemOk(MSG_FC_TRADE_SEE_ITEM_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeSeeItemOk(MSG_FC_TRADE_SEE_ITEM_OK* pMsg)");
	//   Ʈ TradeǰƮ ̵Ѵ.
//	CItemInfo* pItemInfo = new CItemInfo((ITEM_GENERAL*)((char*)pMsg+sizeof(MSG_FC_TRADE_SEE_ITEM_OK)));
	if(((ITEM_GENERAL*)((char*)pMsg+sizeof(MSG_FC_TRADE_SEE_ITEM_OK)))->ItemNum == MONEY_ITEM_NUMBER )
	{
		CItemInfo* pTradeItem = new CItemInfo(((ITEM_GENERAL*)((char*)pMsg+sizeof(MSG_FC_TRADE_SEE_ITEM_OK))));
		if(g_pGameMain->m_pTrade)
		{
			g_pGameMain->m_pTrade->AddItem(pTradeItem, 1);
		}
	}
	else
	{
		CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber( ((ITEM_GENERAL*)((char*)pMsg+sizeof(MSG_FC_TRADE_SEE_ITEM_OK)))->UniqueNumber );
		ASSERT_ASSERT( pItemInfo != NULL );
		if( pItemInfo )
		{
			CItemInfo* pTradeItem = new CItemInfo((ITEM_GENERAL*)pItemInfo);

			// 2010. 02. 11 by ckPark ߵ 
			//pTradeItem->SetEnchantParam( pItemInfo->GetEnchantParamFactor(), pItemInfo->GetEnchantNumber() );
			// ߵ æƮ , Ÿ  ߰ 
			pTradeItem->CopyItemInfo( pItemInfo );
			// end 2010. 02. 11 by ckPark ߵ 

			// 2003.10.14, ŷ
			pTradeItem->CurrentCount = ((ITEM_GENERAL*)((char*)pMsg+sizeof(MSG_FC_TRADE_SEE_ITEM_OK)))->CurrentCount;
			if(g_pGameMain->m_pTrade)
			{
				g_pGameMain->m_pTrade->AddItem(pTradeItem, 1);
			}
		}
	}
}
// 2010-06-15 by shcho&hslee ý - ŷ    recv
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeSeePetData(MSG_TRADE_PET_DATA* pMsg)
/// \brief		MSG_TRADE_PET_DATA (commandMsg : T_FC_TRADE_SEE_PET_DATA)
/// \author		shcho&hslee				// 2010-06-15 by shcho&hslee ý - ŷ    
/// \date		2010-08-09 ~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeSeePetData(MSG_TRADE_PET_DATA* pMsg)
{
	FLOG("CAtumApplication::FieldSocketTradeSeeItemOk(MSG_TRADE_PET_DATA* pMsg)");
	vector<CItemInfo*>::iterator it = g_pGameMain->m_pTrade->m_vecOtherStore.begin();
	while(it != g_pGameMain->m_pTrade->m_vecOtherStore.end())
	{
		CItemInfo* pItem = (*it);
		pItem->SetPetExp(pMsg->PetExp);
//		pItem->SetPetEnableLevelUp(pMsg->EnableLevelUp);				//2011-10-06 by jhahn Ʈ  ý
//		pItem->SetReName(pMsg->EnableEditPetName);						//2011-10-06 by jhahn Ʈ  ý
		pItem->SetPetLevel(pMsg->PetLevel);
		it++;
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeSeePetData(MSG_TRADE_PET_DATA* pMsg)
/// \brief		MSG_TRADE_PET_DATA (commandMsg : T_FC_TRADE_DELETE_CURRENT_PET_DATA)
/// \author		shcho&hslee				// 2010-06-15 by shcho&hslee ý - ŷ    
/// \date		2010-08-09 ~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeDeletePetData(MSG_TRADE_PET_DATA* pMsg)
{	//  Լ ߰
	g_pShuttleChild->GetPetManager()->DeletePetCurrentData(pMsg->CreatedPetUID);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketTradeSeePetData(MSG_TRADE_PET_DATA* pMsg)
/// \brief		MSG_TRADE_PET_DATA (commandMsg : T_FC_TRADE_INSERT_CURRENT_PET_DATA)
/// \author		shcho&hslee				// 2010-06-15 by shcho&hslee ý - ŷ    
/// \date		2010-08-09 ~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTradeInsertPetData(MSG_FC_ITEM_PET_BASEDATA* pMsg)
{
	g_pShuttleChild->PutPetInfo(pMsg);
}
// ends 2010-06-15 by shcho&hslee ý - ŷ    recv

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketSkillUseSkill(MSG_FC_SKILL_USE_SKILL_OK *pMsg)
/// \brief		MSG_FC_SKILL_USE_SKILL_OK
/// \author		jschoi
/// \date		2004-11-01 ~ 2004-11-01
/// \warning	1.   ų  ϴ 쿡 
///				   켱  ųŸ(SKILL_BASE_NUM) ų ̶ 켱  .
///				2.   ų   Ѵ.
///				3. ̹  Ʈ  쿡 Ʈ Ѵ.
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketSkillUseSkill(MSG_FC_SKILL_USE_SKILL_OK *pMsg)
{
	FLOG("CAtumApplication::FieldSocketSkillUseSkill(MSG_FC_SKILL_USE_SKILL_OK *pMsg)");
	
	// 2007-04-05 by bhsohn   ó
	//  ųʱȭ
	g_pShuttleChild->m_pSkill->InitPreSkillItemNum();

 	if(pMsg->TargetIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		BOOL bDeleteUsingSkill			= FALSE;
		BOOL bDeleteEnemyUsingSkill		= FALSE;

		ITEM* pItem = g_pDatabase->GetServerItemInfo(pMsg->SkillItemID.ItemNum);

		if(SKILLTYPE_TIMELIMIT == pItem->SkillType)
		{// 2007-01-04 by dgwoo ð ų  Ѵ.
			bDeleteUsingSkill			= TRUE;
			bDeleteEnemyUsingSkill		= TRUE;
		}
		else if(pMsg->AttackIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			bDeleteUsingSkill			= TRUE;
		}
		else
		{
			bDeleteEnemyUsingSkill		= TRUE;
		}
		
		if(bDeleteUsingSkill)
		{// 2007-01-04 by dgwoo   ų߿ ˻Ͽ .
			CSkillInfo *pSkillInfo = g_pShuttleChild->m_pSkill->FindUsingSkillInfoByBaseNum(pMsg->SkillItemID.ItemNum);
			if(pSkillInfo)
			{
				g_pGameMain->m_pInfSkill->DeleteSkillInfo(pSkillInfo);
				pSkillInfo->ReleaseParamFactor();
// 2007-01-16 by dgwoo   ų ϸ  Ÿӱ  Ǿ  ų ִ.
//				g_pShuttleChild->m_pSkill->EraseUsingSkill(pSkillInfo);
				// 2008-12-26 by bhsohn    
				if(bDeleteEnemyUsingSkill)
				{
					//      ų ´ٸ   .
					g_pShuttleChild->m_pSkill->EraseLowLVUsingSkill(pMsg->AttackIndex, pMsg->SkillItemID.ItemNum);
				}
				// end 2008-12-26 by bhsohn    
			}
		}
		if(bDeleteEnemyUsingSkill)
		{// 2007-01-04 by dgwoo ٸ  ų߿ ˻Ͽ .
			// ̶  BASENUM ų  ̹ ϰ ִ   ų  .
			CSkillInfo *pSkillInfo = g_pShuttleChild->m_pSkill->FindEnemyUsingSkillForMeInfoByBaseNum(pMsg->SkillItemID.ItemNum);
			if(pSkillInfo)
			{
				g_pGameMain->m_pInfSkill->DeleteSkillInfo(pSkillInfo);
				pSkillInfo->ReleaseParamFactor();
				g_pShuttleChild->m_pSkill->EraseUsingSkill(pSkillInfo,TRUE);
			}
		}

		if(pMsg->AttackIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{	//   ų  ϴ 
			//  ųŸ(SKILL_BASE_NUM) ų ̶ 켱  .

			// 2009-03-31 by bhsohn 1Ī   ,  
			if(SKILL_BASE_NUM(pMsg->SkillItemID.ItemNum) == AGEAR_SKILL_BASENUM_AIRSIEGEMODE)
			{
				// 1Ī ̸ , 3Ī  
				if(CAMERA_TYPE_FPS == g_pSOption->sEyePt)
				{
					g_pD3dApp->m_pCamera->SetCamType( CAMERA_TYPE_NORMAL);
				}
			}
			// end 2009-03-31 by bhsohn 1Ī   ,  
			
			// ų Ӱ Ѵ.
			CSkillInfo* pSkillInfo = g_pShuttleChild->m_pSkill->FindItemSkill(pMsg->SkillItemID.ItemNum);
			if(pSkillInfo)
			{
				pSkillInfo->Init();
				// 2005-11-25 by ispark, Ʈ ų̸   Ʈ ų .
				if(pSkillInfo->ItemInfo->SkillType == SKILLTYPE_CLICK &&
					SKILL_KIND(pSkillInfo->ItemNum) == SKILL_KIND_CONTROL)
				{
					g_pShuttleChild->m_pSkill->ReleaseAllUsingControlSkill(pSkillInfo->ItemNum);
				}

				// 2007-01-09 by dgwoo   ų 츸 ų Ѵ.
				//  ų  ÿ ̷ ̹ ų vecUsingSkill   
				// spҸ ų Ҽ ִ.
				CSkillInfo* pUsingSkillInfo = g_pShuttleChild->m_pSkill->FindUsingSkillInfo(pMsg->SkillItemID.ItemNum);
				if(NULL == pUsingSkillInfo)
				{
					return;
				}
				pSkillInfo->SetClientIndex(pMsg->AttackIndex, pMsg->TargetIndex);
				pSkillInfo->UseSkillFromServer();
// 2007-01-10 by dgwoo UseSkillFromServer()Լ ó.
//				pSkillInfo->SetCheckEnableTime();
//				pSkillInfo->SetCheckReattackTime();
				//g_pShuttleChild->m_pSkill->m_vecUsingSkill.push_back(pSkillInfo);
			}

			// 2006-07-28 by ispark, ڸʿ λ
			if(IS_BAZAAR_SKILL(pSkillInfo->ItemInfo))
			{
				g_pInterface->OpenBazaarShop(pSkillInfo->ItemInfo);
			}
		}
		else
		{ // Ÿ   ų  ų ϰ ߰Ѵ.

			CSkillInfo* pSkillInfo = g_pShuttleChild->m_pSkill->FindEnemyUsingSkillForMeInfo(pMsg->SkillItemID.ItemNum);
			if(NULL == pSkillInfo)
			{
				// ٸ  ų  ų (ITEM_SKILL*) ´.
				ITEM_SKILL itemSkill;
				memset(&itemSkill, 0x00, sizeof(ITEM_SKILL));
				itemSkill.ItemInfo		= g_pDatabase->GetServerItemInfo(pMsg->SkillItemID.ItemNum);
				itemSkill.ItemNum		= itemSkill.ItemInfo->ItemNum;
				itemSkill.Kind			= itemSkill.ItemInfo->Kind;
				itemSkill.UniqueNumber	= pMsg->SkillItemID.ItemUID;
				
				//    ų ϰ Ѵ.
				pSkillInfo	= g_pShuttleChild->m_pSkill->FindItemEnemySkillInfo(pMsg->SkillItemID.ItemNum);
				if(NULL == pSkillInfo)
				{
					pSkillInfo = new CSkillInfo(&itemSkill);
					g_pShuttleChild->m_pSkill->m_mapEnemySkillInfo[pMsg->SkillItemID.ItemNum] = pSkillInfo;
				}

				pSkillInfo->SetClientIndex(pMsg->AttackIndex, pMsg->TargetIndex);
				pSkillInfo->UseSkillFromServer();
// 2007-01-10 by dgwoo UseSkillFromServer() Լ ó.
//				pSkillInfo->SetCheckEnableTime();
//				pSkillInfo->SetCheckReattackTime();	// 2005-11-24 by ispark
				g_pShuttleChild->m_pSkill->m_vecEnemyUsingSkillForMe.push_back(pSkillInfo);
			}
			else
			{
				pSkillInfo->Init();
				pSkillInfo->SetClientIndex(pMsg->AttackIndex, pMsg->TargetIndex);
				pSkillInfo->UseSkillFromServer();
// 2007-01-10 by dgwoo UseSkillFromServer() Լ ó.
//				pSkillInfo->SetCheckEnableTime();
//				pSkillInfo->SetCheckReattackTime();	// 2005-11-24 by ispark
			}
		}

		// effect
		if(	g_pShuttleChild->m_pSkillEffect)
		{
			if(g_pShuttleChild->m_pSkillEffect->FindSkillEffect(pMsg->SkillItemID.ItemNum))
			{ // ̹  ų ִٸ..
				g_pShuttleChild->m_pSkillEffect->ChangeBodyCondition(pMsg->SkillItemID.ItemNum,BODYCON_USE_SKILL_MASK);
			}
			// 2009-04-07 by bhsohn ¡   
			else if(BGEAR_STATE_CHARINGSHOT == SKILL_BASE_NUM(pMsg->SkillItemID.ItemNum))
			{
				g_pShuttleChild->m_pSkillEffect->CreateSkillEffect(pMsg->SkillItemID.ItemNum, BODYCON_USE_SKILL_MASK);
			}
			// end 2009-04-07 by bhsohn ¡   
			else
			{ //  ų ٸ Ѵ.
				// Ʈ - ߿ ٲ..
				// 2005-08-23 by ispark
				ITEM* pItem = g_pDatabase->GetServerItemInfo(pMsg->SkillItemID.ItemNum);
				CAppEffectData* pEff = new CAppEffectData(g_pShuttleChild,SKILL_BASE_NUM(pItem->SourceIndex),D3DXVECTOR3(0,0,0));
				if(pEff->m_bUsing == TRUE )
				{
					pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
				}
				else
				{
					delete pEff;
				}
			}			
		}
	}
	else
	{
		// Enemy skill ߵ
		CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->TargetIndex );
		if(pUnit)
		{
			// 2006-11-21 by ispark,  ų   ó ߰
			((CEnemyData *)pUnit)->UseSkillFromServer(pMsg->SkillItemID.ItemNum);
			ITEM* pItem = g_pDatabase->GetServerItemInfo(pMsg->SkillItemID.ItemNum);
			
			// 2007-04-02 by bhsohn MoveŶ   üũ
			UpdateEnemySkillState(true, pUnit, pMsg->TargetIndex, pMsg->SkillItemID.ItemNum);
						
			if(pUnit->m_pSkillEffect)
			{
				if(pUnit->m_pSkillEffect->FindSkillEffect(pMsg->SkillItemID.ItemNum))
				{ 
					// ̹  ų ִٸ..
					pUnit->m_pSkillEffect->ChangeBodyCondition(pMsg->SkillItemID.ItemNum,BODYCON_USE_SKILL_MASK);
				}
				else
				{ //  ų ٸ Ѵ.

					// Ʈ - ߿ ٲ..
					// 2005-08-23 by ispark
					CAppEffectData* pEff = new CAppEffectData(pUnit,SKILL_BASE_NUM(pItem->SourceIndex),D3DXVECTOR3(0,0,0));
					if(pEff->m_bUsing)
					{
						pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					}
					else
					{
						delete pEff;
					}
				}
			}

			// 2006-12-08 by ispark,   ų Ե  ϴ Ʈ
			if(g_pShuttleChild->m_pSkillEffect
				&& g_pShuttleChild->m_pSkillEffect->CheckTargetSkillEffect(pMsg->SkillItemID.ItemNum)
				&& !IsInfluenceCharacter(g_pShuttleChild->m_myShuttleInfo.InfluenceType,((CEnemyData *)pUnit)->m_infoCharacter.CharacterInfo.InfluenceType)	//϶.
				&& D3DXVec3Length(&(g_pShuttleChild->m_vPos - pUnit->m_vPos)) < pItem->Range			//ĵų  ÿ Ʈ ߻.
				&& g_pShuttleChild->GetUnitAlphaState() != CL_SKILL_NONE)						//ų  .
			{
				if(g_pShuttleChild->m_pSkillEffect->FindSkillEffect(pMsg->SkillItemID.ItemNum))
				{ // ̹  ų ִٸ..
					g_pShuttleChild->m_pSkillEffect->ChangeBodyCondition(pMsg->SkillItemID.ItemNum, BODYCON_TARGET_USE_SKILL_MASK);
				}
				else
				{ 
					CAppEffectData* pEff = new CAppEffectData(g_pShuttleChild,SKILL_BASE_NUM(pItem->SourceIndex),D3DXVECTOR3(0,0,0));
					pEff->ChangeBodyCondition(BODYCON_TARGET_USE_SKILL_MASK);
					if(pEff->m_bUsing)
					{
						pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					}
					else
					{
						SAFE_DELETE(pEff);
					}
				}			
			}
		}
	}
}
//2011-10-06 by jhahn Ʈ  ý
VOID	CAtumApplication::FieldSocketInvenItempHidePetData(MSG_FC_ITEM_NOTIFY_WINDOW_POSITION* pMsg)
{

	CItemInfo* temp  = g_pStoreData->FindItemInInventoryByUniqueNumber(pMsg->UniqueNumber);
	temp->GetItemInfo()->Position = pMsg->ItemWindowIndex;
	temp->ItemWindowIndex = pMsg->ItemWindowIndex;


	CMapItemWindowInventoryIterator it = g_pStoreData->m_mapItemWindowPosition.begin();
	while(it != g_pStoreData->m_mapItemWindowPosition.end())
	{
		CItemInfo* pItemInfo = it->second;
		if(pItemInfo->UniqueNumber == pMsg->UniqueNumber)
		{
			pItemInfo->GetItemInfo()->Position = POS_HIDDEN_ITEM;			
			pItemInfo->ItemWindowIndex = POS_HIDDEN_ITEM;			
		//	g_pStoreData->m_mapItemWindowPosition[POS_HIDDEN_ITEM] = pSelectItem;
			g_pGameMain->m_pInven->SetSingleInvenIconInfo(pItemInfo);
			
		}		
		it++;
	}
	
	g_pShuttleChild->ResortingItem();
	g_pShuttleChild->SetShuttleData(5);
	g_pGameMain->m_pInven->SetScrollEndLine();						// 2006-06-21 by ispark
	g_pGameMain->m_pInven->SetAllIconInfo();
}	  
//end 2011-10-06 by jhahn Ʈ  ý

// 2012-07-12 by jhahn, Ʈ  ũ ߰
VOID CAtumApplication::FieldSocketInvenItempSwapPetEquipOk(MSG_FC_ITEM_PET_SWAP_CHANGE_OK* pMsg)
{	
	for (int i = 0 ; i< SIZE_MAX_PETSOCKET_SWAP_ITEM_COUNT;i++ )
	{
		g_pShuttleChild->SetEqSwabPet(pMsg->ChangeItemUID[i]);
	}
	
}


VOID CAtumApplication::FieldSocketInvenItempSwapPetEquip(MSG_FC_ITEM_PET_SWAP_SAVE_OK* pMsg)
{

	tPET_CURRENTINFO *pPetCurrentInfo = NULL;
	tPET_LEVEL_DATA *psPetLevelDataPrev = NULL;
	INVEN_DISPLAY_INFO *pInvenDisplayInfo = g_pGameMain->m_pInven->rtnPtr_AttachmentItemInfo ( POS_PET );	
	
	if (pInvenDisplayInfo)
	{
		pPetCurrentInfo = g_pShuttleChild->GetPetManager()->GetPtr_PetCurrentData ( pInvenDisplayInfo->pItem->UniqueNumber );	
		psPetLevelDataPrev = g_pDatabase->GetPtr_PetLevelData ( pPetCurrentInfo->PetIndex , pPetCurrentInfo->PetLevel );
	}
	else
		return;

	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemUID[0] = pMsg->SaveItemUID[0];
	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemNum[0] = pMsg->SaveItemNum[0];

	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemUID[1] = pMsg->SaveItemUID[1];
	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemNum[1] = pMsg->SaveItemNum[1];

	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemUID[2] = pMsg->SaveItemUID[2];
	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemNum[2] = pMsg->SaveItemNum[2];

	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemUID[3] = pMsg->SaveItemUID[3];
	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemNum[3] = pMsg->SaveItemNum[3];

	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemUID[4] = pMsg->SaveItemUID[4];
	pPetCurrentInfo->PetSwap[pMsg->SlotIndex].ItemNum[4] = pMsg->SaveItemNum[4];

}
//end 2012-07-12 by jhahn, Ʈ  ũ ߰
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketSkillCancelSkillOK(MSG_FC_SKILL_CANCEL_SKILL_OK * pMsg)
/// \brief		ų  û Ϸƴ.
/// \author		dgwoo
/// \date		2006-11-28 ~ 2006-11-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketSkillCancelSkillOK(MSG_FC_SKILL_CANCEL_SKILL_OK * pMsg)
{
	if(g_pShuttleChild->m_myShuttleInfo.ClientIndex != pMsg->ClientIndex)
	{
		CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex(pMsg->ClientIndex);
		if(pUnit)
		{
			CEnemyData* pEnemy = ((CEnemyData *)pUnit);
			pEnemy->CancelUsingSkill(pMsg->SkillItemID.ItemNum);

			// 2007-04-02 by bhsohn MoveŶ   üũ
			UpdateEnemySkillState(false, pUnit, pMsg->ClientIndex, pMsg->SkillItemID.ItemNum);

			// 2006-12-08 by ispark, ҽ  ϴ Ʈ
			// 2006-12-12 by ispark, ݴ ų Ʈ̴.
			if(pEnemy->m_pSkillEffect && pMsg->AttackSkillItemNum0)
			{
				if(pEnemy->m_pSkillEffect->FindSkillEffect(pMsg->AttackSkillItemNum0))
				{ // ̹  ų ִٸ..
					pEnemy->m_pSkillEffect->ChangeBodyCondition(pMsg->AttackSkillItemNum0, BODYCON_TARGET_USE_SKILL_MASK);
				}
				else
				{ 
					ITEM* pItem = g_pDatabase->GetServerItemInfo(pMsg->AttackSkillItemNum0);
					CAppEffectData* pEff = new CAppEffectData(pUnit,SKILL_BASE_NUM(pItem->SourceIndex),D3DXVECTOR3(0,0,0));
					pEff->ChangeBodyCondition(BODYCON_TARGET_USE_SKILL_MASK);
					if(pEff->m_bUsing == TRUE )
					{
						pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					}
					else
					{
						SAFE_DELETE(pEff);
					}			
				}
			}
		}
	}else if(g_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex)
	{
		
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInvalidateSkill(MSG_FC_SKILL_INVALIDATE_SKILL *pMsg)
/// \brief		MSG_FC_SKILL_INVALIDATE_SKILL
/// \author		jschoi
/// \date		2004-11-01 ~ 2004-11-01
/// \warning	1. CancelSkill   ޴ ̴. 
///				2. ð  ݵ Ŭ̾Ʈ ų CancelSkill  Ѵ.
///				3. ¡ ų Ѿ ߻ ų  ˷ش.
///				4. нú ų  .
///				5.  Ŭ ų  ÿ ǹǷ  .
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FieldSocketInvalidateSkill(MSG_FC_SKILL_INVALIDATE_SKILL *pMsg)
{
	FLOG("CAtumApplication::FieldSocketInvalidateSkill(MSG_FC_SKILL_INVALIDATE_SKILL *pMsg)");
	if(pMsg->ClientIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		if(g_pShuttleChild->m_pSkillEffect)
		{
			g_pShuttleChild->m_pSkillEffect->DeleteSkillEffect(pMsg->SkillItemID.ItemNum);
		}

		// 2009. 08. 11 by ckPark   ų
		//   ų 
		char	strMessage[256];
		char*	strSkillName;
		strSkillName = g_pShuttleChild->m_pSkill->GetSkillName(pMsg->SkillItemID.ItemNum);
		CSkillInfo* pSkill	= g_pShuttleChild->m_pSkill->FindEnemyUsingSkillForMeInfo( pMsg->SkillItemID.ItemNum );
		if(	pSkill && COMPARE_BIT_FLAG( pSkill->ItemInfo->ItemAttribute, SKILL_ATTR_PARTY_FORMATION_SKILL ) )
		{ 
			g_pGameMain->m_pInfSkill->DeleteSkillInfo( pSkill, pSkill->Possess );
			wsprintf( strMessage, STRMSG_C_SKILL_0003, strSkillName );//"ų [%s]  մϴ."
			g_pD3dApp->m_pChat->CreateChatChild( strMessage, COLOR_SKILL_CANCEL,CHAT_TAB_SYSTEM );
			pSkill->ReleaseParamFactor();
		}
		// end 2009. 08. 11 by ckPark   ų

		// 2012-12-17 by bhsohn A 踮 Ʈ    ó
		ITEM* pItem = g_pDatabase->GetServerItemInfo(pMsg->SkillItemID.ItemNum);
		if(pItem)
		{
			if(SKILL_BASE_NUM(pMsg->SkillItemID.ItemNum) == AGEAR_SKILL_BASENUM_BARIAL)		
			{
				ClearPlaySearchEyeEffect(g_pShuttleChild, SKILL_BASE_NUM(pItem->SourceIndex));
			}
		}
		// END 2012-12-17 by bhsohn A 踮 Ʈ    ó

		// 2013-02-14 by mspark, M  ų Ŀ 濡  ʴ  
		if(pItem)
		{
			if(SKILL_BASE_NUM(pMsg->SkillItemID.ItemNum) == MGEAR_STATE_INVINCIBLE)		
			{
				ClearPlaySearchEyeEffect(g_pShuttleChild, SKILL_BASE_NUM(pItem->SourceIndex));
			}
		}
		// end 2013-02-14 by mspark, M  ų Ŀ 濡  ʴ  
	}
	else
	{
		// Enemy skill
		CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->ClientIndex );
		if(pUnit && pUnit->m_pSkillEffect)
		{
			ITEM* pItem = g_pDatabase->GetServerItemInfo(pMsg->SkillItemID.ItemNum);
			// 2006-07-31 by ispark, λ ų  ǳ 
			if(IS_BAZAAR_SKILL(pItem) && ((CEnemyData*)pUnit)->m_pMoveChatShop)
			{
				//  λ  ̸  
				((CEnemyData*)pUnit)->DeleteChatMoveShop();
				if(g_pInterface->m_pBazaarShop && g_pInterface->m_pBazaarShop->GetBazaarClientIndex() == pMsg->ClientIndex)
				{
					g_pInterface->m_pBazaarShop->SetbBazaarShopEnd(TRUE);
					g_pD3dApp->m_pChat->CreateChatChild(STRMSG_C_060801_0000, COLOR_ERROR);
				}
			}
			pUnit->m_pSkillEffect->DeleteSkillEffect(pMsg->SkillItemID.ItemNum);
// 2007-01-19 by dgwoo Ʈ ѹ SourceIndex ⺻ Ѵ.
//			g_pShuttleChild->m_pSkill->DisableSkillEffect(pUnit,SKILL_BASE_NUM(pMsg->SkillItemID.ItemNum));
			g_pShuttleChild->m_pSkill->DisableSkillEffect(pUnit,SKILL_BASE_NUM(pItem->SourceIndex));
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterGetAccountUniqueNumberOk(MSG_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER_OK* pMsg)
/// \brief		MSG_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterGetAccountUniqueNumberOk(MSG_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterGetAccountUniqueNumberOk(MSG_FC_CHARACTER_GET_ACCOUNTUNIQUENUMBER_OK* pMsg)");
	MSG_MT_DIAL		msgMTDial;
	msgMTDial.nCalleeAccountUniqueNumber = pMsg->AccountUniqueNumber;

	COPYDATASTRUCT	copyData;
	memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
	AV_MSG_WM_COPYDATA voIP(_1to1Call, AV_MT_DIAL, 0);
	copyData.dwData = (DWORD)voIP;
	copyData.lpData = &msgMTDial;
	copyData.cbData = sizeof(MSG_MT_DIAL);
	::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&copyData);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleRequestPkOk(MSG_FC_BATTLE_REQUEST_PK_OK* pMsg)
/// \brief		MSG_FC_BATTLE_REQUEST_PK_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	 ƹϵ 
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleRequestPkOk(MSG_FC_BATTLE_REQUEST_PK_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleRequestPkOk(MSG_FC_BATTLE_REQUEST_PK_OK* pMsg)");
	if(pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleCancelPK(void)
/// \brief		
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	ƹϵ 
///
/// \param		void
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleCancelPK(void)
{
	FLOG("CAtumApplication::FieldSocketBattleCancelPK(void)");
//	m_pShuttleChild->m_bPKMode = FALSE;
//	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.begin();
//	while(itEnemy != m_pScene->m_mapEnemyList.end())
//	{
//		itEnemy->second->SetPkState( PK_PVP, FALSE );
//		itEnemy++;
//	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeMonsterHP(MSG_FC_MONSTER_CHANGE_HP* pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_MONSTER_HP
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeMonsterHP(MSG_FC_MONSTER_CHANGE_HP* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangeMonsterHP(MSG_FC_MONSTER_CHANGE_HP* pMsg)");
	CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);
	if(itMonster != m_pScene->m_mapMonsterList.end())
	{
		itMonster->second->MonsterChangeHPFromServer(pMsg->CurrentHP);
	}

	// 2010. 03. 15 by ckPark ǴƼ ʵ 2( ó)
	if( m_pInterface && m_pInterface->m_pInfinity )
		m_pInterface->m_pInfinity->SetKeyMonsterHP( pMsg->MonsterIndex, pMsg->CurrentHP );
	// end 2010. 03. 15 by ckPark ǴƼ ʵ 2( ó)
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterShowEffectOk(MSG_FC_CHARACTER_SHOW_EFFECT_OK* pMsg)
/// \brief		 Ʈ ߻
/// \author		dhkwon
/// \date		2004-06-28 ~ 2004-06-28
/// \warning	 Ʈ .
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterShowEffectOk(MSG_FC_CHARACTER_SHOW_EFFECT_OK* pMsg)
{
	CUnitData * pUnit = m_pScene->FindUnitDataByClientIndex( pMsg->ClientIndex );
	if(pUnit)
	{
		CAppEffectData* pEffect = new CAppEffectData( pUnit, pMsg->EffectIndex, D3DXVECTOR3(0,0,0) );
		m_pEffectList->AddChild( pEffect );
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketCharacterMapEffectOk(MSG_FC_CHARACTER_SHOW_MAP_EFFECT_OK* pMsg)
/// \brief		
/// \author		// 2007-04-19 by bhsohn ġ  ߰
/// \date		2007-04-20 ~ 2007-04-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterMapEffectOk(MSG_FC_CHARACTER_SHOW_MAP_EFFECT_OK* pMsg)
{	
	ClientIndex_t  ClientIdx  = pMsg->ClientIdx;
	if(ClientIdx  == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		//  ڽ Ʈ Ѹ ʿ䰡 . 
		return;
	}
	
	CUnitData *pUnit = g_pScene->FindUnitDataByClientIndex(ClientIdx);
	if(NULL == pUnit)
	{
		return;
	}	
	D3DXVECTOR3	vPos, vVel, vUp;
	vPos = A2DX(pMsg->avec3Position);
	vVel = A2DX(pMsg->avec3Target);
	vUp = A2DX(pMsg->avec3Up);	
	
	// Vel(),Up ʹ 1000.0f ߱  븻 Ѵ. 
	D3DXVec3Normalize(&vVel, &vVel);
	D3DXVec3Normalize(&vUp, &vUp);

	// 2008-12-29 by bhsohn Ű ӽ  Ʈ ߰
	// Ʈ 
	//g_pShuttleChild->CreateScanItemEffect(pUnit, vPos, vVel, vUp, pMsg->nLifetime, pMsg->EffectIndex);
	switch(pMsg->EffectIndex)
	{
// 2012-11-29 by mspark, ġ ġ ̵ϴ ĳ ġ ϵ 
#ifdef C_SEARCHEYE_SHUTTLE_POSITION_MSPARK
	case RC_EFF_SEARCHEYE_SHUTTLE_POSITION:
		{						
			g_pD3dApp->SetPlaySearchEyeEffect(pUnit, pMsg->EffectIndex, 0);
		}
		break;
	case RC_EFF_SEARCHEYE_SHUTTLE_POSITION2:
		{
			g_pD3dApp->SetPlaySearchEyeEffect(pUnit, pMsg->EffectIndex, 0);
		}
		break;
#else
	case RC_EFF_SCAN_ITEM:
		{
			// ġ
			g_pShuttleChild->CreateScanItemEffect(pUnit, vPos, vVel, vUp, pMsg->nLifetime, pMsg->EffectIndex);
		}
		break;
	case RC_EFF_SCAN_ITEM2:
		{
			// ġ
			g_pShuttleChild->CreateScanItemEffect(pUnit, vPos, vVel, vUp, pMsg->nLifetime, pMsg->EffectIndex);
		}
		break;
#endif
// end 2012-11-29 by mspark, ġ ġ ̵ϴ ĳ ġ ϵ 
	default:
		{			
			float fVelLength = D3DXVec3Length(&vVel);
			if(fVelLength <= 0)
			{
				// ⺤ ũⰡ 0̸,   ְ  ͸ Ѵ.
				vVel = m_pCamera->GetViewDir();
				vVel.y = 0;
				D3DXVec3Normalize(&vVel,&vVel);			
			}

			// ġ ̰ ƴ Ʈ ǥ (, Űӽ Ʈ )
			CreateMyAppEffectData(pMsg->EffectIndex, vPos, vVel, vUp);
		}
		break;
	}
	// end 2008-12-29 by bhsohn Ű ӽ  Ʈ ߰

	
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleDropBundleOk(MSG_FC_BATTLE_DROP_BUNDLE_OK* pMsg)
/// \brief		MSG_FC_BATTLE_DROP_BUNDLE_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	 
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleDropBundleOk(MSG_FC_BATTLE_DROP_BUNDLE_OK* pMsg)
{
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterDeleteOtherInfo(MSG_FC_CHARACTER_DELETE_OTHER_INFO* pMsg)
/// \brief		MSG_FC_CHARACTER_DELETE_OTHER_INFO
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterDeleteOtherInfo(MSG_FC_CHARACTER_DELETE_OTHER_INFO* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterDeleteOtherInfo(MSG_FC_CHARACTER_DELETE_OTHER_INFO* pMsg)");
	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->OtherClientIndex);
	if(itEnemy != m_pScene->m_mapEnemyList.end())
	{
		DBGOUT("!!! %s Enemy Delete Other Info !!!\n", itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName);
		itEnemy->second->m_bUsing = FALSE;
//		m_pScene->DeleteFieldItemOfUnitData( itEnemy->second );
//		m_pScene->DeleteToBlockData(itEnemy->second);
//		SAFE_DELETE(itEnemy->second);
//		m_pScene->m_mapEnemyList.erase(itEnemy);
//		DBGOUT("̷͵ ? MSG_FC_CHARACTER_DELETE_OTHER_INFO\n");
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterMonsterCreated(MSG_FC_MONSTER_CREATED* pMsg)
/// \brief		MSG_FC_MONSTER_CREATED
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterMonsterCreated(MSG_FC_MONSTER_CREATED* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterMonsterCreated(MSG_FC_MONSTER_CREATED* pMsg)");
	CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);
	if(itMonster == m_pScene->m_mapMonsterList.end())
	{
		CMonsterData * pMonster = new CMonsterData(pMsg);
		m_pScene->InsertToBlockData(pMonster);
		m_pScene->m_mapMonsterList[pMsg->MonsterIndex] = pMonster;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleRequestP2PPkOk(MSG_FC_BATTLE_REQUEST_P2P_PK_OK* pMsg)
/// \brief		MSG_FC_BATTLE_REQUEST_P2P_PK_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleRequestP2PPkOk(MSG_FC_BATTLE_REQUEST_P2P_PK_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleRequestP2PPkOk(MSG_FC_BATTLE_REQUEST_P2P_PK_OK* pMsg)");
	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->SourceClientIndex);
	if(itEnemy != m_pScene->m_mapEnemyList.end())
	{
		BOOL bRejectCheck = TRUE;
		// 2006-11-07 by ispark,  Ʈ ִ   ɾ 
		vector<Reject_t>::iterator itReject = g_pGameMain->m_pCommunity->GetReject()->m_vecReject.begin();
		while(itReject != g_pGameMain->m_pCommunity->GetReject()->m_vecReject.end())
		{
			if(0 == stricmp(itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName, itReject->szRejectName))
			{
				bRejectCheck = FALSE;
				break;
			}
			itReject++;			
		}
		// 2008-06-20 by bhsohn EP3 ɼǰ ó
		// ɼǿ 1:1  
		if(bRejectCheck)
		{
			if(!g_pD3dApp->IsOptionEtc(OPTION_RADIO_MAN_TO_MAN))
			{
				bRejectCheck = FALSE;
			}
		}		
		// end 2008-06-20 by bhsohn EP3 ɼǰ ó

		if(g_pGameMain->m_pChat->m_bPKOptionFlag && bRejectCheck)
		{
			char buf[128];
			wsprintf(buf,STRMSG_C_PK_0007,itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName);//"%s԰  Ͻðڽϱ?"
			g_pGameMain->m_pInfWindow->AddMsgBox(buf, _Q_PK_REQUEST, pMsg->SourceClientIndex,0,0,0,itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName);
			g_fSendMovePacket = max(g_fSendMovePacket,20.0f);
			// 2008-07-14 by bhsohn EP3  ó
			//g_pGameMain->m_pOtherCharInfo->GetOtherCharInfo(itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName,TRUE);
			g_pGameMain->m_pCommunity->RqCharacterUserInfo(itEnemy->second->m_infoCharacter.CharacterInfo.CharacterUniqueNumber);
		}
		else
		{
			MSG_FC_BATTLE_REJECT_REQUEST_P2P_PK sMsg;
			memset(&sMsg,0x00,sizeof(sMsg));
			char buffer[SIZE_MAX_PACKET];
			int nType = T_FC_BATTLE_REJECT_REQUEST_P2P_PK;
			sMsg.SourceClientIndex = itEnemy->second->m_infoCharacter.CharacterInfo.ClientIndex;
			memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
			memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
			g_pD3dApp->m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));
			
			char buf[128];
			wsprintf(buf,STRMSG_C_PK_0008,itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName);//"\\yźλ \\y%s԰  ź Ͽϴ."
			m_pChat->CreateChatChild(buf,COLOR_SYSTEM);			
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleAcceptRequestP2PPkOk(MSG_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK* pMsg)
/// \brief		MSG_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleAcceptRequestP2PPkOk(MSG_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleAcceptRequestP2PPkOk(MSG_FC_BATTLE_ACCEPT_REQUEST_P2P_PK_OK* pMsg)");

	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->PeerClientIndex);
	if(itEnemy != m_pScene->m_mapEnemyList.end())
	{
		itEnemy->second->SetPkState(PK_PVP, TRUE);
		g_pShuttleChild->SetPkState(PK_PVP, TRUE);
		// 2007-01-30 by dgwoo PVP 1:1ϴ  ε Ѵ.
		g_pShuttleChild->SetPVPClientIndex(pMsg->PeerClientIndex);

		// 2005-05-18 by jschoi - 1:1    
		g_pShuttleChild->m_pOrderTarget = itEnemy->second;

		m_pChat->CreateChatChild(STRMSG_C_PK_0009,COLOR_PARTY);//"  Ǿϴ."
	}
	else
	{
		m_pChat->CreateChatChild(STRMSG_C_PK_0010,COLOR_PARTY);//"븦 ã Ͽϴ."
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleRejectRequestP2PPkOk(MSG_FC_BATTLE_REJECT_REQUEST_P2P_PK_OK* pMsg)
/// \brief		MSG_FC_BATTLE_REJECT_REQUEST_P2P_PK_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleRejectRequestP2PPkOk(MSG_FC_BATTLE_REJECT_REQUEST_P2P_PK_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleRejectRequestP2PPkOk(MSG_FC_BATTLE_REJECT_REQUEST_P2P_PK_OK* pMsg)");
	m_pChat->CreateChatChild(STRMSG_C_PK_0011,COLOR_TRADE);//"   Ͽϴ."
	vector<CINFMessageBox*>::iterator it = g_pGameMain->m_pInfWindow->m_vecMessageBox.begin();
	while(it != g_pGameMain->m_pInfWindow->m_vecMessageBox.end())
	{
		CINFMessageBox* pMsgBox = *it;		

		//  1:1  
		if(_Q_PK_REQUEST == pMsgBox->m_nMsgType)
		{
			MSG_FC_BATTLE_REJECT_REQUEST_P2P_PK sMsg;
			memset(&sMsg,0x00,sizeof(sMsg));
			char buffer[SIZE_MAX_PACKET];
			int nType = T_FC_BATTLE_REJECT_REQUEST_P2P_PK;
			sMsg.SourceClientIndex = pMsgBox->m_dwData;
			memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
			memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
			g_pD3dApp->m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));
			pMsgBox->m_dwData = 0;
			g_pGameMain->m_pInfWindow->m_vecMessageBox.erase(it);
			delete pMsgBox;
			pMsgBox = NULL;
			continue;			
		}		
		it++;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleSurrenderP2PPkOk(MSG_FC_BATTLE_SURRENDER_P2P_PK_OK* pMsg)
/// \brief		MSG_FC_BATTLE_SURRENDER_P2P_PK_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleSurrenderP2PPkOk(MSG_FC_BATTLE_SURRENDER_P2P_PK_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleSurrenderP2PPkOk(MSG_FC_BATTLE_SURRENDER_P2P_PK_OK* pMsg)");
	if(m_pChat)
		m_pChat->CreateChatChild(STRMSG_C_PK_0012,COLOR_TRADE);//" ׺ û Ͽϴ."
	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->SourceClientIndex);
	if(itEnemy != m_pScene->m_mapEnemyList.end())
	{
		char buf[128];
		wsprintf(buf,STRMSG_C_PK_0013,itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName);//"%s ׺ ޾Ƶ̽ðڽϱ?"
		g_pGameMain->m_pInfWindow->AddMsgBox(buf, _Q_PK_LOSE_REQUEST_OK, pMsg->SourceClientIndex,0,0,0,itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangeCharacterMent(MSG_FC_CHARACTER_CHANGE_CHARACTER_MENT* pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_CHARACTER_MENT
/// \author		ydkim
/// \date		
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangeCharacterMent(MSG_FC_CHARACTER_CHANGE_CHARACTER_MENT* pMsg)
{
	int temp,temp2;
	char buf[2][512];
	memset(buf, 0x00, 512*2);

	strncpy( buf[0], pMsg->szCharacterMent1, sizeof(pMsg->szCharacterMent1));
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(buf[0], &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(buf[0],&temp,&temp2);
	strncpy( buf[1], buf[0], sizeof(buf[0]));

	if(pMsg->ClientIdx == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		// ĳ Ʈ ̸
		memset(&g_pGameMain->m_pChat->m_strMyMent,0x00,sizeof(g_pGameMain->m_pChat->m_strMyMent));
		strncpy( g_pGameMain->m_pChat->m_strMyMent, buf[1], sizeof(buf[1]));
	}
	else
	{
		// ٸ ĳ Ʈ ̸

		CEnemyData * pEnemy = (CEnemyData*)g_pScene->FindUnitDataByClientIndex(pMsg->ClientIdx);
		// 2006-05-03 by ispark, ٸ ̸  ʰ Ѵ.
		if(pEnemy && IsInfluenceCharacter(g_pShuttleChild->m_myShuttleInfo.InfluenceType, pEnemy->m_infoCharacter.CharacterInfo.InfluenceType))
		{
				memset(pEnemy->m_infoCharacter.CharacterInfo.szCharacterMent,0x00,SIZE_STRING_32);
				strncpy( pEnemy->m_infoCharacter.CharacterInfo.szCharacterMent, buf[1], strlen(buf[1]));			
	//		CVecEnemyIterator itEnemy = g_pD3dApp->m_pScene->m_vecEnemyRenderList.begin();
	//		while(itEnemy != g_pD3dApp->m_pScene->m_vecEnemyRenderList.end())
	//		{
	//			if((*itEnemy)->m_infoCharacter.CharacterInfo.ClientIndex == pMsg->ClientIdx)
	//			{
	//				memset((*itEnemy)->m_infoCharacter.CharacterInfo.szCharacterMent,0x00,SIZE_STRING_32);
	//				strncpy( (*itEnemy)->m_infoCharacter.CharacterInfo.szCharacterMent, buf[1], strlen(buf[1]));			
	//			}
	//			
	//			itEnemy++;
	//		}		
		}
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleRejectSurrenderP2PPkOk(MSG_FC_BATTLE_REJECT_SURRENDER_P2P_PK_OK* pMsg)
/// \brief		MSG_FC_BATTLE_REJECT_SURRENDER_P2P_PK_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleRejectSurrenderP2PPkOk(MSG_FC_BATTLE_REJECT_SURRENDER_P2P_PK_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleRejectSurrenderP2PPkOk(MSG_FC_BATTLE_REJECT_SURRENDER_P2P_PK_OK* pMsg)");
	if(m_pChat)
	{
		m_pChat->CreateChatChild(STRMSG_C_PK_0014,COLOR_TRADE);//" ׺  Ͽϴ."
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleEndP2PPk(MSG_FC_BATTLE_END_P2P_PK* pMsg)
/// \brief		MSG_FC_BATTLE_END_P2P_PK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleEndP2PPk(MSG_FC_BATTLE_END_P2P_PK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleEndP2PPk(MSG_FC_BATTLE_END_P2P_PK* pMsg)");
	switch(pMsg->EndType)
	{
	case BATTLE_END_WIN:
		{
			if(m_pChat)
				m_pChat->CreateChatChild(STRMSG_C_PK_0015,COLOR_TRADE);//"[¸] ¸ Ͽϴ."
		}
		break;
	case BATTLE_END_DEFEAT:
		{
			if(m_pChat)
				m_pChat->CreateChatChild(STRMSG_C_PK_0016,COLOR_TRADE);//"[й] й Ͽϴ."
		}
		break;
	case BATTLE_END_TIE:
		{
			if(m_pChat)
				m_pChat->CreateChatChild(STRMSG_C_PK_0017,COLOR_TRADE);//"[º] ºθ  Ͽϴ."
		}
		break;
	case BATTLE_END_END:
		{
			if(m_pChat)
				m_pChat->CreateChatChild(STRMSG_C_PK_0018,COLOR_TRADE);//"[]  Ǿϴ."
		}
		break;
	}
	m_pShuttleChild->SetPkState( PK_PVP, FALSE );
	m_pShuttleChild->SetPVPClientIndex(NULL);
//	m_pShuttleChild->m_bPKMode = FALSE;
//	m_pShuttleChild->m_pOrderTarget = NULL;
	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->PeerClientIndex);
	if(itEnemy != m_pScene->m_mapEnemyList.end())
	{
		itEnemy->second->SetPkState( PK_PVP, FALSE );
		if(m_pShuttleChild->m_pOrderTarget == itEnemy->second )
		{
			m_pShuttleChild->m_pOrderTarget = NULL;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterChangePKPoint(MSG_FC_CHARACTER_CHANGE_PKPOINT* pMsg)
/// \brief		MSG_FC_CHARACTER_CHANGE_PKPOINT
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterChangePKPoint(MSG_FC_CHARACTER_CHANGE_PKPOINT* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterChangePKPoint(MSG_FC_CHARACTER_CHANGE_PKPOINT* pMsg)");
	if(pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		m_pShuttleChild->m_myShuttleInfo.Propensity = pMsg->Propensity;
		m_pShuttleChild->m_myShuttleInfo.PKWinPoint = pMsg->PKWinPoint;
		m_pShuttleChild->m_myShuttleInfo.PKLossPoint = pMsg->PKLossPoint;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleDropDummyOk(MSG_FC_BATTLE_DROP_DUMMY_OK* pMsg)
/// \brief		MSG_FC_BATTLE_DROP_DUMMY_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleDropDummyOk(MSG_FC_BATTLE_DROP_DUMMY_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleDropDummyOk(MSG_FC_BATTLE_DROP_DUMMY_OK* pMsg)");
// 2006-12-04 by ispark,   
	if(pMsg->AttackIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		m_pShuttleChild->DelChaffDataAll();		
		m_pShuttleChild->AddChaffData(m_pShuttleChild, pMsg);
//		m_pScene->AddFieldItemBattleDropDummyOk( m_pShuttleChild, pMsg );
	}
	else
	{
		CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
		if(itEnemy != m_pScene->m_mapEnemyList.end())
		{
			itEnemy->second->DelChaffDataAll();
			itEnemy->second->AddChaffData(itEnemy->second, pMsg);
//			m_pScene->AddFieldItemBattleDropDummyOk( itEnemy->second, pMsg );
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBattleDeleteDummyOK(MSG_FC_BATTLE_DELETE_DUMMY_OK* pMsg)
/// \brief		 
/// \author		ispark
/// \date		2006-12-04 ~ 2006-12-04
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleDeleteDummyOK(MSG_FC_BATTLE_DELETE_DUMMY_OK* pMsg)
{
	if(pMsg->AttackIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		m_pShuttleChild->DelChaffData(pMsg->ItemFieldIndex);
	}
	else
	{
		CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
		if(itEnemy != m_pScene->m_mapEnemyList.end())
		{
			itEnemy->second->DelChaffData(pMsg->ItemFieldIndex);
		}
	}
}
	
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBattleExplodeDummyOK(MSG_FC_BATTLE_EXPLODE_DUMMY_OK* pMsg)
/// \brief		 
/// \author		ispark
/// \date		2006-12-04 ~ 2006-12-04
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleExplodeDummyOK(MSG_FC_BATTLE_EXPLODE_DUMMY_OK* pMsg)
{
	if(pMsg->AttackIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		m_pShuttleChild->DelChaffData(pMsg->ItemFieldIndex);
		if(g_pShuttleChild->m_pChaffData.size() <= 0)
		{
			vector<CSkillInfo*>::iterator itSkillInfo = g_pShuttleChild->m_pSkill->m_vecUsingSkill.begin();
			while(itSkillInfo != g_pShuttleChild->m_pSkill->m_vecUsingSkill.end())
			{
				// 2009-04-21 by bhsohn  DesParam߰
				//if(IS_EXIST_DES_PARAM((*itSkillInfo)->ItemInfo, DES_SKILL_HALLUCINATION))
				if((*itSkillInfo)->ItemInfo->IsExistDesParam(DES_SKILL_HALLUCINATION))
				{
					(*itSkillInfo)->ChangeSkillState(SKILL_STATE_WAIT_REATTACK);
				}
				itSkillInfo++;
			}
		}
	}
	else
	{
		CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
		if(itEnemy != m_pScene->m_mapEnemyList.end())
		{
			itEnemy->second->DelChaffData(pMsg->ItemFieldIndex);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleAttackHideItem(MSG_FC_BATTLE_ATTACK_HIDE_ITEM* pMsg)
/// \brief		MSG_FC_BATTLE_ATTACK_HIDE_ITEM
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleAttackHideItem(MSG_FC_BATTLE_ATTACK_HIDE_ITEM* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleAttackHideItem(MSG_FC_BATTLE_ATTACK_HIDE_ITEM* pMsg)");
	m_pScene->DeleteFieldItemOfFieldIndex( pMsg->TargetItemFieldIndex );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleAttackExplodeItem(MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM* pMsg)
/// \brief		MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleAttackExplodeItem(MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleAttackExplodeItem(MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM* pMsg)");
	m_pScene->ExplodingFieldItemOfFieldIndex( pMsg->TargetItemFieldIndex );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMonsterHide(MSG_FC_MONSTER_HIDE* pMsg)
/// \brief		MSG_FC_MONSTER_HIDE
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMonsterHide(MSG_FC_MONSTER_HIDE* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMonsterHide(MSG_FC_MONSTER_HIDE* pMsg)");
	CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);
	if(itMonster != m_pScene->m_mapMonsterList.end())
	{
		itMonster->second->m_bRenderState = FALSE;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMonsterShow(MSG_FC_MONSTER_SHOW* pMsg)
/// \brief		MSG_FC_MONSTER_SHOW
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMonsterShow(MSG_FC_MONSTER_SHOW* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMonsterShow(MSG_FC_MONSTER_SHOW* pMsg)");
	CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);
	if(itMonster != m_pScene->m_mapMonsterList.end())
	{
		itMonster->second->m_bRenderState = TRUE;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMonsterChangeBodycondition(MSG_FC_MONSTER_CHANGE_BODYCONDITION* pMsg)
/// \brief		MSG_FC_MONSTER_CHANGE_BODYCONDITION
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMonsterChangeBodycondition(MSG_FC_MONSTER_CHANGE_BODYCONDITION* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMonsterChangeBodycondition(MSG_FC_MONSTER_CHANGE_BODYCONDITION* pMsg)");
	CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);
	if(itMonster != m_pScene->m_mapMonsterList.end())
	{
		itMonster->second->ChangeBodyConditionFromServer(pMsg->BodyCondition);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleDropFixerOk(MSG_FC_BATTLE_DROP_FIXER_OK* pMsg)
/// \brief		MSG_FC_BATTLE_DROP_FIXER_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleDropFixerOk(MSG_FC_BATTLE_DROP_FIXER_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleDropFixerOk(MSG_FC_BATTLE_DROP_FIXER_OK* pMsg)");
	CItemData* pItem = m_pScene->FindFieldItemByFieldIndex( pMsg->ItemFieldIndex );
	if( pItem )//&& pItem->m_dwPartType == _FIXER)
	{
		return;
	}
	CAtumData * pAttack = m_pScene->FindUnitDataByClientIndex(pMsg->AttackIndex);
	CAtumData * pTarget = m_pScene->FindUnitDataByClientIndex(pMsg->TargetIndex);
	if(pAttack && pTarget)
	{
		m_pScene->AddFieldItemBattleDropFixerOk(pTarget,pAttack,pMsg);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInfoGetItemInfoOk(ITEM & item)
/// \brief		MSG_FC_INFO_GET_ITEM_INFO_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		ITEM & item
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetItemInfoOk(ITEM & item)
{
	FLOG("CAtumApplication::FieldSocketInfoGetItemInfoOk(ITEM & item)");
	EnterCriticalSection(&m_cs);
	ITEM * pInfo = m_pDatabase->UpdateItemInfo(item);
	if(pInfo)
	{
		g_pStoreData->UpdateItemInfo( item.ItemNum );
	}
//	if(pInfo)
//	{
//		g_pStoreData->UpdateUnitInfoByUpdateItemInfo( pInfo );
//	}
	// ߷ ȭ  ְ ȴٸ  õǾѴ.

	LeaveCriticalSection(&m_cs);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInfoGetSimpleItemInfoOk(MEX_ITEM_INFO & pMsg)
/// \brief		MSG_FC_INFO_GET_SIMPLE_ITEM_INFO_OK
/// \author		dhkwon
/// \date		2004-07-01 ~ 2004-07-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetSimpleItemInfoOk(MEX_ITEM_INFO	& ItemInfo)
{
	g_pDatabase->UpdateSimpleItemInfo( ItemInfo );
	g_pStoreData->UpdateItemInfo( ItemInfo.ItemNum );
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInfoGetEnchantCostOk(MSG_FC_INFO_GET_ENCHANT_COST_OK* pMsg)
/// \brief		MSG_FC_INFO_GET_ENCHANT_COST_OK
/// \author		dhkwon
/// \date		2004-07-01 ~ 2004-07-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetEnchantCostOk(MSG_FC_INFO_GET_ENCHANT_COST_OK* pMsg)
{
	CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
	if(pCityLab)
	{
		pCityLab->SetPrice(pMsg->Cost);
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInfoGetRareItemInfoOk(RARE_ITEM_INFO & item)
/// \brief		MSG_FC_INFO_GET_ITEM_INFO_OK
/// \author		dhkwon
/// \date		2004-04-2 ~ 2004-04-2
/// \warning	
///
/// \param		RARE_ITEM_INFO & rareItem
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetRareItemInfoOk(RARE_ITEM_INFO & rareItem)
{
	FLOG("CAtumApplication::FieldSocketInfoGetRareItemInfoOk(RARE_ITEM_INFO & item)");
	EnterCriticalSection(&m_cs);
	RARE_ITEM_INFO * pRareItem = m_pDatabase->UpdateRareItemInfo(rareItem);
	//g_pStoreData->UpdateUnitInfoByUpdateItemInfo( pInfo );
	// ߷ ȭ  ְ ȴٸ  õǾѴ.

	LeaveCriticalSection(&m_cs);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInfoGetMonsterInfoOk(MSG_FC_INFO_GET_MONSTER_INFO_OK *mon)
/// \brief		MSG_FC_INFO_GET_MONSTER_INFO_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetMonsterInfoOk(MSG_FC_INFO_GET_MONSTER_INFO_OK *mon)
{
	FLOG("CAtumApplication::FieldSocketInfoGetMonsterInfoOk(MSG_FC_INFO_GET_MONSTER_INFO_OK *mon)");
	EnterCriticalSection(&m_cs);
	m_pDatabase->UpdateMonsterInfo( &mon->MonsterInfo );
	LeaveCriticalSection(&m_cs);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInfoGetMapObjectInfoOk(MAPOBJECTINFO & obj)
/// \brief		MSG_FC_INFO_GET_MAPOBJECT_INFO_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		MAPOBJECTINFO
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetMapObjectInfoOk(MAPOBJECTINFO & obj)
{
	FLOG("CAtumApplication::FieldSocketInfoGetMapObjectInfoOk(MAPOBJECTINFO & obj)");
	EnterCriticalSection(&m_cs);
	MAPOBJECTINFO * pInfo = m_pDatabase->UpdateObjectInfo( obj );
	if(g_pGround)
	{
		CObjectChild * pBigObj = NULL;
		CObjectChild * pObj = NULL;
		if(g_pGround->m_ppObjectList)
		{//  Ʈ  
//  ؾ			
//			for(int i = 0;i<g_pGround->m_projectInfo.sXSize;i++)
//			{
//				for(int j = 0;j<g_pGround->m_projectInfo.sXSize;j++)
//				{
//					pObj = (CObjectChild *)g_pGround->m_pObject[i*g_pGround->m_projectInfo.sYSize + j].m_pChild;
//					while(pObj)
//					{
//						if(pObj->m_nCode == pInfo->Code)
//						{
//							pObj->m_pObjectInfo = pInfo;
//						}
//						pObj = (CObjectChild *)pObj->m_pNext;
//					}
//					pBigObj = (CObjectChild *)g_pGround->m_pBigObject; 
//					while( pBigObj ) 
//					{ 
//						if(pBigObj->m_nCode == pInfo->Code) 
//						{ 
//							pBigObj->m_pObjectInfo = pInfo; 
//						} 
//						pBigObj = (CObjectChild *)pBigObj->m_pNext; 
//					} 
//
//				}
//			}
		}
		if(g_pGround->m_pObjectEvent)
		{// ̺Ʈ Ʈ  
			pObj = (CObjectChild *)g_pGround->m_pObjectEvent->m_pChild;
			while(pObj)
			{
				if(pObj->m_nCode == pInfo->Code)
				{
					pObj->m_pObjectInfo = pInfo;
				}
				pObj = (CObjectChild *)pObj->m_pNext;
			}
		}
	}

	LeaveCriticalSection(&m_cs);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleAttackHideItemWKind(MSG_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND* pMsg)
/// \brief		MSG_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleAttackHideItemWKind(MSG_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleAttackHideItemWKind(MSG_FC_BATTLE_ATTACK_HIDE_ITEM_W_KIND* pMsg)");
	m_pScene->DeleteFieldItemOfFieldIndex( pMsg->TargetItemFieldIndex );
	if(	pMsg->ItemKind == ITEMKIND_FIXER &&
		m_pShuttleChild &&
		pMsg->TargetIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		m_pScene->DeleteFieldItemBattleDropFixerOk(pMsg->TargetItemFieldIndex);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleAttackExplodeItemWKind(MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM_W_KIND* pMsg)
/// \brief		MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM_W_KIND
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleAttackExplodeItemWKind(MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM_W_KIND* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleAttackExplodeItemWKind(MSG_FC_BATTLE_ATTACK_EXPLODE_ITEM_W_KIND* pMsg)");
	m_pScene->ExplodingFieldItemOfFieldIndex( pMsg->TargetItemFieldIndex );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketConnectSyncTime(MSG_FC_CONNECT_SYNC_TIME* pMsg)
/// \brief		MSG_FC_CONNECT_SYNC_TIME
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketConnectSyncTime(MSG_FC_CONNECT_SYNC_TIME* pMsg)
{
	FLOG("CAtumApplication::FieldSocketConnectSyncTime(MSG_FC_CONNECT_SYNC_TIME* pMsg)");
	m_pScene->m_dwStartTime = GetTickCount();
	m_pScene->m_nBaseTime = pMsg->CurrentTime;
#ifdef _DEBUG_MAPSETTING
	m_pScene->SetDay();
#endif
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemReloadItemInfo(void)
/// \brief		
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		void
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemReloadItemInfo(void)
{
	FLOG("CAtumApplication::FieldSocketItemReloadItemInfo(void)");
	m_pDatabase->ReloadDatabase();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUseEnchantOk(MSG_FC_ITEM_USE_ENCHANT_OK* pMsg)
/// \brief		MSG_FC_ITEM_USE_ENCHANT_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseEnchantOk(MSG_FC_ITEM_USE_ENCHANT_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUseEnchantOk(MSG_FC_ITEM_USE_ENCHANT_OK* pMsg)");
//	CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
//	if(pCityLab)
//	{
//		pCityLab->InitData();
//	}
	// 2010. 05. 27 by jskim ű Ű ӽ  -  
	if(pMsg->bSuccessFlag)
	{
		g_pD3dApp->m_pChat->CreateChatChild(STRMSG_C_100421_0417, COLOR_SYSTEM);
	}
	else
	{
		g_pD3dApp->m_pChat->CreateChatChild(STRMSG_C_100421_0418, COLOR_SYSTEM);
	}
	//end 2010. 05. 27 by jskim ű Ű ӽ  -  
	
	DBGOUT("MSG_FC_ITEM_USE_ENCHANT_OK\n");
//	g_pGameMain->m_pInven->DeleteEnchantItem(pMsg->ItemNum);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemPutEnchant(MSG_FC_ITEM_PUT_ENCHANT* pMsg)
/// \brief		MSG_FC_ITEM_PUT_ENCHANT
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemPutEnchant(MSG_FC_ITEM_PUT_ENCHANT* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemPutEnchant(MSG_FC_ITEM_PUT_ENCHANT* pMsg)");
	if( g_pStoreData->PutEnchant(pMsg) == FALSE )
	{
		DBGOUT("MSG_FC_ITEM_PUT_ENCHANT\n");
//		if( m_dwGameState == _CITY )
//		{
			ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
			CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
			if(pStore)
			{
				pStore->AddEnchantItem( pMsg->Enchant.TargetItemUniqueNumber, pMsg->Enchant.EnchantItemNum );
			}
			CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
			if(pCityLab)
			{
				pCityLab->PutEnchant( pMsg );
			}
//		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketQuestRequestStartResult(MSG_FC_QUEST_REQUEST_START_RESULT* pMsg)
/// \brief		MSG_FC_QUEST_REQUEST_START_RESULT
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketQuestRequestStartResult(MSG_FC_QUEST_REQUEST_START_RESULT* pMsg)
{
	FLOG("CAtumApplication::FieldSocketQuestRequestStartResult(MSG_FC_QUEST_REQUEST_START_RESULT* pMsg)");
	ASSERT_ASSERT(g_pQuestData);
	if(pMsg->MexQuestInfo.QuestState == QUEST_STATE_IN_PROGRESS)
	{
		DBGOUT("Quest(%d) is Start.\n",pMsg->MexQuestInfo.QuestIndex);
		CQuest* pQuest = g_pQuestData->FindQuest(pMsg->MexQuestInfo.QuestIndex);
		if(pQuest)
		{
			MEX_QUEST_INFO* pCharacterQuest = g_pQuestData->FindCharacterQuest(pMsg->MexQuestInfo.QuestIndex);
			if(!pCharacterQuest)
			{
				pCharacterQuest = new MEX_QUEST_INFO;
				pCharacterQuest->QuestIndex = pQuest->QuestIndex;
				pCharacterQuest->QuestState = QUEST_STATE_IN_PROGRESS;
				if(pQuest->IsCityWar)
				{
					strcpy( pCharacterQuest->szCityWarServerGroupName, pMsg->MexQuestInfo.szCityWarServerGroupName );
				}
				g_pQuestData->AddCharacterQuest(pCharacterQuest->QuestIndex, pCharacterQuest);
				if( m_dwGameState == _CITY ||
					m_dwGameState == _SHOP)	// û 湮 ̶ Ʈ Ʈ ٽ Ѵ.
				{
					#ifdef _DEBUG
					ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
					#else
					if( m_pInterface == NULL) return;
					if( m_pInterface->m_pCityBase == NULL ) return;
					#endif
					GUI_BUILDINGNPC* pShop = m_pInterface->m_pCityBase->GetCurrentBuildingNPC();
					if(pShop)
					{
						g_pQuestData->GetQuestList(pShop->buildingInfo.NPCIndex);
					}
				}
				if(pQuest->QuestEndType == QUEST_END_TYPE_IMMEDIATE)
				{
					// success
					g_pQuestData->SendFieldSocketQuestRequestSuccess( pQuest->QuestIndex );
				}
				else if(pQuest->QuestEndType == QUEST_END_TYPE_SELECT_INFLUENCE)
				{
					// 2007-06-12 by bhsohn ̼ ̽ 
					//g_pGameMain->m_pMissionInfo->SetInfluenceMission(TRUE, pMsg->fANIInflDistributionPercent, pMsg->fVCNInflDistributionPercent);
					g_pGameMain->SetInfluenceMission(TRUE, pMsg->fANIInflDistributionPercent, pMsg->fVCNInflDistributionPercent);
				}

				if(pQuest->TimeLimitInMinutes != 0)
				{
					g_pGameMain->SetQuestLimitTime( pQuest->TimeLimitInMinutes, 0, pQuest->QuestName);
				}
				if(m_pShuttleChild->m_myShuttleInfo.Level < 6)
				{
					// ̼ â ȮϽǼ ֽϴ.
					g_pGameMain->SetNotice( 25 );
				}

			}
			else
			{
				pCharacterQuest->QuestIndex = pQuest->QuestIndex;
				pCharacterQuest->QuestState = QUEST_STATE_IN_PROGRESS;
				if(pQuest->TimeLimitInMinutes != 0)
				{
					g_pGameMain->SetQuestLimitTime( pQuest->TimeLimitInMinutes, 
						pCharacterQuest->QuestPlayTimeStamp, pQuest->QuestName);
				}

				DBGOUT("Already Start Quest .(QuestIndex:%d)\n",pQuest->QuestIndex);
			}
		}
	}
	else if(pMsg->MexQuestInfo.QuestState == QUEST_STATE_NONE)
	{
		DBGOUT("Can't Start Quest.(QuestIndex:%d)\n",pMsg->MexQuestInfo.QuestIndex);
	}

	// 2009-02-03 by bhsohn ̼ ۽ Ϸ üũ üũ
	{
		int nMissionIndex = g_pD3dApp->SerchMissionCondition();
		if(nMissionIndex != NULL && g_pGImage)
		{
			g_pGImage->SetImageInfo(MISSION_SUC, TRUE);
		}
	}
	// end 2009-02-03 by bhsohn ̼ ۽ Ϸ üũ üũ
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketQuestRequestSuccessResult(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT* pMsg)
/// \brief		MSG_FC_QUEST_REQUEST_SUCCESS_RESULT
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketQuestRequestSuccessResult(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT* pMsg)
{
	FLOG("CAtumApplication::FieldSocketQuestRequestSuccessResult(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT* pMsg)");
	ASSERT_ASSERT(g_pQuestData);
	#ifdef _DEBUG
	ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
	#else
	if( m_pInterface == NULL) return;
	if( m_pInterface->m_pCityBase == NULL ) return;
	#endif
	if(pMsg->IsSuccessful)
	{
		DBGOUT("Quest(%d)is Done.\n",pMsg->QuestIndex);
		// ̼â ٲٱ
		if(g_pInterface->m_pCityBase->m_pMission->m_nCancerSelect < CITY_MISSION_MAX_NUMBER)
				g_pInterface->m_pCityBase->m_pMission->m_bProgressMission[g_pInterface->m_pCityBase->m_pMission->m_nCancerSelect] = FALSE;
		CQuest *pQuest = g_pQuestData->FindQuest( pMsg->QuestIndex );
		ASSERT_ASSERT(pQuest);
		if(pQuest->TimeLimitInMinutes != 0)
		{
			g_pGameMain->m_bQuestLimitTimeView = FALSE;
		}
		if(pQuest->QuestType == QUEST_TYPE_REPEATABLE)
		{
			g_pQuestData->DeleteCharacterQuest(pMsg->QuestIndex);
		}		
		else
		{
			MEX_QUEST_INFO* pCharacterQuest = g_pQuestData->FindCharacterQuest(pMsg->QuestIndex);
			if(!pCharacterQuest)
			{
				pCharacterQuest = new MEX_QUEST_INFO;
				pCharacterQuest->QuestIndex = pMsg->QuestIndex;
				pCharacterQuest->QuestState = QUEST_STATE_COMPLETED;
				g_pQuestData->AddCharacterQuest(pCharacterQuest->QuestIndex, pCharacterQuest);
				DBGOUT("Exit Quest Not Started Quest (QuestIndex:%d)\n",pMsg->QuestIndex);
			}
			else
			{
				pCharacterQuest->QuestIndex = pMsg->QuestIndex;
				pCharacterQuest->QuestState = QUEST_STATE_COMPLETED;
			}

			if(pQuest->QuestEndType == QUEST_END_TYPE_SELECT_INFLUENCE)
			{
				// 2006-02-08 by ispark FALSE...    ʿ䰡 .
				// 2007-06-12 by bhsohn ̼ ̽ 
				//g_pGameMain->m_pMissionInfo->SetInfluenceMission(FALSE, 0.0f, 0.0f);			
				g_pGameMain->SetInfluenceMission(FALSE, 0.0f, 0.0f);			
			}
			else if(pQuest->TargetMeetObjectMapArea.MapIndex != 0 && pQuest->TargetMeetObjectIndex != 0)
			{
				g_pGImage->SetImageInfo(MISSION_SUC);
			}
			else if(0 != pQuest->TargetDeadByMonsterUniquenumber)
			{
				g_pGImage->SetImageInfo(MISSION_SUC);
			}
		}
//		if(m_dwGameState == _CITY)	// û 湮 ̶ Ʈ Ʈ ٽ Ѵ.
		GUI_BUILDINGNPC* pShop = m_pInterface->m_pCityBase->GetCurrentBuildingNPC();
		if(pShop)
		{
			g_pQuestData->GetQuestList(pShop->buildingInfo.NPCIndex);
		}

		// 2007-03-06 by bhsohn Ʈ Ϸ ġ ó  
		//g_pQuestData->SetQuestEndNPCTalk( TRUE, pMsg->QuestIndex);
		g_pQuestData->SetQuestEndNPCTalk( TRUE, pMsg->QuestIndex, pMsg->ExpOfCompensation);
		// end 2007-03-06 by bhsohn Ʈ Ϸ ġ ó  

		g_pGameMain->m_pCharacterInfo->SetQuestDesc( -1 ); // reset
		if(pQuest->QuestType == QUEST_TYPE_SERIES && pQuest->NextQuestIndex != 0)
		{
			g_pQuestData->NotifyStartQuest();
		}
		char buf[256];
		if( pQuest->EndCinemaNum == 0 )
		{
//			wsprintf( buf, STRMSG_C_QUEST_0062, pQuest->QuestName );//"̼ %s ϷϿϴ."
//			g_pGameMain->m_pInfWindow->AddMsgBox( buf, _MESSAGE );
		}
		else
		{
			wsprintf( buf, "%d.tex", pQuest->EndCinemaNum );
			g_pInterface->InitSoundScript( buf );
			g_pInterface->RestoreSoundScript();
		}
		// 2007-06-12 by bhsohn ̼ ̽ 
//		int nSelect = g_pGameMain->m_pMissionInfo->GetSelectIndexCurrent();
//		g_pGameMain->m_pMissionInfo->RefreshMission();
//		if(pQuest->QuestEndType == QUEST_END_TYPE_IMMEDIATE)
//		{
//			nSelect++;
//			
//			g_pGameMain->m_pMissionInfo->SetSelectIndexCurrent(nSelect);
//			g_pGameMain->m_pMissionInfo->SetFirstMissionSelect(TRUE);
//		}
		// ۰   Ʈ  ٷ ϰԲ
		if(pQuest->QuestEndType == QUEST_END_TYPE_IMMEDIATE)
		{
			INT dwNextQuest = pQuest->QuestIndex+1;
			g_pGameMain->ShowMissionTreeWnd(TRUE, FALSE);
			g_pGameMain->SelectNextMission(dwNextQuest);
			
		}

		vector<Quest_MonsterInfo>::iterator it = g_pQuestData->m_vecQuestMonsterCount.begin();
		while(it != g_pQuestData->m_vecQuestMonsterCount.end())
		{
			if(pMsg->QuestIndex == (*it).nQuestIndex)
			{
				it = g_pQuestData->m_vecQuestMonsterCount.erase(it);
				DBGOUT("FieldSocketQuestRequestSuccessResult, MonsterQuestInfo Delete QuestIndex %d\n", pMsg->QuestIndex);
				continue;
			}
			it++;
		}

		// 2007-07-04 by bhsohn ۷ ߰
		// ̼  
		ShowOpMissionComplete(pMsg);
	}
	else
	{
		DBGOUT("Failed Quest(QuestIndex:%d)", pMsg->QuestIndex);
		CQuest *pQuest = g_pQuestData->FindQuest( pMsg->QuestIndex );
		ASSERT_ASSERT(pQuest);
		// 2007-03-06 by bhsohn Ʈ Ϸ ġ ó  
		//g_pQuestData->SetQuestEndNPCTalk( FALSE, pMsg->QuestIndex );
		g_pQuestData->SetQuestEndNPCTalk( FALSE, pMsg->QuestIndex, pMsg->ExpOfCompensation);
		// end 2007-03-06 by bhsohn Ʈ Ϸ ġ ó  
	}
	
	g_pQuestData->NotifyStartQuest();

	// 2007-06-12 by bhsohn ̼ ̽ 
	// 2009-04-08 by bhsohn  ұ,  ʱȭ ý ߰ 
	if(pMsg->IsSuccessful)
	{
		// ̼  
		g_pGameMain->RefreshMission(FALSE);	
		//  ˾  Show
		CHARACTER myShuttleInfo = g_pShuttleChild->GetMyShuttleInfo();
		g_pGameMain->UpdateMissionPopWnd(myShuttleInfo.Level, pMsg->QuestIndex);
	}

//	if( (m_pScene->m_byMapType == MAP_TYPE_TUTORIAL) && 
//		(pMsg->QuestIndex == 1 || 
//		pMsg->QuestIndex == 2 || 
//		pMsg->QuestIndex == 3 || 
//		pMsg->QuestIndex == 11) )
//	{// ʺ Ʈ϶ üũ
//		m_pShuttleChild->CheckBeginnerQuest();
//	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::ShowOpMissionComplete(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT* pMsg)
/// \brief		
/// \author		// 2007-07-04 by bhsohn ۷ ߰
/// \date		2007-07-16 ~ 2007-07-16
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::ShowOpMissionComplete(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT* pMsg)
{
	vector<QUEST_PAY_ITEM_INFO> vecQuestPay;
	vecQuestPay.clear();

	for(int i=0;i<pMsg->QuestPayInfoListCount;i++)
	{
		QUEST_PAY_ITEM_INFO* pRecvQuestPayItem = (QUEST_PAY_ITEM_INFO*)(((char*)pMsg) 
										+ sizeof(MSG_FC_QUEST_REQUEST_SUCCESS_RESULT)
										+ sizeof(QUEST_PAY_ITEM_INFO)*i);
		QUEST_PAY_ITEM_INFO tmpQuest;

		memcpy(&tmpQuest, pRecvQuestPayItem, sizeof(QUEST_PAY_ITEM_INFO));

		vecQuestPay.push_back(tmpQuest);
	}
	g_pInterface->ShowOpMissionComplete(pMsg->ExpOfCompensation, pMsg->BonusStatOfCompensation, vecQuestPay);
	// 2008-12-16 by dgwoo ̼  
	CQuest * pQuest = g_pQuestData->FindQuest(pMsg->QuestIndex);
	if(pQuest && (pQuest->QuestPartyType == QUEST_PARTYTYPE_PARTY)
		&& !(g_pShuttleChild->GetMyShuttleInfo().SecretInfoOption & USER_INFO_OPTION_MISSIONMASTER)
		&& (g_pQuestData->GetMissionMasterQuestCompletedCount() == 1))		
	{//̼  ϴ â .
		g_pGameMain->m_pMissionMain->SetMissionMasterWindowShow(TRUE);
	}

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketQuestRequestSuccessCheckResult(MSG_FC_QUEST_REQUEST_SUCCESS_CHECK_RESULT* pMsg)
/// \brief		Ƽ̼  
/// \author		ispark
/// \date		2006-03-24 ~ 2006-03-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketQuestRequestSuccessCheckResult(MSG_FC_QUEST_REQUEST_SUCCESS_CHECK_RESULT* pMsg)
{
	g_pGImage->SetImageInfo(MISSION_SUC, TRUE, pMsg->QuestIndex);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketQuestPutAllQuest(MSG_FC_QUEST_PUT_ALL_QUEST* pMsg)
/// \brief		MSG_FC_QUEST_PUT_ALL_QUEST
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketQuestPutAllQuest(MSG_FC_QUEST_PUT_ALL_QUEST* pMsg)
{
	FLOG("CAtumApplication::FieldSocketQuestPutAllQuest(MSG_FC_QUEST_PUT_ALL_QUEST* pMsg)");
	for(int i=0;i<pMsg->NumOfQuest;i++)
	{
		MEX_QUEST_INFO* pRecvCharacterQuest = (MEX_QUEST_INFO*)(((char*)pMsg) + sizeof(MSG_FC_QUEST_PUT_ALL_QUEST)
										+ sizeof(MEX_QUEST_INFO)*i);
		DBGOUT("Quest(%d:state:%d) Received.\n", pRecvCharacterQuest->QuestIndex,pRecvCharacterQuest->QuestState);
		MEX_QUEST_INFO* pCharacterQuest = new MEX_QUEST_INFO;
		memcpy(pCharacterQuest, pRecvCharacterQuest, sizeof(MEX_QUEST_INFO));
		g_pQuestData->AddCharacterQuest( pCharacterQuest->QuestIndex, pCharacterQuest );

		CQuest *pQuest = g_pQuestData->FindQuest( pCharacterQuest->QuestIndex );
		if( pQuest == NULL )
		{
			DBGOUT("Quest File is NULL(%d).\n\n\n\n", pCharacterQuest->QuestIndex);
			continue;
		}
		if( pQuest->TimeLimitInMinutes != 0 &&
			pCharacterQuest->QuestState == QUEST_STATE_IN_PROGRESS)
		{
			g_pGameMain->SetQuestLimitTime( pQuest->TimeLimitInMinutes, pRecvCharacterQuest->QuestPlayTimeStamp, pQuest->QuestName);
		}
	}
	
	SendMissionComplete();
	CQuest *pQuestInfo = g_pQuestData->GetProgressMission();
	if(pQuestInfo)
	{
		if(pQuestInfo->QuestEndType == QUEST_END_TYPE_SELECT_INFLUENCE)
		{
			// 2006-02-08 by ispark
			// 2007-06-12 by bhsohn ̼ ̽ 
			//g_pGameMain->m_pMissionInfo->SetInfluenceMission(TRUE, pMsg->fANIInflDistributionPercent, pMsg->fVCNInflDistributionPercent);
			g_pGameMain->SetInfluenceMission(TRUE, pMsg->fANIInflDistributionPercent, pMsg->fVCNInflDistributionPercent);
		}		
	}
	// 2007-01-26 by bhsohn ű ̼ ̽
	// ű   .
		g_pGameMain->UpdateNoviceUserHelper();		
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketQuestDiscardQuestOk(MSG_FC_QUEST_DISCARD_QUEST_OK* pMsg)
/// \brief		MSG_FC_QUEST_DISCARD_QUEST_OK,  Ʈ 
/// \author		dhkwon
/// \date		2004-08-09 ~ 2004-08-09
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketQuestDiscardQuestOk(MSG_FC_QUEST_DISCARD_QUEST_OK* pMsg)
{
	if( pMsg->IsDiscarded == 1 ) // Ʈ  
	{
		CQuest *pQuest = g_pQuestData->FindQuest( pMsg->QuestIndex );
		if( pQuest )
		{
			char buf[256];
			wsprintf( buf, STRMSG_C_QUEST_0063, pQuest->QuestName );//"[%s]̼  Ǿϴ."
			m_pChat->CreateChatChild( buf, COLOR_SYSTEM );

			// 2007-06-12 by bhsohn ̼ ̽ 
			//g_pGameMain->m_pMissionInfo->RefreshMission();			

			if(pQuest->TimeLimitInMinutes)
			{
				g_pGameMain->m_bQuestLimitTimeView = FALSE;
			}
		}
		g_pQuestData->DeleteCharacterQuest( pMsg->QuestIndex );
		// 2007-06-12 by bhsohn ̼ ̽ 
		g_pGameMain->RefreshMission(FALSE);

		#ifdef _DEBUG
		ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
		#else
		if( m_pInterface == NULL) return;
		if( m_pInterface->m_pCityBase == NULL ) return;
		#endif
		GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
		if(pBuilding)
		{
			g_pQuestData->GetQuestList( pBuilding->buildingInfo.NPCIndex );
		}
		g_pGameMain->m_pCharacterInfo->SetQuestDesc( -1 ); // reset

		// Ʈ   
		vector<Quest_MonsterInfo>::iterator it = g_pQuestData->m_vecQuestMonsterCount.begin();
		while(it != g_pQuestData->m_vecQuestMonsterCount.end())
		{
			if(pMsg->QuestIndex == (*it).nQuestIndex)
			{
				// 2006-04-10 by ispark,  
				it = g_pQuestData->m_vecQuestMonsterCount.erase(it);
				DBGOUT("FieldSocketQuestDiscardQuestOk, MonsterQuestInfo Delete QuestIndex %d\n", pMsg->QuestIndex);
				continue;
			}
			it++;
		}
		
	}
	else
	{
		DBGOUT("CAtumApplication::FieldSocketQuestDiscardQuestOk, Quest(%d),pMsg->IsDiscarded != 1\n", pMsg->QuestIndex);
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketSkillSetupSkillOk(MSG_FC_SKILL_SETUP_SKILL_OK* pMsg)
/// \brief		MSG_FC_SKILL_SETUP_SKILL_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketSkillSetupSkillOk(MSG_FC_SKILL_SETUP_SKILL_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketSkillSetupSkillOk(MSG_FC_SKILL_SETUP_SKILL_OK* pMsg)");
	pMsg->ItemSkill.ItemInfo = g_pDatabase->GetServerItemInfo(pMsg->ItemSkill.ItemNum);
	CSkillInfo* pSkillInfo = g_pShuttleChild->m_pSkill->PutSkill(&(pMsg->ItemSkill));		// 2004-07-23 jschoi
	g_pGameMain->m_pCharacterInfo->SetAllUTCInfo();

	//--------------------------------------------------------------------------//
	// 2006-12-14 by dgwoo ReAttackTime 10 ̻   ð üũؼ 
	// ų ð Ŭ̾Ʈ Ѵ.
	UINT fReAttackTime = pSkillInfo->ItemInfo->ReAttacktime;

	// 2010. 08. 18. by hsLee. ڿ ų  ð ǵ .
	// 2009. 04. 06 by ckPark  ų  Ӽ ߰
// 	if(fReAttackTime >= TERM_TICK_MUST_SERVER_CHECK_SKILL_REATTACK_TIME &&							//5 ̻ 
// 		!COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION))	// ڰ ƴ϶
	if(COMPARE_BIT_FLAG(pSkillInfo->ItemInfo->ItemAttribute, SKILL_ATTR_STORE_USING_TIME) /*&&		//5 ̻ 
		!COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION)*/ )	// ڰ ƴ϶
	// end 2009. 04. 06 by ckPark  ų  Ӽ ߰
	{
		ATUM_DATE_TIME curServerTime = GetServerDateTime();
		int nSeconds = curServerTime.GetTimeInSeconds() - pMsg->ItemSkill.UseTime.GetTimeInSeconds();
		if(fReAttackTime > (nSeconds * 1000))
		{//fReAttackTime - (nSeconds*1000)   ð  帥ڴ ų ׳ Ҽ ֵѴ.
			
			// 2009-02-17 by bhsohn ĵ  
			pSkillInfo->SetSkillEnable(TRUE);
			// end 2009-02-17 by bhsohn ĵ  

			pSkillInfo->SetClientIndex (	g_pShuttleChild->GetShuttleInfo()->ClientIndex ,
											g_pShuttleChild->GetShuttleInfo()->ClientIndex );

			g_pShuttleChild->m_pSkill->m_vecUsingSkill.push_back(pSkillInfo);
			pSkillInfo->SetSkillState(SKILL_STATE_WAIT_REATTACK);
			pSkillInfo->SetReattackTime(fReAttackTime - (nSeconds*1000));
		}
		
	}
	//--------------------------------------------------------------------------//
	
	if(pMsg->ItemUpdateType==IUT_SHOP)
	{
		// 2005-12-09 by ispark
		CAtumNode * pEffectParent;
		if(g_pD3dApp->m_bCharacter)
			pEffectParent = m_pCharacterChild;
		else
			pEffectParent = m_pShuttleChild;

//		CAppEffectData * pEff = new CAppEffectData(m_pShuttleChild,RC_EFF_GET_SKILL,D3DXVECTOR3(0,0,0));
		CAppEffectData * pEff = new CAppEffectData(pEffectParent,RC_EFF_GET_SKILL,D3DXVECTOR3(0,0,0));
		m_pEffectList->AddChild(pEff);
		CINFCitySkillShop * pShop = (CINFCitySkillShop*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_SKILL_SHOP);
		if(pShop)
		{
			pShop->ReloadSkillItemList();
		}

		char ShopResult[128];
		wsprintf(ShopResult, STRMSG_C_060519_0001, pMsg->ItemSkill.ItemInfo->ItemName, pMsg->ItemSkill.ItemInfo->SkillLevel);
		m_pChat->CreateChatChild(ShopResult, COLOR_ITEM);

		m_bRequestEnable = TRUE;
		g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketRequestRequestOk(MSG_FC_REQUEST_REQUEST_OK* pMsg)
/// \brief		MSG_FC_REQUEST_REQUEST_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketRequestRequestOk(MSG_FC_REQUEST_REQUEST_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketRequestRequestOk(MSG_FC_REQUEST_REQUEST_OK* pMsg)");
	BYTE bType = pMsg->RequestType;
	int nMsgType = 0;
	char buf[256];
	switch(bType)
	{
	case REQUEST_TYPE_PARTY_BATTLE:
		{
			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->SourceClientIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				nMsgType = _Q_REQUEST_PARTY_BATTLE;
				wsprintf(buf,STRMSG_C_PARTY_0048,itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName);//"%s    Ͻðڽϱ?"

				// 2008-07-14 by bhsohn EP3  ó
				if(g_pGameMain->IsRejectUser(itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName))
				{	
					g_pD3dApp->m_pChat->CreateChatChild(STRMSG_C_080714_0207,COLOR_ERROR);//"\\yź Ͽ ϵ Դϴ."					
				}
				// end 2008-07-14 by bhsohn EP3  ó

				// 2008-06-20 by bhsohn EP3 ɼǰ ó
				//if(!g_pGameMain->m_pInfWindow->IsExistMsgBox(nMsgType))
				if(!g_pGameMain->m_pInfWindow->IsExistMsgBox(nMsgType) 
					&& IsOptionEtc(OPTION_RADIO_FORMATIONWAR)//   ɼ ѾѴ.
					&&!g_pGameMain->IsRejectUser(itEnemy->second->m_infoCharacter.CharacterInfo.CharacterName)) // ź Ʈ   .	// 2008-07-14 by bhsohn EP3  ó
				{
					//  û ޴  Ұ 
					g_pGameMain->m_pCommunity->GetParty()->SetEnablePartyMenu(FALSE);
					g_pGameMain->m_pInfWindow->AddMsgBox(buf,nMsgType,pMsg->SourceClientIndex);
					break;
				}
				else
				{
					MSG_FC_REQUEST_REJECT_REQUEST sMsg;
					memset(&sMsg,0x00,sizeof(sMsg));
					char buffer[SIZE_MAX_PACKET];
					int nType = T_FC_REQUEST_REJECT_REQUEST;
					sMsg.SourceClientIndex = pMsg->SourceClientIndex;
					sMsg.RequestType = bType;
					memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
					memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
					m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));
				}
			}
		}
		break;
	case REQUEST_TYPE_GUILD_WAR:
		{
			nMsgType = _Q_REQUEST_GUILD_WAR;
			wsprintf(buf,STRMSG_C_GUILD_0035,pMsg->SourceCharacterName);//"%s ܰ  Ͻðڽϱ?"
			// 2008-06-20 by bhsohn EP3 ɼǰ ó
			// 2008-07-14 by bhsohn EP3  ó
			if(g_pGameMain->IsRejectUser(pMsg->SourceCharacterName))
			{	
				g_pD3dApp->m_pChat->CreateChatChild(STRMSG_C_080714_0207,COLOR_ERROR);//"\\yź Ͽ ϵ Դϴ."					
			}
			// end 2008-07-14 by bhsohn EP3  ó

//			if( !g_pGameMain->m_pInfWindow->IsExistMsgBox(nMsgType) && 
//				g_pShuttleChild->m_pGuildWarInfo == NULL)
			if( !g_pGameMain->m_pInfWindow->IsExistMsgBox(nMsgType) 
				&& g_pShuttleChild->m_pGuildWarInfo == NULL
				&& IsOptionEtc(OPTION_RADIO_GUILD_WAR)	//  ѾѴ.
				&&!g_pGameMain->IsRejectUser(pMsg->SourceCharacterName)) // ź Ʈ   .	// 2008-07-14 by bhsohn EP3  ó
			{
				//  û ޴  Ұ 
				g_pGameMain->m_pInfWindow->AddMsgBox(buf,nMsgType,pMsg->SourceClientIndex);
				break;
			}
			else
			{
				MSG_FC_REQUEST_REJECT_REQUEST sMsg;
				memset(&sMsg,0x00,sizeof(sMsg));
				sMsg.SourceClientIndex = pMsg->SourceClientIndex;
				sMsg.RequestType = bType;
				m_pFieldWinSocket->SendMsg( T_FC_REQUEST_REJECT_REQUEST, (char*)&sMsg, sizeof(sMsg) );
			}
		}
		break;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketRequestRejectRequestOk(MSG_FC_REQUEST_REJECT_REQUEST_OK* pMsg)
/// \brief		MSG_FC_REQUEST_REJECT_REQUEST_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketRequestRejectRequestOk(MSG_FC_REQUEST_REJECT_REQUEST_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketRequestRejectRequestOk(MSG_FC_REQUEST_REJECT_REQUEST_OK* pMsg)");
	switch(pMsg->RequestType)
	{
	case REQUEST_TYPE_PARTY_BATTLE:
		{
			m_pChat->CreateChatChild(STRMSG_C_PARTY_0049,COLOR_SYSTEM);//"    Ͽϴ."
			//  ޴   
			g_pGameMain->m_pCommunity->GetParty()->SetEnablePartyMenu(TRUE);
		}
		break;
	case REQUEST_TYPE_GUILD_WAR:
		{
			m_pChat->CreateChatChild(STRMSG_C_GUILD_0036,COLOR_SYSTEM);//"   Ͽϴ."
		}
		break;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketRequestCancelRequest(MSG_FC_REQUEST_CANCEL_REQUEST* pMsg)
/// \brief		MSG_FC_REQUEST_CANCEL_REQUEST
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketRequestCancelRequest(MSG_FC_REQUEST_CANCEL_REQUEST* pMsg)
{
	FLOG("CAtumApplication::FieldSocketRequestCancelRequest(MSG_FC_REQUEST_CANCEL_REQUEST* pMsg)");
	switch(pMsg->RequestType)
	{
	case REQUEST_TYPE_PARTY_BATTLE:
		{
			m_pChat->CreateChatChild(STRMSG_C_PARTY_0050,COLOR_PARTY);//" û  Ǿϴ."
			if(g_pGameMain->m_pInfWindow->IsExistMsgBox(_Q_REQUEST_PARTY_BATTLE))
			{
				g_pGameMain->m_pInfWindow->DeleteMsgBox(_Q_REQUEST_PARTY_BATTLE);
			}
			//  ޴   
			g_pGameMain->m_pCommunity->GetParty()->SetEnablePartyMenu(TRUE);
		}
		break;
	case REQUEST_TYPE_GUILD_WAR:
		{
			m_pChat->CreateChatChild(STRMSG_C_GUILD_0037,COLOR_SYSTEM);//" û  Ǿϴ."
		}
		break;
	}

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketRequestAcceptRequestOk(MSG_FC_REQUEST_ACCEPT_REQUEST_OK* pMsg)
/// \brief		MSG_FC_REQUEST_ACCEPT_REQUEST_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketRequestAcceptRequestOk(MSG_FC_REQUEST_ACCEPT_REQUEST_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketRequestAcceptRequestOk(MSG_FC_REQUEST_ACCEPT_REQUEST_OK* pMsg)");
	switch(pMsg->RequestType)
	{
	case REQUEST_TYPE_PARTY_BATTLE:
		{
			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->PeerClientIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				char message[256];
				wsprintf(message,STRMSG_C_PARTY_0051,((CEnemyData *)itEnemy->second)->m_infoCharacter.CharacterInfo.CharacterName);//"%s   ³ Ͽϴ."
				m_pChat->CreateChatChild(message,COLOR_SYSTEM);
			}
		}
		break;
	case REQUEST_TYPE_GUILD_WAR:
		{
			char message[256];
			wsprintf(message,STRMSG_C_GUILD_0038,pMsg->PeerCharacterName);//"%s   ³ Ͽϴ."
			m_pChat->CreateChatChild(message,COLOR_SYSTEM);
		}
		break;
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketRequestRepairOk(MSG_FC_SHOP_REQUEST_REPAIR_OK* pMsg)
/// \brief		MSG_FC_SHOP_REQUEST_REPAIR_OK  OK
/// \author		ispark
/// \date		2005-11-08 ~ 2005-11-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketRequestRepairOk(MSG_FC_SHOP_REQUEST_REPAIR_OK* pMsg)
{
	char message[256];
	switch(pMsg->DesParam)
	{
// 2006-03-07 by ispark,   ġ 
#if defined(LANGUAGE_ENGLISH) || defined(LANGUAGE_VIETNAM)|| defined(LANGUAGE_THAI)|| defined(LANGUAGE_RUSSIA)// 2008-04-30 by bhsohn ±  ߰
	// 2005-11-10 by ispark
	// ۷ι ޼ Է  ٸ.
	case DES_HP:
		wsprintf(message,STRMSG_C_051108_0002, pMsg->Count, "HP", pMsg->RepairCost);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_DP:
		wsprintf(message,STRMSG_C_051108_0002, pMsg->Count, "Shield", pMsg->RepairCost);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_EP:
		wsprintf(message,STRMSG_C_051108_0003, pMsg->Count, "EP", pMsg->RepairCost);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] Ͽϴ."
		break;
	case DES_SP:
		wsprintf(message,STRMSG_C_051108_0002, pMsg->Count, "SP", pMsg->RepairCost);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_BULLET_01:
		wsprintf(message,STRMSG_C_051108_0004, g_pShuttleChild->m_pPrimaryWeapon->GetRealItemInfo()->ItemName, pMsg->Count, pMsg->RepairCost);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%s][%d] Ͽϴ."
		break;
	case DES_BULLET_02:
		wsprintf(message,STRMSG_C_051108_0004, g_pShuttleChild->m_pSecondaryWeapon->GetRealItemInfo()->ItemName, pMsg->Count, pMsg->RepairCost);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%s][%d] Ͽϴ."
		break;
#elif defined(LANGUAGE_CHINA)
		case DES_HP:
		wsprintf(message,STRMSG_C_051108_0002, pMsg->RepairCost, pMsg->Count, "HP");
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_DP:
		//wsprintf(message,STRMSG_C_051108_0002, pMsg->RepairCost, pMsg->Count, "Shield");
		wsprintf(message,STRMSG_C_051108_0002, pMsg->RepairCost, pMsg->Count, STRMSG_C_070425_0200);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_EP:
		//wsprintf(message,STRMSG_C_051108_0003, pMsg->RepairCost, pMsg->Count, "EP");
		wsprintf(message,STRMSG_C_051108_0003, pMsg->RepairCost, pMsg->Count, STRMSG_C_070425_0201);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] Ͽϴ."
		break;
	case DES_SP:
		wsprintf(message,STRMSG_C_051108_0002, pMsg->RepairCost, pMsg->Count, "SP");
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_BULLET_01:
		wsprintf(message,STRMSG_C_051108_0004, pMsg->RepairCost, g_pShuttleChild->m_pPrimaryWeapon->GetRealItemInfo()->ItemName, pMsg->Count);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%s][%d] Ͽϴ."
		break;
	case DES_BULLET_02:
		wsprintf(message,STRMSG_C_051108_0004, pMsg->RepairCost, g_pShuttleChild->m_pSecondaryWeapon->GetRealItemInfo()->ItemName, pMsg->Count);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%s][%d] Ͽϴ."
		break;
#else
	case DES_HP:
		wsprintf(message,STRMSG_C_051108_0002, pMsg->RepairCost, pMsg->Count, "HP");
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_DP:
		//wsprintf(message,STRMSG_C_051108_0002, pMsg->RepairCost, pMsg->Count, "");
		wsprintf(message,STRMSG_C_051108_0002, pMsg->RepairCost, pMsg->Count, STRMSG_C_070425_0200);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_EP:
		//wsprintf(message,STRMSG_C_051108_0003, pMsg->RepairCost, pMsg->Count, "EP");
		wsprintf(message,STRMSG_C_051108_0003, pMsg->RepairCost, pMsg->Count, STRMSG_C_070425_0201);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] Ͽϴ."
		break;
	case DES_SP:
		wsprintf(message,STRMSG_C_051108_0002, pMsg->RepairCost, pMsg->Count, "SP");
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%d][%s] ȸϿϴ."
		break;
	case DES_BULLET_01:
		wsprintf(message,STRMSG_C_051108_0004, pMsg->RepairCost, g_pShuttleChild->m_pPrimaryWeapon->GetRealItemInfo()->ItemName, pMsg->Count);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%s][%d] Ͽϴ."
		break;
	case DES_BULLET_02:
		wsprintf(message,STRMSG_C_051108_0004, pMsg->RepairCost, g_pShuttleChild->m_pSecondaryWeapon->GetRealItemInfo()->ItemName, pMsg->Count);
		m_pChat->CreateChatChild(message, COLOR_ERROR);//"[%d] SPI() [%s][%d] Ͽϴ."
		break;
#endif
	default:
		{
			return;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketShopBuyColorItemOk(MSG_FC_SHOP_BUY_COLOR_ITEM_OK* pMsg)
/// \brief		MSG_FC_SHOP_BUY_COLOR_ITEM_OK
/// \author		ydkim
/// \date		2005-12-8
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopBuyColorItemOk(MSG_FC_SHOP_BUY_COLOR_ITEM_OK* pMsg)
{
	CItemInfo*  pItemArmor = NULL;
	pItemArmor = g_pStoreData->FindItemInInventoryByUniqueNumber(pMsg->ItemUID64);
	if(pItemArmor)
	{
		pItemArmor->ColorCode		= pMsg->ColorCode;		
		// 2006-02-17 by ispark
//		g_pGameMain->m_nArmorColor	= max(1, pMsg->ColorCode%100);
		g_pShuttleChild->SetAmorColor(max(1, pMsg->ColorCode%100));
		// 2006-05-19 by ispark, 
		char ShopResult[128];
// 2007-08-10 by cmkwon, Ʒ  ,  ˻  ʿ䰡 
//		CINFCityShop * pCityShop = (CINFCityShop*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_TUNING_COLOR);
//		SHOP_ITEM* pShopItem = pCityShop->FindCityShopDataByColor(pMsg->ColorCode);
//		if(pShopItem)
//		{
//			wsprintf(ShopResult, STRMSG_C_060519_0002, pShopItem->ItemName);
//			m_pChat->CreateChatChild(ShopResult, COLOR_ITEM);	
//		}
		ITEM* item = g_pDatabase->GetServerItemInfo(pMsg->ColorCode);
		if(item)
		{
			wsprintf(ShopResult, STRMSG_C_060519_0002, item->ItemName);
			m_pChat->CreateChatChild(ShopResult, COLOR_ITEM);	
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyBattleStart(MSG_FC_PARTY_BATTLE_READY* pMsg)
/// \brief		MSG_FC_PARTY_BATTLE_READY
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyBattleStart(MSG_FC_PARTY_BATTLE_START* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyBattleReady(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketQuestUpdateMonsterCount(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT* pMsg)
/// \brief		MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT
/// \author		ydkim
/// \date		2005-10-26~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketQuestUpdateMonsterCount(MSG_FC_QUEST_UPDATE_MONSTER_COUNT* pMsg)
{
	Quest_MonsterInfo pTempMonsterCount;
	int nMissionIndex = 0;
	
	vector<Quest_MonsterInfo>::iterator it = g_pQuestData->m_vecQuestMonsterCount.begin();
	while(it != g_pQuestData->m_vecQuestMonsterCount.end())
	{
		if( (*it).nMonsterUnitkind == pMsg->MonsterUniqueNumber && (*it).nQuestIndex == pMsg->QuestIndex)
		{
			//  Ʈ Ʈ Ͱ  
			(*it).nMonsterCount =  pMsg->Count;
			// ̼ Ϸ üũ
			nMissionIndex = SerchMissionCondition();
			if(nMissionIndex != NULL)
			{
				// 2006-03-27 by ispark, Ƽ̼ ߰
				CQuest *pQuest = g_pQuestData->GetProgressMission();
				if(pQuest->IsPartyQuest())
				{
					g_pQuestData->SendFieldSocketQuestRequestSuccessCheck(nMissionIndex);
				}
				else
				{
					g_pGImage->SetImageInfo(MISSION_SUC, TRUE);
				}
			}	
			return;
		}
		it++;
	}
	
	// Ʈ  ߰ ( Ʈ Ͱ )
	pTempMonsterCount.nMonsterCount			= pMsg->Count;
	pTempMonsterCount.nMonsterUnitkind		= pMsg->MonsterUniqueNumber;
	pTempMonsterCount.nQuestIndex			= pMsg->QuestIndex;

	g_pQuestData->m_vecQuestMonsterCount.push_back(pTempMonsterCount);

	// ̼ Ϸ üũ
	nMissionIndex = SerchMissionCondition();
	if(nMissionIndex != NULL)
	{
		// 2006-03-27 by ispark, Ƽ̼ ߰
		CQuest *pQuest = g_pQuestData->GetProgressMission();
		if(pQuest->IsPartyQuest())
		{
			g_pQuestData->SendFieldSocketQuestRequestSuccessCheck(nMissionIndex);
		}
		else
		{
			g_pGImage->SetImageInfo(MISSION_SUC, TRUE);
		}
	}	
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketQuestPutAllQuestMonsterCount(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT* pMsg)
/// \brief		MSG_FC_QUEST_UPDATE_MONSTER_COUNT
/// \author		ydkim
/// \date		2005-10-26~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketQuestPutAllQuestMonsterCount(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT* pMsg)
{
	for(int i=0;i<pMsg->NumOfMonsterCount;i++)
	{
		MEX_QUEST_MONSTER_COUNT* pRecvMonsterCount = (MEX_QUEST_MONSTER_COUNT*)(((char*)pMsg) + sizeof(MSG_FC_QUEST_PUT_ALL_QUEST_MONSTER_COUNT)
										+ sizeof(MEX_QUEST_MONSTER_COUNT)*i);

		Quest_MonsterInfo pTempMonsterCount;
		pTempMonsterCount.nMonsterCount		= pRecvMonsterCount->Count;
		pTempMonsterCount.nMonsterUnitkind	= pRecvMonsterCount->MonsterUniqueNumber;
		pTempMonsterCount.nQuestIndex		= pRecvMonsterCount->QuestIndex;

		g_pQuestData->m_vecQuestMonsterCount.push_back(pTempMonsterCount);
		DBGOUT("QuestMonsterCount(%d:state:%d) Received.\n", pRecvMonsterCount->MonsterUniqueNumber,pRecvMonsterCount->QuestIndex);
	}

	SendMissionComplete();
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketPartyBattleEnd(MSG_FC_PARTY_BATTLE_END* pMsg)
/// \brief		MSG_FC_PARTY_BATTLE_END
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketPartyBattleEnd(MSG_FC_PARTY_BATTLE_END* pMsg)
{
	if(g_pShuttleChild)
		g_pShuttleChild->m_pClientParty->FPartyBattleEnd(pMsg);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemResetSkillEnchantToLoadedItem(void)
/// \brief		
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	SKILL Ķ Ǵ ڵ ٽ ؾ Ѵ.
///
/// \param		void
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemResetSkillEnchantToLoadedItem(void)
{
	FLOG("CAtumApplication::FieldSocketItemResetSkillEnchantToLoadedItem(void)");
//	static BOOL bSet = TRUE;
//	if(bSet)
//	{
//		m_pShuttleChild->SetWeaponData(0,TRUE);//,TRUE);
//	}
//	else
//	{
//		m_pShuttleChild->SetWeaponData(1,TRUE);//,TRUE);
//	}
//	bSet = !bSet;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleToggleShieldResult(MSG_FC_BATTLE_TOGGLE_SHIELD_RESULT* pMsg)
/// \brief		MSG_FC_BATTLE_TOGGLE_SHIELD_RESULT
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleToggleShieldResult(MSG_FC_BATTLE_TOGGLE_SHIELD_RESULT* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleToggleShieldResult(MSG_FC_BATTLE_TOGGLE_SHIELD_RESULT* pMsg)");
	if(pMsg->IsOn)
	{
		if(pMsg->AttackIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			if(m_pShuttleChild && m_pShuttleChild->m_pSecondaryWeapon)
			{
//				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(WEAPON_BODYCON_START);
				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_USE|TOGGLE_WEAPON_BODYCON_USING);
				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_USE|TOGGLE_WEAPON_BODYCON_USING, FALSE);
				m_pShuttleChild->m_pSecondaryWeapon->SetUseToggleWeapon(TRUE);
			}

#ifdef _DEBUG
			char strMessage[256];
			wsprintf(strMessage,STRMSG_C_ITEM_0063);//"  մϴ."
			m_pChat->CreateChatChild(strMessage,COLOR_DEBUG);
#endif
//			m_pShuttleChild->m_bShielding = TRUE; // DP ȭ 
		}
		else
		{
			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				itEnemy->second->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_USE|TOGGLE_WEAPON_BODYCON_USING);
				itEnemy->second->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_USE|TOGGLE_WEAPON_BODYCON_USING, FALSE);
				itEnemy->second->m_bShielding = TRUE;
			}
		}
	}
	else
	{
		if(pMsg->AttackIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			if(m_pShuttleChild && m_pShuttleChild->m_pSecondaryWeapon)
			{
				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_END|TOGGLE_WEAPON_BODYCON_NORMAL);
				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_END|TOGGLE_WEAPON_BODYCON_NORMAL, FALSE);
				m_pShuttleChild->m_pSecondaryWeapon->SetUseToggleWeapon(FALSE);
			}

#ifdef _DEBUG
			char strMessage[256];
			wsprintf(strMessage,STRMSG_C_ITEM_0064);//"  մϴ."
			m_pChat->CreateChatChild(strMessage,COLOR_DEBUG);
#endif
//			m_pShuttleChild->m_bShielding = FALSE; // DP ȭ 
		}
		else
		{
			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				itEnemy->second->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_END|TOGGLE_WEAPON_BODYCON_NORMAL);
				itEnemy->second->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_END|TOGGLE_WEAPON_BODYCON_NORMAL, FALSE);
				itEnemy->second->m_bShielding = FALSE;
			}
		}

	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleToggleDecoyOk(MSG_FC_BATTLE_TOGGLE_DECOY_OK* pMsg)
/// \brief		  /
/// \author		jschoi
/// \date		2004-10-13 ~ 2004-10-13
/// \warning	̰  Ʈ    óѴ.
///				 /  SetParamFactor, ReleaseParamFactor 
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleToggleDecoyOk(MSG_FC_BATTLE_TOGGLE_DECOY_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleToggleDecoyOk(MSG_FC_BATTLE_TOGGLE_DECOY_OK* pMsg)");
	if(pMsg->IsOn)
	{
		if(pMsg->AttackIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			if(m_pShuttleChild && m_pShuttleChild->m_pSecondaryWeapon)
			{
				m_pShuttleChild->m_pSecondaryWeapon->SetUseToggleWeapon(TRUE);
				// 2004-10-13 by jschoi ̰  Ʈ ؾ.
				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_USE|TOGGLE_WEAPON_BODYCON_USING);
				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_USE|TOGGLE_WEAPON_BODYCON_USING, FALSE);

				ITEM *pItem = g_pDatabase->GetServerItemInfo(pMsg->ItemNum);
				if(pItem)
				{
					// 2009-04-21 by bhsohn  DesParam߰
// 					m_pShuttleChild->SetParamFactorDesParam(m_pShuttleChild->m_paramFactor,pItem->DestParameter1,pItem->ParameterValue1);
// 					m_pShuttleChild->SetParamFactorDesParam(m_pShuttleChild->m_paramFactor,pItem->DestParameter2,pItem->ParameterValue2);
// 					m_pShuttleChild->SetParamFactorDesParam(m_pShuttleChild->m_paramFactor,pItem->DestParameter3,pItem->ParameterValue3);
// 					m_pShuttleChild->SetParamFactorDesParam(m_pShuttleChild->m_paramFactor,pItem->DestParameter4,pItem->ParameterValue4);
					int nArrParamCnt = 0;
					for(nArrParamCnt = 0; nArrParamCnt < SIZE_MAX_DESPARAM_COUNT_IN_ITEM; nArrParamCnt++)
					{
						m_pShuttleChild->SetParamFactorDesParam(m_pShuttleChild->m_paramFactor,
																pItem->ArrDestParameter[nArrParamCnt],
																pItem->ArrParameterValue[nArrParamCnt]);

					}					
					// end 2009-04-21 by bhsohn  DesParam߰
				}
			}

#ifdef _DEBUG
			char strMessage[256];
			wsprintf(strMessage,STRMSG_C_ITEM_0065);//"  մϴ."
			m_pChat->CreateChatChild(strMessage,COLOR_DEBUG);
#endif
		}
		else
		{
			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				// 2004-10-13 by jschoi ̰  Ʈ ؾ.
				itEnemy->second->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_USE|TOGGLE_WEAPON_BODYCON_USING);
				itEnemy->second->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_USE|TOGGLE_WEAPON_BODYCON_USING, FALSE);

			}
		}
	}
	else
	{
		if(pMsg->AttackIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			if(m_pShuttleChild && m_pShuttleChild->m_pSecondaryWeapon)
			{
				m_pShuttleChild->m_pSecondaryWeapon->SetUseToggleWeapon(FALSE);
				// 2004-10-13 by jschoi ̰  Ʈ ؾ.
				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_END|TOGGLE_WEAPON_BODYCON_NORMAL);
				m_pShuttleChild->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_END|TOGGLE_WEAPON_BODYCON_NORMAL, FALSE);

				ITEM *pItem = g_pDatabase->GetServerItemInfo(pMsg->ItemNum);
				if(pItem)
				{
					// 2009-04-21 by bhsohn  DesParam߰
// 					m_pShuttleChild->ReleaseParamFactorDesParam(m_pShuttleChild->m_paramFactor,pItem->DestParameter1,pItem->ParameterValue1);
// 					m_pShuttleChild->ReleaseParamFactorDesParam(m_pShuttleChild->m_paramFactor,pItem->DestParameter2,pItem->ParameterValue2);
// 					m_pShuttleChild->ReleaseParamFactorDesParam(m_pShuttleChild->m_paramFactor,pItem->DestParameter3,pItem->ParameterValue3);
// 					m_pShuttleChild->ReleaseParamFactorDesParam(m_pShuttleChild->m_paramFactor,pItem->DestParameter4,pItem->ParameterValue4);
					int nArrParamCnt = 0;
					for(nArrParamCnt = 0; nArrParamCnt < SIZE_MAX_DESPARAM_COUNT_IN_ITEM; nArrParamCnt++)
					{
						m_pShuttleChild->ReleaseParamFactorDesParam(m_pShuttleChild->m_paramFactor,
																	pItem->ArrDestParameter[nArrParamCnt],
																	pItem->ArrParameterValue[nArrParamCnt]);
					}					
					// end 2009-04-21 by bhsohn  DesParam߰
				}
			}
			
			
#ifdef _DEBUG
			char strMessage[256];
			wsprintf(strMessage,STRMSG_C_ITEM_0066);//"  մϴ."
			m_pChat->CreateChatChild(strMessage,COLOR_DEBUG);
#endif
		}
		else
		{
			CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
			if(itEnemy != m_pScene->m_mapEnemyList.end())
			{
				// 2004-10-13 by jschoi ̰  Ʈ ؾ.
				// ϴ  ͼ ̹   Ʈ  ׳ ؾ.
				// Enemy  ˾Ƽ Ʈ  Ѵ.
				itEnemy->second->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_END|TOGGLE_WEAPON_BODYCON_NORMAL);
				itEnemy->second->ResetSecondaryWeaponBodyCondition(TOGGLE_WEAPON_BODYCON_END|TOGGLE_WEAPON_BODYCON_NORMAL, FALSE);
				
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattlePriBulletReloaded(MSG_FC_BATTLE_PRI_BULLET_RELOADED* pMsg)
/// \brief		MSG_FC_BATTLE_PRI_BULLET_RELOADED
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattlePriBulletReloaded(MSG_FC_BATTLE_PRI_BULLET_RELOADED* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattlePriBulletReloaded(MSG_FC_BATTLE_PRI_BULLET_RELOADED* pMsg)");
	m_pShuttleChild->PrimaryBulletReloaded( pMsg );

	// 2005-11-08 by ispark
	//   Ÿ 
	g_pInterface->m_pCityBase->RecvRequestRepair();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleSecBulletReloaded(MSG_FC_BATTLE_SEC_BULLET_RELOADED* pMsg)
/// \brief		MSG_FC_BATTLE_SEC_BULLET_RELOADED
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleSecBulletReloaded(MSG_FC_BATTLE_SEC_BULLET_RELOADED* pMsg)
{
	FLOG("CAtumApplication::FieldSocketBattleSecBulletReloaded(MSG_FC_BATTLE_SEC_BULLET_RELOADED* pMsg)");
	m_pShuttleChild->SecondaryBulletReloaded( pMsg );

	// 2005-11-08 by ispark
	//   Ÿ 
	g_pInterface->m_pCityBase->RecvRequestRepair();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketEventChangeWeather(MSG_FC_EVENT_CHANGE_WEATHER* pMsg)
/// \brief		MSG_FC_EVENT_CHANGE_WEATHER
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventChangeWeather(MSG_FC_EVENT_CHANGE_WEATHER* pMsg)
{
	FLOG("CAtumApplication::FieldSocketEventChangeWeather(MSG_FC_EVENT_CHANGE_WEATHER* pMsg)");
	SetFogLevel( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex, !m_pScene->m_bNight );
	m_pScene->m_byWeatherType = pMsg->MapWeather;
	m_pScene->m_bChangeWeather = TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUpdateItemPos(MSG_FC_ITEM_UPDATE_ITEM_POS* pMsg)
/// \brief		MSG_FC_ITEM_UPDATE_ITEM_POS, Ÿĳ  ü
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUpdateItemPos(MSG_FC_ITEM_UPDATE_ITEM_POS* pMsg)
{
	FLOG("CAtumApplication::FieldSocketItemUpdateItemPos(MSG_FC_ITEM_UPDATE_ITEM_POS* pMsg)");
	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
	if(itEnemy != m_pScene->m_mapEnemyList.end())
	{

		// 2009. 08. 27 by ckPark ׷ ҽ  ý 
		//itEnemy->second->ChangeItemPoint(pMsg->ItemPosition,pMsg->ItemNum, pMsg->ColorCode);

// 2012-07-06 by mspark, æƮ Ʈ
#ifdef C_ENCHANT_EFFECT_MSPARK
		itEnemy->second->m_infoCharacter.CharacterRenderInfo.SetRenderEnchantEffect(pMsg->nEnchantEffect_Primary, pMsg->nEnchantEffect_Secondary);
#endif
// end 2012-07-06 by mspark, æƮ Ʈ

// 2012-07-19 by isshin, ۹̸
#ifdef C_ENEMY_INFO_ISSHIN
		g_pGameMain->m_pCommunity->UpdateEnemyItemInfo(TRUE, pMsg->ClientIndex);
#endif
// end 2012-07-19 by isshin, ۹̸

		// 2012-11-29 by bhsohn Ʈ   Ʈ 
//		itEnemy->second->ChangeItemPoint( pMsg->ItemPosition,pMsg->ItemNum, pMsg->nShapeItemNum, pMsg->nEffectItemNum );
		itEnemy->second->ChangeItemPoint( pMsg->ItemPosition,pMsg->ItemNum, pMsg->nShapeItemNum, pMsg->nEffectItemNum, pMsg->nPetLevel);
		// END 2012-11-29 by bhsohn Ʈ   Ʈ 
		itEnemy->second->m_infoCharacter.CharacterRenderInfo.SetRenderInfoWithPOS( pMsg->ItemPosition,pMsg->ItemNum, pMsg->nShapeItemNum, pMsg->nEffectItemNum );
		// end 2009. 08. 27 by ckPark ׷ ҽ  ý 

	}
	else
	{// ĳͰ -Error
		DBGOUT("CAtumApplication::FieldSocketItemUpdateItemPos(MSG_FC_ITEM_UPDATE_ITEM_POS* pMsg) \n");
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCharacterGetOtherRenderInfoOk(MSG_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK* pMsg)
/// \brief		MSG_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterGetOtherRenderInfoOk(MSG_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketCharacterGetOtherRenderInfoOk(MSG_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK* pMsg)");
	// Ÿĳ  ü
	if(m_dwGameState == _CITY)
	{
		DBGOUT("MSG_FC_CHARACTER_GET_OTHER_RENDER_INFO_OK in CITY \n");
		return;
	}
	CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
	if(itEnemy != m_pScene->m_mapEnemyList.end())
	{//
		memcpy(&(itEnemy->second->m_infoCharacter.CharacterRenderInfo),&pMsg->CharacterRenderInfo,sizeof(CHARACTER_RENDER_INFO));
		itEnemy->second->InitItemPoint();
		//  
	}
	else
	{// ĳͰ -Error
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInfoGetBuildingNPCInfoOk(MSG_FC_INFO_GET_BUILDINGNPC_INFO_OK* pMsg)
/// \brief		MSG_FC_INFO_GET_BUILDINGNPC_INFO_OK
/// \author		dhkwon
/// \date		2004-04-12 ~ 2004-04-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetBuildingNPCInfoOk(MSG_FC_INFO_GET_BUILDINGNPC_INFO_OK* pMsg)
{
	EnterCriticalSection(&m_cs);
	BUILDINGNPC * pInfo = m_pDatabase->UpdateBuildingNPCInfo(pMsg->BuildingNPCInfo);
	LeaveCriticalSection(&m_cs);
	m_pInterface->m_pCityBase->SetDetailBuildingInfo( pMsg->BuildingNPCInfo );
	DBGOUT("RECV GET_BUILDINGNPC_INFO_OK, Building(%s),NPC(%d,%s)\n",pMsg->BuildingNPCInfo.BuildingName, pMsg->BuildingNPCInfo.NPCIndex, pMsg->BuildingNPCInfo.NPCName);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketConnectClose(MSG_FC_CONNECT_CLOSE* pMsg)
/// \brief		MSG_FC_CONNECT_CLOSE
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketConnectClose(MSG_FC_CONNECT_CLOSE* pMsg)
{
	FLOG("CAtumApplication::FieldSocketConnectClose(MSG_FC_CONNECT_CLOSE* pMsg)");
	char message[256];
	wsprintf(message,STRMSG_C_SERVER_0012,pMsg->reason);//" Ǿϴ.  ˴ϴ.  [%d]"
	NetworkErrorMsgBox(message);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketEventSuggestChannels(MSG_FC_EVENT_SUGGEST_CHANNELS* pMsg)
/// \brief		MSG_FC_EVENT_SUGGEST_CHANNELS
/// \author		dhkwon
/// \date		2004-03-29 ~ 2004-03-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventSuggestChannels(MSG_FC_EVENT_SUGGEST_CHANNELS* pMsg)
{
	char *p = (char *)pMsg;
	p += sizeof(MSG_FC_EVENT_SUGGEST_CHANNELS);

	ChangeGameState(_SELECTCHANNEL);
	m_pInterface->InitChannelListObjects();//g_pChannelList
	m_pInterface->RestoreChannelListObjects();
	ASSERT_ASSERT(g_pChannelList);

	g_pChannelList->RecvStartChannelList(pMsg->MapIndex, pMsg->WarpTargetIndex);
	
	DBGOUT("-------------------Channel Information------------------\n");
	for(int i=0;i<pMsg->NumOfChannels;i++)
	{
		g_pChannelList->RecvChannelList((MEX_CHANNEL_INFO*)p);
		DBGOUT("    Channel Number : %d, Crowdedness : %d%%\n", ((MEX_CHANNEL_INFO*)p)->ChannelIndex, ((MEX_CHANNEL_INFO*)p)->Crowdedness );
		p += sizeof(MEX_CHANNEL_INFO);
	}
	g_pChannelList->RecvDoneChannelList();
	DBGOUT("-------------------Channel Information Done-------------\n", COLOR_SKILL_USE);

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCityGetBuildingListOk(MSG_FC_CITY_GET_BUILDING_LIST_OK* pMsg)
/// \brief		MSG_FC_CITY_GET_BUILDING_LIST_OK
/// \author		dhkwon
/// \date		2004-04-12 ~ 2004-04-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCityGetBuildingListOk(MSG_FC_CITY_GET_BUILDING_LIST_OK* pMsg)
{
	char *p = (char *)pMsg;
	p += sizeof(MSG_FC_CITY_GET_BUILDING_LIST_OK);

	DBGOUT("-----------------Shop Information----------------------\n");
	for(int i=0;i<pMsg->NumOfBuildings;i++)
	{
		CITY_BUILDING_INFO_4_EXCHANGE briefBuildingInfo;
		memcpy(&briefBuildingInfo, p, sizeof(CITY_BUILDING_INFO_4_EXCHANGE));
		//////////////////////////////////////////////////////////////////////
		DBGOUT("Shop Information :[Index:%d][Kind:%d]\n", briefBuildingInfo.BuildingIndex, briefBuildingInfo.BuildingKind );

		if(briefBuildingInfo.BuildingKind != 100 || !m_bTestServer)
		{
			m_pInterface->m_pCityBase->AddBuildingIndexList( briefBuildingInfo );
		}
		//////////////////////////////////////////////////////////////////////
		p += sizeof(CITY_BUILDING_INFO_4_EXCHANGE);
	}
	DBGOUT("----------------Shop Information End---------------------\n");
	if(g_pInterface->m_pCityBase)
	{
		g_pInterface->m_pCityBase->SetButtonEnableByLevel(g_pShuttleChild->m_myShuttleInfo.Level);
	}
//	SendFieldSocketGetShopWarpTargetMapList( m_pShuttleChild->m_myShuttleInfo.MapChannelIndex );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketGetShopWarpTargetMapListOk(MSG_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST_OK* pMsg)
/// \brief		MSG_FC_CITY_GET_WARP_TARGET_MAP_LIST_OK
/// \author		dhkwon
/// \date		2004-04-12 ~ 2004-04-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketGetShopWarpTargetMapListOk(MSG_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST_OK* pMsg)
{
	char *p = (char *)pMsg;
	p += sizeof(MSG_FC_EVENT_GET_SHOP_WARP_TARGET_MAP_LIST_OK);

	ASSERT_ASSERT(g_pInterface->m_pCityBase);
	CINFCityWarp* pCityWarp = g_pInterface->m_pCityBase->GetCityWarp();
	DBGOUT("-----------------City Warp Information----------------------\n");
	if(pCityWarp)
	{
		pCityWarp->Reset();
		for(int i=0;i<pMsg->NumOfTargetMaps;i++)
		{
			pCityWarp->AddWarpTargetInfoList((WARP_TARGET_MAP_INFO_4_EXCHANGE*)p);
			DBGOUT("City Warp Information :[Index:%d]\n", ((WARP_TARGET_MAP_INFO_4_EXCHANGE*)p)->MapIndex );
			p += sizeof(WARP_TARGET_MAP_INFO_4_EXCHANGE);
		}
		pCityWarp->RecvWarpListDone();
	}
	DBGOUT("----------------City Warp Information End---------------------\n");

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketAdminGetServerStatOk(MSG_FC_ADMIN_GET_SERVER_STAT_OK* pMsg)
/// \brief		 ü  
/// \author		dhkwon
/// \date		2004-05-13 ~ 2004-05-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketAdminGetServerStatOk(MSG_FC_ADMIN_GET_SERVER_STAT_OK* pMsg)
{
// 2012-11-07 by bhsohn Ʈ Ŷ ó
#ifdef C_CLIENT_LIVE_TIME
	m_fServerLiveTime = MAX_CLIENT_LIVE_TIME;
	if(!GetEnterLock())
	{
		EnterLock(TRUE);	// FALSE :Lock  TRUE : UnLock
	}
#endif
// END 2012-11-07 by bhsohn Ʈ Ŷ ó

	wsprintf(m_strMapUserNum, "MAP USER [ %d ] [%d(%d)]", 
		pMsg->CurrentUserCount,
		pMsg->CurrentMapChannelIndex.MapIndex,
		pMsg->CurrentMapChannelIndex.ChannelIndex);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketString128(MSG_FC_STRING_128* pMsg)
/// \brief		MSG_FC_STRING_128
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketString128(MSG_FC_STRING_128* pMsg)
{
	FLOG("CAtumApplication::FieldSocketString128(MSG_FC_STRING_128* pMsg)");
	if(pMsg->PrintType == STR128_PRINT_TYPE_CHAT)
	{// ä â 
		if(m_pChat)
		{	
			m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
			m_pChat->SetNumField(pMsg->SecurityNumber);				// 2011-11-01 by jhahn ȣȭ ó
// 2011-06-30 by jhahn  缳 н
#ifdef C_SECURITY_COMMAND_JHAHN
			char buf[256];
			wsprintf(buf, "FieldSocket128 %0d", pMsg->SecurityNumber);
			m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
#endif	
//end 2011-06-30 by jhahn  缳 н
			// 2012-06-19 by jhseol, Ʒ ߰part2  :      ũ Ͽ   
			if( 0 == strncmp(pMsg->String, STRMSG_S_F2NOTIFY_0107, strlen(STRMSG_S_F2NOTIFY_0107)))
			{
				g_pShuttleChild->SetUnitAlpha(CL_SKILL_CAMOUFLAGE, SKILL_OBJECT_ALPHA_DEFAULT);
			}
			else if( 0 == strncmp(pMsg->String, STRMSG_S_F2NOTIFY_0108, strlen(STRMSG_S_F2NOTIFY_0108)))
			{
				g_pShuttleChild->SetUnitAlpha(CL_SKILL_NONE, SKILL_OBJECT_ALPHA_NONE);
			}
			// end 2012-06-19 by jhseol, Ʒ ߰part2  :      ũ Ͽ   
		}



	}
	else if(pMsg->PrintType == STR128_PRINT_TYPE_STATIC)
	{
		memset(m_strDebug,0x00,sizeof(m_strDebug));
		memcpy(m_strDebug,pMsg->String,strlen(pMsg->String));
	}
	else if (pMsg->PrintType == STR128_PRINT_TYPE_DBGOUT)
	{	
		DbgOut("%s\n", pMsg->String);	
	}
	else if (pMsg->PrintType == STR128_PRINT_TYPE_NOTICE)
	{
		
		DbgOut("%s\n", pMsg->String);	
		AddSpeakerGMString(pMsg->String, FALSE);   // 2012-04-18 by jhahn  Ʈ ý ˸ 
	}

	
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketString256(MSG_FC_STRING_256* pMsg)
/// \brief		MSG_FC_STRING_256
/// \author		
/// \date		
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketString256(MSG_FC_STRING_256* pMsg)
{
	FLOG("CAtumApplication::FieldSocketString128(MSG_FC_STRING_128* pMsg)");
	if(pMsg->PrintType == STR128_PRINT_TYPE_CHAT)
	{// ä â 
		if(m_pChat)
		{
			m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
			m_pChat->SetNumField(pMsg->SecurityNumber);				// 2011-11-01 by jhahn ȣȭ ó
//2011-06-30 by jhahn  缳 н
#ifdef C_SECURITY_COMMAND_JHAHN
			char buf[256];
			wsprintf(buf, "FieldSocket256 %0d", pMsg->SecurityNumber);
			m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
#endif	
//end 2011-06-30 by jhahn  缳 н
		}
	}

	else if(pMsg->PrintType == STR128_PRINT_TYPE_STATIC)
	{
		memset(m_strDebug,0x00,sizeof(m_strDebug));
		memcpy(m_strDebug,pMsg->String,strlen(pMsg->String));
	}
	else if (pMsg->PrintType == STR128_PRINT_TYPE_DBGOUT)
	{
		
		DbgOut("%s\n", pMsg->String);	
	}
	else if (pMsg->PrintType == STR128_PRINT_TYPE_NOTICE)
	{
		
		DbgOut("%s\n", pMsg->String);	
		AddSpeakerGMString(pMsg->String, FALSE);   // 2012-04-18 by jhahn  Ʈ ý ˸ 
	}

}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketString512(MSG_FC_STRING_512* pMsg)
/// \brief		MSG_FC_STRING_128
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketString512(MSG_FC_STRING_512* pMsg)
{
	FLOG("CAtumApplication::FieldSocketString128(MSG_FC_STRING_128* pMsg)");
	if(pMsg->PrintType == STR128_PRINT_TYPE_CHAT)
	{// ä â 
		if(m_pChat)
		{
			m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
			m_pChat->SetNumField(pMsg->SecurityNumber);				// 2011-11-01 by jhahn ȣȭ ó
//2011-06-30 by jhahn  缳 н
#ifdef C_SECURITY_COMMAND_JHAHN
			char buf[256];
			wsprintf(buf, "FieldSocket512 %0d", pMsg->SecurityNumber);
			m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
#endif	
//end 2011-06-30 by jhahn  缳 н
		}
	}

	else if(pMsg->PrintType == STR128_PRINT_TYPE_STATIC)
	{
		memset(m_strDebug,0x00,sizeof(m_strDebug));
		memcpy(m_strDebug,pMsg->String,strlen(pMsg->String));
	}
	else if (pMsg->PrintType == STR128_PRINT_TYPE_DBGOUT)
	{		
		DbgOut("%s\n", pMsg->String);	
	}
	else if (pMsg->PrintType == STR128_PRINT_TYPE_NOTICE)
	{
		
		DbgOut("%s\n", pMsg->String);	
		AddSpeakerGMString(pMsg->String, FALSE);   // 2012-04-18 by jhahn  Ʈ ý ˸ 
	}

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMonsterSkillUseSkill(MSG_FC_MONSTER_SKILL_USE_SKILL* pMsg)
/// \brief		Monster Skill - Use Skill
/// \author		jschoi
/// \date		2004-06-25 ~ 2004-06-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMonsterSkillUseSkill(MSG_FC_MONSTER_SKILL_USE_SKILL* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMonsterSkillUseSkill(MSG_FC_MONSTER_SKILL_USE_SKILL* pMsg)");

	CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);

	if(itMonster != m_pScene->m_mapMonsterList.end())
	{
		if(g_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex)
		{
			itMonster->second->m_bSkillEnd = TRUE;	//   ų Ḧ ˷Ѵ.
		}
		itMonster->second->m_nMonsterSkillState = MONSTER_SKILL_ON;
		itMonster->second->InitMonsterMovePattern(pMsg->SkillItemNum);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketMonsterSkillEndSkill(MSG_FC_MONSTER_SKILL_END_SKILL* pMsg)
/// \brief		Monster Skill - End Skill
/// \author		jschoi
/// \date		2004-06-25 ~ 2004-06-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMonsterSkillEndSkill(MSG_FC_MONSTER_SKILL_END_SKILL* pMsg)
{
	FLOG("CAtumApplication::FieldSocketMonsterSkillEndSkill(MSG_FC_MONSTER_SKILL_END_SKILL* pMsg)");	
	CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);

	if(itMonster != m_pScene->m_mapMonsterList.end())
	{
		itMonster->second->m_nMonsterSkillState = MONSTER_SKILL_OFF;
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketObjectChangeBodyConditionOk(MSG_FC_OBJECT_CHANGE_BODYCONDITION_OK* pMsg)
/// \brief		 Ʈ ٵ Ѵ.
/// \author		jschoi
/// \date		2004-11-27 ~ 2004-11-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketObjectChangeBodyConditionOk(MSG_FC_OBJECT_CHANGE_BODYCONDITION_OK* pMsg)
{
	CObjectChild* pObj = g_pScene->FindMapObjectByCodeAndPosition(pMsg->nObjectCodeNum,A2DX(pMsg->AVec3Position));
	if(pObj)
	{
		// 2008-06-24 by dgwoo   ߰.
		//m_pSound->PlayD3DSound(SOUND_WARP, A2DX(pMsg->AVec3Position));
		if(pObj->m_pObjectInfo->Code == WARP_GATE_OBJECT_NUM_2||pObj->m_pObjectInfo->Code == WARP_GATE_OBJECT_NUM_3)// 2012-06-13 by jhahn  Ʈ ߰2.
		{
			m_pSound->PlayD3DSound(SOUND_WARP_2,A2DX(pMsg->AVec3Position));
		}
		else
		{
			m_pSound->PlayD3DSound(SOUND_WARP,A2DX(pMsg->AVec3Position));
		}

		
		pObj->ChangeBodycondition(pMsg->bodyCondition);
		
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketObjectChangeBodyConditionOk(MSG_FC_AUCTION_INSERT_ITEM* pMsg)
/// \brief		   ޾Ƽ  ü  Ѵ
/// \author		ydkim
/// \date		2004-12-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketAuctionInsertItem(MSG_FC_AUCTION_INSERT_ITEM* pMsg)
{
	GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
	if(pBuilding == NULL)
	{
		return;
	}
	int nBuildingKind = pBuilding->buildingInfo.BuildingKind;
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildingKind);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end())
	{
		return;
	}
	
	if(IS_AUCTION_SHOP_TYPE(nBuildingKind))
	{
		((CINFCityAuction*)it->second)->InputItem(pMsg);
	}

}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketAuctionRegisterItemOk(MSG_FC_AUCTION_REGISTER_ITEM_OK* pMsg)
/// \brief		   
/// \author		ydkim
/// \date		2004-12-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketAuctionRegisterItemOk(MSG_FC_AUCTION_REGISTER_ITEM_OK* pMsg)
{	
	GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
	if(pBuilding == NULL)
	{
		return;
	}
	int nBuildingKind = pBuilding->buildingInfo.BuildingKind;
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildingKind);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end())
	{
		return;
	}

	if(IS_AUCTION_SHOP_TYPE(nBuildingKind))
	{
		((CINFCityAuction*)it->second)->m_vecAuctionItem[((CINFCityAuction*)it->second)->m_nCurrentTab].clear();
		((CINFCityAuction*)it->second)->AuctionItemInfoView(((CINFCityAuction*)it->second)->m_nCurrentTab);
		CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber(pMsg->ItemUID);
		if(pItemInfo)
		{
			g_pStoreData->DeleteItem(pItemInfo->UniqueNumber);
		}
		g_pD3dApp->m_pChat->CreateChatChild(STRMSG_C_AUCTION_0011,COLOR_SYSTEM);//"  Ͽ  Ǿϴ"
	}	
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketAuctionCancerRegisterOk(MSG_FC_AUCTION_REGISTER_ITEM_OK* pMsg)
/// \brief		    
/// \author		ydkim
/// \date		2004-12-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketAuctionCancerRegisterOk(MSG_FC_AUCTION_CANCEL_REGISTER_OK* pMsg)
{
	GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
	if(pBuilding == NULL)
	{
		return;
	}
	int nBuildingKind = pBuilding->buildingInfo.BuildingKind;
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildingKind);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end())
	{
		return;
	}

	if(IS_AUCTION_SHOP_TYPE(nBuildingKind))
	{
		((CINFCityAuction*)it->second)->m_vecAuctionItem[((CINFCityAuction*)it->second)->m_nCurrentTab].clear();
		((CINFCityAuction*)it->second)->AuctionItemInfoView(((CINFCityAuction*)it->second)->m_nCurrentTab);
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketAuctionBuyItemOk(MSG_FC_AUCTION_BUY_ITEM_OK* pMsg)
/// \brief		   
/// \author		ydkim
/// \date		2004-12-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketAuctionBuyItemOk(MSG_FC_AUCTION_BUY_ITEM_OK* pMsg)
{
	GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
	if(pBuilding == NULL)
	{
		return;
	}
	int nBuildingKind = pBuilding->buildingInfo.BuildingKind;
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildingKind);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end())
	{
		return;
	}

	if(IS_AUCTION_SHOP_TYPE(nBuildingKind))
	{
		((CINFCityAuction*)it->second)->m_vecAuctionItem[((CINFCityAuction*)it->second)->m_nCurrentTab].clear();
		((CINFCityAuction*)it->second)->AuctionItemInfoView(((CINFCityAuction*)it->second)->m_nCurrentTab);
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketAuctionPutEnchant(MSG_FC_AUCTION_PUT_ENCHANT* pMsg)
/// \brief		  æƮ 
/// \author		ydkim
/// \date		2004-12-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketAuctionPutEnchant(MSG_FC_AUCTION_PUT_ENCHANT* pMsg)
{
	GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
	if(pBuilding == NULL)
	{
		return;
	}
	int nBuildingKind = pBuilding->buildingInfo.BuildingKind;
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildingKind);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end())
	{
		return;
	}

	if(IS_AUCTION_SHOP_TYPE(nBuildingKind))
	{		
		((CINFCityAuction*)it->second)->AddEnchantItem(pMsg->AuctionKind, pMsg->AuctionItemEnchant.TargetItemUniqueNumber, pMsg->AuctionItemEnchant.EnchantItemNum);
	}
}

//	CINFCityAuction * pCityAuction = (CINFCityAuction*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_FACTORY);
//	if(pCityAuction)
//	{
//		AuctionItem_t pAuctionItem;
//		memset(&pAuctionItem, 0x00, sizeof(AuctionItem_t));
//		pAuctionItem.AuctionItemGeneral		= pMsg->AuctionItemGeneral;
//		pAuctionItem.AuctionKind			= pMsg->AuctionKind;
//		pAuctionItem.AuctionPrice			= pMsg->AuctionPrice;
//		pAuctionItem.AuctionStartDate		= pMsg->AuctionStartDate;
//		strncpy(pAuctionItem.SellerCharacterName, pMsg->SellerCharacterName, sizeof(pMsg->SellerCharacterName));
//		
////		pCityAuction->m_vecAuctionItem.push_back(&pAuctionItem);
//	}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketItemMixItemsResult(MSG_FC_ITEM_MIX_ITEMS_RESULT* pMsg)
/// \brief		MSG_FC_ITEM_MIX_ITEMS_RESULT
/// \author		dhkwon
/// \date		2004-07-19 ~ 2004-07-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemMixItemsResult(MSG_FC_ITEM_MIX_ITEMS_RESULT* pMsg)
{
	if( pMsg->Err != ERR_NO_ERROR )
	{
		CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_FACTORY);
		if(pCityLab)
		{
			pCityLab->InitData();
		}
		g_pGameMain->m_pInfWindow->AddMsgBox( STRERR_C_MIX_0002, _MESSAGE );
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketGuildGetWarInfoOk(MSG_FC_GUILD_GET_WAR_INFO_OK* pMsg)
/// \brief		MSG_FC_GUILD_GET_WAR_INFO_OK
/// \author		dhkwon
/// \date		2004-07-26 ~ 2004-07-26
/// \warning	   ޽ ޾ƾ  õȴ.
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketGuildGetWarInfoOk(MSG_FC_GUILD_GET_WAR_INFO_OK* pMsg)
{
	MSG_IC_GUILD_GET_GUILD_INFO_OK* pGuild = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
	if(pGuild)
	{
		g_pShuttleChild->m_pGuildWarInfo = new MSG_FC_GUILD_GET_WAR_INFO_OK;
		g_pShuttleChild->m_pGuildWarInfo->MapChannel = pMsg->MapChannel;
		g_pShuttleChild->m_pGuildWarInfo->PeerGuildUID = pMsg->PeerGuildUID;
	}
	m_pScene->SetPKSettingGuildWar( pMsg->PeerGuildUID, TRUE );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		jschoi
/// \date		2005-03-25 ~ 2005-03-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketGuildSummonMember(MSG_FC_GUILD_SUMMON_MEMBER* pMsg)
{
	//  ü û
	if(	g_pShuttleChild &&
		g_pShuttleChild->m_pClientParty )
	{
		if(g_pShuttleChild->m_pClientParty->IsFormationFlightMove() )
		{
			g_pShuttleChild->SendPacket(T_IC_PARTY_CANCEL_FLIGHT_POSITION);
			g_pShuttleChild->m_pClientParty->FormationFlightClear();
		}
		if(g_pShuttleChild->m_pClientParty->GetPartyInfo().bPartyType == _PARTYMASTER)
		{
			g_pShuttleChild->m_pClientParty->ISendPartyChangeFlightFormation(0);
		}
	}

	MSG_FC_GUILD_SUMMON_MEMBER_OK sMsg;
	memset(&sMsg,0x00,sizeof(sMsg));
	sMsg.uidGuildUID = pMsg->uidGuildUID;
	sMsg.MapChannel = pMsg->MapChannel;
	sMsg.PositionVector = pMsg->PositionVector;
	g_pFieldWinSocket->SendMsg( T_FC_GUILD_SUMMON_MEMBER_OK, (char*)&sMsg, sizeof(sMsg) );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		ydkim
/// \date		2005-03-28 ~ 2005-03-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseCarditemRestoreNotify(MSG_FC_ITEM_USE_CARDITEM_RESTORE_NOTIFY* pMsg)
{
	if(g_pShuttleChild->m_myShuttleInfo.ClientIndex != pMsg->restoreClientIdx)
	{
		return;
	}
	
	vector<CINFMessageBox*>::iterator it = g_pGameMain->m_pInfWindow->m_vecMessageBox.begin();
	while(it != g_pGameMain->m_pInfWindow->m_vecMessageBox.end())
	{
		CINFMessageBox* pMsgBox = *it;
		// ޼ ڽ (ȯ)
		if(_Q_TRADE_REQUEST == pMsgBox->m_nMsgType)
		{
			g_pGameMain->m_pTrade->SendTradeReject();
		}

		//  1:1 ȭ 
		if(_Q_VOIP_OK == pMsgBox->m_nMsgType)
		{
			MSG_IC_VOIP_ERROR sMsg;
			sMsg.nErrorNum = VOIPERR_1to1_REJECT;
			sMsg.nSend2AccountUniqueNumber = g_pD3dApp->m_VOIPState.nCalledAccountUniqueNumber;
			g_pIMSocket->SendMsg( T_IC_VOIP_ERROR, (char*)&sMsg, sizeof(sMsg) );
			// State ʱȭ
			//memset(&g_pD3dApp->m_VOIPState, 0x00, sizeof(g_pD3dApp->m_VOIPState));
			g_pD3dApp->m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
			g_pD3dApp->m_VOIPState.bCaller = FALSE;
		}

		//  1:1  
		if(_Q_PK_REQUEST == pMsgBox->m_nMsgType)
		{
			MSG_FC_BATTLE_REJECT_REQUEST_P2P_PK sMsg;
			memset(&sMsg,0x00,sizeof(sMsg));
			char buffer[SIZE_MAX_PACKET];
			int nType = T_FC_BATTLE_REJECT_REQUEST_P2P_PK;
			sMsg.SourceClientIndex = pMsgBox->m_dwData;
			memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
			memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sMsg, sizeof(sMsg));
			g_pD3dApp->m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sMsg));
			pMsgBox->m_dwData = 0;
		}

		g_pGameMain->m_pInfWindow->m_vecMessageBox.erase(it);		
		delete pMsgBox;
		pMsgBox = NULL;
		continue;
		
		it++;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		ydkim
/// \date		2005-03-28 ~ 2005-03-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseCarditemGuildsummonNotify(MSG_FC_ITEM_USE_CARDITEM_GUILDSUMMON_NOTIFY* pMsg)
{
}


///////////////////////////////////////////////////////////////////////////////
/// \class		FieldSocketInfoGetHappyHourEventInfoOk(MSG_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_OK* pMsg)
/// \brief		Ǿƿ ̺Ʈ  PC ̺Ʈ  äâ 
///
/// \author		dgwoo
/// \version	
/// \date		2006-09-01 ~ 2006-09-01
/// \warning	
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetHappyHourEventInfoOk(BOOL bLevelUp, MSG_FC_INFO_GET_HAPPY_HOUR_EVENT_INFO_OK* pMsg)
{	
	char szNotice[1024];
	memset(szNotice, 0x00, 1024);
	if(g_pGameMain != NULL && g_pGameMain->m_pUnitInfoBar != NULL)
		g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.clear();
	else
		return;	

	// 2007-01-25 by dgwoo byStateType 0(), 1(۵), 2()
	if(pMsg->byStateType%10)
		g_pGameMain->m_pUnitInfoBar->SetHappyHourEventIconPos();
	
	switch(pMsg->byStateType) 
	{
	case HAPPYEV_STATE_TYPE_END:
		{
			// 2007-11-01 by bhsohn  ƿ ̺Ʈ ó  
			char chInfluence[256];
			memset(chInfluence, 0x00, 256);			
			// ±۾
			wsprintf(chInfluence, CAtumSJ::GetInfluenceTypeString(pMsg->byInfluenceType4));			

			//sprintf(szNotice, STRMSG_C_EVENT_0001);//"Ǿƿ ̺Ʈ Ǿϴ."
			sprintf(szNotice, STRMSG_C_071101_0203, chInfluence);//%s Ǿƿ ̺Ʈ Ǿϴ.
			// 2008-03-14 by bhsohn   Ǿƿ ó
			if(!bLevelUp)
			{
				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
			}

			g_pGameMain->m_pUnitInfoBar->SetHappyHourInfluence(bLevelUp, FALSE, pMsg);
			
			//g_pGameMain->m_pUnitInfoBar->m_BHappyHourEvent &= 0x10;
//			memset(&g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo,0x00,sizeof(EVENT_INFO));
//			sprintf(szNotice, STRMSG_C_EVENT_0001);//"Ǿƿ ̺Ʈ Ǿϴ."
//			m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);		
//
//			//  Ǿ ȿᳪ?
//			//if(0x10 | g_pGameMain->m_pUnitInfoBar->m_BHappyHourEvent)
//			if(g_pGameMain->m_pUnitInfoBar->IsHappyHourEvent())
//			{//Ǿ ̺Ʈ ȿϸ
//				if(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRate > 0.0f)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0003,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRate)*100);//" ġ %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropRareRate > 0.0f)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0004,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropRareRate)*100);//"ɼ  %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRepairRate > 0.0f)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0005,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRepairRate)*100);//"׾  гƼ %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropItemRate > 0.0f)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0006,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropItemRate)*100);//"  %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fSPIRate > 0.0f)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0007,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fSPIRate)*100);//"Ƿ %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fWarPointRate > 0.0f)
//				{// 2007-06-26 by dgwoo  Ʈ ߰.
//					sprintf(szNotice, STRMSG_C_070626_0100,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fWarPointRate)*100);//"Ƿ %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//			}
		}
		break;
	case HAPPYEV_STATE_TYPE_STARTING:
	case HAPPYEV_STATE_TYPE_START:
		{
			// 2007-11-01 by bhsohn  ƿ ̺Ʈ ó  
			char chInfluence[256];
			memset(chInfluence, 0x00, 256);			

			// ±۾
			wsprintf(chInfluence, CAtumSJ::GetInfluenceTypeString(pMsg->byInfluenceType4));			

			//  ƿ  
			if(pMsg->byStateType == HAPPYEV_STATE_TYPE_START)
			{
//			sprintf(szNotice, STRMSG_C_EVENT_0002	//"Ǿƿ ̺Ʈ %dú %dñ ˴ϴ."
//				, pMsg->StartATime.Hour
//				, pMsg->EndATime.Hour);
				sprintf(szNotice, STRMSG_C_071101_0201	//"Ǿƿ ̺Ʈ %dú %dñ ˴ϴ."
				,chInfluence
				, pMsg->StartATime.Hour
				, pMsg->EndATime.Hour);

			
			}
			else
			{
//			sprintf(szNotice, STRMSG_C_EVENT_0009		//"%\s Ǿƿ ̺Ʈ %dú %dñ  Դϴ."
//				, pMsg->StartATime.Hour
//				, pMsg->EndATime.Hour);
			sprintf(szNotice, STRMSG_C_071101_0202		//"%\s Ǿƿ ̺Ʈ %dú %dñ  Դϴ."
				,chInfluence
				, pMsg->StartATime.Hour
				, pMsg->EndATime.Hour);		
			}
			// 2008-03-14 by bhsohn   Ǿƿ ó
			if(!bLevelUp)
			{
				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);
			}
			g_pGameMain->m_pUnitInfoBar->SetHappyHourInfluence(bLevelUp, TRUE, pMsg);
			
//			//g_pGameMain->m_pUnitInfoBar->m_BHappyHourEvent |= 0x01;
//			if(pMsg->byStateType == HAPPYEV_STATE_TYPE_START)
//			{
//			sprintf(szNotice, STRMSG_C_EVENT_0002	//"Ǿƿ ̺Ʈ %dú %dñ ˴ϴ."
//				, pMsg->StartATime.Hour
//				, pMsg->EndATime.Hour);
//			}
//			else
//			{
//			sprintf(szNotice, STRMSG_C_EVENT_0009		//"Ǿƿ ̺Ʈ %dú %dñ  Դϴ."
//				, pMsg->StartATime.Hour
//				, pMsg->EndATime.Hour);
//			}
//			m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);			
			

//			if(pMsg->fEXPRate2 > 1.0f || g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0003,(pMsg->fEXPRate2-1.0f)*100);//" ġ %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRate = (pMsg->fEXPRate2-1.f);
//				sprintf(szNotice, STRMSG_C_EVENT_0003,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRate+
//											g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRate)*100);//" ġ %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fDropRareRate2 > 1.0f || g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropRareRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0004,(pMsg->fDropRareRate2-1.0f)*100);//"ɼ  %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropRareRate = (pMsg->fDropRareRate2-1.f) ;
//				sprintf(szNotice, STRMSG_C_EVENT_0004,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropRareRate +
//											g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropRareRate)*100);//"ɼ  %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fEXPRepairRate2 > 0.0f || g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRepairRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0005,(pMsg->fEXPRepairRate2)*100);//"׾  гƼ %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRepairRate = (pMsg->fEXPRepairRate2) ;
//				sprintf(szNotice, STRMSG_C_EVENT_0005,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRepairRate +
//											g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRepairRate)*100);//"׾  гƼ %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fDropItemRate2 > 1.0f || g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropItemRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0006,(pMsg->fDropItemRate2-1.f)*100);//"  %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropItemRate = (pMsg->fDropItemRate2-1.f);
//				sprintf(szNotice, STRMSG_C_EVENT_0006,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropItemRate +
//											g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropItemRate)*100);//"  %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fSPIRate2 > 1.0f || g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fSPIRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0007,(pMsg->fSPIRate2-1.f)*100);//"Ƿ %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fSPIRate = (pMsg->fSPIRate2-1.f);
//				sprintf(szNotice, STRMSG_C_EVENT_0007,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fSPIRate +
//											g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fSPIRate)*100);//"Ƿ %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fWarPointRate2 > 1.0f || g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fWarPointRate > 0.0f)
//			{//  Ʈ.
//				sprintf(szNotice, STRMSG_C_070626_0100,(pMsg->fWarPointRate2-1.f)*100);//" Ʈ %d%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fWarPointRate = (pMsg->fWarPointRate2-1.f);
//				sprintf(szNotice, STRMSG_C_070626_0100,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fWarPointRate +
//											g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fWarPointRate)*100);//"Ƿ %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}			
			//m_pChat->CreateChatChild(STRMSG_C_EVENT_0008 ,COLOR_SYSTEM);//" ð ǽñ ٶϴ. ^^"
			// end 2007-11-01 by bhsohn  ƿ ̺Ʈ ó  
		}
			break;
	case PCBANG_HAPPYEV_STATE_TYPE_END:
		{
			// 2007-11-01 by bhsohn  ƿ ̺Ʈ ó  			
			sprintf(szNotice, STRMSG_C_060830_0100);		//"PC Ǿƿ ̺Ʈ Ǿϴ."			

			// 2008-03-14 by bhsohn   Ǿƿ ó
			if(!bLevelUp)
			{
				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);
			}
			g_pGameMain->m_pUnitInfoBar->SetHappyHourPcBang(bLevelUp, FALSE,pMsg);		
			
			//g_pGameMain->m_pUnitInfoBar->m_BHappyHourEvent &= 0x01;
//			memset(&g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo,0x00,sizeof(EVENT_INFO));
//			sprintf(szNotice, STRMSG_C_060830_0100);		//"PC Ǿƿ ̺Ʈ Ǿϴ."
//			m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);
//
//			//// 2007-11-01 by bhsohn  ƿ ̺Ʈ ó  
//			//if(0x01 | g_pGameMain->m_pUnitInfoBar->m_BHappyHourEvent)
//			if(g_pGameMain->m_pUnitInfoBar->IsHappyHourEvent())
//			{//Ǿƿ ̺Ʈ ȿϸ
//				if(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRate > 0.0f)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0003,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRate)*100);//" ġ %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropRareRate > 0.0f)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0004,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropRareRate)*100);//"ɼ  %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRepairRate)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0005,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRepairRate)*100);//"׾  гƼ %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRepairRate > 0.0f)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0006,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRepairRate)*100);//"  %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fSPIRate)
//				{
//					sprintf(szNotice, STRMSG_C_EVENT_0007,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fSPIRate)*100);//"Ƿ %.0f%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//				if(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fWarPointRate)
//				{//  Ʈ.
//					sprintf(szNotice, STRMSG_C_070626_0100,(g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fWarPointRate)*100);//" Ʈ %d%% "
//					g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//				}
//			}
		}
		break;
	case PCBANG_HAPPYEV_STATE_TYPE_STARTING:
	case PCBANG_HAPPYEV_STATE_TYPE_START:
		{
			// 2007-11-01 by bhsohn  ƿ ̺Ʈ ó  
			if(pMsg->byStateType == PCBANG_HAPPYEV_STATE_TYPE_START)
			{
				sprintf(szNotice, STRMSG_C_060830_0101);	//"PC Ǿƿ ̺Ʈ ˴ϴ."
			}
			else
			{
				sprintf(szNotice, STRMSG_C_060830_0102);	//"PC Ǿƿ ̺Ʈ Դϴ."
			}
			// 2008-03-14 by bhsohn   Ǿƿ ó
			if(!bLevelUp)
			{
				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);			
			}
			g_pGameMain->m_pUnitInfoBar->SetHappyHourPcBang(bLevelUp, TRUE, pMsg);

//			g_pGameMain->m_pUnitInfoBar->m_BHappyHourEvent |= 0x10;
//			if(pMsg->byStateType == HAPPYEV_STATE_TYPE_START)
//			{
//				sprintf(szNotice, STRMSG_C_060830_0101);	//"PC Ǿƿ ̺Ʈ ˴ϴ."
//			}
//			else
//			{
//				sprintf(szNotice, STRMSG_C_060830_0102);	//"PC Ǿƿ ̺Ʈ Դϴ."
//			}
//			m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);
//			if(pMsg->fEXPRate2 > 0.0f || g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0003,pMsg->fEXPRate2*100);//" ġ %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRate = pMsg->fEXPRate2;
//				sprintf(szNotice, STRMSG_C_EVENT_0003,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRate +
//					g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRate)*100);//" ġ %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fDropRareRate2 > 0.0f || g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropRareRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0004,pMsg->fDropRareRate2*100);//"ɼ  %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropRareRate = pMsg->fDropRareRate2;
//				sprintf(szNotice, STRMSG_C_EVENT_0004,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropRareRate +
//					g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropRareRate)*100);//"ɼ  %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fEXPRepairRate2 > 0.0f || g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRepairRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0005,pMsg->fEXPRepairRate2*100);//"׾  гƼ %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRepairRate = pMsg->fEXPRepairRate2;
//				sprintf(szNotice, STRMSG_C_EVENT_0005,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fEXPRepairRate +
//					g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fEXPRepairRate)*100);//"׾  гƼ %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fDropItemRate2 > 0.0f || g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropItemRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0006,pMsg->fDropItemRate2*100);//"  %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropItemRate = pMsg->fDropItemRate2;
//				sprintf(szNotice, STRMSG_C_EVENT_0006,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fDropItemRate+
//					g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fDropItemRate)*100);//"  %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fSPIRate2 > 0.0f || g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fSPIRate > 0.0f)
//			{
//				sprintf(szNotice, STRMSG_C_EVENT_0007,pMsg->fSPIRate2*100);//"Ƿ %.0f%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fSPIRate = pMsg->fSPIRate2;
//				sprintf(szNotice, STRMSG_C_EVENT_0007,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fSPIRate + 
//					g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fSPIRate)*100);//"Ƿ %.0f%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			if(pMsg->fWarPointRate2 > 0.0f || g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fWarPointRate > 0.0f)
//			{//  Ʈ.
//				sprintf(szNotice, STRMSG_C_070626_0100,pMsg->fWarPointRate2*100);//" Ʈ %d%% "
//				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);	
//				
//				g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fWarPointRate = pMsg->fWarPointRate2;
//				sprintf(szNotice, STRMSG_C_070626_0100,(g_pGameMain->m_pUnitInfoBar->m_PCHappyEventInfo.fWarPointRate + 
//					g_pGameMain->m_pUnitInfoBar->m_HappyEventInfo.fWarPointRate)*100);//" Ʈ %d%% "
//				g_pGameMain->m_pUnitInfoBar->m_vecEventHappyHour.push_back(szNotice);
//			}
//			m_pChat->CreateChatChild(STRMSG_C_EVENT_0008 ,COLOR_SYSTEM);//" ð ǽñ ٶϴ. ^^"
		}
		break;
	// 2008-05-21 by bhsohn ,   ƿ ߰
		///////////////////   ƿ /////////////////// 
	case GAME_EVENT_GROUP_MOTHERSHIP_END:
		{			
			sprintf(szNotice, STRMSG_C_080521_0202);		//" ¸  ̺Ʈ Ǿƿ  ˴ϴ."
			if(!bLevelUp)
			{
				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);
			}
			g_pGameMain->m_pUnitInfoBar->SetHappyHourMotherShip(bLevelUp, FALSE,pMsg);					
		}
		break;
	case GAME_EVENT_GROUP_MOTHERSHIP_START:
	case GAME_EVENT_GROUP_MOTHERSHIP_STARTING:
		{			
			if(pMsg->byStateType == GAME_EVENT_GROUP_MOTHERSHIP_START)
			{
				sprintf(szNotice, STRMSG_C_080521_0200);	//" ¸  ̺Ʈ Ǿƿ  ˴ϴ"
			}
			else
			{
				sprintf(szNotice, STRMSG_C_080521_0201);	//" ¸  ̺Ʈ Ǿƿ  Դϴ."
			}			
			if(!bLevelUp)
			{
				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);			
			}
			g_pGameMain->m_pUnitInfoBar->SetHappyHourMotherShip(bLevelUp, TRUE, pMsg);
		}
		break;
		///////////////////   ƿ /////////////////// 
	case GAME_EVENT_GROUP_ITEM_END:
		{
			sprintf(szNotice, STRMSG_C_080521_0205);		//" ð  ̺Ʈ Ǿƿ  ˴ϴ."
			if(!bLevelUp)
			{
				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);
			}
			g_pGameMain->m_pUnitInfoBar->SetHappyHourItem(bLevelUp, FALSE,pMsg);		
		}
		break;
	case GAME_EVENT_GROUP_ITEM_START:
	case GAME_EVENT_GROUP_ITEM_STARTING:
		{
			if(pMsg->byStateType == GAME_EVENT_GROUP_ITEM_START)
			{
				sprintf(szNotice, STRMSG_C_080521_0203);	//" ð  ̺Ʈ Ǿƿ  ˴ϴ."
			}
			else
			{
				sprintf(szNotice, STRMSG_C_080521_0204);	//" ð  ̺Ʈ Ǿƿ  Դϴ."
			}			
			if(!bLevelUp)
			{
				m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);			
			}
			g_pGameMain->m_pUnitInfoBar->SetHappyHourItem(bLevelUp, TRUE, pMsg);
		}
		break;
	// end 2008-05-21 by bhsohn ,   ƿ ߰	
	}	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		ydkim
/// \date		2005-04-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetGameEventInfoOk(MSG_FC_INFO_GET_GAME_EVENT_INFO_OK* pMsg)
{
	m_pChat->CreateChatChild(STRMSG_C_EVENT_0010,COLOR_SYSTEM);//"׳ ̺Ʈ  ׽Ʈ ڵ"
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketMonsterTutorialMonsterDeadNotify(MSG_FC_MONSTER_TUTORIAL_MONSTER_DEAD_NOTIFY* pMsg)
/// \brief		Ʃ丮 ʿ Ͱ ׾ Ŭ̾Ʈ ˷
/// \author		jschoi
/// \date		2005-04-21 ~ 2005-04-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMonsterTutorialMonsterDeadNotify(MSG_FC_MONSTER_TUTORIAL_MONSTER_DEAD_NOTIFY* pMsg)
{
	g_pTutorial->MonsterDeadNotify(pMsg->monsterIdx);
}


// 2009. 09. 18 by ckPark ǴƼ ʵ HP   ȭ
VOID	CAtumApplication::FieldSocketMonsterHPTalk( MSG_FC_MONSTER_HPTALK* pMsg )
{
	if( pMsg->TargetIndex )
	{
		CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->TargetIndex );
		if( pUnit )
		{
			char szStr[ SIZE_MAX_HPTALK_DESCRIPTION + SIZE_MAX_CHARACTER_NAME ];
			char szName[ SIZE_MAX_CHARACTER_NAME ];

			if( pUnit->m_dwPartType == _ENEMY )
				strcpy( szName, ((CEnemyData*)(pUnit))->GetEnemyInfo().CharacterInfo.CharacterName );
			else if( pUnit->m_dwPartType == _SHUTTLE )
				strcpy( szName, ((CShuttleChild*)(pUnit))->GetMyShuttleInfo().CharacterName );
			else
				strcpy( szName, "null\\0" );

			char* p = strrchr( szName, '\\');
			if( p )
				*p = '\0';

			sprintf( szStr, pMsg->HPTalk, szName );

			g_pD3dApp->m_pChat->CreateChatChild( szStr, COLOR_CHAT_REGION, CHAT_TAB_SYSTEM );
		}
	}
	else if( pMsg->MonsterUnitKind )
	{
		//  īε  ´
		MEX_MONSTER_INFO* pMonster = g_pDatabase->CheckMonsterInfo( pMsg->MonsterUnitKind );
		if( pMonster )
		{
			char szStr[ SIZE_MAX_HPTALK_DESCRIPTION + SIZE_MAX_MONSTER_NAME ];
			sprintf( szStr, "%s : %s", pMonster->MonsterName, pMsg->HPTalk );
			
			// ȭ  ó
			switch( pMsg->HPTalkImportance )
			{
			case HPACTION_TALK_IMPORTANCE_ALL:
				g_pD3dApp->m_pChat->CreateChatChild( szStr, COLOR_CHAT_REGION, CHAT_TAB_NORMAL );
				g_pGameMain->m_pUnitNameInfo->MonsterChatCreateInfo( strlen( szStr ), szStr, pMsg->MonsterIndex );
				break;
			case HPACTION_TALK_IMPORTANCE_INFL:
				g_pD3dApp->m_pChat->CreateChatChild( szStr, COLOR_CHAT_REGION, CHAT_TAB_NORMAL );
				g_pGameMain->m_pUnitNameInfo->MonsterChatCreateInfo( strlen( szStr ), szStr, pMsg->MonsterIndex );
				break;
			case HPACTION_TALK_IMPORTANCE_CHANNEL:
				g_pD3dApp->m_pChat->CreateChatChild( szStr, COLOR_CHAT_REGION, CHAT_TAB_NORMAL );
				g_pGameMain->m_pUnitNameInfo->MonsterChatCreateInfo( strlen( szStr ), szStr, pMsg->MonsterIndex );
				break;
			default:
				::DbgOut( "UnDefined MSG_FC_MONSTER_HPTALK::HPTalkImportance\n");
				break;
			}
		}
	}

	if( pMsg->HPCameraTremble )
		m_pCamera->ChangeCamCollType( 1, pMsg->HPCameraTremble / 100 );
}
// end 2009. 09. 18 by ckPark ǴƼ ʵ HP   ȭ
//2011-10-24 by jhahn Ʈ ý 
VOID	CAtumApplication::FieldSocketTriggerMapBuffSkill(MSG_FC_TRIGGER_MAP_BUFF_SKILL* pMsg )
{
		// 2010. 05. 31 by hsLee ǴƼ ʵ 2 ̵ . (Ʈ  뷱   .) -   NULL üũ ߰.
	if ( NULL == g_pShuttleChild )
		return;
	
	if ( NULL != g_pShuttleChild->m_pSkill )
		g_pShuttleChild->m_pSkill->InitPreSkillItemNum();
	// End 2010. 05. 31 by hsLee ǴƼ ʵ 2 ̵ . (Ʈ  뷱   .)

	//   ų
	if( g_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex )
	{
		BOOL bDeleteUsingSkill			= FALSE;
		BOOL bDeleteEnemyUsingSkill		= FALSE;

		ITEM* pItem = g_pDatabase->GetServerItemInfo( pMsg->SkillItemNum );
		// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
		if( !pItem )
			return;
		// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

		if(SKILLTYPE_TIMELIMIT == pItem->SkillType)
		{
			bDeleteUsingSkill			= TRUE;
			bDeleteEnemyUsingSkill		= TRUE;
		}
		else if(pMsg->ClientIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			bDeleteUsingSkill			= TRUE;
		}
		else
		{
			bDeleteEnemyUsingSkill		= TRUE;
		}

		if(bDeleteUsingSkill)
		{
			CSkillInfo *pSkillInfo = g_pShuttleChild->m_pSkill->FindUsingSkillInfoByBaseNum( pMsg->SkillItemNum );
			if(pSkillInfo)
			{
				g_pGameMain->m_pInfSkill->DeleteSkillInfo( pSkillInfo );
				pSkillInfo->ReleaseParamFactor();
				if(bDeleteEnemyUsingSkill)
				{
					g_pShuttleChild->m_pSkill->EraseLowLVUsingSkill( NULL, pMsg->SkillItemNum );
				}
			}
		}

		if(bDeleteEnemyUsingSkill)
		{
			CSkillInfo *pSkillInfo = g_pShuttleChild->m_pSkill->FindEnemyUsingSkillForMeInfoByBaseNum( pMsg->SkillItemNum );
			if(pSkillInfo)
			{
				g_pGameMain->m_pInfSkill->DeleteSkillInfo(pSkillInfo);
				pSkillInfo->ReleaseParamFactor();
				g_pShuttleChild->m_pSkill->EraseUsingSkill(pSkillInfo,TRUE);
			}
		}

		CSkillInfo* pSkillInfo = g_pShuttleChild->m_pSkill->FindEnemyUsingSkillForMeInfo( pMsg->SkillItemNum );
		if(NULL == pSkillInfo)
		{
			// ų  
			ITEM_SKILL itemSkill;
			memset( &itemSkill, 0x00, sizeof( ITEM_SKILL ) );

			// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
			itemSkill.ItemInfo		= pItem;
			itemSkill.ItemNum		= pItem->ItemNum;
			itemSkill.Kind			= pItem->Kind;
			// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

			pSkillInfo	= g_pShuttleChild->m_pSkill->FindItemEnemySkillInfo( pMsg->SkillItemNum );
			if( NULL == pSkillInfo )
			{
				pSkillInfo = new CSkillInfo( &itemSkill );
				g_pShuttleChild->m_pSkill->m_mapEnemySkillInfo[ pMsg->SkillItemNum ] = pSkillInfo;
			}	
			

			// 2011-10-10 by jhahn EP4 Ʈ ý	ȭ Ʈ ߰

 			
 			{
				if(pMsg->SkillItemNum == 7514630 )
				{
// 					CAppEffectData * pData = new CAppEffectData(g_pCamera,RC_EFF_SANDSTROM_TRIGER,/*m_pShuttleChild->m_vPos*/100);
// 					if(pData)
// 					{
// 						pData = (CAppEffectData *)m_pEffectList->AddChild(pData);							
// 						pData->SetRepeat( TRUE, pItem->Time / 1000.0f, 99 );
// 						
// 					}			
				}
				else if(pMsg->SkillItemNum == 7514620)
				{
					m_pFxSystem->SetingSandStromSurface(TRUE);	
					
// 					CAppEffectData * pData = new CAppEffectData(g_pD3dApp->m_pShuttleChild,RC_EFF_MAGMA_TRIGER,m_pShuttleChild->m_vPos);
// 					if(pData)
// 					{
// 						pData = (CAppEffectData *)m_pEffectList->AddChild(pData);						
// 						pData->SetRepeat( TRUE, pItem->Time / 1000.0f, 99 );// 	
// 						m_pFxSystem->SetingSandStromSurface(TRUE);	
// 					}			
				}
				pSkillInfo->UseSkillFromServer(NULL, TRUE);	

			}

			g_pShuttleChild->m_pSkill->m_vecEnemyUsingSkillForMe.push_back( pSkillInfo );
			
		//end 2011-10-10 by jhahn EP4 Ʈ ý	ȭ Ʈ ߰
		}
		else 
		{
			//  ų 
			pSkillInfo->Init();
			pSkillInfo->SetClientIndex( NULL, pMsg->ClientIndex );
			// 2010. 06. 18 by jskim   ų Ʈ 
			//pSkillInfo->UseSkillFromServer();
		
			pSkillInfo->UseSkillFromServer(NULL, FALSE);
			//end 2010. 06. 18 by jskim   ų Ʈ 
		}

		if(	g_pShuttleChild->m_pSkillEffect )
		{
			if( g_pShuttleChild->m_pSkillEffect->FindSkillEffect( pMsg->SkillItemNum ) )
			{
				g_pShuttleChild->m_pSkillEffect->ChangeBodyCondition( pMsg->SkillItemNum, BODYCON_USE_SKILL_MASK );
			}
			else
			{
				// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
				//ITEM* pItem = g_pDatabase->GetServerItemInfo( pMsg->SkillItemNum );
				// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
				CAppEffectData* pEff = new CAppEffectData( g_pShuttleChild,
					SKILL_BASE_NUM(pItem->SourceIndex),
					D3DXVECTOR3(0,0,0) );
				if(pEff->m_bUsing == TRUE )
				{
					// 2011-10-10 by jhahn EP4 Ʈ ý	ȭ Ʈ ߰		
					pEff = (CAppEffectData*)g_pD3dApp->m_pEffectList->AddChild(pEff);
					if (pMsg->SkillItemNum == 7514630 )
						m_pFxSystem->SetingSandStromSurface(TRUE);
					if (pMsg->SkillItemNum == 7514620 || pMsg->SkillItemNum == 7514630)
						pEff->SetRepeat(1,/*pMsg->AddTime*/10,1);
					//end 2011-10-10 by jhahn EP4 Ʈ ý	ȭ Ʈ ߰						
				}						
				else
					delete pEff;
			}
		}
	}
	else
	{
		CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->ClientIndex );
		if(pUnit)
		{
			ITEM* pItem = g_pDatabase->GetServerItemInfo( pMsg->SkillItemNum );

			// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
			if( !pItem )
				return;
			// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

			// ()  ߿  ų Ʈ  ʴ´
			if( pItem->IsExistDesParam( DES_SKILL_INVINCIBLE )
				|| pItem->IsExistDesParam( DES_SKILL_BARRIER ) )
				return;

			// 2010. 03. 18 by ckPark ǴƼ ʵ 2( ų ߰)
			if( pItem->SkillType == SKILLTYPE_TIMELIMIT )
			{
				((CMonsterData*)(pUnit))->InsertMonsterBuffSkill( pMsg->SkillItemNum, pItem );
			}
			// end 2010. 03. 18 by ckPark ǴƼ ʵ 2( ų ߰)

			if(pUnit->m_pSkillEffect)
			{
				if( pUnit->m_pSkillEffect->FindSkillEffect( pMsg->SkillItemNum ) )
				{ 
					pUnit->m_pSkillEffect->ChangeBodyCondition( pMsg->SkillItemNum, BODYCON_USE_SKILL_MASK );
				}
			
				else
				{
					CAppEffectData* pEff = new CAppEffectData( pUnit, SKILL_BASE_NUM(pItem->SourceIndex), D3DXVECTOR3(0,0,0) );
					if(pEff->m_bUsing)
					{
						pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					}
					else
					{
						delete pEff;
					}
				}


			}
		}
	}

}
//end 2011-10-24 by jhahn Ʈ ý 
// 2009. 09. 21 by ckPark ǴƼ ʵ  ų 
VOID	CAtumApplication::FieldSocketMonsterSkill( MSG_FC_MONSTER_SKILL* pMsg )
{

	// 2010. 05. 31 by hsLee ǴƼ ʵ 2 ̵ . (Ʈ  뷱   .) -   NULL üũ ߰.
	if ( NULL == g_pShuttleChild )
		return;
	
	if ( NULL != g_pShuttleChild->m_pSkill )
		g_pShuttleChild->m_pSkill->InitPreSkillItemNum();
	// End 2010. 05. 31 by hsLee ǴƼ ʵ 2 ̵ . (Ʈ  뷱   .)

	//   ų
	if( g_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ClientIndex )
	{
		BOOL bDeleteUsingSkill			= FALSE;
		BOOL bDeleteEnemyUsingSkill		= FALSE;

		ITEM* pItem = g_pDatabase->GetServerItemInfo( pMsg->SkillItemNum );
		// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
		if( !pItem )
			return;
		// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

		if(SKILLTYPE_TIMELIMIT == pItem->SkillType)
		{
			bDeleteUsingSkill			= TRUE;
			bDeleteEnemyUsingSkill		= TRUE;
		}
		else if(pMsg->ClientIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
		{
			bDeleteUsingSkill			= TRUE;
		}
		else
		{
			bDeleteEnemyUsingSkill		= TRUE;
		}

		if(bDeleteUsingSkill)
		{
			CSkillInfo *pSkillInfo = g_pShuttleChild->m_pSkill->FindUsingSkillInfoByBaseNum( pMsg->SkillItemNum );
			if(pSkillInfo)
			{
				g_pGameMain->m_pInfSkill->DeleteSkillInfo( pSkillInfo );
				pSkillInfo->ReleaseParamFactor();
				if(bDeleteEnemyUsingSkill)
				{
					g_pShuttleChild->m_pSkill->EraseLowLVUsingSkill( pMsg->MonsterIndex, pMsg->SkillItemNum );
				}
			}
		}

		if(bDeleteEnemyUsingSkill)
		{
			CSkillInfo *pSkillInfo = g_pShuttleChild->m_pSkill->FindEnemyUsingSkillForMeInfoByBaseNum( pMsg->SkillItemNum );
			if(pSkillInfo)
			{
				g_pGameMain->m_pInfSkill->DeleteSkillInfo(pSkillInfo);
				pSkillInfo->ReleaseParamFactor();
				g_pShuttleChild->m_pSkill->EraseUsingSkill(pSkillInfo,TRUE);
			}
		}

		CSkillInfo* pSkillInfo = g_pShuttleChild->m_pSkill->FindEnemyUsingSkillForMeInfo( pMsg->SkillItemNum );
		if(NULL == pSkillInfo)
		{
			// ų  
			ITEM_SKILL itemSkill;
			memset( &itemSkill, 0x00, sizeof( ITEM_SKILL ) );

			// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
// 			itemSkill.ItemInfo		= g_pDatabase->GetServerItemInfo( pMsg->SkillItemNum );
// 			itemSkill.ItemNum		= itemSkill.ItemInfo->ItemNum;
// 			itemSkill.Kind			= itemSkill.ItemInfo->Kind;
			itemSkill.ItemInfo		= pItem;
			itemSkill.ItemNum		= pItem->ItemNum;
			itemSkill.Kind			= pItem->Kind;
			// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

			pSkillInfo	= g_pShuttleChild->m_pSkill->FindItemEnemySkillInfo( pMsg->SkillItemNum );
			if( NULL == pSkillInfo )
			{
				pSkillInfo = new CSkillInfo( &itemSkill );
				g_pShuttleChild->m_pSkill->m_mapEnemySkillInfo[ pMsg->SkillItemNum ] = pSkillInfo;
			}

			pSkillInfo->SetClientIndex( pMsg->MonsterIndex, pMsg->ClientIndex );
			// 2010. 06. 18 by jskim   ų Ʈ 
			//pSkillInfo->UseSkillFromServer();
			CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);
			pSkillInfo->UseSkillFromServer(((CMonsterData*)itMonster->second)->m_pMonsterInfo->MonsterName, FALSE);

			//end 2010. 06. 18 by jskim   ų Ʈ 
			g_pShuttleChild->m_pSkill->m_vecEnemyUsingSkillForMe.push_back( pSkillInfo );
		}
		else
		{
			//  ų 
			pSkillInfo->Init();
			pSkillInfo->SetClientIndex( pMsg->MonsterIndex, pMsg->ClientIndex );
			// 2010. 06. 18 by jskim   ų Ʈ 
			//pSkillInfo->UseSkillFromServer();
			CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->MonsterIndex);
			pSkillInfo->UseSkillFromServer(((CMonsterData*)itMonster->second)->m_pMonsterInfo->MonsterName, FALSE);
			//end 2010. 06. 18 by jskim   ų Ʈ 
		}

		if(	g_pShuttleChild->m_pSkillEffect )
		{
			if( g_pShuttleChild->m_pSkillEffect->FindSkillEffect( pMsg->SkillItemNum ) )
			{
				g_pShuttleChild->m_pSkillEffect->ChangeBodyCondition( pMsg->SkillItemNum, BODYCON_USE_SKILL_MASK );
			}
			else
			{
				// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
				//ITEM* pItem = g_pDatabase->GetServerItemInfo( pMsg->SkillItemNum );
				// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
				CAppEffectData* pEff = new CAppEffectData( g_pShuttleChild,
					SKILL_BASE_NUM(pItem->SourceIndex),
					D3DXVECTOR3(0,0,0) );
				if(pEff->m_bUsing == TRUE )
					pEff = (CAppEffectData*)g_pD3dApp->m_pEffectList->AddChild(pEff);
				else
					delete pEff;
			}
		}
	}
	else
	{
		CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->ClientIndex );
		if(pUnit)
		{
			ITEM* pItem = g_pDatabase->GetServerItemInfo( pMsg->SkillItemNum );

			// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
			if( !pItem )
				return;
			// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

			// ()  ߿  ų Ʈ  ʴ´
			if( pItem->IsExistDesParam( DES_SKILL_INVINCIBLE )
				|| pItem->IsExistDesParam( DES_SKILL_BARRIER ) )
				return;

			// 2010. 03. 18 by ckPark ǴƼ ʵ 2( ų ߰)
			if( pItem->SkillType == SKILLTYPE_TIMELIMIT 
				&& pMsg->ClientIndex == pMsg->MonsterIndex )
			{
				((CMonsterData*)(pUnit))->InsertMonsterBuffSkill( pMsg->SkillItemNum, pItem );
			}
			// end 2010. 03. 18 by ckPark ǴƼ ʵ 2( ų ߰)

			if(pUnit->m_pSkillEffect)
			{
				if( pUnit->m_pSkillEffect->FindSkillEffect( pMsg->SkillItemNum ) )
				{ 
					pUnit->m_pSkillEffect->ChangeBodyCondition( pMsg->SkillItemNum, BODYCON_USE_SKILL_MASK );
				}
				else
				{
					CAppEffectData* pEff = new CAppEffectData( pUnit, SKILL_BASE_NUM(pItem->SourceIndex), D3DXVECTOR3(0,0,0) );
					if(pEff->m_bUsing)
					{
						pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					}
					else
					{
						delete pEff;
					}
				}


			}
		}
	}
}
// 2011-02-08 by jhahn EP4 Ʈ ý Ʈ 			
void	CAtumApplication::FieldObjectChangeOK(MSG_FC_OBJECT_CHANGE* pMsg)
{
	if( pMsg->ObjectIdx )
		ChangeMapObject( pMsg->ObjectIdx, pMsg->ChangeObjectIdx );

	
}
//end 2011-02-08 by jhahn EP4 Ʈ ý Ʈ 			

// 2011-02-08 by jhahn EP4 Ʈ  ý
VOID	CAtumApplication::FieldSocketShopClose(MSG_FC_SHOP_CLOSE* pMsg)
{
	MSG_FC_EVENT_LEAVE_BUILDING sMsg;
	sMsg.BuildingIndex = pMsg->BuildingIndex;
	g_pFieldWinSocket->SendMsg( T_FC_EVENT_LEAVE_BUILDING, (char*)&sMsg, sizeof(sMsg) );

}
//end 2011-02-08 by jhahn EP4 Ʈ  ý  
//2011-02-08 by jhahn EP4 Ʈ  ý
VOID	CAtumApplication::FieldSocketSetLimitTime( MSG_FC_SET_LIMITTIME* pMsg)
{

	m_pInterface->m_pInfinity->SetHellMap();
	ATUM_DATE_TIME curServerTime = GetServerDateTime();
	if( m_pInterface && m_pInterface->m_pInfinity )
	{
		m_pInterface->m_pInfinity->SetInfinityLimitTime(&curServerTime,pMsg->LimitTime);
		//m_pInterface->m_pInfinity->SetInfinityLimitTimeReset( pMsg->LimitTime );
	}

} 
//end 2011-02-08 by jhahn EP4 Ʈ  ý
VOID	CAtumApplication::FieldSocketMonsterMonsterBarrierUsing( MSG_FC_BATTLE_MONSTER_BARRIER_USING* pMsg )
{

}

VOID	CAtumApplication::FieldSocketMonsterMonsterBarrierUse( MSG_FC_BATTLE_MONSTER_BARRIER_USE* pMsg )
{
	CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->MonsterIndex );
	if(pUnit)
	{
		ITEM* pItem = g_pDatabase->GetServerItemInfo( pMsg->SkillItemNum );
		if(pUnit->m_pSkillEffect)
		{
			if( pUnit->m_pSkillEffect->FindSkillEffect( pMsg->SkillItemNum ) )
				pUnit->m_pSkillEffect->ChangeBodyCondition( pMsg->SkillItemNum, BODYCON_USE_SKILL_MASK );
			else
			{
				CAppEffectData* pEff = new CAppEffectData( pUnit, SKILL_BASE_NUM(pItem->SourceIndex), D3DXVECTOR3(0,0,0) );
				if( !pEff->m_bUsing )
					delete pEff;
				else
				{
					pEff = (CAppEffectData *)g_pD3dApp->m_pEffectList->AddChild(pEff);
					pEff->SetRepeat( TRUE, pItem->Time / 1000.0f, 99 );
				}
			}
		}
	}
}

VOID	CAtumApplication::FieldSocketCharacterDebuffDotInfo( MSG_FC_CHARACTER_DEBUFF_DOT_INFO_OK* pMsg )
{
	if( g_pShuttleChild )
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoDebuffDotInfo( pMsg );
}

VOID	CAtumApplication::FieldSocketCharacterDebuffDotApply( MSG_FC_CHARACTER_DEBUFF_DOT_APPLYING* pMsg )
{
	if( g_pShuttleChild )
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoDebuffDotApply( pMsg );
}

VOID	CAtumApplication::FieldSocketCharacterDebuffDotRelease( MSG_FC_CHARACTER_DEBUFF_DOT_RELEASE* pMsg )
{
	if( g_pShuttleChild )
		g_pShuttleChild->m_pClientParty->FPartyUpdateMemberInfoDebuffDotRelease( pMsg );
}
// end 2009. 09. 21 by ckPark ǴƼ ʵ  ų 


// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
VOID	CAtumApplication::FieldSocketInfinityModeListOK( MSG_FC_INFINITY_MODE_LIST_OK* pMsg )
{
	//    ʱȭ
	m_pInfinityManager->ClearModeInfo();

	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
// 	// ǴƼ   ȭ ȯ
// 	CINFCityInfinityField* pINFInfinityField = NULL;
// 	CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY );
// 	if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
// 		pINFInfinityField = ((CINFCityInfinityField*)((*it).second));
// 
// 	if( pMsg )
// 	{
// 		char* pTemp = (char*)(pMsg) + sizeof( MSG_FC_INFINITY_MODE_LIST_OK );
// 
// 		//  ŭ  ߰
// 		for( int i=0; i<pMsg->InfinityModeListCount; ++i )
// 		{
// 			INFINITY_MODE_INFO* p = (INFINITY_MODE_INFO*)(pTemp + i * sizeof( INFINITY_MODE_INFO ));
// 			m_pInfinityManager->AddModeInfo( p );
// 
// 			pINFInfinityField->AddInfinityMapImg( p->InfinityMapIdx );
// 		}
// 	}
// 
// 	// ǴƼ   ȭ ȯ
// 	if( pINFInfinityField )
// 		pINFInfinityField->ShowWndEx( CINFCityInfinityField::INFINITY_ZONESEL, TRUE );

	// ǴƼ   ȭ ȯ
	if( m_pInterface )
	{
		if( m_pInterface->m_pCityBase )
		{
			if( m_pInterface->m_pCityBase->GetRefCurrentBuildingNPCState() == BUILDINGNPC_RENDER_INFINITYFIELD )
				m_pInterface->m_pCityBase->OnCityNPCButtonDown( CITY_NPC_BUTTON_CLOSE );
		}

		CINFCityInfinityFieldPopUp*	pInfinityPopUp	= m_pInterface->m_pInfinityPopup;

		if( pInfinityPopUp )
		{
			if( pMsg )
			{
				char* pTemp = (char*)(pMsg) + sizeof( MSG_FC_INFINITY_MODE_LIST_OK );

				//  ŭ  ߰
				for( int i=0; i<pMsg->InfinityModeListCount; ++i )
				{
					INFINITY_MODE_INFO* p = (INFINITY_MODE_INFO*)(pTemp + i * sizeof( INFINITY_MODE_INFO ));
					m_pInfinityManager->AddModeInfo( p );

					pInfinityPopUp->AddInfinityMapImg( p->InfinityMapIdx );
				}
			}

			// ǴƼ   ȭ ȯ
			if( pInfinityPopUp )
				pInfinityPopUp->ShowWndEx( CINFCityInfinityFieldPopUp::INFINITY_ZONESEL, TRUE );
		}
	}
	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
}

VOID	CAtumApplication::FieldSocketInfinityReadyListOK( MSG_FC_INFINITY_READY_LIST_OK* pMsg )
{
	//  ǴƼ   ʱȭ Ѵ
	m_pInfinityManager->ClearReadyInfo();

	if( pMsg )
	{
		char* pTemp = (char*)(pMsg) + sizeof( MSG_FC_INFINITY_READY_LIST_OK );

		//  ŭ  ߰
		for( int i=0; i<pMsg->InfinityPlayingListCount; ++i )
		{
			INFINITY_READY_LIST* p = (INFINITY_READY_LIST*)(pTemp + i * sizeof( INFINITY_READY_LIST ));
			m_pInfinityManager->AddReadyInfo( p );
		}
	}

	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

// 	//  ȭ ȯ
// 	CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY );
// 	if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
// 		((CINFCityInfinityField*)((*it).second))->ShowWndEx( CINFCityInfinityField::INFINITY_ROOMSEL, TRUE );

	if( m_pInterface && m_pInterface->m_pInfinityPopup )
		m_pInterface->m_pInfinityPopup->ShowWndEx( CINFCityInfinityFieldPopUp::INFINITY_ROOMSEL, TRUE );

	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
}

VOID	CAtumApplication::FieldSocketInfinityCreateOK( MSG_FC_INFINITY_CREATE_OK* pMsg )
{
	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

// 	//   Ϸ  , ȭ ȯ
// 	CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY );
// 	if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
// 		((CINFCityInfinityField*)((*it).second))->ShowWndEx( CINFCityInfinityField::INFINITY_INROOM, TRUE );

	if( m_pInterface && m_pInterface->m_pInfinityPopup )
		m_pInterface->m_pInfinityPopup->ShowWndEx( CINFCityInfinityFieldPopUp::INFINITY_INROOM, TRUE );

	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

	//   UID 
	m_pInfinityManager->SetMyRoomInfo( 0, pMsg->InfinityCreateUID, NULL );

	//   ̵  .
	m_pInfinityManager->SetMyRoomInfo_Difficult ( pMsg->IntinityDifficultyLevel );

	//   Ʈ û
	g_pFieldWinSocket->SendMsg( T_FC_INFINITY_MEMBER_INFO_LIST, 0, 0 );
}

VOID	CAtumApplication::FieldSocketInfinityMemberInfoList( MSG_FC_INFINITY_MEMBER_INFO_LIST_OK* pMsg )
{
	//    Ʈ ʱȭ
	m_pInfinityManager->ClearMemberInfo();

	if( pMsg )
	{
		//  ClientIdx
		m_pInfinityManager->SetMyRoomInfo( pMsg->MasterClientIdx, 0, NULL );

		char* pTemp = (char*)(pMsg) + sizeof( MSG_FC_INFINITY_MEMBER_INFO_LIST_OK );

		// ǴƼ ŭ ߰
		for( int i=0; i<pMsg->InfinityMemberListCount; ++i )
		{
			INFINITY_MEMBER_INFO_LIST* p = (INFINITY_MEMBER_INFO_LIST*)(pTemp + i * sizeof( INFINITY_MEMBER_INFO_LIST ));
			m_pInfinityManager->AddMemberInfo( p );
		}
	}
}

VOID	CAtumApplication::FieldSocketInfinityLeaveOK( MSG_FC_INFINITY_LEAVE_OK* pMsg )
{
	// ٸ   ̶ Ʈ 
	if( m_pArenaManager->GetArenaCharacterInfo()->ClientIndex != pMsg->LeaveClientIdx )

	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	//m_pInfinityManager->RemoveMemberInfo( pMsg->LeaveClientIdx );
	{
		INFINITY_MEMBER_INFO_LIST* pMember = m_pInfinityManager->GetMemberInfoByClientIdx( pMsg->LeaveClientIdx );
		if( pMember )
		{
			char szTemp[ SIZE_MAX_CHAT_MESSAGE ];
			sprintf( szTemp, STRMSG_C_100310_0301, pMember->CharacterName );	// "\\yǴƼ ʵ 濡 %s ϴ.\\y"
			g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
		}

		m_pInfinityManager->RemoveMemberInfo( pMsg->LeaveClientIdx );
	}
	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

	else
	{
		// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

// 		//   ̶
// 		CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY );
// 		if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
// 		{
// 			((CINFCityInfinityField*)((*it).second))->DisableChatControl();
// 			((CINFCityInfinityField*)((*it).second))->ClearChatList();
// 		}

		//   ̶
		if( m_pInterface && m_pInterface->m_pInfinityPopup )
		{
			m_pInterface->m_pInfinityPopup->DisableChatControl();
			m_pInterface->m_pInfinityPopup->ClearChatList();

			if( !m_pInterface->m_pInfinityPopup->IsShowWnd() )
				return;
		}
		// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

		//  Ʈ û
		if( g_pD3dApp->GetInfinityManager()->GetInfinityModeIdx() != -1 )
		{
			INFINITY_MODE_INFO* pMapInfo	= g_pD3dApp->GetInfinityManager()->GetInfinityModeByIndex( g_pD3dApp->GetInfinityManager()->GetInfinityModeIdx() );

			MSG_FC_INFINITY_READY_LIST msg;
			msg.InfinityMapIdx	= pMapInfo->InfinityMapIdx;
			msg.InfinityMode	= pMapInfo->InfinityMode;

			g_pD3dApp->GetInfinityManager()->ClearMemberInfo();
			g_pD3dApp->GetInfinityManager()->ClearMyRoomInfo();
			g_pD3dApp->GetInfinityManager()->ClearReadyInfo();
			g_pD3dApp->GetInfinityManager()->ClearJoinRequest();
			g_pD3dApp->GetInfinityManager()->ClearRejectClientIdx();

			g_pFieldWinSocket->SendMsg( T_FC_INFINITY_READY_LIST, (char*)(&msg), sizeof(MSG_FC_INFINITY_READY_LIST) );
		}
	}
}

VOID	CAtumApplication::FieldSocketInfinityBanOK( MSG_FC_INFINITY_BAN_OK* pMsg )
{
	// ٸ   Ѱ̶  Ʈ 
	if( m_pArenaManager->GetArenaCharacterInfo()->ClientIndex != pMsg->BanClientIdx )
	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	//m_pInfinityManager->RemoveMemberInfo( pMsg->BanClientIdx );
	{
		INFINITY_MEMBER_INFO_LIST* pMember = m_pInfinityManager->GetMemberInfoByClientIdx( pMsg->BanClientIdx );
		if( pMember )
		{
			char szTemp[ SIZE_MAX_CHAT_MESSAGE ];
			sprintf( szTemp, STRMSG_C_100310_0301, pMember->CharacterName );	// "\\yǴƼ ʵ 濡 %s ϴ.\\y"
			g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
		}

		m_pInfinityManager->RemoveMemberInfo( pMsg->BanClientIdx );
	}
	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	else
	{
		// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

// 		//   ̶
// 		CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY );
// 		if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
// 		{
// 			((CINFCityInfinityField*)((*it).second))->DisableChatControl();
// 			((CINFCityInfinityField*)((*it).second))->ClearChatList();
// 		}

		//   ̶
		if( m_pInterface && m_pInterface->m_pInfinityPopup )
		{
			m_pInterface->m_pInfinityPopup->DisableChatControl();
			m_pInterface->m_pInfinityPopup->ClearChatList();

			if( !m_pInterface->m_pInfinityPopup->IsShowWnd() )
				return;
		}

		char szTemp[ SIZE_MAX_CHAT_MESSAGE ];
		strcpy( szTemp, STRMSG_C_100310_0305 );	// "\\yǴƼ ʵ 濡 ߹ Ͽϴ.\\y"
		g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
		// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)

		//   Ʈ û
		if( g_pD3dApp->GetInfinityManager()->GetInfinityModeIdx() != -1 )
		{
			INFINITY_MODE_INFO* pMapInfo	= g_pD3dApp->GetInfinityManager()->GetInfinityModeByIndex( g_pD3dApp->GetInfinityManager()->GetInfinityModeIdx() );

			MSG_FC_INFINITY_READY_LIST msg;
			msg.InfinityMapIdx	= pMapInfo->InfinityMapIdx;
			msg.InfinityMode	= pMapInfo->InfinityMode;

			g_pD3dApp->GetInfinityManager()->ClearMemberInfo();
			g_pD3dApp->GetInfinityManager()->ClearMyRoomInfo();
			g_pD3dApp->GetInfinityManager()->ClearReadyInfo();

			g_pFieldWinSocket->SendMsg( T_FC_INFINITY_READY_LIST, (char*)(&msg), sizeof(MSG_FC_INFINITY_READY_LIST) );
		}
	}
}

VOID	CAtumApplication::FieldSocketInfinityJoinRequest( MSG_FC_INFINITY_JOIN_REQUEST_MASTERUSER* pMsg )
{
	//   û ߰
	m_pInfinityManager->AddJoinRequest( pMsg );
}

VOID	CAtumApplication::FieldSocketInfinityJoinOK( MSG_FC_INFINITY_JOIN_OK* pMsg )
{
	//   û  ( ƴ ٸ Ŭ̾Ʈϰ)
	if( m_pArenaManager->GetArenaCharacterInfo()->ClientIndex != pMsg->JoinClientIdx )
	{
		// 㰡  츸
		if( pMsg->bAccept )
		{
			INFINITY_MEMBER_INFO_LIST memberinfo;
			strcpy(memberinfo.CharacterName, pMsg->JoinCharacterName);
			memberinfo.ClientIdx	= pMsg->JoinClientIdx;
			memberinfo.Gear			= pMsg->Gear;
			memberinfo.Lv			= pMsg->Lv;
			memberinfo.State		= INFINITY_STATE_NONE;

			//  ߰
			m_pInfinityManager->AddMemberInfo( &memberinfo );

			// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
			char szTemp[ SIZE_MAX_CHAT_MESSAGE ];

			char* p = strrchr( pMsg->JoinCharacterName, '\\' );
			if( p )
				*p = '\0';

			sprintf( szTemp, STRMSG_C_100310_0303, pMsg->JoinCharacterName );	// "\\yǴƼ ʵ 濡 %s  Ͽϴ.\\y"
			g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
			// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
		}
	}
	else
	{

		// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
// 		CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY );
// 		if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
// 		{
// 			// 㰡  츸
// 			if( pMsg->bAccept )
// 			{
// 				((CINFCityInfinityField*)((*it).second))->ShowWndEx( CINFCityInfinityField::INFINITY_INROOM, TRUE );
// 				
// 				g_pFieldWinSocket->SendMsg( T_FC_INFINITY_MEMBER_INFO_LIST, 0, 0 );
// 			}
// 
// 			((CINFCityInfinityField*)((*it).second))->SetRoomJoinWait( FALSE );
// 		}

		if( m_pInterface && m_pInterface->m_pInfinityPopup )
		{
			// 㰡  츸
			if( pMsg->bAccept )
			{
				m_pInterface->m_pInfinityPopup->ShowWndEx( CINFCityInfinityFieldPopUp::INFINITY_INROOM, TRUE );

				g_pFieldWinSocket->SendMsg( T_FC_INFINITY_MEMBER_INFO_LIST, 0, 0 );
			}

			m_pInterface->m_pInfinityPopup->SetRoomJoinWait( FALSE );
		}
		// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	}
}

VOID	CAtumApplication::FieldSocketInfinityEnter( MSG_FC_INFINITY_ENTER* pMsg )
{
	// ä ε
	m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.ChannelIndex = pMsg->InfinityChannelIdx;
	// 
	m_pShuttleChild->m_vPos	= pMsg->CharacterPosition;

	//  ε 
	m_pInterface->InvalidateMapLoadObjects();
	m_pInterface->DeleteMapLoadObjects();
	ChangeGameState( _GAME );

	// Ƽ  
	int nPenaltyTime = m_pInfinityManager->GetMyRoomInfo()->ModeInfo.TimePenaltyValue;
	char szTemp[ 256 ];

	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo( m_pInfinityManager->GetMyRoomInfo()->ModeInfo.InfinityMapIdx );
	if( pMapInfo )
	{
		
		// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
// 		if( nPenaltyTime > 0 )
// 		{
// 			sprintf( szTemp, STRMSG_C_091103_0334, pMapInfo->MapName, nPenaltyTime );	// "\\y[%s]()   ǴƼ ʵ  ð [%d]  ˴ϴ.\\y"
// 			g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
// 		}
// 		else if( nPenaltyTime < 0 )
// 		{
// 			sprintf( szTemp, STRMSG_C_091103_0333, pMapInfo->MapName, abs(nPenaltyTime) );	// "\\y[%s]()   ǴƼ ʵ  ð [%d]  ˴ϴ.\\y"
// 			g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
// 		}

		switch( m_pInfinityManager->GetMyRoomInfo()->ModeInfo.InfinityMode )
		{
		case INFINITY_MODE_BOSSRUSH:
			{
				if( nPenaltyTime > 0 )
				{
					sprintf( szTemp, STRMSG_C_091103_0334, pMapInfo->MapName, nPenaltyTime );	// "\\y[%s]()   ǴƼ ʵ  ð [%d]  ˴ϴ.\\y"
					g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
				}
				else if( nPenaltyTime < 0 )
				{
					sprintf( szTemp, STRMSG_C_091103_0333, pMapInfo->MapName, abs(nPenaltyTime) );	// "\\y[%s]()   ǴƼ ʵ  ð [%d]  ˴ϴ.\\y"
					g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
				}
			}
			break;

		case INFINITY_MODE_DEFENCE:
			{
				sprintf( szTemp, STRMSG_C_100310_0308, pMapInfo->MapName, nPenaltyTime );	// "\\y[%s]()    HP  HP [%d]%%ŭ  մϴ.\\y"
				g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
			}
			break;
		}

		// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	}

	// ǴƼ ǥ   Ƿ     Ѵ
	m_pShuttleChild->DeletePattern();
	m_pShuttleChild->PatternWarpOut(TRUE);

	g_ArenaServerDateTime	= pMsg->StartTime;	
	g_ArenaStartTime		= timeGetTime();

	// ǴƼ ð
	// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
// 	if( m_pInterface->m_pInfinity )
// 		m_pInterface->m_pInfinity->SetInfinityLimitTime( &(pMsg->StartTime), pMsg->LimitTime );
	if( m_pInterface && m_pInterface->m_pInfinity )
		m_pInterface->m_pInfinity->SetInfinityLimitTime( &(pMsg->StartTime), pMsg->LimitTime );
	// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

	// ǴƼ  ε  
	m_bInfinityMapload	= FALSE;

	// ǴƼ  㰡
	m_bEnterInfinityAllowed	= TRUE;

	// α׿â 
	g_pGameMain->m_pSystem->EnableLogOffBtn( FALSE );
}

VOID	CAtumApplication::FieldSocketInfinityReadyOK( MSG_FC_INFINITY_READY_OK* pMsg )
{
	// ش  ¸ 
	INFINITY_MEMBER_INFO_LIST* pMember = m_pInfinityManager->GetMemberInfoByClientIdx( pMsg->ReadyClientIdx );
	if( pMember )
		pMember->State = INFINITY_STATE_READY;

	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	if( m_pInfinityManager->IsAllReady()
		&& m_pInfinityManager->GetMemberCount() == m_pInfinityManager->GetMyRoomInfo()->ModeInfo.MaxMemberCount )
	{
		char szTemp[ SIZE_MAX_CHAT_MESSAGE ];
		strcpy( szTemp, STRMSG_C_100310_0304 );	// "\\yǴƼ ʵ   ο غϷ Դϴ.\\y"
		g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
	}
	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
}

VOID	CAtumApplication::FieldSocketInfinityReadyCancelOK( MSG_FC_INFINITY_READY_CANCEL_OK* pMsg )
{
	// ش  ¸  ҷ
	INFINITY_MEMBER_INFO_LIST* pMember = m_pInfinityManager->GetMemberInfoByClientIdx( pMsg->ReadyCancelClientIdx );
	if( pMember )
		pMember->State = INFINITY_STATE_UNPREPARED;
}

VOID	CAtumApplication::FieldSocketInfinityChangeMaster( MSG_FC_INFINITY_CHANGE_MASTER_OK* pMsg )
{
	//  ش 
	INFINITY_MEMBER_INFO_LIST* pMember = m_pInfinityManager->GetMemberInfoByClientIdx( pMsg->ChangeMasterClientIdx );
	if( pMember )
	// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	//m_pInfinityManager->GetMyRoomInfo()->MasterIndex	= pMsg->ChangeMasterClientIdx;
	{
		m_pInfinityManager->GetMyRoomInfo()->MasterIndex	= pMsg->ChangeMasterClientIdx;
		char szTemp[ SIZE_MAX_CHAT_MESSAGE ];
		sprintf( szTemp, STRMSG_C_100310_0302, pMember->CharacterName );	// "\\yǴƼ ʵ   %s  Ǿϴ.\\y"
		g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
	}
	// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
}

VOID	CAtumApplication::FieldSocketInfinityCinema( MSG_FC_INFINITY_CINEMA* pMsg )
{
	// ǴƼ Ʈ 
	if( pMsg->EffectIdx / 100000 == 60 )
	{
		// ش ȣ, ġ Ʈ ߰
		CAppEffectData* pEff = new CAppEffectData( pMsg->EffectIdx,
												   D3DXVECTOR3( pMsg->EffectPosition_X, pMsg->EffectPosition_Y, pMsg->EffectPosition_Z ));

		if( !pEff->m_bUsing )
		{
			SAFE_DELETE( pEff );
		}
		else
		{
			m_pEffectList->AddChild( pEff );
			pEff->SetRepeat( TRUE, pMsg->EffectPlayTime / 1000.0f, pMsg->EffectPlayCount );
		}
	}

	// Ʈ 
	if( pMsg->ObjectIdx )
		ChangeMapObject( pMsg->ObjectIdx, pMsg->ChangeObjectIdx );

	//  ó
	if( strlen( pMsg->CinemaTalk ) > 0 )
		m_pChat->CreateChatChild( pMsg->CinemaTalk, COLOR_CHAT_REGION, CHAT_TAB_NORMAL );

	// ī޶ 
	if( pMsg->CameraTremble )
		m_pCamera->ChangeCamCollType( 1, pMsg->CameraTremble / 100 );

	// 2010. 03. 15 by ckPark ǴƼ ʵ 2( ó)
	// 
	if ( strlen( pMsg->TipFileName ) > 0 && m_pInterface && m_pInterface->m_pInfinity )
	{
		// 2010. 05. 17 by hsLee ǴƼ ʵ 2 UI ߰ . ܰ ǥ  .
		if ( m_pInterface->m_pInfinity->IsEvent_AlarmDefenseStep ( pMsg->TipFileName ) )
			m_pInterface->m_pInfinity->SetAlarm_DefenseStep ( pMsg->TipFileName );
		else
		{
// 2011-07-22 by jhahn 3 ( ó) ð
			m_pInterface->m_pInfinity->SerchTipImg(pMsg->TipFileName);
			m_pInterface->m_pInfinity->SetTipImg( pMsg->TipFileName );
//end 2011-07-22 by jhahn 3 ( ó) ð
		}
		// End 2010. 05. 17 by hsLee ǴƼ ʵ 2 UI ߰ . ܰ ǥ  .
	}

	// ī̹ڽ
	if( strlen( pMsg->SkyFileName ) > 0 && m_pScene )
		m_pScene->ChangeSkyBox( pMsg->SkyFileName );

	// Ʈ ִϸ̼
	if( pMsg->ObjectBodyConditionIdx && m_pScene )
		m_pScene->ChangeEventObjectBodyCondition( pMsg->ObjectBodyConditionIdx, pMsg->BodyCondition );

	if( strlen( pMsg->SoundFileName ) && m_pSound)
		m_pSound->PlayD3DSound( pMsg->SoundFileName, D3DXVECTOR3(0,0,0), TRUE );
	// end 2010. 03. 15 by ckPark ǴƼ ʵ 2( ó)

	// 2011. 03. 08 by jskim 3  - Ʈ ý
	if( pMsg->QuestIndex )
	{
		CHARACTER myShuttleInfo = g_pShuttleChild->GetMyShuttleInfo();
		g_pGameMain->m_pMissionMain->ShowMissionPopWnd(TRUE, pMsg->QuestIndex);	
	}
	// end 2011. 03. 08 by jskim 3  - Ʈ ý
}

VOID	CAtumApplication::FieldSocketInfinitySuccessFIN( void )
{
	// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
	//m_pInterface->m_pInfinity->SetResult( TRUE );
	if( m_pInterface && m_pInterface->m_pInfinity )
		m_pInterface->m_pInfinity->SetResult( TRUE );
	// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
	// 2010. 05. 27 by jskim ó׸  ī޶ 
	g_pShuttleChild->InfinityCinema(TRUE);
	//end 2010. 05. 27 by jskim ó׸  ī޶ 
}

VOID	CAtumApplication::FieldSocketInfinityFailFIN( void )
{
	// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
	//m_pInterface->m_pInfinity->SetResult( FALSE );
	if( m_pInterface && m_pInterface->m_pInfinity )
		m_pInterface->m_pInfinity->SetResult( FALSE );
	// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
	// 2010. 05. 27 by jskim ó׸  ī޶ 
	g_pShuttleChild->InfinityCinema(FALSE);
	//end 2010. 05. 27 by jskim ó׸  ī޶ 
}

VOID	CAtumApplication::FieldSocketInfinityReadyFinishMainSvrStart( void )
{
	g_pGameMain->m_pSystem->EnableLogOffBtn( TRUE );

	// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
	//m_pInterface->m_pInfinity->SetInfinityEnd();
	if( m_pInterface && m_pInterface->m_pInfinity )
		m_pInterface->m_pInfinity->SetInfinityEnd();
	// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

	ArenaFinishWarp( FALSE );
}

VOID	CAtumApplication::FieldSocketInfinityTenderDropItemInfo( MSG_FC_INFINITY_TENDER_DROPITEM_INFO* pMsg )
{
	// 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
	//m_pInfinityManager->AddTenderItem( pMsg );

	if( m_pInterface && m_pInterface->m_pInfinity )
		m_pInterface->m_pInfinity->AddTenderItem( pMsg );
	// end 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
}

VOID	CAtumApplication::FieldSocketInfinityTenderStart( MSG_FC_INFINITY_TENDER_START* pMsg )
{
	// 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
// 	ITEM* pItem = m_pDatabase->GetServerItemInfo( pMsg->TenderItemNum );
// 	if( !pItem )
// 		m_pInterface->m_pInfinity->SetTenderItemBigIcon( NULL );
// 	else
// 	{
// 		m_pInfinityManager->SetCurTenderItem( pMsg->ItemFieldIndex );
// 
// 		m_pInfinityManager->SetCurTenderItemInfo( pItem,
// 												  m_pInfinityManager->GetCurTenderItem()->PrefixCodeNum, 
// 												  m_pInfinityManager->GetCurTenderItem()->SuffixCodeNum );
// 
// 		m_pInterface->m_pInfinity->SetTenderItemBigIcon( g_pGameMain->FindBigIcon( pItem->SourceIndex ) );
// 	}
// 
// 	m_pInterface->m_pInfinity->SetTenderEndTime( timeGetTime() + TICK_TENDER_PROCESSING_TERM );
	// end 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
}

VOID	CAtumApplication::FieldSocketInfinityPutInTenderOK( MSG_FC_INFINITY_TENDER_PUT_IN_TENDER_OK* pMsg )
{
	// ֻ 
	CUnitData* pUnit = m_pScene->FindUnitDataByClientIndex( pMsg->DiceUserIdx );
	if( !pUnit )
		return;

	// ĳ ̸
	char szCharName[ SIZE_MAX_CHARACTER_NAME ] = {0, };

	switch( pUnit->m_dwPartType )
	{
		case _SHUTTLE:
			strcpy( szCharName, ((CShuttleChild*)(pUnit))->GetShuttleInfo()->CharacterName );
		break;

		case _ENEMY:
			strcpy( szCharName, ((CEnemyData*)(pUnit))->m_infoCharacter.CharacterInfo.CharacterName );
		break;

		default:
			return;
	}

	char* p = strrchr( szCharName, '\\');
	if( p )
		*p = '\0';

	char szBuff[256];

	// 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
// 	if( pMsg->DiceCount != 0 )
// 		sprintf( szBuff, STRMSG_C_091103_0315, szCharName, pMsg->DiceCount );
// 	else
// 	{
// 		MSG_FC_INFINITY_TENDER_DROPITEM_INFO* pTenderItem = m_pInfinityManager->GetTenderItem( pMsg->ItemFieldIndex );
// 		if( !pTenderItem )
// 			return;
// 
// 		ITEM* pItem = m_pDatabase->GetServerItemInfo( pTenderItem->TenderDropItemNum );
// 		if( !pItem )
// 			return;
// 
// 		sprintf( szBuff, STRMSG_C_091103_0314, szCharName, pItem->ItemName );
// 	}
	
	if( !(m_pInterface && m_pInterface->m_pInfinity) )
		return;

	TenderItem* pTenderItem = m_pInterface->m_pInfinity->GetTenderItem( pMsg->ItemFieldIndex );
	if( !pTenderItem )
		return;

	if( pMsg->DiceCount != 0 )
		sprintf( szBuff, STRMSG_C_100310_0321, pTenderItem->m_pItem->ItemName, szCharName, pMsg->DiceCount );	// "[%s]  [%s]  [%d] Խϴ."
	else
		sprintf( szBuff, STRMSG_C_091103_0314, szCharName, pTenderItem->m_pItem->ItemName );	// "[%s] [%s]? Ͽϴ."
	// end 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )

	m_pChat->CreateChatChild( szBuff, COLOR_ITEM );
}

VOID	CAtumApplication::FieldSocketInfinityTenderResult( MSG_FC_INFINITY_TENDER_RESULT* pMsg )
{
	CUnitData* pUnit = m_pScene->FindUnitDataByClientIndex( pMsg->DiceUserIdx );
	if( !pUnit )
		return;

	char szCharName[ SIZE_MAX_CHARACTER_NAME ] = {0, };
	
	switch( pUnit->m_dwPartType )
	{
	case _SHUTTLE:
		strcpy( szCharName, ((CShuttleChild*)(pUnit))->GetShuttleInfo()->CharacterName );
		break;

	case _ENEMY:
		strcpy( szCharName, ((CEnemyData*)(pUnit))->m_infoCharacter.CharacterInfo.CharacterName );
		break;

	default:
		return;
	}

	char* p = strrchr( szCharName, '\\');
	if( p )
		*p = '\0';

	ITEM* pItem = m_pDatabase->GetServerItemInfo( pMsg->TenderItemNum );
	if( !pItem )
		return;

	char szBuff[256];

	// "%s  [%d] %s ȹմϴ."
	sprintf( szBuff, STRMSG_C_091103_0316, szCharName, pMsg->DiceCount, pItem->ItemName );

	m_pChat->CreateChatChild( szBuff, COLOR_ITEM );

	// 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
	//m_pInfinityManager->RemoveTenderItem( pMsg->ItemFieldIndex );

	//m_pInfinityManager->SetCurTenderItem( 0 );

	//m_pInterface->m_pInfinity->SetTenderItemBigIcon( NULL );

	if( m_pInterface && m_pInterface->m_pInfinity )
		m_pInterface->m_pInfinity->RemoveTenderItem( pMsg->ItemFieldIndex );
	// end 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
}

VOID	CAtumApplication::FieldSocketInfinityTenderResultTimeOver( MSG_FC_INFINITY_TENDER_RESULT_TIMEOVER* pMsg )
{
	// 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
// 	m_pInfinityManager->RemoveTenderItem( pMsg->ItemFieldIndex );
// 
// 	m_pInfinityManager->SetCurTenderItem( 0 );
// 
// 	m_pInterface->m_pInfinity->SetTenderItemBigIcon( NULL );

	if( m_pInterface && m_pInterface->m_pInfinity )
	{
		TenderItem* pItem = m_pInterface->m_pInfinity->GetTenderItem( pMsg->ItemFieldIndex );
		if( pItem )
		{
			pItem->m_bTendered = TRUE;
			if( m_pInterface && m_pInterface->m_pInfinity )
				m_pInterface->m_pInfinity->ReArrangeTenderItemPosition();
		}
	}
	// end 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )

	g_pGameMain->SetItemInfoNormal( NULL, 0, 0 );
}

VOID	CAtumApplication::FieldSocketInfinityTenderResultAllGiveUp( MSG_FC_INFINITY_TENDER_RESULT_ALLGIVEUP* pMsg )
{
	// 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
// 	m_pInfinityManager->RemoveTenderItem( pMsg->ItemFieldIndex );
// 
// 	m_pInfinityManager->SetCurTenderItem( 0 );
// 
// 	m_pInterface->m_pInfinity->SetTenderItemBigIcon( NULL );
// 
// 	m_pChat->CreateChatChild( STRMSG_C_091103_0317, COLOR_ITEM );

	TenderItem* pTenderItem = m_pInterface->m_pInfinity->GetTenderItem( pMsg->ItemFieldIndex );
	if( pTenderItem )
	{
		char szBuff[ 256 ];
		sprintf( szBuff, STRMSG_C_100310_0322, pTenderItem->m_pItem->ItemName );	// " ο[%s]  Ͽϴ."
		m_pChat->CreateChatChild( szBuff, COLOR_ITEM );

		if( m_pInterface && m_pInterface->m_pInfinity )
			m_pInterface->m_pInfinity->RemoveTenderItem( pMsg->ItemFieldIndex );
	}
	// end 2010. 04. 13 by ckPark ǴƼ ʵ 2(  )
}

VOID	CAtumApplication::FieldSocketInfinityApplyResistanceItem( MSG_FC_INFO_APPLY_RESISTANCE_ITEM* pMsg )
{
	if( pMsg->SkillNum )
	{
		ITEM* pItem = m_pDatabase->GetServerItemInfo( pMsg->SkillNum );
		if( pItem )
			m_pChat->CreateChatChild( STRMSG_C_091103_0341, COLOR_ITEM );
	}
}

VOID	CAtumApplication::FieldSocketInfinityShopItemHeader( void )
{
	CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY_SHOP );
	if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
		((CINFCityInfinityShop*)((*it).second))->ClearItemInfo( );
}

VOID	CAtumApplication::FieldSocketInfinityShopItem( MSG_FC_SHOP_INFINITY_ITEM* pMsg )
{
	// ǴƼ    Ʈ ߰
	CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY_SHOP );
	if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
		((CINFCityInfinityShop*)((*it).second))->AddItemInfo( pMsg );
}

VOID	CAtumApplication::FieldSocketInfinityShopItemDone( void )
{
	CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY_SHOP );
	if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
		((CINFCityInfinityShop*)((*it).second))->ItemInputDone();
}

VOID	CAtumApplication::FieldSocketInfinityChangeLimitTime( MSG_FC_INFINITY_CHANGE_LIMITTIME* pMsg )
{
	// ǴƼ  ð 
	m_pInterface->m_pInfinity->SetInfinityChangeLimitTime( pMsg );
}

VOID	CAtumApplication::FieldSocketInfinityJoinCancelRequestMaster( MSG_FC_INFINITY_JOIN_CANCEL_REQUEST_MASTERUSER* pMsg )
{
	// ǴƼ   û   
	GetInfinityManager()->RemoveJoinRequest( pMsg->JoinCancelClientIdx );
}

VOID	CAtumApplication::FieldSocketInfinityRequestRestartByDisconnect( void )
{
	// ǴƼ   ˷
	m_bInfinityRestart	= TRUE;
	m_bAddInfinityRestartMessageBox	= TRUE;
}

VOID	CAtumApplication::FieldSocketInfinityDeletedCinema( MSG_FC_INFINITY_DELETED_CINEMA* pMsg )
{
	// Ʈ 
	if( pMsg->ObjectIdx )
		ChangeMapObject( pMsg->ObjectIdx, pMsg->ChangeObjectIdx );
}

VOID	CAtumApplication::FieldSocketInfinityEnterByDisConnect( MSG_FC_INFINITY_ENTER_BY_DISCONNECT* pMsg )
{
	// ä ε
	m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.ChannelIndex = pMsg->InfinityChannelIdx;
	// 
	m_pShuttleChild->m_vPos	= pMsg->CharacterPosition;

	//    
	INFINITY_MODE_INFO info;
	info.InfinityMapIdx		= m_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex;
	info.InfinityMode		= pMsg->InfinityMode;
	info.InfinityModeUID	= 0;
	info.Join				= TRUE;
	info.MinLv				= 0;
	info.MaxLv				= 0;
	info.TimePenaltyValue	= pMsg->TimePenaltyValue;

	GetInfinityManager()->SetMyRoomInfo( pMsg->MasterClientIdx, pMsg->InfinityCreateUID, &info );

	//  ε 
	m_pInterface->InvalidateMapLoadObjects();
	m_pInterface->DeleteMapLoadObjects();
	ChangeGameState( _GAME );

	// Ƽ  
	int nPenaltyTime = m_pInfinityManager->GetMyRoomInfo()->ModeInfo.TimePenaltyValue;
	char szTemp[ 256 ];

	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo( m_pInfinityManager->GetMyRoomInfo()->ModeInfo.InfinityMapIdx );
	if( pMapInfo )
	{
		if( nPenaltyTime > 0 )
		{
			sprintf( szTemp, STRMSG_C_091103_0334, pMapInfo->MapName, nPenaltyTime );	// "\\y[%s]()   ǴƼ ʵ  ð [%d]  ˴ϴ.\\y"
			g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
		}
		else if( nPenaltyTime < 0 )
		{
			sprintf( szTemp, STRMSG_C_091103_0333, pMapInfo->MapName, abs(nPenaltyTime) );	// "\\y[%s]()   ǴƼ ʵ  ð [%d]  ˴ϴ.\\y"
			g_pGameMain->CreateChatChild( szTemp, COLOR_SYSTEM );
		}
	}

	// ǴƼ ǥ   Ƿ     Ѵ
	m_pShuttleChild->DeletePattern();
	m_pShuttleChild->PatternWarpOut(TRUE);

	// ӽÿ FieldSocketConnectArenaServerLoginOk ȭ ð Ѵ
	//g_ArenaServerDateTime	= pMsg->StartTime;
	//g_ArenaStartTime		= timeGetTime();

	// ǴƼ ð
	// 2010. 04. 16 by ckPark ǴƼ ʵ 2( )
// 	m_pInterface->m_pInfinity->SetInfinityLimitTime( &(pMsg->StartTime), pMsg->LimitTime );
// 
// 	m_pInterface->m_pInfinity->SetInfinityPenaltyTime( pMsg->DecreaseTimeByDead );

	if( m_pInterface && m_pInterface->m_pInfinity )
	{
		m_pInterface->m_pInfinity->SetInfinityLimitTime( &(pMsg->StartTime), pMsg->LimitTime );

		m_pInterface->m_pInfinity->SetInfinityPenaltyTime( pMsg->DecreaseTimeByDead );
	}
	// end 2010. 04. 16 by ckPark ǴƼ ʵ 2( )

	// ǴƼ  ε  
	m_bInfinityMapload	= FALSE;

	// ǴƼ  㰡
	m_bEnterInfinityAllowed	= TRUE;

	// α׿â 
	g_pGameMain->m_pSystem->EnableLogOffBtn( FALSE );

	// Restart False
	m_bInfinityRestart	 = FALSE;
}

VOID	CAtumApplication::FieldSocketInfinityPartyAutoCreated( MSG_FC_PARTY_AUTO_CREATED* pMsg )
{
	m_pShuttleChild->m_pClientParty->FPartyAutoCreateOK( pMsg );
}
// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý

/*****************************************************************************************************
**
**	ǴƼ ̵   ޱ.
**
**	Create Info :	2010. 05. 26. by hsLee.
**
******************************************************************************************************/
VOID	CAtumApplication :: FieldSocketInfinityRegsiterDifficultyBonusInfoListData ( MSG_INFINITY_DIFFICULTY_LIST_OK* pMsg )
{
	if ( NULL == pMsg )
		return;
	
	m_pInfinityManager->ClearInfinityDifficultyBonusInfo_ListData();

	char* pTemp = (char*)(pMsg) + sizeof( MSG_INFINITY_DIFFICULTY_LIST_OK );
	
	//  ŭ  ߰
	for( int i=0; i<pMsg->Difficulty_List_count; ++i )
	{
		INFINITY_DIFFICULTY_BONUS_INFO* p = (INFINITY_DIFFICULTY_BONUS_INFO*)(pTemp + i * sizeof( INFINITY_DIFFICULTY_BONUS_INFO ));
		m_pInfinityManager->Register_InfinityDifficultyBonusInfo_ListData ( p );
	}

}

// 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() )
/********************************************************************************************************
**
**	ǴƼ  ̵    ޱ.
**
**	Create Info :	2010. 05. 26.	by hsLee.
**
*********************************************************************************************************/
VOID	CAtumApplication :: FieldSocketInfinityChangeRoomDifficultyLevelOK( MSG_FC_INFINITY_CHANGE_DIFFICULTY_LEVEL_OK* pMsg )
{
	if ( NULL == pMsg )
		return;

	if ( g_pD3dApp->GetInfinityManager()->SetMyRoomInfo_Difficult ( pMsg->InfinityDifficultyLevel ) )
	{
		if ( TRUE == pMsg->bUpdate )
		{
			char szMsgBuff[256] = {0, };
				sprintf ( szMsgBuff ,  STRMSG_C_100601_0501 , pMsg->InfinityDifficultyLevel );
				
			m_pChat->CreateChatChild ( szMsgBuff , COLOR_SYSTEM );
		}
	}

}
// End 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() )


// 2010. 05. 31 by hsLee ǴƼ ʵ 2 ̵ . (Ʈ  뷱   .)
/****************************************************************************
**
**	ǴƼ -   ɹ  .
**
**	Create Info :	2010. 05. 31. by hsLee.
**
*****************************************************************************/
VOID CAtumApplication :: FieldSocketInfinityReadyCancelAllOK ( MSG_FC_INFINITY_READY_CANCEL_ALL_OK* pMsg )
{

	if ( NULL == pMsg )
		return;

	const MyInfinityRoomInfo *a_psInfinityMyRoomInfo = g_pD3dApp->GetInfinityManager()->GetMyRoomInfo();

	if ( a_psInfinityMyRoomInfo->InfinityCreateUID != pMsg->InfinityCreateUID )
		return;

	UINT ui = 0;

	for ( ui = 0; ui < g_pD3dApp->GetInfinityManager()->GetMemberCount(); ++ui )
	{

		INFINITY_MEMBER_INFO_LIST *pMemberInfo = g_pD3dApp->GetInfinityManager()->GetMemberInfoByIndex( ui );
			if ( NULL == pMemberInfo || pMemberInfo->ClientIdx == a_psInfinityMyRoomInfo->MasterIndex )
				continue;

		pMemberInfo->State = INFINITY_STATE_UNPREPARED;
	}

}
// End 2010. 05. 31 by hsLee ǴƼ ʵ 2 ̵ . (Ʈ  뷱   .)


// 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.
VOID	CAtumApplication :: FieldSocketInfinityCinemaSkip ( MSG_FC_INFINITY_SKIP_ENDING_CINEMA_OK * pMsg )
{
	if ( NULL == pMsg || TRUE != pMsg->EnableSkip )
		return;

	g_pInterface->m_pInfinity->SkipEndingCinema( pMsg->szCharName , pMsg->NormalEnding == TRUE ? true : false );

	g_pInterface->m_pInfinity->UpdateTenderAllItemInfo_TenderStartTime ( pMsg->sUpdateTenderItemStartTime );

}
// End 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.


// 2010. 02. 11 by ckPark ߵ 
VOID	CAtumApplication::FieldSocketInfoApplyDestParam( MSG_FC_INFO_APPLY_DESTPARAM* pMsg )
{
	//    
	if( m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ApplyClientIdx )
	{
		CItemInfo* pItem = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ApplyItemUID );
		if( pItem )
		{
			char szTemp[ 256 ];
			sprintf( szTemp, STRMSG_C_100218_0308, pItem->ItemInfo->ItemName );	// "\\g[%s] ߵ Ǿϴ.\\g"
			m_pChat->CreateChatChild( szTemp, COLOR_SYSTEM );

			if( g_pGameMain )
			{
				// Ÿ 
				g_pGameMain->SetItemCoolStart( pMsg->ApplyItemUID );
			}
		}
	}

	// Ʈ
	CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->ApplyClientIdx );
	if( pUnit )
	{
		CAppEffectData* pEff = new CAppEffectData( pUnit, pMsg->ApplyEffectIdx, D3DXVECTOR3(0.0f, 0.0f, 0.0f) );

		if( !pEff->m_bUsing )
		{
			SAFE_DELETE( pEff );
		}
		else
		{
			m_pEffectList->AddChild( pEff );
		}
	}
}

VOID	CAtumApplication::FieldSocketInfoApplyDestParamList( MSG_FC_INFO_APPLY_DESTPARAM_LIST* pMsg )
{
	if( m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->ApplyClientIdx )
	{
		CItemInfo* pItem = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ApplyItemUID );

		if( pItem )
		{
			char szTemp[ 256 ];
			sprintf( szTemp, STRMSG_C_100218_0308, pItem->ItemInfo->ItemName );	// "\\g[%s] ߵ Ǿϴ.\\g"
			m_pChat->CreateChatChild( szTemp, COLOR_SYSTEM );

			if( g_pGameMain )
			{
				// Ÿ 
				g_pGameMain->SetItemCoolStart( pMsg->ApplyItemUID );
			}
		}
	}

	// Ʈ
	CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->ApplyClientIdx );
	if( pUnit )
	{
		for( int i=0; i<pMsg->ApplyDestParamCnt; ++i )
		{
			APPLY_DESTPARAM_INFO* pDesParam = (APPLY_DESTPARAM_INFO*)(((char*)(pMsg))
											  + sizeof( MSG_FC_INFO_APPLY_DESTPARAM_LIST )
											  + sizeof( APPLY_DESTPARAM_INFO ) * i);

			if( pDesParam->ApplyEffectIdx )
			{
				// ش ȣ, ġ Ʈ ߰
				CAppEffectData* pEff = new CAppEffectData( pUnit, pDesParam->ApplyEffectIdx, D3DXVECTOR3(0.0f, 0.0f, 0.0f) );

				if( !pEff->m_bUsing )
				{
					SAFE_DELETE( pEff );
				}
				else
				{
					m_pEffectList->AddChild( pEff );
				}
			}
		}
	}
}

VOID	CAtumApplication::FieldSocketItemEndCoolItemOK( MSG_FC_ITEM_END_COOLINGTIME_ITEM_OK* pMsg )
{
	// Ÿ 
	if( g_pGameMain )
		g_pGameMain->SetItemCoolEnd( pMsg->ItemUID );
}

VOID	CAtumApplication::FieldSocketItemGetCoolTimeInfoOK( MSG_FC_ITEM_GET_COOLINGTIME_INFO_OK* pMsg )
{
	CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUID );
	if( pItemInfo )
	{
		// Ÿ ð 
		pItemInfo->SetCoolElapsedTime( pMsg->CoolingTimeStamp * 1000 );

		if( g_pGameMain )
		{
			if( pMsg->CoolingTimeStamp <= 0 )
				// Ÿ 0  Ÿ Ʈ 
				g_pGameMain->PopInvokeWearItem( pMsg->ItemUID );
			else
				// Ÿ  ð 缳
				g_pGameMain->RefreshInvokeItemTickTime( pMsg->ItemUID );
		}
	}
}

VOID	CAtumApplication::FieldSocketItemUseInvokingWearItemBuff( MSG_FC_ITEM_USE_INVOKING_WEAR_ITEM_BUFF* pMsg )
{
	CItemInfo* pItem = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUID );
	if( pItem && g_pGameMain )
		g_pGameMain->m_pInfSkill->InsertItemBuff( pItem->ItemInfo, pMsg->ItemUID, pItem->ItemInfo->Time );
}
// end 2010. 02. 11 by ckPark ߵ 

// 2010. 03. 15 by ckPark ǴƼ ʵ 2( ó)
VOID	CAtumApplication::FieldSocketInfinityChangeAliveForGameClearMonsterHP( MSG_FC_INFINITY_CHANGE_ALIVE_FOR_GAMECLEAR_MONSTERHP* pMsg )
{
	if( m_pInterface && m_pInterface->m_pInfinity )
	{
		KeyMonsterInfo* pKeyMon = m_pInterface->m_pInfinity->GetKeyMonsterInfo( pMsg->MonsterIdx );
		if( pKeyMon )
		{
			char szBuff[ 256 ];
			char* p = strrchr( pMsg->DeadCharactarName, '\\' );
			if( p )
				*p = '\0';
			
#if defined(LANGUAGE_JAPAN)
		sprintf( szBuff, STRMSG_C_100618_0405,	// " Ͽ %s HP %dŭ  Ͽϴ."
			pKeyMon->m_pMonsterInfo->MonsterName,
			pKeyMon->m_nCurHP - (INT)(pMsg->CurrentHP) );
#else
		sprintf( szBuff, STRMSG_C_100310_0307,	// "%s Ͽ %s HP %dŭ  Ͽϴ."
			pMsg->DeadCharactarName,
			pKeyMon->m_pMonsterInfo->MonsterName,
			pKeyMon->m_nCurHP - (INT)(pMsg->CurrentHP) );
#endif			
			m_pChat->CreateChatChild( szBuff, COLOR_SYSTEM );
			
			// Ű ü 
			m_pInterface->m_pInfinity->SetKeyMonsterHP( pMsg->MonsterIdx, (INT)(pMsg->CurrentHP) );
		}
	}
}

VOID	CAtumApplication::FieldSocketMonsterCreatedAliveForGameClear( MSG_FC_MONSTER_CREATED_ALIVE_FOR_GAMECLEAR* pMsg )
{
	MEX_MONSTER_INFO* pMon = m_pDatabase->CheckMonsterInfo( pMsg->MonsterNum );
	if( pMon && m_pInterface && m_pInterface->m_pInfinity )
		// 2010. 06. 08 by hsLee ǴƼ ʵ 2 ̵ . (Ʊ  뷱 .) - Ű  Ͻ MaxHP  ߰.
		m_pInterface->m_pInfinity->AddKeyMonster( pMon, pMsg->MonsterIdx, pMsg->CurrentHP , pMsg->MaxHP );
		/*m_pInterface->m_pInfinity->AddKeyMonster( pMon, pMsg->MonsterIdx, pMsg->CurrentHP );*/
}
// end 2010. 03. 15 by ckPark ǴƼ ʵ 2( ó)

// 2010. 03. 18 by ckPark ǴƼ ʵ 2( ų ߰)
VOID	CAtumApplication::FieldSocketMonsterCancelSkill( MSG_FC_MONSTER_SKILL_CANCEL* pMsg )
{
	if( m_pScene )
	{
		CUnitData* pUnit = m_pScene->FindUnitDataByClientIndex( pMsg->MonsterIndex );
		if( pUnit && pUnit->m_dwPartType == _MONSTER )
			((CMonsterData*)(pUnit))->RemoveMonsterBuffSkill( pMsg->SkillItemNum );
	}
}
// end 2010. 03. 18 by ckPark ǴƼ ʵ 2( ų ߰)

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCharacterTutorialSkipOk(MSG_FC_CHARACTER_TUTORIAL_SKIP_OK* pMsg)
/// \brief		Ʃ丮 ŵ  ׿  
/// \author		jschoi
/// \date		2005-04-21 ~ 2005-04-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterTutorialSkipOk(MSG_FC_CHARACTER_TUTORIAL_SKIP_OK* pMsg)
{
	m_bRequestEnable = TRUE;
	g_pShuttleChild->m_myShuttleInfo.MapChannelIndex = pMsg->mapChannelIdx;

	g_pInterface->InitMapLoadObjects();
	g_pInterface->RestoreMapLoadObjects();
	// 2007-12-26 by bhsohn  ۿ  κ 
//	SAFE_DELETE(m_pMapInitThread );
//	m_pMapInitThread = new CMapInitThread();
//	m_pMapInitThread->CreateThread();
	ChangeGameState(_MAPLOAD);	
	
	{
		// IM Server  õ
		g_pD3dApp->ConnectLoginIMServer(g_pD3dApp->m_strUserID,
			((CShuttleChild *)(g_pD3dApp->m_pShuttleChild))->m_myShuttleInfo.CharacterName,
			g_pD3dApp->m_strUserPassword);											
	}
	// end 2007-12-26 by bhsohn  ۿ  κ 
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketMoveHackShield_GuidReqMsg(MSG_FC_MOVE_HACKSHIELD_GuidReqMsg* pMsg)
/// \brief		
/// \author		ispark
/// \date		2006-06-05 ~ 2006-06-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
// 2008-04-04 by bhsohn ٽ  
//VOID CAtumApplication::FieldSocketMoveHackShield_GuidReqMsg(MSG_FC_MOVE_HACKSHIELD_GuidReqMsg* pMsg)
//{
//	MSG_FC_MOVE_HACKSHIELD_GuidAckMsg sMsg;
//	memset(&sMsg,0x00,sizeof(sMsg));
//
//	HS_MakeGuidAckMsg(pMsg->pbyGuidReqMsg, sMsg.pbyGuidAckMsg);
//
//	m_pFieldWinSocket->SendMsg(T_FC_MOVE_HACKSHIELD_GuidAckMsg, (char*)&sMsg, sizeof(sMsg));
//
//	// ٽ 
//	MSG_FC_CHARACTER_GAMESTART sGameStartMsg;
//	memset(&sMsg,0x00,sizeof(sGameStartMsg));
//	char buffer[SIZE_MAX_PACKET];
//	sGameStartMsg.ClientIndex = m_pShuttleChild->m_myShuttleInfo.ClientIndex;
//	sGameStartMsg.CharacterUniqueNumber = m_pShuttleChild->m_myShuttleInfo.CharacterUniqueNumber;
//	int nType = T_FC_CHARACTER_GAMESTART;
//	memcpy(buffer, &nType, SIZE_FIELD_TYPE_HEADER);
//	memcpy(buffer+SIZE_FIELD_TYPE_HEADER, &sGameStartMsg, sizeof(sGameStartMsg));
//	g_pD3dApp->m_pFieldWinSocket->Write(buffer, SIZE_FIELD_TYPE_HEADER + sizeof(sGameStartMsg));
//	DBGOUT("MoveHackShield_GuidReqMsg : Ready, Send GameStart(T_FC_CHARACTER_GAMESTART, m_bMapLoad = TRUE; m_bLoginChat = IM_SERVER_STATE_READY_FOR_GAMESTART);\n");	
//}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketMoveHackShield_CRCReqMsg(MSG_FC_MOVE_HACKSHIELD_CRCReqMsg* pMsg)
/// \brief		
/// \author		ispark
/// \date		2006-06-05 ~ 2006-06-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMoveHackShield_CRCReqMsg(MSG_FC_MOVE_HACKSHIELD_CRCReqMsg* pMsg)
{

	if (b_CanadaMutex) //2012-09-17 by jhahn	ĳ ٽ  
	{
		// 2008-04-04 by bhsohn ٽ  
		MSG_FC_MOVE_HACKSHIELD_CRCAckMsg sMsg;
		memset(&sMsg,0x00,sizeof(sMsg));
		
		//	HS_MakeCRCAckMsg(pMsg->pbyReqMsg, sMsg.pbyAckMsg);		
		int nRet = _AhnHS_MakeResponse(pMsg->stRequestBuf.byBuffer, pMsg->stRequestBuf.nLength, &sMsg.stResponseBuf);
		if(ERROR_SUCCESS != nRet)
		{
			char szMessage[256];
			//wsprintf(szMessage,STRMSG_C_060608_0000);//" Ǿϴ.  ˴ϴ.  [%d]"
			wsprintf ( szMessage , "%s\n[%d]" , STRMSG_C_060608_0000 , nRet );
			
			NetworkErrorMsgBox(szMessage);
			return;
		}
		// end 2008-04-04 by bhsohn ٽ  
		
		m_pFieldWinSocket->SendMsg(T_FC_MOVE_HACKSHIELD_CRCAckMsg, (char*)&sMsg, sizeof(sMsg));

	
	}
	
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketError(MSG_ERROR* pMsg)
/// \brief		MSG_ERROR ó
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketError(MSG_ERROR* pMsg)
{
	FLOG("CAtumApplication::FieldSocketError(MSG_ERROR* pMsg)");
	char errMsg[1024];
	memset(errMsg, 0x00, sizeof(errMsg));
	wsprintf(errMsg, "ERROR, FieldSocket, ErrCode : [%s]%#04x, ErrParam1:%d, ErrParam2:%d\n",
		GetErrorString(pMsg->ErrorCode), pMsg->ErrorCode, pMsg->ErrParam1, pMsg->ErrParam2);

	// 2007-08-14 by bhsohn  Ʈ ڰ  ְԲ 
	char* chErrorString = NULL;
	// end 2007-08-14 by bhsohn  Ʈ ڰ  ְԲ 

	if(pMsg->StringLength > 0)
	{
		memcpy(errMsg+strlen(errMsg), ((char*)pMsg) + sizeof(MSG_ERROR), pMsg->StringLength);

		// 2007-08-14 by bhsohn  Ʈ ڰ  ְԲ 
		chErrorString = (char*)malloc(pMsg->StringLength+1);
		memset(chErrorString, 0x00, pMsg->StringLength+1);
		strncpy(chErrorString, ((char*)pMsg) + sizeof(MSG_ERROR), pMsg->StringLength);
		// end 2007-08-14 by bhsohn  Ʈ ڰ  ְԲ 
	}

	DBGOUT(errMsg);
	DBGOUT("\n");

	CheckMultiLock(TRUE, pMsg->MsgType);

	// 2005-03-17 by jschoi
	// 1. Ŭ̾Ʈ  ó
	// 2006-07-28 by ispark, 
	switch(pMsg->MsgType)
	{
	case T_FC_SHOP_BUY_ITEM:
	case T_FC_SHOP_BUY_CASH_ITEM:
	case T_FC_STORE_MOVE_ITEM:
	case T_FC_SHOP_SELL_ITEM:			//    
	case T_FC_STORE_GET_ITEM:
	case T_FC_ITEM_USE_ENCHANT:
	case T_FC_ITEM_MIX_ITEMS:
	case T_FC_BAZAAR_SELL_PUT_ITEM:
	case T_FC_BAZAAR_SELL_CANCEL_ITEM:
	case T_FC_BAZAAR_BUY_PUT_ITEM:
	case T_FC_BAZAAR_BUY_CANCEL_ITEM:
	case T_FC_BAZAAR_SELL_START:
	case T_FC_BAZAAR_BUY_START:
	case T_FC_BAZAAR_SELL_BUY_ITEM:
	case T_FC_BAZAAR_BUY_SELL_ITEM:
	case T_FC_BAZAAR_SELL_REQUEST_ITEMLIST:
	case T_FC_BAZAAR_BUY_REQUEST_ITEMLIST:
	case T_FC_EVENT_CHARACTERMODE_ENTER_BUILDING:
	case T_FC_EVENT_ENTER_BUILDING:
	case T_FC_ITEM_USE_RANDOMBOX:
	case T_FC_STORE_LOG_GUILD_ITEM:
	case T_FC_CHARACTER_USE_BONUSSTAT:					// 2006-09-18 by ispark, ʽ   ȭ
	case T_FC_CHARACTER_GET_CASH_MONEY_COUNT:			// 2006-09-21 by ispark, ĳ Ʈ 
	case T_FC_CHARACTER_CREATE:							// 2008-01-15 by dgwoo  ó.
	case T_FC_CHARACTER_DELETE:
	case T_FC_SHOP_CHECK_GIVE_TARGET:
	case T_FC_CITY_POLL_REQUEST_LEADER_CANDIDATE_LIST:
	case T_FC_EVENT_COUPON_EVENT_USE_COUPON:
		{
			m_bRequestEnable = TRUE;
			m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
		}
		break;
	}	
	// 2. ߸ ų  ó	
	if(pMsg->MsgType == T_FC_SKILL_PREPARE_USE ||		// 2006-12-20 by ispark
		pMsg->MsgType == T_FC_SKILL_USE_SKILL)
	{
		if(g_pShuttleChild && g_pShuttleChild->m_pSkill)
		{
			g_pShuttleChild->m_pSkill->CancelSkill(pMsg->ErrParam1, FALSE);

			// 2007-07-09 by bhsohn     ½ÿ  ó
			CancelBazzarSkill(pMsg->ErrParam1);			
			// end 2007-07-09 by bhsohn     ½ÿ  ó
		}
	}

	// 3.   æƮ   ʱȭ
	if( pMsg->MsgType == T_FC_ITEM_USE_ENCHANT )
	{
		CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
		if(pCityLab)
		{
			pCityLab->InitData();
		}
	}
	else if( pMsg->MsgType == T_FC_ITEM_MIX_ITEMS )
	{
		CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_FACTORY);
		if(pCityLab)
		{
			pCityLab->InitData();
		}
	}

	// 4.  н ó
	if(pMsg->MsgType == T_FC_EVENT_REQUEST_OBJECT_EVENT || pMsg->MsgType == T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT)
//		&& pMsg->ErrorCode == ERR_PROTOCOL_REQ_WARP_REQUIREMENTS_NOT_MATCHED)	// 2005-12-29 by ispark, ʿ  
	{//   
		g_pShuttleChild->m_nCurrentPatternNumber = PATTERN_UNIT_WARP_OUT;
		g_pShuttleChild->DeletePattern();
		
		// 2007-10-19 by bhsohn ĳ 忡  нÿ  ó
		//g_pShuttleChild->m_dwState = _NORMAL;
		if(FALSE == IsMyShuttleCharacter())
		{
			g_pShuttleChild->m_dwState = _NORMAL;
		}
		// end 2007-10-19 by bhsohn ĳ 忡  нÿ  ó

		g_pShuttleChild->m_bOrderMove = FALSE;

		//  ̶ 
		if(	g_pShuttleChild->m_pClientParty &&
			g_pShuttleChild->m_pClientParty->IsFormationFlightMove())
		{
			char message [256];
			g_pShuttleChild->SendPacket(T_IC_PARTY_CANCEL_FLIGHT_POSITION);
			g_pShuttleChild->m_pClientParty->FormationFlightClear();
//			m_infoParty.bFormationFlyingPositionType = 0;
//			m_bFormationFlight = FALSE; //   ˽ϰ   Ѵ.
			wsprintf(message,STRMSG_C_PARTY_0001);//"࿡ ϴ."
			g_pD3dApp->m_pChat->CreateChatChild(message,COLOR_SYSTEM);
		}
	}

	// 5. Ѹ н ó
	if(pMsg->MsgType == T_FC_MOVE_ROLLING &&
		pMsg->ErrorCode == ERR_PROTOCOL_NOT_ENOUGH_ELAPSE_TIME)
	{
		// Ѹ ʱȭ
		g_pShuttleChild->InitRolling();
	}

	// 6.   
	char errStr[512];
#ifndef _DEBUG
	if(m_pShuttleChild && COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
#endif
	{
		// 2007-08-14 by bhsohn  Ʈ ڰ  ְԲ 
		//wsprintf(errStr,"ERR:(%s),(%s)",GetProtocolTypeString(pMsg->MsgType),GetErrorString(pMsg->ErrorCode));
		if(chErrorString)
		{
			// 2007-10-23 by bhsohn   ڵ ߰
			//wsprintf(errStr,"ERR:(%s),(%s) (%s)",GetProtocolTypeString(pMsg->MsgType),GetErrorString(pMsg->ErrorCode), chErrorString);
			wsprintf(errStr,"ERR:(%s),(%s) (%s) [%d][%d]",
					GetProtocolTypeString(pMsg->MsgType),
					GetErrorString(pMsg->ErrorCode), 
					chErrorString,
					pMsg->ErrParam1, pMsg->ErrParam2);

			
			free(chErrorString);
		}
		else
		{
			// 2007-10-23 by bhsohn   ڵ ߰
			//wsprintf(errStr,"ERR:(%s),(%s)",GetProtocolTypeString(pMsg->MsgType),GetErrorString(pMsg->ErrorCode));
			wsprintf(errStr,"ERR:(%s),(%s) [%d][%d]",
					GetProtocolTypeString(pMsg->MsgType),
					GetErrorString(pMsg->ErrorCode),
					pMsg->ErrParam1, pMsg->ErrParam2);
		}		
		// end 2007-08-14 by bhsohn  Ʈ ڰ  ְԲ 
		m_pChat->CreateChatChild(errStr,COLOR_SYSTEM);
	}
	// 2008-04-08 by dgwoo Ʒ Ȱ  ÷ ȯ.
	if(pMsg->MsgType == T_FC_ITEM_USE_CARDITEM_RESTORE)
	{
		
		// 2007-10-23 by dgwoo ׾ 쿡 T_FC_ITEM_USE_CARDITEM_RESTORE  ߻ SendDeadMsg() ߻.
		if(g_pShuttleChild->CheckUnitState() == BREAKDOWN)
			g_pShuttleChild->SendDeadMsg();
	}

	// 7. ޽ ŸԿ  Ϲ ó
	if(FieldSocketErrorByErrorCode(pMsg))
	{
		if(pMsg->CloseConnection)
		{
			g_pFieldWinSocket->CloseSocket();

			char message[256];
				wsprintf(message,STRERR_ERROR_0001,pMsg->ErrorCode);//"   մϴ.  ˴ϴ. [0x%x] case T_ERROR:(FC)  "
			
			/*
			if(COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
			{
				wsprintf(message,STRERR_ERROR_0001,pMsg->ErrorCode);//"   մϴ.  ˴ϴ. [0x%x] case T_ERROR:(FC)  "
			}
			else
			{
				wsprintf(message,STRMSG_C_060608_0000);//" Ǿϴ.  ˴ϴ.  [%d]"
			}
			*/
			NetworkErrorMsgBox(message);
		}
		return;
	}

	// 8. ޽ ŸԺ ޽ ó
	FieldSocketErrorByMsgType(pMsg);

	if(pMsg->CloseConnection)
	{
		g_pFieldWinSocket->CloseSocket();

		char message[256];
			wsprintf(message,STRERR_ERROR_0002,pMsg->ErrorCode);//"  Ǿϴ.  ˴ϴ. [0x%x] case T_ERROR:(FC)  "

		/*
		if(COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
		{
			wsprintf(message,STRERR_ERROR_0002,pMsg->ErrorCode);//"  Ǿϴ.  ˴ϴ. [0x%x] case T_ERROR:(FC)  "
		}
		else
		{
			wsprintf(message,STRMSG_C_060608_0000);//" Ǿϴ.  ˴ϴ.  [%d]"
		}
		*/
		NetworkErrorMsgBox(message);
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::CancelBazzarSkill()
/// \brief		Ŷ ǵ  ݷ 
/// \author		// 2007-07-09 by bhsohn     ½ÿ  ó
/// \date		2007-07-09 ~ 2007-07-09
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::CancelBazzarSkill(int nSkillItemNum)
{
	ITEM* pItem = g_pDatabase->GetServerItemInfo(nSkillItemNum);			
	if(pItem && IS_BAZAAR_SKILL(pItem))
	{
		char strMessage[256];
		char* strSkillName;
		strSkillName = g_pShuttleChild->m_pSkill->GetSkillName(nSkillItemNum);
		if(strSkillName)
		{
			wsprintf(strMessage,STRMSG_C_SKILL_0003,strSkillName);//"ų [%s]  մϴ."
			g_pD3dApp->m_pChat->CreateChatChild(strMessage, COLOR_SKILL_CANCEL,CHAT_TAB_SYSTEM);		
		}		
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketInvalidPacket(char* pPacket)
/// \brief		Ŷ ǵ  ݷ 
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInvalidPacket(char* pPacket)
{
	FLOG("CAtumApplication::FieldSocketInvalidPacket(char* pPacket)");
	char * p = pPacket;
	MessageType_t	nType = 0;
	memcpy(&nType,p,sizeof(MessageType_t));
	char message[256];
	g_pFieldWinSocket->CloseSocket();
#ifdef _DEBUG
		wsprintf(message,STRMSG_C_SERVER_0013,nType,GetProtocolTypeString(nType));
#else
	wsprintf(message,STRMSG_C_SERVER_0013,nType,"FUnknown");//"  ޼ Ÿ Ŭ̾Ʈ "
#endif
	
	// 2007-07-10 by bhsohn  Ÿ   ó
	//  Ŷ
	char chTmp[128];
	wsprintf(chTmp, "PreType[%04x]:%s", m_nPreComType, GetProtocolTypeString(m_nPreComType));
	if((strlen(message)+strlen(chTmp)) < 256)
	{
		strcat(message, chTmp);
	}
	// end 2007-07-10 by bhsohn  Ÿ   ó
	
	NetworkErrorMsgBox(message);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketMoveRolling(MSG_FC_MOVE_ROLLING_OK *pMsg)
/// \brief		Ѹ ޼
/// \author		ispark
/// \date		2005-07-07 ~ 2005-07-07
/// \warning	
///
/// \param		
/// \return		VOID
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMoveRolling(MSG_FC_MOVE_ROLLING_OK *pMsg)
{
	if(m_pShuttleChild == NULL)
	{
		return;
	}
	if(pMsg->ClientIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		//  ޼ ڱ ڽ̸
		g_pShuttleChild->CheckRoll(pMsg->byLeftDirectionFlag);
	}
	else
	{
		//  Ѹ ޼
		CEnemyData *pEnemy = NULL;
		CMapEnemyIterator itEnemy = g_pScene->m_mapEnemyList.find(pMsg->ClientIndex);
		if(itEnemy == g_pScene->m_mapEnemyList.end())
			return;

		pEnemy = itEnemy->second;		// 2005-07-07 by ispark
		pEnemy->CheckRoll(pMsg);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::OnRecvIMSocketMessage(DWORD wParam)
/// \brief		
/// \author		dhkwon
/// \date		2004-03-18 ~ 2004-03-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
int CAtumApplication::OnRecvIMSocketMessage(DWORD wParam, UINT nSocketNotifyType)
{
	FLOG("CAtumApplication::OnRecvIMSocketMessage(DWORD wParam)");

	// 2007-11-22 by bhsohn Ʒ ռ
	CIMSocket* pIMSocket = GetIMWinSocket(nSocketNotifyType);
	if(NULL == pIMSocket)
	{
		// Ͽ
		return 0;
	}
	// end 2007-11-22 by bhsohn Ʒ ռ

	
	switch(LOWORD(wParam))
	{
	case CIMSocket::WS_ERROR:
		{
		}
		break;
	case CIMSocket::WS_CONNECTED:
		{
			if(WM_IM_NOTIFY == nSocketNotifyType )
			{
				if(HIWORD(wParam) == FALSE)
				{
					NetworkErrorMsgBox(STRMSG_C_SERVER_0015);//"IM    ˴ϴ."
				}
			}			
			// 2007-11-22 by bhsohn Ʒ ռ
			// Ʒ IM  
			else if(WM_IM_ARENA_NOTIFY == nSocketNotifyType )
			{
				EnterLock(TRUE);	// FALSE :Lock  TRUE : UnLock

				if(HIWORD(wParam) == FALSE)
				{
					char szNotice[1024];
					memset(szNotice,0x00,1024);		
					sprintf(szNotice, STRMSG_C_080129_0201);		//"Ʒ   Ͽϴ."
					m_pChat->CreateChatChild(szNotice ,COLOR_SYSTEM);

					//  ߻  ´.
					CloseArenaSocket();
				}
				else
				{
					// Ʒ IM Ἲ 
					SendArenaIMLogin();
				}			
			}

		}
		break;
	case CIMSocket::WS_CLOSED:
		{
			DBGOUT("CIMSocket::WS_CLOSED: bArena[%d] \n", WM_IM_ARENA_NOTIFY == nSocketNotifyType);
		}
		break;
	case CIMSocket::WS_RECEIVED:
		{
		char * pPacket = NULL;
		int len;
		MessageType_t nType = 0;
		// 2007-11-22 by bhsohn Ʒ ռ
		//m_pIMSocket->Read(&pPacket,len);
		pIMSocket->Read(&pPacket,len);

		if(pPacket)
		{
			nType = 0;
			memcpy(&nType, pPacket,SIZE_FIELD_TYPE_HEADER);

			g_cCustomOptimizer.ViewDebugString(nType, CCustomOptimizer::E_IM_SERVER_TO_CLIENT);

#ifdef _DEBUG
			PrintExchangeMsg(RECV_TYPE, nType, NULL, ST_FIELD_SERVER);
//			PrintExchangeMsg(RECV_TYPE, nType, NULL, ST_INVALID_TYPE, PRINTLEVEL_ALL);//,ST_FIELD_SERVER);
#endif
			// 2007-11-22 by bhsohn Ʒ ռ
			//   üũ 
			CheckMultiLock(FALSE, nType);
			// end 2007-11-22 by bhsohn Ʒ ռ
			
			switch(nType)
			{
			case T_IC_CONNECT_LOGIN_OK://α 
				{
					// 2007-11-22 by bhsohn Ʒ ռ
					// IMSocketConnectLoginOk();					
					
					if(WM_IM_NOTIFY == nSocketNotifyType )
					{
						IMSocketConnectLoginOk();
					}
					else if(WM_IM_ARENA_NOTIFY == nSocketNotifyType)
					{		
						// Arenaʵ弭 IM  Ϸ Ǿ ˷ش.
						ArenaIMSocketConnectLoginOk();						
					}					
				}
				break;
			case T_IC_CHAT_PTOP: // 1:1 ä  
				{
					IMSocketChatPtoP((MSG_IC_CHAT_PTOP*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_PARTY:
				{
					IMSocketChatParty((MSG_IC_CHAT_PARTY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_GUILD:
				{
					IMSocketChatGuild((MSG_IC_CHAT_GUILD*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_SELL_ALL:
				{
					IMSocketChatSellAll((MSG_IC_CHAT_SELL_ALL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_CASH_ALL:
				{
					IMSocketChatCashAll((MSG_IC_CHAT_CASH_ALL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_ALL:
				{
					IMSocketChatAll(pPacket);
				}
				break;
			case T_IC_CHAT_WAR:
				{
					IMSocketChatWar((MSG_IC_CHAT_WAR*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_CHATROOM:
				{
					IMSocketChatChatRoom((MSG_IC_CHAT_CHATROOM*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_GET_GUILD_OK://   û 
				{
					// 2007-11-22 by bhsohn Ʒ ռ
					//IMSocketChatGetGuildOk((MSG_IC_CHAT_GET_GUILD_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					IMSocketChatGetGuildOk((MSG_IC_CHAT_GET_GUILD_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER), nSocketNotifyType);
				}
				break;
			case T_IC_CHAT_CHANGE_GUILD://  ٲ
				{
					// 2007-11-22 by bhsohn Ʒ ռ
					//IMSocketChatChangeGuild((MSG_IC_CHAT_CHANGE_GUILD*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					IMSocketChatChangeGuild((MSG_IC_CHAT_CHANGE_GUILD*)(pPacket+SIZE_FIELD_TYPE_HEADER), nSocketNotifyType);
				}
				break;
/*				case T_IC_CHAT_GET_PARTY_OK://   û 
				{
					m_pIMSocket->OnRecvdGetPartyOK((MSG_IC_CHAT_GET_PARTY_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
*/				case T_IC_CHAT_CHANGE_PARTY://   ٲ
				{
					// 2007-11-22 by bhsohn Ʒ ռ
					//IMSocketChatChangeParty((MSG_IC_CHAT_CHANGE_PARTY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
					IMSocketChatChangeParty((MSG_IC_CHAT_CHANGE_PARTY*)(pPacket+SIZE_FIELD_TYPE_HEADER), nSocketNotifyType);
				}
				break;
			case T_IC_CHAT_FRIENDLIST_LOADING_OK:// ģƮ ޱ
				{
					IMSocketChatFriendlistAll((MSG_IC_CHAT_FRIENDLIST_LOADING_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_FRIENDLIST_INSERT_OK:// ģƮ ߰ 
				{
					IMSocketChatFriendlistInsertOk((MSG_IC_CHAT_FRIENDLIST_INSERT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_REJECTLIST_LOADING_OK:// źθƮ ޱ
				{
					IMSocketChatRejectlistAll((MSG_IC_CHAT_REJECTLIST_LOADING_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_REJECTLIST_INSERT_OK:// źθƮ ߰  
				{
					IMSocketChatRejectlistInsertOk((MSG_IC_CHAT_REJECTLIST_INSERT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_FRIENDLIST_REFRESH_OK:// Refresh 
				{
					IMSocketChatFriendlistRefreshOk((MSG_IC_CHAT_FRIENDLIST_REFRESH_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_FRIENDLIST_DELETE_OK:// DeletelistOK
				{
					IMSocketChatFriendlistDeleteOk((MSG_IC_CHAT_FRIENDLIST_DELETE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_REJECTLIST_DELETE_OK:// RejectDeletelistOK
				{
					IMSocketChatRejectlistDeleteOk((MSG_IC_CHAT_REJECTLIST_DELETE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;			
			case T_IC_PARTY_ACCEPT_INVITE_OK:
				{
					IMSocketPartyAcceptInviteOk((MSG_IC_PARTY_ACCEPT_INVITE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_PUT_MEMBER:
				{
					IMSocketPartyPutMember((MSG_IC_PARTY_PUT_MEMBER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_LEAVE_OK:
				{
					IMSocketPartyLeaveOk((MSG_IC_PARTY_LEAVE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_BAN_MEMBER_OK:
				{
					IMSocketPartyBanMemberOk((MSG_IC_PARTY_BAN_MEMBER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_DISMEMBER_OK:
				{
					IMSocketPartyDismemberOk((MSG_IC_PARTY_DISMEMBER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_TRANSFER_MASTER_OK:
				{
					IMSocketPartyTransferMasterOk((MSG_IC_PARTY_TRANSFER_MASTER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_PUT_ALL_MEMBER:
				{
					IMSocketPartyPutAllMember((MSG_IC_PARTY_PUT_ALL_MEMBER*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_CHANGE_FLIGHT_FORMATION_OK:
				{
					IMSocketPartyChangeFlightFormationOk((MSG_IC_PARTY_CHANGE_FLIGHT_FORMATION_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_GET_FLIGHT_POSITION:
				{
					IMSocketPartyGetFlightPosition((MSG_IC_PARTY_GET_FLIGHT_POSITION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_CHANGE_FLIGHT_POSITION:
				{
					IMSocketPartyChangeFlightPosition((MSG_IC_PARTY_CHANGE_FLIGHT_POSITION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_CANCEL_FLIGHT_POSITION:
				{
					IMSocketPartyCancelFlightPosition((MSG_IC_PARTY_CANCEL_FLIGHT_POSITION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;

			case T_IC_PARTY_ALL_FLIGHT_POSITION:
				{
					IMSocketPartyAllFlightPosition((MSG_IC_PARTY_ALL_FLIGHT_POSITION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;

			case T_IC_PARTY_PUT_LAST_PARTY_INFO:
				{
					IMSocketPartyPutLastPartyInfo((MSG_IC_PARTY_PUT_LAST_PARTY_INFO*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_UPDATE_MEMBER_INFO_MAPNAME:
				{
					IMSocketPartyUpdateMemberInfoMapName((MSG_IC_PARTY_UPDATE_MEMBER_INFO_MAPNAME*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_MEMBER_INVALIDATED:
				{
					IMSocketPartyMemberInvalidated((MSG_IC_PARTY_MEMBER_INVALIDATED*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_MEMBER_REJOINED:
				{
					IMSocketPartyMemberRejoined((MSG_IC_PARTY_MEMBER_REJOINED*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_UPDATE_ITEM_POS:
				{
					IMSocketPartyUpdateItemPos((MSG_IC_PARTY_UPDATE_ITEM_POS*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
				// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
			case T_IC_PARTY_GET_AUTO_PARTY_INFO_OK:
				{
					IMSocketPartyGetAutoInfoOK( (MSG_IC_PARTY_GET_AUTO_PARTY_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER) );
				}
				break;
				// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
			case T_IC_GUILD_CREATE_OK:
				{
					IMSocketGuildCreateOk((MSG_IC_GUILD_CREATE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_GET_GUILD_INFO_OK:
				{
					IMSocketGuildGetGuildInfoOk((MSG_IC_GUILD_GET_GUILD_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_REQUEST_INVITE_QUESTION:
				{
					IMSocketGuildRequestInviteQuestion((MSG_IC_GUILD_REQUEST_INVITE_QUESTION*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_ACCEPT_INVITE_OK:
				{
					IMSocketGuildAcceptInviteOk((MSG_IC_GUILD_ACCEPT_INVITE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_REJECT_INVITE_OK:
				{
					IMSocketGuildRejectInviteOk((MSG_IC_GUILD_REJECT_INVITE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_BAN_MEMBER_OK:
				{
					IMSocketGuildBanMemberOk((MSG_IC_GUILD_BAN_MEMBER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_LEAVE_OK:
				{
					IMSocketGuildLeaveOk((MSG_IC_GUILD_LEAVE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_DISMEMBER_OK:
				{
					IMSocketGuildDismemberOk((MSG_IC_GUILD_DISMEMBER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_CANCEL_DISMEMBER_OK:
				{
					IMSocketGuildCancelDismemberOk((MSG_IC_GUILD_CANCEL_DISMEMBER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_GET_DISMEMBER_DATE_OK:
				{
					IMSocketGuildGetDismemberDateOk((MSG_IC_GUILD_GET_DISMEMBER_DATE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_CHANGE_GUILD_NAME_OK:
				{
					IMSocketGuildChangeGuildNameOk((MSG_IC_GUILD_CHANGE_GUILD_NAME_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_SET_GUILD_MARK_OK:
				{
					IMSocketGuildSetGuildMarkOk((MSG_IC_GUILD_SET_GUILD_MARK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_GET_GUILD_MARK_OK:
				{
					IMSocketGuildGetGuildMarkOk((MSG_IC_GUILD_GET_GUILD_MARK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_SET_RANK_OK:
				{
					IMSocketGuildSetRankOk((MSG_IC_GUILD_SET_RANK_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_SET_MEMBER_STATE:
				{
					IMSocketGuildSetMemberState((MSG_IC_GUILD_SET_MEMBER_STATE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_CHANGE_GUILD_STATE:
				{
					IMSocketGuildChangeGuildState((MSG_IC_GUILD_CHANGE_GUILD_STATE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_LOADING_GUILD_DONE:
				{
					IMSocketGuildLoadingGuildDone((MSG_IC_GUILD_LOADING_GUILD_DONE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_GET_OTHER_GUILD_INFO_OK:
				{
					IMSocketGuildGetOtherGuildInfoOk((MSG_IC_GUILD_GET_OTHER_GUILD_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_WAR_READY:
				{
					IMSocketGuildWarReady((MSG_IC_GUILD_WAR_READY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_START_WAR:
				{
					IMSocketGuildStartWar((MSG_IC_GUILD_START_WAR*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_END_WAR:
				{
					IMSocketGuildEndWar((MSG_IC_GUILD_END_WAR*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_ADMIN_GET_SERVER_STAT_OK:
				{
					IMSocketAdminGetServerStatOk((MSG_IC_ADMIN_GET_SERVER_STAT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CONNECT_CLOSE:
				{
					IMSocketConnectClose((MSG_IC_CONNECT_CLOSE*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_STRING_128:
				{
					IMSocketString128((MSG_IC_STRING_128*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_STRING_256:
				{
					IMSocketString256((MSG_IC_STRING_256*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_STRING_512:
				{
					IMSocketString512((MSG_IC_STRING_512*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_VOIP_GET_ACCOUNTUNIQUENUMBER_OK:
				{
					IMSocketVoipGetAccountUniquenumberOk((MSG_IC_VOIP_GET_ACCOUNTUNIQUENUMBER_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_VOIP_1to1_DIAL:
				{
					IMSocketVoip1to1Dial((MSG_IC_VOIP_1to1_DIAL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_VOIP_1to1_DIAL_OK:
				{
					IMSocketVoip1to1DialOk((MSG_IC_VOIP_1to1_DIAL_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_VOIP_ERROR:
				{
					IMSocketVoipError((MSG_IC_VOIP_ERROR*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_VOIP_1to1_END:
				{
					IMSocketVoip1to1End((MSG_IC_VOIP_1to1_END*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_VOIP_NtoN_CREATEROOM_REQUEST_OK:
				{
					IMSocketVoipNtoNCreateRoomRequestOk((MSG_IC_VOIP_NtoN_CREATEROOM_REQUEST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_VOIP_NtoN_INVITE_YOU:
				{
					IMSocketVoipNtoNInviteYou((MSG_IC_VOIP_NtoN_INVITE_YOU*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_VOIP_NtoN_GOOUT_ALL:
				{
					IMSocketVoipNtoNGooutAll((MSG_IC_VOIP_NtoN_GOOUT_ALL*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_COUNTDOWN_START:
				{
					IMSocketCountdownStart((MSG_IC_COUNTDOWN_START*)(pPacket+SIZE_FIELD_TYPE_HEADER));					
				}
				break;
			case T_IC_GUILD_CHANGE_MEMBER_CAPACITY:
				{
					IMSocketItemUseCarditemGuildChangeMemberCapacity((MSG_IC_GUILD_CHANGE_MEMBER_CAPACITY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_GET_GUILD_MEMBER_LIST_OK:
				{
					IMSocketGuildGetGuildMemberListOk((MSG_IC_GUILD_GET_GUILD_MEMBER_LIST_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHAT_INFLUENCE_ALL:
				{
					IMSocketChatInfluenceAll(pPacket);
				}
				break;
			case T_IC_ADMIN_CALLGM_INFO_OK:
				{
					IMSocketAdminCallGMInfoOk((MSG_IC_ADMIN_CALLGM_INFO_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_ADMIN_CALLGM_VIEW_OK:
				{
					IMSocketAdminCallGMViewOk(pPacket);
				}
				break;
			case T_IC_ADMIN_CALLGM_BRING_OK:
				{
					IMSocketAdminCallGMBringOk(pPacket);
				}
				break;
			case T_IC_GUILD_END_WAR_ADMIN_NOTIFY:
				{
					IMSocketGuildEndWarAdminNotify((MSG_IC_GUILD_END_WAR_ADMIN_NOTIFY*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			// 2008-03-03 by bhsohn  Ʒ IM  
			case T_IC_CONNECT_FM_TO_IM_OK:
				{
					IMSocketConnectFmToImOk();
				}
				break;
				// end 2008-03-03 by bhsohn  Ʒ IM  
				// 2008-06-03 by bhsohn EP3   ó
			case T_IC_GUILD_NOTICE_WRITE_OK:	//    
				{				
					IMSocketNoticeWriteOk((MSG_IC_GUILD_NOTICE_WRITE_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
				//  
			case T_IC_GUILD_GET_APPLICANT_OK_HEADER:
				{
					IMSocketGetApplicantOkHeader();
				}
				break;
			case T_IC_GUILD_GET_APPLICANT_OK:
				{
					IMSocketGetApplicantOk((MSG_IC_GUILD_GET_APPLICANT_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_GET_APPLICANT_OK_DONE:
				{
					IMSocketGetApplicantOKDone();
				}
				break;
				//  Ұ 
			case T_IC_GUILD_GET_INTRODUCTION_OK:
				{
					IMSocketGetIntroducitonOk((MSG_IC_GUILD_GET_INTRODUCTION_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
				//  Ұ Ʈ
			case T_IC_GUILD_UPDATE_INTRODUCTION_OK:
				{
					IMSocketGuildUpdateIntroductionOk();
				}
				break;
				//  Ұ
			case T_IC_GUILD_DELETE_INTRODUCTION_OK:
				{
					IMSocketGuildDelIntroductionOk();
				}
				break;
				//   Ұ ´.
			case T_IC_GUILD_GET_SELF_INTRODUCTION_OK:
				{
					IMSocketGetSelfIntroductionOK((MSG_IC_GUILD_GET_SELF_INTRODUCTION_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
				//  Ʈ ˻
			case T_IC_GUILD_SEARCH_INTRODUCTION_OK_HEADER:
				{

				}
				break;				
			case T_IC_GUILD_SEARCH_INTRODUCTION_OK:
				{
					IMSocketGuildSearchIntroOk((MSG_IC_GUILD_SEARCH_INTRODUCTION_OK*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_SEARCH_INTRODUCTION_OK_DONE:
				{
					IMSocketGuildSearchIntroDone();
				}
				break;
				// ڱ Ұ Ʈ 			
			case T_IC_GUILD_UPDATE_SELFINTRODUCTION_OK:
				{
					IMSocketUpdateSelfIntroOk();
				}
				break;		
				// ڱ Ұ 
			case T_IC_GUILD_DELETE_SELFINTRODUCTION_OK:
				{
					IMSocketDelSelfIntroOk();
				}
				break;
				// end 2008-05-29 by bhsohn EP3   ó
				// 2008-06-03 by bhsohn EP3   ó
			case T_IC_PARTY_LIST_INFO_OK:	// Ʈ û
				{
					IMSocketPartyListInfoOk((MSG_IC_PARTY_LIST_INFO_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_CHANGE_INFO_OK:				// Ƽ  
				{
					IMSocketPartyChangeInfoOk();
				}
				break;
			case T_IC_PARTY_RECOMMENDATION_MEMBER_OK:	// õ ο
				{
					IMSocketPartyReCommandMemberOk((MSG_IC_PARTY_RECOMMENDATION_MEMBER_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_PARTY_JOIN_FREE_OK:				//  
				{
				}
				break;
			case T_IC_PARTY_INFO:						//   
				{
					IMSocketPartyInfo((MSG_IC_PARTY_INFO*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_GUILD_APPLICANT_INVITE_OK :
				{

				}
				break;
			case T_IC_GUILD_APPLICANT_REJECT_INVITE_OK:
				{

				}
				break;
			case T_IC_GUILD_MEMBER_LEVEL_UP:
				{
					//   
					IMSocketGuildMemerLevelUp((MSG_IC_GUILD_MEMBER_LEVEL_UP*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
				// end 2008-06-03 by bhsohn EP3   ó
				// 2008-06-18 by bhsohn ܿ ī  ó
			case T_IC_GUILD_CHANGE_MEMBERSHIP:
				{
					//    
					IMSocketGuildChangeMemberShip((MSG_IC_GUILD_CHANGE_MEMBERSHIP*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
				// end 2008-06-18 by bhsohn ܿ ī  ó
				// 2008-06-24 by dgwoo äù. 
			case T_IC_CHATROOM_CREATE_OK:
				{
					IMSocketChatRoomCreateOK((MSG_IC_CHATROOM_CREATE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_LIST_INFO_OK:
				{
					IMSocketChatRoomListInfoOK((MSG_IC_CHATROOM_LIST_INFO_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_REQUEST_INVITE_QUESTION:
				{
					IMSocketChatRoomRequestInviteQuestion((MSG_IC_CHATROOM_REQUEST_INVITE_QUESTION*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_JOIN_OK:
				{
					IMSocketChatRoomJoinOK();
				}
				break;
			case T_IC_CHATROOM_ACCEPT_INVITE_OK:
				{
					IMSocketChatRoomAcceptInviteOK((MSG_IC_CHATROOM_ACCEPT_INVITE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_REJECT_INVITE_OK:
				{
					IMSocketChatRoomRejectInviteOK();
				}
				break;
			case T_IC_CHATROOM_LEAVE_OK:
				{
					IMSocketChatRoomLeaveOK((MSG_IC_CHATROOM_LEAVE_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_BAN_OK:
				{
					IMSocketChatRoomBanOK((MSG_IC_CHATROOM_BAN_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_CHANGE_NAME_OK:
				{
					IMSocketChatRoomChangeNameOK((MSG_IC_CHATROOM_CHANGE_NAME_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_CHANGE_MASTER_OK:
				{
					IMSocketChatroomChangeMasterOK((MSG_IC_CHATROOM_CHANGE_MASTER_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_CHANGE_LOCK_PW_OK:
				{
					IMSocketChatRoomChangeLockPWOK((MSG_IC_CHATROOM_CHANGE_LOCK_PW_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_CHANGE_MAX_MEMBER_OK:
				{
					IMSocketChatRoomChangeMaxMemberOK((MSG_IC_CHATROOM_CHANGE_MAX_MEMBER_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			case T_IC_CHATROOM_MEMBER_INFO_OK:
				{
					IMSocketChatRoomMemberInfoOK((MSG_IC_CHATROOM_MEMBER_INFO_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;

			case T_IC_CHATROOM_OTHER_MEMBER_INFO_OK:
				{
					IMSocketChatRoomOtherMemberInfoOK((MSG_IC_CHATROOM_MEMBER_INFO_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
				// 2008-07-11 by bhsohn  ģ Ʈ ý ߰
			case T_IC_CHAT_ONLINE_EACHOTHER_FRIEND_COUNT:
				{
					IMSocketChatOnlineEachOtherFriendCount((MSG_IC_CHAT_ONLINE_EACHOTHER_FRIEND_COUNT*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
				// end 2008-07-11 by bhsohn  ģ Ʈ ý ߰
			case T_IC_VOIP_SET_OK:
				{
					IMSocketVoIPSetOK((MSG_IC_VOIP_SET_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
				// 2008-07-17 by bhsohn  ũ Ž ñ  ذ
			case T_IC_GUILD_CHANGE_FAME_RANK:
				{
					IMGuildChangeFameRank((MSG_IC_GUILD_CHANGE_FAME_RANK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
				// end 2008-07-17 by bhsohn  ũ Ž ñ  ذ
				// 2009-01-12 by bhsohn ģ  ϴ  ޽â  ߰
			case T_IC_CHAT_FRIENDLIST_INSERT_NOTIFY:
				{
					IMChatFriendListInsertNotify((MSG_IC_CHAT_FRIENDLIST_INSERT_NOTIFY*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
				// end 2009-01-12 by bhsohn ģ  ϴ  ޽â  ߰
			// 2009. 01. 12 by ckPark   ý
			case T_IC_INFO_DECLARATION_MSWAR_SET_OK:
				{
					g_pD3dApp->EnterLock(TRUE);
					
					IMSocketWarDeclareSetOK((MSG_IC_INFO_DECLARATION_MSWAR_SET_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			// end 2009. 01. 12 by ckPark   ý
			// 2010. 03. 18 by jskim ͺ ī
			case T_IC_PARTY_UPDATE_ITEM_TRANSFORMER_OK:
				{
					IMSocketPartyUpdateItemTransformerOk((MSG_IC_PARTY_UPDATE_ITEM_TRANSFORMER_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER));
				}
				break;
			//end 2010. 03. 18 by jskim ͺ ī

			case T_ERROR:
				{
					IMSocketError((MSG_ERROR*)(pPacket+SIZE_FIELD_TYPE_HEADER));
				}
				break;
			default:
				{
					IMSocketInvalidPacket(pPacket);
				}
				break;
			}
			// 2007-07-10 by bhsohn  Ÿ   ó
			m_nPreIMComType = nType;
			
			if(pPacket != NULL)
			{
				SAFE_DELETE(pPacket);
			}
		}
		break;
		}
	}
	return 0;
}

VOID CAtumApplication::IMSocketConnectLoginOk(void)
{
	FLOG("CAtumApplication::IMSocketConnectLoginOk(void)");

	// 2007-11-20 by bhsohn ʷε ϴ  
	//m_pInterface->m_pMapLoad->m_bLoginChat = IM_SERVER_STATE_SUCCESS_LOGIN;
	m_pInterface->m_pMapLoad->SetLoginChatMode(IM_SERVER_STATE_SUCCESS_LOGIN);
	m_pInterface->m_pMapLoad->MapLoadNextStep();

	// 2007-11-20 by bhsohn ʷε ϴ  
	{
		g_pD3dApp->SendGameStart(((CShuttleChild *)(g_pD3dApp->m_pShuttleChild))->m_myShuttleInfo.ClientIndex,
												((CShuttleChild *)(g_pD3dApp->m_pShuttleChild))->m_myShuttleInfo.CharacterUniqueNumber);
		m_pInterface->m_pMapLoad->SetLoginChatMode(IM_SERVER_STATE_READY_FOR_GAMESTART);
		m_pInterface->m_pMapLoad->MapLoadNextStep();
	}	
	// end 2007-11-20 by bhsohn ʷε ϴ  

	// 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)	
#if defined(DEFINE_USE_GAMEGUARD_XTRAP)
	CHARACTER* pMainInfo = g_pD3dApp->GetMFSMyShuttleInfo();
    XTrap_C_KeepAlive();
	XTrap_C_SetUserInfoEx((LPCSTR)pMainInfo->AccountName, (LPCSTR)NULL, (LPCSTR)pMainInfo->CharacterName, (LPCSTR)NULL,0,m_pFieldWinSocket->GetFieldWinSocket(WM_PACKET_NOTIFY)->GetSocketHandle());
#endif
	//end 2009. 09. 21 by jskim Ӱ XTRAP (Ʈ)	

// 2011. 1. 18 by jskim Ʈ VTC
#if defined(DEFINE_USE_GAMEGUARD_VTC)
	CHARACTER* pMainInfo = g_pD3dApp->GetMFSMyShuttleInfo();
	m_fnVTCDLLSetUser(pMainInfo->AccountName);	
#endif
// end 2011. 1. 18 by jskim Ʈ VTC
	DBGOUT("IM Server State : Connect Done (T_IC_CONNECT_LOGIN_OK, m_bLoginChat = IM_SERVER_STATE_SUCCESS_LOGIN)\n");
}

VOID CAtumApplication::IMSocketChatPtoP(MSG_IC_CHAT_PTOP* pMsg)
{
	// 2008-06-20 by bhsohn EP3 ɼǰ ó
	if(!g_pD3dApp->IsOptionEtc(OPTION_RADIO_WHISPER))
	{
		// ӼӸ .
		return;
	}
	// end 2008-06-20 by bhsohn EP3 ɼǰ ó
	FLOG("CAtumApplication::IMSocketChatPtoP(MSG_IC_CHAT_PTOP* pMsg)");
	char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_IC_CHAT_PTOP);
	memcpy(bufChat,p,size);
	char str[512];
	int temp,temp2;
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(bufChat, &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(bufChat,&temp,&temp2);
	wsprintf(str,"\"[%s] %s",pMsg->FromCharacterName,bufChat);//ӼӸ
//	m_pChat->CreateChatChild(str,COLOR_CHAT_PTOP);
	m_pChat->CreateChatChild(str,COLOR_CHAT_PTOP,CHAT_TAB_PTOP, pMsg->ToCharacterName, pMsg->FromCharacterName);
	if(strcmp(m_pShuttleChild->m_myShuttleInfo.CharacterName,pMsg->FromCharacterName))
	{
		bool bChatCheckPToP = false;
		for(int i=0;i<MAX_CHAT_PTOP_CONT;i++)
		{
			if(!strcmp(m_pShuttleChild->m_strChatPToP[i],pMsg->FromCharacterName))
			{
				m_pShuttleChild->m_bOldPToPPos = i;
				bChatCheckPToP = true;
				break;
			}
		}
		if(!bChatCheckPToP)
		{
			memset(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bCurPToPPos],0x00,SIZE_MAX_CHARACTER_NAME);
			strncpy(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bCurPToPPos],pMsg->FromCharacterName,strlen(pMsg->FromCharacterName));
			m_pShuttleChild->m_bOldPToPPos = m_pShuttleChild->m_bCurPToPPos;
			m_pShuttleChild->m_bCurPToPPos++;
			if(m_pShuttleChild->m_bCurPToPPos == MAX_CHAT_PTOP_CONT)
				m_pShuttleChild->m_bCurPToPPos = 0;
		}
	}
}

VOID CAtumApplication::IMSocketChatParty(MSG_IC_CHAT_PARTY* pMsg)
{
	// 2008-11-06 by bhsohn ź  ä /Ƽ/ äÿ   ó
	if(g_pGameMain->IsRejectUser(pMsg->FromCharacterName))
	{
		return;
	}
	// end 2008-11-06 by bhsohn ź  ä /Ƽ/ äÿ   ó

	FLOG("CAtumApplication::IMSocketChatParty(MSG_IC_CHAT_PARTY* pMsg)");
	char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_IC_CHAT_PARTY);
	memcpy(bufChat,p,size);
	char str[512];
	int temp,temp2;
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(bufChat, &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(bufChat,&temp,&temp2);

	// 2007-11-22 by bhsohn Ʒ ռ
	//wsprintf(str,"#[%s] %s",pMsg->FromCharacterName,bufChat);//ä
	char szCharacterName[SIZE_MAX_ARENA_FULL_NAME];
	memset(szCharacterName, 0x00, SIZE_MAX_ARENA_FULL_NAME);
	strncpy(szCharacterName, pMsg->FromCharacterName, SIZE_MAX_CHARACTER_NAME);
	ConevertArenaRenderUserName(GetArenaState(), szCharacterName);

	wsprintf(str,"#[%s] %s",szCharacterName,bufChat);//ä
	// end 2007-11-22 by bhsohn Ʒ ռ

	
	//	m_pChat->CreateChatChild(str,COLOR_PARTY);
	m_pChat->CreateChatChild(str,COLOR_PARTY,CHAT_TAB_PARTY);
}

VOID CAtumApplication::IMSocketChatGuild(MSG_IC_CHAT_GUILD* pMsg)
{
	// 2008-11-06 by bhsohn ź  ä /Ƽ/ äÿ   ó
	if(g_pGameMain->IsRejectUser(pMsg->FromCharacterName))
	{
		return;
	}
	// end 2008-11-06 by bhsohn ź  ä /Ƽ/ äÿ   ó

	FLOG("CAtumApplication::IMSocketChatGuild(MSG_IC_CHAT_GUILD* pMsg)");
	char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_IC_CHAT_GUILD);
	memcpy(bufChat,p,size);
	char str[512];
	int temp,temp2;
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(bufChat, &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(bufChat,&temp,&temp2);
	wsprintf(str,"@[%s] %s",pMsg->FromCharacterName,bufChat);// ä
//	m_pChat->CreateChatChild(str,COLOR_CHAT_GUILD);
	m_pChat->CreateChatChild(str,COLOR_CHAT_GUILD, CHAT_TAB_GUILD);
}
VOID CAtumApplication::IMSocketChatWar(MSG_IC_CHAT_WAR* pMsg)
{
	// 2008-11-06 by bhsohn ź  ä /Ƽ/ äÿ   ó
	if(g_pGameMain->IsRejectUser(pMsg->FromCharacterName))
	{
		return;
	}
	// end 2008-11-06 by bhsohn ź  ä /Ƽ/ äÿ   ó

	char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_IC_CHAT_WAR);
	memcpy(bufChat,p,size);
	char str[512];
	int temp,temp2;
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(bufChat, &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(bufChat,&temp,&temp2);
	wsprintf(str,"^[%s] %s",pMsg->FromCharacterName,bufChat);//  ä
	m_pChat->CreateChatChild(str,COLOR_CHAT_WAR, CHAT_TAB_WAR);

}
VOID CAtumApplication::IMSocketChatChatRoom(MSG_IC_CHAT_CHATROOM* pMsg)
{
	char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_IC_CHAT_CHATROOM);
	memcpy(bufChat,p,size);
	char str[512];
	int temp,temp2;
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(bufChat, &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(bufChat,&temp,&temp2);
	wsprintf(str,"&[%s] %s",pMsg->FromCharacterName,bufChat);//  ä
	m_pChat->CreateChatChild(str,COLOR_CHAT_CHATROOM, CHAT_TAB_CHATROOM);
}
VOID CAtumApplication::IMSocketChatSellAll(MSG_IC_CHAT_SELL_ALL* pMsg)
{
	FLOG("CAtumApplication::IMSocketChatSellAll(MSG_IC_CHAT_SELL_ALL* pMsg)");
	// 2006-11-07 by ispark,  Ʈ ִ   ɾ 
	vector<Reject_t>::iterator itReject = g_pGameMain->m_pCommunity->GetReject()->m_vecReject.begin();
	while(itReject != g_pGameMain->m_pCommunity->GetReject()->m_vecReject.end())
	{
		if(0 == stricmp(pMsg->FromCharacterName, itReject->szRejectName))
		{
			return;
		}
		itReject++;			
	}

	char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_IC_CHAT_SELL_ALL);
	memcpy(bufChat,p,size);
	char str[512];
	int temp,temp2;
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(bufChat, &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(bufChat,&temp,&temp2);
	wsprintf(str,"$[%s] %s",pMsg->FromCharacterName,bufChat);//  ä
	m_pChat->CreateChatChild(str,COLOR_CHAT_SELL, CHAT_TAB_TRADE);
}
VOID CAtumApplication::IMSocketChatCashAll(MSG_IC_CHAT_CASH_ALL* pMsg)
{
	FLOG("CAtumApplication::IMSocketChatCashAll(MSG_IC_CHAT_CASH_ALL* pMsg)");

	char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_IC_CHAT_CASH_ALL);
	memcpy(bufChat,p,size);
	char str[512];
	int temp,temp2;
	// 2006-04-13 by ispark
	CheckReadyStringFiltering(bufChat, &temp, &temp2);
//	m_pAbuseFilter->AbuseFiltering(bufChat,&temp,&temp2);
	wsprintf(str,"&[%s] %s",pMsg->FromCharacterName,bufChat);//  ä
	m_pChat->CreateChatChild(str,COLOR_CHAT_CASH, CHAT_TAB_CASH);
}

VOID CAtumApplication::IMSocketChatAll(char* pPacket)
{
	FLOG("CAtumApplication::IMSocketChatAll(char* pPacket)");
	if(m_dwGameState == _GAME || m_dwGameState == _SHOP || m_dwGameState == _CITY)
	{
		MSG_IC_CHAT_ALL	*pChatAll = NULL;
		char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
		memset(bufChat, 0x00, SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4);

		pChatAll = (MSG_IC_CHAT_ALL*)(pPacket + SIZE_FIELD_TYPE_HEADER);
//		wsprintf(bufChat, " [%s] ", pChatAll->FromCharacterName);
		// nType ä ,bufCharacterName  ĳ ̸, bufChat ä 
		// ڸ 
//		for(int i=0;i<4;i++)
//			m_pChat->CreateChatChild(bufChat,COLOR_CHAT_ALL);
		int temp,temp2;
		// 2006-04-13 by ispark
		CheckReadyStringFiltering(bufChat, &temp, &temp2);
//		m_pAbuseFilter->AbuseFiltering(bufChat,&temp,&temp2);


		// 2007-08-07 by bhsohn Ŀ  ߰
		wsprintf(bufChat, STRMSG_C_INTERFACE_0049, pPacket+SIZE_FIELD_TYPE_HEADER+sizeof(MSG_IC_CHAT_ALL));//"[] %s"		
		m_pChat->CreateChatChild(bufChat,COLOR_CHAT_ALL, CHAT_TAB_GAMEMASTER);
		AddSpeakerGMString(bufChat, TRUE);		
		// end 2007-08-07 by bhsohn Ŀ  ߰
		
//		if(m_pInterface && g_pGameMain)
//		{
//			char bufOrder[256];
//			wsprintf(bufOrder,":%s",bufChat);
//			g_pGameMain->SetNotice(bufOrder);
//		}
	}
}

VOID CAtumApplication::IMSocketChatInfluenceAll(char *pPacket)
{
	FLOG("CAtumApplication::IMSocketChatInfluenceAll(MSG_IC_CHAT_INFLUENCE_ALL* pMsg)");
	if(m_dwGameState == _GAME || m_dwGameState == _SHOP || m_dwGameState == _CITY)
	{
		MSG_IC_CHAT_INFLUENCE_ALL	*pChatAll = NULL;
		char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
		memset(bufChat, 0x00, SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4);

		pChatAll = (MSG_IC_CHAT_INFLUENCE_ALL*)(pPacket + SIZE_FIELD_TYPE_HEADER);
		int temp,temp2;
		// 2006-12-13 by dgwoo ( & ߰.)
		//wsprintf(bufChat, STRMSG_C_060421_0000, pPacket+SIZE_FIELD_TYPE_HEADER+sizeof(MSG_IC_CHAT_INFLUENCE_ALL));//"[] %s"
		wsprintf(bufChat, "[%s] %s", pChatAll->FromCharacterName, pPacket+SIZE_FIELD_TYPE_HEADER+sizeof(MSG_IC_CHAT_INFLUENCE_ALL));//"[] %s"
		CheckReadyStringFiltering(bufChat, &temp, &temp2);
		m_pChat->CreateChatChild(bufChat,COLOR_INFLUENCE, CHAT_TAB_INFLUENCE_LEADER);
	}
}
// 2007-11-22 by bhsohn Ʒ ռ
VOID CAtumApplication::IMSocketChatGetGuildOk(MSG_IC_CHAT_GET_GUILD_OK* pMsg, UINT nSocketNotifyType)
{
	FLOG("CAtumApplication::IMSocketChatGetGuildOk(MSG_IC_CHAT_GET_GUILD_OK* pMsg)");
	m_pIMSocket->OnRecvdGetGuildOK(pMsg, nSocketNotifyType);
}
VOID CAtumApplication::IMSocketChatChangeGuild(MSG_IC_CHAT_CHANGE_GUILD* pMsg, UINT nSocketNotifyType)
{
	FLOG("CAtumApplication::IMSocketChatChangeGuild(MSG_IC_CHAT_CHANGE_GUILD* pMsg)");
	m_pIMSocket->OnRecvdChangeGuild(pMsg, nSocketNotifyType);
}
VOID CAtumApplication::IMSocketChatChangeParty(MSG_IC_CHAT_CHANGE_PARTY* pMsg, UINT nSocketNotifyType)
{
	FLOG("CAtumApplication::IMSocketChatChangeParty(MSG_IC_CHAT_CHANGE_PARTY* pMsg)");
	m_pIMSocket->OnRecvdChangeParty(pMsg, nSocketNotifyType);
}
// end 2007-11-22 by bhsohn Ʒ ռ

VOID CAtumApplication::IMSocketPartyAcceptInviteOk(MSG_IC_PARTY_ACCEPT_INVITE_OK* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyAcceptInviteOk(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyPutMember(MSG_IC_PARTY_PUT_MEMBER* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _SHOP		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyPutMember(pMsg);
	}

}

VOID CAtumApplication::IMSocketPartyLeaveOk(MSG_IC_PARTY_LEAVE_OK* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _SHOP		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyLeaveOk(pMsg);
	}

// 2008-12-09 by dgwoo ̼Ǹ.
	if(NULL == g_pGameMain)
	{
		return;
	}
	CINFCommuPartyCre*	pPartyCre = g_pGameMain->m_pCommunity->GetPartyCreate();
	if(pPartyCre == NULL)
		return;
	if(pPartyCre->IsMissionMaster())
	{
		MSG_FC_QUEST_MISSIONMASTER_HELP_INVITE sMsg;
		sMsg.CharacterUID = pPartyCre->GetMissionMasterUID();
		g_pFieldWinSocket->SendMsg(T_FC_QUEST_MISSIONMASTER_HELP_INVITE,(char*)&sMsg,sizeof(sMsg));
	}
	pPartyCre->SetMissionMaster(FALSE);
// end 2008-12-09 by dgwoo ̼Ǹ.

}

VOID CAtumApplication::IMSocketPartyBanMemberOk(MSG_IC_PARTY_BAN_MEMBER_OK* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyBanMemberOk(pMsg);
	}

}

VOID CAtumApplication::IMSocketPartyDismemberOk(MSG_IC_PARTY_DISMEMBER_OK* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyDismemberOk(pMsg);
	}	
// 2008-12-09 by dgwoo ̼Ǹ.
	if(NULL == g_pGameMain)
	{
		return;
	}
	CINFCommuPartyCre*	pPartyCre = g_pGameMain->m_pCommunity->GetPartyCreate();
	if(pPartyCre == NULL)
		return;
	if(pPartyCre->IsMissionMaster())
	{
		MSG_FC_QUEST_MISSIONMASTER_HELP_INVITE sMsg;
		sMsg.CharacterUID = pPartyCre->GetMissionMasterUID();
		g_pFieldWinSocket->SendMsg(T_FC_QUEST_MISSIONMASTER_HELP_INVITE,(char*)&sMsg,sizeof(sMsg));
	}
	pPartyCre->SetMissionMaster(FALSE);
// end 2008-12-09 by dgwoo ̼Ǹ.
}
VOID CAtumApplication::IMSocketPartyTransferMasterOk(MSG_IC_PARTY_TRANSFER_MASTER_OK* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyTransferMasterOk(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyPutAllMember(MSG_IC_PARTY_PUT_ALL_MEMBER* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyPutAllMember(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyChangeFlightFormationOk(MSG_IC_PARTY_CHANGE_FLIGHT_FORMATION_OK* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyChangeFlightFormationOk(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyGetFlightPosition(MSG_IC_PARTY_GET_FLIGHT_POSITION* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyGetFlightPosition(pMsg);
	} 
}

VOID CAtumApplication::IMSocketPartyChangeFlightPosition(MSG_IC_PARTY_CHANGE_FLIGHT_POSITION* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyChangeFlightPosition(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyCancelFlightPosition(MSG_IC_PARTY_CANCEL_FLIGHT_POSITION* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyCancelFlightPosition(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyAllFlightPosition(MSG_IC_PARTY_ALL_FLIGHT_POSITION* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyAllFlightPosition(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyPutLastPartyInfo(MSG_IC_PARTY_PUT_LAST_PARTY_INFO* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyPutLastPartyInfo(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyUpdateMemberInfoMapName(MSG_IC_PARTY_UPDATE_MEMBER_INFO_MAPNAME* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyUpdateMemberInfoMapname(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyMemberInvalidated(MSG_IC_PARTY_MEMBER_INVALIDATED* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyMemberInvalidated(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyMemberRejoined(MSG_IC_PARTY_MEMBER_REJOINED* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyMemberRejoined(pMsg);
	}
}

VOID CAtumApplication::IMSocketPartyUpdateItemPos(MSG_IC_PARTY_UPDATE_ITEM_POS* pMsg)
{
	if((m_dwGameState == _GAME		||
		m_dwGameState == _CITY		||
		m_dwGameState == _MAPLOAD	||
		m_dwGameState == _SHOP		||
		m_dwGameState == _SELECTCHANNEL ) &&
		g_pShuttleChild)
	{
		g_pShuttleChild->m_pClientParty->IPartyUpdateItemPos(pMsg);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildCreateOk(MSG_IC_GUILD_CREATE_OK* pMsg)
/// \brief		  
/// \author		dhkwon
/// \date		2004-05-19 ~ 2004-05-19
/// \warning	Releaseÿ MSG_IC_GUILD_CREATE_OK  MSG_IC_GUILD_GET_GUILD_INFO_OK ٴ 
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildCreateOk(MSG_IC_GUILD_CREATE_OK* pMsg)
{
	char buf[256];
	wsprintf( buf, STRMSG_C_GUILD_0002, pMsg->GuildName );
	m_pChat->CreateChatChild( buf, COLOR_CHAT_GUILD );
	g_pGameMain->m_pCommunity->GetGuild()->IMSocketSendGetGuildInfo(pMsg->GuildUniqueNumber);
	DBGOUT("Guild [%s] Create Done.\n", pMsg->GuildName);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildGetGuildInfoOk(MSG_IC_GUILD_GET_GUILD_INFO_OK* pMsg)
/// \brief		   Ʈ 
/// \author		dhkwon
/// \date		2004-05-20 ~ 2004-05-20
/// \warning	ӽ۽ô  Ϲ ,
///				׿(â,尡)ÿ Ŭ̾Ʈ MSG_IC_GUILD_GET_GUILD_INFO ûѴ.
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildGetGuildInfoOk(MSG_IC_GUILD_GET_GUILD_INFO_OK* pMsg)
{
#ifdef _DEBUG
	if(g_pGameMain)
	{
		g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo(pMsg, TRUE);
	}
	else
	{
		NetworkErrorMsgBox(STRMSG_C_SERVER_0016);//"  GAMESTART_OK  Ͽϴ."
		return; // 2005-03-25 by jschoi
	}
#else
	g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo(pMsg, TRUE);
#endif
	char *p = (char *)pMsg;
	p += sizeof(MSG_IC_GUILD_GET_GUILD_INFO_OK);
	DBGOUT("---------------Guild List Receive---------------\n");
	for(int i = 0; i < pMsg->NumOfGuildMemberInfo; i++)
	{
		DBGOUT("	[%s][%d]\n",((MEX_GUILD_MEMBER_INFO*)p)->MemberName, ((MEX_GUILD_MEMBER_INFO*)p)->IsOnline);
		g_pGameMain->m_pCommunity->GetGuild()->AddGuildMember((MEX_GUILD_MEMBER_INFO*)p);
		p += sizeof(MEX_GUILD_MEMBER_INFO);
	}
	DBGOUT("------------------------------------------------\n");
	if(pMsg->GuildUniqueNumber != 0 )
	{
		m_pDatabase->CheckGuildMarkVersion( pMsg->GuildUniqueNumber, pMsg->GuildMarkVersion );
	}
	if(pMsg->GuildState == GUILD_STATE_DISMEMBER_READY)
	{
		//  ػ ñ û
		MSG_IC_GUILD_GET_DISMEMBER_DATE sMsg;
		sMsg.GuildUniqueNumber = pMsg->GuildUniqueNumber;
		m_pIMSocket->SendMsg( T_IC_GUILD_GET_DISMEMBER_DATE, (char*)&sMsg, sizeof(sMsg));
	}
	g_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber = pMsg->GuildUniqueNumber;
	strcpy( g_pShuttleChild->m_myShuttleInfo.GuildName, pMsg->GuildName );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildRequestInviteQuestion(MSG_IC_GUILD_REQUEST_INVITE_QUESTION* pMsg)
/// \brief		  
/// \author		dhkwon
/// \date		2004-05-19 ~ 2004-05-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildRequestInviteQuestion(MSG_IC_GUILD_REQUEST_INVITE_QUESTION* pMsg)
{
	// 2008-06-20 by bhsohn EP3 ɼǰ ó
	if(!g_pD3dApp->IsOptionEtc(OPTION_RADIO_GUILD_INVITE))		
	{
		//  
		MSG_IC_GUILD_REJECT_INVITE sMsg;
		memset(&sMsg, 0x00, sizeof(MSG_IC_GUILD_REJECT_INVITE));
		sMsg.GuildUniqueNumber = pMsg->GuildUniqueNumber;
		g_pIMSocket->SendMsg( T_IC_GUILD_REJECT_INVITE, (char*)&sMsg, sizeof(sMsg));
		return;
	}	
	// end 2008-06-20 by bhsohn EP3 ɼǰ ó

	char buf[256];
	wsprintf( buf, STRMSG_C_GUILD_0007, pMsg->GuildCommanderCharacterName, pMsg->GuildName );
	g_pGameMain->m_pInfWindow->AddMsgBox( buf, _Q_GUILD_INVITE_QUESTION, (DWORD)pMsg->GuildUniqueNumber );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildAcceptInviteOk(MSG_IC_GUILD_ACCEPT_INVITE_OK* pMsg)
/// \brief		  뺸
/// \author		dhkwon
/// \date		2004-05-19 ~ 2004-05-19
/// \warning	 Ե    ûؾ Ѵ.
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildAcceptInviteOk(MSG_IC_GUILD_ACCEPT_INVITE_OK* pMsg)
{
	char buf[256];
	wsprintf( buf, STRMSG_C_GUILD_0008, pMsg->MemberInfo.MemberName );
	m_pChat->CreateChatChild( buf, COLOR_CHAT_GUILD );
	if(pMsg->MemberInfo.MemberUniqueNumber != m_pShuttleChild->m_myShuttleInfo.CharacterUniqueNumber)
	{
		g_pGameMain->m_pCommunity->GetGuild()->AddGuildMember(&pMsg->MemberInfo);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildRejectInviteOk(MSG_IC_GUILD_REJECT_INVITE_OK* pMsg)
/// \brief		   뺸(忡Ը )
/// \author		dhkwon
/// \date		2004-05-19 ~ 2004-05-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildRejectInviteOk(MSG_IC_GUILD_REJECT_INVITE_OK* pMsg)
{
	char buf[256];
	wsprintf( buf, STRMSG_C_GUILD_0009, pMsg->CharacterName );
	m_pChat->CreateChatChild( buf, COLOR_CHAT_GUILD );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildBanMemberOk(MSG_IC_GUILD_BAN_MEMBER_OK* pMsg)
/// \brief		 ߹ .(  )
/// \author		dhkwon
/// \date		2004-05-20 ~ 2004-05-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildBanMemberOk(MSG_IC_GUILD_BAN_MEMBER_OK* pMsg)
{
	// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
	//MEX_GUILD_MEMBER_INFO* pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildMemberInfo(pMsg->MemberUniqueNumber);
	structGuildInfo* pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildMemberInfo(pMsg->MemberUniqueNumber);

	char buf[256];
	if(pMsg->MemberUniqueNumber != m_pShuttleChild->m_myShuttleInfo.CharacterUniqueNumber)
	{
		wsprintf( buf, STRMSG_C_GUILD_0010, pInfo->MemberName );
	}
	else
	{
		wsprintf( buf, STRMSG_C_080716_0202);
	}
	m_pChat->CreateChatChild( buf, COLOR_CHAT_GUILD );
	if(pMsg->MemberUniqueNumber != m_pShuttleChild->m_myShuttleInfo.CharacterUniqueNumber)
	{
		g_pGameMain->m_pCommunity->GetGuild()->DeleteGuildMember(pMsg->MemberUniqueNumber);
	}
	else
	{
		g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo(NULL, TRUE);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildLeaveOk(MSG_IC_GUILD_LEAVE_OK* pMsg)
/// \brief		带 Ż .(  )
/// \author		dhkwon
/// \date		2004-05-20 ~ 2004-05-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildLeaveOk(MSG_IC_GUILD_LEAVE_OK* pMsg)
{
	// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
	//MEX_GUILD_MEMBER_INFO* pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildMemberInfo(pMsg->MemberUniqueNumber);
	structGuildInfo* pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildMemberInfo(pMsg->MemberUniqueNumber);

	char buf[256];
	wsprintf( buf, STRMSG_C_GUILD_0011, pInfo->MemberName );
	m_pChat->CreateChatChild( buf, COLOR_CHAT_GUILD );
	if(pMsg->MemberUniqueNumber != m_pShuttleChild->m_myShuttleInfo.CharacterUniqueNumber)
	{
		g_pGameMain->m_pCommunity->GetGuild()->DeleteGuildMember(pMsg->MemberUniqueNumber);
	}
	else
	{
		g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo(NULL, TRUE);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildDismemberOk(MSG_IC_GUILD_DISMEMBER_OK* pMsg)
/// \brief		 ü û
/// \author		dhkwon
/// \date		2004-05-21 ~ 2004-05-21
/// \warning	 ü · ٲ.
///				GuildInfo ü   ResetGuildInfo pInfo ϱ ̴.
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildDismemberOk(MSG_IC_GUILD_DISMEMBER_OK* pMsg)
{
	m_pChat->CreateChatChild( STRMSG_C_GUILD_0012, COLOR_CHAT_GUILD );
	MSG_IC_GUILD_GET_GUILD_INFO_OK *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
	if(pInfo)
	{
//		MSG_IC_GUILD_GET_GUILD_INFO_OK GuildInfo;
//		memcpy( &GuildInfo, pInfo, sizeof(MSG_IC_GUILD_GET_GUILD_INFO_OK));
//		GuildInfo.GuildState = GUILD_STATE_DISMEMBER_READY;
//		g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo( &GuildInfo, TRUE );
		g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo( NULL, TRUE );
		//  ػ ñ û
//		MSG_IC_GUILD_GET_DISMEMBER_DATE sMsg;
//		sMsg.GuildUniqueNumber = GuildInfo.GuildUniqueNumber;
//		m_pIMSocket->SendMsg( T_IC_GUILD_GET_DISMEMBER_DATE, (char*)&sMsg, sizeof(sMsg));
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildCancelDismemberOk(MSG_IC_GUILD_CANCEL_DISMEMBER_OK*) pMsg)
/// \brief		ü 
/// \author		dhkwon
/// \date		2004-05-22 ~ 2004-05-22
/// \warning	GuildInfo ü   ResetGuildInfo pInfo ϱ ̴.
///				
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildCancelDismemberOk(MSG_IC_GUILD_CANCEL_DISMEMBER_OK* pMsg)
{
	m_pChat->CreateChatChild( STRMSG_C_GUILD_0013, COLOR_CHAT_GUILD );
	MSG_IC_GUILD_GET_GUILD_INFO_OK *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
	if(pInfo)
	{
		MSG_IC_GUILD_GET_GUILD_INFO_OK GuildInfo;
		memcpy( &GuildInfo, pInfo, sizeof(MSG_IC_GUILD_GET_GUILD_INFO_OK));
		GuildInfo.GuildState = pMsg->GuildState;
		g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo( &GuildInfo, FALSE );
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildSetGuildMarkOk(MSG_IC_GUILD_SET_GUILD_MARK_OK* pMsg)
/// \brief		  ٲ
/// \author		dhkwon
/// \date		2004-05-22 ~ 2004-05-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildSetGuildMarkOk(MSG_IC_GUILD_SET_GUILD_MARK_OK* pMsg)
{
	m_pChat->CreateChatChild( STRMSG_C_GUILD_0019, COLOR_CHAT_GUILD );
	MSG_IC_GUILD_GET_GUILD_INFO_OK *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
	m_pDatabase->UpdateGuildMark(pInfo->GuildUniqueNumber, 
								pMsg->GuildMarkVersion,
								((char*)pMsg + sizeof(MSG_IC_GUILD_SET_GUILD_MARK_OK)), 
								pMsg->SizeOfGuildMark);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildGetGuildMarkOk(MSG_IC_GUILD_GET_GUILD_MARK_OK* pMsg)
/// \brief		 ũ  û, ֺ 帶ũ  쵵 
/// \author		dhkwon
/// \date		2004-05-22 ~ 2004-05-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildGetGuildMarkOk(MSG_IC_GUILD_GET_GUILD_MARK_OK* pMsg)
{
	m_pDatabase->UpdateGuildMark(pMsg->GuildUniqueNumber,
								pMsg->GuildMarkVersion,
								((char*)pMsg + sizeof(MSG_IC_GUILD_GET_GUILD_MARK_OK)), 
								pMsg->SizeOfGuildMark);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildSetRankOk(MSG_IC_GUILD_SET_RANK_OK* pMsg)
/// \brief		GuildRank 
/// \author		dhkwon
/// \date		2004-05-22 ~ 2004-05-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildSetRankOk(MSG_IC_GUILD_SET_RANK_OK* pMsg)
{
	// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
	//MEX_GUILD_MEMBER_INFO *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildMemberInfo(pMsg->MemberUniqueNumber);
	structGuildInfo *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildMemberInfo(pMsg->MemberUniqueNumber);
	
	if(pInfo)
	{
		//pInfo->GuildRank = pMsg->GuildRank;		
		g_pGameMain->m_pCommunity->GetGuild()->SetGuildDSetRank(pMsg->MemberUniqueNumber, pMsg->GuildRank);

		char buf[256];
		wsprintf( buf, STRMSG_C_GUILD_0020, pInfo->MemberName, GetGuildRankName(pInfo->GuildRank) );
		m_pChat->CreateChatChild( buf, COLOR_CHAT_GUILD );
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildGetDismemberDateOk(MSG_IC_GUILD_GET_DISMEMBER_DATE_OK* pMsg)
/// \brief		 ػ ñ
/// \author		dhkwon
/// \date		2004-05-22 ~ 2004-05-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildGetDismemberDateOk(MSG_IC_GUILD_GET_DISMEMBER_DATE_OK* pMsg)
{
	char buf[256];
	string date;
	date = pMsg->DismemberDateTime.GetLocalDateTimeString(string(),GetLanguageType());
	wsprintf(buf, STRMSG_C_GUILD_0016, date.c_str() );
	m_pChat->CreateChatChild( buf, COLOR_CHAT_GUILD );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildChangeGuildNameOk(MSG_IC_GUILD_CHANGE_GUILD_NAME_OK* pMsg)
/// \brief		 ̸ ٲ۴.
/// \author		dhkwon
/// \date		2004-05-22 ~ 2004-05-22
/// \warning	 Ŭ̾Ʈ  ȵ. Ŀ NPC  
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildChangeGuildNameOk(MSG_IC_GUILD_CHANGE_GUILD_NAME_OK* pMsg)
{
	char buf[256];
	wsprintf(buf, STRMSG_C_GUILD_0017, pMsg->NewGuildName );
	m_pChat->CreateChatChild( buf, COLOR_CHAT_GUILD );
	MSG_IC_GUILD_GET_GUILD_INFO_OK *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
	if(pInfo)
	{
		MSG_IC_GUILD_GET_GUILD_INFO_OK GuildInfo;
		memcpy( &GuildInfo, pInfo, sizeof(MSG_IC_GUILD_GET_GUILD_INFO_OK));
		strcpy(GuildInfo.GuildName, pMsg->NewGuildName );
		g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo( &GuildInfo,FALSE );
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildSetMemberState(MSG_IC_GUILD_SET_MEMBER_STATE* pMsg)
/// \brief		 ¶/  ȭ
/// \author		dhkwon
/// \date		2004-05-21 ~ 2004-05-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildSetMemberState(MSG_IC_GUILD_SET_MEMBER_STATE* pMsg)
{
	ASSERT_IMPLIES(g_pGameMain, g_pGameMain->m_pCommunity);
	CINFCommunityGuild* pGuild = g_pGameMain->m_pCommunity->GetGuild();

	// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
	//MEX_GUILD_MEMBER_INFO* pInfo = pGuild->GetGuildMemberInfo(pMsg->MemberUniqueNumber);
	structGuildInfo *pInfo = pGuild->GetGuildMemberInfo(pMsg->MemberUniqueNumber);
		
	if(pInfo)
	{		
		//pInfo->IsOnline = pMsg->GuildMemberState;
		g_pGameMain->m_pCommunity->GetGuild()->SetGuildOnOffInfo(pMsg->MemberUniqueNumber, pMsg->GuildMemberState);

		if( pInfo->IsOnline == TRUE &&
			pGuild->GetNtoNCallState() == TRUE &&
			pGuild->GetMyGuildRank() == GUILD_RANK_COMMANDER)
		{
			pGuild->IMSocketSendVoipNtoNInviteUser( pMsg->MemberUniqueNumber );
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildChangeGuildState(MSG_IC_GUILD_CHANGE_GUILD_STATE* pMsg)
/// \brief		 ü ,  
/// \author		dhkwon
/// \date		2004-05-22 ~ 2004-05-22
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildChangeGuildState(MSG_IC_GUILD_CHANGE_GUILD_STATE* pMsg)
{
	if(pMsg->GuildState == GUILD_STATE_DISMEMBER_READY)
	{
		m_pChat->CreateChatChild( STRMSG_C_GUILD_0015, COLOR_CHAT_GUILD );
		DBGOUT("GUILD_STATE_DISMEMBER_READY.\n");
		MSG_IC_GUILD_GET_GUILD_INFO_OK *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
		if(pInfo)
		{
			MSG_IC_GUILD_GET_GUILD_INFO_OK GuildInfo;
			memcpy( &GuildInfo, pInfo, sizeof(MSG_IC_GUILD_GET_GUILD_INFO_OK));
			GuildInfo.GuildState = GUILD_STATE_DISMEMBER_READY;
			g_pGameMain->m_pCommunity->GetGuild()->ResetGuildInfo( &GuildInfo, FALSE );
			//  ػ ñ û
			MSG_IC_GUILD_GET_DISMEMBER_DATE sMsg;
			sMsg.GuildUniqueNumber = GuildInfo.GuildUniqueNumber;
			m_pIMSocket->SendMsg( T_IC_GUILD_GET_DISMEMBER_DATE, (char*)&sMsg, sizeof(sMsg));
		}
	}
#ifdef _DEBUG
	else
	{
		DBGOUT("GUILD_STATE_NORMAL\n");
	}
#endif
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildLoadingGuildDone(MSG_IC_GUILD_LOADING_GUILD_DONE* pMsg)
/// \brief		  û غ (IM)
/// \author		dhkwon
/// \date		2004-05-31 ~ 2004-05-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildLoadingGuildDone(MSG_IC_GUILD_LOADING_GUILD_DONE* pMsg)
{
	m_bReadyToGetGuildInfo = TRUE;
	if( m_dwGameState == _GAME || 
		m_dwGameState == _CITY || 
		m_dwGameState == _SHOP || 
		(m_bReadyFieldGameStartOk))// 2007-01-07 by bhsohn   ȭ   ó
	{
		MSG_IC_GUILD_GET_GUILD_INFO sMsg;
		sMsg.GuildUniqueNumber = m_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber;
		m_pIMSocket->SendMsg( T_IC_GUILD_GET_GUILD_INFO, (char*)&sMsg, sizeof(sMsg));
	}
#ifdef _DEBUG
	else
	{
		DBGOUT("ERROR : m_dwGameState != _GAME,_CITY,_SHOP, MSG_IC_GUILD_GET_GUILD_INFO\n");
	}
#endif
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketGuildGetOtherGuildInfoOk(MSG_IC_GUILD_GET_OTHER_GUILD_INFO_OK* pMsg)
/// \brief		ٸ ĳ  
/// \author		dhkwon
/// \date		2004-06-01 ~ 2004-06-01
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildGetOtherGuildInfoOk(MSG_IC_GUILD_GET_OTHER_GUILD_INFO_OK* pMsg)
{
	m_pDatabase->UpdateOtherGuildInfo( &pMsg->OtherGuildMemberInfo );
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketAdminGetServerStatOk(MSG_IC_ADMIN_GET_SERVER_STAT_OK* pMsg)
/// \brief		 (ä)  
/// \author		dhkwon
/// \date		2004-05-13 ~ 2004-05-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketAdminGetServerStatOk(MSG_IC_ADMIN_GET_SERVER_STAT_OK* pMsg)
{
	wsprintf(m_strSeverUserNum, "ALL USER [ %d ]", pMsg->TotalUserCount);
}
VOID CAtumApplication::IMSocketConnectClose(MSG_IC_CONNECT_CLOSE* pMsg)
{
	FLOG("CAtumApplication::IMSocketConnectClose(MSG_IC_CONNECT_CLOSE* pMsg)");
	char message[256];
	wsprintf(message,STRMSG_C_SERVER_0017,pMsg->reason);//"ä  Ǿϴ.  ˴ϴ. [%d] T_IC_CONNECT_CLOSE  "
	NetworkErrorMsgBox(message);
}

VOID CAtumApplication::IMSocketString128(MSG_IC_STRING_128* pMsg)
{
	FLOG("CAtumApplication::IMSocketString128(MSG_IC_STRING_128* pMsg)");
/*	
	if(pMsg->PrintType == STR128_PRINT_TYPE_CHAT)
	{// ä â 
		if(m_pChat)
			m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
	}
	else if(pMsg->PrintType == STR128_PRINT_TYPE_STATIC)
	{//  ؽƮ 
		memset(m_strDebug,0x00,sizeof(m_strDebug));
		memcpy(m_strDebug,pMsg->String,strlen(pMsg->String));
	}
*/
	m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
	m_pChat->SetNumIme(pMsg->SecurityNumber);			// 2011-11-01 by jhahn ȣȭ ó

//2011-06-30 by jhahn  缳 н	
#ifdef C_SECURITY_COMMAND_JHAHN
	char buf[256];
	wsprintf(buf, "IMSocket128 %0d", pMsg->SecurityNumber);
	m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
#endif	
//end 2011-06-30 by jhahn  缳 н
}
VOID CAtumApplication::IMSocketString256(MSG_IC_STRING_256* pMsg)
{
	FLOG("CAtumApplication::IMSocketString128(MSG_IC_STRING_128* pMsg)");
/*	
	if(pMsg->PrintType == STR128_PRINT_TYPE_CHAT)
	{// ä â 
		if(m_pChat)
			m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
	}
	else if(pMsg->PrintType == STR128_PRINT_TYPE_STATIC)
	{//  ؽƮ 
		memset(m_strDebug,0x00,sizeof(m_strDebug));
		memcpy(m_strDebug,pMsg->String,strlen(pMsg->String));
	}
*/
	m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
	m_pChat->SetNumIme(pMsg->SecurityNumber);						// 2011-11-01 by jhahn ȣȭ ó
//2011-06-30 by jhahn  缳 н
#ifdef C_SECURITY_COMMAND_JHAHN
	char buf[256];
	wsprintf(buf, "IMSocket256 %0d", pMsg->SecurityNumber);
	m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
#endif	
//end 2011-06-30 by jhahn  缳 н
}
VOID CAtumApplication::IMSocketString512(MSG_IC_STRING_512* pMsg)
{
	FLOG("CAtumApplication::IMSocketString128(MSG_IC_STRING_128* pMsg)");
/*	
	if(pMsg->PrintType == STR128_PRINT_TYPE_CHAT)
	{// ä â 
		if(m_pChat)
			m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
	}
	else if(pMsg->PrintType == STR128_PRINT_TYPE_STATIC)
	{//  ؽƮ 
		memset(m_strDebug,0x00,sizeof(m_strDebug));
		memcpy(m_strDebug,pMsg->String,strlen(pMsg->String));
	}
*/
	m_pChat->CreateChatChild(pMsg->String,COLOR_SYSTEM);
		m_pChat->SetNumIme(pMsg->SecurityNumber);						// 2011-11-01 by jhahn ȣȭ ó
//2011-06-30 by jhahn  缳 н
#ifdef C_SECURITY_COMMAND_JHAHN
	char buf[256];
	wsprintf(buf, "IMSocket512 %0d", pMsg->SecurityNumber);
	m_pChat->CreateChatChild(buf,COLOR_SYSTEM);
#endif	
//end 2011-06-30 by jhahn  缳 н
}

VOID CAtumApplication::IMSocketError(MSG_ERROR* pMsg)
{
	FLOG("CAtumApplication::IMSocketError(MSG_ERROR* pMsg)");
	//  ó ڵ
	char errMsg[1024];
	memset(errMsg, 0x00, sizeof(errMsg));
	wsprintf(errMsg, "ERROR, ISocket, ErrCode : [%s]%#04x, ErrParam1:%d, ErrParam2:%d\n",
		GetErrorString(pMsg->ErrorCode), pMsg->ErrorCode, pMsg->ErrParam1, pMsg->ErrParam2);
	if(pMsg->StringLength>0)
	{
		memcpy(errMsg+strlen(errMsg), (char*)pMsg + sizeof(MSG_ERROR), pMsg->StringLength);
	}
	DBGOUT(errMsg);

	// 2007-12-21 by bhsohn α׷    
	//   üũ 
	CheckMultiLock(FALSE, pMsg->MsgType);

	// 2005-03-18 by jschoi
	// 1.   
	char errStr[512];
#ifndef _DEBUG
	if(m_pShuttleChild && COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
#endif
	{
		wsprintf(errStr,"ERR:(%s),(%s)",GetProtocolTypeString(pMsg->MsgType),GetErrorString(pMsg->ErrorCode));
		m_pChat->CreateChatChild(errStr,COLOR_SYSTEM);
	}

	// 2. ErrorCode  ()ó
	if(IMSocketErrorByErrorCode(pMsg))
	{
		if(pMsg->CloseConnection)
		{
			g_pIMSocket->CloseSocket();

			char message[256];
				wsprintf(message,STRMSG_C_SERVER_0020,pMsg->ErrorCode);//"  Ǿϴ.  ˴ϴ. [0x%x] case T_ERROR:(IM)  "

			/*
			if(COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
			{
				wsprintf(message,STRMSG_C_SERVER_0020,pMsg->ErrorCode);//"  Ǿϴ.  ˴ϴ. [0x%x] case T_ERROR:(IM)  "
			}
			else
			{
				wsprintf(message,STRMSG_C_060608_0000,pMsg->ErrorCode);//"  Ǿϴ.  ˴ϴ."
			}
			*/
			NetworkErrorMsgBox(message);
		}
		return;
	}

	// 3. ޽ ŸԺ ()ó
	IMSocketErrorByMsgType(pMsg);

	if(pMsg->CloseConnection)
	{
		if(pMsg->CloseConnection)
		{
			g_pIMSocket->CloseSocket();

			char message[256];
				wsprintf(message,STRMSG_C_SERVER_0020,pMsg->ErrorCode);//"  Ǿϴ.  ˴ϴ. [0x%x] case T_ERROR:(IM)  "

			/*
			if(COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
			{
				wsprintf(message,STRMSG_C_SERVER_0020,pMsg->ErrorCode);//"  Ǿϴ.  ˴ϴ. [0x%x] case T_ERROR:(IM)  "
			}
			else
			{
				wsprintf(message,STRMSG_C_060608_0000,pMsg->ErrorCode);//"  Ǿϴ.  ˴ϴ."
			}
			*/
			NetworkErrorMsgBox(message);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			IMSocketGuildWarReady(MSG_IC_GUILD_WAR_READY* pMsg)
/// \brief		MSG_IC_GUILD_WAR_READY
/// \author		dhkwon
/// \date		2004-07-27 ~ 2004-07-27
/// \warning	pMsg->WaitingTime  Ŀ  
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildWarReady(MSG_IC_GUILD_WAR_READY* pMsg)
{
	// ydkim 2004.10.20
	//char message[256];
	//wsprintf( message, "%dĿ  ۵˴ϴ.", pMsg->WaitingTime);
	////m_fBattleCountCheckTime = (float)pMsg->WaitingTime;
	//m_pChat->CreateChatChild(message, COLOR_SYSTEM);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			IMSocketCountdownStart(MSG_IC_COUNTDOWN_START* pMsg)
/// \brief		 īƮ 
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketCountdownStart(MSG_IC_COUNTDOWN_START* pMsg)
{
	g_pGameMain->m_pGameCountDown->SetCountDown(pMsg->byCountdownType, pMsg->nWaitingSecond, COLOR_VOIP);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			IMSocketItemUseCarditemGuildChangeMemberCapacity(MSG_IC_GUILD_CHANGE_MEMBER_CAPACITY* pMsg)
/// \brief		  (ī )
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketItemUseCarditemGuildChangeMemberCapacity(MSG_IC_GUILD_CHANGE_MEMBER_CAPACITY* pMsg)
{	
	if(g_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber == pMsg->guildUID)
	{
		g_pGameMain->m_pCommunity->GetGuild()->SetMaxGuildMember(pMsg->nMemberCapacity);
		// 2008-06-18 by bhsohn ܿ ī  ó
		char ErrorMsgMissionList[256];
		wsprintf(ErrorMsgMissionList, STRMSG_C_080619_0202, pMsg->IncreaseCapacity, pMsg->nMemberCapacity);
		m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_SYSTEM); //"\\y ִ ο %d  Ͽϴ.   ִ  ο %dԴϴ."
		// end 2008-06-18 by bhsohn ܿ ī  ó
	}	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			IMSocketGuildStartWar(MSG_IC_GUILD_START_WAR* pMsg)
/// \brief		MSG_IC_GUILD_START_WAR
/// \author		dhkwon
/// \date		2004-07-27 ~ 2004-07-27
/// \warning	Ŭ̾Ʈ T_FC_GUILD_GET_WAR_INFO_OK  Ŀ ¥ ̴.
///				
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildStartWar(MSG_IC_GUILD_START_WAR* pMsg)
{
	m_pChat->CreateChatChild(STRMSG_C_GUILD_0039, COLOR_SYSTEM);//" ۵Ǿϴ."
	MSG_FC_GUILD_GET_WAR_INFO sMsg;
	sMsg.GuildUID = g_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber;
	m_pFieldWinSocket->SendMsg( T_FC_GUILD_GET_WAR_INFO, (char*)&sMsg, sizeof(sMsg) );
	//g_pShuttleChild->m_bPKMode = TRUE;
	g_pShuttleChild->SetPkState( PK_GVG, TRUE );
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			IMSocketGuildEndWar(MSG_IC_GUILD_END_WAR* pMsg)
/// \brief		MSG_IC_GUILD_END_WAR
/// \author		dhkwon
/// \date		2004-07-27 ~ 2004-07-27
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildEndWar(MSG_IC_GUILD_END_WAR* pMsg)
{
	MSG_IC_GUILD_GET_GUILD_INFO_OK* pGuild = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
	if( pGuild)
	{
		char message[256];
		memset(message, 0x00, sizeof(message) );
		switch(pMsg->WarEndType)
		{
		case BATTLE_END_WIN:
			{// ¸
				wsprintf(message,STRMSG_C_GUILD_0040, pMsg->PeerGuildName);//"%s ܰ ￡ ¸Ͽϴ."
				MSG_IC_GUILD_GET_GUILD_INFO_OK *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
				if(pInfo)
				{
					pInfo->WarWinPoint++;
				}
			}
			break;
		case BATTLE_END_DEFEAT:
			{// й
				wsprintf(message,STRMSG_C_GUILD_0041, pMsg->PeerGuildName);//"%s ܰ ￡ йϿϴ."
				MSG_IC_GUILD_GET_GUILD_INFO_OK *pInfo = g_pGameMain->m_pCommunity->GetGuild()->GetGuildInfo();
				if(pInfo)
				{
					pInfo->WarLossPoint++;
				}
			}
			break;
		case BATTLE_END_TIE:
			{// º
				wsprintf(message,STRMSG_C_GUILD_0042, pMsg->PeerGuildName);//"%s ܰ ￡ ºθ  Ͽϴ."
			}
			break;
		case BATTLE_END_END:
			{// ׳ Ǿϴ(ҹ)
				wsprintf(message,STRMSG_C_GUILD_0043, pMsg->PeerGuildName);//"%s ܰ  Ǿϴ."
			}
			break;
		default:
			{
				DBGOUT("ERROR:MSG_IC_GUILD_END_WAR(%d)\n", pMsg->WarEndType);
			}
			break;
		}
		m_pChat->CreateChatChild(message, COLOR_SYSTEM);
	}
	if(g_pShuttleChild->m_pGuildWarInfo)
	{
		m_pScene->SetPKSettingGuildWar( g_pShuttleChild->m_pGuildWarInfo->PeerGuildUID, FALSE );
		SAFE_DELETE(g_pShuttleChild->m_pGuildWarInfo);
	}
	//g_pShuttleChild->m_bPKMode = FALSE;
	g_pShuttleChild->SetPkState( PK_GVG, FALSE );
}

VOID CAtumApplication::IMSocketInvalidPacket(char* pPacket)
{
	FLOG("CAtumApplication::IMSocketInvalidPacket(char* pPacket)");
	char * p = pPacket;
	MessageType_t	nType = 0;
	memcpy(&nType,p,sizeof(MessageType_t));
	char message[256];
	g_pIMSocket->CloseSocket();
#ifdef _DEBUG
	wsprintf(message,STRMSG_C_SERVER_0013,nType,GetProtocolTypeString(nType));//"  ޼ Ÿ Ŭ̾Ʈ  TYPE[%#04x] : %s"
#else
	wsprintf(message,STRMSG_C_SERVER_0013,nType,"IUnknown");//"  ޼ Ÿ Ŭ̾Ʈ "
#endif
	
	// 2007-07-10 by bhsohn  Ÿ   ó
	char chTmp[128];
	wsprintf(chTmp, "PreType[%04x]:%s", m_nPreIMComType, GetProtocolTypeString(m_nPreIMComType));
	if((strlen(message)+strlen(chTmp)) < 256)
	{
		strcat(message, chTmp);
	}
	// end 2007-07-10 by bhsohn  Ÿ   ó

	NetworkErrorMsgBox(message);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketVoipGetAccountUniquenumberOk(MSG_IC_VOIP_GET_ACCOUNTUNIQUENUMBER_OK* pMsg)
/// \brief		   ũ ѹ û , VOIP.exe REGISTER Ѵ.(AV_MT_REGISTER)
/// \author		dhkwon
/// \date		2004-07-03 ~ 2004-07-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::IMSocketVoipGetAccountUniquenumberOk(MSG_IC_VOIP_GET_ACCOUNTUNIQUENUMBER_OK* pMsg)
{
	m_VOIPState.nCalledAccountUniqueNumber = pMsg->nCalledAccountUniqueNumber;
	MSG_MT_REGISTER sMsg;
	sMsg.nAccountUniqueNumber = g_pShuttleChild->m_myShuttleInfo.AccountUniqueNumber;
	strncpy( sMsg.szCharacterName, g_pShuttleChild->m_myShuttleInfo.CharacterName, SIZE_MAX_CHARACTER_NAME );
	COPYDATASTRUCT	copyData;
	memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
	AV_MSG_WM_COPYDATA voIP(_1to1Call, AV_MT_REGISTER, 0);
	copyData.dwData = (DWORD)voIP;
	copyData.lpData = &sMsg;
	copyData.cbData = sizeof(sMsg);
	::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&copyData);
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketVoip1to1Dial(MSG_IC_VOIP_1to1_DIAL* pMsg)
/// \brief		ȭ û , REGISTER Ŀ ȭ  θ .
/// \author		dhkwon
/// \date		2004-07-03 ~ 2004-07-03
/// \warning	MSG_IC_VOIP_1to1_DIAL ȭ û  Ŭ̾Ʈ Ѵ.
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::IMSocketVoip1to1Dial(MSG_IC_VOIP_1to1_DIAL* pMsg)
{
	if( m_VOIPState.nVOIPState == _VOIP_NOTLOGIN )
	{
		MSG_MT_REGISTER sMsg;
		sMsg.nAccountUniqueNumber = g_pShuttleChild->m_myShuttleInfo.AccountUniqueNumber;
		strncpy( sMsg.szCharacterName, g_pShuttleChild->m_myShuttleInfo.CharacterName, SIZE_MAX_CHARACTER_NAME );
		COPYDATASTRUCT	copyData;
		memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
		AV_MSG_WM_COPYDATA voIP(_1to1Call, AV_MT_REGISTER, 0);
		copyData.dwData = (DWORD)voIP;
//		copyData.dwData = MAKELONG(AV_MT_REGISTER, 0);
		copyData.lpData = &sMsg;
		copyData.cbData = sizeof(sMsg);
		strncpy( m_VOIPState.szName, pMsg->szCallerCharacterName, SIZE_MAX_CHARACTER_NAME );
		::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&copyData);
		m_VOIPState.bCaller = FALSE;
		m_VOIPState.nVOIPState = _VOIP_TRY_REGISTER;
		m_VOIPState.nCalledAccountUniqueNumber = pMsg->nCallerAccountUniqueNumber;
	}
	else
	{
		MSG_IC_VOIP_ERROR sMsg;
		sMsg.nErrorNum = VOIPERR_1to1_CANNOT_CALL;
		sMsg.nSend2AccountUniqueNumber = pMsg->nCallerAccountUniqueNumber;
		g_pIMSocket->SendMsg( T_IC_VOIP_ERROR, (char*)&sMsg, sizeof(sMsg) );
	}

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketVoip1to1DialOk(MSG_IC_VOIP_1to1_DIAL_OK* pMsg)
/// \brief		
/// \author		dhkwon
/// \date		2004-07-03 ~ 2004-07-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::IMSocketVoip1to1DialOk(MSG_IC_VOIP_1to1_DIAL_OK* pMsg)
{
	// ȭ 
	m_VOIPState.nVOIPState = _VOIP_DIALINGSTATE;
	MSG_MT_DIAL		msgMTDial;
	msgMTDial.nCalleeAccountUniqueNumber = pMsg->nCalledAccountUniqueNumber;
	g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_ONE);
	COPYDATASTRUCT	copyData;
	memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
	AV_MSG_WM_COPYDATA voIP(_1to1Call, AV_MT_DIAL, 0);
	copyData.dwData = (DWORD)voIP;
	copyData.lpData = &msgMTDial;
	copyData.cbData = sizeof(MSG_MT_DIAL);
	::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&copyData);


}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketVoip1to1End(MSG_IC_VOIP_1to1_END* pMsg)
/// \brief		ȭ 
/// \author		dhkwon
/// \date		2004-07-06 ~ 2004-07-06
/// \warning	   UNREGISTERȣ
///				ȭ ư MSG_IC_VOIP_END ȣ
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::IMSocketVoip1to1End(MSG_IC_VOIP_1to1_END* pMsg)
{
	// 2008-07-14 by dgwoo ȭ Ÿټ.
	g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_NONE);
	COPYDATASTRUCT	copyData;
	memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
	AV_MSG_WM_COPYDATA voIP(_BothCall, AV_MT_UNREGISTER, 0);
	copyData.dwData = (DWORD)voIP;
	copyData.lpData = NULL;
	copyData.cbData = 0;
	::SendMessage( m_VOIPState.m_hWndAtumVoIPClient,
					WM_COPYDATA, (WPARAM)GetHwnd(),
					(LPARAM)&copyData);
	m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
	m_VOIPState.bCaller = FALSE;
	DBGOUT("IMSocketVoip1to1End by other \n");
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketVoipNtoNCreateRoomRequestOk(MSG_IC_VOIP_NtoN_CREATEROOM_REQUEST_OK* pMsg)
/// \brief		T_IC_VOIP_NtoN_CREATEROOM_REQUEST_OK
/// \author		dhkwon
/// \date		2004-08-30 ~ 2004-08-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::IMSocketVoipNtoNCreateRoomRequestOk(MSG_IC_VOIP_NtoN_CREATEROOM_REQUEST_OK* pMsg)
{
	ASSERT_ASSERT(m_VOIPState.nVOIPState == _VOIP_TRY_REGISTER);
	if(pMsg->byIsPartyCall == TRUE) //  ȭ
	{
		COPYDATASTRUCT	copyData;
		MSG_MT_PARTY_CREATE_ROOM sMsg;
		sMsg.llPartyID = g_pShuttleChild->m_pClientParty->GetPartyInfo().PartyID;
		sMsg.nAccountUniqueNumber = g_pShuttleChild->m_myShuttleInfo.AccountUniqueNumber;
		// 2008-10-14 by bhsohn VOIP
		//sMsg.nConcurrentTalkingCount = g_pD3dApp->m_VOIPState.nConnectCount;
		sMsg.nConcurrentTalkingCount = SIZE_NORMAL_TALKING_USER_COUNT;

		strcpy( sMsg.szCharacterName, g_pShuttleChild->m_myShuttleInfo.CharacterName );

		memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
		AV_MSG_WM_COPYDATA voIP(_NtoNCall, AV_MT_PARTY_CREATE_ROOM, 0);
		copyData.dwData = (DWORD)voIP;
		copyData.lpData = &sMsg;
		copyData.cbData = sizeof(sMsg);
		::SendMessage( m_VOIPState.m_hWndAtumVoIPClient,
						WM_COPYDATA, (WPARAM)GetHwnd(),
						(LPARAM)&copyData);
		g_pShuttleChild->m_pClientParty->SetNtoNCallState(TRUE);
		m_VOIPState.nCallState = _CALLSTATE_PARTY;
	}
	else //  ȭ
	{
		COPYDATASTRUCT	copyData;
		MSG_MT_GUILD_CREATE_ROOM sMsg;
		sMsg.uiGuildUniqueNumber = g_pShuttleChild->m_myShuttleInfo.GuildUniqueNumber;
		sMsg.nAccountUniqueNumber = g_pShuttleChild->m_myShuttleInfo.AccountUniqueNumber;
		// 2008-10-14 by bhsohn VOIP
		//sMsg.nConcurrentTalkingCount = g_pD3dApp->m_VOIPState.nConnectCount;
		sMsg.nConcurrentTalkingCount = SIZE_NORMAL_TALKING_USER_COUNT;
		
		strcpy( sMsg.szCharacterName, g_pShuttleChild->m_myShuttleInfo.CharacterName );

		memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
		AV_MSG_WM_COPYDATA voIP(_NtoNCall, AV_MT_GUILD_CREATE_ROOM, 0);
		copyData.dwData = (DWORD)voIP;
		copyData.lpData = &sMsg;
		copyData.cbData = sizeof(sMsg);
		::SendMessage( m_VOIPState.m_hWndAtumVoIPClient,
						WM_COPYDATA, (WPARAM)GetHwnd(),
						(LPARAM)&copyData);
		g_pGameMain->m_pCommunity->GetGuild()->SetNtoNCallState(TRUE);
		//g_pShuttleChild->m_pClientParty->SetNtoNCallState(TRUE);
		m_VOIPState.nCallState = _CALLSTATE_GUILD;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketVoipNtoNInviteYou(MSG_IC_VOIP_NtoN_INVITE_YOU* pMsg)
/// \brief		T_IC_VOIP_NtoN_INVITE_YOU
/// \author		dhkwon
/// \date		2004-08-30 ~ 2004-08-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::IMSocketVoipNtoNInviteYou(MSG_IC_VOIP_NtoN_INVITE_YOU* pMsg)
{
	if( pMsg->byIsPartyCall == TRUE ) //  ȭ
	{
		if(m_VOIPState.nVOIPState == _VOIP_NOTLOGIN)
		{
			g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_VOIP_0003, _Q_JOIN_PARTY_VOIP);
		}
		else
		{
			m_pChat->CreateChatChild(STRERR_C_VOIP_0005,COLOR_VOIP);
		}
	}
	else //  ȭ
	{
		if(m_VOIPState.nVOIPState == _VOIP_NOTLOGIN)
		{
			g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_VOIP_0005, _Q_JOIN_GUILD_VOIP);
		}
		else
		{
			m_pChat->CreateChatChild(STRERR_C_VOIP_0006,COLOR_VOIP);
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketVoipNtoNGooutAll(MSG_IC_VOIP_NtoN_GOOUT_ALL* pMsg)
/// \brief		/忡  NtoN ȭ 
/// \author		dhkwon
/// \date		2004-10-05 ~ 2004-10-05
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::IMSocketVoipNtoNGooutAll(MSG_IC_VOIP_NtoN_GOOUT_ALL* pMsg)
{
	COPYDATASTRUCT	copyData;
	memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
	copyData.dwData = MAKELONG(AV_MT_UNREGISTER, 0);
	copyData.lpData = NULL;
	copyData.cbData = 0;
	::SendMessage( m_VOIPState.m_hWndAtumVoIPClient,
					WM_COPYDATA, (WPARAM)GetHwnd(),
					(LPARAM)&copyData);
	m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
	m_VOIPState.bCaller = FALSE;
	g_pShuttleChild->m_pClientParty->SetNtoNCallState(FALSE);
	g_pGameMain->m_pCommunity->GetGuild()->SetNtoNCallState(FALSE);

	if( pMsg->byIsPartyCall == TRUE ) //  ȭ
	{
		m_pChat->CreateChatChild(STRMSG_C_VOIP_0020,COLOR_VOIP);
	}
	else //  ȭ
	{
		m_pChat->CreateChatChild(STRMSG_C_VOIP_0019,COLOR_VOIP);
	}
}
VOID CAtumApplication::IMSocketVoIPSetOK(MSG_IC_VOIP_SET_OK* pMsg)
{
	if( pMsg->VoipType == CHECK_TYPE_VOIP_PARTY)
	{
		g_pShuttleChild->m_pClientParty->SetVoiceParty(pMsg->CharacterUID);
	}
	else if( pMsg->VoipType == CHECK_TYPE_VOIP_GUILD)
	{
		g_pGameMain->m_pCommunity->GetGuild()->SetVoiceGuild(pMsg->CharacterUID);
	}
	else if(pMsg->VoipType == CHECK_TYPE_VOIP_NONE)
	{
		g_pShuttleChild->m_pClientParty->NoneVoiceParty(pMsg->CharacterUID);
		g_pGameMain->m_pCommunity->GetGuild()->NoneVoiceGuild(pMsg->CharacterUID);
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketChatFriendlistAll(MSG_IC_CHAT_FRIENDLIST_LOADING_OK* pMsg)
/// \brief		ģƮ ޱ
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketChatFriendlistAll(MSG_IC_CHAT_FRIENDLIST_LOADING_OK* pMsg)
{
	Friend_t temp_friend;
	// 2008-10-24 by bhsohn ģ, ź Ʈ 49 Ǵ  ó
	//g_pGameMain->m_pCommunity->GetFriend()->ResetFriendList();	

	FRIENDINFO *pfriendinfo = (FRIENDINFO *)((char *)pMsg + sizeof(MSG_IC_CHAT_FRIENDLIST_LOADING_OK));
	for(int i=0; i<pMsg->nFriendListCounts; i++)
	{
		memset(&temp_friend, 0x00, sizeof(Friend_t));
		strncpy(temp_friend.szFriendName, pfriendinfo->szCharacterName, SIZE_MAX_CHARACTER_NAME);
		temp_friend.bOnline			= pfriendinfo->byIsOnline;
		// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
		//g_pGameMain->m_pCommunity->GetFriend()->m_vecFriend.push_back(temp_friend);
		g_pGameMain->m_pCommunity->GetFriend()->AddFriendList(temp_friend);
		pfriendinfo++;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketChatFriendlistInsertOk(MSG_IC_CHAT_FRIENDLIST_INSERT_OK* pMsg);
/// \brief		ģƮ  OK
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketChatFriendlistInsertOk(MSG_IC_CHAT_FRIENDLIST_INSERT_OK* pMsg)
{
	Friend_t temp_friend;
	memset(&temp_friend, 0x00, sizeof(Friend_t));

	strncpy(temp_friend.szFriendName, pMsg->szCharacterName, SIZE_MAX_CHARACTER_NAME);
	temp_friend.bOnline = pMsg->byIsOnline;
	// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
	//g_pGameMain->m_pCommunity->GetFriend()->m_vecFriend.push_back(temp_friend);
	g_pGameMain->m_pCommunity->GetFriend()->AddFriendList(temp_friend);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketChatRejectlistAll(MSG_IC_CHAT_REJECTLIST_LOADING_OK* pMsg);
/// \brief		ź Ʈ ޱ
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketChatRejectlistAll(MSG_IC_CHAT_REJECTLIST_LOADING_OK* pMsg)
{
	Reject_t temp_reject;
	
	// 2008-10-24 by bhsohn ģ, ź Ʈ 49 Ǵ  ó
	//g_pGameMain->m_pCommunity->GetReject()->InitRejectList();

	FRIENDINFO *prejectinfo = (FRIENDINFO *)((char *)pMsg + sizeof(MSG_IC_CHAT_REJECTLIST_LOADING_OK));
	for(int i=0; i<pMsg->nRejectListCounts; i++)
	{
		memset(&temp_reject, 0x00, sizeof(Reject_t));
		strncpy(temp_reject.szRejectName, prejectinfo->szCharacterName, SIZE_MAX_CHARACTER_NAME);
		// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
		temp_reject.atimeRegTime = prejectinfo->RegDate;
		//g_pGameMain->m_pCommunity->GetReject()->m_vecReject.push_back(temp_reject);
		g_pGameMain->m_pCommunity->GetReject()->AddRejectList(temp_reject);
		prejectinfo++;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketChatRejectlistInsertOk(MSG_IC_CHAT_REJECTLIST_INSERT_OK* pMsg)
/// \brief		ź Ʈ ޱ OK
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketChatRejectlistInsertOk(MSG_IC_CHAT_REJECTLIST_INSERT_OK* pMsg)
{
	Reject_t temp_reject;
	memset(&temp_reject, 0x00, sizeof(Reject_t));

	strncpy(temp_reject.szRejectName, pMsg->szCharacterName, SIZE_MAX_CHARACTER_NAME);
	// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
	temp_reject.atimeRegTime = pMsg->RegDate;

	//g_pGameMain->m_pCommunity->GetReject()->m_vecReject.push_back(temp_reject);
	g_pGameMain->m_pCommunity->GetReject()->AddRejectList(temp_reject);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketChatFriendlistRefreshOk(MSG_IC_CHAT_FRIENDLIST_REFRESH_OK* pMsg)
/// \brief		
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketChatFriendlistRefreshOk(MSG_IC_CHAT_FRIENDLIST_REFRESH_OK* pMsg)
{
	FRIENDINFO *pfriendinfo = (FRIENDINFO *)((char *)pMsg + sizeof(MSG_IC_CHAT_FRIENDLIST_REFRESH_OK));
	for(int i=0; i<pMsg->nFriendListCounts; i++)
	{
		// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
//		vector<Friend_t>::iterator it = g_pGameMain->m_pCommunity->GetFriend()->m_vecFriend.begin();
//		while(it != g_pGameMain->m_pCommunity->GetFriend()->m_vecFriend.end())
//		{
//			if(0 == strncmp(pfriendinfo->szCharacterName, it->szFriendName, SIZE_MAX_CHARACTER_NAME))
//			{
//				it->bOnline			= pfriendinfo->byIsOnline;
//			}
//			it++;
//		}		
		g_pGameMain->m_pCommunity->GetFriend()->FriendListRefresh(pfriendinfo->szCharacterName, pfriendinfo->byIsOnline);
		pfriendinfo++;
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketChatFriendlistDeleteOk(MSG_IC_CHAT_FRIENDLIST_DELETE_OK* pMsg)
/// \brief		 Ʈ 
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketChatFriendlistDeleteOk(MSG_IC_CHAT_FRIENDLIST_DELETE_OK* pMsg)
{
	// 2008-04-04 by bhsohn Ep3 Ŀ´Ƽ â
//	vector<Friend_t>::iterator it = g_pGameMain->m_pCommunity->GetFriend()->m_vecFriend.begin();
//	while(it != g_pGameMain->m_pCommunity->GetFriend()->m_vecFriend.end())
//	{
//		if(0 == strncmp(pMsg->szCharacterName, it->szFriendName, SIZE_MAX_CHARACTER_NAME))
//		{
//			g_pGameMain->m_pCommunity->GetFriend()->m_vecFriend.erase(it);
//			break;
//		}
//		it++;
//	}
	g_pGameMain->m_pCommunity->GetFriend()->DeleteFriendList(pMsg->szCharacterName);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketChatRejectlistDeleteOk(MSG_IC_CHAT_REJECTLIST_DELETE_OK* pMsg)
/// \brief		źθƮ 
/// \author		ydkim
/// \date		
///////////////////////////////////////////////////////////////////////////////
VOID	CAtumApplication::IMSocketChatRejectlistDeleteOk(MSG_IC_CHAT_REJECTLIST_DELETE_OK* pMsg)
{
	vector<Reject_t>::iterator it = g_pGameMain->m_pCommunity->GetReject()->m_vecReject.begin();
	while(it != g_pGameMain->m_pCommunity->GetReject()->m_vecReject.end())
	{
		if(0 == stricmp(pMsg->szCharacterName, it->szRejectName))
		{
			g_pGameMain->m_pCommunity->GetReject()->m_vecReject.erase(it);
			break;
		}
		it++;
	}	
}

void CAtumApplication::IMSocketVoipError(MSG_IC_VOIP_ERROR* pMsg)
{

	// 2008-07-17 by dgwoo  ̽ Ʈѷ â   ʴ´.
	//g_pGameMain->m_pChat->ShowVoiceChatControl(TRUE); 
	switch(pMsg->nErrorNum)
	{
	case VOIPERR_1to1_NO_SUCH_CHARACTER:
		{
			// 2009-01-12 by bhsohn Ϻ ߰ 
			//m_pChat->CreateChatChild(STRERR_C_VOIP_0001,COLOR_VOIP);
			m_pChat->CreateChatChild(STRMSG_C_090112_0204,COLOR_VOIP);
			// end 2009-01-12 by bhsohn Ϻ ߰ 

			m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
			m_VOIPState.bCaller = FALSE;
		}
		break;
	case VOIPERR_1to1_NO_SUCH_ACCOUNTUNIQUENUMBER:
		{
			m_pChat->CreateChatChild(STRERR_C_VOIP_0002,COLOR_VOIP);
			m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
			m_VOIPState.bCaller = FALSE;
		}
		break;
	case VOIPERR_1to1_CANNOT_CALL:
		{
			m_pChat->CreateChatChild(STRERR_C_VOIP_0003,COLOR_VOIP);
			// UNREGISTER
			COPYDATASTRUCT	copyData;
			memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
			AV_MSG_WM_COPYDATA voIP(_BothCall, AV_MT_UNREGISTER, 0);
			copyData.dwData = (DWORD)voIP;
			copyData.lpData = NULL;
			copyData.cbData = 0;
			::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&copyData);
			// State ʱȭ
			m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
			m_VOIPState.bCaller = FALSE;
		}
		break;
	case VOIPERR_1to1_REJECT:
		{
			m_pChat->CreateChatChild(STRERR_C_VOIP_0004,COLOR_VOIP);
			// UNREGISTER
			COPYDATASTRUCT	copyData;
			memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
			AV_MSG_WM_COPYDATA voIP(_BothCall, AV_MT_UNREGISTER, 0);
			copyData.dwData = (DWORD)voIP;
			copyData.lpData = NULL;
			copyData.cbData = 0;
			::SendMessage(m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA, (WPARAM)m_hWnd, (LPARAM)&copyData);
			// State ʱȭ
			m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
			m_VOIPState.bCaller = FALSE;

		}
		break;
//	case VOIPERR_NtoN_NO_SUCH_CHARACTER:
//		{
//		}
//		break;
	default:
		{
		}
		break;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketAdminCallGMInfoOk(MSG_IC_ADMIN_CALLGM_INFO_OK* pMsg)
/// \brief		
/// \author		ispark
/// \date		2006-05-08 ~ 2006-05-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketAdminCallGMInfoOk(MSG_IC_ADMIN_CALLGM_INFO_OK* pMsg)
{
	char str[64] = {0,};
	wsprintf(str,STRMSG_C_060509_0000,pMsg->nCallGMTotalCount);		// " ó ǰ %d ֽϴ."
	m_pChat->CreateChatChild(str,COLOR_CHAT_ALL, CHAT_TAB_NORMAL);
}
	
///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketAdminCallGMViewOk(char* pPacket)
/// \brief		
/// \author		ispark
/// \date		2006-05-08 ~ 2006-05-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketAdminCallGMViewOk(char* pPacket)
{
	if(m_dwGameState == _GAME || m_dwGameState == _SHOP || m_dwGameState == _CITY)
	{
		MSG_IC_ADMIN_CALLGM_VIEW_OK	*pCallGM_View = NULL;
		char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+36];
		memset(bufChat, 0x00, SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+36);
		pCallGM_View = (MSG_IC_ADMIN_CALLGM_VIEW_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER);
		for(int i = 0; i < pCallGM_View->nCallGMCount; i++)
		{
			int temp,temp2;
			SCALLGM *pScallGM = (SCALLGM*)(pPacket + SIZE_FIELD_TYPE_HEADER + sizeof(MSG_IC_ADMIN_CALLGM_VIEW_OK) + sizeof(SCALLGM)*i);
			char strDescription[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME];
			memset(strDescription, 0x00, SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME);
			memcpy(strDescription, pScallGM->szCallGMDescription, SIZE_MAX_CHAT_MESSAGE);

			CheckReadyStringFiltering(strDescription, &temp, &temp2);

			wsprintf(bufChat, STRMSG_C_060509_0001, 
						pScallGM->szCallerCharacterName, 
						pScallGM->atimeCallTime.GetLocalDateTimeString(string(),GetLanguageType()), 
						strDescription);	// "[%s][%s][%s]" // [ĳ͸][ð][]
			m_pChat->CreateChatChild(bufChat,COLOR_CHAT_ALL, CHAT_TAB_NORMAL);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::IMSocketAdminCallGMBringOk(char* pPacket)
/// \brief		
/// \author		ispark
/// \date		2006-05-08 ~ 2006-05-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketAdminCallGMBringOk(char* pPacket)
{
	if(m_dwGameState == _GAME || m_dwGameState == _SHOP || m_dwGameState == _CITY)
	{
		MSG_IC_ADMIN_CALLGM_BRING_OK	*pCallGM_Bring = NULL;
		// 2009-02-05 by bhsohn /bringCallgm ״  ذ
		//char bufChat[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4];
		char bufChat[MAX_PATH];
		// end 2009-02-05 by bhsohn /bringCallgm ״  ذ

		char bufCallerInfl[SIZE_MAX_CHAT_MESSAGE];					// CallerInflTy
		char bufCallerInflTemp[SIZE_MAX_CHAT_MESSAGE];					// CallerInflTy
		// 2009-02-05 by bhsohn /bringCallgm ״  ذ
		//memset(bufChat, 0x00, SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME+4);
		ZERO_MEMORY(bufChat);
		// end 2009-02-05 by bhsohn /bringCallgm ״  ذ

		pCallGM_Bring = (MSG_IC_ADMIN_CALLGM_BRING_OK*)(pPacket + SIZE_FIELD_TYPE_HEADER);
		for(int i = 0; i < pCallGM_Bring->nCallGMCount; i++)
		{
			int temp,temp2;
			SCALLGM *pScallGM = (SCALLGM*)(pPacket + SIZE_FIELD_TYPE_HEADER + sizeof(MSG_IC_ADMIN_CALLGM_BRING_OK) + sizeof(SCALLGM)*i);
			char strDescription[SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME];
			memset(strDescription, 0x00, SIZE_MAX_CHAT_MESSAGE + SIZE_MAX_CHARACTER_NAME);
			memcpy(strDescription, pScallGM->szCallGMDescription, SIZE_MAX_CHAT_MESSAGE);

			// 2007-11-19 by dgwoo  ý .
			memset(bufCallerInfl,0x00,SIZE_MAX_CHAT_MESSAGE);
			memset(bufCallerInflTemp,0x00,SIZE_MAX_CHAT_MESSAGE);
			GetInfluenceString(bufCallerInflTemp,pScallGM->CallerInflTy);
			wsprintf(bufCallerInfl ,STRMSG_C_071119_0100,pScallGM->szCallerCharacterName,bufCallerInflTemp);

			CheckReadyStringFiltering(strDescription, &temp, &temp2);

			wsprintf(bufChat, STRMSG_C_060509_0001, 
						bufCallerInfl, 
						pScallGM->atimeCallTime.GetLocalDateTimeString(string(),GetLanguageType()),
						strDescription);		// "[%s][%s][%s]" // [ĳ͸][ð][]
			m_pChat->CreateChatChild(bufChat,COLOR_CHAT_ALL,CHAT_TAB_PTOP, g_pShuttleChild->m_myShuttleInfo.CharacterName, bufCallerInfl);

			if(strcmp(m_pShuttleChild->m_myShuttleInfo.CharacterName,pScallGM->szCallerCharacterName))
			{
				bool bChatCheckPToP = false;
				for(int i=0;i<MAX_CHAT_PTOP_CONT;i++)
				{
					if(!strcmp(m_pShuttleChild->m_strChatPToP[i],pScallGM->szCallerCharacterName))
					{
						m_pShuttleChild->m_bOldPToPPos = i;
						bChatCheckPToP = true;
						break;
					}
				}
				if(!bChatCheckPToP)
				{
					memset(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bCurPToPPos],0x00,SIZE_MAX_CHARACTER_NAME);
					strncpy(m_pShuttleChild->m_strChatPToP[m_pShuttleChild->m_bCurPToPPos],pScallGM->szCallerCharacterName,strlen(pScallGM->szCallerCharacterName));
					m_pShuttleChild->m_bOldPToPPos = m_pShuttleChild->m_bCurPToPPos;
					m_pShuttleChild->m_bCurPToPPos++;
					if(m_pShuttleChild->m_bCurPToPPos == MAX_CHAT_PTOP_CONT)
						m_pShuttleChild->m_bCurPToPPos = 0;
				}
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \class		IMSocketGuildEndWarAdminNotify((MSG_IC_GUILD_END_WAR_ADMIN_NOTIFY*)
/// \brief		  ڴ ڿԸ ش.(äâ)
///
/// \author		dgwoo
/// \version	
/// \date		2006-08-09 ~ 2006-08-09
/// \warning	
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketGuildEndWarAdminNotify(MSG_IC_GUILD_END_WAR_ADMIN_NOTIFY* pMsg)
{
	char buf[512];
	if(pMsg->WarEndType)
	{
		wsprintf(buf,STRMSG_C_060809_0101,pMsg->WinerGuildName,pMsg->LoserGuildName);
		m_pChat->CreateChatChild(buf,COLOR_TRADE);
	}
	else
	{
		wsprintf(buf,STRMSG_C_060809_0100,pMsg->WinerGuildName,pMsg->LoserGuildName);
		m_pChat->CreateChatChild(buf,COLOR_TRADE);
	}
}

VOID CAtumApplication::IMSocketChatRoomCreateOK(MSG_IC_CHATROOM_CREATE_OK* pMsg)
{
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom();
	pChatRoom->CreateMyRoomOK(pMsg);
	g_pGameMain->m_pChat->SetChatRoomAct(TRUE);

}
VOID CAtumApplication::IMSocketChatRoomListInfoOK(MSG_IC_CHATROOM_LIST_INFO_OK* pMsg)
{
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom(); 
	pChatRoom->AddRoomList(pMsg);
}
VOID CAtumApplication::IMSocketChatRoomRequestInviteQuestion(MSG_IC_CHATROOM_REQUEST_INVITE_QUESTION *pMsg)
{
	// 2008-07-14 by bhsohn EP3  ó
	if(g_pGameMain->IsRejectUser(pMsg->ChatRoomMasterName))
	{
		
		return;
	}
	// end 2008-07-14 by bhsohn EP3  ó

	char buf[128];
	memset(buf,0x00,128);
	wsprintf(buf,STRMSG_C_080625_0104,pMsg->ChatRoomMasterName);
	g_pGameMain->m_pInfWindow->AddMsgBox(buf, _Q_CHATROOM_INVITE_FROM,0,0,0,pMsg->ChatRoomNum);
	
}
VOID CAtumApplication::IMSocketChatRoomJoinOK()
{
}
VOID CAtumApplication::IMSocketChatRoomAcceptInviteOK(MSG_IC_CHATROOM_ACCEPT_INVITE_OK* pMsg)
{
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom(); 
	pChatRoom->AddMyRoomInvite(pMsg);
	g_pGameMain->m_pChat->SetChatRoomAct(TRUE);

}
VOID CAtumApplication::IMSocketChatRoomRejectInviteOK()
{
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::IMSocketChatRoomLeaveOK(MSG_IC_CHATROOM_LEAVE_OK* pMsg)
/// \brief		 濡 ִ  äù .
/// \author		dgwoo
/// \date		2008-06-30 ~ 2008-06-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketChatRoomLeaveOK(MSG_IC_CHATROOM_LEAVE_OK* pMsg)
{
	if(g_pGameMain)
	{
		CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom(); 
		pChatRoom->ChatRoomLeaveOK(pMsg);
	}
	
}
VOID CAtumApplication::IMSocketChatRoomBanOK(MSG_IC_CHATROOM_BAN_OK* pMsg)
{
	if(g_pGameMain)
	{

		CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom();
		//m_pChat->CreateChatChild(STRMSG_C_080625_0108,COLOR_ITEM);
		pChatRoom->ChatRoomBan(pMsg);

		//pChatRoom->InitMyChatRoom();
	}
}
VOID CAtumApplication::IMSocketChatRoomChangeNameOK(MSG_IC_CHATROOM_CHANGE_NAME_OK* pMsg)
{
	// 2009-04-13 by bhsohn ä   
	if(!g_pGameMain || !g_pGameMain->m_pCommunity)
	{
		return;
	}	
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom();
	if(pChatRoom)
	{
		memcpy(pChatRoom->m_stMyRoomInfo.ChatRoomName,pMsg->ChatRoomName,SIZE_MAX_CHATROOM_NAME);
		pChatRoom->m_pEBChatRoomCS->SetString(pChatRoom->m_stMyRoomInfo.ChatRoomName,SIZE_MAX_CHATROOM_NAME);
	}
	// end 2009-04-13 by bhsohn ä   

}
VOID CAtumApplication::IMSocketChatroomChangeMasterOK(MSG_IC_CHATROOM_CHANGE_MASTER_OK* pMsg)
{
	// 2009-04-13 by bhsohn ä   
	if(!g_pGameMain || !g_pGameMain->m_pCommunity)
	{
		return;
	}	
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom();
	if(pChatRoom)
	{
		pChatRoom->m_stMyRoomInfo.MasterCharacterUID = pMsg->NewCharacterUID;
		pChatRoom->SetButtonActive();
	}
	// end 2009-04-13 by bhsohn ä   
}
VOID CAtumApplication::IMSocketChatRoomChangeLockPWOK(MSG_IC_CHATROOM_CHANGE_LOCK_PW_OK* pMsg)
{
	// 2009-04-13 by bhsohn ä   
	if(!g_pGameMain || !g_pGameMain->m_pCommunity)
	{
		return;
	}	
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom();
	if(pChatRoom)
	{
		pChatRoom->ChangeLockPWOK(pMsg);
	
	}	
	// end 2009-04-13 by bhsohn ä   
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::IMSocketChatRoomMemberInfoOK(MSG_IC_CHATROOM_MEMBER_INFO_OK* pMsg)
/// \brief		  ش. ( ư.)
/// \author		dgwoo
/// \date		2008-06-30 ~ 2008-06-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketChatRoomMemberInfoOK(MSG_IC_CHATROOM_MEMBER_INFO_OK* pMsg)
{
	// 2009-04-13 by bhsohn ä   
	if(!g_pGameMain || !g_pGameMain->m_pCommunity)
	{
		return;
	}	
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom();
	if(pChatRoom)
	{
		pChatRoom->AddMyRoomInfo(pMsg);
		g_pGameMain->m_pChat->SetChatRoomAct(TRUE);
	}
	// end 2009-04-13 by bhsohn ä   
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::IMSocketChatRoomOtherMemberInfoOK(MSG_IC_CHATROOM_MEMBER_INFO_OK* pMsg)
/// \brief		ٸ    ִ .
/// \author		dgwoo
/// \date		2008-06-30 ~ 2008-06-30
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::IMSocketChatRoomOtherMemberInfoOK(MSG_IC_CHATROOM_MEMBER_INFO_OK* pMsg)
{
	// 2009-04-13 by bhsohn ä   
	if(!g_pGameMain || !g_pGameMain->m_pCommunity)
	{
		return;
	}	
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom();
	if(pChatRoom)
	{
		pChatRoom->AddOtherRoomInfo(pMsg);
	}
	// end 2009-04-13 by bhsohn ä   
}
VOID CAtumApplication::IMSocketChatRoomChangeMaxMemberOK(MSG_IC_CHATROOM_CHANGE_MAX_MEMBER_OK* pMsg)
{
	// 2009-04-13 by bhsohn ä   
	if(!g_pGameMain || !g_pGameMain->m_pCommunity)
	{
		return;
	}	
	CINFCommunityChatRoom* pChatRoom = g_pGameMain->m_pCommunity->GetChatRoom();
	if(pChatRoom)
	{
		pChatRoom->m_stMyRoomInfo.ChatRoomMaxCount = pMsg->ChatRoomMaxMember;
		pChatRoom->m_pLBChatRoom->SetSelectItem(pChatRoom->GetListBoxSelectItem(pMsg->ChatRoomMaxMember));
	}
	// end 2009-04-13 by bhsohn ä   
}

VOID CAtumApplication::OnRecvCopyData(WPARAM wParam, COPYDATASTRUCT* pCopyDataStruct)
{
	FLOG("CAtumApplication::OnRecvCopyData(WPARAM wParam, COPYDATASTRUCT* pCopyDataStruct)");
	AV_MSG_WM_COPYDATA voIP(pCopyDataStruct->dwData);
	char buf[256];


	switch(voIP.nMsgType)
	{
	case AV_EV_CLIENT_ERROR:
		{
			m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;//  state  ʴ´. Ŀ ٽ õҶ   ü ֱ 
			g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_NONE);
			short nErrCode = voIP.nMsgParam;
			if(voIP.nCallType == _1to1Call)
			{
				switch(nErrCode)
				{
				case 1:
					wsprintf(buf,STRERR_C_VOIP_0007);//"[ ] Invalid product"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 2:
					wsprintf(buf,STRERR_C_VOIP_0008);//"[ ] Invalid PCN"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 3:
					wsprintf(buf,STRERR_C_VOIP_0009);//"[ ] Invalid Number"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 4:
					wsprintf(buf,STRERR_C_VOIP_0010);//"[ ] Server Error"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 5:
					wsprintf(buf,STRERR_C_VOIP_0011);//"[ ] No Free Channel"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 6:
					wsprintf(buf,STRERR_C_VOIP_0012);//"[ ] Network Error"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 7:
					wsprintf(buf,STRERR_C_VOIP_0013);//"[ ] No bandwidth"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 12:
					wsprintf(buf,STRERR_C_VOIP_0014);//"[ ] No Permission"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 17:
					wsprintf(buf,STRERR_C_VOIP_0015);//"[ ] Busy.. Try again"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 30:
					wsprintf(buf,STRERR_C_VOIP_0016);//"[ ] No Answer"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 31:
					wsprintf(buf,STRERR_C_VOIP_0017);//"[ ] Already login"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 32:
					wsprintf(buf,STRERR_C_VOIP_0018);//"[ ] Incorrect pwd"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 35:
					wsprintf(buf,STRERR_C_VOIP_0019);//"[ ] Not Login"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 36:
					wsprintf(buf,STRERR_C_VOIP_0020);//"[ ] [  ]"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 50:
					wsprintf(buf,STRERR_C_VOIP_0021);//"[ ] Using Serial Port"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				case 51:
					wsprintf(buf,STRERR_C_VOIP_0022);//"[ ] Invalid Serial Port"
					m_pChat->CreateChatChild(buf,COLOR_VOIP,CHAT_TAB_SOUND);
					break;
				}
			}
			else // NtoN
			{
				m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;//  state  ʴ´. Ŀ ٽ õҶ   ü ֱ 
				m_VOIPState.bCaller = FALSE;
				m_VOIPState.nCallState = _CALLSTATE_1TO1;
				ASSERT_IMPLIES(g_pShuttleChild, g_pShuttleChild->m_pClientParty);
				g_pShuttleChild->m_pClientParty->SetNtoNCallState(FALSE);
				ASSERT_IMPLIES(g_pGameMain, g_pGameMain->m_pCommunity);
				g_pGameMain->m_pCommunity->GetGuild()->SetNtoNCallState(FALSE);
				g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_NONE);
				switch(nErrCode)
				{
				case _SC2_NO_ERROR:
					{
					}
					break;
				case _SC2_NORMAL_ERROR:
					{
						m_pChat->CreateChatChild(STRERR_C_VOIP_0023,COLOR_VOIP,CHAT_TAB_SOUND);//"[/ȭ ] ˼ Դϴ."
					}
					break;
				case _SC2_INVALID_STATUS_ERROR://
					{
						m_pChat->CreateChatChild(STRERR_C_VOIP_0024,COLOR_VOIP,CHAT_TAB_SOUND);//"[/ȭ ]  Դϴ."
					}
					break;
				case _SC2_INVALID_PARAM_ERROR://
					{
						m_pChat->CreateChatChild(STRERR_C_VOIP_0025,COLOR_VOIP,CHAT_TAB_SOUND);//"[/ȭ ] Ķ Դϴ."
					}
					break;
				case _SC2_INVALID_ROOMID_ERROR://̵
					{
						m_pChat->CreateChatChild(STRERR_C_VOIP_0026,COLOR_VOIP,CHAT_TAB_SOUND);//"[/ȭ ] ȭ  Դϴ."
					}
					break;
				case _SC2_CONNECT_VDSERVER_ERROR://ῡ
				case _SC2_CONNECT_VCSERVER_ERROR:
					{
						m_pChat->CreateChatChild(STRERR_C_VOIP_0027,COLOR_VOIP,CHAT_TAB_SOUND);//"[/ȭ ]   Դϴ.",
					}
					break;
				case _SC2_VOIP_SERVER_ERROR:// 
					{
						m_pChat->CreateChatChild(STRERR_C_VOIP_0028,COLOR_VOIP,CHAT_TAB_SOUND);//"[/ȭ ]  Դϴ."
					}
					break;
				default:
					{
						m_pChat->CreateChatChild(STRERR_C_VOIP_0029,COLOR_VOIP,CHAT_TAB_SOUND);//"[/ȭ] ˼  Դϴ."
					}
					break;
				}
			}
		}
		break;
	case AV_EV_CLIENT_STATUS:
		{
			short	nStatus= voIP.nMsgParam;
			if(voIP.nCallType == _1to1Call)
			{
				switch(nStatus)
				{
				case -1:
					wsprintf(buf,STRERR_C_VOIP_0030);//"  Դϴ."
					m_pChat->CreateChatChild(buf,COLOR_VOIP);
					m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
					break;
				case 0:
					wsprintf(buf,STRMSG_C_VOIP_0021);//"  [ Ready ]"
					m_pChat->CreateChatChild(buf,COLOR_VOIP);
					m_VOIPState.nVOIPState = _VOIP_REGISTERED;
					
					// â ɼǿ  
					if((g_pGameMain != NULL) && (TRUE == g_pGameMain->m_pInfWindow->m_bMessageBoxFlag))
					{
						// UNREGISTER
						COPYDATASTRUCT	copyData;
						memset(&copyData, 0x00, sizeof(COPYDATASTRUCT));
						AV_MSG_WM_COPYDATA voIP(_BothCall, AV_MT_UNREGISTER, 0);
						copyData.dwData = (DWORD)voIP;
						copyData.lpData = NULL;
						copyData.cbData = 0;
						::SendMessage( m_VOIPState.m_hWndAtumVoIPClient, WM_COPYDATA,
										(WPARAM)g_pD3dApp->GetHwnd(), 
										(LPARAM)&copyData);

						MSG_IC_VOIP_ERROR sMsg;
						sMsg.nErrorNum = VOIPERR_1to1_REJECT;
						sMsg.nSend2AccountUniqueNumber = m_VOIPState.nCalledAccountUniqueNumber;
						g_pIMSocket->SendMsg( T_IC_VOIP_ERROR, (char*)&sMsg, sizeof(sMsg) );
						m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
						m_VOIPState.bCaller = FALSE;
					}
					break;
				case 1:
					wsprintf(buf,STRMSG_C_VOIP_0022);//"  [ Connecting ]"
					m_pChat->CreateChatChild(buf,COLOR_VOIP);
					break;
				case 2:
					wsprintf(buf,STRMSG_C_VOIP_0023);//"  [ Ringing ]"
					m_pChat->CreateChatChild(buf,COLOR_VOIP);
					m_VOIPState.nVOIPState = _VOIP_ALERTINGSTATE;
					break;
				case 3:
					wsprintf(buf,STRMSG_C_VOIP_0024);//"ȭ ۵Ǿϴ."
					m_pChat->CreateChatChild(buf,COLOR_VOIP);
					m_VOIPState.nVOIPState = _VOIP_DIALINGSTATE;
					
					break;
				case 4:
					wsprintf(buf,STRMSG_C_VOIP_0025);//"  [ Error ]"//
					m_pChat->CreateChatChild(buf,COLOR_VOIP);
					break;
				default:
					wsprintf(buf,STRMSG_C_VOIP_0026);//"  [ Unknown Status ]"
					m_pChat->CreateChatChild(buf,COLOR_VOIP);
					break;
				}
			}
			else // NtoN
			{
				switch(nStatus)
				{
				case _SC2_ERROR_STATUS:
					{
						m_pChat->CreateChatChild(STRMSG_C_VOIP_0027,COLOR_VOIP);//"[/ȭ]  Դϴ."
						m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
					}
					break;
				case _SC2_READY_STATUS: // not login
					{
						m_pChat->CreateChatChild(STRMSG_C_VOIP_0028,COLOR_VOIP);//"[/ȭ] ..."
						m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
					}
					break;
				case _SC2_CONNECTING_VDSERVER_STATUS: // connecting
				case _SC2_CONNECTED_VDSERVER_STATUS: // connecting
					{
						m_VOIPState.nVOIPState = _VOIP_TRY_REGISTER;
					}
					break;
				case _SC2_CONNECTING_VCSERVER_STATUS:
				case _SC2_CONNECTED_VCSERVER_STATUS:
					{
						m_pChat->CreateChatChild(STRMSG_C_VOIP_0029,COLOR_VOIP);//"[/ȭ] ..."
						m_VOIPState.nVOIPState = _VOIP_TRY_REGISTER;
					}
					break;
				case _SC2_CREATED_ROOM_STATUS:// registered
				case _SC2_JOINED_ROOM_STATUS:// registered
					{
						m_pChat->CreateChatChild(STRMSG_C_VOIP_0030, COLOR_VOIP);//"[/ȭ] ȭ ۵Ǿϴ. ϱ Ű 'Z' Դϴ."
						m_VOIPState.nVOIPState = _VOIP_DIALINGSTATE;
						
					}
					break;
				}
			}
		}
		break;
	case AV_EV_EXECUTE_OK:
		{
			m_VOIPState.m_hWndAtumVoIPClient = (HWND)wParam;
			m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
		}
		break;
	case AV_EV_REGISTERED:
		{
			if(m_VOIPState.bCaller == TRUE)
			{
				MSG_IC_VOIP_1to1_DIAL sMsg;
				sMsg.nCallerAccountUniqueNumber = g_pShuttleChild->m_myShuttleInfo.AccountUniqueNumber;
				sMsg.nCalledAccountUniqueNumber = m_VOIPState.nCalledAccountUniqueNumber;
				strncpy(sMsg.szCallerCharacterName, m_pShuttleChild->m_myShuttleInfo.CharacterName, SIZE_MAX_CHARACTER_NAME );
				m_pIMSocket->SendMsg( T_IC_VOIP_1to1_DIAL, (char*)&sMsg, sizeof(sMsg) );
				m_VOIPState.nVOIPState = _VOIP_DIALBLOCK;
			}
			else
			{
				wsprintf(buf,STRMSG_C_VOIP_0001,m_VOIPState.szName);
				g_pGameMain->m_pInfWindow->AddMsgBox(buf, _Q_VOIP_OK,0,0,DELETE_MASSAGEBOX_TIME,0,m_VOIPState.szName);
				m_VOIPState.nVOIPState = _VOIP_REGISTERED;
			}
		}
		break;
	case AV_EV_CREATE_ROOM_OK:
		{
			MSG_IC_VOIP_NtoN_INVITE_ALL sMsg;
			if(m_VOIPState.nCallState == _CALLSTATE_PARTY)
			{
				m_pChat->CreateChatChild(STRMSG_C_VOIP_0031,COLOR_VOIP);//"밣 ȭ ۵Ǿϴ. ϱ Ű 'Z' Դϴ."
				sMsg.byIsPartyCall = TRUE;
				g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_PARTY);
				
			}
			else
			{
				m_pChat->CreateChatChild(STRMSG_C_VOIP_0032,COLOR_VOIP);//" ȭ ۵Ǿϴ. ϱ Ű 'Z' Դϴ."
				sMsg.byIsPartyCall = FALSE;
				g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_GUILD);
			}
			m_pIMSocket->SendMsg( T_IC_VOIP_NtoN_INVITE_ALL, (char*)&sMsg, sizeof(sMsg) );
//			g_pIMSocket->WriteMessageType( T_IC_VOIP_NtoN_INVITE_ALL );
		}
		break;
	case AV_EV_JOIN_ROOM_OK:
		{
			g_pShuttleChild->m_pClientParty->SetNtoNCallState(TRUE);
			m_VOIPState.nVOIPState = _VOIP_DIALINGSTATE;
			if(m_VOIPState.nCallState == _CALLSTATE_PARTY)
			{
				m_pChat->CreateChatChild(STRMSG_C_VOIP_0031,COLOR_VOIP);//"밣 ȭ ۵Ǿϴ. ϱ Ű 'Z' Դϴ."
				g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_PARTY);
			}
			else
			{
				m_pChat->CreateChatChild(STRMSG_C_VOIP_0032,COLOR_VOIP);//" ȭ ۵Ǿϴ. ϱ Ű 'Z' Դϴ."
				g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_GUILD);
			}
		}
		break;
	case AV_EV_JOIN_USER:
		{
			// 2008-10-14 by bhsohn VOIP
			// űԷ 
//			MSG_EV_JOIN_USER * pMsg = (MSG_EV_JOIN_USER*)pCopyDataStruct->lpData;
//			if(m_VOIPState.nCallState == _CALLSTATE_PARTY)
//			{
//				wsprintf(buf, STRMSG_C_VOIP_0033, pMsg->szCharacterName);//"%s 밣 ȭ Ͽϴ"
//			}
//			else
//			{
//				wsprintf(buf, STRMSG_C_VOIP_0034, pMsg->szCharacterName);//"%s  ȭ Ͽϴ"
//			}
//			m_pChat->CreateChatChild(buf,COLOR_VOIP);
			MSG_EV_JOIN_USER * pMsg = (MSG_EV_JOIN_USER*)pCopyDataStruct->lpData;
			if(m_VOIPState.nCallState == _CALLSTATE_PARTY)
			{
				wsprintf(buf, STRMSG_C_VOIP_0033, pMsg->szCharacterName);//"%s 밣 ȭ Ͽϴ"
				if(pMsg->EnableTalking)
				{
					// Ѹ ȹ
					g_pShuttleChild->m_pClientParty->SetSpekeAuth(pMsg->szCharacterName);
				}
				else
				{
					// Ѹ 
					g_pShuttleChild->m_pClientParty->ReleaseSpekeAuth(pMsg->szCharacterName);
				}
			}
			else if(m_VOIPState.nCallState == _CALLSTATE_GUILD)
			{
				BOOL bStartTalking = FALSE;
				switch(pMsg->EnableTalking)
				{
				case TRUE:
					{
						// ϱ 
						bStartTalking = TRUE;
					}
					break;
				case FALSE:
					{
						// ϱ 
						bStartTalking = FALSE;
					}
					break;
				}
				
				if(g_pGameMain && g_pGameMain->m_pCommunity)
				{
					g_pGameMain->m_pCommunity->GetGuild()->SetVOIPSpeaking(pMsg->szCharacterName, bStartTalking);
				}

				wsprintf(buf, STRMSG_C_VOIP_0034, pMsg->szCharacterName);//"%s  ȭ Ͽϴ"				
			}
			else
			{
				wsprintf(buf, STRMSG_C_VOIP_0034, pMsg->szCharacterName);//"%s  ȭ Ͽϴ"				
			}
			
			CHARACTER myShuttleInfo = g_pShuttleChild->GetMyShuttleInfo();		
			if(g_pGameMain && !stricmp(myShuttleInfo.CharacterName, pMsg->szCharacterName))
			{				
				DBGOUT("My Speaker Auth [%d]\n", pMsg->EnableTalking);
				//  ɸ̸  
				g_pGameMain->SetVOIPSpeaking(pMsg->EnableTalking);
			}
			
			m_pChat->CreateChatChild(buf,COLOR_VOIP);
			// end 2008-10-14 by bhsohn VOIP
		}
		break;
	case AV_EV_GOOUT_USER:
		{
			MSG_EV_GOOUT_USER * pMsg = (MSG_EV_GOOUT_USER*)pCopyDataStruct->lpData;
			if(voIP.nCallType == _1to1Call)
			{
				wsprintf(buf, STRMSG_C_VOIP_0035);//"1:1ȭ Ǿϴ."
				m_VOIPState.nVOIPState = _VOIP_NOTLOGIN;
				m_VOIPState.bCaller = FALSE;
			}
			else 
			{
				if(m_VOIPState.nCallState == _CALLSTATE_PARTY)
				{
					// 2008-10-14 by bhsohn VOIP
					// Ѹ 
					g_pShuttleChild->m_pClientParty->ReleaseAllSpeeakeInfo(pMsg->szCharacterName);
					// end 2008-10-14 by bhsohn VOIP

					wsprintf(buf, STRMSG_C_VOIP_0036, pMsg->szCharacterName);//"%s 밣 ȭ ϴ."
				}
				else
				{
					// 2008-10-14 by bhsohn VOIP
					g_pGameMain->m_pCommunity->GetGuild()->ReleaseVOIPInfo(pMsg->szCharacterName);					
					
					wsprintf(buf, STRMSG_C_VOIP_0037, pMsg->szCharacterName);//"%s  ȭ ϴ."
				}
			}
			// 2008-10-14 by bhsohn VOIP
			//g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_NONE);
			CHARACTER myShuttleInfo = g_pShuttleChild->GetMyShuttleInfo();		
			if(g_pGameMain && !stricmp(myShuttleInfo.CharacterName, pMsg->szCharacterName))
			{
				g_pGameMain->m_pChat->UpdateVoiceChatType(VOICE_NONE);
			}			
			m_pChat->CreateChatChild(buf,COLOR_VOIP);
		}
		break;
		// 2008-10-14 by bhsohn VOIP
	case AV_EV_TALK_USER:
		{
			// ӵ ¿  
			MSG_EV_TALK_USER * pMsg = (MSG_EV_TALK_USER*)pCopyDataStruct->lpData;
			CHARACTER myShuttleInfo = g_pShuttleChild->GetMyShuttleInfo();		
			if(m_VOIPState.nCallState == _CALLSTATE_PARTY)
			{
				wsprintf(buf, STRMSG_C_VOIP_0033, pMsg->szCharacterName);//"%s 밣 ȭ Ͽϴ"
				if(pMsg->bTalkFlag)
				{
					// ϱ Ѹ ȹ
					g_pShuttleChild->m_pClientParty->SetSpekeAuth(pMsg->szCharacterName);
				}
				else
				{
					// 
					g_pShuttleChild->m_pClientParty->ReleaseSpekeAuth(pMsg->szCharacterName);
				}
			}
			else if(m_VOIPState.nCallState == _CALLSTATE_GUILD)
			{
				BOOL bStartTalking = FALSE;
				switch(pMsg->bTalkFlag)
				{
				case TRUE:
					{
						// ϱ 
						bStartTalking = TRUE;
					}
					break;
				case FALSE:
					{
						// ϱ 
						bStartTalking = FALSE;
					}
					break;
				}
				
				if(g_pGameMain && g_pGameMain->m_pCommunity)
				{
					g_pGameMain->m_pCommunity->GetGuild()->SetVOIPSpeaking(pMsg->szCharacterName, bStartTalking);
				}

				wsprintf(buf, STRMSG_C_VOIP_0034, pMsg->szCharacterName);//"%s  ȭ Ͽϴ"				
			}
			
			if(g_pGameMain && !stricmp(myShuttleInfo.CharacterName, pMsg->szCharacterName))
			{				
				DBGOUT("My Speaker Auth [%d]\n", pMsg->bTalkFlag);
				//  ɸ̸  
				g_pGameMain->SetVOIPSpeaking(pMsg->bTalkFlag);
			}
			
			if(COMPARE_RACE(myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
			{
				switch(pMsg->bTalkFlag)
				{
				case TRUE:
					{
						//wsprintf(buf, "%s ϱ  ȹ", pMsg->szCharacterName);//"%s  ۽ "
					}
					break;				
				default:
					{
						//wsprintf(buf, "%s ϱ  ", pMsg->szCharacterName);//"%s  ۽ "
					}
					break;
				}					
				
				if(strlen(buf) > 0)
				{
					m_pChat->CreateChatChild(buf,COLOR_VOIP);
				}		
				
			}
		}
		break;
//		{
//			MSG_EV_TALK_USER * pMsg = (MSG_EV_TALK_USER*)pCopyDataStruct->lpData;
//			if(voIP.nCallType == _NtoNCall)
//			{
//				if(m_VOIPState.nCallState == _CALLSTATE_PARTY)
//				{
//					if(pMsg->bTalkFlag)
//					{
//						// Ŀ  ̱
//						g_pShuttleChild->m_pClientParty->SetSpekerIcon(pMsg->szCharacterName);
//					}
//					else
//					{
//						// Ŀ  ϱ
//						g_pShuttleChild->m_pClientParty->ReleaseSpekerIcon(pMsg->szCharacterName);
//					}
//				}
//				else
//				{
//					if(pMsg->bTalkFlag)
//					{
//						wsprintf(buf, STRMSG_C_VOIP_0038, pMsg->szCharacterName);//"%s  ۽ "
//					}
//					else
//					{
//						wsprintf(buf, STRMSG_C_VOIP_0039, pMsg->szCharacterName);//"%s  ۽ "
//					}
//					m_pChat->CreateChatChild(buf,COLOR_VOIP);
//				}
//			}
//		}
		// end 2008-10-14 by bhsohn VOIP
//		break;
		// 2008-10-14 by bhsohn VOIP
	case AV_EV_CHANGED_TALKING_STATE:
		{
			MSG_EV_CHANGED_TALKING_STATE * pMsg = (MSG_EV_CHANGED_TALKING_STATE*)pCopyDataStruct->lpData;
			if(voIP.nCallType == _NtoNCall)
			{
				CHARACTER myShuttleInfo = g_pShuttleChild->GetMyShuttleInfo();		
				if(m_VOIPState.nCallState == _CALLSTATE_PARTY)
				{
					switch(pMsg->nTakingState)
					{
					case TALKING_STATE_START_TALKING:
						{
							// Ŀ  ̱
							g_pShuttleChild->m_pClientParty->SetSpekerIcon(pMsg->szCharacterName);
						}
						break;
					case TALKING_STATE_END_TALKING:
						{
							// Ŀ  ϱ
							g_pShuttleChild->m_pClientParty->ReleaseSpekerIcon(pMsg->szCharacterName);
						}
						break;
					}					
				}
				else if(m_VOIPState.nCallState == _CALLSTATE_GUILD)
				{
					
				}
				if(COMPARE_RACE(myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
				{					
					switch(pMsg->nTakingState)
					{
					case TALKING_STATE_START_TALKING:
						{
							wsprintf(buf, STRMSG_C_VOIP_0038, pMsg->szCharacterName);//"%s  ۽ "
						}
						break;
					case TALKING_STATE_END_TALKING:
						{
							wsprintf(buf, STRMSG_C_VOIP_0039, pMsg->szCharacterName);//"%s  ۽ "
						}
						break;
					default:
						{
							wsprintf(buf, "");
						}
						break;
					}					
					
					if(strlen(buf) > 0)
					{
						m_pChat->CreateChatChild(buf,COLOR_VOIP);
					}					
				}
			}
		}
		break;
		// end 2008-10-14 by bhsohn VOIP
	case AV_EV_NOTIFY:
		{		
			switch(voIP.nMsgParam) 
			{
			case VOIPERR_NtoN_FAIL_REQUEST_TOKEN:
				{
					wsprintf(buf, STRMSG_C_051006_0001);	// "ϱ  û !!   ٽ õϼ"
				}
				break;
			case VOIPERR_NtoN_LOST_TOKEN:
				{
					wsprintf(buf, STRMSG_C_051006_0002);	// "ϱ  ҵ.   ٽ õϼ"
				}
				break;
			default:
				{
					wsprintf(buf, "Unknown VoIP Notify");
				}
			}
			// 2008-10-14 by bhsohn VOIP
			//m_pChat->CreateChatChild(buf,COLOR_VOIP, CHAT_TAB_SOUND);
			m_pChat->CreateChatChild(buf,COLOR_VOIP);
		}
		break;
	case AV_EV_GET_SPK_VOLUME_OK:
		{
			// 2008-10-20 by bhsohn VOIP  
			//  
			USHORT Volum = voIP.nMsgParam;
			if(g_pGameMain)
			{
				g_pGameMain->InitSetVoiceVolum(Volum);
			}
		}
		break;
	default:
		{
		}
		break;
	}
}
#define DEBUG_COLOR		RGB(222, 222, 222)
void CAtumApplication::RenderDbg()
{
	FLOG("CAtumApplication::RenderDbg()");
	char buff[1024];



// 	static UINT		nFrameTime	= timeGetTime();
// 	UINT			nCurTime	= timeGetTime();
// 	
// 	if(nCurTime > nFrameTime + 5000)
// 	{
// 		::DbgOut("FPS : %.1f\n", m_fFPS);
// 		nFrameTime = nCurTime;
// 	}
	// 2011-07-29 by jhahn  ׻ ǥ
	int linePixel = 14;
	int lineNumber = 0;
#ifdef TEST140
	sprintf(buff,"FPS : [ %.1f ]",m_fFPS);
			m_pFontDebug->DrawText(100, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
#endif
	//end 2011-07-29 by jhahn  ׻ ǥ

#ifndef _DEBUG
	if( (m_dwGameState == _GAME || m_dwGameState == _CITY || m_dwGameState == _SHOP) &&
		g_pInterface->m_bShowInterface == TRUE &&
		COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
	{
#else
	if( (m_dwGameState == _GAME || m_dwGameState == _CITY || m_dwGameState == _SHOP) &&
		g_pInterface->m_bShowInterface == TRUE )
	{
#endif
		
#ifndef _DBGOUT_EFFECT

		if(strlen(m_strDebug))
		{
			m_pFontDebug->DrawText( 256, linePixel*lineNumber++, DEBUG_COLOR, m_strDebug,0 );
		}
		if(!m_bDebugText)
		{
#ifdef _DEBUG
			m_pFontDebug->DrawText( 256, linePixel*lineNumber++, DEBUG_COLOR, "DEBUG : CTRL+ALT+'/'", 0);
#endif
			// 2007-03-28 by bhsohn ڰ ¸  ְ  
			/*
			if(strlen(m_strSeverUserNum))
			{
				sprintf(buff,"%s",m_strSeverUserNum);
				m_pFontDebug->DrawText(256, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
			}
			if(strlen(m_strMapUserNum))
			{
				sprintf(buff,"%s",m_strMapUserNum);
				m_pFontDebug->DrawText(256, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
			}
			*/
			
			// 2007-04-09 by bhsohn   ǥ  ó
			if(strlen(m_strConnectSeverName))
			{
				sprintf(buff,"%s",m_strConnectSeverName);
				m_pFontDebug->DrawText(256, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
			}			
			// end 2007-04-09 by bhsohn   ǥ  ó			
			// end 2007-03-28 by bhsohn ڰ ¸  ְ  

			// 2006-05-24 by ispark
			GetInfluenceString(buff, m_pShuttleChild->m_myShuttleInfo.InfluenceType);
			m_pFontDebug->DrawText(256, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
//			// 2006-11-02 by ispark, ĳ ̴ Ÿ üũ(߿ ʿ 𸣴   ʿ ּ )
//			sprintf(buff, "CHARACTER MOVE RATE\\e(%.1f)\\e", m_pCharacterChild->GetCharacterSpeed());
//			m_pFontDebug->DrawText(256, linePixel*lineNumber++, DEBUG_COLOR, buff, 0);
		}
		else
		{
			lineNumber = 10;
			if(strlen(m_strSeverUserNum))
			{
				sprintf(buff,"%s",m_strSeverUserNum);
				m_pFontDebug->DrawText(10, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
			}
			if(strlen(m_strMapUserNum))
			{
				sprintf(buff,"%s",m_strMapUserNum);
				m_pFontDebug->DrawText(10, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
			}

			sprintf(buff,"MEM : [ %d ]",g_pD3dDev->GetAvailableTextureMem());
			m_pFontDebug->DrawText(10, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
			sprintf(buff,"OBJ : [ %d ]",g_pScene->m_vectorCulledObjectPtrList.size());
			m_pFontDebug->DrawText(10, linePixel*lineNumber++, DEBUG_COLOR, buff,0);
/*			if(m_pScene)
			{
				sprintf(buff,"Monster Render Count : %d",m_pScene->m_mapMonsterRenderList.size());
				m_pFontDebug->DrawText(10, linePixel*lineNumber++, DEBUG_COLOR, buff,0);

				sprintf(buff,"Monster Data Count : %d",m_pScene->m_mapMonsterList.size());
				m_pFontDebug->DrawText(10, linePixel*lineNumber++, DEBUG_COLOR, buff,0);

				sprintf(buff,"Enemy Render Count : %d",m_pScene->m_mapEnemyRenderList.size());
				m_pFontDebug->DrawText(10, linePixel*lineNumber++, DEBUG_COLOR, buff,0);

				sprintf(buff,"Enemy Data Count : %d",m_pScene->m_mapEnemyList.size());
				m_pFontDebug->DrawText(10, linePixel*lineNumber++, DEBUG_COLOR, buff,0);

				sprintf( buff, "Render Distance : %d", (int)(m_pScene->m_fFogEndValue + m_pCamera->m_fRenderDistance) );
				m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff, 0 );
			}
			if(m_pCamera)
			{
				sprintf( buff, "Detail Rate : %d%", (int)(m_pCamera->m_fDetailRateGround * 100.0f) );
				m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff, 0 );
			}
*/

			if(m_pEffectRender)
			{
				sprintf( buff, "Effect count : P[%d], S[%d], O[%d], T[%d]", 
					m_pEffectRender->m_nParticleEffectCountPerSecond,
					m_pEffectRender->m_nSpriteEffectCountPerSecond,
					m_pEffectRender->m_nObjectEffectCountPerSecond,
					m_pEffectRender->m_nTraceEffectCountPerSecond );
				m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff, 0 );
			}

#ifdef _DEBUG
			sprintf( buff, "ENEMY Move packet/sec:[%d], count/packet:[%d]", g_nMoveCountPerRate, g_nMoveCountPerPacket );
			m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff, 0 );
			sprintf( buff, "MISSILE COUNT:[%d]", g_nMissileCount );
			m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff, 0 );
			sprintf( buff, "Character Pos [X:%d Y:%d Z:%d]", (int)g_pShuttleChild->m_vPos.x, (int)g_pShuttleChild->m_vPos.y, (int)g_pShuttleChild->m_vPos.z);
			m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff, 0 );
//			sprintf(buff, "FOG[%.2f,%.2f,%.2f],S[%.1f],E[%.1f]",
//				g_pScene->m_fSkyRedColor, g_pScene->m_fSkyGreenColor, g_pScene->m_fSkyBlueColor,
//				g_pScene->m_fFogStartValue, g_pScene->m_fFogEndValue );
//			m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff, 0 );
//			sprintf(buff, "FOG[%.2f,%.2f,%.2f],S[%.1f],E[%.1f]",
//				m_pScene->m_fSkyRedColor, m_pScene->m_fSkyGreenColor, m_pScene->m_fSkyBlueColor,
//				m_pScene->m_fFogDestStartValue, m_pScene->m_fFogDestEndValue );
//			m_pFont->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff,0 );
//			sprintf( buff, "POS[ %.1f, %.1f, %.1f ]", m_pShuttleChild->m_vPos.x, m_pShuttleChild->m_vPos.y, m_pShuttleChild->m_vPos.z);
//			m_pFont->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff,0 );
//			sprintf( buff, "FOG Distance, Start[%.1f] End[%.1f]",g_pScene->m_fFogDestStartValue, g_pScene->m_fFogDestEndValue );
//			m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff,0 );
//			sprintf( buff, "1's weapon side position = (%.2f,%.2f,%.2f)", 
//							g_pShuttleChild->m_vPrimarySidePos.x,
//							g_pShuttleChild->m_vPrimarySidePos.y,
//							g_pShuttleChild->m_vPrimarySidePos.z);
//			m_pFontDebug->DrawText( 10, linePixel*lineNumber++, DEBUG_COLOR, buff,0 );
#endif // _DEBUG_endif
		}

#endif // !_DBGOUT_EFFECT_endif
	}
}



///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleAttackOk(MSG_FC_BATTLE_ATTACK_OK* pMsg)
/// \brief		Attack  ó(ȭ鿡 Ѿ Ʈ )
///				1. Attack index  Ǻ ( this function )
///				2. 1,2    :  CUnitData::CreateWeaponByFieldServer
///				3. AttackType ݹ Ǻ : CUnitData::CheckAttack
///				4. Target ó(,) : Weapon constructor
/// \author		dhkwon
/// \date		2004-09-07 ~ 2004-09-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleAttackOk(MSG_FC_BATTLE_ATTACK_OK* pMsg)
{
	ASSERT_ASSERT(m_pShuttleChild);
	if(m_pShuttleChild == NULL)
	{
		return;
	}
	if(pMsg->AttackIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		if(IS_PRIMARY_ATT_TYPE(pMsg->AttackType))
		{
			if(m_pShuttleChild->m_pPrimaryWeapon &&
				ATT_TYPE_SPLASH_PRI != pMsg->AttackType)
			{
				m_pShuttleChild->m_pPrimaryWeapon->SetWeaponCount(pMsg->RemainedBulletFuel);
			}
		}
		// 2010-06-15 by shcho&hslee ý -   
        //else	  
		else if(IS_SECONDARY_ATT_TYPE(pMsg->AttackType))	
        // end 2010-06-15 by shcho&hslee ý -   
		{
			if(m_pShuttleChild->m_pSecondaryWeapon)
			{
				m_pShuttleChild->m_pSecondaryWeapon->SetWeaponCount(pMsg->RemainedBulletFuel);
			}
		}
		g_pShuttleChild->CreateWeaponByFieldServer(pMsg);
	}
//	else if(pMsg->TargetInfo.TargetIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
//	{
//		// 2005-07-07 by ispark
//		//   ݽ
//		// 2 ݽ
//		if(IS_SECONDARY_ATT_TYPE(pMsg->AttackType))
//		{
//			m_pShuttleChild->SetMissileWarning(TRUE);
//			m_pShuttleChild->SetMissileCount(m_pShuttleChild->GetMissileCount() + 1);
//		}
//	}

	if(pMsg->AttackIndex < 10000) // Enemy
	{
		CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
		if(itEnemy != m_pScene->m_mapEnemyList.end() )
		{
			itEnemy->second->CreateWeaponByFieldServer(pMsg);
		}
	}
	else // Monster
	{
		CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->AttackIndex);
		if(itMonster != m_pScene->m_mapMonsterList.end() )
		{
			itMonster->second->CreateWeaponByFieldServer(pMsg);
		}

	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketBattleAttackEvasionOk(MSG_FC_BATTLE_ATTACK_EVASION_OK *pMsg)
/// \brief		ȸ
/// \author		ispark
/// \date		2005-12-12 ~ 2005-12-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleAttackEvasionOk(MSG_FC_BATTLE_ATTACK_EVASION_OK *pMsg)
{
	if(!m_pScene->m_pWeaponData)
		return;
	CWeapon * pNode = (CWeapon *)m_pScene->m_pWeaponData->m_pChild;
	while(pNode)
	{
		if( (pNode->m_dwPartType == _MISSILE || pNode->m_dwPartType == _ROCKET ) &&
			pMsg->AttackIndex == ((CWSlowData*)pNode)->m_nClientIndex && 
			pMsg->WeaponIndex == ((CWSlowData*)pNode)->m_nWeaponIndex)
		{
			((CWSlowData*)pNode)->m_bEvasion = TRUE;
			break;
		}

		pNode = (CWeapon *)pNode->m_pNext;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarNotifyInvasion(MSG_FC_BATTLE_ATTACK_EVASION_OK *pMsg)
/// \brief		 ħ
/// \author		ydkim
/// \date		
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarNotifyInvasion(MSG_FC_WAR_NOTIFY_INVASION *pMsg)
{
	MAP_INFO* pMapinfo = g_pDatabase->GetMapInfo(pMsg->MapChannelIndex0.MapIndex);
	char buff[256];
	ZERO_MEMORY(buff);
	
	if(pMapinfo)
	{
// 2006-03-07 by ispark,   ġ 
#if defined(LANGUAGE_ENGLISH) || defined(LANGUAGE_VIETNAM)|| defined(LANGUAGE_THAI)|| defined(LANGUAGE_RUSSIA)// 2008-04-30 by bhsohn ±  ߰
		// 2006-01-04 by ispark, ۷ι  ̸ ̴ ġ ٸ.
		wsprintf(buff,"%s %s[%d].",  STRMSG_C_051228_0001, pMapinfo->MapName,pMsg->MapChannelIndex0.ChannelIndex);
#else
		wsprintf(buff,"%s[%d] %s", pMapinfo->MapName,pMsg->MapChannelIndex0.ChannelIndex,  STRMSG_C_051228_0001);
#endif
		m_pChat->CreateChatChild(buff, COLOR_ITEM);//"  Ͽϴ."
	}
	else
	{
		m_pChat->CreateChatChild(STRMSG_C_051228_0001, COLOR_ITEM);//"  Ͽϴ."
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarNotifyInfluenceMonsterDead(MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD *pMsg)
/// \brief		¸ ı
/// \author		ydkim
/// \date		
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarNotifyInfluenceMonsterDead(MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD *pMsg)
{
	MEX_MONSTER_INFO* pMonsterInfo = g_pDatabase->CheckMonsterInfo(pMsg->MonsterUnitkind);
	char buff[1024];
	ZERO_MEMORY(buff);
	if(pMonsterInfo == NULL)
	{
		DbgOut("Monster Info Error : %d\n",pMsg->MonsterUnitkind);
		return;
	}
	if(IS_SAME_CHARACTER_MONSTER_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType,
			pMonsterInfo->Belligerence))
	{
		//   ı
		wsprintf(buff,"%s %s", pMonsterInfo->MonsterName,  STRMSG_C_051228_0002);		
	}
	else
	{
		//    ı Ű 
		wsprintf(buff,"%s %s", pMonsterInfo->MonsterName,  STRMSG_C_051228_0003);		
	}

	m_pChat->CreateChatChild(buff, COLOR_ITEM);//" ħ ׽ϴ."
	// 2007-02-06 by bhsohn    üũ
	// 2008-04-04 by bhsohn   Ŭ ߰
	//CINFGameMainUnitInfoBar* pBar = g_pInterface->m_pGameMain->m_pUnitInfoBar;
	g_pGameMain->DestroyMotherShipInfo(pMonsterInfo->Belligerence);

	// 2008-04-22 by bhsohn /   ǥ ϰ 	
	g_pInterface->RefreshWarMotherWarInfo();	//  
	// end 2008-04-22 by bhsohn /   ǥ ϰ 	

	// end 2007-02-06 by bhsohn    üũ
	// 2007-08-23 by bhsohn  ⿩ ū   ޽ ó
	AlertMsgWarMonsterInfo(pMonsterInfo, pMsg->szBestGuildName);
	// end 2007-08-23 by bhsohn  ⿩ ū   ޽ ó

	// 2008-07-11 by bhsohn , Ʈ  
	// 2009-03-25 by bhsohn , Ʈ ߸  ذ
	//if(IS_SAME_CHARACTER_MONSTER_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, pMonsterInfo->Belligerence))
	if(!IS_SAME_CHARACTER_MONSTER_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, pMonsterInfo->Belligerence))
	{
		ZERO_MEMORY(buff);
		wsprintf(buff, STRMSG_C_061121_0002, ADD_CONTRIBUTIONPOINT_BOSS_MONSTER);	// " Ʈ %d ߰ Ǿϴ."
		m_pChat->CreateChatChild(buff, COLOR_CHAT_GUILD);
	}
	// end 2008-07-11 by bhsohn , Ʈ  
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::AlertMsgWarMonsterInfo(MEX_MONSTER_INFO* pMonsterInfo, char* pBestGuildName)
/// \brief		
/// \author		// 2007-08-23 by bhsohn  ⿩ ū   ޽ ó
/// \date		
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::AlertMsgWarMonsterInfo(MEX_MONSTER_INFO* pMonsterInfo, char* pBestGuildName)
{
	if((NULL == pMonsterInfo) || strlen(pBestGuildName) == 0)
	{
		return;
	}
	char buff[128];
	ZERO_MEMORY(buff);
	wsprintf(buff, STRMSG_C_070823_0201, pBestGuildName, pMonsterInfo->MonsterName);
	AddSpeakerGMString(buff, FALSE);

	// 2008-07-11 by bhsohn  ¸  ޽ ý ޽ ߰
	m_pChat->CreateChatChild(buff, COLOR_ITEM);//" ħ ׽ϴ."
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID FieldSocketWarNotifyInfluenceAutoMonsterDead(MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD *pMsg)
/// \brief		  ڵ Ҹ
/// \author		// 2007-02-15 by bhsohn  ڵ Ҹ ̺Ʈ .
/// \date		2007-02-15 ~ 2007-02-15
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarNotifyInfluenceAutoMonsterDead(MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_DEAD *pMsg)
{
	MEX_MONSTER_INFO* pMonsterInfo = g_pDatabase->CheckMonsterInfo(pMsg->MonsterUnitkind);
	if(NULL == pMonsterInfo)
	{
		return;
	}
	
	//  ڵ Ҹ 
	// 2008-04-04 by bhsohn   Ŭ ߰
	//CINFGameMainUnitInfoBar* pBar = g_pInterface->m_pGameMain->m_pUnitInfoBar;
	g_pGameMain->DestroyMotherShipInfo(pMonsterInfo->Belligerence);

	// 2008-04-22 by bhsohn /   ǥ ϰ 	
	g_pInterface->RefreshWarMotherWarInfo();	//  
	// end 2008-04-22 by bhsohn /   ǥ ϰ 	
	
	// 2008-07-11 by bhsohn , Ʈ  	
	if(IS_SAME_CHARACTER_MONSTER_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, pMonsterInfo->Belligerence))
	{
		char buff[1024];
		ZERO_MEMORY(buff);
		wsprintf(buff, STRMSG_C_061121_0002, ADD_CONTRIBUTIONPOINT_BOSS_MONSTER);	// " Ʈ %d ߰ Ǿϴ."
		m_pChat->CreateChatChild(buff, COLOR_CHAT_GUILD);
	}
	// end 2008-07-11 by bhsohn , Ʈ  


	DBGOUT("CAtumApplication::FieldSocketWarNotifyInfluenceAutoMonsterDead[%d] \n", pMonsterInfo->Belligerence);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarNotifyInfluenceMonsterIvasion((MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_INVASION*)(pPacket+SIZE_FIELD_TYPE_HEADER))
/// \brief		   ޼
/// \author		ispark
/// \date		2006-01-20 ~ 2006-01-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarNotifyInfluenceMonsterIvasion(MSG_FC_WAR_NOTIFY_INFLUENCE_MONSTER_INVASION *pMsg)
{
	MEX_MONSTER_INFO* pMonsterInfo = g_pDatabase->CheckMonsterInfo(pMsg->MonsterUnitkind);
	if(pMonsterInfo)
	{
		char buff[128];
		ZERO_MEMORY(buff);
		// ()  ް ֽϴ.
		wsprintf(buff,STRMSG_C_060120_0000, pMonsterInfo->MonsterName);		
		m_pChat->CreateChatChild(buff, COLOR_ITEM);//" ħ ׽ϴ."
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarBossMonsterSummonDataInvasion(MSG_FC_WAR_BOSS_MONSTER_SUMMON_DATA* pMsg)
/// \brief		  ޼
/// \author		ispark
/// \date		2006-04-14 ~ 2006-04-14
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarBossMonsterSummonDataInvasion(MSG_FC_WAR_BOSS_MONSTER_SUMMON_DATA* pMsg)
{
	MEX_MONSTER_INFO* pMonsterInfo = g_pDatabase->CheckMonsterInfo(pMsg->SummonMonsterUnitkind);
	if(pMonsterInfo)
	{
		// 2009-01-28 by bhsohn , Ʈ ©  
		//char buffInfluence[12];
		//char buff[128];
		char buffInfluence[64];
		char buff[256];
		// end 2009-01-28 by bhsohn Ϻ û 
		ZERO_MEMORY(buff);
		ZERO_MEMORY(buffInfluence);

		if(pMonsterInfo->Belligerence == BELL_INFLUENCE_VCN)
		{
			wsprintf(buffInfluence, STRMSG_C_060210_0000);
		}
		else
		{
			wsprintf(buffInfluence, STRMSG_C_060210_0001);
		}

		if(pMsg->RemainMinute <= 0)
		{
			// "%s  %s() Ͽϴ."
			wsprintf(buff,STRMSG_C_060414_0001, buffInfluence, pMonsterInfo->MonsterName);
			m_pSound->SetBackMusic(_BOSSMONSTERSUMMON);
		}
		else
		{
			// "%s  %s() ϱ  %d ҽϴ."
			wsprintf(buff,STRMSG_C_060414_0000, buffInfluence, pMonsterInfo->MonsterName, pMsg->RemainMinute);
			m_pSound->SetBackMusic(_BOSSMONSTERSUMMONREADY);
		}

		m_pChat->CreateChatChild(buff, COLOR_ITEM);	
		
		// 2007-02-06 by bhsohn    üũ		
		if(pMsg->RemainMinute <= 0)
		{
			//  
			// 2009-03-17 by bhsohn ܰ躰 𼱽ý ߰			
			switch(pMsg->BeforeWinCheck)
			{
			case MSBOSSSTEP_UNKNOWN_BEFOREWAR:
				{
					//  ֱ⿡   ų ù ֱ 					
				}
				break;
			case MSBOSSSTEP_WIN_BEFOREWAR:
				{
					//  ֱ⿡  ¸					
					//"%s    ¸ ڸɿ   ¼  Դϴ."
					wsprintf(buff,STRMSG_C_090317_0201, buffInfluence);
					m_pChat->CreateChatChild(buff, COLOR_ITEM);	
				}
				break;
			case MSBOSSSTEP_LOSS_BEFOREWAR:
				{
					//  ֱ⿡  й					
					//"000    й ¸     غ ȭ Ͽϴ."
					wsprintf(buff,STRMSG_C_090317_0202, buffInfluence);
					m_pChat->CreateChatChild(buff, COLOR_ITEM);	
				}
				break;
			}			
			// end 2009-03-17 by bhsohn ܰ躰 𼱽ý ߰

			// 2008-04-04 by bhsohn   Ŭ ߰
			//CINFGameMainUnitInfoBar* pBar = g_pInterface->m_pGameMain->m_pUnitInfoBar;
			// 2008-04-22 by bhsohn /   ǥ ϰ 
			g_pGameMain->SummonMotherShipInfo(pMonsterInfo->Belligerence, &pMsg->SummonMonsterTime, pMsg->ContributionPoint, pMsg->SummonMonsterUnitkind);
			
		}		
		// 2009-03-17 by bhsohn ܰ躰 𼱽ý ߰
		if(COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race, RACE_OPERATION|RACE_GAMEMASTER))
		{
			// ڸ  ܰ ǥ 

			// 2009. 06. 04 by ckPark ܰ躰  ڿ  
			//wsprintf(buff,"MotionShip LV[%d] ", pMsg->BossStep);
			wsprintf(buff,"MotherShip LV[%d] ", pMsg->BossStep);
			// end 2009. 06. 04 by ckPark ܰ躰  ڿ  

			m_pChat->CreateChatChild(buff, COLOR_ITEM);	
		}
		// end 2009-03-17 by bhsohn ܰ躰 𼱽ý ߰
		// end end 2007-02-06 by bhsohn    üũ		
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketWarStrategypointMonsterSummon(SSUMMON_STRATEGYPOINT_INFO* pMsg)
/// \brief		 
/// \author		// 2007-07-04 by bhsohn ۷ ߰
/// \date		2007-07-04 ~ 2007-07-04
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarStrategypointMonsterSummon(MSG_FC_WAR_STRATEGYPOINT_MONSTER_SUMMON* pMsg)
{
	MAP_INFO* pMapinfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	char buf[1024] = {0,};
	char bufTime[1024] = {0,};
	char bufInfluence[64] = {0,};

	if(IS_MAP_INFLUENCE_VCN(pMapinfo->MapInfluenceType))
	{
		wsprintf(bufInfluence, "%s", STRMSG_C_060210_0000);
	}
	else if(IS_MAP_INFLUENCE_ANI(pMapinfo->MapInfluenceType))
	{
		wsprintf(bufInfluence, "%s", STRMSG_C_060210_0001);
	}
	
	wsprintf(buf, STRMSG_C_061121_0000, bufInfluence, pMapinfo->MapName);	// "\\c%s\\c %s   Ʈ Ǿϴ."

	// ð 
	wsprintf(bufTime, STRMSG_C_070712_0209, pMsg->SummonStrategyPointTime.Hour, pMsg->SummonStrategyPointTime.Minute);
	// 2007-12-27 by dgwoo
	g_pInterface->AddInflWarMonster(buf, pMsg->MapIndex, pMapinfo->MapInfluenceType, pMsg->SummonStrategyPointTime);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarJacoMonsterSummon(MSG_FC_WAR_JACO_MONSTER_SUMMON* pMsg)
/// \brief		  	
/// \author		ispark
/// \date		2006-04-20 ~ 2006-04-20
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarJacoMonsterSummon(MSG_FC_WAR_JACO_MONSTER_SUMMON* pMsg)
{
	// 2009-04-09 by bhsohn   ȯ, Ʈ ©  
	//char buffInfluence[12];
	//char buff[128];
	char buffInfluence[64];
	char buff[256];
	// end 2009-04-09 by bhsohn   ȯ, Ʈ ©  
	
	ZERO_MEMORY(buff);
	ZERO_MEMORY(buffInfluence);

	if(pMsg->nBelligerence0 == BELL_INFLUENCE_VCN)
	{
		wsprintf(buffInfluence, STRMSG_C_060210_0001);
	}
	else
	{
		wsprintf(buffInfluence, STRMSG_C_060210_0000);
	}

	wsprintf(buff,STRMSG_C_060420_0000, buffInfluence);	//"%s     Ͱ  Ѵ.   游 εϴ."

	m_pChat->CreateChatChild(buff, COLOR_ITEM);		
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarInfluenceData(MSG_FC_WAR_INFLUENCE_DATA* pMsg)
/// \brief		̺Ʈ ȸ 
/// \author		ispark
/// \date		2006-04-21 ~ 2006-04-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarInfluenceData(MSG_FC_WAR_INFLUENCE_DATA* pMsg)
{
	// 2009-03-31 by bhsohn ̺Ʈ ȸ  
// 	if(COMPARE_INFLUENCE(pMsg->byInfluenceType, g_pShuttleChild->m_myShuttleInfo.InfluenceType) && 
// 		pMsg->fDPRepairRate > 0.0f)
// 	{
// 		 g_bEventRecovery = TRUE;
// 		 g_fEventRecoveryRate = pMsg->fDPRepairRate;		
// 	}
	if(COMPARE_INFLUENCE(pMsg->byInfluenceType, g_pShuttleChild->m_myShuttleInfo.InfluenceType))
	{
		if(pMsg->fDPRepairRate > 0.0f)
		{
			g_bEventRecovery = TRUE;
			g_fEventRecoveryRate = pMsg->fDPRepairRate;		
		}
		else
		{
			g_bEventRecovery = FALSE;
			g_fEventRecoveryRate = 0.0f;		
		}
		
	}
	// end 2009-03-31 by bhsohn ̺Ʈ ȸ  
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarSignBoardInsertString(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING* pMsg)
/// \brief		  Ʈ Է
/// \author		ispark
/// \date		2006-04-18 ~ 2006-04-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarSignBoardInsertString(MSG_FC_WAR_SIGN_BOARD_INSERT_STRING* pMsg)
{
	if(g_pGameMain->m_pCityBoard &&
		!COMPARE_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		int temp = 0, temp2 = 0;
		CheckReadyStringFiltering(pMsg->SingBoardString, &temp, &temp2);
		g_pGameMain->m_pCityBoard->SetString(pMsg);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarReqSignBoardStringListOk(MSG_FC_WAR_REQ_SIGN_BOARD_STRING_LIST_OK* pMsg)
/// \brief		  ü 
/// \author		ispark
/// \date		2006-04-18 ~ 2006-04-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarReqSignBoardStringListOk(MSG_FC_WAR_REQ_SIGN_BOARD_STRING_LIST_OK* pMsg)
{
	if(g_pGameMain->m_pCityBoard &&
		!COMPARE_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		MSG_FC_WAR_SIGN_BOARD_INSERT_STRING *pSignBoardInsertString = (MSG_FC_WAR_SIGN_BOARD_INSERT_STRING *)((char *)pMsg + sizeof(MSG_FC_WAR_REQ_SIGN_BOARD_STRING_LIST_OK));
		for(int i=0; i < pMsg->nStringCount; i++)
		{
			int temp = 0, temp2 = 0;
			CheckReadyStringFiltering(pSignBoardInsertString->SingBoardString, &temp, &temp2);
			g_pGameMain->m_pCityBoard->SetString(pSignBoardInsertString);
			pSignBoardInsertString++;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarSignBoardDeleteString(MSG_FC_WAR_SIGN_BOARD_DELETE_STRING* pMsg)
/// \brief		  ޼ 
/// \author		ispark
/// \date		2006-04-18 ~ 2006-04-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarSignBoardDeleteString(MSG_FC_WAR_SIGN_BOARD_DELETE_STRING* pMsg)
{
	if(g_pGameMain->m_pCityBoard &&
		!COMPARE_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		g_pGameMain->m_pCityBoard->DelString(pMsg->DeleteStringIndex);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketWarUpdateContributionPointOk(MSG_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK* pMsg)
/// \brief		 Ʈ
/// \author		ispark
/// \date		2006-04-19 ~ 2006-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarUpdateContributionPointOk(MSG_FC_WAR_UPDATE_CONTRIBUTION_POINT_OK* pMsg)
{
	if(g_pGameMain->m_pCityBoard &&
		!COMPARE_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, INFLUENCE_TYPE_NORMAL))
	{
		g_pGameMain->m_pCityBoard->SetContributionPoint(pMsg);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketItemUpdateUsingItem(MSG_FC_STORE_UPDATE_USINGITEM *pMsg)
/// \brief		ȭ  Ʈ
/// \author		ispark
/// \date		2006-03-31 ~ 2006-03-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketStoreUpdateUsingItem(MSG_FC_STORE_UPDATE_USINGITEM *pMsg)
{
	CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUID0 );
	ASSERT_ASSERT( IS_COUNTABLE_ITEM(pItemInfo->Kind) == FALSE );
	pItemInfo->SetItemPassTime(pMsg->UsingTimeStamp0);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketStoreUpdateItemNum(MSG_FC_STORE_UPDATE_ITEMNUM* pMsg)
/// \brief		ս  ѹ 
/// \author		ispark
/// \date		2006-06-15 ~ 2006-06-15
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketStoreUpdateItemNum(MSG_FC_STORE_UPDATE_ITEMNUM* pMsg)
{
	CINFCityLab* pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_FACTORY);
	if(pCityLab)
	{
		pCityLab->ReSetTargetItemNum(pMsg->ItemUniqueNumber, pMsg->ItemNum);
	}
	// 2009-04-08 by bhsohn  ұ,  ʱȭ ý ߰ 
	else
	{
		CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber(pMsg->ItemUniqueNumber);
		ITEM* pItem = g_pDatabase->GetServerItemInfo(pMsg->ItemNum);
		
		if(pItem == NULL || pItemInfo == NULL)
		{
			return;
		}		
		pItemInfo->ItemInfo = pItem;
		pItemInfo->ItemNum = pMsg->ItemNum;
		pItemInfo->ResetRealItemInfo();
	}
	// end 2009-04-08 by bhsohn  ұ,  ʱȭ ý ߰ 
}

VOID CAtumApplication::FieldSocketStoreLogGuildItemOK(MSG_FC_STORE_LOG_GUILD_ITEM_OK* pMsg)
{
	CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
	pStore->StringInOrderBound(pMsg);

}
VOID CAtumApplication::FieldSocketStoreLogGuildItemOKHeader()
{
	CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
	pStore->HeaderGuildLog();
}
VOID CAtumApplication::FieldSocketStoreLogGuildItemOKDone()
{
	CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
	pStore->DoneGuildLog();

}
VOID CAtumApplication::FieldSocketBattleAttackFindOk(MSG_FC_BATTLE_ATTACK_FIND_OK* pMsg)
{
	// 2005-08-05 by ispark
	// ̻    -  ҽ ˻   ־.
	if(!m_pScene->m_pWeaponData)
		return;
	CWeapon * pNode = (CWeapon *)m_pScene->m_pWeaponData->m_pChild;
	while(pNode)
	{
		if( (pNode->m_dwPartType == _MISSILE || pNode->m_dwPartType == _ROCKET ) &&
			pMsg->AttackIndex == ((CWSlowData*)pNode)->m_nClientIndex && 
			pMsg->WeaponIndex == ((CWSlowData*)pNode)->m_nWeaponIndex)
		{
			((CWSlowData*)pNode)->m_dwWeaponState = _EXPLODING;

			if(pMsg->TargetIndex >= MONSTER_CLIENT_INDEX_START_NUM)
			{
				CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->TargetIndex);
				if(itMonster != m_pScene->m_mapMonsterList.end())
				{
					D3DXVec3Normalize(&itMonster->second->m_vAttackVel,&(itMonster->second->m_vPos - ((CWSlowData*)pNode)->m_vPos));
					itMonster->second->m_bAniColl = TRUE;
					itMonster->second->m_fAniCollTime = 1.0f;
				}
			}
			break;
		}

		pNode = (CWeapon *)pNode->m_pNext;
	}
}

VOID CAtumApplication::FieldSocketBattleDropMineOk(MSG_FC_BATTLE_DROP_MINE_OK* pMsg)
{
	if(m_pScene->m_pWeaponData)
	{
		CAtumNode * pWeapon = NULL;
#ifdef _DEBUG
		pWeapon = m_pScene->m_pWeaponData->m_pChild;
		while(pWeapon)
		{
			if( pWeapon->m_dwPartType == _MINE && 
				((CWeaponMineData *)pWeapon)->m_nFieldItemIndex == pMsg->ItemFieldIndex)
			{
				DWORD dwState = ((CWeaponMineData *)pWeapon)->m_dwWeaponState;
				DBGOUT( "MSG_FC_BATTLE_DROP_MINE_OK, Mine DUPLICATE[ItemFieldIndex == %d]\n",pMsg->ItemFieldIndex);
//				return ;
			}
			pWeapon = (CWeaponMineData *)pWeapon->m_pNext;
		}
#endif
		pWeapon = new CWeaponMineData(pMsg);
		pWeapon = (CWeaponMineData *)m_pScene->m_pWeaponData->AddChild(pWeapon);
		if(m_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->AttackIndex)
		{
			m_pShuttleChild->ResetSecondaryWeaponBodyCondition(WEAPON_BODYCON_FIRE_1);
			m_pShuttleChild->ResetSecondaryWeaponBodyCondition(WEAPON_BODYCON_FIRE_1, FALSE);
			m_pShuttleChild->m_pSecondaryWeapon->SetWeaponCount(pMsg->RemainedBulletFuel);
			if(m_pShuttleChild->m_pSecondaryWeapon)
			{
				m_pShuttleChild->m_pSecondaryWeapon->AddMine( (CWeaponMineData *)pWeapon );
			}
		}
	}
}

VOID CAtumApplication::FieldSocketBattleMineAttackOk(MSG_FC_BATTLE_MINE_ATTACK_OK* pMsg)
{
//	DBGOUT("MSG_FC_BATTLE_MINE_ATTACK_OK\n");
	if(!m_pScene->m_pWeaponData)
		return ;
	CWeapon * pWeapon = (CWeapon *)m_pScene->m_pWeaponData->m_pChild;
	while(pWeapon)
	{
		if( pWeapon->m_dwPartType == _MINE && 
			((CWeaponMineData *)pWeapon)->m_nFieldItemIndex == pMsg->ItemFieldIndex &&
			((CWeaponMineData *)pWeapon)->m_dwWeaponState == _NORMAL)
		{
			// Effect ߰ؾ
			if(IS_VALID_CLIENT_INDEX(pMsg->TargetInfo.TargetIndex))
			{
				if(pMsg->TargetInfo.TargetIndex == m_pShuttleChild->m_myShuttleInfo.ClientIndex)
				{
					pWeapon->m_pTarget = m_pShuttleChild;
					((CWeaponMineData *)pWeapon)->m_nTargetItemFieldIndex = pMsg->TargetInfo.TargetItemFieldIndex;
					pWeapon->m_dwWeaponState = _EXPLODING;
				}
				else
				{
					CMapEnemyIterator itEnemy = m_pScene->m_mapEnemyList.find(pMsg->TargetInfo.TargetIndex);
					if(itEnemy != m_pScene->m_mapEnemyList.end())
					{
						pWeapon->m_pTarget = itEnemy->second;
						((CWeaponMineData *)pWeapon)->m_nTargetItemFieldIndex = pMsg->TargetInfo.TargetItemFieldIndex;
						pWeapon->m_dwWeaponState = _EXPLODING;
					}
				}
				return;
			}
			else
			{
				CMapMonsterIterator itMonster = m_pScene->m_mapMonsterList.find(pMsg->TargetInfo.TargetIndex);
				if(itMonster != m_pScene->m_mapMonsterList.end())
				{
					pWeapon->m_pTarget = itMonster->second;
					((CWeaponMineData *)pWeapon)->m_nTargetItemFieldIndex = pMsg->TargetInfo.TargetItemFieldIndex;
					pWeapon->m_dwWeaponState = _EXPLODING;
					return;
				}
			}
			//   Ŭ̾Ʈ  ۸ 
			pWeapon->m_bUsing = FALSE;
			return;
		}
		pWeapon = (CWeapon *)pWeapon->m_pNext;
	}
}

VOID CAtumApplication::FieldSocketBattleMineAttackFindOk(MSG_FC_BATTLE_MINE_ATTACK_FIND_OK* pMsg)
{
	ASSERT_ASSERT(m_pScene->m_pWeaponData);
	CWeapon * pWeapon = (CWeapon *)m_pScene->m_pWeaponData->m_pChild;
	while(pWeapon)
	{
		if( pWeapon->m_dwPartType == _MINE &&
			((CWeaponMineData *)pWeapon)->m_nFieldItemIndex == pMsg->ItemFieldIndex)
		{
			if(!COMPARE_BODYCON_BIT(pWeapon->m_bodyCondition,BODYCON_HIT_MASK))
			{
				pWeapon->m_bodyCondition = BODYCON_HIT_MASK;
				if(pWeapon->m_pCharacterInfo)
					pWeapon->m_pCharacterInfo->ChangeBodyCondition(pWeapon->m_bodyCondition);
			}
			pWeapon->m_dwWeaponState = _EXPLODED;
			((CWeaponMineData *)pWeapon)->m_nFieldItemIndex = 0xFFFFFFFF;
			return;
		}
		pWeapon = (CWeapon *)pWeapon->m_pNext;
	}
}

VOID CAtumApplication::FieldSocketTimerStartTimer(MSG_FC_TIMER_START_TIMER* pMsg)
{	
	m_pShuttleChild->m_timeProcess.StartTimer(pMsg);
}

VOID CAtumApplication::FieldSocketTimerStopTimer(MSG_FC_TIMER_STOP_TIMER* pMsg)
{
	m_pShuttleChild->m_timeProcess.StopTimer(pMsg);	
}

VOID CAtumApplication::FieldSocketTimerUpdateTimer(MSG_FC_TIMER_UPDATE_TIMER* pMsg)
{
	m_pShuttleChild->m_timeProcess.UpdateTimer(pMsg);
}

VOID CAtumApplication::FieldSocketTimerPauseTimer(MSG_FC_TIMER_PAUSE_TIMER* pMsg)
{
	m_pShuttleChild->m_timeProcess.PauseTimer(pMsg);
}

VOID CAtumApplication::FieldSocketTimerContinueTimer(MSG_FC_TIMER_CONTINUE_TIMER* pMsg)
{
	m_pShuttleChild->m_timeProcess.ContinueTimer(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketSKillPrepareUseOk(MSG_FC_SKILL_PREPARE_USE_OK* pMsg)
/// \brief		ߵ ų Ʈ ߰Ѵ.
/// \author		jschoi
/// \date		2004-10-12 ~ 2004-10-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketSKillPrepareUseOk(MSG_FC_SKILL_PREPARE_USE_OK* pMsg)
{
	ITEM* pSkill = g_pDatabase->GetServerItemInfo(pMsg->SkillItemID.ItemNum);
	if(pMsg->ClientIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		CSkillInfo *pSkillInfo = g_pShuttleChild->m_pSkill->FindItemSkill(pSkill->ItemNum);
		pSkillInfo->PrepareSkillFromServer();

		// Ʈ
			g_pShuttleChild->m_pSkillEffect->CreateSkillEffect(pMsg->SkillItemID.ItemNum,BODYCON_CHARGING_MASK);
	}
	else // Enemy or Monster
	{
		CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->ClientIndex );
		if(pUnit)
		{
//			if(IS_EXIST_DES_PARAM(pSkill,DES_SKILL_HYPERSHOT))
//			{//ۼ.
//			}
//			else if(IS_EXIST_DES_PARAM(pSkill,DES_SKILL_BIG_BOOM))
//			{// .
//			}
//			else 
//			{// ¡
//			}
		
			// Ʈ
			pUnit->m_pSkillEffect->CreateSkillEffect(pMsg->SkillItemID.ItemNum,BODYCON_CHARGING_MASK);
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketCancelPrepareOk(MSG_FC_SKILL_CANCEL_PREPARE_OK* pMsg)
/// \brief		ߵ ų Ʈ ߰Ѵ.
/// \author		jschoi
/// \date		2004-10-12 ~ 2004-10-12
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCancelPrepareOk(MSG_FC_SKILL_CANCEL_PREPARE_OK* pMsg)
{
	if(pMsg->ClientIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		g_pShuttleChild->m_pSkillEffect->DeleteSkillEffect(pMsg->SkillItemID.ItemNum);
	}
	else // Enemy or Monster
	{
		CUnitData* pUnit = g_pScene->FindUnitDataByClientIndex( pMsg->ClientIndex );
		if(pUnit)
		{
		    pUnit->m_pSkillEffect->DeleteSkillEffect(pMsg->SkillItemID.ItemNum);	
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketMoveWeaponVelOk(MSG_FC_MOVE_WEAPON_VEL_OK* pMsg)
/// \brief		MSG_FC_MOVE_WEAPON_VEL_OK, Enemy,(Monster) WeaponVeló
/// \author		dhkwon
/// \date		2004-10-18 ~ 2004-10-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMoveWeaponVelOk(MSG_FC_MOVE_WEAPON_VEL_OK* pMsg)
{
	CUnitData* pUnit = m_pScene->FindUnitDataByClientIndex( pMsg->ClientIndex );
	if( pUnit && pUnit != m_pShuttleChild )
	{
		pUnit->SetWeaponVelFromServer( (D3DXVECTOR3)pMsg->WeaponVel );
		// 2010-06-15 by shcho&hslee ý -  
		pUnit->SetPetVelFromServer( pMsg->PetLeftVel, pMsg->PetRightVel );
		// end 2010-06-15 by shcho&hslee ý -  
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCountdownStart(MSG_FC_COUNTDOWN_START* pMsg)
/// \brief		īƮ ٿ ó(īƮ )
/// \author		ydkim
/// \date		2004-10-20 ~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCountdownStart(MSG_FC_COUNTDOWN_START* pMsg)
{
	g_pGameMain->m_pGameCountDown->SetCountDown(pMsg->byCountdownType,pMsg->nWaitingSecond, COLOR_VOIP);	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCityCheckWarpStateOk(MSG_FC_CITY_CHECK_WARP_STATE_OK* pMsg)
/// \brief		ÿ  Ѱ  û  亯 ó
/// \author		jschoi
/// \date		2004-10-25 ~ 2004-10-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCityCheckWarpStateOk(MSG_FC_CITY_CHECK_WARP_STATE_OK* pMsg)
{
	if(pMsg->Err == NOERROR)
	{
		SAFE_DELETE(g_pShuttleChild->m_pCinemaCamera);
		if( m_dwGameState==_CITY &&
			g_pShuttleChild->InitCinemaUnit(PATTERN_UNIT_CITY_OUT, TRUE) == TRUE)
		{
			g_pShuttleChild->m_nCurrentPatternNumber = PATTERN_UNIT_CITY_OUT;
			StartFadeEffect(FALSE,2,D3DCOLOR_ARGB(0,0,0,0));
			g_pD3dApp->m_pSound->PlayD3DSound( SOUND_TAKEINGOFF_IN_CITY, g_pShuttleChild->m_vPos, FALSE);
			g_pShuttleChild->ChangeSingleBodyCondition(BODYCON_TAKEOFF_MASK);

			g_pShuttleChild->ChangeUnitState( _TAKINGOFF );

			CAppEffectData * pEffect = new CAppEffectData(RC_EFF_LANDING_TAKEOFF,MAP_TYPE_CITY_UNIT_POS);
			pEffect->ChangeBodyCondition(BODYCON_LANDED_MASK);
			g_pD3dApp->m_pEffectList->AddChild(pEffect);
		}
		else
		{
			if(g_pShuttleChild->m_nEventType == EVENT_CITY_OUTDOOR)
			{
				g_pInterface->m_pCityBase->SendEventRequestWarpToOutdoor();
			}
			else if(g_pShuttleChild->m_nEventType == EVENT_CITY_OUT_MOVE)
			{
				CINFCityWarp* pCityWarp = g_pInterface->m_pCityBase->GetCityWarp();
				ASSERT_ASSERT(pCityWarp);
				pCityWarp->SendFieldSocketRequestShopWarp();
			}
		}
	}
	else if(pMsg->Err == ERR_PROTOCOL_ALREADY_PARTY_BATTLE)
	{
		m_pChat->CreateChatChild(STRMSG_C_PARTY_0052,COLOR_PARTY);//"  ʾ  Ұմϴ."
	}
	else
	{

	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCitywarGetOccupyinfoOk(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK* pMsg)
/// \brief		   ´
/// \author		ydkim
/// \date		2005-02-14
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCitywarGetOccupyinfoOk(MSG_FC_CITYWAR_GET_OCCUPYINFO_OK* pMsg)
{
	CINFCityOccupy* pCityOccupy = NULL;
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(BUILDINGKIND_CITY_OCCUPY_INFO);
	if(it != g_pInterface->m_pCityBase->m_mapCityShop.end())
	{
		pCityOccupy = ((CINFCityOccupy*)it->second);		
	}
	if(pCityOccupy == NULL)
		return;
	pCityOccupy->m_vecInfoOccupy.clear();
	pCityOccupy->m_pTimeDef	= pMsg->CityWarOccupyInfo3.CityWarDefaultTime;

	if(pMsg->CityWarOccupyInfo3.OccupyGuildUID != INVALID_GUILD_UID)
	{
		wsprintf( pCityOccupy->strOccupyGuild, STRMSG_C_OCCUPY_0024, pMsg->CityWarOccupyInfo3.OccupyGuildName);//"[ɿ : %s]"
		pCityOccupy->m_nOccupyGuildMasterUID = pMsg->CityWarOccupyInfo3.OccupyGuildMasterCharacterUID;
		pCityOccupy->m_nOccupyGuildUID			= pMsg->CityWarOccupyInfo3.OccupyGuildUID;
		wsprintf( g_pInterface->m_pCityBase->m_strGuildMasterGr, 
			"\\g[%s]\\g%s",
			pMsg->CityWarOccupyInfo3.OccupyGuildName,
			pMsg->CityWarOccupyInfo3.szBriefing);
	}
	
	char strtemp[SIZE_MAX_CITY_BRIEFING_LENGTH];
	memset(strtemp, 0x00, SIZE_MAX_CITY_BRIEFING_LENGTH);

	SCITY_OCCUPY_INFO	CityWarOccupyInfo3 = pMsg->CityWarOccupyInfo3;							//   
	pCityOccupy->m_vecInfoOccupy.push_back(STRMSG_C_OCCUPY_0025);				// index 0//"\\g   *Է½ ʱⰪ *"

	wsprintf( strtemp, STRMSG_C_OCCUPY_0026, (int)(CityWarOccupyInfo3.fTexPercent));//"[%d%%  Ǿϴ]"
	pCityOccupy->m_vecInfoOccupy.push_back(strtemp);											// index 1	 
	memset(strtemp, 0x00, SIZE_MAX_CITY_BRIEFING_LENGTH);

	wsprintf( strtemp, STRMSG_C_OCCUPY_0027, //"[%d %d %d %d%d]"
		(int)CityWarOccupyInfo3.CityWarSettingTime.Year,
		(int)CityWarOccupyInfo3.CityWarSettingTime.Month,
		(int)CityWarOccupyInfo3.CityWarSettingTime.Day,
		(int)CityWarOccupyInfo3.CityWarSettingTime.Hour,
		(int)CityWarOccupyInfo3.CityWarSettingTime.Second);
	pCityOccupy->m_vecInfoOccupy.push_back(strtemp);											// index 2	OCCUPY_DATE_WAR
	memset(strtemp, 0x00, SIZE_MAX_CITY_BRIEFING_LENGTH);

//	m_vecInfoOccupy.push_back("[, ̻]");												// index 3	OCCUPY_USE_STORE
//	memset(strtemp, 0x00, SIZE_MAX_CITY_BRIEFING_LENGTH);
	
	///////////////////////////////////////////////////////////
	//
	vector<BUILDINGNPC*> VecBuildingNPC;
//	vector<int> vecNotOccupy;
//	vector<int> vecOccupy;

	VecBuildingNPC.clear();
	pCityOccupy->vecNotOccupy.clear();
	pCityOccupy->vecOccupy.clear();

	g_pDatabase->FindBuildingNPCListOccupyShop(g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex, 
		&VecBuildingNPC);
	pCityOccupy->SortStoreOccupyByVecBuildingNPC(&VecBuildingNPC);

	vector<BUILDINGNPC*>::iterator buildit = VecBuildingNPC.begin();
	while (buildit != VecBuildingNPC.end()) 
	{
		if((*buildit)->OwnerOrderNumber <= CityWarOccupyInfo3.nDefenseCounts)
		{
			// ɵ 			
			pCityOccupy->vecOccupy.push_back((int)(*buildit)->MapIndex);
		}
		else 
		{
			// ɵ  
			pCityOccupy->vecNotOccupy.push_back((int)(*buildit)->MapIndex);
		}
			
		buildit++;
	}
	//
	///////////////////////////////////////////////////////////

	if((int)pCityOccupy->vecOccupy.size() == 0)
	{
		pCityOccupy->m_vecInfoOccupy.push_back(STRMSG_C_OCCUPY_0028);	//"[ɵ  ϴ]"
	}
	else
	{
		wsprintf( strtemp, STRMSG_C_OCCUPY_0029, (int)pCityOccupy->vecOccupy.size());//"%d   Ǿϴ."
		pCityOccupy->m_vecInfoOccupy.push_back(strtemp);										// index 4	OCCUPY_OCCUPY_SHOP
		memset(strtemp, 0x00, SIZE_MAX_CITY_BRIEFING_LENGTH);
	}
	wsprintf( strtemp, STRMSG_C_OCCUPY_0030, (int)CityWarOccupyInfo3.nDefenseCounts);//"%dȸ  ."
	pCityOccupy->m_vecInfoOccupy.push_back(strtemp);										// index 4	OCCUPY_OCCUPY_SHOP
	memset(strtemp, 0x00, SIZE_MAX_CITY_BRIEFING_LENGTH);

	wsprintf( strtemp, STRMSG_C_OCCUPY_0031, (int)CityWarOccupyInfo3.nSumOfTex);//"[ \\r%d\\r(SPI)]."
	pCityOccupy->m_vecInfoOccupy.push_back(strtemp);										// index 7	OCCUPY_TEX_INFO	
	memset(strtemp, 0x00, SIZE_MAX_CITY_BRIEFING_LENGTH);
	
	wsprintf( strtemp, "%s", CityWarOccupyInfo3.szBriefing);
	pCityOccupy->m_vecInfoOccupy.push_back(strtemp);													// index 5	OCCUPY_GREATING
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCitywarBringSumoftexOk(MSG_FC_CITYWAR_BRING_SUMOFTEX_OK* pMsg)
/// \brief		   ´
/// \author		ydkim
/// \date		2005-02-15~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCitywarBringSumoftexOk(MSG_FC_CITYWAR_BRING_SUMOFTEX_OK* pMsg)
{
	char buf[128];
	memset(buf, 0x00, 128);
	wsprintf( buf, STRMSG_C_OCCUPY_0032, (int)pMsg->nBroughtSumOfTex);//"%d() Խϴ."
	m_pChat->CreateChatChild(buf,COLOR_SYSTEM);	
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCitywarStartWar(MSG_FC_CITYWAR_START_WAR* pMsg)
/// \brief		   ˸
/// \author		ydkim
/// \date		2005-02-15~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCitywarStartWar(MSG_FC_CITYWAR_START_WAR* pMsg)
{
	if(NULL == g_pGameMain->GetMapNameByIndex(pMsg->CityWarMapIndex3))
	{
		return;
	}
	char buf[256];
	memset(buf, 0x00, 256);
	wsprintf(buf, g_pGameMain->GetMapNameByIndex(pMsg->CityWarMapIndex3));
	
	char szNotice[1024];
	sprintf(szNotice, STRMSG_C_OCCUPY_0033, buf); //"\"%s\"   Ǿϴ."
	m_pChat->CreateChatChild(szNotice, COLOR_SYSTEM);	

	//   	
	if(INVALID_GUILD_UID == pMsg->OccupyGuildUID3)
	{		
		wsprintf(szNotice, STRMSG_C_OCCUPY_0034);//" NPC Դϴ."
	}
	else
	{
		wsprintf(szNotice, STRMSG_C_OCCUPY_0035, pMsg->szOccupyGuildName3);//" %s Դϴ."
	}
	m_pChat->CreateChatChild(szNotice, COLOR_SYSTEM);

	sprintf(szNotice, STRMSG_C_OCCUPY_0036, buf); //"\"%s\" ʿ  (  )"
	m_pChat->CreateChatChild(szNotice, COLOR_SYSTEM);
	m_pChat->CreateChatChild(STRMSG_C_OCCUPY_0037, COLOR_SYSTEM);//"    ÷  ˴ϴ.",

	if(	g_pShuttleChild && 
		g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex == pMsg->CityWarMapIndex3)
	{
		g_pShuttleChild->m_byCityWarTeamType = CITYWAR_TEAM_TYPE_DEFENSER;
		g_pShuttleChild->m_pPkNormalTimer->SetCityWar();

		if(g_pScene)
		{
			g_pScene->ChangeAllEnemyCityWarTeamType(CITYWAR_TEAM_TYPE_DEFENSER); //   Ѵ.
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCitywarEndWar(MSG_FC_CITYWAR_END_WAR* pMsg)
/// \brief		   ˸
/// \author		ydkim
/// \date		2005-02-15~
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCitywarEndWar(MSG_FC_CITYWAR_END_WAR* pMsg)
{	
	if(NULL == g_pGameMain->GetMapNameByIndex(pMsg->CityWarMapIndex3))
	{
		return;
	}
	char buf[256];
	memset(buf, 0x00, 256);
	wsprintf(buf, g_pGameMain->GetMapNameByIndex(pMsg->CityWarMapIndex3));

	char szNotice[1024];
	sprintf(szNotice, STRMSG_C_OCCUPY_0038, buf);//"\"%s\"   Ǿϴ."
	m_pChat->CreateChatChild(szNotice,COLOR_SYSTEM);

	if(INVALID_GUILD_UID == pMsg->OccupyGuildUID3)
	{
		sprintf(szNotice, STRMSG_C_OCCUPY_0039, buf);//"\"NPC\" \"%s\" Ͽϴ."
	}
	else
	{
		sprintf(szNotice, STRMSG_C_OCCUPY_0040, pMsg->szOccupyGuildName3, buf); //"\"%s\" \"%s\" Ͽϴ."
	}
	m_pChat->CreateChatChild(szNotice,COLOR_SYSTEM);
	
	ATUM_DATE_TIME tmTime = pMsg->atimeNextCityWarDefaultTime;
	tmTime.AddDateTime(0, 0, 0, TIMEGAP_CITYWAR_CHANGEABLE_TERM_HOUR, 0, 0);
	sprintf(szNotice, STRMSG_C_OCCUPY_0041			//" \"%s\"  ð"
		, buf);
	m_pChat->CreateChatChild(szNotice,COLOR_SYSTEM);
	//%s ~ %s ˴ϴ.
	sprintf(szNotice, STRMSG_C_OCCUPY_0042			//"%s ~ %s Ǹ "
		, pMsg->atimeNextCityWarDefaultTime.GetLocalDateTimeString(string(),GetLanguageType(), TRUE)
		, tmTime.GetLocalDateTimeString(string(),GetLanguageType(), TRUE));
	m_pChat->CreateChatChild(szNotice,COLOR_SYSTEM);

	sprintf(szNotice, STRMSG_C_OCCUPY_0043);//"ɿ忡  ð   ֽϴ."
	m_pChat->CreateChatChild(szNotice,COLOR_SYSTEM);

	if(	g_pShuttleChild &&
		g_pShuttleChild->m_myShuttleInfo.MapChannelIndex.MapIndex == pMsg->CityWarMapIndex3)
	{
		if(g_pShuttleChild->m_pPkNormalTimer)
		{
			g_pShuttleChild->m_pPkNormalTimer->ReleaseCityWar();
		}
		
		g_pShuttleChild->m_byCityWarTeamType = CITYWAR_TEAM_TYPE_NORMAL;

		if(g_pScene)
		{
			g_pScene->ChangeAllEnemyCityWarTeamType(CITYWAR_TEAM_TYPE_NORMAL); //   Ѵ
		}
	}
}



/////////////////////////////////////////////////////////////////////////////// 
/// \fn			FieldSocketCharacterGetCashMoneyCountOk(MSG_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK* pMsg) 
/// \brief		 ĳ Ӵϸ ´(  ѹ û Ѵ) 
/// \author		ydkim 
/// \date		2005-02-15~ 
/// \warning	 
/// 
/// \param		 
/// \return		 
/////////////////////////////////////////////////////////////////////////////// 
VOID CAtumApplication::FieldSocketCharacterGetCashMoneyCountOk(MSG_FC_CHARACTER_GET_CASH_MONEY_COUNT_OK* pMsg) 
{ 
	CINFCityCashShop* pCityCash = NULL; 
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(BUILDINGKIND_CASH_SHOP); 
	if(it != g_pInterface->m_pCityBase->m_mapCityShop.end()) 
	{ 
		pCityCash = ((CINFCityCashShop*)it->second);		 
	} 
	if(pCityCash == NULL) 
		return; 
	 
	pCityCash->SetCashMoney(pMsg->nMCash); 
	pCityCash->SetGiftCardCashPoint(pMsg->nGiftCard);
	if(pCityCash->IsInputItemDone())
	{
		g_pD3dApp->m_bRequestEnable = TRUE;			// 2006-07-07 by ispark, ޼  Ϸ. ĳ ׻   ĳ Ӵϸ ޴´.
	}
} 

/////////////////////////////////////////////////////////////////////////////// 
/// \fn			FieldSocketCharacterChangeCharacterModeOk(MSG_FC_CHARACTER_CHANGE_CHARACTER_MODE_OK* pMsg)
/// \brief		ĳ  ȯ
/// \author		ydkim 
/// \date		2005-07-26~ 
/// \warning	 
/// 
/// \param		 
/// \return		 
/////////////////////////////////////////////////////////////////////////////// 
VOID CAtumApplication::FieldSocketCharacterChangeCharacterModeOk(MSG_FC_CHARACTER_CHANGE_CHARACTER_MODE_OK* pMsg)
{
	if(pMsg->ClientIndex != m_pShuttleChild->m_myShuttleInfo.ClientIndex)
	{
		m_pScene->ChangeEnemyCharacterMode(pMsg);
	}
} 



///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketSkillUseAck(MSG_FC_SKILL_CONFIRM_USE_ACK* pMsg)
/// \brief		ų  㰡 
/// \author		ispark
/// \date		2005-12-03 ~ 2005-12-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketSkillConfirmUseAck(MSG_FC_SKILL_CONFIRM_USE_ACK* pMsg)
{
	char szNotice[1024] = {0, };
	vector<PARTYENEMYINFO*>::iterator itParty = g_pShuttleChild->m_pClientParty->m_vecPartyEnemyInfo.begin();
	while(itParty != g_pShuttleChild->m_pClientParty->m_vecPartyEnemyInfo.end())
	{
		if((*itParty)->m_ImPartyMemberInfo.CharacterUniqueNumber == pMsg->TargetCharacterUID)
		{
			wsprintf(szNotice, "%s", (*itParty)->m_ImPartyMemberInfo.CharacterName);
			break;
		}

		itParty++;
	}

	ITEM* pItem = g_pShuttleChild->m_pSkill->FindItem(pMsg->UsingSkillItemNum);
	if(pItem)
	{
		if(pMsg->bYesOrNo)
		{
			// 
			g_pShuttleChild->m_pSkill->SetTargetIndex(0);
			g_pShuttleChild->m_pSkill->SetCharacterUID(pMsg->TargetCharacterUID);

			CSkillInfo* pSkillInfo = g_pShuttleChild->m_pSkill->FindItemSkill(pMsg->UsingSkillItemNum);
			pSkillInfo->SetCheckAckWaitingTime(0);

			// 2008-02-26 by bhsohn  Ʒ   
			//  ̸ 
			g_pD3dApp->ConevertArenaRenderUserName(g_pD3dApp->GetArenaState(), szNotice);

			wsprintf(szNotice, STRMSG_C_051203_0004, szNotice, pItem->ItemName);//"%s [%s] ų  ϼ̽ϴ."
			m_pChat->CreateChatChild(szNotice,COLOR_ERROR);
		}
		else
		{			
			// 2008-02-26 by bhsohn  Ʒ   
			//  ̸ 
			g_pD3dApp->ConevertArenaRenderUserName(g_pD3dApp->GetArenaState(), szNotice);

			// ź
			wsprintf(szNotice, STRMSG_C_051203_0003, szNotice, pItem->ItemName);//"%s [%s] ų ź ϼ̽ϴ."
			m_pChat->CreateChatChild(szNotice,COLOR_ERROR);

			// ų 
			CSkillInfo* pSkillInfo = g_pShuttleChild->m_pSkill->FindItemSkill(pMsg->UsingSkillItemNum);
			g_pGameMain->m_pInfSkill->DeleteSkillInfo(pSkillInfo);
			pSkillInfo->ReleaseParamFactor();
			g_pShuttleChild->m_pSkill->EraseUsingSkill(pSkillInfo);
		}

		// 2009. 04. 22 by ckPark ݿν  Ÿٿ   ذ

		g_pShuttleChild->m_pSkill->SetCharacterUID( 0 );

		// end 2009. 04. 22 by ckPark ݿν  Ÿٿ   ذ
	}
	else
	{
		DBGOUT("%d ų  \n", pMsg->UsingSkillItemNum);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		ispark
/// \date		2005-12-03 ~ 2005-12-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketSkillConfirmUse(MSG_FC_SKILL_CONFIRM_USE* pMsg)
{
	// 2006-08-02 by ispark, λ̸ ݿ   ޼ Ұ


	// 2009. 04. 06 by ckPark ݿν ٸ Ÿ ų  
// 	if(g_pInterface->m_pBazaarShop)
// 	{
// 		return;
// 	}
	
	if( g_pInterface->m_pBazaarShop
		|| g_pShuttleChild->m_pSkill->GetSkillConfirm().AttackCharacterUID
		|| g_pShuttleChild->m_pSkill->GetSkillConfirm().TargetCharacterUID )
	{
		MSG_FC_SKILL_CONFIRM_USE_ACK sMsg;
		sMsg.bYesOrNo = FALSE;				// ź
		sMsg.AttackCharacterUID		= pMsg->AttackCharacterUID;		// ų  CharacterUID
		sMsg.TargetCharacterUID		= pMsg->TargetCharacterUID;		// ų Ÿ CharacterUID
		sMsg.UsingSkillItemNum		= pMsg->UsingSkillItemNum;		//  ų ItemNum
		sMsg.SkillConfirmUseUID		= pMsg->SkillConfirmUseUID;
		g_pFieldWinSocket->SendMsg(T_FC_SKILL_CONFIRM_USE_ACK, (char*)&sMsg, sizeof(sMsg));
		return;
	}
	// end 2009. 04. 06 by ckPark ݿν ٸ Ÿ ų  



	// Ÿ Է
	g_pShuttleChild->m_pSkill->SetSkillConfirmData(pMsg);

	char chMsg[128];
	// 2008-02-26 by bhsohn  Ʒ   
	//wsprintf(chMsg, STRMSG_C_051203_0002, pMsg->szAttackCharacterName); //"%s ݿθ ̽ϴ. Ͻðڽϱ?"
	char szCharName[SIZE_MAX_ARENA_FULL_NAME];
	STRNCPY_MEMSET(szCharName, pMsg->szAttackCharacterName, SIZE_MAX_ARENA_FULL_NAME);	
	//  ̸ 
	g_pD3dApp->ConevertArenaRenderUserName(g_pD3dApp->GetArenaState(), szCharName);
	wsprintf(chMsg, STRMSG_C_051203_0002, szCharName); //"%s ݿθ ̽ϴ. Ͻðڽϱ?"
	
	g_pGameMain->m_pInfWindow->AddTimeMsgBox(chMsg, _Q_SKILL_CALLOFHERO,10,STRMSG_C_060724_0000); // 10ʸ ٸ.
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCityCheckWarpStateOk(MSG_FC_CITY_CHECK_WARP_STATE_OK* pMsg)
/// \brief		ÿ  Ѱ  û  亯 ó
/// \author		jschoi
/// \date		2004-10-25 ~ 2004-10-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBattleShowDamage(MSG_FC_BATTLE_SHOW_DAMAGE* pMsg)
{
#ifdef _DEBUG
	if(COMPARE_RACE(m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION|RACE_GAMEMASTER))
	{
		char msg[MAX_PATH];
		CUnitData* pTarget = m_pScene->FindUnitDataByClientIndex(pMsg->TargetIndex);
		if( pTarget )
		{
			if(pTarget->m_dwPartType == _ENEMY)
			{
				wsprintf( msg, STRMSG_C_INTERFACE_0050, //"%s %d  Ծϴ.(DamageKind:%d)"
					((CEnemyData*)pTarget)->m_infoCharacter.CharacterInfo.CharacterName,
  					pMsg->AmountDamage, pMsg->DamageKind );
			}
			else if(pTarget->m_dwPartType == _SHUTTLE)
			{
				wsprintf( msg, STRMSG_C_INTERFACE_0050, 
					m_pShuttleChild->m_myShuttleInfo.CharacterName,
					pMsg->AmountDamage, pMsg->DamageKind );
			}
			else if(pTarget->m_dwPartType == _MONSTER)
			{
				wsprintf( msg, STRMSG_C_MONSTER_0003, //"%s() %d  Ծϴ.(DamageKind:%d)"
					((CMonsterData*)pTarget)->m_pMonsterInfo->MonsterName,
					pMsg->AmountDamage, pMsg->DamageKind );
			}
			else if(pTarget->m_dwPartType == _ADMIN)	// 2005-10-25 by ispark
			{
				wsprintf( msg, STRMSG_C_MONSTER_0003, //"%s() %d  Ծϴ.(DamageKind:%d)"
					"GM",
					pMsg->AmountDamage, pMsg->DamageKind );
			}			
			
			m_pChat->CreateChatChild(msg,COLOR_VOIP);
		}
	}
#endif
	// ShuttleChild  Critical Damage üѴ.
	if(g_pShuttleChild->m_myShuttleInfo.ClientIndex == pMsg->TargetIndex)
	{
		pMsg->DamageKind = DAMAGEKIND_CRITICAL;

		// 2008-11-13 by bhsohn ̽ƽ ۾
		// 浹 
		if(pMsg->byIsPrimaryWeapon)
		{
			g_pD3dApp->SetJoyStickFeedback(TRUE, JOY_FEED_WEAPON1_DAMAGE);
		}
		else
		{
			g_pD3dApp->SetJoyStickFeedback(TRUE, JOY_FEED_WEAPON2_DAMAGE);
		}
		// end 2008-11-13 by bhsohn ̽ƽ ۾
	}

//  2005-06-02 by ydkim
//   ̱ ShowInterface ̰ Ѵ 
//	if(g_pInterface->m_bShowInterface)
//	{
    // 2011. 03. 08 by jskim 3 
	g_pGameMain->m_pDamageView->RecvBattleShowDamage( pMsg->TargetIndex, pMsg->AmountDamage, pMsg->DamageKind, pMsg->MultiTargetIndex );
    // end 2011. 03. 08 by jskim 3 
//	}
//	else
//	{
//		g_pGameMain->m_pDamageView->vecDamage.clear();
//	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketEventCallWarpEventReqeust(MSG_FC_EVENT_CALL_WARP_EVENT_REQUEST* pMsg)
/// \brief		̺Ʈ 
/// \author		ispark
/// \date		2006-07-24 ~ 2006-07-24
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventCallWarpEventReqeust(MSG_FC_EVENT_CALL_WARP_EVENT_REQUEST* pMsg)
{
	// 2006-08-02 by ispark, λ̸ ̺Ʈ  ޼ Ұ
	if(g_pInterface->m_pBazaarShop)
	{
		return;
	}
	// 2007-05-15 by dgwoo ð Ʒ  Լ .
	//g_pGameMain->m_pInfWindow->AddMsgBox(pMsg->szUserMessage, _Q_EVENT_CALL_WARP_REQUEST, pMsg->dwCallWarpEventID0, 0, (pMsg->dwSupportTermTick0 / 1000));
	g_pGameMain->m_pInfWindow->AddTimeMsgBox(pMsg->szUserMessage, _Q_EVENT_CALL_WARP_REQUEST,(pMsg->dwSupportTermTick0 / 1000),STRMSG_C_060724_0000, pMsg->dwCallWarpEventID0,0);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarSellPutItemOK(MSG_FC_BAZAAR_SELL_PUT_ITEM_OK* pMsg)
/// \brief		  
/// \author		ispark
/// \date		2006-07-28 ~ 2006-07-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarSellPutItemOK(MSG_FC_BAZAAR_SELL_PUT_ITEM_OK* pMsg)
{
	g_pInterface->m_pBazaarShop->Recv_RegSellItemOK(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		ispark
/// \date		2006-07-31 ~ 2006-07-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarBuyPutItemOK(MSG_FC_BAZAAR_BUY_PUT_ITEM_OK* pMsg)
{
	g_pInterface->m_pBazaarShop->Recv_RegBuyItemOK(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarSellCancelItemOK(MSG_FC_BAZAAR_SELL_CANCEL_ITEM_OK* pMsg)
/// \brief		  
/// \author		ispark
/// \date		2006-07-28 ~ 2006-07-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarSellCancelItemOK(MSG_FC_BAZAAR_SELL_CANCEL_ITEM_OK* pMsg)
{
	g_pInterface->m_pBazaarShop->Recv_DelSellItemOK(pMsg);
}
	
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarBuyCancelItemOK(MSG_FC_BAZAAR_BUY_CANCEL_ITEM_OK* pMsg)
/// \brief		  
/// \author		ispark
/// \date		2006-07-31 ~ 2006-07-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarBuyCancelItemOK(MSG_FC_BAZAAR_BUY_CANCEL_ITEM_OK* pMsg)
{
	g_pInterface->m_pBazaarShop->Recv_DelBuyItemOK(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarSellStartOK()
/// \brief		 Ǹ  
/// \author		ispark
/// \date		2006-07-28 ~ 2006-07-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarSellStartOK()
{
	g_pInterface->m_pBazaarShop->Recv_OpenShopOK();
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarBuyStartOK()
/// \brief		 Ǹ  
/// \author		ispark
/// \date		2006-07-28 ~ 2006-07-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarBuyStartOK()
{
	g_pInterface->m_pBazaarShop->Recv_OpenShopOK();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarInfoOK(MSG_FC_BAZAAR_INFO_OK* pMsg)
/// \brief		  
/// \author		ispark
/// \date		2006-07-28 ~ 2006-07-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarInfoOK(MSG_FC_BAZAAR_INFO_OK* pMsg)
{
	g_pShuttleChild->CheckBazaarInfo(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarSellReQuestItemListOK(MSG_FC_BAZAAR_SELL_REQUEST_ITEMLIST_OK* pMsg)
/// \brief		   Ʈ 
/// \author		ispark
/// \date		2006-07-29 ~ 2006-07-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarSellReQuestItemListOK(MSG_FC_BAZAAR_SELL_REQUEST_ITEMLIST_OK* pMsg)
{
	//  
	g_pInterface->VisitBazaarShop();

	//  
	SBAZAAR_SELL_ITEM * pSellItemInfo = (SBAZAAR_SELL_ITEM *)((char *)pMsg + sizeof(MSG_FC_BAZAAR_SELL_REQUEST_ITEMLIST_OK));
	for(int i = 0; i < pMsg->nItemListCnts0; i++)
	{
		g_pInterface->m_pBazaarShop->Recv_SetSellItem(pSellItemInfo);
		pSellItemInfo++;
	}

	m_bRequestEnable = TRUE;			//  ޼ Ϸ
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarBuyReQuestItemListOK(MSG_FC_BAZAAR_BUY_REQUEST_ITEMLIST_OK* pMsg)
/// \brief		  Ʈ 
/// \author		ispark
/// \date		2006-07-31 ~ 2006-07-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarBuyReQuestItemListOK(MSG_FC_BAZAAR_BUY_REQUEST_ITEMLIST_OK* pMsg)
{
	//  
	g_pInterface->VisitBazaarShop();

	//  
	SBAZAAR_BUY_ITEM * pBuyItemInfo = (SBAZAAR_BUY_ITEM *)((char *)pMsg + sizeof(MSG_FC_BAZAAR_BUY_REQUEST_ITEMLIST_OK));
	for(int i = 0; i < pMsg->nItemListCnts0; i++)
	{
		g_pInterface->m_pBazaarShop->Recv_SetBuyItem(pBuyItemInfo);
		pBuyItemInfo++;
	}

	m_bRequestEnable = TRUE;			//  ޼ Ϸ
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarSellItemEnchantlistOK(MSG_FC_BAZAAR_SELL_ITEM_ENCHANTLIST_OK* pMsg)
/// \brief		   þƮ Ʈ 
/// \author		ispark
/// \date		2006-07-29 ~ 2006-07-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarSellItemEnchantlistOK(MSG_FC_BAZAAR_SELL_ITEM_ENCHANTLIST_OK* pMsg)
{

	for(int i = 0; i < pMsg->nEnchatCnts; i++)
	{
		int EnchantItemNum = *(INT*)(((char*)pMsg)+sizeof(MSG_FC_BAZAAR_SELL_ITEM_ENCHANTLIST_OK)+sizeof(INT)*i);
		g_pInterface->m_pBazaarShop->Recv_SetSellEnchantItem(pMsg->itemUID, EnchantItemNum);
	}

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarCustomerInfoOK(MSG_FC_BAZAAR_CUSTOMER_INFO_OK* pMsg)
/// \brief		   α
/// \author		ispark
/// \date		2006-07-29 ~ 2006-07-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarCustomerInfoOK(MSG_FC_BAZAAR_CUSTOMER_INFO_OK* pMsg)
{
	g_pInterface->m_pBazaarShop->Recv_CustomerInfoOK(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarSellBuyItemOK(MSG_FC_BAZAAR_SELL_BUY_ITEM_OK* pMsg)
/// \brief		 Ǹ 
/// \author		ispark
/// \date		2006-07-29 ~ 2006-07-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarSellBuyItemOK(MSG_FC_BAZAAR_SELL_BUY_ITEM_OK* pMsg)
{
	g_pInterface->m_pBazaarShop->Recv_SellBuyItemOK(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketBazaarBuySellItemOK(MSG_FC_BAZAAR_BUY_SELL_ITEM_OK* pMsg)
/// \brief		  
/// \author		ispark
/// \date		2006-07-31 ~ 2006-07-31
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketBazaarBuySellItemOK(MSG_FC_BAZAAR_BUY_SELL_ITEM_OK* pMsg)
{
	g_pInterface->m_pBazaarShop->Recv_BuySellItemOK(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketNotifyServerShutdown()
/// \brief		 30  ڵ 
/// \author		ispark
/// \date		2006-08-04 ~ 2006-08-04
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketNotifyServerShutdown()
{
	if(m_bGameShutDown == FALSE)
	{
		g_pInterface->SetShutDownStart();
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \class		VOID CAtumApplication::
/// \brief		ǵ  ̺Ʈ  .
///
/// \author		dgwoo
/// \version	
/// \date		2006-08-10 ~ 2006-08-10
/// \warning	
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseRandomBoxOk(MSG_FC_ITEM_USE_RANDOMBOX_OK* pMsg)
{
	char buf[512];

	// 2008-08-26 by bhsohn ڽ ý 
	//g_pD3dApp->m_bRequestEnable = TRUE;			//  ޼ Ϸ

	//ٸ  ̺Ʈ  üũ.
	if(0 != strcmp(m_pShuttleChild->m_myShuttleInfo.CharacterName,pMsg->szCharacterName0))
	{
		// 2007-07-20 by bhsohn   ½ ٸ  ñ  ó
		char itemname[ITEMINFO_ITEM_FULL_NAME];
		memset(itemname, 0x00, ITEMINFO_ITEM_FULL_NAME);
		g_pDatabase->GetItemNameRareString(itemname, pMsg->nResultItemNum0, pMsg->nPrefixCodeNum0, pMsg->nSuffixCodeNum0);

		wsprintf(buf,STRMSG_C_PARTY_0021,pMsg->szCharacterName0, itemname);
		m_pChat->CreateChatChild(buf,COLOR_SKILL_USE);
		// end 2007-07-20 by bhsohn   ½ ٸ  ñ  ó
		return;
	}

	//ڽ  
	switch(pMsg->nRandomBoxResult)
	{
	case RANDOMBOX_RESULT_FAIL://  Ѱ.
		
		m_pChat->CreateChatChild(STRMSG_C_060810_0100,COLOR_SKILL_USE);
		break;
	case RANDOMBOX_RESULT_ITEM://   
		{
			char itemname[ITEMINFO_ITEM_FULL_NAME];
			memset(itemname, 0x00, ITEMINFO_ITEM_FULL_NAME);
			g_pDatabase->GetItemNameRareString(itemname, pMsg->nResultItemNum0, pMsg->nPrefixCodeNum0, pMsg->nSuffixCodeNum0);
			
			wsprintf(buf, STRMSG_C_060810_0101, itemname);
			m_pChat->CreateChatChild(buf, COLOR_ITEM);
			wsprintf(buf, STRMSG_C_ITEM_0006, itemname,pMsg->n64ResultCounts);
			m_pChat->CreateChatChild(buf, COLOR_SKILL_USE,CHAT_TAB_SYSTEM);

			// 2009. 10. 08 by ckPark ʵ â  ߺ Ұ ó

			// ʵ â  ˸޼
			ITEM* pItem = g_pDatabase->GetServerItemInfo( pMsg->nResultItemNum0 );
			if( pItem && pItem->IsExistDesParam( DES_FIELD_STORE ) )
			{
				sprintf( buf, STRMSG_C_091008_0301, pItem->ItemName );	// "%s  κ丮    ð  ˴ϴ."
				m_pChat->CreateChatChild( buf, COLOR_ITEM );
			}

			// end 2009. 10. 08 by ckPark ʵ â  ߺ Ұ ó
		}
		break;
	case RANDOMBOX_RESULT_EXP://ġ  .
		wsprintf(buf,STRMSG_C_060810_0102,pMsg->n64ResultCounts);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
		wsprintf(buf,STRMSG_C_QUEST_0006,pMsg->n64ResultCounts);
		m_pChat->CreateChatChild(buf,COLOR_SKILL_USE);
		break;
	case RANDOMBOX_RESULT_SPI://SPI  .
		wsprintf(buf,STRMSG_C_060810_0103,pMsg->n64ResultCounts);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
		wsprintf(buf,STRMSG_C_ITEM_0002,pMsg->n64ResultCounts);
		m_pChat->CreateChatChild(buf,COLOR_SKILL_USE);
		break;
	default:
		break;
	}

}
///////////////////////////////////////////////////////////////////////////////
/// \class		
/// \brief		
///
/// \author		// 2008-08-26 by bhsohn ڽ ý 
/// \version	
/// \date		2008-08-26 ~ 2008-08-26
/// \warning	
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketItemUseRandomBoxOkDone()
{
	// Done Ϸ ,  Ǭ.
	g_pD3dApp->m_bRequestEnable = TRUE;			//  ޼ Ϸ
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketStoreRequestQuickslotOK(MSG_FC_STORE_REQUEST_QUICKSLOT_OK* pMsg)
/// \brief		   û OK
/// \author		ispark
/// \date		2006-09-05 ~ 2006-09-05
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketStoreRequestQuickslotOK(MSG_FC_STORE_REQUEST_QUICKSLOT_OK* pMsg)
{
	for(int i = 0; i < QUICKTABCOUNT; i++)
	{
		for(int j = 0; j < QUICKSLOTCOUNT; j++)
		{
			CItemInfo *pItemInfo = g_pStoreData->FindItemInInventoryByItemNum(pMsg->POS[i].arrItemNum_[j]);
			CSkillInfo *pSkillInfo = g_pShuttleChild->m_pSkill->FindItemSkill(pMsg->POS[i].arrItemNum_[j]);
			if(pItemInfo)
			{
				// 
				g_pSOptionCharacter->UniqueNumber[i][j] = pItemInfo->UniqueNumber;
			}
			else if(pSkillInfo)
			{
				// ų
				g_pSOptionCharacter->UniqueNumber[i][j] = pSkillInfo->UniqueNumber;
			}

			g_pSOptionCharacter->ItemNum[i][j] = pMsg->POS[i].arrItemNum_[j];
		}
	}

	if(g_pGameMain->m_pQuickSlot)
		g_pGameMain->m_pQuickSlot->SetAllQSlotInfo();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketCharacterUseBonusstatOK(MSG_FC_CHARACTER_USE_BONUSSTAT_OK* pMsg)\
/// \brief		ʽ ȿ  
/// \author		ispark
/// \date		2006-09-18 ~ 2006-09-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterUseBonusstatOK(MSG_FC_CHARACTER_USE_BONUSSTAT_OK* pMsg)
{
	m_bRequestEnable = TRUE;			// 2006-09-18 by ispark, ޼ 
	m_pShuttleChild->m_myShuttleInfo.BonusStat = pMsg->byReaminBonusStat;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketUseSkillSupportItemOK(MSG_FC_ITEM_USE_SKILL_SUPPORT_ITEM_OK* pMsg)
/// \brief		ų  
/// \author		ispark
/// \date		2006-10-02 ~ 2006-10-02
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketUseSkillSupportItemOK(MSG_FC_ITEM_USE_SKILL_SUPPORT_ITEM_OK* pMsg)
{
	FLOG("CAtumApplication::FieldSocketUseSkillSupportItemOK(MSG_FC_ITEM_USE_SKILL_SUPPORT_ITEM_OK* pMsg)");

	ITEM* pItemInfo = g_pDatabase->GetServerItemInfo(pMsg->ItemNum);
	SetEffectUseItem(pItemInfo);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketGetServerDataTimeOK(MSG_FC_INFO_GET_SERVER_DATE_TIME_OK* pMsg)
/// \brief		 ð 
/// \author		ispark
/// \date		2006-10-11 ~ 2006-10-11
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketGetServerDataTimeOK(MSG_FC_INFO_GET_SERVER_DATE_TIME_OK* pMsg)
{
	g_ServerDateTime = pMsg->atimeCurServerTime;

	g_GameStartTime = timeGetTime();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketRequestPartyWarp(MSG_FC_QUEST_REQUEST_PARTY_WARP* pMsg)
/// \brief		Ʈ  Ȯ ޼
/// \author		ispark
/// \date		2006-10-16 ~ 2006-10-16
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketRequestPartyWarp(MSG_FC_QUEST_REQUEST_PARTY_WARP* pMsg)
{
	// ̸  ޼ Ұ
	if(g_pInterface->m_pBazaarShop)
	{
		return;
	}
	
	char strMessage[1024] = {0,};
	char strCallUserName[SIZE_MAX_CHARACTER_NAME] = {0,};
	vector<PARTYENEMYINFO*>::iterator itParty = g_pShuttleChild->m_pClientParty->m_vecPartyEnemyInfo.begin();
	while(itParty != g_pShuttleChild->m_pClientParty->m_vecPartyEnemyInfo.end())
	{
		if(pMsg->callerCharacterUID == (*itParty)->m_ImPartyMemberInfo.CharacterUniqueNumber)
		{
			strcpy(strCallUserName, (*itParty)->m_ImPartyMemberInfo.CharacterName);
			break;
		}
		
		itParty++;
	}

	wsprintf(strMessage, STRMSG_C_061016_0000, strCallUserName);
	//g_pGameMain->m_pInfWindow->AddMsgBox(strMessage, _Q_QUEST_REQUEST_PARTY_WARP, pMsg->warpMapChannIndex.MapIndex, pMsg->warpMapChannIndex.ChannelIndex, (pMsg->dwRemainTime / 1000), pMsg->callerCharacterUID);
	g_pGameMain->m_pInfWindow->AddTimeMsgBox(strMessage, _Q_QUEST_REQUEST_PARTY_WARP,(pMsg->dwRemainTime / 1000),STRMSG_C_060724_0000, pMsg->warpMapChannIndex.MapIndex, pMsg->warpMapChannIndex.ChannelIndex,pMsg->callerCharacterUID);

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketWarMonsterCreated(MSG_FC_WAR_MONSTER_CREATED* pMsg)
/// \brief		
/// \author		ispark
/// \date		2006-11-21 ~ 2006-11-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarMonsterCreated(MSG_FC_WAR_MONSTER_CREATED* pMsg)
{
	MAP_INFO* pMapinfo = g_pDatabase->GetMapInfo(pMsg->MapChannIdx.MapIndex);
	
	char buf[1024] = {0,};
	char bufInfluence[64] = {0,};

	if(IS_MAP_INFLUENCE_VCN(pMapinfo->MapInfluenceType))
	{
		wsprintf(bufInfluence, "%s", STRMSG_C_060210_0000);
	}
	else if(IS_MAP_INFLUENCE_ANI(pMapinfo->MapInfluenceType))
	{
		wsprintf(bufInfluence, "%s", STRMSG_C_060210_0001);
	}
	else
	{
		// ʿ    .
		DBGOUT("@@ Not Map Data InfluenceType (FieldSocketWarMonsterCreated) @@\n");
		return;
	}
	wsprintf(buf, STRMSG_C_061121_0000, bufInfluence, pMapinfo->MapName);	// "\\c%s\\c %s   Ʈ Ǿϴ."
	m_pChat->CreateChatChild(buf, COLOR_ITEM);

	// 2007-07-04 by bhsohn ۷ ߰
	// 2008-04-04 by bhsohn   Ŭ ߰
	//CINFGameMainUnitInfoBar* pBar = g_pInterface->m_pGameMain->m_pUnitInfoBar;
	if(g_pGameMain->GetSummonMotherShipCnt() == 0)
	{
		//   . 
		// ð 
		char bufTime[1024] = {0,};
		//wsprintf(bufTime, STRMSG_C_070712_0209, pMsg->CreateTime.Hour, pMsg->CreateTime.Minute);
		g_pInterface->AddInflWarMonster(buf, pMsg->MapChannIdx.MapIndex, pMapinfo->MapInfluenceType, pMsg->CreateTime);
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketWarMonsterAutoDestroyed(MSG_FC_WAR_MONSTER_AUTO_DESTROYED* pMsg)
/// \brief		
/// \author		ispark
/// \date		2006-11-21 ~ 2006-11-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarMonsterAutoDestroyed(MSG_FC_WAR_MONSTER_AUTO_DESTROYED* pMsg)
{
	MAP_INFO* pMapinfo = g_pDatabase->GetMapInfo(pMsg->MapChannIdx.MapIndex);
	MEX_MONSTER_INFO* pMonsterInfo = g_pDatabase->CheckMonsterInfo(pMsg->MonsterUnitKind);

	char buf[1024] = {0,};
	char bufInfluence[64] = {0,};

	if(IS_MAP_INFLUENCE_VCN(pMapinfo->MapInfluenceType))
	{
		wsprintf(bufInfluence, "%s", STRMSG_C_060210_0000);
	}
	else if(IS_MAP_INFLUENCE_ANI(pMapinfo->MapInfluenceType))
	{
		wsprintf(bufInfluence, "%s", STRMSG_C_060210_0001);
	}
	else
	{
		// ʿ    .
		DBGOUT("@@ Not Map Data InfluenceType (FieldSocketWarMonsterAutoDestroyed) @@\n");
		return;
	}
	
	wsprintf(buf, STRMSG_C_061121_0003, bufInfluence, pMapinfo->MapName);	// "\\c%s\\c %s   Ʈ ϴ."
	m_pChat->CreateChatChild(buf, COLOR_CHAT_GUILD);

	if(IS_SAME_CHARACTER_MONSTER_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, pMonsterInfo->Belligerence))
	{
		memset(buf, 0x00, 1024);
		wsprintf(buf, STRMSG_C_061121_0002, ADD_CONTRIBUTIONPOINT_STRATEGYPOINT_MONSTER);	// " Ʈ %d ߰ Ǿϴ."
		m_pChat->CreateChatChild(buf, COLOR_CHAT_GUILD);
	}

}
	
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketWarMonsterDead(MSG_FC_WAR_MONSTER_DEAD* pMsg)
/// \brief		
/// \author		ispark
/// \date		2006-11-21 ~ 2006-11-21
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketWarMonsterDead(MSG_FC_WAR_MONSTER_DEAD* pMsg)
{
	MAP_INFO* pMapinfo = g_pDatabase->GetMapInfo(pMsg->MapChannIdx.MapIndex);
	MEX_MONSTER_INFO* pMonsterInfo = g_pDatabase->CheckMonsterInfo(pMsg->MonsterUnitKind);
	
	char		buf[1024] = {0,};
	char		bufInfluence[64] = {0,};
	BYTE		bMapInf = 0;

	if(IS_MAP_INFLUENCE_VCN(pMapinfo->MapInfluenceType))
	{
		wsprintf(bufInfluence, "%s", STRMSG_C_060210_0000);
		bMapInf = INFLUENCE_TYPE_VCN;
	}
	else if(IS_MAP_INFLUENCE_ANI(pMapinfo->MapInfluenceType))
	{
		wsprintf(bufInfluence, "%s", STRMSG_C_060210_0001);
		bMapInf = INFLUENCE_TYPE_ANI;
	}
	else
	{
		// ʿ    .
		DBGOUT("@@ Not Map Data InfluenceType (FieldSocketWarMonsterDead) @@\n");
		return;
	}

	wsprintf(buf, STRMSG_C_061121_0001, bufInfluence, pMapinfo->MapName);	// "\\c%s\\c %s   Ʈ ĵǾϴ."
	m_pChat->CreateChatChild(buf, COLOR_ITEM);

	// 2007-10-02 by dgwoo 
	if(IsWarMotherShip()																						//  
		&& !COMPARE_INFLUENCE(bMapInf,g_pShuttleChild->GetMyShuttleInfo().InfluenceType)					// ʰ   ƴϰ
		&& (COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_INFLUENCE_LEADER) ||					// .
					COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_INFLUENCE_SUBLEADER_MASK)))			// 
	{//
		wsprintf(buf, STRMSG_C_071002_0102);	// "Alt + Click ڷƮ ŬϿ Ȱȭ ϼ."
		m_pChat->CreateChatChild(buf, COLOR_CHAT_GUILD);
	}

	memset(buf, 0x00, 1024);
	// ĵ  Ʈ ¿  ޼ 
	if(FALSE == IS_SAME_CHARACTER_MONSTER_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, pMonsterInfo->Belligerence))
	{
		wsprintf(buf, STRMSG_C_061121_0002, ADD_CONTRIBUTIONPOINT_STRATEGYPOINT_MONSTER);	// " Ʈ %d ߰ Ǿϴ."
		m_pChat->CreateChatChild(buf, COLOR_CHAT_GUILD);
	}

	// 2007-07-23 by bhsohn ۷ ߰۾
	g_pInterface->DetroySummonMonster(pMsg->MapChannIdx.MapIndex);

	// 2008-04-22 by bhsohn /   ǥ ϰ 	
	g_pInterface->RefreshWarSPWarInfo();	// 
	// end 2008-04-22 by bhsohn /   ǥ ϰ 	
	
}

VOID CAtumApplication::SendMovePacket(BOOL bActive) 
{ 
	g_fSendMovePacket -= 0.2f; 
	MSG_FC_MOVE sMsg; 
	memset(&sMsg,0x00,sizeof(sMsg)); 
	sMsg.ClientIndex = m_pShuttleChild->m_myShuttleInfo.ClientIndex; 
	if(bActive == TRUE) 
	{ 
		sMsg.TimeGap = m_dwSpeedHackTimer; 
	} 
	else 
	{ 
		sMsg.TimeGap = 200; 
		m_dwSpeedHackTimer = 0; 
	} 
	sMsg.PositionVector = m_pShuttleChild->m_vPos; 
	sMsg.TargetVector = m_pShuttleChild->m_vVel*1000.0f; 
	D3DXVECTOR3 vUp; 
	vUp.x = m_pShuttleChild->m_mMatrix._21; 
	vUp.y = m_pShuttleChild->m_mMatrix._22; 
	vUp.z = m_pShuttleChild->m_mMatrix._23; 
	sMsg.UpVector = vUp*1000.0f; 
	// 2008-02-17 by bhsohn ʷε Ϸ Ͽ    ִ ̴.
	//m_pFieldWinSocket->SendMsg( T_FC_MOVE, (char*)&sMsg, sizeof(sMsg)); 
	if(TRUE == IsLockMode())
	{
		//ʷε Ϸ ¿ MOVE .
		m_pFieldWinSocket->SendMsg( T_FC_MOVE, (char*)&sMsg, sizeof(sMsg)); 
	}
	
	m_vClientOldPos = m_pShuttleChild->m_vPos; 
	// 2008-02-17 by bhsohn ʷε Ϸ Ͽ    ִ ̴.
	//if(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind))
	if(IS_DT(m_pShuttleChild->m_myShuttleInfo.UnitKind) && (TRUE == IsLockMode())) 
	{ 			 
		//ʷε Ϸ ¿ MOVE .
		m_pShuttleChild->SendMoveWeaponVel(); 
	}
//#ifdef _DEBUG 
//	m_nDebugTimerMove++; 
//#endif 
}

void CAtumApplication::InitSpeedHackTimer()
{
	m_nCheckSpeedHackCount = 0;
	m_dwCheckSpeedHackTime = 0;
	m_nSendMovePacketCount = 0;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FadeEffectRender()
/// \brief		Fade-In&Out ý
/// \author		jschoi
/// \date		2004-12-13 ~ 2004-12-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FadeEffectRender()
{
	if(	m_pInterface && m_pInterface->m_pFadeEffect)
	{
		m_pInterface->m_pFadeEffect->Render();
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::StartFadeEffect(BOOL bFadeIn,int nTime,D3DCOLOR dwColor)
/// \brief		Fade-In&Out  Ѵ.
/// \author		jschoi
/// \date		2004-12-13 ~ 2004-12-13
/// \warning	
///
/// \param		bFadeIn : TRUE(Fade In)/FALSE(Fade Out)
///				nTime	: ӽð
///				dwColor : 
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::StartFadeEffect(BOOL bFadeIn,int nTime,D3DCOLOR dwColor)
{
	if(	m_pInterface && m_pInterface->m_pFadeEffect)
	{
		m_pInterface->m_pFadeEffect->SetFadeEffect(bFadeIn,nTime,dwColor);
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication:EndFadeEffect()
/// \brief		Fade-In&Out  Ѵ.
/// \author		jschoi
/// \date		2004-12-13 ~ 2004-12-13
/// \warning	Fade-In ڵ ǹǷ  ʿ.(Fade-Out  Լ ȣ ʿ䰡 ִ.)
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::EndFadeEffect()
{
	if(	m_pInterface &&	m_pInterface->m_pFadeEffect)
	{
		m_pInterface->m_pFadeEffect->ReleaseFadeEffect();
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FadeEffectTick()
/// \brief		
/// \author		jschoi
/// \date		2004-12-13 ~ 2004-12-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::FadeEffectTick()
{
	if(	m_pInterface &&	m_pInterface->m_pFadeEffect)
	{
		m_pInterface->m_pFadeEffect->Tick(m_fElapsedTime);
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		jschoi
/// \date		2005-04-26 ~ 2005-04-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
float CAtumApplication::GetFadeAlpha()
{
	if(	m_pInterface &&	m_pInterface->m_pFadeEffect)
	{
		return m_pInterface->m_pFadeEffect->GetCurrentAlpha();
	}
	return 0.0f;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketMoveLockonOk(MSG_FC_MOVE_LOCKON_OK* pMsg)
/// \brief		
/// \author		jschoi
/// \date		2005-02-15 ~ 2005-02-15
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMoveLockonOk(MSG_FC_MOVE_LOCKON_OK* pMsg)
{
	if( pMsg->TargetIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex )
	{
		// 2006-01-07 by ispark, 
//		char msg[MAX_PATH];
//		wsprintf(msg, STRMSG_C_INTERFACE_0051, pMsg->AttackCharacterName);//":[%s]  Ÿ ҽϴ."
//		m_pChat->CreateChatChild(msg,COLOR_VOIP);

		// 2005-11-03 by ispark
		// Ÿ  
		CMapEnemyIterator it = g_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
		if(it != g_pScene->m_mapEnemyList.end())
		{
			if(pMsg->TargetIndex != it->second->m_nTargetIndex)
			{
				it->second->m_nTargetIndex = pMsg->TargetIndex;
				if(g_pShuttleChild->m_pOrderTarget == NULL)
				{
					// OrderTarget ٸ Ѵ.
					g_pShuttleChild->m_pOrderTarget = (CEnemyData*)it->second;

					// ׸  ˸. ",  Ҿ~~"
					MSG_FC_MOVE_LOCKON sMsg;
					sMsg.AttackIndex = g_pShuttleChild->m_myShuttleInfo.ClientIndex;
					sMsg.TargetIndex = ((CEnemyData*)g_pShuttleChild->m_pOrderTarget)->m_infoCharacter.CharacterInfo.ClientIndex;	
					g_pFieldWinSocket->SendMsg( T_FC_MOVE_LOCKON, (char*)&sMsg, sizeof(sMsg) );				
				}

//				if(it->second->m_pPkNormalTimer->IsCityWar() == FALSE)
//				{
//					it->second->SetbPkAttack(TRUE);
//					it->second->m_pPkNormalTimer->SetPkDelay();			// 5 ð üũ // 2006-01-07 by ispark, 
//				}	
			}
		}
	}
	else //  
	{
//		CMapEnemyIterator it = g_pScene->m_mapEnemyList.find(pMsg->TargetIndex);
//		if(it != g_pScene->m_mapEnemyList.end())
//		{
//			if(it->second->m_nTargetIndex != pMsg->AttackIndex)
//			{
//				it->second->m_nTargetIndex = pMsg->AttackIndex;
//
//				if(it->second->m_pPkNormalTimer->IsCityWar() == FALSE)
//				{
//					it->second->SetbPkAttack(TRUE);
//					it->second->m_pPkNormalTimer->SetPkDelay();			// 5 ð üũ // 2006-01-07 by ispark, 
//				}	
//			}
//		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketMoveUnlockonOk(MSG_FC_MOVE_UNLOCKON_OK* pMsg)
/// \brief		
/// \author		jschoi
/// \date		2005-02-15 ~ 2005-02-15
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketMoveUnlockonOk(MSG_FC_MOVE_UNLOCKON_OK* pMsg)
{
	if( pMsg->TargetIndex == g_pShuttleChild->m_myShuttleInfo.ClientIndex )
	{
		// 2006-01-07 by ispark, 
//		char msg[MAX_PATH];
//		wsprintf(msg, STRMSG_C_INTERFACE_0052, pMsg->AttackCharacterName);//"[%s] Ÿ ߽ϴ."
//		m_pChat->CreateChatChild(msg,COLOR_VOIP);

		CMapEnemyIterator it = g_pScene->m_mapEnemyList.find(pMsg->AttackIndex);
		if(it != g_pScene->m_mapEnemyList.end())
		{
//			if(!it->second->m_pPkNormalTimer->IsPkEnableNormalOrderTarget())
//			{
//				// 5 ð  ʾƼ    OrderTaget 
//				g_pShuttleChild->m_pOrderTarget = NULL;
//				it->second->m_pPkNormalTimer->ReleasePkDelay();
//			}
//			DBGOUT("%s()  \n", pMsg->AttackCharacterName);
			it->second->m_nTargetIndex = 0;
		}
	}
	else //  
	{
		CMapEnemyIterator it = g_pScene->m_mapEnemyList.find(pMsg->TargetIndex);
		if(it != g_pScene->m_mapEnemyList.end())
		{
//			if(!it->second->m_pPkNormalTimer->IsPkEnableNormalOrderTarget())
//			{
//				// 5 ð  ʾƼ    Taget 
//				it->second->m_nTargetIndex = 0;
//				it->second->m_pPkNormalTimer->ReleasePkDelay();
//			}
			// 2006-01-09 by ispark, Ÿ  ƴ϶ ε 
//			DBGOUT("%s()  \n", (CEnemyData*)it->second->m_infoCharacter.CharacterInfo.CharacterName);
			if(it->second->m_nTargetIndex != g_pShuttleChild->m_myShuttleInfo.ClientIndex)
				it->second->m_nTargetIndex = 0;
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketInfoGetCurrentMapInfoOk(MSG_FC_INFO_GET_CURRENT_MAP_INFO_OK* pMsg)
/// \brief		
/// \author		jschoi
/// \date		2005-02-16 ~ 2005-02-16
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoGetCurrentMapInfoOk(MSG_FC_INFO_GET_CURRENT_MAP_INFO_OK* pMsg)
{
	if(g_pShuttleChild && g_pShuttleChild->m_pPkNormalTimer)
	{
		if(pMsg->IsCityWarStarted == 0)
		{
			g_pShuttleChild->m_pPkNormalTimer->ReleaseCityWar();
		}
		else
		{
			g_pShuttleChild->m_pPkNormalTimer->SetCityWar();
		}		

		g_pShuttleChild->m_byCityWarTeamType = pMsg->byCityWarTeamType;
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketCharacterCashPremiumCardInfo(MSG_FC_CHARACTER_CASH_PREMIUM_CARD_INFO* pMsg)
/// \brief		
/// \author		jschoi
/// \date		2005-02-18 ~ 2005-02-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterCashPremiumCardInfo(MSG_FC_CHARACTER_CASH_PREMIUM_CARD_INFO* pMsg)
{
	// 2005-03-18 by jschoi
	g_pD3dApp->m_bRequestEnable = TRUE;

	if(g_pShuttleChild)
	{
		SetPremiumCardInfo(pMsg);
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::FieldSocketStoreUpdateItemStorage(MSG_FC_STORE_UPDATE_ITEMSTORAGE* pMsg)
/// \brief		
/// \author		ispark
/// \date		2005-12-07 ~ 2005-12-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketStoreUpdateItemStorage(MSG_FC_STORE_UPDATE_ITEMSTORAGE* pMsg)
{
//	ASSERT_IMPLIES(pMsg->FromPossess != pMsg->ToPossess, pMsg->FromPossess != 0 || pMsg->ToPossess != 0);
//	ASSERT_IMPLIES(m_pInterface, m_pInterface->m_pCityBase);
	
	CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
	ASSERT_ASSERT(pStore);
	if(pStore)
	{
		if(ITEM_IN_STORE == pMsg->FromItemStorage)	// â -> â
		{
			CItemInfo* pItemInfo = pStore->FindItemInfo( pMsg->ItemUniqueNumber );
			ASSERT_ASSERT( IS_COUNTABLE_ITEM(pItemInfo->Kind) == FALSE );
			CItemInfo* pNewItemInfo = new CItemInfo((ITEM_GENERAL*)pItemInfo);
			pNewItemInfo->ItemWindowIndex = POS_INVALID_POSITION;

			// 2010. 02. 11 by ckPark ߵ 
			//pNewItemInfo->SetEnchantParam( pItemInfo->GetEnchantParamFactor(), pItemInfo->GetEnchantNumber() );
			// ߵ æƮ , Ÿ  ߰ 
			pNewItemInfo->CopyItemInfo( pItemInfo );
			// end 2010. 02. 11 by ckPark ߵ 

			pStore->DeleteItem( pMsg->ItemUniqueNumber ); // InputItemDone();
			g_pStoreData->AddItemDataToUniqueNumberAndWindowPosition( pNewItemInfo );
			g_pGameMain->m_pInven->SetAllIconInfo();
		}
		else if(ITEM_IN_STORE == pMsg->ToItemStorage) // â -> â
		{
			CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
			ASSERT_ASSERT( IS_COUNTABLE_ITEM(pItemInfo->Kind) == FALSE );
			CItemInfo* pNewItemInfo = new CItemInfo((ITEM_GENERAL*)pItemInfo);

			// 2010. 02. 11 by ckPark ߵ 
			//pNewItemInfo->SetEnchantParam( pItemInfo->GetEnchantParamFactor(), pItemInfo->GetEnchantNumber() );
			// ߵ æƮ , Ÿ  ߰ 
			pNewItemInfo->CopyItemInfo( pItemInfo );
			// end 2010. 02. 11 by ckPark ߵ 

			pStore->AddItem( pNewItemInfo );
			pStore->InputItemDone();
			g_pStoreData->DeleteItem( pMsg->ItemUniqueNumber );
		}
		else if(ITEM_IN_GUILD_STORE == pMsg->FromItemStorage)
		{// â -> κ丮.
			CItemInfo* pItemInfo = pStore->FindItemInfo( pMsg->ItemUniqueNumber );
			ASSERT_ASSERT( IS_COUNTABLE_ITEM(pItemInfo->Kind) == FALSE );
			CItemInfo* pNewItemInfo = new CItemInfo((ITEM_GENERAL*)pItemInfo);
			pNewItemInfo->ItemWindowIndex = POS_INVALID_POSITION;

			// 2010. 02. 11 by ckPark ߵ 
			//pNewItemInfo->SetEnchantParam( pItemInfo->GetEnchantParamFactor(), pItemInfo->GetEnchantNumber() );
			// ߵ æƮ , Ÿ  ߰ 
			pNewItemInfo->CopyItemInfo( pItemInfo );
			// end 2010. 02. 11 by ckPark ߵ 

			pStore->DeleteItem( pMsg->ItemUniqueNumber ); // InputItemDone();
			g_pStoreData->AddItemDataToUniqueNumberAndWindowPosition( pNewItemInfo );
			g_pGameMain->m_pInven->SetAllIconInfo();

		}
		else if(ITEM_IN_GUILD_STORE == pMsg->ToItemStorage)
		{// κ丮 -> â
			CItemInfo* pItemInfo = g_pStoreData->FindItemInInventoryByUniqueNumber( pMsg->ItemUniqueNumber );
			ASSERT_ASSERT( IS_COUNTABLE_ITEM(pItemInfo->Kind) == FALSE );
			CItemInfo* pNewItemInfo = new CItemInfo((ITEM_GENERAL*)pItemInfo);

			// 2010. 02. 11 by ckPark ߵ 
			//pNewItemInfo->SetEnchantParam( pItemInfo->GetEnchantParamFactor(), pItemInfo->GetEnchantNumber() );
			// ߵ æƮ , Ÿ  ߰ 
			pNewItemInfo->CopyItemInfo( pItemInfo );
			// end 2010. 02. 11 by ckPark ߵ 

			pStore->AddItem( pNewItemInfo );
			pStore->InputItemDone();
			g_pStoreData->DeleteItem( pMsg->ItemUniqueNumber );
		}
		// 2006-10-25 by dgwoo
		g_pD3dApp->m_bRequestEnable = TRUE;
		g_pD3dApp->m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;

		// 2007-02-12 by bhsohn Item   ó
		FromStoreMultiResponseOK();
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID	CAtumApplication::FieldSocketCharacterObserverStartOK(MSG_FC_CHARACTER_OBSERVER_START* pMsg)
/// \brief		  غ ϷǾ پ ȴٴ Ŷ.
/// \author		dgwoo
/// \date		2007-03-29 ~ 2007-03-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterObserverStartOK(MSG_FC_CHARACTER_OBSERVER_START* pMsg)
{
	g_pShuttleChild->m_bMouseLock = FALSE;
	g_pShuttleChild->m_bObserve = FALSE;
	g_pShuttleChild->m_nAlphaValue = 255;

	if(COMPARE_RACE(g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.Race,RACE_OPERATION) 
		|| COMPARE_RACE(g_pD3dApp->m_pShuttleChild->m_myShuttleInfo.Race,RACE_GAMEMASTER))
	{
		CMapEnemyIterator itEnemy = g_pD3dApp->m_pScene->m_mapEnemyList.begin();
		while(itEnemy != g_pD3dApp->m_pScene->m_mapEnemyList.end())
		{
			if(itEnemy->second->m_infoCharacter.CharacterInfo.ClientIndex == pMsg->TargetClientIndex)
			{

				g_pShuttleChild->m_stObserve.ClientIndex = itEnemy->second->m_infoCharacter.CharacterInfo.ClientIndex;
				g_pShuttleChild->m_stObserve.pEnemyData = itEnemy->second;
				g_pShuttleChild->m_bObserve = TRUE;
				g_pShuttleChild->m_bMouseLock = TRUE;
				g_pShuttleChild->m_nAlphaValue = 0;
				g_pD3dApp->m_bFixUnitDirMode = FALSE;
				g_pGameMain->m_pUnitInfoBar->UpdateAllGage();
				return;
			}
			itEnemy++;
		}
	}

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketCharacterObserverEndOK(MSG_FC_CHARACTER_OBSERVER_END* pMsg)
/// \brief		  .
/// \author		dgwoo
/// \date		2007-03-29 ~ 2007-03-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterObserverEndOK(MSG_FC_CHARACTER_OBSERVER_END* pMsg)
{

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketCharacterObserverRegOK(MSG_FC_CHARACTER_OBSERVER_REG* pMsg);
/// \brief		 Ű  Ϸ.
/// \author		dgwoo
/// \date		2007-03-29 ~ 2007-03-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterObserverRegOK(MSG_FC_CHARACTER_OBSERVER_REG* pMsg)
{	
	DbgOut("FieldSocketCharacterObserverRegOK\n");
	g_pShuttleChild->m_ObserveQuick[pMsg->nRegNum] = pMsg->ClientIndex;
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketCharacterObserverInfoOK(MSG_FC_CHARACTER_OBSERVER_INFO* pMsg);
/// \brief		   ޴´.
/// \author		dgwoo
/// \date		2007-03-29 ~ 2007-03-29
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterObserverInfoOK(MSG_FC_CHARACTER_OBSERVER_INFO* pMsg)
{
	//memcpy(&g_pShuttleChild->m_stObserve.ClientInfo,pMsg,sizeof(MSG_FC_CHARACTER_OBSERVER_INFO));
	g_pShuttleChild->ObserveUpdateGage(pMsg);
	g_pGameMain->m_pUnitInfoBar->UpdateAllGage();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketArenaWatchReady()
/// \brief		/ ̶ ɾ Է.
/// \author		dgwoo
/// \date		2007-06-18 ~ 2007-06-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaWatchReady(MSG_FC_ARENA_WATCH_READY* pMsg)
{
	if(pMsg->ArenaState >= ARENA_STATE_FIGHTING_WARING)
	{
		m_pInterface->m_pGameArena->SetArenaGameState(ARENA_GAME_STATE_SCORE);
		g_pScene->ChangeObjectBodyCondition(ARENA_MAP_01_DOOR_OBJECT,BODYCON_DOOR_OPENING_MASK);
// 2012-05-29 by mspark, Ʒ 2 (׳ũ) 
#ifdef C_ARENA_EX_1ST_MSPARK
		g_pScene->ChangeObjectBodyCondition(ARENA_MAP_02_DOOR_OBJECT,BODYCON_DOOR_OPENING_MASK);
#endif
// end 2012-05-29 by mspark, Ʒ 2 (׳ũ) 
	}else
	{
		m_pInterface->m_pGameArena->SetArenaGameState(ARENA_GAME_STATE_TIMER);
	}
	g_pShuttleChild->SetOperation(TRUE);
	g_pShuttleChild->m_nAlphaValue = SKILL_OBJECT_ALPHA_OTHER_INFLUENCE;
	g_pD3dApp->m_pChat->CreateChatChild( STRMSG_C_070618_0100, COLOR_ERROR);	//" ۵Ǿϴ."
	// 2007-04-04 by dgwoo ۽ Ʋ  صд.
	g_pShuttleChild->m_stObserve.ClientInfo.DP = g_pShuttleChild->m_myShuttleInfo.DP;
	g_pShuttleChild->m_stObserve.ClientInfo.HP = g_pShuttleChild->m_myShuttleInfo.HP;
	g_pShuttleChild->m_stObserve.ClientInfo.EP = g_pShuttleChild->m_myShuttleInfo.EP;
	g_pShuttleChild->m_stObserve.ClientInfo.SP = g_pShuttleChild->m_myShuttleInfo.SP;
	g_pShuttleChild->m_stObserve.ClientInfo.CurrentDP = g_pShuttleChild->m_myShuttleInfo.CurrentDP;
	g_pShuttleChild->m_stObserve.ClientInfo.CurrentHP = g_pShuttleChild->m_myShuttleInfo.CurrentHP;
	g_pShuttleChild->m_stObserve.ClientInfo.CurrentEP = g_pShuttleChild->m_myShuttleInfo.CurrentEP;
	g_pShuttleChild->m_stObserve.ClientInfo.CurrentSP = g_pShuttleChild->m_myShuttleInfo.CurrentSP;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketArenaWatchStart(MSG_FC_ARENA_WATCH_START* pMsg)
/// \brief		Ҽִ   ü ش.
/// \author		dgwoo
/// \date		2007-06-18 ~ 2007-06-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaWatchStart(MSG_FC_ARENA_WATCH_START* pMsg)
{
	m_pInterface->m_pGameArena->AddEnemyOperation(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketArenaWatchEnd()
/// \brief		  .
/// \author		dgwoo
/// \date		2007-06-18 ~ 2007-06-18
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaWatchEnd()
{
	g_pShuttleChild->SetOperation(FALSE);
	g_pShuttleChild->m_bObserve = FALSE;
	g_pShuttleChild->m_nAlphaValue = SKILL_OBJECT_ALPHA_NONE;
	g_pShuttleChild->ObserveCancelUpdateInfo();
	g_pD3dApp->m_pChat->CreateChatChild( STRMSG_C_070618_0101, COLOR_ERROR);	//" Ǿϴ."

	g_pInterface->m_pGameArena->SetArenaGameState(ARENA_GAME_STATE_NORMAL,TRUE);
	g_pInterface->m_pGameArena->ClearEnemyOperation();							//  Ѵ.
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketArenaWatchRemoveUser(MSG_FC_ARENA_WATCH_REMOVE_USER* pMsg)
/// \brief		Ʒ   Ѵ.
/// \author		dgwoo
/// \date		2007-06-19 ~ 2007-06-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaWatchRemoveUser(MSG_FC_ARENA_WATCH_REMOVE_USER* pMsg)
{
	m_pInterface->m_pGameArena->DeleteOperationUser(pMsg->ClientIndex);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketCharacterWatchInfo(MSG_FC_CHARACTER_WATCH_INFO* pMsg)
/// \brief		  (ALL) (,) ش
/// \author		dgwoo
/// \date		2007-06-19 ~ 2007-06-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterWatchInfo(MSG_FC_CHARACTER_WATCH_INFO* pMsg)
{
	m_pInterface->m_pGameArena->ChangeWatchInfo(pMsg);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaRequestTeamOK(MSG_FC_ARENA_REQUEST_TEAM_OK* pMsg);
/// \brief		Ʒ  
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRequestTeamOK(MSG_FC_ARENA_REQUEST_TEAM_OK* pMsg)
{
	CINFCityArena * pCityArena = (CINFCityArena*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_ARENA);
	if(pCityArena != NULL)
	{
		pCityArena->ArenaTeamListInput(pMsg);
	}
	m_bRequestEnable = TRUE;
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaCreateTeamOK(MSG_FC_ARENA_CREATE_TEAM_OK* pMsg);
/// \brief		Ʒ  .
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaCreateTeamOK(MSG_FC_ARENA_CREATE_TEAM_OK* pMsg)
{
	CINFCityArena * pCityArena = (CINFCityArena*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_ARENA);
	if(pCityArena != NULL)
	{
		pCityArena->ReFresh();
	}
	m_pInterface->m_pGameArena->CreateTeamOK(pMsg);
	// 2008-11-24 by dgwoo Ʒ ä  Ȱȭ ȵǴ 
	g_pGameMain->m_pChat->SetChatArenaAct(TRUE);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaEnterTeamOK(MSG_FC_ARENA_ENTER_TEAM_OK* pMsg);
/// \brief		Ʒ 濡 .
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaEnterTeamOK(MSG_FC_ARENA_ENTER_TEAM_OK* pMsg)
{
	m_pInterface->m_pGameArena->EnterTeamOK(pMsg);
	// 2008-11-24 by dgwoo Ʒ ä  Ȱȭ ȵǴ 
	g_pGameMain->m_pChat->SetChatArenaAct(TRUE);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaTeamMemberList(MSG_FC_ARENA_TEAM_MEMBER_LIST* pMsg);
/// \brief		濡 ִ  Ʈ.
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaTeamMemberList(MSG_FC_ARENA_TEAM_MEMBER_LIST* pMsg)
{
	g_pInterface->m_pGameArena->AddTeamUserInfo(pMsg);
	// 2007-11-22 by bhsohn Ʒ ռ
	if(TRUE == g_pInterface->IsArenaReady())
	{		
		// û 
		SetArenaState(ARENA_STATE_ARENA_WAIT);
	}
	// end 2007-11-22 by bhsohn Ʒ ռ
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaReaveTeamOK();
/// \brief		  Ϸ.
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaReaveTeamOK()
{
	g_pInterface->m_pGameArena->ReaveArena();
	// 2008-11-24 by dgwoo Ʒ ä  Ȱȭ ȵǴ 
	g_pGameMain->m_pChat->SetChatArenaAct(FALSE);

	BOOL bArenaTeamNotLoad = (ARENA_STATE_ARENA_GAMING != g_pD3dApp->GetArenaState()) 								
								&& !IS_CITY_MAP_INDEX(g_pD3dApp->GetMyShuttleMapChannelIndex().MapIndex);
	if(bArenaTeamNotLoad)	
	{			
		//  ƴϸ鼭   Ʒ  ´.
		g_pD3dApp->CloseArenaSocket();		
		return;
	}

	GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
	if(NULL == pBuilding)
	{
		return;
	}
	if(BUILDINGKIND_ARENA != pBuilding->buildingInfo.BuildingKind)
	{
		return;
	}

	//      Ѵ.
	CINFCityArena * pCityArena = (CINFCityArena*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_ARENA);
	if(pCityArena != NULL)
	{
		pCityArena->ReFresh();
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaTeamReady(MSG_FC_ARENA_TEAM_READY* pMsg);
/// \brief		 Ī 
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaTeamReady(MSG_FC_ARENA_TEAM_READY* pMsg)
{
	g_pInterface->m_pGameArena->TeamReady();
	
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaEnterRoom(MSG_FC_ARENA_ENTER_ROOM* pMsg);
/// \brief		Ʒ  .
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaEnterRoom(MSG_FC_ARENA_ENTER_ROOM* pMsg)
{	
	g_pInterface->m_pGameArena->m_pINFArenaScore->SetArenaScoreEx(pMsg->VCNDeathCount,pMsg->ANIDeathCount);	
	g_pInterface->m_pGameArena->EnterRoom(pMsg->StartRoomTime,pMsg->PlayLimitedTime);	
	// 2009. 09. 10 by jsKim Ʒ Խ  ī  
	g_ArenaServerDateTime = pMsg->ArenaServerTime;
	g_ArenaStartTime = timeGetTime();
	// end 2009. 09. 10 by jsKim Ʒ Խ  ī  

	// 2008-03-03 by bhsohn  Ʒ IM  
	//g_pGameMain->m_pInfWindow->AddTimeMsgBox(STRMSG_C_070504_0100, _Q_ARENA_WARP,30,STRMSG_C_060724_0000);	
	// Ǿ ޽ â .
	DoModalAreanQuestion();	
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaRoomWarStart();
/// \brief		 .
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRoomWarStart()
{
	// 2007-11-22 by bhsohn Ʒ ռ
	// ʰ     ʱȭѴ.
	g_pInterface->m_pGameArena->SetAlreadyArenaStart(TRUE);

	g_pInterface->m_pGameArena->StartCountWar();
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaRoomWarInfo(MSG_FC_ARENA_ROOM_WAR_INFO* pMsg);
/// \brief		Ʈ ȯ ó.
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRoomWarInfo(MSG_FC_ARENA_ROOM_WAR_INFO* pMsg)
{
	g_pInterface->m_pGameArena->SetArenaScore(pMsg);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID	FieldSocketArenaRoomWarFinishHeader(MSG_FC_ARENA_ROOM_WAR_FINISH_HEADER* pMsg);
/// \brief		Ʒ   ֱ .
/// \author		dgwoo
/// \date		2007-05-08 ~ 2007-05-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRoomWarFinishHeader(MSG_FC_ARENA_ROOM_WAR_FINISH_HEADER* pMsg)
{
	m_pInterface->m_pGameArena->FinishHeader(pMsg);
	m_bRequestEnable = FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaRoomWarFinish(MSG_FC_ARENA_ROOM_WAR_FINISH_DEATHMATCH* pMsg);
/// \brief		Ʒ   ִ  
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRoomWarFinish(MSG_FC_ARENA_ROOM_WAR_FINISH* pMsg)
{
	g_pInterface->m_pGameArena->AddResult(pMsg);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID	FieldSocketArenaRoomWarFinishDone(MSG_FC_ARENA_ROOM_WAR_FINISH_DONE* pMsg);
/// \brief		Ʒ    
/// \author		dgwoo
/// \date		2007-05-08 ~ 2007-05-08
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRoomWarFinishDone(MSG_FC_ARENA_ROOM_WAR_FINISH_DONE* pMsg)
{	
	g_pInterface->m_pGameArena->EndWar(pMsg);
	// 2008-04-15 by bhsohn Ʒ Ʈ  ý 
	// Ʈ 
	m_pArenaManager->SetInflPoint(pMsg->InflPoint);

	m_bRequestEnable = TRUE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		dgwoo
/// \date		2007-05-10 ~ 2007-05-10
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRoomWarFinishDraw(MSG_FC_ARENA_ROOM_WAR_FINISH_DRAW* pMsg)
{
	g_pInterface->m_pGameArena->EndWarDraw(pMsg);

	// 2008-04-15 by bhsohn Ʒ Ʈ  ý 
	// Ʈ 
	m_pArenaManager->SetInflPoint(pMsg->InflPoint);
	
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaFinishWarpOK(MSG_FC_ARENA_FINISH_WARP_OK* pMsg);
/// \brief		Ʒ   .
/// \author		dgwoo
/// \date		2007-04-19 ~ 2007-04-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaFinishWarpOK(MSG_FC_ARENA_FINISH_WARP_OK* pMsg)
{
	EventWarpOtherMap(pMsg->MapChannelIndex);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID FieldSocketArenaBeforRoomWarFinish()
/// \brief		Ʒ  1  ޽.
/// \author		dgwoo
/// \date		2007-05-15 ~ 2007-05-15
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaBeforRoomWarFinish()
{
	m_pChat->CreateChatChild(STRMSG_C_070515_0100,COLOR_VOIP);
	g_pInterface->m_pGameArena->m_pINFArenaScore->SetArenaTime(60);
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketArenaRequestCreateTeamInfoOK(MSG_FC_ARENA_REQUEST_CREATE_TEAMINFO_OK* pMsg)
/// \brief		Ʒ 忡  ο ޶ִ   .
/// \author		dgwoo
/// \date		2007-04-26 ~ 2007-04-26
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRequestCreateTeamInfoOK(MSG_FC_ARENA_REQUEST_CREATE_TEAMINFO_OK* pMsg)
{
	CINFCityArena * pCityArena = (CINFCityArena*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_ARENA);
	if(pCityArena != NULL)
	{
			pCityArena->AllModePersonInfo(pMsg);
	}
	m_bRequestEnable = TRUE;

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID	FieldSocketArenaTeamMatching();
/// \brief		Ʒ Ī ۾.
/// \author		dgwoo
/// \date		2007-05-03 ~ 2007-05-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaTeamMatching()
{
	g_pInterface->m_pGameArena->TeamMatching();
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID FieldSocketCharacterPayWarPoint(MSG_FC_CHARACTER_PAY_WARPOINT* pMsg)
/// \brief		Ʈ Ͽ.
/// \author		dgwoo
/// \date		2007-05-16 ~ 2007-05-16
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketCharacterPayWarPoint(MSG_FC_CHARACTER_PAY_WARPOINT* pMsg)
{
	g_pShuttleChild->m_myShuttleInfo.WarPoint = pMsg->TotalWarPoint;
	g_pShuttleChild->m_myShuttleInfo.CumulativeWarPoint = pMsg->CumulativeWarPoint;
	char buf[256];
	wsprintf(buf,STRMSG_C_070514_0101,pMsg->WarPoint);
	m_pChat->CreateChatChild(buf,COLOR_ITEM,CHAT_TAB_SYSTEM);
}
VOID CAtumApplication::FieldSocketCharacterUpdateSubleaderOk(MSG_FC_CHARACTER_UPDATE_SUBLEADER_OK * pMsg)
{
	char buf[256] = {0,};
	if(IS_ANI_INFLUENCE_TYPE(g_pShuttleChild->m_myShuttleInfo.InfluenceType))
	{
		if(pMsg->SubLeaderRank == 1)
		{
			if(IsMyShuttleLeader())
			{
				wsprintf(buf,STRMSG_C_071006_0107,pMsg->CharacterName,STRCMD_ANI_INFLUENCE_SUBLEADER_1);
			}
			else
			{
				wsprintf(buf,STRMSG_C_071006_0106,STRCMD_ANI_INFLUENCE_SUBLEADER_1);
			}
			
		}
		else if(pMsg->SubLeaderRank == 2)
		{
			if(IsMyShuttleLeader())
			{
				wsprintf(buf,STRMSG_C_071006_0107,pMsg->CharacterName,STRCMD_ANI_INFLUENCE_SUBLEADER_2);
			}
			else
			{
				wsprintf(buf,STRMSG_C_071006_0106,STRCMD_ANI_INFLUENCE_SUBLEADER_2);
			}
		}
	}
	else
	{
		if(pMsg->SubLeaderRank == 1)
		{
			if(IsMyShuttleLeader())
			{
				wsprintf(buf,STRMSG_C_071006_0107,pMsg->CharacterName,STRCMD_VCN_INFLUENCE_SUBLEADER_1);
			}
			else
			{			
				wsprintf(buf,STRMSG_C_071006_0106,STRCMD_VCN_INFLUENCE_SUBLEADER_1);
			}
		}
		else if(pMsg->SubLeaderRank == 2)
		{
			if(IsMyShuttleLeader())
			{
				wsprintf(buf,STRMSG_C_071006_0107,pMsg->CharacterName,STRCMD_VCN_INFLUENCE_SUBLEADER_2);
			}
			else
			{
				wsprintf(buf,STRMSG_C_071006_0106,STRCMD_VCN_INFLUENCE_SUBLEADER_2);
			}
		}
	}
	m_pChat->CreateChatChild(buf,COLOR_ITEM);

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID FieldSocketArenaRequestOtherTeamInfoOK(MSG_FC_ARENA_REQUEST_OTHER_TEAM_INFO_OK* pMsg)
/// \brief		  Ʈ
/// \author		dgwoo
/// \date		2007-05-25 ~ 2007-05-25
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaRequestOtherTeamInfoOK(MSG_FC_ARENA_REQUEST_OTHER_TEAM_INFO_OK* pMsg)
{
	SARENA_REQUEST_OTHER_TEAM_INFO_OK *pTeamInfo = (SARENA_REQUEST_OTHER_TEAM_INFO_OK *)((char *)pMsg + sizeof(MSG_FC_ARENA_REQUEST_OTHER_TEAM_INFO_OK));
	int i = 0;
	char buf[256];
	char sArenaMode[256];
	for(i = 0 ; i < pMsg->ArenaOtherTeamListCount ; i++)
	{
		if(pMsg->ArenaMode == ARENAMODE_DEATHMATCH)
			wsprintf(sArenaMode,"%s",STRMSG_C_070427_0100);
		else
			wsprintf(sArenaMode,"%s",STRMSG_C_070427_0101);

		wsprintf(buf,STRMSG_C_070525_0100,sArenaMode,pTeamInfo->MemberCount,pTeamInfo->TeamCount);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
		pTeamInfo++;
	}
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketTutorialStartOK(MSG_FC_TUTORIAL_START_OK * pMsg)
/// \brief		۰ ÿ Ϸ Ʃ丮  ޾ƿ´.
/// \author		dgwoo
/// \date		2007-07-16 ~ 2007-07-16
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTutorialStartOK(MSG_FC_TUTORIAL_START_OK * pMsg)
{
	STUTORIAL_LIST_INFO *pTutorialInfo = (STUTORIAL_LIST_INFO *)((char *)pMsg + sizeof(MSG_FC_TUTORIAL_START_OK));
	int i = 0;
	for(i = 0 ; i < pMsg->TutorialInfoListCount ; i++)
	{
		g_pTutorial->SetCompleteLesson(pTutorialInfo->TutorialNum,pTutorialInfo->TutorialComplete);
		pTutorialInfo++;
	}

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketTutorialCompleteOK()
/// \brief		
/// \author		dgwoo
/// \date		2007-07-16 ~ 2007-07-16
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTutorialCompleteOK(MSG_FC_TUTORIAL_COMPLETE_OK * pMsg)
{
	g_pTutorial->SetCompleteLesson(pMsg->TutorialNum);
}


/**********************************************************************************************
**
**	Ŀ  (ü ) ó.
**
**	Create Info :	2007. 08. 07. by bhsohn.		// 2007-08-07 by bhsohn Ŀ  ߰
**
**
***********************************************************************************************/
VOID CAtumApplication::FieldSocketChatAllInfluenceOK(MSG_FC_CHAT_ALL_INFLUENCE * pMsg)
{	
	if(g_pGameMain)
	{
		// 2007-11-07 by bhsohn Ŀ  弳 
		char szChatMsg[SIZE_MAX_STRING_256];
		memset(szChatMsg, 0x00, SIZE_MAX_STRING_256);
		strncpy(szChatMsg, pMsg->str256ChatMsg, SIZE_MAX_STRING_256);
		int temp,temp2;
		CheckReadyStringFiltering(szChatMsg,&temp,&temp2);
		// end 2007-11-07 by bhsohn Ŀ  弳 

		char chTxt[SIZE_MAX_CHARACTER_NAME+SIZE_MAX_STRING_256+8];
		// 2007-11-07 by bhsohn Ŀ  弳 
		//wsprintf(chTxt, STRMSG_C_070810_0202, pMsg->FromCharacterName, pMsg->str256ChatMsg);
		wsprintf ( chTxt , STRMSG_C_070810_0202 , pMsg->FromCharacterName , szChatMsg );
		g_pGameMain->AddSpeakerMsgString ( chTxt , FALSE , FALSE );
	}
}
VOID CAtumApplication::FieldSocketChatOutPostGuild(MSG_FC_CHAT_OUTPOST_GUILD* pMsg)
{
	char str[512];
	char strChat[SIZE_MAX_CHAT_MESSAGE];
	BYTE size = pMsg->MessageLength;
	char * p = (char *)pMsg;
	p += sizeof(MSG_FC_CHAT_OUTPOST_GUILD);
	memcpy(strChat,p,size);
	int temp,temp2;
	CheckReadyStringFiltering(strChat,&temp,&temp2);
	wsprintf(str,"[%s] %s",pMsg->FromCharacterName,strChat);//  ä
	m_pChat->CreateChatChild(str,COLOR_INFLUENCE, CHAT_TAB_INFLUENCE_LEADER);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostWarBefore(MSG_FC_OUTPOST_WAR_BEFORE* pMsg)
/// \brief		 ߹()
/// \author		dgwoo
/// \date		2007-09-06 ~ 2007-09-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostWarBefore(MSG_FC_OUTPOST_WAR_BEFORE* pMsg)
{
	char buf[512];
	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	// 2007-10-01 by bhsohn   Ʈ   
	//wsprintf(buf,STRMSG_C_070816_0103,pMsg->RemainTime,pMapInfo->MapName);
	wsprintf(buf,STRMSG_C_070816_0103,pMapInfo->MapName, pMsg->RemainTime);
	m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);
	g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_BEFORE,pMsg->MapIndex);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostWarStart(MSG_FC_OUTPOST_WAR_START* pMsg)
/// \brief		  ߹.
/// \author		dgwoo
/// \date		2007-09-06 ~ 2007-09-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostWarStart(MSG_FC_OUTPOST_WAR_START* pMsg)
{
	char buf[512];
	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	// 2008-10-14 by dgwoo  ðϴ κ 
	//wsprintf(buf,STRMSG_C_070816_0109,pMapInfo->MapName);
	wsprintf(buf,STRMSG_C_070816_0118,pMapInfo->MapName);
	m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);
//	g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_WAR_START);
//	g_pGameMain->m_pOutPost->AddOutPostMapIndex(pMsg->MapIndex);
//	g_pGameMain->m_pOutPost->SetWarTime(pMsg->WarStartTime,pMsg->WarEndTime);
	g_pGameMain->m_pOutPost->AddOutPost(pMsg->MapIndex,OUTPOST_STATE_WAR_START,pMsg->Influence,pMsg->WarStartTime,pMsg->WarEndTime);
	// 2008-10-14 by dgwoo  ðϴ κ 
	//wsprintf(buf,STRMSG_C_070816_0118,pMapInfo->MapName);
	g_pInterface->ShowOpWndTxt(STRMSG_C_081014_0100);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostProtectorDestroy(MSG_FC_OUTPOST_PROTECTOR_DESTROY* pMsg)
/// \brief		 ȣ ı.
/// \author		dgwoo
/// \date		2007-09-06 ~ 2007-09-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostProtectorDestroy(MSG_FC_OUTPOST_PROTECTOR_DESTROY* pMsg)
{
	char buf[512];
	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	// 2008-10-16 by dgwoo Ʈ 
	//wsprintf(buf,STRMSG_C_070816_0105);
	wsprintf(buf,"\\c[%s]\\c%s",pMapInfo->MapName,STRMSG_C_070816_0105);
	m_pChat->CreateChatChild(buf,COLOR_ITEM);

	// 2007-10-05 by dgwoo ڳ    Ľ .
	if(pMsg->GuildUID == 0)
	{
		g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_WAR_START,pMsg->MapIndex);
		// 2008-10-16 by dgwoo Ʈ 
		wsprintf(buf,"\\c[%s]\\c%s",pMapInfo->MapName,STRMSG_C_071005_0100);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
		return;
	}
	g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_PROTECT_DESTROY,pMsg->MapIndex);
	if(COMPARE_INFLUENCE(INFLUENCE_TYPE_VCN, pMsg->Influence))
	{
		wsprintf(buf,STRMSG_C_070816_0106,STRMSG_C_060210_0000,pMsg->GuildName,pMapInfo->MapName);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
	}
	else if(COMPARE_INFLUENCE(INFLUENCE_TYPE_ANI, pMsg->Influence))
	{
		wsprintf(buf,STRMSG_C_070816_0106,STRMSG_C_060210_0001,pMsg->GuildName,pMapInfo->MapName);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
	}
	if(COMPARE_INFLUENCE(g_pShuttleChild->m_myShuttleInfo.InfluenceType, pMsg->Influence))
	{
		wsprintf(buf,STRMSG_C_071002_0103);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
	}
	
}



///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostResetStartOk(MSG_FC_OUTPOST_RESET_START_OK* pMsg)
/// \brief		 .
/// \author		dgwoo
/// \date		2007-09-06 ~ 2007-09-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostResetStartOk(MSG_FC_OUTPOST_RESET_START_OK* pMsg)
{
	char buf[512];
	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
//	m_pChat->CreateChatChild(buf,COLOR_ITEM);
	g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_RESET_START,pMsg->MapIndex);
	if(COMPARE_INFLUENCE(INFLUENCE_TYPE_VCN, pMsg->Influence))
	{
		wsprintf(buf,STRMSG_C_070816_0107,STRMSG_C_060210_0000,pMsg->GuildName,pMapInfo->MapName);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
	}
	else if(COMPARE_INFLUENCE(INFLUENCE_TYPE_ANI, pMsg->Influence))
	{
		wsprintf(buf,STRMSG_C_070816_0107,STRMSG_C_060210_0001,pMsg->GuildName,pMapInfo->MapName);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
	}

	// 2007-10-02 by dgwoo ߰.
	if(!COMPARE_INFLUENCE(INFLUENCE_TYPE_NORMAL,g_pShuttleChild->m_myShuttleInfo.InfluenceType))
	{// ˸, .
		//g_pGameMain->m_pOutPost->m_bAttackerInf = pMsg->Influence;
		g_pGameMain->m_pOutPost->SetAttInfluence(pMsg->MapIndex,pMsg->Influence);
		if(COMPARE_INFLUENCE(pMsg->Influence,g_pShuttleChild->m_myShuttleInfo.InfluenceType))
		{// .
			if(pMsg->GuildUID == g_pShuttleChild->GetMyShuttleInfo().GuildUniqueNumber					// ı 鼭.
				&& (COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_INFLUENCE_LEADER) ||		// .
					COMPARE_RACE(g_pShuttleChild->m_myShuttleInfo.Race,RACE_INFLUENCE_SUBLEADER_MASK)))		// .
			{
				wsprintf(buf,STRMSG_C_071002_0100);				//"ý ü  ߾óġ ıϼ."
				m_pChat->CreateChatChild(buf,COLOR_ITEM);
			}
		}
		else
		{// .
			wsprintf(buf,STRMSG_C_071002_0101);				//"ü Ϸ   ߾óġ ıϷ   Ͻÿ."
			m_pChat->CreateChatChild(buf,COLOR_ITEM);
		}
	}
	wsprintf(buf,STRMSG_C_070816_0111,OUTPOST_RESET);
	m_pChat->CreateChatChild(buf,COLOR_VOIP);

	g_pGameMain->m_pOutPost->SetResetTime(pMsg->MapIndex,pMsg->ResetStartTime,pMsg->ResetEndTime);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostResetDestroy(MSG_FC_OUTPOST_RESET_DESTROY* pMsg)
/// \brief		ε ıǾ.
/// \author		dgwoo
/// \date		2007-09-06 ~ 2007-09-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostResetDestroy(MSG_FC_OUTPOST_RESET_DESTROY* pMsg)
{
	char buf[512];
	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	wsprintf(buf,STRMSG_C_070816_0114);
	m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);
	g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_RESET_DESTROY,pMsg->MapIndex);
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostResetSuccess(MSG_FC_OUTPOST_RESET_SUCCESS* pMsg)
/// \brief		 .
/// \author		dgwoo
/// \date		2007-09-06 ~ 2007-09-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostResetSuccess(MSG_FC_OUTPOST_RESET_SUCCESS* pMsg)
{
	char buf[512];
	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
// 2007-09-06 by dgwoo         Ų.
//	if(g_pShuttleChild->GetMyShuttleInfo().GuildUniqueNumber != pMsg->Influence
//		pMsg->GuildUID)
	wsprintf(buf,STRMSG_C_070816_0115);
	m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);

	if(COMPARE_INFLUENCE(INFLUENCE_TYPE_VCN, pMsg->Influence))	
	{
		wsprintf(buf,STRMSG_C_070816_0112,STRMSG_C_060210_0000,pMsg->GuildName,pMapInfo->MapName);

	}
	else if(COMPARE_INFLUENCE(INFLUENCE_TYPE_ANI, pMsg->Influence))	
	{
		wsprintf(buf,STRMSG_C_070816_0112,STRMSG_C_060210_0001,pMsg->GuildName,pMapInfo->MapName);
	}
	m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);

	wsprintf(buf,STRMSG_C_070816_0113);
	m_pChat->CreateChatChild(buf,COLOR_ITEM);

	g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_RESET_SUCCESS,pMsg->MapIndex);

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostWarEnd(MSG_FC_OUTPOST_WAR_END* pMsg)
/// \brief		 ð .
/// \author		dgwoo
/// \date		2007-09-06 ~ 2007-09-06
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostWarEnd(MSG_FC_OUTPOST_WAR_END* pMsg)
{
	char buf[512];
	MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_WAR_END,pMsg->MapIndex);
	g_pGameMain->m_pOutPost->DeleteOutPostMapIndex(pMsg->MapIndex);

	wsprintf(buf,STRMSG_C_070816_0110,pMapInfo->MapName);							// "%s  Ǿϴ."
	g_pInterface->ShowOpWndTxt(buf);
	m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);

	if(COMPARE_INFLUENCE(INFLUENCE_TYPE_VCN, pMsg->Influence))	
	{
		wsprintf(buf,STRMSG_C_070816_0119,STRMSG_C_060210_0000,pMsg->GuildName,pMapInfo->MapName);
		m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);
	}
	else if(COMPARE_INFLUENCE(INFLUENCE_TYPE_ANI, pMsg->Influence))
	{
		wsprintf(buf,STRMSG_C_070816_0119,STRMSG_C_060210_0001,pMsg->GuildName,pMapInfo->MapName);
		m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);
	}
}
VOID CAtumApplication::FieldSocketInfoNoticeRequestOk(MSG_FC_INFO_NOTICE_REQUEST_OK* pMsg)
{	
	int nBuildIdx = BUILDINGKIND_CITYLEADER_OUTPOST;
	if(TRUE == IsLeaderOutPost())
	{
		nBuildIdx = BUILDINGKIND_CITYLEADER_LEADER;
	}

	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildIdx);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end() ||
		it->second == NULL)
	{
		return;
	}
	if(BUILDINGKIND_CITYLEADER_OUTPOST == nBuildIdx)
	{		
		CINFCityOutPost * pCityOutPost = ((CINFCityOutPost*)it->second);
		pCityOutPost->SetNotice(pMsg->NoticeString);
	}
	else if(BUILDINGKIND_CITYLEADER_LEADER == nBuildIdx)
	{		
		CINFCityLeader * pCityOutPost = ((CINFCityLeader*)it->second);
		pCityOutPost->SetNotice(pMsg->NoticeString);
	}
	
}
VOID CAtumApplication::FieldSocketInfoNoticeRegOk()
{
}
VOID CAtumApplication::FieldSocketInfoNoticeModifyOk()
{
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketInfoExpediencyfundPayBackOk(MSG_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK* pMsg)
/// \brief		    
/// \author		// 2007-09-05 by bhsohn  
/// \date		2007-09-10 ~ 2007-09-10
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoExpediencyfundPayBackOk(MSG_FC_INFO_EXPEDIENCYFUND_PAYBACK_OK* pMsg)
{	
	int nBuildIdx = BUILDINGKIND_CITYLEADER_OUTPOST;
	if(TRUE == IsLeaderOutPost())
	{
		nBuildIdx = BUILDINGKIND_CITYLEADER_LEADER;
	}

	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildIdx);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end() ||
		it->second == NULL)
	{
		return;
	}
	
	char buf[1024] = {0,};
	wsprintf(buf, STRMSG_C_070910_0208, pMsg->ExpediencyFundPayBackCount);
	m_pChat->CreateChatChild(buf, COLOR_ITEM);	
	
	if(BUILDINGKIND_CITYLEADER_OUTPOST == nBuildIdx)
	{		
		CINFCityOutPost * pCityOutPost = ((CINFCityOutPost*)it->second);
		pCityOutPost->SetExpenceInfo((float)pMsg->ExpediencyFundRate, pMsg->CumulativeExpediencyFund, pMsg->ExpediencyFund);
	}
	else if(BUILDINGKIND_CITYLEADER_LEADER == nBuildIdx)
	{		
		CINFCityLeader * pCityOutPost = ((CINFCityLeader*)it->second);
		pCityOutPost->SetExpenceInfo((float)pMsg->ExpediencyFundRate, pMsg->CumulativeExpediencyFund, pMsg->ExpediencyFund);		 
	}
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketInfoExpediencyfundRequestOk(MSG_FC_INFO_EXPEDIENCYFUND_REQUEST_OK* pMsg)
/// \brief		//    
/// \author		// 2007-09-05 by bhsohn  
/// \date		2007-09-10 ~ 2007-09-10
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketInfoExpediencyfundRequestOk(MSG_FC_INFO_EXPEDIENCYFUND_REQUEST_OK* pMsg)
{
	int nBuildIdx = BUILDINGKIND_CITYLEADER_OUTPOST;
	if(TRUE == IsLeaderOutPost())
	{
		nBuildIdx = BUILDINGKIND_CITYLEADER_LEADER;
	}

	//    
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildIdx);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end() ||
		it->second == NULL)
	{
		return;
	}
	if(BUILDINGKIND_CITYLEADER_OUTPOST == nBuildIdx)
	{		
		CINFCityOutPost * pCityOutPost = ((CINFCityOutPost*)it->second);
		pCityOutPost->SetExpenceInfo((float)pMsg->ExpediencyFundRate, pMsg->CumulativeExpediencyFund, pMsg->ExpediencyFund);
	}
	else if(BUILDINGKIND_CITYLEADER_LEADER == nBuildIdx)
	{		
		CINFCityLeader * pCityOutPost = ((CINFCityLeader*)it->second);
		pCityOutPost->SetExpenceInfo((float)pMsg->ExpediencyFundRate, pMsg->CumulativeExpediencyFund, pMsg->ExpediencyFund);		 
	}	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostNextWarInfoRequestOk(MSG_FC_OUTPOST_NEXTWAR_INFO_REQUEST_OK* pMsg)
/// \brief		//   ð 
/// \author		// 2007-09-05 by bhsohn  
/// \date		2007-09-10 ~ 2007-09-10
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostNextWarInfoRequestOk(MSG_FC_OUTPOST_NEXTWAR_INFO_REQUEST_OK* pMsg)
{
	int nBuildIdx = BUILDINGKIND_CITYLEADER_OUTPOST;
	if(TRUE == IsLeaderOutPost())
	{
		nBuildIdx = BUILDINGKIND_CITYLEADER_LEADER;
	}
	
	//    
	CMapCityShopIterator it = g_pInterface->m_pCityBase->m_mapCityShop.find(nBuildIdx);
	if(it == g_pInterface->m_pCityBase->m_mapCityShop.end() ||
		it->second == NULL)
	{
		return;
	}
	
	ATUM_DATE_TIME *pTimeList = (ATUM_DATE_TIME*)((char *)pMsg + sizeof(MSG_FC_OUTPOST_NEXTWAR_INFO_REQUEST_OK));
	vector<ATUM_DATE_TIME>	vectmpTimeList;
	
	int i = 0;
	for(i = 0 ; i < pMsg->OutPostNextWarTimeListCount ; i++)
	{		
		ATUM_DATE_TIME tmpTimeList;
		memcpy(&tmpTimeList, pTimeList, sizeof(ATUM_DATE_TIME));
	
		// 2007-10-31 by bhsohn  ð  ߸   ó
		tmpTimeList.Year = 2007;
		tmpTimeList.Month = 1;
		tmpTimeList.Day = 1;
		// end 2007-10-31 by bhsohn  ð  ߸   ó

		vectmpTimeList.push_back(tmpTimeList);
		pTimeList++;
	}
	if(BUILDINGKIND_CITYLEADER_OUTPOST == nBuildIdx )
	{		
		CINFCityOutPost * pCityOutPost = ((CINFCityOutPost*)it->second);
		pCityOutPost->SetNextWarInfo(pMsg->OutPostNextWarTime, pMsg->OutPostNextWarSelectTimeChoice, vectmpTimeList);
	}
	else if(BUILDINGKIND_CITYLEADER_LEADER == nBuildIdx )
	{		
		CINFCityLeader * pCityOutPost = ((CINFCityLeader*)it->second);
		pCityOutPost->SetNextWarInfo(pMsg->OutPostNextWarTime, pMsg->OutPostNextWarSelectTimeChoice, vectmpTimeList);
	}
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketOutPostNextWarInfoRequestOk(MSG_FC_OUTPOST_NEXTWAR_INFO_REQUEST_OK* pMsg)
/// \brief		//   ð 
/// \author		// 2007-09-05 by bhsohn  
/// \date		2007-09-10 ~ 2007-09-10
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketOutPostNextWarSetTimeOk(MSG_FC_OUTPOST_NEXTWAR_SET_TIME_OK* pMsg)
{	
	MAP_INFO* pMapinfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	if(NULL == pMapinfo)
	{
		return;
	}
	char buf[1024] = {0,};
	// 2007-10-05 by bhsohn ,, Ʈ ý ߰
//	wsprintf(buf, STRMSG_C_070910_0204, pMapinfo->MapName, 
//										pMsg->OutPostNextWarTime.Month, pMsg->OutPostNextWarTime.Day,
//										pMsg->OutPostNextWarTime.Hour, pMsg->OutPostNextWarTime.Minute);
	string szStrBuf;
	ATUM_DATE_TIME timeTmp;
	timeTmp.GetLocalString_MMDD(pMsg->OutPostNextWarTime.Month, pMsg->OutPostNextWarTime.Day, szStrBuf,GetLanguageType());

	wsprintf(buf, STRMSG_C_070910_0204, pMapinfo->MapName, 
										szStrBuf.c_str(),
										pMsg->OutPostNextWarTime.Hour, pMsg->OutPostNextWarTime.Minute);
	// end 2007-10-05 by bhsohn ,, Ʈ ý ߰

	m_pChat->CreateChatChild(buf, COLOR_ITEM);	

}

VOID CAtumApplication::FieldSocketOutPostWarInfo(MSG_FC_OUTPOST_WAR_INFO* pMsg)
{
	// 2008-12-31 by bhsohn  ۷ ȶߴ  	
	int nOutPosMapIdx = -1;
	// end 2008-12-31 by bhsohn  ۷ ȶߴ  

	SOUTPOST_WAR_INFO *pOutPost = (SOUTPOST_WAR_INFO*)((char *)pMsg + sizeof(MSG_FC_OUTPOST_WAR_INFO));
	for(int i = 0; i < pMsg->OutPostWarInfoListCount ; i++)
	{
//		g_pGameMain->m_pOutPost->AddOutPostMapIndex(pOutPost->MapIndex);
//		g_pGameMain->m_pOutPost->m_bAttackerInf = pOutPost->OutPostResetIngInfluence;
//		if(IS_OUTPOST_RESETING(pOutPost->OutPostState))
//		{
//			g_pGameMain->m_pOutPost->SetOutPostState(OUTPOST_STATE_RESET_START);
//		}
//		g_pGameMain->m_pOutPost->SetWarTime(pOutPost->OutPostWarStartTime,pOutPost->OutPostWarEndTime);
//		g_pGameMain->m_pOutPost->SetResetTime(pOutPost->OutPostWarResetRamainSecondTime );
		if(IS_OUTPOST_RESETING(pOutPost->OutPostState))
		{
			g_pGameMain->m_pOutPost->AddOutPost(pOutPost->MapIndex,OUTPOST_STATE_RESET_START,pOutPost->OutPostResetIngInfluence,pOutPost->OutPostWarStartTime,pOutPost->OutPostWarEndTime,pOutPost->OutPostWarResetRamainSecondTime);
		}
		else
		{
			// 2008-12-31 by bhsohn  ۷ ȶߴ  
			nOutPosMapIdx = pOutPost->MapIndex;
			// end 2008-12-31 by bhsohn  ۷ ȶߴ  
			g_pGameMain->m_pOutPost->AddOutPost(pOutPost->MapIndex,OUTPOST_STATE_WAR_START,pOutPost->OutPostResetIngInfluence,pOutPost->OutPostWarStartTime,pOutPost->OutPostWarEndTime,pOutPost->OutPostWarResetRamainSecondTime);
		}
		
		pOutPost++;
	}
	// 2008-12-31 by bhsohn  ۷ ȶߴ  
	if(nOutPosMapIdx != -1 && m_pChat)
	{
		char buf[512];
		MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(nOutPosMapIdx);		
		if(pMapInfo)
		{
			wsprintf(buf,STRMSG_C_070816_0118,pMapInfo->MapName);
			m_pChat->CreateChatChild(buf,COLOR_MONSTER_ID04);
		}		
		g_pInterface->ShowOpWndTxt(STRMSG_C_081014_0100);

	}
	// end 2008-12-31 by bhsohn  ۷ ȶߴ  

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			void CAtumApplication::AddSpeakerGMString(char* pGmChat)
/// \brief		
/// \author		// 2007-08-07 by bhsohn Ŀ  ߰
/// \date		2007-08-07 ~ 2007-08-07
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::AddSpeakerGMString(char* pGmChat, BOOL bGmColor)
{
	if(g_pGameMain)
	{	
		g_pGameMain->AddSpeakerMsgString(pGmChat, TRUE, bGmColor);
	}
	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketTutorialEndOK()
/// \brief		Ʃ丮 .
/// \author		dgwoo
/// \date		2007-07-16 ~ 2007-07-16
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketTutorialEndOK()
{
	// 2009. 10. 14 by jskim ī  - ó Ʃ丮  ѷα ȳ  ó
	m_pTutorial->SetTutorialEd(TRUE);
	//end 2009. 10. 14 by jskim ī  - ó Ʃ丮  ѷα ȳ  ó
}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketEventTeleportBuildComplete(MSG_FC_EVENT_TELEPORT_BUILDCOMPLETE* pMsg)
/// \brief		ڷƮ ġ Ϸ.
/// \author		dgwoo
/// \date		2007-09-19 ~ 2007-09-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventTeleportBuildComplete(MSG_FC_EVENT_TELEPORT_BUILDCOMPLETE* pMsg)
{
	char buf[1024] = {0,};
	MAP_INFO* pMapinfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	wsprintf(buf, STRMSG_C_070816_0120,pMapinfo->MapName);
	m_pChat->CreateChatChild(buf, COLOR_ITEM);	
	// ̽ .
	m_pInterface->m_pToolTip->SetImgType(TOOLTIP_IMGTYPE_TELEPORT_SUC);

}
///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketEventTeleportDestroy(MSG_FC_EVENT_TELEPORT_DESTROY* pMsg)
/// \brief		ڷƮ ı
/// \author		dgwoo
/// \date		2007-09-19 ~ 2007-09-19
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventTeleportDestroy(MSG_FC_EVENT_TELEPORT_DESTROY* pMsg)
{
	char buf[1024] = {0,};
	MAP_INFO* pMapinfo = g_pDatabase->GetMapInfo(pMsg->MapIndex);
	if(pMsg->bInactivateByOtherTeleport)
	{// ڷƮ Ȱȭ.
		wsprintf(buf,STRMSG_C_070816_0123,pMapinfo->MapName);					//"\\y%s\\c ڷƮ Ȱȭ Ǿϴ."
	}
	else
	{// ڷƮ ı.
		wsprintf(buf, STRMSG_C_070816_0121,pMapinfo->MapName);					//"\\y%s\\c \\yڷƮ\\c ıǾϴ."
		// ̽ .
		m_pInterface->m_pToolTip->SetImgType(TOOLTIP_IMGTYPE_TELEPORT_DESTROY);

	}
	m_pChat->CreateChatChild(buf, COLOR_ITEM);	
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID	FieldSocketArenaGMCommandInfoHeader();
/// \brief		GMɾ û   ѹ ش.(Ʒ Ŷ)
///				FieldSocketArenaGMCommandInfo,FieldSocketArenaGMCommandInfoDone
/// \author		dgwoo
/// \date		2007-05-28 ~ 2007-05-28
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketArenaGMCommandInfoHeader()
{
	m_vecTeamInfo.clear();
	m_bRequestEnable = FALSE;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			VOID CAtumApplication::FieldSocketCharacterBuyWarPointItem(MSG_FC_CHARACTER_BUY_WARPOINT_ITEM* pMsg)
/// \brief		Ʈ޿  Ž  ͸ Ű Լ.
/// \author		dgwoo
/// \date		2007-06-13 ~ 2007-06-13
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketShopBuyWarPointItemOK(MSG_FC_SHOP_BUY_WARPOINT_ITEM_OK* pMsg)
{
	g_pShuttleChild->m_myShuttleInfo.WarPoint = pMsg->WarPoint;
}
VOID CAtumApplication::FieldSocketArenaGMCommandInfo(MSG_FC_ARENA_GM_COMMAND_INFO* pMsg)
{
	MSG_FC_ARENA_GM_COMMAND_INFO sTeamInfo;
	memset(&sTeamInfo,0x00,sizeof(MSG_FC_ARENA_GM_COMMAND_INFO));
	sTeamInfo.ArenaMode			= pMsg->ArenaMode;
	sTeamInfo.Level				= pMsg->Level;
	sTeamInfo.MemberCount		= pMsg->MemberCount;
	sTeamInfo.TeamCount			= pMsg->TeamCount;
	m_vecTeamInfo.push_back(sTeamInfo);
}
VOID CAtumApplication::FieldSocketArenaGMCommandInfoDone(MSG_FC_ARENA_GM_COMMAND_INFO_DONE* pMsg)
{
	char buf[256];
	char cLevel;
	char sArenaMode[256];
	sort(m_vecTeamInfo.begin(),m_vecTeamInfo.end(),ArenaTeamInfo());
	vector<MSG_FC_ARENA_GM_COMMAND_INFO>::iterator it = m_vecTeamInfo.begin();
	while(m_vecTeamInfo.end() != it)
	{
		if(it->ArenaMode == ARENAMODE_DEATHMATCH)
			wsprintf(sArenaMode,"%s",STRMSG_C_070427_0100);
		else
			wsprintf(sArenaMode,"%s",STRMSG_C_070427_0101);

		if(it->Level >= ARENA_STAGE_A_START_LEVEL)
			cLevel = STRMSG_C_070528_0102;
		else if(it->Level >= ARENA_STAGE_B_START_LEVEL)
			cLevel = STRMSG_C_070528_0103;
		else if(it->Level >= ARENA_STAGE_C_START_LEVEL)
			cLevel = STRMSG_C_070528_0104;
		else if(it->Level >= ARENA_STAGE_D_START_LEVEL)
			cLevel = STRMSG_C_070528_0105;
	
		wsprintf(buf,STRMSG_C_070528_0100,sArenaMode,cLevel,it->MemberCount,it->TeamCount);
		m_pChat->CreateChatChild(buf,COLOR_ITEM);
		it++;
	}
	wsprintf(buf,STRMSG_C_070528_0101,pMsg->ReadyUserTotalCount,pMsg->MatchIngUserTotalCount,pMsg->ArenaFightIngUserTotalCount);
	m_pChat->CreateChatChild(buf,COLOR_ITEM);
	m_bRequestEnable = TRUE;
}

// 2009. 04. 06 by ckPark ӽ۽ ߷ æƮ  ȵȻ·  (0001388)
void	CAtumApplication::FieldSocketPutEnchantDone( void )
{
	
	// 2010. 01. 12 by ckPark      ƴ   ϴ  ذ

// 	float fWeight = g_pStoreData->GetTotalWeight() / CAtumSJ::GetTransport(&g_pShuttleChild->m_myShuttleInfo);
// 	if(fWeight >= 0.9f)
// 	{
// 		m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0044,COLOR_SYSTEM);//" 緮 90% ʰ Ͽϴ."
// 		m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0045,COLOR_SYSTEM);//"ּ ӵθ ̵ϸ, Ҹ մϴ."
// 	}
// 	else if(fWeight > WEIGHT_RATE_VERY_HEAVY)
// 	{
// 		m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0046,COLOR_SYSTEM);//" 緮 80% ʰ Ͽϴ."
// 		m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0047,COLOR_SYSTEM);//"ν  ѵǸ, Ҹ մϴ."
// 	}
// 	else if(fWeight >= WEIGHT_RATE_HEAVY)
// 	{
// 		m_pChat->CreateChatChild(STRMSG_C_INTERFACE_0048,COLOR_SYSTEM);//" 緮 70% ʰϿ Ҹ մϴ."
// 	}

	// end 2010. 01. 12 by ckPark      ƴ   ϴ  ذ

}
// end 2009. 04. 06 by ckPark ӽ۽ ߷ æƮ  ȵȻ·  (0001388)

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		dgwoo
/// \date		2008-01-15 ~ 2008-01-15
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventCouponEventUseCouponOK(MSG_FC_EVENT_COUPON_EVENT_USE_COUPON_OK* pMsg)
{
	m_bRequestEnable = TRUE;
	g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_080115_0100, _Q_COUPON);//"  Ǿϴ."
	g_pGameMain->ShowCouponWindow(FALSE);
	g_pGameMain->m_pCouponBtn->EnableBtn(FALSE);
	g_pGameMain->m_pCouponBtn->ShowWindow(FALSE);

}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		
/// \author		dgwoo
/// \date		2008-01-15 ~ 2008-01-15
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
VOID CAtumApplication::FieldSocketEventCouponEventInfo(MSG_FC_EVENT_COUPON_EVENT_INFO* pMsg)
{
	g_pGameMain->SetCouponActive(pMsg);
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::RenderRequestEnable()
/// \brief		 û Ұ  ޽ 
/// \author		jschoi
/// \date		2005-03-03 ~ 2005-03-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::RenderRequestEnable()
{
	// 2007-12-17 by bhsohn    ȿ  ·
	//if(m_bRequestEnable == TRUE)
	if(IsLockMode() == TRUE)
	{
		return;
	}
	
	if(m_dwGameState == _SELECT)
	{
		if(g_pSelect)
		{
			g_pSelect->RenderRequestEnable(m_fRequestEnableTime);
		}
	}
	else
	{
		if(g_pGameMain)
		{
			g_pGameMain->RenderRequestEnable(m_fRequestEnableTime);
		}
	}
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			CAtumApplication::RequestEnableTick(float fElapsedTime)
/// \brief		
/// \author		jschoi
/// \date		2005-03-03 ~ 2005-03-03
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
void CAtumApplication::RequestEnableTick(float fElapsedTime)
{	
	// 2008-01-17 by bhsohn Locký ߰
	//if(m_bRequestEnable == FALSE)
	if(IsLockMode()== FALSE)
	{
		m_fRequestEnableTime += fElapsedTime;
		if(m_fRequestEnableTime > REQUEST_ENABLE_TIME)	
		{
			m_fRequestEnableTime -= REQUEST_ENABLE_TIME;
		}
	}
	else
	{
		m_fRequestEnableTime = REQUEST_ENABLE_INIT_TIME;
	}
}


// 2005-03-16 by jschoi
VOID CAtumApplication::FieldSocketStoreInsertUsingItem(MSG_FC_STORE_INSERT_USINGITEM* pMsg)
{
	ITEM* pItemInfo = g_pDatabase->GetServerItemInfo(pMsg->ItemNum);
	g_pGameMain->m_pInfSkill->InsertItemInfo(pItemInfo, pMsg->ItemUID, pMsg->nRemainSecond);
	
// 2012-11-29 by mspark, ġ ġ ̵ϴ ĳ ġ ϵ 
#ifdef C_SEARCHEYE_SHUTTLE_POSITION_MSPARK
	m_nItemNum = pItemInfo->ItemNum;
#endif
// end 2012-11-29 by mspark, ġ ġ ̵ϴ ĳ ġ ϵ 

	if(ITEMKIND_CARD == pItemInfo->Kind
		&& COMPARE_BIT_FLAG(pItemInfo->ItemAttribute, ITEM_ATTR_TIME_LIMITE)
		&& 0 < pItemInfo->ReAttacktime)
	{// 2007-06-21 by dgwoo ð   Կ ǥ.
		g_pGameMain->m_pQuickSlot->StartReattackTime(pItemInfo);
	}
	// 2008-11-26 by bhsohn ð   
	else if(ITEMKIND_CARD == pItemInfo->Kind
		&& COMPARE_BIT_FLAG(pItemInfo->ItemAttribute, ITEM_ATTR_DELETED_TIME_LIMITE_AFTER_USED)
		&& 0 < pItemInfo->ReAttacktime)
	{
		g_pGameMain->m_pQuickSlot->StartReattackTime(pItemInfo);
	}
	// end 2008-11-26 by bhsohn ð   
	// 2010. 04. 14 by jskim   ν  ߰
	g_pShuttleChild->RecalculateSpeedAndAngle();
	g_pShuttleChild->SetShuttleSpeed();
	//end 2010. 04. 14 by jskim   ν  ߰
}

// 2005-03-16 by jschoi
VOID CAtumApplication::FieldSocketStoreDeleteUsingItem(MSG_FC_STORE_DELETE_USINGITEM* pMsg)
{
	ITEM* pItemInfo = g_pDatabase->GetServerItemInfo(pMsg->ItemNum);
	g_pGameMain->m_pInfSkill->DeleteItemInfo(pItemInfo);

	// 2010. 04. 14 by jskim   ν  ߰
	g_pShuttleChild->RecalculateSpeedAndAngle();
	g_pShuttleChild->SetShuttleSpeed();
	//end 2010. 04. 14 by jskim   ν  ߰
}



///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketErrorByErrorCode(MSG_ERROR* pMsg)
/// \brief		ErrorCode  ˻ 켱
/// \author		jschoi
/// \date		2005-03-17 ~ 2005-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CAtumApplication::FieldSocketErrorByErrorCode(MSG_ERROR* pMsg)
{
	char errStr[512];
	if(pMsg->ErrorCode == ERR_PROTOCOL_NOT_ENOUGH_EP)							// EP (ν ۵ Ұ)
	{
		wsprintf(errStr,STRERR_ERROR_0003);//"ᰡ մϴ. Ḧ ä켼."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_TOO_LONG_DISTANCE)						// Ÿ ʹ ִ(ex. SIZE_VISIBLERECT_X̻)
	{
		wsprintf(errStr,STRERR_ERROR_0004);//"Ÿ ʹ ָ  ֽϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_ALREADY_P2P_PK)							// ̹ ϴ PK 
	{
		wsprintf(errStr,STRERR_ERROR_0005);//"̹ Դϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_TOO_FAR_TO_P2P_PK)						// ʹ ־ ϴ PK Ұ
	{
		wsprintf(errStr,STRERR_ERROR_0006);//"Ÿ ʹ ָ  ־ û   ϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_HIGH_LEVEL_GAP_TO_P2P_PK)				//     PK Ұ
	{
		wsprintf(errStr,STRERR_ERROR_0007);//" ̰ 10̻  1:1   ϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_NOT_DOING_P2P_PK)						// PK  ƴ
	{
		wsprintf(errStr,STRERR_ERROR_0008);//"  ƴմϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_CANNOT_USE_ITEM)
	{
		wsprintf(errStr,STRERR_ERROR_0009);//"ش     ִ ° ƴմϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_RACE_NOT_MATCHED)
//	{
//		wsprintf(errStr,"ش  ƴմϴ. ѹ  Ȯ ֽñ ٶϴ.");
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_ATTACK_PART_NOT_MATCHED)
//	{
//		wsprintf(errStr," Ʈ Ʈ մϴ.");
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_DEFENSE_PART_NOT_MATCHED)
//	{
//		wsprintf(errStr," Ʈ Ʈ մϴ.");//-->
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_FUEL_PART_NOT_MATCHED)
//	{
//		wsprintf(errStr," Ʈ Ʈ մϴ.");
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_SOUL_PART_NOT_MATCHED)
//	{
//		wsprintf(errStr," Ʈ Ʈ մϴ.");
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_UNITKIND_NOT_MATCHED)
//	{
//		wsprintf(errStr,"      Դϴ.");
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED)
//	{
//		wsprintf(errStr," մϴ.");
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_SHIELD_PART_NOT_MATCHED)
//	{
//		wsprintf(errStr," Ʈ Ʈ մϴ.");//->
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_DODGE_PART_NOT_MATCHED)
//	{
//		wsprintf(errStr,"ȸ Ʈ Ʈ մϴ.");
//		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
//	}
	
	// 2009. 10. 08 by ckPark ʵ â  ߺ Ұ ó
	
	// T_FC_ITEM_USE_RANDOMBOX  ó ű
// 	else if(pMsg->ErrorCode == ERR_PROTOCOL_ALREADY_HAVE_ITEM)
// 	{
// 		wsprintf(errStr,STRERR_ERROR_0010);// "̹   ֽϴ."
// 		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
// 	}

	// end 2009. 10. 08 by ckPark ʵ â  ߺ Ұ ó

	else if(pMsg->ErrorCode == ERR_PROTOCOL_ALREADY_HAVE_SKILL)
	{
		wsprintf(errStr,STRERR_ERROR_0011);// "̹ ų  ֽϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_EXPERIENCE_NOT_MATCHED)
	{
		wsprintf(errStr,STRERR_ERROR_0012);// "ġ մϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_ALREADY_MAX_PARTY_MEMBER)
	{
		wsprintf(errStr,STRERR_ERROR_0013);// " ο ִ Ѿϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_MIN_TRADE_QUANTITY_ERROR)
	{
		wsprintf(errStr,STRERR_ERROR_0014,pMsg->ErrParam1);// "%d  ŷϽʽÿ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_TOO_FAR_TO_TRADE)
	{
		wsprintf(errStr,STRERR_ERROR_0015);// "ָ  ־ ŷ  ʽϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_ALREADY_TRADING)
	{
		wsprintf(errStr,STRERR_ERROR_0016);// "̹ ŷԴϴ."
		m_pChat->CreateChatChild(errStr,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_NOT_LOGINED)
	{
		NetworkErrorMsgBox(STRERR_ERROR_0017);// " ٰԴϴ. Ŭ̾Ʈ մϴ."
	}
	else if (pMsg->ErrorCode == ERR_PROTOCOL_NOT_ENOUGH_SP)
	{ 
		m_pChat->CreateChatChild(STRERR_ERROR_0018,COLOR_SKILL_CANCEL);// "ųƮ մϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_ITEM_CANNOT_TRANSFER)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0019,COLOR_ERROR);// "̵    Դϴ."		
		
		// ̵   Դϴ.
		//UpdateMutltiItemError();
		// 2008-08-18 by bhsohn 1   ̵ ý 
		IntervalSellMutltiOneItem();
		// end 2008-08-18 by bhsohn 1   ̵ ý 
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_ITEM_OVER_WEIGHT)
	{
		m_pChat->CreateChatChild(STRMSG_C_050927_0001,COLOR_ERROR);// "緮 ʰϿ     ϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_DO_NOT_HAVE_LINK_ITEM )
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0021,COLOR_ERROR);// "ų    ʿ  ϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_INVENTORY_FULL_ITEM)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0022,COLOR_ERROR,CHAT_TAB_SYSTEM);// "κ丮  մϴ."
		// 2007-03-09 by bhsohn   â κ 
		DelMultiItemList();	
		// end 2007-03-09 by bhsohn   â κ 

		// 2009-05-18 by bhsohn Ű κǮϋ  ó
		if(pMsg->MsgType == T_FC_ITEM_USE_LUCKY_ITEM)
		{
			GUI_BUILDINGNPC* pBuilding = g_pInterface->m_pCityBase->GetCurrentBuildingNPC();
			if(pBuilding)
			{
				if(BUILDINGKIND_LUCKY == pBuilding->buildingInfo.BuildingKind)
				{
					CINFLuckyMachine* pStore = (CINFLuckyMachine*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LUCKY);			
					if(pStore)
					{
						pStore->ErrorLuckyMechineInvenFull();
						pStore->ResetLuckyMachineInfo();
					}	
				}

			}
			
		}
		// end 2009-05-18 by bhsohn Ű κǮϋ  ó

	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_STORE_FULL_ITEM)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0023,COLOR_ERROR);// "â   մϴ."
		// 2007-03-09 by bhsohn   â κ 
		DelMultiItemList();	
		// end 2007-03-09 by bhsohn   â κ 
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_ITEM_NOT_MATCHED)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0024,COLOR_ERROR);// "ʿ   ̼    ϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_NO_SUCH_ITEM)
	{// 2006-10-17 by dgwoo â    ش.
		if(pMsg->MsgType == T_FC_STORE_MOVE_ITEM)
		{
			CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
			pStore->SetStoreItemSPI();
		}
		// 2008-02-12 by bhsohn  ش ٴ ޽ 
		//m_pChat->CreateChatChild(STRERR_ERROR_0025,COLOR_ERROR);// "ش  ϴ."

		// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
		if( pMsg->ErrorCode == ERR_PROTOCOL_NO_SUCH_ITEM )
 			m_pChat->CreateChatChild( STRMSG_C_091103_0324, COLOR_ERROR );	// "  ϱ  ʿ  մϴ."
		// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	}
//	else if(pMsg->ErrorCode == ERR_PROTOCOL_NOT_ENOUGH_MONEY)
//	{
//		m_pChat->CreateChatChild("ǰ մϴ.",COLOR_ERROR);
//	}
//	else if(pMsg->ErrorCode == ERR_COMMON_NO_SUCH_CHARACTER)		// 2006-05-08 by ispark, ޼ ŸԺ з, 
//	{
//		m_pChat->CreateChatChild(STRERR_ERROR_0026,COLOR_ERROR);// "ĳ͸ ã  ϴ."
//	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_QUEST_INVALID_CITYWAR_QUEST_INDEX)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0027,COLOR_ERROR);// "  Դϴ. Ÿ Ű ֽʽÿ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_NOT_GUILD_MASTER)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0028,COLOR_ERROR);// " ̼ 常   ֽϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_QUEST_ALREADY_EXIST_CITYWAR)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0029,COLOR_ERROR);// "̹ ٸ  ̼  Դϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_QUEST_CITYWAR_MGAMESERVERID_NOT_MATCHED )
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0030,COLOR_ERROR);// " ̼ ش     ֽϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_QUEST_COUPON_INVALID_NUMBER)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0031,COLOR_ERROR);// "   ִ ȣ ƴմϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_QUEST_COUPON_ALREADY_USED)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0032,COLOR_ERROR);// "̹  ȣԴϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_QUEST_COUPON_EXPIRED)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0033,COLOR_ERROR);// "ȿⰣ  ȣԴϴ."
	}
	else if(pMsg->ErrorCode == ERR_COMMON_INVALID_BUILDINGKIND)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0034,COLOR_ERROR);// "ȿ  ƴմϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_INVALID_ITEM_KIND)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0035,COLOR_ERROR);// "     Դϴ.",
		m_pChat->CreateChatChild(STRERR_ERROR_0036,COLOR_ERROR);// " ͷ  ٶϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_NO_SUCH_ITEM_INFO)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0037,COLOR_ERROR);// "   Դϴ."
		m_pChat->CreateChatChild(STRERR_ERROR_0036,COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_ITEM_KIND_NOT_MATCHED)
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0038,COLOR_ERROR);// "߸   Դϴ."
//		m_pChat->CreateChatChild(" ͷ  ٶϴ.",COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_NOTIFY_MAX_ITEM_COUNTS_OVER)
	{
		m_pChat->CreateChatChild(STRMSG_C_050913_0001, COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER)
	{
		m_pChat->CreateChatChild(STRMSG_C_050913_0002, COLOR_ERROR);
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_CANNOT_INVITE_USER) // 2005-12-02 by ispark
	{
		m_pChat->CreateChatChild(STRERR_ERROR_0136,COLOR_ERROR);// " ʴ   ϴ."
	}
	else if(pMsg->ErrorCode == ERR_PROTOCOL_DOING_PARTY_BATTLE)
	{
		g_pShuttleChild->SendDeadMsg();
	}
	else if(pMsg->ErrorCode == ERR_DOING_SERVER_SHUTDOWN)
	{
		//  ó
		char szTemp[256] = {0, };
			sprintf ( szTemp , "%s\n[%s]" , STRMSG_C_060608_0000 , "ERR_DOING_SERVER_SHUTDOWN" );

		NetworkErrorMsgBox ( szTemp );
		//NetworkErrorMsgBox(STRMSG_C_060608_0000);					// "  Ǿϴ.  ˴ϴ."
	}


	// 2009. 01. 12 by ckPark   ý
// 	else if(pMsg->ErrorCode == ERR_NO_SUCH_DECLARATION_MSWAR_INFO)
// 	{
// 		m_pChat->CreateChatChild(STRMSG_C_090113_0323, COLOR_ERROR);// "\\y  ã  ϴ.\\y"
// 		g_pD3dApp->EnterLock(TRUE);
// 	}
// 	else if(pMsg->ErrorCode == ERR_NO_MORE_DECLARATION_MSWAR_SET)
// 	{
// 		m_pChat->CreateChatChild(STRMSG_C_090113_0324, COLOR_ERROR);// "\\y ̻    ϴ.\\y"
// 		g_pD3dApp->EnterLock(TRUE);
// 	}
// 	else if(pMsg->ErrorCode == ERR_INVALID_DECLARATION_MSWAR_TIME)
// 	{
// 		m_pChat->CreateChatChild(STRMSG_C_090113_0325, COLOR_ERROR);// "\\y ð ߸ ԷµǾϴ. Է ߸Ǿų,  ðκ 12ð ̳    ϴ.\\y"
// 		g_pD3dApp->EnterLock(TRUE);
// 	}
	// end 2009. 01. 12 by ckPark   ý


	// 2009. 09. 21 by ckPark ǴƼ ʵ  ų 

	else if( pMsg->ErrorCode == ERR_DEBUFF_SKILL_APPLYING_SLIENCE )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_RELEASE_SKILL_NOT_FIND )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_DEBUFF_SKILL_APPLYING_NOT_HP_RECOVERY )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_DEBUFF_SKILL_APPLYING_NOT_DP_RECOVERY )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_DEBUFF_SKILL_APPLYING_NOT_SP_RECOVERY )
	{
		_asm nop
	}

	// end 2009. 09. 21 by ckPark ǴƼ ʵ  ų 
	
	// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
	else if( pMsg->ErrorCode == ERR_INFINITY_OVER_ENTRANCECOUNT )
	{
		
		// 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
// 		CMapCityShopList::iterator it = m_pInterface->m_pCityBase->m_mapCityShop.find( BUILDINGKIND_INFINITY );
// 		if( it != m_pInterface->m_pCityBase->m_mapCityShop.end() )
// 		{
// 			((CINFCityInfinityField*)((*it).second))->SetRoomJoinWait( FALSE );
// 			
// 			GetInfinityManager()->ClearMyRoomInfo();
// 		}
		// 2010. 12. 01 by jskim ǹ  Ǵ  ޽ 
		m_pChat->CreateChatChild(STRMSG_C_101201_0401, COLOR_ERROR);// "\\y  ȸ ʰǾϴ.\\y"
		// end 2010. 12. 01 by jskim ǹ  Ǵ  ޽  
		if( m_pInterface && m_pInterface->m_pInfinityPopup )
		{
			m_pInterface->m_pInfinityPopup->SetRoomJoinWait( FALSE );

			GetInfinityManager()->ClearMyRoomInfo();
		}
		// end 2010. 03. 03 by ckPark ǴƼ ʵ 2( UI)
	}
	else if( pMsg->ErrorCode == ERR_INFINITY_MODE )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_INFINITY_CREATEUID )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_INFINITY_NO_SUCH_MASTER_USER )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_INFINITY_NO_SUCH_MEMBER_LIST )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_INFINITY_SAME_MASTER )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_INFINITY_MASTER )
	{
		_asm nop
	}
	else if( pMsg->ErrorCode == ERR_INFINITY_CREATE_MAPCHANNEL )
	{
		_asm nop
	}

	// 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() )
	else if ( pMsg->ErrorCode == ERR_INFINITY_DIFFICLUTY_NOT_FIND )
	{	// ̵   ã.
		m_pChat->CreateChatChild ( STRERR_ERROR_0151 , COLOR_ERROR );	//"ǴƼ ̵  ã  ϴ."
	}
	else if ( pMsg->ErrorCode == ERR_INFINITY_DIFFICULTY_LEVEL_SAME )
	{	//  ̵   û. - .	
		m_pChat->CreateChatChild ( STRERR_ERROR_0153 , COLOR_ERROR );
	}
	else if ( pMsg->ErrorCode == ERR_INFINITY_DIFFICULTY_LEVEL_INVALID )
	{	// ̵   ã. -  .
		m_pChat->CreateChatChild ( STRERR_ERROR_0152 , COLOR_ERROR );	//"ǴƼ   ùٸ ʽϴ."
	}
	// End 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() )

	// 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.
	else if ( pMsg->ErrorCode == ERR_INFINITY_MISMATCH_CREATEUID )
	{
		_asm nop
	}
		// 2010. 12. 01 by jskim ǹ  Ǵ  ޽  
	else if ( pMsg->ErrorCode == ERR_INFINITY_MISMATCH_LEVEL )
	{
		//_asm nop
		if( m_pInterface && m_pInterface->m_pInfinityPopup )
		{
			m_pInterface->m_pInfinityPopup->SetRoomJoinWait( FALSE );
			GetInfinityManager()->ClearMyRoomInfo();
		}
		m_pChat->CreateChatChild ( STRMSG_C_101201_0402 , COLOR_ERROR );	//"     Ұմϴ.\\y"		 
	}
	// end 2010. 12. 01 by jskim ǹ  Ǵ  ޽  
	else if ( pMsg->ErrorCode == ERR_INFINITY_PLAYING_STATE )
	{
		_asm nop
	}
	else if ( pMsg->ErrorCode == ERR_INFINITY_ALWAYS_SKIP_ENDINGCINEMA )
	{
		_asm nop
	}
	// End 2010. 07. 27 by hsLee ǴƼ 2   ó׸  ŵ ó.

	// 2010. 03. 29 by ckPark ǴƼ Ƽ    ¿ ۹ư    
// 	else if( pMsg->ErrorCode == ERR_INFINITY_NOT_ALL_READY )
// 	{
// 		_asm nop
// 	}
	// end 2010. 03. 29 by ckPark ǴƼ Ƽ    ¿ ۹ư    
	// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý



	// 2006-05-08 by ispark, DBG ۵
	else if(pMsg->ErrorCode == ERR_COMMON_BAD_NETWORK)
	{
		DBGOUT("\n<--------------------[BAD NETWORK!!!!!]-------------------->\n");
	}
	else
	{
		// ErrorCode ˻  Դϴ.
		return FALSE;
	}
	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
/// \fn			FieldSocketErrorByMsgType(MSG_ERROR* pMsg)
/// \brief		MsgType  ˻ 켱
/// \author		jschoi
/// \date		2005-03-17 ~ 2005-03-17
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
BOOL CAtumApplication::FieldSocketErrorByMsgType(MSG_ERROR* pMsg)
{
	char szBuf[512];


	// 2010. 05. 19 by hsLee ǴƼ ʵ 2 ̵ . (ȣó +  ó() )
	switch ( pMsg->MsgType )
	{

		case T_FC_CHARACTER_CREATE :

			switch (pMsg->ErrorCode )
			{
				case ERR_COMMON_CHARACTER_ALREADY_EXISTS :
					
					if(g_pSelect/* && !g_pSelect->m_pInfWindow->IsExistMsgBox(_MESSAGE_ERROR_CREATE)*/)
					{
						//  ̸  ε 3
						g_pSelect->m_pCreateMenu->m_nFocus = 3;
						//g_pSelect->m_pInfWindow->AddMsgBox(STRERR_ERROR_0039, _MESSAGE_ERROR_CREATE);// "̹ ϴ ̸Դϴ."
					}
					break;

				case ERR_PROTOCOL_INVALID_AUTOSTAT_TYPE :
				
					if(g_pSelect && !g_pSelect->m_pInfWindow->IsExistMsgBox(_MESSAGE_ERROR_CREATE))
					{
						g_pSelect->m_pInfWindow->AddMsgBox(STRERR_ERROR_0040, _MESSAGE_ERROR_CREATE);// "Ÿ Դϴ. Ÿ  ٶϴ."
					}
					break;
				
				default :

					g_pSelect->m_pInfWindow->AddMsgBox(STRERR_ERROR_0041, _MESSAGE_ERROR_CREATE);// "ĳ  Ͽϴ."
					break;
			}
			break;
			
		case T_FC_CHARACTER_DELETE :

			g_pSelect->ShowSecutiryWnd(FALSE);

			// 2007-09-12 by bhsohn 2 ȣ ý 		
			switch ( pMsg->ErrorCode ) 
			{
				case ERR_SECPASS_PASSWORD_NOT_MATCHED :
					
					g_pSelect->m_pInfWindow->AddMsgBox( STRMSG_C_070917_0203, _MESSAGE );
					break;

				case ERR_WARING_OUTPOST_TO_OWNMAP :
			
					g_pSelect->m_pInfWindow->AddMsgBox(STRMSG_C_071112_0101,_MESSAGE);		//"     ĳ͸    ϴ."	
					break;

				// 2008-10-20 by bhsohn VOIP  üؾ߸ ĳ͸   ְ 
				case ERR_DELETE_CHARACTER_GUILDCOMMANDER :
	
					g_pSelect->m_pInfWindow->AddMsgBox(STRMSG_C_081021_0200, _MESSAGE); //" üؾ߸ ĳ͸   ֽϴ."
					break;
				// end 2008-10-20 by bhsohn VOIP  üؾ߸ ĳ͸   ְ 
			}
			break;
// 2005-11-22 by ispark
//  Լ ó ϹǷ 
//	else if(pMsg->MsgType == T_FC_ITEM_USE_ENCHANT)
//	{
//		CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_LABORATORY);
//		if(pCityLab)
//		{
//			pCityLab->InitData();
//		}
//		m_pChat->CreateChatChild(STRERR_C_ENCHANT_0001,COLOR_ERROR);
//	}
		case T_FC_ITEM_MIX_ITEMS :
			{
				CINFCityLab * pCityLab = (CINFCityLab*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_FACTORY);

				if(pCityLab)
					pCityLab->InitData();
				
				switch ( pMsg->ErrorCode ) 
				{
					case ERR_PROTOCOL_NO_SUCH_MIXING_INFO :

						m_pChat->CreateChatChild(STRERR_C_MIX_0001,COLOR_ERROR);// "      Դϴ."
						break;

					case ERR_PROTOCOL_NOT_ENOUGH_MONEY :

						m_pChat->CreateChatChild(STRERR_ERROR_0105,COLOR_ERROR);// "ǰ Ͽ    ϴ."
						break;

					// 2007-09-12 by bhsohn 2 ȣ ý 
					case ERR_SECPASS_LOCKED :
						{
							char ErrorMsgMissionList[256];
							wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
							m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
						}
						break;
					// end 2007-09-12 by bhsohn 2 ȣ ý 

					case ERR_PROTOCOL_ALREADY_USE_ITEM :
				
						m_pChat->CreateChatChild(STRMSG_C_071212_0100,COLOR_ERROR);// "ش     ִ ° ƴմϴ."
						break;

					// 2008-03-14 by bhsohn ս 
					case ERR_PROTOCOL_REQ_MIX_ITEM_NOT_MATCHED :
						//ѹ  1    ִ Դϴ.
						m_pChat->CreateChatChild(STRMSG_C_080318_0200,COLOR_ERROR);// "  ʾ    ϴ."
						break;

					case ERR_PROTOCOL_INVALID_ITEM_COUNT :
						// 
						m_pChat->CreateChatChild(STRMSG_C_080318_0200,COLOR_ERROR);// "  ʾ    ϴ."
						break;
				}
					// end 2008-03-14 by bhsohn ս 
			//		else
			//		{
			//			m_pChat->CreateChatChild(STRERR_ERROR_0106,COLOR_ERROR);// "   ϴ."
			//		}
			}
			break;

		case T_FC_SKILL_USE_SKILL :
			{
				switch ( pMsg->ErrorCode )
				{
					case ERR_PROTOCOL_CANNOT_USE_SKILL :
				
						m_pChat->CreateChatChild(STRMSG_C_060720_0000, COLOR_ERROR);	// "ų   Ǿϴ."
						break;
				
					case ERR_INVISIBLE_STATE :

						m_pChat->CreateChatChild(STRERR_C_SKILL_0002, COLOR_ERROR);		// "ų    Դϴ."
						break;

					case ERR_PROTOCOL_QUEST_IS_IN_PROGRESS :
				
						m_pChat->CreateChatChild(STRMSG_C_060807_0000, COLOR_ERROR);	// "̼Դϴ. ̵ ش罺ų   ϴ."
						break;

					case ERR_NO_MEMBERSHIP_USER :
				
						m_pChat->CreateChatChild(STRMSG_C_060920_0103, COLOR_ERROR);	// "  ƴմϴ."
						break;

					case ERR_ARENA_STATE :
						
						m_pChat->CreateChatChild(STRMSG_C_070509_0100,COLOR_ERROR);
						break;

					case ERR_USING_SHOP :
				
						m_pChat->CreateChatChild(STRMSG_C_060512_0001,COLOR_ERROR);// "  ̿ Դϴ."	
						break;

					// 2007-09-12 by bhsohn 2 ȣ ý 
					case ERR_SECPASS_LOCKED :
						{
							char ErrorMsgMissionList[256];
							wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
							m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
						}
						break;
					// end 2007-09-12 by bhsohn 2 ȣ ý 

					// 2010. 11. 24. by hsLee. ڰ Ÿ   Ÿ Ÿ    üũ.
					case ERR_PROTOCOL_NOT_WARP_BURNING_MAP :
						
						m_pChat->CreateChatChild ( STRERR_C_VOIP_0002 , COLOR_ERROR );
						break;
					// End. 2010. 11. 24. by hsLee. ڰ Ÿ   Ÿ Ÿ    üũ.
				}

				DBGOUT("ERROR : USE SKILL --> You Need Check Code \n");
			}
			break;

		case T_FC_CHARACTER_USE_BONUSSTAT :	// ʽ Ʈ ų Stat  ȿ ʴ.

			switch ( pMsg->ErrorCode )
			{	
				case ERR_PROTOCOL_LIMIT_STAT_POINT :
			
					m_pChat->CreateChatChild(STRERR_ERROR_0042,COLOR_ERROR);// "ش   ̻ ø  ϴ."
					break;

				case ERR_PROTOCOL_INVALID_STAT_VALUE_OR_KIND :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0043,COLOR_ERROR);// "ʽ  ų   ȿ ʽϴ."
					break;

				default :

					m_pChat->CreateChatChild(STRERR_ERROR_0044,COLOR_ERROR);// "ʽ   Դϴ."
					break;
			}
			break;
	
		case T_FC_SHOP_BUY_CASH_ITEM :
	
			switch ( pMsg->ErrorCode )
			{
				case ERR_CASH_mgQueryMall_ERROR :
				case ERR_CASH_mgQueryMall_RESULT_CANNOT_PAYMENT :
				case ERR_CASH_mgQueryMall_RESULT_NO_ACCOUNT :

					m_pChat->CreateChatChild(STRERR_ERROR_0045,COLOR_ERROR);// "ȭ   Դϴ. ͷ Ͻñ ٶϴ."
					break;

				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :

					m_pChat->CreateChatChild(STRERR_ERROR_0047,COLOR_ERROR);// "ĳ մϴ."
					break;

				case ERR_CASH_PREMIUM_CARD_ALREADY_USING :
				
					m_pChat->CreateChatChild(STRMSG_C_050603_0001,COLOR_ERROR); // "̹   ī尡  Դϴ"
					break;

				case ERR_CASH_PREMIUM_CARD_NOT_MATCHED :

					m_pChat->CreateChatChild(STRMSG_C_050603_0002,COLOR_ERROR); //"  ׷̵ ī带    ϴ."
					break;
		
				case ERR_CASH_PREMIUM_CARD_NOT_YET_BUY_STATE :

					m_pChat->CreateChatChild(STRMSG_C_050603_0003,COLOR_ERROR); //"̻   ī带    ϴ."
					break;

				/*case ERR_CASH_PREMIUM_CARD_NOT_MATCHED :

					m_pChat->CreateChatChild(STRMSG_C_050603_0004,COLOR_ERROR); //"  ׷̵ ī带    ϴ."
					break;*/

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 
				// 2008-08-18 by bhsohn 1   ̵ ý 
				case ERR_INTERVAL_SYSTEM_SECOND :
					break;
				// end 2008-08-18 by bhsohn 1   ̵ ý
		
				// 2009. 08. 21 by ckPark ĳ ϱ⿡  üũ
				case ERR_CASH_INVALID_GIVE_TARGET_ACCOUNT :
					{
						char ErrorMsg[256];
						g_pGameMain->GetCashGiftSendCharacterName( ErrorMsg );
						wsprintf( ErrorMsg, STRMSG_C_090821_0301, ErrorMsg );
						m_pChat->CreateChatChild( ErrorMsg, COLOR_ERROR ); //"%s ȸ  ·,    ϴ."
					}
					break;
				// end 2009. 08. 21 by ckPark ĳ ϱ⿡  üũ

				// 2009. 09. 24 by jskim ʵ â ĳ 
				case ERR_CANNOT_BUY_ITEM :

					m_pChat->CreateChatChild(STRERR_ERROR_0110,COLOR_ERROR);		// "    ϴ."
					break;
				//end 2009. 09. 24 by jskim ʵ â ĳ 

				// 2010. 01. 27 by ckPark ĳ   Ǹ ý
				case ERR_SOLD_OUT_SHOP_ITEM :

					m_pChat->CreateChatChild( STRMSG_C_100127_0302, COLOR_ERROR );		// "ش  Ǹ   Ǿ    ϴ."
					break;
				// end 2010. 01. 27 by ckPark ĳ   Ǹ ý
				// 2010-08-31 by shcho&&jskim,  ý 
				case ERR_NOT_DISSOLVED_ITEM:
					{
						m_pChat->CreateChatChild( STRMSG_C_100901_0406, COLOR_ERROR );		// "\\y  ƴմϴ.\\y"
						break;
					}
				case ERR_NOT_INSERT_DISSOLVED_ITEMS:
					{
						m_pChat->CreateChatChild( STRMSG_C_100901_0407, COLOR_ERROR );		// "\\y Կ Ͽϴ.\\y"
						break;
					}
				// end 2010-08-31 by shcho&&jskim,  ý 
			}
			break;

		case T_FC_CHARACTER_GET_CASH_MONEY_COUNT :

			switch ( pMsg->ErrorCode )
			{
				case ERR_CASH_CASH_SHOP_NO_SERVICE :
					
					g_pInterface->m_pCityBase->OnCityNPCButtonDown(CITY_NPC_BUTTON_CLOSE);
					g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_070110_0100, _MESSAGE);	// "ۘ µ ʾҽϴ."
					break;

				default :

					m_pChat->CreateChatChild(STRERR_ERROR_0046,COLOR_ERROR);// "ĳ  Դϴ. ͷ Ͻñ ٶϴ."
					break;
			}
			break;

		case T_FC_ITEM_USE_ENERGY :

			switch ( pMsg->ErrorCode )
			{
				case ERR_PROTOCOL_INVALID_ITEM_COUNT : 

					m_pChat->CreateChatChild(STRERR_ERROR_0037,COLOR_ERROR);// "   Դϴ."
					m_pChat->CreateChatChild(STRERR_ERROR_0036,COLOR_ERROR);// " ͷ  ٶϴ."
					break;

				case ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED :
	
					m_pChat->CreateChatChild(STRERR_ERROR_0048,COLOR_ERROR);// "    ּ   ۴."
					break;

				case ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0049,COLOR_ERROR);// "    ִ   ũ."
					break;

				case ERR_PROTOCOL_REQ_NOT_CITY_MAP_CHANNEL :

					m_pChat->CreateChatChild(STRERR_ERROR_0050,COLOR_ERROR);// "ݳ  ʱȭ մϴ."
					m_pChat->CreateChatChild(STRERR_ERROR_0051,COLOR_ERROR);// " ʱȭ Ͽϴ."
					break;
				
				case ERR_PROTOCOL_REQ_MUST_RELEASE_ALL_ITEM :

					m_pChat->CreateChatChild(STRERR_ERROR_0052,COLOR_ERROR);// " ʱȭ     ϼ."
					m_pChat->CreateChatChild(STRERR_ERROR_0051,COLOR_ERROR);// " ʱȭ Ͽϴ."
					break;

				case ERR_PROTOCOL_STAT_ERROR_STATE :

					m_pChat->CreateChatChild(STRERR_ERROR_0053,COLOR_ERROR);// "ʱȭϷ   Դϴ. "
					m_pChat->CreateChatChild(STRERR_ERROR_0036,COLOR_ERROR);// " ͷ  ٶϴ."
					break;

				case ERR_PROTOCOL_STAT_INITIALIZE_STATE :
		
					m_pChat->CreateChatChild(STRERR_ERROR_0054,COLOR_ERROR);// "ʱȭϷ  ̹ ʱȭ Դϴ."
					break;

				case ERR_PROTOCOL_NO_SUCH_DES_PARAM :

					m_pChat->CreateChatChild(STRERR_ERROR_0035,COLOR_ERROR);// "     Դϴ."
					m_pChat->CreateChatChild(STRERR_ERROR_0036,COLOR_ERROR);// " ͷ  ٶϴ."
					break;
					
				case ERR_PROTOCOL_AREADY_USING_HP_UP_ITEM :

					m_pChat->CreateChatChild(STRERR_ERROR_0055,COLOR_ERROR);// "̹ ŰƮ Դϴ."
					break;
				
				case ERR_PROTOCOL_AREADY_USING_DP_UP_ITEM :

					m_pChat->CreateChatChild(STRERR_ERROR_0056,COLOR_ERROR);// "̹ ŰƮ Դϴ."
					break;

				case ERR_PROTOCOL_AREADY_USING_SP_UP_ITEM :

					m_pChat->CreateChatChild(STRERR_ERROR_0057,COLOR_ERROR);// "̹ SP UP  ."
					break;
						
				case ERR_PROTOCOL_AREADY_USING_EP_UP_ITEM :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0058,COLOR_ERROR);// "̹ Ḧ Դϴ."
					break;

				case ERR_PROTOCOL_AREADY_FULL_HP :

					//			m_pChat->CreateChatChild("̹ HP  .",COLOR_ERROR);
					break;

				case ERR_PROTOCOL_AREADY_FULL_DP :
					//			m_pChat->CreateChatChild("̹ DP  .",COLOR_ERROR);
					break;

				case ERR_PROTOCOL_AREADY_FULL_SP :

					//			m_pChat->CreateChatChild("̹ SP  .",COLOR_ERROR);
					break;

				case ERR_PROTOCOL_AREADY_FULL_EP :

					//			m_pChat->CreateChatChild("̹ EP  .",COLOR_ERROR);
					break;

				case ERR_USING_BAZAAR :

					m_pChat->CreateChatChild(STRMSG_C_060802_0001,COLOR_ERROR);// "λ     ϴ."
					break;

				case ERR_PROTOCOL_CANNOT_USE_ITEM_IN_ARENA :

					m_pChat->CreateChatChild(STRMSG_C_070604_0100,COLOR_ERROR);// "Ʒ ʿ     Դϴ."
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				case ERR_CANNOT_SEARCH_OUTPOST :
				
					m_pChat->CreateChatChild(STRMSG_C_070816_0117,COLOR_ERROR);	//  ̰ų,  ܿ   ֽϴ.
					break;

				// 2010. 01. 18 by ckPark 縳    Ķ ó
				case ERR_ALREADY_USE_ITEMPARAM :

					m_pChat->CreateChatChild( STRMSG_C_100118_0301, COLOR_ERROR );
					break;
				// end 2010. 01. 18 by ckPark 縳    Ķ ó

				default : 
					
					m_pChat->CreateChatChild(STRERR_ERROR_0059,COLOR_ERROR);// "    Դϴ."
					break;
			}
			break;
		
		case T_FC_ITEM_USE_ITEM :
	
			switch ( pMsg->ErrorCode )
			{
				case ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0048,COLOR_ERROR);// "    ּ   ۴."
					break;
				
				case ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0049,COLOR_ERROR);// "    ִ   ũ."
					break;

				case ERR_PROTOCOL_ALREADY_USE_ITEM :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0060,COLOR_ERROR);// "Ϸ  ̹  Դϴ."
					break;

				case ERR_PROTOCOL_ALREADY_USE_OTHER_ITEM :

					m_pChat->CreateChatChild(STRERR_ERROR_0061,COLOR_ERROR);// "Ϸ ۰    ̹  Դϴ."
					break;

				case ERR_PROTOCOL_NO_SUCH_DES_PARAM :

					m_pChat->CreateChatChild(STRERR_ERROR_0035,COLOR_ERROR);// "     Դϴ."
					m_pChat->CreateChatChild(STRERR_ERROR_0036,COLOR_ERROR);// " ͷ  ٶϴ."
					break;

				// 2007-08-24 by bhsohn Ŀ   ϰ ϴ ɾ ߰
				case ERR_CANNOT_USE_SPEAKER_ITEM :
				
					m_pChat->CreateChatChild(STRMSG_C_070824_0201,COLOR_ERROR); //"[Ŀ]     Դϴ."
					break;
				// end 2007-08-24 by bhsohn Ŀ   ϰ ϴ ɾ ߰

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				// 2009. 09. 24 by jskim ʵ â ĳ 
				case ERR_INVALID_CHARACTER :

					m_pChat->CreateChatChild(STRMSG_C_090925_0404,COLOR_ERROR); //"ʵ â  ĳͰ  ʽϴ."
					break;
					
				/*case ERR_PROTOCOL_ALREADY_USE_ITEM :
	
					m_pChat->CreateChatChild(STRERR_ERROR_0060,COLOR_ERROR); //"Ϸ  ̹  Դϴ."
					break;*/

				case ERR_ALREADY_USING_BUILDING :
					
					m_pChat->CreateChatChild(STRMSG_C_090925_0405,COLOR_ERROR); //"Ϸ  ̹ ̿ Դϴ."
					break;
		
				case ERR_PROTOCOL_CANNOT_USE_ITEM :
					
					m_pChat->CreateChatChild(STRMSG_C_090925_0406,COLOR_ERROR); //"ʵ â     Դϴ."
					break;
				//end 2009. 09. 24 by jskim ʵ â ĳ 

				// 2010. 01. 18 by ckPark 縳    Ķ ó
				case ERR_ALREADY_USE_ITEMPARAM :
	
					m_pChat->CreateChatChild( STRMSG_C_100118_0301, COLOR_ERROR );
					break;
				// end 2010. 01. 18 by ckPark 縳    Ķ ó

				// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
				case ERR_INFINITY_ONLY_USE_ITEM :

					m_pChat->CreateChatChild( STRMSG_C_091103_0340, COLOR_ERROR );
					break;
				// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý
				// 2010. 06. 18 by jskim ǴƼ    Ʈ 
				case ERR_INFINITY_CANNOT_USE_ITEM :
					m_pChat->CreateChatChild( STRMSG_C_100618_0406, COLOR_ERROR ); //"ش  ǴƼ ʵ峻  Ұ մϴ."
					break;
				//end 2010. 06. 18 by jskim ǴƼ    Ʈ 

				default :
					m_pChat->CreateChatChild(STRERR_ERROR_0062,COLOR_ERROR);// "   Դϴ."
					break;
			}
			break;

		case T_FC_REQUEST_REQUEST :

			if( pMsg->ErrParam1 == REQUEST_TYPE_PARTY_BATTLE )
			{
				g_pGameMain->m_pCommunity->GetParty()->SetEnablePartyMenu( TRUE );
				break;
			}
			
			switch ( pMsg->ErrorCode )
			{
				case ERR_COMMON_NO_SUCH_CHARACTER :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0063,COLOR_ERROR);// "  ã  ϴ."
					break;

				case ERR_COMMON_NOT_ALLOWED_TO_MYSELF :

					m_pChat->CreateChatChild(STRERR_ERROR_0064,COLOR_ERROR);// "ڱ ڽſԴ û   ϴ."
					break;
					
				case ERR_PROTOCOL_TOO_FAR_TO_DO :

					m_pChat->CreateChatChild(STRERR_ERROR_0065,COLOR_ERROR);// " Ÿ ־ û   ϴ."
					break;

				case ERR_PROTOCOL_NO_SUCH_PARTY :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0066,COLOR_ERROR);// "ڽ Ȥ  Ƽ   ʱ  û   ϴ."
					break;

				case ERR_PROTOCOL_PARTY_PERMISSION_DENIED :

					m_pChat->CreateChatChild(STRERR_ERROR_0067,COLOR_ERROR);// "ڽ Ȥ  Ƽ ƴϱ  û   ϴ."
					break;

				case ERR_PROTOCOL_ALREADY_REQUESTING_PARTY_BATTLE :

					m_pChat->CreateChatChild(STRERR_ERROR_0068,COLOR_ERROR);// "ڽ Ȥ  ̹ Ƽ ûԴϴ."
					break;

				case ERR_PROTOCOL_ALREADY_PARTY_BATTLE :

					m_pChat->CreateChatChild(STRERR_ERROR_0068,COLOR_ERROR);// "ڽ Ȥ  ̹ Ƽ ûԴϴ."
					break;
					
				case ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0069,COLOR_ERROR);// "  ʾ    ϴ."
					break;
				
				case ERR_PROTOCOL_MAP_CHANNEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0070,COLOR_ERROR);// "   ʿ  ʽϴ."
					break;
				
				case ERR_PROTOCOL_NO_SUCH_REQUEST_TYPE :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0071,COLOR_ERROR);// "ȿ  ûԴϴ."
					break;

				// 2009-02-05 by bhsohn   ȯ Ҵ  ذ
				case ERR_WARING_OUTPOST_TO_OWNMAP :

					m_pChat->CreateChatChild(STRMSG_C_090205_0201, COLOR_ERROR);// "ȿ  ûԴϴ."
					break;
				// end 2009-02-05 by bhsohn   ȯ Ҵ  ذ

				default :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0072,COLOR_ERROR);// " û ߽ϴ."
					break;
			}
			break;

		case T_FC_QUEST_DISCARD_QUEST :

			switch ( pMsg->ErrorCode )
			{
				
				case ERR_PROTOCOL_QUEST_CANNOT_CITYWAR_QUEST :
								
					m_pChat->CreateChatChild ( STRERR_ERROR_0073 , COLOR_ERROR );	// "      ϴ."
					break;

				case ERR_PROTOCOL_QUEST_IMPOSSIBLE_GIVEUP :

					g_pGameMain->AddMsgBox( STRMSG_C_060720_0001 , _MESSAGE );		// "ش ̼    ϴ."
					break;

				default :
					break;
			}
			break;

		case T_FC_QUEST_REQUEST_START :

			switch ( pMsg->ErrorCode )
			{	
				case ERR_PROTOCOL_QUEST_CANNOT_CITYWAR_QUEST :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0074,COLOR_ERROR);// "      ϴ."
					break;

				case ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0075,COLOR_ERROR);// "  ʾ Ʈ    ϴ."
					break;

				case ERR_PROTOCOL_REQ_ATTACK_PART_NOT_MATCHED :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0076,COLOR_ERROR);// "Ʈ  Ͽ Ʈ    ϴ."
					break;

				case ERR_PROTOCOL_REQ_DEFENSE_PART_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0077,COLOR_ERROR);// "Ʈ  Ͽ Ʈ    ϴ."
					break;

				case ERR_PROTOCOL_REQ_FUEL_PART_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0078,COLOR_ERROR);// "Ʈ  Ͽ Ʈ    ϴ."
					break;

				case ERR_PROTOCOL_REQ_SOUL_PART_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0079,COLOR_ERROR);// "Ʈ  Ͽ Ʈ    ϴ."
					break;

				case ERR_PROTOCOL_REQ_SHIELD_PART_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0080,COLOR_ERROR);// "Ʈ  Ͽ Ʈ    ϴ."
					break;

				case ERR_PROTOCOL_REQ_DODGE_PART_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0081,COLOR_ERROR);// "ȸƮ  Ͽ Ʈ    ϴ."
					break;

		//		else if(pMsg->ErrorCode == )// 2006-03-24 by ispark
				// 2006-03-28 by ispark,  ̼

				case ERR_PROTOCOL_MAP_CHANNEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0070,COLOR_ERROR);// "   ʿ  ʽϴ."
					break;
				
				case ERR_PROTOCOL_NO_SUCH_PARTY :

					m_pChat->CreateChatChild(STRMSG_C_060328_0001, COLOR_ERROR); // "¿   ִ ̼Դϴ."
					break;

				case ERR_PROTOCOL_REQ_PARTYMEMBERS_NOT_MATCHED :

					m_pChat->CreateChatChild(STRMSG_C_060328_0002, COLOR_ERROR); // "  մϴ."
					break;
					
				case ERR_PROTOCOL_REQ_PARTYMEMBERS_LEVEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRMSG_C_060328_0003, COLOR_ERROR); // " ְ  10̻ ̰ ϴ."
					break;

				case ERR_PROTOCOL_REQ_PARTYMEMBERS_SOMEONE_CANNOT_WARP :

					m_pChat->CreateChatChild(STRMSG_C_060328_0004, COLOR_ERROR); // "     ֽϴ."
					break;

				case ERR_ARENA_STATE :

					break;
			
				// 2010. 02. 02 by ckPark ŷ ̼ǽ   ó
				case ERR_PROTOCOL_CANNOT_WARP :
					{
						_asm nop
					}
					break;
				// end 2010. 02. 02 by ckPark ŷ ̼ǽ   ó

				default :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0082,COLOR_ERROR);// "Ʈ    ϴ."
					break;
			}
			break;

		case T_FC_BATTLE_REQUEST_P2P_PK :

			switch ( pMsg->ErrorCode )
			{
				
				case ERR_PROTOCOL_REQ_LEVEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0083,COLOR_ERROR);// "  ʾ    ϴ."
					break;
				
				case ERR_USING_BAZAAR :					// 2006-08-01 by ispark
	
					m_pChat->CreateChatChild(STRMSG_C_060512_0001,COLOR_ERROR);// "  ̿ Դϴ."
					break;
	
				case ERR_PROTOCOL_CANNOT_IN_CITY_MAP_CHANNEL :
					
					m_pChat->CreateChatChild(STRMSG_C_061010_0001, COLOR_ERROR); // 2006-10-10 by ispark, "ÿ PVP   ϴ."
					break;
		
				case ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED :

					m_pChat->CreateChatChild(STRMSG_C_050825_0011,COLOR_ERROR);	// " ʽϴ."
					break;

				case ERR_ARENA_STATE :

					m_pChat->CreateChatChild(STRMSG_C_070514_0100,COLOR_ERROR); //"Ʒ  ̹Ƿ û  ϴ."
					break;
			}
			break;

		case T_FC_BATTLE_ACCEPT_REQUEST_P2P_PK :			// 2006-08-01 by ispark

			switch ( pMsg->ErrorCode )
			{
				case ERR_USING_BAZAAR :
				
					m_pChat->CreateChatChild(STRMSG_C_060512_0001,COLOR_ERROR);// "  ̿ Դϴ."
					break;

				default :
					break;
			}
			break;

		case T_FC_ITEM_CHANGE_WINDOW_POSITION :

			switch ( pMsg->ErrorCode )
			{
				case ERR_PROTOCOL_INVALID_ITEM_WINDOW_POSITION :

					m_pChat->CreateChatChild(STRERR_ERROR_0084,COLOR_ERROR);// " ̵ ߸Ǿϴ."
					break;

				case ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0085,COLOR_ERROR);// " Ƽ     ϴ."
					break;

				case ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0086,COLOR_ERROR);// " Ƽ     ϴ."
					break;

				case ERR_PROTOCOL_REQ_UNITKIND_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0087,COLOR_ERROR);// "ش     ִ  ƴմϴ."
					break;

				case ERR_PROTOCOL_REQ_RACE_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0088,COLOR_ERROR);// "ش     ִ  ƴմϴ."
					break;

				case ERR_PROTOCOL_REQ_ATTACK_PART_NOT_MATCHED :
					m_pChat->CreateChatChild(STRERR_ERROR_0089,COLOR_ERROR);// "Ʈ  Ͽ     ϴ."
					break;

				case ERR_PROTOCOL_REQ_DEFENSE_PART_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0090,COLOR_ERROR);// "Ʈ  Ͽ     ϴ."
					break;

				case ERR_PROTOCOL_REQ_FUEL_PART_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0091,COLOR_ERROR);// "Ʈ  Ͽ     ϴ."
					break;

				case ERR_PROTOCOL_REQ_SOUL_PART_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0092,COLOR_ERROR);// "Ʈ  Ͽ     ϴ."
					break;

				case ERR_PROTOCOL_REQ_SHIELD_PART_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0093,COLOR_ERROR);// "Ʈ  Ͽ     ϴ."
					break;

				case ERR_PROTOCOL_REQ_DODGE_PART_NOT_MATCHED :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0094,COLOR_ERROR);// "ȸƮ  Ͽ     ϴ."
					break;

				case ERR_CANNOT_ATTACHED_USING_PREMIUM_CARD :
				
					m_pChat->CreateChatChild(STRMSG_C_060331_0003,COLOR_ERROR);// "  ߿     Դϴ."
					break;

				case ERR_EXPIRED_ITEM :
				
					m_pChat->CreateChatChild(STRMSG_C_060331_0004,COLOR_ERROR);//  ð  Ǿϴ.   ˴ϴ."
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				// 2008-08-18 by bhsohn 1   ̵ ý 
				case ERR_INTERVAL_SYSTEM_SECOND :
					{
						// 2012-12-18 by bhsohn   Ż/, Lockɸ  
						g_pD3dApp->EnterLock(TRUE);		// FALSE :Lock  TRUE : UnLock		
						// END 2012-12-18 by bhsohn   Ż/, Lockɸ  
					}
					break;
				// end 2008-08-18 by bhsohn 1   ̵ ý 

				// 2010. 01. 18 by ckPark 縳    Ķ ó
				case ERR_ALREADY_USE_ITEMPARAM :

					m_pChat->CreateChatChild( STRMSG_C_100118_0301, COLOR_ERROR );
					break;
				// end 2010. 01. 18 by ckPark 縳    Ķ ó

				default :

					m_pChat->CreateChatChild(STRERR_ERROR_0095,COLOR_ERROR);// "    ϴ."
					break;
			}
			break;

		case T_FC_SHOP_BUY_ITEM :

			switch ( pMsg->ErrorCode )
			{	
				case ERR_PROTOCOL_REQ_RACE_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0096,COLOR_ERROR);// "ų    ִ  ƴմϴ."
					break;

				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :

					m_pChat->CreateChatChild(STRERR_ERROR_0109,COLOR_ERROR);// "ǰ Ͽ     ϴ."
					break;
					
				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				// 2008-08-18 by bhsohn 1   ̵ ý 
				case ERR_INTERVAL_SYSTEM_SECOND :
					break;
				// end 2008-08-18 by bhsohn 1   ̵ ý 

				// 2009. 09. 24 by jskim ʵ â ĳ 
				case ERR_CANNOT_BUY_ITEM :
				
					m_pChat->CreateChatChild(STRERR_ERROR_0110, COLOR_ERROR);// "    ϴ."
					break;
				//end 2009. 09. 24 by jskim ʵ â ĳ 
				// 2011-10-24 by jhahn Ʈ ý 		
				case ERR_INSUFFICIENT_NUMBER_SHOP_ITEM:					
					m_pChat->CreateChatChild( STRMSG_C_111114_0001, COLOR_ERROR );
					break;
					
					
				case ERR_NOT_OWNER_SHOP:				
					m_pChat->CreateChatChild( STRMSG_C_111114_0002, COLOR_ERROR );
					break;
                //end 2011-10-24 by jhahn Ʈ ý 	

				default :

					m_pChat->CreateChatChild(STRERR_ERROR_0110,COLOR_ERROR);// "    ϴ."
					break;
			}
			break;
		
		case T_FC_ITEM_USE_ENCHANT :


			switch ( pMsg->ErrorCode ) 
			{
				case ERR_PROTOCOL_REQ_UNITKIND_NOT_MATCHED :

					m_pChat->CreateChatChild(STRERR_ERROR_0097,COLOR_ERROR);// " ʾ æƮ/   ϴ."
					break;
			
				case ERR_PROTOCOL_ALREADY_MAX_ENCHANT_PER_ITEM :
		
					m_pChat->CreateChatChild(STRERR_ERROR_0098,COLOR_ERROR);// " ̻ æƮ/   ϴ."
					break;

				case ERR_PROTOCOL_ALREADY_HAVE_RARE_FIX :

					m_pChat->CreateChatChild(STRERR_ERROR_0099,COLOR_ERROR);// "æƮ/   ϴ."
					break;
				
				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :
		
					m_pChat->CreateChatChild(STRERR_ERROR_0100,COLOR_ERROR);// "ǰ Ͽ æƮ/   ϴ."
					break;
				
				case ERR_PROTOCOL_ALREADY_INITIALIZE_RARE_FIX :
		
					m_pChat->CreateChatChild(STRERR_ERROR_0101,COLOR_ERROR);// "شϴ ۿ  ɼ ϴ."
					break;
					
				case ERR_PROTOCOL_CANNOT_USE_ITEMKIND_PREVENTION_DELETE_ITEM :
		
					m_pChat->CreateChatChild(STRMSG_C_050927_0002, COLOR_ERROR);// "æƮ ı  ī带   ϴ."
					break;
					
				// 2009. 01. 21 by ckPark æƮ Ȯ  ī
				case ERR_PROTOCOL_CANNOT_USE_ITEMKIND_PREVENTION_DELETE_ITEM_BY_STARTCOUNT :
					{
						// ı  
						// 5æ ̸ Ȯ   æ  Ȯī Ҹ  
						char szTemp[MAX_PATH];
						sprintf(szTemp, STRMSG_C_090121_0301, pMsg->ErrParam1);
						m_pChat->CreateChatChild(szTemp, COLOR_ERROR);//"\\y%dæƮ ̸ ش    ϴ.\\y"
					}
					break;
				// end 2009. 01. 21 by ckPark æƮ Ȯ  ī

				case ERR_PROTOCOL_CANNOT_ENCHANT_ITEM : // 2005-11-22 by ispark

					m_pChat->CreateChatChild(STRMSG_C_051122_0005, COLOR_ERROR);//"þƮ    Դϴ."
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 
		
				// 2011-10-20 by jhahn	æƮ  
				case ERR_PROTOCOL_CANNOT_ENCHANT_MORE_THEN_10:
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_111020_0001);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); 
					}
					break;
				case ERR_PROTOCOL_CANNOT_ENCHANT_DIFFERENCE_ATTRIBUTE:
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_111020_0002);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); 
					}
					break;
				//end 2011-10-20 by jhahn	æƮ  
					
		
				default :
		
					m_pChat->CreateChatChild(STRERR_ERROR_0102,COLOR_ERROR);// "æƮ/   ϴ."
					break;
			}
			break;
			
		case T_FC_STORE_MOVE_ITEM :

			switch ( pMsg->ErrorCode )
			{
				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :
		
					m_pChat->CreateChatChild(STRERR_ERROR_0103,COLOR_ERROR);// "ǰ Ͽ â ̿   ϴ."
					break;

		
				case ERR_NO_SEARCH_CHARACTER :
					// 2006-09-19 by dgwoo
					m_pChat->CreateChatChild(STRMSG_C_060920_0102,COLOR_ERROR);
					break;

				case ERR_PROTOCOL_ITEM_AMOUNT_EXCEED :
					{
						CINFCityStore* pStore = (CINFCityStore*)m_pInterface->m_pCityBase->FindBuildingShop(BUILDINGKIND_STORE);
						//pStore->GetGuildItem();
						pStore->SetStoreItemSPI();
						m_pChat->CreateChatChild(STRERR_ERROR_0025,COLOR_ERROR);// "ش  ϴ."
					}
					break;

				case ERR_NOT_RANK_DRAW_GUILD_STORE :

					m_pChat->CreateChatChild(STRMSG_C_061011_0101,COLOR_ERROR);// " ̻ ãⰡ մϴ."
					break;

				case ERR_PROTOCOL_GUILD_STORE_FULL_ITEM :

					m_pChat->CreateChatChild(STRMSG_C_061018_0100,COLOR_ERROR);// "   ʰ Ǿϴ."
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 


				// 2008-08-18 by bhsohn 1   ̵ ý 
				case ERR_INTERVAL_SYSTEM_SECOND :
			
					break;
				// end 2008-08-18 by bhsohn 1   ̵ ý 

				// 2009. 09. 24 by jskim ʵ â ĳ 
				case ERR_CANNOT_USE_GUILD_STORE :
				
					m_pChat->CreateChatChild(STRMSG_C_090925_0401,COLOR_ERROR);	//"ʵ忡  â ̿   ϴ."
					break;

				case ERR_CANNOT_USE_FIELD_STORE :

					m_pChat->CreateChatChild(STRMSG_C_090925_0402,COLOR_ERROR); //"ʵ â ̿   ϴ."
					break;
				//end 2009. 09. 24 by jskim ʵ â ĳ 

				default :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0104,COLOR_ERROR);// "â ̿   ϴ."
					break;
			}
			break;
			
		case T_FC_EVENT_REQUEST_SHOP_WARP :


			switch ( pMsg->ErrorCode )
			{
				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :

					m_pChat->CreateChatChild(STRERR_ERROR_0107,COLOR_ERROR,CHAT_TAB_SYSTEM);// "ǰ Ͽ    ϴ."
					break;

				case ERR_PROTOCOL_REQ_WARP_REQUIREMENTS_NOT_MATCHED :
					{
						// 2005-12-12 by ispark
						// н ̼ ֱ
						CQuest* pQuest = NULL;
						char ErrorMsgMissionList[256];
						MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->ErrParam2);
						if(pMapInfo)
						{
							pQuest = g_pQuestData->FindQuest(pMapInfo->QuestIndexForWarp);
							if(pQuest)
							{
								wsprintf(ErrorMsgMissionList, STRMSG_C_050811_0001, pQuest->QuestName);
								m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR,CHAT_TAB_SYSTEM); //"%s ̼ ذ    ϴ."
							}
						}
						else
						{
							m_pChat->CreateChatChild(STRERR_ERROR_0108, COLOR_ERROR,CHAT_TAB_SYSTEM); //"   ϴ."
						}
					}
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				// 2007-09-20 by dgwoo  Ʈ ߰.
				case ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP :

					g_pInterface->m_pCityBase->CloseCurrentEnterBuilding();
					wsprintf(szBuf,STRMSG_C_070816_0122);
					m_pChat->CreateChatChild(szBuf,COLOR_ERROR);				//"  ܿ   ֽϴ."
					break;

				// 2007-10-05 by dgwoo    ݴ´.
				case ERR_PROTOCOL_NOT_HAVE_GUILD :

					g_pInterface->m_pCityBase->CloseCurrentEnterBuilding();
					m_pChat->CreateChatChild(STRERR_ERROR_0108,COLOR_ERROR,CHAT_TAB_SYSTEM);// "   ϴ."
					break;
				
				// 2008-07-21 by bhsohn     Ȳ  ó ߰
				case ERR_CANNOT_WARP_BY_TRADING :

					m_pChat->CreateChatChild(STRMSG_C_080721_0200,COLOR_ERROR,CHAT_TAB_SYSTEM);// "ŷ߿    ϴ."
					break;
		
				case ERR_CANNOT_WARP_BY_SHOPPING :

					m_pChat->CreateChatChild(STRMSG_C_080721_0201,COLOR_ERROR,CHAT_TAB_SYSTEM);// " ̿ ߿    ϴ."
					break;
					
				case ERR_USING_BAZAAR :
			
					m_pChat->CreateChatChild(STRMSG_C_080721_0202,COLOR_ERROR,CHAT_TAB_SYSTEM);// "  ̿ ߿    ϴ."
					break;
				// end 2008-07-21 by bhsohn     Ȳ  ó ߰

				default :

					m_pChat->CreateChatChild(STRERR_ERROR_0108,COLOR_ERROR,CHAT_TAB_SYSTEM);// "   ϴ."
					break;
			}
			break;
			
		case T_FC_SHOP_REQUEST_REPAIR :

			switch ( pMsg->ErrorCode )
			{

				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0111,COLOR_ERROR);// "ǰ Ͽ    ϴ."
					break;


				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 
		
					
				default :
		
					m_pChat->CreateChatChild(STRERR_ERROR_0112,COLOR_ERROR);// "   ϴ."
					break;
			}
			break;

		case T_FC_ITEM_USE_CARDITEM_GUILD :

			switch ( pMsg->ErrorCode )
			{

				case ERR_PROTOCOL_NOT_GUILD_MASTER :
					
					// 2008-06-18 by bhsohn ܿ ī  ó
					//m_pChat->CreateChatChild(STRERR_ERROR_0113,COLOR_ERROR);// "常    ֽϴ."
					m_pChat->CreateChatChild(STRMSG_C_080619_0201,COLOR_ERROR);// "\\yش  常    ֽϴ."			
					break;

				case ERR_PROTOCOL_GUILD_CARD_ALREADY_USING :

					m_pChat->CreateChatChild(STRERR_ERROR_0114,COLOR_ERROR);// "̹ ī尡  Դϴ."
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				// 2008-06-18 by bhsohn ܿ ī  ó
				case ERR_PROTOCOL_OVER_MEMBERCOUNT :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_080619_0200);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ̻   ִ ο  ų  ϴ."
					}
					break;
				// end 2008-06-18 by bhsohn ܿ ī  ó
		
				default :

					m_pChat->CreateChatChild(STRERR_ERROR_0115,COLOR_ERROR);// " ī带    ϴ."
					break;
			}
			break;
			
		case T_FC_ITEM_USE_CARDITEM_MONSTERSUMMON :

			switch ( pMsg->ErrorCode )
			{
				case ERR_PROTOCOL_NO_SUCH_MONSTER_INFO :

					m_pChat->CreateChatChild(STRERR_ERROR_0116,COLOR_ERROR);// "   Դϴ."
					m_pChat->CreateChatChild(STRERR_ERROR_0117,COLOR_ERROR);// " ͷ  ٶϴ."
					break;
				
				case ERR_PROTOCOL_INVALID_SOCKET_FORNPC :

					m_pChat->CreateChatChild(STRERR_ERROR_0118,COLOR_ERROR);// "NPC   Դϴ."
					m_pChat->CreateChatChild(STRERR_ERROR_0119,COLOR_ERROR);// "  Ͻñ ٶϴ."
					break;

				case ERR_PROTOCOL_INVALID_POSITION :
				case ERR_PROTOCOL_CANNOT_IN_CITY_MAP_CHANNEL :
		
					m_pChat->CreateChatChild(STRERR_ERROR_0120,COLOR_ERROR);// "̰  ȯī带    ϴ."
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 
		
				default :

					m_pChat->CreateChatChild(STRERR_ERROR_0121,COLOR_ERROR);// " ȯ ī带    ϴ."
					break;
			}
			break;
			
		case T_FC_ITEM_USE_CARDITEM_CHANGECHARACTERNAME :

			switch ( pMsg->ErrorCode )
			{

				case ERR_PROTOCOL_CANNOT_USEITEM_IN_PARTY :

					m_pChat->CreateChatChild(STRERR_ERROR_0122,COLOR_ERROR);// "Ƽ  Ұ  Դϴ."	
					break;
				
				case ERR_PROTOCOL_INVALID_CHARACTER_NAME :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0123,COLOR_ERROR);// "ĳ͸ ȿ ʽϴ."
					break;
						
				case ERR_COMMON_CHARACTER_ALREADY_EXISTS :

					m_pChat->CreateChatChild(STRERR_ERROR_0124,COLOR_ERROR);// "̹ ϴ ̸ Դϴ."
					break;

				case ERR_DB_EXECUTION_FAILED :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0125,COLOR_ERROR);// "    ϴ."
					m_pChat->CreateChatChild(STRERR_ERROR_0036,COLOR_ERROR);// " ͷ  ٶϴ."
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				// 2007-11-20 by dgwoo  ڵ ߰.

				case ERR_REQ_REG_LEADER_CANDIDATE :
			
					m_pChat->CreateChatChild(STRMSG_C_071120_0100,COLOR_ERROR);		//"ĺ   ̸ ī带   ϴ."
					break;

				default :
					
					m_pChat->CreateChatChild(STRERR_ERROR_0125,COLOR_ERROR);// "    ϴ."
					break;
			}
			break;

		// 2005-11-14 by ispark -   ó
		case T_FC_EVENT_REQUEST_OBJECT_EVENT :
		case T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT :

			switch ( pMsg->ErrorCode )
			{

				// 2005-12-29 by ispark, 
		//		if(pMsg->ErrorCode == ERR_PROTOCOL_REQ_WARP_REQUIREMENTS_NOT_MATCHED)
				case ERR_REQ_WARP_COMPLETIONQUEST_NOT_MATCHED :
					{//   
						// 2005-08-11 by ispark	
						// н ̼ ֱ
						CQuest* pQuest = NULL;
						char ErrorMsgMissionList[256];
						MAP_INFO* pMapInfo = g_pDatabase->GetMapInfo(pMsg->ErrParam2);
						if(pMapInfo)
						{
							pQuest = g_pQuestData->FindQuest(pMapInfo->QuestIndexForWarp);
							if(pQuest)
							{
								wsprintf(ErrorMsgMissionList, STRMSG_C_050811_0001, pQuest->QuestName);
								m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR,CHAT_TAB_SYSTEM); //"%s ̼ ذ    ϴ."
							}
							else
							{
								wsprintf(ErrorMsgMissionList, STRMSG_C_051114_0001);
								m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR,CHAT_TAB_SYSTEM); //" غԴϴ."
							}
						}
						else
						{
							m_pChat->CreateChatChild(STRERR_ERROR_0108, COLOR_ERROR,CHAT_TAB_SYSTEM); //"   ϴ."
						}
					}
					break;

				// 2008-07-21 by bhsohn     Ȳ  ó ߰
				case ERR_CANNOT_WARP_BY_TRADING :
					
					m_pChat->CreateChatChild(STRMSG_C_080721_0200,COLOR_ERROR,CHAT_TAB_SYSTEM);// "ŷ߿    ϴ."
					break;
					
				case ERR_CANNOT_WARP_BY_SHOPPING :
					
					m_pChat->CreateChatChild(STRMSG_C_080721_0201,COLOR_ERROR,CHAT_TAB_SYSTEM);// " ̿ ߿    ϴ."
					break;
					
				case ERR_USING_BAZAAR :
					
					m_pChat->CreateChatChild(STRMSG_C_080721_0202,COLOR_ERROR,CHAT_TAB_SYSTEM);// "  ̿ ߿    ϴ."
					break;

				// end 2008-07-21 by bhsohn     Ȳ  ó ߰

				case ERR_PROTOCOL_CANNOT_WARP :
					{
						// 2005-12-29 by ispark, ٸ  ÷ ̵ 
						char ErrorMsg[256];
						wsprintf(ErrorMsg, STRMSG_C_051229_0102);
						m_pChat->CreateChatChild(ErrorMsg, COLOR_ERROR); //"ٸ  ÷ ̵   ϴ."
					}
					break;

				// 2007-05-22 by bhsohn  п  ޽ ߰
				case ERR_CANNOT_WARP_TO_CITY :
					{			
						char ErrorMsg[256];
						wsprintf(ErrorMsg, STRMSG_C_051229_0102);
						m_pChat->CreateChatChild(ErrorMsg, COLOR_ERROR); //"ٸ  ÷ ̵   ϴ."
					}
					break;
				// end 2007-05-22 by bhsohn  п  ޽ ߰

				case ERR_CANNOT_WARP_CONNFLICT_AREA :
					{
						// 2006-02-14 by ispark
						char ErrorMsg[256];
						wsprintf(ErrorMsg, STRMSG_C_060214_0001);
						m_pChat->CreateChatChild(ErrorMsg, COLOR_ERROR); //"   ϴ."
					}
					break;

			
				case ERR_CANNOT_WARP_POSSESSED_CONNFLICT_AREA :
					{
						// 2006-02-14 by ispark
						char ErrorMsg[256];
						wsprintf(ErrorMsg, STRMSG_C_060214_0002);
						m_pChat->CreateChatChild(ErrorMsg, COLOR_ERROR); //"ش ¿  ʾ    ϴ."
					}
					break;

				// 2007-08-29 by bhsohn   뵵 ȸǷ 
				case ERR_CONFERENCEROOM_PERMISSION_DENIED :

					if ( pMsg->MsgType != T_FC_EVENT_REQUEST_OBJECT_EVENT )
						 break;
					
					{
						char ErrorMsg[256];
						// 2007-10-06 by dgwoo Ī .
						if(IS_VCN_INFLUENCE_TYPE(g_pShuttleChild->m_myShuttleInfo.InfluenceType))
						{
							wsprintf(ErrorMsg, STRMSG_C_070831_0201,STRCMD_VCN_INFLUENCE_LEADER);
						}
						else
						{
							wsprintf(ErrorMsg, STRMSG_C_070831_0201,STRCMD_ANI_INFLUENCE_LEADER);
						}
						m_pChat->CreateChatChild(ErrorMsg, COLOR_ERROR); //"\\y%s   ο     ֽϴ."
					}
					break;
				// end 2007-08-29 by bhsohn   뵵 ȸǷ 

				// 2007-09-14 dgwoo      . ߻.
				
#ifdef C_EPSODE4_UI_CHANGE_JSKIM					        // 2011. 10. 10 by jskim UIý 
                    case ERR_CANNOT_WARP_TO_OUTPOST :	 
// 2011. 12. 23 by jskim   Խ ޽  ޽  
// 					switch ( pMsg->ErrorCode )
// 					{
// 						case T_FC_EVENT_REQUEST_OBJECT_EVENT :
// 							{
// 								wsprintf(szBuf,STRMSG_C_070816_0100);
// 								m_pChat->CreateChatChild(szBuf,COLOR_ERROR);			//"\\y  ܿ ƴմϴ."
// 							}
// 							break;
// 
// 						case T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT :
// 							{
// 								wsprintf(szBuf,STRMSG_C_070816_0117);
// 								m_pChat->CreateChatChild(szBuf, COLOR_ERROR);			//"  Դϴ.  Ұ մϴ."
// 							}
// 							break;
//					}																			  
#else		  
					case ERR_CANNOT_WARP_TO_OUTPOST :	 
					
					switch ( pMsg->ErrorCode )
					{
						case T_FC_EVENT_REQUEST_OBJECT_EVENT :
							{
								wsprintf(szBuf,STRMSG_C_070816_0100);
								m_pChat->CreateChatChild(szBuf,COLOR_ERROR);			//"\\y  ܿ ƴմϴ."
							}
							break;

#endif
						case T_FC_PARTY_REQUEST_PARTY_OBJECT_EVENT :
							{
								wsprintf(szBuf,STRMSG_C_070816_0117);
								m_pChat->CreateChatChild(szBuf, COLOR_ERROR);			//"  Դϴ.  Ұ մϴ."
							}
// end 2011. 12. 23 by jskim   Խ ޽  ޽  
					break;
// 2011-11-01 by jhahn EP4 Ʈ ý 
				case ERR_REQ_WARP_ONE_TIME_LIMITED:
					{
						wsprintf(szBuf,STRMSG_C_111114_0003);
						m_pChat->CreateChatChild(szBuf, COLOR_ERROR);			//"1   "
					}
					break;
				case ERR_REQ_WARP_GUILD_NOT_MATCHED:
					{
						wsprintf(szBuf,STRMSG_C_111114_0004);
						m_pChat->CreateChatChild(szBuf, COLOR_ERROR);			//"   ִ 尡 ƴ"
					}
					break;
				case ERR_REQ_WARP_MAXIMUM_USER_LIMITED:
					{
						wsprintf(szBuf,STRMSG_C_111114_0005);
						m_pChat->CreateChatChild(szBuf, COLOR_ERROR);			//"ִ   ִ ο Ѿ"

					}
					break;
// 2012-04-02 by jhahn EP4 Ʈ ý -   ߰  
				case ERR_REQ_WARP_INFLUENCE_NOT_MATCHED:
					{
						wsprintf(szBuf,STRMSG_C_120402_0002);
						m_pChat->CreateChatChild(szBuf, COLOR_ERROR);			//"忡 ʿ Ʈ  "
					}																
					break;


				case ERR_REQ_WARP_GAME_START_NOT_ALLOWED_USER:
					{
						wsprintf(szBuf,STRMSG_C_120402_0001);
						m_pChat->CreateChatChild(szBuf, COLOR_ERROR);			//"忡 ʿ Ʈ  "
					}																
					break;
//end 2012-04-02 by jhahn EP4 Ʈ ý -   ߰  
				case ERR_REQ_WARP_NO_QUEST_ITEM:
					{
						wsprintf(szBuf,STRMSG_C_111114_0006);
						m_pChat->CreateChatChild(szBuf, COLOR_ERROR);			//"忡 ʿ Ʈ  "
					}
					break;				 
//end 2011-11-01 by jhahn EP4 Ʈ ý 

				case ERR_CANNOT_WARP_TO_OUTPOST_CITY_MAP :

					wsprintf(szBuf,STRMSG_C_070816_0117);
					m_pChat->CreateChatChild(szBuf, COLOR_ERROR); //"  Դϴ.  Ұ մϴ."
					break;

				// 2012-07-02 by hskim,   -      Ұ
				case ERR_CANNOT_WARP_DURING_MSWAR :
					
					wsprintf(szBuf,STRMSG_C_120702_0001);
					m_pChat->CreateChatChild(szBuf, COLOR_ERROR); //"    Ұ մϴ."
					break;
				// end 2012-07-02 by hskim,   -      Ұ
			}
			break;


		// 2005-06-29 by ispark -  ä â  ó
		case T_FC_EVENT_SELECT_CHANNEL :

			switch ( pMsg->ErrorCode )
			{
				
				case ERR_PROTOCOL_REQ_WARP_REQUIREMENTS_NOT_MATCHED :

		//			m_pChat->CreateChatChild(STRMSG_C_050627_0001,COLOR_ERROR); //"   ϴ."
					g_pD3dDev->SetDialogBoxMode(TRUE);
					MessageBox(m_hWnd,STRMSG_C_060510_0000,"Error", MB_OK);
					g_pD3dDev->SetDialogBoxMode(FALSE);
					break;

				default :

					break;
			}
			break;
		// 2005-11-15 by ispark - Ѹ   ð  ó (5 :  ó)

		case T_FC_MOVE_ROLLING :

			switch ( pMsg->ErrorCode )
			{
	
				case ERR_PROTOCOL_NOT_ENOUGH_ELAPSE_TIME :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_051115_0001, ROLLING_USE_INTERVAL_TICK / 1000);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"Ѹ   ð %d  ϴ."
					}
					break;

				default :
					break;
			}
			break;


		// 2005-12-06 by ispark,   û ׾ 
		case T_FC_SKILL_CONFIRM_USE :
		
			switch ( pMsg->ErrorCode )
			{
			
				case ERR_INVALID_PEER_CHARACTER :
				case ERR_REQ_WARP_COMPLETIONQUEST_NOT_MATCHED :

					m_pChat->CreateChatChild(STRMSG_C_051205_0004, COLOR_ERROR); //"     Դϴ."

					// 2007-10-22 by bhsohn Ÿ ų   ó
					g_pShuttleChild->m_pSkill->ReleasePrePareSkill();
					break;
			}
			break;

		// 2005-12-06 by ispark, ų ڰ ׾ 
		case T_FC_SKILL_CONFIRM_USE_ACK :

			switch ( pMsg->ErrorCode )
			{
				case ERR_INVALID_PEER_CHARACTER :
				case ERR_REQ_WARP_COMPLETIONQUEST_NOT_MATCHED :

					m_pChat->CreateChatChild(STRMSG_C_051206_0002, COLOR_ERROR); //"ų     Դϴ."
					break;
			}
			break;

		// 2005-12-08 by ispark, ͼӸ 
		case T_IC_CHAT_PTOP :

			switch ( pMsg->ErrorCode )
			{
				case ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED :

					m_pChat->CreateChatChild(STRMSG_C_051208_0100, COLOR_ERROR); // " ٸ ̹Ƿ Ӹ    ϴ."
					break;
					
				case ERR_COMMON_NO_SUCH_CHARACTER :

					m_pChat->CreateChatChild(STRERR_ERROR_0145, COLOR_ERROR); // " ӿ  ʽϴ."
					break;
			}
			break;

		// 2005-12-08 by ispark, Ʈ Ϸ û
		case T_FC_QUEST_REQUEST_SUCCESS :
		
			switch ( pMsg->ErrorCode )
			{
				case ERR_PROTOCOL_DOING_PARTY_BATTLE :

					m_pChat->CreateChatChild(STRMSG_C_051207_0001, COLOR_ERROR); // "¿    ϴ."
					break;

				case ERR_PROTOCOL_REQ_INFLUENCE_NOT_MATCHED :
					{
						char ErrorMsgInfluence[256];
						m_pChat->CreateChatChild(STRMSG_C_051208_0104, COLOR_ERROR);	// "  ϳ ¸   ֽϴ."
						wsprintf(ErrorMsgInfluence, STRMSG_C_051220_0100, CAtumSJ::GetInfluenceTypeString(pMsg->ErrParam2));
						m_pChat->CreateChatChild(ErrorMsgInfluence, COLOR_ERROR);		// "  %s  õǾϴ."
					}
					break;

				// 2009-04-08 by bhsohn  ұ,  ʱȭ ý ߰ 
				case ERR_CANNOT_CHOOSE_INFLUENCE_TYPE :
				
					g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_090408_0104, _MESSAGE);	
					break;
				// end 2009-04-08 by bhsohn  ұ,  ʱȭ ý ߰ 
			}
			break;

		// 2005-12-08 by ispark, Į 
		case T_FC_SHOP_BUY_COLOR_ITEM :
	
			switch ( pMsg->ErrorCode ) 
			{	
				case ERR_PROTOCOL_REQ_MINLEVEL_NOT_MATCHED :
		
					m_pChat->CreateChatChild(STRMSG_C_051118_0001, COLOR_ERROR); // "     ϴ."
					break;
				
				case ERR_PROTOCOL_REQ_MAXLEVEL_NOT_MATCHED :
	
					m_pChat->CreateChatChild(STRMSG_C_051118_0001, COLOR_ERROR); // "     ϴ."
					break;

				case ERR_PROTOCOL_BUILDING_KIND_NOT_MATCHED :
		
					m_pChat->CreateChatChild(STRMSG_C_051208_0106, COLOR_ERROR); // "Į ƴմϴ."
					break;
				
				case ERR_INVALID_ARMOR_ITEM :
		
					m_pChat->CreateChatChild(STRMSG_C_051208_0107, COLOR_ERROR); // "Į Item Number Դϴ."
					break;

				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :
					
					m_pChat->CreateChatChild(STRMSG_C_SHOP_0011, COLOR_ERROR); // " ϱ  ǰ մϴ"
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				// 2008-08-18 by bhsohn 1   ̵ ý 
				case ERR_INTERVAL_SYSTEM_SECOND :

					break;
				// end 2008-08-18 by bhsohn 1   ̵ ý 
			}
			break;

		// 2006-03-28 by ispark, Ʈ  üũ
		case T_FC_QUEST_REQUEST_SUCCESS_CHECK :

			switch ( pMsg->ErrorCode )
			{
	
				case ERR_PROTOCOL_REQ_PARTYMEMBERS_SOMEONE_NOT_COMPLETION :

					// ׳  .
					break;

				default :

					break;
			}
			break;
	
		// 2006-04-10 by ispark, Ȱ ī
		case T_FC_ITEM_USE_CARDITEM_RESTORE :

			switch ( pMsg->ErrorCode )
			{
	
				case ERR_FAILURE_USE_RESTORE_ITEM :
			
					m_pChat->CreateChatChild(STRMSG_C_060410_0004, COLOR_ERROR);	// "Ȱ  Ͽϴ."
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 
			}

			// 2007-10-23 by dgwoo ׾ 쿡 T_FC_ITEM_USE_CARDITEM_RESTORE  ߻ SendDeadMsg() ߻.
			if(g_pShuttleChild->CheckUnitState() == BREAKDOWN)
				g_pShuttleChild->SendDeadMsg();

			break;


		// 2006-05-12 by ispark, ŷ  üũ
		case T_FC_TRADE_OK_TRADE :
	
			
			// ⿡  ڵ  üũ Ѵ.
			// ERR_PROTOCOL_MAX_ITEM_COUNTS_OVER
			// ERR_PROTOCOL_NO_SUCH_ITEM
			// ERR_PROTOCOL_INVENTORY_FULL_ITEM
			switch ( pMsg->MsgType )
			{
				case ERR_PROTOCOL_INVALID_ITEM_COUNT :
				
					m_pChat->CreateChatChild(STRMSG_C_060512_0000,COLOR_ERROR);// "  Դϴ."		
					break;

				default :
					break;
			}
			break;

		// 2006-05-12 by ispark, ŷ  
		case T_FC_TRADE_REQUEST_TRADE :

			switch ( pMsg->ErrorCode )
			{
				case ERR_USING_SHOP :

					m_pChat->CreateChatChild(STRMSG_C_060512_0001,COLOR_ERROR);// "  ̿ Դϴ."	
					break;

				case ERR_USING_BAZAAR :

					m_pChat->CreateChatChild(STRMSG_C_060512_0001,COLOR_ERROR);// "  ̿ Դϴ."	
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 


				// 2008-02-26 by bhsohn  Ʒ   
				case ERR_CANNOT_USE_ARENASERVER :
					{
						char ErrorMsgMissionList[256];

						// 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý

						//wsprintf(ErrorMsgMissionList, STRMSG_C_080225_0203);
						if( g_pD3dApp->m_ArenaSocketType == CAtumApplication::ARENASOCKET_ARENA )
							wsprintf(ErrorMsgMissionList, STRMSG_C_080225_0203);
						else if( g_pD3dApp->m_ArenaSocketType == CAtumApplication::ARENASOCKET_INFINITY )
							wsprintf(ErrorMsgMissionList, STRMSG_C_091103_0322);

						// end 2009. 11. 02 by ckPark ǴƼ ʵ νϽ  ý

						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2008-02-26 by bhsohn  Ʒ   
			}
			break;

		// 2006-05-15 by ispark
		case T_FC_STORE_GET_ITEM :

			switch ( pMsg->ErrorCode )
			{
				case ERR_ITEM_TRADING :

					m_pChat->CreateChatChild(STRERR_ERROR_0016,COLOR_ERROR);// "̹ ŷԴϴ."
					break;

				case ERR_NO_SEARCH_CHARACTER :
					// 2006-09-19 by dgwoo
					m_pChat->CreateChatChild(STRMSG_C_060920_0102,COLOR_ERROR);
					break;

				case ERR_NO_MEMBERSHIP_USER :

					m_pChat->CreateChatChild(STRMSG_C_060920_0103,COLOR_ERROR);
					break;

				// 2007-09-12 by bhsohn 2 ȣ ý 
				case ERR_SECPASS_LOCKED :
					{
						char ErrorMsgMissionList[256];
						wsprintf(ErrorMsgMissionList, STRMSG_C_070917_0213);
						m_pChat->CreateChatChild(ErrorMsgMissionList, COLOR_ERROR); //"\\y ý Ȱȭ Ǿϴ."
					}
					break;
				// end 2007-09-12 by bhsohn 2 ȣ ý 

				// 2009. 09. 24 by jskim ʵ â ĳ 
				case ERR_CANNOT_USE_GUILD_STORE :

					m_pChat->CreateChatChild(STRMSG_C_090925_0401,COLOR_ERROR);	//"ʵ忡  â ̿   ϴ."	
					break;

				case ERR_CANNOT_USE_FIELD_STORE :
				
					m_pChat->CreateChatChild(STRMSG_C_090925_0402,COLOR_ERROR);	//"ʵ â ̿   ϴ."
					break;
				//end 2009. 09. 24 by jskim ʵ â ĳ 
					// 2012-12-11 by bhsohn  â ̵  ߰
				default :
					{
						m_pChat->CreateChatChild(STRERR_ERROR_0104,COLOR_ERROR);// "â ̿   ϴ."
					}
					break;
				// END 2012-12-11 by bhsohn  â ̵  ߰
			}
			break;
		
		// 2006-07-31 by ispark, ڸ
		case T_FC_BAZAAR_SELL_PUT_ITEM :

			switch ( pMsg->ErrorCode )
			{
				case ERR_INVALID_CHARACTER  :

					m_pChat->CreateChatChild(STRMSG_C_060801_0006,COLOR_ERROR);// "ǸŻų  ĳͰ  ʽϴ."
					break;

				case ERR_PROTOCOL_ITEM_CANNOT_TRANSFER :

					m_pChat->CreateChatChild(STRMSG_C_060801_0001,COLOR_ERROR);// "  Ͽϴ."
					break;
				
				case ERR_PROTOCOL_ITEM_AMOUNT_EXCEED :

					break;

				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :

					g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_060802_0005, _MESSAGE);	// " ִȿ ʰϿϴ.(ִȿ 20)"
					break;
			}
			break;
				
		case T_FC_BAZAAR_SELL_CANCEL_ITEM :

			switch ( pMsg->ErrorCode )
			{
				case ERR_INVALID_CHARACTER :
			
					m_pChat->CreateChatChild(STRMSG_C_060801_0006,COLOR_ERROR);// "ǸŻų  ĳͰ  ʽϴ."
					break;

				case ERR_PROTOCOL_INVALID_CHARACTER_STATE :

					break;
			}
			break;

		case T_FC_BAZAAR_SELL_START :
			
			switch ( pMsg->ErrorCode )
			{
				case ERR_INVALID_CHARACTER :

					m_pChat->CreateChatChild(STRMSG_C_060801_0006,COLOR_ERROR);// "ǸŻų  ĳͰ  ʽϴ."
					break;

				case ERR_PROTOCOL_INVALID_CHARACTER_STATE :

					break;
			}
			break;

		case T_FC_BAZAAR_SELL_REQUEST_ITEMLIST :

			switch ( pMsg->ErrorCode )
			{
				
				case ERR_INVALID_CHARACTER :
			
					g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_060801_0000, _MESSAGE);	// "λ  Ǿϴ."
					break;

				case ERR_INVALID_PEER_CHARACTER :

					g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_060801_0000, _MESSAGE);	// "λ  Ǿϴ."
					break;

				case ERR_INVALID_BAZAAR :

					m_pChat->CreateChatChild(STRERR_ERROR_0034,COLOR_ERROR);				// "ȿ  ƴմϴ."
					g_pInterface->ReadyCloseBazaarShop(TRUE);								//   üũ
					break;
			}
			break;

		case T_FC_BAZAAR_SELL_BUY_ITEM :

			switch ( pMsg->ErrorCode )
			{

				case ERR_INVALID_CHARACTER :

		//			wsprintf(errStr,STRERR_ERROR_0003);
					g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_060801_0000, _Q_BAZAAR_INVALID_SHOP_END);	// "λ  Ǿϴ."
					break;

				case ERR_INVALID_PEER_CHARACTER :

					g_pGameMain->m_pInfWindow->AddMsgBox(STRMSG_C_060801_0000, _Q_BAZAAR_INVALID_SHOP_END);	// "λ  Ǿϴ."
					break;

				case ERR_PROTOCOL_NOT_ENOUGH_MONEY :

					g_pGameMain->m_pInfWindow->AddMsgBox(STRERR_ERROR_0109, _MESSAGE);
					break;
					
				case ERR_PROTOCOL_BAZAAR_NO_SUCH_ITEM :

					m_pChat->CreateChatChild(STRERR_ERROR_0025,COLOR_ERROR);// "ش  ϴ."
					g_pInterface->ErrBazaarItemList();
					break;

				case ERR_PROTOCOL_ITEM_AMOUNT_EXCEED :

					break;
					
				case ERR_PROTOCOL_INVENTORY_FULL_ITEM :

					g_pGameMain->m_pInfWindow->AddMsgBox(STRERR_ERROR_0022, _MESSAGE);
					break;
			}
			break;
			
		case T_FC_BAZAAR_BUY_PUT_ITEM :

			switch (pMsg->ErrorCode )
			{
				case ERR_DB_INVALID_PARAMETER :
					break;
					
				case ERR_INVALID_CHARACTER :

					m_pChat->Creat