// AllListDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mapeditor.h"
#include "AllListDlg.h"

#include "MainFrm.h"
#include "MapEditor.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"
#include "MFCUtil.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAllListDlg dialog


CAllListDlg::CAllListDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAllListDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAllListDlg)
	m_strSearch = _T("");
	//}}AFX_DATA_INIT

	// 07-05-14 by shkim, Ʈ ġ Ѱ ֱ 
	m_nObjCheckNumber = -1;
}


void CAllListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAllListDlg)
	DDX_Control(pDX, IDC_LIST_OBJECTLIST, m_ListObject);
	DDX_Text(pDX, IDC_OBJLIST_EDIT, m_strSearch);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAllListDlg, CDialog)
	//{{AFX_MSG_MAP(CAllListDlg)
	ON_LBN_SELCHANGE(IDC_LIST_OBJECTLIST, OnSelchangeListObjectlist)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_BN_CLICKED(IDC_SERCHOBJLIST_BUTTON, OnSerchobjlistButton)
	ON_EN_UPDATE(IDC_OBJLIST_EDIT, OnUpdateObjlistEdit)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAllListDlg message handlers

void CAllListDlg::OnSelchangeListObjectlist() 
{
	// Ʈ ڽ Ʈ ȣ Ŭ ϸ ī޶ װ ġѴ.
	int num = m_ListObject.GetCurSel();

	// 07-05-15 by shkim, Ʈ ƹ͵ ٸ
	if( num < 0 )
	{
		return;
	}

	GetObjectViewer( num ); // 07-05-14 by shkim, Ʈ 
	
}

// by dhkwon 20100720 Ʈ      
void CAllListDlg::OnButtonDelete() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
//	if(pView->m_bCheckObject && pView->m_dlgObjectSet.m_pObject)
//	{
//		pView->m_dlgObjectSet.m_pObject->m_bUsing = FALSE;
//		pView->m_pBackground->m_nObjectNumber--;
//	}
//	else
//	{
//		AfxMessageBox("Ʈ (Object Set) Ű Ʈ ´ ٽ ȮϿ ֽʽÿ",MB_OK);
//	}

	int nCount = m_ListObject.GetSelCount();
	int* vIndex = new int[nCount];
	memset((void*)vIndex, 0x00, nCount*sizeof(int));
	m_ListObject.GetSelItems( nCount, (LPINT)vIndex);
	for(int i=0;i<nCount;i++)
	{
		CObjectChild * pObj = (CObjectChild*)m_ListObject.GetItemDataPtr(vIndex[i] );	
		ASSERT(pObj);
		pObj->m_bUsing = FALSE;
		pView->m_pBackground->m_nObjectNumber--;
	}
}
void CAllListDlg::OnKeyButtonDelete() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	//	if(pView->m_bCheckObject && pView->m_dlgObjectSet.m_pObject)
	//	{
	//		pView->m_dlgObjectSet.m_pObject->m_bUsing = FALSE;
	//		pView->m_pBackground->m_nObjectNumber--;
	//	}
	//	else
	//	{
	//		AfxMessageBox("Ʈ (Object Set) Ű Ʈ ´ ٽ ȮϿ ֽʽÿ",MB_OK);
	//	}
	
	int nCount = m_ListObject.GetSelCount();
	int* vIndex = new int[nCount];
	memset((void*)vIndex, 0x00, nCount*sizeof(int));
	m_ListObject.GetSelItems( nCount, (LPINT)vIndex);
	for(int i=0;i<nCount;i++)
	{
		CObjectChild * pObj = (CObjectChild*)m_ListObject.GetItemDataPtr(vIndex[i] );	
		ASSERT(pObj);
		pObj->m_bUsing = FALSE;
		pView->m_pBackground->m_nObjectNumber--;
	}
}

void CAllListDlg::OnOK() 
{
	// TODO: Add extra validation here	
//	CDialog::OnOK();
}

void CAllListDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CDialog::OnCancel();
}
/*
BOOL CompareLeft(CString &strText, CString &strSearch, int nLength)
{
	CString strLeft = strText.Left(nLength);
	if(strLeft == strSearch)
		return TRUE;
	return FALSE;

}
*/
// by dhkwon, 20100708, ListBox ItemData   Ʈ ڽ  
void CAllListDlg::OnSerchobjlistButton() 
{	
	int nCurSel = m_ListObject.GetCurSel(); //  -1 ̸
	// 07-05-14 by shkim,  Ʈ ˻ ش.
	int nObjNumber = GetObjectNumberCheck( m_strSearch );

	// 07-05-15 by shkim, Ʈ ƹ͵ ٸ
	if( nObjNumber < 0 )
	{
		return;
	}
	if( nCurSel == nObjNumber )
	{
		if(m_ListObject.GetCount() == nCurSel+1)
		{
			m_ListObject.SetCurSel( 0 );
			nObjNumber = GetObjectNumberCheck( m_strSearch );
		}
		else
		{
			CString strText;
			m_ListObject.GetText(nCurSel+1, strText);
			if( CompareLeft(strText, m_strSearch, m_strSearch.GetLength()) == TRUE )
			{
				nObjNumber++;
				//m_ListObject.SetCurSel(nCurSel+1);
			}
			else
			{
				m_ListObject.SetCurSel( 0 );
				nObjNumber = GetObjectNumberCheck( m_strSearch );
			}

		}
	}

	m_ListObject.SetCurSel( nObjNumber );	

	GetObjectViewer( nObjNumber ); // 07-05-14 by shkim, Ʈ 
}

void CAllListDlg::OnUpdateObjlistEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_UPDATE flag ORed into the lParam mask.
	
	// 07-05-09 by shkim, Ʈ Ʈ ˻ Ʈ Ʈ
	//  Ʈ Ʈ Լ Ʈ ٷ   Լ̴.

	UpdateData(TRUE);	
//	UpdateData(FALSE);


	// by dhkwon, 20100708, ListBox ItemData   Ʈ ڽ  
	int nObjNumber = GetObjectNumberCheck( m_strSearch );

	if( nObjNumber < 0 )
	{
		return;
	}


	m_ListObject.SetCurSel( nObjNumber );	

	GetObjectViewer( nObjNumber );



}

// by dhkwon, 20100708, ListBox ItemData   Ʈ ڽ  
int CAllListDlg::GetObjectNumberCheck( CString strSearch )
{
	int nTotal = m_ListObject.GetCount();

	if( nTotal == 0 )
	{
		return -1;
	}

	int num = m_ListObject.GetCurSel(); //  -1 ̸

	if( num < 0 ) //  -1 ̸ 0 ־
	{
		num = 0;
	}
	CString strText, strLeft;
	for( int i = num ; i < nTotal ; i++ )
	{
		m_ListObject.GetText(i, strText);

		if( CompareLeft(strText, strSearch, strSearch.GetLength()) == TRUE )
		{
			return i;
		}
	}
	return num;
}

void CAllListDlg::GetObjectViewer( int nListNumber )
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	CString str;
	CObjectChild * pObj = (CObjectChild*)m_ListObject.GetItemDataPtr( nListNumber );	
	ASSERT(pObj);

	D3DXVECTOR3 vVel,vPos;
	vPos = pView->m_pCamera->GetEyePt();
	D3DXVec3Normalize(&vVel,&pView->m_pCamera->GetViewDir());
	vPos = pObj->m_vPos - 1000.0f*vVel;
	if(pView->m_bCheckObject)
		pView->m_dlgObjectSet.ObjectSelect(pObj);
	pView->m_pCamera->SetViewParams(vPos,pObj->m_vPos,pView->m_pCamera->GetUpVec());


}


void CAllListDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default


	
	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL CAllListDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	switch(pMsg->message)
	{
	case WM_KEYDOWN:
		{
			if (pMsg->wParam == 46)
			{
				OnKeyButtonDelete();			
			}		
		}
		break;
	}
	
	
	return CDialog::PreTranslateMessage(pMsg);
}
