// AppEffectData.cpp: implementation of the CAppEffectData class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AppEffectData.h"

#include "MainFrm.h"
#include "MapEditor.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAppEffectData::CAppEffectData(int nType,D3DXVECTOR3 vPos)
{
	m_pCharacterInfo = NULL;
	m_fDistance = 0.0f;
	m_vTargetPos = vPos;
	m_vPos = vPos;
	m_vVel = D3DXVECTOR3(0,0,1);
	m_vUp = D3DXVECTOR3(0,1,0);
	D3DXMatrixLookAtRH( &m_mMatrix, &(m_vPos), &(m_vPos + m_vVel), &m_vUp);
	D3DXMatrixInverse( &m_mMatrix, NULL, &m_mMatrix );
	char buf[256];
	m_nType = nType;
	wsprintf(buf,"%08d",m_nType);
	LoadCharacterEffect(buf);
	m_bodyCondition = BODYCON_FLY_MASK;
	if(m_pCharacterInfo)
	{
		m_pCharacterInfo->SetAllBodyConditionMatrix(m_mMatrix);
		m_pCharacterInfo->ChangeBodyCondition(m_bodyCondition);
	}
}

CAppEffectData::~CAppEffectData()
{
	if(m_pCharacterInfo)//߰
	{
		m_pCharacterInfo->InvalidateDeviceObjects();
		m_pCharacterInfo->DeleteDeviceObjects();
		SAFE_DELETE(m_pCharacterInfo);
	}
}

void CAppEffectData::Tick()
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	float fElapsedTime = pView->GetElapsedTime();
	// effect matrix & ticking
	if(m_pCharacterInfo)
	{
		m_pCharacterInfo->SetSingleBodyConditionMatrix( BODYCON_FLY_MASK,m_mMatrix );
		m_pCharacterInfo->Tick(fElapsedTime);
	}
	if(m_pCharacterInfo)
	{
		if(!m_pCharacterInfo->IsUsing())
			m_bUsing = FALSE;
	}
	else
	{
		m_bUsing = FALSE;
	}
}

void CAppEffectData::LoadCharacterEffect(char* strFileName)
{
	if(m_pCharacterInfo)
	{
		m_pCharacterInfo->InvalidateDeviceObjects();
		m_pCharacterInfo->DeleteDeviceObjects();
		m_pCharacterInfo->InitData();
	}
	m_pCharacterInfo = new CCharacterInfo();
	if(m_pCharacterInfo->Load(strFileName))
	{
		m_pCharacterInfo->InitDeviceObjects();
		m_pCharacterInfo->RestoreDeviceObjects();
	}
	else
		SAFE_DELETE(m_pCharacterInfo);
}

