// Background.cpp: implementation of the CBackground class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MapEditor.h"
#include "Background.h"

#include "Dbgout_C.h"
#include "stdio.h"
#include "MainFrm.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"
#include <direct.h>
#include "AppEffectData.h"

#include "SCamera.h"
#include "roam.h"
#include "ViewFrustum.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern LPDIRECT3DDEVICE8	g_pD3dDev;
ViewFrustum * g_pFrustum;

#define D3DFVF_SPRITEVERTEX (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX1)
#define D3DFVF_NOSPRITE (D3DFVF_XYZ|D3DFVF_DIFFUSE)
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBackground::CBackground(short x, short y)
{


	m_pHeightMap = NULL;
	
	int i,j;
	m_sXSize = x;
	m_sYSize = y;
	m_fTileSize = 40.0f;
	m_pVBLine = NULL;
	m_pTileVertexArray = NULL;
	m_pBlockVertexArray = NULL;
	m_pBlockData = NULL;
	m_pVBWater = NULL;
	m_pTileInfo = NULL;
	m_pTexFileInfo = NULL;
	m_pEventInfo = NULL;
	m_nCreateTexNumber = 0;
	m_nTexUseNumber = 0;
	m_nObjectNumber = 0;
	m_nObjectNumberOld = 0;
	m_fCheckWaterTexAniTime = 0.1f;
	m_ninsertTileFileCont = 0;
	m_ninsertTileFileBaseCont = 0;
	m_nMonsterNumber = 0;
	m_fHeight = -5.0f;	
	
	m_bPickCheck = true; // 07-05-08 by shkim, ŷ üũ
	m_vPickPos = D3DXVECTOR3( 0.0f, 0.0f, 0.0f ); // 07-05-08 by shkim, ŷ ġ

	///////////// Event Set //////////
	for(i=0;i<MAX_TEXEVENT_NUM;i++)
		m_pEventTexture[i] = NULL;

	m_pTileInfo = new TILEINFO[m_sXSize*m_sYSize];
	memset(m_pTileInfo, 0x00, sizeof(TILEINFO)*m_sXSize*m_sYSize);
	for(i=0;i<m_sXSize*m_sYSize;i++)
	{
		m_pTileInfo[i].texTileDirect1=-1;
		m_pTileInfo[i].texTileDirect2=-1;
		m_pTileInfo[i].texTileDirect3=-1;
		m_pTileInfo[i].texTileDirect4=-1;
		m_pTileInfo[i].useTexNumber = 0;
		m_pTileInfo[i].useBaseTexNumber = -1;
		m_pTileInfo[i].ranTexNumber = -1;
		m_pTileInfo[i].waterType = 0;
		m_pTileInfo[i].waterHeight = 0;
		m_pTileInfo[i].waterTexNumber = 0;
		m_pTileInfo[i].bBaseTile = TRUE;
	}
	m_pTexFileInfo = new TEXFILEINFO[MAX_TEXTILE_NUM];
	for(i=0;i<MAX_TEXTILE_NUM;i++)
	{
		wsprintf(m_pTexFileInfo[i].name, "");
		m_pTexFileInfo[i].texTileDirect1=-1;
		m_pTexFileInfo[i].texTileDirect2=-1;
		m_pTexFileInfo[i].texTileDirect3=-1;
		m_pTexFileInfo[i].texTileDirect4=-1;
	}

	m_pTileVertexArray = new VERTEXINFO[ (m_sXSize+1) * (m_sYSize+1) ];
	// 07-05-08 by shkim, ӽ  
	m_pvTempVecArr = new D3DXVECTOR3[ ( m_sXSize + 1 ) * ( m_sYSize + 1 ) ];

	for( i=0;i<m_sXSize+1;i++)
	{
		for(j=0;j<m_sYSize+1;j++)
		{
			m_pTileVertexArray[i*(m_sYSize+1)+j].pos.x = i * m_fTileSize;
			m_pTileVertexArray[i*(m_sYSize+1)+j].pos.z = j * m_fTileSize;
			m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y = 0.0f;
			m_pTileVertexArray[i*(m_sYSize+1)+j].nor = D3DXVECTOR3(0,1,0);

			// 07-05-08 by shkim,  迭  ޾Ƽ ӽ  ִ´.
			m_pvTempVecArr[ i * ( m_sYSize + 1 ) + j ].x = m_pTileVertexArray[ i * ( m_sYSize + 1 ) + j ].pos.x;
			m_pvTempVecArr[ i * ( m_sYSize + 1 ) + j ].y = m_pTileVertexArray[ i * ( m_sYSize + 1 ) + j ].pos.y;
			m_pvTempVecArr[ i * ( m_sYSize + 1 ) + j ].z = m_pTileVertexArray[ i * ( m_sYSize + 1 ) + j ].pos.z;
		}
	}

	m_pBlockVertexArray = new VERTEXINFO[(2*m_sXSize+1)*(2*m_sYSize+1)];
	for( i=0;i<2*m_sXSize+1;i++)
	{
		for(j=0;j<2*m_sYSize+1;j++)
		{
			m_pBlockVertexArray[i*(2*m_sYSize+1)+j].pos.x = i * 20;
			m_pBlockVertexArray[i*(2*m_sYSize+1)+j].pos.z = j * 20;
			m_pBlockVertexArray[i*(2*m_sYSize+1)+j].pos.y = 0.0f;
			m_pBlockVertexArray[i*(2*m_sYSize+1)+j].nor = D3DXVECTOR3(0,1,0);
		}
	}

	m_pBlockData = new BLOCKDATA[(2*m_sXSize+1)*(2*m_sYSize+1)];
	for( i=0;i<2*m_sXSize+1;i++)
	{
		for(j=0;j<2*m_sYSize+1;j++)
		{
			m_pBlockData[i*(2*m_sYSize+1)+j].fBlockHeight = 0.0f;
			m_pBlockData[i*(2*m_sYSize+1)+j].fGroundHeight = 0.0f;
			m_pBlockData[i*(2*m_sYSize+1)+j].nUseBlockCount = 0;
		}
	}
	for(i=0;i<MAX_TEXTILE_NUM;i++)
		m_pCreateTexture[i] = NULL;

	for(i=0;i<10;i++)
		m_pWaterTexture[i] = NULL;

	for(i=0;i<MAX_BASETILE_NUM;i++)
	{
		for(j=0;j<MAX_BASETILERANDOM_NUM;j++)
		{
			m_pTileTexture[i][j] = NULL;
		}
	}

	m_pEventInfo = new EVENTINFO[(m_sXSize)*(m_sYSize)];
	m_bUsingArray = new BOOL[(m_sXSize)*(m_sYSize)];
	m_bUsingMonsterRegion = new BOOL[(m_sXSize)*(m_sYSize)];
	for( i=0;i<m_sXSize;i++)
	{
		for(j=0;j<m_sYSize;j++)
		{	
			m_pEventInfo[i*(m_sYSize)+j].m_vPosition = D3DXVECTOR3(0,0,0);
			m_pEventInfo[i*(m_sYSize)+j].m_bMove = 0;
			m_pEventInfo[i*(m_sYSize)+j].m_bPKType = 0;
			m_pEventInfo[i*(m_sYSize)+j].m_bEnableLand = FALSE;
			m_pEventInfo[i*(m_sYSize)+j].m_bEnvetType = 0;
			m_pEventInfo[i*(m_sYSize)+j].m_EventwParam1 = 0;
			m_pEventInfo[i*(m_sYSize)+j].m_EventwParam2 = 0;
			m_pEventInfo[i*(m_sYSize)+j].m_EventwParam3 = 0;
			strcpy(m_pEventInfo[i*(m_sYSize)+j].m_EventstrParam, "");
//			m_pEventInfo[i*(m_sYSize)+j].m_bUseWater = FALSE;
			m_pEventInfo[i*(m_sYSize)+j].m_dwWaterType = 0;
			m_bUsingArray[i*(m_sYSize)+j] = FALSE;
			m_bUsingMonsterRegion[i*(m_sYSize)+j] = FALSE;
		}
	}
	// Water  ϱ  Matrix  ̸ ۼѴ.
	D3DXVECTOR3 vUp,vPos,vTarget;
	vUp = D3DXVECTOR3(0,0,-1);
	vPos = D3DXVECTOR3(0,100,0);
	vTarget = D3DXVECTOR3(0,0,0);
	D3DXMatrixLookAtLH(&m_matWater,&vPos,&vTarget,&vUp);
	m_pBackTexture = NULL;




	g_pFrustum = new ViewFrustum;

	m_pTerrain = new Terrain();
	//Terrain::side = 64.0f;
	m_pTerrain->iResolution = 128;
	m_pTerrain->iNumMips = 1;
	strcpy(m_pTerrain->texname, "Res-TempTex\\map");
	Patch::tvar= 0;
	Patch::lVariance = 1.9f*1.5f * 3.0f;// by dhkwon map size*40
	//		Patch::lVariance = 1.9f;
	Patch::sroam= 0;
	strcpy(m_strTerrainMap, "Res-Map\\height512.bmp");
	//m_pTerrain->Init(m_strTerrainMap);
	m_pTerrain->InitDevices(g_pD3dDev); 
	
}

CBackground::~CBackground()
{
	SAFE_DELETE_ARRAY(m_pTileInfo);
	SAFE_DELETE_ARRAY(m_pTexFileInfo);

	SAFE_DELETE_ARRAY(m_pTileVertexArray);
	SAFE_DELETE_ARRAY(m_pvTempVecArr); // 07-05-08 by shkim, temp vertex 

	SAFE_DELETE_ARRAY(m_pBlockVertexArray);
	SAFE_DELETE_ARRAY(m_pBlockData);

	SAFE_DELETE_ARRAY(m_pEventInfo);
	
	SAFE_DELETE_ARRAY(m_bUsingArray);
	SAFE_DELETE_ARRAY(m_bUsingMonsterRegion);

	SAFE_DELETE(m_pTerrain);
	SAFE_DELETE_ARRAY(m_pHeightMap);



	map<INT,CAtumNode *>::iterator it = m_mapObjectData.begin();
	int size = (int)m_mapObjectData.size();
	int count = 0; //07-04-30 by shkim,    Ȯ
	
	while(it != m_mapObjectData.end())
	{
		CAtumNode * pNode = (CAtumNode *)it->second;
		SAFE_DELETE(pNode);
		count++;
		it++;
	}
	m_mapObjectData.clear();
	SAFE_RELEASE(m_pBackTexture);
}


HRESULT CBackground::InitDeviceObjects()
{
	char buf[256];
	int i;
	// Water
	for(i=0;i<10;i++)
	{
		wsprintf(buf,"water%03d.tga",i);
		if( FAILED( D3DUtil_CreateTexture( g_pD3dDev,buf, &m_pWaterTexture[i] ) ) )
			return E_FAIL;
	}
	/////////////// Event Set ////////////////////////
	for(i=0;i<MAX_TEXEVENT_NUM;i++)
	{
		wsprintf(buf,"EventSet-%d.tga",i);
		if( FAILED( D3DUtil_CreateTexture( g_pD3dDev,buf, &m_pEventTexture[i] ) ) )
			return E_FAIL;
	}

	return CAtumNode::InitDeviceObjects();
}

HRESULT CBackground::RestoreDeviceObjects()
{

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();


	g_pD3dDev->BeginStateBlock();
    g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE,  FALSE );
    g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE,  FALSE );
	g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   TRUE );
	g_pD3dDev->SetRenderState( D3DRS_LIGHTING, TRUE );
	g_pD3dDev->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	g_pD3dDev->EndStateBlock( &m_dwStateBlock );

	float hsx,hsy;
	// test tile
	int i,j;
/*	for(i=0;i<32;i++)
	{
		for(j=0;j<32;j++)
		{
			if( FAILED( g_pD3dDev->CreateVertexBuffer( 6 * sizeof(SPRITEVERTEX),
				0, D3DFVF_SPRITEVERTEX, D3DPOOL_MANAGED, &m_pVBRender[i*32+j] ) ) )
				return E_FAIL;
		}
	}
*/	for(i=0;i<64;i++)
	{
		for(j=0;j<64;j++)
		{
			if( FAILED( g_pD3dDev->CreateVertexBuffer( 6 * sizeof(SPRITEVERTEX),
				0, D3DFVF_SPRITEVERTEX, D3DPOOL_MANAGED, &m_pVBRender[i*64+j] ) ) )
				return E_FAIL;
		}
	}
	// Water 
	if( FAILED( g_pD3dDev->CreateVertexBuffer( 4 * sizeof(SPRITEVERTEX),
		0, D3DFVF_SPRITEVERTEX, D3DPOOL_MANAGED, &m_pVBWater ) ) )
		return E_FAIL;
	SPRITEVERTEX* v1;
	m_pVBWater->Lock( 0, 0, (BYTE**)&v1, 0 );
	hsx = 40.0f;
	hsy = 40.0f;
	v1[0].p = D3DXVECTOR3(0,-hsy,0);		v1[0].tu = 0.0f;v1[0].tv = 1.0f;//	v1[0].color=0x99ff0000;
	v1[1].p = D3DXVECTOR3(0,0,0);			v1[1].tu = 0.0f;v1[1].tv = 0.0f;//	v1[1].color=0x99ff0000;
	v1[2].p = D3DXVECTOR3(hsx,-hsy,0);		v1[2].tu = 1.0f;v1[2].tv = 1.0f;//	v1[2].color=0x99ff0000;
	v1[3].p = D3DXVECTOR3(hsx,0,0);			v1[3].tu = 1.0f;v1[3].tv = 0.0f;//	v1[3].color=0x99ff0000;
	m_pVBWater->Unlock();

	if( FAILED( g_pD3dDev->CreateVertexBuffer( 5 * sizeof(LINEVERTEX),
		0, D3DFVF_LINEVERTEX, D3DPOOL_MANAGED, &m_pVBLine ) ) )
		return E_FAIL;

	if( FAILED( g_pD3dDev->CreateVertexBuffer( 4 * sizeof(NOSPRITE),
		0, D3DFVF_NOSPRITE, D3DPOOL_MANAGED, &m_pVBFlying ) ) )
		return E_FAIL;

	NOSPRITE* v2;
	m_pVBFlying->Lock( 0, 0, (BYTE**)&v2, 0 );
	hsx = m_sXSize*40.0f;
	hsy = m_sYSize*40.0f;
	v2[0].p = D3DXVECTOR3(0,25,0);		v2[0].color=0x99334AFD;
	v2[1].p = D3DXVECTOR3(0,25,hsy);	v2[1].color=0x99334AFD;	
	v2[2].p = D3DXVECTOR3(hsx,25,0);	v2[2].color=0x99334AFD;
	v2[3].p = D3DXVECTOR3(hsx,25,hsy);	v2[3].color=0x99334AFD;
	m_pVBFlying->Unlock();


	FLOAT fAspect = ((FLOAT)pView->m_d3dsdBackBuffer.Width) / pView->m_d3dsdBackBuffer.Height;
	g_pFrustum->SetPerspectiveSpecs(D3DX_PI/4,fAspect,1.0f,200000.0f);



	return CAtumNode::RestoreDeviceObjects();
}

HRESULT CBackground::InvalidateDeviceObjects()
{
	int i,j;
//	for(i=0; i<32*32; i++)
//		SAFE_RELEASE( m_pVBRender[i] );
	for(i=0; i<64; i++)
	{
		for(j=0; j<64; j++)
			SAFE_RELEASE( m_pVBRender[i*64+j] );
	}
	SAFE_RELEASE( m_pVBLine );
	SAFE_RELEASE( m_pVBWater );
	SAFE_RELEASE( m_pVBFlying );

	if(m_pTerrain)
	{
		m_pTerrain->ClearDevices();
	}

	return CAtumNode::InvalidateDeviceObjects();
}

HRESULT CBackground::DeleteDeviceObjects()
{
	int i,j;
	for( i=0; i<MAX_BASETILE_NUM; i++)
		for(j=0;j<MAX_BASETILERANDOM_NUM;j++)
			SAFE_RELEASE( m_pTileTexture[i][j] );
	for(i=0; i<MAX_TEXTILE_NUM; i++)
		SAFE_RELEASE( m_pCreateTexture[i] );
	for(i=0; i<10; i++)
		SAFE_RELEASE( m_pWaterTexture[i] );
	////////////// Event Set /////////////
	for(i=0; i<MAX_TEXEVENT_NUM; i++)
		SAFE_RELEASE( m_pEventTexture[i] );

	SAFE_DELETE_ARRAY(m_bUsingMonsterRegion);

	if(m_pTerrain)
	{
		SAFE_DELETE(m_pTerrain);
	}

	SAFE_DELETE_ARRAY(m_pHeightMap);

	return CAtumNode::DeleteDeviceObjects();
}

void CBackground::Render()//D3DXVECTOR3 vPos,D3DXVECTOR3 vAt)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();


	D3DXVECTOR3 vPos,vAt,vLookatVel;
//	vPos = pView->m_pCamera->GetEyePt();
	vPos = pView->m_pCamera->GetLookatPt();
	D3DXMATRIX mat;
	D3DXMatrixIdentity(&mat);
	int i,j;
	int temp = (int)(vPos.y / 30.0f);
	if(temp < 5)
		temp = 4;
	temp = 32;
	int tempx, tempz;

//	D3DXVec3Normalize(&vLookatVel,&pView->m_pCamera->GetViewDir());
//	vAt = vPos + temp*40.0f*vLookatVel;
	
//	tempx = (int)(vAt.x / m_fTileSize);
//	tempz = (int)(vAt.z / m_fTileSize);
	tempx = (int)(vPos.x / m_fTileSize);
	tempz = (int)(vPos.z / m_fTileSize);

	int max_x, max_z, min_x, min_z;
	
	if((tempx - temp) < 0)
		min_x = 0;
	else
		min_x = tempx -temp;

	if((tempz - temp) < 0)
		min_z = 0;
	else
		min_z = tempz - temp;

	if((tempx + temp) > m_sXSize)
		max_x = m_sXSize;
	else
		max_x = tempx + temp;

	if((tempz + temp) > m_sYSize)
		max_z = m_sYSize;
	else
		max_z = tempz + temp;

    D3DMATERIAL8 mtrl;
    D3DUtil_InitMaterial( mtrl, 1.0f, 1.0f, 1.0f );
    g_pD3dDev->SetMaterial( &mtrl );

//	for(i=0;i<32;i++)
//	{
//		for(j=0;j<32;j++)
//		{
//			if(tempx-16+i >=0 && tempx-16+i < m_sXSize && tempz-16+j >= 0 && tempz-16+j < m_sYSize)
//			{
//				g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
//				int k = (tempx-16+i)*m_sYSize+(tempz-16+j);
//          }
//      }
//   }


	if(!pView->m_bRoamLandView)
	{
		if (m_pTerrain) 
		{
			//		

			g_pD3dDev->SetRenderState( D3DRS_FILLMODE,   D3DFILL_SOLID );
			g_pD3dDev->SetRenderState( D3DRS_CULLMODE,   D3DCULL_CW );
			g_pD3dDev->SetVertexShader( D3DFVF_CUSTOMVERTEX );
			//dynamic roam  - render
			m_pTerrain->Render();	
		
		
		}
	}


		
	
	if(!pView->m_bLandView)
	{
	
//g_pD3dDev->SetRenderState( D3DRS_FILLMODE,   D3DFILL_SOLID );
		g_pD3dDev->SetRenderState( D3DRS_CULLMODE,   D3DCULL_CCW );
		
		for(i=0;i<64;i++)
		{
			for(j=0;j<64;j++)
			{
				if(tempx-32+i >=0 && tempx-32+i < m_sXSize && tempz-32+j >= 0 && tempz-32+j < m_sYSize)
				{
					g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
					int k = (tempx-32+i)*m_sYSize+(tempz-32+j);
					if( m_pBackTexture )
					{
						g_pD3dDev->SetTexture(0, m_pBackTexture );
					}
					else
					{
						g_pD3dDev->SetTexture( 0, m_pCreateTexture[m_pTileInfo[k].useTexNumber] );
					}
					g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
					g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
					g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
					g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
					///////////////// Evnet Set - RenderState  ////////////////////
					g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE,  TRUE );
					g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
					g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_INVSRCALPHA );
					///////////////// Event Set - ̺Ʈ     ǥ( 巡׵ ) ///////////////
					if((pView->m_bCheckEventSet && pView->m_bLButtonCheck && m_bUsingArray[k] )|| 
						(pView->m_bCheckMonsterSet && pView->m_bLButtonCheck && m_bUsingArray[k]) ||
						(pView->m_nCommand == 0 && pView->m_checkTilesetRegion && m_bUsingArray[k]))
					{
						g_pD3dDev->SetTexture( 0, m_pEventTexture[0] );
						g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
						g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
						g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
						g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
					}
					///////////////// Event Set - ̺Ʈ     ǥ(  ) ///////////////
					//////////////	1 .   ֱ /////////////////////////////
					if(pView->m_bCheckEventSet && pView->m_dlgEventSet.m_checkEventSetMode)
					{
						switch(pView->m_dlgEventSet.m_nCommandEvent)
						{
						case 0:
							{
								if(m_pEventInfo[k].m_bPKType==0)
								{
									g_pD3dDev->SetTexture( 0, m_pEventTexture[1] );
									g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
									g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
									g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
									g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
								}
								else if(m_pEventInfo[k].m_bPKType==1)
								{
									g_pD3dDev->SetTexture( 0, m_pEventTexture[2] );
									g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
									g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
									g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
									g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
								}
								else if(m_pEventInfo[k].m_bPKType==2)
								{
									g_pD3dDev->SetTexture( 0, m_pEventTexture[3] );
									g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
									g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
									g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
									g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
								}
							}
							break;
						case 1:
							{
								if(m_pEventInfo[k].m_bEnableLand==0)
								{
									g_pD3dDev->SetTexture( 0, m_pEventTexture[4] );
									g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
									g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
									g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
									g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
								}
								else if(m_pEventInfo[k].m_bEnableLand==1)
								{
									g_pD3dDev->SetTexture( 0, m_pEventTexture[5] );
									g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
									g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
									g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
									g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
								}
							}
							break;
						case 2:
							{
								int nTexNum = 6 + m_pEventInfo[k].m_bEnvetType;
								if(nTexNum > 9)
									nTexNum = 0;

								g_pD3dDev->SetTexture( 0, m_pEventTexture[nTexNum] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
							break;
						case 3:
							{
								if(m_pEventInfo[k].m_bMove==0)
								{
									g_pD3dDev->SetTexture( 0, m_pEventTexture[1] );
									g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
									g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
									g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
									g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
								}
								else if(m_pEventInfo[k].m_bMove==1)
								{
									g_pD3dDev->SetTexture( 0, m_pEventTexture[5] );
									g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
									g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
									g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
									g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
								}
								else if(m_pEventInfo[k].m_bMove==2)
								{
									g_pD3dDev->SetTexture( 0, m_pEventTexture[9] );
									g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
									g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
									g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
									g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
								}
							}
							break;
						}
					}
					//////////////////////// 2 .  View 忡 ֱ ////////////////////////
					else if(pView->m_bCheckEventSet && pView->m_dlgEventSet.m_checkEventViewMode)
					{
						if(pView->m_dlgEventSet.m_checkViewPCN)
						{
							if(m_pEventInfo[k].m_bPKType==0)
							{
								g_pD3dDev->SetTexture( 0, m_pEventTexture[1] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
							else if(m_pEventInfo[k].m_bPKType==1)
							{
								g_pD3dDev->SetTexture( 0, m_pEventTexture[2] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
							else if(m_pEventInfo[k].m_bPKType==2)
							{
								g_pD3dDev->SetTexture( 0, m_pEventTexture[3] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
						}
						if(pView->m_dlgEventSet.m_checkViewLand)
						{
							if(m_pEventInfo[k].m_bEnableLand==0)
							{
								g_pD3dDev->SetTexture( 0, m_pEventTexture[4] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
							else if(m_pEventInfo[k].m_bEnableLand==1)
							{
								g_pD3dDev->SetTexture( 0, m_pEventTexture[5] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
						}
						if(pView->m_dlgEventSet.m_checkViewWarf)
						{
							int nTexNum = 6 + m_pEventInfo[k].m_bEnvetType;
							if(nTexNum > 9)
								nTexNum = 0;

							g_pD3dDev->SetTexture( 0, m_pEventTexture[nTexNum] );
							g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
							g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
							g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
							g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
						}
						if(pView->m_dlgEventSet.m_checkViewMove)
						{
							if(m_pEventInfo[k].m_bMove==0)
							{
								g_pD3dDev->SetTexture( 0, m_pEventTexture[1] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
							else if(m_pEventInfo[k].m_bMove==1)
							{
								g_pD3dDev->SetTexture( 0, m_pEventTexture[5] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
							else if(m_pEventInfo[k].m_bMove==2)
							{
								g_pD3dDev->SetTexture( 0, m_pEventTexture[9] );
								g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
								g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
								g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
								g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
							}
						}
					}
					else if(pView->m_bCheckMonsterSet)
					{
						if(pView->m_dlgMonsterSet.m_bMonsterView && m_bUsingMonsterRegion[k])
						{
							g_pD3dDev->SetTexture( 0, m_pEventTexture[1] );
							g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
							g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
							g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
							g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
						}
						if(tempx-32+i >= pView->m_dlgMonsterSet.m_sMin_x && tempx-32+i < pView->m_dlgMonsterSet.m_sMax_x
							&& tempz-32+j >= pView->m_dlgMonsterSet.m_sMin_z && tempz-32+j < pView->m_dlgMonsterSet.m_sMax_z)
						{
							g_pD3dDev->SetTexture( 0, m_pEventTexture[2] );
							g_pD3dDev->SetVertexShader( D3DFVF_SPRITEVERTEX );
							g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
							g_pD3dDev->SetStreamSource( 0, m_pVBRender[i*64+j], sizeof(SPRITEVERTEX) );
							g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 2 );
						}
					}
				}
			}
			
	}
	///////////////// Flying View  -     ֱ ////////////////
	if(pView->m_bFlyingViewMax)
	{
		NOSPRITE* v2;
		m_pVBFlying->Lock( 0, 0, (BYTE**)&v2, 0 );
		v2[0].p.y = m_projectInfo.m_fHeightMax;		v2[0].color=0x99334AFD;
		v2[1].p.y = m_projectInfo.m_fHeightMax;		v2[1].color=0x99334AFD;
		v2[2].p.y = m_projectInfo.m_fHeightMax;		v2[2].color=0x99334AFD;
		v2[3].p.y = m_projectInfo.m_fHeightMax;		v2[3].color=0x99334AFD;
		m_pVBFlying->Unlock();

		g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );
		g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE,  TRUE );
		g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
		g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_DESTALPHA );
		D3DXMATRIX matFlying;
		D3DXMatrixIdentity(&matFlying);

		g_pD3dDev->SetTexture( 0, NULL );
		g_pD3dDev->SetVertexShader( D3DFVF_NOSPRITE );
		g_pD3dDev->SetTransform( D3DTS_WORLD, &matFlying );
		g_pD3dDev->SetStreamSource( 0, m_pVBFlying, sizeof(NOSPRITE) );
		g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );
	}
	if(pView->m_bFlyingViewMin)
	{
		NOSPRITE* v2;
		m_pVBFlying->Lock( 0, 0, (BYTE**)&v2, 0 );
		v2[0].p.y = m_projectInfo.m_fHeightMin;	v2[0].color=0x99FD4A33;	
		v2[1].p.y = m_projectInfo.m_fHeightMin;	v2[1].color=0x99FD4A33;	
		v2[2].p.y = m_projectInfo.m_fHeightMin;	v2[2].color=0x99FD4A33;
		v2[3].p.y = m_projectInfo.m_fHeightMin;	v2[3].color=0x99FD4A33;
		m_pVBFlying->Unlock();

		g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );
		g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE,  TRUE );
		g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
		g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_DESTALPHA );
		D3DXMATRIX matFlying;
		D3DXMatrixIdentity(&matFlying);

		g_pD3dDev->SetTexture( 0, NULL );
		g_pD3dDev->SetVertexShader( D3DFVF_NOSPRITE );
		g_pD3dDev->SetTransform( D3DTS_WORLD, &matFlying );
		g_pD3dDev->SetStreamSource( 0, m_pVBFlying, sizeof(NOSPRITE) );
		g_pD3dDev->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );
	}
	if(!pView->m_bLandView)
	{
		// Water
		g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE,  TRUE );
		g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
		g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_INVSRCALPHA );
		g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   TRUE );
		g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );
		g_pD3dDev->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1 );
		static int deside=1;
		bool bTextype = FALSE;
		m_fCheckWaterTexAniTime -= pView->GetElapsedTime();
		if(m_fCheckWaterTexAniTime<0.0f)
		{
			bTextype = TRUE;
			m_fCheckWaterTexAniTime = 0.1f;
		}
		m_fHeight += deside*pView->GetElapsedTime();
		if(m_fHeight < -5)
			deside = 1;
		else if(m_fHeight > 5)
			deside = -1;
		for(i=0;i<64;i++)
		{
			for(j=0;j<64;j++)
			{
				if(tempx-32+i >=0 && tempx-32+i+1 < m_sXSize && tempz-32+j >= 0 && tempz-32+j+1 < m_sYSize)
				{
					int k = (tempx-32+i)*m_sYSize+(tempz-32+j);
					if(m_pTileInfo[k].waterType)
					{
						if(bTextype)
						{
							m_pTileInfo[k].waterTexNumber++;
							if(m_pTileInfo[k].waterTexNumber > 9)
								m_pTileInfo[k].waterTexNumber = 0;
						}
						g_pD3dDev->SetTexture(0,m_pWaterTexture[m_pTileInfo[k].waterTexNumber]);
						g_pD3dDev->SetVertexShader(D3DFVF_SPRITEVERTEX);
						m_matWater._41 = 40.0f*(tempx-32+i+1);
						m_matWater._42 = m_pTileInfo[k].waterHeight+m_fHeight;
						m_matWater._43 = 40.0f*(tempz-32+j);
						g_pD3dDev->SetTransform(D3DTS_WORLD,&m_matWater);
						g_pD3dDev->SetStreamSource(0,m_pVBWater,sizeof(SPRITEVERTEX));
						g_pD3dDev->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
					}
				}
			}
		}
	}
	g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
	if(pView->m_bRenderLine)
	{
		g_pD3dDev->SetTexture( 0, NULL );
		g_pD3dDev->SetRenderState( D3DRS_LIGHTING, FALSE );
		g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   TRUE );
		g_pD3dDev->SetVertexShader( D3DFVF_LINEVERTEX );
		g_pD3dDev->SetTransform( D3DTS_WORLD, &mat );
		LINEVERTEX* pVertices=NULL;
		for(i=min_x;i<max_x;i++)
		{
			for(j=min_z;j<max_z;j++)
			{
				// by dhkwon 100816,  ()
				if(FAILED(m_pVBLine->Lock(0, 0, (BYTE**)&pVertices, NULL)))
					return ;
				pVertices[0].pos = m_pTileVertexArray[i*(m_sYSize+1)+(j)].pos;pVertices[0].color=GRID_COLOR_BLACK; 
				pVertices[1].pos = m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j)].pos;pVertices[1].color=GRID_COLOR_BLACK;
				pVertices[2].pos = m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos;pVertices[2].color=GRID_COLOR_BLACK;
				pVertices[3].pos = m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos;pVertices[3].color=GRID_COLOR_BLACK;
				pVertices[4].pos = m_pTileVertexArray[i*(m_sYSize+1)+(j)].pos;pVertices[4].color=GRID_COLOR_BLACK;
				
				m_pVBLine->Unlock();
				g_pD3dDev->SetStreamSource( 0, m_pVBLine, sizeof(LINEVERTEX) );
				g_pD3dDev->DrawPrimitive( D3DPT_LINESTRIP, 0, 4 );
//				if( pView->m_dwObjectType < pView->m_nObjectNormalCont )
//				{
//					//  Ÿϴ 
//					if(FAILED(m_pVBLine->Lock(0, 0, (BYTE**)&pVertices, NULL)))
//						return ;
//				
//					// 07-05-04 by shkim, ׷ û ׸ λ ü
//					pVertices[0].pos = m_pTileVertexArray[i*(m_sYSize+1)+(j)].pos;pVertices[0].color=GRID_COLOR_RED;
//					pVertices[1].pos = m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j)].pos;pVertices[1].color=GRID_COLOR_RED;
//					pVertices[2].pos = m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos;pVertices[2].color=GRID_COLOR_RED;
//					pVertices[3].pos = m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos;pVertices[3].color=GRID_COLOR_RED;
//					pVertices[4].pos = m_pTileVertexArray[i*(m_sYSize+1)+(j)].pos;pVertices[4].color=GRID_COLOR_RED;
//					
//					m_pVBLine->Unlock();
//					g_pD3dDev->SetStreamSource( 0, m_pVBLine, sizeof(LINEVERTEX) );
//					g_pD3dDev->DrawPrimitive( D3DPT_LINESTRIP, 0, 4 );
//				}
//				else
//				{
//					// Ǫ  
//					if(FAILED(m_pVBLine->Lock(0, 0, (BYTE**)&pVertices, NULL)))
//						return ;
//					pVertices[0].pos = m_pBlockVertexArray[(2*i)*(2*m_sYSize+1)+(2*j)].pos;pVertices[0].color=GRID_COLOR_BLUE; 
//					pVertices[1].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j)].pos;pVertices[1].color=GRID_COLOR_BLUE;
//					pVertices[2].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[2].color=GRID_COLOR_BLUE; 
//					pVertices[3].pos = m_pBlockVertexArray[(2*i)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[3].color=GRID_COLOR_BLUE; 
//					pVertices[4].pos = m_pBlockVertexArray[(2*i)*(2*m_sYSize+1)+(2*j)].pos;pVertices[4].color=GRID_COLOR_BLUE; 
//					m_pVBLine->Unlock();
//					g_pD3dDev->SetStreamSource( 0, m_pVBLine, sizeof(LINEVERTEX) );
//					g_pD3dDev->DrawPrimitive( D3DPT_LINESTRIP, 0, 4 );
//					if(FAILED(m_pVBLine->Lock(0, 0, (BYTE**)&pVertices, NULL)))
//						return ;
//					pVertices[0].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j)].pos;pVertices[0].color=GRID_COLOR_BLUE; 
//					pVertices[1].pos = m_pBlockVertexArray[(2*i+2)*(2*m_sYSize+1)+(2*j)].pos;pVertices[1].color=GRID_COLOR_BLUE;
//					pVertices[2].pos = m_pBlockVertexArray[(2*i+2)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[2].color=GRID_COLOR_BLUE; 
//					pVertices[3].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[3].color=GRID_COLOR_BLUE; 
//					pVertices[4].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j)].pos;pVertices[4].color=GRID_COLOR_BLUE; 
//					m_pVBLine->Unlock();
//					g_pD3dDev->SetStreamSource( 0, m_pVBLine, sizeof(LINEVERTEX) );
//					g_pD3dDev->DrawPrimitive( D3DPT_LINESTRIP, 0, 4 );
//					if(FAILED(m_pVBLine->Lock(0, 0, (BYTE**)&pVertices, NULL)))
//						return ;
//					pVertices[0].pos = m_pBlockVertexArray[(2*i)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[0].color=GRID_COLOR_BLUE; 
//					pVertices[1].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[1].color=GRID_COLOR_BLUE;
//					pVertices[2].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j+2)].pos;pVertices[2].color=GRID_COLOR_BLUE; 
//					pVertices[3].pos = m_pBlockVertexArray[(2*i)*(2*m_sYSize+1)+(2*j+2)].pos;pVertices[3].color=GRID_COLOR_BLUE; 
//					pVertices[4].pos = m_pBlockVertexArray[(2*i)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[4].color=GRID_COLOR_BLUE; 
//					m_pVBLine->Unlock();
//					g_pD3dDev->SetStreamSource( 0, m_pVBLine, sizeof(LINEVERTEX) );
//					g_pD3dDev->DrawPrimitive( D3DPT_LINESTRIP, 0, 4 );
//					if(FAILED(m_pVBLine->Lock(0, 0, (BYTE**)&pVertices, NULL)))
//						return ;
//					pVertices[0].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[0].color=GRID_COLOR_BLUE; 
//					pVertices[1].pos = m_pBlockVertexArray[(2*i+2)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[1].color=GRID_COLOR_BLUE;
//					pVertices[2].pos = m_pBlockVertexArray[(2*i+2)*(2*m_sYSize+1)+(2*j+2)].pos;pVertices[2].color=GRID_COLOR_BLUE; 
//					pVertices[3].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j+2)].pos;pVertices[3].color=GRID_COLOR_BLUE; 
//					pVertices[4].pos = m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+(2*j+1)].pos;pVertices[4].color=GRID_COLOR_BLUE; 
//					m_pVBLine->Unlock();
//					g_pD3dDev->SetStreamSource( 0, m_pVBLine, sizeof(LINEVERTEX) );
//					g_pD3dDev->DrawPrimitive( D3DPT_LINESTRIP, 0, 4 );
//				}
			}
		}
	}

	if(pView->m_bAllObjectRender)
	{//  Ʈ Ѵ.
		for(i=0;i<m_sXSize;i++)
		{
			for(j=0;j<m_sYSize;j++)
			{
				int nIndex = i*1000 + j;
				map<INT, CAtumNode *>::iterator it = m_mapObjectData.find(nIndex);
				if(it != m_mapObjectData.end())
				{
					((CAtumNode *)it->second)->Render();
				}
			}
		}
	}
	else if(pView->m_bAllObjectNotRender)
	{// ƹ͵   ʴ´.
	}
	else
	{
		D3DXVECTOR3 vLookat;
		D3DXVec3Normalize(&vLookat,&pView->m_pCamera->GetViewDir());
//		vLookat = pView->m_pCamera->GetEyePt() + 32*40.0f*vLookat;
		vLookat = pView->m_pCamera->GetLookatPt();
		int nIndex;
		int xi = (int)(vLookat.x/40.0f);
		int zi = (int)(vLookat.z/40.0f);
		for(i=xi-32;i<xi+32;i++)
		{
			for(j=zi-32;j<zi+32;j++)
			{
				if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
				{
					nIndex = i*1000 + j;
					map<INT, CAtumNode *>::iterator it = m_mapObjectData.find(nIndex);
					if(it != m_mapObjectData.end())
					{
						((CAtumNode *)it->second)->Render();
					}
				}
			}
		}
	}

	// Ʈ  ϸ Ʈ  ִ 
	if(pView->m_nCommand == 3 && !pView->m_bCheckObject)
	{		
 		D3DXVECTOR3 vPickRayOrig;
		D3DXVECTOR3 vPickRayDir;
		CalculatePickPostion( &vPickRayOrig, &vPickRayDir ); //07-05-11 by shkim, ŷ 

		FLOAT fU = 0.0f, fV = 0.0f;
		FLOAT fDist = 0.0f;
		D3DXVECTOR3 V( 0.0f, 0.0f, 0.0f );

		for(i=0;i<64;i++)
		{
			for(j=0;j<64;j++)
			{
				if(tempx-32+i >=0 && tempx-32+i+1 < m_sXSize && tempz-32+j >= 0 && tempz-32+j+1 < m_sYSize)
				{
					
					if(IntersectTriangle( vPickRayOrig,
										  vPickRayDir,
										  m_pTileVertexArray[(tempx-32+i)*(m_sYSize+1)+tempz-32+j].pos,
										  m_pTileVertexArray[(tempx-32+i)*(m_sYSize+1)+(tempz-32+j+1)].pos,
										  m_pTileVertexArray[(tempx-32+i+1)*(m_sYSize+1)+(tempz-32+j+1)].pos,
										  &fDist, &fU, &fV ) )
					{
						V = vPickRayOrig + vPickRayDir*fDist;
						
						pView->m_pObject->RenderPreView(V);
					}

					if(IntersectTriangle( vPickRayOrig,
										  vPickRayDir,
										  m_pTileVertexArray[(tempx-32+i)*(m_sYSize+1)+tempz-32+j].pos,
										  m_pTileVertexArray[(tempx-32+i+1)*(m_sYSize+1)+(tempz-32+j+1)].pos,
										  m_pTileVertexArray[(tempx-32+i+1)*(m_sYSize+1)+tempz-32+j].pos,
										  &fDist, &fU, &fV ) )
					{
						V = vPickRayOrig + vPickRayDir*fDist;

						pView->m_pObject->RenderPreView(V);
					}
				}
			}
		}
	}

}


	// 07-05-07 by shkim, ̰ Ⱥ̰ üŷ
	if( m_bPickCheck )
	{
		DrawBrush( m_vPickPos ); // 07-05-07 by shkim, draw  brush
	}
}

int CBackground::TextureCreate(LPDIRECT3DTEXTURE8 ptex1,LPDIRECT3DTEXTURE8 ptex2,int a)
{
	if(!ptex1 || !ptex2)
		return -1;
    D3DLOCKED_RECT d3dlr,d3dlr1,d3dlr2;
	for(int i=0;i<m_nCreateTexNumber;i++)
	{
		if(m_pTileInfo[a].bBaseTile)
		{
			if( m_pTexFileInfo[i].bBaseTile)
			{
				if(m_pTileInfo[a].texTileDirect1 == m_pTexFileInfo[i].texTileDirect1 
					&& m_pTileInfo[a].texTileDirect2 == m_pTexFileInfo[i].texTileDirect2
					&& m_pTileInfo[a].texTileDirect3 == m_pTexFileInfo[i].texTileDirect3 
					&& m_pTileInfo[a].texTileDirect4 == m_pTexFileInfo[i].texTileDirect4
					&& m_pTileInfo[a].useBaseTexNumber == m_pTexFileInfo[i].useBaseTexNumber
					&& m_pTileInfo[a].ranTexNumber == m_pTexFileInfo[i].ranTexNumber)
					return i;
			}
		}
		else
		{
			if(m_pTileInfo[a].texTileDirect1 == m_pTexFileInfo[i].texTileDirect1 
				&& m_pTileInfo[a].texTileDirect2 == m_pTexFileInfo[i].texTileDirect2
				&& m_pTileInfo[a].texTileDirect3 == m_pTexFileInfo[i].texTileDirect3 
				&& m_pTileInfo[a].texTileDirect4 == m_pTexFileInfo[i].texTileDirect4)
				return i;
		}
	}
	m_pTexFileInfo[m_nCreateTexNumber].texTileDirect1 = m_pTileInfo[a].texTileDirect1;
	m_pTexFileInfo[m_nCreateTexNumber].texTileDirect2 = m_pTileInfo[a].texTileDirect2;
	m_pTexFileInfo[m_nCreateTexNumber].texTileDirect3 = m_pTileInfo[a].texTileDirect3;
	m_pTexFileInfo[m_nCreateTexNumber].texTileDirect4 = m_pTileInfo[a].texTileDirect4;
	if(m_pTileInfo[a].bBaseTile)
	{
		m_pTexFileInfo[m_nCreateTexNumber].bBaseTile = m_pTileInfo[a].bBaseTile;
		m_pTexFileInfo[m_nCreateTexNumber].useBaseTexNumber = m_pTileInfo[a].useBaseTexNumber;
		m_pTexFileInfo[m_nCreateTexNumber].ranTexNumber = m_pTileInfo[a].ranTexNumber;
	}
	char buf[20];
	strcpy(buf,"Maptile_dummy.tga");
	if( FAILED( D3DUtil_CreateTexture( g_pD3dDev,buf, &m_pCreateTexture[m_nCreateTexNumber] ) ) )
		return E_FAIL;

	m_pCreateTexture[m_nCreateTexNumber]->LockRect( 0, &d3dlr, 0, 0 );
	ptex1->LockRect( 0, &d3dlr1, 0, 0 );
	ptex2->LockRect( 0, &d3dlr2, 0, 0 );

	DWORD* pDstRow = (DWORD*)d3dlr.pBits;
	DWORD* pDstRow1 = (DWORD*)d3dlr1.pBits;
	DWORD* pDstRow2 = (DWORD*)d3dlr2.pBits;
	DWORD* pDst16,*pSrc1,*pSrc2;
	DWORD bAlpha; // 4-bit measure of pixel intensity
	BYTE bRed1,bGreen1, bBlue1;
	BYTE bRed2,bGreen2, bBlue2;
	pDst16 = (DWORD*)pDstRow;
	pSrc1 = (DWORD*)pDstRow1;
	pSrc2 = (DWORD*)pDstRow2;

	for(int y=0; y < 128; y++ )
	{
		for(int x=0; x < 128; x++ )
		{
			bAlpha =  (DWORD)((*pSrc2)  >> 24);
			DbgOut("%x",bAlpha);
			if(bAlpha == 0)
			{
				*pDst16 = (DWORD)((*pSrc1));// | 0xff000000);
			}
			else if(bAlpha == 255)
			{
				*pDst16 = (DWORD)((*pSrc2));// | 0xff000000);
			}
			else// if(bAlpha > 0)
			{
				bRed2 = (BYTE)(*pSrc2  >> 16);
				bGreen2 = (BYTE)(*pSrc2  >> 8);
				bBlue2 = (BYTE)(*pSrc2);
				bRed2 = bRed2 * bAlpha / 255;
				bGreen2 = bGreen2 * bAlpha / 255;
				bBlue2 = bBlue2 * bAlpha / 255;

				bRed1 = (BYTE)(*pSrc1  >> 16);
				bGreen1 = (BYTE)(*pSrc1  >> 8);
				bBlue1 = (BYTE)(*pSrc1);
				bRed1 = bRed1 * (255-bAlpha) / 255;
				bGreen1 = bGreen1 * (255-bAlpha) / 255;
				bBlue1 = bBlue1 * (255-bAlpha) / 255;

				*pDst16 = D3DCOLOR_ARGB(0x00,bRed1,bGreen1,bBlue1) + D3DCOLOR_ARGB(0xFF,bRed2,bGreen2,bBlue2);
			}
			pSrc1++;
			pSrc2++;
			pDst16++;
		}
		DbgOut("\n");
	}
	// Done updating texture, so clean up used objects
	ptex2->UnlockRect(0);
	ptex1->UnlockRect(0);
	m_pCreateTexture[m_nCreateTexNumber]->UnlockRect(0);
	wsprintf(buf,"05%06d",m_nCreateTexNumber);
	strcpy(m_pTexFileInfo[m_nCreateTexNumber].name,buf);
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	char strpathtexture[256];
	_chdir(pView->m_strCurrentDir);
	char bufDirName[256];
	wsprintf( bufDirName,".\\Tile\\%d\\128",m_projectInfo.m_useTileSetIndex);
	_mkdir( bufDirName );
	_chdir(pView->m_strCurrentDir);
	wsprintf(strpathtexture,".\\Tile\\%d\\128\\%s.bmp",m_projectInfo.m_useTileSetIndex,buf);
	if( FAILED(D3DXSaveTextureToFile(strpathtexture,D3DXIFF_BMP,m_pCreateTexture[m_nCreateTexNumber],
		NULL)))
		return E_FAIL;
	
	ResizeTexture(m_pCreateTexture[m_nCreateTexNumber], buf, 128);

	CFile WriteTexDataFile;
	TEXFILEINFO info;
	int usetex;
	memcpy(&info,&m_pTexFileInfo[m_nCreateTexNumber],sizeof(info));

	char strpath[256];
	_chdir(pView->m_strCurrentDir);
	wsprintf(strpath,".\\Tile\\%d\\Texdata.mtd",m_projectInfo.m_useTileSetIndex);
	if(WriteTexDataFile.Open(strpath, CFile::modeReadWrite))
	{
		WriteTexDataFile.Seek(20,CFile::begin);
		WriteTexDataFile.Read(&usetex,sizeof(int));
		usetex++;
		WriteTexDataFile.Seek(20,CFile::begin);
		WriteTexDataFile.Write(&usetex,sizeof(int));
		WriteTexDataFile.SeekToEnd();
		WriteTexDataFile.Write(&info,sizeof(info));

		WriteTexDataFile.Close();
	}
	else
	{
		if(WriteTexDataFile.Open(strpath,CFile::modeCreate | CFile::modeReadWrite))
		{
			WriteTexDataFile.Seek(20,CFile::begin);
			usetex=1;
			WriteTexDataFile.Write(&usetex,sizeof(int));
			WriteTexDataFile.SeekToEnd();
			WriteTexDataFile.Write(&info,sizeof(info));
			WriteTexDataFile.Close();
		}
	}

	m_nCreateTexNumber++;
	
	return m_nCreateTexNumber-1;
}

void CBackground::ResizeTexture(LPDIRECT3DTEXTURE8 pTexture, char *szFilename, int nSize)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	char strpathtexture[256];
	D3DLOCKED_RECT d3dlr,d3dlr1;
	LPDIRECT3DTEXTURE8 tempTex64;
	LPDIRECT3DTEXTURE8 tempTex32;
	BYTE bRed,bGreen, bBlue;
	DWORD bR,bG,bB;
	char buf[128];
	wsprintf(buf,"mappicture%d.tga", nSize / 2);
	D3DUtil_CreateTexture( g_pD3dDev,buf, &tempTex64 ) ;
	tempTex64->LockRect( 0, &d3dlr, 0, 0 );
	pTexture->LockRect( 0, &d3dlr1, 0, 0 );
	DWORD* pDstRow = (DWORD*)d3dlr.pBits;
	DWORD* pDstRow1 = (DWORD*)d3dlr1.pBits;
	DWORD* pDst,*pSrc;
	pDst = (DWORD*)pDstRow;
	pSrc = (DWORD*)pDstRow1;
	int x,y;
	for(x=0; x < nSize / 2; x++ )
	{
		for(y=0; y < nSize/ 2; y++ )
		{
			pSrc = (DWORD*)pDstRow1;
			pSrc += nSize*2*x + y*2;
			bR = (BYTE)(*pSrc  >> 16);
			bG = (BYTE)(*pSrc  >> 8);
			bB = (BYTE)(*pSrc);
			pSrc++;
			bR += (BYTE)(*pSrc  >> 16);
			bG += (BYTE)(*pSrc  >> 8);
			bB += (BYTE)(*pSrc);
			pSrc += nSize - 1;
			bR += (BYTE)(*pSrc  >> 16);
			bG += (BYTE)(*pSrc  >> 8);
			bB += (BYTE)(*pSrc);
			pSrc++;
			bR += (BYTE)(*pSrc  >> 16);
			bG += (BYTE)(*pSrc  >> 8);
			bB += (BYTE)(*pSrc);

			bRed = bR/4;
			bGreen = bG/4;
			bBlue = bB/4;
			
			*pDst = D3DCOLOR_ARGB(0xFF,bRed,bGreen,bBlue);
			pDst++;
		}
	}
	tempTex64->UnlockRect( 0 );
	pTexture->UnlockRect( 0 );
	wsprintf(buf,"05%06d",m_nCreateTexNumber);
	char bufDirName[256];
	wsprintf( bufDirName,".\\Tile\\%d\\%d",m_projectInfo.m_useTileSetIndex, nSize/2);
	_mkdir( bufDirName );
	_chdir(pView->m_strCurrentDir);
	wsprintf(strpathtexture,".\\Tile\\%d\\%d\\%s.bmp",m_projectInfo.m_useTileSetIndex,nSize/2,buf);
	D3DXSaveTextureToFile(strpathtexture,D3DXIFF_BMP,tempTex64,NULL);

	wsprintf(buf,"mappicture%d.tga",nSize/4);
	D3DUtil_CreateTexture( g_pD3dDev,buf, &tempTex32 ) ;
	tempTex32->LockRect( 0, &d3dlr, 0, 0 );
	tempTex64->LockRect( 0, &d3dlr1, 0, 0 );
	pDstRow = (DWORD*)d3dlr.pBits;
	pDstRow1 = (DWORD*)d3dlr1.pBits;
	pDst = (DWORD*)pDstRow;
	pSrc = (DWORD*)pDstRow1;
	for(x=0; x < nSize/4; x++ )
	{
		for(y=0; y < nSize/4; y++ )
		{
			pSrc = (DWORD*)pDstRow1;
			pSrc += (nSize/2)*2*x + y*2;
			bR = (BYTE)(*pSrc  >> 16);
			bG = (BYTE)(*pSrc  >> 8);
			bB = (BYTE)(*pSrc);
			pSrc++;
			bR += (BYTE)(*pSrc  >> 16);
			bG += (BYTE)(*pSrc  >> 8);
			bB += (BYTE)(*pSrc);
			pSrc += nSize/2 - 1;
			bR += (BYTE)(*pSrc  >> 16);
			bG += (BYTE)(*pSrc  >> 8);
			bB += (BYTE)(*pSrc);
			pSrc++;
			bR += (BYTE)(*pSrc  >> 16);
			bG += (BYTE)(*pSrc  >> 8);
			bB += (BYTE)(*pSrc);

			bRed = bR/4;
			bGreen = bG/4;
			bBlue = bB/4;
			
			*pDst = D3DCOLOR_ARGB(0xFF,bRed,bGreen,bBlue);
			pDst++;
		}
	}
	tempTex32->UnlockRect( 0 );
	tempTex64->UnlockRect( 0 );
	wsprintf(buf,"05%06d",m_nCreateTexNumber);
	wsprintf( bufDirName,".\\Tile\\%d\\%d",m_projectInfo.m_useTileSetIndex,nSize/4);
	_mkdir( bufDirName );
	_chdir(pView->m_strCurrentDir);
	wsprintf(strpathtexture,".\\Tile\\%d\\%d\\%s.bmp",m_projectInfo.m_useTileSetIndex,nSize/4,buf);
	D3DXSaveTextureToFile(strpathtexture,D3DXIFF_BMP,tempTex32,NULL);
	SAFE_RELEASE(tempTex32);
	SAFE_RELEASE(tempTex64);

}

void CBackground::setMultiTex(int x, int z,int cho)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	int temp;
	int tempTileType1,tempTileType2,tempTileType3,tempTileType4;
	temp = x+z;
	int nChoose = cho;

	tempTileType1 = m_pTileInfo[temp].texTileDirect1;
	tempTileType2 = m_pTileInfo[temp].texTileDirect2;
	tempTileType3 = m_pTileInfo[temp].texTileDirect3;
	tempTileType4 = m_pTileInfo[temp].texTileDirect4;
	int num, ranTex;

	num = m_pTileInfo[temp].useTexNumber;
	char buf[256];
	wsprintf(buf,"Texture is not set. Carefully press the Ѥ++ keys.\n If the problem persists, please contact the developer.");
	if(nChoose==1)
	{
		if(tempTileType1==tempTileType2)
		{
			if(tempTileType1==tempTileType4)
			{
				if(tempTileType4==tempTileType3)
				{
					if(tempTileType1!=-1)
					{
					// 1 õ Ÿ ؽķ 00  Ÿ Ÿ 
//						ranTex = rand()%10;
						ranTex = rand()%BASETILE_CENTER_NUM;
						m_pTileInfo[temp].bBaseTile = TRUE;
						m_pTileInfo[temp].useBaseTexNumber = tempTileType1;
						m_pTileInfo[temp].ranTexNumber = ranTex;
						num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect1][0+ranTex],temp);
						if(num == -1)
							AfxMessageBox(buf,IDOK);
						m_pTileInfo[temp].useTexNumber = num;
					}
					else
						m_pTileInfo[temp].bBaseTile = TRUE;
				}
				else
				{
					if(tempTileType1 != -1)
					{
						m_pTileInfo[temp].bBaseTile = FALSE;
						num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect1][BASETILE_CENTER_NUM + 8],temp);
						if(num == -1)
							AfxMessageBox(buf,IDOK);
						m_pTileInfo[temp].useTexNumber = num;
					}
					else
					{
						m_pTileInfo[temp].useTexNumber = num;
					}
				}
			}
			else if(tempTileType2==tempTileType3)
			{
				if(tempTileType1 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect1][BASETILE_CENTER_NUM + 9],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
			else
			{
				if(tempTileType1 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect1][BASETILE_CENTER_NUM + 4],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
		}
		else if(tempTileType1==tempTileType4)
		{
			if(tempTileType4==tempTileType3)
			{
				if(tempTileType1 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect1][BASETILE_CENTER_NUM + 11],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
			else
			{
				if(tempTileType1 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect1][BASETILE_CENTER_NUM + 7],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
		}
		else
		{
			if(tempTileType1 != -1)
			{
				m_pTileInfo[temp].bBaseTile = FALSE;
				num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect1][BASETILE_CENTER_NUM + 0],temp);
				if(num == -1)
					AfxMessageBox(buf,IDOK);
				m_pTileInfo[temp].useTexNumber = num;
			}
			else
			{
				m_pTileInfo[temp].useTexNumber = num;
			}
		}
	}
	else if(nChoose==2)
	{
		if(tempTileType2==tempTileType3)
		{
			if(tempTileType2==tempTileType1)
			{
				if(tempTileType1==tempTileType4)
				{
					if(tempTileType2!=-1)
					{
					// 1 õ Ÿ ؽķ 00  Ÿ Ÿ 
//						ranTex = rand()%10;
						ranTex = rand()%BASETILE_CENTER_NUM;
						m_pTileInfo[temp].bBaseTile = TRUE;
						m_pTileInfo[temp].useBaseTexNumber = tempTileType1;
						m_pTileInfo[temp].ranTexNumber = ranTex;
						num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect2][0+ranTex],temp);
						if(num == -1)
							AfxMessageBox(buf,IDOK);
						m_pTileInfo[temp].useTexNumber = num;
					}
					else
						m_pTileInfo[temp].bBaseTile = TRUE;
				}
				else
				{
					if(tempTileType2 != -1)
					{
						m_pTileInfo[temp].bBaseTile = FALSE;
						num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect2][BASETILE_CENTER_NUM + 9],temp);
						if(num == -1)
							AfxMessageBox(buf,IDOK);
						m_pTileInfo[temp].useTexNumber = num;
					}
					else
					{
						m_pTileInfo[temp].useTexNumber = num;
					}
				}
			}
			else if(tempTileType3==tempTileType4)
			{
				if(tempTileType2 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect2][BASETILE_CENTER_NUM + 10],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
			else
			{
				if(tempTileType2 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect2][BASETILE_CENTER_NUM + 5],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
		}
		else if(tempTileType2==tempTileType1)
		{
			if(tempTileType1==tempTileType4)
			{
				if(tempTileType2 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect2][BASETILE_CENTER_NUM + 8],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
			else
			{
				if(tempTileType2 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect2][BASETILE_CENTER_NUM + 4],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
		}
		else
		{
			if(tempTileType2 != -1)
			{
				m_pTileInfo[temp].bBaseTile = FALSE;
				num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect2][BASETILE_CENTER_NUM + 1],temp);
				if(num == -1)
					AfxMessageBox(buf,IDOK);
				m_pTileInfo[temp].useTexNumber = num;
			}
			else
			{
				m_pTileInfo[temp].useTexNumber = num;
			}
		}
	}
	else if(nChoose==3)
	{
		if(tempTileType3==tempTileType4)
		{
			if(tempTileType3==tempTileType2)
			{
				if(tempTileType2==tempTileType1)
				{
					if(tempTileType3!=-1)
					{
					// 1 õ Ÿ ؽķ 00  Ÿ Ÿ 
//						ranTex = rand()%10;
						ranTex = rand()%BASETILE_CENTER_NUM;
						m_pTileInfo[temp].bBaseTile = TRUE;
						m_pTileInfo[temp].useBaseTexNumber = tempTileType1;
						m_pTileInfo[temp].ranTexNumber = ranTex;
						num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect3][0+ranTex],temp);
						if(num == -1)
							AfxMessageBox(buf,IDOK);
						m_pTileInfo[temp].useTexNumber = num;
					}
					else
						m_pTileInfo[temp].bBaseTile = TRUE;
				}
				else
				{
					if(tempTileType3 != -1)
					{
						m_pTileInfo[temp].bBaseTile = FALSE;
						num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect3][BASETILE_CENTER_NUM + 10],temp);
						if(num == -1)
							AfxMessageBox(buf,IDOK);
						m_pTileInfo[temp].useTexNumber = num;
					}
					else
					{
						m_pTileInfo[temp].useTexNumber = num;
					}
				}
			}
			else if(tempTileType4==tempTileType1)
			{
				if(tempTileType3 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect3][BASETILE_CENTER_NUM + 11],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
			else
			{
				if(tempTileType3 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect3][BASETILE_CENTER_NUM + 6],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
		}
		else if(tempTileType3==tempTileType2)
		{
			if(tempTileType2==tempTileType1)
			{
				if(tempTileType3 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect3][BASETILE_CENTER_NUM + 9],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
			else
			{
				if(tempTileType3 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect3][BASETILE_CENTER_NUM + 5],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
		}
		else
		{
			if(tempTileType3 != -1)
			{
				m_pTileInfo[temp].bBaseTile = FALSE;
				num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect3][BASETILE_CENTER_NUM + 2],temp);
				if(num == -1)
					AfxMessageBox(buf,IDOK);
				m_pTileInfo[temp].useTexNumber = num;
			}
			else
			{
				m_pTileInfo[temp].useTexNumber = num;
			}
		}
	}
	else
	{
		if(tempTileType4==tempTileType1)
		{
			if(tempTileType4==tempTileType3)
			{
				if(tempTileType3==tempTileType2)
				{
					if(tempTileType4!=-1)
					{
					// 1 õ Ÿ ؽķ 00  Ÿ Ÿ 
//						ranTex = rand()%10;
						ranTex = rand()%BASETILE_CENTER_NUM;
						m_pTileInfo[temp].bBaseTile = TRUE;
						m_pTileInfo[temp].useBaseTexNumber = tempTileType1;
						m_pTileInfo[temp].ranTexNumber = ranTex;
						num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect4][0+ranTex],temp);
						if(num == -1)
							AfxMessageBox(buf,IDOK);
						m_pTileInfo[temp].useTexNumber = num;
					}
					else
						m_pTileInfo[temp].bBaseTile = TRUE;
				}
				else
				{
					if(tempTileType4 != -1)
					{
						m_pTileInfo[temp].bBaseTile = FALSE;
						num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect4][BASETILE_CENTER_NUM + 11],temp);
						if(num == -1)
							AfxMessageBox(buf,IDOK);
						m_pTileInfo[temp].useTexNumber = num;
					}
					else
					{
						m_pTileInfo[temp].useTexNumber = num;
					}
				}
			}
			else if(tempTileType1==tempTileType2)
			{
				if(tempTileType4 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect4][BASETILE_CENTER_NUM + 8],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
			else
			{
				if(tempTileType4 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect4][BASETILE_CENTER_NUM + 7],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
		}
		else if(tempTileType4==tempTileType3)
		{
			if(tempTileType3==tempTileType2)
			{
				if(tempTileType4 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect4][BASETILE_CENTER_NUM + 10],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
			else
			{
				if(tempTileType4 != -1)
				{
					m_pTileInfo[temp].bBaseTile = FALSE;
					num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect4][BASETILE_CENTER_NUM + 6],temp);
					if(num == -1)
						AfxMessageBox(buf,IDOK);
					m_pTileInfo[temp].useTexNumber = num;
				}
				else
				{
					m_pTileInfo[temp].useTexNumber = num;
				}
			}
		}
		else
		{
			if(tempTileType4 != -1)
			{
				m_pTileInfo[temp].bBaseTile = FALSE;
				num = TextureCreate(m_pCreateTexture[m_pTileInfo[temp].useTexNumber],m_pTileTexture[m_pTileInfo[temp].texTileDirect4][BASETILE_CENTER_NUM + 3],temp);
				if(num == -1)
					AfxMessageBox(buf,IDOK);
				m_pTileInfo[temp].useTexNumber = num;
			}
			else
			{
				m_pTileInfo[temp].useTexNumber = num;
			}
		}
	}
}

void CBackground::Tick()
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();


	g_pFrustum->SetViewTransform(pView->m_pCamera->GetViewMatrix());

	float fElapsedTime = pView->GetElapsedTime();

	D3DXVECTOR3 vPos,vAt,vLookatVel;
//	vPos = pView->m_pCamera->GetEyePt();
	vPos = pView->m_pCamera->GetLookatPt();
	int i,j;

//	D3DXVec3Normalize(&vLookatVel,&pView->m_pCamera->GetViewDir());
//	vAt = vPos + 32*40.0f*vLookatVel;

	if (m_pTerrain)
	{
		// if dynamic roam then set the current transform to our frustum class
		// and update the tesselation
		//		Patch::frst.SetViewTransform(*SCamera::GetViewMatrix());
		m_pTerrain->Tesselate();
	}


	int xi,zi;
	xi = (int)(vPos.x / m_fTileSize);
	zi = (int)(vPos.z / m_fTileSize);
	int nIndex;
	for(i=xi-32;i<xi+32;i++)
	{
		for(j=zi-32;j<zi+32;j++)
		{
			if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
			{
				nIndex = i*1000 + j;
				map<INT, CAtumNode *>::iterator it = m_mapObjectData.find(nIndex);
				if(it != m_mapObjectData.end())
				{
					((CAtumNode *)it->second)->Tick();

					int cont = 0;
					CObjectChild * pObj = (CObjectChild *)it->second->m_pChild;
					while(pObj)
					{
						cont++;
						pObj = (CObjectChild *)pObj->m_pNext;
					}
					if(!cont)
					{
						SAFE_DELETE(it->second);
						m_mapObjectData.erase(it);
					}
				}
			}
		}
	}
	if(m_nObjectNumberOld != m_nObjectNumber)
	{
		pView->ResetObjectList();
		m_nObjectNumberOld = m_nObjectNumber;
	}

	// ü-κ, -  Ұ
	//  Ʈ  ѹ ǾҰ̴.
	// ü Ʈ    Tick  ǾѴ.
	// Ʈ  ϰ ȴ.
	list<EFFECTINFO>::iterator itEff = pView->m_listEffectInfo.begin();
	while(itEff != pView->m_listEffectInfo.end())
	{
		if(itEff->bRegion)
		{// ü Ʈ
			if(itEff->bLoop)
			{// ΰ(ѹ )
				if(itEff->fCheckTime > 0.0f)
					itEff->fCheckTime -= fElapsedTime;
				if(itEff->fCheckTime <= 0.0f && itEff->fCheckTime > -1000.0f)
				{// 
					itEff->fCheckTime = -1000.0f;
					CAppEffectData * pEffect = new CAppEffectData(itEff->nType,itEff->vPos);
					pView->m_pEffectList->AddChild(pEffect);
				}
			}
			else
			{// ΰ(ߵð )
				if(itEff->fCheckTime > 0.0f)
					itEff->fCheckTime -= fElapsedTime;
				if(itEff->fCheckTime <= 0.0f)
				{// 
					itEff->fCheckTime = itEff->fReTime;
					CAppEffectData * pEffect = new CAppEffectData(itEff->nType,itEff->vPos);
					pView->m_pEffectList->AddChild(pEffect);
				}
			}
		}
		else
		{// κ Ʈ
			int tempx = (int)(itEff->vPos.x/40.0f);
			int tempz = (int)(itEff->vPos.z/40.0f);
			if(tempx >= xi-32 && tempx < xi+32 && tempz >= zi-32 && tempz < zi+32)
			{//   ΰ
				if(itEff->bLoop)
				{// ΰ(ѹ )
					if(itEff->fCheckTime > 0.0f)
						itEff->fCheckTime -= fElapsedTime;
					if(itEff->fCheckTime <= 0.0f && itEff->fCheckTime > -1000.0f)
					{// 
						itEff->fCheckTime = -1000.0f;
						CAppEffectData * pEffect = new CAppEffectData(itEff->nType,itEff->vPos);
						pView->m_pEffectList->AddChild(pEffect);
					}
				}
				else
				{// ΰ(ߵð )
					if(itEff->fCheckTime > 0.0f)
						itEff->fCheckTime -= fElapsedTime;
					if(itEff->fCheckTime <= 0.0f)
					{// 
						itEff->fCheckTime = itEff->fReTime;
						CAppEffectData * pEffect = new CAppEffectData(itEff->nType,itEff->vPos);
						pView->m_pEffectList->AddChild(pEffect);
					}
				}
			}
		}
		itEff++;
	}


	
		
}


void CBackground::MouseAction(int action, const D3DXVECTOR3& orig, const D3DXVECTOR3& dir)// ,int nTileTextype)
{			
// 	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
// 	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
// 
// 	int tempX,tempZ;
// 	D3DXVECTOR3 vLookat;
// 	D3DXVec3Normalize(&vLookat,&pView->m_pCamera->GetViewDir());
// //	vLookat = pView->m_pCamera->GetEyePt() + 32*40.0f*vLookat;
// 	vLookat = pView->m_pCamera->GetLookatPt();
// 	int xi = (int)(vLookat.x/40.0f);
// 	int zi = (int)(vLookat.z/40.0f);
// 
// 	for(int i=xi-32;i<xi+32;i++)
// 	{
// 		for(int j=zi-32;j<zi+32;j++)
// 		{
// 			FLOAT fBary1, fBary2;
// 			FLOAT fDist;
// 			D3DXVECTOR3 v,v2;
// 			if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
// 			{
// 				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
// 					m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos,m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,
// 					&fDist, &fBary1, &fBary2 ))
// 				{
//					v = orig + dir * fDist;

// 					//  Ÿ ϱ  
// 					if(action == 0 && pView->m_checkTilesetRegion)
// 					{
// 						tempX = (int)(v.x/40.0f);
// 						tempZ = (int)(v.z/40.0f);
// 						SetTileRegion(tempX,tempZ);
// 
// 						char chTmp[256];
// 						sprintf(chTmp, " ׼  Ÿϼ() [X:%.2f],[Z:%.2f] \n", tempX, tempZ );
// 
// 						DBGOUT(" %s \n", chTmp);
// 
// 						return;
// 					}
// 					//  Ÿ ٲٱ
// 					int type = CheckTile1( m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
// 						                   m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos,
// 										   m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,v);
// 					if(type==0)
// 					{
// 						v2 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos;
// 					}
// 					else if(type==3)
// 					{
// 						v2 = m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos;
// 					}
// 					else
// 					{
// 						v2 = m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos;
// 					}
// 
// 					if(action == 0 && pView->m_checkTilesetPoint)
// 					{
// 						SetTilePoint(i, j,type);//, nTileTextype
// 					}
// 					else
// 					{
// 						Action(action, i, j, v,v2);//, nTileTextype
// 					}

//					return;
//				}

// 				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
// 					m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos,
// 					&fDist, &fBary1, &fBary2 ))
// 				{
// 					v = orig + dir*fDist;
// 					//  Ÿ ϱ  
// 					if(action == 0 && pView->m_checkTilesetRegion)
// 					{
// 						tempX = (int)(v.x/40.0f);
// 						tempZ = (int)(v.z/40.0f);
// 						SetTileRegion(tempX,tempZ);
// 
// 						char chTmp[256];
// 						sprintf(chTmp, " ׼  Ÿϼ() [X:%.2f],[Z:%.2f] \n", tempX, tempZ );
// 
// 						DBGOUT(" %s \n", chTmp);
// 						return;
// 					}

// 					int type = CheckTile2( m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
// 										   m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,
// 										   m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos,v );
// 					if(type==0)
// 					{
// 						v2 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos;
// 					}
// 					else if(type==2)
// 					{
// 						v2 = m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos;
// 					}
// 					else
// 					{
// 						v2 = m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos;
// 					}
// 
// 					if(action == 0 && pView->m_checkTilesetPoint)
// 					{
// 						SetTilePoint(i, j,type);//, nTileTextype
// 					}
// 					else
// 					{
// 						Action(action, i, j,v,v2);//,nTileTextype
//					}
//					return;
//				}
//			}
//		}
//	}

    //07-05-11 by shkim,   ü 
 	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
 	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	int nX = 0, nZ = 0;
	int nI = 0, nJ = 0;
	int nTriSeting = 0;
 	D3DXVECTOR3 vVec( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 vVTerrain( 0.0f, 0.0f, 0.0f );

 	BOOL bNearLengthCheck = NearPickCheck( orig, dir, &nTriSeting, &nI, &nJ );
 
 	if( bNearLengthCheck == TRUE ) // 07-05-10 by shkim,  
 	{
 		PickPos( &vVec ); // ŷ  ġ ˾ ´.
 
 		nX = (int)(vVec.x/40.0f);
 		nZ = (int)(vVec.z/40.0f);

		//  Ÿ ϱ  
		if(action == 0 && pView->m_checkTilesetRegion)
		{
			SetTileRegion( nX, nZ );

			char chTmp[256];
			sprintf(chTmp, " Action region of the Tile Set [X:%.2f],[Z:%.2f] \n", nX, nZ );
			DBGOUT(" %s \n", chTmp);
		}

		// 1 Ÿ üũ ->  Ÿ Ŭ ϰ  ã´.
		if( nTriSeting == LOW_TRIANGLE )//07-05-11 by shkim,  ﰢ
		{		
			int type = CheckTile1( m_pTileVertexArray[nI*(m_sYSize+1)+nJ].pos,
								   m_pTileVertexArray[nI*(m_sYSize+1)+(nJ+1)].pos,
								   m_pTileVertexArray[(nI+1)*(m_sYSize+1)+(nJ+1)].pos,
								   vVec );
			if(type == 0)
			{
				vVTerrain = m_pTileVertexArray[ nI * (m_sYSize + 1) + nJ].pos;
			}
			else if(type == 1 )
			{
				vVTerrain = m_pTileVertexArray[nI * (m_sYSize + 1) + (nJ + 1)].pos;
			}
			else // 2 
			{
				vVTerrain = m_pTileVertexArray[(nI + 1) * (m_sYSize + 1) + (nJ + 1)].pos;
			}

			if(action == 0 && pView->m_checkTilesetPoint)
			{
				SetTilePoint( nI, nJ, type);//, nTileTextype
			}
			else
			{
				Action(action, nI, nJ, m_vPickPos, vVTerrain);//, nTileTextype
			}
		}

		// 2 Ÿ üũ ->  Ÿ Ŭ ϰ  ã´.

		if( nTriSeting == HIGH_TRIANGLE ) //07-05-11 by shkim, Ʒ ﰢ
		{
			
			int type = CheckTile2( m_pTileVertexArray[nI*(m_sYSize+1)+nJ].pos,
								   m_pTileVertexArray[(nI+1)*(m_sYSize+1)+(nJ+1)].pos,
								   m_pTileVertexArray[(nI+1)*(m_sYSize+1)+nJ].pos,
								   vVec );
			if(type == 0)
			{
				vVTerrain = m_pTileVertexArray[nI * (m_sYSize + 1) + nJ].pos;
			}
			else if(type == 2)
			{
				vVTerrain = m_pTileVertexArray[(nI + 1) * (m_sYSize + 1)+(nJ + 1)].pos;
			}
			else // 3 
			{
				vVTerrain = m_pTileVertexArray[(nI + 1) * (m_sYSize + 1) + nJ].pos;
			}

			if(action == 0 && pView->m_checkTilesetPoint)
			{
				SetTilePoint(nI, nJ, type);//, nTileTextype
			}
			else
			{
				Action(action, nI, nJ, m_vPickPos, vVTerrain);//,nTileTextype
			}
		}
	}
 	
}

void CBackground::EventAction(CEventSetDlg *pDlg, const D3DXVECTOR3& orig, const D3DXVECTOR3& dir)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

// 	D3DXVECTOR3 vLookat;
// 	D3DXVec3Normalize(&vLookat,&pView->m_pCamera->GetViewDir());
// //	vLookat = pView->m_pCamera->GetEyePt() + 32*40.0f*vLookat;
// 	vLookat = pView->m_pCamera->GetLookatPt();
// 	int xi = (int)(vLookat.x/40.0f);
// 	int zi = (int)(vLookat.z/40.0f);
// 
// 	int tempX,tempZ;
// 
// 	for(int i=xi-32;i<xi+32;i++)
// 	{
// 		for(int j=zi-32;j<zi+32;j++)
// 		{
// 			FLOAT fBary1, fBary2;
// 			FLOAT fDist;
// 			D3DXVECTOR3 v,v2;
// 			if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
// 			{
// 				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
// 					m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos,m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,
// 					&fDist, &fBary1, &fBary2 ))
// 				{
// 					v = orig + dir*fDist;
// 					tempX = (int)(v.x/40.0f);
// 					tempZ = (int)(v.z/40.0f);
// 					if(pView->m_bRButtonCheck)
// 					{
// 						pView->m_bRButtonCheck = FALSE;
// 						SetEventInfo(tempX,tempZ);
// 					}
// 					else
// 						SetEvent(pDlg,tempX,tempZ);
// 					return;
// 				}
// 				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
// 					m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos,
// 					&fDist, &fBary1, &fBary2 ))
// 				{
// 					v = orig + dir*fDist;
// 					tempX = (int)(v.x/40.0f);
// 					tempZ = (int)(v.z/40.0f);
// 					if(pView->m_bRButtonCheck)
// 					{
// 						pView->m_bRButtonCheck = FALSE;
// 						SetEventInfo(tempX,tempZ);
// 					}
// 					else
// 						SetEvent(pDlg,tempX,tempZ);
// 					return;
// 				}
// 			}
// 		}
// 	}

	// 07-05-11 by shkim,   ( for κ Լȭ )
	int nX = 0, nZ = 0;
	D3DXVECTOR3 vVec( 0.0f, 0.0f, 0.0f );
	BOOL bNearLengthCheck = NearPickCheck( orig, dir );

	if( bNearLengthCheck == TRUE ) // 07-05-11 by shkim, ݺ Ż   .
	{
		PickPos( &vVec ); // ŷ  ġ ˾ ´.

//		char chTmp[256];
//		sprintf(chTmp, " PickPos  => [X:%.2f], [Y:%.2f], [Z:%.2f] \n", vVec.x, vVec.y, vVec.z );

//		DBGOUT(" %s \n", chTmp);

		nX = (int)(vVec.x/40.0f);
		nZ = (int)(vVec.z/40.0f);

 		if(pView->m_bRButtonCheck)
 		{
 			pView->m_bRButtonCheck = FALSE;
 			SetEventInfo( nX, nZ );
 		}
 		else
		{
 			SetEvent( pDlg, nX, nZ );
		}
	}
}

void CBackground::SetEventInfo(int i, int j)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	pView->m_dlgEventSet.m_editInfoEventType = m_pEventInfo[i*m_sYSize+j].m_bEnvetType;
	pView->m_dlgEventSet.m_editInfowParam1 = m_pEventInfo[i*m_sYSize+j].m_EventwParam1;
	pView->m_dlgEventSet.m_editInfowParam2 = m_pEventInfo[i*m_sYSize+j].m_EventwParam2;
	pView->m_dlgEventSet.m_editInfowParam3 = m_pEventInfo[i*m_sYSize+j].m_EventwParam3;
	pView->m_dlgEventSet.m_editInfostrParam = m_pEventInfo[i*m_sYSize+j].m_EventstrParam;
	switch(m_pEventInfo[i*m_sYSize+j].m_dwWaterType)
	{
	case 0:
		pView->m_dlgEventSet.m_editIsWater.Format("FALSE");
		break;
	case 1:
		pView->m_dlgEventSet.m_editIsWater.Format("Water[S/C]");
		break;
	case 2:
		pView->m_dlgEventSet.m_editIsWater.Format("Water[S]");
		break;
	case 3:
		pView->m_dlgEventSet.m_editIsWater.Format("Water[C]");
		break;

	}
//	if(m_pEventInfo[i*m_sYSize+j].m_bUseWater)
//		pView->m_dlgEventSet.m_editIsWater.Format("TRUE");
//	else
//		pView->m_dlgEventSet.m_editIsWater.Format("FALSE");
}
void CBackground::SetEvent(CEventSetDlg  *pDlg,int i, int j)
{
	static BOOL	bSetStartPos = TRUE;
	static int nStartX = 0;
	static int nStartZ = 0;
	static int nEndX = 0;
	static int nEndZ = 0;
	static int nOldStartX = 0;
	static int nOldStartZ = 0;
	static int nOldEndX = 0;
	static int nOldEndZ = 0;

	if(i<0)
		i=0;
	if(i>m_sXSize)
		i=m_sXSize-1;
	if(j<0)
		j=0;
	if(j>m_sYSize)
		j=m_sYSize-1;

	if(bSetStartPos)
	{
		nStartX = i;
		nStartZ = j;
		bSetStartPos = FALSE;
	}
	nEndX = i;
	nEndZ = j;

	int start_x,start_z;
	int end_x,end_z;
	
	if(nStartX > nEndX)
	{
		end_x = nStartX;
		start_x = nEndX;
	}
	else
	{
		start_x = nStartX;
		end_x = nEndX;
	}
	if(nStartZ > nEndZ)
	{
		end_z = nStartZ;
		start_z = nEndZ;
	}
	else
	{
		start_z = nStartZ;
		end_z = nEndZ;
	}

	int m,n;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	if(!pView->m_bLButtonCheck)
	{
		nEndX = i;
		nEndZ = j;
		bSetStartPos = TRUE;

		//  
		for(m = nOldStartX ; m < nOldEndX+1 ; m++)
		{
			for(n = nOldStartZ ; n < nOldEndZ+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = FALSE;
			}
		}

		switch(pDlg->m_nCommandEvent)
		{
		case 0:
			{
				for(m = start_x ; m < end_x+1 ; m++)
				{
					for(n = start_z ; n < end_z+1 ; n++)
					{
						if(pDlg->m_checkPK)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bPKType = 0;
						}
						else if(pDlg->m_checkCombat)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bPKType = 1;
						}
						else if(pDlg->m_checkNormal)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bPKType = 2;
						}
						m_bUsingArray[m*(m_sYSize)+n] = FALSE;
					}
				}
			}
			break;
		case 1:
			{
				for(m = start_x ; m < end_x+1 ; m++)
				{
					for(n = start_z ; n < end_z+1 ; n++)
					{
						if(pDlg->m_checkLandImpossible)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bEnableLand = FALSE;
						}
						else if(pDlg->m_checkLandPossible)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bEnableLand = TRUE;
						}
						m_bUsingArray[m*(m_sYSize)+n] = FALSE;
					}
				}
			}
			break;
		case 2:
			{
				if(pDlg->m_checkEventArea)
				{
					if(m_dlgEvnetSetDetail.DoModal()==IDOK)
					{
						for(m = start_x ; m < end_x+1 ; m++)
						{
							for(n = start_z ; n < end_z+1 ; n++)
							{
								m_pEventInfo[m*(m_sYSize)+n].m_bEnvetType = m_dlgEvnetSetDetail.m_editEventType;
								m_pEventInfo[m*(m_sYSize)+n].m_EventwParam1 = m_dlgEvnetSetDetail.m_editEventwParam1;
								m_pEventInfo[m*(m_sYSize)+n].m_EventwParam2 = m_dlgEvnetSetDetail.m_editEventwParam2;
								m_pEventInfo[m*(m_sYSize)+n].m_EventwParam3 = m_dlgEvnetSetDetail.m_editEventwParam3;
								strcpy(m_pEventInfo[m*(m_sYSize)+n].m_EventstrParam,m_dlgEvnetSetDetail.m_editEventstrParam);
//								m_pEventInfo[m*(m_sYSize)+n].m_EventstrParam = m_dlgEvnetSetDetail.m_editEventstrParam;
								m_bUsingArray[m*(m_sYSize)+n] = FALSE;
							}
						}
					}
				}
				else if(pDlg->m_checkEventNormal)
				{
					for(m = start_x ; m < end_x+1 ; m++)
					{
						for(n = start_z ; n < end_z+1 ; n++)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bEnvetType = 0;
							m_pEventInfo[m*(m_sYSize)+n].m_EventwParam1 = 0;
							m_pEventInfo[m*(m_sYSize)+n].m_EventwParam2 = 0;
							m_pEventInfo[m*(m_sYSize)+n].m_EventwParam3 = 0;
							strcpy(m_pEventInfo[m*(m_sYSize)+n].m_EventstrParam,"");
//							m_pEventInfo[m*(m_sYSize)+n].m_EventstrParam = "";
							m_bUsingArray[m*(m_sYSize)+n] = FALSE;
						}
					}
				}
			}
			break;
		case 3:
			{
				for(m = start_x ; m < end_x+1 ; m++)
				{
					for(n = start_z ; n < end_z+1 ; n++)
					{
						if(pDlg->m_checkMoveOk)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bMove = 0;
						}
						else if(pDlg->m_checkMoveCheck)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bMove = 1;
						}
						else if(pDlg->m_checkMoveNo)
						{
							m_pEventInfo[m*(m_sYSize)+n].m_bMove = 2;
						}
						m_bUsingArray[m*(m_sYSize)+n] = FALSE;
					}
				}
			}
			break;
		}
		pView->m_pMiniMap->SetEvent();

	}
	else
	{
		//  巹  -  
		for(m = nOldStartX ; m < nOldEndX+1 ; m++)
		{
			for(n = nOldStartZ ; n < nOldEndZ+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = FALSE;
			}
		}
		//  巹  -  ϱ
		for(m = start_x ; m < end_x+1 ; m++)
		{
			for(n = start_z ; n < end_z+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = TRUE;
			}
		}
	}
	nOldEndX = end_x;
	nOldEndZ = end_z;
	nOldStartX = start_x;
	nOldStartZ = start_z;

}
void CBackground::MonsterAction(CMonsterSetDlg  *pDlg, const D3DXVECTOR3& orig, const D3DXVECTOR3& dir)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

// 	D3DXVECTOR3 vLookat;
// 	D3DXVec3Normalize(&vLookat,&pView->m_pCamera->GetViewDir());
// //	vLookat = pView->m_pCamera->GetEyePt() + 32*40.0f*vLookat;
// 	vLookat = pView->m_pCamera->GetLookatPt();
// 	int xi = (int)(vLookat.x/40.0f);
// 	int zi = (int)(vLookat.z/40.0f);
// 
// 	int tempX,tempZ;
// 
// 	for(int i=xi-32;i<xi+32;i++)
// 	{
// 		for(int j=zi-32;j<zi+32;j++)
// 		{
// 			FLOAT fBary1, fBary2;
// 			FLOAT fDist;
// 			D3DXVECTOR3 v,v2;
// 			if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
// 			{
// 				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
// 					m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos,m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,
// 					&fDist, &fBary1, &fBary2 ))
// 				{
// 					//  Ÿ ٲٱ
// 					v = orig + dir*fDist;
// 					tempX = (int)(v.x/40.0f);
// 					tempZ = (int)(v.z/40.0f);
// 					SetMonster(pDlg,tempX,tempZ);
// 					return;
// 				}
// 				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
// 					m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos,
// 					&fDist, &fBary1, &fBary2 ))
// 				{
// 					v = orig + dir*fDist;
// 					tempX = (int)(v.x/40.0f);
// 					tempZ = (int)(v.z/40.0f);
// 					SetMonster(pDlg,tempX,tempZ);
// 					return;
// 				}
// 			}
// 		}
// 	}

	// 07-05-11 by shkim,   ( for κ Լȭ )
	int nX = 0, nZ = 0;
	D3DXVECTOR3 vVec( 0.0f, 0.0f, 0.0f );
	BOOL bNearLengthCheck = NearPickCheck( orig, dir );

	if( bNearLengthCheck == TRUE ) // 07-05-11 by shkim, ݺ Ż   .
	{
		PickPos( &vVec ); // ŷ  ġ ˾ ´.

//		char chTmp[256];
//		sprintf(chTmp, " PickPos  => [X:%.2f], [Y:%.2f], [Z:%.2f] \n", vVec.x, vVec.y, vVec.z );

//		DBGOUT(" %s \n", chTmp);

		nX = (int)(vVec.x/40.0f);
		nZ = (int)(vVec.z/40.0f);

		SetMonster( pDlg, nX, nZ );
 		
	}

}

void CBackground::SetTileRegion(int x,int y)
{
	static BOOL	bTileSetStartPos = TRUE;
	static int nTileStartX = 0;
	static int nTileStartZ = 0;
	static int nTileEndX = 0;
	static int nTileEndZ = 0;
	static int nTileOldStartX = 0;
	static int nTileOldStartZ = 0;
	static int nTileOldEndX = 0;
	static int nTileOldEndZ = 0;

	if(x<0)
		x=0;
	if(x>m_sXSize)
		x=m_sXSize-1;
	if(y<0)
		y=0;
	if(y>m_sYSize)
		y=m_sYSize-1;

	if(bTileSetStartPos)
	{
		nTileStartX = x;
		nTileStartZ = y;
		bTileSetStartPos = FALSE;
	}
	nTileEndX = x;
	nTileEndZ = y;

	int start_x,start_z;
	int end_x,end_z;
	int i,j;
	int m,n;
	
	if(nTileStartX > nTileEndX)
	{
		end_x = nTileStartX;
		start_x = nTileEndX;
	}
	else
	{
		start_x = nTileStartX;
		end_x = nTileEndX;
	}
	if(nTileStartZ > nTileEndZ)
	{
		end_z = nTileStartZ;
		start_z = nTileEndZ;
	}
	else
	{
		start_z = nTileStartZ;
		end_z = nTileEndZ;
	}
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	if(!pView->m_bLButtonCheck)
	{
		nTileEndX = x;
		nTileEndZ = y;
		bTileSetStartPos = TRUE;

		//  
		for(m = nTileOldStartX ; m < nTileOldEndX+1 ; m++)
		{
			for(n = nTileOldStartZ ; n < nTileOldEndZ+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = FALSE;
			}
		}
		if((end_x - start_x) > 0 && (end_z - start_z) > 0)
		{
			for(i = start_x; i < end_x; i++)
			{
				for(j = start_z; j < end_z; j++)
				{
					ActionTileSet(i, j,2);//,v,v2);
				}
			}

		}
	}
	else
	{
		//  巹  -  
		for(m = nTileOldStartX ; m < nTileOldEndX+1 ; m++)
		{
			for(n = nTileOldStartZ ; n < nTileOldEndZ+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = FALSE;
			}
		}
		//  巹  -  ϱ
		for(m = start_x ; m < end_x+1 ; m++)
		{
			for(n = start_z ; n < end_z+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = TRUE;
			}
		}
	}
	nTileOldEndX = end_x;
	nTileOldEndZ = end_z;
	nTileOldStartX = start_x;
	nTileOldStartZ = start_z;
}

void CBackground::SetTilePoint(int x,int y,int type)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
//	int i,j;
	switch(pView->m_nTileSetScaleType)
	{
		case 0:
		{
			ActionTileSet(x, y,type);
		}
		break;
		case 1:
		{
			ActionTileSet(x, y,0);
			ActionTileSet(x, y,1);
			ActionTileSet(x, y,2);
			ActionTileSet(x, y,3);
		}
		break;
		case 2:
		{
			ActionTileSet(x, y-1,type);
			ActionTileSet(x-1, y,type);
			ActionTileSet(x, y,type);
			ActionTileSet(x, y+1,type);
			ActionTileSet(x+1, y,type);
		}
		break;
		case 3:
		{
			if(type==1)
				type = 0;
			else if(type==2)
				type = 3;
			ActionTileSet(x, y-1,type);
			ActionTileSet(x+1, y-1,type);
			ActionTileSet(x-1, y,type);
			ActionTileSet(x, y,type);
			ActionTileSet(x+1, y,type);
			ActionTileSet(x+2, y,type);
			ActionTileSet(x, y+1,type);
			ActionTileSet(x+1, y+1,type);
		}
		break;
		case 4:
		{
			ActionTileSet(x, y-1,0);
			ActionTileSet(x+1, y-1,0);
			ActionTileSet(x-1, y,0);
			ActionTileSet(x, y,0);
			ActionTileSet(x+1, y,0);
			ActionTileSet(x+2, y,0);
			ActionTileSet(x-1, y+1,0);
			ActionTileSet(x, y+1,0);
			ActionTileSet(x+1, y+1,0);
			ActionTileSet(x+2, y+1,0);
			ActionTileSet(x, y+2,0);
			ActionTileSet(x+1, y+2,0);
		}
		break;
	}
}

void CBackground::SetMonster(CMonsterSetDlg  *pDlg,int i, int j)
{
	static BOOL	bMonSetStartPos = TRUE;
	static int nMonStartX = 0;
	static int nMonStartZ = 0;
	static int nMonEndX = 0;
	static int nMonEndZ = 0;
	static int nMonOldStartX = 0;
	static int nMonOldStartZ = 0;
	static int nMonOldEndX = 0;
	static int nMonOldEndZ = 0;

	if(i<0)
		i=0;
	if(i>m_sXSize)
		i=m_sXSize-1;
	if(j<0)
		j=0;
	if(j>m_sYSize)
		j=m_sYSize-1;

	if(bMonSetStartPos)
	{
		nMonStartX = i;
		nMonStartZ = j;
		bMonSetStartPos = FALSE;
	}
	nMonEndX = i;
	nMonEndZ = j;

	int start_x,start_z;
	int end_x,end_z;
	
	if(nMonStartX > nMonEndX)
	{
		end_x = nMonStartX;
		start_x = nMonEndX;
	}
	else
	{
		start_x = nMonStartX;
		end_x = nMonEndX;
	}
	if(nMonStartZ > nMonEndZ)
	{
		end_z = nMonStartZ;
		start_z = nMonEndZ;
	}
	else
	{
		start_z = nMonStartZ;
		end_z = nMonEndZ;
	}

	int m,n;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	if(!pView->m_bLButtonCheck)
	{
		nMonEndX = i;
		nMonEndZ = j;
		bMonSetStartPos = TRUE;

		//  
		for(m = nMonOldStartX ; m < nMonOldEndX+1 ; m++)
		{
			for(n = nMonOldStartZ ; n < nMonOldEndZ+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = FALSE;
			}
		}
		m_dlgMonsterSetDetail.m_sStartPosX = start_x;
		m_dlgMonsterSetDetail.m_sStartPosZ = start_z;
		m_dlgMonsterSetDetail.m_sEndPosX = end_x+1;
		m_dlgMonsterSetDetail.m_sEndPosZ = end_z+1;
		if(m_dlgMonsterSetDetail.DoModal()==IDOK)
		{
			MONSTERINFO2 mInfo;
			memset(&mInfo,0x00,sizeof(mInfo));
			wsprintf(mInfo.strRegionName,m_dlgMonsterSetDetail.m_strMonsterRegion);
			mInfo.sEndx = m_dlgMonsterSetDetail.m_sEndPosX;
			mInfo.sEndz = m_dlgMonsterSetDetail.m_sEndPosZ;
			mInfo.sStartx = m_dlgMonsterSetDetail.m_sStartPosX;
			mInfo.sStartz = m_dlgMonsterSetDetail.m_sStartPosZ;
			mInfo.nMonType = m_dlgMonsterSetDetail.m_nMonType;
			mInfo.sMaxMon = m_dlgMonsterSetDetail.m_sMaxMon;
			mInfo.sResNum = m_dlgMonsterSetDetail.m_sMonResNum;
			mInfo.sResTime = m_dlgMonsterSetDetail.m_sMonResTime;
			mInfo.bMonType = m_dlgMonsterSetDetail.m_bMonType;
			m_listMonsterInfo.push_back(mInfo);
			m_nMonsterNumber++;
			pView->m_dlgMonsterSet.UpdateMonster(mInfo.strRegionName);

			UpdateMonsterRegion(mInfo.sStartx,mInfo.sStartz,mInfo.sEndx,mInfo.sEndz,TRUE);
		}
	}
	else
	{
		//  巹  -  
		for(m = nMonOldStartX ; m < nMonOldEndX+1 ; m++)
		{
			for(n = nMonOldStartZ ; n < nMonOldEndZ+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = FALSE;
			}
		}
		//  巹  -  ϱ
		for(m = start_x ; m < end_x+1 ; m++)
		{
			for(n = start_z ; n < end_z+1 ; n++)
			{
				m_bUsingArray[m*(m_sYSize)+n] = TRUE;
			}
		}
	}
	nMonOldEndX = end_x;
	nMonOldEndZ = end_z;
	nMonOldStartX = start_x;
	nMonOldStartZ = start_z;

}

CString CBackground::UpdateMonsterData(CString str)
{
	list<MONSTERINFO2>::iterator it = m_listMonsterInfo.begin();
	for(int i=0;i<m_nMonsterNumber;i++)
	{
		if(strcmp((LPCTSTR)str, (*it).strRegionName) == 0 )
		{
			m_dlgMonsterSetDetail.m_sEndPosX = (*it).sEndx;
			m_dlgMonsterSetDetail.m_sEndPosZ = (*it).sEndz;
			m_dlgMonsterSetDetail.m_sMaxMon = (*it).sMaxMon;
			m_dlgMonsterSetDetail.m_nMonType = (*it).nMonType;
			m_dlgMonsterSetDetail.m_sMonResNum = (*it).sResNum;
			m_dlgMonsterSetDetail.m_sMonResTime = (*it).sResTime;
			m_dlgMonsterSetDetail.m_sStartPosX = (*it).sStartx;
			m_dlgMonsterSetDetail.m_sStartPosZ = (*it).sStartz;
			m_dlgMonsterSetDetail.m_strMonsterRegion = (*it).strRegionName;
			m_dlgMonsterSetDetail.m_bMonType = (*it).bMonType;
			if(m_dlgMonsterSetDetail.DoModal() == IDOK)
			{
				UpdateMonsterRegion((*it).sStartx,(*it).sStartz,(*it).sEndx,(*it).sEndz,FALSE);

				(*it).sEndx = m_dlgMonsterSetDetail.m_sEndPosX;
				(*it).sEndz = m_dlgMonsterSetDetail.m_sEndPosZ;
				(*it).sMaxMon = m_dlgMonsterSetDetail.m_sMaxMon;
				(*it).nMonType = m_dlgMonsterSetDetail.m_nMonType;
				(*it).sResNum = m_dlgMonsterSetDetail.m_sMonResNum;
				(*it).sResTime = m_dlgMonsterSetDetail.m_sMonResTime;
				(*it).sStartx = m_dlgMonsterSetDetail.m_sStartPosX;
				(*it).sStartz = m_dlgMonsterSetDetail.m_sStartPosZ;
				strcpy((*it).strRegionName,m_dlgMonsterSetDetail.m_strMonsterRegion);
				(*it).bMonType = m_dlgMonsterSetDetail.m_bMonType;
				
				UpdateMonsterRegion((*it).sStartx,(*it).sStartz,(*it).sEndx,(*it).sEndz,TRUE);
				return (*it).strRegionName;
			}
		}
		it++;
	}
	return str;
}

void CBackground::UpdateMonsterRegion(short minx,short minz,short maxx,short maxz,BOOL bCheck)
{
	int i,j;
	for(i=minx;i<maxx;i++)
	{
		for(j=minz;j<maxz;j++)
		{
			m_bUsingMonsterRegion[i*(m_sYSize)+j] = bCheck;
		}
	}
}

/*
void CBackground::ObjectAction(const D3DXVECTOR3& orig, const D3DXVECTOR3& dir)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	D3DXVECTOR3 vLookat;
	D3DXVec3Normalize(&vLookat,&pView->m_pCamera->GetViewDir());
	vLookat = pView->m_pCamera->GetEyePt() + 16*40.0f*vLookat;
	int xi = (int)(vLookat.x/40.0f);
	int zi = (int)(vLookat.z/40.0f);

	for(int i=xi-16;i<xi+16;i++)
	{
		for(int j=zi-16;j<zi+16;j++)
		{
			FLOAT fBary1, fBary2;
			FLOAT fDist;
			D3DXVECTOR3 v,v2;
			if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
			{
				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
					m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos,m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,
					&fDist, &fBary1, &fBary2 ))
				{
					v = orig + dir*fDist;
					SeekObject(v);
					return;
				}
				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
					m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos,
					&fDist, &fBary1, &fBary2 ))
				{
					v = orig + dir*fDist;
					SeekObject(v);
					return;
				}
			}
		}
	}
}
*/

void CBackground::SeekObject()//CPoint point)//D3DXVECTOR3 vPos)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	D3DXVECTOR2 vPos,vPos2;
//	vPos = D3DXVECTOR2(point.x,point.y);
//	RECT rect;
//	GetClientRect(((CD3DApplication *)pView)->m_hWnd,&rect);
	CPoint ptCursor;
	GetCursorPos( &ptCursor );
	::ScreenToClient(((CD3DApplication *)pView)->m_hWnd, &ptCursor );
	vPos = D3DXVECTOR2(ptCursor.x,ptCursor.y);

	CObjectChild * pTar = NULL;
	float fLength = 500.0f;
	float fDist;
	
	D3DXVECTOR3 vCamPos,vAt,vLookatVel;
//	vCamPos = pView->m_pCamera->GetEyePt();
	vCamPos = pView->m_pCamera->GetLookatPt();
//	D3DXVec3Normalize(&vLookatVel,&pView->m_pCamera->GetViewDir());
//	vAt = vCamPos + 32*40.0f*vLookatVel;
	int i,j;
	int temp = (int)(vCamPos.y / 30.0f);
	if(temp < 5)
		temp = 4;
	temp = 32;
	
	int xi,zi;
	xi = (int)(vCamPos.x / m_fTileSize);
	zi = (int)(vCamPos.z / m_fTileSize);

	int nIndex;
	for(i=xi-32;i<xi+32;i++)
	{
		for(j=zi-32;j<zi+32;j++)
		{
			if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
			{
				nIndex = i*1000 + j;
				map<INT, CAtumNode *>::iterator it = m_mapObjectData.find(nIndex);
				
				if(it != m_mapObjectData.end())
				{
					CObjectChild * pObj = (CObjectChild *)it->second->m_pChild;
					while(pObj)
					{
						if(pObj->m_nObjScreenX >= 0 && pObj->m_nObjScreenY >= 0)
						{
							vPos2 = D3DXVECTOR2(pObj->m_nObjScreenX,pObj->m_nObjScreenY);
							fDist = D3DXVec2Length(&(vPos-vPos2));
							if(fDist < fLength)
							{
								fLength = fDist;
								pTar = pObj;
								
							}
						}
						pObj = (CObjectChild *)pObj->m_pNext;
					} //while end
				}
			}
		} // for j end
	} // for i end
	
	if(pTar)
	{
		int temp = 0;
		
		int clearNum = pView->m_dlgAllList.m_ListObject.GetCurSel();
		
		int nTotal = pView->m_dlgAllList.m_ListObject.GetCount();
		
		pView->m_dlgAllList.m_ListObject.SetSel(clearNum,FALSE);

		pView->m_dlgObjectSet.ObjectSelect(pTar);

		while(temp != nTotal)
		{

			CObjectChild * pDummyobj = (CObjectChild *)pView->m_dlgAllList.m_ListObject.GetItemData(temp);
			
			if(pTar->m_vPos == pDummyobj->m_vPos )
			{
				pView->m_dlgAllList.m_ListObject.SetSel(temp);
				return;				
			}
			temp++;
			
		}
	}
}

void CBackground::ActionTileSet(int x, int z,int type)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int tilesettype = type;
	if(pView->m_checkTilesetRegion)
		tilesettype = 2;
	switch(tilesettype)
	{
		case 0:
		{
			if((x-1)*m_sYSize >= 0 && (z-1) >= 0)
			{
				m_pTileInfo[(x-1)*m_sYSize+(z-1)].texTileDirect3 = pView->m_nTileTextype;//tiletype;
				setMultiTex((x-1)*m_sYSize,(z-1),3);
			}
			if((x-1)*m_sYSize >= 0 && z >= 0)
			{
				m_pTileInfo[(x-1)*m_sYSize+z].texTileDirect2 = pView->m_nTileTextype;//tiletype;
				setMultiTex((x-1)*m_sYSize,z,2);
			}
			if(x*m_sYSize >= 0 && (z-1) >= 0)
			{
				m_pTileInfo[x*m_sYSize+(z-1)].texTileDirect4 = pView->m_nTileTextype;//tiletype;
				setMultiTex(x*m_sYSize,(z-1),4);
			}
			if(x*m_sYSize >= 0 && z >= 0)
			{
				m_pTileInfo[x*m_sYSize+z].texTileDirect1 = pView->m_nTileTextype;//tiletype;
				setMultiTex(x*m_sYSize,z,1);
			}
			break;
		}
		case 1:
		{
			if(x*m_sYSize >= 0 && (z-1) >= 0)
			{
				m_pTileInfo[x*m_sYSize+(z-1)].texTileDirect3 = pView->m_nTileTextype;//tiletype;
				setMultiTex(x*m_sYSize,(z-1),3);
			}
			if(x*m_sYSize >= 0 && z >= 0)
			{
				m_pTileInfo[x*m_sYSize+z].texTileDirect2 = pView->m_nTileTextype;//tiletype;
				setMultiTex(x*m_sYSize,z,2);
			}
			if((x+1) < m_sXSize && (x+1)*m_sYSize >= 0 && (z-1) >= 0)
			{
				m_pTileInfo[(x+1)*m_sYSize+(z-1)].texTileDirect4 = pView->m_nTileTextype;//tiletype;
				setMultiTex((x+1)*m_sYSize,(z-1),4);
			}
			if((x+1) < m_sXSize && (x+1)*m_sYSize >= 0 && z >= 0)
			{
				m_pTileInfo[(x+1)*m_sYSize+z].texTileDirect1 = pView->m_nTileTextype;//tiletype;
				setMultiTex((x+1)*m_sYSize,z,1);
			}
			break;
		}
		case 2:
		{
			if(x*m_sYSize >= 0 && z >= 0)
			{
				m_pTileInfo[x*m_sYSize+z].texTileDirect3 = pView->m_nTileTextype;//tiletype;
				setMultiTex(x*m_sYSize,z,3);
			}
			if(x*m_sYSize >= 0 && (z+1) >= 0 && (z+1) < m_sYSize)
			{
				m_pTileInfo[x*m_sYSize+(z+1)].texTileDirect2 = pView->m_nTileTextype;//tiletype;
				setMultiTex(x*m_sYSize,(z+1),2);
			}
			if((x+1) < m_sXSize && (x+1)*m_sYSize >= 0 && z >= 0)
			{
				m_pTileInfo[(x+1)*m_sYSize+z].texTileDirect4 = pView->m_nTileTextype;//tiletype;
				setMultiTex((x+1)*m_sYSize,z,4);
			}
			if((x+1) < m_sXSize && (x+1)*m_sYSize >= 0 && (z+1) >= 0 && (z+1) < m_sYSize)
			{
				m_pTileInfo[(x+1)*m_sYSize+(z+1)].texTileDirect1 = pView->m_nTileTextype;//tiletype;
				setMultiTex((x+1)*m_sYSize,(z+1),1);
			}
			break;
		}
		case 3:
		{
			if((x-1)*m_sYSize >= 0 && z >= 0)
			{
				m_pTileInfo[(x-1)*m_sYSize+z].texTileDirect3 = pView->m_nTileTextype;//tiletype;
				setMultiTex((x-1)*m_sYSize,z,3);
			}
			if((x-1)*m_sYSize >= 0 && (z+1) >= 0 && (z+1) < m_sYSize)
			{
				m_pTileInfo[(x-1)*m_sYSize+(z+1)].texTileDirect2 = pView->m_nTileTextype;//tiletype;
				setMultiTex((x-1)*m_sYSize,(z+1),2);
			}
			if(x*m_sYSize >= 0 && z >= 0)
			{
				m_pTileInfo[x*m_sYSize+z].texTileDirect4 = pView->m_nTileTextype;//tiletype;
				setMultiTex(x*m_sYSize,z,4);
			}
			if(x*m_sYSize >= 0 && (z+1) >= 0 && (z+1) < m_sYSize)
			{
				m_pTileInfo[x*m_sYSize+(z+1)].texTileDirect1 = pView->m_nTileTextype;//tiletype;
				setMultiTex(x*m_sYSize,(z+1),1);
			}
			break;
		}
	}
}

// action: . (x,z): ݺ  X,Z ġ. vOri: ŷ . vTile: üũ   
void CBackground::Action( int action, int x, int z, D3DXVECTOR3 vOri, D3DXVECTOR3 vTile )//,int tiletype
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	int sizeType = pView->m_nControlSizeType; // 07-05-03   (޺ ڽ)

	int i,j;

	D3DXVECTOR2 vPoint,vPoint1,vPoint2,vPoint3,vPoint4;
	D3DXVECTOR2 vNearTilePos;

	vPoint = D3DXVECTOR2(vTile.x, vTile.z); //  ġ
	vNearTilePos = D3DXVECTOR2(vTile.x, vTile.z); //   ãƼ ޾Ҵ.

	vPoint1 = D3DXVECTOR2( m_pTileVertexArray[x*(m_sYSize+1)+z].pos.x, m_pTileVertexArray[x*(m_sYSize+1)+z].pos.z );
	vPoint2 = D3DXVECTOR2( m_pTileVertexArray[x*(m_sYSize+1)+z+1].pos.x, m_pTileVertexArray[x*(m_sYSize+1)+z+1].pos.z );
	vPoint3 = D3DXVECTOR2( m_pTileVertexArray[(x+1)*(m_sYSize+1)+(z+1)].pos.x, m_pTileVertexArray[(x+1)*(m_sYSize+1)+(z+1)].pos.z );
	vPoint4 = D3DXVECTOR2( m_pTileVertexArray[(x+1)*(m_sYSize+1)+z].pos.x, m_pTileVertexArray[(x+1)*(m_sYSize+1)+z].pos.z );


	switch(action)
	{
		case NONE_ACTION:
		{
			break;
		}
		case HEIGHT_ATCION:
		{
		
			switch( sizeType )
			{
				case SIZE_2X2: // 2X2 
				{
					if( D3DXVec2Length( &( vPoint - vPoint1 ) ) < 1.0f )
					{
						i = x;
						j = z;
					}
					else if( D3DXVec2Length( &( vPoint - vPoint2 ) ) < 1.0f )
					{
						i = x;
						j = z+1;
					}
					else if( D3DXVec2Length( &( vPoint - vPoint3 ) ) < 1.0f )
					{
						i = x+1;
						j = z+1;
					}
					else if( D3DXVec2Length( &( vPoint - vPoint4 ) ) < 1.0f )
					{
						i = x+1;
						j = z;
					}
			

					if(i >= 0 && i <= m_sXSize && j >= 0 && j <= m_sYSize)
					{
						SetVertex( i, j );						
					}

				//	Restore( i - 1, j - 1 , 3 );
					Restore();
					break;
				}
				case SIZE_3X3: // 3X3
				{
					i = x;
					j = z;
					if(i >= 0 && i <= m_sXSize && j >= 0 && j <= m_sYSize)
					{
						SetVertex(i,j);
					}

					if(i >= 0 && i <= m_sXSize && j+1 >= 0 && j+1 <= m_sYSize)
					{
						SetVertex(i,j+1);
					}

					if(i+1 >= 0 && i+1 <= m_sXSize && j+1 >= 0 && j+1 <= m_sYSize)
					{
						SetVertex(i+1,j+1);
					}

					if(i+1 >= 0 && i+1 <= m_sXSize && j >= 0 && j <= m_sYSize)
					{
						SetVertex(i+1,j);
					}

				//	Restore(i-2,j-2,5);
					Restore();
					break;
				}
				case SIZE_4X4: // 4X4
				{
					if( D3DXVec2Length( &( vPoint-vPoint1 ) ) < 1.0f )
					{
						i = x;
						j = z;
					}
					else if( D3DXVec2Length( &( vPoint - vPoint2 ) ) < 1.0f )
					{
						i = x;
						j = z+1;
					}
					else if( D3DXVec2Length( &( vPoint - vPoint3 ) ) < 1.0f )
					{
						i = x+1;
						j = z+1;
					}
					else if( D3DXVec2Length( &( vPoint - vPoint4 ) ) < 1.0f )
					{
						i = x+1;
						j = z;
					}

					if( i-1 >= 0 && i-1 <= m_sXSize && j-1 >= 0 && j-1 <= m_sYSize )
					{
						SetVertex(i-1,j-1);
					}

					if( i-1 >= 0 && i-1 <= m_sXSize && j >= 0 && j <= m_sYSize )
					{
						SetVertex(i-1,j);
					}

					if( i-1 >= 0 && i-1 <= m_sXSize && j+1 >= 0 && j+1 <= m_sYSize )
					{
						SetVertex(i-1,j+1);
					}

					if( i >= 0 && i <= m_sXSize && j-1 >= 0 && j-1 <= m_sYSize )
					{
						SetVertex(i,j-1);
					}

					if( i >= 0 && i <= m_sXSize && j >= 0 && j <= m_sYSize )
					{
						SetVertex(i,j);
					}

					if( i >= 0 && i <= m_sXSize && j >= 0 && j <= m_sYSize )
					{
						SetVertex(i,j);
					}

					if( i >= 0 && i <= m_sXSize && j+1 >= 0 && j+1 <= m_sYSize )
					{
						SetVertex(i,j+1);
					}

					if( i+1 >= 0 && i+1 <= m_sXSize && j-1 >= 0 && j-1 <= m_sYSize )
					{
						SetVertex(i+1,j-1);
					}

					if( i+1 >= 0 && i+1 <= m_sXSize && j >= 0 && j <= m_sYSize )
					{
						SetVertex(i+1,j);
					}

					if( i+1 >= 0 && i+1 <= m_sXSize && j+1 >= 0 && j+1 <= m_sYSize )
					{
						SetVertex(i+1,j+1);
					}

				//	Restore(i-2,j-2,5);
					Restore();

					break;
				}
			}
			break;
		}
		case PLANE_ACTION: // ȭ
		{
			int i = x;
			int j = z;
			if( i >= 0 && i <= m_sXSize && j >= 0 && j <= m_sYSize )
			{
				SetVertexFlat(i,j);
			}

			if( i >= 0 && i <= m_sXSize && j+1 >= 0 && j+1 <= m_sYSize )
			{
				SetVertexFlat(i,j+1);
			}

			if( i+1 >= 0 && i+1 <= m_sXSize && j+1 >= 0 && j+1 <= m_sYSize )
			{
				SetVertexFlat(i+1,j+1);
			}

			if( i+1 >= 0 && i+1 <= m_sXSize && j >= 0 && j <= m_sYSize )
			{
				SetVertexFlat(i+1,j);
			}

		//	Restore(i-2,j-2,5);
			Restore();
			break;
		}

		case OBJ_SELECT: // 콺 Ʈ 
		{
			int i,cont = pView->m_editObjectNumber;
			D3DXVECTOR3 vPos;

			if(pView->m_dwObjectType < pView->m_nObjectNormalCont)
			{
				if(cont<5)
				{
					for(i=0;i<cont;i++)
					{
						vPos= vOri;
						vPos.x += (float)(rand()%1000)/100.0f -5.0f;
						if(vPos.x < 0.0f)
							continue;
						vPos.z += (float)(rand()%1000)/100.0f -5.0f;
						if(vPos.z < 0.0f)
							continue;
						CObjectChild * pObject = new CObjectChild(pView->m_dwObjectType,vPos,true);//,pView->m_vObjectVel,vUp,true);
//						AddChild(pObject);
						if(!pObject->m_bUsing)
							delete pObject;
						else
						{
							InsertObject(pObject);
							pView->ResetObjectList();
						}
						m_nObjectNumber++;
					}
				}
				else if(cont<20)
				{
					for(i=0;i<cont;i++)
					{
						vPos= vOri;
						vPos.x += (float)(rand()%6000)/100.0f -30.0f;
						if(vPos.x < 0.0f)
							continue;
						vPos.z += (float)(rand()%6000)/100.0f -30.0f;
						if(vPos.z < 0.0f)
							continue;
						CObjectChild * pObject = new CObjectChild(pView->m_dwObjectType,vPos,true);//,pView->m_vObjectVel,vUp,true);
//						AddChild(pObject);
						if(!pObject->m_bUsing)
							delete pObject;
						else
						{
							InsertObject(pObject);
							pView->ResetObjectList();
						}
						m_nObjectNumber++;
					}
				}
				else if(cont<51)
				{
					for(i=0;i<cont;i++)
					{
						vPos= vOri;
						vPos.x += (float)(rand()%10000)/100.0f -50.0f;
						if(vPos.x < 0.0f)
							continue;
						vPos.z += (float)(rand()%10000)/100.0f -50.0f;
						if(vPos.z < 0.0f)
							continue;
						CObjectChild * pObject = new CObjectChild(pView->m_dwObjectType,vPos,true);//,pView->m_vObjectVel,vUp,true);
//						AddChild(pObject);
						if(!pObject->m_bUsing)
							delete pObject;
						else
						{
							InsertObject(pObject);
							pView->ResetObjectList();
						}
						m_nObjectNumber++;
					}
				}
				else if(cont<(100+1))
				{
					for(i=0;i<cont;i++)
					{
						vPos= vOri;
						vPos.x += (float)(rand()%20000)/100.0f -100.0f;
						if(vPos.x < 0.0f)
							continue;
						vPos.z += (float)(rand()%20000)/100.0f -100.0f;
						if(vPos.z < 0.0f)
							continue;
						CObjectChild * pObject = new CObjectChild(pView->m_dwObjectType,vPos,true);//,pView->m_vObjectVel,vUp,true);
//						AddChild(pObject);
						if(!pObject->m_bUsing)
							delete pObject;
						else
						{
							InsertObject(pObject);
							pView->ResetObjectList();
						}
						m_nObjectNumber++;
					}
				}
			}
			else
			{
				vPos = vOri;
				int tempx = ((int)(vPos.x/20.0f));
				int tempz = ((int)(vPos.z/20.0f));
//				float fHeight;
				vPos.x = tempx*20;
				vPos.y = m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight;
				vPos.z = tempz*20;
				
/*				switch(pView->m_dwObjectType-pView->m_nObjectNormalCont)
				{
					case 0:
					{
						vPos.x = tempx*20 + 10;
						vPos.z = tempz*20 + 10;
						if(pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount)
							vPos.y = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight;
						else
							vPos.y = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight;
						pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight += 20.0f;
						pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount++;
						break;
					}
					case 1:
					{
						if(((int)vPos.x)%20 > 10)
							tempx++;
						if(((int)vPos.z)%20 > 10)
							tempz++;
						vPos.x = tempx*20;
						vPos.z = tempz*20;
						if(pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount
							|| pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount
							|| pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount
							|| pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount)
						{
							fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight;
							if(fHeight < pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight)
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight;
							if(fHeight < pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight)
								fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight;
							if(fHeight < pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight)
								fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight;
						}
						else
						{
							fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight;
							if(fHeight > pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight)
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight;
							if(fHeight > pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight)
								fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight;
							if(fHeight > pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight)
								fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight;
						}
						pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount++;
						pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount++;
						pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount++;
						pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount++;
						pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight = fHeight+40.0f;
						pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight = fHeight+40.0f;
						pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight = fHeight+40.0f;
						pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight = fHeight+40.0f;
						vPos.y = fHeight;
						break;
					}
					case 2:
					{
						if(((int)vPos.x)%20 > 10)
							tempx++;
						if(((int)vPos.z)%20 > 10)
							tempz++;
						vPos.x = tempx*20;
						vPos.z = tempz*20;
						if(pView->m_bObjectDir==1 || pView->m_bObjectDir==3)
						{
							if(pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount
								|| pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount)
							{
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight;
								if(fHeight < pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight)
									fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight;
							}
							else
							{
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight;
								if(fHeight > pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight)
									fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight;
							}
							pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount++;
							pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount++;
							pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight = fHeight+40.0f;
							pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight = fHeight+40.0f;
						}
						else
						{
							if(pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount
								|| pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount)
							{
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight;
								if(fHeight < pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight)
									fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight;
							}
							else
							{
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight;
								if(fHeight > pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight)
									fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight;
							}
							pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount++;
							pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount++;
							pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight = fHeight+40.0f;
							pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight = fHeight+40.0f;
						}
						vPos.y = fHeight;
						break;
					}
					case 3:
					{
						if(((int)vPos.x)%20 > 10)
							tempx++;
						if(((int)vPos.z)%20 > 10)
							tempz++;
						vPos.x = tempx*20;
						vPos.z = tempz*20;
						if(pView->m_bObjectDir==1 || pView->m_bObjectDir==3)
						{
							if(pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount
								|| pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount)
							{
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight;
								if(fHeight < pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight)
									fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight;
							}
							else
							{
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight;
								if(fHeight > pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight)
									fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight;
							}
							pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount++;
							pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount++;
							pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight = fHeight+40.0f;
							pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight = fHeight+40.0f;
						}
						else
						{
							if(pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount
								|| pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount)
							{
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight;
								if(fHeight < pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight)
									fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight;
							}
							else
							{
								fHeight = pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fGroundHeight;
								if(fHeight > pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight)
									fHeight = pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fGroundHeight;
							}
							pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].nUseBlockCount++;
							pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].nUseBlockCount++;
							pView->m_pBackground->m_pBlockData[(tempx-1)*(2*pView->m_pBackground->m_sYSize) + tempz-1].fBlockHeight = fHeight+40.0f;
							pView->m_pBackground->m_pBlockData[tempx*(2*pView->m_pBackground->m_sYSize) + tempz].fBlockHeight = fHeight+40.0f;
						}
						vPos.y = fHeight;
						break;
					}
				}
*/				
				CObjectChild * pObject = new CObjectChild(vPos);
//				AddChild(pObject);
				if(!pObject->m_bUsing)
					delete pObject;
				else
				{
					InsertObject(pObject);
					pView->ResetObjectList();
				}
				m_nObjectNumber++;
			}
			break;
		}

		case OBJ_DELETE: // Ʈ 
		{
			D3DXVECTOR3 vPos,vAt,vLookatVel;
//			vPos = pView->m_pCamera->GetEyePt();
			vPos = pView->m_pCamera->GetLookatPt();
//			D3DXVec3Normalize(&vLookatVel,&pView->m_pCamera->GetViewDir());
//			vAt = vPos + 32*40.0f*vLookatVel;
			int i,j;
			int temp = (int)(vPos.y / 30.0f);
			if(temp < 5)
				temp = 4;
			temp = 32;
			int xi,zi;
			xi = (int)(vPos.x / m_fTileSize);
			zi = (int)(vPos.z / m_fTileSize);

			int nIndex;
			m_nObjectNumberOld = m_nObjectNumber;

			for(i=xi-32;i<xi+32;i++)
			{
				for(j=zi-32;j<zi+32;j++)
				{
					if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
					{
						nIndex = i*1000 + j;
						map<INT, CAtumNode *>::iterator it = m_mapObjectData.find(nIndex);
						if(it != m_mapObjectData.end())
						{
							CObjectChild * pChild = (CObjectChild *)it->second->m_pChild;
							D3DXVECTOR2 vPos1,vPos2;
							vPos1 = D3DXVECTOR2(vOri.x,vOri.z);
							while(pChild)
							{
								vPos2 = D3DXVECTOR2(pChild->m_vPos.x,pChild->m_vPos.z);
								if( pChild->m_bUsing &&
									D3DXVec2Length(&(vPos1-vPos2))<pView->m_editObjectDelete)
								{
									pChild->m_bUsing = FALSE;
									m_nObjectNumber--;
									if(pChild->m_dwPartType >= pView->m_nObjectNormalCont)
									{
										int objx,objz;
										objx = (int)(pChild->m_vPos.x/20.0f);
										objz = (int)(pChild->m_vPos.z/20.0f);
										switch(pChild->m_dwPartType - pView->m_nObjectNormalCont)
										{
											case 0:
											{
												m_pBlockData[objx*(2*m_sYSize) + objz].nUseBlockCount--;
												if(!m_pBlockData[objx*(2*m_sYSize) + objz].nUseBlockCount)
													m_pBlockData[objx*(2*m_sYSize) + objz].fBlockHeight = m_pBlockData[objx*(2*m_sYSize) + objz].fGroundHeight;
												else
													m_pBlockData[objx*(2*m_sYSize) + objz].fBlockHeight -= 20.0f;
												break;
											}
											case 1:
											{
												m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].nUseBlockCount--;
												m_pBlockData[(objx-1)*(2*m_sYSize) + objz].nUseBlockCount--;
												m_pBlockData[objx*(2*m_sYSize) + objz-1].nUseBlockCount--;
												m_pBlockData[objx*(2*m_sYSize) + objz].nUseBlockCount--;
												if(!m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].nUseBlockCount)
													m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fBlockHeight = m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fGroundHeight;
												else
													m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fBlockHeight -= 40.0f;
												if(!m_pBlockData[(objx-1)*(2*m_sYSize) + objz].nUseBlockCount)
													m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fBlockHeight = m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fGroundHeight;
												else
													m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fBlockHeight -= 40.0f;
												if(!m_pBlockData[objx*(2*m_sYSize) + objz-1].nUseBlockCount)
													m_pBlockData[objx*(2*m_sYSize) + objz-1].fBlockHeight = m_pBlockData[objx*(2*m_sYSize) + objz-1].fGroundHeight;
												else
													m_pBlockData[objx*(2*m_sYSize) + objz-1].fBlockHeight -= 40.0f;
												if(!m_pBlockData[objx*(2*m_sYSize) + objz].nUseBlockCount)
													m_pBlockData[objx*(2*m_sYSize) + objz].fBlockHeight = m_pBlockData[objx*(2*m_sYSize) + objz].fGroundHeight;
												else
													m_pBlockData[objx*(2*m_sYSize) + objz].fBlockHeight -= 40.0f;
												break;
											}
											case 2:
											{
												if(pChild->m_vPos.x==0 || pChild->m_vPos.x==0)
												{
													m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].nUseBlockCount--;
													m_pBlockData[objx*(2*m_sYSize) + objz].nUseBlockCount--;
													if(!m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].nUseBlockCount)
														m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fBlockHeight = m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fGroundHeight;
													else
														m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fBlockHeight -= 40.0f;
													if(!m_pBlockData[objx*(2*m_sYSize) + objz].nUseBlockCount)
														m_pBlockData[objx*(2*m_sYSize) + objz].fBlockHeight = m_pBlockData[objx*(2*m_sYSize) + objz].fGroundHeight;
													else
														m_pBlockData[objx*(2*m_sYSize) + objz].fBlockHeight -= 40.0f;
												}
												else
												{
													m_pBlockData[(objx-1)*(2*m_sYSize) + objz].nUseBlockCount--;
													m_pBlockData[objx*(2*m_sYSize) + objz-1].nUseBlockCount--;
													if(!m_pBlockData[(objx-1)*(2*m_sYSize) + objz].nUseBlockCount)
														m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fBlockHeight = m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fGroundHeight;
													else
														m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fBlockHeight -= 40.0f;
													if(!m_pBlockData[objx*(2*m_sYSize) + objz-1].nUseBlockCount)
														m_pBlockData[objx*(2*m_sYSize) + objz-1].fBlockHeight = m_pBlockData[objx*(2*m_sYSize) + objz-1].fGroundHeight;
													else
														m_pBlockData[objx*(2*m_sYSize) + objz-1].fBlockHeight -= 40.0f;
												}
												break;
											}
											case 3:
											{
												if(pChild->m_vPos.x==0 || pChild->m_vPos.x==0)
												{
													m_pBlockData[(objx-1)*(2*m_sYSize) + objz].nUseBlockCount--;
													m_pBlockData[objx*(2*m_sYSize) + objz-1].nUseBlockCount--;
													if(!m_pBlockData[(objx-1)*(2*m_sYSize) + objz].nUseBlockCount)
														m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fBlockHeight = m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fGroundHeight;
													else
														m_pBlockData[(objx-1)*(2*m_sYSize) + objz].fBlockHeight -= 40.0f;
													if(!m_pBlockData[objx*(2*m_sYSize) + objz-1].nUseBlockCount)
														m_pBlockData[objx*(2*m_sYSize) + objz-1].fBlockHeight = m_pBlockData[objx*(2*m_sYSize) + objz-1].fGroundHeight;
													else
														m_pBlockData[objx*(2*m_sYSize) + objz-1].fBlockHeight -= 40.0f;
												}
												else
												{
													m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].nUseBlockCount--;
													m_pBlockData[objx*(2*m_sYSize) + objz].nUseBlockCount--;
													if(!m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].nUseBlockCount)
														m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fBlockHeight = m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fGroundHeight;
													else
														m_pBlockData[(objx-1)*(2*m_sYSize) + objz-1].fBlockHeight -= 40.0f;
													if(!m_pBlockData[objx*(2*m_sYSize) + objz].nUseBlockCount)
														m_pBlockData[objx*(2*m_sYSize) + objz].fBlockHeight = m_pBlockData[objx*(2*m_sYSize) + objz].fGroundHeight;
													else
														m_pBlockData[objx*(2*m_sYSize) + objz].fBlockHeight -= 40.0f;
												}
												break;
											}
										}
									}
								}

								pChild = (CObjectChild *)pChild->m_pNext;
							}						
						}
					}
				} // for j
			} // for i
			break;
		}

		case WATER_SETTING: //  ׸
		{
			SetWater(x,z);	
		}

		case SMOOTH_ACTION: // ٵ
		{
			int i = x;
			int j = z;

			if( D3DXVec2Length( &( vPoint - vPoint1 ) ) < 1.0f )
			{
				i = x;
				j = z;
			}
			else if( D3DXVec2Length( &( vPoint - vPoint2 ) ) < 1.0f )
			{
				i = x;
				j = z+1;
			}
			else if( D3DXVec2Length( &( vPoint - vPoint3 ) ) < 1.0f )
			{
				i = x+1;
				j = z+1;
			}
			else if( D3DXVec2Length( &( vPoint - vPoint4 ) ) < 1.0f )
			{
				i = x+1;
				j = z;
			}
	

			if(i >= 0 && i <= m_sXSize && j >= 0 && j <= m_sYSize)
			{
				SetVertexSmooth( i, j );						
			}
		
			Restore();
			break;			
		}
	}

}

// 07-05-13 by shkim, Ȯ  ڰ  . Լ    ־ 
void CBackground::Restore( /*int a, int b, int c */)
{
	SPRITEVERTEX* v;
	int xi,zi,i,j;
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	D3DXVECTOR3 vLookat;
//	D3DXVec3Normalize(&vLookat,&pView->m_pCamera->GetViewDir());
//	vLookat = pView->m_pCamera->GetEyePt() + 50.0f*vLookat;
//	vLookat = pView->m_pCamera->GetEyePt() + 32*40.0f*vLookat;
	vLookat = pView->m_pCamera->GetLookatPt();
	xi = (int)(vLookat.x/40.0f);
	zi = (int)(vLookat.z/40.0f);
	
/*	
	for(i=0;i<32;i++)
	{
		for(j=0;j<32;j++)
		{
			if(xi-16+i >= 0 && xi-16+i+1 <= m_sXSize && zi-16+j >= 0 && zi-16+j+1 <= m_sYSize)
			{
				m_pVBRender[i*32+j]->Lock( 0, 0, (BYTE**)&v, 0 );
				v[0].p = m_pTileVertexArray[(xi-16+i)*(m_sYSize+1)+(zi-16+j)].pos;
				v[0].n = m_pTileVertexArray[(xi-16+i)*(m_sYSize+1)+(zi-16+j)].nor;
				v[0].tu = 0.0f;v[0].tv = 0.0f;
				v[1].p = m_pTileVertexArray[(xi-16+i)*(m_sYSize+1)+(zi-16+j+1)].pos;
				v[1].n = m_pTileVertexArray[(xi-16+i)*(m_sYSize+1)+(zi-16+j+1)].nor;
				v[1].tu = 0.0f;v[1].tv = 1.0f;
				v[2].p = m_pTileVertexArray[(xi-16+i+1)*(m_sYSize+1)+(zi-16+j+1)].pos;
				v[2].n = m_pTileVertexArray[(xi-16+i+1)*(m_sYSize+1)+(zi-16+j+1)].nor;
				v[2].tu = 1.0f;v[2].tv = 1.0f;
				v[3].p = m_pTileVertexArray[(xi-16+i)*(m_sYSize+1)+(zi-16+j)].pos;
				v[3].n = m_pTileVertexArray[(xi-16+i)*(m_sYSize+1)+(zi-16+j)].nor;
				v[3].tu = 0.0f;v[3].tv = 0.0f;
				v[4].p = m_pTileVertexArray[(xi-16+i+1)*(m_sYSize+1)+(zi-16+j+1)].pos;
				v[4].n = m_pTileVertexArray[(xi-16+i+1)*(m_sYSize+1)+(zi-16+j+1)].nor;
				v[4].tu = 1.0f;v[4].tv = 1.0f;
				v[5].p = m_pTileVertexArray[(xi-16+i+1)*(m_sYSize+1)+(zi-16+j)].pos;
				v[5].n = m_pTileVertexArray[(xi-16+i+1)*(m_sYSize+1)+(zi-16+j)].nor;
				v[5].tu = 1.0f;v[5].tv = 0.0f;
				m_pVBRender[i*32+j]->Unlock();
				int k = (xi-16+i)*m_sYSize+(zi-16+j);
				int tempHeight = m_pTileInfo[(xi-16+i)*(m_sYSize)+(zi-16+j)].waterHeight +5;
				if(m_pTileVertexArray[(xi-16+i)*(m_sYSize+1)+(zi-16+j)].pos.y > tempHeight && 
					m_pTileVertexArray[(xi-16+i+1)*(m_sYSize+1)+(zi-16+j)].pos.y > tempHeight && 
					m_pTileVertexArray[(xi-16+i)*(m_sYSize+1)+(zi-16+j+1)].pos.y > tempHeight && 
					m_pTileVertexArray[(xi-16+i+1)*(m_sYSize+1)+(zi-16+j+1)].pos.y > tempHeight && 
					(xi-16+i) < m_sYSize && (zi-16+j) < m_sYSize)
				{
					m_pTileInfo[k].useWater = FALSE;
					m_pEventInfo[k].m_bUseWater = FALSE;
				}
			}
		}
	}
*/
	for(i=0;i<64;i++)
	{
		for(j=0;j<64;j++)
		{
			if(xi-32+i >= 0 && xi-32+i+1 < m_sXSize && zi-32+j >= 0 && zi-32+j+1 < m_sYSize)
			{
				m_pVBRender[i*64+j]->Lock( 0, 0, (BYTE**)&v, 0 );
				v[0].p = m_pTileVertexArray[(xi-32+i)*(m_sYSize+1)+(zi-32+j)].pos;
				v[0].n = m_pTileVertexArray[(xi-32+i)*(m_sYSize+1)+(zi-32+j)].nor;
				v[0].tu = 0.0f;v[0].tv = 0.0f;

				v[1].p = m_pTileVertexArray[(xi-32+i)*(m_sYSize+1)+(zi-32+j+1)].pos;
				v[1].n = m_pTileVertexArray[(xi-32+i)*(m_sYSize+1)+(zi-32+j+1)].nor;
				v[1].tu = 0.0f;v[1].tv = 1.0f;

				v[2].p = m_pTileVertexArray[(xi-32+i+1)*(m_sYSize+1)+(zi-32+j+1)].pos;
				v[2].n = m_pTileVertexArray[(xi-32+i+1)*(m_sYSize+1)+(zi-32+j+1)].nor;
				v[2].tu = 1.0f;v[2].tv = 1.0f;

				v[3].p = m_pTileVertexArray[(xi-32+i)*(m_sYSize+1)+(zi-32+j)].pos;
				v[3].n = m_pTileVertexArray[(xi-32+i)*(m_sYSize+1)+(zi-32+j)].nor;
				v[3].tu = 0.0f;v[3].tv = 0.0f;

				v[4].p = m_pTileVertexArray[(xi-32+i+1)*(m_sYSize+1)+(zi-32+j+1)].pos;
				v[4].n = m_pTileVertexArray[(xi-32+i+1)*(m_sYSize+1)+(zi-32+j+1)].nor;
				v[4].tu = 1.0f;v[4].tv = 1.0f;

				v[5].p = m_pTileVertexArray[(xi-32+i+1)*(m_sYSize+1)+(zi-32+j)].pos;
				v[5].n = m_pTileVertexArray[(xi-32+i+1)*(m_sYSize+1)+(zi-32+j)].nor;
				v[5].tu = 1.0f;v[5].tv = 0.0f;
				if(m_pBackTexture)
				{
					v[0].tv = 1.0f - ((float)(pView->m_nOldLookZ-32+j))/((float)m_sYSize);
					v[0].tu = ((float)(pView->m_nOldLookX-32+i))/((float)m_sXSize);
					v[1].tv = 1.0f - ((float)(pView->m_nOldLookZ-32+j+1))/((float)m_sYSize);
					v[1].tu = ((float)(pView->m_nOldLookX-32+i))/((float)m_sXSize);
					v[2].tv = 1.0f - ((float)(pView->m_nOldLookZ-32+j+1))/((float)m_sYSize);
					v[2].tu = ((float)(pView->m_nOldLookX-32+i+1))/((float)m_sXSize);
					v[3].tv = 1.0f - ((float)(pView->m_nOldLookZ-32+j))/((float)m_sYSize);
					v[3].tu = ((float)(pView->m_nOldLookX-32+i))/((float)m_sXSize);
					v[4].tv = 1.0f - ((float)(pView->m_nOldLookZ-32+j+1))/((float)m_sYSize);
					v[4].tu = ((float)(pView->m_nOldLookX-32+i+1))/((float)m_sXSize);
					v[5].tv = 1.0f - ((float)(pView->m_nOldLookZ-32+j))/((float)m_sYSize);
					v[5].tu = ((float)(pView->m_nOldLookX-32+i+1))/((float)m_sXSize);

				}

				m_pVBRender[i*64+j]->Unlock();

				int k = (xi-32+i)*m_sYSize+(zi-32+j);

				int tempHeight = m_pTileInfo[(xi-32+i)*(m_sYSize)+(zi-32+j)].waterHeight +5;

				if( m_pTileVertexArray[(xi-32+i)*(m_sYSize+1)+(zi-32+j)].pos.y > tempHeight && 
					m_pTileVertexArray[(xi-32+i+1)*(m_sYSize+1)+(zi-32+j)].pos.y > tempHeight && 
					m_pTileVertexArray[(xi-32+i)*(m_sYSize+1)+(zi-32+j+1)].pos.y > tempHeight && 
					m_pTileVertexArray[(xi-32+i+1)*(m_sYSize+1)+(zi-32+j+1)].pos.y > tempHeight && 
					(xi-32+i) < m_sYSize && (zi-32+j) < m_sYSize )
				{
					m_pTileInfo[k].waterType = 0;
//					m_pEventInfo[k].m_bUseWater = FALSE;
					m_pEventInfo[k].m_dwWaterType = 0;
				}
			}
		}
	}
}

void CBackground::SetVertex(int i, int j)
{
	float highvalue = 1.0f;
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	highvalue = pView->m_editUpDownRate;

	int dir = 0;

	// 07-05-16 by shkim, м. ̸ üũؼ ó ش.
	if( pView->m_nUpdown == 0 )
	{
		dir = 1;
	}
	else
	{
		dir = -1;
	}

	m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y += dir * highvalue;

	// 07-05-08 by shkim,   
	m_pvTempVecArr[i*(m_sYSize+1)+j].y = m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y;


	//   ִ ּҸ  Ų.
	if(pView->m_editHeightMax < m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y)
	{
		m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y = pView->m_editHeightMax;
	}

	if(pView->m_editHeightMin > m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y)
	{
		m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y = pView->m_editHeightMin;
	}

	// 07-05-17 by shkim,   Ͱ 
	SetVertexBlock( i, j );


}

void CBackground::SetVertexFlat(int i, int j)
{
	float highvalue;
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	highvalue = pView->m_editFlatRate;
// 2007-08-03 by dgwoo Ʒ  .
//	if(m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y > highvalue+pView->m_editFlatRate)
//	{
//		m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y -= highvalue;
//	}
//	else if(m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y < -highvalue+pView->m_editFlatRate)
//	{
//		m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y += highvalue;	
//	}
//	else
//	{
//		m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y = pView->m_editFlatRate;		
//	}
	m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y = highvalue;

	// 07-05-17 by shkim,   Ͱ 
	SetVertexBlock( i, j );
}

// 07-05-15 ~ 07-05-18 by shkim, smooth ٵ
void CBackground::SetVertexSmooth( int i, int j )
{	
	// 07-05-17 by shkim, ٵ     ++  ++

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	float highvalue = pView->m_editUpDownRate; //    

	BOOL bBase = GetClickCheck( i, j );

	BOOL bUp = GetClickCheck( i - 1, j );
	BOOL bLeft = GetClickCheck( i, j - 1 );
	BOOL bRight = GetClickCheck( i, j + 1 );
	BOOL bDown = GetClickCheck( i + 1, j );

	int nCount = 0; //   
	float fHeight = 0.0f; // ̰
	float fFirstHeight = 0.0f; // Ŭ ġ ġ
	float fAverage = 0.0;// հ

	if( bBase == FALSE )
	{
		return;
	}
	else
	{
		fHeight = m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y;
		fAverage += fHeight; //  ġ
		fFirstHeight = fHeight; //  ̰
		nCount++; // ġ   īƮ
	}


	if( bUp == TRUE )
	{
		fHeight = m_pTileVertexArray[ (i - 1) * (m_sYSize+1) + j ].pos.y;
		fAverage += fHeight;
		nCount++;
	}
	
	if( bLeft == TRUE )
	{
		fHeight = m_pTileVertexArray[ i * (m_sYSize+1) + (j - 1) ].pos.y;
		fAverage += fHeight;
		nCount++;
	}

	if( bRight == TRUE )
	{
		fHeight = m_pTileVertexArray[ i * (m_sYSize+1) + (j + 1) ].pos.y;
		fAverage += fHeight;
		nCount++;
	}

	if( bDown == TRUE )
	{
		fHeight = m_pTileVertexArray[ (i + 1) * (m_sYSize+1) + j ].pos.y;
		fAverage += fHeight;
		nCount++;
	}

	// nCount  3 ̻ ƴϸ ׳ 
	if( nCount < 3 )
	{
		return;
	}
	else
	{
		// հ
		fAverage /= nCount;

		if( fFirstHeight > fAverage )
		{
			m_pTileVertexArray[i * (m_sYSize+1) + j].pos.y += -(fFirstHeight - fAverage) * 1.0;
		}
		else if( fFirstHeight < fAverage )
		{
			m_pTileVertexArray[i * (m_sYSize+1) + j].pos.y += (fAverage - fFirstHeight) * 1.0f;
		}
		else 
		{
			return;
		}
	}

	// 07-05-17 by shkim,   Ͱ 
	SetVertexBlock( i, j );
}

BOOL CBackground::GetClickCheck( int nX, int nZ )
{
	// 2011-03-17 by jhAhnźȭ  ٵ Ҷ ͷ ǥ  -1 ϶ ִ밪 ̻϶     κ
	if ((nX < 0) || (nX > m_sXSize))return FALSE;
	if ((nZ < 0) || (nZ > m_sYSize))return FALSE;	
	//end 2011-03-17 by jhAhn źȭ  ٵ Ҷ ͷ ǥ  -1 ϶ Ǵ ִ밪 ̻϶     κ
	
	float fX = m_pTileVertexArray[nX*(m_sYSize+1)+nZ].pos.x;
	float fZ = m_pTileVertexArray[nX*(m_sYSize+1)+nZ].pos.z;
// 2007-10-30 by dgwoo 128*128 źȭ ۾̵ǰ 256*256 
// źȭ ۾ ȵ Ʒ ҽ ּó.
//	fX += ( ( (float)m_sXSize * 40.0f ) / 2.0f );// * 40.0f;
//	fZ += ( ( (float)m_sYSize * 40.0f ) / 2.0f );// * 40.0f;


	if( fX < 0.0f 
		|| fX >= ( m_sXSize * 40.0f ) 
		|| fZ < 0.0f 
		|| fZ >= ( m_sYSize * 40.0f ) )
	{
		return FALSE;
	}

	return TRUE;
}

void CBackground::SetVertexBlock( int i, int j )
{
	if(2*i-1 >= 0 && 2*i-1 < 2*m_sYSize+1 && 2*j-1 >= 0 && 2*j-1 < 2*m_sYSize+1)
	{
		m_pBlockVertexArray[(2*i-1)*(2*m_sYSize+1)+2*j-1].pos.y = 
			( m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y
			     + m_pTileVertexArray[(i-1)*(m_sYSize+1)+j-1].pos.y ) / 2.0f;
	}

	if(2*i-1 >= 0 && 2*i-1 < 2*m_sYSize+1 && 2*j >= 0 && 2*j < 2*m_sYSize+1)
	{
		m_pBlockVertexArray[(2*i-1)*(2*m_sYSize+1)+2*j].pos.y =
			( m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y
			     + m_pTileVertexArray[(i-1)*(m_sYSize+1)+j].pos.y) / 2.0f;
	}

	if(2*i >= 0 && 2*i < 2*m_sYSize+1 && 2*j-1 >= 0 && 2*j-1 < 2*m_sYSize+1)
	{
		m_pBlockVertexArray[2*i*(2*m_sYSize+1)+2*j-1].pos.y = 
			(m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y
			        + m_pTileVertexArray[(i)*(m_sYSize+1)+j-1].pos.y) / 2.0f;
	}

	if(2*i >= 0 && 2*i < 2*m_sYSize+1 && 2*j >= 0 && 2*j < 2*m_sYSize+1)
	{
		m_pBlockVertexArray[2*i*(2*m_sYSize+1)+2*j].pos.y = 
			m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y;
	}

	if(2*i >= 0 && 2*i < 2*m_sYSize+1 && 2*j+1 >= 0 && 2*j+1 < 2*m_sYSize+1)
	{
		m_pBlockVertexArray[2*i*(2*m_sYSize+1)+2*j+1].pos.y = 
			(m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y
			      + m_pTileVertexArray[(i)*(m_sYSize+1)+j+1].pos.y)/2.0f;
	}

	if(2*i+1 >= 0 && 2*i+1 < 2*m_sYSize+1 && 2*j >= 0 && 2*j < 2*m_sYSize+1)
	{
		m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+2*j].pos.y = 
			(m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y
			        + m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos.y)/2.0f;
	}

	if(2*i+1 >= 0 && 2*i+1 < 2*m_sYSize+1 && 2*j+1 >= 0 && 2*j+1 < 2*m_sYSize+1)
	{
		m_pBlockVertexArray[(2*i+1)*(2*m_sYSize+1)+2*j+1].pos.y =
			(m_pTileVertexArray[i*(m_sYSize+1)+j].pos.y
			        + m_pTileVertexArray[(i+1)*(m_sYSize+1)+j+1].pos.y)/2.0f;
	}


	//    ͸ ̿Ͽ Ground  Block Ÿ Ѵ.
	if(2*i-2 >=0 && 2*i-2< 2*m_sYSize && 2*j-2>=0 && 2*j-2<2*m_sYSize)
	{
		m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j-2].fGroundHeight = MinGroundHeight(2*i-2, 2*j-2);

		if(m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j-2].nUseBlockCount==0)
		{
			m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j-2].fBlockHeight = 
				             m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j-2].fGroundHeight;
		}
	}

	if(2*i-2 >=0 && 2*i-2< 2*m_sYSize && 2*j-1>=0 && 2*j-1<2*m_sYSize)
	{
		m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j-1].fGroundHeight = MinGroundHeight(2*i-2, 2*j-1);

		if(m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j-1].nUseBlockCount==0)
		{
			m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j-1].fBlockHeight = 
				        m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j-1].fGroundHeight;
		}
	}

	if(2*i-2 >=0 && 2*i-2< 2*m_sYSize && 2*j>=0 && 2*j<2*m_sYSize)
	{
		m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j].fGroundHeight = MinGroundHeight(2*i-2, 2*j);

		if(m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j].nUseBlockCount==0)
		{
			m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j].fBlockHeight = 
				       m_pBlockData[(2*i-2)*(2*m_sYSize)+2*j].fGroundHeight;
		}
	}

	if(2*i-1 >=0 && 2*i-1< 2*m_sYSize && 2*j-2>=0 && 2*j-2<2*m_sYSize)
	{
		m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j-2].fGroundHeight = MinGroundHeight(2*i-1, 2*j-2);

		if(m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j-2].nUseBlockCount==0)
		{
			m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j-2].fBlockHeight = 
				           m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j-2].fGroundHeight;
		}
	}

	if(2*i-1 >=0 && 2*i-1< 2*m_sYSize && 2*j-1>=0 && 2*j-1<2*m_sYSize)
	{
		m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j-1].fGroundHeight = MinGroundHeight(2*i-1, 2*j-1);

		if(m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j-1].nUseBlockCount==0)
		{
			m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j-1].fBlockHeight = 
				            m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j-1].fGroundHeight;
		}
	}

	if(2*i-1 >=0 && 2*i-1< 2*m_sYSize && 2*j>=0 && 2*j<2*m_sYSize)
	{
		m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j].fGroundHeight = MinGroundHeight(2*i-1, 2*j);

		if(m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j].nUseBlockCount==0)
		{
			m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j].fBlockHeight = 
				               m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j].fGroundHeight;
		}
	}

	if( 2*i-1>=0 && 2*i-1< 2*m_sYSize && 2*j+1>=0 && 2*j+1<2*m_sYSize)
	{
		m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j+1].fGroundHeight = MinGroundHeight(2*i-1, 2*j+1);

		if(m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j+1].nUseBlockCount==0)
		{
			m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j+1].fBlockHeight = 
				              m_pBlockData[(2*i-1)*(2*m_sYSize)+2*j+1].fGroundHeight;
		}
	}

	if( 2*i>=0 && 2*i< 2*m_sYSize && 2*j-2>=0 && 2*j-2<2*m_sYSize)
	{
		m_pBlockData[(2*i)*(2*m_sYSize)+2*j-2].fGroundHeight = MinGroundHeight(2*i, 2*j-2);

		if(m_pBlockData[(2*i)*(2*m_sYSize)+2*j-2].nUseBlockCount==0)
		{
			m_pBlockData[(2*i)*(2*m_sYSize)+2*j-2].fBlockHeight = 
				               m_pBlockData[(2*i)*(2*m_sYSize)+2*j-2].fGroundHeight;
		}
	}

	if(2*i >=0 && 2*i< 2*m_sYSize && 2*j-1>=0 && 2*j-1<2*m_sYSize)
	{
		m_pBlockData[(2*i)*(2*m_sYSize)+2*j-1].fGroundHeight = MinGroundHeight(2*i, 2*j-1);

		if(m_pBlockData[(2*i)*(2*m_sYSize)+2*j-1].nUseBlockCount==0)
		{
			m_pBlockData[(2*i)*(2*m_sYSize)+2*j-1].fBlockHeight = 
				                 m_pBlockData[(2*i)*(2*m_sYSize)+2*j-1].fGroundHeight;
		}
	}

	if(2*i >=0 && 2*i< 2*m_sYSize && 2*j>=0 && 2*j<2*m_sYSize)
	{
		m_pBlockData[(2*i)*(2*m_sYSize)+2*j].fGroundHeight = MinGroundHeight(2*i, 2*j);

		if(m_pBlockData[(2*i)*(2*m_sYSize)+2*j].nUseBlockCount==0)
		{
			m_pBlockData[(2*i)*(2*m_sYSize)+2*j].fBlockHeight = 
				                 m_pBlockData[(2*i)*(2*m_sYSize)+2*j].fGroundHeight;
		}
	}

	if(2*i >=0 && 2*i< 2*m_sYSize && 2*j+1>=0 && 2*j+1<2*m_sYSize)
	{
		m_pBlockData[(2*i)*(2*m_sYSize)+2*j+1].fGroundHeight = MinGroundHeight(2*i, 2*j+1);

		if(m_pBlockData[(2*i)*(2*m_sYSize)+2*j+1].nUseBlockCount==0)
		{
			m_pBlockData[(2*i)*(2*m_sYSize)+2*j+1].fBlockHeight = 
				               m_pBlockData[(2*i)*(2*m_sYSize)+2*j+1].fGroundHeight;
		}
	}

	if(2*i+1 >=0 && 2*i+1< 2*m_sYSize && 2*j-1>=0 && 2*j-1<2*m_sYSize)
	{
		m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j-1].fGroundHeight = MinGroundHeight(2*i+1, 2*j-1);

		if(m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j-1].nUseBlockCount==0)
		{
			m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j-1].fBlockHeight = 
				                m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j-1].fGroundHeight;
		}
	}

	if(2*i+1 >=0 && 2*i+1< 2*m_sYSize && 2*j>=0 && 2*j<2*m_sYSize)
	{
		m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j].fGroundHeight = MinGroundHeight(2*i+1, 2*j);

		if(m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j].nUseBlockCount==0)
		{
			m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j].fBlockHeight = 
				                 m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j].fGroundHeight;
		}
	}

	if(2*i+1 >=0 && 2*i+1< 2*m_sYSize && 2*j+1>=0 && 2*j+1<2*m_sYSize)
	{
		m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j+1].fGroundHeight = MinGroundHeight(2*i+1, 2*j+1);

		if(m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j+1].nUseBlockCount==0)
		{
			m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j+1].fBlockHeight = 
				              m_pBlockData[(2*i+1)*(2*m_sYSize)+2*j+1].fGroundHeight;
		}
	}

	int a, b;
	for(a=-1;a<2;a++)
	{
		for(b=-1;b<2;b++)
		{
			if(i+a >=0 && i+a <= m_sXSize && j+b >=0 && j+b <= m_sYSize)
			{
				SetNormal(i+a,j+b);
			}
		}
	}
}


float CBackground::MinGroundHeight(int i, int j)
{
	float fHeight;

	fHeight = m_pBlockVertexArray[(i)*(2*m_sYSize+1)+j].pos.y;

	if(fHeight > m_pBlockVertexArray[(i+1)*(2*m_sYSize+1)+j].pos.y)
	{
		fHeight = m_pBlockVertexArray[(i+1)*(2*m_sYSize+1)+j].pos.y;
	}

	if(fHeight > m_pBlockVertexArray[(i)*(2*m_sYSize+1)+j+1].pos.y)
	{
		fHeight = m_pBlockVertexArray[(i)*(2*m_sYSize+1)+j+1].pos.y;
	}

	if(fHeight > m_pBlockVertexArray[(i+1)*(2*m_sYSize+1)+j+1].pos.y)
	{
		fHeight = m_pBlockVertexArray[(i+1)*(2*m_sYSize+1)+j+1].pos.y;
	}

	return fHeight;
}

void CBackground::SetNormal(int i, int j)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	D3DXVECTOR3 vTemp = D3DXVECTOR3(0,0,0);
	D3DXVECTOR3 vTemp2 = D3DXVECTOR3(0,0,0);
	D3DXVECTOR3 vTemp3 = D3DXVECTOR3(0,0,0);
	D3DXVECTOR3 vTemp4 = D3DXVECTOR3(0,0,0);

	if((i-1) >= 0 && j >= 0 && (i-1) >= 0 && j-1 >= 0 )
	{
		vTemp3 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i-1)*(m_sYSize+1)+j].pos;
		vTemp4 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i-1)*(m_sYSize+1)+j-1].pos;
		D3DXVec3Cross(&vTemp2,&vTemp3,&vTemp4);
		D3DXVec3Normalize(&vTemp2,&-vTemp2);
		vTemp+=vTemp2;
	}
	if((i-1) >= 0 && j-1 >= 0 && (i) >= 0 && j-1 >= 0)
	{
		vTemp3 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i-1)*(m_sYSize+1)+j-1].pos;
		vTemp4 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i)*(m_sYSize+1)+j-1].pos;
		D3DXVec3Cross(&vTemp2,&vTemp3,&vTemp4);
		D3DXVec3Normalize(&vTemp2,&-vTemp2);
		vTemp+=vTemp2;
	}
	if((i) >= 0 && j-1 >= 0 && (i+1) <= m_sXSize && j <= m_sYSize)
	{
		vTemp3 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i)*(m_sYSize+1)+j-1].pos;
		vTemp4 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos;
		D3DXVec3Cross(&vTemp2,&vTemp3,&vTemp4);
		D3DXVec3Normalize(&vTemp2,&-vTemp2);
		vTemp+=vTemp2;
	}
	if((i+1) <= m_sXSize && j <= m_sYSize && (i+1) <= m_sXSize && j+1 <= m_sYSize)
	{
		vTemp3 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos;
		vTemp4 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i+1)*(m_sYSize+1)+j+1].pos;
		D3DXVec3Cross(&vTemp2,&vTemp3,&vTemp4);
		D3DXVec3Normalize(&vTemp2,&-vTemp2);
		vTemp+=vTemp2;
	}
	if((i+1) <= m_sXSize && j+1 <= m_sYSize && (i) <= m_sXSize && j+1 <= m_sYSize)
	{
		vTemp3 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i+1)*(m_sYSize+1)+j+1].pos;
		vTemp4 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i)*(m_sYSize+1)+j+1].pos;
		D3DXVec3Cross(&vTemp2,&vTemp3,&vTemp4);
		D3DXVec3Normalize(&vTemp2,&-vTemp2);
		vTemp+=vTemp2;
	}
	if((i) <= m_sXSize && j+1 <= m_sYSize && (i-1) >= 0 && j >= 0)
	{
		vTemp3 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i)*(m_sYSize+1)+j+1].pos;
		vTemp4 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos - m_pTileVertexArray[(i-1)*(m_sYSize+1)+j].pos;
		D3DXVec3Cross(&vTemp2,&vTemp3,&vTemp4);
		D3DXVec3Normalize(&vTemp2,&-vTemp2);
		vTemp+=vTemp2;
	}
	D3DXVec3Normalize(&vTemp,&vTemp);
	m_pTileVertexArray[i*(m_sYSize+1)+j].nor = vTemp;
}

BOOL CBackground::IntersectTriangle( const D3DXVECTOR3& orig,
                                       const D3DXVECTOR3& dir, D3DXVECTOR3& v0,
                                       D3DXVECTOR3& v1, D3DXVECTOR3& v2,
                                       FLOAT* t, FLOAT* u, FLOAT* v )
{
    // Find vectors for two edges sharing vert0
    D3DXVECTOR3 edge1 = v1 - v0;
    D3DXVECTOR3 edge2 = v2 - v0;

    // Begin calculating determinant - also used to calculate U parameter
    D3DXVECTOR3 pvec;
    D3DXVec3Cross( &pvec, &dir, &edge2 );

    // If determinant is near zero, ray lies in plane of triangle
    FLOAT det = D3DXVec3Dot( &edge1, &pvec );

    D3DXVECTOR3 tvec;
    if( det > 0 )
    {
        tvec = orig - v0;
    }
    else
    {
        tvec = v0 - orig;
        det = -det;
    }

    if( det < 0.0001f )
        return FALSE;

    // Calculate U parameter and test bounds
    *u = D3DXVec3Dot( &tvec, &pvec );
    if( *u < 0.0f || *u > det )
        return FALSE;

	// Prepare to test V parameter
	D3DXVECTOR3 qvec;
	D3DXVec3Cross( &qvec, &tvec, &edge1 );

	// Calculate V parameter and test bounds
    *v = D3DXVec3Dot( &dir, &qvec );
    if( *v < 0.0f || *u + *v > det )
        return FALSE;

	// Calculate t, scale parameters, ray intersects triangle
	*t = D3DXVec3Dot( &edge2, &qvec );
	FLOAT fInvDet = 1.0f / det;
	*t *= fInvDet;
	*u *= fInvDet;
	*v *= fInvDet;

    return TRUE;
}

int	CBackground::CheckTile1(D3DXVECTOR3 p1,D3DXVECTOR3 p2,D3DXVECTOR3 p3,D3DXVECTOR3 vPickPos)
{
	// 07-05-13 by shkim, ּ ,    üũش.(Ʒ ﰢ üũ)

	float fLength1,fLength2,fLength3;
	fLength1=D3DXVec3Length( &( p1 - vPickPos ) );
	fLength2=D3DXVec3Length( &( p2 - vPickPos ) );
	fLength3=D3DXVec3Length( &( p3 - vPickPos ) );

	if( fLength1 < fLength2 )
	{
		if( fLength1 < fLength3 )
		{
			return 0; // 0   .
		}
		else
		{
			return 2; // 2  .
		}
	}
	else
	{
		if( fLength2 < fLength3 )
		{
			return 1; // 1  .
		}
		else
		{
			return 2;
		}
	}
}

int	CBackground::CheckTile2(D3DXVECTOR3 p1,D3DXVECTOR3 p2,D3DXVECTOR3 p3,D3DXVECTOR3 vPickPos)
{
	// 07-05-13 by shkim, ּ ,    üũش.( ﰢ üũ)

	float fLength1,fLength2,fLength3;
	fLength1=D3DXVec3Length( &( p1 - vPickPos ) );
	fLength2=D3DXVec3Length( &( p2 - vPickPos ) );
	fLength3=D3DXVec3Length( &( p3 - vPickPos ) );
	if( fLength1 < fLength2 )
	{
		if( fLength1 < fLength3 )
		{
			return 0; // 0  .
		}
		else
		{
			return 3; // 3  .
		}
	}
	else
	{
		if( fLength2 < fLength3 )
		{
			return 2; // 2  .
		}
		else
		{
			return 3;
		}
	}
}

void CBackground::InsertTile(CString strFilename)
{
	char buf[256];
	wsprintf(buf,strFilename);
	if(m_ninsertTileFileCont<MAX_BASETILERANDOM_NUM)
	{
		D3DUtil_CreateTexture( g_pD3dDev, buf, &m_pTileTexture[m_nTexUseNumber][m_ninsertTileFileCont++] ); 
	}
	else
	{
		m_ninsertTileFileCont = 0;
		m_nTexUseNumber++;
		D3DUtil_CreateTexture( g_pD3dDev, buf, &m_pTileTexture[m_nTexUseNumber][m_ninsertTileFileCont++] ); 
	}
}

void CBackground::InsertTileBase(CString strFilename)
{
	char buf[256];
	wsprintf(buf,strFilename);
//	D3DUtil_CreateTexture( g_pD3dDev, buf, &m_pBaseTexture[m_ninsertTileFileBaseCont++] ); 
}
void CBackground::ReInitMap(MapInfo * info)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
/*
	CObjectChild * pChild = (CObjectChild *)m_pChild;
	while(pChild)
	{
		pChild->m_bUsing = FALSE;
		pChild = (CObjectChild *)pChild->m_pNext;
	}
*/
	
	map<INT,CAtumNode *>::iterator it = m_mapObjectData.begin();
	while(it != m_mapObjectData.end())
	{
		CAtumNode * pNode = (CAtumNode *)it->second;
		SAFE_DELETE(pNode);
		it++;
	}
	m_mapObjectData.clear();

	if(info->m_nObjectNumber > 0)
		m_nObjectNumber = info->m_nObjectNumber;
	else
		m_nObjectNumber = 0;
	int i,type;
	int cont = 0;
	CObjectChild * pObject = NULL;
	for(i=0;i<m_nObjectNumber;i++)
	{
		if(pView->m_pObjectInfo[i].m_dwObjType < 10000 && 
			pView->m_pObjectInfo[i].m_dwObjType >= pView->m_nObjectNormalCont)
		{
			type = pView->m_pObjectInfo[i].m_dwObjType - pView->m_nObjectNormalCont + 10000;
		}
		else
		{
			type = pView->m_pObjectInfo[i].m_dwObjType;
		}
		if(pView->m_pObjectInfo[i].vPos.x > 0.0f && pView->m_pObjectInfo[i].vPos.x < m_sXSize*40.0f 
			&& pView->m_pObjectInfo[i].vPos.z > 0.0f && pView->m_pObjectInfo[i].vPos.z < m_sYSize*40.0f)
		{
//			pObject = new CObjectChild(type,pView->m_pObjectInfo[i].bRenderType,
//				pView->m_pObjectInfo[i].m_vPos,pView->m_pObjectInfo[i].m_vVel,pView->m_pObjectInfo[i].m_vUp,pView->m_pObjectInfo[i].bCheckTick);
			pObject = new CObjectChild(pView->m_pObjectInfo[i],pView->m_pObjectInfoDetail[i]);
			if(!pObject->m_bUsing)
			{
				cont++;
				delete pObject;
			}
			else
			{
				InsertObject(pObject);
				pView->ResetObjectList();
//				memcpy(&pObject->m_info,&pView->m_pObjectInfoDetail[i],sizeof(MAPOBJECTINFODETAIL));
			}
		}
		else
		{
			cont++;
		}
	}
	m_nObjectNumber -= cont;
//	Restore(0,0,m_sYSize);

	_chdir(pView->m_strCurrentDir);

	CString strPath;
	strPath.Format(".\\%s\\%s\\%s.DDS",pView->m_pWorkspace->workspaceName,m_projectInfo.m_strProjectName,m_projectInfo.m_strProjectName);

	SetAllTexture(strPath);

	
	Restore();
}

void CBackground::LoadTex(int usetex,TEXFILEINFO info)
{
	SAFE_RELEASE(m_pCreateTexture[usetex]);
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	char strpath[256];
	_chdir(pView->m_strCurrentDir);
	wsprintf(strpath,".\\Tile\\%d\\128\\%s.bmp",m_projectInfo.m_useTileSetIndex,info.name);
//	wsprintf(strpath,".\\%s\\%s",m_projectInfo.m_strProjectName,info.name);
	D3DUtil_CreateTexture( g_pD3dDev,strpath, &m_pCreateTexture[usetex] );

	memcpy(&m_pTexFileInfo[usetex],&info,sizeof(info));
	m_nCreateTexNumber = usetex + 1;
}

void CBackground::SetWater(int a, int b)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int dis = (int)(pView->m_editWater/2);
	int height = pView->m_editWaterHeight+5;
	for(int i=a-dis;i<a+dis;i++)
	{
		for(int j=b-dis;j<b+dis;j++)
		{
			if(i>=0 && i<m_sXSize && j>=0 && j< m_sYSize)
			{
				if((m_pTileVertexArray[i*(m_sYSize+1)+(j)].pos.y < height) ||
				(m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j)].pos.y < height) ||
				(m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos.y < height) ||
				(m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos.y < height))
				{
					m_pTileInfo[i*m_sYSize+j].waterType = pView->m_dwWaterType;
					m_pTileInfo[i*m_sYSize+j].waterHeight = pView->m_editWaterHeight;
					m_pTileInfo[i*m_sYSize+j].waterTexNumber = rand()%10;
//					m_pEventInfo[i*m_sYSize+j].m_bUseWater = TRUE;
					m_pEventInfo[i*m_sYSize+j].m_dwWaterType = pView->m_dwWaterType;
				}
				else
				{
					m_pTileInfo[i*m_sYSize+j].waterType = 0;
//					m_pEventInfo[i*m_sYSize+j].m_bUseWater = FALSE;
					m_pEventInfo[i*m_sYSize+j].m_dwWaterType = 0;
				}
			}
		}
	}
}
void CBackground::SetBaseTile(int num)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int i,ranTex,index,temp;
	for(i=0;i<m_sXSize*m_sYSize;i++)
	{
//		ranTex = rand()%10;
		ranTex = rand()%BASETILE_CENTER_NUM;
		m_pTileInfo[i].texTileDirect1=num;
		m_pTileInfo[i].texTileDirect2=num;
		m_pTileInfo[i].texTileDirect3=num;
		m_pTileInfo[i].texTileDirect4=num;
		m_pTileInfo[i].useTexNumber = num;
		m_pTileInfo[i].useBaseTexNumber = num;
		m_pTileInfo[i].ranTexNumber = ranTex;
		m_pTileInfo[i].bBaseTile = TRUE;
		temp = ranTex-1;
		if(temp<0)
			temp = 2;
		if(m_pTileTexture[m_pTileInfo[i].useBaseTexNumber][temp] && m_pTileTexture[m_pTileInfo[i].useBaseTexNumber][m_pTileInfo[i].ranTexNumber])
		{
			index = TextureCreate(m_pTileTexture[m_pTileInfo[i].useBaseTexNumber][temp],
				m_pTileTexture[m_pTileInfo[i].useBaseTexNumber][m_pTileInfo[i].ranTexNumber],i);
			m_pTileInfo[i].useTexNumber = index;
		}
	}
}

void CBackground::SaveMiniMap()
{
	int size;
	if(m_projectInfo.m_sYSize > 32 && m_projectInfo.m_sYSize <= 64)
	{
		size = 64*8;
	}
	else if(m_projectInfo.m_sYSize > 64 && m_projectInfo.m_sYSize <= 128)
	{
		size = 128*8;
	}
	else if(m_projectInfo.m_sYSize > 128 && m_projectInfo.m_sYSize <= 256)
	{
		size = 256*8;
	}
	else if(m_projectInfo.m_sYSize > 256 && m_projectInfo.m_sYSize <= 512)
	{
		size = 512*8;
	}
	LPDIRECT3DTEXTURE8 tempTex,tempTex2;
	LPDIRECT3DTEXTURE8 ptex1;
    D3DLOCKED_RECT d3dlr,d3dlr1,d3dlr2;
	int m,n;
	char buf[128];
	wsprintf(buf,"mappicture%d.tga",size);
	D3DUtil_CreateTexture( g_pD3dDev,buf, &tempTex ) ;

	g_pD3dDev->CreateTexture( size, size, 1,
                                      0, D3DFMT_A4R4G4B4,
                                    D3DPOOL_MANAGED, &tempTex );

	tempTex->LockRect( 0, &d3dlr, 0, 0 );

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	D3DXVECTOR3 vPos;
	vPos = D3DXVECTOR3(0,500,0);
	D3DXVECTOR3 v,orig,dir;//,v2;
	FLOAT fBary1, fBary2;
	FLOAT fDist;
	BYTE bRed,bGreen, bBlue;
	BYTE bRed2,bGreen2, bBlue2;
	DWORD bAlpha; // 4-bit measure of pixel intensity
	int i,j;
	DWORD* pDst,*pSrc;
	DWORD* pDstRow = (DWORD*)d3dlr.pBits;
	for(m = 0; m < m_projectInfo.m_sXSize; m++)
	{
		for(n = 0; n < m_projectInfo.m_sYSize; n++)
		{
			pDst = (DWORD*)pDstRow;
			int k = 8*m*size + 8*n;
			pDst += k;
			ptex1 = m_pCreateTexture[m_pTileInfo[m*m_projectInfo.m_sYSize + n].useTexNumber];
			ptex1->LockRect( 0, &d3dlr1, 0, 0 );
			DWORD* pSrcRow = (DWORD*)d3dlr1.pBits;
			pSrc = (DWORD*)pSrcRow;
			for(int y=0; y < 128; )
			{
				for(int x=0; x < 128; )
				{
					if(m_pTileInfo[m*m_projectInfo.m_sYSize + n].waterType)
					{
						vPos.x = m*40 + 40*x/128.0f;
						vPos.z = n*40 + 40*y/128.0f;
						orig = vPos;
						dir = D3DXVECTOR3(0,-1,0);
						bool bWater = false;
						if(m >=0 && m < m_projectInfo.m_sYSize && n >=0 && n < m_projectInfo.m_sYSize)
						{
							if(IntersectTriangle(orig,dir,m_pTileVertexArray[m*(m_sYSize+1)+n].pos,
								m_pTileVertexArray[m*(m_sYSize+1)+(n+1)].pos,
								m_pTileVertexArray[(m+1)*(m_sYSize+1)+(n+1)].pos,
								&fDist, &fBary1, &fBary2 ))
							{
								v = orig + dir*fDist;
								if(v.y < m_projectInfo.m_fWaterHeight)
									bWater = true;
							}
							if(IntersectTriangle(orig,dir,m_pTileVertexArray[m*(m_sYSize+1)+n].pos,
								m_pTileVertexArray[(m+1)*(m_sYSize+1)+(n+1)].pos,
								m_pTileVertexArray[(m+1)*(m_sYSize+1)+n].pos,
								&fDist, &fBary1, &fBary2 ))
							{
								v = orig + dir*fDist;
								if(v.y < m_projectInfo.m_fWaterHeight)
									bWater = true;
							}
						}
						if(bWater)
						{
//							*pDst = D3DCOLOR_ARGB(0x00,0,0,255);
							bAlpha = 150;
							bRed2 = 0;
							bGreen2 = 0;
							bBlue2 = 255;
							bRed2 = bRed2 * bAlpha / 255;
							bGreen2 = bGreen2 * bAlpha / 255;
							bBlue2 = bBlue2 * bAlpha / 255;

							bRed = (BYTE)(*pSrc  >> 16);
							bGreen = (BYTE)(*pSrc  >> 8);
							bBlue = (BYTE)(*pSrc);
							bRed = bRed * (255-bAlpha) / 255;
							bGreen = bGreen * (255-bAlpha) / 255;
							bBlue = bBlue * (255-bAlpha) / 255;
							*pDst = D3DCOLOR_ARGB(0x00,bRed,bGreen,bBlue) + D3DCOLOR_ARGB(0xFF,bRed2,bGreen2,bBlue2);
						}
						else
							*pDst = (DWORD)((*pSrc));
					}
					else
					{
						*pDst = (DWORD)((*pSrc));
					}
					pSrc+= 16;
					pDst += size;
					x += 16;
				}
				y += 16;
				pSrc += 128*15;
				pDst = (DWORD*)pDstRow;
				k = 8*m*size + 8*n + y/16;
				pDst += k;
			}
			ptex1->UnlockRect(0);
		}
	}
	// Done updating texture, so clean up used objects
	tempTex->UnlockRect(0);

	strcpy(buf,"MiniMap.bmp");
	char strpathtexture[256];
	_chdir(pView->m_strCurrentDir);
	wsprintf(strpathtexture,".\\%s\\%s\\%s",pView->m_pWorkspace->workspaceName,m_projectInfo.m_strProjectName,buf);
	D3DXSaveTextureToFile(strpathtexture,D3DXIFF_BMP,tempTex,NULL);

	///////////////////////////////////  Ÿ ׸ Ϸ ϱ 2  
	/////////////////////////////////// Ʋ̺  Ѱ   
	/////////////////////////////////// 256 Į ü̼õ  
	wsprintf(buf,"mappicture%d.tga",size);
	D3DUtil_CreateTexture( g_pD3dDev,buf, &tempTex2 ) ;

	vPos = D3DXVECTOR3(1,500,1);
	tempTex->LockRect( 0, &d3dlr, 0, 0 );
	tempTex2->LockRect( 0, &d3dlr2, 0, 0 );
	pDstRow = (DWORD*)d3dlr.pBits;
	pDst = (DWORD*)pDstRow;
	DWORD* pDstRow2 = (DWORD*)d3dlr2.pBits;
	DWORD* pDst2 = (DWORD*)pDstRow2;
	for(m = 0; m < size;m++)
	{
		for(n = 0; n < size;n++)
		{
			int height = 0;
			bRed = height;
			bGreen = height;
			bBlue = height;
			bRed2 = height;
			bGreen2 = height;
			bBlue2 = height;
			i = (int)(vPos.x/40.0f);
			j = (int)(vPos.z/40.0f);
			orig = vPos;
			dir = D3DXVECTOR3(0,-1,0);

			if(i >=0 && i < m_projectInfo.m_sYSize && j >=0 && j < m_projectInfo.m_sYSize)
			{
				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
					m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos,
					m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,
					&fDist, &fBary1, &fBary2 ))
				{
					v = orig + dir*fDist;
//					height = (int)(v.y+100.0f);
					height = (int)((m_projectInfo.m_fHeightMax - v.y)/1.5f);
					if(v.y >= m_projectInfo.m_fHeightMax)
					{
						bRed = 0;
						bGreen = 255;
						bBlue = 0;
					}
					else if(v.y <= m_projectInfo.m_fHeightMin)
					{
						bRed = 255;
						bGreen = 0;
						bBlue = 0;
					}
					else
					{
						bRed = height;
						bGreen = height;
						bBlue = height;
					}
					if(height<0)
					{
						bRed2 = 0;
						bGreen2 = 0;
						bBlue2 = 0;
					}
					else if(height>255)
					{
						bRed2 = 255;
						bGreen2 = 255;
						bBlue2 = 255;
					}
					else
					{
						bRed2 = height;
						bGreen2 = height;
						bBlue2 = height;
					}
				}
				if(IntersectTriangle(orig,dir,m_pTileVertexArray[i*(m_sYSize+1)+j].pos,
					m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos,
					m_pTileVertexArray[(i+1)*(m_sYSize+1)+j].pos,
					&fDist, &fBary1, &fBary2 ))
				{
					v = orig + dir*fDist;
					height = (int)((m_projectInfo.m_fHeightMax - v.y)/1.5f);
					if(v.y >= m_projectInfo.m_fHeightMax)
					{
						bRed = 0;
						bGreen = 255;
						bBlue = 0;
					}
					else if(v.y <= m_projectInfo.m_fHeightMin)
					{
						bRed = 255;
						bGreen = 0;
						bBlue = 0;
					}
					else
					{
						bRed = height;
						bGreen = height;
						bBlue = height;
					}
					if(height<0)
					{
						bRed2 = 0;
						bGreen2 = 0;
						bBlue2 = 0;
					}
					else if(height>255)
					{
						bRed2 = 255;
						bGreen2 = 255;
						bBlue2 = 255;
					}
					else
					{
						bRed2 = height;
						bGreen2 = height;
						bBlue2 = height;
					}
				}
			}
			*pDst = D3DCOLOR_ARGB(0x00,bRed,bGreen,255);
			*pDst2 = D3DCOLOR_ARGB(0x00,bRed2,bGreen2,255);
			pDst++;
			pDst2++;
			vPos.z += 5;
		}
		vPos.x += 5;
		vPos.z = 1;
	}
	
	// Done updating texture, so clean up used objects
	tempTex2->UnlockRect(0);
	tempTex->UnlockRect(0);

	strcpy(buf,"MiniMapHeight.bmp");
	_chdir(pView->m_strCurrentDir);
	wsprintf(strpathtexture,".\\%s\\%s\\%s",pView->m_pWorkspace->workspaceName,m_projectInfo.m_strProjectName,buf);
	D3DXSaveTextureToFile(strpathtexture,D3DXIFF_BMP,tempTex,NULL);
	strcpy(buf,"MiniMap256.bmp");
	_chdir(pView->m_strCurrentDir);
	wsprintf(strpathtexture,".\\%s\\%s\\%s",pView->m_pWorkspace->workspaceName,m_projectInfo.m_strProjectName,buf);
	D3DXSaveTextureToFile(strpathtexture,D3DXIFF_BMP,tempTex2,NULL);

	SAFE_RELEASE(tempTex);
	SAFE_RELEASE(tempTex2);
}
// ׸Ϸ  Ÿ ϱ
// by dhkwon 20100727  
/*void CBackground::SetHeightData(CString str)
{
	int size;
	if(m_projectInfo.m_sYSize > 128 && m_projectInfo.m_sYSize <= 256)
	{
		size = 256;
	}
	else if(m_projectInfo.m_sYSize > 64 && m_projectInfo.m_sYSize <= 128)
	{
		size = 128;
	}
	else if(m_projectInfo.m_sYSize > 32 && m_projectInfo.m_sYSize <= 64)
	{
		size = 64;
	}

	char buf[256];
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	_chdir(pView->m_strCurrentDir);
	wsprintf(buf,".\\heightmap\\%s",str);

	LPDIRECT3DTEXTURE8 tempTex;
	D3DLOCKED_RECT d3dlr;
	DWORD* pDstRow;
	DWORD* pDst;
	int m,n;
	D3DUtil_CreateTexture( g_pD3dDev,buf, &tempTex ) ;

	tempTex->LockRect( 0, &d3dlr, 0, 0 );
	pDstRow = (DWORD*)d3dlr.pBits;
	pDst = (DWORD*)pDstRow;
	for(m = 0; m < size;m++)
	{
		if(m <= m_projectInfo.m_sXSize)
		{
			for(n = 0; n < size;n++)
			{
				if(n <= m_projectInfo.m_sYSize)
				{
					int k = m*(m_projectInfo.m_sYSize+1) + n;
					DWORD color = (DWORD)(*pDst & 0x000000FF);
					if(color < 0x00000055)
						m_pTileVertexArray[k].pos.y = -30.0f;
					else if(color < 0x000000AA)
						m_pTileVertexArray[k].pos.y = 0.0f;
					else
						m_pTileVertexArray[k].pos.y = 50.0f;
					pDst++;
				}
				else
				{
					pDst = (DWORD*)pDstRow;
					pDst += (m+1)*size;
					n = size;
				}
			}
		}
	}
	// Done updating texture, so clean up used objects
	tempTex->UnlockRect(0);
	SAFE_RELEASE(tempTex);
	for(m = 0; m < m_projectInfo.m_sXSize;m++)
	{
		for(n = 0; n < m_projectInfo.m_sYSize;n++)
		{
			SetNormal(m,n);
		}
	}
}
*/
void CBackground::SetHeightData(CString strPath,int base,int max)
{
	float fHeightRate = max/256.0f;
//	int size = 16;
//	if(m_projectInfo.m_sYSize == 512) // by dhkwon 20100712, heightmap 512 
//	{
//		size = 513;
//	}
//	else if(m_projectInfo.m_sYSize >= 256 && m_projectInfo.m_sYSize < 512)
//	{
//		size = 512;
//	}
//	else if(m_projectInfo.m_sYSize >= 128 && m_projectInfo.m_sYSize < 256)
//	{
//		size = 256;
//	}
//	else if(m_projectInfo.m_sYSize >= 64 && m_projectInfo.m_sYSize < 128)
//	{
//		size = 128;
//	}
//	else if(m_projectInfo.m_sYSize >= 32 && m_projectInfo.m_sYSize < 64)
//	{
//		size = 64;
//	}

//	char buf[256];
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
//	_chdir(pView->m_strCurrentDir);
//	wsprintf(buf,".\\heightmap\\%s",str);

	LPDIRECT3DTEXTURE8 tempTex;
	D3DLOCKED_RECT d3dlr;
	DWORD* pDstRow;
	DWORD* pDst;
	int m,n;
//	D3DUtil_CreateTexture( g_pD3dDev,buf, &tempTex ) ;
	D3DUtil_CreateTexture( g_pD3dDev,(LPTSTR)(LPCTSTR)strPath, &tempTex ) ;

	D3DSURFACE_DESC desc;
	tempTex->GetLevelDesc( 0, &desc);
//	if(m_projectInfo.m_sXSize > desc.Width || m_projectInfo.m_sYSize > desc.Height)
//	{
//		char buf[1024];
//		wsprintf(buf, "Heightmap ̹  üũϼ. (W:%d, H=%d)", desc.Width, desc.Height);
//		AfxMessageBox(buf,IDOK);
//		return;
//	}

	tempTex->LockRect( 0, &d3dlr, 0, 0 );
	pDstRow = (DWORD*)d3dlr.pBits;
	pDst = (DWORD*)pDstRow;
	
/*	for(m = 0; m <= size;m++)
	{
		if(m <= m_projectInfo.m_sXSize)
		{
			for(n = 0; n <= size;n++)
			{
				if(n <= m_projectInfo.m_sYSize)
				{
					int k = m*(m_projectInfo.m_sYSize+1) + n;
					DWORD color = (DWORD)(*pDst & 0x000000FF);
					m_pTileVertexArray[k].pos.y = color*fHeightRate + base;
					pDst++;
				}
				else
				{
					pDst = (DWORD*)pDstRow;
					pDst += (m+1)*size;
					n = size;
				}
			}
		}
		else 
		{
			break;
		}
	}
*/	
	// by dhkwon 100727 hight map size  ǵ (Ʈ U,V )
	for(int i=0; i <= m_projectInfo.m_sYSize; i++)
	{
		for( int j=0; j <= m_projectInfo.m_sXSize; j++)
		{
			float u = ((float)j)/((float)m_projectInfo.m_sXSize);
			float v = ((float)i)/((float)m_projectInfo.m_sYSize);
			int x = (desc.Width-1) * u;
			int y = (desc.Height-1) * v;
			DWORD color = (DWORD)(pDst[x+y*desc.Width] & 0x000000FF);
			m_pTileVertexArray[(m_projectInfo.m_sXSize+1)*i+j].pos.y = color*fHeightRate + base;
			//DWORD color = (DWORD)(pDst[(desc.Width+1)*i+j] & 0x000000FF);
			//m_pTileVertexArray[(m_projectInfo.m_sXSize+1)*i+j].pos.y = color*fHeightRate + base;
			
		}
	}
	// end by dhkwon 100727 hight map size  ǵ (Ʈ U,V )

	// Done updating texture, so clean up used objects
	tempTex->UnlockRect(0);
	SAFE_RELEASE(tempTex);
	for(m = 0; m < m_projectInfo.m_sXSize;m++)
	{
		for(n = 0; n < m_projectInfo.m_sYSize;n++)
		{
			SetNormal(m,n);
		}
	}
	Restore();		// by dhkwon 100727 ߰

}

//ysw4_23 : O2Ʈ ´.
void CBackground::InsertObject(CObjectChild * pObject)
{
	int nPosX,nPosZ,nIndex;
	nPosX = (int)(pObject->m_vPos.x/40.0f);
	nPosZ = (int)(pObject->m_vPos.z/40.0f);
	nIndex = nPosX*1000 + nPosZ;
	map<INT, CAtumNode *>::iterator it = m_mapObjectData.find(nIndex);
	if(it != m_mapObjectData.end())
	{
		((CAtumNode *)it->second)->AddChild(pObject);
	}
	else
	{
		CAtumNode * pNode = new CAtumNode();
		m_mapObjectData[nIndex] = pNode;
		pNode->AddChild((CAtumNode *)pObject);
		
	}
}

BOOL CBackground::SetAllTexture(CString str)
{
	SAFE_RELEASE(m_pBackTexture);
	D3DUtil_CreateTexture( g_pD3dDev,(LPTSTR)(LPCTSTR)str, &m_pBackTexture );
	if(m_pBackTexture)
	{
		return TRUE;
	}
	return FALSE;
}

// 07-05-07 by shkim, Brush ׸
bool CBackground::DrawPickPos( int Count, float size, D3DCOLOR Col, D3DXVECTOR3 vPos )
{
	LPDIRECT3DDEVICE8	pd3dDevice = g_pD3dDev;

	D3DXVECTOR3 vPick( 0.0f, 0.0f, 0.0f );
	vPick = vPos;

	float _size = size * CELLSPACE;

	if ( Count < 4 ) Count = 4;	

	LINE3D S_Line[2];

	pd3dDevice->SetTexture( 0, NULL ); // ߰
	pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE ); // ߰
	pd3dDevice->SetRenderState( D3DRS_ZENABLE,   TRUE ); // ߰
	pd3dDevice->SetVertexShader( D3DFVF_LINE3D ); // ߰

	S_Line[1].Col = S_Line[0].Col = Col;

//	pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1);
//	pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_DIFFUSE);
//	pd3dDevice->SetFVF( D3DFVF_LINE3D );	

//	if( SetPick( &vPick ) ) // ŷ  ġ(vector)  
	{
		for ( int i = 0; i < Count ; i++ )
		{	
			float Angle0 = (float)i / (float)Count * 2.0f * D3DX_PI; //   1 ġ
			float Angle1 = (float)(i+1) / (float)Count * 2.0f * D3DX_PI; //  2 ġ

			float fFrontPosX = vPick.x + _size * cos(Angle0);
			float fFrontPosZ = vPick.z + _size * sin(Angle0);

			float fLastPosX = vPick.x + _size * cos(Angle1);
			float fLastPosZ = vPick.z + _size * sin(Angle1);

//			float fHeight0 = GetHeight( fFrontPosX, fFrontPosZ);
//			float fHeight1 = GetHeight( fLastPosX, fLastPosZ);
			
			S_Line[0].Pos = D3DXVECTOR3( fFrontPosX, vPick.y + 0.2f, fFrontPosZ );
			S_Line[1].Pos = D3DXVECTOR3( fLastPosX, vPick.y + 0.2f, fLastPosZ );

//			S_Line[0].Pos = D3DXVECTOR3( fFrontPosX, 0.2f, fFrontPosZ );
//			S_Line[1].Pos = D3DXVECTOR3( fLastPosX, 0.2f, fLastPosZ );			
		
			pd3dDevice->DrawPrimitiveUP( D3DPT_LINELIST, 1, S_Line, sizeof( LINE3D ) );
		}
	}

	return true;
}

// 07-05-07 by shkim, Draw Brush
void CBackground::DrawBrush( D3DXVECTOR3 vPos )
{
	D3DXMATRIX w;
	D3DXMatrixIdentity( &w );
	g_pD3dDev->SetTransform(D3DTS_WORLD, &w);

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	int Size = pView->m_nBrushSize;
	
	DrawPickPos( 40, (float)Size, 0xffffff00, vPos ); // ִũ 
}

// 07-05-08 by shkim, Draw check
void CBackground::BrushCheck( BOOL bCheck )
{
	m_bPickCheck = bCheck;
}

//07-05-11 by shkim, ŷ   Ѵ.
void CBackground::CalculatePickPostion( D3DXVECTOR3* pvOrig ,D3DXVECTOR3* pvDir)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	D3DXVECTOR3 vPickRayDir;
	D3DXVECTOR3 vPickRayOrig;
	D3DXMATRIX matProj;
	matProj = pView->m_pCamera->GetProjMatrix();

	POINT ptCursor;
	GetCursorPos( &ptCursor );
	::ScreenToClient(((CD3DApplication *)pView)->m_hWnd, &ptCursor );

	// Compute the vector of the pick ray in screen space
	D3DXVECTOR3 v;
	v.x =  ( ( ( 2.0f * ptCursor.x ) / pView->m_d3dsdBackBuffer.Width  ) - 1 ) / matProj._11;
	v.y = -( ( ( 2.0f * ptCursor.y ) / pView->m_d3dsdBackBuffer.Height ) - 1 ) / matProj._22;
	v.z =  1.0f;

	// Get the inverse view matrix
	D3DXMATRIX matView, m;
	matView = pView->m_pCamera->GetViewMatrix();
	D3DXMatrixInverse( &m, NULL, &matView );

	// Transform the screen space pick ray into 3D space
	vPickRayDir.x = (v.x * m._11) + (v.y * m._21) + (v.z * m._31);
	vPickRayDir.y = (v.x * m._12) + (v.y * m._22) + (v.z * m._32);
	vPickRayDir.z = (v.x * m._13) + (v.y * m._23) + (v.z * m._33);
	vPickRayOrig.x = m._41;
	vPickRayOrig.y = m._42;
	vPickRayOrig.z = m._43;

//	(*pvOrig).x = (v.x * m._11) + (v.y * m._21) + (v.z * m._31);

	// return value
	*pvOrig = vPickRayOrig;
	*pvDir = vPickRayDir;
}

//07-05-11 by shkim, ŷ    Ÿ  üũ Ѵ.
BOOL CBackground::NearPickCheck( D3DXVECTOR3 vRayOrig, D3DXVECTOR3 vRayDir,
								int* nLHTriangle, int* nX, int* nZ )
{
//////  κ  ʿ ߿  //////
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	int tempX = 0, tempZ = 0;
	D3DXVECTOR3 vLookat( 0.0f, 0.0f, 0.0f );
	D3DXVec3Normalize(&vLookat,&pView->m_pCamera->GetViewDir());

	vLookat = pView->m_pCamera->GetLookatPt();
////// ̺κ   ʿ /////////////////

	int xi = (int)(vLookat.x/40.0f);
	int zi = (int)(vLookat.z/40.0f);

	FLOAT fU, fV, fDist;
	D3DXVECTOR3 v, v0, v1, v2;

	BOOL bNearPosCheck = TRUE; //07-05-10 by shkim,   ѹ  ˻ ϱ ؼ
	FLOAT fOldDist = 0.0f; //07-05-10 by shkim,   ̴.

	for(int i=xi-32;i<xi+32;i++)
	{
		for(int j=zi-32;j<zi+32;j++)
		{		
			if(i >= 0 && i < m_sXSize && j >= 0 && j < m_sYSize)
			{				
				v0 = m_pTileVertexArray[i*(m_sYSize+1)+j].pos;
				v1 = m_pTileVertexArray[i*(m_sYSize+1)+(j+1)].pos;
				v2 = m_pTileVertexArray[(i+1)*(m_sYSize+1)+(j+1)].pos;

				if( IntersectTriangle( vRayOrig,
						               vRayDir,
									   v0, v1, v2, 
									   &fDist,
									   &fU,
									   &fV ) )
				{
				//	v = vRayOrig + vRayDir * fDist;
					v = v0 + ( fU * ( v1 - v0 ) ) + ( fV * ( v2 - v0 ) );
					
					// 07-05-10 by shkim,     ؼ ŷ Ƕ ̴.
					if( bNearPosCheck == TRUE )
					{
						bNearPosCheck = FALSE;
						fOldDist = fDist;
						m_vPickPos = v;

						if( nX != NULL && nZ != NULL && nLHTriangle != NULL )
						{
							*nX = i; //07-05-11 by shkim, MouseAction Լ
							*nZ = j; //07-05-11 by shkim, MouseAction Լ
							*nLHTriangle = LOW_TRIANGLE; //07-05-11 by shkim,  ﰢ
						}
					}
					else
					{
						if( fDist < fOldDist ) //    粨 ̴ϱ  ֱ
						{
							fOldDist = fDist;
							m_vPickPos = v;

							if( nX != NULL && nZ != NULL && nLHTriangle != NULL )
							{
								*nX = i; //07-05-11 by shkim, MouseAction Լ
								*nZ = j; //07-05-11 by shkim, MouseAction Լ
								*nLHTriangle = LOW_TRIANGLE; //07-05-11 by shkim,  ﰢ
							}
						}
					}
				}

				v0 = m_pTileVertexArray[i * (m_sYSize + 1) + j].pos;
				v1 = m_pTileVertexArray[(i + 1) * (m_sYSize + 1) + (j + 1)].pos;
				v2 = m_pTileVertexArray[(i + 1) * (m_sYSize + 1) + j].pos;

				if( IntersectTriangle( vRayOrig,
						               vRayDir,
									   v0, v1, v2,
									   &fDist,
									   &fU,
									   &fV ) )
				{
					//v = vRayOrig + vRayDir*fDist;
					v = v0 + ( fU * ( v1 - v0 ) ) + ( fV * ( v2 - v0 ) );			

					// 07-05-10 by shkim,     ؼ ŷ Ƕ ̴.
					if( bNearPosCheck == TRUE )
					{
						bNearPosCheck = FALSE;
						fOldDist = fDist;
						m_vPickPos = v;

						if( nX != NULL && nZ != NULL && nLHTriangle != NULL )
						{
							*nX = i; //07-05-11 by shkim, MouseAction Լ
							*nZ = j; //07-05-11 by shkim, MouseAction Լ
							*nLHTriangle = HIGH_TRIANGLE; //07-05-11 by shkim, Ʒ ﰢ
						}
					}
					else
					{
						if( fDist < fOldDist ) //    粨 ̴ϱ  ֱ
						{
							fOldDist = fDist;
							m_vPickPos = v;

							if( nX != NULL && nZ != NULL && nLHTriangle != NULL )
							{
								*nX = i; //07-05-11 by shkim, MouseAction Լ
								*nZ = j; //07-05-11 by shkim, MouseAction Լ
								*nLHTriangle = HIGH_TRIANGLE; //07-05-11 by shkim, Ʒ ﰢ
							}
						}
					} // else
				} // if
			} // if
		} // for j
	} //for i

	if( bNearPosCheck == FALSE )
	{
		return TRUE;
	}

	return FALSE;
}