// Background.h: interface for the CBackground class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BACKGROUND_H__E55A92E3_96CF_4DAD_A5F6_EFE66E81EAEF__INCLUDED_)
#define AFX_BACKGROUND_H__E55A92E3_96CF_4DAD_A5F6_EFE66E81EAEF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AtumNode.h"
#include "EventSetDlg.h"
#include "EventSetDetailDlg.h"
#include "MonsterSetDlg.h"
#include "MonsterSetDetailDlg.h"
#include <list>
#include "ObjectChild.h"

class Terrain;
#include "texture.h"


typedef struct _WORKSPACE
{
	char workspaceName[40];
	int numberOfProject;
} WORKSPACE;

typedef struct _PROJECTINFO
{
	int			m_useTileSetIndex;
	char		m_strProjectName[40];
	char		m_strFieldIP[16];
	short		m_sFieldPort;
	short		m_sFieldPortUDP;
	char		m_strNPCIP[16];
	short		m_sNPCPort;
	short		m_sNPCPortUDP;
	short		m_sXSize;
	short		m_sYSize;
	float		m_fHeightMax;
	float		m_fHeightMin;
	float		m_fWaterHeight;
	float		m_fDiffuseR1;
	float		m_fDiffuseG1;
	float		m_fDiffuseB1;
	float		m_fAmbientR1;
	float		m_fAmbientG1;
	float		m_fAmbientB1;
	float		m_fDiffuseR2;
	float		m_fDiffuseG2;
	float		m_fDiffuseB2;
	float		m_fAmbientR2;
	float		m_fAmbientG2;
	float		m_fAmbientB2;
} PROJECTINFO;

typedef struct _PROJECTINFOOLD
{
	int			m_useTileSetIndex;
	char		m_strProjectName[40];
	char		m_strFieldIP[16];
	short		m_sFieldPort;
	short		m_sFieldPortUDP;
	char		m_strNPCIP[16];
	short		m_sNPCPort;
	short		m_sNPCPortUDP;
	short		m_sXSize;
	short		m_sYSize;
	float		m_fHeightMax;
	float		m_fHeightMin;
	float		m_fWaterHeight;
	float		m_fDiffuseR1;
	float		m_fDiffuseG1;
	float		m_fDiffuseB1;
	float		m_fAmbientR1;
	float		m_fAmbientG1;
	float		m_fAmbientB1;
} PROJECTINFOOLD;

typedef struct _EVENT_DATA
{
	D3DXVECTOR3 m_vPosition;
	int			m_bMove;
	BYTE		m_bPKType;
	BOOL		m_bEnableLand;
	BYTE		m_bEnvetType;
	short		m_EventwParam1;
	short		m_EventwParam2;
	short		m_EventwParam3;
	char		m_EventstrParam[40];
	DWORD		m_dwWaterType;			// Water Ÿ(0:ƴ, 1:/Ŭ̾Ʈ, 2:, 3:Ŭ̾Ʈ)
} EVENTINFO;

typedef struct _MONSTER_DATA
{
	char		strRegionName[40];
	UINT		nMonType;
	short		sStartx;
	short		sStartz;
	short		sEndx;
	short		sEndz;
	short		sMaxMon;
	short		sResNum;
	short		sResTime;
} MONSTERINFO;

typedef struct _MONSTER_DATA2
{
	char		strRegionName[40];
	UINT		nMonType;
	short		sStartx;
	short		sStartz;
	short		sEndx;
	short		sEndz;
	short		sMaxMon;
	short		sResNum;
	short		sResTime;
	BYTE		bMonType;		// 0: 1: 2: 3:
} MONSTERINFO2;

typedef struct _MONSTER_DATA3
{
	char		strRegionName[40];
	UINT		nMonType;
	short		sStartx;
	short		sStartz;
	short		sStarty;
	short		sEndx;
	short		sEndz;
	short		sEndy;
	short		sMaxMon;
	short		sResNum;
	UINT		nResTime;
	BYTE		bMonType;		
} MONSTERINFO3;					// startY, endY ߰, nResTime --> UINT ȯ

typedef struct _VERTEXINFO
{
    D3DXVECTOR3 pos;
	D3DXVECTOR3 nor;
} VERTEXINFO;

typedef struct _LINEVERTEX
{
    D3DXVECTOR3 pos; 
    DWORD       color;
} LINEVERTEX;


typedef struct _TILEINFO // tile type
{
	INT texTileDirect1;			// 1 ⿡  ؽƮ Ÿ
	INT texTileDirect2;			// 2 ⿡  ؽƮ Ÿ
	INT texTileDirect3;			// 3 ⿡  ؽƮ Ÿ
	INT texTileDirect4;			// 4 ⿡  ؽƮ Ÿ

	INT		useTexNumber;		// ؽ ε
	DWORD	waterType;			// Water 
	INT		waterHeight;		// Water 
	SHORT	waterTexNumber;		// Water Texture
	BOOL	bBaseTile;			// Base Ÿ 
	INT		useBaseTexNumber;	//  Base ؽ ε
	INT		ranTexNumber;		//  Base ؽ  ε

} TILEINFO;


typedef struct _TEXFILEINFO
{
//	UINT tileType;				// Ÿ Ÿ
	char name[20];				// Ÿ ̸
	INT texTileDirect1;			// 1 ⿡  ؽƮ Ÿ
	INT texTileDirect2;			// 2 ⿡  ؽƮ Ÿ
	INT texTileDirect3;			// 3 ⿡  ؽƮ Ÿ
	INT texTileDirect4;			// 4 ⿡  ؽƮ Ÿ
	BOOL	bBaseTile;			// Base Ÿ 
	INT		useBaseTexNumber;	//  Base ؽ ε
	INT		ranTexNumber;		//  Base ؽ  ε
} TEXFILEINFO;

/////////////////////////////////////////////////

/////////////////////////////////////////////////
// Ÿ 
/*
typedef struct _OBJECTINFO
{
	DWORD		m_dwObjType;			// Object Ÿ
	BOOL		bRenderType;			//  Ÿ
	BOOL		bCheckTick;				// ʰ üũ
	D3DXVECTOR3 m_vPos;
	D3DXVECTOR3 m_vVel;
	D3DXVECTOR3 m_vUp;
}OBJECTINFO;
*/

typedef struct _MAP_DATA
{
	FLOAT			m_fTileSize;
	int				m_nVertexNumber;
	int				m_nTileInfoNumber;
	int				m_nObjectNumber;
}MapInfo;

typedef struct _SPRITEVERTEX
{
    D3DXVECTOR3 p;
    D3DXVECTOR3 n;
    FLOAT       tu, tv;
} SPRITEVERTEX;

typedef struct _NOSPRITE
{
    D3DXVECTOR3 p;
    DWORD       color;
} NOSPRITE;

typedef struct _BLOCKDATA
{
	FLOAT		fBlockHeight;
	FLOAT		fGroundHeight;
	INT			nUseBlockCount;
} BLOCKDATA;
/////////////////////////////////////////////////
typedef struct _TILEINFOCLIENT // tile type
{
	INT			useTexNumber;		// ؽ ε
	DWORD		waterType;			// Water 
	INT			waterHeight;		// Water 
	SHORT		waterTexNumber;		// Water Texture
	BYTE		bMove;				// Move Type
	BOOL		bEnableLand;
	BYTE		bEnvetType;
} TILEINFOCLIENT;

typedef struct _OBJECTINFOCLIENT
{
	DWORD		dwObjType;			// Object Ÿ
	INT			nCount;
	D3DXVECTOR3 vPos;
	D3DXVECTOR3 vVel;
	D3DXVECTOR3 vUp;
//	FLOAT		fObjectScale;
	DWORD		dwMonsterUniqueNumber;
	BYTE		bObjectTexIndex;
	UINT		nObjectSrcIndex;
	BYTE		bBodyCondition;
	BOOL		bIsEvent;
	BYTE		bEventType;
	short		sEventIndexFrom;
	short		sEventIndexTo;
	short		sEventIndex3;
	char		strEventParam[40];
} OBJECTINFOCLIENT;

typedef struct _MAP_DATA_SERVER
{
	int				m_nVertexNumber;
	int				m_nObjectNumber;
}MapInfoServer;

typedef struct _OBJECTINFOSERVER
{
	DWORD		dwObjType;			// Object Ÿ
	D3DXVECTOR3 vPos;
	D3DXVECTOR3 vUp;
	BOOL		bIsEvent;
	BYTE		bEventType;
	short		sEventIndexFrom;
	short		sEventIndexTo;
	short		sEventIndex3;
	char		strEventParam[40];
} OBJECTINFOSERVER;

#define D3DFVF_TILEVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1)
#define D3DFVF_LINEVERTEX (D3DFVF_XYZ|D3DFVF_DIFFUSE)

#define GRID_COLOR_RED 0xFF01210F
#define GRID_COLOR_BLUE 0xFF0000FF
#define GRID_COLOR_BLACK 0xFF000000

inline DWORD FtoDW( FLOAT f ) { return *((DWORD*)&f); }

// 07-05-07 by shkim, 귯 ü
typedef struct _Line3D
{
	D3DXVECTOR3 Pos;
	D3DCOLOR		Col;

	_Line3D()
	{
		Pos = D3DXVECTOR3(0.0f,0.0f,0.0f);
		Col = 0xffffffff;
	}

} LINE3D;

#define D3DFVF_LINE3D (D3DFVF_XYZ | D3DFVF_DIFFUSE)

const int CELLSPACE = 20; // 07-05-08 by shkim, 콺 Ŀ   Ѵ
class Terrain;

class CBackground : public CAtumNode  
{
	enum ACTION_TYPE // 07-04-20 by shkim, Ÿ ˾  ְ ߰
	{
		NONE_ACTION = 0, // ƹ 
		HEIGHT_ATCION, // 
		PLANE_ACTION, // ȭ
		OBJ_SELECT, // 콺 Ʈ 
		OBJ_DELETE, // Ʈ 
		WATER_SETTING, //  ׸
		SMOOTH_ACTION = 10, // ٵ
	};
	enum SIZE_TYPE // 07-05-13 by shkim,   
	{
		SIZE_2X2 = 0,
		SIZE_3X3 = 1,
		SIZE_4X4 = 2,
	};
	
public:
	CBackground(short x, short y);
	virtual ~CBackground();
	virtual HRESULT InitDeviceObjects();
	virtual HRESULT RestoreDeviceObjects();
	virtual HRESULT InvalidateDeviceObjects();
	virtual HRESULT DeleteDeviceObjects();
	virtual void Render();//D3DXVECTOR3 vPos,D3DXVECTOR3 vAt);
	virtual void Tick();

	void MouseAction(int action, const D3DXVECTOR3& orig, const D3DXVECTOR3& dir);//,int nTileTextype );
	int	CheckTile1(D3DXVECTOR3 p1,D3DXVECTOR3 p2,D3DXVECTOR3 p3,D3DXVECTOR3 vPickPos); // Ʒ ﰢ
	int	CheckTile2(D3DXVECTOR3 p1,D3DXVECTOR3 p2,D3DXVECTOR3 p3,D3DXVECTOR3 vPickPos); //  ﰢ üũ
	void setMultiTex(int x, int z,int cho);
	void InsertTile(CString strFilename);
	void InsertTileBase(CString strFilename);
	int TextureCreate(LPDIRECT3DTEXTURE8 ptex1,LPDIRECT3DTEXTURE8 ptex2,int a);
	
	void ReInitMap(MapInfo * info);
	void LoadTex(int usetex,TEXFILEINFO info);

	void SetVertex( int i, int j );
	void SetVertexFlat( int i, int j );
	void SetVertexSmooth( int i, int j ); // 07-05-15 by shkim, Smooth

	void SetWater(int a, int b);
	void Restore(/*int a, int b, int c*/); // 07-05-13 by shkim, Ȯ  Լ ȿ ڰ 
	void SetNormal(int i, int j);
	void SetBaseTile(int num);
	////////////// EventSet //////////////////////
	void EventAction(CEventSetDlg  *pDlg, const D3DXVECTOR3& orig, const D3DXVECTOR3& dir);
	void SetEvent(CEventSetDlg  *pDlg,int i, int j);
	void SetEventInfo(int i, int j);
	////////////// Object Choose /////////////////
//	void ObjectAction(const D3DXVECTOR3& orig, const D3DXVECTOR3& dir);
	void SeekObject();//CPoint point);//D3DXVECTOR3 vPos);
	////////////// MonsterSet //////////////////////
	void MonsterAction(CMonsterSetDlg  *pDlg, const D3DXVECTOR3& orig, const D3DXVECTOR3& dir);
	void SetMonster(CMonsterSetDlg  *pDlg,int i, int j);
	CString UpdateMonsterData(CString str);
	void UpdateMonsterRegion(short minx,short minz,short maxx,short maxz,BOOL bCheck);
	////////////// MiniMap Save //////////////////////
	void SaveMiniMap();
	////////////// ׸Ϸ  ϱ //////////////////////
//	void SetHeightData(CString str);
	void SetHeightData(CString strPath,int base,int max);
	//////////////  Ÿ  ϱ //////////////////////
	void SetTileRegion(int x,int y);
	////////////// Ʈ Ÿ  ϱ //////////////////////
	void SetTilePoint(int x,int y,int type);

	void InsertObject(CObjectChild * pObject);

	float MinGroundHeight(int i, int j);

	BOOL IntersectTriangle( const D3DXVECTOR3& orig,
       const D3DXVECTOR3& dir, D3DXVECTOR3& v0,
       D3DXVECTOR3& v1, D3DXVECTOR3& v2,
       FLOAT* t, FLOAT* u, FLOAT* v );
	BOOL SetAllTexture(CString str);

	void BrushCheck( BOOL bCheck ); // 07-05-08 by shkim, brush ̰ Ⱥ̰	

	// 07-05-11 by shkim, ŷ  Ѵ.
	void CalculatePickPostion( D3DXVECTOR3* pvOrig ,D3DXVECTOR3* pvDir);

	// 07-05-11 by shkim, ŷ  ã
	BOOL NearPickCheck(  D3DXVECTOR3 orig, D3DXVECTOR3 dir, 
						 int* nLHTriangle = NULL, //  Ǵ Ʒ ﰢ üũ
						 int* nX = NULL,
						 int* nZ = NULL
						 );

	// 07-05-11 by shkim, ŷ  ġ Ѱش.
	void PickPos( D3DXVECTOR3* pVpos )
	{
		*pVpos = m_vPickPos;
	}

private:
	// 07-05-07 by shkim, ׷ brush ũ  
	bool DrawPickPos( int Count, float size, D3DCOLOR Col, D3DXVECTOR3 vPos ); 
	void DrawBrush( D3DXVECTOR3 vPos ); // 07-05-07 by shkim, brush ׸ Լ	
	float GetHeight( float fX, float fZ ); // 07-05-08 by shkim, Pick ġ   ̸ 

	// 07-05-17 by shkim, ٵ⿡  Ǵ üũ Լ
	BOOL GetClickCheck( int nX, int nZ );

	// 07-05-17 by shkim,  ִ    Լ 
	void SetVertexBlock( int i, int j );

private:
	enum	TRIANGLE // 07-05-11 by shkim, , Ʒ üũ
	{		
		LOW_TRIANGLE = 1,
		HIGH_TRIANGLE = 2
	};
	BOOL				m_bPickCheck; // 07-05-07 by shkim, brush ̱ Ȯ
	D3DXVECTOR3			m_vPickPos; // 07-05-07 by shkim, brush ġ

protected:
	void Action( int action, int x, int z, D3DXVECTOR3 vOri, D3DXVECTOR3 vTile );//,int tiletype
	void ActionTileSet(int x, int z,int type);
	void ResizeTexture(LPDIRECT3DTEXTURE8 pTexture, char *szFilename,int nSize);

	LPDIRECT3DVERTEXBUFFER8	m_pVBLine;

public:
	LPDIRECT3DTEXTURE8		m_pTileTexture[MAX_BASETILE_NUM][MAX_BASETILERANDOM_NUM];  
	// [0-9]:0Ÿ 
	// [10]:1Ÿ [11]:2Ÿ [12]:3Ÿ [13]:4Ÿ
	// [14]:5Ÿ [15]:6Ÿ [16]:7Ÿ [17]:8Ÿ
	// [18]:9Ÿ [19]:10Ÿ [20]:11Ÿ [21]:12Ÿ
	TILEINFO		*		m_pTileInfo; //  ϴ ŸϹȣ, N x M  
	VERTEXINFO		*		m_pTileVertexArray;
	VERTEXINFO		*		m_pBlockVertexArray;
	D3DXVECTOR3		*		m_pvTempVecArr; // 07-05-08 by shkim, ӽ  ġ  ´.

	BLOCKDATA		*		m_pBlockData;
	TEXFILEINFO		*		m_pTexFileInfo;
	LPDIRECT3DTEXTURE8		m_pCreateTexture[MAX_TEXTILE_NUM];		// Created Texture
	LPDIRECT3DVERTEXBUFFER8	m_pVBFlying;			// Flying VextexBuffer
//	LPDIRECT3DVERTEXBUFFER8	m_pVBRender[32*32];
	LPDIRECT3DVERTEXBUFFER8	m_pVBRender[64*64];

	LPDIRECT3DTEXTURE8		m_pWaterTexture[10];			// Water Texture
	LPDIRECT3DVERTEXBUFFER8	m_pVBWater;
	D3DXMATRIX				m_matWater;
	FLOAT					m_fCheckWaterTexAniTime;
	FLOAT					m_fHeight;


	INT						m_ninsertTileFileCont;
	INT						m_ninsertTileFileBaseCont;
	////////// Event Set ///////////////
	LPDIRECT3DTEXTURE8		m_pEventTexture[MAX_TEXEVENT_NUM];
	EVENTINFO	*			m_pEventInfo;
	BOOL		*			m_bUsingArray;
	CEventSetDetailDlg		m_dlgEvnetSetDetail;
	CMonsterSetDetailDlg	m_dlgMonsterSetDetail;
	short					m_sXSize;
	short					m_sYSize;

	float					m_fTileSize;
	INT						m_nCreateTexNumber;
	INT						m_nTexUseNumber;
	INT						m_nObjectNumber;
	INT						m_nObjectNumberOld;

	PROJECTINFO				m_projectInfo;

	////////// Event Set ///////////////
	list<MONSTERINFO2>		m_listMonsterInfo;
	INT						m_nMonsterNumber;
	BOOL	*				m_bUsingMonsterRegion;

	map<INT,CAtumNode *>	m_mapObjectData;    // int -> 000 000  ڸ x  ڸ z ε Ŵ
	LPDIRECT3DTEXTURE8			m_pBackTexture;


	// ROAM
 	Terrain			*			m_pTerrain;
 	char						m_strTerrainMap[MAX_PATH];
	TextureMngr					m_TextureMgr;
 	float			*			m_pHeightMap;
};

#endif // !defined(AFX_BACKGROUND_H__E55A92E3_96CF_4DAD_A5F6_EFE66E81EAEF__INCLUDED_)
