// DXImage.cpp: implementation of the CDXImage class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DXImage.h"
#include "DXUtil.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

extern LPDIRECT3DDEVICE8	g_pD3dDev;

////////////////////////////////////////////////////////////////////////

//         CDXImage

////////////////////////////////////////////////////////////////////////


CDXImage::CDXImage()
	:m_v2Scaling(1,1), m_v2Rcenter(0,0), m_v2Trans(0,0)
{
	m_pRect = NULL;
	m_pTexture = NULL;
	m_bSpriteCrate = FALSE;
	m_pd3dxSprite = NULL;
}

CDXImage::~CDXImage()
{

}

HRESULT CDXImage::InitDeviceObjects()
{
	m_v2Trans = D3DXVECTOR2( (float)m_ptStart.x, (float)m_ptStart.y);

	return CDXWnd::InitDeviceObjects();
}

void CDXImage::Move( float x, float y ) 
{ 
	m_v2Trans = D3DXVECTOR2(x, y);

	int sx = (int)(x - m_ptStart.x);
	int sy = (int)(y - m_ptStart.y);
	m_ptStart.x += sx;
	m_ptStart.y += sy; 
	m_ptEnd.x += sx;
	m_ptEnd.y += sy;

}

HRESULT CDXImage::RestoreDeviceObjects()
{
	if(!m_pd3dxSprite)
	{
		D3DXCreateSprite(g_pD3dDev , &m_pd3dxSprite);
		m_bSpriteCrate = TRUE;
	}
	D3DXIMAGE_INFO SrcInfo;
	D3DXCreateTextureFromFileEx( g_pD3dDev,m_strWindowName, D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, 
		D3DFMT_A8R8G8B8 , D3DPOOL_DEFAULT, D3DX_FILTER_NONE, D3DX_DEFAULT, 
		0, &SrcInfo , NULL, &m_pTexture);
	return CDXWnd::RestoreDeviceObjects();
}

HRESULT CDXImage::InvalidateDeviceObjects()
{
	SAFE_RELEASE(m_pTexture);
	if(m_bSpriteCrate)
		SAFE_RELEASE(m_pd3dxSprite);
	if(m_pRect)
		delete m_pRect;

	return CDXWnd::InvalidateDeviceObjects();
}

HRESULT CDXImage::DeleteDeviceObjects()
{
	return CDXWnd::DeleteDeviceObjects();
}

void CDXImage::Render()
{
	if(m_pd3dxSprite)
		m_pd3dxSprite->Draw( m_pTexture, m_pRect, &m_v2Scaling, &m_v2Rcenter, 0, &m_v2Trans, 0xFFFFFFFF );

	CDXWnd::Render();
}

void CDXImage::SetRect(long left,long top, long right, long bottom)
{
	if(m_pRect) delete m_pRect;
	m_pRect = new RECT;
	m_pRect->left = left;
	m_pRect->top = top;
	m_pRect->right = right;
	m_pRect->bottom = bottom;
}

