// DXImage.h: interface for the CDXImage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DXIMAGE_H__C2EAADF2_0C97_4626_A6A4_13BF2EB40CE0__INCLUDED_)
#define AFX_DXIMAGE_H__C2EAADF2_0C97_4626_A6A4_13BF2EB40CE0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "DXWnd.h"

#define D3DFVF_TLVERTEX D3DFVF_XYZRHW|D3DFVF_DIFFUSE|D3DFVF_TEX1

typedef struct _D3DTLVERTEX {
    float		sx;
    float		sy;
    float		sz;
    float		rhw;
    D3DCOLOR	color;
    float		tu;
    float		tv;
    _D3DTLVERTEX() { }
    _D3DTLVERTEX(const D3DVECTOR& v, float _rhw, D3DCOLOR _color, float _tu, float _tv )
    { sx = v.x; sy = v.y; sz = v.z; rhw = _rhw;
      color = _color; 
      tu = _tu; tv = _tv;
    }
} D3DTLVERTEX, *LPD3DTLVERTEX;

class CDXImage : public CDXWnd
{
public:
	CDXImage();
	virtual ~CDXImage();
	virtual HRESULT InitDeviceObjects();
	virtual HRESULT RestoreDeviceObjects();
	virtual HRESULT DeleteDeviceObjects();
	virtual HRESULT InvalidateDeviceObjects();
	virtual void Render();
	void Move( float x, float y );
	void SetDXSprite(LPD3DXSPRITE pSpr) { m_pd3dxSprite = pSpr; }
	LPD3DXSPRITE GetDXSprite() { return m_pd3dxSprite; }
	void SpriteBegin() { if(m_bSpriteCrate) m_pd3dxSprite->Begin(); }
	void SpriteEnd() { if(m_bSpriteCrate) m_pd3dxSprite->End(); }
	D3DXVECTOR2 GetTransVector() { return m_v2Trans; }
	void SetRect(long left,long top, long right, long bottom);
	void SetTexture(LPDIRECT3DTEXTURE8 pTex) {m_pTexture = pTex;};

protected:
	LPDIRECT3DTEXTURE8	m_pTexture;
	LPD3DXSPRITE		m_pd3dxSprite; 
	D3DXVECTOR2			m_v2Scaling, m_v2Rcenter, m_v2Trans;
	RECT			*	m_pRect;
	BOOL				m_bSpriteCrate;
};
#endif // !defined(AFX_DXIMAGE_H__C2EAADF2_0C97_4626_A6A4_13BF2EB40CE0__INCLUDED_)
