// DXWnd.cpp: implementation of the CDXWnd class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <Windowsx.h>
#include "DXWnd.h"
#include "DXUtil.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

extern LPDIRECT3DDEVICE8	g_pD3dDev;	// D3D̽ü PTR

CDXWnd::CDXWnd()
{
	m_pParent = NULL;
    m_pNext = NULL;
    m_pPrev = NULL;
	m_pChild = NULL;
	m_ptStart.x = 0;
	m_ptStart.y = 0;
	m_ptEnd.x = 0;
	m_ptEnd.y = 0;
	ZeroMemory(m_strWindowName, sizeof(m_strWindowName));
}

CDXWnd::~CDXWnd()
{

}

BOOL CDXWnd::Create(LPCTSTR windowName, POINT start, POINT end)
{
	strcpy(m_strWindowName, windowName );
	m_ptStart = start;
	m_ptEnd = end;
	return TRUE;
}


BOOL CDXWnd::SendMessage(UINT message, WPARAM wParam=0, LPARAM lParam=0 )
{
	switch(message)
	{
	case WM_LBUTTONDOWN:
		OnLButtonDown(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) );
		break;
	case WM_RBUTTONDOWN:
		OnRButtonDown(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) );
		break;
	case WM_LBUTTONUP:
		OnLButtonUp(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) );
		break;
	case WM_RBUTTONUP:
		OnRButtonUp(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) );
		break;
	case WM_MOUSEMOVE:
		OnMouseOver(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) );
		break;
	case WM_KEYDOWN:
		OnKeyDown(lParam, (BOOL)wParam);
	case WM_KEYUP:
		OnKeyUp(lParam, (BOOL)wParam);
	}
	return TRUE;
}

HRESULT CDXWnd::InitDeviceObjects()
{
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
			pNode->InitDeviceObjects();
	return S_OK;
}

HRESULT CDXWnd::RestoreDeviceObjects()
{
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
			pNode->RestoreDeviceObjects();
	return S_OK;
}

HRESULT CDXWnd::InvalidateDeviceObjects()
{
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
			pNode->InvalidateDeviceObjects();
	return S_OK;
}

HRESULT CDXWnd::DeleteDeviceObjects()
{
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
			pNode->DeleteDeviceObjects();
	return S_OK;
}

void CDXWnd::Tick(float elapsedTime)
{
	if ( m_pChild ) 
	{
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
			pNode->Tick(elapsedTime);
	}
	CDXWnd::OnMouseOut();
}

void CDXWnd::Render()
{
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
			pNode->Render();
}

void CDXWnd::AddChild( CDXWnd* pNode )
{
	pNode->m_pParent = this;
	if ( !m_pChild ) 
	{
		m_pChild = pNode; 
		return;
	}

    if( m_pChild->m_pNext )
        m_pChild->m_pNext->m_pPrev = pNode;

    pNode->m_pNext = m_pChild->m_pNext;
    pNode->m_pPrev = m_pChild;

    m_pChild->m_pNext = pNode;
}

void CDXWnd::DeleteChild( CDXWnd* pNode)
{
	if(pNode->m_pPrev)
		pNode->m_pPrev->m_pNext = pNode->m_pNext;
	if(pNode->m_pNext)
		pNode->m_pNext->m_pPrev = pNode->m_pPrev;
	if(!pNode->m_pNext && !pNode->m_pPrev)
		m_pChild=NULL;
	if(pNode->m_pNext && !pNode->m_pPrev)
		m_pChild=pNode->m_pNext;
	delete pNode;
}

void CDXWnd::OnLButtonDown(int x, int y)
{
	m_ptMouse.x = x;
	m_ptMouse.y = y;
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
		{
			if(pNode->IsOverMouse( x, y ))
				pNode->OnLButtonDown( x, y);
		}
}

void CDXWnd::OnRButtonDown(int x, int y)
{
	m_ptMouse.x = x;
	m_ptMouse.y = y;
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
		{
			if(pNode->IsOverMouse( x, y ))
				pNode->OnRButtonDown( x, y);
		}
}

void CDXWnd::OnKeyDown(int nChar, BOOL capsLock)
{

}

void CDXWnd::OnKeyUp(int nChar, BOOL capsLock)
{

}

void CDXWnd::OnRButtonUp(int x, int y)
{
	m_ptMouse.x = x;
	m_ptMouse.y = y;
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
		{
			if(pNode->IsOverMouse( x, y ))
				pNode->OnRButtonUp( x, y);
		}

}

void CDXWnd::OnLButtonUp(int x, int y)
{
	m_ptMouse.x = x;
	m_ptMouse.y = y;
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
		{
			if(pNode->IsOverMouse( x, y ))
				pNode->OnLButtonUp( x, y);
		}

}

void CDXWnd::OnMouseOver(int x, int y)
{
	m_ptMouse.x = x;
	m_ptMouse.y = y;
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
		{
			if(pNode->IsOverMouse( x, y ))
				pNode->OnMouseOver( x, y);
		}
}

void CDXWnd::OnMouseOut()
{
	if ( m_pChild ) 
		for( CDXWnd* pNode = m_pChild; pNode; pNode = pNode->m_pNext )
		{
			if(!pNode->IsOverMouse( m_ptMouse.x, m_ptMouse.y ))
				pNode->OnMouseOut();
		}
}

BOOL CDXWnd::IsOverMouse( int x, int y )
{
	if( m_ptStart.x <= x && m_ptEnd.x >= x && m_ptStart.y <= y && m_ptEnd.y >= y )
		return TRUE;
	return FALSE;
}

// ڽ Ŭ action ϷǾ  ڽĿ θ ȣϴ Լ
void CDXWnd::OnActionComplete(CDXWnd* pChild, int action)
{

}
