// DXWnd.h: interface for the CDXWnd class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DXWND_H__3160019E_382D_4E93_9509_78F98090B58D__INCLUDED_)
#define AFX_DXWND_H__3160019E_382D_4E93_9509_78F98090B58D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <D3DX8.h>
#include <DXUtil.h>


class CDXWnd  
{
public:
	CDXWnd();
	virtual ~CDXWnd();

	CDXWnd*			m_pChild;		// ϵ 
protected:
	CDXWnd*			m_pParent;
	CDXWnd*			m_pPrev;		//  
	CDXWnd*			m_pNext;		//  
	POINT			m_ptStart;		// ġ
	POINT			m_ptEnd;		
	POINT			m_ptMouse;		
	DWORD			m_dwStateBlock;	// º
	char			m_strWindowName[80];// window ̸

	BOOL IsOverMouse( int x, int y );

public:
	// window handlers, functions
	BOOL Create( LPCTSTR windowName, POINT start, POINT end);
	virtual BOOL SendMessage( UINT message, WPARAM wParam, LPARAM lParam );
	virtual void OnLButtonDown(int x, int y);
	virtual void OnRButtonDown(int x, int y);
	virtual void OnLButtonUp(int x, int y);
	virtual void OnRButtonUp(int x, int y);
	virtual void OnMouseOver(int x, int y);
	virtual void OnMouseOut();
	virtual void OnKeyUp(int nChar, BOOL capsLock);
	virtual void OnKeyDown(int nChar, BOOL capsLock);
	virtual void OnActionComplete(CDXWnd* pChild, int action);
	// D3D child node functions
	virtual HRESULT InitDeviceObjects();
	virtual HRESULT RestoreDeviceObjects();
	virtual HRESULT InvalidateDeviceObjects();
	virtual HRESULT DeleteDeviceObjects();
	virtual void Render();
	virtual void Tick(float elapsedTime);
	void AddChild( CDXWnd* pNode );
	void DeleteChild( CDXWnd* pNode);
	void SetParent( CDXWnd* pParent ){ m_pParent = pParent; }
	void SetNext( CDXWnd* pNext ) { m_pNext = pNext; }
	POINT GetStart() { return m_ptStart; }
	POINT GetEnd() { return m_ptEnd; }
	virtual void SetPos( POINT start, POINT end ) { m_ptStart = start; m_ptEnd = end; }
	friend CDXWnd;

};

#endif // !defined(AFX_DXWND_H__3160019E_382D_4E93_9509_78F98090B58D__INCLUDED_)
