// EffectSetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mapeditor.h"
#include "EffectSetDlg.h"

#include "MainFrm.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#include "EffectSetDetailDlg.h"
#include "AppEffectData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEffectSetDlg dialog


CEffectSetDlg::CEffectSetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEffectSetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEffectSetDlg)
	m_strEffectRegion = _T("");
	m_strEffectType = _T("");
	m_strEffectLoop = _T("");
	m_fEffectRetime = 0.0f;
	m_strPosition = _T("");
	//}}AFX_DATA_INIT
}


void CEffectSetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEffectSetDlg)
	DDX_Control(pDX, IDC_LIST_EFFECT, m_listEffect);
	DDX_Text(pDX, IDC_EDIT_EFFECTREGION, m_strEffectRegion);
	DDX_Text(pDX, IDC_EDIT_EFFECTTYPE, m_strEffectType);
	DDX_Text(pDX, IDC_EDIT_EFFECTLOOP, m_strEffectLoop);
	DDX_Text(pDX, IDC_EDIT_EFFECTRETIME, m_fEffectRetime);
	DDX_Text(pDX, IDC_EDIT_EFFECTPOSITION, m_strPosition);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEffectSetDlg, CDialog)
	//{{AFX_MSG_MAP(CEffectSetDlg)
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	ON_LBN_SELCHANGE(IDC_LIST_EFFECT, OnSelchangeListEffect)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEffectSetDlg message handlers

void CEffectSetDlg::OnButtonUpdate() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int num = m_listEffect.GetCurSel();
	if(num >= 0)
	{
		list<EFFECTINFO>::iterator it = pView->m_listEffectInfo.begin();
		for(int i = 0;i < num;i++)
			it++;
		CEffectSetDetailDlg *pDlg = new CEffectSetDetailDlg();
		pDlg->m_strEffectName.Format("%s",it->strEffectName);
		pDlg->m_nEffectType = it->nType;
		pDlg->m_bRegion = it->bRegion;
		pDlg->m_bLoop = it->bLoop;
		pDlg->m_fReTime = it->fReTime;
		pDlg->m_fPosX = it->vPos.x;
		pDlg->m_fPosY = it->vPos.y;
		pDlg->m_fPosZ = it->vPos.z;
		if(pDlg->DoModal()==IDOK)
		{
			if(strlen(pDlg->m_strEffectName))
			{
				EFFECTINFO effInfo;
				wsprintf(it->strEffectName,"%s",pDlg->m_strEffectName);
				it->nType = pDlg->m_nEffectType;
				it->bRegion = pDlg->m_bRegion;
				it->bLoop = pDlg->m_bLoop;
				it->fReTime = pDlg->m_fReTime;
				it->fCheckTime = pDlg->m_fReTime;
				it->vPos.x = pDlg->m_fPosX;
				it->vPos.y = pDlg->m_fPosY;
				it->vPos.z = pDlg->m_fPosZ;
				CString strEffectName;
				m_listEffect.GetText(num,strEffectName);
				if(strcmp(strEffectName,pDlg->m_strEffectName))
				{
					int n = m_listEffect.GetCount();
					for (int i=0;i < n;i++)
					   m_listEffect.DeleteString( n-i-1 );
					it = pView->m_listEffectInfo.begin();
					while(it != pView->m_listEffectInfo.end())
					{
						m_listEffect.AddString(it->strEffectName);
						it++;
					}
				}
			}
			CAppEffectData * pEffect = (CAppEffectData *)pView->m_pEffectList->m_pChild;
			while(pEffect)
			{
				pEffect->m_bUsing = FALSE;
				pEffect = (CAppEffectData *)pEffect->m_pNext;
			}
			it = pView->m_listEffectInfo.begin();
			while(it != pView->m_listEffectInfo.end())
			{
				it->fCheckTime = it->fReTime;
				it++;
			}
		}
		delete pDlg;
	}
}

void CEffectSetDlg::OnSelchangeListEffect() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int num = m_listEffect.GetCurSel();
	if(num >= 0)
	{
		list<EFFECTINFO>::iterator it = pView->m_listEffectInfo.begin();
		for(int i = 0;i < num;i++)
			it++;
		if(it->bRegion)
			m_strEffectRegion.Format("Regional effects");
		else
			m_strEffectRegion.Format("Part of local effects");
		if(it->bRegion)
			m_strEffectLoop.Format("Loop-type effects");
		else
			m_strEffectLoop.Format("Moment-type effects");
		m_strEffectType.Format("%d",it->nType);
		m_fEffectRetime = it->fReTime;
		m_strPosition.Format("%.2f,%.2f,%.2f",it->vPos.x,it->vPos.y,it->vPos.z);
		D3DXVECTOR3 vVel,vPos;
		vPos = it->vPos;
		D3DXVec3Normalize(&vVel,&pView->m_pCamera->GetViewDir());
		vPos = vPos - vVel*200.0f;
		pView->m_pCamera->SetViewParams(vPos,vPos + vVel,pView->m_pCamera->GetUpVec());
		UpdateData(FALSE);
	}
}

void CEffectSetDlg::OnButtonDelete() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int num = m_listEffect.GetCurSel();
	if(num >= 0)
	{
		list<EFFECTINFO>::iterator it = pView->m_listEffectInfo.begin();
		for(int i = 0;i < num;i++)
			it++;
		CAppEffectData * pEffect = (CAppEffectData *)pView->m_pEffectList->m_pChild;
		while(pEffect)
		{
			if((int)(pEffect->m_vPos.x) == (int)(it->vPos.x) && (int)(pEffect->m_vPos.y) == (int)(it->vPos.y) 
				&& (int)(pEffect->m_vPos.z) == (int)(it->vPos.z) && pEffect->m_nType == it->nType)
				pEffect->m_bUsing = FALSE;
			pEffect = (CAppEffectData *)pEffect->m_pNext;
		}
		pView->m_listEffectInfo.erase(it);
		m_listEffect.DeleteString(num);
	}
}
