// EventSetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MapEditor.h"
#include "EventSetDlg.h"

#include "MainFrm.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEventSetDlg dialog


CEventSetDlg::CEventSetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEventSetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEventSetDlg)
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_nCommandEvent = 0;
	m_checkEventSetMode = TRUE;
	m_checkEventViewMode = FALSE;
	m_checkViewPCN = FALSE;
	m_checkLandPossible = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkViewLand = FALSE;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkViewWarf = FALSE;
	m_editInfoEventType = 0;
	m_editInfostrParam = _T("");
	m_editInfowParam1 = 0;
	m_editInfowParam2 = 0;
	m_editIsWater = _T("");
	m_checkMoveNo = FALSE;
	m_checkMoveOk = FALSE;
	m_checkViewMove = FALSE;
	m_checkMoveCheck = FALSE;
	m_editInfowParam3 = 0;
	//}}AFX_DATA_INIT
}


void CEventSetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEventSetDlg)
	DDX_Check(pDX, IDC_CHECK_PK, m_checkPK);
	DDX_Check(pDX, IDC_CHECK_COMBAT, m_checkCombat);
	DDX_Check(pDX, IDC_CHECK_NORMAL, m_checkNormal);
	DDX_Radio(pDX, IDC_RADIO_SETPK, m_nCommandEvent);
	DDX_Check(pDX, IDC_CHECK_EVENTSET, m_checkEventSetMode);
	DDX_Check(pDX, IDC_CHECK_EVENTVIEW, m_checkEventViewMode);
	DDX_Check(pDX, IDC_CHECK_VIEW_PKZONE, m_checkViewPCN);
	DDX_Check(pDX, IDC_CHECK_LAND_OK, m_checkLandPossible);
	DDX_Check(pDX, IDC_CHECK_LAND_NO, m_checkLandImpossible);
	DDX_Check(pDX, IDC_CHECK_VIEW_LAND, m_checkViewLand);
	DDX_Check(pDX, IDC_CHECK_EVENT_NO, m_checkEventNormal);
	DDX_Check(pDX, IDC_CHECK_EVENT_OK, m_checkEventArea);
	DDX_Check(pDX, IDC_CHECK_VIEW_WARF, m_checkViewWarf);
	DDX_Text(pDX, IDC_EDIT_INFO_EVENTTYPE, m_editInfoEventType);
	DDX_Text(pDX, IDC_EDIT_INFO_STRPARAM, m_editInfostrParam);
	DDX_Text(pDX, IDC_EDIT_INFO_WPARAM1, m_editInfowParam1);
	DDX_Text(pDX, IDC_EDIT_INFO_WPARAM2, m_editInfowParam2);
	DDX_Text(pDX, IDC_EDIT_INFO_ISWATER, m_editIsWater);
	DDX_Check(pDX, IDC_CHECK_MOVE_NO, m_checkMoveNo);
	DDX_Check(pDX, IDC_CHECK_MOVE_OK, m_checkMoveOk);
	DDX_Check(pDX, IDC_CHECK_VIEW_MOVE, m_checkViewMove);
	DDX_Check(pDX, IDC_CHECK_MOVE_CHECK, m_checkMoveCheck);
	DDX_Text(pDX, IDC_EDIT_INFO_WPARAM3, m_editInfowParam3);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEventSetDlg, CDialog)
	//{{AFX_MSG_MAP(CEventSetDlg)
	ON_BN_CLICKED(IDC_CHECK_PK, OnCheckPk)
	ON_BN_CLICKED(IDC_CHECK_COMBAT, OnCheckCombat)
	ON_BN_CLICKED(IDC_CHECK_NORMAL, OnCheckNormal)
	ON_BN_CLICKED(IDC_CHECK_EVENTSET, OnCheckEventset)
	ON_BN_CLICKED(IDC_CHECK_EVENTVIEW, OnCheckEventview)
	ON_BN_CLICKED(IDC_CHECK_VIEW_PKZONE, OnCheckViewPkzone)
	ON_BN_CLICKED(IDC_CHECK_LAND_OK, OnCheckLandOk)
	ON_BN_CLICKED(IDC_CHECK_LAND_NO, OnCheckLandNo)
	ON_BN_CLICKED(IDC_CHECK_VIEW_LAND, OnCheckViewLand)
	ON_BN_CLICKED(IDC_CHECK_EVENT_NO, OnCheckEventNo)
	ON_BN_CLICKED(IDC_CHECK_EVENT_OK, OnCheckEventOk)
	ON_BN_CLICKED(IDC_CHECK_VIEW_WARF, OnCheckViewWarf)
	ON_BN_CLICKED(IDC_CHECK_MOVE_OK, OnCheckMoveOk)
	ON_BN_CLICKED(IDC_CHECK_MOVE_NO, OnCheckMoveNo)
	ON_BN_CLICKED(IDC_CHECK_VIEW_MOVE, OnCheckViewMove)
	ON_BN_CLICKED(IDC_CHECK_MOVE_CHECK, OnCheckMoveCheck)
	ON_BN_CLICKED(IDC_BUTTON_EVENT_SETALL, OnButtonEventSetall)
	ON_BN_CLICKED(IDC_BUTTON_EVENT_RESETPK, OnButtonEventResetpk)
	ON_BN_CLICKED(IDC_BUTTON_EVENT_RESETLAND, OnButtonEventResetland)
	ON_BN_CLICKED(IDC_BUTTON_EVENT_RESETWARF, OnButtonEventResetwarf)
	ON_BN_CLICKED(IDC_BUTTON_EVENT_RESETMOVE, OnButtonEventResetmove)
	ON_BN_CLICKED(IDC_RADIO_SETPK, OnRadioSetpk)
	ON_BN_CLICKED(IDC_RADIO_LANDSET, OnRadioLandset)
	ON_BN_CLICKED(IDC_RADIO_EVENTSET, OnRadioEventset)
	ON_BN_CLICKED(IDC_RADIO_MOVESET, OnRadioMoveset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEventSetDlg message handlers


void CEventSetDlg::OnCheckPk() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 0;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckCombat() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 0;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckNormal() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 0;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckEventset() 
{
	// TODO: Add your control notification handler code here
//	m_checkEventSetMode = !m_checkEventSetMode;
	UpdateData();
	m_checkEventViewMode = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckEventview() 
{
	// TODO: Add your control notification handler code here
//	m_checkEventViewMode = !m_checkEventViewMode;
	UpdateData();
	m_checkEventSetMode = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckViewPkzone() 
{
	// TODO: Add your control notification handler code here
//	m_checkViewPCN = !m_checkViewPCN;
	UpdateData();
}

void CEventSetDlg::OnCheckLandOk() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 1;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckLandNo() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 1;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckViewLand() 
{
	// TODO: Add your control notification handler code here
//	m_checkViewLand = !m_checkViewLand;
	UpdateData();
	
}

void CEventSetDlg::OnCheckEventNo() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 2;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckEventOk() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 2;
	m_checkEventNormal = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckViewWarf() 
{
	// TODO: Add your control notification handler code here
//	m_checkViewWarf = !m_checkViewWarf;
	UpdateData();
}
void CEventSetDlg::UpdateDataEvent() 
{
	UpdateData(FALSE);
}

void CEventSetDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CDialog::OnCancel();
}

void CEventSetDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CEventSetDlg::OnCheckMoveOk() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 3;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckMoveNo() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 3;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnCheckViewMove() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
}

void CEventSetDlg::OnCheckMoveCheck() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_nCommandEvent = 3;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnButtonEventSetall() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int i,j;
	if(m_checkEventNormal)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bEnvetType = 0;
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_EventwParam1 = 0;
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_EventwParam2 = 0;
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_EventwParam3 = 0;
				strcpy(pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_EventstrParam,"");
			}
		}
	}
	else if(m_checkEventArea)
	{
	}
	else if(m_checkLandImpossible)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bEnableLand = FALSE;
			}
		}
	}
	else if(m_checkLandPossible)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bEnableLand = TRUE;
			}
		}
	}
	else if(m_checkPK)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bPKType = 0;
			}
		}
	}
	else if(m_checkCombat)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bPKType = 1;
			}
		}
	}
	else if(m_checkNormal)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bPKType = 2;
			}
		}
	}
	else if(m_checkMoveOk)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bMove = 0;
			}
		}
	}
	else if(m_checkMoveCheck)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bMove = 1;
			}
		}
	}
	else if(m_checkMoveNo)
	{
		for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
		{
			for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
			{
				pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bMove = 2;
			}
		}
	}
}

void CEventSetDlg::OnButtonEventResetpk() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int i,j;

	for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
	{
		for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
		{
			pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bPKType = 0;
		}
	}
}

void CEventSetDlg::OnButtonEventResetland() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int i,j;
	for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
	{
		for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
		{
			pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bEnableLand = FALSE;
		}
	}
}

void CEventSetDlg::OnButtonEventResetwarf() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int i,j;
	for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
	{
		for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
		{
			pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bEnvetType = 0;
			pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_EventwParam1 = 0;
			pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_EventwParam2 = 0;
			pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_EventwParam3 = 0;
			strcpy(pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_EventstrParam,"");
		}
	}
}

void CEventSetDlg::OnButtonEventResetmove() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int i,j;
	for(i=0;i<pView->m_pBackground->m_projectInfo.m_sXSize;i++)
	{
		for(j=0;j<pView->m_pBackground->m_projectInfo.m_sYSize;j++)
		{
			pView->m_pBackground->m_pEventInfo[i*pView->m_pBackground->m_projectInfo.m_sYSize + j].m_bMove = 0;
		}
	}
}

void CEventSetDlg::OnRadioSetpk() 
{
	// TODO: Add your control notification handler code here
	m_nCommandEvent = 0;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = TRUE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnRadioLandset() 
{
	// TODO: Add your control notification handler code here
	m_nCommandEvent = 1;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = TRUE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnRadioEventset() 
{
	// TODO: Add your control notification handler code here
	m_nCommandEvent = 2;
	m_checkEventNormal = TRUE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = FALSE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
}

void CEventSetDlg::OnRadioMoveset() 
{
	// TODO: Add your control notification handler code here
	m_nCommandEvent = 3;
	m_checkEventNormal = FALSE;
	m_checkEventArea = FALSE;
	m_checkLandImpossible = FALSE;
	m_checkLandPossible = FALSE;
	m_checkPK = FALSE;
	m_checkCombat = FALSE;
	m_checkNormal = FALSE;
	m_checkMoveOk = TRUE;
	m_checkMoveNo = FALSE;
	m_checkMoveCheck = FALSE;
	UpdateData(FALSE);
	
}
