// GameDataLast.cpp: implementation of the CGameDataLast class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GameDataLast.h"

#include <string.h>
#include <stdlib.h>
#include <fcntl.h>      /* Needed only for _O_RDWR definition */
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/stat.h>
#include <stdio.h>

#include "DXUtil.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CGameData::CGameData()
{
	pTotal_header = NULL;
	memset(m_EncodeStrFilePath,0x00,sizeof(m_EncodeStrFilePath));
	memset(m_ZipFilePath,0x00,sizeof(m_ZipFilePath));
    memset(m_EncodeString,0x00,sizeof(m_EncodeString));
	m_it = m_mapDataHeader.begin();
	m_bEncode = FALSE;
}

CGameData::~CGameData()
{
	map<string,DataHeader*>::iterator it = m_mapDataHeader.begin();

	while(it != m_mapDataHeader.end())
	{
		DataHeader* pHeader = it->second;
		SAFE_DELETE (pHeader);
		it++;
	}		
	SAFE_DELETE( pTotal_header );
}

int CGameData::GetTotalNumber()
{
	return pTotal_header->m_DataNumber;
}

DataHeader * CGameData::GetStartPosition()
{
	m_it = m_mapDataHeader.begin();

	return m_it->second;
}

DataHeader* CGameData::GetNext()
{
	m_it++;
	if(m_it == m_mapDataHeader.end() )
		return NULL;
	return m_it->second;

}

DataHeader* CGameData::Find(char* strName)
{
	map<string,DataHeader*>::iterator it = m_mapDataHeader.find(strName);

	if(it != m_mapDataHeader.end())
	{
		return it->second;
	}	
	return NULL;
}

CGameData::SetFile(char *filename,  BOOL encode, char* encodeString, int encodeSize)
{
	strcpy(m_ZipFilePath, filename);
	if(encode)
	{
		SetEncodeString(encodeString, encodeSize);
	}
	m_bEncode = encode;
	make_parse_file_ext();
}

void CGameData::make_parse_file_ext()
{
	int EncodeFile,ReadFile;
    char Data[300],temp[300], DataBuff[MAXBUFF],Encode[1024];
	int CurrentReadPoint=0, maxsize;
	// read encode string
	if( m_bEncode && strlen(m_EncodeStrFilePath) > 0 )
	{
		memset(Encode,0x00,sizeof(Encode));
		EncodeFile = open(m_EncodeStrFilePath, O_RDONLY );

		read( EncodeFile, m_EncodeString, sizeof(m_EncodeString) );
		close(EncodeFile);
	}
	int readsize=0;
	pTotal_header = new TotalHeader;
	memset(temp,0x00,sizeof(temp));
	memset(Data,0x00,sizeof(Data));
	ReadFile = open(m_ZipFilePath, O_RDONLY | O_BINARY);
	if(ReadFile==-1)
	{
		char buf[512];
		wsprintf(buf,"data file error(%s)",m_ZipFilePath);
		MessageBox(NULL, buf, "ATUM", MB_OK);
		return ;
	}
	maxsize = strlen(m_EncodeString);
	long length = _lseek(ReadFile, 0, SEEK_END);
	char* pTemp = new char[length];
	int readPointer=0;
	_lseek(ReadFile, 0, SEEK_SET);
	int n;
	while(n=read( ReadFile, DataBuff,sizeof(DataBuff)))
	{
		if(m_bEncode)
		{
			for(int j=0; j<n;j++)
			{
					DataBuff[j] ^= m_EncodeString[j%maxsize]; 
			}
		}
		memcpy(&pTemp[readPointer],DataBuff,n);
		readPointer += n;
		memset(DataBuff,0x00,sizeof(DataBuff));
	}
	close(ReadFile);

	// read total header
	readPointer = 0;
	memcpy( pTotal_header, &pTemp[readPointer], sizeof(TotalHeader) );
	readPointer += sizeof(TotalHeader);
	// read data header
	for( int i=0 ; i < (pTotal_header->m_DataNumber) ; i++)
	{
		DataHeader* pHeader = new DataHeader;
		memcpy((void*) pHeader, &pTemp[readPointer], sizeof(DataHeader)-4);
		readPointer += sizeof(DataHeader)-4;
		pHeader->m_pData = new char[pHeader->m_DataSize];
		memcpy((void*) pHeader->m_pData, &pTemp[readPointer], pHeader->m_DataSize );
		readPointer += pHeader->m_DataSize;
		m_mapDataHeader[pHeader->m_FileName] = pHeader;
	}	
	delete pTemp;
}

//////////////////////////////////////////////////////////////////////
// TotalHeader Class
//////////////////////////////////////////////////////////////////////

TotalHeader::TotalHeader()
{
	m_EncodeNum = 1000;
	m_Identification = 1000;
	m_FileSize = 0;
	m_DataNumber = 0;
	m_Parity = 0;
}

TotalHeader::~TotalHeader()
{

}

//////////////////////////////////////////////////////////////////////
// DataHeader Class
//////////////////////////////////////////////////////////////////////

DataHeader::DataHeader()
{
	m_EncodeNum = 0;
	m_DataSize = 0;
	m_Parity = 0;
	m_pData = NULL;
	memset(m_FileName,0x00,sizeof(m_FileName));
}

DataHeader::~DataHeader()
{
	delete [] m_pData;
}


