// LightListDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mapeditor.h"
#include "LightListDlg.h"

#include "MainFrm.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#include "LightSetDetailDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLightListDlg dialog


CLightListDlg::CLightListDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLightListDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLightListDlg)
	m_fLightAmbientB = 1.0f;
	m_fLightAmbientG = 1.0f;
	m_fLightAmbientR = 1.0f;
	m_fLightAttenuation0 = 1.0f;
	m_fLightAttenuation1 = 0.0f;
	m_fLightAttenuation2 = 0.0f;
	m_fLightDiffuseB = 1.0f;
	m_fLightDiffuseG = 1.0f;
	m_fLightDiffuseR = 1.0f;
	m_fLightDirX = 0.0f;
	m_fLightDirY = -1.0f;
	m_fLightDirZ = 0.0f;
	m_fLightFalloff = 1.0f;
	m_fLightPhi = 1.0f;
	m_fLightPosX = 0.0f;
	m_fLightPosY = 0.0f;
	m_fLightPosZ = 0.0f;
	m_fLightRange = 0.0f;
	m_fLightSpecularB = 1.0f;
	m_fLightSpecularG = 1.0f;
	m_fLightSpecularR = 1.0f;
	m_fLightTheta = 0.0f;
	m_strLightType = _T("");
	m_sLightMaxNum = 0;
	m_bLightPosition = FALSE;
	//}}AFX_DATA_INIT
}


void CLightListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLightListDlg)
	DDX_Control(pDX, IDC_LIST_LIGHT, m_listLight);
	DDX_Text(pDX, IDC_EDIT_LIGHT_AMBIENT_B, m_fLightAmbientB);
	DDX_Text(pDX, IDC_EDIT_LIGHT_AMBIENT_G, m_fLightAmbientG);
	DDX_Text(pDX, IDC_EDIT_LIGHT_AMBIENT_R, m_fLightAmbientR);
	DDX_Text(pDX, IDC_EDIT_LIGHT_ATTENUATION0, m_fLightAttenuation0);
	DDX_Text(pDX, IDC_EDIT_LIGHT_ATTENUATION1, m_fLightAttenuation1);
	DDX_Text(pDX, IDC_EDIT_LIGHT_ATTENUATION2, m_fLightAttenuation2);
	DDX_Text(pDX, IDC_EDIT_LIGHT_DIFFUSE_B, m_fLightDiffuseB);
	DDX_Text(pDX, IDC_EDIT_LIGHT_DIFFUSE_G, m_fLightDiffuseG);
	DDX_Text(pDX, IDC_EDIT_LIGHT_DIFFUSE_R, m_fLightDiffuseR);
	DDX_Text(pDX, IDC_EDIT_LIGHT_DIR_X, m_fLightDirX);
	DDX_Text(pDX, IDC_EDIT_LIGHT_DIR_Y, m_fLightDirY);
	DDX_Text(pDX, IDC_EDIT_LIGHT_DIR_Z, m_fLightDirZ);
	DDX_Text(pDX, IDC_EDIT_LIGHT_FALLOFF, m_fLightFalloff);
	DDX_Text(pDX, IDC_EDIT_LIGHT_PHI, m_fLightPhi);
	DDX_Text(pDX, IDC_EDIT_LIGHT_POS_X, m_fLightPosX);
	DDX_Text(pDX, IDC_EDIT_LIGHT_POS_Y, m_fLightPosY);
	DDX_Text(pDX, IDC_EDIT_LIGHT_POS_Z, m_fLightPosZ);
	DDX_Text(pDX, IDC_EDIT_LIGHT_RANGE, m_fLightRange);
	DDX_Text(pDX, IDC_EDIT_LIGHT_SPECULAR_B, m_fLightSpecularB);
	DDX_Text(pDX, IDC_EDIT_LIGHT_SPECULAR_G, m_fLightSpecularG);
	DDX_Text(pDX, IDC_EDIT_LIGHT_SPECULAR_R, m_fLightSpecularR);
	DDX_Text(pDX, IDC_EDIT_LIGHT_THETA, m_fLightTheta);
	DDX_Text(pDX, IDC_EDIT_LIGHT_TYPE, m_strLightType);
	DDX_Text(pDX, IDC_EDIT_LIGHT_MAXNUM, m_sLightMaxNum);
	DDX_Check(pDX, IDC_CHECK_LIGHT_POSITION, m_bLightPosition);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLightListDlg, CDialog)
	//{{AFX_MSG_MAP(CLightListDlg)
	ON_LBN_SELCHANGE(IDC_LIST_LIGHT, OnSelchangeListLight)
	ON_BN_CLICKED(IDC_BUTTON_LIGHT_DELETE, OnButtonLightDelete)
	ON_BN_CLICKED(IDC_BUTTON_LIGHT_UPDATE, OnButtonLightUpdate)
	ON_BN_CLICKED(IDC_CHECK_LIGHT_POSITION, OnCheckLightPosition)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLightListDlg message handlers

void CLightListDlg::OnSelchangeListLight() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int num = m_listLight.GetCurSel();
	int i;
	if(num >= 0)
	{
		list<D3DLIGHT8*>::iterator it = pView->m_listLightInfo.begin();
		for(i = 0;i < num;i++)
			it++;
		if(it != pView->m_listLightInfo.end())
		{
			m_fLightAmbientB = (*it)->Ambient.b;
			m_fLightAmbientG = (*it)->Ambient.g;
			m_fLightAmbientR = (*it)->Ambient.r;
			m_fLightAttenuation0 = (*it)->Attenuation0;
			m_fLightAttenuation1 = (*it)->Attenuation1;
			m_fLightAttenuation2 = (*it)->Attenuation2;
			m_fLightDiffuseB = (*it)->Diffuse.b;
			m_fLightDiffuseG = (*it)->Diffuse.g;
			m_fLightDiffuseR = (*it)->Diffuse.r;
			m_fLightDirX = (*it)->Direction.x;
			m_fLightDirY = (*it)->Direction.y;
			m_fLightDirZ = (*it)->Direction.z;
			m_fLightFalloff = (*it)->Falloff;
			m_fLightPhi = (*it)->Phi;
			m_fLightPosX = (*it)->Position.x;
			m_fLightPosY = (*it)->Position.y;
			m_fLightPosZ = (*it)->Position.z;
			m_fLightRange = (*it)->Range;
			m_fLightSpecularB = (*it)->Specular.b;
			m_fLightSpecularG = (*it)->Specular.g;
			m_fLightSpecularR = (*it)->Specular.r;
			m_fLightTheta = (*it)->Theta;
			if((*it)->Type == D3DLIGHT_POINT)
				m_strLightType.Format("D3DLIGHT_POINT");
			else if((*it)->Type == D3DLIGHT_SPOT)
				m_strLightType.Format("D3DLIGHT_SPOT");
			else if((*it)->Type == D3DLIGHT_DIRECTIONAL)
				m_strLightType.Format("D3DLIGHT_DIRECTIONAL");
			UpdateData(FALSE);
		}
	}
}

void CLightListDlg::OnButtonLightDelete() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int num = m_listLight.GetCurSel();
	int i;
	if(num >= 0)
	{
		pView->m_nUseLightNum--;
		list<D3DLIGHT8*>::iterator it = pView->m_listLightInfo.begin();
		for(i = 0;i < num;i++)
			it++;
		SAFE_DELETE((*it));
		pView->m_listLightInfo.erase(it);
		int n = m_listLight.GetCount();
		for(i=0;i < n;i++)
		   m_listLight.DeleteString( n-i-1 );
		it = pView->m_listLightInfo.begin();
		int cont = 1;
		while(it != pView->m_listLightInfo.end())
		{
			char buf[256];
			sprintf(buf,"Library updated [%d] first.",cont);
			m_listLight.AddString(buf);
			cont++;
			it++;
		}
		if(pView->m_nUseLightNum - USED_LIGHT_NUM != cont - 1)
			AfxMessageBox("Data stored in the number of light must be used.");
		pView->SetLightAll();
	}
	
}

void CLightListDlg::OnButtonLightUpdate() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int num = m_listLight.GetCurSel();
	int i;
	if(num >= 0)
	{
		list<D3DLIGHT8*>::iterator it = pView->m_listLightInfo.begin();
		for(i = 0;i < num;i++)
			it++;
		if(it != pView->m_listLightInfo.end())
		{
/*			CLightSetDetailDlg * pDlg = new CLightSetDetailDlg();
			memcpy(&pDlg->m_light,&(*it),sizeof(D3DLIGHT8));
			if(pDlg->DoModal() == IDOK)
			{
				memcpy(&(*it),&pDlg->m_light,sizeof(D3DLIGHT8));
				pView->SetLightAll();
			}
			delete pDlg;
*/	
			pView->m_pLight = (*it);
//			CLightSetDetailDlg * pDlg = new CLightSetDetailDlg();
			memcpy(&pView->m_dlgLightSetDetail.m_light,(*it),sizeof(D3DLIGHT8));
			pView->m_dlgLightSetDetail.ShowWindow( SW_SHOW );
			pView->m_dlgLightSetDetail.InitData();
//			if(pDlg->DoModal() == IDOK)
//			{
//				memcpy((*it),&pDlg->m_light,sizeof(D3DLIGHT8));
//				pView->SetLightAll();
//			}
//			delete pDlg;
//			pView->m_pLight = NULL;
		}
	}
}

void CLightListDlg::OnCheckLightPosition() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
}

void CLightListDlg::SetLightPosition(D3DXVECTOR3 vMove)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	int num = m_listLight.GetCurSel();
	int i;
	if(num >= 0)
	{
		list<D3DLIGHT8*>::iterator it = pView->m_listLightInfo.begin();
		for(i = 0;i < num;i++)
			it++;
		if(it != pView->m_listLightInfo.end())
		{
//			D3DLIGHT8 light;
//			memcpy(&light,&(*it),sizeof(D3DLIGHT8));
//			light.Position.x += vMove.x;
			(*it)->Position.x -= vMove.x;
			(*it)->Position.z -= vMove.z;
			pView->SetLightAll();
		}
	}
}
