// LightSetDetailDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mapeditor.h"
#include "LightSetDetailDlg.h"

#include "MainFrm.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLightSetDetailDlg dialog


CLightSetDetailDlg::CLightSetDetailDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLightSetDetailDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLightSetDetailDlg)
	//}}AFX_DATA_INIT
}


void CLightSetDetailDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLightSetDetailDlg)
	DDX_Control(pDX, IDC_SLIDER_SPECULAR_R, m_sliderLightSpecularR);
	DDX_Control(pDX, IDC_SLIDER_SPECULAR_G, m_sliderLightSpecularG);
	DDX_Control(pDX, IDC_SLIDER_SPECULAR_B, m_sliderLightSpecularB);
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_R, m_sliderLightDiffuseR);
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_G, m_sliderLightDiffuseG);
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_B, m_sliderLightDiffuseB);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_R, m_sliderLightAmbientR);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_G, m_sliderLightAmbientG);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_B, m_sliderLightAmbientB);
	DDX_Control(pDX, IDC_COMBO_LIGHT_TYPE, m_comboLightType);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_B, m_fLightAmbientB);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_G, m_fLightAmbientG);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_R, m_fLightAmbientR);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_B, m_fLightDiffuseB);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_G, m_fLightDiffuseG);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_R, m_fLightDiffuseR);
	DDX_Text(pDX, IDC_EDIT_DIRECTION_X, m_fLightDirX);
	DDX_Text(pDX, IDC_EDIT_DIRECTION_Y, m_fLightDirY);
	DDX_Text(pDX, IDC_EDIT_DIRECTION_Z, m_fLightDirZ);
	DDX_Text(pDX, IDC_EDIT_LIGHT_ATTENUATION0, m_fLightAttenuation0);
	DDX_Text(pDX, IDC_EDIT_LIGHT_ATTENUATION1, m_fLightAttenuation1);
	DDX_Text(pDX, IDC_EDIT_LIGHT_ATTENUATION2, m_fLightAttenuation2);
	DDX_Text(pDX, IDC_EDIT_LIGHT_FALLOFF, m_fLightFalloff);
	DDX_Text(pDX, IDC_EDIT_LIGHT_PHI, m_fLightPhi);
	DDX_Text(pDX, IDC_EDIT_LIGHT_RANGE, m_fLightRange);
	DDX_Text(pDX, IDC_EDIT_LIGHT_THETA, m_fLightTheta);
	DDX_Text(pDX, IDC_EDIT_POSITION_X, m_fLightPosX);
	DDX_Text(pDX, IDC_EDIT_POSITION_Y, m_fLightPosY);
	DDX_Text(pDX, IDC_EDIT_POSITION_Z, m_fLightPosZ);
	DDX_Text(pDX, IDC_EDIT_SPECULAR_B, m_fLightSpecularB);
	DDX_Text(pDX, IDC_EDIT_SPECULAR_G, m_fLightSpecularG);
	DDX_Text(pDX, IDC_EDIT_SPECULAR_R, m_fLightSpecularR);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLightSetDetailDlg, CDialog)
	//{{AFX_MSG_MAP(CLightSetDetailDlg)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_B, OnReleasedcaptureSliderAmbientB)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_G, OnReleasedcaptureSliderAmbientG)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_R, OnReleasedcaptureSliderAmbientR)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_B, OnReleasedcaptureSliderDiffuseB)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_G, OnReleasedcaptureSliderDiffuseG)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_R, OnReleasedcaptureSliderDiffuseR)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SPECULAR_B, OnReleasedcaptureSliderSpecularB)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SPECULAR_G, OnReleasedcaptureSliderSpecularG)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SPECULAR_R, OnReleasedcaptureSliderSpecularR)
	ON_CBN_SELCHANGE(IDC_COMBO_LIGHT_TYPE, OnSelchangeComboLightType)
	ON_EN_CHANGE(IDC_EDIT_AMBIENT_B, OnChangeEditAmbientB)
	ON_EN_CHANGE(IDC_EDIT_AMBIENT_G, OnChangeEditAmbientG)
	ON_EN_CHANGE(IDC_EDIT_AMBIENT_R, OnChangeEditAmbientR)
	ON_EN_CHANGE(IDC_EDIT_DIFFUSE_B, OnChangeEditDiffuseB)
	ON_EN_CHANGE(IDC_EDIT_DIFFUSE_G, OnChangeEditDiffuseG)
	ON_EN_CHANGE(IDC_EDIT_DIFFUSE_R, OnChangeEditDiffuseR)
	ON_EN_CHANGE(IDC_EDIT_DIRECTION_X, OnChangeEditDirectionX)
	ON_EN_CHANGE(IDC_EDIT_DIRECTION_Y, OnChangeEditDirectionY)
	ON_EN_CHANGE(IDC_EDIT_DIRECTION_Z, OnChangeEditDirectionZ)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_ATTENUATION0, OnChangeEditLightAttenuation0)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_ATTENUATION1, OnChangeEditLightAttenuation1)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_ATTENUATION2, OnChangeEditLightAttenuation2)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_FALLOFF, OnChangeEditLightFalloff)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_PHI, OnChangeEditLightPhi)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_RANGE, OnChangeEditLightRange)
	ON_EN_CHANGE(IDC_EDIT_LIGHT_THETA, OnChangeEditLightTheta)
	ON_EN_CHANGE(IDC_EDIT_POSITION_X, OnChangeEditPositionX)
	ON_EN_CHANGE(IDC_EDIT_POSITION_Y, OnChangeEditPositionY)
	ON_EN_CHANGE(IDC_EDIT_POSITION_Z, OnChangeEditPositionZ)
	ON_EN_CHANGE(IDC_EDIT_SPECULAR_B, OnChangeEditSpecularB)
	ON_EN_CHANGE(IDC_EDIT_SPECULAR_G, OnChangeEditSpecularG)
	ON_EN_CHANGE(IDC_EDIT_SPECULAR_R, OnChangeEditSpecularR)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLightSetDetailDlg message handlers

BOOL CLightSetDetailDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_light.Type = D3DLIGHT_POINT;
	m_light.Ambient.b = m_fLightAmbientB = 1.0f;
	m_light.Ambient.g = m_fLightAmbientG = 1.0f;
	m_light.Ambient.r = m_fLightAmbientR = 1.0f;
	m_light.Diffuse.b = m_fLightDiffuseB = 1.0f;
	m_light.Diffuse.g = m_fLightDiffuseG = 1.0f;
	m_light.Diffuse.r = m_fLightDiffuseR = 1.0f;
	m_light.Direction.x = m_fLightDirX = 0.0f;
	m_light.Direction.y = m_fLightDirY = -1.0f;
	m_light.Direction.z = m_fLightDirZ = 0.0f;
	m_light.Attenuation0 = m_fLightAttenuation0 = 0.0f;
	m_light.Attenuation1 = m_fLightAttenuation1 = 0.0f;
	m_light.Attenuation2 = m_fLightAttenuation2 = 0.0f;
	m_light.Falloff = m_fLightFalloff = 0.0f;
	m_light.Phi = m_fLightPhi = 0.0f;
	m_light.Range = m_fLightRange = 0.0f;
	m_light.Theta = m_fLightTheta = 0.0f;
	m_light.Position.x = m_fLightPosX = 0.0f;
	m_light.Position.y = m_fLightPosY = 0.0f;
	m_light.Position.z = m_fLightPosZ = 0.0f;
	m_light.Specular.b = m_fLightSpecularB = 1.0f;
	m_light.Specular.g = m_fLightSpecularG = 1.0f;
	m_light.Specular.r = m_fLightSpecularR = 1.0f;

	m_sliderLightDiffuseR.SetRange(0,1000);
//	m_sliderLightDiffuseR.SetPos(1000);
	m_sliderLightDiffuseG.SetRange(0,1000);
//	m_sliderLightDiffuseG.SetPos(1000);
	m_sliderLightDiffuseB.SetRange(0,1000);
//	m_sliderLightDiffuseB.SetPos(1000);

	m_sliderLightAmbientR.SetRange(0,1000);
//	m_sliderLightAmbientR.SetPos(1000);
	m_sliderLightAmbientG.SetRange(0,1000);
//	m_sliderLightAmbientG.SetPos(1000);
	m_sliderLightAmbientB.SetRange(0,1000);
//	m_sliderLightAmbientB.SetPos(1000);

	m_sliderLightSpecularR.SetRange(0,1000);
//	m_sliderLightSpecularR.SetPos(1000);
	m_sliderLightSpecularG.SetRange(0,1000);
//	m_sliderLightSpecularG.SetPos(1000);
	m_sliderLightSpecularB.SetRange(0,1000);
//	m_sliderLightSpecularB.SetPos(1000);

	
	m_comboLightType.SetCurSel(m_light.Type - 1);

	m_fLightAmbientB = m_light.Ambient.b;
	m_fLightAmbientG = m_light.Ambient.g;
	m_fLightAmbientR = m_light.Ambient.r;
	m_fLightDiffuseB = m_light.Diffuse.b;
	m_fLightDiffuseG = m_light.Diffuse.g;
	m_fLightDiffuseR = m_light.Diffuse.r;
	m_fLightDirX = m_light.Direction.x;
	m_fLightDirY = m_light.Direction.y;
	m_fLightDirZ = m_light.Direction.z;
	m_fLightAttenuation0 = m_light.Attenuation0;
	m_fLightAttenuation1 = m_light.Attenuation1;
	m_fLightAttenuation2 = m_light.Attenuation2;
	m_fLightFalloff = m_light.Falloff;
	m_fLightPhi = m_light.Phi;
	m_fLightRange = m_light.Range;
	m_fLightTheta = m_light.Theta;
	m_fLightPosX = m_light.Position.x;
	m_fLightPosY = m_light.Position.y;
	m_fLightPosZ = m_light.Position.z;
	m_fLightSpecularB = m_light.Specular.b;
	m_fLightSpecularG = m_light.Specular.g;
	m_fLightSpecularR = m_light.Specular.r;
	UpdateData(FALSE);
	
	m_sliderLightAmbientB.SetPos((int)(m_fLightAmbientB*1000.0f));
	m_sliderLightAmbientG.SetPos((int)(m_fLightAmbientG*1000.0f));
	m_sliderLightAmbientR.SetPos((int)(m_fLightAmbientR*1000.0f));
	m_sliderLightDiffuseB.SetPos((int)(m_fLightDiffuseB*1000.0f));
	m_sliderLightDiffuseG.SetPos((int)(m_fLightDiffuseG*1000.0f));
	m_sliderLightDiffuseR.SetPos((int)(m_fLightDiffuseR*1000.0f));
	m_sliderLightSpecularB.SetPos((int)(m_fLightSpecularB*1000.0f));
	m_sliderLightSpecularG.SetPos((int)(m_fLightSpecularG*1000.0f));
	m_sliderLightSpecularR.SetPos((int)(m_fLightSpecularR*1000.0f)); 
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLightSetDetailDlg::OnReleasedcaptureSliderAmbientB(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightAmbientB = (float)m_sliderLightAmbientB.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Ambient.b = m_fLightAmbientB;
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnReleasedcaptureSliderAmbientG(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightAmbientG = (float)m_sliderLightAmbientG.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Ambient.g = m_fLightAmbientG;	
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnReleasedcaptureSliderAmbientR(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightAmbientR = (float)m_sliderLightAmbientR.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Ambient.r = m_fLightAmbientR;	
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnReleasedcaptureSliderDiffuseB(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightDiffuseB = (float)m_sliderLightDiffuseB.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Diffuse.b = m_fLightDiffuseB;	
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnReleasedcaptureSliderDiffuseG(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightDiffuseG = (float)m_sliderLightDiffuseG.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Diffuse.g = m_fLightDiffuseG;	
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnReleasedcaptureSliderDiffuseR(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightDiffuseR = (float)m_sliderLightDiffuseR.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Diffuse.r = m_fLightDiffuseR;		
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnReleasedcaptureSliderSpecularB(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightSpecularB = (float)m_sliderLightSpecularB.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Specular.b = m_fLightSpecularB;		
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnReleasedcaptureSliderSpecularG(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightSpecularG = (float)m_sliderLightSpecularG.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Specular.g = m_fLightSpecularG;			
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnReleasedcaptureSliderSpecularR(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	m_fLightSpecularR = (float)m_sliderLightSpecularR.GetPos()/1000.0f;
	UpdateData(FALSE);	
	m_light.Specular.r = m_fLightSpecularR;			
	*pResult = 0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnSelchangeComboLightType() 
{
	// TODO: Add your control notification handler code here
//	UpdateData();
	int type = m_comboLightType.GetCurSel();
	if(type==0)
		m_light.Type = D3DLIGHT_POINT;
	else if(type==1)
		m_light.Type = D3DLIGHT_SPOT;
	else if(type==2)
		m_light.Type = D3DLIGHT_DIRECTIONAL;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditAmbientB() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Ambient.b = m_fLightAmbientB;
	m_sliderLightAmbientB.SetPos((int)(m_fLightAmbientB*1000.0f));

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditAmbientG() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Ambient.g = m_fLightAmbientG;
	m_sliderLightAmbientG.SetPos((int)(m_fLightAmbientG*1000.0f));

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditAmbientR() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Ambient.r = m_fLightAmbientR;
	m_sliderLightAmbientR.SetPos((int)(m_fLightAmbientR*1000.0f));

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditDiffuseB() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Diffuse.b = m_fLightDiffuseB;	
	m_sliderLightDiffuseB.SetPos((int)(m_fLightDiffuseB*1000.0f));

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditDiffuseG() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Diffuse.g = m_fLightDiffuseG;	
	m_sliderLightDiffuseG.SetPos((int)(m_fLightDiffuseG*1000.0f));

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditDiffuseR() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Diffuse.r = m_fLightDiffuseR;	
	m_sliderLightDiffuseR.SetPos((int)(m_fLightDiffuseR*1000.0f));

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditDirectionX() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();	
	m_light.Direction.x = m_fLightDirX;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditDirectionY() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Direction.y = m_fLightDirY;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditDirectionZ() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Direction.z = m_fLightDirZ;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditLightAttenuation0() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();	
	m_light.Attenuation0 = m_fLightAttenuation0;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditLightAttenuation1() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Attenuation1 = m_fLightAttenuation1;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditLightAttenuation2() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Attenuation2 = m_fLightAttenuation2;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditLightFalloff() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Falloff = m_fLightFalloff;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditLightPhi() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();	
	m_light.Phi = m_fLightPhi;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditLightRange() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();
	m_light.Range = m_fLightRange;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditLightTheta() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();	
	m_light.Theta = m_fLightTheta;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditPositionX() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();	
	m_light.Position.x = m_fLightPosX;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditPositionY() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Position.y = m_fLightPosY;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditPositionZ() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Position.z = m_fLightPosZ;

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditSpecularB() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Specular.b = m_fLightSpecularB;		
	m_sliderLightSpecularB.SetPos((int)(m_fLightSpecularB*1000.0f));

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditSpecularG() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Specular.g = m_fLightSpecularG;		
	m_sliderLightSpecularG.SetPos((int)(m_fLightSpecularG*1000.0f));

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}

void CLightSetDetailDlg::OnChangeEditSpecularR() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();		
	m_light.Specular.r = m_fLightSpecularR;		
	m_sliderLightSpecularR.SetPos((int)(m_fLightSpecularR*1000.0f)); 

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	memcpy( pView->m_pLight, &m_light, sizeof( D3DLIGHT8 ) );
	pView->SetLightAll();
}
void CLightSetDetailDlg::InitData()
{
	m_comboLightType.SetCurSel( m_light.Type - 1 );
	m_fLightAmbientB = m_light.Ambient.b;
	m_fLightAmbientG = m_light.Ambient.g;
	m_fLightAmbientR = m_light.Ambient.r;
	m_fLightDiffuseB = m_light.Diffuse.b;
	m_fLightDiffuseG = m_light.Diffuse.g;
	m_fLightDiffuseR = m_light.Diffuse.r;
	m_fLightDirX = m_light.Direction.x;
	m_fLightDirY = m_light.Direction.y;
	m_fLightDirZ = m_light.Direction.z;
	m_fLightAttenuation0 = m_light.Attenuation0;
	m_fLightAttenuation1 = m_light.Attenuation1;
	m_fLightAttenuation2 = m_light.Attenuation2;
	m_fLightFalloff = m_light.Falloff;
	m_fLightPhi = m_light.Phi;
	m_fLightRange = m_light.Range;
	m_fLightTheta = m_light.Theta;
	m_fLightPosX = m_light.Position.x;
	m_fLightPosY = m_light.Position.y;
	m_fLightPosZ = m_light.Position.z;
	m_fLightSpecularB = m_light.Specular.b;
	m_fLightSpecularG = m_light.Specular.g;
	m_fLightSpecularR = m_light.Specular.r;
	m_sliderLightAmbientB.SetPos((int)(m_fLightAmbientB*1000.0f));
	m_sliderLightAmbientG.SetPos((int)(m_fLightAmbientG*1000.0f));
	m_sliderLightAmbientR.SetPos((int)(m_fLightAmbientR*1000.0f));
	m_sliderLightDiffuseB.SetPos((int)(m_fLightDiffuseB*1000.0f));
	m_sliderLightDiffuseG.SetPos((int)(m_fLightDiffuseG*1000.0f));
	m_sliderLightDiffuseR.SetPos((int)(m_fLightDiffuseR*1000.0f));
	m_sliderLightSpecularB.SetPos((int)(m_fLightSpecularB*1000.0f));
	m_sliderLightSpecularG.SetPos((int)(m_fLightSpecularG*1000.0f));
	m_sliderLightSpecularR.SetPos((int)(m_fLightSpecularR*1000.0f)); 

	UpdateData(FALSE);
}

void CLightSetDetailDlg::OnOK() 
{
	// TODO: Add extra validation here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	pView->m_dlgLightSetDetail.ShowWindow( SW_HIDE );
	
	CDialog::OnOK();
}
