// LightSetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mapeditor.h"
#include "LightSetDlg.h"

#include "MainFrm.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLightSetDlg dialog

extern LPDIRECT3DDEVICE8	g_pD3dDev;

CLightSetDlg::CLightSetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLightSetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLightSetDlg)
	m_editAmbientB = 1.0f;
	m_editAmbientG = 1.0f;
	m_editAmbientR = 1.0f;
	m_editDiffuseB = 1.0f;
	m_editDiffuseG = 1.0f;
	m_editDiffuseR = 1.0f;
	m_editDirectionX = -1.0f;
	m_editDirectionY = -1.0f;
	m_editDirectionZ = -1.0f;
	m_bChangeLight = FALSE;
	m_editAmbientB2 = 0.0f;
	m_editAmbientG2 = 0.0f;
	m_editAmbientR2 = 0.0f;
	m_editDiffuseB2 = 0.0f;
	m_editDiffuseG2 = 0.0f;
	m_editDiffuseR2 = 0.0f;
	//}}AFX_DATA_INIT
}


void CLightSetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLightSetDlg)
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_R2, m_sliderDiffuseR2);
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_G2, m_sliderDiffuseG2);
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_B2, m_sliderDiffuseB2);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_R2, m_sliderAmbientR2);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_G2, m_sliderAmbientG2);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_B2, m_sliderAmbientB2);
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_R, m_sliderDiffuseR);
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_G, m_sliderDiffuseG);
	DDX_Control(pDX, IDC_SLIDER_DIFFUSE_B, m_sliderDiffuseB);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_R, m_sliderAmbientR);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_G, m_sliderAmbientG);
	DDX_Control(pDX, IDC_SLIDER_AMBIENT_B, m_sliderAmbientB);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_B, m_editAmbientB);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_G, m_editAmbientG);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_R, m_editAmbientR);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_B, m_editDiffuseB);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_G, m_editDiffuseG);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_R, m_editDiffuseR);
	DDX_Text(pDX, IDC_EDIT_DIRECTION_X, m_editDirectionX);
	DDX_Text(pDX, IDC_EDIT_DIRECTION_Y, m_editDirectionY);
	DDX_Text(pDX, IDC_EDIT_DIRECTION_Z, m_editDirectionZ);
	DDX_Check(pDX, IDC_CHECK_CHANGE_LIGHT, m_bChangeLight);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_B2, m_editAmbientB2);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_G2, m_editAmbientG2);
	DDX_Text(pDX, IDC_EDIT_AMBIENT_R2, m_editAmbientR2);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_B2, m_editDiffuseB2);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_G2, m_editDiffuseG2);
	DDX_Text(pDX, IDC_EDIT_DIFFUSE_R2, m_editDiffuseR2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLightSetDlg, CDialog)
	//{{AFX_MSG_MAP(CLightSetDlg)
	ON_EN_CHANGE(IDC_EDIT_DIRECTION_X, OnChangeEditDirectionX)
	ON_EN_CHANGE(IDC_EDIT_DIRECTION_Y, OnChangeEditDirectionY)
	ON_EN_CHANGE(IDC_EDIT_DIRECTION_Z, OnChangeEditDirectionZ)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_B, OnReleasedcaptureSliderAmbientB)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_G, OnReleasedcaptureSliderAmbientG)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_R, OnReleasedcaptureSliderAmbientR)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_B, OnReleasedcaptureSliderDiffuseB)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_G, OnReleasedcaptureSliderDiffuseG)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_R, OnReleasedcaptureSliderDiffuseR)
	ON_BN_CLICKED(IDC_CHECK_CHANGE_LIGHT, OnCheckChangeLight)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_B2, OnReleasedcaptureSliderAmbientB2)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_G2, OnReleasedcaptureSliderAmbientG2)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AMBIENT_R2, OnReleasedcaptureSliderAmbientR2)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_B2, OnReleasedcaptureSliderDiffuseB2)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_G2, OnReleasedcaptureSliderDiffuseG2)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_DIFFUSE_R2, OnReleasedcaptureSliderDiffuseR2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLightSetDlg message handlers

void CLightSetDlg::OnChangeEditDirectionX() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	UpdateData();	
	pView->light.Direction.x = m_editDirectionX;
	g_pD3dDev->SetLight( 0, &pView->light );
}

void CLightSetDlg::OnChangeEditDirectionY() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	UpdateData();	
	pView->light.Direction.y = m_editDirectionY;
	g_pD3dDev->SetLight( 0, &pView->light );
}

void CLightSetDlg::OnChangeEditDirectionZ() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	UpdateData();	
	pView->light.Direction.z = m_editDirectionZ;
	g_pD3dDev->SetLight( 0, &pView->light );
}

void CLightSetDlg::OnReleasedcaptureSliderAmbientB(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editAmbientB = (float)m_sliderAmbientB.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fAmbientB1 = m_editAmbientB;
	UpdateData(FALSE);	
	
	if(!m_bChangeLight)
	{
		pView->light.Ambient.b = m_editAmbientB;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderAmbientG(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editAmbientG = (float)m_sliderAmbientG.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fAmbientG1 = m_editAmbientG;
	UpdateData(FALSE);	
	
	if(!m_bChangeLight)
	{
		pView->light.Ambient.g = m_editAmbientG;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderAmbientR(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editAmbientR = (float)m_sliderAmbientR.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fAmbientR1 = m_editAmbientR;
	UpdateData(FALSE);	
	
	if(!m_bChangeLight)
	{
		pView->light.Ambient.r = m_editAmbientR;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderDiffuseB(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editDiffuseB = (float)m_sliderDiffuseB.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fDiffuseB1 = m_editDiffuseB;
	UpdateData(FALSE);	
	
	if(!m_bChangeLight)
	{
		pView->light.Diffuse.b = m_editDiffuseB;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderDiffuseG(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editDiffuseG = (float)m_sliderDiffuseG.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fDiffuseG1 = m_editDiffuseG;
	UpdateData(FALSE);	
	
	if(!m_bChangeLight)
	{
		pView->light.Diffuse.g = m_editDiffuseG;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderDiffuseR(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editDiffuseR = (float)m_sliderDiffuseR.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fDiffuseR1 = m_editDiffuseR;
	UpdateData(FALSE);	
	
	if(!m_bChangeLight)
	{
		pView->light.Diffuse.r = m_editDiffuseR;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

BOOL CLightSetDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_sliderDiffuseR.SetRange(0,1000);
	m_sliderDiffuseR.SetPos(1000);
	m_sliderDiffuseG.SetRange(0,1000);
	m_sliderDiffuseG.SetPos(1000);
	m_sliderDiffuseB.SetRange(0,1000);
	m_sliderDiffuseB.SetPos(1000);

	m_sliderAmbientR.SetRange(0,1000);
	m_sliderAmbientR.SetPos(1000);
	m_sliderAmbientG.SetRange(0,1000);
	m_sliderAmbientG.SetPos(1000);
	m_sliderAmbientB.SetRange(0,1000);
	m_sliderAmbientB.SetPos(1000);
	
	m_sliderDiffuseR2.SetRange(0,1000);
	m_sliderDiffuseR2.SetPos(0);
	m_sliderDiffuseG2.SetRange(0,1000);
	m_sliderDiffuseG2.SetPos(0);
	m_sliderDiffuseB2.SetRange(0,1000);
	m_sliderDiffuseB2.SetPos(0);

	m_sliderAmbientR2.SetRange(0,1000);
	m_sliderAmbientR2.SetPos(0);
	m_sliderAmbientG2.SetRange(0,1000);
	m_sliderAmbientG2.SetPos(0);
	m_sliderAmbientB2.SetRange(0,1000);
	m_sliderAmbientB2.SetPos(0);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLightSetDlg::SetData(PROJECTINFO project)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editDiffuseR = project.m_fDiffuseR1;
	m_editDiffuseG = project.m_fDiffuseG1;
	m_editDiffuseB = project.m_fDiffuseB1;

	m_editAmbientR = project.m_fAmbientR1;
	m_editAmbientG = project.m_fAmbientG1;
	m_editAmbientB = project.m_fAmbientB1;

	m_sliderDiffuseR.SetPos((int)(m_editDiffuseR*1000));
	m_sliderDiffuseG.SetPos((int)(m_editDiffuseG*1000));
	m_sliderDiffuseB.SetPos((int)(m_editDiffuseB*1000));

	m_sliderAmbientR.SetPos((int)(m_editAmbientR*1000));
	m_sliderAmbientG.SetPos((int)(m_editAmbientG*1000));
	m_sliderAmbientB.SetPos((int)(m_editAmbientB*1000));

	m_editDiffuseR2 = project.m_fDiffuseR2;
	m_editDiffuseG2 = project.m_fDiffuseG2;
	m_editDiffuseB2 = project.m_fDiffuseB2;

	m_editAmbientR2 = project.m_fAmbientR2;
	m_editAmbientG2 = project.m_fAmbientG2;
	m_editAmbientB2 = project.m_fAmbientB2;

	m_sliderDiffuseR2.SetPos((int)(m_editDiffuseR2*1000));
	m_sliderDiffuseG2.SetPos((int)(m_editDiffuseG2*1000));
	m_sliderDiffuseB2.SetPos((int)(m_editDiffuseB2*1000));

	m_sliderAmbientR2.SetPos((int)(m_editAmbientR2*1000));
	m_sliderAmbientG2.SetPos((int)(m_editAmbientG2*1000));
	m_sliderAmbientB2.SetPos((int)(m_editAmbientB2*1000));

	m_bChangeLight = FALSE;
	pView->light.Diffuse.r  = m_editDiffuseR;
	pView->light.Diffuse.g  = m_editDiffuseG;
	pView->light.Diffuse.b  = m_editDiffuseB;
	pView->light.Ambient.r  = m_editAmbientR;
	pView->light.Ambient.g  = m_editAmbientG;
	pView->light.Ambient.b  = m_editAmbientB;
	g_pD3dDev->SetLight( 0, &pView->light );
	UpdateData(FALSE);
}

void CLightSetDlg::OnCheckChangeLight() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	UpdateData();
	if(m_bChangeLight)
	{
		pView->light.Diffuse.r  = m_editDiffuseR2;
		pView->light.Diffuse.g  = m_editDiffuseG2;
		pView->light.Diffuse.b  = m_editDiffuseB2;
		pView->light.Ambient.r  = m_editAmbientR2;
		pView->light.Ambient.g  = m_editAmbientG2;
		pView->light.Ambient.b  = m_editAmbientB2;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	else
	{
		pView->light.Diffuse.r  = m_editDiffuseR;
		pView->light.Diffuse.g  = m_editDiffuseG;
		pView->light.Diffuse.b  = m_editDiffuseB;
		pView->light.Ambient.r  = m_editAmbientR;
		pView->light.Ambient.g  = m_editAmbientG;
		pView->light.Ambient.b  = m_editAmbientB;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
}

void CLightSetDlg::OnReleasedcaptureSliderAmbientB2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editAmbientB2 = (float)m_sliderAmbientB2.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fAmbientB2 = m_editAmbientB2;
	UpdateData(FALSE);
	
	if(m_bChangeLight)
	{
		pView->light.Ambient.b  = m_editAmbientB2;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderAmbientG2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editAmbientG2 = (float)m_sliderAmbientG2.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fAmbientG2 = m_editAmbientG2;
	UpdateData(FALSE);	
	
	if(m_bChangeLight)
	{
		pView->light.Ambient.g  = m_editAmbientG2;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderAmbientR2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editAmbientR2 = (float)m_sliderAmbientR2.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fAmbientR2 = m_editAmbientR2;
	UpdateData(FALSE);	
	
	if(m_bChangeLight)
	{
		pView->light.Ambient.r  = m_editAmbientR2;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderDiffuseB2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editDiffuseB2 = (float)m_sliderDiffuseB2.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fDiffuseB2 = m_editDiffuseB2;
	UpdateData(FALSE);	
	
	if(m_bChangeLight)
	{
		pView->light.Diffuse.b  = m_editDiffuseB2;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderDiffuseG2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editDiffuseG2 = (float)m_sliderDiffuseG2.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fDiffuseG2 = m_editDiffuseG2;
	UpdateData(FALSE);	
	
	if(m_bChangeLight)
	{
		pView->light.Diffuse.g  = m_editDiffuseG2;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}

void CLightSetDlg::OnReleasedcaptureSliderDiffuseR2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	m_editDiffuseR2 = (float)m_sliderDiffuseR2.GetPos()/1000.0f;
	pView->m_pBackground->m_projectInfo.m_fDiffuseR2 = m_editDiffuseR2;
	UpdateData(FALSE);	
	
	if(m_bChangeLight)
	{
		pView->light.Diffuse.r  = m_editDiffuseR2;
		g_pD3dDev->SetLight( 0, &pView->light );
	}
	*pResult = 0;
}
