// MapEditorView.h : interface of the CMapEditorView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAPEDITORVIEW_H__D55DB87E_3BE4_475D_8D98_EEDDB21DB07C__INCLUDED_)
#define AFX_MAPEDITORVIEW_H__D55DB87E_3BE4_475D_8D98_EEDDB21DB07C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "StdAfx.h"
#include "Background.h"
#include "D3DFont.h"
#include "ObjectRender.h"
#include "ObjectChild.h"
#include "EventSetDlg.h"
#include "WorkspaceDlg.h"
#include "MiniMap.h"
#include "ObjectSetDlg.h"
#include "MonsterSetDlg.h"
#include "LightSetDlg.h"
#include "EditDlg.h"

#include "EffectSetDlg.h"
#include "LightListDlg.h"
#include "AllListDlg.h"
//#include "ProjectDetailDlg.h"
#include ".\Src_Eff\EffectRender.h"// by dhkwon 2003.5.16
#include "LightSetDetailDlg.h"

#include "LightRender.h"

typedef struct _MAPOBJECTINFO
{
	INT		Code;						// Object Type
	BOOL	Alpha;						//
	USHORT	RadiusForServer;			// Ojbect , 
	USHORT	RadiusForClient;			// Ojbect , Ŭ̾Ʈ
	BOOL	Collision;					// 浹 ó ÷
} MAPOBJECTINFO;



typedef struct _TILESETINFO
{
	char TileSetName[40];
	int index;
} TileSetInfo;

typedef struct _EFFECTINFO
{
	char		strEffectName[40];
	INT			nType;
	BOOL		bRegion;
	BOOL		bLoop;
	FLOAT		fReTime;
	FLOAT		fCheckTime;
	D3DXVECTOR3 vPos;
} EFFECTINFO;

typedef struct _EFFECTINFOCLIENT
{
	INT			nType;
	BOOL		bRegion;
	BOOL		bLoop;
	FLOAT		fReTime;
	D3DXVECTOR3 vPos;
} EFFECTINFOCLIENT;

////////////////////////////////////
// ĳ &  
typedef UINT64 BodyCond_t;

#define NUM_OF_BODYCONDITION_BIT		64

// Body Conditions
#define BODYCON_SET_OR_CLEAR_MASK		(BodyCond_t)0x0000000000000001		// set(1) or clear(0)
// start - exclusive condition
#define BODYCON_FLY_MASK				(BodyCond_t)0x0000000000000002		// 
#define BODYCON_LANDED_MASK				(BodyCond_t)0x0000000000000004		// 
#define	BODYCON_DEAD_MASK				(BodyCond_t)0x0000000000000008		// 
#define BODYCON_NOT_USED1_MASK			(BodyCond_t)0x0000000000000010
// end - exclusive condition
// start - new bodycon
#define BODYCON_NOT_USED2_MASK			(BodyCond_t)0x0000000000000020
#define BODYCON_LANDING_MASK			(BodyCond_t)0x0000000000000040		//
#define BODYCON_BOOSTER1_MASK			(BodyCond_t)0x0000000000000080		//ν(1~10)
#define BODYCON_BOOSTER2_MASK			(BodyCond_t)0x0000000000000100		//ν(10~15)
#define BODYCON_BOOSTER3_MASK			(BodyCond_t)0x0000000000000200		//ν(70~80)
#define BODYCON_BOOSTER4_MASK			(BodyCond_t)0x0000000000000400		//ν(81~100)
#define BODYCON_NIGHTFLY_MASK			(BodyCond_t)0x0000000000000800		//߰(߰)
#define BODYCON_EXPLOSION_MASK			(BodyCond_t)0x0000000000001000		//
#define BODYCON_DAMAGE1_MASK			(BodyCond_t)0x0000000000002000		//1, 
#define BODYCON_DAMAGE2_MASK			(BodyCond_t)0x0000000000004000		//2, 
#define BODYCON_DAMAGE3_MASK			(BodyCond_t)0x0000000000008000		//3, 
#define BODYCON_CREATION_MASK			(BodyCond_t)0x0000000000010000		//
#define BODYCON_FIRE_MASK				(BodyCond_t)0x0000000000020000		//߻
#define BODYCON_BULLET_MASK				(BodyCond_t)0x0000000000040000		//źü
#define BODYCON_HIT_MASK				(BodyCond_t)0x0000000000080000		//Ÿ
#define BODYCON_SPRAY_MASK              (BodyCond_t)0x0000000000100000		//,,
#define BODYCON_ATTACK1_MASK            (BodyCond_t)0x0000000000200000		//Ͱ1
#define BODYCON_ATTACK2_MASK            (BodyCond_t)0x0000000000400000		//Ͱ2
#define BODYCON_ATTACK3_MASK            (BodyCond_t)0x0000000000800000		//Ͱ3
#define BODYCON_ATTACK4_MASK            (BodyCond_t)0x0000000001000000		//Ͱ4
#define BODYCON_ATTACK5_MASK            (BodyCond_t)0x0000000002000000		//ͽų
// end - new bodycon
#define	BODYCON_SHAKEING_MASK			(BodyCond_t)0x0000000004000000		// 鸲
#define	BODYCON_FREEZING_MASK			(BodyCond_t)0x0000000008000000		// 
#define	BODYCON_ATTACKSLOW_MASK			(BodyCond_t)0x0000000010000000		//  
#define	BODYCON_SLOW_MASK				(BodyCond_t)0x0000000020000000		// ǵ 
#define	BODYCON_NOATTACK_MASK			(BodyCond_t)0x0000000040000000		// ݱ
#define	BODYCON_ILLUSION_MASK			(BodyCond_t)0x0000000080000000		// 
#define	BODYCON_FIGHTING_MASK			(BodyCond_t)0x0000000100000000		// 
#define BODYCON_EVENT_HANDLE_MASK		(BodyCond_t)0x0000000200000000		// ̺Ʈ(, ) ó,  client ̵  
#define BODYCON_STOP_MASK				(BodyCond_t)0x0000000400000000		// 	------>  ϴ 2002.11.25. ߰
#define BODYCON_STEALTH_MASK			(BodyCond_t)0x0000000800000000		// ڽ
#define BODYCON_GHOST_MASK				(BodyCond_t)0x0000001000000000		// Ʈ
#define BODYCON_CLOAKING_MASK			(BodyCond_t)0x0000002000000000		// Ŭŷ
#define BODYCON_FALL_MASK				(BodyCond_t)0x0000004000000000		// ߶
#define BODYCON_SKILLBAN_MASK			(BodyCond_t)0x0000008000000000		// ų
#define BODYCON_RESIST_MASK				(BodyCond_t)0x0000010000000000		// ų׻
#define BODYCON_SHIELD_MASK				(BodyCond_t)0x0000020000000000		//  , 20030917 ߰
// bit  ũ
#define CLEAR_BODYCON_BIT(VAR, MASK) { VAR &= ~MASK; }
#define SET_BODYCON_BIT(VAR, MASK)								\
{																\
	if ((MASK & BODYCON_EX_STATE_CLEAR_MASK) != 0)				\
	{															\
		CLEAR_BODYCON_BIT(VAR, BODYCON_EX_STATE_CLEAR_MASK);	\
	}															\
	if ((MASK & BODYCON_BOOSTER_EX_STATE_CLEAR_MASK) != 0)		\
	{															\
		CLEAR_BODYCON_BIT(VAR, BODYCON_BOOSTER_EX_STATE_CLEAR_MASK);\
	}															\
	VAR |= MASK;												\
}
#define COMPARE_BODYCON_BIT(VAR, MASK) (((VAR) & (MASK)) != 0)
#define BODYCON_EX_STATE_CLEAR_MASK		(BodyCond_t)(BODYCON_FLY_MASK | BODYCON_LANDED_MASK | BODYCON_DEAD_MASK | BODYCON_NOT_USED1_MASK)
										// BODYCON_FLY_MASK | BODYCON_LANDED_MASK | BODYCON_DEAD_MASK | BODYCON_NOT_USED_MASK
										//  װ bit setҶ ׻  mask clear־ 
										//  state exclusiveϱ ̴
										//
										// ex)
										// CLEAR_BODYCON_BIT( c, BODYCON_EX_STATE_CLEAR_MASK)
										// SET_BODYCON_BIT( c, BODYCON_FLY_MASK)
#define BODYCON_BOOSTER_EX_STATE_CLEAR_MASK	(BodyCond_t)(BODYCON_BOOSTER1_MASK | BODYCON_BOOSTER2_MASK | BODYCON_BOOSTER3_MASK | BODYCON_BOOSTER4_MASK)
											// BODYCON_BOOSTER1_MASK | BODYCON_BOOSTER2_MASK | BODYCON_BOOSTER3_MASK | BODYCON_BOOSTER4_MASK
#define BODYCON_KEEPING_MASK			(BodyCond_t)(BODYCON_EX_STATE_CLEAR_MASK|BODYCON_DAMAGE1_MASK|BODYCON_DAMAGE2_MASK|BODYCON_DAMAGE3_MASK)	//  body coditions

#define D3DFVF_FOGVERTEX (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX1)

class CMapEditorView : public CFormView, public CD3DApplication
{
protected: // create from serialization only
	CMapEditorView();
	DECLARE_DYNCREATE(CMapEditorView)

	enum TERRAIN_STATE
	{
		TERRAIN_UP = 0,
		TERRAIN_DOWN = 1,
		TERRAIN_FLAT = 2, // ȭ
		TERRAIN_SMOOTH = 3 // ٵ
	};
public:
	//{{AFX_DATA(CMapEditorView)
	enum { IDD = IDD_MAPEDITOR_FORM };
	CComboBox	m_comboTileSetScale;
	CComboBox	m_comboTileSet;
	CListBox	m_ctrlBaseTileList;
	CSliderCtrl	m_sliderObjectDir;
	CComboBox	m_comboObjectSelect;
	CComboBox	m_comboControlSizeType; //  Ʈ  ũ
	CListBox	m_ctrlTileList;
	BOOL	m_bRenderLine;
	int		m_nCommand;
	int		m_nUpdown;
	float	m_editUpDownRate;
	float	m_editFlatRate;
	int		m_editObjectNumber;
	int		m_editObjectDelete;
	int		m_editWater;
	BOOL	m_checkAlphaBlending;
	BOOL	m_checkTilesetPoint;
	BOOL	m_checkTilesetRegion;
	int		m_editWaterHeight;
	float	m_editHeightMax;
	float	m_editHeightMin;
	int		m_editObjectBlockCont;
	int		m_editObjectNormalCont;
	BOOL	m_checkObjectNormal;
	BOOL	m_checkFog;
	BOOL	m_bAllObjectRender;
	BOOL	m_bLandView;
	BOOL	m_bRoamLandView;
	BOOL	m_bAllObjectNotRender;
	DWORD	m_dwWaterType;
	//}}AFX_DATA

// Attributes
public:
	CMapEditorDoc* GetDocument();


// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMapEditorView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMapEditorView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
    HRESULT OneTimeSceneInit();
    HRESULT InitDeviceObjects();
    HRESULT RestoreDeviceObjects();
    HRESULT FrameMove();
    HRESULT Render();
	void RenderScene() { Render3DEnvironment(); }
    HRESULT InvalidateDeviceObjects();
    HRESULT DeleteDeviceObjects();
    HRESULT FinalCleanup();
	HRESULT ConfirmDevice( D3DCAPS8* pCaps, DWORD dwBehavior, D3DFORMAT Format );
	VOID SetLight();
	BOOL	IsReady() { return m_bReady; }
	FLOAT GetElapsedTime() { return m_fElapsedTime; }

	void CheckMove();
	void ObjectMoveRotation();

	void InitMapData();
	void SaveWorkspace();
	void SaveProject();
	void SaveMapFile();
	void OnOpenProjectSub(CString str);
	void OpenWorkspace(CString str);
	PROJECTINFO OpenProject(CString str);
	void OpenMapData(CString str);
	void CreateChangeTexture(int num, int nTargetIndex);
	VOID	CalcObjectSourceScreenCoords(D3DXVECTOR3 vObjPos,int iScreenWidth, int iScreenHeight,int &iCoordX, int &iCoordY, int &iCoordW);
	D3DSURFACE_DESC GetBackBufferDesc() { return m_d3dsdBackBuffer; }
	void CheckSetEffect(D3DXVECTOR3 vOrig,D3DXVECTOR3 vDir);
	void CheckSupprotLight(D3DXVECTOR3 vOrig,D3DXVECTOR3 vDir);
	void SetEffect(D3DXVECTOR3 vPos);
	void SetLight(D3DXVECTOR3 vPos);
	void SetLightAll();
	void ResetObjectList();
	void SaveXFile(int nSize, int x, int z);  
	void SaveXFileOld(int nSize, int x, int z);
	void SetObject( D3DXMATRIX mat, char *szFilename );
	LPDIRECT3DTEXTURE8 ResizeTexture(LPDIRECT3DTEXTURE8 pTexture, int nSize);

protected:
	DWORD			m_dwStateBlock;
	BOOL			m_bReady;
	CPoint			m_ptOldPoint;
    CD3DFont*		m_pFont;                      // Font for drawing text
	char			m_strDump[256];

	BOOL			m_bSaveWorkspace;
	BOOL			m_bSaveProject;
    CD3DArcBall		m_ArcBall;

public:	
	CD3DCamera*		m_pCamera;
	BYTE			m_bCamDirType;
//	D3DXVECTOR3		m_vUp,m_vLookat,m_vEye;
	CBackground *	m_pBackground;
	INT				m_nControlSizeType; // Ʈ  Ÿ?
	CObjectRender *	m_pObject;
	INT				m_nObjectNormalCont;
	INT				m_nObjectBlockCont;
	DWORD			m_dwObjectType;
//	INT				m_nObjectNum;
	MapInfo			m_info;
	OBJECTINFO *	m_pObjectInfo;
	MAPOBJECTINFODETAIL *	m_pObjectInfoDetail;
	INT				m_nOldLookX;
	INT				m_nOldLookZ;
	D3DXVECTOR3		m_vObjectVel;
	LPDIRECT3DTEXTURE8	m_pTex;
	INT				m_nBaseTileTextype;
	char			m_strCurrentDir[256];

	INT				m_nTileTextype;
	INT				m_nTileSetScaleType;

	//////////////// Flyint View /////////////////////
	BOOL			m_bFlyingViewMax;
	BOOL			m_bFlyingViewMin;

	//////////////// Event Set ///////////////////////
	CEventSetDlg	m_dlgEventSet;		// ̺Ʈ   ̾α׹ڽ
	BOOL			m_bCheckEventSet;	// 콺 ׼ǽ ϰ  (̺Ʈ )
	BOOL			m_bLButtonCheck;	// 콺 巡׽ ϰ ɺ(콺 ʹư )
	BOOL			m_bRButtonCheck;	// 콺 巡׽ ϰ ɺ(콺 ʹư )

	//////////////// Workspace ///////////////////////
	CWorkspaceDlg	m_dlgWorkspace;
	WORKSPACE *		m_pWorkspace;
	list<PROJECTINFO> m_listProjectInfo;
	BOOL			m_bCheckWorkspaceView;

	//////////////// MiniMap ///////////////////////
	CMiniMap	*	m_pMiniMap;
	BOOL			m_bCheckMiniMapView;

	//////////////// Object Edit ///////////////////
	BOOL			m_bCheckObject;
	CObjectSetDlg	m_dlgObjectSet;

	//////////////// Monster Set ///////////////////
	BOOL			m_bCheckMonsterSet;		//   ׼ǽ ϰ  
	CMonsterSetDlg	m_dlgMonsterSet;		//    ̾α ڽ

	//////////////// Light Set ///////////////////
    D3DLIGHT8		light;
    D3DLIGHT8		m_light1;
	D3DLIGHT8		*m_pLight;				//   Ʈ Ʈ
	BOOL			m_bCheckLightSet;
	CLightSetDlg	m_dlgLightSet;
	BOOL			m_bCheckLightSet2;
	list<D3DLIGHT8*>	m_listLightInfo;
	INT				m_nMaxLightNum;
	INT				m_nUseLightNum;
	CLightListDlg	m_dlgLightList;
	CLightSetDetailDlg m_dlgLightSetDetail;
	BOOL			m_bShowLight;
	CLightRender	*m_pLightRender;

	//////////////// All List ֱ ///////////////////
	BOOL			m_bAllList;
	CAllListDlg		m_dlgAllList;

	CEditDlg		m_dlgEdit;
	BOOL			m_bEdit;

	BOOL			m_bEffect;
	BYTE			m_bObjectDir;
	////////////////  Ÿϼ ε ///////////
	INT				m_nUseTileset;
	// Effect
	CEffectRender	*			m_pEffectRender; 

	CAtumNode		*			m_pEffectList;		//  Effect 
	map<INT, MAPOBJECTINFO*>		m_mapObjectInfo;

	list<EFFECTINFO>			m_listEffectInfo;
	CEffectSetDlg				m_dlgEffect;

	LPDIRECT3DVERTEXBUFFER8		m_pPointVB;

	BOOL						m_bCtrl; // 07-05-03 by shkim, ctrl key toggle
	int							m_nBrushSize; // 07-05-07 by shkim, brush size
	DWORD	m_dwBackRed;
	DWORD	m_dwBackGreen;
	DWORD	m_dwBackBlue;

protected:
	enum KEYPROCESS // 07-05-04 by shkim, Ű ޽ ۿ
	{
		CTRL = 17,
		GREATE_GARO_LEFT = 219, // '['
		GREATE_GARO_RIGHT = 221 // ']'
	};

	void			KeyProcess( int nKey ); // 07-05-03 by shkim, Ű ޽ ޾Ƽ 

protected:
	// 07-05-03 by shkim, m_comboControlSizeType   뵵
	int				m_nComboCtrlSizeType; 
	
	BOOL			m_bCheckBrush; // ׽Ʈ 귯 üũ
	D3DXVECTOR3		m_vPickPos; //07-05-07 by shkim, ŷ ġ

// Generated message map functions
protected:
	//{{AFX_MSG(CMapEditorView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnCheckLine();
	afx_msg void OnRadioCommand();
	afx_msg void OnRadioDown();
	afx_msg void OnRadioFlat();
	afx_msg void OnRadioHeight();
	afx_msg void OnRadioUp();
	afx_msg void OnSelchangeListTile();
	afx_msg void OnButtonCameramoveLeft();
	afx_msg void OnButtonCameramoveRight();
	afx_msg void OnChangeEditUpdownValue();
	afx_msg void OnChangeEditFlatSize();
	afx_msg void OnSelchangeComboContorlSize();
	afx_msg void OnSelchangeComboObjectSelect();
	afx_msg void OnRadioObject();
	afx_msg void OnChangeEditObjectCreatecont();
	afx_msg void OnChangeEditObjectDelete();
	afx_msg void OnRadioObjectDelete();
	afx_msg void OnRadioWater();
	afx_msg void OnChangeEditWater();
	afx_msg void OnReleasedcaptureSliderObjectDir(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnEventSet();
	afx_msg void OnUpdateEventSet(CCmdUI* pCmdUI);
	afx_msg void OnNewWorkspace();
	afx_msg void OnNewProject();
	afx_msg void OnOpenProject();
	afx_msg void OnOpenWorkspace();
	afx_msg void OnSaveProject();
	afx_msg void OnWorkspaceView();
	afx_msg void OnUpdateWorkspaceView(CCmdUI* pCmdUI);
	afx_msg void OnSelchangeListTilebase();
	afx_msg void OnCameraSet();
	afx_msg void OnFlyingView();
	afx_msg void OnUpdateFlyingView(CCmdUI* pCmdUI);
	afx_msg void OnMinimapView();
	afx_msg void OnUpdateMinimapView(CCmdUI* pCmdUI);
	afx_msg void OnCheckObjectalpha();
	afx_msg void OnButtonInserttile2();
	afx_msg void OnButtonObject();
	afx_msg void OnUpdateButtonObject(CCmdUI* pCmdUI);
	afx_msg void OnButtonMonster();
	afx_msg void OnUpdateButtonMonster(CCmdUI* pCmdUI);
	afx_msg void OnButtonTileSetInsert();
	afx_msg void OnSelchangeComboTileset();
	afx_msg void OnButtonPicture();
	afx_msg void OnUpdateButtonPicture(CCmdUI* pCmdUI);
	afx_msg void OnButtonLoaddata();
	afx_msg void OnUpdateButtonLoaddata(CCmdUI* pCmdUI);
	afx_msg void OnButtonLoaddata256();
	afx_msg void OnUpdateButtonLoaddata256(CCmdUI* pCmdUI);
	afx_msg void OnCheckTilesetPoint();
	afx_msg void OnCheckTilesetRegion();
	afx_msg void OnChangeEditWaterHeight();
	afx_msg void OnButtonDeletetile();
	afx_msg void OnButtonUpdatetile();
	afx_msg void OnButtonSetlight();
	afx_msg void OnUpdateButtonSetlight(CCmdUI* pCmdUI);
	afx_msg void OnChangeEditHeightmax();
	afx_msg void OnChangeEditHeightmin();
	afx_msg void OnButtonFlightmin();
	afx_msg void OnUpdateButtonFlightmin(CCmdUI* pCmdUI);
	afx_msg void OnButtonObjectturnright();
	afx_msg void OnButtonObjectturnleft();
	afx_msg void OnButtonTilesetDelete();
	afx_msg void OnSelchangeComboTilesetscale();
	afx_msg void OnChangeEditObjectBlockcont();
	afx_msg void OnChangeEditObjectNormalcont();
	afx_msg void OnButtonObjectUpdate();
	afx_msg void OnCheckObjectnormal();
	afx_msg void OnButtonObjectReset();
	afx_msg void OnUpdateButtonObjectReset(CCmdUI* pCmdUI);
	afx_msg void OnRadioCamera();
	afx_msg void OnRadioDefault();
	afx_msg void OnCheckFog();
	afx_msg void OnButtonEffect();
	afx_msg void OnUpdateButtonEffect(CCmdUI* pCmdUI);
	afx_msg void OnRadioEffect();
	afx_msg void OnButtonSetlight2();
	afx_msg void OnUpdateButtonSetlight2(CCmdUI* pCmdUI);
	afx_msg void OnRadioLight();
	afx_msg void OnCheckObjectallrender();
	afx_msg void OnCheckLand();
	afx_msg void OnButtonAlllist();
	afx_msg void OnUpdateButtonAlllist(CCmdUI* pCmdUI);
	afx_msg void OnCheckObjectallnotrender();
	afx_msg void OnButtonLoadObject();
	afx_msg void OnUpdateButtonLoadObject(CCmdUI* pCmdUI);
	afx_msg void OnButtonSaveX();
	afx_msg void OnUpdateButtonSaveX(CCmdUI* pCmdUI);
	afx_msg void OnButtonMap();
	afx_msg void OnUpdateButtonMap(CCmdUI* pCmdUI);
	afx_msg void OnButtonLightView();
	afx_msg void OnUpdateButtonLightView(CCmdUI* pCmdUI);
	afx_msg void OnButtonSetBackTexture();
	afx_msg void OnChangeEditWaterType();
	afx_msg void OnButtonSmooth();
	afx_msg void OnButtonGenerateBackTexture();
	afx_msg void OnChangeEditRed();
	afx_msg void OnChangeEditGreen();
	afx_msg void OnChangeEditBlue();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnCheckRoamland();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in MapEditorView.cpp
inline CMapEditorDoc* CMapEditorView::GetDocument()
   { return (CMapEditorDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAPEDITORVIEW_H__D55DB87E_3BE4_475D_8D98_EEDDB21DB07C__INCLUDED_)
