// MiniMap.cpp: implementation of the CMiniMap class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "mapeditor.h"
#include "MiniMap.h"

#include "MainFrm.h"
#include "MapEditor.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern LPDIRECT3DDEVICE8	g_pD3dDev;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMiniMap::CMiniMap(short x, short y)
{
	m_pCam = NULL;
	m_pObject = NULL;
	m_sSizeX = x;
	m_sSizeY = y;
	for ( int i = 0;i < MAX_EVENT_NUM;i++ )
	{
//		m_pEvent[i] = NULL;
		m_pEventTexture[i] = NULL;
	}
	m_sEventTextureSize = 0;
	m_pEvent = NULL;
}

CMiniMap::~CMiniMap()
{
	SAFE_DELETE(m_pCam);
	SAFE_DELETE(m_pObject);
	for ( int i = 0;i < MAX_EVENT_NUM;i++ )
	{
//		SAFE_DELETE(m_pEvent[i]);
		SAFE_DELETE(m_pEventTexture[i]);
	}
	SAFE_DELETE(m_pEvent);
}

HRESULT CMiniMap::InitDeviceObjects()
{
	POINT start,end;
	start.x =0;
	start.y =0;
	end.x = 10;
	end.y = 10;
	m_pCam = new CDXImage;
	m_pCam->Create("camview.tga",start,end);
	m_pCam->InitDeviceObjects();

	m_pObject = new CDXImage;
	m_pObject->Create(".\\Res-Tex\\object.tga",start,end);
	m_pObject->InitDeviceObjects();


	if(m_sSizeX > 32 && m_sSizeX <= 64)
	{
		m_sEventTextureSize = 64;
	}
	else if(m_sSizeX > 64 && m_sSizeX <= 128)
	{
		m_sEventTextureSize = 128;
	}
	else if(m_sSizeX > 128 && m_sSizeX <= 256)
	{
		m_sEventTextureSize = 256;
	}
	else if(m_sSizeX > 256 && m_sSizeX <= 512)
	{
		m_sEventTextureSize = 512;
	}

	char buf[128];
	wsprintf(buf,"mappicture%d.tga",m_sEventTextureSize);
	for ( int i = 0;i < MAX_EVENT_NUM;i++ )
	{
		D3DUtil_CreateTexture( g_pD3dDev,buf, &m_pEventTexture[i] );
	}
	SetEvent();
	
	m_pEvent = new CDXImage;
	m_pEvent->Create(buf,start,end);
	m_pEvent->InitDeviceObjects();
/*	
	for ( int i = 0;i < MAX_EVENT_NUM;i++ )
	{
		char buf[256];
		wsprintf( buf, ".\\Res-Tex\\event%d.tga", i);
		m_pEvent[i] = new CDXImage;
		m_pEvent[i]->Create(buf,start,end);
		m_pEvent[i]->InitDeviceObjects();
	}
*/	

	
	return CDXImage::InitDeviceObjects();
}

HRESULT CMiniMap::RestoreDeviceObjects()
{
	g_pD3dDev->BeginStateBlock();
	g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	g_pD3dDev->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
	g_pD3dDev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
	g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE,  FALSE );
	g_pD3dDev->EndStateBlock( &m_dwStateBlock );

	m_pCam->RestoreDeviceObjects();
	m_pObject->RestoreDeviceObjects();
	for ( int i = 0;i < MAX_EVENT_NUM;i++ )
	{
//		m_pEvent[i]->RestoreDeviceObjects();
	}
	m_pEvent->RestoreDeviceObjects();
	return CDXImage::RestoreDeviceObjects();
}
HRESULT CMiniMap::InvalidateDeviceObjects()
{
	m_pCam->InvalidateDeviceObjects();
	m_pObject->InvalidateDeviceObjects();
	for ( int i = 0;i < MAX_EVENT_NUM;i++ )
	{
//		m_pEvent[i]->InvalidateDeviceObjects();
	}
	m_pEvent->SetTexture(NULL);
	m_pEvent->InvalidateDeviceObjects();
	return CDXImage::InvalidateDeviceObjects();
}

HRESULT CMiniMap::DeleteDeviceObjects()
{
	m_pCam->DeleteDeviceObjects();
	m_pObject->DeleteDeviceObjects();
	for ( int i = 0;i < MAX_EVENT_NUM;i++ )
	{
		SAFE_RELEASE( m_pEventTexture[i] );
//		m_pEvent[i]->DeleteDeviceObjects();
	}
	m_pEvent->DeleteDeviceObjects();
	return CDXImage::DeleteDeviceObjects();
}

void CMiniMap::Tick()
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
//	SetCamPos(pView->m_vEye.x,pView->m_vEye.z);
	SetCamPos();//pView->m_pCamera->GetEyePt());
}

void CMiniMap::Render()
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
	CDXImage::Render();
	
	g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
	m_pCam->Render();

	map<INT, CAtumNode *>::iterator it = pView->m_pBackground->m_mapObjectData.begin();
	while(it != pView->m_pBackground->m_mapObjectData.end())
	{
		CAtumNode * pNode = it->second;
		CObjectChild * pObj = (CObjectChild *)pNode->m_pChild;
		while(pObj)
		{
			float fx,fz;

			fz=(pObj->m_vPos.x)*(((float)(m_sSizeX))/(m_sSizeX*40.0f));
			fx=(pObj->m_vPos.z)*(((float)(m_sSizeY))/(m_sSizeY*40.0f));

			m_pObject->Move(fx,fz);
			m_pObject->Render();

			pObj = (CObjectChild *)pObj->m_pNext;
		}
		it++;
	}

	if(pView->m_bCheckEventSet && pView->m_dlgEventSet.m_checkEventSetMode)
	{
		switch(pView->m_dlgEventSet.m_nCommandEvent)
		{
		case 0:
			{
				m_pEvent->SetTexture( m_pEventTexture[0] );
			}
			break;
		case 1:
			{
				m_pEvent->SetTexture( m_pEventTexture[1] );
			}
			break;
		case 2:
			{
				m_pEvent->SetTexture( m_pEventTexture[2] );
			}
			break;
		case 3:
			{
				m_pEvent->SetTexture( m_pEventTexture[3] );
			}
			break;
		}
		m_pEvent->Move(0,0);
		m_pEvent->Render();
	}
}

void CMiniMap::SetCamPos()//float x, float z)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

//	D3DXVECTOR3 vEye = pView->m_pCamera->GetEyePt();
	D3DXVECTOR3 vEye = pView->m_pCamera->GetLookatPt();
	float fx,fz;

	fz=(vEye.x)*(((float)(m_sSizeX))/(m_sSizeX*40.0f))-5;
	fx=(vEye.z)*(((float)(m_sSizeY))/(m_sSizeY*40.0f))-5;

	m_pCam->Move(fx,fz);

}

void CMiniMap::SetEvent()
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	LPDIRECT3DTEXTURE8 tempTex = NULL;
	
	if(pView->m_bCheckEventSet)// && pView->m_dlgEventSet.m_checkEventSetMode)
	{
		switch(pView->m_dlgEventSet.m_nCommandEvent)
		{
		case 0:
			{
				tempTex = m_pEventTexture[0];
			}
			break;
		case 1:
			{
				tempTex = m_pEventTexture[1];
			}
			break;
		case 2:
			{
				tempTex = m_pEventTexture[2];
			}
			break;
		case 3:
			{
				tempTex = m_pEventTexture[3];
			}
			break;
		}
	}

	if ( tempTex )
	{
		D3DLOCKED_RECT d3dlr;
		DWORD dwColor;
		tempTex->LockRect( 0, &d3dlr, 0, 0 );
		DWORD* pDstRow = (DWORD*)d3dlr.pBits;
		DWORD* pDst16 = (DWORD*)pDstRow;

		for ( int y = 0; y < m_sEventTextureSize; y++ )
		{
			for ( int x = 0; x < m_sEventTextureSize; x++ )
			{
				int k = y * pView->m_pBackground->m_projectInfo.m_sYSize + x;
				if ( y < 0 || y >= pView->m_pBackground->m_projectInfo.m_sXSize || x < 0 || x >= pView->m_pBackground->m_projectInfo.m_sYSize )
				{
					dwColor = D3DCOLOR_ARGB(0x00,0x00,0x00,0x00);
				}
				else
				{
					switch ( pView->m_dlgEventSet.m_nCommandEvent )
					{
					case 0:
						{
							if ( pView->m_pBackground->m_pEventInfo[k].m_bPKType == 0 )
							{
								dwColor = D3DCOLOR_ARGB(0x00,0x00,0x00,0x00);
							}
							else if ( pView->m_pBackground->m_pEventInfo[k].m_bPKType == 1 )
							{
								dwColor = D3DCOLOR_ARGB(0xFF,0xFF,0xFF,0x00);
							}
							else if ( pView->m_pBackground->m_pEventInfo[k].m_bPKType == 2 )
							{
								dwColor = D3DCOLOR_ARGB(0xFF,0x00,0xFF,0x00);
							}
						}
						break;
					case 1:
						{
							if ( pView->m_pBackground->m_pEventInfo[k].m_bEnableLand == 0 )
							{
								dwColor = D3DCOLOR_ARGB(0x00,0x00,0x00,0x00);
							}
							else if ( pView->m_pBackground->m_pEventInfo[k].m_bEnableLand == 1 )
							{
								dwColor = D3DCOLOR_ARGB(0xFF,0xFF,0x00,0xFF);
							}
						}
						break;
					case 2:
						{
							if ( !pView->m_pBackground->m_pEventInfo[k].m_bEnvetType )
							{
								dwColor = D3DCOLOR_ARGB(0x00,0x00,0x00,0x00);
							}
							else
							{
								dwColor = D3DCOLOR_ARGB(0xFF,0xFF,0xFF,0xFF);
							}
						}
						break;
					case 3:
						{
							if ( pView->m_pBackground->m_pEventInfo[k].m_bMove == 0 )
							{
								dwColor = D3DCOLOR_ARGB(0x00,0x00,0x00,0x00);
							}
							else if ( pView->m_pBackground->m_pEventInfo[k].m_bMove == 1 )
							{
								dwColor = D3DCOLOR_ARGB(0xFF,0x00,0xFF,0x00);
							}
							else if ( pView->m_pBackground->m_pEventInfo[k].m_bMove == 2 )
							{
								dwColor = D3DCOLOR_ARGB(0xFF,0x77,0x77,0x77);
							}
						}
						break;
					}
				}
				*pDst16 = dwColor;
				pDst16++;
			}
		}
		tempTex->UnlockRect(0);
	}

}



/*
			if(pView->m_bCheckEventSet && pView->m_dlgEventSet.m_checkEventViewMode)
			{
				switch(pView->m_dlgEventSet.m_nCommandEvent)
				{
				case 0:
					{
						if(m_pEventInfo[k].m_bPKType==0)
						{
						}
						else if(m_pEventInfo[k].m_bPKType==1)
						{
						}
						else if(m_pEventInfo[k].m_bPKType==2)
						{
						}
					}
					break;
				case 1:
					{
						if(m_pEventInfo[k].m_bEnableLand==0)
						{
						}
						else if(m_pEventInfo[k].m_bEnableLand==1)
						{
						}
					}
					break;
				case 2:
					{
					}
					break;
				case 3:
					{
						if(m_pEventInfo[k].m_bMove==0)
						{
						}
						else if(m_pEventInfo[k].m_bMove==1)
						{
						}
						else if(m_pEventInfo[k].m_bMove==2)
						{
						}
					}
					break;
				}
			}
*/
