// MiniMap.h: interface for the CMiniMap class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MINIMAP_H__10000AC0_AE15_4C3C_AB5E_296B8F98B4FF__INCLUDED_)
#define AFX_MINIMAP_H__10000AC0_AE15_4C3C_AB5E_296B8F98B4FF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "DXImage.h"

#define MAX_EVENT_NUM		4


class CMiniMap : public CDXImage  
{
public:
	CMiniMap(short x, short y);
	virtual ~CMiniMap();
	virtual HRESULT InitDeviceObjects();
	virtual HRESULT RestoreDeviceObjects();
	virtual HRESULT DeleteDeviceObjects();
	virtual HRESULT InvalidateDeviceObjects();

	virtual void Tick();
	virtual void Render();
	void SetCamPos();//float x, float z);
	void SetEvent();
	CDXImage	*			m_pCam;
	CDXImage	*			m_pObject;

	LPDIRECT3DTEXTURE8		m_pEventTexture[MAX_EVENT_NUM];		// Created Texture
	short					m_sEventTextureSize;
	CDXImage	*			m_pEvent;

	short m_sSizeX;
	short m_sSizeY;
};

#endif // !defined(AFX_MINIMAP_H__10000AC0_AE15_4C3C_AB5E_296B8F98B4FF__INCLUDED_)
