// MonsterSetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mapeditor.h"
#include "MonsterSetDlg.h"

#include "MainFrm.h"
#include "MapEditor.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMonsterSetDlg dialog


CMonsterSetDlg::CMonsterSetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMonsterSetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMonsterSetDlg)
	m_strStartPos = _T("");
	m_sMonResTime = 0;
	m_sMonResNum = 0;
	m_sMaxMon = 0;
	m_strEndPos = _T("");
	m_bMonsterView = FALSE;
	m_nMonType = 0;
	m_bMonType = 0;
	//}}AFX_DATA_INIT
	m_bSelectRetion = FALSE;
	m_iOriginNum = -1;
}


void CMonsterSetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMonsterSetDlg)
	DDX_Control(pDX, IDC_LIST_MONSTER_REGION, m_listboxMonster);
	DDX_Text(pDX, IDC_EDIT_STARTPOS, m_strStartPos);
	DDX_Text(pDX, IDC_EDIT_RESTIME, m_sMonResTime);
	DDX_Text(pDX, IDC_EDIT_RESNUM, m_sMonResNum);
	DDX_Text(pDX, IDC_EDIT_MAXMON, m_sMaxMon);
	DDX_Text(pDX, IDC_EDIT_ENDPOS, m_strEndPos);
	DDX_Check(pDX, IDC_CHECK_VIEWMONSTER, m_bMonsterView);
	DDX_Text(pDX, IDC_EDIT_MONTYPE, m_nMonType);
	DDX_Text(pDX, IDC_EDIT_MONTYPE2, m_bMonType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMonsterSetDlg, CDialog)
	//{{AFX_MSG_MAP(CMonsterSetDlg)
	ON_LBN_SELCHANGE(IDC_LIST_MONSTER_REGION, OnSelchangeListMonsterRegion)
	ON_LBN_DBLCLK(IDC_LIST_MONSTER_REGION, OnDblclkListMonsterRegion)
	ON_BN_CLICKED(IDC_CHECK_VIEWMONSTER, OnCheckViewmonster)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMonsterSetDlg message handlers

void CMonsterSetDlg::OnOK() 
{
	// TODO: Add extra validation here
	

	
	
//	CDialog::OnOK();
}

void CMonsterSetDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CDialog::OnCancel();
}

void CMonsterSetDlg::UpdateMonster(CString str) 
{
	int n = m_listboxMonster.GetCount();
	for (int i=0;i < n;i++)
	{
	   m_listboxMonster.DeleteString( n-i-1 );
	}
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	if(pView && pView->m_pWorkspace && pView->m_pBackground)
	{

		list<MONSTERINFO2>::iterator it = pView->m_pBackground->m_listMonsterInfo.begin();
		for(int i=0;i<pView->m_pBackground->m_nMonsterNumber;i++)
		{
			if(strcmp((*it).strRegionName,str)==0)
			{
				m_sMin_x = (*it).sStartx;
				m_sMin_z = (*it).sStartz;
				m_sMax_x = (*it).sEndx;
				m_sMax_z = (*it).sEndz;
				UpdateData(FALSE);
			}
			m_listboxMonster.AddString((*it).strRegionName);
			it++;
		}
	}
	m_bSelectRetion = TRUE;

	if (m_iOriginNum >= 0)
	{
		m_listboxMonster.SetCurSel(m_iOriginNum);
	}
	UpdateData(FALSE);

}

void CMonsterSetDlg::OnSelchangeListMonsterRegion() 
{
	// TODO: Add your control notification handler code here
	m_bMonsterView = FALSE;
	UpdateData(FALSE);

	CString str;
	int nIndex = m_listboxMonster.GetCurSel();

	m_iOriginNum = nIndex;

	m_listboxMonster.GetText( nIndex, str );

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	if(pView && pView->m_pWorkspace && pView->m_pBackground)
	{
		list<MONSTERINFO2>::iterator it = pView->m_pBackground->m_listMonsterInfo.begin();
		for(int i=0;i<pView->m_pBackground->m_nMonsterNumber;i++)
		{
			if(strcmp((LPCTSTR)str, (*it).strRegionName) == 0 )
			{
				m_sMaxMon = (*it).sMaxMon;
				m_sMonResNum = (*it).sResNum;
				m_sMonResTime = (*it).sResTime;
				m_nMonType = (*it).nMonType;
				m_strEndPos.Format("%d , %d",(*it).sEndx,(*it).sEndz);
				m_strStartPos.Format("%d , %d",(*it).sStartx,(*it).sStartz);

				m_sMin_x = (*it).sStartx;
				m_sMin_z = (*it).sStartz;
				m_sMax_x = (*it).sEndx;
				m_sMax_z = (*it).sEndz;
				m_bSelectRetion = TRUE;
				m_bMonType = (*it).bMonType;

				D3DXVECTOR3 vVel,vPos,vTemp;
				vTemp = D3DXVECTOR3(((*it).sStartx+((*it).sEndx-(*it).sStartx)/2.0f)*40.0f,0,((*it).sStartz+((*it).sEndz-(*it).sStartz)/2.0f)*40.0f);
				D3DXVec3Normalize(&vVel,&pView->m_pCamera->GetViewDir());
				vPos = vTemp - vVel*200.0f;
				pView->m_pCamera->SetViewParams(vPos,vPos + vVel,pView->m_pCamera->GetUpVec());

				UpdateData(FALSE);
				return;
			}
			it++;
		}
	}
	UpdateData(FALSE);
	
}

void CMonsterSetDlg::OnDblclkListMonsterRegion() 
{
	// TODO: Add your control notification handler code here
	CString str;
	int nIndex = m_listboxMonster.GetCurSel();
	m_listboxMonster.GetText( nIndex, str );

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	if(pView && pView->m_pWorkspace && pView->m_pBackground)
	{
		list<MONSTERINFO2>::iterator it = pView->m_pBackground->m_listMonsterInfo.begin();
		for(int i=0;i<pView->m_pBackground->m_nMonsterNumber;i++)
		{
			if(strcmp((LPCTSTR)str, (*it).strRegionName) == 0 )
			{
				m_sMaxMon = (*it).sMaxMon;
				m_sMonResNum = (*it).sResNum;
				m_sMonResTime = (*it).sResTime;
				m_nMonType = (*it).nMonType;
				m_strEndPos.Format("%d , %d",(*it).sEndx,(*it).sEndz);
				m_strStartPos.Format("%d , %d",(*it).sStartx,(*it).sStartz);

				m_sMin_x = (*it).sStartx;
				m_sMin_z = (*it).sStartz;
				m_sMax_x = (*it).sEndx;
				m_sMax_z = (*it).sEndz;
				m_bMonType = (*it).bMonType;
				m_bSelectRetion = TRUE;
				UpdateData(FALSE);
				break;

			}
			it++;
		}
	}
	
	CString newStr = pView->m_pBackground->UpdateMonsterData(str);

	if(pView && pView->m_pWorkspace && pView->m_pBackground)
	{
		list<MONSTERINFO2>::iterator it = pView->m_pBackground->m_listMonsterInfo.begin();
		for(int i=0;i<pView->m_pBackground->m_nMonsterNumber;i++)
		{
			if(strcmp(newStr, (*it).strRegionName) == 0 )
			{
				m_sMaxMon = (*it).sMaxMon;
				m_sMonResNum = (*it).sResNum;
				m_sMonResTime = (*it).sResTime;
				m_nMonType = (*it).nMonType;
				m_strEndPos.Format("%d , %d",(*it).sEndx,(*it).sEndz);
				m_strStartPos.Format("%d , %d",(*it).sStartx,(*it).sStartz);

				m_sMin_x = (*it).sStartx;
				m_sMin_z = (*it).sStartz;
				m_sMax_x = (*it).sEndx;
				m_sMax_z = (*it).sEndz;
				m_bMonType = (*it).bMonType;
				m_bSelectRetion = TRUE;
				UpdateData(FALSE);
				break;

			}
			it++;
		}
	}
	UpdateMonster(newStr);

	if(pView && pView->m_pWorkspace && pView->m_pBackground)
	{
		list<MONSTERINFO2>::iterator it = pView->m_pBackground->m_listMonsterInfo.begin();
		for(int i=0;i<pView->m_pBackground->m_nMonsterNumber;i++)
		{
			if(strcmp((LPCTSTR)str, (*it).strRegionName) == 0 )
			{
				((*it).sEndx,(*it).sEndz);
				((*it).sStartx,(*it).sStartz);
			}
			it++;
		}
	}

	UpdateData(FALSE);
}

void CMonsterSetDlg::OnCheckViewmonster() 
{
	// TODO: Add your control notification handler code here

	int m_bSelectIndex = m_listboxMonster.GetCurSel();
	m_bMonsterView = !m_bMonsterView;
	UpdateData(FALSE);
}

void CMonsterSetDlg::ClearMonsterData()
{
	int n = m_listboxMonster.GetCount();
	for (int i=0;i < n;i++)
	{
	   m_listboxMonster.DeleteString( n-i-1 );
	}
	m_sMin_x = 0;
	m_sMin_z = 0;
	m_sMax_x = 0;
	m_sMax_z = 0;
}

void CMonsterSetDlg::OnButtonDelete() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	CString str;
	int nIndex = m_listboxMonster.GetCurSel();
	m_listboxMonster.GetText( nIndex, str );
	m_listboxMonster.DeleteString(nIndex);
	int cont = pView->m_pBackground->m_listMonsterInfo.size();
	if(pView && pView->m_pWorkspace && pView->m_pBackground)
	{
		list<MONSTERINFO2>::iterator it = pView->m_pBackground->m_listMonsterInfo.begin();
//		for(int i=0;i<pView->m_pBackground->m_nMonsterNumber;i++)
//		{
		int nCheckCont = 0;
		while(it != pView->m_pBackground->m_listMonsterInfo.end())
		{
			char strTemp[256];
			strcpy(strTemp,(*it).strRegionName);
			if(nCheckCont == nIndex)
			{
				pView->m_pBackground->m_listMonsterInfo.erase(it);
				pView->m_pBackground->m_nMonsterNumber--;
				break;
			}
			if(strcmp((LPCTSTR)str, (*it).strRegionName) == 0 )
			{
				pView->m_pBackground->m_listMonsterInfo.erase(it);
				pView->m_pBackground->m_nMonsterNumber--;
				break;
			}
			nCheckCont++;
			it++;
		}
//		}
		if(m_listboxMonster.GetCount() > 0 &&  nIndex-1 >= 0)
		{
			m_listboxMonster.SetCurSel(nIndex-1);
			m_listboxMonster.GetText( nIndex-1, str );
			{
				it = pView->m_pBackground->m_listMonsterInfo.begin();
				for(int i=0;i<pView->m_pBackground->m_nMonsterNumber;i++)
				{
					if(strcmp((LPCTSTR)str, (*it).strRegionName) == 0 )
					{
						m_sMaxMon = (*it).sMaxMon;
						m_sMonResNum = (*it).sResNum;
						m_sMonResTime = (*it).sResTime;
						m_nMonType = (*it).nMonType;
						m_strEndPos.Format("%d , %d",(*it).sEndx,(*it).sEndz);
						m_strStartPos.Format("%d , %d",(*it).sStartx,(*it).sStartz);

						m_sMin_x = (*it).sStartx;
						m_sMin_z = (*it).sStartz;
						m_sMax_x = (*it).sEndx;
						m_sMax_z = (*it).sEndz;
						m_bMonType = (*it).bMonType;
						UpdateData(FALSE);
						break;
					}
					it++;
				}
			}
		}
	}
	cont = pView->m_pBackground->m_listMonsterInfo.size();
}
