// ObjectRender.cpp: implementation of the CObjectRender class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MapEditor.h"
#include "ObjectRender.h"
#include "ObjectChild.h"

#include "MainFrm.h"
#include "MapEditor.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"
#include <direct.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern LPDIRECT3DDEVICE8	g_pD3dDev;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CObjectRender::CObjectRender()
{
	m_nUseMeshNumber = 0;
	m_nMeshCount = 0; // 07-05-03 by shkim,  ޽ 
	m_nMeshBlockCount = 0; // 07-05-03 by shkim,  ޽  

	m_pMeshObjectNode = NULL;
	m_pMeshBlockNode = NULL;

	// 2009-05-15 by bhsohn ʿ 
	m_bMeshObjectNode = NULL;
	m_nMeshObjectNodeCnt = 0;

/*	int i;
	for(i=0;i<OBJECT_NORMAL_NUM;i++)
	{
		m_pMeshObjectNode[i] = new CSkinnedMesh();
	}
	for(i=0;i<OBJECT_BLOCK_NUM;i++)
	{
		m_pMeshBlockNode[i] = new CSkinnedMesh();
	}
*/

}

CObjectRender::~CObjectRender()
{
//	int i;
/*
	for(i=0;i<OBJECT_NORMAL_NUM;i++)
		SAFE_DELETE(m_pMeshObjectNode[i]);
	for(i=0;i<OBJECT_BLOCK_NUM;i++)
		SAFE_DELETE(m_pMeshBlockNode[i]);
*/
	// 2009-05-15 by bhsohn ʿ 
	SAFE_DELETE_ARRAY(m_bMeshObjectNode);
	m_nMeshObjectNodeCnt = 0;
	// end 2009-05-15 by bhsohn ʿ 
}

HRESULT CObjectRender::InitDeviceObjects()
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	char buf[256];
	wsprintf(buf,"%s\\Res-Obj",pView->m_strCurrentDir);
	_chdir(buf);

	int i = 0;
	if(pView->m_nObjectNormalCont > 0)
	{
		m_pMeshObjectNode = new CSkinnedMesh[pView->m_nObjectNormalCont];
		// 2009-05-15 by bhsohn ʿ 
// 		for(i=0;i<pView->m_nObjectNormalCont;i++)
// 		{
// 			m_pMeshObjectNode[i].InitDeviceObjects();
// 			m_pMeshObjectNode[i].LoadMeshHierarchy(i);
// 			wsprintf(buf,"03%04d00",i);
// 			pView->m_comboObjectSelect.AddString(buf);
// 		}
		SAFE_DELETE_ARRAY(m_bMeshObjectNode);
		m_nMeshObjectNodeCnt = pView->m_nObjectNormalCont;
		m_bMeshObjectNode = new BOOL[pView->m_nObjectNormalCont];
		for(i=0;i<pView->m_nObjectNormalCont;i++)
		{
			m_bMeshObjectNode[i] = FALSE;

 			wsprintf(buf,"03%04d00",i);
			pView->m_comboObjectSelect.AddString(buf);
		}
		// end 2009-05-15 by bhsohn ʿ 
		
	}
	if(pView->m_nObjectBlockCont > 0)
	{
		m_pMeshBlockNode = new CSkinnedMesh[pView->m_nObjectBlockCont];

		m_nMeshBlockCount = pView->m_nObjectBlockCont; //   ŭ 迭  ҰŴ.

		for(i=0;i<pView->m_nObjectBlockCont;i++)
		{
			m_pMeshBlockNode[i].InitDeviceObjects();
			m_pMeshBlockNode[i].LoadMeshHierarchy(9999-i);
			wsprintf(buf,"03%04d00",9999-i);
			pView->m_comboObjectSelect.AddString(buf);
		}
	}
/*
	for(i=0;i<OBJECT_NORMAL_NUM;i++)
	{
		wsprintf(buf,"03%04d00.obj",i);
		m_pMeshObjectNode[i]->InitDeviceObjects();
		m_pMeshObjectNode[i]->LoadMeshHierarchyFromMem(buf);
		pView->m_comboObjectSelect.AddString(buf);
	}
	for(i=0;i<OBJECT_BLOCK_NUM;i++)
	{
		wsprintf(buf,"03%04d00.obj",9999-i);
		m_pMeshBlockNode[i]->InitDeviceObjects();
		m_pMeshBlockNode[i]->LoadMeshHierarchyFromMem(buf);
		pView->m_comboObjectSelect.AddString(buf);
	}
*/
    D3DUtil_InitMaterial( m_Material, 1, 1, 1 );

	return S_OK;
}

///////////////////////////////////////////////////////////////////////////////
/// \fn			
/// \brief		̹ ε
/// \author		// 2009-05-15 by bhsohn ʿ 
/// \date		2009-05-15 ~ 2009-05-15
/// \warning	
///
/// \param		
/// \return		
///////////////////////////////////////////////////////////////////////////////
CSkinnedMesh* CObjectRender::GetSkinnedMesh_Idx_To_Mesh(int nIdx)
{	
	if(NULL == m_bMeshObjectNode)
	{
		return NULL;
	}
	else if(nIdx >= m_nMeshObjectNodeCnt)
	{
		return NULL;
	}
	else if(m_bMeshObjectNode[nIdx])
	{
		return &m_pMeshObjectNode[nIdx];
	}

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	char buf[256];
	wsprintf(buf,"%s\\Res-Obj",pView->m_strCurrentDir);
	_chdir(buf);

	m_pMeshObjectNode[nIdx].InitDeviceObjects();
	m_pMeshObjectNode[nIdx].LoadMeshHierarchy(nIdx);
	
	m_bMeshObjectNode[nIdx] = TRUE;

	return &m_pMeshObjectNode[nIdx];

}
HRESULT CObjectRender::RestoreDeviceObjects()
{
	g_pD3dDev->BeginStateBlock();
    g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE,  FALSE );
//  g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE,  TRUE );
//	g_pD3dDev->SetRenderState( D3DRS_ALPHAFUNC,  D3DCMP_GREATER );
//	g_pD3dDev->SetRenderState( D3DRS_ALPHAREF,  0 );
	g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   TRUE );
	g_pD3dDev->SetRenderState( D3DRS_LIGHTING, TRUE );
	g_pD3dDev->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
	g_pD3dDev->EndStateBlock( &m_dwStateBlock );
	return CSkinnedMesh::RestoreDeviceObjects();
}

HRESULT CObjectRender::InvalidateDeviceObjects()
{
	return CSkinnedMesh::InvalidateDeviceObjects();
}

HRESULT CObjectRender::DeleteDeviceObjects()
{
//	int i;
// 	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
//	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();	
	int i = 0;
	for( i = 0 ; i < m_nMeshCount ; i++ )
	{
		 // 07-05-03 by shkim, Ʈ ޸𸮸 
		m_pMeshObjectNode[i].DeleteDeviceObjects();
	}

	SAFE_DELETE_ARRAY(m_pMeshObjectNode);

	for( i = 0 ; i < m_nMeshBlockCount ; i++ )
	{
		// 07-05-03 by shkim, Ʈ  ޸𸮸 
		m_pMeshBlockNode[i].DeleteDeviceObjects();
	}

	SAFE_DELETE_ARRAY(m_pMeshBlockNode);

	// 2009-05-15 by bhsohn ʿ 
	m_nMeshObjectNodeCnt = 0;
	SAFE_DELETE_ARRAY(m_bMeshObjectNode);

/*	for(i=0;i<OBJECT_NORMAL_NUM;i++)
	{
		m_pMeshObjectNode[i]->DeleteDeviceObjects();
	}
	for(i=0;i<OBJECT_BLOCK_NUM;i++)
	{
		m_pMeshBlockNode[i]->DeleteDeviceObjects();
	}
*/	return CSkinnedMesh::DeleteDeviceObjects();
}

void CObjectRender::Render(CAtumNode * pNode)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	CObjectChild * pRender = (CObjectChild *)pNode;

	if(pRender->m_dwPartType < pView->m_nObjectNormalCont)
	{
		// 2009-05-15 by bhsohn ʿ 
// 		m_pMeshObjectNode[pRender->m_dwPartType].Tick(pRender->m_fCurrentTime);
// 		if(pRender->m_bRenderType)
// 		{
// 			g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
// 			g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,   D3DBLEND_SRCALPHA );
// 			g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_INVSRCALPHA );
// 			g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   TRUE );
// 		}
// 		else
// 			g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
// 		if(pRender->m_bCheckRender)
// 		{
// 			D3DXMATRIX matScale,mat;
// //			D3DXMatrixScaling(&matScale, pRender->m_info.fObjectScale,pRender->m_info.fObjectScale,pRender->m_info.fObjectScale);
// 			D3DXMatrixScaling(&matScale, 1.0f,1.0f,1.0f);
// 			mat = matScale*pRender->m_mMatrix;
// 			m_pMeshObjectNode[pRender->m_dwPartType].SetWorldMatrix(mat);
// //			m_pMeshObjectNode[pRender->m_dwPartType].AnotherTexture(pRender->m_info.bObjectTexIndex);
// 
// 			m_pMeshObjectNode[pRender->m_dwPartType].Render();
// 		}

		CSkinnedMesh* pSelMesh = GetSkinnedMesh_Idx_To_Mesh( pRender->m_dwPartType );
		if(pSelMesh)
		{
			pSelMesh->Tick(pRender->m_fCurrentTime);
			if(pRender->m_bRenderType)
			{
				g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
				g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,   D3DBLEND_SRCALPHA );
				g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_INVSRCALPHA );
				g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   TRUE );
			}
			else
				g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
			if(pRender->m_bCheckRender)
			{
				D3DXMATRIX matScale,mat;
				//			D3DXMatrixScaling(&matScale, pRender->m_info.fObjectScale,pRender->m_info.fObjectScale,pRender->m_info.fObjectScale);
				D3DXMatrixScaling(&matScale, 1.0f,1.0f,1.0f);
				mat = matScale*pRender->m_mMatrix;
				pSelMesh->SetWorldMatrix(mat);
				//			m_pMeshObjectNode[pRender->m_dwPartType].AnotherTexture(pRender->m_info.bObjectTexIndex);
				
				pSelMesh->Render();
			}
		}

		// end 2009-05-15 by bhsohn ʿ 		
	}
	else
	{
		m_pMeshBlockNode[pRender->m_dwPartType - 10000].Tick(pRender->m_fCurrentTime);
		g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
		if(pRender->m_bCheckRender)
		{
			D3DXMATRIX matScale,mat;
//			D3DXMatrixScaling(&matScale, pRender->m_info.fObjectScale,pRender->m_info.fObjectScale,pRender->m_info.fObjectScale);
			D3DXMatrixScaling(&matScale, 1.0f,1.0f,1.0f);
			mat = matScale*pRender->m_mMatrix;
			m_pMeshBlockNode[pRender->m_dwPartType-10000].SetWorldMatrix(pRender->m_mMatrix);
//			m_pMeshBlockNode[pRender->m_dwPartType-10000].AnotherTexture(pRender->m_info.bObjectTexIndex);
			m_pMeshBlockNode[pRender->m_dwPartType-10000].Render();
		}
	}
/*
	if(pRender->m_dwPartType < OBJECT_NORMAL_NUM)
	{
		m_pMeshObjectNode[pRender->m_dwPartType]->Tick(pRender->m_fCurrentTime);
		if(pRender->m_bRenderType)
		{
			g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
			g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,   D3DBLEND_SRCALPHA );
			g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_INVSRCALPHA );
			g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   TRUE );
		}
		else
			g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
		if(pRender->m_bCheckRender)
		{
			m_pMeshObjectNode[pRender->m_dwPartType]->SetWorldMatrix(pRender->m_mMatrix);
			m_pMeshObjectNode[pRender->m_dwPartType]->Render();
		}
	}
	else
	{
		m_pMeshBlockNode[pRender->m_dwPartType-OBJECT_NORMAL_NUM]->Tick(pRender->m_fCurrentTime);
		g_pD3dDev->ApplyStateBlock( m_dwStateBlock );
		if(pRender->m_bCheckRender)
		{
			m_pMeshBlockNode[pRender->m_dwPartType-OBJECT_NORMAL_NUM]->SetWorldMatrix(pRender->m_mMatrix);
			m_pMeshBlockNode[pRender->m_dwPartType-OBJECT_NORMAL_NUM]->Render();
		}
	}
*/
}

void CObjectRender::RenderPreView(D3DXVECTOR3 vPos)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	
    g_pD3dDev->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    g_pD3dDev->SetRenderState( D3DRS_ALPHATESTENABLE, FALSE );
    g_pD3dDev->SetRenderState( D3DRS_SRCBLEND,   D3DBLEND_ONE );
    g_pD3dDev->SetRenderState( D3DRS_DESTBLEND,  D3DBLEND_ONE );
	g_pD3dDev->SetRenderState( D3DRS_ZENABLE,   TRUE );
	g_pD3dDev->SetRenderState( D3DRS_LIGHTING, TRUE );
	D3DXMATRIX mMatrix;
	D3DXVECTOR3 vUp, vVel;
	vUp = D3DXVECTOR3(0,1,0);
	vVel = D3DXVECTOR3(1,0,0);
//	if(pView->m_dwObjectType >= pView->m_nObjectNormalCont)
//	{
		if(pView->m_bObjectDir == 0)
			vVel = D3DXVECTOR3(1,0,0);
		else if(pView->m_bObjectDir == 1)
			vVel = D3DXVECTOR3(0,0,1);
		else if(pView->m_bObjectDir == 2)
			vVel = D3DXVECTOR3(-1,0,0);
		else
			vVel = D3DXVECTOR3(0,0,-1);
		int x = ((int)(vPos.x/20.0f));
		int z = ((int)(vPos.z/20.0f));
		vPos.x = x*20;
	//	vPos.y = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight;	
		vPos.z = z*20;
//	}

	D3DXMatrixLookAtLH(&mMatrix,&vPos,&(vPos+vVel),&vUp);
	D3DXMatrixInverse(&mMatrix,NULL,&mMatrix);

	if(pView->m_dwObjectType < pView->m_nObjectNormalCont)
	{

		// 2009-05-15 by bhsohn ʿ 
// 		m_pMeshObjectNode[pView->m_dwObjectType].Tick(0.0f);
// 		m_pMeshObjectNode[pView->m_dwObjectType].SetWorldMatrix(mMatrix);
// 		m_pMeshObjectNode[pView->m_dwObjectType].AnotherTexture(1);
// 		m_pMeshObjectNode[pView->m_dwObjectType].Render();
		
		CSkinnedMesh* pSelMesh = GetSkinnedMesh_Idx_To_Mesh(pView->m_dwObjectType);
		if(pSelMesh)
		{
			pSelMesh->Tick(0.0f);
			pSelMesh->SetWorldMatrix(mMatrix);
			pSelMesh->AnotherTexture(1);
			pSelMesh->Render();
		}
		// end 2009-05-15 by bhsohn ʿ 

	}
	else
	{
		
		// 2009-05-15 by bhsohn ʿ 
// 		m_pMeshBlockNode[pView->m_dwObjectType - pView->m_nObjectNormalCont].Tick(0.0f);
// 		m_pMeshBlockNode[pView->m_dwObjectType - pView->m_nObjectNormalCont].SetWorldMatrix(mMatrix);
// 		m_pMeshBlockNode[pView->m_dwObjectType - pView->m_nObjectNormalCont].AnotherTexture(1);
// 		m_pMeshBlockNode[pView->m_dwObjectType - pView->m_nObjectNormalCont].Render();

		CSkinnedMesh* pSelMesh = GetSkinnedMesh_Idx_To_Mesh(pView->m_dwObjectType - pView->m_nObjectNormalCont);
		if(pSelMesh)
		{
			pSelMesh->Tick(0.0f);
			pSelMesh->SetWorldMatrix(mMatrix);
			pSelMesh->AnotherTexture(1);
			pSelMesh->Render();
		}
		// end 2009-05-15 by bhsohn ʿ 
	}
/*
	if(pView->m_dwObjectType >= OBJECT_NORMAL_NUM)
	{
		if(pView->m_bObjectDir == 0)
			vVel = D3DXVECTOR3(1,0,0);
		else if(pView->m_bObjectDir == 1)
			vVel = D3DXVECTOR3(0,0,1);
		else if(pView->m_bObjectDir == 2)
			vVel = D3DXVECTOR3(-1,0,0);
		else
			vVel = D3DXVECTOR3(0,0,-1);
		int x = ((int)(vPos.x/20.0f));
		int z = ((int)(vPos.z/20.0f));
		float fHeight;
		switch(pView->m_dwObjectType-OBJECT_NORMAL_NUM)
		{
			case 0:
			{
				vPos.x = x*20 + 10;
				vPos.z = z*20 + 10;
				if(pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].nUseBlockCount)
					vPos.y = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight;
				else
					vPos.y = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight;
				break;
			}
			case 1:
			{
				if(((int)vPos.x)%20 > 10)
					x++;
				if(((int)vPos.z)%20 > 10)
					z++;
				vPos.x = x*20;
				vPos.z = z*20;
				if(pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].nUseBlockCount
					|| pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].nUseBlockCount
					|| pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].nUseBlockCount
					|| pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].nUseBlockCount)
				{
					fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight;
					if(fHeight < pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight)
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight;
					if(fHeight < pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight)
						fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight;
					if(fHeight < pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight)
						fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight;
				}
				else
				{
					fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight;
					if(fHeight > pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight)
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight;
					if(fHeight > pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight)
						fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight;
					if(fHeight > pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight)
						fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight;
				}
				vPos.y = fHeight;
				break;
			}
			case 2:
			{
				if(((int)vPos.x)%20 > 10)
					x++;
				if(((int)vPos.z)%20 > 10)
					z++;
				vPos.x = x*20;
				vPos.z = z*20;
				if(pView->m_bObjectDir==1 || 3)
				{
					if(pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].nUseBlockCount
						|| pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].nUseBlockCount)
					{
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight;
						if(fHeight < pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight)
							fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight;
					}
					else
					{
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight;
						if(fHeight > pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight)
							fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight;
					}
				}
				else
				{
					if(pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].nUseBlockCount
						|| pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].nUseBlockCount)
					{
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight;
						if(fHeight < pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight)
							fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight;
					}
					else
					{
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight;
						if(fHeight > pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight)
							fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight;
					}
				}
				vPos.y = fHeight;
				break;
			}
			case 3:
			{
				if(((int)vPos.x)%20 > 10)
					x++;
				if(((int)vPos.z)%20 > 10)
					z++;
				vPos.x = x*20;
				vPos.z = z*20;
				if(pView->m_bObjectDir==1 || 3)
				{
					if(pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].nUseBlockCount
						|| pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].nUseBlockCount)
					{
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight;
						if(fHeight < pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight)
							fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight;
					}
					else
					{
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight;
						if(fHeight > pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight)
							fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight;
					}
				}
				else
				{
					if(pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].nUseBlockCount
						|| pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].nUseBlockCount)
					{
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].fBlockHeight;
						if(fHeight < pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight)
							fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fBlockHeight;
					}
					else
					{
						fHeight = pView->m_pBackground->m_pBlockData[(x-1)*(2*pView->m_pBackground->m_sYSize) + z-1].fGroundHeight;
						if(fHeight > pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight)
							fHeight = pView->m_pBackground->m_pBlockData[x*(2*pView->m_pBackground->m_sYSize) + z].fGroundHeight;
					}
				}
				vPos.y = fHeight;
				break;
			}
		}
	}
	D3DXMatrixLookAtLH(&mMatrix,&vPos,&(vPos+vVel),&vUp);
	D3DXMatrixInverse(&mMatrix,NULL,&mMatrix);

	if(pView->m_dwObjectType < OBJECT_NORMAL_NUM)
	{
		m_pMeshObjectNode[pView->m_dwObjectType]->Tick(0.0f);
		m_pMeshObjectNode[pView->m_dwObjectType]->SetWorldMatrix(mMatrix);
		m_pMeshObjectNode[pView->m_dwObjectType]->Render();
	}
	else
	{
		m_pMeshBlockNode[pView->m_dwObjectType-OBJECT_NORMAL_NUM]->Tick(0.0f);
		m_pMeshBlockNode[pView->m_dwObjectType-OBJECT_NORMAL_NUM]->SetWorldMatrix(mMatrix);
		m_pMeshBlockNode[pView->m_dwObjectType-OBJECT_NORMAL_NUM]->Render();
	}
*/
}

void CObjectRender::InsertObject(CString strFilename)
{
/*
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	char buf[256];
	wsprintf(buf,"%s\\Res-Obj",pView->m_strCurrentDir);
	_chdir(buf);
	wsprintf(buf,"%s",strFilename);
	m_pMeshObjectNode[m_nUseMeshNumber]->InitDeviceObjects();
	m_pMeshObjectNode[m_nUseMeshNumber]->LoadMeshHierarchyFromMem(buf);
	m_nUseMeshNumber++;
*/
}

float CObjectRender::CheckMeshColl(CAtumNode *pNode,D3DXMATRIX mat)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	float fDist;
	CObjectChild * pChild = (CObjectChild *)pNode;
	if(pChild->m_dwPartType < pView->m_nObjectNormalCont)
	{
		// 2009-05-15 by bhsohn ʿ 
// 		m_pMeshObjectNode[pChild->m_dwPartType].Tick(0.0f);
// 		m_pMeshObjectNode[pChild->m_dwPartType].SetWorldMatrix(pChild->m_mMatrix);
// 		fDist = m_pMeshObjectNode[pChild->m_dwPartType].CheckCollision(mat);

		CSkinnedMesh* pSelMesh = GetSkinnedMesh_Idx_To_Mesh(pChild->m_dwPartType);
		if(pSelMesh)
		{
			pSelMesh->Tick(0.0f);
			pSelMesh->SetWorldMatrix(pChild->m_mMatrix);
			fDist = pSelMesh->CheckCollision(mat);
		}

		// end 2009-05-15 by bhsohn ʿ 
	}
	else
	{
		// 2009-05-15 by bhsohn ʿ 
// 		m_pMeshBlockNode[pChild->m_dwPartType - 10000].Tick(0.0f);
// 		m_pMeshBlockNode[pChild->m_dwPartType - 10000].SetWorldMatrix(pChild->m_mMatrix);
// 		fDist = m_pMeshBlockNode[pChild->m_dwPartType - 10000].CheckCollision(mat);

		CSkinnedMesh* pSelMesh = GetSkinnedMesh_Idx_To_Mesh(pChild->m_dwPartType - 10000);
		if(pSelMesh)
		{
			pSelMesh->Tick(0.0f);
			pSelMesh->SetWorldMatrix(pChild->m_mMatrix);
			fDist = pSelMesh->CheckCollision(mat);
		}
		// end 2009-05-15 by bhsohn ʿ 
	}
	return fDist;
}
