// ObjectRender.h: interface for the CObjectRender class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OBJECTRENDER_H__C409C051_FCD2_43F0_9025_500B72F2B185__INCLUDED_)
#define AFX_OBJECTRENDER_H__C409C051_FCD2_43F0_9025_500B72F2B185__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SkinnedMesh.h"

class CObjectRender : public CSkinnedMesh  
{
public:
	CObjectRender();
	virtual ~CObjectRender();
	virtual HRESULT InitDeviceObjects();
	virtual HRESULT RestoreDeviceObjects();
	virtual HRESULT InvalidateDeviceObjects();
	virtual HRESULT DeleteDeviceObjects();
	virtual void Render(CAtumNode * pNode);
	void RenderPreView(D3DXVECTOR3 vPos);
	void InsertObject(CString strFilename);

	float CheckMeshColl(CAtumNode *pNode,D3DXMATRIX mat);

public:
	// 2009-05-15 by bhsohn ʿ 
	CSkinnedMesh* GetSkinnedMesh_Idx_To_Mesh(int nIdx);

	// 2009-05-15 by bhsohn ʿ 
	BOOL 					*m_bMeshObjectNode;
	int						m_nMeshObjectNodeCnt;
	D3DXVECTOR3				m_vColor;			// Į
	DWORD					m_dwColor;			// Į
	D3DMATERIAL8			m_Material;			// 
	
	CSkinnedMesh 	*		m_pMeshObjectNode;//[OBJECT_NORMAL_NUM];
	CSkinnedMesh 	*		m_pMeshBlockNode;//[OBJECT_BLOCK_NUM];
	int 					m_nUseMeshNumber;

private:
	int						m_nMeshCount; // 07-05-03 by shkim,  ޽ 
	int						m_nMeshBlockCount; // 07-05-03 by shkim,  ޽  
};

#endif // !defined(AFX_OBJECTRENDER_H__C409C051_FCD2_43F0_9025_500B72F2B185__INCLUDED_)
