// ObjectSetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mapeditor.h"
#include "ObjectSetDlg.h"

#include "Dbgout_C.h"
#include "MainFrm.h"
#include "MapEditor.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#include "ObjectInfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define D3DXToRadian( degree ) ((degree) * (D3DX_PI / 180.0f))
#define D3DXToDegree( radian ) ((radian) * (180.0f / D3DX_PI))

/////////////////////////////////////////////////////////////////////////////
// CObjectSetDlg dialog


CObjectSetDlg::CObjectSetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CObjectSetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CObjectSetDlg)
	m_editArea = 0;
	m_strObjectname = _T("");
	m_strPosition = _T("");
	m_editPosX = 0.0f;
	m_editPosY = 0.0f;
	m_editPosZ = 0.0f;
	m_strTarget = _T("");
	m_strUp = _T("");
	m_bHeight = FALSE;
	m_bAlpha = FALSE;
	m_bMoveRotation = FALSE;
	m_editMoveObject = 0.0f;
	m_checkMoveObject = FALSE;
	m_fAngleSide = 0.0f;
	m_fAngleTarget = 0.0f;
	m_fAngleUp = 0.0f;
	//}}AFX_DATA_INIT

	m_pObject = NULL;
	vTempVel = D3DXVECTOR3(0,0,0);
	vTempUp = D3DXVECTOR3(0,0,0);

}


void CObjectSetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjectSetDlg)
	DDX_Control(pDX, IDC_SLIDER_SIDE, m_sliderSide);
	DDX_Control(pDX, IDC_SLIDER_UP, m_sliderUp);
	DDX_Control(pDX, IDC_SLIDER_TARGET, m_sliderTarget);
	DDX_Text(pDX, IDC_EDIT_AREA, m_editArea);
	DDX_Text(pDX, IDC_EDIT_OBJECTNAME, m_strObjectname);
	DDX_Text(pDX, IDC_EDIT_POS, m_strPosition);
	DDX_Text(pDX, IDC_EDIT_POSX, m_editPosX);
	DDX_Text(pDX, IDC_EDIT_POSY, m_editPosY);
	DDX_Text(pDX, IDC_EDIT_POSZ, m_editPosZ);
	DDX_Text(pDX, IDC_EDIT_TARGET, m_strTarget);
	DDX_Text(pDX, IDC_EDIT_UP, m_strUp);
	DDX_Check(pDX, IDC_CHECK_HEIGHT, m_bHeight);
	DDX_Check(pDX, IDC_CHECK_ALPHA, m_bAlpha);
	DDX_Check(pDX, IDC_CHECK_MOVEROTATION, m_bMoveRotation);
	DDX_Text(pDX, IDC_EDIT_MOVE_OBJECT, m_editMoveObject);
	DDX_Check(pDX, IDC_CHECK_MOVE_OBJECT, m_checkMoveObject);
	DDX_Text(pDX, IDC_EDIT_ANGLE_SIDE, m_fAngleSide);
	DDX_Text(pDX, IDC_EDIT_ANGLE_TARGET, m_fAngleTarget);
	DDX_Text(pDX, IDC_EDIT_ANGLE_UP, m_fAngleUp);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjectSetDlg, CDialog)
	//{{AFX_MSG_MAP(CObjectSetDlg)
	ON_EN_CHANGE(IDC_EDIT_POSX, OnChangeEditPosx)
	ON_EN_CHANGE(IDC_EDIT_POSY, OnChangeEditPosy)
	ON_EN_CHANGE(IDC_EDIT_POSZ, OnChangeEditPosz)
	ON_BN_CLICKED(IDC_CHECK_HEIGHT, OnCheckHeight)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_TARGET, OnReleasedcaptureSliderTarget)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_UP, OnReleasedcaptureSliderUp)
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT, OnButtonDefault)
	ON_BN_CLICKED(IDC_CHECK_ALPHA, OnCheckAlpha)
	ON_BN_CLICKED(IDC_CHECK_MOVEROTATION, OnCheckMoverotation)
	ON_BN_CLICKED(IDC_BUTTON_SETNORMAL, OnButtonSetnormal)
	ON_EN_CHANGE(IDC_EDIT_MOVE_OBJECT, OnChangeEditMoveObject)
	ON_BN_CLICKED(IDC_CHECK_MOVE_OBJECT, OnCheckMoveObject)
	ON_EN_CHANGE(IDC_EDIT_ANGLE_TARGET, OnChangeEditAngleTarget)
	ON_EN_CHANGE(IDC_EDIT_ANGLE_UP, OnChangeEditAngleUp)
	ON_EN_CHANGE(IDC_EDIT_ANGLE_SIDE, OnChangeEditAngleSide)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SIDE, OnReleasedcaptureSliderSide)
	ON_BN_CLICKED(IDC_BUTTON_INFO, OnButtonInfo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectSetDlg message handlers

void CObjectSetDlg::OnChangeEditPosx() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_pObject)
		m_pObject->m_vPos.x = m_editPosX;
	SetData();
	
}

void CObjectSetDlg::OnChangeEditPosy() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_pObject)
		m_pObject->m_vPos.y = m_editPosY;
	UpdateData(FALSE);
	SetData();
	
}

void CObjectSetDlg::OnChangeEditPosz() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_pObject)
		m_pObject->m_vPos.z = m_editPosZ;
	SetData();
	
}



void CObjectSetDlg::ObjectSelect(CObjectChild *pObj)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	if(m_pObject)
	{
		m_pObject->m_bCheckChoose = FALSE;
		m_pObject->m_bCheckRender = TRUE;
	}

	m_pObject = pObj;

	if(m_pObject)
	{
		vTempVel = m_pObject->m_vVel;
		vTempUp = m_pObject->m_vUp;
		m_bHeight = m_pObject->m_bCheckTick;
		m_bAlpha = m_pObject->m_bRenderType;
		m_pObject->m_bCheckChoose = TRUE;
		CString str;
//		str.GetBufferSetLength(50);
		m_editPosX = m_pObject->m_vPos.x;
		m_editPosY = m_pObject->m_vPos.y;
		m_editPosZ = m_pObject->m_vPos.z;
		int index = 0;


		if(m_pObject->m_dwPartType >= 10000)
		{
			index = m_pObject->m_dwPartType - 10000;
			index += pView->m_nObjectNormalCont;
			DBGOUT("[m_pObject] m_pObject count(%d)\n", index);
		}
		else
		{
			index = m_pObject->m_dwPartType;
			DBGOUT("[m_pObject] m_pObject->m_dwPartType(%d)\n", index);
		}
		

		pView->m_comboObjectSelect.GetLBText(index,m_strObjectname);
		str.Format("%8.2f,%8.2f,%8.2f",m_pObject->m_vPos.x,m_pObject->m_vPos.y,m_pObject->m_vPos.z);
		m_strPosition = str;
		str.Format("%8.2f,%8.2f,%8.2f",m_pObject->m_vVel.x,m_pObject->m_vVel.y,m_pObject->m_vVel.z);
		m_strTarget = str;
		str.Format("%8.2f,%8.2f,%8.2f",m_pObject->m_vUp.x,m_pObject->m_vUp.y,m_pObject->m_vUp.z);
		m_strUp = str;

//		LPSTR lpCmdLing = _T("ObjectSelect => pObj");
//		DBGOUT("[Error] Parameter Count Error, address(%x)_(%s)\n", pObj, str);

//		lpCmdLing = _T("ObjectSelect => m_pObject");
		DBGOUT("[TEST] Parameter Count Error, address(%x)_(%s)\n", m_pObject, str);

	}
	UpdateData(FALSE);
}

void CObjectSetDlg::OnCheckHeight() 
{
	// TODO: Add your control notification handler code here
	m_bHeight = !m_bHeight;
	if(m_pObject)
	{
		if(m_bHeight)
		{
			m_pObject->m_bCheckTick = TRUE;
		}
		else
		{
			m_pObject->m_bCheckTick = FALSE;
		}
	}
}
void CObjectSetDlg::SetRenderState()
{
	if(m_pObject)
	{
		m_pObject->m_bCheckChoose = FALSE;
		m_pObject->m_bCheckRender = TRUE;
	}
}
void CObjectSetDlg::SetData()
{
	if(m_pObject)
	{
		CString str;
		str.Format("%8.2f,%8.2f,%8.2f",m_pObject->m_vPos.x,m_pObject->m_vPos.y,m_pObject->m_vPos.z);
		m_strPosition = str;
		str.Format("%8.2f,%8.2f,%8.2f",m_pObject->m_vVel.x,m_pObject->m_vVel.y,m_pObject->m_vVel.z);
		m_strTarget = str;
		str.Format("%8.2f,%8.2f,%8.2f",m_pObject->m_vUp.x,m_pObject->m_vUp.y,m_pObject->m_vUp.z);
		m_strUp = str;
	}
	UpdateData(FALSE);
}

void CObjectSetDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CDialog::OnCancel();
}

void CObjectSetDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CObjectSetDlg::OnReleasedcaptureSliderTarget(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	if(m_pObject)
	{
		D3DXMATRIX matTemp;
		D3DXVECTOR3 vSide;
		m_pObject->m_vUp = D3DXVECTOR3(0,1,0);
		m_pObject->m_vVel = D3DXVECTOR3(1,0,0);
		vSide = D3DXVECTOR3(0,0,1);
		int nPos = m_sliderTarget.GetPos();
		float m_fAngleTargetRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleTarget = D3DXToDegree( m_fAngleTargetRadian );
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vUp, m_fAngleTargetRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );

		nPos = m_sliderUp.GetPos();
		float m_fAngleUpRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleUp = D3DXToDegree( m_fAngleUpRadian );
		D3DXMatrixRotationAxis( &matTemp, &vSide, m_fAngleUpRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );

		nPos = m_sliderSide.GetPos();
		float m_fAngleSideRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleSide = D3DXToDegree( m_fAngleSideRadian );
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vVel, m_fAngleSideRadian);
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
	}
	else
		AfxMessageBox("Please select and object.",MB_OK);
	UpdateData(FALSE);
	
	*pResult = 0;
}

void CObjectSetDlg::OnReleasedcaptureSliderUp(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	if(m_pObject)
	{
		D3DXMATRIX matTemp;
		D3DXVECTOR3 vSide;
		m_pObject->m_vUp = D3DXVECTOR3(0,1,0);
		m_pObject->m_vVel = D3DXVECTOR3(1,0,0);
		vSide = D3DXVECTOR3(0,0,1);
		int nPos = m_sliderTarget.GetPos();
		float m_fAngleTargetRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleTarget = D3DXToDegree( m_fAngleTargetRadian );
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vUp, m_fAngleTargetRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );

		nPos = m_sliderUp.GetPos();
		float m_fAngleUpRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleUp = D3DXToDegree( m_fAngleUpRadian );
		D3DXMatrixRotationAxis( &matTemp, &vSide, m_fAngleUpRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );

		nPos = m_sliderSide.GetPos();
		float m_fAngleSideRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleSide = D3DXToDegree( m_fAngleSideRadian );
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vVel, m_fAngleSideRadian);
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
	}
	else
		AfxMessageBox("Please select an object.",MB_OK);
	UpdateData(FALSE);
	
	*pResult = 0;
}

void CObjectSetDlg::OnReleasedcaptureSliderSide(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	if(m_pObject)
	{
		D3DXMATRIX matTemp;
		D3DXVECTOR3 vSide;
		m_pObject->m_vUp = D3DXVECTOR3(0,1,0);
		m_pObject->m_vVel = D3DXVECTOR3(1,0,0);
		vSide = D3DXVECTOR3(0,0,1);
		int nPos = m_sliderTarget.GetPos();
		float m_fAngleTargetRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleTarget = D3DXToDegree( m_fAngleTargetRadian );
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vUp, m_fAngleTargetRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );

		nPos = m_sliderUp.GetPos();
		float m_fAngleUpRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleUp = D3DXToDegree( m_fAngleUpRadian );
		D3DXMatrixRotationAxis( &matTemp, &vSide, m_fAngleUpRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );

		nPos = m_sliderSide.GetPos();
		float m_fAngleSideRadian = 3.14f*2.0f*nPos/1000.0f;
		m_fAngleSide = D3DXToDegree( m_fAngleSideRadian );
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vVel, m_fAngleSideRadian);
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
	}
	else
		AfxMessageBox("Please select an object.",MB_OK);
	UpdateData(FALSE);
	
	*pResult = 0;
}

BOOL CObjectSetDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_sliderTarget.SetRange(1,1000);
	m_sliderTarget.SetPos(1);
	m_sliderUp.SetRange(1,1000);
	m_sliderUp.SetPos(1);
	m_sliderSide.SetRange(1,1000);
	m_sliderSide.SetPos(1);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CObjectSetDlg::OnButtonDefault() 
{
	// TODO: Add your control notification handler code here
	if(m_pObject)
	{
		m_pObject->m_vVel = D3DXVECTOR3(0,0,1);
		m_pObject->m_vUp = D3DXVECTOR3(0,1,0);
	}
}

void CObjectSetDlg::OnCheckAlpha() 
{
	// TODO: Add your control notification handler code here
	m_bAlpha = !m_bAlpha;
	if(m_pObject)
	{
		if(m_bAlpha)
		{
			m_pObject->m_bRenderType = TRUE;
		}
		else
		{
			m_pObject->m_bRenderType = FALSE;
		}
	}
	
}

void CObjectSetDlg::OnCheckMoverotation() 
{
	// TODO: Add your control notification handler code here
	m_bMoveRotation = !m_bMoveRotation;
}

void CObjectSetDlg::OnButtonSetnormal() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	UpdateData();
	if(m_pObject)
	{
		float fDist,fBary1,fBary2;
		int x = m_pObject->m_vPos.x/40.0f;
		int z = m_pObject->m_vPos.z/40.0f;
		D3DXVECTOR3 vDir = D3DXVECTOR3(0,-1,0);
		D3DXVECTOR3 vPos = m_pObject->m_vPos-vDir;
		D3DXVECTOR3 vUp = m_pObject->m_vUp;
		if(pView->m_pBackground->IntersectTriangle(vPos,vDir,pView->m_pBackground->m_pTileVertexArray[(x)*(pView->m_pBackground->m_sYSize+1)+z].pos,
			pView->m_pBackground->m_pTileVertexArray[(x)*(pView->m_pBackground->m_sYSize+1)+(z+1)].pos,pView->m_pBackground->m_pTileVertexArray[(x+1)*(pView->m_pBackground->m_sYSize+1)+(z+1)].pos,
			&fDist, &fBary1, &fBary2 ))
		{
			//  Ÿ ٲٱ
			D3DXVec3Cross(&m_pObject->m_vUp,&(pView->m_pBackground->m_pTileVertexArray[(x)*(pView->m_pBackground->m_sYSize+1)+(z+1)].pos-pView->m_pBackground->m_pTileVertexArray[(x)*(pView->m_pBackground->m_sYSize+1)+z].pos)
				,&(pView->m_pBackground->m_pTileVertexArray[(x+1)*(pView->m_pBackground->m_sYSize+1)+(z+1)].pos-pView->m_pBackground->m_pTileVertexArray[(x)*(pView->m_pBackground->m_sYSize+1)+(z+1)].pos));
			D3DXVec3Cross(&m_pObject->m_vVel,&vUp,&m_pObject->m_vUp);
		}
		else if(pView->m_pBackground->IntersectTriangle(vPos,vDir,pView->m_pBackground->m_pTileVertexArray[(x)*(pView->m_pBackground->m_sYSize+1)+z].pos,
			pView->m_pBackground->m_pTileVertexArray[(x+1)*(pView->m_pBackground->m_sYSize+1)+(z+1)].pos,pView->m_pBackground->m_pTileVertexArray[(x+1)*(pView->m_pBackground->m_sYSize+1)+z].pos,
			&fDist, &fBary1, &fBary2 ))
		{
			D3DXVec3Cross(&m_pObject->m_vUp,&(pView->m_pBackground->m_pTileVertexArray[(x+1)*(pView->m_pBackground->m_sYSize+1)+(z+1)].pos-pView->m_pBackground->m_pTileVertexArray[(x)*(pView->m_pBackground->m_sYSize+1)+z].pos)
				,&(pView->m_pBackground->m_pTileVertexArray[(x+1)*(pView->m_pBackground->m_sYSize+1)+(z)].pos-pView->m_pBackground->m_pTileVertexArray[(x+1)*(pView->m_pBackground->m_sYSize+1)+(z+1)].pos));
			D3DXVec3Cross(&m_pObject->m_vVel,&vUp,&m_pObject->m_vUp);
		}
	}
}

void CObjectSetDlg::OnChangeEditMoveObject() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
}

void CObjectSetDlg::OnCheckMoveObject() 
{
	// TODO: Add your control notification handler code here
	m_checkMoveObject = !m_checkMoveObject;
}

void CObjectSetDlg::OnChangeEditAngleTarget() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();
	if(m_pObject)
	{
		D3DXMATRIX matTemp;
		D3DXVECTOR3 vSide;
		m_pObject->m_vUp = D3DXVECTOR3(0,1,0);
		m_pObject->m_vVel = D3DXVECTOR3(1,0,0);
		vSide = D3DXVECTOR3(0,0,1);
		int nPos;
		float m_fAngleTargetRadin = D3DXToRadian( m_fAngleTarget );
		nPos = (int)((m_fAngleTargetRadin*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vUp, m_fAngleTargetRadin);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		m_sliderTarget.SetPos(nPos);

		float m_fAngleUpRadian = D3DXToRadian( m_fAngleUp );
		nPos = (int)((m_fAngleUpRadian*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &vSide, m_fAngleUpRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
		m_sliderUp.SetPos(nPos);

		float m_fAngleSideRadian = D3DXToRadian( m_fAngleSide );
		nPos = (int)((m_fAngleSideRadian*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vVel, m_fAngleSideRadian);
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
		m_sliderSide.SetPos(m_fAngleSideRadian);
	}
	else
		AfxMessageBox("Please select an object.",MB_OK);
//	UpdateData(FALSE);
	
}

void CObjectSetDlg::OnChangeEditAngleUp() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();
	if(m_pObject)
	{
		D3DXMATRIX matTemp;
		D3DXVECTOR3 vSide;
		m_pObject->m_vUp = D3DXVECTOR3(0,1,0);
		m_pObject->m_vVel = D3DXVECTOR3(1,0,0);
		vSide = D3DXVECTOR3(0,0,1);
		int nPos;
		float m_fAngleTargetRadin = D3DXToRadian( m_fAngleTarget );
		nPos = (int)((m_fAngleTargetRadin*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vUp, m_fAngleTargetRadin);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		m_sliderTarget.SetPos(nPos);

		float m_fAngleUpRadian = D3DXToRadian( m_fAngleUp );
		nPos = (int)((m_fAngleUpRadian*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &vSide, m_fAngleUpRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
		m_sliderUp.SetPos(nPos);

		float m_fAngleSideRadian = D3DXToRadian( m_fAngleSide );
		nPos = (int)((m_fAngleSideRadian*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vVel, m_fAngleSideRadian);
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
		m_sliderSide.SetPos(m_fAngleSideRadian);
	}
	else
		AfxMessageBox("Please select an object.",MB_OK);
//	UpdateData(FALSE);
	
}

void CObjectSetDlg::OnChangeEditAngleSide() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData();
	if(m_pObject)
	{
		D3DXMATRIX matTemp;
		D3DXVECTOR3 vSide;
		m_pObject->m_vUp = D3DXVECTOR3(0,1,0);
		m_pObject->m_vVel = D3DXVECTOR3(1,0,0);
		vSide = D3DXVECTOR3(0,0,1);
		int nPos;
		float m_fAngleTargetRadin = D3DXToRadian( m_fAngleTarget );
		nPos = (int)((m_fAngleTargetRadin*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vUp, m_fAngleTargetRadin);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		m_sliderTarget.SetPos(nPos);

		float m_fAngleUpRadian = D3DXToRadian( m_fAngleUp );
		nPos = (int)((m_fAngleUpRadian*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &vSide, m_fAngleUpRadian);
		D3DXVec3TransformCoord( &m_pObject->m_vVel, &m_pObject->m_vVel, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
		m_sliderUp.SetPos(nPos);

		float m_fAngleSideRadian = D3DXToRadian( m_fAngleSide );
		nPos = (int)((m_fAngleSideRadian*1000.0f)/(3.14f*2.0f));
		D3DXMatrixRotationAxis( &matTemp, &m_pObject->m_vVel, m_fAngleSideRadian);
		D3DXVec3TransformCoord( &vSide, &vSide, &matTemp );
		D3DXVec3TransformCoord( &m_pObject->m_vUp, &m_pObject->m_vUp, &matTemp );
		m_sliderSide.SetPos(m_fAngleSideRadian);
		

		
	
	}
	else
		AfxMessageBox("Please select an object.",MB_OK);
//	UpdateData(FALSE);
	
}


void CObjectSetDlg::OnButtonInfo() 
{
	// TODO: Add your control notification handler code here
	if(m_pObject)
	{
		CObjectInfoDlg * pDlg = new CObjectInfoDlg();
		pDlg->m_bIsEvent = m_pObject->m_info.bIsEvent;
		pDlg->m_strEventParam.Format("%s",m_pObject->m_info.strEventParam);
		pDlg->m_bEventType = m_pObject->m_info.bEventType;
		pDlg->m_sEventIndexFrom = m_pObject->m_info.sEventIndexFrom;
		pDlg->m_sEventIndexTo = m_pObject->m_info.sEventIndexTo;
		pDlg->m_sEventIndex3 = m_pObject->m_info.sEventIndex3;
//		pDlg->m_fObjectScale = m_pObject->m_info.fObjectScale;
		pDlg->m_dwMonsterUniqueNumber = m_pObject->m_info.dwMonsterUniqueNumber;
		pDlg->m_nObjectSrcIndex = m_pObject->m_info.nObjectSrcIndex;
		pDlg->m_bObjectTexIndex = m_pObject->m_info.bObjectTexIndex;
		pDlg->m_dwObjectType = m_pObject->m_info.dwObjectType;
		pDlg->m_sObjectBodycondition = m_pObject->m_info.bBodyCondition;
		UpdateData(FALSE);
		if(pDlg->DoModal()==IDOK)
		{
			m_pObject->m_info.bIsEvent = pDlg->m_bIsEvent;
			memset(m_pObject->m_info.strEventParam, 0x00, sizeof(m_pObject->m_info.strEventParam) );
			strncpy(m_pObject->m_info.strEventParam, pDlg->m_strEventParam,strlen(pDlg->m_strEventParam));
			m_pObject->m_info.bEventType= pDlg->m_bEventType;
			m_pObject->m_info.sEventIndexFrom = pDlg->m_sEventIndexFrom;
			m_pObject->m_info.sEventIndexTo = pDlg->m_sEventIndexTo;
			m_pObject->m_info.sEventIndex3 = pDlg->m_sEventIndex3;
//			m_pObject->m_info.fObjectScale = pDlg->m_fObjectScale;
			m_pObject->m_info.dwMonsterUniqueNumber = pDlg->m_dwMonsterUniqueNumber;
			m_pObject->m_info.nObjectSrcIndex = pDlg->m_nObjectSrcIndex;
			m_pObject->m_info.bObjectTexIndex = pDlg->m_bObjectTexIndex;
			m_pObject->m_info.dwObjectType = pDlg->m_dwObjectType;
			m_pObject->m_info.bBodyCondition = pDlg->m_sObjectBodycondition;
			LONGLONG bBodyCon = 1;
			bBodyCon <<= m_pObject->m_info.bBodyCondition;
			m_pObject->m_bodyCondition = bBodyCon;
		}
		delete pDlg;
		pDlg = NULL;
	}
}
