
#include "SCamera.h"

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

float		SCamera::s_fFOV;
float		SCamera::s_fAspect;
float		SCamera::s_fNPlane;
float		SCamera::s_fFPlane;
D3DXVECTOR3	SCamera::s_vEye;
D3DXVECTOR3	SCamera::s_vLookat;
D3DXVECTOR3	SCamera::s_vUp;
D3DXVECTOR3	SCamera::s_vDir;
D3DXVECTOR3	SCamera::s_vCross;
D3DXMATRIX	SCamera::s_matProj;
D3DXMATRIX	SCamera::s_matView;
D3DXMATRIX	SCamera::s_matBillboard;

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

void SCamera::RotateXAxis(float angle)
{
	D3DXMATRIX matRot;
	D3DXMatrixRotationX(&matRot,angle);

	D3DXVECTOR3 vNewDst,vNewUp;
	D3DXVec3TransformCoord(&vNewDst,&s_vDir,&matRot);
	D3DXVec3TransformCoord(&vNewUp,&s_vUp,&matRot);
	vNewDst += s_vEye;

	SetViewParams(NULL,&vNewDst,&vNewUp);
}

void SCamera::RotateYAxis(float angle)
{
	D3DXMATRIX matRot;
	D3DXMatrixRotationY(&matRot,angle);

	D3DXVECTOR3 vNewDst,vNewUp;
	D3DXVec3TransformCoord(&vNewDst,&s_vDir,&matRot);
	D3DXVec3TransformCoord(&vNewUp,&s_vUp,&matRot);
	vNewDst += s_vEye;

	SetViewParams(NULL,&vNewDst,&vNewUp);
}

void SCamera::RotateZAxis(float angle)
{
	D3DXMATRIX matRot;
	D3DXMatrixRotationZ(&matRot,angle);

	D3DXVECTOR3 vNewDst,vNewUp;
	D3DXVec3TransformCoord(&vNewDst,&s_vDir,&matRot);
	D3DXVec3TransformCoord(&vNewUp,&s_vUp,&matRot);
	vNewDst += s_vEye;

	SetViewParams(NULL,&vNewDst,&vNewUp);
}

void SCamera::RotateCAxis(float angle)
{
	D3DXMATRIX matRot;
	D3DXMatrixRotationAxis(&matRot,&s_vCross,angle);

	D3DXVECTOR3 vNewDst,vNewUp;
	D3DXVec3TransformCoord(&vNewDst,&s_vDir,&matRot);
	D3DXVec3Cross(&vNewUp,&vNewDst,&s_vCross);
	D3DXVec3Normalize(&vNewUp,&vNewUp);
	vNewDst += s_vEye;

	SetViewParams(NULL,&vNewDst,&vNewUp);
}

void SCamera::RotateUAxis(float angle)
{
	D3DXMATRIX matRot;
	D3DXMatrixRotationAxis(&matRot,&s_vUp,angle);

	D3DXVECTOR3 vNewDst;
	D3DXVec3TransformCoord(&vNewDst,&s_vDir,&matRot);
	vNewDst += s_vEye;

	SetViewParams(NULL,&vNewDst,NULL);
}

void SCamera::RotateDAxis(float angle)
{
	D3DXMATRIX matRot;
	D3DXMatrixRotationAxis(&matRot,&s_vDir,angle);

	D3DXVECTOR3 vNewUp;
	D3DXVec3TransformCoord(&vNewUp,&s_vUp,&matRot);
	D3DXVec3Normalize(&vNewUp,&vNewUp);

	SetViewParams(NULL,NULL,&vNewUp);
}

void SCamera::TranslateXAxis(float distance)
{
	D3DXVECTOR3 vNewEye	= s_vEye;
	D3DXVECTOR3 vNewDst	= s_vLookat;

	vNewEye.x += distance;
	vNewDst.x += distance;

	SetViewParams(&vNewEye,&vNewDst,NULL);
}

void SCamera::TranslateYAxis(float distance)
{
	D3DXVECTOR3 vNewEye	= s_vEye;
	D3DXVECTOR3 vNewDst	= s_vLookat;

	vNewEye.y += distance;
	vNewDst.y += distance;

	SetViewParams(&vNewEye,&vNewDst,NULL);
}

void SCamera::TranslateZAxis(float distance)
{
	D3DXVECTOR3 vNewEye	= s_vEye;
	D3DXVECTOR3 vNewDst	= s_vLookat;

	vNewEye.z += distance;
	vNewDst.z += distance;

	SetViewParams(&vNewEye,&vNewDst,NULL);
}

void SCamera::TranslateCAxis(float distance)
{
	D3DXVECTOR3 vNewEye	= s_vEye;
	D3DXVECTOR3 vNewDst	= s_vLookat;

	D3DXVECTOR3 vMove;
	D3DXVec3Normalize(&vMove,&s_vCross);
	vMove	*= distance;
	vNewEye += vMove;
	vNewDst += vMove;

	SetViewParams(&vNewEye,&vNewDst,NULL);
}

void SCamera::TranslateUAxis(float distance)
{
	D3DXVECTOR3 vNewEye	= s_vEye;
	D3DXVECTOR3 vNewDst	= s_vLookat;

	D3DXVECTOR3 vMove;
	D3DXVec3Normalize(&vMove,&s_vUp);
	vMove	*= distance;
	vNewEye += vMove;
	vNewDst += vMove;

	SetViewParams(&vNewEye,&vNewDst,NULL);
}

void SCamera::TranslateDAxis(float distance)
{
	D3DXVECTOR3 vNewEye	= s_vEye;
	D3DXVECTOR3 vNewDst	= s_vLookat;

	D3DXVECTOR3 vMove;
	D3DXVec3Normalize(&vMove,&s_vDir);
	vMove	*= distance;
	vNewEye += vMove;
	vNewDst += vMove;

	SetViewParams(&vNewEye,&vNewDst,NULL);
}

void SCamera::SetProjParams(float fFOV,float fAspect,float fNPlane,float fFPlane)
{
	s_fFOV	  = fFOV;
	s_fAspect = fAspect;
	s_fNPlane = fNPlane;
	s_fFPlane = fFPlane;

	D3DXMatrixPerspectiveFovLH(&s_matProj,fFOV,fAspect,fNPlane,fFPlane);
}

void SCamera::SetViewParams(D3DXVECTOR3* pEye,D3DXVECTOR3* pLookat,D3DXVECTOR3* pUp)
{
	if(pEye)	s_vEye	  = *pEye;
	if(pLookat) s_vLookat = *pLookat;
	if(pUp)		s_vUp	  = *pUp;

	s_vDir = s_vLookat - s_vEye;
	D3DXVec3Normalize(&s_vDir,&s_vDir);
	D3DXVec3Cross(&s_vCross,&s_vUp,&s_vDir);
	D3DXVec3Cross(&s_vUp,&s_vDir,&s_vCross);
	D3DXVec3Normalize(&s_vCross,&s_vCross);
	D3DXVec3Normalize(&s_vUp,&s_vUp);

	D3DXMatrixLookAtLH(&s_matView,&s_vEye,&s_vLookat,&s_vUp);
	D3DXMatrixInverse(&s_matBillboard,NULL,&s_matView);
	s_matBillboard._41 = 0.0f;
	s_matBillboard._42 = 0.0f;
	s_matBillboard._43 = 0.0f;
}

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
