#if !defined(SCAMERA_H__C4F6F8E5_CA48_46AF_8E84_DD50489CBCF1__INCLUDED_)
#define SCAMERA_H__C4F6F8E5_CA48_46AF_8E84_DD50489CBCF1__INCLUDED_

#pragma once

#include <d3d8.h>
#include <d3dx8.h>

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

class SCamera
{
protected:
	static float		s_fFOV;
	static float		s_fAspect;
	static float		s_fNPlane;
	static float		s_fFPlane;
	static D3DXVECTOR3	s_vEye;
	static D3DXVECTOR3	s_vLookat;
	static D3DXVECTOR3	s_vUp;
	static D3DXVECTOR3	s_vDir;
	static D3DXVECTOR3	s_vCross;
	static D3DXMATRIX	s_matProj;
	static D3DXMATRIX	s_matView;
	static D3DXMATRIX	s_matBillboard;

public:
	static float		GetNPlane()			 { return s_fNPlane; }
	static float		GetFPlane()			 { return s_fFPlane; }
	static D3DXVECTOR3*	GetEye()			 { return &s_vEye; }
	static D3DXVECTOR3* GetLookat()			 { return &s_vLookat; }
	static D3DXVECTOR3* GetUp()				 { return &s_vUp; }
	static D3DXVECTOR3* GetDir()			 { return &s_vDir; }
	static D3DXVECTOR3* GetCross()			 { return &s_vCross; }
	static D3DXMATRIX*	GetProjMatrix()		 { return &s_matProj; }
	static D3DXMATRIX*	GetViewMatrix()		 { return &s_matView; }
	static D3DXMATRIX*	GetBillboardMatrix() { return &s_matBillboard; }

public:
	static void RotateXAxis(float angle);
	static void RotateYAxis(float angle);
	static void RotateZAxis(float angle);
	static void RotateCAxis(float angle);
	static void RotateUAxis(float angle);
	static void RotateDAxis(float angle);
	static void TranslateXAxis(float distance);
	static void TranslateYAxis(float distance);
	static void TranslateZAxis(float distance);
	static void TranslateCAxis(float distance);
	static void TranslateUAxis(float distance);
	static void TranslateDAxis(float distance);
	static void SetProjParams(float fFOV,float fAspect,float fNPlane,float fFPlane);
	static void SetViewParams(D3DXVECTOR3* pEye,D3DXVECTOR3* pLookat,D3DXVECTOR3* pUp);
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

#endif
