

#include "stdafx.h"
#include "texture.h"
//#include "GameDatalast.h"
//#include "Background.h"

extern LPDIRECT3DDEVICE8 g_pD3dDev;


//********************************************************************
// 
// The Texture Maganger class implementation
//

//--------------------------------------------------------------------
//
// Constructor
//
TextureMngr::TextureMngr()
{
	strcpy(m_szTexturePath,".\\textures\\");
}

//--------------------------------------------------------------------
//
// Reset all wTris members
//
void TextureMngr::Reset()
{
	for(WORD i=0;i<texs.size();i++) 
		texs[i].wTris=0;		
}

//--------------------------------------------------------------------
//
// AddTexture creates texture and index buffer
//
WORD TextureMngr::AddTexture(char *szName,WORD wni)
{
	//new entry for the container
	WGTexture tx;

	//initialiy blank
	tx.pIB=NULL;
	tx.pTex=NULL;
	tx.wni=wni;

	//check for existing...
	WORD wf;
	if ((wf=FindTexture(szName))!=0xffff) return wf;

	//construct the name
	strcpy(tx.name,szName);
	char szPath[MAX_PATH];
//	strcpy(szPath,m_szTexturePath);
	memset(szPath, 0x00, MAX_PATH*sizeof(char));
	strcpy(szPath,szName);

	//try to create the texture
	HRESULT hr=D3DXCreateTextureFromFileA( g_pD3dDev, szPath,&(tx.pTex) );
/*	HRESULT hr=D3DXERR_INVALIDDATA;
	DataHeader*  pHeader = g_pGround->m_pTextureData->Find( szPath );
	if ( pHeader )
	{
		hr = D3DXCreateTextureFromFileInMemory( g_pD3dDev
			, pHeader->m_pData
			, pHeader->m_DataSize
			, &(tx.pTex) ) ;
	}
*/
	//these ifs here are quite redundant but are for tracing purpuses
	if (hr==D3DERR_NOTAVAILABLE) return 0xffff;
	if (hr==D3DERR_OUTOFVIDEOMEMORY) return 0xffff;
	if (hr==D3DERR_INVALIDCALL) return 0xffff;
	if (hr==D3DXERR_INVALIDDATA) return 0xffff;
	
	if (hr!=S_OK) return 0xffff;
	
	//create the index buffer
	g_pD3dDev->CreateIndexBuffer(wni*2,D3DUSAGE_DYNAMIC | D3DUSAGE_WRITEONLY,D3DFMT_INDEX16,
		D3DPOOL_DEFAULT,&(tx.pIB));

	//put the entry in the collection
	tx.wTris=wni/3;
	texs.push_back(tx);

	//return the index in the vector collection
	return texs.size()-1;
}



//--------------------------------------------------------------------
//
// FindTexture returns the index in the collection entry
//
WORD TextureMngr::FindTexture(char *szName)
{
	//quite bad search method...
	for(WORD i=0;i<texs.size();i++) 
		if (strcmp(texs[i].name,szName)==0) return i;
		return 0xffff;
}


//--------------------------------------------------------------------
//
// Sums the triangle count of all entries to caluclate overall triangle 
// count
//
WORD TextureMngr::GetTriangleCount() 
{
	WORD res=0;
	for(WORD i=0;i<texs.size();i++) 
		res+=texs[i].wTris;
	return res;
}

//--------------------------------------------------------------------
//
// Read the indices from a custom raw file
//
bool TextureMngr::LoadIndices(char *szName)
{
	//header
	WGSave wh;

	//open the file
	FILE *fp=fopen(szName,"rb");
	if (fp==NULL) return false;

	//clear the collection
	texs.clear();

	//for all chunks in the raw file
	for(;;) {
		//read the header
		if (fread(&wh,1,sizeof(wh),fp)!=sizeof(wh)) break;

		//add the texture and create the index buffer
		WORD i=AddTexture(wh.name,wh.size);

		//if creatin failed continue with the next chunk
		if (i==0xffff) return false;

		//read the indices
		BYTE *pb=(BYTE *)malloc(wh.size*2);
		fread(pb,1,wh.size*2,fp);
		
		//lock the index buffer and move in the data
		BYTE *pib;
		texs[i].pIB->Lock(0,wh.size*2,(BYTE**)&pib,0);
		memmove(pib,pb,wh.size*2);
		texs[i].pIB->Unlock();

		//free the memory allocated fro swap
		free(pb);
		}
	//close file
	fclose(fp);
	return true;
}

//--------------------------------------------------------------------
//
// InitDevices just initializes the D3Device...member
//
void TextureMngr::InitDevices(IDirect3DDevice8* dev)
{
	FreeDevices();
//	p3DDev=dev;
}

//--------------------------------------------------------------------
//
// Free any resources allocated from the device
//
void TextureMngr::FreeDevices()
{
	for(WORD i=0;i<texs.size();i++) {
		if (texs[i].pTex) {texs[i].pTex->Release();texs[i].pTex=NULL;}
		if (texs[i].pIB) {texs[i].pIB->Release();texs[i].pIB=NULL;}
	}
		
}

//--------------------------------------------------------------------
//
// Recreate all texture index buffer... in the collection
//
void TextureMngr::Recreate()
{
	char szPath[256];
	for(WORD i=0;i<texs.size();i++) if (texs[i].pTex==NULL)
		{
		//construct path for the texture
		strcpy(szPath,m_szTexturePath);
		strcat(szPath,texs[i].name);

		//load the texutre
		HRESULT hr=D3DXCreateTextureFromFileA( g_pD3dDev, szPath,&(texs[i].pTex) );
	
		//please not that
		if (hr!=S_OK) continue;
		
		//create the index buffer
  	    g_pD3dDev->CreateIndexBuffer(texs[i].wni*2,D3DUSAGE_DYNAMIC | D3DUSAGE_WRITEONLY,D3DFMT_INDEX16,
						D3DPOOL_DEFAULT,&(texs[i].pIB));

		texs[i].wTris=0;
	}
}
