// CharacterInfo.h: interface for the CCharacterInfo class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHARACTERINFO_H__902387E2_AA6D_4345_8FCB_B8CC5C2D7A70__INCLUDED_)
#define AFX_CHARACTERINFO_H__902387E2_AA6D_4345_8FCB_B8CC5C2D7A70__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "effect.h"


struct CharacterData
{
	char	m_strCharacterFileName[20];
	int		m_nBodyConditionNumber;

};

struct BodyConditionData
{
	LONGLONG	m_nBodyCondition;
	char	m_strBodyConditionName[20];
	BOOL	m_bCharacterAlphaBlending;
	int		m_nCharacterTextureRenderState;
	int		m_nCharacterDestBlend;
	int		m_nCharacterSrcBlend;
	int		m_nEffectNumber;
	float	m_fStartAnimationTime;
	float	m_fEndAnimationTime;
	BOOL	m_bCharacterRendering;
	//add
	BOOL	m_bNotAnimationLooping;
	float	m_fAnimationVel;
	char	m_strSoundFileName[20];
};

struct EffectData
{
	int		m_nEffectType;
	char	m_strEffectName[20];
	D3DXVECTOR3 m_vPos;
	D3DXVECTOR3	m_vTarget;
	D3DXVECTOR3	m_vUp;
	float	m_fStartTime;
	BOOL	m_bUseBillboard;
	float	m_fBillboardAngle;
	float	m_fBillboardRotateAngle;
	float	m_fBillboardRotatePerSec;
	float	m_fRandomUpLargeAngle;
	float	m_fRandomUpSmallAngle;
	BOOL	m_bUseCharacterMatrix;
};

class CBodyConditionInfo;
class CCharacterInfo;
class CEffectInfo : public EffectData
{
public:
	CEffectInfo();
	~CEffectInfo();

	void InitData();
	BOOL Tick(float fElapsedTime);
	void Render();
	HRESULT InitDeviceObjects();
	HRESULT RestoreDeviceObjects();
	HRESULT InvalidateDeviceObjects();
	HRESULT DeleteDeviceObjects();
	void ParticleStop();
	void SetTexture(char* strTexture);// by dhkwon, 030917

public:
	char* m_pEffect;
	BOOL m_bRestored;
	float m_fCurrentTime;
	CBodyConditionInfo* m_pParent;
};

class CBodyConditionInfo : public BodyConditionData
{
public:
	CBodyConditionInfo();
	~CBodyConditionInfo();

	void InitData();
	BOOL Tick(float fElapsedTime);
	void Render();
	HRESULT InitDeviceObjects();
	HRESULT RestoreDeviceObjects();
	HRESULT InvalidateDeviceObjects();
	HRESULT DeleteDeviceObjects();

	BOOL IsUsing();
	BOOL EffectStop();

	vector<CEffectInfo*> m_vecEffect;
	CCharacterInfo* m_pParent;
	float			m_fCurrentAnimationTime;
	D3DXMATRIX		m_mMatrix;
};

class CCharacterInfo : public CharacterData
{
public:
	CCharacterInfo();
	~CCharacterInfo();

	void InitData();
	void ChangeBodyCondition(LONGLONG hyBody);
	void SetBodyCondition(LONGLONG hyBody);
	BOOL IsUpkeepBodyCondition(LONGLONG hyBody);
	BOOL Tick(float fElapsedTime);
	void Render();
	HRESULT InitDeviceObjects();
	HRESULT RestoreDeviceObjects();
	HRESULT InvalidateDeviceObjects();
	HRESULT DeleteDeviceObjects();
//	void Save(char* strName);
	BOOL Load(char* strName);

	BOOL IsUsing(LONGLONG hyBody);// single body condition
	BOOL IsUsing();
	void SetSingleBodyConditionMatrix(LONGLONG hyBody, D3DXMATRIX m);
	void SetAllBodyConditionMatrix(D3DXMATRIX m);

	map<LONGLONG,CBodyConditionInfo*> m_mapBodyCondition;
	LONGLONG		m_nCurrentBodyCondition;
	D3DXMATRIX		m_mMatrix;
	D3DXVECTOR3		m_vPos;
	vector<LONGLONG> m_vecCurrentBodyCondition;
};

#endif // !defined(AFX_CHARACTERINFO_H__902387E2_AA6D_4345_8FCB_B8CC5C2D7A70__INCLUDED_)
