// EffectRender.h: interface for the CEffectRender class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_EFFECTRENDER_H__7B0E8CE2_67C8_4A53_97BE_F7589D2FFB62__INCLUDED_)
#define AFX_EFFECTRENDER_H__7B0E8CE2_67C8_4A53_97BE_F7589D2FFB62__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AtumNode.h"
#include "GameDataLast.h"
#include "effect.h"
#include "SpriteAniData.h"
#include "ParticleSystem.h"
#include "ObjectAniData.h"
#include "SkinnedMesh.h"

#define TEX_EFFECT_NUM 100
#define OBJ_EFFECT_NUM 300
class CEffectRender : public CAtumNode  
{
public:
	CEffectRender();
	virtual ~CEffectRender();

	void Render();
//	void RenderCloud();
	void RenderCharacterInfo(CCharacterInfo* pChar);
	void ObjectAniRender(CObjectAni* pEffect);
	void SpriteAniRender(CSpriteAni* pEffect);
	void ParticleSystemRender(CParticleSystem* pEffect);
	int ParticleRender(CParticleSystem* pParticleSystem, CParticle* p,D3DXVECTOR3 vAxis,int nOldTextureIndex);
//	void ParticleRender(CParticleSystem* pEffect);
	void ObjectParticleRender(CObjectAni* pEffect, CParticle* pParticle);
	void RenderZEnable();
	HRESULT InitDeviceObjects();
	HRESULT RestoreDeviceObjects();
	HRESULT InvalidateDeviceObjects();
	HRESULT DeleteDeviceObjects();
	void Tick(float fElapsedTime);

	int GetEmptyTextureIndex();
	int LoadTexture(char* strName);
	int GetEmptyObjectIndex();
	int LoadObject(char* strName);
	DataHeader* FindEffectInfo(char* strName);
	DataHeader* FindObjectInfo(char* strName);
	DWORD LoadEffect(char* strName, DWORD dwEffectType, char* pEffect);
	// by dhkwon, 030923
	BOOL AddFontTexture(char* strText, LPDIRECT3DTEXTURE8 pTexture );
	BOOL DeleteFontTexture(char* strText);

	LPDIRECT3DVERTEXBUFFER8	m_pVB1;
	LPDIRECT3DVERTEXBUFFER8 m_pVB2[2];			
	LPDIRECT3DVERTEXBUFFER8 m_pVB4[4];			
	LPDIRECT3DVERTEXBUFFER8 m_pVB8[8];			
	LPDIRECT3DVERTEXBUFFER8 m_pVB16[16];

	float					m_fTextureCheckTime;
	CGameData*				m_pTexEffectData;
	CGameData*				m_pEffectData;
	CGameData*				m_pObjectData;
	LPDIRECT3DTEXTURE8		m_pTexture[TEX_EFFECT_NUM];
	int						m_nTextureRenderCount[TEX_EFFECT_NUM];
	//CGameData* pObjEffectData[];
	CSkinnedMesh*			m_pObjEffectMesh[OBJ_EFFECT_NUM];
//	int						m_nObjRenderCount[OBJ_EFFECT_NUM];
	map<string, int>		m_mapTexNameToIndex;
	map<string, int>		m_mapObjNameToIndex;
	vector<Effect*>			m_vecZEnableEffect;

	// by dhkwon, 030923
	map<string, LPDIRECT3DTEXTURE8> m_mapTextToTexture;
	map<string, int> m_mapTextRenderCount;


	BOOL					m_bZBufferTemp;// by JHLEE
};

#endif // !defined(AFX_EFFECTRENDER_H__7B0E8CE2_67C8_4A53_97BE_F7589D2FFB62__INCLUDED_)
