// ObjectAniData.cpp: implementation of the CObjectAniData class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "effect.h"
#include "ObjectAniData.h"
//#include "AtumApplication.h"

//extern CAtumApplication				*g_pD3dApp;
#include "MainFrm.h"
#include "MapEditor.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CObjectAni::CObjectAni()
{
	memset((void*)this,0,sizeof(CObjectAni));
	m_pParent = NULL;
}

CObjectAni::~CObjectAni()
{

}

// by dhkwon, 030917
void CObjectAni::SetTexture(char* strTexture)
{
	if(strTexture)
		strcpy(m_strTextureFile, strTexture);
	else
		m_strTextureFile[0] = NULL;
}

BOOL CObjectAni::Tick(float fElapsedTime)
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	m_fCurrentTick -= fElapsedTime;
	if(m_fCurrentTick < 0)
	{
		switch(m_nObjectAniType)
		{
		case 0:// Object animation
			{
				m_fCurrentObjectAniTime += m_fTick*m_fObjectAniVel;
				 if(m_fStartTime != 0 || m_fEndTime != 0)
				 {
					 if(m_fCurrentObjectAniTime < m_fStartTime)
					 {
						 m_fCurrentObjectAniTime = m_fStartTime;
					 } else if( m_fCurrentObjectAniTime > m_fEndTime)
					 {
						 if(m_bObjectAnimationLoop)
						 {
							 m_fCurrentObjectAniTime = m_fEndTime;
						 } else
						 {
							m_fCurrentObjectAniTime = m_fStartTime;
						 }
					 }
				 }
			}
			break;
		case 1:// Texture animation
			{
				m_fCurrentTextureAniTime += m_fTick;
				if(m_fCurrentTextureAniTime>m_fTextureAniVel)
				{
					m_nCurrentTextureType++;
					if(m_nCurrentTextureType>=m_nTotalTextureNumber)
					{
						if(m_bAnimationLoop)
							m_nCurrentTextureType = 0;
						else
							m_nCurrentTextureType = m_nTotalTextureNumber-1;
					}
					m_fCurrentTextureAniTime = 0;
				}
			}
			break;
		case 2:// Object-Texture animation
			{
				m_fCurrentObjectAniTime += m_fTick*m_fObjectAniVel;
				 if(m_fStartTime != 0 || m_fEndTime != 0)
				 {
					 if(m_fCurrentObjectAniTime < m_fStartTime)
					 {
						 m_fCurrentObjectAniTime = m_fStartTime;
					 } else if( m_fCurrentObjectAniTime > m_fEndTime)
					 {
						 if(m_bObjectAnimationLoop)
						 {
							 m_fCurrentObjectAniTime = m_fEndTime;
						 } else
						 {
							m_fCurrentObjectAniTime = m_fStartTime;
						 }
					 }
				 }
				m_fCurrentTextureAniTime += m_fTick;
				if(m_fCurrentTextureAniTime>m_fTextureAniVel)
				{
					m_nCurrentTextureType++;
					if(m_nCurrentTextureType>=m_nTotalTextureNumber)
					{
						if(m_bAnimationLoop)
							m_nCurrentTextureType = 0;
						else
							m_nCurrentTextureType = m_nTotalTextureNumber-1;
					}
					m_fCurrentTextureAniTime = 0;
				}
			}
			break;
		}
		// color
		m_fColorChangeStartTime -= m_fTick;
		if(m_fColorChangeStartTime<=0 && ((DWORD)m_cColor) != 0 && 
			(m_cColorStep.r!=0 || m_cColorStep.g!=0 || m_cColorStep.b!=0 || m_cColorStep.a!=0))
		{
			m_cColor += m_cColorStep;
			if(m_cColor.r < 0 ) m_cColor.r = 0;
			if(m_cColor.g < 0 ) m_cColor.g = 0;
			if(m_cColor.b < 0 ) m_cColor.b = 0;
			if(m_cColor.a < 0 ) m_cColor.a = 0;
			if(m_cColor.r > 1 ) m_cColor.r = 1;
			if(m_cColor.g > 1 ) m_cColor.g = 1;
			if(m_cColor.b > 1 ) m_cColor.b = 1;
			if(m_cColor.a > 1 ) m_cColor.a = 1;
			if((DWORD)m_cColor == 0 )
			{
				if(m_bColorLoop)
				{
					m_cColorStep *= -1;
					m_cColor += m_cColorStep;
				}
				else
				{
					return FALSE;
				}
			}
			else if( (DWORD)m_cColor == 0xFFFFFFFF )
			{
				if(m_bColorLoop)
				{
					m_cColorStep *= -1;
					m_cColor += m_cColorStep;
				}
			}
		}
		if(m_pParent && m_pParent->m_bUseBillboard && m_pParent->m_fBillboardRotatePerSec>0)
		{
			m_fCurrentBillboardRotateTime += m_fTick;
			if(m_fCurrentBillboardRotateTime > m_pParent->m_fBillboardRotatePerSec)
			{
				m_fCurrentBillboardRotateAngle += m_pParent->m_fBillboardRotateAngle;
				m_fCurrentBillboardRotateTime = 0;
			}
		}
		m_fCurrentTick = m_fTick;
	}
	if(m_bZbufferEnable)
	{
		D3DXVECTOR3 vPos = D3DXVECTOR3(m_pParent->m_vPos.x,	m_pParent->m_vPos.y,m_pParent->m_vPos.z);
		D3DXVec3TransformCoord( &vPos, &vPos, &m_pParent->m_pParent->m_mMatrix );
//		fDistance = D3DXVec3Length(&(g_pD3dApp->m_pCamera->GetEyePt()-vPos));
		fDistance = D3DXVec3Length(&(pView->m_pCamera->GetEyePt()-vPos));
	}
 
	return TRUE;
}

void CObjectAni::Render()
{
}

HRESULT CObjectAni::InitDeviceObjects()
{
	fDistance = 0;
	m_nCurrentTextureType = 0;
	m_nTotalTextureNumber = 0;
	m_fCurrentTick = m_fTick;
	m_fCurrentTextureAniTime = 0;
	m_fCurrentObjectAniTime = m_fStartTime;
	m_fCurrentBillboardRotateAngle = 0;
	m_fCurrentBillboardRotateTime = 0;
	if(m_pParent && //!m_pParent->m_bUseBillboard && 
		(m_pParent->m_fRandomUpLargeAngle != 0 || m_pParent->m_fRandomUpSmallAngle != 0))
	{
		m_fCurrentRandomUpAngleX = Random(m_pParent->m_fRandomUpLargeAngle, m_pParent->m_fRandomUpSmallAngle);
		m_fCurrentRandomUpAngleZ = Random(m_pParent->m_fRandomUpLargeAngle, m_pParent->m_fRandomUpSmallAngle);
	}
	return S_OK;
}

HRESULT CObjectAni::RestoreDeviceObjects()
{
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	int index = -1;
	if(strlen(m_strObjectFile)>0)
	{
		index = pView->m_pEffectRender->LoadObject(m_strObjectFile);
	}
	if(index>=0)
	{
		m_nTotalTextureNumber = pView->m_pEffectRender->m_pObjEffectMesh[index]->m_bTotalTextureNum;
	}
	m_bRestored = TRUE;
	return S_OK;
}

HRESULT CObjectAni::InvalidateDeviceObjects()
{
	return S_OK;
}

HRESULT CObjectAni::DeleteDeviceObjects()
{
	m_bRestored = FALSE;
	return S_OK;
}
