// WorkspaceDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mapeditor.h"
#include "WorkspaceDlg.h"
#include "ProjectDetailDlg.h"
#include <direct.h>

#include "DbgOut_C.h"
#include "MainFrm.h"
#include "MapEditor.h"
#include "MapEditorDoc.h"
#include "MapEditorView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWorkspaceDlg dialog


CWorkspaceDlg::CWorkspaceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWorkspaceDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWorkspaceDlg)
	m_editNPCIP = _T("");
	m_editFieldIP = _T("");
	m_editFieldPort = 0;
	m_editNPCPort = 0;
	m_editXSize = 0;
	m_editYSize = 0;
	m_staticName = _T("");
	m_editFieldPortUDP = 0;
	m_editNPCPortUDP = 0;
	m_editTileSetIndex = 0;
	m_editHeightMax = 0.0f;
	m_editHeightMin = 0.0f;
	m_editWaterHeight = 0.0f;
	m_bSelectIndex = 0;
	//}}AFX_DATA_INIT
}


void CWorkspaceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWorkspaceDlg)
	DDX_Control(pDX, IDC_LIST, m_ctrlList);
	DDX_Text(pDX, IDC_EDIT_NPCIP, m_editNPCIP);
	DDX_Text(pDX, IDC_EDIT_FIELDIP, m_editFieldIP);
	DDX_Text(pDX, IDC_EDIT_FIELDPORT, m_editFieldPort);
	DDX_Text(pDX, IDC_EDIT_NPCPORT, m_editNPCPort);
	DDX_Text(pDX, IDC_EDIT_XSIZE, m_editXSize);
	DDX_Text(pDX, IDC_EDIT_YSIZE, m_editYSize);
	DDX_Text(pDX, IDC_STATIC_NAME, m_staticName);
	DDX_Text(pDX, IDC_EDIT_FIELDPORT2, m_editFieldPortUDP);
	DDX_Text(pDX, IDC_EDIT_NPCPORT2, m_editNPCPortUDP);
	DDX_Text(pDX, IDC_EDIT_TILESETINDEX, m_editTileSetIndex);
	DDX_Text(pDX, IDC_EDIT_WHEIGHTMAX, m_editHeightMax);
	DDX_Text(pDX, IDC_EDIT_WHEIGHTMIN, m_editHeightMin);
	DDX_Text(pDX, IDC_EDIT_WWATERHEIGHT, m_editWaterHeight);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWorkspaceDlg, CDialog)
	//{{AFX_MSG_MAP(CWorkspaceDlg)
	ON_LBN_SELCHANGE(IDC_LIST, OnSelchangeList)
	ON_LBN_DBLCLK(IDC_LIST, OnDblclkList)
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	ON_BN_CLICKED(IDC_BUTTON_DELETE_PROJECT, OnButtonDeleteProject)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWorkspaceDlg message handlers

void CWorkspaceDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CDialog::OnCancel();
}

void CWorkspaceDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CWorkspaceDlg::UpdateWorkspace()
{
	int n = m_ctrlList.GetCount();
	for (int i=0;i < n;i++)
	{
	   m_ctrlList.DeleteString( n-i-1 );
	}
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	if(pView && pView->m_pWorkspace)
	{
		m_staticName = pView->m_pWorkspace->workspaceName;

		list<PROJECTINFO>::iterator it = pView->m_listProjectInfo.begin();
		
		for(int i=0;i<pView->m_pWorkspace->numberOfProject;i++)
		{
			m_ctrlList.AddString((*it).m_strProjectName);
			it++;
		}
	}
	UpdateData(FALSE);

}

void CWorkspaceDlg::OnSelchangeList() 
{
	// TODO: Add your control notification handler code here
	CString str;
	m_bSelectIndex = m_ctrlList.GetCurSel();
	m_ctrlList.GetText( m_bSelectIndex, str );

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	if(pView && pView->m_pWorkspace)
	{
		m_staticName = pView->m_pWorkspace->workspaceName;

		list<PROJECTINFO>::iterator it = pView->m_listProjectInfo.begin();
		
		for(int i=0;i<pView->m_pWorkspace->numberOfProject;i++)
		{
			if(strcmp((LPCTSTR)str, (*it).m_strProjectName) == 0 )
			{
				wsprintf(m_strProjectMapName,(*it).m_strProjectName);
				m_editTileSetIndex = (*it).m_useTileSetIndex;
				m_editFieldIP = (*it).m_strFieldIP;
				m_editFieldPort = (*it).m_sFieldPort;
				m_editFieldPortUDP = (*it).m_sFieldPortUDP;
				m_editNPCIP = (*it).m_strNPCIP;
				m_editNPCPort = (*it).m_sNPCPort;
				m_editNPCPortUDP = (*it).m_sNPCPortUDP;
				m_editXSize = (*it).m_sXSize;
				m_editYSize = (*it).m_sYSize;
				m_editHeightMax = (*it).m_fHeightMax;
				m_editHeightMin = (*it).m_fHeightMin;
				m_editWaterHeight = (*it).m_fWaterHeight;

				DBGOUT("[String] Map number (%s)\n", str);
			}
			it++;
		}
	}
	UpdateData(FALSE);
}

void CWorkspaceDlg::OnDblclkList() 
{
	// TODO: Add your control notification handler code here
	CString str;
	int nIndex = m_ctrlList.GetCurSel();
	m_ctrlList.GetText( nIndex, str );

	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();

	pView->OnOpenProjectSub(str);
}

void CWorkspaceDlg::OnButtonDeleteProject() 
{
	if(AfxMessageBox("Are you sure?", MB_OKCANCEL ) == IDOK )
	{
		CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
		CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
		CString str;
		m_ctrlList.GetText( m_bSelectIndex, str );
		list<PROJECTINFO>::iterator it = pView->m_listProjectInfo.begin();
		while(it!=pView->m_listProjectInfo.end())
		{
			if(strcmp((*it).m_strProjectName,(LPCTSTR)str) == 0 )
			{
				pView->m_listProjectInfo.erase(it);
				m_ctrlList.DeleteString( m_bSelectIndex );
				AfxMessageBox("Exit the program and delete the directory.", MB_OK );
				return;
			}
			it++;
		}
	}
}

void CWorkspaceDlg::OnButtonUpdate() 
{
	// TODO: Add your control notification handler code here
	CMainFrame* pFrame = (CMainFrame*)AfxGetMainWnd();
	CMapEditorView* pView = (CMapEditorView*)pFrame->GetActiveView();
	CProjectDetailDlg	dlg;
	dlg.m_editMapName.Format("%s",m_strProjectMapName);
	dlg.m_editTileSetIndex = m_editTileSetIndex;
	dlg.m_editFieldIP = m_editFieldIP;
	dlg.m_editFieldPort = m_editFieldPort;
	dlg.m_editFieldPortUDP = m_editFieldPortUDP;
	dlg.m_editNPCIP = m_editNPCIP;
	dlg.m_editNPCPort = m_editNPCPort;
	dlg.m_editNPCPortUDP = m_editNPCPortUDP;
	dlg.m_editXSize = m_editXSize;
	dlg.m_editYSize = m_editYSize;
	dlg.m_editHeightMax = m_editHeightMax;
	dlg.m_editHeightMin = m_editHeightMin;
	dlg.m_editWaterHeight = m_editWaterHeight;
	UpdateData(FALSE);
	if(dlg.DoModal() == IDOK)
	{
		list<PROJECTINFO>::iterator it = pView->m_listProjectInfo.begin();
		BYTE bCheck = m_bSelectIndex;
		while(it!=pView->m_listProjectInfo.end())
		{
			if(strcmp((*it).m_strProjectName,m_strProjectMapName) == 0 )
			{
				if( !pView->m_pBackground && 
					strcmp((*it).m_strProjectName, (LPCTSTR)dlg.m_editMapName))
				{
					AfxMessageBox("Map does not load, if you change your name, the data is stored.", MB_OK );
					return;
				}
				if( pView->m_pBackground && 
					strcmp((*it).m_strProjectName, pView->m_pBackground->m_projectInfo.m_strProjectName))
				{
					AfxMessageBox("To change the name of the project, the project must be loaded.", MB_OK );
					return;
				}
				if(pView->m_pBackground)
				{
					strcpy(pView->m_pBackground->m_projectInfo.m_strProjectName, (LPCTSTR)dlg.m_editMapName );
					wsprintf(pView->m_pBackground->m_projectInfo.m_strFieldIP,"%s",dlg.m_editFieldIP);
					pView->m_pBackground->m_projectInfo.m_sFieldPort = dlg.m_editFieldPort;
					pView->m_pBackground->m_projectInfo.m_sFieldPortUDP = dlg.m_editFieldPortUDP;
					wsprintf(pView->m_pBackground->m_projectInfo.m_strNPCIP,"%s",dlg.m_editNPCIP);
					pView->m_pBackground->m_projectInfo.m_sNPCPort = dlg.m_editNPCPort;
					pView->m_pBackground->m_projectInfo.m_sNPCPortUDP = dlg.m_editNPCPortUDP;
					pView->m_pBackground->m_projectInfo.m_fHeightMax = dlg.m_editHeightMax;
					pView->m_pBackground->m_projectInfo.m_fHeightMin = dlg.m_editHeightMin;
					pView->m_pBackground->m_projectInfo.m_fWaterHeight = dlg.m_editWaterHeight;
				}
				if(strcmp((*it).m_strProjectName, (LPCTSTR)dlg.m_editMapName))
				{
					char str[256];
					_chdir(pView->m_strCurrentDir);
					wsprintf(str,".\\%s\\%s",pView->m_pWorkspace->workspaceName,(LPCTSTR)dlg.m_editMapName);
					_mkdir(str);
					AfxMessageBox("Exit the program and delete the previous directory.", MB_OK );
				}
				strcpy((*it).m_strProjectName, (LPCTSTR)dlg.m_editMapName );
				wsprintf((*it).m_strFieldIP,"%s",dlg.m_editFieldIP);
				(*it).m_sFieldPort = dlg.m_editFieldPort;
				(*it).m_sFieldPortUDP = dlg.m_editFieldPortUDP;
				wsprintf((*it).m_strNPCIP,"%s",dlg.m_editNPCIP);
				(*it).m_sNPCPort = dlg.m_editNPCPort;
				(*it).m_sNPCPortUDP = dlg.m_editNPCPortUDP;
				(*it).m_fHeightMax = dlg.m_editHeightMax;
				(*it).m_fHeightMin = dlg.m_editHeightMin;
				(*it).m_fWaterHeight = dlg.m_editWaterHeight;

				strcpy(m_strProjectMapName, (*it).m_strProjectName);
				wsprintf(m_strProjectMapName,(*it).m_strProjectName);
				m_editTileSetIndex = (*it).m_useTileSetIndex;
				m_editFieldIP = (*it).m_strFieldIP;
				m_editFieldPort = (*it).m_sFieldPort;
				m_editFieldPortUDP = (*it).m_sFieldPortUDP;
				m_editNPCIP = (*it).m_strNPCIP;
				m_editNPCPort = (*it).m_sNPCPort;
				m_editNPCPortUDP = (*it).m_sNPCPortUDP;
				m_editXSize = (*it).m_sXSize;
				m_editYSize = (*it).m_sYSize;
				m_editHeightMax = (*it).m_fHeightMax;
				m_editHeightMin = (*it).m_fHeightMin;
				m_editWaterHeight = (*it).m_fWaterHeight;
				UpdateData(FALSE);
			}
			it++;
		}
	}
}
